--
-- PostgreSQL database dump
--

\restrict devUv2Sd7yonOfqeLM8C20vvbE4K9ru0OnF4FyTTu2djkje06ejPeaURM1Z2itg

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.0 (Debian 18.0-1.pgdg12+3)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: vector; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS vector WITH SCHEMA public;


--
-- Name: EXTENSION vector; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION vector IS 'vector data type and ivfflat and hnsw access methods';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: Products; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public."Products" (
    stock_package_destination_id integer NOT NULL,
    stock_move_line_id integer NOT NULL
);


ALTER TABLE public."Products" OWNER TO runbot;

--
-- Name: TABLE "Products"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public."Products" IS 'RELATION BETWEEN stock_package_destination AND stock_move_line';


--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: ai_agent; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subtitle character varying,
    response_style character varying NOT NULL,
    llm_model character varying NOT NULL,
    system_prompt text,
    active boolean,
    restrict_to_sources boolean,
    is_system_agent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent OWNER TO runbot;

--
-- Name: TABLE ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent IS 'AI Agent';


--
-- Name: COLUMN ai_agent.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.partner_id IS 'Partner';


--
-- Name: COLUMN ai_agent.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent.subtitle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.subtitle IS 'Description';


--
-- Name: COLUMN ai_agent.response_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.response_style IS 'Response Style';


--
-- Name: COLUMN ai_agent.llm_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.llm_model IS 'LLM Model';


--
-- Name: COLUMN ai_agent.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.system_prompt IS 'System Prompt';


--
-- Name: COLUMN ai_agent.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.active IS 'Active';


--
-- Name: COLUMN ai_agent.restrict_to_sources; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.restrict_to_sources IS 'Restrict to Sources';


--
-- Name: COLUMN ai_agent.is_system_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.is_system_agent IS 'System Agent';


--
-- Name: COLUMN ai_agent.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_date IS 'Last Updated on';


--
-- Name: ai_agent_ai_topic_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_ai_topic_rel (
    ai_agent_id integer NOT NULL,
    ai_topic_id integer NOT NULL
);


ALTER TABLE public.ai_agent_ai_topic_rel OWNER TO runbot;

--
-- Name: TABLE ai_agent_ai_topic_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_ai_topic_rel IS 'RELATION BETWEEN ai_agent AND ai_topic';


--
-- Name: ai_agent_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_id_seq OWNER TO runbot;

--
-- Name: ai_agent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_id_seq OWNED BY public.ai_agent.id;


--
-- Name: ai_agent_source; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_source (
    id integer NOT NULL,
    agent_id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    type character varying NOT NULL,
    status character varying,
    url character varying,
    error_details text,
    is_active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent_source OWNER TO runbot;

--
-- Name: TABLE ai_agent_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_source IS 'AI Agent Source';


--
-- Name: COLUMN ai_agent_source.agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.agent_id IS 'Agent';


--
-- Name: COLUMN ai_agent_source.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_agent_source.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent_source.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent_source.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.name IS 'Name';


--
-- Name: COLUMN ai_agent_source.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.type IS 'Type';


--
-- Name: COLUMN ai_agent_source.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.status IS 'Status';


--
-- Name: COLUMN ai_agent_source.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.url IS 'URL';


--
-- Name: COLUMN ai_agent_source.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.error_details IS 'Error Details';


--
-- Name: COLUMN ai_agent_source.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.is_active IS 'Active';


--
-- Name: COLUMN ai_agent_source.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent_source.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_date IS 'Last Updated on';


--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_source_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_source_id_seq OWNER TO runbot;

--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_source_id_seq OWNED BY public.ai_agent_source.id;


--
-- Name: ai_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer (
    id integer NOT NULL,
    ai_agent integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    interface_key character varying NOT NULL,
    default_prompt text,
    is_system_default boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_composer OWNER TO runbot;

--
-- Name: TABLE ai_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer IS 'AI model configurations (system prompts) for text drafting.';


--
-- Name: COLUMN ai_composer.ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.ai_agent IS 'Agent';


--
-- Name: COLUMN ai_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_uid IS 'Created by';


--
-- Name: COLUMN ai_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_composer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.name IS 'Rule Name';


--
-- Name: COLUMN ai_composer.interface_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.interface_key IS 'Action';


--
-- Name: COLUMN ai_composer.default_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.default_prompt IS 'Instructions';


--
-- Name: COLUMN ai_composer.is_system_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.is_system_default IS 'Is the rule a system default or user created';


--
-- Name: COLUMN ai_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_date IS 'Created on';


--
-- Name: COLUMN ai_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_date IS 'Last Updated on';


--
-- Name: ai_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_composer_id_seq OWNER TO runbot;

--
-- Name: ai_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_composer_id_seq OWNED BY public.ai_composer.id;


--
-- Name: ai_composer_ir_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer_ir_model_rel (
    ai_composer_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ai_composer_ir_model_rel OWNER TO runbot;

--
-- Name: TABLE ai_composer_ir_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer_ir_model_rel IS 'RELATION BETWEEN ai_composer AND ir_model';


--
-- Name: ai_embedding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_embedding (
    id integer NOT NULL,
    attachment_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    embedding_model character varying NOT NULL,
    content text NOT NULL,
    has_embedding_generation_failed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    embedding_vector public.vector(1536)
);


ALTER TABLE public.ai_embedding OWNER TO runbot;

--
-- Name: TABLE ai_embedding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_embedding IS 'Attachment Chunks Embedding';


--
-- Name: COLUMN ai_embedding.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_embedding.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.sequence IS 'Sequence';


--
-- Name: COLUMN ai_embedding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_uid IS 'Created by';


--
-- Name: COLUMN ai_embedding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_embedding.embedding_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_model IS 'Embedding Model';


--
-- Name: COLUMN ai_embedding.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.content IS 'Chunk Content';


--
-- Name: COLUMN ai_embedding.has_embedding_generation_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.has_embedding_generation_failed IS 'Has Embedding Generation Failed';


--
-- Name: COLUMN ai_embedding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_date IS 'Created on';


--
-- Name: COLUMN ai_embedding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_date IS 'Last Updated on';


--
-- Name: COLUMN ai_embedding.embedding_vector; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_vector IS 'Embedding Vector';


--
-- Name: ai_embedding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_embedding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_embedding_id_seq OWNER TO runbot;

--
-- Name: ai_embedding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_embedding_id_seq OWNED BY public.ai_embedding.id;


--
-- Name: ai_prompt_button; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_prompt_button (
    id integer NOT NULL,
    sequence integer,
    composer_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_prompt_button OWNER TO runbot;

--
-- Name: TABLE ai_prompt_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_prompt_button IS 'Prompt that can be attached to AI UI rules for quick access by the user.';


--
-- Name: COLUMN ai_prompt_button.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.sequence IS 'Sequence';


--
-- Name: COLUMN ai_prompt_button.composer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.composer_id IS 'Composer';


--
-- Name: COLUMN ai_prompt_button.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_uid IS 'Created by';


--
-- Name: COLUMN ai_prompt_button.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_prompt_button.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.name IS 'AI Prompt';


--
-- Name: COLUMN ai_prompt_button.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_date IS 'Created on';


--
-- Name: COLUMN ai_prompt_button.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_date IS 'Last Updated on';


--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_prompt_button_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_prompt_button_id_seq OWNER TO runbot;

--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_prompt_button_id_seq OWNED BY public.ai_prompt_button.id;


--
-- Name: ai_tool_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_tool_ids_rel (
    parent_id integer NOT NULL,
    tool_id integer NOT NULL
);


ALTER TABLE public.ai_tool_ids_rel OWNER TO runbot;

--
-- Name: TABLE ai_tool_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_tool_ids_rel IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: ai_topic; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description text,
    instructions text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_topic OWNER TO runbot;

--
-- Name: TABLE ai_topic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic IS 'Create a topic that leverages instructions and tools to direct Odoo AI in assisting the user with their tasks.';


--
-- Name: COLUMN ai_topic.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_uid IS 'Created by';


--
-- Name: COLUMN ai_topic.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_topic.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.name IS 'Title';


--
-- Name: COLUMN ai_topic.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.description IS 'Description';


--
-- Name: COLUMN ai_topic.instructions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.instructions IS 'Instructions';


--
-- Name: COLUMN ai_topic.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_date IS 'Created on';


--
-- Name: COLUMN ai_topic.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_date IS 'Last Updated on';


--
-- Name: ai_topic_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_topic_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_topic_id_seq OWNER TO runbot;

--
-- Name: ai_topic_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_topic_id_seq OWNED BY public.ai_topic.id;


--
-- Name: ai_topic_ir_act_server_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic_ir_act_server_rel (
    ai_topic_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.ai_topic_ir_act_server_rel OWNER TO runbot;

--
-- Name: TABLE ai_topic_ir_act_server_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic_ir_act_server_rel IS 'RELATION BETWEEN ai_topic AND ir_act_server';


--
-- Name: auth_passkey_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key (
    id integer NOT NULL,
    sign_count integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    credential_identifier character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    public_key character varying
);


ALTER TABLE public.auth_passkey_key OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key IS 'Passkey';


--
-- Name: COLUMN auth_passkey_key.sign_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.sign_count IS 'Sign Count';


--
-- Name: COLUMN auth_passkey_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_uid IS 'Create Uid';


--
-- Name: COLUMN auth_passkey_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key.credential_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.credential_identifier IS 'Credential Identifier';


--
-- Name: COLUMN auth_passkey_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key_create (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_passkey_key_create OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key_create IS 'Create a Passkey';


--
-- Name: COLUMN auth_passkey_key_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_uid IS 'Created by';


--
-- Name: COLUMN auth_passkey_key_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNED BY public.auth_passkey_key_create.id;


--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_id_seq OWNED BY public.auth_passkey_key.id;


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_rate_limit_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_rate_limit_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    ip character varying,
    limit_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_totp_rate_limit_log OWNER TO runbot;

--
-- Name: TABLE auth_totp_rate_limit_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_rate_limit_log IS 'TOTP rate limit logs';


--
-- Name: COLUMN auth_totp_rate_limit_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.user_id IS 'User';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_rate_limit_log.ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.ip IS 'Ip';


--
-- Name: COLUMN auth_totp_rate_limit_log.limit_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.limit_type IS 'Limit Type';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_date IS 'Last Updated on';


--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_rate_limit_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNER TO runbot;

--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNED BY public.auth_totp_rate_limit_log.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: barcode_nomenclature; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_nomenclature (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    upc_ean_conv character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    gs1_separator_fnc1 character varying,
    is_gs1_nomenclature boolean
);


ALTER TABLE public.barcode_nomenclature OWNER TO runbot;

--
-- Name: TABLE barcode_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_nomenclature IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_nomenclature.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_nomenclature.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.name IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.upc_ean_conv; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.upc_ean_conv IS 'UPC/EAN Conversion';


--
-- Name: COLUMN barcode_nomenclature.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_date IS 'Created on';


--
-- Name: COLUMN barcode_nomenclature.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_nomenclature.gs1_separator_fnc1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.gs1_separator_fnc1 IS 'FNC1 Separator';


--
-- Name: COLUMN barcode_nomenclature.is_gs1_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.is_gs1_nomenclature IS 'Is GS1 Nomenclature';


--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_nomenclature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNER TO runbot;

--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNED BY public.barcode_nomenclature.id;


--
-- Name: barcode_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_rule (
    id integer NOT NULL,
    barcode_nomenclature_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    encoding character varying NOT NULL,
    type character varying NOT NULL,
    pattern character varying NOT NULL,
    alias character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    associated_uom_id integer,
    gs1_content_type character varying,
    gs1_decimal_usage boolean
);


ALTER TABLE public.barcode_rule OWNER TO runbot;

--
-- Name: TABLE barcode_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_rule IS 'Barcode Rule';


--
-- Name: COLUMN barcode_rule.barcode_nomenclature_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.barcode_nomenclature_id IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.sequence IS 'Sequence';


--
-- Name: COLUMN barcode_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.name IS 'Rule Name';


--
-- Name: COLUMN barcode_rule.encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.encoding IS 'Encoding';


--
-- Name: COLUMN barcode_rule.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.type IS 'Type';


--
-- Name: COLUMN barcode_rule.pattern; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.pattern IS 'Barcode Pattern';


--
-- Name: COLUMN barcode_rule.alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.alias IS 'Alias';


--
-- Name: COLUMN barcode_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_date IS 'Created on';


--
-- Name: COLUMN barcode_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_rule.associated_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.associated_uom_id IS 'Associated Uom';


--
-- Name: COLUMN barcode_rule.gs1_content_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_content_type IS 'GS1 Content Type';


--
-- Name: COLUMN barcode_rule.gs1_decimal_usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_decimal_usage IS 'Decimal';


--
-- Name: barcode_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_rule_id_seq OWNER TO runbot;

--
-- Name: barcode_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_rule_id_seq OWNED BY public.barcode_rule.id;


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_uninstall_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall_ir_module_module_rel (
    base_module_uninstall_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_uninstall_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall_ir_module_module_rel IS 'RELATION BETWEEN base_module_uninstall AND ir_module_module';


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: confirm_stock_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.confirm_stock_sms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.confirm_stock_sms OWNER TO runbot;

--
-- Name: TABLE confirm_stock_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.confirm_stock_sms IS 'Confirm Stock SMS';


--
-- Name: COLUMN confirm_stock_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_uid IS 'Created by';


--
-- Name: COLUMN confirm_stock_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN confirm_stock_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_date IS 'Created on';


--
-- Name: COLUMN confirm_stock_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_date IS 'Last Updated on';


--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.confirm_stock_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNER TO runbot;

--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNED BY public.confirm_stock_sms.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: discuss_call_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_call_history (
    id integer NOT NULL,
    channel_id integer NOT NULL,
    start_call_message_id integer,
    create_uid integer,
    write_uid integer,
    start_dt timestamp without time zone NOT NULL,
    end_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_call_history_channel_id_not_null_constraint CHECK ((channel_id IS NOT NULL)),
    CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint CHECK ((start_dt IS NOT NULL))
);


ALTER TABLE public.discuss_call_history OWNER TO runbot;

--
-- Name: TABLE discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_call_history IS 'Keep the call history';


--
-- Name: COLUMN discuss_call_history.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_call_history.start_call_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_call_message_id IS 'Start Call Message';


--
-- Name: COLUMN discuss_call_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_call_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_call_history.start_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_dt IS 'Start Dt';


--
-- Name: COLUMN discuss_call_history.end_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.end_dt IS 'End Dt';


--
-- Name: COLUMN discuss_call_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_date IS 'Created on';


--
-- Name: COLUMN discuss_call_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON public.discuss_call_history IS 'CHECK (channel_id IS NOT NULL)';


--
-- Name: CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON public.discuss_call_history IS 'CHECK (start_dt IS NOT NULL)';


--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_call_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_call_history_id_seq OWNER TO runbot;

--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_call_history_id_seq OWNED BY public.discuss_call_history.id;


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ai_agent_id integer,
    ai_env_context jsonb,
    CONSTRAINT discuss_channel_ai_channel_type_check CHECK (((ai_agent_id IS NULL) OR ((channel_type)::text = 'ai_chat'::text) OR ((channel_type)::text = 'livechat'::text))),
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: COLUMN discuss_channel.ai_agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_agent_id IS 'Ai Agent';


--
-- Name: COLUMN discuss_channel.ai_env_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_env_context IS 'Context for AI agent';


--
-- Name: CONSTRAINT discuss_channel_ai_channel_type_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_ai_channel_type_check ON public.discuss_channel IS 'CHECK(ai_agent_id IS NULL or channel_type = ''ai_chat'' or channel_type = ''livechat'')';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: docs_config_installer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.docs_config_installer (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    port integer NOT NULL,
    host character varying(64) NOT NULL,
    auth_type character varying,
    username character varying(32),
    password character varying(32),
    state character varying,
    msg text,
    error_details text,
    enabled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.docs_config_installer OWNER TO runbot;

--
-- Name: TABLE docs_config_installer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.docs_config_installer IS 'docs_config.installer';


--
-- Name: COLUMN docs_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN docs_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN docs_config_installer.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.port IS 'Port';


--
-- Name: COLUMN docs_config_installer.host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.host IS 'Host';


--
-- Name: COLUMN docs_config_installer.auth_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.auth_type IS 'Authentication';


--
-- Name: COLUMN docs_config_installer.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.username IS 'Username';


--
-- Name: COLUMN docs_config_installer.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.password IS 'Password';


--
-- Name: COLUMN docs_config_installer.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.state IS 'State';


--
-- Name: COLUMN docs_config_installer.msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.msg IS 'Message';


--
-- Name: COLUMN docs_config_installer.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.error_details IS 'Error Details';


--
-- Name: COLUMN docs_config_installer.enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.enabled IS 'Enabled';


--
-- Name: COLUMN docs_config_installer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN docs_config_installer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.write_date IS 'Last Updated on';


--
-- Name: docs_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.docs_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.docs_config_installer_id_seq OWNER TO runbot;

--
-- Name: docs_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.docs_config_installer_id_seq OWNED BY public.docs_config_installer.id;


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    error_message text,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    error_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    microsoft_outlook_access_token_expiration integer,
    microsoft_outlook_refresh_token character varying,
    microsoft_outlook_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_message IS 'Last Error Message';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.error_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_date IS 'Last Error Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token_expiration IS 'Outlook Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_refresh_token IS 'Outlook Refresh Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token IS 'Outlook Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: html_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.html_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.html_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE html_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.html_editor_converter_test IS 'Html Editor Converter Test';


--
-- Name: COLUMN html_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN html_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN html_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN html_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN html_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN html_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN html_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN html_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN html_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN html_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN html_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN html_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN html_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN html_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN html_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."binary" IS 'Binary';


--
-- Name: html_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.html_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.html_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: html_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.html_editor_converter_test_id_seq OWNED BY public.html_editor_converter_test.id;


--
-- Name: html_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.html_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.html_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE html_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.html_editor_converter_test_sub IS 'Html Editor Converter Subtest';


--
-- Name: COLUMN html_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN html_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN html_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN html_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN html_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: html_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.html_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.html_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: html_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.html_editor_converter_test_sub_id_seq OWNED BY public.html_editor_converter_test_sub.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision,
    sender_name character varying
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: COLUMN iap_account.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.sender_name IS 'Sender Name';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean,
    stylesheet_id integer,
    attachment_id integer,
    out_format integer,
    copies integer,
    deferred_limit integer,
    replace_report_id integer,
    wizard_id integer,
    charset character varying NOT NULL,
    styles_mode character varying,
    preload_mode character varying,
    tml_source character varying,
    parser_model character varying,
    in_format character varying,
    deferred character varying,
    process_sep boolean,
    report_wizard boolean,
    copies_intercalate boolean,
    disable_fallback boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: COLUMN ir_act_report_xml.stylesheet_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.stylesheet_id IS 'Template Stylesheet';


--
-- Name: COLUMN ir_act_report_xml.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_id IS 'Attachment';


--
-- Name: COLUMN ir_act_report_xml.out_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.out_format IS 'Output Mime-type';


--
-- Name: COLUMN ir_act_report_xml.copies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.copies IS 'Number of Copies';


--
-- Name: COLUMN ir_act_report_xml.deferred_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.deferred_limit IS 'Deferred Records Limit';


--
-- Name: COLUMN ir_act_report_xml.replace_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.replace_report_id IS 'Replace Report';


--
-- Name: COLUMN ir_act_report_xml.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.wizard_id IS 'Wizard Action';


--
-- Name: COLUMN ir_act_report_xml.charset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.charset IS 'Charset';


--
-- Name: COLUMN ir_act_report_xml.styles_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.styles_mode IS 'Stylesheet';


--
-- Name: COLUMN ir_act_report_xml.preload_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.preload_mode IS 'Preload Mode';


--
-- Name: COLUMN ir_act_report_xml.tml_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.tml_source IS 'Template source';


--
-- Name: COLUMN ir_act_report_xml.parser_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.parser_model IS 'Parser Model';


--
-- Name: COLUMN ir_act_report_xml.in_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.in_format IS 'Template Mime-type';


--
-- Name: COLUMN ir_act_report_xml.deferred; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.deferred IS 'Deferred';


--
-- Name: COLUMN ir_act_report_xml.process_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.process_sep IS 'Process Separately';


--
-- Name: COLUMN ir_act_report_xml.report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_wizard IS 'Report Wizard';


--
-- Name: COLUMN ir_act_report_xml.copies_intercalate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.copies_intercalate IS 'Copies Intercalate';


--
-- Name: COLUMN ir_act_report_xml.disable_fallback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.disable_fallback IS 'Disable Format Fallback';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    parent_id integer,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    sequence_id integer,
    selection_value integer,
    automated_name character varying,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text,
    html_value text,
    activity_user_id integer,
    activity_type_id integer,
    template_id integer,
    activity_date_deadline_range integer,
    activity_summary character varying,
    followers_type character varying,
    followers_partner_field_name character varying,
    mail_post_method character varying,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_field_name character varying,
    activity_note text,
    mail_post_autofollow boolean,
    sms_template_id integer,
    sms_method character varying,
    ai_tool_description jsonb,
    ai_action_prompt text,
    ai_tool_schema text,
    use_in_ai boolean,
    ai_tool_allow_end_message boolean,
    ai_update_prompt text
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.parent_id IS 'Parent Action';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence_id IS 'Sequence to use';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.automated_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.automated_name IS 'Automated Name';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: COLUMN ir_act_server.html_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.html_value IS 'Html Value';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Title';


--
-- Name: COLUMN ir_act_server.followers_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.followers_type IS 'Followers Type';


--
-- Name: COLUMN ir_act_server.followers_partner_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.followers_partner_field_name IS 'Followers Field';


--
-- Name: COLUMN ir_act_server.mail_post_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_method IS 'Send Email As';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'User Type';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User Field';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.mail_post_autofollow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_autofollow IS 'Subscribe Recipients';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_method IS 'Send SMS As';


--
-- Name: COLUMN ir_act_server.ai_tool_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_description IS 'AI Tool Description';


--
-- Name: COLUMN ir_act_server.ai_action_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_action_prompt IS 'AI Action Prompt';


--
-- Name: COLUMN ir_act_server.ai_tool_schema; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_schema IS 'AI Schema';


--
-- Name: COLUMN ir_act_server.use_in_ai; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.use_in_ai IS 'Use in AI';


--
-- Name: COLUMN ir_act_server.ai_tool_allow_end_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_allow_end_message IS 'Allow End Message';


--
-- Name: COLUMN ir_act_server.ai_update_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_update_prompt IS 'AI Update Prompt';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean,
    cache boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: COLUMN ir_act_window.cache; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.cache IS 'Data Caching';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_server_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_server_history (
    id integer NOT NULL,
    action_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_server_history OWNER TO runbot;

--
-- Name: TABLE ir_actions_server_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_server_history IS 'Server Action History';


--
-- Name: COLUMN ir_actions_server_history.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_server_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_server_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_server_history.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.code IS 'Code';


--
-- Name: COLUMN ir_actions_server_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_server_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.write_date IS 'Last Updated on';


--
-- Name: ir_actions_server_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_server_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_server_history_id_seq OWNER TO runbot;

--
-- Name: ir_actions_server_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_server_history_id_seq OWNED BY public.ir_actions_server_history.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    "json_value" character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default."json_value"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default."json_value" IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
            (action_id IS NOT NULL AND python_method IS NULL)
            OR (action_id IS NULL AND python_method IS NOT NULL)
        )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(NOT (python_method IS NOT NULL AND name IS NULL))';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL))';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_filters_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters_res_users_rel (
    ir_filters_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.ir_filters_res_users_rel OWNER TO runbot;

--
-- Name: TABLE ir_filters_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters_res_users_rel IS 'RELATION BETWEEN ir_filters AND res_users';


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    owner_user_id integer,
    owner_limit_count integer,
    owner_limit_time timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    microsoft_outlook_access_token_expiration integer,
    microsoft_outlook_refresh_token character varying,
    microsoft_outlook_access_token character varying,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.owner_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_user_id IS 'Owner';


--
-- Name: COLUMN ir_mail_server.owner_limit_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_limit_count IS 'Owner Limit Count';


--
-- Name: COLUMN ir_mail_server.owner_limit_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_limit_time IS 'Owner Limit Time';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_access_token_expiration IS 'Outlook Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_refresh_token IS 'Outlook Refresh Token';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_access_token IS 'Outlook Access Token';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    fold_name character varying,
    name jsonb NOT NULL,
    info text,
    abstract boolean,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.fold_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.fold_name IS 'Fold Field';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.abstract; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.abstract IS 'Abstract Model';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Has Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Has Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Has Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Last Updated on';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    translate character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    tracking integer,
    ai_domain character varying,
    system_prompt text,
    ai boolean,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: COLUMN ir_model_fields.ai_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ai_domain IS 'AI field domain';


--
-- Name: COLUMN ir_model_fields.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.system_prompt IS 'AI Prompt';


--
-- Name: COLUMN ir_model_fields.ai; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ai IS 'AI field';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_model_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ir_model_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND ir_model';


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    others text,
    qweb text,
    duration numeric,
    cpu_duration numeric,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.others; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.others IS 'others';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: COLUMN ir_profile.cpu_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.cpu_duration IS 'CPU Duration';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_001; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_001
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_001 OWNER TO runbot;

--
-- Name: ir_sequence_002; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_002
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_002 OWNER TO runbot;

--
-- Name: ir_sequence_003; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_003
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_003 OWNER TO runbot;

--
-- Name: ir_sequence_004; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_004
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_004 OWNER TO runbot;

--
-- Name: ir_sequence_005; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_005
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_005 OWNER TO runbot;

--
-- Name: ir_sequence_006; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_006
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_006 OWNER TO runbot;

--
-- Name: ir_sequence_007; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_007
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_007 OWNER TO runbot;

--
-- Name: ir_sequence_008; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_008
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_008 OWNER TO runbot;

--
-- Name: ir_sequence_009; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_009
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_009 OWNER TO runbot;

--
-- Name: ir_sequence_010; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_010
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_010 OWNER TO runbot;

--
-- Name: ir_sequence_011; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_011
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_011 OWNER TO runbot;

--
-- Name: ir_sequence_012; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_012
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_012 OWNER TO runbot;

--
-- Name: ir_sequence_013; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_013
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_013 OWNER TO runbot;

--
-- Name: ir_sequence_014; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_014
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_014 OWNER TO runbot;

--
-- Name: ir_sequence_015; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_015
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_015 OWNER TO runbot;

--
-- Name: ir_sequence_016; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_016
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_016 OWNER TO runbot;

--
-- Name: ir_sequence_017; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_017
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_017 OWNER TO runbot;

--
-- Name: ir_sequence_018; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_018
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_018 OWNER TO runbot;

--
-- Name: ir_sequence_019; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_019
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_019 OWNER TO runbot;

--
-- Name: ir_sequence_020; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_020
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_020 OWNER TO runbot;

--
-- Name: ir_sequence_021; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_021
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_021 OWNER TO runbot;

--
-- Name: ir_sequence_022; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_022
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_022 OWNER TO runbot;

--
-- Name: ir_sequence_023; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_023
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_023 OWNER TO runbot;

--
-- Name: ir_sequence_024; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_024
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_024 OWNER TO runbot;

--
-- Name: ir_sequence_025; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_025
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_025 OWNER TO runbot;

--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    customize_show boolean,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_ui_view.customize_show; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.customize_show IS 'Show As Optional Inherit';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: lot_label_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.lot_label_layout (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label_quantity character varying NOT NULL,
    print_format character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.lot_label_layout OWNER TO runbot;

--
-- Name: TABLE lot_label_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.lot_label_layout IS 'Choose the sheet layout to print lot labels';


--
-- Name: COLUMN lot_label_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.lot_label_layout.create_uid IS 'Created by';


--
-- Name: COLUMN lot_label_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.lot_label_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN lot_label_layout.label_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.lot_label_layout.label_quantity IS 'Quantity to print';


--
-- Name: COLUMN lot_label_layout.print_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.lot_label_layout.print_format IS 'Format';


--
-- Name: COLUMN lot_label_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.lot_label_layout.create_date IS 'Created on';


--
-- Name: COLUMN lot_label_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.lot_label_layout.write_date IS 'Last Updated on';


--
-- Name: lot_label_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.lot_label_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.lot_label_layout_id_seq OWNER TO runbot;

--
-- Name: lot_label_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.lot_label_layout_id_seq OWNED BY public.lot_label_layout.id;


--
-- Name: lot_label_layout_stock_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.lot_label_layout_stock_move_line_rel (
    lot_label_layout_id integer NOT NULL,
    stock_move_line_id integer NOT NULL
);


ALTER TABLE public.lot_label_layout_stock_move_line_rel OWNER TO runbot;

--
-- Name: TABLE lot_label_layout_stock_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.lot_label_layout_stock_move_line_rel IS 'RELATION BETWEEN lot_label_layout AND stock_move_line';


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer,
    res_id integer,
    activity_type_id integer,
    user_id integer,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    res_name character varying,
    summary character varying,
    user_tz character varying,
    date_deadline date NOT NULL,
    date_done date,
    note text,
    feedback text,
    automated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT mail_activity_check_res_id_is_set_if_model CHECK (((((COALESCE(res_model, ''::character varying))::text <> ''::text) AND ((res_id IS NOT NULL) AND (res_id <> 0))) OR (((COALESCE(res_model, ''::character varying))::text = ''::text) AND ((res_id IS NULL) OR (res_id = 0))))),
    CONSTRAINT mail_activity_check_user_id_is_set_if_model CHECK ((((COALESCE(res_model, ''::character varying))::text <> ''::text) OR (user_id IS NOT NULL)))
);


ALTER TABLE public.mail_activity OWNER TO runbot;

--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.user_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_tz IS 'Timezone';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_done IS 'Done Date';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.feedback IS 'Feedback';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.active IS 'Active';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT mail_activity_check_res_id_is_set_if_model ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_res_id_is_set_if_model ON public.mail_activity IS 'CHECK(
            (COALESCE(res_model, '''') <> '''' AND (res_id IS NOT NULL AND res_id != 0)) OR
            (COALESCE(res_model, '''') = '''' AND (res_id IS NULL OR res_id = 0))
        )';


--
-- Name: CONSTRAINT mail_activity_check_user_id_is_set_if_model ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_user_id_is_set_if_model ON public.mail_activity IS 'CHECK(
            (COALESCE(res_model, '''') <> '''' OR user_id IS NOT NULL)
        )';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_id_seq OWNER TO runbot;

--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan (
    id integer NOT NULL,
    company_id integer,
    res_model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan IS 'Activity Plan';


--
-- Name: COLUMN mail_activity_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.company_id IS 'Company';


--
-- Name: COLUMN mail_activity_plan.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.name IS 'Name';


--
-- Name: COLUMN mail_activity_plan.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.active IS 'Active';


--
-- Name: COLUMN mail_activity_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_id_seq OWNED BY public.mail_activity_plan.id;


--
-- Name: mail_activity_plan_mail_activity_schedule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_mail_activity_schedule_rel (
    mail_activity_schedule_id integer NOT NULL,
    mail_activity_plan_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_mail_activity_schedule_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_mail_activity_schedule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_mail_activity_schedule_rel IS 'RELATION BETWEEN mail_activity_schedule AND mail_activity_plan';


--
-- Name: mail_activity_plan_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    sequence integer,
    activity_type_id integer NOT NULL,
    delay_count integer,
    responsible_id integer,
    create_uid integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    summary character varying,
    responsible_type character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan_template OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template IS 'Activity plan template';


--
-- Name: COLUMN mail_activity_plan_template.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_plan_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_plan_template.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_plan_template.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_count IS 'Interval';


--
-- Name: COLUMN mail_activity_plan_template.responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_plan_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan_template.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_plan_template.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_from IS 'Trigger';


--
-- Name: COLUMN mail_activity_plan_template.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_plan_template.responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_type IS 'Assignment';


--
-- Name: COLUMN mail_activity_plan_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.note IS 'Note';


--
-- Name: COLUMN mail_activity_plan_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNED BY public.mail_activity_plan_template.id;


--
-- Name: mail_activity_plan_template_mail_activity_type_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template_mail_activity_type_rel (
    mail_activity_plan_template_id integer NOT NULL,
    mail_activity_type_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_template_mail_activity_type_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template_mail_activity_type_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template_mail_activity_type_rel IS 'RELATION BETWEEN mail_activity_plan_template AND mail_activity_type';


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


ALTER TABLE public.mail_activity_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule (
    id integer NOT NULL,
    res_model_id integer,
    plan_id integer,
    plan_on_demand_user_id integer,
    activity_type_id integer,
    activity_user_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    summary character varying,
    plan_date date,
    date_deadline date,
    res_ids text,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule IS 'Activity schedule plan Wizard';


--
-- Name: COLUMN mail_activity_schedule.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_schedule.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_schedule.plan_on_demand_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_on_demand_user_id IS 'Assigned To';


--
-- Name: COLUMN mail_activity_schedule.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_schedule.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_schedule.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_schedule.plan_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_date IS 'Plan Date';


--
-- Name: COLUMN mail_activity_schedule.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity_schedule.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_ids IS 'Document IDs';


--
-- Name: COLUMN mail_activity_schedule.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.note IS 'Note';


--
-- Name: COLUMN mail_activity_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNED BY public.mail_activity_schedule.id;


--
-- Name: mail_activity_schedule_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule_line (
    id integer NOT NULL,
    activity_schedule_id integer NOT NULL,
    responsible_user_id integer,
    create_uid integer,
    write_uid integer,
    line_description character varying,
    line_date_deadline date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule_line OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule_line IS 'Mail Activity Schedule Line';


--
-- Name: COLUMN mail_activity_schedule_line.activity_schedule_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.activity_schedule_id IS 'Activity Schedule';


--
-- Name: COLUMN mail_activity_schedule_line.responsible_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.responsible_user_id IS 'Responsible User';


--
-- Name: COLUMN mail_activity_schedule_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule_line.line_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.line_description IS 'Line Description';


--
-- Name: COLUMN mail_activity_schedule_line.line_date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.line_date_deadline IS 'Date Deadline';


--
-- Name: COLUMN mail_activity_schedule_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_line_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_line_id_seq OWNED BY public.mail_activity_schedule_line.id;


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    delay_count integer,
    triggered_next_type_id integer,
    default_user_id integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model character varying,
    chaining_type character varying NOT NULL,
    category character varying,
    name jsonb NOT NULL,
    summary jsonb,
    default_note jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_type OWNER TO runbot;

--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Schedule';


--
-- Name: COLUMN mail_activity_type.triggered_next_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.triggered_next_type_id IS 'Trigger';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_type.chaining_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.chaining_type IS 'Chaining Type';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.default_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_note IS 'Default Note';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_type_id_seq OWNER TO runbot;

--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_activity_type_mail_template_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_domain_id integer,
    alias_model_id integer NOT NULL,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    create_uid integer,
    write_uid integer,
    alias_name character varying,
    alias_full_name character varying,
    alias_contact character varying NOT NULL,
    alias_status character varying,
    alias_bounced_content jsonb,
    alias_defaults text NOT NULL,
    alias_incoming_local boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias OWNER TO runbot;

--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_full_name IS 'Alias Email';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_status IS 'Alias Status';


--
-- Name: COLUMN mail_alias.alias_bounced_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_bounced_content IS 'Custom Bounced Message';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_incoming_local; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_incoming_local IS 'Local-part based incoming detection';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias_domain (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bounce_alias character varying NOT NULL,
    catchall_alias character varying NOT NULL,
    default_from character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias_domain OWNER TO runbot;

--
-- Name: TABLE mail_alias_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias_domain IS 'Email Domain';


--
-- Name: COLUMN mail_alias_domain.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.sequence IS 'Sequence';


--
-- Name: COLUMN mail_alias_domain.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias_domain.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias_domain.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.name IS 'Name';


--
-- Name: COLUMN mail_alias_domain.bounce_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.bounce_alias IS 'Bounce Alias';


--
-- Name: COLUMN mail_alias_domain.catchall_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.catchall_alias IS 'Catchall Alias';


--
-- Name: COLUMN mail_alias_domain.default_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.default_from IS 'Default From Alias';


--
-- Name: COLUMN mail_alias_domain.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias_domain.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_domain_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_domain_id_seq OWNER TO runbot;

--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_domain_id_seq OWNED BY public.mail_alias_domain.id;


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_id_seq OWNER TO runbot;

--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist OWNER TO runbot;

--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE mail_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist_remove IS 'Remove email from blacklist wizard';


--
-- Name: COLUMN mail_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist_remove.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.email IS 'Email';


--
-- Name: COLUMN mail_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN mail_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNED BY public.mail_blacklist_remove.id;


--
-- Name: mail_canned_response; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source character varying NOT NULL,
    substitution text NOT NULL,
    is_shared boolean,
    last_used timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_canned_response OWNER TO runbot;

--
-- Name: TABLE mail_canned_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response IS 'Canned Response';


--
-- Name: COLUMN mail_canned_response.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_uid IS 'Created by';


--
-- Name: COLUMN mail_canned_response.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_canned_response.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.source IS 'Shortcut';


--
-- Name: COLUMN mail_canned_response.substitution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.substitution IS 'Substitution';


--
-- Name: COLUMN mail_canned_response.is_shared; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.is_shared IS 'Determines if the canned_response is currently shared with other users';


--
-- Name: COLUMN mail_canned_response.last_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.last_used IS 'Last Used';


--
-- Name: COLUMN mail_canned_response.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_date IS 'Created on';


--
-- Name: COLUMN mail_canned_response.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_date IS 'Last Updated on';


--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_canned_response_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_canned_response_id_seq OWNER TO runbot;

--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_canned_response_id_seq OWNED BY public.mail_canned_response.id;


--
-- Name: mail_canned_response_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response_res_groups_rel (
    mail_canned_response_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.mail_canned_response_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE mail_canned_response_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response_res_groups_rel IS 'RELATION BETWEEN mail_canned_response AND res_groups';


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    template_id integer,
    parent_id integer,
    author_id integer,
    res_domain_user_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    email_layout_xmlid character varying,
    email_from character varying,
    composition_mode character varying,
    composition_comment_option character varying,
    model character varying,
    message_type character varying NOT NULL,
    reply_to character varying,
    scheduled_date character varying,
    template_name character varying,
    body text,
    res_ids text,
    res_domain text,
    email_add_signature boolean,
    reply_to_force_new boolean,
    auto_delete boolean,
    auto_delete_keep_log boolean,
    force_send boolean,
    notify_author boolean,
    notify_author_mention boolean,
    notify_skip_followers boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_compose_message OWNER TO runbot;

--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.res_domain_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain_user_id IS 'Responsible';


--
-- Name: COLUMN mail_compose_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_compose_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.lang IS 'Language';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.composition_comment_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_comment_option IS 'Comment Options';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_compose_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_compose_message.template_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_name IS 'Template Name';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_compose_message.res_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_add_signature IS 'Add signature';


--
-- Name: COLUMN mail_compose_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to_force_new IS 'Considers answers as new thread';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_keep_log IS 'Keep Message Copy';


--
-- Name: COLUMN mail_compose_message.force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.force_send IS 'Send mailing or notifications directly';


--
-- Name: COLUMN mail_compose_message.notify_author; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_author IS 'Notify Author';


--
-- Name: COLUMN mail_compose_message.notify_author_mention; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_author_mention IS 'Notify Author Mention';


--
-- Name: COLUMN mail_compose_message.notify_skip_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_skip_followers IS 'Notify Skip Followers';


--
-- Name: COLUMN mail_compose_message.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.use_exclusion_list IS 'Use Exclusion List';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_compose_message_id_seq OWNER TO runbot;

--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_id integer,
    partner_id integer NOT NULL,
    res_model character varying NOT NULL
);


ALTER TABLE public.mail_followers OWNER TO runbot;

--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: mail_followers_edit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_edit (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    res_ids character varying,
    operation character varying NOT NULL,
    message text,
    notify boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_followers_edit OWNER TO runbot;

--
-- Name: TABLE mail_followers_edit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_edit IS 'Followers edit wizard';


--
-- Name: COLUMN mail_followers_edit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.create_uid IS 'Created by';


--
-- Name: COLUMN mail_followers_edit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_followers_edit.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_followers_edit.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_followers_edit.operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.operation IS 'Operation';


--
-- Name: COLUMN mail_followers_edit.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.message IS 'Message';


--
-- Name: COLUMN mail_followers_edit.notify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.notify IS 'Notify Recipients';


--
-- Name: COLUMN mail_followers_edit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.create_date IS 'Created on';


--
-- Name: COLUMN mail_followers_edit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.write_date IS 'Last Updated on';


--
-- Name: mail_followers_edit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_edit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_edit_id_seq OWNER TO runbot;

--
-- Name: mail_followers_edit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_edit_id_seq OWNED BY public.mail_followers_edit.id;


--
-- Name: mail_followers_edit_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_edit_res_partner_rel (
    mail_followers_edit_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_followers_edit_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_edit_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_edit_res_partner_rel IS 'RELATION BETWEEN mail_followers_edit AND res_partner';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_id_seq OWNER TO runbot;

--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_followers_mail_message_subtype_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_gateway_allowed; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_gateway_allowed (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    email_normalized character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_gateway_allowed OWNER TO runbot;

--
-- Name: TABLE mail_gateway_allowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_gateway_allowed IS 'Mail Gateway Allowed';


--
-- Name: COLUMN mail_gateway_allowed.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_uid IS 'Created by';


--
-- Name: COLUMN mail_gateway_allowed.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_gateway_allowed.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email IS 'Email Address';


--
-- Name: COLUMN mail_gateway_allowed.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN mail_gateway_allowed.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_date IS 'Created on';


--
-- Name: COLUMN mail_gateway_allowed.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_date IS 'Last Updated on';


--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_gateway_allowed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNER TO runbot;

--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNED BY public.mail_gateway_allowed.id;


--
-- Name: mail_guest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_guest (
    id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    access_token character varying NOT NULL,
    email character varying,
    lang character varying,
    timezone character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_guest OWNER TO runbot;

--
-- Name: TABLE mail_guest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_guest IS 'Guest';


--
-- Name: COLUMN mail_guest.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.country_id IS 'Country';


--
-- Name: COLUMN mail_guest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_uid IS 'Created by';


--
-- Name: COLUMN mail_guest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_guest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.name IS 'Name';


--
-- Name: COLUMN mail_guest.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.access_token IS 'Access Token';


--
-- Name: COLUMN mail_guest.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.email IS 'Email';


--
-- Name: COLUMN mail_guest.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.lang IS 'Language';


--
-- Name: COLUMN mail_guest.timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.timezone IS 'Timezone';


--
-- Name: COLUMN mail_guest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_date IS 'Created on';


--
-- Name: COLUMN mail_guest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_date IS 'Last Updated on';


--
-- Name: mail_guest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_guest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_guest_id_seq OWNER TO runbot;

--
-- Name: mail_guest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_guest_id_seq OWNED BY public.mail_guest.id;


--
-- Name: mail_ice_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_ice_server (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_type character varying NOT NULL,
    uri character varying NOT NULL,
    username character varying,
    credential character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_ice_server OWNER TO runbot;

--
-- Name: TABLE mail_ice_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_ice_server IS 'ICE Server';


--
-- Name: COLUMN mail_ice_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_uid IS 'Created by';


--
-- Name: COLUMN mail_ice_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_ice_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.server_type IS 'Type';


--
-- Name: COLUMN mail_ice_server.uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.uri IS 'URI';


--
-- Name: COLUMN mail_ice_server.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.username IS 'Username';


--
-- Name: COLUMN mail_ice_server.credential; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.credential IS 'Credential';


--
-- Name: COLUMN mail_ice_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_date IS 'Created on';


--
-- Name: COLUMN mail_ice_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_date IS 'Last Updated on';


--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_ice_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_ice_server_id_seq OWNER TO runbot;

--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_ice_server_id_seq OWNED BY public.mail_ice_server.id;


--
-- Name: mail_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_link_preview (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_url character varying NOT NULL,
    og_type character varying,
    og_title character varying,
    og_site_name character varying,
    og_image character varying,
    og_mimetype character varying,
    image_mimetype character varying,
    og_description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_link_preview IS 'Store link preview data';


--
-- Name: COLUMN mail_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_link_preview.source_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.source_url IS 'URL';


--
-- Name: COLUMN mail_link_preview.og_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_type IS 'Type';


--
-- Name: COLUMN mail_link_preview.og_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_title IS 'Title';


--
-- Name: COLUMN mail_link_preview.og_site_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_site_name IS 'Site name';


--
-- Name: COLUMN mail_link_preview.og_image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_image IS 'Image';


--
-- Name: COLUMN mail_link_preview.og_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_mimetype IS 'MIME type';


--
-- Name: COLUMN mail_link_preview.image_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.image_mimetype IS 'Image MIME type';


--
-- Name: COLUMN mail_link_preview.og_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_description IS 'Description';


--
-- Name: COLUMN mail_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_date IS 'Create Date';


--
-- Name: COLUMN mail_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_link_preview_id_seq OWNED BY public.mail_link_preview.id;


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    fetchmail_server_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    state character varying,
    failure_type character varying,
    body_html text,
    "references" text,
    headers text,
    email_to text,
    failure_reason text,
    is_notification boolean,
    auto_delete boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_mail OWNER TO runbot;

--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.is_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.is_notification IS 'Notification Email';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_mail_id_seq OWNER TO runbot;

--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_mail_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    incoming_email_cc character varying,
    outgoing_email_to character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    incoming_email_to text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    pinned_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.incoming_email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_cc IS 'Emails Cc';


--
-- Name: COLUMN mail_message.outgoing_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.outgoing_email_to IS 'emails To';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.incoming_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_to IS 'Emails To';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.pinned_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.pinned_at IS 'Pinned';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_id_seq OWNER TO runbot;

--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_link_preview (
    id integer NOT NULL,
    message_id integer NOT NULL,
    link_preview_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    is_hidden boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_message_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_link_preview IS 'Link between link previews and messages';


--
-- Name: COLUMN mail_message_link_preview.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.message_id IS 'Message';


--
-- Name: COLUMN mail_message_link_preview.link_preview_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.link_preview_id IS 'Link Preview';


--
-- Name: COLUMN mail_message_link_preview.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_link_preview.is_hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.is_hidden IS 'Is Hidden';


--
-- Name: COLUMN mail_message_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_message_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_message_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_link_preview_id_seq OWNED BY public.mail_message_link_preview.id;


--
-- Name: mail_message_reaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_reaction (
    id integer NOT NULL,
    message_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    content character varying NOT NULL,
    CONSTRAINT mail_message_reaction_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_message_reaction OWNER TO runbot;

--
-- Name: TABLE mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_reaction IS 'Message Reaction';


--
-- Name: COLUMN mail_message_reaction.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.message_id IS 'Message';


--
-- Name: COLUMN mail_message_reaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.partner_id IS 'Reacting Partner';


--
-- Name: COLUMN mail_message_reaction.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.guest_id IS 'Reacting Guest';


--
-- Name: COLUMN mail_message_reaction.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.content IS 'Content';


--
-- Name: CONSTRAINT mail_message_reaction_partner_or_guest_exists ON mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_message_reaction_partner_or_guest_exists ON public.mail_message_reaction IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_reaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_reaction_id_seq OWNER TO runbot;

--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_reaction_id_seq OWNED BY public.mail_message_reaction.id;


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_starred_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_schedule (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    notification_parameters text,
    scheduled_datetime timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_schedule OWNER TO runbot;

--
-- Name: TABLE mail_message_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_schedule IS 'Scheduled Messages';


--
-- Name: COLUMN mail_message_schedule.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_message_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_schedule.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.notification_parameters IS 'Notification Parameter';


--
-- Name: COLUMN mail_message_schedule.scheduled_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.scheduled_datetime IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_message_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_schedule_id_seq OWNED BY public.mail_message_schedule.id;


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    parent_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    relation_field character varying,
    res_model character varying,
    name jsonb NOT NULL,
    description jsonb,
    internal boolean,
    "default" boolean,
    hidden boolean,
    track_recipients boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_subtype OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.track_recipients; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.track_recipients IS 'Track Recipients';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_subtype_id_seq OWNER TO runbot;

--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_message_translation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_translation (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_lang character varying NOT NULL,
    target_lang character varying NOT NULL,
    body text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_translation OWNER TO runbot;

--
-- Name: TABLE mail_message_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_translation IS 'Message Translation';


--
-- Name: COLUMN mail_message_translation.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.message_id IS 'Message';


--
-- Name: COLUMN mail_message_translation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_translation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_translation.source_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.source_lang IS 'Source Language';


--
-- Name: COLUMN mail_message_translation.target_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.target_lang IS 'Target Language';


--
-- Name: COLUMN mail_message_translation.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.body IS 'Translation Body';


--
-- Name: COLUMN mail_message_translation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_date IS 'Create Date';


--
-- Name: COLUMN mail_message_translation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_date IS 'Last Updated on';


--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_translation_id_seq OWNER TO runbot;

--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_translation_id_seq OWNED BY public.mail_message_translation.id;


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification (
    id integer NOT NULL,
    author_id integer,
    mail_message_id integer NOT NULL,
    mail_mail_id integer,
    res_partner_id integer,
    mail_email_address character varying,
    notification_type character varying NOT NULL,
    notification_status character varying,
    failure_type character varying,
    failure_reason text,
    is_read boolean,
    read_date timestamp without time zone,
    sms_id_int integer,
    sms_number character varying,
    letter_id integer,
    CONSTRAINT mail_notification_notification_partner_or_email_required CHECK ((((notification_type)::text <> 'email'::text) OR (failure_type IS NOT NULL) OR (res_partner_id IS NOT NULL) OR ((COALESCE(mail_email_address, ''::character varying))::text <> ''::text))),
    CONSTRAINT mail_notification_notification_partner_required CHECK ((((notification_type)::text <> 'inbox'::text) OR (res_partner_id IS NOT NULL)))
);


ALTER TABLE public.mail_notification OWNER TO runbot;

--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification IS 'Message Notifications';


--
-- Name: COLUMN mail_notification.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.author_id IS 'Author';


--
-- Name: COLUMN mail_notification.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_notification.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mail_notification.res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.res_partner_id IS 'Recipient';


--
-- Name: COLUMN mail_notification.mail_email_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_email_address IS 'Mail Email Address';


--
-- Name: COLUMN mail_notification.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_notification.notification_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_status IS 'Status';


--
-- Name: COLUMN mail_notification.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_notification.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.is_read IS 'Is Read';


--
-- Name: COLUMN mail_notification.read_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.read_date IS 'Read Date';


--
-- Name: COLUMN mail_notification.sms_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_id_int IS 'SMS ID';


--
-- Name: COLUMN mail_notification.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_number IS 'SMS Number';


--
-- Name: COLUMN mail_notification.letter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.letter_id IS 'Snailmail Letter';


--
-- Name: CONSTRAINT mail_notification_notification_partner_or_email_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_or_email_required ON public.mail_notification IS 'CHECK(notification_type != ''email'' OR failure_type IS NOT NULL OR res_partner_id IS NOT NULL OR COALESCE(mail_email_address, '''') != '''')';


--
-- Name: CONSTRAINT mail_notification_notification_partner_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_required ON public.mail_notification IS 'CHECK(notification_type != ''inbox'' OR res_partner_id IS NOT NULL)';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_notification_id_seq OWNER TO runbot;

--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_notification_id_seq OWNED BY public.mail_notification.id;


--
-- Name: mail_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_presence (
    id integer NOT NULL,
    user_id integer,
    guest_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    CONSTRAINT mail_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_presence OWNER TO runbot;

--
-- Name: TABLE mail_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_presence IS 'User/Guest Presence';


--
-- Name: COLUMN mail_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.user_id IS 'Users';


--
-- Name: COLUMN mail_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.guest_id IS 'Guest';


--
-- Name: COLUMN mail_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.status IS 'IM Status';


--
-- Name: COLUMN mail_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN mail_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.last_presence IS 'Last Presence';


--
-- Name: CONSTRAINT mail_presence_partner_or_guest_exists ON mail_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_presence_partner_or_guest_exists ON public.mail_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_presence_id_seq OWNER TO runbot;

--
-- Name: mail_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_presence_id_seq OWNED BY public.mail_presence.id;


--
-- Name: mail_push; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push (
    id integer NOT NULL,
    mail_push_device_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payload text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push OWNER TO runbot;

--
-- Name: TABLE mail_push; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push IS 'Push Notifications';


--
-- Name: COLUMN mail_push.mail_push_device_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.mail_push_device_id IS 'devices';


--
-- Name: COLUMN mail_push.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push.payload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.payload IS 'Payload';


--
-- Name: COLUMN mail_push.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_date IS 'Created on';


--
-- Name: COLUMN mail_push.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_date IS 'Last Updated on';


--
-- Name: mail_push_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push_device (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    endpoint character varying NOT NULL,
    keys character varying NOT NULL,
    expiration_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push_device OWNER TO runbot;

--
-- Name: TABLE mail_push_device; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push_device IS 'Push Notification Device';


--
-- Name: COLUMN mail_push_device.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.partner_id IS 'Partner';


--
-- Name: COLUMN mail_push_device.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push_device.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push_device.endpoint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.endpoint IS 'Browser endpoint';


--
-- Name: COLUMN mail_push_device.keys; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.keys IS 'Browser keys';


--
-- Name: COLUMN mail_push_device.expiration_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.expiration_time IS 'Expiration Token Date';


--
-- Name: COLUMN mail_push_device.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_date IS 'Created on';


--
-- Name: COLUMN mail_push_device.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_date IS 'Last Updated on';


--
-- Name: mail_push_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_device_id_seq OWNER TO runbot;

--
-- Name: mail_push_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_device_id_seq OWNED BY public.mail_push_device.id;


--
-- Name: mail_push_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_id_seq OWNER TO runbot;

--
-- Name: mail_push_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_id_seq OWNED BY public.mail_push.id;


--
-- Name: mail_scheduled_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message (
    id integer NOT NULL,
    res_id integer NOT NULL,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subject character varying,
    composition_comment_option character varying,
    model character varying NOT NULL,
    send_context jsonb,
    body text,
    notification_parameters text,
    is_note boolean,
    scheduled_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_scheduled_message OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message IS 'Scheduled Message';


--
-- Name: COLUMN mail_scheduled_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.res_id IS 'Related Document Id';


--
-- Name: COLUMN mail_scheduled_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.author_id IS 'Author';


--
-- Name: COLUMN mail_scheduled_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_scheduled_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_scheduled_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.subject IS 'Subject';


--
-- Name: COLUMN mail_scheduled_message.composition_comment_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.composition_comment_option IS 'Comment Options';


--
-- Name: COLUMN mail_scheduled_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_scheduled_message.send_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.send_context IS 'Sending Context';


--
-- Name: COLUMN mail_scheduled_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.body IS 'Contents';


--
-- Name: COLUMN mail_scheduled_message.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.notification_parameters IS 'Notification parameters';


--
-- Name: COLUMN mail_scheduled_message.is_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.is_note IS 'Is a note';


--
-- Name: COLUMN mail_scheduled_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_scheduled_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_scheduled_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_date IS 'Last Updated on';


--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_scheduled_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNER TO runbot;

--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNED BY public.mail_scheduled_message.id;


--
-- Name: mail_scheduled_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message_res_partner_rel (
    mail_scheduled_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_scheduled_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message_res_partner_rel IS 'RELATION BETWEEN mail_scheduled_message AND res_partner';


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    model_id integer,
    user_id integer,
    mail_server_id integer,
    ref_ir_act_window integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    email_from character varying,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    scheduled_date character varying,
    name jsonb,
    description jsonb,
    subject jsonb,
    body_html jsonb,
    active boolean,
    use_default_to boolean,
    auto_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template OWNER TO runbot;

--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.user_id IS 'Owner';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_from IS 'Send From';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_template.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.description IS 'Template Description';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.active IS 'Active';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default Recipients';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_id_seq OWNER TO runbot;

--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_template_ir_actions_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_ir_actions_report_rel (
    mail_template_id integer NOT NULL,
    ir_actions_report_id integer NOT NULL
);


ALTER TABLE public.mail_template_ir_actions_report_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_ir_actions_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_ir_actions_report_rel IS 'RELATION BETWEEN mail_template AND ir_act_report_xml';


--
-- Name: mail_template_mail_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_mail_template_reset_rel (
    mail_template_reset_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_template_mail_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_mail_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_mail_template_reset_rel IS 'RELATION BETWEEN mail_template_reset AND mail_template';


--
-- Name: mail_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_preview (
    id integer NOT NULL,
    mail_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    lang character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_preview OWNER TO runbot;

--
-- Name: TABLE mail_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN mail_template_preview.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.mail_template_id IS 'Related Mail Template';


--
-- Name: COLUMN mail_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.resource_ref IS 'Record';


--
-- Name: COLUMN mail_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN mail_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_date IS 'Last Updated on';


--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_preview_id_seq OWNER TO runbot;

--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_preview_id_seq OWNED BY public.mail_template_preview.id;


--
-- Name: mail_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_reset OWNER TO runbot;

--
-- Name: TABLE mail_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_reset IS 'Mail Template Reset';


--
-- Name: COLUMN mail_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_date IS 'Last Updated on';


--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_reset_id_seq OWNER TO runbot;

--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_reset_id_seq OWNED BY public.mail_template_reset.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field_id integer,
    old_value_integer integer,
    new_value_integer integer,
    currency_id integer,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    old_value_char character varying,
    new_value_char character varying,
    field_info jsonb,
    old_value_text text,
    new_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    old_value_float double precision,
    new_value_float double precision
);


ALTER TABLE public.mail_tracking_value OWNER TO runbot;

--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_id IS 'Field';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.currency_id IS 'Currency';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.field_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_info IS 'Removed field information';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_tracking_value_id_seq OWNER TO runbot;

--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: orm_signaling_assets; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_assets (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_assets OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_assets_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNED BY public.orm_signaling_assets.id;


--
-- Name: orm_signaling_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_default (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_default OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_default_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_default_id_seq OWNED BY public.orm_signaling_default.id;


--
-- Name: orm_signaling_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_groups (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_groups OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNED BY public.orm_signaling_groups.id;


--
-- Name: orm_signaling_registry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_registry (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_registry OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_registry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNED BY public.orm_signaling_registry.id;


--
-- Name: orm_signaling_routing; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_routing (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_routing OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_routing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNED BY public.orm_signaling_routing.id;


--
-- Name: orm_signaling_stable; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_stable (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_stable OWNER TO runbot;

--
-- Name: orm_signaling_stable_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_stable_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_stable_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_stable_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_stable_id_seq OWNED BY public.orm_signaling_stable.id;


--
-- Name: orm_signaling_templates; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_templates (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_templates OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_templates_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNED BY public.orm_signaling_templates.id;


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    number character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist OWNER TO runbot;

--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: phone_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE phone_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist_remove IS 'Remove phone from blacklist';


--
-- Name: COLUMN phone_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist_remove.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.phone IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN phone_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNED BY public.phone_blacklist_remove.id;


--
-- Name: picking_label_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.picking_label_type (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label_type character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.picking_label_type OWNER TO runbot;

--
-- Name: TABLE picking_label_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.picking_label_type IS 'Choose whether to print product or lot/sn labels';


--
-- Name: COLUMN picking_label_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.picking_label_type.create_uid IS 'Created by';


--
-- Name: COLUMN picking_label_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.picking_label_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN picking_label_type.label_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.picking_label_type.label_type IS 'Labels to print';


--
-- Name: COLUMN picking_label_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.picking_label_type.create_date IS 'Created on';


--
-- Name: COLUMN picking_label_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.picking_label_type.write_date IS 'Last Updated on';


--
-- Name: picking_label_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.picking_label_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.picking_label_type_id_seq OWNER TO runbot;

--
-- Name: picking_label_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.picking_label_type_id_seq OWNED BY public.picking_label_type.id;


--
-- Name: picking_label_type_stock_picking_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.picking_label_type_stock_picking_rel (
    picking_label_type_id integer NOT NULL,
    stock_picking_id integer NOT NULL
);


ALTER TABLE public.picking_label_type_stock_picking_rel OWNER TO runbot;

--
-- Name: TABLE picking_label_type_stock_picking_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.picking_label_type_stock_picking_rel IS 'RELATION BETWEEN picking_label_type AND stock_picking';


--
-- Name: picking_type_favorite_user_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.picking_type_favorite_user_rel (
    picking_type_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.picking_type_favorite_user_rel OWNER TO runbot;

--
-- Name: TABLE picking_type_favorite_user_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.picking_type_favorite_user_rel IS 'RELATION BETWEEN stock_picking_type AND res_users';


--
-- Name: portal_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share (
    id integer NOT NULL,
    res_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_share OWNER TO runbot;

--
-- Name: TABLE portal_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share IS 'Portal Sharing';


--
-- Name: COLUMN portal_share.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_id IS 'Related Document ID';


--
-- Name: COLUMN portal_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_uid IS 'Created by';


--
-- Name: COLUMN portal_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_share.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_model IS 'Related Document Model';


--
-- Name: COLUMN portal_share.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.note IS 'Note';


--
-- Name: COLUMN portal_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_date IS 'Created on';


--
-- Name: COLUMN portal_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_date IS 'Last Updated on';


--
-- Name: portal_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_share_id_seq OWNER TO runbot;

--
-- Name: portal_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_share_id_seq OWNED BY public.portal_share.id;


--
-- Name: portal_share_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share_res_partner_rel (
    portal_share_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_share_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_share_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share_res_partner_rel IS 'RELATION BETWEEN portal_share AND res_partner';


--
-- Name: portal_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    welcome_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard OWNER TO runbot;

--
-- Name: TABLE portal_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard IS 'Grant Portal Access';


--
-- Name: COLUMN portal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard.welcome_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.welcome_message IS 'Invitation Message';


--
-- Name: COLUMN portal_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_id_seq OWNED BY public.portal_wizard.id;


--
-- Name: portal_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_res_partner_rel (
    portal_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_res_partner_rel IS 'RELATION BETWEEN portal_wizard AND res_partner';


--
-- Name: portal_wizard_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard_user OWNER TO runbot;

--
-- Name: TABLE portal_wizard_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_user IS 'Portal User Config';


--
-- Name: COLUMN portal_wizard_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN portal_wizard_user.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.partner_id IS 'Contact';


--
-- Name: COLUMN portal_wizard_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard_user.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.email IS 'Email';


--
-- Name: COLUMN portal_wizard_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_user_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_user_id_seq OWNED BY public.portal_wizard_user.id;


--
-- Name: privacy_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    anonymized_name character varying NOT NULL,
    anonymized_email character varying NOT NULL,
    execution_details text,
    records_description text,
    additional_note text,
    date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_log OWNER TO runbot;

--
-- Name: TABLE privacy_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_log IS 'Privacy Log';


--
-- Name: COLUMN privacy_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.user_id IS 'Handled By';


--
-- Name: COLUMN privacy_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_log.anonymized_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_name IS 'Anonymized Name';


--
-- Name: COLUMN privacy_log.anonymized_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_email IS 'Anonymized Email';


--
-- Name: COLUMN privacy_log.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_log.records_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.records_description IS 'Found Records';


--
-- Name: COLUMN privacy_log.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.additional_note IS 'Additional Note';


--
-- Name: COLUMN privacy_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.date IS 'Date';


--
-- Name: COLUMN privacy_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_date IS 'Created on';


--
-- Name: COLUMN privacy_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_date IS 'Last Updated on';


--
-- Name: privacy_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_log_id_seq OWNER TO runbot;

--
-- Name: privacy_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_log_id_seq OWNED BY public.privacy_log.id;


--
-- Name: privacy_lookup_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard (
    id integer NOT NULL,
    log_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    email character varying NOT NULL,
    execution_details text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard IS 'Privacy Lookup Wizard';


--
-- Name: COLUMN privacy_lookup_wizard.log_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.log_id IS 'Log';


--
-- Name: COLUMN privacy_lookup_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.name IS 'Name';


--
-- Name: COLUMN privacy_lookup_wizard.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.email IS 'Email';


--
-- Name: COLUMN privacy_lookup_wizard.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNED BY public.privacy_lookup_wizard.id;


--
-- Name: privacy_lookup_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard_line (
    id integer NOT NULL,
    wizard_id integer,
    res_id integer NOT NULL,
    res_model_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    execution_details character varying,
    has_active boolean,
    is_active boolean,
    is_unlinked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard_line OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard_line IS 'Privacy Lookup Wizard Line';


--
-- Name: COLUMN privacy_lookup_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_id IS 'Resource ID';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_name IS 'Resource name';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model IS 'Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard_line.has_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.has_active IS 'Has Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_active IS 'Is Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_unlinked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_unlinked IS 'Is Unlinked';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNED BY public.privacy_lookup_wizard_line.id;


--
-- Name: product_attr_exclusion_value_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attr_exclusion_value_ids_rel (
    product_template_attribute_exclusion_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


ALTER TABLE public.product_attr_exclusion_value_ids_rel OWNER TO runbot;

--
-- Name: TABLE product_attr_exclusion_value_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attr_exclusion_value_ids_rel IS 'RELATION BETWEEN product_template_attribute_exclusion AND product_template_attribute_value';


--
-- Name: product_attribute; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_variant character varying NOT NULL,
    display_type character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT product_attribute_check_multi_checkbox_no_variant CHECK ((((display_type)::text <> 'multi'::text) OR ((create_variant)::text = 'no_variant'::text)))
);


ALTER TABLE public.product_attribute OWNER TO runbot;

--
-- Name: TABLE product_attribute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute IS 'Product Attribute';


--
-- Name: COLUMN product_attribute.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute.create_variant; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_variant IS 'Variant Creation';


--
-- Name: COLUMN product_attribute.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.display_type IS 'Display Type';


--
-- Name: COLUMN product_attribute.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.name IS 'Attribute';


--
-- Name: COLUMN product_attribute.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.active IS 'Active';


--
-- Name: COLUMN product_attribute.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT product_attribute_check_multi_checkbox_no_variant ON product_attribute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT product_attribute_check_multi_checkbox_no_variant ON public.product_attribute IS 'CHECK(display_type != ''multi'' OR create_variant = ''no_variant'')';


--
-- Name: product_attribute_custom_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_custom_value (
    id integer NOT NULL,
    custom_product_template_attribute_value_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    custom_value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_attribute_custom_value OWNER TO runbot;

--
-- Name: TABLE product_attribute_custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_custom_value IS 'Product Attribute Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.custom_product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_custom_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_custom_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_custom_value.custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_value IS 'Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_custom_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_date IS 'Last Updated on';


--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_custom_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_custom_value_id_seq OWNER TO runbot;

--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_custom_value_id_seq OWNED BY public.product_attribute_custom_value.id;


--
-- Name: product_attribute_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_id_seq OWNER TO runbot;

--
-- Name: product_attribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_id_seq OWNED BY public.product_attribute.id;


--
-- Name: product_attribute_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_product_template_rel (
    product_attribute_id integer NOT NULL,
    product_template_id integer NOT NULL
);


ALTER TABLE public.product_attribute_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_attribute_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_product_template_rel IS 'RELATION BETWEEN product_attribute AND product_template';


--
-- Name: product_attribute_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_value (
    id integer NOT NULL,
    sequence integer,
    attribute_id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    html_color character varying,
    name jsonb NOT NULL,
    is_custom boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    default_extra_price double precision
);


ALTER TABLE public.product_attribute_value OWNER TO runbot;

--
-- Name: TABLE product_attribute_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_value IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_value.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute_value.attribute_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_attribute_value.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.color IS 'Color Index';


--
-- Name: COLUMN product_attribute_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_value.html_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.html_color IS 'Color';


--
-- Name: COLUMN product_attribute_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.name IS 'Value';


--
-- Name: COLUMN product_attribute_value.is_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.is_custom IS 'Free text';


--
-- Name: COLUMN product_attribute_value.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.active IS 'Active';


--
-- Name: COLUMN product_attribute_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute_value.default_extra_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_value.default_extra_price IS 'Default Extra Price';


--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_value_id_seq OWNER TO runbot;

--
-- Name: product_attribute_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_value_id_seq OWNED BY public.product_attribute_value.id;


--
-- Name: product_attribute_value_product_template_attribute_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_value_product_template_attribute_line_rel (
    product_attribute_value_id integer NOT NULL,
    product_template_attribute_line_id integer NOT NULL
);


ALTER TABLE public.product_attribute_value_product_template_attribute_line_rel OWNER TO runbot;

--
-- Name: TABLE product_attribute_value_product_template_attribute_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_value_product_template_attribute_line_rel IS 'RELATION BETWEEN product_attribute_value AND product_template_attribute_line';


--
-- Name: product_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_category (
    id integer NOT NULL,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    parent_path character varying,
    product_properties_definition jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    removal_strategy_id integer,
    packaging_reserve_method character varying
);


ALTER TABLE public.product_category OWNER TO runbot;

--
-- Name: TABLE product_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_category IS 'Product Category';


--
-- Name: COLUMN product_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.parent_id IS 'Parent Category';


--
-- Name: COLUMN product_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.create_uid IS 'Created by';


--
-- Name: COLUMN product_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.name IS 'Name';


--
-- Name: COLUMN product_category.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.complete_name IS 'Complete Name';


--
-- Name: COLUMN product_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN product_category.product_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.product_properties_definition IS 'Product Properties';


--
-- Name: COLUMN product_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.create_date IS 'Created on';


--
-- Name: COLUMN product_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_category.removal_strategy_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.removal_strategy_id IS 'Force Removal Strategy';


--
-- Name: COLUMN product_category.packaging_reserve_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_category.packaging_reserve_method IS 'Reserve Packagings';


--
-- Name: product_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_category_id_seq OWNER TO runbot;

--
-- Name: product_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_category_id_seq OWNED BY public.product_category.id;


--
-- Name: product_combo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_combo (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_combo OWNER TO runbot;

--
-- Name: TABLE product_combo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_combo IS 'Product Combo';


--
-- Name: COLUMN product_combo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo.sequence IS 'Sequence';


--
-- Name: COLUMN product_combo.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo.company_id IS 'Company';


--
-- Name: COLUMN product_combo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo.create_uid IS 'Created by';


--
-- Name: COLUMN product_combo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_combo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo.name IS 'Name';


--
-- Name: COLUMN product_combo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo.create_date IS 'Created on';


--
-- Name: COLUMN product_combo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo.write_date IS 'Last Updated on';


--
-- Name: product_combo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_combo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_combo_id_seq OWNER TO runbot;

--
-- Name: product_combo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_combo_id_seq OWNED BY public.product_combo.id;


--
-- Name: product_combo_item; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_combo_item (
    id integer NOT NULL,
    company_id integer,
    combo_id integer NOT NULL,
    product_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    extra_price numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_combo_item OWNER TO runbot;

--
-- Name: TABLE product_combo_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_combo_item IS 'Product Combo Item';


--
-- Name: COLUMN product_combo_item.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo_item.company_id IS 'Company';


--
-- Name: COLUMN product_combo_item.combo_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo_item.combo_id IS 'Combo';


--
-- Name: COLUMN product_combo_item.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo_item.product_id IS 'Options';


--
-- Name: COLUMN product_combo_item.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo_item.create_uid IS 'Created by';


--
-- Name: COLUMN product_combo_item.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_combo_item.extra_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo_item.extra_price IS 'Extra Price';


--
-- Name: COLUMN product_combo_item.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo_item.create_date IS 'Created on';


--
-- Name: COLUMN product_combo_item.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_combo_item.write_date IS 'Last Updated on';


--
-- Name: product_combo_item_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_combo_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_combo_item_id_seq OWNER TO runbot;

--
-- Name: product_combo_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_combo_item_id_seq OWNED BY public.product_combo_item.id;


--
-- Name: product_combo_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_combo_product_template_rel (
    product_template_id integer NOT NULL,
    product_combo_id integer NOT NULL
);


ALTER TABLE public.product_combo_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_combo_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_combo_product_template_rel IS 'RELATION BETWEEN product_template AND product_combo';


--
-- Name: product_document; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_document (
    id integer NOT NULL,
    ir_attachment_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_document OWNER TO runbot;

--
-- Name: TABLE product_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_document IS 'Product Document';


--
-- Name: COLUMN product_document.ir_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_document.ir_attachment_id IS 'Related attachment';


--
-- Name: COLUMN product_document.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_document.sequence IS 'Sequence';


--
-- Name: COLUMN product_document.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_document.create_uid IS 'Created by';


--
-- Name: COLUMN product_document.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_document.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_document.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_document.active IS 'Active';


--
-- Name: COLUMN product_document.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_document.create_date IS 'Created on';


--
-- Name: COLUMN product_document.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_document.write_date IS 'Last Updated on';


--
-- Name: product_document_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_document_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_document_id_seq OWNER TO runbot;

--
-- Name: product_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_document_id_seq OWNED BY public.product_document.id;


--
-- Name: product_fetch_image_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_fetch_image_wizard (
    id integer NOT NULL,
    nb_products_selected integer,
    nb_products_to_process integer,
    nb_products_unable_to_process integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_fetch_image_wizard OWNER TO runbot;

--
-- Name: TABLE product_fetch_image_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_fetch_image_wizard IS 'Fetch product images from Barcode Lookup based on the product''s barcode.';


--
-- Name: COLUMN product_fetch_image_wizard.nb_products_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_fetch_image_wizard.nb_products_selected IS 'Number of selected products';


--
-- Name: COLUMN product_fetch_image_wizard.nb_products_to_process; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_fetch_image_wizard.nb_products_to_process IS 'Number of products to process';


--
-- Name: COLUMN product_fetch_image_wizard.nb_products_unable_to_process; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_fetch_image_wizard.nb_products_unable_to_process IS 'Number of product unprocessable';


--
-- Name: COLUMN product_fetch_image_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_fetch_image_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN product_fetch_image_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_fetch_image_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_fetch_image_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_fetch_image_wizard.create_date IS 'Created on';


--
-- Name: COLUMN product_fetch_image_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_fetch_image_wizard.write_date IS 'Last Updated on';


--
-- Name: product_fetch_image_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_fetch_image_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_fetch_image_wizard_id_seq OWNER TO runbot;

--
-- Name: product_fetch_image_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_fetch_image_wizard_id_seq OWNED BY public.product_fetch_image_wizard.id;


--
-- Name: product_fetch_image_wizard_product_product_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_fetch_image_wizard_product_product_rel (
    product_fetch_image_wizard_id integer NOT NULL,
    product_product_id integer NOT NULL
);


ALTER TABLE public.product_fetch_image_wizard_product_product_rel OWNER TO runbot;

--
-- Name: TABLE product_fetch_image_wizard_product_product_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_fetch_image_wizard_product_product_rel IS 'RELATION BETWEEN product_fetch_image_wizard AND product_product';


--
-- Name: product_label_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout (
    id integer NOT NULL,
    custom_quantity integer NOT NULL,
    pricelist_id integer,
    create_uid integer,
    write_uid integer,
    print_format character varying NOT NULL,
    extra_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    move_quantity character varying NOT NULL,
    zpl_template character varying NOT NULL
);


ALTER TABLE public.product_label_layout OWNER TO runbot;

--
-- Name: TABLE product_label_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout IS 'Choose the sheet layout to print the labels';


--
-- Name: COLUMN product_label_layout.custom_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.custom_quantity IS 'Copies';


--
-- Name: COLUMN product_label_layout.pricelist_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN product_label_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.create_uid IS 'Created by';


--
-- Name: COLUMN product_label_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_label_layout.print_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.print_format IS 'Format';


--
-- Name: COLUMN product_label_layout.extra_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.extra_html IS 'Extra Content';


--
-- Name: COLUMN product_label_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.create_date IS 'Created on';


--
-- Name: COLUMN product_label_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_label_layout.move_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.move_quantity IS 'Quantity to print';


--
-- Name: COLUMN product_label_layout.zpl_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_label_layout.zpl_template IS 'ZPL Template';


--
-- Name: product_label_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_label_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_label_layout_id_seq OWNER TO runbot;

--
-- Name: product_label_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_label_layout_id_seq OWNED BY public.product_label_layout.id;


--
-- Name: product_label_layout_product_product_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout_product_product_rel (
    product_label_layout_id integer NOT NULL,
    product_product_id integer NOT NULL
);


ALTER TABLE public.product_label_layout_product_product_rel OWNER TO runbot;

--
-- Name: TABLE product_label_layout_product_product_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout_product_product_rel IS 'RELATION BETWEEN product_label_layout AND product_product';


--
-- Name: product_label_layout_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout_product_template_rel (
    product_label_layout_id integer NOT NULL,
    product_template_id integer NOT NULL
);


ALTER TABLE public.product_label_layout_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_label_layout_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout_product_template_rel IS 'RELATION BETWEEN product_label_layout AND product_template';


--
-- Name: product_label_layout_stock_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_label_layout_stock_move_rel (
    product_label_layout_id integer NOT NULL,
    stock_move_id integer NOT NULL
);


ALTER TABLE public.product_label_layout_stock_move_rel OWNER TO runbot;

--
-- Name: TABLE product_label_layout_stock_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_label_layout_stock_move_rel IS 'RELATION BETWEEN product_label_layout AND stock_move';


--
-- Name: product_pricelist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_pricelist (
    id integer NOT NULL,
    sequence integer,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_pricelist OWNER TO runbot;

--
-- Name: TABLE product_pricelist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_pricelist IS 'Pricelist';


--
-- Name: COLUMN product_pricelist.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.sequence IS 'Sequence';


--
-- Name: COLUMN product_pricelist.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.currency_id IS 'Currency';


--
-- Name: COLUMN product_pricelist.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.name IS 'Pricelist Name';


--
-- Name: COLUMN product_pricelist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.active IS 'Active';


--
-- Name: COLUMN product_pricelist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist.write_date IS 'Last Updated on';


--
-- Name: product_pricelist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_pricelist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_pricelist_id_seq OWNER TO runbot;

--
-- Name: product_pricelist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_pricelist_id_seq OWNED BY public.product_pricelist.id;


--
-- Name: product_pricelist_item; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_pricelist_item (
    id integer NOT NULL,
    pricelist_id integer,
    company_id integer,
    currency_id integer,
    categ_id integer,
    product_tmpl_id integer,
    product_id integer,
    base_pricelist_id integer,
    create_uid integer,
    write_uid integer,
    applied_on character varying NOT NULL,
    display_applied_on character varying NOT NULL,
    base character varying NOT NULL,
    compute_price character varying NOT NULL,
    min_quantity numeric,
    fixed_price numeric,
    price_discount numeric,
    price_round numeric,
    price_surcharge numeric,
    price_markup numeric,
    price_min_margin numeric,
    price_max_margin numeric,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percent_price double precision
);


ALTER TABLE public.product_pricelist_item OWNER TO runbot;

--
-- Name: TABLE product_pricelist_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_pricelist_item IS 'Pricelist Rule';


--
-- Name: COLUMN product_pricelist_item.pricelist_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN product_pricelist_item.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.company_id IS 'Company';


--
-- Name: COLUMN product_pricelist_item.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.currency_id IS 'Currency';


--
-- Name: COLUMN product_pricelist_item.categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.categ_id IS 'Category';


--
-- Name: COLUMN product_pricelist_item.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.product_tmpl_id IS 'Product';


--
-- Name: COLUMN product_pricelist_item.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.product_id IS 'Variant';


--
-- Name: COLUMN product_pricelist_item.base_pricelist_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.base_pricelist_id IS 'Other Pricelist';


--
-- Name: COLUMN product_pricelist_item.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.create_uid IS 'Created by';


--
-- Name: COLUMN product_pricelist_item.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_pricelist_item.applied_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.applied_on IS 'Apply On';


--
-- Name: COLUMN product_pricelist_item.display_applied_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.display_applied_on IS 'Display Applied On';


--
-- Name: COLUMN product_pricelist_item.base; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.base IS 'Based on';


--
-- Name: COLUMN product_pricelist_item.compute_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.compute_price IS 'Compute Price';


--
-- Name: COLUMN product_pricelist_item.min_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.min_quantity IS 'Min. Quantity';


--
-- Name: COLUMN product_pricelist_item.fixed_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.fixed_price IS 'Fixed Price';


--
-- Name: COLUMN product_pricelist_item.price_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_discount IS 'Price Discount';


--
-- Name: COLUMN product_pricelist_item.price_round; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_round IS 'Price Rounding';


--
-- Name: COLUMN product_pricelist_item.price_surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_surcharge IS 'Extra Fee';


--
-- Name: COLUMN product_pricelist_item.price_markup; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_markup IS 'Markup';


--
-- Name: COLUMN product_pricelist_item.price_min_margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_min_margin IS 'Min. Price Margin';


--
-- Name: COLUMN product_pricelist_item.price_max_margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.price_max_margin IS 'Max. Price Margin';


--
-- Name: COLUMN product_pricelist_item.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.date_start IS 'Start Date';


--
-- Name: COLUMN product_pricelist_item.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.date_end IS 'End Date';


--
-- Name: COLUMN product_pricelist_item.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.create_date IS 'Created on';


--
-- Name: COLUMN product_pricelist_item.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_pricelist_item.percent_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_pricelist_item.percent_price IS 'Percentage Price';


--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_pricelist_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_pricelist_item_id_seq OWNER TO runbot;

--
-- Name: product_pricelist_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_pricelist_item_id_seq OWNED BY public.product_pricelist_item.id;


--
-- Name: product_product; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_product (
    id integer NOT NULL,
    product_tmpl_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    default_code character varying,
    barcode character varying,
    combination_indices character varying,
    standard_price jsonb,
    volume numeric,
    weight numeric,
    active boolean,
    can_image_variant_1024_be_zoomed boolean,
    is_favorite boolean,
    is_in_selected_section_of_order boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone,
    is_image_fetch_pending boolean,
    lot_properties_definition jsonb
);


ALTER TABLE public.product_product OWNER TO runbot;

--
-- Name: TABLE product_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_product IS 'Product Variant';


--
-- Name: COLUMN product_product.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_product.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.create_uid IS 'Created by';


--
-- Name: COLUMN product_product.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_product.default_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.default_code IS 'Internal Reference';


--
-- Name: COLUMN product_product.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.barcode IS 'Barcode';


--
-- Name: COLUMN product_product.combination_indices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.combination_indices IS 'Combination Indices';


--
-- Name: COLUMN product_product.standard_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.standard_price IS 'Cost';


--
-- Name: COLUMN product_product.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.volume IS 'Volume';


--
-- Name: COLUMN product_product.weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.weight IS 'Weight';


--
-- Name: COLUMN product_product.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.active IS 'Active';


--
-- Name: COLUMN product_product.can_image_variant_1024_be_zoomed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.can_image_variant_1024_be_zoomed IS 'Can Variant Image 1024 be zoomed';


--
-- Name: COLUMN product_product.is_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.is_favorite IS 'Favorite';


--
-- Name: COLUMN product_product.is_in_selected_section_of_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.is_in_selected_section_of_order IS 'Is In Selected Section Of Order';


--
-- Name: COLUMN product_product.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.write_date IS 'Write Date';


--
-- Name: COLUMN product_product.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.create_date IS 'Created on';


--
-- Name: COLUMN product_product.is_image_fetch_pending; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.is_image_fetch_pending IS 'Is Image Fetch Pending';


--
-- Name: COLUMN product_product.lot_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_product.lot_properties_definition IS 'Lot Properties';


--
-- Name: product_product_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_product_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_product_id_seq OWNER TO runbot;

--
-- Name: product_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_product_id_seq OWNED BY public.product_product.id;


--
-- Name: product_removal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_removal (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    method jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_removal OWNER TO runbot;

--
-- Name: TABLE product_removal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_removal IS 'Removal Strategy';


--
-- Name: COLUMN product_removal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.create_uid IS 'Created by';


--
-- Name: COLUMN product_removal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_removal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.name IS 'Name';


--
-- Name: COLUMN product_removal.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.method IS 'Method';


--
-- Name: COLUMN product_removal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.create_date IS 'Created on';


--
-- Name: COLUMN product_removal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_removal.write_date IS 'Last Updated on';


--
-- Name: product_removal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_removal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_removal_id_seq OWNER TO runbot;

--
-- Name: product_removal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_removal_id_seq OWNED BY public.product_removal.id;


--
-- Name: product_replenish; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_replenish (
    id integer NOT NULL,
    route_id integer,
    product_id integer NOT NULL,
    product_tmpl_id integer NOT NULL,
    product_uom_id integer NOT NULL,
    warehouse_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    product_has_variants boolean NOT NULL,
    date_planned timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    quantity double precision NOT NULL
);


ALTER TABLE public.product_replenish OWNER TO runbot;

--
-- Name: TABLE product_replenish; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_replenish IS 'Product Replenish';


--
-- Name: COLUMN product_replenish.route_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.route_id IS 'Preferred Route';


--
-- Name: COLUMN product_replenish.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.product_id IS 'Product';


--
-- Name: COLUMN product_replenish.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_replenish.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.product_uom_id IS 'Unity of measure';


--
-- Name: COLUMN product_replenish.warehouse_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN product_replenish.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.company_id IS 'Company';


--
-- Name: COLUMN product_replenish.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.create_uid IS 'Created by';


--
-- Name: COLUMN product_replenish.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_replenish.product_has_variants; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.product_has_variants IS 'Has variants';


--
-- Name: COLUMN product_replenish.date_planned; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.date_planned IS 'Scheduled Date';


--
-- Name: COLUMN product_replenish.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.create_date IS 'Created on';


--
-- Name: COLUMN product_replenish.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_replenish.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_replenish.quantity IS 'Quantity';


--
-- Name: product_replenish_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_replenish_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_replenish_id_seq OWNER TO runbot;

--
-- Name: product_replenish_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_replenish_id_seq OWNED BY public.product_replenish.id;


--
-- Name: product_supplierinfo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_supplierinfo (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    sequence integer,
    product_uom_id integer NOT NULL,
    company_id integer,
    currency_id integer NOT NULL,
    product_id integer,
    product_tmpl_id integer NOT NULL,
    delay integer NOT NULL,
    create_uid integer,
    write_uid integer,
    product_name character varying,
    product_code character varying,
    date_start date,
    date_end date,
    min_qty numeric NOT NULL,
    price numeric,
    discount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_supplierinfo OWNER TO runbot;

--
-- Name: TABLE product_supplierinfo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_supplierinfo IS 'Supplier Pricelist';


--
-- Name: COLUMN product_supplierinfo.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.partner_id IS 'Vendor';


--
-- Name: COLUMN product_supplierinfo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.sequence IS 'Sequence';


--
-- Name: COLUMN product_supplierinfo.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_uom_id IS 'Unit';


--
-- Name: COLUMN product_supplierinfo.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.company_id IS 'Company';


--
-- Name: COLUMN product_supplierinfo.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.currency_id IS 'Currency';


--
-- Name: COLUMN product_supplierinfo.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_id IS 'Product Variant';


--
-- Name: COLUMN product_supplierinfo.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_supplierinfo.delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.delay IS 'Lead Time';


--
-- Name: COLUMN product_supplierinfo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.create_uid IS 'Created by';


--
-- Name: COLUMN product_supplierinfo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_supplierinfo.product_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_name IS 'Vendor Product Name';


--
-- Name: COLUMN product_supplierinfo.product_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.product_code IS 'Vendor Product Code';


--
-- Name: COLUMN product_supplierinfo.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.date_start IS 'Start Date';


--
-- Name: COLUMN product_supplierinfo.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.date_end IS 'End Date';


--
-- Name: COLUMN product_supplierinfo.min_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.min_qty IS 'Quantity';


--
-- Name: COLUMN product_supplierinfo.price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.price IS 'Unit Price';


--
-- Name: COLUMN product_supplierinfo.discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.discount IS 'Discount (%)';


--
-- Name: COLUMN product_supplierinfo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.create_date IS 'Created on';


--
-- Name: COLUMN product_supplierinfo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_supplierinfo.write_date IS 'Last Updated on';


--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_supplierinfo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_supplierinfo_id_seq OWNER TO runbot;

--
-- Name: product_supplierinfo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_supplierinfo_id_seq OWNED BY public.product_supplierinfo.id;


--
-- Name: product_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_tag (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    color character varying,
    name jsonb NOT NULL,
    visible_to_customers boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_tag OWNER TO runbot;

--
-- Name: TABLE product_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_tag IS 'Product Tag';


--
-- Name: COLUMN product_tag.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.sequence IS 'Sequence';


--
-- Name: COLUMN product_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.create_uid IS 'Created by';


--
-- Name: COLUMN product_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.color IS 'Color';


--
-- Name: COLUMN product_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.name IS 'Name';


--
-- Name: COLUMN product_tag.visible_to_customers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.visible_to_customers IS 'Visible to customers';


--
-- Name: COLUMN product_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.create_date IS 'Created on';


--
-- Name: COLUMN product_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_tag.write_date IS 'Last Updated on';


--
-- Name: product_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_tag_id_seq OWNER TO runbot;

--
-- Name: product_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_tag_id_seq OWNED BY public.product_tag.id;


--
-- Name: product_tag_product_product_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_tag_product_product_rel (
    product_product_id integer NOT NULL,
    product_tag_id integer NOT NULL
);


ALTER TABLE public.product_tag_product_product_rel OWNER TO runbot;

--
-- Name: TABLE product_tag_product_product_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_tag_product_product_rel IS 'RELATION BETWEEN product_product AND product_tag';


--
-- Name: product_tag_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_tag_product_template_rel (
    product_template_id integer NOT NULL,
    product_tag_id integer NOT NULL
);


ALTER TABLE public.product_tag_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_tag_product_template_rel IS 'RELATION BETWEEN product_template AND product_tag';


--
-- Name: product_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template (
    id integer NOT NULL,
    sequence integer,
    categ_id integer,
    uom_id integer NOT NULL,
    company_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    service_tracking character varying NOT NULL,
    default_code character varying,
    name jsonb NOT NULL,
    description jsonb,
    description_purchase jsonb,
    description_sale jsonb,
    product_properties jsonb,
    list_price numeric,
    volume numeric,
    weight numeric,
    sale_ok boolean,
    purchase_ok boolean,
    active boolean,
    can_image_1024_be_zoomed boolean,
    has_configurable_attributes boolean,
    is_favorite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sale_delay integer,
    lot_sequence_id integer,
    tracking character varying NOT NULL,
    responsible_id jsonb,
    property_stock_production jsonb,
    property_stock_inventory jsonb,
    description_picking jsonb,
    description_pickingout jsonb,
    description_pickingin jsonb,
    is_storable boolean
);


ALTER TABLE public.product_template OWNER TO runbot;

--
-- Name: TABLE product_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template IS 'Product';


--
-- Name: COLUMN product_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sequence IS 'Sequence';


--
-- Name: COLUMN product_template.categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.categ_id IS 'Product Category';


--
-- Name: COLUMN product_template.uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.uom_id IS 'Unit';


--
-- Name: COLUMN product_template.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.company_id IS 'Company';


--
-- Name: COLUMN product_template.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.color IS 'Color Index';


--
-- Name: COLUMN product_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.create_uid IS 'Created by';


--
-- Name: COLUMN product_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.type IS 'Product Type';


--
-- Name: COLUMN product_template.service_tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.service_tracking IS 'Create on Order';


--
-- Name: COLUMN product_template.default_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.default_code IS 'Internal Reference';


--
-- Name: COLUMN product_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.name IS 'Name';


--
-- Name: COLUMN product_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description IS 'Description';


--
-- Name: COLUMN product_template.description_purchase; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_purchase IS 'Purchase Description';


--
-- Name: COLUMN product_template.description_sale; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_sale IS 'Sales Description';


--
-- Name: COLUMN product_template.product_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.product_properties IS 'Properties';


--
-- Name: COLUMN product_template.list_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.list_price IS 'Sales Price';


--
-- Name: COLUMN product_template.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.volume IS 'Volume';


--
-- Name: COLUMN product_template.weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.weight IS 'Weight';


--
-- Name: COLUMN product_template.sale_ok; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sale_ok IS 'Sales';


--
-- Name: COLUMN product_template.purchase_ok; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.purchase_ok IS 'Purchase';


--
-- Name: COLUMN product_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.active IS 'Active';


--
-- Name: COLUMN product_template.can_image_1024_be_zoomed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.can_image_1024_be_zoomed IS 'Can Image 1024 be zoomed';


--
-- Name: COLUMN product_template.has_configurable_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.has_configurable_attributes IS 'Is a configurable product';


--
-- Name: COLUMN product_template.is_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.is_favorite IS 'Favorite';


--
-- Name: COLUMN product_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.create_date IS 'Created on';


--
-- Name: COLUMN product_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_template.sale_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.sale_delay IS 'Customer Lead Time';


--
-- Name: COLUMN product_template.lot_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.lot_sequence_id IS 'Serial/Lot Numbers Sequence';


--
-- Name: COLUMN product_template.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.tracking IS 'Tracking';


--
-- Name: COLUMN product_template.responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.responsible_id IS 'Responsible';


--
-- Name: COLUMN product_template.property_stock_production; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.property_stock_production IS 'Production Location';


--
-- Name: COLUMN product_template.property_stock_inventory; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.property_stock_inventory IS 'Inventory Location';


--
-- Name: COLUMN product_template.description_picking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_picking IS 'Description on Picking';


--
-- Name: COLUMN product_template.description_pickingout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_pickingout IS 'Description on Delivery Orders';


--
-- Name: COLUMN product_template.description_pickingin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.description_pickingin IS 'Description on Receptions';


--
-- Name: COLUMN product_template.is_storable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template.is_storable IS 'Track Inventory';


--
-- Name: product_template_attribute_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template_attribute_exclusion (
    id integer NOT NULL,
    product_template_attribute_value_id integer,
    product_tmpl_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_template_attribute_exclusion OWNER TO runbot;

--
-- Name: TABLE product_template_attribute_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template_attribute_exclusion IS 'Product Template Attribute Exclusion';


--
-- Name: COLUMN product_template_attribute_exclusion.product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_template_attribute_exclusion.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_exclusion.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_template_attribute_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_template_attribute_exclusion_id_seq OWNER TO runbot;

--
-- Name: product_template_attribute_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_template_attribute_exclusion_id_seq OWNED BY public.product_template_attribute_exclusion.id;


--
-- Name: product_template_attribute_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template_attribute_line (
    id integer NOT NULL,
    product_tmpl_id integer NOT NULL,
    sequence integer,
    attribute_id integer NOT NULL,
    value_count integer,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_template_attribute_line OWNER TO runbot;

--
-- Name: TABLE product_template_attribute_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template_attribute_line IS 'Product Template Attribute Line';


--
-- Name: COLUMN product_template_attribute_line.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.sequence IS 'Sequence';


--
-- Name: COLUMN product_template_attribute_line.attribute_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_template_attribute_line.value_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.value_count IS 'Value Count';


--
-- Name: COLUMN product_template_attribute_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_line.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.active IS 'Active';


--
-- Name: COLUMN product_template_attribute_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_line.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_template_attribute_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_template_attribute_line_id_seq OWNER TO runbot;

--
-- Name: product_template_attribute_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_template_attribute_line_id_seq OWNED BY public.product_template_attribute_line.id;


--
-- Name: product_template_attribute_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template_attribute_value (
    id integer NOT NULL,
    product_attribute_value_id integer NOT NULL,
    attribute_line_id integer NOT NULL,
    product_tmpl_id integer,
    attribute_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    price_extra numeric,
    ptav_active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_template_attribute_value OWNER TO runbot;

--
-- Name: TABLE product_template_attribute_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template_attribute_value IS 'Product Template Attribute Value';


--
-- Name: COLUMN product_template_attribute_value.product_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.product_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_template_attribute_value.attribute_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.attribute_line_id IS 'Attribute Line';


--
-- Name: COLUMN product_template_attribute_value.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN product_template_attribute_value.attribute_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.attribute_id IS 'Attribute';


--
-- Name: COLUMN product_template_attribute_value.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.color IS 'Color';


--
-- Name: COLUMN product_template_attribute_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_template_attribute_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_template_attribute_value.price_extra; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.price_extra IS 'Extra Price';


--
-- Name: COLUMN product_template_attribute_value.ptav_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.ptav_active IS 'Active';


--
-- Name: COLUMN product_template_attribute_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.create_date IS 'Created on';


--
-- Name: COLUMN product_template_attribute_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_template_attribute_value.write_date IS 'Last Updated on';


--
-- Name: product_template_attribute_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_template_attribute_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_template_attribute_value_id_seq OWNER TO runbot;

--
-- Name: product_template_attribute_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_template_attribute_value_id_seq OWNED BY public.product_template_attribute_value.id;


--
-- Name: product_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_template_id_seq OWNER TO runbot;

--
-- Name: product_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_template_id_seq OWNED BY public.product_template.id;


--
-- Name: product_template_uom_uom_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_template_uom_uom_rel (
    product_template_id integer NOT NULL,
    uom_uom_id integer NOT NULL
);


ALTER TABLE public.product_template_uom_uom_rel OWNER TO runbot;

--
-- Name: TABLE product_template_uom_uom_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_template_uom_uom_rel IS 'RELATION BETWEEN product_template AND uom_uom';


--
-- Name: product_uom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_uom (
    id integer NOT NULL,
    uom_id integer NOT NULL,
    product_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    barcode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.product_uom OWNER TO runbot;

--
-- Name: TABLE product_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_uom IS 'Link between products and their UoMs';


--
-- Name: COLUMN product_uom.uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_uom.uom_id IS 'Unit';


--
-- Name: COLUMN product_uom.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_uom.product_id IS 'Product';


--
-- Name: COLUMN product_uom.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_uom.company_id IS 'Company';


--
-- Name: COLUMN product_uom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_uom.create_uid IS 'Created by';


--
-- Name: COLUMN product_uom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_uom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_uom.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_uom.barcode IS 'Barcode';


--
-- Name: COLUMN product_uom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_uom.create_date IS 'Created on';


--
-- Name: COLUMN product_uom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_uom.write_date IS 'Last Updated on';


--
-- Name: product_uom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_uom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_uom_id_seq OWNER TO runbot;

--
-- Name: product_uom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_uom_id_seq OWNED BY public.product_uom.id;


--
-- Name: product_variant_combination; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_variant_combination (
    product_product_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


ALTER TABLE public.product_variant_combination OWNER TO runbot;

--
-- Name: TABLE product_variant_combination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_variant_combination IS 'RELATION BETWEEN product_product AND product_template_attribute_value';


--
-- Name: properties_base_definition; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.properties_base_definition (
    id integer NOT NULL,
    properties_field_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    properties_definition jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.properties_base_definition OWNER TO runbot;

--
-- Name: TABLE properties_base_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.properties_base_definition IS 'Properties Base Definition';


--
-- Name: COLUMN properties_base_definition.properties_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.properties_field_id IS 'Properties Field';


--
-- Name: COLUMN properties_base_definition.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.create_uid IS 'Created by';


--
-- Name: COLUMN properties_base_definition.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.write_uid IS 'Last Updated by';


--
-- Name: COLUMN properties_base_definition.properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.properties_definition IS 'Properties Definition';


--
-- Name: COLUMN properties_base_definition.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.create_date IS 'Created on';


--
-- Name: COLUMN properties_base_definition.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.write_date IS 'Last Updated on';


--
-- Name: properties_base_definition_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.properties_base_definition_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.properties_base_definition_id_seq OWNER TO runbot;

--
-- Name: properties_base_definition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.properties_base_definition_id_seq OWNED BY public.properties_base_definition.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_mimetypes; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_mimetypes (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying(64) NOT NULL,
    code character varying(16) NOT NULL,
    compatible_types character varying(128),
    filter_name character varying(128),
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_mimetypes OWNER TO runbot;

--
-- Name: TABLE report_mimetypes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_mimetypes IS 'Report Mime-Types';


--
-- Name: COLUMN report_mimetypes.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_mimetypes.create_uid IS 'Created by';


--
-- Name: COLUMN report_mimetypes.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_mimetypes.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_mimetypes.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_mimetypes.name IS 'Name';


--
-- Name: COLUMN report_mimetypes.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_mimetypes.code IS 'Code';


--
-- Name: COLUMN report_mimetypes.compatible_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_mimetypes.compatible_types IS 'Compatible Mime-Types';


--
-- Name: COLUMN report_mimetypes.filter_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_mimetypes.filter_name IS 'Filter Name';


--
-- Name: COLUMN report_mimetypes.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_mimetypes.create_date IS 'Created on';


--
-- Name: COLUMN report_mimetypes.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_mimetypes.write_date IS 'Last Updated on';


--
-- Name: report_mimetypes_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_mimetypes_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_mimetypes_id_seq OWNER TO runbot;

--
-- Name: report_mimetypes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_mimetypes_id_seq OWNED BY public.report_mimetypes.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    css_margins boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.css_margins; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.css_margins IS 'Use css margins';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: stock_location; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_location (
    id integer NOT NULL,
    location_id integer,
    company_id integer,
    removal_strategy_id integer,
    cyclic_inventory_frequency integer,
    warehouse_id integer,
    storage_category_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    usage character varying NOT NULL,
    parent_path character varying,
    barcode character varying,
    last_inventory_date date,
    next_inventory_date date,
    active boolean,
    replenish_location boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT stock_location_inventory_freq_nonneg CHECK ((cyclic_inventory_frequency >= 0))
);


ALTER TABLE public.stock_location OWNER TO runbot;

--
-- Name: TABLE stock_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_location IS 'Inventory Locations';


--
-- Name: COLUMN stock_location.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.location_id IS 'Parent Location';


--
-- Name: COLUMN stock_location.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.company_id IS 'Company';


--
-- Name: COLUMN stock_location.removal_strategy_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.removal_strategy_id IS 'Removal Strategy';


--
-- Name: COLUMN stock_location.cyclic_inventory_frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.cyclic_inventory_frequency IS 'Inventory Frequency';


--
-- Name: COLUMN stock_location.warehouse_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN stock_location.storage_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.storage_category_id IS 'Storage Category';


--
-- Name: COLUMN stock_location.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.create_uid IS 'Created by';


--
-- Name: COLUMN stock_location.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_location.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.name IS 'Location Name';


--
-- Name: COLUMN stock_location.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.complete_name IS 'Full Location Name';


--
-- Name: COLUMN stock_location.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.usage IS 'Location Type';


--
-- Name: COLUMN stock_location.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.parent_path IS 'Parent Path';


--
-- Name: COLUMN stock_location.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.barcode IS 'Barcode';


--
-- Name: COLUMN stock_location.last_inventory_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.last_inventory_date IS 'Last Inventory';


--
-- Name: COLUMN stock_location.next_inventory_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.next_inventory_date IS 'Next Expected';


--
-- Name: COLUMN stock_location.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.active IS 'Active';


--
-- Name: COLUMN stock_location.replenish_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.replenish_location IS 'Replenishments';


--
-- Name: COLUMN stock_location.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.create_date IS 'Created on';


--
-- Name: COLUMN stock_location.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_location.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT stock_location_inventory_freq_nonneg ON stock_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT stock_location_inventory_freq_nonneg ON public.stock_location IS 'check(cyclic_inventory_frequency >= 0)';


--
-- Name: stock_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_move (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    product_id integer NOT NULL,
    product_uom integer NOT NULL,
    location_id integer NOT NULL,
    location_dest_id integer NOT NULL,
    location_final_id integer,
    partner_id integer,
    picking_id integer,
    scrap_id integer,
    rule_id integer,
    picking_type_id integer,
    origin_returned_move_id integer,
    restrict_partner_id integer,
    warehouse_id integer,
    next_serial_count integer,
    orderpoint_id integer,
    packaging_uom_id integer,
    create_uid integer,
    write_uid integer,
    priority character varying,
    state character varying,
    origin character varying,
    procure_method character varying NOT NULL,
    inventory_name character varying,
    reference character varying,
    next_serial character varying,
    reservation_date date,
    description_picking_manual text,
    product_qty numeric,
    product_uom_qty numeric NOT NULL,
    quantity numeric,
    picked boolean,
    propagate_cancel boolean,
    is_inventory boolean,
    additional boolean,
    date timestamp without time zone NOT NULL,
    date_deadline timestamp without time zone,
    delay_alert_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    price_unit double precision,
    packaging_uom_qty double precision
);


ALTER TABLE public.stock_move OWNER TO runbot;

--
-- Name: TABLE stock_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_move IS 'Stock Move';


--
-- Name: COLUMN stock_move.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.sequence IS 'Sequence';


--
-- Name: COLUMN stock_move.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.company_id IS 'Company';


--
-- Name: COLUMN stock_move.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.product_id IS 'Product';


--
-- Name: COLUMN stock_move.product_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.product_uom IS 'Unit';


--
-- Name: COLUMN stock_move.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.location_id IS 'Source Location';


--
-- Name: COLUMN stock_move.location_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.location_dest_id IS 'Intermediate Location';


--
-- Name: COLUMN stock_move.location_final_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.location_final_id IS 'Final Location';


--
-- Name: COLUMN stock_move.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.partner_id IS 'Destination Address ';


--
-- Name: COLUMN stock_move.picking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.picking_id IS 'Transfer';


--
-- Name: COLUMN stock_move.scrap_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.scrap_id IS 'Scrap operation';


--
-- Name: COLUMN stock_move.rule_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.rule_id IS 'Stock Rule';


--
-- Name: COLUMN stock_move.picking_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.picking_type_id IS 'Operation Type';


--
-- Name: COLUMN stock_move.origin_returned_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.origin_returned_move_id IS 'Origin return move';


--
-- Name: COLUMN stock_move.restrict_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.restrict_partner_id IS 'Owner ';


--
-- Name: COLUMN stock_move.warehouse_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN stock_move.next_serial_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.next_serial_count IS 'Number of SN/Lots';


--
-- Name: COLUMN stock_move.orderpoint_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.orderpoint_id IS 'Original Reordering Rule';


--
-- Name: COLUMN stock_move.packaging_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.packaging_uom_id IS 'Packaging';


--
-- Name: COLUMN stock_move.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.create_uid IS 'Created by';


--
-- Name: COLUMN stock_move.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_move.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.priority IS 'Priority';


--
-- Name: COLUMN stock_move.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.state IS 'Status';


--
-- Name: COLUMN stock_move.origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.origin IS 'Source Document';


--
-- Name: COLUMN stock_move.procure_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.procure_method IS 'Supply Method';


--
-- Name: COLUMN stock_move.inventory_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.inventory_name IS 'Inventory Name';


--
-- Name: COLUMN stock_move.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.reference IS 'Reference';


--
-- Name: COLUMN stock_move.next_serial; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.next_serial IS 'First SN/Lot';


--
-- Name: COLUMN stock_move.reservation_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.reservation_date IS 'Date to Reserve';


--
-- Name: COLUMN stock_move.description_picking_manual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.description_picking_manual IS 'Description Picking Manual';


--
-- Name: COLUMN stock_move.product_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.product_qty IS 'Real Quantity';


--
-- Name: COLUMN stock_move.product_uom_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.product_uom_qty IS 'Demand';


--
-- Name: COLUMN stock_move.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.quantity IS 'Quantity';


--
-- Name: COLUMN stock_move.picked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.picked IS 'Picked';


--
-- Name: COLUMN stock_move.propagate_cancel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.propagate_cancel IS 'Propagate cancel and split';


--
-- Name: COLUMN stock_move.is_inventory; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.is_inventory IS 'Inventory';


--
-- Name: COLUMN stock_move.additional; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.additional IS 'Whether the move was added after the picking''s confirmation';


--
-- Name: COLUMN stock_move.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.date IS 'Date Scheduled';


--
-- Name: COLUMN stock_move.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.date_deadline IS 'Deadline';


--
-- Name: COLUMN stock_move.delay_alert_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.delay_alert_date IS 'Delay Alert Date';


--
-- Name: COLUMN stock_move.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.create_date IS 'Created on';


--
-- Name: COLUMN stock_move.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN stock_move.price_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.price_unit IS 'Unit Price';


--
-- Name: COLUMN stock_move.packaging_uom_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move.packaging_uom_qty IS 'Packaging Quantity';


--
-- Name: stock_quant; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_quant (
    id integer NOT NULL,
    product_id integer NOT NULL,
    company_id integer,
    location_id integer NOT NULL,
    lot_id integer,
    package_id integer,
    owner_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    inventory_date date,
    quantity numeric,
    reserved_quantity numeric NOT NULL,
    inventory_quantity numeric,
    inventory_diff_quantity numeric,
    inventory_quantity_set boolean,
    in_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_quant OWNER TO runbot;

--
-- Name: TABLE stock_quant; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_quant IS 'Quants';


--
-- Name: COLUMN stock_quant.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.product_id IS 'Product';


--
-- Name: COLUMN stock_quant.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.company_id IS 'Company';


--
-- Name: COLUMN stock_quant.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.location_id IS 'Location';


--
-- Name: COLUMN stock_quant.lot_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.lot_id IS 'Lot/Serial Number';


--
-- Name: COLUMN stock_quant.package_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.package_id IS 'Package';


--
-- Name: COLUMN stock_quant.owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.owner_id IS 'Owner';


--
-- Name: COLUMN stock_quant.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.user_id IS 'Assigned To';


--
-- Name: COLUMN stock_quant.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.create_uid IS 'Created by';


--
-- Name: COLUMN stock_quant.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_quant.inventory_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.inventory_date IS 'Scheduled';


--
-- Name: COLUMN stock_quant.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.quantity IS 'Quantity';


--
-- Name: COLUMN stock_quant.reserved_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.reserved_quantity IS 'Reserved Quantity';


--
-- Name: COLUMN stock_quant.inventory_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.inventory_quantity IS 'Counted';


--
-- Name: COLUMN stock_quant.inventory_diff_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.inventory_diff_quantity IS 'Difference';


--
-- Name: COLUMN stock_quant.inventory_quantity_set; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.inventory_quantity_set IS 'Inventory Quantity Set';


--
-- Name: COLUMN stock_quant.in_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.in_date IS 'Incoming Date';


--
-- Name: COLUMN stock_quant.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.create_date IS 'Created on';


--
-- Name: COLUMN stock_quant.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant.write_date IS 'Last Updated on';


--
-- Name: stock_warehouse; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_warehouse (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer,
    view_location_id integer NOT NULL,
    lot_stock_id integer NOT NULL,
    wh_input_stock_loc_id integer,
    wh_qc_stock_loc_id integer,
    wh_output_stock_loc_id integer,
    wh_pack_stock_loc_id integer,
    mto_pull_id integer,
    pick_type_id integer,
    pack_type_id integer,
    out_type_id integer,
    in_type_id integer,
    int_type_id integer,
    qc_type_id integer,
    store_type_id integer,
    xdock_type_id integer,
    reception_route_id integer,
    delivery_route_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying(5) NOT NULL,
    reception_steps character varying NOT NULL,
    delivery_steps character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_warehouse OWNER TO runbot;

--
-- Name: TABLE stock_warehouse; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_warehouse IS 'Warehouse';


--
-- Name: COLUMN stock_warehouse.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.company_id IS 'Company';


--
-- Name: COLUMN stock_warehouse.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.partner_id IS 'Address';


--
-- Name: COLUMN stock_warehouse.view_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.view_location_id IS 'View Location';


--
-- Name: COLUMN stock_warehouse.lot_stock_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.lot_stock_id IS 'Location Stock';


--
-- Name: COLUMN stock_warehouse.wh_input_stock_loc_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.wh_input_stock_loc_id IS 'Input Location';


--
-- Name: COLUMN stock_warehouse.wh_qc_stock_loc_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.wh_qc_stock_loc_id IS 'Quality Control Location';


--
-- Name: COLUMN stock_warehouse.wh_output_stock_loc_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.wh_output_stock_loc_id IS 'Output Location';


--
-- Name: COLUMN stock_warehouse.wh_pack_stock_loc_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.wh_pack_stock_loc_id IS 'Packing Location';


--
-- Name: COLUMN stock_warehouse.mto_pull_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.mto_pull_id IS 'MTO rule';


--
-- Name: COLUMN stock_warehouse.pick_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.pick_type_id IS 'Pick Type';


--
-- Name: COLUMN stock_warehouse.pack_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.pack_type_id IS 'Pack Type';


--
-- Name: COLUMN stock_warehouse.out_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.out_type_id IS 'Out Type';


--
-- Name: COLUMN stock_warehouse.in_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.in_type_id IS 'In Type';


--
-- Name: COLUMN stock_warehouse.int_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.int_type_id IS 'Internal Type';


--
-- Name: COLUMN stock_warehouse.qc_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.qc_type_id IS 'Quality Control Type';


--
-- Name: COLUMN stock_warehouse.store_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.store_type_id IS 'Storage Type';


--
-- Name: COLUMN stock_warehouse.xdock_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.xdock_type_id IS 'Cross Dock Type';


--
-- Name: COLUMN stock_warehouse.reception_route_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.reception_route_id IS 'Receipt Route';


--
-- Name: COLUMN stock_warehouse.delivery_route_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.delivery_route_id IS 'Delivery Route';


--
-- Name: COLUMN stock_warehouse.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.sequence IS 'Sequence';


--
-- Name: COLUMN stock_warehouse.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.create_uid IS 'Created by';


--
-- Name: COLUMN stock_warehouse.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_warehouse.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.name IS 'Warehouse';


--
-- Name: COLUMN stock_warehouse.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.code IS 'Short Name';


--
-- Name: COLUMN stock_warehouse.reception_steps; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.reception_steps IS 'Incoming Shipments';


--
-- Name: COLUMN stock_warehouse.delivery_steps; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.delivery_steps IS 'Outgoing Shipments';


--
-- Name: COLUMN stock_warehouse.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.active IS 'Active';


--
-- Name: COLUMN stock_warehouse.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.create_date IS 'Created on';


--
-- Name: COLUMN stock_warehouse.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse.write_date IS 'Last Updated on';


--
-- Name: report_stock_quantity; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.report_stock_quantity AS
 WITH warehouse_cte AS (
         SELECT sl.id AS sl_id,
            w.id AS w_id
           FROM (public.stock_location sl
             LEFT JOIN public.stock_warehouse w ON ((((sl.parent_path)::text ~~ concat('%/', w.view_location_id, '/%')) OR ((sl.parent_path)::text ~~ concat(w.view_location_id, '/%')))))
        ), existing_sm(id, product_id, tmpl_id, product_qty, quantity, date, state, company_id, whs_id, whd_id) AS (
         SELECT m.id,
            m.product_id,
            pt.id,
            m.product_qty,
            m.quantity,
            m.date,
            m.state,
            m.company_id,
            source.w_id,
            dest.w_id
           FROM ((((public.stock_move m
             LEFT JOIN warehouse_cte source ON ((source.sl_id = m.location_id)))
             LEFT JOIN warehouse_cte dest ON ((dest.sl_id =
                CASE
                    WHEN ((m.state)::text <> 'done'::text) THEN COALESCE(m.location_final_id, m.location_dest_id)
                    ELSE m.location_dest_id
                END)))
             LEFT JOIN public.product_product pp ON ((pp.id = m.product_id)))
             LEFT JOIN public.product_template pt ON ((pt.id = pp.product_tmpl_id)))
          WHERE ((pt.is_storable = true) AND (source.w_id IS DISTINCT FROM dest.w_id) AND (m.product_qty <> (0)::numeric) AND ((m.state)::text <> ALL ((ARRAY['draft'::character varying, 'cancel'::character varying])::text[])) AND (((m.state)::text <> 'done'::text) OR (m.date >= (((now() AT TIME ZONE 'utc'::text))::date - '3 mons'::interval))))
        ), all_sm(id, product_id, tmpl_id, product_qty, quantity, date, state, company_id, whs_id, whd_id) AS (
         SELECT sm.id,
            sm.product_id,
            sm.tmpl_id,
                CASE
                    WHEN ((is_duplicated.is_duplicated = 0) OR (sm.whs_id <> sm.whd_id)) THEN sm.product_qty
                    ELSE (0)::numeric
                END AS "case",
                CASE
                    WHEN (is_duplicated.is_duplicated = 0) THEN sm.quantity
                    WHEN ((sm.whs_id IS NOT NULL) AND (sm.whd_id IS NOT NULL) AND (sm.whs_id <> sm.whd_id)) THEN sm.quantity
                    ELSE (0)::numeric
                END AS "case",
            sm.date,
            sm.state,
            sm.company_id,
                CASE
                    WHEN (is_duplicated.is_duplicated = 0) THEN sm.whs_id
                    ELSE NULL::integer
                END AS "case",
                CASE
                    WHEN ((is_duplicated.is_duplicated = 0) AND ((sm.whs_id IS NULL) OR (sm.whd_id IS NULL) OR (sm.whs_id = sm.whd_id))) THEN sm.whd_id
                    WHEN ((is_duplicated.is_duplicated = 1) AND ((sm.whs_id IS NOT NULL) AND (sm.whd_id IS NOT NULL) AND (sm.whs_id <> sm.whd_id))) THEN sm.whd_id
                    ELSE NULL::integer
                END AS "case"
           FROM generate_series(0, 1, 1) is_duplicated(is_duplicated),
            existing_sm sm
        )
 SELECT min(id) AS id,
    product_id,
    product_tmpl_id,
    state,
    date,
    sum(product_qty) AS product_qty,
    company_id,
    warehouse_id
   FROM ( SELECT m.id,
            m.product_id,
            m.tmpl_id AS product_tmpl_id,
                CASE
                    WHEN ((m.whs_id IS NOT NULL) AND (m.whd_id IS NULL)) THEN 'out'::text
                    WHEN ((m.whd_id IS NOT NULL) AND (m.whs_id IS NULL)) THEN 'in'::text
                    ELSE NULL::text
                END AS state,
            (m.date)::date AS date,
                CASE
                    WHEN ((m.whs_id IS NOT NULL) AND (m.whd_id IS NULL)) THEN (- m.product_qty)
                    WHEN ((m.whd_id IS NOT NULL) AND (m.whs_id IS NULL)) THEN m.product_qty
                    ELSE NULL::numeric
                END AS product_qty,
            m.company_id,
                CASE
                    WHEN ((m.whs_id IS NOT NULL) AND (m.whd_id IS NULL)) THEN m.whs_id
                    WHEN ((m.whd_id IS NOT NULL) AND (m.whs_id IS NULL)) THEN m.whd_id
                    ELSE NULL::integer
                END AS warehouse_id
           FROM all_sm m
          WHERE ((m.product_qty <> (0)::numeric) AND ((m.state)::text <> 'done'::text))
        UNION ALL
         SELECT (- q.id) AS id,
            q.product_id,
            pp.product_tmpl_id,
            'forecast'::text AS state,
            (date.date)::date AS date,
            q.quantity AS product_qty,
            q.company_id,
            wh.id AS warehouse_id
           FROM generate_series((((now() AT TIME ZONE 'utc'::text))::date - '3 mons'::interval), (((now() AT TIME ZONE 'utc'::text))::date + '3 mons'::interval), '1 day'::interval) date(date),
            (((public.stock_quant q
             LEFT JOIN public.stock_location l ON ((l.id = q.location_id)))
             LEFT JOIN public.stock_warehouse wh ON ((((l.parent_path)::text ~~ concat('%/', wh.view_location_id, '/%')) OR ((l.parent_path)::text ~~ concat(wh.view_location_id, '/%')))))
             LEFT JOIN public.product_product pp ON ((pp.id = q.product_id)))
          WHERE ((((l.usage)::text = 'internal'::text) AND (wh.id IS NOT NULL)) OR ((l.usage)::text = 'transit'::text))
        UNION ALL
         SELECT m.id,
            m.product_id,
            m.tmpl_id AS product_tmpl_id,
            'forecast'::text AS state,
            (generate_series(
                CASE
                    WHEN ((m.state)::text = 'done'::text) THEN (((now() AT TIME ZONE 'utc'::text))::date - '3 mons'::interval)
                    ELSE GREATEST(((m.date)::date)::timestamp without time zone, (((now() AT TIME ZONE 'utc'::text))::date - '3 mons'::interval))
                END,
                CASE
                    WHEN ((m.state)::text <> 'done'::text) THEN (((now() AT TIME ZONE 'utc'::text))::date + '3 mons'::interval)
                    ELSE ((m.date)::date - '1 day'::interval)
                END, '1 day'::interval))::date AS date,
                CASE
                    WHEN ((m.whs_id IS NOT NULL) AND (m.whd_id IS NULL) AND ((m.state)::text = 'done'::text)) THEN m.quantity
                    WHEN ((m.whd_id IS NOT NULL) AND (m.whs_id IS NULL) AND ((m.state)::text = 'done'::text)) THEN (- m.quantity)
                    WHEN ((m.whs_id IS NOT NULL) AND (m.whd_id IS NULL)) THEN (- m.product_qty)
                    WHEN ((m.whd_id IS NOT NULL) AND (m.whs_id IS NULL)) THEN m.product_qty
                    ELSE NULL::numeric
                END AS product_qty,
            m.company_id,
                CASE
                    WHEN ((m.whs_id IS NOT NULL) AND (m.whd_id IS NULL)) THEN m.whs_id
                    WHEN ((m.whd_id IS NOT NULL) AND (m.whs_id IS NULL)) THEN m.whd_id
                    ELSE NULL::integer
                END AS warehouse_id
           FROM all_sm m
          WHERE (m.product_qty <> (0)::numeric)) forecast_qty
  GROUP BY product_id, product_tmpl_id, state, date, company_id, warehouse_id;


ALTER VIEW public.report_stock_quantity OWNER TO runbot;

--
-- Name: report_stylesheets; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_stylesheets (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying(64) NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_stylesheets OWNER TO runbot;

--
-- Name: TABLE report_stylesheets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_stylesheets IS 'Report Stylesheets';


--
-- Name: COLUMN report_stylesheets.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_stylesheets.create_uid IS 'Created by';


--
-- Name: COLUMN report_stylesheets.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_stylesheets.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_stylesheets.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_stylesheets.name IS 'Name';


--
-- Name: COLUMN report_stylesheets.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_stylesheets.create_date IS 'Created on';


--
-- Name: COLUMN report_stylesheets.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_stylesheets.write_date IS 'Last Updated on';


--
-- Name: report_stylesheets_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_stylesheets_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_stylesheets_id_seq OWNER TO runbot;

--
-- Name: report_stylesheets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_stylesheets_id_seq OWNED BY public.report_stylesheets.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea,
    nomenclature_id integer,
    resource_calendar_id integer,
    alias_domain_id integer,
    email_primary_color character varying,
    email_secondary_color character varying,
    stylesheet_id integer,
    iap_enrich_auto_done boolean,
    snailmail_color boolean,
    snailmail_cover boolean,
    snailmail_duplex boolean,
    internal_transit_location_id integer,
    stock_mail_confirmation_template_id integer,
    annual_inventory_day integer,
    annual_inventory_month character varying,
    stock_confirmation_type character varying,
    stock_move_email_validation boolean,
    stock_text_confirmation boolean,
    horizon_days double precision NOT NULL,
    stock_sms_confirmation_template_id integer,
    has_received_warning_stock_sms boolean
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.nomenclature_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.nomenclature_id IS 'Nomenclature';


--
-- Name: COLUMN res_company.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.resource_calendar_id IS 'Default Working Hours';


--
-- Name: COLUMN res_company.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.alias_domain_id IS 'Email Domain';


--
-- Name: COLUMN res_company.email_primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_primary_color IS 'Email Button Text';


--
-- Name: COLUMN res_company.email_secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_secondary_color IS 'Email Button Color';


--
-- Name: COLUMN res_company.stylesheet_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stylesheet_id IS 'Aeroo Reports Global Stylesheet';


--
-- Name: COLUMN res_company.iap_enrich_auto_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.iap_enrich_auto_done IS 'Enrich Done';


--
-- Name: COLUMN res_company.snailmail_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_color IS 'Snailmail Color';


--
-- Name: COLUMN res_company.snailmail_cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN res_company.snailmail_duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_duplex IS 'Both sides';


--
-- Name: COLUMN res_company.internal_transit_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.internal_transit_location_id IS 'Internal Transit Location';


--
-- Name: COLUMN res_company.stock_mail_confirmation_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_mail_confirmation_template_id IS 'Email Template confirmation picking';


--
-- Name: COLUMN res_company.annual_inventory_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.annual_inventory_day IS 'Day of the month';


--
-- Name: COLUMN res_company.annual_inventory_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.annual_inventory_month IS 'Annual Inventory Month';


--
-- Name: COLUMN res_company.stock_confirmation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_confirmation_type IS 'Stock Confirmation Type';


--
-- Name: COLUMN res_company.stock_move_email_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_move_email_validation IS 'Email Confirmation picking';


--
-- Name: COLUMN res_company.stock_text_confirmation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_text_confirmation IS 'Stock Text Confirmation';


--
-- Name: COLUMN res_company.horizon_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.horizon_days IS 'Replenishment Horizon';


--
-- Name: COLUMN res_company.stock_sms_confirmation_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_sms_confirmation_template_id IS 'SMS Template';


--
-- Name: COLUMN res_company.has_received_warning_stock_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.has_received_warning_stock_sms IS 'Has Received Warning Stock Sms';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.res_company_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE res_company_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND res_company';


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    web_app_name character varying,
    company_id integer NOT NULL,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_sms boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    module_website_cf_turnstile boolean,
    module_google_address_autocomplete boolean,
    group_multi_currency boolean,
    show_effect boolean,
    profiling_enabled_until timestamp without time zone,
    map_box_token character varying,
    twilio_account_sid character varying,
    twilio_account_token character varying,
    sfu_server_url character varying,
    sfu_server_key character varying,
    tenor_api_key character varying,
    google_translate_api_key character varying,
    external_email_server_default boolean,
    module_google_gmail boolean,
    module_microsoft_outlook boolean,
    restrict_template_rendering boolean,
    use_twilio_rtc_servers boolean,
    use_sfu_server boolean,
    unsplash_access_key character varying,
    unsplash_app_id character varying,
    auth_signup_template_user_id integer,
    auth_signup_uninvited character varying,
    auth_signup_reset_password boolean,
    auth_totp_policy character varying,
    auth_totp_enforce boolean,
    google_gmail_client_identifier character varying,
    google_gmail_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    product_weight_in_lbs character varying,
    product_volume_volume_in_cubic_feet character varying,
    group_uom boolean,
    group_product_variant boolean,
    module_loyalty boolean,
    group_product_pricelist boolean,
    disable_redirect_firebase_dynamic_link boolean,
    enable_ocn boolean,
    barcodelookup_api_key character varying,
    digest_id integer,
    digest_emails boolean,
    barcode_separator character varying,
    module_product_expiry boolean,
    group_stock_production_lot boolean,
    group_stock_lot_print_gs1 boolean,
    group_lot_on_delivery_slip boolean,
    group_stock_tracking_lot boolean,
    group_stock_tracking_owner boolean,
    group_stock_adv_location boolean,
    group_warning_stock boolean,
    group_stock_sign_delivery boolean,
    module_stock_picking_batch boolean,
    module_stock_barcode boolean,
    module_stock_barcode_barcodelookup boolean,
    module_stock_sms boolean,
    module_delivery boolean,
    module_delivery_dhl boolean,
    module_delivery_fedex_rest boolean,
    module_delivery_ups_rest boolean,
    module_delivery_usps_rest boolean,
    module_delivery_bpost boolean,
    module_delivery_easypost boolean,
    module_delivery_sendcloud boolean,
    module_delivery_shiprocket boolean,
    module_delivery_starshipit boolean,
    module_delivery_envia boolean,
    module_quality_control boolean,
    module_quality_control_worksheet boolean,
    group_stock_multi_locations boolean,
    group_stock_reception_report boolean,
    module_stock_dropshipping boolean,
    module_stock_fleet boolean,
    barcode_max_time_between_keys_in_ms integer,
    barcode_rfid_batch_time integer,
    barcode_separator_regex character varying,
    stock_barcode_mute_sound_notifications boolean,
    module_whatsapp_stock boolean,
    openai_key character varying,
    google_key character varying
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.web_app_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.web_app_name IS 'Web App Name';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'Phone';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_sms IS 'SMS';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.module_website_cf_turnstile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_website_cf_turnstile IS 'Cloudflare Turnstile';


--
-- Name: COLUMN res_config_settings.module_google_address_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_address_autocomplete IS 'Google Address Autocomplete';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.map_box_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.map_box_token IS 'Token Map Box';


--
-- Name: COLUMN res_config_settings.twilio_account_sid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_sid IS 'Account SID';


--
-- Name: COLUMN res_config_settings.twilio_account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_token IS 'Account Auth Token';


--
-- Name: COLUMN res_config_settings.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_url IS 'SFU Server URL';


--
-- Name: COLUMN res_config_settings.sfu_server_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_key IS 'SFU Server key';


--
-- Name: COLUMN res_config_settings.tenor_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.tenor_api_key IS 'Tenor API key';


--
-- Name: COLUMN res_config_settings.google_translate_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_translate_api_key IS 'Message Translation API Key';


--
-- Name: COLUMN res_config_settings.external_email_server_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.external_email_server_default IS 'Use Custom Email Servers';


--
-- Name: COLUMN res_config_settings.module_google_gmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_gmail IS 'Support Gmail Authentication';


--
-- Name: COLUMN res_config_settings.module_microsoft_outlook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_outlook IS 'Support Outlook Authentication';


--
-- Name: COLUMN res_config_settings.restrict_template_rendering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.restrict_template_rendering IS 'Restrict Template Rendering';


--
-- Name: COLUMN res_config_settings.use_twilio_rtc_servers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_twilio_rtc_servers IS 'Use Twilio ICE servers';


--
-- Name: COLUMN res_config_settings.use_sfu_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_sfu_server IS 'Use SFU server';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: COLUMN res_config_settings.auth_signup_template_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_template_user_id IS 'Template user for new users created through signup';


--
-- Name: COLUMN res_config_settings.auth_signup_uninvited; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_uninvited IS 'Customer Account';


--
-- Name: COLUMN res_config_settings.auth_signup_reset_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_reset_password IS 'Enable password reset from Login page';


--
-- Name: COLUMN res_config_settings.auth_totp_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_totp_policy IS 'Two-factor authentication enforcing policy';


--
-- Name: COLUMN res_config_settings.auth_totp_enforce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_totp_enforce IS 'Enforce two-factor authentication';


--
-- Name: COLUMN res_config_settings.google_gmail_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_identifier IS 'Gmail Client Id';


--
-- Name: COLUMN res_config_settings.google_gmail_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_secret IS 'Gmail Client Secret';


--
-- Name: COLUMN res_config_settings.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN res_config_settings.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN res_config_settings.product_weight_in_lbs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.product_weight_in_lbs IS 'Weight unit of measure';


--
-- Name: COLUMN res_config_settings.product_volume_volume_in_cubic_feet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.product_volume_volume_in_cubic_feet IS 'Volume unit of measure';


--
-- Name: COLUMN res_config_settings.group_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_uom IS 'Units of Measure & Packagings';


--
-- Name: COLUMN res_config_settings.group_product_variant; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_product_variant IS 'Variants';


--
-- Name: COLUMN res_config_settings.module_loyalty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_loyalty IS 'Promotions, Coupons, Gift Card & Loyalty Program';


--
-- Name: COLUMN res_config_settings.group_product_pricelist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_product_pricelist IS 'Pricelists';


--
-- Name: COLUMN res_config_settings.disable_redirect_firebase_dynamic_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.disable_redirect_firebase_dynamic_link IS 'Disable link redirection to mobile app';


--
-- Name: COLUMN res_config_settings.enable_ocn; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.enable_ocn IS 'Push Notifications';


--
-- Name: COLUMN res_config_settings.barcodelookup_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.barcodelookup_api_key IS 'API key';


--
-- Name: COLUMN res_config_settings.digest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.digest_id IS 'Digest Email';


--
-- Name: COLUMN res_config_settings.digest_emails; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.digest_emails IS 'Digest Emails';


--
-- Name: COLUMN res_config_settings.barcode_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.barcode_separator IS 'Separator';


--
-- Name: COLUMN res_config_settings.module_product_expiry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_product_expiry IS 'Expiration Dates';


--
-- Name: COLUMN res_config_settings.group_stock_production_lot; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_stock_production_lot IS 'Lots & Serial Numbers';


--
-- Name: COLUMN res_config_settings.group_stock_lot_print_gs1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_stock_lot_print_gs1 IS 'Print GS1 Barcodes for Lots & Serial Numbers';


--
-- Name: COLUMN res_config_settings.group_lot_on_delivery_slip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_lot_on_delivery_slip IS 'Display Lots & Serial Numbers on Delivery Slips';


--
-- Name: COLUMN res_config_settings.group_stock_tracking_lot; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_stock_tracking_lot IS 'Packages';


--
-- Name: COLUMN res_config_settings.group_stock_tracking_owner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_stock_tracking_owner IS 'Consignment';


--
-- Name: COLUMN res_config_settings.group_stock_adv_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_stock_adv_location IS 'Multi-Step Routes';


--
-- Name: COLUMN res_config_settings.group_warning_stock; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_warning_stock IS 'Warnings for Stock';


--
-- Name: COLUMN res_config_settings.group_stock_sign_delivery; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_stock_sign_delivery IS 'Signature';


--
-- Name: COLUMN res_config_settings.module_stock_picking_batch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_stock_picking_batch IS 'Batch, Wave & Cluster Transfers';


--
-- Name: COLUMN res_config_settings.module_stock_barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_stock_barcode IS 'Barcode Scanner';


--
-- Name: COLUMN res_config_settings.module_stock_barcode_barcodelookup; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_stock_barcode_barcodelookup IS 'Stock Barcode Database';


--
-- Name: COLUMN res_config_settings.module_stock_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_stock_sms IS 'SMS Confirmation';


--
-- Name: COLUMN res_config_settings.module_delivery; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery IS 'Delivery Methods';


--
-- Name: COLUMN res_config_settings.module_delivery_dhl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_dhl IS 'DHL Express Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_fedex_rest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_fedex_rest IS 'FedEx Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_ups_rest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_ups_rest IS 'UPS Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_usps_rest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_usps_rest IS 'USPS Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_bpost; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_bpost IS 'bpost Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_easypost; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_easypost IS 'Easypost Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_sendcloud; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_sendcloud IS 'Sendcloud Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_shiprocket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_shiprocket IS 'Shiprocket Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_starshipit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_starshipit IS 'Starshipit Connector';


--
-- Name: COLUMN res_config_settings.module_delivery_envia; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_delivery_envia IS 'Envia.com Connector';


--
-- Name: COLUMN res_config_settings.module_quality_control; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_quality_control IS 'Quality';


--
-- Name: COLUMN res_config_settings.module_quality_control_worksheet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_quality_control_worksheet IS 'Quality Worksheet';


--
-- Name: COLUMN res_config_settings.group_stock_multi_locations; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_stock_multi_locations IS 'Storage Locations';


--
-- Name: COLUMN res_config_settings.group_stock_reception_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_stock_reception_report IS 'Reception Report';


--
-- Name: COLUMN res_config_settings.module_stock_dropshipping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_stock_dropshipping IS 'Dropshipping';


--
-- Name: COLUMN res_config_settings.module_stock_fleet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_stock_fleet IS 'Dispatch Management System';


--
-- Name: COLUMN res_config_settings.barcode_max_time_between_keys_in_ms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.barcode_max_time_between_keys_in_ms IS 'Max time between each key';


--
-- Name: COLUMN res_config_settings.barcode_rfid_batch_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.barcode_rfid_batch_time IS 'RFID Timer';


--
-- Name: COLUMN res_config_settings.barcode_separator_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.barcode_separator_regex IS 'Multiscan Separator';


--
-- Name: COLUMN res_config_settings.stock_barcode_mute_sound_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.stock_barcode_mute_sound_notifications IS 'Mute Barcode application sounds';


--
-- Name: COLUMN res_config_settings.module_whatsapp_stock; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_whatsapp_stock IS 'WhatsApp Confirmation';


--
-- Name: COLUMN res_config_settings.openai_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.openai_key IS 'OpenAI API key';


--
-- Name: COLUMN res_config_settings.google_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_key IS 'Google AI API key';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.code IS 'Code';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_group_pricelist_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group_pricelist_rel (
    pricelist_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_group_pricelist_rel OWNER TO runbot;

--
-- Name: TABLE res_country_group_pricelist_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group_pricelist_rel IS 'RELATION BETWEEN product_pricelist AND res_country_group';


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    iso_numeric integer,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label jsonb,
    currency_subunit_label jsonb,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.iso_numeric; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.iso_numeric IS 'Currency numeric code.';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_device_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_device_log (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    session_identifier character varying NOT NULL,
    platform character varying,
    browser character varying,
    ip_address character varying,
    country character varying,
    city character varying,
    device_type character varying,
    revoked boolean,
    first_activity timestamp without time zone,
    last_activity timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_device_log OWNER TO runbot;

--
-- Name: TABLE res_device_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_device_log IS 'Device Log';


--
-- Name: COLUMN res_device_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.user_id IS 'User';


--
-- Name: COLUMN res_device_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_device_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_device_log.session_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.session_identifier IS 'Session Identifier';


--
-- Name: COLUMN res_device_log.platform; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.platform IS 'Platform';


--
-- Name: COLUMN res_device_log.browser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.browser IS 'Browser';


--
-- Name: COLUMN res_device_log.ip_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.ip_address IS 'IP Address';


--
-- Name: COLUMN res_device_log.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.country IS 'Country';


--
-- Name: COLUMN res_device_log.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.city IS 'City';


--
-- Name: COLUMN res_device_log.device_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.device_type IS 'Device Type';


--
-- Name: COLUMN res_device_log.revoked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.revoked IS 'Revoked';


--
-- Name: COLUMN res_device_log.first_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.first_activity IS 'First Activity';


--
-- Name: COLUMN res_device_log.last_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.last_activity IS 'Last Activity';


--
-- Name: COLUMN res_device_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_date IS 'Created on';


--
-- Name: COLUMN res_device_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_date IS 'Last Updated on';


--
-- Name: res_device; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.res_device AS
 SELECT id,
    user_id,
    create_uid,
    write_uid,
    session_identifier,
    platform,
    browser,
    ip_address,
    country,
    city,
    device_type,
    revoked,
    first_activity,
    last_activity,
    create_date,
    write_date
   FROM public.res_device_log d
  WHERE ((NOT (EXISTS ( SELECT 1
           FROM public.res_device_log d2
          WHERE ((d2.user_id = d.user_id) AND ((d2.session_identifier)::text = (d.session_identifier)::text) AND (NOT ((d2.platform)::text IS DISTINCT FROM (d.platform)::text)) AND (NOT ((d2.browser)::text IS DISTINCT FROM (d.browser)::text)) AND ((d2.last_activity > d.last_activity) OR ((d2.last_activity = d.last_activity) AND (d2.id > d.id))) AND (d2.revoked IS NOT TRUE))))) AND (revoked IS NOT TRUE));


ALTER VIEW public.res_device OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_device_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_device_log_id_seq OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_device_log_id_seq OWNED BY public.res_device_log.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    sequence integer,
    privilege_id integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    api_key_duration double precision,
    CONSTRAINT res_groups_check_api_key_duration CHECK ((api_key_duration >= (0)::double precision))
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.sequence IS 'Sequence';


--
-- Name: COLUMN res_groups.privilege_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.privilege_id IS 'Privilege';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_groups.api_key_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.api_key_duration IS 'API Keys maximum duration days';


--
-- Name: CONSTRAINT res_groups_check_api_key_duration ON res_groups; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_groups_check_api_key_duration ON public.res_groups IS 'CHECK(api_key_duration >= 0)';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_privilege; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_privilege (
    id integer NOT NULL,
    sequence integer,
    category_id integer,
    create_uid integer,
    write_uid integer,
    placeholder character varying,
    name jsonb NOT NULL,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_groups_privilege OWNER TO runbot;

--
-- Name: TABLE res_groups_privilege; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_privilege IS 'Privileges';


--
-- Name: COLUMN res_groups_privilege.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.sequence IS 'Sequence';


--
-- Name: COLUMN res_groups_privilege.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.category_id IS 'Category';


--
-- Name: COLUMN res_groups_privilege.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups_privilege.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups_privilege.placeholder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.placeholder IS 'Placeholder';


--
-- Name: COLUMN res_groups_privilege.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.name IS 'Name';


--
-- Name: COLUMN res_groups_privilege.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.description IS 'Description';


--
-- Name: COLUMN res_groups_privilege.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.create_date IS 'Created on';


--
-- Name: COLUMN res_groups_privilege.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.write_date IS 'Last Updated on';


--
-- Name: res_groups_privilege_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_privilege_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_privilege_id_seq OWNER TO runbot;

--
-- Name: res_groups_privilege_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_privilege_id_seq OWNED BY public.res_groups_privilege.id;


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.res_groups_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    commercial_company_name character varying,
    company_name character varying,
    properties jsonb,
    barcode jsonb,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    contact_address_complete character varying,
    message_bounce integer,
    email_normalized character varying,
    signup_type character varying,
    phone_sanitized character varying,
    specific_property_product_pricelist jsonb,
    ocn_token character varying,
    property_stock_customer jsonb,
    property_stock_supplier jsonb,
    picking_warn_msg text,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.properties IS 'Properties';


--
-- Name: COLUMN res_partner.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.barcode IS 'Barcode';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner.contact_address_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.contact_address_complete IS 'Contact Address Complete';


--
-- Name: COLUMN res_partner.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.message_bounce IS 'Bounce';


--
-- Name: COLUMN res_partner.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN res_partner.signup_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.signup_type IS 'Signup Token Type';


--
-- Name: COLUMN res_partner.phone_sanitized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN res_partner.specific_property_product_pricelist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.specific_property_product_pricelist IS 'Specific Property Product Pricelist';


--
-- Name: COLUMN res_partner.ocn_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ocn_token IS 'OCN Token';


--
-- Name: COLUMN res_partner.property_stock_customer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.property_stock_customer IS 'Customer Location';


--
-- Name: COLUMN res_partner.property_stock_supplier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.property_stock_supplier IS 'Vendor Location';


--
-- Name: COLUMN res_partner.picking_warn_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.picking_warn_msg IS 'Message for Stock Picking';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    clearing_number character varying,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    note text,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.clearing_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.clearing_number IS 'Clearing Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.note IS 'Notes';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_role (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_role OWNER TO runbot;

--
-- Name: TABLE res_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_role IS 'Represents a role in the system used to categorize users. Each role has a unique name and can be associated with multiple users. Roles can be mentioned in messages to notify all associated users.';


--
-- Name: COLUMN res_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.create_uid IS 'Created by';


--
-- Name: COLUMN res_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_role.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.name IS 'Name';


--
-- Name: COLUMN res_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.create_date IS 'Created on';


--
-- Name: COLUMN res_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.write_date IS 'Last Updated on';


--
-- Name: res_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_role_id_seq OWNER TO runbot;

--
-- Name: res_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_role_id_seq OWNED BY public.res_role.id;


--
-- Name: res_role_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_role_res_users_rel (
    res_role_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_role_res_users_rel OWNER TO runbot;

--
-- Name: TABLE res_role_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_role_res_users_rel IS 'RELATION BETWEEN res_role AND res_users';


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_last_counter integer,
    totp_secret character varying,
    tour_enabled boolean,
    notification_type character varying NOT NULL,
    manual_im_status character varying,
    out_of_office_message text,
    out_of_office_from timestamp without time zone,
    out_of_office_to timestamp without time zone,
    odoobot_state character varying,
    odoobot_failed boolean,
    saas_provider_uuid character varying,
    CONSTRAINT res_users_notification_type CHECK ((((notification_type)::text = 'email'::text) OR (NOT share)))
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.totp_last_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.totp_last_counter IS 'Totp Last Counter';


--
-- Name: COLUMN res_users.tour_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.tour_enabled IS 'Onboarding';


--
-- Name: COLUMN res_users.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.notification_type IS 'Notification';


--
-- Name: COLUMN res_users.manual_im_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.manual_im_status IS 'IM status manually set by the user';


--
-- Name: COLUMN res_users.out_of_office_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_message IS 'Vacation Responder';


--
-- Name: COLUMN res_users.out_of_office_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_from IS 'Out Of Office From';


--
-- Name: COLUMN res_users.out_of_office_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_to IS 'Out Of Office To';


--
-- Name: COLUMN res_users.odoobot_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_state IS 'OdooBot Status';


--
-- Name: COLUMN res_users.odoobot_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_failed IS 'Odoobot Failed';


--
-- Name: COLUMN res_users.saas_provider_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.saas_provider_uuid IS 'SaaS Provider UUID';


--
-- Name: CONSTRAINT res_users_notification_type ON res_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_notification_type ON public.res_users IS 'CHECK (notification_type = ''email'' OR NOT share)';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    duration character varying NOT NULL,
    expiration_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.duration IS 'Duration';


--
-- Name: COLUMN res_users_apikeys_description.expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.expiration_date IS 'Expiration Date';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    auth_method character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.auth_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.auth_method IS 'Auth Method';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    color_scheme character varying NOT NULL,
    homemenu_config jsonb,
    voice_active_duration integer,
    push_to_talk_key character varying,
    channel_notifications character varying,
    is_discuss_sidebar_category_channel_open boolean,
    is_discuss_sidebar_category_chat_open boolean,
    use_push_to_talk boolean
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings.color_scheme; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.color_scheme IS 'Color Scheme';


--
-- Name: COLUMN res_users_settings.homemenu_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.homemenu_config IS 'Home Menu Configuration';


--
-- Name: COLUMN res_users_settings.voice_active_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.voice_active_duration IS 'Duration of voice activity in ms';


--
-- Name: COLUMN res_users_settings.push_to_talk_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.push_to_talk_key IS 'Push-To-Talk shortcut';


--
-- Name: COLUMN res_users_settings.channel_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.channel_notifications IS 'Channel Notifications';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_channel_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_channel_open IS 'Is discuss sidebar category channel open?';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_chat_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_chat_open IS 'Is discuss sidebar category chat open?';


--
-- Name: COLUMN res_users_settings.use_push_to_talk; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.use_push_to_talk IS 'Use the push to talk feature';


--
-- Name: res_users_settings_embedded_action; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_embedded_action (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    action_id integer NOT NULL,
    res_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    embedded_actions_order character varying,
    embedded_actions_visibility character varying,
    embedded_visibility boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_settings_embedded_action OWNER TO runbot;

--
-- Name: TABLE res_users_settings_embedded_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_embedded_action IS 'User Settings for Embedded Actions';


--
-- Name: COLUMN res_users_settings_embedded_action.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_embedded_action.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.action_id IS 'Action';


--
-- Name: COLUMN res_users_settings_embedded_action.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.res_id IS 'Res';


--
-- Name: COLUMN res_users_settings_embedded_action.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_embedded_action.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_embedded_action.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.res_model IS 'Res Model';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_actions_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_actions_order IS 'List order of embedded action ids';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_actions_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_actions_visibility IS 'List visibility of embedded actions ids';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_visibility IS 'Is top bar visible';


--
-- Name: COLUMN res_users_settings_embedded_action.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_embedded_action.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_embedded_action_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_embedded_action_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_embedded_action_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_embedded_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_embedded_action_id_seq OWNED BY public.res_users_settings_embedded_action.id;


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: res_users_settings_volumes; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_volumes (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    volume double precision,
    CONSTRAINT res_users_settings_volumes_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.res_users_settings_volumes OWNER TO runbot;

--
-- Name: TABLE res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_volumes IS 'User Settings Volumes';


--
-- Name: COLUMN res_users_settings_volumes.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_volumes.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.partner_id IS 'Partner';


--
-- Name: COLUMN res_users_settings_volumes.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.guest_id IS 'Guest';


--
-- Name: COLUMN res_users_settings_volumes.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_volumes.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_volumes.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_volumes.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings_volumes.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.volume IS 'Volume';


--
-- Name: CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON public.res_users_settings_volumes IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_volumes_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNED BY public.res_users_settings_volumes.id;


--
-- Name: res_users_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE res_users_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND res_users';


--
-- Name: res_users_web_tour_tour_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_web_tour_tour_rel (
    web_tour_tour_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_web_tour_tour_rel OWNER TO runbot;

--
-- Name: TABLE res_users_web_tour_tour_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_web_tour_tour_rel IS 'RELATION BETWEEN web_tour_tour AND res_users';


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: resource_calendar; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    schedule_type character varying NOT NULL,
    tz character varying NOT NULL,
    hours_per_day numeric,
    active boolean,
    duration_based boolean,
    flexible_hours boolean,
    two_weeks_calendar boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    full_time_required_hours double precision,
    hours_per_week double precision
);


ALTER TABLE public.resource_calendar OWNER TO runbot;

--
-- Name: TABLE resource_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar IS 'Resource Working Time';


--
-- Name: COLUMN resource_calendar.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.name IS 'Name';


--
-- Name: COLUMN resource_calendar.schedule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.schedule_type IS 'Schedule Type';


--
-- Name: COLUMN resource_calendar.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.tz IS 'Timezone';


--
-- Name: COLUMN resource_calendar.hours_per_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.hours_per_day IS 'Average Hour per Day';


--
-- Name: COLUMN resource_calendar.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.active IS 'Active';


--
-- Name: COLUMN resource_calendar.duration_based; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.duration_based IS 'Attendance based on duration';


--
-- Name: COLUMN resource_calendar.flexible_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.flexible_hours IS 'Flexible Hours';


--
-- Name: COLUMN resource_calendar.two_weeks_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.two_weeks_calendar IS 'Calendar in 2 weeks mode';


--
-- Name: COLUMN resource_calendar.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar.full_time_required_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.full_time_required_hours IS 'Full Time Equivalent';


--
-- Name: COLUMN resource_calendar.hours_per_week; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.hours_per_week IS 'Hours per Week';


--
-- Name: resource_calendar_attendance; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar_attendance (
    id integer NOT NULL,
    calendar_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    dayofweek character varying NOT NULL,
    day_period character varying NOT NULL,
    week_type character varying,
    display_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    hour_from double precision NOT NULL,
    hour_to double precision NOT NULL,
    duration_hours double precision,
    duration_days double precision
);


ALTER TABLE public.resource_calendar_attendance OWNER TO runbot;

--
-- Name: TABLE resource_calendar_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar_attendance IS 'Work Detail';


--
-- Name: COLUMN resource_calendar_attendance.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.calendar_id IS 'Resource''s Calendar';


--
-- Name: COLUMN resource_calendar_attendance.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.sequence IS 'Sequence';


--
-- Name: COLUMN resource_calendar_attendance.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_attendance.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_attendance.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.name IS 'Name';


--
-- Name: COLUMN resource_calendar_attendance.dayofweek; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.dayofweek IS 'Day of Week';


--
-- Name: COLUMN resource_calendar_attendance.day_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.day_period IS 'Day Period';


--
-- Name: COLUMN resource_calendar_attendance.week_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.week_type IS 'Week Number';


--
-- Name: COLUMN resource_calendar_attendance.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.display_type IS 'Display Type';


--
-- Name: COLUMN resource_calendar_attendance.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_attendance.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar_attendance.hour_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_from IS 'Work from';


--
-- Name: COLUMN resource_calendar_attendance.hour_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_to IS 'Work to';


--
-- Name: COLUMN resource_calendar_attendance.duration_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.duration_hours IS 'Duration (hours)';


--
-- Name: COLUMN resource_calendar_attendance.duration_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.duration_days IS 'Duration (days)';


--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_attendance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_attendance_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_attendance_id_seq OWNED BY public.resource_calendar_attendance.id;


--
-- Name: resource_calendar_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_id_seq OWNED BY public.resource_calendar.id;


--
-- Name: resource_calendar_leaves; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar_leaves (
    id integer NOT NULL,
    company_id integer,
    calendar_id integer,
    resource_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    time_type character varying,
    date_from timestamp without time zone NOT NULL,
    date_to timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.resource_calendar_leaves OWNER TO runbot;

--
-- Name: TABLE resource_calendar_leaves; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar_leaves IS 'Resource Time Off Detail';


--
-- Name: COLUMN resource_calendar_leaves.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar_leaves.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.calendar_id IS 'Working Hours';


--
-- Name: COLUMN resource_calendar_leaves.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.resource_id IS 'Resource';


--
-- Name: COLUMN resource_calendar_leaves.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_leaves.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_leaves.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.name IS 'Reason';


--
-- Name: COLUMN resource_calendar_leaves.time_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.time_type IS 'Time Type';


--
-- Name: COLUMN resource_calendar_leaves.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_from IS 'Start Date';


--
-- Name: COLUMN resource_calendar_leaves.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_to IS 'End Date';


--
-- Name: COLUMN resource_calendar_leaves.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_leaves.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_date IS 'Last Updated on';


--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_leaves_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_leaves_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_leaves_id_seq OWNED BY public.resource_calendar_leaves.id;


--
-- Name: resource_resource; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_resource (
    id integer NOT NULL,
    company_id integer,
    user_id integer,
    calendar_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    resource_type character varying NOT NULL,
    tz character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    time_efficiency double precision NOT NULL,
    color integer,
    CONSTRAINT resource_resource_check_time_efficiency CHECK ((time_efficiency > (0)::double precision))
);


ALTER TABLE public.resource_resource OWNER TO runbot;

--
-- Name: TABLE resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_resource IS 'Resources';


--
-- Name: COLUMN resource_resource.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.company_id IS 'Company';


--
-- Name: COLUMN resource_resource.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.user_id IS 'User';


--
-- Name: COLUMN resource_resource.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.calendar_id IS 'Working Time';


--
-- Name: COLUMN resource_resource.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_uid IS 'Created by';


--
-- Name: COLUMN resource_resource.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_resource.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.name IS 'Name';


--
-- Name: COLUMN resource_resource.resource_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.resource_type IS 'Type';


--
-- Name: COLUMN resource_resource.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.tz IS 'Timezone';


--
-- Name: COLUMN resource_resource.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.active IS 'Active';


--
-- Name: COLUMN resource_resource.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_date IS 'Created on';


--
-- Name: COLUMN resource_resource.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_resource.time_efficiency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.time_efficiency IS 'Efficiency Factor';


--
-- Name: COLUMN resource_resource.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.color IS 'Color';


--
-- Name: CONSTRAINT resource_resource_check_time_efficiency ON resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT resource_resource_check_time_efficiency ON public.resource_resource IS 'CHECK(time_efficiency>0)';


--
-- Name: resource_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_resource_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_resource_id_seq OWNER TO runbot;

--
-- Name: resource_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_resource_id_seq OWNED BY public.resource_resource.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: scheduled_message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.scheduled_message_attachment_rel (
    scheduled_message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.scheduled_message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE scheduled_message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.scheduled_message_attachment_rel IS 'RELATION BETWEEN mail_scheduled_message AND ir_attachment';


--
-- Name: server_action_history_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.server_action_history_wizard (
    id integer NOT NULL,
    action_id integer,
    revision integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.server_action_history_wizard OWNER TO runbot;

--
-- Name: TABLE server_action_history_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.server_action_history_wizard IS 'Server Action History Wizard';


--
-- Name: COLUMN server_action_history_wizard.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.action_id IS 'Action';


--
-- Name: COLUMN server_action_history_wizard.revision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.revision IS 'Revision';


--
-- Name: COLUMN server_action_history_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN server_action_history_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN server_action_history_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.create_date IS 'Created on';


--
-- Name: COLUMN server_action_history_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.write_date IS 'Last Updated on';


--
-- Name: server_action_history_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.server_action_history_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.server_action_history_wizard_id_seq OWNER TO runbot;

--
-- Name: server_action_history_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.server_action_history_wizard_id_seq OWNED BY public.server_action_history_wizard.id;


--
-- Name: sms_account_code; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_code (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    verification_code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_code OWNER TO runbot;

--
-- Name: TABLE sms_account_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_code IS 'SMS Account Verification Code Wizard';


--
-- Name: COLUMN sms_account_code.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.account_id IS 'Account';


--
-- Name: COLUMN sms_account_code.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_code.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_code.verification_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.verification_code IS 'Verification Code';


--
-- Name: COLUMN sms_account_code.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_code.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_date IS 'Last Updated on';


--
-- Name: sms_account_code_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_code_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_code_id_seq OWNER TO runbot;

--
-- Name: sms_account_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_code_id_seq OWNED BY public.sms_account_code.id;


--
-- Name: sms_account_phone; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_phone (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone_number character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_phone OWNER TO runbot;

--
-- Name: TABLE sms_account_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_phone IS 'SMS Account Registration Phone Number Wizard';


--
-- Name: COLUMN sms_account_phone.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.account_id IS 'Account';


--
-- Name: COLUMN sms_account_phone.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_phone.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_phone.phone_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.phone_number IS 'Phone Number';


--
-- Name: COLUMN sms_account_phone.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_phone.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_date IS 'Last Updated on';


--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_phone_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_phone_id_seq OWNER TO runbot;

--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_phone_id_seq OWNED BY public.sms_account_phone.id;


--
-- Name: sms_account_sender; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_sender (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    sender_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_sender OWNER TO runbot;

--
-- Name: TABLE sms_account_sender; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_sender IS 'SMS Account Sender Name Wizard';


--
-- Name: COLUMN sms_account_sender.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.account_id IS 'Account';


--
-- Name: COLUMN sms_account_sender.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_sender.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_sender.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.sender_name IS 'Sender Name';


--
-- Name: COLUMN sms_account_sender.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_sender.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_date IS 'Last Updated on';


--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_sender_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_sender_id_seq OWNER TO runbot;

--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_sender_id_seq OWNED BY public.sms_account_sender.id;


--
-- Name: sms_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_composer (
    id integer NOT NULL,
    res_id integer,
    template_id integer,
    create_uid integer,
    write_uid integer,
    composition_mode character varying NOT NULL,
    res_model character varying,
    res_ids character varying,
    recipient_single_number_itf character varying,
    number_field_name character varying,
    numbers character varying,
    body text NOT NULL,
    mass_keep_log boolean,
    mass_force_send boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_composer OWNER TO runbot;

--
-- Name: TABLE sms_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_composer IS 'Send SMS Wizard';


--
-- Name: COLUMN sms_composer.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_id IS 'Document ID';


--
-- Name: COLUMN sms_composer.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.template_id IS 'Use Template';


--
-- Name: COLUMN sms_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_uid IS 'Created by';


--
-- Name: COLUMN sms_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_composer.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.composition_mode IS 'Composition Mode';


--
-- Name: COLUMN sms_composer.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_model IS 'Document Model Name';


--
-- Name: COLUMN sms_composer.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_ids IS 'Document IDs';


--
-- Name: COLUMN sms_composer.recipient_single_number_itf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.recipient_single_number_itf IS 'Recipient Number';


--
-- Name: COLUMN sms_composer.number_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.number_field_name IS 'Number Field';


--
-- Name: COLUMN sms_composer.numbers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.numbers IS 'Recipients (Numbers)';


--
-- Name: COLUMN sms_composer.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.body IS 'Message';


--
-- Name: COLUMN sms_composer.mass_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_keep_log IS 'Keep a note on document';


--
-- Name: COLUMN sms_composer.mass_force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_force_send IS 'Send directly';


--
-- Name: COLUMN sms_composer.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.use_exclusion_list IS 'Use Exclusion List';


--
-- Name: COLUMN sms_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_date IS 'Created on';


--
-- Name: COLUMN sms_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_date IS 'Last Updated on';


--
-- Name: sms_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_composer_id_seq OWNER TO runbot;

--
-- Name: sms_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_composer_id_seq OWNED BY public.sms_composer.id;


--
-- Name: sms_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_sms (
    id integer NOT NULL,
    partner_id integer,
    mail_message_id integer,
    create_uid integer,
    write_uid integer,
    uuid character varying,
    number character varying,
    state character varying NOT NULL,
    failure_type character varying,
    body text,
    to_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_sms OWNER TO runbot;

--
-- Name: TABLE sms_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_sms IS 'Outgoing SMS';


--
-- Name: COLUMN sms_sms.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.partner_id IS 'Customer';


--
-- Name: COLUMN sms_sms.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.mail_message_id IS 'Mail Message';


--
-- Name: COLUMN sms_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_uid IS 'Created by';


--
-- Name: COLUMN sms_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_sms.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.uuid IS 'UUID';


--
-- Name: COLUMN sms_sms.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.number IS 'Number';


--
-- Name: COLUMN sms_sms.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.state IS 'SMS Status';


--
-- Name: COLUMN sms_sms.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.failure_type IS 'Failure Type';


--
-- Name: COLUMN sms_sms.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.body IS 'Body';


--
-- Name: COLUMN sms_sms.to_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.to_delete IS 'Marked for deletion';


--
-- Name: COLUMN sms_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_date IS 'Created on';


--
-- Name: COLUMN sms_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_date IS 'Last Updated on';


--
-- Name: sms_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_sms_id_seq OWNER TO runbot;

--
-- Name: sms_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_sms_id_seq OWNED BY public.sms_sms.id;


--
-- Name: sms_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template (
    id integer NOT NULL,
    model_id integer NOT NULL,
    sidebar_action_id integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    name jsonb,
    body jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template OWNER TO runbot;

--
-- Name: TABLE sms_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template IS 'SMS Templates';


--
-- Name: COLUMN sms_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model_id IS 'Applies to';


--
-- Name: COLUMN sms_template.sidebar_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.sidebar_action_id IS 'Sidebar action';


--
-- Name: COLUMN sms_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN sms_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.lang IS 'Language';


--
-- Name: COLUMN sms_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model IS 'Related Document Model';


--
-- Name: COLUMN sms_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.name IS 'Name';


--
-- Name: COLUMN sms_template.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.body IS 'Body';


--
-- Name: COLUMN sms_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_date IS 'Created on';


--
-- Name: COLUMN sms_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_date IS 'Last Updated on';


--
-- Name: sms_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_id_seq OWNER TO runbot;

--
-- Name: sms_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_id_seq OWNED BY public.sms_template.id;


--
-- Name: sms_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_preview (
    id integer NOT NULL,
    sms_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    resource_ref character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_preview OWNER TO runbot;

--
-- Name: TABLE sms_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_preview IS 'SMS Template Preview';


--
-- Name: COLUMN sms_template_preview.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN sms_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN sms_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.resource_ref IS 'Record reference';


--
-- Name: COLUMN sms_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_date IS 'Last Updated on';


--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_preview_id_seq OWNER TO runbot;

--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_preview_id_seq OWNED BY public.sms_template_preview.id;


--
-- Name: sms_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_reset OWNER TO runbot;

--
-- Name: TABLE sms_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_reset IS 'SMS Template Reset';


--
-- Name: COLUMN sms_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_date IS 'Last Updated on';


--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_reset_id_seq OWNER TO runbot;

--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_reset_id_seq OWNED BY public.sms_template_reset.id;


--
-- Name: sms_template_sms_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_sms_template_reset_rel (
    sms_template_reset_id integer NOT NULL,
    sms_template_id integer NOT NULL
);


ALTER TABLE public.sms_template_sms_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE sms_template_sms_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_sms_template_reset_rel IS 'RELATION BETWEEN sms_template_reset AND sms_template';


--
-- Name: sms_tracker; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_tracker (
    id integer NOT NULL,
    mail_notification_id integer,
    create_uid integer,
    write_uid integer,
    sms_uuid character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_tracker OWNER TO runbot;

--
-- Name: TABLE sms_tracker; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_tracker IS 'Link SMS to mailing/sms tracking models';


--
-- Name: COLUMN sms_tracker.mail_notification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.mail_notification_id IS 'Mail Notification';


--
-- Name: COLUMN sms_tracker.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_uid IS 'Created by';


--
-- Name: COLUMN sms_tracker.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_tracker.sms_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.sms_uuid IS 'SMS uuid';


--
-- Name: COLUMN sms_tracker.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_date IS 'Created on';


--
-- Name: COLUMN sms_tracker.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_date IS 'Last Updated on';


--
-- Name: sms_tracker_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_tracker_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_tracker_id_seq OWNER TO runbot;

--
-- Name: sms_tracker_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_tracker_id_seq OWNED BY public.sms_tracker.id;


--
-- Name: snailmail_letter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.snailmail_letter (
    id integer NOT NULL,
    user_id integer,
    res_id integer NOT NULL,
    partner_id integer NOT NULL,
    company_id integer NOT NULL,
    report_template integer,
    attachment_id integer,
    message_id integer,
    state_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    state character varying NOT NULL,
    error_code character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    info_msg text,
    color boolean,
    cover boolean,
    duplex boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.snailmail_letter OWNER TO runbot;

--
-- Name: TABLE snailmail_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.snailmail_letter IS 'Snailmail Letter';


--
-- Name: COLUMN snailmail_letter.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.user_id IS 'Sent by';


--
-- Name: COLUMN snailmail_letter.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.res_id IS 'Document ID';


--
-- Name: COLUMN snailmail_letter.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.partner_id IS 'Recipient';


--
-- Name: COLUMN snailmail_letter.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.company_id IS 'Company';


--
-- Name: COLUMN snailmail_letter.report_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN snailmail_letter.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.attachment_id IS 'Attachment';


--
-- Name: COLUMN snailmail_letter.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.message_id IS 'Snailmail Status Message';


--
-- Name: COLUMN snailmail_letter.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state_id IS 'State';


--
-- Name: COLUMN snailmail_letter.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.country_id IS 'Country';


--
-- Name: COLUMN snailmail_letter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.model IS 'Model';


--
-- Name: COLUMN snailmail_letter.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state IS 'Status';


--
-- Name: COLUMN snailmail_letter.error_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.error_code IS 'Error';


--
-- Name: COLUMN snailmail_letter.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street IS 'Street';


--
-- Name: COLUMN snailmail_letter.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street2 IS 'Street2';


--
-- Name: COLUMN snailmail_letter.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.zip IS 'Zip';


--
-- Name: COLUMN snailmail_letter.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.city IS 'City';


--
-- Name: COLUMN snailmail_letter.info_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.info_msg IS 'Information';


--
-- Name: COLUMN snailmail_letter.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.color IS 'Color';


--
-- Name: COLUMN snailmail_letter.cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.cover IS 'Cover Page';


--
-- Name: COLUMN snailmail_letter.duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.duplex IS 'Both side';


--
-- Name: COLUMN snailmail_letter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.snailmail_letter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.snailmail_letter_id_seq OWNER TO runbot;

--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.snailmail_letter_id_seq OWNED BY public.snailmail_letter.id;


--
-- Name: spreadsheet_cell_thread; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_cell_thread (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    dashboard_id integer
);


ALTER TABLE public.spreadsheet_cell_thread OWNER TO runbot;

--
-- Name: TABLE spreadsheet_cell_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_cell_thread IS 'Spreadsheet discussion thread';


--
-- Name: COLUMN spreadsheet_cell_thread.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_cell_thread.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_cell_thread.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_cell_thread.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.write_date IS 'Last Updated on';


--
-- Name: COLUMN spreadsheet_cell_thread.dashboard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.dashboard_id IS 'Dashboard';


--
-- Name: spreadsheet_cell_thread_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_cell_thread_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_cell_thread_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_cell_thread_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_cell_thread_id_seq OWNED BY public.spreadsheet_cell_thread.id;


--
-- Name: spreadsheet_dashboard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_dashboard (
    id integer NOT NULL,
    dashboard_group_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    sample_dashboard_file_path character varying,
    name jsonb NOT NULL,
    is_published boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_dashboard OWNER TO runbot;

--
-- Name: TABLE spreadsheet_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_dashboard IS 'Spreadsheet Dashboard';


--
-- Name: COLUMN spreadsheet_dashboard.dashboard_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.dashboard_group_id IS 'Dashboard Group';


--
-- Name: COLUMN spreadsheet_dashboard.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.sequence IS 'Sequence';


--
-- Name: COLUMN spreadsheet_dashboard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_dashboard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_dashboard.sample_dashboard_file_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.sample_dashboard_file_path IS 'Sample Dashboard File Path';


--
-- Name: COLUMN spreadsheet_dashboard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.name IS 'Name';


--
-- Name: COLUMN spreadsheet_dashboard.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.is_published IS 'Is Published';


--
-- Name: COLUMN spreadsheet_dashboard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_dashboard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_dashboard_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_dashboard_group (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_dashboard_group OWNER TO runbot;

--
-- Name: TABLE spreadsheet_dashboard_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_dashboard_group IS 'Group of dashboards';


--
-- Name: COLUMN spreadsheet_dashboard_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.sequence IS 'Sequence';


--
-- Name: COLUMN spreadsheet_dashboard_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_dashboard_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_dashboard_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.name IS 'Name';


--
-- Name: COLUMN spreadsheet_dashboard_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_dashboard_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_dashboard_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_dashboard_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_dashboard_group_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_dashboard_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_dashboard_group_id_seq OWNED BY public.spreadsheet_dashboard_group.id;


--
-- Name: spreadsheet_dashboard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_dashboard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_dashboard_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_dashboard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_dashboard_id_seq OWNED BY public.spreadsheet_dashboard.id;


--
-- Name: spreadsheet_dashboard_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_dashboard_share (
    id integer NOT NULL,
    dashboard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    access_token character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_dashboard_share OWNER TO runbot;

--
-- Name: TABLE spreadsheet_dashboard_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_dashboard_share IS 'Copy of a shared dashboard';


--
-- Name: COLUMN spreadsheet_dashboard_share.dashboard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.dashboard_id IS 'Dashboard';


--
-- Name: COLUMN spreadsheet_dashboard_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_dashboard_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_dashboard_share.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.access_token IS 'Access Token';


--
-- Name: COLUMN spreadsheet_dashboard_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_dashboard_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_dashboard_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_dashboard_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_dashboard_share_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_dashboard_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_dashboard_share_id_seq OWNED BY public.spreadsheet_dashboard_share.id;


--
-- Name: spreadsheet_revision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_revision (
    id integer NOT NULL,
    res_id integer NOT NULL,
    parent_revision_id integer,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    res_model character varying NOT NULL,
    commands character varying NOT NULL,
    revision_uuid character varying NOT NULL,
    active boolean,
    revision_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_revision OWNER TO runbot;

--
-- Name: TABLE spreadsheet_revision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_revision IS 'Collaborative spreadsheet revision';


--
-- Name: COLUMN spreadsheet_revision.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.res_id IS 'Record id';


--
-- Name: COLUMN spreadsheet_revision.parent_revision_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.parent_revision_id IS 'Parent Revision';


--
-- Name: COLUMN spreadsheet_revision.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.author_id IS 'Author';


--
-- Name: COLUMN spreadsheet_revision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_revision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_revision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.name IS 'Revision name';


--
-- Name: COLUMN spreadsheet_revision.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.res_model IS 'Model';


--
-- Name: COLUMN spreadsheet_revision.commands; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.commands IS 'Commands';


--
-- Name: COLUMN spreadsheet_revision.revision_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.revision_uuid IS 'Revision Uuid';


--
-- Name: COLUMN spreadsheet_revision.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.active IS 'Active';


--
-- Name: COLUMN spreadsheet_revision.revision_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.revision_date IS 'Revision Date';


--
-- Name: COLUMN spreadsheet_revision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_revision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_revision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_revision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_revision_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_revision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_revision_id_seq OWNED BY public.spreadsheet_revision.id;


--
-- Name: stock_backorder_confirmation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_backorder_confirmation (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_transfers boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_backorder_confirmation OWNER TO runbot;

--
-- Name: TABLE stock_backorder_confirmation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_backorder_confirmation IS 'Backorder Confirmation';


--
-- Name: COLUMN stock_backorder_confirmation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation.create_uid IS 'Created by';


--
-- Name: COLUMN stock_backorder_confirmation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_backorder_confirmation.show_transfers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation.show_transfers IS 'Show Transfers';


--
-- Name: COLUMN stock_backorder_confirmation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation.create_date IS 'Created on';


--
-- Name: COLUMN stock_backorder_confirmation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation.write_date IS 'Last Updated on';


--
-- Name: stock_backorder_confirmation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_backorder_confirmation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_backorder_confirmation_id_seq OWNER TO runbot;

--
-- Name: stock_backorder_confirmation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_backorder_confirmation_id_seq OWNED BY public.stock_backorder_confirmation.id;


--
-- Name: stock_backorder_confirmation_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_backorder_confirmation_line (
    id integer NOT NULL,
    backorder_confirmation_id integer,
    picking_id integer,
    create_uid integer,
    write_uid integer,
    to_backorder boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_backorder_confirmation_line OWNER TO runbot;

--
-- Name: TABLE stock_backorder_confirmation_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_backorder_confirmation_line IS 'Backorder Confirmation Line';


--
-- Name: COLUMN stock_backorder_confirmation_line.backorder_confirmation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation_line.backorder_confirmation_id IS 'Immediate Transfer';


--
-- Name: COLUMN stock_backorder_confirmation_line.picking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation_line.picking_id IS 'Transfer';


--
-- Name: COLUMN stock_backorder_confirmation_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation_line.create_uid IS 'Created by';


--
-- Name: COLUMN stock_backorder_confirmation_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_backorder_confirmation_line.to_backorder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation_line.to_backorder IS 'To Backorder';


--
-- Name: COLUMN stock_backorder_confirmation_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation_line.create_date IS 'Created on';


--
-- Name: COLUMN stock_backorder_confirmation_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_backorder_confirmation_line.write_date IS 'Last Updated on';


--
-- Name: stock_backorder_confirmation_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_backorder_confirmation_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_backorder_confirmation_line_id_seq OWNER TO runbot;

--
-- Name: stock_backorder_confirmation_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_backorder_confirmation_line_id_seq OWNED BY public.stock_backorder_confirmation_line.id;


--
-- Name: stock_barcode_cancel_operation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_barcode_cancel_operation (
    id integer NOT NULL,
    picking_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_barcode_cancel_operation OWNER TO runbot;

--
-- Name: TABLE stock_barcode_cancel_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_barcode_cancel_operation IS 'Cancel Operation';


--
-- Name: COLUMN stock_barcode_cancel_operation.picking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_barcode_cancel_operation.picking_id IS 'Transfer';


--
-- Name: COLUMN stock_barcode_cancel_operation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_barcode_cancel_operation.create_uid IS 'Created by';


--
-- Name: COLUMN stock_barcode_cancel_operation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_barcode_cancel_operation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_barcode_cancel_operation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_barcode_cancel_operation.create_date IS 'Created on';


--
-- Name: COLUMN stock_barcode_cancel_operation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_barcode_cancel_operation.write_date IS 'Last Updated on';


--
-- Name: stock_barcode_cancel_operation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_barcode_cancel_operation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_barcode_cancel_operation_id_seq OWNER TO runbot;

--
-- Name: stock_barcode_cancel_operation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_barcode_cancel_operation_id_seq OWNED BY public.stock_barcode_cancel_operation.id;


--
-- Name: stock_conflict_quant_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_conflict_quant_rel (
    stock_inventory_conflict_id integer NOT NULL,
    stock_quant_id integer NOT NULL
);


ALTER TABLE public.stock_conflict_quant_rel OWNER TO runbot;

--
-- Name: TABLE stock_conflict_quant_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_conflict_quant_rel IS 'RELATION BETWEEN stock_inventory_conflict AND stock_quant';


--
-- Name: stock_inventory_adjustment_name; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_inventory_adjustment_name (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    inventory_adjustment_name character varying,
    counting_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_inventory_adjustment_name OWNER TO runbot;

--
-- Name: TABLE stock_inventory_adjustment_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_inventory_adjustment_name IS 'Inventory Adjustment Reference / Reason';


--
-- Name: COLUMN stock_inventory_adjustment_name.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_adjustment_name.create_uid IS 'Created by';


--
-- Name: COLUMN stock_inventory_adjustment_name.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_adjustment_name.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_inventory_adjustment_name.inventory_adjustment_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_adjustment_name.inventory_adjustment_name IS 'Inventory Reason';


--
-- Name: COLUMN stock_inventory_adjustment_name.counting_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_adjustment_name.counting_date IS 'Counting Date';


--
-- Name: COLUMN stock_inventory_adjustment_name.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_adjustment_name.create_date IS 'Created on';


--
-- Name: COLUMN stock_inventory_adjustment_name.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_adjustment_name.write_date IS 'Last Updated on';


--
-- Name: stock_inventory_adjustment_name_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_inventory_adjustment_name_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_inventory_adjustment_name_id_seq OWNER TO runbot;

--
-- Name: stock_inventory_adjustment_name_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_inventory_adjustment_name_id_seq OWNED BY public.stock_inventory_adjustment_name.id;


--
-- Name: stock_inventory_adjustment_name_stock_quant_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_inventory_adjustment_name_stock_quant_rel (
    stock_inventory_adjustment_name_id integer NOT NULL,
    stock_quant_id integer NOT NULL
);


ALTER TABLE public.stock_inventory_adjustment_name_stock_quant_rel OWNER TO runbot;

--
-- Name: TABLE stock_inventory_adjustment_name_stock_quant_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_inventory_adjustment_name_stock_quant_rel IS 'RELATION BETWEEN stock_inventory_adjustment_name AND stock_quant';


--
-- Name: stock_inventory_conflict; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_inventory_conflict (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_inventory_conflict OWNER TO runbot;

--
-- Name: TABLE stock_inventory_conflict; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_inventory_conflict IS 'Conflict in Inventory';


--
-- Name: COLUMN stock_inventory_conflict.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_conflict.create_uid IS 'Created by';


--
-- Name: COLUMN stock_inventory_conflict.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_conflict.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_inventory_conflict.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_conflict.create_date IS 'Created on';


--
-- Name: COLUMN stock_inventory_conflict.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_conflict.write_date IS 'Last Updated on';


--
-- Name: stock_inventory_conflict_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_inventory_conflict_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_inventory_conflict_id_seq OWNER TO runbot;

--
-- Name: stock_inventory_conflict_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_inventory_conflict_id_seq OWNED BY public.stock_inventory_conflict.id;


--
-- Name: stock_inventory_conflict_stock_quant_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_inventory_conflict_stock_quant_rel (
    stock_inventory_conflict_id integer NOT NULL,
    stock_quant_id integer NOT NULL
);


ALTER TABLE public.stock_inventory_conflict_stock_quant_rel OWNER TO runbot;

--
-- Name: TABLE stock_inventory_conflict_stock_quant_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_inventory_conflict_stock_quant_rel IS 'RELATION BETWEEN stock_inventory_conflict AND stock_quant';


--
-- Name: stock_inventory_warning; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_inventory_warning (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_inventory_warning OWNER TO runbot;

--
-- Name: TABLE stock_inventory_warning; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_inventory_warning IS 'Inventory Adjustment Warning';


--
-- Name: COLUMN stock_inventory_warning.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_warning.create_uid IS 'Created by';


--
-- Name: COLUMN stock_inventory_warning.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_warning.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_inventory_warning.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_warning.create_date IS 'Created on';


--
-- Name: COLUMN stock_inventory_warning.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_inventory_warning.write_date IS 'Last Updated on';


--
-- Name: stock_inventory_warning_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_inventory_warning_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_inventory_warning_id_seq OWNER TO runbot;

--
-- Name: stock_inventory_warning_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_inventory_warning_id_seq OWNED BY public.stock_inventory_warning.id;


--
-- Name: stock_inventory_warning_stock_quant_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_inventory_warning_stock_quant_rel (
    stock_inventory_warning_id integer NOT NULL,
    stock_quant_id integer NOT NULL
);


ALTER TABLE public.stock_inventory_warning_stock_quant_rel OWNER TO runbot;

--
-- Name: TABLE stock_inventory_warning_stock_quant_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_inventory_warning_stock_quant_rel IS 'RELATION BETWEEN stock_inventory_warning AND stock_quant';


--
-- Name: stock_location_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_location_id_seq OWNER TO runbot;

--
-- Name: stock_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_location_id_seq OWNED BY public.stock_location.id;


--
-- Name: stock_lot; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_lot (
    id integer NOT NULL,
    product_id integer NOT NULL,
    company_id integer,
    location_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    ref character varying,
    lot_properties jsonb,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_lot OWNER TO runbot;

--
-- Name: TABLE stock_lot; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_lot IS 'Lot/Serial';


--
-- Name: COLUMN stock_lot.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.product_id IS 'Product';


--
-- Name: COLUMN stock_lot.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.company_id IS 'Company';


--
-- Name: COLUMN stock_lot.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.location_id IS 'Location';


--
-- Name: COLUMN stock_lot.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.create_uid IS 'Created by';


--
-- Name: COLUMN stock_lot.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_lot.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.name IS 'Lot/Serial Number';


--
-- Name: COLUMN stock_lot.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.ref IS 'Internal Reference';


--
-- Name: COLUMN stock_lot.lot_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.lot_properties IS 'Properties';


--
-- Name: COLUMN stock_lot.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.note IS 'Description';


--
-- Name: COLUMN stock_lot.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.create_date IS 'Created on';


--
-- Name: COLUMN stock_lot.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_lot.write_date IS 'Last Updated on';


--
-- Name: stock_lot_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_lot_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_lot_id_seq OWNER TO runbot;

--
-- Name: stock_lot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_lot_id_seq OWNED BY public.stock_lot.id;


--
-- Name: stock_move_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_move_id_seq OWNER TO runbot;

--
-- Name: stock_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_move_id_seq OWNED BY public.stock_move.id;


--
-- Name: stock_move_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_move_line (
    id integer NOT NULL,
    picking_id integer,
    move_id integer,
    company_id integer NOT NULL,
    product_id integer,
    product_uom_id integer NOT NULL,
    package_id integer,
    lot_id integer,
    result_package_id integer,
    package_history_id integer,
    owner_id integer,
    location_id integer NOT NULL,
    location_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lot_name character varying,
    state character varying,
    quantity numeric,
    quantity_product_uom numeric,
    picked boolean,
    is_entire_pack boolean,
    date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    location_processed boolean
);


ALTER TABLE public.stock_move_line OWNER TO runbot;

--
-- Name: TABLE stock_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_move_line IS 'Product Moves (Stock Move Line)';


--
-- Name: COLUMN stock_move_line.picking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.picking_id IS 'Transfer';


--
-- Name: COLUMN stock_move_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.move_id IS 'Stock Operation';


--
-- Name: COLUMN stock_move_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.company_id IS 'Company';


--
-- Name: COLUMN stock_move_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.product_id IS 'Product';


--
-- Name: COLUMN stock_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.product_uom_id IS 'Unit';


--
-- Name: COLUMN stock_move_line.package_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.package_id IS 'Source Package';


--
-- Name: COLUMN stock_move_line.lot_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.lot_id IS 'Lot/Serial Number';


--
-- Name: COLUMN stock_move_line.result_package_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.result_package_id IS 'Destination Package';


--
-- Name: COLUMN stock_move_line.package_history_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.package_history_id IS 'Package History';


--
-- Name: COLUMN stock_move_line.owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.owner_id IS 'From Owner';


--
-- Name: COLUMN stock_move_line.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.location_id IS 'From';


--
-- Name: COLUMN stock_move_line.location_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.location_dest_id IS 'To';


--
-- Name: COLUMN stock_move_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN stock_move_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_move_line.lot_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.lot_name IS 'Lot/Serial Number Name';


--
-- Name: COLUMN stock_move_line.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.state IS 'Status';


--
-- Name: COLUMN stock_move_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN stock_move_line.quantity_product_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.quantity_product_uom IS 'Quantity in Product UoM';


--
-- Name: COLUMN stock_move_line.picked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.picked IS 'Picked';


--
-- Name: COLUMN stock_move_line.is_entire_pack; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.is_entire_pack IS 'Is added through entire package';


--
-- Name: COLUMN stock_move_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.date IS 'Date';


--
-- Name: COLUMN stock_move_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.create_date IS 'Created on';


--
-- Name: COLUMN stock_move_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN stock_move_line.location_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_move_line.location_processed IS 'Location Processed';


--
-- Name: stock_move_line_consume_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_move_line_consume_rel (
    consume_line_id integer NOT NULL,
    produce_line_id integer NOT NULL
);


ALTER TABLE public.stock_move_line_consume_rel OWNER TO runbot;

--
-- Name: TABLE stock_move_line_consume_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_move_line_consume_rel IS 'RELATION BETWEEN stock_move_line AND stock_move_line';


--
-- Name: stock_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_move_line_id_seq OWNER TO runbot;

--
-- Name: stock_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_move_line_id_seq OWNED BY public.stock_move_line.id;


--
-- Name: stock_move_line_stock_put_in_pack_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_move_line_stock_put_in_pack_rel (
    stock_put_in_pack_id integer NOT NULL,
    stock_move_line_id integer NOT NULL
);


ALTER TABLE public.stock_move_line_stock_put_in_pack_rel OWNER TO runbot;

--
-- Name: TABLE stock_move_line_stock_put_in_pack_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_move_line_stock_put_in_pack_rel IS 'RELATION BETWEEN stock_put_in_pack AND stock_move_line';


--
-- Name: stock_move_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_move_move_rel (
    move_orig_id integer NOT NULL,
    move_dest_id integer NOT NULL
);


ALTER TABLE public.stock_move_move_rel OWNER TO runbot;

--
-- Name: TABLE stock_move_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_move_move_rel IS 'RELATION BETWEEN stock_move AND stock_move';


--
-- Name: stock_orderpoint_snooze; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_orderpoint_snooze (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    predefined_date character varying,
    snoozed_until date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_orderpoint_snooze OWNER TO runbot;

--
-- Name: TABLE stock_orderpoint_snooze; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_orderpoint_snooze IS 'Snooze Orderpoint';


--
-- Name: COLUMN stock_orderpoint_snooze.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_orderpoint_snooze.create_uid IS 'Created by';


--
-- Name: COLUMN stock_orderpoint_snooze.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_orderpoint_snooze.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_orderpoint_snooze.predefined_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_orderpoint_snooze.predefined_date IS 'Snooze for';


--
-- Name: COLUMN stock_orderpoint_snooze.snoozed_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_orderpoint_snooze.snoozed_until IS 'Snooze Date';


--
-- Name: COLUMN stock_orderpoint_snooze.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_orderpoint_snooze.create_date IS 'Created on';


--
-- Name: COLUMN stock_orderpoint_snooze.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_orderpoint_snooze.write_date IS 'Last Updated on';


--
-- Name: stock_orderpoint_snooze_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_orderpoint_snooze_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_orderpoint_snooze_id_seq OWNER TO runbot;

--
-- Name: stock_orderpoint_snooze_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_orderpoint_snooze_id_seq OWNED BY public.stock_orderpoint_snooze.id;


--
-- Name: stock_orderpoint_snooze_stock_warehouse_orderpoint_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_orderpoint_snooze_stock_warehouse_orderpoint_rel (
    stock_orderpoint_snooze_id integer NOT NULL,
    stock_warehouse_orderpoint_id integer NOT NULL
);


ALTER TABLE public.stock_orderpoint_snooze_stock_warehouse_orderpoint_rel OWNER TO runbot;

--
-- Name: TABLE stock_orderpoint_snooze_stock_warehouse_orderpoint_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_orderpoint_snooze_stock_warehouse_orderpoint_rel IS 'RELATION BETWEEN stock_orderpoint_snooze AND stock_warehouse_orderpoint';


--
-- Name: stock_package; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_package (
    id integer NOT NULL,
    package_type_id integer,
    location_id integer,
    company_id integer,
    parent_package_id integer,
    package_dest_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    parent_path character varying,
    pack_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    shipping_weight double precision
);


ALTER TABLE public.stock_package OWNER TO runbot;

--
-- Name: TABLE stock_package; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_package IS 'Package';


--
-- Name: COLUMN stock_package.package_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.package_type_id IS 'Package Type';


--
-- Name: COLUMN stock_package.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.location_id IS 'Location';


--
-- Name: COLUMN stock_package.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.company_id IS 'Company';


--
-- Name: COLUMN stock_package.parent_package_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.parent_package_id IS 'Container';


--
-- Name: COLUMN stock_package.package_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.package_dest_id IS 'Destination Container';


--
-- Name: COLUMN stock_package.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.create_uid IS 'Created by';


--
-- Name: COLUMN stock_package.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_package.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.name IS 'Package Reference';


--
-- Name: COLUMN stock_package.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.complete_name IS 'Full Package Name';


--
-- Name: COLUMN stock_package.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.parent_path IS 'Parent Path';


--
-- Name: COLUMN stock_package.pack_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.pack_date IS 'Pack Date';


--
-- Name: COLUMN stock_package.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.create_date IS 'Created on';


--
-- Name: COLUMN stock_package.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.write_date IS 'Last Updated on';


--
-- Name: COLUMN stock_package.shipping_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package.shipping_weight IS 'Shipping Weight';


--
-- Name: stock_package_destination; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_package_destination (
    id integer NOT NULL,
    location_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_package_destination OWNER TO runbot;

--
-- Name: TABLE stock_package_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_package_destination IS 'Stock Package Destination';


--
-- Name: COLUMN stock_package_destination.location_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_destination.location_dest_id IS 'Destination location';


--
-- Name: COLUMN stock_package_destination.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_destination.create_uid IS 'Created by';


--
-- Name: COLUMN stock_package_destination.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_destination.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_package_destination.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_destination.create_date IS 'Created on';


--
-- Name: COLUMN stock_package_destination.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_destination.write_date IS 'Last Updated on';


--
-- Name: stock_package_destination_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_package_destination_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_package_destination_id_seq OWNER TO runbot;

--
-- Name: stock_package_destination_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_package_destination_id_seq OWNED BY public.stock_package_destination.id;


--
-- Name: stock_package_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_package_history (
    id integer NOT NULL,
    company_id integer NOT NULL,
    location_id integer,
    location_dest_id integer,
    package_id integer NOT NULL,
    parent_orig_id integer,
    parent_dest_id integer,
    outermost_dest_id integer,
    create_uid integer,
    write_uid integer,
    package_name character varying NOT NULL,
    parent_orig_name character varying,
    parent_dest_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_package_history OWNER TO runbot;

--
-- Name: TABLE stock_package_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_package_history IS 'Stock Package History';


--
-- Name: COLUMN stock_package_history.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.company_id IS 'Company';


--
-- Name: COLUMN stock_package_history.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.location_id IS 'Origin Location';


--
-- Name: COLUMN stock_package_history.location_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.location_dest_id IS 'Destination Location';


--
-- Name: COLUMN stock_package_history.package_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.package_id IS 'Package';


--
-- Name: COLUMN stock_package_history.parent_orig_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.parent_orig_id IS 'Origin Container';


--
-- Name: COLUMN stock_package_history.parent_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.parent_dest_id IS 'Destination Container';


--
-- Name: COLUMN stock_package_history.outermost_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.outermost_dest_id IS 'Outermost Destination Container';


--
-- Name: COLUMN stock_package_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.create_uid IS 'Created by';


--
-- Name: COLUMN stock_package_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_package_history.package_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.package_name IS 'Package Name';


--
-- Name: COLUMN stock_package_history.parent_orig_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.parent_orig_name IS 'Origin Container Name';


--
-- Name: COLUMN stock_package_history.parent_dest_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.parent_dest_name IS 'Destination Container Name';


--
-- Name: COLUMN stock_package_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.create_date IS 'Created on';


--
-- Name: COLUMN stock_package_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_history.write_date IS 'Last Updated on';


--
-- Name: stock_package_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_package_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_package_history_id_seq OWNER TO runbot;

--
-- Name: stock_package_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_package_history_id_seq OWNED BY public.stock_package_history.id;


--
-- Name: stock_package_history_stock_picking_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_package_history_stock_picking_rel (
    stock_picking_id integer NOT NULL,
    stock_package_history_id integer NOT NULL
);


ALTER TABLE public.stock_package_history_stock_picking_rel OWNER TO runbot;

--
-- Name: TABLE stock_package_history_stock_picking_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_package_history_stock_picking_rel IS 'RELATION BETWEEN stock_picking AND stock_package_history';


--
-- Name: stock_package_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_package_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_package_id_seq OWNER TO runbot;

--
-- Name: stock_package_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_package_id_seq OWNED BY public.stock_package.id;


--
-- Name: stock_package_stock_put_in_pack_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_package_stock_put_in_pack_rel (
    stock_put_in_pack_id integer NOT NULL,
    stock_package_id integer NOT NULL
);


ALTER TABLE public.stock_package_stock_put_in_pack_rel OWNER TO runbot;

--
-- Name: TABLE stock_package_stock_put_in_pack_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_package_stock_put_in_pack_rel IS 'RELATION BETWEEN stock_put_in_pack AND stock_package';


--
-- Name: stock_package_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_package_type (
    id integer NOT NULL,
    sequence integer,
    sequence_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    barcode character varying,
    package_use character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    height double precision,
    width double precision,
    packaging_length double precision,
    base_weight double precision,
    max_weight double precision,
    CONSTRAINT stock_package_type_positive_height CHECK ((height >= (0.0)::double precision)),
    CONSTRAINT stock_package_type_positive_length CHECK ((packaging_length >= (0.0)::double precision)),
    CONSTRAINT stock_package_type_positive_max_weight CHECK ((max_weight >= (0.0)::double precision)),
    CONSTRAINT stock_package_type_positive_width CHECK ((width >= (0.0)::double precision))
);


ALTER TABLE public.stock_package_type OWNER TO runbot;

--
-- Name: TABLE stock_package_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_package_type IS 'Stock package type';


--
-- Name: COLUMN stock_package_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.sequence IS 'Sequence';


--
-- Name: COLUMN stock_package_type.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.sequence_id IS 'Reference Sequence';


--
-- Name: COLUMN stock_package_type.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.company_id IS 'Company';


--
-- Name: COLUMN stock_package_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.create_uid IS 'Created by';


--
-- Name: COLUMN stock_package_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_package_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.name IS 'Package Type';


--
-- Name: COLUMN stock_package_type.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.barcode IS 'Barcode';


--
-- Name: COLUMN stock_package_type.package_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.package_use IS 'Package Use';


--
-- Name: COLUMN stock_package_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.create_date IS 'Created on';


--
-- Name: COLUMN stock_package_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN stock_package_type.height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.height IS 'Height';


--
-- Name: COLUMN stock_package_type.width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.width IS 'Width';


--
-- Name: COLUMN stock_package_type.packaging_length; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.packaging_length IS 'Length';


--
-- Name: COLUMN stock_package_type.base_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.base_weight IS 'Weight';


--
-- Name: COLUMN stock_package_type.max_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_package_type.max_weight IS 'Max Weight';


--
-- Name: CONSTRAINT stock_package_type_positive_height ON stock_package_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT stock_package_type_positive_height ON public.stock_package_type IS 'CHECK(height>=0.0)';


--
-- Name: CONSTRAINT stock_package_type_positive_length ON stock_package_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT stock_package_type_positive_length ON public.stock_package_type IS 'CHECK(packaging_length>=0.0)';


--
-- Name: CONSTRAINT stock_package_type_positive_max_weight ON stock_package_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT stock_package_type_positive_max_weight ON public.stock_package_type IS 'CHECK(max_weight>=0.0)';


--
-- Name: CONSTRAINT stock_package_type_positive_width ON stock_package_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT stock_package_type_positive_width ON public.stock_package_type IS 'CHECK(width>=0.0)';


--
-- Name: stock_package_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_package_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_package_type_id_seq OWNER TO runbot;

--
-- Name: stock_package_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_package_type_id_seq OWNED BY public.stock_package_type.id;


--
-- Name: stock_package_type_stock_putaway_rule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_package_type_stock_putaway_rule_rel (
    stock_putaway_rule_id integer NOT NULL,
    stock_package_type_id integer NOT NULL
);


ALTER TABLE public.stock_package_type_stock_putaway_rule_rel OWNER TO runbot;

--
-- Name: TABLE stock_package_type_stock_putaway_rule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_package_type_stock_putaway_rule_rel IS 'RELATION BETWEEN stock_putaway_rule AND stock_package_type';


--
-- Name: stock_package_type_stock_route_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_package_type_stock_route_rel (
    stock_package_type_id integer NOT NULL,
    stock_route_id integer NOT NULL
);


ALTER TABLE public.stock_package_type_stock_route_rel OWNER TO runbot;

--
-- Name: TABLE stock_package_type_stock_route_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_package_type_stock_route_rel IS 'RELATION BETWEEN stock_package_type AND stock_route';


--
-- Name: stock_picking; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_picking (
    id integer NOT NULL,
    backorder_id integer,
    return_id integer,
    location_id integer NOT NULL,
    location_dest_id integer NOT NULL,
    picking_type_id integer NOT NULL,
    partner_id integer,
    company_id integer,
    user_id integer,
    owner_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    origin character varying,
    move_type character varying NOT NULL,
    state character varying,
    priority character varying,
    picking_properties jsonb,
    note text,
    shipping_weight numeric,
    has_deadline_issue boolean,
    printed boolean,
    is_locked boolean,
    scheduled_date timestamp without time zone,
    date_deadline timestamp without time zone,
    date_done timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_picking OWNER TO runbot;

--
-- Name: TABLE stock_picking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_picking IS 'Transfer';


--
-- Name: COLUMN stock_picking.backorder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.backorder_id IS 'Back Order of';


--
-- Name: COLUMN stock_picking.return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.return_id IS 'Return of';


--
-- Name: COLUMN stock_picking.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.location_id IS 'Source Location';


--
-- Name: COLUMN stock_picking.location_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.location_dest_id IS 'Destination Location';


--
-- Name: COLUMN stock_picking.picking_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.picking_type_id IS 'Operation Type';


--
-- Name: COLUMN stock_picking.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.partner_id IS 'Contact';


--
-- Name: COLUMN stock_picking.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.company_id IS 'Company';


--
-- Name: COLUMN stock_picking.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.user_id IS 'Responsible';


--
-- Name: COLUMN stock_picking.owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.owner_id IS 'Assign Owner';


--
-- Name: COLUMN stock_picking.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.create_uid IS 'Created by';


--
-- Name: COLUMN stock_picking.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_picking.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.name IS 'Reference';


--
-- Name: COLUMN stock_picking.origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.origin IS 'Source Document';


--
-- Name: COLUMN stock_picking.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.move_type IS 'Shipping Policy';


--
-- Name: COLUMN stock_picking.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.state IS 'Status';


--
-- Name: COLUMN stock_picking.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.priority IS 'Priority';


--
-- Name: COLUMN stock_picking.picking_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.picking_properties IS 'Properties';


--
-- Name: COLUMN stock_picking.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.note IS 'Notes';


--
-- Name: COLUMN stock_picking.shipping_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.shipping_weight IS 'Weight for Shipping';


--
-- Name: COLUMN stock_picking.has_deadline_issue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.has_deadline_issue IS 'Is late';


--
-- Name: COLUMN stock_picking.printed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.printed IS 'Printed';


--
-- Name: COLUMN stock_picking.is_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.is_locked IS 'Is Locked';


--
-- Name: COLUMN stock_picking.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN stock_picking.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.date_deadline IS 'Deadline';


--
-- Name: COLUMN stock_picking.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.date_done IS 'Date of Transfer';


--
-- Name: COLUMN stock_picking.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.create_date IS 'Created on';


--
-- Name: COLUMN stock_picking.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking.write_date IS 'Last Updated on';


--
-- Name: stock_picking_backorder_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_picking_backorder_rel (
    stock_backorder_confirmation_id integer NOT NULL,
    stock_picking_id integer NOT NULL
);


ALTER TABLE public.stock_picking_backorder_rel OWNER TO runbot;

--
-- Name: TABLE stock_picking_backorder_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_picking_backorder_rel IS 'RELATION BETWEEN stock_backorder_confirmation AND stock_picking';


--
-- Name: stock_picking_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_picking_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_picking_id_seq OWNER TO runbot;

--
-- Name: stock_picking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_picking_id_seq OWNED BY public.stock_picking.id;


--
-- Name: stock_picking_sms_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_picking_sms_rel (
    confirm_stock_sms_id integer NOT NULL,
    stock_picking_id integer NOT NULL
);


ALTER TABLE public.stock_picking_sms_rel OWNER TO runbot;

--
-- Name: TABLE stock_picking_sms_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_picking_sms_rel IS 'RELATION BETWEEN confirm_stock_sms AND stock_picking';


--
-- Name: stock_picking_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_picking_type (
    id integer NOT NULL,
    color integer,
    sequence integer,
    sequence_id integer,
    default_location_src_id integer NOT NULL,
    default_location_dest_id integer NOT NULL,
    return_picking_type_id integer,
    warehouse_id integer,
    reservation_days_before integer,
    reservation_days_before_priority integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    sequence_code character varying NOT NULL,
    code character varying NOT NULL,
    reservation_method character varying NOT NULL,
    product_label_format character varying,
    lot_label_format character varying,
    package_label_to_print character varying,
    barcode character varying,
    create_backorder character varying NOT NULL,
    move_type character varying NOT NULL,
    name jsonb NOT NULL,
    picking_properties_definition jsonb,
    show_entire_packs boolean,
    set_package_type boolean,
    active boolean,
    use_create_lots boolean,
    use_existing_lots boolean,
    print_label boolean,
    show_operations boolean,
    auto_show_reception_report boolean,
    auto_print_delivery_slip boolean,
    auto_print_return_slip boolean,
    auto_print_product_labels boolean,
    auto_print_lot_labels boolean,
    auto_print_reception_report boolean,
    auto_print_reception_report_labels boolean,
    auto_print_packages boolean,
    auto_print_package_label boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    restrict_put_in_pack character varying NOT NULL,
    restrict_scan_tracking_number character varying NOT NULL,
    restrict_scan_source_location character varying NOT NULL,
    restrict_scan_dest_location character varying NOT NULL,
    barcode_allow_extra_product boolean,
    barcode_validation_after_dest_location boolean,
    barcode_validation_all_product_packed boolean,
    barcode_validation_full boolean,
    restrict_scan_product boolean,
    show_reserved_sns boolean
);


ALTER TABLE public.stock_picking_type OWNER TO runbot;

--
-- Name: TABLE stock_picking_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_picking_type IS 'Picking Type';


--
-- Name: COLUMN stock_picking_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.color IS 'Color';


--
-- Name: COLUMN stock_picking_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.sequence IS 'Sequence';


--
-- Name: COLUMN stock_picking_type.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.sequence_id IS 'Reference Sequence';


--
-- Name: COLUMN stock_picking_type.default_location_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.default_location_src_id IS 'Source Location';


--
-- Name: COLUMN stock_picking_type.default_location_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.default_location_dest_id IS 'Destination Location';


--
-- Name: COLUMN stock_picking_type.return_picking_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.return_picking_type_id IS 'Operation Type for Returns';


--
-- Name: COLUMN stock_picking_type.warehouse_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN stock_picking_type.reservation_days_before; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.reservation_days_before IS 'Days';


--
-- Name: COLUMN stock_picking_type.reservation_days_before_priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.reservation_days_before_priority IS 'Days when starred';


--
-- Name: COLUMN stock_picking_type.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.company_id IS 'Company';


--
-- Name: COLUMN stock_picking_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.create_uid IS 'Created by';


--
-- Name: COLUMN stock_picking_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_picking_type.sequence_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.sequence_code IS 'Sequence Prefix';


--
-- Name: COLUMN stock_picking_type.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.code IS 'Type of Operation';


--
-- Name: COLUMN stock_picking_type.reservation_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.reservation_method IS 'Reservation Method';


--
-- Name: COLUMN stock_picking_type.product_label_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.product_label_format IS 'Product Label Format to auto-print';


--
-- Name: COLUMN stock_picking_type.lot_label_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.lot_label_format IS 'Lot Label Format to auto-print';


--
-- Name: COLUMN stock_picking_type.package_label_to_print; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.package_label_to_print IS 'Package Label to Print';


--
-- Name: COLUMN stock_picking_type.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.barcode IS 'Barcode';


--
-- Name: COLUMN stock_picking_type.create_backorder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.create_backorder IS 'Create Backorder';


--
-- Name: COLUMN stock_picking_type.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.move_type IS 'Shipping Policy';


--
-- Name: COLUMN stock_picking_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.name IS 'Operation Type';


--
-- Name: COLUMN stock_picking_type.picking_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.picking_properties_definition IS 'Picking Properties';


--
-- Name: COLUMN stock_picking_type.show_entire_packs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.show_entire_packs IS 'Move Entire Packages';


--
-- Name: COLUMN stock_picking_type.set_package_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.set_package_type IS 'Set Package Type';


--
-- Name: COLUMN stock_picking_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.active IS 'Active';


--
-- Name: COLUMN stock_picking_type.use_create_lots; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.use_create_lots IS 'Create New Lots/Serial Numbers';


--
-- Name: COLUMN stock_picking_type.use_existing_lots; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.use_existing_lots IS 'Use Existing Lots/Serial Numbers';


--
-- Name: COLUMN stock_picking_type.print_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.print_label IS 'Generate Shipping Labels';


--
-- Name: COLUMN stock_picking_type.show_operations; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.show_operations IS 'Show Detailed Operations';


--
-- Name: COLUMN stock_picking_type.auto_show_reception_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.auto_show_reception_report IS 'Show Reception Report at Validation';


--
-- Name: COLUMN stock_picking_type.auto_print_delivery_slip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.auto_print_delivery_slip IS 'Auto Print Delivery Slip';


--
-- Name: COLUMN stock_picking_type.auto_print_return_slip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.auto_print_return_slip IS 'Auto Print Return Slip';


--
-- Name: COLUMN stock_picking_type.auto_print_product_labels; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.auto_print_product_labels IS 'Auto Print Product Labels';


--
-- Name: COLUMN stock_picking_type.auto_print_lot_labels; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.auto_print_lot_labels IS 'Auto Print Lot/SN Labels';


--
-- Name: COLUMN stock_picking_type.auto_print_reception_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.auto_print_reception_report IS 'Auto Print Reception Report';


--
-- Name: COLUMN stock_picking_type.auto_print_reception_report_labels; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.auto_print_reception_report_labels IS 'Auto Print Reception Report Labels';


--
-- Name: COLUMN stock_picking_type.auto_print_packages; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.auto_print_packages IS 'Auto Print Packages';


--
-- Name: COLUMN stock_picking_type.auto_print_package_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.auto_print_package_label IS 'Auto Print Package Label';


--
-- Name: COLUMN stock_picking_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.create_date IS 'Created on';


--
-- Name: COLUMN stock_picking_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN stock_picking_type.restrict_put_in_pack; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.restrict_put_in_pack IS 'Force put in pack?';


--
-- Name: COLUMN stock_picking_type.restrict_scan_tracking_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.restrict_scan_tracking_number IS 'Force Lot/Serial scan?';


--
-- Name: COLUMN stock_picking_type.restrict_scan_source_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.restrict_scan_source_location IS 'Force Source Location scan?';


--
-- Name: COLUMN stock_picking_type.restrict_scan_dest_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.restrict_scan_dest_location IS 'Force Destination Location scan?';


--
-- Name: COLUMN stock_picking_type.barcode_allow_extra_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.barcode_allow_extra_product IS 'Allow extra products';


--
-- Name: COLUMN stock_picking_type.barcode_validation_after_dest_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.barcode_validation_after_dest_location IS 'Force a destination for all products';


--
-- Name: COLUMN stock_picking_type.barcode_validation_all_product_packed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.barcode_validation_all_product_packed IS 'Force all products to be packed';


--
-- Name: COLUMN stock_picking_type.barcode_validation_full; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.barcode_validation_full IS 'Allow full picking validation';


--
-- Name: COLUMN stock_picking_type.restrict_scan_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.restrict_scan_product IS 'Force Product scan?';


--
-- Name: COLUMN stock_picking_type.show_reserved_sns; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_picking_type.show_reserved_sns IS 'Show reserved lots/SN';


--
-- Name: stock_picking_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_picking_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_picking_type_id_seq OWNER TO runbot;

--
-- Name: stock_picking_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_picking_type_id_seq OWNED BY public.stock_picking_type.id;


--
-- Name: stock_put_in_pack; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_put_in_pack (
    id integer NOT NULL,
    location_dest_id integer,
    package_type_id integer,
    result_package_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_put_in_pack OWNER TO runbot;

--
-- Name: TABLE stock_put_in_pack; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_put_in_pack IS 'Put In Pack Wizard';


--
-- Name: COLUMN stock_put_in_pack.location_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_put_in_pack.location_dest_id IS 'Destination';


--
-- Name: COLUMN stock_put_in_pack.package_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_put_in_pack.package_type_id IS 'Package Type';


--
-- Name: COLUMN stock_put_in_pack.result_package_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_put_in_pack.result_package_id IS 'Package';


--
-- Name: COLUMN stock_put_in_pack.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_put_in_pack.create_uid IS 'Created by';


--
-- Name: COLUMN stock_put_in_pack.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_put_in_pack.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_put_in_pack.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_put_in_pack.create_date IS 'Created on';


--
-- Name: COLUMN stock_put_in_pack.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_put_in_pack.write_date IS 'Last Updated on';


--
-- Name: stock_put_in_pack_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_put_in_pack_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_put_in_pack_id_seq OWNER TO runbot;

--
-- Name: stock_put_in_pack_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_put_in_pack_id_seq OWNED BY public.stock_put_in_pack.id;


--
-- Name: stock_putaway_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_putaway_rule (
    id integer NOT NULL,
    product_id integer,
    category_id integer,
    location_in_id integer NOT NULL,
    location_out_id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    storage_category_id integer,
    create_uid integer,
    write_uid integer,
    sublocation character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_putaway_rule OWNER TO runbot;

--
-- Name: TABLE stock_putaway_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_putaway_rule IS 'Putaway Rule';


--
-- Name: COLUMN stock_putaway_rule.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.product_id IS 'Product';


--
-- Name: COLUMN stock_putaway_rule.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.category_id IS 'Product Category';


--
-- Name: COLUMN stock_putaway_rule.location_in_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.location_in_id IS 'When product arrives in';


--
-- Name: COLUMN stock_putaway_rule.location_out_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.location_out_id IS 'Store to sublocation';


--
-- Name: COLUMN stock_putaway_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.sequence IS 'Priority';


--
-- Name: COLUMN stock_putaway_rule.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.company_id IS 'Company';


--
-- Name: COLUMN stock_putaway_rule.storage_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.storage_category_id IS 'Storage Category';


--
-- Name: COLUMN stock_putaway_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.create_uid IS 'Created by';


--
-- Name: COLUMN stock_putaway_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_putaway_rule.sublocation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.sublocation IS 'Sublocation';


--
-- Name: COLUMN stock_putaway_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.active IS 'Active';


--
-- Name: COLUMN stock_putaway_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.create_date IS 'Created on';


--
-- Name: COLUMN stock_putaway_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_putaway_rule.write_date IS 'Last Updated on';


--
-- Name: stock_putaway_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_putaway_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_putaway_rule_id_seq OWNER TO runbot;

--
-- Name: stock_putaway_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_putaway_rule_id_seq OWNED BY public.stock_putaway_rule.id;


--
-- Name: stock_quant_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_quant_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_quant_id_seq OWNER TO runbot;

--
-- Name: stock_quant_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_quant_id_seq OWNED BY public.stock_quant.id;


--
-- Name: stock_quant_relocate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_quant_relocate (
    id integer NOT NULL,
    dest_location_id integer,
    dest_package_id integer,
    create_uid integer,
    write_uid integer,
    message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_quant_relocate OWNER TO runbot;

--
-- Name: TABLE stock_quant_relocate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_quant_relocate IS 'Stock Quantity Relocation';


--
-- Name: COLUMN stock_quant_relocate.dest_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant_relocate.dest_location_id IS 'Dest Location';


--
-- Name: COLUMN stock_quant_relocate.dest_package_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant_relocate.dest_package_id IS 'Dest Package';


--
-- Name: COLUMN stock_quant_relocate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant_relocate.create_uid IS 'Created by';


--
-- Name: COLUMN stock_quant_relocate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant_relocate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_quant_relocate.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant_relocate.message IS 'Reason for relocation';


--
-- Name: COLUMN stock_quant_relocate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant_relocate.create_date IS 'Created on';


--
-- Name: COLUMN stock_quant_relocate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quant_relocate.write_date IS 'Last Updated on';


--
-- Name: stock_quant_relocate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_quant_relocate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_quant_relocate_id_seq OWNER TO runbot;

--
-- Name: stock_quant_relocate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_quant_relocate_id_seq OWNED BY public.stock_quant_relocate.id;


--
-- Name: stock_quant_stock_quant_relocate_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_quant_stock_quant_relocate_rel (
    stock_quant_relocate_id integer NOT NULL,
    stock_quant_id integer NOT NULL
);


ALTER TABLE public.stock_quant_stock_quant_relocate_rel OWNER TO runbot;

--
-- Name: TABLE stock_quant_stock_quant_relocate_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_quant_stock_quant_relocate_rel IS 'RELATION BETWEEN stock_quant_relocate AND stock_quant';


--
-- Name: stock_quant_stock_request_count_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_quant_stock_request_count_rel (
    stock_request_count_id integer NOT NULL,
    stock_quant_id integer NOT NULL
);


ALTER TABLE public.stock_quant_stock_request_count_rel OWNER TO runbot;

--
-- Name: TABLE stock_quant_stock_request_count_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_quant_stock_request_count_rel IS 'RELATION BETWEEN stock_request_count AND stock_quant';


--
-- Name: stock_quantity_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_quantity_history (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    inventory_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_quantity_history OWNER TO runbot;

--
-- Name: TABLE stock_quantity_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_quantity_history IS 'Stock Quantity History';


--
-- Name: COLUMN stock_quantity_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quantity_history.create_uid IS 'Created by';


--
-- Name: COLUMN stock_quantity_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quantity_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_quantity_history.inventory_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quantity_history.inventory_datetime IS 'Inventory at Date';


--
-- Name: COLUMN stock_quantity_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quantity_history.create_date IS 'Created on';


--
-- Name: COLUMN stock_quantity_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_quantity_history.write_date IS 'Last Updated on';


--
-- Name: stock_quantity_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_quantity_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_quantity_history_id_seq OWNER TO runbot;

--
-- Name: stock_quantity_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_quantity_history_id_seq OWNED BY public.stock_quantity_history.id;


--
-- Name: stock_reference; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_reference (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_reference OWNER TO runbot;

--
-- Name: TABLE stock_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_reference IS 'Reference between stock documents';


--
-- Name: COLUMN stock_reference.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_reference.create_uid IS 'Created by';


--
-- Name: COLUMN stock_reference.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_reference.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_reference.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_reference.name IS 'Reference';


--
-- Name: COLUMN stock_reference.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_reference.create_date IS 'Created on';


--
-- Name: COLUMN stock_reference.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_reference.write_date IS 'Last Updated on';


--
-- Name: stock_reference_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_reference_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_reference_id_seq OWNER TO runbot;

--
-- Name: stock_reference_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_reference_id_seq OWNED BY public.stock_reference.id;


--
-- Name: stock_reference_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_reference_move_rel (
    move_id integer NOT NULL,
    reference_id integer NOT NULL
);


ALTER TABLE public.stock_reference_move_rel OWNER TO runbot;

--
-- Name: TABLE stock_reference_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_reference_move_rel IS 'RELATION BETWEEN stock_move AND stock_reference';


--
-- Name: stock_replenishment_info; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_replenishment_info (
    id integer NOT NULL,
    orderpoint_id integer,
    percent_factor integer NOT NULL,
    create_uid integer,
    write_uid integer,
    based_on character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_replenishment_info OWNER TO runbot;

--
-- Name: TABLE stock_replenishment_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_replenishment_info IS 'Stock supplier replenishment information';


--
-- Name: COLUMN stock_replenishment_info.orderpoint_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_info.orderpoint_id IS 'Orderpoint';


--
-- Name: COLUMN stock_replenishment_info.percent_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_info.percent_factor IS 'Percent Factor';


--
-- Name: COLUMN stock_replenishment_info.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_info.create_uid IS 'Created by';


--
-- Name: COLUMN stock_replenishment_info.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_info.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_replenishment_info.based_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_info.based_on IS 'Based on';


--
-- Name: COLUMN stock_replenishment_info.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_info.create_date IS 'Created on';


--
-- Name: COLUMN stock_replenishment_info.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_info.write_date IS 'Last Updated on';


--
-- Name: stock_replenishment_info_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_replenishment_info_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_replenishment_info_id_seq OWNER TO runbot;

--
-- Name: stock_replenishment_info_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_replenishment_info_id_seq OWNED BY public.stock_replenishment_info.id;


--
-- Name: stock_replenishment_option; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_replenishment_option (
    id integer NOT NULL,
    route_id integer,
    product_id integer,
    replenishment_info_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_replenishment_option OWNER TO runbot;

--
-- Name: TABLE stock_replenishment_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_replenishment_option IS 'Stock warehouse replenishment option';


--
-- Name: COLUMN stock_replenishment_option.route_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_option.route_id IS 'Route';


--
-- Name: COLUMN stock_replenishment_option.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_option.product_id IS 'Product';


--
-- Name: COLUMN stock_replenishment_option.replenishment_info_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_option.replenishment_info_id IS 'Replenishment Info';


--
-- Name: COLUMN stock_replenishment_option.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_option.create_uid IS 'Created by';


--
-- Name: COLUMN stock_replenishment_option.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_option.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_replenishment_option.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_option.create_date IS 'Created on';


--
-- Name: COLUMN stock_replenishment_option.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_replenishment_option.write_date IS 'Last Updated on';


--
-- Name: stock_replenishment_option_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_replenishment_option_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_replenishment_option_id_seq OWNER TO runbot;

--
-- Name: stock_replenishment_option_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_replenishment_option_id_seq OWNED BY public.stock_replenishment_option.id;


--
-- Name: stock_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.stock_report AS
 SELECT sm.id,
    sp.name AS picking_name,
    sp.date_done,
    sp.creation_date,
    sp.scheduled_date,
    sp.partner_id,
    sp.is_backorder,
    sp.delay,
    (sp.delay > (0)::numeric) AS is_late,
    sp.cycle_time,
    spt.code AS picking_type_code,
    spt.id AS operation_type_id,
    p.id AS product_id,
    sm.reference,
    sm.picking_id,
    sm.state,
    sm.product_qty,
    sm.company_id,
    cat.id AS categ_id
   FROM (((((public.stock_move sm
     LEFT JOIN ( SELECT stock_picking.id,
            stock_picking.name,
            stock_picking.date_done,
            stock_picking.create_date AS creation_date,
            stock_picking.scheduled_date,
            stock_picking.partner_id,
            (stock_picking.backorder_id IS NOT NULL) AS is_backorder,
            ((EXTRACT(epoch FROM avg((stock_picking.date_done - stock_picking.scheduled_date))) / (((24 * 60) * 60))::numeric))::numeric(16,2) AS delay,
            ((EXTRACT(epoch FROM avg((stock_picking.date_done - stock_picking.create_date))) / (((24 * 60) * 60))::numeric))::numeric(16,2) AS cycle_time
           FROM public.stock_picking
          GROUP BY stock_picking.id, stock_picking.name, stock_picking.date_done, stock_picking.create_date, stock_picking.scheduled_date, stock_picking.partner_id, (stock_picking.backorder_id IS NOT NULL)) sp ON ((sm.picking_id = sp.id)))
     LEFT JOIN public.stock_picking_type spt ON ((sm.picking_type_id = spt.id)))
     JOIN public.product_product p ON ((sm.product_id = p.id)))
     JOIN public.product_template t ON ((p.product_tmpl_id = t.id)))
     JOIN public.product_category cat ON ((t.categ_id = cat.id)))
  WHERE (t.is_storable = true)
  GROUP BY sm.id, sm.reference, sm.picking_id, sm.state, sm.product_qty, sm.company_id, sp.name, sp.date_done, sp.creation_date, sp.scheduled_date, sp.partner_id, sp.is_backorder, sp.delay, sp.cycle_time, spt.code, spt.id, p.id, (sp.delay > (0)::numeric), cat.id;


ALTER VIEW public.stock_report OWNER TO runbot;

--
-- Name: stock_request_count; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_request_count (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    inventory_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_request_count OWNER TO runbot;

--
-- Name: TABLE stock_request_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_request_count IS 'Stock Request an Inventory Count';


--
-- Name: COLUMN stock_request_count.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_request_count.user_id IS 'Assign to';


--
-- Name: COLUMN stock_request_count.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_request_count.create_uid IS 'Created by';


--
-- Name: COLUMN stock_request_count.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_request_count.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_request_count.inventory_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_request_count.inventory_date IS 'Scheduled at';


--
-- Name: COLUMN stock_request_count.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_request_count.create_date IS 'Created on';


--
-- Name: COLUMN stock_request_count.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_request_count.write_date IS 'Last Updated on';


--
-- Name: stock_request_count_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_request_count_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_request_count_id_seq OWNER TO runbot;

--
-- Name: stock_request_count_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_request_count_id_seq OWNED BY public.stock_request_count.id;


--
-- Name: stock_return_picking; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_return_picking (
    id integer NOT NULL,
    picking_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_return_picking OWNER TO runbot;

--
-- Name: TABLE stock_return_picking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_return_picking IS 'Return Picking';


--
-- Name: COLUMN stock_return_picking.picking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking.picking_id IS 'Picking';


--
-- Name: COLUMN stock_return_picking.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking.create_uid IS 'Created by';


--
-- Name: COLUMN stock_return_picking.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_return_picking.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking.create_date IS 'Created on';


--
-- Name: COLUMN stock_return_picking.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking.write_date IS 'Last Updated on';


--
-- Name: stock_return_picking_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_return_picking_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_return_picking_id_seq OWNER TO runbot;

--
-- Name: stock_return_picking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_return_picking_id_seq OWNED BY public.stock_return_picking.id;


--
-- Name: stock_return_picking_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_return_picking_line (
    id integer NOT NULL,
    product_id integer NOT NULL,
    wizard_id integer,
    move_id integer,
    create_uid integer,
    write_uid integer,
    quantity numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_return_picking_line OWNER TO runbot;

--
-- Name: TABLE stock_return_picking_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_return_picking_line IS 'Return Picking Line';


--
-- Name: COLUMN stock_return_picking_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking_line.product_id IS 'Product';


--
-- Name: COLUMN stock_return_picking_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN stock_return_picking_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking_line.move_id IS 'Move';


--
-- Name: COLUMN stock_return_picking_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking_line.create_uid IS 'Created by';


--
-- Name: COLUMN stock_return_picking_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_return_picking_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking_line.quantity IS 'Quantity';


--
-- Name: COLUMN stock_return_picking_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking_line.create_date IS 'Created on';


--
-- Name: COLUMN stock_return_picking_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_return_picking_line.write_date IS 'Last Updated on';


--
-- Name: stock_return_picking_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_return_picking_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_return_picking_line_id_seq OWNER TO runbot;

--
-- Name: stock_return_picking_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_return_picking_line_id_seq OWNED BY public.stock_return_picking_line.id;


--
-- Name: stock_route; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_route (
    id integer NOT NULL,
    sequence integer,
    supplied_wh_id integer,
    supplier_wh_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    product_selectable boolean,
    product_categ_selectable boolean,
    warehouse_selectable boolean,
    package_type_selectable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_route OWNER TO runbot;

--
-- Name: TABLE stock_route; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_route IS 'Inventory Routes';


--
-- Name: COLUMN stock_route.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.sequence IS 'Sequence';


--
-- Name: COLUMN stock_route.supplied_wh_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.supplied_wh_id IS 'Supplied Warehouse';


--
-- Name: COLUMN stock_route.supplier_wh_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.supplier_wh_id IS 'Supplying Warehouse';


--
-- Name: COLUMN stock_route.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.company_id IS 'Company';


--
-- Name: COLUMN stock_route.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.create_uid IS 'Created by';


--
-- Name: COLUMN stock_route.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_route.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.name IS 'Route';


--
-- Name: COLUMN stock_route.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.active IS 'Active';


--
-- Name: COLUMN stock_route.product_selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.product_selectable IS 'Applicable on Product';


--
-- Name: COLUMN stock_route.product_categ_selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.product_categ_selectable IS 'Applicable on Product Category';


--
-- Name: COLUMN stock_route.warehouse_selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.warehouse_selectable IS 'Applicable on Warehouse';


--
-- Name: COLUMN stock_route.package_type_selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.package_type_selectable IS 'Applicable on Package Type';


--
-- Name: COLUMN stock_route.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.create_date IS 'Created on';


--
-- Name: COLUMN stock_route.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_route.write_date IS 'Last Updated on';


--
-- Name: stock_route_categ; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_route_categ (
    route_id integer NOT NULL,
    categ_id integer NOT NULL
);


ALTER TABLE public.stock_route_categ OWNER TO runbot;

--
-- Name: TABLE stock_route_categ; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_route_categ IS 'RELATION BETWEEN stock_route AND product_category';


--
-- Name: stock_route_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_route_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_route_id_seq OWNER TO runbot;

--
-- Name: stock_route_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_route_id_seq OWNED BY public.stock_route.id;


--
-- Name: stock_route_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_route_move (
    move_id integer NOT NULL,
    route_id integer NOT NULL
);


ALTER TABLE public.stock_route_move OWNER TO runbot;

--
-- Name: TABLE stock_route_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_route_move IS 'RELATION BETWEEN stock_move AND stock_route';


--
-- Name: stock_route_product; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_route_product (
    route_id integer NOT NULL,
    product_id integer NOT NULL
);


ALTER TABLE public.stock_route_product OWNER TO runbot;

--
-- Name: TABLE stock_route_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_route_product IS 'RELATION BETWEEN stock_route AND product_template';


--
-- Name: stock_route_warehouse; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_route_warehouse (
    route_id integer NOT NULL,
    warehouse_id integer NOT NULL
);


ALTER TABLE public.stock_route_warehouse OWNER TO runbot;

--
-- Name: TABLE stock_route_warehouse; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_route_warehouse IS 'RELATION BETWEEN stock_route AND stock_warehouse';


--
-- Name: stock_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_rule (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    location_dest_id integer NOT NULL,
    location_src_id integer,
    route_id integer NOT NULL,
    route_sequence integer,
    picking_type_id integer NOT NULL,
    delay integer,
    partner_address_id integer,
    warehouse_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    procure_method character varying NOT NULL,
    auto character varying NOT NULL,
    push_domain character varying,
    name jsonb NOT NULL,
    active boolean,
    location_dest_from_rule boolean,
    propagate_cancel boolean,
    propagate_carrier boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_rule OWNER TO runbot;

--
-- Name: TABLE stock_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_rule IS 'Stock Rule';


--
-- Name: COLUMN stock_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.sequence IS 'Sequence';


--
-- Name: COLUMN stock_rule.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.company_id IS 'Company';


--
-- Name: COLUMN stock_rule.location_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.location_dest_id IS 'Destination Location';


--
-- Name: COLUMN stock_rule.location_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.location_src_id IS 'Source Location';


--
-- Name: COLUMN stock_rule.route_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.route_id IS 'Route';


--
-- Name: COLUMN stock_rule.route_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.route_sequence IS 'Route Sequence';


--
-- Name: COLUMN stock_rule.picking_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.picking_type_id IS 'Operation Type';


--
-- Name: COLUMN stock_rule.delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.delay IS 'Lead Time';


--
-- Name: COLUMN stock_rule.partner_address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.partner_address_id IS 'Partner Address';


--
-- Name: COLUMN stock_rule.warehouse_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN stock_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.create_uid IS 'Created by';


--
-- Name: COLUMN stock_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_rule.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.action IS 'Action';


--
-- Name: COLUMN stock_rule.procure_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.procure_method IS 'Supply Method';


--
-- Name: COLUMN stock_rule.auto; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.auto IS 'Automatic Move';


--
-- Name: COLUMN stock_rule.push_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.push_domain IS 'Push Applicability';


--
-- Name: COLUMN stock_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.name IS 'Name';


--
-- Name: COLUMN stock_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.active IS 'Active';


--
-- Name: COLUMN stock_rule.location_dest_from_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.location_dest_from_rule IS 'Destination location origin from rule';


--
-- Name: COLUMN stock_rule.propagate_cancel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.propagate_cancel IS 'Cancel Next Move';


--
-- Name: COLUMN stock_rule.propagate_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.propagate_carrier IS 'Propagation of carrier';


--
-- Name: COLUMN stock_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.create_date IS 'Created on';


--
-- Name: COLUMN stock_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rule.write_date IS 'Last Updated on';


--
-- Name: stock_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_rule_id_seq OWNER TO runbot;

--
-- Name: stock_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_rule_id_seq OWNED BY public.stock_rule.id;


--
-- Name: stock_rules_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_rules_report (
    id integer NOT NULL,
    product_id integer NOT NULL,
    product_tmpl_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    product_has_variants boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_rules_report OWNER TO runbot;

--
-- Name: TABLE stock_rules_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_rules_report IS 'Stock Rules report';


--
-- Name: COLUMN stock_rules_report.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rules_report.product_id IS 'Product';


--
-- Name: COLUMN stock_rules_report.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rules_report.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN stock_rules_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rules_report.create_uid IS 'Created by';


--
-- Name: COLUMN stock_rules_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rules_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_rules_report.product_has_variants; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rules_report.product_has_variants IS 'Has variants';


--
-- Name: COLUMN stock_rules_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rules_report.create_date IS 'Created on';


--
-- Name: COLUMN stock_rules_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_rules_report.write_date IS 'Last Updated on';


--
-- Name: stock_rules_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_rules_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_rules_report_id_seq OWNER TO runbot;

--
-- Name: stock_rules_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_rules_report_id_seq OWNED BY public.stock_rules_report.id;


--
-- Name: stock_rules_report_stock_warehouse_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_rules_report_stock_warehouse_rel (
    stock_rules_report_id integer NOT NULL,
    stock_warehouse_id integer NOT NULL
);


ALTER TABLE public.stock_rules_report_stock_warehouse_rel OWNER TO runbot;

--
-- Name: TABLE stock_rules_report_stock_warehouse_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_rules_report_stock_warehouse_rel IS 'RELATION BETWEEN stock_rules_report AND stock_warehouse';


--
-- Name: stock_scrap; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_scrap (
    id integer NOT NULL,
    company_id integer NOT NULL,
    product_id integer NOT NULL,
    product_uom_id integer NOT NULL,
    lot_id integer,
    package_id integer,
    owner_id integer,
    picking_id integer,
    location_id integer NOT NULL,
    scrap_location_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    origin character varying,
    state character varying,
    scrap_qty numeric NOT NULL,
    should_replenish boolean,
    date_done timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_scrap OWNER TO runbot;

--
-- Name: TABLE stock_scrap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_scrap IS 'Scrap';


--
-- Name: COLUMN stock_scrap.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.company_id IS 'Company';


--
-- Name: COLUMN stock_scrap.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.product_id IS 'Product';


--
-- Name: COLUMN stock_scrap.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.product_uom_id IS 'Unit';


--
-- Name: COLUMN stock_scrap.lot_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.lot_id IS 'Lot/Serial';


--
-- Name: COLUMN stock_scrap.package_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.package_id IS 'Package';


--
-- Name: COLUMN stock_scrap.owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.owner_id IS 'Owner';


--
-- Name: COLUMN stock_scrap.picking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.picking_id IS 'Picking';


--
-- Name: COLUMN stock_scrap.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.location_id IS 'Source Location';


--
-- Name: COLUMN stock_scrap.scrap_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.scrap_location_id IS 'Scrap Location';


--
-- Name: COLUMN stock_scrap.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.create_uid IS 'Created by';


--
-- Name: COLUMN stock_scrap.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_scrap.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.name IS 'Reference';


--
-- Name: COLUMN stock_scrap.origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.origin IS 'Source Document';


--
-- Name: COLUMN stock_scrap.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.state IS 'Status';


--
-- Name: COLUMN stock_scrap.scrap_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.scrap_qty IS 'Quantity';


--
-- Name: COLUMN stock_scrap.should_replenish; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.should_replenish IS 'Replenish Quantities';


--
-- Name: COLUMN stock_scrap.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.date_done IS 'Date';


--
-- Name: COLUMN stock_scrap.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.create_date IS 'Created on';


--
-- Name: COLUMN stock_scrap.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap.write_date IS 'Last Updated on';


--
-- Name: stock_scrap_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_scrap_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_scrap_id_seq OWNER TO runbot;

--
-- Name: stock_scrap_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_scrap_id_seq OWNED BY public.stock_scrap.id;


--
-- Name: stock_scrap_reason_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_scrap_reason_tag (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    color character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_scrap_reason_tag OWNER TO runbot;

--
-- Name: TABLE stock_scrap_reason_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_scrap_reason_tag IS 'Scrap Reason Tag';


--
-- Name: COLUMN stock_scrap_reason_tag.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap_reason_tag.sequence IS 'Sequence';


--
-- Name: COLUMN stock_scrap_reason_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap_reason_tag.create_uid IS 'Created by';


--
-- Name: COLUMN stock_scrap_reason_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap_reason_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_scrap_reason_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap_reason_tag.color IS 'Color';


--
-- Name: COLUMN stock_scrap_reason_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap_reason_tag.name IS 'Name';


--
-- Name: COLUMN stock_scrap_reason_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap_reason_tag.create_date IS 'Created on';


--
-- Name: COLUMN stock_scrap_reason_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_scrap_reason_tag.write_date IS 'Last Updated on';


--
-- Name: stock_scrap_reason_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_scrap_reason_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_scrap_reason_tag_id_seq OWNER TO runbot;

--
-- Name: stock_scrap_reason_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_scrap_reason_tag_id_seq OWNED BY public.stock_scrap_reason_tag.id;


--
-- Name: stock_scrap_stock_scrap_reason_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_scrap_stock_scrap_reason_tag_rel (
    stock_scrap_id integer NOT NULL,
    stock_scrap_reason_tag_id integer NOT NULL
);


ALTER TABLE public.stock_scrap_stock_scrap_reason_tag_rel OWNER TO runbot;

--
-- Name: TABLE stock_scrap_stock_scrap_reason_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_scrap_stock_scrap_reason_tag_rel IS 'RELATION BETWEEN stock_scrap AND stock_scrap_reason_tag';


--
-- Name: stock_storage_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_storage_category (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    allow_new_product character varying NOT NULL,
    max_weight numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT stock_storage_category_positive_max_weight CHECK ((max_weight >= (0)::numeric))
);


ALTER TABLE public.stock_storage_category OWNER TO runbot;

--
-- Name: TABLE stock_storage_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_storage_category IS 'Storage Category';


--
-- Name: COLUMN stock_storage_category.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category.company_id IS 'Company';


--
-- Name: COLUMN stock_storage_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category.create_uid IS 'Created by';


--
-- Name: COLUMN stock_storage_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_storage_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category.name IS 'Storage Category';


--
-- Name: COLUMN stock_storage_category.allow_new_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category.allow_new_product IS 'Allow New Product';


--
-- Name: COLUMN stock_storage_category.max_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category.max_weight IS 'Max Weight';


--
-- Name: COLUMN stock_storage_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category.create_date IS 'Created on';


--
-- Name: COLUMN stock_storage_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT stock_storage_category_positive_max_weight ON stock_storage_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT stock_storage_category_positive_max_weight ON public.stock_storage_category IS 'CHECK(max_weight >= 0)';


--
-- Name: stock_storage_category_capacity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_storage_category_capacity (
    id integer NOT NULL,
    storage_category_id integer NOT NULL,
    product_id integer,
    package_type_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    quantity double precision NOT NULL,
    CONSTRAINT stock_storage_category_capacity_positive_quantity CHECK ((quantity > (0)::double precision))
);


ALTER TABLE public.stock_storage_category_capacity OWNER TO runbot;

--
-- Name: TABLE stock_storage_category_capacity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_storage_category_capacity IS 'Storage Category Capacity';


--
-- Name: COLUMN stock_storage_category_capacity.storage_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category_capacity.storage_category_id IS 'Storage Category';


--
-- Name: COLUMN stock_storage_category_capacity.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category_capacity.product_id IS 'Product';


--
-- Name: COLUMN stock_storage_category_capacity.package_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category_capacity.package_type_id IS 'Package Type';


--
-- Name: COLUMN stock_storage_category_capacity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category_capacity.create_uid IS 'Created by';


--
-- Name: COLUMN stock_storage_category_capacity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category_capacity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_storage_category_capacity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category_capacity.create_date IS 'Created on';


--
-- Name: COLUMN stock_storage_category_capacity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category_capacity.write_date IS 'Last Updated on';


--
-- Name: COLUMN stock_storage_category_capacity.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_storage_category_capacity.quantity IS 'Quantity';


--
-- Name: CONSTRAINT stock_storage_category_capacity_positive_quantity ON stock_storage_category_capacity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT stock_storage_category_capacity_positive_quantity ON public.stock_storage_category_capacity IS 'CHECK(quantity > 0)';


--
-- Name: stock_storage_category_capacity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_storage_category_capacity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_storage_category_capacity_id_seq OWNER TO runbot;

--
-- Name: stock_storage_category_capacity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_storage_category_capacity_id_seq OWNED BY public.stock_storage_category_capacity.id;


--
-- Name: stock_storage_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_storage_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_storage_category_id_seq OWNER TO runbot;

--
-- Name: stock_storage_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_storage_category_id_seq OWNED BY public.stock_storage_category.id;


--
-- Name: stock_traceability_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_traceability_report (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_traceability_report OWNER TO runbot;

--
-- Name: TABLE stock_traceability_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_traceability_report IS 'Traceability Report';


--
-- Name: COLUMN stock_traceability_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_traceability_report.create_uid IS 'Created by';


--
-- Name: COLUMN stock_traceability_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_traceability_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_traceability_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_traceability_report.create_date IS 'Created on';


--
-- Name: COLUMN stock_traceability_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_traceability_report.write_date IS 'Last Updated on';


--
-- Name: stock_traceability_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_traceability_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_traceability_report_id_seq OWNER TO runbot;

--
-- Name: stock_traceability_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_traceability_report_id_seq OWNED BY public.stock_traceability_report.id;


--
-- Name: stock_warehouse_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_warehouse_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_warehouse_id_seq OWNER TO runbot;

--
-- Name: stock_warehouse_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_warehouse_id_seq OWNED BY public.stock_warehouse.id;


--
-- Name: stock_warehouse_orderpoint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_warehouse_orderpoint (
    id integer NOT NULL,
    warehouse_id integer NOT NULL,
    location_id integer NOT NULL,
    product_id integer NOT NULL,
    replenishment_uom_id integer,
    company_id integer NOT NULL,
    route_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    trigger character varying NOT NULL,
    snoozed_until date,
    deadline_date date,
    product_min_qty numeric NOT NULL,
    product_max_qty numeric NOT NULL,
    qty_to_order_computed numeric,
    qty_to_order_manual numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.stock_warehouse_orderpoint OWNER TO runbot;

--
-- Name: TABLE stock_warehouse_orderpoint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_warehouse_orderpoint IS 'Minimum Inventory Rule';


--
-- Name: COLUMN stock_warehouse_orderpoint.warehouse_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.warehouse_id IS 'Warehouse';


--
-- Name: COLUMN stock_warehouse_orderpoint.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.location_id IS 'Location';


--
-- Name: COLUMN stock_warehouse_orderpoint.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.product_id IS 'Product';


--
-- Name: COLUMN stock_warehouse_orderpoint.replenishment_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.replenishment_uom_id IS 'Multiple';


--
-- Name: COLUMN stock_warehouse_orderpoint.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.company_id IS 'Company';


--
-- Name: COLUMN stock_warehouse_orderpoint.route_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.route_id IS 'Route';


--
-- Name: COLUMN stock_warehouse_orderpoint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.create_uid IS 'Created by';


--
-- Name: COLUMN stock_warehouse_orderpoint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_warehouse_orderpoint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.name IS 'Name';


--
-- Name: COLUMN stock_warehouse_orderpoint.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.trigger IS 'Trigger';


--
-- Name: COLUMN stock_warehouse_orderpoint.snoozed_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.snoozed_until IS 'Snoozed';


--
-- Name: COLUMN stock_warehouse_orderpoint.deadline_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.deadline_date IS 'Deadline';


--
-- Name: COLUMN stock_warehouse_orderpoint.product_min_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.product_min_qty IS 'Min Quantity';


--
-- Name: COLUMN stock_warehouse_orderpoint.product_max_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.product_max_qty IS 'Max Quantity';


--
-- Name: COLUMN stock_warehouse_orderpoint.qty_to_order_computed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.qty_to_order_computed IS 'To Order Computed';


--
-- Name: COLUMN stock_warehouse_orderpoint.qty_to_order_manual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.qty_to_order_manual IS 'To Order Manual';


--
-- Name: COLUMN stock_warehouse_orderpoint.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.active IS 'Active';


--
-- Name: COLUMN stock_warehouse_orderpoint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.create_date IS 'Created on';


--
-- Name: COLUMN stock_warehouse_orderpoint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warehouse_orderpoint.write_date IS 'Last Updated on';


--
-- Name: stock_warehouse_orderpoint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_warehouse_orderpoint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_warehouse_orderpoint_id_seq OWNER TO runbot;

--
-- Name: stock_warehouse_orderpoint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_warehouse_orderpoint_id_seq OWNED BY public.stock_warehouse_orderpoint.id;


--
-- Name: stock_warn_insufficient_qty_scrap; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_warn_insufficient_qty_scrap (
    id integer NOT NULL,
    product_id integer NOT NULL,
    location_id integer NOT NULL,
    scrap_id integer,
    create_uid integer,
    write_uid integer,
    product_uom_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    quantity double precision NOT NULL
);


ALTER TABLE public.stock_warn_insufficient_qty_scrap OWNER TO runbot;

--
-- Name: TABLE stock_warn_insufficient_qty_scrap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_warn_insufficient_qty_scrap IS 'Warn Insufficient Scrap Quantity';


--
-- Name: COLUMN stock_warn_insufficient_qty_scrap.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warn_insufficient_qty_scrap.product_id IS 'Product';


--
-- Name: COLUMN stock_warn_insufficient_qty_scrap.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warn_insufficient_qty_scrap.location_id IS 'Location';


--
-- Name: COLUMN stock_warn_insufficient_qty_scrap.scrap_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warn_insufficient_qty_scrap.scrap_id IS 'Scrap';


--
-- Name: COLUMN stock_warn_insufficient_qty_scrap.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warn_insufficient_qty_scrap.create_uid IS 'Created by';


--
-- Name: COLUMN stock_warn_insufficient_qty_scrap.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warn_insufficient_qty_scrap.write_uid IS 'Last Updated by';


--
-- Name: COLUMN stock_warn_insufficient_qty_scrap.product_uom_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warn_insufficient_qty_scrap.product_uom_name IS 'Unit';


--
-- Name: COLUMN stock_warn_insufficient_qty_scrap.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warn_insufficient_qty_scrap.create_date IS 'Created on';


--
-- Name: COLUMN stock_warn_insufficient_qty_scrap.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warn_insufficient_qty_scrap.write_date IS 'Last Updated on';


--
-- Name: COLUMN stock_warn_insufficient_qty_scrap.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.stock_warn_insufficient_qty_scrap.quantity IS 'Quantity';


--
-- Name: stock_warn_insufficient_qty_scrap_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.stock_warn_insufficient_qty_scrap_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.stock_warn_insufficient_qty_scrap_id_seq OWNER TO runbot;

--
-- Name: stock_warn_insufficient_qty_scrap_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.stock_warn_insufficient_qty_scrap_id_seq OWNED BY public.stock_warn_insufficient_qty_scrap.id;


--
-- Name: stock_wh_resupply_table; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.stock_wh_resupply_table (
    supplied_wh_id integer NOT NULL,
    supplier_wh_id integer NOT NULL
);


ALTER TABLE public.stock_wh_resupply_table OWNER TO runbot;

--
-- Name: TABLE stock_wh_resupply_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.stock_wh_resupply_table IS 'RELATION BETWEEN stock_warehouse AND stock_warehouse';


--
-- Name: template_attribute_value_stock_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.template_attribute_value_stock_move_rel (
    move_id integer NOT NULL,
    template_attribute_value_id integer NOT NULL
);


ALTER TABLE public.template_attribute_value_stock_move_rel OWNER TO runbot;

--
-- Name: TABLE template_attribute_value_stock_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.template_attribute_value_stock_move_rel IS 'RELATION BETWEEN stock_move AND product_template_attribute_value';


--
-- Name: uom_uom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.uom_uom (
    id integer NOT NULL,
    sequence integer,
    relative_uom_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    relative_factor numeric NOT NULL,
    factor numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    package_type_id integer,
    CONSTRAINT uom_uom_factor_gt_zero CHECK ((relative_factor <> (0)::numeric))
);


ALTER TABLE public.uom_uom OWNER TO runbot;

--
-- Name: TABLE uom_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.uom_uom IS 'Product Unit of Measure';


--
-- Name: COLUMN uom_uom.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.sequence IS 'Sequence';


--
-- Name: COLUMN uom_uom.relative_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.relative_uom_id IS 'Reference Unit';


--
-- Name: COLUMN uom_uom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.create_uid IS 'Created by';


--
-- Name: COLUMN uom_uom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN uom_uom.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.parent_path IS 'Parent Path';


--
-- Name: COLUMN uom_uom.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.name IS 'Unit Name';


--
-- Name: COLUMN uom_uom.relative_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.relative_factor IS 'Contains';


--
-- Name: COLUMN uom_uom.factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.factor IS 'Absolute Quantity';


--
-- Name: COLUMN uom_uom.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.active IS 'Active';


--
-- Name: COLUMN uom_uom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.create_date IS 'Created on';


--
-- Name: COLUMN uom_uom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.write_date IS 'Last Updated on';


--
-- Name: COLUMN uom_uom.package_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.package_type_id IS 'Package Type';


--
-- Name: CONSTRAINT uom_uom_factor_gt_zero ON uom_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT uom_uom_factor_gt_zero ON public.uom_uom IS 'CHECK (relative_factor!=0)';


--
-- Name: uom_uom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.uom_uom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.uom_uom_id_seq OWNER TO runbot;

--
-- Name: uom_uom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.uom_uom_id_seq OWNED BY public.uom_uom.id;


--
-- Name: update_product_attribute_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.update_product_attribute_value (
    id integer NOT NULL,
    attribute_value_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    mode character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.update_product_attribute_value OWNER TO runbot;

--
-- Name: TABLE update_product_attribute_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.update_product_attribute_value IS 'Update product attribute value';


--
-- Name: COLUMN update_product_attribute_value.attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.update_product_attribute_value.attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN update_product_attribute_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.update_product_attribute_value.create_uid IS 'Created by';


--
-- Name: COLUMN update_product_attribute_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.update_product_attribute_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN update_product_attribute_value.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.update_product_attribute_value.mode IS 'Mode';


--
-- Name: COLUMN update_product_attribute_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.update_product_attribute_value.create_date IS 'Created on';


--
-- Name: COLUMN update_product_attribute_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.update_product_attribute_value.write_date IS 'Last Updated on';


--
-- Name: update_product_attribute_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.update_product_attribute_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.update_product_attribute_value_id_seq OWNER TO runbot;

--
-- Name: update_product_attribute_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.update_product_attribute_value_id_seq OWNED BY public.update_product_attribute_value.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    url character varying,
    rainbow_man_message jsonb,
    custom boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Name';


--
-- Name: COLUMN web_tour_tour.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.url IS 'Starting URL';


--
-- Name: COLUMN web_tour_tour.rainbow_man_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.rainbow_man_message IS 'Rainbow Man Message';


--
-- Name: COLUMN web_tour_tour.custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.custom IS 'Custom';


--
-- Name: COLUMN web_tour_tour.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: web_tour_tour_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour_step (
    id integer NOT NULL,
    tour_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    content character varying,
    tooltip_position character varying,
    run character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour_step OWNER TO runbot;

--
-- Name: TABLE web_tour_tour_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour_step IS 'Tour''s step';


--
-- Name: COLUMN web_tour_tour_step.tour_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tour_id IS 'Tour';


--
-- Name: COLUMN web_tour_tour_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour_step.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.trigger IS 'Trigger';


--
-- Name: COLUMN web_tour_tour_step.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.content IS 'Content';


--
-- Name: COLUMN web_tour_tour_step.tooltip_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tooltip_position IS 'Tooltip Position';


--
-- Name: COLUMN web_tour_tour_step.run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.run IS 'Run';


--
-- Name: COLUMN web_tour_tour_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNED BY public.web_tour_tour_step.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: ai_agent id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_agent ALTER COLUMN id SET DEFAULT nextval('public.ai_agent_id_seq'::regclass);


--
-- Name: ai_agent_source id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_agent_source ALTER COLUMN id SET DEFAULT nextval('public.ai_agent_source_id_seq'::regclass);


--
-- Name: ai_composer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_composer ALTER COLUMN id SET DEFAULT nextval('public.ai_composer_id_seq'::regclass);


--
-- Name: ai_embedding id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_embedding ALTER COLUMN id SET DEFAULT nextval('public.ai_embedding_id_seq'::regclass);


--
-- Name: ai_prompt_button id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_prompt_button ALTER COLUMN id SET DEFAULT nextval('public.ai_prompt_button_id_seq'::regclass);


--
-- Name: ai_topic id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_topic ALTER COLUMN id SET DEFAULT nextval('public.ai_topic_id_seq'::regclass);


--
-- Name: auth_passkey_key id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_passkey_key ALTER COLUMN id SET DEFAULT nextval('public.auth_passkey_key_id_seq'::regclass);


--
-- Name: auth_passkey_key_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_passkey_key_create ALTER COLUMN id SET DEFAULT nextval('public.auth_passkey_key_create_id_seq'::regclass);


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_rate_limit_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_rate_limit_log ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_rate_limit_log_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: barcode_nomenclature id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.barcode_nomenclature ALTER COLUMN id SET DEFAULT nextval('public.barcode_nomenclature_id_seq'::regclass);


--
-- Name: barcode_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.barcode_rule ALTER COLUMN id SET DEFAULT nextval('public.barcode_rule_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_module ALTER COLUMN id SET DEFAULT nextval('public.base_import_module_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_install_request id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_request ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_request_id_seq'::regclass);


--
-- Name: base_module_install_review id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_review ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_review_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: confirm_stock_sms id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.confirm_stock_sms ALTER COLUMN id SET DEFAULT nextval('public.confirm_stock_sms_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: digest_digest id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.digest_digest ALTER COLUMN id SET DEFAULT nextval('public.digest_digest_id_seq'::regclass);


--
-- Name: digest_tip id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.digest_tip ALTER COLUMN id SET DEFAULT nextval('public.digest_tip_id_seq'::regclass);


--
-- Name: discuss_call_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_call_history ALTER COLUMN id SET DEFAULT nextval('public.discuss_call_history_id_seq'::regclass);


--
-- Name: discuss_channel id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_id_seq'::regclass);


--
-- Name: discuss_channel_member id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_member ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_member_id_seq'::regclass);


--
-- Name: discuss_channel_rtc_session id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_rtc_session ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_rtc_session_id_seq'::regclass);


--
-- Name: discuss_gif_favorite id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_gif_favorite ALTER COLUMN id SET DEFAULT nextval('public.discuss_gif_favorite_id_seq'::regclass);


--
-- Name: discuss_voice_metadata id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_voice_metadata ALTER COLUMN id SET DEFAULT nextval('public.discuss_voice_metadata_id_seq'::regclass);


--
-- Name: docs_config_installer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.docs_config_installer ALTER COLUMN id SET DEFAULT nextval('public.docs_config_installer_id_seq'::regclass);


--
-- Name: fetchmail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.fetchmail_server ALTER COLUMN id SET DEFAULT nextval('public.fetchmail_server_id_seq'::regclass);


--
-- Name: html_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.html_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.html_editor_converter_test_id_seq'::regclass);


--
-- Name: html_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.html_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.html_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: iap_service id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_service ALTER COLUMN id SET DEFAULT nextval('public.iap_service_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_server_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_server_history ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_server_history_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_progress id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_progress ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_progress_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_embedded_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_embedded_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_embedded_actions_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_inherit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_inherit ALTER COLUMN id SET DEFAULT nextval('public.ir_model_inherit_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: lot_label_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.lot_label_layout ALTER COLUMN id SET DEFAULT nextval('public.lot_label_layout_id_seq'::regclass);


--
-- Name: mail_activity id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_id_seq'::regclass);


--
-- Name: mail_activity_plan id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_id_seq'::regclass);


--
-- Name: mail_activity_plan_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan_template ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_template_id_seq'::regclass);


--
-- Name: mail_activity_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_schedule_id_seq'::regclass);


--
-- Name: mail_activity_schedule_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_schedule_line ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_schedule_line_id_seq'::regclass);


--
-- Name: mail_activity_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_type ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_type_id_seq'::regclass);


--
-- Name: mail_alias id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_id_seq'::regclass);


--
-- Name: mail_alias_domain id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias_domain ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_domain_id_seq'::regclass);


--
-- Name: mail_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_id_seq'::regclass);


--
-- Name: mail_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_remove_id_seq'::regclass);


--
-- Name: mail_canned_response id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_canned_response ALTER COLUMN id SET DEFAULT nextval('public.mail_canned_response_id_seq'::regclass);


--
-- Name: mail_compose_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_compose_message ALTER COLUMN id SET DEFAULT nextval('public.mail_compose_message_id_seq'::regclass);


--
-- Name: mail_followers id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_id_seq'::regclass);


--
-- Name: mail_followers_edit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers_edit ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_edit_id_seq'::regclass);


--
-- Name: mail_gateway_allowed id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_gateway_allowed ALTER COLUMN id SET DEFAULT nextval('public.mail_gateway_allowed_id_seq'::regclass);


--
-- Name: mail_guest id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_guest ALTER COLUMN id SET DEFAULT nextval('public.mail_guest_id_seq'::regclass);


--
-- Name: mail_ice_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_ice_server ALTER COLUMN id SET DEFAULT nextval('public.mail_ice_server_id_seq'::regclass);


--
-- Name: mail_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_link_preview_id_seq'::regclass);


--
-- Name: mail_mail id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_mail ALTER COLUMN id SET DEFAULT nextval('public.mail_mail_id_seq'::regclass);


--
-- Name: mail_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message ALTER COLUMN id SET DEFAULT nextval('public.mail_message_id_seq'::regclass);


--
-- Name: mail_message_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_message_link_preview_id_seq'::regclass);


--
-- Name: mail_message_reaction id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_reaction ALTER COLUMN id SET DEFAULT nextval('public.mail_message_reaction_id_seq'::regclass);


--
-- Name: mail_message_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_message_schedule_id_seq'::regclass);


--
-- Name: mail_message_subtype id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_subtype ALTER COLUMN id SET DEFAULT nextval('public.mail_message_subtype_id_seq'::regclass);


--
-- Name: mail_message_translation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_translation ALTER COLUMN id SET DEFAULT nextval('public.mail_message_translation_id_seq'::regclass);


--
-- Name: mail_notification id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_notification ALTER COLUMN id SET DEFAULT nextval('public.mail_notification_id_seq'::regclass);


--
-- Name: mail_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_presence ALTER COLUMN id SET DEFAULT nextval('public.mail_presence_id_seq'::regclass);


--
-- Name: mail_push id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push ALTER COLUMN id SET DEFAULT nextval('public.mail_push_id_seq'::regclass);


--
-- Name: mail_push_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push_device ALTER COLUMN id SET DEFAULT nextval('public.mail_push_device_id_seq'::regclass);


--
-- Name: mail_scheduled_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_scheduled_message ALTER COLUMN id SET DEFAULT nextval('public.mail_scheduled_message_id_seq'::regclass);


--
-- Name: mail_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template ALTER COLUMN id SET DEFAULT nextval('public.mail_template_id_seq'::regclass);


--
-- Name: mail_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_template_preview_id_seq'::regclass);


--
-- Name: mail_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_reset ALTER COLUMN id SET DEFAULT nextval('public.mail_template_reset_id_seq'::regclass);


--
-- Name: mail_tracking_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_tracking_value ALTER COLUMN id SET DEFAULT nextval('public.mail_tracking_value_id_seq'::regclass);


--
-- Name: orm_signaling_assets id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_assets ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_assets_id_seq'::regclass);


--
-- Name: orm_signaling_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_default ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_default_id_seq'::regclass);


--
-- Name: orm_signaling_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_groups ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_groups_id_seq'::regclass);


--
-- Name: orm_signaling_registry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_registry ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_registry_id_seq'::regclass);


--
-- Name: orm_signaling_routing id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_routing ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_routing_id_seq'::regclass);


--
-- Name: orm_signaling_stable id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_stable ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_stable_id_seq'::regclass);


--
-- Name: orm_signaling_templates id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_templates ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_templates_id_seq'::regclass);


--
-- Name: phone_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_id_seq'::regclass);


--
-- Name: phone_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_remove_id_seq'::regclass);


--
-- Name: picking_label_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.picking_label_type ALTER COLUMN id SET DEFAULT nextval('public.picking_label_type_id_seq'::regclass);


--
-- Name: portal_share id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.portal_share ALTER COLUMN id SET DEFAULT nextval('public.portal_share_id_seq'::regclass);


--
-- Name: portal_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.portal_wizard ALTER COLUMN id SET DEFAULT nextval('public.portal_wizard_id_seq'::regclass);


--
-- Name: portal_wizard_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.portal_wizard_user ALTER COLUMN id SET DEFAULT nextval('public.portal_wizard_user_id_seq'::regclass);


--
-- Name: privacy_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_log ALTER COLUMN id SET DEFAULT nextval('public.privacy_log_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard_line ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_line_id_seq'::regclass);


--
-- Name: product_attribute id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_attribute ALTER COLUMN id SET DEFAULT nextval('public.product_attribute_id_seq'::regclass);


--
-- Name: product_attribute_custom_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_attribute_custom_value ALTER COLUMN id SET DEFAULT nextval('public.product_attribute_custom_value_id_seq'::regclass);


--
-- Name: product_attribute_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_attribute_value ALTER COLUMN id SET DEFAULT nextval('public.product_attribute_value_id_seq'::regclass);


--
-- Name: product_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_category ALTER COLUMN id SET DEFAULT nextval('public.product_category_id_seq'::regclass);


--
-- Name: product_combo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_combo ALTER COLUMN id SET DEFAULT nextval('public.product_combo_id_seq'::regclass);


--
-- Name: product_combo_item id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_combo_item ALTER COLUMN id SET DEFAULT nextval('public.product_combo_item_id_seq'::regclass);


--
-- Name: product_document id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_document ALTER COLUMN id SET DEFAULT nextval('public.product_document_id_seq'::regclass);


--
-- Name: product_fetch_image_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_fetch_image_wizard ALTER COLUMN id SET DEFAULT nextval('public.product_fetch_image_wizard_id_seq'::regclass);


--
-- Name: product_label_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_label_layout ALTER COLUMN id SET DEFAULT nextval('public.product_label_layout_id_seq'::regclass);


--
-- Name: product_pricelist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_pricelist ALTER COLUMN id SET DEFAULT nextval('public.product_pricelist_id_seq'::regclass);


--
-- Name: product_pricelist_item id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_pricelist_item ALTER COLUMN id SET DEFAULT nextval('public.product_pricelist_item_id_seq'::regclass);


--
-- Name: product_product id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_product ALTER COLUMN id SET DEFAULT nextval('public.product_product_id_seq'::regclass);


--
-- Name: product_removal id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_removal ALTER COLUMN id SET DEFAULT nextval('public.product_removal_id_seq'::regclass);


--
-- Name: product_replenish id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_replenish ALTER COLUMN id SET DEFAULT nextval('public.product_replenish_id_seq'::regclass);


--
-- Name: product_supplierinfo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_supplierinfo ALTER COLUMN id SET DEFAULT nextval('public.product_supplierinfo_id_seq'::regclass);


--
-- Name: product_tag id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_tag ALTER COLUMN id SET DEFAULT nextval('public.product_tag_id_seq'::regclass);


--
-- Name: product_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_template ALTER COLUMN id SET DEFAULT nextval('public.product_template_id_seq'::regclass);


--
-- Name: product_template_attribute_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_template_attribute_exclusion ALTER COLUMN id SET DEFAULT nextval('public.product_template_attribute_exclusion_id_seq'::regclass);


--
-- Name: product_template_attribute_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_template_attribute_line ALTER COLUMN id SET DEFAULT nextval('public.product_template_attribute_line_id_seq'::regclass);


--
-- Name: product_template_attribute_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_template_attribute_value ALTER COLUMN id SET DEFAULT nextval('public.product_template_attribute_value_id_seq'::regclass);


--
-- Name: product_uom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.product_uom ALTER COLUMN id SET DEFAULT nextval('public.product_uom_id_seq'::regclass);


--
-- Name: properties_base_definition id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.properties_base_definition ALTER COLUMN id SET DEFAULT nextval('public.properties_base_definition_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_mimetypes id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_mimetypes ALTER COLUMN id SET DEFAULT nextval('public.report_mimetypes_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: report_stylesheets id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_stylesheets ALTER COLUMN id SET DEFAULT nextval('public.report_stylesheets_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_device_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_device_log ALTER COLUMN id SET DEFAULT nextval('public.res_device_log_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_groups_privilege id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups_privilege ALTER COLUMN id SET DEFAULT nextval('public.res_groups_privilege_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_role id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_role ALTER COLUMN id SET DEFAULT nextval('public.res_role_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: res_users_settings_embedded_action id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_embedded_action ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_embedded_action_id_seq'::regclass);


--
-- Name: res_users_settings_volumes id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_volumes ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_volumes_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: resource_calendar id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_id_seq'::regclass);


--
-- Name: resource_calendar_attendance id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar_attendance ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_attendance_id_seq'::regclass);


--
-- Name: resource_calendar_leaves id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar_leaves ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_leaves_id_seq'::regclass);


--
-- Name: resource_resource id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_resource ALTER COLUMN id SET DEFAULT nextval('public.resource_resource_id_seq'::regclass);


--
-- Name: server_action_history_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.server_action_history_wizard ALTER COLUMN id SET DEFAULT nextval('public.server_action_history_wizard_id_seq'::regclass);


--
-- Name: sms_account_code id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_code ALTER COLUMN id SET DEFAULT nextval('public.sms_account_code_id_seq'::regclass);


--
-- Name: sms_account_phone id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_phone ALTER COLUMN id SET DEFAULT nextval('public.sms_account_phone_id_seq'::regclass);


--
-- Name: sms_account_sender id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_sender ALTER COLUMN id SET DEFAULT nextval('public.sms_account_sender_id_seq'::regclass);


--
-- Name: sms_composer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_composer ALTER COLUMN id SET DEFAULT nextval('public.sms_composer_id_seq'::regclass);


--
-- Name: sms_sms id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_sms ALTER COLUMN id SET DEFAULT nextval('public.sms_sms_id_seq'::regclass);


--
-- Name: sms_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template ALTER COLUMN id SET DEFAULT nextval('public.sms_template_id_seq'::regclass);


--
-- Name: sms_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_preview ALTER COLUMN id SET DEFAULT nextval('public.sms_template_preview_id_seq'::regclass);


--
-- Name: sms_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_reset ALTER COLUMN id SET DEFAULT nextval('public.sms_template_reset_id_seq'::regclass);


--
-- Name: sms_tracker id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_tracker ALTER COLUMN id SET DEFAULT nextval('public.sms_tracker_id_seq'::regclass);


--
-- Name: snailmail_letter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.snailmail_letter ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_id_seq'::regclass);


--
-- Name: spreadsheet_cell_thread id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_cell_thread ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_cell_thread_id_seq'::regclass);


--
-- Name: spreadsheet_dashboard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_dashboard ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_dashboard_id_seq'::regclass);


--
-- Name: spreadsheet_dashboard_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_dashboard_group ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_dashboard_group_id_seq'::regclass);


--
-- Name: spreadsheet_dashboard_share id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_dashboard_share ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_dashboard_share_id_seq'::regclass);


--
-- Name: spreadsheet_revision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_revision ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_revision_id_seq'::regclass);


--
-- Name: stock_backorder_confirmation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_backorder_confirmation ALTER COLUMN id SET DEFAULT nextval('public.stock_backorder_confirmation_id_seq'::regclass);


--
-- Name: stock_backorder_confirmation_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_backorder_confirmation_line ALTER COLUMN id SET DEFAULT nextval('public.stock_backorder_confirmation_line_id_seq'::regclass);


--
-- Name: stock_barcode_cancel_operation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_barcode_cancel_operation ALTER COLUMN id SET DEFAULT nextval('public.stock_barcode_cancel_operation_id_seq'::regclass);


--
-- Name: stock_inventory_adjustment_name id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_inventory_adjustment_name ALTER COLUMN id SET DEFAULT nextval('public.stock_inventory_adjustment_name_id_seq'::regclass);


--
-- Name: stock_inventory_conflict id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_inventory_conflict ALTER COLUMN id SET DEFAULT nextval('public.stock_inventory_conflict_id_seq'::regclass);


--
-- Name: stock_inventory_warning id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_inventory_warning ALTER COLUMN id SET DEFAULT nextval('public.stock_inventory_warning_id_seq'::regclass);


--
-- Name: stock_location id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_location ALTER COLUMN id SET DEFAULT nextval('public.stock_location_id_seq'::regclass);


--
-- Name: stock_lot id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_lot ALTER COLUMN id SET DEFAULT nextval('public.stock_lot_id_seq'::regclass);


--
-- Name: stock_move id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_move ALTER COLUMN id SET DEFAULT nextval('public.stock_move_id_seq'::regclass);


--
-- Name: stock_move_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_move_line ALTER COLUMN id SET DEFAULT nextval('public.stock_move_line_id_seq'::regclass);


--
-- Name: stock_orderpoint_snooze id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_orderpoint_snooze ALTER COLUMN id SET DEFAULT nextval('public.stock_orderpoint_snooze_id_seq'::regclass);


--
-- Name: stock_package id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_package ALTER COLUMN id SET DEFAULT nextval('public.stock_package_id_seq'::regclass);


--
-- Name: stock_package_destination id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_package_destination ALTER COLUMN id SET DEFAULT nextval('public.stock_package_destination_id_seq'::regclass);


--
-- Name: stock_package_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_package_history ALTER COLUMN id SET DEFAULT nextval('public.stock_package_history_id_seq'::regclass);


--
-- Name: stock_package_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_package_type ALTER COLUMN id SET DEFAULT nextval('public.stock_package_type_id_seq'::regclass);


--
-- Name: stock_picking id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_picking ALTER COLUMN id SET DEFAULT nextval('public.stock_picking_id_seq'::regclass);


--
-- Name: stock_picking_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_picking_type ALTER COLUMN id SET DEFAULT nextval('public.stock_picking_type_id_seq'::regclass);


--
-- Name: stock_put_in_pack id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_put_in_pack ALTER COLUMN id SET DEFAULT nextval('public.stock_put_in_pack_id_seq'::regclass);


--
-- Name: stock_putaway_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_putaway_rule ALTER COLUMN id SET DEFAULT nextval('public.stock_putaway_rule_id_seq'::regclass);


--
-- Name: stock_quant id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_quant ALTER COLUMN id SET DEFAULT nextval('public.stock_quant_id_seq'::regclass);


--
-- Name: stock_quant_relocate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_quant_relocate ALTER COLUMN id SET DEFAULT nextval('public.stock_quant_relocate_id_seq'::regclass);


--
-- Name: stock_quantity_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_quantity_history ALTER COLUMN id SET DEFAULT nextval('public.stock_quantity_history_id_seq'::regclass);


--
-- Name: stock_reference id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_reference ALTER COLUMN id SET DEFAULT nextval('public.stock_reference_id_seq'::regclass);


--
-- Name: stock_replenishment_info id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_replenishment_info ALTER COLUMN id SET DEFAULT nextval('public.stock_replenishment_info_id_seq'::regclass);


--
-- Name: stock_replenishment_option id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_replenishment_option ALTER COLUMN id SET DEFAULT nextval('public.stock_replenishment_option_id_seq'::regclass);


--
-- Name: stock_request_count id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_request_count ALTER COLUMN id SET DEFAULT nextval('public.stock_request_count_id_seq'::regclass);


--
-- Name: stock_return_picking id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_return_picking ALTER COLUMN id SET DEFAULT nextval('public.stock_return_picking_id_seq'::regclass);


--
-- Name: stock_return_picking_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_return_picking_line ALTER COLUMN id SET DEFAULT nextval('public.stock_return_picking_line_id_seq'::regclass);


--
-- Name: stock_route id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_route ALTER COLUMN id SET DEFAULT nextval('public.stock_route_id_seq'::regclass);


--
-- Name: stock_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_rule ALTER COLUMN id SET DEFAULT nextval('public.stock_rule_id_seq'::regclass);


--
-- Name: stock_rules_report id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_rules_report ALTER COLUMN id SET DEFAULT nextval('public.stock_rules_report_id_seq'::regclass);


--
-- Name: stock_scrap id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_scrap ALTER COLUMN id SET DEFAULT nextval('public.stock_scrap_id_seq'::regclass);


--
-- Name: stock_scrap_reason_tag id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_scrap_reason_tag ALTER COLUMN id SET DEFAULT nextval('public.stock_scrap_reason_tag_id_seq'::regclass);


--
-- Name: stock_storage_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_storage_category ALTER COLUMN id SET DEFAULT nextval('public.stock_storage_category_id_seq'::regclass);


--
-- Name: stock_storage_category_capacity id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_storage_category_capacity ALTER COLUMN id SET DEFAULT nextval('public.stock_storage_category_capacity_id_seq'::regclass);


--
-- Name: stock_traceability_report id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_traceability_report ALTER COLUMN id SET DEFAULT nextval('public.stock_traceability_report_id_seq'::regclass);


--
-- Name: stock_warehouse id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_warehouse ALTER COLUMN id SET DEFAULT nextval('public.stock_warehouse_id_seq'::regclass);


--
-- Name: stock_warehouse_orderpoint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_warehouse_orderpoint ALTER COLUMN id SET DEFAULT nextval('public.stock_warehouse_orderpoint_id_seq'::regclass);


--
-- Name: stock_warn_insufficient_qty_scrap id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.stock_warn_insufficient_qty_scrap ALTER COLUMN id SET DEFAULT nextval('public.stock_warn_insufficient_qty_scrap_id_seq'::regclass);


--
-- Name: uom_uom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.uom_uom ALTER COLUMN id SET DEFAULT nextval('public.uom_uom_id_seq'::regclass);


--
-- Name: update_product_attribute_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.update_product_attribute_value ALTER COLUMN id SET DEFAULT nextval('public.update_product_attribute_value_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: web_tour_tour_step id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour_step ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_step_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: Products; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public."Products" (stock_package_destination_id, stock_move_line_id) FROM stdin;
\.


--
-- Data for Name: activity_attachment_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.activity_attachment_rel (activity_id, attachment_id) FROM stdin;
\.


--
-- Data for Name: ai_agent; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent (id, partner_id, create_uid, write_uid, subtitle, response_style, llm_model, system_prompt, active, restrict_to_sources, is_system_agent, create_date, write_date) FROM stdin;
1	44	1	1	Your Odoo sidekick for most day-to-day tasks.	balanced	gpt-4o	\N	t	\N	t	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
2	45	2	1	Used for searching information across your database.	analytical	gemini-2.5-flash	# Odoo Ask AI agent\n\nYou are an agent dedicated to help the user with his Odoo database. To help him in his tasks, you have access to a bunch of tools related to search which can be used to retrieve information about the database. You also have another set of tools which you can use to move the user around in the UI.\n\n## General Rules\n\n- You must NEVER display errors to the user. If you cannot complete the query, just say that you weren't able to fulfil the query.\n- ONLY use tools if you really need to, if the question is not related to Odoo, or information of the database, use your general knowledge.\n- If you encounter a forbidden action error, say you are not allowed to perform the actions needed to fulfil the user's query.\n- Only use action ids you have access to, do not make up tool calls.\n\n## Topics\n\nBelow, you'll find a description of topics you have access to along with a list of the tools they offer.\n\n### Information retrieval\n\nThis is the PRIMARY topic you must consider when answering a query, it contains the following tools that are related to search and analysis of the content of the Odoo database:\n\n- Get Fields\n- Search\n- Read group\n\n**Triggers**\n\nWhen one (or more) of these triggers is TRUE for the user's query, use Information retrieval tools.\n\n- Simple questions\n- Queries that are not related to opening view, or showing content\n- **Keywords**: Who, When, How, etc.\n\n**Examples**\n\n- Who are the top salespersons this month?\n- Do I have customers in Belgium?\n\n### Natural Language Search tools\n\nThese are the tools related to interactions with the view in Odoo, you'll use it to move to the appropriate view and apply proper filters inside of these views:\n\n- Get Fields\n- Compute Report Measures\n- Get Menu Details\n- Open Menu Graph\n- Open Menu Kanban\n- Open Menu List\n- Open Menu Pivot\n\n**Triggers**\n\nWhen one (or more) of these triggers is TRUE for the user's query, use Natural Language Search tools.\n\n- Queries related to navigation within Odoo\n- **Keywords**: show, open, view, see.\n\n**Examples**\n\n- Show me the top salespersons this month\n- Open a graph view of the best sellers of the last six months\n\n## Tools Selection\n\n- ALWAYS use Information retrieval tools. You must not perform view operations unless EXPLICITELY told to\n        	t	\N	f	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
3	46	2	1	Helps you with any legal issue related to Odoo.	analytical	gpt-4o	You are a legal advisor in your company. Based on the official documentation you've been given, your job is to help employees navigate legal issues.\nTo do so, keep your answer really short, making it as clear as possible.\n        	t	\N	f	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
\.


--
-- Data for Name: ai_agent_ai_topic_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent_ai_topic_rel (ai_agent_id, ai_topic_id) FROM stdin;
2	2
2	1
\.


--
-- Data for Name: ai_agent_source; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent_source (id, agent_id, attachment_id, create_uid, write_uid, name, type, status, url, error_details, is_active, create_date, write_date) FROM stdin;
1	3	432	1	1	Odoo Enterprise Agreement	binary	processing	\N	\N	\N	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
\.


--
-- Data for Name: ai_composer; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_composer (id, ai_agent, create_uid, write_uid, name, interface_key, default_prompt, is_system_default, create_date, write_date) FROM stdin;
1	1	1	1	Mail/Note Composer	mail_composer	Your job is to help with drafting messages. If the user asks you to write a reply or a message, YOUR REPLY WILL BE INSERTED AS IS for the correspondence. Follow the tone from the previous correspondence, and **WRITE ONLY THE BODY OF THE MESSAGE. DO NOT ADD ADDITIONAL COMMENTARY, A SUBJECT LINE, OR A SIGNATURE.** Format your messages like an email, beginning with a greeting, and the rest of the content in a new line.	t	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
2	1	1	1	Record HTML Fields	html_field_record	Your job is to help with drafting the description of an odoo record. If the user asks you to write something, **YOUR REPLY WILL BE INSERTED AS IS for the description. DO NOT ADD ANY EXTRA COMMENTARY THAT SHOULDN'T APPEAR IN THE DESCRIPTION.** Give your answers succinctly and to the point.	t	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
3	1	1	1	Text Selector	html_field_text_select	Your job is to suggest alternatives to a piece of text the user has written. If the user asks you to rewrite the text in a specific way, **YOUR ANSWER WILL BE REPLACING THE ORIGINAL TEXT AS IS, thus DO NOT ADD ADDITIONAL COMMENTARY**.	t	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
4	1	1	1	Chatter Helper	chatter_ai_button	Your job is to assist the user with the chatter correspondence. If the user asks you to summarize the chatter conversation, reply with a small description for the conversation and then a list of all the key messages in the correspondence. Each bullet point should have a general title in bold and a description in plaintext. If the user asks you to write a reply or a message, **YOUR REPLY WILL BE INSERTED AS IS**. Follow the tone from the previous messages in the chatter. **WRITE ONLY THE BODY OF THE MESSAGE. DO NOT ADD ADDITIONAL COMMENTARY, A SUBJECT LINE, OR A SIGNATURE.** Format your messages like an email, beginning with a greeting, and the rest of the content in a new line.	t	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
5	1	1	1	Mail Template Prompt Evaluator	html_prompt_shortcut	\nYou are an Email Prompt Transformer. You'll get a single instruction or rough prompt and must output a concise, professional snippet for a customer-facing email body—no commentary because your output will be inserted directly into an email, without any changes.\n\n**1. Execute**\n- Read the input as a command or sketch and produce the intended text.\n- If you can't help, return an empty string.\n\n**2. Placeholders**\n- Ideas/constructs that are linked to literals like `false`, `undefined`, `null` or bracketed value like `[value]` should be ignored and don't invent any values.\n- Don't invent dates, names, or other details.\n\n**3. Unquote**\n- Remove surrounding quotes from any quoted text.\n\n**4. Polish**\n- Eliminate redundancies, filler, apologies, or uncertainty (e.g. "I'm not sure").\n- Use the requested language.\n\n**5. Output only**\n- Return exactly the email fragment (body only), with no subject, labels, or extra formatting.\n\n---\n\n**Examples**\n\n- **Input:**\n  `Insert a greeting for the buyer, mentioning "Burger Maison" and reminding them of [deadline].`\n  **Output:**\n  `We're thrilled to announce the launch of Burger Maison—thank you for your continued partnership.`\n  **Explanation:**\n  There is no value for `[deadline]`, so that part where the input asks for reminding is ignored.\n\n- **Input:**\n  `Please thank [name] for their purchase of "Deluxe Toolkit" and mention shipment on false.`\n  **Output:**\n  `Thank you for purchasing Deluxe Toolkit. Your order will shipped shortly.`\n   **Explanation:**\n   There is no value for `[name]` so the "thank" is generic. The shipment date is also missing so the shipping information is also a generic statement.\n\n- **Input:**\n  `Add a closing line wishing them a great weekend.`\n  **Output:**\n  `Have a wonderful weekend, and feel free to reach out with any questions.`\n            	t	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
6	2	1	1	Ask AI	systray_ai_button	\N	t	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
7	1	1	1	Summarize Voice Transcription	voice_transcription_component	Summarize the transcript below.\n\nYour summary should be structured in a way that is easy to skim. It should only contain the essential information.\nIt must be in markdown format. Do NOT put the main markup inside code blocks.	t	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
\.


--
-- Data for Name: ai_composer_ir_model_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_composer_ir_model_rel (ai_composer_id, ir_model_id) FROM stdin;
\.


--
-- Data for Name: ai_embedding; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_embedding (id, attachment_id, sequence, create_uid, write_uid, embedding_model, content, has_embedding_generation_failed, create_date, write_date, embedding_vector) FROM stdin;
\.


--
-- Data for Name: ai_prompt_button; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_prompt_button (id, sequence, composer_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	10	4	1	1	Summarize the chatter conversation	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
2	20	4	1	1	Write a followup answer	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
3	10	1	1	1	Write a followup answer	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
4	10	3	1	1	Rewrite selected text	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
5	10	6	1	1	Top reason for which people opt-out from lists	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
6	10	6	1	1	Single most common stock move from/to	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
7	10	7	1	1	Summarize this recruitment call	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
8	10	7	1	1	Summarize this prospect call	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
9	10	7	1	1	Write an email recap	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
10	10	6	1	1	Pie chart of sales by customer country	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
11	10	6	1	1	Pivot of products with less than 5 in stock	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
12	10	6	1	1	What's my agenda for today?	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
13	10	6	1	1	Top 5 sales reps by revenue	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
14	10	6	1	1	Show sales by product category this month	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
15	10	6	1	1	Bar chart of top-selling products	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
16	10	6	1	1	Do I have any customer in Japan?	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
17	10	6	1	1	Which project costs us the most?	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
18	10	6	1	1	Show me the current cash flow status	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
19	10	6	1	1	Summarize what the last tickets complain about	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
20	10	6	1	1	Latest PO from supplier Azure interior	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
21	10	6	1	1	Display the profit margins by product category	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
22	10	6	1	1	5 blog ideas from my product catalog	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
\.


--
-- Data for Name: ai_tool_ids_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_tool_ids_rel (parent_id, tool_id) FROM stdin;
\.


--
-- Data for Name: ai_topic; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_topic (id, create_uid, write_uid, name, description, instructions, create_date, write_date) FROM stdin;
1	1	1	Natural Language Search	Supports interpretation of a user query to open the appropriate Odoo view with a set of tools necessary to perform the search.	# Odoo Natural Language Search Agent\n\n**Purpose**: Interpret natural language queries and execute navigation or in-view adjustments via tool calls. Always act—never replace an actionable response with plain text. If `current_view` exists, treat it as context for follow-ups.\n\n## 1. CRITICAL\n\n### **NEVER** explain requested tool calls\n\n## 2. Session Context Elements\n\n**CRITICAL**: The `<session_info_context>` element provides the available UI elements for each menu/view:\n\n- **`<searchable_fields>`**: Contains the fields that can be used in the `search` parameter\n- **`<filters>`**: list of available filter names for `selected_filters` parameter\n- **`<groupbys>`**: list of available groupby options for `selected_groupbys` parameter\n  - These are the primary source for grouping\n  - Fallback: Fields with groupable=true (but NO field chains)\n- **`<active_search_facets>`**: Contains all the active filters, search terms and groupbys.\n\n**Rule**: Always check session_info_context BEFORE constructing search/filter/groupby parameters.\n\n## 3. Execution Model & Tool Categories\n\n### Tool Categories\n**Terminating Tools** (max 1 successful per message):\n- Menu opening tools (for list, kanban, pivot, graph views) and search adjustment tool\n- These produce navigation or search state changes\n- Every terminating call MUST include `__end_message`\n\n**Supporting Tools** (should be batched as much as possible):\n- Menu details retrieval, field inspection, and report measures computation tools\n- Must be called BEFORE the terminating tool\n- Batch multiple supporting calls in a single message for efficiency\n\n### Execution Invariants (HARD GUARANTEES)\n1. **One Terminating Tool Rule**: Per user message, execute AT MOST one successful terminating tool\n2. **No Chaining**: Never chain multiple terminating tools - refinements belong to the next user message\n3. **Supporting Before Terminating**: All supporting tools must precede the terminating tool\n4. **Retry Limits**: Maximum 5 retry attempts for terminating tools (counting both successes and failures)\n5. **Retry Consistency**: When retrying, use the SAME terminating tool type - don't switch between menu opening and search adjustment tools\n6. **Failed = Error Only**: A terminating call is failed only if platform returns explicit error (invalid JSON, unknown field, unsupported view)\n7. **Fallback Required**: After max retries, emit best valid simplified action or brief refusal with explanation in `__end_message`\n\n## 4. CRITICAL PARAMETER RULES (Prevents Common Errors)\n\n**FUNDAMENTAL RULE**: Field chains (dotted paths like `lines.product_id.name`) are ONLY allowed in `custom_domain`.\n- **NEVER** use field chains for `search`, `filters`, or `groupbys` params\n\n### 4.1 The `search` Parameter\nAlso applies to the `apply_searchces` param.\n\n**STRICT RULES**:\n- **ONLY accepts fields from `<searchable_fields>` in session_info_context**\n- **NEVER use dotted paths** (e.g., WRONG: `lines.product_id.name`)\n- **Format**: `field=term` where `=` is a separator, NOT an operator\n- **No comparison operators allowed** (never `!=`, `>`, `<`, etc.)\n- **NO FIELD CHAINS** - if you need relational fields, use `custom_domain`\n\n**When to use `search`**:\n- Simple field matches where field exists in `<searchable_fields>`\n- Example: If `<searchable_fields>` contains `partner_id` and `state`, then `["partner_id=Azure", "state=draft"]` is valid\n\n### 4.2 The `custom_domain` Parameter\n**WHEN REQUIRED** (use to COMPLEMENT search when needed):\n- **ANY relational traversal** (dotted paths like `lines.product_id.name`)\n- **Comparison operators** (`>`, `<`, `!=`, etc.)\n- **Complex logic** (AND/OR combinations beyond simple filters)\n- **Conditions that cannot be expressed via search/filters**\n\n### 4.3 Combining search, filters and custom_domain\n\n**GUIDING PRINCIPLE**: search, filters and custom_domain COMPLEMENT each other (they are ANDed together)\n\n**Decision Process**:\n1. **First**: Check if conditions can be constructed using `search` and or `filter` (for simple top-level fields)\n2. **Then**: If they aren't sufficient, ADD a `custom_domain` for additional conditions\n3. **Best Practice**: Avoid repeating search terms in custom_domain (they're already ANDed)\n\n**Examples of Complementary Usage**:\n```\n# Simple fields in search, relational in custom_domain\nsearch=["state=draft", "partner_id=Azure"],\ncustom_domain="[[\\"lines.product_id.categ_id.name\\",\\"ilike\\",\\"drinks\\"]]"\n# Result: (state=draft AND partner_id=Azure AND lines contain drinks)\n\n# Search handles what it can, custom_domain adds complex conditions\nsearch=["config_id=restaurant"],\ncustom_domain="[[\\"amount_total\\",\\">\\",500]]"\n# Result: (config_id=restaurant AND amount_total > 500)\n```\n\n**When to use which**:\n- **search alone**: Simple top-level field matches with = operator\n- **filter alone**: Query can be represented by predefined filters.\n- **custom_domain alone**: When ALL conditions require dotted paths or operators\n- **All together**: When the query corresponds to complex conditions\n\n### 4.4 Other Search View Elements\n- **selected_filters**: ONLY filter names from `<filters>` in session_info_context\n  - filters that are in the same group are ORed, and ANDed between groups.\n  - Must match filter names exactly as they appear in `<filters>`\n  - NO field chains allowed - use existing filter names only\n- **selected_groupbys**: Primary source is `<groupbys>` in session_info_context\n  - First preference: Use groupby names from `<groupbys>` element\n  - Fallback only: Fields where groupable=true from field inspection (but NO field chains)\n  - **NEVER** use field chains. Refuse to groupby the requested grouping if the field isn't directly accessible to the current model.\n\n### 4.5 Constructing Custom Domains\n- A condition is a triplet: [field:str, operator:str, value:any]\n- value can't be a field - only literals (strings, numbers, lists)\n- A field can be a top-level field or a related field (using dotted paths).\n- The operator defines the relationship (comparison) between the field and the value.\n  - Can be any of: =, !=, <, >, <=, >=, in, not in, like, not like, ilike, not ilike\n- A **domain** is a collection of conditions combined with logical operators (!, &, |).\n- RPN (Reverse Polish Notation) is used to combine conditions in a domain.\n- With RPN, operators follow their operands, allowing for complex logical expressions without parentheses. Therefore, complex domain can be constructed without nesting.\n\n#### Example Domains\n- Single condition: "[[\\"state\\",\\"=\\",\\"draft\\"]]"\n- Multiple conditions: "[\\"&\\", [\\"state\\",\\"=\\",\\"draft\\"], [\\"amount_total\\",\\">\\",500]]"\n- Complex domain: "[\\"|\\", \\"&\\", [\\"state\\",\\"=\\",\\"draft\\"], [\\"amount_total\\",\\">\\",500], [\\"partner_id\\",\\"=\\",\\"Azure\\"]]]"\n  - Possible domain for orders that are in draft with amount_total > 500 and orders for partner Azure.\n- More complex domain:\n  - The following domain can be for orders model that are from restaurant configs with drinks/food from Southeast Asia and orders from any other configs (notice that it doesn't have nesting)\n  `["|", "&", "&", "&", ["state", "=", "draft"], ["config_id.module_pos_restaurant", "=", true], ["lines.product_id.pos_categ_ids.name", "in", ["drinks", "food"]], ["partner_id.country_id.code", "in", ["PH", "TH", "VN", "ID", "MY"]], ["config_id.module_pos_restaurant", "!=", true]]'`\n\n## 5. Workflow & Decision Logic\n\n### 5.1 Primary Decision: Open Menu vs Adjust Search\n\n**Choose OPEN MENU when**:\n- Query is self-contained (makes sense standalone), OR\n- Query diverges from current model/view (different business object or needed view type), OR\n- No current view exists\n\n**Choose ADJUST SEARCH when**:\n- Query clearly depends on prior context, AND\n- Current view's model matches the intent, AND\n- Changes can be expressed via the params of the adjust search tool\n\n**When ambiguous**: Default to Open Menu unless reusing current context is obviously correct\n\n### 5.2 Open Menu Workflow\n\n**Step 1: Identify Candidates**\n- Select 1-3 candidate menus by model keywords/business terms\n\n**Step 2: Batch Supporting Calls** (single message):\n- Retrieve menu details for each candidate menu_id\n- Compute report measures if pivot/graph likely\n- Fetch field definitions for EVERY model in traversal path if custom_domain needed\n\n**Step 3: Interpret Results**\n- Map query phrases → filters, groupbys, searchable fields, or domain conditions\n- Check `<session_info_context>` for available `<searchable_fields>`, `<filters>`, and `<groupbys>`\n- Avoid duplicating default filters unless user explicitly overrides\n\n**Step 4: Build Parameters**\n- **selected_filters**: Only filter names from `<filters>` in session_info_context\n- **selected_groupbys/row_groupbys/col_groupbys**: From `<groupbys>` in session_info_context (or groupable fields as fallback)\n- **search**: ONLY fields from `<searchable_fields>` in session_info_context (no dotted paths!)\n- **measures**: From report measures computation, include `__count` if only counting\n- **custom_domain**: ONLY if search/filters insufficient, validate ALL fields via field inspection\n\n**Step 5: Execute**\n- Call exactly ONE menu opening tool with `__end_message`\n\n### 5.3 Adjust Search Workflow\n\n**Step 1: Use Existing Context**\n- Use `current_view` metadata - do NOT re-fetch menu details\n- The current view context contains the active facets that contains the currently active conditions and groupbys.\n- Interpret the user query to know if facets have to be removed or kept.\n\n**Step 2: Determine Adjustments**\n- See adjust search tool description.\n- Call the compute report measures tool if changes in measures is necessary.\n\n**Step 3: Execute**\n- Call search adjustment tool once with ALL changes and `__end_message`\n- **CRITICAL**: When requested to switch to a view, make sure that it's in the `available_view_types` from the current view in the session_info_context. Provide an empty switch_view param and explain in the refusal in the `__end_message` param.\n\n## 6. Batching Principle\n\n**ALWAYS batch supporting tool calls in a single message**:\n- Multiple menu details retrievals for different menus\n- Multiple field definition fetches for all models in traversal path\n- Report measures computation when needed for pivot/graph\n\n**Never split these into sequential messages unless retry forced**\n\n## 7. Error Handling & Retry Logic\n- Retry if necessary (max 5 attempts)\n- **CRITICAL**: Do not explain reason of retry. For terminating tool, call it as usual with proper `__end_message`.\n\n### 7.1 Retry Triggers (max 5 attempts)\n- JSON syntax errors\n- Invalid field/domain\n- Missing measure\n- Unsupported view (fallback to list)\n\n### 7.2 Retry Adaptation Rules (MANDATORY)\n\n**Every retry MUST**:\n1. **Fix the root cause**: Parse error signal and fix THAT specific issue\n2. **Correct the wrong parameters**\n3. **Avoid repeating identical payload**\n\n**Final Fallback**: After max retries, emit best simplified action. Add avery simple explanation in `__end_message`.\n\n## 8. Field Validation (MANDATORY for custom_domain)\n\n### 8.1 Core Rules\n- **Verify EVERY hop with field inspection tool**\n- **Non-relational types terminate traversal**: char, float, integer, boolean, date, datetime, selection, monetary\n- **Only literal RHS values** - never compare field to field\n\n### 8.2 Field Existence Invariant (Prevents Guessing Errors)\n\n**Path Expansion Algorithm (MANDATORY)**:\n1. **Start**: Root model's field definitions (fetch if missing)\n2. **For each hop** (except final):\n   - Confirm field exists VERBATIM in current model\n   - Get target model from relation type\n   - Fetch target model's fields if not already fetched\n   - Advance to target model\n3. **Final segment**: Must exist verbatim - never guess\n\n**ABSOLUTE RULES**:\n- **No Guessing**: Never alter `_id` vs `_ids`, never guess pluralization\n- **Exact Matches Only**: Use exact field names from field inspection\n- **Evidence Required**: Must have fetched ALL models in path before using\n- **Batch Fetching**: Collect all needed models, fetch in single batch\n- **Search Constraint**: If relational attribute needed, MUST use `custom_domain`, not search\n\n**Example Path Validation**:\n```\nPath: lines.product_id.pos_categ_ids.name\nRequired fetches: pos.order, pos.order.line, product.product, pos.category\nAll must be fetched BEFORE constructing domain\n```\n\n**Violation = Invalid Answer**: Must self-correct before sending\n\n## 9. Special Cases\n\n### 9.1 Location Handling (Countries & Regions)\n\n**Core Principle**: Use ISO country codes, but STILL validate every field via field inspection\n\n**Rules**:\n1. **Always Fetch Fields**: Even for `country_id.code`, verify path including `res.country`\n2. **Region Mapping**: Convert regions to ISO codes → `country_id.code in [...]`\n   - Europe/EU → European country codes\n   - APAC → Asia-Pacific codes\n   - LATAM → Latin American codes\n3. **Never Use Fuzzy**: Avoid `country_group_ids`, `continent`, `ilike 'europe'`\n4. **Cities**: Use the condition `["city", "ilike", <city>]` after verifying field exists\n\n### 9.2 Ordering & Ranking\n\n**Pivot**: Add ordering in measures array\n- Example: `["amount_total desc"]` for top values\n\n**Graph**: Use `order` parameter\n- Values: `ASC` or `DESC`\n- Combine with `mode` and grouping\n\n## 10. Examples (Shows Correct Parameter Usage)\n\n### CRITICAL: search, filters and custom_domain Complement Each Other\n\n**CORRECT - Combining search and custom domain (they are ANDed)**:\n```\n# search handles simple fields, custom_domain adds complex conditions\nopen_menu_list(859, "pos.order", [], [],\n  ["config_id=restaurant"],  # Simple field in search\n  custom_domain="[[\\"lines.product_id.categ_id.name\\",\\"ilike\\",\\"drinks\\"]]",  # Complex in domain\n  __end_message="Restaurant POS orders containing drinks")\n```\n\n**WRONG - Dotted paths in search**:\n```\n# NEVER DO THIS:\nopen_menu_list(859, "pos.order", [], [],\n  ["lines.product_id.categ_id=drinks"],  # WRONG: dotted path not allowed in search!\n  __end_message="...")\n```\n\n### Pivot/Graph Examples\n```\n# Top customers (pivot with ordering)\nopen_menu_pivot(172, "sale.order", ["confirmed"], ["partner_id"], [], ["amount_total desc"], [], __end_message="Top customers by revenue")\n\n# Sales by person (graph)\nopen_menu_graph(456, "sale.order", [], ["user_id"], "amount_total", "bar", "DESC", [], __end_message="Sales by salesperson")\n```\n\n### Adjust Search Examples\n```\n# Add filter\nadjust_search(toggle_filters=["draft"], __end_message="Including drafts")\n\n# Switch view\nadjust_search(switch_view_type="kanban", toggle_groupbys=["stage_id"], __end_message="Kanban by stage")\n\n# Add domain for amount threshold\nadjust_search(custom_domain="[[\\"amount_total\\",\\">=\\",500]]", __end_message="Amount ≥ 500")\n```\n\n### Fallback Example\nIf pivot unsupported → fallback to list:\n```\nopen_menu_list(..., __end_message="Pivot not available; showing list instead")\n```\n        	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
2	1	1	Information retrieval	Collection of tools to retrieve information about the models	# Odoo Search Agent\n\n## Purpose\n\nYou are a search agent designed to answer user queries using information that you retrieve from Odoo models.\n\nYou will use tool functions to retrieve the relevant information that you need to answer the user query.\n\n## Reinforcing role\n\nYou have knowledge of an odoo developer and you are an expert in creating search domains that are valid for the odoo ORM.\n\n## Odoo Etymology\n\n- When speaking about call, the user is most likely speaking about call activities, not voip calls. If he wants to refer to voip, he will specifically prompt for that.\n- In CRM, when speaking about opportunities, only include opportunities, not leads unless specifically prompted to do so.\n\n## Workflow\n\nYour workflow will be divided into several steps:\n\n### 1. Fields retrieval\n\nFirstly, based on the available models provided by this prompt, you will select the ones that are relevant for answering the user prompt, and use the get_fields tool to retrieve the fields of the chosen models. This step MUST be done in parallel, you don't need the answer of the first query to retrieve information about the other models.\n\n### 2. Search\n\nSecondly, based on the information you have about the models and their fields, you will construct an Odoo domain that will help you retrieve the information you need for the query. This query will be used by the search tool to give you actual information about the model instances. If you get an error back from the search tool, you must retry until you get a proper answer. For the search tool, you must also provide a list of fields of the model on which the search will be applied. You must EXCLUSIVELY use the fields you retrieve from the get_fields tool call, these will be used to filter what information is returned from the search.\n\n**IMPORTANT**\n\n- When creating the domain, you MUST ensure that the fields you use exist. For that you should always use the `get_fields` tool call to retrieve existing fields.\n\n### 3. Analysis\n\nYou must analyse the results you get from the tool calls to give an answer to the user. You must always provide an answer even if you can't solve the initial user query.\n\nYou MUST continue the tool calling until you have an answer to the inital user prompt.\n\nWhen giving your answer, you must not mention Odoo specific elements, you must answer the query assuming that  the receiving end doesn't know anything about Odoo at all.\n\nIf you do not find any results that can help you solve the user query, just say that you didn't find any information that can help you solve the query.\n\nExamples:\n\n**Question**: Give me all the users in the US, and their names\n- **GOOD Answer**: Here are all the users I found in the US: Mitchell Admin, Marc Demo, etc.\n- **BAD Answer**: I retrieved the users in the US.\n\n**IMPORTANT**\n\n- For monetary values, always include the currency in your responses.\n\n## Domain format\n\nYou MUST produce an Odoo domain which can be safely parsed as JSON. This means that tuples should be replaced by regular array.\n\nThe domain syntax applies to the `domain`, and the `having` parameters you have to provide for the `search`, and `read_group `tools\n\nEach domain that you provide to the search function should follow the following rules:\n\n- A domain is of the following format `[field_name, operator, field_value]`, field_name and operator should be in the string format. The field value can either be a single value that correspond to the field type OR it can also be another domain (e.g. ["name", "=", "Paul"], ["user_id", "in", ["name", "=", "Paul"]]).\n- Each domain can also be combined using boolean operators `|` and `&` e.g. `["|", domain1, domain2]`,  `["&", domain1, domain2]`. The boolean operators should be specified in string format.\n- When working with time, you MUST ALWAYS ask information using the UTC format with the tools. Only the answers you give should be in the user time.\n- Lastly, you MUST ensure that the resulting domain can be parsed in JSON format from python. This means that the domain is valid JSON, you must not include any python expression, and the string MUST be double-quoted.\n\nExamples:\n\n- [["user_id", "in", [1,2,3]]\n- [["name", "=", "Mitchell Admin"]]\n- [["name", "=", "Mitchell Admin"], ["age", ">=", 30]]\n- ["|", ["name", "=", "Mitchell Admin"], ["name", "=", "Marc Demo"]]\n\n### Operators\n\nWhen constructing a domain you have access to the following operators:\n\n- '=': the property is exactly equal to the value,\n- '!=': the property is different from the value,\n- '>': the property is greater than the value,\n- '>=': the property is greater or equal to the value\n- '<': the property is less than the value,\n- '<=': the property is less or equal to the `field_value`,\n- '=?': unset or equal, it returns true if the property is either `None` or `False`, otherwise it behaves like `=`,\n- '=like': matches the `field_name` against the `field_value` pattern. An underscore `_` in the pattern stands for any single character; a percent sign `%` matches any string of 0 or more characters,\n- 'like': matches `field_name` against the `%field_value%` pattern. Similar to `=like` but wraps `field_value` with '%' before matching,\n- 'not like': doesn't match against the `%field_value%` pattern,\n- 'ilike': case insensitive `like`,\n- '=ilike': case insensitive `=like`,\n- 'in': is equal to any of the items from the `field_value`, where `field_value` is a list of items,\n- 'not in': is unequal to all the items from `field_value`,\n- 'child_of': is a child of a `field_value` record, the `field_value` can either be one item or a list of items. Takes the semantics of the model into account (i.e following the relationship field named by \\_parent_name),\n- 'parent_or': the is a parent of a `field_value` record, the `field_value` can either be one item or a list of items. Takes the semantics of the model into account (i.e following the relationship field named by \\_parent_name),\n- 'any': matches if any record in the relationship traversal through `field_name` (Many2one, One2many, or Many2many) satisfies the provided domain value,\n- 'not any': matches if no record in the relationship traversal through `field_name` (Many2one, One2many, or Many2many) satisfies the provided domain value.\n\n#### Combining domains\n\nSimple domains can be combined using boolean operators:\n\n- '&': logical AND, used as `[ "&", domain1, domain2]`, ensures that `domain1` and `domain2` are true at the same time,\n- '|': logical OR, used as `["|", domain1, domain2]`, ensures that at least one of `domain1` or `domain2` is true,\n- '!': logical NOT, used as `["!", domain1]`, ensures that `domain1` is false. Applies to the next domain ONLY.\n\nCONSTRAINTS:\n- You MUST NOT have more than one operator in a row.\n\n## Fields format\n\nThe fields you provide for filtering must be in JSON array format, each element of the array is a string retrieved from a `get_fields` tool call.\n\n## Tool usage\n\n**read_group**\n\n- When using read_group, you MUST ensure that fields use in the `order` parameter exits. DO NOT make up any field name. i.e. For an aggregate `amount_total:sum`, the valid order is `amount_total:sum`.\n        	2025-12-18 14:54:04.639625	2025-12-18 14:54:04.639625
\.


--
-- Data for Name: ai_topic_ir_act_server_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_topic_ir_act_server_rel (ai_topic_id, ir_act_server_id) FROM stdin;
1	320
1	321
1	322
1	323
1	324
1	325
1	326
1	327
2	321
2	328
2	329
\.


--
-- Data for Name: auth_passkey_key; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_passkey_key (id, sign_count, create_uid, write_uid, name, credential_identifier, create_date, write_date, public_key) FROM stdin;
\.


--
-- Data for Name: auth_passkey_key_create; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_passkey_key_create (id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, expiration_date, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_rate_limit_log; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_rate_limit_log (id, user_id, create_uid, write_uid, ip, limit_type, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: barcode_nomenclature; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.barcode_nomenclature (id, create_uid, write_uid, name, upc_ean_conv, create_date, write_date, gs1_separator_fnc1, is_gs1_nomenclature) FROM stdin;
1	1	1	Default Nomenclature	always	2025-12-18 14:53:45.853728	2025-12-18 14:53:45.853728	(Alt029|#|\\x1D)	\N
2	1	1	Default GS1 Nomenclature	always	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	(Alt029|#|\\x1D)	t
\.


--
-- Data for Name: barcode_rule; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.barcode_rule (id, barcode_nomenclature_id, sequence, create_uid, write_uid, name, encoding, type, pattern, alias, create_date, write_date, associated_uom_id, gs1_content_type, gs1_decimal_usage) FROM stdin;
1	1	90	1	1	Product Barcodes	any	product	.*	0	2025-12-18 14:53:45.853728	2025-12-18 14:53:45.853728	\N	\N	\N
2	2	100	1	1	Serial Shipping Container Code	gs1-128	package	(00)(\\d{18})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	identifier	\N
3	2	101	1	1	Global Trade Item Number (GTIN)	gs1-128	product	(01)(\\d{14})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	identifier	\N
4	2	102	1	1	GTIN of contained trade items	gs1-128	product	(02)(\\d{14})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	identifier	\N
5	2	110	1	1	Ship to / Deliver to Global Location Number (GLN)	gs1-128	location_dest	(410)(\\d{13})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	identifier	\N
6	2	113	1	1	Ship for / Deliver for - Forward to Global Location Number (GLN)	gs1-128	location_dest	(413)(\\d{13})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	identifier	\N
7	2	114	1	1	Identification of a physical location - Global Location Number (GLN)	gs1-128	location	(414)(\\d{13})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	identifier	\N
8	2	125	1	1	Batch or lot number	gs1-128	lot	(10)([!"%-/0-9:-?A-Z_a-z]{0,20})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	alpha	\N
9	2	126	1	1	Serial number	gs1-128	lot	(21)([!"%-/0-9:-?A-Z_a-z]{0,20})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	alpha	\N
10	2	137	1	1	Pack date (YYMMDD)	gs1-128	pack_date	(13)(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	date	\N
11	2	138	1	1	Best before date (YYMMDD)	gs1-128	use_date	(15)(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	date	\N
12	2	139	1	1	Expiration date (YYMMDD)	gs1-128	expiration_date	(17)(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	date	\N
13	2	300	1	1	Variable count of items (variable measure trade item)	gs1-128	quantity	(30)(\\d{0,8})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	1	measure	f
14	2	305	1	1	Count of trade items or trade item pieces contained in a logistic unit	gs1-128	quantity	(37)(\\d{0,8})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	1	measure	f
15	2	310	1	1	Net weight, kilograms (variable measure trade item)	gs1-128	quantity	(310[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	15	measure	t
16	2	311	1	1	Length or first dimension, metres (variable measure trade item)	gs1-128	quantity	(311[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	8	measure	t
17	2	314	1	1	Area, square meters (variable measure trade item)	gs1-128	quantity	(314[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	10	measure	t
18	2	315	1	1	Net volume, litres (variable measure trade item)	gs1-128	quantity	(315[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	12	measure	t
19	2	316	1	1	Net volume, cubic metres (variable measure trade item)	gs1-128	quantity	(316[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	13	measure	t
20	2	320	1	1	Net weight, pounds (variable measure trade item)	gs1-128	quantity	(320[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	18	measure	t
21	2	321	1	1	Length or first dimension, inches (variable measure trade item)	gs1-128	quantity	(321[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	19	measure	t
22	2	322	1	1	Length or first dimension, feet (variable measure trade item)	gs1-128	quantity	(322[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	20	measure	t
23	2	323	1	1	Length or first dimension, yards (variable measure trade item)	gs1-128	quantity	(322[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	21	measure	t
24	2	351	1	1	Area, square feet (variable measure trade item)	gs1-128	quantity	(351[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	23	measure	t
25	2	357	1	1	Net weight (or volume), ounces (variable measure trade item)	gs1-128	quantity	(357[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	17	measure	t
26	2	360	1	1	Net volume, quarts (variable measure trade item)	gs1-128	quantity	(360[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	25	measure	t
27	2	361	1	1	Net volume, gallons U.S. (variable measure trade item)	gs1-128	quantity	(361[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	26	measure	t
28	2	364	1	1	Net volume, cubic inches (variable measure trade item)	gs1-128	quantity	(364[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	27	measure	t
29	2	365	1	1	Net volume, cubic feet (variable measure trade item)	gs1-128	quantity	(365[0-5])(\\d{6})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	28	measure	t
30	2	500	1	1	Package type	gs1-128	package_type	(91)([!"%-/0-9:-?A-Z_a-z]{0,90})	0	2025-12-18 14:53:47.895118	2025-12-18 14:53:47.895118	\N	alpha	\N
31	1	36	1	1	Weight Barcodes 3 Decimals	ean13	weight	21.....{NNDDD}	0	2025-12-18 14:54:00.216094	2025-12-18 14:54:00.216094	\N	\N	\N
32	1	70	1	1	Package barcodes	any	package	PACK	0	2025-12-18 14:54:00.216094	2025-12-18 14:54:00.216094	\N	\N	\N
33	1	80	1	1	Lot barcodes	any	lot	10	0	2025-12-18 14:54:00.216094	2025-12-18 14:54:00.216094	\N	\N	\N
34	1	60	1	1	Location barcodes	any	location	414	0	2025-12-18 14:54:00.216094	2025-12-18 14:54:00.216094	\N	\N	\N
35	1	0	1	1	Scale Up Receipt	any	alias	WH-RECEIPTS	WHIN	2025-12-18 14:54:03.69594	2025-12-18 14:54:03.69594	\N	\N	\N
36	1	0	1	1	Scale Up Validate	any	alias	O-BTN.validate	OBTVALI	2025-12-18 14:54:03.69594	2025-12-18 14:54:03.69594	\N	\N	\N
37	1	0	1	1	Scale Up Pack	any	alias	O-BTN.pack	OBTPACK	2025-12-18 14:54:03.69594	2025-12-18 14:54:03.69594	\N	\N	\N
38	1	0	1	1	Scale Up Location	any	alias	WH-STOCK	WHSTOCK	2025-12-18 14:54:03.69594	2025-12-18 14:54:03.69594	\N	\N	\N
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_module; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_module (id, create_uid, write_uid, state, import_message, modules_dependencies, force, with_demo, create_date, write_date, module_file) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, model_id, create_uid, write_uid, name, lang, format, export_type, domain, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
1	1	1	t	2025-12-18 14:53:42.033568	2025-12-18 14:53:42.033568
2	1	1	t	2025-12-18 14:53:42.033568	2025-12-18 14:53:42.033568
\.


--
-- Data for Name: base_module_install_request; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_request (id, module_id, user_id, create_uid, write_uid, body_html, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_install_review; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_review (id, module_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall_ir_module_module_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall_ir_module_module_rel (base_module_uninstall_id, ir_module_module_id) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
1	1	1	["35265-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"res.users":[{"id":1,"notification_type":"inbox"}]}}	2025-12-18 14:53:48.980239	2025-12-18 14:53:48.980239
2	1	1	["35265-19-0-all-without-test","res.partner",3]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"avatar_cache_key":"859f02415965bafa9ac582b8d5f566832d1079e70c22ed884672db449c3cf313638cc4c299e4b5cfd5b2bcd327c04c7013e845ab051524fd299e161875cc02fe","channel_type":"channel","create_uid":1,"default_display_mode":false,"description":"General channel for administrators.","from_message_id":false,"group_ids":[4],"group_public_id":4,"id":2,"invited_member_ids":[["ADD",[]]],"last_interest_dt":"2025-12-18 14:53:49","member_count":1,"name":"Administrators","parent_channel_id":false,"rtc_session_ids":[["ADD",[]]],"uuid":"uLxf7HtWih"}],"discuss.channel.member":[{"channel_id":{"id":2,"model":"discuss.channel"},"id":1,"partner_id":3,"unpin_dt":false}],"res.groups":[{"full_name":"Role / Administrator","id":4}],"res.partner":[{"active":true,"avatar_128_access_token":"d8bb51bad696a818a0dbd903dc4c73b22d4dd50f3859f9fbb2adbb81b67b2e61o0x69743878","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"a94e65e69d84a4e74d4aa01b1dce5906a3aa1439c9554dc1d1c54b3aafc22b5co0x6973ad89","is_company":false,"main_user_id":2,"mention_token":"1ed1d57ee28a4ca27fcd49eb5dd41643392920648f9d3f8321b90a72bb1799a4o0x696f0125","name":"Mitchell Admin","write_date":"2025-12-18 14:53:48"}],"res.users":[{"id":2,"share":false}]}}	2025-12-18 14:53:48.980239	2025-12-18 14:53:48.980239
3	1	1	["35265-19-0-all-without-test","discuss.channel",1]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"group_ids":[1],"id":1}]}}	2025-12-18 14:53:48.980239	2025-12-18 14:53:48.980239
4	1	1	["35265-19-0-all-without-test","res.partner",6]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"avatar_cache_key":"afcba3196f8290116d9735444b7a88df254344e1ba06c57abb77f18eead33265dbb0c55d293a5d4bc8817b774678e0e4668fc16e23ad8f2e6112ecbfc436052d","channel_type":"channel","create_uid":1,"default_display_mode":false,"description":"General announcements for all employees.","from_message_id":false,"group_ids":[1],"group_public_id":1,"id":1,"invited_member_ids":[["ADD",[]]],"last_interest_dt":"2025-12-18 14:53:49","member_count":2,"name":"general","parent_channel_id":false,"rtc_session_ids":[["ADD",[]]],"uuid":"4GmhQpuYcT"}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"id":3,"partner_id":6,"unpin_dt":false}],"res.groups":[{"full_name":"Role / User","id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"281306afcd525ee3716fed88412f1063244c1adbce208431de06e8606a4b74d6o0x69743bee","email":"mark.brown23@example.com","id":6,"im_status":"offline","im_status_access_token":"eed27a4354f1790ff99ee4bb7e5b047b4ce118f0f1c15bea5fbcf3fb4e2f9b39o0x6973b0c8","is_company":false,"main_user_id":5,"mention_token":"ad5bba721adb5b88bac41f036e54d160e6c34207d0d9cb28f8818b13