--
-- PostgreSQL database dump
--

\restrict 90NDGkBLcrFEj9AMEGlOBraiVZ58QQbs4viGHbHWceds74FZFDedmh8WKag1RoB

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.0 (Debian 18.0-1.pgdg12+3)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: vector; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS vector WITH SCHEMA public;


--
-- Name: EXTENSION vector; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION vector IS 'vector data type and ivfflat and hnsw access methods';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_account OWNER TO runbot;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO runbot;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_applicability OWNER TO runbot;

--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNER TO runbot;

--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    sequence integer,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_distribution_model OWNER TO runbot;

--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNER TO runbot;

--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    account_id integer,
    product_uom_id integer,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision,
    x_plan2_id integer,
    x_plan3_id integer,
    task_id integer,
    parent_task_id integer,
    project_id integer,
    department_id integer,
    manager_id integer,
    employee_id integer,
    validated boolean,
    helpdesk_ticket_id integer
);


ALTER TABLE public.account_analytic_line OWNER TO runbot;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Project Account';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_line.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan3_id IS 'Internal';


--
-- Name: COLUMN account_analytic_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.employee_id IS 'Employee';


--
-- Name: COLUMN account_analytic_line.validated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.validated IS 'Validated line';


--
-- Name: account_analytic_line_calendar_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_calendar_employee (
    id integer NOT NULL,
    user_id integer NOT NULL,
    employee_id integer,
    create_uid integer,
    write_uid integer,
    checked boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_line_calendar_employee OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_calendar_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_calendar_employee IS 'Personal Filters on Employees for the Calendar view';


--
-- Name: COLUMN account_analytic_line_calendar_employee.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line_calendar_employee.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.employee_id IS 'Employee';


--
-- Name: COLUMN account_analytic_line_calendar_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line_calendar_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line_calendar_employee.checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.checked IS 'Checked';


--
-- Name: COLUMN account_analytic_line_calendar_employee.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.active IS 'Active';


--
-- Name: COLUMN account_analytic_line_calendar_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line_calendar_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.write_date IS 'Last Updated on';


--
-- Name: account_analytic_line_calendar_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_calendar_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_calendar_employee_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_calendar_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_calendar_employee_id_seq OWNED BY public.account_analytic_line_calendar_employee.id;


--
-- Name: account_analytic_line_hr_timesheet_merge_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel (
    hr_timesheet_merge_wizard_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_hr_timesheet_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel IS 'RELATION BETWEEN hr_timesheet_merge_wizard AND account_analytic_line';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    complete_name character varying,
    name jsonb NOT NULL,
    default_applicability jsonb,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_plan OWNER TO runbot;

--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_plan_id_seq OWNER TO runbot;

--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: ai_agent; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subtitle character varying,
    response_style character varying NOT NULL,
    llm_model character varying NOT NULL,
    system_prompt text,
    active boolean,
    restrict_to_sources boolean,
    is_system_agent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent OWNER TO runbot;

--
-- Name: TABLE ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent IS 'AI Agent';


--
-- Name: COLUMN ai_agent.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.partner_id IS 'Partner';


--
-- Name: COLUMN ai_agent.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent.subtitle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.subtitle IS 'Description';


--
-- Name: COLUMN ai_agent.response_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.response_style IS 'Response Style';


--
-- Name: COLUMN ai_agent.llm_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.llm_model IS 'LLM Model';


--
-- Name: COLUMN ai_agent.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.system_prompt IS 'System Prompt';


--
-- Name: COLUMN ai_agent.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.active IS 'Active';


--
-- Name: COLUMN ai_agent.restrict_to_sources; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.restrict_to_sources IS 'Restrict to Sources';


--
-- Name: COLUMN ai_agent.is_system_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.is_system_agent IS 'System Agent';


--
-- Name: COLUMN ai_agent.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_date IS 'Last Updated on';


--
-- Name: ai_agent_ai_topic_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_ai_topic_rel (
    ai_agent_id integer NOT NULL,
    ai_topic_id integer NOT NULL
);


ALTER TABLE public.ai_agent_ai_topic_rel OWNER TO runbot;

--
-- Name: TABLE ai_agent_ai_topic_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_ai_topic_rel IS 'RELATION BETWEEN ai_agent AND ai_topic';


--
-- Name: ai_agent_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_id_seq OWNER TO runbot;

--
-- Name: ai_agent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_id_seq OWNED BY public.ai_agent.id;


--
-- Name: ai_agent_source; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_source (
    id integer NOT NULL,
    agent_id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    type character varying NOT NULL,
    status character varying,
    url character varying,
    error_details text,
    is_active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent_source OWNER TO runbot;

--
-- Name: TABLE ai_agent_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_source IS 'AI Agent Source';


--
-- Name: COLUMN ai_agent_source.agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.agent_id IS 'Agent';


--
-- Name: COLUMN ai_agent_source.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_agent_source.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent_source.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent_source.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.name IS 'Name';


--
-- Name: COLUMN ai_agent_source.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.type IS 'Type';


--
-- Name: COLUMN ai_agent_source.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.status IS 'Status';


--
-- Name: COLUMN ai_agent_source.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.url IS 'URL';


--
-- Name: COLUMN ai_agent_source.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.error_details IS 'Error Details';


--
-- Name: COLUMN ai_agent_source.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.is_active IS 'Active';


--
-- Name: COLUMN ai_agent_source.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent_source.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_date IS 'Last Updated on';


--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_source_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_source_id_seq OWNER TO runbot;

--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_source_id_seq OWNED BY public.ai_agent_source.id;


--
-- Name: ai_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer (
    id integer NOT NULL,
    ai_agent integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    interface_key character varying NOT NULL,
    default_prompt text,
    is_system_default boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_composer OWNER TO runbot;

--
-- Name: TABLE ai_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer IS 'AI model configurations (system prompts) for text drafting.';


--
-- Name: COLUMN ai_composer.ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.ai_agent IS 'Agent';


--
-- Name: COLUMN ai_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_uid IS 'Created by';


--
-- Name: COLUMN ai_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_composer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.name IS 'Rule Name';


--
-- Name: COLUMN ai_composer.interface_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.interface_key IS 'Action';


--
-- Name: COLUMN ai_composer.default_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.default_prompt IS 'Instructions';


--
-- Name: COLUMN ai_composer.is_system_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.is_system_default IS 'Is the rule a system default or user created';


--
-- Name: COLUMN ai_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_date IS 'Created on';


--
-- Name: COLUMN ai_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_date IS 'Last Updated on';


--
-- Name: ai_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_composer_id_seq OWNER TO runbot;

--
-- Name: ai_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_composer_id_seq OWNED BY public.ai_composer.id;


--
-- Name: ai_composer_ir_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer_ir_model_rel (
    ai_composer_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ai_composer_ir_model_rel OWNER TO runbot;

--
-- Name: TABLE ai_composer_ir_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer_ir_model_rel IS 'RELATION BETWEEN ai_composer AND ir_model';


--
-- Name: ai_embedding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_embedding (
    id integer NOT NULL,
    attachment_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    embedding_model character varying NOT NULL,
    content text NOT NULL,
    has_embedding_generation_failed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    embedding_vector public.vector(1536)
);


ALTER TABLE public.ai_embedding OWNER TO runbot;

--
-- Name: TABLE ai_embedding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_embedding IS 'Attachment Chunks Embedding';


--
-- Name: COLUMN ai_embedding.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_embedding.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.sequence IS 'Sequence';


--
-- Name: COLUMN ai_embedding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_uid IS 'Created by';


--
-- Name: COLUMN ai_embedding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_embedding.embedding_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_model IS 'Embedding Model';


--
-- Name: COLUMN ai_embedding.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.content IS 'Chunk Content';


--
-- Name: COLUMN ai_embedding.has_embedding_generation_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.has_embedding_generation_failed IS 'Has Embedding Generation Failed';


--
-- Name: COLUMN ai_embedding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_date IS 'Created on';


--
-- Name: COLUMN ai_embedding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_date IS 'Last Updated on';


--
-- Name: COLUMN ai_embedding.embedding_vector; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_vector IS 'Embedding Vector';


--
-- Name: ai_embedding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_embedding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_embedding_id_seq OWNER TO runbot;

--
-- Name: ai_embedding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_embedding_id_seq OWNED BY public.ai_embedding.id;


--
-- Name: ai_prompt_button; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_prompt_button (
    id integer NOT NULL,
    sequence integer,
    composer_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_prompt_button OWNER TO runbot;

--
-- Name: TABLE ai_prompt_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_prompt_button IS 'Prompt that can be attached to AI UI rules for quick access by the user.';


--
-- Name: COLUMN ai_prompt_button.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.sequence IS 'Sequence';


--
-- Name: COLUMN ai_prompt_button.composer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.composer_id IS 'Composer';


--
-- Name: COLUMN ai_prompt_button.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_uid IS 'Created by';


--
-- Name: COLUMN ai_prompt_button.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_prompt_button.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.name IS 'AI Prompt';


--
-- Name: COLUMN ai_prompt_button.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_date IS 'Created on';


--
-- Name: COLUMN ai_prompt_button.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_date IS 'Last Updated on';


--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_prompt_button_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_prompt_button_id_seq OWNER TO runbot;

--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_prompt_button_id_seq OWNED BY public.ai_prompt_button.id;


--
-- Name: ai_tool_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_tool_ids_rel (
    parent_id integer NOT NULL,
    tool_id integer NOT NULL
);


ALTER TABLE public.ai_tool_ids_rel OWNER TO runbot;

--
-- Name: TABLE ai_tool_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_tool_ids_rel IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: ai_topic; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description text,
    instructions text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_topic OWNER TO runbot;

--
-- Name: TABLE ai_topic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic IS 'Create a topic that leverages instructions and tools to direct Odoo AI in assisting the user with their tasks.';


--
-- Name: COLUMN ai_topic.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_uid IS 'Created by';


--
-- Name: COLUMN ai_topic.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_topic.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.name IS 'Title';


--
-- Name: COLUMN ai_topic.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.description IS 'Description';


--
-- Name: COLUMN ai_topic.instructions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.instructions IS 'Instructions';


--
-- Name: COLUMN ai_topic.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_date IS 'Created on';


--
-- Name: COLUMN ai_topic.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_date IS 'Last Updated on';


--
-- Name: ai_topic_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_topic_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_topic_id_seq OWNER TO runbot;

--
-- Name: ai_topic_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_topic_id_seq OWNED BY public.ai_topic.id;


--
-- Name: ai_topic_ir_act_server_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic_ir_act_server_rel (
    ai_topic_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.ai_topic_ir_act_server_rel OWNER TO runbot;

--
-- Name: TABLE ai_topic_ir_act_server_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic_ir_act_server_rel IS 'RELATION BETWEEN ai_topic AND ir_act_server';


--
-- Name: auth_passkey_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key (
    id integer NOT NULL,
    sign_count integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    credential_identifier character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    public_key character varying
);


ALTER TABLE public.auth_passkey_key OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key IS 'Passkey';


--
-- Name: COLUMN auth_passkey_key.sign_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.sign_count IS 'Sign Count';


--
-- Name: COLUMN auth_passkey_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_uid IS 'Create Uid';


--
-- Name: COLUMN auth_passkey_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key.credential_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.credential_identifier IS 'Credential Identifier';


--
-- Name: COLUMN auth_passkey_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key_create (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_passkey_key_create OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key_create IS 'Create a Passkey';


--
-- Name: COLUMN auth_passkey_key_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_uid IS 'Created by';


--
-- Name: COLUMN auth_passkey_key_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNED BY public.auth_passkey_key_create.id;


--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_id_seq OWNED BY public.auth_passkey_key.id;


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_rate_limit_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_rate_limit_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    ip character varying,
    limit_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_totp_rate_limit_log OWNER TO runbot;

--
-- Name: TABLE auth_totp_rate_limit_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_rate_limit_log IS 'TOTP rate limit logs';


--
-- Name: COLUMN auth_totp_rate_limit_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.user_id IS 'User';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_rate_limit_log.ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.ip IS 'Ip';


--
-- Name: COLUMN auth_totp_rate_limit_log.limit_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.limit_type IS 'Limit Type';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_date IS 'Last Updated on';


--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_rate_limit_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNER TO runbot;

--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNED BY public.auth_totp_rate_limit_log.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_uninstall_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall_ir_module_module_rel (
    base_module_uninstall_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_uninstall_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall_ir_module_module_rel IS 'RELATION BETWEEN base_module_uninstall AND ir_module_module';


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    kpi_helpdesk_tickets_closed boolean,
    kpi_project_task_opened boolean
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_helpdesk_tickets_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_helpdesk_tickets_closed IS 'Tickets Closed';


--
-- Name: COLUMN digest_digest.kpi_project_task_opened; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_project_task_opened IS 'Open Tasks';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: discuss_call_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_call_history (
    id integer NOT NULL,
    channel_id integer NOT NULL,
    start_call_message_id integer,
    create_uid integer,
    write_uid integer,
    start_dt timestamp without time zone NOT NULL,
    end_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_call_history_channel_id_not_null_constraint CHECK ((channel_id IS NOT NULL)),
    CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint CHECK ((start_dt IS NOT NULL))
);


ALTER TABLE public.discuss_call_history OWNER TO runbot;

--
-- Name: TABLE discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_call_history IS 'Keep the call history';


--
-- Name: COLUMN discuss_call_history.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_call_history.start_call_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_call_message_id IS 'Start Call Message';


--
-- Name: COLUMN discuss_call_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_call_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_call_history.start_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_dt IS 'Start Dt';


--
-- Name: COLUMN discuss_call_history.end_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.end_dt IS 'End Dt';


--
-- Name: COLUMN discuss_call_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_date IS 'Created on';


--
-- Name: COLUMN discuss_call_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON public.discuss_call_history IS 'CHECK (channel_id IS NOT NULL)';


--
-- Name: CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON public.discuss_call_history IS 'CHECK (start_dt IS NOT NULL)';


--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_call_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_call_history_id_seq OWNER TO runbot;

--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_call_history_id_seq OWNED BY public.discuss_call_history.id;


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ai_agent_id integer,
    ai_env_context jsonb,
    CONSTRAINT discuss_channel_ai_channel_type_check CHECK (((ai_agent_id IS NULL) OR ((channel_type)::text = 'ai_chat'::text) OR ((channel_type)::text = 'livechat'::text))),
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: COLUMN discuss_channel.ai_agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_agent_id IS 'Ai Agent';


--
-- Name: COLUMN discuss_channel.ai_env_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_env_context IS 'Context for AI agent';


--
-- Name: CONSTRAINT discuss_channel_ai_channel_type_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_ai_channel_type_check ON public.discuss_channel IS 'CHECK(ai_agent_id IS NULL or channel_type = ''ai_chat'' or channel_type = ''livechat'')';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: discuss_channel_hr_department_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_hr_department_rel (
    discuss_channel_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_hr_department_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_hr_department_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_hr_department_rel IS 'RELATION BETWEEN discuss_channel AND hr_department';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: employee_bank_account_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.employee_bank_account_rel (
    employee_id integer NOT NULL,
    bank_account_id integer NOT NULL
);


ALTER TABLE public.employee_bank_account_rel OWNER TO runbot;

--
-- Name: TABLE employee_bank_account_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.employee_bank_account_rel IS 'RELATION BETWEEN hr_employee AND res_partner_bank';


--
-- Name: employee_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.employee_category_rel (
    employee_id integer NOT NULL,
    category_id integer NOT NULL
);


ALTER TABLE public.employee_category_rel OWNER TO runbot;

--
-- Name: TABLE employee_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.employee_category_rel IS 'RELATION BETWEEN hr_employee AND hr_employee_category';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    error_message text,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    error_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    microsoft_outlook_access_token_expiration integer,
    microsoft_outlook_refresh_token character varying,
    microsoft_outlook_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_message IS 'Last Error Message';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.error_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_date IS 'Last Error Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token_expiration IS 'Outlook Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_refresh_token IS 'Outlook Refresh Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token IS 'Outlook Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: helpdesk_sla; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla (
    id integer NOT NULL,
    team_id integer NOT NULL,
    stage_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    priority character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "time" double precision NOT NULL
);


ALTER TABLE public.helpdesk_sla OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla IS 'Helpdesk SLA Policies';


--
-- Name: COLUMN helpdesk_sla.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.team_id IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_sla.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.stage_id IS 'Target Stage';


--
-- Name: COLUMN helpdesk_sla.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_sla.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_sla.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_sla.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.priority IS 'Priority';


--
-- Name: COLUMN helpdesk_sla.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.name IS 'Name';


--
-- Name: COLUMN helpdesk_sla.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.description IS 'SLA Policy Description';


--
-- Name: COLUMN helpdesk_sla.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.active IS 'Active';


--
-- Name: COLUMN helpdesk_sla.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_sla.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_sla."time"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla."time" IS 'Within';


--
-- Name: helpdesk_sla_helpdesk_stage_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_helpdesk_stage_rel (
    helpdesk_sla_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_helpdesk_stage_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_helpdesk_stage_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_helpdesk_stage_rel IS 'RELATION BETWEEN helpdesk_sla AND helpdesk_stage';


--
-- Name: helpdesk_sla_helpdesk_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_helpdesk_tag_rel (
    helpdesk_sla_id integer NOT NULL,
    helpdesk_tag_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_helpdesk_tag_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_helpdesk_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_helpdesk_tag_rel IS 'RELATION BETWEEN helpdesk_sla AND helpdesk_tag';


--
-- Name: helpdesk_sla_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_sla_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_sla_id_seq OWNER TO runbot;

--
-- Name: helpdesk_sla_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_sla_id_seq OWNED BY public.helpdesk_sla.id;


--
-- Name: helpdesk_sla_report_analysis; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.helpdesk_sla_report_analysis AS
SELECT
    NULL::integer AS id,
    NULL::integer AS ticket_id,
    NULL::text AS description,
    NULL::character varying AS ticket_ref,
    NULL::character varying AS name,
    NULL::timestamp without time zone AS create_date,
    NULL::integer AS team_id,
    NULL::boolean AS active,
    NULL::integer AS stage_id,
    NULL::integer AS user_id,
    NULL::integer AS partner_id,
    NULL::character varying AS partner_name,
    NULL::character varying AS partner_email,
    NULL::character varying AS partner_phone,
    NULL::integer AS company_id,
    NULL::character varying AS kanban_state,
    NULL::double precision AS rating_last_value,
    NULL::double precision AS rating_avg,
    NULL::character varying AS priority,
    NULL::double precision AS ticket_close_hours,
    NULL::numeric AS ticket_open_hours,
    NULL::double precision AS ticket_assignation_hours,
    NULL::double precision AS avg_response_hours,
    NULL::double precision AS first_response_hours,
    NULL::timestamp without time zone AS close_date,
    NULL::boolean AS ticket_closed,
    NULL::integer AS sla_stage_id,
    NULL::timestamp without time zone AS sla_deadline,
    NULL::integer AS sla_id,
    NULL::double precision AS sla_exceeded_hours,
    NULL::boolean AS sla_fail,
    NULL::integer AS sla_status_failed,
    NULL::text AS sla_status,
    NULL::boolean AS sla_success,
    NULL::integer AS department_id,
    NULL::integer AS manager_id,
    NULL::integer AS employee_id,
    NULL::double precision AS total_hours_spent;


ALTER VIEW public.helpdesk_sla_report_analysis OWNER TO runbot;

--
-- Name: helpdesk_sla_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_res_partner_rel (
    helpdesk_sla_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_res_partner_rel IS 'RELATION BETWEEN helpdesk_sla AND res_partner';


--
-- Name: helpdesk_sla_status; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_status (
    id integer NOT NULL,
    ticket_id integer NOT NULL,
    sla_id integer NOT NULL,
    sla_stage_id integer,
    create_uid integer,
    write_uid integer,
    deadline timestamp without time zone,
    reached_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    exceeded_hours double precision
);


ALTER TABLE public.helpdesk_sla_status OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_status IS 'Ticket SLA Status';


--
-- Name: COLUMN helpdesk_sla_status.ticket_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.ticket_id IS 'Ticket';


--
-- Name: COLUMN helpdesk_sla_status.sla_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.sla_id IS 'Sla';


--
-- Name: COLUMN helpdesk_sla_status.sla_stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.sla_stage_id IS 'Target Stage';


--
-- Name: COLUMN helpdesk_sla_status.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_sla_status.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_sla_status.deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.deadline IS 'Deadline';


--
-- Name: COLUMN helpdesk_sla_status.reached_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.reached_datetime IS 'Reached Date';


--
-- Name: COLUMN helpdesk_sla_status.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_sla_status.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_sla_status.exceeded_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.exceeded_hours IS 'Exceeded Working Hours';


--
-- Name: helpdesk_sla_status_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_sla_status_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_sla_status_id_seq OWNER TO runbot;

--
-- Name: helpdesk_sla_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_sla_status_id_seq OWNED BY public.helpdesk_sla_status.id;


--
-- Name: helpdesk_stage; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage (
    id integer NOT NULL,
    sequence integer,
    template_id integer,
    rotting_threshold_days integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    legend_blocked jsonb NOT NULL,
    legend_done jsonb NOT NULL,
    legend_normal jsonb NOT NULL,
    active boolean,
    fold boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer
);


ALTER TABLE public.helpdesk_stage OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage IS 'Helpdesk Stage';


--
-- Name: COLUMN helpdesk_stage.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.sequence IS 'Sequence';


--
-- Name: COLUMN helpdesk_stage.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.template_id IS 'Email Template';


--
-- Name: COLUMN helpdesk_stage.rotting_threshold_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.rotting_threshold_days IS 'Days to rot';


--
-- Name: COLUMN helpdesk_stage.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.color IS 'Color';


--
-- Name: COLUMN helpdesk_stage.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_stage.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_stage.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.name IS 'Name';


--
-- Name: COLUMN helpdesk_stage.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.description IS 'Description';


--
-- Name: COLUMN helpdesk_stage.legend_blocked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.legend_blocked IS 'Red Kanban Label';


--
-- Name: COLUMN helpdesk_stage.legend_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.legend_done IS 'Green Kanban Label';


--
-- Name: COLUMN helpdesk_stage.legend_normal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.legend_normal IS 'Grey Kanban Label';


--
-- Name: COLUMN helpdesk_stage.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.active IS 'Active';


--
-- Name: COLUMN helpdesk_stage.fold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.fold IS 'Folded';


--
-- Name: COLUMN helpdesk_stage.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_stage.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_stage.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.sms_template_id IS 'SMS Template';


--
-- Name: helpdesk_stage_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage_delete_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_stage_delete_wizard OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage_delete_wizard IS 'Helpdesk Stage Delete Wizard';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: helpdesk_stage_delete_wizard_helpdesk_team_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel (
    helpdesk_stage_delete_wizard_id integer NOT NULL,
    helpdesk_team_id integer NOT NULL
);


ALTER TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage_delete_wizard_helpdesk_team_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel IS 'RELATION BETWEEN helpdesk_stage_delete_wizard AND helpdesk_team';


--
-- Name: helpdesk_stage_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_stage_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_stage_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: helpdesk_stage_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_stage_delete_wizard_id_seq OWNED BY public.helpdesk_stage_delete_wizard.id;


--
-- Name: helpdesk_stage_helpdesk_stage_delete_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel (
    helpdesk_stage_delete_wizard_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


ALTER TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage_helpdesk_stage_delete_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel IS 'RELATION BETWEEN helpdesk_stage_delete_wizard AND helpdesk_stage';


--
-- Name: helpdesk_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_stage_id_seq OWNER TO runbot;

--
-- Name: helpdesk_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_stage_id_seq OWNED BY public.helpdesk_stage.id;


--
-- Name: helpdesk_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_tag OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag IS 'Helpdesk Tags';


--
-- Name: COLUMN helpdesk_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.color IS 'Color';


--
-- Name: COLUMN helpdesk_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.name IS 'Name';


--
-- Name: COLUMN helpdesk_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.write_date IS 'Last Updated on';


--
-- Name: helpdesk_tag_assignment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag_assignment (
    id integer NOT NULL,
    team_id integer,
    tag_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_tag_assignment OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag_assignment IS 'Helpdesk Tag Assignment';


--
-- Name: COLUMN helpdesk_tag_assignment.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.team_id IS 'Team';


--
-- Name: COLUMN helpdesk_tag_assignment.tag_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.tag_id IS 'Ticket Tag';


--
-- Name: COLUMN helpdesk_tag_assignment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_tag_assignment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_tag_assignment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_tag_assignment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.write_date IS 'Last Updated on';


--
-- Name: helpdesk_tag_assignment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_tag_assignment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_tag_assignment_id_seq OWNER TO runbot;

--
-- Name: helpdesk_tag_assignment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_tag_assignment_id_seq OWNED BY public.helpdesk_tag_assignment.id;


--
-- Name: helpdesk_tag_assignment_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag_assignment_res_users_rel (
    helpdesk_tag_assignment_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.helpdesk_tag_assignment_res_users_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag_assignment_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag_assignment_res_users_rel IS 'RELATION BETWEEN helpdesk_tag_assignment AND res_users';


--
-- Name: helpdesk_tag_helpdesk_ticket_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag_helpdesk_ticket_rel (
    helpdesk_ticket_id integer NOT NULL,
    helpdesk_tag_id integer NOT NULL
);


ALTER TABLE public.helpdesk_tag_helpdesk_ticket_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag_helpdesk_ticket_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag_helpdesk_ticket_rel IS 'RELATION BETWEEN helpdesk_ticket AND helpdesk_tag';


--
-- Name: helpdesk_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_tag_id_seq OWNER TO runbot;

--
-- Name: helpdesk_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_tag_id_seq OWNED BY public.helpdesk_tag.id;


--
-- Name: helpdesk_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_team (
    id integer NOT NULL,
    alias_id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer,
    color integer,
    resource_calendar_id integer,
    auto_close_day integer,
    to_stage_id integer,
    create_uid integer,
    write_uid integer,
    assign_method character varying NOT NULL,
    privacy_visibility character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    ticket_properties jsonb,
    active boolean,
    auto_assignment boolean,
    use_alias boolean,
    allow_portal_ticket_closing boolean,
    use_website_helpdesk_form boolean,
    use_website_helpdesk_livechat boolean,
    use_website_helpdesk_forum boolean,
    use_website_helpdesk_slides boolean,
    use_website_helpdesk_knowledge boolean,
    use_helpdesk_timesheet boolean,
    use_helpdesk_sale_timesheet boolean,
    use_credit_notes boolean,
    use_coupons boolean,
    use_giftcards boolean,
    use_fsm boolean,
    use_product_returns boolean,
    use_product_replacements boolean,
    use_product_repairs boolean,
    use_twitter boolean,
    use_rating boolean,
    use_sla boolean,
    auto_close_ticket boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    project_id integer,
    user_id integer
);


ALTER TABLE public.helpdesk_team OWNER TO runbot;

--
-- Name: TABLE helpdesk_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_team IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_team.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.alias_id IS 'Alias';


--
-- Name: COLUMN helpdesk_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.sequence IS 'Sequence';


--
-- Name: COLUMN helpdesk_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_team.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN helpdesk_team.auto_close_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.auto_close_day IS 'Inactive Period(days)';


--
-- Name: COLUMN helpdesk_team.to_stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.to_stage_id IS 'Move to Stage';


--
-- Name: COLUMN helpdesk_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_team.assign_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.assign_method IS 'Assignment Method';


--
-- Name: COLUMN helpdesk_team.privacy_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.privacy_visibility IS 'Visibility';


--
-- Name: COLUMN helpdesk_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.name IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_team.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.description IS 'About Team';


--
-- Name: COLUMN helpdesk_team.ticket_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.ticket_properties IS 'Ticket Properties';


--
-- Name: COLUMN helpdesk_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.active IS 'Active';


--
-- Name: COLUMN helpdesk_team.auto_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.auto_assignment IS 'Automatic Assignment';


--
-- Name: COLUMN helpdesk_team.use_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_alias IS 'Use Alias';


--
-- Name: COLUMN helpdesk_team.allow_portal_ticket_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.allow_portal_ticket_closing IS 'Closure by Customers';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_form IS 'Website Form';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_livechat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_livechat IS 'Live Chat';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_forum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_forum IS 'Community Forum';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_slides; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_slides IS 'eLearning';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_knowledge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_knowledge IS 'Knowledge';


--
-- Name: COLUMN helpdesk_team.use_helpdesk_timesheet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_helpdesk_timesheet IS 'Timesheets';


--
-- Name: COLUMN helpdesk_team.use_helpdesk_sale_timesheet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_helpdesk_sale_timesheet IS 'Time Billing';


--
-- Name: COLUMN helpdesk_team.use_credit_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_credit_notes IS 'Refunds';


--
-- Name: COLUMN helpdesk_team.use_coupons; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_coupons IS 'Coupons';


--
-- Name: COLUMN helpdesk_team.use_giftcards; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_giftcards IS 'Gift Cards';


--
-- Name: COLUMN helpdesk_team.use_fsm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_fsm IS 'Field Service';


--
-- Name: COLUMN helpdesk_team.use_product_returns; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_product_returns IS 'Returns';


--
-- Name: COLUMN helpdesk_team.use_product_replacements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_product_replacements IS 'Replacements';


--
-- Name: COLUMN helpdesk_team.use_product_repairs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_product_repairs IS 'Repairs';


--
-- Name: COLUMN helpdesk_team.use_twitter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_twitter IS 'X';


--
-- Name: COLUMN helpdesk_team.use_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_rating IS 'Customer Ratings';


--
-- Name: COLUMN helpdesk_team.use_sla; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_sla IS 'SLA Policies';


--
-- Name: COLUMN helpdesk_team.auto_close_ticket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.auto_close_ticket IS 'Automatic Closing';


--
-- Name: COLUMN helpdesk_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_team.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.project_id IS 'Project';


--
-- Name: COLUMN helpdesk_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.user_id IS 'Specific user';


--
-- Name: helpdesk_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_team_id_seq OWNER TO runbot;

--
-- Name: helpdesk_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_team_id_seq OWNED BY public.helpdesk_team.id;


--
-- Name: helpdesk_team_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_team_res_users_rel (
    helpdesk_team_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.helpdesk_team_res_users_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_team_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_team_res_users_rel IS 'RELATION BETWEEN helpdesk_team AND res_users';


--
-- Name: helpdesk_ticket; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_ticket (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    company_id integer,
    color integer,
    user_id integer,
    partner_id integer,
    stage_id integer,
    answered_customer_message_count integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    access_token character varying,
    name character varying NOT NULL,
    kanban_state character varying NOT NULL,
    partner_name character varying,
    partner_email character varying,
    partner_phone character varying,
    priority character varying,
    ticket_ref character varying,
    properties jsonb,
    description text,
    active boolean,
    closed_by_partner boolean,
    sla_reached_late boolean,
    sla_reached boolean,
    date_last_stage_update timestamp without time zone,
    assign_date timestamp without time zone,
    close_date timestamp without time zone,
    sla_deadline timestamp without time zone,
    oldest_unanswered_customer_message_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rating_last_value double precision,
    assign_hours double precision,
    close_hours double precision,
    sla_deadline_hours double precision,
    first_response_hours double precision,
    avg_response_hours double precision,
    total_response_hours double precision,
    project_id integer,
    analytic_account_id integer,
    total_hours_spent double precision
);


ALTER TABLE public.helpdesk_ticket OWNER TO runbot;

--
-- Name: TABLE helpdesk_ticket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_ticket IS 'Helpdesk Ticket';


--
-- Name: COLUMN helpdesk_ticket.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.campaign_id IS 'Campaign';


--
-- Name: COLUMN helpdesk_ticket.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.source_id IS 'Source';


--
-- Name: COLUMN helpdesk_ticket.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.medium_id IS 'Medium';


--
-- Name: COLUMN helpdesk_ticket.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.team_id IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_ticket.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_ticket.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_ticket.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.user_id IS 'Assigned to';


--
-- Name: COLUMN helpdesk_ticket.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_id IS 'Customer';


--
-- Name: COLUMN helpdesk_ticket.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.stage_id IS 'Stage';


--
-- Name: COLUMN helpdesk_ticket.answered_customer_message_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.answered_customer_message_count IS '# Exchanges';


--
-- Name: COLUMN helpdesk_ticket.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.email_cc IS 'Email cc';


--
-- Name: COLUMN helpdesk_ticket.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.access_token IS 'Security Token';


--
-- Name: COLUMN helpdesk_ticket.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.name IS 'Subject';


--
-- Name: COLUMN helpdesk_ticket.kanban_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.kanban_state IS 'Kanban State';


--
-- Name: COLUMN helpdesk_ticket.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_name IS 'Customer Name';


--
-- Name: COLUMN helpdesk_ticket.partner_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_email IS 'Customer Email';


--
-- Name: COLUMN helpdesk_ticket.partner_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_phone IS 'Customer Phone';


--
-- Name: COLUMN helpdesk_ticket.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.priority IS 'Priority';


--
-- Name: COLUMN helpdesk_ticket.ticket_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.ticket_ref IS 'Ticket IDs Sequence';


--
-- Name: COLUMN helpdesk_ticket.properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.properties IS 'Properties';


--
-- Name: COLUMN helpdesk_ticket.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.description IS 'Description';


--
-- Name: COLUMN helpdesk_ticket.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.active IS 'Active';


--
-- Name: COLUMN helpdesk_ticket.closed_by_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.closed_by_partner IS 'Closed by Partner';


--
-- Name: COLUMN helpdesk_ticket.sla_reached_late; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_reached_late IS 'Has SLA reached late';


--
-- Name: COLUMN helpdesk_ticket.sla_reached; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_reached IS 'Has SLA reached';


--
-- Name: COLUMN helpdesk_ticket.date_last_stage_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN helpdesk_ticket.assign_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.assign_date IS 'First assignment date';


--
-- Name: COLUMN helpdesk_ticket.close_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.close_date IS 'Close date';


--
-- Name: COLUMN helpdesk_ticket.sla_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_deadline IS 'SLA Deadline';


--
-- Name: COLUMN helpdesk_ticket.oldest_unanswered_customer_message_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.oldest_unanswered_customer_message_date IS 'Oldest Unanswered Customer Message Date';


--
-- Name: COLUMN helpdesk_ticket.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_ticket.rating_last_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.rating_last_value IS 'Rating Last Value';


--
-- Name: COLUMN helpdesk_ticket.assign_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.assign_hours IS 'Time to first assignment (hours)';


--
-- Name: COLUMN helpdesk_ticket.close_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.close_hours IS 'Time to close (hours)';


--
-- Name: COLUMN helpdesk_ticket.sla_deadline_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_deadline_hours IS 'Working Hours until SLA Deadline';


--
-- Name: COLUMN helpdesk_ticket.first_response_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.first_response_hours IS 'Hours to First Response';


--
-- Name: COLUMN helpdesk_ticket.avg_response_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.avg_response_hours IS 'Average Hours to Respond';


--
-- Name: COLUMN helpdesk_ticket.total_response_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.total_response_hours IS 'Total Exchange Time in Hours';


--
-- Name: COLUMN helpdesk_ticket.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.project_id IS 'Project';


--
-- Name: COLUMN helpdesk_ticket.analytic_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN helpdesk_ticket.total_hours_spent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.total_hours_spent IS 'Time Spent';


--
-- Name: helpdesk_ticket_convert_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_ticket_convert_wizard (
    id integer NOT NULL,
    project_id integer,
    stage_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_ticket_convert_wizard OWNER TO runbot;

--
-- Name: TABLE helpdesk_ticket_convert_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_ticket_convert_wizard IS 'Convert Helpdesk Tickets to Tasks';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.project_id IS 'Project';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.stage_id IS 'Stage';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.write_date IS 'Last Updated on';


--
-- Name: helpdesk_ticket_convert_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_ticket_convert_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_ticket_convert_wizard_id_seq OWNER TO runbot;

--
-- Name: helpdesk_ticket_convert_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_ticket_convert_wizard_id_seq OWNED BY public.helpdesk_ticket_convert_wizard.id;


--
-- Name: helpdesk_ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_ticket_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_ticket_id_seq OWNER TO runbot;

--
-- Name: helpdesk_ticket_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_ticket_id_seq OWNED BY public.helpdesk_ticket.id;


--
-- Name: helpdesk_ticket_report_analysis; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.helpdesk_ticket_report_analysis AS
SELECT
    NULL::integer AS id,
    NULL::integer AS ticket_id,
    NULL::text AS description,
    NULL::character varying AS ticket_ref,
    NULL::character varying AS name,
    NULL::timestamp without time zone AS create_date,
    NULL::character varying AS priority,
    NULL::integer AS user_id,
    NULL::integer AS partner_id,
    NULL::character varying AS partner_name,
    NULL::character varying AS partner_email,
    NULL::character varying AS partner_phone,
    NULL::integer AS stage_id,
    NULL::timestamp without time zone AS sla_deadline,
    NULL::double precision AS ticket_deadline_hours,
    NULL::double precision AS ticket_close_hours,
    NULL::numeric AS ticket_open_hours,
    NULL::double precision AS ticket_assignation_hours,
    NULL::timestamp without time zone AS close_date,
    NULL::timestamp without time zone AS assign_date,
    NULL::double precision AS rating_last_value,
    NULL::double precision AS rating_avg,
    NULL::boolean AS active,
    NULL::integer AS team_id,
    NULL::integer AS company_id,
    NULL::character varying AS kanban_state,
    NULL::double precision AS first_response_hours,
    NULL::double precision AS avg_response_hours,
    NULL::boolean AS sla_success,
    NULL::double precision AS total_hours_spent,
    NULL::integer AS employee_parent_id,
    NULL::integer AS department_id,
    NULL::integer AS employee_id;


ALTER VIEW public.helpdesk_ticket_report_analysis OWNER TO runbot;

--
-- Name: hr_bank_account_allocation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_bank_account_allocation_wizard (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_bank_account_allocation_wizard OWNER TO runbot;

--
-- Name: TABLE hr_bank_account_allocation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_bank_account_allocation_wizard IS 'Bank Account Allocation Wizard';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.employee_id IS 'Employee';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_bank_account_allocation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_bank_account_allocation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_bank_account_allocation_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_bank_account_allocation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_bank_account_allocation_wizard_id_seq OWNED BY public.hr_bank_account_allocation_wizard.id;


--
-- Name: hr_bank_account_allocation_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_bank_account_allocation_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    bank_account_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying,
    amount numeric,
    trusted boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_bank_account_allocation_wizard_line OWNER TO runbot;

--
-- Name: TABLE hr_bank_account_allocation_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_bank_account_allocation_wizard_line IS 'Bank Account Allocation Line (Wizard)';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.amount IS 'Amount';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.trusted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.trusted IS 'Trusted';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.write_date IS 'Last Updated on';


--
-- Name: hr_bank_account_allocation_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_bank_account_allocation_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_bank_account_allocation_wizard_line_id_seq OWNER TO runbot;

--
-- Name: hr_bank_account_allocation_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_bank_account_allocation_wizard_line_id_seq OWNED BY public.hr_bank_account_allocation_wizard_line.id;


--
-- Name: hr_contract_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_contract_type (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_contract_type OWNER TO runbot;

--
-- Name: TABLE hr_contract_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_contract_type IS 'Contract Type';


--
-- Name: COLUMN hr_contract_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_contract_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.country_id IS 'Country';


--
-- Name: COLUMN hr_contract_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_contract_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_contract_type.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.code IS 'Code';


--
-- Name: COLUMN hr_contract_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.name IS 'Name';


--
-- Name: COLUMN hr_contract_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_contract_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_date IS 'Last Updated on';


--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_contract_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_contract_type_id_seq OWNER TO runbot;

--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_contract_type_id_seq OWNED BY public.hr_contract_type.id;


--
-- Name: hr_department; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_department (
    id integer NOT NULL,
    company_id integer,
    parent_id integer,
    manager_id integer,
    color integer,
    master_department_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    note text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_department OWNER TO runbot;

--
-- Name: TABLE hr_department; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_department IS 'Department';


--
-- Name: COLUMN hr_department.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.company_id IS 'Company';


--
-- Name: COLUMN hr_department.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_id IS 'Parent Department';


--
-- Name: COLUMN hr_department.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.manager_id IS 'Manager';


--
-- Name: COLUMN hr_department.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.color IS 'Color Index';


--
-- Name: COLUMN hr_department.master_department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.master_department_id IS 'Master Department';


--
-- Name: COLUMN hr_department.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_uid IS 'Created by';


--
-- Name: COLUMN hr_department.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_department.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_path IS 'Parent Path';


--
-- Name: COLUMN hr_department.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.name IS 'Department Name';


--
-- Name: COLUMN hr_department.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.note IS 'Note';


--
-- Name: COLUMN hr_department.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.active IS 'Active';


--
-- Name: COLUMN hr_department.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_date IS 'Created on';


--
-- Name: COLUMN hr_department.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_date IS 'Last Updated on';


--
-- Name: hr_department_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_department_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_department_id_seq OWNER TO runbot;

--
-- Name: hr_department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_department_id_seq OWNED BY public.hr_department.id;


--
-- Name: hr_departure_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_reason (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_reason OWNER TO runbot;

--
-- Name: TABLE hr_departure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_reason IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_reason.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.sequence IS 'Sequence';


--
-- Name: COLUMN hr_departure_reason.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.country_id IS 'Country';


--
-- Name: COLUMN hr_departure_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_reason.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.name IS 'Reason';


--
-- Name: COLUMN hr_departure_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_date IS 'Last Updated on';


--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_reason_id_seq OWNER TO runbot;

--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_reason_id_seq OWNED BY public.hr_departure_reason.id;


--
-- Name: hr_departure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_wizard (
    id integer NOT NULL,
    departure_reason_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    departure_date date NOT NULL,
    departure_description text,
    remove_related_user boolean,
    set_date_end boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_wizard OWNER TO runbot;

--
-- Name: TABLE hr_departure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_wizard IS 'Departure Wizard';


--
-- Name: COLUMN hr_departure_wizard.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_wizard.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_date IS 'Contract End Date';


--
-- Name: COLUMN hr_departure_wizard.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_departure_wizard.remove_related_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.remove_related_user IS 'Related User';


--
-- Name: COLUMN hr_departure_wizard.set_date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.set_date_end IS 'Set Contract End Date';


--
-- Name: COLUMN hr_departure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_departure_wizard_hr_employee_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_wizard_hr_employee_rel (
    hr_departure_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_departure_wizard_hr_employee_rel OWNER TO runbot;

--
-- Name: TABLE hr_departure_wizard_hr_employee_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_wizard_hr_employee_rel IS 'RELATION BETWEEN hr_departure_wizard AND hr_employee';


--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNED BY public.hr_departure_wizard.id;


--
-- Name: hr_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer NOT NULL,
    message_main_attachment_id integer,
    current_version_id integer,
    user_id integer,
    work_contact_id integer,
    country_of_birth integer,
    parent_id integer,
    coach_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    work_phone character varying,
    mobile_phone character varying,
    work_email character varying,
    legal_name character varying,
    private_phone character varying,
    private_email character varying,
    lang character varying,
    place_of_birth character varying,
    permit_no character varying,
    visa_no character varying,
    certificate character varying,
    study_field character varying,
    study_school character varying,
    emergency_contact character varying,
    emergency_phone character varying,
    barcode character varying,
    pin character varying,
    private_car_plate character varying,
    birthday date,
    visa_expire date,
    work_permit_expiration_date date,
    salary_distribution jsonb,
    employee_properties jsonb,
    active boolean,
    birthday_public_display boolean,
    work_permit_scheduled_activity boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    monday_location_id integer,
    tuesday_location_id integer,
    wednesday_location_id integer,
    thursday_location_id integer,
    friday_location_id integer,
    saturday_location_id integer,
    sunday_location_id integer,
    today_location_name character varying,
    hourly_cost numeric,
    timesheet_manager_id integer,
    last_validated_timesheet_date date
);


ALTER TABLE public.hr_employee OWNER TO runbot;

--
-- Name: TABLE hr_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee IS 'Employee';


--
-- Name: COLUMN hr_employee.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.resource_id IS 'Resource';


--
-- Name: COLUMN hr_employee.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.company_id IS 'Company';


--
-- Name: COLUMN hr_employee.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_employee.current_version_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.current_version_id IS 'Current Version';


--
-- Name: COLUMN hr_employee.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.user_id IS 'User';


--
-- Name: COLUMN hr_employee.work_contact_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_contact_id IS 'Work Contact';


--
-- Name: COLUMN hr_employee.country_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.country_of_birth IS 'Country of Birth';


--
-- Name: COLUMN hr_employee.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.parent_id IS 'Manager';


--
-- Name: COLUMN hr_employee.coach_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.coach_id IS 'Coach';


--
-- Name: COLUMN hr_employee.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.color IS 'Color Index';


--
-- Name: COLUMN hr_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.name IS 'Employee Name';


--
-- Name: COLUMN hr_employee.work_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_phone IS 'Work Phone';


--
-- Name: COLUMN hr_employee.mobile_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.mobile_phone IS 'Work Mobile';


--
-- Name: COLUMN hr_employee.work_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_email IS 'Work Email';


--
-- Name: COLUMN hr_employee.legal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.legal_name IS 'Legal Name';


--
-- Name: COLUMN hr_employee.private_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_phone IS 'Private Phone';


--
-- Name: COLUMN hr_employee.private_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_email IS 'Private Email';


--
-- Name: COLUMN hr_employee.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.lang IS 'Lang';


--
-- Name: COLUMN hr_employee.place_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.place_of_birth IS 'Place of Birth';


--
-- Name: COLUMN hr_employee.permit_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.permit_no IS 'Work Permit No';


--
-- Name: COLUMN hr_employee.visa_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_no IS 'Visa No';


--
-- Name: COLUMN hr_employee.certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate IS 'Certificate Level';


--
-- Name: COLUMN hr_employee.study_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_field IS 'Field of Study';


--
-- Name: COLUMN hr_employee.study_school; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_school IS 'School';


--
-- Name: COLUMN hr_employee.emergency_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_contact IS 'Emergency Contact';


--
-- Name: COLUMN hr_employee.emergency_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_phone IS 'Emergency Phone';


--
-- Name: COLUMN hr_employee.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.barcode IS 'Badge ID';


--
-- Name: COLUMN hr_employee.pin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.pin IS 'PIN';


--
-- Name: COLUMN hr_employee.private_car_plate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_car_plate IS 'Private Car Plate';


--
-- Name: COLUMN hr_employee.birthday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.birthday IS 'Birthday';


--
-- Name: COLUMN hr_employee.visa_expire; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_expire IS 'Visa Expiration Date';


--
-- Name: COLUMN hr_employee.work_permit_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_expiration_date IS 'Work Permit Expiration Date';


--
-- Name: COLUMN hr_employee.salary_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.salary_distribution IS 'Salary Distribution';


--
-- Name: COLUMN hr_employee.employee_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.employee_properties IS 'Properties';


--
-- Name: COLUMN hr_employee.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.active IS 'Active';


--
-- Name: COLUMN hr_employee.birthday_public_display; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.birthday_public_display IS 'Show to all employees';


--
-- Name: COLUMN hr_employee.work_permit_scheduled_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_scheduled_activity IS 'Work Permit Scheduled Activity';


--
-- Name: COLUMN hr_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_employee.monday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.monday_location_id IS 'Monday';


--
-- Name: COLUMN hr_employee.tuesday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.tuesday_location_id IS 'Tuesday';


--
-- Name: COLUMN hr_employee.wednesday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.wednesday_location_id IS 'Wednesday';


--
-- Name: COLUMN hr_employee.thursday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.thursday_location_id IS 'Thursday';


--
-- Name: COLUMN hr_employee.friday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.friday_location_id IS 'Friday';


--
-- Name: COLUMN hr_employee.saturday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.saturday_location_id IS 'Saturday';


--
-- Name: COLUMN hr_employee.sunday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.sunday_location_id IS 'Sunday';


--
-- Name: COLUMN hr_employee.today_location_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.today_location_name IS 'Today Location Name';


--
-- Name: COLUMN hr_employee.hourly_cost; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.hourly_cost IS 'Hourly Cost';


--
-- Name: COLUMN hr_employee.timesheet_manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.timesheet_manager_id IS 'Timesheet Approver';


--
-- Name: COLUMN hr_employee.last_validated_timesheet_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.last_validated_timesheet_date IS 'Last Validated Timesheet Date';


--
-- Name: hr_employee_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_category (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_category OWNER TO runbot;

--
-- Name: TABLE hr_employee_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_category IS 'Employee Category';


--
-- Name: COLUMN hr_employee_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.color IS 'Color Index';


--
-- Name: COLUMN hr_employee_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.name IS 'Tag Name';


--
-- Name: COLUMN hr_employee_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_date IS 'Last Updated on';


--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_category_id_seq OWNER TO runbot;

--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_category_id_seq OWNED BY public.hr_employee_category.id;


--
-- Name: hr_employee_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_skill (
    id integer NOT NULL,
    skill_id integer NOT NULL,
    skill_level_id integer NOT NULL,
    skill_type_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    valid_from date,
    valid_to date,
    display_warning_message boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_skill OWNER TO runbot;

--
-- Name: TABLE hr_employee_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_skill IS 'Skill level for employee';


--
-- Name: COLUMN hr_employee_skill.skill_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_id IS 'Skill';


--
-- Name: COLUMN hr_employee_skill.skill_level_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_level_id IS 'Skill Level';


--
-- Name: COLUMN hr_employee_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_employee_skill.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_skill.valid_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.valid_from IS 'Validity Start';


--
-- Name: COLUMN hr_employee_skill.valid_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.valid_to IS 'Validity Stop';


--
-- Name: COLUMN hr_employee_skill.display_warning_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.display_warning_message IS 'Display Warning Message';


--
-- Name: COLUMN hr_employee_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_date IS 'Last Updated on';


--
-- Name: hr_skill_level; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_level (
    id integer NOT NULL,
    skill_type_id integer,
    level_progress integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    default_level boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_skill_level_check_level_progress CHECK (((level_progress >= 0) AND (level_progress <= 100)))
);


ALTER TABLE public.hr_skill_level OWNER TO runbot;

--
-- Name: TABLE hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_level IS 'Skill Level';


--
-- Name: COLUMN hr_skill_level.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_skill_level.level_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.level_progress IS 'Progress';


--
-- Name: COLUMN hr_skill_level.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_level.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_level.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.name IS 'Name';


--
-- Name: COLUMN hr_skill_level.default_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.default_level IS 'Default Level';


--
-- Name: COLUMN hr_skill_level.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_level.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_skill_level_check_level_progress ON hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_skill_level_check_level_progress ON public.hr_skill_level IS 'CHECK(level_progress BETWEEN 0 AND 100)';


--
-- Name: hr_skill_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_type (
    id integer NOT NULL,
    sequence integer,
    color integer,
    levels_count integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    is_certification boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_skill_type OWNER TO runbot;

--
-- Name: TABLE hr_skill_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_type IS 'Skill Type';


--
-- Name: COLUMN hr_skill_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_skill_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.color IS 'Color';


--
-- Name: COLUMN hr_skill_type.levels_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.levels_count IS 'Levels Count';


--
-- Name: COLUMN hr_skill_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.name IS 'Name';


--
-- Name: COLUMN hr_skill_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.active IS 'Active';


--
-- Name: COLUMN hr_skill_type.is_certification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.is_certification IS 'Certification';


--
-- Name: COLUMN hr_skill_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_date IS 'Last Updated on';


--
-- Name: hr_version; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_version (
    id integer NOT NULL,
    company_id integer,
    employee_id integer,
    last_modified_uid integer NOT NULL,
    country_id integer,
    private_state_id integer,
    private_country_id integer,
    distance_home_work integer,
    km_home_work integer,
    children integer,
    department_id integer,
    job_id integer,
    address_id integer,
    work_location_id integer,
    departure_reason_id integer,
    resource_calendar_id integer,
    contract_template_id integer,
    structure_type_id integer,
    contract_type_id integer,
    hr_responsible_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    identification_id character varying,
    ssnid character varying,
    passport_id character varying,
    sex character varying,
    private_street character varying,
    private_street2 character varying,
    private_city character varying,
    private_zip character varying,
    distance_home_work_unit character varying NOT NULL,
    marital character varying NOT NULL,
    spouse_complete_name character varying,
    employee_type character varying NOT NULL,
    job_title character varying,
    date_version date NOT NULL,
    passport_expiration_date date,
    spouse_birthdate date,
    departure_date date,
    contract_date_start date,
    contract_date_end date,
    trial_date_end date,
    departure_description text,
    additional_note text,
    wage numeric,
    active boolean,
    is_custom_job_title boolean,
    is_flexible boolean,
    is_fully_flexible boolean,
    last_modified_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_version_check_contract_start_date_defined CHECK (((contract_date_end IS NULL) OR (contract_date_start IS NOT NULL)))
);


ALTER TABLE public.hr_version OWNER TO runbot;

--
-- Name: TABLE hr_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_version IS 'Version';


--
-- Name: COLUMN hr_version.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.company_id IS 'Company';


--
-- Name: COLUMN hr_version.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.employee_id IS 'Employee';


--
-- Name: COLUMN hr_version.last_modified_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.last_modified_uid IS 'Last Modified by';


--
-- Name: COLUMN hr_version.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.country_id IS 'Nationality (Country)';


--
-- Name: COLUMN hr_version.private_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_state_id IS 'Private State';


--
-- Name: COLUMN hr_version.private_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_country_id IS 'Private Country';


--
-- Name: COLUMN hr_version.distance_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.distance_home_work IS 'Home-Work Distance';


--
-- Name: COLUMN hr_version.km_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.km_home_work IS 'Home-Work Distance in Km';


--
-- Name: COLUMN hr_version.children; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.children IS 'Dependent Children';


--
-- Name: COLUMN hr_version.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.department_id IS 'Department';


--
-- Name: COLUMN hr_version.job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.job_id IS 'Job';


--
-- Name: COLUMN hr_version.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.address_id IS 'Work Address';


--
-- Name: COLUMN hr_version.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.work_location_id IS 'Work Location';


--
-- Name: COLUMN hr_version.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_version.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_version.contract_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_template_id IS 'Contract Template';


--
-- Name: COLUMN hr_version.structure_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.structure_type_id IS 'Salary Structure Type';


--
-- Name: COLUMN hr_version.contract_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_type_id IS 'Contract Type';


--
-- Name: COLUMN hr_version.hr_responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.hr_responsible_id IS 'HR Responsible';


--
-- Name: COLUMN hr_version.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.create_uid IS 'Created by';


--
-- Name: COLUMN hr_version.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_version.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.name IS 'Name';


--
-- Name: COLUMN hr_version.identification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.identification_id IS 'Identification No';


--
-- Name: COLUMN hr_version.ssnid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.ssnid IS 'SSN No';


--
-- Name: COLUMN hr_version.passport_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.passport_id IS 'Passport No';


--
-- Name: COLUMN hr_version.sex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.sex IS 'Gender';


--
-- Name: COLUMN hr_version.private_street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_street IS 'Private Street';


--
-- Name: COLUMN hr_version.private_street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_street2 IS 'Private Street2';


--
-- Name: COLUMN hr_version.private_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_city IS 'Private City';


--
-- Name: COLUMN hr_version.private_zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_zip IS 'Private Zip';


--
-- Name: COLUMN hr_version.distance_home_work_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.distance_home_work_unit IS 'Home-Work Distance unit';


--
-- Name: COLUMN hr_version.marital; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.marital IS 'Marital Status';


--
-- Name: COLUMN hr_version.spouse_complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.spouse_complete_name IS 'Spouse Legal Name';


--
-- Name: COLUMN hr_version.employee_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.employee_type IS 'Employee Type';


--
-- Name: COLUMN hr_version.job_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.job_title IS 'Job Title';


--
-- Name: COLUMN hr_version.date_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.date_version IS 'Date Version';


--
-- Name: COLUMN hr_version.passport_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.passport_expiration_date IS 'Passport Expiration Date';


--
-- Name: COLUMN hr_version.spouse_birthdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.spouse_birthdate IS 'Spouse Birthdate';


--
-- Name: COLUMN hr_version.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.departure_date IS 'Departure Date';


--
-- Name: COLUMN hr_version.contract_date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_date_start IS 'Contract Start Date';


--
-- Name: COLUMN hr_version.contract_date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_date_end IS 'Contract End Date';


--
-- Name: COLUMN hr_version.trial_date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.trial_date_end IS 'End of Trial Period';


--
-- Name: COLUMN hr_version.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_version.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.additional_note IS 'Additional Note';


--
-- Name: COLUMN hr_version.wage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.wage IS 'Wage';


--
-- Name: COLUMN hr_version.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.active IS 'Active';


--
-- Name: COLUMN hr_version.is_custom_job_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.is_custom_job_title IS 'Is Custom Job Title';


--
-- Name: COLUMN hr_version.is_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.is_flexible IS 'Is Flexible';


--
-- Name: COLUMN hr_version.is_fully_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.is_fully_flexible IS 'Is Fully Flexible';


--
-- Name: COLUMN hr_version.last_modified_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.last_modified_date IS 'Last Modified on';


--
-- Name: COLUMN hr_version.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.create_date IS 'Created on';


--
-- Name: COLUMN hr_version.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_version_check_contract_start_date_defined ON hr_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_version_check_contract_start_date_defined ON public.hr_version IS 'CHECK(contract_date_end IS NULL OR contract_date_start IS NOT NULL)';


--
-- Name: hr_employee_certification_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_certification_report AS
 SELECT row_number() OVER () AS id,
    e.id AS employee_id,
    e.company_id,
    v.department_id,
    s.skill_id,
    s.skill_type_id,
    ((sl.level_progress)::numeric / 100.0) AS level_progress,
    sl.name AS skill_level,
    (((s.valid_to IS NULL) OR (s.valid_to >= '2025-12-18'::date)) AND (s.valid_from <= '2025-12-18'::date)) AS active
   FROM ((((public.hr_employee e
     LEFT JOIN public.hr_version v ON ((e.current_version_id = v.id)))
     LEFT JOIN public.hr_employee_skill s ON ((e.id = s.employee_id)))
     LEFT JOIN public.hr_skill_level sl ON ((sl.id = s.skill_level_id)))
     LEFT JOIN public.hr_skill_type st ON ((st.id = sl.skill_type_id)))
  WHERE (e.active AND (st.active IS TRUE) AND (st.is_certification IS TRUE));


ALTER VIEW public.hr_employee_certification_report OWNER TO runbot;

--
-- Name: hr_employee_cv_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_cv_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    color_primary character varying NOT NULL,
    color_secondary character varying NOT NULL,
    show_skills boolean,
    show_contact boolean,
    show_others boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_cv_wizard OWNER TO runbot;

--
-- Name: TABLE hr_employee_cv_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_cv_wizard IS 'Print Resume';


--
-- Name: COLUMN hr_employee_cv_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_cv_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_cv_wizard.color_primary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_primary IS 'Primary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.color_secondary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_secondary IS 'Secondary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.show_skills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_skills IS 'Skills';


--
-- Name: COLUMN hr_employee_cv_wizard.show_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_contact IS 'Contact Information';


--
-- Name: COLUMN hr_employee_cv_wizard.show_others; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_others IS 'Others';


--
-- Name: COLUMN hr_employee_cv_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_cv_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_cv_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNED BY public.hr_employee_cv_wizard.id;


--
-- Name: hr_employee_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_delete_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_delete_wizard OWNER TO runbot;

--
-- Name: TABLE hr_employee_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_delete_wizard IS 'Employee Delete Wizard';


--
-- Name: COLUMN hr_employee_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_employee_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_employee_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_delete_wizard_id_seq OWNED BY public.hr_employee_delete_wizard.id;


--
-- Name: hr_employee_hr_employee_cv_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_employee_cv_wizard_rel (
    hr_employee_cv_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_employee_cv_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_employee_cv_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_employee_cv_wizard_rel IS 'RELATION BETWEEN hr_employee_cv_wizard AND hr_employee';


--
-- Name: hr_employee_hr_employee_delete_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_employee_delete_wizard_rel (
    hr_employee_delete_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_employee_delete_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_employee_delete_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_employee_delete_wizard_rel IS 'RELATION BETWEEN hr_employee_delete_wizard AND hr_employee';


--
-- Name: hr_employee_hr_skill_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_skill_rel (
    hr_employee_id integer NOT NULL,
    hr_skill_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_skill_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_skill_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_skill_rel IS 'RELATION BETWEEN hr_employee AND hr_skill';


--
-- Name: hr_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_id_seq OWNER TO runbot;

--
-- Name: hr_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_id_seq OWNED BY public.hr_employee.id;


--
-- Name: hr_employee_location; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_location (
    id integer NOT NULL,
    work_location_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_location OWNER TO runbot;

--
-- Name: TABLE hr_employee_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_location IS 'Employee Location';


--
-- Name: COLUMN hr_employee_location.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.work_location_id IS 'Location';


--
-- Name: COLUMN hr_employee_location.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_location.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_location.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_location.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.date IS 'Date';


--
-- Name: COLUMN hr_employee_location.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_location.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.write_date IS 'Last Updated on';


--
-- Name: hr_employee_location_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_location_id_seq OWNER TO runbot;

--
-- Name: hr_employee_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_location_id_seq OWNED BY public.hr_employee_location.id;


--
-- Name: hr_employee_public; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_public AS
 SELECT e.id,
    e.id AS employee_id,
    e.name,
    e.active,
    v.create_date,
    v.department_id,
    v.job_id,
    v.company_id,
    v.address_id,
    e.mobile_phone,
    e.work_phone,
    e.work_email,
    e.work_contact_id,
    v.work_location_id,
    e.user_id,
    e.resource_id,
    e.color,
    v.resource_calendar_id,
    e.parent_id,
    e.coach_id,
    v.create_uid,
    v.write_uid,
    v.write_date,
    e.monday_location_id,
    e.tuesday_location_id,
    e.wednesday_location_id,
    e.thursday_location_id,
    e.friday_location_id,
    e.saturday_location_id,
    e.sunday_location_id,
    e.today_location_name,
    e.timesheet_manager_id
   FROM (public.hr_employee e
     JOIN public.hr_version v ON ((v.id = e.current_version_id)));


ALTER VIEW public.hr_employee_public OWNER TO runbot;

--
-- Name: hr_employee_skill_history_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_skill_history_report AS
 WITH individual_skill AS (
         SELECT hr_employee_skill.valid_from,
            hr_employee_skill.valid_to,
            hr_employee_skill.employee_id,
            hr_employee_skill.skill_id
           FROM public.hr_employee_skill
          ORDER BY hr_employee_skill.employee_id, hr_employee_skill.skill_id, hr_employee_skill.valid_from
        ), date_table AS (
         SELECT date_table_1.date,
            date_table_1.employee_id
           FROM ( SELECT start.valid_from AS date,
                    start.employee_id
                   FROM individual_skill start
                UNION
                 SELECT stop.valid_to AS date,
                    stop.employee_id
                   FROM individual_skill stop
                  WHERE (stop.valid_to IS NOT NULL)) date_table_1
          ORDER BY date_table_1.date
        )
 SELECT DISTINCT ON (date_table.date, emp_skill_level.employee_id, emp_skill_level.skill_id) date_table.date,
    emp_skill_level.employee_id,
    emp_skill_level.skill_id,
    emp_skill_level.skill_type_id,
    emp_skill_level.level_progress
   FROM (date_table
     CROSS JOIN ( SELECT emp_skill.id,
            emp_skill.skill_id,
            emp_skill.skill_level_id,
            emp_skill.skill_type_id,
            emp_skill.employee_id,
            emp_skill.create_uid,
            emp_skill.write_uid,
            emp_skill.valid_from,
            emp_skill.valid_to,
            emp_skill.display_warning_message,
            emp_skill.create_date,
            emp_skill.write_date,
            level.level_progress
           FROM (public.hr_employee_skill emp_skill
             JOIN public.hr_skill_level level ON ((emp_skill.skill_level_id = level.id)))) emp_skill_level)
  WHERE ((date_table.date >= emp_skill_level.valid_from) AND (date_table.employee_id = emp_skill_level.employee_id) AND ((emp_skill_level.valid_to IS NULL) OR (date_table.date <= emp_skill_level.valid_to)))
  ORDER BY date_table.date, emp_skill_level.employee_id, emp_skill_level.skill_id, emp_skill_level.valid_from DESC;


ALTER VIEW public.hr_employee_skill_history_report OWNER TO runbot;

--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_skill_id_seq OWNER TO runbot;

--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_skill_id_seq OWNED BY public.hr_employee_skill.id;


--
-- Name: hr_employee_skill_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_skill_report AS
 SELECT row_number() OVER () AS id,
    e.id AS employee_id,
    e.company_id,
    v.department_id,
    v.job_id,
    s.skill_id,
    s.skill_type_id,
    ((sl.level_progress)::numeric / 100.0) AS level_progress,
    sl.name AS skill_level
   FROM ((((public.hr_employee e
     LEFT JOIN public.hr_version v ON ((e.current_version_id = v.id)))
     LEFT JOIN public.hr_employee_skill s ON ((e.id = s.employee_id)))
     LEFT JOIN public.hr_skill_level sl ON ((sl.id = s.skill_level_id)))
     LEFT JOIN public.hr_skill_type st ON ((st.id = sl.skill_type_id)))
  WHERE ((st.active IS TRUE) AND (st.is_certification IS NOT TRUE) AND (s.valid_to IS NULL));


ALTER VIEW public.hr_employee_skill_report OWNER TO runbot;

--
-- Name: hr_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job (
    id integer NOT NULL,
    sequence integer,
    no_of_recruitment integer,
    user_id integer,
    department_id integer,
    company_id integer,
    contract_type_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description text,
    requirements text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_job_no_of_recruitment_positive CHECK ((no_of_recruitment >= 0))
);


ALTER TABLE public.hr_job OWNER TO runbot;

--
-- Name: TABLE hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job IS 'Job Position';


--
-- Name: COLUMN hr_job.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.sequence IS 'Sequence';


--
-- Name: COLUMN hr_job.no_of_recruitment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.no_of_recruitment IS 'Target';


--
-- Name: COLUMN hr_job.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.user_id IS 'Recruiter';


--
-- Name: COLUMN hr_job.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.department_id IS 'Department';


--
-- Name: COLUMN hr_job.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.company_id IS 'Company';


--
-- Name: COLUMN hr_job.contract_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.contract_type_id IS 'Employment Type';


--
-- Name: COLUMN hr_job.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_uid IS 'Created by';


--
-- Name: COLUMN hr_job.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_job.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.name IS 'Job Position';


--
-- Name: COLUMN hr_job.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.description IS 'Job Description';


--
-- Name: COLUMN hr_job.requirements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.requirements IS 'Requirements';


--
-- Name: COLUMN hr_job.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.active IS 'Active';


--
-- Name: COLUMN hr_job.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_date IS 'Created on';


--
-- Name: COLUMN hr_job.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_job_no_of_recruitment_positive ON hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_job_no_of_recruitment_positive ON public.hr_job IS 'CHECK(no_of_recruitment >= 0)';


--
-- Name: hr_job_hr_skill_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job_hr_skill_rel (
    hr_job_id integer NOT NULL,
    hr_skill_id integer NOT NULL
);


ALTER TABLE public.hr_job_hr_skill_rel OWNER TO runbot;

--
-- Name: TABLE hr_job_hr_skill_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job_hr_skill_rel IS 'RELATION BETWEEN hr_job AND hr_skill';


--
-- Name: hr_job_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_job_id_seq OWNER TO runbot;

--
-- Name: hr_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_job_id_seq OWNED BY public.hr_job.id;


--
-- Name: hr_job_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job_skill (
    id integer NOT NULL,
    skill_id integer NOT NULL,
    skill_level_id integer NOT NULL,
    skill_type_id integer NOT NULL,
    job_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    valid_from date,
    valid_to date,
    display_warning_message boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_job_skill OWNER TO runbot;

--
-- Name: TABLE hr_job_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job_skill IS 'Skills for job positions';


--
-- Name: COLUMN hr_job_skill.skill_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.skill_id IS 'Skill';


--
-- Name: COLUMN hr_job_skill.skill_level_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.skill_level_id IS 'Skill Level';


--
-- Name: COLUMN hr_job_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_job_skill.job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.job_id IS 'Job';


--
-- Name: COLUMN hr_job_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_job_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_job_skill.valid_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.valid_from IS 'Validity Start';


--
-- Name: COLUMN hr_job_skill.valid_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.valid_to IS 'Validity Stop';


--
-- Name: COLUMN hr_job_skill.display_warning_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.display_warning_message IS 'Display Warning Message';


--
-- Name: COLUMN hr_job_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_job_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.write_date IS 'Last Updated on';


--
-- Name: hr_job_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_job_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_job_skill_id_seq OWNER TO runbot;

--
-- Name: hr_job_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_job_skill_id_seq OWNED BY public.hr_job_skill.id;


--
-- Name: hr_payroll_structure_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_payroll_structure_type (
    id integer NOT NULL,
    default_resource_calendar_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_payroll_structure_type OWNER TO runbot;

--
-- Name: TABLE hr_payroll_structure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_payroll_structure_type IS 'Salary Structure Type';


--
-- Name: COLUMN hr_payroll_structure_type.default_resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.default_resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_payroll_structure_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.country_id IS 'Country';


--
-- Name: COLUMN hr_payroll_structure_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_payroll_structure_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_payroll_structure_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.name IS 'Salary Structure Type';


--
-- Name: COLUMN hr_payroll_structure_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_payroll_structure_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.write_date IS 'Last Updated on';


--
-- Name: hr_payroll_structure_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_payroll_structure_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_payroll_structure_type_id_seq OWNER TO runbot;

--
-- Name: hr_payroll_structure_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_payroll_structure_type_id_seq OWNED BY public.hr_payroll_structure_type.id;


--
-- Name: hr_resume_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_resume_line (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    duration integer,
    line_type_id integer,
    create_uid integer,
    write_uid integer,
    course_type character varying NOT NULL,
    external_url character varying,
    certificate_filename character varying,
    date_start date NOT NULL,
    date_end date,
    name jsonb NOT NULL,
    description jsonb,
    resume_line_properties jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_resume_line_date_check CHECK (((date_start <= date_end) OR (date_end IS NULL)))
);


ALTER TABLE public.hr_resume_line OWNER TO runbot;

--
-- Name: TABLE hr_resume_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_resume_line IS 'Resume line of an employee';


--
-- Name: COLUMN hr_resume_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.employee_id IS 'Employee';


--
-- Name: COLUMN hr_resume_line.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.duration IS 'Duration';


--
-- Name: COLUMN hr_resume_line.line_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.line_type_id IS 'Type';


--
-- Name: COLUMN hr_resume_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.create_uid IS 'Created by';


--
-- Name: COLUMN hr_resume_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_resume_line.course_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.course_type IS 'Course Type';


--
-- Name: COLUMN hr_resume_line.external_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.external_url IS 'External URL';


--
-- Name: COLUMN hr_resume_line.certificate_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.certificate_filename IS 'Certificate Filename';


--
-- Name: COLUMN hr_resume_line.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.date_start IS 'Date Start';


--
-- Name: COLUMN hr_resume_line.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.date_end IS 'Date End';


--
-- Name: COLUMN hr_resume_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.name IS 'Name';


--
-- Name: COLUMN hr_resume_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.description IS 'Description';


--
-- Name: COLUMN hr_resume_line.resume_line_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.resume_line_properties IS 'Properties';


--
-- Name: COLUMN hr_resume_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.create_date IS 'Created on';


--
-- Name: COLUMN hr_resume_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_resume_line_date_check ON hr_resume_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_resume_line_date_check ON public.hr_resume_line IS 'CHECK ((date_start <= date_end OR date_end IS NULL))';


--
-- Name: hr_resume_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_resume_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_resume_line_id_seq OWNER TO runbot;

--
-- Name: hr_resume_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_resume_line_id_seq OWNED BY public.hr_resume_line.id;


--
-- Name: hr_resume_line_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_resume_line_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    resume_line_type_properties_definition jsonb,
    is_course boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_resume_line_type OWNER TO runbot;

--
-- Name: TABLE hr_resume_line_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_resume_line_type IS 'Type of a resume line';


--
-- Name: COLUMN hr_resume_line_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_resume_line_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_resume_line_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_resume_line_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.name IS 'Name';


--
-- Name: COLUMN hr_resume_line_type.resume_line_type_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.resume_line_type_properties_definition IS 'Sections Properties';


--
-- Name: COLUMN hr_resume_line_type.is_course; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.is_course IS 'Course';


--
-- Name: COLUMN hr_resume_line_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_resume_line_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.write_date IS 'Last Updated on';


--
-- Name: hr_resume_line_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_resume_line_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_resume_line_type_id_seq OWNER TO runbot;

--
-- Name: hr_resume_line_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_resume_line_type_id_seq OWNED BY public.hr_resume_line_type.id;


--
-- Name: hr_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill (
    id integer NOT NULL,
    sequence integer,
    skill_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_skill OWNER TO runbot;

--
-- Name: TABLE hr_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill IS 'Skill';


--
-- Name: COLUMN hr_skill.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.sequence IS 'Sequence';


--
-- Name: COLUMN hr_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.name IS 'Name';


--
-- Name: COLUMN hr_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.write_date IS 'Last Updated on';


--
-- Name: hr_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_id_seq OWNER TO runbot;

--
-- Name: hr_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_id_seq OWNED BY public.hr_skill.id;


--
-- Name: hr_skill_level_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_level_id_seq OWNER TO runbot;

--
-- Name: hr_skill_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_level_id_seq OWNED BY public.hr_skill_level.id;


--
-- Name: hr_skill_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_type_id_seq OWNER TO runbot;

--
-- Name: hr_skill_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_type_id_seq OWNED BY public.hr_skill_type.id;


--
-- Name: hr_timesheet_merge_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_timesheet_merge_wizard (
    id integer NOT NULL,
    encoding_uom_id integer,
    project_id integer,
    task_id integer,
    employee_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision
);


ALTER TABLE public.hr_timesheet_merge_wizard OWNER TO runbot;

--
-- Name: TABLE hr_timesheet_merge_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_timesheet_merge_wizard IS 'Merge Timesheets';


--
-- Name: COLUMN hr_timesheet_merge_wizard.encoding_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.encoding_uom_id IS 'Encoding Uom';


--
-- Name: COLUMN hr_timesheet_merge_wizard.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.project_id IS 'Project';


--
-- Name: COLUMN hr_timesheet_merge_wizard.task_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.task_id IS 'Task';


--
-- Name: COLUMN hr_timesheet_merge_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.employee_id IS 'Employee';


--
-- Name: COLUMN hr_timesheet_merge_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_timesheet_merge_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_timesheet_merge_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.name IS 'Description';


--
-- Name: COLUMN hr_timesheet_merge_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.date IS 'Date';


--
-- Name: COLUMN hr_timesheet_merge_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_timesheet_merge_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_timesheet_merge_wizard.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_merge_wizard.unit_amount IS 'Quantity';


--
-- Name: hr_timesheet_merge_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_timesheet_merge_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_timesheet_merge_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_timesheet_merge_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_timesheet_merge_wizard_id_seq OWNED BY public.hr_timesheet_merge_wizard.id;


--
-- Name: hr_timesheet_stop_timer_confirmation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_timesheet_stop_timer_confirmation_wizard (
    id integer NOT NULL,
    timesheet_id integer,
    create_uid integer,
    write_uid integer,
    timesheet_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    time_spent double precision
);


ALTER TABLE public.hr_timesheet_stop_timer_confirmation_wizard OWNER TO runbot;

--
-- Name: TABLE hr_timesheet_stop_timer_confirmation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_timesheet_stop_timer_confirmation_wizard IS 'Confirm timesheet creation when stop timer';


--
-- Name: COLUMN hr_timesheet_stop_timer_confirmation_wizard.timesheet_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_stop_timer_confirmation_wizard.timesheet_id IS 'Timesheet';


--
-- Name: COLUMN hr_timesheet_stop_timer_confirmation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_stop_timer_confirmation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_timesheet_stop_timer_confirmation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_stop_timer_confirmation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_timesheet_stop_timer_confirmation_wizard.timesheet_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_stop_timer_confirmation_wizard.timesheet_name IS 'Name';


--
-- Name: COLUMN hr_timesheet_stop_timer_confirmation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_stop_timer_confirmation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_timesheet_stop_timer_confirmation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_stop_timer_confirmation_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_timesheet_stop_timer_confirmation_wizard.time_spent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_timesheet_stop_timer_confirmation_wizard.time_spent IS 'Time Spent';


--
-- Name: hr_timesheet_stop_timer_confirmation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_timesheet_stop_timer_confirmation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_timesheet_stop_timer_confirmation_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_timesheet_stop_timer_confirmation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_timesheet_stop_timer_confirmation_wizard_id_seq OWNED BY public.hr_timesheet_stop_timer_confirmation_wizard.id;


--
-- Name: hr_version_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_version_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_version_id_seq OWNER TO runbot;

--
-- Name: hr_version_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_version_id_seq OWNED BY public.hr_version.id;


--
-- Name: hr_version_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_version_wizard (
    id integer NOT NULL,
    contract_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_version_wizard OWNER TO runbot;

--
-- Name: TABLE hr_version_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_version_wizard IS 'Contract Template Wizard';


--
-- Name: COLUMN hr_version_wizard.contract_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.contract_template_id IS 'Contract Template';


--
-- Name: COLUMN hr_version_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_version_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_version_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_version_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_version_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_version_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_version_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_version_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_version_wizard_id_seq OWNED BY public.hr_version_wizard.id;


--
-- Name: hr_work_location; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_work_location (
    id integer NOT NULL,
    company_id integer NOT NULL,
    address_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location_type character varying NOT NULL,
    location_number character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_work_location OWNER TO runbot;

--
-- Name: TABLE hr_work_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_work_location IS 'Work Location';


--
-- Name: COLUMN hr_work_location.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.company_id IS 'Company';


--
-- Name: COLUMN hr_work_location.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.address_id IS 'Work Address';


--
-- Name: COLUMN hr_work_location.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_uid IS 'Created by';


--
-- Name: COLUMN hr_work_location.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_work_location.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.name IS 'Work Location';


--
-- Name: COLUMN hr_work_location.location_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.location_type IS 'Cover Image';


--
-- Name: COLUMN hr_work_location.location_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.location_number IS 'Location Number';


--
-- Name: COLUMN hr_work_location.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.active IS 'Active';


--
-- Name: COLUMN hr_work_location.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_date IS 'Created on';


--
-- Name: COLUMN hr_work_location.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_date IS 'Last Updated on';


--
-- Name: hr_work_location_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_work_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_work_location_id_seq OWNER TO runbot;

--
-- Name: hr_work_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_work_location_id_seq OWNED BY public.hr_work_location.id;


--
-- Name: html_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.html_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.html_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE html_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.html_editor_converter_test IS 'Html Editor Converter Test';


--
-- Name: COLUMN html_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN html_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN html_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN html_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN html_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN html_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN html_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN html_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN html_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN html_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN html_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN html_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN html_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN html_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN html_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."binary" IS 'Binary';


--
-- Name: html_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.html_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.html_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: html_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.html_editor_converter_test_id_seq OWNED BY public.html_editor_converter_test.id;


--
-- Name: html_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.html_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.html_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE html_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.html_editor_converter_test_sub IS 'Html Editor Converter Subtest';


--
-- Name: COLUMN html_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN html_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN html_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN html_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN html_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: html_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.html_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.html_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: html_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.html_editor_converter_test_sub_id_seq OWNED BY public.html_editor_converter_test_sub.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision,
    sender_name character varying
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: COLUMN iap_account.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.sender_name IS 'Sender Name';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    parent_id integer,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    sequence_id integer,
    selection_value integer,
    automated_name character varying,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text,
    html_value text,
    activity_user_id integer,
    activity_type_id integer,
    template_id integer,
    activity_date_deadline_range integer,
    activity_summary character varying,
    followers_type character varying,
    followers_partner_field_name character varying,
    mail_post_method character varying,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_field_name character varying,
    activity_note text,
    mail_post_autofollow boolean,
    sms_template_id integer,
    sms_method character varying,
    ai_tool_description jsonb,
    ai_action_prompt text,
    ai_tool_schema text,
    use_in_ai boolean,
    ai_tool_allow_end_message boolean,
    ai_update_prompt text
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.parent_id IS 'Parent Action';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence_id IS 'Sequence to use';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.automated_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.automated_name IS 'Automated Name';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: COLUMN ir_act_server.html_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.html_value IS 'Html Value';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Title';


--
-- Name: COLUMN ir_act_server.followers_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.followers_type IS 'Followers Type';


--
-- Name: COLUMN ir_act_server.followers_partner_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.followers_partner_field_name IS 'Followers Field';


--
-- Name: COLUMN ir_act_server.mail_post_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_method IS 'Send Email As';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'User Type';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User Field';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.mail_post_autofollow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_autofollow IS 'Subscribe Recipients';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_method IS 'Send SMS As';


--
-- Name: COLUMN ir_act_server.ai_tool_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_description IS 'AI Tool Description';


--
-- Name: COLUMN ir_act_server.ai_action_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_action_prompt IS 'AI Action Prompt';


--
-- Name: COLUMN ir_act_server.ai_tool_schema; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_schema IS 'AI Schema';


--
-- Name: COLUMN ir_act_server.use_in_ai; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.use_in_ai IS 'Use in AI';


--
-- Name: COLUMN ir_act_server.ai_tool_allow_end_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_allow_end_message IS 'Allow End Message';


--
-- Name: COLUMN ir_act_server.ai_update_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_update_prompt IS 'AI Update Prompt';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean,
    cache boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: COLUMN ir_act_window.cache; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.cache IS 'Data Caching';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_server_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_server_history (
    id integer NOT NULL,
    action_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_server_history OWNER TO runbot;

--
-- Name: TABLE ir_actions_server_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_server_history IS 'Server Action History';


--
-- Name: COLUMN ir_actions_server_history.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_server_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_server_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_server_history.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.code IS 'Code';


--
-- Name: COLUMN ir_actions_server_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_server_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.write_date IS 'Last Updated on';


--
-- Name: ir_actions_server_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_server_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_server_history_id_seq OWNER TO runbot;

--
-- Name: ir_actions_server_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_server_history_id_seq OWNED BY public.ir_actions_server_history.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    "json_value" character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default."json_value"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default."json_value" IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
            (action_id IS NOT NULL AND python_method IS NULL)
            OR (action_id IS NULL AND python_method IS NOT NULL)
        )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(NOT (python_method IS NOT NULL AND name IS NULL))';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL))';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_filters_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters_res_users_rel (
    ir_filters_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.ir_filters_res_users_rel OWNER TO runbot;

--
-- Name: TABLE ir_filters_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters_res_users_rel IS 'RELATION BETWEEN ir_filters AND res_users';


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    owner_user_id integer,
    owner_limit_count integer,
    owner_limit_time timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    microsoft_outlook_access_token_expiration integer,
    microsoft_outlook_refresh_token character varying,
    microsoft_outlook_access_token character varying,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.owner_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_user_id IS 'Owner';


--
-- Name: COLUMN ir_mail_server.owner_limit_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_limit_count IS 'Owner Limit Count';


--
-- Name: COLUMN ir_mail_server.owner_limit_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_limit_time IS 'Owner Limit Time';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_access_token_expiration IS 'Outlook Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_refresh_token IS 'Outlook Refresh Token';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_access_token IS 'Outlook Access Token';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    fold_name character varying,
    name jsonb NOT NULL,
    info text,
    abstract boolean,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.fold_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.fold_name IS 'Fold Field';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.abstract; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.abstract IS 'Abstract Model';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Has Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Has Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Has Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Last Updated on';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    translate character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    tracking integer,
    ai_domain character varying,
    system_prompt text,
    ai boolean,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: COLUMN ir_model_fields.ai_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ai_domain IS 'AI field domain';


--
-- Name: COLUMN ir_model_fields.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.system_prompt IS 'AI Prompt';


--
-- Name: COLUMN ir_model_fields.ai; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ai IS 'AI field';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_model_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ir_model_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND ir_model';


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    others text,
    qweb text,
    duration numeric,
    cpu_duration numeric,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.others; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.others IS 'others';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: COLUMN ir_profile.cpu_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.cpu_duration IS 'CPU Duration';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_001; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_001
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_001 OWNER TO runbot;

--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    customize_show boolean,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_ui_view.customize_show; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.customize_show IS 'Show As Optional Inherit';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer,
    res_id integer,
    activity_type_id integer,
    user_id integer,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    res_name character varying,
    summary character varying,
    user_tz character varying,
    date_deadline date NOT NULL,
    date_done date,
    note text,
    feedback text,
    automated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT mail_activity_check_res_id_is_set_if_model CHECK (((((COALESCE(res_model, ''::character varying))::text <> ''::text) AND ((res_id IS NOT NULL) AND (res_id <> 0))) OR (((COALESCE(res_model, ''::character varying))::text = ''::text) AND ((res_id IS NULL) OR (res_id = 0))))),
    CONSTRAINT mail_activity_check_user_id_is_set_if_model CHECK ((((COALESCE(res_model, ''::character varying))::text <> ''::text) OR (user_id IS NOT NULL)))
);


ALTER TABLE public.mail_activity OWNER TO runbot;

--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.user_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_tz IS 'Timezone';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_done IS 'Done Date';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.feedback IS 'Feedback';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.active IS 'Active';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT mail_activity_check_res_id_is_set_if_model ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_res_id_is_set_if_model ON public.mail_activity IS 'CHECK(
            (COALESCE(res_model, '''') <> '''' AND (res_id IS NOT NULL AND res_id != 0)) OR
            (COALESCE(res_model, '''') = '''' AND (res_id IS NULL OR res_id = 0))
        )';


--
-- Name: CONSTRAINT mail_activity_check_user_id_is_set_if_model ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_user_id_is_set_if_model ON public.mail_activity IS 'CHECK(
            (COALESCE(res_model, '''') <> '''' OR user_id IS NOT NULL)
        )';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_id_seq OWNER TO runbot;

--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan (
    id integer NOT NULL,
    company_id integer,
    res_model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    department_id integer
);


ALTER TABLE public.mail_activity_plan OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan IS 'Activity Plan';


--
-- Name: COLUMN mail_activity_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.company_id IS 'Company';


--
-- Name: COLUMN mail_activity_plan.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.name IS 'Name';


--
-- Name: COLUMN mail_activity_plan.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.active IS 'Active';


--
-- Name: COLUMN mail_activity_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_activity_plan.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.department_id IS 'Department';


--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_id_seq OWNED BY public.mail_activity_plan.id;


--
-- Name: mail_activity_plan_mail_activity_schedule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_mail_activity_schedule_rel (
    mail_activity_schedule_id integer NOT NULL,
    mail_activity_plan_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_mail_activity_schedule_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_mail_activity_schedule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_mail_activity_schedule_rel IS 'RELATION BETWEEN mail_activity_schedule AND mail_activity_plan';


--
-- Name: mail_activity_plan_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    sequence integer,
    activity_type_id integer NOT NULL,
    delay_count integer,
    responsible_id integer,
    create_uid integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    summary character varying,
    responsible_type character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan_template OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template IS 'Activity plan template';


--
-- Name: COLUMN mail_activity_plan_template.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_plan_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_plan_template.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_plan_template.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_count IS 'Interval';


--
-- Name: COLUMN mail_activity_plan_template.responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_plan_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan_template.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_plan_template.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_from IS 'Trigger';


--
-- Name: COLUMN mail_activity_plan_template.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_plan_template.responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_type IS 'Assignment';


--
-- Name: COLUMN mail_activity_plan_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.note IS 'Note';


--
-- Name: COLUMN mail_activity_plan_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNED BY public.mail_activity_plan_template.id;


--
-- Name: mail_activity_plan_template_mail_activity_type_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template_mail_activity_type_rel (
    mail_activity_plan_template_id integer NOT NULL,
    mail_activity_type_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_template_mail_activity_type_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template_mail_activity_type_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template_mail_activity_type_rel IS 'RELATION BETWEEN mail_activity_plan_template AND mail_activity_type';


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


ALTER TABLE public.mail_activity_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule (
    id integer NOT NULL,
    res_model_id integer,
    plan_id integer,
    plan_on_demand_user_id integer,
    activity_type_id integer,
    activity_user_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    summary character varying,
    plan_date date,
    date_deadline date,
    res_ids text,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule IS 'Activity schedule plan Wizard';


--
-- Name: COLUMN mail_activity_schedule.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_schedule.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_schedule.plan_on_demand_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_on_demand_user_id IS 'Assigned To';


--
-- Name: COLUMN mail_activity_schedule.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_schedule.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_schedule.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_schedule.plan_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_date IS 'Plan Date';


--
-- Name: COLUMN mail_activity_schedule.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity_schedule.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_ids IS 'Document IDs';


--
-- Name: COLUMN mail_activity_schedule.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.note IS 'Note';


--
-- Name: COLUMN mail_activity_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNED BY public.mail_activity_schedule.id;


--
-- Name: mail_activity_schedule_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule_line (
    id integer NOT NULL,
    activity_schedule_id integer NOT NULL,
    responsible_user_id integer,
    create_uid integer,
    write_uid integer,
    line_description character varying,
    line_date_deadline date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule_line OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule_line IS 'Mail Activity Schedule Line';


--
-- Name: COLUMN mail_activity_schedule_line.activity_schedule_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.activity_schedule_id IS 'Activity Schedule';


--
-- Name: COLUMN mail_activity_schedule_line.responsible_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.responsible_user_id IS 'Responsible User';


--
-- Name: COLUMN mail_activity_schedule_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule_line.line_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.line_description IS 'Line Description';


--
-- Name: COLUMN mail_activity_schedule_line.line_date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.line_date_deadline IS 'Date Deadline';


--
-- Name: COLUMN mail_activity_schedule_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_line_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_line_id_seq OWNED BY public.mail_activity_schedule_line.id;


--
-- Name: mail_activity_todo_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_todo_create (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    summary character varying,
    date_deadline date NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_todo_create OWNER TO runbot;

--
-- Name: TABLE mail_activity_todo_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_todo_create IS 'Create activity and todo at the same time';


--
-- Name: COLUMN mail_activity_todo_create.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_todo_create.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_todo_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_todo_create.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_todo_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_todo_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_todo_create.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_todo_create.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_todo_create.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_todo_create.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity_todo_create.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_todo_create.note IS 'Note';


--
-- Name: COLUMN mail_activity_todo_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_todo_create.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_todo_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_todo_create.write_date IS 'Last Updated on';


--
-- Name: mail_activity_todo_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_todo_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_todo_create_id_seq OWNER TO runbot;

--
-- Name: mail_activity_todo_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_todo_create_id_seq OWNED BY public.mail_activity_todo_create.id;


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    delay_count integer,
    triggered_next_type_id integer,
    default_user_id integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model character varying,
    chaining_type character varying NOT NULL,
    category character varying,
    name jsonb NOT NULL,
    summary jsonb,
    default_note jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_type OWNER TO runbot;

--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Schedule';


--
-- Name: COLUMN mail_activity_type.triggered_next_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.triggered_next_type_id IS 'Trigger';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_type.chaining_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.chaining_type IS 'Chaining Type';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.default_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_note IS 'Default Note';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_type_id_seq OWNER TO runbot;

--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_activity_type_mail_template_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_domain_id integer,
    alias_model_id integer NOT NULL,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    create_uid integer,
    write_uid integer,
    alias_name character varying,
    alias_full_name character varying,
    alias_contact character varying NOT NULL,
    alias_status character varying,
    alias_bounced_content jsonb,
    alias_defaults text NOT NULL,
    alias_incoming_local boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias OWNER TO runbot;

--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_full_name IS 'Alias Email';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_status IS 'Alias Status';


--
-- Name: COLUMN mail_alias.alias_bounced_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_bounced_content IS 'Custom Bounced Message';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_incoming_local; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_incoming_local IS 'Local-part based incoming detection';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias_domain (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bounce_alias character varying NOT NULL,
    catchall_alias character varying NOT NULL,
    default_from character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias_domain OWNER TO runbot;

--
-- Name: TABLE mail_alias_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias_domain IS 'Email Domain';


--
-- Name: COLUMN mail_alias_domain.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.sequence IS 'Sequence';


--
-- Name: COLUMN mail_alias_domain.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias_domain.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias_domain.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.name IS 'Name';


--
-- Name: COLUMN mail_alias_domain.bounce_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.bounce_alias IS 'Bounce Alias';


--
-- Name: COLUMN mail_alias_domain.catchall_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.catchall_alias IS 'Catchall Alias';


--
-- Name: COLUMN mail_alias_domain.default_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.default_from IS 'Default From Alias';


--
-- Name: COLUMN mail_alias_domain.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias_domain.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_domain_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_domain_id_seq OWNER TO runbot;

--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_domain_id_seq OWNED BY public.mail_alias_domain.id;


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_id_seq OWNER TO runbot;

--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist OWNER TO runbot;

--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE mail_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist_remove IS 'Remove email from blacklist wizard';


--
-- Name: COLUMN mail_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist_remove.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.email IS 'Email';


--
-- Name: COLUMN mail_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN mail_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNED BY public.mail_blacklist_remove.id;


--
-- Name: mail_canned_response; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source character varying NOT NULL,
    substitution text NOT NULL,
    is_shared boolean,
    last_used timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_canned_response OWNER TO runbot;

--
-- Name: TABLE mail_canned_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response IS 'Canned Response';


--
-- Name: COLUMN mail_canned_response.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_uid IS 'Created by';


--
-- Name: COLUMN mail_canned_response.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_canned_response.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.source IS 'Shortcut';


--
-- Name: COLUMN mail_canned_response.substitution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.substitution IS 'Substitution';


--
-- Name: COLUMN mail_canned_response.is_shared; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.is_shared IS 'Determines if the canned_response is currently shared with other users';


--
-- Name: COLUMN mail_canned_response.last_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.last_used IS 'Last Used';


--
-- Name: COLUMN mail_canned_response.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_date IS 'Created on';


--
-- Name: COLUMN mail_canned_response.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_date IS 'Last Updated on';


--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_canned_response_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_canned_response_id_seq OWNER TO runbot;

--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_canned_response_id_seq OWNED BY public.mail_canned_response.id;


--
-- Name: mail_canned_response_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response_res_groups_rel (
    mail_canned_response_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.mail_canned_response_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE mail_canned_response_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response_res_groups_rel IS 'RELATION BETWEEN mail_canned_response AND res_groups';


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    template_id integer,
    parent_id integer,
    author_id integer,
    res_domain_user_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    email_layout_xmlid character varying,
    email_from character varying,
    composition_mode character varying,
    composition_comment_option character varying,
    model character varying,
    message_type character varying NOT NULL,
    reply_to character varying,
    scheduled_date character varying,
    template_name character varying,
    body text,
    res_ids text,
    res_domain text,
    email_add_signature boolean,
    reply_to_force_new boolean,
    auto_delete boolean,
    auto_delete_keep_log boolean,
    force_send boolean,
    notify_author boolean,
    notify_author_mention boolean,
    notify_skip_followers boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_compose_message OWNER TO runbot;

--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.res_domain_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain_user_id IS 'Responsible';


--
-- Name: COLUMN mail_compose_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_compose_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.lang IS 'Language';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.composition_comment_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_comment_option IS 'Comment Options';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_compose_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_compose_message.template_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_name IS 'Template Name';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_compose_message.res_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_add_signature IS 'Add signature';


--
-- Name: COLUMN mail_compose_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to_force_new IS 'Considers answers as new thread';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_keep_log IS 'Keep Message Copy';


--
-- Name: COLUMN mail_compose_message.force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.force_send IS 'Send mailing or notifications directly';


--
-- Name: COLUMN mail_compose_message.notify_author; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_author IS 'Notify Author';


--
-- Name: COLUMN mail_compose_message.notify_author_mention; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_author_mention IS 'Notify Author Mention';


--
-- Name: COLUMN mail_compose_message.notify_skip_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_skip_followers IS 'Notify Skip Followers';


--
-- Name: COLUMN mail_compose_message.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.use_exclusion_list IS 'Use Exclusion List';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_compose_message_id_seq OWNER TO runbot;

--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_id integer,
    partner_id integer NOT NULL,
    res_model character varying NOT NULL
);


ALTER TABLE public.mail_followers OWNER TO runbot;

--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: mail_followers_edit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_edit (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    res_ids character varying,
    operation character varying NOT NULL,
    message text,
    notify boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_followers_edit OWNER TO runbot;

--
-- Name: TABLE mail_followers_edit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_edit IS 'Followers edit wizard';


--
-- Name: COLUMN mail_followers_edit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.create_uid IS 'Created by';


--
-- Name: COLUMN mail_followers_edit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_followers_edit.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_followers_edit.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_followers_edit.operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.operation IS 'Operation';


--
-- Name: COLUMN mail_followers_edit.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.message IS 'Message';


--
-- Name: COLUMN mail_followers_edit.notify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.notify IS 'Notify Recipients';


--
-- Name: COLUMN mail_followers_edit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.create_date IS 'Created on';


--
-- Name: COLUMN mail_followers_edit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.write_date IS 'Last Updated on';


--
-- Name: mail_followers_edit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_edit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_edit_id_seq OWNER TO runbot;

--
-- Name: mail_followers_edit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_edit_id_seq OWNED BY public.mail_followers_edit.id;


--
-- Name: mail_followers_edit_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_edit_res_partner_rel (
    mail_followers_edit_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_followers_edit_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_edit_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_edit_res_partner_rel IS 'RELATION BETWEEN mail_followers_edit AND res_partner';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_id_seq OWNER TO runbot;

--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_followers_mail_message_subtype_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_gateway_allowed; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_gateway_allowed (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    email_normalized character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_gateway_allowed OWNER TO runbot;

--
-- Name: TABLE mail_gateway_allowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_gateway_allowed IS 'Mail Gateway Allowed';


--
-- Name: COLUMN mail_gateway_allowed.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_uid IS 'Created by';


--
-- Name: COLUMN mail_gateway_allowed.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_gateway_allowed.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email IS 'Email Address';


--
-- Name: COLUMN mail_gateway_allowed.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN mail_gateway_allowed.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_date IS 'Created on';


--
-- Name: COLUMN mail_gateway_allowed.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_date IS 'Last Updated on';


--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_gateway_allowed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNER TO runbot;

--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNED BY public.mail_gateway_allowed.id;


--
-- Name: mail_guest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_guest (
    id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    access_token character varying NOT NULL,
    email character varying,
    lang character varying,
    timezone character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_guest OWNER TO runbot;

--
-- Name: TABLE mail_guest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_guest IS 'Guest';


--
-- Name: COLUMN mail_guest.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.country_id IS 'Country';


--
-- Name: COLUMN mail_guest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_uid IS 'Created by';


--
-- Name: COLUMN mail_guest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_guest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.name IS 'Name';


--
-- Name: COLUMN mail_guest.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.access_token IS 'Access Token';


--
-- Name: COLUMN mail_guest.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.email IS 'Email';


--
-- Name: COLUMN mail_guest.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.lang IS 'Language';


--
-- Name: COLUMN mail_guest.timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.timezone IS 'Timezone';


--
-- Name: COLUMN mail_guest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_date IS 'Created on';


--
-- Name: COLUMN mail_guest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_date IS 'Last Updated on';


--
-- Name: mail_guest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_guest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_guest_id_seq OWNER TO runbot;

--
-- Name: mail_guest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_guest_id_seq OWNED BY public.mail_guest.id;


--
-- Name: mail_ice_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_ice_server (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_type character varying NOT NULL,
    uri character varying NOT NULL,
    username character varying,
    credential character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_ice_server OWNER TO runbot;

--
-- Name: TABLE mail_ice_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_ice_server IS 'ICE Server';


--
-- Name: COLUMN mail_ice_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_uid IS 'Created by';


--
-- Name: COLUMN mail_ice_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_ice_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.server_type IS 'Type';


--
-- Name: COLUMN mail_ice_server.uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.uri IS 'URI';


--
-- Name: COLUMN mail_ice_server.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.username IS 'Username';


--
-- Name: COLUMN mail_ice_server.credential; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.credential IS 'Credential';


--
-- Name: COLUMN mail_ice_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_date IS 'Created on';


--
-- Name: COLUMN mail_ice_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_date IS 'Last Updated on';


--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_ice_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_ice_server_id_seq OWNER TO runbot;

--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_ice_server_id_seq OWNED BY public.mail_ice_server.id;


--
-- Name: mail_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_link_preview (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_url character varying NOT NULL,
    og_type character varying,
    og_title character varying,
    og_site_name character varying,
    og_image character varying,
    og_mimetype character varying,
    image_mimetype character varying,
    og_description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_link_preview IS 'Store link preview data';


--
-- Name: COLUMN mail_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_link_preview.source_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.source_url IS 'URL';


--
-- Name: COLUMN mail_link_preview.og_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_type IS 'Type';


--
-- Name: COLUMN mail_link_preview.og_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_title IS 'Title';


--
-- Name: COLUMN mail_link_preview.og_site_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_site_name IS 'Site name';


--
-- Name: COLUMN mail_link_preview.og_image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_image IS 'Image';


--
-- Name: COLUMN mail_link_preview.og_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_mimetype IS 'MIME type';


--
-- Name: COLUMN mail_link_preview.image_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.image_mimetype IS 'Image MIME type';


--
-- Name: COLUMN mail_link_preview.og_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_description IS 'Description';


--
-- Name: COLUMN mail_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_date IS 'Create Date';


--
-- Name: COLUMN mail_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_link_preview_id_seq OWNED BY public.mail_link_preview.id;


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    fetchmail_server_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    state character varying,
    failure_type character varying,
    body_html text,
    "references" text,
    headers text,
    email_to text,
    failure_reason text,
    is_notification boolean,
    auto_delete boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_mail OWNER TO runbot;

--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.is_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.is_notification IS 'Notification Email';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_mail_id_seq OWNER TO runbot;

--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_mail_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    incoming_email_cc character varying,
    outgoing_email_to character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    incoming_email_to text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    pinned_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.incoming_email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_cc IS 'Emails Cc';


--
-- Name: COLUMN mail_message.outgoing_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.outgoing_email_to IS 'emails To';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.incoming_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_to IS 'Emails To';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.pinned_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.pinned_at IS 'Pinned';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_id_seq OWNER TO runbot;

--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_link_preview (
    id integer NOT NULL,
    message_id integer NOT NULL,
    link_preview_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    is_hidden boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_message_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_link_preview IS 'Link between link previews and messages';


--
-- Name: COLUMN mail_message_link_preview.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.message_id IS 'Message';


--
-- Name: COLUMN mail_message_link_preview.link_preview_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.link_preview_id IS 'Link Preview';


--
-- Name: COLUMN mail_message_link_preview.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_link_preview.is_hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.is_hidden IS 'Is Hidden';


--
-- Name: COLUMN mail_message_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_message_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_message_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_link_preview_id_seq OWNED BY public.mail_message_link_preview.id;


--
-- Name: mail_message_reaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_reaction (
    id integer NOT NULL,
    message_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    content character varying NOT NULL,
    CONSTRAINT mail_message_reaction_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_message_reaction OWNER TO runbot;

--
-- Name: TABLE mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_reaction IS 'Message Reaction';


--
-- Name: COLUMN mail_message_reaction.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.message_id IS 'Message';


--
-- Name: COLUMN mail_message_reaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.partner_id IS 'Reacting Partner';


--
-- Name: COLUMN mail_message_reaction.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.guest_id IS 'Reacting Guest';


--
-- Name: COLUMN mail_message_reaction.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.content IS 'Content';


--
-- Name: CONSTRAINT mail_message_reaction_partner_or_guest_exists ON mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_message_reaction_partner_or_guest_exists ON public.mail_message_reaction IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_reaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_reaction_id_seq OWNER TO runbot;

--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_reaction_id_seq OWNED BY public.mail_message_reaction.id;


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_starred_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_schedule (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    notification_parameters text,
    scheduled_datetime timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_schedule OWNER TO runbot;

--
-- Name: TABLE mail_message_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_schedule IS 'Scheduled Messages';


--
-- Name: COLUMN mail_message_schedule.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_message_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_schedule.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.notification_parameters IS 'Notification Parameter';


--
-- Name: COLUMN mail_message_schedule.scheduled_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.scheduled_datetime IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_message_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_schedule_id_seq OWNED BY public.mail_message_schedule.id;


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    parent_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    relation_field character varying,
    res_model character varying,
    name jsonb NOT NULL,
    description jsonb,
    internal boolean,
    "default" boolean,
    hidden boolean,
    track_recipients boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_subtype OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.track_recipients; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.track_recipients IS 'Track Recipients';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_subtype_id_seq OWNER TO runbot;

--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_message_translation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_translation (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_lang character varying NOT NULL,
    target_lang character varying NOT NULL,
    body text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_translation OWNER TO runbot;

--
-- Name: TABLE mail_message_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_translation IS 'Message Translation';


--
-- Name: COLUMN mail_message_translation.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.message_id IS 'Message';


--
-- Name: COLUMN mail_message_translation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_translation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_translation.source_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.source_lang IS 'Source Language';


--
-- Name: COLUMN mail_message_translation.target_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.target_lang IS 'Target Language';


--
-- Name: COLUMN mail_message_translation.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.body IS 'Translation Body';


--
-- Name: COLUMN mail_message_translation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_date IS 'Create Date';


--
-- Name: COLUMN mail_message_translation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_date IS 'Last Updated on';


--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_translation_id_seq OWNER TO runbot;

--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_translation_id_seq OWNED BY public.mail_message_translation.id;


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification (
    id integer NOT NULL,
    author_id integer,
    mail_message_id integer NOT NULL,
    mail_mail_id integer,
    res_partner_id integer,
    mail_email_address character varying,
    notification_type character varying NOT NULL,
    notification_status character varying,
    failure_type character varying,
    failure_reason text,
    is_read boolean,
    read_date timestamp without time zone,
    sms_id_int integer,
    sms_number character varying,
    letter_id integer,
    CONSTRAINT mail_notification_notification_partner_or_email_required CHECK ((((notification_type)::text <> 'email'::text) OR (failure_type IS NOT NULL) OR (res_partner_id IS NOT NULL) OR ((COALESCE(mail_email_address, ''::character varying))::text <> ''::text))),
    CONSTRAINT mail_notification_notification_partner_required CHECK ((((notification_type)::text <> 'inbox'::text) OR (res_partner_id IS NOT NULL)))
);


ALTER TABLE public.mail_notification OWNER TO runbot;

--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification IS 'Message Notifications';


--
-- Name: COLUMN mail_notification.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.author_id IS 'Author';


--
-- Name: COLUMN mail_notification.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_notification.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mail_notification.res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.res_partner_id IS 'Recipient';


--
-- Name: COLUMN mail_notification.mail_email_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_email_address IS 'Mail Email Address';


--
-- Name: COLUMN mail_notification.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_notification.notification_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_status IS 'Status';


--
-- Name: COLUMN mail_notification.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_notification.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.is_read IS 'Is Read';


--
-- Name: COLUMN mail_notification.read_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.read_date IS 'Read Date';


--
-- Name: COLUMN mail_notification.sms_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_id_int IS 'SMS ID';


--
-- Name: COLUMN mail_notification.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_number IS 'SMS Number';


--
-- Name: COLUMN mail_notification.letter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.letter_id IS 'Snailmail Letter';


--
-- Name: CONSTRAINT mail_notification_notification_partner_or_email_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_or_email_required ON public.mail_notification IS 'CHECK(notification_type != ''email'' OR failure_type IS NOT NULL OR res_partner_id IS NOT NULL OR COALESCE(mail_email_address, '''') != '''')';


--
-- Name: CONSTRAINT mail_notification_notification_partner_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_required ON public.mail_notification IS 'CHECK(notification_type != ''inbox'' OR res_partner_id IS NOT NULL)';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_notification_id_seq OWNER TO runbot;

--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_notification_id_seq OWNED BY public.mail_notification.id;


--
-- Name: mail_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_presence (
    id integer NOT NULL,
    user_id integer,
    guest_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    CONSTRAINT mail_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_presence OWNER TO runbot;

--
-- Name: TABLE mail_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_presence IS 'User/Guest Presence';


--
-- Name: COLUMN mail_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.user_id IS 'Users';


--
-- Name: COLUMN mail_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.guest_id IS 'Guest';


--
-- Name: COLUMN mail_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.status IS 'IM Status';


--
-- Name: COLUMN mail_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN mail_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.last_presence IS 'Last Presence';


--
-- Name: CONSTRAINT mail_presence_partner_or_guest_exists ON mail_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_presence_partner_or_guest_exists ON public.mail_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_presence_id_seq OWNER TO runbot;

--
-- Name: mail_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_presence_id_seq OWNED BY public.mail_presence.id;


--
-- Name: mail_push; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push (
    id integer NOT NULL,
    mail_push_device_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payload text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push OWNER TO runbot;

--
-- Name: TABLE mail_push; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push IS 'Push Notifications';


--
-- Name: COLUMN mail_push.mail_push_device_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.mail_push_device_id IS 'devices';


--
-- Name: COLUMN mail_push.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push.payload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.payload IS 'Payload';


--
-- Name: COLUMN mail_push.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_date IS 'Created on';


--
-- Name: COLUMN mail_push.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_date IS 'Last Updated on';


--
-- Name: mail_push_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push_device (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    endpoint character varying NOT NULL,
    keys character varying NOT NULL,
    expiration_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push_device OWNER TO runbot;

--
-- Name: TABLE mail_push_device; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push_device IS 'Push Notification Device';


--
-- Name: COLUMN mail_push_device.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.partner_id IS 'Partner';


--
-- Name: COLUMN mail_push_device.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push_device.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push_device.endpoint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.endpoint IS 'Browser endpoint';


--
-- Name: COLUMN mail_push_device.keys; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.keys IS 'Browser keys';


--
-- Name: COLUMN mail_push_device.expiration_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.expiration_time IS 'Expiration Token Date';


--
-- Name: COLUMN mail_push_device.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_date IS 'Created on';


--
-- Name: COLUMN mail_push_device.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_date IS 'Last Updated on';


--
-- Name: mail_push_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_device_id_seq OWNER TO runbot;

--
-- Name: mail_push_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_device_id_seq OWNED BY public.mail_push_device.id;


--
-- Name: mail_push_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_id_seq OWNER TO runbot;

--
-- Name: mail_push_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_id_seq OWNED BY public.mail_push.id;


--
-- Name: mail_scheduled_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message (
    id integer NOT NULL,
    res_id integer NOT NULL,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subject character varying,
    composition_comment_option character varying,
    model character varying NOT NULL,
    send_context jsonb,
    body text,
    notification_parameters text,
    is_note boolean,
    scheduled_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_scheduled_message OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message IS 'Scheduled Message';


--
-- Name: COLUMN mail_scheduled_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.res_id IS 'Related Document Id';


--
-- Name: COLUMN mail_scheduled_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.author_id IS 'Author';


--
-- Name: COLUMN mail_scheduled_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_scheduled_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_scheduled_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.subject IS 'Subject';


--
-- Name: COLUMN mail_scheduled_message.composition_comment_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.composition_comment_option IS 'Comment Options';


--
-- Name: COLUMN mail_scheduled_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_scheduled_message.send_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.send_context IS 'Sending Context';


--
-- Name: COLUMN mail_scheduled_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.body IS 'Contents';


--
-- Name: COLUMN mail_scheduled_message.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.notification_parameters IS 'Notification parameters';


--
-- Name: COLUMN mail_scheduled_message.is_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.is_note IS 'Is a note';


--
-- Name: COLUMN mail_scheduled_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_scheduled_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_scheduled_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_date IS 'Last Updated on';


--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_scheduled_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNER TO runbot;

--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNED BY public.mail_scheduled_message.id;


--
-- Name: mail_scheduled_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message_res_partner_rel (
    mail_scheduled_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_scheduled_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message_res_partner_rel IS 'RELATION BETWEEN mail_scheduled_message AND res_partner';


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    model_id integer,
    user_id integer,
    mail_server_id integer,
    ref_ir_act_window integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    email_from character varying,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    scheduled_date character varying,
    name jsonb,
    description jsonb,
    subject jsonb,
    body_html jsonb,
    active boolean,
    use_default_to boolean,
    auto_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template OWNER TO runbot;

--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.user_id IS 'Owner';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_from IS 'Send From';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_template.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.description IS 'Template Description';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.active IS 'Active';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default Recipients';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_id_seq OWNER TO runbot;

--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_template_ir_actions_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_ir_actions_report_rel (
    mail_template_id integer NOT NULL,
    ir_actions_report_id integer NOT NULL
);


ALTER TABLE public.mail_template_ir_actions_report_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_ir_actions_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_ir_actions_report_rel IS 'RELATION BETWEEN mail_template AND ir_act_report_xml';


--
-- Name: mail_template_mail_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_mail_template_reset_rel (
    mail_template_reset_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_template_mail_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_mail_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_mail_template_reset_rel IS 'RELATION BETWEEN mail_template_reset AND mail_template';


--
-- Name: mail_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_preview (
    id integer NOT NULL,
    mail_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    lang character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_preview OWNER TO runbot;

--
-- Name: TABLE mail_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN mail_template_preview.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.mail_template_id IS 'Related Mail Template';


--
-- Name: COLUMN mail_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.resource_ref IS 'Record';


--
-- Name: COLUMN mail_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN mail_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_date IS 'Last Updated on';


--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_preview_id_seq OWNER TO runbot;

--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_preview_id_seq OWNED BY public.mail_template_preview.id;


--
-- Name: mail_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_reset OWNER TO runbot;

--
-- Name: TABLE mail_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_reset IS 'Mail Template Reset';


--
-- Name: COLUMN mail_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_date IS 'Last Updated on';


--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_reset_id_seq OWNER TO runbot;

--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_reset_id_seq OWNED BY public.mail_template_reset.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field_id integer,
    old_value_integer integer,
    new_value_integer integer,
    currency_id integer,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    old_value_char character varying,
    new_value_char character varying,
    field_info jsonb,
    old_value_text text,
    new_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    old_value_float double precision,
    new_value_float double precision
);


ALTER TABLE public.mail_tracking_value OWNER TO runbot;

--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_id IS 'Field';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.currency_id IS 'Currency';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.field_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_info IS 'Removed field information';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_tracking_value_id_seq OWNER TO runbot;

--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: orm_signaling_assets; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_assets (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_assets OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_assets_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNED BY public.orm_signaling_assets.id;


--
-- Name: orm_signaling_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_default (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_default OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_default_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_default_id_seq OWNED BY public.orm_signaling_default.id;


--
-- Name: orm_signaling_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_groups (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_groups OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNED BY public.orm_signaling_groups.id;


--
-- Name: orm_signaling_registry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_registry (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_registry OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_registry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNED BY public.orm_signaling_registry.id;


--
-- Name: orm_signaling_routing; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_routing (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_routing OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_routing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNED BY public.orm_signaling_routing.id;


--
-- Name: orm_signaling_stable; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_stable (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_stable OWNER TO runbot;

--
-- Name: orm_signaling_stable_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_stable_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_stable_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_stable_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_stable_id_seq OWNED BY public.orm_signaling_stable.id;


--
-- Name: orm_signaling_templates; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_templates (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_templates OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_templates_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNED BY public.orm_signaling_templates.id;


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    number character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist OWNER TO runbot;

--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: phone_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE phone_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist_remove IS 'Remove phone from blacklist';


--
-- Name: COLUMN phone_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist_remove.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.phone IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN phone_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNED BY public.phone_blacklist_remove.id;


--
-- Name: portal_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share (
    id integer NOT NULL,
    res_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_share OWNER TO runbot;

--
-- Name: TABLE portal_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share IS 'Portal Sharing';


--
-- Name: COLUMN portal_share.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_id IS 'Related Document ID';


--
-- Name: COLUMN portal_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_uid IS 'Created by';


--
-- Name: COLUMN portal_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_share.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_model IS 'Related Document Model';


--
-- Name: COLUMN portal_share.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.note IS 'Note';


--
-- Name: COLUMN portal_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_date IS 'Created on';


--
-- Name: COLUMN portal_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_date IS 'Last Updated on';


--
-- Name: portal_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_share_id_seq OWNER TO runbot;

--
-- Name: portal_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_share_id_seq OWNED BY public.portal_share.id;


--
-- Name: portal_share_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share_res_partner_rel (
    portal_share_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_share_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_share_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share_res_partner_rel IS 'RELATION BETWEEN portal_share AND res_partner';


--
-- Name: portal_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    welcome_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard OWNER TO runbot;

--
-- Name: TABLE portal_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard IS 'Grant Portal Access';


--
-- Name: COLUMN portal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard.welcome_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.welcome_message IS 'Invitation Message';


--
-- Name: COLUMN portal_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_id_seq OWNED BY public.portal_wizard.id;


--
-- Name: portal_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_res_partner_rel (
    portal_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_res_partner_rel IS 'RELATION BETWEEN portal_wizard AND res_partner';


--
-- Name: portal_wizard_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard_user OWNER TO runbot;

--
-- Name: TABLE portal_wizard_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_user IS 'Portal User Config';


--
-- Name: COLUMN portal_wizard_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN portal_wizard_user.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.partner_id IS 'Contact';


--
-- Name: COLUMN portal_wizard_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard_user.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.email IS 'Email';


--
-- Name: COLUMN portal_wizard_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_user_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_user_id_seq OWNED BY public.portal_wizard_user.id;


--
-- Name: privacy_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    anonymized_name character varying NOT NULL,
    anonymized_email character varying NOT NULL,
    execution_details text,
    records_description text,
    additional_note text,
    date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_log OWNER TO runbot;

--
-- Name: TABLE privacy_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_log IS 'Privacy Log';


--
-- Name: COLUMN privacy_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.user_id IS 'Handled By';


--
-- Name: COLUMN privacy_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_log.anonymized_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_name IS 'Anonymized Name';


--
-- Name: COLUMN privacy_log.anonymized_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_email IS 'Anonymized Email';


--
-- Name: COLUMN privacy_log.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_log.records_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.records_description IS 'Found Records';


--
-- Name: COLUMN privacy_log.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.additional_note IS 'Additional Note';


--
-- Name: COLUMN privacy_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.date IS 'Date';


--
-- Name: COLUMN privacy_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_date IS 'Created on';


--
-- Name: COLUMN privacy_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_date IS 'Last Updated on';


--
-- Name: privacy_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_log_id_seq OWNER TO runbot;

--
-- Name: privacy_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_log_id_seq OWNED BY public.privacy_log.id;


--
-- Name: privacy_lookup_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard (
    id integer NOT NULL,
    log_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    email character varying NOT NULL,
    execution_details text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard IS 'Privacy Lookup Wizard';


--
-- Name: COLUMN privacy_lookup_wizard.log_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.log_id IS 'Log';


--
-- Name: COLUMN privacy_lookup_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.name IS 'Name';


--
-- Name: COLUMN privacy_lookup_wizard.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.email IS 'Email';


--
-- Name: COLUMN privacy_lookup_wizard.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNED BY public.privacy_lookup_wizard.id;


--
-- Name: privacy_lookup_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard_line (
    id integer NOT NULL,
    wizard_id integer,
    res_id integer NOT NULL,
    res_model_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    execution_details character varying,
    has_active boolean,
    is_active boolean,
    is_unlinked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard_line OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard_line IS 'Privacy Lookup Wizard Line';


--
-- Name: COLUMN privacy_lookup_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_id IS 'Resource ID';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_name IS 'Resource name';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model IS 'Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard_line.has_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.has_active IS 'Has Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_active IS 'Is Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_unlinked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_unlinked IS 'Is Unlinked';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNED BY public.privacy_lookup_wizard_line.id;


--
-- Name: project_collaborator; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_collaborator (
    id integer NOT NULL,
    project_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    limited_access boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_collaborator OWNER TO runbot;

--
-- Name: TABLE project_collaborator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_collaborator IS 'Collaborators in project shared';


--
-- Name: COLUMN project_collaborator.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_collaborator.project_id IS 'Project Shared';


--
-- Name: COLUMN project_collaborator.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_collaborator.partner_id IS 'Collaborator';


--
-- Name: COLUMN project_collaborator.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_collaborator.create_uid IS 'Created by';


--
-- Name: COLUMN project_collaborator.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_collaborator.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_collaborator.limited_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_collaborator.limited_access IS 'Limited Access';


--
-- Name: COLUMN project_collaborator.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_collaborator.create_date IS 'Created on';


--
-- Name: COLUMN project_collaborator.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_collaborator.write_date IS 'Last Updated on';


--
-- Name: project_collaborator_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_collaborator_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_collaborator_id_seq OWNER TO runbot;

--
-- Name: project_collaborator_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_collaborator_id_seq OWNED BY public.project_collaborator.id;


--
-- Name: project_favorite_user_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_favorite_user_rel (
    project_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.project_favorite_user_rel OWNER TO runbot;

--
-- Name: TABLE project_favorite_user_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_favorite_user_rel IS 'RELATION BETWEEN project_project AND res_users';


--
-- Name: project_milestone; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_milestone (
    id integer NOT NULL,
    sequence integer,
    project_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    deadline date,
    reached_date date,
    is_reached boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_milestone OWNER TO runbot;

--
-- Name: TABLE project_milestone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_milestone IS 'Project Milestone';


--
-- Name: COLUMN project_milestone.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.sequence IS 'Sequence';


--
-- Name: COLUMN project_milestone.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.project_id IS 'Project';


--
-- Name: COLUMN project_milestone.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.create_uid IS 'Created by';


--
-- Name: COLUMN project_milestone.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_milestone.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.name IS 'Name';


--
-- Name: COLUMN project_milestone.deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.deadline IS 'Deadline';


--
-- Name: COLUMN project_milestone.reached_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.reached_date IS 'Reached Date';


--
-- Name: COLUMN project_milestone.is_reached; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.is_reached IS 'Reached';


--
-- Name: COLUMN project_milestone.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.create_date IS 'Created on';


--
-- Name: COLUMN project_milestone.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_milestone.write_date IS 'Last Updated on';


--
-- Name: project_milestone_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_milestone_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_milestone_id_seq OWNER TO runbot;

--
-- Name: project_milestone_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_milestone_id_seq OWNED BY public.project_milestone.id;


--
-- Name: project_project; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_project (
    id integer NOT NULL,
    account_id integer,
    alias_id integer NOT NULL,
    sequence integer,
    partner_id integer,
    company_id integer,
    color integer,
    user_id integer,
    stage_id integer,
    last_update_id integer,
    create_uid integer,
    write_uid integer,
    access_token character varying,
    privacy_visibility character varying NOT NULL,
    last_update_status character varying NOT NULL,
    date_start date,
    date date,
    name jsonb NOT NULL,
    label_tasks jsonb,
    task_properties_definition jsonb,
    description text,
    active boolean,
    allow_task_dependencies boolean,
    allow_milestones boolean,
    allow_recurring_tasks boolean,
    is_template boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    x_plan2_id integer,
    x_plan3_id integer,
    allow_timesheets boolean,
    allocated_hours double precision,
    allow_tickets boolean,
    CONSTRAINT project_project_project_date_greater CHECK ((date >= date_start))
);


ALTER TABLE public.project_project OWNER TO runbot;

--
-- Name: TABLE project_project; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_project IS 'Project';


--
-- Name: COLUMN project_project.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.account_id IS 'Project Account';


--
-- Name: COLUMN project_project.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.alias_id IS 'Alias';


--
-- Name: COLUMN project_project.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.sequence IS 'Sequence';


--
-- Name: COLUMN project_project.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.partner_id IS 'Customer';


--
-- Name: COLUMN project_project.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.company_id IS 'Company';


--
-- Name: COLUMN project_project.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.color IS 'Color Index';


--
-- Name: COLUMN project_project.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.user_id IS 'Project Manager';


--
-- Name: COLUMN project_project.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.stage_id IS 'Stage';


--
-- Name: COLUMN project_project.last_update_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.last_update_id IS 'Last Update';


--
-- Name: COLUMN project_project.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.create_uid IS 'Created by';


--
-- Name: COLUMN project_project.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_project.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.access_token IS 'Security Token';


--
-- Name: COLUMN project_project.privacy_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.privacy_visibility IS 'Visibility';


--
-- Name: COLUMN project_project.last_update_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.last_update_status IS 'Last Update Status';


--
-- Name: COLUMN project_project.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.date_start IS 'Start Date';


--
-- Name: COLUMN project_project.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.date IS 'Expiration Date';


--
-- Name: COLUMN project_project.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.name IS 'Name';


--
-- Name: COLUMN project_project.label_tasks; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.label_tasks IS 'Use Tasks as';


--
-- Name: COLUMN project_project.task_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.task_properties_definition IS 'Task Properties';


--
-- Name: COLUMN project_project.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.description IS 'Description';


--
-- Name: COLUMN project_project.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.active IS 'Active';


--
-- Name: COLUMN project_project.allow_task_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.allow_task_dependencies IS 'Task Dependencies';


--
-- Name: COLUMN project_project.allow_milestones; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.allow_milestones IS 'Milestones';


--
-- Name: COLUMN project_project.allow_recurring_tasks; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.allow_recurring_tasks IS 'Recurring Tasks';


--
-- Name: COLUMN project_project.is_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.is_template IS 'Is Template';


--
-- Name: COLUMN project_project.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.create_date IS 'Created on';


--
-- Name: COLUMN project_project.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.write_date IS 'Last Updated on';


--
-- Name: COLUMN project_project.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.x_plan2_id IS 'Departments';


--
-- Name: COLUMN project_project.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.x_plan3_id IS 'Internal';


--
-- Name: COLUMN project_project.allow_timesheets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.allow_timesheets IS 'Timesheets';


--
-- Name: COLUMN project_project.allocated_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.allocated_hours IS 'Allocated Time';


--
-- Name: COLUMN project_project.allow_tickets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project.allow_tickets IS 'Allow tickets';


--
-- Name: CONSTRAINT project_project_project_date_greater ON project_project; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT project_project_project_date_greater ON public.project_project IS 'check(date >= date_start)';


--
-- Name: project_project_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_project_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_project_id_seq OWNER TO runbot;

--
-- Name: project_project_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_project_id_seq OWNED BY public.project_project.id;


--
-- Name: project_project_project_tags_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_project_project_tags_rel (
    project_project_id integer NOT NULL,
    project_tags_id integer NOT NULL
);


ALTER TABLE public.project_project_project_tags_rel OWNER TO runbot;

--
-- Name: TABLE project_project_project_tags_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_project_project_tags_rel IS 'RELATION BETWEEN project_project AND project_tags';


--
-- Name: project_project_project_task_type_delete_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_project_project_task_type_delete_wizard_rel (
    project_task_type_delete_wizard_id integer NOT NULL,
    project_project_id integer NOT NULL
);


ALTER TABLE public.project_project_project_task_type_delete_wizard_rel OWNER TO runbot;

--
-- Name: TABLE project_project_project_task_type_delete_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_project_project_task_type_delete_wizard_rel IS 'RELATION BETWEEN project_task_type_delete_wizard AND project_project';


--
-- Name: project_project_stage; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_project_stage (
    id integer NOT NULL,
    sequence integer,
    mail_template_id integer,
    company_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    fold boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer
);


ALTER TABLE public.project_project_stage OWNER TO runbot;

--
-- Name: TABLE project_project_stage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_project_stage IS 'Project Stage';


--
-- Name: COLUMN project_project_stage.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.sequence IS 'Sequence';


--
-- Name: COLUMN project_project_stage.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.mail_template_id IS 'Email Template';


--
-- Name: COLUMN project_project_stage.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.company_id IS 'Company';


--
-- Name: COLUMN project_project_stage.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.color IS 'Color';


--
-- Name: COLUMN project_project_stage.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.create_uid IS 'Created by';


--
-- Name: COLUMN project_project_stage.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_project_stage.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.name IS 'Name';


--
-- Name: COLUMN project_project_stage.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.active IS 'Active';


--
-- Name: COLUMN project_project_stage.fold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.fold IS 'Folded';


--
-- Name: COLUMN project_project_stage.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.create_date IS 'Created on';


--
-- Name: COLUMN project_project_stage.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.write_date IS 'Last Updated on';


--
-- Name: COLUMN project_project_stage.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage.sms_template_id IS 'SMS Template';


--
-- Name: project_project_stage_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_project_stage_delete_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_project_stage_delete_wizard OWNER TO runbot;

--
-- Name: TABLE project_project_stage_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_project_stage_delete_wizard IS 'Project Stage Delete Wizard';


--
-- Name: COLUMN project_project_stage_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN project_project_stage_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_project_stage_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN project_project_stage_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_project_stage_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: project_project_stage_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_project_stage_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_project_stage_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: project_project_stage_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_project_stage_delete_wizard_id_seq OWNED BY public.project_project_stage_delete_wizard.id;


--
-- Name: project_project_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_project_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_project_stage_id_seq OWNER TO runbot;

--
-- Name: project_project_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_project_stage_id_seq OWNED BY public.project_project_stage.id;


--
-- Name: project_project_stage_project_project_stage_delete_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_project_stage_project_project_stage_delete_wizard_rel (
    project_project_stage_delete_wizard_id integer NOT NULL,
    project_project_stage_id integer NOT NULL
);


ALTER TABLE public.project_project_stage_project_project_stage_delete_wizard_rel OWNER TO runbot;

--
-- Name: TABLE project_project_stage_project_project_stage_delete_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_project_stage_project_project_stage_delete_wizard_rel IS 'RELATION BETWEEN project_project_stage_delete_wizard AND project_project_stage';


--
-- Name: project_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_role (
    id integer NOT NULL,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_role OWNER TO runbot;

--
-- Name: TABLE project_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_role IS 'Project Role';


--
-- Name: COLUMN project_role.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_role.color IS 'Color';


--
-- Name: COLUMN project_role.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_role.sequence IS 'Sequence';


--
-- Name: COLUMN project_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_role.create_uid IS 'Created by';


--
-- Name: COLUMN project_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_role.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_role.name IS 'Name';


--
-- Name: COLUMN project_role.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_role.active IS 'Active';


--
-- Name: COLUMN project_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_role.create_date IS 'Created on';


--
-- Name: COLUMN project_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_role.write_date IS 'Last Updated on';


--
-- Name: project_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_role_id_seq OWNER TO runbot;

--
-- Name: project_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_role_id_seq OWNED BY public.project_role.id;


--
-- Name: project_role_project_task_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_role_project_task_rel (
    project_task_id integer NOT NULL,
    project_role_id integer NOT NULL
);


ALTER TABLE public.project_role_project_task_rel OWNER TO runbot;

--
-- Name: TABLE project_role_project_task_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_role_project_task_rel IS 'RELATION BETWEEN project_task AND project_role';


--
-- Name: project_share_collaborator_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_share_collaborator_wizard (
    id integer NOT NULL,
    parent_wizard_id integer,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    access_mode character varying NOT NULL,
    send_invitation boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_share_collaborator_wizard OWNER TO runbot;

--
-- Name: TABLE project_share_collaborator_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_share_collaborator_wizard IS 'Project Sharing Collaborator Wizard';


--
-- Name: COLUMN project_share_collaborator_wizard.parent_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_collaborator_wizard.parent_wizard_id IS 'Parent Wizard';


--
-- Name: COLUMN project_share_collaborator_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_collaborator_wizard.partner_id IS 'Collaborator';


--
-- Name: COLUMN project_share_collaborator_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_collaborator_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN project_share_collaborator_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_collaborator_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_share_collaborator_wizard.access_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_collaborator_wizard.access_mode IS 'Access Mode';


--
-- Name: COLUMN project_share_collaborator_wizard.send_invitation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_collaborator_wizard.send_invitation IS 'Send Invitation';


--
-- Name: COLUMN project_share_collaborator_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_collaborator_wizard.create_date IS 'Created on';


--
-- Name: COLUMN project_share_collaborator_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_collaborator_wizard.write_date IS 'Last Updated on';


--
-- Name: project_share_collaborator_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_share_collaborator_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_share_collaborator_wizard_id_seq OWNER TO runbot;

--
-- Name: project_share_collaborator_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_share_collaborator_wizard_id_seq OWNED BY public.project_share_collaborator_wizard.id;


--
-- Name: project_share_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_share_wizard (
    id integer NOT NULL,
    res_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_share_wizard OWNER TO runbot;

--
-- Name: TABLE project_share_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_share_wizard IS 'Project Sharing';


--
-- Name: COLUMN project_share_wizard.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_wizard.res_id IS 'Related Document ID';


--
-- Name: COLUMN project_share_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN project_share_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_share_wizard.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_wizard.res_model IS 'Related Document Model';


--
-- Name: COLUMN project_share_wizard.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_wizard.note IS 'Note';


--
-- Name: COLUMN project_share_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_wizard.create_date IS 'Created on';


--
-- Name: COLUMN project_share_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_share_wizard.write_date IS 'Last Updated on';


--
-- Name: project_share_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_share_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_share_wizard_id_seq OWNER TO runbot;

--
-- Name: project_share_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_share_wizard_id_seq OWNED BY public.project_share_wizard.id;


--
-- Name: project_share_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_share_wizard_res_partner_rel (
    project_share_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.project_share_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE project_share_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_share_wizard_res_partner_rel IS 'RELATION BETWEEN project_share_wizard AND res_partner';


--
-- Name: project_tags; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_tags (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_tags OWNER TO runbot;

--
-- Name: TABLE project_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_tags IS 'Project Tags';


--
-- Name: COLUMN project_tags.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_tags.color IS 'Color';


--
-- Name: COLUMN project_tags.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_tags.create_uid IS 'Created by';


--
-- Name: COLUMN project_tags.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_tags.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_tags.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_tags.name IS 'Name';


--
-- Name: COLUMN project_tags.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_tags.create_date IS 'Created on';


--
-- Name: COLUMN project_tags.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_tags.write_date IS 'Last Updated on';


--
-- Name: project_tags_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_tags_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_tags_id_seq OWNER TO runbot;

--
-- Name: project_tags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_tags_id_seq OWNED BY public.project_tags.id;


--
-- Name: project_tags_project_task_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_tags_project_task_rel (
    project_task_id integer NOT NULL,
    project_tags_id integer NOT NULL
);


ALTER TABLE public.project_tags_project_task_rel OWNER TO runbot;

--
-- Name: TABLE project_tags_project_task_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_tags_project_task_rel IS 'RELATION BETWEEN project_task AND project_tags';


--
-- Name: project_task; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_task (
    id integer NOT NULL,
    sequence integer,
    stage_id integer,
    project_id integer,
    partner_id integer,
    company_id integer,
    color integer,
    displayed_image_id integer,
    parent_id integer,
    milestone_id integer,
    recurrence_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    access_token character varying,
    name character varying NOT NULL,
    priority character varying,
    state character varying NOT NULL,
    partner_phone character varying,
    email_from character varying,
    html_field_history jsonb,
    task_properties jsonb,
    description text,
    working_hours_open numeric,
    working_hours_close numeric,
    active boolean,
    display_in_project boolean,
    recurring_task boolean,
    is_template boolean,
    has_template_ancestor boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    date_end timestamp without time zone,
    date_assign timestamp without time zone,
    date_deadline timestamp without time zone,
    date_last_stage_update timestamp without time zone,
    rating_last_value double precision,
    allocated_hours double precision,
    working_days_open double precision,
    working_days_close double precision,
    planned_date_begin timestamp without time zone,
    remaining_hours double precision,
    effective_hours double precision,
    total_hours_spent double precision,
    progress double precision,
    overtime double precision,
    subtask_effective_hours double precision,
    CONSTRAINT project_task_planned_dates_check CHECK ((planned_date_begin <= date_deadline)),
    CONSTRAINT project_task_private_task_has_no_parent CHECK ((NOT ((project_id IS NULL) AND (parent_id IS NOT NULL)))),
    CONSTRAINT project_task_recurring_task_has_no_parent CHECK ((NOT ((recurring_task IS TRUE) AND (parent_id IS NOT NULL))))
);


ALTER TABLE public.project_task OWNER TO runbot;

--
-- Name: TABLE project_task; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_task IS 'Task';


--
-- Name: COLUMN project_task.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.sequence IS 'Sequence';


--
-- Name: COLUMN project_task.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.stage_id IS 'Stage';


--
-- Name: COLUMN project_task.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.project_id IS 'Project';


--
-- Name: COLUMN project_task.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.partner_id IS 'Customer';


--
-- Name: COLUMN project_task.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.company_id IS 'Company';


--
-- Name: COLUMN project_task.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.color IS 'Color Index';


--
-- Name: COLUMN project_task.displayed_image_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.displayed_image_id IS 'Cover Image';


--
-- Name: COLUMN project_task.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.parent_id IS 'Parent Task';


--
-- Name: COLUMN project_task.milestone_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.milestone_id IS 'Milestone';


--
-- Name: COLUMN project_task.recurrence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.recurrence_id IS 'Recurrence';


--
-- Name: COLUMN project_task.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.create_uid IS 'Created by';


--
-- Name: COLUMN project_task.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_task.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.email_cc IS 'Email cc';


--
-- Name: COLUMN project_task.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.access_token IS 'Security Token';


--
-- Name: COLUMN project_task.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.name IS 'Title';


--
-- Name: COLUMN project_task.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.priority IS 'Priority';


--
-- Name: COLUMN project_task.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.state IS 'State';


--
-- Name: COLUMN project_task.partner_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.partner_phone IS 'Contact Number';


--
-- Name: COLUMN project_task.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.email_from IS 'Email From';


--
-- Name: COLUMN project_task.html_field_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.html_field_history IS 'History data';


--
-- Name: COLUMN project_task.task_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.task_properties IS 'Properties';


--
-- Name: COLUMN project_task.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.description IS 'Description';


--
-- Name: COLUMN project_task.working_hours_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.working_hours_open IS 'Working Hours to Assign';


--
-- Name: COLUMN project_task.working_hours_close; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.working_hours_close IS 'Working Hours to Close';


--
-- Name: COLUMN project_task.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.active IS 'Active';


--
-- Name: COLUMN project_task.display_in_project; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.display_in_project IS 'Display In Project';


--
-- Name: COLUMN project_task.recurring_task; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.recurring_task IS 'Recurrent';


--
-- Name: COLUMN project_task.is_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.is_template IS 'Is Template';


--
-- Name: COLUMN project_task.has_template_ancestor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.has_template_ancestor IS 'Has Template Ancestor';


--
-- Name: COLUMN project_task.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.create_date IS 'Created On';


--
-- Name: COLUMN project_task.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.write_date IS 'Last Updated On';


--
-- Name: COLUMN project_task.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.date_end IS 'Ending Date';


--
-- Name: COLUMN project_task.date_assign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.date_assign IS 'Assigning Date';


--
-- Name: COLUMN project_task.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.date_deadline IS 'Deadline';


--
-- Name: COLUMN project_task.date_last_stage_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN project_task.rating_last_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.rating_last_value IS 'Rating Last Value';


--
-- Name: COLUMN project_task.allocated_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.allocated_hours IS 'Allocated Time';


--
-- Name: COLUMN project_task.working_days_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.working_days_open IS 'Working Days to Assign';


--
-- Name: COLUMN project_task.working_days_close; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.working_days_close IS 'Working Days to Close';


--
-- Name: COLUMN project_task.planned_date_begin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.planned_date_begin IS 'Start date';


--
-- Name: COLUMN project_task.remaining_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.remaining_hours IS 'Time Remaining';


--
-- Name: COLUMN project_task.effective_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.effective_hours IS 'Time Spent';


--
-- Name: COLUMN project_task.total_hours_spent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.total_hours_spent IS 'Total Time Spent';


--
-- Name: COLUMN project_task.progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.progress IS 'Progress';


--
-- Name: COLUMN project_task.overtime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.overtime IS 'Overtime';


--
-- Name: COLUMN project_task.subtask_effective_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task.subtask_effective_hours IS 'Time Spent on Sub-tasks';


--
-- Name: CONSTRAINT project_task_planned_dates_check ON project_task; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT project_task_planned_dates_check ON public.project_task IS 'CHECK ((planned_date_begin <= date_deadline))';


--
-- Name: CONSTRAINT project_task_private_task_has_no_parent ON project_task; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT project_task_private_task_has_no_parent ON public.project_task IS 'CHECK (NOT (project_id IS NULL AND parent_id IS NOT NULL))';


--
-- Name: CONSTRAINT project_task_recurring_task_has_no_parent ON project_task; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT project_task_recurring_task_has_no_parent ON public.project_task IS 'CHECK (NOT (recurring_task IS TRUE AND parent_id IS NOT NULL))';


--
-- Name: project_task_convert_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_task_convert_wizard (
    id integer NOT NULL,
    team_id integer,
    stage_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_task_convert_wizard OWNER TO runbot;

--
-- Name: TABLE project_task_convert_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_task_convert_wizard IS 'Convert Project Tasks to Tickets';


--
-- Name: COLUMN project_task_convert_wizard.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_convert_wizard.team_id IS 'Team';


--
-- Name: COLUMN project_task_convert_wizard.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_convert_wizard.stage_id IS 'Stage';


--
-- Name: COLUMN project_task_convert_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_convert_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN project_task_convert_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_convert_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_task_convert_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_convert_wizard.create_date IS 'Created on';


--
-- Name: COLUMN project_task_convert_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_convert_wizard.write_date IS 'Last Updated on';


--
-- Name: project_task_convert_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_task_convert_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_task_convert_wizard_id_seq OWNER TO runbot;

--
-- Name: project_task_convert_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_task_convert_wizard_id_seq OWNED BY public.project_task_convert_wizard.id;


--
-- Name: project_task_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_task_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_task_id_seq OWNER TO runbot;

--
-- Name: project_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_task_id_seq OWNED BY public.project_task.id;


--
-- Name: project_task_recurrence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_task_recurrence (
    id integer NOT NULL,
    repeat_interval integer,
    create_uid integer,
    write_uid integer,
    repeat_unit character varying,
    repeat_type character varying,
    repeat_until date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_task_recurrence OWNER TO runbot;

--
-- Name: TABLE project_task_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_task_recurrence IS 'Task Recurrence';


--
-- Name: COLUMN project_task_recurrence.repeat_interval; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_recurrence.repeat_interval IS 'Repeat Every';


--
-- Name: COLUMN project_task_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN project_task_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_task_recurrence.repeat_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_recurrence.repeat_unit IS 'Repeat Unit';


--
-- Name: COLUMN project_task_recurrence.repeat_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_recurrence.repeat_type IS 'Until';


--
-- Name: COLUMN project_task_recurrence.repeat_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_recurrence.repeat_until IS 'End Date';


--
-- Name: COLUMN project_task_recurrence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN project_task_recurrence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_recurrence.write_date IS 'Last Updated on';


--
-- Name: project_task_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_task_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_task_recurrence_id_seq OWNER TO runbot;

--
-- Name: project_task_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_task_recurrence_id_seq OWNED BY public.project_task_recurrence.id;


--
-- Name: project_task_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_task_type (
    id integer NOT NULL,
    sequence integer,
    mail_template_id integer,
    color integer,
    rating_template_id integer,
    rotting_threshold_days integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    rating_status character varying NOT NULL,
    rating_status_period character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    fold boolean,
    auto_validation_state boolean,
    rating_active boolean,
    rating_request_deadline timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer
);


ALTER TABLE public.project_task_type OWNER TO runbot;

--
-- Name: TABLE project_task_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_task_type IS 'Task Stage';


--
-- Name: COLUMN project_task_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.sequence IS 'Sequence';


--
-- Name: COLUMN project_task_type.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.mail_template_id IS 'Email Template';


--
-- Name: COLUMN project_task_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.color IS 'Color';


--
-- Name: COLUMN project_task_type.rating_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.rating_template_id IS 'Rating Email Template';


--
-- Name: COLUMN project_task_type.rotting_threshold_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.rotting_threshold_days IS 'Days to rot';


--
-- Name: COLUMN project_task_type.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.user_id IS 'Stage Owner';


--
-- Name: COLUMN project_task_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.create_uid IS 'Created by';


--
-- Name: COLUMN project_task_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_task_type.rating_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.rating_status IS 'Customer Ratings Status';


--
-- Name: COLUMN project_task_type.rating_status_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.rating_status_period IS 'Rating Frequency';


--
-- Name: COLUMN project_task_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.name IS 'Name';


--
-- Name: COLUMN project_task_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.active IS 'Active';


--
-- Name: COLUMN project_task_type.fold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.fold IS 'Folded';


--
-- Name: COLUMN project_task_type.auto_validation_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.auto_validation_state IS 'Automatic Kanban Status';


--
-- Name: COLUMN project_task_type.rating_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.rating_active IS 'Send a customer rating request';


--
-- Name: COLUMN project_task_type.rating_request_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.rating_request_deadline IS 'Rating Request Deadline';


--
-- Name: COLUMN project_task_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.create_date IS 'Created on';


--
-- Name: COLUMN project_task_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN project_task_type.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type.sms_template_id IS 'SMS Template';


--
-- Name: project_task_type_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_task_type_delete_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_task_type_delete_wizard OWNER TO runbot;

--
-- Name: TABLE project_task_type_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_task_type_delete_wizard IS 'Project Task Stage Delete Wizard';


--
-- Name: COLUMN project_task_type_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN project_task_type_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_task_type_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN project_task_type_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_type_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: project_task_type_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_task_type_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_task_type_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: project_task_type_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_task_type_delete_wizard_id_seq OWNED BY public.project_task_type_delete_wizard.id;


--
-- Name: project_task_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_task_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_task_type_id_seq OWNER TO runbot;

--
-- Name: project_task_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_task_type_id_seq OWNED BY public.project_task_type.id;


--
-- Name: project_task_type_project_task_type_delete_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_task_type_project_task_type_delete_wizard_rel (
    project_task_type_delete_wizard_id integer NOT NULL,
    project_task_type_id integer NOT NULL
);


ALTER TABLE public.project_task_type_project_task_type_delete_wizard_rel OWNER TO runbot;

--
-- Name: TABLE project_task_type_project_task_type_delete_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_task_type_project_task_type_delete_wizard_rel IS 'RELATION BETWEEN project_task_type_delete_wizard AND project_task_type';


--
-- Name: project_task_type_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_task_type_rel (
    project_id integer NOT NULL,
    type_id integer NOT NULL
);


ALTER TABLE public.project_task_type_rel OWNER TO runbot;

--
-- Name: TABLE project_task_type_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_task_type_rel IS 'RELATION BETWEEN project_project AND project_task_type';


--
-- Name: project_task_user_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_task_user_rel (
    id integer NOT NULL,
    task_id integer NOT NULL,
    user_id integer NOT NULL,
    stage_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_task_user_rel OWNER TO runbot;

--
-- Name: TABLE project_task_user_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_task_user_rel IS 'Personal Task Stage';


--
-- Name: COLUMN project_task_user_rel.task_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_user_rel.task_id IS 'Task';


--
-- Name: COLUMN project_task_user_rel.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_user_rel.user_id IS 'User';


--
-- Name: COLUMN project_task_user_rel.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_user_rel.stage_id IS 'Stage';


--
-- Name: COLUMN project_task_user_rel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_user_rel.create_uid IS 'Created by';


--
-- Name: COLUMN project_task_user_rel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_user_rel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_task_user_rel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_user_rel.create_date IS 'Created on';


--
-- Name: COLUMN project_task_user_rel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_task_user_rel.write_date IS 'Last Updated on';


--
-- Name: project_task_user_rel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_task_user_rel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_task_user_rel_id_seq OWNER TO runbot;

--
-- Name: project_task_user_rel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_task_user_rel_id_seq OWNED BY public.project_task_user_rel.id;


--
-- Name: project_template_create_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_template_create_wizard (
    id integer NOT NULL,
    alias_domain_id integer,
    template_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    alias_name character varying,
    date_start date,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_template_create_wizard OWNER TO runbot;

--
-- Name: TABLE project_template_create_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_template_create_wizard IS 'Project Template create Wizard';


--
-- Name: COLUMN project_template_create_wizard.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN project_template_create_wizard.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.template_id IS 'Template';


--
-- Name: COLUMN project_template_create_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN project_template_create_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_template_create_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.name IS 'Name';


--
-- Name: COLUMN project_template_create_wizard.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.alias_name IS 'Alias Name';


--
-- Name: COLUMN project_template_create_wizard.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.date_start IS 'Start Date';


--
-- Name: COLUMN project_template_create_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.date IS 'Expiration Date';


--
-- Name: COLUMN project_template_create_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.create_date IS 'Created on';


--
-- Name: COLUMN project_template_create_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_create_wizard.write_date IS 'Last Updated on';


--
-- Name: project_template_create_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_template_create_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_template_create_wizard_id_seq OWNER TO runbot;

--
-- Name: project_template_create_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_template_create_wizard_id_seq OWNED BY public.project_template_create_wizard.id;


--
-- Name: project_template_role_to_users_map; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_template_role_to_users_map (
    id integer NOT NULL,
    wizard_id integer,
    role_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.project_template_role_to_users_map OWNER TO runbot;

--
-- Name: TABLE project_template_role_to_users_map; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_template_role_to_users_map IS 'Project role to users mapping';


--
-- Name: COLUMN project_template_role_to_users_map.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_role_to_users_map.wizard_id IS 'Wizard';


--
-- Name: COLUMN project_template_role_to_users_map.role_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_role_to_users_map.role_id IS 'Project Role';


--
-- Name: COLUMN project_template_role_to_users_map.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_role_to_users_map.create_uid IS 'Created by';


--
-- Name: COLUMN project_template_role_to_users_map.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_role_to_users_map.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_template_role_to_users_map.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_role_to_users_map.create_date IS 'Created on';


--
-- Name: COLUMN project_template_role_to_users_map.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_template_role_to_users_map.write_date IS 'Last Updated on';


--
-- Name: project_template_role_to_users_map_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_template_role_to_users_map_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_template_role_to_users_map_id_seq OWNER TO runbot;

--
-- Name: project_template_role_to_users_map_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_template_role_to_users_map_id_seq OWNED BY public.project_template_role_to_users_map.id;


--
-- Name: project_template_role_to_users_map_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_template_role_to_users_map_res_users_rel (
    project_template_role_to_users_map_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.project_template_role_to_users_map_res_users_rel OWNER TO runbot;

--
-- Name: TABLE project_template_role_to_users_map_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_template_role_to_users_map_res_users_rel IS 'RELATION BETWEEN project_template_role_to_users_map AND res_users';


--
-- Name: project_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.project_update (
    id integer NOT NULL,
    progress integer,
    user_id integer NOT NULL,
    project_id integer NOT NULL,
    task_count integer,
    closed_task_count integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    name character varying NOT NULL,
    status character varying NOT NULL,
    date date,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    allocated_time integer,
    timesheet_time integer,
    uom_id integer
);


ALTER TABLE public.project_update OWNER TO runbot;

--
-- Name: TABLE project_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.project_update IS 'Project Update';


--
-- Name: COLUMN project_update.progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.progress IS 'Progress';


--
-- Name: COLUMN project_update.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.user_id IS 'Author';


--
-- Name: COLUMN project_update.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.project_id IS 'Project';


--
-- Name: COLUMN project_update.task_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.task_count IS 'Task Count';


--
-- Name: COLUMN project_update.closed_task_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.closed_task_count IS 'Closed Task Count';


--
-- Name: COLUMN project_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.create_uid IS 'Created by';


--
-- Name: COLUMN project_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN project_update.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.email_cc IS 'Email cc';


--
-- Name: COLUMN project_update.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.name IS 'Title';


--
-- Name: COLUMN project_update.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.status IS 'Status';


--
-- Name: COLUMN project_update.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.date IS 'Date';


--
-- Name: COLUMN project_update.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.description IS 'Description';


--
-- Name: COLUMN project_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.create_date IS 'Created on';


--
-- Name: COLUMN project_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.write_date IS 'Last Updated on';


--
-- Name: COLUMN project_update.allocated_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.allocated_time IS 'Allocated Time';


--
-- Name: COLUMN project_update.timesheet_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.timesheet_time IS 'Timesheet Time';


--
-- Name: COLUMN project_update.uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.project_update.uom_id IS 'Unit';


--
-- Name: project_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.project_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.project_update_id_seq OWNER TO runbot;

--
-- Name: project_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.project_update_id_seq OWNED BY public.project_update.id;


--
-- Name: properties_base_definition; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.properties_base_definition (
    id integer NOT NULL,
    properties_field_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    properties_definition jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.properties_base_definition OWNER TO runbot;

--
-- Name: TABLE properties_base_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.properties_base_definition IS 'Properties Base Definition';


--
-- Name: COLUMN properties_base_definition.properties_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.properties_field_id IS 'Properties Field';


--
-- Name: COLUMN properties_base_definition.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.create_uid IS 'Created by';


--
-- Name: COLUMN properties_base_definition.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.write_uid IS 'Last Updated by';


--
-- Name: COLUMN properties_base_definition.properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.properties_definition IS 'Properties Definition';


--
-- Name: COLUMN properties_base_definition.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.create_date IS 'Created on';


--
-- Name: COLUMN properties_base_definition.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.write_date IS 'Last Updated on';


--
-- Name: properties_base_definition_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.properties_base_definition_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.properties_base_definition_id_seq OWNER TO runbot;

--
-- Name: properties_base_definition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.properties_base_definition_id_seq OWNED BY public.properties_base_definition.id;


--
-- Name: rating_rating; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rating_rating (
    id integer NOT NULL,
    res_model_id integer,
    res_id integer NOT NULL,
    parent_res_model_id integer,
    parent_res_id integer,
    rated_partner_id integer,
    partner_id integer,
    message_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    parent_res_name character varying,
    parent_res_model character varying,
    rating_text character varying,
    access_token character varying,
    feedback text,
    is_internal boolean,
    consumed boolean,
    create_date timestamp without time zone,
    rated_on timestamp without time zone,
    write_date timestamp without time zone,
    rating double precision,
    publisher_id integer,
    publisher_comment text,
    publisher_datetime timestamp without time zone,
    CONSTRAINT rating_rating_rating_range CHECK (((rating >= (0)::double precision) AND (rating <= (5)::double precision)))
);


ALTER TABLE public.rating_rating OWNER TO runbot;

--
-- Name: TABLE rating_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rating_rating IS 'Rating';


--
-- Name: COLUMN rating_rating.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN rating_rating.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.res_id IS 'Document';


--
-- Name: COLUMN rating_rating.parent_res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.parent_res_model_id IS 'Parent Related Document Model';


--
-- Name: COLUMN rating_rating.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.parent_res_id IS 'Parent Document';


--
-- Name: COLUMN rating_rating.rated_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.rated_partner_id IS 'Rated Operator';


--
-- Name: COLUMN rating_rating.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.partner_id IS 'Customer';


--
-- Name: COLUMN rating_rating.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.message_id IS 'Message';


--
-- Name: COLUMN rating_rating.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.create_uid IS 'Created by';


--
-- Name: COLUMN rating_rating.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.write_uid IS 'Last Updated by';


--
-- Name: COLUMN rating_rating.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.res_name IS 'Resource name';


--
-- Name: COLUMN rating_rating.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.res_model IS 'Document Model';


--
-- Name: COLUMN rating_rating.parent_res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.parent_res_name IS 'Parent Document Name';


--
-- Name: COLUMN rating_rating.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.parent_res_model IS 'Parent Document Model';


--
-- Name: COLUMN rating_rating.rating_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.rating_text IS 'Rating';


--
-- Name: COLUMN rating_rating.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.access_token IS 'Security Token';


--
-- Name: COLUMN rating_rating.feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.feedback IS 'Comment';


--
-- Name: COLUMN rating_rating.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.is_internal IS 'Visible Internally Only';


--
-- Name: COLUMN rating_rating.consumed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.consumed IS 'Filled Rating';


--
-- Name: COLUMN rating_rating.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.create_date IS 'Submitted on';


--
-- Name: COLUMN rating_rating.rated_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.rated_on IS 'Rated On';


--
-- Name: COLUMN rating_rating.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.write_date IS 'Last Updated on';


--
-- Name: COLUMN rating_rating.rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.rating IS 'Rating Value';


--
-- Name: COLUMN rating_rating.publisher_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.publisher_id IS 'Commented by';


--
-- Name: COLUMN rating_rating.publisher_comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.publisher_comment IS 'Publisher comment';


--
-- Name: COLUMN rating_rating.publisher_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.rating_rating.publisher_datetime IS 'Commented on';


--
-- Name: CONSTRAINT rating_rating_rating_range ON rating_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT rating_rating_rating_range ON public.rating_rating IS 'check(rating >= 0 and rating <= 5)';


--
-- Name: rating_rating_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.rating_rating_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.rating_rating_id_seq OWNER TO runbot;

--
-- Name: rating_rating_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.rating_rating_id_seq OWNED BY public.rating_rating.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    css_margins boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.css_margins; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.css_margins IS 'Use css margins';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: report_project_task_user; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.report_project_task_user AS
SELECT
    NULL::integer AS nbr,
    NULL::integer AS id,
    NULL::integer AS task_id,
    NULL::timestamp without time zone AS create_date,
    NULL::timestamp without time zone AS date_assign,
    NULL::timestamp without time zone AS date_end,
    NULL::timestamp without time zone AS date_last_stage_update,
    NULL::timestamp without time zone AS date_deadline,
    NULL::boolean AS display_in_project,
    NULL::integer AS project_id,
    NULL::character varying AS priority,
    NULL::character varying AS name,
    NULL::integer AS company_id,
    NULL::integer AS partner_id,
    NULL::integer AS parent_id,
    NULL::integer AS stage_id,
    NULL::character varying AS state,
    NULL::integer AS milestone_id,
    NULL::boolean AS is_closed,
    NULL::boolean AS has_late_and_unreached_milestone,
    NULL::text AS description,
    NULL::double precision AS rating_last_value,
    NULL::double precision AS rating_avg,
    NULL::double precision AS working_days_close,
    NULL::double precision AS working_days_open,
    NULL::numeric AS working_hours_open,
    NULL::numeric AS working_hours_close,
    NULL::numeric AS delay_endings_days,
    NULL::bigint AS dependent_ids_count,
    NULL::boolean AS is_template,
    NULL::boolean AS has_template_ancestor,
    NULL::timestamp without time zone AS planned_date_begin,
    NULL::double precision AS progress,
    NULL::double precision AS effective_hours,
    NULL::double precision AS remaining_hours,
    NULL::double precision AS remaining_hours_percentage,
    NULL::double precision AS allocated_hours,
    NULL::double precision AS overtime;


ALTER VIEW public.report_project_task_user OWNER TO runbot;

--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea,
    resource_calendar_id integer,
    alias_domain_id integer,
    email_primary_color character varying,
    email_secondary_color character varying,
    iap_enrich_auto_done boolean,
    snailmail_color boolean,
    snailmail_cover boolean,
    snailmail_duplex boolean,
    hr_presence_control_email_amount integer,
    contract_expiration_notice_period integer,
    work_permit_expiration_notice_period integer,
    hr_presence_control_ip_list character varying,
    employee_properties_definition jsonb,
    hr_presence_control_login boolean,
    hr_presence_control_email boolean,
    hr_presence_control_ip boolean,
    hr_presence_control_attendance boolean,
    project_time_mode_id integer,
    timesheet_encode_uom_id integer,
    internal_project_id integer,
    timesheet_mail_employee_delay integer,
    timesheet_mail_delay integer,
    timesheet_mail_employee_interval character varying NOT NULL,
    timesheet_mail_interval character varying NOT NULL,
    timesheet_mail_employee_allow boolean,
    timesheet_mail_allow boolean,
    timesheet_mail_employee_nextdate timestamp without time zone,
    timesheet_mail_nextdate timestamp without time zone
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.resource_calendar_id IS 'Default Working Hours';


--
-- Name: COLUMN res_company.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.alias_domain_id IS 'Email Domain';


--
-- Name: COLUMN res_company.email_primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_primary_color IS 'Email Button Text';


--
-- Name: COLUMN res_company.email_secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_secondary_color IS 'Email Button Color';


--
-- Name: COLUMN res_company.iap_enrich_auto_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.iap_enrich_auto_done IS 'Enrich Done';


--
-- Name: COLUMN res_company.snailmail_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_color IS 'Snailmail Color';


--
-- Name: COLUMN res_company.snailmail_cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN res_company.snailmail_duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_duplex IS 'Both sides';


--
-- Name: COLUMN res_company.hr_presence_control_email_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email_amount IS '# emails to send';


--
-- Name: COLUMN res_company.contract_expiration_notice_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.contract_expiration_notice_period IS 'Contract Expiry Notice Period';


--
-- Name: COLUMN res_company.work_permit_expiration_notice_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.work_permit_expiration_notice_period IS 'Work Permit Expiry Notice Period';


--
-- Name: COLUMN res_company.hr_presence_control_ip_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip_list IS 'Valid IP addresses';


--
-- Name: COLUMN res_company.employee_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.employee_properties_definition IS 'Employee Properties';


--
-- Name: COLUMN res_company.hr_presence_control_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_login IS 'Based on user status in system';


--
-- Name: COLUMN res_company.hr_presence_control_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email IS 'Based on number of emails sent';


--
-- Name: COLUMN res_company.hr_presence_control_ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip IS 'Based on IP Address';


--
-- Name: COLUMN res_company.hr_presence_control_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_attendance IS 'Based on attendances';


--
-- Name: COLUMN res_company.project_time_mode_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.project_time_mode_id IS 'Project Time Unit';


--
-- Name: COLUMN res_company.timesheet_encode_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_encode_uom_id IS 'Timesheet Encoding Unit';


--
-- Name: COLUMN res_company.internal_project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.internal_project_id IS 'Internal Project';


--
-- Name: COLUMN res_company.timesheet_mail_employee_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_delay IS 'Employee Reminder Days';


--
-- Name: COLUMN res_company.timesheet_mail_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_delay IS 'Approver Reminder Days';


--
-- Name: COLUMN res_company.timesheet_mail_employee_interval; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_interval IS 'Employee Frequency';


--
-- Name: COLUMN res_company.timesheet_mail_interval; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_interval IS 'Approver Reminder Frequency';


--
-- Name: COLUMN res_company.timesheet_mail_employee_allow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_allow IS 'Employee Reminder';


--
-- Name: COLUMN res_company.timesheet_mail_allow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_allow IS 'Approver Reminder';


--
-- Name: COLUMN res_company.timesheet_mail_employee_nextdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_nextdate IS 'Next scheduled date for employee reminder';


--
-- Name: COLUMN res_company.timesheet_mail_nextdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_nextdate IS 'Next scheduled date for approver reminder';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.res_company_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE res_company_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND res_company';


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    web_app_name character varying,
    company_id integer NOT NULL,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_sms boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    module_website_cf_turnstile boolean,
    module_google_address_autocomplete boolean,
    group_multi_currency boolean,
    show_effect boolean,
    profiling_enabled_until timestamp without time zone,
    map_box_token character varying,
    twilio_account_sid character varying,
    twilio_account_token character varying,
    sfu_server_url character varying,
    sfu_server_key character varying,
    tenor_api_key character varying,
    google_translate_api_key character varying,
    external_email_server_default boolean,
    module_google_gmail boolean,
    module_microsoft_outlook boolean,
    restrict_template_rendering boolean,
    use_twilio_rtc_servers boolean,
    use_sfu_server boolean,
    unsplash_access_key character varying,
    unsplash_app_id character varying,
    group_analytic_accounting boolean,
    auth_signup_template_user_id integer,
    auth_signup_uninvited character varying,
    auth_signup_reset_password boolean,
    auth_totp_policy character varying,
    auth_totp_enforce boolean,
    google_gmail_client_identifier character varying,
    google_gmail_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    disable_redirect_firebase_dynamic_link boolean,
    enable_ocn boolean,
    digest_id integer,
    digest_emails boolean,
    module_hr_presence boolean,
    module_hr_skills boolean,
    module_hr_timesheet boolean,
    group_project_stages boolean,
    module_project_timesheet_holidays boolean,
    reminder_user_allow boolean,
    reminder_allow boolean,
    timesheet_min_duration integer,
    timesheet_rounding integer,
    openai_key character varying,
    google_key character varying
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.web_app_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.web_app_name IS 'Web App Name';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'Phone';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_sms IS 'SMS';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.module_website_cf_turnstile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_website_cf_turnstile IS 'Cloudflare Turnstile';


--
-- Name: COLUMN res_config_settings.module_google_address_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_address_autocomplete IS 'Google Address Autocomplete';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.map_box_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.map_box_token IS 'Token Map Box';


--
-- Name: COLUMN res_config_settings.twilio_account_sid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_sid IS 'Account SID';


--
-- Name: COLUMN res_config_settings.twilio_account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_token IS 'Account Auth Token';


--
-- Name: COLUMN res_config_settings.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_url IS 'SFU Server URL';


--
-- Name: COLUMN res_config_settings.sfu_server_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_key IS 'SFU Server key';


--
-- Name: COLUMN res_config_settings.tenor_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.tenor_api_key IS 'Tenor API key';


--
-- Name: COLUMN res_config_settings.google_translate_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_translate_api_key IS 'Message Translation API Key';


--
-- Name: COLUMN res_config_settings.external_email_server_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.external_email_server_default IS 'Use Custom Email Servers';


--
-- Name: COLUMN res_config_settings.module_google_gmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_gmail IS 'Support Gmail Authentication';


--
-- Name: COLUMN res_config_settings.module_microsoft_outlook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_outlook IS 'Support Outlook Authentication';


--
-- Name: COLUMN res_config_settings.restrict_template_rendering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.restrict_template_rendering IS 'Restrict Template Rendering';


--
-- Name: COLUMN res_config_settings.use_twilio_rtc_servers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_twilio_rtc_servers IS 'Use Twilio ICE servers';


--
-- Name: COLUMN res_config_settings.use_sfu_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_sfu_server IS 'Use SFU server';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: COLUMN res_config_settings.group_analytic_accounting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_analytic_accounting IS 'Analytic Accounting';


--
-- Name: COLUMN res_config_settings.auth_signup_template_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_template_user_id IS 'Template user for new users created through signup';


--
-- Name: COLUMN res_config_settings.auth_signup_uninvited; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_uninvited IS 'Customer Account';


--
-- Name: COLUMN res_config_settings.auth_signup_reset_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_reset_password IS 'Enable password reset from Login page';


--
-- Name: COLUMN res_config_settings.auth_totp_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_totp_policy IS 'Two-factor authentication enforcing policy';


--
-- Name: COLUMN res_config_settings.auth_totp_enforce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_totp_enforce IS 'Enforce two-factor authentication';


--
-- Name: COLUMN res_config_settings.google_gmail_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_identifier IS 'Gmail Client Id';


--
-- Name: COLUMN res_config_settings.google_gmail_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_secret IS 'Gmail Client Secret';


--
-- Name: COLUMN res_config_settings.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN res_config_settings.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN res_config_settings.disable_redirect_firebase_dynamic_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.disable_redirect_firebase_dynamic_link IS 'Disable link redirection to mobile app';


--
-- Name: COLUMN res_config_settings.enable_ocn; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.enable_ocn IS 'Push Notifications';


--
-- Name: COLUMN res_config_settings.digest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.digest_id IS 'Digest Email';


--
-- Name: COLUMN res_config_settings.digest_emails; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.digest_emails IS 'Digest Emails';


--
-- Name: COLUMN res_config_settings.module_hr_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_hr_presence IS 'Advanced Presence Control';


--
-- Name: COLUMN res_config_settings.module_hr_skills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_hr_skills IS 'Skills Management';


--
-- Name: COLUMN res_config_settings.module_hr_timesheet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_hr_timesheet IS 'Task Logs';


--
-- Name: COLUMN res_config_settings.group_project_stages; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_project_stages IS 'Project Stages';


--
-- Name: COLUMN res_config_settings.module_project_timesheet_holidays; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_project_timesheet_holidays IS 'Time Off';


--
-- Name: COLUMN res_config_settings.reminder_user_allow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.reminder_user_allow IS 'Employee Reminder';


--
-- Name: COLUMN res_config_settings.reminder_allow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.reminder_allow IS 'Approver Reminder';


--
-- Name: COLUMN res_config_settings.timesheet_min_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.timesheet_min_duration IS 'Minimal Duration';


--
-- Name: COLUMN res_config_settings.timesheet_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.timesheet_rounding IS 'Round up';


--
-- Name: COLUMN res_config_settings.openai_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.openai_key IS 'OpenAI API key';


--
-- Name: COLUMN res_config_settings.google_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_key IS 'Google AI API key';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.code IS 'Code';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    iso_numeric integer,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label jsonb,
    currency_subunit_label jsonb,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.iso_numeric; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.iso_numeric IS 'Currency numeric code.';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_device_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_device_log (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    session_identifier character varying NOT NULL,
    platform character varying,
    browser character varying,
    ip_address character varying,
    country character varying,
    city character varying,
    device_type character varying,
    revoked boolean,
    first_activity timestamp without time zone,
    last_activity timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_device_log OWNER TO runbot;

--
-- Name: TABLE res_device_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_device_log IS 'Device Log';


--
-- Name: COLUMN res_device_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.user_id IS 'User';


--
-- Name: COLUMN res_device_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_device_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_device_log.session_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.session_identifier IS 'Session Identifier';


--
-- Name: COLUMN res_device_log.platform; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.platform IS 'Platform';


--
-- Name: COLUMN res_device_log.browser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.browser IS 'Browser';


--
-- Name: COLUMN res_device_log.ip_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.ip_address IS 'IP Address';


--
-- Name: COLUMN res_device_log.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.country IS 'Country';


--
-- Name: COLUMN res_device_log.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.city IS 'City';


--
-- Name: COLUMN res_device_log.device_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.device_type IS 'Device Type';


--
-- Name: COLUMN res_device_log.revoked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.revoked IS 'Revoked';


--
-- Name: COLUMN res_device_log.first_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.first_activity IS 'First Activity';


--
-- Name: COLUMN res_device_log.last_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.last_activity IS 'Last Activity';


--
-- Name: COLUMN res_device_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_date IS 'Created on';


--
-- Name: COLUMN res_device_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_date IS 'Last Updated on';


--
-- Name: res_device; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.res_device AS
 SELECT id,
    user_id,
    create_uid,
    write_uid,
    session_identifier,
    platform,
    browser,
    ip_address,
    country,
    city,
    device_type,
    revoked,
    first_activity,
    last_activity,
    create_date,
    write_date
   FROM public.res_device_log d
  WHERE ((NOT (EXISTS ( SELECT 1
           FROM public.res_device_log d2
          WHERE ((d2.user_id = d.user_id) AND ((d2.session_identifier)::text = (d.session_identifier)::text) AND (NOT ((d2.platform)::text IS DISTINCT FROM (d.platform)::text)) AND (NOT ((d2.browser)::text IS DISTINCT FROM (d.browser)::text)) AND ((d2.last_activity > d.last_activity) OR ((d2.last_activity = d.last_activity) AND (d2.id > d.id))) AND (d2.revoked IS NOT TRUE))))) AND (revoked IS NOT TRUE));


ALTER VIEW public.res_device OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_device_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_device_log_id_seq OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_device_log_id_seq OWNED BY public.res_device_log.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    sequence integer,
    privilege_id integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    api_key_duration double precision,
    CONSTRAINT res_groups_check_api_key_duration CHECK ((api_key_duration >= (0)::double precision))
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.sequence IS 'Sequence';


--
-- Name: COLUMN res_groups.privilege_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.privilege_id IS 'Privilege';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_groups.api_key_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.api_key_duration IS 'API Keys maximum duration days';


--
-- Name: CONSTRAINT res_groups_check_api_key_duration ON res_groups; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_groups_check_api_key_duration ON public.res_groups IS 'CHECK(api_key_duration >= 0)';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_privilege; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_privilege (
    id integer NOT NULL,
    sequence integer,
    category_id integer,
    create_uid integer,
    write_uid integer,
    placeholder character varying,
    name jsonb NOT NULL,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_groups_privilege OWNER TO runbot;

--
-- Name: TABLE res_groups_privilege; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_privilege IS 'Privileges';


--
-- Name: COLUMN res_groups_privilege.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.sequence IS 'Sequence';


--
-- Name: COLUMN res_groups_privilege.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.category_id IS 'Category';


--
-- Name: COLUMN res_groups_privilege.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups_privilege.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups_privilege.placeholder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.placeholder IS 'Placeholder';


--
-- Name: COLUMN res_groups_privilege.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.name IS 'Name';


--
-- Name: COLUMN res_groups_privilege.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.description IS 'Description';


--
-- Name: COLUMN res_groups_privilege.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.create_date IS 'Created on';


--
-- Name: COLUMN res_groups_privilege.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.write_date IS 'Last Updated on';


--
-- Name: res_groups_privilege_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_privilege_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_privilege_id_seq OWNER TO runbot;

--
-- Name: res_groups_privilege_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_privilege_id_seq OWNED BY public.res_groups_privilege.id;


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.res_groups_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    commercial_company_name character varying,
    company_name character varying,
    properties jsonb,
    barcode jsonb,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    contact_address_complete character varying,
    message_bounce integer,
    email_normalized character varying,
    signup_type character varying,
    phone_sanitized character varying,
    ocn_token character varying,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.properties IS 'Properties';


--
-- Name: COLUMN res_partner.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.barcode IS 'Barcode';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner.contact_address_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.contact_address_complete IS 'Contact Address Complete';


--
-- Name: COLUMN res_partner.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.message_bounce IS 'Bounce';


--
-- Name: COLUMN res_partner.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN res_partner.signup_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.signup_type IS 'Signup Token Type';


--
-- Name: COLUMN res_partner.phone_sanitized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN res_partner.ocn_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ocn_token IS 'OCN Token';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    clearing_number character varying,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    note text,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.clearing_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.clearing_number IS 'Clearing Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.note IS 'Notes';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_task_share_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_task_share_wizard_rel (
    task_share_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_task_share_wizard_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_task_share_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_task_share_wizard_rel IS 'RELATION BETWEEN task_share_wizard AND res_partner';


--
-- Name: res_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_role (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_role OWNER TO runbot;

--
-- Name: TABLE res_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_role IS 'Represents a role in the system used to categorize users. Each role has a unique name and can be associated with multiple users. Roles can be mentioned in messages to notify all associated users.';


--
-- Name: COLUMN res_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.create_uid IS 'Created by';


--
-- Name: COLUMN res_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_role.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.name IS 'Name';


--
-- Name: COLUMN res_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.create_date IS 'Created on';


--
-- Name: COLUMN res_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.write_date IS 'Last Updated on';


--
-- Name: res_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_role_id_seq OWNER TO runbot;

--
-- Name: res_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_role_id_seq OWNED BY public.res_role.id;


--
-- Name: res_role_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_role_res_users_rel (
    res_role_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_role_res_users_rel OWNER TO runbot;

--
-- Name: TABLE res_role_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_role_res_users_rel IS 'RELATION BETWEEN res_role AND res_users';


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_last_counter integer,
    totp_secret character varying,
    tour_enabled boolean,
    notification_type character varying NOT NULL,
    manual_im_status character varying,
    out_of_office_message text,
    out_of_office_from timestamp without time zone,
    out_of_office_to timestamp without time zone,
    odoobot_state character varying,
    odoobot_failed boolean,
    saas_provider_uuid character varying,
    helpdesk_target_closed integer,
    helpdesk_target_rating double precision,
    helpdesk_target_success double precision,
    CONSTRAINT res_users_notification_type CHECK ((((notification_type)::text = 'email'::text) OR (NOT share))),
    CONSTRAINT res_users_target_closed_not_zero CHECK ((helpdesk_target_closed > 0)),
    CONSTRAINT res_users_target_rating_not_zero CHECK ((helpdesk_target_rating > (0)::double precision)),
    CONSTRAINT res_users_target_success_not_zero CHECK ((helpdesk_target_success > (0)::double precision))
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.totp_last_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.totp_last_counter IS 'Totp Last Counter';


--
-- Name: COLUMN res_users.tour_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.tour_enabled IS 'Onboarding';


--
-- Name: COLUMN res_users.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.notification_type IS 'Notification';


--
-- Name: COLUMN res_users.manual_im_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.manual_im_status IS 'IM status manually set by the user';


--
-- Name: COLUMN res_users.out_of_office_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_message IS 'Vacation Responder';


--
-- Name: COLUMN res_users.out_of_office_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_from IS 'Out Of Office From';


--
-- Name: COLUMN res_users.out_of_office_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_to IS 'Out Of Office To';


--
-- Name: COLUMN res_users.odoobot_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_state IS 'OdooBot Status';


--
-- Name: COLUMN res_users.odoobot_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_failed IS 'Odoobot Failed';


--
-- Name: COLUMN res_users.saas_provider_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.saas_provider_uuid IS 'SaaS Provider UUID';


--
-- Name: COLUMN res_users.helpdesk_target_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.helpdesk_target_closed IS 'Helpdesk Target Closed';


--
-- Name: COLUMN res_users.helpdesk_target_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.helpdesk_target_rating IS 'Helpdesk Target Rating';


--
-- Name: COLUMN res_users.helpdesk_target_success; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.helpdesk_target_success IS 'Helpdesk Target Success';


--
-- Name: CONSTRAINT res_users_notification_type ON res_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_notification_type ON public.res_users IS 'CHECK (notification_type = ''email'' OR NOT share)';


--
-- Name: CONSTRAINT res_users_target_closed_not_zero ON res_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_target_closed_not_zero ON public.res_users IS 'CHECK(helpdesk_target_closed > 0)';


--
-- Name: CONSTRAINT res_users_target_rating_not_zero ON res_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_target_rating_not_zero ON public.res_users IS 'CHECK(helpdesk_target_rating > 0)';


--
-- Name: CONSTRAINT res_users_target_success_not_zero ON res_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_target_success_not_zero ON public.res_users IS 'CHECK(helpdesk_target_success > 0)';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    duration character varying NOT NULL,
    expiration_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.duration IS 'Duration';


--
-- Name: COLUMN res_users_apikeys_description.expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.expiration_date IS 'Expiration Date';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    auth_method character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.auth_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.auth_method IS 'Auth Method';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    color_scheme character varying NOT NULL,
    homemenu_config jsonb,
    voice_active_duration integer,
    push_to_talk_key character varying,
    channel_notifications character varying,
    is_discuss_sidebar_category_channel_open boolean,
    is_discuss_sidebar_category_chat_open boolean,
    use_push_to_talk boolean
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings.color_scheme; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.color_scheme IS 'Color Scheme';


--
-- Name: COLUMN res_users_settings.homemenu_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.homemenu_config IS 'Home Menu Configuration';


--
-- Name: COLUMN res_users_settings.voice_active_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.voice_active_duration IS 'Duration of voice activity in ms';


--
-- Name: COLUMN res_users_settings.push_to_talk_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.push_to_talk_key IS 'Push-To-Talk shortcut';


--
-- Name: COLUMN res_users_settings.channel_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.channel_notifications IS 'Channel Notifications';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_channel_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_channel_open IS 'Is discuss sidebar category channel open?';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_chat_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_chat_open IS 'Is discuss sidebar category chat open?';


--
-- Name: COLUMN res_users_settings.use_push_to_talk; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.use_push_to_talk IS 'Use the push to talk feature';


--
-- Name: res_users_settings_embedded_action; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_embedded_action (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    action_id integer NOT NULL,
    res_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    embedded_actions_order character varying,
    embedded_actions_visibility character varying,
    embedded_visibility boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_settings_embedded_action OWNER TO runbot;

--
-- Name: TABLE res_users_settings_embedded_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_embedded_action IS 'User Settings for Embedded Actions';


--
-- Name: COLUMN res_users_settings_embedded_action.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_embedded_action.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.action_id IS 'Action';


--
-- Name: COLUMN res_users_settings_embedded_action.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.res_id IS 'Res';


--
-- Name: COLUMN res_users_settings_embedded_action.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_embedded_action.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_embedded_action.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.res_model IS 'Res Model';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_actions_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_actions_order IS 'List order of embedded action ids';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_actions_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_actions_visibility IS 'List visibility of embedded actions ids';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_visibility IS 'Is top bar visible';


--
-- Name: COLUMN res_users_settings_embedded_action.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_embedded_action.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_embedded_action_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_embedded_action_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_embedded_action_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_embedded_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_embedded_action_id_seq OWNED BY public.res_users_settings_embedded_action.id;


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: res_users_settings_volumes; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_volumes (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    volume double precision,
    CONSTRAINT res_users_settings_volumes_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.res_users_settings_volumes OWNER TO runbot;

--
-- Name: TABLE res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_volumes IS 'User Settings Volumes';


--
-- Name: COLUMN res_users_settings_volumes.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_volumes.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.partner_id IS 'Partner';


--
-- Name: COLUMN res_users_settings_volumes.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.guest_id IS 'Guest';


--
-- Name: COLUMN res_users_settings_volumes.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_volumes.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_volumes.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_volumes.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings_volumes.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.volume IS 'Volume';


--
-- Name: CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON public.res_users_settings_volumes IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_volumes_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNED BY public.res_users_settings_volumes.id;


--
-- Name: res_users_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE res_users_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND res_users';


--
-- Name: res_users_web_tour_tour_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_web_tour_tour_rel (
    web_tour_tour_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_web_tour_tour_rel OWNER TO runbot;

--
-- Name: TABLE res_users_web_tour_tour_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_web_tour_tour_rel IS 'RELATION BETWEEN web_tour_tour AND res_users';


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: resource_calendar; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    schedule_type character varying NOT NULL,
    tz character varying NOT NULL,
    hours_per_day numeric,
    active boolean,
    duration_based boolean,
    flexible_hours boolean,
    two_weeks_calendar boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    full_time_required_hours double precision,
    hours_per_week double precision
);


ALTER TABLE public.resource_calendar OWNER TO runbot;

--
-- Name: TABLE resource_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar IS 'Resource Working Time';


--
-- Name: COLUMN resource_calendar.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.name IS 'Name';


--
-- Name: COLUMN resource_calendar.schedule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.schedule_type IS 'Schedule Type';


--
-- Name: COLUMN resource_calendar.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.tz IS 'Timezone';


--
-- Name: COLUMN resource_calendar.hours_per_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.hours_per_day IS 'Average Hour per Day';


--
-- Name: COLUMN resource_calendar.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.active IS 'Active';


--
-- Name: COLUMN resource_calendar.duration_based; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.duration_based IS 'Attendance based on duration';


--
-- Name: COLUMN resource_calendar.flexible_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.flexible_hours IS 'Flexible Hours';


--
-- Name: COLUMN resource_calendar.two_weeks_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.two_weeks_calendar IS 'Calendar in 2 weeks mode';


--
-- Name: COLUMN resource_calendar.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar.full_time_required_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.full_time_required_hours IS 'Full Time Equivalent';


--
-- Name: COLUMN resource_calendar.hours_per_week; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.hours_per_week IS 'Hours per Week';


--
-- Name: resource_calendar_attendance; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar_attendance (
    id integer NOT NULL,
    calendar_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    dayofweek character varying NOT NULL,
    day_period character varying NOT NULL,
    week_type character varying,
    display_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    hour_from double precision NOT NULL,
    hour_to double precision NOT NULL,
    duration_hours double precision,
    duration_days double precision
);


ALTER TABLE public.resource_calendar_attendance OWNER TO runbot;

--
-- Name: TABLE resource_calendar_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar_attendance IS 'Work Detail';


--
-- Name: COLUMN resource_calendar_attendance.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.calendar_id IS 'Resource''s Calendar';


--
-- Name: COLUMN resource_calendar_attendance.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.sequence IS 'Sequence';


--
-- Name: COLUMN resource_calendar_attendance.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_attendance.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_attendance.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.name IS 'Name';


--
-- Name: COLUMN resource_calendar_attendance.dayofweek; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.dayofweek IS 'Day of Week';


--
-- Name: COLUMN resource_calendar_attendance.day_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.day_period IS 'Day Period';


--
-- Name: COLUMN resource_calendar_attendance.week_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.week_type IS 'Week Number';


--
-- Name: COLUMN resource_calendar_attendance.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.display_type IS 'Display Type';


--
-- Name: COLUMN resource_calendar_attendance.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_attendance.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar_attendance.hour_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_from IS 'Work from';


--
-- Name: COLUMN resource_calendar_attendance.hour_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_to IS 'Work to';


--
-- Name: COLUMN resource_calendar_attendance.duration_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.duration_hours IS 'Duration (hours)';


--
-- Name: COLUMN resource_calendar_attendance.duration_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.duration_days IS 'Duration (days)';


--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_attendance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_attendance_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_attendance_id_seq OWNED BY public.resource_calendar_attendance.id;


--
-- Name: resource_calendar_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_id_seq OWNED BY public.resource_calendar.id;


--
-- Name: resource_calendar_leaves; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar_leaves (
    id integer NOT NULL,
    company_id integer,
    calendar_id integer,
    resource_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    time_type character varying,
    date_from timestamp without time zone NOT NULL,
    date_to timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.resource_calendar_leaves OWNER TO runbot;

--
-- Name: TABLE resource_calendar_leaves; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar_leaves IS 'Resource Time Off Detail';


--
-- Name: COLUMN resource_calendar_leaves.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar_leaves.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.calendar_id IS 'Working Hours';


--
-- Name: COLUMN resource_calendar_leaves.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.resource_id IS 'Resource';


--
-- Name: COLUMN resource_calendar_leaves.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_leaves.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_leaves.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.name IS 'Reason';


--
-- Name: COLUMN resource_calendar_leaves.time_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.time_type IS 'Time Type';


--
-- Name: COLUMN resource_calendar_leaves.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_from IS 'Start Date';


--
-- Name: COLUMN resource_calendar_leaves.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_to IS 'End Date';


--
-- Name: COLUMN resource_calendar_leaves.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_leaves.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_date IS 'Last Updated on';


--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_leaves_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_leaves_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_leaves_id_seq OWNED BY public.resource_calendar_leaves.id;


--
-- Name: resource_resource; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_resource (
    id integer NOT NULL,
    company_id integer,
    user_id integer,
    calendar_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    resource_type character varying NOT NULL,
    tz character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    time_efficiency double precision NOT NULL,
    color integer,
    CONSTRAINT resource_resource_check_time_efficiency CHECK ((time_efficiency > (0)::double precision))
);


ALTER TABLE public.resource_resource OWNER TO runbot;

--
-- Name: TABLE resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_resource IS 'Resources';


--
-- Name: COLUMN resource_resource.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.company_id IS 'Company';


--
-- Name: COLUMN resource_resource.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.user_id IS 'User';


--
-- Name: COLUMN resource_resource.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.calendar_id IS 'Working Time';


--
-- Name: COLUMN resource_resource.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_uid IS 'Created by';


--
-- Name: COLUMN resource_resource.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_resource.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.name IS 'Name';


--
-- Name: COLUMN resource_resource.resource_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.resource_type IS 'Type';


--
-- Name: COLUMN resource_resource.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.tz IS 'Timezone';


--
-- Name: COLUMN resource_resource.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.active IS 'Active';


--
-- Name: COLUMN resource_resource.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_date IS 'Created on';


--
-- Name: COLUMN resource_resource.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_resource.time_efficiency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.time_efficiency IS 'Efficiency Factor';


--
-- Name: COLUMN resource_resource.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.color IS 'Color';


--
-- Name: CONSTRAINT resource_resource_check_time_efficiency ON resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT resource_resource_check_time_efficiency ON public.resource_resource IS 'CHECK(time_efficiency>0)';


--
-- Name: resource_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_resource_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_resource_id_seq OWNER TO runbot;

--
-- Name: resource_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_resource_id_seq OWNED BY public.resource_resource.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: scheduled_message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.scheduled_message_attachment_rel (
    scheduled_message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.scheduled_message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE scheduled_message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.scheduled_message_attachment_rel IS 'RELATION BETWEEN mail_scheduled_message AND ir_attachment';


--
-- Name: server_action_history_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.server_action_history_wizard (
    id integer NOT NULL,
    action_id integer,
    revision integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.server_action_history_wizard OWNER TO runbot;

--
-- Name: TABLE server_action_history_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.server_action_history_wizard IS 'Server Action History Wizard';


--
-- Name: COLUMN server_action_history_wizard.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.action_id IS 'Action';


--
-- Name: COLUMN server_action_history_wizard.revision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.revision IS 'Revision';


--
-- Name: COLUMN server_action_history_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN server_action_history_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN server_action_history_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.create_date IS 'Created on';


--
-- Name: COLUMN server_action_history_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.write_date IS 'Last Updated on';


--
-- Name: server_action_history_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.server_action_history_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.server_action_history_wizard_id_seq OWNER TO runbot;

--
-- Name: server_action_history_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.server_action_history_wizard_id_seq OWNED BY public.server_action_history_wizard.id;


--
-- Name: sms_account_code; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_code (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    verification_code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_code OWNER TO runbot;

--
-- Name: TABLE sms_account_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_code IS 'SMS Account Verification Code Wizard';


--
-- Name: COLUMN sms_account_code.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.account_id IS 'Account';


--
-- Name: COLUMN sms_account_code.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_code.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_code.verification_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.verification_code IS 'Verification Code';


--
-- Name: COLUMN sms_account_code.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_code.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_date IS 'Last Updated on';


--
-- Name: sms_account_code_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_code_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_code_id_seq OWNER TO runbot;

--
-- Name: sms_account_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_code_id_seq OWNED BY public.sms_account_code.id;


--
-- Name: sms_account_phone; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_phone (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone_number character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_phone OWNER TO runbot;

--
-- Name: TABLE sms_account_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_phone IS 'SMS Account Registration Phone Number Wizard';


--
-- Name: COLUMN sms_account_phone.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.account_id IS 'Account';


--
-- Name: COLUMN sms_account_phone.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_phone.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_phone.phone_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.phone_number IS 'Phone Number';


--
-- Name: COLUMN sms_account_phone.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_phone.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_date IS 'Last Updated on';


--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_phone_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_phone_id_seq OWNER TO runbot;

--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_phone_id_seq OWNED BY public.sms_account_phone.id;


--
-- Name: sms_account_sender; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_sender (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    sender_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_sender OWNER TO runbot;

--
-- Name: TABLE sms_account_sender; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_sender IS 'SMS Account Sender Name Wizard';


--
-- Name: COLUMN sms_account_sender.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.account_id IS 'Account';


--
-- Name: COLUMN sms_account_sender.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_sender.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_sender.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.sender_name IS 'Sender Name';


--
-- Name: COLUMN sms_account_sender.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_sender.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_date IS 'Last Updated on';


--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_sender_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_sender_id_seq OWNER TO runbot;

--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_sender_id_seq OWNED BY public.sms_account_sender.id;


--
-- Name: sms_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_composer (
    id integer NOT NULL,
    res_id integer,
    template_id integer,
    create_uid integer,
    write_uid integer,
    composition_mode character varying NOT NULL,
    res_model character varying,
    res_ids character varying,
    recipient_single_number_itf character varying,
    number_field_name character varying,
    numbers character varying,
    body text NOT NULL,
    mass_keep_log boolean,
    mass_force_send boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_composer OWNER TO runbot;

--
-- Name: TABLE sms_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_composer IS 'Send SMS Wizard';


--
-- Name: COLUMN sms_composer.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_id IS 'Document ID';


--
-- Name: COLUMN sms_composer.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.template_id IS 'Use Template';


--
-- Name: COLUMN sms_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_uid IS 'Created by';


--
-- Name: COLUMN sms_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_composer.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.composition_mode IS 'Composition Mode';


--
-- Name: COLUMN sms_composer.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_model IS 'Document Model Name';


--
-- Name: COLUMN sms_composer.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_ids IS 'Document IDs';


--
-- Name: COLUMN sms_composer.recipient_single_number_itf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.recipient_single_number_itf IS 'Recipient Number';


--
-- Name: COLUMN sms_composer.number_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.number_field_name IS 'Number Field';


--
-- Name: COLUMN sms_composer.numbers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.numbers IS 'Recipients (Numbers)';


--
-- Name: COLUMN sms_composer.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.body IS 'Message';


--
-- Name: COLUMN sms_composer.mass_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_keep_log IS 'Keep a note on document';


--
-- Name: COLUMN sms_composer.mass_force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_force_send IS 'Send directly';


--
-- Name: COLUMN sms_composer.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.use_exclusion_list IS 'Use Exclusion List';


--
-- Name: COLUMN sms_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_date IS 'Created on';


--
-- Name: COLUMN sms_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_date IS 'Last Updated on';


--
-- Name: sms_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_composer_id_seq OWNER TO runbot;

--
-- Name: sms_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_composer_id_seq OWNED BY public.sms_composer.id;


--
-- Name: sms_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_sms (
    id integer NOT NULL,
    partner_id integer,
    mail_message_id integer,
    create_uid integer,
    write_uid integer,
    uuid character varying,
    number character varying,
    state character varying NOT NULL,
    failure_type character varying,
    body text,
    to_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_sms OWNER TO runbot;

--
-- Name: TABLE sms_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_sms IS 'Outgoing SMS';


--
-- Name: COLUMN sms_sms.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.partner_id IS 'Customer';


--
-- Name: COLUMN sms_sms.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.mail_message_id IS 'Mail Message';


--
-- Name: COLUMN sms_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_uid IS 'Created by';


--
-- Name: COLUMN sms_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_sms.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.uuid IS 'UUID';


--
-- Name: COLUMN sms_sms.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.number IS 'Number';


--
-- Name: COLUMN sms_sms.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.state IS 'SMS Status';


--
-- Name: COLUMN sms_sms.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.failure_type IS 'Failure Type';


--
-- Name: COLUMN sms_sms.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.body IS 'Body';


--
-- Name: COLUMN sms_sms.to_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.to_delete IS 'Marked for deletion';


--
-- Name: COLUMN sms_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_date IS 'Created on';


--
-- Name: COLUMN sms_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_date IS 'Last Updated on';


--
-- Name: sms_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_sms_id_seq OWNER TO runbot;

--
-- Name: sms_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_sms_id_seq OWNED BY public.sms_sms.id;


--
-- Name: sms_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template (
    id integer NOT NULL,
    model_id integer NOT NULL,
    sidebar_action_id integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    name jsonb,
    body jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template OWNER TO runbot;

--
-- Name: TABLE sms_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template IS 'SMS Templates';


--
-- Name: COLUMN sms_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model_id IS 'Applies to';


--
-- Name: COLUMN sms_template.sidebar_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.sidebar_action_id IS 'Sidebar action';


--
-- Name: COLUMN sms_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN sms_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.lang IS 'Language';


--
-- Name: COLUMN sms_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model IS 'Related Document Model';


--
-- Name: COLUMN sms_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.name IS 'Name';


--
-- Name: COLUMN sms_template.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.body IS 'Body';


--
-- Name: COLUMN sms_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_date IS 'Created on';


--
-- Name: COLUMN sms_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_date IS 'Last Updated on';


--
-- Name: sms_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_id_seq OWNER TO runbot;

--
-- Name: sms_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_id_seq OWNED BY public.sms_template.id;


--
-- Name: sms_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_preview (
    id integer NOT NULL,
    sms_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    resource_ref character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_preview OWNER TO runbot;

--
-- Name: TABLE sms_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_preview IS 'SMS Template Preview';


--
-- Name: COLUMN sms_template_preview.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN sms_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN sms_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.resource_ref IS 'Record reference';


--
-- Name: COLUMN sms_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_date IS 'Last Updated on';


--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_preview_id_seq OWNER TO runbot;

--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_preview_id_seq OWNED BY public.sms_template_preview.id;


--
-- Name: sms_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_reset OWNER TO runbot;

--
-- Name: TABLE sms_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_reset IS 'SMS Template Reset';


--
-- Name: COLUMN sms_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_date IS 'Last Updated on';


--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_reset_id_seq OWNER TO runbot;

--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_reset_id_seq OWNED BY public.sms_template_reset.id;


--
-- Name: sms_template_sms_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_sms_template_reset_rel (
    sms_template_reset_id integer NOT NULL,
    sms_template_id integer NOT NULL
);


ALTER TABLE public.sms_template_sms_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE sms_template_sms_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_sms_template_reset_rel IS 'RELATION BETWEEN sms_template_reset AND sms_template';


--
-- Name: sms_tracker; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_tracker (
    id integer NOT NULL,
    mail_notification_id integer,
    create_uid integer,
    write_uid integer,
    sms_uuid character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_tracker OWNER TO runbot;

--
-- Name: TABLE sms_tracker; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_tracker IS 'Link SMS to mailing/sms tracking models';


--
-- Name: COLUMN sms_tracker.mail_notification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.mail_notification_id IS 'Mail Notification';


--
-- Name: COLUMN sms_tracker.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_uid IS 'Created by';


--
-- Name: COLUMN sms_tracker.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_tracker.sms_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.sms_uuid IS 'SMS uuid';


--
-- Name: COLUMN sms_tracker.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_date IS 'Created on';


--
-- Name: COLUMN sms_tracker.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_date IS 'Last Updated on';


--
-- Name: sms_tracker_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_tracker_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_tracker_id_seq OWNER TO runbot;

--
-- Name: sms_tracker_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_tracker_id_seq OWNED BY public.sms_tracker.id;


--
-- Name: snailmail_letter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.snailmail_letter (
    id integer NOT NULL,
    user_id integer,
    res_id integer NOT NULL,
    partner_id integer NOT NULL,
    company_id integer NOT NULL,
    report_template integer,
    attachment_id integer,
    message_id integer,
    state_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    state character varying NOT NULL,
    error_code character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    info_msg text,
    color boolean,
    cover boolean,
    duplex boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.snailmail_letter OWNER TO runbot;

--
-- Name: TABLE snailmail_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.snailmail_letter IS 'Snailmail Letter';


--
-- Name: COLUMN snailmail_letter.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.user_id IS 'Sent by';


--
-- Name: COLUMN snailmail_letter.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.res_id IS 'Document ID';


--
-- Name: COLUMN snailmail_letter.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.partner_id IS 'Recipient';


--
-- Name: COLUMN snailmail_letter.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.company_id IS 'Company';


--
-- Name: COLUMN snailmail_letter.report_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN snailmail_letter.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.attachment_id IS 'Attachment';


--
-- Name: COLUMN snailmail_letter.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.message_id IS 'Snailmail Status Message';


--
-- Name: COLUMN snailmail_letter.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state_id IS 'State';


--
-- Name: COLUMN snailmail_letter.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.country_id IS 'Country';


--
-- Name: COLUMN snailmail_letter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.model IS 'Model';


--
-- Name: COLUMN snailmail_letter.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state IS 'Status';


--
-- Name: COLUMN snailmail_letter.error_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.error_code IS 'Error';


--
-- Name: COLUMN snailmail_letter.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street IS 'Street';


--
-- Name: COLUMN snailmail_letter.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street2 IS 'Street2';


--
-- Name: COLUMN snailmail_letter.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.zip IS 'Zip';


--
-- Name: COLUMN snailmail_letter.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.city IS 'City';


--
-- Name: COLUMN snailmail_letter.info_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.info_msg IS 'Information';


--
-- Name: COLUMN snailmail_letter.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.color IS 'Color';


--
-- Name: COLUMN snailmail_letter.cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.cover IS 'Cover Page';


--
-- Name: COLUMN snailmail_letter.duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.duplex IS 'Both side';


--
-- Name: COLUMN snailmail_letter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.snailmail_letter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.snailmail_letter_id_seq OWNER TO runbot;

--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.snailmail_letter_id_seq OWNED BY public.snailmail_letter.id;


--
-- Name: spreadsheet_cell_thread; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_cell_thread (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    dashboard_id integer
);


ALTER TABLE public.spreadsheet_cell_thread OWNER TO runbot;

--
-- Name: TABLE spreadsheet_cell_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_cell_thread IS 'Spreadsheet discussion thread';


--
-- Name: COLUMN spreadsheet_cell_thread.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_cell_thread.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_cell_thread.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_cell_thread.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.write_date IS 'Last Updated on';


--
-- Name: COLUMN spreadsheet_cell_thread.dashboard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_cell_thread.dashboard_id IS 'Dashboard';


--
-- Name: spreadsheet_cell_thread_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_cell_thread_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_cell_thread_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_cell_thread_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_cell_thread_id_seq OWNED BY public.spreadsheet_cell_thread.id;


--
-- Name: spreadsheet_dashboard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_dashboard (
    id integer NOT NULL,
    dashboard_group_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    sample_dashboard_file_path character varying,
    name jsonb NOT NULL,
    is_published boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_dashboard OWNER TO runbot;

--
-- Name: TABLE spreadsheet_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_dashboard IS 'Spreadsheet Dashboard';


--
-- Name: COLUMN spreadsheet_dashboard.dashboard_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.dashboard_group_id IS 'Dashboard Group';


--
-- Name: COLUMN spreadsheet_dashboard.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.sequence IS 'Sequence';


--
-- Name: COLUMN spreadsheet_dashboard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_dashboard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_dashboard.sample_dashboard_file_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.sample_dashboard_file_path IS 'Sample Dashboard File Path';


--
-- Name: COLUMN spreadsheet_dashboard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.name IS 'Name';


--
-- Name: COLUMN spreadsheet_dashboard.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.is_published IS 'Is Published';


--
-- Name: COLUMN spreadsheet_dashboard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_dashboard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_dashboard_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_dashboard_group (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_dashboard_group OWNER TO runbot;

--
-- Name: TABLE spreadsheet_dashboard_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_dashboard_group IS 'Group of dashboards';


--
-- Name: COLUMN spreadsheet_dashboard_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.sequence IS 'Sequence';


--
-- Name: COLUMN spreadsheet_dashboard_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_dashboard_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_dashboard_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.name IS 'Name';


--
-- Name: COLUMN spreadsheet_dashboard_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_dashboard_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_group.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_dashboard_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_dashboard_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_dashboard_group_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_dashboard_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_dashboard_group_id_seq OWNED BY public.spreadsheet_dashboard_group.id;


--
-- Name: spreadsheet_dashboard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_dashboard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_dashboard_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_dashboard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_dashboard_id_seq OWNED BY public.spreadsheet_dashboard.id;


--
-- Name: spreadsheet_dashboard_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_dashboard_share (
    id integer NOT NULL,
    dashboard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    access_token character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_dashboard_share OWNER TO runbot;

--
-- Name: TABLE spreadsheet_dashboard_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_dashboard_share IS 'Copy of a shared dashboard';


--
-- Name: COLUMN spreadsheet_dashboard_share.dashboard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.dashboard_id IS 'Dashboard';


--
-- Name: COLUMN spreadsheet_dashboard_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_dashboard_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_dashboard_share.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.access_token IS 'Access Token';


--
-- Name: COLUMN spreadsheet_dashboard_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_dashboard_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_dashboard_share.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_dashboard_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_dashboard_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_dashboard_share_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_dashboard_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_dashboard_share_id_seq OWNED BY public.spreadsheet_dashboard_share.id;


--
-- Name: spreadsheet_revision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.spreadsheet_revision (
    id integer NOT NULL,
    res_id integer NOT NULL,
    parent_revision_id integer,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    res_model character varying NOT NULL,
    commands character varying NOT NULL,
    revision_uuid character varying NOT NULL,
    active boolean,
    revision_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.spreadsheet_revision OWNER TO runbot;

--
-- Name: TABLE spreadsheet_revision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.spreadsheet_revision IS 'Collaborative spreadsheet revision';


--
-- Name: COLUMN spreadsheet_revision.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.res_id IS 'Record id';


--
-- Name: COLUMN spreadsheet_revision.parent_revision_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.parent_revision_id IS 'Parent Revision';


--
-- Name: COLUMN spreadsheet_revision.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.author_id IS 'Author';


--
-- Name: COLUMN spreadsheet_revision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.create_uid IS 'Created by';


--
-- Name: COLUMN spreadsheet_revision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN spreadsheet_revision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.name IS 'Revision name';


--
-- Name: COLUMN spreadsheet_revision.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.res_model IS 'Model';


--
-- Name: COLUMN spreadsheet_revision.commands; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.commands IS 'Commands';


--
-- Name: COLUMN spreadsheet_revision.revision_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.revision_uuid IS 'Revision Uuid';


--
-- Name: COLUMN spreadsheet_revision.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.active IS 'Active';


--
-- Name: COLUMN spreadsheet_revision.revision_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.revision_date IS 'Revision Date';


--
-- Name: COLUMN spreadsheet_revision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.create_date IS 'Created on';


--
-- Name: COLUMN spreadsheet_revision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.spreadsheet_revision.write_date IS 'Last Updated on';


--
-- Name: spreadsheet_revision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.spreadsheet_revision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.spreadsheet_revision_id_seq OWNER TO runbot;

--
-- Name: spreadsheet_revision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.spreadsheet_revision_id_seq OWNED BY public.spreadsheet_revision.id;


--
-- Name: task_dependencies_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.task_dependencies_rel (
    task_id integer NOT NULL,
    depends_on_id integer NOT NULL
);


ALTER TABLE public.task_dependencies_rel OWNER TO runbot;

--
-- Name: TABLE task_dependencies_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.task_dependencies_rel IS 'RELATION BETWEEN project_task AND project_task';


--
-- Name: task_share_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.task_share_wizard (
    id integer NOT NULL,
    res_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    task_id integer,
    res_model character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.task_share_wizard OWNER TO runbot;

--
-- Name: TABLE task_share_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.task_share_wizard IS 'Task Sharing';


--
-- Name: COLUMN task_share_wizard.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.task_share_wizard.res_id IS 'Related Document ID';


--
-- Name: COLUMN task_share_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.task_share_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN task_share_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.task_share_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN task_share_wizard.task_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.task_share_wizard.task_id IS 'Task';


--
-- Name: COLUMN task_share_wizard.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.task_share_wizard.res_model IS 'Related Document Model';


--
-- Name: COLUMN task_share_wizard.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.task_share_wizard.note IS 'Note';


--
-- Name: COLUMN task_share_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.task_share_wizard.create_date IS 'Created on';


--
-- Name: COLUMN task_share_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.task_share_wizard.write_date IS 'Last Updated on';


--
-- Name: task_share_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.task_share_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.task_share_wizard_id_seq OWNER TO runbot;

--
-- Name: task_share_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.task_share_wizard_id_seq OWNED BY public.task_share_wizard.id;


--
-- Name: team_stage_auto_close_from_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.team_stage_auto_close_from_rel (
    helpdesk_team_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


ALTER TABLE public.team_stage_auto_close_from_rel OWNER TO runbot;

--
-- Name: TABLE team_stage_auto_close_from_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.team_stage_auto_close_from_rel IS 'RELATION BETWEEN helpdesk_team AND helpdesk_stage';


--
-- Name: team_stage_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.team_stage_rel (
    helpdesk_team_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


ALTER TABLE public.team_stage_rel OWNER TO runbot;

--
-- Name: TABLE team_stage_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.team_stage_rel IS 'RELATION BETWEEN helpdesk_team AND helpdesk_stage';


--
-- Name: timer_timer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.timer_timer (
    id integer NOT NULL,
    res_id integer NOT NULL,
    user_id integer,
    parent_res_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    parent_res_model character varying,
    timer_start timestamp without time zone,
    timer_pause timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.timer_timer OWNER TO runbot;

--
-- Name: TABLE timer_timer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.timer_timer IS 'Timer Module';


--
-- Name: COLUMN timer_timer.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.res_id IS 'Res';


--
-- Name: COLUMN timer_timer.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.user_id IS 'User';


--
-- Name: COLUMN timer_timer.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.parent_res_id IS 'Parent Document';


--
-- Name: COLUMN timer_timer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.create_uid IS 'Created by';


--
-- Name: COLUMN timer_timer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN timer_timer.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.res_model IS 'Res Model';


--
-- Name: COLUMN timer_timer.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.parent_res_model IS 'Parent Document Model';


--
-- Name: COLUMN timer_timer.timer_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.timer_start IS 'Timer Start';


--
-- Name: COLUMN timer_timer.timer_pause; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.timer_pause IS 'Timer Last Pause';


--
-- Name: COLUMN timer_timer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.create_date IS 'Created on';


--
-- Name: COLUMN timer_timer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.timer_timer.write_date IS 'Last Updated on';


--
-- Name: timer_timer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.timer_timer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.timer_timer_id_seq OWNER TO runbot;

--
-- Name: timer_timer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.timer_timer_id_seq OWNED BY public.timer_timer.id;


--
-- Name: timesheets_analysis_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.timesheets_analysis_report AS
 SELECT id,
    name,
    user_id,
    project_id,
    task_id,
    parent_task_id,
    employee_id,
    manager_id,
    company_id,
    department_id,
    currency_id,
    date,
    amount,
    unit_amount,
    partner_id,
    validated,
        CASE
            WHEN validated THEN 'validated'::text
            ELSE 'draft'::text
        END AS validated_status,
    helpdesk_ticket_id
   FROM public.account_analytic_line a
  WHERE (project_id IS NOT NULL);


ALTER VIEW public.timesheets_analysis_report OWNER TO runbot;

--
-- Name: uom_uom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.uom_uom (
    id integer NOT NULL,
    sequence integer,
    relative_uom_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    relative_factor numeric NOT NULL,
    factor numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    timesheet_widget character varying,
    CONSTRAINT uom_uom_factor_gt_zero CHECK ((relative_factor <> (0)::numeric))
);


ALTER TABLE public.uom_uom OWNER TO runbot;

--
-- Name: TABLE uom_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.uom_uom IS 'Product Unit of Measure';


--
-- Name: COLUMN uom_uom.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.sequence IS 'Sequence';


--
-- Name: COLUMN uom_uom.relative_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.relative_uom_id IS 'Reference Unit';


--
-- Name: COLUMN uom_uom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.create_uid IS 'Created by';


--
-- Name: COLUMN uom_uom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN uom_uom.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.parent_path IS 'Parent Path';


--
-- Name: COLUMN uom_uom.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.name IS 'Unit Name';


--
-- Name: COLUMN uom_uom.relative_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.relative_factor IS 'Contains';


--
-- Name: COLUMN uom_uom.factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.factor IS 'Absolute Quantity';


--
-- Name: COLUMN uom_uom.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.active IS 'Active';


--
-- Name: COLUMN uom_uom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.create_date IS 'Created on';


--
-- Name: COLUMN uom_uom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.write_date IS 'Last Updated on';


--
-- Name: COLUMN uom_uom.timesheet_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.uom_uom.timesheet_widget IS 'Widget';


--
-- Name: CONSTRAINT uom_uom_factor_gt_zero ON uom_uom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT uom_uom_factor_gt_zero ON public.uom_uom IS 'CHECK (relative_factor!=0)';


--
-- Name: uom_uom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.uom_uom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.uom_uom_id_seq OWNER TO runbot;

--
-- Name: uom_uom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.uom_uom_id_seq OWNED BY public.uom_uom.id;


--
-- Name: utm_campaign; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_campaign (
    id integer NOT NULL,
    user_id integer NOT NULL,
    stage_id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    title jsonb NOT NULL,
    active boolean,
    is_auto_campaign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_campaign OWNER TO runbot;

--
-- Name: TABLE utm_campaign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_campaign IS 'UTM Campaign';


--
-- Name: COLUMN utm_campaign.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.user_id IS 'Responsible';


--
-- Name: COLUMN utm_campaign.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.stage_id IS 'Stage';


--
-- Name: COLUMN utm_campaign.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.color IS 'Color Index';


--
-- Name: COLUMN utm_campaign.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.create_uid IS 'Created by';


--
-- Name: COLUMN utm_campaign.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_campaign.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.name IS 'Campaign Identifier';


--
-- Name: COLUMN utm_campaign.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.title IS 'Campaign Name';


--
-- Name: COLUMN utm_campaign.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.active IS 'Active';


--
-- Name: COLUMN utm_campaign.is_auto_campaign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.is_auto_campaign IS 'Automatically Generated Campaign';


--
-- Name: COLUMN utm_campaign.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.create_date IS 'Created on';


--
-- Name: COLUMN utm_campaign.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_campaign.write_date IS 'Last Updated on';


--
-- Name: utm_campaign_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_campaign_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_campaign_id_seq OWNER TO runbot;

--
-- Name: utm_campaign_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_campaign_id_seq OWNED BY public.utm_campaign.id;


--
-- Name: utm_medium; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_medium (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_medium OWNER TO runbot;

--
-- Name: TABLE utm_medium; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_medium IS 'UTM Medium';


--
-- Name: COLUMN utm_medium.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.create_uid IS 'Created by';


--
-- Name: COLUMN utm_medium.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_medium.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.name IS 'Medium Name';


--
-- Name: COLUMN utm_medium.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.active IS 'Active';


--
-- Name: COLUMN utm_medium.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.create_date IS 'Created on';


--
-- Name: COLUMN utm_medium.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_medium.write_date IS 'Last Updated on';


--
-- Name: utm_medium_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_medium_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_medium_id_seq OWNER TO runbot;

--
-- Name: utm_medium_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_medium_id_seq OWNED BY public.utm_medium.id;


--
-- Name: utm_source; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_source (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_source OWNER TO runbot;

--
-- Name: TABLE utm_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_source IS 'UTM Source';


--
-- Name: COLUMN utm_source.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.create_uid IS 'Created by';


--
-- Name: COLUMN utm_source.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_source.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.name IS 'Source Name';


--
-- Name: COLUMN utm_source.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.create_date IS 'Created on';


--
-- Name: COLUMN utm_source.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_source.write_date IS 'Last Updated on';


--
-- Name: utm_source_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_source_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_source_id_seq OWNER TO runbot;

--
-- Name: utm_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_source_id_seq OWNED BY public.utm_source.id;


--
-- Name: utm_stage; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_stage (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_stage OWNER TO runbot;

--
-- Name: TABLE utm_stage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_stage IS 'Campaign Stage';


--
-- Name: COLUMN utm_stage.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.sequence IS 'Sequence';


--
-- Name: COLUMN utm_stage.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.create_uid IS 'Created by';


--
-- Name: COLUMN utm_stage.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_stage.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.name IS 'Name';


--
-- Name: COLUMN utm_stage.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.create_date IS 'Created on';


--
-- Name: COLUMN utm_stage.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_stage.write_date IS 'Last Updated on';


--
-- Name: utm_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_stage_id_seq OWNER TO runbot;

--
-- Name: utm_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_stage_id_seq OWNED BY public.utm_stage.id;


--
-- Name: utm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.utm_tag OWNER TO runbot;

--
-- Name: TABLE utm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_tag IS 'UTM Tag';


--
-- Name: COLUMN utm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.color IS 'Color Index';


--
-- Name: COLUMN utm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN utm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN utm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.name IS 'Name';


--
-- Name: COLUMN utm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.create_date IS 'Created on';


--
-- Name: COLUMN utm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.utm_tag.write_date IS 'Last Updated on';


--
-- Name: utm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.utm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.utm_tag_id_seq OWNER TO runbot;

--
-- Name: utm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.utm_tag_id_seq OWNED BY public.utm_tag.id;


--
-- Name: utm_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.utm_tag_rel (
    tag_id integer NOT NULL,
    campaign_id integer NOT NULL
);


ALTER TABLE public.utm_tag_rel OWNER TO runbot;

--
-- Name: TABLE utm_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.utm_tag_rel IS 'RELATION BETWEEN utm_campaign AND utm_tag';


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    url character varying,
    rainbow_man_message jsonb,
    custom boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Name';


--
-- Name: COLUMN web_tour_tour.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.url IS 'Starting URL';


--
-- Name: COLUMN web_tour_tour.rainbow_man_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.rainbow_man_message IS 'Rainbow Man Message';


--
-- Name: COLUMN web_tour_tour.custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.custom IS 'Custom';


--
-- Name: COLUMN web_tour_tour.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: web_tour_tour_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour_step (
    id integer NOT NULL,
    tour_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    content character varying,
    tooltip_position character varying,
    run character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour_step OWNER TO runbot;

--
-- Name: TABLE web_tour_tour_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour_step IS 'Tour''s step';


--
-- Name: COLUMN web_tour_tour_step.tour_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tour_id IS 'Tour';


--
-- Name: COLUMN web_tour_tour_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour_step.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.trigger IS 'Trigger';


--
-- Name: COLUMN web_tour_tour_step.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.content IS 'Content';


--
-- Name: COLUMN web_tour_tour_step.tooltip_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tooltip_position IS 'Tooltip Position';


--
-- Name: COLUMN web_tour_tour_step.run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.run IS 'Run';


--
-- Name: COLUMN web_tour_tour_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNED BY public.web_tour_tour_step.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: account_analytic_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_account ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_account_id_seq'::regclass);


--
-- Name: account_analytic_applicability id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_applicability ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_applicability_id_seq'::regclass);


--
-- Name: account_analytic_distribution_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_distribution_model ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_distribution_model_id_seq'::regclass);


--
-- Name: account_analytic_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_line ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_line_id_seq'::regclass);


--
-- Name: account_analytic_line_calendar_employee id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_line_calendar_employee ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_line_calendar_employee_id_seq'::regclass);


--
-- Name: account_analytic_plan id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.account_analytic_plan ALTER COLUMN id SET DEFAULT nextval('public.account_analytic_plan_id_seq'::regclass);


--
-- Name: ai_agent id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_agent ALTER COLUMN id SET DEFAULT nextval('public.ai_agent_id_seq'::regclass);


--
-- Name: ai_agent_source id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_agent_source ALTER COLUMN id SET DEFAULT nextval('public.ai_agent_source_id_seq'::regclass);


--
-- Name: ai_composer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_composer ALTER COLUMN id SET DEFAULT nextval('public.ai_composer_id_seq'::regclass);


--
-- Name: ai_embedding id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_embedding ALTER COLUMN id SET DEFAULT nextval('public.ai_embedding_id_seq'::regclass);


--
-- Name: ai_prompt_button id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_prompt_button ALTER COLUMN id SET DEFAULT nextval('public.ai_prompt_button_id_seq'::regclass);


--
-- Name: ai_topic id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_topic ALTER COLUMN id SET DEFAULT nextval('public.ai_topic_id_seq'::regclass);


--
-- Name: auth_passkey_key id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_passkey_key ALTER COLUMN id SET DEFAULT nextval('public.auth_passkey_key_id_seq'::regclass);


--
-- Name: auth_passkey_key_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_passkey_key_create ALTER COLUMN id SET DEFAULT nextval('public.auth_passkey_key_create_id_seq'::regclass);


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_rate_limit_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_rate_limit_log ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_rate_limit_log_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_module ALTER COLUMN id SET DEFAULT nextval('public.base_import_module_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_install_request id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_request ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_request_id_seq'::regclass);


--
-- Name: base_module_install_review id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_review ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_review_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: digest_digest id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.digest_digest ALTER COLUMN id SET DEFAULT nextval('public.digest_digest_id_seq'::regclass);


--
-- Name: digest_tip id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.digest_tip ALTER COLUMN id SET DEFAULT nextval('public.digest_tip_id_seq'::regclass);


--
-- Name: discuss_call_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_call_history ALTER COLUMN id SET DEFAULT nextval('public.discuss_call_history_id_seq'::regclass);


--
-- Name: discuss_channel id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_id_seq'::regclass);


--
-- Name: discuss_channel_member id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_member ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_member_id_seq'::regclass);


--
-- Name: discuss_channel_rtc_session id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_rtc_session ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_rtc_session_id_seq'::regclass);


--
-- Name: discuss_gif_favorite id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_gif_favorite ALTER COLUMN id SET DEFAULT nextval('public.discuss_gif_favorite_id_seq'::regclass);


--
-- Name: discuss_voice_metadata id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_voice_metadata ALTER COLUMN id SET DEFAULT nextval('public.discuss_voice_metadata_id_seq'::regclass);


--
-- Name: fetchmail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.fetchmail_server ALTER COLUMN id SET DEFAULT nextval('public.fetchmail_server_id_seq'::regclass);


--
-- Name: helpdesk_sla id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.helpdesk_sla ALTER COLUMN id SET DEFAULT nextval('public.helpdesk_sla_id_seq'::regclass);


--
-- Name: helpdesk_sla_status id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.helpdesk_sla_status ALTER COLUMN id SET DEFAULT nextval('public.helpdesk_sla_status_id_seq'::regclass);


--
-- Name: helpdesk_stage id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.helpdesk_stage ALTER COLUMN id SET DEFAULT nextval('public.helpdesk_stage_id_seq'::regclass);


--
-- Name: helpdesk_stage_delete_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.helpdesk_stage_delete_wizard ALTER COLUMN id SET DEFAULT nextval('public.helpdesk_stage_delete_wizard_id_seq'::regclass);


--
-- Name: helpdesk_tag id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.helpdesk_tag ALTER COLUMN id SET DEFAULT nextval('public.helpdesk_tag_id_seq'::regclass);


--
-- Name: helpdesk_tag_assignment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.helpdesk_tag_assignment ALTER COLUMN id SET DEFAULT nextval('public.helpdesk_tag_assignment_id_seq'::regclass);


--
-- Name: helpdesk_team id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.helpdesk_team ALTER COLUMN id SET DEFAULT nextval('public.helpdesk_team_id_seq'::regclass);


--
-- Name: helpdesk_ticket id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.helpdesk_ticket ALTER COLUMN id SET DEFAULT nextval('public.helpdesk_ticket_id_seq'::regclass);


--
-- Name: helpdesk_ticket_convert_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.helpdesk_ticket_convert_wizard ALTER COLUMN id SET DEFAULT nextval('public.helpdesk_ticket_convert_wizard_id_seq'::regclass);


--
-- Name: hr_bank_account_allocation_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_bank_account_allocation_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_bank_account_allocation_wizard_id_seq'::regclass);


--
-- Name: hr_bank_account_allocation_wizard_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_bank_account_allocation_wizard_line ALTER COLUMN id SET DEFAULT nextval('public.hr_bank_account_allocation_wizard_line_id_seq'::regclass);


--
-- Name: hr_contract_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_contract_type ALTER COLUMN id SET DEFAULT nextval('public.hr_contract_type_id_seq'::regclass);


--
-- Name: hr_department id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_department ALTER COLUMN id SET DEFAULT nextval('public.hr_department_id_seq'::regclass);


--
-- Name: hr_departure_reason id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_departure_reason ALTER COLUMN id SET DEFAULT nextval('public.hr_departure_reason_id_seq'::regclass);


--
-- Name: hr_departure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_departure_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_departure_wizard_id_seq'::regclass);


--
-- Name: hr_employee id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_id_seq'::regclass);


--
-- Name: hr_employee_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_category ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_category_id_seq'::regclass);


--
-- Name: hr_employee_cv_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_cv_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_cv_wizard_id_seq'::regclass);


--
-- Name: hr_employee_delete_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_delete_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_delete_wizard_id_seq'::regclass);


--
-- Name: hr_employee_location id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_location ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_location_id_seq'::regclass);


--
-- Name: hr_employee_skill id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_skill ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_skill_id_seq'::regclass);


--
-- Name: hr_job id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_job ALTER COLUMN id SET DEFAULT nextval('public.hr_job_id_seq'::regclass);


--
-- Name: hr_job_skill id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_job_skill ALTER COLUMN id SET DEFAULT nextval('public.hr_job_skill_id_seq'::regclass);


--
-- Name: hr_payroll_structure_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_payroll_structure_type ALTER COLUMN id SET DEFAULT nextval('public.hr_payroll_structure_type_id_seq'::regclass);


--
-- Name: hr_resume_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_resume_line ALTER COLUMN id SET DEFAULT nextval('public.hr_resume_line_id_seq'::regclass);


--
-- Name: hr_resume_line_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_resume_line_type ALTER COLUMN id SET DEFAULT nextval('public.hr_resume_line_type_id_seq'::regclass);


--
-- Name: hr_skill id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_skill ALTER COLUMN id SET DEFAULT nextval('public.hr_skill_id_seq'::regclass);


--
-- Name: hr_skill_level id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_skill_level ALTER COLUMN id SET DEFAULT nextval('public.hr_skill_level_id_seq'::regclass);


--
-- Name: hr_skill_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_skill_type ALTER COLUMN id SET DEFAULT nextval('public.hr_skill_type_id_seq'::regclass);


--
-- Name: hr_timesheet_merge_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_timesheet_merge_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_timesheet_merge_wizard_id_seq'::regclass);


--
-- Name: hr_timesheet_stop_timer_confirmation_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_timesheet_stop_timer_confirmation_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_timesheet_stop_timer_confirmation_wizard_id_seq'::regclass);


--
-- Name: hr_version id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_version ALTER COLUMN id SET DEFAULT nextval('public.hr_version_id_seq'::regclass);


--
-- Name: hr_version_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_version_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_version_wizard_id_seq'::regclass);


--
-- Name: hr_work_location id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_work_location ALTER COLUMN id SET DEFAULT nextval('public.hr_work_location_id_seq'::regclass);


--
-- Name: html_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.html_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.html_editor_converter_test_id_seq'::regclass);


--
-- Name: html_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.html_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.html_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: iap_service id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_service ALTER COLUMN id SET DEFAULT nextval('public.iap_service_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_server_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_server_history ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_server_history_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_progress id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_progress ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_progress_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_embedded_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_embedded_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_embedded_actions_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_inherit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_inherit ALTER COLUMN id SET DEFAULT nextval('public.ir_model_inherit_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: mail_activity id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_id_seq'::regclass);


--
-- Name: mail_activity_plan id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_id_seq'::regclass);


--
-- Name: mail_activity_plan_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan_template ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_template_id_seq'::regclass);


--
-- Name: mail_activity_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_schedule_id_seq'::regclass);


--
-- Name: mail_activity_schedule_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_schedule_line ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_schedule_line_id_seq'::regclass);


--
-- Name: mail_activity_todo_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_todo_create ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_todo_create_id_seq'::regclass);


--
-- Name: mail_activity_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_type ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_type_id_seq'::regclass);


--
-- Name: mail_alias id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_id_seq'::regclass);


--
-- Name: mail_alias_domain id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias_domain ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_domain_id_seq'::regclass);


--
-- Name: mail_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_id_seq'::regclass);


--
-- Name: mail_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_remove_id_seq'::regclass);


--
-- Name: mail_canned_response id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_canned_response ALTER COLUMN id SET DEFAULT nextval('public.mail_canned_response_id_seq'::regclass);


--
-- Name: mail_compose_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_compose_message ALTER COLUMN id SET DEFAULT nextval('public.mail_compose_message_id_seq'::regclass);


--
-- Name: mail_followers id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_id_seq'::regclass);


--
-- Name: mail_followers_edit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers_edit ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_edit_id_seq'::regclass);


--
-- Name: mail_gateway_allowed id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_gateway_allowed ALTER COLUMN id SET DEFAULT nextval('public.mail_gateway_allowed_id_seq'::regclass);


--
-- Name: mail_guest id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_guest ALTER COLUMN id SET DEFAULT nextval('public.mail_guest_id_seq'::regclass);


--
-- Name: mail_ice_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_ice_server ALTER COLUMN id SET DEFAULT nextval('public.mail_ice_server_id_seq'::regclass);


--
-- Name: mail_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_link_preview_id_seq'::regclass);


--
-- Name: mail_mail id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_mail ALTER COLUMN id SET DEFAULT nextval('public.mail_mail_id_seq'::regclass);


--
-- Name: mail_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message ALTER COLUMN id SET DEFAULT nextval('public.mail_message_id_seq'::regclass);


--
-- Name: mail_message_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_message_link_preview_id_seq'::regclass);


--
-- Name: mail_message_reaction id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_reaction ALTER COLUMN id SET DEFAULT nextval('public.mail_message_reaction_id_seq'::regclass);


--
-- Name: mail_message_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_message_schedule_id_seq'::regclass);


--
-- Name: mail_message_subtype id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_subtype ALTER COLUMN id SET DEFAULT nextval('public.mail_message_subtype_id_seq'::regclass);


--
-- Name: mail_message_translation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_translation ALTER COLUMN id SET DEFAULT nextval('public.mail_message_translation_id_seq'::regclass);


--
-- Name: mail_notification id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_notification ALTER COLUMN id SET DEFAULT nextval('public.mail_notification_id_seq'::regclass);


--
-- Name: mail_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_presence ALTER COLUMN id SET DEFAULT nextval('public.mail_presence_id_seq'::regclass);


--
-- Name: mail_push id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push ALTER COLUMN id SET DEFAULT nextval('public.mail_push_id_seq'::regclass);


--
-- Name: mail_push_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push_device ALTER COLUMN id SET DEFAULT nextval('public.mail_push_device_id_seq'::regclass);


--
-- Name: mail_scheduled_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_scheduled_message ALTER COLUMN id SET DEFAULT nextval('public.mail_scheduled_message_id_seq'::regclass);


--
-- Name: mail_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template ALTER COLUMN id SET DEFAULT nextval('public.mail_template_id_seq'::regclass);


--
-- Name: mail_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_template_preview_id_seq'::regclass);


--
-- Name: mail_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_reset ALTER COLUMN id SET DEFAULT nextval('public.mail_template_reset_id_seq'::regclass);


--
-- Name: mail_tracking_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_tracking_value ALTER COLUMN id SET DEFAULT nextval('public.mail_tracking_value_id_seq'::regclass);


--
-- Name: orm_signaling_assets id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_assets ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_assets_id_seq'::regclass);


--
-- Name: orm_signaling_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_default ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_default_id_seq'::regclass);


--
-- Name: orm_signaling_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_groups ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_groups_id_seq'::regclass);


--
-- Name: orm_signaling_registry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_registry ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_registry_id_seq'::regclass);


--
-- Name: orm_signaling_routing id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_routing ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_routing_id_seq'::regclass);


--
-- Name: orm_signaling_stable id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_stable ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_stable_id_seq'::regclass);


--
-- Name: orm_signaling_templates id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_templates ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_templates_id_seq'::regclass);


--
-- Name: phone_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_id_seq'::regclass);


--
-- Name: phone_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_remove_id_seq'::regclass);


--
-- Name: portal_share id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.portal_share ALTER COLUMN id SET DEFAULT nextval('public.portal_share_id_seq'::regclass);


--
-- Name: portal_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.portal_wizard ALTER COLUMN id SET DEFAULT nextval('public.portal_wizard_id_seq'::regclass);


--
-- Name: portal_wizard_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.portal_wizard_user ALTER COLUMN id SET DEFAULT nextval('public.portal_wizard_user_id_seq'::regclass);


--
-- Name: privacy_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_log ALTER COLUMN id SET DEFAULT nextval('public.privacy_log_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard_line ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_line_id_seq'::regclass);


--
-- Name: project_collaborator id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_collaborator ALTER COLUMN id SET DEFAULT nextval('public.project_collaborator_id_seq'::regclass);


--
-- Name: project_milestone id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_milestone ALTER COLUMN id SET DEFAULT nextval('public.project_milestone_id_seq'::regclass);


--
-- Name: project_project id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_project ALTER COLUMN id SET DEFAULT nextval('public.project_project_id_seq'::regclass);


--
-- Name: project_project_stage id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_project_stage ALTER COLUMN id SET DEFAULT nextval('public.project_project_stage_id_seq'::regclass);


--
-- Name: project_project_stage_delete_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_project_stage_delete_wizard ALTER COLUMN id SET DEFAULT nextval('public.project_project_stage_delete_wizard_id_seq'::regclass);


--
-- Name: project_role id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_role ALTER COLUMN id SET DEFAULT nextval('public.project_role_id_seq'::regclass);


--
-- Name: project_share_collaborator_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_share_collaborator_wizard ALTER COLUMN id SET DEFAULT nextval('public.project_share_collaborator_wizard_id_seq'::regclass);


--
-- Name: project_share_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_share_wizard ALTER COLUMN id SET DEFAULT nextval('public.project_share_wizard_id_seq'::regclass);


--
-- Name: project_tags id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_tags ALTER COLUMN id SET DEFAULT nextval('public.project_tags_id_seq'::regclass);


--
-- Name: project_task id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_task ALTER COLUMN id SET DEFAULT nextval('public.project_task_id_seq'::regclass);


--
-- Name: project_task_convert_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_task_convert_wizard ALTER COLUMN id SET DEFAULT nextval('public.project_task_convert_wizard_id_seq'::regclass);


--
-- Name: project_task_recurrence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_task_recurrence ALTER COLUMN id SET DEFAULT nextval('public.project_task_recurrence_id_seq'::regclass);


--
-- Name: project_task_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_task_type ALTER COLUMN id SET DEFAULT nextval('public.project_task_type_id_seq'::regclass);


--
-- Name: project_task_type_delete_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_task_type_delete_wizard ALTER COLUMN id SET DEFAULT nextval('public.project_task_type_delete_wizard_id_seq'::regclass);


--
-- Name: project_task_user_rel id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_task_user_rel ALTER COLUMN id SET DEFAULT nextval('public.project_task_user_rel_id_seq'::regclass);


--
-- Name: project_template_create_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_template_create_wizard ALTER COLUMN id SET DEFAULT nextval('public.project_template_create_wizard_id_seq'::regclass);


--
-- Name: project_template_role_to_users_map id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_template_role_to_users_map ALTER COLUMN id SET DEFAULT nextval('public.project_template_role_to_users_map_id_seq'::regclass);


--
-- Name: project_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.project_update ALTER COLUMN id SET DEFAULT nextval('public.project_update_id_seq'::regclass);


--
-- Name: properties_base_definition id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.properties_base_definition ALTER COLUMN id SET DEFAULT nextval('public.properties_base_definition_id_seq'::regclass);


--
-- Name: rating_rating id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.rating_rating ALTER COLUMN id SET DEFAULT nextval('public.rating_rating_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_device_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_device_log ALTER COLUMN id SET DEFAULT nextval('public.res_device_log_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_groups_privilege id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups_privilege ALTER COLUMN id SET DEFAULT nextval('public.res_groups_privilege_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_role id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_role ALTER COLUMN id SET DEFAULT nextval('public.res_role_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: res_users_settings_embedded_action id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_embedded_action ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_embedded_action_id_seq'::regclass);


--
-- Name: res_users_settings_volumes id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_volumes ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_volumes_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: resource_calendar id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_id_seq'::regclass);


--
-- Name: resource_calendar_attendance id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar_attendance ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_attendance_id_seq'::regclass);


--
-- Name: resource_calendar_leaves id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar_leaves ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_leaves_id_seq'::regclass);


--
-- Name: resource_resource id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_resource ALTER COLUMN id SET DEFAULT nextval('public.resource_resource_id_seq'::regclass);


--
-- Name: server_action_history_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.server_action_history_wizard ALTER COLUMN id SET DEFAULT nextval('public.server_action_history_wizard_id_seq'::regclass);


--
-- Name: sms_account_code id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_code ALTER COLUMN id SET DEFAULT nextval('public.sms_account_code_id_seq'::regclass);


--
-- Name: sms_account_phone id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_phone ALTER COLUMN id SET DEFAULT nextval('public.sms_account_phone_id_seq'::regclass);


--
-- Name: sms_account_sender id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_sender ALTER COLUMN id SET DEFAULT nextval('public.sms_account_sender_id_seq'::regclass);


--
-- Name: sms_composer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_composer ALTER COLUMN id SET DEFAULT nextval('public.sms_composer_id_seq'::regclass);


--
-- Name: sms_sms id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_sms ALTER COLUMN id SET DEFAULT nextval('public.sms_sms_id_seq'::regclass);


--
-- Name: sms_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template ALTER COLUMN id SET DEFAULT nextval('public.sms_template_id_seq'::regclass);


--
-- Name: sms_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_preview ALTER COLUMN id SET DEFAULT nextval('public.sms_template_preview_id_seq'::regclass);


--
-- Name: sms_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_reset ALTER COLUMN id SET DEFAULT nextval('public.sms_template_reset_id_seq'::regclass);


--
-- Name: sms_tracker id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_tracker ALTER COLUMN id SET DEFAULT nextval('public.sms_tracker_id_seq'::regclass);


--
-- Name: snailmail_letter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.snailmail_letter ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_id_seq'::regclass);


--
-- Name: spreadsheet_cell_thread id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_cell_thread ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_cell_thread_id_seq'::regclass);


--
-- Name: spreadsheet_dashboard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_dashboard ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_dashboard_id_seq'::regclass);


--
-- Name: spreadsheet_dashboard_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_dashboard_group ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_dashboard_group_id_seq'::regclass);


--
-- Name: spreadsheet_dashboard_share id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_dashboard_share ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_dashboard_share_id_seq'::regclass);


--
-- Name: spreadsheet_revision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.spreadsheet_revision ALTER COLUMN id SET DEFAULT nextval('public.spreadsheet_revision_id_seq'::regclass);


--
-- Name: task_share_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.task_share_wizard ALTER COLUMN id SET DEFAULT nextval('public.task_share_wizard_id_seq'::regclass);


--
-- Name: timer_timer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.timer_timer ALTER COLUMN id SET DEFAULT nextval('public.timer_timer_id_seq'::regclass);


--
-- Name: uom_uom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.uom_uom ALTER COLUMN id SET DEFAULT nextval('public.uom_uom_id_seq'::regclass);


--
-- Name: utm_campaign id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_campaign ALTER COLUMN id SET DEFAULT nextval('public.utm_campaign_id_seq'::regclass);


--
-- Name: utm_medium id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_medium ALTER COLUMN id SET DEFAULT nextval('public.utm_medium_id_seq'::regclass);


--
-- Name: utm_source id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_source ALTER COLUMN id SET DEFAULT nextval('public.utm_source_id_seq'::regclass);


--
-- Name: utm_stage id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_stage ALTER COLUMN id SET DEFAULT nextval('public.utm_stage_id_seq'::regclass);


--
-- Name: utm_tag id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.utm_tag ALTER COLUMN id SET DEFAULT nextval('public.utm_tag_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: web_tour_tour_step id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour_step ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_step_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: account_analytic_account; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_account (id, plan_id, root_plan_id, company_id, partner_id, create_uid, write_uid, code, name, active, create_date, write_date) FROM stdin;
1	3	3	\N	\N	1	1	\N	{"en_US": "Time Off", "es_419": "Vacaciones"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
2	3	3	\N	\N	1	1	\N	{"en_US": "Operating Costs", "es_419": "Costos operativos"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
3	1	1	\N	9	1	1	\N	{"en_US": "Our Super Product", "es_419": "Nuestro increíble producto"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
4	1	1	\N	9	1	1	\N	{"en_US": "Seagate P2", "es_419": "Seagate P2"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
5	1	1	\N	10	1	1	\N	{"en_US": "Millennium Industries", "es_419": "Millennium Industries"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
6	1	1	\N	15	1	1	\N	{"en_US": "CampToCamp", "es_419": "CampToCamp"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
7	1	1	\N	9	1	1	\N	{"en_US": "Deco Addict", "es_419": "Deco Addict"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
8	1	1	\N	8	1	1	\N	{"en_US": "Asustek", "es_419": "Asustek"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
9	1	1	\N	11	1	1	\N	{"en_US": "Delta PC", "es_419": "Delta PC"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
10	1	1	\N	8	1	1	\N	{"en_US": "Spark Systems", "es_419": "Spark Systems"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
11	1	1	\N	15	1	1	\N	{"en_US": "Nebula", "es_419": "Nebula"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
12	1	1	\N	10	1	1	\N	{"en_US": "Luminous Technologies", "es_419": "Luminous Technologies"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
13	1	1	\N	15	1	1	\N	{"en_US": "Desertic - Hispafuentes", "es_419": "Desertic - Hispafuentes"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
14	1	1	\N	16	1	1	\N	{"en_US": "Lumber Inc", "es_419": "Lumber Inc"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
15	1	1	\N	15	1	1	\N	{"en_US": "Camp to Camp", "es_419": "Camp to Camp"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
16	1	1	\N	\N	1	1	\N	{"en_US": "Active account", "es_419": "Cuenta activa"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
17	2	2	\N	\N	1	1	\N	{"en_US": "Administrative", "es_419": "Administrativo"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
18	2	2	\N	\N	1	1	\N	{"en_US": "Commercial & Marketing", "es_419": "Comercial y marketing"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
19	2	2	\N	\N	1	1	\N	{"en_US": "Research & Development", "es_419": "Investigación y desarrollo"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
20	2	2	\N	\N	1	1	\N	{"en_US": "Human Resources", "es_419": "Recursos humanos"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
21	2	2	\N	\N	1	1	\N	{"en_US": "Legal", "es_419": "Legal"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
22	2	2	\N	\N	1	1	\N	{"en_US": "Finance", "es_419": "Finanzas"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
23	2	2	\N	\N	1	1	\N	{"en_US": "Production", "es_419": "Producción"}	t	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
27	1	1	\N	\N	1	1	\N	{"en_US": "Home Construction", "es_419": "Construcción de casas"}	t	2025-12-18 15:14:48.812278	2025-12-18 15:14:48.812278
24	1	1	\N	\N	1	1	\N	{"en_US": "Office Design", "es_419": "Diseño de la oficina"}	t	2025-12-18 15:14:48.812278	2025-12-18 15:14:48.812278
26	1	1	\N	\N	1	1	\N	{"en_US": "Renovations", "es_419": "Renovaciones"}	t	2025-12-18 15:14:48.812278	2025-12-18 15:14:48.812278
25	1	1	\N	\N	1	1	\N	{"en_US": "Research & Development", "es_419": "Investigación y desarrollo"}	t	2025-12-18 15:14:48.812278	2025-12-18 15:14:48.812278
28	1	1	1	\N	1	1	\N	{"en_US": "Internal"}	t	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191
29	1	1	\N	\N	1	1	\N	{"en_US": "VIP Support"}	t	2025-12-18 15:14:57.292494	2025-12-18 15:14:57.292494
\.


--
-- Data for Name: account_analytic_applicability; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_applicability (id, analytic_plan_id, company_id, create_uid, write_uid, business_domain, applicability, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: account_analytic_distribution_model; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_distribution_model (id, sequence, partner_id, partner_category_id, company_id, create_uid, write_uid, analytic_distribution, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: account_analytic_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_line (id, account_id, product_uom_id, partner_id, user_id, company_id, currency_id, create_uid, write_uid, name, category, date, amount, create_date, write_date, unit_amount, x_plan2_id, x_plan3_id, task_id, parent_task_id, project_id, department_id, manager_id, employee_id, validated, helpdesk_ticket_id) FROM stdin;
1	25	4	\N	2	1	1	1	1	Requirements analysis	other	2025-12-17	-200.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	\N	\N	2	2	1	1	\N	\N
2	25	4	\N	2	1	1	1	1	Design	other	2025-12-17	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	\N	\N	2	2	1	1	\N	\N
3	25	4	\N	2	1	1	1	1	Quality analysis	other	2025-12-17	-300.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	\N	\N	2	2	1	1	\N	\N
4	25	4	\N	2	1	1	1	1	Quality analysis	other	2025-12-17	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	\N	\N	2	2	1	1	\N	\N
5	25	4	\N	2	1	1	1	1	Delivery	other	2025-12-17	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	\N	\N	2	2	1	1	\N	\N
218	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-08	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	36	\N	2	4	18	19	\N	\N
219	25	4	\N	\N	1	1	1	1	Call	other	2025-12-08	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	36	\N	2	3	2	8	\N	\N
220	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-08	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	36	\N	2	4	4	10	\N	\N
221	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-08	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	36	\N	2	3	1	2	\N	\N
222	25	4	\N	\N	1	1	1	1	Call	other	2025-12-08	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	36	\N	2	5	10	14	\N	\N
223	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-08	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	36	\N	2	4	3	4	\N	\N
224	25	4	\N	5	1	1	1	1	Presentation	other	2025-12-08	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	36	\N	2	4	1	3	\N	\N
225	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-08	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	36	\N	2	7	2	7	\N	\N
226	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-08	-55.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	36	\N	2	3	2	9	\N	\N
227	25	4	\N	\N	1	1	1	1	Call	other	2025-12-09	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	36	\N	2	7	5	12	\N	\N
228	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-09	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	36	\N	2	7	5	13	\N	\N
229	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-10	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	4	3	4	\N	\N
230	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-10	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	7	2	7	\N	\N
231	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-10	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	37	\N	2	7	5	13	\N	\N
232	25	4	\N	5	1	1	1	1	Requirements analysis	other	2025-12-10	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	37	\N	2	4	1	3	\N	\N
233	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-10	-65.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	4	3	16	\N	\N
234	25	4	\N	\N	1	1	1	1	Call	other	2025-12-10	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	37	\N	2	7	2	7	\N	\N
235	25	4	\N	\N	1	1	1	1	Design	other	2025-12-10	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	4	4	10	\N	\N
236	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-11	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	4	4	10	\N	\N
237	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-11	-55.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	3	2	9	\N	\N
238	25	4	\N	\N	1	1	1	1	Call	other	2025-12-11	-110.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	37	\N	2	3	2	9	\N	\N
239	25	4	\N	\N	1	1	1	1	Design	other	2025-12-11	-55.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	3	2	9	\N	\N
240	25	4	\N	2	1	1	1	1	Delivery	other	2025-12-11	-200.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	37	\N	2	2	1	1	\N	\N
241	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-11	-165.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	37	\N	2	3	2	9	\N	\N
242	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-11	-195.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	37	\N	2	4	3	16	\N	\N
243	25	4	\N	\N	1	1	1	1	Training	other	2025-12-11	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	4	18	19	\N	\N
244	25	4	\N	\N	1	1	1	1	Training	other	2025-12-11	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	7	2	7	\N	\N
245	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-11	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	7	5	12	\N	\N
246	25	4	\N	\N	1	1	1	1	Call	other	2025-12-11	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	37	\N	2	7	5	11	\N	\N
247	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-11	-195.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	37	\N	2	4	3	16	\N	\N
248	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-11	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	1	1	5	\N	\N
249	25	4	\N	\N	1	1	1	1	Design	other	2025-12-12	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	6	3	18	\N	\N
250	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-12	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	37	\N	2	6	3	18	\N	\N
251	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-12	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	7	5	13	\N	\N
252	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-12	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	37	\N	2	7	2	7	\N	\N
253	25	4	\N	\N	1	1	1	1	Design	other	2025-12-12	-135.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	37	\N	2	4	4	10	\N	\N
254	25	4	\N	2	1	1	1	1	Requirements analysis	other	2025-12-12	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	2	1	1	\N	\N
255	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-12	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	37	\N	2	4	18	19	\N	\N
256	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-14	-65.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	38	\N	2	4	3	16	\N	\N
257	25	4	\N	2	1	1	1	1	Delivery	other	2025-12-14	-300.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	38	\N	2	2	1	1	\N	\N
258	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-14	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	38	\N	2	2	3	15	\N	\N
259	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-14	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	38	\N	2	4	18	19	\N	\N
260	25	4	\N	\N	1	1	1	1	Design	other	2025-12-14	-120.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	38	\N	2	4	18	20	\N	\N
261	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-15	-195.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	38	\N	2	4	3	16	\N	\N
262	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-15	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	38	\N	2	3	2	8	\N	\N
263	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-15	-10.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	38	\N	2	7	2	6	\N	\N
264	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-15	-110.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	38	\N	2	3	2	9	\N	\N
265	25	4	\N	5	1	1	1	1	Presentation	other	2025-12-15	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	38	\N	2	4	1	3	\N	\N
266	25	4	\N	\N	1	1	1	1	Call	other	2025-12-16	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	38	\N	2	7	2	7	\N	\N
267	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-16	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	38	\N	2	3	1	2	\N	\N
268	25	4	\N	\N	1	1	1	1	Training	other	2025-12-16	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	38	\N	2	6	3	18	\N	\N
269	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-16	-120.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	38	\N	2	3	1	2	\N	\N
270	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-16	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	38	\N	2	3	1	2	\N	\N
271	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-16	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	38	\N	2	5	10	14	\N	\N
272	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-16	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	38	\N	2	3	2	8	\N	\N
273	25	4	\N	5	1	1	1	1	On Site Visit	other	2025-12-17	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	38	\N	2	4	1	3	\N	\N
274	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-17	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	38	\N	2	3	2	8	\N	\N
275	25	4	\N	\N	1	1	1	1	Call	other	2025-12-17	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	38	\N	2	4	3	4	\N	\N
276	25	4	\N	\N	1	1	1	1	Design	other	2025-12-13	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	7	5	12	\N	\N
277	25	4	\N	5	1	1	1	1	Presentation	other	2025-12-13	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	4	1	3	\N	\N
278	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-13	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	3	2	8	\N	\N
279	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-14	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	39	\N	2	7	5	11	\N	\N
280	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-14	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	3	2	8	\N	\N
281	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-15	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	39	\N	2	6	3	18	\N	\N
282	25	4	\N	\N	1	1	1	1	Call	other	2025-12-15	-195.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	39	\N	2	4	3	16	\N	\N
283	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-15	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	7	5	12	\N	\N
284	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-15	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	3	2	8	\N	\N
285	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-15	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	7	2	7	\N	\N
286	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-15	-130.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	39	\N	2	4	3	16	\N	\N
287	25	4	\N	\N	1	1	1	1	Training	other	2025-12-16	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	3	1	2	\N	\N
288	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-16	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	3	1	2	\N	\N
289	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-17	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	39	\N	2	4	3	4	\N	\N
290	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-17	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	5	10	14	\N	\N
291	25	4	\N	\N	1	1	1	1	Training	other	2025-12-18	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	7	5	12	\N	\N
292	25	4	\N	\N	1	1	1	1	Training	other	2025-12-19	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	4	4	10	\N	\N
293	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-19	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	4	18	20	\N	\N
294	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-19	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	4	4	10	\N	\N
295	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-20	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	39	\N	2	7	2	6	\N	\N
296	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-20	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	3	2	8	\N	\N
297	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-20	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	39	\N	2	4	18	19	\N	\N
298	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-15	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	40	\N	2	1	1	5	\N	\N
299	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-15	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	7	5	12	\N	\N
300	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-15	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	5	10	14	\N	\N
301	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-15	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	3	1	2	\N	\N
302	25	4	\N	\N	1	1	1	1	Call	other	2025-12-16	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	4	18	20	\N	\N
303	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-16	-55.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	3	2	9	\N	\N
304	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-16	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	40	\N	2	7	2	7	\N	\N
305	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-16	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	7	5	13	\N	\N
306	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-16	-120.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	40	\N	2	4	18	20	\N	\N
307	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-17	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	1	1	5	\N	\N
308	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-17	-120.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	40	\N	2	4	18	20	\N	\N
309	25	4	\N	\N	1	1	1	1	Design	other	2025-12-17	-90.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	40	\N	2	4	4	10	\N	\N
310	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-18	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	4	18	19	\N	\N
311	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-18	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	40	\N	2	3	2	8	\N	\N
312	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-18	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	7	5	12	\N	\N
313	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-18	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	40	\N	2	4	3	4	\N	\N
314	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-18	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	5	10	14	\N	\N
315	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-18	-65.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	4	3	16	\N	\N
316	25	4	\N	2	1	1	1	1	Quality analysis	other	2025-12-17	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	2	1	1	\N	\N
317	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-19	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	40	\N	2	6	3	18	\N	\N
318	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-19	-10.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	7	2	6	\N	\N
319	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-19	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	4	18	20	\N	\N
320	25	4	\N	5	1	1	1	1	Design	other	2025-12-19	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	4	1	3	\N	\N
321	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-20	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	40	\N	2	4	18	20	\N	\N
322	25	4	\N	\N	1	1	1	1	Training	other	2025-12-20	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	40	\N	2	4	18	20	\N	\N
323	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-13	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	41	\N	2	3	1	2	\N	\N
324	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-13	-130.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	41	\N	2	4	3	16	\N	\N
325	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-13	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	6	3	18	\N	\N
326	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-14	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	41	\N	2	7	2	7	\N	\N
327	25	4	\N	2	1	1	1	1	On Site Visit	other	2025-12-14	-300.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	41	\N	2	2	1	1	\N	\N
328	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-15	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	7	5	13	\N	\N
329	25	4	\N	2	1	1	1	1	Quality analysis	other	2025-12-15	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	2	1	1	\N	\N
330	25	4	\N	\N	1	1	1	1	Call	other	2025-12-15	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	7	5	12	\N	\N
331	25	4	\N	\N	1	1	1	1	Design	other	2025-12-15	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	4	10	17	\N	\N
332	25	4	\N	\N	1	1	1	1	Design	other	2025-12-15	-65.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	4	3	16	\N	\N
333	25	4	\N	5	1	1	1	1	Training	other	2025-12-16	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	41	\N	2	4	1	3	\N	\N
334	25	4	\N	5	1	1	1	1	Sprint	other	2025-12-16	-225.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	41	\N	2	4	1	3	\N	\N
335	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-16	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	4	3	4	\N	\N
336	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-16	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	3	1	2	\N	\N
337	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-17	-60.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	41	\N	2	4	10	17	\N	\N
338	25	4	\N	\N	1	1	1	1	Call	other	2025-12-17	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	4	18	19	\N	\N
339	25	4	\N	5	1	1	1	1	Call	other	2025-12-17	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	4	1	3	\N	\N
340	25	4	\N	5	1	1	1	1	Delivery	other	2025-12-17	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	4	1	3	\N	\N
341	25	4	\N	\N	1	1	1	1	Sprint	other	2025-12-17	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	5	10	14	\N	\N
342	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-18	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	41	\N	2	7	5	11	\N	\N
343	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-18	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	41	\N	2	7	2	6	\N	\N
6	24	4	7	5	1	1	1	1	Requirements analysis	other	2025-12-17	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	10	\N	1	4	1	3	\N	\N
7	24	4	7	\N	1	1	1	1	Delivery	other	2025-12-17	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	10	\N	1	3	2	8	\N	\N
8	24	4	7	\N	1	1	1	1	Training	other	2025-12-12	-105.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	10	\N	1	1	1	5	\N	\N
9	24	4	7	\N	1	1	1	1	Presentation	other	2025-12-10	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	10	\N	1	4	18	20	\N	\N
31	24	4	7	\N	1	1	1	1	Sprint	other	2025-12-16	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	11	\N	1	5	10	14	\N	\N
32	24	4	7	\N	1	1	1	1	Presentation	other	2025-12-15	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	11	\N	1	4	18	19	\N	\N
33	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-12-13	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	11	\N	1	3	2	8	\N	\N
34	24	4	7	\N	1	1	1	1	Call	other	2025-12-06	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	11	\N	1	7	5	13	t	\N
55	24	4	7	\N	1	1	1	1	Presentation	other	2025-12-16	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	14	\N	1	3	2	8	\N	\N
56	24	4	7	\N	1	1	1	1	Sprint	other	2025-12-14	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	14	\N	1	7	5	12	\N	\N
57	24	4	7	\N	1	1	1	1	Sprint	other	2025-12-14	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	14	\N	1	4	18	19	\N	\N
58	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-12-14	-90.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	14	\N	1	7	5	12	\N	\N
59	24	4	7	\N	1	1	1	1	Call	other	2025-12-10	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	14	\N	1	4	18	20	\N	\N
60	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-12-09	-135.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	14	\N	1	7	5	12	\N	\N
86	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-12-13	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	15	\N	1	4	10	17	\N	\N
87	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-12-12	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	15	\N	1	3	2	8	\N	\N
88	24	4	7	\N	1	1	1	1	Delivery	other	2025-12-11	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	15	\N	1	4	3	4	\N	\N
89	24	4	7	\N	1	1	1	1	Presentation	other	2025-12-11	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	15	\N	1	7	2	7	\N	\N
90	24	4	7	\N	1	1	1	1	Call	other	2025-12-10	-60.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	15	\N	1	4	10	17	\N	\N
91	24	4	7	\N	1	1	1	1	Design	other	2025-12-08	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	15	\N	1	4	3	4	\N	\N
112	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-12-15	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	16	\N	1	7	5	13	\N	\N
113	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-12-12	-165.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	16	\N	1	3	2	9	\N	\N
114	24	4	7	\N	1	1	1	1	Presentation	other	2025-12-08	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	16	\N	1	6	3	18	\N	\N
115	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-12-08	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	16	\N	1	7	2	6	\N	\N
135	24	4	7	\N	1	1	1	1	Sprint	other	2025-12-17	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	17	\N	1	7	5	12	\N	\N
136	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-12-16	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	17	\N	1	7	5	13	\N	\N
137	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-12-13	-130.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	2	\N	\N	17	\N	1	4	3	16	\N	\N
138	24	4	7	\N	1	1	1	1	Design	other	2025-12-09	-105.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	3	\N	\N	17	\N	1	3	2	8	\N	\N
139	24	4	7	\N	1	1	1	1	Training	other	2025-12-09	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	17	\N	1	7	5	12	\N	\N
167	24	4	7	\N	1	1	1	1	Training	other	2025-12-15	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	18	\N	1	3	2	8	\N	\N
168	24	4	7	\N	1	1	1	1	Call	other	2025-12-11	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	18	\N	1	7	5	12	\N	\N
186	24	4	7	\N	1	1	1	1	Call	other	2025-12-11	-10.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	22	\N	1	7	2	6	\N	\N
187	24	4	7	\N	1	1	1	1	Call	other	2025-12-11	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	1	\N	\N	22	\N	1	3	2	8	\N	\N
344	28	4	\N	2	1	1	1	1	Analysis	other	2025-12-18	0.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	0	\N	\N	71	\N	7	2	1	1	\N	\N
345	28	4	\N	2	1	1	1	1	Analysis	other	2025-12-18	0.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:54.609191	0	\N	\N	72	\N	7	2	1	1	\N	\N
191	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-03	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	4	10	17	t	\N
192	25	4	\N	\N	1	1	1	1	Design	other	2025-12-03	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	35	\N	2	3	1	2	t	\N
193	25	4	\N	\N	1	1	1	1	Call	other	2025-12-03	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	35	\N	2	7	5	11	t	\N
194	25	4	\N	\N	1	1	1	1	Call	other	2025-12-04	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	35	\N	2	5	10	14	t	\N
195	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-04	-120.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	35	\N	2	3	1	2	t	\N
196	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-04	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	7	5	13	t	\N
197	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-04	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	35	\N	2	5	10	14	t	\N
198	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-04	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	35	\N	2	6	3	18	t	\N
199	25	4	\N	\N	1	1	1	1	Call	other	2025-12-04	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	35	\N	2	4	3	4	t	\N
200	25	4	\N	\N	1	1	1	1	Call	other	2025-12-04	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	7	5	13	t	\N
201	25	4	\N	\N	1	1	1	1	Call	other	2025-12-04	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	35	\N	2	7	2	7	t	\N
202	25	4	\N	\N	1	1	1	1	Design	other	2025-12-04	-90.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	35	\N	2	2	3	15	t	\N
203	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-04	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	7	2	7	t	\N
204	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-04	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	7	5	12	t	\N
205	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-04	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	3	1	2	t	\N
206	25	4	\N	\N	1	1	1	1	Training	other	2025-12-04	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	7	5	11	t	\N
207	25	4	\N	\N	1	1	1	1	Delivery	other	2025-12-04	-60.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	35	\N	2	4	10	17	t	\N
208	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-04	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	4	18	20	t	\N
209	25	4	\N	\N	1	1	1	1	Call	other	2025-12-04	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	3	1	2	t	\N
210	25	4	\N	\N	1	1	1	1	Presentation	other	2025-12-05	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	3	2	8	t	\N
211	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-05	-105.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	35	\N	2	4	18	19	t	\N
212	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-05	-135.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	35	\N	2	4	4	10	t	\N
213	25	4	\N	\N	1	1	1	1	On Site Visit	other	2025-12-05	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	35	\N	2	5	10	14	t	\N
214	25	4	\N	\N	1	1	1	1	Requirements analysis	other	2025-12-06	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	36	\N	2	7	2	6	t	\N
215	25	4	\N	\N	1	1	1	1	Call	other	2025-12-06	-135.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	36	\N	2	7	5	12	t	\N
216	25	4	\N	\N	1	1	1	1	Design	other	2025-12-06	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	36	\N	2	4	4	10	t	\N
217	25	4	\N	\N	1	1	1	1	Quality analysis	other	2025-12-07	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	36	\N	2	4	3	4	t	\N
10	24	4	7	5	1	1	1	1	On Site Visit	other	2025-12-06	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	10	\N	1	4	1	3	t	\N
11	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-12-05	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	10	\N	1	5	10	14	t	\N
12	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-12-03	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	10	\N	1	3	2	8	t	\N
13	24	4	7	\N	1	1	1	1	Sprint	other	2025-12-01	-10.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	10	\N	1	7	2	6	t	\N
14	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-29	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	10	\N	1	6	3	18	t	\N
15	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-28	-65.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	10	\N	1	4	3	16	t	\N
16	24	4	7	\N	1	1	1	1	Design	other	2025-11-24	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	10	\N	1	1	1	5	t	\N
17	24	4	7	\N	1	1	1	1	Training	other	2025-11-22	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	10	\N	1	7	5	11	t	\N
18	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-21	-135.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	10	\N	1	4	4	10	t	\N
19	24	4	7	2	1	1	1	1	Quality analysis	other	2025-11-20	-200.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	10	\N	1	2	1	1	t	\N
20	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-11-20	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	10	\N	1	5	10	14	t	\N
21	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-16	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	10	\N	1	7	5	12	t	\N
35	24	4	7	\N	1	1	1	1	Delivery	other	2025-12-06	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	3	1	2	t	\N
36	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-12-04	-135.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	11	\N	1	7	5	12	t	\N
37	24	4	7	\N	1	1	1	1	Design	other	2025-11-29	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	4	18	19	t	\N
38	24	4	7	\N	1	1	1	1	Training	other	2025-11-28	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	7	5	12	t	\N
39	24	4	7	\N	1	1	1	1	Design	other	2025-11-25	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	4	4	10	t	\N
40	24	4	7	\N	1	1	1	1	Training	other	2025-11-23	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	4	18	19	t	\N
41	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-20	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	7	2	7	t	\N
42	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-11-18	-55.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	3	2	9	t	\N
43	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-17	-105.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	11	\N	1	4	18	19	t	\N
61	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-12-07	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	2	3	15	t	\N
62	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-12-03	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	7	5	12	t	\N
63	24	4	7	\N	1	1	1	1	Training	other	2025-12-01	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	7	5	13	t	\N
64	24	4	7	\N	1	1	1	1	Presentation	other	2025-11-30	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	7	5	11	t	\N
65	24	4	7	\N	1	1	1	1	Call	other	2025-11-28	-130.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	14	\N	1	4	3	16	t	\N
66	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-11-23	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	4	3	4	t	\N
67	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-21	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	4	18	19	t	\N
68	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-21	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	14	\N	1	3	1	2	t	\N
69	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-17	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	14	\N	1	7	2	7	t	\N
92	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-12-07	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	5	10	14	t	\N
93	24	4	7	\N	1	1	1	1	Presentation	other	2025-12-05	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	4	4	10	t	\N
94	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-12-05	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	4	10	17	t	\N
95	24	4	7	\N	1	1	1	1	Design	other	2025-12-02	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	1	1	5	t	\N
96	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-12-02	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	15	\N	1	7	5	13	t	\N
97	24	4	7	\N	1	1	1	1	Design	other	2025-11-27	-60.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	15	\N	1	4	10	17	t	\N
98	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-26	-135.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	15	\N	1	7	5	12	t	\N
99	24	4	7	\N	1	1	1	1	Training	other	2025-11-25	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	3	2	8	t	\N
100	24	4	7	\N	1	1	1	1	Training	other	2025-11-22	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	7	5	11	t	\N
101	24	4	7	2	1	1	1	1	Design	other	2025-11-19	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	2	1	1	t	\N
116	24	4	7	\N	1	1	1	1	Training	other	2025-12-04	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	16	\N	1	4	3	4	t	\N
117	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-12-01	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	4	10	17	t	\N
118	24	4	7	\N	1	1	1	1	Call	other	2025-11-29	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	7	5	12	t	\N
119	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-11-27	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	16	\N	1	7	5	13	t	\N
120	24	4	7	\N	1	1	1	1	Design	other	2025-11-26	-120.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	16	\N	1	3	1	2	t	\N
121	24	4	7	\N	1	1	1	1	Design	other	2025-11-25	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	16	\N	1	1	1	5	t	\N
122	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-23	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	16	\N	1	7	2	7	t	\N
123	24	4	7	\N	1	1	1	1	Call	other	2025-11-19	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	5	10	14	t	\N
124	24	4	7	\N	1	1	1	1	Presentation	other	2025-11-18	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	16	\N	1	4	18	20	t	\N
125	24	4	7	\N	1	1	1	1	Presentation	other	2025-11-18	-110.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	16	\N	1	3	2	9	t	\N
126	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-17	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	3	1	2	t	\N
140	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-12-07	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	4	18	20	t	\N
141	24	4	7	\N	1	1	1	1	Call	other	2025-12-03	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	17	\N	1	7	5	11	t	\N
142	24	4	7	\N	1	1	1	1	Presentation	other	2025-12-02	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	7	5	13	t	\N
143	24	4	7	\N	1	1	1	1	Training	other	2025-11-30	-65.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	4	3	16	t	\N
144	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-11-26	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	17	\N	1	3	1	2	t	\N
145	24	4	7	\N	1	1	1	1	Presentation	other	2025-11-24	-90.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	17	\N	1	2	3	15	t	\N
146	24	4	7	\N	1	1	1	1	Call	other	2025-11-22	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	4	4	10	t	\N
147	24	4	7	\N	1	1	1	1	Sprint	other	2025-11-15	-90.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	17	\N	1	2	3	15	t	\N
148	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-15	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	4	18	20	t	\N
149	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-11-14	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	17	\N	1	5	10	14	t	\N
169	24	4	7	\N	1	1	1	1	Design	other	2025-12-04	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	4	18	20	t	\N
170	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-30	-135.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	18	\N	1	2	3	15	t	\N
171	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-11-27	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	18	\N	1	3	1	2	t	\N
172	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-24	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	4	18	20	t	\N
173	24	4	7	\N	1	1	1	1	Sprint	other	2025-11-19	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	1	1	5	t	\N
174	24	4	7	\N	1	1	1	1	Training	other	2025-11-16	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	4	10	17	t	\N
175	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-11-16	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	4	10	17	t	\N
176	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-15	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	6	3	18	t	\N
188	24	4	7	\N	1	1	1	1	Meeting	other	2025-12-04	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	24	22	1	3	1	2	t	\N
189	24	4	7	\N	1	1	1	1	Summary Writing	other	2025-12-04	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	25	24	1	5	10	14	t	\N
190	24	4	7	\N	1	1	1	1	Preparation	other	2025-12-04	-90.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	26	24	1	7	5	12	t	\N
22	24	4	7	\N	1	1	1	1	Design	other	2025-11-14	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	10	\N	1	7	5	13	t	\N
23	24	4	7	\N	1	1	1	1	Training	other	2025-11-13	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	10	\N	1	1	1	5	t	\N
24	24	4	7	\N	1	1	1	1	Presentation	other	2025-11-11	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	10	\N	1	5	10	14	t	\N
25	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-10	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	10	\N	1	7	2	6	t	\N
26	24	4	7	\N	1	1	1	1	Call	other	2025-10-31	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	10	\N	1	4	3	4	t	\N
27	24	4	7	\N	1	1	1	1	Design	other	2025-10-30	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	10	\N	1	7	5	11	t	\N
28	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-10-29	-105.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	10	\N	1	4	18	19	t	\N
29	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-10-28	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	10	\N	1	4	10	17	t	\N
30	24	4	7	\N	1	1	1	1	Design	other	2025-10-24	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	10	\N	1	7	5	13	t	\N
44	24	4	7	\N	1	1	1	1	Sprint	other	2025-11-14	-165.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	11	\N	1	3	2	9	t	\N
45	24	4	7	5	1	1	1	1	Presentation	other	2025-11-13	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	4	1	3	t	\N
46	24	4	7	\N	1	1	1	1	Training	other	2025-11-12	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	11	\N	1	7	5	13	t	\N
47	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-10	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	7	2	7	t	\N
48	24	4	7	\N	1	1	1	1	Training	other	2025-11-09	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	2	3	15	t	\N
49	24	4	7	\N	1	1	1	1	Training	other	2025-11-06	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	4	18	19	t	\N
50	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-11-02	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	7	5	13	t	\N
51	24	4	7	\N	1	1	1	1	Presentation	other	2025-10-30	-105.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	11	\N	1	4	18	19	t	\N
52	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-10-26	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	4	10	17	t	\N
53	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-10-26	-110.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	11	\N	1	3	2	9	t	\N
54	24	4	7	\N	1	1	1	1	Call	other	2025-10-19	-55.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	11	\N	1	3	2	9	t	\N
70	24	4	7	\N	1	1	1	1	Training	other	2025-11-11	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	6	3	18	t	\N
71	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-11	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	3	1	2	t	\N
72	24	4	7	\N	1	1	1	1	Training	other	2025-11-10	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	7	5	11	t	\N
73	24	4	7	\N	1	1	1	1	Presentation	other	2025-11-09	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	14	\N	1	4	3	4	t	\N
74	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-11-08	-55.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	3	2	9	t	\N
75	24	4	7	\N	1	1	1	1	Design	other	2025-11-08	-30.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	14	\N	1	5	10	14	t	\N
76	24	4	7	\N	1	1	1	1	Call	other	2025-11-07	-135.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	14	\N	1	4	4	10	t	\N
77	24	4	7	\N	1	1	1	1	Call	other	2025-11-04	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	7	5	11	t	\N
78	24	4	7	\N	1	1	1	1	Design	other	2025-11-04	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	14	\N	1	4	18	20	t	\N
79	24	4	7	5	1	1	1	1	Call	other	2025-11-03	-225.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	14	\N	1	4	1	3	t	\N
80	24	4	7	\N	1	1	1	1	Sprint	other	2025-11-03	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	14	\N	1	7	5	11	t	\N
81	24	4	7	\N	1	1	1	1	Design	other	2025-11-02	-105.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	14	\N	1	1	1	5	t	\N
82	24	4	7	\N	1	1	1	1	Presentation	other	2025-11-01	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	4	10	17	t	\N
83	24	4	7	\N	1	1	1	1	Call	other	2025-10-31	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	14	\N	1	7	5	13	t	\N
84	24	4	7	2	1	1	1	1	Delivery	other	2025-10-29	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	14	\N	1	2	1	1	t	\N
85	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-10-21	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	14	\N	1	5	10	14	t	\N
102	24	4	7	\N	1	1	1	1	Training	other	2025-11-12	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	7	5	12	t	\N
103	24	4	7	\N	1	1	1	1	Sprint	other	2025-11-09	-65.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	4	3	16	t	\N
104	24	4	7	\N	1	1	1	1	Design	other	2025-11-08	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	15	\N	1	1	1	5	t	\N
105	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-11-07	-130.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	15	\N	1	4	3	16	t	\N
106	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-05	-60.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	15	\N	1	4	10	17	t	\N
107	24	4	7	2	1	1	1	1	On Site Visit	other	2025-10-31	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	2	1	1	t	\N
108	24	4	7	\N	1	1	1	1	Delivery	other	2025-10-25	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	4	10	17	t	\N
109	24	4	7	\N	1	1	1	1	Delivery	other	2025-10-21	-100.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	15	\N	1	4	3	4	t	\N
110	24	4	7	\N	1	1	1	1	Presentation	other	2025-10-20	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	15	\N	1	4	10	17	t	\N
111	24	4	7	\N	1	1	1	1	Delivery	other	2025-10-19	-105.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	15	\N	1	1	1	5	t	\N
127	24	4	7	\N	1	1	1	1	Call	other	2025-11-13	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	16	\N	1	4	10	17	t	\N
128	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-07	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	7	2	7	t	\N
129	24	4	7	\N	1	1	1	1	Sprint	other	2025-11-06	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	7	5	13	t	\N
130	24	4	7	\N	1	1	1	1	Delivery	other	2025-11-04	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	2	3	15	t	\N
131	24	4	7	\N	1	1	1	1	Sprint	other	2025-11-03	-20.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	4	10	17	t	\N
132	24	4	7	\N	1	1	1	1	Presentation	other	2025-11-01	-195.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	16	\N	1	4	3	16	t	\N
133	24	4	7	\N	1	1	1	1	Delivery	other	2025-10-28	-15.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	5	10	14	t	\N
134	24	4	7	5	1	1	1	1	On Site Visit	other	2025-10-22	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	16	\N	1	4	1	3	t	\N
150	24	4	7	\N	1	1	1	1	Presentation	other	2025-11-12	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	4	18	19	t	\N
151	24	4	7	\N	1	1	1	1	Call	other	2025-11-06	-120.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	17	\N	1	3	1	2	t	\N
152	24	4	7	\N	1	1	1	1	Training	other	2025-11-05	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	3	2	8	t	\N
153	24	4	7	\N	1	1	1	1	Call	other	2025-11-05	-130.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	17	\N	1	4	3	16	t	\N
154	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-11-02	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	2	3	15	t	\N
155	24	4	7	5	1	1	1	1	Call	other	2025-11-01	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	4	1	3	t	\N
156	24	4	7	\N	1	1	1	1	Training	other	2025-10-29	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	17	\N	1	4	10	17	t	\N
157	24	4	7	\N	1	1	1	1	Presentation	other	2025-10-28	-50.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	17	\N	1	7	5	13	t	\N
158	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-10-27	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	7	5	11	t	\N
159	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-10-27	-40.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	4	18	20	t	\N
160	24	4	7	\N	1	1	1	1	Training	other	2025-10-27	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	7	5	12	t	\N
161	24	4	7	\N	1	1	1	1	Training	other	2025-10-24	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	7	5	12	t	\N
162	24	4	7	\N	1	1	1	1	Training	other	2025-10-23	-45.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	17	\N	1	6	3	18	t	\N
163	24	4	7	\N	1	1	1	1	Sprint	other	2025-10-23	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	7	5	11	t	\N
164	24	4	7	\N	1	1	1	1	Training	other	2025-10-22	-70.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	17	\N	1	1	1	5	t	\N
165	24	4	7	5	1	1	1	1	Presentation	other	2025-10-21	-150.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	17	\N	1	4	1	3	t	\N
166	24	4	7	5	1	1	1	1	Quality analysis	other	2025-10-20	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	17	\N	1	4	1	3	t	\N
177	24	4	7	\N	1	1	1	1	Call	other	2025-10-30	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	1	1	5	t	\N
178	24	4	7	\N	1	1	1	1	Quality analysis	other	2025-10-26	-55.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	3	2	9	t	\N
179	24	4	7	\N	1	1	1	1	Delivery	other	2025-10-25	-105.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	3	\N	\N	18	\N	1	3	2	8	t	\N
180	24	4	7	\N	1	1	1	1	Presentation	other	2025-10-25	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	1	1	5	t	\N
181	24	4	7	\N	1	1	1	1	Presentation	other	2025-10-24	-25.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	7	5	13	t	\N
182	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-10-23	-80.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	18	\N	1	3	1	2	t	\N
183	24	4	7	\N	1	1	1	1	On Site Visit	other	2025-10-22	-90.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	2	\N	\N	18	\N	1	4	4	10	t	\N
184	24	4	7	\N	1	1	1	1	Requirements analysis	other	2025-10-20	-35.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	4	18	19	t	\N
185	24	4	7	5	1	1	1	1	Requirements analysis	other	2025-10-19	-75.00	2025-12-18 15:14:54.609191	2025-12-18 15:14:56.790277	1	\N	\N	18	\N	1	4	1	3	t	\N
346	2	4	9	2	1	1	1	1	Fix Drawer Slides	other	2025-12-17	-100.00	2025-12-18 15:14:57.292494	2025-12-18 15:14:57.292494	1	\N	\N	\N	\N	8	2	1	1	\N	16
347	2	4	9	2	1	1	1	1	Changed Drawer Handle	other	2025-12-17	-50.00	2025-12-18 15:14:57.292494	2025-12-18 15:14:57.292494	0.5	\N	\N	\N	\N	8	2	1	1	\N	16
\.


--
-- Data for Name: account_analytic_line_calendar_employee; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_line_calendar_employee (id, user_id, employee_id, create_uid, write_uid, checked, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: account_analytic_line_hr_timesheet_merge_wizard_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_line_hr_timesheet_merge_wizard_rel (hr_timesheet_merge_wizard_id, account_analytic_line_id) FROM stdin;
\.


--
-- Data for Name: account_analytic_plan; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.account_analytic_plan (id, parent_id, color, sequence, create_uid, write_uid, parent_path, complete_name, name, default_applicability, description, create_date, write_date) FROM stdin;
2	\N	3	10	1	1	2/	Departments	{"en_US": "Departments", "es_419": "Departamentos"}	\N	\N	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
3	\N	5	10	1	1	3/	Internal	{"en_US": "Internal", "es_419": "Interno"}	{"1": "unavailable"}	\N	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
1	\N	8	10	1	1	1/	Project	{"en_US": "Project", "es_419": "Proyecto"}	\N	\N	2025-12-18 15:14:40.976009	2025-12-18 15:14:40.976009
\.


--
-- Data for Name: activity_attachment_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.activity_attachment_rel (activity_id, attachment_id) FROM stdin;
\.


--
-- Data for Name: ai_agent; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent (id, partner_id, create_uid, write_uid, subtitle, response_style, llm_model, system_prompt, active, restrict_to_sources, is_system_agent, create_date, write_date) FROM stdin;
1	61	1	1	Your Odoo sidekick for most day-to-day tasks.	balanced	gpt-4o	\N	t	\N	t	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
2	62	2	1	Used for searching information across your database.	analytical	gemini-2.5-flash	# Odoo Ask AI agent\n\nYou are an agent dedicated to help the user with his Odoo database. To help him in his tasks, you have access to a bunch of tools related to search which can be used to retrieve information about the database. You also have another set of tools which you can use to move the user around in the UI.\n\n## General Rules\n\n- You must NEVER display errors to the user. If you cannot complete the query, just say that you weren't able to fulfil the query.\n- ONLY use tools if you really need to, if the question is not related to Odoo, or information of the database, use your general knowledge.\n- If you encounter a forbidden action error, say you are not allowed to perform the actions needed to fulfil the user's query.\n- Only use action ids you have access to, do not make up tool calls.\n\n## Topics\n\nBelow, you'll find a description of topics you have access to along with a list of the tools they offer.\n\n### Information retrieval\n\nThis is the PRIMARY topic you must consider when answering a query, it contains the following tools that are related to search and analysis of the content of the Odoo database:\n\n- Get Fields\n- Search\n- Read group\n\n**Triggers**\n\nWhen one (or more) of these triggers is TRUE for the user's query, use Information retrieval tools.\n\n- Simple questions\n- Queries that are not related to opening view, or showing content\n- **Keywords**: Who, When, How, etc.\n\n**Examples**\n\n- Who are the top salespersons this month?\n- Do I have customers in Belgium?\n\n### Natural Language Search tools\n\nThese are the tools related to interactions with the view in Odoo, you'll use it to move to the appropriate view and apply proper filters inside of these views:\n\n- Get Fields\n- Compute Report Measures\n- Get Menu Details\n- Open Menu Graph\n- Open Menu Kanban\n- Open Menu List\n- Open Menu Pivot\n\n**Triggers**\n\nWhen one (or more) of these triggers is TRUE for the user's query, use Natural Language Search tools.\n\n- Queries related to navigation within Odoo\n- **Keywords**: show, open, view, see.\n\n**Examples**\n\n- Show me the top salespersons this month\n- Open a graph view of the best sellers of the last six months\n\n## Tools Selection\n\n- ALWAYS use Information retrieval tools. You must not perform view operations unless EXPLICITELY told to\n        	t	\N	f	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
3	63	2	1	Helps you with any legal issue related to Odoo.	analytical	gpt-4o	You are a legal advisor in your company. Based on the official documentation you've been given, your job is to help employees navigate legal issues.\nTo do so, keep your answer really short, making it as clear as possible.\n        	t	\N	f	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
\.


--
-- Data for Name: ai_agent_ai_topic_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent_ai_topic_rel (ai_agent_id, ai_topic_id) FROM stdin;
2	2
2	1
\.


--
-- Data for Name: ai_agent_source; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent_source (id, agent_id, attachment_id, create_uid, write_uid, name, type, status, url, error_details, is_active, create_date, write_date) FROM stdin;
1	3	416	1	1	Odoo Enterprise Agreement	binary	processing	\N	\N	\N	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
\.


--
-- Data for Name: ai_composer; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_composer (id, ai_agent, create_uid, write_uid, name, interface_key, default_prompt, is_system_default, create_date, write_date) FROM stdin;
1	1	1	1	Mail/Note Composer	mail_composer	Your job is to help with drafting messages. If the user asks you to write a reply or a message, YOUR REPLY WILL BE INSERTED AS IS for the correspondence. Follow the tone from the previous correspondence, and **WRITE ONLY THE BODY OF THE MESSAGE. DO NOT ADD ADDITIONAL COMMENTARY, A SUBJECT LINE, OR A SIGNATURE.** Format your messages like an email, beginning with a greeting, and the rest of the content in a new line.	t	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
2	1	1	1	Record HTML Fields	html_field_record	Your job is to help with drafting the description of an odoo record. If the user asks you to write something, **YOUR REPLY WILL BE INSERTED AS IS for the description. DO NOT ADD ANY EXTRA COMMENTARY THAT SHOULDN'T APPEAR IN THE DESCRIPTION.** Give your answers succinctly and to the point.	t	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
3	1	1	1	Text Selector	html_field_text_select	Your job is to suggest alternatives to a piece of text the user has written. If the user asks you to rewrite the text in a specific way, **YOUR ANSWER WILL BE REPLACING THE ORIGINAL TEXT AS IS, thus DO NOT ADD ADDITIONAL COMMENTARY**.	t	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
4	1	1	1	Chatter Helper	chatter_ai_button	Your job is to assist the user with the chatter correspondence. If the user asks you to summarize the chatter conversation, reply with a small description for the conversation and then a list of all the key messages in the correspondence. Each bullet point should have a general title in bold and a description in plaintext. If the user asks you to write a reply or a message, **YOUR REPLY WILL BE INSERTED AS IS**. Follow the tone from the previous messages in the chatter. **WRITE ONLY THE BODY OF THE MESSAGE. DO NOT ADD ADDITIONAL COMMENTARY, A SUBJECT LINE, OR A SIGNATURE.** Format your messages like an email, beginning with a greeting, and the rest of the content in a new line.	t	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
5	1	1	1	Mail Template Prompt Evaluator	html_prompt_shortcut	\nYou are an Email Prompt Transformer. You'll get a single instruction or rough prompt and must output a concise, professional snippet for a customer-facing email body—no commentary because your output will be inserted directly into an email, without any changes.\n\n**1. Execute**\n- Read the input as a command or sketch and produce the intended text.\n- If you can't help, return an empty string.\n\n**2. Placeholders**\n- Ideas/constructs that are linked to literals like `false`, `undefined`, `null` or bracketed value like `[value]` should be ignored and don't invent any values.\n- Don't invent dates, names, or other details.\n\n**3. Unquote**\n- Remove surrounding quotes from any quoted text.\n\n**4. Polish**\n- Eliminate redundancies, filler, apologies, or uncertainty (e.g. "I'm not sure").\n- Use the requested language.\n\n**5. Output only**\n- Return exactly the email fragment (body only), with no subject, labels, or extra formatting.\n\n---\n\n**Examples**\n\n- **Input:**\n  `Insert a greeting for the buyer, mentioning "Burger Maison" and reminding them of [deadline].`\n  **Output:**\n  `We're thrilled to announce the launch of Burger Maison—thank you for your continued partnership.`\n  **Explanation:**\n  There is no value for `[deadline]`, so that part where the input asks for reminding is ignored.\n\n- **Input:**\n  `Please thank [name] for their purchase of "Deluxe Toolkit" and mention shipment on false.`\n  **Output:**\n  `Thank you for purchasing Deluxe Toolkit. Your order will shipped shortly.`\n   **Explanation:**\n   There is no value for `[name]` so the "thank" is generic. The shipment date is also missing so the shipping information is also a generic statement.\n\n- **Input:**\n  `Add a closing line wishing them a great weekend.`\n  **Output:**\n  `Have a wonderful weekend, and feel free to reach out with any questions.`\n            	t	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
6	2	1	1	Ask AI	systray_ai_button	\N	t	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
7	1	1	1	Summarize Voice Transcription	voice_transcription_component	Summarize the transcript below.\n\nYour summary should be structured in a way that is easy to skim. It should only contain the essential information.\nIt must be in markdown format. Do NOT put the main markup inside code blocks.	t	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
\.


--
-- Data for Name: ai_composer_ir_model_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_composer_ir_model_rel (ai_composer_id, ir_model_id) FROM stdin;
\.


--
-- Data for Name: ai_embedding; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_embedding (id, attachment_id, sequence, create_uid, write_uid, embedding_model, content, has_embedding_generation_failed, create_date, write_date, embedding_vector) FROM stdin;
\.


--
-- Data for Name: ai_prompt_button; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_prompt_button (id, sequence, composer_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	10	4	1	1	Summarize the chatter conversation	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
2	20	4	1	1	Write a followup answer	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
3	10	1	1	1	Write a followup answer	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
4	10	3	1	1	Rewrite selected text	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
5	10	6	1	1	Top reason for which people opt-out from lists	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
6	10	6	1	1	Single most common stock move from/to	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
7	10	7	1	1	Summarize this recruitment call	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
8	10	7	1	1	Summarize this prospect call	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
9	10	7	1	1	Write an email recap	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
10	10	6	1	1	Pie chart of sales by customer country	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
11	10	6	1	1	Pivot of products with less than 5 in stock	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
12	10	6	1	1	What's my agenda for today?	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
13	10	6	1	1	Top 5 sales reps by revenue	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
14	10	6	1	1	Show sales by product category this month	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
15	10	6	1	1	Bar chart of top-selling products	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
16	10	6	1	1	Do I have any customer in Japan?	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
17	10	6	1	1	Which project costs us the most?	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
18	10	6	1	1	Show me the current cash flow status	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
19	10	6	1	1	Summarize what the last tickets complain about	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
20	10	6	1	1	Latest PO from supplier Azure interior	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
21	10	6	1	1	Display the profit margins by product category	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
22	10	6	1	1	5 blog ideas from my product catalog	2025-12-18 15:14:57.773741	2025-12-18 15:14:57.773741
\.


--
-- Data for Name: ai_tool_ids_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_tool_ids_rel (parent_id, tool_id) FROM stdin;
\.


--
-- Data for Name: ai_topic; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_topic (id, create_uid, write_uid, name, description, instructions, create_date, write_date) FROM stdin;
1	1	1	Natural Language Search	Supports interpretation of a user query to open the appropriate Odoo view with a set of tools necessary to perform the search.	# Odoo Natural Language Search Agent\n\n**Purpose**: Interpret natural language queries and execute navigation or in-view adjustments via tool calls. Always act—never replace an actionable response with plain text. If `current_view` exists, treat it as context for follow-ups.\n\n## 1. CRITICAL\n\n### **NEVER** explain requested tool calls\n\n## 2. Session Context Elements\n\n**CRITICAL**: The `<session_info_context>` element provides the available UI elements for each menu/view:\n\n- **`<searchable_fields>`**: Contains the fields that can be used in the `search` parameter\n- **`<filters>`**: list of available filter names for `selected_filters` parameter\n- **`<groupbys>`**: list of available groupby options for `selected_groupbys` parameter\n  - These are the primary source for grouping\n  - Fallback: Fields with groupable=true (but NO field chains)\n- **`<active_search_facets>`**: Contains all the active filters, search terms and groupbys.\n\n**Rule**: Always check session_info_context BEFORE constructing search/filter/groupby parameters.\n\n## 3. Execution Model & Tool Categories\n\n### Tool Categories\n**Terminating Tools** (max 1 successful per message):\n- Menu opening tools (for list, kanban, pivot, graph views) and search adjustment tool\n- These produce navigation or search state changes\n- Every terminating call MUST include `__end_message`\n\n**Supporting Tools** (should be batched as much as possible):\n- Menu details retrieval, field inspection, and report measures computation tools\n- Must be called BEFORE the terminating tool\n- Batch multiple supporting calls in a single message for efficiency\n\n### Execution Invariants (HARD GUARANTEES)\n1. **One Terminating Tool Rule**: Per user message, execute AT MOST one successful terminating tool\n2. **No Chaining**: Never chain multiple terminating tools - refinements belong to the next user message\n3. **Supporting Before Terminating**: All supporting tools must precede the terminating tool\n4. **Retry Limits**: Maximum 5 retry attempts for terminating tools (counting both successes and failures)\n5. **Retry Consistency**: When retrying, use the SAME terminating tool type - don't switch between menu opening and search adjustment tools\n6. **Failed = Error Only**: A terminating call is failed only if platform returns explicit error (invalid JSON, unknown field, unsupported view)\n7. **Fallback Required**: After max retries, emit best valid simplified action or brief refusal with explanation in `__end_message`\n\n## 4. CRITICAL PARAMETER RULES (Prevents Common Errors)\n\n**FUNDAMENTAL RULE**: Field chains (dotted paths like `lines.product_id.name`) are ONLY allowed in `custom_domain`.\n- **NEVER** use field chains for `search`, `filters`, or `groupbys` params\n\n### 4.1 The `search` Parameter\nAlso applies to the `apply_searchces` param.\n\n**STRICT RULES**:\n- **ONLY accepts fields from `<searchable_fields>` in session_info_context**\n- **NEVER use dotted paths** (e.g., WRONG: `lines.product_id.name`)\n- **Format**: `field=term` where `=` is a separator, NOT an operator\n- **No comparison operators allowed** (never `!=`, `>`, `<`, etc.)\n- **NO FIELD CHAINS** - if you need relational fields, use `custom_domain`\n\n**When to use `search`**:\n- Simple field matches where field exists in `<searchable_fields>`\n- Example: If `<searchable_fields>` contains `partner_id` and `state`, then `["partner_id=Azure", "state=draft"]` is valid\n\n### 4.2 The `custom_domain` Parameter\n**WHEN REQUIRED** (use to COMPLEMENT search when needed):\n- **ANY relational traversal** (dotted paths like `lines.product_id.name`)\n- **Comparison operators** (`>`, `<`, `!=`, etc.)\n- **Complex logic** (AND/OR combinations beyond simple filters)\n- **Conditions that cannot be expressed via search/filters**\n\n### 4.3 Combining search, filters and custom_domain\n\n**GUIDING PRINCIPLE**: search, filters and custom_domain COMPLEMENT each other (they are ANDed together)\n\n**Decision Process**:\n1. **First**: Check if conditions can be constructed using `search` and or `filter` (for simple top-level fields)\n2. **Then**: If they aren't sufficient, ADD a `custom_domain` for additional conditions\n3. **Best Practice**: Avoid repeating search terms in custom_domain (they're already ANDed)\n\n**Examples of Complementary Usage**:\n```\n# Simple fields in search, relational in custom_domain\nsearch=["state=draft", "partner_id=Azure"],\ncustom_domain="[[\\"lines.product_id.categ_id.name\\",\\"ilike\\",\\"drinks\\"]]"\n# Result: (state=draft AND partner_id=Azure AND lines contain drinks)\n\n# Search handles what it can, custom_domain adds complex conditions\nsearch=["config_id=restaurant"],\ncustom_domain="[[\\"amount_total\\",\\">\\",500]]"\n# Result: (config_id=restaurant AND amount_total > 500)\n```\n\n**When to use which**:\n- **search alone**: Simple top-level field matches with = operator\n- **filter alone**: Query can be represented by predefined filters.\n- **custom_domain alone**: When ALL conditions require dotted paths or operators\n- **All together**: When the query corresponds to complex conditions\n\n### 4.4 Other Search View Elements\n- **selected_filters**: ONLY filter names from `<filters>` in session_info_context\n  - filters that are in the same group are ORed, and ANDed between groups.\n  - Must match filter names exactly as they appear in `<filters>`\n  - NO field chains allowed - use existing filter names only\n- **selected_groupbys**: Primary source is `<groupbys>` in session_info_context\n  - First preference: Use groupby names from `<groupbys>` element\n  - Fallback only: Fields where groupable=true from field inspection (but NO field chains)\n  - **NEVER** use field chains. Refuse to groupby the requested grouping if the field isn't directly accessible to the current model.\n\n### 4.5 Constructing Custom Domains\n- A condition is a triplet: [field:str, operator:str, value:any]\n- value can't be a field - only literals (strings, numbers, lists)\n- A field can be a top-level field or a related field (using dotted paths).\n- The operator defines the relationship (comparison) between the field and the value.\n  - Can be any of: =, !=, <, >, <=, >=, in, not in, like, not like, ilike, not ilike\n- A **domain** is a collection of conditions