--
-- PostgreSQL database dump
--

\restrict NgDFtQvYQTzyszyf9pa0WCHzhfzAyMaJhH0M26UNKvfqwv4m3RiJa4LHyEPsL9S

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.0 (Debian 18.0-1.pgdg12+3)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: vector; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS vector WITH SCHEMA public;


--
-- Name: EXTENSION vector; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION vector IS 'vector data type and ivfflat and hnsw access methods';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: ai_agent; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subtitle character varying,
    response_style character varying NOT NULL,
    llm_model character varying NOT NULL,
    system_prompt text,
    active boolean,
    restrict_to_sources boolean,
    is_system_agent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent OWNER TO runbot;

--
-- Name: TABLE ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent IS 'AI Agent';


--
-- Name: COLUMN ai_agent.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.partner_id IS 'Partner';


--
-- Name: COLUMN ai_agent.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent.subtitle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.subtitle IS 'Description';


--
-- Name: COLUMN ai_agent.response_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.response_style IS 'Response Style';


--
-- Name: COLUMN ai_agent.llm_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.llm_model IS 'LLM Model';


--
-- Name: COLUMN ai_agent.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.system_prompt IS 'System Prompt';


--
-- Name: COLUMN ai_agent.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.active IS 'Active';


--
-- Name: COLUMN ai_agent.restrict_to_sources; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.restrict_to_sources IS 'Restrict to Sources';


--
-- Name: COLUMN ai_agent.is_system_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.is_system_agent IS 'System Agent';


--
-- Name: COLUMN ai_agent.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_date IS 'Last Updated on';


--
-- Name: ai_agent_ai_topic_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_ai_topic_rel (
    ai_agent_id integer NOT NULL,
    ai_topic_id integer NOT NULL
);


ALTER TABLE public.ai_agent_ai_topic_rel OWNER TO runbot;

--
-- Name: TABLE ai_agent_ai_topic_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_ai_topic_rel IS 'RELATION BETWEEN ai_agent AND ai_topic';


--
-- Name: ai_agent_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_id_seq OWNER TO runbot;

--
-- Name: ai_agent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_id_seq OWNED BY public.ai_agent.id;


--
-- Name: ai_agent_source; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_source (
    id integer NOT NULL,
    agent_id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    type character varying NOT NULL,
    status character varying,
    url character varying,
    error_details text,
    is_active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent_source OWNER TO runbot;

--
-- Name: TABLE ai_agent_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_source IS 'AI Agent Source';


--
-- Name: COLUMN ai_agent_source.agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.agent_id IS 'Agent';


--
-- Name: COLUMN ai_agent_source.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_agent_source.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent_source.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent_source.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.name IS 'Name';


--
-- Name: COLUMN ai_agent_source.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.type IS 'Type';


--
-- Name: COLUMN ai_agent_source.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.status IS 'Status';


--
-- Name: COLUMN ai_agent_source.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.url IS 'URL';


--
-- Name: COLUMN ai_agent_source.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.error_details IS 'Error Details';


--
-- Name: COLUMN ai_agent_source.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.is_active IS 'Active';


--
-- Name: COLUMN ai_agent_source.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent_source.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_date IS 'Last Updated on';


--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_source_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_source_id_seq OWNER TO runbot;

--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_source_id_seq OWNED BY public.ai_agent_source.id;


--
-- Name: ai_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer (
    id integer NOT NULL,
    ai_agent integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    interface_key character varying NOT NULL,
    default_prompt text,
    is_system_default boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_composer OWNER TO runbot;

--
-- Name: TABLE ai_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer IS 'AI model configurations (system prompts) for text drafting.';


--
-- Name: COLUMN ai_composer.ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.ai_agent IS 'Agent';


--
-- Name: COLUMN ai_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_uid IS 'Created by';


--
-- Name: COLUMN ai_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_composer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.name IS 'Rule Name';


--
-- Name: COLUMN ai_composer.interface_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.interface_key IS 'Action';


--
-- Name: COLUMN ai_composer.default_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.default_prompt IS 'Instructions';


--
-- Name: COLUMN ai_composer.is_system_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.is_system_default IS 'Is the rule a system default or user created';


--
-- Name: COLUMN ai_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_date IS 'Created on';


--
-- Name: COLUMN ai_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_date IS 'Last Updated on';


--
-- Name: ai_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_composer_id_seq OWNER TO runbot;

--
-- Name: ai_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_composer_id_seq OWNED BY public.ai_composer.id;


--
-- Name: ai_composer_ir_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer_ir_model_rel (
    ai_composer_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ai_composer_ir_model_rel OWNER TO runbot;

--
-- Name: TABLE ai_composer_ir_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer_ir_model_rel IS 'RELATION BETWEEN ai_composer AND ir_model';


--
-- Name: ai_embedding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_embedding (
    id integer NOT NULL,
    attachment_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    embedding_model character varying NOT NULL,
    content text NOT NULL,
    has_embedding_generation_failed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    embedding_vector public.vector(1536)
);


ALTER TABLE public.ai_embedding OWNER TO runbot;

--
-- Name: TABLE ai_embedding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_embedding IS 'Attachment Chunks Embedding';


--
-- Name: COLUMN ai_embedding.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_embedding.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.sequence IS 'Sequence';


--
-- Name: COLUMN ai_embedding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_uid IS 'Created by';


--
-- Name: COLUMN ai_embedding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_embedding.embedding_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_model IS 'Embedding Model';


--
-- Name: COLUMN ai_embedding.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.content IS 'Chunk Content';


--
-- Name: COLUMN ai_embedding.has_embedding_generation_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.has_embedding_generation_failed IS 'Has Embedding Generation Failed';


--
-- Name: COLUMN ai_embedding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_date IS 'Created on';


--
-- Name: COLUMN ai_embedding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_date IS 'Last Updated on';


--
-- Name: COLUMN ai_embedding.embedding_vector; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_vector IS 'Embedding Vector';


--
-- Name: ai_embedding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_embedding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_embedding_id_seq OWNER TO runbot;

--
-- Name: ai_embedding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_embedding_id_seq OWNED BY public.ai_embedding.id;


--
-- Name: ai_prompt_button; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_prompt_button (
    id integer NOT NULL,
    sequence integer,
    composer_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_prompt_button OWNER TO runbot;

--
-- Name: TABLE ai_prompt_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_prompt_button IS 'Prompt that can be attached to AI UI rules for quick access by the user.';


--
-- Name: COLUMN ai_prompt_button.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.sequence IS 'Sequence';


--
-- Name: COLUMN ai_prompt_button.composer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.composer_id IS 'Composer';


--
-- Name: COLUMN ai_prompt_button.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_uid IS 'Created by';


--
-- Name: COLUMN ai_prompt_button.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_prompt_button.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.name IS 'AI Prompt';


--
-- Name: COLUMN ai_prompt_button.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_date IS 'Created on';


--
-- Name: COLUMN ai_prompt_button.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_date IS 'Last Updated on';


--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_prompt_button_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_prompt_button_id_seq OWNER TO runbot;

--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_prompt_button_id_seq OWNED BY public.ai_prompt_button.id;


--
-- Name: ai_tool_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_tool_ids_rel (
    parent_id integer NOT NULL,
    tool_id integer NOT NULL
);


ALTER TABLE public.ai_tool_ids_rel OWNER TO runbot;

--
-- Name: TABLE ai_tool_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_tool_ids_rel IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: ai_topic; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description text,
    instructions text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_topic OWNER TO runbot;

--
-- Name: TABLE ai_topic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic IS 'Create a topic that leverages instructions and tools to direct Odoo AI in assisting the user with their tasks.';


--
-- Name: COLUMN ai_topic.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_uid IS 'Created by';


--
-- Name: COLUMN ai_topic.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_topic.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.name IS 'Title';


--
-- Name: COLUMN ai_topic.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.description IS 'Description';


--
-- Name: COLUMN ai_topic.instructions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.instructions IS 'Instructions';


--
-- Name: COLUMN ai_topic.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_date IS 'Created on';


--
-- Name: COLUMN ai_topic.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_date IS 'Last Updated on';


--
-- Name: ai_topic_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_topic_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_topic_id_seq OWNER TO runbot;

--
-- Name: ai_topic_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_topic_id_seq OWNED BY public.ai_topic.id;


--
-- Name: ai_topic_ir_act_server_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic_ir_act_server_rel (
    ai_topic_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.ai_topic_ir_act_server_rel OWNER TO runbot;

--
-- Name: TABLE ai_topic_ir_act_server_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic_ir_act_server_rel IS 'RELATION BETWEEN ai_topic AND ir_act_server';


--
-- Name: auth_passkey_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key (
    id integer NOT NULL,
    sign_count integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    credential_identifier character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    public_key character varying
);


ALTER TABLE public.auth_passkey_key OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key IS 'Passkey';


--
-- Name: COLUMN auth_passkey_key.sign_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.sign_count IS 'Sign Count';


--
-- Name: COLUMN auth_passkey_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_uid IS 'Create Uid';


--
-- Name: COLUMN auth_passkey_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key.credential_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.credential_identifier IS 'Credential Identifier';


--
-- Name: COLUMN auth_passkey_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key_create (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_passkey_key_create OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key_create IS 'Create a Passkey';


--
-- Name: COLUMN auth_passkey_key_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_uid IS 'Created by';


--
-- Name: COLUMN auth_passkey_key_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNED BY public.auth_passkey_key_create.id;


--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_id_seq OWNED BY public.auth_passkey_key.id;


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_rate_limit_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_rate_limit_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    ip character varying,
    limit_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_totp_rate_limit_log OWNER TO runbot;

--
-- Name: TABLE auth_totp_rate_limit_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_rate_limit_log IS 'TOTP rate limit logs';


--
-- Name: COLUMN auth_totp_rate_limit_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.user_id IS 'User';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_rate_limit_log.ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.ip IS 'Ip';


--
-- Name: COLUMN auth_totp_rate_limit_log.limit_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.limit_type IS 'Limit Type';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_date IS 'Last Updated on';


--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_rate_limit_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNER TO runbot;

--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNED BY public.auth_totp_rate_limit_log.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_uninstall_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall_ir_module_module_rel (
    base_module_uninstall_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_uninstall_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall_ir_module_module_rel IS 'RELATION BETWEEN base_module_uninstall AND ir_module_module';


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm (
    id integer NOT NULL,
    duration integer NOT NULL,
    duration_minutes integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    alarm_type character varying NOT NULL,
    "interval" character varying NOT NULL,
    name jsonb NOT NULL,
    body text,
    notify_responsible boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer
);


ALTER TABLE public.calendar_alarm OWNER TO runbot;

--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm IS 'Event Alarm';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration IS 'Remind Before';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.mail_template_id IS 'Email Template';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.alarm_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.alarm_type IS 'Type';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.body IS 'Additional Message';


--
-- Name: COLUMN calendar_alarm.notify_responsible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.notify_responsible IS 'Notify Responsible';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_alarm.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.sms_template_id IS 'SMS Template';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.calendar_alarm_calendar_event_rel OWNER TO runbot;

--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_alarm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_alarm_id_seq OWNER TO runbot;

--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_alarm_id_seq OWNED BY public.calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_attendee (
    id integer NOT NULL,
    event_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    common_name character varying,
    access_token character varying,
    state character varying,
    availability character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_attendee OWNER TO runbot;

--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_attendee IS 'Calendar Attendee Information';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.partner_id IS 'Attendee';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.common_name IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.availability IS 'Available/Busy';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_attendee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_attendee_id_seq OWNER TO runbot;

--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_attendee_id_seq OWNED BY public.calendar_attendee.id;


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event (
    id integer NOT NULL,
    user_id integer,
    videocall_channel_id integer,
    res_id integer,
    res_model_id integer,
    recurrence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location character varying,
    videocall_location character varying,
    access_token character varying,
    privacy character varying,
    show_as character varying NOT NULL,
    res_model character varying,
    start_date date,
    stop_date date,
    description text,
    notes text,
    active boolean,
    allday boolean,
    recurrency boolean,
    follow_recurrence boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.calendar_event OWNER TO runbot;

--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event IS 'Calendar Event';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.user_id IS 'Organizer';


--
-- Name: COLUMN calendar_event.videocall_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_channel_id IS 'Discuss Channel';


--
-- Name: COLUMN calendar_event.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_id IS 'Document ID';


--
-- Name: COLUMN calendar_event.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model_id IS 'Document Model';


--
-- Name: COLUMN calendar_event.recurrence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrence_id IS 'Recurrence Rule';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.videocall_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_location IS 'Meeting URL';


--
-- Name: COLUMN calendar_event.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_event.privacy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.privacy IS 'Privacy';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.show_as IS 'Show as';


--
-- Name: COLUMN calendar_event.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model IS 'Document Model Name';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.notes IS 'Notes';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.follow_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.follow_recurrence IS 'Follow Recurrence';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start IS 'Start';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop IS 'Stop';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.duration IS 'Duration';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_id_seq OWNER TO runbot;

--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_id_seq OWNED BY public.calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_res_partner_rel (
    res_partner_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


ALTER TABLE public.calendar_event_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_res_partner_rel IS 'RELATION BETWEEN res_partner AND calendar_event';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_event_type OWNER TO runbot;

--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_type IS 'Event Meeting Type';


--
-- Name: COLUMN calendar_event_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.color IS 'Color';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_type_id_seq OWNER TO runbot;

--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_type_id_seq OWNED BY public.calendar_event_type.id;


--
-- Name: calendar_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_filters (
    id integer NOT NULL,
    user_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    partner_checked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_filters OWNER TO runbot;

--
-- Name: TABLE calendar_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_filters IS 'Calendar Filters';


--
-- Name: COLUMN calendar_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.user_id IS 'Me';


--
-- Name: COLUMN calendar_filters.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_id IS 'Employee';


--
-- Name: COLUMN calendar_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.active IS 'Active';


--
-- Name: COLUMN calendar_filters.partner_checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_checked IS 'Checked';


--
-- Name: COLUMN calendar_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_date IS 'Created on';


--
-- Name: COLUMN calendar_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_date IS 'Last Updated on';


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_filters_id_seq OWNER TO runbot;

--
-- Name: calendar_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_filters_id_seq OWNED BY public.calendar_filters.id;


--
-- Name: calendar_popover_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_popover_delete_wizard (
    id integer NOT NULL,
    template_id integer,
    calendar_event_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    delete character varying,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_popover_delete_wizard OWNER TO runbot;

--
-- Name: TABLE calendar_popover_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_popover_delete_wizard IS 'Calendar Popover Delete Wizard';


--
-- Name: COLUMN calendar_popover_delete_wizard.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.template_id IS 'Mail Template';


--
-- Name: COLUMN calendar_popover_delete_wizard.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.calendar_event_id IS 'Calendar Event';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_popover_delete_wizard.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.lang IS 'Language';


--
-- Name: COLUMN calendar_popover_delete_wizard.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.subject IS 'Subject';


--
-- Name: COLUMN calendar_popover_delete_wizard.delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.delete IS 'Delete';


--
-- Name: COLUMN calendar_popover_delete_wizard.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.body IS 'Contents';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_popover_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNED BY public.calendar_popover_delete_wizard.id;


--
-- Name: calendar_provider_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_provider_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    external_calendar_provider character varying,
    cal_client_id character varying,
    cal_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    cal_sync_paused boolean,
    microsoft_outlook_sync_paused boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_provider_config OWNER TO runbot;

--
-- Name: TABLE calendar_provider_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_provider_config IS 'Calendar Provider Configuration Wizard';


--
-- Name: COLUMN calendar_provider_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_provider_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_provider_config.external_calendar_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.external_calendar_provider IS 'Choose an external calendar to configure';


--
-- Name: COLUMN calendar_provider_config.cal_client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_id IS 'Google Client_id';


--
-- Name: COLUMN calendar_provider_config.cal_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_secret IS 'Google Client_key';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN calendar_provider_config.cal_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_sync_paused IS 'Google Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_sync_paused IS 'Outlook Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_date IS 'Created on';


--
-- Name: COLUMN calendar_provider_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_date IS 'Last Updated on';


--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_provider_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_provider_config_id_seq OWNER TO runbot;

--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_provider_config_id_seq OWNED BY public.calendar_provider_config.id;


--
-- Name: calendar_recurrence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_recurrence (
    id integer NOT NULL,
    base_event_id integer,
    "interval" integer,
    count integer,
    day integer,
    trigger_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    event_tz character varying,
    rrule character varying,
    rrule_type character varying,
    end_type character varying,
    month_by character varying,
    weekday character varying,
    byday character varying,
    until date,
    mon boolean,
    tue boolean,
    wed boolean,
    thu boolean,
    fri boolean,
    sat boolean,
    sun boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT calendar_recurrence_month_day CHECK ((((rrule_type)::text <> 'monthly'::text) OR ((month_by)::text <> 'day'::text) OR ((day >= 1) AND (day <= 31)) OR (((weekday)::text = ANY ((ARRAY['MON'::character varying, 'TUE'::character varying, 'WED'::character varying, 'THU'::character varying, 'FRI'::character varying, 'SAT'::character varying, 'SUN'::character varying])::text[])) AND ((byday)::text = ANY ((ARRAY['1'::character varying, '2'::character varying, '3'::character varying, '4'::character varying, '-1'::character varying])::text[])))))
);


ALTER TABLE public.calendar_recurrence OWNER TO runbot;

--
-- Name: TABLE calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_recurrence IS 'Event Recurrence Rule';


--
-- Name: COLUMN calendar_recurrence.base_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.base_event_id IS 'Base Event';


--
-- Name: COLUMN calendar_recurrence."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence."interval" IS 'Interval';


--
-- Name: COLUMN calendar_recurrence.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.count IS 'Count';


--
-- Name: COLUMN calendar_recurrence.day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.day IS 'Day';


--
-- Name: COLUMN calendar_recurrence.trigger_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.trigger_id IS 'Trigger';


--
-- Name: COLUMN calendar_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_recurrence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.name IS 'Name';


--
-- Name: COLUMN calendar_recurrence.event_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.event_tz IS 'Timezone';


--
-- Name: COLUMN calendar_recurrence.rrule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule IS 'Rrule';


--
-- Name: COLUMN calendar_recurrence.rrule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule_type IS 'Rrule Type';


--
-- Name: COLUMN calendar_recurrence.end_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.end_type IS 'End Type';


--
-- Name: COLUMN calendar_recurrence.month_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.month_by IS 'Month By';


--
-- Name: COLUMN calendar_recurrence.weekday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.weekday IS 'Weekday';


--
-- Name: COLUMN calendar_recurrence.byday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.byday IS 'By day';


--
-- Name: COLUMN calendar_recurrence.until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.until IS 'Repeat Until';


--
-- Name: COLUMN calendar_recurrence.mon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.mon IS 'Mon';


--
-- Name: COLUMN calendar_recurrence.tue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.tue IS 'Tue';


--
-- Name: COLUMN calendar_recurrence.wed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.wed IS 'Wed';


--
-- Name: COLUMN calendar_recurrence.thu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.thu IS 'Thu';


--
-- Name: COLUMN calendar_recurrence.fri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.fri IS 'Fri';


--
-- Name: COLUMN calendar_recurrence.sat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sat IS 'Sat';


--
-- Name: COLUMN calendar_recurrence.sun; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sun IS 'Sun';


--
-- Name: COLUMN calendar_recurrence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN calendar_recurrence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT calendar_recurrence_month_day ON calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT calendar_recurrence_month_day ON public.calendar_recurrence IS 'CHECK (
        rrule_type != ''monthly''
        OR month_by != ''day''
        OR day >= 1 AND day <= 31
        OR weekday IN (''MON'', ''TUE'', ''WED'', ''THU'', ''FRI'', ''SAT'', ''SUN'') AND byday IN (''1'', ''2'', ''3'', ''4'', ''-1''))';


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_recurrence_id_seq OWNER TO runbot;

--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_recurrence_id_seq OWNED BY public.calendar_recurrence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: discuss_call_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_call_history (
    id integer NOT NULL,
    channel_id integer NOT NULL,
    start_call_message_id integer,
    create_uid integer,
    write_uid integer,
    start_dt timestamp without time zone NOT NULL,
    end_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_call_history_channel_id_not_null_constraint CHECK ((channel_id IS NOT NULL)),
    CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint CHECK ((start_dt IS NOT NULL))
);


ALTER TABLE public.discuss_call_history OWNER TO runbot;

--
-- Name: TABLE discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_call_history IS 'Keep the call history';


--
-- Name: COLUMN discuss_call_history.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_call_history.start_call_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_call_message_id IS 'Start Call Message';


--
-- Name: COLUMN discuss_call_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_call_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_call_history.start_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_dt IS 'Start Dt';


--
-- Name: COLUMN discuss_call_history.end_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.end_dt IS 'End Dt';


--
-- Name: COLUMN discuss_call_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_date IS 'Created on';


--
-- Name: COLUMN discuss_call_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON public.discuss_call_history IS 'CHECK (channel_id IS NOT NULL)';


--
-- Name: CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON public.discuss_call_history IS 'CHECK (start_dt IS NOT NULL)';


--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_call_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_call_history_id_seq OWNER TO runbot;

--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_call_history_id_seq OWNED BY public.discuss_call_history.id;


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ai_agent_id integer,
    ai_env_context jsonb,
    CONSTRAINT discuss_channel_ai_channel_type_check CHECK (((ai_agent_id IS NULL) OR ((channel_type)::text = 'ai_chat'::text) OR ((channel_type)::text = 'livechat'::text))),
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: COLUMN discuss_channel.ai_agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_agent_id IS 'Ai Agent';


--
-- Name: COLUMN discuss_channel.ai_env_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_env_context IS 'Context for AI agent';


--
-- Name: CONSTRAINT discuss_channel_ai_channel_type_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_ai_channel_type_check ON public.discuss_channel IS 'CHECK(ai_agent_id IS NULL or channel_type = ''ai_chat'' or channel_type = ''livechat'')';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: discuss_channel_hr_department_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_hr_department_rel (
    discuss_channel_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_hr_department_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_hr_department_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_hr_department_rel IS 'RELATION BETWEEN discuss_channel AND hr_department';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: employee_bank_account_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.employee_bank_account_rel (
    employee_id integer NOT NULL,
    bank_account_id integer NOT NULL
);


ALTER TABLE public.employee_bank_account_rel OWNER TO runbot;

--
-- Name: TABLE employee_bank_account_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.employee_bank_account_rel IS 'RELATION BETWEEN hr_employee AND res_partner_bank';


--
-- Name: employee_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.employee_category_rel (
    employee_id integer NOT NULL,
    category_id integer NOT NULL
);


ALTER TABLE public.employee_category_rel OWNER TO runbot;

--
-- Name: TABLE employee_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.employee_category_rel IS 'RELATION BETWEEN hr_employee AND hr_employee_category';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    error_message text,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    error_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    microsoft_outlook_access_token_expiration integer,
    microsoft_outlook_refresh_token character varying,
    microsoft_outlook_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_message IS 'Last Error Message';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.error_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_date IS 'Last Error Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token_expiration IS 'Outlook Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_refresh_token IS 'Outlook Refresh Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token IS 'Outlook Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: homework_location_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.homework_location_wizard (
    id integer NOT NULL,
    work_location_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date,
    weekly boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.homework_location_wizard OWNER TO runbot;

--
-- Name: TABLE homework_location_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.homework_location_wizard IS 'Set Homework Location Wizard';


--
-- Name: COLUMN homework_location_wizard.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.work_location_id IS 'Location';


--
-- Name: COLUMN homework_location_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.employee_id IS 'Employee';


--
-- Name: COLUMN homework_location_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN homework_location_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN homework_location_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.date IS 'Date';


--
-- Name: COLUMN homework_location_wizard.weekly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.weekly IS 'Weekly';


--
-- Name: COLUMN homework_location_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.create_date IS 'Created on';


--
-- Name: COLUMN homework_location_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.write_date IS 'Last Updated on';


--
-- Name: homework_location_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.homework_location_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.homework_location_wizard_id_seq OWNER TO runbot;

--
-- Name: homework_location_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.homework_location_wizard_id_seq OWNED BY public.homework_location_wizard.id;


--
-- Name: hr_bank_account_allocation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_bank_account_allocation_wizard (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_bank_account_allocation_wizard OWNER TO runbot;

--
-- Name: TABLE hr_bank_account_allocation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_bank_account_allocation_wizard IS 'Bank Account Allocation Wizard';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.employee_id IS 'Employee';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_bank_account_allocation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_bank_account_allocation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_bank_account_allocation_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_bank_account_allocation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_bank_account_allocation_wizard_id_seq OWNED BY public.hr_bank_account_allocation_wizard.id;


--
-- Name: hr_bank_account_allocation_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_bank_account_allocation_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    bank_account_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying,
    amount numeric,
    trusted boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_bank_account_allocation_wizard_line OWNER TO runbot;

--
-- Name: TABLE hr_bank_account_allocation_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_bank_account_allocation_wizard_line IS 'Bank Account Allocation Line (Wizard)';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.amount IS 'Amount';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.trusted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.trusted IS 'Trusted';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.write_date IS 'Last Updated on';


--
-- Name: hr_bank_account_allocation_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_bank_account_allocation_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_bank_account_allocation_wizard_line_id_seq OWNER TO runbot;

--
-- Name: hr_bank_account_allocation_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_bank_account_allocation_wizard_line_id_seq OWNED BY public.hr_bank_account_allocation_wizard_line.id;


--
-- Name: hr_contract_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_contract_type (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_contract_type OWNER TO runbot;

--
-- Name: TABLE hr_contract_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_contract_type IS 'Contract Type';


--
-- Name: COLUMN hr_contract_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_contract_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.country_id IS 'Country';


--
-- Name: COLUMN hr_contract_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_contract_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_contract_type.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.code IS 'Code';


--
-- Name: COLUMN hr_contract_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.name IS 'Name';


--
-- Name: COLUMN hr_contract_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_contract_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_date IS 'Last Updated on';


--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_contract_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_contract_type_id_seq OWNER TO runbot;

--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_contract_type_id_seq OWNED BY public.hr_contract_type.id;


--
-- Name: hr_department; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_department (
    id integer NOT NULL,
    company_id integer,
    parent_id integer,
    manager_id integer,
    color integer,
    master_department_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    note text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_department OWNER TO runbot;

--
-- Name: TABLE hr_department; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_department IS 'Department';


--
-- Name: COLUMN hr_department.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.company_id IS 'Company';


--
-- Name: COLUMN hr_department.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_id IS 'Parent Department';


--
-- Name: COLUMN hr_department.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.manager_id IS 'Manager';


--
-- Name: COLUMN hr_department.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.color IS 'Color Index';


--
-- Name: COLUMN hr_department.master_department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.master_department_id IS 'Master Department';


--
-- Name: COLUMN hr_department.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_uid IS 'Created by';


--
-- Name: COLUMN hr_department.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_department.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_path IS 'Parent Path';


--
-- Name: COLUMN hr_department.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.name IS 'Department Name';


--
-- Name: COLUMN hr_department.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.note IS 'Note';


--
-- Name: COLUMN hr_department.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.active IS 'Active';


--
-- Name: COLUMN hr_department.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_date IS 'Created on';


--
-- Name: COLUMN hr_department.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_date IS 'Last Updated on';


--
-- Name: hr_department_hr_leave_mandatory_day_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_department_hr_leave_mandatory_day_rel (
    hr_leave_mandatory_day_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


ALTER TABLE public.hr_department_hr_leave_mandatory_day_rel OWNER TO runbot;

--
-- Name: TABLE hr_department_hr_leave_mandatory_day_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_department_hr_leave_mandatory_day_rel IS 'RELATION BETWEEN hr_leave_mandatory_day AND hr_department';


--
-- Name: hr_department_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_department_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_department_id_seq OWNER TO runbot;

--
-- Name: hr_department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_department_id_seq OWNED BY public.hr_department.id;


--
-- Name: hr_departure_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_reason (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_reason OWNER TO runbot;

--
-- Name: TABLE hr_departure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_reason IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_reason.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.sequence IS 'Sequence';


--
-- Name: COLUMN hr_departure_reason.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.country_id IS 'Country';


--
-- Name: COLUMN hr_departure_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_reason.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.name IS 'Reason';


--
-- Name: COLUMN hr_departure_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_date IS 'Last Updated on';


--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_reason_id_seq OWNER TO runbot;

--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_reason_id_seq OWNED BY public.hr_departure_reason.id;


--
-- Name: hr_departure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_wizard (
    id integer NOT NULL,
    departure_reason_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    departure_date date NOT NULL,
    departure_description text,
    remove_related_user boolean,
    set_date_end boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_wizard OWNER TO runbot;

--
-- Name: TABLE hr_departure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_wizard IS 'Departure Wizard';


--
-- Name: COLUMN hr_departure_wizard.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_wizard.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_date IS 'Contract End Date';


--
-- Name: COLUMN hr_departure_wizard.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_departure_wizard.remove_related_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.remove_related_user IS 'Related User';


--
-- Name: COLUMN hr_departure_wizard.set_date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.set_date_end IS 'Set Contract End Date';


--
-- Name: COLUMN hr_departure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_departure_wizard_hr_employee_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_wizard_hr_employee_rel (
    hr_departure_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_departure_wizard_hr_employee_rel OWNER TO runbot;

--
-- Name: TABLE hr_departure_wizard_hr_employee_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_wizard_hr_employee_rel IS 'RELATION BETWEEN hr_departure_wizard AND hr_employee';


--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNED BY public.hr_departure_wizard.id;


--
-- Name: hr_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer NOT NULL,
    message_main_attachment_id integer,
    current_version_id integer,
    user_id integer,
    work_contact_id integer,
    country_of_birth integer,
    parent_id integer,
    coach_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    work_phone character varying,
    mobile_phone character varying,
    work_email character varying,
    legal_name character varying,
    private_phone character varying,
    private_email character varying,
    lang character varying,
    place_of_birth character varying,
    permit_no character varying,
    visa_no character varying,
    certificate character varying,
    study_field character varying,
    study_school character varying,
    emergency_contact character varying,
    emergency_phone character varying,
    barcode character varying,
    pin character varying,
    private_car_plate character varying,
    birthday date,
    visa_expire date,
    work_permit_expiration_date date,
    salary_distribution jsonb,
    employee_properties jsonb,
    active boolean,
    birthday_public_display boolean,
    work_permit_scheduled_activity boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    leave_manager_id integer,
    monday_location_id integer,
    tuesday_location_id integer,
    wednesday_location_id integer,
    thursday_location_id integer,
    friday_location_id integer,
    saturday_location_id integer,
    sunday_location_id integer,
    today_location_name character varying
);


ALTER TABLE public.hr_employee OWNER TO runbot;

--
-- Name: TABLE hr_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee IS 'Employee';


--
-- Name: COLUMN hr_employee.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.resource_id IS 'Resource';


--
-- Name: COLUMN hr_employee.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.company_id IS 'Company';


--
-- Name: COLUMN hr_employee.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_employee.current_version_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.current_version_id IS 'Current Version';


--
-- Name: COLUMN hr_employee.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.user_id IS 'User';


--
-- Name: COLUMN hr_employee.work_contact_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_contact_id IS 'Work Contact';


--
-- Name: COLUMN hr_employee.country_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.country_of_birth IS 'Country of Birth';


--
-- Name: COLUMN hr_employee.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.parent_id IS 'Manager';


--
-- Name: COLUMN hr_employee.coach_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.coach_id IS 'Coach';


--
-- Name: COLUMN hr_employee.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.color IS 'Color Index';


--
-- Name: COLUMN hr_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.name IS 'Employee Name';


--
-- Name: COLUMN hr_employee.work_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_phone IS 'Work Phone';


--
-- Name: COLUMN hr_employee.mobile_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.mobile_phone IS 'Work Mobile';


--
-- Name: COLUMN hr_employee.work_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_email IS 'Work Email';


--
-- Name: COLUMN hr_employee.legal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.legal_name IS 'Legal Name';


--
-- Name: COLUMN hr_employee.private_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_phone IS 'Private Phone';


--
-- Name: COLUMN hr_employee.private_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_email IS 'Private Email';


--
-- Name: COLUMN hr_employee.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.lang IS 'Lang';


--
-- Name: COLUMN hr_employee.place_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.place_of_birth IS 'Place of Birth';


--
-- Name: COLUMN hr_employee.permit_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.permit_no IS 'Work Permit No';


--
-- Name: COLUMN hr_employee.visa_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_no IS 'Visa No';


--
-- Name: COLUMN hr_employee.certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate IS 'Certificate Level';


--
-- Name: COLUMN hr_employee.study_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_field IS 'Field of Study';


--
-- Name: COLUMN hr_employee.study_school; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_school IS 'School';


--
-- Name: COLUMN hr_employee.emergency_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_contact IS 'Emergency Contact';


--
-- Name: COLUMN hr_employee.emergency_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_phone IS 'Emergency Phone';


--
-- Name: COLUMN hr_employee.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.barcode IS 'Badge ID';


--
-- Name: COLUMN hr_employee.pin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.pin IS 'PIN';


--
-- Name: COLUMN hr_employee.private_car_plate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_car_plate IS 'Private Car Plate';


--
-- Name: COLUMN hr_employee.birthday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.birthday IS 'Birthday';


--
-- Name: COLUMN hr_employee.visa_expire; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_expire IS 'Visa Expiration Date';


--
-- Name: COLUMN hr_employee.work_permit_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_expiration_date IS 'Work Permit Expiration Date';


--
-- Name: COLUMN hr_employee.salary_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.salary_distribution IS 'Salary Distribution';


--
-- Name: COLUMN hr_employee.employee_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.employee_properties IS 'Properties';


--
-- Name: COLUMN hr_employee.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.active IS 'Active';


--
-- Name: COLUMN hr_employee.birthday_public_display; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.birthday_public_display IS 'Show to all employees';


--
-- Name: COLUMN hr_employee.work_permit_scheduled_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_scheduled_activity IS 'Work Permit Scheduled Activity';


--
-- Name: COLUMN hr_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_employee.leave_manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.leave_manager_id IS 'Time Off Approver';


--
-- Name: COLUMN hr_employee.monday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.monday_location_id IS 'Monday';


--
-- Name: COLUMN hr_employee.tuesday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.tuesday_location_id IS 'Tuesday';


--
-- Name: COLUMN hr_employee.wednesday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.wednesday_location_id IS 'Wednesday';


--
-- Name: COLUMN hr_employee.thursday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.thursday_location_id IS 'Thursday';


--
-- Name: COLUMN hr_employee.friday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.friday_location_id IS 'Friday';


--
-- Name: COLUMN hr_employee.saturday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.saturday_location_id IS 'Saturday';


--
-- Name: COLUMN hr_employee.sunday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.sunday_location_id IS 'Sunday';


--
-- Name: COLUMN hr_employee.today_location_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.today_location_name IS 'Today Location Name';


--
-- Name: hr_employee_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_category (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_category OWNER TO runbot;

--
-- Name: TABLE hr_employee_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_category IS 'Employee Category';


--
-- Name: COLUMN hr_employee_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.color IS 'Color Index';


--
-- Name: COLUMN hr_employee_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.name IS 'Tag Name';


--
-- Name: COLUMN hr_employee_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_date IS 'Last Updated on';


--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_category_id_seq OWNER TO runbot;

--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_category_id_seq OWNED BY public.hr_employee_category.id;


--
-- Name: hr_employee_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_skill (
    id integer NOT NULL,
    skill_id integer NOT NULL,
    skill_level_id integer NOT NULL,
    skill_type_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    valid_from date,
    valid_to date,
    display_warning_message boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_skill OWNER TO runbot;

--
-- Name: TABLE hr_employee_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_skill IS 'Skill level for employee';


--
-- Name: COLUMN hr_employee_skill.skill_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_id IS 'Skill';


--
-- Name: COLUMN hr_employee_skill.skill_level_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_level_id IS 'Skill Level';


--
-- Name: COLUMN hr_employee_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_employee_skill.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_skill.valid_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.valid_from IS 'Validity Start';


--
-- Name: COLUMN hr_employee_skill.valid_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.valid_to IS 'Validity Stop';


--
-- Name: COLUMN hr_employee_skill.display_warning_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.display_warning_message IS 'Display Warning Message';


--
-- Name: COLUMN hr_employee_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_date IS 'Last Updated on';


--
-- Name: hr_skill_level; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_level (
    id integer NOT NULL,
    skill_type_id integer,
    level_progress integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    default_level boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_skill_level_check_level_progress CHECK (((level_progress >= 0) AND (level_progress <= 100)))
);


ALTER TABLE public.hr_skill_level OWNER TO runbot;

--
-- Name: TABLE hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_level IS 'Skill Level';


--
-- Name: COLUMN hr_skill_level.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_skill_level.level_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.level_progress IS 'Progress';


--
-- Name: COLUMN hr_skill_level.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_level.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_level.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.name IS 'Name';


--
-- Name: COLUMN hr_skill_level.default_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.default_level IS 'Default Level';


--
-- Name: COLUMN hr_skill_level.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_level.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_skill_level_check_level_progress ON hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_skill_level_check_level_progress ON public.hr_skill_level IS 'CHECK(level_progress BETWEEN 0 AND 100)';


--
-- Name: hr_skill_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_type (
    id integer NOT NULL,
    sequence integer,
    color integer,
    levels_count integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    is_certification boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_skill_type OWNER TO runbot;

--
-- Name: TABLE hr_skill_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_type IS 'Skill Type';


--
-- Name: COLUMN hr_skill_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_skill_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.color IS 'Color';


--
-- Name: COLUMN hr_skill_type.levels_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.levels_count IS 'Levels Count';


--
-- Name: COLUMN hr_skill_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.name IS 'Name';


--
-- Name: COLUMN hr_skill_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.active IS 'Active';


--
-- Name: COLUMN hr_skill_type.is_certification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.is_certification IS 'Certification';


--
-- Name: COLUMN hr_skill_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_date IS 'Last Updated on';


--
-- Name: hr_version; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_version (
    id integer NOT NULL,
    company_id integer,
    employee_id integer,
    last_modified_uid integer NOT NULL,
    country_id integer,
    private_state_id integer,
    private_country_id integer,
    distance_home_work integer,
    km_home_work integer,
    children integer,
    department_id integer,
    job_id integer,
    address_id integer,
    work_location_id integer,
    departure_reason_id integer,
    resource_calendar_id integer,
    contract_template_id integer,
    structure_type_id integer,
    contract_type_id integer,
    hr_responsible_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    identification_id character varying,
    ssnid character varying,
    passport_id character varying,
    sex character varying,
    private_street character varying,
    private_street2 character varying,
    private_city character varying,
    private_zip character varying,
    distance_home_work_unit character varying NOT NULL,
    marital character varying NOT NULL,
    spouse_complete_name character varying,
    employee_type character varying NOT NULL,
    job_title character varying,
    date_version date NOT NULL,
    passport_expiration_date date,
    spouse_birthdate date,
    departure_date date,
    contract_date_start date,
    contract_date_end date,
    trial_date_end date,
    departure_description text,
    additional_note text,
    wage numeric,
    active boolean,
    is_custom_job_title boolean,
    is_flexible boolean,
    is_fully_flexible boolean,
    last_modified_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_version_check_contract_start_date_defined CHECK (((contract_date_end IS NULL) OR (contract_date_start IS NOT NULL)))
);


ALTER TABLE public.hr_version OWNER TO runbot;

--
-- Name: TABLE hr_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_version IS 'Version';


--
-- Name: COLUMN hr_version.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.company_id IS 'Company';


--
-- Name: COLUMN hr_version.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.employee_id IS 'Employee';


--
-- Name: COLUMN hr_version.last_modified_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.last_modified_uid IS 'Last Modified by';


--
-- Name: COLUMN hr_version.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.country_id IS 'Nationality (Country)';


--
-- Name: COLUMN hr_version.private_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_state_id IS 'Private State';


--
-- Name: COLUMN hr_version.private_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_country_id IS 'Private Country';


--
-- Name: COLUMN hr_version.distance_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.distance_home_work IS 'Home-Work Distance';


--
-- Name: COLUMN hr_version.km_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.km_home_work IS 'Home-Work Distance in Km';


--
-- Name: COLUMN hr_version.children; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.children IS 'Dependent Children';


--
-- Name: COLUMN hr_version.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.department_id IS 'Department';


--
-- Name: COLUMN hr_version.job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.job_id IS 'Job';


--
-- Name: COLUMN hr_version.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.address_id IS 'Work Address';


--
-- Name: COLUMN hr_version.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.work_location_id IS 'Work Location';


--
-- Name: COLUMN hr_version.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_version.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_version.contract_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_template_id IS 'Contract Template';


--
-- Name: COLUMN hr_version.structure_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.structure_type_id IS 'Salary Structure Type';


--
-- Name: COLUMN hr_version.contract_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_type_id IS 'Contract Type';


--
-- Name: COLUMN hr_version.hr_responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.hr_responsible_id IS 'HR Responsible';


--
-- Name: COLUMN hr_version.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.create_uid IS 'Created by';


--
-- Name: COLUMN hr_version.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_version.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.name IS 'Name';


--
-- Name: COLUMN hr_version.identification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.identification_id IS 'Identification No';


--
-- Name: COLUMN hr_version.ssnid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.ssnid IS 'SSN No';


--
-- Name: COLUMN hr_version.passport_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.passport_id IS 'Passport No';


--
-- Name: COLUMN hr_version.sex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.sex IS 'Gender';


--
-- Name: COLUMN hr_version.private_street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_street IS 'Private Street';


--
-- Name: COLUMN hr_version.private_street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_street2 IS 'Private Street2';


--
-- Name: COLUMN hr_version.private_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_city IS 'Private City';


--
-- Name: COLUMN hr_version.private_zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_zip IS 'Private Zip';


--
-- Name: COLUMN hr_version.distance_home_work_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.distance_home_work_unit IS 'Home-Work Distance unit';


--
-- Name: COLUMN hr_version.marital; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.marital IS 'Marital Status';


--
-- Name: COLUMN hr_version.spouse_complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.spouse_complete_name IS 'Spouse Legal Name';


--
-- Name: COLUMN hr_version.employee_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.employee_type IS 'Employee Type';


--
-- Name: COLUMN hr_version.job_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.job_title IS 'Job Title';


--
-- Name: COLUMN hr_version.date_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.date_version IS 'Date Version';


--
-- Name: COLUMN hr_version.passport_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.passport_expiration_date IS 'Passport Expiration Date';


--
-- Name: COLUMN hr_version.spouse_birthdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.spouse_birthdate IS 'Spouse Birthdate';


--
-- Name: COLUMN hr_version.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.departure_date IS 'Departure Date';


--
-- Name: COLUMN hr_version.contract_date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_date_start IS 'Contract Start Date';


--
-- Name: COLUMN hr_version.contract_date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_date_end IS 'Contract End Date';


--
-- Name: COLUMN hr_version.trial_date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.trial_date_end IS 'End of Trial Period';


--
-- Name: COLUMN hr_version.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_version.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.additional_note IS 'Additional Note';


--
-- Name: COLUMN hr_version.wage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.wage IS 'Wage';


--
-- Name: COLUMN hr_version.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.active IS 'Active';


--
-- Name: COLUMN hr_version.is_custom_job_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.is_custom_job_title IS 'Is Custom Job Title';


--
-- Name: COLUMN hr_version.is_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.is_flexible IS 'Is Flexible';


--
-- Name: COLUMN hr_version.is_fully_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.is_fully_flexible IS 'Is Fully Flexible';


--
-- Name: COLUMN hr_version.last_modified_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.last_modified_date IS 'Last Modified on';


--
-- Name: COLUMN hr_version.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.create_date IS 'Created on';


--
-- Name: COLUMN hr_version.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_version_check_contract_start_date_defined ON hr_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_version_check_contract_start_date_defined ON public.hr_version IS 'CHECK(contract_date_end IS NULL OR contract_date_start IS NOT NULL)';


--
-- Name: hr_employee_certification_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_certification_report AS
 SELECT row_number() OVER () AS id,
    e.id AS employee_id,
    e.company_id,
    v.department_id,
    s.skill_id,
    s.skill_type_id,
    ((sl.level_progress)::numeric / 100.0) AS level_progress,
    sl.name AS skill_level,
    (((s.valid_to IS NULL) OR (s.valid_to >= '2026-01-08'::date)) AND (s.valid_from <= '2026-01-08'::date)) AS active
   FROM ((((public.hr_employee e
     LEFT JOIN public.hr_version v ON ((e.current_version_id = v.id)))
     LEFT JOIN public.hr_employee_skill s ON ((e.id = s.employee_id)))
     LEFT JOIN public.hr_skill_level sl ON ((sl.id = s.skill_level_id)))
     LEFT JOIN public.hr_skill_type st ON ((st.id = sl.skill_type_id)))
  WHERE (e.active AND (st.active IS TRUE) AND (st.is_certification IS TRUE));


ALTER VIEW public.hr_employee_certification_report OWNER TO runbot;

--
-- Name: hr_employee_cv_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_cv_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    color_primary character varying NOT NULL,
    color_secondary character varying NOT NULL,
    show_skills boolean,
    show_contact boolean,
    show_others boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_cv_wizard OWNER TO runbot;

--
-- Name: TABLE hr_employee_cv_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_cv_wizard IS 'Print Resume';


--
-- Name: COLUMN hr_employee_cv_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_cv_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_cv_wizard.color_primary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_primary IS 'Primary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.color_secondary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_secondary IS 'Secondary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.show_skills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_skills IS 'Skills';


--
-- Name: COLUMN hr_employee_cv_wizard.show_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_contact IS 'Contact Information';


--
-- Name: COLUMN hr_employee_cv_wizard.show_others; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_others IS 'Others';


--
-- Name: COLUMN hr_employee_cv_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_cv_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_cv_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNED BY public.hr_employee_cv_wizard.id;


--
-- Name: hr_employee_hr_employee_cv_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_employee_cv_wizard_rel (
    hr_employee_cv_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_employee_cv_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_employee_cv_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_employee_cv_wizard_rel IS 'RELATION BETWEEN hr_employee_cv_wizard AND hr_employee';


--
-- Name: hr_employee_hr_leave_allocation_generate_multi_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_leave_allocation_generate_multi_wizard_rel (
    hr_leave_allocation_generate_multi_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_leave_allocation_generate_multi_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_leave_allocation_generate_multi_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_leave_allocation_generate_multi_wizard_rel IS 'RELATION BETWEEN hr_leave_allocation_generate_multi_wizard AND hr_employee';


--
-- Name: hr_employee_hr_leave_generate_multi_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_leave_generate_multi_wizard_rel (
    hr_leave_generate_multi_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_leave_generate_multi_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_leave_generate_multi_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_leave_generate_multi_wizard_rel IS 'RELATION BETWEEN hr_leave_generate_multi_wizard AND hr_employee';


--
-- Name: hr_employee_hr_skill_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_skill_rel (
    hr_employee_id integer NOT NULL,
    hr_skill_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_skill_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_skill_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_skill_rel IS 'RELATION BETWEEN hr_employee AND hr_skill';


--
-- Name: hr_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_id_seq OWNER TO runbot;

--
-- Name: hr_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_id_seq OWNED BY public.hr_employee.id;


--
-- Name: hr_employee_location; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_location (
    id integer NOT NULL,
    work_location_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_location OWNER TO runbot;

--
-- Name: TABLE hr_employee_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_location IS 'Employee Location';


--
-- Name: COLUMN hr_employee_location.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.work_location_id IS 'Location';


--
-- Name: COLUMN hr_employee_location.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_location.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_location.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_location.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.date IS 'Date';


--
-- Name: COLUMN hr_employee_location.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_location.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.write_date IS 'Last Updated on';


--
-- Name: hr_employee_location_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_location_id_seq OWNER TO runbot;

--
-- Name: hr_employee_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_location_id_seq OWNED BY public.hr_employee_location.id;


--
-- Name: hr_employee_public; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_public AS
 SELECT e.id,
    e.id AS employee_id,
    e.name,
    e.active,
    v.create_date,
    v.department_id,
    v.job_id,
    v.company_id,
    v.address_id,
    e.mobile_phone,
    e.work_phone,
    e.work_email,
    e.work_contact_id,
    v.work_location_id,
    e.user_id,
    e.resource_id,
    e.color,
    v.resource_calendar_id,
    e.parent_id,
    e.coach_id,
    v.create_uid,
    v.write_uid,
    v.write_date,
    e.leave_manager_id,
    e.monday_location_id,
    e.tuesday_location_id,
    e.wednesday_location_id,
    e.thursday_location_id,
    e.friday_location_id,
    e.saturday_location_id,
    e.sunday_location_id,
    e.today_location_name
   FROM (public.hr_employee e
     JOIN public.hr_version v ON ((v.id = e.current_version_id)));


ALTER VIEW public.hr_employee_public OWNER TO runbot;

--
-- Name: hr_employee_skill_history_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_skill_history_report AS
 WITH individual_skill AS (
         SELECT hr_employee_skill.valid_from,
            hr_employee_skill.valid_to,
            hr_employee_skill.employee_id,
            hr_employee_skill.skill_id
           FROM public.hr_employee_skill
          ORDER BY hr_employee_skill.employee_id, hr_employee_skill.skill_id, hr_employee_skill.valid_from
        ), date_table AS (
         SELECT date_table_1.date,
            date_table_1.employee_id
           FROM ( SELECT start.valid_from AS date,
                    start.employee_id
                   FROM individual_skill start
                UNION
                 SELECT stop.valid_to AS date,
                    stop.employee_id
                   FROM individual_skill stop
                  WHERE (stop.valid_to IS NOT NULL)) date_table_1
          ORDER BY date_table_1.date
        )
 SELECT DISTINCT ON (date_table.date, emp_skill_level.employee_id, emp_skill_level.skill_id) date_table.date,
    emp_skill_level.employee_id,
    emp_skill_level.skill_id,
    emp_skill_level.skill_type_id,
    emp_skill_level.level_progress
   FROM (date_table
     CROSS JOIN ( SELECT emp_skill.id,
            emp_skill.skill_id,
            emp_skill.skill_level_id,
            emp_skill.skill_type_id,
            emp_skill.employee_id,
            emp_skill.create_uid,
            emp_skill.write_uid,
            emp_skill.valid_from,
            emp_skill.valid_to,
            emp_skill.display_warning_message,
            emp_skill.create_date,
            emp_skill.write_date,
            level.level_progress
           FROM (public.hr_employee_skill emp_skill
             JOIN public.hr_skill_level level ON ((emp_skill.skill_level_id = level.id)))) emp_skill_level)
  WHERE ((date_table.date >= emp_skill_level.valid_from) AND (date_table.employee_id = emp_skill_level.employee_id) AND ((emp_skill_level.valid_to IS NULL) OR (date_table.date <= emp_skill_level.valid_to)))
  ORDER BY date_table.date, emp_skill_level.employee_id, emp_skill_level.skill_id, emp_skill_level.valid_from DESC;


ALTER VIEW public.hr_employee_skill_history_report OWNER TO runbot;

--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_skill_id_seq OWNER TO runbot;

--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_skill_id_seq OWNED BY public.hr_employee_skill.id;


--
-- Name: hr_employee_skill_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_skill_report AS
 SELECT row_number() OVER () AS id,
    e.id AS employee_id,
    e.company_id,
    v.department_id,
    v.job_id,
    s.skill_id,
    s.skill_type_id,
    ((sl.level_progress)::numeric / 100.0) AS level_progress,
    sl.name AS skill_level
   FROM ((((public.hr_employee e
     LEFT JOIN public.hr_version v ON ((e.current_version_id = v.id)))
     LEFT JOIN public.hr_employee_skill s ON ((e.id = s.employee_id)))
     LEFT JOIN public.hr_skill_level sl ON ((sl.id = s.skill_level_id)))
     LEFT JOIN public.hr_skill_type st ON ((st.id = sl.skill_type_id)))
  WHERE ((st.active IS TRUE) AND (st.is_certification IS NOT TRUE) AND (s.valid_to IS NULL));


ALTER VIEW public.hr_employee_skill_report OWNER TO runbot;

--
-- Name: hr_holidays_cancel_leave; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_holidays_cancel_leave (
    id integer NOT NULL,
    leave_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_holidays_cancel_leave OWNER TO runbot;

--
-- Name: TABLE hr_holidays_cancel_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_holidays_cancel_leave IS 'Cancel Time Off Wizard';


--
-- Name: COLUMN hr_holidays_cancel_leave.leave_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.leave_id IS 'Time Off Request';


--
-- Name: COLUMN hr_holidays_cancel_leave.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.create_uid IS 'Created by';


--
-- Name: COLUMN hr_holidays_cancel_leave.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_holidays_cancel_leave.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.reason IS 'Reason';


--
-- Name: COLUMN hr_holidays_cancel_leave.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.create_date IS 'Created on';


--
-- Name: COLUMN hr_holidays_cancel_leave.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.write_date IS 'Last Updated on';


--
-- Name: hr_holidays_cancel_leave_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_holidays_cancel_leave_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_holidays_cancel_leave_id_seq OWNER TO runbot;

--
-- Name: hr_holidays_cancel_leave_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_holidays_cancel_leave_id_seq OWNED BY public.hr_holidays_cancel_leave.id;


--
-- Name: hr_holidays_summary_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_holidays_summary_employee (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    holiday_type character varying NOT NULL,
    date_from date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_holidays_summary_employee OWNER TO runbot;

--
-- Name: TABLE hr_holidays_summary_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_holidays_summary_employee IS 'HR Time Off Summary Report By Employee';


--
-- Name: COLUMN hr_holidays_summary_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_holidays_summary_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_holidays_summary_employee.holiday_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.holiday_type IS 'Select Time Off Type';


--
-- Name: COLUMN hr_holidays_summary_employee.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.date_from IS 'From';


--
-- Name: COLUMN hr_holidays_summary_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_holidays_summary_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.write_date IS 'Last Updated on';


--
-- Name: hr_holidays_summary_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_holidays_summary_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_holidays_summary_employee_id_seq OWNER TO runbot;

--
-- Name: hr_holidays_summary_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_holidays_summary_employee_id_seq OWNED BY public.hr_holidays_summary_employee.id;


--
-- Name: hr_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job (
    id integer NOT NULL,
    sequence integer,
    no_of_recruitment integer,
    user_id integer,
    department_id integer,
    company_id integer,
    contract_type_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description text,
    requirements text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_job_no_of_recruitment_positive CHECK ((no_of_recruitment >= 0))
);


ALTER TABLE public.hr_job OWNER TO runbot;

--
-- Name: TABLE hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job IS 'Job Position';


--
-- Name: COLUMN hr_job.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.sequence IS 'Sequence';


--
-- Name: COLUMN hr_job.no_of_recruitment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.no_of_recruitment IS 'Target';


--
-- Name: COLUMN hr_job.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.user_id IS 'Recruiter';


--
-- Name: COLUMN hr_job.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.department_id IS 'Department';


--
-- Name: COLUMN hr_job.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.company_id IS 'Company';


--
-- Name: COLUMN hr_job.contract_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.contract_type_id IS 'Employment Type';


--
-- Name: COLUMN hr_job.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_uid IS 'Created by';


--
-- Name: COLUMN hr_job.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_job.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.name IS 'Job Position';


--
-- Name: COLUMN hr_job.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.description IS 'Job Description';


--
-- Name: COLUMN hr_job.requirements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.requirements IS 'Requirements';


--
-- Name: COLUMN hr_job.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.active IS 'Active';


--
-- Name: COLUMN hr_job.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_date IS 'Created on';


--
-- Name: COLUMN hr_job.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_job_no_of_recruitment_positive ON hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_job_no_of_recruitment_positive ON public.hr_job IS 'CHECK(no_of_recruitment >= 0)';


--
-- Name: hr_job_hr_leave_mandatory_day_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job_hr_leave_mandatory_day_rel (
    hr_leave_mandatory_day_id integer NOT NULL,
    hr_job_id integer NOT NULL
);


ALTER TABLE public.hr_job_hr_leave_mandatory_day_rel OWNER TO runbot;

--
-- Name: TABLE hr_job_hr_leave_mandatory_day_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job_hr_leave_mandatory_day_rel IS 'RELATION BETWEEN hr_leave_mandatory_day AND hr_job';


--
-- Name: hr_job_hr_skill_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job_hr_skill_rel (
    hr_job_id integer NOT NULL,
    hr_skill_id integer NOT NULL
);


ALTER TABLE public.hr_job_hr_skill_rel OWNER TO runbot;

--
-- Name: TABLE hr_job_hr_skill_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job_hr_skill_rel IS 'RELATION BETWEEN hr_job AND hr_skill';


--
-- Name: hr_job_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_job_id_seq OWNER TO runbot;

--
-- Name: hr_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_job_id_seq OWNED BY public.hr_job.id;


--
-- Name: hr_job_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job_skill (
    id integer NOT NULL,
    skill_id integer NOT NULL,
    skill_level_id integer NOT NULL,
    skill_type_id integer NOT NULL,
    job_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    valid_from date,
    valid_to date,
    display_warning_message boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_job_skill OWNER TO runbot;

--
-- Name: TABLE hr_job_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job_skill IS 'Skills for job positions';


--
-- Name: COLUMN hr_job_skill.skill_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.skill_id IS 'Skill';


--
-- Name: COLUMN hr_job_skill.skill_level_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.skill_level_id IS 'Skill Level';


--
-- Name: COLUMN hr_job_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_job_skill.job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.job_id IS 'Job';


--
-- Name: COLUMN hr_job_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_job_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_job_skill.valid_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.valid_from IS 'Validity Start';


--
-- Name: COLUMN hr_job_skill.valid_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.valid_to IS 'Validity Stop';


--
-- Name: COLUMN hr_job_skill.display_warning_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.display_warning_message IS 'Display Warning Message';


--
-- Name: COLUMN hr_job_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_job_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job_skill.write_date IS 'Last Updated on';


--
-- Name: hr_job_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_job_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_job_skill_id_seq OWNER TO runbot;

--
-- Name: hr_job_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_job_skill_id_seq OWNED BY public.hr_job_skill.id;


--
-- Name: hr_leave; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave (
    id integer NOT NULL,
    message_main_attachment_id integer,
    user_id integer,
    holiday_status_id integer NOT NULL,
    employee_id integer NOT NULL,
    employee_company_id integer,
    company_id integer,
    department_id integer,
    resource_calendar_id integer,
    meeting_id integer,
    first_approver_id integer,
    second_approver_id integer,
    create_uid integer,
    write_uid integer,
    private_name character varying,
    state character varying,
    duration_display character varying,
    request_date_from_period character varying,
    request_date_to_period character varying,
    request_date_from date,
    request_date_to date,
    notes text,
    request_unit_half boolean,
    request_unit_hours boolean,
    date_from timestamp without time zone,
    date_to timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    number_of_days double precision,
    number_of_hours double precision,
    request_hour_from double precision,
    request_hour_to double precision,
    CONSTRAINT hr_leave_date_check2 CHECK ((date_from <= date_to)),
    CONSTRAINT hr_leave_date_check3 CHECK ((request_date_from <= request_date_to)),
    CONSTRAINT hr_leave_duration_check CHECK ((number_of_days >= (0)::double precision))
);


ALTER TABLE public.hr_leave OWNER TO runbot;

--
-- Name: TABLE hr_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave IS 'Time Off';


--
-- Name: COLUMN hr_leave.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_leave.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.user_id IS 'User';


--
-- Name: COLUMN hr_leave.holiday_status_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.holiday_status_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.employee_id IS 'Employee';


--
-- Name: COLUMN hr_leave.employee_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.employee_company_id IS 'Employee Company';


--
-- Name: COLUMN hr_leave.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.company_id IS 'Company';


--
-- Name: COLUMN hr_leave.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.department_id IS 'Department';


--
-- Name: COLUMN hr_leave.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.resource_calendar_id IS 'Resource Calendar';


--
-- Name: COLUMN hr_leave.meeting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.meeting_id IS 'Meeting';


--
-- Name: COLUMN hr_leave.first_approver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.first_approver_id IS 'First Approval';


--
-- Name: COLUMN hr_leave.second_approver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.second_approver_id IS 'Second Approval';


--
-- Name: COLUMN hr_leave.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave.private_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.private_name IS 'Time Off Description';


--
-- Name: COLUMN hr_leave.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.state IS 'Status';


--
-- Name: COLUMN hr_leave.duration_display; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.duration_display IS 'Requested';


--
-- Name: COLUMN hr_leave.request_date_from_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_date_from_period IS 'Date Period Start';


--
-- Name: COLUMN hr_leave.request_date_to_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_date_to_period IS 'Date Period End';


--
-- Name: COLUMN hr_leave.request_date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_date_from IS 'Request Start Date';


--
-- Name: COLUMN hr_leave.request_date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_date_to IS 'Request End Date';


--
-- Name: COLUMN hr_leave.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.notes IS 'Reasons';


--
-- Name: COLUMN hr_leave.request_unit_half; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_unit_half IS 'Half-Day';


--
-- Name: COLUMN hr_leave.request_unit_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_unit_hours IS 'Specific Time';


--
-- Name: COLUMN hr_leave.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.date_from IS 'Start Date';


--
-- Name: COLUMN hr_leave.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.date_to IS 'End Date';


--
-- Name: COLUMN hr_leave.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_leave.number_of_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.number_of_days IS 'Duration (Days)';


--
-- Name: COLUMN hr_leave.number_of_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.number_of_hours IS 'Duration (Hours)';


--
-- Name: COLUMN hr_leave.request_hour_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_hour_from IS 'Hour from';


--
-- Name: COLUMN hr_leave.request_hour_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_hour_to IS 'Hour to';


--
-- Name: CONSTRAINT hr_leave_date_check2 ON hr_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_date_check2 ON public.hr_leave IS 'CHECK ((date_from <= date_to))';


--
-- Name: CONSTRAINT hr_leave_date_check3 ON hr_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_date_check3 ON public.hr_leave IS 'CHECK ((request_date_from <= request_date_to))';


--
-- Name: CONSTRAINT hr_leave_duration_check ON hr_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_duration_check ON public.hr_leave IS 'CHECK ( number_of_days >= 0 )';


--
-- Name: hr_leave_accrual_level; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_accrual_level (
    id integer NOT NULL,
    sequence integer,
    accrual_plan_id integer NOT NULL,
    start_count integer,
    postpone_max_days integer,
    accrual_validity_count integer,
    create_uid integer,
    write_uid integer,
    start_type character varying NOT NULL,
    milestone_date character varying NOT NULL,
    added_value_type character varying NOT NULL,
    frequency character varying NOT NULL,
    week_day character varying NOT NULL,
    first_day character varying,
    second_day character varying,
    first_month_day character varying,
    first_month character varying,
    second_month_day character varying,
    second_month character varying,
    yearly_month character varying,
    yearly_day character varying,
    action_with_unused_accruals character varying NOT NULL,
    carryover_options character varying NOT NULL,
    accrual_validity_type character varying NOT NULL,
    added_value numeric NOT NULL,
    maximum_leave numeric,
    maximum_leave_yearly numeric,
    cap_accrued_time boolean,
    cap_accrued_time_yearly boolean,
    accrual_validity boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_leave_accrual_level_added_value_greater_than_zero CHECK ((added_value > (0)::numeric)),
    CONSTRAINT hr_leave_accrual_level_start_count_check CHECK ((((start_count > 0) AND ((milestone_date)::text = 'after'::text)) OR ((start_count = 0) AND ((milestone_date)::text = 'creation'::text)))),
    CONSTRAINT hr_leave_accrual_level_valid_accrual_validity_value CHECK (((accrual_validity IS NOT TRUE) OR (COALESCE(accrual_validity_count, 0) > 0))),
    CONSTRAINT hr_leave_accrual_level_valid_postpone_max_days_value CHECK ((((action_with_unused_accruals)::text <> 'all'::text) OR ((carryover_options)::text <> 'limited'::text) OR (COALESCE(postpone_max_days, 0) > 0))),
    CONSTRAINT hr_leave_accrual_level_valid_yearly_cap_value CHECK (((cap_accrued_time_yearly IS NOT TRUE) OR (COALESCE(maximum_leave_yearly, (0)::numeric) > (0)::numeric)))
);


ALTER TABLE public.hr_leave_accrual_level OWNER TO runbot;

--
-- Name: TABLE hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_accrual_level IS 'Accrual Plan Level';


--
-- Name: COLUMN hr_leave_accrual_level.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.sequence IS 'sequence';


--
-- Name: COLUMN hr_leave_accrual_level.accrual_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.accrual_plan_id IS 'Accrual Plan';


--
-- Name: COLUMN hr_leave_accrual_level.start_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.start_count IS 'Start Count';


--
-- Name: COLUMN hr_leave_accrual_level.postpone_max_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.postpone_max_days IS 'Postpone Max Days';


--
-- Name: COLUMN hr_leave_accrual_level.accrual_validity_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.accrual_validity_count IS 'Accrual Validity Count';


--
-- Name: COLUMN hr_leave_accrual_level.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_accrual_level.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_accrual_level.start_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.start_type IS 'Start Type';


--
-- Name: COLUMN hr_leave_accrual_level.milestone_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.milestone_date IS 'Milestone Date';


--
-- Name: COLUMN hr_leave_accrual_level.added_value_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.added_value_type IS 'Added Value Type';


--
-- Name: COLUMN hr_leave_accrual_level.frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.frequency IS 'Frequency';


--
-- Name: COLUMN hr_leave_accrual_level.week_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.week_day IS 'Allocation on';


--
-- Name: COLUMN hr_leave_accrual_level.first_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.first_day IS 'First Day';


--
-- Name: COLUMN hr_leave_accrual_level.second_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.second_day IS 'Second Day';


--
-- Name: COLUMN hr_leave_accrual_level.first_month_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.first_month_day IS 'First Month Day';


--
-- Name: COLUMN hr_leave_accrual_level.first_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.first_month IS 'First Month';


--
-- Name: COLUMN hr_leave_accrual_level.second_month_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.second_month_day IS 'Second Month Day';


--
-- Name: COLUMN hr_leave_accrual_level.second_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.second_month IS 'Second Month';


--
-- Name: COLUMN hr_leave_accrual_level.yearly_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.yearly_month IS 'Yearly Month';


--
-- Name: COLUMN hr_leave_accrual_level.yearly_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.yearly_day IS 'Yearly Day';


--
-- Name: COLUMN hr_leave_accrual_level.action_with_unused_accruals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.action_with_unused_accruals IS 'Action With Unused Accruals';


--
-- Name: COLUMN hr_leave_accrual_level.carryover_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.carryover_options IS 'Carryover Options';


--
-- Name: COLUMN hr_leave_accrual_level.accrual_validity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.accrual_validity_type IS 'Accrual Validity Type';


--
-- Name: COLUMN hr_leave_accrual_level.added_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.added_value IS 'Added Value';


--
-- Name: COLUMN hr_leave_accrual_level.maximum_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.maximum_leave IS 'Maximum Leave';


--
-- Name: COLUMN hr_leave_accrual_level.maximum_leave_yearly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.maximum_leave_yearly IS 'Maximum Leave Yearly';


--
-- Name: COLUMN hr_leave_accrual_level.cap_accrued_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.cap_accrued_time IS 'Cap Accrued Time';


--
-- Name: COLUMN hr_leave_accrual_level.cap_accrued_time_yearly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.cap_accrued_time_yearly IS 'Cap Accrued Time Yearly';


--
-- Name: COLUMN hr_leave_accrual_level.accrual_validity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.accrual_validity IS 'Accrual Validity';


--
-- Name: COLUMN hr_leave_accrual_level.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_accrual_level.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_leave_accrual_level_added_value_greater_than_zero ON hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_accrual_level_added_value_greater_than_zero ON public.hr_leave_accrual_level IS 'CHECK(added_value > 0)';


--
-- Name: CONSTRAINT hr_leave_accrual_level_start_count_check ON hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_accrual_level_start_count_check ON public.hr_leave_accrual_level IS 'CHECK((start_count > 0 AND milestone_date = ''after'') OR (start_count = 0 AND milestone_date = ''creation''))';


--
-- Name: CONSTRAINT hr_leave_accrual_level_valid_accrual_validity_value ON hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_accrual_level_valid_accrual_validity_value ON public.hr_leave_accrual_level IS 'CHECK(accrual_validity IS NOT TRUE OR COALESCE(accrual_validity_count, 0) > 0)';


--
-- Name: CONSTRAINT hr_leave_accrual_level_valid_postpone_max_days_value ON hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_accrual_level_valid_postpone_max_days_value ON public.hr_leave_accrual_level IS 'CHECK(action_with_unused_accruals <> ''all'' OR carryover_options <> ''limited'' OR COALESCE(postpone_max_days, 0) > 0)';


--
-- Name: CONSTRAINT hr_leave_accrual_level_valid_yearly_cap_value ON hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_accrual_level_valid_yearly_cap_value ON public.hr_leave_accrual_level IS 'CHECK(cap_accrued_time_yearly IS NOT TRUE OR COALESCE(maximum_leave_yearly, 0) > 0)';


--
-- Name: hr_leave_accrual_level_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_accrual_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_accrual_level_id_seq OWNER TO runbot;

--
-- Name: hr_leave_accrual_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_accrual_level_id_seq OWNED BY public.hr_leave_accrual_level.id;


--
-- Name: hr_leave_accrual_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_accrual_plan (
    id integer NOT NULL,
    time_off_type_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    transition_mode character varying NOT NULL,
    accrued_gain_time character varying NOT NULL,
    carryover_date character varying NOT NULL,
    carryover_day character varying,
    carryover_month character varying,
    added_value_type character varying,
    active boolean,
    is_based_on_worked_time boolean,
    can_be_carryover boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_leave_accrual_plan OWNER TO runbot;

--
-- Name: TABLE hr_leave_accrual_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_accrual_plan IS 'Accrual Plan';


--
-- Name: COLUMN hr_leave_accrual_plan.time_off_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.time_off_type_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_accrual_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_accrual_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_accrual_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_accrual_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.name IS 'Name';


--
-- Name: COLUMN hr_leave_accrual_plan.transition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.transition_mode IS 'Transition Mode';


--
-- Name: COLUMN hr_leave_accrual_plan.accrued_gain_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.accrued_gain_time IS 'Accrued Gain Time';


--
-- Name: COLUMN hr_leave_accrual_plan.carryover_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.carryover_date IS 'Carry-Over Time';


--
-- Name: COLUMN hr_leave_accrual_plan.carryover_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.carryover_day IS 'Carryover Day';


--
-- Name: COLUMN hr_leave_accrual_plan.carryover_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.carryover_month IS 'Carryover Month';


--
-- Name: COLUMN hr_leave_accrual_plan.added_value_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.added_value_type IS 'Added Value Type';


--
-- Name: COLUMN hr_leave_accrual_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.active IS 'Active';


--
-- Name: COLUMN hr_leave_accrual_plan.is_based_on_worked_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.is_based_on_worked_time IS 'Is Based On Worked Time';


--
-- Name: COLUMN hr_leave_accrual_plan.can_be_carryover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.can_be_carryover IS 'Can Be Carryover';


--
-- Name: COLUMN hr_leave_accrual_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_accrual_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.write_date IS 'Last Updated on';


--
-- Name: hr_leave_accrual_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_accrual_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_accrual_plan_id_seq OWNER TO runbot;

--
-- Name: hr_leave_accrual_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_accrual_plan_id_seq OWNED BY public.hr_leave_accrual_plan.id;


--
-- Name: hr_leave_allocation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_allocation (
    id integer NOT NULL,
    holiday_status_id integer NOT NULL,
    employee_id integer NOT NULL,
    employee_company_id integer,
    manager_id integer,
    approver_id integer,
    second_approver_id integer,
    department_id integer,
    accrual_plan_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    state character varying,
    allocation_type character varying NOT NULL,
    date_from date NOT NULL,
    date_to date,
    last_executed_carryover_date date,
    lastcall date,
    actual_lastcall date,
    nextcall date,
    carried_over_days_expiration_date date,
    notes text,
    already_accrued boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    number_of_days double precision,
    number_of_hours_display double precision,
    yearly_accrued_amount double precision,
    expiring_carryover_days double precision,
    CONSTRAINT hr_leave_allocation_duration_check CHECK ((((number_of_days > (0)::double precision) AND ((allocation_type)::text = 'regular'::text)) OR ((allocation_type)::text <> 'regular'::text)))
);


ALTER TABLE public.hr_leave_allocation OWNER TO runbot;

--
-- Name: TABLE hr_leave_allocation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_allocation IS 'Time Off Allocation';


--
-- Name: COLUMN hr_leave_allocation.holiday_status_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.holiday_status_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_allocation.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.employee_id IS 'Employee';


--
-- Name: COLUMN hr_leave_allocation.employee_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.employee_company_id IS 'Company';


--
-- Name: COLUMN hr_leave_allocation.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.manager_id IS 'Manager';


--
-- Name: COLUMN hr_leave_allocation.approver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.approver_id IS 'First Approval';


--
-- Name: COLUMN hr_leave_allocation.second_approver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.second_approver_id IS 'Second Approval';


--
-- Name: COLUMN hr_leave_allocation.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.department_id IS 'Department';


--
-- Name: COLUMN hr_leave_allocation.accrual_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.accrual_plan_id IS 'Accrual Plan';


--
-- Name: COLUMN hr_leave_allocation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_allocation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_allocation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.name IS 'Description';


--
-- Name: COLUMN hr_leave_allocation.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.state IS 'Status';


--
-- Name: COLUMN hr_leave_allocation.allocation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.allocation_type IS 'Allocation Type';


--
-- Name: COLUMN hr_leave_allocation.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.date_from IS 'Start Date';


--
-- Name: COLUMN hr_leave_allocation.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.date_to IS 'End Date';


--
-- Name: COLUMN hr_leave_allocation.last_executed_carryover_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.last_executed_carryover_date IS 'Last Executed Carryover Date';


--
-- Name: COLUMN hr_leave_allocation.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.lastcall IS 'Date of the last accrual allocation';


--
-- Name: COLUMN hr_leave_allocation.actual_lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.actual_lastcall IS 'Actual Lastcall';


--
-- Name: COLUMN hr_leave_allocation.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.nextcall IS 'Date of the next accrual allocation';


--
-- Name: COLUMN hr_leave_allocation.carried_over_days_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.carried_over_days_expiration_date IS 'Carried over days expiration date';


--
-- Name: COLUMN hr_leave_allocation.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.notes IS 'Reasons';


--
-- Name: COLUMN hr_leave_allocation.already_accrued; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.already_accrued IS 'Already Accrued';


--
-- Name: COLUMN hr_leave_allocation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_allocation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_leave_allocation.number_of_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.number_of_days IS 'Number of Days';


--
-- Name: COLUMN hr_leave_allocation.number_of_hours_display; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.number_of_hours_display IS 'Duration (hours)';


--
-- Name: COLUMN hr_leave_allocation.yearly_accrued_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.yearly_accrued_amount IS 'Yearly Accrued Amount';


--
-- Name: COLUMN hr_leave_allocation.expiring_carryover_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.expiring_carryover_days IS 'The number of carried over days that will expire on carried_over_days_expiration_date';


--
-- Name: CONSTRAINT hr_leave_allocation_duration_check ON hr_leave_allocation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_allocation_duration_check ON public.hr_leave_allocation IS 'CHECK( ( number_of_days > 0 AND allocation_type=''regular'') or (allocation_type != ''regular''))';


--
-- Name: hr_leave_allocation_generate_multi_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_allocation_generate_multi_wizard (
    id integer NOT NULL,
    holiday_status_id integer NOT NULL,
    company_id integer NOT NULL,
    department_id integer,
    category_id integer,
    accrual_plan_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    allocation_mode character varying NOT NULL,
    allocation_type character varying NOT NULL,
    date_from date NOT NULL,
    date_to date,
    notes text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.hr_leave_allocation_generate_multi_wizard OWNER TO runbot;

--
-- Name: TABLE hr_leave_allocation_generate_multi_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_allocation_generate_multi_wizard IS 'Generate time off allocations for multiple employees';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.holiday_status_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.holiday_status_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.department_id IS 'Department';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.category_id IS 'Employee Tag';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.accrual_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.accrual_plan_id IS 'Accrual Plan';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.name IS 'Description';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.allocation_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.allocation_mode IS 'Allocation Mode';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.allocation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.allocation_type IS 'Allocation Type';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.date_from IS 'Start Date';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.date_to IS 'End Date';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.notes IS 'Reasons';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.duration IS 'Allocation';


--
-- Name: hr_leave_allocation_generate_multi_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_allocation_generate_multi_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_allocation_generate_multi_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_leave_allocation_generate_multi_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_allocation_generate_multi_wizard_id_seq OWNED BY public.hr_leave_allocation_generate_multi_wizard.id;


--
-- Name: hr_leave_allocation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_allocation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_allocation_id_seq OWNER TO runbot;

--
-- Name: hr_leave_allocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_allocation_id_seq OWNED BY public.hr_leave_allocation.id;


--
-- Name: hr_leave_employee_type_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_leave_employee_type_report AS
 SELECT row_number() OVER (ORDER BY employee_id) AS id,
    employee_id,
    active_employee,
    number_of_days,
    number_of_hours,
    department_id,
    leave_type,
    holiday_status,
    state,
    date_from,
    date_to,
    company_id
   FROM ( SELECT allocation.employee_id,
            employee.active AS active_employee,
                CASE
                    WHEN (allocation.id = min_allocation_id.min_id) THEN (aggregate_allocation.number_of_days - COALESCE(aggregate_leave.number_of_days, (0)::double precision))
                    ELSE (0)::double precision
                END AS number_of_days,
                CASE
                    WHEN (allocation.id = min_allocation_id.min_id) THEN (aggregate_allocation.number_of_hours - COALESCE(aggregate_leave.number_of_hours, (0)::double precision))
                    ELSE (0)::double precision
                END AS number_of_hours,
            v.department_id,
            allocation.holiday_status_id AS leave_type,
            allocation.state,
            allocation.date_from,
            allocation.date_to,
            'left'::text AS holiday_status,
            allocation.employee_company_id AS company_id
           FROM (((((public.hr_leave_allocation allocation
             JOIN public.hr_employee employee ON ((allocation.employee_id = employee.id)))
             LEFT JOIN public.hr_version v ON ((v.id = employee.current_version_id)))
             LEFT JOIN ( SELECT hr_leave_allocation.employee_id,
                    hr_leave_allocation.holiday_status_id,
                    min(hr_leave_allocation.id) AS min_id
                   FROM public.hr_leave_allocation
                  GROUP BY hr_leave_allocation.employee_id, hr_leave_allocation.holiday_status_id) min_allocation_id ON (((allocation.employee_id = min_allocation_id.employee_id) AND (allocation.holiday_status_id = min_allocation_id.holiday_status_id))))
             LEFT JOIN ( SELECT hr_leave_allocation.employee_id,
                    hr_leave_allocation.holiday_status_id,
                    sum(
                        CASE
                            WHEN ((hr_leave_allocation.state)::text = 'validate'::text) THEN hr_leave_allocation.number_of_days
                            ELSE (0)::double precision
                        END) AS number_of_days,
                    sum(
                        CASE
                            WHEN ((hr_leave_allocation.state)::text = 'validate'::text) THEN hr_leave_allocation.number_of_hours_display
                            ELSE (0)::double precision
                        END) AS number_of_hours
                   FROM public.hr_leave_allocation
                  GROUP BY hr_leave_allocation.employee_id, hr_leave_allocation.holiday_status_id) aggregate_allocation ON (((allocation.employee_id = aggregate_allocation.employee_id) AND (allocation.holiday_status_id = aggregate_allocation.holiday_status_id))))
             LEFT JOIN ( SELECT hr_leave.employee_id,
                    hr_leave.holiday_status_id,
                    sum(
                        CASE
                            WHEN ((hr_leave.state)::text = ANY ((ARRAY['validate'::character varying, 'validate1'::character varying])::text[])) THEN hr_leave.number_of_days
                            ELSE (0)::double precision
                        END) AS number_of_days,
                    sum(
                        CASE
                            WHEN ((hr_leave.state)::text = ANY ((ARRAY['validate'::character varying, 'validate1'::character varying])::text[])) THEN hr_leave.number_of_hours
                            ELSE (0)::double precision
                        END) AS number_of_hours
                   FROM public.hr_leave
                  GROUP BY hr_leave.employee_id, hr_leave.holiday_status_id) aggregate_leave ON (((allocation.employee_id = aggregate_leave.employee_id) AND (allocation.holiday_status_id = aggregate_leave.holiday_status_id))))
        UNION ALL
         SELECT request.employee_id,
            employee.active AS active_employee,
            request.number_of_days,
            request.number_of_hours,
            v.department_id,
            request.holiday_status_id AS leave_type,
            request.state,
            request.date_from,
            request.date_to,
                CASE
                    WHEN ((request.state)::text = ANY ((ARRAY['validate1'::character varying, 'validate'::character varying])::text[])) THEN 'taken'::text
                    WHEN ((request.state)::text = 'confirm'::text) THEN 'planned'::text
                    ELSE NULL::text
                END AS holiday_status,
            request.employee_company_id AS company_id
           FROM ((public.hr_leave request
             JOIN public.hr_employee employee ON ((request.employee_id = employee.id)))
             LEFT JOIN public.hr_version v ON ((v.id = employee.current_version_id)))
          WHERE ((request.state)::text = ANY ((ARRAY['confirm'::character varying, 'validate'::character varying, 'validate1'::character varying])::text[]))) leaves;


ALTER VIEW public.hr_leave_employee_type_report OWNER TO runbot;

--
-- Name: hr_leave_generate_multi_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_generate_multi_wizard (
    id integer NOT NULL,
    holiday_status_id integer NOT NULL,
    company_id integer NOT NULL,
    department_id integer,
    category_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    allocation_mode character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_leave_generate_multi_wizard OWNER TO runbot;

--
-- Name: TABLE hr_leave_generate_multi_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_generate_multi_wizard IS 'Generate time off for multiple employees';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.holiday_status_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.holiday_status_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.department_id IS 'Department';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.category_id IS 'Employee Tag';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.name IS 'Description';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.allocation_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.allocation_mode IS 'Allocation Mode';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.date_from IS 'Start Date';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.date_to IS 'End Date';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_leave_generate_multi_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_generate_multi_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_generate_multi_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_leave_generate_multi_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_generate_multi_wizard_id_seq OWNED BY public.hr_leave_generate_multi_wizard.id;


--
-- Name: hr_leave_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_id_seq OWNER TO runbot;

--
-- Name: hr_leave_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_id_seq OWNED BY public.hr_leave.id;


--
-- Name: hr_leave_mandatory_day; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_mandatory_day (
    id integer NOT NULL,
    company_id integer NOT NULL,
    color integer,
    resource_calendar_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    start_date date NOT NULL,
    end_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_leave_mandatory_day_date_from_after_day_to CHECK ((start_date <= end_date))
);


ALTER TABLE public.hr_leave_mandatory_day OWNER TO runbot;

--
-- Name: TABLE hr_leave_mandatory_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_mandatory_day IS 'Mandatory Day';


--
-- Name: COLUMN hr_leave_mandatory_day.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_mandatory_day.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.color IS 'Color';


--
-- Name: COLUMN hr_leave_mandatory_day.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_leave_mandatory_day.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_mandatory_day.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_mandatory_day.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.name IS 'Name';


--
-- Name: COLUMN hr_leave_mandatory_day.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.start_date IS 'Start Date';


--
-- Name: COLUMN hr_leave_mandatory_day.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.end_date IS 'End Date';


--
-- Name: COLUMN hr_leave_mandatory_day.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_mandatory_day.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_leave_mandatory_day_date_from_after_day_to ON hr_leave_mandatory_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_mandatory_day_date_from_after_day_to ON public.hr_leave_mandatory_day IS 'CHECK(start_date <= end_date)';


--
-- Name: hr_leave_mandatory_day_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_mandatory_day_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_mandatory_day_id_seq OWNER TO runbot;

--
-- Name: hr_leave_mandatory_day_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_mandatory_day_id_seq OWNED BY public.hr_leave_mandatory_day.id;


--
-- Name: hr_leave_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_leave_report AS
 SELECT row_number() OVER (ORDER BY employee_id) AS id,
    leave_id,
    allocation_id,
    employee_id,
    name,
    number_of_days,
    leave_type,
    number_of_hours,
    department_id,
    holiday_status_id,
    state,
    date_from,
    date_to,
    company_id
   FROM ( SELECT NULL::text AS leave_id,
            allocation.id AS allocation_id,
            allocation.employee_id,
            allocation.name,
            allocation.number_of_days,
            allocation.number_of_hours_display AS number_of_hours,
            v.department_id,
            allocation.holiday_status_id,
            allocation.state,
            allocation.date_from,
            allocation.date_to,
            'allocation'::text AS leave_type,
            allocation.employee_company_id AS company_id
           FROM ((public.hr_leave_allocation allocation
             JOIN public.hr_employee employee ON ((allocation.employee_id = employee.id)))
             LEFT JOIN public.hr_version v ON ((v.id = employee.current_version_id)))
          WHERE (employee.active IS TRUE)
        UNION ALL
         SELECT NULL::text AS allocation_id,
            request.id AS leave_id,
            request.employee_id,
            request.private_name AS name,
            (request.number_of_days * ('-1'::integer)::double precision) AS number_of_days,
            (request.number_of_hours * ('-1'::integer)::double precision) AS number_of_hours,
            v.department_id,
            request.holiday_status_id,
            request.state,
            request.date_from,
            request.date_to,
            'request'::text AS leave_type,
            request.employee_company_id AS company_id
           FROM ((public.hr_leave request
             JOIN public.hr_employee employee ON ((request.employee_id = employee.id)))
             LEFT JOIN public.hr_version v ON ((v.id = employee.current_version_id)))
          WHERE (employee.active IS TRUE)) leaves;


ALTER VIEW public.hr_leave_report OWNER TO runbot;

--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea,
    resource_calendar_id integer,
    alias_domain_id integer,
    email_primary_color character varying,
    email_secondary_color character varying,
    iap_enrich_auto_done boolean,
    snailmail_color boolean,
    snailmail_cover boolean,
    snailmail_duplex boolean,
    hr_presence_control_email_amount integer,
    contract_expiration_notice_period integer,
    work_permit_expiration_notice_period integer,
    hr_presence_control_ip_list character varying,
    employee_properties_definition jsonb,
    hr_presence_control_login boolean,
    hr_presence_control_email boolean,
    hr_presence_control_ip boolean,
    hr_presence_control_attendance boolean
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.resource_calendar_id IS 'Default Working Hours';


--
-- Name: COLUMN res_company.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.alias_domain_id IS 'Email Domain';


--
-- Name: COLUMN res_company.email_primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_primary_color IS 'Email Button Text';


--
-- Name: COLUMN res_company.email_secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_secondary_color IS 'Email Button Color';


--
-- Name: COLUMN res_company.iap_enrich_auto_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.iap_enrich_auto_done IS 'Enrich Done';


--
-- Name: COLUMN res_company.snailmail_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_color IS 'Snailmail Color';


--
-- Name: COLUMN res_company.snailmail_cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN res_company.snailmail_duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_duplex IS 'Both sides';


--
-- Name: COLUMN res_company.hr_presence_control_email_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email_amount IS '# emails to send';


--
-- Name: COLUMN res_company.contract_expiration_notice_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.contract_expiration_notice_period IS 'Contract Expiry Notice Period';


--
-- Name: COLUMN res_company.work_permit_expiration_notice_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.work_permit_expiration_notice_period IS 'Work Permit Expiry Notice Period';


--
-- Name: COLUMN res_company.hr_presence_control_ip_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip_list IS 'Valid IP addresses';


--
-- Name: COLUMN res_company.employee_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.employee_properties_definition IS 'Employee Properties';


--
-- Name: COLUMN res_company.hr_presence_control_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_login IS 'Based on user status in system';


--
-- Name: COLUMN res_company.hr_presence_control_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email IS 'Based on number of emails sent';


--
-- Name: COLUMN res_company.hr_presence_control_ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip IS 'Based on IP Address';


--
-- Name: COLUMN res_company.hr_presence_control_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_attendance IS 'Based on attendances';


--
-- Name: resource_calendar; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    schedule_type character varying NOT NULL,
    tz character varying NOT NULL,
    hours_per_day numeric,
    active boolean,
    duration_based boolean,
    flexible_hours boolean,
    two_weeks_calendar boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    full_time_required_hours double precision,
    hours_per_week double precision
);


ALTER TABLE public.resource_calendar OWNER TO runbot;

--
-- Name: TABLE resource_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar IS 'Resource Working Time';


--
-- Name: COLUMN resource_calendar.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.name IS 'Name';


--
-- Name: COLUMN resource_calendar.schedule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.schedule_type IS 'Schedule Type';


--
-- Name: COLUMN resource_calendar.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.tz IS 'Timezone';


--
-- Name: COLUMN resource_calendar.hours_per_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.hours_per_day IS 'Average Hour per Day';


--
-- Name: COLUMN resource_calendar.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.active IS 'Active';


--
-- Name: COLUMN resource_calendar.duration_based; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.duration_based IS 'Attendance based on duration';


--
-- Name: COLUMN resource_calendar.flexible_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.flexible_hours IS 'Flexible Hours';


--
-- Name: COLUMN resource_calendar.two_weeks_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.two_weeks_calendar IS 'Calendar in 2 weeks mode';


--
-- Name: COLUMN resource_calendar.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar.full_time_required_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.full_time_required_hours IS 'Full Time Equivalent';


--
-- Name: COLUMN resource_calendar.hours_per_week; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.hours_per_week IS 'Hours per Week';


--
-- Name: resource_resource; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_resource (
    id integer NOT NULL,
    company_id integer,
    user_id integer,
    calendar_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    resource_type character varying NOT NULL,
    tz character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    time_efficiency double precision NOT NULL,
    color integer,
    CONSTRAINT resource_resource_check_time_efficiency CHECK ((time_efficiency > (0)::double precision))
);


ALTER TABLE public.resource_resource OWNER TO runbot;

--
-- Name: TABLE resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_resource IS 'Resources';


--
-- Name: COLUMN resource_resource.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.company_id IS 'Company';


--
-- Name: COLUMN resource_resource.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.user_id IS 'User';


--
-- Name: COLUMN resource_resource.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.calendar_id IS 'Working Time';


--
-- Name: COLUMN resource_resource.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_uid IS 'Created by';


--
-- Name: COLUMN resource_resource.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_resource.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.name IS 'Name';


--
-- Name: COLUMN resource_resource.resource_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.resource_type IS 'Type';


--
-- Name: COLUMN resource_resource.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.tz IS 'Timezone';


--
-- Name: COLUMN resource_resource.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.active IS 'Active';


--
-- Name: COLUMN resource_resource.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_date IS 'Created on';


--
-- Name: COLUMN resource_resource.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_resource.time_efficiency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.time_efficiency IS 'Efficiency Factor';


--
-- Name: COLUMN resource_resource.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.color IS 'Color';


--
-- Name: CONSTRAINT resource_resource_check_time_efficiency ON resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT resource_resource_check_time_efficiency ON public.resource_resource IS 'CHECK(time_efficiency>0)';


--
-- Name: hr_leave_report_calendar; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_leave_report_calendar AS
 SELECT hl.id,
    hl.id AS leave_id,
    hl.date_from AS start_datetime,
    hl.date_to AS stop_datetime,
    hl.employee_id,
    hl.state,
    hl.department_id,
    hl.number_of_days AS duration,
    hl.private_name AS description,
    hl.holiday_status_id,
    em.company_id,
    v.job_id,
    em.user_id,
    COALESCE(rr.tz, rc.tz, cc.tz, 'UTC'::character varying) AS tz,
    ((hl.state)::text = 'refuse'::text) AS is_striked,
    ((hl.state)::text <> ALL ((ARRAY['validate'::character varying, 'refuse'::character varying])::text[])) AS is_hatched
   FROM ((((((public.hr_leave hl
     LEFT JOIN public.hr_employee em ON ((em.id = hl.employee_id)))
     LEFT JOIN public.hr_version v ON ((v.id = em.current_version_id)))
     LEFT JOIN public.resource_resource rr ON ((rr.id = em.resource_id)))
     LEFT JOIN public.resource_calendar rc ON ((rc.id = v.resource_calendar_id)))
     LEFT JOIN public.res_company co ON ((co.id = em.company_id)))
     LEFT JOIN public.resource_calendar cc ON ((cc.id = co.resource_calendar_id)))
  WHERE ((hl.state)::text = ANY ((ARRAY['confirm'::character varying, 'validate'::character varying, 'validate1'::character varying, 'refuse'::character varying])::text[]));


ALTER VIEW public.hr_leave_report_calendar OWNER TO runbot;

--
-- Name: hr_leave_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_type (
    id integer NOT NULL,
    sequence integer,
    color integer,
    icon_id integer,
    company_id integer,
    country_id integer,
    leave_notif_subtype_id integer,
    allocation_notif_subtype_id integer,
    max_allowed_negative integer,
    create_uid integer,
    write_uid integer,
    leave_validation_type character varying,
    allocation_validation_type character varying,
    time_type character varying,
    request_unit character varying NOT NULL,
    name jsonb NOT NULL,
    create_calendar_meeting boolean,
    active boolean,
    hide_on_dashboard boolean,
    requires_allocation boolean NOT NULL,
    employee_requests boolean NOT NULL,
    unpaid boolean,
    include_public_holidays_in_duration boolean,
    support_document boolean,
    allow_request_on_top boolean,
    elligible_for_accrual_rate boolean,
    allows_negative boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    pre_approved_instance boolean,
    CONSTRAINT hr_leave_type_check_negative CHECK (((NOT allows_negative) OR (max_allowed_negative > 0)))
);


ALTER TABLE public.hr_leave_type OWNER TO runbot;

--
-- Name: TABLE hr_leave_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_type IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_leave_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.color IS 'Color';


--
-- Name: COLUMN hr_leave_type.icon_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.icon_id IS 'Cover Image';


--
-- Name: COLUMN hr_leave_type.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.country_id IS 'Country';


--
-- Name: COLUMN hr_leave_type.leave_notif_subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.leave_notif_subtype_id IS 'Time Off Notification Subtype';


--
-- Name: COLUMN hr_leave_type.allocation_notif_subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.allocation_notif_subtype_id IS 'Allocation Notification Subtype';


--
-- Name: COLUMN hr_leave_type.max_allowed_negative; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.max_allowed_negative IS 'Maximum Excess Amount';


--
-- Name: COLUMN hr_leave_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_type.leave_validation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.leave_validation_type IS 'Time Off Validation';


--
-- Name: COLUMN hr_leave_type.allocation_validation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.allocation_validation_type IS 'Approval';


--
-- Name: COLUMN hr_leave_type.time_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.time_type IS 'Kind of Time Off';


--
-- Name: COLUMN hr_leave_type.request_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.request_unit IS 'Duration Type';


--
-- Name: COLUMN hr_leave_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.name IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_type.create_calendar_meeting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.create_calendar_meeting IS 'Display Time Off in Calendar';


--
-- Name: COLUMN hr_leave_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.active IS 'Active';


--
-- Name: COLUMN hr_leave_type.hide_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.hide_on_dashboard IS 'Hide On Dashboard';


--
-- Name: COLUMN hr_leave_type.requires_allocation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.requires_allocation IS 'Requires allocation';


--
-- Name: COLUMN hr_leave_type.employee_requests; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.employee_requests IS 'Allow Employee Requests';


--
-- Name: COLUMN hr_leave_type.unpaid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.unpaid IS 'Is Unpaid';


--
-- Name: COLUMN hr_leave_type.include_public_holidays_in_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.include_public_holidays_in_duration IS 'Ignore Public Holidays';


--
-- Name: COLUMN hr_leave_type.support_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.support_document IS 'Supporting Document';


--
-- Name: COLUMN hr_leave_type.allow_request_on_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.allow_request_on_top IS 'Allow Request on Top';


--
-- Name: COLUMN hr_leave_type.elligible_for_accrual_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.elligible_for_accrual_rate IS 'Eligible for Accrual Rate';


--
-- Name: COLUMN hr_leave_type.allows_negative; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.allows_negative IS 'Allow Negative Cap';


--
-- Name: COLUMN hr_leave_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_leave_type.pre_approved_instance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.pre_approved_instance IS 'Pre Approved Instance';


--
-- Name: CONSTRAINT hr_leave_type_check_negative ON hr_leave_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_type_check_negative ON public.hr_leave_type IS 'CHECK(NOT allows_negative OR max_allowed_negative > 0)';


--
-- Name: hr_leave_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_type_id_seq OWNER TO runbot;

--
-- Name: hr_leave_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_type_id_seq OWNED BY public.hr_leave_type.id;


--
-- Name: hr_leave_type_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_type_res_users_rel (
    hr_leave_type_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.hr_leave_type_res_users_rel OWNER TO runbot;

--
-- Name: TABLE hr_leave_type_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_type_res_users_rel IS 'RELATION BETWEEN hr_leave_type AND res_users';


--
-- Name: hr_payroll_structure_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_payroll_structure_type (
    id integer NOT NULL,
    default_resource_calendar_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_payroll_structure_type OWNER TO runbot;

--
-- Name: TABLE hr_payroll_structure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_payroll_structure_type IS 'Salary Structure Type';


--
-- Name: COLUMN hr_payroll_structure_type.default_resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.default_resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_payroll_structure_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.country_id IS 'Country';


--
-- Name: COLUMN hr_payroll_structure_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_payroll_structure_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_payroll_structure_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.name IS 'Salary Structure Type';


--
-- Name: COLUMN hr_payroll_structure_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_payroll_structure_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_payroll_structure_type.write_date IS 'Last Updated on';


--
-- Name: hr_payroll_structure_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_payroll_structure_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_payroll_structure_type_id_seq OWNER TO runbot;

--
-- Name: hr_payroll_structure_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_payroll_structure_type_id_seq OWNED BY public.hr_payroll_structure_type.id;


--
-- Name: hr_resume_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_resume_line (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    duration integer,
    line_type_id integer,
    create_uid integer,
    write_uid integer,
    course_type character varying NOT NULL,
    external_url character varying,
    certificate_filename character varying,
    date_start date NOT NULL,
    date_end date,
    name jsonb NOT NULL,
    description jsonb,
    resume_line_properties jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_resume_line_date_check CHECK (((date_start <= date_end) OR (date_end IS NULL)))
);


ALTER TABLE public.hr_resume_line OWNER TO runbot;

--
-- Name: TABLE hr_resume_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_resume_line IS 'Resume line of an employee';


--
-- Name: COLUMN hr_resume_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.employee_id IS 'Employee';


--
-- Name: COLUMN hr_resume_line.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.duration IS 'Duration';


--
-- Name: COLUMN hr_resume_line.line_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.line_type_id IS 'Type';


--
-- Name: COLUMN hr_resume_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.create_uid IS 'Created by';


--
-- Name: COLUMN hr_resume_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_resume_line.course_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.course_type IS 'Course Type';


--
-- Name: COLUMN hr_resume_line.external_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.external_url IS 'External URL';


--
-- Name: COLUMN hr_resume_line.certificate_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.certificate_filename IS 'Certificate Filename';


--
-- Name: COLUMN hr_resume_line.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.date_start IS 'Date Start';


--
-- Name: COLUMN hr_resume_line.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.date_end IS 'Date End';


--
-- Name: COLUMN hr_resume_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.name IS 'Name';


--
-- Name: COLUMN hr_resume_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.description IS 'Description';


--
-- Name: COLUMN hr_resume_line.resume_line_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.resume_line_properties IS 'Properties';


--
-- Name: COLUMN hr_resume_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.create_date IS 'Created on';


--
-- Name: COLUMN hr_resume_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_resume_line_date_check ON hr_resume_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_resume_line_date_check ON public.hr_resume_line IS 'CHECK ((date_start <= date_end OR date_end IS NULL))';


--
-- Name: hr_resume_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_resume_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_resume_line_id_seq OWNER TO runbot;

--
-- Name: hr_resume_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_resume_line_id_seq OWNED BY public.hr_resume_line.id;


--
-- Name: hr_resume_line_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_resume_line_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    resume_line_type_properties_definition jsonb,
    is_course boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_resume_line_type OWNER TO runbot;

--
-- Name: TABLE hr_resume_line_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_resume_line_type IS 'Type of a resume line';


--
-- Name: COLUMN hr_resume_line_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_resume_line_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_resume_line_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_resume_line_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.name IS 'Name';


--
-- Name: COLUMN hr_resume_line_type.resume_line_type_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.resume_line_type_properties_definition IS 'Sections Properties';


--
-- Name: COLUMN hr_resume_line_type.is_course; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.is_course IS 'Course';


--
-- Name: COLUMN hr_resume_line_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_resume_line_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.write_date IS 'Last Updated on';


--
-- Name: hr_resume_line_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_resume_line_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_resume_line_type_id_seq OWNER TO runbot;

--
-- Name: hr_resume_line_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_resume_line_type_id_seq OWNED BY public.hr_resume_line_type.id;


--
-- Name: hr_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill (
    id integer NOT NULL,
    sequence integer,
    skill_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_skill OWNER TO runbot;

--
-- Name: TABLE hr_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill IS 'Skill';


--
-- Name: COLUMN hr_skill.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.sequence IS 'Sequence';


--
-- Name: COLUMN hr_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.name IS 'Name';


--
-- Name: COLUMN hr_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.write_date IS 'Last Updated on';


--
-- Name: hr_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_id_seq OWNER TO runbot;

--
-- Name: hr_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_id_seq OWNED BY public.hr_skill.id;


--
-- Name: hr_skill_level_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_level_id_seq OWNER TO runbot;

--
-- Name: hr_skill_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_level_id_seq OWNED BY public.hr_skill_level.id;


--
-- Name: hr_skill_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_type_id_seq OWNER TO runbot;

--
-- Name: hr_skill_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_type_id_seq OWNED BY public.hr_skill_type.id;


--
-- Name: hr_version_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_version_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_version_id_seq OWNER TO runbot;

--
-- Name: hr_version_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_version_id_seq OWNED BY public.hr_version.id;


--
-- Name: hr_version_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_version_wizard (
    id integer NOT NULL,
    contract_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_version_wizard OWNER TO runbot;

--
-- Name: TABLE hr_version_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_version_wizard IS 'Contract Template Wizard';


--
-- Name: COLUMN hr_version_wizard.contract_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.contract_template_id IS 'Contract Template';


--
-- Name: COLUMN hr_version_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_version_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_version_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_version_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_version_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_version_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_version_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_version_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_version_wizard_id_seq OWNED BY public.hr_version_wizard.id;


--
-- Name: hr_work_location; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_work_location (
    id integer NOT NULL,
    company_id integer NOT NULL,
    address_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location_type character varying NOT NULL,
    location_number character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_work_location OWNER TO runbot;

--
-- Name: TABLE hr_work_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_work_location IS 'Work Location';


--
-- Name: COLUMN hr_work_location.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.company_id IS 'Company';


--
-- Name: COLUMN hr_work_location.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.address_id IS 'Work Address';


--
-- Name: COLUMN hr_work_location.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_uid IS 'Created by';


--
-- Name: COLUMN hr_work_location.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_work_location.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.name IS 'Work Location';


--
-- Name: COLUMN hr_work_location.location_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.location_type IS 'Cover Image';


--
-- Name: COLUMN hr_work_location.location_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.location_number IS 'Location Number';


--
-- Name: COLUMN hr_work_location.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.active IS 'Active';


--
-- Name: COLUMN hr_work_location.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_date IS 'Created on';


--
-- Name: COLUMN hr_work_location.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_date IS 'Last Updated on';


--
-- Name: hr_work_location_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_work_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_work_location_id_seq OWNER TO runbot;

--
-- Name: hr_work_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_work_location_id_seq OWNED BY public.hr_work_location.id;


--
-- Name: html_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.html_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.html_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE html_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.html_editor_converter_test IS 'Html Editor Converter Test';


--
-- Name: COLUMN html_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN html_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN html_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN html_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN html_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN html_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN html_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN html_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN html_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN html_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN html_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN html_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN html_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN html_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN html_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."binary" IS 'Binary';


--
-- Name: html_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.html_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.html_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: html_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.html_editor_converter_test_id_seq OWNED BY public.html_editor_converter_test.id;


--
-- Name: html_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.html_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.html_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE html_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.html_editor_converter_test_sub IS 'Html Editor Converter Subtest';


--
-- Name: COLUMN html_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN html_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN html_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN html_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN html_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: html_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.html_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.html_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: html_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.html_editor_converter_test_sub_id_seq OWNED BY public.html_editor_converter_test_sub.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision,
    sender_name character varying
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: COLUMN iap_account.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.sender_name IS 'Sender Name';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    parent_id integer,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    sequence_id integer,
    selection_value integer,
    automated_name character varying,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text,
    html_value text,
    activity_user_id integer,
    activity_type_id integer,
    template_id integer,
    activity_date_deadline_range integer,
    activity_summary character varying,
    followers_type character varying,
    followers_partner_field_name character varying,
    mail_post_method character varying,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_field_name character varying,
    activity_note text,
    mail_post_autofollow boolean,
    sms_template_id integer,
    sms_method character varying,
    ai_tool_description jsonb,
    ai_action_prompt text,
    ai_tool_schema text,
    use_in_ai boolean,
    ai_tool_allow_end_message boolean,
    ai_update_prompt text
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.parent_id IS 'Parent Action';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence_id IS 'Sequence to use';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.automated_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.automated_name IS 'Automated Name';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: COLUMN ir_act_server.html_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.html_value IS 'Html Value';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Title';


--
-- Name: COLUMN ir_act_server.followers_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.followers_type IS 'Followers Type';


--
-- Name: COLUMN ir_act_server.followers_partner_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.followers_partner_field_name IS 'Followers Field';


--
-- Name: COLUMN ir_act_server.mail_post_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_method IS 'Send Email As';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'User Type';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User Field';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.mail_post_autofollow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_autofollow IS 'Subscribe Recipients';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_method IS 'Send SMS As';


--
-- Name: COLUMN ir_act_server.ai_tool_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_description IS 'AI Tool Description';


--
-- Name: COLUMN ir_act_server.ai_action_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_action_prompt IS 'AI Action Prompt';


--
-- Name: COLUMN ir_act_server.ai_tool_schema; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_schema IS 'AI Schema';


--
-- Name: COLUMN ir_act_server.use_in_ai; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.use_in_ai IS 'Use in AI';


--
-- Name: COLUMN ir_act_server.ai_tool_allow_end_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_allow_end_message IS 'Allow End Message';


--
-- Name: COLUMN ir_act_server.ai_update_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_update_prompt IS 'AI Update Prompt';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean,
    cache boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: COLUMN ir_act_window.cache; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.cache IS 'Data Caching';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_server_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_server_history (
    id integer NOT NULL,
    action_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_server_history OWNER TO runbot;

--
-- Name: TABLE ir_actions_server_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_server_history IS 'Server Action History';


--
-- Name: COLUMN ir_actions_server_history.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_server_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_server_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_server_history.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.code IS 'Code';


--
-- Name: COLUMN ir_actions_server_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_server_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.write_date IS 'Last Updated on';


--
-- Name: ir_actions_server_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_server_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_server_history_id_seq OWNER TO runbot;

--
-- Name: ir_actions_server_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_server_history_id_seq OWNED BY public.ir_actions_server_history.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    "json_value" character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default."json_value"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default."json_value" IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
            (action_id IS NOT NULL AND python_method IS NULL)
            OR (action_id IS NULL AND python_method IS NOT NULL)
        )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(NOT (python_method IS NOT NULL AND name IS NULL))';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL))';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_filters_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters_res_users_rel (
    ir_filters_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.ir_filters_res_users_rel OWNER TO runbot;

--
-- Name: TABLE ir_filters_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters_res_users_rel IS 'RELATION BETWEEN ir_filters AND res_users';


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    owner_user_id integer,
    owner_limit_count integer,
    owner_limit_time timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    microsoft_outlook_access_token_expiration integer,
    microsoft_outlook_refresh_token character varying,
    microsoft_outlook_access_token character varying,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.owner_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_user_id IS 'Owner';


--
-- Name: COLUMN ir_mail_server.owner_limit_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_limit_count IS 'Owner Limit Count';


--
-- Name: COLUMN ir_mail_server.owner_limit_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_limit_time IS 'Owner Limit Time';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_access_token_expiration IS 'Outlook Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_refresh_token IS 'Outlook Refresh Token';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_access_token IS 'Outlook Access Token';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    fold_name character varying,
    name jsonb NOT NULL,
    info text,
    abstract boolean,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.fold_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.fold_name IS 'Fold Field';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.abstract; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.abstract IS 'Abstract Model';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Has Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Has Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Has Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Last Updated on';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    translate character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    tracking integer,
    ai_domain character varying,
    system_prompt text,
    ai boolean,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: COLUMN ir_model_fields.ai_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ai_domain IS 'AI field domain';


--
-- Name: COLUMN ir_model_fields.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.system_prompt IS 'AI Prompt';


--
-- Name: COLUMN ir_model_fields.ai; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ai IS 'AI field';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    others text,
    qweb text,
    duration numeric,
    cpu_duration numeric,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.others; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.others IS 'others';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: COLUMN ir_profile.cpu_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.cpu_duration IS 'CPU Duration';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    customize_show boolean,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_ui_view.customize_show; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.customize_show IS 'Show As Optional Inherit';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer,
    res_id integer,
    activity_type_id integer,
    user_id integer,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    res_name character varying,
    summary character varying,
    user_tz character varying,
    date_deadline date NOT NULL,
    date_done date,
    note text,
    feedback text,
    automated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    calendar_event_id integer,
    CONSTRAINT mail_activity_check_res_id_is_set_if_model CHECK (((((COALESCE(res_model, ''::character varying))::text <> ''::text) AND ((res_id IS NOT NULL) AND (res_id <> 0))) OR (((COALESCE(res_model, ''::character varying))::text = ''::text) AND ((res_id IS NULL) OR (res_id = 0))))),
    CONSTRAINT mail_activity_check_user_id_is_set_if_model CHECK ((((COALESCE(res_model, ''::character varying))::text <> ''::text) OR (user_id IS NOT NULL)))
);


ALTER TABLE public.mail_activity OWNER TO runbot;

--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.user_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_tz IS 'Timezone';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_done IS 'Done Date';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.feedback IS 'Feedback';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.active IS 'Active';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_activity.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.calendar_event_id IS 'Calendar Meeting';


--
-- Name: CONSTRAINT mail_activity_check_res_id_is_set_if_model ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_res_id_is_set_if_model ON public.mail_activity IS 'CHECK(
            (COALESCE(res_model, '''') <> '''' AND (res_id IS NOT NULL AND res_id != 0)) OR
            (COALESCE(res_model, '''') = '''' AND (res_id IS NULL OR res_id = 0))
        )';


--
-- Name: CONSTRAINT mail_activity_check_user_id_is_set_if_model ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_user_id_is_set_if_model ON public.mail_activity IS 'CHECK(
            (COALESCE(res_model, '''') <> '''' OR user_id IS NOT NULL)
        )';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_id_seq OWNER TO runbot;

--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan (
    id integer NOT NULL,
    company_id integer,
    res_model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    department_id integer
);


ALTER TABLE public.mail_activity_plan OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan IS 'Activity Plan';


--
-- Name: COLUMN mail_activity_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.company_id IS 'Company';


--
-- Name: COLUMN mail_activity_plan.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.name IS 'Name';


--
-- Name: COLUMN mail_activity_plan.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.active IS 'Active';


--
-- Name: COLUMN mail_activity_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_activity_plan.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.department_id IS 'Department';


--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_id_seq OWNED BY public.mail_activity_plan.id;


--
-- Name: mail_activity_plan_mail_activity_schedule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_mail_activity_schedule_rel (
    mail_activity_schedule_id integer NOT NULL,
    mail_activity_plan_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_mail_activity_schedule_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_mail_activity_schedule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_mail_activity_schedule_rel IS 'RELATION BETWEEN mail_activity_schedule AND mail_activity_plan';


--
-- Name: mail_activity_plan_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    sequence integer,
    activity_type_id integer NOT NULL,
    delay_count integer,
    responsible_id integer,
    create_uid integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    summary character varying,
    responsible_type character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan_template OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template IS 'Activity plan template';


--
-- Name: COLUMN mail_activity_plan_template.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_plan_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_plan_template.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_plan_template.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_count IS 'Interval';


--
-- Name: COLUMN mail_activity_plan_template.responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_plan_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan_template.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_plan_template.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_from IS 'Trigger';


--
-- Name: COLUMN mail_activity_plan_template.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_plan_template.responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_type IS 'Assignment';


--
-- Name: COLUMN mail_activity_plan_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.note IS 'Note';


--
-- Name: COLUMN mail_activity_plan_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNED BY public.mail_activity_plan_template.id;


--
-- Name: mail_activity_plan_template_mail_activity_type_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template_mail_activity_type_rel (
    mail_activity_plan_template_id integer NOT NULL,
    mail_activity_type_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_template_mail_activity_type_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template_mail_activity_type_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template_mail_activity_type_rel IS 'RELATION BETWEEN mail_activity_plan_template AND mail_activity_type';


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


ALTER TABLE public.mail_activity_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule (
    id integer NOT NULL,
    res_model_id integer,
    plan_id integer,
    plan_on_demand_user_id integer,
    activity_type_id integer,
    activity_user_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    summary character varying,
    plan_date date,
    date_deadline date,
    res_ids text,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule IS 'Activity schedule plan Wizard';


--
-- Name: COLUMN mail_activity_schedule.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_schedule.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_schedule.plan_on_demand_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_on_demand_user_id IS 'Assigned To';


--
-- Name: COLUMN mail_activity_schedule.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_schedule.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_schedule.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_schedule.plan_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_date IS 'Plan Date';


--
-- Name: COLUMN mail_activity_schedule.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity_schedule.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_ids IS 'Document IDs';


--
-- Name: COLUMN mail_activity_schedule.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.note IS 'Note';


--
-- Name: COLUMN mail_activity_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNED BY public.mail_activity_schedule.id;


--
-- Name: mail_activity_schedule_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule_line (
    id integer NOT NULL,
    activity_schedule_id integer NOT NULL,
    responsible_user_id integer,
    create_uid integer,
    write_uid integer,
    line_description character varying,
    line_date_deadline date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule_line OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule_line IS 'Mail Activity Schedule Line';


--
-- Name: COLUMN mail_activity_schedule_line.activity_schedule_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.activity_schedule_id IS 'Activity Schedule';


--
-- Name: COLUMN mail_activity_schedule_line.responsible_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.responsible_user_id IS 'Responsible User';


--
-- Name: COLUMN mail_activity_schedule_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule_line.line_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.line_description IS 'Line Description';


--
-- Name: COLUMN mail_activity_schedule_line.line_date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.line_date_deadline IS 'Date Deadline';


--
-- Name: COLUMN mail_activity_schedule_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_line_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_line_id_seq OWNED BY public.mail_activity_schedule_line.id;


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    delay_count integer,
    triggered_next_type_id integer,
    default_user_id integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model character varying,
    chaining_type character varying NOT NULL,
    category character varying,
    name jsonb NOT NULL,
    summary jsonb,
    default_note jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_type OWNER TO runbot;

--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Schedule';


--
-- Name: COLUMN mail_activity_type.triggered_next_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.triggered_next_type_id IS 'Trigger';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_type.chaining_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.chaining_type IS 'Chaining Type';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.default_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_note IS 'Default Note';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_type_id_seq OWNER TO runbot;

--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_activity_type_mail_template_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_domain_id integer,
    alias_model_id integer NOT NULL,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    create_uid integer,
    write_uid integer,
    alias_name character varying,
    alias_full_name character varying,
    alias_contact character varying NOT NULL,
    alias_status character varying,
    alias_bounced_content jsonb,
    alias_defaults text NOT NULL,
    alias_incoming_local boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias OWNER TO runbot;

--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_full_name IS 'Alias Email';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_status IS 'Alias Status';


--
-- Name: COLUMN mail_alias.alias_bounced_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_bounced_content IS 'Custom Bounced Message';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_incoming_local; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_incoming_local IS 'Local-part based incoming detection';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias_domain (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bounce_alias character varying NOT NULL,
    catchall_alias character varying NOT NULL,
    default_from character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias_domain OWNER TO runbot;

--
-- Name: TABLE mail_alias_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias_domain IS 'Email Domain';


--
-- Name: COLUMN mail_alias_domain.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.sequence IS 'Sequence';


--
-- Name: COLUMN mail_alias_domain.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias_domain.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias_domain.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.name IS 'Name';


--
-- Name: COLUMN mail_alias_domain.bounce_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.bounce_alias IS 'Bounce Alias';


--
-- Name: COLUMN mail_alias_domain.catchall_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.catchall_alias IS 'Catchall Alias';


--
-- Name: COLUMN mail_alias_domain.default_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.default_from IS 'Default From Alias';


--
-- Name: COLUMN mail_alias_domain.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias_domain.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_domain_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_domain_id_seq OWNER TO runbot;

--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_domain_id_seq OWNED BY public.mail_alias_domain.id;


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_id_seq OWNER TO runbot;

--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist OWNER TO runbot;

--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE mail_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist_remove IS 'Remove email from blacklist wizard';


--
-- Name: COLUMN mail_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist_remove.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.email IS 'Email';


--
-- Name: COLUMN mail_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN mail_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNED BY public.mail_blacklist_remove.id;


--
-- Name: mail_canned_response; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source character varying NOT NULL,
    substitution text NOT NULL,
    is_shared boolean,
    last_used timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_canned_response OWNER TO runbot;

--
-- Name: TABLE mail_canned_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response IS 'Canned Response';


--
-- Name: COLUMN mail_canned_response.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_uid IS 'Created by';


--
-- Name: COLUMN mail_canned_response.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_canned_response.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.source IS 'Shortcut';


--
-- Name: COLUMN mail_canned_response.substitution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.substitution IS 'Substitution';


--
-- Name: COLUMN mail_canned_response.is_shared; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.is_shared IS 'Determines if the canned_response is currently shared with other users';


--
-- Name: COLUMN mail_canned_response.last_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.last_used IS 'Last Used';


--
-- Name: COLUMN mail_canned_response.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_date IS 'Created on';


--
-- Name: COLUMN mail_canned_response.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_date IS 'Last Updated on';


--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_canned_response_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_canned_response_id_seq OWNER TO runbot;

--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_canned_response_id_seq OWNED BY public.mail_canned_response.id;


--
-- Name: mail_canned_response_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response_res_groups_rel (
    mail_canned_response_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.mail_canned_response_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE mail_canned_response_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response_res_groups_rel IS 'RELATION BETWEEN mail_canned_response AND res_groups';


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    template_id integer,
    parent_id integer,
    author_id integer,
    res_domain_user_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    email_layout_xmlid character varying,
    email_from character varying,
    composition_mode character varying,
    composition_comment_option character varying,
    model character varying,
    message_type character varying NOT NULL,
    reply_to character varying,
    scheduled_date character varying,
    template_name character varying,
    body text,
    res_ids text,
    res_domain text,
    email_add_signature boolean,
    reply_to_force_new boolean,
    auto_delete boolean,
    auto_delete_keep_log boolean,
    force_send boolean,
    notify_author boolean,
    notify_author_mention boolean,
    notify_skip_followers boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_compose_message OWNER TO runbot;

--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.res_domain_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain_user_id IS 'Responsible';


--
-- Name: COLUMN mail_compose_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_compose_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.lang IS 'Language';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.composition_comment_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_comment_option IS 'Comment Options';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_compose_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_compose_message.template_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_name IS 'Template Name';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_compose_message.res_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_add_signature IS 'Add signature';


--
-- Name: COLUMN mail_compose_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to_force_new IS 'Considers answers as new thread';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_keep_log IS 'Keep Message Copy';


--
-- Name: COLUMN mail_compose_message.force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.force_send IS 'Send mailing or notifications directly';


--
-- Name: COLUMN mail_compose_message.notify_author; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_author IS 'Notify Author';


--
-- Name: COLUMN mail_compose_message.notify_author_mention; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_author_mention IS 'Notify Author Mention';


--
-- Name: COLUMN mail_compose_message.notify_skip_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_skip_followers IS 'Notify Skip Followers';


--
-- Name: COLUMN mail_compose_message.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.use_exclusion_list IS 'Use Exclusion List';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_compose_message_id_seq OWNER TO runbot;

--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_id integer,
    partner_id integer NOT NULL,
    res_model character varying NOT NULL
);


ALTER TABLE public.mail_followers OWNER TO runbot;

--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: mail_followers_edit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_edit (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    res_ids character varying,
    operation character varying NOT NULL,
    message text,
    notify boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_followers_edit OWNER TO runbot;

--
-- Name: TABLE mail_followers_edit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_edit IS 'Followers edit wizard';


--
-- Name: COLUMN mail_followers_edit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.create_uid IS 'Created by';


--
-- Name: COLUMN mail_followers_edit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_followers_edit.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_followers_edit.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_followers_edit.operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.operation IS 'Operation';


--
-- Name: COLUMN mail_followers_edit.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.message IS 'Message';


--
-- Name: COLUMN mail_followers_edit.notify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.notify IS 'Notify Recipients';


--
-- Name: COLUMN mail_followers_edit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.create_date IS 'Created on';


--
-- Name: COLUMN mail_followers_edit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.write_date IS 'Last Updated on';


--
-- Name: mail_followers_edit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_edit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_edit_id_seq OWNER TO runbot;

--
-- Name: mail_followers_edit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_edit_id_seq OWNED BY public.mail_followers_edit.id;


--
-- Name: mail_followers_edit_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_edit_res_partner_rel (
    mail_followers_edit_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_followers_edit_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_edit_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_edit_res_partner_rel IS 'RELATION BETWEEN mail_followers_edit AND res_partner';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_id_seq OWNER TO runbot;

--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_followers_mail_message_subtype_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_gateway_allowed; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_gateway_allowed (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    email_normalized character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_gateway_allowed OWNER TO runbot;

--
-- Name: TABLE mail_gateway_allowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_gateway_allowed IS 'Mail Gateway Allowed';


--
-- Name: COLUMN mail_gateway_allowed.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_uid IS 'Created by';


--
-- Name: COLUMN mail_gateway_allowed.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_gateway_allowed.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email IS 'Email Address';


--
-- Name: COLUMN mail_gateway_allowed.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN mail_gateway_allowed.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_date IS 'Created on';


--
-- Name: COLUMN mail_gateway_allowed.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_date IS 'Last Updated on';


--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_gateway_allowed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNER TO runbot;

--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNED BY public.mail_gateway_allowed.id;


--
-- Name: mail_guest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_guest (
    id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    access_token character varying NOT NULL,
    email character varying,
    lang character varying,
    timezone character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_guest OWNER TO runbot;

--
-- Name: TABLE mail_guest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_guest IS 'Guest';


--
-- Name: COLUMN mail_guest.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.country_id IS 'Country';


--
-- Name: COLUMN mail_guest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_uid IS 'Created by';


--
-- Name: COLUMN mail_guest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_guest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.name IS 'Name';


--
-- Name: COLUMN mail_guest.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.access_token IS 'Access Token';


--
-- Name: COLUMN mail_guest.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.email IS 'Email';


--
-- Name: COLUMN mail_guest.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.lang IS 'Language';


--
-- Name: COLUMN mail_guest.timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.timezone IS 'Timezone';


--
-- Name: COLUMN mail_guest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_date IS 'Created on';


--
-- Name: COLUMN mail_guest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_date IS 'Last Updated on';


--
-- Name: mail_guest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_guest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_guest_id_seq OWNER TO runbot;

--
-- Name: mail_guest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_guest_id_seq OWNED BY public.mail_guest.id;


--
-- Name: mail_ice_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_ice_server (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_type character varying NOT NULL,
    uri character varying NOT NULL,
    username character varying,
    credential character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_ice_server OWNER TO runbot;

--
-- Name: TABLE mail_ice_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_ice_server IS 'ICE Server';


--
-- Name: COLUMN mail_ice_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_uid IS 'Created by';


--
-- Name: COLUMN mail_ice_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_ice_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.server_type IS 'Type';


--
-- Name: COLUMN mail_ice_server.uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.uri IS 'URI';


--
-- Name: COLUMN mail_ice_server.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.username IS 'Username';


--
-- Name: COLUMN mail_ice_server.credential; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.credential IS 'Credential';


--
-- Name: COLUMN mail_ice_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_date IS 'Created on';


--
-- Name: COLUMN mail_ice_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_date IS 'Last Updated on';


--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_ice_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_ice_server_id_seq OWNER TO runbot;

--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_ice_server_id_seq OWNED BY public.mail_ice_server.id;


--
-- Name: mail_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_link_preview (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_url character varying NOT NULL,
    og_type character varying,
    og_title character varying,
    og_site_name character varying,
    og_image character varying,
    og_mimetype character varying,
    image_mimetype character varying,
    og_description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_link_preview IS 'Store link preview data';


--
-- Name: COLUMN mail_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_link_preview.source_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.source_url IS 'URL';


--
-- Name: COLUMN mail_link_preview.og_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_type IS 'Type';


--
-- Name: COLUMN mail_link_preview.og_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_title IS 'Title';


--
-- Name: COLUMN mail_link_preview.og_site_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_site_name IS 'Site name';


--
-- Name: COLUMN mail_link_preview.og_image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_image IS 'Image';


--
-- Name: COLUMN mail_link_preview.og_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_mimetype IS 'MIME type';


--
-- Name: COLUMN mail_link_preview.image_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.image_mimetype IS 'Image MIME type';


--
-- Name: COLUMN mail_link_preview.og_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_description IS 'Description';


--
-- Name: COLUMN mail_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_date IS 'Create Date';


--
-- Name: COLUMN mail_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_link_preview_id_seq OWNED BY public.mail_link_preview.id;


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    fetchmail_server_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    state character varying,
    failure_type character varying,
    body_html text,
    "references" text,
    headers text,
    email_to text,
    failure_reason text,
    is_notification boolean,
    auto_delete boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_mail OWNER TO runbot;

--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.is_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.is_notification IS 'Notification Email';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_mail_id_seq OWNER TO runbot;

--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_mail_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    incoming_email_cc character varying,
    outgoing_email_to character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    incoming_email_to text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    pinned_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.incoming_email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_cc IS 'Emails Cc';


--
-- Name: COLUMN mail_message.outgoing_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.outgoing_email_to IS 'emails To';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.incoming_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_to IS 'Emails To';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.pinned_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.pinned_at IS 'Pinned';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_id_seq OWNER TO runbot;

--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_link_preview (
    id integer NOT NULL,
    message_id integer NOT NULL,
    link_preview_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    is_hidden boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_message_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_link_preview IS 'Link between link previews and messages';


--
-- Name: COLUMN mail_message_link_preview.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.message_id IS 'Message';


--
-- Name: COLUMN mail_message_link_preview.link_preview_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.link_preview_id IS 'Link Preview';


--
-- Name: COLUMN mail_message_link_preview.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_link_preview.is_hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.is_hidden IS 'Is Hidden';


--
-- Name: COLUMN mail_message_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_message_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_message_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_link_preview_id_seq OWNED BY public.mail_message_link_preview.id;


--
-- Name: mail_message_reaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_reaction (
    id integer NOT NULL,
    message_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    content character varying NOT NULL,
    CONSTRAINT mail_message_reaction_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_message_reaction OWNER TO runbot;

--
-- Name: TABLE mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_reaction IS 'Message Reaction';


--
-- Name: COLUMN mail_message_reaction.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.message_id IS 'Message';


--
-- Name: COLUMN mail_message_reaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.partner_id IS 'Reacting Partner';


--
-- Name: COLUMN mail_message_reaction.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.guest_id IS 'Reacting Guest';


--
-- Name: COLUMN mail_message_reaction.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.content IS 'Content';


--
-- Name: CONSTRAINT mail_message_reaction_partner_or_guest_exists ON mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_message_reaction_partner_or_guest_exists ON public.mail_message_reaction IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_reaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_reaction_id_seq OWNER TO runbot;

--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_reaction_id_seq OWNED BY public.mail_message_reaction.id;


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_starred_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_schedule (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    notification_parameters text,
    scheduled_datetime timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_schedule OWNER TO runbot;

--
-- Name: TABLE mail_message_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_schedule IS 'Scheduled Messages';


--
-- Name: COLUMN mail_message_schedule.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_message_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_schedule.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.notification_parameters IS 'Notification Parameter';


--
-- Name: COLUMN mail_message_schedule.scheduled_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.scheduled_datetime IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_message_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_schedule_id_seq OWNED BY public.mail_message_schedule.id;


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    parent_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    relation_field character varying,
    res_model character varying,
    name jsonb NOT NULL,
    description jsonb,
    internal boolean,
    "default" boolean,
    hidden boolean,
    track_recipients boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_subtype OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.track_recipients; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.track_recipients IS 'Track Recipients';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_subtype_id_seq OWNER TO runbot;

--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_message_translation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_translation (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_lang character varying NOT NULL,
    target_lang character varying NOT NULL,
    body text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_translation OWNER TO runbot;

--
-- Name: TABLE mail_message_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_translation IS 'Message Translation';


--
-- Name: COLUMN mail_message_translation.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.message_id IS 'Message';


--
-- Name: COLUMN mail_message_translation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_translation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_translation.source_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.source_lang IS 'Source Language';


--
-- Name: COLUMN mail_message_translation.target_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.target_lang IS 'Target Language';


--
-- Name: COLUMN mail_message_translation.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.body IS 'Translation Body';


--
-- Name: COLUMN mail_message_translation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_date IS 'Create Date';


--
-- Name: COLUMN mail_message_translation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_date IS 'Last Updated on';


--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_translation_id_seq OWNER TO runbot;

--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_translation_id_seq OWNED BY public.mail_message_translation.id;


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification (
    id integer NOT NULL,
    author_id integer,
    mail_message_id integer NOT NULL,
    mail_mail_id integer,
    res_partner_id integer,
    mail_email_address character varying,
    notification_type character varying NOT NULL,
    notification_status character varying,
    failure_type character varying,
    failure_reason text,
    is_read boolean,
    read_date timestamp without time zone,
    sms_id_int integer,
    sms_number character varying,
    letter_id integer,
    CONSTRAINT mail_notification_notification_partner_or_email_required CHECK ((((notification_type)::text <> 'email'::text) OR (failure_type IS NOT NULL) OR (res_partner_id IS NOT NULL) OR ((COALESCE(mail_email_address, ''::character varying))::text <> ''::text))),
    CONSTRAINT mail_notification_notification_partner_required CHECK ((((notification_type)::text <> 'inbox'::text) OR (res_partner_id IS NOT NULL)))
);


ALTER TABLE public.mail_notification OWNER TO runbot;

--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification IS 'Message Notifications';


--
-- Name: COLUMN mail_notification.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.author_id IS 'Author';


--
-- Name: COLUMN mail_notification.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_notification.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mail_notification.res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.res_partner_id IS 'Recipient';


--
-- Name: COLUMN mail_notification.mail_email_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_email_address IS 'Mail Email Address';


--
-- Name: COLUMN mail_notification.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_notification.notification_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_status IS 'Status';


--
-- Name: COLUMN mail_notification.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_notification.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.is_read IS 'Is Read';


--
-- Name: COLUMN mail_notification.read_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.read_date IS 'Read Date';


--
-- Name: COLUMN mail_notification.sms_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_id_int IS 'SMS ID';


--
-- Name: COLUMN mail_notification.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_number IS 'SMS Number';


--
-- Name: COLUMN mail_notification.letter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.letter_id IS 'Snailmail Letter';


--
-- Name: CONSTRAINT mail_notification_notification_partner_or_email_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_or_email_required ON public.mail_notification IS 'CHECK(notification_type != ''email'' OR failure_type IS NOT NULL OR res_partner_id IS NOT NULL OR COALESCE(mail_email_address, '''') != '''')';


--
-- Name: CONSTRAINT mail_notification_notification_partner_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_required ON public.mail_notification IS 'CHECK(notification_type != ''inbox'' OR res_partner_id IS NOT NULL)';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_notification_id_seq OWNER TO runbot;

--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_notification_id_seq OWNED BY public.mail_notification.id;


--
-- Name: mail_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_presence (
    id integer NOT NULL,
    user_id integer,
    guest_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    CONSTRAINT mail_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_presence OWNER TO runbot;

--
-- Name: TABLE mail_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_presence IS 'User/Guest Presence';


--
-- Name: COLUMN mail_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.user_id IS 'Users';


--
-- Name: COLUMN mail_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.guest_id IS 'Guest';


--
-- Name: COLUMN mail_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.status IS 'IM Status';


--
-- Name: COLUMN mail_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN mail_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.last_presence IS 'Last Presence';


--
-- Name: CONSTRAINT mail_presence_partner_or_guest_exists ON mail_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_presence_partner_or_guest_exists ON public.mail_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_presence_id_seq OWNER TO runbot;

--
-- Name: mail_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_presence_id_seq OWNED BY public.mail_presence.id;


--
-- Name: mail_push; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push (
    id integer NOT NULL,
    mail_push_device_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payload text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push OWNER TO runbot;

--
-- Name: TABLE mail_push; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push IS 'Push Notifications';


--
-- Name: COLUMN mail_push.mail_push_device_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.mail_push_device_id IS 'devices';


--
-- Name: COLUMN mail_push.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push.payload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.payload IS 'Payload';


--
-- Name: COLUMN mail_push.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_date IS 'Created on';


--
-- Name: COLUMN mail_push.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_date IS 'Last Updated on';


--
-- Name: mail_push_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push_device (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    endpoint character varying NOT NULL,
    keys character varying NOT NULL,
    expiration_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push_device OWNER TO runbot;

--
-- Name: TABLE mail_push_device; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push_device IS 'Push Notification Device';


--
-- Name: COLUMN mail_push_device.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.partner_id IS 'Partner';


--
-- Name: COLUMN mail_push_device.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push_device.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push_device.endpoint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.endpoint IS 'Browser endpoint';


--
-- Name: COLUMN mail_push_device.keys; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.keys IS 'Browser keys';


--
-- Name: COLUMN mail_push_device.expiration_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.expiration_time IS 'Expiration Token Date';


--
-- Name: COLUMN mail_push_device.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_date IS 'Created on';


--
-- Name: COLUMN mail_push_device.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_date IS 'Last Updated on';


--
-- Name: mail_push_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_device_id_seq OWNER TO runbot;

--
-- Name: mail_push_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_device_id_seq OWNED BY public.mail_push_device.id;


--
-- Name: mail_push_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_id_seq OWNER TO runbot;

--
-- Name: mail_push_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_id_seq OWNED BY public.mail_push.id;


--
-- Name: mail_scheduled_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message (
    id integer NOT NULL,
    res_id integer NOT NULL,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subject character varying,
    composition_comment_option character varying,
    model character varying NOT NULL,
    send_context jsonb,
    body text,
    notification_parameters text,
    is_note boolean,
    scheduled_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_scheduled_message OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message IS 'Scheduled Message';


--
-- Name: COLUMN mail_scheduled_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.res_id IS 'Related Document Id';


--
-- Name: COLUMN mail_scheduled_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.author_id IS 'Author';


--
-- Name: COLUMN mail_scheduled_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_scheduled_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_scheduled_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.subject IS 'Subject';


--
-- Name: COLUMN mail_scheduled_message.composition_comment_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.composition_comment_option IS 'Comment Options';


--
-- Name: COLUMN mail_scheduled_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_scheduled_message.send_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.send_context IS 'Sending Context';


--
-- Name: COLUMN mail_scheduled_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.body IS 'Contents';


--
-- Name: COLUMN mail_scheduled_message.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.notification_parameters IS 'Notification parameters';


--
-- Name: COLUMN mail_scheduled_message.is_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.is_note IS 'Is a note';


--
-- Name: COLUMN mail_scheduled_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_scheduled_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_scheduled_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_date IS 'Last Updated on';


--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_scheduled_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNER TO runbot;

--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNED BY public.mail_scheduled_message.id;


--
-- Name: mail_scheduled_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message_res_partner_rel (
    mail_scheduled_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_scheduled_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message_res_partner_rel IS 'RELATION BETWEEN mail_scheduled_message AND res_partner';


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    model_id integer,
    user_id integer,
    mail_server_id integer,
    ref_ir_act_window integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    email_from character varying,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    scheduled_date character varying,
    name jsonb,
    description jsonb,
    subject jsonb,
    body_html jsonb,
    active boolean,
    use_default_to boolean,
    auto_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template OWNER TO runbot;

--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.user_id IS 'Owner';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_from IS 'Send From';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_template.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.description IS 'Template Description';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.active IS 'Active';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default Recipients';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_id_seq OWNER TO runbot;

--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_template_ir_actions_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_ir_actions_report_rel (
    mail_template_id integer NOT NULL,
    ir_actions_report_id integer NOT NULL
);


ALTER TABLE public.mail_template_ir_actions_report_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_ir_actions_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_ir_actions_report_rel IS 'RELATION BETWEEN mail_template AND ir_act_report_xml';


--
-- Name: mail_template_mail_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_mail_template_reset_rel (
    mail_template_reset_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_template_mail_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_mail_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_mail_template_reset_rel IS 'RELATION BETWEEN mail_template_reset AND mail_template';


--
-- Name: mail_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_preview (
    id integer NOT NULL,
    mail_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    lang character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_preview OWNER TO runbot;

--
-- Name: TABLE mail_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN mail_template_preview.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.mail_template_id IS 'Related Mail Template';


--
-- Name: COLUMN mail_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.resource_ref IS 'Record';


--
-- Name: COLUMN mail_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN mail_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_date IS 'Last Updated on';


--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_preview_id_seq OWNER TO runbot;

--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_preview_id_seq OWNED BY public.mail_template_preview.id;


--
-- Name: mail_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_reset OWNER TO runbot;

--
-- Name: TABLE mail_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_reset IS 'Mail Template Reset';


--
-- Name: COLUMN mail_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_date IS 'Last Updated on';


--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_reset_id_seq OWNER TO runbot;

--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_reset_id_seq OWNED BY public.mail_template_reset.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field_id integer,
    old_value_integer integer,
    new_value_integer integer,
    currency_id integer,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    old_value_char character varying,
    new_value_char character varying,
    field_info jsonb,
    old_value_text text,
    new_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    old_value_float double precision,
    new_value_float double precision
);


ALTER TABLE public.mail_tracking_value OWNER TO runbot;

--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_id IS 'Field';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.currency_id IS 'Currency';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.field_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_info IS 'Removed field information';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_tracking_value_id_seq OWNER TO runbot;

--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: meeting_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.meeting_category_rel (
    event_id integer NOT NULL,
    type_id integer NOT NULL
);


ALTER TABLE public.meeting_category_rel OWNER TO runbot;

--
-- Name: TABLE meeting_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.meeting_category_rel IS 'RELATION BETWEEN calendar_event AND calendar_event_type';


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: orm_signaling_assets; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_assets (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_assets OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_assets_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNED BY public.orm_signaling_assets.id;


--
-- Name: orm_signaling_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_default (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_default OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_default_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_default_id_seq OWNED BY public.orm_signaling_default.id;


--
-- Name: orm_signaling_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_groups (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_groups OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNED BY public.orm_signaling_groups.id;


--
-- Name: orm_signaling_registry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_registry (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_registry OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_registry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNED BY public.orm_signaling_registry.id;


--
-- Name: orm_signaling_routing; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_routing (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_routing OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_routing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNED BY public.orm_signaling_routing.id;


--
-- Name: orm_signaling_stable; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_stable (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_stable OWNER TO runbot;

--
-- Name: orm_signaling_stable_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_stable_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_stable_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_stable_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_stable_id_seq OWNED BY public.orm_signaling_stable.id;


--
-- Name: orm_signaling_templates; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_templates (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_templates OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_templates_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNED BY public.orm_signaling_templates.id;


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    number character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist OWNER TO runbot;

--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: phone_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE phone_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist_remove IS 'Remove phone from blacklist';


--
-- Name: COLUMN phone_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist_remove.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.phone IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN phone_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNED BY public.phone_blacklist_remove.id;


--
-- Name: portal_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share (
    id integer NOT NULL,
    res_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_share OWNER TO runbot;

--
-- Name: TABLE portal_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share IS 'Portal Sharing';


--
-- Name: COLUMN portal_share.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_id IS 'Related Document ID';


--
-- Name: COLUMN portal_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_uid IS 'Created by';


--
-- Name: COLUMN portal_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_share.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_model IS 'Related Document Model';


--
-- Name: COLUMN portal_share.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.note IS 'Note';


--
-- Name: COLUMN portal_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_date IS 'Created on';


--
-- Name: COLUMN portal_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_date IS 'Last Updated on';


--
-- Name: portal_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_share_id_seq OWNER TO runbot;

--
-- Name: portal_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_share_id_seq OWNED BY public.portal_share.id;


--
-- Name: portal_share_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share_res_partner_rel (
    portal_share_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_share_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_share_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share_res_partner_rel IS 'RELATION BETWEEN portal_share AND res_partner';


--
-- Name: portal_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    welcome_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard OWNER TO runbot;

--
-- Name: TABLE portal_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard IS 'Grant Portal Access';


--
-- Name: COLUMN portal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard.welcome_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.welcome_message IS 'Invitation Message';


--
-- Name: COLUMN portal_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_id_seq OWNED BY public.portal_wizard.id;


--
-- Name: portal_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_res_partner_rel (
    portal_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_res_partner_rel IS 'RELATION BETWEEN portal_wizard AND res_partner';


--
-- Name: portal_wizard_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard_user OWNER TO runbot;

--
-- Name: TABLE portal_wizard_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_user IS 'Portal User Config';


--
-- Name: COLUMN portal_wizard_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN portal_wizard_user.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.partner_id IS 'Contact';


--
-- Name: COLUMN portal_wizard_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard_user.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.email IS 'Email';


--
-- Name: COLUMN portal_wizard_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_user_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_user_id_seq OWNED BY public.portal_wizard_user.id;


--
-- Name: privacy_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    anonymized_name character varying NOT NULL,
    anonymized_email character varying NOT NULL,
    execution_details text,
    records_description text,
    additional_note text,
    date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_log OWNER TO runbot;

--
-- Name: TABLE privacy_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_log IS 'Privacy Log';


--
-- Name: COLUMN privacy_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.user_id IS 'Handled By';


--
-- Name: COLUMN privacy_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_log.anonymized_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_name IS 'Anonymized Name';


--
-- Name: COLUMN privacy_log.anonymized_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_email IS 'Anonymized Email';


--
-- Name: COLUMN privacy_log.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_log.records_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.records_description IS 'Found Records';


--
-- Name: COLUMN privacy_log.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.additional_note IS 'Additional Note';


--
-- Name: COLUMN privacy_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.date IS 'Date';


--
-- Name: COLUMN privacy_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_date IS 'Created on';


--
-- Name: COLUMN privacy_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_date IS 'Last Updated on';


--
-- Name: privacy_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_log_id_seq OWNER TO runbot;

--
-- Name: privacy_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_log_id_seq OWNED BY public.privacy_log.id;


--
-- Name: privacy_lookup_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard (
    id integer NOT NULL,
    log_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    email character varying NOT NULL,
    execution_details text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard IS 'Privacy Lookup Wizard';


--
-- Name: COLUMN privacy_lookup_wizard.log_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.log_id IS 'Log';


--
-- Name: COLUMN privacy_lookup_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.name IS 'Name';


--
-- Name: COLUMN privacy_lookup_wizard.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.email IS 'Email';


--
-- Name: COLUMN privacy_lookup_wizard.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNED BY public.privacy_lookup_wizard.id;


--
-- Name: privacy_lookup_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard_line (
    id integer NOT NULL,
    wizard_id integer,
    res_id integer NOT NULL,
    res_model_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    execution_details character varying,
    has_active boolean,
    is_active boolean,
    is_unlinked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard_line OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard_line IS 'Privacy Lookup Wizard Line';


--
-- Name: COLUMN privacy_lookup_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_id IS 'Resource ID';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_name IS 'Resource name';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model IS 'Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard_line.has_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.has_active IS 'Has Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_active IS 'Is Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_unlinked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_unlinked IS 'Is Unlinked';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNED BY public.privacy_lookup_wizard_line.id;


--
-- Name: properties_base_definition; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.properties_base_definition (
    id integer NOT NULL,
    properties_field_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    properties_definition jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.properties_base_definition OWNER TO runbot;

--
-- Name: TABLE properties_base_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.properties_base_definition IS 'Properties Base Definition';


--
-- Name: COLUMN properties_base_definition.properties_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.properties_field_id IS 'Properties Field';


--
-- Name: COLUMN properties_base_definition.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.create_uid IS 'Created by';


--
-- Name: COLUMN properties_base_definition.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.write_uid IS 'Last Updated by';


--
-- Name: COLUMN properties_base_definition.properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.properties_definition IS 'Properties Definition';


--
-- Name: COLUMN properties_base_definition.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.create_date IS 'Created on';


--
-- Name: COLUMN properties_base_definition.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.write_date IS 'Last Updated on';


--
-- Name: properties_base_definition_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.properties_base_definition_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.properties_base_definition_id_seq OWNER TO runbot;

--
-- Name: properties_base_definition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.properties_base_definition_id_seq OWNED BY public.properties_base_definition.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    css_margins boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.css_margins; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.css_margins IS 'Use css margins';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    web_app_name character varying,
    company_id integer NOT NULL,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_sms boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    module_website_cf_turnstile boolean,
    module_google_address_autocomplete boolean,
    group_multi_currency boolean,
    show_effect boolean,
    profiling_enabled_until timestamp without time zone,
    map_box_token character varying,
    twilio_account_sid character varying,
    twilio_account_token character varying,
    sfu_server_url character varying,
    sfu_server_key character varying,
    tenor_api_key character varying,
    google_translate_api_key character varying,
    external_email_server_default boolean,
    module_google_gmail boolean,
    module_microsoft_outlook boolean,
    restrict_template_rendering boolean,
    use_twilio_rtc_servers boolean,
    use_sfu_server boolean,
    unsplash_access_key character varying,
    unsplash_app_id character varying,
    auth_signup_template_user_id integer,
    auth_signup_uninvited character varying,
    auth_signup_reset_password boolean,
    auth_totp_policy character varying,
    auth_totp_enforce boolean,
    google_gmail_client_identifier character varying,
    google_gmail_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    disable_redirect_firebase_dynamic_link boolean,
    enable_ocn boolean,
    digest_id integer,
    digest_emails boolean,
    module_hr_presence boolean,
    module_hr_skills boolean,
    openai_key character varying,
    google_key character varying
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.web_app_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.web_app_name IS 'Web App Name';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'Phone';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_sms IS 'SMS';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.module_website_cf_turnstile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_website_cf_turnstile IS 'Cloudflare Turnstile';


--
-- Name: COLUMN res_config_settings.module_google_address_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_address_autocomplete IS 'Google Address Autocomplete';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.map_box_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.map_box_token IS 'Token Map Box';


--
-- Name: COLUMN res_config_settings.twilio_account_sid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_sid IS 'Account SID';


--
-- Name: COLUMN res_config_settings.twilio_account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_token IS 'Account Auth Token';


--
-- Name: COLUMN res_config_settings.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_url IS 'SFU Server URL';


--
-- Name: COLUMN res_config_settings.sfu_server_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_key IS 'SFU Server key';


--
-- Name: COLUMN res_config_settings.tenor_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.tenor_api_key IS 'Tenor API key';


--
-- Name: COLUMN res_config_settings.google_translate_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_translate_api_key IS 'Message Translation API Key';


--
-- Name: COLUMN res_config_settings.external_email_server_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.external_email_server_default IS 'Use Custom Email Servers';


--
-- Name: COLUMN res_config_settings.module_google_gmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_gmail IS 'Support Gmail Authentication';


--
-- Name: COLUMN res_config_settings.module_microsoft_outlook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_outlook IS 'Support Outlook Authentication';


--
-- Name: COLUMN res_config_settings.restrict_template_rendering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.restrict_template_rendering IS 'Restrict Template Rendering';


--
-- Name: COLUMN res_config_settings.use_twilio_rtc_servers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_twilio_rtc_servers IS 'Use Twilio ICE servers';


--
-- Name: COLUMN res_config_settings.use_sfu_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_sfu_server IS 'Use SFU server';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: COLUMN res_config_settings.auth_signup_template_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_template_user_id IS 'Template user for new users created through signup';


--
-- Name: COLUMN res_config_settings.auth_signup_uninvited; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_uninvited IS 'Customer Account';


--
-- Name: COLUMN res_config_settings.auth_signup_reset_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_reset_password IS 'Enable password reset from Login page';


--
-- Name: COLUMN res_config_settings.auth_totp_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_totp_policy IS 'Two-factor authentication enforcing policy';


--
-- Name: COLUMN res_config_settings.auth_totp_enforce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_totp_enforce IS 'Enforce two-factor authentication';


--
-- Name: COLUMN res_config_settings.google_gmail_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_identifier IS 'Gmail Client Id';


--
-- Name: COLUMN res_config_settings.google_gmail_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_secret IS 'Gmail Client Secret';


--
-- Name: COLUMN res_config_settings.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN res_config_settings.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN res_config_settings.disable_redirect_firebase_dynamic_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.disable_redirect_firebase_dynamic_link IS 'Disable link redirection to mobile app';


--
-- Name: COLUMN res_config_settings.enable_ocn; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.enable_ocn IS 'Push Notifications';


--
-- Name: COLUMN res_config_settings.digest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.digest_id IS 'Digest Email';


--
-- Name: COLUMN res_config_settings.digest_emails; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.digest_emails IS 'Digest Emails';


--
-- Name: COLUMN res_config_settings.module_hr_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_hr_presence IS 'Advanced Presence Control';


--
-- Name: COLUMN res_config_settings.module_hr_skills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_hr_skills IS 'Skills Management';


--
-- Name: COLUMN res_config_settings.openai_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.openai_key IS 'OpenAI API key';


--
-- Name: COLUMN res_config_settings.google_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_key IS 'Google AI API key';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.code IS 'Code';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    iso_numeric integer,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label jsonb,
    currency_subunit_label jsonb,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.iso_numeric; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.iso_numeric IS 'Currency numeric code.';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_device_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_device_log (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    session_identifier character varying NOT NULL,
    platform character varying,
    browser character varying,
    ip_address character varying,
    country character varying,
    city character varying,
    device_type character varying,
    revoked boolean,
    first_activity timestamp without time zone,
    last_activity timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_device_log OWNER TO runbot;

--
-- Name: TABLE res_device_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_device_log IS 'Device Log';


--
-- Name: COLUMN res_device_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.user_id IS 'User';


--
-- Name: COLUMN res_device_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_device_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_device_log.session_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.session_identifier IS 'Session Identifier';


--
-- Name: COLUMN res_device_log.platform; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.platform IS 'Platform';


--
-- Name: COLUMN res_device_log.browser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.browser IS 'Browser';


--
-- Name: COLUMN res_device_log.ip_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.ip_address IS 'IP Address';


--
-- Name: COLUMN res_device_log.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.country IS 'Country';


--
-- Name: COLUMN res_device_log.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.city IS 'City';


--
-- Name: COLUMN res_device_log.device_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.device_type IS 'Device Type';


--
-- Name: COLUMN res_device_log.revoked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.revoked IS 'Revoked';


--
-- Name: COLUMN res_device_log.first_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.first_activity IS 'First Activity';


--
-- Name: COLUMN res_device_log.last_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.last_activity IS 'Last Activity';


--
-- Name: COLUMN res_device_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_date IS 'Created on';


--
-- Name: COLUMN res_device_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_date IS 'Last Updated on';


--
-- Name: res_device; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.res_device AS
 SELECT id,
    user_id,
    create_uid,
    write_uid,
    session_identifier,
    platform,
    browser,
    ip_address,
    country,
    city,
    device_type,
    revoked,
    first_activity,
    last_activity,
    create_date,
    write_date
   FROM public.res_device_log d
  WHERE ((NOT (EXISTS ( SELECT 1
           FROM public.res_device_log d2
          WHERE ((d2.user_id = d.user_id) AND ((d2.session_identifier)::text = (d.session_identifier)::text) AND (NOT ((d2.platform)::text IS DISTINCT FROM (d.platform)::text)) AND (NOT ((d2.browser)::text IS DISTINCT FROM (d.browser)::text)) AND ((d2.last_activity > d.last_activity) OR ((d2.last_activity = d.last_activity) AND (d2.id > d.id))) AND (d2.revoked IS NOT TRUE))))) AND (revoked IS NOT TRUE));


ALTER VIEW public.res_device OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_device_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_device_log_id_seq OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_device_log_id_seq OWNED BY public.res_device_log.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    sequence integer,
    privilege_id integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    api_key_duration double precision,
    CONSTRAINT res_groups_check_api_key_duration CHECK ((api_key_duration >= (0)::double precision))
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.sequence IS 'Sequence';


--
-- Name: COLUMN res_groups.privilege_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.privilege_id IS 'Privilege';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_groups.api_key_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.api_key_duration IS 'API Keys maximum duration days';


--
-- Name: CONSTRAINT res_groups_check_api_key_duration ON res_groups; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_groups_check_api_key_duration ON public.res_groups IS 'CHECK(api_key_duration >= 0)';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_privilege; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_privilege (
    id integer NOT NULL,
    sequence integer,
    category_id integer,
    create_uid integer,
    write_uid integer,
    placeholder character varying,
    name jsonb NOT NULL,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_groups_privilege OWNER TO runbot;

--
-- Name: TABLE res_groups_privilege; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_privilege IS 'Privileges';


--
-- Name: COLUMN res_groups_privilege.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.sequence IS 'Sequence';


--
-- Name: COLUMN res_groups_privilege.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.category_id IS 'Category';


--
-- Name: COLUMN res_groups_privilege.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups_privilege.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups_privilege.placeholder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.placeholder IS 'Placeholder';


--
-- Name: COLUMN res_groups_privilege.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.name IS 'Name';


--
-- Name: COLUMN res_groups_privilege.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.description IS 'Description';


--
-- Name: COLUMN res_groups_privilege.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.create_date IS 'Created on';


--
-- Name: COLUMN res_groups_privilege.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.write_date IS 'Last Updated on';


--
-- Name: res_groups_privilege_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_privilege_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_privilege_id_seq OWNER TO runbot;

--
-- Name: res_groups_privilege_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_privilege_id_seq OWNED BY public.res_groups_privilege.id;


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    commercial_company_name character varying,
    company_name character varying,
    properties jsonb,
    barcode jsonb,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    contact_address_complete character varying,
    message_bounce integer,
    email_normalized character varying,
    signup_type character varying,
    calendar_last_notif_ack timestamp without time zone,
    phone_sanitized character varying,
    ocn_token character varying,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.properties IS 'Properties';


--
-- Name: COLUMN res_partner.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.barcode IS 'Barcode';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner.contact_address_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.contact_address_complete IS 'Contact Address Complete';


--
-- Name: COLUMN res_partner.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.message_bounce IS 'Bounce';


--
-- Name: COLUMN res_partner.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN res_partner.signup_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.signup_type IS 'Signup Token Type';


--
-- Name: COLUMN res_partner.calendar_last_notif_ack; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.calendar_last_notif_ack IS 'Last notification marked as read from base Calendar';


--
-- Name: COLUMN res_partner.phone_sanitized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN res_partner.ocn_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ocn_token IS 'OCN Token';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    clearing_number character varying,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    note text,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.clearing_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.clearing_number IS 'Clearing Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.note IS 'Notes';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_role (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_role OWNER TO runbot;

--
-- Name: TABLE res_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_role IS 'Represents a role in the system used to categorize users. Each role has a unique name and can be associated with multiple users. Roles can be mentioned in messages to notify all associated users.';


--
-- Name: COLUMN res_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.create_uid IS 'Created by';


--
-- Name: COLUMN res_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_role.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.name IS 'Name';


--
-- Name: COLUMN res_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.create_date IS 'Created on';


--
-- Name: COLUMN res_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.write_date IS 'Last Updated on';


--
-- Name: res_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_role_id_seq OWNER TO runbot;

--
-- Name: res_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_role_id_seq OWNED BY public.res_role.id;


--
-- Name: res_role_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_role_res_users_rel (
    res_role_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_role_res_users_rel OWNER TO runbot;

--
-- Name: TABLE res_role_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_role_res_users_rel IS 'RELATION BETWEEN res_role AND res_users';


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_last_counter integer,
    totp_secret character varying,
    tour_enabled boolean,
    notification_type character varying NOT NULL,
    manual_im_status character varying,
    out_of_office_message text,
    out_of_office_from timestamp without time zone,
    out_of_office_to timestamp without time zone,
    odoobot_state character varying,
    odoobot_failed boolean,
    saas_provider_uuid character varying,
    CONSTRAINT res_users_notification_type CHECK ((((notification_type)::text = 'email'::text) OR (NOT share)))
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.totp_last_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.totp_last_counter IS 'Totp Last Counter';


--
-- Name: COLUMN res_users.tour_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.tour_enabled IS 'Onboarding';


--
-- Name: COLUMN res_users.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.notification_type IS 'Notification';


--
-- Name: COLUMN res_users.manual_im_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.manual_im_status IS 'IM status manually set by the user';


--
-- Name: COLUMN res_users.out_of_office_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_message IS 'Vacation Responder';


--
-- Name: COLUMN res_users.out_of_office_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_from IS 'Out Of Office From';


--
-- Name: COLUMN res_users.out_of_office_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_to IS 'Out Of Office To';


--
-- Name: COLUMN res_users.odoobot_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_state IS 'OdooBot Status';


--
-- Name: COLUMN res_users.odoobot_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_failed IS 'Odoobot Failed';


--
-- Name: COLUMN res_users.saas_provider_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.saas_provider_uuid IS 'SaaS Provider UUID';


--
-- Name: CONSTRAINT res_users_notification_type ON res_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_notification_type ON public.res_users IS 'CHECK (notification_type = ''email'' OR NOT share)';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    duration character varying NOT NULL,
    expiration_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.duration IS 'Duration';


--
-- Name: COLUMN res_users_apikeys_description.expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.expiration_date IS 'Expiration Date';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    auth_method character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.auth_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.auth_method IS 'Auth Method';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    color_scheme character varying NOT NULL,
    homemenu_config jsonb,
    voice_active_duration integer,
    push_to_talk_key character varying,
    channel_notifications character varying,
    is_discuss_sidebar_category_channel_open boolean,
    is_discuss_sidebar_category_chat_open boolean,
    use_push_to_talk boolean,
    calendar_default_privacy character varying NOT NULL
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings.color_scheme; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.color_scheme IS 'Color Scheme';


--
-- Name: COLUMN res_users_settings.homemenu_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.homemenu_config IS 'Home Menu Configuration';


--
-- Name: COLUMN res_users_settings.voice_active_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.voice_active_duration IS 'Duration of voice activity in ms';


--
-- Name: COLUMN res_users_settings.push_to_talk_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.push_to_talk_key IS 'Push-To-Talk shortcut';


--
-- Name: COLUMN res_users_settings.channel_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.channel_notifications IS 'Channel Notifications';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_channel_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_channel_open IS 'Is discuss sidebar category channel open?';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_chat_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_chat_open IS 'Is discuss sidebar category chat open?';


--
-- Name: COLUMN res_users_settings.use_push_to_talk; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.use_push_to_talk IS 'Use the push to talk feature';


--
-- Name: COLUMN res_users_settings.calendar_default_privacy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.calendar_default_privacy IS 'Calendar Default Privacy';


--
-- Name: res_users_settings_embedded_action; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_embedded_action (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    action_id integer NOT NULL,
    res_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    embedded_actions_order character varying,
    embedded_actions_visibility character varying,
    embedded_visibility boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_settings_embedded_action OWNER TO runbot;

--
-- Name: TABLE res_users_settings_embedded_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_embedded_action IS 'User Settings for Embedded Actions';


--
-- Name: COLUMN res_users_settings_embedded_action.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_embedded_action.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.action_id IS 'Action';


--
-- Name: COLUMN res_users_settings_embedded_action.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.res_id IS 'Res';


--
-- Name: COLUMN res_users_settings_embedded_action.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_embedded_action.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_embedded_action.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.res_model IS 'Res Model';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_actions_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_actions_order IS 'List order of embedded action ids';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_actions_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_actions_visibility IS 'List visibility of embedded actions ids';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_visibility IS 'Is top bar visible';


--
-- Name: COLUMN res_users_settings_embedded_action.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_embedded_action.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_embedded_action_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_embedded_action_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_embedded_action_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_embedded_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_embedded_action_id_seq OWNED BY public.res_users_settings_embedded_action.id;


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: res_users_settings_volumes; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_volumes (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    volume double precision,
    CONSTRAINT res_users_settings_volumes_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.res_users_settings_volumes OWNER TO runbot;

--
-- Name: TABLE res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_volumes IS 'User Settings Volumes';


--
-- Name: COLUMN res_users_settings_volumes.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_volumes.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.partner_id IS 'Partner';


--
-- Name: COLUMN res_users_settings_volumes.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.guest_id IS 'Guest';


--
-- Name: COLUMN res_users_settings_volumes.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_volumes.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_volumes.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_volumes.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings_volumes.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.volume IS 'Volume';


--
-- Name: CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON public.res_users_settings_volumes IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_volumes_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNED BY public.res_users_settings_volumes.id;


--
-- Name: res_users_web_tour_tour_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_web_tour_tour_rel (
    web_tour_tour_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_web_tour_tour_rel OWNER TO runbot;

--
-- Name: TABLE res_users_web_tour_tour_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_web_tour_tour_rel IS 'RELATION BETWEEN web_tour_tour AND res_users';


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: resource_calendar_attendance; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar_attendance (
    id integer NOT NULL,
    calendar_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    dayofweek character varying NOT NULL,
    day_period character varying NOT NULL,
    week_type character varying,
    display_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    hour_from double precision NOT NULL,
    hour_to double precision NOT NULL,
    duration_hours double precision,
    duration_days double precision
);


ALTER TABLE public.resource_calendar_attendance OWNER TO runbot;

--
-- Name: TABLE resource_calendar_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar_attendance IS 'Work Detail';


--
-- Name: COLUMN resource_calendar_attendance.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.calendar_id IS 'Resource''s Calendar';


--
-- Name: COLUMN resource_calendar_attendance.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.sequence IS 'Sequence';


--
-- Name: COLUMN resource_calendar_attendance.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_attendance.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_attendance.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.name IS 'Name';


--
-- Name: COLUMN resource_calendar_attendance.dayofweek; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.dayofweek IS 'Day of Week';


--
-- Name: COLUMN resource_calendar_attendance.day_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.day_period IS 'Day Period';


--
-- Name: COLUMN resource_calendar_attendance.week_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.week_type IS 'Week Number';


--
-- Name: COLUMN resource_calendar_attendance.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.display_type IS 'Display Type';


--
-- Name: COLUMN resource_calendar_attendance.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_attendance.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar_attendance.hour_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_from IS 'Work from';


--
-- Name: COLUMN resource_calendar_attendance.hour_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.hour_to IS 'Work to';


--
-- Name: COLUMN resource_calendar_attendance.duration_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.duration_hours IS 'Duration (hours)';


--
-- Name: COLUMN resource_calendar_attendance.duration_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_attendance.duration_days IS 'Duration (days)';


--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_attendance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_attendance_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_attendance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_attendance_id_seq OWNED BY public.resource_calendar_attendance.id;


--
-- Name: resource_calendar_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_id_seq OWNED BY public.resource_calendar.id;


--
-- Name: resource_calendar_leaves; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar_leaves (
    id integer NOT NULL,
    company_id integer,
    calendar_id integer,
    resource_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    time_type character varying,
    date_from timestamp without time zone NOT NULL,
    date_to timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    holiday_id integer,
    elligible_for_accrual_rate boolean
);


ALTER TABLE public.resource_calendar_leaves OWNER TO runbot;

--
-- Name: TABLE resource_calendar_leaves; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar_leaves IS 'Resource Time Off Detail';


--
-- Name: COLUMN resource_calendar_leaves.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar_leaves.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.calendar_id IS 'Working Hours';


--
-- Name: COLUMN resource_calendar_leaves.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.resource_id IS 'Resource';


--
-- Name: COLUMN resource_calendar_leaves.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar_leaves.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar_leaves.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.name IS 'Reason';


--
-- Name: COLUMN resource_calendar_leaves.time_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.time_type IS 'Time Type';


--
-- Name: COLUMN resource_calendar_leaves.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_from IS 'Start Date';


--
-- Name: COLUMN resource_calendar_leaves.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.date_to IS 'End Date';


--
-- Name: COLUMN resource_calendar_leaves.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar_leaves.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar_leaves.holiday_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.holiday_id IS 'Time Off Request';


--
-- Name: COLUMN resource_calendar_leaves.elligible_for_accrual_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar_leaves.elligible_for_accrual_rate IS 'Eligible for Accrual Rate';


--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_calendar_leaves_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_calendar_leaves_id_seq OWNER TO runbot;

--
-- Name: resource_calendar_leaves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_calendar_leaves_id_seq OWNED BY public.resource_calendar_leaves.id;


--
-- Name: resource_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.resource_resource_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.resource_resource_id_seq OWNER TO runbot;

--
-- Name: resource_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.resource_resource_id_seq OWNED BY public.resource_resource.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: scheduled_message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.scheduled_message_attachment_rel (
    scheduled_message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.scheduled_message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE scheduled_message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.scheduled_message_attachment_rel IS 'RELATION BETWEEN mail_scheduled_message AND ir_attachment';


--
-- Name: server_action_history_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.server_action_history_wizard (
    id integer NOT NULL,
    action_id integer,
    revision integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.server_action_history_wizard OWNER TO runbot;

--
-- Name: TABLE server_action_history_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.server_action_history_wizard IS 'Server Action History Wizard';


--
-- Name: COLUMN server_action_history_wizard.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.action_id IS 'Action';


--
-- Name: COLUMN server_action_history_wizard.revision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.revision IS 'Revision';


--
-- Name: COLUMN server_action_history_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN server_action_history_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN server_action_history_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.create_date IS 'Created on';


--
-- Name: COLUMN server_action_history_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.write_date IS 'Last Updated on';


--
-- Name: server_action_history_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.server_action_history_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.server_action_history_wizard_id_seq OWNER TO runbot;

--
-- Name: server_action_history_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.server_action_history_wizard_id_seq OWNED BY public.server_action_history_wizard.id;


--
-- Name: sms_account_code; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_code (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    verification_code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_code OWNER TO runbot;

--
-- Name: TABLE sms_account_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_code IS 'SMS Account Verification Code Wizard';


--
-- Name: COLUMN sms_account_code.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.account_id IS 'Account';


--
-- Name: COLUMN sms_account_code.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_code.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_code.verification_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.verification_code IS 'Verification Code';


--
-- Name: COLUMN sms_account_code.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_code.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_date IS 'Last Updated on';


--
-- Name: sms_account_code_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_code_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_code_id_seq OWNER TO runbot;

--
-- Name: sms_account_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_code_id_seq OWNED BY public.sms_account_code.id;


--
-- Name: sms_account_phone; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_phone (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone_number character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_phone OWNER TO runbot;

--
-- Name: TABLE sms_account_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_phone IS 'SMS Account Registration Phone Number Wizard';


--
-- Name: COLUMN sms_account_phone.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.account_id IS 'Account';


--
-- Name: COLUMN sms_account_phone.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_phone.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_phone.phone_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.phone_number IS 'Phone Number';


--
-- Name: COLUMN sms_account_phone.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_phone.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_date IS 'Last Updated on';


--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_phone_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_phone_id_seq OWNER TO runbot;

--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_phone_id_seq OWNED BY public.sms_account_phone.id;


--
-- Name: sms_account_sender; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_sender (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    sender_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_sender OWNER TO runbot;

--
-- Name: TABLE sms_account_sender; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_sender IS 'SMS Account Sender Name Wizard';


--
-- Name: COLUMN sms_account_sender.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.account_id IS 'Account';


--
-- Name: COLUMN sms_account_sender.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_sender.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_sender.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.sender_name IS 'Sender Name';


--
-- Name: COLUMN sms_account_sender.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_sender.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_date IS 'Last Updated on';


--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_sender_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_sender_id_seq OWNER TO runbot;

--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_sender_id_seq OWNED BY public.sms_account_sender.id;


--
-- Name: sms_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_composer (
    id integer NOT NULL,
    res_id integer,
    template_id integer,
    create_uid integer,
    write_uid integer,
    composition_mode character varying NOT NULL,
    res_model character varying,
    res_ids character varying,
    recipient_single_number_itf character varying,
    number_field_name character varying,
    numbers character varying,
    body text NOT NULL,
    mass_keep_log boolean,
    mass_force_send boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_composer OWNER TO runbot;

--
-- Name: TABLE sms_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_composer IS 'Send SMS Wizard';


--
-- Name: COLUMN sms_composer.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_id IS 'Document ID';


--
-- Name: COLUMN sms_composer.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.template_id IS 'Use Template';


--
-- Name: COLUMN sms_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_uid IS 'Created by';


--
-- Name: COLUMN sms_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_composer.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.composition_mode IS 'Composition Mode';


--
-- Name: COLUMN sms_composer.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_model IS 'Document Model Name';


--
-- Name: COLUMN sms_composer.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_ids IS 'Document IDs';


--
-- Name: COLUMN sms_composer.recipient_single_number_itf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.recipient_single_number_itf IS 'Recipient Number';


--
-- Name: COLUMN sms_composer.number_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.number_field_name IS 'Number Field';


--
-- Name: COLUMN sms_composer.numbers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.numbers IS 'Recipients (Numbers)';


--
-- Name: COLUMN sms_composer.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.body IS 'Message';


--
-- Name: COLUMN sms_composer.mass_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_keep_log IS 'Keep a note on document';


--
-- Name: COLUMN sms_composer.mass_force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_force_send IS 'Send directly';


--
-- Name: COLUMN sms_composer.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.use_exclusion_list IS 'Use Exclusion List';


--
-- Name: COLUMN sms_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_date IS 'Created on';


--
-- Name: COLUMN sms_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_date IS 'Last Updated on';


--
-- Name: sms_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_composer_id_seq OWNER TO runbot;

--
-- Name: sms_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_composer_id_seq OWNED BY public.sms_composer.id;


--
-- Name: sms_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_sms (
    id integer NOT NULL,
    partner_id integer,
    mail_message_id integer,
    create_uid integer,
    write_uid integer,
    uuid character varying,
    number character varying,
    state character varying NOT NULL,
    failure_type character varying,
    body text,
    to_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_sms OWNER TO runbot;

--
-- Name: TABLE sms_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_sms IS 'Outgoing SMS';


--
-- Name: COLUMN sms_sms.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.partner_id IS 'Customer';


--
-- Name: COLUMN sms_sms.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.mail_message_id IS 'Mail Message';


--
-- Name: COLUMN sms_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_uid IS 'Created by';


--
-- Name: COLUMN sms_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_sms.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.uuid IS 'UUID';


--
-- Name: COLUMN sms_sms.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.number IS 'Number';


--
-- Name: COLUMN sms_sms.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.state IS 'SMS Status';


--
-- Name: COLUMN sms_sms.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.failure_type IS 'Failure Type';


--
-- Name: COLUMN sms_sms.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.body IS 'Body';


--
-- Name: COLUMN sms_sms.to_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.to_delete IS 'Marked for deletion';


--
-- Name: COLUMN sms_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_date IS 'Created on';


--
-- Name: COLUMN sms_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_date IS 'Last Updated on';


--
-- Name: sms_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_sms_id_seq OWNER TO runbot;

--
-- Name: sms_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_sms_id_seq OWNED BY public.sms_sms.id;


--
-- Name: sms_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template (
    id integer NOT NULL,
    model_id integer NOT NULL,
    sidebar_action_id integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    name jsonb,
    body jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template OWNER TO runbot;

--
-- Name: TABLE sms_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template IS 'SMS Templates';


--
-- Name: COLUMN sms_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model_id IS 'Applies to';


--
-- Name: COLUMN sms_template.sidebar_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.sidebar_action_id IS 'Sidebar action';


--
-- Name: COLUMN sms_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN sms_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.lang IS 'Language';


--
-- Name: COLUMN sms_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model IS 'Related Document Model';


--
-- Name: COLUMN sms_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.name IS 'Name';


--
-- Name: COLUMN sms_template.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.body IS 'Body';


--
-- Name: COLUMN sms_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_date IS 'Created on';


--
-- Name: COLUMN sms_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_date IS 'Last Updated on';


--
-- Name: sms_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_id_seq OWNER TO runbot;

--
-- Name: sms_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_id_seq OWNED BY public.sms_template.id;


--
-- Name: sms_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_preview (
    id integer NOT NULL,
    sms_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    resource_ref character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_preview OWNER TO runbot;

--
-- Name: TABLE sms_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_preview IS 'SMS Template Preview';


--
-- Name: COLUMN sms_template_preview.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN sms_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN sms_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.resource_ref IS 'Record reference';


--
-- Name: COLUMN sms_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_date IS 'Last Updated on';


--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_preview_id_seq OWNER TO runbot;

--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_preview_id_seq OWNED BY public.sms_template_preview.id;


--
-- Name: sms_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_reset OWNER TO runbot;

--
-- Name: TABLE sms_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_reset IS 'SMS Template Reset';


--
-- Name: COLUMN sms_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_date IS 'Last Updated on';


--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_reset_id_seq OWNER TO runbot;

--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_reset_id_seq OWNED BY public.sms_template_reset.id;


--
-- Name: sms_template_sms_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_sms_template_reset_rel (
    sms_template_reset_id integer NOT NULL,
    sms_template_id integer NOT NULL
);


ALTER TABLE public.sms_template_sms_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE sms_template_sms_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_sms_template_reset_rel IS 'RELATION BETWEEN sms_template_reset AND sms_template';


--
-- Name: sms_tracker; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_tracker (
    id integer NOT NULL,
    mail_notification_id integer,
    create_uid integer,
    write_uid integer,
    sms_uuid character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_tracker OWNER TO runbot;

--
-- Name: TABLE sms_tracker; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_tracker IS 'Link SMS to mailing/sms tracking models';


--
-- Name: COLUMN sms_tracker.mail_notification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.mail_notification_id IS 'Mail Notification';


--
-- Name: COLUMN sms_tracker.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_uid IS 'Created by';


--
-- Name: COLUMN sms_tracker.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_tracker.sms_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.sms_uuid IS 'SMS uuid';


--
-- Name: COLUMN sms_tracker.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_date IS 'Created on';


--
-- Name: COLUMN sms_tracker.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_date IS 'Last Updated on';


--
-- Name: sms_tracker_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_tracker_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_tracker_id_seq OWNER TO runbot;

--
-- Name: sms_tracker_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_tracker_id_seq OWNED BY public.sms_tracker.id;


--
-- Name: snailmail_letter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.snailmail_letter (
    id integer NOT NULL,
    user_id integer,
    res_id integer NOT NULL,
    partner_id integer NOT NULL,
    company_id integer NOT NULL,
    report_template integer,
    attachment_id integer,
    message_id integer,
    state_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    state character varying NOT NULL,
    error_code character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    info_msg text,
    color boolean,
    cover boolean,
    duplex boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.snailmail_letter OWNER TO runbot;

--
-- Name: TABLE snailmail_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.snailmail_letter IS 'Snailmail Letter';


--
-- Name: COLUMN snailmail_letter.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.user_id IS 'Sent by';


--
-- Name: COLUMN snailmail_letter.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.res_id IS 'Document ID';


--
-- Name: COLUMN snailmail_letter.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.partner_id IS 'Recipient';


--
-- Name: COLUMN snailmail_letter.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.company_id IS 'Company';


--
-- Name: COLUMN snailmail_letter.report_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN snailmail_letter.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.attachment_id IS 'Attachment';


--
-- Name: COLUMN snailmail_letter.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.message_id IS 'Snailmail Status Message';


--
-- Name: COLUMN snailmail_letter.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state_id IS 'State';


--
-- Name: COLUMN snailmail_letter.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.country_id IS 'Country';


--
-- Name: COLUMN snailmail_letter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.model IS 'Model';


--
-- Name: COLUMN snailmail_letter.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state IS 'Status';


--
-- Name: COLUMN snailmail_letter.error_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.error_code IS 'Error';


--
-- Name: COLUMN snailmail_letter.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street IS 'Street';


--
-- Name: COLUMN snailmail_letter.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street2 IS 'Street2';


--
-- Name: COLUMN snailmail_letter.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.zip IS 'Zip';


--
-- Name: COLUMN snailmail_letter.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.city IS 'City';


--
-- Name: COLUMN snailmail_letter.info_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.info_msg IS 'Information';


--
-- Name: COLUMN snailmail_letter.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.color IS 'Color';


--
-- Name: COLUMN snailmail_letter.cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.cover IS 'Cover Page';


--
-- Name: COLUMN snailmail_letter.duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.duplex IS 'Both side';


--
-- Name: COLUMN snailmail_letter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.snailmail_letter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.snailmail_letter_id_seq OWNER TO runbot;

--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.snailmail_letter_id_seq OWNED BY public.snailmail_letter.id;


--
-- Name: summary_emp_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.summary_emp_rel (
    sum_id integer NOT NULL,
    emp_id integer NOT NULL
);


ALTER TABLE public.summary_emp_rel OWNER TO runbot;

--
-- Name: TABLE summary_emp_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.summary_emp_rel IS 'RELATION BETWEEN hr_holidays_summary_employee AND hr_employee';


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    url character varying,
    rainbow_man_message jsonb,
    custom boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Name';


--
-- Name: COLUMN web_tour_tour.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.url IS 'Starting URL';


--
-- Name: COLUMN web_tour_tour.rainbow_man_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.rainbow_man_message IS 'Rainbow Man Message';


--
-- Name: COLUMN web_tour_tour.custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.custom IS 'Custom';


--
-- Name: COLUMN web_tour_tour.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: web_tour_tour_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour_step (
    id integer NOT NULL,
    tour_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    content character varying,
    tooltip_position character varying,
    run character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour_step OWNER TO runbot;

--
-- Name: TABLE web_tour_tour_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour_step IS 'Tour''s step';


--
-- Name: COLUMN web_tour_tour_step.tour_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tour_id IS 'Tour';


--
-- Name: COLUMN web_tour_tour_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour_step.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.trigger IS 'Trigger';


--
-- Name: COLUMN web_tour_tour_step.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.content IS 'Content';


--
-- Name: COLUMN web_tour_tour_step.tooltip_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tooltip_position IS 'Tooltip Position';


--
-- Name: COLUMN web_tour_tour_step.run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.run IS 'Run';


--
-- Name: COLUMN web_tour_tour_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNED BY public.web_tour_tour_step.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: ai_agent id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_agent ALTER COLUMN id SET DEFAULT nextval('public.ai_agent_id_seq'::regclass);


--
-- Name: ai_agent_source id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_agent_source ALTER COLUMN id SET DEFAULT nextval('public.ai_agent_source_id_seq'::regclass);


--
-- Name: ai_composer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_composer ALTER COLUMN id SET DEFAULT nextval('public.ai_composer_id_seq'::regclass);


--
-- Name: ai_embedding id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_embedding ALTER COLUMN id SET DEFAULT nextval('public.ai_embedding_id_seq'::regclass);


--
-- Name: ai_prompt_button id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_prompt_button ALTER COLUMN id SET DEFAULT nextval('public.ai_prompt_button_id_seq'::regclass);


--
-- Name: ai_topic id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_topic ALTER COLUMN id SET DEFAULT nextval('public.ai_topic_id_seq'::regclass);


--
-- Name: auth_passkey_key id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_passkey_key ALTER COLUMN id SET DEFAULT nextval('public.auth_passkey_key_id_seq'::regclass);


--
-- Name: auth_passkey_key_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_passkey_key_create ALTER COLUMN id SET DEFAULT nextval('public.auth_passkey_key_create_id_seq'::regclass);


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_rate_limit_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_rate_limit_log ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_rate_limit_log_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_module ALTER COLUMN id SET DEFAULT nextval('public.base_import_module_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_install_request id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_request ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_request_id_seq'::regclass);


--
-- Name: base_module_install_review id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_review ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_review_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: calendar_alarm id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_alarm ALTER COLUMN id SET DEFAULT nextval('public.calendar_alarm_id_seq'::regclass);


--
-- Name: calendar_attendee id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_attendee ALTER COLUMN id SET DEFAULT nextval('public.calendar_attendee_id_seq'::regclass);


--
-- Name: calendar_event id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_event ALTER COLUMN id SET DEFAULT nextval('public.calendar_event_id_seq'::regclass);


--
-- Name: calendar_event_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_event_type ALTER COLUMN id SET DEFAULT nextval('public.calendar_event_type_id_seq'::regclass);


--
-- Name: calendar_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_filters ALTER COLUMN id SET DEFAULT nextval('public.calendar_filters_id_seq'::regclass);


--
-- Name: calendar_popover_delete_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_popover_delete_wizard ALTER COLUMN id SET DEFAULT nextval('public.calendar_popover_delete_wizard_id_seq'::regclass);


--
-- Name: calendar_provider_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_provider_config ALTER COLUMN id SET DEFAULT nextval('public.calendar_provider_config_id_seq'::regclass);


--
-- Name: calendar_recurrence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.calendar_recurrence ALTER COLUMN id SET DEFAULT nextval('public.calendar_recurrence_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: digest_digest id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.digest_digest ALTER COLUMN id SET DEFAULT nextval('public.digest_digest_id_seq'::regclass);


--
-- Name: digest_tip id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.digest_tip ALTER COLUMN id SET DEFAULT nextval('public.digest_tip_id_seq'::regclass);


--
-- Name: discuss_call_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_call_history ALTER COLUMN id SET DEFAULT nextval('public.discuss_call_history_id_seq'::regclass);


--
-- Name: discuss_channel id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_id_seq'::regclass);


--
-- Name: discuss_channel_member id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_member ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_member_id_seq'::regclass);


--
-- Name: discuss_channel_rtc_session id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_rtc_session ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_rtc_session_id_seq'::regclass);


--
-- Name: discuss_gif_favorite id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_gif_favorite ALTER COLUMN id SET DEFAULT nextval('public.discuss_gif_favorite_id_seq'::regclass);


--
-- Name: discuss_voice_metadata id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_voice_metadata ALTER COLUMN id SET DEFAULT nextval('public.discuss_voice_metadata_id_seq'::regclass);


--
-- Name: fetchmail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.fetchmail_server ALTER COLUMN id SET DEFAULT nextval('public.fetchmail_server_id_seq'::regclass);


--
-- Name: homework_location_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.homework_location_wizard ALTER COLUMN id SET DEFAULT nextval('public.homework_location_wizard_id_seq'::regclass);


--
-- Name: hr_bank_account_allocation_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_bank_account_allocation_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_bank_account_allocation_wizard_id_seq'::regclass);


--
-- Name: hr_bank_account_allocation_wizard_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_bank_account_allocation_wizard_line ALTER COLUMN id SET DEFAULT nextval('public.hr_bank_account_allocation_wizard_line_id_seq'::regclass);


--
-- Name: hr_contract_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_contract_type ALTER COLUMN id SET DEFAULT nextval('public.hr_contract_type_id_seq'::regclass);


--
-- Name: hr_department id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_department ALTER COLUMN id SET DEFAULT nextval('public.hr_department_id_seq'::regclass);


--
-- Name: hr_departure_reason id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_departure_reason ALTER COLUMN id SET DEFAULT nextval('public.hr_departure_reason_id_seq'::regclass);


--
-- Name: hr_departure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_departure_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_departure_wizard_id_seq'::regclass);


--
-- Name: hr_employee id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_id_seq'::regclass);


--
-- Name: hr_employee_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_category ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_category_id_seq'::regclass);


--
-- Name: hr_employee_cv_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_cv_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_cv_wizard_id_seq'::regclass);


--
-- Name: hr_employee_location id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_location ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_location_id_seq'::regclass);


--
-- Name: hr_employee_skill id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_employee_skill ALTER COLUMN id SET DEFAULT nextval('public.hr_employee_skill_id_seq'::regclass);


--
-- Name: hr_holidays_cancel_leave id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_holidays_cancel_leave ALTER COLUMN id SET DEFAULT nextval('public.hr_holidays_cancel_leave_id_seq'::regclass);


--
-- Name: hr_holidays_summary_employee id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_holidays_summary_employee ALTER COLUMN id SET DEFAULT nextval('public.hr_holidays_summary_employee_id_seq'::regclass);


--
-- Name: hr_job id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_job ALTER COLUMN id SET DEFAULT nextval('public.hr_job_id_seq'::regclass);


--
-- Name: hr_job_skill id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_job_skill ALTER COLUMN id SET DEFAULT nextval('public.hr_job_skill_id_seq'::regclass);


--
-- Name: hr_leave id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_leave ALTER COLUMN id SET DEFAULT nextval('public.hr_leave_id_seq'::regclass);


--
-- Name: hr_leave_accrual_level id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_leave_accrual_level ALTER COLUMN id SET DEFAULT nextval('public.hr_leave_accrual_level_id_seq'::regclass);


--
-- Name: hr_leave_accrual_plan id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_leave_accrual_plan ALTER COLUMN id SET DEFAULT nextval('public.hr_leave_accrual_plan_id_seq'::regclass);


--
-- Name: hr_leave_allocation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_leave_allocation ALTER COLUMN id SET DEFAULT nextval('public.hr_leave_allocation_id_seq'::regclass);


--
-- Name: hr_leave_allocation_generate_multi_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_leave_allocation_generate_multi_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_leave_allocation_generate_multi_wizard_id_seq'::regclass);


--
-- Name: hr_leave_generate_multi_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_leave_generate_multi_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_leave_generate_multi_wizard_id_seq'::regclass);


--
-- Name: hr_leave_mandatory_day id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_leave_mandatory_day ALTER COLUMN id SET DEFAULT nextval('public.hr_leave_mandatory_day_id_seq'::regclass);


--
-- Name: hr_leave_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_leave_type ALTER COLUMN id SET DEFAULT nextval('public.hr_leave_type_id_seq'::regclass);


--
-- Name: hr_payroll_structure_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_payroll_structure_type ALTER COLUMN id SET DEFAULT nextval('public.hr_payroll_structure_type_id_seq'::regclass);


--
-- Name: hr_resume_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_resume_line ALTER COLUMN id SET DEFAULT nextval('public.hr_resume_line_id_seq'::regclass);


--
-- Name: hr_resume_line_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_resume_line_type ALTER COLUMN id SET DEFAULT nextval('public.hr_resume_line_type_id_seq'::regclass);


--
-- Name: hr_skill id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_skill ALTER COLUMN id SET DEFAULT nextval('public.hr_skill_id_seq'::regclass);


--
-- Name: hr_skill_level id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_skill_level ALTER COLUMN id SET DEFAULT nextval('public.hr_skill_level_id_seq'::regclass);


--
-- Name: hr_skill_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_skill_type ALTER COLUMN id SET DEFAULT nextval('public.hr_skill_type_id_seq'::regclass);


--
-- Name: hr_version id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_version ALTER COLUMN id SET DEFAULT nextval('public.hr_version_id_seq'::regclass);


--
-- Name: hr_version_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_version_wizard ALTER COLUMN id SET DEFAULT nextval('public.hr_version_wizard_id_seq'::regclass);


--
-- Name: hr_work_location id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.hr_work_location ALTER COLUMN id SET DEFAULT nextval('public.hr_work_location_id_seq'::regclass);


--
-- Name: html_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.html_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.html_editor_converter_test_id_seq'::regclass);


--
-- Name: html_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.html_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.html_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: iap_service id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_service ALTER COLUMN id SET DEFAULT nextval('public.iap_service_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_server_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_server_history ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_server_history_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_progress id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_progress ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_progress_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_embedded_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_embedded_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_embedded_actions_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_inherit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_inherit ALTER COLUMN id SET DEFAULT nextval('public.ir_model_inherit_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: mail_activity id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_id_seq'::regclass);


--
-- Name: mail_activity_plan id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_id_seq'::regclass);


--
-- Name: mail_activity_plan_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan_template ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_template_id_seq'::regclass);


--
-- Name: mail_activity_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_schedule_id_seq'::regclass);


--
-- Name: mail_activity_schedule_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_schedule_line ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_schedule_line_id_seq'::regclass);


--
-- Name: mail_activity_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_type ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_type_id_seq'::regclass);


--
-- Name: mail_alias id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_id_seq'::regclass);


--
-- Name: mail_alias_domain id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias_domain ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_domain_id_seq'::regclass);


--
-- Name: mail_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_id_seq'::regclass);


--
-- Name: mail_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_remove_id_seq'::regclass);


--
-- Name: mail_canned_response id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_canned_response ALTER COLUMN id SET DEFAULT nextval('public.mail_canned_response_id_seq'::regclass);


--
-- Name: mail_compose_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_compose_message ALTER COLUMN id SET DEFAULT nextval('public.mail_compose_message_id_seq'::regclass);


--
-- Name: mail_followers id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_id_seq'::regclass);


--
-- Name: mail_followers_edit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers_edit ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_edit_id_seq'::regclass);


--
-- Name: mail_gateway_allowed id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_gateway_allowed ALTER COLUMN id SET DEFAULT nextval('public.mail_gateway_allowed_id_seq'::regclass);


--
-- Name: mail_guest id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_guest ALTER COLUMN id SET DEFAULT nextval('public.mail_guest_id_seq'::regclass);


--
-- Name: mail_ice_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_ice_server ALTER COLUMN id SET DEFAULT nextval('public.mail_ice_server_id_seq'::regclass);


--
-- Name: mail_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_link_preview_id_seq'::regclass);


--
-- Name: mail_mail id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_mail ALTER COLUMN id SET DEFAULT nextval('public.mail_mail_id_seq'::regclass);


--
-- Name: mail_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message ALTER COLUMN id SET DEFAULT nextval('public.mail_message_id_seq'::regclass);


--
-- Name: mail_message_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_message_link_preview_id_seq'::regclass);


--
-- Name: mail_message_reaction id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_reaction ALTER COLUMN id SET DEFAULT nextval('public.mail_message_reaction_id_seq'::regclass);


--
-- Name: mail_message_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_message_schedule_id_seq'::regclass);


--
-- Name: mail_message_subtype id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_subtype ALTER COLUMN id SET DEFAULT nextval('public.mail_message_subtype_id_seq'::regclass);


--
-- Name: mail_message_translation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_translation ALTER COLUMN id SET DEFAULT nextval('public.mail_message_translation_id_seq'::regclass);


--
-- Name: mail_notification id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_notification ALTER COLUMN id SET DEFAULT nextval('public.mail_notification_id_seq'::regclass);


--
-- Name: mail_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_presence ALTER COLUMN id SET DEFAULT nextval('public.mail_presence_id_seq'::regclass);


--
-- Name: mail_push id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push ALTER COLUMN id SET DEFAULT nextval('public.mail_push_id_seq'::regclass);


--
-- Name: mail_push_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push_device ALTER COLUMN id SET DEFAULT nextval('public.mail_push_device_id_seq'::regclass);


--
-- Name: mail_scheduled_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_scheduled_message ALTER COLUMN id SET DEFAULT nextval('public.mail_scheduled_message_id_seq'::regclass);


--
-- Name: mail_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template ALTER COLUMN id SET DEFAULT nextval('public.mail_template_id_seq'::regclass);


--
-- Name: mail_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_template_preview_id_seq'::regclass);


--
-- Name: mail_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_reset ALTER COLUMN id SET DEFAULT nextval('public.mail_template_reset_id_seq'::regclass);


--
-- Name: mail_tracking_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_tracking_value ALTER COLUMN id SET DEFAULT nextval('public.mail_tracking_value_id_seq'::regclass);


--
-- Name: orm_signaling_assets id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_assets ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_assets_id_seq'::regclass);


--
-- Name: orm_signaling_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_default ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_default_id_seq'::regclass);


--
-- Name: orm_signaling_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_groups ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_groups_id_seq'::regclass);


--
-- Name: orm_signaling_registry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_registry ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_registry_id_seq'::regclass);


--
-- Name: orm_signaling_routing id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_routing ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_routing_id_seq'::regclass);


--
-- Name: orm_signaling_stable id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_stable ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_stable_id_seq'::regclass);


--
-- Name: orm_signaling_templates id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_templates ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_templates_id_seq'::regclass);


--
-- Name: phone_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_id_seq'::regclass);


--
-- Name: phone_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_remove_id_seq'::regclass);


--
-- Name: portal_share id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.portal_share ALTER COLUMN id SET DEFAULT nextval('public.portal_share_id_seq'::regclass);


--
-- Name: portal_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.portal_wizard ALTER COLUMN id SET DEFAULT nextval('public.portal_wizard_id_seq'::regclass);


--
-- Name: portal_wizard_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.portal_wizard_user ALTER COLUMN id SET DEFAULT nextval('public.portal_wizard_user_id_seq'::regclass);


--
-- Name: privacy_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_log ALTER COLUMN id SET DEFAULT nextval('public.privacy_log_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard_line ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_line_id_seq'::regclass);


--
-- Name: properties_base_definition id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.properties_base_definition ALTER COLUMN id SET DEFAULT nextval('public.properties_base_definition_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_device_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_device_log ALTER COLUMN id SET DEFAULT nextval('public.res_device_log_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_groups_privilege id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups_privilege ALTER COLUMN id SET DEFAULT nextval('public.res_groups_privilege_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_role id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_role ALTER COLUMN id SET DEFAULT nextval('public.res_role_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: res_users_settings_embedded_action id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_embedded_action ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_embedded_action_id_seq'::regclass);


--
-- Name: res_users_settings_volumes id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_volumes ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_volumes_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: resource_calendar id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_id_seq'::regclass);


--
-- Name: resource_calendar_attendance id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar_attendance ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_attendance_id_seq'::regclass);


--
-- Name: resource_calendar_leaves id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_calendar_leaves ALTER COLUMN id SET DEFAULT nextval('public.resource_calendar_leaves_id_seq'::regclass);


--
-- Name: resource_resource id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.resource_resource ALTER COLUMN id SET DEFAULT nextval('public.resource_resource_id_seq'::regclass);


--
-- Name: server_action_history_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.server_action_history_wizard ALTER COLUMN id SET DEFAULT nextval('public.server_action_history_wizard_id_seq'::regclass);


--
-- Name: sms_account_code id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_code ALTER COLUMN id SET DEFAULT nextval('public.sms_account_code_id_seq'::regclass);


--
-- Name: sms_account_phone id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_phone ALTER COLUMN id SET DEFAULT nextval('public.sms_account_phone_id_seq'::regclass);


--
-- Name: sms_account_sender id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_sender ALTER COLUMN id SET DEFAULT nextval('public.sms_account_sender_id_seq'::regclass);


--
-- Name: sms_composer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_composer ALTER COLUMN id SET DEFAULT nextval('public.sms_composer_id_seq'::regclass);


--
-- Name: sms_sms id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_sms ALTER COLUMN id SET DEFAULT nextval('public.sms_sms_id_seq'::regclass);


--
-- Name: sms_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template ALTER COLUMN id SET DEFAULT nextval('public.sms_template_id_seq'::regclass);


--
-- Name: sms_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_preview ALTER COLUMN id SET DEFAULT nextval('public.sms_template_preview_id_seq'::regclass);


--
-- Name: sms_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_reset ALTER COLUMN id SET DEFAULT nextval('public.sms_template_reset_id_seq'::regclass);


--
-- Name: sms_tracker id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_tracker ALTER COLUMN id SET DEFAULT nextval('public.sms_tracker_id_seq'::regclass);


--
-- Name: snailmail_letter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.snailmail_letter ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: web_tour_tour_step id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour_step ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_step_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: activity_attachment_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.activity_attachment_rel (activity_id, attachment_id) FROM stdin;
\.


--
-- Data for Name: ai_agent; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent (id, partner_id, create_uid, write_uid, subtitle, response_style, llm_model, system_prompt, active, restrict_to_sources, is_system_agent, create_date, write_date) FROM stdin;
1	61	1	1	Your Odoo sidekick for most day-to-day tasks.	balanced	gpt-4o	\N	t	\N	t	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
2	62	2	1	Used for searching information across your database.	analytical	gemini-2.5-flash	# Odoo Ask AI agent\n\nYou are an agent dedicated to help the user with his Odoo database. To help him in his tasks, you have access to a bunch of tools related to search which can be used to retrieve information about the database. You also have another set of tools which you can use to move the user around in the UI.\n\n## General Rules\n\n- You must NEVER display errors to the user. If you cannot complete the query, just say that you weren't able to fulfil the query.\n- ONLY use tools if you really need to, if the question is not related to Odoo, or information of the database, use your general knowledge.\n- If you encounter a forbidden action error, say you are not allowed to perform the actions needed to fulfil the user's query.\n- Only use action ids you have access to, do not make up tool calls.\n\n## Topics\n\nBelow, you'll find a description of topics you have access to along with a list of the tools they offer.\n\n### Information retrieval\n\nThis is the PRIMARY topic you must consider when answering a query, it contains the following tools that are related to search and analysis of the content of the Odoo database:\n\n- Get Fields\n- Search\n- Read group\n\n**Triggers**\n\nWhen one (or more) of these triggers is TRUE for the user's query, use Information retrieval tools.\n\n- Simple questions\n- Queries that are not related to opening view, or showing content\n- **Keywords**: Who, When, How, etc.\n\n**Examples**\n\n- Who are the top salespersons this month?\n- Do I have customers in Belgium?\n\n### Natural Language Search tools\n\nThese are the tools related to interactions with the view in Odoo, you'll use it to move to the appropriate view and apply proper filters inside of these views:\n\n- Get Fields\n- Compute Report Measures\n- Get Menu Details\n- Open Menu Graph\n- Open Menu Kanban\n- Open Menu List\n- Open Menu Pivot\n\n**Triggers**\n\nWhen one (or more) of these triggers is TRUE for the user's query, use Natural Language Search tools.\n\n- Queries related to navigation within Odoo\n- **Keywords**: show, open, view, see.\n\n**Examples**\n\n- Show me the top salespersons this month\n- Open a graph view of the best sellers of the last six months\n\n## Tools Selection\n\n- ALWAYS use Information retrieval tools. You must not perform view operations unless EXPLICITELY told to\n        	t	\N	f	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
3	63	2	1	Helps you with any legal issue related to Odoo.	analytical	gpt-4o	You are a legal advisor in your company. Based on the official documentation you've been given, your job is to help employees navigate legal issues.\nTo do so, keep your answer really short, making it as clear as possible.\n        	t	\N	f	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
\.


--
-- Data for Name: ai_agent_ai_topic_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent_ai_topic_rel (ai_agent_id, ai_topic_id) FROM stdin;
2	2
2	1
\.


--
-- Data for Name: ai_agent_source; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent_source (id, agent_id, attachment_id, create_uid, write_uid, name, type, status, url, error_details, is_active, create_date, write_date) FROM stdin;
1	3	427	1	1	Odoo Enterprise Agreement	binary	processing	\N	\N	\N	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
\.


--
-- Data for Name: ai_composer; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_composer (id, ai_agent, create_uid, write_uid, name, interface_key, default_prompt, is_system_default, create_date, write_date) FROM stdin;
1	1	1	1	Mail/Note Composer	mail_composer	Your job is to help with drafting messages. If the user asks you to write a reply or a message, YOUR REPLY WILL BE INSERTED AS IS for the correspondence. Follow the tone from the previous correspondence, and **WRITE ONLY THE BODY OF THE MESSAGE. DO NOT ADD ADDITIONAL COMMENTARY, A SUBJECT LINE, OR A SIGNATURE.** Format your messages like an email, beginning with a greeting, and the rest of the content in a new line.	t	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
2	1	1	1	Record HTML Fields	html_field_record	Your job is to help with drafting the description of an odoo record. If the user asks you to write something, **YOUR REPLY WILL BE INSERTED AS IS for the description. DO NOT ADD ANY EXTRA COMMENTARY THAT SHOULDN'T APPEAR IN THE DESCRIPTION.** Give your answers succinctly and to the point.	t	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
3	1	1	1	Text Selector	html_field_text_select	Your job is to suggest alternatives to a piece of text the user has written. If the user asks you to rewrite the text in a specific way, **YOUR ANSWER WILL BE REPLACING THE ORIGINAL TEXT AS IS, thus DO NOT ADD ADDITIONAL COMMENTARY**.	t	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
4	1	1	1	Chatter Helper	chatter_ai_button	Your job is to assist the user with the chatter correspondence. If the user asks you to summarize the chatter conversation, reply with a small description for the conversation and then a list of all the key messages in the correspondence. Each bullet point should have a general title in bold and a description in plaintext. If the user asks you to write a reply or a message, **YOUR REPLY WILL BE INSERTED AS IS**. Follow the tone from the previous messages in the chatter. **WRITE ONLY THE BODY OF THE MESSAGE. DO NOT ADD ADDITIONAL COMMENTARY, A SUBJECT LINE, OR A SIGNATURE.** Format your messages like an email, beginning with a greeting, and the rest of the content in a new line.	t	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
5	1	1	1	Mail Template Prompt Evaluator	html_prompt_shortcut	\nYou are an Email Prompt Transformer. You'll get a single instruction or rough prompt and must output a concise, professional snippet for a customer-facing email body—no commentary because your output will be inserted directly into an email, without any changes.\n\n**1. Execute**\n- Read the input as a command or sketch and produce the intended text.\n- If you can't help, return an empty string.\n\n**2. Placeholders**\n- Ideas/constructs that are linked to literals like `false`, `undefined`, `null` or bracketed value like `[value]` should be ignored and don't invent any values.\n- Don't invent dates, names, or other details.\n\n**3. Unquote**\n- Remove surrounding quotes from any quoted text.\n\n**4. Polish**\n- Eliminate redundancies, filler, apologies, or uncertainty (e.g. "I'm not sure").\n- Use the requested language.\n\n**5. Output only**\n- Return exactly the email fragment (body only), with no subject, labels, or extra formatting.\n\n---\n\n**Examples**\n\n- **Input:**\n  `Insert a greeting for the buyer, mentioning "Burger Maison" and reminding them of [deadline].`\n  **Output:**\n  `We're thrilled to announce the launch of Burger Maison—thank you for your continued partnership.`\n  **Explanation:**\n  There is no value for `[deadline]`, so that part where the input asks for reminding is ignored.\n\n- **Input:**\n  `Please thank [name] for their purchase of "Deluxe Toolkit" and mention shipment on false.`\n  **Output:**\n  `Thank you for purchasing Deluxe Toolkit. Your order will shipped shortly.`\n   **Explanation:**\n   There is no value for `[name]` so the "thank" is generic. The shipment date is also missing so the shipping information is also a generic statement.\n\n- **Input:**\n  `Add a closing line wishing them a great weekend.`\n  **Output:**\n  `Have a wonderful weekend, and feel free to reach out with any questions.`\n            	t	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
6	2	1	1	Ask AI	systray_ai_button	\N	t	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
7	1	1	1	Summarize Voice Transcription	voice_transcription_component	Summarize the transcript below.\n\nYour summary should be structured in a way that is easy to skim. It should only contain the essential information.\nIt must be in markdown format. Do NOT put the main markup inside code blocks.	t	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
\.


--
-- Data for Name: ai_composer_ir_model_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_composer_ir_model_rel (ai_composer_id, ir_model_id) FROM stdin;
\.


--
-- Data for Name: ai_embedding; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_embedding (id, attachment_id, sequence, create_uid, write_uid, embedding_model, content, has_embedding_generation_failed, create_date, write_date, embedding_vector) FROM stdin;
\.


--
-- Data for Name: ai_prompt_button; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_prompt_button (id, sequence, composer_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	10	4	1	1	Summarize the chatter conversation	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
2	20	4	1	1	Write a followup answer	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
3	10	1	1	1	Write a followup answer	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
4	10	3	1	1	Rewrite selected text	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
5	10	6	1	1	Top reason for which people opt-out from lists	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
6	10	6	1	1	Single most common stock move from/to	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
7	10	7	1	1	Summarize this recruitment call	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
8	10	7	1	1	Summarize this prospect call	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
9	10	7	1	1	Write an email recap	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
10	10	6	1	1	Pie chart of sales by customer country	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
11	10	6	1	1	Pivot of products with less than 5 in stock	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
12	10	6	1	1	What's my agenda for today?	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
13	10	6	1	1	Top 5 sales reps by revenue	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
14	10	6	1	1	Show sales by product category this month	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
15	10	6	1	1	Bar chart of top-selling products	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
16	10	6	1	1	Do I have any customer in Japan?	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
17	10	6	1	1	Which project costs us the most?	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
18	10	6	1	1	Show me the current cash flow status	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
19	10	6	1	1	Summarize what the last tickets complain about	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
20	10	6	1	1	Latest PO from supplier Azure interior	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
21	10	6	1	1	Display the profit margins by product category	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
22	10	6	1	1	5 blog ideas from my product catalog	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
\.


--
-- Data for Name: ai_tool_ids_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_tool_ids_rel (parent_id, tool_id) FROM stdin;
\.


--
-- Data for Name: ai_topic; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_topic (id, create_uid, write_uid, name, description, instructions, create_date, write_date) FROM stdin;
1	1	1	Natural Language Search	Supports interpretation of a user query to open the appropriate Odoo view with a set of tools necessary to perform the search.	# Odoo Natural Language Search Agent\n\n**Purpose**: Interpret natural language queries and execute navigation or in-view adjustments via tool calls. Always act—never replace an actionable response with plain text. If `current_view` exists, treat it as context for follow-ups.\n\n## 1. CRITICAL\n\n### **NEVER** explain requested tool calls\n\n## 2. Session Context Elements\n\n**CRITICAL**: The `<session_info_context>` element provides the available UI elements for each menu/view:\n\n- **`<searchable_fields>`**: Contains the fields that can be used in the `search` parameter\n- **`<filters>`**: list of available filter names for `selected_filters` parameter\n- **`<groupbys>`**: list of available groupby options for `selected_groupbys` parameter\n  - These are the primary source for grouping\n  - Fallback: Fields with groupable=true (but NO field chains)\n- **`<active_search_facets>`**: Contains all the active filters, search terms and groupbys.\n\n**Rule**: Always check session_info_context BEFORE constructing search/filter/groupby parameters.\n\n## 3. Execution Model & Tool Categories\n\n### Tool Categories\n**Terminating Tools** (max 1 successful per message):\n- Menu opening tools (for list, kanban, pivot, graph views) and search adjustment tool\n- These produce navigation or search state changes\n- Every terminating call MUST include `__end_message`\n\n**Supporting Tools** (should be batched as much as possible):\n- Menu details retrieval, field inspection, and report measures computation tools\n- Must be called BEFORE the terminating tool\n- Batch multiple supporting calls in a single message for efficiency\n\n### Execution Invariants (HARD GUARANTEES)\n1. **One Terminating Tool Rule**: Per user message, execute AT MOST one successful terminating tool\n2. **No Chaining**: Never chain multiple terminating tools - refinements belong to the next user message\n3. **Supporting Before Terminating**: All supporting tools must precede the terminating tool\n4. **Retry Limits**: Maximum 5 retry attempts for terminating tools (counting both successes and failures)\n5. **Retry Consistency**: When retrying, use the SAME terminating tool type - don't switch between menu opening and search adjustment tools\n6. **Failed = Error Only**: A terminating call is failed only if platform returns explicit error (invalid JSON, unknown field, unsupported view)\n7. **Fallback Required**: After max retries, emit best valid simplified action or brief refusal with explanation in `__end_message`\n\n## 4. CRITICAL PARAMETER RULES (Prevents Common Errors)\n\n**FUNDAMENTAL RULE**: Field chains (dotted paths like `lines.product_id.name`) are ONLY allowed in `custom_domain`.\n- **NEVER** use field chains for `search`, `filters`, or `groupbys` params\n\n### 4.1 The `search` Parameter\nAlso applies to the `apply_searchces` param.\n\n**STRICT RULES**:\n- **ONLY accepts fields from `<searchable_fields>` in session_info_context**\n- **NEVER use dotted paths** (e.g., WRONG: `lines.product_id.name`)\n- **Format**: `field=term` where `=` is a separator, NOT an operator\n- **No comparison operators allowed** (never `!=`, `>`, `<`, etc.)\n- **NO FIELD CHAINS** - if you need relational fields, use `custom_domain`\n\n**When to use `search`**:\n- Simple field matches where field exists in `<searchable_fields>`\n- Example: If `<searchable_fields>` contains `partner_id` and `state`, then `["partner_id=Azure", "state=draft"]` is valid\n\n### 4.2 The `custom_domain` Parameter\n**WHEN REQUIRED** (use to COMPLEMENT search when needed):\n- **ANY relational traversal** (dotted paths like `lines.product_id.name`)\n- **Comparison operators** (`>`, `<`, `!=`, etc.)\n- **Complex logic** (AND/OR combinations beyond simple filters)\n- **Conditions that cannot be expressed via search/filters**\n\n### 4.3 Combining search, filters and custom_domain\n\n**GUIDING PRINCIPLE**: search, filters and custom_domain COMPLEMENT each other (they are ANDed together)\n\n**Decision Process**:\n1. **First**: Check if conditions can be constructed using `search` and or `filter` (for simple top-level fields)\n2. **Then**: If they aren't sufficient, ADD a `custom_domain` for additional conditions\n3. **Best Practice**: Avoid repeating search terms in custom_domain (they're already ANDed)\n\n**Examples of Complementary Usage**:\n```\n# Simple fields in search, relational in custom_domain\nsearch=["state=draft", "partner_id=Azure"],\ncustom_domain="[[\\"lines.product_id.categ_id.name\\",\\"ilike\\",\\"drinks\\"]]"\n# Result: (state=draft AND partner_id=Azure AND lines contain drinks)\n\n# Search handles what it can, custom_domain adds complex conditions\nsearch=["config_id=restaurant"],\ncustom_domain="[[\\"amount_total\\",\\">\\",500]]"\n# Result: (config_id=restaurant AND amount_total > 500)\n```\n\n**When to use which**:\n- **search alone**: Simple top-level field matches with = operator\n- **filter alone**: Query can be represented by predefined filters.\n- **custom_domain alone**: When ALL conditions require dotted paths or operators\n- **All together**: When the query corresponds to complex conditions\n\n### 4.4 Other Search View Elements\n- **selected_filters**: ONLY filter names from `<filters>` in session_info_context\n  - filters that are in the same group are ORed, and ANDed between groups.\n  - Must match filter names exactly as they appear in `<filters>`\n  - NO field chains allowed - use existing filter names only\n- **selected_groupbys**: Primary source is `<groupbys>` in session_info_context\n  - First preference: Use groupby names from `<groupbys>` element\n  - Fallback only: Fields where groupable=true from field inspection (but NO field chains)\n  - **NEVER** use field chains. Refuse to groupby the requested grouping if the field isn't directly accessible to the current model.\n\n### 4.5 Constructing Custom Domains\n- A condition is a triplet: [field:str, operator:str, value:any]\n- value can't be a field - only literals (strings, numbers, lists)\n- A field can be a top-level field or a related field (using dotted paths).\n- The operator defines the relationship (comparison) between the field and the value.\n  - Can be any of: =, !=, <, >, <=, >=, in, not in, like, not like, ilike, not ilike\n- A **domain** is a collection of conditions combined with logical operators (!, &, |).\n- RPN (Reverse Polish Notation) is used to combine conditions in a domain.\n- With RPN, operators follow their operands, allowing for complex logical expressions without parentheses. Therefore, complex domain can be constructed without nesting.\n\n#### Example Domains\n- Single condition: "[[\\"state\\",\\"=\\",\\"draft\\"]]"\n- Multiple conditions: "[\\"&\\", [\\"state\\",\\"=\\",\\"draft\\"], [\\"amount_total\\",\\">\\",500]]"\n- Complex domain: "[\\"|\\", \\"&\\", [\\"state\\",\\"=\\",\\"draft\\"], [\\"amount_total\\",\\">\\",500], [\\"partner_id\\",\\"=\\",\\"Azure\\"]]]"\n  - Possible domain for orders that are in draft with amount_total > 500 and orders for partner Azure.\n- More complex domain:\n  - The following domain can be for orders model that are from restaurant configs with drinks/food from Southeast Asia and orders from any other configs (notice that it doesn't have nesting)\n  `["|", "&", "&", "&", ["state", "=", "draft"], ["config_id.module_pos_restaurant", "=", true], ["lines.product_id.pos_categ_ids.name", "in", ["drinks", "food"]], ["partner_id.country_id.code", "in", ["PH", "TH", "VN", "ID", "MY"]], ["config_id.module_pos_restaurant", "!=", true]]'`\n\n## 5. Workflow & Decision Logic\n\n### 5.1 Primary Decision: Open Menu vs Adjust Search\n\n**Choose OPEN MENU when**:\n- Query is self-contained (makes sense standalone), OR\n- Query diverges from current model/view (different business object or needed view type), OR\n- No current view exists\n\n**Choose ADJUST SEARCH when**:\n- Query clearly depends on prior context, AND\n- Current view's model matches the intent, AND\n- Changes can be expressed via the params of the adjust search tool\n\n**When ambiguous**: Default to Open Menu unless reusing current context is obviously correct\n\n### 5.2 Open Menu Workflow\n\n**Step 1: Identify Candidates**\n- Select 1-3 candidate menus by model keywords/business terms\n\n**Step 2: Batch Supporting Calls** (single message):\n- Retrieve menu details for each candidate menu_id\n- Compute report measures if pivot/graph likely\n- Fetch field definitions for EVERY model in traversal path if custom_domain needed\n\n**Step 3: Interpret Results**\n- Map query phrases → filters, groupbys, searchable fields, or domain conditions\n- Check `<session_info_context>` for available `<searchable_fields>`, `<filters>`, and `<groupbys>`\n- Avoid duplicating default filters unless user explicitly overrides\n\n**Step 4: Build Parameters**\n- **selected_filters**: Only filter names from `<filters>` in session_info_context\n- **selected_groupbys/row_groupbys/col_groupbys**: From `<groupbys>` in session_info_context (or groupable fields as fallback)\n- **search**: ONLY fields from `<searchable_fields>` in session_info_context (no dotted paths!)\n- **measures**: From report measures computation, include `__count` if only counting\n- **custom_domain**: ONLY if search/filters insufficient, validate ALL fields via field inspection\n\n**Step 5: Execute**\n- Call exactly ONE menu opening tool with `__end_message`\n\n### 5.3 Adjust Search Workflow\n\n**Step 1: Use Existing Context**\n- Use `current_view` metadata - do NOT re-fetch menu details\n- The current view context contains the active facets that contains the currently active conditions and groupbys.\n- Interpret the user query to know if facets have to be removed or kept.\n\n**Step 2: Determine Adjustments**\n- See adjust search tool description.\n- Call the compute report measures tool if changes in measures is necessary.\n\n**Step 3: Execute**\n- Call search adjustment tool once with ALL changes and `__end_message`\n- **CRITICAL**: When requested to switch to a view, make sure that it's in the `available_view_types` from the current view in the session_info_context. Provide an empty switch_view param and explain in the refusal in the `__end_message` param.\n\n## 6. Batching Principle\n\n**ALWAYS batch supporting tool calls in a single message**:\n- Multiple menu details retrievals for different menus\n- Multiple field definition fetches for all models in traversal path\n- Report measures computation when needed for pivot/graph\n\n**Never split these into sequential messages unless retry forced**\n\n## 7. Error Handling & Retry Logic\n- Retry if necessary (max 5 attempts)\n- **CRITICAL**: Do not explain reason of retry. For terminating tool, call it as usual with proper `__end_message`.\n\n### 7.1 Retry Triggers (max 5 attempts)\n- JSON syntax errors\n- Invalid field/domain\n- Missing measure\n- Unsupported view (fallback to list)\n\n### 7.2 Retry Adaptation Rules (MANDATORY)\n\n**Every retry MUST**:\n1. **Fix the root cause**: Parse error signal and fix THAT specific issue\n2. **Correct the wrong parameters**\n3. **Avoid repeating identical payload**\n\n**Final Fallback**: After max retries, emit best simplified action. Add avery simple explanation in `__end_message`.\n\n## 8. Field Validation (MANDATORY for custom_domain)\n\n### 8.1 Core Rules\n- **Verify EVERY hop with field inspection tool**\n- **Non-relational types terminate traversal**: char, float, integer, boolean, date, datetime, selection, monetary\n- **Only literal RHS values** - never compare field to field\n\n### 8.2 Field Existence Invariant (Prevents Guessing Errors)\n\n**Path Expansion Algorithm (MANDATORY)**:\n1. **Start**: Root model's field definitions (fetch if missing)\n2. **For each hop** (except final):\n   - Confirm field exists VERBATIM in current model\n   - Get target model from relation type\n   - Fetch target model's fields if not already fetched\n   - Advance to target model\n3. **Final segment**: Must exist verbatim - never guess\n\n**ABSOLUTE RULES**:\n- **No Guessing**: Never alter `_id` vs `_ids`, never guess pluralization\n- **Exact Matches Only**: Use exact field names from field inspection\n- **Evidence Required**: Must have fetched ALL models in path before using\n- **Batch Fetching**: Collect all needed models, fetch in single batch\n- **Search Constraint**: If relational attribute needed, MUST use `custom_domain`, not search\n\n**Example Path Validation**:\n```\nPath: lines.product_id.pos_categ_ids.name\nRequired fetches: pos.order, pos.order.line, product.product, pos.category\nAll must be fetched BEFORE constructing domain\n```\n\n**Violation = Invalid Answer**: Must self-correct before sending\n\n## 9. Special Cases\n\n### 9.1 Location Handling (Countries & Regions)\n\n**Core Principle**: Use ISO country codes, but STILL validate every field via field inspection\n\n**Rules**:\n1. **Always Fetch Fields**: Even for `country_id.code`, verify path including `res.country`\n2. **Region Mapping**: Convert regions to ISO codes → `country_id.code in [...]`\n   - Europe/EU → European country codes\n   - APAC → Asia-Pacific codes\n   - LATAM → Latin American codes\n3. **Never Use Fuzzy**: Avoid `country_group_ids`, `continent`, `ilike 'europe'`\n4. **Cities**: Use the condition `["city", "ilike", <city>]` after verifying field exists\n\n### 9.2 Ordering & Ranking\n\n**Pivot**: Add ordering in measures array\n- Example: `["amount_total desc"]` for top values\n\n**Graph**: Use `order` parameter\n- Values: `ASC` or `DESC`\n- Combine with `mode` and grouping\n\n## 10. Examples (Shows Correct Parameter Usage)\n\n### CRITICAL: search, filters and custom_domain Complement Each Other\n\n**CORRECT - Combining search and custom domain (they are ANDed)**:\n```\n# search handles simple fields, custom_domain adds complex conditions\nopen_menu_list(859, "pos.order", [], [],\n  ["config_id=restaurant"],  # Simple field in search\n  custom_domain="[[\\"lines.product_id.categ_id.name\\",\\"ilike\\",\\"drinks\\"]]",  # Complex in domain\n  __end_message="Restaurant POS orders containing drinks")\n```\n\n**WRONG - Dotted paths in search**:\n```\n# NEVER DO THIS:\nopen_menu_list(859, "pos.order", [], [],\n  ["lines.product_id.categ_id=drinks"],  # WRONG: dotted path not allowed in search!\n  __end_message="...")\n```\n\n### Pivot/Graph Examples\n```\n# Top customers (pivot with ordering)\nopen_menu_pivot(172, "sale.order", ["confirmed"], ["partner_id"], [], ["amount_total desc"], [], __end_message="Top customers by revenue")\n\n# Sales by person (graph)\nopen_menu_graph(456, "sale.order", [], ["user_id"], "amount_total", "bar", "DESC", [], __end_message="Sales by salesperson")\n```\n\n### Adjust Search Examples\n```\n# Add filter\nadjust_search(toggle_filters=["draft"], __end_message="Including drafts")\n\n# Switch view\nadjust_search(switch_view_type="kanban", toggle_groupbys=["stage_id"], __end_message="Kanban by stage")\n\n# Add domain for amount threshold\nadjust_search(custom_domain="[[\\"amount_total\\",\\">=\\",500]]", __end_message="Amount ≥ 500")\n```\n\n### Fallback Example\nIf pivot unsupported → fallback to list:\n```\nopen_menu_list(..., __end_message="Pivot not available; showing list instead")\n```\n        	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
2	1	1	Information retrieval	Collection of tools to retrieve information about the models	# Odoo Search Agent\n\n## Purpose\n\nYou are a search agent designed to answer user queries using information that you retrieve from Odoo models.\n\nYou will use tool functions to retrieve the relevant information that you need to answer the user query.\n\n## Reinforcing role\n\nYou have knowledge of an odoo developer and you are an expert in creating search domains that are valid for the odoo ORM.\n\n## Odoo Etymology\n\n- When speaking about call, the user is most likely speaking about call activities, not voip calls. If he wants to refer to voip, he will specifically prompt for that.\n- In CRM, when speaking about opportunities, only include opportunities, not leads unless specifically prompted to do so.\n\n## Workflow\n\nYour workflow will be divided into several steps:\n\n### 1. Fields retrieval\n\nFirstly, based on the available models provided by this prompt, you will select the ones that are relevant for answering the user prompt, and use the get_fields tool to retrieve the fields of the chosen models. This step MUST be done in parallel, you don't need the answer of the first query to retrieve information about the other models.\n\n### 2. Search\n\nSecondly, based on the information you have about the models and their fields, you will construct an Odoo domain that will help you retrieve the information you need for the query. This query will be used by the search tool to give you actual information about the model instances. If you get an error back from the search tool, you must retry until you get a proper answer. For the search tool, you must also provide a list of fields of the model on which the search will be applied. You must EXCLUSIVELY use the fields you retrieve from the get_fields tool call, these will be used to filter what information is returned from the search.\n\n**IMPORTANT**\n\n- When creating the domain, you MUST ensure that the fields you use exist. For that you should always use the `get_fields` tool call to retrieve existing fields.\n\n### 3. Analysis\n\nYou must analyse the results you get from the tool calls to give an answer to the user. You must always provide an answer even if you can't solve the initial user query.\n\nYou MUST continue the tool calling until you have an answer to the inital user prompt.\n\nWhen giving your answer, you must not mention Odoo specific elements, you must answer the query assuming that  the receiving end doesn't know anything about Odoo at all.\n\nIf you do not find any results that can help you solve the user query, just say that you didn't find any information that can help you solve the query.\n\nExamples:\n\n**Question**: Give me all the users in the US, and their names\n- **GOOD Answer**: Here are all the users I found in the US: Mitchell Admin, Marc Demo, etc.\n- **BAD Answer**: I retrieved the users in the US.\n\n**IMPORTANT**\n\n- For monetary values, always include the currency in your responses.\n\n## Domain format\n\nYou MUST produce an Odoo domain which can be safely parsed as JSON. This means that tuples should be replaced by regular array.\n\nThe domain syntax applies to the `domain`, and the `having` parameters you have to provide for the `search`, and `read_group `tools\n\nEach domain that you provide to the search function should follow the following rules:\n\n- A domain is of the following format `[field_name, operator, field_value]`, field_name and operator should be in the string format. The field value can either be a single value that correspond to the field type OR it can also be another domain (e.g. ["name", "=", "Paul"], ["user_id", "in", ["name", "=", "Paul"]]).\n- Each domain can also be combined using boolean operators `|` and `&` e.g. `["|", domain1, domain2]`,  `["&", domain1, domain2]`. The boolean operators should be specified in string format.\n- When working with time, you MUST ALWAYS ask information using the UTC format with the tools. Only the answers you give should be in the user time.\n- Lastly, you MUST ensure that the resulting domain can be parsed in JSON format from python. This means that the domain is valid JSON, you must not include any python expression, and the string MUST be double-quoted.\n\nExamples:\n\n- [["user_id", "in", [1,2,3]]\n- [["name", "=", "Mitchell Admin"]]\n- [["name", "=", "Mitchell Admin"], ["age", ">=", 30]]\n- ["|", ["name", "=", "Mitchell Admin"], ["name", "=", "Marc Demo"]]\n\n### Operators\n\nWhen constructing a domain you have access to the following operators:\n\n- '=': the property is exactly equal to the value,\n- '!=': the property is different from the value,\n- '>': the property is greater than the value,\n- '>=': the property is greater or equal to the value\n- '<': the property is less than the value,\n- '<=': the property is less or equal to the `field_value`,\n- '=?': unset or equal, it returns true if the property is either `None` or `False`, otherwise it behaves like `=`,\n- '=like': matches the `field_name` against the `field_value` pattern. An underscore `_` in the pattern stands for any single character; a percent sign `%` matches any string of 0 or more characters,\n- 'like': matches `field_name` against the `%field_value%` pattern. Similar to `=like` but wraps `field_value` with '%' before matching,\n- 'not like': doesn't match against the `%field_value%` pattern,\n- 'ilike': case insensitive `like`,\n- '=ilike': case insensitive `=like`,\n- 'in': is equal to any of the items from the `field_value`, where `field_value` is a list of items,\n- 'not in': is unequal to all the items from `field_value`,\n- 'child_of': is a child of a `field_value` record, the `field_value` can either be one item or a list of items. Takes the semantics of the model into account (i.e following the relationship field named by \\_parent_name),\n- 'parent_or': the is a parent of a `field_value` record, the `field_value` can either be one item or a list of items. Takes the semantics of the model into account (i.e following the relationship field named by \\_parent_name),\n- 'any': matches if any record in the relationship traversal through `field_name` (Many2one, One2many, or Many2many) satisfies the provided domain value,\n- 'not any': matches if no record in the relationship traversal through `field_name` (Many2one, One2many, or Many2many) satisfies the provided domain value.\n\n#### Combining domains\n\nSimple domains can be combined using boolean operators:\n\n- '&': logical AND, used as `[ "&", domain1, domain2]`, ensures that `domain1` and `domain2` are true at the same time,\n- '|': logical OR, used as `["|", domain1, domain2]`, ensures that at least one of `domain1` or `domain2` is true,\n- '!': logical NOT, used as `["!", domain1]`, ensures that `domain1` is false. Applies to the next domain ONLY.\n\nCONSTRAINTS:\n- You MUST NOT have more than one operator in a row.\n\n## Fields format\n\nThe fields you provide for filtering must be in JSON array format, each element of the array is a string retrieved from a `get_fields` tool call.\n\n## Tool usage\n\n**read_group**\n\n- When using read_group, you MUST ensure that fields use in the `order` parameter exits. DO NOT make up any field name. i.e. For an aggregate `amount_total:sum`, the valid order is `amount_total:sum`.\n        	2026-01-08 15:34:00.245272	2026-01-08 15:34:00.245272
\.


--
-- Data for Name: ai_topic_ir_act_server_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_topic_ir_act_server_rel (ai_topic_id, ir_act_server_id) FROM stdin;
1	251
1	252
1	253
1	254
1	255
1	256
1	257
1	258
2	252
2	259
2	260
\.


--
-- Data for Name: auth_passkey_key; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_passkey_key (id, sign_count, create_uid, write_uid, name, credential_identifier, create_date, write_date, public_key) FROM stdin;
\.


--
-- Data for Name: auth_passkey_key_create; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_passkey_key_create (id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, expiration_date, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_rate_limit_log; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_rate_limit_log (id, user_id, create_uid, write_uid, ip, limit_type, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_module; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_module (id, create_uid, write_uid, state, import_message, modules_dependencies, force, with_demo, create_date, write_date, module_file) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, model_id, create_uid, write_uid, name, lang, format, export_type, domain, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
1	1	1	t	2026-01-08 15:33:42.668518	2026-01-08 15:33:42.668518
2	1	1	t	2026-01-08 15:33:42.668518	2026-01-08 15:33:42.668518
\.


--
-- Data for Name: base_module_install_request; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_request (id, module_id, user_id, create_uid, write_uid, body_html, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_install_review; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_review (id, module_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall_ir_module_module_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall_ir_module_module_rel (base_module_uninstall_id, ir_module_module_id) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
1	1	1	["39475-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"res.users":[{"id":1,"notification_type":"inbox"}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
2	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"avatar_cache_key":"ba7a24e06b8cb2d90bde5708683ace596501333487d119e4c751d2c15d9284f584d89f176ff54fb4407a45533380450e5c786e3fba590162de6997b50f2f2e56","channel_type":"channel","create_uid":1,"default_display_mode":false,"description":"General channel for administrators.","from_message_id":false,"group_ids":[4],"group_public_id":4,"id":2,"invited_member_ids":[["ADD",[]]],"last_interest_dt":"2026-01-08 15:33:48","member_count":1,"name":"Administrators","parent_channel_id":false,"rtc_session_ids":[["ADD",[]]],"uuid":"ChhD2UZgYb"}],"discuss.channel.member":[{"channel_id":{"id":2,"model":"discuss.channel"},"id":1,"partner_id":3,"unpin_dt":false}],"res.groups":[{"full_name":"Role / Administrator","id":4}],"res.partner":[{"active":true,"avatar_128_access_token":"af27a1756684973f3d8cdcf95724b8e9333fe815c31e65b0aa3daa781ae4b532o0x6986ad78","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"894a9785819384932d5af2862f6561facb9b2610b129d2d9c4bf225ff7fe5f24o0x69862289","is_company":false,"main_user_id":2,"mention_token":"b7b72668743363a63e7194375d953557ba9e9b65b3a9880a9ac8618d284f1052o0x69817625","name":"Mitchell Admin","write_date":"2026-01-08 15:33:48"}],"res.users":[{"id":2,"share":false}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
3	1	1	["39475-19-0-all-without-test","discuss.channel",1]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"group_ids":[1],"id":1}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
4	1	1	["39475-19-0-all-without-test","res.partner",6]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"avatar_cache_key":"a366d7792e80198ff405df90d3c2edf837bcf3797e5c1570a7030502b7239458d51b48b716a0729353493a7ebab64470d6a6bbb1603ff8dba524ca3fd992f955","channel_type":"channel","create_uid":1,"default_display_mode":false,"description":"General announcements for all employees.","from_message_id":false,"group_ids":[1],"group_public_id":1,"id":1,"invited_member_ids":[["ADD",[]]],"last_interest_dt":"2026-01-08 15:33:48","member_count":2,"name":"general","parent_channel_id":false,"rtc_session_ids":[["ADD",[]]],"uuid":"ozTRHB7tMi"}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"id":3,"partner_id":6,"unpin_dt":false}],"res.groups":[{"full_name":"Role / User","id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"a4cc5c852fa123eb0427d5f6919d45ceb611eff6fc5126c8a8375fd8043a70f6o0x6986b0ee","email":"mark.brown23@example.com","id":6,"im_status":"offline","im_status_access_token":"308e6bf61339a66ad23ceccb2882e1f4964e7b6c5e8d1a365e8c5e89b16c2fb2o0x698625c8","is_company":false,"main_user_id":5,"mention_token":"ec43354804ea1cdb37059ad01b6281518f2ba67fa4e16b3227daac356050d380o0x698177e0","name":"Marc Demo","write_date":"2026-01-08 15:33:48"}],"res.users":[{"id":5,"share":false}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
5	1	1	["39475-19-0-all-without-test","res.groups",1]	{"type":"mail.record/insert","payload":{"mail.canned.response":[{"id":1,"source":"hello","substitution":"Hello, how may I help you?"}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
6	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
7	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
8	1	1	["39475-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-01-08 15:33:48","fetched_message_id":1,"id":2,"last_seen_dt":false,"partner_id":3,"seen_message_id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"af27a1756684973f3d8cdcf95724b8e9333fe815c31e65b0aa3daa781ae4b532o0x6986ad78","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"894a9785819384932d5af2862f6561facb9b2610b129d2d9c4bf225ff7fe5f24o0x69862289","is_company":false,"main_user_id":2,"mention_token":"b7b72668743363a63e7194375d953557ba9e9b65b3a9880a9ac8618d284f1052o0x69817625","name":"Mitchell Admin","write_date":"2026-01-08 15:33:48"}],"res.users":[{"id":2,"share":false}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
9	1	1	["39475-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-01-08 15:33:48","fetched_message_id":1,"id":2,"last_seen_dt":false,"partner_id":3,"seen_message_id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"af27a1756684973f3d8cdcf95724b8e9333fe815c31e65b0aa3daa781ae4b532o0x6986ad78","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"894a9785819384932d5af2862f6561facb9b2610b129d2d9c4bf225ff7fe5f24o0x69862289","is_company":false,"main_user_id":2,"mention_token":"b7b72668743363a63e7194375d953557ba9e9b65b3a9880a9ac8618d284f1052o0x69817625","name":"Mitchell Admin","write_date":"2026-01-08 15:33:48"}],"res.users":[{"id":2,"share":false}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
10	1	1	["39475-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-01-08 15:33:48","fetched_message_id":false,"id":3,"last_seen_dt":false,"partner_id":6,"seen_message_id":false}],"res.partner":[{"active":true,"avatar_128_access_token":"a4cc5c852fa123eb0427d5f6919d45ceb611eff6fc5126c8a8375fd8043a70f6o0x6986b0ee","email":"mark.brown23@example.com","id":6,"im_status":"offline","im_status_access_token":"308e6bf61339a66ad23ceccb2882e1f4964e7b6c5e8d1a365e8c5e89b16c2fb2o0x698625c8","is_company":false,"main_user_id":5,"mention_token":"ec43354804ea1cdb37059ad01b6281518f2ba67fa4e16b3227daac356050d380o0x698177e0","name":"Marc Demo","write_date":"2026-01-08 15:33:48"}],"res.users":[{"id":5,"share":false}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
11	1	1	["39475-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-01-08 15:33:48","fetched_message_id":1,"id":2,"last_seen_dt":false,"partner_id":3,"seen_message_id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"af27a1756684973f3d8cdcf95724b8e9333fe815c31e65b0aa3daa781ae4b532o0x6986ad78","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"894a9785819384932d5af2862f6561facb9b2610b129d2d9c4bf225ff7fe5f24o0x69862289","is_company":false,"main_user_id":2,"mention_token":"b7b72668743363a63e7194375d953557ba9e9b65b3a9880a9ac8618d284f1052o0x69817625","name":"Mitchell Admin","write_date":"2026-01-08 15:33:48"}],"res.users":[{"id":2,"share":false}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
44	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-2}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
45	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
46	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
12	1	1	["39475-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-01-08 15:33:48","fetched_message_id":false,"id":3,"last_seen_dt":false,"partner_id":6,"seen_message_id":false}],"res.partner":[{"active":true,"avatar_128_access_token":"a4cc5c852fa123eb0427d5f6919d45ceb611eff6fc5126c8a8375fd8043a70f6o0x6986b0ee","email":"mark.brown23@example.com","id":6,"im_status":"offline","im_status_access_token":"308e6bf61339a66ad23ceccb2882e1f4964e7b6c5e8d1a365e8c5e89b16c2fb2o0x698625c8","is_company":false,"main_user_id":5,"mention_token":"ec43354804ea1cdb37059ad01b6281518f2ba67fa4e16b3227daac356050d380o0x698177e0","name":"Marc Demo","write_date":"2026-01-08 15:33:48"}],"res.users":[{"id":5,"share":false}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
13	1	1	["39475-19-0-all-without-test","res.groups",1]	{"type":"mail.record/insert","payload":{"mail.canned.response":[{"id":2,"source":"bye","substitution":"Thanks for your feedback. Goodbye!"}]}}	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
14	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
15	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
16	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
17	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
18	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-3}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
19	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
20	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"avatar_cache_key":"a366d7792e80198ff405df90d3c2edf837bcf3797e5c1570a7030502b7239458d51b48b716a0729353493a7ebab64470d6a6bbb1603ff8dba524ca3fd992f955","channel_type":"channel","create_uid":1,"default_display_mode":false,"description":"General announcements for all employees.","from_message_id":false,"group_ids":[1],"group_public_id":1,"id":1,"invited_member_ids":[["ADD",[]]],"last_interest_dt":"2026-01-08 15:33:48","member_count":2,"name":"general","parent_channel_id":false,"rtc_session_ids":[["ADD",[]]],"uuid":"ozTRHB7tMi"}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"id":12,"partner_id":3,"unpin_dt":false}],"hr.employee":[{"id":1,"leave_date_to":false}],"res.groups":[{"full_name":"Role / User","id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"af27a1756684973f3d8cdcf95724b8e9333fe815c31e65b0aa3daa781ae4b532o0x6986ad78","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"894a9785819384932d5af2862f6561facb9b2610b129d2d9c4bf225ff7fe5f24o0x69862289","is_company":false,"main_user_id":2,"mention_token":"b7b72668743363a63e7194375d953557ba9e9b65b3a9880a9ac8618d284f1052o0x69817625","name":"Database Support","write_date":"2026-01-08 15:33:56"}],"res.users":[{"employee_ids":[1],"id":2,"share":false}]}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
21	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
22	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
23	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
24	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-3}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
25	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
26	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
27	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
28	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
29	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
30	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
31	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
32	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
33	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
34	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
35	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
36	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-2}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
37	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
38	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
39	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
40	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_deleted":true,"count_diff":-1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
41	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
42	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
43	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
47	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
48	1	1	["39475-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
\.


--
-- Data for Name: calendar_alarm; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_alarm (id, duration, duration_minutes, mail_template_id, create_uid, write_uid, alarm_type, "interval", name, body, notify_responsible, create_date, write_date, sms_template_id) FROM stdin;
6	3	180	10	1	1	email	hours	{"en_US": "Email - 3 Hours", "es_419": "Correo electrónico - 3 horas"}	\N	f	2026-01-08 15:33:51.033182	2026-01-08 15:33:54.463904	\N
7	6	360	10	1	1	email	hours	{"en_US": "Email - 6 Hours", "es_419": "Correo electrónico - 6 horas"}	\N	f	2026-01-08 15:33:51.033182	2026-01-08 15:33:54.463904	\N
5	1	1440	\N	1	1	notification	days	{"en_US": "Notification - 1 Days", "es_419": "Notificación - 1 día"}	\N	f	2026-01-08 15:33:51.033182	2026-01-08 15:33:54.463904	\N
3	1	60	\N	1	1	notification	hours	{"en_US": "Notification - 1 Hours", "es_419": "Notificación - 1 hora"}	\N	f	2026-01-08 15:33:51.033182	2026-01-08 15:33:54.463904	\N
1	15	15	\N	1	1	notification	minutes	{"en_US": "Notification - 15 Minutes", "es_419": "Notificación - 15 minutos"}	\N	f	2026-01-08 15:33:51.033182	2026-01-08 15:33:54.463904	\N
4	2	120	\N	1	1	notification	hours	{"en_US": "Notification - 2 Hours", "es_419": "Notificación - 2 horas"}	\N	f	2026-01-08 15:33:51.033182	2026-01-08 15:33:54.463904	\N
2	30	30	\N	1	1	notification	minutes	{"en_US": "Notification - 30 Minutes", "es_419": "Notificación - 30 minutos"}	\N	f	2026-01-08 15:33:51.033182	2026-01-08 15:33:54.463904	\N
\.


--
-- Data for Name: calendar_alarm_calendar_event_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_alarm_calendar_event_rel (calendar_event_id, calendar_alarm_id) FROM stdin;
\.


--
-- Data for Name: calendar_attendee; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_attendee (id, event_id, partner_id, create_uid, write_uid, common_name, access_token, state, availability, create_date, write_date) FROM stdin;
1	1	8	1	1	Wood Corner	15106fc6dd4346e88dded341a926d48d	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
2	2	11	1	1	Ready Mat	5470691ae71f4aa79ceaa3917c5fecaf	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
3	2	10	1	1	Gemini Furniture	ef1aa375aa0a4862906ecd472840804b	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
4	2	2	1	1	OdooBot	4c5344cb95cf4ac883576e40a3846d8a	accepted	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
6	4	8	1	1	Wood Corner	c868b26b16404c51b9a49e367892b50f	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
7	4	6	1	1	Marc Demo	c42ad18af46f40758203298185cb7cf4	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
9	5	15	1	1	Azure Interior	84b037eaf9f34a6da1aed01cef62382a	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
10	6	8	1	1	Wood Corner	8a38a1e3c0e24d8c996b73a5ca6b0916	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
11	6	2	1	1	OdooBot	cc07838b0cc2459eb0e50f81ed0efb30	accepted	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
12	6	11	1	1	Ready Mat	d4e012182b524add92fec64426736c6d	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
13	6	15	1	1	Azure Interior	3b7ce88f6d4b4b3db673f49134d6bb2a	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
14	7	11	1	1	Ready Mat	920e745b91ad4fb48a120ee60b0de23e	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
5	3	3	1	1	Database Support	bc5796bdf26042638543412a59f48697	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:53.332923
8	5	3	1	1	Database Support	d3396446f57e48a79332b22ec95ffa8e	needsAction	\N	2026-01-08 15:33:51.033182	2026-01-08 15:33:53.332923
15	8	3	2	1	Database Support	5e8c94b378e1417ca4247553580d32e0	accepted	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
16	9	43	1	1	Ronnie Hart	38782bd7d358495e89a4882b4b3f597e	needsAction	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
17	10	43	1	1	Ronnie Hart	2f218792fd784478a8cd60e3166d7d96	needsAction	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
18	11	53	1	1	Anita Oliver	5bbcf3dad0cc48459cbd566429fa0f24	needsAction	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
19	12	53	1	1	Anita Oliver	91493567fc98414cb17cc57aa5ba0aa3	needsAction	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
20	13	6	5	1	Marc Demo	65acd3660f954742a7c9aa2774ac08d9	accepted	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
21	14	6	5	1	Marc Demo	130e11da58b5450b9b9ca51dbab46a5e	accepted	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
22	15	54	1	1	Sharlene Rhodes	330a3a4fe1374747bfbfd96f741e3938	needsAction	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
23	16	54	1	1	Sharlene Rhodes	d32262c141bb4157a4e9bd112240fd89	needsAction	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
24	17	57	1	1	Paul Williams	c497462402e340a3812c448401d365ad	needsAction	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
25	18	57	1	1	Paul Williams	30c33bf250ee4cc3ace5b7f34fb35dd9	needsAction	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
\.


--
-- Data for Name: calendar_event; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_event (id, user_id, videocall_channel_id, res_id, res_model_id, recurrence_id, create_uid, write_uid, name, location, videocall_location, access_token, privacy, show_as, res_model, start_date, stop_date, description, notes, active, allday, recurrency, follow_recurrence, start, stop, create_date, write_date, duration) FROM stdin;
1	2	\N	0	\N	\N	1	1	Follow-up for Project proposal	\N	\N	\N	\N	busy	\N	\N	\N	<div>Meeting to discuss project plan and hash out the details of implementation.<br><strong>Organized by</strong><br>Mitchell Admin<br><a href="mailto:admin@example.com">admin@example.com</a><br><a href="tel:+1%20555-555-5555">+1 555-555-5555</a><br><br><strong>Contact Details</strong><br>Wood Corner<br><a href="mailto:wood.corner26@example.com">wood.corner26@example.com</a><br><a href="tel:(623)-853-7197">(623)-853-7197</a></div>	\N	t	f	\N	f	2026-01-03 10:20:00	2026-01-03 16:30:00	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182	6.3
2	5	\N	0	\N	\N	1	1	Initial discussion	\N	\N	\N	\N	busy	\N	\N	\N	<div>Discussion with partner for product.<br><strong>Organized by</strong><br>Marc Demo<br><a href="mailto:mark.brown23@example.com">mark.brown23@example.com</a><br><a href="tel:(441)-695-2334">(441)-695-2334</a><br><br><strong>Contact Details</strong><br>Gemini Furniture<br><a href="mailto:gemini_furniture@fake.geminifurniture.com">gemini_furniture@fake.geminifurniture.com</a><br><a href="tel:+378%200549%20885555">+378 0549 885555</a></div>	\N	t	f	\N	f	2026-01-05 12:00:00	2026-01-05 19:00:00	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182	7
3	2	\N	0	\N	\N	1	1	Pricing Discussion	\N	\N	\N	\N	busy	\N	\N	\N	<div>Internal meeting for discussion for new pricing for product and services.<br><strong>Organized by</strong><br>Mitchell Admin<br><a href="mailto:admin@example.com">admin@example.com</a><br><a href="tel:+1%20555-555-5555">+1 555-555-5555</a></div>	\N	t	f	\N	f	2026-01-12 15:55:05	2026-01-12 18:55:05	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182	3
4	5	\N	0	\N	\N	1	1	Requirements review	\N	\N	\N	\N	busy	\N	\N	\N	<div><strong>Organized by</strong><br>Marc Demo<br><a href="mailto:mark.brown23@example.com">mark.brown23@example.com</a><br><a href="tel:(441)-695-2334">(441)-695-2334</a><br><br><strong>Contact Details</strong><br>Wood Corner<br><a href="mailto:wood.corner26@example.com">wood.corner26@example.com</a><br><a href="tel:(623)-853-7197">(623)-853-7197</a></div>	\N	t	f	\N	f	2026-01-20 08:00:00	2026-01-20 10:30:00	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182	2.5
6	5	\N	0	\N	\N	1	1	Presentation for new Services	\N	\N	\N	\N	busy	\N	\N	\N	<div><strong>Organized by</strong><br>Marc Demo<br><a href="mailto:mark.brown23@example.com">mark.brown23@example.com</a><br><a href="tel:(441)-695-2334">(441)-695-2334</a><br><br><strong>Contact Details</strong><br>Wood Corner<br><a href="mailto:wood.corner26@example.com">wood.corner26@example.com</a><br><a href="tel:(623)-853-7197">(623)-853-7197</a></div>	\N	t	f	\N	f	2026-01-18 02:00:00	2026-01-18 10:30:00	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182	8.5
7	5	\N	0	\N	\N	1	1	Presentation of the new Calendar	\N	\N	\N	\N	busy	\N	2026-01-16	2026-01-16	<div><strong>Organized by</strong><br>Marc Demo<br><a href="mailto:mark.brown23@example.com">mark.brown23@example.com</a><br><a href="tel:(441)-695-2334">(441)-695-2334</a><br><br><strong>Contact Details</strong><br>Ready Mat<br><a href="mailto:ready.mat28@example.com">ready.mat28@example.com</a><br><a href="tel:(803)-873-6126">(803)-873-6126</a></div>	\N	t	t	\N	f	2026-01-16 00:00:00	2026-01-16 00:00:00	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182	8.5
5	2	\N	0	\N	\N	1	1	Changes in Designing	\N	\N	\N	\N	busy	\N	2026-01-22	2026-01-22	<div><strong>Organized by</strong><br>Mitchell Admin<br><a href="mailto:admin@example.com">admin@example.com</a><br><a href="tel:+1%20555-555-5555">+1 555-555-5555</a><br><br><strong>Contact Details</strong><br>Azure Interior<br><a href="mailto:azure.Interior24@example.com">azure.Interior24@example.com</a><br><a href="tel:(870)-931-0505">(870)-931-0505</a></div>	\N	t	t	\N	f	2026-01-22 00:00:00	2026-01-22 00:00:00	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182	0
8	2	\N	2	423	\N	2	1	Database Support on Time Off : 3 days	\N	\N	\N	confidential	busy	hr.leave	2026-01-26	2026-01-28	<div><strong>Organized by</strong><br>Database Support<br><a href="mailto:admin@example.com">admin@example.com</a><br><a href="tel:+1%20555-555-5555">+1 555-555-5555</a></div>	\N	t	t	\N	f	2026-01-26 08:00:00	2026-01-28 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	22.799999999999997
9	\N	\N	3	423	\N	1	1	Ronnie Hart on Time Off : 5 days	\N	\N	\N	confidential	busy	hr.leave	2026-01-14	2026-01-20	<div><strong>Contact Details</strong><br>Ronnie Hart<br><a href="mailto:ronnie.hart87@example.com">ronnie.hart87@example.com</a><br><a href="tel:(555)-310-7863">(555)-310-7863</a></div>	\N	t	t	\N	f	2026-01-14 08:00:00	2026-01-20 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	38
10	\N	\N	4	423	\N	1	1	Ronnie Hart on Time Off : 3 days	\N	\N	\N	confidential	busy	hr.leave	2026-02-23	2026-02-25	<div><strong>Contact Details</strong><br>Ronnie Hart<br><a href="mailto:ronnie.hart87@example.com">ronnie.hart87@example.com</a><br><a href="tel:(555)-310-7863">(555)-310-7863</a></div>	\N	t	t	\N	f	2026-02-23 08:00:00	2026-02-25 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	22.799999999999997
11	\N	\N	5	423	\N	1	1	Anita Oliver on Time Off : 5 days	\N	\N	\N	confidential	busy	hr.leave	2026-01-22	2026-01-28	<div><strong>Contact Details</strong><br>Anita Oliver<br><a href="mailto:anita.oliver32@example.com">anita.oliver32@example.com</a><br><a href="tel:(555)-497-4804">(555)-497-4804</a></div>	\N	t	t	\N	f	2026-01-22 08:00:00	2026-01-28 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	38
12	\N	\N	6	423	\N	1	1	Anita Oliver on Time Off : 3 days	\N	\N	\N	confidential	busy	hr.leave	2026-01-05	2026-01-07	<div><strong>Contact Details</strong><br>Anita Oliver<br><a href="mailto:anita.oliver32@example.com">anita.oliver32@example.com</a><br><a href="tel:(555)-497-4804">(555)-497-4804</a></div>	\N	t	t	\N	f	2026-01-05 08:00:00	2026-01-07 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	22.799999999999997
13	5	\N	7	423	\N	5	1	Marc Demo on Time Off : 3 days	\N	\N	\N	confidential	busy	hr.leave	2026-02-09	2026-02-11	<div><strong>Organized by</strong><br>Marc Demo<br><a href="mailto:mark.brown23@example.com">mark.brown23@example.com</a><br><a href="tel:(441)-695-2334">(441)-695-2334</a></div>	\N	t	t	\N	f	2026-02-09 08:00:00	2026-02-11 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	22.799999999999997
14	5	\N	8	423	\N	5	1	Marc Demo on Time Off : 3 days	\N	\N	\N	confidential	busy	hr.leave	2026-01-05	2026-01-07	<div><strong>Organized by</strong><br>Marc Demo<br><a href="mailto:mark.brown23@example.com">mark.brown23@example.com</a><br><a href="tel:(441)-695-2334">(441)-695-2334</a></div>	\N	t	t	\N	f	2026-01-05 08:00:00	2026-01-07 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	22.799999999999997
15	\N	\N	9	423	\N	1	1	Sharlene Rhodes on Time Off : 6 days	\N	\N	\N	confidential	busy	hr.leave	2026-01-09	2026-01-16	<div><strong>Contact Details</strong><br>Sharlene Rhodes<br><a href="mailto:sharlene.rhodes49@example.com">sharlene.rhodes49@example.com</a><br><a href="tel:(555)-719-4182">(555)-719-4182</a></div>	\N	t	t	\N	f	2026-01-09 08:00:00	2026-01-16 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	45.599999999999994
16	\N	\N	10	423	\N	1	1	Sharlene Rhodes on Time Off : 3 days	\N	\N	\N	confidential	busy	hr.leave	2026-01-26	2026-01-28	<div><strong>Contact Details</strong><br>Sharlene Rhodes<br><a href="mailto:sharlene.rhodes49@example.com">sharlene.rhodes49@example.com</a><br><a href="tel:(555)-719-4182">(555)-719-4182</a></div>	\N	t	t	\N	f	2026-01-26 08:00:00	2026-01-28 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	22.799999999999997
17	\N	\N	11	423	\N	1	1	Paul Williams on Time Off : 1 days	\N	\N	\N	confidential	busy	hr.leave	2026-02-02	2026-02-02	<div><strong>Contact Details</strong><br>Paul Williams<br><a href="mailto:paul.williams59@example.com">paul.williams59@example.com</a><br><a href="tel:(555)-262-1607">(555)-262-1607</a></div>	\N	t	t	\N	f	2026-02-02 08:00:00	2026-02-02 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	7.6
18	\N	\N	12	423	\N	1	1	Paul Williams on Time Off : 1 days	\N	\N	\N	confidential	busy	hr.leave	2026-05-06	2026-05-06	<div><strong>Contact Details</strong><br>Paul Williams<br><a href="mailto:paul.williams59@example.com">paul.williams59@example.com</a><br><a href="tel:(555)-262-1607">(555)-262-1607</a></div>	\N	t	t	\N	f	2026-05-06 08:00:00	2026-05-06 16:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	7.6
\.


--
-- Data for Name: calendar_event_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_event_res_partner_rel (res_partner_id, calendar_event_id) FROM stdin;
8	1
2	2
11	2
10	2
3	3
6	4
8	4
3	5
15	5
2	6
11	6
8	6
15	6
11	7
3	8
43	9
43	10
53	11
53	12
6	13
6	14
54	15
54	16
57	17
57	18
\.


--
-- Data for Name: calendar_event_type; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_event_type (id, color, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	10	1	1	Customer Meeting	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
2	9	1	1	Internal Meeting	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
3	3	1	1	Off-site Meeting	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
4	7	1	1	Open Discussion	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
5	5	1	1	Feedback Meeting	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
\.


--
-- Data for Name: calendar_filters; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_filters (id, user_id, partner_id, create_uid, write_uid, active, partner_checked, create_date, write_date) FROM stdin;
1	2	8	1	1	t	t	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
2	2	6	1	1	t	t	2026-01-08 15:33:51.033182	2026-01-08 15:33:51.033182
\.


--
-- Data for Name: calendar_popover_delete_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_popover_delete_wizard (id, template_id, calendar_event_id, create_uid, write_uid, lang, subject, delete, body, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: calendar_provider_config; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_provider_config (id, create_uid, write_uid, external_calendar_provider, cal_client_id, cal_client_secret, microsoft_outlook_client_identifier, microsoft_outlook_client_secret, cal_sync_paused, microsoft_outlook_sync_paused, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: calendar_recurrence; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.calendar_recurrence (id, base_event_id, "interval", count, day, trigger_id, create_uid, write_uid, name, event_tz, rrule, rrule_type, end_type, month_by, weekday, byday, until, mon, tue, wed, thu, fri, sat, sun, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: digest_digest; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.digest_digest (id, company_id, create_uid, write_uid, periodicity, state, next_run_date, name, kpi_res_users_connected, kpi_mail_message_total, create_date, write_date) FROM stdin;
1	1	1	1	daily	activated	2026-01-08	{"en_US": "Your Odoo Periodic Digest", "es_419": "Su resumen periódico de Odoo"}	t	t	2026-01-08 15:33:54.524606	2026-01-08 15:33:54.524606
\.


--
-- Data for Name: digest_digest_res_users_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.digest_digest_res_users_rel (digest_digest_id, res_users_id) FROM stdin;
1	2
\.


--
-- Data for Name: digest_tip; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.digest_tip (id, sequence, group_id, create_uid, write_uid, name, tip_description, create_date, write_date) FROM stdin;
6	3300	1	1	1	{"en_US": "Tip: Join the Dark Side", "es_419": "Consejo: Únase al lado oscuro"}	{"en_US": "<div>\\n    <p class=\\"tip_title\\">Tip: Join the Dark Side</p>\\n    <p class=\\"tip_content\\">Feeling eye strain? Give your eyes a break by switching to Dark Mode.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/18-web-dark-theme.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            ", "es_419": "<div>\\n    <p class=\\"tip_title\\">Consejo: Únase al lado oscuro</p>\\n    <p class=\\"tip_content\\">¿Necesita descansar su vista? Use el modo oscuro.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/18-web-dark-theme.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            "}	2026-01-08 15:33:54.524606	2026-01-08 15:33:54.524606
7	3800	1	1	1	{"en_US": "Tip: Personalize your Home Menu", "es_419": "Consejo: Personalice su menú principal"}	{"en_US": "<div>\\n    <p class=\\"tip_title\\">Tip: Personalize your Home Menu</p>\\n    <p class=\\"tip_content\\">Click and hold on a Menu Item to reorder your Apps to your liking.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/18-web-app-order.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            ", "es_419": "<div>\\n    <p class=\\"tip_title\\">Consejo: Personalice su menú principal</p>\\n    <p class=\\"tip_content\\">Haga clic y mantenga presionado un elemento del menú para reordenar sus aplicaciones a su gusto.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/18-web-app-order.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            "}	2026-01-08 15:33:54.524606	2026-01-08 15:33:54.524606
3	2300	1	1	1	{"en_US": "Tip: A calculator in Odoo", "es_419": "Consejo: una calculadora en Odoo"}	{"en_US": "<div>\\n    <p class=\\"tip_title\\">Tip: A calculator in Odoo</p>\\n    <p class=\\"tip_content\\">When editing a number, you can use formulae by typing the `=` character. This is useful when computing a margin or a discount on a quotation, sale order or invoice.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-calculator.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            ", "es_419": "<div>\\n    <p class=\\"tip_title\\">Consejo: una calculadora en Odoo</p>\\n    <p class=\\"tip_content\\">Cuando edite un número, puede utilizar fórmulas al escribir el carácter `=`. Esto es útil cuando calcula un margen o un descuento en una cotización, orden de venta o factura.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-calculator.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            "}	2026-01-08 15:33:54.524606	2026-01-08 15:33:54.524606
2	2100	1	1	1	{"en_US": "Tip: Click on an avatar to chat with a user", "es_419": "Consejo: haga clic en un avatar para chatear con un usuario"}	{"en_US": "<div>\\n    <p class=\\"tip_title\\">Tip: Click on an avatar to chat with a user</p>\\n    <p class=\\"tip_content\\">Have a question about a document? Click on the responsible user's picture to start a conversation. If his avatar has a green dot, he is online.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-avatar.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            ", "es_419": "<div>\\n    <p class=\\"tip_title\\">Consejo: haga clic en un avatar para chatear con un usuario</p>\\n    <p class=\\"tip_content\\">¿Tiene una pregunta sobre el documento? Haga clic en la fotografía del usuario responsable para iniciar una conversación. Si el avatar tiene un punto verde significa que el usuario está en línea.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-avatar.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            "}	2026-01-08 15:33:54.524606	2026-01-08 15:33:54.524606
4	2400	1	1	1	{"en_US": "Tip: How to ping users in internal notes?", "es_419": "Consejo: ¿cómo notificar usuarios en las notas internas?"}	{"en_US": "<div>\\n    <p class=\\"tip_title\\">Tip: How to ping users in internal notes?</p>\\n    <p class=\\"tip_content\\">Type \\"@\\" to notify someone in a message, or \\"#\\" to link to a channel. Try to notify @OdooBot to test the feature.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-notifications.png\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            ", "es_419": "<div>\\n    <p class=\\"tip_title\\">Consejo: ¿cómo notificar usuarios en las notas internas?</p>\\n    <p class=\\"tip_content\\">Escriba \\"@\\" para enviar una notificación a alguien por medio de un mensaje, o \\"#\\" para vincular un canal. Intente enviar una notificación a @OdooBot para probar esta función.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-notifications.png\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            "}	2026-01-08 15:33:54.524606	2026-01-08 15:33:54.524606
5	2500	1	1	1	{"en_US": "Tip: Knowledge is power", "es_419": "Consejo: el conocimiento es poder"}	{"en_US": "<div>\\n    <p class=\\"tip_title\\">Tip: Knowledge is power</p>\\n    <p class=\\"tip_content\\">When following documents, use the pencil icon to fine-tune the information you want to receive.\\nFollow a project / sales team to keep track of this project's tasks / this team's opportunities.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-following.png\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            ", "es_419": "<div>\\n    <p class=\\"tip_title\\">Consejo: el conocimiento es poder</p>\\n    <p class=\\"tip_content\\">Cuando siga documentos, use el icono de lápiz para ajustar la información que desea recibir.\\nSiga un proyecto o un equipo de ventas para llevar el seguimiento de las tareas de este proyecto o las oportunidades de este equipo.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-following.png\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            "}	2026-01-08 15:33:54.524606	2026-01-08 15:33:54.524606
1	800	1	1	1	{"en_US": "Tip: Speed up your workflow with shortcuts", "es_419": "Consejo: acelere su flujo de trabajo con atajos"}	{"en_US": "<div>\\n    <p class=\\"tip_title\\">Tip: Speed up your workflow with shortcuts</p>\\n    <p class=\\"tip_content\\">Press ALT in any screen to highlight shortcuts for every button in the screen. It is useful to process multiple documents in batch.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-alt-shortcuts.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            ", "es_419": "<div>\\n    <p class=\\"tip_title\\">Consejo: acelere su flujo de trabajo con atajos</p>\\n    <p class=\\"tip_content\\">Presione ALT en cualquier pantalla para destacar atajos para cada botón en la pantalla. Es útil para procesar varios documentos en lote.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/digest/static/src/img/milk-alt-shortcuts.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            "}	2026-01-08 15:33:54.524606	2026-01-08 15:33:54.524606
8	1900	1	1	1	{"en_US": "Tip: Navigate menus like a pro", "es_419": "Consejo: Domina la navegación por los menús"}	{"en_US": "<div>\\n                    <b class=\\"tip_title\\">Tip: Navigate menus like a pro</b>\\n                    <p class=\\"tip_content\\">From the Home page, start typing what you would like to access. Odoo will suggest menus matching your search. Use arrow keys and press enter to jump to your menu.</p>\\n                    <img src=\\"https://download.odoocdn.com/digests/digest_enterprise/static/src/img/milk-menu-navigation.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n                </div>\\n            ", "es_419": "<div>\\n                    <b class=\\"tip_title\\">Consejo: Domina la navegación por los menús</b>\\n                    <p class=\\"tip_content\\">Desde la página de inicio, empieza a escribir a qué deseas acceder. Odoo te sugerirá menús que coincidan con tu búsqueda. Usa las flechas del teclado y presiona Enter para ir al menú.</p>\\n                    <img src=\\"https://download.odoocdn.com/digests/digest_enterprise/static/src/img/milk-menu-navigation.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n                </div>\\n            "}	2026-01-08 15:33:54.682535	2026-01-08 15:33:54.682535
9	3400	4	1	1	{"en_US": "Tip: Your Business right in their pocket", "es_419": "Consejo: Tu negocio al alcance de tus clientes"}	{"en_US": "<div>\\n    <p class=\\"tip_title\\">Tip: Your Business right in their pocket</p>\\n    <p class=\\"tip_content\\">Connect your WhatsApp account to Odoo to receive inbound messages directly in your CRM.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/whatsapp/static/src/img/18-whatsapp-message-flow.png\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            ", "es_419": "<div>\\n    <p class=\\"tip_title\\">Consejo: Tu negocio al alcance de tus clientes</p>\\n    <p class=\\"tip_content\\">Conecta tu cuenta de WhatsApp a Odoo para recibir los mensajes en tu CRM.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/whatsapp/static/src/img/18-whatsapp-message-flow.png\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            "}	2026-01-08 15:33:54.682535	2026-01-08 15:33:54.682535
10	3500	19	1	1	{"en_US": "Tip: Where's Bryan?", "es_419": "Consejo: ¿Dónde está Brian?"}	{"en_US": "<div>\\n    <p class=\\"tip_title\\">Tip: Where's Bryan?</p>\\n    <p class=\\"tip_content\\">Activate Remote Work to let Employees specify where they are working from.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/hr/static/src/img/18-hr-work-location.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            ", "es_419": "<div>\\n    <p class=\\"tip_title\\">Consejo: ¿Dónde está Brian?</p>\\n    <p class=\\"tip_content\\">Habilite la función de trabajo remoto para permitir que los empleados especifiquen desde dónde están trabajando.</p>\\n    <img src=\\"https://download.odoocdn.com/digests/hr/static/src/img/18-hr-work-location.gif\\" width=\\"540\\" class=\\"illustration_border\\">\\n</div>\\n            "}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
\.


--
-- Data for Name: digest_tip_res_users_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.digest_tip_res_users_rel (digest_tip_id, res_users_id) FROM stdin;
\.


--
-- Data for Name: discuss_call_history; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_call_history (id, channel_id, start_call_message_id, create_uid, write_uid, start_dt, end_dt, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: discuss_channel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel (id, parent_channel_id, from_message_id, group_public_id, create_uid, write_uid, name, channel_type, default_display_mode, sfu_channel_uuid, sfu_server_url, uuid, description, active, last_interest_dt, create_date, write_date, ai_agent_id, ai_env_context) FROM stdin;
2	\N	\N	4	1	1	Administrators	channel	\N	\N	\N	ChhD2UZgYb	General channel for administrators.	t	2026-01-08 15:33:48	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419	\N	\N
1	\N	\N	1	1	1	general	channel	\N	\N	\N	ozTRHB7tMi	General announcements for all employees.	t	2026-01-08 15:33:48	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419	\N	\N
9	\N	\N	\N	1	1	Public Community	channel	\N	\N	\N	RxxJUaBUik	A space for engaging discussions among employees, partners, and the public.	t	2026-01-08 15:33:49	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419	\N	\N
3	\N	\N	1	1	1	sales	channel	\N	\N	\N	UX2wo8xtss	Discussion about best sales practices and deals.	t	2026-01-08 15:33:49	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419	\N	\N
4	\N	\N	1	1	1	board-meetings	channel	\N	\N	\N	EqL3nQWVcN	Board meetings, budgets, strategic plans	t	2026-01-08 15:33:49	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419	\N	\N
5	\N	\N	1	1	1	rd	channel	\N	\N	\N	TsQ7XFmcyE	Research and development discussion group	t	2026-01-08 15:33:49	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419	\N	\N
6	1	1	1	1	1	Welcome to the #general channel	channel	\N	\N	\N	LdPywqGscJ	\N	t	2026-01-08 15:33:49	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419	\N	\N
7	1	\N	1	1	1	Ideas & Suggestions	channel	\N	\N	\N	x3E7h8TzSp	\N	t	2026-01-08 15:33:49	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419	\N	\N
8	1	\N	1	1	1	Troubleshooting	channel	\N	\N	\N	ubIGaMmSaY	\N	t	2026-01-08 15:33:49	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419	\N	\N
\.


--
-- Data for Name: discuss_channel_hr_department_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_hr_department_rel (discuss_channel_id, hr_department_id) FROM stdin;
\.


--
-- Data for Name: discuss_channel_member; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_member (id, partner_id, guest_id, channel_id, fetched_message_id, seen_message_id, new_message_separator, rtc_inviting_session_id, create_uid, write_uid, custom_channel_name, custom_notifications, mute_until_dt, unpin_dt, last_interest_dt, last_seen_dt, create_date, write_date) FROM stdin;
3	6	\N	1	\N	\N	0	\N	1	1	\N	\N	\N	\N	2026-01-08 15:33:48	\N	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
6	6	\N	7	\N	\N	0	\N	1	1	\N	\N	\N	\N	2026-01-08 15:33:49	\N	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
8	6	\N	8	30	30	31	\N	1	1	\N	\N	\N	\N	2026-01-08 15:33:49	\N	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
9	3	\N	9	31	31	32	\N	1	1	\N	\N	\N	\N	2026-01-08 15:33:49	\N	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
10	6	\N	9	33	33	34	\N	1	1	\N	\N	\N	\N	2026-01-08 15:33:49	\N	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
11	\N	1	9	32	32	33	\N	1	1	\N	\N	\N	\N	2026-01-08 15:33:49	\N	2026-01-08 15:33:48.648419	2026-01-08 15:33:48.648419
12	3	\N	1	\N	\N	0	\N	1	1	\N	\N	\N	\N	2026-01-08 15:33:56	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
\.


--
-- Data for Name: discuss_channel_res_groups_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_res_groups_rel (discuss_channel_id, res_groups_id) FROM stdin;
2	4
1	1
\.


--
-- Data for Name: discuss_channel_rtc_session; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_rtc_session (id, channel_member_id, channel_id, partner_id, create_uid, write_uid, is_screen_sharing_on, is_camera_on, is_muted, is_deaf, write_date, create_date) FROM stdin;
\.


--
-- Data for Name: discuss_gif_favorite; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_gif_favorite (id, create_uid, write_uid, tenor_gif_id, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: discuss_voice_metadata; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_voice_metadata (id, attachment_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: email_template_attachment_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.email_template_attachment_rel (email_template_id, attachment_id) FROM stdin;
\.


--
-- Data for Name: employee_bank_account_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.employee_bank_account_rel (employee_id, bank_account_id) FROM stdin;
\.


--
-- Data for Name: employee_category_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.employee_category_rel (employee_id, category_id) FROM stdin;
1	3
1	2
2	3
2	1
3	3
4	3
4	2
5	3
5	6
7	3
7	4
10	3
13	3
13	4
13	5
14	3
15	3
15	6
16	3
17	3
17	6
\.


--
-- Data for Name: fetchmail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.fetchmail_server (id, port, object_id, priority, create_uid, write_uid, name, state, server, server_type, "user", password, script, error_message, configuration, active, is_ssl, attach, original, date, error_date, create_date, write_date, google_gmail_access_token_expiration, google_gmail_refresh_token, google_gmail_access_token, microsoft_outlook_access_token_expiration, microsoft_outlook_refresh_token, microsoft_outlook_access_token) FROM stdin;
\.


--
-- Data for Name: homework_location_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.homework_location_wizard (id, work_location_id, employee_id, create_uid, write_uid, date, weekly, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_bank_account_allocation_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_bank_account_allocation_wizard (id, employee_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_bank_account_allocation_wizard_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_bank_account_allocation_wizard_line (id, wizard_id, bank_account_id, sequence, create_uid, write_uid, amount_type, amount, trusted, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_contract_type; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_contract_type (id, sequence, country_id, create_uid, write_uid, code, name, create_date, write_date) FROM stdin;
9	1009	\N	1	1	Apprenticeship	{"en_US": "Apprenticeship", "es_419": "Prácticas"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
12	1012	\N	1	1	Employee	{"en_US": "Employee", "es_419": "Empleado"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
5	1005	\N	1	1	Full-Time	{"en_US": "Full-Time", "es_419": "Tiempo completo"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
3	1003	\N	1	1	Interim	{"en_US": "Interim", "es_419": "Provisional"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
7	1007	\N	1	1	Intern	{"en_US": "Intern", "es_419": "Becario"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
6	1006	\N	1	1	Part-Time	{"en_US": "Part-Time", "es_419": "Medio tiempo"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
1	1001	\N	1	1	Permanent	{"en_US": "Permanent", "es_419": "Permanente"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
4	1004	\N	1	1	Seasonal	{"en_US": "Seasonal", "es_419": "Por temporada"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
11	1011	\N	1	1	Statutory	{"en_US": "Statutory", "es_419": "Estatutario"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
8	1008	\N	1	1	Student	{"en_US": "Student", "es_419": "Estudiante"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
2	1002	\N	1	1	Temporary	{"en_US": "Temporary", "es_419": "Temporal"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
10	1010	\N	1	1	Thesis	{"en_US": "Thesis", "es_419": "Tesis"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
\.


--
-- Data for Name: hr_department; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_department (id, company_id, parent_id, manager_id, color, master_department_id, create_uid, write_uid, parent_path, name, note, active, create_date, write_date) FROM stdin;
1	1	2	1	8	2	1	1	2/1/	{"en_US": "Administration", "es_419": "Administración"}	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
6	1	5	18	10	2	1	1	2/4/5/6/	{"en_US": "Long Term Projects", "es_419": "Proyectos a largo plazo"}	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
2	1	\N	1	5	2	1	1	2/	{"en_US": "Management", "es_419": "Gestión"}	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
7	1	2	5	3	2	1	1	2/7/	{"en_US": "Professional Services", "es_419": "Servicios profesionales"}	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
5	1	4	4	10	2	1	1	2/4/5/	{"en_US": "R&D USA", "es_419": "I+D EE. UU."}	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
4	1	2	3	10	2	1	1	2/4/	{"en_US": "Research & Development", "es_419": "Investigación y desarrollo"}	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
3	1	2	2	9	2	1	1	2/3/	{"en_US": "Sales", "es_419": "Ventas"}	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
\.


--
-- Data for Name: hr_department_hr_leave_mandatory_day_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_department_hr_leave_mandatory_day_rel (hr_leave_mandatory_day_id, hr_department_id) FROM stdin;
\.


--
-- Data for Name: hr_departure_reason; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_departure_reason (id, sequence, country_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	0	\N	1	1	{"en_US": "Fired", "es_419": "Despedido"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
2	1	\N	1	1	{"en_US": "Resigned", "es_419": "Renunció"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
3	2	\N	1	1	{"en_US": "Retired", "es_419": "Retirado"}	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
\.


--
-- Data for Name: hr_departure_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_departure_wizard (id, departure_reason_id, create_uid, write_uid, departure_date, departure_description, remove_related_user, set_date_end, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_departure_wizard_hr_employee_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_departure_wizard_hr_employee_rel (hr_departure_wizard_id, hr_employee_id) FROM stdin;
\.


--
-- Data for Name: hr_employee; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee (id, resource_id, company_id, message_main_attachment_id, current_version_id, user_id, work_contact_id, country_of_birth, parent_id, coach_id, color, create_uid, write_uid, name, work_phone, mobile_phone, work_email, legal_name, private_phone, private_email, lang, place_of_birth, permit_no, visa_no, certificate, study_field, study_school, emergency_contact, emergency_phone, barcode, pin, private_car_plate, birthday, visa_expire, work_permit_expiration_date, salary_distribution, employee_properties, active, birthday_public_display, work_permit_scheduled_activity, create_date, write_date, leave_manager_id, monday_location_id, tuesday_location_id, wednesday_location_id, thursday_location_id, friday_location_id, saturday_location_id, sunday_location_id, today_location_name) FROM stdin;
6	6	1	\N	6	\N	45	\N	2	2	0	1	1	Abigail Peterson	(555)-233-3393	\N	abigail.peterson39@example.com	Abigail Peterson	\N	abigail.peterson33@example.com	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
7	7	1	\N	8	\N	46	\N	2	2	0	1	1	Audrey Peterson	(555)-276-7903	\N	audrey.peterson25@example.com	Audrey Peterson	\N	Audrey.peterson2020@example.com	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
8	8	1	\N	9	\N	47	\N	2	2	0	1	1	Eli Lambert	(555)-169-1352	\N	eli.lambert22@example.com	Eli Lambert	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
9	9	1	\N	10	\N	48	\N	2	2	0	1	1	Rachel Perry	(555)-267-3735	\N	jod@odoo.com	Rachel Perry	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
10	10	1	\N	11	\N	49	\N	4	4	0	1	1	Keith Byrd	(555)-505-5146	\N	keith.byrd52@example.com	Keith Byrd	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
11	11	1	\N	12	\N	50	\N	5	5	0	1	1	Doris Cole	(555)-331-5378	\N	doris.cole31@example.com	Doris Cole	\N	Doris.cole.LoveSong@example.com	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
12	12	1	\N	13	\N	51	\N	5	5	0	1	1	Ernest Reed	(555)-518-8232	\N	ernest.reed47@example.com	Ernest Reed	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
13	13	1	\N	14	\N	52	\N	5	5	0	1	1	Toni Jimenez	(555)-707-8451	\N	toni.jimenez23@example.com	Toni Jimenez	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
17	17	1	\N	18	\N	56	\N	10	10	0	1	1	Jennie Fletcher	(555)-363-8229	\N	jennie.fletcher76@example.com	Jennie Fletcher	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
19	19	1	\N	20	\N	58	\N	18	18	0	1	1	Walter Horton	(555)-912-1201	\N	walter.horton80@example.com	Walter Horton	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
20	20	1	\N	21	\N	59	\N	18	18	0	1	1	Beth Evans	(555)-532-3841	\N	beth.evans77@example.com	Beth Evans	\N	beth.evans@example.com	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
21	21	1	\N	25	\N	60	\N	\N	\N	0	1	1	Barty McBly	(555)-234-3424	\N	barty.mcbly@example.com	Barty McBly	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036	\N	\N	\N	\N	\N	\N	\N	\N	\N
2	2	1	\N	2	\N	42	\N	1	1	0	1	1	Jeffrey Kelly	(555)-264-7362	\N	jeffrey.kelly72@example.com	Jeffrey Kelly	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:56.767712	2	\N	\N	\N	\N	\N	\N	\N	\N
3	3	1	\N	3	5	6	\N	1	1	0	1	1	Marc Demo	(441)-695-2334	\N	mark.brown23@example.com	Marc Demo	+1 555-555-5757	demo@yourcompany.example.com	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2026-01-08 15:33:54.738036	2026-01-08 15:33:56.767712	2	\N	\N	\N	\N	\N	\N	\N	\N
5	5	1	\N	5	\N	44	\N	1	1	0	1	1	Tina Williamson	(555)-694-7266	\N	tina.williamson98@example.com	Tina Williamson	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:56.767712	2	\N	\N	\N	\N	\N	\N	\N	\N
16	16	1	\N	17	\N	55	\N	3	3	0	1	1	Randall Lewis	(555)-775-6660	\N	randall.lewis74@example.com	Randall Lewis	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:56.767712	5	\N	\N	\N	\N	\N	\N	\N	\N
14	14	1	\N	15	\N	53	\N	10	10	0	1	1	Anita Oliver	(555)-497-4804	\N	anita.oliver32@example.com	Anita Oliver	(538)-672-3185	anita.oliver00@example.com	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:56.767712	2	\N	\N	\N	\N	\N	\N	\N	\N
4	4	1	\N	4	\N	43	\N	3	3	0	1	1	Ronnie Hart	(555)-310-7863	\N	ronnie.hart87@example.com	Ronnie Hart	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:56.767712	2	\N	\N	\N	\N	\N	\N	\N	\N
15	15	1	\N	16	\N	54	\N	3	3	0	1	1	Sharlene Rhodes	(555)-719-4182	\N	sharlene.rhodes49@example.com	Sharlene Rhodes	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:56.767712	2	\N	\N	\N	\N	\N	\N	\N	\N
18	18	1	\N	19	\N	57	\N	3	3	0	1	1	Paul Williams	(555)-262-1607	\N	paul.williams59@example.com	Paul Williams	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2010-01-01 00:00:00	2026-01-08 15:33:56.767712	2	\N	\N	\N	\N	\N	\N	\N	\N
1	1	1	\N	1	2	3	\N	1	1	0	1	1	Database Support	+1 555-555-5555	\N	admin@example.com	Database Support	+1 555-555-5555	admin@yourcompany.example.com	\N	\N	\N	\N	\N	Civil Engineering: Applied Mathematics	Université Catholique de Louvain (UCL)	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	t	f	f	2026-01-08 15:33:54.738036	2026-01-08 15:33:59.205275	2	\N	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: hr_employee_category; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_category (id, color, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	1	1	1	Sales	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
2	2	1	1	Trainer	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
3	6	1	1	Employee	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
4	4	1	1	Consultant	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
5	3	1	1	Standard 20 hours/week	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
6	8	1	1	High Potential	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
\.


--
-- Data for Name: hr_employee_cv_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_cv_wizard (id, create_uid, write_uid, color_primary, color_secondary, show_skills, show_contact, show_others, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_employee_hr_employee_cv_wizard_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_hr_employee_cv_wizard_rel (hr_employee_cv_wizard_id, hr_employee_id) FROM stdin;
\.


--
-- Data for Name: hr_employee_hr_leave_allocation_generate_multi_wizard_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_hr_leave_allocation_generate_multi_wizard_rel (hr_leave_allocation_generate_multi_wizard_id, hr_employee_id) FROM stdin;
\.


--
-- Data for Name: hr_employee_hr_leave_generate_multi_wizard_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_hr_leave_generate_multi_wizard_rel (hr_leave_generate_multi_wizard_id, hr_employee_id) FROM stdin;
\.


--
-- Data for Name: hr_employee_hr_skill_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_hr_skill_rel (hr_employee_id, hr_skill_id) FROM stdin;
1	27
1	29
1	32
1	38
1	87
4	27
4	32
4	29
4	38
6	3
6	24
6	35
6	65
7	3
7	35
7	65
11	3
11	24
11	35
11	65
12	3
12	24
12	35
12	65
13	3
13	35
13	24
13	65
14	38
14	58
14	59
14	37
20	37
20	38
17	58
17	37
17	38
10	58
10	38
10	37
3	59
3	58
3	37
3	38
18	37
18	38
16	58
16	59
16	38
16	37
15	59
15	37
15	38
19	59
19	58
19	38
19	37
5	1
5	3
5	24
5	31
5	87
8	23
8	67
8	64
2	23
2	64
2	67
9	23
9	67
\.


--
-- Data for Name: hr_employee_location; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_location (id, work_location_id, employee_id, create_uid, write_uid, date, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_employee_skill; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_employee_skill (id, skill_id, skill_level_id, skill_type_id, employee_id, create_uid, write_uid, valid_from, valid_to, display_warning_message, create_date, write_date) FROM stdin;
3	29	11	2	1	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
11	87	12	6	1	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
17	27	10	2	4	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
24	3	5	1	6	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
33	24	10	2	11	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
38	24	8	2	12	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
59	37	15	3	17	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
71	59	15	3	3	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
76	58	14	3	16	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
78	59	13	3	16	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
90	87	12	6	5	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
92	31	9	2	5	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
103	23	9	2	2	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
105	64	18	5	2	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
107	23	10	2	9	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
110	67	20	5	9	1	1	2026-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
5	32	11	2	1	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
8	27	10	2	1	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
14	32	10	2	4	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
19	35	9	2	6	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
21	24	8	2	6	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
26	35	10	2	7	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
28	65	20	5	7	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
36	3	5	1	11	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
42	35	9	2	13	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
44	24	11	2	13	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
49	58	16	3	14	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
51	37	17	3	14	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
55	37	15	3	20	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
61	38	16	3	10	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
64	37	16	3	10	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
67	58	15	3	3	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
73	37	13	3	18	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
81	37	15	3	15	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
82	59	13	3	15	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
85	58	15	3	19	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
87	37	17	3	19	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
94	24	9	2	5	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
98	23	8	2	8	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
100	67	20	5	8	1	1	2025-07-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
2	29	10	2	1	1	1	2025-07-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
10	87	12	6	1	1	1	2025-07-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
32	24	9	2	11	1	1	2025-07-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
70	59	14	3	3	1	1	2025-07-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
89	87	12	6	5	1	1	2025-07-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
109	67	19	5	9	1	1	2025-07-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
6	38	17	3	1	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
12	29	11	2	4	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
15	38	16	3	4	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
22	65	20	5	6	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
29	3	5	1	7	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
30	35	9	2	11	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
34	65	19	5	11	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
37	35	8	2	12	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
39	65	19	5	12	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
40	3	6	1	12	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
45	65	20	5	13	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
46	3	5	1	13	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
47	38	15	3	14	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
52	59	16	3	14	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
53	38	16	3	20	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
56	38	16	3	17	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
57	58	13	3	17	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
62	58	13	3	10	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
65	38	16	3	3	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
68	37	15	3	3	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
72	38	17	3	18	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
74	38	15	3	16	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
77	37	15	3	16	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
79	38	16	3	15	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
83	38	14	3	19	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
88	59	13	3	19	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
95	3	5	1	5	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
96	1	2	1	5	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
101	64	20	5	8	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
104	67	20	5	2	1	1	2025-01-01	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
16	27	9	2	4	1	1	2025-01-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
23	3	4	1	6	1	1	2025-01-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
58	37	14	3	17	1	1	2025-01-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
75	58	13	3	16	1	1	2025-01-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
91	31	8	2	5	1	1	2025-01-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
102	23	8	2	2	1	1	2025-01-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
106	23	9	2	9	1	1	2025-01-01	2025-12-31	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
1	29	9	2	1	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
4	32	10	2	1	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
7	27	9	2	1	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
9	87	12	6	1	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
13	32	9	2	4	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
18	35	8	2	6	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
20	24	7	2	6	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
25	35	9	2	7	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
27	65	19	5	7	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
31	24	8	2	11	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
35	3	4	1	11	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
41	35	8	2	13	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
43	24	10	2	13	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
48	58	15	3	14	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
50	37	16	3	14	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
54	37	14	3	20	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
60	38	15	3	10	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
63	37	15	3	10	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
66	58	14	3	3	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
69	59	13	3	3	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
80	37	14	3	15	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
84	58	14	3	19	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
86	37	16	3	19	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
93	24	8	2	5	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
97	23	7	2	8	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
99	67	19	5	8	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
108	67	18	5	9	1	1	2025-01-01	2025-06-30	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
\.


--
-- Data for Name: hr_holidays_cancel_leave; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_holidays_cancel_leave (id, leave_id, create_uid, write_uid, reason, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_holidays_summary_employee; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_holidays_summary_employee (id, create_uid, write_uid, holiday_type, date_from, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_job; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_job (id, sequence, no_of_recruitment, user_id, department_id, company_id, contract_type_id, create_uid, write_uid, name, description, requirements, active, create_date, write_date) FROM stdin;
1	10	1	2	4	1	1	1	1	{"en_US": "Chief Technical Officer", "es_419": "Director técnico"}	<p>You will take part in the consulting services we provide to our partners and customers: design, analysis, development, testing, project management, support/coaching. You will work autonomously as well as coordinate and supervise small distributed development teams for some projects. Optionally, you will deliver Odoo training sessions to partners and customers (8-10 people/session). You will report to the Head of Professional Services and work closely with all developers and consultants.\n\nThe job is located in Grand-Rosière (1367), Belgium (between Louvain-La-Neuve and Namur).</p>	Bachelor, master or engineering degree in Computer Science or equivalent by experience\nPreferably at least 1 years of experience\nInterest for enterprise application development\nCustomer-minded\nWilling to travel abroad occasionally for short term missions.\nPassion for the Internet and its culture\nQuick and autonomous learner, problem-solving personality, enthusiastic when faced with technical challenges\nTeam spirit and good communication\nRequired skills:\nGood knowledge of object oriented programming, object modeling, relational databases, Unix/Linux platform\nFluent in English, especially read and written\nNice-to-have skills:\nGood knowledge of Python\nGood knowledge of HTML and Javascript\nKnowledge of UML-like modeling\nGood language skills, other than English (Dutch and French preferred, others welcome)\n            	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:59.205275
2	10	5	5	7	1	3	1	1	{"en_US": "Consultant", "es_419": "Consultor"}	<p>We are looking for a Consultant to provide expert advice and strategic solutions,\n                driving business growth. Strong analytical skills and a proven track record in delivering results are\n                essential.\n            </p>	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:59.205275
3	10	5	2	4	1	1	1	1	{"en_US": "Experienced Developer", "es_419": "Desarrollador con experiencia"}	<p>We are looking for an experience developer to join our Web team.\n                Someone who can snap out of coding and perform analysis or meet clients to explain the technical\n                possibilities that can meet their needs.\n            </p>	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:59.205275
4	10	1	2	1	1	1	1	1	{"en_US": "Human Resources Manager", "es_419": "Gerente de recursos humanos"}	<p>A Human Resources (HR) Manager is responsible for overseeing an organization's workforce and ensuring\n                that all HR functions are effectively managed. This includes recruiting, hiring, onboarding, and\n                training new employees, as well as managing employee relations, performance, and compensation. The HR\n                manager also ensures compliance with labor laws and company policies, while fostering a positive work\n                environment. They may handle conflict resolution, conduct employee evaluations, and implement programs\n                to improve employee engagement and retention. Additionally, HR managers play a strategic role in\n                aligning the workforce with the organization's goals and objectives.\n            </p>	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:59.205275
5	10	1	5	3	1	\N	1	1	{"en_US": "Marketing and Community Manager", "es_419": "Gerente de marketing y comunicación"}	<p>The Marketing Manager defines the mid- to long-term marketing strategy for his covered market segments\n                in the World. He develops and monitors the annual budget in collaboration with Sales. He defines the\n                products and customers portfolio according to the marketing plan. This mission requires strong\n                collaboration with Technical Service and Sales.\n            </p>	\N	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:59.205275
6	10	1	2	\N	1	\N	1	1	{"en_US": "Trainee", "es_419": "Aprendiz"}	<p>You participate to the update of our tutorial tools and pre-sales tools after the launch of a new version of Odoo. Indeed, any new version of the software brings significant improvements in terms of functionalities, ergonomics and configuration.\nYou will have to become familiar with the existing tools (books, class supports, Odoo presentation’s slides, commercial tools),\nto participate to the update of those tools in order to make them appropriate for the new version of the software and, for sure,\nto suggest improvements in order to cover the new domains of the software.\nYou join the Implementation Assistance department. This team of 3 people go with Odoo’s clients in the set up of the software. Your role will be\nto animate webinars in order to show the different functionalities of the software.\nto be involved in the support of the customers and\nto answer to their questions.\nYou help the support manager to set up new support services by\nbeing involved in the treatment of new cases,\ncontributing to the set up of a new politic,\nbeing involved into satisfaction surveys in order to have a better knowledge of how the support given is seen by the customers.</p>	You speak fluently English and French (one other European language is a +)\nAt the time of your traineeship at Odoo, you will be in the last year of a Master or Bachelor Degree (ideally in the following sector: Business Management, IT Management, Computer Sciences)\nYou have a software and new technology awareness\nYou are ready to join a young and dynamic company, you are able to work in a “start up” fast paced environment, hands on attitude\nYou are approachable, honest and a fun team player\nIf you have development competencies, we can propose you specific traineeships	t	2026-01-08 15:33:54.738036	2026-01-08 15:33:59.205275
\.


--
-- Data for Name: hr_job_hr_leave_mandatory_day_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_job_hr_leave_mandatory_day_rel (hr_leave_mandatory_day_id, hr_job_id) FROM stdin;
\.


--
-- Data for Name: hr_job_hr_skill_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_job_hr_skill_rel (hr_job_id, hr_skill_id) FROM stdin;
1	32
1	29
1	27
1	38
1	88
2	3
2	35
2	24
2	65
3	38
3	37
3	58
3	59
4	3
4	1
4	31
4	24
4	87
5	23
5	67
5	64
\.


--
-- Data for Name: hr_job_skill; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_job_skill (id, skill_id, skill_level_id, skill_type_id, job_id, create_uid, write_uid, valid_from, valid_to, display_warning_message, create_date, write_date) FROM stdin;
1	29	11	2	1	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
2	32	11	2	1	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
3	27	10	2	1	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
4	38	17	3	1	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
5	88	12	6	1	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
6	35	9	2	2	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
7	24	8	2	2	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
8	65	20	5	2	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
9	3	5	1	2	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
10	38	16	3	3	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
11	58	13	3	3	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
12	37	15	3	3	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
13	59	13	3	3	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
14	87	12	6	4	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
15	31	10	2	4	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
16	24	8	2	4	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
17	3	5	1	4	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
18	1	2	1	4	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
19	23	9	2	5	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
20	67	20	5	5	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
21	64	18	5	5	1	1	2026-01-08	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
\.


--
-- Data for Name: hr_leave; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_leave (id, message_main_attachment_id, user_id, holiday_status_id, employee_id, employee_company_id, company_id, department_id, resource_calendar_id, meeting_id, first_approver_id, second_approver_id, create_uid, write_uid, private_name, state, duration_display, request_date_from_period, request_date_to_period, request_date_from, request_date_to, notes, request_unit_half, request_unit_hours, date_from, date_to, create_date, write_date, number_of_days, number_of_hours, request_hour_from, request_hour_to) FROM stdin;
1	\N	2	3	1	1	1	2	3	\N	\N	\N	1	1	Trip with Family	confirm	3 days	am	pm	2026-01-05	2026-01-07	\N	f	f	2026-01-05 07:00:00	2026-01-07 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	3	22.799999999999997	8	16.6
2	\N	2	2	1	1	1	2	3	8	\N	\N	1	1	Doctor Appointment	validate	3 days	am	pm	2026-01-26	2026-01-28	\N	f	f	2026-01-26 07:00:00	2026-01-28 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	3	22.799999999999997	8	16.6
3	\N	\N	1	4	1	1	4	3	9	\N	\N	1	1	Trip with Friends	validate	5 days	am	pm	2026-01-14	2026-01-20	\N	f	f	2026-01-14 07:00:00	2026-01-20 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	5	38	8	16.6
4	\N	\N	2	4	1	1	4	3	10	\N	\N	1	1	Dentist appointment	validate	3 days	am	pm	2026-02-23	2026-02-25	\N	f	f	2026-02-23 07:00:00	2026-02-25 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	3	22.799999999999997	8	16.6
5	\N	\N	1	14	1	1	5	3	11	\N	\N	1	1	Trip to Paris	validate	5 days	am	pm	2026-01-22	2026-01-28	\N	f	f	2026-01-22 07:00:00	2026-01-28 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	5	38	8	16.6
6	\N	\N	1	14	1	1	5	3	12	\N	\N	1	1	Trip	validate	3 days	am	pm	2026-01-05	2026-01-07	\N	f	f	2026-01-05 07:00:00	2026-01-07 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	3	22.799999999999997	8	16.6
7	\N	5	2	3	1	1	4	3	13	\N	\N	1	1	Sick day	validate	3 days	am	pm	2026-02-09	2026-02-11	\N	f	f	2026-02-09 07:00:00	2026-02-11 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	3	22.799999999999997	8	16.6
8	\N	5	2	3	1	1	4	3	14	\N	\N	1	1	Sick day	validate	3 days	am	pm	2026-01-05	2026-01-07	\N	f	f	2026-01-05 07:00:00	2026-01-07 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	3	22.799999999999997	8	16.6
9	\N	\N	1	15	1	1	2	3	15	\N	\N	1	1	Trip to London	validate	6 days	am	pm	2026-01-09	2026-01-16	\N	f	f	2026-01-09 07:00:00	2026-01-16 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	6	45.599999999999994	8	16.6
10	\N	\N	2	15	1	1	2	3	16	\N	\N	1	1	Doctor Appointment	validate	3 days	am	pm	2026-01-26	2026-01-28	\N	f	f	2026-01-26 07:00:00	2026-01-28 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	3	22.799999999999997	8	16.6
11	\N	\N	2	18	1	1	6	3	17	\N	\N	1	1	Dentist appointment	validate	1 days	am	pm	2026-02-02	2026-02-02	\N	f	f	2026-02-02 07:00:00	2026-02-02 15:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	1	7.6	8	16.6
12	\N	\N	2	18	1	1	6	3	18	\N	\N	1	1	Second dentist appointment	validate	1 days	am	pm	2026-05-06	2026-05-06	\N	f	f	2026-05-06 06:00:00	2026-05-06 14:36:00	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	1	7.6	8	16.6
\.


--
-- Data for Name: hr_leave_accrual_level; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_leave_accrual_level (id, sequence, accrual_plan_id, start_count, postpone_max_days, accrual_validity_count, create_uid, write_uid, start_type, milestone_date, added_value_type, frequency, week_day, first_day, second_day, first_month_day, first_month, second_month_day, second_month, yearly_month, yearly_day, action_with_unused_accruals, carryover_options, accrual_validity_type, added_value, maximum_leave, maximum_leave_yearly, cap_accrued_time, cap_accrued_time_yearly, accrual_validity, create_date, write_date) FROM stdin;
1	1	1	1	\N	1	1	1	day	after	day	yearly	0	1	15	1	1	1	7	1	1	all	unlimited	day	1.00000	100.00	\N	t	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
2	1460	1	4	\N	1	1	1	year	after	day	yearly	0	1	15	1	1	1	7	1	1	all	unlimited	day	2.00000	100.00	\N	t	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
3	2920	1	8	\N	1	1	1	year	after	day	yearly	0	1	15	1	1	1	7	1	1	all	unlimited	day	3.00000	100.00	\N	t	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
\.


--
-- Data for Name: hr_leave_accrual_plan; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_leave_accrual_plan (id, time_off_type_id, company_id, create_uid, write_uid, name, transition_mode, accrued_gain_time, carryover_date, carryover_day, carryover_month, added_value_type, active, is_based_on_worked_time, can_be_carryover, create_date, write_date) FROM stdin;
1	\N	1	1	1	Seniority Plan	immediately	end	year_start	1	1	day	t	\N	t	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
\.


--
-- Data for Name: hr_leave_allocation; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_leave_allocation (id, holiday_status_id, employee_id, employee_company_id, manager_id, approver_id, second_approver_id, department_id, accrual_plan_id, create_uid, write_uid, name, state, allocation_type, date_from, date_to, last_executed_carryover_date, lastcall, actual_lastcall, nextcall, carried_over_days_expiration_date, notes, already_accrued, create_date, write_date, number_of_days, number_of_hours_display, yearly_accrued_amount, expiring_carryover_days) FROM stdin;
3	75	1	1	1	\N	\N	2	\N	1	1	Functional Training	confirm	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	7	53.199999999999996	\N	\N
1	1	1	1	1	\N	\N	2	\N	1	1	Paid Time Off for Mitchell Admin	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	20	152	\N	\N
2	3	1	1	1	\N	\N	2	\N	1	1	International Tour	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	7	53.199999999999996	\N	\N
4	3	1	1	1	\N	\N	2	\N	1	1	Compensation	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	12	91.19999999999999	\N	\N
5	1	4	1	3	\N	\N	4	\N	1	1	Paid Time Off for Ronnie Hart	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	20	152	\N	\N
6	74	4	1	3	\N	\N	4	\N	1	1	Parental Leaves	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	10	76	\N	\N
7	75	4	1	3	\N	\N	4	\N	1	1	Soft Skills Training	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	12	91.19999999999999	\N	\N
8	1	14	1	10	\N	\N	5	\N	1	1	Paid Time Off for Anita Oliver	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	20	152	\N	\N
9	75	14	1	10	\N	\N	5	\N	1	1	Compliance Training	confirm	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	7	53.199999999999996	\N	\N
10	1	3	1	1	\N	\N	4	\N	1	1	Paid Time Off for Marc Demo	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	20	152	\N	\N
11	75	3	1	1	\N	\N	4	\N	1	1	Time Management Training	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	7	53.199999999999996	\N	\N
12	1	7	1	2	\N	\N	7	\N	1	1	Paid Time Off for Audrey Peterson	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	20	152	\N	\N
13	75	7	1	2	\N	\N	7	\N	1	1	Consulting Training	confirm	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	7	53.199999999999996	\N	\N
14	1	15	1	3	\N	\N	2	\N	1	1	Paid Time Off for Olivia	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	20	152	\N	\N
15	75	15	1	3	\N	\N	2	\N	1	1	Software Development Training	validate	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	5	38	\N	\N
16	1	18	1	3	\N	\N	6	\N	1	1	Paid Time Off for Kim	confirm	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	20	152	\N	\N
17	75	18	1	3	\N	\N	6	\N	1	1	Onboarding Training	confirm	regular	2026-01-01	2026-12-31	\N	\N	\N	\N	\N	\N	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	5	38	\N	\N
\.


--
-- Data for Name: hr_leave_allocation_generate_multi_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_leave_allocation_generate_multi_wizard (id, holiday_status_id, company_id, department_id, category_id, accrual_plan_id, create_uid, write_uid, name, allocation_mode, allocation_type, date_from, date_to, notes, create_date, write_date, duration) FROM stdin;
\.


--
-- Data for Name: hr_leave_generate_multi_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_leave_generate_multi_wizard (id, holiday_status_id, company_id, department_id, category_id, create_uid, write_uid, name, allocation_mode, date_from, date_to, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: hr_leave_mandatory_day; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_leave_mandatory_day (id, company_id, color, resource_calendar_id, create_uid, write_uid, name, start_date, end_date, create_date, write_date) FROM stdin;
1	1	9	\N	1	1	Company Celebration	2026-01-15	2026-01-15	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712
\.


--
-- Data for Name: hr_leave_type; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_leave_type (id, sequence, color, icon_id, company_id, country_id, leave_notif_subtype_id, allocation_notif_subtype_id, max_allowed_negative, create_uid, write_uid, leave_validation_type, allocation_validation_type, time_type, request_unit, name, create_calendar_meeting, active, hide_on_dashboard, requires_allocation, employee_requests, unpaid, include_public_holidays_in_duration, support_document, allow_request_on_top, elligible_for_accrual_rate, allows_negative, create_date, write_date, pre_approved_instance) FROM stdin;
1	1	2	418	\N	\N	8	14	\N	1	1	both	hr	leave	day	{"en_US": "Paid Time Off", "es_419": "Tiempo personal pagado"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
2	2	3	421	\N	\N	10	14	\N	1	1	hr	hr	leave	day	{"en_US": "Sick Time Off", "es_419": "Tiempo personal por enfermedad"}	t	t	t	f	f	f	f	t	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
3	4	4	417	\N	\N	8	14	\N	1	1	manager	hr	leave	day	{"en_US": "Compensatory Days", "es_419": "Días compensatorios"}	t	t	f	t	t	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
4	3	5	423	\N	\N	12	14	\N	1	1	both	hr	leave	hour	{"en_US": "Unpaid", "es_419": "Sin pagar"}	t	t	t	f	f	t	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
5	4	\N	\N	\N	\N	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "Extra Time Off", "es_419": "Tiempo personal adicional"}	t	t	t	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
6	5	\N	417	\N	\N	8	14	\N	1	1	manager	hr	leave	hour	{"en_US": "Extra Hours", "es_419": "Horas extra"}	t	t	t	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
7	100	\N	421	\N	2	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Sick Leave 50%", "es_419": "Licencia por enfermedad - 50%"}	t	t	f	f	f	f	f	t	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
8	100	\N	421	\N	2	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Sick Leave 0%", "es_419": "Licencia por enfermedad - 0%"}	t	t	f	f	f	f	f	t	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
9	100	\N	\N	\N	20	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "Small Unemployment", "es_419": "Desempleo menor"}	t	t	f	t	t	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
10	100	\N	419	\N	20	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "Maternity Time Off", "es_419": "Licencia por maternidad"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
11	100	\N	\N	\N	20	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "Unpredictable Reason", "es_419": "Motivo impredecible"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
12	100	\N	422	\N	20	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "Training Time Off", "es_419": "Tiempo personal en capacitación"}	t	t	f	t	t	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
13	6	\N	417	\N	20	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "Extra Legal Time Off", "es_419": "Permisos legales adicionales"}	t	t	f	t	t	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
14	100	\N	\N	\N	20	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Recovery Bank Holiday", "es_419": "Día festivo de recuperación"}	t	t	f	t	t	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
15	100	\N	418	\N	20	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "European Time Off", "es_419": "Permisos europeos"}	t	t	f	t	t	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
16	100	\N	\N	\N	20	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "Credit Time", "es_419": "Tiempo de crédito"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
17	100	\N	\N	\N	20	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Work Accident Time Off", "es_419": "Tiempo personal por accidente laboral"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
18	100	\N	\N	\N	20	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "Strike", "es_419": "Huelga"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
19	100	\N	\N	\N	20	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "Sick Leave Without Certificate", "es_419": "Licencia por enfermedad sin certificado"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
20	100	\N	\N	\N	20	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "Brief Holiday (Birth)", "es_419": "Permiso breve (nacimiento)"}	t	t	f	t	t	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
21	1	1	\N	\N	43	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "Unpaid leave", "es_419": "Permiso sin goce de sueldo"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
22	2	2	\N	\N	43	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "Illness leave", "es_419": "Licencia por enfermedad"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
23	3	3	\N	\N	43	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "Accident leave", "es_419": "Licencia por accidente"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
24	4	4	\N	\N	43	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "Maternity / Paternity leave", "es_419": "Licencia por maternidad o paternidad"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
25	4	5	\N	\N	43	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "Military leave", "es_419": "Permiso militar"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
26	5	6	\N	\N	43	8	14	\N	1	1	no_validation	hr	leave	day	{"en_US": "Interruption of Work", "es_419": "Interrupción del trabajo"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
27	100	\N	\N	\N	65	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Marriage Leave", "es_419": "Permiso por matrimonio"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
28	100	\N	\N	\N	65	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Maternity Leave", "es_419": "Permiso por maternidad"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
29	100	\N	\N	\N	65	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Hajj Leave", "es_419": "Permiso por peregrinación a La Meca (Hajj)"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
30	100	\N	\N	\N	65	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Death Leave", "es_419": "Permiso por fallecimiento"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
31	100	\N	\N	\N	65	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Paid Sick time off", "es_419": "Permiso por enfermedad remunerado"}	t	t	f	t	t	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
32	100	\N	\N	\N	65	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Sick Leave (75% Paid)", "es_419": "Permiso por enfermedad (pagado al 75%)"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
33	100	\N	\N	\N	65	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Sick Leave (UnPaid)", "es_419": "Permiso por enfermedad (no remunerado)"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
34	100	\N	\N	\N	94	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "HK Annual Leaves", "es_419": "Permisos anuales para Hong Kong"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
35	100	\N	\N	\N	94	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "HK Compensation Leaves", "es_419": "Permisos compensatorios para Hong Kong"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
36	100	\N	421	\N	94	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "HK Sick Leaves", "es_419": "Licencias por enfermedad para Hong Kong"}	t	t	f	f	f	f	f	t	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
37	100	\N	421	\N	94	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "HK Sick Leaves 80%", "es_419": "Licencias por enfermedad (80%) para Hong Kong"}	t	t	f	f	f	f	f	t	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
38	100	\N	\N	\N	94	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "HK Unpaid Leaves", "es_419": "Permisos sin goce de sueldo para Hong Kong"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
39	100	\N	\N	\N	94	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "HK Marriage Leaves", "es_419": "Permisos por matrimonio para Hong Kong"}	t	t	f	f	f	f	f	t	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
40	100	\N	\N	\N	94	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "HK Maternity Leaves", "es_419": "Permisos de maternidad para Hong Kong"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
41	100	\N	\N	\N	94	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "HK Maternity Leaves 80%", "es_419": "Permisos de maternidad (80%) para Hong Kong"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
42	100	\N	\N	\N	94	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "HK Paternity Leaves", "es_419": "Permisos de paternidad para Hong Kong"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
43	100	\N	\N	\N	94	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "HK Paternity Leaves 80%", "es_419": "Licencias de paternidad en HK al 80%"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
44	100	\N	\N	\N	94	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "HK Compassionate Leaves", "es_419": "Permisos por fallecimiento para Hong Kong"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
45	100	\N	\N	\N	94	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "HK Examination Leaves", "es_419": "Permisos por estudio para Hong Kong"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
46	100	\N	\N	\N	100	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "ID Annual Leaves", "es_419": "Permisos anuales para India"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
47	100	\N	\N	\N	100	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "ID Sick Leaves", "es_419": "Licencias por enfermedad para India"}	t	t	f	f	f	f	f	t	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
48	100	\N	\N	\N	100	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "ID Unpaid Leaves", "es_419": "Permisos sin goce de sueldo para India"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
49	100	\N	\N	\N	100	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "ID Marriage Leaves", "es_419": "Permisos por matrimonio para India"}	t	t	f	f	f	f	f	t	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
50	100	\N	\N	\N	100	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "ID Maternity Leaves", "es_419": "Permisos de maternidad para India"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
51	100	\N	\N	\N	100	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "ID Paternity Leaves", "es_419": "Permisos de paternidad para India"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
52	100	\N	\N	\N	100	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "ID Bereavement Leaves", "es_419": "Permisos por fallecimiento para India"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
53	100	\N	\N	\N	112	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Sick Leave (Unpaid)", "es_419": "Permiso por enfermedad (no remunerado)"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
54	100	\N	\N	\N	112	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Maternity Leave", "es_419": "Permiso por maternidad"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
55	100	\N	\N	\N	112	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Pilgrimage Leave", "es_419": "Permiso de peregrinación"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
56	100	\N	\N	\N	112	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Paternity Leave", "es_419": "Licencia de paternidad"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
57	100	\N	\N	\N	112	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Study Leave", "es_419": "Permiso por estudios"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
58	100	5	423	\N	133	12	14	\N	1	1	no_validation	hr	leave	hour	{"en_US": "Unemployment (Weather / Situational)", "es_419": "Desempleo (climático / situacional)"}	t	t	f	f	f	t	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
59	100	5	423	\N	156	12	14	\N	1	1	no_validation	hr	leave	day	{"en_US": "Work risk (IMSS)", "es_419": "Riesgo de trabajo (IMSS)"}	t	t	f	f	f	t	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
60	100	5	419	\N	156	12	14	\N	1	1	no_validation	hr	leave	day	{"en_US": "Maternity (IMSS)", "es_419": "Maternidad (IMSS)"}	t	t	f	f	f	t	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
61	100	5	421	\N	156	12	14	\N	1	1	no_validation	hr	leave	day	{"en_US": "Disability due to illness (IMSS)", "es_419": "Incapacidad por enfermedad (IMSS)"}	t	t	f	f	f	t	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
62	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Sick Leave (100% Paid)", "es_419": "Permiso por enfermedad (pagado al 100%)"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
63	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Sick Leave (75% Paid)", "es_419": "Permiso por enfermedad (pagado al 75%)"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
64	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Sick Leave (UnPaid)", "es_419": "Permiso por enfermedad (no remunerado)"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
65	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Marriage Leave", "es_419": "Permiso por matrimonio"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
66	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Maternity Leave", "es_419": "Permiso por maternidad"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
67	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Iddah Leave", "es_419": "Periodo de espera durante el divorcio"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
68	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Hajj Leave", "es_419": "Permiso por peregrinación a La Meca (Hajj)"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
69	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Paternity Leave", "es_419": "Licencia de paternidad"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
70	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Study Leave", "es_419": "Permiso por estudios"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
71	100	\N	\N	\N	192	8	14	\N	1	1	hr	hr	leave	day	{"en_US": "Emergency Leave", "es_419": "Permiso de emergencia"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
72	100	\N	\N	\N	201	8	14	\N	1	1	no_validation	hr	leave	half_day	{"en_US": "Maternity Time Off", "es_419": "Licencia por maternidad"}	t	t	f	f	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
73	100	6	421	\N	178	8	14	\N	1	1	hr	hr	leave	half_day	{"en_US": "PL Sick Leaves 80% ", "es_419": "Permisos por enfermedad en PL al 80% "}	t	t	f	t	f	f	f	t	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
74	100	\N	419	\N	233	8	14	\N	1	1	both	hr	leave	day	{"en_US": "Parental Leaves", "es_419": "Permisos por paternidad/maternidad"}	t	t	f	t	f	f	f	\N	f	f	\N	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
75	100	\N	422	\N	233	8	14	20	1	1	both	hr	leave	day	{"en_US": "Training Time Off", "es_419": "Tiempo personal en capacitación"}	t	t	f	t	f	f	f	\N	f	f	t	2026-01-08 15:33:56.767712	2026-01-08 15:33:56.767712	\N
\.


--
-- Data for Name: hr_leave_type_res_users_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_leave_type_res_users_rel (hr_leave_type_id, res_users_id) FROM stdin;
1	2
2	2
3	2
4	2
5	2
58	2
59	2
60	2
61	2
74	2
75	2
\.


--
-- Data for Name: hr_payroll_structure_type; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_payroll_structure_type (id, default_resource_calendar_id, country_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	1	\N	1	1	Employee	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
2	1	\N	1	1	Worker	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
3	3	20	1	1	CP200 PFI BE	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
4	3	20	1	1	CP200 BE	2026-01-08 15:33:54.738036	2026-01-08 15:33:54.738036
\.


--
-- Data for Name: hr_resume_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.hr_resume_line (id, employee_id, duration, line_type_id, create_uid, write_uid, course_type, external_url, certificate_filename, date_start, date_end, name, description, resume_line_properties, create_date, write_date) FROM stdin;
96	8	\N	2	1	1	external	\N	\N	2007-07-08	2009-07-16	{"en_US": "Lindenow Primary School", "es_419": "Lindenow Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
1	1	\N	2	1	1	external	\N	\N	2014-09-17	2019-09-10	{"en_US": "Université Libre de Bruxelles - Polytechnique", "es_419": "Université Libre de Bruxelles - Politécnico"}	{"en_US": "<p>Master in Electrical engineering\\n            Master thesis: Better grid management and control through machine learning</p>", "es_419": "<p>Máster en ingeniería eléctrica\\n            Tesis de máster: Mejor gestión y control de la capacidad informática de la red mediante aprendizaje automático</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
2	1	\N	2	1	1	external	\N	\N	2008-09-01	2014-06-30	{"en_US": "Saint-Joseph School", "es_419": "Saint-Joseph School"}	{"en_US": "<p>Science &amp; math</p>", "es_419": "<p>Ciencia y matemáticas</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
3	1	\N	1	1	1	external	\N	\N	2023-11-01	\N	{"en_US": "Odoo SA", "es_419": "Odoo SA"}	{"en_US": "<p>Job position: Development team leader\\n- Supported technical operations with investigating and correcting varied production support issues (Java, Perl, Shell scripts, SQL).\\n- Led quality assurance planning for multiple concurrent projects relative to overall system architecture or trading system changes/new developments.\\n- Configured and released business critical alpha and risk models using MATLAB and SQL with inputs from Portfolio Managers.\\n        </p>", "es_419": "<p>Puesto de trabajo: Líder del equipo de desarrollo\\n- Apoyo en operaciones técnicas. Investigación y corrección de varios errores de producción (Java, Perl, scripts Shell, SQL).\\n- Dirección de la planificación de aseguramiento de la calidad para varios proyectos simultáneos relacionados con la arquitectura general del sistema y los cambios y nuevos desarrollos del sistema.\\n- Configuración y publicación de modelos alfa y de riesgo con MATLAB y SQL con ayuda de los gestores de cartera.\\n        </p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
4	1	\N	1	1	1	external	\N	\N	2019-09-10	2023-09-10	{"en_US": "Burtho Inc.", "es_419": "Burtho Inc."}	{"en_US": "<p>Job position: Product manager\\n- Coordinated and managed software deployment across five system environments from development to production.\\n- Developed stored procedures to assist Java level programming efforts.\\n- Developed multiple renewable energy plant architectures, both commercial installations and defense-related.\\n        </p>", "es_419": "<p>Puesto de trabajo: Gerente de producto\\n- Coordinación y gestión de la implementación de software en cinco entornos de sistema, desde el desarrollo hasta la producción.\\n- Desarrollo de procedimientos almacenados para asistir en la programación a nivel Java.\\n- Desarrollo de arquitectura de plantas de energías renovables, tanto en instalaciones comerciales como en el sector de defensa.\\n        </p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
5	1	\N	4	1	1	external	\N	\N	2023-11-01	\N	{"en_US": "Encryption/decryption", "es_419": "Encriptación/desencriptación"}	{"en_US": "<p>Allows to encrypt/decrypt plain text or files. Available as a web app or as an API.</p>", "es_419": "<p>Permite encriptar/desencriptar texto plano o archivos. Disponible como aplicación web o como API.</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
6	1	\N	4	1	1	external	\N	\N	2025-11-01	\N	{"en_US": "Finance forecaster", "es_419": "Pronóstico financiero"}	{"en_US": "<p>Enter your finance data and the app tries to forecast what will be your future incomes/expenses. The application uses machine learning to train itself.</p>", "es_419": "<p>Introduzca sus datos financieros y la aplicación calculará cuáles serán sus ingresos y gastos en el futuro. La aplicación utiliza el aprendizaje automático para su funcionamiento.</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
7	1	\N	4	1	1	external	\N	\N	2026-11-01	\N	{"en_US": "Map Generator", "es_419": "Generador de mapa"}	{"en_US": "<p>A 2D/3D map generator for incremental games.</p>", "es_419": "<p>Un generador de mapas 2D/3D para juegos incrementales.</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
8	1	\N	2	1	1	external	\N	\N	2012-02-27	2012-11-03	{"en_US": "Park Lake State School", "es_419": "Park Lake State School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
9	1	\N	2	1	1	external	\N	\N	2008-12-09	2011-12-16	{"en_US": "Blue Mountains Grammar School", "es_419": "Blue Mountains Grammar School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
10	1	\N	2	1	1	external	\N	\N	2006-09-21	2008-11-15	{"en_US": "Harrington Park Public School", "es_419": "Harrington Park Public School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
11	1	\N	1	1	1	external	\N	\N	2009-03-23	\N	{"en_US": "Schultz Inc", "es_419": "Schultz Inc"}	{"en_US": "<p>Engineer, electrical</p>", "es_419": "<p>Ingeniero, eléctrico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
12	1	\N	1	1	1	external	\N	\N	2007-05-24	2008-11-22	{"en_US": "White Inc", "es_419": "White Inc"}	{"en_US": "<p>Designer, television/film set</p>", "es_419": "<p>Diseñador, set de filmación</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
13	1	\N	1	1	1	external	\N	\N	2008-12-23	2009-09-21	{"en_US": "Greene-Orr", "es_419": "Greene-Orr"}	{"en_US": "<p>Magazine journalist</p>", "es_419": "<p>Periodista de revista</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
14	1	\N	1	1	1	external	\N	\N	2009-10-22	2011-12-22	{"en_US": "Lewis-Bailey", "es_419": "Lewis-Bailey"}	{"en_US": "<p>Civil Service fast streamer</p>", "es_419": "<p>Civil Service fast streamer</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
15	4	\N	2	1	1	external	\N	\N	1997-05-06	1998-03-18	{"en_US": "Bathurst West Public School", "es_419": "Bathurst West Public School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
16	4	\N	1	1	1	external	\N	\N	1998-02-05	1999-08-05	{"en_US": "Jones Ltd", "es_419": "Jones Ltd"}	{"en_US": "<p>Energy manager</p>", "es_419": "<p>Gerente de energía</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
17	4	\N	1	1	1	external	\N	\N	1998-09-05	\N	{"en_US": "Garcia, Smith and King", "es_419": "Garcia, Smith and King"}	{"en_US": "<p>Medical illustrator</p>", "es_419": "<p>Ilustrador médico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
18	14	\N	2	1	1	external	\N	\N	2013-08-11	2015-07-01	{"en_US": "Seymour P-12 College", "es_419": "Seymour P-12 College"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
19	14	\N	2	1	1	external	\N	\N	2012-08-08	2013-05-05	{"en_US": "Darlington Primary School", "es_419": "Darlington Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
20	14	\N	2	1	1	external	\N	\N	2010-03-25	2012-06-27	{"en_US": "Sutherland Dianella Primary School", "es_419": "Sutherland Dianella Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
21	14	\N	1	1	1	external	\N	\N	2012-04-24	2012-05-26	{"en_US": "Burns, Lester and Cuevas", "es_419": "Burns, Lester and Cuevas"}	{"en_US": "<p>Police officer</p>", "es_419": "<p>Policía</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
22	14	\N	1	1	1	external	\N	\N	2012-05-28	2014-04-25	{"en_US": "Hill Group", "es_419": "Hill Group"}	{"en_US": "<p>Glass blower/designer</p>", "es_419": "<p>Soplador/diseñador de vidrio</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
23	14	\N	1	1	1	external	\N	\N	2014-06-25	2016-04-25	{"en_US": "Parker, Roberson and Acosta", "es_419": "Parker, Roberson and Acosta"}	{"en_US": "<p>Science writer</p>", "es_419": "<p>Escritor científico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
24	14	\N	1	1	1	external	\N	\N	2017-10-23	2019-06-23	{"en_US": "Robinson, Crawford and Norman", "es_419": "Robinson, Crawford and Norman"}	{"en_US": "<p>Psychiatric nurse</p>", "es_419": "<p>Enfermero psiquiátrico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
25	15	\N	2	1	1	external	\N	\N	2016-08-23	2017-03-26	{"en_US": "Kialla West Primary School", "es_419": "Kialla West Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
26	15	\N	1	1	1	external	\N	\N	2017-05-23	2018-09-23	{"en_US": "Arroyo Ltd", "es_419": "Arroyo Ltd"}	{"en_US": "<p>Insurance risk surveyor</p>", "es_419": "<p>Perito de seguros</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
27	16	\N	2	1	1	external	\N	\N	2016-03-25	2017-06-03	{"en_US": "Northern Bay P-12 College", "es_419": "Northern Bay P-12 College"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
28	16	\N	2	1	1	external	\N	\N	2014-05-06	2016-03-21	{"en_US": "Whitsunday Anglican School", "es_419": "Whitsunday Anglican School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
29	16	\N	2	1	1	external	\N	\N	2011-03-04	2014-03-28	{"en_US": "Tyndale Christian School", "es_419": "Tyndale Christian School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
30	16	\N	1	1	1	external	\N	\N	2013-01-31	2015-04-01	{"en_US": "Green Ltd", "es_419": "Green Ltd"}	{"en_US": "<p>Arboriculturist</p>", "es_419": "<p>Arboricultor</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
31	16	\N	1	1	1	external	\N	\N	2012-12-01	\N	{"en_US": "Lynch-Hodges", "es_419": "Lynch-Hodges"}	{"en_US": "<p>Publishing rights manager</p>", "es_419": "<p>Gestión de derechos de publicación</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
32	16	\N	1	1	1	external	\N	\N	2012-12-31	\N	{"en_US": "Finley, Rowe and Adams", "es_419": "Finley, Rowe and Adams"}	{"en_US": "<p>Copywriter, advertising</p>", "es_419": "<p>Redactor, publicidad</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
33	17	\N	2	1	1	external	\N	\N	1996-03-04	1996-10-26	{"en_US": "Avoca Primary School", "es_419": "Avoca Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
34	17	\N	1	1	1	external	\N	\N	1997-11-03	\N	{"en_US": "Boyd, Wilson and Moore", "es_419": "Boyd, Wilson and Moore"}	{"en_US": "<p>Medical physicist</p>", "es_419": "<p>Físico médico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
35	17	\N	1	1	1	external	\N	\N	1997-02-02	1997-08-04	{"en_US": "Freeman, Williams and Berger", "es_419": "Freeman, Williams and Berger"}	{"en_US": "<p>Human resources officer</p>", "es_419": "<p>Responsable de recursos humanos</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
36	17	\N	1	1	1	external	\N	\N	1998-03-04	2003-03-04	{"en_US": "Hanson, Roach and Jordan", "es_419": "Hanson, Roach and Jordan"}	{"en_US": "<p>Geographical information systems officer</p>", "es_419": "<p>Encargado de sistemas de información geográfica</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
37	17	\N	1	1	1	external	\N	\N	2004-10-05	2016-06-04	{"en_US": "Davis PLC", "es_419": "Davis PLC"}	{"en_US": "<p>Secretary, company</p>", "es_419": "<p>Secretario, empresa</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
38	3	\N	2	1	1	external	\N	\N	1997-06-26	1999-03-17	{"en_US": "Parke State School", "es_419": "Parke State School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
39	3	\N	1	1	1	external	\N	\N	1999-04-26	\N	{"en_US": "Evans, Cooper and White", "es_419": "Evans, Cooper and White"}	{"en_US": "<p>Therapist, speech and language</p>", "es_419": "<p>Terapeuta del lenguaje</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
40	3	\N	1	1	1	external	\N	\N	1998-11-26	\N	{"en_US": "Rivera, Shaw and Hughes", "es_419": "Rivera, Shaw and Hughes"}	{"en_US": "<p>Landscape architect</p>", "es_419": "<p>Arquitecto paisajista</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
41	3	\N	1	1	1	external	\N	\N	1999-12-27	2001-07-27	{"en_US": "Phillips, Jones and Brown", "es_419": "Phillips, Jones and Brown"}	{"en_US": "<p>Teacher, special educational needs</p>", "es_419": "<p>Profesor, necesidades educativas especiales</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
42	3	\N	1	1	1	external	\N	\N	2002-02-24	2007-07-27	{"en_US": "Hughes, Parker and Barber", "es_419": "Hughes, Parker and Barber"}	{"en_US": "<p>Engineer, drilling</p>", "es_419": "<p>Ingeniero, perforación</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
43	10	\N	2	1	1	external	\N	\N	2006-12-22	2009-01-23	{"en_US": "St Michael's Primary School", "es_419": "St Michael's Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
44	10	\N	2	1	1	external	\N	\N	2006-02-21	2006-09-27	{"en_US": "Wodonga Primary School", "es_419": "Wodonga Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
45	10	\N	2	1	1	external	\N	\N	2003-10-14	2005-11-09	{"en_US": "Leinster School", "es_419": "Leinster School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
46	10	\N	1	1	1	external	\N	\N	2006-05-14	2008-11-14	{"en_US": "Russell-Webster", "es_419": "Russell-Webster"}	{"en_US": "<p>Biochemist, clinical</p>", "es_419": "<p>Bioquímico, clínico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
47	10	\N	1	1	1	external	\N	\N	2004-07-14	2005-11-14	{"en_US": "Lewis Group", "es_419": "Lewis Group"}	{"en_US": "<p>Sports development officer</p>", "es_419": "<p>Director de promoción deportiva</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
48	10	\N	1	1	1	external	\N	\N	2004-07-14	2005-11-14	{"en_US": "Johnson, Shaw and Carroll", "es_419": "Johnson, Shaw and Carroll"}	{"en_US": "<p>Engineer, mining</p>", "es_419": "<p>Ingeniero, minería</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
49	7	\N	2	1	1	external	\N	\N	2006-08-13	2008-09-30	{"en_US": "St Raphael's Primary School", "es_419": "St Raphael's Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
50	7	\N	2	1	1	external	\N	\N	2005-12-28	2006-08-09	{"en_US": "Woodridge State School", "es_419": "Woodridge State School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
51	7	\N	2	1	1	external	\N	\N	2003-06-07	2005-12-26	{"en_US": "Our Lady Star of the Sea School", "es_419": "Our Lady Star of the Sea School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
52	7	\N	1	1	1	external	\N	\N	2004-04-06	\N	{"en_US": "Chavez Group", "es_419": "Chavez Group"}	{"en_US": "<p>Mental health nurse</p>", "es_419": "<p>Enfermera de salud mental</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
53	7	\N	1	1	1	external	\N	\N	2005-05-07	2007-08-08	{"en_US": "Hubbard-Dean", "es_419": "Hubbard-Dean"}	{"en_US": "<p>Conference centre manager</p>", "es_419": "<p>Gestor de centros de conferencias</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
54	13	\N	2	1	1	external	\N	\N	2004-11-02	2007-10-09	{"en_US": "Narellan Public School", "es_419": "Narellan Public School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
55	13	\N	1	1	1	external	\N	\N	2006-02-01	\N	{"en_US": "Wilkinson PLC", "es_419": "Wilkinson PLC"}	{"en_US": "<p>Architectural technologist</p>", "es_419": "<p>Arquitecto técnico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
56	13	\N	1	1	1	external	\N	\N	2005-09-03	2006-12-03	{"en_US": "Simmons-Wilcox", "es_419": "Simmons-Wilcox"}	{"en_US": "<p>IT sales professional</p>", "es_419": "<p>Profesional de ventas de TI</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
57	13	\N	1	1	1	external	\N	\N	2007-06-03	\N	{"en_US": "Goodman Inc", "es_419": "Goodman Inc"}	{"en_US": "<p>Analytical chemist</p>", "es_419": "<p>Analista químico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
58	2	\N	2	1	1	external	\N	\N	1994-11-19	1997-02-18	{"en_US": "Armidale City Public School", "es_419": "Armidale City Public School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
59	2	\N	2	1	1	external	\N	\N	1993-05-11	1994-08-24	{"en_US": "Craigmore South Junior Primary School", "es_419": "Craigmore South Junior Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
60	2	\N	1	1	1	external	\N	\N	1993-12-12	1994-05-11	{"en_US": "Stanley-Mendez", "es_419": "Stanley-Mendez"}	{"en_US": "<p>Glass blower/designer</p>", "es_419": "<p>Soplador/diseñador de vidrio</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
61	2	\N	1	1	1	external	\N	\N	1995-04-12	1997-07-12	{"en_US": "Jackson, Schwartz and Aguirre", "es_419": "Jackson, Schwartz and Aguirre"}	{"en_US": "<p>Analytical chemist</p>", "es_419": "<p>Analista químico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
62	5	\N	2	1	1	external	\N	\N	1999-06-02	2000-12-01	{"en_US": "Wycheproof P-12 College", "es_419": "Wycheproof P-12 College"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
63	5	\N	2	1	1	external	\N	\N	1996-08-02	1999-02-01	{"en_US": "Christian Outreach College", "es_419": "Christian Outreach College"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
64	5	\N	2	1	1	external	\N	\N	1995-05-05	1996-07-27	{"en_US": "Thomas Chirnside Primary School", "es_419": "Thomas Chirnside Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
65	5	\N	1	1	1	external	\N	\N	1996-04-04	1997-07-05	{"en_US": "Logan-Martin", "es_419": "Logan-Martin"}	{"en_US": "<p>Petroleum engineer</p>", "es_419": "<p>Ingeniero petrolero</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
66	5	\N	1	1	1	external	\N	\N	1996-12-02	1997-08-05	{"en_US": "Gallegos, Little and Walters", "es_419": "Gallegos, Little and Walters"}	{"en_US": "<p>Lecturer, higher education</p>", "es_419": "<p>Profesor, educación superior</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
67	19	\N	2	1	1	external	\N	\N	2014-08-17	2016-05-06	{"en_US": "King Island District High School", "es_419": "King Island District High School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
68	19	\N	2	1	1	external	\N	\N	2013-07-18	2014-07-29	{"en_US": "Elphinstone Primary School", "es_419": "Elphinstone Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
69	19	\N	2	1	1	external	\N	\N	2011-01-29	2013-03-30	{"en_US": "William Light R-12 School", "es_419": "William Light R-12 School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
70	19	\N	1	1	1	external	\N	\N	2012-10-30	2013-08-29	{"en_US": "Davis PLC", "es_419": "Davis PLC"}	{"en_US": "<p>Engineer, production</p>", "es_419": "<p>Ingeniero, producción</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
71	19	\N	1	1	1	external	\N	\N	2013-05-01	\N	{"en_US": "Perez-Morgan", "es_419": "Perez-Morgan"}	{"en_US": "<p>Geoscientist</p>", "es_419": "<p>Geocientífico</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
72	18	\N	2	1	1	external	\N	\N	2003-02-16	2004-05-18	{"en_US": "Ellinbank Primary School", "es_419": "Ellinbank Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
73	18	\N	2	1	1	external	\N	\N	2002-07-01	2003-02-09	{"en_US": "Talbot Primary School", "es_419": "Talbot Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
74	18	\N	1	1	1	external	\N	\N	2003-07-01	\N	{"en_US": "Saunders-Adkins", "es_419": "Saunders-Adkins"}	{"en_US": "<p>Jewellery designer</p>", "es_419": "<p>Diseñador de joyería</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
75	18	\N	1	1	1	external	\N	\N	2004-12-28	2006-07-01	{"en_US": "Davis and Sons", "es_419": "Davis and Sons"}	{"en_US": "<p>Health physicist</p>", "es_419": "<p>Física sanitaria</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
76	18	\N	1	1	1	external	\N	\N	2003-12-29	\N	{"en_US": "Arnold-Cohen", "es_419": "Arnold-Cohen"}	{"en_US": "<p>Personnel officer</p>", "es_419": "<p>Responsable del personal</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
77	11	\N	2	1	1	external	\N	\N	1998-06-07	2000-02-17	{"en_US": "Lawson Public School", "es_419": "Lawson Public School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
78	11	\N	2	1	1	external	\N	\N	1995-08-21	1998-04-10	{"en_US": "Trinity College", "es_419": "Trinity College"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
79	11	\N	2	1	1	external	\N	\N	1992-11-22	1995-05-05	{"en_US": "Woodend Primary School", "es_419": "Woodend Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
80	11	\N	1	1	1	external	\N	\N	1994-11-22	1996-01-22	{"en_US": "Mcneil, Rodriguez and Warren", "es_419": "Mcneil, Rodriguez and Warren"}	{"en_US": "<p>Sub</p>", "es_419": "<p>Sub</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
81	11	\N	1	1	1	external	\N	\N	1996-05-25	1997-11-22	{"en_US": "Davis, Sanchez and Miller", "es_419": "Davis, Sanchez and Miller"}	{"en_US": "<p>Customer service manager</p>", "es_419": "<p>Gerente de atención al cliente</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
82	11	\N	1	1	1	external	\N	\N	1994-02-22	\N	{"en_US": "Cole Ltd", "es_419": "Cole Ltd"}	{"en_US": "<p>Fast food restaurant manager</p>", "es_419": "<p>Gerente de restaurante de comida rápida</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
83	11	\N	1	1	1	external	\N	\N	1998-07-25	1999-12-23	{"en_US": "Garcia and Sons", "es_419": "Garcia and Sons"}	{"en_US": "<p>Careers information officer</p>", "es_419": "<p>Responsable de información sobre carreras profesionales</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
84	9	\N	2	1	1	external	\N	\N	2009-11-08	2010-09-30	{"en_US": "Umbakumba School", "es_419": "Umbakumba School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
85	9	\N	1	1	1	external	\N	\N	2011-02-07	2012-01-08	{"en_US": "Wilson Ltd", "es_419": "Wilson Ltd"}	{"en_US": "<p>Trade union research officer</p>", "es_419": "<p>Responsable de investigación sindical</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
86	20	\N	2	1	1	external	\N	\N	2005-04-10	2006-09-30	{"en_US": "Port Curtis Road State School", "es_419": "Port Curtis Road State School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
87	20	\N	2	1	1	external	\N	\N	2004-01-12	2005-03-10	{"en_US": "Claremont College", "es_419": "Claremont College"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
88	20	\N	2	1	1	external	\N	\N	2003-02-08	2003-09-28	{"en_US": "Mandurah Catholic College", "es_419": "Mandurah Catholic College"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
89	20	\N	1	1	1	external	\N	\N	2004-01-10	\N	{"en_US": "Douglas, Thompson and Conner", "es_419": "Douglas, Thompson and Conner"}	{"en_US": "<p>Music therapist</p>", "es_419": "<p>Terapeuta musical</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
90	20	\N	1	1	1	external	\N	\N	2005-07-09	2007-03-11	{"en_US": "Allen-Keller", "es_419": "Allen-Keller"}	{"en_US": "<p>Lexicographer</p>", "es_419": "<p>Lexicógrafo</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
91	12	\N	2	1	1	external	\N	\N	2001-04-13	2002-09-06	{"en_US": "Tottenham Central School", "es_419": "Tottenham Central School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
92	12	\N	2	1	1	external	\N	\N	2000-08-07	2001-02-16	{"en_US": "Galilee Catholic School", "es_419": "Galilee Catholic School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
93	12	\N	1	1	1	external	\N	\N	2001-05-07	\N	{"en_US": "Martin, Stanley and Duncan", "es_419": "Martin, Stanley and Duncan"}	{"en_US": "<p>IT technical support officer</p>", "es_419": "<p>Técnico de soporte informático</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
94	12	\N	1	1	1	external	\N	\N	2003-03-07	2005-10-05	{"en_US": "Fox and Sons", "es_419": "Fox and Sons"}	{"en_US": "<p>Merchant navy officer</p>", "es_419": "<p>Oficial de la Marina Mercante</p>"}	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
95	8	\N	2	1	1	external	\N	\N	2009-07-16	2012-07-23	{"en_US": "Holy Family Primary School", "es_419": "Holy Family Primary School"}	\N	\N	2026-01-08 15:33:59.205275	2026-01-08 15:33:59.205275
97	8	\N	2	1	1	external	\N	\N	2005-12-14	2007-06-