--
-- PostgreSQL database dump
--

\restrict ntPVRgrSiP6RscGOIiprgC94xi0nxhFcALhH7jsfiec06F1lBXF4LI8u6oRbJJc

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 16.11 (Debian 16.11-1.pgdg12+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_assets OWNER TO runbot;

--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_default OWNER TO runbot;

--
-- Name: base_cache_signaling_groups; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_groups
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_groups OWNER TO runbot;

--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_routing OWNER TO runbot;

--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_templates OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: bg_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bg_job (
    id integer NOT NULL,
    priority integer,
    max_retries integer,
    retry_count integer,
    next_job_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    model character varying NOT NULL,
    method character varying NOT NULL,
    batch_id character varying NOT NULL,
    args_json jsonb,
    kwargs_json jsonb,
    context_json jsonb,
    error_message text,
    start_time timestamp without time zone,
    end_time timestamp without time zone,
    cancel_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.bg_job OWNER TO runbot;

--
-- Name: TABLE bg_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bg_job IS 'Background Job';


--
-- Name: COLUMN bg_job.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.priority IS 'Priority';


--
-- Name: COLUMN bg_job.max_retries; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.max_retries IS 'Max Retries';


--
-- Name: COLUMN bg_job.retry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.retry_count IS 'Retry Count';


--
-- Name: COLUMN bg_job.next_job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.next_job_id IS 'Next Job';


--
-- Name: COLUMN bg_job.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.create_uid IS 'Created by';


--
-- Name: COLUMN bg_job.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bg_job.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.name IS 'Job Name';


--
-- Name: COLUMN bg_job.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.state IS 'State';


--
-- Name: COLUMN bg_job.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.model IS 'Model';


--
-- Name: COLUMN bg_job.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.method IS 'Method';


--
-- Name: COLUMN bg_job.batch_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.batch_id IS 'Batch';


--
-- Name: COLUMN bg_job.args_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.args_json IS 'Args Json';


--
-- Name: COLUMN bg_job.kwargs_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.kwargs_json IS 'Kwargs Json';


--
-- Name: COLUMN bg_job.context_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.context_json IS 'Context Json';


--
-- Name: COLUMN bg_job.error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.error_message IS 'Error Message';


--
-- Name: COLUMN bg_job.start_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.start_time IS 'Start Time';


--
-- Name: COLUMN bg_job.end_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.end_time IS 'End Time';


--
-- Name: COLUMN bg_job.cancel_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.cancel_time IS 'Cancel Time';


--
-- Name: COLUMN bg_job.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.create_date IS 'Created on';


--
-- Name: COLUMN bg_job.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.write_date IS 'Last Updated on';


--
-- Name: COLUMN bg_job.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.duration IS 'Duration';


--
-- Name: bg_job_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bg_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bg_job_id_seq OWNER TO runbot;

--
-- Name: bg_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bg_job_id_seq OWNED BY public.bg_job.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    guest_id integer,
    CONSTRAINT bus_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN bus_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.guest_id IS 'Guest';


--
-- Name: CONSTRAINT bus_presence_partner_or_guest_exists ON bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT bus_presence_partner_or_guest_exists ON public.bus_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: db_configuration; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.db_configuration (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.db_configuration OWNER TO runbot;

--
-- Name: TABLE db_configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.db_configuration IS 'db.configuration';


--
-- Name: COLUMN db_configuration.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.create_uid IS 'Created by';


--
-- Name: COLUMN db_configuration.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.write_uid IS 'Last Updated by';


--
-- Name: COLUMN db_configuration.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.name IS 'Name';


--
-- Name: COLUMN db_configuration.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.create_date IS 'Created on';


--
-- Name: COLUMN db_configuration.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.write_date IS 'Last Updated on';


--
-- Name: db_configuration_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.db_configuration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.db_configuration_id_seq OWNER TO runbot;

--
-- Name: db_configuration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.db_configuration_id_seq OWNED BY public.db_configuration.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    allow_public_upload boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL))),
    CONSTRAINT discuss_channel_sub_channel_no_group_public_id CHECK (((parent_channel_id IS NULL) OR (group_public_id IS NULL)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.allow_public_upload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.allow_public_upload IS 'Allow Public Upload';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON public.discuss_channel IS 'CHECK(parent_channel_id IS NULL OR group_public_id IS NULL)';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    fold_state character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.fold_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fold_state IS 'Conversation Fold State';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision,
    sender_name character varying
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: COLUMN iap_account.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.sender_name IS 'Sender Name';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    selection_value integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text,
    template_id integer,
    activity_type_id integer,
    activity_date_deadline_range integer,
    activity_user_id integer,
    mail_post_method character varying,
    activity_summary character varying,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_field_name character varying,
    activity_note text,
    mail_post_autofollow boolean,
    sms_template_id integer,
    sms_method character varying
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.mail_post_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_method IS 'Send Email As';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Title';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'User Type';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User Field';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.mail_post_autofollow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_autofollow IS 'Subscribe Recipients';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_method IS 'Send SMS As';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    json_value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default.json_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.json_value IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
                (action_id IS NOT NULL AND python_method IS NULL) OR
                (action_id IS NULL AND python_method IS NOT NULL)
            )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(
                NOT (python_method IS NOT NULL AND name IS NULL)
            )';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(
                NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL)
            )';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN ir_mail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Has Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Has Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Has Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    tracking integer,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer NOT NULL,
    res_id integer,
    activity_type_id integer,
    user_id integer NOT NULL,
    request_partner_id integer,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    res_name character varying,
    summary character varying,
    user_tz character varying,
    date_deadline date NOT NULL,
    date_done date,
    note text,
    automated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT mail_activity_check_res_id_is_set CHECK (((res_id IS NOT NULL) AND (res_id <> 0)))
);


ALTER TABLE public.mail_activity OWNER TO runbot;

--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.request_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.request_partner_id IS 'Requesting Partner';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.user_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_tz IS 'Timezone';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_done IS 'Done Date';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.active IS 'Active';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT mail_activity_check_res_id_is_set ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_res_id_is_set ON public.mail_activity IS 'CHECK(res_id IS NOT NULL AND res_id !=0 )';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_id_seq OWNER TO runbot;

--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan (
    id integer NOT NULL,
    company_id integer,
    res_model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan IS 'Activity Plan';


--
-- Name: COLUMN mail_activity_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.company_id IS 'Company';


--
-- Name: COLUMN mail_activity_plan.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.name IS 'Name';


--
-- Name: COLUMN mail_activity_plan.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.active IS 'Active';


--
-- Name: COLUMN mail_activity_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_id_seq OWNED BY public.mail_activity_plan.id;


--
-- Name: mail_activity_plan_mail_activity_schedule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_mail_activity_schedule_rel (
    mail_activity_schedule_id integer NOT NULL,
    mail_activity_plan_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_mail_activity_schedule_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_mail_activity_schedule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_mail_activity_schedule_rel IS 'RELATION BETWEEN mail_activity_schedule AND mail_activity_plan';


--
-- Name: mail_activity_plan_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    sequence integer,
    activity_type_id integer NOT NULL,
    delay_count integer,
    responsible_id integer,
    create_uid integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    summary character varying,
    responsible_type character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan_template OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template IS 'Activity plan template';


--
-- Name: COLUMN mail_activity_plan_template.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_plan_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_plan_template.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_plan_template.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_count IS 'Interval';


--
-- Name: COLUMN mail_activity_plan_template.responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_plan_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan_template.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_plan_template.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_from IS 'Trigger';


--
-- Name: COLUMN mail_activity_plan_template.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_plan_template.responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_type IS 'Assignment';


--
-- Name: COLUMN mail_activity_plan_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.note IS 'Note';


--
-- Name: COLUMN mail_activity_plan_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNED BY public.mail_activity_plan_template.id;


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


ALTER TABLE public.mail_activity_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule (
    id integer NOT NULL,
    res_model_id integer NOT NULL,
    plan_id integer,
    plan_on_demand_user_id integer,
    activity_type_id integer,
    activity_user_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    summary character varying,
    plan_date date,
    date_deadline date,
    res_ids text,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule IS 'Activity schedule plan Wizard';


--
-- Name: COLUMN mail_activity_schedule.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_schedule.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_schedule.plan_on_demand_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_on_demand_user_id IS 'Assigned To';


--
-- Name: COLUMN mail_activity_schedule.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_schedule.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_schedule.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_schedule.plan_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_date IS 'Plan Date';


--
-- Name: COLUMN mail_activity_schedule.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity_schedule.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_ids IS 'Document IDs';


--
-- Name: COLUMN mail_activity_schedule.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.note IS 'Note';


--
-- Name: COLUMN mail_activity_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNED BY public.mail_activity_schedule.id;


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    delay_count integer,
    triggered_next_type_id integer,
    default_user_id integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model character varying,
    chaining_type character varying NOT NULL,
    category character varying,
    name jsonb NOT NULL,
    summary jsonb,
    default_note jsonb,
    active boolean,
    keep_done boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_type OWNER TO runbot;

--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Schedule';


--
-- Name: COLUMN mail_activity_type.triggered_next_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.triggered_next_type_id IS 'Trigger';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_type.chaining_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.chaining_type IS 'Chaining Type';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.default_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_note IS 'Default Note';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.keep_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.keep_done IS 'Keep Done';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_type_id_seq OWNER TO runbot;

--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_activity_type_mail_template_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_domain_id integer,
    alias_model_id integer NOT NULL,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    create_uid integer,
    write_uid integer,
    alias_name character varying,
    alias_full_name character varying,
    alias_contact character varying NOT NULL,
    alias_status character varying,
    alias_bounced_content jsonb,
    alias_defaults text NOT NULL,
    alias_incoming_local boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias OWNER TO runbot;

--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_full_name IS 'Alias Email';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_status IS 'Alias Status';


--
-- Name: COLUMN mail_alias.alias_bounced_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_bounced_content IS 'Custom Bounced Message';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_incoming_local; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_incoming_local IS 'Local-part based incoming detection';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias_domain (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bounce_alias character varying NOT NULL,
    catchall_alias character varying NOT NULL,
    default_from character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias_domain OWNER TO runbot;

--
-- Name: TABLE mail_alias_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias_domain IS 'Email Domain';


--
-- Name: COLUMN mail_alias_domain.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.sequence IS 'Sequence';


--
-- Name: COLUMN mail_alias_domain.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias_domain.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias_domain.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.name IS 'Name';


--
-- Name: COLUMN mail_alias_domain.bounce_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.bounce_alias IS 'Bounce Alias';


--
-- Name: COLUMN mail_alias_domain.catchall_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.catchall_alias IS 'Catchall Alias';


--
-- Name: COLUMN mail_alias_domain.default_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.default_from IS 'Default From Alias';


--
-- Name: COLUMN mail_alias_domain.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias_domain.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_domain_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_domain_id_seq OWNER TO runbot;

--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_domain_id_seq OWNED BY public.mail_alias_domain.id;


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_id_seq OWNER TO runbot;

--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist OWNER TO runbot;

--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE mail_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist_remove IS 'Remove email from blacklist wizard';


--
-- Name: COLUMN mail_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist_remove.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.email IS 'Email';


--
-- Name: COLUMN mail_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN mail_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNED BY public.mail_blacklist_remove.id;


--
-- Name: mail_canned_response; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source character varying NOT NULL,
    description character varying,
    substitution text NOT NULL,
    is_shared boolean,
    last_used timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_canned_response OWNER TO runbot;

--
-- Name: TABLE mail_canned_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response IS 'Canned Response';


--
-- Name: COLUMN mail_canned_response.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_uid IS 'Created by';


--
-- Name: COLUMN mail_canned_response.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_canned_response.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.source IS 'Shortcut';


--
-- Name: COLUMN mail_canned_response.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.description IS 'Description';


--
-- Name: COLUMN mail_canned_response.substitution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.substitution IS 'Substitution';


--
-- Name: COLUMN mail_canned_response.is_shared; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.is_shared IS 'Determines if the canned_response is currently shared with other users';


--
-- Name: COLUMN mail_canned_response.last_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.last_used IS 'Last Used';


--
-- Name: COLUMN mail_canned_response.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_date IS 'Created on';


--
-- Name: COLUMN mail_canned_response.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_date IS 'Last Updated on';


--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_canned_response_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_canned_response_id_seq OWNER TO runbot;

--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_canned_response_id_seq OWNED BY public.mail_canned_response.id;


--
-- Name: mail_canned_response_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response_res_groups_rel (
    mail_canned_response_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.mail_canned_response_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE mail_canned_response_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response_res_groups_rel IS 'RELATION BETWEEN mail_canned_response AND res_groups';


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    template_id integer,
    parent_id integer,
    author_id integer,
    res_domain_user_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    email_layout_xmlid character varying,
    email_from character varying,
    composition_mode character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    reply_to character varying,
    scheduled_date character varying,
    template_name character varying,
    body text,
    res_ids text,
    res_domain text,
    email_add_signature boolean,
    reply_to_force_new boolean,
    auto_delete boolean,
    auto_delete_keep_log boolean,
    force_send boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_compose_message OWNER TO runbot;

--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.res_domain_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain_user_id IS 'Responsible';


--
-- Name: COLUMN mail_compose_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_compose_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.lang IS 'Language';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_name IS 'Record Name';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_compose_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_compose_message.template_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_name IS 'Template Name';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_compose_message.res_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_add_signature IS 'Add signature';


--
-- Name: COLUMN mail_compose_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to_force_new IS 'Considers answers as new thread';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_keep_log IS 'Keep Message Copy';


--
-- Name: COLUMN mail_compose_message.force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.force_send IS 'Send mailing or notifications directly';


--
-- Name: COLUMN mail_compose_message.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.use_exclusion_list IS 'Check Exclusion List';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_compose_message_id_seq OWNER TO runbot;

--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_id integer,
    partner_id integer NOT NULL,
    res_model character varying NOT NULL
);


ALTER TABLE public.mail_followers OWNER TO runbot;

--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_id_seq OWNER TO runbot;

--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_followers_mail_message_subtype_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_gateway_allowed; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_gateway_allowed (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    email_normalized character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_gateway_allowed OWNER TO runbot;

--
-- Name: TABLE mail_gateway_allowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_gateway_allowed IS 'Mail Gateway Allowed';


--
-- Name: COLUMN mail_gateway_allowed.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_uid IS 'Created by';


--
-- Name: COLUMN mail_gateway_allowed.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_gateway_allowed.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email IS 'Email Address';


--
-- Name: COLUMN mail_gateway_allowed.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN mail_gateway_allowed.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_date IS 'Created on';


--
-- Name: COLUMN mail_gateway_allowed.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_date IS 'Last Updated on';


--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_gateway_allowed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNER TO runbot;

--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNED BY public.mail_gateway_allowed.id;


--
-- Name: mail_guest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_guest (
    id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    access_token character varying NOT NULL,
    lang character varying,
    timezone character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_guest OWNER TO runbot;

--
-- Name: TABLE mail_guest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_guest IS 'Guest';


--
-- Name: COLUMN mail_guest.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.country_id IS 'Country';


--
-- Name: COLUMN mail_guest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_uid IS 'Created by';


--
-- Name: COLUMN mail_guest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_guest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.name IS 'Name';


--
-- Name: COLUMN mail_guest.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.access_token IS 'Access Token';


--
-- Name: COLUMN mail_guest.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.lang IS 'Language';


--
-- Name: COLUMN mail_guest.timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.timezone IS 'Timezone';


--
-- Name: COLUMN mail_guest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_date IS 'Created on';


--
-- Name: COLUMN mail_guest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_date IS 'Last Updated on';


--
-- Name: mail_guest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_guest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_guest_id_seq OWNER TO runbot;

--
-- Name: mail_guest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_guest_id_seq OWNED BY public.mail_guest.id;


--
-- Name: mail_ice_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_ice_server (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_type character varying NOT NULL,
    uri character varying NOT NULL,
    username character varying,
    credential character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_ice_server OWNER TO runbot;

--
-- Name: TABLE mail_ice_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_ice_server IS 'ICE server';


--
-- Name: COLUMN mail_ice_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_uid IS 'Created by';


--
-- Name: COLUMN mail_ice_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_ice_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.server_type IS 'Type';


--
-- Name: COLUMN mail_ice_server.uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.uri IS 'URI';


--
-- Name: COLUMN mail_ice_server.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.username IS 'Username';


--
-- Name: COLUMN mail_ice_server.credential; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.credential IS 'Credential';


--
-- Name: COLUMN mail_ice_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_date IS 'Created on';


--
-- Name: COLUMN mail_ice_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_date IS 'Last Updated on';


--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_ice_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_ice_server_id_seq OWNER TO runbot;

--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_ice_server_id_seq OWNED BY public.mail_ice_server.id;


--
-- Name: mail_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_link_preview (
    id integer NOT NULL,
    message_id integer,
    create_uid integer,
    write_uid integer,
    source_url character varying NOT NULL,
    og_type character varying,
    og_title character varying,
    og_site_name character varying,
    og_image character varying,
    og_mimetype character varying,
    image_mimetype character varying,
    og_description text,
    is_hidden boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_link_preview IS 'Store link preview data';


--
-- Name: COLUMN mail_link_preview.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.message_id IS 'Message';


--
-- Name: COLUMN mail_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_link_preview.source_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.source_url IS 'URL';


--
-- Name: COLUMN mail_link_preview.og_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_type IS 'Type';


--
-- Name: COLUMN mail_link_preview.og_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_title IS 'Title';


--
-- Name: COLUMN mail_link_preview.og_site_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_site_name IS 'Site name';


--
-- Name: COLUMN mail_link_preview.og_image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_image IS 'Image';


--
-- Name: COLUMN mail_link_preview.og_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_mimetype IS 'MIME type';


--
-- Name: COLUMN mail_link_preview.image_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.image_mimetype IS 'Image MIME type';


--
-- Name: COLUMN mail_link_preview.og_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_description IS 'Description';


--
-- Name: COLUMN mail_link_preview.is_hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.is_hidden IS 'Is Hidden';


--
-- Name: COLUMN mail_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_date IS 'Create Date';


--
-- Name: COLUMN mail_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_link_preview_id_seq OWNED BY public.mail_link_preview.id;


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    fetchmail_server_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    state character varying,
    failure_type character varying,
    body_html text,
    "references" text,
    headers text,
    email_to text,
    failure_reason text,
    is_notification boolean,
    auto_delete boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_mail OWNER TO runbot;

--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.is_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.is_notification IS 'Notification Email';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_mail_id_seq OWNER TO runbot;

--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_mail_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    pinned_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.pinned_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.pinned_at IS 'Pinned';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_id_seq OWNER TO runbot;

--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_reaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_reaction (
    id integer NOT NULL,
    message_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    content character varying NOT NULL,
    CONSTRAINT mail_message_reaction_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_message_reaction OWNER TO runbot;

--
-- Name: TABLE mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_reaction IS 'Message Reaction';


--
-- Name: COLUMN mail_message_reaction.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.message_id IS 'Message';


--
-- Name: COLUMN mail_message_reaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.partner_id IS 'Reacting Partner';


--
-- Name: COLUMN mail_message_reaction.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.guest_id IS 'Reacting Guest';


--
-- Name: COLUMN mail_message_reaction.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.content IS 'Content';


--
-- Name: CONSTRAINT mail_message_reaction_partner_or_guest_exists ON mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_message_reaction_partner_or_guest_exists ON public.mail_message_reaction IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_reaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_reaction_id_seq OWNER TO runbot;

--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_reaction_id_seq OWNED BY public.mail_message_reaction.id;


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_starred_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_schedule (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    notification_parameters text,
    scheduled_datetime timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_schedule OWNER TO runbot;

--
-- Name: TABLE mail_message_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_schedule IS 'Scheduled Messages';


--
-- Name: COLUMN mail_message_schedule.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_message_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_schedule.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.notification_parameters IS 'Notification Parameter';


--
-- Name: COLUMN mail_message_schedule.scheduled_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.scheduled_datetime IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_message_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_schedule_id_seq OWNED BY public.mail_message_schedule.id;


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    parent_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    relation_field character varying,
    res_model character varying,
    name jsonb NOT NULL,
    description jsonb,
    internal boolean,
    "default" boolean,
    hidden boolean,
    track_recipients boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_subtype OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.track_recipients; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.track_recipients IS 'Track Recipients';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_subtype_id_seq OWNER TO runbot;

--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_message_translation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_translation (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_lang character varying NOT NULL,
    target_lang character varying NOT NULL,
    body text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_translation OWNER TO runbot;

--
-- Name: TABLE mail_message_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_translation IS 'Message Translation';


--
-- Name: COLUMN mail_message_translation.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.message_id IS 'Message';


--
-- Name: COLUMN mail_message_translation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_translation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_translation.source_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.source_lang IS 'Source Language';


--
-- Name: COLUMN mail_message_translation.target_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.target_lang IS 'Target Language';


--
-- Name: COLUMN mail_message_translation.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.body IS 'Translation Body';


--
-- Name: COLUMN mail_message_translation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_date IS 'Create Date';


--
-- Name: COLUMN mail_message_translation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_date IS 'Last Updated on';


--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_translation_id_seq OWNER TO runbot;

--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_translation_id_seq OWNED BY public.mail_message_translation.id;


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification (
    id integer NOT NULL,
    author_id integer,
    mail_message_id integer NOT NULL,
    mail_mail_id integer,
    res_partner_id integer,
    notification_type character varying NOT NULL,
    notification_status character varying,
    failure_type character varying,
    failure_reason text,
    is_read boolean,
    read_date timestamp without time zone,
    sms_id_int integer,
    sms_number character varying,
    letter_id integer,
    CONSTRAINT mail_notification_notification_partner_required CHECK ((((notification_type)::text <> ALL ((ARRAY['email'::character varying, 'inbox'::character varying])::text[])) OR (res_partner_id IS NOT NULL)))
);


ALTER TABLE public.mail_notification OWNER TO runbot;

--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification IS 'Message Notifications';


--
-- Name: COLUMN mail_notification.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.author_id IS 'Author';


--
-- Name: COLUMN mail_notification.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_notification.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mail_notification.res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.res_partner_id IS 'Recipient';


--
-- Name: COLUMN mail_notification.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_notification.notification_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_status IS 'Status';


--
-- Name: COLUMN mail_notification.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_notification.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.is_read IS 'Is Read';


--
-- Name: COLUMN mail_notification.read_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.read_date IS 'Read Date';


--
-- Name: COLUMN mail_notification.sms_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_id_int IS 'SMS ID';


--
-- Name: COLUMN mail_notification.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_number IS 'SMS Number';


--
-- Name: COLUMN mail_notification.letter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.letter_id IS 'Snailmail Letter';


--
-- Name: CONSTRAINT mail_notification_notification_partner_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_required ON public.mail_notification IS 'CHECK(notification_type NOT IN (''email'', ''inbox'') OR res_partner_id IS NOT NULL)';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_notification_id_seq OWNER TO runbot;

--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_notification_id_seq OWNED BY public.mail_notification.id;


--
-- Name: mail_notification_mail_resend_message_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification_mail_resend_message_rel (
    mail_resend_message_id integer NOT NULL,
    mail_notification_id integer NOT NULL
);


ALTER TABLE public.mail_notification_mail_resend_message_rel OWNER TO runbot;

--
-- Name: TABLE mail_notification_mail_resend_message_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification_mail_resend_message_rel IS 'RELATION BETWEEN mail_resend_message AND mail_notification';


--
-- Name: mail_push; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push (
    id integer NOT NULL,
    mail_push_device_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payload text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push OWNER TO runbot;

--
-- Name: TABLE mail_push; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push IS 'Push Notifications';


--
-- Name: COLUMN mail_push.mail_push_device_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.mail_push_device_id IS 'devices';


--
-- Name: COLUMN mail_push.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push.payload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.payload IS 'Payload';


--
-- Name: COLUMN mail_push.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_date IS 'Created on';


--
-- Name: COLUMN mail_push.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_date IS 'Last Updated on';


--
-- Name: mail_push_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push_device (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    endpoint character varying NOT NULL,
    keys character varying NOT NULL,
    expiration_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push_device OWNER TO runbot;

--
-- Name: TABLE mail_push_device; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push_device IS 'Push Notification Device';


--
-- Name: COLUMN mail_push_device.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.partner_id IS 'Partner';


--
-- Name: COLUMN mail_push_device.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push_device.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push_device.endpoint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.endpoint IS 'Browser endpoint';


--
-- Name: COLUMN mail_push_device.keys; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.keys IS 'Browser keys';


--
-- Name: COLUMN mail_push_device.expiration_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.expiration_time IS 'Expiration Token Date';


--
-- Name: COLUMN mail_push_device.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_date IS 'Created on';


--
-- Name: COLUMN mail_push_device.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_date IS 'Last Updated on';


--
-- Name: mail_push_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_device_id_seq OWNER TO runbot;

--
-- Name: mail_push_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_device_id_seq OWNED BY public.mail_push_device.id;


--
-- Name: mail_push_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_id_seq OWNER TO runbot;

--
-- Name: mail_push_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_id_seq OWNED BY public.mail_push.id;


--
-- Name: mail_resend_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_message (
    id integer NOT NULL,
    mail_message_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_message OWNER TO runbot;

--
-- Name: TABLE mail_resend_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_message IS 'Email resend wizard';


--
-- Name: COLUMN mail_resend_message.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_resend_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_date IS 'Last Updated on';


--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_message_id_seq OWNER TO runbot;

--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_message_id_seq OWNED BY public.mail_resend_message.id;


--
-- Name: mail_resend_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_partner (
    id integer NOT NULL,
    notification_id integer NOT NULL,
    resend_wizard_id integer,
    create_uid integer,
    write_uid integer,
    message character varying,
    resend boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_partner OWNER TO runbot;

--
-- Name: TABLE mail_resend_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_partner IS 'Partner with additional information for mail resend';


--
-- Name: COLUMN mail_resend_partner.notification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.notification_id IS 'Notification';


--
-- Name: COLUMN mail_resend_partner.resend_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend_wizard_id IS 'Resend wizard';


--
-- Name: COLUMN mail_resend_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_partner.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.message IS 'Error message';


--
-- Name: COLUMN mail_resend_partner.resend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend IS 'Try Again';


--
-- Name: COLUMN mail_resend_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_date IS 'Last Updated on';


--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_partner_id_seq OWNER TO runbot;

--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_partner_id_seq OWNED BY public.mail_resend_partner.id;


--
-- Name: mail_scheduled_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message (
    id integer NOT NULL,
    res_id integer NOT NULL,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying NOT NULL,
    body text,
    notification_parameters text,
    is_note boolean,
    scheduled_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_scheduled_message OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message IS 'Scheduled Message';


--
-- Name: COLUMN mail_scheduled_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.res_id IS 'Related Document Id';


--
-- Name: COLUMN mail_scheduled_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.author_id IS 'Author';


--
-- Name: COLUMN mail_scheduled_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_scheduled_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_scheduled_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.subject IS 'Subject';


--
-- Name: COLUMN mail_scheduled_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_scheduled_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.body IS 'Contents';


--
-- Name: COLUMN mail_scheduled_message.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.notification_parameters IS 'Notification parameters';


--
-- Name: COLUMN mail_scheduled_message.is_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.is_note IS 'Is a note';


--
-- Name: COLUMN mail_scheduled_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_scheduled_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_scheduled_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_date IS 'Last Updated on';


--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_scheduled_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNER TO runbot;

--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNED BY public.mail_scheduled_message.id;


--
-- Name: mail_scheduled_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message_res_partner_rel (
    mail_scheduled_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_scheduled_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message_res_partner_rel IS 'RELATION BETWEEN mail_scheduled_message AND res_partner';


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    model_id integer,
    user_id integer,
    mail_server_id integer,
    ref_ir_act_window integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    email_from character varying,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    scheduled_date character varying,
    name jsonb,
    description jsonb,
    subject jsonb,
    body_html jsonb,
    active boolean,
    use_default_to boolean,
    auto_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template OWNER TO runbot;

--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.user_id IS 'User';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_from IS 'From';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_template.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.description IS 'Template Description';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.active IS 'Active';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default recipients';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_id_seq OWNER TO runbot;

--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_template_ir_actions_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_ir_actions_report_rel (
    mail_template_id integer NOT NULL,
    ir_actions_report_id integer NOT NULL
);


ALTER TABLE public.mail_template_ir_actions_report_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_ir_actions_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_ir_actions_report_rel IS 'RELATION BETWEEN mail_template AND ir_act_report_xml';


--
-- Name: mail_template_mail_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_mail_template_reset_rel (
    mail_template_reset_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_template_mail_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_mail_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_mail_template_reset_rel IS 'RELATION BETWEEN mail_template_reset AND mail_template';


--
-- Name: mail_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_preview (
    id integer NOT NULL,
    mail_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    lang character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_preview OWNER TO runbot;

--
-- Name: TABLE mail_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN mail_template_preview.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.mail_template_id IS 'Related Mail Template';


--
-- Name: COLUMN mail_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.resource_ref IS 'Record';


--
-- Name: COLUMN mail_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN mail_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_date IS 'Last Updated on';


--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_preview_id_seq OWNER TO runbot;

--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_preview_id_seq OWNED BY public.mail_template_preview.id;


--
-- Name: mail_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_reset OWNER TO runbot;

--
-- Name: TABLE mail_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_reset IS 'Mail Template Reset';


--
-- Name: COLUMN mail_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_date IS 'Last Updated on';


--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_reset_id_seq OWNER TO runbot;

--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_reset_id_seq OWNED BY public.mail_template_reset.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field_id integer,
    old_value_integer integer,
    new_value_integer integer,
    currency_id integer,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    old_value_char character varying,
    new_value_char character varying,
    field_info jsonb,
    old_value_text text,
    new_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    old_value_float double precision,
    new_value_float double precision
);


ALTER TABLE public.mail_tracking_value OWNER TO runbot;

--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_id IS 'Field';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.currency_id IS 'Currency';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.field_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_info IS 'Removed field information';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_tracking_value_id_seq OWNER TO runbot;

--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: mail_wizard_invite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite (
    id integer NOT NULL,
    res_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    message text,
    notify boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_wizard_invite OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite IS 'Invite wizard';


--
-- Name: COLUMN mail_wizard_invite.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_wizard_invite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_uid IS 'Created by';


--
-- Name: COLUMN mail_wizard_invite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_wizard_invite.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_wizard_invite.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.message IS 'Message';


--
-- Name: COLUMN mail_wizard_invite.notify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.notify IS 'Notify Recipients';


--
-- Name: COLUMN mail_wizard_invite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_date IS 'Created on';


--
-- Name: COLUMN mail_wizard_invite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_date IS 'Last Updated on';


--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_wizard_invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNER TO runbot;

--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNED BY public.mail_wizard_invite.id;


--
-- Name: mail_wizard_invite_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite_res_partner_rel (
    mail_wizard_invite_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_wizard_invite_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite_res_partner_rel IS 'RELATION BETWEEN mail_wizard_invite AND res_partner';


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    number character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist OWNER TO runbot;

--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: phone_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE phone_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist_remove IS 'Remove phone from blacklist';


--
-- Name: COLUMN phone_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist_remove.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.phone IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN phone_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNED BY public.phone_blacklist_remove.id;


--
-- Name: privacy_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    anonymized_name character varying NOT NULL,
    anonymized_email character varying NOT NULL,
    execution_details text,
    records_description text,
    additional_note text,
    date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_log OWNER TO runbot;

--
-- Name: TABLE privacy_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_log IS 'Privacy Log';


--
-- Name: COLUMN privacy_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.user_id IS 'Handled By';


--
-- Name: COLUMN privacy_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_log.anonymized_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_name IS 'Anonymized Name';


--
-- Name: COLUMN privacy_log.anonymized_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_email IS 'Anonymized Email';


--
-- Name: COLUMN privacy_log.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_log.records_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.records_description IS 'Found Records';


--
-- Name: COLUMN privacy_log.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.additional_note IS 'Additional Note';


--
-- Name: COLUMN privacy_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.date IS 'Date';


--
-- Name: COLUMN privacy_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_date IS 'Created on';


--
-- Name: COLUMN privacy_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_date IS 'Last Updated on';


--
-- Name: privacy_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_log_id_seq OWNER TO runbot;

--
-- Name: privacy_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_log_id_seq OWNED BY public.privacy_log.id;


--
-- Name: privacy_lookup_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard (
    id integer NOT NULL,
    log_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    email character varying NOT NULL,
    execution_details text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard IS 'Privacy Lookup Wizard';


--
-- Name: COLUMN privacy_lookup_wizard.log_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.log_id IS 'Log';


--
-- Name: COLUMN privacy_lookup_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.name IS 'Name';


--
-- Name: COLUMN privacy_lookup_wizard.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.email IS 'Email';


--
-- Name: COLUMN privacy_lookup_wizard.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNED BY public.privacy_lookup_wizard.id;


--
-- Name: privacy_lookup_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard_line (
    id integer NOT NULL,
    wizard_id integer,
    res_id integer NOT NULL,
    res_model_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    execution_details character varying,
    has_active boolean,
    is_active boolean,
    is_unlinked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard_line OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard_line IS 'Privacy Lookup Wizard Line';


--
-- Name: COLUMN privacy_lookup_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_id IS 'Resource ID';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_name IS 'Resource name';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model IS 'Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard_line.has_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.has_active IS 'Has Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_active IS 'Is Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_unlinked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_unlinked IS 'Is Unlinked';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNED BY public.privacy_lookup_wizard_line.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: rel_server_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_server_actions (
    server_id integer NOT NULL,
    action_id integer NOT NULL
);


ALTER TABLE public.rel_server_actions OWNER TO runbot;

--
-- Name: TABLE rel_server_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_server_actions IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    css_margins boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.css_margins; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.css_margins IS 'Use css margins';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    mobile character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea,
    alias_domain_id integer,
    alias_domain_name character varying,
    email_primary_color character varying,
    email_secondary_color character varying,
    snailmail_color boolean,
    snailmail_cover boolean,
    snailmail_duplex boolean
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.alias_domain_id IS 'Email Domain';


--
-- Name: COLUMN res_company.alias_domain_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.alias_domain_name IS 'Alias Domain Name';


--
-- Name: COLUMN res_company.email_primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_primary_color IS 'Email Header Color';


--
-- Name: COLUMN res_company.email_secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_secondary_color IS 'Email Button Color';


--
-- Name: COLUMN res_company.snailmail_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_color IS 'Snailmail Color';


--
-- Name: COLUMN res_company.snailmail_cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN res_company.snailmail_duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_duplex IS 'Both sides';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    web_app_name character varying,
    company_id integer NOT NULL,
    user_default_rights boolean,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_sms boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    module_website_cf_turnstile boolean,
    group_multi_currency boolean,
    show_effect boolean,
    module_product_images boolean,
    profiling_enabled_until timestamp without time zone,
    map_box_token character varying,
    tenor_gif_limit integer,
    twilio_account_sid character varying,
    twilio_account_token character varying,
    sfu_server_url character varying,
    sfu_server_key character varying,
    tenor_api_key character varying,
    tenor_content_filter character varying,
    google_translate_api_key character varying,
    external_email_server_default boolean,
    module_google_gmail boolean,
    module_microsoft_outlook boolean,
    restrict_template_rendering boolean,
    use_twilio_rtc_servers boolean,
    auth_signup_template_user_id integer,
    auth_signup_uninvited character varying,
    auth_signup_reset_password boolean,
    google_gmail_client_identifier character varying,
    google_gmail_client_secret character varying,
    unsplash_access_key character varying,
    unsplash_app_id character varying,
    disable_redirect_firebase_dynamic_link boolean,
    enable_ocn boolean
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.web_app_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.web_app_name IS 'Web App Name';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.user_default_rights; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.user_default_rights IS 'Default Access Rights';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'VoIP';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_sms IS 'SMS';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.module_website_cf_turnstile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_website_cf_turnstile IS 'Cloudflare Turnstile';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.module_product_images; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_product_images IS 'Get product pictures using barcode';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.map_box_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.map_box_token IS 'Token Map Box';


--
-- Name: COLUMN res_config_settings.tenor_gif_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.tenor_gif_limit IS 'Tenor Gif Limit';


--
-- Name: COLUMN res_config_settings.twilio_account_sid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_sid IS 'Twilio Account SID';


--
-- Name: COLUMN res_config_settings.twilio_account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_token IS 'Twilio Account Auth Token';


--
-- Name: COLUMN res_config_settings.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_url IS 'SFU Server URL';


--
-- Name: COLUMN res_config_settings.sfu_server_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_key IS 'SFU Server key';


--
-- Name: COLUMN res_config_settings.tenor_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.tenor_api_key IS 'Tenor API key';


--
-- Name: COLUMN res_config_settings.tenor_content_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.tenor_content_filter IS 'Tenor content filter';


--
-- Name: COLUMN res_config_settings.google_translate_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_translate_api_key IS 'Message Translation API Key';


--
-- Name: COLUMN res_config_settings.external_email_server_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.external_email_server_default IS 'Use Custom Email Servers';


--
-- Name: COLUMN res_config_settings.module_google_gmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_gmail IS 'Support Gmail Authentication';


--
-- Name: COLUMN res_config_settings.module_microsoft_outlook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_outlook IS 'Support Outlook Authentication';


--
-- Name: COLUMN res_config_settings.restrict_template_rendering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.restrict_template_rendering IS 'Restrict Template Rendering';


--
-- Name: COLUMN res_config_settings.use_twilio_rtc_servers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_twilio_rtc_servers IS 'Use Twilio ICE servers';


--
-- Name: COLUMN res_config_settings.auth_signup_template_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_template_user_id IS 'Template user for new users created through signup';


--
-- Name: COLUMN res_config_settings.auth_signup_uninvited; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_uninvited IS 'Customer Account';


--
-- Name: COLUMN res_config_settings.auth_signup_reset_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_reset_password IS 'Enable password reset from Login page';


--
-- Name: COLUMN res_config_settings.google_gmail_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_identifier IS 'Gmail Client Id';


--
-- Name: COLUMN res_config_settings.google_gmail_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_secret IS 'Gmail Client Secret';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: COLUMN res_config_settings.disable_redirect_firebase_dynamic_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.disable_redirect_firebase_dynamic_link IS 'Disable link redirection to mobile app';


--
-- Name: COLUMN res_config_settings.enable_ocn; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.enable_ocn IS 'Push Notifications';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    iso_numeric integer,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label jsonb,
    currency_subunit_label jsonb,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.iso_numeric; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.iso_numeric IS 'Currency numeric code.';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_device_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_device_log (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    session_identifier character varying NOT NULL,
    platform character varying,
    browser character varying,
    ip_address character varying,
    country character varying,
    city character varying,
    device_type character varying,
    revoked boolean,
    first_activity timestamp without time zone,
    last_activity timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_device_log OWNER TO runbot;

--
-- Name: TABLE res_device_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_device_log IS 'Device Log';


--
-- Name: COLUMN res_device_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.user_id IS 'User';


--
-- Name: COLUMN res_device_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_device_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_device_log.session_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.session_identifier IS 'Session Identifier';


--
-- Name: COLUMN res_device_log.platform; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.platform IS 'Platform';


--
-- Name: COLUMN res_device_log.browser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.browser IS 'Browser';


--
-- Name: COLUMN res_device_log.ip_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.ip_address IS 'IP Address';


--
-- Name: COLUMN res_device_log.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.country IS 'Country';


--
-- Name: COLUMN res_device_log.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.city IS 'City';


--
-- Name: COLUMN res_device_log.device_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.device_type IS 'Device Type';


--
-- Name: COLUMN res_device_log.revoked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.revoked IS 'Revoked';


--
-- Name: COLUMN res_device_log.first_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.first_activity IS 'First Activity';


--
-- Name: COLUMN res_device_log.last_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.last_activity IS 'Last Activity';


--
-- Name: COLUMN res_device_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_date IS 'Created on';


--
-- Name: COLUMN res_device_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_date IS 'Last Updated on';


--
-- Name: res_device; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.res_device AS
 SELECT id,
    user_id,
    create_uid,
    write_uid,
    session_identifier,
    platform,
    browser,
    ip_address,
    country,
    city,
    device_type,
    revoked,
    first_activity,
    last_activity,
    create_date,
    write_date
   FROM public.res_device_log d
  WHERE ((NOT (EXISTS ( SELECT 1
           FROM public.res_device_log d2
          WHERE ((d2.user_id = d.user_id) AND ((d2.session_identifier)::text = (d.session_identifier)::text) AND (NOT ((d2.platform)::text IS DISTINCT FROM (d.platform)::text)) AND (NOT ((d2.browser)::text IS DISTINCT FROM (d.browser)::text)) AND ((d2.last_activity > d.last_activity) OR ((d2.last_activity = d.last_activity) AND (d2.id > d.id))) AND (d2.revoked = false))))) AND (revoked = false));


ALTER VIEW public.res_device OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_device_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_device_log_id_seq OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_device_log_id_seq OWNED BY public.res_device_log.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    category_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    api_key_duration double precision,
    CONSTRAINT res_groups_check_api_key_duration CHECK ((api_key_duration >= (0)::double precision))
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.category_id IS 'Application';


--
-- Name: COLUMN res_groups.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.color IS 'Color Index';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_groups.api_key_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.api_key_duration IS 'API Keys maximum duration days';


--
-- Name: CONSTRAINT res_groups_check_api_key_duration ON res_groups; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_groups_check_api_key_duration ON public.res_groups IS 'CHECK(api_key_duration >= 0)';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    short_time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.short_time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.short_time_format IS 'Short Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    title integer,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    mobile character varying,
    commercial_company_name character varying,
    company_name character varying,
    barcode jsonb,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    contact_address_complete character varying,
    message_bounce integer,
    email_normalized character varying,
    signup_type character varying,
    ocn_token character varying,
    phone_sanitized character varying,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.title IS 'Title';


--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.mobile IS 'Mobile';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.barcode IS 'Barcode';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner.contact_address_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.contact_address_complete IS 'Contact Address Complete';


--
-- Name: COLUMN res_partner.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.message_bounce IS 'Bounce';


--
-- Name: COLUMN res_partner.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN res_partner.signup_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.signup_type IS 'Signup Token Type';


--
-- Name: COLUMN res_partner.ocn_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ocn_token IS 'OCN Token';


--
-- Name: COLUMN res_partner.phone_sanitized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone_sanitized IS 'Sanitized Number';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_partner_title; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_title (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    shortcut jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_title OWNER TO runbot;

--
-- Name: TABLE res_partner_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_title IS 'Partner Title';


--
-- Name: COLUMN res_partner_title.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_title.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_title.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.name IS 'Title';


--
-- Name: COLUMN res_partner_title.shortcut; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.shortcut IS 'Abbreviation';


--
-- Name: COLUMN res_partner_title.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_title.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_title.write_date IS 'Last Updated on';


--
-- Name: res_partner_title_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_title_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_title_id_seq OWNER TO runbot;

--
-- Name: res_partner_title_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_title_id_seq OWNED BY public.res_partner_title.id;


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_secret character varying,
    tour_enabled boolean,
    notification_type character varying NOT NULL,
    odoobot_state character varying,
    odoobot_failed boolean,
    saas_provider_uuid character varying,
    CONSTRAINT res_users_notification_type CHECK ((((notification_type)::text = 'email'::text) OR (NOT share)))
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.tour_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.tour_enabled IS 'Onboarding';


--
-- Name: COLUMN res_users.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.notification_type IS 'Notification';


--
-- Name: COLUMN res_users.odoobot_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_state IS 'OdooBot Status';


--
-- Name: COLUMN res_users.odoobot_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_failed IS 'Odoobot Failed';


--
-- Name: COLUMN res_users.saas_provider_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.saas_provider_uuid IS 'SaaS Provider UUID';


--
-- Name: CONSTRAINT res_users_notification_type ON res_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_notification_type ON public.res_users IS 'CHECK (notification_type = ''email'' OR NOT share)';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    duration character varying NOT NULL,
    expiration_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.duration IS 'Duration';


--
-- Name: COLUMN res_users_apikeys_description.expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.expiration_date IS 'Expiration Date';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    auth_method character varying,
    password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.auth_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.auth_method IS 'Auth Method';


--
-- Name: COLUMN res_users_identitycheck.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.password IS 'Password';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    homemenu_config jsonb,
    voice_active_duration integer,
    push_to_talk_key character varying,
    channel_notifications character varying,
    is_discuss_sidebar_category_channel_open boolean,
    is_discuss_sidebar_category_chat_open boolean,
    use_push_to_talk boolean,
    mute_until_dt timestamp without time zone
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings.homemenu_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.homemenu_config IS 'Home Menu Configuration';


--
-- Name: COLUMN res_users_settings.voice_active_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.voice_active_duration IS 'Duration of voice activity in ms';


--
-- Name: COLUMN res_users_settings.push_to_talk_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.push_to_talk_key IS 'Push-To-Talk shortcut';


--
-- Name: COLUMN res_users_settings.channel_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.channel_notifications IS 'Channel Notifications';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_channel_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_channel_open IS 'Is discuss sidebar category channel open?';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_chat_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_chat_open IS 'Is discuss sidebar category chat open?';


--
-- Name: COLUMN res_users_settings.use_push_to_talk; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.use_push_to_talk IS 'Use the push to talk feature';


--
-- Name: COLUMN res_users_settings.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.mute_until_dt IS 'Mute notifications until';


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: res_users_settings_volumes; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_volumes (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    volume double precision,
    CONSTRAINT res_users_settings_volumes_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.res_users_settings_volumes OWNER TO runbot;

--
-- Name: TABLE res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_volumes IS 'User Settings Volumes';


--
-- Name: COLUMN res_users_settings_volumes.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_volumes.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.partner_id IS 'Partner';


--
-- Name: COLUMN res_users_settings_volumes.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.guest_id IS 'Guest';


--
-- Name: COLUMN res_users_settings_volumes.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_volumes.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_volumes.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_volumes.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings_volumes.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.volume IS 'Volume';


--
-- Name: CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON public.res_users_settings_volumes IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_volumes_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNED BY public.res_users_settings_volumes.id;


--
-- Name: res_users_web_tour_tour_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_web_tour_tour_rel (
    web_tour_tour_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_web_tour_tour_rel OWNER TO runbot;

--
-- Name: TABLE res_users_web_tour_tour_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_web_tour_tour_rel IS 'RELATION BETWEEN web_tour_tour AND res_users';


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: scheduled_message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.scheduled_message_attachment_rel (
    scheduled_message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.scheduled_message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE scheduled_message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.scheduled_message_attachment_rel IS 'RELATION BETWEEN mail_scheduled_message AND ir_attachment';


--
-- Name: sms_account_code; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_code (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    verification_code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_code OWNER TO runbot;

--
-- Name: TABLE sms_account_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_code IS 'SMS Account Verification Code Wizard';


--
-- Name: COLUMN sms_account_code.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.account_id IS 'Account';


--
-- Name: COLUMN sms_account_code.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_code.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_code.verification_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.verification_code IS 'Verification Code';


--
-- Name: COLUMN sms_account_code.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_code.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_date IS 'Last Updated on';


--
-- Name: sms_account_code_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_code_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_code_id_seq OWNER TO runbot;

--
-- Name: sms_account_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_code_id_seq OWNED BY public.sms_account_code.id;


--
-- Name: sms_account_phone; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_phone (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone_number character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_phone OWNER TO runbot;

--
-- Name: TABLE sms_account_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_phone IS 'SMS Account Registration Phone Number Wizard';


--
-- Name: COLUMN sms_account_phone.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.account_id IS 'Account';


--
-- Name: COLUMN sms_account_phone.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_phone.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_phone.phone_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.phone_number IS 'Phone Number';


--
-- Name: COLUMN sms_account_phone.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_phone.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_date IS 'Last Updated on';


--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_phone_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_phone_id_seq OWNER TO runbot;

--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_phone_id_seq OWNED BY public.sms_account_phone.id;


--
-- Name: sms_account_sender; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_sender (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    sender_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_sender OWNER TO runbot;

--
-- Name: TABLE sms_account_sender; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_sender IS 'SMS Account Sender Name Wizard';


--
-- Name: COLUMN sms_account_sender.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.account_id IS 'Account';


--
-- Name: COLUMN sms_account_sender.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_sender.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_sender.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.sender_name IS 'Sender Name';


--
-- Name: COLUMN sms_account_sender.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_sender.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_date IS 'Last Updated on';


--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_sender_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_sender_id_seq OWNER TO runbot;

--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_sender_id_seq OWNED BY public.sms_account_sender.id;


--
-- Name: sms_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_composer (
    id integer NOT NULL,
    res_id integer,
    template_id integer,
    create_uid integer,
    write_uid integer,
    composition_mode character varying NOT NULL,
    res_model character varying,
    res_ids character varying,
    recipient_single_number_itf character varying,
    number_field_name character varying,
    numbers character varying,
    body text NOT NULL,
    mass_keep_log boolean,
    mass_force_send boolean,
    mass_use_blacklist boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_composer OWNER TO runbot;

--
-- Name: TABLE sms_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_composer IS 'Send SMS Wizard';


--
-- Name: COLUMN sms_composer.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_id IS 'Document ID';


--
-- Name: COLUMN sms_composer.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.template_id IS 'Use Template';


--
-- Name: COLUMN sms_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_uid IS 'Created by';


--
-- Name: COLUMN sms_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_composer.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.composition_mode IS 'Composition Mode';


--
-- Name: COLUMN sms_composer.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_model IS 'Document Model Name';


--
-- Name: COLUMN sms_composer.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_ids IS 'Document IDs';


--
-- Name: COLUMN sms_composer.recipient_single_number_itf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.recipient_single_number_itf IS 'Recipient Number';


--
-- Name: COLUMN sms_composer.number_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.number_field_name IS 'Number Field';


--
-- Name: COLUMN sms_composer.numbers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.numbers IS 'Recipients (Numbers)';


--
-- Name: COLUMN sms_composer.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.body IS 'Message';


--
-- Name: COLUMN sms_composer.mass_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_keep_log IS 'Keep a note on document';


--
-- Name: COLUMN sms_composer.mass_force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_force_send IS 'Send directly';


--
-- Name: COLUMN sms_composer.mass_use_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_use_blacklist IS 'Use blacklist';


--
-- Name: COLUMN sms_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_date IS 'Created on';


--
-- Name: COLUMN sms_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_date IS 'Last Updated on';


--
-- Name: sms_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_composer_id_seq OWNER TO runbot;

--
-- Name: sms_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_composer_id_seq OWNED BY public.sms_composer.id;


--
-- Name: sms_resend; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_resend (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_resend OWNER TO runbot;

--
-- Name: TABLE sms_resend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_resend IS 'SMS Resend';


--
-- Name: COLUMN sms_resend.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend.mail_message_id IS 'Message';


--
-- Name: COLUMN sms_resend.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend.create_uid IS 'Created by';


--
-- Name: COLUMN sms_resend.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_resend.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend.create_date IS 'Created on';


--
-- Name: COLUMN sms_resend.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend.write_date IS 'Last Updated on';


--
-- Name: sms_resend_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_resend_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_resend_id_seq OWNER TO runbot;

--
-- Name: sms_resend_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_resend_id_seq OWNED BY public.sms_resend.id;


--
-- Name: sms_resend_recipient; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_resend_recipient (
    id integer NOT NULL,
    sms_resend_id integer NOT NULL,
    notification_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    partner_name character varying,
    sms_number character varying,
    resend boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_resend_recipient OWNER TO runbot;

--
-- Name: TABLE sms_resend_recipient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_resend_recipient IS 'Resend Notification';


--
-- Name: COLUMN sms_resend_recipient.sms_resend_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend_recipient.sms_resend_id IS 'Sms Resend';


--
-- Name: COLUMN sms_resend_recipient.notification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend_recipient.notification_id IS 'Notification';


--
-- Name: COLUMN sms_resend_recipient.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend_recipient.create_uid IS 'Created by';


--
-- Name: COLUMN sms_resend_recipient.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend_recipient.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_resend_recipient.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend_recipient.partner_name IS 'Recipient Name';


--
-- Name: COLUMN sms_resend_recipient.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend_recipient.sms_number IS 'Phone Number';


--
-- Name: COLUMN sms_resend_recipient.resend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend_recipient.resend IS 'Try Again';


--
-- Name: COLUMN sms_resend_recipient.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend_recipient.create_date IS 'Created on';


--
-- Name: COLUMN sms_resend_recipient.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_resend_recipient.write_date IS 'Last Updated on';


--
-- Name: sms_resend_recipient_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_resend_recipient_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_resend_recipient_id_seq OWNER TO runbot;

--
-- Name: sms_resend_recipient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_resend_recipient_id_seq OWNED BY public.sms_resend_recipient.id;


--
-- Name: sms_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_sms (
    id integer NOT NULL,
    partner_id integer,
    mail_message_id integer,
    create_uid integer,
    write_uid integer,
    uuid character varying,
    number character varying,
    state character varying NOT NULL,
    failure_type character varying,
    body text,
    to_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_sms OWNER TO runbot;

--
-- Name: TABLE sms_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_sms IS 'Outgoing SMS';


--
-- Name: COLUMN sms_sms.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.partner_id IS 'Customer';


--
-- Name: COLUMN sms_sms.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.mail_message_id IS 'Mail Message';


--
-- Name: COLUMN sms_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_uid IS 'Created by';


--
-- Name: COLUMN sms_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_sms.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.uuid IS 'UUID';


--
-- Name: COLUMN sms_sms.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.number IS 'Number';


--
-- Name: COLUMN sms_sms.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.state IS 'SMS Status';


--
-- Name: COLUMN sms_sms.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.failure_type IS 'Failure Type';


--
-- Name: COLUMN sms_sms.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.body IS 'Body';


--
-- Name: COLUMN sms_sms.to_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.to_delete IS 'Marked for deletion';


--
-- Name: COLUMN sms_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_date IS 'Created on';


--
-- Name: COLUMN sms_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_date IS 'Last Updated on';


--
-- Name: sms_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_sms_id_seq OWNER TO runbot;

--
-- Name: sms_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_sms_id_seq OWNED BY public.sms_sms.id;


--
-- Name: sms_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template (
    id integer NOT NULL,
    model_id integer NOT NULL,
    sidebar_action_id integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    name jsonb,
    body jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template OWNER TO runbot;

--
-- Name: TABLE sms_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template IS 'SMS Templates';


--
-- Name: COLUMN sms_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model_id IS 'Applies to';


--
-- Name: COLUMN sms_template.sidebar_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.sidebar_action_id IS 'Sidebar action';


--
-- Name: COLUMN sms_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN sms_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.lang IS 'Language';


--
-- Name: COLUMN sms_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model IS 'Related Document Model';


--
-- Name: COLUMN sms_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.name IS 'Name';


--
-- Name: COLUMN sms_template.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.body IS 'Body';


--
-- Name: COLUMN sms_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_date IS 'Created on';


--
-- Name: COLUMN sms_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_date IS 'Last Updated on';


--
-- Name: sms_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_id_seq OWNER TO runbot;

--
-- Name: sms_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_id_seq OWNED BY public.sms_template.id;


--
-- Name: sms_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_preview (
    id integer NOT NULL,
    sms_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    resource_ref character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_preview OWNER TO runbot;

--
-- Name: TABLE sms_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_preview IS 'SMS Template Preview';


--
-- Name: COLUMN sms_template_preview.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN sms_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN sms_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.resource_ref IS 'Record reference';


--
-- Name: COLUMN sms_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_date IS 'Last Updated on';


--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_preview_id_seq OWNER TO runbot;

--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_preview_id_seq OWNED BY public.sms_template_preview.id;


--
-- Name: sms_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_reset OWNER TO runbot;

--
-- Name: TABLE sms_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_reset IS 'SMS Template Reset';


--
-- Name: COLUMN sms_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_date IS 'Last Updated on';


--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_reset_id_seq OWNER TO runbot;

--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_reset_id_seq OWNED BY public.sms_template_reset.id;


--
-- Name: sms_template_sms_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_sms_template_reset_rel (
    sms_template_reset_id integer NOT NULL,
    sms_template_id integer NOT NULL
);


ALTER TABLE public.sms_template_sms_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE sms_template_sms_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_sms_template_reset_rel IS 'RELATION BETWEEN sms_template_reset AND sms_template';


--
-- Name: sms_tracker; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_tracker (
    id integer NOT NULL,
    mail_notification_id integer,
    create_uid integer,
    write_uid integer,
    sms_uuid character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_tracker OWNER TO runbot;

--
-- Name: TABLE sms_tracker; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_tracker IS 'Link SMS to mailing/sms tracking models';


--
-- Name: COLUMN sms_tracker.mail_notification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.mail_notification_id IS 'Mail Notification';


--
-- Name: COLUMN sms_tracker.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_uid IS 'Created by';


--
-- Name: COLUMN sms_tracker.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_tracker.sms_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.sms_uuid IS 'SMS uuid';


--
-- Name: COLUMN sms_tracker.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_date IS 'Created on';


--
-- Name: COLUMN sms_tracker.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_date IS 'Last Updated on';


--
-- Name: sms_tracker_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_tracker_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_tracker_id_seq OWNER TO runbot;

--
-- Name: sms_tracker_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_tracker_id_seq OWNED BY public.sms_tracker.id;


--
-- Name: snailmail_letter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.snailmail_letter (
    id integer NOT NULL,
    user_id integer,
    res_id integer NOT NULL,
    partner_id integer NOT NULL,
    company_id integer NOT NULL,
    report_template integer,
    attachment_id integer,
    message_id integer,
    state_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    state character varying NOT NULL,
    error_code character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    info_msg text,
    color boolean,
    cover boolean,
    duplex boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.snailmail_letter OWNER TO runbot;

--
-- Name: TABLE snailmail_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.snailmail_letter IS 'Snailmail Letter';


--
-- Name: COLUMN snailmail_letter.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.user_id IS 'Sent by';


--
-- Name: COLUMN snailmail_letter.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.res_id IS 'Document ID';


--
-- Name: COLUMN snailmail_letter.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.partner_id IS 'Recipient';


--
-- Name: COLUMN snailmail_letter.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.company_id IS 'Company';


--
-- Name: COLUMN snailmail_letter.report_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN snailmail_letter.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.attachment_id IS 'Attachment';


--
-- Name: COLUMN snailmail_letter.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.message_id IS 'Snailmail Status Message';


--
-- Name: COLUMN snailmail_letter.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state_id IS 'State';


--
-- Name: COLUMN snailmail_letter.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.country_id IS 'Country';


--
-- Name: COLUMN snailmail_letter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.model IS 'Model';


--
-- Name: COLUMN snailmail_letter.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state IS 'Status';


--
-- Name: COLUMN snailmail_letter.error_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.error_code IS 'Error';


--
-- Name: COLUMN snailmail_letter.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street IS 'Street';


--
-- Name: COLUMN snailmail_letter.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street2 IS 'Street2';


--
-- Name: COLUMN snailmail_letter.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.zip IS 'Zip';


--
-- Name: COLUMN snailmail_letter.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.city IS 'City';


--
-- Name: COLUMN snailmail_letter.info_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.info_msg IS 'Information';


--
-- Name: COLUMN snailmail_letter.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.color IS 'Color';


--
-- Name: COLUMN snailmail_letter.cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.cover IS 'Cover Page';


--
-- Name: COLUMN snailmail_letter.duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.duplex IS 'Both side';


--
-- Name: COLUMN snailmail_letter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_format_error; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.snailmail_letter_format_error (
    id integer NOT NULL,
    message_id integer,
    create_uid integer,
    write_uid integer,
    snailmail_cover boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.snailmail_letter_format_error OWNER TO runbot;

--
-- Name: TABLE snailmail_letter_format_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.snailmail_letter_format_error IS 'Format Error Sending a Snailmail Letter';


--
-- Name: COLUMN snailmail_letter_format_error.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_format_error.message_id IS 'Message';


--
-- Name: COLUMN snailmail_letter_format_error.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_format_error.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter_format_error.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_format_error.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter_format_error.snailmail_cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_format_error.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN snailmail_letter_format_error.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_format_error.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter_format_error.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_format_error.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_format_error_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.snailmail_letter_format_error_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.snailmail_letter_format_error_id_seq OWNER TO runbot;

--
-- Name: snailmail_letter_format_error_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.snailmail_letter_format_error_id_seq OWNED BY public.snailmail_letter_format_error.id;


--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.snailmail_letter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.snailmail_letter_id_seq OWNER TO runbot;

--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.snailmail_letter_id_seq OWNED BY public.snailmail_letter.id;


--
-- Name: snailmail_letter_missing_required_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.snailmail_letter_missing_required_fields (
    id integer NOT NULL,
    partner_id integer,
    letter_id integer,
    state_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.snailmail_letter_missing_required_fields OWNER TO runbot;

--
-- Name: TABLE snailmail_letter_missing_required_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.snailmail_letter_missing_required_fields IS 'Update address of partner';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.partner_id IS 'Partner';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.letter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.letter_id IS 'Letter';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.state_id IS 'State';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.country_id IS 'Country';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.street IS 'Street';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.street2 IS 'Street2';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.zip IS 'Zip';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.city IS 'City';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter_missing_required_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter_missing_required_fields.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_missing_required_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.snailmail_letter_missing_required_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.snailmail_letter_missing_required_fields_id_seq OWNER TO runbot;

--
-- Name: snailmail_letter_missing_required_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.snailmail_letter_missing_required_fields_id_seq OWNED BY public.snailmail_letter_missing_required_fields.id;


--
-- Name: web_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.web_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test IS 'Web Editor Converter Test';


--
-- Name: COLUMN web_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN web_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN web_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN web_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN web_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN web_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN web_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN web_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN web_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN web_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN web_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN web_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test."binary" IS 'Binary';


--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_id_seq OWNED BY public.web_editor_converter_test.id;


--
-- Name: web_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE web_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_editor_converter_test_sub IS 'Web Editor Converter Subtest';


--
-- Name: COLUMN web_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN web_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN web_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN web_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: web_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_editor_converter_test_sub_id_seq OWNED BY public.web_editor_converter_test_sub.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    url character varying,
    rainbow_man_message jsonb,
    custom boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Name';


--
-- Name: COLUMN web_tour_tour.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.url IS 'Starting URL';


--
-- Name: COLUMN web_tour_tour.rainbow_man_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.rainbow_man_message IS 'Rainbow Man Message';


--
-- Name: COLUMN web_tour_tour.custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.custom IS 'Custom';


--
-- Name: COLUMN web_tour_tour.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: web_tour_tour_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour_step (
    id integer NOT NULL,
    tour_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    content character varying,
    run character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour_step OWNER TO runbot;

--
-- Name: TABLE web_tour_tour_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour_step IS 'Tour''s step';


--
-- Name: COLUMN web_tour_tour_step.tour_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tour_id IS 'Tour';


--
-- Name: COLUMN web_tour_tour_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour_step.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.trigger IS 'Trigger';


--
-- Name: COLUMN web_tour_tour_step.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.content IS 'Content';


--
-- Name: COLUMN web_tour_tour_step.run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.run IS 'Run';


--
-- Name: COLUMN web_tour_tour_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNED BY public.web_tour_tour_step.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_module ALTER COLUMN id SET DEFAULT nextval('public.base_import_module_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_install_request id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_request ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_request_id_seq'::regclass);


--
-- Name: base_module_install_review id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_review ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_review_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bg_job id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bg_job ALTER COLUMN id SET DEFAULT nextval('public.bg_job_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: bus_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_presence ALTER COLUMN id SET DEFAULT nextval('public.bus_presence_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: db_configuration id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.db_configuration ALTER COLUMN id SET DEFAULT nextval('public.db_configuration_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: discuss_channel id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_id_seq'::regclass);


--
-- Name: discuss_channel_member id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_member ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_member_id_seq'::regclass);


--
-- Name: discuss_channel_rtc_session id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_rtc_session ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_rtc_session_id_seq'::regclass);


--
-- Name: discuss_gif_favorite id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_gif_favorite ALTER COLUMN id SET DEFAULT nextval('public.discuss_gif_favorite_id_seq'::regclass);


--
-- Name: discuss_voice_metadata id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_voice_metadata ALTER COLUMN id SET DEFAULT nextval('public.discuss_voice_metadata_id_seq'::regclass);


--
-- Name: fetchmail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.fetchmail_server ALTER COLUMN id SET DEFAULT nextval('public.fetchmail_server_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: iap_service id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_service ALTER COLUMN id SET DEFAULT nextval('public.iap_service_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_progress id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_progress ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_progress_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_embedded_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_embedded_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_embedded_actions_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_inherit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_inherit ALTER COLUMN id SET DEFAULT nextval('public.ir_model_inherit_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: mail_activity id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_id_seq'::regclass);


--
-- Name: mail_activity_plan id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_id_seq'::regclass);


--
-- Name: mail_activity_plan_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan_template ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_template_id_seq'::regclass);


--
-- Name: mail_activity_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_schedule_id_seq'::regclass);


--
-- Name: mail_activity_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_type ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_type_id_seq'::regclass);


--
-- Name: mail_alias id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_id_seq'::regclass);


--
-- Name: mail_alias_domain id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias_domain ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_domain_id_seq'::regclass);


--
-- Name: mail_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_id_seq'::regclass);


--
-- Name: mail_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_remove_id_seq'::regclass);


--
-- Name: mail_canned_response id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_canned_response ALTER COLUMN id SET DEFAULT nextval('public.mail_canned_response_id_seq'::regclass);


--
-- Name: mail_compose_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_compose_message ALTER COLUMN id SET DEFAULT nextval('public.mail_compose_message_id_seq'::regclass);


--
-- Name: mail_followers id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_id_seq'::regclass);


--
-- Name: mail_gateway_allowed id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_gateway_allowed ALTER COLUMN id SET DEFAULT nextval('public.mail_gateway_allowed_id_seq'::regclass);


--
-- Name: mail_guest id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_guest ALTER COLUMN id SET DEFAULT nextval('public.mail_guest_id_seq'::regclass);


--
-- Name: mail_ice_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_ice_server ALTER COLUMN id SET DEFAULT nextval('public.mail_ice_server_id_seq'::regclass);


--
-- Name: mail_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_link_preview_id_seq'::regclass);


--
-- Name: mail_mail id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_mail ALTER COLUMN id SET DEFAULT nextval('public.mail_mail_id_seq'::regclass);


--
-- Name: mail_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message ALTER COLUMN id SET DEFAULT nextval('public.mail_message_id_seq'::regclass);


--
-- Name: mail_message_reaction id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_reaction ALTER COLUMN id SET DEFAULT nextval('public.mail_message_reaction_id_seq'::regclass);


--
-- Name: mail_message_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_message_schedule_id_seq'::regclass);


--
-- Name: mail_message_subtype id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_subtype ALTER COLUMN id SET DEFAULT nextval('public.mail_message_subtype_id_seq'::regclass);


--
-- Name: mail_message_translation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_translation ALTER COLUMN id SET DEFAULT nextval('public.mail_message_translation_id_seq'::regclass);


--
-- Name: mail_notification id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_notification ALTER COLUMN id SET DEFAULT nextval('public.mail_notification_id_seq'::regclass);


--
-- Name: mail_push id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push ALTER COLUMN id SET DEFAULT nextval('public.mail_push_id_seq'::regclass);


--
-- Name: mail_push_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push_device ALTER COLUMN id SET DEFAULT nextval('public.mail_push_device_id_seq'::regclass);


--
-- Name: mail_resend_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_resend_message ALTER COLUMN id SET DEFAULT nextval('public.mail_resend_message_id_seq'::regclass);


--
-- Name: mail_resend_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_resend_partner ALTER COLUMN id SET DEFAULT nextval('public.mail_resend_partner_id_seq'::regclass);


--
-- Name: mail_scheduled_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_scheduled_message ALTER COLUMN id SET DEFAULT nextval('public.mail_scheduled_message_id_seq'::regclass);


--
-- Name: mail_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template ALTER COLUMN id SET DEFAULT nextval('public.mail_template_id_seq'::regclass);


--
-- Name: mail_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_template_preview_id_seq'::regclass);


--
-- Name: mail_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_reset ALTER COLUMN id SET DEFAULT nextval('public.mail_template_reset_id_seq'::regclass);


--
-- Name: mail_tracking_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_tracking_value ALTER COLUMN id SET DEFAULT nextval('public.mail_tracking_value_id_seq'::regclass);


--
-- Name: mail_wizard_invite id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_wizard_invite ALTER COLUMN id SET DEFAULT nextval('public.mail_wizard_invite_id_seq'::regclass);


--
-- Name: phone_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_id_seq'::regclass);


--
-- Name: phone_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_remove_id_seq'::regclass);


--
-- Name: privacy_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_log ALTER COLUMN id SET DEFAULT nextval('public.privacy_log_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard_line ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_line_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_device_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_device_log ALTER COLUMN id SET DEFAULT nextval('public.res_device_log_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_partner_title id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_title ALTER COLUMN id SET DEFAULT nextval('public.res_partner_title_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: res_users_settings_volumes id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_volumes ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_volumes_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: sms_account_code id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_code ALTER COLUMN id SET DEFAULT nextval('public.sms_account_code_id_seq'::regclass);


--
-- Name: sms_account_phone id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_phone ALTER COLUMN id SET DEFAULT nextval('public.sms_account_phone_id_seq'::regclass);


--
-- Name: sms_account_sender id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_sender ALTER COLUMN id SET DEFAULT nextval('public.sms_account_sender_id_seq'::regclass);


--
-- Name: sms_composer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_composer ALTER COLUMN id SET DEFAULT nextval('public.sms_composer_id_seq'::regclass);


--
-- Name: sms_resend id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_resend ALTER COLUMN id SET DEFAULT nextval('public.sms_resend_id_seq'::regclass);


--
-- Name: sms_resend_recipient id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_resend_recipient ALTER COLUMN id SET DEFAULT nextval('public.sms_resend_recipient_id_seq'::regclass);


--
-- Name: sms_sms id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_sms ALTER COLUMN id SET DEFAULT nextval('public.sms_sms_id_seq'::regclass);


--
-- Name: sms_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template ALTER COLUMN id SET DEFAULT nextval('public.sms_template_id_seq'::regclass);


--
-- Name: sms_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_preview ALTER COLUMN id SET DEFAULT nextval('public.sms_template_preview_id_seq'::regclass);


--
-- Name: sms_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_reset ALTER COLUMN id SET DEFAULT nextval('public.sms_template_reset_id_seq'::regclass);


--
-- Name: sms_tracker id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_tracker ALTER COLUMN id SET DEFAULT nextval('public.sms_tracker_id_seq'::regclass);


--
-- Name: snailmail_letter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.snailmail_letter ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_id_seq'::regclass);


--
-- Name: snailmail_letter_format_error id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.snailmail_letter_format_error ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_format_error_id_seq'::regclass);


--
-- Name: snailmail_letter_missing_required_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.snailmail_letter_missing_required_fields ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_missing_required_fields_id_seq'::regclass);


--
-- Name: web_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_id_seq'::regclass);


--
-- Name: web_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.web_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: web_tour_tour_step id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour_step ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_step_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: activity_attachment_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.activity_attachment_rel (activity_id, attachment_id) FROM stdin;
\.


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, expiration_date, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, code, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_module; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_module (id, create_uid, write_uid, state, import_message, modules_dependencies, force, with_demo, create_date, write_date, module_file) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, model_id, create_uid, write_uid, name, lang, format, export_type, domain, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
1	1	1	t	2026-01-19 17:38:31.450369	2026-01-19 17:38:31.450369
2	1	1	t	2026-01-19 17:38:31.450369	2026-01-19 17:38:31.450369
\.


--
-- Data for Name: base_module_install_request; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_request (id, module_id, user_id, create_uid, write_uid, body_html, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_install_review; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_review (id, module_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, module_id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bg_job; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bg_job (id, priority, max_retries, retry_count, next_job_id, create_uid, write_uid, name, state, model, method, batch_id, args_json, kwargs_json, context_json, error_message, start_time, end_time, cancel_time, create_date, write_date, duration) FROM stdin;
1	5	3	0	\N	1	1	Single Job - Data Cleanup	done	res.partner	exists	single-batch-001	\N	{"_record_ids": [42]}	{"lang": "en_US"}	\N	2024-01-01 08:00:00	2024-01-01 08:05:00	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163	300
2	10	3	0	\N	1	1	Export Batch - Part 3/3	done	res.partner	exists	batch-completed-001	\N	{"_record_ids": [42, 43]}	{"lang": "en_US"}	\N	2024-01-02 09:20:00	2024-01-02 09:30:00	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163	600
3	10	3	0	2	1	1	Export Batch - Part 2/3	done	res.partner	exists	batch-completed-001	\N	{"_record_ids": [43]}	{"lang": "en_US"}	\N	2024-01-02 09:10:00	2024-01-02 09:20:00	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163	600
4	10	3	0	3	1	1	Export Batch - Part 1/3	done	res.partner	exists	batch-completed-001	\N	{"_record_ids": [42]}	{"lang": "en_US"}	\N	2024-01-02 09:00:00	2024-01-02 09:10:00	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163	600
5	15	3	0	\N	1	1	Validation Batch - Part 3/3	canceled	res.partner	exists	batch-failed-002	\N	{"_record_ids": [42, 43]}	{"lang": "en_US"}	Canceled due to previous job failure in batch	\N	\N	2024-01-03 14:10:00	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163	0
6	15	3	0	5	1	1	Validation Batch - Part 2/3	failed	res.partner	exists	batch-failed-002	\N	{"_record_ids": [43]}	{"lang": "en_US"}	Validation error: Invalid data format	2024-01-03 14:05:00	2024-01-03 14:10:00	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163	300
7	15	3	0	6	1	1	Validation Batch - Part 1/3	done	res.partner	exists	batch-failed-002	\N	{"_record_ids": [42]}	{"lang": "en_US"}	\N	2024-01-03 14:00:00	2024-01-03 14:05:00	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163	300
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
1	1	1	["41779-18-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"res.partner":[{"id":2}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
2	1	1	["41779-18-0-all-without-test","res.groups",4]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"allow_public_upload":false,"authorizedGroupFullName":"Administration / Settings","avatarCacheKey":"d48309362988ead225cb8578c3f35a1c423debe0ed060472a38ee387950a2e0134ae67c0ac30402b8caef63ea2a3b415942e12c7c578cb9a82ed5301c558d97d","channel_type":"channel","create_uid":1,"defaultDisplayMode":false,"description":"General channel for administrators.","group_based_subscription":true,"id":2,"is_pinned":true,"last_interest_dt":false,"memberCount":1,"name":"Administrators","uuid":"g2G6PhjMSU"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
3	1	1	["41779-18-0-all-without-test","discuss.channel",1]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"group_based_subscription":true,"id":1}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
4	1	1	["41779-18-0-all-without-test","res.groups",1]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"allow_public_upload":false,"authorizedGroupFullName":"User types / Internal User","avatarCacheKey":"d6f4521fe640f833ae701842e09a5cf1140fe67664a8a09e987d21a9ee735c61735a2e4c9f18010e7dd159c49f6fa3aae25ebc566845f51cc10e3aab08673edd","channel_type":"channel","create_uid":1,"defaultDisplayMode":false,"description":"General announcements for all employees.","group_based_subscription":true,"id":1,"is_pinned":true,"last_interest_dt":false,"memberCount":2,"name":"general","uuid":"7C2XEdY2hm"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
5	1	1	["41779-18-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"mail.canned.response":[{"id":1,"source":"hello","substitution":"Hello, how may I help you?"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
6	1	1	["41779-18-0-all-without-test","res.groups",1]	{"type":"mail.record/insert","payload":{"mail.canned.response":[{"id":1,"source":"hello","substitution":"Hello, how may I help you?"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
7	1	1	["41779-18-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"memberCount":2}],"discuss.channel.member":[{"create_date":"2026-01-19 17:38:36","fetched_message_id":1,"id":2,"last_seen_dt":false,"persona":{"id":3,"type":"partner"},"seen_message_id":1,"thread":{"id":1,"model":"discuss.channel"}}],"res.partner":[{"active":true,"avatar_128_access_token":"9c2f58afc0292fa4fb619ce5b91f7782c58a68d1a83bcac93891bb4e9a3e2e63o0x69992278","email":"admin@yourcompany.example.com","id":3,"im_status":"offline","isInternalUser":true,"is_company":false,"name":"Mitchell Admin","userId":2,"write_date":"2026-01-19 17:38:36"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
8	1	1	["41779-18-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"memberCount":2}],"discuss.channel.member":[{"create_date":"2026-01-19 17:38:36","fetched_message_id":1,"id":2,"last_seen_dt":false,"persona":{"id":3,"type":"partner"},"seen_message_id":1,"thread":{"id":1,"model":"discuss.channel"}}],"res.partner":[{"active":true,"avatar_128_access_token":"9c2f58afc0292fa4fb619ce5b91f7782c58a68d1a83bcac93891bb4e9a3e2e63o0x69992278","email":"admin@yourcompany.example.com","id":3,"im_status":"offline","isInternalUser":true,"is_company":false,"name":"Mitchell Admin","userId":2,"write_date":"2026-01-19 17:38:36"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
9	1	1	["41779-18-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"memberCount":2}],"discuss.channel.member":[{"create_date":"2026-01-19 17:38:36","fetched_message_id":false,"id":3,"last_seen_dt":false,"persona":{"id":7,"type":"partner"},"seen_message_id":false,"thread":{"id":1,"model":"discuss.channel"}}],"res.partner":[{"active":true,"avatar_128_access_token":"4595bd3e7c60342792d2c302567a6b28e0278becc4d5ed3c8ffe195639a0f137o0x69992715","email":"mark.brown23@example.com","id":7,"im_status":"offline","isInternalUser":true,"is_company":false,"name":"Marc Demo","userId":6,"write_date":"2026-01-19 17:38:36"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
10	1	1	["41779-18-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"memberCount":2}],"discuss.channel.member":[{"create_date":"2026-01-19 17:38:36","fetched_message_id":1,"id":2,"last_seen_dt":false,"persona":{"id":3,"type":"partner"},"seen_message_id":1,"thread":{"id":1,"model":"discuss.channel"}}],"res.partner":[{"active":true,"avatar_128_access_token":"9c2f58afc0292fa4fb619ce5b91f7782c58a68d1a83bcac93891bb4e9a3e2e63o0x69992278","email":"admin@yourcompany.example.com","id":3,"im_status":"offline","isInternalUser":true,"is_company":false,"name":"Mitchell Admin","userId":2,"write_date":"2026-01-19 17:38:36"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
11	1	1	["41779-18-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"memberCount":2}],"discuss.channel.member":[{"create_date":"2026-01-19 17:38:36","fetched_message_id":false,"id":3,"last_seen_dt":false,"persona":{"id":7,"type":"partner"},"seen_message_id":false,"thread":{"id":1,"model":"discuss.channel"}}],"res.partner":[{"active":true,"avatar_128_access_token":"4595bd3e7c60342792d2c302567a6b28e0278becc4d5ed3c8ffe195639a0f137o0x69992715","email":"mark.brown23@example.com","id":7,"im_status":"offline","isInternalUser":true,"is_company":false,"name":"Marc Demo","userId":6,"write_date":"2026-01-19 17:38:36"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
12	1	1	["41779-18-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"mail.canned.response":[{"id":2,"source":"bye","substitution":"Thanks for your feedback. Goodbye!"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
13	1	1	["41779-18-0-all-without-test","res.groups",1]	{"type":"mail.record/insert","payload":{"mail.canned.response":[{"id":2,"source":"bye","substitution":"Thanks for your feedback. Goodbye!"}]}}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
14	1	1	["41779-18-0-all-without-test","discuss.channel",6]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":6,"last_interest_dt":"2026-01-19 17:38:41"}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
15	1	1	["41779-18-0-all-without-test","discuss.channel",6,"members"]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":6,"is_pinned":true}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
16	1	1	["41779-18-0-all-without-test","discuss.channel",6]	{"type":"discuss.channel/new_message","payload":{"data":{"mail.message":[{"attachment_ids":[],"author":{"id":3,"type":"partner"},"body":"<div class=\\"o_mail_notification\\">left the channel</div>","create_date":"2026-01-19 17:38:41","date":"2026-01-19 17:38:41","default_subject":"Welcome to the #general channel","email_from":"\\"Database Support\\" <admin@yourcompany.example.com>","id":32,"is_discussion":true,"is_note":false,"linkPreviews":[],"message_type":"notification","model":"discuss.channel","notifications":[],"parentMessage":false,"pinned_at":false,"reactions":[],"recipients":[],"record_name":"Welcome to the #general channel","res_id":6,"scheduledDatetime":false,"subject":false,"subtype_description":false,"thread":{"id":6,"model":"discuss.channel"},"write_date":"2026-01-19 17:38:41"}],"mail.thread":[{"id":6,"model":"discuss.channel","module_icon":"/mail/static/description/icon.png"}],"res.partner":[{"avatar_128_access_token":"9c2f58afc0292fa4fb619ce5b91f7782c58a68d1a83bcac93891bb4e9a3e2e63o0x69992278","id":3,"isInternalUser":true,"is_company":false,"name":"Database Support","userId":2,"write_date":"2026-01-19 17:38:41"}]},"id":6}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
17	1	1	["41779-18-0-all-without-test","res.partner",3]	{"type":"discuss.channel/leave","payload":{"discuss.channel":[{"id":6,"isLocallyPinned":false,"is_pinned":false}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
18	1	1	["41779-18-0-all-without-test","discuss.channel",6]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"channelMembers":[["DELETE",[4]]],"id":6,"memberCount":0}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
19	1	1	["41779-18-0-all-without-test","discuss.channel",7]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":7,"last_interest_dt":"2026-01-19 17:38:41"}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
20	1	1	["41779-18-0-all-without-test","discuss.channel",7,"members"]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":7,"is_pinned":true}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
21	1	1	["41779-18-0-all-without-test","discuss.channel",7]	{"type":"discuss.channel/new_message","payload":{"data":{"mail.message":[{"attachment_ids":[],"author":{"id":3,"type":"partner"},"body":"<div class=\\"o_mail_notification\\">left the channel</div>","create_date":"2026-01-19 17:38:41","date":"2026-01-19 17:38:41","default_subject":"Ideas & Suggestions","email_from":"\\"Database Support\\" <admin@yourcompany.example.com>","id":33,"is_discussion":true,"is_note":false,"linkPreviews":[],"message_type":"notification","model":"discuss.channel","notifications":[],"parentMessage":false,"pinned_at":false,"reactions":[],"recipients":[],"record_name":"Ideas & Suggestions","res_id":7,"scheduledDatetime":false,"subject":false,"subtype_description":false,"thread":{"id":7,"model":"discuss.channel"},"write_date":"2026-01-19 17:38:41"}],"mail.thread":[{"id":7,"model":"discuss.channel","module_icon":"/mail/static/description/icon.png"}],"res.partner":[{"avatar_128_access_token":"9c2f58afc0292fa4fb619ce5b91f7782c58a68d1a83bcac93891bb4e9a3e2e63o0x69992278","id":3,"isInternalUser":true,"is_company":false,"name":"Database Support","userId":2,"write_date":"2026-01-19 17:38:41"}]},"id":7}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
22	1	1	["41779-18-0-all-without-test","res.partner",3]	{"type":"discuss.channel/leave","payload":{"discuss.channel":[{"id":7,"isLocallyPinned":false,"is_pinned":false}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
23	1	1	["41779-18-0-all-without-test","discuss.channel",7]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"channelMembers":[["DELETE",[5]]],"id":7,"memberCount":1}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
24	1	1	["41779-18-0-all-without-test","discuss.channel",8]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":8,"last_interest_dt":"2026-01-19 17:38:41"}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
25	1	1	["41779-18-0-all-without-test","discuss.channel",8,"members"]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":8,"is_pinned":true}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
26	1	1	["41779-18-0-all-without-test","discuss.channel",8]	{"type":"discuss.channel/new_message","payload":{"data":{"mail.message":[{"attachment_ids":[],"author":{"id":3,"type":"partner"},"body":"<div class=\\"o_mail_notification\\">left the channel</div>","create_date":"2026-01-19 17:38:41","date":"2026-01-19 17:38:41","default_subject":"Troubleshooting","email_from":"\\"Database Support\\" <admin@yourcompany.example.com>","id":34,"is_discussion":true,"is_note":false,"linkPreviews":[],"message_type":"notification","model":"discuss.channel","notifications":[],"parentMessage":false,"pinned_at":false,"reactions":[],"recipients":[],"record_name":"Troubleshooting","res_id":8,"scheduledDatetime":false,"subject":false,"subtype_description":false,"thread":{"id":8,"model":"discuss.channel"},"write_date":"2026-01-19 17:38:41"}],"mail.thread":[{"id":8,"model":"discuss.channel","module_icon":"/mail/static/description/icon.png"}],"res.partner":[{"avatar_128_access_token":"9c2f58afc0292fa4fb619ce5b91f7782c58a68d1a83bcac93891bb4e9a3e2e63o0x69992278","id":3,"isInternalUser":true,"is_company":false,"name":"Database Support","userId":2,"write_date":"2026-01-19 17:38:41"}]},"id":8}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
27	1	1	["41779-18-0-all-without-test","res.partner",3]	{"type":"discuss.channel/leave","payload":{"discuss.channel":[{"id":8,"isLocallyPinned":false,"is_pinned":false}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
28	1	1	["41779-18-0-all-without-test","discuss.channel",8]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"channelMembers":[["DELETE",[7]]],"id":8,"memberCount":1}]}}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
\.


--
-- Data for Name: bus_presence; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_presence (id, user_id, status, last_poll, last_presence, guest_id) FROM stdin;
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: db_configuration; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.db_configuration (id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: discuss_channel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel (id, parent_channel_id, from_message_id, group_public_id, create_uid, write_uid, name, channel_type, default_display_mode, sfu_channel_uuid, sfu_server_url, uuid, description, active, allow_public_upload, last_interest_dt, create_date, write_date) FROM stdin;
2	\N	\N	4	1	1	Administrators	channel	\N	\N	\N	g2G6PhjMSU	General channel for administrators.	t	f	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
1	\N	\N	1	1	1	general	channel	\N	\N	\N	7C2XEdY2hm	General announcements for all employees.	t	f	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
3	\N	\N	1	1	1	sales	channel	\N	\N	\N	BMXWcBVWns	Discussion about best sales practices and deals.	t	f	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
4	\N	\N	1	1	1	board-meetings	channel	\N	\N	\N	VZj8v5ypAW	Board meetings, budgets, strategic plans	t	f	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
5	\N	\N	1	1	1	rd	channel	\N	\N	\N	4giFuyVKLs	Research and development discussion group	t	f	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
6	1	1	\N	1	1	Welcome to the #general channel	channel	\N	\N	\N	IeHPhKhEnY	\N	t	f	2026-01-19 17:38:41	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.58672
7	1	\N	\N	1	1	Ideas & Suggestions	channel	\N	\N	\N	GcYA3wrCXQ	\N	t	f	2026-01-19 17:38:41	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.58672
8	1	\N	\N	1	1	Troubleshooting	channel	\N	\N	\N	RzXPt2IM2N	\N	t	f	2026-01-19 17:38:41	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.58672
\.


--
-- Data for Name: discuss_channel_member; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_member (id, partner_id, guest_id, channel_id, fetched_message_id, seen_message_id, new_message_separator, rtc_inviting_session_id, create_uid, write_uid, custom_channel_name, fold_state, custom_notifications, mute_until_dt, unpin_dt, last_interest_dt, last_seen_dt, create_date, write_date) FROM stdin;
3	7	\N	1	\N	\N	0	\N	1	1	\N	closed	\N	\N	\N	2026-01-19 17:38:38	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
6	7	\N	7	\N	\N	0	\N	1	1	\N	closed	\N	\N	\N	2026-01-19 17:38:38	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
8	7	\N	8	14	14	15	\N	1	1	\N	closed	\N	\N	\N	2026-01-19 17:38:38	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
\.


--
-- Data for Name: discuss_channel_res_groups_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_res_groups_rel (discuss_channel_id, res_groups_id) FROM stdin;
2	4
1	1
\.


--
-- Data for Name: discuss_channel_rtc_session; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_rtc_session (id, channel_member_id, channel_id, create_uid, write_uid, is_screen_sharing_on, is_camera_on, is_muted, is_deaf, write_date, create_date) FROM stdin;
\.


--
-- Data for Name: discuss_gif_favorite; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_gif_favorite (id, create_uid, write_uid, tenor_gif_id, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: discuss_voice_metadata; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_voice_metadata (id, attachment_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: email_template_attachment_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.email_template_attachment_rel (email_template_id, attachment_id) FROM stdin;
\.


--
-- Data for Name: fetchmail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.fetchmail_server (id, port, object_id, priority, create_uid, write_uid, name, state, server, server_type, "user", password, script, configuration, active, is_ssl, attach, original, date, create_date, write_date, google_gmail_access_token_expiration, google_gmail_authorization_code, google_gmail_refresh_token, google_gmail_access_token) FROM stdin;
\.


--
-- Data for Name: iap_account; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account (id, service_id, create_uid, write_uid, name, account_token, balance, state, service_locked, create_date, write_date, warning_threshold, sender_name) FROM stdin;
\.


--
-- Data for Name: iap_account_res_company_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_company_rel (iap_account_id, res_company_id) FROM stdin;
\.


--
-- Data for Name: iap_account_res_users_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_users_rel (iap_account_id, res_users_id) FROM stdin;
\.


--
-- Data for Name: iap_service; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_service (id, create_uid, write_uid, name, technical_name, description, unit_name, integer_balance, create_date, write_date) FROM stdin;
1	1	1	Lead Generation	reveal	{"en_US": "Get quality leads and opportunities: convert your website visitors into leads, generate leads based on a set of criteria and enrich the company data of your opportunities.", "es_419": "Obtenga leads y oportunidades de calidad: convierta a los visitantes de su sitio web en leads, genere leads basándose en un conjunto de criterios y enriquezca los datos de la empresa de sus oportunidades."}	{"en_US": "Credits", "es_419": "Créditos"}	t	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
2	1	1	Document Digitization	invoice_ocr	{"en_US": "Digitize your scanned or PDF vendor bills, expenses and resumes with OCR and Artificial Intelligence.", "es_419": "Digitalice sus facturas de proveedores, gastos y CV escaneados o en PDF con OCR e Inteligencia Artificial"}	{"en_US": "Documents", "es_419": "Documentos"}	t	2026-01-19 17:38:41.418689	2026-01-19 17:38:41.418689
3	1	1	SMS	sms	{"en_US": "Send SMS to your contacts directly from your database.", "es_419": "Envíe mensajes SMS a sus contactos directo desde su base de datos."}	{"en_US": "Credits", "es_419": "Créditos"}	f	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
4	1	1	Snail Mail	snailmail	{"en_US": "Send your customer invoices and follow-up reports by post, worldwide.", "es_419": "Envíe sus facturas y reportes de seguimiento por correo postal a todo el mundo."}	{"en_US": "Stamps", "es_419": "Sellos"}	t	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_client (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, tag, target, res_model, context, params_store) FROM stdin;
2	\N	1	1	ir.actions.client	\N	action	list,form	{"en_US": "Open Settings Menu", "es_419": "Abrir el menú de ajustes"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	reload	current	\N	{}	\\x7b276d656e755f6964273a20317d
109	\N	1	1	ir.actions.client	discuss	action	list,form	{"en_US": "Discuss", "es_419": "Conversaciones"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	mail.action_discuss	current	\N	{}	\\x7b202764656661756c745f6163746976655f6964273a20276d61696c2e626f785f696e626f7827207d
125	\N	1	1	ir.actions.client	\N	action	list,form	{"en_US": "Notifications", "es_419": "Notificaciones"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	mail.discuss_notification_settings_action	new	\N	{"dialog_size": "medium", "footer": false}	\N
126	\N	1	1	ir.actions.client	\N	action	list,form	{"en_US": "Voice & Video Settings", "es_419": "Ajustes de voz y video"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	mail.discuss_call_settings_action	new	\N	{'dialog_size': 'medium', 'footer': false}	\N
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_report_xml (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, paperformat_id, model, report_type, report_name, report_file, attachment, domain, print_report_name, multi, attachment_use) FROM stdin;
37	3	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Model Overview", "es_419": "Resumen del modelo"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N	\N
42	68	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Technical guide", "es_419": "Guía técnica"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N	\N
79	96	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Preview External Report", "es_419": "Vista previa del reporte externo"}	\N	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188	\N	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N	\N
78	96	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Preview Internal Report", "es_419": "Vista previa del reporte interno"}	\N	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188	\N	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N	\N
80	96	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Report Layout Preview", "es_419": "Vista previa del diseño del reporte"}	\N	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188	\N	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, sequence, model_id, crud_model_id, link_field_id, update_field_id, update_related_model_id, selection_value, usage, state, model_name, update_path, update_m2m_operation, update_boolean_value, evaluation_type, resource_ref, webhook_url, code, value, template_id, activity_type_id, activity_date_deadline_range, activity_user_id, mail_post_method, activity_summary, activity_date_deadline_range_type, activity_user_type, activity_user_field_name, activity_note, mail_post_autofollow, sms_template_id, sms_method) FROM stdin;
35	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Base: Auto-vacuum internal data", "es_419": "Base: limpieza automática de datos internos"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:41.858933	5	40	\N	\N	\N	\N	\N	ir_cron	code	ir.autovacuum	\N	add	true	value	\N	\N	model._run_vacuum_cleaner()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
36	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Base: Portal Users Deletion", "es_419": "Base: eliminación de usuarios del portal"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:41.858933	5	108	\N	\N	\N	\N	\N	ir_cron	code	res.users.deletion	\N	add	true	value	\N	\N	model._gc_portal_users(batch_size=50)	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
12	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Config: Run Remaining Action Todo", "es_419": "Configuración: ejecutar las acciones pendientes"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:41.858933	5	92	\N	\N	\N	\N	\N	ir_actions_server	code	res.config	\N	add	true	value	\N	\N	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
51	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Failed to install demo data for some modules, demo disabled", "es_419": "Error al instalar datos de demostración para algunos módulos, la demostración está deshabilitada"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:41.858933	5	73	\N	\N	\N	\N	\N	ir_actions_server	code	ir.demo_failure.wizard	\N	add	true	value	\N	\N	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
82	88	1	1	ir.actions.server	\N	action	form,list	{"en_US": "Download (vCard)", "es_419": "Descargar (vCard)"}	\N	2026-01-19 17:38:33.693188	2026-01-19 17:38:41.858933	5	88	\N	\N	\N	\N	\N	ir_actions_server	code	res.partner	\N	add	true	value	\N	\N	\n            action = {\n                'type': 'ir.actions.act_url',\n                'url': '/web/partner/vcard?partner_ids=' + ','.join(map(str, records.ids)),\n                'target': 'download',\n            }\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
83	99	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Disable two-factor authentication", "es_419": "Deshabilitar la autenticación de dos factores"}	\N	2026-01-19 17:38:34.241839	2026-01-19 17:38:41.858933	5	99	\N	\N	\N	\N	\N	ir_actions_server	code	res.users	\N	add	true	value	\N	\N	\n            action = records.action_totp_disable()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
87	134	1	1	ir.actions.server	\N	action	form	{"en_US": "Export JS", "es_419": "Exportar JS"}	\N	2026-01-19 17:38:36.21336	2026-01-19 17:38:41.858933	5	134	\N	\N	\N	\N	\N	ir_actions_server	code	web_tour.tour	\N	add	true	value	\N	\N	\nif records:\n    action = records.export_js_file()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
123	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Discuss: channel member unmute", "es_419": "Conversaciones: activar el sonido de un miembro del canal"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.858933	5	196	\N	\N	\N	\N	\N	ir_cron	code	discuss.channel.member	\N	add	true	value	\N	\N	model._cleanup_expired_mutes()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
124	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Discuss: users settings unmute", "es_419": "Conversaciones: ajuste para activar usuarios"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.858933	5	107	\N	\N	\N	\N	\N	ir_cron	code	res.users.settings	\N	add	true	value	\N	\N	model._cleanup_expired_mutes()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
116	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Mail: Email Queue Manager", "es_419": "Correo: Administrador de tareas del correo electrónico"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.858933	5	169	\N	\N	\N	\N	\N	ir_cron	code	mail.mail	\N	add	true	value	\N	\N	model.process_email_queue(batch_size=1000)	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
119	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Mail: Fetchmail Service", "es_419": "Correo: servicio de Fetchmail"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.858933	5	154	\N	\N	\N	\N	\N	ir_cron	code	fetchmail.server	\N	add	true	value	\N	\N	model._fetch_mails()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
120	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Mail: Post scheduled messages", "es_419": "Correo: Publicar los mensajes programados"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.858933	5	172	\N	\N	\N	\N	\N	ir_cron	code	mail.scheduled.message	\N	add	true	value	\N	\N	model._post_messages_cron()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
122	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Mail: send web push notification", "es_419": "Correo: enviar notificaciones push en web"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.858933	5	170	\N	\N	\N	\N	\N	ir_cron	code	mail.push	\N	add	true	value	\N	\N	model._push_notification_to_endpoint()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
118	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Notification: Delete Notifications older than 6 Month", "es_419": "Notificación: eliminar notificaciones con más de 6 meses de antigüedad"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.858933	5	155	\N	\N	\N	\N	\N	ir_cron	code	mail.notification	\N	add	true	value	\N	\N	model._gc_notifications(max_age_days=180)	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
121	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Notification: Notify scheduled messages", "es_419": "Notificación: notificar acerca de los mensajes programados"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.858933	5	165	\N	\N	\N	\N	\N	ir_cron	code	mail.message.schedule	\N	add	true	value	\N	\N	model._send_notifications_cron()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
117	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Publisher: Update Notification", "es_419": "Editor: notificación de actualización"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:41.858933	5	195	\N	\N	\N	\N	\N	ir_cron	code	publisher_warranty.contract	\N	add	true	value	\N	\N	model.update_notification(None)	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
138	99	1	1	ir.actions.server	\N	action	list	{"en_US": "Invite to use two-factor authentication", "es_419": "Invitar a usar la autenticación de dos factores"}	\N	2026-01-19 17:38:39.683311	2026-01-19 17:38:41.858933	5	99	\N	\N	\N	\N	\N	ir_actions_server	code	res.users	\N	add	true	value	\N	\N	\n            action = records.action_totp_invite()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
139	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Open two-factor authentication configuration", "es_419": "Abrir la configuración de la autenticación de dos factores"}	\N	2026-01-19 17:38:39.683311	2026-01-19 17:38:41.858933	5	99	\N	\N	\N	\N	\N	ir_actions_server	code	res.users	\N	add	true	value	\N	\N	\nuser = env.user\naction = user.action_open_my_account_settings()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
137	99	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Send Password Reset Instructions", "es_419": "Enviar instrucciones para restablecer la contraseña"}	\N	2026-01-19 17:38:39.554159	2026-01-19 17:38:41.858933	5	99	\N	\N	\N	\N	\N	ir_actions_server	code	res.users	\N	add	true	value	\N	\N	records.action_reset_password()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
136	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Users: Notify About Unregistered Users", "es_419": "Usuarios: notificar sobre usuarios no registrados"}	\N	2026-01-19 17:38:39.554159	2026-01-19 17:38:41.858933	5	99	\N	\N	\N	\N	\N	ir_cron	code	res.users	\N	add	true	value	\N	\N	model.send_unregistered_user_reminder(batch_size=100)	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
141	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Background Job Runner"}	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:41.858933	5	333	\N	\N	\N	\N	\N	ir_cron	code	bg.job	\N	add	true	value	\N	\N	model._cron_run_enqueued_jobs()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
142	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Background Job Monitor"}	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:41.858933	5	333	\N	\N	\N	\N	\N	ir_cron	code	bg.job	\N	add	true	value	\N	\N	model._cron_check_running_jobs()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
151	345	1	1	ir.actions.server	\N	action	list	{"en_US": "Archive Selection", "es_419": "Selección de archivo"}	\N	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.858933	5	345	\N	\N	\N	\N	\N	ir_actions_server	code	privacy.lookup.wizard.line	\N	add	true	value	\N	\N	\nrecords.action_archive_all()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
152	345	1	1	ir.actions.server	\N	action	list	{"en_US": "Delete Selection", "es_419": "Eliminar selección"}	\N	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.858933	5	345	\N	\N	\N	\N	\N	ir_actions_server	code	privacy.lookup.wizard.line	\N	add	true	value	\N	\N	\nrecords.action_unlink_all()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
147	88	1	1	ir.actions.server	\N	action	form	{"en_US": "Privacy Lookup", "es_419": "Búsqueda de privacidad"}	\N	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.858933	5	88	\N	\N	\N	\N	\N	ir_actions_server	code	res.partner	\N	add	true	value	\N	\N	\naction = record.action_privacy_lookup()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
148	99	1	1	ir.actions.server	\N	action	form	{"en_US": "Privacy Lookup", "es_419": "Búsqueda de privacidad"}	\N	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.858933	5	99	\N	\N	\N	\N	\N	ir_actions_server	code	res.users	\N	add	true	value	\N	\N	\naction = record.partner_id.action_privacy_lookup()\n        	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
162	351	1	1	ir.actions.server	\N	action	list	{"en_US": "Resend", "es_419": "Reenviar"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	5	351	\N	\N	\N	\N	\N	ir_actions_server	code	sms.sms	\N	add	true	value	\N	\N	action = records.resend_failed()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
154	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "SMS: SMS Queue Manager", "es_419": "SMS: administrador de la cola de SMS"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	5	351	\N	\N	\N	\N	\N	ir_cron	code	sms.sms	\N	add	true	value	\N	\N	model._process_queue()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
164	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Snailmail: process letters queue", "es_419": "Correo postal: procesar cartas en la cola"}	\N	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327	5	362	\N	\N	\N	\N	\N	ir_cron	code	snailmail.letter	\N	add	true	value	\N	\N	model._snailmail_cron()	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	f	\N	\N
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
83	2
137	2
138	2
139	1
147	4
148	4
\.


--
-- Data for Name: ir_act_server_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_res_partner_rel (ir_act_server_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: ir_act_server_webhook_field_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_webhook_field_rel (server_id, field_id) FROM stdin;
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_url (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, target, url) FROM stdin;
3	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Home Menu", "es_419": "Menú de inicio"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	self	/web
41	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Theme Store", "es_419": "Tienda de temas"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	new	https://apps.odoo.com/apps/themes
40	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Third-Party Apps", "es_419": "Aplicaciones externas"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	new	https://apps.odoo.com/apps/modules
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, view_id, res_id, "limit", search_view_id, domain, context, res_model, target, view_mode, mobile_view_mode, usage, filter) FROM stdin;
68	99	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Change Password", "es_419": "Cambiar la contraseña"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	change.password.wizard	new	form	kanban	\N	\N
27	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Attachments", "es_419": "Archivos adjuntos"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Attach a new document\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Attach a new document\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:36.870217	\N	\N	80	67	\N	{}	ir.attachment	current	kanban,list,form	kanban	\N	\N
94	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Incoming Mail Servers", "es_419": "Servidores de correo entrante"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	251	\N	80	253	\N	{}	fetchmail.server	current	list,form	kanban	\N	\N
1	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Load demo data", "es_419": "Cargar datos de prueba"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	ir.demo	new	form	kanban	\N	\N
4	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Decimal Accuracy", "es_419": "Precisión decimal"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	decimal.precision	current	list,form	kanban	\N	\N
5	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Actions", "es_419": "Acciones"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	6	\N	80	7	\N	{}	ir.actions.actions	current	list,form	kanban	\N	\N
6	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Reports", "es_419": "Reportes"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	9	\N	80	10	\N	{}	ir.actions.report	current	list,form	kanban	\N	\N
7	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Window Actions", "es_419": "Acciones de ventana"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	14	\N	{}	ir.actions.act_window	current	list,form	kanban	\N	\N
8	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Client Actions", "es_419": "Acciones del cliente"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	15	\N	80	\N	\N	{}	ir.actions.client	current	list,form	kanban	\N	\N
9	\N	1	1	ir.actions.act_window	server-actions	action	list,form	{"en_US": "Server Actions", "es_419": "Acciones del servidor"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	17	\N	80	18	\N	{'key':'server_action'}	ir.actions.server	current	list,form	kanban	\N	\N
10	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Embedded Actions", "es_419": "Acciones incrustadas"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	20	\N	80	\N	\N	{}	ir.embedded.actions	current	list,form	kanban	\N	\N
11	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Configuration Wizards", "es_419": "Asistentes de configuración"}	{"en_US": "<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>", "es_419": "<p>Los asistentes de configuración se usan para ayudarle a configurar una nueva instancia de Odoo. Estos se inician durante la instalación de nuevos módulos, pero puede reiniciarlos de forma manual desde este menú.</p>"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	21	\N	80	\N	\N	{}	ir.actions.todo	current	list,form	kanban	\N	\N
13	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Assets", "es_419": "Activos"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	25	\N	80	\N	\N	{'search_default_active': 1}	ir.asset	current	list,form	kanban	\N	\N
14	\N	1	1	ir.actions.act_window	system-parameters	action	list,form	{"en_US": "System Parameters", "es_419": "Parámetros del sistema"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	ir.config_parameter	current	list,form	kanban	\N	\N
16	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Scheduled Actions Triggers", "es_419": "Activación de acciones planificadas "}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	ir.cron.trigger	current	list,form	kanban	\N	\N
17	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User-defined Filters", "es_419": "Filtros de usuario"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	ir.filters	current	list,form	kanban	\N	\N
18	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Outgoing Mail Servers", "es_419": "Servidores de correo saliente"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	41	\N	80	42	\N	{}	ir.mail_server	current	list,form	kanban	\N	\N
19	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Create Menu", "es_419": "Crear menú"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{'model_id': active_id}	wizard.ir.model.menu.create	new	form	kanban	\N	\N
20	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Models", "es_419": "Modelos"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	45	\N	80	\N	\N	{}	ir.model	current	list,form	kanban	\N	\N
21	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fields", "es_419": "Campos"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	48	\N	80	\N	\N	{}	ir.model.fields	current	list,form	kanban	\N	\N
22	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fields Selection", "es_419": "Selección de campos"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	51	\N	80	\N	\N	{}	ir.model.fields.selection	current	list,form	kanban	\N	\N
23	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "External Identifiers", "es_419": "Identificadores externos"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	54	\N	80	\N	\N	{}	ir.model.data	current	list,form	kanban	\N	\N
24	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Model Constraints", "es_419": "Restricciones del modelo"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	57	\N	80	58	\N	{}	ir.model.constraint	current	list,form	kanban	\N	\N
25	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "ManyToMany Relations", "es_419": "Relaciones many2many"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	60	\N	80	\N	\N	{}	ir.model.relation	current	list,form	kanban	\N	\N
26	\N	1	1	ir.actions.act_window	access-rights	action	list,form	{"en_US": "Access Rights", "es_419": "Permisos de acceso"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	62	\N	80	64	\N	{}	ir.model.access	current	list,form	kanban	\N	\N
15	\N	1	1	ir.actions.act_window	crons	action	list,form	{"en_US": "Scheduled Actions", "es_419": "Acciones planificadas"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:36.870217	31	\N	80	\N	[('id', '!=', 4)]	{'search_default_all': 1}	ir.cron	current	list,form,calendar	kanban	\N	\N
101	154	1	1	ir.actions.act_window	\N	action	form	{"en_US": "Messages", "es_419": "Mensajes"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	[('email_from', '!=', False), ('fetchmail_server_id', '=', active_id)]	{'search_default_server_id': active_id, 'default_fetchmail_server_id': active_id}	mail.mail	current	list,form	kanban	\N	\N
102	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Followers", "es_419": "Seguidores"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.followers	current	list,form	kanban	\N	\N
103	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "ICE servers", "es_419": "Servidores ICE"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.ice.server	current	list,form	kanban	\N	\N
104	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Channels/Members", "es_419": "Canales/Miembros"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	discuss.channel.member	current	list,form	kanban	\N	\N
105	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "RTC sessions", "es_419": "Sesiones de comunicación en tiempo real"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{'search_default_group_by_channel': True}	discuss.channel.rtc.session	current	list,form	kanban	\N	\N
106	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Link Previews", "es_419": "Vista previa del enlace"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.link.preview	current	list,form	kanban	\N	\N
107	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "GIF favorite", "es_419": "GIF favorito "}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	discuss.gif.favorite	current	list,form	kanban	\N	\N
108	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Join a group", "es_419": "Unirse a un grupo"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	287	\N	{}	discuss.channel	current	kanban,list,form	kanban	\N	\N
28	\N	1	1	ir.actions.act_window	record-rules	action	list,form	{"en_US": "Record Rules", "es_419": "Reglas de registro"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	69	\N	80	70	\N	{}	ir.rule	current	list,form	kanban	\N	\N
29	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Sequences", "es_419": "Secuencias"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	72	\N	80	\N	\N	{'active_test': False}	ir.sequence	current	list,form	kanban	\N	\N
30	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Menu Items", "es_419": "Elementos de menú"}	{"en_US": "<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>", "es_419": "<p>Gestione y personalice los elementos disponibles que aparecen en su menú de Odoo. Para eliminar un elemento, haga clic en la caja que se encuentra al inicio de cada línea y haga clic en el botón de eliminar. Los elementos se pueden asignar a grupos específicos para que solo algunos usuarios del sistema puedan acceder a ellos.</p>"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	75	\N	80	76	\N	{'ir.ui.menu.full_list':True}	ir.ui.menu	current	list,form	kanban	\N	\N
31	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Views", "es_419": "Vistas"}	{"en_US": "<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>", "es_419": "<p>Las vistas le permiten personalizar cada vista de Odoo. Puede agregar nuevos campos, moverlos, renombrarlos o eliminarlos si es necesario.</p>"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	78	\N	80	\N	\N	{'search_default_active': 1}	ir.ui.view	current	list,form	kanban	\N	\N
32	16	1	1	ir.actions.act_window	\N	action	form,list	{"en_US": "Compare/Reset", "es_419": "Comparar/Restablecer"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	reset.view.arch.wizard	new	form	kanban	\N	\N
33	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customized Views", "es_419": "Vistas personalizadas"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">Crear una vista personalizada</p><p>Las vistas personalizadas se utilizan cuando los usuarios reorganizan el contenido de sus vistas de tablero (mediante el cliente web)</p>"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	ir.ui.view.custom	current	list,form	kanban	\N	\N
34	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User-defined Defaults", "es_419": "Predeterminados por el usuario"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	86	\N	{}	ir.default	current	list,form	kanban	\N	\N
38	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Logging", "es_419": "Registros"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	90	\N	{}	ir.logging	current	list,form	kanban	\N	\N
39	\N	1	1	ir.actions.act_window	apps	action	list,form	{"en_US": "Apps", "es_419": "Aplicaciones"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No module found!\\n              </p><p>\\n                You should try other search criteria.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No se encontró ningún módulo\\n              </p><p>\\n                Intente usar otro criterio de búsqueda.\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	95	\N	{'search_default_app':1}	ir.module.module	current	kanban,list,form	kanban	\N	\N
43	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Module Update", "es_419": "Actualización de módulo"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	base.module.update	new	form	kanban	\N	\N
44	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Add Languages", "es_419": "Agregar idiomas"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	base.language.install	new	form	kanban	\N	\N
45	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Import Translation", "es_419": "Importar traducción"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	base.language.import	new	form	kanban	\N	\N
46	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Apply Schedule Upgrade", "es_419": "Aplicar actualización programada"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
47	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Module Upgrade Install", "es_419": "Instalar actualización del módulo"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	105	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N
48	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Export Translation", "es_419": "Exportar traducción"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	base.language.export	new	form	kanban	\N	\N
49	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Deduplicate Contacts", "es_419": "Deduplicar contactos"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{'active_test': False}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
50	88	1	1	ir.actions.act_window	\N	action	list	{"en_US": "Merge", "es_419": "Fusionar"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N
52	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Ir profile", "es_419": "Perfil de IR"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{'search_default_group_session': 1}	ir.profile	current	list,form	kanban	\N	\N
53	\N	1	1	ir.actions.act_window	companies	action	list,form	{"en_US": "Companies", "es_419": "Empresas"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new company\\n              </p><p>\\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear una nueva empresa\\n              </p><p>\\n                Cree y gestione las empresas que Odoo gestionará aquí. También puede crear y dar mantenimiento a las tiendas o subsidiarias desde aquí.\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	[('parent_id', '=', False)]	{}	res.company	current	list,kanban,form	kanban	\N	\N
54	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Languages", "es_419": "Idiomas"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	120	\N	{'active_test': False}	res.lang	current	list,form	kanban	\N	\N
55	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Contact Titles", "es_419": "Títulos de contacto"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Title\\n                </p><p>\\n                    Manage Contact Titles as well as their abbreviations (e.g. \\"Mr.\\", \\"Mrs.\\", etc).\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Crear un título\\n                </p><p>\\n                    Administre los nombres de contacto así como sus abreviaciones (por ejemplo, \\"Sr.\\" \\"Sra.\\", etc).\\n                </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	[]	{}	res.partner.title	current	list,form	kanban	\N	\N
59	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Contact Tags", "es_419": "Etiquetas de contacto"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact Tag\\n              </p><p>\\n                Assign tags to your contacts to organize, filter and track them.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear una etiqueta de contacto\\n              </p><p>\\n                Asigne etiquetas a sus contactos para organizarlos, filtrarlos y rastrearlos.\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	132	\N	{}	res.partner.category	current	list,form	kanban	\N	\N
60	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Industries", "es_419": "Industrias"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Industry\\n              </p><p>\\n                Specify industries to classify your contacts and draw up reports.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear una industria\\n              </p><p>\\n                Especifique las industrias para clasificar sus contactos y elaborar reportes.\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	135	\N	{}	res.partner.industry	current	list,form	kanban	\N	\N
61	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Banks", "es_419": "Bancos"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank\\n              </p><p>\\n                Banks are the financial institutions at which you and your contacts have their accounts.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear un banco\\n              </p><p>\\n                Los bancos son instituciones financieras en las que usted y sus contactos tienen sus cuentas.\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	138	\N	{}	res.bank	current	list,form	kanban	\N	\N
62	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Bank Accounts", "es_419": "Cuentas bancarias"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank Account\\n              </p><p>\\n                From here you can manage all bank accounts linked to you and your contacts.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear una cuenta bancaria\\n              </p><p>\\n                Desde aquí puede gestionar todas las cuentas bancarias vinculadas a usted o a sus contactos.\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	res.partner.bank	current	list,form	kanban	\N	\N
63	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Countries", "es_419": "Países"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No Country Found!\\n                </p><p>\\n                    Manage the list of countries that can be set on your contacts.\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No se encontró el país\\n                </p><p>\\n                    Gestione la lista de países que se pueden establecer en sus contactos.\\n                </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	res.country	current	list,form	kanban	\N	\N
64	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Country Group", "es_419": "Grupo del país"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Country Group\\n                </p><p>\\n                    Use groups to organize countries that are frequently selected together (e.g. \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Crear un grupo de países\\n                </p><p>\\n                    Use grupos para organizar países que se seleccionan juntos con frecuencia (por ejemplo, \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	res.country.group	current	list,form	kanban	\N	\N
65	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fed. States", "es_419": "Estados"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a State\\n                </p><p>\\n                    Federal States belong to countries and are part of your contacts' addresses.\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Crear un estado\\n                </p><p>\\n                    Los estados federales pertenecen a países que son parte de sus direcciones de contacto\\n                </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	147	\N	80	\N	\N	{}	res.country.state	current	list,form	kanban	\N	\N
66	94	1	1	ir.actions.act_window	\N	action	form	{"en_US": "Show Currency Rates", "es_419": "Mostrar tasas de cambio"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	151	\N	80	\N	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	res.currency.rate	current	list,form	kanban	\N	\N
67	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Currencies", "es_419": "Monedas"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	153	\N	{'active_test': False}	res.currency	current	list,kanban,form	kanban	\N	\N
69	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Groups", "es_419": "Grupos"}	{"en_US": "<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>", "es_419": "<p>Un grupo es un conjunto de áreas funcionales que se asignarán al usuario para proporcionarle acceso y permisos a aplicaciones específicas y tareas en el sistema. Puede crear grupos personalizados o editar los existentes para personalizar la vista de menús que los usuarios podrán ver. La gestión de los permisos de lectura, escritura, creación y eliminación se puede gestionar desde aquí.</p>"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{'search_default_filter_no_share': 1, 'ir.ui.menu.full_list': 1}	res.groups	current	list,form	kanban	\N	\N
70	\N	1	1	ir.actions.act_window	users	action	list,form	{"en_US": "Users", "es_419": "Usuarios"}	{"en_US": "<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>", "es_419": "<p>Cree y gestione los usuarios que accederán al sistema, puede desactivarlos si no accederán durante cierto tiempo. Puede asignarles grupos para darles acceso específico a las aplicaciones que necesitan usar.</p>"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	164	\N	80	166	\N	{'search_default_filter_no_share': 1, 'show_user_group_warning': True}	res.users	current	list,kanban,form	kanban	\N	\N
71	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "API Key: description input wizard", "es_419": "Clave API: asistente de entrada de descripción"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	res.users.apikeys.description	new	form	kanban	\N	\N
72	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Change My Preferences", "es_419": "Cambiar mis preferencias"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	res.users	new	form	kanban	\N	\N
73	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "API Keys Listing", "es_419": "Lista de claves API"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	171	\N	80	\N	\N	{}	res.users.apikeys	current	list	kanban	\N	\N
74	\N	1	1	ir.actions.act_window	user-device	action	list,form	{"en_US": "User Devices", "es_419": "Dispositivos de usuario"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	res.device	current	list,kanban,form	kanban	\N	\N
75	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Settings", "es_419": "Ajustes"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	res.config.settings	inline	form	kanban	\N	\N
76	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Paper Format General Configuration", "es_419": "Configuración general del formato de papel"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	report.paperformat	current	list,form	kanban	\N	\N
77	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Reports", "es_419": "Reportes"}	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N	80	\N	\N	{}	ir.actions.report	current	list,form	kanban	\N	\N
81	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Configure your document layout", "es_419": "Configura el diseño de tu documento"}	\N	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188	215	\N	80	\N	\N	{"dialog_size": "extra-large"}	base.document.layout	new	form	kanban	\N	\N
84	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Import Module", "es_419": "Importar módulo"}	\N	2026-01-19 17:38:34.934808	2026-01-19 17:38:34.934808	\N	\N	80	\N	\N	{}	base.import.module	new	form	kanban	\N	\N
85	\N	1	1	ir.actions.act_window	settings	action	list,form	{"en_US": "Settings", "es_419": "Ajustes"}	\N	2026-01-19 17:38:35.032459	2026-01-19 17:38:35.032459	\N	\N	80	\N	\N	{'module' : 'general_settings', 'bin_size': False}	res.config.settings	inline	form	kanban	\N	\N
86	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Tours", "es_419": "Recorridos"}	\N	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336	231	\N	80	232	\N	{}	web_tour.tour	current	list,form	kanban	\N	\N
88	\N	1	1	ir.actions.act_window	iap-accounts	action	list,form	{"en_US": "IAP Account", "es_419": "Cuenta para compras dentro de la aplicación"}	\N	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346	\N	\N	80	\N	\N	{}	iap.account	current	list,form	kanban	\N	\N
89	208	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Compose Email", "es_419": "Redactar correo electrónico"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.compose.message	new	form	kanban	\N	\N
90	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Sending Failures", "es_419": "Errores de envío"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.resend.message	new	form	kanban	\N	\N
91	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Resend Email", "es_419": "Reenviar correo electrónico"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.resend.partner	current	form	kanban	\N	\N
92	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Template Preview", "es_419": "Vista previa de la plantilla"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	248	\N	80	\N	\N	{'default_mail_template_id':active_id}	mail.template.preview	new	form	kanban	\N	\N
56	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customers", "es_419": "Clientes"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact in your address book\\n              </p><p>\\n                Odoo helps you track all activities related to your contacts.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear un contacto en la libreta de direcciones\\n              </p><p>\\n                Odoo te ayuda a llevar seguimiento de todas las actividades relacionadas con tus contactos.\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:36.870217	\N	\N	80	128	\N	{'res_partner_search_mode': 'customer'}	res.partner	current	kanban,list,form,activity	kanban	\N	\N
57	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customers", "es_419": "Clientes"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new customer in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a customer.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear un nuevo cliente en su directorio\\n              </p><p>\\n                Odoo le ayuda a rastrear con facilidad todas las actividades relacionadas con un cliente.\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:36.870217	\N	\N	80	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	res.partner	current	kanban,list,form,activity	kanban	\N	t
58	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Vendors", "es_419": "Proveedores"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new vendor in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a vendor.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Cree un nuevo proveedor en su libreta de direcciones\\n              </p><p>\\n                Odoo le ayuda a rastrear con facilidad todas las actividades relacionadas con un proveedor.\\n              </p>\\n            "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:36.870217	\N	\N	80	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	res.partner	current	kanban,list,form,activity	kanban	\N	t
93	174	1	1	ir.actions.act_window	\N	action	list	{"en_US": "Reset Mail Template", "es_419": "Restablecer plantilla de correo"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	250	\N	80	\N	\N	{\n            'default_template_ids': active_ids\n        }	mail.template.reset	new	form	kanban	\N	\N
95	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Subtypes", "es_419": "Subtipos"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.message.subtype	current	list,form	kanban	\N	\N
96	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Tracking Values", "es_419": "Valores de seguimiento"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.tracking.value	current	list,form	kanban	\N	\N
97	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Notifications", "es_419": "Notificaciones"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.notification	current	list,form	kanban	\N	\N
98	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Messages", "es_419": "Mensajes"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	263	\N	{}	mail.message	current	list,form	kanban	\N	\N
99	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Scheduled Messages", "es_419": "Mensajes programados"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.message.schedule	current	list,form	kanban	\N	\N
100	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Emails", "es_419": "Correos electrónicos"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	270	\N	{}	mail.mail	current	list,form	kanban	\N	\N
110	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Canned Responses", "es_419": "Respuestas predefinidas"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a new canned response\\n                </p><p>\\n                    Canned responses allow you to insert prewritten responses in\\n                    your messages by typing <i>:shortcut</i>. The shortcut is\\n                    replaced directly in your message, so that you can still edit\\n                    it before sending.\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Crear una nueva respuesta predefinida\\n                </p><p>\\n                    Las respuestas predefinidas le permiten insertar mensajes creados con anterioridad en\\n                    sus mensajes al escribir <i>:atajo</i>. El atajo es\\n                    remplazado directamente en su mensaje para que pueda editarlo\\n                    antes de enviarlo.\\n                </p>\\n            "}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	288	\N	{\n                'search_default_filter_create_uid': 1,\n            }	mail.canned.response	current	list,form	kanban	\N	\N
111	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Activity Types", "es_419": "Tipos de actividad"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.activity.type	current	list,kanban,form	kanban	\N	\N
112	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Activity Overview", "es_419": "Información general de la actividad"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{\n            'force_search_count': 1,\n        }	mail.activity	current	list,form	kanban	\N	\N
113	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Other activities", "es_419": "Otras actividades"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                No activities.\\n            </p>\\n        ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Sin actividades.\\n            </p>\\n        "}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	299	[('id', 'in', active_ids)]	{}	mail.activity	main	list,form	kanban	\N	\N
114	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "My Activities", "es_419": "Mis actividades"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	299	\N	{\n            'force_search_count': 1,\n            'search_default_filter_user_id_uid': 1,\n            'search_default_filter_date_deadline_past': 1,\n            'search_default_filter_date_deadline_today': 1,\n        }	mail.activity	current	list,kanban	kanban	\N	\N
115	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Activity Plans", "es_419": "Planes de actividad"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create an Activity Plan\\n                </p>\\n                <p>\\n                    Activity plans are used to assign a list of activities in just a few clicks\\n                    (e.g. \\"Onboarding\\", \\"Prospect Follow-up\\", \\"Project Milestone Meeting\\", ...)\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Crear un plan de actividad\\n                </p>\\n                <p>\\n                    Los planes de actividad se utilizan para asignar una lista de actividades con unos cuantos clics\\n                    (por ejemplo, \\"Capacitación\\", \\"Seguimiento del cliente potencial\\", \\"Reunión sobre objetivos del proyecto\\", entre otras)\\n                </p>\\n            "}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	305	\N	{}	mail.activity.plan	current	list,kanban,form	kanban	\N	\N
127	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Alias Domains", "es_419": "Dominios del alias"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.alias.domain	current	list,form	kanban	\N	\N
128	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Aliases", "es_419": "Alias"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{\n                    'search_default_active': True,\n                }\n            	mail.alias	current	list,form	kanban	\N	\N
129	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Mail Gateway Allowed", "es_419": "Puerta de enlace de correo permitida"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.gateway.allowed	current	list	kanban	\N	\N
130	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Guests", "es_419": "Invitados"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.guest	current	list,form	kanban	\N	\N
131	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Message Reactions", "es_419": "Reacciones de mensaje"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	mail.message.reaction	current	list,form	kanban	\N	\N
132	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User Settings", "es_419": "Ajustes de usuario"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{}	res.users.settings	current	list,form	kanban	\N	\N
133	\N	1	1	ir.actions.act_window	email-templates	action	list,form	{"en_US": "Email Templates", "es_419": "Plantillas de correo electrónico"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	348	\N	80	349	\N	{'search_default_base_templates': 1}	mail.template	current	form,list	kanban	\N	\N
134	88	1	1	ir.actions.act_window	\N	action	list	{"en_US": "Send email", "es_419": "Enviar correo"}	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N	80	\N	\N	{\n                'default_composition_mode': 'mass_mail',\n                'default_partner_to': '{{ object.id or \\'\\' }}',\n                'default_subtype_xmlid': 'mail.mt_comment',\n                'default_reply_to_force_new': True,\n            }	mail.compose.message	new	form	kanban	\N	\N
135	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Blacklisted Email Addresses", "es_419": "Direcciones de correo electrónico incluidas en la lista de exclusión"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Add an email address to the blacklist\\n          </p><p>\\n            Email addresses that are blacklisted won't receive Email mailings anymore.\\n        </p>\\n        ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Agregar una dirección de correo electrónico a la lista de exclusión\\n          </p><p>\\n            Las direcciones de correo electrónico que estén en la lista negra ya no recibirán correos electrónicos\\n        </p>\\n        "}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	359	\N	80	361	\N	{}	mail.blacklist	current	list,form	kanban	\N	\N
140	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Background Jobs"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                No background jobs found!\\n            </p>\\n            <p>\\n                Background jobs are created automatically when you perform operations\\n                that take a long time to complete. They allow you to continue working\\n                while the system processes your request in the background.\\n            </p>\\n        "}	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163	\N	\N	80	\N	\N	{}	bg.job	current	list,form	kanban	\N	\N
143	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "You are about to install an extra application", "es_419": "Está por instalar una aplicación adicional"}	\N	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726	\N	\N	80	\N	\N	{ 'default_module_id': active_id }	base.module.install.review	new	form	kanban	\N	\N
144	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Blacklisted Phone Numbers", "es_419": "Números de teléfono en la lista de exclusión"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Add a phone number in the blacklist\\n            </p><p>\\n                Blacklisted phone numbers won't receive SMS Mailings anymore.\\n            </p>\\n        ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Agregue un número de teléfono a la lista de exclusión\\n            </p><p>\\n                Los números de teléfono en la lista de exclusión no recibirán SMS.\\n            </p>\\n        "}	2026-01-19 17:38:40.373729	2026-01-19 17:38:40.373729	402	\N	80	404	\N	{}	phone.blacklist	current	list,form	kanban	\N	\N
149	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Privacy Logs", "es_419": "Registros de privacidad"}	\N	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682	\N	\N	80	\N	\N	{'create': False}	privacy.log	current	list,form	kanban	\N	\N
150	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Privacy Logs", "es_419": "Registros de privacidad"}	\N	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682	\N	\N	80	\N	\N	{'create': False}	privacy.log	current	form	kanban	\N	\N
145	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Privacy Lookup", "es_419": "Búsqueda de privacidad"}	\N	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682	406	\N	80	\N	\N	{}	privacy.lookup.wizard	current	form	kanban	\N	\N
146	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Privacy Lookup Line", "es_419": "Línea de búsqueda de privacidad"}	\N	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682	407	\N	80	\N	\N	{'search_default_group_by_res_model_id': 1, 'no_create_edit': True}	privacy.lookup.wizard.line	current	list	kanban	\N	\N
153	\N	1	1	ir.actions.act_window	modules-state	action	list,form	{"en_US": "Modules State", "es_419": "Estado de los Módulos"}	\N	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672	\N	\N	80	\N	\N	{}	db.configuration	inline	form	kanban	\N	\N
158	352	1	1	ir.actions.act_window	\N	action	list	{"en_US": "Reset SMS Template", "es_419": "Restablecer las plantillas de SMS"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	420	\N	80	\N	\N	{\n            'default_template_ids': active_ids\n        }	sms.template.reset	new	form	kanban	\N	\N
161	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "SMS", "es_419": "SMS"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	\N	\N	80	\N	[('to_delete', '!=', True)]	{}	sms.sms	current	list,form	kanban	\N	\N
159	88	1	1	ir.actions.act_window	\N	action	list	{"en_US": "Send SMS", "es_419": "Enviar SMS"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	\N	\N	80	\N	\N	{\n            'default_composition_mode': 'mass',\n            'default_mass_keep_log': True,\n            'default_res_ids': active_ids\n        }	sms.composer	new	form	kanban	\N	\N
160	88	1	1	ir.actions.act_window	\N	action	form	{"en_US": "Send SMS", "es_419": "Enviar SMS"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	\N	\N	80	\N	\N	{\n            'default_composition_mode': 'comment',\n            'default_res_id': active_id,\n        }	sms.composer	new	form	kanban	\N	\N
155	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Send SMS", "es_419": "Enviar SMS"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	\N	\N	80	\N	\N	{}	sms.composer	new	form	kanban	\N	\N
157	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Sending Failures", "es_419": "Errores de envío"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	\N	\N	80	\N	\N	{}	sms.resend	new	form	kanban	\N	\N
156	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Template Preview", "es_419": "Vista previa de la plantilla"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	418	\N	80	\N	\N	{'default_sms_template_id':active_id}	sms.template.preview	new	form	kanban	\N	\N
163	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Templates", "es_419": "Plantillas"}	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933	\N	\N	80	\N	\N	{}	sms.template	current	list,form	kanban	\N	\N
167	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Failed letter", "es_419": "Carta con errores"}	\N	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327	\N	\N	80	\N	\N	{}	snailmail.letter.missing.required.fields	new	form	kanban	\N	\N
166	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Format Error", "es_419": "Error de formato"}	\N	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327	\N	\N	80	\N	\N	{}	snailmail.letter.format.error	new	form	kanban	\N	\N
165	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Snailmail Letters", "es_419": "Cartas de correo postal"}	\N	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327	436	\N	80	\N	[('state', '!=', 'draft')]	{}	snailmail.letter	current	form,list	kanban	\N	\N
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
73	4
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_view (id, sequence, view_id, act_window_id, create_uid, write_uid, view_mode, multi, create_date, write_date) FROM stdin;
1	1	12	7	1	1	list	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
2	2	13	7	1	1	form	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
3	0	129	56	1	1	kanban	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
4	2	126	56	1	1	form	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
5	1	123	56	1	1	list	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
6	1	129	57	1	1	kanban	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
7	2	123	57	1	1	list	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
8	3	126	57	1	1	form	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
9	1	129	58	1	1	kanban	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
10	2	123	58	1	1	list	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
11	3	126	58	1	1	form	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
12	10	164	70	1	1	list	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
13	20	163	70	1	1	form	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
14	10	170	72	1	1	form	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
15	1	\N	112	1	1	list	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
16	2	297	112	1	1	form	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
17	1	301	113	1	1	list	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
18	2	298	113	1	1	form	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
19	1	302	114	1	1	list	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
20	1	303	114	1	1	kanban	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
21	1	307	115	1	1	list	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
22	2	308	115	1	1	form	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_todo (id, action_id, sequence, create_uid, write_uid, state, name, create_date, write_date) FROM stdin;
1	2	100	1	1	done	Open Menu	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
2	51	1	1	1	done	Demo Failure Notification	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_asset (id, sequence, create_uid, write_uid, name, bundle, directive, path, target, active, create_date, write_date) FROM stdin;
1	16	1	1	13 0 color system support primary variables SCSS	web._assets_primary_variables	append	web_editor/static/src/scss/13_0_color_system_support_primary_variables.scss	\N	f	2026-01-19 17:38:38.721346	2026-01-19 17:38:38.721346
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_attachment (id, res_id, company_id, file_size, create_uid, write_uid, name, res_model, res_field, type, url, access_token, store_fname, checksum, mimetype, description, index_content, public, create_date, write_date, db_datas, original_id) FROM stdin;
1	3	1	9152	1	1	flag_image	res.lang	flag_image	binary	\N	\N	44/44d1661b24fa9f688091c8256535434b60aafba7	44d1661b24fa9f688091c8256535434b60aafba7	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
2	65	1	15497	1	1	flag_image	res.lang	flag_image	binary	\N	\N	62/627090759f9a66678c28c1bc3c3039b37f40f66e	627090759f9a66678c28c1bc3c3039b37f40f66e	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
3	11	1	192	1	1	flag_image	res.lang	flag_image	binary	\N	\N	05/055ffc5cce56e142234ffc466012dff7edc2c7e7	055ffc5cce56e142234ffc466012dff7edc2c7e7	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
4	1	1	11445	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
5	1	1	11445	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
6	1	1	11445	1	1	image_512	res.partner	image_512	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
7	1	1	12556	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0ce8c97df3ec768af51696ede284aac75b0eec18	0ce8c97df3ec768af51696ede284aac75b0eec18	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
8	1	1	5254	1	1	image_128	res.partner	image_128	binary	\N	\N	60/60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
9	1	1	2063	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b7/b73a9deb85def8a1a00e4d545c4f79747d78f487	b73a9deb85def8a1a00e4d545c4f79747d78f487	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
10	15	1	2282	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	3d/3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
11	16	1	4667	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	1c/1c2a8239bc7e06429116c40bc1d1334c621ca379	1c2a8239bc7e06429116c40bc1d1334c621ca379	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
12	7	1	63193	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
13	3	1	68639	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
14	8	1	52528	1	1	image_1920	res.partner	image_1920	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
15	7	1	63193	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
16	3	1	68639	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
17	8	1	52528	1	1	image_1024	res.partner	image_1024	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
18	7	1	63193	1	1	image_512	res.partner	image_512	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
19	3	1	68639	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
20	8	1	52528	1	1	image_512	res.partner	image_512	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
21	7	1	52447	1	1	image_256	res.partner	image_256	binary	\N	\N	54/541590d82737cc97075b4d26e20dd2279c7bdddb	541590d82737cc97075b4d26e20dd2279c7bdddb	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
22	3	1	38672	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88fde30360b832576cfb405e1803f323701cb481	88fde30360b832576cfb405e1803f323701cb481	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
23	8	1	43536	1	1	image_256	res.partner	image_256	binary	\N	\N	19/191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
24	7	1	16870	1	1	image_128	res.partner	image_128	binary	\N	\N	fe/feec584f963736452b620ab99d007a7472d50e4d	feec584f963736452b620ab99d007a7472d50e4d	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
25	3	1	15206	1	1	image_128	res.partner	image_128	binary	\N	\N	f6/f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
26	8	1	15699	1	1	image_128	res.partner	image_128	binary	\N	\N	24/24ffb3e8122416b93bcd50cc67ac33799d047501	24ffb3e8122416b93bcd50cc67ac33799d047501	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
27	9	1	8135	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
28	10	1	9710	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
29	11	1	6301	1	1	image_1920	res.partner	image_1920	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
30	12	1	13440	1	1	image_1920	res.partner	image_1920	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
31	13	1	4724	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
32	14	1	4755	1	1	image_1920	res.partner	image_1920	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
33	15	1	1464	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
34	16	1	1277	1	1	image_1920	res.partner	image_1920	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
35	17	1	3598	1	1	image_1920	res.partner	image_1920	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
36	18	1	4752	1	1	image_1920	res.partner	image_1920	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
37	19	1	4896	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
38	20	1	5433	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
39	21	1	5422	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
40	22	1	5615	1	1	image_1920	res.partner	image_1920	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
41	23	1	5616	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
42	24	1	5084	1	1	image_1920	res.partner	image_1920	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
43	25	1	23707	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
44	26	1	6322	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
45	27	1	4563	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
46	28	1	4105	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
47	29	1	4513	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
48	30	1	4051	1	1	image_1920	res.partner	image_1920	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
49	31	1	4726	1	1	image_1920	res.partner	image_1920	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
50	32	1	6516	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
51	33	1	4410	1	1	image_1920	res.partner	image_1920	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
52	34	1	5157	1	1	image_1920	res.partner	image_1920	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
53	35	1	6492	1	1	image_1920	res.partner	image_1920	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
54	36	1	4291	1	1	image_1920	res.partner	image_1920	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
55	37	1	3767	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
56	38	1	4857	1	1	image_1920	res.partner	image_1920	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
57	39	1	4612	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
58	40	1	3200	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
59	41	1	18074	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
60	9	1	8135	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
61	10	1	9710	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
62	11	1	6301	1	1	image_1024	res.partner	image_1024	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
63	12	1	13440	1	1	image_1024	res.partner	image_1024	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
64	13	1	4724	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
65	14	1	4755	1	1	image_1024	res.partner	image_1024	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
66	15	1	1464	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
67	16	1	1277	1	1	image_1024	res.partner	image_1024	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
68	17	1	3598	1	1	image_1024	res.partner	image_1024	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
69	18	1	4752	1	1	image_1024	res.partner	image_1024	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
70	19	1	4896	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
71	20	1	5433	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
72	21	1	5422	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
73	22	1	5615	1	1	image_1024	res.partner	image_1024	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
74	23	1	5616	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
75	24	1	5084	1	1	image_1024	res.partner	image_1024	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
76	25	1	23707	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
77	26	1	6322	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
78	27	1	4563	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
79	28	1	4105	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
80	29	1	4513	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
81	30	1	4051	1	1	image_1024	res.partner	image_1024	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
82	31	1	4726	1	1	image_1024	res.partner	image_1024	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
83	32	1	6516	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
84	33	1	4410	1	1	image_1024	res.partner	image_1024	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
85	34	1	5157	1	1	image_1024	res.partner	image_1024	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
86	35	1	6492	1	1	image_1024	res.partner	image_1024	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
87	36	1	4291	1	1	image_1024	res.partner	image_1024	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
88	37	1	3767	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
89	38	1	4857	1	1	image_1024	res.partner	image_1024	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
90	39	1	4612	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
91	40	1	3200	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
92	41	1	18074	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
93	9	1	8135	1	1	image_512	res.partner	image_512	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
94	10	1	9710	1	1	image_512	res.partner	image_512	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
95	11	1	6301	1	1	image_512	res.partner	image_512	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
96	12	1	13440	1	1	image_512	res.partner	image_512	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
97	13	1	4724	1	1	image_512	res.partner	image_512	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
98	14	1	4755	1	1	image_512	res.partner	image_512	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
99	15	1	1464	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
100	16	1	1277	1	1	image_512	res.partner	image_512	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
101	17	1	3598	1	1	image_512	res.partner	image_512	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
102	18	1	4752	1	1	image_512	res.partner	image_512	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
103	19	1	4896	1	1	image_512	res.partner	image_512	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
104	20	1	5433	1	1	image_512	res.partner	image_512	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
105	21	1	5422	1	1	image_512	res.partner	image_512	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
106	22	1	5615	1	1	image_512	res.partner	image_512	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
107	23	1	5616	1	1	image_512	res.partner	image_512	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
108	24	1	5084	1	1	image_512	res.partner	image_512	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
109	25	1	23707	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
110	26	1	6322	1	1	image_512	res.partner	image_512	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
111	27	1	4563	1	1	image_512	res.partner	image_512	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
112	28	1	4105	1	1	image_512	res.partner	image_512	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
113	29	1	4513	1	1	image_512	res.partner	image_512	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
114	30	1	4051	1	1	image_512	res.partner	image_512	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
115	31	1	4726	1	1	image_512	res.partner	image_512	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
116	32	1	6516	1	1	image_512	res.partner	image_512	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
117	33	1	4410	1	1	image_512	res.partner	image_512	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
118	34	1	5157	1	1	image_512	res.partner	image_512	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
119	35	1	6492	1	1	image_512	res.partner	image_512	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
120	36	1	4291	1	1	image_512	res.partner	image_512	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
121	37	1	3767	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
122	38	1	4857	1	1	image_512	res.partner	image_512	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
123	39	1	4612	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
124	40	1	3200	1	1	image_512	res.partner	image_512	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
125	41	1	18074	1	1	image_512	res.partner	image_512	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
126	9	1	8135	1	1	image_256	res.partner	image_256	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
127	10	1	9710	1	1	image_256	res.partner	image_256	binary	\N	\N	ea/eac9146029c64f7b1307ea35ab9ffcc99cce991f	eac9146029c64f7b1307ea35ab9ffcc99cce991f	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
128	11	1	6301	1	1	image_256	res.partner	image_256	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
129	12	1	13440	1	1	image_256	res.partner	image_256	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
130	13	1	4724	1	1	image_256	res.partner	image_256	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
131	14	1	4755	1	1	image_256	res.partner	image_256	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
132	15	1	1464	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
133	16	1	1277	1	1	image_256	res.partner	image_256	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
134	17	1	3598	1	1	image_256	res.partner	image_256	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
135	18	1	4752	1	1	image_256	res.partner	image_256	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
136	19	1	4896	1	1	image_256	res.partner	image_256	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
137	20	1	5433	1	1	image_256	res.partner	image_256	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
138	21	1	5422	1	1	image_256	res.partner	image_256	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
139	22	1	5615	1	1	image_256	res.partner	image_256	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
140	23	1	5616	1	1	image_256	res.partner	image_256	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
141	24	1	5084	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
142	25	1	23707	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
143	26	1	6322	1	1	image_256	res.partner	image_256	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
144	27	1	4563	1	1	image_256	res.partner	image_256	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
145	28	1	4105	1	1	image_256	res.partner	image_256	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
146	29	1	4513	1	1	image_256	res.partner	image_256	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
147	30	1	4051	1	1	image_256	res.partner	image_256	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
148	31	1	4726	1	1	image_256	res.partner	image_256	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
149	32	1	6516	1	1	image_256	res.partner	image_256	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
150	33	1	4410	1	1	image_256	res.partner	image_256	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
151	34	1	5157	1	1	image_256	res.partner	image_256	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
152	35	1	6492	1	1	image_256	res.partner	image_256	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
153	36	1	4291	1	1	image_256	res.partner	image_256	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
154	37	1	3767	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
155	38	1	4857	1	1	image_256	res.partner	image_256	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
156	39	1	4612	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
157	40	1	3200	1	1	image_256	res.partner	image_256	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
158	41	1	18074	1	1	image_256	res.partner	image_256	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
159	9	1	10323	1	1	image_128	res.partner	image_128	binary	\N	\N	82/823b20bb764aaf8fcb88134b9bb3d82a05dea84a	823b20bb764aaf8fcb88134b9bb3d82a05dea84a	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
160	10	1	10300	1	1	image_128	res.partner	image_128	binary	\N	\N	c3/c33684082a1e03bbcb7bce2572ccc58d836f2d9d	c33684082a1e03bbcb7bce2572ccc58d836f2d9d	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
161	11	1	8472	1	1	image_128	res.partner	image_128	binary	\N	\N	1d/1d695025b620cc90bd115824dbd8c6722fde6506	1d695025b620cc90bd115824dbd8c6722fde6506	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
162	12	1	15232	1	1	image_128	res.partner	image_128	binary	\N	\N	48/48c74e0562a9887fccde6079b766c08ba86a2069	48c74e0562a9887fccde6079b766c08ba86a2069	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
163	13	1	5510	1	1	image_128	res.partner	image_128	binary	\N	\N	a1/a1600097a74b7d4407c60f4ae1f5fa425c521e52	a1600097a74b7d4407c60f4ae1f5fa425c521e52	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
164	14	1	4258	1	1	image_128	res.partner	image_128	binary	\N	\N	dc/dcb6d977c85554329430b436ff900158de14160c	dcb6d977c85554329430b436ff900158de14160c	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
165	15	1	1464	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
166	16	1	1277	1	1	image_128	res.partner	image_128	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
167	17	1	3598	1	1	image_128	res.partner	image_128	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
168	18	1	4752	1	1	image_128	res.partner	image_128	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
169	19	1	4896	1	1	image_128	res.partner	image_128	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
170	20	1	5433	1	1	image_128	res.partner	image_128	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
171	21	1	5422	1	1	image_128	res.partner	image_128	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
172	22	1	5615	1	1	image_128	res.partner	image_128	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
173	23	1	5616	1	1	image_128	res.partner	image_128	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
174	24	1	5084	1	1	image_128	res.partner	image_128	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
175	25	1	23707	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
176	26	1	6322	1	1	image_128	res.partner	image_128	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
177	27	1	4563	1	1	image_128	res.partner	image_128	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
178	28	1	4105	1	1	image_128	res.partner	image_128	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
179	29	1	4513	1	1	image_128	res.partner	image_128	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
180	30	1	4051	1	1	image_128	res.partner	image_128	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
181	31	1	4726	1	1	image_128	res.partner	image_128	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
182	32	1	6516	1	1	image_128	res.partner	image_128	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
183	33	1	4410	1	1	image_128	res.partner	image_128	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
184	34	1	5157	1	1	image_128	res.partner	image_128	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
185	35	1	6492	1	1	image_128	res.partner	image_128	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
186	36	1	4291	1	1	image_128	res.partner	image_128	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
187	37	1	3767	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
188	38	1	4857	1	1	image_128	res.partner	image_128	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
189	39	1	4612	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
190	40	1	3200	1	1	image_128	res.partner	image_128	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
191	41	1	18074	1	1	image_128	res.partner	image_128	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	image	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	\N
192	\N	1	\N	1	1	placeholder.png	\N	\N	url	/web/static/img/placeholder.png	\N	\N	\N	image/png	\N	\N	t	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188	\N	\N
193	\N	1	854	1	1	res.company.scss	\N	\N	binary	web/static/asset_styles_company_report.scss	\N	54/542922906caac0fe5d253e2c7d913758eb0a7f6e	542922906caac0fe5d253e2c7d913758eb0a7f6e	text/scss	\N	                // Simplified color-contrast function to replicate bootstrap in report preview.\n                @function preview-color-contrast($background) {\n                    @if (lightness($background) > 50) {\n                        @return black;\n                    } @else {\n                        @return white;\n                    }\n                }\n                .o_company_1_layout {\n                    font-family: Lato;\n                    h2 {\n                        color: #212529;\n                    }\n                    #informations strong {\n                        color: #212529;\n                    }\n                    .o_total strong {\n                        color: #212529;\n                    }\n                    .o_company_tagline {\n                        color: #212529\n                    }\n            }	\N	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188	\N	\N
194	2	1	25613	1	1	image_1920	res.partner	image_1920	binary	\N	\N	c7/c7a775ae75785d5acee7edb5b8c748fef61ef8d4	c7a775ae75785d5acee7edb5b8c748fef61ef8d4	image/png	\N	image	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N
195	2	1	25613	1	1	image_1024	res.partner	image_1024	binary	\N	\N	c7/c7a775ae75785d5acee7edb5b8c748fef61ef8d4	c7a775ae75785d5acee7edb5b8c748fef61ef8d4	image/png	\N	image	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N
196	2	1	25613	1	1	image_512	res.partner	image_512	binary	\N	\N	c7/c7a775ae75785d5acee7edb5b8c748fef61ef8d4	c7a775ae75785d5acee7edb5b8c748fef61ef8d4	image/png	\N	image	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N
197	2	1	11405	1	1	image_256	res.partner	image_256	binary	\N	\N	88/882cf6e5697903fd69b7700f5e51fd15096d136c	882cf6e5697903fd69b7700f5e51fd15096d136c	image/png	\N	image	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N
198	2	1	5202	1	1	image_128	res.partner	image_128	binary	\N	\N	36/36ba5ef36880a809f9bdddfe35f12fcf34406a6e	36ba5ef36880a809f9bdddfe35f12fcf34406a6e	image/png	\N	image	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N
199	71	1	1796	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	74/744fc247b813c44f4cf02357706e88b283cb0f97	744fc247b813c44f4cf02357706e88b283cb0f97	image/png	\N	image	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217	\N	\N
\.


--
-- Data for Name: ir_config_parameter; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_config_parameter (id, create_uid, write_uid, key, value, create_date, write_date) FROM stdin;
4	1	1	web.base.url	http://localhost:8069	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
5	1	1	base.login_cooldown_after	10	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
6	1	1	base.login_cooldown_duration	60	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
7	1	1	base.template_portal_user_id	5	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
8	1	1	base.default_max_email_size	10	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
1	1	1	database.secret	c1a5f000-0f5c-46e5-817e-19542e70ab4e	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
2	1	1	database.uuid	abe6113a-f55d-11f0-8a13-a2a258d31ad2	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
3	1	1	database.create_date	2026-01-19 17:38:31	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
9	1	1	base_setup.show_effect	True	2026-01-19 17:38:35.032459	2026-01-19 17:38:35.032459
10	1	1	base_setup.default_user_rights	True	2026-01-19 17:38:35.032459	2026-01-19 17:38:35.032459
11	1	1	ribbon.name	TEST<br/>({db_name})	2026-01-19 17:38:35.504753	2026-01-19 17:38:35.504753
12	1	1	ribbon.color	#f0f0f0	2026-01-19 17:38:35.504753	2026-01-19 17:38:35.504753
13	1	1	ribbon.background.color	rgba(255,0,0,.6)	2026-01-19 17:38:35.504753	2026-01-19 17:38:35.504753
14	1	1	mail.activity.gc.delete_overdue_years	3	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
15	1	1	mail.restrict.template.rendering	1	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
16	1	1	auth_signup.invitation_scope	b2c	2026-01-19 17:38:39.554159	2026-01-19 17:38:39.554159
17	1	1	auth_signup.reset_password	True	2026-01-19 17:38:39.554159	2026-01-19 17:38:39.554159
18	1	1	iap_extract_endpoint	https://extract.api.odoo.com	2026-01-19 17:38:41.418689	2026-01-19 17:38:41.418689
19	1	1	mail_mobile.enable_ocn	True	2026-01-19 17:38:41.480318	2026-01-19 17:38:41.480318
20	1	1	saas_client.allow_bypass_on_production	True	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
21	1	1	server_mode.ribbon_name	DEMO 18	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
\.


--
-- Data for Name: ir_cron; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron (id, ir_actions_server_id, user_id, interval_number, priority, failure_count, create_uid, write_uid, cron_name, interval_type, active, nextcall, lastcall, first_failure_date, create_date, write_date) FROM stdin;
1	35	1	1	3	0	1	1	Base: Auto-vacuum internal data	days	t	2026-01-19 17:38:30	\N	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
2	36	1	1	8	0	1	1	Base: Portal Users Deletion	days	t	2026-01-19 17:38:30	\N	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
3	116	1	1	6	0	1	1	Mail: Email Queue Manager	hours	t	2026-01-19 17:38:38	\N	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
4	117	1	1	1000	0	1	1	Publisher: Update Notification	weeks	t	2026-01-26 17:38:38	\N	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
5	118	1	1	5	0	1	1	Notification: Delete Notifications older than 6 Month	days	t	2026-01-19 17:38:38	\N	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
6	119	1	5	5	0	1	1	Mail: Fetchmail Service	minutes	f	2026-01-19 17:38:38	\N	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
7	120	1	1	5	0	1	1	Mail: Post scheduled messages	days	t	2026-01-19 17:38:38	\N	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
8	121	1	1	5	0	1	1	Notification: Notify scheduled messages	hours	t	2026-01-19 17:38:38	\N	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
9	122	1	1	5	0	1	1	Mail: send web push notification	days	t	2026-01-19 17:38:38	\N	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
10	123	1	1	5	0	1	1	Discuss: channel member unmute	days	t	2026-01-19 17:38:38	\N	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
11	124	1	1	5	0	1	1	Discuss: users settings unmute	days	t	2026-01-19 17:38:38	\N	\N	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
12	136	1	1	6	0	1	1	Users: Notify About Unregistered Users	days	t	2026-01-19 17:38:39	\N	\N	2026-01-19 17:38:39.554159	2026-01-19 17:38:39.554159
13	141	1	10	5	0	1	1	Background Job Runner	minutes	t	2026-01-19 17:38:39	\N	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163
14	142	1	10	5	0	1	1	Background Job Monitor	minutes	t	2026-01-19 17:38:39	\N	\N	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163
15	154	1	1	5	0	1	1	SMS: SMS Queue Manager	hours	t	2026-01-19 17:38:42	\N	\N	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
16	164	1	1	5	0	1	1	Snailmail: process letters queue	hours	t	2026-01-19 17:38:42	\N	\N	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
\.


--
-- Data for Name: ir_cron_progress; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_progress (id, cron_id, remaining, done, timed_out_counter, create_uid, write_uid, deactivate, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_cron_trigger; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_trigger (id, cron_id, create_uid, write_uid, call_at, create_date, write_date) FROM stdin;
1	1	1	1	2026-01-19 17:39:43.088074	2026-01-19 17:38:42.995616	2026-01-19 17:38:42.995616
\.


--
-- Data for Name: ir_default; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_default (id, field_id, user_id, company_id, create_uid, write_uid, condition, json_value, create_date, write_date) FROM stdin;
1	909	\N	\N	1	1	\N	"en_US"	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
\.


--
-- Data for Name: ir_demo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure (id, module_id, wizard_id, create_uid, write_uid, error, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_embedded_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_embedded_actions (id, sequence, parent_action_id, parent_res_id, action_id, user_id, create_uid, write_uid, parent_res_model, python_method, default_view_mode, domain, context, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_embedded_actions_res_groups_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_embedded_actions_res_groups_rel (ir_embedded_actions_id, res_groups_id) FROM stdin;
\.


--
-- Data for Name: ir_exports; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports (id, create_uid, write_uid, name, resource, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports_line (id, export_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_filters; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_filters (id, user_id, action_id, embedded_action_id, embedded_parent_res_id, create_uid, write_uid, name, sort, model_id, domain, context, is_default, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_logging; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_logging (id, create_uid, write_uid, name, type, dbname, level, path, func, line, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_mail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_mail_server (id, smtp_port, sequence, create_uid, write_uid, name, from_filter, smtp_host, smtp_authentication, smtp_user, smtp_pass, smtp_encryption, smtp_debug, active, create_date, write_date, max_email_size, smtp_ssl_certificate, smtp_ssl_private_key, google_gmail_access_token_expiration, google_gmail_authorization_code, google_gmail_refresh_token, google_gmail_access_token) FROM stdin;
\.


--
-- Data for Name: ir_model; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model (id, create_uid, write_uid, model, "order", state, name, info, transient, create_date, write_date, is_mail_thread, is_mail_activity, is_mail_blacklist) FROM stdin;
2	\N	\N	_unknown	id	base	{"en_US": "Unknown", "es_419": "Desconocido"}	\n    Abstract model used as a substitute for relational fields with an unknown\n    comodel.\n    	f	\N	\N	f	f	f
1	\N	\N	base	id	base	{"en_US": "Base", "es_419": "Base"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
25	\N	\N	ir.actions.todo	sequence, id	base	{"en_US": "Configuration Wizards", "es_419": "Asistentes de configuración"}	\n    Configuration Wizards\n    	f	\N	\N	f	f	f
53	\N	\N	ir.qweb.field.one2many	id	base	{"en_US": "Qweb field one2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
56	\N	\N	ir.qweb.field.image_url	id	base	{"en_US": "Qweb Field Image", "es_419": "Campo Qweb de imagen"}	 ``image_url`` widget rendering, inserts an image tag in the\n    document.\n    	f	\N	\N	f	f	f
80	\N	\N	res.country	name	base	{"en_US": "Country", "es_419": "País"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
106	\N	\N	res.users.apikeys.show	id	base	{"en_US": "Show API Key", "es_419": "Mostrar clave API"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
7	\N	\N	ir.model.constraint	id	base	{"en_US": "Model Constraint", "es_419": "Restricción del modelo"}	\n    This model tracks PostgreSQL foreign keys and constraints used by Odoo\n    models.\n    	f	\N	\N	f	f	f
44	\N	\N	ir.qweb.field	id	base	{"en_US": "Qweb Field", "es_419": "Campo Qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
61	\N	\N	ir.qweb.field.relative	id	base	{"en_US": "Qweb Field Relative", "es_419": "Campo relativo de Qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
82	\N	\N	res.country.state	code	base	{"en_US": "Country state", "es_419": "Estado"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
83	\N	\N	res.lang	active desc,name	base	{"en_US": "Languages", "es_419": "Idiomas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
84	\N	\N	format.vat.label.mixin	id	base	{"en_US": "Country Specific VAT Label", "es_419": "Etiqueta de IVA específica del país"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
85	\N	\N	format.address.mixin	id	base	{"en_US": "Address Format", "es_419": "Formato de dirección"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
86	\N	\N	res.partner.category	name	base	{"en_US": "Partner Tags", "es_419": "Etiquetas del contacto"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
97	\N	\N	res.groups	name	base	{"en_US": "Access Groups", "es_419": "Grupos de acceso"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
101	\N	\N	change.password.wizard	id	base	{"en_US": "Change Password Wizard", "es_419": "Asistente para cambiar contraseña"}	 A wizard to manage the change of users' passwords. 	t	\N	\N	f	f	f
123	\N	\N	auth_totp.device	id	base	{"en_US": "Authentication Device", "es_419": "Dispositivo de autenticación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
55	\N	\N	ir.qweb.field.image	id	base	{"en_US": "Qweb Field Image", "es_419": "Campo Qweb de imagen"}	\n    Widget options:\n\n    ``class``\n        set as attribute on the generated <img> tag\n    	f	\N	\N	f	f	f
88	\N	\N	res.partner	complete_name ASC, id DESC	base	{"en_US": "Contact", "es_419": "Contacto"}	 Purpose of this mixin is to offer two services\n\n      * compute a sanitized phone number based on _phone_get_number_fields.\n        It takes first sanitized value, trying each field returned by the\n        method (see ``BaseModel._phone_get_number_fields()´´ for more details\n        about the usage of this method);\n      * compute blacklist state of records. It is based on phone.blacklist\n        model and give an easy-to-use field and API to manipulate blacklisted\n        records;\n\n    Main API methods\n\n      * ``_phone_set_blacklisted``: set recordset as blacklisted;\n      * ``_phone_reset_blacklisted``: reactivate recordset (even if not blacklisted\n        this method can be called safely);\n    	f	\N	\N	t	t	t
119	\N	\N	base.partner.merge.line	min_id asc	base	{"en_US": "Merge Partner Line", "es_419": "Fusionar línea de contacto"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
122	\N	\N	base.document.layout	id	base	{"en_US": "Company Document Layout", "es_419": "Diseño de documentos de la empresa"}	\n    Customise the company document layout and display a live preview\n    	t	\N	\N	f	f	f
68	\N	\N	ir.module.module	application desc,sequence,name	base	{"en_US": "Module", "es_419": "Módulo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
125	\N	\N	base_import.mapping	id	base	{"en_US": "Base Import Mapping", "es_419": "Mapeo de la importación de base"}	 mapping of previous column:field selections\n\n    This is useful when repeatedly importing from a third-party\n    system: column names generated by the external system may\n    not match Odoo's field names or labels. This model is used\n    to save the mapping between column names and fields so that\n    next time a user imports from the same third-party systems\n    we can automatically match the columns to the correct field\n    without them having to re-enter the mapping every single\n    time.\n    	f	\N	\N	f	f	f
127	\N	\N	base.import.module	id	base	{"en_US": "Import Module", "es_419": "Importar módulo"}	 Import Module 	t	\N	\N	f	f	f
128	\N	\N	kpi.provider	id	base	{"en_US": "KPI Provider", "es_419": "Proveedor de KPI"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
129	\N	\N	bus.bus	id	base	{"en_US": "Communication Bus", "es_419": "Bus de comunicación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
130	\N	\N	bus.listener.mixin	id	base	{"en_US": "Can send messages via bus.bus", "es_419": "Puede enviar mensajes mediante bus.bus"}	Allow sending messages related to the current model via as a bus.bus channel.\n\n    The model needs to be allowed as a valid channel for the bus in `_build_bus_channel_list`.\n    	f	\N	\N	f	f	f
132	\N	\N	ir.websocket	id	base	{"en_US": "websocket message handling", "es_419": "gestión de mensajes de WebSocket"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
133	\N	\N	web.environment.ribbon.backend	id	base	{"en_US": "Web Environment Ribbon Backend", "es_419": "Backend \\"Web Environment Ribbon\\""}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
136	\N	\N	iap.account	id	base	{"en_US": "IAP Account", "es_419": "Cuenta para compras dentro de la aplicación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	f	f
134	\N	\N	web_tour.tour	sequence, name, id	base	{"en_US": "Tours", "es_419": "Recorridos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
135	\N	\N	web_tour.tour.step	sequence, id	base	{"en_US": "Tour's step", "es_419": "Paso del recorrido"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
137	\N	\N	iap.enrich.api	id	base	{"en_US": "IAP Lead Enrichment API", "es_419": "API de enriquecimiento de leads para compras dentro de la aplicación"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
93	\N	\N	res.config.settings	id	base	{"en_US": "Config Settings", "es_419": "Ajustes de configuración"}	 Inherit the base settings to add a counter of failed email + configure\n    the alias domain. 	t	\N	\N	f	f	f
5	\N	\N	ir.model.inherit	id	base	{"en_US": "Model Inheritance Tree", "es_419": "Modelo de árbol de la herencia"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
6	\N	\N	ir.model.fields.selection	sequence, id	base	{"en_US": "Fields Selection", "es_419": "Selección de campos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
8	\N	\N	ir.model.relation	id	base	{"en_US": "Relation Model", "es_419": "Modelo relacional"}	\n    This model tracks PostgreSQL tables used to implement Odoo many2many\n    relations.\n    	f	\N	\N	f	f	f
9	\N	\N	ir.model.access	model_id,group_id,name,id	base	{"en_US": "Model Access", "es_419": "Acceso al modelo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
10	\N	\N	ir.model.data	module, model, name	base	{"en_US": "Model Data", "es_419": "Datos del modelo"}	Holds external identifier keys for records in the database.\n       This has two main uses:\n\n           * allows easy data integration with third-party systems,\n             making import/export/sync of data possible, as records\n             can be uniquely identified across multiple systems\n           * allows tracking the origin of data installed by Odoo\n             modules themselves, thus making it possible to later\n             update them seamlessly.\n    	f	\N	\N	f	f	f
11	\N	\N	wizard.ir.model.menu.create	id	base	{"en_US": "Create Menu Wizard", "es_419": "Asistente para crear menú"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
12	\N	\N	ir.sequence	name	base	{"en_US": "Sequence", "es_419": "Secuencia"}	 Sequence model.\n\n    The sequence model allows to define and use so-called sequence objects.\n    Such objects are used to generate unique identifiers in a transaction-safe\n    way.\n\n    	f	\N	\N	f	f	f
13	\N	\N	ir.sequence.date_range	id	base	{"en_US": "Sequence Date Range", "es_419": "Rango de fechas de la secuencia"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
15	\N	\N	ir.ui.view.custom	create_date desc	base	{"en_US": "Custom View", "es_419": "Vista personalizada"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
17	\N	\N	reset.view.arch.wizard	id	base	{"en_US": "Reset View Architecture Wizard", "es_419": "Asistente para restablecer la arquitectura de la vista"}	 A wizard to compare and reset views architecture. 	t	\N	\N	f	f	f
18	\N	\N	ir.asset	sequence, id	base	{"en_US": "Asset", "es_419": "Activo"}	This model contributes to two things:\n\n        1. It provides a function returning a list of all file paths declared\n        in a given list of addons (see _get_addon_paths);\n\n        2. It allows to create 'ir.asset' records to add additional directives\n        to certain bundles.\n    	f	\N	\N	f	f	f
19	\N	\N	ir.actions.actions	name	base	{"en_US": "Actions", "es_419": "Acciones"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
20	\N	\N	ir.actions.act_window	name	base	{"en_US": "Action Window", "es_419": "Ventana de acción"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
22	\N	\N	ir.actions.act_window_close	name	base	{"en_US": "Action Window Close", "es_419": "Acción - Cierre de ventana"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
23	\N	\N	ir.actions.act_url	name	base	{"en_US": "Action URL", "es_419": "URL de la acción"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
26	\N	\N	ir.actions.client	name	base	{"en_US": "Client Action", "es_419": "Acción del cliente"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
27	\N	\N	ir.embedded.actions	sequence, id	base	{"en_US": "Embedded Actions", "es_419": "Acciones incrustadas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
30	\N	\N	ir.binary	id	base	{"en_US": "File streaming helper model for controllers", "es_419": "Modelo de ayuda para la transmisión de archivos para controladores"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
32	\N	\N	ir.cron.trigger	id	base	{"en_US": "Triggered actions", "es_419": "Acciones activadas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
33	\N	\N	ir.cron.progress	id	base	{"en_US": "Progress of Scheduled Actions", "es_419": "Progreso de acciones programadas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
34	\N	\N	ir.filters	model_id, name, id desc	base	{"en_US": "Filters", "es_419": "Filtros"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
35	\N	\N	ir.default	id	base	{"en_US": "Default Values", "es_419": "Valores predeterminados"}	 User-defined default values for fields. 	f	\N	\N	f	f	f
36	\N	\N	ir.exports	name	base	{"en_US": "Exports", "es_419": "Exportaciones"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
37	\N	\N	ir.exports.line	id	base	{"en_US": "Exports Line", "es_419": "Línea de exportaciones"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
38	\N	\N	ir.rule	model_id DESC,id	base	{"en_US": "Record Rule", "es_419": "Regla"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
40	\N	\N	ir.autovacuum	id	base	{"en_US": "Automatic Vacuum", "es_419": "Vaciado automático"}	 Helper model to the ``@api.autovacuum`` method decorator. 	f	\N	\N	f	f	f
42	\N	\N	ir.fields.converter	id	base	{"en_US": "Fields Converter", "es_419": "Convertidor de campos"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
69	\N	\N	ir.module.module.dependency	id	base	{"en_US": "Module dependency", "es_419": "Dependencia del módulo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
28	\N	\N	ir.actions.report	name, id	base	{"en_US": "Report Action", "es_419": "Acción de reporte"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
52	\N	\N	ir.qweb.field.many2many	id	base	{"en_US": "Qweb field many2many", "es_419": "Campo Qweb many2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
58	\N	\N	ir.qweb.field.float_time	id	base	{"en_US": "Qweb Field Float Time", "es_419": "Campo Qweb de tiempo flotante"}	 ``float_time`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "01:30").\n\n    Can be used on any numerical field.\n    	f	\N	\N	f	f	f
59	\N	\N	ir.qweb.field.time	id	base	{"en_US": "QWeb Field Time", "es_419": "Campo de tiempo QWeb"}	 ``time`` converter, to display integer or fractional value as\n    human-readable time (e.g. 1.5 as "1:30 AM"). The unit of this value\n    is in hours.\n\n    Can be used on any numerical field between: 0 <= value < 24\n    	f	\N	\N	f	f	f
62	\N	\N	ir.qweb.field.barcode	id	base	{"en_US": "Qweb Field Barcode", "es_419": "Código de barras del campo Qweb"}	 ``barcode`` widget rendering, inserts a data:uri-using image tag in the\n    document. May be overridden by e.g. the website module to generate links\n    instead.\n    	f	\N	\N	f	f	f
66	\N	\N	ir.logging	id DESC	base	{"en_US": "Logging", "es_419": "Registros"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
67	\N	\N	ir.module.category	name	base	{"en_US": "Application", "es_419": "Aplicación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
70	\N	\N	ir.module.module.exclusion	id	base	{"en_US": "Module exclusion", "es_419": "Exclusión del módulo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
71	\N	\N	ir.demo	id	base	{"en_US": "Demo", "es_419": "Demostración"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
72	\N	\N	ir.demo_failure	id	base	{"en_US": "Demo failure", "es_419": "Error en la demostración"}	 Stores modules for which we could not install demo data\n    	t	\N	\N	f	f	f
73	\N	\N	ir.demo_failure.wizard	id	base	{"en_US": "Demo Failure wizard", "es_419": "Asistente para error de datos de demostración"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
74	\N	\N	report.layout	sequence	base	{"en_US": "Report Layout", "es_419": "Diseño del reporte"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
75	\N	\N	report.paperformat	id	base	{"en_US": "Paper Format Config", "es_419": "Configuración del formato de papel"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
76	\N	\N	ir.profile	session desc, id desc	base	{"en_US": "Profiling results", "es_419": "Resultados del análisis de rendimiento de software"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
77	\N	\N	base.enable.profiling.wizard	id	base	{"en_US": "Enable profiling for some time", "es_419": "Habilitar análisis de rendimiento por cierto tiempo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
78	\N	\N	image.mixin	id	base	{"en_US": "Image Mixin", "es_419": "Mixin de imagen"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
79	\N	\N	avatar.mixin	id	base	{"en_US": "Avatar Mixin", "es_419": "Mixin del avatar"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
81	\N	\N	res.country.group	id	base	{"en_US": "Country Group", "es_419": "Grupo del país"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
87	\N	\N	res.partner.title	name	base	{"en_US": "Partner Title", "es_419": "Título del contacto"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
89	\N	\N	res.partner.industry	name	base	{"en_US": "Industry", "es_419": "Industria"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
90	\N	\N	res.bank	name	base	{"en_US": "Bank", "es_419": "Banco"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
91	\N	\N	res.partner.bank	sequence, id	base	{"en_US": "Bank Accounts", "es_419": "Cuentas bancarias"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
92	\N	\N	res.config	id	base	{"en_US": "Config", "es_419": "Configuración"}	 Base classes for new-style configuration items\n\n    Configuration items should inherit from this class, implement\n    the execute method (and optionally the cancel one) and have\n    their view inherit from the related res_config_view_base view.\n    	t	\N	\N	f	f	f
94	\N	\N	res.currency	active desc, name	base	{"en_US": "Currency", "es_419": "Moneda"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
95	\N	\N	res.currency.rate	name desc	base	{"en_US": "Currency Rate", "es_419": "Tasa de cambio"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
98	\N	\N	res.users.log	id desc	base	{"en_US": "Users Log", "es_419": "Registro de usuarios"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
201	\N	\N	mail.guest	id	base	{"en_US": "Guest", "es_419": "Invitado"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
100	\N	\N	res.users.identitycheck	id	base	{"en_US": "Password Check Wizard", "es_419": "Asistente de verificación de contraseñas"}	 Wizard used to re-check the user's credentials (password) and eventually\n    revoke access to his account to every device he has an active session on.\n\n    Might be useful before the more security-sensitive operations, users might be\n    leaving their computer unlocked & unattended. Re-checking credentials mitigates\n    some of the risk of a third party using such an unattended device to manipulate\n    the account.\n    	t	\N	\N	f	f	f
102	\N	\N	change.password.user	id	base	{"en_US": "User, Change Password Wizard", "es_419": "Usuario, asistente de cambio de contraseña"}	 A model to configure users in the change password wizard. 	t	\N	\N	f	f	f
103	\N	\N	change.password.own	id	base	{"en_US": "User, change own password wizard", "es_419": "Usuario, asistente de cambio de contraseña propia"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
104	\N	\N	res.users.apikeys	id	base	{"en_US": "Users API Keys", "es_419": "Claves API de los usuarios"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
105	\N	\N	res.users.apikeys.description	id	base	{"en_US": "API Key Description", "es_419": "Descripción de la clave API"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
108	\N	\N	res.users.deletion	id	base	{"en_US": "Users Deletion Request", "es_419": "Solicitud de eliminación del usario"}	User deletion requests.\n\n    Those requests are logged in a different model to keep a trace of this action and the\n    deletion is done in a CRON. Indeed, removing a user can be a heavy operation on\n    large database (because of create_uid, write_uid on each model, which are not always\n    indexed). This model just remove the users added in the deletion queue, remaining code\n    must deal with other consideration (archiving, blacklist email...).\n    	f	\N	\N	f	f	f
109	\N	\N	res.device.log	id	base	{"en_US": "Device Log", "es_419": "Registro del dispositivo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
110	\N	\N	res.device	last_activity desc	base	{"en_US": "Devices", "es_419": "Dispositivos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
111	\N	\N	decimal.precision	id	base	{"en_US": "Decimal Precision", "es_419": "Precisión decimal"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
112	\N	\N	report.base.report_irmodulereference	id	base	{"en_US": "Module Reference Report (base)", "es_419": "Reporte del módulo de referencia (base)"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
113	\N	\N	base.module.update	id	base	{"en_US": "Update Module", "es_419": "Actualizar módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
114	\N	\N	base.language.install	id	base	{"en_US": "Install Language", "es_419": "Instalar idioma"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
115	\N	\N	base.language.import	id	base	{"en_US": "Language Import", "es_419": "Importar idioma"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
116	\N	\N	base.module.upgrade	id	base	{"en_US": "Upgrade Module", "es_419": "Actualizar módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
118	\N	\N	base.language.export	id	base	{"en_US": "Language Export", "es_419": "Exportar idioma"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
124	\N	\N	auth_totp.wizard	id	base	{"en_US": "2-Factor Setup Wizard", "es_419": "Asistente de la configuración de la autenticación de dos pasos"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
126	\N	\N	base_import.import	id	base	{"en_US": "Base Import", "es_419": "Importación base"}	\n    This model is used to prepare the loading of data coming from a user file.\n\n    Here is the process that is followed:\n\n    #. The user selects a file to import.\n    #. File parsing and mapping suggestion (see "parse_preview" method)\n\n       #. Extract the current model's importable fields tree (see :meth:`get_fields_tree`).\n       #. Read the file (see :meth:`_read_file`) and extract header names and file\n          length (used for batch import).\n       #. Extract headers types from the data preview (10 first line of the file)\n          (see :meth:`_extract_headers_types`).\n       #. Try to find for each header a field to map with (see :meth:`_get_mapping_suggestions`)\n\n          - First check the previously saved mappings between the header name\n            and one of the model's fields.\n          - If no mapping found, try an exact match comparison using fields\n            technical names, labels and user language translated labels.\n          - If nothing found, try a fuzzy match using word distance between\n            header name and fields tachnical names, labels and user language\n            translated labels. Keep only the closest match.\n\n       #. Prepare examples for each columns using the first non null value from each column.\n       #. Send the info back to the UI where the user can modify the suggested mapping.\n    #. Execute the import: There are two import mode with uses the same process. (see :meth:`execute_import`)\n\n       #. Test import: Try to import but rollback the transaction. This allows\n          the check errors during the import process and allow the user to\n          choose import options for the different encountered errors.\n       #. Real import: Try to import the file using the configured mapping and\n          the eventual "error mapping options". If import encounters blocking\n          errors, the transaction is rollbacked and the user is allowed to\n          choose import options for the different errors.\n\n          - Get file data and fields to import into (see :meth:`_convert_import_data`).\n          - Parse date, float and binary data (see :meth:`_parse_import_data`).\n          - Handle multiple mapping -> concatenate char/text/many2many columns\n            mapped on the same field (see :meth:`_handle_multi_mapping`).\n          - Handle fallback values for boolean and selection fields, in case\n            input data does not match any allowed values (see :meth:`_handle_fallback_values`).\n          - Load data (see ir.model "load" method).\n          - Rollback transaction if test mode or if encountered error.\n          - Save mapping if any import is successful to ease later mapping suggestions.\n          - Return import result to the UI (success or errors if any).\n    	t	\N	\N	f	f	f
138	\N	\N	iap.service	id	base	{"en_US": "IAP Service", "es_419": "Servicio de compras dentro de la aplicación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
4	\N	\N	ir.model.fields	name	base	{"en_US": "Fields", "es_419": "Campos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
21	\N	\N	ir.actions.act_window.view	sequence,id	base	{"en_US": "Action Window View", "es_419": "Vista de ventana de acción"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
31	\N	\N	ir.cron	cron_name	base	{"en_US": "Scheduled Actions", "es_419": "Acciones planificadas"}	 Model describing cron jobs (also called actions or tasks).\n    	f	\N	\N	f	f	f
107	\N	\N	res.users.settings	id	base	{"en_US": "User Settings", "es_419": "Ajustes de usuario"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
120	\N	\N	base.partner.merge.automatic.wizard	id	base	{"en_US": "Merge Partner Wizard", "es_419": "Asistente de fusión de contactos"}	\n        The idea behind this wizard is to create a list of potential partners to\n        merge. We use two objects, the first one is the wizard for the end-user.\n        And the second will contain the partner list to merge.\n    	t	\N	\N	f	f	f
14	\N	\N	ir.ui.menu	sequence,id	base	{"en_US": "Menu", "es_419": "Menú"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
117	\N	\N	base.module.uninstall	id	base	{"en_US": "Module Uninstall", "es_419": "Desinstalar módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
131	\N	\N	bus.presence	id	base	{"en_US": "User Presence", "es_419": "Conexión del usuario"}	 User Presence\n        Its status is 'online', 'away' or 'offline'. This model should be a one2one, but is not\n        attached to res_users to avoid database concurrence errors. Since the 'update_presence' method is executed\n        at each poll, if the user have multiple opened tabs, concurrence errors can happend, but are 'muted-logged'.\n    	f	\N	\N	f	f	f
96	\N	\N	res.company	sequence, name	base	{"en_US": "Companies", "es_419": "Empresas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
39	\N	\N	ir.config_parameter	key	base	{"en_US": "System Parameter", "es_419": "Parámetro del sistema"}	Per-database storage of configuration key-value pairs.	f	\N	\N	f	f	f
41	\N	\N	ir.mail_server	sequence, id	base	{"en_US": "Mail Server", "es_419": "Servidor de correo"}	Represents an SMTP server, able to send outgoing emails, with SSL and TLS capabilities.	f	\N	\N	f	f	f
99	\N	\N	res.users	name, login	base	{"en_US": "User", "es_419": "Usuario"}	 Update of res.users class\n        - add a preference about sending emails about notifications\n        - make a new user follow itself\n        - add a welcome message\n        - add suggestion preference\n    	f	\N	\N	f	f	f
24	\N	\N	ir.actions.server	sequence,name	base	{"en_US": "Server Action", "es_419": "Acción del servidor"}	 Add SMS option in server actions. 	f	\N	\N	f	f	f
139	\N	\N	mail.alias	alias_model_id, alias_name	base	{"en_US": "Email Aliases", "es_419": "Alias de correo"}	A Mail Alias is a mapping of an email address with a given Odoo Document\n       model. It is used by Odoo's mail gateway when processing incoming emails\n       sent to the system. If the recipient address (To) of the message matches\n       a Mail Alias, the message will be either processed following the rules\n       of that alias. If the message is a reply it will be attached to the\n       existing discussion on the corresponding record, otherwise a new\n       record of the corresponding model will be created.\n\n       This is meant to be used in combination with a catch-all email configuration\n       on the company's mail server, so that as soon as a new mail.alias is\n       created, it becomes immediately usable and Odoo will accept email for it.\n     	f	\N	\N	f	f	f
140	\N	\N	mail.alias.domain	sequence ASC, id ASC	base	{"en_US": "Email Domain", "es_419": "Dominio de correo electrónico"}	 Model alias domains, now company-specific. Alias domains are email\n    domains used to receive emails through catchall and bounce aliases, as\n    well as using mail.alias records to redirect email replies.\n\n    This replaces ``mail.alias.domain`` configuration parameter use until v16.\n    	f	\N	\N	f	f	f
143	\N	\N	mail.activity.mixin	id	base	{"en_US": "Activity Mixin", "es_419": "Mixin de la actividad"}	 Mail Activity Mixin is a mixin class to use if you want to add activities\n    management on a model. It works like the mail.thread mixin. It defines\n    an activity_ids one2many field toward activities using res_id and res_model_id.\n    Various related / computed fields are also added to have a global status of\n    activities on documents.\n\n    Activities come with a new JS widget for the form view. It is integrated in the\n    Chatter widget although it is a separate widget. It displays activities linked\n    to the current record and allow to schedule, edit and mark done activities.\n\n    There is also a kanban widget defined. It defines a small widget to integrate\n    in kanban vignettes. It allow to manage activities directly from the kanban\n    view. Use widget="kanban_activity" on activitiy_ids field in kanban view to\n    use it.\n\n    Some context keys allow to control the mixin behavior. Use those in some\n    specific cases like import\n\n     * ``mail_activity_automation_skip``: skip activities automation; it means\n       no automated activities will be generated, updated or unlinked, allowing\n       to save computation and avoid generating unwanted activities;\n    	f	\N	\N	f	t	f
144	\N	\N	mail.alias.mixin.optional	id	base	{"en_US": "Email Aliases Mixin (light)", "es_419": "Mixin de los alias de correo (claro)"}	 A mixin for models that handles underlying 'mail.alias' records to use\n    the mail gateway. Field is not mandatory and its creation is done dynamically\n    based on given 'alias_name', allowing to gradually populate the alias table\n    without having void aliases as when used with an inherits-like implementation.\n    	f	\N	\N	f	f	f
145	\N	\N	mail.alias.mixin	id	base	{"en_US": "Email Aliases Mixin", "es_419": "Mixin de los alias de correo"}	 A mixin for models that inherits mail.alias to have a one-to-one relation\n    between the model and its alias. 	f	\N	\N	f	f	f
146	\N	\N	mail.render.mixin	id	base	{"en_US": "Mail Render Mixin", "es_419": "Mixin de renderización de correo"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
147	\N	\N	mail.composer.mixin	id	base	{"en_US": "Mail Composer Mixin", "es_419": "Mixin del redactor de correo"}	 Mixin used to edit and render some fields used when sending emails or\n    notifications based on a mail template.\n\n    Main current purpose is to hide details related to subject and body computation\n    and rendering based on a mail.template. It also give the base tools to control\n    who is allowed to edit body, notably when dealing with templating language\n    like inline_template or qweb.\n\n    It is meant to evolve in a near future with upcoming support of qweb and fine\n    grain control of rendering access.\n    	f	\N	\N	f	f	f
149	\N	\N	mail.thread.blacklist	id	base	{"en_US": "Mail Blacklist mixin", "es_419": "Mixin de exclusión de correos"}	 Mixin that is inherited by all model with opt out. This mixin stores a normalized\n    email based on primary_email field.\n\n    A normalized email is considered as :\n        - having a left part + @ + a right part (the domain can be without '.something')\n        - being lower case\n        - having no name before the address. Typically, having no 'Name <>'\n    Ex:\n        - Formatted Email : 'Name <NaMe@DoMaIn.CoM>'\n        - Normalized Email : 'name@domain.com'\n\n    The primary email field can be specified on the parent model, if it differs from the default one ('email')\n    The email_normalized field can than be used on that model to search quickly on emails (by simple comparison\n    and not using time consuming regex anymore).\n\n    Using this email_normalized field, blacklist status is computed.\n\n    Mail Thread capabilities are required for this mixin. 	f	\N	\N	t	f	t
167	\N	\N	mail.message.translation	id	base	{"en_US": "Message Translation", "es_419": "Traducción de mensajes"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
207	\N	\N	mail.blacklist.remove	id	base	{"en_US": "Remove email from blacklist wizard", "es_419": "Asistente para eliminar los correos electrónicos de la lista de exclusión"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
150	\N	\N	mail.thread.cc	id	base	{"en_US": "Email CC management", "es_419": "Gestión del CC del correo electrónico"}	 mail_thread model is meant to be inherited by any model that needs to\n        act as a discussion topic on which messages can be attached. Public\n        methods are prefixed with ``message_`` in order to avoid name\n        collisions with methods of the models that will inherit from this class.\n\n        ``mail.thread`` defines fields used to handle and display the\n        communication history. ``mail.thread`` also manages followers of\n        inheriting classes. All features and expected behavior are managed\n        by mail.thread. Widgets has been designed for the 7.0 and following\n        versions of Odoo.\n\n        Inheriting classes are not required to implement any method, as the\n        default implementation will work for any model. However it is common\n        to override at least the ``message_new`` and ``message_update``\n        methods (calling ``super``) to add model-specific behavior at\n        creation and update of a thread when processing incoming emails.\n\n        Options:\n            - _mail_flat_thread: if set to True, all messages without parent_id\n                are automatically attached to the first message posted on the\n                resource. If set to False, the display of Chatter is done using\n                threads, and no parent_id is automatically set.\n\n    MailThread features can be somewhat controlled through context keys :\n\n     - ``mail_create_nosubscribe``: at create or message_post, do not subscribe\n       uid to the record thread\n     - ``mail_create_nolog``: at create, do not log the automatic '<Document>\n       created' message\n     - ``mail_notrack``: at create and write, do not perform the value tracking\n       creating messages\n     - ``tracking_disable``: at create and write, perform no MailThread features\n       (auto subscription, tracking, post, ...)\n     - ``mail_notify_force_send``: if less than 50 email notifications to send,\n       send them directly instead of using the queue; True by default\n    	f	\N	\N	t	f	f
151	\N	\N	mail.thread.main.attachment	id	base	{"en_US": "Mail Main Attachment management", "es_419": "Correo principal para gestión de archivos adjuntos"}	 Mixin that adds main attachment support to the MailThread class. 	f	\N	\N	t	f	f
152	\N	\N	mail.tracking.duration.mixin	id	base	{"en_US": "Mixin to compute the time a record has spent in each value a many2one field can take", "es_419": "Mixin para calcular el tiempo que ha pasado un registro en cada valor que puede tomar un campo many2one"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
153	\N	\N	template.reset.mixin	id	base	{"en_US": "Template Reset Mixin", "es_419": "Mixin de restablecimiento de plantilla"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
156	\N	\N	mail.activity.type	sequence, id	base	{"en_US": "Activity Type", "es_419": "Tipo de actividad"}	 Activity Types are used to categorize activities. Each type is a different\n    kind of activity e.g. call, mail, meeting. An activity can be generic i.e.\n    available for all models using activities; or specific to a model in which\n    case res_model field should be used. 	f	\N	\N	f	f	f
157	\N	\N	mail.activity	date_deadline ASC, id ASC	base	{"en_US": "Activity", "es_419": "Actividad"}	 An actual activity to perform. Activities are linked to\n    documents using res_id and res_model_id fields. Activities have a deadline\n    that can be used in kanban view to display a status. Once done activities\n    are unlinked and a message is posted. This message has a new activity_type_id\n    field that indicates the activity linked to the message. 	f	\N	\N	f	f	f
158	\N	\N	mail.activity.plan	id DESC	base	{"en_US": "Activity Plan", "es_419": "Plan de actividad"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
159	\N	\N	mail.activity.plan.template	sequence,id	base	{"en_US": "Activity plan template", "es_419": "Plantilla del plan de actividad"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
160	\N	\N	mail.blacklist	id	base	{"en_US": "Mail Blacklist", "es_419": "Exclusión del correo "}	 Model of blacklisted email addresses to stop sending emails.	f	\N	\N	t	f	f
162	\N	\N	mail.gateway.allowed	id	base	{"en_US": "Mail Gateway Allowed", "es_419": "Puerta de enlace de correo permitida"}	List of trusted email address which won't have the quota restriction.\n\n    The incoming emails have a restriction of the number of records they can\n    create with alias, defined by the 2 systems parameters;\n    - mail.gateway.loop.minutes\n    - mail.gateway.loop.threshold\n\n    But we might have some legit use cases for which we want to receive a ton of emails\n    from an automated-source. This model stores those trusted source and this restriction\n    won't apply to them.\n    	f	\N	\N	f	f	f
163	\N	\N	mail.link.preview	id	base	{"en_US": "Store link preview data", "es_419": "Almacenar los datos de la vista previa del enlace"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
164	\N	\N	mail.message.reaction	id desc	base	{"en_US": "Message Reaction", "es_419": "Reacción de mensaje"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
165	\N	\N	mail.message.schedule	scheduled_datetime DESC, id DESC	base	{"en_US": "Scheduled Messages", "es_419": "Mensajes programados"}	 Mail message notification schedule queue.\n\n    This model is used to store the mail messages scheduled. So we can\n    delay the sending of the notifications. A scheduled date field already\n    exists on the <mail.mail> but it does not allow us to delay the sending\n    of the <bus.bus> notifications.\n    	f	\N	\N	f	f	f
166	\N	\N	mail.message.subtype	sequence, id	base	{"en_US": "Message subtypes", "es_419": "Subtipos de mensaje"}	 Class holding subtype definition for messages. Subtypes allow to tune\n        the follower subscription, allowing only some subtypes to be pushed\n        on the Wall. 	f	\N	\N	f	f	f
154	\N	\N	fetchmail.server	priority	base	{"en_US": "Incoming Mail Server", "es_419": "Servidor de correos entrantes"}	Incoming POP/IMAP mail server account	f	\N	\N	f	f	f
169	\N	\N	mail.mail	id desc	base	{"en_US": "Outgoing Mails", "es_419": "Correos salientes"}	 Model holding RFC2822 email messages to send. This model also provides\n        facilities to queue and send new email messages.  	f	\N	\N	f	f	f
170	\N	\N	mail.push	id	base	{"en_US": "Push Notifications", "es_419": "Notificaciones push"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
171	\N	\N	mail.push.device	id	base	{"en_US": "Push Notification Device", "es_419": "Dispositivo de notificación push"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
172	\N	\N	mail.scheduled.message	id	base	{"en_US": "Scheduled Message", "es_419": "Mensaje programado"}	 Scheduled message model (holds post values generated by the composer to delay the\n    posting of the message). Different from mail.message.schedule that posts the message but\n    delays the notification process.\n\n    Todo: when adding support for scheduling messages in mass_mail mode, could add a reference to\n    the "parent" composer (by making 'mail.compose.message' not transient anymore). This reference\n    could then be used to cancel every message scheduled "at the same time" (from one composer),\n    and to get the static 'notification parameters' (mail_server_id, auto_delete,...) instead of\n    duplicating them for each scheduled message.\n    Currently as scheduling is allowed in monocomment only, we don't have duplicates and we only\n    have static notification parameters, but some will become dynamic when adding mass_mail support\n    such as 'email_from' and 'force_email_lang'.\n    	f	\N	\N	f	f	f
173	\N	\N	mail.tracking.value	id DESC	base	{"en_US": "Mail Tracking Value", "es_419": "Valor de seguimiento de correo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
174	\N	\N	mail.template	user_id,name,id	base	{"en_US": "Email Templates", "es_419": "Plantillas de correo electrónico"}	Templates for sending email	f	\N	\N	f	f	f
175	\N	\N	mail.ice.server	id	base	{"en_US": "ICE server", "es_419": "Servidor ICE"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
176	\N	\N	mail.canned.response	id desc	base	{"en_US": "Canned Response", "es_419": "Respuesta predefinida"}	\n    Canned Response: content that will automatically replace the shortcut of your choosing. This content can still be adapted before sending your message.\n    	f	\N	\N	f	f	f
178	\N	\N	res.users.settings.volumes	id	base	{"en_US": "User Settings Volumes", "es_419": "Ajustes de volumen del usuario"}	 Represents the volume of the sound that the user of user_setting_id will receive from partner_id. 	f	\N	\N	f	f	f
196	\N	\N	discuss.channel.member	id	base	{"en_US": "Channel Member", "es_419": "Miembro del canal"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
197	\N	\N	discuss.channel.rtc.session	id	base	{"en_US": "Mail RTC session", "es_419": "Sesión de comunicación en tiempo real por correo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
199	\N	\N	discuss.gif.favorite	id	base	{"en_US": "Save favorite GIF from Tenor API", "es_419": "Marcar un GIF de Tenor API como favorito "}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
200	\N	\N	discuss.voice.metadata	id	base	{"en_US": "Metadata for voice attachments", "es_419": "Metadatos para los archivos adjuntos de voz"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
195	\N	\N	publisher_warranty.contract	id	base	{"en_US": "Publisher Warranty Contract", "es_419": "Contrato de garantía del editor"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
168	\N	\N	mail.message	id desc	base	{"en_US": "Message", "es_419": "Mensaje"}	 Override MailMessage class in order to add a new type: SMS messages.\n    Those messages comes with their own notification method, using SMS\n    gateway. 	f	\N	\N	f	f	f
208	\N	\N	mail.compose.message	id	base	{"en_US": "Email composition wizard", "es_419": "Asistente de redacción de correo electrónico"}	 Generic message composition wizard. You may inherit from this wizard\n        at model and view levels to provide specific features.\n\n        The behavior of the wizard depends on the composition_mode field:\n        - 'comment': post on a record.\n        - 'mass_mail': wizard in mass mailing mode where the mail details can\n            contain template placeholders that will be merged with actual data\n            before being sent to each recipient.\n    	t	\N	\N	f	f	f
209	\N	\N	mail.activity.schedule	id	base	{"en_US": "Activity schedule plan Wizard", "es_419": "Asistente para planificar actividades"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
210	\N	\N	mail.resend.message	id	base	{"en_US": "Email resend wizard", "es_419": "Asistente de reenvío de correo electrónico"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
211	\N	\N	mail.resend.partner	id	base	{"en_US": "Partner with additional information for mail resend", "es_419": "Contacto con información adicional para el reenvío del correo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
212	\N	\N	mail.template.preview	id	base	{"en_US": "Email Template Preview", "es_419": "Vista previa de la plantilla del correo electrónico"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
213	\N	\N	mail.template.reset	id	base	{"en_US": "Mail Template Reset", "es_419": "Restablecer plantilla de correo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
214	\N	\N	mail.wizard.invite	id	base	{"en_US": "Invite wizard", "es_419": "Asistente de invitación"}	 Wizard to invite partners (or channels) and make them followers. 	t	\N	\N	f	f	f
45	\N	\N	ir.qweb.field.integer	id	base	{"en_US": "Qweb Field Integer", "es_419": "Campo Qweb entero"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
46	\N	\N	ir.qweb.field.float	id	base	{"en_US": "Qweb Field Float", "es_419": "Campo Qweb flotante"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
47	\N	\N	ir.qweb.field.date	id	base	{"en_US": "Qweb Field Date", "es_419": "Campo Qweb de fecha"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
48	\N	\N	ir.qweb.field.datetime	id	base	{"en_US": "Qweb Field Datetime", "es_419": "Campo Qweb de fecha y hora"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
49	\N	\N	ir.qweb.field.text	id	base	{"en_US": "Qweb Field Text", "es_419": "Campo Qweb de texto"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
50	\N	\N	ir.qweb.field.selection	id	base	{"en_US": "Qweb Field Selection", "es_419": "Campo Qweb de selección"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
329	\N	\N	html.field.history.mixin	id	base	{"en_US": "Field html History", "es_419": "Historial del campo html"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
51	\N	\N	ir.qweb.field.many2one	id	base	{"en_US": "Qweb Field Many to One", "es_419": "Campo Qweb Many2One"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
54	\N	\N	ir.qweb.field.html	id	base	{"en_US": "Qweb Field HTML", "es_419": "Campo Qweb HTML"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
57	\N	\N	ir.qweb.field.monetary	id	base	{"en_US": "Qweb Field Monetary", "es_419": "Campo monetario Qweb"}	 ``monetary`` converter, has a mandatory option\n    ``display_currency`` only if field is not of type Monetary.\n    Otherwise, if we are in presence of a monetary field, the field definition must\n    have a currency_field attribute set.\n\n    The currency is used for formatting *and rounding* of the float value. It\n    is assumed that the linked res_currency has a non-empty rounding value and\n    res.currency's ``round`` method is used to perform rounding.\n\n    .. note:: the monetary converter internally adds the qweb context to its\n              options mapping, so that the context is available to callees.\n              It's set under the ``_values`` key.\n    	f	\N	\N	f	f	f
60	\N	\N	ir.qweb.field.duration	id	base	{"en_US": "Qweb Field Duration", "es_419": "Campo Qweb de duración"}	 ``duration`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "1 hour 30 minutes").\n\n    Can be used on any numerical field.\n\n    Has an option ``unit`` which can be one of ``second``, ``minute``,\n    ``hour``, ``day``, ``week`` or ``year``, used to interpret the numerical\n    field value before converting it. By default use ``second``.\n\n    Has an option ``round``. By default use ``second``.\n\n    Has an option ``digital`` to display 01:00 instead of 1 hour\n\n    Sub-second values will be ignored.\n    	f	\N	\N	f	f	f
63	\N	\N	ir.qweb.field.contact	id	base	{"en_US": "Qweb Field Contact", "es_419": "Campo Qweb de contacto"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
64	\N	\N	ir.qweb.field.qweb	id	base	{"en_US": "Qweb Field qweb", "es_419": "Qweb del campo qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	f	\N	\N	f	f	f
43	\N	\N	ir.qweb	id	base	{"en_US": "Qweb", "es_419": "Qweb"}	 IrQWeb object for rendering editor stuff\n    	f	\N	\N	f	f	f
16	\N	\N	ir.ui.view	priority,name,id	base	{"en_US": "View", "es_419": "Vista"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
330	\N	\N	web_editor.assets	id	base	{"en_US": "Assets Utils", "es_419": "Utilidades de activos"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
331	\N	\N	web_editor.converter.test	id	base	{"en_US": "Web Editor Converter Test", "es_419": "Prueba de convertidor del editor web"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
332	\N	\N	web_editor.converter.test.sub	id	base	{"en_US": "Web Editor Converter Subtest", "es_419": "Subprueba de convertidor del editor web"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
333	\N	\N	bg.job	priority, create_date desc	base	{"en_US": "Background Job"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
334	\N	\N	base.bg	id	base	{"en_US": "Background Job Mixin"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
335	\N	\N	base.module.install.request	id	base	{"en_US": "Module Activation Request", "es_419": "Solicitud de activación de módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
65	\N	\N	ir.http	id	base	{"en_US": "HTTP Routing", "es_419": "Enrutamiento HTTP"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
336	\N	\N	base.module.install.review	id	base	{"en_US": "Module Activation Review", "es_419": "Revisión de la activación del módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
337	\N	\N	google.gmail.mixin	id	base	{"en_US": "Google Gmail Mixin", "es_419": "Mixin de Gmail de Google"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
339	\N	\N	mail.bot	id	base	{"en_US": "Mail Bot", "es_419": "Bot de correo electrónico"}	 The base model, which is implicitly inherited by all models. 	f	\N	\N	f	f	f
340	\N	\N	phone.blacklist	id	base	{"en_US": "Phone Blacklist", "es_419": "Lista de exclusión de números telefónicos"}	 Blacklist of phone numbers. Used to avoid sending unwanted messages to people. 	f	\N	\N	t	f	f
341	\N	\N	mail.thread.phone	id	base	{"en_US": "Phone Blacklist Mixin", "es_419": "Mixin de lista de exclusión de teléfonos"}	 Purpose of this mixin is to offer two services\n\n      * compute a sanitized phone number based on _phone_get_number_fields.\n        It takes first sanitized value, trying each field returned by the\n        method (see ``BaseModel._phone_get_number_fields()´´ for more details\n        about the usage of this method);\n      * compute blacklist state of records. It is based on phone.blacklist\n        model and give an easy-to-use field and API to manipulate blacklisted\n        records;\n\n    Main API methods\n\n      * ``_phone_set_blacklisted``: set recordset as blacklisted;\n      * ``_phone_reset_blacklisted``: reactivate recordset (even if not blacklisted\n        this method can be called safely);\n    	f	\N	\N	t	f	f
342	\N	\N	phone.blacklist.remove	id	base	{"en_US": "Remove phone from blacklist", "es_419": "Eliminar teléfono de la lista de exclusión"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
343	\N	\N	privacy.log	id	base	{"en_US": "Privacy Log", "es_419": "Registro de privacidad"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
344	\N	\N	privacy.lookup.wizard	id	base	{"en_US": "Privacy Lookup Wizard", "es_419": "Asistente de búsqueda de privacidad"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
345	\N	\N	privacy.lookup.wizard.line	id	base	{"en_US": "Privacy Lookup Wizard Line", "es_419": "Línea de asistente de búsqueda de privacidad"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
346	\N	\N	extract.mixin	id	base	{"en_US": "Base class to extract data from documents", "es_419": "Clase base para extraer datos de documentos"}	 Base model to inherit from to add extract functionality to a model. 	f	\N	\N	t	f	f
198	\N	\N	discuss.channel	id	base	{"en_US": "Discussion Channel", "es_419": "Canal de conversaciones"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	t	f	f
347	\N	\N	db.configuration	id	base	{"en_US": "db.configuration"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
29	\N	\N	ir.attachment	id desc	base	{"en_US": "Attachment", "es_419": "Archivos adjuntos"}	Attachments are used to link binary files or url to any openerp document.\n\n    External attachment storage\n    ---------------------------\n\n    The computed field ``datas`` is implemented using ``_file_read``,\n    ``_file_write`` and ``_file_delete``, which can be overridden to implement\n    other storage engines. Such methods should check for other location pseudo\n    uri (example: hdfs://hadoopserver).\n\n    The default implementation is the file:dirname location that stores files\n    on the local filesystem using name based on their sha1 hash\n    	f	\N	\N	f	f	f
352	\N	\N	sms.template	id	base	{"en_US": "SMS Templates", "es_419": "Plantillas de SMS"}	Templates for sending SMS	f	\N	\N	f	f	f
3	\N	\N	ir.model	is_mail_thread DESC, name ASC	base	{"en_US": "Models", "es_419": "Modelos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
161	\N	\N	mail.followers	id	base	{"en_US": "Document Followers", "es_419": "Seguidores del documento"}	 mail_followers holds the data related to the follow mechanism inside\n    Odoo. Partners can choose to follow documents (records) of any kind\n    that inherits from mail.thread. Following documents allow to receive\n    notifications for new messages. A subscription is characterized by:\n\n    :param: res_model: model of the followed objects\n    :param: res_id: ID of resource (may be 0 for every objects)\n    	f	\N	\N	f	f	f
351	\N	\N	sms.sms	id DESC	base	{"en_US": "Outgoing SMS", "es_419": "SMS salientes"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
148	\N	\N	mail.thread	id	base	{"en_US": "Email Thread", "es_419": "Hilo de correos"}	 mail_thread model is meant to be inherited by any model that needs to\n        act as a discussion topic on which messages can be attached. Public\n        methods are prefixed with ``message_`` in order to avoid name\n        collisions with methods of the models that will inherit from this class.\n\n        ``mail.thread`` defines fields used to handle and display the\n        communication history. ``mail.thread`` also manages followers of\n        inheriting classes. All features and expected behavior are managed\n        by mail.thread. Widgets has been designed for the 7.0 and following\n        versions of Odoo.\n\n        Inheriting classes are not required to implement any method, as the\n        default implementation will work for any model. However it is common\n        to override at least the ``message_new`` and ``message_update``\n        methods (calling ``super``) to add model-specific behavior at\n        creation and update of a thread when processing incoming emails.\n\n        Options:\n            - _mail_flat_thread: if set to True, all messages without parent_id\n                are automatically attached to the first message posted on the\n                resource. If set to False, the display of Chatter is done using\n                threads, and no parent_id is automatically set.\n\n    MailThread features can be somewhat controlled through context keys :\n\n     - ``mail_create_nosubscribe``: at create or message_post, do not subscribe\n       uid to the record thread\n     - ``mail_create_nolog``: at create, do not log the automatic '<Document>\n       created' message\n     - ``mail_notrack``: at create and write, do not perform the value tracking\n       creating messages\n     - ``tracking_disable``: at create and write, perform no MailThread features\n       (auto subscription, tracking, post, ...)\n     - ``mail_notify_force_send``: if less than 50 email notifications to send,\n       send them directly instead of using the queue; True by default\n    	f	\N	\N	t	f	f
155	\N	\N	mail.notification	id	base	{"en_US": "Message Notifications", "es_419": "Notificaciones de mensajes"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
353	\N	\N	sms.tracker	id	base	{"en_US": "Link SMS to mailing/sms tracking models", "es_419": "Vincula SMS a los modelos de seguimiento de correo y mensajes de texto"}	Relationship between a sent SMS and tracking records such as notifications and traces.\n\n    This model acts as an extension of a `mail.notification` or a `mailing.trace` and allows to\n    update those based on the SMS provider responses both at sending and when later receiving\n    sent/delivery reports (see `SmsController`).\n    SMS trackers are supposed to be created manually when necessary, and tied to their related\n    SMS through the SMS UUID field. (They are not tied to the SMS records directly as those can\n    be deleted when sent).\n\n    Note: Only admins/system user should need to access (a fortiori modify) these technical\n      records so no "sudo" is used nor should be required here.\n    	f	\N	\N	f	f	f
354	\N	\N	sms.account.code	id	base	{"en_US": "SMS Account Verification Code Wizard", "es_419": "Asistente para código de verificación para cuenta de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
355	\N	\N	sms.account.phone	id	base	{"en_US": "SMS Account Registration Phone Number Wizard", "es_419": "Asistente de registro de número de teléfono para cuenta de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
356	\N	\N	sms.account.sender	id	base	{"en_US": "SMS Account Sender Name Wizard", "es_419": "Asistente para nombre de remitente para cuenta de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
357	\N	\N	sms.composer	id	base	{"en_US": "Send SMS Wizard", "es_419": "Asistente de envío de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
358	\N	\N	sms.resend.recipient	id	base	{"en_US": "Resend Notification", "es_419": "Reenviar notificación"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
359	\N	\N	sms.resend	id	base	{"en_US": "SMS Resend", "es_419": "Reenviar SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
360	\N	\N	sms.template.preview	id	base	{"en_US": "SMS Template Preview", "es_419": "Previsualización de la plantilla de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
361	\N	\N	sms.template.reset	id	base	{"en_US": "SMS Template Reset", "es_419": "Restablecer las plantillas de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
363	\N	\N	snailmail.letter.format.error	id	base	{"en_US": "Format Error Sending a Snailmail Letter", "es_419": "Error de formato al enviar una carta por correo postal"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
362	\N	\N	snailmail.letter	id	base	{"en_US": "Snailmail Letter", "es_419": "Carta de correo postal"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class user(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	\N	\N	f	f	f
364	\N	\N	snailmail.letter.missing.required.fields	id	base	{"en_US": "Update address of partner", "es_419": "Actualice la dirección del contacto"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	t	\N	\N	f	f	f
\.


--
-- Data for Name: ir_model_access; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_access (id, model_id, group_id, create_uid, write_uid, name, active, perm_read, perm_write, perm_create, perm_unlink, create_date, write_date) FROM stdin;
1	111	4	1	1	decimal.precision configuration	t	t	t	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
2	29	1	1	1	ir_attachment group_user	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
3	29	\N	1	1	ir_attachment group_portal_public	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
4	31	4	1	1	ir_cron group_cron	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
5	33	4	1	1	ir_cron_progress group_cron	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
6	32	4	1	1	ir_cron_trigger group_cron	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
7	36	8	1	1	ir_exports group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
8	37	1	1	1	ir_exports_line group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
9	3	2	1	1	ir_model group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
10	7	2	1	1	ir_model_constraint group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
11	8	2	1	1	ir_model_relation group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
12	5	\N	1	1	ir_model_inherit nobody	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
13	9	2	1	1	ir_model_access_group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
14	10	2	1	1	ir_model_data group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
15	4	2	1	1	ir_model_fields group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
16	6	2	1	1	ir_model_fields_selection group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
17	3	1	1	1	ir_model_all	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
18	10	1	1	1	ir_model_data user	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
19	4	1	1	1	ir_model_fields all	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
20	6	1	1	1	ir_model_fields_selection all	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
21	67	2	1	1	ir_module_category group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
22	68	4	1	1	ir_module_module group_user	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
23	69	4	1	1	ir_module_module_dependency group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
24	70	4	1	1	ir_module_module_exclusion group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
25	38	2	1	1	ir_rule group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
26	12	1	1	1	ir_sequence group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
27	12	4	1	1	ir_sequence group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
28	13	1	1	1	ir_sequence_date_range group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
29	13	4	1	1	ir_sequence_date_range group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
30	14	1	1	1	ir_ui_menu group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
31	14	4	1	1	ir_ui_menu group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
32	16	\N	1	1	ir_ui_view group_user	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
33	16	4	1	1	ir_ui_view group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
34	17	4	1	1	reset_view_arch_wizard group_system	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
35	15	4	1	1	ir_ui_view_custom_group_user	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
36	35	\N	1	1	ir_default all	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
37	35	1	1	1	ir_default group_user	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
38	35	4	1	1	ir_default group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
39	96	2	1	1	res_company group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
40	96	11	1	1	res_company group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
41	96	10	1	1	res_company group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
42	96	1	1	1	res_company group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
43	80	11	1	1	res_country group_user_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
44	80	10	1	1	res_country group_user_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
45	80	1	1	1	res_country group_user_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
46	82	11	1	1	res_country_state group_user_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
47	82	10	1	1	res_country_state group_user_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
48	82	1	1	1	res_country_state group_user_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
49	81	11	1	1	res_country_group group_user_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
50	81	10	1	1	res_country_group group_user_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
51	81	1	1	1	res_country_group group_user_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
52	80	9	1	1	res_country group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
53	80	4	1	1	res_country_group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
54	82	9	1	1	res_country_state group_user	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
55	81	9	1	1	res_country_group group_user	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
56	94	11	1	1	res_currency group_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
57	94	10	1	1	res_currency group_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
58	94	1	1	1	res_currency group_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
59	95	11	1	1	res_currency_rate group_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
60	95	10	1	1	res_currency_rate group_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
61	95	1	1	1	res_currency_rate group_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
62	94	4	1	1	res_currency group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
63	95	4	1	1	res_currency_rate group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
64	97	2	1	1	res_groups group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
65	97	1	1	1	res_groups group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
66	83	11	1	1	res_lang group_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
67	83	10	1	1	res_lang group_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
68	83	1	1	1	res_lang group_all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
69	83	4	1	1	res_lang group_user	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
70	88	11	1	1	res_partner group_public	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
71	88	10	1	1	res_partner group_portal	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
72	88	9	1	1	res_partner group_partner_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
73	88	1	1	1	res_partner group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
74	91	1	1	1	res_partner_bank group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
75	91	9	1	1	res_partner_bank group_partner_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
76	86	1	1	1	res_partner_category group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
77	86	9	1	1	res_partner_category group_partner_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
78	89	1	1	1	res_partner_industry group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
79	89	4	1	1	res_partner_industry group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
80	87	9	1	1	res_partner_title group_partner_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
81	87	1	1	1	res_partner_title group_user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
82	99	11	1	1	res_users all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
83	99	10	1	1	res_users all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
84	99	1	1	1	res_users all	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
85	99	2	1	1	res_users group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
86	108	\N	1	1	res_users_deletion all	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
87	108	2	1	1	res_users_deletion group_erp_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
88	98	4	1	1	res_users_log_all	t	t	f	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
89	100	1	1	1	id check employees	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
90	100	10	1	1	id check portal	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
91	104	1	1	1	API keys access employees	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
92	104	10	1	1	API keys access portal	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
93	105	1	1	1	API key wizard employees	t	t	f	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
94	105	10	1	1	API key wizard	t	t	f	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
95	106	1	1	1	API key result employees	t	t	f	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
96	107	\N	1	1	res.users.settings	t	f	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
97	107	1	1	1	res.users.settings	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
98	18	4	1	1	ir_asset_group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
99	19	4	1	1	ir_actions_group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
100	20	4	1	1	ir_actions_act_window_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
101	22	4	1	1	ir_actions_act_window_close_group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
102	28	4	1	1	ir_actions_report_group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
103	25	4	1	1	ir_actions_todo group system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
104	21	4	1	1	ir_actions_act_window_view_group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
105	23	4	1	1	ir_actions_act_url_group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
106	24	4	1	1	ir_actions_server_group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
107	27	1	1	1	ir_embedded_actions_group_user	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
108	26	4	1	1	ir_actions_client all	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
109	90	4	1	1	res_bank_group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
110	90	9	1	1	res_bank_group_partner_manager	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
111	90	1	1	1	res_bank user	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
112	34	2	1	1	ir_filters all	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
113	34	1	1	1	ir_filters all	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
114	34	10	1	1	ir_filters all	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
115	34	11	1	1	ir_filters all	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
116	39	4	1	1	ir_config_parameter_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
117	41	4	1	1	ir_mail_server	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
118	66	2	1	1	ir_logging admin	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
119	75	1	1	1	ir_actions_report_paperformat group_portal	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
120	75	4	1	1	ir_actions_report_paperformat group_system	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
121	74	1	1	1	access_report_layout	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
122	11	4	1	1	access.wizard.ir.model.menu.create	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
123	17	2	1	1	access.reset.view.arch.wizard	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
124	71	4	1	1	access.ir.demo	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
125	72	4	1	1	access.ir.demo_failure	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
126	73	4	1	1	access.ir.demo_failure.wizard	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
127	92	4	1	1	access.res.config	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
128	93	4	1	1	access.res.config.settings	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
129	101	2	1	1	access.change.password.wizard	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
130	102	2	1	1	access.change.password.user	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
131	103	1	1	1	access.change.password.own	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
132	113	4	1	1	access.base.module.update	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
133	114	4	1	1	access.base.language.install	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
134	115	4	1	1	access.base.language.import	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
135	116	4	1	1	access.base.module.upgrade	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
136	117	4	1	1	access.base.module.uninstall	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
137	118	1	1	1	access.base.language.export	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
138	119	9	1	1	access.base.partner.merge.line	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
139	120	9	1	1	access.base.partner.merge.automatic.wizard	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
140	76	4	1	1	ir_profile	t	t	t	t	t	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
141	77	4	1	1	access.base.enable.profiling.wizard	t	t	t	t	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
142	110	1	1	1	access_res_device	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
143	109	1	1	1	access_res_device_log	t	t	f	f	f	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
144	122	4	1	1	access.base.document.layout	t	t	t	t	f	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188
145	124	1	1	1	auth_totp wizard access rules	t	t	t	t	t	2026-01-19 17:38:34.241839	2026-01-19 17:38:34.241839
146	123	1	1	1	TOTP Device access employees	t	t	f	f	f	2026-01-19 17:38:34.241839	2026-01-19 17:38:34.241839
147	123	10	1	1	TOTP Device access portal	t	t	f	f	f	2026-01-19 17:38:34.241839	2026-01-19 17:38:34.241839
148	125	1	1	1	base.import.mapping	t	t	t	t	t	2026-01-19 17:38:34.53603	2026-01-19 17:38:34.53603
149	126	1	1	1	access.base_import.import	t	t	t	t	f	2026-01-19 17:38:34.53603	2026-01-19 17:38:34.53603
150	127	4	1	1	access.base.import.module	t	t	t	t	f	2026-01-19 17:38:34.934808	2026-01-19 17:38:34.934808
151	129	\N	1	1	bus.bus public	t	f	f	f	f	2026-01-19 17:38:35.107472	2026-01-19 17:38:35.107472
152	131	1	1	1	bus.presence	t	t	t	t	t	2026-01-19 17:38:35.107472	2026-01-19 17:38:35.107472
153	131	10	1	1	bus.presence	t	t	t	t	t	2026-01-19 17:38:35.107472	2026-01-19 17:38:35.107472
154	134	4	1	1	access_web_tour_tour_admin	t	t	t	t	t	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
155	134	1	1	1	access_web_tour_tour_readonly	t	t	f	f	f	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
156	135	4	1	1	access_web_tour_tour_step_admin	t	t	t	t	t	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
157	135	1	1	1	access_web_tour_tour_step_readonly	t	t	f	f	f	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
158	136	4	1	1	iap.account.manager	t	t	t	t	t	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
159	136	1	1	1	iap.account.user	t	t	f	t	f	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
160	138	4	1	1	iap.service.manager	t	t	t	t	t	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
161	138	1	1	1	iap.service.user	t	t	f	f	f	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
162	154	4	1	1	fetchmail.server	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
163	168	11	1	1	mail.message.all	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
164	168	10	1	1	mail.message.portal	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
165	168	1	1	1	mail.message.user	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
166	165	4	1	1	mail.message.scheduled.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
167	169	4	1	1	mail.mail.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
168	161	1	1	1	mail.followers.user	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
169	161	4	1	1	mail.followers.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
170	155	10	1	1	mail.notification.portal	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
171	155	1	1	1	mail.notification.user	t	t	t	t	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
172	155	4	1	1	 mail.notification.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
173	198	11	1	1	discuss.channel.public	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
174	198	10	1	1	discuss.channel.portal	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
175	198	1	1	1	discuss.channel.user	t	t	t	t	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
176	198	4	1	1	discuss.channel.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
177	196	11	1	1	discuss.channel.member.public	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
178	196	10	1	1	discuss.channel.member.portal	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
179	196	1	1	1	discuss.channel.member.user	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
180	197	4	1	1	discuss.channel.rtc.session.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
181	139	1	1	1	mail.alias.user	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
182	139	4	1	1	mail.alias.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
183	140	1	1	1	mail.alias.domain.user	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
184	140	2	1	1	mail.alias.domain.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
185	162	4	1	1	mail.gateway.allowed.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
186	164	4	1	1	mail.message.reaction.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
187	166	11	1	1	mail.message.subtype.all	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
188	166	10	1	1	mail.message.subtype.all	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
189	166	1	1	1	mail.message.subtype.user	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
190	166	4	1	1	mail.message.subtype.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
191	173	4	1	1	mail.tracking.value.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
192	195	4	1	1	publisher.warranty.contract.all	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
193	174	1	1	1	mail.template	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
194	174	13	1	1	mail.template_editor	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
195	174	4	1	1	mail.template_system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
196	176	1	1	1	mail.canned.response	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
197	157	1	1	1	mail.activity.user	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
198	158	1	1	1	mail.activity.plan.user	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
199	158	4	1	1	mail.activity.plan.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
200	159	1	1	1	mail.activity.plan.template.user	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
201	159	4	1	1	mail.activity.plan.template.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
202	209	1	1	1	mail.activity.schedule.user	t	t	t	t	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
203	156	1	1	1	mail.activity.type.user	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
204	156	4	1	1	mail.activity.type.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
205	160	4	1	1	access_mail_blacklist_system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
206	214	1	1	1	access.mail.wizard.invite	t	t	t	t	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
207	208	1	1	1	access.mail.compose.message	t	t	t	t	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
208	210	1	1	1	access.mail.resend.message	t	t	t	t	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
209	211	1	1	1	access.mail.resend.partner	t	t	t	t	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
210	212	1	1	1	access.mail.template.preview	t	t	t	t	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
211	207	4	1	1	acesss.mail.blacklist.remove.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
212	201	1	1	1	mail.guest	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
213	201	4	1	1	mail.guest	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
214	175	4	1	1	mail.ice.server.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
215	178	1	1	1	res.users.settings.volumes	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
216	213	13	1	1	access.mail.template.reset	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
217	28	1	1	1	ir.actions.report.access.user	t	t	f	f	f	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
218	163	2	1	1	mail.link.preview.admin	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
219	199	1	1	1	discuss.gif.favorite	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
220	200	4	1	1	discuss.voice.metadata.user	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
221	170	4	1	1	access.mail.push.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
222	171	4	1	1	access.mail.push.device.system	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
223	167	4	1	1	mail.message.translation	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
224	172	1	1	1	access.mail.scheduled.message	t	t	t	t	t	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
225	331	4	1	1	access_web_editor_converter_test	t	t	t	t	t	2026-01-19 17:38:38.721346	2026-01-19 17:38:38.721346
226	332	4	1	1	access_web_editor_converter_test_sub	t	t	t	t	t	2026-01-19 17:38:38.721346	2026-01-19 17:38:38.721346
227	333	1	1	1	bg.job.user	t	t	t	t	f	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163
228	333	4	1	1	bg.job.system	t	t	t	t	t	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163
229	335	1	1	1	access_base_module_install_request	t	t	t	t	f	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
230	336	4	1	1	access_base_module_install_review	t	t	t	t	f	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
231	67	1	1	1	ir_module_category group_user	t	t	f	f	f	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
232	68	1	1	1	ir_module_module group_user	t	t	f	f	f	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
233	340	\N	1	1	access.phone.blacklist.all	t	f	f	f	f	2026-01-19 17:38:40.373729	2026-01-19 17:38:40.373729
234	340	4	1	1	access.phone.blacklist.system	t	t	t	t	t	2026-01-19 17:38:40.373729	2026-01-19 17:38:40.373729
235	342	4	1	1	acesss.phone.blacklist.remove.system	t	t	t	t	t	2026-01-19 17:38:40.373729	2026-01-19 17:38:40.373729
236	344	4	1	1	access_privacy_lookup_wizard	t	t	t	t	t	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
237	345	4	1	1	access_privacy_lookup_wizard_line	t	t	t	t	f	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
238	343	4	1	1	access_privacy_log	t	t	t	t	t	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
239	347	4	1	1	access_db_configuration	t	t	t	t	t	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
240	351	\N	1	1	access.sms.sms.all	t	f	f	f	f	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
241	351	4	1	1	access.sms.sms.system	t	t	t	t	t	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
242	352	\N	1	1	access.sms.template.all	t	f	f	f	f	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
243	352	1	1	1	access.sms.template.user	t	t	f	f	f	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
244	352	4	1	1	access.sms.template.system	t	t	t	t	t	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
245	353	\N	1	1	access.sms.tracker.all	t	f	f	f	f	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
246	353	4	1	1	access.sms.tracker.system	t	t	t	t	t	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
247	357	1	1	1	access.sms.composer	t	t	t	t	f	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
248	358	1	1	1	access.sms.resend.recipient	t	t	t	t	f	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
249	359	1	1	1	access.sms.resend	t	t	t	t	f	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
250	360	1	1	1	access.sms.template.preview	t	t	t	t	f	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
251	361	13	1	1	access.sms.template.reset	t	t	t	t	t	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
252	355	4	1	1	access.sms.account.phone.system	t	t	t	t	t	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
253	354	4	1	1	access.sms.account.code.system	t	t	t	t	t	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
254	356	4	1	1	access.sms.account.sender.system	t	t	t	t	t	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
255	362	1	1	1	snailmail.letter.user	t	t	t	t	f	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
256	362	4	1	1	snailmail.letter.system	t	t	t	t	t	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
257	363	1	1	1	access.snailmail.letter.format.error	t	t	t	t	f	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
258	364	1	1	1	access.snailmail.letter.missing.required.fields	t	t	t	t	f	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
\.


--
-- Data for Name: ir_model_constraint; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_constraint (id, model, module, create_uid, write_uid, name, definition, type, message, write_date, create_date) FROM stdin;
9	13	230	1	1	ir_sequence_date_range_unique_range_per_sequence	unique(sequence_id,date_from,date_to)	u	{"en_US": "You cannot create two date ranges for the same sequence with the same date range."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
46	3	230	1	1	ir_model_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
47	3	230	1	1	ir_model_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
48	4	230	1	1	ir_model_fields_group_rel_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
49	4	230	1	1	ir_model_fields_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
50	4	230	1	1	ir_model_fields_relation_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
51	4	230	1	1	ir_model_fields_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
52	4	230	1	1	ir_model_fields_related_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
53	4	230	1	1	ir_model_fields_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
54	4	230	1	1	ir_model_fields_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
55	5	230	1	1	ir_model_inherit_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
56	5	230	1	1	ir_model_inherit_parent_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
57	5	230	1	1	ir_model_inherit_parent_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
58	6	230	1	1	ir_model_fields_selection_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
59	6	230	1	1	ir_model_fields_selection_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
60	6	230	1	1	ir_model_fields_selection_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
61	7	230	1	1	ir_model_constraint_model_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
62	7	230	1	1	ir_model_constraint_module_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
63	7	230	1	1	ir_model_constraint_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
64	7	230	1	1	ir_model_constraint_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
65	8	230	1	1	ir_model_relation_model_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
66	8	230	1	1	ir_model_relation_module_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
67	8	230	1	1	ir_model_relation_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
68	8	230	1	1	ir_model_relation_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
69	9	230	1	1	ir_model_access_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
70	9	230	1	1	ir_model_access_group_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
71	9	230	1	1	ir_model_access_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
72	9	230	1	1	ir_model_access_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
73	10	230	1	1	ir_model_data_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
74	10	230	1	1	ir_model_data_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
75	11	230	1	1	wizard_ir_model_menu_create_menu_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
76	11	230	1	1	wizard_ir_model_menu_create_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
77	11	230	1	1	wizard_ir_model_menu_create_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
78	12	230	1	1	ir_sequence_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
79	12	230	1	1	ir_sequence_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
80	12	230	1	1	ir_sequence_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
81	13	230	1	1	ir_sequence_date_range_sequence_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
82	13	230	1	1	ir_sequence_date_range_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
83	13	230	1	1	ir_sequence_date_range_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
84	97	230	1	1	ir_ui_menu_group_rel_menu_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
85	14	230	1	1	ir_ui_menu_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
86	14	230	1	1	ir_ui_menu_parent_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
87	14	230	1	1	ir_ui_menu_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
88	14	230	1	1	ir_ui_menu_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
89	15	230	1	1	ir_ui_view_custom_ref_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
90	15	230	1	1	ir_ui_view_custom_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
91	15	230	1	1	ir_ui_view_custom_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
92	15	230	1	1	ir_ui_view_custom_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
93	97	230	1	1	ir_ui_view_group_rel_view_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
94	16	230	1	1	ir_ui_view_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
95	16	230	1	1	ir_ui_view_inherit_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
96	16	230	1	1	ir_ui_view_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
97	16	230	1	1	ir_ui_view_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
98	17	230	1	1	reset_view_arch_wizard_view_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
99	17	230	1	1	reset_view_arch_wizard_compare_view_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
100	17	230	1	1	reset_view_arch_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
101	17	230	1	1	reset_view_arch_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
102	18	230	1	1	ir_asset_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
103	18	230	1	1	ir_asset_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
104	22	230	1	1	ir_actions_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
105	22	230	1	1	ir_actions_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
106	22	230	1	1	ir_actions_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
107	20	230	1	1	ir_act_window_group_rel_act_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
108	20	230	1	1	ir_act_window_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
109	20	230	1	1	ir_act_window_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
110	20	230	1	1	ir_act_window_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
111	20	230	1	1	ir_act_window_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
112	20	230	1	1	ir_act_window_view_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
113	20	230	1	1	ir_act_window_search_view_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
114	21	230	1	1	ir_act_window_view_view_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
115	21	230	1	1	ir_act_window_view_act_window_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
116	21	230	1	1	ir_act_window_view_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
117	21	230	1	1	ir_act_window_view_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
118	23	230	1	1	ir_act_url_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
119	23	230	1	1	ir_act_url_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
120	23	230	1	1	ir_act_url_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
121	24	230	1	1	rel_server_actions_server_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
122	24	230	1	1	rel_server_actions_action_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
123	24	230	1	1	ir_act_server_group_rel_act_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
124	24	230	1	1	ir_act_server_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
125	24	230	1	1	ir_act_server_webhook_field_rel_server_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
126	24	230	1	1	ir_act_server_webhook_field_rel_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
127	24	230	1	1	ir_act_server_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
128	24	230	1	1	ir_act_server_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
129	24	230	1	1	ir_act_server_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
130	24	230	1	1	ir_act_server_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
131	24	230	1	1	ir_act_server_crud_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
132	24	230	1	1	ir_act_server_link_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
133	24	230	1	1	ir_act_server_update_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
134	24	230	1	1	ir_act_server_update_related_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
135	24	230	1	1	ir_act_server_selection_value_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
136	25	230	1	1	ir_actions_todo_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
137	25	230	1	1	ir_actions_todo_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
138	26	230	1	1	ir_act_client_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
139	26	230	1	1	ir_act_client_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
140	26	230	1	1	ir_act_client_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
141	27	230	1	1	ir_embedded_actions_res_groups_rel_ir_embedded_actions_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
142	27	230	1	1	ir_embedded_actions_res_groups_rel_res_groups_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
143	27	230	1	1	ir_embedded_actions_parent_action_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
144	27	230	1	1	ir_embedded_actions_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
145	27	230	1	1	ir_embedded_actions_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
146	27	230	1	1	ir_embedded_actions_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
147	28	230	1	1	res_groups_report_rel_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
148	28	230	1	1	res_groups_report_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
149	28	230	1	1	ir_act_report_xml_binding_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
150	28	230	1	1	ir_act_report_xml_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
151	28	230	1	1	ir_act_report_xml_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
152	28	230	1	1	ir_act_report_xml_paperformat_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
153	29	230	1	1	ir_attachment_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
154	29	230	1	1	ir_attachment_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
155	29	230	1	1	ir_attachment_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
156	31	230	1	1	ir_cron_ir_actions_server_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
157	31	230	1	1	ir_cron_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
158	31	230	1	1	ir_cron_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
159	31	230	1	1	ir_cron_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
160	32	230	1	1	ir_cron_trigger_cron_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
161	32	230	1	1	ir_cron_trigger_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
162	32	230	1	1	ir_cron_trigger_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
163	33	230	1	1	ir_cron_progress_cron_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
164	33	230	1	1	ir_cron_progress_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
165	33	230	1	1	ir_cron_progress_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
166	34	230	1	1	ir_filters_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
167	34	230	1	1	ir_filters_embedded_action_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
168	34	230	1	1	ir_filters_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
169	34	230	1	1	ir_filters_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
170	35	230	1	1	ir_default_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
171	35	230	1	1	ir_default_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
172	35	230	1	1	ir_default_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
173	35	230	1	1	ir_default_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
174	35	230	1	1	ir_default_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
175	36	230	1	1	ir_exports_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
176	36	230	1	1	ir_exports_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
177	37	230	1	1	ir_exports_line_export_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
178	37	230	1	1	ir_exports_line_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
179	37	230	1	1	ir_exports_line_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
180	97	230	1	1	rule_group_rel_rule_group_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
181	38	230	1	1	rule_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
182	38	230	1	1	ir_rule_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
183	38	230	1	1	ir_rule_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
184	38	230	1	1	ir_rule_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
185	39	230	1	1	ir_config_parameter_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
186	39	230	1	1	ir_config_parameter_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
187	41	230	1	1	ir_mail_server_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
188	41	230	1	1	ir_mail_server_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
189	67	230	1	1	ir_module_category_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
190	67	230	1	1	ir_module_category_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
191	68	230	1	1	module_country_module_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
192	68	230	1	1	module_country_country_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
193	68	230	1	1	ir_module_module_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
194	68	230	1	1	ir_module_module_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
195	70	230	1	1	ir_module_module_exclusion_module_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
196	70	230	1	1	ir_module_module_exclusion_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
197	70	230	1	1	ir_module_module_exclusion_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
198	71	230	1	1	ir_demo_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
199	71	230	1	1	ir_demo_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
200	72	230	1	1	ir_demo_failure_module_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
201	72	230	1	1	ir_demo_failure_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
202	72	230	1	1	ir_demo_failure_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
203	72	230	1	1	ir_demo_failure_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
204	73	230	1	1	ir_demo_failure_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
205	73	230	1	1	ir_demo_failure_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
206	74	230	1	1	report_layout_view_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
207	74	230	1	1	report_layout_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
208	74	230	1	1	report_layout_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
209	75	230	1	1	report_paperformat_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
210	75	230	1	1	report_paperformat_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
211	77	230	1	1	base_enable_profiling_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
212	77	230	1	1	base_enable_profiling_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
213	81	230	1	1	res_country_res_country_group_rel_res_country_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
214	80	230	1	1	res_country_res_country_group_rel_res_country_group_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
215	80	230	1	1	res_country_address_view_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
216	80	230	1	1	res_country_currency_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
217	80	230	1	1	res_country_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
218	80	230	1	1	res_country_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
219	81	230	1	1	res_country_group_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
220	81	230	1	1	res_country_group_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
221	82	230	1	1	res_country_state_country_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
222	82	230	1	1	res_country_state_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
223	82	230	1	1	res_country_state_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
224	83	230	1	1	res_lang_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
225	83	230	1	1	res_lang_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
226	88	230	1	1	res_partner_res_partner_category_rel_category_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
227	86	230	1	1	res_partner_res_partner_category_rel_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
228	86	230	1	1	res_partner_category_parent_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
229	86	230	1	1	res_partner_category_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
230	86	230	1	1	res_partner_category_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
231	87	230	1	1	res_partner_title_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
232	87	230	1	1	res_partner_title_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
233	88	230	1	1	res_partner_title_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
234	88	230	1	1	res_partner_parent_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
235	88	230	1	1	res_partner_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
236	88	230	1	1	res_partner_state_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
237	88	230	1	1	res_partner_country_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
238	88	230	1	1	res_partner_industry_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
239	88	230	1	1	res_partner_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
240	88	230	1	1	res_partner_commercial_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
241	88	230	1	1	res_partner_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
242	88	230	1	1	res_partner_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
243	89	230	1	1	res_partner_industry_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
244	89	230	1	1	res_partner_industry_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
245	90	230	1	1	res_bank_state_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
246	90	230	1	1	res_bank_country_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
247	90	230	1	1	res_bank_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
248	90	230	1	1	res_bank_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
249	91	230	1	1	res_partner_bank_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
250	91	230	1	1	res_partner_bank_bank_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
251	91	230	1	1	res_partner_bank_currency_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
252	91	230	1	1	res_partner_bank_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
253	91	230	1	1	res_partner_bank_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
254	91	230	1	1	res_partner_bank_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
255	92	230	1	1	res_config_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
256	92	230	1	1	res_config_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
257	93	230	1	1	res_config_settings_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
258	93	230	1	1	res_config_settings_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
259	94	230	1	1	res_currency_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
260	94	230	1	1	res_currency_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
261	95	230	1	1	res_currency_rate_currency_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
262	95	230	1	1	res_currency_rate_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
263	95	230	1	1	res_currency_rate_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
264	95	230	1	1	res_currency_rate_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
265	99	230	1	1	res_company_users_rel_cid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
266	96	230	1	1	res_company_users_rel_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
267	96	230	1	1	res_company_parent_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
268	96	230	1	1	res_company_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
269	96	230	1	1	res_company_currency_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
270	96	230	1	1	res_company_paperformat_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
271	96	230	1	1	res_company_external_report_layout_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
272	96	230	1	1	res_company_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
273	96	230	1	1	res_company_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
274	99	230	1	1	res_groups_users_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
275	97	230	1	1	res_groups_users_rel_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
276	97	230	1	1	res_groups_implied_rel_gid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
277	97	230	1	1	res_groups_implied_rel_hid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
278	97	230	1	1	res_groups_category_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
279	97	230	1	1	res_groups_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
280	97	230	1	1	res_groups_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
281	98	230	1	1	res_users_log_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
282	98	230	1	1	res_users_log_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
283	99	230	1	1	res_users_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
284	99	230	1	1	res_users_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
285	99	230	1	1	res_users_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
286	99	230	1	1	res_users_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
287	100	230	1	1	res_users_identitycheck_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
288	100	230	1	1	res_users_identitycheck_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
289	101	230	1	1	change_password_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
290	101	230	1	1	change_password_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
291	102	230	1	1	change_password_user_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
292	102	230	1	1	change_password_user_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
293	102	230	1	1	change_password_user_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
294	102	230	1	1	change_password_user_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
295	103	230	1	1	change_password_own_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
296	103	230	1	1	change_password_own_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
297	105	230	1	1	res_users_apikeys_description_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
298	105	230	1	1	res_users_apikeys_description_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
299	107	230	1	1	res_users_settings_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
300	107	230	1	1	res_users_settings_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
301	107	230	1	1	res_users_settings_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
302	108	230	1	1	res_users_deletion_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
303	108	230	1	1	res_users_deletion_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
304	108	230	1	1	res_users_deletion_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
305	109	230	1	1	res_device_log_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
306	109	230	1	1	res_device_log_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
307	109	230	1	1	res_device_log_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
308	111	230	1	1	decimal_precision_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
309	111	230	1	1	decimal_precision_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
310	113	230	1	1	base_module_update_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
311	113	230	1	1	base_module_update_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
312	114	230	1	1	res_lang_install_rel_language_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
313	114	230	1	1	res_lang_install_rel_lang_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
314	114	230	1	1	base_language_install_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
315	114	230	1	1	base_language_install_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
316	115	230	1	1	base_language_import_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
317	115	230	1	1	base_language_import_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
318	116	230	1	1	base_module_upgrade_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
319	116	230	1	1	base_module_upgrade_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
320	117	230	1	1	base_module_uninstall_module_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
321	117	230	1	1	base_module_uninstall_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
322	117	230	1	1	base_module_uninstall_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
323	118	230	1	1	rel_modules_langexport_wiz_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
324	118	230	1	1	rel_modules_langexport_module_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
325	118	230	1	1	base_language_export_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
326	118	230	1	1	base_language_export_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
327	118	230	1	1	base_language_export_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
328	119	230	1	1	base_partner_merge_line_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
329	119	230	1	1	base_partner_merge_line_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
330	119	230	1	1	base_partner_merge_line_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
331	120	230	1	1	base_partner_merge_automatic__base_partner_merge_automatic_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
332	120	230	1	1	base_partner_merge_automatic_wizard_res_par_res_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
333	120	230	1	1	base_partner_merge_automatic_wizard_current_line_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
334	120	230	1	1	base_partner_merge_automatic_wizard_dst_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
335	120	230	1	1	base_partner_merge_automatic_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
336	120	230	1	1	base_partner_merge_automatic_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
10	16	230	1	1	ir_ui_view_inheritance_mode	check(mode != 'extension' or inherit_id is not null)	u	{"en_US": "Invalid inheritance mode: if the mode is 'extension', the view must extend an other view", "es_419": "Modo de herencia no válido: si el modo es 'extensión', la vista debe extender otra vista"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
11	16	230	1	1	ir_ui_view_qweb_required_key	check(type != 'qweb' or key is not null)	u	{"en_US": "Invalid key: QWeb view should have a key", "es_419": "Clave no válida: la vista QWeb debe tener una clave"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
1	3	230	1	1	ir_model_obj_name_uniq	unique(model)	u	{"en_US": "Each model must have a unique name.", "es_419": "Cada modelo debe tener un nombre único. "}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
2	4	230	1	1	ir_model_fields_name_unique	unique(model,name)	u	{"en_US": "Field names must be unique per model.", "es_419": "Los nombres de campo deben ser únicos por modelo."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
3	4	230	1	1	ir_model_fields_size_gt_zero	check(size>=0)	u	{"en_US": "Size of the field cannot be negative.", "es_419": "El tamaño del campo no puede ser negativo."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
4	4	230	1	1	ir_model_fields_name_manual_field	check(state != 'manual' or name like 'x\\_%')	u	{"en_US": "Custom fields must have a name that starts with 'x_'!", "es_419": "Los campos personalizados deben tener un nombre que empiece con 'x_'"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
5	5	230	1	1	ir_model_inherit_uniq	unique(model_id,parent_id)	u	{"en_US": "Models inherits from another only once", "es_419": "El modelo hereda de otro solo una vez"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
6	6	230	1	1	ir_model_fields_selection_selection_field_uniq	unique(field_id,value)	u	{"en_US": "Selections values must be unique per field", "es_419": "Los valores de selección deben ser únicos en cada campo"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
7	7	230	1	1	ir_model_constraint_module_name_uniq	unique(name,module)	u	{"en_US": "Constraints with the same name are unique per module.", "es_419": "Las restricciones con el mismo nombre son únicas por módulo."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
8	10	230	1	1	ir_model_data_name_nospaces	check(name not like '% %')	u	{"en_US": "External IDs cannot contain spaces", "es_419": "Los ID externos no pueden contener espacios"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
12	19	230	1	1	ir_actions_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one.", "es_419": "La ruta a mostrar en la URL debe ser única, seleccione otra."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
13	20	230	1	1	ir_act_window_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one.", "es_419": "La ruta a mostrar en la URL debe ser única, seleccione otra."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
14	23	230	1	1	ir_act_url_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one.", "es_419": "La ruta a mostrar en la URL debe ser única, seleccione otra."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
15	24	230	1	1	ir_act_server_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one.", "es_419": "La ruta a mostrar en la URL debe ser única, seleccione otra."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
16	26	230	1	1	ir_act_client_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one.", "es_419": "La ruta a mostrar en la URL debe ser única, seleccione otra."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
17	27	230	1	1	ir_embedded_actions_check_only_one_action_defined	check(\n               (action_id is not null and python_method is null) or\n               (action_id is null and python_method is not null)\n            )	u	{"en_US": "Constraint to ensure that either an XML action or a python_method is defined, but not both.", "es_419": "Restricción para asegurarse de que solo se defina la acción XML o el python_method, no ambos."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
18	27	230	1	1	ir_embedded_actions_check_python_method_requires_name	check(\n                not(python_method is not null and name is null)\n            )	u	{"en_US": "Constraint to ensure that if a python_method is defined, then the name must also be defined.", "es_419": "Restricción para asegurar que el python_method está definido, el nombre también tiene que estar definido."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
19	28	230	1	1	ir_act_report_xml_path_unique	unique(path)	u	{"en_US": "Path to show in the URL must be unique! Please choose another one.", "es_419": "La ruta a mostrar en la URL debe ser única, seleccione otra."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
20	31	230	1	1	ir_cron_check_strictly_positive_interval	check(interval_number > 0)	u	{"en_US": "The interval number must be a strictly positive number.", "es_419": "El número de intervalo debe ser un número estrictamente positivo."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
21	34	230	1	1	ir_filters_name_model_uid_unique	unique(model_id,user_id,action_id,embedded_action_id,embedded_parent_res_id,name)	u	{"en_US": "Filter names must be unique", "es_419": "Los nombres de los filtros deben ser únicos"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
22	34	230	1	1	ir_filters_check_res_id_only_when_embedded_action	check(\n                not(embedded_parent_res_id is not null and embedded_action_id is null)\n            )	u	{"en_US": "Constraint to ensure that the embedded_parent_res_id is only defined when a top_action_id is defined.", "es_419": "Restricción para asegurar que el embedded_parent_res_id solo se defina cuando se defina un top_action_id."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
23	34	230	1	1	ir_filters_check_sort_json	check(sort is null or jsonb_typeof(sort::jsonb) = 'array')	u	{"en_US": "Invalid sort definition", "es_419": "Definición de acomodar inválida"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
24	38	230	1	1	ir_rule_no_access_rights	check(perm_read!=false or perm_write!=false or perm_create!=false or perm_unlink!=false)	u	{"en_US": "Rule must have at least one checked access right!", "es_419": "La regla debe tener por lo menos un permiso de acceso seleccionado."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
25	39	230	1	1	ir_config_parameter_key_uniq	unique(key)	u	{"en_US": "Key must be unique.", "es_419": "La clave debe ser única."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
26	41	230	1	1	ir_mail_server_certificate_requires_tls	check(smtp_encryption != 'none' or smtp_authentication != 'certificate')	u	{"en_US": "Certificate-based authentication requires a TLS transport", "es_419": "Una autenticación según certificado requiere un transporte TLS"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
27	68	230	1	1	ir_module_module_name_uniq	unique(name)	u	{"en_US": "The name of the module must be unique!", "es_419": "El nombre del módulo debe ser único."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
28	80	230	1	1	res_country_name_uniq	unique(name)	u	{"en_US": "The name of the country must be unique!", "es_419": "El nombre del país debe ser único."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
29	80	230	1	1	res_country_code_uniq	unique(code)	u	{"en_US": "The code of the country must be unique!", "es_419": "El código del país debe ser único."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
30	82	230	1	1	res_country_state_name_code_uniq	unique(country_id,code)	u	{"en_US": "The code of the state must be unique by country!", "es_419": "El código del estado debe ser único por país"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
31	83	230	1	1	res_lang_name_uniq	unique(name)	u	{"en_US": "The name of the language must be unique!", "es_419": "El nombre del idioma debe ser único."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
32	83	230	1	1	res_lang_code_uniq	unique(code)	u	{"en_US": "The code of the language must be unique!", "es_419": "El código del idioma debe ser único."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
33	83	230	1	1	res_lang_url_code_uniq	unique(url_code)	u	{"en_US": "The URL code of the language must be unique!", "es_419": "El código URL del idioma debe ser único"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
34	88	230	1	1	res_partner_check_name	check((type='contact' and name is not null) or(type!='contact') )	u	{"en_US": "Contacts require a name", "es_419": "Los contactos necesitan un nombre"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
35	91	230	1	1	res_partner_bank_unique_number	unique(sanitized_acc_number,partner_id)	u	{"en_US": "The combination Account Number/Partner must be unique.", "es_419": "La combinación de número de cuenta y contacto debe ser única."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
36	94	230	1	1	res_currency_unique_name	unique(name)	u	{"en_US": "The currency code must be unique!", "es_419": "El código de divisa debe ser único"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
37	94	230	1	1	res_currency_rounding_gt_zero	check(rounding>0)	u	{"en_US": "The rounding factor must be greater than 0!", "es_419": "El factor de redondeo debe ser mayor que 0."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
38	95	230	1	1	res_currency_rate_unique_name_per_day	unique(name,currency_id,company_id)	u	{"en_US": "Only one currency rate per day allowed!", "es_419": "Solo se permite una tasa de cambio al día."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
39	95	230	1	1	res_currency_rate_currency_rate_check	check(rate>0)	u	{"en_US": "The currency rate must be strictly positive.", "es_419": "La tasa de cambio debe ser estrictamente positiva."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
40	96	230	1	1	res_company_name_uniq	unique(name)	u	{"en_US": "The company name must be unique!", "es_419": "El nombre de la empresa debe ser único"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
41	97	230	1	1	res_groups_name_uniq	unique(category_id,name)	u	{"en_US": "The name of the group must be unique within an application!", "es_419": "El nombre del grupo debe ser único en una aplicación."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
42	97	230	1	1	res_groups_check_api_key_duration	check(api_key_duration >= 0)	u	{"en_US": "The api key duration cannot be a negative value.", "es_419": "La duración de la clave API no puede ser un valor negativo."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
43	99	230	1	1	res_users_login_key	unique(login)	u	{"en_US": "You can not have two users with the same login!", "es_419": "No puede tener dos usuarios con la misma información de inicio de sesión"}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
44	107	230	1	1	res_users_settings_unique_user_id	unique(user_id)	u	{"en_US": "One user should only have one user settings.", "es_419": "Un usuario solo debe tener una configuración de usuario."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
45	111	230	1	1	decimal_precision_name_uniq	unique(name)	u	{"en_US": "Only one value can be defined for each given usage!", "es_419": "Solo se puede definir un valor para cada uso en concreto."}	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272
337	122	2570	1	1	base_document_layout_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188
338	122	2570	1	1	base_document_layout_report_layout_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188
339	122	2570	1	1	base_document_layout_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188
340	122	2570	1	1	base_document_layout_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:33.693188	2026-01-19 17:38:33.693188
341	124	219	1	1	auth_totp_wizard_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:34.241839	2026-01-19 17:38:34.241839
342	124	219	1	1	auth_totp_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:34.241839	2026-01-19 17:38:34.241839
343	124	219	1	1	auth_totp_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:34.241839	2026-01-19 17:38:34.241839
344	125	253	1	1	base_import_mapping_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:34.53603	2026-01-19 17:38:34.53603
345	125	253	1	1	base_import_mapping_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:34.53603	2026-01-19 17:38:34.53603
346	126	253	1	1	base_import_import_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:34.53603	2026-01-19 17:38:34.53603
347	126	253	1	1	base_import_import_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:34.53603	2026-01-19 17:38:34.53603
348	127	255	1	1	base_import_module_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:34.934808	2026-01-19 17:38:34.934808
349	127	255	1	1	base_import_module_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:34.934808	2026-01-19 17:38:34.934808
350	93	281	1	1	res_config_settings_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:35.032459	2026-01-19 17:38:35.032459
351	129	307	1	1	bus_bus_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:35.107472	2026-01-19 17:38:35.107472
352	129	307	1	1	bus_bus_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:35.107472	2026-01-19 17:38:35.107472
353	131	307	1	1	bus_presence_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:35.107472	2026-01-19 17:38:35.107472
355	134	2619	1	1	res_users_web_tour_tour_rel_web_tour_tour_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
356	134	2619	1	1	res_users_web_tour_tour_rel_res_users_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
357	134	2619	1	1	web_tour_tour_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
358	134	2619	1	1	web_tour_tour_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
359	135	2619	1	1	web_tour_tour_step_tour_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
360	135	2619	1	1	web_tour_tour_step_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
361	135	2619	1	1	web_tour_tour_step_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
354	134	2619	1	1	web_tour_tour_uniq_name	unique(name)	u	{"en_US": "A tour already exists with this name . Tour's name must be unique!", "es_419": "Ya existe un recorrido con este nombre, su nombre debe ser único."}	2026-01-19 17:38:36.21336	2026-01-19 17:38:36.21336
362	29	627	1	1	ir_attachment_original_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.301567	2026-01-19 17:38:36.301567
364	136	633	1	1	iap_account_res_company_rel_iap_account_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
365	136	633	1	1	iap_account_res_company_rel_res_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
366	136	633	1	1	iap_account_res_users_rel_iap_account_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
367	136	633	1	1	iap_account_res_users_rel_res_users_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
368	136	633	1	1	iap_account_service_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
369	136	633	1	1	iap_account_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
370	136	633	1	1	iap_account_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
371	138	633	1	1	iap_service_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
372	138	633	1	1	iap_service_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
363	138	633	1	1	iap_service_unique_technical_name	unique(technical_name)	u	{"en_US": "Only one service can exist with a specific technical_name", "es_419": "Solo puede existir un servicio con un nombre técnico específico"}	2026-01-19 17:38:36.35346	2026-01-19 17:38:36.35346
373	140	1175	1	1	mail_alias_domain_bounce_email_uniques	unique(bounce_alias,name)	u	{"en_US": "Bounce emails should be unique", "es_419": "Los correos electrónicos de devolución deben ser únicos"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
391	139	1175	1	1	mail_alias_alias_domain_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
392	139	1175	1	1	mail_alias_alias_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
393	139	1175	1	1	mail_alias_alias_parent_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
394	139	1175	1	1	mail_alias_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
395	139	1175	1	1	mail_alias_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
396	140	1175	1	1	mail_alias_domain_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
397	140	1175	1	1	mail_alias_domain_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
398	154	1175	1	1	fetchmail_server_object_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
399	154	1175	1	1	fetchmail_server_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
400	154	1175	1	1	fetchmail_server_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
401	155	1175	1	1	mail_notification_author_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
402	155	1175	1	1	mail_notification_mail_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
403	155	1175	1	1	mail_notification_mail_mail_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
404	168	1175	1	1	mail_notification_res_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
405	156	1175	1	1	mail_activity_rel_activity_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
406	156	1175	1	1	mail_activity_rel_recommended_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
407	156	1175	1	1	mail_activity_type_mail_template_rel_mail_activity_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
408	156	1175	1	1	mail_activity_type_mail_template_rel_mail_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
409	156	1175	1	1	mail_activity_type_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
410	156	1175	1	1	mail_activity_type_triggered_next_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
411	156	1175	1	1	mail_activity_type_default_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
412	156	1175	1	1	mail_activity_type_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
413	157	1175	1	1	activity_attachment_rel_activity_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
414	157	1175	1	1	activity_attachment_rel_attachment_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
415	157	1175	1	1	mail_activity_res_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
416	157	1175	1	1	mail_activity_activity_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
417	157	1175	1	1	mail_activity_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
418	157	1175	1	1	mail_activity_request_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
419	157	1175	1	1	mail_activity_recommended_activity_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
420	157	1175	1	1	mail_activity_previous_activity_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
421	157	1175	1	1	mail_activity_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
422	157	1175	1	1	mail_activity_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
423	158	1175	1	1	mail_activity_plan_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
424	158	1175	1	1	mail_activity_plan_res_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
425	158	1175	1	1	mail_activity_plan_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
426	158	1175	1	1	mail_activity_plan_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
427	159	1175	1	1	mail_activity_plan_template_plan_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
428	159	1175	1	1	mail_activity_plan_template_activity_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
429	159	1175	1	1	mail_activity_plan_template_responsible_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
430	159	1175	1	1	mail_activity_plan_template_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
431	159	1175	1	1	mail_activity_plan_template_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
432	160	1175	1	1	mail_blacklist_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
433	160	1175	1	1	mail_blacklist_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
434	161	1175	1	1	mail_followers_mail_message_subtype_rel_mail_followers_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
435	161	1175	1	1	mail_followers_mail_message_subtyp_mail_message_subtype_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
436	161	1175	1	1	mail_followers_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
437	162	1175	1	1	mail_gateway_allowed_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
438	162	1175	1	1	mail_gateway_allowed_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
439	163	1175	1	1	mail_link_preview_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
440	163	1175	1	1	mail_link_preview_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
441	163	1175	1	1	mail_link_preview_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
442	164	1175	1	1	mail_message_reaction_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
443	164	1175	1	1	mail_message_reaction_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
444	164	1175	1	1	mail_message_reaction_guest_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
445	165	1175	1	1	mail_message_schedule_mail_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
446	165	1175	1	1	mail_message_schedule_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
447	165	1175	1	1	mail_message_schedule_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
448	166	1175	1	1	mail_message_subtype_parent_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
449	166	1175	1	1	mail_message_subtype_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
450	166	1175	1	1	mail_message_subtype_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
451	167	1175	1	1	mail_message_translation_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
452	167	1175	1	1	mail_message_translation_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
453	167	1175	1	1	mail_message_translation_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
454	168	1175	1	1	message_attachment_rel_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
455	168	1175	1	1	message_attachment_rel_attachment_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
456	168	1175	1	1	mail_message_res_partner_rel_mail_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
457	168	1175	1	1	mail_message_res_partner_rel_res_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
458	88	1175	1	1	mail_message_res_partner_starred_rel_mail_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
459	168	1175	1	1	mail_message_res_partner_starred_rel_res_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
460	168	1175	1	1	mail_message_parent_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
461	168	1175	1	1	mail_message_record_alias_domain_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
462	168	1175	1	1	mail_message_record_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
463	168	1175	1	1	mail_message_subtype_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
464	168	1175	1	1	mail_message_mail_activity_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
465	168	1175	1	1	mail_message_author_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
466	168	1175	1	1	mail_message_author_guest_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
467	168	1175	1	1	mail_message_mail_server_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
468	168	1175	1	1	mail_message_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
469	168	1175	1	1	mail_message_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
470	169	1175	1	1	mail_mail_res_partner_rel_mail_mail_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
471	169	1175	1	1	mail_mail_res_partner_rel_res_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
472	169	1175	1	1	mail_mail_mail_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
473	169	1175	1	1	mail_mail_fetchmail_server_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
474	169	1175	1	1	mail_mail_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
475	169	1175	1	1	mail_mail_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
476	170	1175	1	1	mail_push_mail_push_device_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
477	170	1175	1	1	mail_push_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
478	170	1175	1	1	mail_push_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
479	171	1175	1	1	mail_push_device_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
480	171	1175	1	1	mail_push_device_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
481	171	1175	1	1	mail_push_device_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
482	172	1175	1	1	scheduled_message_attachment_rel_scheduled_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
483	172	1175	1	1	scheduled_message_attachment_rel_attachment_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
484	172	1175	1	1	mail_scheduled_message_res_partn_mail_scheduled_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
485	172	1175	1	1	mail_scheduled_message_res_partner_rel_res_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
486	172	1175	1	1	mail_scheduled_message_author_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
487	172	1175	1	1	mail_scheduled_message_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
488	172	1175	1	1	mail_scheduled_message_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
489	173	1175	1	1	mail_tracking_value_field_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
490	173	1175	1	1	mail_tracking_value_currency_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
491	173	1175	1	1	mail_tracking_value_mail_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
492	173	1175	1	1	mail_tracking_value_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
493	173	1175	1	1	mail_tracking_value_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
494	174	1175	1	1	email_template_attachment_rel_email_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
495	174	1175	1	1	email_template_attachment_rel_attachment_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
496	174	1175	1	1	mail_template_ir_actions_report_rel_mail_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
497	174	1175	1	1	mail_template_ir_actions_report_rel_ir_actions_report_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
498	174	1175	1	1	mail_template_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
499	174	1175	1	1	mail_template_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
500	174	1175	1	1	mail_template_mail_server_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
501	174	1175	1	1	mail_template_ref_ir_act_window_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
502	174	1175	1	1	mail_template_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
503	174	1175	1	1	mail_template_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
504	175	1175	1	1	mail_ice_server_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
505	175	1175	1	1	mail_ice_server_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
506	176	1175	1	1	mail_canned_response_res_groups_re_mail_canned_response_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
507	176	1175	1	1	mail_canned_response_res_groups_rel_res_groups_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
508	176	1175	1	1	mail_canned_response_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
509	176	1175	1	1	mail_canned_response_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
510	178	1175	1	1	res_users_settings_volumes_user_setting_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
511	178	1175	1	1	res_users_settings_volumes_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
512	178	1175	1	1	res_users_settings_volumes_guest_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
513	178	1175	1	1	res_users_settings_volumes_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
514	178	1175	1	1	res_users_settings_volumes_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
515	131	1175	1	1	bus_presence_guest_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
516	24	1175	1	1	ir_act_server_res_partner_rel_ir_act_server_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
517	24	1175	1	1	ir_act_server_res_partner_rel_res_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
518	24	1175	1	1	ir_act_server_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
519	24	1175	1	1	ir_act_server_activity_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
520	24	1175	1	1	ir_act_server_activity_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
521	96	1175	1	1	res_company_alias_domain_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
522	196	1175	1	1	discuss_channel_member_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
523	196	1175	1	1	discuss_channel_member_guest_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
524	88	1175	1	1	discuss_channel_member_channel_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
525	196	1175	1	1	discuss_channel_member_fetched_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
526	196	1175	1	1	discuss_channel_member_seen_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
527	196	1175	1	1	discuss_channel_member_rtc_inviting_session_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
528	196	1175	1	1	discuss_channel_member_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
529	196	1175	1	1	discuss_channel_member_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
530	197	1175	1	1	discuss_channel_rtc_session_channel_member_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
531	197	1175	1	1	discuss_channel_rtc_session_channel_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
532	197	1175	1	1	discuss_channel_rtc_session_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
533	197	1175	1	1	discuss_channel_rtc_session_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
534	198	1175	1	1	discuss_channel_res_groups_rel_discuss_channel_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
535	198	1175	1	1	discuss_channel_res_groups_rel_res_groups_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
536	198	1175	1	1	discuss_channel_parent_channel_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
537	198	1175	1	1	discuss_channel_from_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
538	198	1175	1	1	discuss_channel_group_public_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
539	198	1175	1	1	discuss_channel_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
540	198	1175	1	1	discuss_channel_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
541	199	1175	1	1	discuss_gif_favorite_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
542	199	1175	1	1	discuss_gif_favorite_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
543	200	1175	1	1	discuss_voice_metadata_attachment_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
544	200	1175	1	1	discuss_voice_metadata_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
545	200	1175	1	1	discuss_voice_metadata_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
546	201	1175	1	1	mail_guest_country_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
547	201	1175	1	1	mail_guest_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
548	201	1175	1	1	mail_guest_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
549	207	1175	1	1	mail_blacklist_remove_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
550	207	1175	1	1	mail_blacklist_remove_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
551	208	1175	1	1	mail_compose_message_ir_attachments_rel_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
552	208	1175	1	1	mail_compose_message_ir_attachments_rel_attachment_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
553	208	1175	1	1	mail_compose_message_res_partner_rel_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
554	208	1175	1	1	mail_compose_message_res_partner_rel_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
555	208	1175	1	1	mail_compose_message_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
556	208	1175	1	1	mail_compose_message_parent_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
557	208	1175	1	1	mail_compose_message_author_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
558	208	1175	1	1	mail_compose_message_res_domain_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
559	208	1175	1	1	mail_compose_message_record_alias_domain_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
560	208	1175	1	1	mail_compose_message_record_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
561	208	1175	1	1	mail_compose_message_subtype_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
562	208	1175	1	1	mail_compose_message_mail_activity_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
563	208	1175	1	1	mail_compose_message_mail_server_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
564	208	1175	1	1	mail_compose_message_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
565	208	1175	1	1	mail_compose_message_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
566	209	1175	1	1	mail_activity_plan_mail_activity_mail_activity_schedule_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
567	209	1175	1	1	mail_activity_plan_mail_activity_sch_mail_activity_plan_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
568	209	1175	1	1	mail_activity_schedule_res_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
569	209	1175	1	1	mail_activity_schedule_plan_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
570	209	1175	1	1	mail_activity_schedule_plan_on_demand_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
571	209	1175	1	1	mail_activity_schedule_activity_type_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
572	209	1175	1	1	mail_activity_schedule_activity_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
573	209	1175	1	1	mail_activity_schedule_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
574	209	1175	1	1	mail_activity_schedule_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
575	210	1175	1	1	mail_notification_mail_resend_messa_mail_resend_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
576	210	1175	1	1	mail_notification_mail_resend_message_mail_notification_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
577	210	1175	1	1	mail_resend_message_mail_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
578	210	1175	1	1	mail_resend_message_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
579	210	1175	1	1	mail_resend_message_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
580	211	1175	1	1	mail_resend_partner_notification_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
581	211	1175	1	1	mail_resend_partner_resend_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
582	211	1175	1	1	mail_resend_partner_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
583	211	1175	1	1	mail_resend_partner_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
584	212	1175	1	1	mail_template_preview_mail_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
585	212	1175	1	1	mail_template_preview_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
586	212	1175	1	1	mail_template_preview_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
587	213	1175	1	1	mail_template_mail_template_reset_r_mail_template_reset_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
588	213	1175	1	1	mail_template_mail_template_reset_rel_mail_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
589	213	1175	1	1	mail_template_reset_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
590	213	1175	1	1	mail_template_reset_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
591	214	1175	1	1	mail_wizard_invite_res_partner_rel_mail_wizard_invite_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
592	214	1175	1	1	mail_wizard_invite_res_partner_rel_res_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
593	214	1175	1	1	mail_wizard_invite_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
594	214	1175	1	1	mail_wizard_invite_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
374	140	1175	1	1	mail_alias_domain_catchall_email_uniques	unique(catchall_alias,name)	u	{"en_US": "Catchall emails should be unique", "es_419": "Los correos electrónicos catchall deben ser únicos"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
375	155	1175	1	1	mail_notification_notification_partner_required	check(notification_type not in('email','inbox') or res_partner_id is not null)	u	{"en_US": "Customer is required for inbox / email notification", "es_419": "Es necesario un cliente para enviar notificaciones por buzón o correo"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
376	157	1175	1	1	mail_activity_check_res_id_is_set	check(res_id is not null and res_id !=0 )	u	{"en_US": "Activities have to be linked to records with a not null res_id.", "es_419": "Las actividades deben estar vinculadas a registros con un res_id no nulo."}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
377	160	1175	1	1	mail_blacklist_unique_email	unique(email)	u	{"en_US": "Email address already exists!", "es_419": "Ya existe esta dirección de correo electrónico."}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
378	161	1175	1	1	mail_followers_mail_followers_res_partner_res_model_id_uniq	unique(res_model,res_id,partner_id)	u	{"en_US": "Error, a partner cannot follow twice the same object.", "es_419": "Error, un contacto no puede seguir dos veces un mismo tema."}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
627	347	1917	1	1	db_configuration_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
379	164	1175	1	1	mail_message_reaction_partner_or_guest_exists	check((partner_id is not null and guest_id is null) or(partner_id is null and guest_id is not null))	u	{"en_US": "A message reaction must be from a partner or from a guest.", "es_419": "La reacción a un mensaje debe ser de un contacto o de un invitado."}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
380	171	1175	1	1	mail_push_device_endpoint_unique	unique(endpoint)	u	{"en_US": "The endpoint must be unique !", "es_419": "El punto de conexión debe ser único"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
381	178	1175	1	1	res_users_settings_volumes_partner_or_guest_exists	check((partner_id is not null and guest_id is null) or(partner_id is null and guest_id is not null))	u	{"en_US": "A volume setting must have a partner or a guest.", "es_419": "Un ajuste de volumen debe tener un contacto o un invitado."}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
382	131	1175	1	1	bus_presence_partner_or_guest_exists	check((user_id is not null and guest_id is null) or(user_id is null and guest_id is not null))	u	{"en_US": "A bus presence must have a user or a guest.", "es_419": "La presencia del bus debe tener un usuario o invitado."}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
383	99	1175	1	1	res_users_notification_type	check(notification_type = 'email' or not share)	u	{"en_US": "Only internal user can receive notifications in Odoo", "es_419": "Solo los usuarios internos pueden recibir notificaciones en Odoo"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
384	196	1175	1	1	discuss_channel_member_partner_or_guest_exists	check((partner_id is not null and guest_id is null) or(partner_id is null and guest_id is not null))	u	{"en_US": "A channel member must be a partner or a guest.", "es_419": "El miembro de un canal debe ser contacto o invitado."}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
385	197	1175	1	1	discuss_channel_rtc_session_channel_member_unique	unique(channel_member_id)	u	{"en_US": "There can only be one rtc session per channel member", "es_419": "Solo puede haber una sesión de RTC por miembro de canal"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
386	198	1175	1	1	discuss_channel_from_message_id_unique	unique(from_message_id)	u	{"en_US": "Messages can only be linked to one sub-channel", "es_419": "Los mensajes solo pueden vincularse a un subcanal"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
387	198	1175	1	1	discuss_channel_sub_channel_no_group_public_id	check(parent_channel_id is null or group_public_id is null)	u	{"en_US": "Group public id should not be set on sub-channels as access is based on parent channel", "es_419": "No debe establecer el ID público del grupo en los subcanales, el acceso está basado en el canal principal"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
388	198	1175	1	1	discuss_channel_uuid_unique	unique(uuid)	u	{"en_US": "The channel UUID must be unique", "es_419": "El UUID del canal debe ser único"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
389	198	1175	1	1	discuss_channel_group_public_id_check	check(channel_type = 'channel' or group_public_id is null)	u	{"en_US": "Group authorization and group auto-subscription are only supported on channels.", "es_419": "La autorización y autosuscripción de grupos solo es posible en canales."}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
390	199	1175	1	1	discuss_gif_favorite_user_gif_favorite	unique(create_uid,tenor_gif_id)	u	{"en_US": "User should not have duplicated favorite GIF", "es_419": "El usuario no debe tener GIF favoritos duplicados"}	2026-01-19 17:38:36.870217	2026-01-19 17:38:36.870217
595	331	2580	1	1	web_editor_converter_test_many2one_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:38.721346	2026-01-19 17:38:38.721346
596	331	2580	1	1	web_editor_converter_test_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:38.721346	2026-01-19 17:38:38.721346
597	331	2580	1	1	web_editor_converter_test_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:38.721346	2026-01-19 17:38:38.721346
598	332	2580	1	1	web_editor_converter_test_sub_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:38.721346	2026-01-19 17:38:38.721346
599	332	2580	1	1	web_editor_converter_test_sub_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:38.721346	2026-01-19 17:38:38.721346
600	93	217	1	1	res_config_settings_auth_signup_template_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.554159	2026-01-19 17:38:39.554159
601	333	235	1	1	bg_job_next_job_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163
602	333	235	1	1	bg_job_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163
603	333	235	1	1	bg_job_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.751163	2026-01-19 17:38:39.751163
604	335	257	1	1	base_module_install_request_module_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
605	335	257	1	1	base_module_install_request_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
606	335	257	1	1	base_module_install_request_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
607	335	257	1	1	base_module_install_request_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
608	336	257	1	1	base_module_install_review_module_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
609	336	257	1	1	base_module_install_review_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
610	336	257	1	1	base_module_install_review_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:39.895726	2026-01-19 17:38:39.895726
612	340	1431	1	1	phone_blacklist_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:40.373729	2026-01-19 17:38:40.373729
613	340	1431	1	1	phone_blacklist_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:40.373729	2026-01-19 17:38:40.373729
614	342	1431	1	1	phone_blacklist_remove_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:40.373729	2026-01-19 17:38:40.373729
615	342	1431	1	1	phone_blacklist_remove_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:40.373729	2026-01-19 17:38:40.373729
611	340	1431	1	1	phone_blacklist_unique_number	unique(number)	u	{"en_US": "Number already exists", "es_419": "El número ya existe"}	2026-01-19 17:38:40.373729	2026-01-19 17:38:40.373729
616	343	1543	1	1	privacy_log_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
617	343	1543	1	1	privacy_log_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
618	343	1543	1	1	privacy_log_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
619	344	1543	1	1	privacy_lookup_wizard_log_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
620	344	1543	1	1	privacy_lookup_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
621	344	1543	1	1	privacy_lookup_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
622	345	1543	1	1	privacy_lookup_wizard_line_wizard_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
623	345	1543	1	1	privacy_lookup_wizard_line_res_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
624	345	1543	1	1	privacy_lookup_wizard_line_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
625	345	1543	1	1	privacy_lookup_wizard_line_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.141682	2026-01-19 17:38:41.141682
626	347	1917	1	1	db_configuration_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.58672	2026-01-19 17:38:41.58672
630	24	2191	1	1	ir_act_server_sms_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
631	351	2191	1	1	sms_sms_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
632	351	2191	1	1	sms_sms_mail_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
633	351	2191	1	1	sms_sms_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
634	351	2191	1	1	sms_sms_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
635	352	2191	1	1	sms_template_model_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
636	352	2191	1	1	sms_template_sidebar_action_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
637	352	2191	1	1	sms_template_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
638	352	2191	1	1	sms_template_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
639	353	2191	1	1	sms_tracker_mail_notification_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
640	353	2191	1	1	sms_tracker_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
641	353	2191	1	1	sms_tracker_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
642	354	2191	1	1	sms_account_code_account_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
643	354	2191	1	1	sms_account_code_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
644	354	2191	1	1	sms_account_code_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
645	355	2191	1	1	sms_account_phone_account_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
646	355	2191	1	1	sms_account_phone_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
647	355	2191	1	1	sms_account_phone_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
648	356	2191	1	1	sms_account_sender_account_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
649	356	2191	1	1	sms_account_sender_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
650	356	2191	1	1	sms_account_sender_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
651	357	2191	1	1	sms_composer_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
652	357	2191	1	1	sms_composer_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
653	357	2191	1	1	sms_composer_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
654	358	2191	1	1	sms_resend_recipient_sms_resend_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
655	358	2191	1	1	sms_resend_recipient_notification_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
656	358	2191	1	1	sms_resend_recipient_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
657	358	2191	1	1	sms_resend_recipient_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
658	359	2191	1	1	sms_resend_mail_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
659	359	2191	1	1	sms_resend_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
660	359	2191	1	1	sms_resend_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
661	360	2191	1	1	sms_template_preview_sms_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
662	360	2191	1	1	sms_template_preview_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
663	360	2191	1	1	sms_template_preview_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
664	361	2191	1	1	sms_template_sms_template_reset_rel_sms_template_reset_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
665	361	2191	1	1	sms_template_sms_template_reset_rel_sms_template_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
666	361	2191	1	1	sms_template_reset_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
667	361	2191	1	1	sms_template_reset_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
629	353	2191	1	1	sms_tracker_sms_uuid_unique	unique(sms_uuid)	u	{"en_US": "A record for this UUID already exists", "es_419": "Ya existe un registro para este UUID"}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
628	351	2191	1	1	sms_sms_uuid_unique	unique(uuid)	u	{"en_US": "UUID must be unique", "es_419": "El UUID debe ser único."}	2026-01-19 17:38:41.858933	2026-01-19 17:38:41.858933
668	155	2193	1	1	mail_notification_letter_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
669	362	2193	1	1	snailmail_letter_user_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
670	362	2193	1	1	snailmail_letter_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
671	362	2193	1	1	snailmail_letter_company_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
672	362	2193	1	1	snailmail_letter_report_template_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
673	362	2193	1	1	snailmail_letter_attachment_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
674	362	2193	1	1	snailmail_letter_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
675	362	2193	1	1	snailmail_letter_state_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
676	362	2193	1	1	snailmail_letter_country_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
677	362	2193	1	1	snailmail_letter_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
678	362	2193	1	1	snailmail_letter_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
679	363	2193	1	1	snailmail_letter_format_error_message_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
680	363	2193	1	1	snailmail_letter_format_error_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
681	363	2193	1	1	snailmail_letter_format_error_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
682	364	2193	1	1	snailmail_letter_missing_required_fields_partner_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
683	364	2193	1	1	snailmail_letter_missing_required_fields_letter_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
684	364	2193	1	1	snailmail_letter_missing_required_fields_state_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
685	364	2193	1	1	snailmail_letter_missing_required_fields_country_id_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
686	364	2193	1	1	snailmail_letter_missing_required_fields_create_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
687	364	2193	1	1	snailmail_letter_missing_required_fields_write_uid_fkey	\N	f	{"en_US": null}	2026-01-19 17:38:42.759327	2026-01-19 17:38:42.759327
\.


--
-- Data for Name: ir_model_data; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_data (id, create_uid, create_date, write_date, write_uid, res_id, noupdate, name, module, model) FROM stdin;
1	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	1	t	USD	base	res.currency
2	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	1	t	main_company	base	res.company
3	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	1	t	main_partner	base	res.partner
4	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	1	t	user_root	base	res.users
5	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	1	t	group_user	base	res.groups
6	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	1	t	module_category_accounting	base	ir.module.category
7	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	2	t	module_category_accounting_accounting	base	ir.module.category
8	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	1	t	module_account	base	ir.module.module
9	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	3	t	module_category_inventory	base	ir.module.category
10	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	4	t	module_category_inventory_purchase	base	ir.module.category
11	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	2	t	module_account_3way_match	base	ir.module.module
12	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	3	t	module_account_accountant	base	ir.module.module
13	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	4	t	module_account_accountant_batch_payment	base	ir.module.module
14	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	5	t	module_account_accountant_check_printing	base	ir.module.module
15	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	6	t	module_account_accountant_fleet	base	ir.module.module
16	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	7	t	module_account_accountant_ux	base	ir.module.module
17	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	8	t	module_account_add_gln	base	ir.module.module
18	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	5	t	module_category_uncategorized	base	ir.module.category
19	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	9	t	module_account_analytic_distribution_manual	base	ir.module.module
20	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	6	t	module_category_accounting_and_finance	base	ir.module.category
21	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	10	t	module_account_analytic_parent	base	ir.module.module
22	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	7	t	module_category_analytic_accounting	base	ir.module.category
23	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	11	t	module_account_analytic_required	base	ir.module.module
24	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	12	t	module_account_analytic_sequence	base	ir.module.module
25	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	8	t	module_category_account	base	ir.module.category
26	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	13	t	module_account_analytic_spread_by_tag	base	ir.module.module
27	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	14	t	module_account_analytic_tag	base	ir.module.module
28	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	15	t	module_account_asset	base	ir.module.module
29	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	16	t	module_account_asset_fleet	base	ir.module.module
30	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	17	t	module_account_auto_transfer	base	ir.module.module
31	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	18	t	module_account_avatax	base	ir.module.module
32	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	19	t	module_account_avatax_geolocalize	base	ir.module.module
33	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	20	t	module_account_avatax_sale	base	ir.module.module
34	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	21	t	module_account_avatax_stock	base	ir.module.module
35	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	22	t	module_account_background_post	base	ir.module.module
36	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	9	t	module_category_planner	base	ir.module.category
37	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	23	t	module_account_balance_import	base	ir.module.module
38	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	24	t	module_account_bank_statement_extract	base	ir.module.module
39	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	25	t	module_account_bank_statement_import	base	ir.module.module
40	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	26	t	module_account_bank_statement_import_camt	base	ir.module.module
41	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	27	t	module_account_bank_statement_import_csv	base	ir.module.module
42	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	28	t	module_account_bank_statement_import_ofx	base	ir.module.module
43	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	29	t	module_account_bank_statement_import_qif	base	ir.module.module
44	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	30	t	module_account_base_import	base	ir.module.module
45	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	31	t	module_account_batch_payment	base	ir.module.module
46	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	32	t	module_account_batch_payment_ux	base	ir.module.module
47	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	33	t	module_account_billing	base	ir.module.module
48	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	10	t	module_category_accounting_management	base	ir.module.category
49	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	34	t	module_account_brand	base	ir.module.module
50	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	35	t	module_account_budget	base	ir.module.module
51	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	36	t	module_account_cashbox	base	ir.module.module
52	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	37	t	module_account_cashbox_l10n_latam_check	base	ir.module.module
53	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	38	t	module_account_check_printing	base	ir.module.module
54	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	39	t	module_account_debit_note	base	ir.module.module
55	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	11	t	module_category_account_reporting	base	ir.module.category
56	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	40	t	module_account_debt_report	base	ir.module.module
57	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	41	t	module_account_direct_debit	base	ir.module.module
58	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	42	t	module_account_disallowed_expenses	base	ir.module.module
59	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	43	t	module_account_disallowed_expenses_fleet	base	ir.module.module
60	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	44	t	module_account_edi	base	ir.module.module
61	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	45	t	module_account_edi_proxy_client	base	ir.module.module
62	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	46	t	module_account_edi_ubl_cii	base	ir.module.module
63	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	47	t	module_account_edi_ubl_cii_tax_extension	base	ir.module.module
64	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	48	t	module_account_exchange_difference_invoice	base	ir.module.module
65	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	49	t	module_account_external_tax	base	ir.module.module
66	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	50	t	module_account_extract	base	ir.module.module
67	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	51	t	module_account_financial_amount	base	ir.module.module
68	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	52	t	module_account_fleet	base	ir.module.module
69	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	53	t	module_account_followup	base	ir.module.module
70	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	54	t	module_account_followup_ux	base	ir.module.module
71	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	55	t	module_account_global_discount	base	ir.module.module
72	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	56	t	module_account_in_payment	base	ir.module.module
73	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	12	t	module_category_productivity	base	ir.module.category
74	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	57	t	module_account_inter_company_rules	base	ir.module.module
75	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	58	t	module_account_interbanking_statement	base	ir.module.module
76	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	59	t	module_account_interests	base	ir.module.module
77	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	60	t	module_account_internal_transfer	base	ir.module.module
78	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	61	t	module_account_intrastat	base	ir.module.module
79	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	62	t	module_account_intrastat_services	base	ir.module.module
80	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	63	t	module_account_invoice_auto_send_by_email	base	ir.module.module
81	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	64	t	module_account_invoice_bank_brand	base	ir.module.module
82	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	65	t	module_account_invoice_check_total	base	ir.module.module
83	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	66	t	module_account_invoice_commission	base	ir.module.module
84	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	67	t	module_account_invoice_control	base	ir.module.module
85	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	68	t	module_account_invoice_crm_tag	base	ir.module.module
86	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	69	t	module_account_invoice_date_due	base	ir.module.module
87	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	70	t	module_account_invoice_extract	base	ir.module.module
88	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	71	t	module_account_invoice_extract_purchase	base	ir.module.module
89	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	72	t	module_account_invoice_fiscal_position_update	base	ir.module.module
90	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	73	t	module_account_invoice_fixed_discount	base	ir.module.module
91	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	74	t	module_account_invoice_line_number	base	ir.module.module
92	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	75	t	module_account_invoice_partial	base	ir.module.module
93	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	76	t	module_account_invoice_payment_term_date_due	base	ir.module.module
94	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	77	t	module_account_invoice_pricelist	base	ir.module.module
95	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	13	t	module_category_sales	base	ir.module.category
96	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	78	t	module_account_invoice_pricelist_sale	base	ir.module.module
97	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	79	t	module_account_invoice_prices_update	base	ir.module.module
98	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	80	t	module_account_invoice_refund_link	base	ir.module.module
99	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	81	t	module_account_invoice_refund_reason	base	ir.module.module
100	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	82	t	module_account_invoice_section_sale_order	base	ir.module.module
101	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	83	t	module_account_invoice_show_currency_rate	base	ir.module.module
102	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	84	t	module_account_invoice_supplier_ref_unique	base	ir.module.module
103	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	85	t	module_account_invoice_supplierinfo_update	base	ir.module.module
104	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	14	t	module_category_localization	base	ir.module.category
105	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	86	t	module_account_invoice_tax	base	ir.module.module
106	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	15	t	module_category_localization_	base	ir.module.category
107	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	16	t	module_category_localization___accounting	base	ir.module.category
108	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	87	t	module_account_invoice_tax_required	base	ir.module.module
109	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	88	t	module_account_invoice_transmit_method	base	ir.module.module
110	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	89	t	module_account_invoice_transmit_method_substitution_rule	base	ir.module.module
111	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	90	t	module_account_invoice_tree_currency	base	ir.module.module
112	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	91	t	module_account_invoice_triple_discount	base	ir.module.module
113	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	92	t	module_account_invoice_warn_message	base	ir.module.module
114	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	93	t	module_account_iso20022	base	ir.module.module
115	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	17	t	module_category_localization_accounting	base	ir.module.category
116	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	94	t	module_account_journal_book_report	base	ir.module.module
117	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	95	t	module_account_journal_security	base	ir.module.module
118	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	96	t	module_account_loans	base	ir.module.module
119	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	97	t	module_account_mail_autosubscribe	base	ir.module.module
120	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	98	t	module_account_manual_currency	base	ir.module.module
121	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	99	t	module_account_move_analytic_link	base	ir.module.module
122	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	100	t	module_account_move_auto_post_ref	base	ir.module.module
123	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	18	t	module_category_finance	base	ir.module.category
124	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	101	t	module_account_move_base_import	base	ir.module.module
125	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	19	t	module_category_usability	base	ir.module.category
126	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	102	t	module_account_move_cancel_confirm	base	ir.module.module
127	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	20	t	module_category_manufacture	base	ir.module.category
128	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	103	t	module_account_move_line_mrp_info	base	ir.module.module
129	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	21	t	module_category_warehouse_management	base	ir.module.category
130	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	104	t	module_account_move_line_stock_info	base	ir.module.module
131	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	105	t	module_account_move_reconcile_forbid_cancel	base	ir.module.module
132	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	22	t	module_category_accounts	base	ir.module.category
133	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	106	t	module_account_move_tier_validation	base	ir.module.module
134	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	107	t	module_account_move_tier_validation_approver	base	ir.module.module
135	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	108	t	module_account_move_update_analytic	base	ir.module.module
136	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	109	t	module_account_multi_store	base	ir.module.module
137	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	110	t	module_account_multicompany_ux	base	ir.module.module
138	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	111	t	module_account_multicurrency_ux	base	ir.module.module
139	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	112	t	module_account_no_followup	base	ir.module.module
140	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	113	t	module_account_online_payment	base	ir.module.module
141	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	114	t	module_account_online_synchronization	base	ir.module.module
142	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	115	t	module_account_partner_company_group	base	ir.module.module
143	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	116	t	module_account_partner_reconcile	base	ir.module.module
144	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	117	t	module_account_payment	base	ir.module.module
145	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	23	t	module_category_payment	base	ir.module.category
146	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	118	t	module_account_payment_financial_surcharge	base	ir.module.module
147	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	119	t	module_account_payment_loan	base	ir.module.module
148	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	120	t	module_account_payment_mode_brand	base	ir.module.module
149	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	24	t	module_category_technical	base	ir.module.category
150	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	121	t	module_account_payment_multi	base	ir.module.module
151	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	122	t	module_account_payment_pro	base	ir.module.module
152	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	123	t	module_account_payment_pro_multi_store	base	ir.module.module
153	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	124	t	module_account_payment_pro_receiptbook	base	ir.module.module
154	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	125	t	module_account_payment_term_surcharge	base	ir.module.module
155	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	126	t	module_account_payment_ux	base	ir.module.module
156	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	127	t	module_account_peppol	base	ir.module.module
157	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	25	t	module_category_accounting_payment	base	ir.module.category
158	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	128	t	module_account_qr_code_emv	base	ir.module.module
159	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	129	t	module_account_qr_code_sepa	base	ir.module.module
160	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	130	t	module_account_receipt_journal	base	ir.module.module
161	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	131	t	module_account_reconcile_analytic_tag	base	ir.module.module
162	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	132	t	module_account_reconcile_model_oca	base	ir.module.module
163	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	133	t	module_account_reconcile_oca	base	ir.module.module
164	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	134	t	module_account_reconcile_oca_queue	base	ir.module.module
165	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	135	t	module_account_reports	base	ir.module.module
166	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	136	t	module_account_reports_cash_basis	base	ir.module.module
167	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	137	t	module_account_reports_multicurrency	base	ir.module.module
168	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	138	t	module_account_saft	base	ir.module.module
169	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	139	t	module_account_saft_import	base	ir.module.module
170	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	140	t	module_account_sepa_direct_debit	base	ir.module.module
171	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	141	t	module_account_statement_base	base	ir.module.module
172	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	142	t	module_account_statement_base_ux	base	ir.module.module
173	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	143	t	module_account_statement_import_base	base	ir.module.module
174	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	26	t	module_category_banking_addons	base	ir.module.category
175	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	144	t	module_account_statement_import_camt	base	ir.module.module
176	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	145	t	module_account_statement_import_camt54	base	ir.module.module
177	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	146	t	module_account_statement_import_file	base	ir.module.module
178	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	147	t	module_account_statement_import_file_reconcile_oca	base	ir.module.module
179	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	148	t	module_account_statement_import_move_line	base	ir.module.module
180	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	149	t	module_account_statement_import_ofx	base	ir.module.module
181	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	150	t	module_account_statement_import_online	base	ir.module.module
182	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	151	t	module_account_statement_import_online_gocardless	base	ir.module.module
183	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	152	t	module_account_statement_import_online_paypal	base	ir.module.module
184	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	153	t	module_account_statement_import_online_plaid	base	ir.module.module
185	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	154	t	module_account_statement_import_online_ponto	base	ir.module.module
186	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	155	t	module_account_statement_import_online_stripe	base	ir.module.module
187	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	156	t	module_account_statement_import_sheet_file	base	ir.module.module
188	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	27	t	module_category_productivity_documents	base	ir.module.category
189	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	157	t	module_account_statement_import_sheet_file_bg	base	ir.module.module
190	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	158	t	module_account_tax_group_widget_base_amount	base	ir.module.module
191	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	159	t	module_account_tax_legal_notes_translate	base	ir.module.module
192	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	160	t	module_account_tax_python	base	ir.module.module
193	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	161	t	module_account_tax_settlement	base	ir.module.module
194	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	162	t	module_account_test	base	ir.module.module
195	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	163	t	module_account_update_tax_tags	base	ir.module.module
196	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	164	t	module_account_ux	base	ir.module.module
197	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	165	t	module_account_winbooks_import	base	ir.module.module
198	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	166	t	module_accountant	base	ir.module.module
199	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	167	t	module_accountant_internal_transfer	base	ir.module.module
200	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	28	t	module_category_ai	base	ir.module.category
201	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	168	t	module_ai_agent	base	ir.module.module
202	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	169	t	module_ai_agent_knowledge	base	ir.module.module
203	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	170	t	module_ai_agent_litellm	base	ir.module.module
204	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	171	t	module_ai_agent_website	base	ir.module.module
205	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	172	t	module_ai_meeting_notes	base	ir.module.module
206	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	173	t	module_analytic	base	ir.module.module
207	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	29	t	module_category_generic_modules	base	ir.module.category
208	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	30	t	module_category_generic_modules_projects_and_services	base	ir.module.category
209	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	174	t	module_analytic_base_department	base	ir.module.module
210	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	175	t	module_analytic_brand	base	ir.module.module
211	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	176	t	module_analytic_enterprise	base	ir.module.module
212	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	177	t	module_analytic_hr_department_restriction	base	ir.module.module
213	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	178	t	module_animal	base	ir.module.module
214	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	31	t	module_category_server_ux	base	ir.module.category
215	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	179	t	module_announcement	base	ir.module.module
216	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	32	t	module_category_services	base	ir.module.category
217	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	33	t	module_category_services_appointment	base	ir.module.category
218	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	180	t	module_appointment	base	ir.module.module
219	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	34	t	module_category_marketing	base	ir.module.category
220	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	35	t	module_category_marketing_online_appointment	base	ir.module.category
221	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	181	t	module_appointment_account_payment	base	ir.module.module
222	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	182	t	module_appointment_crm	base	ir.module.module
223	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	183	t	module_appointment_google_calendar	base	ir.module.module
224	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	184	t	module_appointment_google_reserve	base	ir.module.module
225	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	185	t	module_appointment_hr	base	ir.module.module
226	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	186	t	module_appointment_hr_recruitment	base	ir.module.module
227	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	187	t	module_appointment_microsoft_calendar	base	ir.module.module
228	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	188	t	module_appointment_sms	base	ir.module.module
229	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	36	t	module_category_human_resources	base	ir.module.category
230	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	37	t	module_category_human_resources_approvals	base	ir.module.category
231	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	189	t	module_approvals	base	ir.module.module
232	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	190	t	module_approvals_purchase	base	ir.module.module
233	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	191	t	module_approvals_purchase_stock	base	ir.module.module
234	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	38	t	module_category_hidden	base	ir.module.category
235	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	39	t	module_category_hidden_tools	base	ir.module.category
236	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	192	t	module_attachment_indexation	base	ir.module.module
237	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	40	t	module_category_knowledge_management	base	ir.module.category
238	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	193	t	module_attachment_preview	base	ir.module.module
239	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	194	t	module_attachment_queue	base	ir.module.module
240	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	195	t	module_attachment_synchronize	base	ir.module.module
241	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	41	t	module_category_tools	base	ir.module.category
242	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	196	t	module_attachment_unindex_content	base	ir.module.module
243	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	197	t	module_attachment_zipped_download	base	ir.module.module
244	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	198	t	module_auditlog	base	ir.module.module
245	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	42	t	module_category_base	base	ir.module.category
246	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	199	t	module_auth_admin_passkey	base	ir.module.module
247	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	200	t	module_auth_api_key	base	ir.module.module
248	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	201	t	module_auth_api_key_group	base	ir.module.module
249	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	202	t	module_auth_api_key_server_env	base	ir.module.module
250	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	203	t	module_auth_jwt	base	ir.module.module
251	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	204	t	module_auth_jwt_demo	base	ir.module.module
252	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	205	t	module_auth_ldap	base	ir.module.module
253	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	206	t	module_auth_oauth	base	ir.module.module
254	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	207	t	module_auth_oauth_filter_by_domain	base	ir.module.module
255	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	43	t	module_category_tool	base	ir.module.category
256	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	208	t	module_auth_oauth_multi_token	base	ir.module.module
257	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	209	t	module_auth_oidc	base	ir.module.module
258	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	210	t	module_auth_oidc_environment	base	ir.module.module
259	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	211	t	module_auth_passkey	base	ir.module.module
260	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	212	t	module_auth_password_policy	base	ir.module.module
261	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	213	t	module_auth_password_policy_portal	base	ir.module.module
262	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	214	t	module_auth_password_policy_signup	base	ir.module.module
263	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	215	t	module_auth_saml	base	ir.module.module
264	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	216	t	module_auth_session_timeout	base	ir.module.module
265	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	217	t	module_auth_signup	base	ir.module.module
266	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	44	t	module_category_authentication	base	ir.module.category
267	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	218	t	module_auth_signup_verify_email	base	ir.module.module
268	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	45	t	module_category_extra_tools	base	ir.module.category
269	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	219	t	module_auth_totp	base	ir.module.module
270	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	220	t	module_auth_totp_mail	base	ir.module.module
271	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	221	t	module_auth_totp_mail_enforce	base	ir.module.module
272	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	222	t	module_auth_totp_portal	base	ir.module.module
273	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	223	t	module_auth_user_case_insensitive	base	ir.module.module
274	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	224	t	module_auto_backup	base	ir.module.module
275	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	225	t	module_autovacuum_message_attachment	base	ir.module.module
276	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	226	t	module_barcode_action	base	ir.module.module
277	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	227	t	module_barcodes	base	ir.module.module
278	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	228	t	module_barcodes_generator_abstract	base	ir.module.module
279	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	229	t	module_barcodes_gs1_nomenclature	base	ir.module.module
280	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	230	t	module_base	base	ir.module.module
281	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	231	t	module_base_address_extended	base	ir.module.module
282	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	232	t	module_base_algolia_search	base	ir.module.module
283	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	46	t	module_category_sales_sales	base	ir.module.category
284	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	233	t	module_base_automation	base	ir.module.module
285	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	234	t	module_base_automation_hr_contract	base	ir.module.module
286	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	235	t	module_base_bg	base	ir.module.module
287	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	236	t	module_base_cancel_confirm	base	ir.module.module
288	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	47	t	module_category_reporting	base	ir.module.category
289	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	237	t	module_base_comment_template	base	ir.module.module
290	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	238	t	module_base_country_state_translatable	base	ir.module.module
291	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	239	t	module_base_cron_exclusion	base	ir.module.module
292	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	240	t	module_base_custom_filter	base	ir.module.module
293	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	241	t	module_base_dynamic_message	base	ir.module.module
294	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	242	t	module_base_exception	base	ir.module.module
295	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	48	t	module_category_personalization	base	ir.module.category
296	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	243	t	module_base_export_manager	base	ir.module.module
297	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	244	t	module_base_external_dbsource	base	ir.module.module
298	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	245	t	module_base_external_dbsource_mssql	base	ir.module.module
299	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	246	t	module_base_external_dbsource_mysql	base	ir.module.module
300	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	247	t	module_base_fontawesome	base	ir.module.module
301	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	248	t	module_base_fontawesome_web_editor	base	ir.module.module
302	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	249	t	module_base_force_record_noupdate	base	ir.module.module
303	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	250	t	module_base_geolocalize	base	ir.module.module
304	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	251	t	module_base_global_discount	base	ir.module.module
305	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	252	t	module_base_iban	base	ir.module.module
306	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	253	t	module_base_import	base	ir.module.module
307	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	254	t	module_base_import_match	base	ir.module.module
308	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	255	t	module_base_import_module	base	ir.module.module
309	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	49	t	module_category_server_tools	base	ir.module.category
310	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	256	t	module_base_import_security_group	base	ir.module.module
311	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	257	t	module_base_install_request	base	ir.module.module
312	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	258	t	module_base_location	base	ir.module.module
313	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	50	t	module_category_partner_management	base	ir.module.category
314	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	259	t	module_base_location_geonames_import	base	ir.module.module
315	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	51	t	module_category_localization_europe	base	ir.module.category
316	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	260	t	module_base_location_nuts	base	ir.module.module
317	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	52	t	module_category_technical_settings	base	ir.module.category
318	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	261	t	module_base_m2m_custom_field	base	ir.module.module
319	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	262	t	module_base_menu_visibility_restriction	base	ir.module.module
320	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	53	t	module_category_others	base	ir.module.category
321	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	263	t	module_base_model_restrict_update	base	ir.module.module
322	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	264	t	module_base_multi_store	base	ir.module.module
323	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	265	t	module_base_name_search_improved	base	ir.module.module
324	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	266	t	module_base_optional_quick_create	base	ir.module.module
325	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	267	t	module_base_partition	base	ir.module.module
326	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	268	t	module_base_partner_company_group	base	ir.module.module
327	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	54	t	module_category_generic_modules_base	base	ir.module.category
328	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	269	t	module_base_partner_sequence	base	ir.module.module
329	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	270	t	module_base_portal_type	base	ir.module.module
330	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	271	t	module_base_remote	base	ir.module.module
331	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	272	t	module_base_report_to_label_printer	base	ir.module.module
332	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	273	t	module_base_report_to_print_node	base	ir.module.module
333	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	274	t	module_base_report_to_printer	base	ir.module.module
334	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	55	t	module_category_reporting_subsystem	base	ir.module.category
335	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	275	t	module_base_report_to_printer_aeroo	base	ir.module.module
336	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	276	t	module_base_report_to_printer_mail	base	ir.module.module
337	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	277	t	module_base_revision	base	ir.module.module
338	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	278	t	module_base_search_custom_field_filter	base	ir.module.module
339	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	279	t	module_base_search_fuzzy	base	ir.module.module
340	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	280	t	module_base_sequence_option	base	ir.module.module
341	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	281	t	module_base_setup	base	ir.module.module
342	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	282	t	module_base_sparse_field	base	ir.module.module
343	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	283	t	module_base_sparse_field_list_support	base	ir.module.module
344	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	284	t	module_base_substate	base	ir.module.module
345	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	285	t	module_base_technical_features	base	ir.module.module
346	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	56	t	module_category_hidden_dependency	base	ir.module.category
347	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	286	t	module_base_technical_user	base	ir.module.module
348	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	287	t	module_base_temporary_action	base	ir.module.module
349	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	288	t	module_base_tier_validation	base	ir.module.module
350	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	289	t	module_base_tier_validation_correction	base	ir.module.module
351	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	290	t	module_base_tier_validation_formula	base	ir.module.module
352	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	291	t	module_base_tier_validation_forward	base	ir.module.module
353	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	292	t	module_base_tier_validation_server_action	base	ir.module.module
354	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	293	t	module_base_time_window	base	ir.module.module
355	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	294	t	module_base_transaction_id	base	ir.module.module
356	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	295	t	module_base_user_empty_password	base	ir.module.module
357	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	296	t	module_base_user_role	base	ir.module.module
358	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	297	t	module_base_user_role_company	base	ir.module.module
359	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	298	t	module_base_user_role_history	base	ir.module.module
360	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	299	t	module_base_user_show_email	base	ir.module.module
361	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	300	t	module_base_ux	base	ir.module.module
362	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	301	t	module_base_vat	base	ir.module.module
363	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	302	t	module_base_view_inheritance_extension	base	ir.module.module
364	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	303	t	module_bi_sql_editor	base	ir.module.module
365	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	304	t	module_board	base	ir.module.module
366	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	305	t	module_brand	base	ir.module.module
367	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	306	t	module_buk_connector	base	ir.module.module
368	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	307	t	module_bus	base	ir.module.module
369	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	308	t	module_bus_alt_connection	base	ir.module.module
370	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	57	t	module_category_productivity_calendar	base	ir.module.category
371	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	309	t	module_calendar	base	ir.module.module
372	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	310	t	module_calendar_sms	base	ir.module.module
373	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	58	t	module_category_call_center	base	ir.module.category
374	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	311	t	module_call_center_whatsapp	base	ir.module.module
375	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	312	t	module_card_installment	base	ir.module.module
376	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	313	t	module_certificate	base	ir.module.module
377	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	314	t	module_chained_swapper	base	ir.module.module
378	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	315	t	module_clarity_backend	base	ir.module.module
379	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	316	t	module_cloud_storage	base	ir.module.module
380	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	317	t	module_cloud_storage_azure	base	ir.module.module
381	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	318	t	module_cloud_storage_google	base	ir.module.module
382	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	319	t	module_cloud_storage_migration	base	ir.module.module
383	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	320	t	module_connector_fintoc	base	ir.module.module
384	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	59	t	module_category_sales_crm	base	ir.module.category
385	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	321	t	module_contacts	base	ir.module.module
386	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	322	t	module_contacts_enterprise	base	ir.module.module
387	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	323	t	module_contract_brand	base	ir.module.module
388	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	324	t	module_contract_forecast_brand	base	ir.module.module
389	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	325	t	module_contract_payment_mode_brand	base	ir.module.module
390	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	326	t	module_crm	base	ir.module.module
391	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	60	t	module_category_customer_relationship_management	base	ir.module.category
392	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	327	t	module_crm_claim	base	ir.module.module
393	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	328	t	module_crm_date_deadline_required	base	ir.module.module
394	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	329	t	module_crm_enterprise	base	ir.module.module
395	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	61	t	module_category_website	base	ir.module.category
396	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	62	t	module_category_website_website	base	ir.module.category
397	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	330	t	module_crm_enterprise_partner_assign	base	ir.module.module
398	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	63	t	module_category_services_helpdesk	base	ir.module.category
399	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	331	t	module_crm_helpdesk	base	ir.module.module
400	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	332	t	module_crm_iap_enrich	base	ir.module.module
401	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	333	t	module_crm_iap_mine	base	ir.module.module
402	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	334	t	module_crm_industry	base	ir.module.module
403	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	335	t	module_crm_lead_code	base	ir.module.module
404	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	336	t	module_crm_lead_currency	base	ir.module.module
405	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	337	t	module_crm_lead_firstname	base	ir.module.module
406	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	338	t	module_crm_lead_product	base	ir.module.module
407	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	64	t	module_category_project	base	ir.module.category
408	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	339	t	module_crm_lead_to_task	base	ir.module.module
409	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	340	t	module_crm_lead_vat	base	ir.module.module
410	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	341	t	module_crm_livechat	base	ir.module.module
411	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	342	t	module_crm_location	base	ir.module.module
412	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	343	t	module_crm_mail_plugin	base	ir.module.module
413	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	344	t	module_crm_partner_assign	base	ir.module.module
414	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	345	t	module_crm_partner_company_group	base	ir.module.module
415	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	346	t	module_crm_partner_required	base	ir.module.module
416	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	347	t	module_crm_phonecall	base	ir.module.module
417	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	348	t	module_crm_phonecall_planner	base	ir.module.module
418	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	349	t	module_crm_phonecall_result	base	ir.module.module
419	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	350	t	module_crm_phonecall_summary_predefined	base	ir.module.module
420	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	351	t	module_crm_project_create	base	ir.module.module
421	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	352	t	module_crm_sale_subscription	base	ir.module.module
422	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	353	t	module_crm_sale_ux	base	ir.module.module
423	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	354	t	module_crm_salesperson_planner	base	ir.module.module
424	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	355	t	module_crm_security_group	base	ir.module.module
425	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	356	t	module_crm_sms	base	ir.module.module
426	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	357	t	module_crm_stage_mail	base	ir.module.module
427	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	358	t	module_crm_stage_multi_team	base	ir.module.module
428	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	359	t	module_crm_stage_multi_teams	base	ir.module.module
429	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	360	t	module_crm_stage_probability	base	ir.module.module
430	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	65	t	module_category_human_resources_survey	base	ir.module.category
431	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	361	t	module_crm_survey	base	ir.module.module
432	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	362	t	module_crm_team_parent	base	ir.module.module
433	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	363	t	module_crm_timesheet	base	ir.module.module
434	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	364	t	module_crm_won_restrict_per_stage	base	ir.module.module
435	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	365	t	module_currency_rate_live	base	ir.module.module
436	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	66	t	module_category_productivity_data_cleaning	base	ir.module.category
437	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	366	t	module_data_cleaning	base	ir.module.module
438	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	367	t	module_data_merge_crm	base	ir.module.module
439	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	368	t	module_data_merge_helpdesk	base	ir.module.module
440	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	369	t	module_data_merge_project	base	ir.module.module
441	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	370	t	module_data_merge_stock_account	base	ir.module.module
442	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	371	t	module_data_merge_utm	base	ir.module.module
443	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	372	t	module_data_recycle	base	ir.module.module
444	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	373	t	module_database_cleanup	base	ir.module.module
445	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	374	t	module_database_size	base	ir.module.module
446	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	375	t	module_date_range	base	ir.module.module
447	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	376	t	module_date_range_account	base	ir.module.module
448	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	377	t	module_dbfilter_from_header	base	ir.module.module
449	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	378	t	module_default_multi_user	base	ir.module.module
450	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	67	t	module_category_sales_delivery	base	ir.module.category
451	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	379	t	module_delivery	base	ir.module.module
452	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	68	t	module_category_operations	base	ir.module.category
453	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	69	t	module_category_operations_inventory	base	ir.module.category
454	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	70	t	module_category_operations_inventory_delivery	base	ir.module.category
455	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	380	t	module_delivery_andreani	base	ir.module.module
456	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	71	t	module_category_inventory_delivery	base	ir.module.category
457	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	381	t	module_delivery_bpost	base	ir.module.module
458	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	382	t	module_delivery_dhl	base	ir.module.module
459	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	383	t	module_delivery_dhl_rest	base	ir.module.module
460	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	384	t	module_delivery_easypost	base	ir.module.module
461	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	385	t	module_delivery_envia	base	ir.module.module
462	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	386	t	module_delivery_fedex	base	ir.module.module
463	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	387	t	module_delivery_fedex_rest	base	ir.module.module
464	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	72	t	module_category_manufacturing	base	ir.module.category
465	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	73	t	module_category_manufacturing_internet_of_things_(iot)	base	ir.module.category
466	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	388	t	module_delivery_iot	base	ir.module.module
467	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	389	t	module_delivery_mondialrelay	base	ir.module.module
468	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	390	t	module_delivery_procurement_group_carrier	base	ir.module.module
469	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	391	t	module_delivery_sendcloud	base	ir.module.module
470	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	392	t	module_delivery_shiprocket	base	ir.module.module
471	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	393	t	module_delivery_starshipit	base	ir.module.module
472	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	394	t	module_delivery_stock_picking_batch	base	ir.module.module
473	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	395	t	module_delivery_total_weight_from_packaging	base	ir.module.module
474	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	396	t	module_delivery_ups	base	ir.module.module
475	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	397	t	module_delivery_ups_rest	base	ir.module.module
476	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	398	t	module_delivery_usps	base	ir.module.module
477	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	399	t	module_delivery_usps_rest	base	ir.module.module
478	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	400	t	module_delivery_ux	base	ir.module.module
479	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	401	t	module_demo_base	base	ir.module.module
480	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	402	t	module_demo_base_minimal	base	ir.module.module
481	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	403	t	module_demo_full	base	ir.module.module
482	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	404	t	module_demo_mrp	base	ir.module.module
483	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	405	t	module_demo_rental	base	ir.module.module
484	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	406	t	module_demo_services	base	ir.module.module
485	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	407	t	module_demo_services_minimal	base	ir.module.module
486	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	408	t	module_demo_wholesale	base	ir.module.module
487	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	409	t	module_demo_wholesale_minimal	base	ir.module.module
488	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	410	t	module_developer_menu	base	ir.module.module
489	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	411	t	module_digest	base	ir.module.module
490	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	412	t	module_digest_enterprise	base	ir.module.module
491	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	74	t	module_category_knowledge	base	ir.module.category
492	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	413	t	module_document_knowledge	base	ir.module.module
493	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	414	t	module_document_page	base	ir.module.module
494	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	75	t	module_category_document_knowledge	base	ir.module.category
495	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	415	t	module_document_page_access_group	base	ir.module.module
496	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	416	t	module_document_page_access_group_user_role	base	ir.module.module
497	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	417	t	module_document_page_approval	base	ir.module.module
498	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	76	t	module_category_generic_modules_others	base	ir.module.category
499	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	418	t	module_document_page_environment_manual	base	ir.module.module
500	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	419	t	module_document_page_environmental_aspect	base	ir.module.module
501	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	420	t	module_document_page_group	base	ir.module.module
502	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	421	t	module_document_page_health_safety_manual	base	ir.module.module
503	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	422	t	module_document_page_partner	base	ir.module.module
504	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	77	t	module_category_management_system	base	ir.module.category
505	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	423	t	module_document_page_procedure	base	ir.module.module
506	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	424	t	module_document_page_project	base	ir.module.module
507	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	425	t	module_document_page_quality_manual	base	ir.module.module
508	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	426	t	module_document_page_reference	base	ir.module.module
509	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	427	t	module_document_page_tag	base	ir.module.module
510	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	428	t	module_document_page_work_instruction	base	ir.module.module
511	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	429	t	module_document_quick_access	base	ir.module.module
512	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	430	t	module_document_quick_access_folder_auto_classification	base	ir.module.module
513	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	431	t	module_document_url	base	ir.module.module
514	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	432	t	module_documents	base	ir.module.module
515	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	433	t	module_documents_account	base	ir.module.module
516	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	434	t	module_documents_account_bg	base	ir.module.module
517	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	435	t	module_documents_account_peppol	base	ir.module.module
518	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	436	t	module_documents_approvals	base	ir.module.module
519	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	437	t	module_documents_fleet	base	ir.module.module
520	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	438	t	module_documents_fsm	base	ir.module.module
521	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	439	t	module_documents_hr	base	ir.module.module
522	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	440	t	module_documents_hr_contract	base	ir.module.module
523	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	441	t	module_documents_hr_expense	base	ir.module.module
524	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	442	t	module_documents_hr_holidays	base	ir.module.module
525	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	443	t	module_documents_hr_payroll	base	ir.module.module
526	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	444	t	module_documents_hr_recruitment	base	ir.module.module
527	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	78	t	module_category_human_resources_payroll	base	ir.module.category
528	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	445	t	module_documents_l10n_be_hr_payroll	base	ir.module.module
529	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	446	t	module_documents_l10n_ch_hr_payroll	base	ir.module.module
530	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	447	t	module_documents_l10n_hk_hr_payroll	base	ir.module.module
531	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	448	t	module_documents_l10n_ke_hr_payroll	base	ir.module.module
532	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	449	t	module_documents_product	base	ir.module.module
533	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	450	t	module_documents_project	base	ir.module.module
534	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	451	t	module_documents_project_sale	base	ir.module.module
535	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	452	t	module_documents_project_sign	base	ir.module.module
536	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	453	t	module_documents_sign	base	ir.module.module
537	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	454	t	module_documents_spreadsheet	base	ir.module.module
538	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	455	t	module_documents_spreadsheet_cashflow	base	ir.module.module
539	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	79	t	module_category_marketing_events	base	ir.module.category
540	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	456	t	module_event	base	ir.module.module
541	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	457	t	module_event_booth	base	ir.module.module
542	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	458	t	module_event_booth_sale	base	ir.module.module
543	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	459	t	module_event_crm	base	ir.module.module
544	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	460	t	module_event_crm_sale	base	ir.module.module
545	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	461	t	module_event_enterprise	base	ir.module.module
546	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	462	t	module_event_product	base	ir.module.module
547	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	463	t	module_event_sale	base	ir.module.module
548	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	464	t	module_event_sms	base	ir.module.module
549	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	80	t	module_category_marketing_social	base	ir.module.category
550	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	465	t	module_event_social	base	ir.module.module
551	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	466	t	module_excel_import_export	base	ir.module.module
552	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	467	t	module_export_bg	base	ir.module.module
553	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	468	t	module_facebook_pixel_tracking	base	ir.module.module
554	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	469	t	module_fetchmail_attach_from_folder	base	ir.module.module
555	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	470	t	module_fetchmail_notify_error_to_sender	base	ir.module.module
556	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	471	t	module_filter_multi_user	base	ir.module.module
557	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	81	t	module_category_human_resources_fleet	base	ir.module.category
558	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	472	t	module_fleet	base	ir.module.module
559	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	82	t	module_category_human_resources_frontdesk	base	ir.module.category
560	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	473	t	module_frontdesk	base	ir.module.module
561	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	474	t	module_gamification	base	ir.module.module
562	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	475	t	module_gamification_sale_crm	base	ir.module.module
563	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	476	t	module_google_account	base	ir.module.module
564	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	477	t	module_google_calendar	base	ir.module.module
565	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	478	t	module_google_gmail	base	ir.module.module
566	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	479	t	module_google_recaptcha	base	ir.module.module
567	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	480	t	module_google_service	base	ir.module.module
568	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	481	t	module_google_tag_manager_advanced_tracking	base	ir.module.module
569	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	482	t	module_helpdesk	base	ir.module.module
570	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	483	t	module_helpdesk_account	base	ir.module.module
571	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	484	t	module_helpdesk_fsm	base	ir.module.module
572	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	485	t	module_helpdesk_fsm_report	base	ir.module.module
573	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	486	t	module_helpdesk_fsm_sale	base	ir.module.module
574	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	487	t	module_helpdesk_holidays	base	ir.module.module
575	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	488	t	module_helpdesk_mail_plugin	base	ir.module.module
576	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	489	t	module_helpdesk_repair	base	ir.module.module
577	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	490	t	module_helpdesk_sale	base	ir.module.module
578	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	491	t	module_helpdesk_sale_loyalty	base	ir.module.module
579	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	492	t	module_helpdesk_sale_timesheet	base	ir.module.module
580	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	493	t	module_helpdesk_sms	base	ir.module.module
581	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	83	t	module_category_projects_and_services	base	ir.module.category
582	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	494	t	module_helpdesk_solutions	base	ir.module.module
583	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	495	t	module_helpdesk_solutions_project	base	ir.module.module
584	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	496	t	module_helpdesk_stock	base	ir.module.module
585	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	497	t	module_helpdesk_stock_account	base	ir.module.module
586	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	498	t	module_helpdesk_stock_ux	base	ir.module.module
587	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	499	t	module_helpdesk_subticket	base	ir.module.module
588	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	500	t	module_helpdesk_timesheet	base	ir.module.module
589	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	501	t	module_helpdesk_timesheet_ux	base	ir.module.module
590	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	502	t	module_helpdesk_ux	base	ir.module.module
591	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	84	t	module_category_human_resources_employees	base	ir.module.category
592	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	503	t	module_hr	base	ir.module.module
593	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	85	t	module_category_human_resources_appraisals	base	ir.module.category
594	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	504	t	module_hr_appraisal	base	ir.module.module
595	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	505	t	module_hr_appraisal_contract	base	ir.module.module
596	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	506	t	module_hr_appraisal_oca	base	ir.module.module
597	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	507	t	module_hr_appraisal_skills	base	ir.module.module
598	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	508	t	module_hr_appraisal_survey	base	ir.module.module
599	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	86	t	module_category_human_resources_attendances	base	ir.module.category
600	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	509	t	module_hr_attendance	base	ir.module.module
601	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	510	t	module_hr_attendance_gantt	base	ir.module.module
602	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	511	t	module_hr_calendar	base	ir.module.module
603	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	87	t	module_category_human_resources_contracts	base	ir.module.category
604	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	512	t	module_hr_contract	base	ir.module.module
605	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	513	t	module_hr_contract_employee_calendar_planning	base	ir.module.module
606	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	88	t	module_category_generic_modules_human_resources	base	ir.module.category
607	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	514	t	module_hr_contract_reference	base	ir.module.module
608	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	515	t	module_hr_contract_renew	base	ir.module.module
609	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	516	t	module_hr_contract_reports	base	ir.module.module
610	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	517	t	module_hr_contract_salary	base	ir.module.module
611	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	518	t	module_hr_contract_salary_holidays	base	ir.module.module
612	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	519	t	module_hr_contract_salary_payroll	base	ir.module.module
613	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	520	t	module_hr_contract_sign	base	ir.module.module
614	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	521	t	module_hr_course	base	ir.module.module
615	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	522	t	module_hr_department_code	base	ir.module.module
616	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	523	t	module_hr_employee_age	base	ir.module.module
617	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	524	t	module_hr_employee_birthday_mail	base	ir.module.module
618	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	525	t	module_hr_employee_calendar_planning	base	ir.module.module
619	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	526	t	module_hr_employee_cost_history	base	ir.module.module
620	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	527	t	module_hr_employee_firstname	base	ir.module.module
621	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	528	t	module_hr_employee_id	base	ir.module.module
622	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	529	t	module_hr_employee_language	base	ir.module.module
623	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	530	t	module_hr_employee_medical_examination	base	ir.module.module
624	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	531	t	module_hr_employee_partner_external	base	ir.module.module
625	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	532	t	module_hr_employee_phone_extension	base	ir.module.module
626	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	533	t	module_hr_employee_ppe	base	ir.module.module
627	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	534	t	module_hr_employee_relative	base	ir.module.module
628	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	535	t	module_hr_employee_second_lastname	base	ir.module.module
629	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	536	t	module_hr_employee_service	base	ir.module.module
630	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	537	t	module_hr_employee_service_contract	base	ir.module.module
631	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	538	t	module_hr_employee_ssn	base	ir.module.module
632	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	89	t	module_category_human_resources_expenses	base	ir.module.category
633	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	539	t	module_hr_expense	base	ir.module.module
634	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	540	t	module_hr_expense_advance_clearing	base	ir.module.module
635	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	541	t	module_hr_expense_advance_clearing_sequence	base	ir.module.module
636	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	542	t	module_hr_expense_analytic_tag	base	ir.module.module
637	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	543	t	module_hr_expense_cancel	base	ir.module.module
638	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	544	t	module_hr_expense_extract	base	ir.module.module
639	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	545	t	module_hr_expense_invoice	base	ir.module.module
640	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	546	t	module_hr_expense_payment	base	ir.module.module
641	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	547	t	module_hr_expense_predict_product	base	ir.module.module
642	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	548	t	module_hr_expense_sequence	base	ir.module.module
643	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	549	t	module_hr_expense_tier_validation	base	ir.module.module
644	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	550	t	module_hr_fleet	base	ir.module.module
645	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	551	t	module_hr_gamification	base	ir.module.module
646	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	552	t	module_hr_gantt	base	ir.module.module
647	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	90	t	module_category_human_resources_time_off	base	ir.module.category
648	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	553	t	module_hr_holidays	base	ir.module.module
649	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	554	t	module_hr_holidays_attendance	base	ir.module.module
650	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	555	t	module_hr_holidays_contract	base	ir.module.module
651	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	556	t	module_hr_holidays_contract_gantt	base	ir.module.module
652	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	557	t	module_hr_holidays_gantt	base	ir.module.module
653	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	558	t	module_hr_holidays_leave_repeated	base	ir.module.module
654	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	559	t	module_hr_holidays_natural_period	base	ir.module.module
655	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	560	t	module_hr_holidays_public	base	ir.module.module
656	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	561	t	module_hr_holidays_public_city	base	ir.module.module
657	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	562	t	module_hr_holidays_settings	base	ir.module.module
658	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	563	t	module_hr_holidays_ux	base	ir.module.module
659	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	91	t	module_category_human_resources_remote_work	base	ir.module.category
660	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	564	t	module_hr_homeworking	base	ir.module.module
661	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	565	t	module_hr_homeworking_calendar	base	ir.module.module
662	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	92	t	module_category_services_employee_hourly_cost	base	ir.module.category
663	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	566	t	module_hr_hourly_cost	base	ir.module.module
664	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	567	t	module_hr_job_category	base	ir.module.module
665	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	568	t	module_hr_livechat	base	ir.module.module
666	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	569	t	module_hr_maintenance	base	ir.module.module
667	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	570	t	module_hr_mobile	base	ir.module.module
668	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	571	t	module_hr_org_chart	base	ir.module.module
669	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	572	t	module_hr_payroll	base	ir.module.module
670	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	573	t	module_hr_payroll_account	base	ir.module.module
671	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	574	t	module_hr_payroll_account_iso20022	base	ir.module.module
672	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	575	t	module_hr_payroll_attendance	base	ir.module.module
673	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	576	t	module_hr_payroll_expense	base	ir.module.module
674	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	577	t	module_hr_payroll_fleet	base	ir.module.module
675	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	578	t	module_hr_payroll_holidays	base	ir.module.module
676	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	579	t	module_hr_payroll_planning	base	ir.module.module
677	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	580	t	module_hr_personal_equipment_request	base	ir.module.module
678	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	581	t	module_hr_presence	base	ir.module.module
679	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	582	t	module_hr_professional_category	base	ir.module.module
680	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	93	t	module_category_human_resources_recruitment	base	ir.module.category
681	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	583	t	module_hr_recruitment	base	ir.module.module
682	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	584	t	module_hr_recruitment_extract	base	ir.module.module
683	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	94	t	module_category_human_resources_recruitment_integration	base	ir.module.category
684	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	585	t	module_hr_recruitment_integration_base	base	ir.module.module
685	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	586	t	module_hr_recruitment_integration_monster	base	ir.module.module
686	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	587	t	module_hr_recruitment_integration_skills_monster	base	ir.module.module
687	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	588	t	module_hr_recruitment_integration_website	base	ir.module.module
688	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	589	t	module_hr_recruitment_integration_website_monster	base	ir.module.module
689	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	590	t	module_hr_recruitment_reports	base	ir.module.module
690	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	591	t	module_hr_recruitment_sign	base	ir.module.module
691	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	592	t	module_hr_recruitment_skills	base	ir.module.module
692	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	593	t	module_hr_recruitment_sms	base	ir.module.module
693	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	594	t	module_hr_recruitment_survey	base	ir.module.module
694	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	95	t	module_category_human_resources_referrals	base	ir.module.category
695	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	595	t	module_hr_referral	base	ir.module.module
696	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	596	t	module_hr_skills	base	ir.module.module
697	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	597	t	module_hr_skills_slides	base	ir.module.module
698	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	598	t	module_hr_skills_survey	base	ir.module.module
699	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	96	t	module_category_services_timesheets	base	ir.module.category
700	\N	2026-01-19 17:38:23.744272	2026-01-19 17:38:23.744272	\N	599	t	module_hr_timesheet	base	ir.mo