--
-- PostgreSQL database dump
--

\restrict kSCwdPjFFS8hZ529lzpxcRC8ZTFpqrurzU4PUKjETPzrLyuBS6nnnw3OJKM5j4B

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.0 (Debian 18.0-1.pgdg12+3)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: vector; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS vector WITH SCHEMA public;


--
-- Name: EXTENSION vector; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION vector IS 'vector data type and ivfflat and hnsw access methods';


--
-- Name: knowledge_dictionary; Type: TEXT SEARCH DICTIONARY; Schema: public; Owner: runbot
--

CREATE TEXT SEARCH DICTIONARY public.knowledge_dictionary (
    TEMPLATE = pg_catalog.simple );


ALTER TEXT SEARCH DICTIONARY public.knowledge_dictionary OWNER TO runbot;

--
-- Name: knowledge_config; Type: TEXT SEARCH CONFIGURATION; Schema: public; Owner: runbot
--

CREATE TEXT SEARCH CONFIGURATION public.knowledge_config (
    PARSER = pg_catalog."default" );

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR asciiword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR word WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR numword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR email WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR url WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR host WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR sfloat WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR version WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword_numpart WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword_part WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword_asciipart WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR protocol WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR numhword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR asciihword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR hword WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR url_path WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR file WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR "float" WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR "int" WITH public.knowledge_dictionary;

ALTER TEXT SEARCH CONFIGURATION public.knowledge_config
    ADD MAPPING FOR uint WITH public.knowledge_dictionary;


ALTER TEXT SEARCH CONFIGURATION public.knowledge_config OWNER TO runbot;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    account_type character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    code_store jsonb,
    note text,
    active boolean,
    reconcile boolean,
    non_trade boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    fiscal_category_id integer,
    is_monetary boolean,
    l10n_ar_arca_activity_id integer
);


ALTER TABLE public.account_account OWNER TO runbot;

--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.account_type IS 'Type';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.name IS 'Account Name';


--
-- Name: COLUMN account_account.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.description IS 'Description';


--
-- Name: COLUMN account_account.code_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.code_store IS 'Code Store';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.active IS 'Active';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.non_trade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.non_trade IS 'Non Trade';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account.fiscal_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.fiscal_category_id IS 'Fiscal Category';


--
-- Name: COLUMN account_account.is_monetary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.is_monetary IS 'Is Monetary';


--
-- Name: COLUMN account_account.l10n_ar_arca_activity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.l10n_ar_arca_activity_id IS 'Associated ARCA Activity';


--
-- Name: account_account_account_auto_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_auto_reconcile_wizard_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_auto_reconcile_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_auto_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_auto_reconcile_wizard_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_account';


--
-- Name: account_account_account_merge_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_merge_wizard_rel (
    account_merge_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_merge_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_merge_wizard_rel IS 'RELATION BETWEEN account_merge_wizard AND account_account';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_exclude_res_currency_provision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_exclude_res_currency_provision (
    account_account_id integer NOT NULL,
    res_currency_id integer NOT NULL
);


ALTER TABLE public.account_account_exclude_res_currency_provision OWNER TO runbot;

--
-- Name: TABLE account_account_exclude_res_currency_provision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_exclude_res_currency_provision IS 'RELATION BETWEEN account_account AND res_currency';


--
-- Name: account_account_fiscal_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_fiscal_rate (
    id integer NOT NULL,
    related_account_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rate double precision NOT NULL
);


ALTER TABLE public.account_account_fiscal_rate OWNER TO runbot;

--
-- Name: TABLE account_account_fiscal_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_fiscal_rate IS 'Fiscal Rate';


--
-- Name: COLUMN account_account_fiscal_rate.related_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.related_account_id IS 'Account';


--
-- Name: COLUMN account_account_fiscal_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.company_id IS 'Company';


--
-- Name: COLUMN account_account_fiscal_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_fiscal_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_fiscal_rate.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.date_from IS 'Start Date';


--
-- Name: COLUMN account_account_fiscal_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_account_fiscal_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account_fiscal_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.rate IS 'Fiscal Rate (%)';


--
-- Name: account_account_fiscal_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_fiscal_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_fiscal_rate_id_seq OWNER TO runbot;

--
-- Name: account_account_fiscal_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_fiscal_rate_id_seq OWNED BY public.account_account_fiscal_rate.id;


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_id_seq OWNER TO runbot;

--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_res_company_rel (
    account_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_res_company_rel IS 'RELATION BETWEEN account_account AND res_company';


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    color integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    applicability character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_tax_repartition_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_tag_id_seq OWNER TO runbot;

--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tag_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_product_template_rel (
    product_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_product_template_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_product_template_rel IS 'RELATION BETWEEN product_template AND account_account_tag';


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_tax_default_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_accrued_orders_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_accrued_orders_wizard (
    id integer NOT NULL,
    company_id integer,
    journal_id integer NOT NULL,
    currency_id integer,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_accrued_orders_wizard OWNER TO runbot;

--
-- Name: TABLE account_accrued_orders_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_accrued_orders_wizard IS 'Accrued Orders Wizard';


--
-- Name: COLUMN account_accrued_orders_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrued_orders_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_accrued_orders_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.currency_id IS 'Company Currency';


--
-- Name: COLUMN account_accrued_orders_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.account_id IS 'Accrual Account';


--
-- Name: COLUMN account_accrued_orders_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrued_orders_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrued_orders_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrued_orders_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_accrued_orders_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.amount IS 'Amount';


--
-- Name: COLUMN account_accrued_orders_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrued_orders_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_accrued_orders_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNER TO runbot;

--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNED BY public.account_accrued_orders_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    database_count integer,
    main_database_id integer,
    maintenance_window_duration integer,
    use_databases boolean,
    maintenance_window_start double precision,
    pg_storage_size integer,
    cnpg_database_password character varying,
    cnpg_database_config jsonb
);


ALTER TABLE public.account_analytic_account OWNER TO runbot;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_account.database_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.database_count IS '# Databases';


--
-- Name: COLUMN account_analytic_account.main_database_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.main_database_id IS 'Main Database';


--
-- Name: COLUMN account_analytic_account.maintenance_window_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.maintenance_window_duration IS 'Maintenance Window Duration';


--
-- Name: COLUMN account_analytic_account.use_databases; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.use_databases IS 'Use Databases?';


--
-- Name: COLUMN account_analytic_account.maintenance_window_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.maintenance_window_start IS 'Maintenance Window Start';


--
-- Name: COLUMN account_analytic_account.pg_storage_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.pg_storage_size IS 'PostgreSQL Storage Size';


--
-- Name: COLUMN account_analytic_account.cnpg_database_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.cnpg_database_password IS 'Cnpg Database Password';


--
-- Name: COLUMN account_analytic_account.cnpg_database_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.cnpg_database_config IS 'Additional configs';


--
-- Name: account_analytic_account_adhoc_product_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account_adhoc_product_rel (
    account_analytic_account_id integer NOT NULL,
    adhoc_product_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_adhoc_product_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_account_adhoc_product_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account_adhoc_product_rel IS 'RELATION BETWEEN account_analytic_account AND adhoc_product';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO runbot;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_account_saas_environment_postgres_server_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account_saas_environment_postgres_server_rel (
    saas_environment_postgres_server_id integer NOT NULL,
    account_analytic_account_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_saas_environment_postgres_server_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_account_saas_environment_postgres_server_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account_saas_environment_postgres_server_rel IS 'RELATION BETWEEN saas_environment_postgres_server AND account_analytic_account';


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_applicability OWNER TO runbot;

--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_applicability.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_applicability.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.account_prefix IS 'Financial Accounts Prefixes';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNER TO runbot;

--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    sequence integer,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_distribution_model OWNER TO runbot;

--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_distribution_model.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_distribution_model.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_distribution_model.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.account_prefix IS 'Accounts Prefix';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNER TO runbot;

--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    account_id integer,
    product_uom_id integer,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision,
    x_plan2_id integer,
    x_plan3_id integer,
    product_id integer,
    general_account_id integer,
    journal_id integer,
    move_line_id integer,
    code character varying(8),
    ref character varying,
    task_id integer,
    parent_task_id integer,
    project_id integer,
    department_id integer,
    manager_id integer,
    employee_id integer,
    so_line integer,
    validated boolean,
    helpdesk_ticket_id integer,
    timesheet_invoice_id integer,
    order_id integer,
    timesheet_invoice_type character varying,
    is_so_line_edited boolean
);


ALTER TABLE public.account_analytic_line OWNER TO runbot;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Project Account';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_line.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan3_id IS 'Internal';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.journal_id IS 'Financial Journal';


--
-- Name: COLUMN account_analytic_line.move_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.move_line_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.employee_id IS 'Employee';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: COLUMN account_analytic_line.validated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.validated IS 'Validated line';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_id IS 'Invoice';


--
-- Name: COLUMN account_analytic_line.order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.order_id IS 'Order Reference';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_type IS 'Billable Type';


--
-- Name: COLUMN account_analytic_line.is_so_line_edited; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.is_so_line_edited IS 'Is Sales Order Item Manually Edited';


--
-- Name: account_analytic_line_calendar_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_calendar_employee (
    id integer NOT NULL,
    user_id integer NOT NULL,
    employee_id integer,
    create_uid integer,
    write_uid integer,
    checked boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_line_calendar_employee OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_calendar_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_calendar_employee IS 'Personal Filters on Employees for the Calendar view';


--
-- Name: COLUMN account_analytic_line_calendar_employee.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line_calendar_employee.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.employee_id IS 'Employee';


--
-- Name: COLUMN account_analytic_line_calendar_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line_calendar_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line_calendar_employee.checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.checked IS 'Checked';


--
-- Name: COLUMN account_analytic_line_calendar_employee.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.active IS 'Active';


--
-- Name: COLUMN account_analytic_line_calendar_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line_calendar_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.write_date IS 'Last Updated on';


--
-- Name: account_analytic_line_calendar_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_calendar_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_calendar_employee_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_calendar_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_calendar_employee_id_seq OWNED BY public.account_analytic_line_calendar_employee.id;


--
-- Name: account_analytic_line_hr_timesheet_merge_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel (
    hr_timesheet_merge_wizard_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_hr_timesheet_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel IS 'RELATION BETWEEN hr_timesheet_merge_wizard AND account_analytic_line';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    complete_name character varying,
    name jsonb NOT NULL,
    default_applicability jsonb,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    x_plan2_id integer,
    x_plan3_id integer
);


ALTER TABLE public.account_analytic_plan OWNER TO runbot;

--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_plan.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_plan.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.x_plan3_id IS 'Internal';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_plan_id_seq OWNER TO runbot;

--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: account_ar_vat_line; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.account_ar_vat_line AS
SELECT
    NULL::text AS column_group_key,
    NULL::integer AS id,
    NULL::character varying AS cuit,
    NULL::character varying AS afip_responsibility_type_name,
    NULL::character varying AS partner_name,
    NULL::character varying AS tax_type,
    NULL::integer AS move_id,
    NULL::character varying AS move_type,
    NULL::date AS date,
    NULL::date AS invoice_date,
    NULL::integer AS partner_id,
    NULL::integer AS journal_id,
    NULL::character varying AS move_name,
    NULL::integer AS afip_responsibility_type_id,
    NULL::integer AS document_type_id,
    NULL::character varying AS state,
    NULL::integer AS company_id,
    NULL::numeric AS taxed,
    NULL::numeric AS base_10,
    NULL::numeric AS vat_10,
    NULL::numeric AS base_21,
    NULL::numeric AS vat_21,
    NULL::numeric AS base_27,
    NULL::numeric AS vat_27,
    NULL::numeric AS base_5,
    NULL::numeric AS vat_5,
    NULL::numeric AS base_25,
    NULL::numeric AS vat_25,
    NULL::numeric AS not_taxed,
    NULL::numeric AS vat_per,
    NULL::numeric AS perc_iibb,
    NULL::numeric AS perc_earnings,
    NULL::numeric AS city_tax,
    NULL::numeric AS other_taxes,
    NULL::numeric AS total;


ALTER VIEW public.account_ar_vat_line OWNER TO runbot;

--
-- Name: account_audit_account_status; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_audit_account_status (
    id integer NOT NULL,
    audit_id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    status character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_audit_account_status OWNER TO runbot;

--
-- Name: TABLE account_audit_account_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_audit_account_status IS 'Account Audit Account Status';


--
-- Name: COLUMN account_audit_account_status.audit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.audit_id IS 'Audit';


--
-- Name: COLUMN account_audit_account_status.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.account_id IS 'Account';


--
-- Name: COLUMN account_audit_account_status.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.create_uid IS 'Created by';


--
-- Name: COLUMN account_audit_account_status.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_audit_account_status.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.status IS 'Status';


--
-- Name: COLUMN account_audit_account_status.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.create_date IS 'Created on';


--
-- Name: COLUMN account_audit_account_status.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.write_date IS 'Last Updated on';


--
-- Name: account_audit_account_status_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_audit_account_status_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_audit_account_status_id_seq OWNER TO runbot;

--
-- Name: account_audit_account_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_audit_account_status_id_seq OWNED BY public.account_audit_account_status.id;


--
-- Name: account_auto_reconcile_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    search_mode character varying NOT NULL,
    from_date date,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_auto_reconcile_wizard OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard IS 'Account automatic reconciliation wizard';


--
-- Name: COLUMN account_auto_reconcile_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_auto_reconcile_wizard.search_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.search_mode IS 'Reconcile';


--
-- Name: COLUMN account_auto_reconcile_wizard.from_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.from_date IS 'From';


--
-- Name: COLUMN account_auto_reconcile_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.to_date IS 'To';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_auto_reconcile_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard_account_move_line_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_account_move_line_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_move_line';


--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_auto_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNER TO runbot;

--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNED BY public.account_auto_reconcile_wizard.id;


--
-- Name: account_auto_reconcile_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard_res_partner_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_res_partner_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND res_partner';


--
-- Name: account_automatic_entry_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    account_type character varying,
    date date NOT NULL,
    total_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage double precision
);


ALTER TABLE public.account_automatic_entry_wizard OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard IS 'Create Automatic Entries';


--
-- Name: COLUMN account_automatic_entry_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_automatic_entry_wizard.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.destination_account_id IS 'To';


--
-- Name: COLUMN account_automatic_entry_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_entry_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_automatic_entry_wizard.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.action IS 'Action';


--
-- Name: COLUMN account_automatic_entry_wizard.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_automatic_entry_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.date IS 'Date';


--
-- Name: COLUMN account_automatic_entry_wizard.total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.total_amount IS 'Total Amount';


--
-- Name: COLUMN account_automatic_entry_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_entry_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_automatic_entry_wizard.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.percentage IS 'Percentage';


--
-- Name: account_automatic_entry_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard_account_move_line_rel (
    account_automatic_entry_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_automatic_entry_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard_account_move_line_rel IS 'RELATION BETWEEN account_automatic_entry_wizard AND account_move_line';


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_automatic_entry_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNER TO runbot;

--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNED BY public.account_automatic_entry_wizard.id;


--
-- Name: account_autopost_bills_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_autopost_bills_wizard (
    id integer NOT NULL,
    partner_id integer,
    nb_unmodified_bills integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_autopost_bills_wizard OWNER TO runbot;

--
-- Name: TABLE account_autopost_bills_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_autopost_bills_wizard IS 'Autopost Bills Wizard';


--
-- Name: COLUMN account_autopost_bills_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN account_autopost_bills_wizard.nb_unmodified_bills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.nb_unmodified_bills IS 'Number of bills previously unmodified from this partner';


--
-- Name: COLUMN account_autopost_bills_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_autopost_bills_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_autopost_bills_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_autopost_bills_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_date IS 'Last Updated on';


--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_autopost_bills_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNER TO runbot;

--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNED BY public.account_autopost_bills_wizard.id;


--
-- Name: account_bank_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_selection (
    id integer NOT NULL,
    account_online_link_id integer,
    selected_account integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_selection OWNER TO runbot;

--
-- Name: TABLE account_bank_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_selection IS 'Link a bank account to the selected journal';


--
-- Name: COLUMN account_bank_selection.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_selection.selected_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.selected_account IS 'Selected Account';


--
-- Name: COLUMN account_bank_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.write_date IS 'Last Updated on';


--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_selection_id_seq OWNER TO runbot;

--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_selection_id_seq OWNED BY public.account_bank_selection.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    company_id integer,
    currency_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    reference character varying,
    first_line_index character varying,
    date date,
    balance_start numeric,
    balance_end numeric,
    balance_end_real numeric,
    is_complete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    message_main_attachment_id integer
);


ALTER TABLE public.account_bank_statement OWNER TO runbot;

--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.currency_id IS 'Currency';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.first_line_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.first_line_index IS 'First Line Index';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.is_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_complete IS 'Is Complete';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.message_main_attachment_id IS 'Main Attachment';


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_ir_attachment_rel (
    account_bank_statement_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_bank_statement_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_ir_attachment_rel IS 'RELATION BETWEEN account_bank_statement AND ir_attachment';


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    statement_id integer,
    sequence integer,
    partner_id integer,
    currency_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    account_number character varying,
    partner_name character varying,
    transaction_type character varying,
    payment_ref character varying,
    internal_index character varying,
    transaction_details jsonb,
    amount numeric,
    amount_currency numeric,
    is_reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount_residual double precision,
    message_main_attachment_id integer,
    cron_last_check timestamp without time zone,
    unique_import_id character varying,
    online_account_id integer,
    online_link_id integer,
    online_transaction_identifier character varying,
    online_partner_information character varying
);


ALTER TABLE public.account_bank_statement_line OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Journal Currency';


--
-- Name: COLUMN account_bank_statement_line.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.payment_ref IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.internal_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.internal_index IS 'Internal Reference';


--
-- Name: COLUMN account_bank_statement_line.transaction_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_bank_statement_line.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_bank_statement_line.cron_last_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.cron_last_check IS 'Cron Last Check';


--
-- Name: COLUMN account_bank_statement_line.unique_import_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.unique_import_id IS 'Import ID';


--
-- Name: COLUMN account_bank_statement_line.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_account_id IS 'Online Account';


--
-- Name: COLUMN account_bank_statement_line.online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_statement_line.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line.online_partner_information; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_partner_information IS 'Online Partner Information';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_bank_statement_line_transient; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line_transient (
    id integer NOT NULL,
    sequence integer,
    journal_id integer,
    online_account_id integer,
    company_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    online_transaction_identifier character varying,
    payment_ref character varying,
    account_number character varying,
    partner_name character varying,
    state character varying,
    date date,
    transaction_details jsonb,
    amount numeric,
    amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_statement_line_transient OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line_transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line_transient IS 'Transient model for bank statement line';


--
-- Name: COLUMN account_bank_statement_line_transient.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line_transient.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line_transient.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_bank_statement_line_transient.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line_transient.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line_transient.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line_transient.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line_transient.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.payment_ref IS 'Payment Ref';


--
-- Name: COLUMN account_bank_statement_line_transient.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.account_number IS 'Account Number';


--
-- Name: COLUMN account_bank_statement_line_transient.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line_transient.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.state IS 'State';


--
-- Name: COLUMN account_bank_statement_line_transient.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.date IS 'Date';


--
-- Name: COLUMN account_bank_statement_line_transient.transaction_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line_transient.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line_transient.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line_transient.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_transient_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNED BY public.account_bank_statement_line_transient.id;


--
-- Name: account_batch_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard (
    id integer NOT NULL,
    batch_payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_remove_options boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard IS 'Batch payments error reporting wizard';


--
-- Name: COLUMN account_batch_error_wizard.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_batch_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard.show_remove_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.show_remove_options IS 'Show Remove Options';


--
-- Name: COLUMN account_batch_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNED BY public.account_batch_error_wizard.id;


--
-- Name: account_batch_error_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line (
    id integer NOT NULL,
    error_wizard_id integer,
    warning_wizard_id integer,
    create_uid integer,
    write_uid integer,
    description character varying NOT NULL,
    help_message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line IS 'Batch payments error reporting wizard line';


--
-- Name: COLUMN account_batch_error_wizard_line.error_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.error_wizard_id IS 'Error Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.warning_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.warning_wizard_id IS 'Warning Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.description IS 'Description';


--
-- Name: COLUMN account_batch_error_wizard_line.help_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.help_message IS 'Help';


--
-- Name: COLUMN account_batch_error_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_line_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line_account_payment_rel (
    account_batch_error_wizard_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_error_wizard_line_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line_account_payment_rel IS 'RELATION BETWEEN account_batch_error_wizard_line AND account_payment';


--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNED BY public.account_batch_error_wizard_line.id;


--
-- Name: account_batch_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment (
    id integer NOT NULL,
    journal_id integer,
    currency_id integer,
    company_currency_id integer,
    payment_method_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    batch_type character varying NOT NULL,
    export_filename character varying,
    date date NOT NULL,
    export_file_create_date date,
    amount_residual numeric,
    amount_residual_currency numeric,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_payment OWNER TO runbot;

--
-- Name: TABLE account_batch_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment IS 'Batch Payment';


--
-- Name: COLUMN account_batch_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.journal_id IS 'Bank';


--
-- Name: COLUMN account_batch_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_batch_payment.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_batch_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_batch_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.name IS 'Reference';


--
-- Name: COLUMN account_batch_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.state IS 'State';


--
-- Name: COLUMN account_batch_payment.batch_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.batch_type IS 'Batch Type';


--
-- Name: COLUMN account_batch_payment.export_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_filename IS 'File Name';


--
-- Name: COLUMN account_batch_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.date IS 'Date';


--
-- Name: COLUMN account_batch_payment.export_file_create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_file_create_date IS 'Generation Date';


--
-- Name: COLUMN account_batch_payment.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual IS 'Amount Residual';


--
-- Name: COLUMN account_batch_payment.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual_currency IS 'Amount Residual Currency';


--
-- Name: COLUMN account_batch_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount IS 'Amount';


--
-- Name: COLUMN account_batch_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_date IS 'Last Updated on';


--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_id_seq OWNER TO runbot;

--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_payment_id_seq OWNED BY public.account_batch_payment.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    strategy character varying NOT NULL,
    rounding_method character varying NOT NULL,
    name jsonb NOT NULL,
    profit_account_id jsonb,
    loss_account_id jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rounding double precision NOT NULL
);


ALTER TABLE public.account_cash_rounding OWNER TO runbot;

--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_cash_rounding.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cash_rounding_id_seq OWNER TO runbot;

--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_change_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_currency (
    id integer NOT NULL,
    currency_to_id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    conversion_rate numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_currency OWNER TO runbot;

--
-- Name: TABLE account_change_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_currency IS 'Change Currency';


--
-- Name: COLUMN account_change_currency.currency_to_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.currency_to_id IS 'Currency to';


--
-- Name: COLUMN account_change_currency.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.move_id IS 'Move';


--
-- Name: COLUMN account_change_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_currency.conversion_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.conversion_rate IS 'Conversion Rate';


--
-- Name: COLUMN account_change_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_date IS 'Created on';


--
-- Name: COLUMN account_change_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_date IS 'Last Updated on';


--
-- Name: account_change_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_currency_id_seq OWNER TO runbot;

--
-- Name: account_change_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_currency_id_seq OWNED BY public.account_change_currency.id;


--
-- Name: account_change_lock_date; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_lock_date (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    exception_applies_to character varying NOT NULL,
    exception_duration character varying NOT NULL,
    exception_reason character varying,
    fiscalyear_lock_date date,
    tax_lock_date date,
    sale_lock_date date,
    purchase_lock_date date,
    hard_lock_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_lock_date OWNER TO runbot;

--
-- Name: TABLE account_change_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_lock_date IS 'Change Lock Date';


--
-- Name: COLUMN account_change_lock_date.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.company_id IS 'Company';


--
-- Name: COLUMN account_change_lock_date.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_lock_date.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_lock_date.exception_applies_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_applies_to IS 'Exception applies';


--
-- Name: COLUMN account_change_lock_date.exception_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_duration IS 'Exception Duration';


--
-- Name: COLUMN account_change_lock_date.exception_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_reason IS 'Exception Reason';


--
-- Name: COLUMN account_change_lock_date.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.fiscalyear_lock_date IS 'Lock Everything';


--
-- Name: COLUMN account_change_lock_date.tax_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.tax_lock_date IS 'Lock Tax Return';


--
-- Name: COLUMN account_change_lock_date.sale_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.sale_lock_date IS 'Lock Sales';


--
-- Name: COLUMN account_change_lock_date.purchase_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.purchase_lock_date IS 'Lock Purchases';


--
-- Name: COLUMN account_change_lock_date.hard_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.hard_lock_date IS 'Hard Lock';


--
-- Name: COLUMN account_change_lock_date.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_date IS 'Created on';


--
-- Name: COLUMN account_change_lock_date.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_date IS 'Last Updated on';


--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_lock_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_lock_date_id_seq OWNER TO runbot;

--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_lock_date_id_seq OWNED BY public.account_change_lock_date.id;


--
-- Name: account_check_action_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_action_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_action_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_action_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_action_wizard IS 'Account Check Action Wizard';


--
-- Name: COLUMN account_check_action_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_action_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_action_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.date IS 'Date';


--
-- Name: COLUMN account_check_action_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_action_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_action_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNED BY public.account_check_action_wizard.id;


--
-- Name: account_check_to_date_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_to_date_report_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_to_date_report_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_to_date_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_to_date_report_wizard IS 'account.check.to_date.report.wizard';


--
-- Name: COLUMN account_check_to_date_report_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.journal_id IS 'Diario';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_to_date_report_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.to_date IS 'Hasta Fecha';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_to_date_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNED BY public.account_check_to_date_report_wizard.id;


--
-- Name: account_create_batch_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_create_batch_error_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_create_batch_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_create_batch_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_create_batch_error_wizard IS 'Create Batch Payment Error Wizard';


--
-- Name: COLUMN account_create_batch_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_create_batch_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_create_batch_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_create_batch_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_create_batch_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_create_batch_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_create_batch_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_create_batch_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_create_batch_error_wizard_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_create_batch_error_wizard_account_payment_rel (
    account_create_batch_error_wizard_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_create_batch_error_wizard_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_create_batch_error_wizard_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_create_batch_error_wizard_account_payment_rel IS 'RELATION BETWEEN account_create_batch_error_wizard AND account_payment';


--
-- Name: account_create_batch_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_create_batch_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_create_batch_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_create_batch_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_create_batch_error_wizard_id_seq OWNED BY public.account_create_batch_error_wizard.id;


--
-- Name: account_debit_note; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_debit_note (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date NOT NULL,
    copy_lines boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_debit_note OWNER TO runbot;

--
-- Name: TABLE account_debit_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_debit_note IS 'Add Debit Note wizard';


--
-- Name: COLUMN account_debit_note.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.journal_id IS 'Use Specific Journal';


--
-- Name: COLUMN account_debit_note.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_uid IS 'Created by';


--
-- Name: COLUMN account_debit_note.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_debit_note.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.reason IS 'Reason';


--
-- Name: COLUMN account_debit_note.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.date IS 'Debit Note Date';


--
-- Name: COLUMN account_debit_note.copy_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.copy_lines IS 'Copy Lines';


--
-- Name: COLUMN account_debit_note.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_date IS 'Created on';


--
-- Name: COLUMN account_debit_note.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_date IS 'Last Updated on';


--
-- Name: account_debit_note_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_debit_note_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_debit_note_id_seq OWNER TO runbot;

--
-- Name: account_debit_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_debit_note_id_seq OWNED BY public.account_debit_note.id;


--
-- Name: account_duplicate_transaction_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_duplicate_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_duplicate_transaction_wizard OWNER TO runbot;

--
-- Name: TABLE account_duplicate_transaction_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_duplicate_transaction_wizard IS 'Wizard for duplicate transactions';


--
-- Name: COLUMN account_duplicate_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_duplicate_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNER TO runbot;

--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNED BY public.account_duplicate_transaction_wizard.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_financial_year_op OWNER TO runbot;

--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_financial_year_op_id_seq OWNER TO runbot;

--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_category (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_category OWNER TO runbot;

--
-- Name: TABLE account_fiscal_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_category IS 'Account Fiscal Category';


--
-- Name: COLUMN account_fiscal_category.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_category.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.code IS 'Code';


--
-- Name: COLUMN account_fiscal_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.name IS 'Name';


--
-- Name: COLUMN account_fiscal_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.active IS 'Active';


--
-- Name: COLUMN account_fiscal_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_category_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_category_id_seq OWNED BY public.account_fiscal_category.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    country_id integer,
    country_group_id integer,
    create_uid integer,
    write_uid integer,
    zip_from character varying,
    zip_to character varying,
    foreign_vat character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    auto_apply boolean,
    vat_required boolean,
    is_domestic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    avatax_invoice_account_id integer,
    avatax_refund_account_id integer,
    is_avatax boolean
);


ALTER TABLE public.account_fiscal_position OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.foreign_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.foreign_vat IS 'Foreign Tax ID';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.is_domestic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.is_domestic IS 'Is Domestic';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position.avatax_invoice_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_invoice_account_id IS 'Avatax Invoice Account';


--
-- Name: COLUMN account_fiscal_position.avatax_refund_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_refund_account_id IS 'Avatax Refund Account';


--
-- Name: COLUMN account_fiscal_position.is_avatax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.is_avatax IS 'Use AvaTax API';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account_tax_rel (
    account_fiscal_position_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account_tax_rel IS 'RELATION BETWEEN account_fiscal_position AND account_tax';


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_l10n_ar_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_l10n_ar_tax (
    id integer NOT NULL,
    fiscal_position_id integer NOT NULL,
    default_tax_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    webservice character varying,
    tax_type character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_l10n_ar_tax OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_l10n_ar_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_l10n_ar_tax IS 'account.fiscal.position.l10n_ar_tax';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.default_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.default_tax_id IS 'Default Tax';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.webservice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.webservice IS 'Webservice';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.tax_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.tax_type IS 'Tax Type';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_l10n_ar_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_l10n_ar_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq OWNED BY public.account_fiscal_position_l10n_ar_tax.id;


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_year; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_year (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_year OWNER TO runbot;

--
-- Name: TABLE account_fiscal_year; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_year IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscal_year.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_year.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_year.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_year.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.name IS 'Name';


--
-- Name: COLUMN account_fiscal_year.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_from IS 'Start Date';


--
-- Name: COLUMN account_fiscal_year.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_to IS 'End Date';


--
-- Name: COLUMN account_fiscal_year.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_year.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_year_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_year_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_year_id_seq OWNED BY public.account_fiscal_year.id;


--
-- Name: account_followup_followup_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_followup_line (
    id integer NOT NULL,
    delay integer NOT NULL,
    company_id integer NOT NULL,
    mail_template_id integer,
    sms_template_id integer,
    activity_type_id integer,
    create_uid integer,
    write_uid integer,
    activity_summary character varying,
    activity_default_responsible_type character varying NOT NULL,
    name jsonb NOT NULL,
    activity_note text,
    send_email boolean,
    join_invoices boolean,
    send_sms boolean,
    create_activity boolean,
    auto_execute boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    send_letter boolean
);


ALTER TABLE public.account_followup_followup_line OWNER TO runbot;

--
-- Name: TABLE account_followup_followup_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_followup_line IS 'Follow-up Criteria';


--
-- Name: COLUMN account_followup_followup_line.delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.delay IS 'Due Days';


--
-- Name: COLUMN account_followup_followup_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.company_id IS 'Company';


--
-- Name: COLUMN account_followup_followup_line.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.mail_template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_followup_line.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_followup_line.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN account_followup_followup_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_followup_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_followup_line.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_summary IS 'Summary';


--
-- Name: COLUMN account_followup_followup_line.activity_default_responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_default_responsible_type IS 'Responsible';


--
-- Name: COLUMN account_followup_followup_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.name IS 'Description';


--
-- Name: COLUMN account_followup_followup_line.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_note IS 'Note';


--
-- Name: COLUMN account_followup_followup_line.send_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_email IS 'Email';


--
-- Name: COLUMN account_followup_followup_line.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_followup_line.send_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_sms IS 'SMS';


--
-- Name: COLUMN account_followup_followup_line.create_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_activity IS 'Schedule Activity';


--
-- Name: COLUMN account_followup_followup_line.auto_execute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.auto_execute IS 'Automatic';


--
-- Name: COLUMN account_followup_followup_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_followup_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_followup_line.send_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_letter IS 'Letter';


--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_followup_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNER TO runbot;

--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNED BY public.account_followup_followup_line.id;


--
-- Name: account_followup_followup_line_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_followup_line_res_users_rel (
    account_followup_followup_line_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.account_followup_followup_line_res_users_rel OWNER TO runbot;

--
-- Name: TABLE account_followup_followup_line_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_followup_line_res_users_rel IS 'RELATION BETWEEN account_followup_followup_line AND res_users';


--
-- Name: account_followup_manual_reminder; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder (
    id integer NOT NULL,
    template_id integer,
    partner_id integer,
    sms_template_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    sms_body character varying,
    body text,
    email boolean,
    sms boolean,
    print boolean,
    join_invoices boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    snailmail boolean
);


ALTER TABLE public.account_followup_manual_reminder OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder IS 'Wizard for sending manual reminders to clients';


--
-- Name: COLUMN account_followup_manual_reminder.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_manual_reminder.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.partner_id IS 'Partner';


--
-- Name: COLUMN account_followup_manual_reminder.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_manual_reminder.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_manual_reminder.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_manual_reminder.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.lang IS 'Language';


--
-- Name: COLUMN account_followup_manual_reminder.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.subject IS 'Subject';


--
-- Name: COLUMN account_followup_manual_reminder.sms_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_body IS 'Sms Body';


--
-- Name: COLUMN account_followup_manual_reminder.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.body IS 'Contents';


--
-- Name: COLUMN account_followup_manual_reminder.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.email IS 'Email';


--
-- Name: COLUMN account_followup_manual_reminder.sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms IS 'Sms';


--
-- Name: COLUMN account_followup_manual_reminder.print; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.print IS 'Print';


--
-- Name: COLUMN account_followup_manual_reminder.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_manual_reminder.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_manual_reminder.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_manual_reminder.snailmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.snailmail IS 'Snailmail';


--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_manual_reminder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNER TO runbot;

--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNED BY public.account_followup_manual_reminder.id;


--
-- Name: account_followup_manual_reminder_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder_ir_attachment_rel (
    account_followup_manual_reminder_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_followup_manual_reminder_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder_ir_attachment_rel IS 'RELATION BETWEEN account_followup_manual_reminder AND ir_attachment';


--
-- Name: account_followup_missing_information_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_missing_information_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_followup_missing_information_wizard OWNER TO runbot;

--
-- Name: TABLE account_followup_missing_information_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_missing_information_wizard IS 'Followup missing information wizard';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_date IS 'Last Updated on';


--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_missing_information_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNER TO runbot;

--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNED BY public.account_followup_missing_information_wizard.id;


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_full_reconcile OWNER TO runbot;

--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_full_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code_prefix_start character varying,
    code_prefix_end character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_group_check_length_prefix CHECK ((char_length((COALESCE(code_prefix_start, ''::character varying))::text) = char_length((COALESCE(code_prefix_end, ''::character varying))::text)))
);


ALTER TABLE public.account_group OWNER TO runbot;

--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.company_id IS 'Company';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.code_prefix_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group.code_prefix_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_group_check_length_prefix ON account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_group_check_length_prefix ON public.account_group IS 'CHECK(char_length(COALESCE(code_prefix_start, '''')) = char_length(COALESCE(code_prefix_end, '''')))';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_id_seq OWNER TO runbot;

--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying(3) NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_incoterms OWNER TO runbot;

--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_incoterms_id_seq OWNER TO runbot;

--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_transaction_rel (
    invoice_id integer NOT NULL,
    transaction_id integer NOT NULL
);


ALTER TABLE public.account_invoice_transaction_rel OWNER TO runbot;

--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN account_move AND payment_transaction';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    alias_id integer,
    default_account_id integer,
    suspense_account_id integer,
    non_deductible_account_id integer,
    sequence integer,
    currency_id integer,
    company_id integer NOT NULL,
    invoice_template_pdf_report_id integer,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    create_uid integer,
    write_uid integer,
    color integer,
    access_token character varying,
    code character varying(5) NOT NULL,
    type character varying NOT NULL,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    bank_statements_source character varying,
    incoming_einvoice_notification_email character varying,
    name jsonb NOT NULL,
    sequence_override_regex text,
    active boolean,
    is_self_billing boolean,
    restrict_mode_hash_table boolean,
    refund_sequence boolean,
    payment_sequence boolean,
    show_on_dashboard boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    check_sequence_id integer,
    bank_check_printing_layout character varying,
    check_manual_sequencing boolean,
    debit_sequence boolean,
    account_online_account_id integer,
    account_online_link_id integer,
    l10n_latam_use_documents boolean,
    nacha_immediate_destination character varying,
    nacha_destination character varying,
    nacha_immediate_origin character varying,
    nacha_company_identification character varying,
    nacha_origination_dfi_identification character varying,
    nacha_entry_class_code character varying NOT NULL,
    nacha_discretionary_data character varying(20),
    nacha_is_balanced boolean,
    mail_template_id integer,
    branch_order integer,
    shared_to_branches boolean,
    l10n_ar_afip_pos_number integer,
    l10n_ar_afip_pos_partner_id integer,
    l10n_ar_afip_pos_system character varying,
    l10n_ar_is_pos boolean,
    qr_code_label character varying,
    qr_code character varying,
    discriminate_taxes character varying NOT NULL,
    check_add_debit_button boolean
);


ALTER TABLE public.account_journal OWNER TO runbot;

--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Alias';


--
-- Name: COLUMN account_journal.default_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.default_account_id IS 'Default Account';


--
-- Name: COLUMN account_journal.suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.suspense_account_id IS 'Suspense Account';


--
-- Name: COLUMN account_journal.non_deductible_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.non_deductible_account_id IS 'Private Share Account';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.invoice_template_pdf_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_template_pdf_report_id IS 'Invoice report';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.access_token IS 'Security Token';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.code IS 'Sequence Prefix';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.incoming_einvoice_notification_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.incoming_einvoice_notification_email IS 'Send Copy To';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.sequence_override_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence_override_regex IS 'Sequence Override Regex';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.is_self_billing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.is_self_billing IS 'Self Billing';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Secure Posted Entries with Hash';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.payment_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.payment_sequence IS 'Dedicated Payment Sequence';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal.check_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_sequence_id IS 'Check Sequence';


--
-- Name: COLUMN account_journal.bank_check_printing_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_check_printing_layout IS 'Check Layout';


--
-- Name: COLUMN account_journal.check_manual_sequencing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_manual_sequencing IS 'Manual Numbering';


--
-- Name: COLUMN account_journal.debit_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.debit_sequence IS 'Dedicated Debit Note Sequence';


--
-- Name: COLUMN account_journal.account_online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_journal.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_journal.l10n_latam_use_documents; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_latam_use_documents IS 'Use Documents?';


--
-- Name: COLUMN account_journal.nacha_immediate_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_destination IS 'Immediate Destination';


--
-- Name: COLUMN account_journal.nacha_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_destination IS 'Destination';


--
-- Name: COLUMN account_journal.nacha_immediate_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_origin IS 'Immediate Origin';


--
-- Name: COLUMN account_journal.nacha_company_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_company_identification IS 'Company Identification';


--
-- Name: COLUMN account_journal.nacha_origination_dfi_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_origination_dfi_identification IS 'Origination Dfi Identification';


--
-- Name: COLUMN account_journal.nacha_entry_class_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_entry_class_code IS 'Standard Entry Class Code';


--
-- Name: COLUMN account_journal.nacha_discretionary_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_discretionary_data IS 'Company Discretionary Data';


--
-- Name: COLUMN account_journal.nacha_is_balanced; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_is_balanced IS 'Generate Balanced Files';


--
-- Name: COLUMN account_journal.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.mail_template_id IS 'Email Template';


--
-- Name: COLUMN account_journal.branch_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.branch_order IS 'Branch Order';


--
-- Name: COLUMN account_journal.shared_to_branches; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.shared_to_branches IS 'Shared To Branches';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_number IS 'ARCA POS Number';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_partner_id IS 'ARCA POS Address';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_system; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_system IS 'ARCA POS System';


--
-- Name: COLUMN account_journal.l10n_ar_is_pos; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_is_pos IS 'Is ARCA POS?';


--
-- Name: COLUMN account_journal.qr_code_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code_label IS 'QR Code Label';


--
-- Name: COLUMN account_journal.qr_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code IS 'QR Code';


--
-- Name: COLUMN account_journal.discriminate_taxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.discriminate_taxes IS 'Discriminate taxes?';


--
-- Name: COLUMN account_journal.check_add_debit_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_add_debit_button IS 'Agregar botón de débito';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_journal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_group OWNER TO runbot;

--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Ledger group';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_group_id_seq OWNER TO runbot;

--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_id_seq OWNER TO runbot;

--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_lock_exception; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_lock_exception (
    id integer NOT NULL,
    company_id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    lock_date_field character varying NOT NULL,
    lock_date date,
    company_lock_date date,
    active boolean,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_lock_exception OWNER TO runbot;

--
-- Name: TABLE account_lock_exception; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_lock_exception IS 'Account Lock Exception';


--
-- Name: COLUMN account_lock_exception.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_id IS 'Company';


--
-- Name: COLUMN account_lock_exception.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.user_id IS 'User';


--
-- Name: COLUMN account_lock_exception.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_uid IS 'Created by';


--
-- Name: COLUMN account_lock_exception.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_lock_exception.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.reason IS 'Reason';


--
-- Name: COLUMN account_lock_exception.lock_date_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date_field IS 'Lock Date Field';


--
-- Name: COLUMN account_lock_exception.lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date IS 'Changed Lock Date';


--
-- Name: COLUMN account_lock_exception.company_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_lock_date IS 'Original Lock Date';


--
-- Name: COLUMN account_lock_exception.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.active IS 'Active';


--
-- Name: COLUMN account_lock_exception.end_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.end_datetime IS 'End Date';


--
-- Name: COLUMN account_lock_exception.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_date IS 'Created on';


--
-- Name: COLUMN account_lock_exception.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_date IS 'Last Updated on';


--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_lock_exception_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_lock_exception_id_seq OWNER TO runbot;

--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_lock_exception_id_seq OWNED BY public.account_lock_exception.id;


--
-- Name: account_merge_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    is_group_by_name boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard IS 'Account merge wizard';


--
-- Name: COLUMN account_merge_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard.is_group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.is_group_by_name IS 'Group by name?';


--
-- Name: COLUMN account_merge_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_id_seq OWNED BY public.account_merge_wizard.id;


--
-- Name: account_merge_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    sequence integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    grouping_key character varying,
    display_type character varying NOT NULL,
    is_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard_line IS 'Account merge wizard line';


--
-- Name: COLUMN account_merge_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_merge_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_merge_wizard_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.account_id IS 'Account';


--
-- Name: COLUMN account_merge_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard_line.grouping_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.grouping_key IS 'Grouping Key';


--
-- Name: COLUMN account_merge_wizard_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_merge_wizard_line.is_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.is_selected IS 'Is Selected';


--
-- Name: COLUMN account_merge_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNED BY public.account_merge_wizard_line.id;


--
-- Name: account_missing_transaction_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_missing_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_missing_transaction_wizard OWNER TO runbot;

--
-- Name: TABLE account_missing_transaction_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_missing_transaction_wizard IS 'Wizard for missing transactions';


--
-- Name: COLUMN account_missing_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_missing_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_missing_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_missing_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_missing_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_missing_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_missing_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNER TO runbot;

--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNED BY public.account_missing_transaction_wizard.id;


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    sequence_number integer,
    message_main_attachment_id integer,
    journal_id integer NOT NULL,
    company_id integer,
    origin_payment_id integer,
    statement_line_id integer,
    tax_cash_basis_rec_id integer,
    tax_cash_basis_origin_move_id integer,
    auto_post_origin_id integer,
    secure_sequence_number integer,
    invoice_payment_term_id integer,
    partner_id integer,
    commercial_partner_id integer,
    partner_shipping_id integer,
    partner_bank_id integer,
    fiscal_position_id integer,
    preferred_payment_method_line_id integer,
    currency_id integer NOT NULL,
    reversed_entry_id integer,
    invoice_user_id integer,
    invoice_incoterm_id integer,
    invoice_cash_rounding_id integer,
    create_uid integer,
    write_uid integer,
    sequence_prefix character varying,
    access_token character varying,
    name character varying,
    ref character varying,
    state character varying NOT NULL,
    move_type character varying NOT NULL,
    auto_post character varying NOT NULL,
    inalterable_hash character varying,
    payment_reference character varying,
    qr_code_method character varying,
    payment_state character varying,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_origin character varying,
    incoterm_location character varying,
    date date NOT NULL,
    auto_post_until date,
    invoice_date date,
    invoice_date_due date,
    delivery_date date,
    taxable_supply_date date,
    sending_data jsonb,
    narration text,
    invoice_currency_rate numeric,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_untaxed_in_currency_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_total_in_currency_signed numeric,
    amount_residual_signed numeric,
    quick_edit_total_amount numeric,
    always_tax_exigible boolean,
    checked boolean,
    posted_before boolean,
    made_sequence_gap boolean,
    is_manually_modified boolean,
    is_move_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    signing_user integer,
    payment_state_before_switch character varying,
    debit_origin_id integer,
    avatax_tax_date date,
    closing_return_id integer,
    l10n_latam_document_type_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    pay_now_journal_id integer,
    internal_notes text,
    l10n_ar_afip_responsibility_type_id integer,
    l10n_ar_afip_service_start date,
    l10n_ar_afip_service_end date,
    extract_attachment_id integer,
    extract_detected_layout integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    extract_partner_name character varying,
    extracted_words jsonb,
    extracted_numbers jsonb,
    extracted_dates jsonb,
    extract_prefill_data jsonb,
    is_in_extractable_state boolean,
    extract_state_processed boolean,
    l10n_ar_fce_transmission_type character varying,
    l10n_ar_afip_auth_mode character varying,
    l10n_ar_afip_auth_code character varying(24),
    l10n_ar_afip_result character varying,
    l10n_ar_afip_verification_result character varying,
    l10n_ar_afip_auth_code_due date,
    l10n_ar_afip_xml_request text,
    l10n_ar_afip_xml_response text,
    l10n_ar_afip_fce_is_cancellation boolean,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date
);


ALTER TABLE public.account_move OWNER TO runbot;

--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move IS 'Journal Entry';


--
-- Name: COLUMN account_move.sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.origin_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.origin_payment_id IS 'Payment';


--
-- Name: COLUMN account_move.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.statement_line_id IS 'Statement Line';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.tax_cash_basis_origin_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_origin_move_id IS 'Cash Basis Origin';


--
-- Name: COLUMN account_move.auto_post_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_origin_id IS 'First recurring entry';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalterability No Gap Sequence #';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN account_move.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_bank_id IS 'Recipient Bank';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.preferred_payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.preferred_payment_method_line_id IS 'Preferred Payment Method Line';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.sequence_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.move_type IS 'Type';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Auto-post';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_move.qr_code_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.qr_code_method IS 'Payment QR-code';


--
-- Name: COLUMN account_move.payment_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state IS 'Payment Status';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.incoterm_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.incoterm_location IS 'Incoterm Location';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.auto_post_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_until IS 'Auto-post until';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.delivery_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.delivery_date IS 'Delivery Date';


--
-- Name: COLUMN account_move.taxable_supply_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.taxable_supply_date IS 'Taxable Supply Date';


--
-- Name: COLUMN account_move.sending_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sending_data IS 'Sending Data';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.invoice_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_untaxed_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_in_currency_signed IS 'Untaxed Amount Signed Currency';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_total_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_in_currency_signed IS 'Total in Currency Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.quick_edit_total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.quick_edit_total_amount IS 'Total (Tax inc.)';


--
-- Name: COLUMN account_move.always_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.always_tax_exigible IS 'Always Tax Exigible';


--
-- Name: COLUMN account_move.checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.checked IS 'Reviewed';


--
-- Name: COLUMN account_move.posted_before; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.posted_before IS 'Posted Before';


--
-- Name: COLUMN account_move.made_sequence_gap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.made_sequence_gap IS 'Made Sequence Gap';


--
-- Name: COLUMN account_move.is_manually_modified; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_manually_modified IS 'Is Manually Modified';


--
-- Name: COLUMN account_move.is_move_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_move_sent IS 'Is Move Sent';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.signing_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.signing_user IS 'Signer';


--
-- Name: COLUMN account_move.payment_state_before_switch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state_before_switch IS 'Payment State Before Switch';


--
-- Name: COLUMN account_move.debit_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.debit_origin_id IS 'Original Invoice Debited';


--
-- Name: COLUMN account_move.avatax_tax_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.avatax_tax_date IS 'Avatax Date';


--
-- Name: COLUMN account_move.closing_return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.closing_return_id IS 'Closing Return';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: COLUMN account_move.pay_now_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.pay_now_journal_id IS 'Pay now Journal';


--
-- Name: COLUMN account_move.internal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.internal_notes IS 'Internal Notes';


--
-- Name: COLUMN account_move.l10n_ar_afip_responsibility_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_responsibility_type_id IS 'ARCA Responsibility Type';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_start IS 'ARCA Service Start Date';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_end IS 'ARCA Service End Date';


--
-- Name: COLUMN account_move.extract_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_attachment_id IS 'Extract Attachment';


--
-- Name: COLUMN account_move.extract_detected_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_detected_layout IS 'Extract Detected Layout Id';


--
-- Name: COLUMN account_move.extract_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_state IS 'Extract state';


--
-- Name: COLUMN account_move.extract_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_status IS 'Extract status';


--
-- Name: COLUMN account_move.extract_document_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_move.extract_partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_partner_name IS 'Extract Detected Partner Name';


--
-- Name: COLUMN account_move.extracted_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extracted_words IS 'Extracted Words';


--
-- Name: COLUMN account_move.extracted_numbers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extracted_numbers IS 'Extracted Numbers';


--
-- Name: COLUMN account_move.extracted_dates; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extracted_dates IS 'Extracted Dates';


--
-- Name: COLUMN account_move.extract_prefill_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_prefill_data IS 'Extract Prefill Data';


--
-- Name: COLUMN account_move.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_move.extract_state_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_state_processed IS 'Extract State Processed';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_mode IS 'ARCA Authorization Mode';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code IS 'Authorization Code';


--
-- Name: COLUMN account_move.l10n_ar_afip_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_result IS 'Result';


--
-- Name: COLUMN account_move.l10n_ar_afip_verification_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_verification_result IS 'ARCA Verification result';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code_due IS 'Authorization Due date';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_request IS 'XML Request';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_response IS 'XML Response';


--
-- Name: COLUMN account_move.l10n_ar_afip_fce_is_cancellation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_fce_is_cancellation IS 'FCE: Is Cancellation?';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_start IS 'Associated Period Start';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_end IS 'Associated Perdio End';


--
-- Name: account_move__account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move__account_payment (
    invoice_id integer NOT NULL,
    payment_id integer NOT NULL
);


ALTER TABLE public.account_move__account_payment OWNER TO runbot;

--
-- Name: TABLE account_move__account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move__account_payment IS 'RELATION BETWEEN account_move AND account_payment';


--
-- Name: account_move_account_move_send_batch_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_move_send_batch_wizard_rel (
    account_move_send_batch_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_move_send_batch_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_move_send_batch_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_move_send_batch_wizard_rel IS 'RELATION BETWEEN account_move_send_batch_wizard AND account_move';


--
-- Name: account_move_account_resequence_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_resequence_wizard_rel (
    account_resequence_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_resequence_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_resequence_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_resequence_wizard_rel IS 'RELATION BETWEEN account_resequence_wizard AND account_move';


--
-- Name: account_move_change_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_change_rate (
    id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    currency_rate numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_change_rate OWNER TO runbot;

--
-- Name: TABLE account_move_change_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_change_rate IS 'account.move.change.rate';


--
-- Name: COLUMN account_move_change_rate.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.move_id IS 'Move';


--
-- Name: COLUMN account_move_change_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_change_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_change_rate.currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move_change_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_move_change_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_date IS 'Last Updated on';


--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_change_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_change_rate_id_seq OWNER TO runbot;

--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_change_rate_id_seq OWNED BY public.account_move_change_rate.id;


--
-- Name: account_move_debit_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_debit_move (
    debit_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_debit_move OWNER TO runbot;

--
-- Name: TABLE account_move_debit_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_debit_move IS 'RELATION BETWEEN account_debit_note AND account_move';


--
-- Name: account_move_deferred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_deferred_rel (
    original_move_id integer NOT NULL,
    deferred_move_id integer NOT NULL
);


ALTER TABLE public.account_move_deferred_rel OWNER TO runbot;

--
-- Name: TABLE account_move_deferred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_deferred_rel IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_id_seq OWNER TO runbot;

--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_l10n_ar_boarding_permission_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_l10n_ar_boarding_permission_rel (
    account_move_id integer NOT NULL,
    l10n_ar_boarding_permission_id integer NOT NULL
);


ALTER TABLE public.account_move_l10n_ar_boarding_permission_rel OWNER TO runbot;

--
-- Name: TABLE account_move_l10n_ar_boarding_permission_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_l10n_ar_boarding_permission_rel IS 'RELATION BETWEEN account_move AND l10n_ar_boarding_permission';


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    sequence integer,
    account_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    group_tax_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_repartition_line_id integer,
    full_reconcile_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    move_name character varying,
    parent_state character varying,
    ref character varying,
    name character varying,
    matching_number character varying,
    display_type character varying NOT NULL,
    date date,
    invoice_date date,
    date_maturity date,
    discount_date date,
    analytic_distribution jsonb,
    extra_tax_data jsonb,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    tax_base_amount numeric,
    amount_residual numeric,
    amount_residual_currency numeric,
    quantity numeric,
    price_unit numeric,
    price_subtotal numeric,
    price_total numeric,
    discount numeric,
    discount_amount_currency numeric,
    discount_balance numeric,
    is_storno boolean,
    is_imported boolean,
    reconciled boolean,
    collapse_composition boolean,
    collapse_prices boolean,
    no_followup boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    deductible_amount double precision,
    deferred_start_date date,
    deferred_end_date date,
    exclude_bank_lines boolean,
    l10n_latam_document_type_id integer,
    is_downpayment boolean,
    followup_line_id integer,
    user_id integer,
    subscription_mrr numeric,
    subscription_id integer,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_subsection'::character varying, 'line_note'::character varying])::text[])) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_subsection'::character varying, 'line_note'::character varying])::text[])) OR (((balance <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR ((balance >= (0)::numeric) AND (amount_currency >= (0)::numeric))))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_subsection'::character varying, 'line_note'::character varying])::text[])) OR ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_subsection'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


ALTER TABLE public.account_move_line OWNER TO runbot;

--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Originator Statement Line';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.group_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.group_tax_id IS 'Originator Group of Taxes';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Distribution Line';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.matching_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.matching_number IS 'Matching #';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.discount_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_date IS 'Discount Date';


--
-- Name: COLUMN account_move_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_move_line.extra_tax_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.extra_tax_data IS 'Extra Tax Data';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.discount_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_amount_currency IS 'Discount amount in Currency';


--
-- Name: COLUMN account_move_line.discount_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_balance IS 'Discount Balance';


--
-- Name: COLUMN account_move_line.is_storno; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_storno IS 'Company Storno Accounting';


--
-- Name: COLUMN account_move_line.is_imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_imported IS 'Is Imported';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.collapse_composition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.collapse_composition IS 'Hide Composition';


--
-- Name: COLUMN account_move_line.collapse_prices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.collapse_prices IS 'Hide Prices';


--
-- Name: COLUMN account_move_line.no_followup; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.no_followup IS 'No Follow-Up';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.deductible_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deductible_amount IS 'Deductibility';


--
-- Name: COLUMN account_move_line.deferred_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deferred_start_date IS 'Start Date';


--
-- Name: COLUMN account_move_line.deferred_end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deferred_end_date IS 'End Date';


--
-- Name: COLUMN account_move_line.exclude_bank_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.exclude_bank_lines IS 'Exclude Bank Lines';


--
-- Name: COLUMN account_move_line.is_downpayment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_downpayment IS 'Is Downpayment';


--
-- Name: COLUMN account_move_line.followup_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.followup_line_id IS 'Follow-up Level';


--
-- Name: COLUMN account_move_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.user_id IS 'Contact Salesperson';


--
-- Name: COLUMN account_move_line.subscription_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.subscription_id IS 'Subscription';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_subsection'', ''line_note'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                display_type IN (''line_section'', ''line_subsection'', ''line_note'')
                OR (
                    (balance <= 0 AND amount_currency <= 0)
                    OR
                    (balance >= 0 AND amount_currency >= 0)
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_subsection'', ''line_note'') OR credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_subsection'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_payment_rel (
    account_move_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_payment_rel IS 'RELATION BETWEEN account_move_line AND account_payment';


--
-- Name: account_move_line_account_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_reconcile_wizard_rel (
    account_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_reconcile_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_reconcile_wizard_rel IS 'RELATION BETWEEN account_reconcile_wizard AND account_move_line';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_line_id_seq OWNER TO runbot;

--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_line_l10n_us_1099_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_l10n_us_1099_wizard_rel (
    l10n_us_1099_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_l10n_us_1099_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_l10n_us_1099_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_l10n_us_1099_wizard_rel IS 'RELATION BETWEEN l10n_us_1099_wizard AND account_move_line';


--
-- Name: account_move_line_payment_to_pay_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_payment_to_pay_rel (
    payment_id integer NOT NULL,
    to_pay_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_payment_to_pay_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_payment_to_pay_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_payment_to_pay_rel IS 'RELATION BETWEEN account_payment AND account_move_line';


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_latam_document_type_id integer,
    l10n_latam_document_number character varying,
    l10n_ar_afip_fce_is_cancellation boolean
);


ALTER TABLE public.account_move_reversal OWNER TO runbot;

--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_reversal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.company_id IS 'Company';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason displayed on Credit Note';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_number IS 'Document Number';


--
-- Name: COLUMN account_move_reversal.l10n_ar_afip_fce_is_cancellation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_ar_afip_fce_is_cancellation IS 'FCE: Is Cancellation?';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_reversal_id_seq OWNER TO runbot;

--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_move_reversal_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_move (
    reversal_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_reversal_new_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_new_move (
    reversal_id integer NOT NULL,
    new_move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_new_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_new_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_new_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_send_batch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_batch_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_batch_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_batch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_batch_wizard IS 'Account Move Send Batch Wizard';


--
-- Name: COLUMN account_move_send_batch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_batch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_batch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_batch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_batch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNED BY public.account_move_send_batch_wizard.id;


--
-- Name: account_move_send_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard (
    id integer NOT NULL,
    template_id integer,
    move_id integer NOT NULL,
    pdf_report_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    model character varying,
    template_name character varying,
    sending_method_checkboxes jsonb,
    extra_edi_checkboxes jsonb,
    mail_attachments_widget jsonb,
    body text,
    res_ids text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard IS 'Account Move Send Wizard';


--
-- Name: COLUMN account_move_send_wizard.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.template_id IS 'Mail Template';


--
-- Name: COLUMN account_move_send_wizard.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.move_id IS 'Move';


--
-- Name: COLUMN account_move_send_wizard.pdf_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.pdf_report_id IS 'Invoice report';


--
-- Name: COLUMN account_move_send_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_wizard.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.lang IS 'Language';


--
-- Name: COLUMN account_move_send_wizard.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.subject IS 'Subject';


--
-- Name: COLUMN account_move_send_wizard.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.model IS 'Related Document Model';


--
-- Name: COLUMN account_move_send_wizard.template_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.template_name IS 'Template Name';


--
-- Name: COLUMN account_move_send_wizard.sending_method_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.sending_method_checkboxes IS 'Sending Method Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.extra_edi_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.extra_edi_checkboxes IS 'Extra Edi Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_move_send_wizard.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.body IS 'Contents';


--
-- Name: COLUMN account_move_send_wizard.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN account_move_send_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNED BY public.account_move_send_wizard.id;


--
-- Name: account_move_send_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard_res_partner_rel (
    account_move_send_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_move_send_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard_res_partner_rel IS 'RELATION BETWEEN account_move_send_wizard AND res_partner';


--
-- Name: account_move_validate_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_validate_account_move_rel (
    validate_account_move_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_validate_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_move_validate_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_validate_account_move_rel IS 'RELATION BETWEEN validate_account_move AND account_move';


--
-- Name: account_multicurrency_revaluation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_multicurrency_revaluation_wizard (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_multicurrency_revaluation_wizard OWNER TO runbot;

--
-- Name: TABLE account_multicurrency_revaluation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_multicurrency_revaluation_wizard IS 'Multicurrency Revaluation Wizard';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.date IS 'Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_date IS 'Last Updated on';


--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNER TO runbot;

--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNED BY public.account_multicurrency_revaluation_wizard.id;


--
-- Name: account_online_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_account (
    id integer NOT NULL,
    account_online_link_id integer,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    online_identifier character varying,
    account_number character varying,
    account_data character varying,
    fetching_status character varying,
    last_sync date,
    inverse_balance_sign boolean,
    inverse_transaction_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    balance double precision,
    available_balance double precision
);


ALTER TABLE public.account_online_account OWNER TO runbot;

--
-- Name: TABLE account_online_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_account IS 'representation of an online bank account';


--
-- Name: COLUMN account_online_account.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_online_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.currency_id IS 'Currency';


--
-- Name: COLUMN account_online_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.name IS 'Account Name';


--
-- Name: COLUMN account_online_account.online_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.online_identifier IS 'Online Identifier';


--
-- Name: COLUMN account_online_account.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_number IS 'Account Number';


--
-- Name: COLUMN account_online_account.account_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_data IS 'Account Data';


--
-- Name: COLUMN account_online_account.fetching_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.fetching_status IS 'Fetching Status';


--
-- Name: COLUMN account_online_account.last_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.last_sync IS 'Last Transaction Synchronized on';


--
-- Name: COLUMN account_online_account.inverse_balance_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_balance_sign IS 'Inverse Balance Sign';


--
-- Name: COLUMN account_online_account.inverse_transaction_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_transaction_sign IS 'Inverse Transaction Sign';


--
-- Name: COLUMN account_online_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_date IS 'Created on';


--
-- Name: COLUMN account_online_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_online_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.balance IS 'Balance';


--
-- Name: COLUMN account_online_account.available_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.available_balance IS 'Available Balance';


--
-- Name: account_online_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_account_id_seq OWNER TO runbot;

--
-- Name: account_online_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_account_id_seq OWNED BY public.account_online_account.id;


--
-- Name: account_online_link; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_link (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    client_id character varying,
    refresh_token character varying,
    access_token character varying,
    provider_type character varying,
    renewal_contact_email character varying,
    expiring_synchronization_date date,
    connection_state_details jsonb,
    auto_sync boolean,
    has_unlinked_accounts boolean,
    last_refresh timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_online_link OWNER TO runbot;

--
-- Name: TABLE account_online_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_link IS 'Bank Connection';


--
-- Name: COLUMN account_online_link.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.company_id IS 'Company';


--
-- Name: COLUMN account_online_link.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_link.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_link.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.state IS 'State';


--
-- Name: COLUMN account_online_link.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.name IS 'Name';


--
-- Name: COLUMN account_online_link.client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.client_id IS 'Client';


--
-- Name: COLUMN account_online_link.refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.refresh_token IS 'Refresh Token';


--
-- Name: COLUMN account_online_link.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.access_token IS 'Access Token';


--
-- Name: COLUMN account_online_link.provider_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.provider_type IS 'Provider Type';


--
-- Name: COLUMN account_online_link.renewal_contact_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.renewal_contact_email IS 'Connection Requests';


--
-- Name: COLUMN account_online_link.expiring_synchronization_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.expiring_synchronization_date IS 'Expiring Synchronization Date';


--
-- Name: COLUMN account_online_link.connection_state_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.connection_state_details IS 'Connection State Details';


--
-- Name: COLUMN account_online_link.auto_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.auto_sync IS 'Automatic synchronization';


--
-- Name: COLUMN account_online_link.has_unlinked_accounts; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.has_unlinked_accounts IS 'Has Unlinked Accounts';


--
-- Name: COLUMN account_online_link.last_refresh; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.last_refresh IS 'Last Synchronization';


--
-- Name: COLUMN account_online_link.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_date IS 'Created on';


--
-- Name: COLUMN account_online_link.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_date IS 'Last Updated on';


--
-- Name: account_online_link_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_link_id_seq OWNER TO runbot;

--
-- Name: account_online_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_link_id_seq OWNED BY public.account_online_link.id;


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    full_reconcile_id integer,
    exchange_move_id integer,
    debit_currency_id integer,
    credit_currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    max_date date,
    draft_caba_move_vals jsonb,
    amount numeric,
    debit_amount_currency numeric,
    credit_amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_partial_reconcile OWNER TO runbot;

--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_partial_reconcile.debit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_currency_id IS 'Currency of the debit journal item.';


--
-- Name: COLUMN account_partial_reconcile.credit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_currency_id IS 'Currency of the credit journal item.';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.draft_caba_move_vals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.draft_caba_move_vals IS 'Values that created the draft cash-basis entry';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.debit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_amount_currency IS 'Debit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.credit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_amount_currency IS 'Credit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    move_id integer,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    partner_bank_id integer,
    paired_internal_transfer_payment_id integer,
    payment_method_line_id integer,
    payment_method_id integer,
    currency_id integer,
    partner_id integer,
    outstanding_account_id integer,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    state character varying NOT NULL,
    payment_type character varying NOT NULL,
    partner_type character varying NOT NULL,
    memo character varying,
    payment_reference character varying,
    date date NOT NULL,
    amount numeric,
    amount_company_currency_signed numeric,
    is_reconciled boolean,
    is_matched boolean,
    is_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    batch_payment_id integer,
    check_number character varying,
    check_amount_in_words character varying,
    destination_company_id integer,
    destination_journal_id integer,
    is_internal_transfer boolean,
    payment_transaction_id integer,
    payment_token_id integer,
    source_payment_id integer,
    counterpart_currency_id integer,
    write_off_type_id integer,
    counterpart_exchange_rate numeric,
    force_amount_company_currency numeric,
    unreconciled_amount numeric,
    write_off_amount numeric,
    l10n_latam_move_check_ids_operation_date timestamp without time zone,
    l10n_ar_fiscal_position_id integer,
    withholdable_advanced_amount numeric,
    CONSTRAINT account_payment_check_amount_not_negative CHECK ((amount >= 0.0))
);


ALTER TABLE public.account_payment OWNER TO runbot;

--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.company_id IS 'Company';


--
-- Name: COLUMN account_payment.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.paired_internal_transfer_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.paired_internal_transfer_payment_id IS 'Paired Internal Transfer Payment';


--
-- Name: COLUMN account_payment.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Method';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment.outstanding_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN account_payment.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_account_id IS 'Destination Account';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.name IS 'Number';


--
-- Name: COLUMN account_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.state IS 'State';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.memo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.memo IS 'Memo';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.date IS 'Date';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.amount_company_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount_company_currency_signed IS 'Amount Company Currency Signed';


--
-- Name: COLUMN account_payment.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_payment.is_matched; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_matched IS 'Is Matched With a Bank Statement';


--
-- Name: COLUMN account_payment.is_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_sent IS 'Is Sent';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_payment.check_amount_in_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.check_amount_in_words IS 'Amount in Words';


--
-- Name: COLUMN account_payment.destination_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_company_id IS 'Destination Company';


--
-- Name: COLUMN account_payment.destination_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_payment.is_internal_transfer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_internal_transfer IS 'Internal Transfer';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved Payment Token';


--
-- Name: COLUMN account_payment.source_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.source_payment_id IS 'Source Payment';


--
-- Name: COLUMN account_payment.counterpart_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_currency_id IS 'Counterpart Currency';


--
-- Name: COLUMN account_payment.write_off_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_off_type_id IS 'Write Off Type';


--
-- Name: COLUMN account_payment.counterpart_exchange_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_exchange_rate IS 'Counterpart Exchange Rate';


--
-- Name: COLUMN account_payment.force_amount_company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.force_amount_company_currency IS 'Forced Amount on Company Currency';


--
-- Name: COLUMN account_payment.unreconciled_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.unreconciled_amount IS 'Adjustment / Advance';


--
-- Name: COLUMN account_payment.write_off_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_off_amount IS 'Write Off Amount';


--
-- Name: COLUMN account_payment.l10n_latam_move_check_ids_operation_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_latam_move_check_ids_operation_date IS 'Operation Date';


--
-- Name: COLUMN account_payment.l10n_ar_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_ar_fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_payment.withholdable_advanced_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholdable_advanced_amount IS 'Adjustment / Advance (untaxed)';


--
-- Name: CONSTRAINT account_payment_check_amount_not_negative ON account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_payment_check_amount_not_negative ON public.account_payment IS 'CHECK(amount >= 0.0)';


--
-- Name: account_payment_account_bank_statement_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_account_bank_statement_line_rel (
    account_bank_statement_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_bank_statement_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_account_bank_statement_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_account_bank_statement_line_rel IS 'RELATION BETWEEN account_bank_statement_line AND account_payment';


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_id_seq OWNER TO runbot;

--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_invoice_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_invoice_wizard (
    id integer NOT NULL,
    payment_id integer NOT NULL,
    journal_id integer NOT NULL,
    product_id integer NOT NULL,
    product_account_id integer,
    journal_document_type_id integer,
    create_uid integer,
    write_uid integer,
    description character varying,
    document_number character varying,
    invoice_date date NOT NULL,
    date date,
    analytic_distribution jsonb,
    amount_total numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    origin_invoice_id integer,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date
);


ALTER TABLE public.account_payment_invoice_wizard OWNER TO runbot;

--
-- Name: TABLE account_payment_invoice_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_invoice_wizard IS 'account.payment.invoice.wizard';


--
-- Name: COLUMN account_payment_invoice_wizard.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.payment_id IS 'Payment';


--
-- Name: COLUMN account_payment_invoice_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_invoice_wizard.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.product_id IS 'Product';


--
-- Name: COLUMN account_payment_invoice_wizard.product_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.product_account_id IS 'Product Account';


--
-- Name: COLUMN account_payment_invoice_wizard.journal_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.journal_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_payment_invoice_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_invoice_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_invoice_wizard.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.description IS 'Reason';


--
-- Name: COLUMN account_payment_invoice_wizard.document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.document_number IS 'Document Number';


--
-- Name: COLUMN account_payment_invoice_wizard.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.invoice_date IS 'Refund Date';


--
-- Name: COLUMN account_payment_invoice_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.date IS 'Accounting Date';


--
-- Name: COLUMN account_payment_invoice_wizard.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_payment_invoice_wizard.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.amount_total IS 'Total Amount';


--
-- Name: COLUMN account_payment_invoice_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_invoice_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_invoice_wizard.origin_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.origin_invoice_id IS 'Origin Invoice';


--
-- Name: COLUMN account_payment_invoice_wizard.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.l10n_ar_afip_asoc_period_start IS 'Associate Period From';


--
-- Name: COLUMN account_payment_invoice_wizard.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.l10n_ar_afip_asoc_period_end IS 'Associate Period To';


--
-- Name: account_payment_invoice_wizard_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_invoice_wizard_account_tax_rel (
    account_payment_invoice_wizard_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_payment_invoice_wizard_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_invoice_wizard_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_invoice_wizard_account_tax_rel IS 'RELATION BETWEEN account_payment_invoice_wizard AND account_tax';


--
-- Name: account_payment_invoice_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_invoice_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_invoice_wizard_id_seq OWNER TO runbot;

--
-- Name: account_payment_invoice_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_invoice_wizard_id_seq OWNED BY public.account_payment_invoice_wizard.id;


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_method OWNER TO runbot;

--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_method_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method_line (
    id integer NOT NULL,
    sequence integer,
    payment_method_id integer NOT NULL,
    payment_account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_provider_id integer
);


ALTER TABLE public.account_payment_method_line OWNER TO runbot;

--
-- Name: TABLE account_payment_method_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method_line IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_method_line.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_method_line.payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_account_id IS 'Payment Account';


--
-- Name: COLUMN account_payment_method_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_method_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.name IS 'Name';


--
-- Name: COLUMN account_payment_method_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_method_line.payment_provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_provider_id IS 'Payment Provider';


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_line_id_seq OWNED BY public.account_payment_method_line.id;


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    currency_id integer,
    journal_id integer,
    partner_bank_id integer,
    custom_user_currency_id integer,
    source_currency_id integer,
    company_id integer,
    partner_id integer,
    payment_method_line_id integer,
    writeoff_account_id integer,
    create_uid integer,
    write_uid integer,
    communication character varying,
    installments_mode character varying,
    payment_type character varying,
    partner_type character varying,
    payment_difference_handling character varying,
    writeoff_label character varying,
    payment_date date NOT NULL,
    amount numeric,
    custom_user_amount numeric,
    source_amount numeric,
    source_amount_currency numeric,
    group_payment boolean,
    can_edit_wizard boolean,
    can_group_payments boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_token_id integer,
    l10n_ar_fiscal_position_id integer
);


ALTER TABLE public.account_payment_register OWNER TO runbot;

--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register IS 'Pay';


--
-- Name: COLUMN account_payment_register.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment_register.custom_user_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_currency_id IS 'Custom User Currency';


--
-- Name: COLUMN account_payment_register.source_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_currency_id IS 'Source Currency';


--
-- Name: COLUMN account_payment_register.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.company_id IS 'Company';


--
-- Name: COLUMN account_payment_register.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_register.writeoff_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.communication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.communication IS 'Memo';


--
-- Name: COLUMN account_payment_register.installments_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.installments_mode IS 'Installments Mode';


--
-- Name: COLUMN account_payment_register.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_register.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_register.payment_difference_handling; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment_register.writeoff_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.amount IS 'Amount';


--
-- Name: COLUMN account_payment_register.custom_user_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_amount IS 'Custom User Amount';


--
-- Name: COLUMN account_payment_register.source_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount IS 'Amount to Pay (company currency)';


--
-- Name: COLUMN account_payment_register.source_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount_currency IS 'Amount to Pay (foreign currency)';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payments';


--
-- Name: COLUMN account_payment_register.can_edit_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_edit_wizard IS 'Can Edit Wizard';


--
-- Name: COLUMN account_payment_register.can_group_payments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_group_payments IS 'Can Group Payments';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_register.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_token_id IS 'Saved payment token';


--
-- Name: COLUMN account_payment_register.l10n_ar_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.l10n_ar_fiscal_position_id IS 'Fiscal Position';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_register_id_seq OWNER TO runbot;

--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_register_l10n_latam_check_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_l10n_latam_check_rel (
    account_payment_register_id integer NOT NULL,
    l10n_latam_check_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_l10n_latam_check_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_l10n_latam_check_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_l10n_latam_check_rel IS 'RELATION BETWEEN account_payment_register AND l10n_latam_check';


--
-- Name: account_payment_register_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_move_line_rel (
    wizard_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_move_line_rel IS 'RELATION BETWEEN account_payment_register AND account_move_line';


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    company_id integer,
    sequence integer NOT NULL,
    discount_days integer,
    create_uid integer,
    write_uid integer,
    early_pay_discount_computation character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    display_on_invoice boolean,
    early_discount boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_percentage double precision
);


ALTER TABLE public.account_payment_term OWNER TO runbot;

--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.discount_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_days IS 'Discount Days';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.early_pay_discount_computation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_pay_discount_computation IS 'Cash Discount Tax Reduction';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.display_on_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.display_on_invoice IS 'Show installment dates';


--
-- Name: COLUMN account_payment_term.early_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_discount IS 'Early Discount';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term.discount_percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_percentage IS 'Discount %';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    nb_days integer,
    payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    delay_type character varying NOT NULL,
    days_next_month character varying(2),
    value_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_term_line OWNER TO runbot;

--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.nb_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.nb_days IS 'Days';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Value';


--
-- Name: COLUMN account_payment_term_line.delay_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.delay_type IS 'Delay Type';


--
-- Name: COLUMN account_payment_term_line.days_next_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.days_next_month IS 'Days on the next month';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Due';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    next_activity_type_id integer,
    mapped_partner_id integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    match_amount character varying,
    match_label character varying,
    match_label_param character varying,
    name jsonb NOT NULL,
    active boolean,
    can_be_proposed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    match_amount_min double precision,
    match_amount_max double precision,
    created_automatically boolean
);


ALTER TABLE public.account_reconcile_model OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.next_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.next_activity_type_id IS 'Next Activity';


--
-- Name: COLUMN account_reconcile_model.mapped_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.mapped_partner_id IS 'Mapped Partner';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.trigger IS 'Trigger';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.active IS 'Active';


--
-- Name: COLUMN account_reconcile_model.can_be_proposed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.can_be_proposed IS 'Can Be Proposed';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.created_automatically; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.created_automatically IS 'Created Automatically';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line (
    id integer NOT NULL,
    model_id integer,
    company_id integer,
    sequence integer NOT NULL,
    account_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying NOT NULL,
    amount_string character varying NOT NULL,
    analytic_distribution jsonb,
    label jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_reconcile_model_line OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line IS 'Rules for the reconciliation model';


--
-- Name: COLUMN account_reconcile_model_line.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line.amount_string; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_reconcile_model_line.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.label IS 'Label';


--
-- Name: COLUMN account_reconcile_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount IS 'Float Amount';


--
-- Name: account_reconcile_model_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_account_tax_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_tax';


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNED BY public.account_reconcile_model_line.id;


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_reconcile_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_wizard (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    account_id integer,
    to_partner_id integer,
    tax_id integer,
    create_uid integer,
    write_uid integer,
    label character varying,
    date date,
    edit_mode_amount_currency numeric,
    allow_partials boolean,
    to_check boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_wizard OWNER TO runbot;

--
-- Name: TABLE account_reconcile_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_wizard IS 'Account reconciliation wizard';


--
-- Name: COLUMN account_reconcile_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_wizard.to_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_wizard.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.tax_id IS 'Tax';


--
-- Name: COLUMN account_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_wizard.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.label IS 'Label';


--
-- Name: COLUMN account_reconcile_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.date IS 'Date';


--
-- Name: COLUMN account_reconcile_wizard.edit_mode_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.edit_mode_amount_currency IS 'Edit mode amount';


--
-- Name: COLUMN account_reconcile_wizard.allow_partials; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.allow_partials IS 'Allow partials';


--
-- Name: COLUMN account_reconcile_wizard.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNED BY public.account_reconcile_wizard.id;


--
-- Name: account_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report (
    id integer NOT NULL,
    sequence integer,
    root_report_id integer,
    country_id integer,
    load_more_limit integer,
    prefix_groups_threshold integer,
    create_uid integer,
    write_uid integer,
    chart_template character varying,
    availability_condition character varying,
    integer_rounding character varying,
    default_opening_date_filter character varying,
    currency_translation character varying,
    filter_multi_company character varying,
    filter_hide_0_lines character varying,
    filter_hierarchy character varying,
    filter_account_type character varying,
    name jsonb NOT NULL,
    active boolean,
    use_sections boolean,
    only_tax_exigible boolean,
    search_bar boolean,
    allow_foreign_vat boolean,
    filter_date_range boolean,
    filter_show_draft boolean,
    filter_unreconciled boolean,
    filter_unfold_all boolean,
    filter_period_comparison boolean,
    filter_growth_comparison boolean,
    filter_journals boolean,
    filter_analytic boolean,
    filter_partner boolean,
    filter_aml_ir_filters boolean,
    filter_budgets boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    custom_handler_model_id integer,
    send_and_print_values jsonb,
    allow_account_audit_status_on_lines boolean,
    filter_analytic_groupby boolean,
    require_custom_filter boolean,
    filter_show_all_custom boolean
);


ALTER TABLE public.account_report OWNER TO runbot;

--
-- Name: TABLE account_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report IS 'Accounting Report';


--
-- Name: COLUMN account_report.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.sequence IS 'Sequence';


--
-- Name: COLUMN account_report.root_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.root_report_id IS 'Root Report';


--
-- Name: COLUMN account_report.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.country_id IS 'Country';


--
-- Name: COLUMN account_report.load_more_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.load_more_limit IS 'Load More Limit';


--
-- Name: COLUMN account_report.prefix_groups_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.prefix_groups_threshold IS 'Prefix Groups Threshold';


--
-- Name: COLUMN account_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report.chart_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.chart_template IS 'Chart of Accounts';


--
-- Name: COLUMN account_report.availability_condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.availability_condition IS 'Availability';


--
-- Name: COLUMN account_report.integer_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.integer_rounding IS 'Integer Rounding';


--
-- Name: COLUMN account_report.default_opening_date_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.default_opening_date_filter IS 'Default Opening';


--
-- Name: COLUMN account_report.currency_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.currency_translation IS 'Currency Translation';


--
-- Name: COLUMN account_report.filter_multi_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_multi_company IS 'Multi-Company';


--
-- Name: COLUMN account_report.filter_hide_0_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hide_0_lines IS 'Hide lines at 0';


--
-- Name: COLUMN account_report.filter_hierarchy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hierarchy IS 'Account Groups';


--
-- Name: COLUMN account_report.filter_account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_account_type IS 'Account Types';


--
-- Name: COLUMN account_report.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.name IS 'Name';


--
-- Name: COLUMN account_report.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.active IS 'Active';


--
-- Name: COLUMN account_report.use_sections; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.use_sections IS 'Composite Report';


--
-- Name: COLUMN account_report.only_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.only_tax_exigible IS 'Only Tax Exigible Lines';


--
-- Name: COLUMN account_report.search_bar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.search_bar IS 'Search Bar';


--
-- Name: COLUMN account_report.allow_foreign_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.allow_foreign_vat IS 'Allow Foreign VAT';


--
-- Name: COLUMN account_report.filter_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_date_range IS 'Date Range';


--
-- Name: COLUMN account_report.filter_show_draft; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_show_draft IS 'Draft Entries';


--
-- Name: COLUMN account_report.filter_unreconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unreconciled IS 'Unreconciled Entries';


--
-- Name: COLUMN account_report.filter_unfold_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unfold_all IS 'Unfold All';


--
-- Name: COLUMN account_report.filter_period_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_period_comparison IS 'Period Comparison';


--
-- Name: COLUMN account_report.filter_growth_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_growth_comparison IS 'Growth Comparison';


--
-- Name: COLUMN account_report.filter_journals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_journals IS 'Journals';


--
-- Name: COLUMN account_report.filter_analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic IS 'Analytic Filter';


--
-- Name: COLUMN account_report.filter_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_partner IS 'Partners';


--
-- Name: COLUMN account_report.filter_aml_ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_aml_ir_filters IS 'Favorite Filters';


--
-- Name: COLUMN account_report.filter_budgets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_budgets IS 'Budgets';


--
-- Name: COLUMN account_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_date IS 'Created on';


--
-- Name: COLUMN account_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report.custom_handler_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.custom_handler_model_id IS 'Custom Handler Model';


--
-- Name: COLUMN account_report.send_and_print_values; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.send_and_print_values IS 'Send And Print Values';


--
-- Name: COLUMN account_report.allow_account_audit_status_on_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.allow_account_audit_status_on_lines IS 'Allow Account Audit Status On Lines';


--
-- Name: COLUMN account_report.filter_analytic_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic_groupby IS 'Analytic Group By';


--
-- Name: COLUMN account_report.require_custom_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.require_custom_filter IS 'Require Custom Filter';


--
-- Name: COLUMN account_report.filter_show_all_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_show_all_custom IS 'Show All';


--
-- Name: account_report_account_report_horizontal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_account_report_horizontal_group_rel (
    account_report_id integer NOT NULL,
    account_report_horizontal_group_id integer NOT NULL
);


ALTER TABLE public.account_report_account_report_horizontal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_report_account_report_horizontal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_account_report_horizontal_group_rel IS 'RELATION BETWEEN account_report AND account_report_horizontal_group';


--
-- Name: account_report_annotation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_annotation (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_annotation OWNER TO runbot;

--
-- Name: TABLE account_report_annotation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_annotation IS 'Account Report Annotation';


--
-- Name: COLUMN account_report_annotation.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.message_id IS 'Message';


--
-- Name: COLUMN account_report_annotation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_annotation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_annotation.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.date IS 'Date';


--
-- Name: COLUMN account_report_annotation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.create_date IS 'Created on';


--
-- Name: COLUMN account_report_annotation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.write_date IS 'Last Updated on';


--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_annotation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_annotation_id_seq OWNER TO runbot;

--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_annotation_id_seq OWNED BY public.account_report_annotation.id;


--
-- Name: account_report_budget; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_budget (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_budget OWNER TO runbot;

--
-- Name: TABLE account_report_budget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_budget IS 'Accounting Report Budget';


--
-- Name: COLUMN account_report_budget.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_budget.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.company_id IS 'Company';


--
-- Name: COLUMN account_report_budget.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.name IS 'Name';


--
-- Name: COLUMN account_report_budget.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.write_date IS 'Last Updated on';


--
-- Name: account_report_budget_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_budget_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_id_seq OWNER TO runbot;

--
-- Name: account_report_budget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_budget_id_seq OWNED BY public.account_report_budget.id;


--
-- Name: account_report_budget_item; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_budget_item (
    id integer NOT NULL,
    budget_id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_report_budget_item OWNER TO runbot;

--
-- Name: TABLE account_report_budget_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_budget_item IS 'Accounting Report Budget Item';


--
-- Name: COLUMN account_report_budget_item.budget_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.budget_id IS 'Budget';


--
-- Name: COLUMN account_report_budget_item.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.account_id IS 'Account';


--
-- Name: COLUMN account_report_budget_item.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget_item.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget_item.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.date IS 'Date';


--
-- Name: COLUMN account_report_budget_item.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget_item.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_budget_item.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.amount IS 'Amount';


--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_budget_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_item_id_seq OWNER TO runbot;

--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_budget_item_id_seq OWNED BY public.account_report_budget_item.id;


--
-- Name: account_report_column; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_column (
    id integer NOT NULL,
    sequence integer,
    report_id integer,
    custom_audit_action_id integer,
    create_uid integer,
    write_uid integer,
    expression_label character varying NOT NULL,
    figure_type character varying NOT NULL,
    name jsonb NOT NULL,
    sortable boolean,
    blank_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_column OWNER TO runbot;

--
-- Name: TABLE account_report_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_column IS 'Accounting Report Column';


--
-- Name: COLUMN account_report_column.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_column.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.report_id IS 'Report';


--
-- Name: COLUMN account_report_column.custom_audit_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.custom_audit_action_id IS 'Custom Audit Action';


--
-- Name: COLUMN account_report_column.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_column.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_column.expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.expression_label IS 'Expression Label';


--
-- Name: COLUMN account_report_column.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_column.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.name IS 'Name';


--
-- Name: COLUMN account_report_column.sortable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sortable IS 'Sortable';


--
-- Name: COLUMN account_report_column.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_column.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_date IS 'Created on';


--
-- Name: COLUMN account_report_column.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_date IS 'Last Updated on';


--
-- Name: account_report_column_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_column_id_seq OWNER TO runbot;

--
-- Name: account_report_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_column_id_seq OWNED BY public.account_report_column.id;


--
-- Name: account_report_expression; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_expression (
    id integer NOT NULL,
    report_line_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label character varying NOT NULL,
    engine character varying NOT NULL,
    formula character varying NOT NULL,
    subformula character varying,
    date_scope character varying NOT NULL,
    figure_type character varying,
    carryover_target character varying,
    green_on_positive boolean,
    blank_if_zero boolean,
    auditable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_report_expression_domain_engine_subformula_required CHECK ((((engine)::text <> 'domain'::text) OR (subformula IS NOT NULL)))
);


ALTER TABLE public.account_report_expression OWNER TO runbot;

--
-- Name: TABLE account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_expression IS 'Accounting Report Expression';


--
-- Name: COLUMN account_report_expression.report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.report_line_id IS 'Report Line';


--
-- Name: COLUMN account_report_expression.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_expression.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_expression.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.label IS 'Label';


--
-- Name: COLUMN account_report_expression.engine; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.engine IS 'Computation Engine';


--
-- Name: COLUMN account_report_expression.formula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.formula IS 'Formula';


--
-- Name: COLUMN account_report_expression.subformula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.subformula IS 'Subformula';


--
-- Name: COLUMN account_report_expression.date_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.date_scope IS 'Date Scope';


--
-- Name: COLUMN account_report_expression.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_expression.carryover_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.carryover_target IS 'Carry Over To';


--
-- Name: COLUMN account_report_expression.green_on_positive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.green_on_positive IS 'Is Growth Good when Positive';


--
-- Name: COLUMN account_report_expression.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_expression.auditable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.auditable IS 'Auditable';


--
-- Name: COLUMN account_report_expression.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_date IS 'Created on';


--
-- Name: COLUMN account_report_expression.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_report_expression_domain_engine_subformula_required ON account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_report_expression_domain_engine_subformula_required ON public.account_report_expression IS 'CHECK(engine != ''domain'' OR subformula IS NOT NULL)';


--
-- Name: account_report_expression_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_expression_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_expression_id_seq OWNER TO runbot;

--
-- Name: account_report_expression_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_expression_id_seq OWNED BY public.account_report_expression.id;


--
-- Name: account_report_external_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_external_value (
    id integer NOT NULL,
    target_report_expression_id integer NOT NULL,
    company_id integer NOT NULL,
    carryover_origin_report_line_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    text_value character varying,
    carryover_origin_expression_label character varying,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


ALTER TABLE public.account_report_external_value OWNER TO runbot;

--
-- Name: TABLE account_report_external_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_external_value IS 'Accounting Report External Value';


--
-- Name: COLUMN account_report_external_value.target_report_expression_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.target_report_expression_id IS 'Target Expression';


--
-- Name: COLUMN account_report_external_value.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.company_id IS 'Company';


--
-- Name: COLUMN account_report_external_value.carryover_origin_report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_report_line_id IS 'Origin Line';


--
-- Name: COLUMN account_report_external_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_external_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_external_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.name IS 'Name';


--
-- Name: COLUMN account_report_external_value.text_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.text_value IS 'Text Value';


--
-- Name: COLUMN account_report_external_value.carryover_origin_expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_expression_label IS 'Origin Expression Label';


--
-- Name: COLUMN account_report_external_value.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.date IS 'Date';


--
-- Name: COLUMN account_report_external_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_date IS 'Created on';


--
-- Name: COLUMN account_report_external_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_external_value.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.value IS 'Numeric Value';


--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_external_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_external_value_id_seq OWNER TO runbot;

--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_external_value_id_seq OWNED BY public.account_report_external_value.id;


--
-- Name: account_report_file_download_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_file_download_error_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    file_name character varying,
    actionable_errors jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_file_download_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_report_file_download_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_file_download_error_wizard IS 'Manage the file generation errors from report exports.';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_file_download_error_wizard.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.file_name IS 'File Name';


--
-- Name: COLUMN account_report_file_download_error_wizard.actionable_errors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.actionable_errors IS 'Actionable Errors';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_file_download_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNED BY public.account_report_file_download_error_wizard.id;


--
-- Name: account_report_horizontal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group IS 'Horizontal group for reports';


--
-- Name: COLUMN account_report_horizontal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.name IS 'Name';


--
-- Name: COLUMN account_report_horizontal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNED BY public.account_report_horizontal_group.id;


--
-- Name: account_report_horizontal_group_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group_rule (
    id integer NOT NULL,
    horizontal_group_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    domain character varying NOT NULL,
    field_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group_rule OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group_rule IS 'Horizontal group rule for reports';


--
-- Name: COLUMN account_report_horizontal_group_rule.horizontal_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.horizontal_group_id IS 'Horizontal Group';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group_rule.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.domain IS 'Domain';


--
-- Name: COLUMN account_report_horizontal_group_rule.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.field_name IS 'Field';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNED BY public.account_report_horizontal_group_rule.id;


--
-- Name: account_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_id_seq OWNER TO runbot;

--
-- Name: account_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_id_seq OWNED BY public.account_report.id;


--
-- Name: account_report_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_line (
    id integer NOT NULL,
    report_id integer NOT NULL,
    hierarchy_level integer NOT NULL,
    parent_id integer,
    sequence integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    groupby character varying,
    user_groupby character varying,
    code character varying,
    horizontal_split_side character varying,
    name jsonb NOT NULL,
    foldable boolean,
    print_on_new_page boolean,
    hide_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_line OWNER TO runbot;

--
-- Name: TABLE account_report_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_line IS 'Accounting Report Line';


--
-- Name: COLUMN account_report_line.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.report_id IS 'Parent Report';


--
-- Name: COLUMN account_report_line.hierarchy_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hierarchy_level IS 'Level';


--
-- Name: COLUMN account_report_line.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_report_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_line.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.action_id IS 'Action';


--
-- Name: COLUMN account_report_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_line.groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.groupby IS 'Group By';


--
-- Name: COLUMN account_report_line.user_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.user_groupby IS 'User Group By';


--
-- Name: COLUMN account_report_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.code IS 'Code';


--
-- Name: COLUMN account_report_line.horizontal_split_side; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.horizontal_split_side IS 'Horizontal Split Side';


--
-- Name: COLUMN account_report_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.name IS 'Name';


--
-- Name: COLUMN account_report_line.foldable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.foldable IS 'Foldable';


--
-- Name: COLUMN account_report_line.print_on_new_page; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.print_on_new_page IS 'Print On New Page';


--
-- Name: COLUMN account_report_line.hide_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hide_if_zero IS 'Hide if Zero';


--
-- Name: COLUMN account_report_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_report_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_date IS 'Last Updated on';


--
-- Name: account_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_line_id_seq OWNER TO runbot;

--
-- Name: account_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_line_id_seq OWNED BY public.account_report_line.id;


--
-- Name: account_report_section_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_section_rel (
    main_report_id integer NOT NULL,
    sub_report_id integer NOT NULL
);


ALTER TABLE public.account_report_section_rel OWNER TO runbot;

--
-- Name: TABLE account_report_section_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_section_rel IS 'RELATION BETWEEN account_report AND account_report';


--
-- Name: account_report_send; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_send (
    id integer NOT NULL,
    mail_template_id integer,
    account_report_id integer,
    create_uid integer,
    write_uid integer,
    mode character varying,
    mail_subject character varying,
    report_options jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    enable_download boolean,
    checkbox_download boolean,
    enable_send_mail boolean,
    checkbox_send_mail boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_send OWNER TO runbot;

--
-- Name: TABLE account_report_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_send IS 'Account Report Send';


--
-- Name: COLUMN account_report_send.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_report_send.account_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.account_report_id IS 'Report';


--
-- Name: COLUMN account_report_send.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_send.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_send.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mode IS 'Mode';


--
-- Name: COLUMN account_report_send.mail_subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_subject IS 'Subject';


--
-- Name: COLUMN account_report_send.report_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.report_options IS 'Report Options';


--
-- Name: COLUMN account_report_send.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_report_send.mail_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_body IS 'Contents';


--
-- Name: COLUMN account_report_send.enable_download; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.enable_download IS 'Enable Download';


--
-- Name: COLUMN account_report_send.checkbox_download; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.checkbox_download IS 'Download';


--
-- Name: COLUMN account_report_send.enable_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.enable_send_mail IS 'Enable Send Mail';


--
-- Name: COLUMN account_report_send.checkbox_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.checkbox_send_mail IS 'Email';


--
-- Name: COLUMN account_report_send.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.create_date IS 'Created on';


--
-- Name: COLUMN account_report_send.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.write_date IS 'Last Updated on';


--
-- Name: account_report_send_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_send_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_send_id_seq OWNER TO runbot;

--
-- Name: account_report_send_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_send_id_seq OWNED BY public.account_report_send.id;


--
-- Name: account_report_send_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_send_res_partner_rel (
    account_report_send_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_report_send_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_report_send_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_send_res_partner_rel IS 'RELATION BETWEEN account_report_send AND res_partner';


--
-- Name: account_reports_export_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard (
    id integer NOT NULL,
    report_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    doc_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reports_export_wizard OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard IS 'Export wizard for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.report_id IS 'Parent Report Id';


--
-- Name: COLUMN account_reports_export_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard.doc_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.doc_name IS 'Documents Name';


--
-- Name: COLUMN account_reports_export_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard_format (
    id integer NOT NULL,
    export_wizard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    fun_to_call character varying NOT NULL,
    fun_param character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reports_export_wizard_format OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard_format IS 'Export format for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard_format.export_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.export_wizard_id IS 'Parent Wizard';


--
-- Name: COLUMN account_reports_export_wizard_format.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard_format.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard_format.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.name IS 'Name';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_to_call; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_to_call IS 'Function to Call';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_param IS 'Function Parameter';


--
-- Name: COLUMN account_reports_export_wizard_format.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard_format.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNED BY public.account_reports_export_wizard_format.id;


--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNED BY public.account_reports_export_wizard.id;


--
-- Name: account_resequence_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_resequence_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    first_name character varying NOT NULL,
    ordering character varying NOT NULL,
    first_date date,
    end_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_resequence_wizard OWNER TO runbot;

--
-- Name: TABLE account_resequence_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_resequence_wizard IS 'Remake the sequence of Journal Entries.';


--
-- Name: COLUMN account_resequence_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_resequence_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_resequence_wizard.first_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_name IS 'First New Sequence';


--
-- Name: COLUMN account_resequence_wizard.ordering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.ordering IS 'Ordering';


--
-- Name: COLUMN account_resequence_wizard.first_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_date IS 'First Date';


--
-- Name: COLUMN account_resequence_wizard.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.end_date IS 'End Date';


--
-- Name: COLUMN account_resequence_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_resequence_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_date IS 'Last Updated on';


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_resequence_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNER TO runbot;

--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNED BY public.account_resequence_wizard.id;


--
-- Name: account_return; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return (
    id integer NOT NULL,
    message_main_attachment_id integer,
    type_id integer NOT NULL,
    company_id integer NOT NULL,
    tax_unit_id integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    generic_state_tax_report character varying,
    generic_state_only_pay character varying,
    generic_state_review_submit character varying,
    generic_state_review character varying,
    audit_status character varying NOT NULL,
    skipped_check_cycles character varying,
    date_from date NOT NULL,
    date_to date NOT NULL,
    date_deadline date,
    date_lock date,
    date_submission date,
    name jsonb NOT NULL,
    total_amount_to_pay numeric,
    period_amount_to_pay numeric,
    active boolean,
    is_completed boolean,
    manually_created boolean,
    report_opened_once boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return OWNER TO runbot;

--
-- Name: TABLE account_return; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return IS 'Accounting Return';


--
-- Name: COLUMN account_return.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_return.type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.type_id IS 'Return Type';


--
-- Name: COLUMN account_return.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.company_id IS 'Company';


--
-- Name: COLUMN account_return.tax_unit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.tax_unit_id IS 'Tax Unit';


--
-- Name: COLUMN account_return.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.create_uid IS 'Created by';


--
-- Name: COLUMN account_return.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.state IS 'State';


--
-- Name: COLUMN account_return.generic_state_tax_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.generic_state_tax_report IS 'Generic State';


--
-- Name: COLUMN account_return.generic_state_only_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.generic_state_only_pay IS 'Generic State Only Pay';


--
-- Name: COLUMN account_return.generic_state_review_submit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.generic_state_review_submit IS 'Generic State Review Submit';


--
-- Name: COLUMN account_return.generic_state_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.generic_state_review IS 'Generic State Review';


--
-- Name: COLUMN account_return.audit_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.audit_status IS 'Audit Status';


--
-- Name: COLUMN account_return.skipped_check_cycles; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.skipped_check_cycles IS 'Skipped Check Cycles';


--
-- Name: COLUMN account_return.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_from IS 'Date From';


--
-- Name: COLUMN account_return.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_to IS 'Date To';


--
-- Name: COLUMN account_return.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_deadline IS 'Deadline';


--
-- Name: COLUMN account_return.date_lock; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_lock IS 'Lock Date';


--
-- Name: COLUMN account_return.date_submission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_submission IS 'Submission Date';


--
-- Name: COLUMN account_return.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.name IS 'Name';


--
-- Name: COLUMN account_return.total_amount_to_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.total_amount_to_pay IS 'Total Amount To Pay';


--
-- Name: COLUMN account_return.period_amount_to_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.period_amount_to_pay IS 'Period Amount To Pay';


--
-- Name: COLUMN account_return.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.active IS 'Active';


--
-- Name: COLUMN account_return.is_completed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.is_completed IS 'Is Completed';


--
-- Name: COLUMN account_return.manually_created; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.manually_created IS 'Manually Created';


--
-- Name: COLUMN account_return.report_opened_once; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.report_opened_once IS 'Report Opened Once';


--
-- Name: COLUMN account_return.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.create_date IS 'Created on';


--
-- Name: COLUMN account_return.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.write_date IS 'Last Updated on';


--
-- Name: account_return_check; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check (
    id integer NOT NULL,
    template_id integer,
    records_count integer,
    records_model integer,
    return_id integer NOT NULL,
    supervisor_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    type character varying NOT NULL,
    state character varying NOT NULL,
    result character varying NOT NULL,
    return_state character varying,
    name jsonb NOT NULL,
    message jsonb,
    action jsonb,
    refresh_result boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_check OWNER TO runbot;

--
-- Name: TABLE account_return_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check IS 'Accounting Return Check';


--
-- Name: COLUMN account_return_check.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.template_id IS 'Template';


--
-- Name: COLUMN account_return_check.records_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.records_count IS 'Records Count';


--
-- Name: COLUMN account_return_check.records_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.records_model IS 'Model';


--
-- Name: COLUMN account_return_check.return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.return_id IS 'Account Return';


--
-- Name: COLUMN account_return_check.supervisor_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.supervisor_id IS 'Supervised By';


--
-- Name: COLUMN account_return_check.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_check.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_check.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.code IS 'Check ID';


--
-- Name: COLUMN account_return_check.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.type IS 'Type';


--
-- Name: COLUMN account_return_check.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.state IS 'Return State To Check For';


--
-- Name: COLUMN account_return_check.result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.result IS 'Result';


--
-- Name: COLUMN account_return_check.return_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.return_state IS 'Return State';


--
-- Name: COLUMN account_return_check.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.name IS 'Name';


--
-- Name: COLUMN account_return_check.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.message IS 'Description';


--
-- Name: COLUMN account_return_check.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.action IS 'Action';


--
-- Name: COLUMN account_return_check.refresh_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.refresh_result IS 'Refresh Result';


--
-- Name: COLUMN account_return_check.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.create_date IS 'Created on';


--
-- Name: COLUMN account_return_check.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.write_date IS 'Last Updated on';


--
-- Name: account_return_check_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_check_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_check_id_seq OWNER TO runbot;

--
-- Name: account_return_check_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_check_id_seq OWNED BY public.account_return_check.id;


--
-- Name: account_return_check_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check_ir_attachment_rel (
    account_return_check_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_return_check_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_return_check_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check_ir_attachment_rel IS 'RELATION BETWEEN account_return_check AND ir_attachment';


--
-- Name: account_return_check_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check_res_users_rel (
    account_return_check_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.account_return_check_res_users_rel OWNER TO runbot;

--
-- Name: TABLE account_return_check_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check_res_users_rel IS 'RELATION BETWEEN account_return_check AND res_users';


--
-- Name: account_return_check_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check_template (
    id integer NOT NULL,
    return_type integer NOT NULL,
    action_id integer,
    activity_type integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    cycle character varying NOT NULL,
    type character varying NOT NULL,
    additional_action_domain character varying,
    additional_action_context character varying,
    additional_action_params character varying,
    model character varying,
    domain character varying,
    name jsonb NOT NULL,
    description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_check_template OWNER TO runbot;

--
-- Name: TABLE account_return_check_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check_template IS 'Account Return Check Template';


--
-- Name: COLUMN account_return_check_template.return_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.return_type IS 'Tax Return/Audit';


--
-- Name: COLUMN account_return_check_template.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.action_id IS 'Action on Click';


--
-- Name: COLUMN account_return_check_template.activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.activity_type IS 'Activities';


--
-- Name: COLUMN account_return_check_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_check_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_check_template.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.code IS 'Code';


--
-- Name: COLUMN account_return_check_template.cycle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.cycle IS 'Cycle';


--
-- Name: COLUMN account_return_check_template.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.type IS 'Type';


--
-- Name: COLUMN account_return_check_template.additional_action_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.additional_action_domain IS 'Additional Action Domain';


--
-- Name: COLUMN account_return_check_template.additional_action_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.additional_action_context IS 'Additional Action Context';


--
-- Name: COLUMN account_return_check_template.additional_action_params; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.additional_action_params IS 'Additional Action Params';


--
-- Name: COLUMN account_return_check_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.model IS 'Model';


--
-- Name: COLUMN account_return_check_template.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.domain IS 'Domain';


--
-- Name: COLUMN account_return_check_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.name IS 'Title';


--
-- Name: COLUMN account_return_check_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.description IS 'Description';


--
-- Name: COLUMN account_return_check_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.create_date IS 'Created on';


--
-- Name: COLUMN account_return_check_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.write_date IS 'Last Updated on';


--
-- Name: account_return_check_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_check_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_check_template_id_seq OWNER TO runbot;

--
-- Name: account_return_check_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_check_template_id_seq OWNED BY public.account_return_check_template.id;


--
-- Name: account_return_check_template_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check_template_res_country_rel (
    account_return_check_template_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.account_return_check_template_res_country_rel OWNER TO runbot;

--
-- Name: TABLE account_return_check_template_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check_template_res_country_rel IS 'RELATION BETWEEN account_return_check_template AND res_country';


--
-- Name: account_return_creation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_creation_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    return_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    category character varying,
    date_from date NOT NULL,
    date_to date NOT NULL,
    regulatory_compliance boolean,
    treasury_financing boolean,
    purchases boolean,
    operating_expenses boolean,
    sales boolean,
    inventory boolean,
    fixed_assets boolean,
    payroll boolean,
    government boolean,
    equity boolean,
    other boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_creation_wizard OWNER TO runbot;

--
-- Name: TABLE account_return_creation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_creation_wizard IS 'Return creation wizard';


--
-- Name: COLUMN account_return_creation_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_return_creation_wizard.return_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.return_type_id IS 'Return Type';


--
-- Name: COLUMN account_return_creation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_creation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_creation_wizard.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.category IS 'Category';


--
-- Name: COLUMN account_return_creation_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.date_from IS 'Date From';


--
-- Name: COLUMN account_return_creation_wizard.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.date_to IS 'Date To';


--
-- Name: COLUMN account_return_creation_wizard.regulatory_compliance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.regulatory_compliance IS 'Regulatory compliance';


--
-- Name: COLUMN account_return_creation_wizard.treasury_financing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.treasury_financing IS 'Treasury and financing';


--
-- Name: COLUMN account_return_creation_wizard.purchases; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.purchases IS 'Purchases';


--
-- Name: COLUMN account_return_creation_wizard.operating_expenses; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.operating_expenses IS 'Operating expenses';


--
-- Name: COLUMN account_return_creation_wizard.sales; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.sales IS 'Sales';


--
-- Name: COLUMN account_return_creation_wizard.inventory; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.inventory IS 'Inventory';


--
-- Name: COLUMN account_return_creation_wizard.fixed_assets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.fixed_assets IS 'Fixed assets';


--
-- Name: COLUMN account_return_creation_wizard.payroll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.payroll IS 'Payroll';


--
-- Name: COLUMN account_return_creation_wizard.government; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.government IS 'Government';


--
-- Name: COLUMN account_return_creation_wizard.equity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.equity IS 'Equity';


--
-- Name: COLUMN account_return_creation_wizard.other; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.other IS 'Others';


--
-- Name: COLUMN account_return_creation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_return_creation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.write_date IS 'Last Updated on';


--
-- Name: account_return_creation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_creation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_creation_wizard_id_seq OWNER TO runbot;

--
-- Name: account_return_creation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_creation_wizard_id_seq OWNED BY public.account_return_creation_wizard.id;


--
-- Name: account_return_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_id_seq OWNER TO runbot;

--
-- Name: account_return_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_id_seq OWNED BY public.account_return.id;


--
-- Name: account_return_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_ir_attachment_rel (
    account_return_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_return_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_return_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_ir_attachment_rel IS 'RELATION BETWEEN account_return AND ir_attachment';


--
-- Name: account_return_payment_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_payment_wizard (
    id integer NOT NULL,
    company_id integer,
    partner_bank_id integer,
    return_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    amount_to_pay numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_payment_wizard OWNER TO runbot;

--
-- Name: TABLE account_return_payment_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_payment_wizard IS 'Returns Generic Payment Wizard';


--
-- Name: COLUMN account_return_payment_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_return_payment_wizard.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.partner_bank_id IS 'Partner Bank';


--
-- Name: COLUMN account_return_payment_wizard.return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.return_id IS 'Return';


--
-- Name: COLUMN account_return_payment_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_payment_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_payment_wizard.amount_to_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.amount_to_pay IS 'Amount To Pay';


--
-- Name: COLUMN account_return_payment_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_return_payment_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.write_date IS 'Last Updated on';


--
-- Name: account_return_payment_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_payment_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_payment_wizard_id_seq OWNER TO runbot;

--
-- Name: account_return_payment_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_payment_wizard_id_seq OWNED BY public.account_return_payment_wizard.id;


--
-- Name: account_return_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_res_company_rel (
    account_return_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_return_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_return_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_res_company_rel IS 'RELATION BETWEEN account_return AND res_company';


--
-- Name: account_return_submission_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_submission_wizard (
    id integer NOT NULL,
    return_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    instructions text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_submission_wizard OWNER TO runbot;

--
-- Name: TABLE account_return_submission_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_submission_wizard IS 'Return submission wizard';


--
-- Name: COLUMN account_return_submission_wizard.return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.return_id IS 'Return';


--
-- Name: COLUMN account_return_submission_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_submission_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_submission_wizard.instructions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.instructions IS 'Instructions';


--
-- Name: COLUMN account_return_submission_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_return_submission_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.write_date IS 'Last Updated on';


--
-- Name: account_return_submission_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_submission_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_submission_wizard_id_seq OWNER TO runbot;

--
-- Name: account_return_submission_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_submission_wizard_id_seq OWNED BY public.account_return_submission_wizard.id;


--
-- Name: account_return_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_type (
    id integer NOT NULL,
    report_id integer,
    country_id integer,
    payment_partner_bank_id integer,
    default_deadline_days_delay integer,
    create_uid integer,
    write_uid integer,
    category character varying NOT NULL,
    states_workflow character varying,
    default_deadline_periodicity character varying,
    default_deadline_start_date date,
    name jsonb NOT NULL,
    deadline_periodicity jsonb,
    deadline_start_date jsonb,
    deadline_days_delay jsonb,
    auto_generate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_type OWNER TO runbot;

--
-- Name: TABLE account_return_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_type IS 'Accounting Return Type';


--
-- Name: COLUMN account_return_type.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.report_id IS 'Report';


--
-- Name: COLUMN account_return_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.country_id IS 'Country';


--
-- Name: COLUMN account_return_type.payment_partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.payment_partner_bank_id IS 'Payment Partner Bank';


--
-- Name: COLUMN account_return_type.default_deadline_days_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.default_deadline_days_delay IS 'Default Deadline';


--
-- Name: COLUMN account_return_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.category IS 'Type';


--
-- Name: COLUMN account_return_type.states_workflow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.states_workflow IS 'States';


--
-- Name: COLUMN account_return_type.default_deadline_periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.default_deadline_periodicity IS 'Default Periodicity';


--
-- Name: COLUMN account_return_type.default_deadline_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.default_deadline_start_date IS 'Default Start Date';


--
-- Name: COLUMN account_return_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.name IS 'Name';


--
-- Name: COLUMN account_return_type.deadline_periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.deadline_periodicity IS 'Periodicity';


--
-- Name: COLUMN account_return_type.deadline_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.deadline_start_date IS 'Start Date';


--
-- Name: COLUMN account_return_type.deadline_days_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.deadline_days_delay IS 'Deadline';


--
-- Name: COLUMN account_return_type.auto_generate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.auto_generate IS 'Auto Generated';


--
-- Name: COLUMN account_return_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.create_date IS 'Created on';


--
-- Name: COLUMN account_return_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.write_date IS 'Last Updated on';


--
-- Name: account_return_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_type_id_seq OWNER TO runbot;

--
-- Name: account_return_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_type_id_seq OWNED BY public.account_return_type.id;


--
-- Name: account_secure_entries_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_secure_entries_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    hash_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_secure_entries_wizard OWNER TO runbot;

--
-- Name: TABLE account_secure_entries_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_secure_entries_wizard IS 'Secure Journal Entries';


--
-- Name: COLUMN account_secure_entries_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_secure_entries_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_secure_entries_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_secure_entries_wizard.hash_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.hash_date IS 'Hash All Entries';


--
-- Name: COLUMN account_secure_entries_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_secure_entries_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_date IS 'Last Updated on';


--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_secure_entries_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNER TO runbot;

--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNED BY public.account_secure_entries_wizard.id;


--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    num_journals_without_account_bank integer,
    num_journals_without_account_credit integer,
    create_uid integer,
    write_uid integer,
    new_journal_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_setup_bank_manual_config OWNER TO runbot;

--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account_bank IS 'Num Journals Without Account Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account_credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account_credit IS 'Num Journals Without Account Credit';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNER TO runbot;

--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    tax_group_id integer NOT NULL,
    cash_basis_transition_account_id integer,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    price_include_override character varying,
    tax_exigibility character varying,
    name jsonb NOT NULL,
    description jsonb,
    invoice_label jsonb,
    invoice_legal_notes jsonb,
    amount numeric NOT NULL,
    is_domestic boolean,
    active boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ubl_cii_tax_category_code character varying,
    ubl_cii_tax_exemption_reason_code character varying,
    l10n_ar_withholding_sequence_id integer,
    l10n_ar_state_id integer,
    l10n_ar_scale_id integer,
    l10n_ar_withholding_payment_type character varying,
    l10n_ar_tax_type character varying,
    l10n_ar_code character varying,
    l10n_ar_non_taxable_amount numeric,
    l10n_ar_minimum_threshold double precision,
    api_codigo_articulo_retencion character varying,
    api_codigo_articulo_percepcion character varying,
    api_articulo_inciso_calculo_percepcion character varying,
    api_articulo_inciso_calculo_retencion character varying,
    ratio double precision
);


ALTER TABLE public.account_tax OWNER TO runbot;

--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.country_id IS 'Country';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax.tax_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.price_include_override; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.price_include_override IS 'Included in Price';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Exigibility';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.description IS 'Description';


--
-- Name: COLUMN account_tax.invoice_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_label IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.invoice_legal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_legal_notes IS 'Legal Notes';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.is_domestic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_domestic IS 'Is Domestic';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.is_base_affected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax.ubl_cii_tax_category_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.ubl_cii_tax_category_code IS 'Tax Category Code';


--
-- Name: COLUMN account_tax.ubl_cii_tax_exemption_reason_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.ubl_cii_tax_exemption_reason_code IS 'Tax Exemption Reason Code';


--
-- Name: COLUMN account_tax.l10n_ar_withholding_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_withholding_sequence_id IS 'WTH Sequence';


--
-- Name: COLUMN account_tax.l10n_ar_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_state_id IS 'Jurisdiction';


--
-- Name: COLUMN account_tax.l10n_ar_scale_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_scale_id IS 'Scale';


--
-- Name: COLUMN account_tax.l10n_ar_withholding_payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_withholding_payment_type IS 'Argentina Withholding Payment Type';


--
-- Name: COLUMN account_tax.l10n_ar_tax_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_tax_type IS 'WTH Tax';


--
-- Name: COLUMN account_tax.l10n_ar_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_code IS 'ARCA Code';


--
-- Name: COLUMN account_tax.l10n_ar_non_taxable_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_non_taxable_amount IS 'Non Taxable Amount';


--
-- Name: COLUMN account_tax.l10n_ar_minimum_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_minimum_threshold IS 'Minimum Treshold';


--
-- Name: COLUMN account_tax.api_codigo_articulo_retencion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_codigo_articulo_retencion IS 'Código de Artículo/Inciso por el que retiene';


--
-- Name: COLUMN account_tax.api_codigo_articulo_percepcion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_codigo_articulo_percepcion IS 'Código de artículo Inciso por el que percibe';


--
-- Name: COLUMN account_tax.api_articulo_inciso_calculo_percepcion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_articulo_inciso_calculo_percepcion IS 'Artículo/Inciso para el cálculo percepción';


--
-- Name: COLUMN account_tax.api_articulo_inciso_calculo_retencion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_articulo_inciso_calculo_retencion IS 'Artículo/Inciso para el cálculo retención';


--
-- Name: COLUMN account_tax.ratio; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.ratio IS 'Ratio';


--
-- Name: account_tax_alternatives; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_alternatives (
    dest_tax_id integer NOT NULL,
    src_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_alternatives OWNER TO runbot;

--
-- Name: TABLE account_tax_alternatives; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_alternatives IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_filiation_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    tax_payable_account_id integer,
    tax_receivable_account_id integer,
    advance_tax_payment_account_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    pos_receipt_label character varying,
    name jsonb NOT NULL,
    preceding_subtotal jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_ar_tribute_afip_code character varying,
    l10n_ar_vat_afip_code character varying
);


ALTER TABLE public.account_tax_group OWNER TO runbot;

--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.company_id IS 'Company';


--
-- Name: COLUMN account_tax_group.tax_payable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_payable_account_id IS 'Tax Payable Account';


--
-- Name: COLUMN account_tax_group.tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_receivable_account_id IS 'Tax Receivable Account';


--
-- Name: COLUMN account_tax_group.advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.advance_tax_payment_account_id IS 'Tax Advance Account';


--
-- Name: COLUMN account_tax_group.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.country_id IS 'Country';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.pos_receipt_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.pos_receipt_label IS 'PoS receipt label';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.preceding_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.preceding_subtotal IS 'Preceding Subtotal';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_group.l10n_ar_tribute_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_tribute_afip_code IS 'Tribute ARCA Code';


--
-- Name: COLUMN account_tax_group.l10n_ar_vat_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_vat_afip_code IS 'VAT ARCA Code';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_group_id_seq OWNER TO runbot;

--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_id_seq OWNER TO runbot;

--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    account_id integer,
    tax_id integer,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    repartition_type character varying NOT NULL,
    document_type character varying NOT NULL,
    factor_percent numeric NOT NULL,
    use_in_tax_closing boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_repartition_line OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.tax_id IS 'Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.document_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.document_type IS 'Related to';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNER TO runbot;

--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: account_tax_unit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit (
    id integer NOT NULL,
    country_id integer NOT NULL,
    main_company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    vat character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_unit OWNER TO runbot;

--
-- Name: TABLE account_tax_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit IS 'Tax Unit';


--
-- Name: COLUMN account_tax_unit.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.country_id IS 'Country';


--
-- Name: COLUMN account_tax_unit.main_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.main_company_id IS 'Main Company';


--
-- Name: COLUMN account_tax_unit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_unit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_unit.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.name IS 'Name';


--
-- Name: COLUMN account_tax_unit.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.vat IS 'Tax ID';


--
-- Name: COLUMN account_tax_unit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_unit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_date IS 'Last Updated on';


--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_unit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_unit_id_seq OWNER TO runbot;

--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_unit_id_seq OWNED BY public.account_tax_unit.id;


--
-- Name: account_tax_unit_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit_res_company_rel (
    res_company_id integer NOT NULL,
    account_tax_unit_id integer NOT NULL
);


ALTER TABLE public.account_tax_unit_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_unit_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit_res_company_rel IS 'RELATION BETWEEN res_company AND account_tax_unit';


--
-- Name: account_write_off_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_write_off_type (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    label character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_write_off_type OWNER TO runbot;

--
-- Name: TABLE account_write_off_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_write_off_type IS 'account.write_off.type';


--
-- Name: COLUMN account_write_off_type.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.account_id IS 'Account';


--
-- Name: COLUMN account_write_off_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.create_uid IS 'Created by';


--
-- Name: COLUMN account_write_off_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_write_off_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.name IS 'Name';


--
-- Name: COLUMN account_write_off_type.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.label IS 'Label';


--
-- Name: COLUMN account_write_off_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.active IS 'Active';


--
-- Name: COLUMN account_write_off_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.create_date IS 'Created on';


--
-- Name: COLUMN account_write_off_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.write_date IS 'Last Updated on';


--
-- Name: account_write_off_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_write_off_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_write_off_type_id_seq OWNER TO runbot;

--
-- Name: account_write_off_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_write_off_type_id_seq OWNED BY public.account_write_off_type.id;


--
-- Name: account_write_off_type_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_write_off_type_res_company_rel (
    account_write_off_type_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_write_off_type_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_write_off_type_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_write_off_type_res_company_rel IS 'RELATION BETWEEN account_write_off_type AND res_company';


--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: adhoc_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module (
    id integer NOT NULL,
    prod_database_count integer,
    adhoc_product_id integer,
    extra_lines integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module OWNER TO runbot;

--
-- Name: TABLE adhoc_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module IS 'Adhoc Module';


--
-- Name: COLUMN adhoc_module.prod_database_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module.prod_database_count IS '# Databases';


--
-- Name: COLUMN adhoc_module.adhoc_product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module.adhoc_product_id IS 'Adhoc Product';


--
-- Name: COLUMN adhoc_module.extra_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module.extra_lines IS 'Extra Lines';


--
-- Name: COLUMN adhoc_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module.name IS 'Name';


--
-- Name: COLUMN adhoc_module.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module.description IS 'Description';


--
-- Name: COLUMN adhoc_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_category (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_category OWNER TO runbot;

--
-- Name: TABLE adhoc_module_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_category IS 'adhoc.module.category';


--
-- Name: COLUMN adhoc_module_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.name IS 'Name';


--
-- Name: COLUMN adhoc_module_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_category_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_category_id_seq OWNED BY public.adhoc_module_category.id;


--
-- Name: adhoc_module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.adhoc_module_country OWNER TO runbot;

--
-- Name: TABLE adhoc_module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_country IS 'RELATION BETWEEN adhoc_module_module AND res_country';


--
-- Name: adhoc_module_create_task_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_create_task_wizard (
    id integer NOT NULL,
    project_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_create_task_wizard OWNER TO runbot;

--
-- Name: TABLE adhoc_module_create_task_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_create_task_wizard IS 'adhoc.module.create.task.wizard';


--
-- Name: COLUMN adhoc_module_create_task_wizard.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_create_task_wizard.project_id IS 'Project';


--
-- Name: COLUMN adhoc_module_create_task_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_create_task_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_create_task_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_create_task_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_create_task_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_create_task_wizard.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_create_task_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_create_task_wizard.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_create_task_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_create_task_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_create_task_wizard_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_create_task_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_create_task_wizard_id_seq OWNED BY public.adhoc_module_create_task_wizard.id;


--
-- Name: adhoc_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_dependency (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_dependency OWNER TO runbot;

--
-- Name: TABLE adhoc_module_dependency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_dependency IS 'Module dependency';


--
-- Name: COLUMN adhoc_module_dependency.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_dependency.module_id IS 'Module';


--
-- Name: COLUMN adhoc_module_dependency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_dependency.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_dependency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_dependency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_dependency.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_dependency.name IS 'Name';


--
-- Name: COLUMN adhoc_module_dependency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_dependency.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_dependency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_dependency.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_dependency_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_dependency_id_seq OWNED BY public.adhoc_module_dependency.id;


--
-- Name: adhoc_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_id_seq OWNED BY public.adhoc_module.id;


--
-- Name: adhoc_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_module (
    id integer NOT NULL,
    category_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    adhoc_category_id integer,
    extra_lines integer,
    source_module_id integer,
    repository_id integer,
    major_version_id integer,
    module_id integer NOT NULL,
    state_id integer,
    prod_database_count integer,
    python_code_qty integer,
    xml_code_qty integer,
    js_code_qty integer,
    css_scss_code_qty integer,
    name character varying NOT NULL,
    author character varying,
    maintainer character varying,
    website character varying,
    latest_version character varying,
    published_version character varying,
    url character varying,
    state character varying,
    license character varying,
    icon character varying,
    module_type character varying,
    adhoc_summary character varying,
    support_type character varying NOT NULL,
    review character varying,
    customer_warning character varying,
    tx_project_url character varying,
    incompatible_modules character varying,
    force_auto_install character varying,
    auto_install_policy character varying,
    state_category character varying,
    shortdesc jsonb,
    summary jsonb,
    description jsonb,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    adhoc_description_html text,
    visibility_obs text,
    auto_install boolean,
    demo boolean,
    application boolean,
    to_buy boolean,
    imported boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_module OWNER TO runbot;

--
-- Name: TABLE adhoc_module_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_module IS 'adhoc.module.module';


--
-- Name: COLUMN adhoc_module_module.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.category_id IS 'Category';


--
-- Name: COLUMN adhoc_module_module.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.sequence IS 'Sequence';


--
-- Name: COLUMN adhoc_module_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_module.adhoc_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.adhoc_category_id IS 'Adhoc Category';


--
-- Name: COLUMN adhoc_module_module.extra_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.extra_lines IS 'Extra Lines';


--
-- Name: COLUMN adhoc_module_module.source_module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.source_module_id IS 'Source Module';


--
-- Name: COLUMN adhoc_module_module.repository_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.repository_id IS 'Repository';


--
-- Name: COLUMN adhoc_module_module.major_version_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.major_version_id IS 'Major Version';


--
-- Name: COLUMN adhoc_module_module.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.module_id IS 'Module';


--
-- Name: COLUMN adhoc_module_module.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.state_id IS 'State';


--
-- Name: COLUMN adhoc_module_module.prod_database_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.prod_database_count IS '# Dbs This Version';


--
-- Name: COLUMN adhoc_module_module.python_code_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.python_code_qty IS 'Python Code Qty';


--
-- Name: COLUMN adhoc_module_module.xml_code_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.xml_code_qty IS 'Xml Code Qty';


--
-- Name: COLUMN adhoc_module_module.js_code_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.js_code_qty IS 'Js Code Qty';


--
-- Name: COLUMN adhoc_module_module.css_scss_code_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.css_scss_code_qty IS 'Css Scss Code Qty';


--
-- Name: COLUMN adhoc_module_module.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.name IS 'Technical Name';


--
-- Name: COLUMN adhoc_module_module.author; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.author IS 'Author';


--
-- Name: COLUMN adhoc_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN adhoc_module_module.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.website IS 'Website';


--
-- Name: COLUMN adhoc_module_module.latest_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.latest_version IS 'Installed Version';


--
-- Name: COLUMN adhoc_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN adhoc_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.url IS 'URL';


--
-- Name: COLUMN adhoc_module_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.state IS 'Status';


--
-- Name: COLUMN adhoc_module_module.license; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.license IS 'License';


--
-- Name: COLUMN adhoc_module_module.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.icon IS 'Icon URL';


--
-- Name: COLUMN adhoc_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN adhoc_module_module.adhoc_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.adhoc_summary IS 'Adhoc Summary';


--
-- Name: COLUMN adhoc_module_module.support_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.support_type IS 'Support Type';


--
-- Name: COLUMN adhoc_module_module.review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.review IS 'Review';


--
-- Name: COLUMN adhoc_module_module.customer_warning; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.customer_warning IS 'Customer Warning';


--
-- Name: COLUMN adhoc_module_module.tx_project_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.tx_project_url IS 'Transifex Project URL';


--
-- Name: COLUMN adhoc_module_module.incompatible_modules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.incompatible_modules IS 'Incompatible Modules';


--
-- Name: COLUMN adhoc_module_module.force_auto_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.force_auto_install IS 'Force Auto Install';


--
-- Name: COLUMN adhoc_module_module.auto_install_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.auto_install_policy IS 'Auto Installation Policy';


--
-- Name: COLUMN adhoc_module_module.state_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.state_category IS 'State Category';


--
-- Name: COLUMN adhoc_module_module.shortdesc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.shortdesc IS 'Module Name';


--
-- Name: COLUMN adhoc_module_module.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.summary IS 'Summary';


--
-- Name: COLUMN adhoc_module_module.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.description IS 'Description';


--
-- Name: COLUMN adhoc_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN adhoc_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN adhoc_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN adhoc_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN adhoc_module_module.adhoc_description_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.adhoc_description_html IS 'Adhoc Description Html';


--
-- Name: COLUMN adhoc_module_module.visibility_obs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.visibility_obs IS 'Internal comment';


--
-- Name: COLUMN adhoc_module_module.auto_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.auto_install IS 'Automatic Installation';


--
-- Name: COLUMN adhoc_module_module.demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.demo IS 'Demo Data';


--
-- Name: COLUMN adhoc_module_module.application; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.application IS 'Application';


--
-- Name: COLUMN adhoc_module_module.to_buy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.to_buy IS 'Odoo Enterprise Module';


--
-- Name: COLUMN adhoc_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.imported IS 'Imported Module';


--
-- Name: COLUMN adhoc_module_module.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.active IS 'Active';


--
-- Name: COLUMN adhoc_module_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_module.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_module_adhoc_module_update_cloc_info_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_module_adhoc_module_update_cloc_info_rel (
    adhoc_module_update_cloc_info_id integer NOT NULL,
    adhoc_module_module_id integer NOT NULL
);


ALTER TABLE public.adhoc_module_module_adhoc_module_update_cloc_info_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_module_module_adhoc_module_update_cloc_info_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_module_adhoc_module_update_cloc_info_rel IS 'RELATION BETWEEN adhoc_module_update_cloc_info AND adhoc_module_module';


--
-- Name: adhoc_module_module_db_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_module_db_rel (
    module_id integer NOT NULL,
    db_id integer NOT NULL
);


ALTER TABLE public.adhoc_module_module_db_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_module_module_db_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_module_db_rel IS 'RELATION BETWEEN adhoc_module_module AND saas_database';


--
-- Name: adhoc_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_module_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_module_id_seq OWNED BY public.adhoc_module_module.id;


--
-- Name: adhoc_module_module_incompatible_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_module_incompatible_rel (
    module1_id integer NOT NULL,
    module2_id integer NOT NULL
);


ALTER TABLE public.adhoc_module_module_incompatible_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_module_module_incompatible_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_module_incompatible_rel IS 'RELATION BETWEEN adhoc_module_module AND adhoc_module_module';


--
-- Name: adhoc_module_ready_to_upgrade_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_ready_to_upgrade_wizard (
    id integer NOT NULL,
    upgrade_type_id integer NOT NULL,
    from_version_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_ready_to_upgrade_wizard OWNER TO runbot;

--
-- Name: TABLE adhoc_module_ready_to_upgrade_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_ready_to_upgrade_wizard IS 'adhoc.module.ready_to_upgrade.wizard';


--
-- Name: COLUMN adhoc_module_ready_to_upgrade_wizard.upgrade_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_ready_to_upgrade_wizard.upgrade_type_id IS 'Upgrade Type';


--
-- Name: COLUMN adhoc_module_ready_to_upgrade_wizard.from_version_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_ready_to_upgrade_wizard.from_version_id IS 'From Odoo Project';


--
-- Name: COLUMN adhoc_module_ready_to_upgrade_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_ready_to_upgrade_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_ready_to_upgrade_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_ready_to_upgrade_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_ready_to_upgrade_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_ready_to_upgrade_wizard.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_ready_to_upgrade_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_ready_to_upgrade_wizard.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_ready_to_upgrade_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_ready_to_upgrade_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_ready_to_upgrade_wizard_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_ready_to_upgrade_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_ready_to_upgrade_wizard_id_seq OWNED BY public.adhoc_module_ready_to_upgrade_wizard.id;


--
-- Name: adhoc_module_repository; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_repository (
    id integer NOT NULL,
    major_version_id integer NOT NULL,
    auto_scan_interval_number integer,
    sequence integer,
    auto_update_interval_number integer,
    linked_repo_id integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "user" character varying NOT NULL,
    subdirectory character varying,
    name character varying NOT NULL,
    token character varying,
    auto_scan character varying,
    auto_scan_interval_type character varying,
    tx_project_url character varying,
    auto_update_interval_type character varying,
    repos_yml_dir character varying,
    cicd_user character varying,
    cicd_repo character varying,
    auto_scan_next_date date,
    auto_update_next_date date,
    shell_command_after text,
    active boolean,
    external_repository boolean,
    propagate_to_new_version boolean,
    last_update_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_repository OWNER TO runbot;

--
-- Name: TABLE adhoc_module_repository; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_repository IS 'adhoc.module.repository';


--
-- Name: COLUMN adhoc_module_repository.major_version_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.major_version_id IS 'Major Version';


--
-- Name: COLUMN adhoc_module_repository.auto_scan_interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.auto_scan_interval_number IS 'Auto Scan Interval Number';


--
-- Name: COLUMN adhoc_module_repository.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.sequence IS 'Sequence';


--
-- Name: COLUMN adhoc_module_repository.auto_update_interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.auto_update_interval_number IS 'Auto Update Interval Number';


--
-- Name: COLUMN adhoc_module_repository.linked_repo_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.linked_repo_id IS 'Linked Repo';


--
-- Name: COLUMN adhoc_module_repository.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_repository.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_repository.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.full_name IS 'Full Name';


--
-- Name: COLUMN adhoc_module_repository."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository."user" IS 'User or Organization';


--
-- Name: COLUMN adhoc_module_repository.subdirectory; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.subdirectory IS 'Subdirectory';


--
-- Name: COLUMN adhoc_module_repository.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.name IS 'Repository Name';


--
-- Name: COLUMN adhoc_module_repository.token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.token IS 'Github Token';


--
-- Name: COLUMN adhoc_module_repository.auto_scan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.auto_scan IS 'Auto Scan?';


--
-- Name: COLUMN adhoc_module_repository.auto_scan_interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.auto_scan_interval_type IS 'Auto Scan Interval Type';


--
-- Name: COLUMN adhoc_module_repository.tx_project_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.tx_project_url IS 'Transifex Project URL';


--
-- Name: COLUMN adhoc_module_repository.auto_update_interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.auto_update_interval_type IS 'Auto Update Interval Type';


--
-- Name: COLUMN adhoc_module_repository.repos_yml_dir; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.repos_yml_dir IS 'repos yml dir';


--
-- Name: COLUMN adhoc_module_repository.cicd_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.cicd_user IS 'cicd user';


--
-- Name: COLUMN adhoc_module_repository.cicd_repo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.cicd_repo IS 'cicd repo';


--
-- Name: COLUMN adhoc_module_repository.auto_scan_next_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.auto_scan_next_date IS 'Date of Next Auto-Scan';


--
-- Name: COLUMN adhoc_module_repository.auto_update_next_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.auto_update_next_date IS 'Date of Next Auto-Update';


--
-- Name: COLUMN adhoc_module_repository.shell_command_after; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.shell_command_after IS 'Shell Command After';


--
-- Name: COLUMN adhoc_module_repository.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.active IS 'Active';


--
-- Name: COLUMN adhoc_module_repository.external_repository; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.external_repository IS 'External Repository';


--
-- Name: COLUMN adhoc_module_repository.propagate_to_new_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.propagate_to_new_version IS 'Propagate To New Version';


--
-- Name: COLUMN adhoc_module_repository.last_update_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.last_update_date IS 'Last Update Date';


--
-- Name: COLUMN adhoc_module_repository.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_repository.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_repository.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_repository_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_repository_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_repository_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_repository_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_repository_id_seq OWNED BY public.adhoc_module_repository.id;


--
-- Name: adhoc_module_repository_saas_pull_request_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_repository_saas_pull_request_rel (
    adhoc_module_repository_id integer NOT NULL,
    saas_pull_request_id integer NOT NULL
);


ALTER TABLE public.adhoc_module_repository_saas_pull_request_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_module_repository_saas_pull_request_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_repository_saas_pull_request_rel IS 'RELATION BETWEEN adhoc_module_repository AND saas_pull_request';


--
-- Name: adhoc_module_saas_odoo_version_repository_commit_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_saas_odoo_version_repository_commit_rel (
    saas_odoo_version_repository_commit_id integer NOT NULL,
    adhoc_module_id integer NOT NULL
);


ALTER TABLE public.adhoc_module_saas_odoo_version_repository_commit_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_module_saas_odoo_version_repository_commit_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_saas_odoo_version_repository_commit_rel IS 'RELATION BETWEEN saas_odoo_version_repository_commit AND adhoc_module';


--
-- Name: adhoc_module_saas_pull_request_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_saas_pull_request_rel (
    saas_pull_request_id integer NOT NULL,
    adhoc_module_id integer NOT NULL
);


ALTER TABLE public.adhoc_module_saas_pull_request_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_module_saas_pull_request_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_saas_pull_request_rel IS 'RELATION BETWEEN saas_pull_request AND adhoc_module';


--
-- Name: adhoc_module_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_state (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying NOT NULL,
    description character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_state OWNER TO runbot;

--
-- Name: TABLE adhoc_module_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_state IS 'Adhoc Module State';


--
-- Name: COLUMN adhoc_module_state.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_state.sequence IS 'Sequence';


--
-- Name: COLUMN adhoc_module_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_state.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_state.name IS 'Name';


--
-- Name: COLUMN adhoc_module_state.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_state.category IS 'Category';


--
-- Name: COLUMN adhoc_module_state.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_state.description IS 'Description';


--
-- Name: COLUMN adhoc_module_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_state.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_state.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_state_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_state_id_seq OWNED BY public.adhoc_module_state.id;


--
-- Name: adhoc_module_update_cloc_info; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_update_cloc_info (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_url character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_update_cloc_info OWNER TO runbot;

--
-- Name: TABLE adhoc_module_update_cloc_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_update_cloc_info IS 'Module update cloc info';


--
-- Name: COLUMN adhoc_module_update_cloc_info.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_update_cloc_info.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_update_cloc_info.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_update_cloc_info.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_update_cloc_info.server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_update_cloc_info.server_url IS 'Server Url';


--
-- Name: COLUMN adhoc_module_update_cloc_info.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_update_cloc_info.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_update_cloc_info.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_update_cloc_info.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_update_cloc_info_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_update_cloc_info_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_update_cloc_info_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_update_cloc_info_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_update_cloc_info_id_seq OWNED BY public.adhoc_module_update_cloc_info.id;


--
-- Name: adhoc_product; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_product (
    id integer NOT NULL,
    parent_id integer,
    product_manager_id integer,
    product_owner_id integer,
    technical_team_id integer,
    technical_expert_id integer,
    color integer,
    product_category_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    complete_name character varying,
    parent_path character varying,
    description text,
    requires_product_on_subscription boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    estimated_consultancy_hours double precision
);


ALTER TABLE public.adhoc_product OWNER TO runbot;

--
-- Name: TABLE adhoc_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_product IS 'Adhoc Products';


--
-- Name: COLUMN adhoc_product.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.parent_id IS 'Producto Padre';


--
-- Name: COLUMN adhoc_product.product_manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.product_manager_id IS 'Product Manager';


--
-- Name: COLUMN adhoc_product.product_owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.product_owner_id IS 'Product Owner';


--
-- Name: COLUMN adhoc_product.technical_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.technical_team_id IS 'Equipo Técnico';


--
-- Name: COLUMN adhoc_product.technical_expert_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.technical_expert_id IS 'Responsable Técnico';


--
-- Name: COLUMN adhoc_product.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.color IS 'Color';


--
-- Name: COLUMN adhoc_product.product_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.product_category_id IS 'Product Category';


--
-- Name: COLUMN adhoc_product.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_product.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_product.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.name IS 'Nombre';


--
-- Name: COLUMN adhoc_product.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.type IS 'Type';


--
-- Name: COLUMN adhoc_product.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.complete_name IS 'Nombre Completo';


--
-- Name: COLUMN adhoc_product.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.parent_path IS 'Parent Path';


--
-- Name: COLUMN adhoc_product.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.description IS 'Description';


--
-- Name: COLUMN adhoc_product.requires_product_on_subscription; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.requires_product_on_subscription IS 'Requires Product On Subscription';


--
-- Name: COLUMN adhoc_product.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_product.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.write_date IS 'Last Updated on';


--
-- Name: COLUMN adhoc_product.estimated_consultancy_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_product.estimated_consultancy_hours IS 'Estimated Consultancy Hours';


--
-- Name: adhoc_product_expert_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_product_expert_rel (
    adhoc_product_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.adhoc_product_expert_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_product_expert_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_product_expert_rel IS 'RELATION BETWEEN adhoc_product AND hr_employee';


--
-- Name: adhoc_product_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_product_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_product_id_seq OWNER TO runbot;

--
-- Name: adhoc_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_product_id_seq OWNED BY public.adhoc_product.id;


--
-- Name: adhoc_product_module_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_product_module_install_rel (
    adhoc_product_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.adhoc_product_module_install_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_product_module_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_product_module_install_rel IS 'RELATION BETWEEN adhoc_product AND adhoc_module';


--
-- Name: adhoc_product_rating_rating_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_product_rating_rating_rel (
    rating_rating_id integer NOT NULL,
    adhoc_product_id integer NOT NULL
);


ALTER TABLE public.adhoc_product_rating_rating_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_product_rating_rating_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_product_rating_rating_rel IS 'RELATION BETWEEN rating_rating AND adhoc_product';


--
-- Name: adhoc_product_saas_database_kpi_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_product_saas_database_kpi_line_rel (
    saas_database_kpi_line_id integer NOT NULL,
    adhoc_product_id integer NOT NULL
);


ALTER TABLE public.adhoc_product_saas_database_kpi_line_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_product_saas_database_kpi_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_product_saas_database_kpi_line_rel IS 'RELATION BETWEEN saas_database_kpi_line AND adhoc_product';


--
-- Name: adhoc_product_sale_order_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_product_sale_order_rel (
    sale_order_id integer NOT NULL,
    adhoc_product_id integer NOT NULL
);


ALTER TABLE public.adhoc_product_sale_order_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_product_sale_order_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_product_sale_order_rel IS 'RELATION BETWEEN sale_order AND adhoc_product';


--
-- Name: adhoc_product_upgrade_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_product_upgrade_line_rel (
    upgrade_line_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.adhoc_product_upgrade_line_rel OWNER TO runbot;

--
-- Name: TABLE adhoc_product_upgrade_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_product_upgrade_line_rel IS 'RELATION BETWEEN saas_upgrade_line AND adhoc_module';


--
-- Name: adjusting_entries__account_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adjusting_entries__account_move (
    move_id integer NOT NULL,
    adjusting_entry_move_id integer NOT NULL
);


ALTER TABLE public.adjusting_entries__account_move OWNER TO runbot;

--
-- Name: TABLE adjusting_entries__account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adjusting_entries__account_move IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: afip_concept; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_concept (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_concept OWNER TO runbot;

--
-- Name: TABLE afip_concept; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_concept IS 'afip.concept';


--
-- Name: COLUMN afip_concept.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_uid IS 'Created by';


--
-- Name: COLUMN afip_concept.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_concept.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.code IS 'Code';


--
-- Name: COLUMN afip_concept.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.name IS 'Name';


--
-- Name: COLUMN afip_concept.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.active IS 'Active';


--
-- Name: COLUMN afip_concept.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_date IS 'Created on';


--
-- Name: COLUMN afip_concept.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_date IS 'Last Updated on';


--
-- Name: afip_concept_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_concept_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_concept_id_seq OWNER TO runbot;

--
-- Name: afip_concept_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_concept_id_seq OWNED BY public.afip_concept.id;


--
-- Name: afip_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_tax (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_tax OWNER TO runbot;

--
-- Name: TABLE afip_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_tax IS 'afip.tax';


--
-- Name: COLUMN afip_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_uid IS 'Created by';


--
-- Name: COLUMN afip_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_tax.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.code IS 'Code';


--
-- Name: COLUMN afip_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.name IS 'Name';


--
-- Name: COLUMN afip_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.active IS 'Active';


--
-- Name: COLUMN afip_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_date IS 'Created on';


--
-- Name: COLUMN afip_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_date IS 'Last Updated on';


--
-- Name: afip_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_tax_id_seq OWNER TO runbot;

--
-- Name: afip_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_tax_id_seq OWNED BY public.afip_tax.id;


--
-- Name: ai_agent; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subtitle character varying,
    response_style character varying NOT NULL,
    llm_model character varying NOT NULL,
    system_prompt text,
    active boolean,
    restrict_to_sources boolean,
    is_system_agent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent OWNER TO runbot;

--
-- Name: TABLE ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent IS 'AI Agent';


--
-- Name: COLUMN ai_agent.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.partner_id IS 'Partner';


--
-- Name: COLUMN ai_agent.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent.subtitle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.subtitle IS 'Description';


--
-- Name: COLUMN ai_agent.response_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.response_style IS 'Response Style';


--
-- Name: COLUMN ai_agent.llm_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.llm_model IS 'LLM Model';


--
-- Name: COLUMN ai_agent.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.system_prompt IS 'System Prompt';


--
-- Name: COLUMN ai_agent.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.active IS 'Active';


--
-- Name: COLUMN ai_agent.restrict_to_sources; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.restrict_to_sources IS 'Restrict to Sources';


--
-- Name: COLUMN ai_agent.is_system_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.is_system_agent IS 'System Agent';


--
-- Name: COLUMN ai_agent.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_date IS 'Last Updated on';


--
-- Name: ai_agent_ai_topic_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_ai_topic_rel (
    ai_agent_id integer NOT NULL,
    ai_topic_id integer NOT NULL
);


ALTER TABLE public.ai_agent_ai_topic_rel OWNER TO runbot;

--
-- Name: TABLE ai_agent_ai_topic_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_ai_topic_rel IS 'RELATION BETWEEN ai_agent AND ai_topic';


--
-- Name: ai_agent_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_id_seq OWNER TO runbot;

--
-- Name: ai_agent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_id_seq OWNED BY public.ai_agent.id;


--
-- Name: ai_agent_source; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_source (
    id integer NOT NULL,
    agent_id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    type character varying NOT NULL,
    status character varying,
    url character varying,
    error_details text,
    is_active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    article_id integer
);


ALTER TABLE public.ai_agent_source OWNER TO runbot;

--
-- Name: TABLE ai_agent_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_source IS 'AI Agent Source';


--
-- Name: COLUMN ai_agent_source.agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.agent_id IS 'Agent';


--
-- Name: COLUMN ai_agent_source.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_agent_source.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent_source.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent_source.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.name IS 'Name';


--
-- Name: COLUMN ai_agent_source.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.type IS 'Type';


--
-- Name: COLUMN ai_agent_source.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.status IS 'Status';


--
-- Name: COLUMN ai_agent_source.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.url IS 'URL';


--
-- Name: COLUMN ai_agent_source.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.error_details IS 'Error Details';


--
-- Name: COLUMN ai_agent_source.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.is_active IS 'Active';


--
-- Name: COLUMN ai_agent_source.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent_source.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_date IS 'Last Updated on';


--
-- Name: COLUMN ai_agent_source.article_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.article_id IS 'Source Article';


--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_source_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_source_id_seq OWNER TO runbot;

--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_source_id_seq OWNED BY public.ai_agent_source.id;


--
-- Name: ai_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer (
    id integer NOT NULL,
    ai_agent integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    interface_key character varying NOT NULL,
    default_prompt text,
    is_system_default boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_composer OWNER TO runbot;

--
-- Name: TABLE ai_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer IS 'AI model configurations (system prompts) for text drafting.';


--
-- Name: COLUMN ai_composer.ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.ai_agent IS 'Agent';


--
-- Name: COLUMN ai_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_uid IS 'Created by';


--
-- Name: COLUMN ai_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_composer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.name IS 'Rule Name';


--
-- Name: COLUMN ai_composer.interface_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.interface_key IS 'Action';


--
-- Name: COLUMN ai_composer.default_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.default_prompt IS 'Instructions';


--
-- Name: COLUMN ai_composer.is_system_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.is_system_default IS 'Is the rule a system default or user created';


--
-- Name: COLUMN ai_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_date IS 'Created on';


--
-- Name: COLUMN ai_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_date IS 'Last Updated on';


--
-- Name: ai_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_composer_id_seq OWNER TO runbot;

--
-- Name: ai_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_composer_id_seq OWNED BY public.ai_composer.id;


--
-- Name: ai_composer_ir_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer_ir_model_rel (
    ai_composer_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ai_composer_ir_model_rel OWNER TO runbot;

--
-- Name: TABLE ai_composer_ir_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer_ir_model_rel IS 'RELATION BETWEEN ai_composer AND ir_model';


--
-- Name: ai_embedding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_embedding (
    id integer NOT NULL,
    attachment_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    embedding_model character varying NOT NULL,
    content text NOT NULL,
    has_embedding_generation_failed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    embedding_vector public.vector(1536)
);


ALTER TABLE public.ai_embedding OWNER TO runbot;

--
-- Name: TABLE ai_embedding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_embedding IS 'Attachment Chunks Embedding';


--
-- Name: COLUMN ai_embedding.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_embedding.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.sequence IS 'Sequence';


--
-- Name: COLUMN ai_embedding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_uid IS 'Created by';


--
-- Name: COLUMN ai_embedding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_embedding.embedding_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_model IS 'Embedding Model';


--
-- Name: COLUMN ai_embedding.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.content IS 'Chunk Content';


--
-- Name: COLUMN ai_embedding.has_embedding_generation_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.has_embedding_generation_failed IS 'Has Embedding Generation Failed';


--
-- Name: COLUMN ai_embedding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_date IS 'Created on';


--
-- Name: COLUMN ai_embedding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_date IS 'Last Updated on';


--
-- Name: COLUMN ai_embedding.embedding_vector; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_vector IS 'Embedding Vector';


--
-- Name: ai_embedding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_embedding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_embedding_id_seq OWNER TO runbot;

--
-- Name: ai_embedding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_embedding_id_seq OWNED BY public.ai_embedding.id;


--
-- Name: ai_prompt_button; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_prompt_button (
    id integer NOT NULL,
    sequence integer,
    composer_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_prompt_button OWNER TO runbot;

--
-- Name: TABLE ai_prompt_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_prompt_button IS 'Prompt that can be attached to AI UI rules for quick access by the user.';


--
-- Name: COLUMN ai_prompt_button.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.sequence IS 'Sequence';


--
-- Name: COLUMN ai_prompt_button.composer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.composer_id IS 'Composer';


--
-- Name: COLUMN ai_prompt_button.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_uid IS 'Created by';


--
-- Name: COLUMN ai_prompt_button.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_prompt_button.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.name IS 'AI Prompt';


--
-- Name: COLUMN ai_prompt_button.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_date IS 'Created on';


--
-- Name: COLUMN ai_prompt_button.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_date IS 'Last Updated on';


--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_prompt_button_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_prompt_button_id_seq OWNER TO runbot;

--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_prompt_button_id_seq OWNED BY public.ai_prompt_button.id;


--
-- Name: ai_tool_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_tool_ids_rel (
    parent_id integer NOT NULL,
    tool_id integer NOT NULL
);


ALTER TABLE public.ai_tool_ids_rel OWNER TO runbot;

--
-- Name: TABLE ai_tool_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_tool_ids_rel IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: ai_topic; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description text,
    instructions text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_topic OWNER TO runbot;

--
-- Name: TABLE ai_topic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic IS 'Create a topic that leverages instructions and tools to direct Odoo AI in assisting the user with their tasks.';


--
-- Name: COLUMN ai_topic.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_uid IS 'Created by';


--
-- Name: COLUMN ai_topic.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_topic.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.name IS 'Title';


--
-- Name: COLUMN ai_topic.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.description IS 'Description';


--
-- Name: COLUMN ai_topic.instructions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.instructions IS 'Instructions';


--
-- Name: COLUMN ai_topic.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_date IS 'Created on';


--
-- Name: COLUMN ai_topic.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_date IS 'Last Updated on';


--
-- Name: ai_topic_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_topic_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_topic_id_seq OWNER TO runbot;

--
-- Name: ai_topic_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_topic_id_seq OWNED BY public.ai_topic.id;


--
-- Name: ai_topic_ir_act_server_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic_ir_act_server_rel (
    ai_topic_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.ai_topic_ir_act_server_rel OWNER TO runbot;

--
-- Name: TABLE ai_topic_ir_act_server_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic_ir_act_server_rel IS 'RELATION BETWEEN ai_topic AND ir_act_server';


--
-- Name: appointment_answer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_answer (
    id integer NOT NULL,
    question_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.appointment_answer OWNER TO runbot;

--
-- Name: TABLE appointment_answer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_answer IS 'Appointment Question Answers';


--
-- Name: COLUMN appointment_answer.question_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer.question_id IS 'Question';


--
-- Name: COLUMN appointment_answer.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_answer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_answer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_answer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer.name IS 'Answer';


--
-- Name: COLUMN appointment_answer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer.create_date IS 'Created on';


--
-- Name: COLUMN appointment_answer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer.write_date IS 'Last Updated on';


--
-- Name: appointment_answer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.appointment_answer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_answer_id_seq OWNER TO runbot;

--
-- Name: appointment_answer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.appointment_answer_id_seq OWNED BY public.appointment_answer.id;


--
-- Name: appointment_answer_input; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_answer_input (
    id integer NOT NULL,
    question_id integer NOT NULL,
    value_answer_id integer,
    appointment_type_id integer NOT NULL,
    calendar_event_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    value_text_box text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    calendar_booking_id integer,
    CONSTRAINT appointment_answer_input_check_event_or_booking CHECK (((calendar_booking_id IS NOT NULL) OR (calendar_event_id IS NOT NULL))),
    CONSTRAINT appointment_answer_input_value_check CHECK (((value_answer_id IS NOT NULL) OR (COALESCE(value_text_box, ''::text) <> ''::text)))
);


ALTER TABLE public.appointment_answer_input OWNER TO runbot;

--
-- Name: TABLE appointment_answer_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_answer_input IS 'Appointment Answer Inputs';


--
-- Name: COLUMN appointment_answer_input.question_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.question_id IS 'Question';


--
-- Name: COLUMN appointment_answer_input.value_answer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.value_answer_id IS 'Selected Answer';


--
-- Name: COLUMN appointment_answer_input.appointment_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN appointment_answer_input.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.calendar_event_id IS 'Calendar Event';


--
-- Name: COLUMN appointment_answer_input.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.partner_id IS 'Customer';


--
-- Name: COLUMN appointment_answer_input.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_answer_input.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_answer_input.value_text_box; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.value_text_box IS 'Text Answer';


--
-- Name: COLUMN appointment_answer_input.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.create_date IS 'Created on';


--
-- Name: COLUMN appointment_answer_input.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_answer_input.calendar_booking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_answer_input.calendar_booking_id IS 'Meeting Booking';


--
-- Name: CONSTRAINT appointment_answer_input_check_event_or_booking ON appointment_answer_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_answer_input_check_event_or_booking ON public.appointment_answer_input IS 'CHECK(calendar_booking_id IS NOT NULL OR calendar_event_id IS NOT NULL)';


--
-- Name: CONSTRAINT appointment_answer_input_value_check ON appointment_answer_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_answer_input_value_check ON public.appointment_answer_input IS 'CHECK(value_answer_id IS NOT NULL OR COALESCE(value_text_box, '''') <> '''')';


--
-- Name: appointment_answer_input_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.appointment_answer_input_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_answer_input_id_seq OWNER TO runbot;

--
-- Name: appointment_answer_input_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.appointment_answer_input_id_seq OWNED BY public.appointment_answer_input.id;


--
-- Name: appointment_booking_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_booking_line (
    id integer NOT NULL,
    appointment_resource_id integer,
    appointment_type_id integer,
    capacity_reserved integer NOT NULL,
    capacity_used integer,
    calendar_event_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    event_start timestamp without time zone,
    event_stop timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT appointment_booking_line_check_capacity_reserved CHECK ((capacity_reserved >= 0))
);


ALTER TABLE public.appointment_booking_line OWNER TO runbot;

--
-- Name: TABLE appointment_booking_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_booking_line IS 'Appointment Booking Line';


--
-- Name: COLUMN appointment_booking_line.appointment_resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.appointment_resource_id IS 'Appointment Resource';


--
-- Name: COLUMN appointment_booking_line.appointment_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.appointment_type_id IS 'Appointment';


--
-- Name: COLUMN appointment_booking_line.capacity_reserved; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.capacity_reserved IS 'Capacity Reserved';


--
-- Name: COLUMN appointment_booking_line.capacity_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.capacity_used IS 'Capacity Used';


--
-- Name: COLUMN appointment_booking_line.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.calendar_event_id IS 'Booking';


--
-- Name: COLUMN appointment_booking_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_booking_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_booking_line.event_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.event_start IS 'Booking Start';


--
-- Name: COLUMN appointment_booking_line.event_stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.event_stop IS 'Booking End';


--
-- Name: COLUMN appointment_booking_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.create_date IS 'Created on';


--
-- Name: COLUMN appointment_booking_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_booking_line.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT appointment_booking_line_check_capacity_reserved ON appointment_booking_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_booking_line_check_capacity_reserved ON public.appointment_booking_line IS 'CHECK(capacity_reserved >= 0)';


--
-- Name: appointment_booking_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.appointment_booking_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_booking_line_id_seq OWNER TO runbot;

--
-- Name: appointment_booking_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.appointment_booking_line_id_seq OWNED BY public.appointment_booking_line.id;


--
-- Name: appointment_invite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_invite (
    id integer NOT NULL,
    identical_config_id integer,
    appointment_type_count integer,
    create_uid integer,
    write_uid integer,
    access_token character varying NOT NULL,
    short_code character varying NOT NULL,
    resources_choice character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    website_id integer,
    is_published boolean,
    ticket_id integer
);


ALTER TABLE public.appointment_invite OWNER TO runbot;

--
-- Name: TABLE appointment_invite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_invite IS 'Appointment Invite';


--
-- Name: COLUMN appointment_invite.identical_config_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.identical_config_id IS 'Identical Config';


--
-- Name: COLUMN appointment_invite.appointment_type_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.appointment_type_count IS 'Selected Appointments Count';


--
-- Name: COLUMN appointment_invite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_invite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_invite.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.access_token IS 'Token';


--
-- Name: COLUMN appointment_invite.short_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.short_code IS 'Short Code';


--
-- Name: COLUMN appointment_invite.resources_choice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.resources_choice IS 'Assign to';


--
-- Name: COLUMN appointment_invite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.create_date IS 'Created on';


--
-- Name: COLUMN appointment_invite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_invite.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.website_id IS 'Website';


--
-- Name: COLUMN appointment_invite.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.is_published IS 'Is Published';


--
-- Name: COLUMN appointment_invite.ticket_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_invite.ticket_id IS 'Ticket';


--
-- Name: appointment_invite_appointment_resource_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_invite_appointment_resource_rel (
    appointment_invite_id integer NOT NULL,
    appointment_resource_id integer NOT NULL
);


ALTER TABLE public.appointment_invite_appointment_resource_rel OWNER TO runbot;

--
-- Name: TABLE appointment_invite_appointment_resource_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_invite_appointment_resource_rel IS 'RELATION BETWEEN appointment_invite AND appointment_resource';


--
-- Name: appointment_invite_appointment_type_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_invite_appointment_type_rel (
    appointment_invite_id integer NOT NULL,
    appointment_type_id integer NOT NULL
);


ALTER TABLE public.appointment_invite_appointment_type_rel OWNER TO runbot;

--
-- Name: TABLE appointment_invite_appointment_type_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_invite_appointment_type_rel IS 'RELATION BETWEEN appointment_invite AND appointment_type';


--
-- Name: appointment_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.appointment_invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_invite_id_seq OWNER TO runbot;

--
-- Name: appointment_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.appointment_invite_id_seq OWNED BY public.appointment_invite.id;


--
-- Name: appointment_invite_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_invite_res_users_rel (
    appointment_invite_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.appointment_invite_res_users_rel OWNER TO runbot;

--
-- Name: TABLE appointment_invite_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_invite_res_users_rel IS 'RELATION BETWEEN appointment_invite AND res_users';


--
-- Name: appointment_manage_leaves; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_manage_leaves (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    leave_start_dt timestamp without time zone NOT NULL,
    leave_end_dt timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.appointment_manage_leaves OWNER TO runbot;

--
-- Name: TABLE appointment_manage_leaves; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_manage_leaves IS 'Add or remove leaves from appointments';


--
-- Name: COLUMN appointment_manage_leaves.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_manage_leaves.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_manage_leaves.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_manage_leaves.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_manage_leaves.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_manage_leaves.reason IS 'Reason';


--
-- Name: COLUMN appointment_manage_leaves.leave_start_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_manage_leaves.leave_start_dt IS 'Start Date';


--
-- Name: COLUMN appointment_manage_leaves.leave_end_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_manage_leaves.leave_end_dt IS 'End Date';


--
-- Name: COLUMN appointment_manage_leaves.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_manage_leaves.create_date IS 'Created on';


--
-- Name: COLUMN appointment_manage_leaves.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_manage_leaves.write_date IS 'Last Updated on';


--
-- Name: appointment_manage_leaves_appointment_resource_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_manage_leaves_appointment_resource_rel (
    appointment_manage_leaves_id integer NOT NULL,
    appointment_resource_id integer NOT NULL
);


ALTER TABLE public.appointment_manage_leaves_appointment_resource_rel OWNER TO runbot;

--
-- Name: TABLE appointment_manage_leaves_appointment_resource_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_manage_leaves_appointment_resource_rel IS 'RELATION BETWEEN appointment_manage_leaves AND appointment_resource';


--
-- Name: appointment_manage_leaves_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.appointment_manage_leaves_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_manage_leaves_id_seq OWNER TO runbot;

--
-- Name: appointment_manage_leaves_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.appointment_manage_leaves_id_seq OWNED BY public.appointment_manage_leaves.id;


--
-- Name: appointment_question; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_question (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    question_type character varying NOT NULL,
    name jsonb NOT NULL,
    placeholder jsonb,
    extra_comment jsonb,
    active boolean,
    is_default boolean,
    is_reusable boolean,
    question_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT appointment_question_check_default_question_is_reusable CHECK (((is_default IS DISTINCT FROM true) OR (is_reusable IS TRUE)))
);


ALTER TABLE public.appointment_question OWNER TO runbot;

--
-- Name: TABLE appointment_question; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_question IS 'Appointment Questions';


--
-- Name: COLUMN appointment_question.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_question.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_question.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_question.question_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.question_type IS 'Answer Type';


--
-- Name: COLUMN appointment_question.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.name IS 'Question';


--
-- Name: COLUMN appointment_question.placeholder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.placeholder IS 'Placeholder';


--
-- Name: COLUMN appointment_question.extra_comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.extra_comment IS 'Extra Comment';


--
-- Name: COLUMN appointment_question.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.active IS 'Active';


--
-- Name: COLUMN appointment_question.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.is_default IS 'Default question';


--
-- Name: COLUMN appointment_question.is_reusable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.is_reusable IS 'Is Reusable';


--
-- Name: COLUMN appointment_question.question_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.question_required IS 'Mandatory Answer';


--
-- Name: COLUMN appointment_question.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.create_date IS 'Created on';


--
-- Name: COLUMN appointment_question.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_question.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT appointment_question_check_default_question_is_reusable ON appointment_question; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_question_check_default_question_is_reusable ON public.appointment_question IS 'CHECK(is_default IS DISTINCT FROM TRUE OR is_reusable IS TRUE)';


--
-- Name: appointment_question_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.appointment_question_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_question_id_seq OWNER TO runbot;

--
-- Name: appointment_question_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.appointment_question_id_seq OWNED BY public.appointment_question.id;


--
-- Name: appointment_resource; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_resource (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer,
    resource_calendar_id integer,
    sequence integer NOT NULL,
    capacity integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description jsonb,
    active boolean,
    shareable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT appointment_resource_check_capacity CHECK ((capacity >= 1))
);


ALTER TABLE public.appointment_resource OWNER TO runbot;

--
-- Name: TABLE appointment_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_resource IS 'Appointment Resource';


--
-- Name: COLUMN appointment_resource.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.resource_id IS 'Resource';


--
-- Name: COLUMN appointment_resource.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.company_id IS 'Company';


--
-- Name: COLUMN appointment_resource.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN appointment_resource.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_resource.capacity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.capacity IS 'Capacity';


--
-- Name: COLUMN appointment_resource.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_resource.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_resource.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.name IS 'Name';


--
-- Name: COLUMN appointment_resource.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.description IS 'Description';


--
-- Name: COLUMN appointment_resource.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.active IS 'Active';


--
-- Name: COLUMN appointment_resource.shareable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.shareable IS 'Shareable';


--
-- Name: COLUMN appointment_resource.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.create_date IS 'Created on';


--
-- Name: COLUMN appointment_resource.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_resource.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT appointment_resource_check_capacity ON appointment_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_resource_check_capacity ON public.appointment_resource IS 'check(capacity >= 1)';


--
-- Name: appointment_resource_appointment_slot_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_resource_appointment_slot_rel (
    appointment_slot_id integer NOT NULL,
    appointment_resource_id integer NOT NULL
);


ALTER TABLE public.appointment_resource_appointment_slot_rel OWNER TO runbot;

--
-- Name: TABLE appointment_resource_appointment_slot_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_resource_appointment_slot_rel IS 'RELATION BETWEEN appointment_slot AND appointment_resource';


--
-- Name: appointment_resource_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.appointment_resource_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_resource_id_seq OWNER TO runbot;

--
-- Name: appointment_resource_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.appointment_resource_id_seq OWNED BY public.appointment_resource.id;


--
-- Name: appointment_resource_linked_appointment_resource; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_resource_linked_appointment_resource (
    resource_id integer NOT NULL,
    linked_resource_id integer NOT NULL
);


ALTER TABLE public.appointment_resource_linked_appointment_resource OWNER TO runbot;

--
-- Name: TABLE appointment_resource_linked_appointment_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_resource_linked_appointment_resource IS 'RELATION BETWEEN appointment_resource AND appointment_resource';


--
-- Name: appointment_slot; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_slot (
    id integer NOT NULL,
    appointment_type_id integer,
    create_uid integer,
    write_uid integer,
    slot_type character varying NOT NULL,
    weekday character varying NOT NULL,
    allday boolean,
    start_datetime timestamp without time zone,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    start_hour double precision NOT NULL,
    end_hour double precision NOT NULL,
    CONSTRAINT appointment_slot_check_start_and_end_datetimes CHECK ((((slot_type)::text = 'recurring'::text) OR ((start_datetime IS NOT NULL) AND (end_datetime IS NOT NULL) AND (start_datetime <= end_datetime)))),
    CONSTRAINT appointment_slot_check_start_and_end_hour CHECK (((((end_hour = (0)::double precision) AND ((start_hour >= (0)::double precision) AND (start_hour <= (23.99)::double precision))) OR ((start_hour >= (0)::double precision) AND (start_hour <= end_hour))) AND ((end_hour = (0)::double precision) OR ((end_hour >= start_hour) AND (end_hour <= (23.99)::double precision)))))
);


ALTER TABLE public.appointment_slot OWNER TO runbot;

--
-- Name: TABLE appointment_slot; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_slot IS 'Appointment: Time Slot';


--
-- Name: COLUMN appointment_slot.appointment_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN appointment_slot.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_slot.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_slot.slot_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.slot_type IS 'Slot type';


--
-- Name: COLUMN appointment_slot.weekday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.weekday IS 'Week Day';


--
-- Name: COLUMN appointment_slot.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.allday IS 'All day';


--
-- Name: COLUMN appointment_slot.start_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.start_datetime IS 'From';


--
-- Name: COLUMN appointment_slot.end_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.end_datetime IS 'To';


--
-- Name: COLUMN appointment_slot.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.create_date IS 'Created on';


--
-- Name: COLUMN appointment_slot.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_slot.start_hour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.start_hour IS 'Starting Hour';


--
-- Name: COLUMN appointment_slot.end_hour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_slot.end_hour IS 'Ending Hour';


--
-- Name: CONSTRAINT appointment_slot_check_start_and_end_datetimes ON appointment_slot; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_slot_check_start_and_end_datetimes ON public.appointment_slot IS 'CHECK(
            slot_type=''recurring'' OR (
            start_datetime IS NOT NULL AND end_datetime IS NOT NULL AND (start_datetime <= end_datetime))
        )';


--
-- Name: CONSTRAINT appointment_slot_check_start_and_end_hour ON appointment_slot; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_slot_check_start_and_end_hour ON public.appointment_slot IS 'CHECK(
            ((end_hour=0 AND (start_hour BETWEEN 0 AND 23.99)) OR (start_hour BETWEEN 0 AND end_hour))
            AND (end_hour=0 OR (end_hour BETWEEN start_hour AND 23.99))
        )';


--
-- Name: appointment_slot_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.appointment_slot_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_slot_id_seq OWNER TO runbot;

--
-- Name: appointment_slot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.appointment_slot_id_seq OWNED BY public.appointment_slot.id;


--
-- Name: appointment_slot_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_slot_res_users_rel (
    appointment_slot_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.appointment_slot_res_users_rel OWNER TO runbot;

--
-- Name: TABLE appointment_slot_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_slot_res_users_rel IS 'RELATION BETWEEN appointment_slot AND res_users';


--
-- Name: appointment_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_type (
    id integer NOT NULL,
    sequence integer,
    location_id integer,
    max_bookings integer,
    booked_mail_template_id integer,
    canceled_mail_template_id integer,
    max_schedule_days integer NOT NULL,
    user_capacity integer,
    create_uid integer,
    write_uid integer,
    appointment_tz character varying NOT NULL,
    event_videocall_source character varying,
    category character varying,
    schedule_based_on character varying NOT NULL,
    name jsonb NOT NULL,
    message_confirmation jsonb,
    message_intro jsonb,
    active boolean,
    auto_confirm boolean,
    allow_guests boolean,
    manage_capacity boolean,
    is_auto_assign boolean,
    is_date_first boolean,
    hide_duration boolean,
    hide_timezone boolean,
    show_avatars boolean,
    is_published boolean,
    start_datetime timestamp without time zone,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    appointment_duration double precision NOT NULL,
    manual_confirmation_percentage double precision,
    min_cancellation_hours double precision NOT NULL,
    min_schedule_hours double precision NOT NULL,
    slot_creation_interval double precision,
    work_hours_activated boolean,
    product_id integer,
    has_payment_step boolean,
    website_id integer,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    is_seo_optimized boolean,
    upgrade_create boolean,
    CONSTRAINT appointment_type_check_capacity_positive CHECK (((user_capacity >= 1) AND (max_bookings >= 1))),
    CONSTRAINT appointment_type_check_manual_confirmation_percentage CHECK (((manual_confirmation_percentage >= (0)::double precision) AND (manual_confirmation_percentage <= (1)::double precision))),
    CONSTRAINT appointment_type_check_product_and_payment_step CHECK (((has_payment_step IS NULL) OR (NOT has_payment_step) OR (product_id IS NOT NULL)))
);


ALTER TABLE public.appointment_type OWNER TO runbot;

--
-- Name: TABLE appointment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_type IS 'Appointment Type';


--
-- Name: COLUMN appointment_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.sequence IS 'Sequence';


--
-- Name: COLUMN appointment_type.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.location_id IS 'Location';


--
-- Name: COLUMN appointment_type.max_bookings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.max_bookings IS 'Total Bookings';


--
-- Name: COLUMN appointment_type.booked_mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.booked_mail_template_id IS 'Booking Email';


--
-- Name: COLUMN appointment_type.canceled_mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.canceled_mail_template_id IS 'Cancellation Email';


--
-- Name: COLUMN appointment_type.max_schedule_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.max_schedule_days IS 'Schedule not after (days)';


--
-- Name: COLUMN appointment_type.user_capacity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.user_capacity IS 'User Capacity';


--
-- Name: COLUMN appointment_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.create_uid IS 'Created by';


--
-- Name: COLUMN appointment_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN appointment_type.appointment_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.appointment_tz IS 'Timezone';


--
-- Name: COLUMN appointment_type.event_videocall_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.event_videocall_source IS 'Video Link';


--
-- Name: COLUMN appointment_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.category IS 'Category';


--
-- Name: COLUMN appointment_type.schedule_based_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.schedule_based_on IS 'Book';


--
-- Name: COLUMN appointment_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.name IS 'Appointment Title';


--
-- Name: COLUMN appointment_type.message_confirmation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.message_confirmation IS 'Confirmation Message';


--
-- Name: COLUMN appointment_type.message_intro; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.message_intro IS 'Introduction Message';


--
-- Name: COLUMN appointment_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.active IS 'Active';


--
-- Name: COLUMN appointment_type.auto_confirm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.auto_confirm IS 'Auto Confirm';


--
-- Name: COLUMN appointment_type.allow_guests; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.allow_guests IS 'Allow invitations';


--
-- Name: COLUMN appointment_type.manage_capacity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.manage_capacity IS 'Manage Capacities';


--
-- Name: COLUMN appointment_type.is_auto_assign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.is_auto_assign IS 'Assign automatically';


--
-- Name: COLUMN appointment_type.is_date_first; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.is_date_first IS 'Select date and time first';


--
-- Name: COLUMN appointment_type.hide_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.hide_duration IS 'Hide Duration';


--
-- Name: COLUMN appointment_type.hide_timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.hide_timezone IS 'Hide Time Zone';


--
-- Name: COLUMN appointment_type.show_avatars; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.show_avatars IS 'Display pictures';


--
-- Name: COLUMN appointment_type.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.is_published IS 'Is Published';


--
-- Name: COLUMN appointment_type.start_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.start_datetime IS 'Start Datetime';


--
-- Name: COLUMN appointment_type.end_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.end_datetime IS 'End Datetime';


--
-- Name: COLUMN appointment_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.create_date IS 'Created on';


--
-- Name: COLUMN appointment_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN appointment_type.appointment_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.appointment_duration IS 'Duration';


--
-- Name: COLUMN appointment_type.manual_confirmation_percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.manual_confirmation_percentage IS 'Capacity Percentage';


--
-- Name: COLUMN appointment_type.min_cancellation_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.min_cancellation_hours IS 'Cancel Before (hours)';


--
-- Name: COLUMN appointment_type.min_schedule_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.min_schedule_hours IS 'Schedule before (hours)';


--
-- Name: COLUMN appointment_type.slot_creation_interval; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.slot_creation_interval IS 'Create slot every';


--
-- Name: COLUMN appointment_type.work_hours_activated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.work_hours_activated IS 'Employee Schedule';


--
-- Name: COLUMN appointment_type.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.product_id IS 'Booking Product';


--
-- Name: COLUMN appointment_type.has_payment_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.has_payment_step IS 'Up-front Payment';


--
-- Name: COLUMN appointment_type.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.website_id IS 'Website';


--
-- Name: COLUMN appointment_type.website_meta_og_img; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN appointment_type.website_meta_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN appointment_type.website_meta_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN appointment_type.website_meta_keywords; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN appointment_type.seo_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.seo_name IS 'Seo name';


--
-- Name: COLUMN appointment_type.is_seo_optimized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.is_seo_optimized IS 'SEO optimized';


--
-- Name: COLUMN appointment_type.upgrade_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.appointment_type.upgrade_create IS 'Upgrade Create';


--
-- Name: CONSTRAINT appointment_type_check_capacity_positive ON appointment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_type_check_capacity_positive ON public.appointment_type IS 'check(user_capacity >= 1 AND max_bookings >= 1)';


--
-- Name: CONSTRAINT appointment_type_check_manual_confirmation_percentage ON appointment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_type_check_manual_confirmation_percentage ON public.appointment_type IS 'check(manual_confirmation_percentage >= 0 and manual_confirmation_percentage <= 1)';


--
-- Name: CONSTRAINT appointment_type_check_product_and_payment_step ON appointment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT appointment_type_check_product_and_payment_step ON public.appointment_type IS 'CHECK(has_payment_step IS NULL OR NOT has_payment_step OR product_id IS NOT NULL)';


--
-- Name: appointment_type_appointment_question_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_type_appointment_question_rel (
    appointment_question_id integer NOT NULL,
    appointment_type_id integer NOT NULL
);


ALTER TABLE public.appointment_type_appointment_question_rel OWNER TO runbot;

--
-- Name: TABLE appointment_type_appointment_question_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_type_appointment_question_rel IS 'RELATION BETWEEN appointment_question AND appointment_type';


--
-- Name: appointment_type_appointment_resource_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_type_appointment_resource_rel (
    appointment_resource_id integer NOT NULL,
    appointment_type_id integer NOT NULL
);


ALTER TABLE public.appointment_type_appointment_resource_rel OWNER TO runbot;

--
-- Name: TABLE appointment_type_appointment_resource_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_type_appointment_resource_rel IS 'RELATION BETWEEN appointment_resource AND appointment_type';


--
-- Name: appointment_type_calendar_alarm_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_type_calendar_alarm_rel (
    appointment_type_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.appointment_type_calendar_alarm_rel OWNER TO runbot;

--
-- Name: TABLE appointment_type_calendar_alarm_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_type_calendar_alarm_rel IS 'RELATION BETWEEN appointment_type AND calendar_alarm';


--
-- Name: appointment_type_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_type_country_rel (
    appointment_type_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.appointment_type_country_rel OWNER TO runbot;

--
-- Name: TABLE appointment_type_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_type_country_rel IS 'RELATION BETWEEN appointment_type AND res_country';


--
-- Name: appointment_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.appointment_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.appointment_type_id_seq OWNER TO runbot;

--
-- Name: appointment_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.appointment_type_id_seq OWNED BY public.appointment_type.id;


--
-- Name: appointment_type_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.appointment_type_res_users_rel (
    appointment_type_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.appointment_type_res_users_rel OWNER TO runbot;

--
-- Name: TABLE appointment_type_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.appointment_type_res_users_rel IS 'RELATION BETWEEN appointment_type AND res_users';


--
-- Name: auth_passkey_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key (
    id integer NOT NULL,
    sign_count integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    credential_identifier character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    public_key character varying
);


ALTER TABLE public.auth_passkey_key OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key IS 'Passkey';


--
-- Name: COLUMN auth_passkey_key.sign_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.sign_count IS 'Sign Count';


--
-- Name: COLUMN auth_passkey_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_uid IS 'Create Uid';


--
-- Name: COLUMN auth_passkey_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key.credential_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.credential_identifier IS 'Credential Identifier';


--
-- Name: COLUMN auth_passkey_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key_create (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_passkey_key_create OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key_create IS 'Create a Passkey';


--
-- Name: COLUMN auth_passkey_key_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_uid IS 'Created by';


--
-- Name: COLUMN auth_passkey_key_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNED BY public.auth_passkey_key_create.id;


--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_id_seq OWNED BY public.auth_passkey_key.id;


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_rate_limit_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_rate_limit_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    ip character varying,
    limit_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_totp_rate_limit_log OWNER TO runbot;

--
-- Name: TABLE auth_totp_rate_limit_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_rate_limit_log IS 'TOTP rate limit logs';


--
-- Name: COLUMN auth_totp_rate_limit_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.user_id IS 'User';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_rate_limit_log.ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.ip IS 'Ip';


--
-- Name: COLUMN auth_totp_rate_limit_log.limit_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.limit_type IS 'Limit Type';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_date IS 'Last Updated on';


--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_rate_limit_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNER TO runbot;

--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNED BY public.auth_totp_rate_limit_log.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: avatax_connection_test_result; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_connection_test_result (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_response text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_connection_test_result OWNER TO runbot;

--
-- Name: TABLE avatax_connection_test_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_connection_test_result IS 'Test connection with avatax';


--
-- Name: COLUMN avatax_connection_test_result.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_connection_test_result.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_connection_test_result.server_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.server_response IS 'Server Response';


--
-- Name: COLUMN avatax_connection_test_result.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_date IS 'Created on';


--
-- Name: COLUMN avatax_connection_test_result.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_date IS 'Last Updated on';


--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_connection_test_result_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNER TO runbot;

--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNED BY public.avatax_connection_test_result.id;


--
-- Name: avatax_exemption; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_exemption (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    description character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_exemption OWNER TO runbot;

--
-- Name: TABLE avatax_exemption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_exemption IS 'Avatax Partner Exemption Codes';


--
-- Name: COLUMN avatax_exemption.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.company_id IS 'Company';


--
-- Name: COLUMN avatax_exemption.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_exemption.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_exemption.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.name IS 'Name';


--
-- Name: COLUMN avatax_exemption.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.code IS 'Code';


--
-- Name: COLUMN avatax_exemption.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.description IS 'Description';


--
-- Name: COLUMN avatax_exemption.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.create_date IS 'Created on';


--
-- Name: COLUMN avatax_exemption.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.write_date IS 'Last Updated on';


--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_exemption_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_exemption_id_seq OWNER TO runbot;

--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_exemption_id_seq OWNED BY public.avatax_exemption.id;


--
-- Name: avatax_exemption_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_exemption_res_country_rel (
    avatax_exemption_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.avatax_exemption_res_country_rel OWNER TO runbot;

--
-- Name: TABLE avatax_exemption_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_exemption_res_country_rel IS 'RELATION BETWEEN avatax_exemption AND res_country';


--
-- Name: avatax_validate_address; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_validate_address (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_validate_address OWNER TO runbot;

--
-- Name: TABLE avatax_validate_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_validate_address IS 'Suggests validated addresses from Avatax';


--
-- Name: COLUMN avatax_validate_address.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.partner_id IS 'Partner';


--
-- Name: COLUMN avatax_validate_address.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_validate_address.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_validate_address.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.create_date IS 'Created on';


--
-- Name: COLUMN avatax_validate_address.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.write_date IS 'Last Updated on';


--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_validate_address_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_validate_address_id_seq OWNER TO runbot;

--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_validate_address_id_seq OWNED BY public.avatax_validate_address.id;


--
-- Name: badge_unlocked_definition_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.badge_unlocked_definition_rel (
    gamification_badge_id integer NOT NULL,
    gamification_goal_definition_id integer NOT NULL
);


ALTER TABLE public.badge_unlocked_definition_rel OWNER TO runbot;

--
-- Name: TABLE badge_unlocked_definition_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.badge_unlocked_definition_rel IS 'RELATION BETWEEN gamification_badge AND gamification_goal_definition';


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    from_invoice boolean
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_document_layout.from_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.from_invoice IS 'From Invoice';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_language_install_website_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install_website_rel (
    base_language_install_id integer NOT NULL,
    website_id integer NOT NULL
);


ALTER TABLE public.base_language_install_website_rel OWNER TO runbot;

--
-- Name: TABLE base_language_install_website_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install_website_rel IS 'RELATION BETWEEN base_language_install AND website';


--
-- Name: base_module_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install (
    id integer NOT NULL,
    confirm_input integer,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install OWNER TO runbot;

--
-- Name: TABLE base_module_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install IS 'Module Install';


--
-- Name: COLUMN base_module_install.confirm_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.confirm_input IS 'Confirm Input';


--
-- Name: COLUMN base_module_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.show_all IS 'Show All';


--
-- Name: COLUMN base_module_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_date IS 'Last Updated on';


--
-- Name: base_module_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_id_seq OWNER TO runbot;

--
-- Name: base_module_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_id_seq OWNED BY public.base_module_install.id;


--
-- Name: base_module_install_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_ir_module_module_rel (
    base_module_install_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_install_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_install_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_ir_module_module_rel IS 'RELATION BETWEEN base_module_install AND ir_module_module';


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    confirm_input integer
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_module_uninstall.confirm_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.confirm_input IS 'Confirm Input';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_uninstall_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall_ir_module_module_rel (
    base_module_uninstall_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_uninstall_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall_ir_module_module_rel IS 'RELATION BETWEEN base_module_uninstall AND ir_module_module';


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: bg_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bg_job (
    id integer NOT NULL,
    priority integer,
    max_retries integer,
    retry_count integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    model character varying NOT NULL,
    method character varying NOT NULL,
    args_json jsonb,
    kwargs_json jsonb,
    context_json jsonb,
    error_message text,
    start_time timestamp without time zone,
    end_time timestamp without time zone,
    cancel_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.bg_job OWNER TO runbot;

--
-- Name: TABLE bg_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bg_job IS 'Background Job';


--
-- Name: COLUMN bg_job.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.priority IS 'Priority';


--
-- Name: COLUMN bg_job.max_retries; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.max_retries IS 'Max Retries';


--
-- Name: COLUMN bg_job.retry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.retry_count IS 'Retry Count';


--
-- Name: COLUMN bg_job.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.create_uid IS 'Created by';


--
-- Name: COLUMN bg_job.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bg_job.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.name IS 'Job Name';


--
-- Name: COLUMN bg_job.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.state IS 'State';


--
-- Name: COLUMN bg_job.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.model IS 'Model';


--
-- Name: COLUMN bg_job.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.method IS 'Method';


--
-- Name: COLUMN bg_job.args_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.args_json IS 'Args Json';


--
-- Name: COLUMN bg_job.kwargs_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.kwargs_json IS 'Kwargs Json';


--
-- Name: COLUMN bg_job.context_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.context_json IS 'Context Json';


--
-- Name: COLUMN bg_job.error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.error_message IS 'Error Message';


--
-- Name: COLUMN bg_job.start_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.start_time IS 'Start Time';


--
-- Name: COLUMN bg_job.end_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.end_time IS 'End Time';


--
-- Name: COLUMN bg_job.cancel_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.cancel_time IS 'Cancel Time';


--
-- Name: COLUMN bg_job.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.create_date IS 'Created on';


--
-- Name: COLUMN bg_job.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.write_date IS 'Last Updated on';


--
-- Name: COLUMN bg_job.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.duration IS 'Duration';


--
-- Name: bg_job_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bg_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bg_job_id_seq OWNER TO runbot;

--
-- Name: bg_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bg_job_id_seq OWNED BY public.bg_job.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm (
    id integer NOT NULL,
    duration integer NOT NULL,
    duration_minutes integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    alarm_type character varying NOT NULL,
    "interval" character varying NOT NULL,
    name jsonb NOT NULL,
    body text,
    notify_responsible boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    default_for_new_appointment_type boolean,
    sms_template_id integer
);


ALTER TABLE public.calendar_alarm OWNER TO runbot;

--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm IS 'Event Alarm';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration IS 'Remind Before';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.mail_template_id IS 'Email Template';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.alarm_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.alarm_type IS 'Type';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.body IS 'Additional Message';


--
-- Name: COLUMN calendar_alarm.notify_responsible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.notify_responsible IS 'Notify Responsible';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_alarm.default_for_new_appointment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.default_for_new_appointment_type IS 'New Appointments Default';


--
-- Name: COLUMN calendar_alarm.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.sms_template_id IS 'SMS Template';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.calendar_alarm_calendar_event_rel OWNER TO runbot;

--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_alarm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_alarm_id_seq OWNER TO runbot;

--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_alarm_id_seq OWNED BY public.calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_attendee (
    id integer NOT NULL,
    event_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    common_name character varying,
    access_token character varying,
    state character varying,
    availability character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_attendee OWNER TO runbot;

--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_attendee IS 'Calendar Attendee Information';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.partner_id IS 'Attendee';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.common_name IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.availability IS 'Available/Busy';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_attendee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_attendee_id_seq OWNER TO runbot;

--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_attendee_id_seq OWNED BY public.calendar_attendee.id;


--
-- Name: calendar_booking; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_booking (
    id integer NOT NULL,
    appointment_invite_id integer,
    appointment_type_id integer NOT NULL,
    partner_id integer,
    asked_capacity integer,
    staff_user_id integer,
    account_move_id integer,
    product_id integer NOT NULL,
    calendar_event_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    booking_token character varying,
    description text,
    allday boolean,
    not_available boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_booking OWNER TO runbot;

--
-- Name: TABLE calendar_booking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_booking IS 'Meeting Booking';


--
-- Name: COLUMN calendar_booking.appointment_invite_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.appointment_invite_id IS 'Appointment Invite';


--
-- Name: COLUMN calendar_booking.appointment_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.appointment_type_id IS 'Appointment Type';


--
-- Name: COLUMN calendar_booking.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.partner_id IS 'Contact';


--
-- Name: COLUMN calendar_booking.asked_capacity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.asked_capacity IS 'Asked Capacity';


--
-- Name: COLUMN calendar_booking.staff_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.staff_user_id IS 'Operator';


--
-- Name: COLUMN calendar_booking.account_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.account_move_id IS 'Appointment Invoice';


--
-- Name: COLUMN calendar_booking.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.product_id IS 'Product';


--
-- Name: COLUMN calendar_booking.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.calendar_event_id IS 'Meeting';


--
-- Name: COLUMN calendar_booking.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_booking.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_booking.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.name IS 'Customer Name';


--
-- Name: COLUMN calendar_booking.booking_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.booking_token IS 'Access Token';


--
-- Name: COLUMN calendar_booking.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.description IS 'Description';


--
-- Name: COLUMN calendar_booking.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.allday IS 'Allday';


--
-- Name: COLUMN calendar_booking.not_available; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.not_available IS 'Is Not Available';


--
-- Name: COLUMN calendar_booking.start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.start IS 'Start';


--
-- Name: COLUMN calendar_booking.stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.stop IS 'Stop';


--
-- Name: COLUMN calendar_booking.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.create_date IS 'Created on';


--
-- Name: COLUMN calendar_booking.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking.write_date IS 'Last Updated on';


--
-- Name: calendar_booking_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_booking_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_booking_id_seq OWNER TO runbot;

--
-- Name: calendar_booking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_booking_id_seq OWNED BY public.calendar_booking.id;


--
-- Name: calendar_booking_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_booking_line (
    id integer NOT NULL,
    appointment_resource_id integer,
    calendar_booking_id integer NOT NULL,
    capacity_reserved integer,
    capacity_used integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_booking_line OWNER TO runbot;

--
-- Name: TABLE calendar_booking_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_booking_line IS 'Meeting User/Resource Booking';


--
-- Name: COLUMN calendar_booking_line.appointment_resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking_line.appointment_resource_id IS 'Resource';


--
-- Name: COLUMN calendar_booking_line.calendar_booking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking_line.calendar_booking_id IS 'Meeting Booking';


--
-- Name: COLUMN calendar_booking_line.capacity_reserved; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking_line.capacity_reserved IS 'Capacity Reserved';


--
-- Name: COLUMN calendar_booking_line.capacity_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking_line.capacity_used IS 'Capacity Used';


--
-- Name: COLUMN calendar_booking_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking_line.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_booking_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_booking_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking_line.create_date IS 'Created on';


--
-- Name: COLUMN calendar_booking_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_booking_line.write_date IS 'Last Updated on';


--
-- Name: calendar_booking_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_booking_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_booking_line_id_seq OWNER TO runbot;

--
-- Name: calendar_booking_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_booking_line_id_seq OWNED BY public.calendar_booking_line.id;


--
-- Name: calendar_booking_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_booking_res_partner_rel (
    calendar_booking_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.calendar_booking_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE calendar_booking_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_booking_res_partner_rel IS 'RELATION BETWEEN calendar_booking AND res_partner';


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event (
    id integer NOT NULL,
    user_id integer,
    videocall_channel_id integer,
    res_id integer,
    res_model_id integer,
    recurrence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location character varying,
    videocall_location character varying,
    access_token character varying,
    privacy character varying,
    show_as character varying NOT NULL,
    res_model character varying,
    start_date date,
    stop_date date,
    description text,
    notes text,
    active boolean,
    allday boolean,
    recurrency boolean,
    follow_recurrence boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision,
    appointment_type_id integer,
    appointment_invite_id integer,
    appointment_booker_id integer,
    appointment_status character varying,
    visitor_id integer,
    request_id integer
);


ALTER TABLE public.calendar_event OWNER TO runbot;

--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event IS 'Calendar Event';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.user_id IS 'Organizer';


--
-- Name: COLUMN calendar_event.videocall_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_channel_id IS 'Discuss Channel';


--
-- Name: COLUMN calendar_event.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_id IS 'Document ID';


--
-- Name: COLUMN calendar_event.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model_id IS 'Document Model';


--
-- Name: COLUMN calendar_event.recurrence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrence_id IS 'Recurrence Rule';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.videocall_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_location IS 'Meeting URL';


--
-- Name: COLUMN calendar_event.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_event.privacy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.privacy IS 'Privacy';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.show_as IS 'Show as';


--
-- Name: COLUMN calendar_event.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model IS 'Document Model Name';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.notes IS 'Notes';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.follow_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.follow_recurrence IS 'Follow Recurrence';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start IS 'Start';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop IS 'Stop';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.duration IS 'Duration';


--
-- Name: COLUMN calendar_event.appointment_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.appointment_type_id IS 'Appointment';


--
-- Name: COLUMN calendar_event.appointment_invite_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.appointment_invite_id IS 'Appointment Invitation';


--
-- Name: COLUMN calendar_event.appointment_booker_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.appointment_booker_id IS 'Person who is booking the appointment';


--
-- Name: COLUMN calendar_event.appointment_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.appointment_status IS 'Appointment Status';


--
-- Name: COLUMN calendar_event.visitor_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.visitor_id IS 'Visitor';


--
-- Name: COLUMN calendar_event.request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.request_id IS 'Request';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_id_seq OWNER TO runbot;

--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_id_seq OWNED BY public.calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_res_partner_rel (
    res_partner_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


ALTER TABLE public.calendar_event_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_res_partner_rel IS 'RELATION BETWEEN res_partner AND calendar_event';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_event_type OWNER TO runbot;

--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_type IS 'Event Meeting Type';


--
-- Name: COLUMN calendar_event_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.color IS 'Color';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_type_id_seq OWNER TO runbot;

--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_type_id_seq OWNED BY public.calendar_event_type.id;


--
-- Name: calendar_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_filters (
    id integer NOT NULL,
    user_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    partner_checked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_filters OWNER TO runbot;

--
-- Name: TABLE calendar_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_filters IS 'Calendar Filters';


--
-- Name: COLUMN calendar_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.user_id IS 'Me';


--
-- Name: COLUMN calendar_filters.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_id IS 'Employee';


--
-- Name: COLUMN calendar_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.active IS 'Active';


--
-- Name: COLUMN calendar_filters.partner_checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_checked IS 'Checked';


--
-- Name: COLUMN calendar_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_date IS 'Created on';


--
-- Name: COLUMN calendar_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_date IS 'Last Updated on';


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_filters_id_seq OWNER TO runbot;

--
-- Name: calendar_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_filters_id_seq OWNED BY public.calendar_filters.id;


--
-- Name: calendar_popover_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_popover_delete_wizard (
    id integer NOT NULL,
    template_id integer,
    calendar_event_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    delete character varying,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_popover_delete_wizard OWNER TO runbot;

--
-- Name: TABLE calendar_popover_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_popover_delete_wizard IS 'Calendar Popover Delete Wizard';


--
-- Name: COLUMN calendar_popover_delete_wizard.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.template_id IS 'Mail Template';


--
-- Name: COLUMN calendar_popover_delete_wizard.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.calendar_event_id IS 'Calendar Event';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_popover_delete_wizard.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.lang IS 'Language';


--
-- Name: COLUMN calendar_popover_delete_wizard.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.subject IS 'Subject';


--
-- Name: COLUMN calendar_popover_delete_wizard.delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.delete IS 'Delete';


--
-- Name: COLUMN calendar_popover_delete_wizard.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.body IS 'Contents';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_popover_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNED BY public.calendar_popover_delete_wizard.id;


--
-- Name: calendar_provider_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_provider_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    external_calendar_provider character varying,
    cal_client_id character varying,
    cal_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    cal_sync_paused boolean,
    microsoft_outlook_sync_paused boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_provider_config OWNER TO runbot;

--
-- Name: TABLE calendar_provider_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_provider_config IS 'Calendar Provider Configuration Wizard';


--
-- Name: COLUMN calendar_provider_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_provider_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_provider_config.external_calendar_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.external_calendar_provider IS 'Choose an external calendar to configure';


--
-- Name: COLUMN calendar_provider_config.cal_client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_id IS 'Google Client_id';


--
-- Name: COLUMN calendar_provider_config.cal_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_secret IS 'Google Client_key';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN calendar_provider_config.cal_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_sync_paused IS 'Google Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_sync_paused IS 'Outlook Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_date IS 'Created on';


--
-- Name: COLUMN calendar_provider_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_date IS 'Last Updated on';


--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_provider_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_provider_config_id_seq OWNER TO runbot;

--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_provider_config_id_seq OWNED BY public.calendar_provider_config.id;


--
-- Name: calendar_recurrence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_recurrence (
    id integer NOT NULL,
    base_event_id integer,
    "interval" integer,
    count integer,
    day integer,
    trigger_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    event_tz character varying,
    rrule character varying,
    rrule_type character varying,
    end_type character varying,
    month_by character varying,
    weekday character varying,
    byday character varying,
    until date,
    mon boolean,
    tue boolean,
    wed boolean,
    thu boolean,
    fri boolean,
    sat boolean,
    sun boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT calendar_recurrence_month_day CHECK ((((rrule_type)::text <> 'monthly'::text) OR ((month_by)::text <> 'day'::text) OR ((day >= 1) AND (day <= 31)) OR (((weekday)::text = ANY ((ARRAY['MON'::character varying, 'TUE'::character varying, 'WED'::character varying, 'THU'::character varying, 'FRI'::character varying, 'SAT'::character varying, 'SUN'::character varying])::text[])) AND ((byday)::text = ANY ((ARRAY['1'::character varying, '2'::character varying, '3'::character varying, '4'::character varying, '-1'::character varying])::text[])))))
);


ALTER TABLE public.calendar_recurrence OWNER TO runbot;

--
-- Name: TABLE calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_recurrence IS 'Event Recurrence Rule';


--
-- Name: COLUMN calendar_recurrence.base_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.base_event_id IS 'Base Event';


--
-- Name: COLUMN calendar_recurrence."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence."interval" IS 'Interval';


--
-- Name: COLUMN calendar_recurrence.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.count IS 'Count';


--
-- Name: COLUMN calendar_recurrence.day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.day IS 'Day';


--
-- Name: COLUMN calendar_recurrence.trigger_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.trigger_id IS 'Trigger';


--
-- Name: COLUMN calendar_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_recurrence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.name IS 'Name';


--
-- Name: COLUMN calendar_recurrence.event_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.event_tz IS 'Timezone';


--
-- Name: COLUMN calendar_recurrence.rrule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule IS 'Rrule';


--
-- Name: COLUMN calendar_recurrence.rrule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule_type IS 'Rrule Type';


--
-- Name: COLUMN calendar_recurrence.end_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.end_type IS 'End Type';


--
-- Name: COLUMN calendar_recurrence.month_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.month_by IS 'Month By';


--
-- Name: COLUMN calendar_recurrence.weekday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.weekday IS 'Weekday';


--
-- Name: COLUMN calendar_recurrence.byday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.byday IS 'By day';


--
-- Name: COLUMN calendar_recurrence.until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.until IS 'Repeat Until';


--
-- Name: COLUMN calendar_recurrence.mon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.mon IS 'Mon';


--
-- Name: COLUMN calendar_recurrence.tue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.tue IS 'Tue';


--
-- Name: COLUMN calendar_recurrence.wed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.wed IS 'Wed';


--
-- Name: COLUMN calendar_recurrence.thu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.thu IS 'Thu';


--
-- Name: COLUMN calendar_recurrence.fri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.fri IS 'Fri';


--
-- Name: COLUMN calendar_recurrence.sat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sat IS 'Sat';


--
-- Name: COLUMN calendar_recurrence.sun; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sun IS 'Sun';


--
-- Name: COLUMN calendar_recurrence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN calendar_recurrence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT calendar_recurrence_month_day ON calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT calendar_recurrence_month_day ON public.calendar_recurrence IS 'CHECK (
        rrule_type != ''monthly''
        OR month_by != ''day''
        OR day >= 1 AND day <= 31
        OR weekday IN (''MON'', ''TUE'', ''WED'', ''THU'', ''FRI'', ''SAT'', ''SUN'') AND byday IN (''1'', ''2'', ''3'', ''4'', ''-1''))';


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_recurrence_id_seq OWNER TO runbot;

--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_recurrence_id_seq OWNED BY public.calendar_recurrence.id;


--
-- Name: certificate_certificate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.certificate_certificate (
    id integer NOT NULL,
    private_key_id integer,
    public_key_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    pkcs12_password character varying,
    scope character varying,
    content_format character varying,
    subject_common_name character varying,
    serial_number character varying,
    loading_error text,
    active boolean,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    content_filename character varying
);


ALTER TABLE public.certificate_certificate OWNER TO runbot;

--
-- Name: TABLE certificate_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.certificate_certificate IS 'Certificate';


--
-- Name: COLUMN certificate_certificate.private_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.private_key_id IS 'Private Key';


--
-- Name: COLUMN certificate_certificate.public_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.public_key_id IS 'Public Key';


--
-- Name: COLUMN certificate_certificate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.company_id IS 'Company';


--
-- Name: COLUMN certificate_certificate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.create_uid IS 'Created by';


--
-- Name: COLUMN certificate_certificate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN certificate_certificate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.name IS 'Name';


--
-- Name: COLUMN certificate_certificate.pkcs12_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.pkcs12_password IS 'Certificate Password';


--
-- Name: COLUMN certificate_certificate.scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.scope IS 'Certificate scope';


--
-- Name: COLUMN certificate_certificate.content_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.content_format IS 'Original certificate format';


--
-- Name: COLUMN certificate_certificate.subject_common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.subject_common_name IS 'Subject Name';


--
-- Name: COLUMN certificate_certificate.serial_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.serial_number IS 'Serial number';


--
-- Name: COLUMN certificate_certificate.loading_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.loading_error IS 'Loading error';


--
-- Name: COLUMN certificate_certificate.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.active IS 'Active';


--
-- Name: COLUMN certificate_certificate.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.date_start IS 'Available date';


--
-- Name: COLUMN certificate_certificate.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.date_end IS 'Expiration date';


--
-- Name: COLUMN certificate_certificate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.create_date IS 'Created on';


--
-- Name: COLUMN certificate_certificate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.write_date IS 'Last Updated on';


--
-- Name: COLUMN certificate_certificate.content_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.content_filename IS 'Content Filename';


--
-- Name: certificate_certificate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.certificate_certificate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.certificate_certificate_id_seq OWNER TO runbot;

--
-- Name: certificate_certificate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.certificate_certificate_id_seq OWNED BY public.certificate_certificate.id;


--
-- Name: certificate_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.certificate_key (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    password character varying,
    loading_error text,
    public boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.certificate_key OWNER TO runbot;

--
-- Name: TABLE certificate_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.certificate_key IS 'Cryptographic Keys';


--
-- Name: COLUMN certificate_key.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.company_id IS 'Company';


--
-- Name: COLUMN certificate_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.create_uid IS 'Created by';


--
-- Name: COLUMN certificate_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN certificate_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.name IS 'Name';


--
-- Name: COLUMN certificate_key.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.password IS 'Private key password';


--
-- Name: COLUMN certificate_key.loading_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.loading_error IS 'Loading error';


--
-- Name: COLUMN certificate_key.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.public IS 'Public/Private key';


--
-- Name: COLUMN certificate_key.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.active IS 'Active';


--
-- Name: COLUMN certificate_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.create_date IS 'Created on';


--
-- Name: COLUMN certificate_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.write_date IS 'Last Updated on';


--
-- Name: certificate_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.certificate_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.certificate_key_id_seq OWNER TO runbot;

--
-- Name: certificate_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.certificate_key_id_seq OWNED BY public.certificate_key.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: chatbot_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_message (
    id integer NOT NULL,
    mail_message_id integer,
    discuss_channel_id integer NOT NULL,
    script_step_id integer,
    user_script_answer_id integer,
    user_raw_script_answer_id integer,
    create_uid integer,
    write_uid integer,
    user_raw_answer text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.chatbot_message OWNER TO runbot;

--
-- Name: TABLE chatbot_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_message IS 'Chatbot Message';


--
-- Name: COLUMN chatbot_message.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.mail_message_id IS 'Related Mail Message';


--
-- Name: COLUMN chatbot_message.discuss_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.discuss_channel_id IS 'Discussion Channel';


--
-- Name: COLUMN chatbot_message.script_step_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.script_step_id IS 'Chatbot Step';


--
-- Name: COLUMN chatbot_message.user_script_answer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.user_script_answer_id IS 'User''s answer';


--
-- Name: COLUMN chatbot_message.user_raw_script_answer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.user_raw_script_answer_id IS 'User Raw Script Answer';


--
-- Name: COLUMN chatbot_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_message.user_raw_answer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.user_raw_answer IS 'User''s raw answer';


--
-- Name: COLUMN chatbot_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_message.write_date IS 'Last Updated on';


--
-- Name: chatbot_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.chatbot_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.chatbot_message_id_seq OWNER TO runbot;

--
-- Name: chatbot_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.chatbot_message_id_seq OWNED BY public.chatbot_message.id;


--
-- Name: chatbot_script; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_script (
    id integer NOT NULL,
    source_id integer NOT NULL,
    operator_partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    title jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.chatbot_script OWNER TO runbot;

--
-- Name: TABLE chatbot_script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_script IS 'Chatbot Script';


--
-- Name: COLUMN chatbot_script.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.source_id IS 'Source';


--
-- Name: COLUMN chatbot_script.operator_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.operator_partner_id IS 'Bot Operator';


--
-- Name: COLUMN chatbot_script.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_script.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_script.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.title IS 'Title';


--
-- Name: COLUMN chatbot_script.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.active IS 'Active';


--
-- Name: COLUMN chatbot_script.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_script.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script.write_date IS 'Last Updated on';


--
-- Name: chatbot_script_answer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_script_answer (
    id integer NOT NULL,
    sequence integer,
    script_step_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    redirect_link character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.chatbot_script_answer OWNER TO runbot;

--
-- Name: TABLE chatbot_script_answer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_script_answer IS 'Chatbot Script Answer';


--
-- Name: COLUMN chatbot_script_answer.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.sequence IS 'Sequence';


--
-- Name: COLUMN chatbot_script_answer.script_step_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.script_step_id IS 'Script Step';


--
-- Name: COLUMN chatbot_script_answer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_script_answer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_script_answer.redirect_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.redirect_link IS 'Redirect Link';


--
-- Name: COLUMN chatbot_script_answer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.name IS 'Answer';


--
-- Name: COLUMN chatbot_script_answer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_script_answer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_answer.write_date IS 'Last Updated on';


--
-- Name: chatbot_script_answer_chatbot_script_step_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_script_answer_chatbot_script_step_rel (
    chatbot_script_step_id integer NOT NULL,
    chatbot_script_answer_id integer NOT NULL
);


ALTER TABLE public.chatbot_script_answer_chatbot_script_step_rel OWNER TO runbot;

--
-- Name: TABLE chatbot_script_answer_chatbot_script_step_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_script_answer_chatbot_script_step_rel IS 'RELATION BETWEEN chatbot_script_step AND chatbot_script_answer';


--
-- Name: chatbot_script_answer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.chatbot_script_answer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.chatbot_script_answer_id_seq OWNER TO runbot;

--
-- Name: chatbot_script_answer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.chatbot_script_answer_id_seq OWNED BY public.chatbot_script_answer.id;


--
-- Name: chatbot_script_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.chatbot_script_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.chatbot_script_id_seq OWNER TO runbot;

--
-- Name: chatbot_script_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.chatbot_script_id_seq OWNED BY public.chatbot_script.id;


--
-- Name: chatbot_script_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_script_step (
    id integer NOT NULL,
    sequence integer,
    chatbot_script_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    step_type character varying NOT NULL,
    message jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    helpdesk_team_id integer
);


ALTER TABLE public.chatbot_script_step OWNER TO runbot;

--
-- Name: TABLE chatbot_script_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_script_step IS 'Chatbot Script Step';


--
-- Name: COLUMN chatbot_script_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.sequence IS 'Sequence';


--
-- Name: COLUMN chatbot_script_step.chatbot_script_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.chatbot_script_id IS 'Chatbot';


--
-- Name: COLUMN chatbot_script_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.create_uid IS 'Created by';


--
-- Name: COLUMN chatbot_script_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN chatbot_script_step.step_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.step_type IS 'Step Type';


--
-- Name: COLUMN chatbot_script_step.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.message IS 'Message';


--
-- Name: COLUMN chatbot_script_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.create_date IS 'Created on';


--
-- Name: COLUMN chatbot_script_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.write_date IS 'Last Updated on';


--
-- Name: COLUMN chatbot_script_step.helpdesk_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.chatbot_script_step.helpdesk_team_id IS 'Helpdesk Team';


--
-- Name: chatbot_script_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.chatbot_script_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.chatbot_script_step_id_seq OWNER TO runbot;

--
-- Name: chatbot_script_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.chatbot_script_step_id_seq OWNED BY public.chatbot_script_step.id;


--
-- Name: chatbot_script_step_im_livechat_expertise_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.chatbot_script_step_im_livechat_expertise_rel (
    chatbot_script_step_id integer NOT NULL,
    im_livechat_expertise_id integer NOT NULL
);


ALTER TABLE public.chatbot_script_step_im_livechat_expertise_rel OWNER TO runbot;

--
-- Name: TABLE chatbot_script_step_im_livechat_expertise_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.chatbot_script_step_im_livechat_expertise_rel IS 'RELATION BETWEEN chatbot_script_step AND im_livechat_expertise';


--
-- Name: cnpg_settings_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cnpg_settings_wizard (
    id integer NOT NULL,
    database_id integer NOT NULL,
    memory_extra integer NOT NULL,
    cpu_extra integer NOT NULL,
    create_uid integer,
    write_uid integer,
    requests_cpu character varying,
    requests_memory character varying,
    limits_cpu character varying,
    limits_memory character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cnpg_settings_wizard OWNER TO runbot;

--
-- Name: TABLE cnpg_settings_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cnpg_settings_wizard IS 'CNPG Settings Wizard';


--
-- Name: COLUMN cnpg_settings_wizard.database_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.database_id IS 'Database';


--
-- Name: COLUMN cnpg_settings_wizard.memory_extra; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.memory_extra IS 'Memory Extra (MB - megabytes)';


--
-- Name: COLUMN cnpg_settings_wizard.cpu_extra; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.cpu_extra IS 'CPU Extra (m - millicores)';


--
-- Name: COLUMN cnpg_settings_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN cnpg_settings_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cnpg_settings_wizard.requests_cpu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.requests_cpu IS 'Current Requests CPU';


--
-- Name: COLUMN cnpg_settings_wizard.requests_memory; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.requests_memory IS 'Current Requests Memory';


--
-- Name: COLUMN cnpg_settings_wizard.limits_cpu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.limits_cpu IS 'Current Limits CPU';


--
-- Name: COLUMN cnpg_settings_wizard.limits_memory; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.limits_memory IS 'Current Limits Memory';


--
-- Name: COLUMN cnpg_settings_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.create_date IS 'Created on';


--
-- Name: COLUMN cnpg_settings_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cnpg_settings_wizard.write_date IS 'Last Updated on';


--
-- Name: cnpg_settings_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cnpg_settings_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cnpg_settings_wizard_id_seq OWNER TO runbot;

--
-- Name: cnpg_settings_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cnpg_settings_wizard_id_seq OWNED BY public.cnpg_settings_wizard.id;


--
-- Name: code_help_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.code_help_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code_help_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.code_help_wizard OWNER TO runbot;

--
-- Name: TABLE code_help_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.code_help_wizard IS 'Wizard to Edit Help Information';


--
-- Name: COLUMN code_help_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.code_help_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN code_help_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.code_help_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN code_help_wizard.code_help_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.code_help_wizard.code_help_html IS 'Help Information';


--
-- Name: COLUMN code_help_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.code_help_wizard.create_date IS 'Created on';


--
-- Name: COLUMN code_help_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.code_help_wizard.write_date IS 'Last Updated on';


--
-- Name: code_help_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.code_help_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.code_help_wizard_id_seq OWNER TO runbot;

--
-- Name: code_help_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.code_help_wizard_id_seq OWNED BY public.code_help_wizard.id;


--
-- Name: communication_database_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.communication_database_rel (
    saas_communication_id integer NOT NULL,
    saas_database_id integer NOT NULL
);


ALTER TABLE public.communication_database_rel OWNER TO runbot;

--
-- Name: TABLE communication_database_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.communication_database_rel IS 'RELATION BETWEEN saas_communication AND saas_database';


--
-- Name: communication_published_database_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.communication_published_database_rel (
    saas_communication_id integer NOT NULL,
    saas_database_id integer NOT NULL
);


ALTER TABLE public.communication_published_database_rel OWNER TO runbot;

--
-- Name: TABLE communication_published_database_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.communication_published_database_rel IS 'RELATION BETWEEN saas_communication AND saas_database';


--
-- Name: communication_unpublished_database_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.communication_unpublished_database_rel (
    saas_communication_id integer NOT NULL,
    saas_database_id integer NOT NULL
);


ALTER TABLE public.communication_unpublished_database_rel OWNER TO runbot;

--
-- Name: TABLE communication_unpublished_database_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.communication_unpublished_database_rel IS 'RELATION BETWEEN saas_communication AND saas_database';


--
-- Name: crm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_tag OWNER TO runbot;

--
-- Name: TABLE crm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag IS 'CRM Tag';


--
-- Name: COLUMN crm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.color IS 'Color';


--
-- Name: COLUMN crm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.name IS 'Tag Name';


--
-- Name: COLUMN crm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_date IS 'Created on';


--
-- Name: COLUMN crm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_date IS 'Last Updated on';


--
-- Name: crm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_tag_id_seq OWNER TO runbot;

--
-- Name: crm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_tag_id_seq OWNED BY public.crm_tag.id;


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    invoiced_target double precision
);


ALTER TABLE public.crm_team OWNER TO runbot;

--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team.invoiced_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.invoiced_target IS 'Invoicing Target';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_id_seq OWNER TO runbot;

--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: crm_team_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_member (
    id integer NOT NULL,
    crm_team_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_team_member OWNER TO runbot;

--
-- Name: TABLE crm_team_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_member IS 'Sales Team Member';


--
-- Name: COLUMN crm_team_member.crm_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN crm_team_member.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_team_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team_member.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.active IS 'Active';


--
-- Name: COLUMN crm_team_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_date IS 'Created on';


--
-- Name: COLUMN crm_team_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_date IS 'Last Updated on';


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_member_id_seq OWNER TO runbot;

--
-- Name: crm_team_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_member_id_seq OWNED BY public.crm_team_member.id;


--
-- Name: customer_note_preview_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.customer_note_preview_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    title character varying,
    message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.customer_note_preview_wizard OWNER TO runbot;

--
-- Name: TABLE customer_note_preview_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.customer_note_preview_wizard IS 'customer.note.preview.wizard';


--
-- Name: COLUMN customer_note_preview_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.customer_note_preview_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN customer_note_preview_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.customer_note_preview_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN customer_note_preview_wizard.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.customer_note_preview_wizard.title IS 'Title';


--
-- Name: COLUMN customer_note_preview_wizard.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.customer_note_preview_wizard.message IS 'Message';


--
-- Name: COLUMN customer_note_preview_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.customer_note_preview_wizard.create_date IS 'Created on';


--
-- Name: COLUMN customer_note_preview_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.customer_note_preview_wizard.write_date IS 'Last Updated on';


--
-- Name: customer_note_preview_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.customer_note_preview_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.customer_note_preview_wizard_id_seq OWNER TO runbot;

--
-- Name: customer_note_preview_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.customer_note_preview_wizard_id_seq OWNED BY public.customer_note_preview_wizard.id;


--
-- Name: deactivated_upgrade_line_request_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.deactivated_upgrade_line_request_rel (
    request_id integer NOT NULL,
    upgrade_line_id integer NOT NULL
);


ALTER TABLE public.deactivated_upgrade_line_request_rel OWNER TO runbot;

--
-- Name: TABLE deactivated_upgrade_line_request_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.deactivated_upgrade_line_request_rel IS 'RELATION BETWEEN helpdesk_ticket_upgrade_request AND saas_upgrade_line';


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: dev_access_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.dev_access_wizard (
    id integer NOT NULL,
    database_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.dev_access_wizard OWNER TO runbot;

--
-- Name: TABLE dev_access_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.dev_access_wizard IS 'Dev Access Wizard';


--
-- Name: COLUMN dev_access_wizard.database_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.dev_access_wizard.database_id IS 'Database';


--
-- Name: COLUMN dev_access_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.dev_access_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN dev_access_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.dev_access_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN dev_access_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.dev_access_wizard.duration IS 'Duration';


--
-- Name: COLUMN dev_access_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.dev_access_wizard.create_date IS 'Created on';


--
-- Name: COLUMN dev_access_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.dev_access_wizard.write_date IS 'Last Updated on';


--
-- Name: dev_access_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.dev_access_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.dev_access_wizard_id_seq OWNER TO runbot;

--
-- Name: dev_access_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.dev_access_wizard_id_seq OWNED BY public.dev_access_wizard.id;


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    kpi_account_total_revenue boolean,
    kpi_helpdesk_tickets_closed boolean,
    kpi_livechat_rating boolean,
    kpi_livechat_conversations boolean,
    kpi_livechat_response boolean,
    kpi_project_task_opened boolean,
    kpi_account_bank_cash boolean,
    kpi_all_sale_total boolean
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_account_total_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_total_revenue IS 'Revenue';


--
-- Name: COLUMN digest_digest.kpi_helpdesk_tickets_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_helpdesk_tickets_closed IS 'Tickets Closed';


--
-- Name: COLUMN digest_digest.kpi_livechat_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_livechat_rating IS '% of Happiness';


--
-- Name: COLUMN digest_digest.kpi_livechat_conversations; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_livechat_conversations IS 'Conversations handled';


--
-- Name: COLUMN digest_digest.kpi_livechat_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_livechat_response IS 'Time to answer (sec)';


--
-- Name: COLUMN digest_digest.kpi_project_task_opened; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_project_task_opened IS 'Open Tasks';


--
-- Name: COLUMN digest_digest.kpi_account_bank_cash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_bank_cash IS 'Bank & Cash Moves';


--
-- Name: COLUMN digest_digest.kpi_all_sale_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_all_sale_total IS 'All Sales';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: discuss_call_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_call_history (
    id integer NOT NULL,
    channel_id integer NOT NULL,
    start_call_message_id integer,
    create_uid integer,
    write_uid integer,
    start_dt timestamp without time zone NOT NULL,
    end_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_call_history_channel_id_not_null_constraint CHECK ((channel_id IS NOT NULL)),
    CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint CHECK ((start_dt IS NOT NULL))
);


ALTER TABLE public.discuss_call_history OWNER TO runbot;

--
-- Name: TABLE discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_call_history IS 'Keep the call history';


--
-- Name: COLUMN discuss_call_history.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_call_history.start_call_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_call_message_id IS 'Start Call Message';


--
-- Name: COLUMN discuss_call_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_call_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_call_history.start_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_dt IS 'Start Dt';


--
-- Name: COLUMN discuss_call_history.end_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.end_dt IS 'End Dt';


--
-- Name: COLUMN discuss_call_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_date IS 'Created on';


--
-- Name: COLUMN discuss_call_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON public.discuss_call_history IS 'CHECK (channel_id IS NOT NULL)';


--
-- Name: CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON public.discuss_call_history IS 'CHECK (start_dt IS NOT NULL)';


--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_call_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_call_history_id_seq OWNER TO runbot;

--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_call_history_id_seq OWNED BY public.discuss_call_history.id;


--
-- Name: discuss_call_history_im_livechat_channel_member_history_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_call_history_im_livechat_channel_member_history_rel (
    discuss_call_history_id integer NOT NULL,
    im_livechat_channel_member_history_id integer NOT NULL
);


ALTER TABLE public.discuss_call_history_im_livechat_channel_member_history_rel OWNER TO runbot;

--
-- Name: TABLE discuss_call_history_im_livechat_channel_member_history_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_call_history_im_livechat_channel_member_history_rel IS 'RELATION BETWEEN discuss_call_history AND im_livechat_channel_member_history';


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    livechat_lang_id integer,
    livechat_channel_id integer,
    livechat_operator_id integer,
    livechat_agent_requesting_help_history integer,
    livechat_agent_providing_help_history integer,
    chatbot_current_step_id integer,
    country_id integer,
    rating_last_text character varying,
    livechat_status character varying,
    livechat_outcome character varying,
    livechat_week_day character varying,
    livechat_failure character varying,
    livechat_note text,
    livechat_is_escalated boolean,
    livechat_end_dt timestamp without time zone,
    rating_last_value double precision,
    livechat_start_hour double precision,
    livechat_visitor_id integer,
    is_pending_chat_request boolean,
    has_helpdesk_ticket boolean,
    ai_agent_id integer,
    ai_env_context jsonb,
    CONSTRAINT discuss_channel_ai_channel_type_check CHECK (((ai_agent_id IS NULL) OR ((channel_type)::text = 'ai_chat'::text) OR ((channel_type)::text = 'livechat'::text))),
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL))),
    CONSTRAINT discuss_channel_livechat_end_dt_status_constraint CHECK (((livechat_end_dt IS NULL) OR (livechat_status IS NULL))),
    CONSTRAINT discuss_channel_livechat_operator_id CHECK (((((channel_type)::text = 'livechat'::text) AND (livechat_operator_id IS NOT NULL)) OR ((channel_type)::text <> 'livechat'::text)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: COLUMN discuss_channel.livechat_lang_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_lang_id IS 'Language';


--
-- Name: COLUMN discuss_channel.livechat_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel.livechat_operator_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_operator_id IS 'Operator';


--
-- Name: COLUMN discuss_channel.livechat_agent_requesting_help_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_agent_requesting_help_history IS 'Help Requested (Agent)';


--
-- Name: COLUMN discuss_channel.livechat_agent_providing_help_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_agent_providing_help_history IS 'Help Provided (Agent)';


--
-- Name: COLUMN discuss_channel.chatbot_current_step_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.chatbot_current_step_id IS 'Chatbot Current Step';


--
-- Name: COLUMN discuss_channel.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.country_id IS 'Country';


--
-- Name: COLUMN discuss_channel.rating_last_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.rating_last_text IS 'Rating Text';


--
-- Name: COLUMN discuss_channel.livechat_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_status IS 'Livechat Status';


--
-- Name: COLUMN discuss_channel.livechat_outcome; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_outcome IS 'Livechat Outcome';


--
-- Name: COLUMN discuss_channel.livechat_week_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_week_day IS 'Day of the Week';


--
-- Name: COLUMN discuss_channel.livechat_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_failure IS 'Live Chat Session Failure';


--
-- Name: COLUMN discuss_channel.livechat_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_note IS 'Live Chat Note';


--
-- Name: COLUMN discuss_channel.livechat_is_escalated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_is_escalated IS 'Is session escalated';


--
-- Name: COLUMN discuss_channel.livechat_end_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_end_dt IS 'Session end date';


--
-- Name: COLUMN discuss_channel.rating_last_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.rating_last_value IS 'Rating Last Value';


--
-- Name: COLUMN discuss_channel.livechat_start_hour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_start_hour IS 'Session Start Hour';


--
-- Name: COLUMN discuss_channel.livechat_visitor_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.livechat_visitor_id IS 'Visitor';


--
-- Name: COLUMN discuss_channel.is_pending_chat_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.is_pending_chat_request IS 'When created from an operator, whether the channel is yet to be opened on the visitor side.';


--
-- Name: COLUMN discuss_channel.has_helpdesk_ticket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.has_helpdesk_ticket IS 'Has Helpdesk Ticket';


--
-- Name: COLUMN discuss_channel.ai_agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_agent_id IS 'Ai Agent';


--
-- Name: COLUMN discuss_channel.ai_env_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_env_context IS 'Context for AI agent';


--
-- Name: CONSTRAINT discuss_channel_ai_channel_type_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_ai_channel_type_check ON public.discuss_channel IS 'CHECK(ai_agent_id IS NULL or channel_type = ''ai_chat'' or channel_type = ''livechat'')';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: CONSTRAINT discuss_channel_livechat_end_dt_status_constraint ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_livechat_end_dt_status_constraint ON public.discuss_channel IS 'CHECK(livechat_end_dt IS NULL or livechat_status IS NULL)';


--
-- Name: CONSTRAINT discuss_channel_livechat_operator_id ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_livechat_operator_id ON public.discuss_channel IS 'CHECK((channel_type = ''livechat'' and livechat_operator_id is not null) or (channel_type != ''livechat''))';


--
-- Name: discuss_channel_hr_department_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_hr_department_rel (
    discuss_channel_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_hr_department_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_hr_department_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_hr_department_rel IS 'RELATION BETWEEN discuss_channel AND hr_department';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_im_livechat_expertise_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_im_livechat_expertise_rel (
    discuss_channel_id integer NOT NULL,
    im_livechat_expertise_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_im_livechat_expertise_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_im_livechat_expertise_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_im_livechat_expertise_rel IS 'RELATION BETWEEN discuss_channel AND im_livechat_expertise';


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: dms_acc_rep_export_wizard_format_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.dms_acc_rep_export_wizard_format_rel (
    account_reports_export_wizard_id integer NOT NULL,
    account_reports_export_wizard_format_id integer NOT NULL
);


ALTER TABLE public.dms_acc_rep_export_wizard_format_rel OWNER TO runbot;

--
-- Name: TABLE dms_acc_rep_export_wizard_format_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.dms_acc_rep_export_wizard_format_rel IS 'RELATION BETWEEN account_reports_export_wizard AND account_reports_export_wizard_format';


--
-- Name: hr_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer NOT NULL,
    message_main_attachment_id integer,
    current_version_id integer,
    user_id integer,
    work_contact_id integer,
    country_of_birth integer,
    parent_id integer,
    coach_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    work_phone character varying,
    mobile_phone character varying,
    work_email character varying,
    legal_name character varying,
    private_phone character varying,
    private_email character varying,
    lang character varying,
    place_of_birth character varying,
    permit_no character varying,
    visa_no character varying,
    certificate character varying,
    study_field character varying,
    study_school character varying,
    emergency_contact character varying,
    emergency_phone character varying,
    barcode character varying,
    pin character varying,
    private_car_plate character varying,
    birthday date,
    visa_expire date,
    work_permit_expiration_date date,
    salary_distribution jsonb,
    employee_properties jsonb,
    active boolean,
    birthday_public_display boolean,
    work_permit_scheduled_activity boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    monday_location_id integer,
    tuesday_location_id integer,
    wednesday_location_id integer,
    thursday_location_id integer,
    friday_location_id integer,
    saturday_location_id integer,
    sunday_location_id integer,
    today_location_name character varying,
    hourly_cost numeric,
    timesheet_manager_id integer,
    last_validated_timesheet_date date,
    billable_time_target double precision,
    CONSTRAINT hr_employee_check_billable_time_target CHECK ((billable_time_target >= (0)::double precision))
);


ALTER TABLE public.hr_employee OWNER TO runbot;

--
-- Name: TABLE hr_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee IS 'Employee';


--
-- Name: COLUMN hr_employee.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.resource_id IS 'Resource';


--
-- Name: COLUMN hr_employee.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.company_id IS 'Company';


--
-- Name: COLUMN hr_employee.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_employee.current_version_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.current_version_id IS 'Current Version';


--
-- Name: COLUMN hr_employee.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.user_id IS 'User';


--
-- Name: COLUMN hr_employee.work_contact_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_contact_id IS 'Work Contact';


--
-- Name: COLUMN hr_employee.country_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.country_of_birth IS 'Country of Birth';


--
-- Name: COLUMN hr_employee.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.parent_id IS 'Manager';


--
-- Name: COLUMN hr_employee.coach_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.coach_id IS 'Coach';


--
-- Name: COLUMN hr_employee.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.color IS 'Color Index';


--
-- Name: COLUMN hr_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.name IS 'Employee Name';


--
-- Name: COLUMN hr_employee.work_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_phone IS 'Work Phone';


--
-- Name: COLUMN hr_employee.mobile_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.mobile_phone IS 'Work Mobile';


--
-- Name: COLUMN hr_employee.work_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_email IS 'Work Email';


--
-- Name: COLUMN hr_employee.legal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.legal_name IS 'Legal Name';


--
-- Name: COLUMN hr_employee.private_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_phone IS 'Private Phone';


--
-- Name: COLUMN hr_employee.private_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_email IS 'Private Email';


--
-- Name: COLUMN hr_employee.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.lang IS 'Lang';


--
-- Name: COLUMN hr_employee.place_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.place_of_birth IS 'Place of Birth';


--
-- Name: COLUMN hr_employee.permit_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.permit_no IS 'Work Permit No';


--
-- Name: COLUMN hr_employee.visa_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_no IS 'Visa No';


--
-- Name: COLUMN hr_employee.certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate IS 'Certificate Level';


--
-- Name: COLUMN hr_employee.study_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_field IS 'Field of Study';


--
-- Name: COLUMN hr_employee.study_school; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_school IS 'School';


--
-- Name: COLUMN hr_employee.emergency_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_contact IS 'Emergency Contact';


--
-- Name: COLUMN hr_employee.emergency_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_phone IS 'Emergency Phone';


--
-- Name: COLUMN hr_employee.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.barcode IS 'Badge ID';


--
-- Name: COLUMN hr_employee.pin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.pin IS 'PIN';


--
-- Name: COLUMN hr_employee.private_car_plate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_car_plate IS 'Private Car Plate';


--
-- Name: COLUMN hr_employee.birthday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.birthday IS 'Birthday';


--
-- Name: COLUMN hr_employee.visa_expire; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_expire IS 'Visa Expiration Date';


--
-- Name: COLUMN hr_employee.work_permit_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_expiration_date IS 'Work Permit Expiration Date';


--
-- Name: COLUMN hr_employee.salary_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.salary_distribution IS 'Salary Distribution';


--
-- Name: COLUMN hr_employee.employee_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.employee_properties IS 'Properties';


--
-- Name: COLUMN hr_employee.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.active IS 'Active';


--
-- Name: COLUMN hr_employee.birthday_public_display; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.birthday_public_display IS 'Show to all employees';


--
-- Name: COLUMN hr_employee.work_permit_scheduled_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_scheduled_activity IS 'Work Permit Scheduled Activity';


--
-- Name: COLUMN hr_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_employee.monday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.monday_location_id IS 'Monday';


--
-- Name: COLUMN hr_employee.tuesday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.tuesday_location_id IS 'Tuesday';


--
-- Name: COLUMN hr_employee.wednesday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.wednesday_location_id IS 'Wednesday';


--
-- Name: COLUMN hr_employee.thursday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.thursday_location_id IS 'Thursday';


--
-- Name: COLUMN hr_employee.friday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.friday_location_id IS 'Friday';


--
-- Name: COLUMN hr_employee.saturday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.saturday_location_id IS 'Saturday';


--
-- Name: COLUMN hr_employee.sunday_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.sunday_location_id IS 'Sunday';


--
-- Name: COLUMN hr_employee.today_location_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.today_location_name IS 'Today Location Name';


--
-- Name: COLUMN hr_employee.hourly_cost; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.hourly_cost IS 'Hourly Cost';


--
-- Name: COLUMN hr_employee.timesheet_manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.timesheet_manager_id IS 'Timesheet Approver';


--
-- Name: COLUMN hr_employee.last_validated_timesheet_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.last_validated_timesheet_date IS 'Last Validated Timesheet Date';


--
-- Name: COLUMN hr_employee.billable_time_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.billable_time_target IS 'Billing Time Target';


--
-- Name: CONSTRAINT hr_employee_check_billable_time_target ON hr_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_employee_check_billable_time_target ON public.hr_employee IS 'CHECK(billable_time_target >= 0)';


--
-- Name: hr_version; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_version (
    id integer NOT NULL,
    company_id integer,
    employee_id integer,
    last_modified_uid integer NOT NULL,
    country_id integer,
    private_state_id integer,
    private_country_id integer,
    distance_home_work integer,
    km_home_work integer,
    children integer,
    department_id integer,
    job_id integer,
    address_id integer,
    work_location_id integer,
    departure_reason_id integer,
    resource_calendar_id integer,
    contract_template_id integer,
    structure_type_id integer,
    contract_type_id integer,
    hr_responsible_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    identification_id character varying,
    ssnid character varying,
    passport_id character varying,
    sex character varying,
    private_street character varying,
    private_street2 character varying,
    private_city character varying,
    private_zip character varying,
    distance_home_work_unit character varying NOT NULL,
    marital character varying NOT NULL,
    spouse_complete_name character varying,
    employee_type character varying NOT NULL,
    job_title character varying,
    date_version date NOT NULL,
    passport_expiration_date date,
    spouse_birthdate date,
    departure_date date,
    contract_date_start date,
    contract_date_end date,
    trial_date_end date,
    departure_description text,
    additional_note text,
    wage numeric,
    active boolean,
    is_custom_job_title boolean,
    is_flexible boolean,
    is_fully_flexible boolean,
    last_modified_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_version_check_contract_start_date_defined CHECK (((contract_date_end IS NULL) OR (contract_date_start IS NOT NULL)))
);


ALTER TABLE public.hr_version OWNER TO runbot;

--
-- Name: TABLE hr_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_version IS 'Version';


--
-- Name: COLUMN hr_version.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.company_id IS 'Company';


--
-- Name: COLUMN hr_version.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.employee_id IS 'Employee';


--
-- Name: COLUMN hr_version.last_modified_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.last_modified_uid IS 'Last Modified by';


--
-- Name: COLUMN hr_version.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.country_id IS 'Nationality (Country)';


--
-- Name: COLUMN hr_version.private_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_state_id IS 'Private State';


--
-- Name: COLUMN hr_version.private_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_country_id IS 'Private Country';


--
-- Name: COLUMN hr_version.distance_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.distance_home_work IS 'Home-Work Distance';


--
-- Name: COLUMN hr_version.km_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.km_home_work IS 'Home-Work Distance in Km';


--
-- Name: COLUMN hr_version.children; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.children IS 'Dependent Children';


--
-- Name: COLUMN hr_version.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.department_id IS 'Department';


--
-- Name: COLUMN hr_version.job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.job_id IS 'Job';


--
-- Name: COLUMN hr_version.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.address_id IS 'Work Address';


--
-- Name: COLUMN hr_version.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.work_location_id IS 'Work Location';


--
-- Name: COLUMN hr_version.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_version.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_version.contract_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_template_id IS 'Contract Template';


--
-- Name: COLUMN hr_version.structure_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.structure_type_id IS 'Salary Structure Type';


--
-- Name: COLUMN hr_version.contract_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_type_id IS 'Contract Type';


--
-- Name: COLUMN hr_version.hr_responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.hr_responsible_id IS 'HR Responsible';


--
-- Name: COLUMN hr_version.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.create_uid IS 'Created by';


--
-- Name: COLUMN hr_version.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_version.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.name IS 'Name';


--
-- Name: COLUMN hr_version.identification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.identification_id IS 'Identification No';


--
-- Name: COLUMN hr_version.ssnid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.ssnid IS 'SSN No';


--
-- Name: COLUMN hr_version.passport_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.passport_id IS 'Passport No';


--
-- Name: COLUMN hr_version.sex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.sex IS 'Gender';


--
-- Name: COLUMN hr_version.private_street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_street IS 'Private Street';


--
-- Name: COLUMN hr_version.private_street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_street2 IS 'Private Street2';


--
-- Name: COLUMN hr_version.private_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_city IS 'Private City';


--
-- Name: COLUMN hr_version.private_zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.private_zip IS 'Private Zip';


--
-- Name: COLUMN hr_version.distance_home_work_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.distance_home_work_unit IS 'Home-Work Distance unit';


--
-- Name: COLUMN hr_version.marital; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.marital IS 'Marital Status';


--
-- Name: COLUMN hr_version.spouse_complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.spouse_complete_name IS 'Spouse Legal Name';


--
-- Name: COLUMN hr_version.employee_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.employee_type IS 'Employee Type';


--
-- Name: COLUMN hr_version.job_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.job_title IS 'Job Title';


--
-- Name: COLUMN hr_version.date_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.date_version IS 'Date Version';


--
-- Name: COLUMN hr_version.passport_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.passport_expiration_date IS 'Passport Expiration Date';


--
-- Name: COLUMN hr_version.spouse_birthdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.spouse_birthdate IS 'Spouse Birthdate';


--
-- Name: COLUMN hr_version.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.departure_date IS 'Departure Date';


--
-- Name: COLUMN hr_version.contract_date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_date_start IS 'Contract Start Date';


--
-- Name: COLUMN hr_version.contract_date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.contract_date_end IS 'Contract End Date';


--
-- Name: COLUMN hr_version.trial_date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.trial_date_end IS 'End of Trial Period';


--
-- Name: COLUMN hr_version.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_version.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.additional_note IS 'Additional Note';


--
-- Name: COLUMN hr_version.wage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.wage IS 'Wage';


--
-- Name: COLUMN hr_version.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.active IS 'Active';


--
-- Name: COLUMN hr_version.is_custom_job_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.is_custom_job_title IS 'Is Custom Job Title';


--
-- Name: COLUMN hr_version.is_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.is_flexible IS 'Is Flexible';


--
-- Name: COLUMN hr_version.is_fully_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.is_fully_flexible IS 'Is Fully Flexible';


--
-- Name: COLUMN hr_version.last_modified_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.last_modified_date IS 'Last Modified on';


--
-- Name: COLUMN hr_version.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.create_date IS 'Created on';


--
-- Name: COLUMN hr_version.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_version.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_version_check_contract_start_date_defined ON hr_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_version_check_contract_start_date_defined ON public.hr_version IS 'CHECK(contract_date_end IS NULL OR contract_date_start IS NOT NULL)';


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea,
    social_twitter character varying,
    social_facebook character varying,
    social_github character varying,
    social_linkedin character varying,
    social_youtube character varying,
    social_instagram character varying,
    social_tiktok character varying,
    social_discord character varying,
    resource_calendar_id integer,
    alias_domain_id integer,
    email_primary_color character varying,
    email_secondary_color character varying,
    iap_enrich_auto_done boolean,
    snailmail_color boolean,
    snailmail_cover boolean,
    snailmail_duplex boolean,
    fiscalyear_last_day integer NOT NULL,
    transfer_account_id integer,
    default_cash_difference_income_account_id integer,
    default_cash_difference_expense_account_id integer,
    account_journal_suspense_account_id integer,
    account_journal_early_pay_discount_gain_account_id integer,
    account_journal_early_pay_discount_loss_account_id integer,
    account_sale_tax_id integer,
    account_purchase_tax_id integer,
    account_purchase_receipt_fiscal_position_id integer,
    currency_exchange_journal_id integer,
    income_currency_exchange_account_id integer,
    expense_currency_exchange_account_id integer,
    incoterm_id integer,
    batch_payment_sequence_id integer,
    account_opening_move_id integer,
    account_default_pos_receivable_account_id integer,
    expense_accrual_account_id integer,
    revenue_accrual_account_id integer,
    automatic_entry_default_journal_id integer,
    domestic_fiscal_position_id integer,
    account_fiscal_country_id integer,
    tax_cash_basis_journal_id integer,
    account_cash_basis_base_account_id integer,
    account_discount_income_allocation_id integer,
    account_discount_expense_allocation_id integer,
    income_account_id integer,
    expense_account_id integer,
    price_difference_account_id integer,
    fiscalyear_last_month character varying NOT NULL,
    chart_template character varying,
    bank_account_code_prefix character varying,
    cash_account_code_prefix character varying,
    transfer_account_code_prefix character varying,
    tax_calculation_rounding_method character varying,
    terms_type character varying,
    quick_edit_mode character varying,
    account_price_include character varying NOT NULL,
    fiscalyear_lock_date date,
    tax_lock_date date,
    sale_lock_date date,
    purchase_lock_date date,
    hard_lock_date date,
    account_opening_date date,
    invoice_terms jsonb,
    invoice_terms_html jsonb,
    expects_chart_of_accounts boolean,
    anglo_saxon_accounting boolean,
    qr_code boolean,
    link_qr_code boolean,
    display_invoice_amount_total_words boolean,
    display_invoice_tax_company_currency boolean,
    account_use_credit_limit boolean,
    tax_exigibility boolean,
    account_storno boolean,
    restrictive_audit_trail boolean,
    autopost_bills boolean,
    hr_presence_control_email_amount integer,
    contract_expiration_notice_period integer,
    work_permit_expiration_notice_period integer,
    hr_presence_control_ip_list character varying,
    employee_properties_definition jsonb,
    hr_presence_control_login boolean,
    hr_presence_control_email boolean,
    hr_presence_control_ip boolean,
    hr_presence_control_attendance boolean,
    website_id integer,
    signing_user integer,
    deferred_expense_journal_id integer,
    deferred_expense_account_id integer,
    deferred_revenue_journal_id integer,
    deferred_revenue_account_id integer,
    generate_deferred_expense_entries_method character varying NOT NULL,
    deferred_expense_amount_computation_method character varying NOT NULL,
    generate_deferred_revenue_entries_method character varying NOT NULL,
    deferred_revenue_amount_computation_method character varying NOT NULL,
    invoicing_switch_threshold date,
    predict_bill_product boolean,
    sign_invoice boolean,
    account_check_printing_layout character varying,
    account_check_printing_date_label boolean,
    account_check_printing_multi_stub boolean,
    account_check_printing_margin_top double precision,
    account_check_printing_margin_left double precision,
    account_check_printing_margin_right double precision,
    vat_check_vies boolean,
    currency_interval_unit character varying NOT NULL,
    currency_provider character varying,
    currency_next_execution_date date,
    avalara_api_id character varying,
    avalara_api_key character varying,
    avalara_environment character varying NOT NULL,
    avalara_commit boolean,
    avalara_address_validation boolean,
    avalara_use_upc boolean,
    setting_account_avatax boolean,
    account_return_reminder_day integer NOT NULL,
    account_tax_return_journal_id integer,
    account_revaluation_journal_id integer,
    account_revaluation_expense_provision_account_id integer,
    account_revaluation_income_provision_account_id integer,
    account_representative_id integer,
    account_return_periodicity character varying NOT NULL,
    totals_below_sections boolean,
    account_last_return_cron_refresh timestamp without time zone,
    project_time_mode_id integer,
    timesheet_encode_uom_id integer,
    internal_project_id integer,
    quotation_validity_days integer,
    sale_discount_product_id integer,
    downpayment_account_id integer,
    sale_onboarding_payment_method character varying,
    portal_confirmation_sign boolean,
    portal_confirmation_pay boolean,
    prepayment_percent double precision,
    use_payment_pro boolean,
    reconcile_on_company_currency boolean,
    l10n_ar_afip_start_date date,
    sale_order_template_id integer,
    timesheet_mail_employee_delay integer,
    timesheet_mail_delay integer,
    timesheet_mail_employee_interval character varying NOT NULL,
    timesheet_mail_interval character varying NOT NULL,
    timesheet_mail_employee_allow boolean,
    timesheet_mail_allow boolean,
    timesheet_mail_employee_nextdate timestamp without time zone,
    timesheet_mail_nextdate timestamp without time zone,
    extract_in_invoice_digitalization_mode character varying,
    extract_out_invoice_digitalization_mode character varying,
    extract_single_line_per_tax boolean,
    l10n_ar_afip_ws_key_id integer,
    l10n_ar_afip_ws_crt_id integer,
    l10n_ar_afip_verification_type character varying NOT NULL,
    l10n_ar_afip_ws_environment character varying,
    l10n_ar_fce_transmission_type character varying,
    l10n_ar_show_withholding_legend boolean,
    l10n_ar_computable_tax_credit character varying,
    arba_cit character varying,
    l10n_ar_report_signed_by text,
    l10n_ar_invoice_report_ars_amount boolean,
    l10n_ar_tax_base_account_id integer,
    l10n_ar_last_currency_sync_date date,
    rate_perc numeric,
    rate_surcharge numeric,
    l10n_ar_arca_activity_id integer,
    timesheet_show_rates boolean,
    timesheet_show_leaderboard boolean,
    CONSTRAINT res_company_check_quotation_validity_days CHECK ((quotation_validity_days >= 0))
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.social_twitter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.social_twitter IS 'X Account';


--
-- Name: COLUMN res_company.social_facebook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.social_facebook IS 'Facebook Account';


--
-- Name: COLUMN res_company.social_github; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.social_github IS 'GitHub Account';


--
-- Name: COLUMN res_company.social_linkedin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.social_linkedin IS 'LinkedIn Account';


--
-- Name: COLUMN res_company.social_youtube; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.social_youtube IS 'Youtube Account';


--
-- Name: COLUMN res_company.social_instagram; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.social_instagram IS 'Instagram Account';


--
-- Name: COLUMN res_company.social_tiktok; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.social_tiktok IS 'TikTok Account';


--
-- Name: COLUMN res_company.social_discord; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.social_discord IS 'Discord Account';


--
-- Name: COLUMN res_company.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.resource_calendar_id IS 'Default Working Hours';


--
-- Name: COLUMN res_company.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.alias_domain_id IS 'Email Domain';


--
-- Name: COLUMN res_company.email_primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_primary_color IS 'Email Button Text';


--
-- Name: COLUMN res_company.email_secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_secondary_color IS 'Email Button Color';


--
-- Name: COLUMN res_company.iap_enrich_auto_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.iap_enrich_auto_done IS 'Enrich Done';


--
-- Name: COLUMN res_company.snailmail_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_color IS 'Snailmail Color';


--
-- Name: COLUMN res_company.snailmail_cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN res_company.snailmail_duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_duplex IS 'Both sides';


--
-- Name: COLUMN res_company.fiscalyear_last_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.fiscalyear_last_day IS 'Fiscalyear Last Day';


--
-- Name: COLUMN res_company.transfer_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.transfer_account_id IS 'Inter-Banks Transfer Account';


--
-- Name: COLUMN res_company.default_cash_difference_income_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.default_cash_difference_income_account_id IS 'Cash Difference Income';


--
-- Name: COLUMN res_company.default_cash_difference_expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.default_cash_difference_expense_account_id IS 'Cash Difference Expense';


--
-- Name: COLUMN res_company.account_journal_suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_journal_suspense_account_id IS 'Journal Suspense Account';


--
-- Name: COLUMN res_company.account_journal_early_pay_discount_gain_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_journal_early_pay_discount_gain_account_id IS 'Cash Discount Write-Off Gain Account';


--
-- Name: COLUMN res_company.account_journal_early_pay_discount_loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_journal_early_pay_discount_loss_account_id IS 'Cash Discount Write-Off Loss Account';


--
-- Name: COLUMN res_company.account_sale_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_sale_tax_id IS 'Default Sale Tax';


--
-- Name: COLUMN res_company.account_purchase_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_purchase_tax_id IS 'Default Purchase Tax';


--
-- Name: COLUMN res_company.account_purchase_receipt_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_purchase_receipt_fiscal_position_id IS 'Default Purchase Receipt Fiscal Position';


--
-- Name: COLUMN res_company.currency_exchange_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.currency_exchange_journal_id IS 'Exchange Gain or Loss Journal';


--
-- Name: COLUMN res_company.income_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.income_currency_exchange_account_id IS 'Gain Exchange Rate Account';


--
-- Name: COLUMN res_company.expense_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.expense_currency_exchange_account_id IS 'Loss Exchange Rate Account';


--
-- Name: COLUMN res_company.incoterm_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.incoterm_id IS 'Default incoterm';


--
-- Name: COLUMN res_company.batch_payment_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.batch_payment_sequence_id IS 'Batch Payment Sequence';


--
-- Name: COLUMN res_company.account_opening_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_opening_move_id IS 'Opening Journal Entry';


--
-- Name: COLUMN res_company.account_default_pos_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_default_pos_receivable_account_id IS 'Default PoS Receivable Account';


--
-- Name: COLUMN res_company.expense_accrual_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.expense_accrual_account_id IS 'Expense Accrual Account';


--
-- Name: COLUMN res_company.revenue_accrual_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.revenue_accrual_account_id IS 'Revenue Accrual Account';


--
-- Name: COLUMN res_company.automatic_entry_default_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.automatic_entry_default_journal_id IS 'Automatic Entry Default Journal';


--
-- Name: COLUMN res_company.domestic_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.domestic_fiscal_position_id IS 'Domestic Fiscal Position';


--
-- Name: COLUMN res_company.account_fiscal_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_fiscal_country_id IS 'Fiscal Country';


--
-- Name: COLUMN res_company.tax_cash_basis_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.tax_cash_basis_journal_id IS 'Cash Basis Journal';


--
-- Name: COLUMN res_company.account_cash_basis_base_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_cash_basis_base_account_id IS 'Base Tax Received Account';


--
-- Name: COLUMN res_company.account_discount_income_allocation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_discount_income_allocation_id IS 'Separate account for income discount';


--
-- Name: COLUMN res_company.account_discount_expense_allocation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_discount_expense_allocation_id IS 'Separate account for expense discount';


--
-- Name: COLUMN res_company.income_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.income_account_id IS 'Income Account';


--
-- Name: COLUMN res_company.expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.expense_account_id IS 'Expense Account';


--
-- Name: COLUMN res_company.price_difference_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.price_difference_account_id IS 'Price Difference Account';


--
-- Name: COLUMN res_company.fiscalyear_last_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.fiscalyear_last_month IS 'Fiscalyear Last Month';


--
-- Name: COLUMN res_company.chart_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.chart_template IS 'Chart Template';


--
-- Name: COLUMN res_company.bank_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.bank_account_code_prefix IS 'Prefix of the bank accounts';


--
-- Name: COLUMN res_company.cash_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.cash_account_code_prefix IS 'Prefix of the cash accounts';


--
-- Name: COLUMN res_company.transfer_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.transfer_account_code_prefix IS 'Prefix of the transfer accounts';


--
-- Name: COLUMN res_company.tax_calculation_rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.tax_calculation_rounding_method IS 'Tax Calculation Rounding Method';


--
-- Name: COLUMN res_company.terms_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.terms_type IS 'Terms & Conditions format';


--
-- Name: COLUMN res_company.quick_edit_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.quick_edit_mode IS 'Quick encoding';


--
-- Name: COLUMN res_company.account_price_include; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_price_include IS 'Default Sales Price Include';


--
-- Name: COLUMN res_company.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.fiscalyear_lock_date IS 'Global Lock Date';


--
-- Name: COLUMN res_company.tax_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.tax_lock_date IS 'Tax Return Lock Date';


--
-- Name: COLUMN res_company.sale_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sale_lock_date IS 'Sales Lock Date';


--
-- Name: COLUMN res_company.purchase_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.purchase_lock_date IS 'Purchase Lock date';


--
-- Name: COLUMN res_company.hard_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hard_lock_date IS 'Hard Lock Date';


--
-- Name: COLUMN res_company.account_opening_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_opening_date IS 'Opening Entry';


--
-- Name: COLUMN res_company.invoice_terms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.invoice_terms IS 'Default Terms and Conditions';


--
-- Name: COLUMN res_company.invoice_terms_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.invoice_terms_html IS 'Default Terms and Conditions as a Web page';


--
-- Name: COLUMN res_company.expects_chart_of_accounts; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.expects_chart_of_accounts IS 'Expects a Chart of Accounts';


--
-- Name: COLUMN res_company.anglo_saxon_accounting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.anglo_saxon_accounting IS 'Use anglo-saxon accounting';


--
-- Name: COLUMN res_company.qr_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.qr_code IS 'Display QR-code on invoices';


--
-- Name: COLUMN res_company.link_qr_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.link_qr_code IS 'Display Link QR-code';


--
-- Name: COLUMN res_company.display_invoice_amount_total_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.display_invoice_amount_total_words IS 'Total amount of invoice in letters';


--
-- Name: COLUMN res_company.display_invoice_tax_company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.display_invoice_tax_company_currency IS 'Taxes in company currency';


--
-- Name: COLUMN res_company.account_use_credit_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_use_credit_limit IS 'Sales Credit Limit';


--
-- Name: COLUMN res_company.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.tax_exigibility IS 'Use Cash Basis';


--
-- Name: COLUMN res_company.account_storno; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_storno IS 'Storno accounting';


--
-- Name: COLUMN res_company.restrictive_audit_trail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.restrictive_audit_trail IS 'Restrictive Audit Trail';


--
-- Name: COLUMN res_company.autopost_bills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.autopost_bills IS 'Auto-validate bills';


--
-- Name: COLUMN res_company.hr_presence_control_email_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email_amount IS '# emails to send';


--
-- Name: COLUMN res_company.contract_expiration_notice_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.contract_expiration_notice_period IS 'Contract Expiry Notice Period';


--
-- Name: COLUMN res_company.work_permit_expiration_notice_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.work_permit_expiration_notice_period IS 'Work Permit Expiry Notice Period';


--
-- Name: COLUMN res_company.hr_presence_control_ip_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip_list IS 'Valid IP addresses';


--
-- Name: COLUMN res_company.employee_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.employee_properties_definition IS 'Employee Properties';


--
-- Name: COLUMN res_company.hr_presence_control_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_login IS 'Based on user status in system';


--
-- Name: COLUMN res_company.hr_presence_control_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email IS 'Based on number of emails sent';


--
-- Name: COLUMN res_company.hr_presence_control_ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip IS 'Based on IP Address';


--
-- Name: COLUMN res_company.hr_presence_control_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_attendance IS 'Based on attendances';


--
-- Name: COLUMN res_company.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.website_id IS 'Website';


--
-- Name: COLUMN res_company.signing_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.signing_user IS 'Signing User';


--
-- Name: COLUMN res_company.deferred_expense_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_expense_journal_id IS 'Deferred Expense Journal';


--
-- Name: COLUMN res_company.deferred_expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_expense_account_id IS 'Deferred Expense Account';


--
-- Name: COLUMN res_company.deferred_revenue_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_revenue_journal_id IS 'Deferred Revenue Journal';


--
-- Name: COLUMN res_company.deferred_revenue_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_revenue_account_id IS 'Deferred Revenue Account';


--
-- Name: COLUMN res_company.generate_deferred_expense_entries_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.generate_deferred_expense_entries_method IS 'Generate Deferred Expense Entries';


--
-- Name: COLUMN res_company.deferred_expense_amount_computation_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_expense_amount_computation_method IS 'Deferred Expense Based on';


--
-- Name: COLUMN res_company.generate_deferred_revenue_entries_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.generate_deferred_revenue_entries_method IS 'Generate Deferred Revenue Entries';


--
-- Name: COLUMN res_company.deferred_revenue_amount_computation_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_revenue_amount_computation_method IS 'Deferred Revenue Based on';


--
-- Name: COLUMN res_company.invoicing_switch_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.invoicing_switch_threshold IS 'Invoicing Switch Threshold';


--
-- Name: COLUMN res_company.predict_bill_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.predict_bill_product IS 'Predict Bill Product';


--
-- Name: COLUMN res_company.sign_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sign_invoice IS 'Display signing field on invoices';


--
-- Name: COLUMN res_company.account_check_printing_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_check_printing_layout IS 'Check Layout';


--
-- Name: COLUMN res_company.account_check_printing_date_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_check_printing_date_label IS 'Print Date Label';


--
-- Name: COLUMN res_company.account_check_printing_multi_stub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_check_printing_multi_stub IS 'Multi-Pages Check Stub';


--
-- Name: COLUMN res_company.account_check_printing_margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_check_printing_margin_top IS 'Check Top Margin';


--
-- Name: COLUMN res_company.account_check_printing_margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_check_printing_margin_left IS 'Check Left Margin';


--
-- Name: COLUMN res_company.account_check_printing_margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_check_printing_margin_right IS 'Right Margin';


--
-- Name: COLUMN res_company.vat_check_vies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.vat_check_vies IS 'Verify VAT Numbers';


--
-- Name: COLUMN res_company.currency_interval_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.currency_interval_unit IS 'Interval Unit';


--
-- Name: COLUMN res_company.currency_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.currency_provider IS 'Service Provider';


--
-- Name: COLUMN res_company.currency_next_execution_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.currency_next_execution_date IS 'Next Execution Date';


--
-- Name: COLUMN res_company.avalara_api_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_api_id IS 'Avalara API ID';


--
-- Name: COLUMN res_company.avalara_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_api_key IS 'Avalara API KEY';


--
-- Name: COLUMN res_company.avalara_environment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_environment IS 'Avalara Environment';


--
-- Name: COLUMN res_company.avalara_commit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_commit IS 'Commit in Avatax';


--
-- Name: COLUMN res_company.avalara_address_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_address_validation IS 'Avalara Address Validation';


--
-- Name: COLUMN res_company.avalara_use_upc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_use_upc IS 'Use UPC';


--
-- Name: COLUMN res_company.setting_account_avatax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.setting_account_avatax IS 'Use AvaTax';


--
-- Name: COLUMN res_company.account_return_reminder_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_return_reminder_day IS 'Start from';


--
-- Name: COLUMN res_company.account_tax_return_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_tax_return_journal_id IS 'Journal';


--
-- Name: COLUMN res_company.account_revaluation_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_revaluation_journal_id IS 'Account Revaluation Journal';


--
-- Name: COLUMN res_company.account_revaluation_expense_provision_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_revaluation_expense_provision_account_id IS 'Expense Provision Account';


--
-- Name: COLUMN res_company.account_revaluation_income_provision_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_revaluation_income_provision_account_id IS 'Income Provision Account';


--
-- Name: COLUMN res_company.account_representative_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_representative_id IS 'Accounting Firm';


--
-- Name: COLUMN res_company.account_return_periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_return_periodicity IS 'Delay units';


--
-- Name: COLUMN res_company.totals_below_sections; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.totals_below_sections IS 'Add totals below sections';


--
-- Name: COLUMN res_company.account_last_return_cron_refresh; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_last_return_cron_refresh IS 'Account Last Return Cron Refresh';


--
-- Name: COLUMN res_company.project_time_mode_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.project_time_mode_id IS 'Project Time Unit';


--
-- Name: COLUMN res_company.timesheet_encode_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_encode_uom_id IS 'Timesheet Encoding Unit';


--
-- Name: COLUMN res_company.internal_project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.internal_project_id IS 'Internal Project';


--
-- Name: COLUMN res_company.quotation_validity_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.quotation_validity_days IS 'Default Quotation Validity';


--
-- Name: COLUMN res_company.sale_discount_product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sale_discount_product_id IS 'Discount Product';


--
-- Name: COLUMN res_company.downpayment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.downpayment_account_id IS 'Downpayment Account';


--
-- Name: COLUMN res_company.sale_onboarding_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sale_onboarding_payment_method IS 'Sale onboarding selected payment method';


--
-- Name: COLUMN res_company.portal_confirmation_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.portal_confirmation_sign IS 'Online Signature';


--
-- Name: COLUMN res_company.portal_confirmation_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.portal_confirmation_pay IS 'Online Payment';


--
-- Name: COLUMN res_company.prepayment_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.prepayment_percent IS 'Prepayment percentage';


--
-- Name: COLUMN res_company.use_payment_pro; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.use_payment_pro IS 'Use Payment Pro';


--
-- Name: COLUMN res_company.reconcile_on_company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.reconcile_on_company_currency IS 'Reconcile On Company Currency';


--
-- Name: COLUMN res_company.l10n_ar_afip_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_start_date IS 'Activities Start';


--
-- Name: COLUMN res_company.sale_order_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sale_order_template_id IS 'Default Sale Template';


--
-- Name: COLUMN res_company.timesheet_mail_employee_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_delay IS 'Employee Reminder Days';


--
-- Name: COLUMN res_company.timesheet_mail_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_delay IS 'Approver Reminder Days';


--
-- Name: COLUMN res_company.timesheet_mail_employee_interval; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_interval IS 'Employee Frequency';


--
-- Name: COLUMN res_company.timesheet_mail_interval; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_interval IS 'Approver Reminder Frequency';


--
-- Name: COLUMN res_company.timesheet_mail_employee_allow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_allow IS 'Employee Reminder';


--
-- Name: COLUMN res_company.timesheet_mail_allow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_allow IS 'Approver Reminder';


--
-- Name: COLUMN res_company.timesheet_mail_employee_nextdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_employee_nextdate IS 'Next scheduled date for employee reminder';


--
-- Name: COLUMN res_company.timesheet_mail_nextdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_mail_nextdate IS 'Next scheduled date for approver reminder';


--
-- Name: COLUMN res_company.extract_in_invoice_digitalization_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.extract_in_invoice_digitalization_mode IS 'Digitization mode on vendor bills';


--
-- Name: COLUMN res_company.extract_out_invoice_digitalization_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.extract_out_invoice_digitalization_mode IS 'Digitization mode on customer invoices';


--
-- Name: COLUMN res_company.extract_single_line_per_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.extract_single_line_per_tax IS 'Single Invoice Line Per Tax';


--
-- Name: COLUMN res_company.l10n_ar_afip_ws_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_ws_key_id IS 'Private Key';


--
-- Name: COLUMN res_company.l10n_ar_afip_ws_crt_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_ws_crt_id IS 'ARCA Certificate';


--
-- Name: COLUMN res_company.l10n_ar_afip_verification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_verification_type IS 'ARCA Invoice Verification';


--
-- Name: COLUMN res_company.l10n_ar_afip_ws_environment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_ws_environment IS 'ARCA Environment';


--
-- Name: COLUMN res_company.l10n_ar_fce_transmission_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_fce_transmission_type IS 'FCE: Transmission Option Default';


--
-- Name: COLUMN res_company.l10n_ar_show_withholding_legend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_show_withholding_legend IS 'Show Withholding Legend';


--
-- Name: COLUMN res_company.l10n_ar_computable_tax_credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_computable_tax_credit IS 'Computable Tax Credit: Prorate Options';


--
-- Name: COLUMN res_company.arba_cit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.arba_cit IS 'CIT ARBA';


--
-- Name: COLUMN res_company.l10n_ar_report_signed_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_report_signed_by IS 'Aclaracion';


--
-- Name: COLUMN res_company.l10n_ar_invoice_report_ars_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_invoice_report_ars_amount IS 'Mostrar importe equivalente en ARS';


--
-- Name: COLUMN res_company.l10n_ar_tax_base_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_tax_base_account_id IS 'Tax Base Account';


--
-- Name: COLUMN res_company.l10n_ar_last_currency_sync_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_last_currency_sync_date IS 'ARCA Last Sync Date';


--
-- Name: COLUMN res_company.rate_perc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.rate_perc IS 'Rate Perc';


--
-- Name: COLUMN res_company.rate_surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.rate_surcharge IS 'Rate Surcharge';


--
-- Name: COLUMN res_company.l10n_ar_arca_activity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_arca_activity_id IS 'Principal Activity';


--
-- Name: COLUMN res_company.timesheet_show_rates; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_show_rates IS 'Timesheet Show Rates';


--
-- Name: COLUMN res_company.timesheet_show_leaderboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.timesheet_show_leaderboard IS 'Timesheet Show Leaderboard';


--
-- Name: CONSTRAINT res_company_check_quotation_validity_days ON res_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_company_check_quotation_validity_days ON public.res_company IS 'CHECK(quotation_validity_days >= 0)';


--
-- Name: edit_billable_time_target; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.edit_billable_time_target AS
 SELECT e.id,
    e.name,
    v.employee_id,
    v.create_date,
    v.resource_calendar_id,
    e.billable_time_target,
    v.company_id,
    v.department_id,
    v.job_id,
    e.parent_id,
    v.address_id,
    v.work_location_id,
    e.timesheet_manager_id,
    e.work_email,
    e.work_phone,
    e.mobile_phone,
    e.user_id,
    e.coach_id,
    v.active,
    v.create_uid,
    v.write_uid,
    v.write_date
   FROM ((public.hr_employee e
     JOIN ( SELECT DISTINCT ON (hr_version.employee_id) hr_version.id,
            hr_version.company_id,
            hr_version.employee_id,
            hr_version.last_modified_uid,
            hr_version.country_id,
            hr_version.private_state_id,
            hr_version.private_country_id,
            hr_version.distance_home_work,
            hr_version.km_home_work,
            hr_version.children,
            hr_version.department_id,
            hr_version.job_id,
            hr_version.address_id,
            hr_version.work_location_id,
            hr_version.departure_reason_id,
            hr_version.resource_calendar_id,
            hr_version.contract_template_id,
            hr_version.structure_type_id,
            hr_version.contract_type_id,
            hr_version.hr_responsible_id,
            hr_version.create_uid,
            hr_version.write_uid,
            hr_version.name,
            hr_version.identification_id,
            hr_version.ssnid,
            hr_version.passport_id,
            hr_version.sex,
            hr_version.private_street,
            hr_version.private_street2,
            hr_version.private_city,
            hr_version.private_zip,
            hr_version.distance_home_work_unit,
            hr_version.marital,
            hr_version.spouse_complete_name,
            hr_version.employee_type,
            hr_version.job_title,
            hr_version.date_version,
            hr_version.passport_expiration_date,
            hr_version.spouse_birthdate,
            hr_version.departure_date,
            hr_version.contract_date_start,
            hr_version.contract_date_end,
            hr_version.trial_date_end,
            hr_version.departure_description,
            hr_version.additional_note,
            hr_version.wage,
            hr_version.active,
            hr_version.is_custom_job_title,
            hr_version.is_flexible,
            hr_version.is_fully_flexible,
            hr_version.last_modified_date,
            hr_version.create_date,
            hr_version.write_date
           FROM public.hr_version
          ORDER BY hr_version.employee_id, hr_version.date_version DESC) v ON ((v.employee_id = e.id)))
     JOIN public.res_company company ON ((e.company_id = company.id)))
  WHERE (company.timesheet_show_rates IS TRUE);


ALTER VIEW public.edit_billable_time_target OWNER TO runbot;

--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: employee_bank_account_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.employee_bank_account_rel (
    employee_id integer NOT NULL,
    bank_account_id integer NOT NULL
);


ALTER TABLE public.employee_bank_account_rel OWNER TO runbot;

--
-- Name: TABLE employee_bank_account_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.employee_bank_account_rel IS 'RELATION BETWEEN hr_employee AND res_partner_bank';


--
-- Name: employee_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.employee_category_rel (
    employee_id integer NOT NULL,
    category_id integer NOT NULL
);


ALTER TABLE public.employee_category_rel OWNER TO runbot;

--
-- Name: TABLE employee_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.employee_category_rel IS 'RELATION BETWEEN hr_employee AND hr_employee_category';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    error_message text,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    error_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    microsoft_outlook_access_token_expiration integer,
    microsoft_outlook_refresh_token character varying,
    microsoft_outlook_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_message IS 'Last Error Message';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.error_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_date IS 'Last Error Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token_expiration IS 'Outlook Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_refresh_token IS 'Outlook Refresh Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token IS 'Outlook Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: gamification_badge; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_badge (
    id integer NOT NULL,
    rule_max_number integer,
    create_uid integer,
    write_uid integer,
    level character varying,
    rule_auth character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    rule_max boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    survey_id integer
);


ALTER TABLE public.gamification_badge OWNER TO runbot;

--
-- Name: TABLE gamification_badge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_badge IS 'Gamification Badge';


--
-- Name: COLUMN gamification_badge.rule_max_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.rule_max_number IS 'Limitation Number';


--
-- Name: COLUMN gamification_badge.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_badge.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_badge.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.level IS 'Forum Badge Level';


--
-- Name: COLUMN gamification_badge.rule_auth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.rule_auth IS 'Allowance to Grant';


--
-- Name: COLUMN gamification_badge.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.name IS 'Badge';


--
-- Name: COLUMN gamification_badge.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.description IS 'Description';


--
-- Name: COLUMN gamification_badge.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.active IS 'Active';


--
-- Name: COLUMN gamification_badge.rule_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.rule_max IS 'Monthly Limited Sending';


--
-- Name: COLUMN gamification_badge.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.create_date IS 'Created on';


--
-- Name: COLUMN gamification_badge.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_badge.survey_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge.survey_id IS 'Survey';


--
-- Name: gamification_badge_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_badge_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_badge_id_seq OWNER TO runbot;

--
-- Name: gamification_badge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_badge_id_seq OWNED BY public.gamification_badge.id;


--
-- Name: gamification_badge_rule_badge_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_badge_rule_badge_rel (
    badge1_id integer NOT NULL,
    badge2_id integer NOT NULL
);


ALTER TABLE public.gamification_badge_rule_badge_rel OWNER TO runbot;

--
-- Name: TABLE gamification_badge_rule_badge_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_badge_rule_badge_rel IS 'RELATION BETWEEN gamification_badge AND gamification_badge';


--
-- Name: gamification_badge_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_badge_user (
    id integer NOT NULL,
    user_id integer NOT NULL,
    sender_id integer,
    badge_id integer NOT NULL,
    challenge_id integer,
    create_uid integer,
    write_uid integer,
    level character varying,
    comment text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    employee_id integer
);


ALTER TABLE public.gamification_badge_user OWNER TO runbot;

--
-- Name: TABLE gamification_badge_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_badge_user IS 'Gamification User Badge';


--
-- Name: COLUMN gamification_badge_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.user_id IS 'User';


--
-- Name: COLUMN gamification_badge_user.sender_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.sender_id IS 'Sender';


--
-- Name: COLUMN gamification_badge_user.badge_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.badge_id IS 'Badge';


--
-- Name: COLUMN gamification_badge_user.challenge_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.challenge_id IS 'Challenge';


--
-- Name: COLUMN gamification_badge_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_badge_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_badge_user.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.level IS 'Badge Level';


--
-- Name: COLUMN gamification_badge_user.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.comment IS 'Comment';


--
-- Name: COLUMN gamification_badge_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.create_date IS 'Created on';


--
-- Name: COLUMN gamification_badge_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_badge_user.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user.employee_id IS 'Employee';


--
-- Name: gamification_badge_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_badge_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_badge_user_id_seq OWNER TO runbot;

--
-- Name: gamification_badge_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_badge_user_id_seq OWNED BY public.gamification_badge_user.id;


--
-- Name: gamification_badge_user_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_badge_user_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    badge_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    comment text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    employee_id integer
);


ALTER TABLE public.gamification_badge_user_wizard OWNER TO runbot;

--
-- Name: TABLE gamification_badge_user_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_badge_user_wizard IS 'Gamification User Badge Wizard';


--
-- Name: COLUMN gamification_badge_user_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.user_id IS 'User';


--
-- Name: COLUMN gamification_badge_user_wizard.badge_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.badge_id IS 'Badge';


--
-- Name: COLUMN gamification_badge_user_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_badge_user_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_badge_user_wizard.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.comment IS 'Comment';


--
-- Name: COLUMN gamification_badge_user_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.create_date IS 'Created on';


--
-- Name: COLUMN gamification_badge_user_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_badge_user_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_badge_user_wizard.employee_id IS 'Employee';


--
-- Name: gamification_badge_user_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_badge_user_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_badge_user_wizard_id_seq OWNER TO runbot;

--
-- Name: gamification_badge_user_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_badge_user_wizard_id_seq OWNED BY public.gamification_badge_user_wizard.id;


--
-- Name: gamification_challenge; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_challenge (
    id integer NOT NULL,
    manager_id integer,
    reward_id integer,
    reward_first_id integer,
    reward_second_id integer,
    reward_third_id integer,
    report_message_group_id integer,
    report_template_id integer NOT NULL,
    remind_update_delay integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    user_domain character varying,
    period character varying NOT NULL,
    visibility_mode character varying NOT NULL,
    report_message_frequency character varying NOT NULL,
    challenge_category character varying NOT NULL,
    start_date date,
    end_date date,
    last_report_date date,
    next_report_date date,
    name jsonb NOT NULL,
    description jsonb,
    reward_failure boolean,
    reward_realtime boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.gamification_challenge OWNER TO runbot;

--
-- Name: TABLE gamification_challenge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_challenge IS 'Gamification Challenge';


--
-- Name: COLUMN gamification_challenge.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.manager_id IS 'Responsible';


--
-- Name: COLUMN gamification_challenge.reward_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.reward_id IS 'For Every Succeeding User';


--
-- Name: COLUMN gamification_challenge.reward_first_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.reward_first_id IS 'For 1st user';


--
-- Name: COLUMN gamification_challenge.reward_second_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.reward_second_id IS 'For 2nd user';


--
-- Name: COLUMN gamification_challenge.reward_third_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.reward_third_id IS 'For 3rd user';


--
-- Name: COLUMN gamification_challenge.report_message_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.report_message_group_id IS 'Send a copy to';


--
-- Name: COLUMN gamification_challenge.report_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.report_template_id IS 'Report Template';


--
-- Name: COLUMN gamification_challenge.remind_update_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.remind_update_delay IS 'Non-updated manual goals will be reminded after';


--
-- Name: COLUMN gamification_challenge.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_challenge.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_challenge.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.state IS 'State';


--
-- Name: COLUMN gamification_challenge.user_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.user_domain IS 'User domain';


--
-- Name: COLUMN gamification_challenge.period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.period IS 'Periodicity';


--
-- Name: COLUMN gamification_challenge.visibility_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.visibility_mode IS 'Display Mode';


--
-- Name: COLUMN gamification_challenge.report_message_frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.report_message_frequency IS 'Report Frequency';


--
-- Name: COLUMN gamification_challenge.challenge_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.challenge_category IS 'Appears in';


--
-- Name: COLUMN gamification_challenge.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.start_date IS 'Start Date';


--
-- Name: COLUMN gamification_challenge.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.end_date IS 'End Date';


--
-- Name: COLUMN gamification_challenge.last_report_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.last_report_date IS 'Last Report Date';


--
-- Name: COLUMN gamification_challenge.next_report_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.next_report_date IS 'Next Report Date';


--
-- Name: COLUMN gamification_challenge.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.name IS 'Challenge Name';


--
-- Name: COLUMN gamification_challenge.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.description IS 'Description';


--
-- Name: COLUMN gamification_challenge.reward_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.reward_failure IS 'Reward Bests if not Succeeded?';


--
-- Name: COLUMN gamification_challenge.reward_realtime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.reward_realtime IS 'Reward as soon as every goal is reached';


--
-- Name: COLUMN gamification_challenge.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.create_date IS 'Created on';


--
-- Name: COLUMN gamification_challenge.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge.write_date IS 'Last Updated on';


--
-- Name: gamification_challenge_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_challenge_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_challenge_id_seq OWNER TO runbot;

--
-- Name: gamification_challenge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_challenge_id_seq OWNED BY public.gamification_challenge.id;


--
-- Name: gamification_challenge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_challenge_line (
    id integer NOT NULL,
    challenge_id integer NOT NULL,
    definition_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    target_goal double precision NOT NULL
);


ALTER TABLE public.gamification_challenge_line OWNER TO runbot;

--
-- Name: TABLE gamification_challenge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_challenge_line IS 'Gamification generic goal for challenge';


--
-- Name: COLUMN gamification_challenge_line.challenge_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge_line.challenge_id IS 'Challenge';


--
-- Name: COLUMN gamification_challenge_line.definition_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge_line.definition_id IS 'Goal Definition';


--
-- Name: COLUMN gamification_challenge_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge_line.sequence IS 'Sequence';


--
-- Name: COLUMN gamification_challenge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge_line.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_challenge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_challenge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge_line.create_date IS 'Created on';


--
-- Name: COLUMN gamification_challenge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_challenge_line.target_goal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_challenge_line.target_goal IS 'Target Value to Reach';


--
-- Name: gamification_challenge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_challenge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_challenge_line_id_seq OWNER TO runbot;

--
-- Name: gamification_challenge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_challenge_line_id_seq OWNED BY public.gamification_challenge_line.id;


--
-- Name: gamification_challenge_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_challenge_users_rel (
    gamification_challenge_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.gamification_challenge_users_rel OWNER TO runbot;

--
-- Name: TABLE gamification_challenge_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_challenge_users_rel IS 'RELATION BETWEEN gamification_challenge AND res_users';


--
-- Name: gamification_goal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_goal (
    id integer NOT NULL,
    definition_id integer NOT NULL,
    user_id integer NOT NULL,
    line_id integer,
    challenge_id integer,
    remind_update_delay integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    start_date date,
    end_date date,
    last_update date,
    to_update boolean,
    closed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    target_goal double precision NOT NULL,
    current double precision NOT NULL
);


ALTER TABLE public.gamification_goal OWNER TO runbot;

--
-- Name: TABLE gamification_goal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_goal IS 'Gamification Goal';


--
-- Name: COLUMN gamification_goal.definition_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.definition_id IS 'Goal Definition';


--
-- Name: COLUMN gamification_goal.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.user_id IS 'User';


--
-- Name: COLUMN gamification_goal.line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.line_id IS 'Challenge Line';


--
-- Name: COLUMN gamification_goal.challenge_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.challenge_id IS 'Challenge';


--
-- Name: COLUMN gamification_goal.remind_update_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.remind_update_delay IS 'Remind delay';


--
-- Name: COLUMN gamification_goal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_goal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_goal.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.state IS 'State';


--
-- Name: COLUMN gamification_goal.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.start_date IS 'Start Date';


--
-- Name: COLUMN gamification_goal.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.end_date IS 'End Date';


--
-- Name: COLUMN gamification_goal.last_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.last_update IS 'Last Update';


--
-- Name: COLUMN gamification_goal.to_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.to_update IS 'To update';


--
-- Name: COLUMN gamification_goal.closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.closed IS 'Closed goal';


--
-- Name: COLUMN gamification_goal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.create_date IS 'Created on';


--
-- Name: COLUMN gamification_goal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_goal.target_goal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.target_goal IS 'To Reach';


--
-- Name: COLUMN gamification_goal.current; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal.current IS 'Current Value';


--
-- Name: gamification_goal_definition; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_goal_definition (
    id integer NOT NULL,
    model_id integer,
    field_id integer,
    field_date_id integer,
    batch_distinctive_field integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    computation_mode character varying NOT NULL,
    display_mode character varying NOT NULL,
    domain character varying NOT NULL,
    batch_user_expression character varying,
    condition character varying NOT NULL,
    res_id_field character varying,
    name jsonb NOT NULL,
    suffix jsonb,
    description text,
    compute_code text,
    monetary boolean,
    batch_mode boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.gamification_goal_definition OWNER TO runbot;

--
-- Name: TABLE gamification_goal_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_goal_definition IS 'Gamification Goal Definition';


--
-- Name: COLUMN gamification_goal_definition.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.model_id IS 'Model';


--
-- Name: COLUMN gamification_goal_definition.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.field_id IS 'Field to Sum';


--
-- Name: COLUMN gamification_goal_definition.field_date_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.field_date_id IS 'Date Field';


--
-- Name: COLUMN gamification_goal_definition.batch_distinctive_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.batch_distinctive_field IS 'Distinctive field for batch user';


--
-- Name: COLUMN gamification_goal_definition.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.action_id IS 'Action';


--
-- Name: COLUMN gamification_goal_definition.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_goal_definition.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_goal_definition.computation_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.computation_mode IS 'Computation Mode';


--
-- Name: COLUMN gamification_goal_definition.display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.display_mode IS 'Displayed as';


--
-- Name: COLUMN gamification_goal_definition.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.domain IS 'Filter Domain';


--
-- Name: COLUMN gamification_goal_definition.batch_user_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.batch_user_expression IS 'Evaluated expression for batch mode';


--
-- Name: COLUMN gamification_goal_definition.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.condition IS 'Goal Performance';


--
-- Name: COLUMN gamification_goal_definition.res_id_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.res_id_field IS 'ID Field of user';


--
-- Name: COLUMN gamification_goal_definition.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.name IS 'Goal Definition';


--
-- Name: COLUMN gamification_goal_definition.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.suffix IS 'Suffix';


--
-- Name: COLUMN gamification_goal_definition.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.description IS 'Goal Description';


--
-- Name: COLUMN gamification_goal_definition.compute_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.compute_code IS 'Python Code';


--
-- Name: COLUMN gamification_goal_definition.monetary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.monetary IS 'Monetary Value';


--
-- Name: COLUMN gamification_goal_definition.batch_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.batch_mode IS 'Batch Mode';


--
-- Name: COLUMN gamification_goal_definition.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.create_date IS 'Created on';


--
-- Name: COLUMN gamification_goal_definition.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_definition.write_date IS 'Last Updated on';


--
-- Name: gamification_goal_definition_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_goal_definition_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_goal_definition_id_seq OWNER TO runbot;

--
-- Name: gamification_goal_definition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_goal_definition_id_seq OWNED BY public.gamification_goal_definition.id;


--
-- Name: gamification_goal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_goal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_goal_id_seq OWNER TO runbot;

--
-- Name: gamification_goal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_goal_id_seq OWNED BY public.gamification_goal.id;


--
-- Name: gamification_goal_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_goal_wizard (
    id integer NOT NULL,
    goal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    current double precision
);


ALTER TABLE public.gamification_goal_wizard OWNER TO runbot;

--
-- Name: TABLE gamification_goal_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_goal_wizard IS 'Gamification Goal Wizard';


--
-- Name: COLUMN gamification_goal_wizard.goal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_wizard.goal_id IS 'Goal';


--
-- Name: COLUMN gamification_goal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_goal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_goal_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN gamification_goal_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN gamification_goal_wizard.current; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_goal_wizard.current IS 'Current';


--
-- Name: gamification_goal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_goal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_goal_wizard_id_seq OWNER TO runbot;

--
-- Name: gamification_goal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_goal_wizard_id_seq OWNED BY public.gamification_goal_wizard.id;


--
-- Name: gamification_invited_user_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_invited_user_ids_rel (
    gamification_challenge_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.gamification_invited_user_ids_rel OWNER TO runbot;

--
-- Name: TABLE gamification_invited_user_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_invited_user_ids_rel IS 'RELATION BETWEEN gamification_challenge AND res_users';


--
-- Name: gamification_karma_rank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_karma_rank (
    id integer NOT NULL,
    karma_min integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    description_motivational jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT gamification_karma_rank_karma_min_check CHECK ((karma_min > 0))
);


ALTER TABLE public.gamification_karma_rank OWNER TO runbot;

--
-- Name: TABLE gamification_karma_rank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_karma_rank IS 'Rank based on karma';


--
-- Name: COLUMN gamification_karma_rank.karma_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_rank.karma_min IS 'Required Karma';


--
-- Name: COLUMN gamification_karma_rank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_rank.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_karma_rank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_rank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_karma_rank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_rank.name IS 'Rank Name';


--
-- Name: COLUMN gamification_karma_rank.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_rank.description IS 'Description';


--
-- Name: COLUMN gamification_karma_rank.description_motivational; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_rank.description_motivational IS 'Motivational';


--
-- Name: COLUMN gamification_karma_rank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_rank.create_date IS 'Created on';


--
-- Name: COLUMN gamification_karma_rank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_rank.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT gamification_karma_rank_karma_min_check ON gamification_karma_rank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT gamification_karma_rank_karma_min_check ON public.gamification_karma_rank IS 'CHECK( karma_min > 0 )';


--
-- Name: gamification_karma_rank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_karma_rank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_karma_rank_id_seq OWNER TO runbot;

--
-- Name: gamification_karma_rank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_karma_rank_id_seq OWNED BY public.gamification_karma_rank.id;


--
-- Name: gamification_karma_tracking; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.gamification_karma_tracking (
    id integer NOT NULL,
    user_id integer NOT NULL,
    old_value integer,
    new_value integer NOT NULL,
    create_uid integer,
    write_uid integer,
    origin_ref character varying,
    origin_ref_model_name character varying,
    reason text,
    consolidated boolean,
    tracking_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.gamification_karma_tracking OWNER TO runbot;

--
-- Name: TABLE gamification_karma_tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.gamification_karma_tracking IS 'Track Karma Changes';


--
-- Name: COLUMN gamification_karma_tracking.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.user_id IS 'User';


--
-- Name: COLUMN gamification_karma_tracking.old_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.old_value IS 'Old Karma Value';


--
-- Name: COLUMN gamification_karma_tracking.new_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.new_value IS 'New Karma Value';


--
-- Name: COLUMN gamification_karma_tracking.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.create_uid IS 'Created by';


--
-- Name: COLUMN gamification_karma_tracking.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.write_uid IS 'Last Updated by';


--
-- Name: COLUMN gamification_karma_tracking.origin_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.origin_ref IS 'Source';


--
-- Name: COLUMN gamification_karma_tracking.origin_ref_model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.origin_ref_model_name IS 'Source Type';


--
-- Name: COLUMN gamification_karma_tracking.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.reason IS 'Description';


--
-- Name: COLUMN gamification_karma_tracking.consolidated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.consolidated IS 'Consolidated';


--
-- Name: COLUMN gamification_karma_tracking.tracking_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.tracking_date IS 'Tracking Date';


--
-- Name: COLUMN gamification_karma_tracking.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.create_date IS 'Created on';


--
-- Name: COLUMN gamification_karma_tracking.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.gamification_karma_tracking.write_date IS 'Last Updated on';


--
-- Name: gamification_karma_tracking_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.gamification_karma_tracking_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.gamification_karma_tracking_id_seq OWNER TO runbot;

--
-- Name: gamification_karma_tracking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.gamification_karma_tracking_id_seq OWNED BY public.gamification_karma_tracking.id;


--
-- Name: github_rate_limit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.github_rate_limit (
    id integer NOT NULL,
    "limit" integer,
    remaining integer,
    create_uid integer,
    write_uid integer,
    reset_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.github_rate_limit OWNER TO runbot;

--
-- Name: TABLE github_rate_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.github_rate_limit IS 'github rate limit wizard';


--
-- Name: COLUMN github_rate_limit."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.github_rate_limit."limit" IS 'limit';


--
-- Name: COLUMN github_rate_limit.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.github_rate_limit.remaining IS 'remaining';


--
-- Name: COLUMN github_rate_limit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.github_rate_limit.create_uid IS 'Created by';


--
-- Name: COLUMN github_rate_limit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.github_rate_limit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN github_rate_limit.reset_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.github_rate_limit.reset_date IS 'reset';


--
-- Name: COLUMN github_rate_limit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.github_rate_limit.create_date IS 'Created on';


--
-- Name: COLUMN github_rate_limit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.github_rate_limit.write_date IS 'Last Updated on';


--
-- Name: github_rate_limit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.github_rate_limit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.github_rate_limit_id_seq OWNER TO runbot;

--
-- Name: github_rate_limit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.github_rate_limit_id_seq OWNED BY public.github_rate_limit.id;


--
-- Name: header_footer_quotation_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.header_footer_quotation_template_rel (
    quotation_document_id integer NOT NULL,
    sale_order_template_id integer NOT NULL
);


ALTER TABLE public.header_footer_quotation_template_rel OWNER TO runbot;

--
-- Name: TABLE header_footer_quotation_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.header_footer_quotation_template_rel IS 'RELATION BETWEEN quotation_document AND sale_order_template';


--
-- Name: helm_app_version; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helm_app_version (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    repository character varying NOT NULL,
    app_name character varying NOT NULL,
    version character varying NOT NULL,
    helm_properties_definition jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helm_app_version OWNER TO runbot;

--
-- Name: TABLE helm_app_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helm_app_version IS 'Helm App Version';


--
-- Name: COLUMN helm_app_version.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.sequence IS 'Sequence';


--
-- Name: COLUMN helm_app_version.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.create_uid IS 'Created by';


--
-- Name: COLUMN helm_app_version.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helm_app_version.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.name IS 'Name';


--
-- Name: COLUMN helm_app_version.repository; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.repository IS 'Repository';


--
-- Name: COLUMN helm_app_version.app_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.app_name IS 'App Name';


--
-- Name: COLUMN helm_app_version.version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.version IS 'Version';


--
-- Name: COLUMN helm_app_version.helm_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.helm_properties_definition IS 'Helm Properties Definition';


--
-- Name: COLUMN helm_app_version.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.active IS 'Active';


--
-- Name: COLUMN helm_app_version.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.create_date IS 'Created on';


--
-- Name: COLUMN helm_app_version.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version.write_date IS 'Last Updated on';


--
-- Name: helm_app_version_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helm_app_version_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helm_app_version_id_seq OWNER TO runbot;

--
-- Name: helm_app_version_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helm_app_version_id_seq OWNED BY public.helm_app_version.id;


--
-- Name: helm_app_version_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helm_app_version_value (
    id integer NOT NULL,
    app_version_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    more_info jsonb,
    value text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helm_app_version_value OWNER TO runbot;

--
-- Name: TABLE helm_app_version_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helm_app_version_value IS 'Helm App Version Value';


--
-- Name: COLUMN helm_app_version_value.app_version_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version_value.app_version_id IS 'App Version';


--
-- Name: COLUMN helm_app_version_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version_value.create_uid IS 'Created by';


--
-- Name: COLUMN helm_app_version_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helm_app_version_value.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version_value.key IS 'Key';


--
-- Name: COLUMN helm_app_version_value.more_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version_value.more_info IS 'More Info';


--
-- Name: COLUMN helm_app_version_value.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version_value.value IS 'Value';


--
-- Name: COLUMN helm_app_version_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version_value.create_date IS 'Created on';


--
-- Name: COLUMN helm_app_version_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helm_app_version_value.write_date IS 'Last Updated on';


--
-- Name: helm_app_version_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helm_app_version_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helm_app_version_value_id_seq OWNER TO runbot;

--
-- Name: helm_app_version_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helm_app_version_value_id_seq OWNED BY public.helm_app_version_value.id;


--
-- Name: helpdesk_sla; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla (
    id integer NOT NULL,
    team_id integer NOT NULL,
    stage_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    priority character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "time" double precision NOT NULL
);


ALTER TABLE public.helpdesk_sla OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla IS 'Helpdesk SLA Policies';


--
-- Name: COLUMN helpdesk_sla.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.team_id IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_sla.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.stage_id IS 'Target Stage';


--
-- Name: COLUMN helpdesk_sla.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_sla.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_sla.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_sla.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.priority IS 'Priority';


--
-- Name: COLUMN helpdesk_sla.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.name IS 'Name';


--
-- Name: COLUMN helpdesk_sla.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.description IS 'SLA Policy Description';


--
-- Name: COLUMN helpdesk_sla.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.active IS 'Active';


--
-- Name: COLUMN helpdesk_sla.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_sla.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_sla."time"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla."time" IS 'Within';


--
-- Name: helpdesk_sla_helpdesk_stage_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_helpdesk_stage_rel (
    helpdesk_sla_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_helpdesk_stage_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_helpdesk_stage_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_helpdesk_stage_rel IS 'RELATION BETWEEN helpdesk_sla AND helpdesk_stage';


--
-- Name: helpdesk_sla_helpdesk_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_helpdesk_tag_rel (
    helpdesk_sla_id integer NOT NULL,
    helpdesk_tag_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_helpdesk_tag_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_helpdesk_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_helpdesk_tag_rel IS 'RELATION BETWEEN helpdesk_sla AND helpdesk_tag';


--
-- Name: helpdesk_sla_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_sla_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_sla_id_seq OWNER TO runbot;

--
-- Name: helpdesk_sla_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_sla_id_seq OWNED BY public.helpdesk_sla.id;


--
-- Name: helpdesk_sla_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_product_template_rel (
    helpdesk_sla_id integer NOT NULL,
    product_template_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_product_template_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_product_template_rel IS 'RELATION BETWEEN helpdesk_sla AND product_template';


--
-- Name: helpdesk_sla_report_analysis; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.helpdesk_sla_report_analysis AS
SELECT
    NULL::integer AS id,
    NULL::integer AS ticket_id,
    NULL::text AS description,
    NULL::character varying AS ticket_ref,
    NULL::character varying AS name,
    NULL::timestamp without time zone AS create_date,
    NULL::integer AS team_id,
    NULL::boolean AS active,
    NULL::integer AS stage_id,
    NULL::integer AS user_id,
    NULL::integer AS partner_id,
    NULL::character varying AS partner_name,
    NULL::character varying AS partner_email,
    NULL::character varying AS partner_phone,
    NULL::integer AS company_id,
    NULL::character varying AS kanban_state,
    NULL::double precision AS rating_last_value,
    NULL::double precision AS rating_avg,
    NULL::character varying AS priority,
    NULL::double precision AS ticket_close_hours,
    NULL::numeric AS ticket_open_hours,
    NULL::double precision AS ticket_assignation_hours,
    NULL::double precision AS avg_response_hours,
    NULL::double precision AS first_response_hours,
    NULL::timestamp without time zone AS close_date,
    NULL::boolean AS ticket_closed,
    NULL::integer AS sla_stage_id,
    NULL::timestamp without time zone AS sla_deadline,
    NULL::integer AS sla_id,
    NULL::double precision AS sla_exceeded_hours,
    NULL::boolean AS sla_fail,
    NULL::integer AS sla_status_failed,
    NULL::text AS sla_status,
    NULL::boolean AS sla_success,
    NULL::integer AS sale_order_id,
    NULL::integer AS department_id,
    NULL::integer AS manager_id,
    NULL::integer AS employee_id,
    NULL::double precision AS total_hours_spent,
    NULL::double precision AS remaining_hours_so,
    NULL::integer AS sale_line_id;


ALTER VIEW public.helpdesk_sla_report_analysis OWNER TO runbot;

--
-- Name: helpdesk_sla_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_res_partner_rel (
    helpdesk_sla_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_res_partner_rel IS 'RELATION BETWEEN helpdesk_sla AND res_partner';


--
-- Name: helpdesk_sla_status; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_status (
    id integer NOT NULL,
    ticket_id integer NOT NULL,
    sla_id integer NOT NULL,
    sla_stage_id integer,
    create_uid integer,
    write_uid integer,
    deadline timestamp without time zone,
    reached_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    exceeded_hours double precision
);


ALTER TABLE public.helpdesk_sla_status OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_status IS 'Ticket SLA Status';


--
-- Name: COLUMN helpdesk_sla_status.ticket_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.ticket_id IS 'Ticket';


--
-- Name: COLUMN helpdesk_sla_status.sla_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.sla_id IS 'Sla';


--
-- Name: COLUMN helpdesk_sla_status.sla_stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.sla_stage_id IS 'Target Stage';


--
-- Name: COLUMN helpdesk_sla_status.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_sla_status.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_sla_status.deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.deadline IS 'Deadline';


--
-- Name: COLUMN helpdesk_sla_status.reached_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.reached_datetime IS 'Reached Date';


--
-- Name: COLUMN helpdesk_sla_status.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_sla_status.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_sla_status.exceeded_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.exceeded_hours IS 'Exceeded Working Hours';


--
-- Name: helpdesk_sla_status_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_sla_status_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_sla_status_id_seq OWNER TO runbot;

--
-- Name: helpdesk_sla_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_sla_status_id_seq OWNED BY public.helpdesk_sla_status.id;


--
-- Name: helpdesk_solution; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_solution (
    id integer NOT NULL,
    ticket_count integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    internal_solution_description text,
    customer_solution_description text,
    ticket_description text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    adhoc_product_id integer,
    solution_script text
);


ALTER TABLE public.helpdesk_solution OWNER TO runbot;

--
-- Name: TABLE helpdesk_solution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_solution IS 'Helpdesk Solution';


--
-- Name: COLUMN helpdesk_solution.ticket_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.ticket_count IS 'Ticket Count';


--
-- Name: COLUMN helpdesk_solution.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_solution.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_solution.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.name IS 'Name';


--
-- Name: COLUMN helpdesk_solution.internal_solution_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.internal_solution_description IS 'Internal Solution Description';


--
-- Name: COLUMN helpdesk_solution.customer_solution_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.customer_solution_description IS 'Customer Solution Description';


--
-- Name: COLUMN helpdesk_solution.ticket_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.ticket_description IS 'Ticket Description';


--
-- Name: COLUMN helpdesk_solution.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.active IS 'Active';


--
-- Name: COLUMN helpdesk_solution.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_solution.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_solution.adhoc_product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.adhoc_product_id IS 'Adhoc Product';


--
-- Name: COLUMN helpdesk_solution.solution_script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution.solution_script IS 'Solution Script';


--
-- Name: helpdesk_solution_faq_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_solution_faq_category (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_solution_faq_category OWNER TO runbot;

--
-- Name: TABLE helpdesk_solution_faq_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_solution_faq_category IS 'Helpdesk Solution Faq Category';


--
-- Name: COLUMN helpdesk_solution_faq_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_faq_category.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_solution_faq_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_faq_category.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_solution_faq_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_faq_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_solution_faq_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_faq_category.name IS 'Name';


--
-- Name: COLUMN helpdesk_solution_faq_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_faq_category.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_solution_faq_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_faq_category.write_date IS 'Last Updated on';


--
-- Name: helpdesk_solution_faq_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_solution_faq_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_solution_faq_category_id_seq OWNER TO runbot;

--
-- Name: helpdesk_solution_faq_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_solution_faq_category_id_seq OWNED BY public.helpdesk_solution_faq_category.id;


--
-- Name: helpdesk_solution_helpdesk_solution_faq_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_solution_helpdesk_solution_faq_category_rel (
    helpdesk_solution_id integer NOT NULL,
    helpdesk_solution_faq_category_id integer NOT NULL
);


ALTER TABLE public.helpdesk_solution_helpdesk_solution_faq_category_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_solution_helpdesk_solution_faq_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_solution_helpdesk_solution_faq_category_rel IS 'RELATION BETWEEN helpdesk_solution AND helpdesk_solution_faq_category';


--
-- Name: helpdesk_solution_helpdesk_solution_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_solution_helpdesk_solution_tag_rel (
    helpdesk_solution_id integer NOT NULL,
    helpdesk_solution_tag_id integer NOT NULL
);


ALTER TABLE public.helpdesk_solution_helpdesk_solution_tag_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_solution_helpdesk_solution_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_solution_helpdesk_solution_tag_rel IS 'RELATION BETWEEN helpdesk_solution AND helpdesk_solution_tag';


--
-- Name: helpdesk_solution_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_solution_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_solution_id_seq OWNER TO runbot;

--
-- Name: helpdesk_solution_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_solution_id_seq OWNED BY public.helpdesk_solution.id;


--
-- Name: helpdesk_solution_saas_odoo_version_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_solution_saas_odoo_version_group_rel (
    helpdesk_solution_id integer NOT NULL,
    saas_odoo_version_group_id integer NOT NULL
);


ALTER TABLE public.helpdesk_solution_saas_odoo_version_group_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_solution_saas_odoo_version_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_solution_saas_odoo_version_group_rel IS 'RELATION BETWEEN helpdesk_solution AND saas_odoo_version_group';


--
-- Name: helpdesk_solution_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_solution_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_solution_tag OWNER TO runbot;

--
-- Name: TABLE helpdesk_solution_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_solution_tag IS 'Helpdesk Solution Tag';


--
-- Name: COLUMN helpdesk_solution_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_tag.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_solution_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_tag.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_solution_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_solution_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_tag.name IS 'Name';


--
-- Name: COLUMN helpdesk_solution_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_tag.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_solution_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_solution_tag.write_date IS 'Last Updated on';


--
-- Name: helpdesk_solution_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_solution_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_solution_tag_id_seq OWNER TO runbot;

--
-- Name: helpdesk_solution_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_solution_tag_id_seq OWNED BY public.helpdesk_solution_tag.id;


--
-- Name: helpdesk_stage; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage (
    id integer NOT NULL,
    sequence integer,
    template_id integer,
    rotting_threshold_days integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    legend_blocked jsonb NOT NULL,
    legend_done jsonb NOT NULL,
    legend_normal jsonb NOT NULL,
    active boolean,
    fold boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer,
    solution_required boolean,
    show_in_upgrade_portal boolean
);


ALTER TABLE public.helpdesk_stage OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage IS 'Helpdesk Stage';


--
-- Name: COLUMN helpdesk_stage.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.sequence IS 'Sequence';


--
-- Name: COLUMN helpdesk_stage.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.template_id IS 'Email Template';


--
-- Name: COLUMN helpdesk_stage.rotting_threshold_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.rotting_threshold_days IS 'Days to rot';


--
-- Name: COLUMN helpdesk_stage.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.color IS 'Color';


--
-- Name: COLUMN helpdesk_stage.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_stage.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_stage.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.name IS 'Name';


--
-- Name: COLUMN helpdesk_stage.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.description IS 'Description';


--
-- Name: COLUMN helpdesk_stage.legend_blocked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.legend_blocked IS 'Red Kanban Label';


--
-- Name: COLUMN helpdesk_stage.legend_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.legend_done IS 'Green Kanban Label';


--
-- Name: COLUMN helpdesk_stage.legend_normal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.legend_normal IS 'Grey Kanban Label';


--
-- Name: COLUMN helpdesk_stage.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.active IS 'Active';


--
-- Name: COLUMN helpdesk_stage.fold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.fold IS 'Folded';


--
-- Name: COLUMN helpdesk_stage.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_stage.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_stage.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN helpdesk_stage.solution_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.solution_required IS 'Solution Required?';


--
-- Name: COLUMN helpdesk_stage.show_in_upgrade_portal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.show_in_upgrade_portal IS 'Show In Upgrade Portal';


--
-- Name: helpdesk_stage_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage_delete_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_stage_delete_wizard OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage_delete_wizard IS 'Helpdesk Stage Delete Wizard';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: helpdesk_stage_delete_wizard_helpdesk_team_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel (
    helpdesk_stage_delete_wizard_id integer NOT NULL,
    helpdesk_team_id integer NOT NULL
);


ALTER TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage_delete_wizard_helpdesk_team_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel IS 'RELATION BETWEEN helpdesk_stage_delete_wizard AND helpdesk_team';


--
-- Name: helpdesk_stage_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_stage_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_stage_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: helpdesk_stage_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_stage_delete_wizard_id_seq OWNED BY public.helpdesk_stage_delete_wizard.id;


--
-- Name: helpdesk_stage_helpdesk_stage_delete_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel (
    helpdesk_stage_delete_wizard_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


ALTER TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage_helpdesk_stage_delete_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel IS 'RELATION BETWEEN helpdesk_stage_delete_wizard AND helpdesk_stage';


--
-- Name: helpdesk_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_stage_id_seq OWNER TO runbot;

--
-- Name: helpdesk_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_stage_id_seq OWNED BY public.helpdesk_stage.id;


--
-- Name: helpdesk_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_tag OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag IS 'Helpdesk Tags';


--
-- Name: COLUMN helpdesk_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.color IS 'Color';


--
-- Name: COLUMN helpdesk_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.name IS 'Name';


--
-- Name: COLUMN helpdesk_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.write_date IS 'Last Updated on';


--
-- Name: helpdesk_tag_assignment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag_assignment (
    id integer NOT NULL,
    team_id integer,
    tag_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_tag_assignment OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag_assignment IS 'Helpdesk Tag Assignment';


--
-- Name: COLUMN helpdesk_tag_assignment.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.team_id IS 'Team';


--
-- Name: COLUMN helpdesk_tag_assignment.tag_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.tag_id IS 'Ticket Tag';


--
-- Name: COLUMN helpdesk_tag_assignment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_tag_assignment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_tag_assignment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_tag_assignment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag_assignment.write_date IS 'Last Updated on';


--
-- Name: helpdesk_tag_assignment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_tag_assignment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_tag_assignment_id_seq OWNER TO runbot;

--
-- Name: helpdesk_tag_assignment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_tag_assignment_id_seq OWNED BY public.helpdesk_tag_assignment.id;


--
-- Name: helpdesk_tag_assignment_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag_assignment_res_users_rel (
    helpdesk_tag_assignment_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.helpdesk_tag_assignment_res_users_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag_assignment_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag_assignment_res_users_rel IS 'RELATION BETWEEN helpdesk_tag_assignment AND res_users';


--
-- Name: helpdesk_tag_helpdesk_ticket_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag_helpdesk_ticket_rel (
    helpdesk_ticket_id integer NOT NULL,
    helpdesk_tag_id integer NOT NULL
);


ALTER TABLE public.helpdesk_tag_helpdesk_ticket_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag_helpdesk_ticket_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag_helpdesk_ticket_rel IS 'RELATION BETWEEN helpdesk_ticket AND helpdesk_tag';


--
-- Name: helpdesk_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_tag_id_seq OWNER TO runbot;

--
-- Name: helpdesk_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_tag_id_seq OWNED BY public.helpdesk_tag.id;


--
-- Name: helpdesk_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_team (
    id integer NOT NULL,
    alias_id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer,
    color integer,
    resource_calendar_id integer,
    auto_close_day integer,
    to_stage_id integer,
    create_uid integer,
    write_uid integer,
    assign_method character varying NOT NULL,
    privacy_visibility character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    ticket_properties jsonb,
    active boolean,
    auto_assignment boolean,
    use_alias boolean,
    allow_portal_ticket_closing boolean,
    use_website_helpdesk_form boolean,
    use_website_helpdesk_livechat boolean,
    use_website_helpdesk_forum boolean,
    use_website_helpdesk_slides boolean,
    use_website_helpdesk_knowledge boolean,
    use_helpdesk_timesheet boolean,
    use_helpdesk_sale_timesheet boolean,
    use_credit_notes boolean,
    use_coupons boolean,
    use_giftcards boolean,
    use_fsm boolean,
    use_product_returns boolean,
    use_product_replacements boolean,
    use_product_repairs boolean,
    use_twitter boolean,
    use_rating boolean,
    use_sla boolean,
    auto_close_ticket boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    website_id integer,
    website_menu_id integer,
    website_form_view_id integer,
    website_meta_og_img character varying,
    website_meta_title jsonb,
    website_meta_description jsonb,
    website_meta_keywords jsonb,
    seo_name jsonb,
    is_seo_optimized boolean,
    is_published boolean,
    website_article_id integer,
    project_id integer,
    user_id integer,
    upgrade_team boolean
);


ALTER TABLE public.helpdesk_team OWNER TO runbot;

--
-- Name: TABLE helpdesk_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_team IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_team.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.alias_id IS 'Alias';


--
-- Name: COLUMN helpdesk_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.sequence IS 'Sequence';


--
-- Name: COLUMN helpdesk_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_team.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN helpdesk_team.auto_close_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.auto_close_day IS 'Inactive Period(days)';


--
-- Name: COLUMN helpdesk_team.to_stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.to_stage_id IS 'Move to Stage';


--
-- Name: COLUMN helpdesk_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_team.assign_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.assign_method IS 'Assignment Method';


--
-- Name: COLUMN helpdesk_team.privacy_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.privacy_visibility IS 'Visibility';


--
-- Name: COLUMN helpdesk_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.name IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_team.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.description IS 'About Team';


--
-- Name: COLUMN helpdesk_team.ticket_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.ticket_properties IS 'Ticket Properties';


--
-- Name: COLUMN helpdesk_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.active IS 'Active';


--
-- Name: COLUMN helpdesk_team.auto_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.auto_assignment IS 'Automatic Assignment';


--
-- Name: COLUMN helpdesk_team.use_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_alias IS 'Use Alias';


--
-- Name: COLUMN helpdesk_team.allow_portal_ticket_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.allow_portal_ticket_closing IS 'Closure by Customers';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_form IS 'Website Form';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_livechat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_livechat IS 'Live Chat';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_forum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_forum IS 'Community Forum';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_slides; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_slides IS 'eLearning';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_knowledge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_knowledge IS 'Knowledge';


--
-- Name: COLUMN helpdesk_team.use_helpdesk_timesheet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_helpdesk_timesheet IS 'Timesheets';


--
-- Name: COLUMN helpdesk_team.use_helpdesk_sale_timesheet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_helpdesk_sale_timesheet IS 'Time Billing';


--
-- Name: COLUMN helpdesk_team.use_credit_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_credit_notes IS 'Refunds';


--
-- Name: COLUMN helpdesk_team.use_coupons; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_coupons IS 'Coupons';


--
-- Name: COLUMN helpdesk_team.use_giftcards; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_giftcards IS 'Gift Cards';


--
-- Name: COLUMN helpdesk_team.use_fsm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_fsm IS 'Field Service';


--
-- Name: COLUMN helpdesk_team.use_product_returns; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_product_returns IS 'Returns';


--
-- Name: COLUMN helpdesk_team.use_product_replacements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_product_replacements IS 'Replacements';


--
-- Name: COLUMN helpdesk_team.use_product_repairs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_product_repairs IS 'Repairs';


--
-- Name: COLUMN helpdesk_team.use_twitter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_twitter IS 'X';


--
-- Name: COLUMN helpdesk_team.use_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_rating IS 'Customer Ratings';


--
-- Name: COLUMN helpdesk_team.use_sla; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_sla IS 'SLA Policies';


--
-- Name: COLUMN helpdesk_team.auto_close_ticket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.auto_close_ticket IS 'Automatic Closing';


--
-- Name: COLUMN helpdesk_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_team.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.website_id IS 'Website';


--
-- Name: COLUMN helpdesk_team.website_menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.website_menu_id IS 'Website Menu';


--
-- Name: COLUMN helpdesk_team.website_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.website_form_view_id IS 'Website Form View';


--
-- Name: COLUMN helpdesk_team.website_meta_og_img; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.website_meta_og_img IS 'Website opengraph image';


--
-- Name: COLUMN helpdesk_team.website_meta_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.website_meta_title IS 'Website meta title';


--
-- Name: COLUMN helpdesk_team.website_meta_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.website_meta_description IS 'Website meta description';


--
-- Name: COLUMN helpdesk_team.website_meta_keywords; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.website_meta_keywords IS 'Website meta keywords';


--
-- Name: COLUMN helpdesk_team.seo_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.seo_name IS 'Seo name';


--
-- Name: COLUMN helpdesk_team.is_seo_optimized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.is_seo_optimized IS 'SEO optimized';


--
-- Name: COLUMN helpdesk_team.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.is_published IS 'Is Published';


--
-- Name: COLUMN helpdesk_team.website_article_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.website_article_id IS 'Article';


--
-- Name: COLUMN helpdesk_team.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.project_id IS 'Project';


--
-- Name: COLUMN helpdesk_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.user_id IS 'Specific user';


--
-- Name: COLUMN helpdesk_team.upgrade_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.upgrade_team IS 'Upgrade Team?';


--
-- Name: helpdesk_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_team_id_seq OWNER TO runbot;

--
-- Name: helpdesk_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_team_id_seq OWNED BY public.helpdesk_team.id;


--
-- Name: helpdesk_team_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_team_res_users_rel (
    helpdesk_team_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.helpdesk_team_res_users_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_team_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_team_res_users_rel IS 'RELATION BETWEEN helpdesk_team AND res_users';


--
-- Name: helpdesk_team_technician_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_team_technician_rel (
    team_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.helpdesk_team_technician_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_team_technician_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_team_technician_rel IS 'RELATION BETWEEN helpdesk_team AND res_users';


--
-- Name: helpdesk_ticket; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_ticket (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    company_id integer,
    color integer,
    user_id integer,
    partner_id integer,
    stage_id integer,
    answered_customer_message_count integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    access_token character varying,
    name character varying NOT NULL,
    kanban_state character varying NOT NULL,
    partner_name character varying,
    partner_email character varying,
    partner_phone character varying,
    priority character varying,
    ticket_ref character varying,
    properties jsonb,
    description text,
    active boolean,
    closed_by_partner boolean,
    sla_reached_late boolean,
    sla_reached boolean,
    date_last_stage_update timestamp without time zone,
    assign_date timestamp without time zone,
    close_date timestamp without time zone,
    sla_deadline timestamp without time zone,
    oldest_unanswered_customer_message_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rating_last_value double precision,
    assign_hours double precision,
    close_hours double precision,
    sla_deadline_hours double precision,
    first_response_hours double precision,
    avg_response_hours double precision,
    total_response_hours double precision,
    partner_company_name character varying,
    origin_channel_id integer,
    helpdesk_solution_id integer,
    ticket_description text,
    solution_description text,
    sale_order_id integer,
    project_id integer,
    analytic_account_id integer,
    total_hours_spent double precision,
    parent_id integer,
    main_database_id integer,
    odoo_version_id integer,
    adhoc_module_id integer,
    adhoc_product_id integer,
    impact character varying,
    urgency character varying,
    sale_line_id integer,
    upgrade_type_id integer,
    consultant_upgrade_id integer,
    assigned_technician_id integer,
    last_test_request_line_id integer,
    last_production_request_line_id integer,
    upgrade_client_data_id integer,
    ticket_upgrade_status character varying,
    upgrade_classification character varying,
    deadline_upgrade date,
    parameters jsonb,
    environment_variables_dict text,
    upgrade_team boolean,
    active_production_freeze boolean,
    confirm_production_sent boolean,
    date_upgrade_scheduled timestamp without time zone,
    gantt_date_stop timestamp without time zone
);


ALTER TABLE public.helpdesk_ticket OWNER TO runbot;

--
-- Name: TABLE helpdesk_ticket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_ticket IS 'Helpdesk Ticket';


--
-- Name: COLUMN helpdesk_ticket.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.campaign_id IS 'Campaign';


--
-- Name: COLUMN helpdesk_ticket.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.source_id IS 'Source';


--
-- Name: COLUMN helpdesk_ticket.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.medium_id IS 'Medium';


--
-- Name: COLUMN helpdesk_ticket.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.team_id IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_ticket.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_ticket.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_ticket.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.user_id IS 'Assigned to';


--
-- Name: COLUMN helpdesk_ticket.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_id IS 'Customer';


--
-- Name: COLUMN helpdesk_ticket.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.stage_id IS 'Stage';


--
-- Name: COLUMN helpdesk_ticket.answered_customer_message_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.answered_customer_message_count IS '# Exchanges';


--
-- Name: COLUMN helpdesk_ticket.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.email_cc IS 'Email cc';


--
-- Name: COLUMN helpdesk_ticket.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.access_token IS 'Security Token';


--
-- Name: COLUMN helpdesk_ticket.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.name IS 'Subject';


--
-- Name: COLUMN helpdesk_ticket.kanban_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.kanban_state IS 'Kanban State';


--
-- Name: COLUMN helpdesk_ticket.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_name IS 'Customer Name';


--
-- Name: COLUMN helpdesk_ticket.partner_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_email IS 'Customer Email';


--
-- Name: COLUMN helpdesk_ticket.partner_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_phone IS 'Customer Phone';


--
-- Name: COLUMN helpdesk_ticket.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.priority IS 'Priority';


--
-- Name: COLUMN helpdesk_ticket.ticket_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.ticket_ref IS 'Ticket IDs Sequence';


--
-- Name: COLUMN helpdesk_ticket.properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.properties IS 'Properties';


--
-- Name: COLUMN helpdesk_ticket.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.description IS 'Description';


--
-- Name: COLUMN helpdesk_ticket.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.active IS 'Active';


--
-- Name: COLUMN helpdesk_ticket.closed_by_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.closed_by_partner IS 'Closed by Partner';


--
-- Name: COLUMN helpdesk_ticket.sla_reached_late; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_reached_late IS 'Has SLA reached late';


--
-- Name: COLUMN helpdesk_ticket.sla_reached; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_reached IS 'Has SLA reached';


--
-- Name: COLUMN helpdesk_ticket.date_last_stage_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN helpdesk_ticket.assign_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.assign_date IS 'First assignment date';


--
-- Name: COLUMN helpdesk_ticket.close_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.close_date IS 'Close date';


--
-- Name: COLUMN helpdesk_ticket.sla_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_deadline IS 'SLA Deadline';


--
-- Name: COLUMN helpdesk_ticket.oldest_unanswered_customer_message_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.oldest_unanswered_customer_message_date IS 'Oldest Unanswered Customer Message Date';


--
-- Name: COLUMN helpdesk_ticket.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_ticket.rating_last_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.rating_last_value IS 'Rating Last Value';


--
-- Name: COLUMN helpdesk_ticket.assign_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.assign_hours IS 'Time to first assignment (hours)';


--
-- Name: COLUMN helpdesk_ticket.close_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.close_hours IS 'Time to close (hours)';


--
-- Name: COLUMN helpdesk_ticket.sla_deadline_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_deadline_hours IS 'Working Hours until SLA Deadline';


--
-- Name: COLUMN helpdesk_ticket.first_response_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.first_response_hours IS 'Hours to First Response';


--
-- Name: COLUMN helpdesk_ticket.avg_response_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.avg_response_hours IS 'Average Hours to Respond';


--
-- Name: COLUMN helpdesk_ticket.total_response_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.total_response_hours IS 'Total Exchange Time in Hours';


--
-- Name: COLUMN helpdesk_ticket.partner_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_company_name IS 'Company Name';


--
-- Name: COLUMN helpdesk_ticket.origin_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.origin_channel_id IS 'Live chat from which the ticket was created';


--
-- Name: COLUMN helpdesk_ticket.helpdesk_solution_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.helpdesk_solution_id IS 'Linked Solution';


--
-- Name: COLUMN helpdesk_ticket.ticket_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.ticket_description IS 'Ticket Description';


--
-- Name: COLUMN helpdesk_ticket.solution_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.solution_description IS 'Solution Description';


--
-- Name: COLUMN helpdesk_ticket.sale_order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sale_order_id IS 'Ref. Sales Order';


--
-- Name: COLUMN helpdesk_ticket.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.project_id IS 'Project';


--
-- Name: COLUMN helpdesk_ticket.analytic_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.analytic_account_id IS 'Analytic Account';


--
-- Name: COLUMN helpdesk_ticket.total_hours_spent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.total_hours_spent IS 'Time Spent';


--
-- Name: COLUMN helpdesk_ticket.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.parent_id IS 'Parent Ticket';


--
-- Name: COLUMN helpdesk_ticket.main_database_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.main_database_id IS 'Database';


--
-- Name: COLUMN helpdesk_ticket.odoo_version_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.odoo_version_id IS 'Odoo Version';


--
-- Name: COLUMN helpdesk_ticket.adhoc_module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.adhoc_module_id IS 'Adhoc Module';


--
-- Name: COLUMN helpdesk_ticket.adhoc_product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.adhoc_product_id IS 'Adhoc Product';


--
-- Name: COLUMN helpdesk_ticket.impact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.impact IS 'Impact';


--
-- Name: COLUMN helpdesk_ticket.urgency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.urgency IS 'Urgency';


--
-- Name: COLUMN helpdesk_ticket.sale_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sale_line_id IS 'Sales Order Item';


--
-- Name: COLUMN helpdesk_ticket.upgrade_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.upgrade_type_id IS 'Upgrade Type';


--
-- Name: COLUMN helpdesk_ticket.consultant_upgrade_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.consultant_upgrade_id IS 'Upgrade Consultant';


--
-- Name: COLUMN helpdesk_ticket.assigned_technician_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.assigned_technician_id IS 'Técnico asignado';


--
-- Name: COLUMN helpdesk_ticket.last_test_request_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.last_test_request_line_id IS 'Last Test Request Line';


--
-- Name: COLUMN helpdesk_ticket.last_production_request_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.last_production_request_line_id IS 'Last Production Request Line';


--
-- Name: COLUMN helpdesk_ticket.upgrade_client_data_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.upgrade_client_data_id IS 'Upgrade Client Data';


--
-- Name: COLUMN helpdesk_ticket.ticket_upgrade_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.ticket_upgrade_status IS 'Ticket Upgrade Status';


--
-- Name: COLUMN helpdesk_ticket.upgrade_classification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.upgrade_classification IS 'Upgrade Classification';


--
-- Name: COLUMN helpdesk_ticket.deadline_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.deadline_upgrade IS 'Fecha deseada de actualización';


--
-- Name: COLUMN helpdesk_ticket.parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.parameters IS 'Parameters';


--
-- Name: COLUMN helpdesk_ticket.environment_variables_dict; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.environment_variables_dict IS 'Environment Variables Dict';


--
-- Name: COLUMN helpdesk_ticket.upgrade_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.upgrade_team IS 'Upgrade Team?';


--
-- Name: COLUMN helpdesk_ticket.active_production_freeze; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.active_production_freeze IS 'Active Production Freeze';


--
-- Name: COLUMN helpdesk_ticket.confirm_production_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.confirm_production_sent IS 'Confirm Production Sent';


--
-- Name: COLUMN helpdesk_ticket.date_upgrade_scheduled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.date_upgrade_scheduled IS 'Fecha agendada para actualización';


--
-- Name: COLUMN helpdesk_ticket.gantt_date_stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.gantt_date_stop IS 'Gantt Date Stop';


--
-- Name: helpdesk_ticket_convert_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_ticket_convert_wizard (
    id integer NOT NULL,
    project_id integer,
    stage_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_ticket_convert_wizard OWNER TO runbot;

--
-- Name: TABLE helpdesk_ticket_convert_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_ticket_convert_wizard IS 'Convert Helpdesk Tickets to Tasks';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.project_id IS 'Project';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.stage_id IS 'Stage';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket_convert_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_convert_wizard.write_date IS 'Last Updated on';


--
-- Name: helpdesk_ticket_convert_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_ticket_convert_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_ticket_convert_wizard_id_seq OWNER TO runbot;

--
-- Name: helpdesk_ticket_convert_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_ticket_convert_wizard_id_seq OWNED BY public.helpdesk_ticket_convert_wizard.id;


--
-- Name: helpdesk_ticket_customer_note; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_ticket_customer_note (
    id integer NOT NULL,
    sequence integer,
    adhoc_product_id integer,
    ticket_id integer NOT NULL,
    upgrade_type_id integer NOT NULL,
    upgrade_line_id integer,
    parent_adhoc_product_id integer,
    create_uid integer,
    write_uid integer,
    access_token character varying,
    title character varying NOT NULL,
    status character varying NOT NULL,
    responsible character varying,
    priority character varying,
    used_placeholders_hash character varying,
    html_field_history jsonb,
    description text,
    notes text,
    post_production boolean,
    code_validation boolean,
    upload_changes boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_ticket_customer_note OWNER TO runbot;

--
-- Name: TABLE helpdesk_ticket_customer_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_ticket_customer_note IS 'Helpdesk Ticket Customer Notes';


--
-- Name: COLUMN helpdesk_ticket_customer_note.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.sequence IS 'Sequence';


--
-- Name: COLUMN helpdesk_ticket_customer_note.adhoc_product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.adhoc_product_id IS 'Adhoc Product';


--
-- Name: COLUMN helpdesk_ticket_customer_note.ticket_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.ticket_id IS 'Ticket';


--
-- Name: COLUMN helpdesk_ticket_customer_note.upgrade_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.upgrade_type_id IS 'Upgrade Type';


--
-- Name: COLUMN helpdesk_ticket_customer_note.upgrade_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.upgrade_line_id IS 'Upgrade Line';


--
-- Name: COLUMN helpdesk_ticket_customer_note.parent_adhoc_product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.parent_adhoc_product_id IS 'Producto Padre';


--
-- Name: COLUMN helpdesk_ticket_customer_note.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket_customer_note.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket_customer_note.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.access_token IS 'Security Token';


--
-- Name: COLUMN helpdesk_ticket_customer_note.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.title IS 'Title';


--
-- Name: COLUMN helpdesk_ticket_customer_note.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.status IS 'Status';


--
-- Name: COLUMN helpdesk_ticket_customer_note.responsible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.responsible IS 'Responsible';


--
-- Name: COLUMN helpdesk_ticket_customer_note.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.priority IS 'Priority';


--
-- Name: COLUMN helpdesk_ticket_customer_note.used_placeholders_hash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.used_placeholders_hash IS 'Used Placeholders Hash';


--
-- Name: COLUMN helpdesk_ticket_customer_note.html_field_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.html_field_history IS 'History data';


--
-- Name: COLUMN helpdesk_ticket_customer_note.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.description IS 'Description';


--
-- Name: COLUMN helpdesk_ticket_customer_note.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.notes IS 'Notes';


--
-- Name: COLUMN helpdesk_ticket_customer_note.post_production; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.post_production IS 'Post Production';


--
-- Name: COLUMN helpdesk_ticket_customer_note.code_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.code_validation IS 'Customer Note Validation';


--
-- Name: COLUMN helpdesk_ticket_customer_note.upload_changes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.upload_changes IS 'Customer Note Upload Changes';


--
-- Name: COLUMN helpdesk_ticket_customer_note.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.active IS 'Active';


--
-- Name: COLUMN helpdesk_ticket_customer_note.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket_customer_note.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_customer_note.write_date IS 'Last Updated on';


--
-- Name: helpdesk_ticket_customer_note_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_ticket_customer_note_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_ticket_customer_note_id_seq OWNER TO runbot;

--
-- Name: helpdesk_ticket_customer_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_ticket_customer_note_id_seq OWNED BY public.helpdesk_ticket_customer_note.id;


--
-- Name: helpdesk_ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_ticket_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_ticket_id_seq OWNER TO runbot;

--
-- Name: helpdesk_ticket_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_ticket_id_seq OWNED BY public.helpdesk_ticket.id;


--
-- Name: helpdesk_ticket_report_analysis; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.helpdesk_ticket_report_analysis AS
SELECT
    NULL::integer AS id,
    NULL::integer AS ticket_id,
    NULL::text AS description,
    NULL::character varying AS ticket_ref,
    NULL::character varying AS name,
    NULL::timestamp without time zone AS create_date,
    NULL::character varying AS priority,
    NULL::integer AS user_id,
    NULL::integer AS partner_id,
    NULL::character varying AS partner_name,
    NULL::character varying AS partner_email,
    NULL::character varying AS partner_phone,
    NULL::integer AS stage_id,
    NULL::timestamp without time zone AS sla_deadline,
    NULL::double precision AS ticket_deadline_hours,
    NULL::double precision AS ticket_close_hours,
    NULL::numeric AS ticket_open_hours,
    NULL::double precision AS ticket_assignation_hours,
    NULL::timestamp without time zone AS close_date,
    NULL::timestamp without time zone AS assign_date,
    NULL::double precision AS rating_last_value,
    NULL::double precision AS rating_avg,
    NULL::boolean AS active,
    NULL::integer AS team_id,
    NULL::integer AS company_id,
    NULL::character varying AS kanban_state,
    NULL::double precision AS first_response_hours,
    NULL::double precision AS avg_response_hours,
    NULL::boolean AS sla_success,
    NULL::integer AS sale_order_id,
    NULL::double precision AS total_hours_spent,
    NULL::integer AS employee_parent_id,
    NULL::integer AS department_id,
    NULL::integer AS employee_id,
    NULL::double precision AS remaining_hours_so,
    NULL::integer AS sale_line_id;


ALTER VIEW public.helpdesk_ticket_report_analysis OWNER TO runbot;

--
-- Name: helpdesk_ticket_saas_upgrade_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_ticket_saas_upgrade_line_rel (
    saas_upgrade_line_id integer NOT NULL,
    helpdesk_ticket_id integer NOT NULL
);


ALTER TABLE public.helpdesk_ticket_saas_upgrade_line_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_ticket_saas_upgrade_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_ticket_saas_upgrade_line_rel IS 'RELATION BETWEEN saas_upgrade_line AND helpdesk_ticket';


--
-- Name: helpdesk_ticket_upgrade_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_ticket_upgrade_request (
    id integer NOT NULL,
    original_database_id integer,
    upgraded_database_id integer,
    ticket_id integer NOT NULL,
    upgrade_type_id integer,
    event_upgrade_id integer,
    first_original_database_id integer,
    next_request_id integer,
    prev_request_id integer,
    create_uid integer,
    write_uid integer,
    description character varying,
    original_database_state character varying,
    upgraded_database_state character varying,
    state character varying NOT NULL,
    odoo_request_id character varying,
    odoo_request_token character varying,
    odoo_host_uri character varying,
    aim character varying,
    odoo_aim character varying,
    status character varying,
    odoo_upgrade_log_filename character varying,
    upgrade_log_filename character varying,
    deadline_upgrade date,
    time_running jsonb,
    time_on_hold jsonb,
    upgrade_line_versions_used jsonb,
    request_status_info jsonb,
    request_info text,
    upgrade_report_html text,
    hide_from_portal boolean,
    automatic boolean,
    with_error_log boolean,
    with_original_database boolean,
    with_upgraded_database boolean,
    with_first_original_database boolean,
    on_by_pass boolean,
    planned_start timestamp without time zone,
    end_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    total_time double precision,
    cum_total_time double precision,
    real_total_time double precision,
    cum_real_total_time double precision
);


ALTER TABLE public.helpdesk_ticket_upgrade_request OWNER TO runbot;

--
-- Name: TABLE helpdesk_ticket_upgrade_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_ticket_upgrade_request IS 'Helpdesk Ticket Upgrade Request';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.original_database_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.original_database_id IS 'Old Database';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.upgraded_database_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.upgraded_database_id IS 'New Database';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.ticket_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.ticket_id IS 'Upgrade';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.upgrade_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.upgrade_type_id IS 'Upgrade Type';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.event_upgrade_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.event_upgrade_id IS 'Upgrade Event';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.first_original_database_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.first_original_database_id IS 'First Original Database';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.next_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.next_request_id IS 'Next Upgrade Request';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.prev_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.prev_request_id IS 'Previous Upgrade Request';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.description IS 'Description';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.original_database_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.original_database_state IS 'Old Database State';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.upgraded_database_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.upgraded_database_state IS 'New Database State';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.state IS 'State';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.odoo_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.odoo_request_id IS 'Odoo Request';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.odoo_request_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.odoo_request_token IS 'Odoo Request Token';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.odoo_host_uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.odoo_host_uri IS 'Odoo Host Uri';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.aim; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.aim IS 'Aim';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.odoo_aim; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.odoo_aim IS 'Odoo Aim';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.status IS 'Status';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.odoo_upgrade_log_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.odoo_upgrade_log_filename IS 'Odoo Upgrade Log Filename';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.upgrade_log_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.upgrade_log_filename IS 'Upgrade Log Filename';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.deadline_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.deadline_upgrade IS 'Fecha deseada de actualización';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.time_running; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.time_running IS 'Time Running';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.time_on_hold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.time_on_hold IS 'Time On Hold';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.upgrade_line_versions_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.upgrade_line_versions_used IS 'Upgrade Line Versions Used';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.request_status_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.request_status_info IS 'Request Status Info';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.request_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.request_info IS 'Request Info';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.upgrade_report_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.upgrade_report_html IS 'Upgrade Report';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.hide_from_portal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.hide_from_portal IS 'Hide from Portal';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.automatic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.automatic IS 'Automatic';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.with_error_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.with_error_log IS 'With Error Log';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.with_original_database; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.with_original_database IS 'With Original Database';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.with_upgraded_database; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.with_upgraded_database IS 'With Upgraded Database';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.with_first_original_database; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.with_first_original_database IS 'With First Original Database';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.on_by_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.on_by_pass IS 'On By Pass';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.planned_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.planned_start IS 'Planned Start';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.end_date IS 'End Date';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.total_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.total_time IS 'Total Time';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.cum_total_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.cum_total_time IS 'Accumulated Total Time';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.real_total_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.real_total_time IS 'Real Total Time';


--
-- Name: COLUMN helpdesk_ticket_upgrade_request.cum_real_total_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket_upgrade_request.cum_real_total_time IS 'Accumulated Real Total Time';


--
-- Name: helpdesk_ticket_upgrade_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_ticket_upgrade_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_ticket_upgrade_request_id_seq OWNER TO runbot;

--
-- Name: helpdesk_ticket_upgrade_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_ticket_upgrade_request_id_seq OWNED BY public.helpdesk_ticket_upgrade_request.id;


--
-- Name: homework_location_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.homework_location_wizard (
    id integer NOT NULL,
    work_location_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date,
    weekly boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.homework_location_wizard OWNER TO runbot;

--
-- Name: TABLE homework_location_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.homework_location_wizard IS 'Set Homework Location Wizard';


--
-- Name: COLUMN homework_location_wizard.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.work_location_id IS 'Location';


--
-- Name: COLUMN homework_location_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.employee_id IS 'Employee';


--
-- Name: COLUMN homework_location_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN homework_location_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN homework_location_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.date IS 'Date';


--
-- Name: COLUMN homework_location_wizard.weekly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.weekly IS 'Weekly';


--
-- Name: COLUMN homework_location_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.create_date IS 'Created on';


--
-- Name: COLUMN homework_location_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.homework_location_wizard.write_date IS 'Last Updated on';


--
-- Name: homework_location_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.homework_location_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.homework_location_wizard_id_seq OWNER TO runbot;

--
-- Name: homework_location_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.homework_location_wizard_id_seq OWNED BY public.homework_location_wizard.id;


--
-- Name: hr_bank_account_allocation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_bank_account_allocation_wizard (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_bank_account_allocation_wizard OWNER TO runbot;

--
-- Name: TABLE hr_bank_account_allocation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_bank_account_allocation_wizard IS 'Bank Account Allocation Wizard';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.employee_id IS 'Employee';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_bank_account_allocation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_bank_account_allocation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_bank_account_allocation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_bank_account_allocation_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_bank_account_allocation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_bank_account_allocation_wizard_id_seq OWNED BY public.hr_bank_account_allocation_wizard.id;


--
-- Name: hr_bank_account_allocation_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_bank_account_allocation_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    bank_account_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying,
    amount numeric,
    trusted boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_bank_account_allocation_wizard_line OWNER TO runbot;

--
-- Name: TABLE hr_bank_account_allocation_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_bank_account_allocation_wizard_line IS 'Bank Account Allocation Line (Wizard)';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.amount IS 'Amount';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.trusted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.trusted IS 'Trusted';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN hr_bank_account_allocation_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_bank_account_allocation_wizard_line.write_date IS 'Last Updated on';


--
-- Name: hr_bank_account_allocation_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_bank_account_allocation_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_bank_account_allocation_wizard_line_id_seq OWNER TO runbot;

--
-- Name: hr_bank_account_allocation_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_bank_account_allocation_wizard_line_id_seq OWNED BY public.hr_bank_account_allocation_wizard_line.id;


--
-- Name: hr_contract_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_contract_type (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_contract_type OWNER TO runbot;

--
-- Name: TABLE hr_contract_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_contract_type IS 'Contract Type';


--
-- Name: COLUMN hr_contract_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_contract_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.country_id IS 'Country';


--
-- Name: COLUMN hr_contract_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_contract_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_contract_type.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.code IS 'Code';


--
-- Name: COLUMN hr_contract_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.name IS 'Name';


--
-- Name: COLUMN hr_contract_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_contract_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_date IS 'Last Updated on';


--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_contract_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_contract_type_id_seq OWNER TO runbot;

--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_contract_type_id_seq OWNED BY public.hr_contract_type.id;


--
-- Name: hr_department; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_department (
    id integer NOT NULL,
    company_id integer,
    parent_id integer,
    manager_id integer,
    color integer,
    master_department_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    note text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_department OWNER TO runbot;

--
-- Name: TABLE hr_department; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_department IS 'Department';


--
-- Name: COLUMN hr_department.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.company_id IS 'Company';


--
-- Name: COLUMN hr_department.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_id IS 'Parent Department';


--
-- Name: COLUMN hr_department.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.manager_id IS 'Manager';


--
-- Name: COLUMN hr_department.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.color IS 'Color Index';


--
-- Name: COLUMN hr_department.master_department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.master_department_id IS 'Master Department';


--
-- Name: COLUMN hr_department.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_uid IS 'Created by';


--
-- Name: COLUMN hr_department.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_department.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_path IS 'Parent Path';


--
-- Name: COLUMN hr_department.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.name IS 'Department Name';


--
-- Name: COLUMN hr_department.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.note IS 'Note';


--
-- Name: COLUMN hr_department.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.active IS 'Active';


--
-- Name: COLUMN hr_department.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_date IS 'Created on';


--
-- Name: COLUMN hr_department.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_date IS 'Last Updated on';


--
-- Name: hr_department_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_department_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_department_id_seq OWNER TO runbot;

--
-- Name: hr_department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_department_id_seq OWNED BY public.hr_department.id;


--
-- Name: hr_departure_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_reason (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_reason OWNER TO runbot;

--
-- Name: TABLE hr_departure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_reason IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_reason.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.sequence IS 'Sequence';


--
-- Name: COLUMN hr_departure_reason.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.country_id IS 'Country';


--
-- Name: COLUMN hr_departure_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_reason.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.name IS 'Reason';


--
-- Name: COLUMN hr_departure_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_date IS 'Last Updated on';


--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_reason_id_seq OWNER TO runbot;

--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_reason_id_seq OWNED BY public.hr_departure_reason.id;


--
-- Name: hr_departure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_wizard (
    id integer NOT NULL,
    departure_reason_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    departure_date date NOT NULL,
    departure_description text,
    remove_related_user boolean,
    set_date_end boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_wizard OWNER TO runbot;

--
-- Name: TABLE hr_departure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_wizard IS 'Departure Wizard';


--
-- Name: COLUMN hr_departure_wizard.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_wizard.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_date IS 'Contract End Date';


--
-- Name: COLUMN hr_departure_wizard.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_departure_wizard.remove_related_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.remove_related_user IS 'Related User';


--
-- Name: COLUMN hr_departure_wizard.set_date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.set_date_end IS 'Set Contract End Date';


--
-- Name: COLUMN hr_departure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_departure_wizard_hr_employee_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_wizard_hr_employee_rel (
    hr_departure_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_departure_wizard_hr_employee_rel OWNER TO runbot;

--
-- Name: TABLE hr_departure_wizard_hr_employee_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_wizard_hr_employee_rel IS 'RELATION BETWEEN hr_departure_wizard AND hr_employee';


--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNED BY public.hr_departure_wizard.id;


--
-- Name: hr_employee_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_category (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_category OWNER TO runbot;

--
-- Name: TABLE hr_employee_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_category IS 'Employee Category';


--
-- Name: COLUMN hr_employee_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.color IS 'Color Index';


--
-- Name: COLUMN hr_employee_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.name IS 'Tag Name';


--
-- Name: COLUMN hr_employee_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_date IS 'Last Updated on';


--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_category_id_seq OWNER TO runbot;

--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_category_id_seq OWNED BY public.hr_employee_category.id;


--
-- Name: hr_employee_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_skill (
    id integer NOT NULL,
    skill_id integer NOT NULL,
    skill_level_id integer NOT NULL,
    skill_type_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    valid_from date,
    valid_to date,
    display_warning_message boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_skill OWNER TO runbot;

--
-- Name: TABLE hr_employee_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_skill IS 'Skill level for employee';


--
-- Name: COLUMN hr_employee_skill.skill_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_id IS 'Skill';


--
-- Name: COLUMN hr_employee_skill.skill_level_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_level_id IS 'Skill Level';


--
-- Name: COLUMN hr_employee_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_employee_skill.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_skill.valid_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.valid_from IS 'Validity Start';


--
-- Name: COLUMN hr_employee_skill.valid_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.valid_to IS 'Validity Stop';


--
-- Name: COLUMN hr_employee_skill.display_warning_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.display_warning_message IS 'Display Warning Message';


--
-- Name: COLUMN hr_employee_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_date IS 'Last Updated on';


--
-- Name: hr_skill_level; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_level (
    id integer NOT NULL,
    skill_type_id integer,
    level_progress integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    default_level boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_skill_level_check_level_progress CHECK (((level_progress >= 0) AND (level_progress <= 100)))
);


ALTER TABLE public.hr_skill_level OWNER TO runbot;

--
-- Name: TABLE hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_level IS 'Skill Level';


--
-- Name: COLUMN hr_skill_level.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_skill_level.level_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.level_progress IS 'Progress';


--
-- Name: COLUMN hr_skill_level.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_level.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_level.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.name IS 'Name';


--
-- Name: COLUMN hr_skill_level.default_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.default_level IS 'Default Level';


--
-- Name: COLUMN hr_skill_level.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_level.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_skill_level_check_level_progress ON hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_skill_level_check_level_progress ON public.hr_skill_level IS 'CHECK(level_progress BETWEEN 0 AND 100)';


--
-- Name: hr_skill_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_type (
    id integer NOT NULL,
    sequence integer,
    color integer,
    levels_count integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    is_certification boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_skill_type OWNER TO runbot;

--
-- Name: TABLE hr_skill_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_type IS 'Skill Type';


--
-- Name: COLUMN hr_skill_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_skill_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.color IS 'Color';


--
-- Name: COLUMN hr_skill_type.levels_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.levels_count IS 'Levels Count';


--
-- Name: COLUMN hr_skill_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.name IS 'Name';


--
-- Name: COLUMN hr_skill_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.active IS 'Active';


--
-- Name: COLUMN hr_skill_type.is_certification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.is_certification IS 'Certification';


--
-- Name: COLUMN hr_skill_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_date IS 'Last Updated on';


--
-- Name: hr_employee_certification_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_certification_report AS
 SELECT row_number() OVER () AS id,
    e.id AS employee_id,
    e.company_id,
    v.department_id,
    s.skill_id,
    s.skill_type_id,
    ((sl.level_progress)::numeric / 100.0) AS level_progress,
    sl.name AS skill_level,
    (((s.valid_to IS NULL) OR (s.valid_to >= '2026-01-21'::date)) AND (s.valid_from <= '2026-01-21'::date)) AS active
   FROM ((((public.hr_employee e
     LEFT JOIN public.hr_version v ON ((e.current_version_id = v.id)))
     LEFT JOIN public.hr_employee_skill s ON ((e.id = s.employee_id)))
     LEFT JOIN public.hr_skill_level sl ON ((sl.id = s.skill_level_id)))
     LEFT JOIN public.hr_skill_type st ON ((st.id = sl.skill_type_id)))
  WHERE (e.active AND (st.active IS TRUE) AND (st.is_certification IS TRUE));


ALTER VIEW public.hr_employee_certification_report OWNER TO runbot;

--
-- Name: hr_employee_cv_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_cv_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    color_primary character varying NOT NULL,
    color_secondary character varying NOT NULL,
    show_skills boolean,
    show_contact boolean,
    show_others boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_cv_wizard OWNER TO runbot;

--
-- Name: TABLE hr_employee_cv_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_cv_wizard IS 'Print Resume';


--
-- Name: COLUMN hr_employee_cv_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_cv_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_cv_wizard.color_primary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_primary IS 'Primary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.color_secondary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_secondary IS 'Secondary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.show_skills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_skills IS 'Skills';


--
-- Name: COLUMN hr_employee_cv_wizard.show_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_contact IS 'Contact Information';


--
-- Name: COLUMN hr_employee_cv_wizard.show_others; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_others IS 'Others';


--
-- Name: COLUMN hr_employee_cv_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_cv_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_cv_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNED BY public.hr_employee_cv_wizard.id;


--
-- Name: hr_employee_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_delete_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_delete_wizard OWNER TO runbot;

--
-- Name: TABLE hr_employee_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_delete_wizard IS 'Employee Delete Wizard';


--
-- Name: COLUMN hr_employee_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_employee_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_employee_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_delete_wizard_id_seq OWNED BY public.hr_employee_delete_wizard.id;


--
-- Name: hr_employee_hr_employee_cv_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_employee_cv_wizard_rel (
    hr_employee_cv_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_employee_cv_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_employee_cv_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_employee_cv_wizard_rel IS 'RELATION BETWEEN hr_employee_cv_wizard AND hr_employee';


--
-- Name: hr_employee_hr_employee_delete_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_employee_delete_wizard_rel (
    hr_employee_delete_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_employee_delete_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_employee_delete_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_employee_delete_wizard_rel IS 'RELATION BETWEEN hr_employee_delete_wizard AND hr_employee';


--
-- Name: hr_employee_hr_skill_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_skill_rel (
    hr_employee_id integer NOT NULL,
    hr_skill_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_skill_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_skill_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_skill_rel IS 'RELATION BETWEEN hr_employee AND hr_skill';


--
-- Name: hr_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_id_seq OWNER TO runbot;

--
-- Name: hr_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_id_seq OWNED BY public.hr_employee.id;


--
-- Name: hr_employee_location; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_location (
    id integer NOT NULL,
    work_location_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_location OWNER TO runbot;

--
-- Name: TABLE hr_employee_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_location IS 'Employee Location';


--
-- Name: COLUMN hr_employee_location.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.work_location_id IS 'Location';


--
-- Name: COLUMN hr_employee_location.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_location.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_location.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_location.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.date IS 'Date';


--
-- Name: COLUMN hr_employee_location.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_location.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_location.write_date IS 'Last Updated on';


--
-- Name: hr_employee_location_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_location_id_seq OWNER TO runbot;

--
-- Name: hr_employee_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_location_id_seq OWNED BY public.hr_employee_location.id;


--
-- Name: hr_employee_public; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_public AS
 SELECT e.id,
    e.id AS employee_id,
    e.name,
    e.active,
    v.create_date,
    v.department_id,
    v.job_id,
    v.company_id,
    v.address_id,
    e.mobile_phone,
    e.work_phone,
    e.work_email,
    e.work_contact_id,
    v.work_location_id,
    e.user_id,
    e.resource_id,
    e.color,
    v.resource_calendar_id,
    e.parent_id,
    e.coach_id,
    v.create_uid,
    v.write_uid,
    v.write_date,
    e.monday_location_id,
    e.tuesday_location_id,
    e.wednesday_location_id,
    e.thursday_location_id,
    e.friday_location_id,
    e.saturday_location_id,
    e.sunday_location_id,
    e.today_location_name,
    e.timesheet_manager_id
   FROM (public.hr_employee e
     JOIN public.hr_version v ON ((v.id = e.current_version_id)));


ALTER VIEW public.hr_employee_public OWNER TO runbot;

--
-- Name: hr_employee_skill_history_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_skill_history_report AS
 WITH individual_skill AS (
         SELECT hr_employee_skill.valid_from,
            hr_employee_skill.valid_to,
            hr_employee_skill.employee_id,
            hr_employee_skill.skill_id
           FROM public.hr_employee_skill
          ORDER BY hr_employee_skill.employee_id, hr_employee_skill.skill_id, hr_employee_skill.valid_from
        ), date_table AS (
         SELECT date_table_1.date,
            date_table_1.employee_id
           FROM ( SELECT start.valid_from AS date,
                    start.employee_id
                   FROM individual_skill start
                UNION
                 SELECT stop.valid_to AS date,
                    stop.employee_id
                   FROM individual_skill stop
                  WHERE (stop.valid_to IS NOT NULL)) date_table_1
          ORDER BY date_table_1.date
        )
 SELECT DISTINCT ON (date_table.date, emp_skill_level.employee_id, emp_skill_level.skill_id) date_table.date,
    emp_skill_level.employee_id,
    emp_skill_level.skill_id,
    emp_skill_level.skill_type_id,
    emp_skill_level.level_progress
   FROM (date_table
     CROSS JOIN ( SELECT emp_skill.id,
            emp_skill.skill_id,
            emp_skill.skill_level_id,
            emp_skill.skill_type_id,
            emp_skill.employee_id,
            emp_skill.create_uid,
            emp_skill.write_uid,
            emp_skill.valid_from,
            emp_skill.valid_to,
            emp_skill.display_warning_message,
            emp_skill.create_date,
            emp_skill.write_date,
            level.level_progress
           FROM (public.hr_employee_skill emp_skill
             JOIN public.hr_skill_level level ON ((emp_skill.skill_level_id = level.id)))) emp_skill_level)
  WHERE ((date_table.date >= emp_skill_level.valid_from) AND (date_table.employee_id = emp_skill_level.employee_id) AND ((emp_skill_level.valid_to IS NULL) OR (date_table.date <= emp_skill_level.valid_to)))
  ORDER BY date_table.date, emp_skill_level.employee_id, emp_skill_level.skill_id, emp_skill_level.valid_from DESC;


ALTER VIEW public.hr_employee_skill_history_report OWNER TO runbot;

--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_skill_id_seq OWNER TO runbot;

--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_skill_id_seq OWNED BY public.hr_employee_skill.id;


--
-- Name: hr_employee_skill_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_skill_report AS
 SELECT row_number() OVER () AS id,
    e.id AS employee_id,
    e.company_id,
    v.department_id,
    v.job_id,
    s.skill_id,
    s.skill_type_id,
    ((sl.level_progress)::numeric / 100.0) AS level_progress,
    sl.name AS skill_level
   FROM ((((public.hr_employee e
     LEFT JOIN public.hr_version v ON ((e.current_version_id = v.id)))
     LEFT JOIN public.hr_employee_skill s ON ((e.id = s.employee_id)))
     LEFT JOIN public.hr_skill_level sl ON ((sl.id = s.skill_level_id)))
     LEFT JOIN public.hr_skill_type st ON ((st.id = sl.skill_type_id)))
  WHERE ((st.active IS TRUE) AND (st.is_certification IS NOT TRUE) AND (s.valid_to IS NULL));


ALTER VIEW public.hr_employee_skill_report OWNER TO runbot;

--
-- Name: hr_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job (
    id integer NOT NULL,
    sequence integer,
    no_of_recruitment integer,
    user_id integer,
    department_id integer,
    company_id integer,
    contract_type_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description text,
    requirements text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_job_no_of_recruitment_positive CHECK ((no_of_recruitment >= 0))
);


ALTER TABLE public.hr_job OWNER TO runbot;

--
-- Name: TABLE hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_jo