--
-- PostgreSQL database dump
--

\restrict ICmKvQKibmQbL33IxPUkIceHwVwQEAnDFeaiRatzddh4D6RGlJeubCyA8Iv4thx

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 16.11 (Debian 16.11-1.pgdg12+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    account_type character varying NOT NULL,
    name jsonb NOT NULL,
    code_store jsonb,
    note text,
    deprecated boolean,
    reconcile boolean,
    non_trade boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_monetary boolean,
    create_asset character varying NOT NULL,
    multiple_assets_per_line boolean,
    disallowed_expenses_category_id integer,
    l10n_ar_afip_activity_id integer
);


ALTER TABLE public.account_account OWNER TO runbot;

--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.account_type IS 'Type';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.name IS 'Account Name';


--
-- Name: COLUMN account_account.code_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.code_store IS 'Code Store';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.deprecated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.deprecated IS 'Deprecated';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.non_trade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.non_trade IS 'Non Trade';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account.is_monetary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.is_monetary IS 'Is Monetary';


--
-- Name: COLUMN account_account.create_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_asset IS 'Create Asset';


--
-- Name: COLUMN account_account.multiple_assets_per_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.multiple_assets_per_line IS 'Multiple Assets per Line';


--
-- Name: COLUMN account_account.disallowed_expenses_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.disallowed_expenses_category_id IS 'Disallowed Expenses Category';


--
-- Name: COLUMN account_account.l10n_ar_afip_activity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.l10n_ar_afip_activity_id IS 'Associated Activity';


--
-- Name: account_account_account_asset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_asset_rel (
    account_account_id integer NOT NULL,
    account_asset_id integer NOT NULL
);


ALTER TABLE public.account_account_account_asset_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_asset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_asset_rel IS 'RELATION BETWEEN account_account AND account_asset';


--
-- Name: account_account_account_auto_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_auto_reconcile_wizard_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_auto_reconcile_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_auto_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_auto_reconcile_wizard_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_account';


--
-- Name: account_account_account_import_summary_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_import_summary_rel (
    account_import_summary_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_import_summary_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_import_summary_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_import_summary_rel IS 'RELATION BETWEEN account_import_summary AND account_account';


--
-- Name: account_account_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_journal_rel (
    account_account_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_account_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_journal_rel IS 'RELATION BETWEEN account_account AND account_journal';


--
-- Name: account_account_account_merge_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_merge_wizard_rel (
    account_merge_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_merge_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_merge_wizard_rel IS 'RELATION BETWEEN account_merge_wizard AND account_account';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_exclude_res_currency_provision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_exclude_res_currency_provision (
    account_account_id integer NOT NULL,
    res_currency_id integer NOT NULL
);


ALTER TABLE public.account_account_exclude_res_currency_provision OWNER TO runbot;

--
-- Name: TABLE account_account_exclude_res_currency_provision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_exclude_res_currency_provision IS 'RELATION BETWEEN account_account AND res_currency';


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_id_seq OWNER TO runbot;

--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_res_company_rel (
    account_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_res_company_rel IS 'RELATION BETWEEN account_account AND res_company';


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    color integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    applicability character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    tax_negate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.tax_negate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.tax_negate IS 'Negate Tax Balance';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_tax_repartition_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_tag_id_seq OWNER TO runbot;

--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tag_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_product_template_rel (
    product_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_product_template_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_product_template_rel IS 'RELATION BETWEEN product_template AND account_account_tag';


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_tax_default_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_accrued_orders_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_accrued_orders_wizard (
    id integer NOT NULL,
    company_id integer,
    journal_id integer NOT NULL,
    currency_id integer,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_accrued_orders_wizard OWNER TO runbot;

--
-- Name: TABLE account_accrued_orders_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_accrued_orders_wizard IS 'Accrued Orders Wizard';


--
-- Name: COLUMN account_accrued_orders_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrued_orders_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_accrued_orders_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.currency_id IS 'Company Currency';


--
-- Name: COLUMN account_accrued_orders_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.account_id IS 'Accrual Account';


--
-- Name: COLUMN account_accrued_orders_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrued_orders_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrued_orders_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrued_orders_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_accrued_orders_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.amount IS 'Amount';


--
-- Name: COLUMN account_accrued_orders_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrued_orders_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_accrued_orders_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNER TO runbot;

--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNED BY public.account_accrued_orders_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_account OWNER TO runbot;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: account_analytic_account_account_transfer_model_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account_account_transfer_model_line_rel (
    account_transfer_model_line_id integer NOT NULL,
    account_analytic_account_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_account_transfer_model_line_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_account_account_transfer_model_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account_account_transfer_model_line_rel IS 'RELATION BETWEEN account_transfer_model_line AND account_analytic_account';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO runbot;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_applicability OWNER TO runbot;

--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_applicability.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_applicability.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.account_prefix IS 'Financial Accounts Prefixes';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNER TO runbot;

--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    sequence integer,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_distribution_model OWNER TO runbot;

--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_distribution_model.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_distribution_model.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_distribution_model.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.account_prefix IS 'Accounts Prefix';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNER TO runbot;

--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    account_id integer,
    product_uom_id integer,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision,
    x_plan2_id integer,
    x_plan3_id integer,
    product_id integer,
    general_account_id integer,
    journal_id integer,
    move_line_id integer,
    code character varying(8),
    ref character varying,
    so_line integer
);


ALTER TABLE public.account_analytic_line OWNER TO runbot;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Project Account';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_line.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan3_id IS 'Internal';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.journal_id IS 'Financial Journal';


--
-- Name: COLUMN account_analytic_line.move_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.move_line_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_line_stock_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_stock_move_rel (
    stock_move_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_stock_move_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_stock_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_stock_move_rel IS 'RELATION BETWEEN stock_move AND account_analytic_line';


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    complete_name character varying,
    name jsonb NOT NULL,
    default_applicability jsonb,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    x_plan2_id integer,
    x_plan3_id integer
);


ALTER TABLE public.account_analytic_plan OWNER TO runbot;

--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_plan.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_plan.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.x_plan3_id IS 'Internal';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_plan_id_seq OWNER TO runbot;

--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: account_ar_vat_line; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.account_ar_vat_line AS
SELECT
    NULL::text AS column_group_key,
    NULL::integer AS id,
    NULL::character varying AS cuit,
    NULL::character varying AS afip_responsibility_type_name,
    NULL::character varying AS partner_name,
    NULL::character varying AS tax_type,
    NULL::integer AS move_id,
    NULL::character varying AS move_type,
    NULL::date AS date,
    NULL::date AS invoice_date,
    NULL::integer AS partner_id,
    NULL::integer AS journal_id,
    NULL::character varying AS move_name,
    NULL::integer AS afip_responsibility_type_id,
    NULL::integer AS document_type_id,
    NULL::character varying AS state,
    NULL::integer AS company_id,
    NULL::numeric AS taxed,
    NULL::numeric AS base_10,
    NULL::numeric AS vat_10,
    NULL::numeric AS base_21,
    NULL::numeric AS vat_21,
    NULL::numeric AS base_27,
    NULL::numeric AS vat_27,
    NULL::numeric AS base_5,
    NULL::numeric AS vat_5,
    NULL::numeric AS base_25,
    NULL::numeric AS vat_25,
    NULL::numeric AS not_taxed,
    NULL::numeric AS vat_per,
    NULL::numeric AS perc_iibb,
    NULL::numeric AS perc_earnings,
    NULL::numeric AS city_tax,
    NULL::numeric AS other_taxes,
    NULL::numeric AS total;


ALTER VIEW public.account_ar_vat_line OWNER TO runbot;

--
-- Name: account_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_asset (
    id integer NOT NULL,
    company_id integer NOT NULL,
    currency_id integer,
    method_number integer,
    account_asset_id integer,
    asset_group_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    journal_id integer,
    model_id integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    method character varying,
    method_period character varying,
    prorata_computation_type character varying NOT NULL,
    prorata_date date NOT NULL,
    acquisition_date date,
    disposal_date date,
    analytic_distribution jsonb,
    asset_properties_definition jsonb,
    asset_properties jsonb,
    original_value numeric,
    book_value numeric,
    salvage_value numeric,
    non_deductible_tax_value numeric,
    already_depreciated_amount_import numeric,
    net_gain_on_sale numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    method_progress_factor double precision,
    salvage_value_pct double precision,
    asset_paused_days double precision,
    location_id integer,
    expedient_id integer,
    invoice_id integer,
    partner_id integer,
    enrollment character varying,
    reference character varying,
    serial_number character varying,
    asset_state character varying,
    observations text,
    transit boolean,
    comodato boolean,
    patrimonial boolean,
    reportable boolean
);


ALTER TABLE public.account_asset OWNER TO runbot;

--
-- Name: TABLE account_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_asset IS 'Asset/Revenue Recognition';


--
-- Name: COLUMN account_asset.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.company_id IS 'Company';


--
-- Name: COLUMN account_asset.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.currency_id IS 'Currency';


--
-- Name: COLUMN account_asset.method_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_number IS 'Duration';


--
-- Name: COLUMN account_asset.account_asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_asset_id IS 'Fixed Asset Account';


--
-- Name: COLUMN account_asset.asset_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_asset.account_depreciation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN account_asset.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN account_asset.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.journal_id IS 'Journal';


--
-- Name: COLUMN account_asset.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.model_id IS 'Model';


--
-- Name: COLUMN account_asset.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.parent_id IS 'Parent';


--
-- Name: COLUMN account_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.name IS 'Asset Name';


--
-- Name: COLUMN account_asset.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.state IS 'Status';


--
-- Name: COLUMN account_asset.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method IS 'Method';


--
-- Name: COLUMN account_asset.method_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN account_asset.prorata_computation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.prorata_computation_type IS 'Computation';


--
-- Name: COLUMN account_asset.prorata_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.prorata_date IS 'Prorata Date';


--
-- Name: COLUMN account_asset.acquisition_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.acquisition_date IS 'Acquisition Date';


--
-- Name: COLUMN account_asset.disposal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.disposal_date IS 'Disposal Date';


--
-- Name: COLUMN account_asset.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_asset.asset_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_properties_definition IS 'Model Properties';


--
-- Name: COLUMN account_asset.asset_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_properties IS 'Properties';


--
-- Name: COLUMN account_asset.original_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.original_value IS 'Original Value';


--
-- Name: COLUMN account_asset.book_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.book_value IS 'Book Value';


--
-- Name: COLUMN account_asset.salvage_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.salvage_value IS 'Not Depreciable Value';


--
-- Name: COLUMN account_asset.non_deductible_tax_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.non_deductible_tax_value IS 'Non Deductible Tax Value';


--
-- Name: COLUMN account_asset.already_depreciated_amount_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.already_depreciated_amount_import IS 'Already Depreciated Amount Import';


--
-- Name: COLUMN account_asset.net_gain_on_sale; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.net_gain_on_sale IS 'Net gain on sale';


--
-- Name: COLUMN account_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.active IS 'Active';


--
-- Name: COLUMN account_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.create_date IS 'Created on';


--
-- Name: COLUMN account_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_asset.method_progress_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_progress_factor IS 'Declining Factor';


--
-- Name: COLUMN account_asset.salvage_value_pct; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.salvage_value_pct IS 'Not Depreciable Value Percent';


--
-- Name: COLUMN account_asset.asset_paused_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_paused_days IS 'Asset Paused Days';


--
-- Name: COLUMN account_asset.location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.location_id IS 'Location';


--
-- Name: COLUMN account_asset.expedient_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.expedient_id IS 'Expedient';


--
-- Name: COLUMN account_asset.invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.invoice_id IS 'Invoice';


--
-- Name: COLUMN account_asset.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.partner_id IS 'Partner';


--
-- Name: COLUMN account_asset.enrollment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.enrollment IS 'Enrollment';


--
-- Name: COLUMN account_asset.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.reference IS 'Reference';


--
-- Name: COLUMN account_asset.serial_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.serial_number IS 'Serial Number';


--
-- Name: COLUMN account_asset.asset_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_state IS 'Asset State';


--
-- Name: COLUMN account_asset.observations; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.observations IS 'Observations';


--
-- Name: COLUMN account_asset.transit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.transit IS 'Transit';


--
-- Name: COLUMN account_asset.comodato; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.comodato IS 'Comodato?';


--
-- Name: COLUMN account_asset.patrimonial; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.patrimonial IS 'Patrimonial?';


--
-- Name: COLUMN account_asset.reportable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.reportable IS 'Reportable?';


--
-- Name: account_asset_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_asset_group (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_asset_group OWNER TO runbot;

--
-- Name: TABLE account_asset_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_asset_group IS 'Asset Group';


--
-- Name: COLUMN account_asset_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.company_id IS 'Company';


--
-- Name: COLUMN account_asset_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.name IS 'Name';


--
-- Name: COLUMN account_asset_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.create_date IS 'Created on';


--
-- Name: COLUMN account_asset_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.write_date IS 'Last Updated on';


--
-- Name: account_asset_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_asset_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_asset_group_id_seq OWNER TO runbot;

--
-- Name: account_asset_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_asset_group_id_seq OWNED BY public.account_asset_group.id;


--
-- Name: account_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_asset_id_seq OWNER TO runbot;

--
-- Name: account_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_asset_id_seq OWNED BY public.account_asset.id;


--
-- Name: account_auto_reconcile_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    search_mode character varying NOT NULL,
    from_date date,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_auto_reconcile_wizard OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard IS 'Account automatic reconciliation wizard';


--
-- Name: COLUMN account_auto_reconcile_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_auto_reconcile_wizard.search_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.search_mode IS 'Reconcile';


--
-- Name: COLUMN account_auto_reconcile_wizard.from_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.from_date IS 'From';


--
-- Name: COLUMN account_auto_reconcile_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.to_date IS 'To';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_auto_reconcile_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard_account_move_line_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_account_move_line_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_move_line';


--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_auto_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNER TO runbot;

--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNED BY public.account_auto_reconcile_wizard.id;


--
-- Name: account_auto_reconcile_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard_res_partner_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_res_partner_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND res_partner';


--
-- Name: account_automatic_entry_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    account_type character varying,
    date date NOT NULL,
    total_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage double precision
);


ALTER TABLE public.account_automatic_entry_wizard OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard IS 'Create Automatic Entries';


--
-- Name: COLUMN account_automatic_entry_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_automatic_entry_wizard.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.destination_account_id IS 'To';


--
-- Name: COLUMN account_automatic_entry_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_entry_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_automatic_entry_wizard.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.action IS 'Action';


--
-- Name: COLUMN account_automatic_entry_wizard.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_automatic_entry_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.date IS 'Date';


--
-- Name: COLUMN account_automatic_entry_wizard.total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.total_amount IS 'Total Amount';


--
-- Name: COLUMN account_automatic_entry_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_entry_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_automatic_entry_wizard.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.percentage IS 'Percentage';


--
-- Name: account_automatic_entry_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard_account_move_line_rel (
    account_automatic_entry_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_automatic_entry_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard_account_move_line_rel IS 'RELATION BETWEEN account_automatic_entry_wizard AND account_move_line';


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_automatic_entry_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNER TO runbot;

--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNED BY public.account_automatic_entry_wizard.id;


--
-- Name: account_autopost_bills_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_autopost_bills_wizard (
    id integer NOT NULL,
    partner_id integer,
    nb_unmodified_bills integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_autopost_bills_wizard OWNER TO runbot;

--
-- Name: TABLE account_autopost_bills_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_autopost_bills_wizard IS 'Autopost Bills Wizard';


--
-- Name: COLUMN account_autopost_bills_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN account_autopost_bills_wizard.nb_unmodified_bills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.nb_unmodified_bills IS 'Number of bills previously unmodified from this partner';


--
-- Name: COLUMN account_autopost_bills_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_autopost_bills_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_autopost_bills_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_autopost_bills_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_date IS 'Last Updated on';


--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_autopost_bills_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNER TO runbot;

--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNED BY public.account_autopost_bills_wizard.id;


--
-- Name: account_bank_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_selection (
    id integer NOT NULL,
    account_online_link_id integer,
    selected_account integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_selection OWNER TO runbot;

--
-- Name: TABLE account_bank_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_selection IS 'Link a bank account to the selected journal';


--
-- Name: COLUMN account_bank_selection.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_selection.selected_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.selected_account IS 'Selected Account';


--
-- Name: COLUMN account_bank_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.write_date IS 'Last Updated on';


--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_selection_id_seq OWNER TO runbot;

--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_selection_id_seq OWNED BY public.account_bank_selection.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    company_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    reference character varying,
    first_line_index character varying,
    date date,
    balance_start numeric,
    balance_end numeric,
    balance_end_real numeric,
    is_complete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    message_main_attachment_id integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    is_in_extractable_state boolean,
    extract_state_processed boolean
);


ALTER TABLE public.account_bank_statement OWNER TO runbot;

--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.first_line_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.first_line_index IS 'First Line Index';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.is_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_complete IS 'Is Complete';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_bank_statement.extract_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_state IS 'Extract state';


--
-- Name: COLUMN account_bank_statement.extract_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_status IS 'Extract status';


--
-- Name: COLUMN account_bank_statement.extract_document_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_bank_statement.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_bank_statement.extract_state_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_state_processed IS 'Extract State Processed';


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_ir_attachment_rel (
    account_bank_statement_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_bank_statement_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_ir_attachment_rel IS 'RELATION BETWEEN account_bank_statement AND ir_attachment';


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    statement_id integer,
    sequence integer,
    partner_id integer,
    currency_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    account_number character varying,
    partner_name character varying,
    transaction_type character varying,
    payment_ref character varying,
    internal_index character varying,
    transaction_details jsonb,
    amount numeric,
    amount_currency numeric,
    is_reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount_residual double precision,
    cron_last_check timestamp without time zone,
    unique_import_id character varying,
    online_account_id integer,
    online_link_id integer,
    online_transaction_identifier character varying,
    online_partner_information character varying
);


ALTER TABLE public.account_bank_statement_line OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Journal Currency';


--
-- Name: COLUMN account_bank_statement_line.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.payment_ref IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.internal_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.internal_index IS 'Internal Reference';


--
-- Name: COLUMN account_bank_statement_line.transaction_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_bank_statement_line.cron_last_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.cron_last_check IS 'Cron Last Check';


--
-- Name: COLUMN account_bank_statement_line.unique_import_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.unique_import_id IS 'Import ID';


--
-- Name: COLUMN account_bank_statement_line.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_account_id IS 'Online Account';


--
-- Name: COLUMN account_bank_statement_line.online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_statement_line.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line.online_partner_information; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_partner_information IS 'Online Partner Information';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_bank_statement_line_transient; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line_transient (
    id integer NOT NULL,
    sequence integer,
    journal_id integer,
    online_account_id integer,
    company_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    online_transaction_identifier character varying,
    payment_ref character varying,
    account_number character varying,
    partner_name character varying,
    state character varying,
    date date,
    transaction_details text,
    amount numeric,
    amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_statement_line_transient OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line_transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line_transient IS 'Transient model for bank statement line';


--
-- Name: COLUMN account_bank_statement_line_transient.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line_transient.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line_transient.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_bank_statement_line_transient.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line_transient.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line_transient.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line_transient.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line_transient.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.payment_ref IS 'Payment Ref';


--
-- Name: COLUMN account_bank_statement_line_transient.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.account_number IS 'Account Number';


--
-- Name: COLUMN account_bank_statement_line_transient.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line_transient.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.state IS 'State';


--
-- Name: COLUMN account_bank_statement_line_transient.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.date IS 'Date';


--
-- Name: COLUMN account_bank_statement_line_transient.transaction_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line_transient.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line_transient.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line_transient.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_transient_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNED BY public.account_bank_statement_line_transient.id;


--
-- Name: account_batch_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard (
    id integer NOT NULL,
    batch_payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_remove_options boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard IS 'Batch payments error reporting wizard';


--
-- Name: COLUMN account_batch_error_wizard.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_batch_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard.show_remove_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.show_remove_options IS 'Show Remove Options';


--
-- Name: COLUMN account_batch_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNED BY public.account_batch_error_wizard.id;


--
-- Name: account_batch_error_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line (
    id integer NOT NULL,
    error_wizard_id integer,
    warning_wizard_id integer,
    create_uid integer,
    write_uid integer,
    description character varying NOT NULL,
    help_message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line IS 'Batch payments error reporting wizard line';


--
-- Name: COLUMN account_batch_error_wizard_line.error_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.error_wizard_id IS 'Error Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.warning_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.warning_wizard_id IS 'Warning Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.description IS 'Description';


--
-- Name: COLUMN account_batch_error_wizard_line.help_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.help_message IS 'Help';


--
-- Name: COLUMN account_batch_error_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_line_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line_account_payment_rel (
    account_batch_error_wizard_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_error_wizard_line_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line_account_payment_rel IS 'RELATION BETWEEN account_batch_error_wizard_line AND account_payment';


--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNED BY public.account_batch_error_wizard_line.id;


--
-- Name: account_batch_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment (
    id integer NOT NULL,
    journal_id integer,
    currency_id integer,
    company_currency_id integer,
    payment_method_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    batch_type character varying NOT NULL,
    export_filename character varying,
    date date NOT NULL,
    export_file_create_date date,
    amount_residual numeric,
    amount_residual_currency numeric,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_payment OWNER TO runbot;

--
-- Name: TABLE account_batch_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment IS 'Batch Payment';


--
-- Name: COLUMN account_batch_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.journal_id IS 'Bank';


--
-- Name: COLUMN account_batch_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_batch_payment.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_batch_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_batch_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.name IS 'Reference';


--
-- Name: COLUMN account_batch_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.state IS 'State';


--
-- Name: COLUMN account_batch_payment.batch_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.batch_type IS 'Batch Type';


--
-- Name: COLUMN account_batch_payment.export_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_filename IS 'File Name';


--
-- Name: COLUMN account_batch_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.date IS 'Date';


--
-- Name: COLUMN account_batch_payment.export_file_create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_file_create_date IS 'Generation Date';


--
-- Name: COLUMN account_batch_payment.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual IS 'Amount Residual';


--
-- Name: COLUMN account_batch_payment.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual_currency IS 'Amount Residual Currency';


--
-- Name: COLUMN account_batch_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount IS 'Amount';


--
-- Name: COLUMN account_batch_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_date IS 'Last Updated on';


--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_id_seq OWNER TO runbot;

--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_payment_id_seq OWNED BY public.account_batch_payment.id;


--
-- Name: account_batch_payment_rejection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment_rejection (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_payment_rejection OWNER TO runbot;

--
-- Name: TABLE account_batch_payment_rejection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment_rejection IS 'Manage the payment rejection from batch payments';


--
-- Name: COLUMN account_batch_payment_rejection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment_rejection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment_rejection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment_rejection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.write_date IS 'Last Updated on';


--
-- Name: account_batch_payment_rejection_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment_rejection_account_payment_rel (
    account_batch_payment_rejection_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_payment_rejection_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_batch_payment_rejection_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment_rejection_account_payment_rel IS 'RELATION BETWEEN account_batch_payment_rejection AND account_payment';


--
-- Name: account_batch_payment_rejection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_payment_rejection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_rejection_id_seq OWNER TO runbot;

--
-- Name: account_batch_payment_rejection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_payment_rejection_id_seq OWNED BY public.account_batch_payment_rejection.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    strategy character varying NOT NULL,
    rounding_method character varying NOT NULL,
    name jsonb NOT NULL,
    profit_account_id jsonb,
    loss_account_id jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rounding double precision NOT NULL
);


ALTER TABLE public.account_cash_rounding OWNER TO runbot;

--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_cash_rounding.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cash_rounding_id_seq OWNER TO runbot;

--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_change_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_currency (
    id integer NOT NULL,
    currency_to_id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    conversion_rate numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_currency OWNER TO runbot;

--
-- Name: TABLE account_change_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_currency IS 'Change Currency';


--
-- Name: COLUMN account_change_currency.currency_to_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.currency_to_id IS 'Currency to';


--
-- Name: COLUMN account_change_currency.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.move_id IS 'Move';


--
-- Name: COLUMN account_change_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_currency.conversion_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.conversion_rate IS 'Conversion Rate';


--
-- Name: COLUMN account_change_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_date IS 'Created on';


--
-- Name: COLUMN account_change_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_date IS 'Last Updated on';


--
-- Name: account_change_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_currency_id_seq OWNER TO runbot;

--
-- Name: account_change_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_currency_id_seq OWNED BY public.account_change_currency.id;


--
-- Name: account_change_lock_date; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_lock_date (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    exception_applies_to character varying NOT NULL,
    exception_duration character varying NOT NULL,
    exception_reason character varying,
    fiscalyear_lock_date date,
    tax_lock_date date,
    sale_lock_date date,
    purchase_lock_date date,
    hard_lock_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_lock_date OWNER TO runbot;

--
-- Name: TABLE account_change_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_lock_date IS 'Change Lock Date';


--
-- Name: COLUMN account_change_lock_date.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.company_id IS 'Company';


--
-- Name: COLUMN account_change_lock_date.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_lock_date.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_lock_date.exception_applies_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_applies_to IS 'Exception applies';


--
-- Name: COLUMN account_change_lock_date.exception_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_duration IS 'Exception Duration';


--
-- Name: COLUMN account_change_lock_date.exception_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_reason IS 'Exception Reason';


--
-- Name: COLUMN account_change_lock_date.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.fiscalyear_lock_date IS 'Lock Everything';


--
-- Name: COLUMN account_change_lock_date.tax_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.tax_lock_date IS 'Lock Tax Return';


--
-- Name: COLUMN account_change_lock_date.sale_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.sale_lock_date IS 'Lock Sales';


--
-- Name: COLUMN account_change_lock_date.purchase_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.purchase_lock_date IS 'Lock Purchases';


--
-- Name: COLUMN account_change_lock_date.hard_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.hard_lock_date IS 'Hard Lock';


--
-- Name: COLUMN account_change_lock_date.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_date IS 'Created on';


--
-- Name: COLUMN account_change_lock_date.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_date IS 'Last Updated on';


--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_lock_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_lock_date_id_seq OWNER TO runbot;

--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_lock_date_id_seq OWNED BY public.account_change_lock_date.id;


--
-- Name: account_check_action_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_action_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_action_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_action_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_action_wizard IS 'Account Check Action Wizard';


--
-- Name: COLUMN account_check_action_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_action_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_action_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.date IS 'Date';


--
-- Name: COLUMN account_check_action_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_action_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_action_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNED BY public.account_check_action_wizard.id;


--
-- Name: account_check_to_date_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_to_date_report_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_to_date_report_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_to_date_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_to_date_report_wizard IS 'account.check.to_date.report.wizard';


--
-- Name: COLUMN account_check_to_date_report_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.journal_id IS 'Diario';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_to_date_report_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.to_date IS 'Hasta Fecha';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_to_date_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNED BY public.account_check_to_date_report_wizard.id;


--
-- Name: account_debit_note; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_debit_note (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date NOT NULL,
    copy_lines boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_debit_note OWNER TO runbot;

--
-- Name: TABLE account_debit_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_debit_note IS 'Add Debit Note wizard';


--
-- Name: COLUMN account_debit_note.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.journal_id IS 'Use Specific Journal';


--
-- Name: COLUMN account_debit_note.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_uid IS 'Created by';


--
-- Name: COLUMN account_debit_note.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_debit_note.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.reason IS 'Reason';


--
-- Name: COLUMN account_debit_note.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.date IS 'Debit Note Date';


--
-- Name: COLUMN account_debit_note.copy_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.copy_lines IS 'Copy Lines';


--
-- Name: COLUMN account_debit_note.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_date IS 'Created on';


--
-- Name: COLUMN account_debit_note.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_date IS 'Last Updated on';


--
-- Name: account_debit_note_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_debit_note_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_debit_note_id_seq OWNER TO runbot;

--
-- Name: account_debit_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_debit_note_id_seq OWNED BY public.account_debit_note.id;


--
-- Name: account_disallowed_expenses_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_disallowed_expenses_category (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_disallowed_expenses_category OWNER TO runbot;

--
-- Name: TABLE account_disallowed_expenses_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_disallowed_expenses_category IS 'Disallowed Expenses Category';


--
-- Name: COLUMN account_disallowed_expenses_category.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.company_id IS 'Company';


--
-- Name: COLUMN account_disallowed_expenses_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.create_uid IS 'Created by';


--
-- Name: COLUMN account_disallowed_expenses_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_disallowed_expenses_category.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.code IS 'Code';


--
-- Name: COLUMN account_disallowed_expenses_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.name IS 'Name';


--
-- Name: COLUMN account_disallowed_expenses_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.active IS 'Active';


--
-- Name: COLUMN account_disallowed_expenses_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.create_date IS 'Created on';


--
-- Name: COLUMN account_disallowed_expenses_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.write_date IS 'Last Updated on';


--
-- Name: account_disallowed_expenses_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_disallowed_expenses_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_disallowed_expenses_category_id_seq OWNER TO runbot;

--
-- Name: account_disallowed_expenses_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_disallowed_expenses_category_id_seq OWNED BY public.account_disallowed_expenses_category.id;


--
-- Name: account_disallowed_expenses_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_disallowed_expenses_rate (
    id integer NOT NULL,
    category_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rate double precision NOT NULL
);


ALTER TABLE public.account_disallowed_expenses_rate OWNER TO runbot;

--
-- Name: TABLE account_disallowed_expenses_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_disallowed_expenses_rate IS 'Disallowed Expenses Rate';


--
-- Name: COLUMN account_disallowed_expenses_rate.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.category_id IS 'Category';


--
-- Name: COLUMN account_disallowed_expenses_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.company_id IS 'Company';


--
-- Name: COLUMN account_disallowed_expenses_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_disallowed_expenses_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_disallowed_expenses_rate.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.date_from IS 'Start Date';


--
-- Name: COLUMN account_disallowed_expenses_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_disallowed_expenses_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_disallowed_expenses_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.rate IS 'Disallowed %';


--
-- Name: account_disallowed_expenses_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_disallowed_expenses_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_disallowed_expenses_rate_id_seq OWNER TO runbot;

--
-- Name: account_disallowed_expenses_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_disallowed_expenses_rate_id_seq OWNED BY public.account_disallowed_expenses_rate.id;


--
-- Name: account_duplicate_transaction_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_duplicate_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_duplicate_transaction_wizard OWNER TO runbot;

--
-- Name: TABLE account_duplicate_transaction_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_duplicate_transaction_wizard IS 'Wizard for duplicate transactions';


--
-- Name: COLUMN account_duplicate_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_duplicate_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNER TO runbot;

--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNED BY public.account_duplicate_transaction_wizard.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_financial_year_op OWNER TO runbot;

--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_financial_year_op_id_seq OWNER TO runbot;

--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    country_id integer,
    country_group_id integer,
    create_uid integer,
    write_uid integer,
    zip_from character varying,
    zip_to character varying,
    foreign_vat character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    auto_apply boolean,
    vat_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    avatax_invoice_account_id integer,
    avatax_refund_account_id integer,
    is_avatax boolean
);


ALTER TABLE public.account_fiscal_position OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.foreign_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.foreign_vat IS 'Foreign Tax ID';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position.avatax_invoice_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_invoice_account_id IS 'Avatax Invoice Account';


--
-- Name: COLUMN account_fiscal_position.avatax_refund_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_refund_account_id IS 'Avatax Refund Account';


--
-- Name: COLUMN account_fiscal_position.is_avatax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.is_avatax IS 'Use AvaTax API';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_l10n_ar_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_l10n_ar_tax (
    id integer NOT NULL,
    fiscal_position_id integer NOT NULL,
    default_tax_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    webservice character varying,
    tax_type character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_l10n_ar_tax OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_l10n_ar_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_l10n_ar_tax IS 'account.fiscal.position.l10n_ar_tax';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.default_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.default_tax_id IS 'Default Tax';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.webservice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.webservice IS 'Webservice';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.tax_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.tax_type IS 'Tax Type';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_l10n_ar_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_l10n_ar_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq OWNED BY public.account_fiscal_position_l10n_ar_tax.id;


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_position_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_tax (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_tax OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_tax IS 'Tax Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_tax.tax_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_src_id IS 'Tax on Product';


--
-- Name: COLUMN account_fiscal_position_tax.tax_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_dest_id IS 'Tax to Apply';


--
-- Name: COLUMN account_fiscal_position_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNED BY public.account_fiscal_position_tax.id;


--
-- Name: account_fiscal_year; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_year (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_year OWNER TO runbot;

--
-- Name: TABLE account_fiscal_year; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_year IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscal_year.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_year.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_year.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_year.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.name IS 'Name';


--
-- Name: COLUMN account_fiscal_year.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_from IS 'Start Date';


--
-- Name: COLUMN account_fiscal_year.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_to IS 'End Date';


--
-- Name: COLUMN account_fiscal_year.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_year.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_year_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_year_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_year_id_seq OWNED BY public.account_fiscal_year.id;


--
-- Name: account_followup_followup_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_followup_line (
    id integer NOT NULL,
    delay integer NOT NULL,
    company_id integer NOT NULL,
    mail_template_id integer,
    sms_template_id integer,
    activity_type_id integer,
    create_uid integer,
    write_uid integer,
    activity_summary character varying,
    activity_default_responsible_type character varying NOT NULL,
    name jsonb NOT NULL,
    activity_note text,
    send_email boolean,
    join_invoices boolean,
    send_sms boolean,
    create_activity boolean,
    auto_execute boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    send_letter boolean
);


ALTER TABLE public.account_followup_followup_line OWNER TO runbot;

--
-- Name: TABLE account_followup_followup_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_followup_line IS 'Follow-up Criteria';


--
-- Name: COLUMN account_followup_followup_line.delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.delay IS 'Due Days';


--
-- Name: COLUMN account_followup_followup_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.company_id IS 'Company';


--
-- Name: COLUMN account_followup_followup_line.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.mail_template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_followup_line.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_followup_line.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN account_followup_followup_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_followup_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_followup_line.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_summary IS 'Summary';


--
-- Name: COLUMN account_followup_followup_line.activity_default_responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_default_responsible_type IS 'Responsible';


--
-- Name: COLUMN account_followup_followup_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.name IS 'Description';


--
-- Name: COLUMN account_followup_followup_line.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_note IS 'Note';


--
-- Name: COLUMN account_followup_followup_line.send_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_email IS 'Send Email';


--
-- Name: COLUMN account_followup_followup_line.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_followup_line.send_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_sms IS 'Send SMS Message';


--
-- Name: COLUMN account_followup_followup_line.create_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_activity IS 'Schedule Activity';


--
-- Name: COLUMN account_followup_followup_line.auto_execute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.auto_execute IS 'Automatic';


--
-- Name: COLUMN account_followup_followup_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_followup_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_followup_line.send_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_letter IS 'Send a Letter';


--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_followup_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNER TO runbot;

--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNED BY public.account_followup_followup_line.id;


--
-- Name: account_followup_followup_line_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_followup_line_res_users_rel (
    account_followup_followup_line_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.account_followup_followup_line_res_users_rel OWNER TO runbot;

--
-- Name: TABLE account_followup_followup_line_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_followup_line_res_users_rel IS 'RELATION BETWEEN account_followup_followup_line AND res_users';


--
-- Name: account_followup_manual_reminder; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder (
    id integer NOT NULL,
    template_id integer,
    partner_id integer,
    sms_template_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    sms_body character varying,
    body text,
    email boolean,
    sms boolean,
    print boolean,
    join_invoices boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    snailmail boolean
);


ALTER TABLE public.account_followup_manual_reminder OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder IS 'Wizard for sending manual reminders to clients';


--
-- Name: COLUMN account_followup_manual_reminder.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_manual_reminder.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.partner_id IS 'Partner';


--
-- Name: COLUMN account_followup_manual_reminder.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_manual_reminder.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_manual_reminder.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_manual_reminder.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.lang IS 'Language';


--
-- Name: COLUMN account_followup_manual_reminder.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.subject IS 'Subject';


--
-- Name: COLUMN account_followup_manual_reminder.sms_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_body IS 'Sms Body';


--
-- Name: COLUMN account_followup_manual_reminder.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.body IS 'Contents';


--
-- Name: COLUMN account_followup_manual_reminder.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.email IS 'Email';


--
-- Name: COLUMN account_followup_manual_reminder.sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms IS 'Sms';


--
-- Name: COLUMN account_followup_manual_reminder.print; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.print IS 'Print';


--
-- Name: COLUMN account_followup_manual_reminder.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_manual_reminder.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_manual_reminder.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_manual_reminder.snailmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.snailmail IS 'Snailmail';


--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_manual_reminder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNER TO runbot;

--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNED BY public.account_followup_manual_reminder.id;


--
-- Name: account_followup_manual_reminder_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder_ir_attachment_rel (
    account_followup_manual_reminder_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_followup_manual_reminder_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder_ir_attachment_rel IS 'RELATION BETWEEN account_followup_manual_reminder AND ir_attachment';


--
-- Name: account_followup_missing_information_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_missing_information_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_followup_missing_information_wizard OWNER TO runbot;

--
-- Name: TABLE account_followup_missing_information_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_missing_information_wizard IS 'Followup missing information wizard';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_date IS 'Last Updated on';


--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_missing_information_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNER TO runbot;

--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNED BY public.account_followup_missing_information_wizard.id;


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    exchange_move_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_full_reconcile OWNER TO runbot;

--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_full_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code_prefix_start character varying,
    code_prefix_end character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_group_check_length_prefix CHECK ((char_length((COALESCE(code_prefix_start, ''::character varying))::text) = char_length((COALESCE(code_prefix_end, ''::character varying))::text)))
);


ALTER TABLE public.account_group OWNER TO runbot;

--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.company_id IS 'Company';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.code_prefix_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group.code_prefix_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_group_check_length_prefix ON account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_group_check_length_prefix ON public.account_group IS 'CHECK(char_length(COALESCE(code_prefix_start, '''')) = char_length(COALESCE(code_prefix_end, '''')))';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_id_seq OWNER TO runbot;

--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_import_summary; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    import_summary_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_import_summary OWNER TO runbot;

--
-- Name: TABLE account_import_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary IS 'Account import summary view';


--
-- Name: COLUMN account_import_summary.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.create_uid IS 'Created by';


--
-- Name: COLUMN account_import_summary.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_import_summary.import_summary_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.import_summary_name IS 'Import Summary Name';


--
-- Name: COLUMN account_import_summary.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.create_date IS 'Created on';


--
-- Name: COLUMN account_import_summary.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.write_date IS 'Last Updated on';


--
-- Name: account_import_summary_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_account_journal_rel (
    account_import_summary_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_account_journal_rel IS 'RELATION BETWEEN account_import_summary AND account_journal';


--
-- Name: account_import_summary_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_account_move_rel (
    account_import_summary_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_account_move_rel IS 'RELATION BETWEEN account_import_summary AND account_move';


--
-- Name: account_import_summary_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_account_tax_rel (
    account_import_summary_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_account_tax_rel IS 'RELATION BETWEEN account_import_summary AND account_tax';


--
-- Name: account_import_summary_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_import_summary_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_import_summary_id_seq OWNER TO runbot;

--
-- Name: account_import_summary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_import_summary_id_seq OWNED BY public.account_import_summary.id;


--
-- Name: account_import_summary_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_res_partner_rel (
    account_import_summary_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_res_partner_rel IS 'RELATION BETWEEN account_import_summary AND res_partner';


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying(3) NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_incoterms OWNER TO runbot;

--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_incoterms_id_seq OWNER TO runbot;

--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_invoice_extract_words; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_extract_words (
    id integer NOT NULL,
    invoice_id integer NOT NULL,
    word_page integer,
    create_uid integer,
    write_uid integer,
    field character varying,
    word_text character varying,
    ocr_selected boolean,
    user_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "word_box_midX" double precision,
    "word_box_midY" double precision,
    word_box_width double precision,
    word_box_height double precision,
    word_box_angle double precision
);


ALTER TABLE public.account_invoice_extract_words OWNER TO runbot;

--
-- Name: TABLE account_invoice_extract_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_extract_words IS 'Extracted words from invoice scan';


--
-- Name: COLUMN account_invoice_extract_words.invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.invoice_id IS 'Invoice';


--
-- Name: COLUMN account_invoice_extract_words.word_page; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_page IS 'Word Page';


--
-- Name: COLUMN account_invoice_extract_words.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_extract_words.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_extract_words.field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.field IS 'Field';


--
-- Name: COLUMN account_invoice_extract_words.word_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_text IS 'Word Text';


--
-- Name: COLUMN account_invoice_extract_words.ocr_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.ocr_selected IS 'Ocr Selected';


--
-- Name: COLUMN account_invoice_extract_words.user_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.user_selected IS 'User Selected';


--
-- Name: COLUMN account_invoice_extract_words.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_extract_words.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midX"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midX" IS 'Word Box Midx';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midY"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midY" IS 'Word Box Midy';


--
-- Name: COLUMN account_invoice_extract_words.word_box_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_width IS 'Word Box Width';


--
-- Name: COLUMN account_invoice_extract_words.word_box_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_height IS 'Word Box Height';


--
-- Name: COLUMN account_invoice_extract_words.word_box_angle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_angle IS 'Word Box Angle';


--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_extract_words_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_extract_words_id_seq OWNER TO runbot;

--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_extract_words_id_seq OWNED BY public.account_invoice_extract_words.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_transaction_rel (
    invoice_id integer NOT NULL,
    transaction_id integer NOT NULL
);


ALTER TABLE public.account_invoice_transaction_rel OWNER TO runbot;

--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN account_move AND payment_transaction';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    alias_id integer,
    default_account_id integer,
    suspense_account_id integer,
    sequence integer,
    currency_id integer,
    company_id integer NOT NULL,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    create_uid integer,
    write_uid integer,
    color integer,
    access_token character varying,
    code character varying(5) NOT NULL,
    type character varying NOT NULL,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    bank_statements_source character varying,
    name jsonb NOT NULL,
    sequence_override_regex text,
    active boolean,
    autocheck_on_post boolean,
    restrict_mode_hash_table boolean,
    refund_sequence boolean,
    payment_sequence boolean,
    show_on_dashboard boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    debit_sequence boolean,
    account_online_account_id integer,
    account_online_link_id integer,
    renewal_contact_email character varying,
    l10n_latam_use_documents boolean,
    nacha_immediate_destination character varying,
    nacha_destination character varying,
    nacha_immediate_origin character varying,
    nacha_company_identification character varying,
    nacha_origination_dfi_identification character varying,
    nacha_entry_class_code character varying NOT NULL,
    nacha_discretionary_data character varying(20),
    nacha_is_balanced boolean,
    mail_template_id integer,
    l10n_ar_afip_pos_number integer,
    l10n_ar_afip_pos_partner_id integer,
    l10n_ar_afip_pos_system character varying,
    l10n_ar_is_pos boolean,
    settlement_partner_id integer,
    settlement_account_id integer,
    tax_settlement character varying,
    settlement_tax character varying,
    qr_code_label character varying,
    qr_code character varying,
    discriminate_taxes character varying NOT NULL,
    check_add_debit_button boolean,
    loan_properties_definition jsonb,
    max_statement_operation double precision
);


ALTER TABLE public.account_journal OWNER TO runbot;

--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Alias';


--
-- Name: COLUMN account_journal.default_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.default_account_id IS 'Default Account';


--
-- Name: COLUMN account_journal.suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.suspense_account_id IS 'Suspense Account';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.access_token IS 'Security Token';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.code IS 'Short Code';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.sequence_override_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence_override_regex IS 'Sequence Override Regex';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.autocheck_on_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.autocheck_on_post IS 'Auto-Check on Post';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Secure Posted Entries with Hash';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.payment_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.payment_sequence IS 'Dedicated Payment Sequence';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal.debit_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.debit_sequence IS 'Dedicated Debit Note Sequence';


--
-- Name: COLUMN account_journal.account_online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_journal.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_journal.renewal_contact_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.renewal_contact_email IS 'Connection Requests';


--
-- Name: COLUMN account_journal.l10n_latam_use_documents; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_latam_use_documents IS 'Use Documents?';


--
-- Name: COLUMN account_journal.nacha_immediate_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_destination IS 'Immediate Destination';


--
-- Name: COLUMN account_journal.nacha_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_destination IS 'Destination';


--
-- Name: COLUMN account_journal.nacha_immediate_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_origin IS 'Immediate Origin';


--
-- Name: COLUMN account_journal.nacha_company_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_company_identification IS 'Company Identification';


--
-- Name: COLUMN account_journal.nacha_origination_dfi_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_origination_dfi_identification IS 'Origination Dfi Identification';


--
-- Name: COLUMN account_journal.nacha_entry_class_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_entry_class_code IS 'Standard Entry Class Code';


--
-- Name: COLUMN account_journal.nacha_discretionary_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_discretionary_data IS 'Company Discretionary Data';


--
-- Name: COLUMN account_journal.nacha_is_balanced; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_is_balanced IS 'Generate Balanced Files';


--
-- Name: COLUMN account_journal.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.mail_template_id IS 'Email Template';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_number IS 'AFIP POS Number';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_partner_id IS 'AFIP POS Address';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_system; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_system IS 'AFIP POS System';


--
-- Name: COLUMN account_journal.l10n_ar_is_pos; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_is_pos IS 'Is AFIP POS?';


--
-- Name: COLUMN account_journal.settlement_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.settlement_partner_id IS 'Partner de liquidación';


--
-- Name: COLUMN account_journal.settlement_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.settlement_account_id IS 'Cuenta de contrapartida';


--
-- Name: COLUMN account_journal.tax_settlement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.tax_settlement IS 'Tax Settlement';


--
-- Name: COLUMN account_journal.settlement_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.settlement_tax IS 'Impuesto de liquidación';


--
-- Name: COLUMN account_journal.qr_code_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code_label IS 'QR Code Label';


--
-- Name: COLUMN account_journal.qr_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code IS 'QR Code';


--
-- Name: COLUMN account_journal.discriminate_taxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.discriminate_taxes IS 'Discriminate taxes?';


--
-- Name: COLUMN account_journal.check_add_debit_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_add_debit_button IS 'Agregar botón de débito';


--
-- Name: COLUMN account_journal.loan_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loan_properties_definition IS 'Model Properties';


--
-- Name: COLUMN account_journal.max_statement_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.max_statement_operation IS 'Max Statement Operation';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_journal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_tag (
    account_journal_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_tag OWNER TO runbot;

--
-- Name: TABLE account_journal_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_tag IS 'RELATION BETWEEN account_journal AND account_account_tag';


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_group OWNER TO runbot;

--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Ledger group';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_group_id_seq OWNER TO runbot;

--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_id_seq OWNER TO runbot;

--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_loan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan (
    id integer NOT NULL,
    company_id integer NOT NULL,
    duration integer,
    long_term_account_id integer,
    short_term_account_id integer,
    expense_account_id integer,
    journal_id integer,
    asset_group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    display_name character varying,
    date date,
    skip_until_date date,
    loan_properties jsonb,
    amount_borrowed numeric,
    interest numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan OWNER TO runbot;

--
-- Name: TABLE account_loan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan IS 'Loan';


--
-- Name: COLUMN account_loan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.company_id IS 'Company';


--
-- Name: COLUMN account_loan.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.duration IS 'Duration';


--
-- Name: COLUMN account_loan.long_term_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.long_term_account_id IS 'Long Term Account';


--
-- Name: COLUMN account_loan.short_term_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.short_term_account_id IS 'Short Term Account';


--
-- Name: COLUMN account_loan.expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.expense_account_id IS 'Expense Account';


--
-- Name: COLUMN account_loan.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.journal_id IS 'Journal';


--
-- Name: COLUMN account_loan.asset_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_loan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.name IS 'Name';


--
-- Name: COLUMN account_loan.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.state IS 'Status';


--
-- Name: COLUMN account_loan.display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.display_name IS 'Loan name';


--
-- Name: COLUMN account_loan.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.date IS 'Loan Date';


--
-- Name: COLUMN account_loan.skip_until_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.skip_until_date IS 'Skip until';


--
-- Name: COLUMN account_loan.loan_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.loan_properties IS 'Properties';


--
-- Name: COLUMN account_loan.amount_borrowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.amount_borrowed IS 'Amount Borrowed';


--
-- Name: COLUMN account_loan.interest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.interest IS 'Interest';


--
-- Name: COLUMN account_loan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.active IS 'Active';


--
-- Name: COLUMN account_loan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.create_date IS 'Created on';


--
-- Name: COLUMN account_loan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_close_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_close_wizard OWNER TO runbot;

--
-- Name: TABLE account_loan_close_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_close_wizard IS 'Close Loan Wizard';


--
-- Name: COLUMN account_loan_close_wizard.loan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_close_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_close_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_close_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.date IS 'Close Date';


--
-- Name: COLUMN account_loan_close_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_close_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_close_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_close_wizard_id_seq OWNER TO runbot;

--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_close_wizard_id_seq OWNED BY public.account_loan_close_wizard.id;


--
-- Name: account_loan_compute_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_compute_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    loan_term integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_end_of_month character varying NOT NULL,
    compounding_method character varying NOT NULL,
    start_date date NOT NULL,
    first_payment_date date NOT NULL,
    loan_amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    interest_rate double precision NOT NULL
);


ALTER TABLE public.account_loan_compute_wizard OWNER TO runbot;

--
-- Name: TABLE account_loan_compute_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_compute_wizard IS 'Loan Compute Wizard';


--
-- Name: COLUMN account_loan_compute_wizard.loan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_compute_wizard.loan_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_term IS 'Loan Term';


--
-- Name: COLUMN account_loan_compute_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_compute_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_compute_wizard.payment_end_of_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.payment_end_of_month IS 'Payment';


--
-- Name: COLUMN account_loan_compute_wizard.compounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.compounding_method IS 'Compounding Method';


--
-- Name: COLUMN account_loan_compute_wizard.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.start_date IS 'Start Date';


--
-- Name: COLUMN account_loan_compute_wizard.first_payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.first_payment_date IS 'First Payment';


--
-- Name: COLUMN account_loan_compute_wizard.loan_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_amount IS 'Loan Amount';


--
-- Name: COLUMN account_loan_compute_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_compute_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_loan_compute_wizard.interest_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.interest_rate IS 'Interest Rate';


--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_compute_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_compute_wizard_id_seq OWNER TO runbot;

--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_compute_wizard_id_seq OWNED BY public.account_loan_compute_wizard.id;


--
-- Name: account_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_id_seq OWNER TO runbot;

--
-- Name: account_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_id_seq OWNED BY public.account_loan.id;


--
-- Name: account_loan_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_line (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    principal numeric,
    interest numeric,
    payment numeric,
    long_term_theoretical_balance numeric,
    short_term_theoretical_balance numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_line OWNER TO runbot;

--
-- Name: TABLE account_loan_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_line IS 'Loan Line';


--
-- Name: COLUMN account_loan_line.loan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.date IS 'Date';


--
-- Name: COLUMN account_loan_line.principal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.principal IS 'Principal';


--
-- Name: COLUMN account_loan_line.interest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.interest IS 'Interest';


--
-- Name: COLUMN account_loan_line.payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.payment IS 'Payment';


--
-- Name: COLUMN account_loan_line.long_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.long_term_theoretical_balance IS 'Long-Term';


--
-- Name: COLUMN account_loan_line.short_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.short_term_theoretical_balance IS 'Short-Term';


--
-- Name: COLUMN account_loan_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.write_date IS 'Last Updated on';


--
-- Name: account_loan_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_line_id_seq OWNER TO runbot;

--
-- Name: account_loan_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_line_id_seq OWNED BY public.account_loan_line.id;


--
-- Name: account_lock_exception; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_lock_exception (
    id integer NOT NULL,
    company_id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    lock_date_field character varying NOT NULL,
    lock_date date,
    company_lock_date date,
    active boolean,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_lock_exception OWNER TO runbot;

--
-- Name: TABLE account_lock_exception; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_lock_exception IS 'Account Lock Exception';


--
-- Name: COLUMN account_lock_exception.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_id IS 'Company';


--
-- Name: COLUMN account_lock_exception.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.user_id IS 'User';


--
-- Name: COLUMN account_lock_exception.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_uid IS 'Created by';


--
-- Name: COLUMN account_lock_exception.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_lock_exception.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.reason IS 'Reason';


--
-- Name: COLUMN account_lock_exception.lock_date_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date_field IS 'Lock Date Field';


--
-- Name: COLUMN account_lock_exception.lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date IS 'Changed Lock Date';


--
-- Name: COLUMN account_lock_exception.company_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_lock_date IS 'Original Lock Date';


--
-- Name: COLUMN account_lock_exception.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.active IS 'Active';


--
-- Name: COLUMN account_lock_exception.end_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.end_datetime IS 'End Date';


--
-- Name: COLUMN account_lock_exception.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_date IS 'Created on';


--
-- Name: COLUMN account_lock_exception.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_date IS 'Last Updated on';


--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_lock_exception_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_lock_exception_id_seq OWNER TO runbot;

--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_lock_exception_id_seq OWNED BY public.account_lock_exception.id;


--
-- Name: account_merge_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    is_group_by_name boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard IS 'Account merge wizard';


--
-- Name: COLUMN account_merge_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard.is_group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.is_group_by_name IS 'Group by name?';


--
-- Name: COLUMN account_merge_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_id_seq OWNED BY public.account_merge_wizard.id;


--
-- Name: account_merge_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    sequence integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    grouping_key character varying,
    display_type character varying NOT NULL,
    is_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard_line IS 'Account merge wizard line';


--
-- Name: COLUMN account_merge_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_merge_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_merge_wizard_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.account_id IS 'Account';


--
-- Name: COLUMN account_merge_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard_line.grouping_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.grouping_key IS 'Grouping Key';


--
-- Name: COLUMN account_merge_wizard_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_merge_wizard_line.is_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.is_selected IS 'Is Selected';


--
-- Name: COLUMN account_merge_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNED BY public.account_merge_wizard_line.id;


--
-- Name: account_missing_transaction_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_missing_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_missing_transaction_wizard OWNER TO runbot;

--
-- Name: TABLE account_missing_transaction_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_missing_transaction_wizard IS 'Wizard for missing transactions';


--
-- Name: COLUMN account_missing_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_missing_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_missing_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_missing_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_missing_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_missing_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_missing_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNER TO runbot;

--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNED BY public.account_missing_transaction_wizard.id;


--
-- Name: account_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_model_rel (
    account_transfer_model_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_model_rel OWNER TO runbot;

--
-- Name: TABLE account_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_model_rel IS 'RELATION BETWEEN account_transfer_model AND account_account';


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    sequence_number integer,
    message_main_attachment_id integer,
    journal_id integer NOT NULL,
    company_id integer,
    origin_payment_id integer,
    statement_line_id integer,
    tax_cash_basis_rec_id integer,
    tax_cash_basis_origin_move_id integer,
    auto_post_origin_id integer,
    secure_sequence_number integer,
    invoice_payment_term_id integer,
    partner_id integer,
    commercial_partner_id integer,
    partner_shipping_id integer,
    partner_bank_id integer,
    fiscal_position_id integer,
    preferred_payment_method_line_id integer,
    currency_id integer NOT NULL,
    reversed_entry_id integer,
    invoice_user_id integer,
    invoice_incoterm_id integer,
    invoice_cash_rounding_id integer,
    create_uid integer,
    write_uid integer,
    sequence_prefix character varying,
    access_token character varying,
    name character varying,
    ref character varying,
    state character varying NOT NULL,
    move_type character varying NOT NULL,
    auto_post character varying NOT NULL,
    inalterable_hash character varying,
    payment_reference character varying,
    qr_code_method character varying,
    payment_state character varying,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_origin character varying,
    incoterm_location character varying,
    date date NOT NULL,
    auto_post_until date,
    invoice_date date,
    invoice_date_due date,
    delivery_date date,
    sending_data jsonb,
    narration text,
    invoice_currency_rate numeric,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_untaxed_in_currency_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_total_in_currency_signed numeric,
    amount_residual_signed numeric,
    quick_edit_total_amount numeric,
    is_storno boolean,
    always_tax_exigible boolean,
    checked boolean,
    posted_before boolean,
    made_sequence_gap boolean,
    is_manually_modified boolean,
    is_move_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    signing_user integer,
    payment_state_before_switch character varying,
    debit_origin_id integer,
    stock_move_id integer,
    transfer_model_id integer,
    avatax_tax_date date,
    l10n_latam_document_type_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    pay_now_journal_id integer,
    tax_closing_report_id integer,
    internal_notes text,
    l10n_ar_afip_responsibility_type_id integer,
    l10n_ar_afip_service_start date,
    l10n_ar_afip_service_end date,
    asset_id integer,
    asset_number_days integer,
    asset_move_type character varying,
    asset_depreciation_beginning_date date,
    depreciation_value numeric,
    asset_value_change boolean,
    extract_attachment_id integer,
    extract_detected_layout integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    extract_partner_name character varying,
    extract_prefill_data jsonb,
    is_in_extractable_state boolean,
    extract_state_processed boolean,
    receiptbook_id integer,
    l10n_ar_fce_transmission_type character varying,
    l10n_ar_afip_auth_mode character varying,
    l10n_ar_afip_auth_code character varying(24),
    l10n_ar_afip_result character varying,
    l10n_ar_afip_verification_result character varying,
    l10n_ar_afip_auth_code_due date,
    l10n_ar_afip_xml_request text,
    l10n_ar_afip_xml_response text,
    l10n_ar_afip_fce_is_cancellation boolean,
    generating_loan_line_id integer,
    is_loan_payment_move boolean,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date,
    transaction_id integer,
    budget_id integer,
    to_pay_amount numeric
);


ALTER TABLE public.account_move OWNER TO runbot;

--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move IS 'Journal Entry';


--
-- Name: COLUMN account_move.sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.origin_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.origin_payment_id IS 'Payment';


--
-- Name: COLUMN account_move.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.statement_line_id IS 'Statement Line';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.tax_cash_basis_origin_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_origin_move_id IS 'Cash Basis Origin';


--
-- Name: COLUMN account_move.auto_post_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_origin_id IS 'First recurring entry';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalterability No Gap Sequence #';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN account_move.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_bank_id IS 'Recipient Bank';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.preferred_payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.preferred_payment_method_line_id IS 'Preferred Payment Method Line';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.sequence_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.move_type IS 'Type';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Auto-post';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_move.qr_code_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.qr_code_method IS 'Payment QR-code';


--
-- Name: COLUMN account_move.payment_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state IS 'Payment Status';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.incoterm_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.incoterm_location IS 'Incoterm Location';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.auto_post_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_until IS 'Auto-post until';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.delivery_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.delivery_date IS 'Delivery Date';


--
-- Name: COLUMN account_move.sending_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sending_data IS 'Sending Data';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.invoice_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_untaxed_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_in_currency_signed IS 'Untaxed Amount Signed Currency';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_total_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_in_currency_signed IS 'Total in Currency Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.quick_edit_total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.quick_edit_total_amount IS 'Total (Tax inc.)';


--
-- Name: COLUMN account_move.is_storno; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_storno IS 'Is Storno';


--
-- Name: COLUMN account_move.always_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.always_tax_exigible IS 'Always Tax Exigible';


--
-- Name: COLUMN account_move.checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.checked IS 'Checked';


--
-- Name: COLUMN account_move.posted_before; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.posted_before IS 'Posted Before';


--
-- Name: COLUMN account_move.made_sequence_gap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.made_sequence_gap IS 'Made Sequence Gap';


--
-- Name: COLUMN account_move.is_manually_modified; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_manually_modified IS 'Is Manually Modified';


--
-- Name: COLUMN account_move.is_move_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_move_sent IS 'Is Move Sent';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.signing_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.signing_user IS 'Signer';


--
-- Name: COLUMN account_move.payment_state_before_switch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state_before_switch IS 'Payment State Before Switch';


--
-- Name: COLUMN account_move.debit_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.debit_origin_id IS 'Original Invoice Debited';


--
-- Name: COLUMN account_move.stock_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.stock_move_id IS 'Stock Move';


--
-- Name: COLUMN account_move.transfer_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.transfer_model_id IS 'Originating Model';


--
-- Name: COLUMN account_move.avatax_tax_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.avatax_tax_date IS 'Avatax Date';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: COLUMN account_move.pay_now_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.pay_now_journal_id IS 'Pay now Journal';


--
-- Name: COLUMN account_move.tax_closing_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_closing_report_id IS 'Tax Closing Report';


--
-- Name: COLUMN account_move.internal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.internal_notes IS 'Internal Notes';


--
-- Name: COLUMN account_move.l10n_ar_afip_responsibility_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_responsibility_type_id IS 'AFIP Responsibility Type';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_start IS 'AFIP Service Start Date';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_end IS 'AFIP Service End Date';


--
-- Name: COLUMN account_move.asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_id IS 'Asset';


--
-- Name: COLUMN account_move.asset_number_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_number_days IS 'Number of days';


--
-- Name: COLUMN account_move.asset_move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_move_type IS 'Asset Move Type';


--
-- Name: COLUMN account_move.asset_depreciation_beginning_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_depreciation_beginning_date IS 'Date of the beginning of the depreciation';


--
-- Name: COLUMN account_move.depreciation_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.depreciation_value IS 'Depreciation';


--
-- Name: COLUMN account_move.asset_value_change; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_value_change IS 'Asset Value Change';


--
-- Name: COLUMN account_move.extract_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_attachment_id IS 'Extract Attachment';


--
-- Name: COLUMN account_move.extract_detected_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_detected_layout IS 'Extract Detected Layout Id';


--
-- Name: COLUMN account_move.extract_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_state IS 'Extract state';


--
-- Name: COLUMN account_move.extract_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_status IS 'Extract status';


--
-- Name: COLUMN account_move.extract_document_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_move.extract_partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_partner_name IS 'Extract Detected Partner Name';


--
-- Name: COLUMN account_move.extract_prefill_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_prefill_data IS 'Extract Prefill Data';


--
-- Name: COLUMN account_move.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_move.extract_state_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_state_processed IS 'Extract State Processed';


--
-- Name: COLUMN account_move.receiptbook_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.receiptbook_id IS 'ReceiptBook';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_mode IS 'AFIP Authorization Mode';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code IS 'Authorization Code';


--
-- Name: COLUMN account_move.l10n_ar_afip_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_result IS 'Result';


--
-- Name: COLUMN account_move.l10n_ar_afip_verification_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_verification_result IS 'AFIP Verification result';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code_due IS 'Authorization Due date';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_request IS 'XML Request';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_response IS 'XML Response';


--
-- Name: COLUMN account_move.l10n_ar_afip_fce_is_cancellation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_fce_is_cancellation IS 'FCE: Is Cancellation?';


--
-- Name: COLUMN account_move.generating_loan_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.generating_loan_line_id IS 'Generating Loan Line';


--
-- Name: COLUMN account_move.is_loan_payment_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_loan_payment_move IS 'Is Loan Payment Move';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_start IS 'Associated Period Start';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_end IS 'Associated Perdio End';


--
-- Name: COLUMN account_move.transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.transaction_id IS 'Transaction';


--
-- Name: COLUMN account_move.budget_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.budget_id IS 'Budget';


--
-- Name: COLUMN account_move.to_pay_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.to_pay_amount IS 'Monto A Pagar';


--
-- Name: account_move__account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move__account_payment (
    invoice_id integer NOT NULL,
    payment_id integer NOT NULL
);


ALTER TABLE public.account_move__account_payment OWNER TO runbot;

--
-- Name: TABLE account_move__account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move__account_payment IS 'RELATION BETWEEN account_move AND account_payment';


--
-- Name: account_move_account_move_send_batch_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_move_send_batch_wizard_rel (
    account_move_send_batch_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_move_send_batch_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_move_send_batch_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_move_send_batch_wizard_rel IS 'RELATION BETWEEN account_move_send_batch_wizard AND account_move';


--
-- Name: account_move_account_resequence_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_resequence_wizard_rel (
    account_resequence_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_resequence_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_resequence_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_resequence_wizard_rel IS 'RELATION BETWEEN account_resequence_wizard AND account_move';


--
-- Name: account_move_asset_modify_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_asset_modify_rel OWNER TO runbot;

--
-- Name: TABLE account_move_asset_modify_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move';


--
-- Name: account_move_change_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_change_rate (
    id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    currency_rate numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_change_rate OWNER TO runbot;

--
-- Name: TABLE account_move_change_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_change_rate IS 'account.move.change.rate';


--
-- Name: COLUMN account_move_change_rate.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.move_id IS 'Move';


--
-- Name: COLUMN account_move_change_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_change_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_change_rate.currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move_change_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_move_change_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_date IS 'Last Updated on';


--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_change_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_change_rate_id_seq OWNER TO runbot;

--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_change_rate_id_seq OWNED BY public.account_move_change_rate.id;


--
-- Name: account_move_debit_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_debit_move (
    debit_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_debit_move OWNER TO runbot;

--
-- Name: TABLE account_move_debit_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_debit_move IS 'RELATION BETWEEN account_debit_note AND account_move';


--
-- Name: account_move_deferred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_deferred_rel (
    original_move_id integer NOT NULL,
    deferred_move_id integer NOT NULL
);


ALTER TABLE public.account_move_deferred_rel OWNER TO runbot;

--
-- Name: TABLE account_move_deferred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_deferred_rel IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_id_seq OWNER TO runbot;

--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_l10n_ar_boarding_permission_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_l10n_ar_boarding_permission_rel (
    account_move_id integer NOT NULL,
    l10n_ar_boarding_permission_id integer NOT NULL
);


ALTER TABLE public.account_move_l10n_ar_boarding_permission_rel OWNER TO runbot;

--
-- Name: TABLE account_move_l10n_ar_boarding_permission_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_l10n_ar_boarding_permission_rel IS 'RELATION BETWEEN account_move AND l10n_ar_boarding_permission';


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    sequence integer,
    account_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    group_tax_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_repartition_line_id integer,
    full_reconcile_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    move_name character varying,
    parent_state character varying,
    ref character varying,
    name character varying,
    matching_number character varying,
    display_type character varying NOT NULL,
    date date,
    invoice_date date,
    date_maturity date,
    discount_date date,
    analytic_distribution jsonb,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    tax_base_amount numeric,
    amount_residual numeric,
    amount_residual_currency numeric,
    quantity numeric,
    price_unit numeric,
    price_subtotal numeric,
    price_total numeric,
    discount numeric,
    discount_amount_currency numeric,
    discount_balance numeric,
    is_imported boolean,
    tax_tag_invert boolean,
    reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    deferred_start_date date,
    deferred_end_date date,
    purchase_line_id integer,
    is_downpayment boolean,
    cogs_origin_id integer,
    l10n_latam_document_type_id integer,
    exclude_bank_lines boolean,
    user_id integer,
    followup_line_id integer,
    tax_settlement_move_id integer,
    tax_state character varying,
    subscription_mrr numeric,
    subscription_id integer,
    no_followup boolean DEFAULT false,
    definitive_line_id integer,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (((balance <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR ((balance >= (0)::numeric) AND (amount_currency >= (0)::numeric))))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


ALTER TABLE public.account_move_line OWNER TO runbot;

--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Originator Statement Line';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.group_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.group_tax_id IS 'Originator Group of Taxes';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Distribution Line';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.matching_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.matching_number IS 'Matching #';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.discount_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_date IS 'Discount Date';


--
-- Name: COLUMN account_move_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.discount_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_amount_currency IS 'Discount amount in Currency';


--
-- Name: COLUMN account_move_line.discount_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_balance IS 'Discount Balance';


--
-- Name: COLUMN account_move_line.is_imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_imported IS 'Is Imported';


--
-- Name: COLUMN account_move_line.tax_tag_invert; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_tag_invert IS 'Invert Tags';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.deferred_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deferred_start_date IS 'Start Date';


--
-- Name: COLUMN account_move_line.deferred_end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deferred_end_date IS 'End Date';


--
-- Name: COLUMN account_move_line.purchase_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.purchase_line_id IS 'Purchase Order Line';


--
-- Name: COLUMN account_move_line.is_downpayment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_downpayment IS 'Is Downpayment';


--
-- Name: COLUMN account_move_line.cogs_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.cogs_origin_id IS 'Cogs Origin';


--
-- Name: COLUMN account_move_line.exclude_bank_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.exclude_bank_lines IS 'Exclude Bank Lines';


--
-- Name: COLUMN account_move_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.user_id IS 'Contact Salesperson';


--
-- Name: COLUMN account_move_line.followup_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.followup_line_id IS 'Follow-up Level';


--
-- Name: COLUMN account_move_line.tax_settlement_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_settlement_move_id IS 'Tax Settlement Move';


--
-- Name: COLUMN account_move_line.tax_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_state IS 'Tax State';


--
-- Name: COLUMN account_move_line.subscription_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.subscription_id IS 'Subscription';


--
-- Name: COLUMN account_move_line.definitive_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.definitive_line_id IS 'Definitive Line';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                display_type IN (''line_section'', ''line_note'')
                OR (
                    (balance <= 0 AND amount_currency <= 0)
                    OR
                    (balance >= 0 AND amount_currency >= 0)
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_reconcile_wizard_rel (
    account_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_reconcile_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_reconcile_wizard_rel IS 'RELATION BETWEEN account_reconcile_wizard AND account_move_line';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_account_tax_settlement_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_settlement_wizard_rel (
    account_tax_settlement_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_settlement_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_settlement_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_settlement_wizard_rel IS 'RELATION BETWEEN account_tax_settlement_wizard AND account_move_line';


--
-- Name: account_move_line_asset_modify_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_asset_modify_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_asset_modify_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move_line';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_line_id_seq OWNER TO runbot;

--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_line_l10n_us_1099_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_l10n_us_1099_wizard_rel (
    l10n_us_1099_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_l10n_us_1099_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_l10n_us_1099_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_l10n_us_1099_wizard_rel IS 'RELATION BETWEEN l10n_us_1099_wizard AND account_move_line';


--
-- Name: account_move_line_payment_to_pay_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_payment_to_pay_rel (
    payment_id integer NOT NULL,
    to_pay_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_payment_to_pay_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_payment_to_pay_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_payment_to_pay_rel IS 'RELATION BETWEEN account_payment AND account_move_line';


--
-- Name: account_move_purchase_order_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_purchase_order_rel (
    purchase_order_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_purchase_order_rel OWNER TO runbot;

--
-- Name: TABLE account_move_purchase_order_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_purchase_order_rel IS 'RELATION BETWEEN purchase_order AND account_move';


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_latam_document_type_id integer,
    l10n_latam_document_number character varying,
    l10n_ar_afip_fce_is_cancellation boolean
);


ALTER TABLE public.account_move_reversal OWNER TO runbot;

--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_reversal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.company_id IS 'Company';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason displayed on Credit Note';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_number IS 'Document Number';


--
-- Name: COLUMN account_move_reversal.l10n_ar_afip_fce_is_cancellation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_ar_afip_fce_is_cancellation IS 'FCE: Is Cancellation?';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_reversal_id_seq OWNER TO runbot;

--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_move_reversal_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_move (
    reversal_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_reversal_new_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_new_move (
    reversal_id integer NOT NULL,
    new_move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_new_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_new_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_new_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_send_batch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_batch_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_batch_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_batch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_batch_wizard IS 'Account Move Send Batch Wizard';


--
-- Name: COLUMN account_move_send_batch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_batch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_batch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_batch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_batch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNED BY public.account_move_send_batch_wizard.id;


--
-- Name: account_move_send_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard (
    id integer NOT NULL,
    move_id integer NOT NULL,
    pdf_report_id integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    mail_subject character varying,
    sending_method_checkboxes jsonb,
    extra_edi_checkboxes jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard IS 'Account Move Send Wizard';


--
-- Name: COLUMN account_move_send_wizard.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.move_id IS 'Move';


--
-- Name: COLUMN account_move_send_wizard.pdf_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.pdf_report_id IS 'Invoice template';


--
-- Name: COLUMN account_move_send_wizard.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_move_send_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_wizard.mail_subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_subject IS 'Subject';


--
-- Name: COLUMN account_move_send_wizard.sending_method_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.sending_method_checkboxes IS 'Sending Method Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.extra_edi_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.extra_edi_checkboxes IS 'Extra Edi Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_move_send_wizard.mail_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_body IS 'Contents';


--
-- Name: COLUMN account_move_send_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNED BY public.account_move_send_wizard.id;


--
-- Name: account_move_send_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard_res_partner_rel (
    account_move_send_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_move_send_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard_res_partner_rel IS 'RELATION BETWEEN account_move_send_wizard AND res_partner';


--
-- Name: account_move_stock_picking_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_stock_picking_rel (
    account_move_id integer NOT NULL,
    stock_picking_id integer NOT NULL
);


ALTER TABLE public.account_move_stock_picking_rel OWNER TO runbot;

--
-- Name: TABLE account_move_stock_picking_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_stock_picking_rel IS 'RELATION BETWEEN account_move AND stock_picking';


--
-- Name: account_move_validate_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_validate_account_move_rel (
    validate_account_move_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_validate_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_move_validate_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_validate_account_move_rel IS 'RELATION BETWEEN validate_account_move AND account_move';


--
-- Name: account_multicurrency_revaluation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_multicurrency_revaluation_wizard (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_multicurrency_revaluation_wizard OWNER TO runbot;

--
-- Name: TABLE account_multicurrency_revaluation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_multicurrency_revaluation_wizard IS 'Multicurrency Revaluation Wizard';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.date IS 'Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_date IS 'Last Updated on';


--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNER TO runbot;

--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNED BY public.account_multicurrency_revaluation_wizard.id;


--
-- Name: account_online_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_account (
    id integer NOT NULL,
    account_online_link_id integer,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    online_identifier character varying,
    account_number character varying,
    account_data character varying,
    fetching_status character varying,
    last_sync date,
    inverse_balance_sign boolean,
    inverse_transaction_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    balance double precision
);


ALTER TABLE public.account_online_account OWNER TO runbot;

--
-- Name: TABLE account_online_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_account IS 'representation of an online bank account';


--
-- Name: COLUMN account_online_account.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_online_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.currency_id IS 'Currency';


--
-- Name: COLUMN account_online_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.name IS 'Account Name';


--
-- Name: COLUMN account_online_account.online_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.online_identifier IS 'Online Identifier';


--
-- Name: COLUMN account_online_account.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_number IS 'Account Number';


--
-- Name: COLUMN account_online_account.account_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_data IS 'Account Data';


--
-- Name: COLUMN account_online_account.fetching_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.fetching_status IS 'Fetching Status';


--
-- Name: COLUMN account_online_account.last_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.last_sync IS 'Last synchronization';


--
-- Name: COLUMN account_online_account.inverse_balance_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_balance_sign IS 'Inverse Balance Sign';


--
-- Name: COLUMN account_online_account.inverse_transaction_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_transaction_sign IS 'Inverse Transaction Sign';


--
-- Name: COLUMN account_online_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_date IS 'Created on';


--
-- Name: COLUMN account_online_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_online_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.balance IS 'Balance';


--
-- Name: account_online_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_account_id_seq OWNER TO runbot;

--
-- Name: account_online_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_account_id_seq OWNED BY public.account_online_account.id;


--
-- Name: account_online_link; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_link (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    client_id character varying,
    refresh_token character varying,
    access_token character varying,
    provider_data character varying,
    provider_type character varying,
    expiring_synchronization_date date,
    connection_state_details jsonb,
    auto_sync boolean,
    has_unlinked_accounts boolean,
    last_refresh timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_online_link OWNER TO runbot;

--
-- Name: TABLE account_online_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_link IS 'Bank Connection';


--
-- Name: COLUMN account_online_link.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.company_id IS 'Company';


--
-- Name: COLUMN account_online_link.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_link.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_link.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.state IS 'State';


--
-- Name: COLUMN account_online_link.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.name IS 'Name';


--
-- Name: COLUMN account_online_link.client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.client_id IS 'Client';


--
-- Name: COLUMN account_online_link.refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.refresh_token IS 'Refresh Token';


--
-- Name: COLUMN account_online_link.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.access_token IS 'Access Token';


--
-- Name: COLUMN account_online_link.provider_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.provider_data IS 'Provider Data';


--
-- Name: COLUMN account_online_link.provider_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.provider_type IS 'Provider Type';


--
-- Name: COLUMN account_online_link.expiring_synchronization_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.expiring_synchronization_date IS 'Expiring Synchronization Date';


--
-- Name: COLUMN account_online_link.connection_state_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.connection_state_details IS 'Connection State Details';


--
-- Name: COLUMN account_online_link.auto_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.auto_sync IS 'Automatic synchronization';


--
-- Name: COLUMN account_online_link.has_unlinked_accounts; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.has_unlinked_accounts IS 'Has Unlinked Accounts';


--
-- Name: COLUMN account_online_link.last_refresh; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.last_refresh IS 'Last Refresh';


--
-- Name: COLUMN account_online_link.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_date IS 'Created on';


--
-- Name: COLUMN account_online_link.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_date IS 'Last Updated on';


--
-- Name: account_online_link_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_link_id_seq OWNER TO runbot;

--
-- Name: account_online_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_link_id_seq OWNED BY public.account_online_link.id;


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    full_reconcile_id integer,
    exchange_move_id integer,
    debit_currency_id integer,
    credit_currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    max_date date,
    amount numeric,
    debit_amount_currency numeric,
    credit_amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_partial_reconcile OWNER TO runbot;

--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_partial_reconcile.debit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_currency_id IS 'Currency of the debit journal item.';


--
-- Name: COLUMN account_partial_reconcile.credit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_currency_id IS 'Currency of the credit journal item.';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.debit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_amount_currency IS 'Debit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.credit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_amount_currency IS 'Credit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    move_id integer,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    partner_bank_id integer,
    paired_internal_transfer_payment_id integer,
    payment_method_line_id integer,
    payment_method_id integer,
    currency_id integer,
    partner_id integer,
    outstanding_account_id integer,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    state character varying NOT NULL,
    payment_type character varying NOT NULL,
    partner_type character varying NOT NULL,
    memo character varying,
    payment_reference character varying,
    date date,
    amount numeric,
    amount_company_currency_signed numeric,
    is_reconciled boolean,
    is_matched boolean,
    is_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    batch_payment_id integer,
    destination_journal_id integer,
    is_internal_transfer boolean,
    payment_transaction_id integer,
    payment_token_id integer,
    source_payment_id integer,
    counterpart_currency_id integer,
    write_off_type_id integer,
    counterpart_exchange_rate numeric,
    force_amount_company_currency numeric,
    unreconciled_amount numeric,
    write_off_amount numeric,
    receiptbook_id integer,
    l10n_latam_move_check_ids_operation_date timestamp without time zone,
    l10n_ar_fiscal_position_id integer,
    withholdable_advanced_amount numeric,
    budget_id integer,
    expedient_id integer,
    transaction_id integer,
    advance_request_id integer,
    payment_days integer,
    assignee_id integer,
    return_payment_id integer,
    sipreco_state character varying,
    approval_state character varying,
    reference character varying,
    days_interval_type character varying,
    payment_min_date date,
    confirmation_date date,
    to_signature_date date,
    transaction_with_advance_payment boolean,
    payment_base_date timestamp without time zone,
    grupo_asingado_por_bmr character varying(2),
    tipo_de_pago character varying(1),
    sucursal_de_cuenta_debito character varying(2),
    numero_de_cuenta_debito character varying(4),
    tipo_de_cuenta character varying(1),
    archivo_banco_name character varying,
    fecha_de_acreditacion date,
    CONSTRAINT account_payment_check_amount_not_negative CHECK ((amount >= 0.0))
);


ALTER TABLE public.account_payment OWNER TO runbot;

--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.company_id IS 'Company';


--
-- Name: COLUMN account_payment.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.paired_internal_transfer_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.paired_internal_transfer_payment_id IS 'Paired Internal Transfer Payment';


--
-- Name: COLUMN account_payment.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Method';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment.outstanding_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN account_payment.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_account_id IS 'Destination Account';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.name IS 'Number';


--
-- Name: COLUMN account_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.state IS 'State';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.memo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.memo IS 'Memo';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.date IS 'Date';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.amount_company_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount_company_currency_signed IS 'Amount Company Currency Signed';


--
-- Name: COLUMN account_payment.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_payment.is_matched; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_matched IS 'Is Matched With a Bank Statement';


--
-- Name: COLUMN account_payment.is_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_sent IS 'Is Sent';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_payment.destination_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_payment.is_internal_transfer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_internal_transfer IS 'Internal Transfer';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved Payment Token';


--
-- Name: COLUMN account_payment.source_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.source_payment_id IS 'Source Payment';


--
-- Name: COLUMN account_payment.counterpart_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_currency_id IS 'Counterpart Currency';


--
-- Name: COLUMN account_payment.write_off_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_off_type_id IS 'Write Off Type';


--
-- Name: COLUMN account_payment.counterpart_exchange_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_exchange_rate IS 'Counterpart Exchange Rate';


--
-- Name: COLUMN account_payment.force_amount_company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.force_amount_company_currency IS 'Forced Amount on Company Currency';


--
-- Name: COLUMN account_payment.unreconciled_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.unreconciled_amount IS 'Adjustment / Advance';


--
-- Name: COLUMN account_payment.write_off_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_off_amount IS 'Write Off Amount';


--
-- Name: COLUMN account_payment.receiptbook_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.receiptbook_id IS 'ReceiptBook';


--
-- Name: COLUMN account_payment.l10n_latam_move_check_ids_operation_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_latam_move_check_ids_operation_date IS 'Operation Date';


--
-- Name: COLUMN account_payment.l10n_ar_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_ar_fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_payment.withholdable_advanced_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholdable_advanced_amount IS 'Adjustment / Advance (untaxed)';


--
-- Name: COLUMN account_payment.budget_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.budget_id IS 'Presupuesto';


--
-- Name: COLUMN account_payment.expedient_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.expedient_id IS 'Expediente';


--
-- Name: COLUMN account_payment.transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.transaction_id IS 'Transacción';


--
-- Name: COLUMN account_payment.advance_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.advance_request_id IS 'Advance Request';


--
-- Name: COLUMN account_payment.payment_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_days IS 'Payment Days';


--
-- Name: COLUMN account_payment.assignee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.assignee_id IS 'Cesionario';


--
-- Name: COLUMN account_payment.return_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.return_payment_id IS 'Línea de devolución';


--
-- Name: COLUMN account_payment.sipreco_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.sipreco_state IS 'Sipreco State';


--
-- Name: COLUMN account_payment.approval_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.approval_state IS 'Approval State';


--
-- Name: COLUMN account_payment.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.reference IS 'Ref. pago';


--
-- Name: COLUMN account_payment.days_interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.days_interval_type IS 'Days Interval Type';


--
-- Name: COLUMN account_payment.payment_min_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_min_date IS 'Fecha Min. de Pago';


--
-- Name: COLUMN account_payment.confirmation_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.confirmation_date IS 'Fecha de Confirmación';


--
-- Name: COLUMN account_payment.to_signature_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.to_signature_date IS 'Fecha a Proceso de Firma';


--
-- Name: COLUMN account_payment.transaction_with_advance_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.transaction_with_advance_payment IS 'With advance payment?';


--
-- Name: COLUMN account_payment.payment_base_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_base_date IS 'Payment Base Date';


--
-- Name: COLUMN account_payment.grupo_asingado_por_bmr; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.grupo_asingado_por_bmr IS 'Grupo Asignado por B.M.R.';


--
-- Name: COLUMN account_payment.tipo_de_pago; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.tipo_de_pago IS 'Tipo De Pago';


--
-- Name: COLUMN account_payment.sucursal_de_cuenta_debito; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.sucursal_de_cuenta_debito IS 'Sucursal De Cuenta Debito';


--
-- Name: COLUMN account_payment.numero_de_cuenta_debito; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.numero_de_cuenta_debito IS 'Numero De Cuenta Debito';


--
-- Name: COLUMN account_payment.tipo_de_cuenta; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.tipo_de_cuenta IS 'Tipo De Cuenta';


--
-- Name: COLUMN account_payment.archivo_banco_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.archivo_banco_name IS 'Archivo Banco Name';


--
-- Name: COLUMN account_payment.fecha_de_acreditacion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.fecha_de_acreditacion IS 'Fecha De Acreditacion';


--
-- Name: CONSTRAINT account_payment_check_amount_not_negative ON account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_payment_check_amount_not_negative ON public.account_payment IS 'CHECK(amount >= 0.0)';


--
-- Name: account_payment_account_bank_statement_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_account_bank_statement_line_rel (
    account_bank_statement_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_bank_statement_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_account_bank_statement_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_account_bank_statement_line_rel IS 'RELATION BETWEEN account_bank_statement_line AND account_payment';


--
-- Name: account_payment_group_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_group_line (
    id integer NOT NULL,
    payment_id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_account_id integer,
    create_uid integer,
    write_uid integer,
    cuit character varying,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_group_line OWNER TO runbot;

--
-- Name: TABLE account_payment_group_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_group_line IS 'Account Vouchers Payment Lines';


--
-- Name: COLUMN account_payment_group_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line.payment_id IS 'Payment';


--
-- Name: COLUMN account_payment_group_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_payment_group_line.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_payment_group_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_group_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_group_line.cuit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line.cuit IS 'Cuit';


--
-- Name: COLUMN account_payment_group_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line.amount IS 'Amount';


--
-- Name: COLUMN account_payment_group_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_group_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_group_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_group_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_group_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_group_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_group_line_id_seq OWNED BY public.account_payment_group_line.id;


--
-- Name: account_payment_group_line_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_group_line_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_group_line_import OWNER TO runbot;

--
-- Name: TABLE account_payment_group_line_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_group_line_import IS 'Account Payment Lines Import';


--
-- Name: COLUMN account_payment_group_line_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line_import.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_group_line_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_group_line_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line_import.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_group_line_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_line_import.write_date IS 'Last Updated on';


--
-- Name: account_payment_group_line_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_group_line_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_group_line_import_id_seq OWNER TO runbot;

--
-- Name: account_payment_group_line_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_group_line_import_id_seq OWNED BY public.account_payment_group_line_import.id;


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_id_seq OWNER TO runbot;

--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_invoice_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_invoice_wizard (
    id integer NOT NULL,
    payment_id integer NOT NULL,
    journal_id integer NOT NULL,
    product_id integer NOT NULL,
    product_account_id integer,
    journal_document_type_id integer,
    create_uid integer,
    write_uid integer,
    description character varying,
    document_number character varying,
    invoice_date date NOT NULL,
    date date,
    analytic_distribution jsonb,
    amount_total numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    origin_invoice_id integer,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date
);


ALTER TABLE public.account_payment_invoice_wizard OWNER TO runbot;

--
-- Name: TABLE account_payment_invoice_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_invoice_wizard IS 'account.payment.invoice.wizard';


--
-- Name: COLUMN account_payment_invoice_wizard.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.payment_id IS 'Payment';


--
-- Name: COLUMN account_payment_invoice_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_invoice_wizard.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.product_id IS 'Product';


--
-- Name: COLUMN account_payment_invoice_wizard.product_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.product_account_id IS 'Product Account';


--
-- Name: COLUMN account_payment_invoice_wizard.journal_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.journal_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_payment_invoice_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_invoice_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_invoice_wizard.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.description IS 'Reason';


--
-- Name: COLUMN account_payment_invoice_wizard.document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.document_number IS 'Document Number';


--
-- Name: COLUMN account_payment_invoice_wizard.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.invoice_date IS 'Refund Date';


--
-- Name: COLUMN account_payment_invoice_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.date IS 'Accounting Date';


--
-- Name: COLUMN account_payment_invoice_wizard.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_payment_invoice_wizard.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.amount_total IS 'Total Amount';


--
-- Name: COLUMN account_payment_invoice_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_invoice_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_invoice_wizard.origin_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.origin_invoice_id IS 'Origin Invoice';


--
-- Name: COLUMN account_payment_invoice_wizard.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.l10n_ar_afip_asoc_period_start IS 'Associate Period From';


--
-- Name: COLUMN account_payment_invoice_wizard.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.l10n_ar_afip_asoc_period_end IS 'Associate Period To';


--
-- Name: account_payment_invoice_wizard_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_invoice_wizard_account_tax_rel (
    account_payment_invoice_wizard_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_payment_invoice_wizard_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_invoice_wizard_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_invoice_wizard_account_tax_rel IS 'RELATION BETWEEN account_payment_invoice_wizard AND account_tax';


--
-- Name: account_payment_invoice_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_invoice_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_invoice_wizard_id_seq OWNER TO runbot;

--
-- Name: account_payment_invoice_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_invoice_wizard_id_seq OWNED BY public.account_payment_invoice_wizard.id;


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_method OWNER TO runbot;

--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_method_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method_line (
    id integer NOT NULL,
    sequence integer,
    payment_method_id integer NOT NULL,
    payment_account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_provider_id integer
);


ALTER TABLE public.account_payment_method_line OWNER TO runbot;

--
-- Name: TABLE account_payment_method_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method_line IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_method_line.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_method_line.payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_account_id IS 'Payment Account';


--
-- Name: COLUMN account_payment_method_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_method_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.name IS 'Name';


--
-- Name: COLUMN account_payment_method_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_method_line.payment_provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_provider_id IS 'Payment Provider';


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_line_id_seq OWNED BY public.account_payment_method_line.id;


--
-- Name: account_payment_receiptbook; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_receiptbook (
    id integer NOT NULL,
    report_partner_id integer,
    mail_template_id integer,
    sequence integer,
    sequence_id integer,
    company_id integer NOT NULL,
    document_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying(64) NOT NULL,
    partner_type character varying NOT NULL,
    prefix character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_receiptbook OWNER TO runbot;

--
-- Name: TABLE account_payment_receiptbook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_receiptbook IS 'Account payment Receiptbook';


--
-- Name: COLUMN account_payment_receiptbook.report_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.report_partner_id IS 'Report Partner';


--
-- Name: COLUMN account_payment_receiptbook.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.mail_template_id IS 'Email Template';


--
-- Name: COLUMN account_payment_receiptbook.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_receiptbook.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.sequence_id IS 'Entry Sequence';


--
-- Name: COLUMN account_payment_receiptbook.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.company_id IS 'Company';


--
-- Name: COLUMN account_payment_receiptbook.document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.document_type_id IS 'Document Type';


--
-- Name: COLUMN account_payment_receiptbook.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_receiptbook.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_receiptbook.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.name IS 'Name';


--
-- Name: COLUMN account_payment_receiptbook.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_receiptbook.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.prefix IS 'Prefix';


--
-- Name: COLUMN account_payment_receiptbook.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.active IS 'Active';


--
-- Name: COLUMN account_payment_receiptbook.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_receiptbook.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.write_date IS 'Last Updated on';


--
-- Name: account_payment_receiptbook_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_receiptbook_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_receiptbook_id_seq OWNER TO runbot;

--
-- Name: account_payment_receiptbook_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_receiptbook_id_seq OWNED BY public.account_payment_receiptbook.id;


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    currency_id integer,
    journal_id integer,
    partner_bank_id integer,
    custom_user_currency_id integer,
    source_currency_id integer,
    company_id integer,
    partner_id integer,
    payment_method_line_id integer,
    writeoff_account_id integer,
    create_uid integer,
    write_uid integer,
    communication character varying,
    installments_mode character varying,
    payment_type character varying,
    partner_type character varying,
    payment_difference_handling character varying,
    writeoff_label character varying,
    payment_date date NOT NULL,
    amount numeric,
    custom_user_amount numeric,
    source_amount numeric,
    source_amount_currency numeric,
    group_payment boolean,
    can_edit_wizard boolean,
    can_group_payments boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_token_id integer,
    l10n_ar_fiscal_position_id integer
);


ALTER TABLE public.account_payment_register OWNER TO runbot;

--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register IS 'Pay';


--
-- Name: COLUMN account_payment_register.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment_register.custom_user_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_currency_id IS 'Custom User Currency';


--
-- Name: COLUMN account_payment_register.source_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_currency_id IS 'Source Currency';


--
-- Name: COLUMN account_payment_register.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.company_id IS 'Company';


--
-- Name: COLUMN account_payment_register.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_register.writeoff_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.communication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.communication IS 'Memo';


--
-- Name: COLUMN account_payment_register.installments_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.installments_mode IS 'Installments Mode';


--
-- Name: COLUMN account_payment_register.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_register.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_register.payment_difference_handling; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment_register.writeoff_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.amount IS 'Amount';


--
-- Name: COLUMN account_payment_register.custom_user_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_amount IS 'Custom User Amount';


--
-- Name: COLUMN account_payment_register.source_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount IS 'Amount to Pay (company currency)';


--
-- Name: COLUMN account_payment_register.source_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount_currency IS 'Amount to Pay (foreign currency)';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payments';


--
-- Name: COLUMN account_payment_register.can_edit_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_edit_wizard IS 'Can Edit Wizard';


--
-- Name: COLUMN account_payment_register.can_group_payments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_group_payments IS 'Can Group Payments';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_register.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_token_id IS 'Saved payment token';


--
-- Name: COLUMN account_payment_register.l10n_ar_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.l10n_ar_fiscal_position_id IS 'Fiscal Position';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_register_id_seq OWNER TO runbot;

--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_register_l10n_latam_check_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_l10n_latam_check_rel (
    account_payment_register_id integer NOT NULL,
    l10n_latam_check_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_l10n_latam_check_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_l10n_latam_check_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_l10n_latam_check_rel IS 'RELATION BETWEEN account_payment_register AND l10n_latam_check';


--
-- Name: account_payment_register_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_move_line_rel (
    wizard_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_move_line_rel IS 'RELATION BETWEEN account_payment_register AND account_move_line';


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    company_id integer,
    sequence integer NOT NULL,
    discount_days integer,
    create_uid integer,
    write_uid integer,
    early_pay_discount_computation character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    display_on_invoice boolean,
    early_discount boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_percentage double precision
);


ALTER TABLE public.account_payment_term OWNER TO runbot;

--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.discount_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_days IS 'Discount Days';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.early_pay_discount_computation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_pay_discount_computation IS 'Cash Discount Tax Reduction';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.display_on_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.display_on_invoice IS 'Show installment dates';


--
-- Name: COLUMN account_payment_term.early_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_discount IS 'Early Discount';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term.discount_percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_percentage IS 'Discount %';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    nb_days integer,
    payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    delay_type character varying NOT NULL,
    days_next_month character varying(2),
    value_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_term_line OWNER TO runbot;

--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.nb_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.nb_days IS 'Days';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Value';


--
-- Name: COLUMN account_payment_term_line.delay_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.delay_type IS 'Delay Type';


--
-- Name: COLUMN account_payment_term_line.days_next_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.days_next_month IS 'Days on the next month';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Due';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    past_months_limit integer,
    create_uid integer,
    write_uid integer,
    rule_type character varying NOT NULL,
    matching_order character varying NOT NULL,
    counterpart_type character varying,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    payment_tolerance_type character varying NOT NULL,
    decimal_separator character varying,
    name jsonb NOT NULL,
    active boolean,
    auto_reconcile boolean,
    to_check boolean,
    match_text_location_label boolean,
    match_text_location_note boolean,
    match_text_location_reference boolean,
    match_same_currency boolean,
    allow_payment_tolerance boolean,
    match_partner boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    match_amount_min double precision,
    match_amount_max double precision,
    payment_tolerance_param double precision
);


ALTER TABLE public.account_reconcile_model OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.past_months_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.past_months_limit IS 'Search Months Limit';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.rule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model.matching_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.matching_order IS 'Matching Order';


--
-- Name: COLUMN account_reconcile_model.counterpart_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.counterpart_type IS 'Counterpart Type';


--
-- Name: COLUMN account_reconcile_model.match_nature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_nature IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount Condition';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.match_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model.match_note_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_type IS 'Payment Tolerance Type';


--
-- Name: COLUMN account_reconcile_model.decimal_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.active IS 'Active';


--
-- Name: COLUMN account_reconcile_model.auto_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model.match_text_location_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_label IS 'Match Text Location Label';


--
-- Name: COLUMN account_reconcile_model.match_text_location_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_note IS 'Match Text Location Note';


--
-- Name: COLUMN account_reconcile_model.match_text_location_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_reference IS 'Match Text Location Reference';


--
-- Name: COLUMN account_reconcile_model.match_same_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_same_currency IS 'Same Currency';


--
-- Name: COLUMN account_reconcile_model.allow_payment_tolerance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.allow_payment_tolerance IS 'Payment Tolerance';


--
-- Name: COLUMN account_reconcile_model.match_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_partner IS 'Partner is Set';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_param IS 'Gap';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line (
    id integer NOT NULL,
    model_id integer,
    company_id integer,
    sequence integer NOT NULL,
    account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying NOT NULL,
    amount_string character varying NOT NULL,
    analytic_distribution jsonb,
    label jsonb,
    force_tax_included boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_reconcile_model_line OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line IS 'Rules for the reconciliation model';


--
-- Name: COLUMN account_reconcile_model_line.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line.amount_string; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_reconcile_model_line.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_line.force_tax_included; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount IS 'Float Amount';


--
-- Name: account_reconcile_model_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_account_tax_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_tax';


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNED BY public.account_reconcile_model_line.id;


--
-- Name: account_reconcile_model_partner_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_partner_mapping (
    id integer NOT NULL,
    model_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_ref_regex character varying,
    narration_regex character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_partner_mapping OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_partner_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_partner_mapping IS 'Partner mapping for reconciliation models';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.payment_ref_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.payment_ref_regex IS 'Find Text in Label';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.narration_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.narration_regex IS 'Find Text in Notes';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_partner_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNED BY public.account_reconcile_model_partner_mapping.id;


--
-- Name: account_reconcile_model_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_category_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner_category';


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_reconcile_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_wizard (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    account_id integer,
    to_partner_id integer,
    tax_id integer,
    create_uid integer,
    write_uid integer,
    label character varying,
    date date,
    edit_mode_amount_currency numeric,
    allow_partials boolean,
    to_check boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_wizard OWNER TO runbot;

--
-- Name: TABLE account_reconcile_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_wizard IS 'Account reconciliation wizard';


--
-- Name: COLUMN account_reconcile_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_wizard.to_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_wizard.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.tax_id IS 'Tax';


--
-- Name: COLUMN account_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_wizard.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.label IS 'Label';


--
-- Name: COLUMN account_reconcile_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.date IS 'Date';


--
-- Name: COLUMN account_reconcile_wizard.edit_mode_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.edit_mode_amount_currency IS 'Edit mode amount';


--
-- Name: COLUMN account_reconcile_wizard.allow_partials; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.allow_partials IS 'Allow partials';


--
-- Name: COLUMN account_reconcile_wizard.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNED BY public.account_reconcile_wizard.id;


--
-- Name: account_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report (
    id integer NOT NULL,
    sequence integer,
    root_report_id integer,
    country_id integer,
    load_more_limit integer,
    prefix_groups_threshold integer,
    create_uid integer,
    write_uid integer,
    chart_template character varying,
    availability_condition character varying,
    integer_rounding character varying,
    default_opening_date_filter character varying,
    currency_translation character varying,
    filter_multi_company character varying,
    filter_hide_0_lines character varying,
    filter_hierarchy character varying,
    filter_account_type character varying,
    name jsonb NOT NULL,
    active boolean,
    use_sections boolean,
    only_tax_exigible boolean,
    search_bar boolean,
    filter_date_range boolean,
    filter_show_draft boolean,
    filter_unreconciled boolean,
    filter_unfold_all boolean,
    filter_period_comparison boolean,
    filter_growth_comparison boolean,
    filter_journals boolean,
    filter_analytic boolean,
    filter_partner boolean,
    filter_fiscal_position boolean,
    filter_aml_ir_filters boolean,
    filter_budgets boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    custom_handler_model_id integer,
    tax_closing_start_date jsonb,
    send_and_print_values jsonb,
    filter_analytic_groupby boolean,
    require_custom_filter boolean,
    settlement_title jsonb,
    allow_settlement boolean,
    settlement_allow_unbalanced boolean,
    filter_cash_basis boolean
);


ALTER TABLE public.account_report OWNER TO runbot;

--
-- Name: TABLE account_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report IS 'Accounting Report';


--
-- Name: COLUMN account_report.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.sequence IS 'Sequence';


--
-- Name: COLUMN account_report.root_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.root_report_id IS 'Root Report';


--
-- Name: COLUMN account_report.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.country_id IS 'Country';


--
-- Name: COLUMN account_report.load_more_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.load_more_limit IS 'Load More Limit';


--
-- Name: COLUMN account_report.prefix_groups_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.prefix_groups_threshold IS 'Prefix Groups Threshold';


--
-- Name: COLUMN account_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report.chart_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.chart_template IS 'Chart of Accounts';


--
-- Name: COLUMN account_report.availability_condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.availability_condition IS 'Availability';


--
-- Name: COLUMN account_report.integer_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.integer_rounding IS 'Integer Rounding';


--
-- Name: COLUMN account_report.default_opening_date_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.default_opening_date_filter IS 'Default Opening';


--
-- Name: COLUMN account_report.currency_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.currency_translation IS 'Currency Translation';


--
-- Name: COLUMN account_report.filter_multi_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_multi_company IS 'Multi-Company';


--
-- Name: COLUMN account_report.filter_hide_0_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hide_0_lines IS 'Hide lines at 0';


--
-- Name: COLUMN account_report.filter_hierarchy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hierarchy IS 'Account Groups';


--
-- Name: COLUMN account_report.filter_account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_account_type IS 'Account Types';


--
-- Name: COLUMN account_report.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.name IS 'Name';


--
-- Name: COLUMN account_report.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.active IS 'Active';


--
-- Name: COLUMN account_report.use_sections; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.use_sections IS 'Composite Report';


--
-- Name: COLUMN account_report.only_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.only_tax_exigible IS 'Only Tax Exigible Lines';


--
-- Name: COLUMN account_report.search_bar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.search_bar IS 'Search Bar';


--
-- Name: COLUMN account_report.filter_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_date_range IS 'Date Range';


--
-- Name: COLUMN account_report.filter_show_draft; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_show_draft IS 'Draft Entries';


--
-- Name: COLUMN account_report.filter_unreconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unreconciled IS 'Unreconciled Entries';


--
-- Name: COLUMN account_report.filter_unfold_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unfold_all IS 'Unfold All';


--
-- Name: COLUMN account_report.filter_period_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_period_comparison IS 'Period Comparison';


--
-- Name: COLUMN account_report.filter_growth_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_growth_comparison IS 'Growth Comparison';


--
-- Name: COLUMN account_report.filter_journals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_journals IS 'Journals';


--
-- Name: COLUMN account_report.filter_analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic IS 'Analytic Filter';


--
-- Name: COLUMN account_report.filter_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_partner IS 'Partners';


--
-- Name: COLUMN account_report.filter_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_fiscal_position IS 'Filter Multivat';


--
-- Name: COLUMN account_report.filter_aml_ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_aml_ir_filters IS 'Favorite Filters';


--
-- Name: COLUMN account_report.filter_budgets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_budgets IS 'Budgets';


--
-- Name: COLUMN account_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_date IS 'Created on';


--
-- Name: COLUMN account_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report.custom_handler_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.custom_handler_model_id IS 'Custom Handler Model';


--
-- Name: COLUMN account_report.tax_closing_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.tax_closing_start_date IS 'Start Date';


--
-- Name: COLUMN account_report.send_and_print_values; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.send_and_print_values IS 'Send And Print Values';


--
-- Name: COLUMN account_report.filter_analytic_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic_groupby IS 'Analytic Group By';


--
-- Name: COLUMN account_report.require_custom_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.require_custom_filter IS 'Require Custom Filter';


--
-- Name: COLUMN account_report.settlement_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.settlement_title IS 'Settlement Title';


--
-- Name: COLUMN account_report.allow_settlement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.allow_settlement IS 'Allow Settlement';


--
-- Name: COLUMN account_report.settlement_allow_unbalanced; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.settlement_allow_unbalanced IS 'Settlement Allow Unbalanced';


--
-- Name: COLUMN account_report.filter_cash_basis; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_cash_basis IS 'Cash Basis';


--
-- Name: account_report_account_report_horizontal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_account_report_horizontal_group_rel (
    account_report_id integer NOT NULL,
    account_report_horizontal_group_id integer NOT NULL
);


ALTER TABLE public.account_report_account_report_horizontal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_report_account_report_horizontal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_account_report_horizontal_group_rel IS 'RELATION BETWEEN account_report AND account_report_horizontal_group';


--
-- Name: account_report_annotation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_annotation (
    id integer NOT NULL,
    report_id integer,
    fiscal_position_id integer,
    create_uid integer,
    write_uid integer,
    line_id character varying,
    text character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_annotation OWNER TO runbot;

--
-- Name: TABLE account_report_annotation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_annotation IS 'Account Report Annotation';


--
-- Name: COLUMN account_report_annotation.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.report_id IS 'Report';


--
-- Name: COLUMN account_report_annotation.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_report_annotation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_annotation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_annotation.line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.line_id IS 'Line';


--
-- Name: COLUMN account_report_annotation.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.text IS 'The annotation''s content.';


--
-- Name: COLUMN account_report_annotation.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.date IS 'Date';


--
-- Name: COLUMN account_report_annotation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.create_date IS 'Created on';


--
-- Name: COLUMN account_report_annotation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.write_date IS 'Last Updated on';


--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_annotation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_annotation_id_seq OWNER TO runbot;

--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_annotation_id_seq OWNED BY public.account_report_annotation.id;


--
-- Name: account_report_budget; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_budget (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_budget OWNER TO runbot;

--
-- Name: TABLE account_report_budget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_budget IS 'Accounting Report Budget';


--
-- Name: COLUMN account_report_budget.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_budget.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.company_id IS 'Company';


--
-- Name: COLUMN account_report_budget.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.name IS 'Name';


--
-- Name: COLUMN account_report_budget.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.write_date IS 'Last Updated on';


--
-- Name: account_report_budget_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_budget_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_id_seq OWNER TO runbot;

--
-- Name: account_report_budget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_budget_id_seq OWNED BY public.account_report_budget.id;


--
-- Name: account_report_budget_item; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_budget_item (
    id integer NOT NULL,
    budget_id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_report_budget_item OWNER TO runbot;

--
-- Name: TABLE account_report_budget_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_budget_item IS 'Accounting Report Budget Item';


--
-- Name: COLUMN account_report_budget_item.budget_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.budget_id IS 'Budget';


--
-- Name: COLUMN account_report_budget_item.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.account_id IS 'Account';


--
-- Name: COLUMN account_report_budget_item.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget_item.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget_item.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.date IS 'Date';


--
-- Name: COLUMN account_report_budget_item.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget_item.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_budget_item.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.amount IS 'Amount';


--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_budget_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_item_id_seq OWNER TO runbot;

--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_budget_item_id_seq OWNED BY public.account_report_budget_item.id;


--
-- Name: account_report_column; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_column (
    id integer NOT NULL,
    sequence integer,
    report_id integer,
    custom_audit_action_id integer,
    create_uid integer,
    write_uid integer,
    expression_label character varying NOT NULL,
    figure_type character varying NOT NULL,
    name jsonb NOT NULL,
    sortable boolean,
    blank_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_column OWNER TO runbot;

--
-- Name: TABLE account_report_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_column IS 'Accounting Report Column';


--
-- Name: COLUMN account_report_column.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_column.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.report_id IS 'Report';


--
-- Name: COLUMN account_report_column.custom_audit_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.custom_audit_action_id IS 'Custom Audit Action';


--
-- Name: COLUMN account_report_column.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_column.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_column.expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.expression_label IS 'Expression Label';


--
-- Name: COLUMN account_report_column.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_column.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.name IS 'Name';


--
-- Name: COLUMN account_report_column.sortable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sortable IS 'Sortable';


--
-- Name: COLUMN account_report_column.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_column.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_date IS 'Created on';


--
-- Name: COLUMN account_report_column.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_date IS 'Last Updated on';


--
-- Name: account_report_column_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_column_id_seq OWNER TO runbot;

--
-- Name: account_report_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_column_id_seq OWNED BY public.account_report_column.id;


--
-- Name: account_report_expression; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_expression (
    id integer NOT NULL,
    report_line_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label character varying NOT NULL,
    engine character varying NOT NULL,
    formula character varying NOT NULL,
    subformula character varying,
    date_scope character varying NOT NULL,
    figure_type character varying,
    carryover_target character varying,
    green_on_positive boolean,
    blank_if_zero boolean,
    auditable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_report_expression_domain_engine_subformula_required CHECK ((((engine)::text <> 'domain'::text) OR (subformula IS NOT NULL)))
);


ALTER TABLE public.account_report_expression OWNER TO runbot;

--
-- Name: TABLE account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_expression IS 'Accounting Report Expression';


--
-- Name: COLUMN account_report_expression.report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.report_line_id IS 'Report Line';


--
-- Name: COLUMN account_report_expression.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_expression.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_expression.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.label IS 'Label';


--
-- Name: COLUMN account_report_expression.engine; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.engine IS 'Computation Engine';


--
-- Name: COLUMN account_report_expression.formula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.formula IS 'Formula';


--
-- Name: COLUMN account_report_expression.subformula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.subformula IS 'Subformula';


--
-- Name: COLUMN account_report_expression.date_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.date_scope IS 'Date Scope';


--
-- Name: COLUMN account_report_expression.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_expression.carryover_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.carryover_target IS 'Carry Over To';


--
-- Name: COLUMN account_report_expression.green_on_positive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.green_on_positive IS 'Is Growth Good when Positive';


--
-- Name: COLUMN account_report_expression.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_expression.auditable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.auditable IS 'Auditable';


--
-- Name: COLUMN account_report_expression.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_date IS 'Created on';


--
-- Name: COLUMN account_report_expression.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_report_expression_domain_engine_subformula_required ON account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_report_expression_domain_engine_subformula_required ON public.account_report_expression IS 'CHECK(engine != ''domain'' OR subformula IS NOT NULL)';


--
-- Name: account_report_expression_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_expression_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_expression_id_seq OWNER TO runbot;

--
-- Name: account_report_expression_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_expression_id_seq OWNED BY public.account_report_expression.id;


--
-- Name: account_report_external_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_external_value (
    id integer NOT NULL,
    target_report_expression_id integer NOT NULL,
    company_id integer NOT NULL,
    foreign_vat_fiscal_position_id integer,
    carryover_origin_report_line_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    text_value character varying,
    carryover_origin_expression_label character varying,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


ALTER TABLE public.account_report_external_value OWNER TO runbot;

--
-- Name: TABLE account_report_external_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_external_value IS 'Accounting Report External Value';


--
-- Name: COLUMN account_report_external_value.target_report_expression_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.target_report_expression_id IS 'Target Expression';


--
-- Name: COLUMN account_report_external_value.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.company_id IS 'Company';


--
-- Name: COLUMN account_report_external_value.foreign_vat_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.foreign_vat_fiscal_position_id IS 'Fiscal position';


--
-- Name: COLUMN account_report_external_value.carryover_origin_report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_report_line_id IS 'Origin Line';


--
-- Name: COLUMN account_report_external_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_external_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_external_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.name IS 'Name';


--
-- Name: COLUMN account_report_external_value.text_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.text_value IS 'Text Value';


--
-- Name: COLUMN account_report_external_value.carryover_origin_expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_expression_label IS 'Origin Expression Label';


--
-- Name: COLUMN account_report_external_value.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.date IS 'Date';


--
-- Name: COLUMN account_report_external_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_date IS 'Created on';


--
-- Name: COLUMN account_report_external_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_external_value.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.value IS 'Numeric Value';


--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_external_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_external_value_id_seq OWNER TO runbot;

--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_external_value_id_seq OWNED BY public.account_report_external_value.id;


--
-- Name: account_report_file_download_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_file_download_error_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    file_name character varying,
    actionable_errors jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_file_download_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_report_file_download_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_file_download_error_wizard IS 'Manage the file generation errors from report exports.';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_file_download_error_wizard.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.file_name IS 'File Name';


--
-- Name: COLUMN account_report_file_download_error_wizard.actionable_errors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.actionable_errors IS 'Actionable Errors';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_file_download_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNED BY public.account_report_file_download_error_wizard.id;


--
-- Name: account_report_horizontal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group IS 'Horizontal group for reports';


--
-- Name: COLUMN account_report_horizontal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.name IS 'Name';


--
-- Name: COLUMN account_report_horizontal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNED BY public.account_report_horizontal_group.id;


--
-- Name: account_report_horizontal_group_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group_rule (
    id integer NOT NULL,
    horizontal_group_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    domain character varying NOT NULL,
    field_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group_rule OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group_rule IS 'Horizontal group rule for reports';


--
-- Name: COLUMN account_report_horizontal_group_rule.horizontal_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.horizontal_group_id IS 'Horizontal Group';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group_rule.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.domain IS 'Domain';


--
-- Name: COLUMN account_report_horizontal_group_rule.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.field_name IS 'Field';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNED BY public.account_report_horizontal_group_rule.id;


--
-- Name: account_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_id_seq OWNER TO runbot;

--
-- Name: account_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_id_seq OWNED BY public.account_report.id;


--
-- Name: account_report_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_line (
    id integer NOT NULL,
    report_id integer NOT NULL,
    hierarchy_level integer NOT NULL,
    parent_id integer,
    sequence integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    groupby character varying,
    user_groupby character varying,
    code character varying,
    horizontal_split_side character varying,
    name jsonb NOT NULL,
    foldable boolean,
    print_on_new_page boolean,
    hide_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_line OWNER TO runbot;

--
-- Name: TABLE account_report_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_line IS 'Accounting Report Line';


--
-- Name: COLUMN account_report_line.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.report_id IS 'Parent Report';


--
-- Name: COLUMN account_report_line.hierarchy_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hierarchy_level IS 'Level';


--
-- Name: COLUMN account_report_line.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_report_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_line.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.action_id IS 'Action';


--
-- Name: COLUMN account_report_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_line.groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.groupby IS 'Group By';


--
-- Name: COLUMN account_report_line.user_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.user_groupby IS 'User Group By';


--
-- Name: COLUMN account_report_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.code IS 'Code';


--
-- Name: COLUMN account_report_line.horizontal_split_side; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.horizontal_split_side IS 'Horizontal Split Side';


--
-- Name: COLUMN account_report_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.name IS 'Name';


--
-- Name: COLUMN account_report_line.foldable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.foldable IS 'Foldable';


--
-- Name: COLUMN account_report_line.print_on_new_page; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.print_on_new_page IS 'Print On New Page';


--
-- Name: COLUMN account_report_line.hide_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hide_if_zero IS 'Hide if Zero';


--
-- Name: COLUMN account_report_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_report_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_date IS 'Last Updated on';


--
-- Name: account_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_line_id_seq OWNER TO runbot;

--
-- Name: account_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_line_id_seq OWNED BY public.account_report_line.id;


--
-- Name: account_report_section_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_section_rel (
    main_report_id integer NOT NULL,
    sub_report_id integer NOT NULL
);


ALTER TABLE public.account_report_section_rel OWNER TO runbot;

--
-- Name: TABLE account_report_section_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_section_rel IS 'RELATION BETWEEN account_report AND account_report';


--
-- Name: account_report_send; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_send (
    id integer NOT NULL,
    mail_template_id integer,
    account_report_id integer,
    create_uid integer,
    write_uid integer,
    mode character varying,
    mail_subject character varying,
    report_options jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    enable_download boolean,
    checkbox_download boolean,
    enable_send_mail boolean,
    checkbox_send_mail boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_send OWNER TO runbot;

--
-- Name: TABLE account_report_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_send IS 'Account Report Send';


--
-- Name: COLUMN account_report_send.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_report_send.account_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.account_report_id IS 'Report';


--
-- Name: COLUMN account_report_send.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_send.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_send.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mode IS 'Mode';


--
-- Name: COLUMN account_report_send.mail_subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_subject IS 'Subject';


--
-- Name: COLUMN account_report_send.report_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.report_options IS 'Report Options';


--
-- Name: COLUMN account_report_send.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_report_send.mail_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_body IS 'Contents';


--
-- Name: COLUMN account_report_send.enable_download; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.enable_download IS 'Enable Download';


--
-- Name: COLUMN account_report_send.checkbox_download; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.checkbox_download IS 'Download';


--
-- Name: COLUMN account_report_send.enable_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.enable_send_mail IS 'Enable Send Mail';


--
-- Name: COLUMN account_report_send.checkbox_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.checkbox_send_mail IS 'Email';


--
-- Name: COLUMN account_report_send.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.create_date IS 'Created on';


--
-- Name: COLUMN account_report_send.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.write_date IS 'Last Updated on';


--
-- Name: account_report_send_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_send_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_send_id_seq OWNER TO runbot;

--
-- Name: account_report_send_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_send_id_seq OWNED BY public.account_report_send.id;


--
-- Name: account_report_send_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_send_res_partner_rel (
    account_report_send_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_report_send_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_report_send_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_send_res_partner_rel IS 'RELATION BETWEEN account_report_send AND res_partner';


--
-- Name: account_reports_export_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard (
    id integer NOT NULL,
    report_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    doc_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reports_export_wizard OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard IS 'Export wizard for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.report_id IS 'Parent Report Id';


--
-- Name: COLUMN account_reports_export_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard.doc_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.doc_name IS 'Documents Name';


--
-- Name: COLUMN account_reports_export_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard_format (
    id integer NOT NULL,
    export_wizard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    fun_to_call character varying NOT NULL,
    fun_param character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reports_export_wizard_format OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard_format IS 'Export format for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard_format.export_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.export_wizard_id IS 'Parent Wizard';


--
-- Name: COLUMN account_reports_export_wizard_format.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard_format.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard_format.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.name IS 'Name';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_to_call; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_to_call IS 'Function to Call';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_param IS 'Function Parameter';


--
-- Name: COLUMN account_reports_export_wizard_format.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard_format.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNED BY public.account_reports_export_wizard_format.id;


--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNED BY public.account_reports_export_wizard.id;


--
-- Name: account_resequence_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_resequence_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    first_name character varying NOT NULL,
    ordering character varying NOT NULL,
    first_date date,
    end_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_resequence_wizard OWNER TO runbot;

--
-- Name: TABLE account_resequence_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_resequence_wizard IS 'Remake the sequence of Journal Entries.';


--
-- Name: COLUMN account_resequence_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_resequence_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_resequence_wizard.first_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_name IS 'First New Sequence';


--
-- Name: COLUMN account_resequence_wizard.ordering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.ordering IS 'Ordering';


--
-- Name: COLUMN account_resequence_wizard.first_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_date IS 'First Date';


--
-- Name: COLUMN account_resequence_wizard.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.end_date IS 'End Date';


--
-- Name: COLUMN account_resequence_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_resequence_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_date IS 'Last Updated on';


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_resequence_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNER TO runbot;

--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNED BY public.account_resequence_wizard.id;


--
-- Name: account_secure_entries_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_secure_entries_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    hash_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_secure_entries_wizard OWNER TO runbot;

--
-- Name: TABLE account_secure_entries_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_secure_entries_wizard IS 'Secure Journal Entries';


--
-- Name: COLUMN account_secure_entries_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_secure_entries_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_secure_entries_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_secure_entries_wizard.hash_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.hash_date IS 'Hash All Entries';


--
-- Name: COLUMN account_secure_entries_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_secure_entries_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_date IS 'Last Updated on';


--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_secure_entries_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNER TO runbot;

--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNED BY public.account_secure_entries_wizard.id;


--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    num_journals_without_account integer,
    create_uid integer,
    write_uid integer,
    new_journal_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_setup_bank_manual_config OWNER TO runbot;

--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account IS 'Num Journals Without Account';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNER TO runbot;

--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    tax_group_id integer NOT NULL,
    cash_basis_transition_account_id integer,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    price_include_override character varying,
    tax_exigibility character varying,
    name jsonb NOT NULL,
    description jsonb,
    invoice_label jsonb,
    invoice_legal_notes text,
    amount numeric NOT NULL,
    active boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_ar_withholding_sequence_id integer,
    l10n_ar_state_id integer,
    l10n_ar_scale_id integer,
    l10n_ar_withholding_payment_type character varying,
    l10n_ar_tax_type character varying,
    l10n_ar_code character varying,
    l10n_ar_non_taxable_amount numeric,
    l10n_ar_minimum_threshold double precision,
    api_codigo_articulo_retencion character varying,
    api_codigo_articulo_percepcion character varying,
    api_articulo_inciso_calculo_percepcion character varying,
    api_articulo_inciso_calculo_retencion character varying,
    porcentaje_exclusion double precision
);


ALTER TABLE public.account_tax OWNER TO runbot;

--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.country_id IS 'Country';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax.tax_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.price_include_override; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.price_include_override IS 'Included in Price';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Exigibility';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.description IS 'Description';


--
-- Name: COLUMN account_tax.invoice_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_label IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.invoice_legal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_legal_notes IS 'Legal Notes';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.is_base_affected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax.l10n_ar_withholding_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_withholding_sequence_id IS 'WTH Sequence';


--
-- Name: COLUMN account_tax.l10n_ar_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_state_id IS 'Jurisdiction';


--
-- Name: COLUMN account_tax.l10n_ar_scale_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_scale_id IS 'Scale';


--
-- Name: COLUMN account_tax.l10n_ar_withholding_payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_withholding_payment_type IS 'Argentina Withholding Payment Type';


--
-- Name: COLUMN account_tax.l10n_ar_tax_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_tax_type IS 'WTH Tax';


--
-- Name: COLUMN account_tax.l10n_ar_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_code IS 'AFIP Code';


--
-- Name: COLUMN account_tax.l10n_ar_non_taxable_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_non_taxable_amount IS 'Non Taxable Amount';


--
-- Name: COLUMN account_tax.l10n_ar_minimum_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_minimum_threshold IS 'Minimum Treshold';


--
-- Name: COLUMN account_tax.api_codigo_articulo_retencion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_codigo_articulo_retencion IS 'Código de Artículo/Inciso por el que retiene';


--
-- Name: COLUMN account_tax.api_codigo_articulo_percepcion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_codigo_articulo_percepcion IS 'Código de artículo Inciso por el que percibe';


--
-- Name: COLUMN account_tax.api_articulo_inciso_calculo_percepcion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_articulo_inciso_calculo_percepcion IS 'Artículo/Inciso para el cálculo percepción';


--
-- Name: COLUMN account_tax.api_articulo_inciso_calculo_retencion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_articulo_inciso_calculo_retencion IS 'Artículo/Inciso para el cálculo retención';


--
-- Name: COLUMN account_tax.porcentaje_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.porcentaje_exclusion IS 'Porcentaje de exclusión';


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_filiation_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    tax_payable_account_id integer,
    tax_receivable_account_id integer,
    advance_tax_payment_account_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    pos_receipt_label character varying,
    name jsonb NOT NULL,
    preceding_subtotal jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_ar_tribute_afip_code character varying,
    l10n_ar_vat_afip_code character varying
);


ALTER TABLE public.account_tax_group OWNER TO runbot;

--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.company_id IS 'Company';


--
-- Name: COLUMN account_tax_group.tax_payable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_payable_account_id IS 'Tax Payable Account';


--
-- Name: COLUMN account_tax_group.tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_receivable_account_id IS 'Tax Receivable Account';


--
-- Name: COLUMN account_tax_group.advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.advance_tax_payment_account_id IS 'Tax Advance Account';


--
-- Name: COLUMN account_tax_group.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.country_id IS 'Country';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.pos_receipt_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.pos_receipt_label IS 'PoS receipt label';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.preceding_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.preceding_subtotal IS 'Preceding Subtotal';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_group.l10n_ar_tribute_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_tribute_afip_code IS 'Tribute AFIP Code';


--
-- Name: COLUMN account_tax_group.l10n_ar_vat_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_vat_afip_code IS 'VAT AFIP Code';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_group_id_seq OWNER TO runbot;

--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_id_seq OWNER TO runbot;

--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_purchase_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_purchase_order_line_rel (
    purchase_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_purchase_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_purchase_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_purchase_order_line_rel IS 'RELATION BETWEEN purchase_order_line AND account_tax';


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    account_id integer,
    tax_id integer,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    repartition_type character varying NOT NULL,
    document_type character varying NOT NULL,
    factor_percent numeric NOT NULL,
    use_in_tax_closing boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_repartition_line OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.tax_id IS 'Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.document_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.document_type IS 'Related to';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNER TO runbot;

--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_sale_order_discount_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_discount_rel (
    sale_order_discount_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_discount_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_discount_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_discount_rel IS 'RELATION BETWEEN sale_order_discount AND account_tax';


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: account_tax_settlement_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_settlement_wizard (
    id integer NOT NULL,
    settlement_journal_id integer,
    report_id integer,
    company_id integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    select_journal boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_settlement_wizard OWNER TO runbot;

--
-- Name: TABLE account_tax_settlement_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_settlement_wizard IS 'Wizard para generar liquidaciones de impuestos desde ';


--
-- Name: COLUMN account_tax_settlement_wizard.settlement_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.settlement_journal_id IS 'Journal';


--
-- Name: COLUMN account_tax_settlement_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.report_id IS 'Report';


--
-- Name: COLUMN account_tax_settlement_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_tax_settlement_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.account_id IS 'Account';


--
-- Name: COLUMN account_tax_settlement_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_settlement_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_settlement_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.date IS 'Journal Entry Date';


--
-- Name: COLUMN account_tax_settlement_wizard.select_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.select_journal IS 'Select Journal';


--
-- Name: COLUMN account_tax_settlement_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_settlement_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.write_date IS 'Last Updated on';


--
-- Name: account_tax_settlement_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_settlement_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_settlement_wizard_id_seq OWNER TO runbot;

--
-- Name: account_tax_settlement_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_settlement_wizard_id_seq OWNED BY public.account_tax_settlement_wizard.id;


--
-- Name: account_tax_unit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit (
    id integer NOT NULL,
    country_id integer NOT NULL,
    main_company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    vat character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_unit OWNER TO runbot;

--
-- Name: TABLE account_tax_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit IS 'Tax Unit';


--
-- Name: COLUMN account_tax_unit.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.country_id IS 'Country';


--
-- Name: COLUMN account_tax_unit.main_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.main_company_id IS 'Main Company';


--
-- Name: COLUMN account_tax_unit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_unit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_unit.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.name IS 'Name';


--
-- Name: COLUMN account_tax_unit.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.vat IS 'Tax ID';


--
-- Name: COLUMN account_tax_unit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_unit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_date IS 'Last Updated on';


--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_unit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_unit_id_seq OWNER TO runbot;

--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_unit_id_seq OWNED BY public.account_tax_unit.id;


--
-- Name: account_tax_unit_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit_res_company_rel (
    res_company_id integer NOT NULL,
    account_tax_unit_id integer NOT NULL
);


ALTER TABLE public.account_tax_unit_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_unit_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit_res_company_rel IS 'RELATION BETWEEN res_company AND account_tax_unit';


--
-- Name: account_transfer_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_transfer_model (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    frequency character varying NOT NULL,
    state character varying NOT NULL,
    date_start date NOT NULL,
    date_stop date,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_transfer_model OWNER TO runbot;

--
-- Name: TABLE account_transfer_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_transfer_model IS 'Account Transfer Model';


--
-- Name: COLUMN account_transfer_model.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_transfer_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.name IS 'Name';


--
-- Name: COLUMN account_transfer_model.frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.frequency IS 'Frequency';


--
-- Name: COLUMN account_transfer_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.state IS 'State';


--
-- Name: COLUMN account_transfer_model.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.date_start IS 'Start Date';


--
-- Name: COLUMN account_transfer_model.date_stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.date_stop IS 'Stop Date';


--
-- Name: COLUMN account_transfer_model.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.active IS 'Active';


--
-- Name: COLUMN account_transfer_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.write_date IS 'Last Updated on';


--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_transfer_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_transfer_model_id_seq OWNER TO runbot;

--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_transfer_model_id_seq OWNED BY public.account_transfer_model.id;


--
-- Name: account_transfer_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_transfer_model_line (
    id integer NOT NULL,
    transfer_model_id integer NOT NULL,
    account_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percent double precision NOT NULL
);


ALTER TABLE public.account_transfer_model_line OWNER TO runbot;

--
-- Name: TABLE account_transfer_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_transfer_model_line IS 'Account Transfer Model Line';


--
-- Name: COLUMN account_transfer_model_line.transfer_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.transfer_model_id IS 'Transfer Model';


--
-- Name: COLUMN account_transfer_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.account_id IS 'Destination Account';


--
-- Name: COLUMN account_transfer_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_transfer_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_transfer_model_line.percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.percent IS 'Percent';


--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_transfer_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_transfer_model_line_id_seq OWNER TO runbot;

--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_transfer_model_line_id_seq OWNED BY public.account_transfer_model_line.id;


--
-- Name: account_transfer_model_line_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_transfer_model_line_res_partner_rel (
    account_transfer_model_line_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_transfer_model_line_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_transfer_model_line_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_transfer_model_line_res_partner_rel IS 'RELATION BETWEEN account_transfer_model_line AND res_partner';


--
-- Name: account_write_off_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_write_off_type (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    label character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_write_off_type OWNER TO runbot;

--
-- Name: TABLE account_write_off_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_write_off_type IS 'account.write_off.type';


--
-- Name: COLUMN account_write_off_type.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.account_id IS 'Account';


--
-- Name: COLUMN account_write_off_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.create_uid IS 'Created by';


--
-- Name: COLUMN account_write_off_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_write_off_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.name IS 'Name';


--
-- Name: COLUMN account_write_off_type.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.label IS 'Label';


--
-- Name: COLUMN account_write_off_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.active IS 'Active';


--
-- Name: COLUMN account_write_off_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.create_date IS 'Created on';


--
-- Name: COLUMN account_write_off_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.write_date IS 'Last Updated on';


--
-- Name: account_write_off_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_write_off_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_write_off_type_id_seq OWNER TO runbot;

--
-- Name: account_write_off_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_write_off_type_id_seq OWNED BY public.account_write_off_type.id;


--
-- Name: account_write_off_type_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_write_off_type_res_company_rel (
    account_write_off_type_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_write_off_type_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_write_off_type_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_write_off_type_res_company_rel IS 'RELATION BETWEEN account_write_off_type AND res_company';


--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: adhoc_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_category (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_category OWNER TO runbot;

--
-- Name: TABLE adhoc_module_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_category IS 'adhoc.module.category';


--
-- Name: COLUMN adhoc_module_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.name IS 'Name';


--
-- Name: COLUMN adhoc_module_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_category_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_category_id_seq OWNED BY public.adhoc_module_category.id;


--
-- Name: public_budget_advance_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.public_budget_advance_request (
    id integer NOT NULL,
    company_id integer NOT NULL,
    user_id integer NOT NULL,
    type_id integer NOT NULL,
    approval_user integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    date date NOT NULL,
    approval_date date,
    confirmation_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.public_budget_advance_request OWNER TO runbot;

--
-- Name: TABLE public_budget_advance_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.public_budget_advance_request IS 'Advance Requests';


--
-- Name: COLUMN public_budget_advance_request.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.company_id IS 'Company';


--
-- Name: COLUMN public_budget_advance_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.user_id IS 'User';


--
-- Name: COLUMN public_budget_advance_request.type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.type_id IS 'Type';


--
-- Name: COLUMN public_budget_advance_request.approval_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.approval_user IS 'Aprobado por';


--
-- Name: COLUMN public_budget_advance_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.create_uid IS 'Created by';


--
-- Name: COLUMN public_budget_advance_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN public_budget_advance_request.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.name IS 'Name';


--
-- Name: COLUMN public_budget_advance_request.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.state IS 'State';


--
-- Name: COLUMN public_budget_advance_request.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.date IS 'Date';


--
-- Name: COLUMN public_budget_advance_request.approval_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.approval_date IS 'Approval Date';


--
-- Name: COLUMN public_budget_advance_request.confirmation_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.confirmation_date IS 'Confirmation Date';


--
-- Name: COLUMN public_budget_advance_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.create_date IS 'Created on';


--
-- Name: COLUMN public_budget_advance_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request.write_date IS 'Last Updated on';


--
-- Name: public_budget_advance_request_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.public_budget_advance_request_line (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    advance_request_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    description character varying,
    requested_amount numeric NOT NULL,
    approved_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.public_budget_advance_request_line OWNER TO runbot;

--
-- Name: TABLE public_budget_advance_request_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.public_budget_advance_request_line IS 'Advance Request Line';


--
-- Name: COLUMN public_budget_advance_request_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request_line.employee_id IS 'Employee';


--
-- Name: COLUMN public_budget_advance_request_line.advance_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request_line.advance_request_id IS 'Advance Request';


--
-- Name: COLUMN public_budget_advance_request_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request_line.create_uid IS 'Created by';


--
-- Name: COLUMN public_budget_advance_request_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN public_budget_advance_request_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request_line.description IS 'Description';


--
-- Name: COLUMN public_budget_advance_request_line.requested_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request_line.requested_amount IS 'Requested Amount';


--
-- Name: COLUMN public_budget_advance_request_line.approved_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request_line.approved_amount IS 'Approved Amount';


--
-- Name: COLUMN public_budget_advance_request_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request_line.create_date IS 'Created on';


--
-- Name: COLUMN public_budget_advance_request_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_request_line.write_date IS 'Last Updated on';


--
-- Name: public_budget_advance_return; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.public_budget_advance_return (
    id integer NOT NULL,
    company_id integer NOT NULL,
    user_id integer NOT NULL,
    type_id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    date date NOT NULL,
    confirmation_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.public_budget_advance_return OWNER TO runbot;

--
-- Name: TABLE public_budget_advance_return; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.public_budget_advance_return IS 'Advance Returns';


--
-- Name: COLUMN public_budget_advance_return.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.company_id IS 'Company';


--
-- Name: COLUMN public_budget_advance_return.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.user_id IS 'User';


--
-- Name: COLUMN public_budget_advance_return.type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.type_id IS 'Type';


--
-- Name: COLUMN public_budget_advance_return.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.move_id IS 'Move';


--
-- Name: COLUMN public_budget_advance_return.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.create_uid IS 'Created by';


--
-- Name: COLUMN public_budget_advance_return.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.write_uid IS 'Last Updated by';


--
-- Name: COLUMN public_budget_advance_return.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.name IS 'Name';


--
-- Name: COLUMN public_budget_advance_return.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.state IS 'State';


--
-- Name: COLUMN public_budget_advance_return.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.date IS 'Date';


--
-- Name: COLUMN public_budget_advance_return.confirmation_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.confirmation_date IS 'Confirmation Date';


--
-- Name: COLUMN public_budget_advance_return.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.create_date IS 'Created on';


--
-- Name: COLUMN public_budget_advance_return.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return.write_date IS 'Last Updated on';


--
-- Name: public_budget_advance_return_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.public_budget_advance_return_line (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    advance_return_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    returned_amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.public_budget_advance_return_line OWNER TO runbot;

--
-- Name: TABLE public_budget_advance_return_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.public_budget_advance_return_line IS 'Advance Return Lines';


--
-- Name: COLUMN public_budget_advance_return_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return_line.employee_id IS 'Employee';


--
-- Name: COLUMN public_budget_advance_return_line.advance_return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return_line.advance_return_id IS 'Advance Return';


--
-- Name: COLUMN public_budget_advance_return_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return_line.create_uid IS 'Created by';


--
-- Name: COLUMN public_budget_advance_return_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN public_budget_advance_return_line.returned_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return_line.returned_amount IS 'Returned Amount';


--
-- Name: COLUMN public_budget_advance_return_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return_line.create_date IS 'Created on';


--
-- Name: COLUMN public_budget_advance_return_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.public_budget_advance_return_line.write_date IS 'Last Updated on';


--
-- Name: advance_request_analysis; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.advance_request_analysis AS
 SELECT rq.date,
    rql.employee_id,
    rq.type_id,
    rq.confirmation_date,
    rql.id,
    rql.approved_amount AS amount,
    rq.state,
    'request'::text AS direction,
    rq.approval_date
   FROM (public.public_budget_advance_request_line rql
     JOIN public.public_budget_advance_request rq ON ((rq.id = rql.advance_request_id)))
UNION ALL
 SELECT rt.date,
    rtl.employee_id,
    rt.type_id,
    rt.confirmation_date,
    (- rtl.id) AS id,
    (- rtl.returned_amount) AS amount,
    rt.state,
    'return'::text AS direction,
    NULL::date AS approval_date
   FROM (public.public_budget_advance_return_line rtl
     JOIN public.public_budget_advance_return rt ON ((rt.id = rtl.advance_return_id)));


ALTER VIEW public.advance_request_analysis OWNER TO runbot;

--
-- Name: afip_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_activity (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT afip_activity_code_length CHECK ((length((code)::text) <= 6))
);


ALTER TABLE public.afip_activity OWNER TO runbot;

--
-- Name: TABLE afip_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_activity IS 'afip.activity';


--
-- Name: COLUMN afip_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.create_uid IS 'Created by';


--
-- Name: COLUMN afip_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_activity.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.code IS 'Code';


--
-- Name: COLUMN afip_activity.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.name IS 'Name';


--
-- Name: COLUMN afip_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.active IS 'Active';


--
-- Name: COLUMN afip_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.create_date IS 'Created on';


--
-- Name: COLUMN afip_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT afip_activity_code_length ON afip_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT afip_activity_code_length ON public.afip_activity IS 'CHECK(LENGTH(code) <= 6)';


--
-- Name: afip_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_activity_id_seq OWNER TO runbot;

--
-- Name: afip_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_activity_id_seq OWNED BY public.afip_activity.id;


--
-- Name: afip_concept; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_concept (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_concept OWNER TO runbot;

--
-- Name: TABLE afip_concept; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_concept IS 'afip.concept';


--
-- Name: COLUMN afip_concept.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_uid IS 'Created by';


--
-- Name: COLUMN afip_concept.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_concept.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.code IS 'Code';


--
-- Name: COLUMN afip_concept.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.name IS 'Name';


--
-- Name: COLUMN afip_concept.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.active IS 'Active';


--
-- Name: COLUMN afip_concept.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_date IS 'Created on';


--
-- Name: COLUMN afip_concept.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_date IS 'Last Updated on';


--
-- Name: afip_concept_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_concept_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_concept_id_seq OWNER TO runbot;

--
-- Name: afip_concept_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_concept_id_seq OWNED BY public.afip_concept.id;


--
-- Name: afip_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_tax (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_tax OWNER TO runbot;

--
-- Name: TABLE afip_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_tax IS 'afip.tax';


--
-- Name: COLUMN afip_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_uid IS 'Created by';


--
-- Name: COLUMN afip_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_tax.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.code IS 'Code';


--
-- Name: COLUMN afip_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.name IS 'Name';


--
-- Name: COLUMN afip_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.active IS 'Active';


--
-- Name: COLUMN afip_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_date IS 'Created on';


--
-- Name: COLUMN afip_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_date IS 'Last Updated on';


--
-- Name: afip_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_tax_id_seq OWNER TO runbot;

--
-- Name: afip_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_tax_id_seq OWNED BY public.afip_tax.id;


--
-- Name: arba_cot_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.arba_cot_wizard (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tipo_recorrido character varying NOT NULL,
    patente_vehiculo character varying,
    patente_acoplado character varying,
    prod_no_term_dev character varying NOT NULL,
    datetime_out timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    importe double precision
);


ALTER TABLE public.arba_cot_wizard OWNER TO runbot;

--
-- Name: TABLE arba_cot_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.arba_cot_wizard IS 'arba.cot.wizard';


--
-- Name: COLUMN arba_cot_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.partner_id IS 'Transportista';


--
-- Name: COLUMN arba_cot_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN arba_cot_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN arba_cot_wizard.tipo_recorrido; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.tipo_recorrido IS 'Tipo Recorrido';


--
-- Name: COLUMN arba_cot_wizard.patente_vehiculo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.patente_vehiculo IS 'Patente Vehiculo';


--
-- Name: COLUMN arba_cot_wizard.patente_acoplado; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.patente_acoplado IS 'Patente Acoplado';


--
-- Name: COLUMN arba_cot_wizard.prod_no_term_dev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.prod_no_term_dev IS 'Productos no terminados / devoluciones';


--
-- Name: COLUMN arba_cot_wizard.datetime_out; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.datetime_out IS 'Datetime Out';


--
-- Name: COLUMN arba_cot_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.create_date IS 'Created on';


--
-- Name: COLUMN arba_cot_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN arba_cot_wizard.importe; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.importe IS 'Importe Neto';


--
-- Name: arba_cot_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.arba_cot_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.arba_cot_wizard_id_seq OWNER TO runbot;

--
-- Name: arba_cot_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.arba_cot_wizard_id_seq OWNED BY public.arba_cot_wizard.id;


--
-- Name: asset_modify; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.asset_modify (
    id integer NOT NULL,
    asset_id integer NOT NULL,
    method_number integer NOT NULL,
    account_asset_id integer,
    account_asset_counterpart_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    create_uid integer,
    write_uid integer,
    method_period character varying,
    modify_action character varying,
    date date,
    name text,
    value_residual numeric,
    salvage_value numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.asset_modify OWNER TO runbot;

--
-- Name: TABLE asset_modify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.asset_modify IS 'Modify Asset';


--
-- Name: COLUMN asset_modify.asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.asset_id IS 'Asset';


--
-- Name: COLUMN asset_modify.method_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.method_number IS 'Duration';


--
-- Name: COLUMN asset_modify.account_asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_asset_id IS 'Gross Increase Account';


--
-- Name: COLUMN asset_modify.account_asset_counterpart_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_asset_counterpart_id IS 'Asset Counterpart Account';


--
-- Name: COLUMN asset_modify.account_depreciation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN asset_modify.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN asset_modify.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.create_uid IS 'Created by';


--
-- Name: COLUMN asset_modify.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.write_uid IS 'Last Updated by';


--
-- Name: COLUMN asset_modify.method_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN asset_modify.modify_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.modify_action IS 'Action';


--
-- Name: COLUMN asset_modify.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.date IS 'Date';


--
-- Name: COLUMN asset_modify.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.name IS 'Note';


--
-- Name: COLUMN asset_modify.value_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.value_residual IS 'Depreciable Amount';


--
-- Name: COLUMN asset_modify.salvage_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.salvage_value IS 'Not Depreciable Amount';


--
-- Name: COLUMN asset_modify.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.create_date IS 'Created on';


--
-- Name: COLUMN asset_modify.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.write_date IS 'Last Updated on';


--
-- Name: asset_modify_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.asset_modify_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.asset_modify_id_seq OWNER TO runbot;

--
-- Name: asset_modify_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.asset_modify_id_seq OWNED BY public.asset_modify.id;


--
-- Name: asset_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.asset_move_line_rel (
    asset_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.asset_move_line_rel OWNER TO runbot;

--
-- Name: TABLE asset_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.asset_move_line_rel IS 'RELATION BETWEEN account_asset AND account_move_line';


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: avatax_connection_test_result; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_connection_test_result (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_response text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_connection_test_result OWNER TO runbot;

--
-- Name: TABLE avatax_connection_test_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_connection_test_result IS 'Test connection with avatax';


--
-- Name: COLUMN avatax_connection_test_result.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_connection_test_result.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_connection_test_result.server_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.server_response IS 'Server Response';


--
-- Name: COLUMN avatax_connection_test_result.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_date IS 'Created on';


--
-- Name: COLUMN avatax_connection_test_result.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_date IS 'Last Updated on';


--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_connection_test_result_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNER TO runbot;

--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNED BY public.avatax_connection_test_result.id;


--
-- Name: avatax_exemption; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_exemption (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    description character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_exemption OWNER TO runbot;

--
-- Name: TABLE avatax_exemption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_exemption IS 'Avatax Partner Exemption Codes';


--
-- Name: COLUMN avatax_exemption.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.company_id IS 'Company';


--
-- Name: COLUMN avatax_exemption.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_exemption.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_exemption.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.name IS 'Name';


--
-- Name: COLUMN avatax_exemption.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.code IS 'Code';


--
-- Name: COLUMN avatax_exemption.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.description IS 'Description';


--
-- Name: COLUMN avatax_exemption.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.create_date IS 'Created on';


--
-- Name: COLUMN avatax_exemption.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.write_date IS 'Last Updated on';


--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_exemption_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_exemption_id_seq OWNER TO runbot;

--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_exemption_id_seq OWNED BY public.avatax_exemption.id;


--
-- Name: avatax_exemption_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_exemption_res_country_rel (
    avatax_exemption_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.avatax_exemption_res_country_rel OWNER TO runbot;

--
-- Name: TABLE avatax_exemption_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_exemption_res_country_rel IS 'RELATION BETWEEN avatax_exemption AND res_country';


--
-- Name: avatax_validate_address; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_validate_address (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_validate_address OWNER TO runbot;

--
-- Name: TABLE avatax_validate_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_validate_address IS 'Suggests validated addresses from Avatax';


--
-- Name: COLUMN avatax_validate_address.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.partner_id IS 'Partner';


--
-- Name: COLUMN avatax_validate_address.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_validate_address.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_validate_address.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.create_date IS 'Created on';


--
-- Name: COLUMN avatax_validate_address.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.write_date IS 'Last Updated on';


--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_validate_address_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_validate_address_id_seq OWNER TO runbot;

--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_validate_address_id_seq OWNED BY public.avatax_validate_address.id;


--
-- Name: barcode_nomenclature; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_nomenclature (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    upc_ean_conv character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    gs1_separator_fnc1 character varying,
    is_gs1_nomenclature boolean
);


ALTER TABLE public.barcode_nomenclature OWNER TO runbot;

--
-- Name: TABLE barcode_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_nomenclature IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_nomenclature.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_nomenclature.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.name IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.upc_ean_conv; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.upc_ean_conv IS 'UPC/EAN Conversion';


--
-- Name: COLUMN barcode_nomenclature.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_date IS 'Created on';


--
-- Name: COLUMN barcode_nomenclature.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_nomenclature.gs1_separator_fnc1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.gs1_separator_fnc1 IS 'FNC1 Separator';


--
-- Name: COLUMN barcode_nomenclature.is_gs1_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.is_gs1_nomenclature IS 'Is GS1 Nomenclature';


--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_nomenclature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNER TO runbot;

--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNED BY public.barcode_nomenclature.id;


--
-- Name: barcode_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_rule (
    id integer NOT NULL,
    barcode_nomenclature_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    encoding character varying NOT NULL,
    type character varying NOT NULL,
    pattern character varying NOT NULL,
    alias character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    associated_uom_id integer,
    gs1_content_type character varying,
    gs1_decimal_usage boolean
);


ALTER TABLE public.barcode_rule OWNER TO runbot;

--
-- Name: TABLE barcode_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_rule IS 'Barcode Rule';


--
-- Name: COLUMN barcode_rule.barcode_nomenclature_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.barcode_nomenclature_id IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.sequence IS 'Sequence';


--
-- Name: COLUMN barcode_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.name IS 'Rule Name';


--
-- Name: COLUMN barcode_rule.encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.encoding IS 'Encoding';


--
-- Name: COLUMN barcode_rule.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.type IS 'Type';


--
-- Name: COLUMN barcode_rule.pattern; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.pattern IS 'Barcode Pattern';


--
-- Name: COLUMN barcode_rule.alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.alias IS 'Alias';


--
-- Name: COLUMN barcode_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_date IS 'Created on';


--
-- Name: COLUMN barcode_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_rule.associated_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.associated_uom_id IS 'Associated Uom';


--
-- Name: COLUMN barcode_rule.gs1_content_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_content_type IS 'GS1 Content Type';


--
-- Name: COLUMN barcode_rule.gs1_decimal_usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_decimal_usage IS 'Decimal';


--
-- Name: barcode_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_rule_id_seq OWNER TO runbot;

--
-- Name: barcode_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_rule_id_seq OWNED BY public.barcode_rule.id;


--
-- Name: base_automation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation (
    id integer NOT NULL,
    model_id integer NOT NULL,
    trg_selection_field_id integer,
    trg_field_ref integer,
    trg_date_id integer,
    trg_date_range integer,
    trg_date_calendar_id integer,
    create_uid integer,
    write_uid integer,
    webhook_uuid character varying,
    record_getter character varying,
    trigger character varying NOT NULL,
    trg_date_range_type character varying,
    filter_pre_domain character varying,
    filter_domain character varying,
    name jsonb NOT NULL,
    description text,
    log_webhook_calls boolean,
    active boolean,
    last_run timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_sale_order_alert boolean
);


ALTER TABLE public.base_automation OWNER TO runbot;

--
-- Name: TABLE base_automation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation IS 'Automation Rule';


--
-- Name: COLUMN base_automation.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.model_id IS 'Model';


--
-- Name: COLUMN base_automation.trg_selection_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_selection_field_id IS 'Trigger Field';


--
-- Name: COLUMN base_automation.trg_field_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_field_ref IS 'Trigger Reference';


--
-- Name: COLUMN base_automation.trg_date_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_id IS 'Trigger Date';


--
-- Name: COLUMN base_automation.trg_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_range IS 'Delay after trigger date';


--
-- Name: COLUMN base_automation.trg_date_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_calendar_id IS 'Use Calendar';


--
-- Name: COLUMN base_automation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation.webhook_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.webhook_uuid IS 'Webhook UUID';


--
-- Name: COLUMN base_automation.record_getter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.record_getter IS 'Record Getter';


--
-- Name: COLUMN base_automation.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trigger IS 'Trigger';


--
-- Name: COLUMN base_automation.trg_date_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_range_type IS 'Delay type';


--
-- Name: COLUMN base_automation.filter_pre_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.filter_pre_domain IS 'Before Update Domain';


--
-- Name: COLUMN base_automation.filter_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.filter_domain IS 'Apply on';


--
-- Name: COLUMN base_automation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.name IS 'Automation Rule Name';


--
-- Name: COLUMN base_automation.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.description IS 'Description';


--
-- Name: COLUMN base_automation.log_webhook_calls; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.log_webhook_calls IS 'Log Calls';


--
-- Name: COLUMN base_automation.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.active IS 'Active';


--
-- Name: COLUMN base_automation.last_run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.last_run IS 'Last Run';


--
-- Name: COLUMN base_automation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.create_date IS 'Created on';


--
-- Name: COLUMN base_automation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_automation.is_sale_order_alert; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.is_sale_order_alert IS 'Is Sale Order Alert';


--
-- Name: base_automation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_automation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_id_seq OWNER TO runbot;

--
-- Name: base_automation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_automation_id_seq OWNED BY public.base_automation.id;


--
-- Name: base_automation_ir_model_fields_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_ir_model_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_ir_model_fields_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_ir_model_fields_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_ir_model_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_automation_onchange_fields_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_onchange_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_onchange_fields_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_onchange_fields_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_onchange_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_automation_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    base_automation_id integer NOT NULL
);


ALTER TABLE public.base_automation_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND base_automation';


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_assets OWNER TO runbot;

--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_default OWNER TO runbot;

--
-- Name: base_cache_signaling_groups; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_groups
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_groups OWNER TO runbot;

--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_routing OWNER TO runbot;

--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_templates OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    from_invoice boolean
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_document_layout.from_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.from_invoice IS 'From Invoice';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install (
    id integer NOT NULL,
    confirm_input integer,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install OWNER TO runbot;

--
-- Name: TABLE base_module_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install IS 'Module Install';


--
-- Name: COLUMN base_module_install.confirm_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.confirm_input IS 'Confirm Input';


--
-- Name: COLUMN base_module_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.show_all IS 'Show All';


--
-- Name: COLUMN base_module_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_date IS 'Last Updated on';


--
-- Name: base_module_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_id_seq OWNER TO runbot;

--
-- Name: base_module_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_id_seq OWNED BY public.base_module_install.id;


--
-- Name: base_module_install_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_ir_module_module_rel (
    base_module_install_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_install_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_install_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_ir_module_module_rel IS 'RELATION BETWEEN base_module_install AND ir_module_module';


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    confirm_input integer
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_module_uninstall.confirm_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.confirm_input IS 'Confirm Input';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: bill_to_po_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bill_to_po_wizard (
    id integer NOT NULL,
    purchase_order_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bill_to_po_wizard OWNER TO runbot;

--
-- Name: TABLE bill_to_po_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bill_to_po_wizard IS 'Bill to Purchase Order';


--
-- Name: COLUMN bill_to_po_wizard.purchase_order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.purchase_order_id IS 'Purchase Order';


--
-- Name: COLUMN bill_to_po_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN bill_to_po_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN bill_to_po_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bill_to_po_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.create_date IS 'Created on';


--
-- Name: COLUMN bill_to_po_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.write_date IS 'Last Updated on';


--
-- Name: bill_to_po_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bill_to_po_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bill_to_po_wizard_id_seq OWNER TO runbot;

--
-- Name: bill_to_po_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bill_to_po_wizard_id_seq OWNED BY public.bill_to_po_wizard.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    guest_id integer,
    CONSTRAINT bus_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN bus_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.guest_id IS 'Guest';


--
-- Name: CONSTRAINT bus_presence_partner_or_guest_exists ON bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT bus_presence_partner_or_guest_exists ON public.bus_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm (
    id integer NOT NULL,
    duration integer NOT NULL,
    duration_minutes integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    alarm_type character varying NOT NULL,
    "interval" character varying NOT NULL,
    name jsonb NOT NULL,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer,
    sms_notify_responsible boolean
);


ALTER TABLE public.calendar_alarm OWNER TO runbot;

--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm IS 'Event Alarm';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration IS 'Remind Before';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.mail_template_id IS 'Email Template';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.alarm_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.alarm_type IS 'Type';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.body IS 'Additional Message';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_alarm.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN calendar_alarm.sms_notify_responsible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.sms_notify_responsible IS 'Notify Responsible';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.calendar_alarm_calendar_event_rel OWNER TO runbot;

--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_alarm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_alarm_id_seq OWNER TO runbot;

--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_alarm_id_seq OWNED BY public.calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_attendee (
    id integer NOT NULL,
    event_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    common_name character varying,
    access_token character varying,
    state character varying,
    availability character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_attendee OWNER TO runbot;

--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_attendee IS 'Calendar Attendee Information';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.partner_id IS 'Attendee';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.common_name IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.availability IS 'Available/Busy';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_attendee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_attendee_id_seq OWNER TO runbot;

--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_attendee_id_seq OWNED BY public.calendar_attendee.id;


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event (
    id integer NOT NULL,
    user_id integer,
    videocall_channel_id integer,
    res_id integer,
    res_model_id integer,
    recurrence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location character varying,
    videocall_location character varying,
    access_token character varying,
    privacy character varying,
    show_as character varying NOT NULL,
    res_model character varying,
    start_date date,
    stop_date date,
    description text,
    active boolean,
    allday boolean,
    recurrency boolean,
    follow_recurrence boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.calendar_event OWNER TO runbot;

--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event IS 'Calendar Event';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.user_id IS 'Organizer';


--
-- Name: COLUMN calendar_event.videocall_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_channel_id IS 'Discuss Channel';


--
-- Name: COLUMN calendar_event.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_id IS 'Document ID';


--
-- Name: COLUMN calendar_event.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model_id IS 'Document Model';


--
-- Name: COLUMN calendar_event.recurrence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrence_id IS 'Recurrence Rule';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.videocall_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_location IS 'Meeting URL';


--
-- Name: COLUMN calendar_event.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_event.privacy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.privacy IS 'Privacy';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.show_as IS 'Show as';


--
-- Name: COLUMN calendar_event.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model IS 'Document Model Name';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.follow_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.follow_recurrence IS 'Follow Recurrence';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start IS 'Start';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop IS 'Stop';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.duration IS 'Duration';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_id_seq OWNER TO runbot;

--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_id_seq OWNED BY public.calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_res_partner_rel (
    res_partner_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


ALTER TABLE public.calendar_event_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_res_partner_rel IS 'RELATION BETWEEN res_partner AND calendar_event';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_event_type OWNER TO runbot;

--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_type IS 'Event Meeting Type';


--
-- Name: COLUMN calendar_event_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.color IS 'Color';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_type_id_seq OWNER TO runbot;

--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_type_id_seq OWNED BY public.calendar_event_type.id;


--
-- Name: calendar_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_filters (
    id integer NOT NULL,
    user_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    partner_checked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_filters OWNER TO runbot;

--
-- Name: TABLE calendar_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_filters IS 'Calendar Filters';


--
-- Name: COLUMN calendar_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.user_id IS 'Me';


--
-- Name: COLUMN calendar_filters.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_id IS 'Employee';


--
-- Name: COLUMN calendar_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.active IS 'Active';


--
-- Name: COLUMN calendar_filters.partner_checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_checked IS 'Checked';


--
-- Name: COLUMN calendar_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_date IS 'Created on';


--
-- Name: COLUMN calendar_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_date IS 'Last Updated on';


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_filters_id_seq OWNER TO runbot;

--
-- Name: calendar_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_filters_id_seq OWNED BY public.calendar_filters.id;


--
-- Name: calendar_popover_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_popover_delete_wizard (
    id integer NOT NULL,
    record integer,
    create_uid integer,
    write_uid integer,
    delete character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_popover_delete_wizard OWNER TO runbot;

--
-- Name: TABLE calendar_popover_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_popover_delete_wizard IS 'Calendar Popover Delete Wizard';


--
-- Name: COLUMN calendar_popover_delete_wizard.record; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.record IS 'Calendar Event';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_popover_delete_wizard.delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.delete IS 'Delete';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_popover_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNED BY public.calendar_popover_delete_wizard.id;


--
-- Name: calendar_provider_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_provider_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    external_calendar_provider character varying,
    cal_client_id character varying,
    cal_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    cal_sync_paused boolean,
    microsoft_outlook_sync_paused boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_provider_config OWNER TO runbot;

--
-- Name: TABLE calendar_provider_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_provider_config IS 'Calendar Provider Configuration Wizard';


--
-- Name: COLUMN calendar_provider_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_provider_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_provider_config.external_calendar_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.external_calendar_provider IS 'Choose an external calendar to configure';


--
-- Name: COLUMN calendar_provider_config.cal_client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_id IS 'Google Client_id';


--
-- Name: COLUMN calendar_provider_config.cal_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_secret IS 'Google Client_key';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN calendar_provider_config.cal_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_sync_paused IS 'Google Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_sync_paused IS 'Outlook Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_date IS 'Created on';


--
-- Name: COLUMN calendar_provider_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_date IS 'Last Updated on';


--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_provider_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_provider_config_id_seq OWNER TO runbot;

--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_provider_config_id_seq OWNED BY public.calendar_provider_config.id;


--
-- Name: calendar_recurrence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_recurrence (
    id integer NOT NULL,
    base_event_id integer,
    "interval" integer,
    count integer,
    day integer,
    trigger_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    event_tz character varying,
    rrule character varying,
    rrule_type character varying,
    end_type character varying,
    month_by character varying,
    weekday character varying,
    byday character varying,
    until date,
    mon boolean,
    tue boolean,
    wed boolean,
    thu boolean,
    fri boolean,
    sat boolean,
    sun boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT calendar_recurrence_month_day CHECK ((((rrule_type)::text <> 'monthly'::text) OR ((month_by)::text <> 'day'::text) OR ((day >= 1) AND (day <= 31)) OR (((weekday)::text = ANY ((ARRAY['MON'::character varying, 'TUE'::character varying, 'WED'::character varying, 'THU'::character varying, 'FRI'::character varying, 'SAT'::character varying, 'SUN'::character varying])::text[])) AND ((byday)::text = ANY ((ARRAY['1'::character varying, '2'::character varying, '3'::character varying, '4'::character varying, '-1'::character varying])::text[])))))
);


ALTER TABLE public.calendar_recurrence OWNER TO runbot;

--
-- Name: TABLE calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_recurrence IS 'Event Recurrence Rule';


--
-- Name: COLUMN calendar_recurrence.base_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.base_event_id IS 'Base Event';


--
-- Name: COLUMN calendar_recurrence."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence."interval" IS 'Interval';


--
-- Name: COLUMN calendar_recurrence.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.count IS 'Count';


--
-- Name: COLUMN calendar_recurrence.day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.day IS 'Day';


--
-- Name: COLUMN calendar_recurrence.trigger_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.trigger_id IS 'Trigger';


--
-- Name: COLUMN calendar_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_recurrence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.name IS 'Name';


--
-- Name: COLUMN calendar_recurrence.event_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.event_tz IS 'Timezone';


--
-- Name: COLUMN calendar_recurrence.rrule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule IS 'Rrule';


--
-- Name: COLUMN calendar_recurrence.rrule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule_type IS 'Rrule Type';


--
-- Name: COLUMN calendar_recurrence.end_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.end_type IS 'End Type';


--
-- Name: COLUMN calendar_recurrence.month_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.month_by IS 'Month By';


--
-- Name: COLUMN calendar_recurrence.weekday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.weekday IS 'Weekday';


--
-- Name: COLUMN calendar_recurrence.byday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.byday IS 'By day';


--
-- Name: COLUMN calendar_recurrence.until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.until IS 'Repeat Until';


--
-- Name: COLUMN calendar_recurrence.mon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.mon IS 'Mon';


--
-- Name: COLUMN calendar_recurrence.tue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.tue IS 'Tue';


--
-- Name: COLUMN calendar_recurrence.wed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.wed IS 'Wed';


--
-- Name: COLUMN calendar_recurrence.thu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.thu IS 'Thu';


--
-- Name: COLUMN calendar_recurrence.fri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.fri IS 'Fri';


--
-- Name: COLUMN calendar_recurrence.sat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sat IS 'Sat';


--
-- Name: COLUMN calendar_recurrence.sun; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sun IS 'Sun';


--
-- Name: COLUMN calendar_recurrence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN calendar_recurrence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT calendar_recurrence_month_day ON calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT calendar_recurrence_month_day ON public.calendar_recurrence IS 'CHECK (rrule_type != ''monthly'' OR month_by != ''day'' OR day >= 1 AND day <= 31 OR weekday in (''MON'', ''TUE'', ''WED'', ''THU'', ''FRI'', ''SAT'', ''SUN'') AND byday in (''1'', ''2'', ''3'', ''4'', ''-1''))';


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_recurrence_id_seq OWNER TO runbot;

--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_recurrence_id_seq OWNED BY public.calendar_recurrence.id;


--
-- Name: certificate_certificate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.certificate_certificate (
    id integer NOT NULL,
    private_key_id integer,
    public_key_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    pkcs12_password character varying,
    scope character varying,
    content_format character varying,
    subject_common_name character varying,
    serial_number character varying,
    loading_error text,
    active boolean,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.certificate_certificate OWNER TO runbot;

--
-- Name: TABLE certificate_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.certificate_certificate IS 'Certificate';


--
-- Name: COLUMN certificate_certificate.private_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.private_key_id IS 'Private Key';


--
-- Name: COLUMN certificate_certificate.public_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.public_key_id IS 'Public Key';


--
-- Name: COLUMN certificate_certificate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.company_id IS 'Company';


--
-- Name: COLUMN certificate_certificate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.create_uid IS 'Created by';


--
-- Name: COLUMN certificate_certificate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN certificate_certificate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.name IS 'Name';


--
-- Name: COLUMN certificate_certificate.pkcs12_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.pkcs12_password IS 'Certificate Password';


--
-- Name: COLUMN certificate_certificate.scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.scope IS 'Certificate scope';


--
-- Name: COLUMN certificate_certificate.content_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.content_format IS 'Original certificate format';


--
-- Name: COLUMN certificate_certificate.subject_common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.subject_common_name IS 'Subject Name';


--
-- Name: COLUMN certificate_certificate.serial_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.serial_number IS 'Serial number';


--
-- Name: COLUMN certificate_certificate.loading_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.loading_error IS 'Loading error';


--
-- Name: COLUMN certificate_certificate.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.active IS 'Active';


--
-- Name: COLUMN certificate_certificate.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.date_start IS 'Available date';


--
-- Name: COLUMN certificate_certificate.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.date_end IS 'Expiration date';


--
-- Name: COLUMN certificate_certificate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.create_date IS 'Created on';


--
-- Name: COLUMN certificate_certificate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.write_date IS 'Last Updated on';


--
-- Name: certificate_certificate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.certificate_certificate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.certificate_certificate_id_seq OWNER TO runbot;

--
-- Name: certificate_certificate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.certificate_certificate_id_seq OWNED BY public.certificate_certificate.id;


--
-- Name: certificate_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.certificate_key (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    password character varying,
    loading_error text,
    public boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.certificate_key OWNER TO runbot;

--
-- Name: TABLE certificate_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.certificate_key IS 'Cryptographic Keys';


--
-- Name: COLUMN certificate_key.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.company_id IS 'Company';


--
-- Name: COLUMN certificate_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.create_uid IS 'Created by';


--
-- Name: COLUMN certificate_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN certificate_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.name IS 'Name';


--
-- Name: COLUMN certificate_key.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.password IS 'Private key password';


--
-- Name: COLUMN certificate_key.loading_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.loading_error IS 'Loading error';


--
-- Name: COLUMN certificate_key.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.public IS 'Public/Private key';


--
-- Name: COLUMN certificate_key.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.active IS 'Active';


--
-- Name: COLUMN certificate_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.create_date IS 'Created on';


--
-- Name: COLUMN certificate_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.write_date IS 'Last Updated on';


--
-- Name: certificate_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.certificate_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.certificate_key_id_seq OWNER TO runbot;

--
-- Name: certificate_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.certificate_key_id_seq OWNED BY public.certificate_key.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: confirm_stock_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.confirm_stock_sms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.confirm_stock_sms OWNER TO runbot;

--
-- Name: TABLE confirm_stock_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.confirm_stock_sms IS 'Confirm Stock SMS';


--
-- Name: COLUMN confirm_stock_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_uid IS 'Created by';


--
-- Name: COLUMN confirm_stock_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN confirm_stock_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_date IS 'Created on';


--
-- Name: COLUMN confirm_stock_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_date IS 'Last Updated on';


--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.confirm_stock_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNER TO runbot;

--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNED BY public.confirm_stock_sms.id;


--
-- Name: crm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_tag OWNER TO runbot;

--
-- Name: TABLE crm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag IS 'CRM Tag';


--
-- Name: COLUMN crm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.color IS 'Color';


--
-- Name: COLUMN crm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.name IS 'Tag Name';


--
-- Name: COLUMN crm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_date IS 'Created on';


--
-- Name: COLUMN crm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_date IS 'Last Updated on';


--
-- Name: crm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_tag_id_seq OWNER TO runbot;

--
-- Name: crm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_tag_id_seq OWNED BY public.crm_tag.id;


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    invoiced_target double precision
);


ALTER TABLE public.crm_team OWNER TO runbot;

--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team.invoiced_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.invoiced_target IS 'Invoicing Target';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_id_seq OWNER TO runbot;

--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: crm_team_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_member (
    id integer NOT NULL,
    crm_team_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_team_member OWNER TO runbot;

--
-- Name: TABLE crm_team_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_member IS 'Sales Team Member';


--
-- Name: COLUMN crm_team_member.crm_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN crm_team_member.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_team_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team_member.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.active IS 'Active';


--
-- Name: COLUMN crm_team_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_date IS 'Created on';


--
-- Name: COLUMN crm_team_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_date IS 'Last Updated on';


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_member_id_seq OWNER TO runbot;

--
-- Name: crm_team_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_member_id_seq OWNED BY public.crm_team_member.id;


--
-- Name: crm_team_sale_order_alert_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_sale_order_alert_rel (
    sale_order_alert_id integer NOT NULL,
    crm_team_id integer NOT NULL
);


ALTER TABLE public.crm_team_sale_order_alert_rel OWNER TO runbot;

--
-- Name: TABLE crm_team_sale_order_alert_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_sale_order_alert_rel IS 'RELATION BETWEEN sale_order_alert AND crm_team';


--
-- Name: db_configuration; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.db_configuration (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.db_configuration OWNER TO runbot;

--
-- Name: TABLE db_configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.db_configuration IS 'db.configuration';


--
-- Name: COLUMN db_configuration.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.create_uid IS 'Created by';


--
-- Name: COLUMN db_configuration.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.write_uid IS 'Last Updated by';


--
-- Name: COLUMN db_configuration.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.name IS 'Name';


--
-- Name: COLUMN db_configuration.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.create_date IS 'Created on';


--
-- Name: COLUMN db_configuration.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.write_date IS 'Last Updated on';


--
-- Name: db_configuration_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.db_configuration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.db_configuration_id_seq OWNER TO runbot;

--
-- Name: db_configuration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.db_configuration_id_seq OWNED BY public.db_configuration.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    kpi_account_total_revenue boolean,
    kpi_helpdesk_tickets_closed boolean,
    kpi_account_bank_cash boolean,
    kpi_all_sale_total boolean
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_account_total_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_total_revenue IS 'Revenue';


--
-- Name: COLUMN digest_digest.kpi_helpdesk_tickets_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_helpdesk_tickets_closed IS 'Tickets Closed';


--
-- Name: COLUMN digest_digest.kpi_account_bank_cash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_bank_cash IS 'Bank & Cash Moves';


--
-- Name: COLUMN digest_digest.kpi_all_sale_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_all_sale_total IS 'All Sales';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    allow_public_upload boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL))),
    CONSTRAINT discuss_channel_sub_channel_no_group_public_id CHECK (((parent_channel_id IS NULL) OR (group_public_id IS NULL)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.allow_public_upload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.allow_public_upload IS 'Allow Public Upload';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON public.discuss_channel IS 'CHECK(parent_channel_id IS NULL OR group_public_id IS NULL)';


--
-- Name: discuss_channel_hr_department_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_hr_department_rel (
    discuss_channel_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_hr_department_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_hr_department_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_hr_department_rel IS 'RELATION BETWEEN discuss_channel AND hr_department';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    fold_state character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.fold_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fold_state IS 'Conversation Fold State';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: dms_acc_rep_export_wizard_format_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.dms_acc_rep_export_wizard_format_rel (
    account_reports_export_wizard_id integer NOT NULL,
    account_reports_export_wizard_format_id integer NOT NULL
);


ALTER TABLE public.dms_acc_rep_export_wizard_format_rel OWNER TO runbot;

--
-- Name: TABLE dms_acc_rep_export_wizard_format_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.dms_acc_rep_export_wizard_format_rel IS 'RELATION BETWEEN account_reports_export_wizard AND account_reports_export_wizard_format';


--
-- Name: docs_config_installer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.docs_config_installer (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    port integer NOT NULL,
    host character varying(64) NOT NULL,
    auth_type character varying,
    username character varying(32),
    password character varying(32),
    state character varying,
    msg text,
    error_details text,
    enabled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.docs_config_installer OWNER TO runbot;

--
-- Name: TABLE docs_config_installer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.docs_config_installer IS 'docs_config.installer';


--
-- Name: COLUMN docs_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN docs_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN docs_config_installer.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.port IS 'Port';


--
-- Name: COLUMN docs_config_installer.host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.host IS 'Host';


--
-- Name: COLUMN docs_config_installer.auth_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.auth_type IS 'Authentication';


--
-- Name: COLUMN docs_config_installer.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.username IS 'Username';


--
-- Name: COLUMN docs_config_installer.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.password IS 'Password';


--
-- Name: COLUMN docs_config_installer.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.state IS 'State';


--
-- Name: COLUMN docs_config_installer.msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.msg IS 'Message';


--
-- Name: COLUMN docs_config_installer.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.error_details IS 'Error Details';


--
-- Name: COLUMN docs_config_installer.enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.enabled IS 'Enabled';


--
-- Name: COLUMN docs_config_installer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN docs_config_installer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.write_date IS 'Last Updated on';


--
-- Name: docs_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.docs_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.docs_config_installer_id_seq OWNER TO runbot;

--
-- Name: docs_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.docs_config_installer_id_seq OWNED BY public.docs_config_installer.id;


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: employee_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.employee_category_rel (
    employee_id integer NOT NULL,
    category_id integer NOT NULL
);


ALTER TABLE public.employee_category_rel OWNER TO runbot;

--
-- Name: TABLE employee_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.employee_category_rel IS 'RELATION BETWEEN hr_employee AND hr_employee_category';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: header_footer_quotation_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.header_footer_quotation_template_rel (
    quotation_document_id integer NOT NULL,
    sale_order_template_id integer NOT NULL
);


ALTER TABLE public.header_footer_quotation_template_rel OWNER TO runbot;

--
-- Name: TABLE header_footer_quotation_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.header_footer_quotation_template_rel IS 'RELATION BETWEEN quotation_document AND sale_order_template';


--
-- Name: helpdesk_sla; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla (
    id integer NOT NULL,
    team_id integer NOT NULL,
    stage_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    priority character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "time" double precision NOT NULL
);


ALTER TABLE public.helpdesk_sla OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla IS 'Helpdesk SLA Policies';


--
-- Name: COLUMN helpdesk_sla.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.team_id IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_sla.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.stage_id IS 'Target Stage';


--
-- Name: COLUMN helpdesk_sla.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_sla.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_sla.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_sla.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.priority IS 'Priority';


--
-- Name: COLUMN helpdesk_sla.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.name IS 'Name';


--
-- Name: COLUMN helpdesk_sla.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.description IS 'SLA Policy Description';


--
-- Name: COLUMN helpdesk_sla.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.active IS 'Active';


--
-- Name: COLUMN helpdesk_sla.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_sla.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_sla."time"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla."time" IS 'Within';


--
-- Name: helpdesk_sla_helpdesk_stage_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_helpdesk_stage_rel (
    helpdesk_sla_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_helpdesk_stage_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_helpdesk_stage_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_helpdesk_stage_rel IS 'RELATION BETWEEN helpdesk_sla AND helpdesk_stage';


--
-- Name: helpdesk_sla_helpdesk_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_helpdesk_tag_rel (
    helpdesk_sla_id integer NOT NULL,
    helpdesk_tag_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_helpdesk_tag_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_helpdesk_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_helpdesk_tag_rel IS 'RELATION BETWEEN helpdesk_sla AND helpdesk_tag';


--
-- Name: helpdesk_sla_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_sla_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_sla_id_seq OWNER TO runbot;

--
-- Name: helpdesk_sla_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_sla_id_seq OWNED BY public.helpdesk_sla.id;


--
-- Name: helpdesk_sla_report_analysis; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.helpdesk_sla_report_analysis AS
SELECT
    NULL::integer AS id,
    NULL::integer AS ticket_id,
    NULL::text AS description,
    NULL::character varying AS ticket_ref,
    NULL::character varying AS name,
    NULL::timestamp without time zone AS create_date,
    NULL::integer AS team_id,
    NULL::boolean AS active,
    NULL::integer AS stage_id,
    NULL::integer AS user_id,
    NULL::integer AS partner_id,
    NULL::character varying AS partner_name,
    NULL::character varying AS partner_email,
    NULL::character varying AS partner_phone,
    NULL::integer AS company_id,
    NULL::character varying AS kanban_state,
    NULL::double precision AS rating_last_value,
    NULL::double precision AS rating_avg,
    NULL::character varying AS priority,
    NULL::double precision AS ticket_close_hours,
    NULL::numeric AS ticket_open_hours,
    NULL::double precision AS ticket_assignation_hours,
    NULL::double precision AS avg_response_hours,
    NULL::double precision AS first_response_hours,
    NULL::timestamp without time zone AS close_date,
    NULL::boolean AS ticket_closed,
    NULL::integer AS sla_stage_id,
    NULL::timestamp without time zone AS sla_deadline,
    NULL::integer AS sla_id,
    NULL::double precision AS sla_exceeded_hours,
    NULL::boolean AS sla_fail,
    NULL::integer AS sla_status_failed,
    NULL::text AS sla_status,
    NULL::boolean AS sla_success,
    NULL::integer AS sale_order_id;


ALTER VIEW public.helpdesk_sla_report_analysis OWNER TO runbot;

--
-- Name: helpdesk_sla_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_res_partner_rel (
    helpdesk_sla_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.helpdesk_sla_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_res_partner_rel IS 'RELATION BETWEEN helpdesk_sla AND res_partner';


--
-- Name: helpdesk_sla_status; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_sla_status (
    id integer NOT NULL,
    ticket_id integer NOT NULL,
    sla_id integer NOT NULL,
    sla_stage_id integer,
    create_uid integer,
    write_uid integer,
    deadline timestamp without time zone,
    reached_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    exceeded_hours double precision
);


ALTER TABLE public.helpdesk_sla_status OWNER TO runbot;

--
-- Name: TABLE helpdesk_sla_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_sla_status IS 'Ticket SLA Status';


--
-- Name: COLUMN helpdesk_sla_status.ticket_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.ticket_id IS 'Ticket';


--
-- Name: COLUMN helpdesk_sla_status.sla_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.sla_id IS 'Sla';


--
-- Name: COLUMN helpdesk_sla_status.sla_stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.sla_stage_id IS 'Target Stage';


--
-- Name: COLUMN helpdesk_sla_status.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_sla_status.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_sla_status.deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.deadline IS 'Deadline';


--
-- Name: COLUMN helpdesk_sla_status.reached_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.reached_datetime IS 'Reached Date';


--
-- Name: COLUMN helpdesk_sla_status.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_sla_status.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_sla_status.exceeded_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_sla_status.exceeded_hours IS 'Exceeded Working Hours';


--
-- Name: helpdesk_sla_status_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_sla_status_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_sla_status_id_seq OWNER TO runbot;

--
-- Name: helpdesk_sla_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_sla_status_id_seq OWNED BY public.helpdesk_sla_status.id;


--
-- Name: helpdesk_stage; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage (
    id integer NOT NULL,
    sequence integer,
    template_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    legend_blocked jsonb NOT NULL,
    legend_done jsonb NOT NULL,
    legend_normal jsonb NOT NULL,
    active boolean,
    fold boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer,
    is_verified boolean
);


ALTER TABLE public.helpdesk_stage OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage IS 'Helpdesk Stage';


--
-- Name: COLUMN helpdesk_stage.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.sequence IS 'Sequence';


--
-- Name: COLUMN helpdesk_stage.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.template_id IS 'Email Template';


--
-- Name: COLUMN helpdesk_stage.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_stage.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_stage.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.name IS 'Name';


--
-- Name: COLUMN helpdesk_stage.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.description IS 'Description';


--
-- Name: COLUMN helpdesk_stage.legend_blocked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.legend_blocked IS 'Red Kanban Label';


--
-- Name: COLUMN helpdesk_stage.legend_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.legend_done IS 'Green Kanban Label';


--
-- Name: COLUMN helpdesk_stage.legend_normal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.legend_normal IS 'Grey Kanban Label';


--
-- Name: COLUMN helpdesk_stage.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.active IS 'Active';


--
-- Name: COLUMN helpdesk_stage.fold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.fold IS 'Folded in Kanban';


--
-- Name: COLUMN helpdesk_stage.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_stage.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_stage.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN helpdesk_stage.is_verified; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage.is_verified IS 'Verificar Etapa';


--
-- Name: helpdesk_stage_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage_delete_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_stage_delete_wizard OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage_delete_wizard IS 'Helpdesk Stage Delete Wizard';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_stage_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_stage_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: helpdesk_stage_delete_wizard_helpdesk_team_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel (
    helpdesk_stage_delete_wizard_id integer NOT NULL,
    helpdesk_team_id integer NOT NULL
);


ALTER TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage_delete_wizard_helpdesk_team_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage_delete_wizard_helpdesk_team_rel IS 'RELATION BETWEEN helpdesk_stage_delete_wizard AND helpdesk_team';


--
-- Name: helpdesk_stage_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_stage_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_stage_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: helpdesk_stage_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_stage_delete_wizard_id_seq OWNED BY public.helpdesk_stage_delete_wizard.id;


--
-- Name: helpdesk_stage_helpdesk_stage_delete_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel (
    helpdesk_stage_delete_wizard_id integer NOT NULL,
    helpdesk_stage_id integer NOT NULL
);


ALTER TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_stage_helpdesk_stage_delete_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_stage_helpdesk_stage_delete_wizard_rel IS 'RELATION BETWEEN helpdesk_stage_delete_wizard AND helpdesk_stage';


--
-- Name: helpdesk_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_stage_id_seq OWNER TO runbot;

--
-- Name: helpdesk_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_stage_id_seq OWNED BY public.helpdesk_stage.id;


--
-- Name: helpdesk_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_tag OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag IS 'Helpdesk Tags';


--
-- Name: COLUMN helpdesk_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.color IS 'Color';


--
-- Name: COLUMN helpdesk_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.name IS 'Name';


--
-- Name: COLUMN helpdesk_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_tag.write_date IS 'Last Updated on';


--
-- Name: helpdesk_tag_helpdesk_ticket_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_tag_helpdesk_ticket_rel (
    helpdesk_ticket_id integer NOT NULL,
    helpdesk_tag_id integer NOT NULL
);


ALTER TABLE public.helpdesk_tag_helpdesk_ticket_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_tag_helpdesk_ticket_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_tag_helpdesk_ticket_rel IS 'RELATION BETWEEN helpdesk_ticket AND helpdesk_tag';


--
-- Name: helpdesk_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_tag_id_seq OWNER TO runbot;

--
-- Name: helpdesk_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_tag_id_seq OWNED BY public.helpdesk_tag.id;


--
-- Name: helpdesk_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_team (
    id integer NOT NULL,
    alias_id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer,
    color integer,
    resource_calendar_id integer,
    auto_close_day integer,
    to_stage_id integer,
    create_uid integer,
    write_uid integer,
    assign_method character varying NOT NULL,
    privacy_visibility character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    ticket_properties jsonb,
    active boolean,
    auto_assignment boolean,
    use_alias boolean,
    allow_portal_ticket_closing boolean,
    use_website_helpdesk_form boolean,
    use_website_helpdesk_livechat boolean,
    use_website_helpdesk_forum boolean,
    use_website_helpdesk_slides boolean,
    use_website_helpdesk_knowledge boolean,
    use_helpdesk_timesheet boolean,
    use_helpdesk_sale_timesheet boolean,
    use_credit_notes boolean,
    use_coupons boolean,
    use_fsm boolean,
    use_product_returns boolean,
    use_product_repairs boolean,
    use_twitter boolean,
    use_rating boolean,
    use_sla boolean,
    auto_close_ticket boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.helpdesk_team OWNER TO runbot;

--
-- Name: TABLE helpdesk_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_team IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_team.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.alias_id IS 'Alias';


--
-- Name: COLUMN helpdesk_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.sequence IS 'Sequence';


--
-- Name: COLUMN helpdesk_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_team.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN helpdesk_team.auto_close_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.auto_close_day IS 'Inactive Period(days)';


--
-- Name: COLUMN helpdesk_team.to_stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.to_stage_id IS 'Move to Stage';


--
-- Name: COLUMN helpdesk_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_team.assign_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.assign_method IS 'Assignment Method';


--
-- Name: COLUMN helpdesk_team.privacy_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.privacy_visibility IS 'Visibility';


--
-- Name: COLUMN helpdesk_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.name IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_team.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.description IS 'About Team';


--
-- Name: COLUMN helpdesk_team.ticket_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.ticket_properties IS 'Ticket Properties';


--
-- Name: COLUMN helpdesk_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.active IS 'Active';


--
-- Name: COLUMN helpdesk_team.auto_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.auto_assignment IS 'Automatic Assignment';


--
-- Name: COLUMN helpdesk_team.use_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_alias IS 'Use Alias';


--
-- Name: COLUMN helpdesk_team.allow_portal_ticket_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.allow_portal_ticket_closing IS 'Closure by Customers';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_form IS 'Website Form';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_livechat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_livechat IS 'Live Chat';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_forum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_forum IS 'Community Forum';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_slides; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_slides IS 'eLearning';


--
-- Name: COLUMN helpdesk_team.use_website_helpdesk_knowledge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_website_helpdesk_knowledge IS 'Knowledge';


--
-- Name: COLUMN helpdesk_team.use_helpdesk_timesheet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_helpdesk_timesheet IS 'Timesheets';


--
-- Name: COLUMN helpdesk_team.use_helpdesk_sale_timesheet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_helpdesk_sale_timesheet IS 'Time Billing';


--
-- Name: COLUMN helpdesk_team.use_credit_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_credit_notes IS 'Refunds';


--
-- Name: COLUMN helpdesk_team.use_coupons; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_coupons IS 'Coupons';


--
-- Name: COLUMN helpdesk_team.use_fsm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_fsm IS 'Field Service';


--
-- Name: COLUMN helpdesk_team.use_product_returns; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_product_returns IS 'Returns';


--
-- Name: COLUMN helpdesk_team.use_product_repairs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_product_repairs IS 'Repairs';


--
-- Name: COLUMN helpdesk_team.use_twitter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_twitter IS 'X';


--
-- Name: COLUMN helpdesk_team.use_rating; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_rating IS 'Customer Ratings';


--
-- Name: COLUMN helpdesk_team.use_sla; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.use_sla IS 'SLA Policies';


--
-- Name: COLUMN helpdesk_team.auto_close_ticket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.auto_close_ticket IS 'Automatic Closing';


--
-- Name: COLUMN helpdesk_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_team.write_date IS 'Last Updated on';


--
-- Name: helpdesk_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_team_id_seq OWNER TO runbot;

--
-- Name: helpdesk_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_team_id_seq OWNED BY public.helpdesk_team.id;


--
-- Name: helpdesk_team_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_team_res_users_rel (
    helpdesk_team_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.helpdesk_team_res_users_rel OWNER TO runbot;

--
-- Name: TABLE helpdesk_team_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_team_res_users_rel IS 'RELATION BETWEEN helpdesk_team AND res_users';


--
-- Name: helpdesk_ticket; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.helpdesk_ticket (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    company_id integer,
    color integer,
    user_id integer,
    partner_id integer,
    stage_id integer,
    answered_customer_message_count integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    access_token character varying,
    name character varying NOT NULL,
    kanban_state character varying NOT NULL,
    partner_name character varying,
    partner_email character varying,
    partner_phone character varying,
    priority character varying,
    ticket_ref character varying,
    properties jsonb,
    description text,
    active boolean,
    closed_by_partner boolean,
    sla_reached_late boolean,
    sla_reached boolean,
    date_last_stage_update timestamp without time zone,
    assign_date timestamp without time zone,
    close_date timestamp without time zone,
    sla_deadline timestamp without time zone,
    oldest_unanswered_customer_message_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rating_last_value double precision,
    assign_hours double precision,
    close_hours double precision,
    sla_deadline_hours double precision,
    first_response_hours double precision,
    avg_response_hours double precision,
    total_response_hours double precision,
    sale_order_id integer,
    amount integer,
    expedient_id integer,
    responsible_user integer,
    dni character varying(11),
    cbu character varying(22),
    resolution_number character varying,
    resolution_date date
);


ALTER TABLE public.helpdesk_ticket OWNER TO runbot;

--
-- Name: TABLE helpdesk_ticket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.helpdesk_ticket IS 'Helpdesk Ticket';


--
-- Name: COLUMN helpdesk_ticket.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.campaign_id IS 'Campaign';


--
-- Name: COLUMN helpdesk_ticket.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.source_id IS 'Source';


--
-- Name: COLUMN helpdesk_ticket.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.medium_id IS 'Medium';


--
-- Name: COLUMN helpdesk_ticket.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.team_id IS 'Helpdesk Team';


--
-- Name: COLUMN helpdesk_ticket.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.company_id IS 'Company';


--
-- Name: COLUMN helpdesk_ticket.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.color IS 'Color Index';


--
-- Name: COLUMN helpdesk_ticket.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.user_id IS 'Assigned to';


--
-- Name: COLUMN helpdesk_ticket.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_id IS 'Customer';


--
-- Name: COLUMN helpdesk_ticket.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.stage_id IS 'Stage';


--
-- Name: COLUMN helpdesk_ticket.answered_customer_message_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.answered_customer_message_count IS '# Exchanges';


--
-- Name: COLUMN helpdesk_ticket.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.create_uid IS 'Created by';


--
-- Name: COLUMN helpdesk_ticket.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.write_uid IS 'Last Updated by';


--
-- Name: COLUMN helpdesk_ticket.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.email_cc IS 'Email cc';


--
-- Name: COLUMN helpdesk_ticket.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.access_token IS 'Security Token';


--
-- Name: COLUMN helpdesk_ticket.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.name IS 'Subject';


--
-- Name: COLUMN helpdesk_ticket.kanban_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.kanban_state IS 'Kanban State';


--
-- Name: COLUMN helpdesk_ticket.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_name IS 'Customer Name';


--
-- Name: COLUMN helpdesk_ticket.partner_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_email IS 'Customer Email';


--
-- Name: COLUMN helpdesk_ticket.partner_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.partner_phone IS 'Customer Phone';


--
-- Name: COLUMN helpdesk_ticket.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.priority IS 'Priority';


--
-- Name: COLUMN helpdesk_ticket.ticket_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.ticket_ref IS 'Ticket IDs Sequence';


--
-- Name: COLUMN helpdesk_ticket.properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.properties IS 'Properties';


--
-- Name: COLUMN helpdesk_ticket.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.description IS 'Description';


--
-- Name: COLUMN helpdesk_ticket.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.active IS 'Active';


--
-- Name: COLUMN helpdesk_ticket.closed_by_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.closed_by_partner IS 'Closed by Partner';


--
-- Name: COLUMN helpdesk_ticket.sla_reached_late; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_reached_late IS 'Has SLA reached late';


--
-- Name: COLUMN helpdesk_ticket.sla_reached; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_reached IS 'Has SLA reached';


--
-- Name: COLUMN helpdesk_ticket.date_last_stage_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN helpdesk_ticket.assign_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.assign_date IS 'First assignment date';


--
-- Name: COLUMN helpdesk_ticket.close_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.close_date IS 'Close date';


--
-- Name: COLUMN helpdesk_ticket.sla_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_deadline IS 'SLA Deadline';


--
-- Name: COLUMN helpdesk_ticket.oldest_unanswered_customer_message_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.oldest_unanswered_customer_message_date IS 'Oldest Unanswered Customer Message Date';


--
-- Name: COLUMN helpdesk_ticket.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.create_date IS 'Created on';


--
-- Name: COLUMN helpdesk_ticket.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.write_date IS 'Last Updated on';


--
-- Name: COLUMN helpdesk_ticket.rating_last_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.rating_last_value IS 'Rating Last Value';


--
-- Name: COLUMN helpdesk_ticket.assign_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.assign_hours IS 'Time to first assignment (hours)';


--
-- Name: COLUMN helpdesk_ticket.close_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.close_hours IS 'Time to close (hours)';


--
-- Name: COLUMN helpdesk_ticket.sla_deadline_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sla_deadline_hours IS 'Working Hours until SLA Deadline';


--
-- Name: COLUMN helpdesk_ticket.first_response_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.first_response_hours IS 'Hours to First Response';


--
-- Name: COLUMN helpdesk_ticket.avg_response_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.avg_response_hours IS 'Average Hours to Respond';


--
-- Name: COLUMN helpdesk_ticket.total_response_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.total_response_hours IS 'Total Exchange Time in Hours';


--
-- Name: COLUMN helpdesk_ticket.sale_order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.sale_order_id IS 'Ref. Sales Order';


--
-- Name: COLUMN helpdesk_ticket.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.amount IS 'Amount';


--
-- Name: COLUMN helpdesk_ticket.expedient_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.expedient_id IS 'Tramite Administrativo';


--
-- Name: COLUMN helpdesk_ticket.responsible_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.responsible_user IS 'Usuario Responsable';


--
-- Name: COLUMN helpdesk_ticket.dni; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.dni IS 'DNI';


--
-- Name: COLUMN helpdesk_ticket.cbu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.cbu IS 'CBU';


--
-- Name: COLUMN helpdesk_ticket.resolution_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.resolution_number IS 'Número de Resolución';


--
-- Name: COLUMN helpdesk_ticket.resolution_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.helpdesk_ticket.resolution_date IS 'Fecha de Resolución';


--
-- Name: helpdesk_ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.helpdesk_ticket_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.helpdesk_ticket_id_seq OWNER TO runbot;

--
-- Name: helpdesk_ticket_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.helpdesk_ticket_id_seq OWNED BY public.helpdesk_ticket.id;


--
-- Name: helpdesk_ticket_report_analysis; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.helpdesk_ticket_report_analysis AS
SELECT
    NULL::integer AS id,
    NULL::integer AS ticket_id,
    NULL::text AS description,
    NULL::character varying AS ticket_ref,
    NULL::character varying AS name,
    NULL::timestamp without time zone AS create_date,
    NULL::character varying AS priority,
    NULL::integer AS user_id,
    NULL::integer AS partner_id,
    NULL::character varying AS partner_name,
    NULL::character varying AS partner_email,
    NULL::character varying AS partner_phone,
    NULL::integer AS stage_id,
    NULL::timestamp without time zone AS sla_deadline,
    NULL::double precision AS ticket_deadline_hours,
    NULL::double precision AS ticket_close_hours,
    NULL::numeric AS ticket_open_hours,
    NULL::double precision AS ticket_assignation_hours,
    NULL::timestamp without time zone AS close_date,
    NULL::timestamp without time zone AS assign_date,
    NULL::double precision AS rating_last_value,
    NULL::double precision AS rating_avg,
    NULL::boolean AS active,
    NULL::integer AS team_id,
    NULL::integer AS company_id,
    NULL::character varying AS kanban_state,
    NULL::double precision AS first_response_hours,
    NULL::double precision AS avg_response_hours,
    NULL::boolean AS sla_success,
    NULL::integer AS sale_order_id;


ALTER VIEW public.helpdesk_ticket_report_analysis OWNER TO runbot;

--
-- Name: hr_attendance; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_attendance (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overtime_status character varying,
    in_country_name character varying,
    in_city character varying,
    in_ip_address character varying,
    in_browser character varying,
    in_mode character varying,
    out_country_name character varying,
    out_city character varying,
    out_ip_address character varying,
    out_browser character varying,
    out_mode character varying,
    in_latitude numeric,
    in_longitude numeric,
    out_latitude numeric,
    out_longitude numeric,
    check_in timestamp without time zone NOT NULL,
    check_out timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    worked_hours double precision,
    overtime_hours double precision,
    validated_overtime_hours double precision,
    expected_hours double precision
);


ALTER TABLE public.hr_attendance OWNER TO runbot;

--
-- Name: TABLE hr_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_attendance IS 'Attendance';


--
-- Name: COLUMN hr_attendance.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.employee_id IS 'Employee';


--
-- Name: COLUMN hr_attendance.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.create_uid IS 'Created by';


--
-- Name: COLUMN hr_attendance.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_attendance.overtime_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.overtime_status IS 'Overtime Status';


--
-- Name: COLUMN hr_attendance.in_country_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.in_country_name IS 'Country';


--
-- Name: COLUMN hr_attendance.in_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.in_city IS 'City';


--
-- Name: COLUMN hr_attendance.in_ip_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.in_ip_address IS 'IP Address';


--
-- Name: COLUMN hr_attendance.in_browser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.in_browser IS 'Browser';


--
-- Name: COLUMN hr_attendance.in_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.in_mode IS 'Mode';


--
-- Name: COLUMN hr_attendance.out_country_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.out_country_name IS 'Out Country Name';


--
-- Name: COLUMN hr_attendance.out_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.out_city IS 'Out City';


--
-- Name: COLUMN hr_attendance.out_ip_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.out_ip_address IS 'Out Ip Address';


--
-- Name: COLUMN hr_attendance.out_browser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.out_browser IS 'Out Browser';


--
-- Name: COLUMN hr_attendance.out_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.out_mode IS 'Out Mode';


--
-- Name: COLUMN hr_attendance.in_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.in_latitude IS 'Latitude';


--
-- Name: COLUMN hr_attendance.in_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.in_longitude IS 'Longitude';


--
-- Name: COLUMN hr_attendance.out_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.out_latitude IS 'Out Latitude';


--
-- Name: COLUMN hr_attendance.out_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.out_longitude IS 'Out Longitude';


--
-- Name: COLUMN hr_attendance.check_in; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.check_in IS 'Check In';


--
-- Name: COLUMN hr_attendance.check_out; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.check_out IS 'Check Out';


--
-- Name: COLUMN hr_attendance.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.create_date IS 'Created on';


--
-- Name: COLUMN hr_attendance.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_attendance.worked_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.worked_hours IS 'Worked Hours';


--
-- Name: COLUMN hr_attendance.overtime_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.overtime_hours IS 'Over Time';


--
-- Name: COLUMN hr_attendance.validated_overtime_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.validated_overtime_hours IS 'Extra Hours';


--
-- Name: COLUMN hr_attendance.expected_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance.expected_hours IS 'Expected Hours';


--
-- Name: hr_attendance_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_attendance_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_attendance_id_seq OWNER TO runbot;

--
-- Name: hr_attendance_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_attendance_id_seq OWNED BY public.hr_attendance.id;


--
-- Name: hr_attendance_overtime; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_attendance_overtime (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date,
    adjustment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision NOT NULL,
    duration_real double precision
);


ALTER TABLE public.hr_attendance_overtime OWNER TO runbot;

--
-- Name: TABLE hr_attendance_overtime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_attendance_overtime IS 'Attendance Overtime';


--
-- Name: COLUMN hr_attendance_overtime.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance_overtime.employee_id IS 'Employee';


--
-- Name: COLUMN hr_attendance_overtime.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance_overtime.create_uid IS 'Created by';


--
-- Name: COLUMN hr_attendance_overtime.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance_overtime.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_attendance_overtime.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance_overtime.date IS 'Day';


--
-- Name: COLUMN hr_attendance_overtime.adjustment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance_overtime.adjustment IS 'Adjustment';


--
-- Name: COLUMN hr_attendance_overtime.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance_overtime.create_date IS 'Created on';


--
-- Name: COLUMN hr_attendance_overtime.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance_overtime.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_attendance_overtime.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance_overtime.duration IS 'Extra Hours';


--
-- Name: COLUMN hr_attendance_overtime.duration_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_attendance_overtime.duration_real IS 'Extra Hours (Real)';


--
-- Name: hr_attendance_overtime_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_attendance_overtime_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_attendance_overtime_id_seq OWNER TO runbot;

--
-- Name: hr_attendance_overtime_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_attendance_overtime_id_seq OWNED BY public.hr_attendance_overtime.id;


--
-- Name: hr_contract_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_contract_type (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_contract_type OWNER TO runbot;

--
-- Name: TABLE hr_contract_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_contract_type IS 'Contract Type';


--
-- Name: COLUMN hr_contract_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_contract_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.country_id IS 'Country';


--
-- Name: COLUMN hr_contract_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_contract_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_contract_type.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.code IS 'Code';


--
-- Name: COLUMN hr_contract_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.name IS 'Name';


--
-- Name: COLUMN hr_contract_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_contract_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_contract_type.write_date IS 'Last Updated on';


--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_contract_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_contract_type_id_seq OWNER TO runbot;

--
-- Name: hr_contract_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_contract_type_id_seq OWNED BY public.hr_contract_type.id;


--
-- Name: hr_department; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_department (
    id integer NOT NULL,
    company_id integer,
    parent_id integer,
    manager_id integer,
    color integer,
    master_department_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    parent_path character varying,
    name jsonb NOT NULL,
    note text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_department OWNER TO runbot;

--
-- Name: TABLE hr_department; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_department IS 'Department';


--
-- Name: COLUMN hr_department.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.company_id IS 'Company';


--
-- Name: COLUMN hr_department.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_id IS 'Parent Department';


--
-- Name: COLUMN hr_department.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.manager_id IS 'Manager';


--
-- Name: COLUMN hr_department.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.color IS 'Color Index';


--
-- Name: COLUMN hr_department.master_department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.master_department_id IS 'Master Department';


--
-- Name: COLUMN hr_department.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_uid IS 'Created by';


--
-- Name: COLUMN hr_department.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_department.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.complete_name IS 'Complete Name';


--
-- Name: COLUMN hr_department.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.parent_path IS 'Parent Path';


--
-- Name: COLUMN hr_department.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.name IS 'Department Name';


--
-- Name: COLUMN hr_department.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.note IS 'Note';


--
-- Name: COLUMN hr_department.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.active IS 'Active';


--
-- Name: COLUMN hr_department.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.create_date IS 'Created on';


--
-- Name: COLUMN hr_department.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_department.write_date IS 'Last Updated on';


--
-- Name: hr_department_hr_leave_mandatory_day_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_department_hr_leave_mandatory_day_rel (
    hr_leave_mandatory_day_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


ALTER TABLE public.hr_department_hr_leave_mandatory_day_rel OWNER TO runbot;

--
-- Name: TABLE hr_department_hr_leave_mandatory_day_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_department_hr_leave_mandatory_day_rel IS 'RELATION BETWEEN hr_leave_mandatory_day AND hr_department';


--
-- Name: hr_department_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_department_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_department_id_seq OWNER TO runbot;

--
-- Name: hr_department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_department_id_seq OWNED BY public.hr_department.id;


--
-- Name: hr_departure_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_reason (
    id integer NOT NULL,
    sequence integer,
    reason_code integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_reason OWNER TO runbot;

--
-- Name: TABLE hr_departure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_reason IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_reason.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.sequence IS 'Sequence';


--
-- Name: COLUMN hr_departure_reason.reason_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.reason_code IS 'Reason Code';


--
-- Name: COLUMN hr_departure_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_reason.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.name IS 'Reason';


--
-- Name: COLUMN hr_departure_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_reason.write_date IS 'Last Updated on';


--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_reason_id_seq OWNER TO runbot;

--
-- Name: hr_departure_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_reason_id_seq OWNED BY public.hr_departure_reason.id;


--
-- Name: hr_departure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_departure_wizard (
    id integer NOT NULL,
    departure_reason_id integer NOT NULL,
    employee_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    departure_date date NOT NULL,
    departure_description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_departure_wizard OWNER TO runbot;

--
-- Name: TABLE hr_departure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_departure_wizard IS 'Departure Wizard';


--
-- Name: COLUMN hr_departure_wizard.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_departure_wizard.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.employee_id IS 'Employee';


--
-- Name: COLUMN hr_departure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_departure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_departure_wizard.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_date IS 'Departure Date';


--
-- Name: COLUMN hr_departure_wizard.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_departure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_departure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_departure_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_departure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_departure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_departure_wizard_id_seq OWNED BY public.hr_departure_wizard.id;


--
-- Name: hr_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee (
    id integer NOT NULL,
    resource_id integer NOT NULL,
    company_id integer NOT NULL,
    resource_calendar_id integer,
    message_main_attachment_id integer,
    color integer,
    department_id integer,
    job_id integer,
    address_id integer,
    work_contact_id integer,
    work_location_id integer,
    user_id integer,
    parent_id integer,
    coach_id integer,
    private_state_id integer,
    private_country_id integer,
    country_id integer,
    children integer,
    country_of_birth integer,
    bank_account_id integer,
    distance_home_work integer,
    km_home_work integer,
    departure_reason_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    job_title character varying,
    work_phone character varying,
    mobile_phone character varying,
    work_email character varying,
    private_street character varying,
    private_street2 character varying,
    private_city character varying,
    private_zip character varying,
    private_phone character varying,
    private_email character varying,
    lang character varying,
    gender character varying,
    marital character varying NOT NULL,
    spouse_complete_name character varying,
    place_of_birth character varying,
    ssnid character varying,
    sinid character varying,
    identification_id character varying,
    passport_id character varying,
    permit_no character varying,
    visa_no character varying,
    certificate character varying,
    study_field character varying,
    study_school character varying,
    emergency_contact character varying,
    emergency_phone character varying,
    distance_home_work_unit character varying NOT NULL,
    employee_type character varying NOT NULL,
    barcode character varying,
    pin character varying,
    private_car_plate character varying,
    spouse_birthdate date,
    birthday date,
    visa_expire date,
    work_permit_expiration_date date,
    departure_date date,
    employee_properties jsonb,
    additional_note text,
    notes text,
    departure_description text,
    active boolean,
    is_flexible boolean,
    is_fully_flexible boolean,
    work_permit_scheduled_activity boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    attendance_manager_id integer,
    last_attendance_id integer,
    last_check_in timestamp without time zone,
    last_check_out timestamp without time zone,
    leave_manager_id integer
);


ALTER TABLE public.hr_employee OWNER TO runbot;

--
-- Name: TABLE hr_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee IS 'Employee';


--
-- Name: COLUMN hr_employee.resource_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.resource_id IS 'Resource';


--
-- Name: COLUMN hr_employee.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.company_id IS 'Company';


--
-- Name: COLUMN hr_employee.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_employee.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_employee.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.color IS 'Color Index';


--
-- Name: COLUMN hr_employee.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.department_id IS 'Department';


--
-- Name: COLUMN hr_employee.job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.job_id IS 'Job Position';


--
-- Name: COLUMN hr_employee.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.address_id IS 'Work Address';


--
-- Name: COLUMN hr_employee.work_contact_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_contact_id IS 'Work Contact';


--
-- Name: COLUMN hr_employee.work_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_location_id IS 'Work Location';


--
-- Name: COLUMN hr_employee.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.user_id IS 'User';


--
-- Name: COLUMN hr_employee.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.parent_id IS 'Manager';


--
-- Name: COLUMN hr_employee.coach_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.coach_id IS 'Coach';


--
-- Name: COLUMN hr_employee.private_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_state_id IS 'Private State';


--
-- Name: COLUMN hr_employee.private_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_country_id IS 'Private Country';


--
-- Name: COLUMN hr_employee.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.country_id IS 'Nationality (Country)';


--
-- Name: COLUMN hr_employee.children; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.children IS 'Number of Dependent Children';


--
-- Name: COLUMN hr_employee.country_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.country_of_birth IS 'Country of Birth';


--
-- Name: COLUMN hr_employee.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN hr_employee.distance_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.distance_home_work IS 'Home-Work Distance';


--
-- Name: COLUMN hr_employee.km_home_work; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.km_home_work IS 'Home-Work Distance in Km';


--
-- Name: COLUMN hr_employee.departure_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.departure_reason_id IS 'Departure Reason';


--
-- Name: COLUMN hr_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.name IS 'Employee Name';


--
-- Name: COLUMN hr_employee.job_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.job_title IS 'Job Title';


--
-- Name: COLUMN hr_employee.work_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_phone IS 'Work Phone';


--
-- Name: COLUMN hr_employee.mobile_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.mobile_phone IS 'Work Mobile';


--
-- Name: COLUMN hr_employee.work_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_email IS 'Work Email';


--
-- Name: COLUMN hr_employee.private_street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_street IS 'Private Street';


--
-- Name: COLUMN hr_employee.private_street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_street2 IS 'Private Street2';


--
-- Name: COLUMN hr_employee.private_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_city IS 'Private City';


--
-- Name: COLUMN hr_employee.private_zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_zip IS 'Private Zip';


--
-- Name: COLUMN hr_employee.private_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_phone IS 'Private Phone';


--
-- Name: COLUMN hr_employee.private_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_email IS 'Private Email';


--
-- Name: COLUMN hr_employee.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.lang IS 'Lang';


--
-- Name: COLUMN hr_employee.gender; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.gender IS 'Gender';


--
-- Name: COLUMN hr_employee.marital; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.marital IS 'Marital Status';


--
-- Name: COLUMN hr_employee.spouse_complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.spouse_complete_name IS 'Spouse Complete Name';


--
-- Name: COLUMN hr_employee.place_of_birth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.place_of_birth IS 'Place of Birth';


--
-- Name: COLUMN hr_employee.ssnid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.ssnid IS 'SSN No';


--
-- Name: COLUMN hr_employee.sinid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.sinid IS 'SIN No';


--
-- Name: COLUMN hr_employee.identification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.identification_id IS 'Identification No';


--
-- Name: COLUMN hr_employee.passport_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.passport_id IS 'Passport No';


--
-- Name: COLUMN hr_employee.permit_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.permit_no IS 'Work Permit No';


--
-- Name: COLUMN hr_employee.visa_no; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_no IS 'Visa No';


--
-- Name: COLUMN hr_employee.certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.certificate IS 'Certificate Level';


--
-- Name: COLUMN hr_employee.study_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_field IS 'Field of Study';


--
-- Name: COLUMN hr_employee.study_school; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.study_school IS 'School';


--
-- Name: COLUMN hr_employee.emergency_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_contact IS 'Contact Name';


--
-- Name: COLUMN hr_employee.emergency_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.emergency_phone IS 'Contact Phone';


--
-- Name: COLUMN hr_employee.distance_home_work_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.distance_home_work_unit IS 'Home-Work Distance unit';


--
-- Name: COLUMN hr_employee.employee_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.employee_type IS 'Employee Type';


--
-- Name: COLUMN hr_employee.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.barcode IS 'Badge ID';


--
-- Name: COLUMN hr_employee.pin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.pin IS 'PIN';


--
-- Name: COLUMN hr_employee.private_car_plate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.private_car_plate IS 'Private Car Plate';


--
-- Name: COLUMN hr_employee.spouse_birthdate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.spouse_birthdate IS 'Spouse Birthdate';


--
-- Name: COLUMN hr_employee.birthday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.birthday IS 'Date of Birth';


--
-- Name: COLUMN hr_employee.visa_expire; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.visa_expire IS 'Visa Expiration Date';


--
-- Name: COLUMN hr_employee.work_permit_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_expiration_date IS 'Work Permit Expiration Date';


--
-- Name: COLUMN hr_employee.departure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.departure_date IS 'Departure Date';


--
-- Name: COLUMN hr_employee.employee_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.employee_properties IS 'Properties';


--
-- Name: COLUMN hr_employee.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.additional_note IS 'Additional Note';


--
-- Name: COLUMN hr_employee.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.notes IS 'Notes';


--
-- Name: COLUMN hr_employee.departure_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.departure_description IS 'Additional Information';


--
-- Name: COLUMN hr_employee.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.active IS 'Active';


--
-- Name: COLUMN hr_employee.is_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.is_flexible IS 'Is Flexible';


--
-- Name: COLUMN hr_employee.is_fully_flexible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.is_fully_flexible IS 'Is Fully Flexible';


--
-- Name: COLUMN hr_employee.work_permit_scheduled_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.work_permit_scheduled_activity IS 'Work Permit Scheduled Activity';


--
-- Name: COLUMN hr_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_employee.attendance_manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.attendance_manager_id IS 'Attendance Manager';


--
-- Name: COLUMN hr_employee.last_attendance_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.last_attendance_id IS 'Last Attendance';


--
-- Name: COLUMN hr_employee.last_check_in; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.last_check_in IS 'Check In';


--
-- Name: COLUMN hr_employee.last_check_out; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.last_check_out IS 'Check Out';


--
-- Name: COLUMN hr_employee.leave_manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee.leave_manager_id IS 'Time Off';


--
-- Name: hr_employee_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_category (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_category OWNER TO runbot;

--
-- Name: TABLE hr_employee_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_category IS 'Employee Category';


--
-- Name: COLUMN hr_employee_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.color IS 'Color Index';


--
-- Name: COLUMN hr_employee_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.name IS 'Tag Name';


--
-- Name: COLUMN hr_employee_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_category.write_date IS 'Last Updated on';


--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_category_id_seq OWNER TO runbot;

--
-- Name: hr_employee_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_category_id_seq OWNED BY public.hr_employee_category.id;


--
-- Name: hr_employee_cv_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_cv_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    color_primary character varying NOT NULL,
    color_secondary character varying NOT NULL,
    show_skills boolean,
    show_contact boolean,
    show_others boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_cv_wizard OWNER TO runbot;

--
-- Name: TABLE hr_employee_cv_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_cv_wizard IS 'Print Resume';


--
-- Name: COLUMN hr_employee_cv_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_cv_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_cv_wizard.color_primary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_primary IS 'Primary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.color_secondary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.color_secondary IS 'Secondary Color';


--
-- Name: COLUMN hr_employee_cv_wizard.show_skills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_skills IS 'Skills';


--
-- Name: COLUMN hr_employee_cv_wizard.show_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_contact IS 'Contact Information';


--
-- Name: COLUMN hr_employee_cv_wizard.show_others; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.show_others IS 'Others';


--
-- Name: COLUMN hr_employee_cv_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_cv_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_cv_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_cv_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_employee_cv_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_cv_wizard_id_seq OWNED BY public.hr_employee_cv_wizard.id;


--
-- Name: hr_employee_hr_employee_cv_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_employee_cv_wizard_rel (
    hr_employee_cv_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_employee_cv_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_employee_cv_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_employee_cv_wizard_rel IS 'RELATION BETWEEN hr_employee_cv_wizard AND hr_employee';


--
-- Name: hr_employee_hr_leave_allocation_generate_multi_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_leave_allocation_generate_multi_wizard_rel (
    hr_leave_allocation_generate_multi_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_leave_allocation_generate_multi_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_leave_allocation_generate_multi_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_leave_allocation_generate_multi_wizard_rel IS 'RELATION BETWEEN hr_leave_allocation_generate_multi_wizard AND hr_employee';


--
-- Name: hr_employee_hr_leave_generate_multi_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_leave_generate_multi_wizard_rel (
    hr_leave_generate_multi_wizard_id integer NOT NULL,
    hr_employee_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_leave_generate_multi_wizard_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_leave_generate_multi_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_leave_generate_multi_wizard_rel IS 'RELATION BETWEEN hr_leave_generate_multi_wizard AND hr_employee';


--
-- Name: hr_employee_hr_skill_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_hr_skill_rel (
    hr_employee_id integer NOT NULL,
    hr_skill_id integer NOT NULL
);


ALTER TABLE public.hr_employee_hr_skill_rel OWNER TO runbot;

--
-- Name: TABLE hr_employee_hr_skill_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_hr_skill_rel IS 'RELATION BETWEEN hr_employee AND hr_skill';


--
-- Name: hr_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_id_seq OWNER TO runbot;

--
-- Name: hr_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_id_seq OWNED BY public.hr_employee.id;


--
-- Name: hr_employee_public; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_public AS
 SELECT name,
    active,
    color,
    department_id,
    job_id,
    job_title,
    company_id,
    address_id,
    work_phone,
    mobile_phone,
    work_email,
    work_contact_id,
    work_location_id,
    user_id,
    resource_id,
    resource_calendar_id,
    is_flexible,
    is_fully_flexible,
    parent_id,
    coach_id,
    leave_manager_id,
    create_date,
    id,
    create_uid,
    write_uid,
    write_date
   FROM public.hr_employee emp;


ALTER VIEW public.hr_employee_public OWNER TO runbot;

--
-- Name: hr_employee_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_skill (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    skill_id integer NOT NULL,
    skill_level_id integer NOT NULL,
    skill_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_skill OWNER TO runbot;

--
-- Name: TABLE hr_employee_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_skill IS 'Skill level for an employee';


--
-- Name: COLUMN hr_employee_skill.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_skill.skill_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_id IS 'Skill';


--
-- Name: COLUMN hr_employee_skill.skill_level_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_level_id IS 'Skill Level';


--
-- Name: COLUMN hr_employee_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_employee_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill.write_date IS 'Last Updated on';


--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_skill_id_seq OWNER TO runbot;

--
-- Name: hr_employee_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_skill_id_seq OWNED BY public.hr_employee_skill.id;


--
-- Name: hr_employee_skill_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_employee_skill_log (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    department_id integer,
    skill_id integer NOT NULL,
    skill_level_id integer NOT NULL,
    skill_type_id integer NOT NULL,
    level_progress integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_employee_skill_log OWNER TO runbot;

--
-- Name: TABLE hr_employee_skill_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_employee_skill_log IS 'Skills History';


--
-- Name: COLUMN hr_employee_skill_log.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.employee_id IS 'Employee';


--
-- Name: COLUMN hr_employee_skill_log.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.department_id IS 'Department';


--
-- Name: COLUMN hr_employee_skill_log.skill_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.skill_id IS 'Skill';


--
-- Name: COLUMN hr_employee_skill_log.skill_level_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.skill_level_id IS 'Skill Level';


--
-- Name: COLUMN hr_employee_skill_log.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_employee_skill_log.level_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.level_progress IS 'Progress';


--
-- Name: COLUMN hr_employee_skill_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.create_uid IS 'Created by';


--
-- Name: COLUMN hr_employee_skill_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_employee_skill_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.date IS 'Date';


--
-- Name: COLUMN hr_employee_skill_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.create_date IS 'Created on';


--
-- Name: COLUMN hr_employee_skill_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_employee_skill_log.write_date IS 'Last Updated on';


--
-- Name: hr_employee_skill_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_employee_skill_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_employee_skill_log_id_seq OWNER TO runbot;

--
-- Name: hr_employee_skill_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_employee_skill_log_id_seq OWNED BY public.hr_employee_skill_log.id;


--
-- Name: hr_skill_level; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_level (
    id integer NOT NULL,
    skill_type_id integer,
    level_progress integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    default_level boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_skill_level_check_level_progress CHECK (((level_progress >= 0) AND (level_progress <= 100)))
);


ALTER TABLE public.hr_skill_level OWNER TO runbot;

--
-- Name: TABLE hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_level IS 'Skill Level';


--
-- Name: COLUMN hr_skill_level.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_skill_level.level_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.level_progress IS 'Progress';


--
-- Name: COLUMN hr_skill_level.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_level.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_level.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.name IS 'Name';


--
-- Name: COLUMN hr_skill_level.default_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.default_level IS 'Default Level';


--
-- Name: COLUMN hr_skill_level.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_level.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_level.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_skill_level_check_level_progress ON hr_skill_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_skill_level_check_level_progress ON public.hr_skill_level IS 'CHECK(level_progress BETWEEN 0 AND 100)';


--
-- Name: hr_skill_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_skill_type OWNER TO runbot;

--
-- Name: TABLE hr_skill_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill_type IS 'Skill Type';


--
-- Name: COLUMN hr_skill_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.color IS 'Color';


--
-- Name: COLUMN hr_skill_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.name IS 'Name';


--
-- Name: COLUMN hr_skill_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.active IS 'Active';


--
-- Name: COLUMN hr_skill_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill_type.write_date IS 'Last Updated on';


--
-- Name: hr_employee_skill_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_employee_skill_report AS
 SELECT row_number() OVER () AS id,
    e.id AS employee_id,
    e.company_id,
    e.department_id,
    s.skill_id,
    s.skill_type_id,
    ((sl.level_progress)::numeric / 100.0) AS level_progress,
    sl.name AS skill_level
   FROM (((public.hr_employee e
     LEFT JOIN public.hr_employee_skill s ON ((e.id = s.employee_id)))
     LEFT JOIN public.hr_skill_level sl ON ((sl.id = s.skill_level_id)))
     LEFT JOIN public.hr_skill_type st ON ((st.id = sl.skill_type_id)))
  WHERE (st.active IS TRUE);


ALTER VIEW public.hr_employee_skill_report OWNER TO runbot;

--
-- Name: hr_holidays_cancel_leave; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_holidays_cancel_leave (
    id integer NOT NULL,
    leave_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_holidays_cancel_leave OWNER TO runbot;

--
-- Name: TABLE hr_holidays_cancel_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_holidays_cancel_leave IS 'Cancel Time Off Wizard';


--
-- Name: COLUMN hr_holidays_cancel_leave.leave_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.leave_id IS 'Time Off Request';


--
-- Name: COLUMN hr_holidays_cancel_leave.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.create_uid IS 'Created by';


--
-- Name: COLUMN hr_holidays_cancel_leave.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_holidays_cancel_leave.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.reason IS 'Reason';


--
-- Name: COLUMN hr_holidays_cancel_leave.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.create_date IS 'Created on';


--
-- Name: COLUMN hr_holidays_cancel_leave.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_cancel_leave.write_date IS 'Last Updated on';


--
-- Name: hr_holidays_cancel_leave_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_holidays_cancel_leave_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_holidays_cancel_leave_id_seq OWNER TO runbot;

--
-- Name: hr_holidays_cancel_leave_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_holidays_cancel_leave_id_seq OWNED BY public.hr_holidays_cancel_leave.id;


--
-- Name: hr_holidays_summary_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_holidays_summary_employee (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    holiday_type character varying NOT NULL,
    date_from date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_holidays_summary_employee OWNER TO runbot;

--
-- Name: TABLE hr_holidays_summary_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_holidays_summary_employee IS 'HR Time Off Summary Report By Employee';


--
-- Name: COLUMN hr_holidays_summary_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.create_uid IS 'Created by';


--
-- Name: COLUMN hr_holidays_summary_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_holidays_summary_employee.holiday_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.holiday_type IS 'Select Time Off Type';


--
-- Name: COLUMN hr_holidays_summary_employee.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.date_from IS 'From';


--
-- Name: COLUMN hr_holidays_summary_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.create_date IS 'Created on';


--
-- Name: COLUMN hr_holidays_summary_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_holidays_summary_employee.write_date IS 'Last Updated on';


--
-- Name: hr_holidays_summary_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_holidays_summary_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_holidays_summary_employee_id_seq OWNER TO runbot;

--
-- Name: hr_holidays_summary_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_holidays_summary_employee_id_seq OWNED BY public.hr_holidays_summary_employee.id;


--
-- Name: hr_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_job (
    id integer NOT NULL,
    sequence integer,
    expected_employees integer,
    no_of_employee integer,
    no_of_recruitment integer,
    department_id integer,
    company_id integer,
    contract_type_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description text,
    requirements text,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_job_no_of_recruitment_positive CHECK ((no_of_recruitment >= 0))
);


ALTER TABLE public.hr_job OWNER TO runbot;

--
-- Name: TABLE hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_job IS 'Job Position';


--
-- Name: COLUMN hr_job.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.sequence IS 'Sequence';


--
-- Name: COLUMN hr_job.expected_employees; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.expected_employees IS 'Total Forecasted Employees';


--
-- Name: COLUMN hr_job.no_of_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.no_of_employee IS 'Current Number of Employees';


--
-- Name: COLUMN hr_job.no_of_recruitment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.no_of_recruitment IS 'Target';


--
-- Name: COLUMN hr_job.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.department_id IS 'Department';


--
-- Name: COLUMN hr_job.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.company_id IS 'Company';


--
-- Name: COLUMN hr_job.contract_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.contract_type_id IS 'Employment Type';


--
-- Name: COLUMN hr_job.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_uid IS 'Created by';


--
-- Name: COLUMN hr_job.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_job.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.name IS 'Job Position';


--
-- Name: COLUMN hr_job.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.description IS 'Job Description';


--
-- Name: COLUMN hr_job.requirements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.requirements IS 'Requirements';


--
-- Name: COLUMN hr_job.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.active IS 'Active';


--
-- Name: COLUMN hr_job.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.create_date IS 'Created on';


--
-- Name: COLUMN hr_job.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_job.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_job_no_of_recruitment_positive ON hr_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_job_no_of_recruitment_positive ON public.hr_job IS 'CHECK(no_of_recruitment >= 0)';


--
-- Name: hr_job_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_job_id_seq OWNER TO runbot;

--
-- Name: hr_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_job_id_seq OWNED BY public.hr_job.id;


--
-- Name: hr_leave; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave (
    id integer NOT NULL,
    message_main_attachment_id integer,
    user_id integer,
    manager_id integer,
    holiday_status_id integer NOT NULL,
    employee_id integer NOT NULL,
    employee_company_id integer,
    company_id integer,
    department_id integer,
    resource_calendar_id integer,
    meeting_id integer,
    first_approver_id integer,
    second_approver_id integer,
    create_uid integer,
    write_uid integer,
    private_name character varying,
    state character varying,
    duration_display character varying,
    request_date_from_period character varying,
    request_date_from date,
    request_date_to date,
    notes text,
    request_unit_half boolean,
    request_unit_hours boolean,
    date_from timestamp without time zone,
    date_to timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    number_of_days double precision,
    number_of_hours double precision,
    request_hour_from double precision,
    request_hour_to double precision,
    overtime_id integer,
    CONSTRAINT hr_leave_date_check2 CHECK ((date_from <= date_to)),
    CONSTRAINT hr_leave_date_check3 CHECK ((request_date_from <= request_date_to)),
    CONSTRAINT hr_leave_duration_check CHECK ((number_of_days >= (0)::double precision))
);


ALTER TABLE public.hr_leave OWNER TO runbot;

--
-- Name: TABLE hr_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave IS 'Time Off';


--
-- Name: COLUMN hr_leave.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN hr_leave.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.user_id IS 'User';


--
-- Name: COLUMN hr_leave.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.manager_id IS 'Manager';


--
-- Name: COLUMN hr_leave.holiday_status_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.holiday_status_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.employee_id IS 'Employee';


--
-- Name: COLUMN hr_leave.employee_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.employee_company_id IS 'Employee Company';


--
-- Name: COLUMN hr_leave.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.company_id IS 'Company';


--
-- Name: COLUMN hr_leave.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.department_id IS 'Department';


--
-- Name: COLUMN hr_leave.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.resource_calendar_id IS 'Resource Calendar';


--
-- Name: COLUMN hr_leave.meeting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.meeting_id IS 'Meeting';


--
-- Name: COLUMN hr_leave.first_approver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.first_approver_id IS 'First Approval';


--
-- Name: COLUMN hr_leave.second_approver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.second_approver_id IS 'Second Approval';


--
-- Name: COLUMN hr_leave.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave.private_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.private_name IS 'Time Off Description';


--
-- Name: COLUMN hr_leave.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.state IS 'Status';


--
-- Name: COLUMN hr_leave.duration_display; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.duration_display IS 'Requested (Days/Hours)';


--
-- Name: COLUMN hr_leave.request_date_from_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_date_from_period IS 'Date Period Start';


--
-- Name: COLUMN hr_leave.request_date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_date_from IS 'Request Start Date';


--
-- Name: COLUMN hr_leave.request_date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_date_to IS 'Request End Date';


--
-- Name: COLUMN hr_leave.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.notes IS 'Reasons';


--
-- Name: COLUMN hr_leave.request_unit_half; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_unit_half IS 'Half Day';


--
-- Name: COLUMN hr_leave.request_unit_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_unit_hours IS 'Custom Hours';


--
-- Name: COLUMN hr_leave.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.date_from IS 'Start Date';


--
-- Name: COLUMN hr_leave.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.date_to IS 'End Date';


--
-- Name: COLUMN hr_leave.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_leave.number_of_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.number_of_days IS 'Duration (Days)';


--
-- Name: COLUMN hr_leave.number_of_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.number_of_hours IS 'Duration (Hours)';


--
-- Name: COLUMN hr_leave.request_hour_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_hour_from IS 'Hour from';


--
-- Name: COLUMN hr_leave.request_hour_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.request_hour_to IS 'Hour to';


--
-- Name: COLUMN hr_leave.overtime_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave.overtime_id IS 'Extra Hours';


--
-- Name: CONSTRAINT hr_leave_date_check2 ON hr_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_date_check2 ON public.hr_leave IS 'CHECK ((date_from <= date_to))';


--
-- Name: CONSTRAINT hr_leave_date_check3 ON hr_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_date_check3 ON public.hr_leave IS 'CHECK ((request_date_from <= request_date_to))';


--
-- Name: CONSTRAINT hr_leave_duration_check ON hr_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_duration_check ON public.hr_leave IS 'CHECK ( number_of_days >= 0 )';


--
-- Name: hr_leave_accrual_level; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_accrual_level (
    id integer NOT NULL,
    sequence integer,
    accrual_plan_id integer NOT NULL,
    start_count integer,
    first_day integer,
    second_day integer,
    first_month_day integer,
    second_month_day integer,
    yearly_day integer,
    postpone_max_days integer,
    accrual_validity_count integer,
    create_uid integer,
    write_uid integer,
    start_type character varying NOT NULL,
    added_value_type character varying NOT NULL,
    frequency character varying NOT NULL,
    week_day character varying NOT NULL,
    first_month character varying,
    second_month character varying,
    yearly_month character varying,
    action_with_unused_accruals character varying NOT NULL,
    accrual_validity_type character varying NOT NULL,
    added_value numeric NOT NULL,
    maximum_leave numeric,
    maximum_leave_yearly numeric,
    cap_accrued_time boolean,
    cap_accrued_time_yearly boolean,
    accrual_validity boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    frequency_hourly_source character varying,
    CONSTRAINT hr_leave_accrual_level_added_value_greater_than_zero CHECK ((added_value > (0)::numeric)),
    CONSTRAINT hr_leave_accrual_level_check_dates CHECK ((((frequency)::text = ANY ((ARRAY['daily'::character varying, 'hourly'::character varying])::text[])) OR ((week_day IS NOT NULL) AND ((frequency)::text = 'weekly'::text)) OR ((first_day > 0) AND (second_day > first_day) AND (first_day <= 31) AND (second_day <= 31) AND ((frequency)::text = 'bimonthly'::text)) OR ((first_day > 0) AND (first_day <= 31) AND ((frequency)::text = 'monthly'::text)) OR ((first_month_day > 0) AND (first_month_day <= 31) AND (second_month_day > 0) AND (second_month_day <= 31) AND ((frequency)::text = 'biyearly'::text)) OR ((yearly_day > 0) AND (yearly_day <= 31) AND ((frequency)::text = 'yearly'::text)))),
    CONSTRAINT hr_leave_accrual_level_start_count_check CHECK ((start_count >= 0)),
    CONSTRAINT hr_leave_accrual_level_valid_yearly_cap_value CHECK (((cap_accrued_time_yearly IS NOT TRUE) OR (COALESCE(maximum_leave_yearly, (0)::numeric) > (0)::numeric)))
);


ALTER TABLE public.hr_leave_accrual_level OWNER TO runbot;

--
-- Name: TABLE hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_accrual_level IS 'Accrual Plan Level';


--
-- Name: COLUMN hr_leave_accrual_level.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.sequence IS 'sequence';


--
-- Name: COLUMN hr_leave_accrual_level.accrual_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.accrual_plan_id IS 'Accrual Plan';


--
-- Name: COLUMN hr_leave_accrual_level.start_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.start_count IS 'Start after';


--
-- Name: COLUMN hr_leave_accrual_level.first_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.first_day IS 'First Day';


--
-- Name: COLUMN hr_leave_accrual_level.second_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.second_day IS 'Second Day';


--
-- Name: COLUMN hr_leave_accrual_level.first_month_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.first_month_day IS 'First Month Day';


--
-- Name: COLUMN hr_leave_accrual_level.second_month_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.second_month_day IS 'Second Month Day';


--
-- Name: COLUMN hr_leave_accrual_level.yearly_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.yearly_day IS 'Yearly Day';


--
-- Name: COLUMN hr_leave_accrual_level.postpone_max_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.postpone_max_days IS 'Maximum amount of accruals to transfer';


--
-- Name: COLUMN hr_leave_accrual_level.accrual_validity_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.accrual_validity_count IS 'Accrual Validity Count';


--
-- Name: COLUMN hr_leave_accrual_level.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_accrual_level.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_accrual_level.start_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.start_type IS ' ';


--
-- Name: COLUMN hr_leave_accrual_level.added_value_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.added_value_type IS 'Added Value Type';


--
-- Name: COLUMN hr_leave_accrual_level.frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.frequency IS 'Frequency';


--
-- Name: COLUMN hr_leave_accrual_level.week_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.week_day IS 'Allocation on';


--
-- Name: COLUMN hr_leave_accrual_level.first_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.first_month IS 'First Month';


--
-- Name: COLUMN hr_leave_accrual_level.second_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.second_month IS 'Second Month';


--
-- Name: COLUMN hr_leave_accrual_level.yearly_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.yearly_month IS 'Yearly Month';


--
-- Name: COLUMN hr_leave_accrual_level.action_with_unused_accruals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.action_with_unused_accruals IS 'Carry over';


--
-- Name: COLUMN hr_leave_accrual_level.accrual_validity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.accrual_validity_type IS 'Accrual Validity Type';


--
-- Name: COLUMN hr_leave_accrual_level.added_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.added_value IS 'Rate';


--
-- Name: COLUMN hr_leave_accrual_level.maximum_leave; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.maximum_leave IS 'Limit to';


--
-- Name: COLUMN hr_leave_accrual_level.maximum_leave_yearly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.maximum_leave_yearly IS 'Yearly limit to';


--
-- Name: COLUMN hr_leave_accrual_level.cap_accrued_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.cap_accrued_time IS 'Cap accrued time';


--
-- Name: COLUMN hr_leave_accrual_level.cap_accrued_time_yearly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.cap_accrued_time_yearly IS 'Milestone cap';


--
-- Name: COLUMN hr_leave_accrual_level.accrual_validity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.accrual_validity IS 'Accrual Validity';


--
-- Name: COLUMN hr_leave_accrual_level.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_accrual_level.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_leave_accrual_level.frequency_hourly_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_level.frequency_hourly_source IS 'Frequency Hourly Source';


--
-- Name: CONSTRAINT hr_leave_accrual_level_added_value_greater_than_zero ON hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_accrual_level_added_value_greater_than_zero ON public.hr_leave_accrual_level IS 'CHECK(added_value > 0)';


--
-- Name: CONSTRAINT hr_leave_accrual_level_check_dates ON hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_accrual_level_check_dates ON public.hr_leave_accrual_level IS 'CHECK( (frequency IN (''daily'', ''hourly'')) or(week_day IS NOT NULL AND frequency = ''weekly'') or (first_day > 0 AND second_day > first_day AND first_day <= 31 AND second_day <= 31 AND frequency = ''bimonthly'') or (first_day > 0 AND first_day <= 31 AND frequency = ''monthly'')or (first_month_day > 0 AND first_month_day <= 31 AND second_month_day > 0 AND second_month_day <= 31 AND frequency = ''biyearly'') or (yearly_day > 0 AND yearly_day <= 31 AND frequency = ''yearly''))';


--
-- Name: CONSTRAINT hr_leave_accrual_level_start_count_check ON hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_accrual_level_start_count_check ON public.hr_leave_accrual_level IS 'CHECK( start_count >= 0 )';


--
-- Name: CONSTRAINT hr_leave_accrual_level_valid_yearly_cap_value ON hr_leave_accrual_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_accrual_level_valid_yearly_cap_value ON public.hr_leave_accrual_level IS 'CHECK(cap_accrued_time_yearly IS NOT TRUE OR COALESCE(maximum_leave_yearly, 0) > 0)';


--
-- Name: hr_leave_accrual_level_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_accrual_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_accrual_level_id_seq OWNER TO runbot;

--
-- Name: hr_leave_accrual_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_accrual_level_id_seq OWNED BY public.hr_leave_accrual_level.id;


--
-- Name: hr_leave_accrual_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_accrual_plan (
    id integer NOT NULL,
    time_off_type_id integer,
    company_id integer,
    carryover_day integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    transition_mode character varying NOT NULL,
    accrued_gain_time character varying NOT NULL,
    carryover_date character varying NOT NULL,
    carryover_month character varying,
    added_value_type character varying,
    active boolean,
    is_based_on_worked_time boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_leave_accrual_plan OWNER TO runbot;

--
-- Name: TABLE hr_leave_accrual_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_accrual_plan IS 'Accrual Plan';


--
-- Name: COLUMN hr_leave_accrual_plan.time_off_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.time_off_type_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_accrual_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_accrual_plan.carryover_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.carryover_day IS 'Carryover Day';


--
-- Name: COLUMN hr_leave_accrual_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_accrual_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_accrual_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.name IS 'Name';


--
-- Name: COLUMN hr_leave_accrual_plan.transition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.transition_mode IS 'Milestone Transition';


--
-- Name: COLUMN hr_leave_accrual_plan.accrued_gain_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.accrued_gain_time IS 'Accrued Gain Time';


--
-- Name: COLUMN hr_leave_accrual_plan.carryover_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.carryover_date IS 'Carry-Over Time';


--
-- Name: COLUMN hr_leave_accrual_plan.carryover_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.carryover_month IS 'Carryover Month';


--
-- Name: COLUMN hr_leave_accrual_plan.added_value_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.added_value_type IS 'Added Value Type';


--
-- Name: COLUMN hr_leave_accrual_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.active IS 'Active';


--
-- Name: COLUMN hr_leave_accrual_plan.is_based_on_worked_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.is_based_on_worked_time IS 'Based on worked time';


--
-- Name: COLUMN hr_leave_accrual_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_accrual_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_accrual_plan.write_date IS 'Last Updated on';


--
-- Name: hr_leave_accrual_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_accrual_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_accrual_plan_id_seq OWNER TO runbot;

--
-- Name: hr_leave_accrual_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_accrual_plan_id_seq OWNED BY public.hr_leave_accrual_plan.id;


--
-- Name: hr_leave_allocation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_allocation (
    id integer NOT NULL,
    holiday_status_id integer NOT NULL,
    employee_id integer NOT NULL,
    employee_company_id integer,
    manager_id integer,
    approver_id integer,
    second_approver_id integer,
    department_id integer,
    accrual_plan_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    state character varying,
    allocation_type character varying NOT NULL,
    date_from date NOT NULL,
    date_to date,
    last_executed_carryover_date date,
    lastcall date,
    actual_lastcall date,
    nextcall date,
    carried_over_days_expiration_date date,
    notes text,
    already_accrued boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    number_of_days double precision,
    number_of_hours_display double precision,
    yearly_accrued_amount double precision,
    expiring_carryover_days double precision,
    overtime_id integer,
    CONSTRAINT hr_leave_allocation_duration_check CHECK ((((number_of_days > (0)::double precision) AND ((allocation_type)::text = 'regular'::text)) OR ((allocation_type)::text <> 'regular'::text)))
);


ALTER TABLE public.hr_leave_allocation OWNER TO runbot;

--
-- Name: TABLE hr_leave_allocation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_allocation IS 'Time Off Allocation';


--
-- Name: COLUMN hr_leave_allocation.holiday_status_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.holiday_status_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_allocation.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.employee_id IS 'Employee';


--
-- Name: COLUMN hr_leave_allocation.employee_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.employee_company_id IS 'Company';


--
-- Name: COLUMN hr_leave_allocation.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.manager_id IS 'Manager';


--
-- Name: COLUMN hr_leave_allocation.approver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.approver_id IS 'First Approval';


--
-- Name: COLUMN hr_leave_allocation.second_approver_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.second_approver_id IS 'Second Approval';


--
-- Name: COLUMN hr_leave_allocation.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.department_id IS 'Department';


--
-- Name: COLUMN hr_leave_allocation.accrual_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.accrual_plan_id IS 'Accrual Plan';


--
-- Name: COLUMN hr_leave_allocation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_allocation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_allocation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.name IS 'Description';


--
-- Name: COLUMN hr_leave_allocation.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.state IS 'Status';


--
-- Name: COLUMN hr_leave_allocation.allocation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.allocation_type IS 'Allocation Type';


--
-- Name: COLUMN hr_leave_allocation.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.date_from IS 'Start Date';


--
-- Name: COLUMN hr_leave_allocation.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.date_to IS 'End Date';


--
-- Name: COLUMN hr_leave_allocation.last_executed_carryover_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.last_executed_carryover_date IS 'Last Executed Carryover Date';


--
-- Name: COLUMN hr_leave_allocation.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.lastcall IS 'Date of the last accrual allocation';


--
-- Name: COLUMN hr_leave_allocation.actual_lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.actual_lastcall IS 'Actual Lastcall';


--
-- Name: COLUMN hr_leave_allocation.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.nextcall IS 'Date of the next accrual allocation';


--
-- Name: COLUMN hr_leave_allocation.carried_over_days_expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.carried_over_days_expiration_date IS 'Carried over days expiration date';


--
-- Name: COLUMN hr_leave_allocation.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.notes IS 'Reasons';


--
-- Name: COLUMN hr_leave_allocation.already_accrued; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.already_accrued IS 'Already Accrued';


--
-- Name: COLUMN hr_leave_allocation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_allocation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_leave_allocation.number_of_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.number_of_days IS 'Number of Days';


--
-- Name: COLUMN hr_leave_allocation.number_of_hours_display; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.number_of_hours_display IS 'Duration (hours)';


--
-- Name: COLUMN hr_leave_allocation.yearly_accrued_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.yearly_accrued_amount IS 'Yearly Accrued Amount';


--
-- Name: COLUMN hr_leave_allocation.expiring_carryover_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.expiring_carryover_days IS 'The number of carried over days that will expire on carried_over_days_expiration_date';


--
-- Name: COLUMN hr_leave_allocation.overtime_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation.overtime_id IS 'Extra Hours';


--
-- Name: CONSTRAINT hr_leave_allocation_duration_check ON hr_leave_allocation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_allocation_duration_check ON public.hr_leave_allocation IS 'CHECK( ( number_of_days > 0 AND allocation_type=''regular'') or (allocation_type != ''regular''))';


--
-- Name: hr_leave_allocation_generate_multi_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_allocation_generate_multi_wizard (
    id integer NOT NULL,
    holiday_status_id integer NOT NULL,
    company_id integer NOT NULL,
    department_id integer,
    category_id integer,
    accrual_plan_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    allocation_mode character varying NOT NULL,
    allocation_type character varying NOT NULL,
    date_from date NOT NULL,
    date_to date,
    notes text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.hr_leave_allocation_generate_multi_wizard OWNER TO runbot;

--
-- Name: TABLE hr_leave_allocation_generate_multi_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_allocation_generate_multi_wizard IS 'Generate time off allocations for multiple employees';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.holiday_status_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.holiday_status_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.department_id IS 'Department';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.category_id IS 'Employee Tag';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.accrual_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.accrual_plan_id IS 'Accrual Plan';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.name IS 'Description';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.allocation_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.allocation_mode IS 'Allocation Mode';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.allocation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.allocation_type IS 'Allocation Type';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.date_from IS 'Start Date';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.date_to IS 'End Date';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.notes IS 'Reasons';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_leave_allocation_generate_multi_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_allocation_generate_multi_wizard.duration IS 'Allocation';


--
-- Name: hr_leave_allocation_generate_multi_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_allocation_generate_multi_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_allocation_generate_multi_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_leave_allocation_generate_multi_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_allocation_generate_multi_wizard_id_seq OWNED BY public.hr_leave_allocation_generate_multi_wizard.id;


--
-- Name: hr_leave_allocation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_allocation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_allocation_id_seq OWNER TO runbot;

--
-- Name: hr_leave_allocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_allocation_id_seq OWNED BY public.hr_leave_allocation.id;


--
-- Name: hr_leave_employee_type_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_leave_employee_type_report AS
 SELECT row_number() OVER (ORDER BY employee_id) AS id,
    employee_id,
    active_employee,
    number_of_days,
    number_of_hours,
    department_id,
    leave_type,
    holiday_status,
    state,
    date_from,
    date_to,
    company_id
   FROM ( SELECT allocation.employee_id,
            employee.active AS active_employee,
                CASE
                    WHEN (allocation.id = min_allocation_id.min_id) THEN (aggregate_allocation.number_of_days - COALESCE(aggregate_leave.number_of_days, (0)::double precision))
                    ELSE (0)::double precision
                END AS number_of_days,
                CASE
                    WHEN (allocation.id = min_allocation_id.min_id) THEN (aggregate_allocation.number_of_hours - COALESCE(aggregate_leave.number_of_hours, (0)::double precision))
                    ELSE (0)::double precision
                END AS number_of_hours,
            allocation.department_id,
            allocation.holiday_status_id AS leave_type,
            allocation.state,
            allocation.date_from,
            allocation.date_to,
            'left'::text AS holiday_status,
            allocation.employee_company_id AS company_id
           FROM ((((public.hr_leave_allocation allocation
             JOIN public.hr_employee employee ON ((allocation.employee_id = employee.id)))
             LEFT JOIN ( SELECT hr_leave_allocation.employee_id,
                    hr_leave_allocation.holiday_status_id,
                    min(hr_leave_allocation.id) AS min_id
                   FROM public.hr_leave_allocation
                  GROUP BY hr_leave_allocation.employee_id, hr_leave_allocation.holiday_status_id) min_allocation_id ON (((allocation.employee_id = min_allocation_id.employee_id) AND (allocation.holiday_status_id = min_allocation_id.holiday_status_id))))
             LEFT JOIN ( SELECT hr_leave_allocation.employee_id,
                    hr_leave_allocation.holiday_status_id,
                    sum(
                        CASE
                            WHEN ((hr_leave_allocation.state)::text = 'validate'::text) THEN hr_leave_allocation.number_of_days
                            ELSE (0)::double precision
                        END) AS number_of_days,
                    sum(
                        CASE
                            WHEN ((hr_leave_allocation.state)::text = 'validate'::text) THEN hr_leave_allocation.number_of_hours_display
                            ELSE (0)::double precision
                        END) AS number_of_hours
                   FROM public.hr_leave_allocation
                  GROUP BY hr_leave_allocation.employee_id, hr_leave_allocation.holiday_status_id) aggregate_allocation ON (((allocation.employee_id = aggregate_allocation.employee_id) AND (allocation.holiday_status_id = aggregate_allocation.holiday_status_id))))
             LEFT JOIN ( SELECT hr_leave.employee_id,
                    hr_leave.holiday_status_id,
                    sum(
                        CASE
                            WHEN ((hr_leave.state)::text = ANY ((ARRAY['validate'::character varying, 'validate1'::character varying])::text[])) THEN hr_leave.number_of_days
                            ELSE (0)::double precision
                        END) AS number_of_days,
                    sum(
                        CASE
                            WHEN ((hr_leave.state)::text = ANY ((ARRAY['validate'::character varying, 'validate1'::character varying])::text[])) THEN hr_leave.number_of_hours
                            ELSE (0)::double precision
                        END) AS number_of_hours
                   FROM public.hr_leave
                  GROUP BY hr_leave.employee_id, hr_leave.holiday_status_id) aggregate_leave ON (((allocation.employee_id = aggregate_leave.employee_id) AND (allocation.holiday_status_id = aggregate_leave.holiday_status_id))))
        UNION ALL
         SELECT request.employee_id,
            employee.active AS active_employee,
            request.number_of_days,
            request.number_of_hours,
            request.department_id,
            request.holiday_status_id AS leave_type,
            request.state,
            request.date_from,
            request.date_to,
                CASE
                    WHEN ((request.state)::text = ANY ((ARRAY['validate1'::character varying, 'validate'::character varying])::text[])) THEN 'taken'::text
                    WHEN ((request.state)::text = 'confirm'::text) THEN 'planned'::text
                    ELSE NULL::text
                END AS holiday_status,
            request.employee_company_id AS company_id
           FROM (public.hr_leave request
             JOIN public.hr_employee employee ON ((request.employee_id = employee.id)))
          WHERE ((request.state)::text = ANY ((ARRAY['confirm'::character varying, 'validate'::character varying, 'validate1'::character varying])::text[]))) leaves;


ALTER VIEW public.hr_leave_employee_type_report OWNER TO runbot;

--
-- Name: hr_leave_generate_multi_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_generate_multi_wizard (
    id integer NOT NULL,
    holiday_status_id integer NOT NULL,
    company_id integer NOT NULL,
    department_id integer,
    category_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    allocation_mode character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_leave_generate_multi_wizard OWNER TO runbot;

--
-- Name: TABLE hr_leave_generate_multi_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_generate_multi_wizard IS 'Generate time off for multiple employees';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.holiday_status_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.holiday_status_id IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.department_id IS 'Department';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.category_id IS 'Employee Tag';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.name IS 'Description';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.allocation_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.allocation_mode IS 'Allocation Mode';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.date_from IS 'Start Date';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.date_to IS 'End Date';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_generate_multi_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_generate_multi_wizard.write_date IS 'Last Updated on';


--
-- Name: hr_leave_generate_multi_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_generate_multi_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_generate_multi_wizard_id_seq OWNER TO runbot;

--
-- Name: hr_leave_generate_multi_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_generate_multi_wizard_id_seq OWNED BY public.hr_leave_generate_multi_wizard.id;


--
-- Name: hr_leave_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_id_seq OWNER TO runbot;

--
-- Name: hr_leave_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_id_seq OWNED BY public.hr_leave.id;


--
-- Name: hr_leave_mandatory_day; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_mandatory_day (
    id integer NOT NULL,
    company_id integer NOT NULL,
    color integer,
    resource_calendar_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    start_date date NOT NULL,
    end_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_leave_mandatory_day_date_from_after_day_to CHECK ((start_date <= end_date))
);


ALTER TABLE public.hr_leave_mandatory_day OWNER TO runbot;

--
-- Name: TABLE hr_leave_mandatory_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_mandatory_day IS 'Mandatory Day';


--
-- Name: COLUMN hr_leave_mandatory_day.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_mandatory_day.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.color IS 'Color';


--
-- Name: COLUMN hr_leave_mandatory_day.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.resource_calendar_id IS 'Working Hours';


--
-- Name: COLUMN hr_leave_mandatory_day.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_mandatory_day.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_mandatory_day.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.name IS 'Name';


--
-- Name: COLUMN hr_leave_mandatory_day.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.start_date IS 'Start Date';


--
-- Name: COLUMN hr_leave_mandatory_day.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.end_date IS 'End Date';


--
-- Name: COLUMN hr_leave_mandatory_day.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_mandatory_day.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_mandatory_day.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_leave_mandatory_day_date_from_after_day_to ON hr_leave_mandatory_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_mandatory_day_date_from_after_day_to ON public.hr_leave_mandatory_day IS 'CHECK(start_date <= end_date)';


--
-- Name: hr_leave_mandatory_day_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_mandatory_day_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_mandatory_day_id_seq OWNER TO runbot;

--
-- Name: hr_leave_mandatory_day_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_mandatory_day_id_seq OWNED BY public.hr_leave_mandatory_day.id;


--
-- Name: hr_leave_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_leave_report AS
 SELECT row_number() OVER (ORDER BY employee_id) AS id,
    leave_id,
    allocation_id,
    employee_id,
    name,
    number_of_days,
    leave_type,
    number_of_hours,
    department_id,
    holiday_status_id,
    state,
    date_from,
    date_to,
    company_id
   FROM ( SELECT NULL::integer AS leave_id,
            allocation.id AS allocation_id,
            allocation.employee_id,
            allocation.name,
            allocation.number_of_days,
            allocation.number_of_hours_display AS number_of_hours,
            allocation.department_id,
            allocation.holiday_status_id,
            allocation.state,
            allocation.date_from,
            allocation.date_to,
            'allocation'::text AS leave_type,
            allocation.employee_company_id AS company_id
           FROM (public.hr_leave_allocation allocation
             JOIN public.hr_employee employee ON ((allocation.employee_id = employee.id)))
          WHERE (employee.active IS TRUE)
        UNION ALL
         SELECT request.id AS leave_id,
            NULL::integer AS allocation_id,
            request.employee_id,
            request.private_name AS name,
            (request.number_of_days * ('-1'::integer)::double precision) AS number_of_days,
            (request.number_of_hours * ('-1'::integer)::double precision) AS number_of_hours,
            request.department_id,
            request.holiday_status_id,
            request.state,
            request.date_from,
            request.date_to,
            'request'::text AS leave_type,
            request.employee_company_id AS company_id
           FROM (public.hr_leave request
             JOIN public.hr_employee employee ON ((request.employee_id = employee.id)))
          WHERE (employee.active IS TRUE)) leaves;


ALTER VIEW public.hr_leave_report OWNER TO runbot;

--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    mobile character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea,
    nomenclature_id integer,
    resource_calendar_id integer,
    alias_domain_id integer,
    alias_domain_name character varying,
    email_primary_color character varying,
    email_secondary_color character varying,
    stylesheet_id integer,
    snailmail_color boolean,
    snailmail_cover boolean,
    snailmail_duplex boolean,
    payment_onboarding_payment_method character varying,
    fiscalyear_last_day integer NOT NULL,
    transfer_account_id integer,
    default_cash_difference_income_account_id integer,
    default_cash_difference_expense_account_id integer,
    account_journal_suspense_account_id integer,
    account_journal_early_pay_discount_gain_account_id integer,
    account_journal_early_pay_discount_loss_account_id integer,
    account_sale_tax_id integer,
    account_purchase_tax_id integer,
    currency_exchange_journal_id integer,
    income_currency_exchange_account_id integer,
    expense_currency_exchange_account_id integer,
    incoterm_id integer,
    batch_payment_sequence_id integer,
    account_opening_move_id integer,
    account_default_pos_receivable_account_id integer,
    expense_accrual_account_id integer,
    revenue_accrual_account_id integer,
    automatic_entry_default_journal_id integer,
    account_fiscal_country_id integer,
    tax_cash_basis_journal_id integer,
    account_cash_basis_base_account_id integer,
    account_discount_income_allocation_id integer,
    account_discount_expense_allocation_id integer,
    fiscalyear_last_month character varying NOT NULL,
    chart_template character varying,
    bank_account_code_prefix character varying,
    cash_account_code_prefix character varying,
    transfer_account_code_prefix character varying,
    tax_calculation_rounding_method character varying,
    terms_type character varying,
    quick_edit_mode character varying,
    account_price_include character varying NOT NULL,
    fiscalyear_lock_date date,
    tax_lock_date date,
    sale_lock_date date,
    purchase_lock_date date,
    hard_lock_date date,
    account_opening_date date NOT NULL,
    invoice_terms jsonb,
    invoice_terms_html jsonb,
    expects_chart_of_accounts boolean,
    anglo_saxon_accounting boolean,
    qr_code boolean,
    display_invoice_amount_total_words boolean,
    display_invoice_tax_company_currency boolean,
    account_use_credit_limit boolean,
    tax_exigibility boolean,
    account_storno boolean,
    check_account_audit_trail boolean,
    autopost_bills boolean,
    hr_presence_control_email_amount integer,
    hr_presence_control_ip_list character varying,
    employee_properties_definition jsonb,
    hr_presence_control_login boolean,
    hr_presence_control_email boolean,
    hr_presence_control_ip boolean,
    hr_presence_control_attendance boolean,
    internal_transit_location_id integer,
    stock_mail_confirmation_template_id integer,
    annual_inventory_day integer,
    annual_inventory_month character varying,
    stock_move_email_validation boolean,
    signing_user integer,
    deferred_expense_journal_id integer,
    deferred_expense_account_id integer,
    deferred_revenue_journal_id integer,
    deferred_revenue_account_id integer,
    generate_deferred_expense_entries_method character varying NOT NULL,
    deferred_expense_amount_computation_method character varying NOT NULL,
    generate_deferred_revenue_entries_method character varying NOT NULL,
    deferred_revenue_amount_computation_method character varying NOT NULL,
    invoicing_switch_threshold date,
    predict_bill_product boolean,
    sign_invoice boolean,
    vat_check_vies boolean,
    currency_interval_unit character varying NOT NULL,
    currency_provider character varying,
    currency_next_execution_date date,
    overtime_company_threshold integer,
    overtime_employee_threshold integer,
    attendance_kiosk_delay integer,
    attendance_kiosk_mode character varying,
    attendance_barcode_source character varying,
    attendance_kiosk_key character varying,
    attendance_overtime_validation character varying,
    hr_attendance_display_overtime boolean,
    attendance_kiosk_use_pin boolean,
    attendance_from_systray boolean,
    auto_check_out boolean,
    absence_management boolean,
    auto_check_out_tolerance double precision,
    po_lock character varying,
    po_double_validation character varying,
    po_double_validation_amount numeric,
    po_lead double precision NOT NULL,
    account_production_wip_account_id integer,
    account_production_wip_overhead_account_id integer,
    stock_request_allow_virtual_loc boolean,
    stock_request_check_available_first boolean,
    stock_sms_confirmation_template_id integer,
    stock_move_sms_validation boolean,
    has_received_warning_stock_sms boolean,
    avalara_api_id character varying,
    avalara_api_key character varying,
    avalara_environment character varying NOT NULL,
    avalara_commit boolean,
    avalara_address_validation boolean,
    avalara_use_upc boolean,
    setting_account_avatax boolean,
    days_to_purchase double precision,
    quotation_validity_days integer,
    sale_discount_product_id integer,
    sale_onboarding_payment_method character varying,
    portal_confirmation_sign boolean,
    portal_confirmation_pay boolean,
    prepayment_percent double precision,
    use_payment_pro boolean,
    account_tax_periodicity_reminder_day integer NOT NULL,
    account_tax_periodicity_journal_id integer,
    account_revaluation_journal_id integer,
    account_revaluation_expense_provision_account_id integer,
    account_revaluation_income_provision_account_id integer,
    account_representative_id integer,
    account_tax_periodicity character varying NOT NULL,
    totals_below_sections boolean,
    reconcile_on_company_currency boolean,
    l10n_ar_afip_start_date date,
    sale_order_template_id integer,
    security_lead double precision NOT NULL,
    gain_account_id integer,
    loss_account_id integer,
    extract_bank_statement_digitalization_mode character varying,
    extract_in_invoice_digitalization_mode character varying,
    extract_out_invoice_digitalization_mode character varying,
    extract_single_line_per_tax boolean,
    use_receiptbook boolean,
    l10n_ar_afip_ws_key_id integer,
    l10n_ar_afip_ws_crt_id integer,
    l10n_ar_afip_verification_type character varying NOT NULL,
    l10n_ar_afip_ws_environment character varying,
    l10n_ar_fce_transmission_type character varying,
    l10n_ar_computable_tax_credit character varying,
    l10n_ar_afip_activity_id integer,
    arba_cit character varying,
    l10n_ar_report_signed_by text,
    l10n_ar_invoice_report_ars_amount boolean,
    l10n_ar_tax_base_account_id integer,
    l10n_ar_last_currency_sync_date date,
    rate_perc numeric,
    rate_surcharge numeric,
    arba_cot character varying,
    CONSTRAINT res_company_check_quotation_validity_days CHECK ((quotation_validity_days >= 0))
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.mobile IS 'Mobile';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.nomenclature_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.nomenclature_id IS 'Nomenclature';


--
-- Name: COLUMN res_company.resource_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.resource_calendar_id IS 'Default Working Hours';


--
-- Name: COLUMN res_company.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.alias_domain_id IS 'Email Domain';


--
-- Name: COLUMN res_company.alias_domain_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.alias_domain_name IS 'Alias Domain Name';


--
-- Name: COLUMN res_company.email_primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_primary_color IS 'Email Header Color';


--
-- Name: COLUMN res_company.email_secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_secondary_color IS 'Email Button Color';


--
-- Name: COLUMN res_company.stylesheet_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stylesheet_id IS 'Aeroo Reports Global Stylesheet';


--
-- Name: COLUMN res_company.snailmail_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_color IS 'Snailmail Color';


--
-- Name: COLUMN res_company.snailmail_cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN res_company.snailmail_duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_duplex IS 'Both sides';


--
-- Name: COLUMN res_company.payment_onboarding_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.payment_onboarding_payment_method IS 'Selected onboarding payment method';


--
-- Name: COLUMN res_company.fiscalyear_last_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.fiscalyear_last_day IS 'Fiscalyear Last Day';


--
-- Name: COLUMN res_company.transfer_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.transfer_account_id IS 'Inter-Banks Transfer Account';


--
-- Name: COLUMN res_company.default_cash_difference_income_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.default_cash_difference_income_account_id IS 'Cash Difference Income';


--
-- Name: COLUMN res_company.default_cash_difference_expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.default_cash_difference_expense_account_id IS 'Cash Difference Expense';


--
-- Name: COLUMN res_company.account_journal_suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_journal_suspense_account_id IS 'Journal Suspense Account';


--
-- Name: COLUMN res_company.account_journal_early_pay_discount_gain_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_journal_early_pay_discount_gain_account_id IS 'Cash Discount Write-Off Gain Account';


--
-- Name: COLUMN res_company.account_journal_early_pay_discount_loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_journal_early_pay_discount_loss_account_id IS 'Cash Discount Write-Off Loss Account';


--
-- Name: COLUMN res_company.account_sale_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_sale_tax_id IS 'Default Sale Tax';


--
-- Name: COLUMN res_company.account_purchase_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_purchase_tax_id IS 'Default Purchase Tax';


--
-- Name: COLUMN res_company.currency_exchange_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.currency_exchange_journal_id IS 'Exchange Gain or Loss Journal';


--
-- Name: COLUMN res_company.income_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.income_currency_exchange_account_id IS 'Gain Exchange Rate Account';


--
-- Name: COLUMN res_company.expense_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.expense_currency_exchange_account_id IS 'Loss Exchange Rate Account';


--
-- Name: COLUMN res_company.incoterm_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.incoterm_id IS 'Default incoterm';


--
-- Name: COLUMN res_company.batch_payment_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.batch_payment_sequence_id IS 'Batch Payment Sequence';


--
-- Name: COLUMN res_company.account_opening_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_opening_move_id IS 'Opening Journal Entry';


--
-- Name: COLUMN res_company.account_default_pos_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_default_pos_receivable_account_id IS 'Default PoS Receivable Account';


--
-- Name: COLUMN res_company.expense_accrual_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.expense_accrual_account_id IS 'Expense Accrual Account';


--
-- Name: COLUMN res_company.revenue_accrual_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.revenue_accrual_account_id IS 'Revenue Accrual Account';


--
-- Name: COLUMN res_company.automatic_entry_default_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.automatic_entry_default_journal_id IS 'Automatic Entry Default Journal';


--
-- Name: COLUMN res_company.account_fiscal_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_fiscal_country_id IS 'Fiscal Country';


--
-- Name: COLUMN res_company.tax_cash_basis_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.tax_cash_basis_journal_id IS 'Cash Basis Journal';


--
-- Name: COLUMN res_company.account_cash_basis_base_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_cash_basis_base_account_id IS 'Base Tax Received Account';


--
-- Name: COLUMN res_company.account_discount_income_allocation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_discount_income_allocation_id IS 'Separate account for income discount';


--
-- Name: COLUMN res_company.account_discount_expense_allocation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_discount_expense_allocation_id IS 'Separate account for expense discount';


--
-- Name: COLUMN res_company.fiscalyear_last_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.fiscalyear_last_month IS 'Fiscalyear Last Month';


--
-- Name: COLUMN res_company.chart_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.chart_template IS 'Chart Template';


--
-- Name: COLUMN res_company.bank_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.bank_account_code_prefix IS 'Prefix of the bank accounts';


--
-- Name: COLUMN res_company.cash_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.cash_account_code_prefix IS 'Prefix of the cash accounts';


--
-- Name: COLUMN res_company.transfer_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.transfer_account_code_prefix IS 'Prefix of the transfer accounts';


--
-- Name: COLUMN res_company.tax_calculation_rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.tax_calculation_rounding_method IS 'Tax Calculation Rounding Method';


--
-- Name: COLUMN res_company.terms_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.terms_type IS 'Terms & Conditions format';


--
-- Name: COLUMN res_company.quick_edit_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.quick_edit_mode IS 'Quick encoding';


--
-- Name: COLUMN res_company.account_price_include; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_price_include IS 'Default Sales Price Include';


--
-- Name: COLUMN res_company.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.fiscalyear_lock_date IS 'Global Lock Date';


--
-- Name: COLUMN res_company.tax_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.tax_lock_date IS 'Tax Return Lock Date';


--
-- Name: COLUMN res_company.sale_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sale_lock_date IS 'Sales Lock Date';


--
-- Name: COLUMN res_company.purchase_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.purchase_lock_date IS 'Purchase Lock date';


--
-- Name: COLUMN res_company.hard_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hard_lock_date IS 'Hard Lock Date';


--
-- Name: COLUMN res_company.account_opening_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_opening_date IS 'Opening Entry';


--
-- Name: COLUMN res_company.invoice_terms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.invoice_terms IS 'Default Terms and Conditions';


--
-- Name: COLUMN res_company.invoice_terms_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.invoice_terms_html IS 'Default Terms and Conditions as a Web page';


--
-- Name: COLUMN res_company.expects_chart_of_accounts; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.expects_chart_of_accounts IS 'Expects a Chart of Accounts';


--
-- Name: COLUMN res_company.anglo_saxon_accounting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.anglo_saxon_accounting IS 'Use anglo-saxon accounting';


--
-- Name: COLUMN res_company.qr_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.qr_code IS 'Display QR-code on invoices';


--
-- Name: COLUMN res_company.display_invoice_amount_total_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.display_invoice_amount_total_words IS 'Total amount of invoice in letters';


--
-- Name: COLUMN res_company.display_invoice_tax_company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.display_invoice_tax_company_currency IS 'Taxes in company currency';


--
-- Name: COLUMN res_company.account_use_credit_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_use_credit_limit IS 'Sales Credit Limit';


--
-- Name: COLUMN res_company.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.tax_exigibility IS 'Use Cash Basis';


--
-- Name: COLUMN res_company.account_storno; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_storno IS 'Storno accounting';


--
-- Name: COLUMN res_company.check_account_audit_trail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.check_account_audit_trail IS 'Audit Trail';


--
-- Name: COLUMN res_company.autopost_bills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.autopost_bills IS 'Auto-validate bills';


--
-- Name: COLUMN res_company.hr_presence_control_email_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email_amount IS '# emails to send';


--
-- Name: COLUMN res_company.hr_presence_control_ip_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip_list IS 'Valid IP addresses';


--
-- Name: COLUMN res_company.employee_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.employee_properties_definition IS 'Employee Properties';


--
-- Name: COLUMN res_company.hr_presence_control_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_login IS 'Based on user status in system';


--
-- Name: COLUMN res_company.hr_presence_control_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_email IS 'Based on number of emails sent';


--
-- Name: COLUMN res_company.hr_presence_control_ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_ip IS 'Based on IP Address';


--
-- Name: COLUMN res_company.hr_presence_control_attendance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_presence_control_attendance IS 'Based on attendances';


--
-- Name: COLUMN res_company.internal_transit_location_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.internal_transit_location_id IS 'Internal Transit Location';


--
-- Name: COLUMN res_company.stock_mail_confirmation_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_mail_confirmation_template_id IS 'Email Template confirmation picking';


--
-- Name: COLUMN res_company.annual_inventory_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.annual_inventory_day IS 'Day of the month';


--
-- Name: COLUMN res_company.annual_inventory_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.annual_inventory_month IS 'Annual Inventory Month';


--
-- Name: COLUMN res_company.stock_move_email_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_move_email_validation IS 'Email Confirmation picking';


--
-- Name: COLUMN res_company.signing_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.signing_user IS 'Signing User';


--
-- Name: COLUMN res_company.deferred_expense_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_expense_journal_id IS 'Deferred Expense Journal';


--
-- Name: COLUMN res_company.deferred_expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_expense_account_id IS 'Deferred Expense Account';


--
-- Name: COLUMN res_company.deferred_revenue_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_revenue_journal_id IS 'Deferred Revenue Journal';


--
-- Name: COLUMN res_company.deferred_revenue_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_revenue_account_id IS 'Deferred Revenue Account';


--
-- Name: COLUMN res_company.generate_deferred_expense_entries_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.generate_deferred_expense_entries_method IS 'Generate Deferred Expense Entries';


--
-- Name: COLUMN res_company.deferred_expense_amount_computation_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_expense_amount_computation_method IS 'Deferred Expense Based on';


--
-- Name: COLUMN res_company.generate_deferred_revenue_entries_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.generate_deferred_revenue_entries_method IS 'Generate Deferred Revenue Entries';


--
-- Name: COLUMN res_company.deferred_revenue_amount_computation_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.deferred_revenue_amount_computation_method IS 'Deferred Revenue Based on';


--
-- Name: COLUMN res_company.invoicing_switch_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.invoicing_switch_threshold IS 'Invoicing Switch Threshold';


--
-- Name: COLUMN res_company.predict_bill_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.predict_bill_product IS 'Predict Bill Product';


--
-- Name: COLUMN res_company.sign_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sign_invoice IS 'Display signing field on invoices';


--
-- Name: COLUMN res_company.vat_check_vies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.vat_check_vies IS 'Verify VAT Numbers';


--
-- Name: COLUMN res_company.currency_interval_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.currency_interval_unit IS 'Interval Unit';


--
-- Name: COLUMN res_company.currency_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.currency_provider IS 'Service Provider';


--
-- Name: COLUMN res_company.currency_next_execution_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.currency_next_execution_date IS 'Next Execution Date';


--
-- Name: COLUMN res_company.overtime_company_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.overtime_company_threshold IS 'Tolerance Time In Favor Of Company';


--
-- Name: COLUMN res_company.overtime_employee_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.overtime_employee_threshold IS 'Tolerance Time In Favor Of Employee';


--
-- Name: COLUMN res_company.attendance_kiosk_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.attendance_kiosk_delay IS 'Attendance Kiosk Delay';


--
-- Name: COLUMN res_company.attendance_kiosk_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.attendance_kiosk_mode IS 'Attendance Mode';


--
-- Name: COLUMN res_company.attendance_barcode_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.attendance_barcode_source IS 'Barcode Source';


--
-- Name: COLUMN res_company.attendance_kiosk_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.attendance_kiosk_key IS 'Attendance Kiosk Key';


--
-- Name: COLUMN res_company.attendance_overtime_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.attendance_overtime_validation IS 'Extra Hours Validation';


--
-- Name: COLUMN res_company.hr_attendance_display_overtime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.hr_attendance_display_overtime IS 'Display Extra Hours';


--
-- Name: COLUMN res_company.attendance_kiosk_use_pin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.attendance_kiosk_use_pin IS 'Employee PIN Identification';


--
-- Name: COLUMN res_company.attendance_from_systray; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.attendance_from_systray IS 'Attendance From Systray';


--
-- Name: COLUMN res_company.auto_check_out; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.auto_check_out IS 'Automatic Check Out';


--
-- Name: COLUMN res_company.absence_management; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.absence_management IS 'Absence Management';


--
-- Name: COLUMN res_company.auto_check_out_tolerance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.auto_check_out_tolerance IS 'Auto Check Out Tolerance';


--
-- Name: COLUMN res_company.po_lock; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.po_lock IS 'Purchase Order Modification';


--
-- Name: COLUMN res_company.po_double_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.po_double_validation IS 'Levels of Approvals';


--
-- Name: COLUMN res_company.po_double_validation_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.po_double_validation_amount IS 'Double validation amount';


--
-- Name: COLUMN res_company.po_lead; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.po_lead IS 'Purchase Lead Time';


--
-- Name: COLUMN res_company.account_production_wip_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_production_wip_account_id IS 'Production WIP Account';


--
-- Name: COLUMN res_company.account_production_wip_overhead_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_production_wip_overhead_account_id IS 'Production WIP Overhead Account';


--
-- Name: COLUMN res_company.stock_request_allow_virtual_loc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_request_allow_virtual_loc IS 'Allow Virtual locations on Stock Requests';


--
-- Name: COLUMN res_company.stock_request_check_available_first; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_request_check_available_first IS 'Check available stock first';


--
-- Name: COLUMN res_company.stock_sms_confirmation_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_sms_confirmation_template_id IS 'SMS Template';


--
-- Name: COLUMN res_company.stock_move_sms_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.stock_move_sms_validation IS 'SMS Confirmation';


--
-- Name: COLUMN res_company.has_received_warning_stock_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.has_received_warning_stock_sms IS 'Has Received Warning Stock Sms';


--
-- Name: COLUMN res_company.avalara_api_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_api_id IS 'Avalara API ID';


--
-- Name: COLUMN res_company.avalara_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_api_key IS 'Avalara API KEY';


--
-- Name: COLUMN res_company.avalara_environment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_environment IS 'Avalara Environment';


--
-- Name: COLUMN res_company.avalara_commit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_commit IS 'Commit in Avatax';


--
-- Name: COLUMN res_company.avalara_address_validation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_address_validation IS 'Avalara Address Validation';


--
-- Name: COLUMN res_company.avalara_use_upc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.avalara_use_upc IS 'Use UPC';


--
-- Name: COLUMN res_company.setting_account_avatax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.setting_account_avatax IS 'Use AvaTax';


--
-- Name: COLUMN res_company.days_to_purchase; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.days_to_purchase IS 'Days to Purchase';


--
-- Name: COLUMN res_company.quotation_validity_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.quotation_validity_days IS 'Default Quotation Validity';


--
-- Name: COLUMN res_company.sale_discount_product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sale_discount_product_id IS 'Discount Product';


--
-- Name: COLUMN res_company.sale_onboarding_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sale_onboarding_payment_method IS 'Sale onboarding selected payment method';


--
-- Name: COLUMN res_company.portal_confirmation_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.portal_confirmation_sign IS 'Online Signature';


--
-- Name: COLUMN res_company.portal_confirmation_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.portal_confirmation_pay IS 'Online Payment';


--
-- Name: COLUMN res_company.prepayment_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.prepayment_percent IS 'Prepayment percentage';


--
-- Name: COLUMN res_company.use_payment_pro; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.use_payment_pro IS 'Use Payment Pro';


--
-- Name: COLUMN res_company.account_tax_periodicity_reminder_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_tax_periodicity_reminder_day IS 'Start from';


--
-- Name: COLUMN res_company.account_tax_periodicity_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_tax_periodicity_journal_id IS 'Journal';


--
-- Name: COLUMN res_company.account_revaluation_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_revaluation_journal_id IS 'Account Revaluation Journal';


--
-- Name: COLUMN res_company.account_revaluation_expense_provision_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_revaluation_expense_provision_account_id IS 'Expense Provision Account';


--
-- Name: COLUMN res_company.account_revaluation_income_provision_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_revaluation_income_provision_account_id IS 'Income Provision Account';


--
-- Name: COLUMN res_company.account_representative_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_representative_id IS 'Accounting Firm';


--
-- Name: COLUMN res_company.account_tax_periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.account_tax_periodicity IS 'Delay units';


--
-- Name: COLUMN res_company.totals_below_sections; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.totals_below_sections IS 'Add totals below sections';


--
-- Name: COLUMN res_company.reconcile_on_company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.reconcile_on_company_currency IS 'Reconcile On Company Currency';


--
-- Name: COLUMN res_company.l10n_ar_afip_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_start_date IS 'Activities Start';


--
-- Name: COLUMN res_company.sale_order_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.sale_order_template_id IS 'Default Sale Template';


--
-- Name: COLUMN res_company.security_lead; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.security_lead IS 'Sales Safety Days';


--
-- Name: COLUMN res_company.gain_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.gain_account_id IS 'Gain Account';


--
-- Name: COLUMN res_company.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN res_company.extract_bank_statement_digitalization_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.extract_bank_statement_digitalization_mode IS 'Digitization mode on bank statements';


--
-- Name: COLUMN res_company.extract_in_invoice_digitalization_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.extract_in_invoice_digitalization_mode IS 'Digitization mode on vendor bills';


--
-- Name: COLUMN res_company.extract_out_invoice_digitalization_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.extract_out_invoice_digitalization_mode IS 'Digitization mode on customer invoices';


--
-- Name: COLUMN res_company.extract_single_line_per_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.extract_single_line_per_tax IS 'Single Invoice Line Per Tax';


--
-- Name: COLUMN res_company.use_receiptbook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.use_receiptbook IS 'Use Receiptbook';


--
-- Name: COLUMN res_company.l10n_ar_afip_ws_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_ws_key_id IS 'Private Key';


--
-- Name: COLUMN res_company.l10n_ar_afip_ws_crt_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_ws_crt_id IS 'AFIP Certificate';


--
-- Name: COLUMN res_company.l10n_ar_afip_verification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_verification_type IS 'AFIP Invoice Verification';


--
-- Name: COLUMN res_company.l10n_ar_afip_ws_environment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_ws_environment IS 'AFIP Environment';


--
-- Name: COLUMN res_company.l10n_ar_fce_transmission_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_fce_transmission_type IS 'FCE: Transmission Option Default';


--
-- Name: COLUMN res_company.l10n_ar_computable_tax_credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_computable_tax_credit IS 'Computable Tax Credit: Prorate Options';


--
-- Name: COLUMN res_company.l10n_ar_afip_activity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_afip_activity_id IS 'Principal Activity';


--
-- Name: COLUMN res_company.arba_cit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.arba_cit IS 'CIT ARBA';


--
-- Name: COLUMN res_company.l10n_ar_report_signed_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_report_signed_by IS 'Aclaracion';


--
-- Name: COLUMN res_company.l10n_ar_invoice_report_ars_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_invoice_report_ars_amount IS 'Mostrar importe equivalente en ARS';


--
-- Name: COLUMN res_company.l10n_ar_tax_base_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_tax_base_account_id IS 'Tax Base Account';


--
-- Name: COLUMN res_company.l10n_ar_last_currency_sync_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.l10n_ar_last_currency_sync_date IS 'AFIP Last Sync Date';


--
-- Name: COLUMN res_company.rate_perc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.rate_perc IS 'Rate Perc';


--
-- Name: COLUMN res_company.rate_surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.rate_surcharge IS 'Rate Surcharge';


--
-- Name: COLUMN res_company.arba_cot; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.arba_cot IS 'Clave COT';


--
-- Name: CONSTRAINT res_company_check_quotation_validity_days ON res_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_company_check_quotation_validity_days ON public.res_company IS 'CHECK(quotation_validity_days >= 0)';


--
-- Name: resource_calendar; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_calendar (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    tz character varying NOT NULL,
    hours_per_day numeric,
    active boolean,
    two_weeks_calendar boolean,
    flexible_hours boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    full_time_required_hours double precision
);


ALTER TABLE public.resource_calendar OWNER TO runbot;

--
-- Name: TABLE resource_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_calendar IS 'Resource Working Time';


--
-- Name: COLUMN resource_calendar.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.company_id IS 'Company';


--
-- Name: COLUMN resource_calendar.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_uid IS 'Created by';


--
-- Name: COLUMN resource_calendar.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_calendar.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.name IS 'Name';


--
-- Name: COLUMN resource_calendar.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.tz IS 'Timezone';


--
-- Name: COLUMN resource_calendar.hours_per_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.hours_per_day IS 'Average Hour per Day';


--
-- Name: COLUMN resource_calendar.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.active IS 'Active';


--
-- Name: COLUMN resource_calendar.two_weeks_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.two_weeks_calendar IS 'Calendar in 2 weeks mode';


--
-- Name: COLUMN resource_calendar.flexible_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.flexible_hours IS 'Flexible Hours';


--
-- Name: COLUMN resource_calendar.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.create_date IS 'Created on';


--
-- Name: COLUMN resource_calendar.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_calendar.full_time_required_hours; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_calendar.full_time_required_hours IS 'Company Full Time';


--
-- Name: resource_resource; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.resource_resource (
    id integer NOT NULL,
    company_id integer,
    user_id integer,
    calendar_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    resource_type character varying NOT NULL,
    tz character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    time_efficiency double precision NOT NULL,
    CONSTRAINT resource_resource_check_time_efficiency CHECK ((time_efficiency > (0)::double precision))
);


ALTER TABLE public.resource_resource OWNER TO runbot;

--
-- Name: TABLE resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.resource_resource IS 'Resources';


--
-- Name: COLUMN resource_resource.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.company_id IS 'Company';


--
-- Name: COLUMN resource_resource.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.user_id IS 'User';


--
-- Name: COLUMN resource_resource.calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.calendar_id IS 'Working Time';


--
-- Name: COLUMN resource_resource.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_uid IS 'Created by';


--
-- Name: COLUMN resource_resource.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_uid IS 'Last Updated by';


--
-- Name: COLUMN resource_resource.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.name IS 'Name';


--
-- Name: COLUMN resource_resource.resource_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.resource_type IS 'Type';


--
-- Name: COLUMN resource_resource.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.tz IS 'Timezone';


--
-- Name: COLUMN resource_resource.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.active IS 'Active';


--
-- Name: COLUMN resource_resource.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.create_date IS 'Created on';


--
-- Name: COLUMN resource_resource.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.write_date IS 'Last Updated on';


--
-- Name: COLUMN resource_resource.time_efficiency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.resource_resource.time_efficiency IS 'Efficiency Factor';


--
-- Name: CONSTRAINT resource_resource_check_time_efficiency ON resource_resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT resource_resource_check_time_efficiency ON public.resource_resource IS 'CHECK(time_efficiency>0)';


--
-- Name: hr_leave_report_calendar; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.hr_leave_report_calendar AS
 SELECT hl.id,
    hl.id AS leave_id,
    hl.date_from AS start_datetime,
    hl.date_to AS stop_datetime,
    hl.employee_id,
    hl.state,
    hl.department_id,
    hl.number_of_days AS duration,
    hl.private_name AS description,
    hl.holiday_status_id,
    em.company_id,
    em.job_id,
    COALESCE(rr.tz, rc.tz, cc.tz, 'UTC'::character varying) AS tz,
    ((hl.state)::text = 'refuse'::text) AS is_striked,
    ((hl.state)::text <> ALL ((ARRAY['validate'::character varying, 'refuse'::character varying])::text[])) AS is_hatched
   FROM (((((public.hr_leave hl
     LEFT JOIN public.hr_employee em ON ((em.id = hl.employee_id)))
     LEFT JOIN public.resource_resource rr ON ((rr.id = em.resource_id)))
     LEFT JOIN public.resource_calendar rc ON ((rc.id = em.resource_calendar_id)))
     LEFT JOIN public.res_company co ON ((co.id = em.company_id)))
     LEFT JOIN public.resource_calendar cc ON ((cc.id = co.resource_calendar_id)))
  WHERE ((hl.state)::text = ANY ((ARRAY['confirm'::character varying, 'validate'::character varying, 'validate1'::character varying, 'refuse'::character varying])::text[]));


ALTER VIEW public.hr_leave_report_calendar OWNER TO runbot;

--
-- Name: hr_leave_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_type (
    id integer NOT NULL,
    sequence integer,
    color integer,
    icon_id integer,
    company_id integer,
    leave_notif_subtype_id integer,
    allocation_notif_subtype_id integer,
    max_allowed_negative integer,
    create_uid integer,
    write_uid integer,
    leave_validation_type character varying,
    requires_allocation character varying NOT NULL,
    employee_requests character varying NOT NULL,
    allocation_validation_type character varying,
    time_type character varying,
    request_unit character varying NOT NULL,
    name jsonb NOT NULL,
    create_calendar_meeting boolean,
    active boolean,
    show_on_dashboard boolean,
    unpaid boolean,
    include_public_holidays_in_duration boolean,
    support_document boolean,
    allows_negative boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    overtime_deductible boolean,
    CONSTRAINT hr_leave_type_check_negative CHECK (((NOT allows_negative) OR (max_allowed_negative > 0)))
);


ALTER TABLE public.hr_leave_type OWNER TO runbot;

--
-- Name: TABLE hr_leave_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_type IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_leave_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.color IS 'Color';


--
-- Name: COLUMN hr_leave_type.icon_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.icon_id IS 'Cover Image';


--
-- Name: COLUMN hr_leave_type.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.company_id IS 'Company';


--
-- Name: COLUMN hr_leave_type.leave_notif_subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.leave_notif_subtype_id IS 'Time Off Notification Subtype';


--
-- Name: COLUMN hr_leave_type.allocation_notif_subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.allocation_notif_subtype_id IS 'Allocation Notification Subtype';


--
-- Name: COLUMN hr_leave_type.max_allowed_negative; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.max_allowed_negative IS 'Maximum Excess Amount';


--
-- Name: COLUMN hr_leave_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_leave_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_leave_type.leave_validation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.leave_validation_type IS 'Time Off Validation';


--
-- Name: COLUMN hr_leave_type.requires_allocation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.requires_allocation IS 'Requires allocation';


--
-- Name: COLUMN hr_leave_type.employee_requests; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.employee_requests IS 'Employee Requests';


--
-- Name: COLUMN hr_leave_type.allocation_validation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.allocation_validation_type IS 'Approval';


--
-- Name: COLUMN hr_leave_type.time_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.time_type IS 'Kind of Time Off';


--
-- Name: COLUMN hr_leave_type.request_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.request_unit IS 'Take Time Off in';


--
-- Name: COLUMN hr_leave_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.name IS 'Time Off Type';


--
-- Name: COLUMN hr_leave_type.create_calendar_meeting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.create_calendar_meeting IS 'Display Time Off in Calendar';


--
-- Name: COLUMN hr_leave_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.active IS 'Active';


--
-- Name: COLUMN hr_leave_type.show_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.show_on_dashboard IS 'Show On Dashboard';


--
-- Name: COLUMN hr_leave_type.unpaid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.unpaid IS 'Is Unpaid';


--
-- Name: COLUMN hr_leave_type.include_public_holidays_in_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.include_public_holidays_in_duration IS 'Public Holiday Included';


--
-- Name: COLUMN hr_leave_type.support_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.support_document IS 'Supporting Document';


--
-- Name: COLUMN hr_leave_type.allows_negative; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.allows_negative IS 'Allow Negative Cap';


--
-- Name: COLUMN hr_leave_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_leave_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN hr_leave_type.overtime_deductible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_leave_type.overtime_deductible IS 'Deduct Extra Hours';


--
-- Name: CONSTRAINT hr_leave_type_check_negative ON hr_leave_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_leave_type_check_negative ON public.hr_leave_type IS 'CHECK(NOT allows_negative OR max_allowed_negative > 0)';


--
-- Name: hr_leave_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_leave_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_leave_type_id_seq OWNER TO runbot;

--
-- Name: hr_leave_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_leave_type_id_seq OWNED BY public.hr_leave_type.id;


--
-- Name: hr_leave_type_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_leave_type_res_users_rel (
    hr_leave_type_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.hr_leave_type_res_users_rel OWNER TO runbot;

--
-- Name: TABLE hr_leave_type_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_leave_type_res_users_rel IS 'RELATION BETWEEN hr_leave_type AND res_users';


--
-- Name: hr_resume_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_resume_line (
    id integer NOT NULL,
    employee_id integer NOT NULL,
    line_type_id integer,
    create_uid integer,
    write_uid integer,
    display_type character varying,
    date_start date NOT NULL,
    date_end date,
    name jsonb NOT NULL,
    description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT hr_resume_line_date_check CHECK (((date_start <= date_end) OR (date_end IS NULL)))
);


ALTER TABLE public.hr_resume_line OWNER TO runbot;

--
-- Name: TABLE hr_resume_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_resume_line IS 'Resume line of an employee';


--
-- Name: COLUMN hr_resume_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.employee_id IS 'Employee';


--
-- Name: COLUMN hr_resume_line.line_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.line_type_id IS 'Type';


--
-- Name: COLUMN hr_resume_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.create_uid IS 'Created by';


--
-- Name: COLUMN hr_resume_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_resume_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.display_type IS 'Display Type';


--
-- Name: COLUMN hr_resume_line.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.date_start IS 'Date Start';


--
-- Name: COLUMN hr_resume_line.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.date_end IS 'Date End';


--
-- Name: COLUMN hr_resume_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.name IS 'Name';


--
-- Name: COLUMN hr_resume_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.description IS 'Description';


--
-- Name: COLUMN hr_resume_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.create_date IS 'Created on';


--
-- Name: COLUMN hr_resume_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT hr_resume_line_date_check ON hr_resume_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT hr_resume_line_date_check ON public.hr_resume_line IS 'CHECK ((date_start <= date_end OR date_end IS NULL))';


--
-- Name: hr_resume_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_resume_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_resume_line_id_seq OWNER TO runbot;

--
-- Name: hr_resume_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_resume_line_id_seq OWNED BY public.hr_resume_line.id;


--
-- Name: hr_resume_line_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_resume_line_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_resume_line_type OWNER TO runbot;

--
-- Name: TABLE hr_resume_line_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_resume_line_type IS 'Type of a resume line';


--
-- Name: COLUMN hr_resume_line_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.sequence IS 'Sequence';


--
-- Name: COLUMN hr_resume_line_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.create_uid IS 'Created by';


--
-- Name: COLUMN hr_resume_line_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_resume_line_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.name IS 'Name';


--
-- Name: COLUMN hr_resume_line_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.create_date IS 'Created on';


--
-- Name: COLUMN hr_resume_line_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_resume_line_type.write_date IS 'Last Updated on';


--
-- Name: hr_resume_line_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_resume_line_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_resume_line_type_id_seq OWNER TO runbot;

--
-- Name: hr_resume_line_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_resume_line_type_id_seq OWNED BY public.hr_resume_line_type.id;


--
-- Name: hr_skill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_skill (
    id integer NOT NULL,
    sequence integer,
    skill_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_skill OWNER TO runbot;

--
-- Name: TABLE hr_skill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_skill IS 'Skill';


--
-- Name: COLUMN hr_skill.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.sequence IS 'Sequence';


--
-- Name: COLUMN hr_skill.skill_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.skill_type_id IS 'Skill Type';


--
-- Name: COLUMN hr_skill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.create_uid IS 'Created by';


--
-- Name: COLUMN hr_skill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_skill.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.name IS 'Name';


--
-- Name: COLUMN hr_skill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.create_date IS 'Created on';


--
-- Name: COLUMN hr_skill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_skill.write_date IS 'Last Updated on';


--
-- Name: hr_skill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_id_seq OWNER TO runbot;

--
-- Name: hr_skill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_id_seq OWNED BY public.hr_skill.id;


--
-- Name: hr_skill_level_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_level_id_seq OWNER TO runbot;

--
-- Name: hr_skill_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_level_id_seq OWNED BY public.hr_skill_level.id;


--
-- Name: hr_skill_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_skill_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_skill_type_id_seq OWNER TO runbot;

--
-- Name: hr_skill_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_skill_type_id_seq OWNED BY public.hr_skill_type.id;


--
-- Name: hr_work_location; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.hr_work_location (
    id integer NOT NULL,
    company_id integer NOT NULL,
    address_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location_type character varying NOT NULL,
    location_number character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.hr_work_location OWNER TO runbot;

--
-- Name: TABLE hr_work_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.hr_work_location IS 'Work Location';


--
-- Name: COLUMN hr_work_location.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.company_id IS 'Company';


--
-- Name: COLUMN hr_work_location.address_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.address_id IS 'Work Address';


--
-- Name: COLUMN hr_work_location.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_uid IS 'Created by';


--
-- Name: COLUMN hr_work_location.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_uid IS 'Last Updated by';


--
-- Name: COLUMN hr_work_location.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.name IS 'Work Location';


--
-- Name: COLUMN hr_work_location.location_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.location_type IS 'Cover Image';


--
-- Name: COLUMN hr_work_location.location_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.location_number IS 'Location Number';


--
-- Name: COLUMN hr_work_location.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.active IS 'Active';


--
-- Name: COLUMN hr_work_location.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.create_date IS 'Created on';


--
-- Name: COLUMN hr_work_location.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.hr_work_location.write_date IS 'Last Updated on';


--
-- Name: hr_work_location_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.hr_work_location_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.hr_work_location_id_seq OWNER TO runbot;

--
-- Name: hr_work_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.hr_work_location_id_seq OWNED BY public.hr_work_location.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision,
    sender_name character varying
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: COLUMN iap_account.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.sender_name IS 'Sender Name';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: inflation_adjustment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.inflation_adjustment (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    account_id integer NOT NULL,
    closure_move_id integer,
    open_move_id integer,
    create_uid integer,
    write_uid integer,
    open_cloure_entry character varying,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.inflation_adjustment OWNER TO runbot;

--
-- Name: TABLE inflation_adjustment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.inflation_adjustment IS 'Inflation adjustment';


--
-- Name: COLUMN inflation_adjustment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.journal_id IS 'Journal';


--
-- Name: COLUMN inflation_adjustment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.company_id IS 'Company';


--
-- Name: COLUMN inflation_adjustment.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.account_id IS 'Account';


--
-- Name: COLUMN inflation_adjustment.closure_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.closure_move_id IS 'Asiento de cierre';


--
-- Name: COLUMN inflation_adjustment.open_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.open_move_id IS 'Asiento de apertura';


--
-- Name: COLUMN inflation_adjustment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.create_uid IS 'Created by';


--
-- Name: COLUMN inflation_adjustment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN inflation_adjustment.open_cloure_entry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.open_cloure_entry IS 'Ha realizado asientos de cierre/apertura?';


--
-- Name: COLUMN inflation_adjustment.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.date_from IS 'Date From';


--
-- Name: COLUMN inflation_adjustment.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.date_to IS 'Date To';


--
-- Name: COLUMN inflation_adjustment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.create_date IS 'Created on';


--
-- Name: COLUMN inflation_adjustment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.write_date IS 'Last Updated on';


--
-- Name: inflation_adjustment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.inflation_adjustment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.inflation_adjustment_id_seq OWNER TO runbot;

--
-- Name: inflation_adjustment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.inflation_adjustment_id_seq OWNED BY public.inflation_adjustment.id;


--
-- Name: inflation_adjustment_index; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.inflation_adjustment_index (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    value numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.inflation_adjustment_index OWNER TO runbot;

--
-- Name: TABLE inflation_adjustment_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.inflation_adjustment_index IS 'Inflation Adjustment Index';


--
-- Name: COLUMN inflation_adjustment_index.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.create_uid IS 'Created by';


--
-- Name: COLUMN inflation_adjustment_index.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.write_uid IS 'Last Updated by';


--
-- Name: COLUMN inflation_adjustment_index.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.date IS 'Date';


--
-- Name: COLUMN inflation_adjustment_index.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.value IS 'Value';


--
-- Name: COLUMN inflation_adjustment_index.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.create_date IS 'Created on';


--
-- Name: COLUMN inflation_adjustment_index.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.write_date IS 'Last Updated on';


--
-- Name: inflation_adjustment_index_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.inflation_adjustment_index_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.inflation_adjustment_index_id_seq OWNER TO runbot;

--
-- Name: inflation_adjustment_index_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.inflation_adjustment_index_id_seq OWNED BY public.inflation_adjustment_index.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean,
    stylesheet_id integer,
    attachment_id integer,
    out_format integer,
    copies integer,
    deferred_limit integer,
    replace_report_id integer,
    wizard_id integer,
    charset character varying NOT NULL,
    styles_mode character varying,
    preload_mode character varying,
    tml_source character varying,
    parser_model character varying,
    in_format character varying,
    deferred character varying,
    process_sep boolean,
    report_wizard boolean,
    copies_intercalate boolean,
    disable_fallback boolean,
    is_invoice_report boolean,
    l10n_ar_copies character varying
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: COLUMN ir_act_report_xml.stylesheet_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.stylesheet_id IS 'Template Stylesheet';


--
-- Name: COLUMN ir_act_report_xml.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_id IS 'Attachment';


--
-- Name: COLUMN ir_act_report_xml.out_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.out_format IS 'Output Mime-type';


--
-- Name: COLUMN ir_act_report_xml.copies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.copies IS 'Number of Copies';


--
-- Name: COLUMN ir_act_report_xml.deferred_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.deferred_limit IS 'Deferred Records Limit';


--
-- Name: COLUMN ir_act_report_xml.replace_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.replace_report_id IS 'Replace Report';


--
-- Name: COLUMN ir_act_report_xml.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.wizard_id IS 'Wizard Action';


--
-- Name: COLUMN ir_act_report_xml.charset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.charset IS 'Charset';


--
-- Name: COLUMN ir_act_report_xml.styles_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.styles_mode IS 'Stylesheet';


--
-- Name: COLUMN ir_act_report_xml.preload_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.preload_mode IS 'Preload Mode';


--
-- Name: COLUMN ir_act_report_xml.tml_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.tml_source IS 'Template source';


--
-- Name: COLUMN ir_act_report_xml.parser_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.parser_model IS 'Parser Model';


--
-- Name: COLUMN ir_act_report_xml.in_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.in_format IS 'Template Mime-type';


--
-- Name: COLUMN ir_act_report_xml.deferred; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.deferred IS 'Deferred';


--
-- Name: COLUMN ir_act_report_xml.process_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.process_sep IS 'Process Separately';


--
-- Name: COLUMN ir_act_report_xml.report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_wizard IS 'Report Wizard';


--
-- Name: COLUMN ir_act_report_xml.copies_intercalate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.copies_intercalate IS 'Copies Intercalate';


--
-- Name: COLUMN ir_act_report_xml.disable_fallback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.disable_fallback IS 'Disable Format Fallback';


--
-- Name: COLUMN ir_act_report_xml.is_invoice_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.is_invoice_report IS 'Invoice report';


--
-- Name: COLUMN ir_act_report_xml.l10n_ar_copies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.l10n_ar_copies IS 'Agregar Duplicado/Triplicado';


--
-- Name: ir_act_report_xml_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_act_report_xml_id integer NOT NULL
);


ALTER TABLE public.ir_act_report_xml_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_report_xml_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_report_xml_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_act_report_xml';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    selection_value integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text,
    template_id integer,
    activity_type_id integer,
    activity_date_deadline_range integer,
    activity_user_id integer,
    mail_post_method character varying,
    activity_summary character varying,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_field_name character varying,
    activity_note text,
    mail_post_autofollow boolean,
    sms_template_id integer,
    sms_method character varying,
    base_automation_id integer
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.mail_post_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_method IS 'Send Email As';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Title';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'User Type';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User Field';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.mail_post_autofollow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_autofollow IS 'Subscribe Recipients';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_method IS 'Send SMS As';


--
-- Name: COLUMN ir_act_server.base_automation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.base_automation_id IS 'Automation Rule';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_server_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_act_server';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_cron_id integer NOT NULL
);


ALTER TABLE public.ir_cron_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_cron_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_cron';


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    json_value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default.json_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.json_value IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
                (action_id IS NOT NULL AND python_method IS NULL) OR
                (action_id IS NULL AND python_method IS NOT NULL)
            )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(
                NOT (python_method IS NOT NULL AND name IS NULL)
            )';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(
                NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL)
            )';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN ir_mail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Has Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Has Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Has Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_access_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_model_access_id integer NOT NULL
);


ALTER TABLE public.ir_model_access_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_access_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_model_access';


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    tracking integer,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_model_fields';


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: r