--
-- PostgreSQL database dump
--

\restrict fwMazagiMc556wAiDeHuPTk52foLSYxrRZV4V9yNfYWiKM6oh9TTU0uRx7OlDNs

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 16.11 (Debian 16.11-1.pgdg11+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    message_main_attachment_id integer,
    currency_id integer,
    company_id integer NOT NULL,
    group_id integer,
    root_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying(64) NOT NULL,
    account_type character varying NOT NULL,
    internal_group character varying,
    note text,
    deprecated boolean,
    include_initial_balance boolean,
    reconcile boolean,
    is_off_balance boolean,
    non_trade boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    analytic_distribution_required boolean,
    asset_model integer,
    create_asset character varying NOT NULL,
    multiple_assets_per_line boolean
);


ALTER TABLE public.account_account OWNER TO runbot;

--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.company_id IS 'Company';


--
-- Name: COLUMN account_account.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.group_id IS 'Group';


--
-- Name: COLUMN account_account.root_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.root_id IS 'Root';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.name IS 'Account Name';


--
-- Name: COLUMN account_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.code IS 'Code';


--
-- Name: COLUMN account_account.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.account_type IS 'Type';


--
-- Name: COLUMN account_account.internal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.internal_group IS 'Internal Group';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.deprecated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.deprecated IS 'Deprecated';


--
-- Name: COLUMN account_account.include_initial_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.include_initial_balance IS 'Bring Accounts Balance Forward';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.is_off_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.is_off_balance IS 'Is Off Balance';


--
-- Name: COLUMN account_account.non_trade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.non_trade IS 'Non Trade';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account.analytic_distribution_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.analytic_distribution_required IS 'Analytic Distribution Required?';


--
-- Name: COLUMN account_account.asset_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.asset_model IS 'Asset Model';


--
-- Name: COLUMN account_account.create_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_asset IS 'Create Asset';


--
-- Name: COLUMN account_account.multiple_assets_per_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.multiple_assets_per_line IS 'Multiple Assets per Line';


--
-- Name: account_account_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_journal_rel (
    account_account_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_account_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_journal_rel IS 'RELATION BETWEEN account_account AND account_journal';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_consolidation_account_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_consolidation_account_rel (
    account_account_id integer NOT NULL,
    consolidation_account_id integer NOT NULL
);


ALTER TABLE public.account_account_consolidation_account_rel OWNER TO runbot;

--
-- Name: TABLE account_account_consolidation_account_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_consolidation_account_rel IS 'RELATION BETWEEN account_account AND consolidation_account';


--
-- Name: account_account_exclude_res_currency_provision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_exclude_res_currency_provision (
    account_account_id integer NOT NULL,
    res_currency_id integer NOT NULL
);


ALTER TABLE public.account_account_exclude_res_currency_provision OWNER TO runbot;

--
-- Name: TABLE account_account_exclude_res_currency_provision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_exclude_res_currency_provision IS 'RELATION BETWEEN account_account AND res_currency';


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_id_seq OWNER TO runbot;

--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_res_company_interest_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_res_company_interest_rel (
    res_company_interest_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_res_company_interest_rel OWNER TO runbot;

--
-- Name: TABLE account_account_res_company_interest_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_res_company_interest_rel IS 'RELATION BETWEEN res_company_interest AND account_account';


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    color integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    applicability character varying NOT NULL,
    active boolean,
    tax_negate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    jurisdiction_code character varying(3)
);


ALTER TABLE public.account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.tax_negate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.tax_negate IS 'Negate Tax Balance';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account_tag.jurisdiction_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.jurisdiction_code IS 'Jurisdiction Code';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_tax_repartition_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_tag_id_seq OWNER TO runbot;

--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tag_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_product_template_rel (
    product_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_product_template_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_product_template_rel IS 'RELATION BETWEEN product_template AND account_account_tag';


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_tax_default_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_account_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_template (
    id integer NOT NULL,
    message_main_attachment_id integer,
    currency_id integer,
    chart_template_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying(64) NOT NULL,
    account_type character varying,
    note text,
    reconcile boolean,
    nocreate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_template OWNER TO runbot;

--
-- Name: TABLE account_account_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_template IS 'Templates for Accounts';


--
-- Name: COLUMN account_account_template.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_account_template.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_account_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.name IS 'Name';


--
-- Name: COLUMN account_account_template.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.code IS 'Code';


--
-- Name: COLUMN account_account_template.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.account_type IS 'Type';


--
-- Name: COLUMN account_account_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.note IS 'Note';


--
-- Name: COLUMN account_account_template.reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.reconcile IS 'Allow Invoices & payments Matching';


--
-- Name: COLUMN account_account_template.nocreate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.nocreate IS 'Optional Create';


--
-- Name: COLUMN account_account_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.create_date IS 'Created on';


--
-- Name: COLUMN account_account_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_template.write_date IS 'Last Updated on';


--
-- Name: account_account_template_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_template_account_tag (
    account_account_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_template_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_template_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_template_account_tag IS 'RELATION BETWEEN account_account_template AND account_account_tag';


--
-- Name: account_account_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_template_id_seq OWNER TO runbot;

--
-- Name: account_account_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_template_id_seq OWNED BY public.account_account_template.id;


--
-- Name: account_account_template_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_template_tax_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_template_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_account_template_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_template_tax_rel IS 'RELATION BETWEEN account_account_template AND account_tax_template';


--
-- Name: account_accrued_orders_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_accrued_orders_wizard (
    id integer NOT NULL,
    company_id integer,
    currency_id integer,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_accrued_orders_wizard OWNER TO runbot;

--
-- Name: TABLE account_accrued_orders_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_accrued_orders_wizard IS 'Accrued Orders Wizard';


--
-- Name: COLUMN account_accrued_orders_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrued_orders_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.currency_id IS 'Company Currency';


--
-- Name: COLUMN account_accrued_orders_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.account_id IS 'Accrual Account';


--
-- Name: COLUMN account_accrued_orders_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrued_orders_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrued_orders_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrued_orders_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_accrued_orders_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.amount IS 'Amount';


--
-- Name: COLUMN account_accrued_orders_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrued_orders_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_accrued_orders_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNER TO runbot;

--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNED BY public.account_accrued_orders_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    message_main_attachment_id integer,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    commercial_partner_id integer
);


ALTER TABLE public.account_analytic_account OWNER TO runbot;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_account.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.commercial_partner_id IS 'Commercial Partner';


--
-- Name: account_analytic_account_account_transfer_model_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account_account_transfer_model_line_rel (
    account_transfer_model_line_id integer NOT NULL,
    account_analytic_account_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_account_transfer_model_line_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_account_account_transfer_model_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account_account_transfer_model_line_rel IS 'RELATION BETWEEN account_transfer_model_line AND account_analytic_account';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO runbot;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_applicability OWNER TO runbot;

--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_applicability.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_applicability.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.account_prefix IS 'Financial Accounts Prefix';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNER TO runbot;

--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_distribution_model OWNER TO runbot;

--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_distribution_model.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_distribution_model.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_distribution_model.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.account_prefix IS 'Accounts Prefix';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNER TO runbot;

--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    product_uom_id integer,
    account_id integer NOT NULL,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    plan_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision,
    product_id integer,
    general_account_id integer,
    journal_id integer,
    move_line_id integer,
    code character varying(8),
    ref character varying,
    task_id integer,
    ancestor_task_id integer,
    project_id integer,
    employee_id integer,
    department_id integer,
    manager_id integer,
    holiday_id integer,
    global_leave_id integer,
    so_line integer,
    validated boolean,
    helpdesk_ticket_id integer,
    timesheet_invoice_id integer,
    order_id integer,
    timesheet_invoice_type character varying,
    is_so_line_edited boolean
);


ALTER TABLE public.account_analytic_line OWNER TO runbot;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.journal_id IS 'Financial Journal';


--
-- Name: COLUMN account_analytic_line.move_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.move_line_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.task_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.task_id IS 'Task';


--
-- Name: COLUMN account_analytic_line.ancestor_task_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.ancestor_task_id IS 'Ancestor Task';


--
-- Name: COLUMN account_analytic_line.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.project_id IS 'Project';


--
-- Name: COLUMN account_analytic_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.employee_id IS 'Employee';


--
-- Name: COLUMN account_analytic_line.department_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.department_id IS 'Department';


--
-- Name: COLUMN account_analytic_line.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.manager_id IS 'Manager';


--
-- Name: COLUMN account_analytic_line.holiday_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.holiday_id IS 'Leave Request';


--
-- Name: COLUMN account_analytic_line.global_leave_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.global_leave_id IS 'Global Time Off';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: COLUMN account_analytic_line.validated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.validated IS 'Validated line';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_id IS 'Invoice';


--
-- Name: COLUMN account_analytic_line.order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.order_id IS 'Order Reference';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_type IS 'Billable Type';


--
-- Name: COLUMN account_analytic_line.is_so_line_edited; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.is_so_line_edited IS 'Is Sales Order Item Manually Edited';


--
-- Name: account_analytic_line_hr_timesheet_merge_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel (
    hr_timesheet_merge_wizard_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_hr_timesheet_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel IS 'RELATION BETWEEN hr_timesheet_merge_wizard AND account_analytic_line';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    company_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    parent_path character varying,
    complete_name character varying,
    default_applicability character varying NOT NULL,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_plan OWNER TO runbot;

--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_plan_id_seq OWNER TO runbot;

--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: account_ar_vat_line; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.account_ar_vat_line AS
SELECT
    NULL::text AS column_group_key,
    NULL::integer AS id,
    NULL::character varying AS cuit,
    NULL::character varying AS afip_responsibility_type_name,
    NULL::character varying AS partner_name,
    NULL::character varying AS tax_type,
    NULL::integer AS move_id,
    NULL::character varying AS move_type,
    NULL::date AS date,
    NULL::date AS invoice_date,
    NULL::integer AS partner_id,
    NULL::integer AS journal_id,
    NULL::character varying AS move_name,
    NULL::integer AS afip_responsibility_type_id,
    NULL::integer AS document_type_id,
    NULL::character varying AS state,
    NULL::integer AS company_id,
    NULL::numeric AS taxed,
    NULL::numeric AS base_10,
    NULL::numeric AS vat_10,
    NULL::numeric AS base_21,
    NULL::numeric AS vat_21,
    NULL::numeric AS base_27,
    NULL::numeric AS vat_27,
    NULL::numeric AS base_5,
    NULL::numeric AS vat_5,
    NULL::numeric AS base_25,
    NULL::numeric AS vat_25,
    NULL::numeric AS not_taxed,
    NULL::numeric AS vat_per,
    NULL::numeric AS other_taxes,
    NULL::numeric AS total;


ALTER VIEW public.account_ar_vat_line OWNER TO runbot;

--
-- Name: account_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_asset (
    id integer NOT NULL,
    message_main_attachment_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    method_number integer,
    account_asset_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    journal_id integer,
    model_id integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    asset_type character varying,
    method character varying,
    method_period character varying,
    prorata_computation_type character varying NOT NULL,
    prorata_date date,
    acquisition_date date,
    disposal_date date,
    analytic_distribution jsonb,
    original_value numeric,
    book_value numeric,
    salvage_value numeric,
    non_deductible_tax_value numeric,
    already_depreciated_amount_import numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    method_progress_factor double precision,
    asset_paused_days double precision
);


ALTER TABLE public.account_asset OWNER TO runbot;

--
-- Name: TABLE account_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_asset IS 'Asset/Revenue Recognition';


--
-- Name: COLUMN account_asset.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_asset.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.company_id IS 'Company';


--
-- Name: COLUMN account_asset.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.currency_id IS 'Currency';


--
-- Name: COLUMN account_asset.method_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_number IS 'Duration';


--
-- Name: COLUMN account_asset.account_asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_asset_id IS 'Fixed Asset Account';


--
-- Name: COLUMN account_asset.account_depreciation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN account_asset.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN account_asset.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.journal_id IS 'Journal';


--
-- Name: COLUMN account_asset.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.model_id IS 'Model';


--
-- Name: COLUMN account_asset.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.parent_id IS 'Parent';


--
-- Name: COLUMN account_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.name IS 'Asset Name';


--
-- Name: COLUMN account_asset.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.state IS 'Status';


--
-- Name: COLUMN account_asset.asset_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_type IS 'Asset Type';


--
-- Name: COLUMN account_asset.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method IS 'Method';


--
-- Name: COLUMN account_asset.method_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN account_asset.prorata_computation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.prorata_computation_type IS 'Computation';


--
-- Name: COLUMN account_asset.prorata_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.prorata_date IS 'Prorata Date';


--
-- Name: COLUMN account_asset.acquisition_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.acquisition_date IS 'Acquisition Date';


--
-- Name: COLUMN account_asset.disposal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.disposal_date IS 'Disposal Date';


--
-- Name: COLUMN account_asset.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.analytic_distribution IS 'Analytic';


--
-- Name: COLUMN account_asset.original_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.original_value IS 'Original Value';


--
-- Name: COLUMN account_asset.book_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.book_value IS 'Book Value';


--
-- Name: COLUMN account_asset.salvage_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.salvage_value IS 'Not Depreciable Value';


--
-- Name: COLUMN account_asset.non_deductible_tax_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.non_deductible_tax_value IS 'Non Deductible Tax Value';


--
-- Name: COLUMN account_asset.already_depreciated_amount_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.already_depreciated_amount_import IS 'Already Depreciated Amount Import';


--
-- Name: COLUMN account_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.active IS 'Active';


--
-- Name: COLUMN account_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.create_date IS 'Created on';


--
-- Name: COLUMN account_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_asset.method_progress_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_progress_factor IS 'Declining Factor';


--
-- Name: COLUMN account_asset.asset_paused_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_paused_days IS 'Asset Paused Days';


--
-- Name: account_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_asset_id_seq OWNER TO runbot;

--
-- Name: account_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_asset_id_seq OWNED BY public.account_asset.id;


--
-- Name: account_automatic_entry_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    account_type character varying,
    date date NOT NULL,
    total_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage double precision
);


ALTER TABLE public.account_automatic_entry_wizard OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard IS 'Create Automatic Entries';


--
-- Name: COLUMN account_automatic_entry_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_automatic_entry_wizard.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.destination_account_id IS 'To';


--
-- Name: COLUMN account_automatic_entry_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_entry_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_automatic_entry_wizard.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.action IS 'Action';


--
-- Name: COLUMN account_automatic_entry_wizard.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_automatic_entry_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.date IS 'Date';


--
-- Name: COLUMN account_automatic_entry_wizard.total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.total_amount IS 'Total Amount';


--
-- Name: COLUMN account_automatic_entry_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_entry_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_automatic_entry_wizard.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.percentage IS 'Percentage';


--
-- Name: account_automatic_entry_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard_account_move_line_rel (
    account_automatic_entry_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_automatic_entry_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard_account_move_line_rel IS 'RELATION BETWEEN account_automatic_entry_wizard AND account_move_line';


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_automatic_entry_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNER TO runbot;

--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNED BY public.account_automatic_entry_wizard.id;


--
-- Name: account_balance_import_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_balance_import_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    counterpart_account_id integer,
    account_opening_entries_journal_id integer,
    partner_balance_journal_id integer,
    check_journal_bank_id integer,
    check_journal_third_id integer,
    create_uid integer,
    write_uid integer,
    mode character varying NOT NULL,
    partner_balance_type character varying,
    check_type character varying,
    accounting_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_balance_import_wizard OWNER TO runbot;

--
-- Name: TABLE account_balance_import_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_balance_import_wizard IS 'Account Initial Balance Wizard';


--
-- Name: COLUMN account_balance_import_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.company_id IS 'Compañía';


--
-- Name: COLUMN account_balance_import_wizard.counterpart_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.counterpart_account_id IS 'Cuenta de Contrapartida';


--
-- Name: COLUMN account_balance_import_wizard.account_opening_entries_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.account_opening_entries_journal_id IS 'Diario de Asientos de Apertura';


--
-- Name: COLUMN account_balance_import_wizard.partner_balance_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.partner_balance_journal_id IS 'Diario';


--
-- Name: COLUMN account_balance_import_wizard.check_journal_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.check_journal_bank_id IS 'Diario de Banco';


--
-- Name: COLUMN account_balance_import_wizard.check_journal_third_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.check_journal_third_id IS 'Diario de Cheques de Terceros';


--
-- Name: COLUMN account_balance_import_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_balance_import_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_balance_import_wizard.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.mode IS 'Modo de Importación';


--
-- Name: COLUMN account_balance_import_wizard.partner_balance_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.partner_balance_type IS 'Tipo de Saldo';


--
-- Name: COLUMN account_balance_import_wizard.check_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.check_type IS 'Tipo de Cheques';


--
-- Name: COLUMN account_balance_import_wizard.accounting_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.accounting_date IS 'Fecha Contable';


--
-- Name: COLUMN account_balance_import_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_balance_import_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.write_date IS 'Last Updated on';


--
-- Name: account_balance_import_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_balance_import_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_balance_import_wizard_id_seq OWNER TO runbot;

--
-- Name: account_balance_import_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_balance_import_wizard_id_seq OWNED BY public.account_balance_import_wizard.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    company_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    reference character varying,
    first_line_index character varying,
    date date,
    balance_start numeric,
    balance_end numeric,
    balance_end_real numeric,
    is_complete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_statement OWNER TO runbot;

--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.first_line_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.first_line_index IS 'First Line Index';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.is_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_complete IS 'Is Complete';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_ir_attachment_rel (
    account_bank_statement_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_bank_statement_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_ir_attachment_rel IS 'RELATION BETWEEN account_bank_statement AND ir_attachment';


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    statement_id integer,
    sequence integer,
    partner_id integer,
    currency_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    account_number character varying,
    partner_name character varying,
    transaction_type character varying,
    payment_ref character varying,
    internal_index character varying,
    amount numeric,
    amount_currency numeric,
    is_reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount_residual double precision,
    cron_last_check timestamp without time zone,
    unique_import_id character varying,
    online_account_id integer,
    online_link_id integer,
    online_transaction_identifier character varying,
    online_partner_information character varying,
    raw_data text,
    pos_session_id integer
);


ALTER TABLE public.account_bank_statement_line OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Journal Currency';


--
-- Name: COLUMN account_bank_statement_line.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.payment_ref IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.internal_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.internal_index IS 'Internal Reference';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_bank_statement_line.cron_last_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.cron_last_check IS 'Cron Last Check';


--
-- Name: COLUMN account_bank_statement_line.unique_import_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.unique_import_id IS 'Import ID';


--
-- Name: COLUMN account_bank_statement_line.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_account_id IS 'Online Account';


--
-- Name: COLUMN account_bank_statement_line.online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_statement_line.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line.online_partner_information; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_partner_information IS 'Online Partner Information';


--
-- Name: COLUMN account_bank_statement_line.raw_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.raw_data IS 'Raw Data';


--
-- Name: COLUMN account_bank_statement_line.pos_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.pos_session_id IS 'Session';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_batch_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard (
    id integer NOT NULL,
    batch_payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_remove_options boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard IS 'Batch payments error reporting wizard';


--
-- Name: COLUMN account_batch_error_wizard.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_batch_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard.show_remove_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.show_remove_options IS 'Show Remove Options';


--
-- Name: COLUMN account_batch_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNED BY public.account_batch_error_wizard.id;


--
-- Name: account_batch_error_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line (
    id integer NOT NULL,
    error_wizard_id integer,
    warning_wizard_id integer,
    create_uid integer,
    write_uid integer,
    description character varying NOT NULL,
    help_message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line IS 'Batch payments error reporting wizard line';


--
-- Name: COLUMN account_batch_error_wizard_line.error_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.error_wizard_id IS 'Error Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.warning_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.warning_wizard_id IS 'Warning Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.description IS 'Description';


--
-- Name: COLUMN account_batch_error_wizard_line.help_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.help_message IS 'Help';


--
-- Name: COLUMN account_batch_error_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_line_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line_account_payment_rel (
    account_batch_error_wizard_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_error_wizard_line_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line_account_payment_rel IS 'RELATION BETWEEN account_batch_error_wizard_line AND account_payment';


--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNED BY public.account_batch_error_wizard_line.id;


--
-- Name: account_batch_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    journal_id integer NOT NULL,
    currency_id integer,
    company_currency_id integer,
    payment_method_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    batch_type character varying NOT NULL,
    export_filename character varying,
    date date NOT NULL,
    export_file_create_date date,
    amount_residual numeric,
    amount_residual_currency numeric,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    direct_debit_collection_date date,
    periodo character varying
);


ALTER TABLE public.account_batch_payment OWNER TO runbot;

--
-- Name: TABLE account_batch_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment IS 'Batch Payment';


--
-- Name: COLUMN account_batch_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_batch_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.journal_id IS 'Bank';


--
-- Name: COLUMN account_batch_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_batch_payment.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_batch_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_batch_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.name IS 'Reference';


--
-- Name: COLUMN account_batch_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.state IS 'State';


--
-- Name: COLUMN account_batch_payment.batch_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.batch_type IS 'Batch Type';


--
-- Name: COLUMN account_batch_payment.export_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_filename IS 'File Name';


--
-- Name: COLUMN account_batch_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.date IS 'Date';


--
-- Name: COLUMN account_batch_payment.export_file_create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_file_create_date IS 'Generation Date';


--
-- Name: COLUMN account_batch_payment.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual IS 'Amount Residual';


--
-- Name: COLUMN account_batch_payment.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual_currency IS 'Amount Residual Currency';


--
-- Name: COLUMN account_batch_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount IS 'Amount';


--
-- Name: COLUMN account_batch_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_batch_payment.direct_debit_collection_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.direct_debit_collection_date IS 'Collection date';


--
-- Name: COLUMN account_batch_payment.periodo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.periodo IS 'Periodo';


--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_id_seq OWNER TO runbot;

--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_payment_id_seq OWNED BY public.account_batch_payment.id;


--
-- Name: account_batch_payment_rejection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment_rejection (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    cancel_action_todo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_payment_rejection OWNER TO runbot;

--
-- Name: TABLE account_batch_payment_rejection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment_rejection IS 'Manage the payment rejection from batch payments';


--
-- Name: COLUMN account_batch_payment_rejection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment_rejection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment_rejection.cancel_action_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.cancel_action_todo IS 'Cancel Action Todo';


--
-- Name: COLUMN account_batch_payment_rejection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment_rejection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.write_date IS 'Last Updated on';


--
-- Name: account_batch_payment_rejection_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment_rejection_account_payment_rel (
    account_batch_payment_rejection_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_payment_rejection_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_batch_payment_rejection_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment_rejection_account_payment_rel IS 'RELATION BETWEEN account_batch_payment_rejection AND account_payment';


--
-- Name: account_batch_payment_rejection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_payment_rejection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_rejection_id_seq OWNER TO runbot;

--
-- Name: account_batch_payment_rejection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_payment_rejection_id_seq OWNED BY public.account_batch_payment_rejection.id;


--
-- Name: account_card; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_card (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payway_method character varying
);


ALTER TABLE public.account_card OWNER TO runbot;

--
-- Name: TABLE account_card; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_card IS 'Credit Card';


--
-- Name: COLUMN account_card.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.company_id IS 'company';


--
-- Name: COLUMN account_card.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.create_uid IS 'Created by';


--
-- Name: COLUMN account_card.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_card.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.name IS 'name';


--
-- Name: COLUMN account_card.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.active IS 'Active';


--
-- Name: COLUMN account_card.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.create_date IS 'Created on';


--
-- Name: COLUMN account_card.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_card.payway_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.payway_method IS 'payway';


--
-- Name: account_card_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_card_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_card_id_seq OWNER TO runbot;

--
-- Name: account_card_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_card_id_seq OWNED BY public.account_card.id;


--
-- Name: account_card_installment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_card_installment (
    id integer NOT NULL,
    card_id integer NOT NULL,
    divisor integer,
    installment integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    surcharge_coefficient numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    bank_discount double precision,
    message character varying,
    is_published boolean
);


ALTER TABLE public.account_card_installment OWNER TO runbot;

--
-- Name: TABLE account_card_installment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_card_installment IS 'amount to add for collection in installments';


--
-- Name: COLUMN account_card_installment.card_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.card_id IS 'Card';


--
-- Name: COLUMN account_card_installment.divisor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.divisor IS 'Divisor';


--
-- Name: COLUMN account_card_installment.installment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.installment IS 'installment plan';


--
-- Name: COLUMN account_card_installment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.create_uid IS 'Created by';


--
-- Name: COLUMN account_card_installment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_card_installment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.name IS 'Fantasy name';


--
-- Name: COLUMN account_card_installment.surcharge_coefficient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.surcharge_coefficient IS 'coefficient';


--
-- Name: COLUMN account_card_installment.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.active IS 'Active';


--
-- Name: COLUMN account_card_installment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.create_date IS 'Created on';


--
-- Name: COLUMN account_card_installment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_card_installment.bank_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.bank_discount IS 'bank discount';


--
-- Name: COLUMN account_card_installment.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.message IS 'Mensaje';


--
-- Name: COLUMN account_card_installment.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.is_published IS 'Is Published';


--
-- Name: account_card_installment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_card_installment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_card_installment_id_seq OWNER TO runbot;

--
-- Name: account_card_installment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_card_installment_id_seq OWNED BY public.account_card_installment.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    strategy character varying NOT NULL,
    rounding_method character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rounding double precision NOT NULL
);


ALTER TABLE public.account_cash_rounding OWNER TO runbot;

--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cash_rounding_id_seq OWNER TO runbot;

--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_cashbox; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    allow_dates_edition boolean,
    restrict_users boolean,
    allow_concurrent_sessions boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_diff double precision
);


ALTER TABLE public.account_cashbox OWNER TO runbot;

--
-- Name: TABLE account_cashbox; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox IS 'Cashbox';


--
-- Name: COLUMN account_cashbox.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.company_id IS 'Company';


--
-- Name: COLUMN account_cashbox.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.sequence_id IS 'Sequence';


--
-- Name: COLUMN account_cashbox.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.name IS 'Name';


--
-- Name: COLUMN account_cashbox.allow_dates_edition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.allow_dates_edition IS 'Allow Dates Edition';


--
-- Name: COLUMN account_cashbox.restrict_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.restrict_users IS 'Restrict Users';


--
-- Name: COLUMN account_cashbox.allow_concurrent_sessions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.allow_concurrent_sessions IS 'Allow Concurrent Sessions';


--
-- Name: COLUMN account_cashbox.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cashbox.max_diff; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.max_diff IS 'Max Diff';


--
-- Name: account_cashbox_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_account_journal_rel (
    account_cashbox_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_cashbox_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_cashbox_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_account_journal_rel IS 'RELATION BETWEEN account_cashbox AND account_journal';


--
-- Name: account_cashbox_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_id_seq OWNED BY public.account_cashbox.id;


--
-- Name: account_cashbox_payment_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_payment_import (
    id integer NOT NULL,
    cashbox_session_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_cashbox_payment_import OWNER TO runbot;

--
-- Name: TABLE account_cashbox_payment_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_payment_import IS 'Import Payment into session';


--
-- Name: COLUMN account_cashbox_payment_import.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.cashbox_session_id IS 'Cashbox Session';


--
-- Name: COLUMN account_cashbox_payment_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_payment_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox_payment_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_payment_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.write_date IS 'Last Updated on';


--
-- Name: account_cashbox_payment_import_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_payment_import_account_payment_rel (
    account_cashbox_payment_import_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_cashbox_payment_import_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_cashbox_payment_import_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_payment_import_account_payment_rel IS 'RELATION BETWEEN account_cashbox_payment_import AND account_payment';


--
-- Name: account_cashbox_payment_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_payment_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_payment_import_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_payment_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_payment_import_id_seq OWNED BY public.account_cashbox_payment_import.id;


--
-- Name: account_cashbox_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_session (
    id integer NOT NULL,
    message_main_attachment_id integer,
    cashbox_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    opening_date timestamp without time zone,
    closing_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_cashbox_session OWNER TO runbot;

--
-- Name: TABLE account_cashbox_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_session IS 'Cashbox session';


--
-- Name: COLUMN account_cashbox_session.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_cashbox_session.cashbox_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.cashbox_id IS 'Cashbox';


--
-- Name: COLUMN account_cashbox_session.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.company_id IS 'Company';


--
-- Name: COLUMN account_cashbox_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox_session.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.name IS 'Name';


--
-- Name: COLUMN account_cashbox_session.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.state IS 'State';


--
-- Name: COLUMN account_cashbox_session.opening_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.opening_date IS 'Opening Date';


--
-- Name: COLUMN account_cashbox_session.closing_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.closing_date IS 'Closing Date';


--
-- Name: COLUMN account_cashbox_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.write_date IS 'Last Updated on';


--
-- Name: account_cashbox_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_session_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_session_id_seq OWNED BY public.account_cashbox_session.id;


--
-- Name: account_cashbox_session_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_session_line (
    id integer NOT NULL,
    cashbox_session_id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    balance_start numeric,
    balance_end_real numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_cashbox_session_line OWNER TO runbot;

--
-- Name: TABLE account_cashbox_session_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_session_line IS 'session journal';


--
-- Name: COLUMN account_cashbox_session_line.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.cashbox_session_id IS 'Session';


--
-- Name: COLUMN account_cashbox_session_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_cashbox_session_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_session_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox_session_line.balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.balance_start IS 'Balance Start';


--
-- Name: COLUMN account_cashbox_session_line.balance_end_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.balance_end_real IS 'Balance End Real';


--
-- Name: COLUMN account_cashbox_session_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_session_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.write_date IS 'Last Updated on';


--
-- Name: account_cashbox_session_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_session_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_session_line_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_session_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_session_line_id_seq OWNED BY public.account_cashbox_session_line.id;


--
-- Name: account_cashbox_session_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_session_res_users_rel (
    account_cashbox_session_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.account_cashbox_session_res_users_rel OWNER TO runbot;

--
-- Name: TABLE account_cashbox_session_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_session_res_users_rel IS 'RELATION BETWEEN account_cashbox_session AND res_users';


--
-- Name: account_cashbox_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_users_rel (
    cashbox_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.account_cashbox_users_rel OWNER TO runbot;

--
-- Name: TABLE account_cashbox_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_users_rel IS 'RELATION BETWEEN account_cashbox AND res_users';


--
-- Name: account_change_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_company (
    id integer NOT NULL,
    move_id integer,
    company_id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_company OWNER TO runbot;

--
-- Name: TABLE account_change_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_company IS 'Change Company';


--
-- Name: COLUMN account_change_company.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.move_id IS 'Move';


--
-- Name: COLUMN account_change_company.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.company_id IS 'Company';


--
-- Name: COLUMN account_change_company.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.journal_id IS 'Journal';


--
-- Name: COLUMN account_change_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_company.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.create_date IS 'Created on';


--
-- Name: COLUMN account_change_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.write_date IS 'Last Updated on';


--
-- Name: account_change_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_company_id_seq OWNER TO runbot;

--
-- Name: account_change_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_company_id_seq OWNED BY public.account_change_company.id;


--
-- Name: account_change_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_currency (
    id integer NOT NULL,
    currency_to_id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    change_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    currency_rate double precision NOT NULL,
    save_secondary_currency boolean
);


ALTER TABLE public.account_change_currency OWNER TO runbot;

--
-- Name: TABLE account_change_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_currency IS 'Change Currency';


--
-- Name: COLUMN account_change_currency.currency_to_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.currency_to_id IS 'Currency to';


--
-- Name: COLUMN account_change_currency.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.move_id IS 'Move';


--
-- Name: COLUMN account_change_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_currency.change_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.change_type IS 'Change Type';


--
-- Name: COLUMN account_change_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_date IS 'Created on';


--
-- Name: COLUMN account_change_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_change_currency.currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_change_currency.save_secondary_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.save_secondary_currency IS 'Save in secondary currency?';


--
-- Name: account_change_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_currency_id_seq OWNER TO runbot;

--
-- Name: account_change_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_currency_id_seq OWNED BY public.account_change_currency.id;


--
-- Name: account_change_lock_date; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_lock_date (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    period_lock_date date,
    fiscalyear_lock_date date,
    tax_lock_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    company_id integer NOT NULL
);


ALTER TABLE public.account_change_lock_date OWNER TO runbot;

--
-- Name: TABLE account_change_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_lock_date IS 'Change Lock Date';


--
-- Name: COLUMN account_change_lock_date.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_lock_date.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_lock_date.period_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.period_lock_date IS 'Journal Entries Lock Date';


--
-- Name: COLUMN account_change_lock_date.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.fiscalyear_lock_date IS 'All Users Lock Date';


--
-- Name: COLUMN account_change_lock_date.tax_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.tax_lock_date IS 'Tax Return Lock Date';


--
-- Name: COLUMN account_change_lock_date.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_date IS 'Created on';


--
-- Name: COLUMN account_change_lock_date.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_change_lock_date.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.company_id IS 'Company';


--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_lock_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_lock_date_id_seq OWNER TO runbot;

--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_lock_date_id_seq OWNED BY public.account_change_lock_date.id;


--
-- Name: account_chart_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_chart_template (
    id integer NOT NULL,
    parent_id integer,
    code_digits integer NOT NULL,
    currency_id integer NOT NULL,
    income_currency_exchange_account_id integer,
    expense_currency_exchange_account_id integer,
    country_id integer,
    account_journal_suspense_account_id integer,
    account_journal_payment_debit_account_id integer,
    account_journal_payment_credit_account_id integer,
    default_cash_difference_income_account_id integer,
    default_cash_difference_expense_account_id integer,
    default_pos_receivable_account_id integer,
    account_journal_early_pay_discount_loss_account_id integer,
    account_journal_early_pay_discount_gain_account_id integer,
    property_account_receivable_id integer,
    property_account_payable_id integer,
    property_account_expense_categ_id integer,
    property_account_income_categ_id integer,
    property_account_expense_id integer,
    property_account_income_id integer,
    property_stock_account_input_categ_id integer,
    property_stock_account_output_categ_id integer,
    property_stock_valuation_account_id integer,
    property_tax_payable_account_id integer,
    property_tax_receivable_account_id integer,
    property_advance_tax_payment_account_id integer,
    property_cash_basis_base_account_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bank_account_code_prefix character varying NOT NULL,
    cash_account_code_prefix character varying NOT NULL,
    transfer_account_code_prefix character varying NOT NULL,
    visible boolean,
    use_anglo_saxon boolean,
    use_storno_accounting boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_chart_template OWNER TO runbot;

--
-- Name: TABLE account_chart_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_chart_template IS 'Account Chart Template';


--
-- Name: COLUMN account_chart_template.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.parent_id IS 'Parent Chart Template';


--
-- Name: COLUMN account_chart_template.code_digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.code_digits IS '# of Digits';


--
-- Name: COLUMN account_chart_template.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.currency_id IS 'Currency';


--
-- Name: COLUMN account_chart_template.income_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.income_currency_exchange_account_id IS 'Gain Exchange Rate Account';


--
-- Name: COLUMN account_chart_template.expense_currency_exchange_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.expense_currency_exchange_account_id IS 'Loss Exchange Rate Account';


--
-- Name: COLUMN account_chart_template.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.country_id IS 'Country';


--
-- Name: COLUMN account_chart_template.account_journal_suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.account_journal_suspense_account_id IS 'Journal Suspense Account';


--
-- Name: COLUMN account_chart_template.account_journal_payment_debit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.account_journal_payment_debit_account_id IS 'Journal Outstanding Receipts Account';


--
-- Name: COLUMN account_chart_template.account_journal_payment_credit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.account_journal_payment_credit_account_id IS 'Journal Outstanding Payments Account';


--
-- Name: COLUMN account_chart_template.default_cash_difference_income_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.default_cash_difference_income_account_id IS 'Cash Difference Income Account';


--
-- Name: COLUMN account_chart_template.default_cash_difference_expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.default_cash_difference_expense_account_id IS 'Cash Difference Expense Account';


--
-- Name: COLUMN account_chart_template.default_pos_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.default_pos_receivable_account_id IS 'PoS receivable account';


--
-- Name: COLUMN account_chart_template.account_journal_early_pay_discount_loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.account_journal_early_pay_discount_loss_account_id IS 'Cash Discount Write-Off Loss Account';


--
-- Name: COLUMN account_chart_template.account_journal_early_pay_discount_gain_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.account_journal_early_pay_discount_gain_account_id IS 'Cash Discount Write-Off Gain Account';


--
-- Name: COLUMN account_chart_template.property_account_receivable_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_receivable_id IS 'Receivable Account';


--
-- Name: COLUMN account_chart_template.property_account_payable_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_payable_id IS 'Payable Account';


--
-- Name: COLUMN account_chart_template.property_account_expense_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_expense_categ_id IS 'Category of Expense Account';


--
-- Name: COLUMN account_chart_template.property_account_income_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_income_categ_id IS 'Category of Income Account';


--
-- Name: COLUMN account_chart_template.property_account_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_expense_id IS 'Expense Account on Product Template';


--
-- Name: COLUMN account_chart_template.property_account_income_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_account_income_id IS 'Income Account on Product Template';


--
-- Name: COLUMN account_chart_template.property_stock_account_input_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_stock_account_input_categ_id IS 'Input Account for Stock Valuation';


--
-- Name: COLUMN account_chart_template.property_stock_account_output_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_stock_account_output_categ_id IS 'Output Account for Stock Valuation';


--
-- Name: COLUMN account_chart_template.property_stock_valuation_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_stock_valuation_account_id IS 'Account Template for Stock Valuation';


--
-- Name: COLUMN account_chart_template.property_tax_payable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_tax_payable_account_id IS 'Tax current account (payable)';


--
-- Name: COLUMN account_chart_template.property_tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_tax_receivable_account_id IS 'Tax current account (receivable)';


--
-- Name: COLUMN account_chart_template.property_advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_advance_tax_payment_account_id IS 'Advance tax payment account';


--
-- Name: COLUMN account_chart_template.property_cash_basis_base_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.property_cash_basis_base_account_id IS 'Base Tax Received Account';


--
-- Name: COLUMN account_chart_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_chart_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_chart_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.name IS 'Name';


--
-- Name: COLUMN account_chart_template.bank_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.bank_account_code_prefix IS 'Prefix of the bank accounts';


--
-- Name: COLUMN account_chart_template.cash_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.cash_account_code_prefix IS 'Prefix of the main cash accounts';


--
-- Name: COLUMN account_chart_template.transfer_account_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.transfer_account_code_prefix IS 'Prefix of the main transfer accounts';


--
-- Name: COLUMN account_chart_template.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.visible IS 'Can be Visible?';


--
-- Name: COLUMN account_chart_template.use_anglo_saxon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.use_anglo_saxon IS 'Use Anglo-Saxon accounting';


--
-- Name: COLUMN account_chart_template.use_storno_accounting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.use_storno_accounting IS 'Use Storno accounting';


--
-- Name: COLUMN account_chart_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.create_date IS 'Created on';


--
-- Name: COLUMN account_chart_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_chart_template.write_date IS 'Last Updated on';


--
-- Name: account_chart_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_chart_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_chart_template_id_seq OWNER TO runbot;

--
-- Name: account_chart_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_chart_template_id_seq OWNED BY public.account_chart_template.id;


--
-- Name: account_check_action_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_action_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_action_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_action_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_action_wizard IS 'Account Check Action Wizard';


--
-- Name: COLUMN account_check_action_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_action_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_action_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.date IS 'Date';


--
-- Name: COLUMN account_check_action_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_action_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_action_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNED BY public.account_check_action_wizard.id;


--
-- Name: account_check_to_date_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_to_date_report_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_to_date_report_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_to_date_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_to_date_report_wizard IS 'account.check.to_date.report.wizard';


--
-- Name: COLUMN account_check_to_date_report_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.journal_id IS 'Diario';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_to_date_report_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.to_date IS 'Hasta Fecha';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_to_date_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNED BY public.account_check_to_date_report_wizard.id;


--
-- Name: account_commission_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_commission_rule (
    id integer NOT NULL,
    sequence integer NOT NULL,
    partner_id integer,
    customer_id integer,
    product_tmpl_id integer,
    categ_id integer,
    create_uid integer,
    write_uid integer,
    date_start date,
    date_end date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    min_amount double precision,
    percent_commission double precision,
    public_category_id integer
);


ALTER TABLE public.account_commission_rule OWNER TO runbot;

--
-- Name: TABLE account_commission_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_commission_rule IS 'Account Commission Rule';


--
-- Name: COLUMN account_commission_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.sequence IS 'Sequence';


--
-- Name: COLUMN account_commission_rule.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.partner_id IS 'Partner';


--
-- Name: COLUMN account_commission_rule.customer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.customer_id IS 'Customer';


--
-- Name: COLUMN account_commission_rule.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN account_commission_rule.categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.categ_id IS 'Product Category';


--
-- Name: COLUMN account_commission_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_commission_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_commission_rule.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.date_start IS 'Start Date';


--
-- Name: COLUMN account_commission_rule.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.date_end IS 'End Date';


--
-- Name: COLUMN account_commission_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_commission_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_commission_rule.min_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.min_amount IS 'Min Amount';


--
-- Name: COLUMN account_commission_rule.percent_commission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.percent_commission IS 'Percentage Commission';


--
-- Name: COLUMN account_commission_rule.public_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.public_category_id IS 'Website Category';


--
-- Name: account_commission_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_commission_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_commission_rule_id_seq OWNER TO runbot;

--
-- Name: account_commission_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_commission_rule_id_seq OWNED BY public.account_commission_rule.id;


--
-- Name: account_consolidation_inner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_consolidation_inner_rel (
    children_ids integer NOT NULL,
    parent_ids integer NOT NULL
);


ALTER TABLE public.account_consolidation_inner_rel OWNER TO runbot;

--
-- Name: TABLE account_consolidation_inner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_consolidation_inner_rel IS 'RELATION BETWEEN consolidation_chart AND consolidation_chart';


--
-- Name: account_debit_note; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_debit_note (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date NOT NULL,
    copy_lines boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_cl_edi_reference_doc_code character varying,
    l10n_cl_original_text character varying,
    l10n_cl_corrected_text character varying,
    l10n_pe_edi_charge_reason character varying
);


ALTER TABLE public.account_debit_note OWNER TO runbot;

--
-- Name: TABLE account_debit_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_debit_note IS 'Add Debit Note wizard';


--
-- Name: COLUMN account_debit_note.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.journal_id IS 'Use Specific Journal';


--
-- Name: COLUMN account_debit_note.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_uid IS 'Created by';


--
-- Name: COLUMN account_debit_note.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_debit_note.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.reason IS 'Reason';


--
-- Name: COLUMN account_debit_note.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.date IS 'Debit Note Date';


--
-- Name: COLUMN account_debit_note.copy_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.copy_lines IS 'Copy Lines';


--
-- Name: COLUMN account_debit_note.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_date IS 'Created on';


--
-- Name: COLUMN account_debit_note.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_debit_note.l10n_cl_edi_reference_doc_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.l10n_cl_edi_reference_doc_code IS 'SII Reference Code';


--
-- Name: COLUMN account_debit_note.l10n_cl_original_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.l10n_cl_original_text IS 'Original Text';


--
-- Name: COLUMN account_debit_note.l10n_cl_corrected_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.l10n_cl_corrected_text IS 'New Corrected Text';


--
-- Name: COLUMN account_debit_note.l10n_pe_edi_charge_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.l10n_pe_edi_charge_reason IS 'Debit Reason';


--
-- Name: account_debit_note_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_debit_note_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_debit_note_id_seq OWNER TO runbot;

--
-- Name: account_debit_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_debit_note_id_seq OWNED BY public.account_debit_note.id;


--
-- Name: account_debt_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_debt_report_wizard (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    result_selection character varying NOT NULL,
    from_date date,
    to_date date,
    show_invoice_detail boolean,
    historical_full boolean,
    company_currency boolean,
    secondary_currency boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_debt_report_wizard OWNER TO runbot;

--
-- Name: TABLE account_debt_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_debt_report_wizard IS 'Account Debt Report Wizard';


--
-- Name: COLUMN account_debt_report_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_debt_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_debt_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_debt_report_wizard.result_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.result_selection IS 'Account Type''s';


--
-- Name: COLUMN account_debt_report_wizard.from_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.from_date IS 'From';


--
-- Name: COLUMN account_debt_report_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.to_date IS 'To';


--
-- Name: COLUMN account_debt_report_wizard.show_invoice_detail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.show_invoice_detail IS 'Show Invoice Detail';


--
-- Name: COLUMN account_debt_report_wizard.historical_full; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.historical_full IS 'Historical Full';


--
-- Name: COLUMN account_debt_report_wizard.company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.company_currency IS 'Company Currency';


--
-- Name: COLUMN account_debt_report_wizard.secondary_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.secondary_currency IS 'Secondary Currency';


--
-- Name: COLUMN account_debt_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_debt_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.write_date IS 'Last Updated on';


--
-- Name: account_debt_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_debt_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_debt_report_wizard_id_seq OWNER TO runbot;

--
-- Name: account_debt_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_debt_report_wizard_id_seq OWNED BY public.account_debt_report_wizard.id;


--
-- Name: account_direct_debit_mandate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_direct_debit_mandate (
    id integer NOT NULL,
    message_main_attachment_id integer,
    partner_id integer NOT NULL,
    commercial_partner_id integer,
    company_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    description character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    partner_bank_id integer,
    credit_card_number character varying,
    partner_payer_id character varying,
    client_id character varying
);


ALTER TABLE public.account_direct_debit_mandate OWNER TO runbot;

--
-- Name: TABLE account_direct_debit_mandate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_direct_debit_mandate IS 'Direct Debit Mandates';


--
-- Name: COLUMN account_direct_debit_mandate.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_direct_debit_mandate.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.partner_id IS 'Customer';


--
-- Name: COLUMN account_direct_debit_mandate.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_direct_debit_mandate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.company_id IS 'Company';


--
-- Name: COLUMN account_direct_debit_mandate.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.journal_id IS 'Journal';


--
-- Name: COLUMN account_direct_debit_mandate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.create_uid IS 'Created by';


--
-- Name: COLUMN account_direct_debit_mandate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_direct_debit_mandate.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.state IS 'State';


--
-- Name: COLUMN account_direct_debit_mandate.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.description IS 'Description';


--
-- Name: COLUMN account_direct_debit_mandate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.create_date IS 'Created on';


--
-- Name: COLUMN account_direct_debit_mandate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_direct_debit_mandate.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.partner_bank_id IS 'CBU';


--
-- Name: COLUMN account_direct_debit_mandate.credit_card_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.credit_card_number IS 'Credit Card Number';


--
-- Name: COLUMN account_direct_debit_mandate.partner_payer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.partner_payer_id IS 'ID de Cliente';


--
-- Name: COLUMN account_direct_debit_mandate.client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.client_id IS 'Client ID';


--
-- Name: account_direct_debit_mandate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_direct_debit_mandate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_direct_debit_mandate_id_seq OWNER TO runbot;

--
-- Name: account_direct_debit_mandate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_direct_debit_mandate_id_seq OWNED BY public.account_direct_debit_mandate.id;


--
-- Name: account_edi_document; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_edi_document (
    id integer NOT NULL,
    move_id integer NOT NULL,
    edi_format_id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    blocking_level character varying,
    error text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_edi_document OWNER TO runbot;

--
-- Name: TABLE account_edi_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_edi_document IS 'Electronic Document for an account.move';


--
-- Name: COLUMN account_edi_document.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.move_id IS 'Move';


--
-- Name: COLUMN account_edi_document.edi_format_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.edi_format_id IS 'Edi Format';


--
-- Name: COLUMN account_edi_document.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.attachment_id IS 'Attachment';


--
-- Name: COLUMN account_edi_document.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.create_uid IS 'Created by';


--
-- Name: COLUMN account_edi_document.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_edi_document.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.state IS 'State';


--
-- Name: COLUMN account_edi_document.blocking_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.blocking_level IS 'Blocking Level';


--
-- Name: COLUMN account_edi_document.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.error IS 'Error';


--
-- Name: COLUMN account_edi_document.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.create_date IS 'Created on';


--
-- Name: COLUMN account_edi_document.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.write_date IS 'Last Updated on';


--
-- Name: account_edi_document_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_edi_document_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_edi_document_id_seq OWNER TO runbot;

--
-- Name: account_edi_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_edi_document_id_seq OWNED BY public.account_edi_document.id;


--
-- Name: account_edi_format; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_edi_format (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_edi_format OWNER TO runbot;

--
-- Name: TABLE account_edi_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_edi_format IS 'EDI format';


--
-- Name: COLUMN account_edi_format.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_edi_format.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_edi_format.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.name IS 'Name';


--
-- Name: COLUMN account_edi_format.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.code IS 'Code';


--
-- Name: COLUMN account_edi_format.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.create_date IS 'Created on';


--
-- Name: COLUMN account_edi_format.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.write_date IS 'Last Updated on';


--
-- Name: account_edi_format_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_edi_format_account_journal_rel (
    account_journal_id integer NOT NULL,
    account_edi_format_id integer NOT NULL
);


ALTER TABLE public.account_edi_format_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_edi_format_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_edi_format_account_journal_rel IS 'RELATION BETWEEN account_journal AND account_edi_format';


--
-- Name: account_edi_format_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_edi_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_edi_format_id_seq OWNER TO runbot;

--
-- Name: account_edi_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_edi_format_id_seq OWNED BY public.account_edi_format.id;


--
-- Name: account_exchange_diff_invoice; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_exchange_diff_invoice (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_exchange_diff_invoice OWNER TO runbot;

--
-- Name: TABLE account_exchange_diff_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_exchange_diff_invoice IS 'account.exchange_diff_invoice';


--
-- Name: COLUMN account_exchange_diff_invoice.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.company_id IS 'Company';


--
-- Name: COLUMN account_exchange_diff_invoice.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.create_uid IS 'Created by';


--
-- Name: COLUMN account_exchange_diff_invoice.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_exchange_diff_invoice.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.create_date IS 'Created on';


--
-- Name: COLUMN account_exchange_diff_invoice.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.write_date IS 'Last Updated on';


--
-- Name: account_exchange_diff_invoice_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_exchange_diff_invoice_account_move_rel (
    account_exchange_diff_invoice_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_exchange_diff_invoice_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_exchange_diff_invoice_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_exchange_diff_invoice_account_move_rel IS 'RELATION BETWEEN account_exchange_diff_invoice AND account_move';


--
-- Name: account_exchange_diff_invoice_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_exchange_diff_invoice_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_exchange_diff_invoice_id_seq OWNER TO runbot;

--
-- Name: account_exchange_diff_invoice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_exchange_diff_invoice_id_seq OWNED BY public.account_exchange_diff_invoice.id;


--
-- Name: account_exchange_diff_invoice_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_exchange_diff_invoice_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partial_line_id integer,
    create_uid integer,
    write_uid integer,
    debit_name character varying,
    credit_name character varying,
    debit_date date,
    credit_date date,
    credit_date_maturity date,
    reconciled_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    debit_rate double precision,
    credit_rate double precision
);


ALTER TABLE public.account_exchange_diff_invoice_line OWNER TO runbot;

--
-- Name: TABLE account_exchange_diff_invoice_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_exchange_diff_invoice_line IS 'account.exchange_diff_invoice.line';


--
-- Name: COLUMN account_exchange_diff_invoice_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_exchange_diff_invoice_line.partial_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.partial_line_id IS 'Partial Line';


--
-- Name: COLUMN account_exchange_diff_invoice_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_exchange_diff_invoice_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_exchange_diff_invoice_line.debit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.debit_name IS 'Debit Name';


--
-- Name: COLUMN account_exchange_diff_invoice_line.credit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.credit_name IS 'Credit Name';


--
-- Name: COLUMN account_exchange_diff_invoice_line.debit_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.debit_date IS 'Debit Date';


--
-- Name: COLUMN account_exchange_diff_invoice_line.credit_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.credit_date IS 'Credit Date';


--
-- Name: COLUMN account_exchange_diff_invoice_line.credit_date_maturity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.credit_date_maturity IS 'Due date';


--
-- Name: COLUMN account_exchange_diff_invoice_line.reconciled_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.reconciled_amount IS 'Importe';


--
-- Name: COLUMN account_exchange_diff_invoice_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.create_date IS 'Created on';


--
-- Name: COLUMN account_exchange_diff_invoice_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_exchange_diff_invoice_line.debit_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.debit_rate IS 'Debit Rate';


--
-- Name: COLUMN account_exchange_diff_invoice_line.credit_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.credit_rate IS 'Credit Rate';


--
-- Name: account_exchange_diff_invoice_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_exchange_diff_invoice_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_exchange_diff_invoice_line_id_seq OWNER TO runbot;

--
-- Name: account_exchange_diff_invoice_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_exchange_diff_invoice_line_id_seq OWNED BY public.account_exchange_diff_invoice_line.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_financial_year_op OWNER TO runbot;

--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_financial_year_op_id_seq OWNER TO runbot;

--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    country_id integer,
    country_group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    zip_from character varying,
    zip_to character varying,
    foreign_vat character varying,
    note jsonb,
    active boolean,
    auto_apply boolean,
    vat_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_taxcloud boolean,
    deduct_price_included_taxes boolean
);


ALTER TABLE public.account_fiscal_position OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.foreign_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.foreign_vat IS 'Foreign Tax ID';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position.is_taxcloud; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.is_taxcloud IS 'Use TaxCloud API';


--
-- Name: COLUMN account_fiscal_position.deduct_price_included_taxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.deduct_price_included_taxes IS 'Deduct Price-Included Taxes';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_account_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account_template (
    id integer NOT NULL,
    position_id integer NOT NULL,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account_template OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account_template IS 'Accounts Mapping Template of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account_template.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.position_id IS 'Fiscal Mapping';


--
-- Name: COLUMN account_fiscal_position_account_template.account_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.account_src_id IS 'Account Source';


--
-- Name: COLUMN account_fiscal_position_account_template.account_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.account_dest_id IS 'Account Destination';


--
-- Name: COLUMN account_fiscal_position_account_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account_template.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_account_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_template_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_account_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_account_template_id_seq OWNED BY public.account_fiscal_position_account_template.id;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_pos_config_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_pos_config_rel (
    pos_config_id integer NOT NULL,
    account_fiscal_position_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_pos_config_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_pos_config_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_pos_config_rel IS 'RELATION BETWEEN pos_config AND account_fiscal_position';


--
-- Name: account_fiscal_position_res_config_settings_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_res_config_settings_rel (
    res_config_settings_id integer NOT NULL,
    account_fiscal_position_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_config_settings_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_res_config_settings_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_res_config_settings_rel IS 'RELATION BETWEEN res_config_settings AND account_fiscal_position';


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_position_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_tax (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_tax OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_tax IS 'Tax Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_tax.tax_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_src_id IS 'Tax on Product';


--
-- Name: COLUMN account_fiscal_position_tax.tax_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_dest_id IS 'Tax to Apply';


--
-- Name: COLUMN account_fiscal_position_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNED BY public.account_fiscal_position_tax.id;


--
-- Name: account_fiscal_position_tax_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_tax_template (
    id integer NOT NULL,
    position_id integer NOT NULL,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_tax_template OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_tax_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_tax_template IS 'Tax Mapping Template of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax_template.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax_template.tax_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.tax_src_id IS 'Tax Source';


--
-- Name: COLUMN account_fiscal_position_tax_template.tax_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.tax_dest_id IS 'Replacement Tax';


--
-- Name: COLUMN account_fiscal_position_tax_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax_template.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_tax_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_tax_template_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_tax_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_tax_template_id_seq OWNED BY public.account_fiscal_position_tax_template.id;


--
-- Name: account_fiscal_position_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_template (
    id integer NOT NULL,
    sequence integer,
    chart_template_id integer NOT NULL,
    country_id integer,
    country_group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    zip_from character varying,
    zip_to character varying,
    note text,
    auto_apply boolean,
    vat_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_taxcloud boolean
);


ALTER TABLE public.account_fiscal_position_template OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_template IS 'Template for Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_fiscal_position_template.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position_template.country_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.name IS 'Fiscal Position Template';


--
-- Name: COLUMN account_fiscal_position_template.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position_template.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position_template.auto_apply; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position_template.vat_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position_template.is_taxcloud; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_template.is_taxcloud IS 'Use TaxCloud API';


--
-- Name: account_fiscal_position_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_template_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_template_id_seq OWNED BY public.account_fiscal_position_template.id;


--
-- Name: account_fiscal_position_template_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_template_res_country_state_rel (
    account_fiscal_position_template_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_template_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_template_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_template_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position_template AND res_country_state';


--
-- Name: account_fiscal_year; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_year (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_year OWNER TO runbot;

--
-- Name: TABLE account_fiscal_year; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_year IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscal_year.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_year.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_year.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_year.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.name IS 'Name';


--
-- Name: COLUMN account_fiscal_year.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_from IS 'Start Date';


--
-- Name: COLUMN account_fiscal_year.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_to IS 'End Date';


--
-- Name: COLUMN account_fiscal_year.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_year.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_year_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_year_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_year_id_seq OWNED BY public.account_fiscal_year.id;


--
-- Name: account_followup_followup_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_followup_line (
    id integer NOT NULL,
    delay integer NOT NULL,
    company_id integer NOT NULL,
    mail_template_id integer,
    sms_template_id integer,
    activity_type_id integer,
    create_uid integer,
    write_uid integer,
    activity_summary character varying,
    activity_default_responsible_type character varying NOT NULL,
    name jsonb NOT NULL,
    activity_note text,
    send_email boolean,
    join_invoices boolean,
    send_sms boolean,
    create_activity boolean,
    auto_execute boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    send_letter boolean
);


ALTER TABLE public.account_followup_followup_line OWNER TO runbot;

--
-- Name: TABLE account_followup_followup_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_followup_line IS 'Follow-up Criteria';


--
-- Name: COLUMN account_followup_followup_line.delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.delay IS 'Due Days';


--
-- Name: COLUMN account_followup_followup_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.company_id IS 'Company';


--
-- Name: COLUMN account_followup_followup_line.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.mail_template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_followup_line.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_followup_line.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN account_followup_followup_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_followup_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_followup_line.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_summary IS 'Summary';


--
-- Name: COLUMN account_followup_followup_line.activity_default_responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_default_responsible_type IS 'Responsible';


--
-- Name: COLUMN account_followup_followup_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.name IS 'Description';


--
-- Name: COLUMN account_followup_followup_line.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_note IS 'Note';


--
-- Name: COLUMN account_followup_followup_line.send_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_email IS 'Send Email';


--
-- Name: COLUMN account_followup_followup_line.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_followup_line.send_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_sms IS 'Send SMS Message';


--
-- Name: COLUMN account_followup_followup_line.create_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_activity IS 'Schedule Activity';


--
-- Name: COLUMN account_followup_followup_line.auto_execute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.auto_execute IS 'Automatic';


--
-- Name: COLUMN account_followup_followup_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_followup_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_followup_line.send_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_letter IS 'Send a Letter';


--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_followup_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNER TO runbot;

--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNED BY public.account_followup_followup_line.id;


--
-- Name: account_followup_manual_reminder; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder (
    id integer NOT NULL,
    template_id integer,
    partner_id integer,
    sms_template_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    sms_body character varying,
    body text,
    email boolean,
    email_add_signature boolean,
    sms boolean,
    print boolean,
    join_invoices boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    snailmail boolean
);


ALTER TABLE public.account_followup_manual_reminder OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder IS 'Wizard for sending manual reminders to clients';


--
-- Name: COLUMN account_followup_manual_reminder.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_manual_reminder.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.partner_id IS 'Partner';


--
-- Name: COLUMN account_followup_manual_reminder.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_manual_reminder.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_manual_reminder.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_manual_reminder.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.lang IS 'Language';


--
-- Name: COLUMN account_followup_manual_reminder.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.subject IS 'Subject';


--
-- Name: COLUMN account_followup_manual_reminder.sms_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_body IS 'Sms Body';


--
-- Name: COLUMN account_followup_manual_reminder.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.body IS 'Contents';


--
-- Name: COLUMN account_followup_manual_reminder.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.email IS 'Email';


--
-- Name: COLUMN account_followup_manual_reminder.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN account_followup_manual_reminder.sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms IS 'Sms';


--
-- Name: COLUMN account_followup_manual_reminder.print; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.print IS 'Print';


--
-- Name: COLUMN account_followup_manual_reminder.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_manual_reminder.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_manual_reminder.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_manual_reminder.snailmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.snailmail IS 'Snailmail';


--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_manual_reminder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNER TO runbot;

--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNED BY public.account_followup_manual_reminder.id;


--
-- Name: account_followup_manual_reminder_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder_ir_attachment_rel (
    account_followup_manual_reminder_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_followup_manual_reminder_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder_ir_attachment_rel IS 'RELATION BETWEEN account_followup_manual_reminder AND ir_attachment';


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    exchange_move_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_full_reconcile OWNER TO runbot;

--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.name IS 'Number';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_full_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name character varying NOT NULL,
    code_prefix_start character varying,
    code_prefix_end character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_group_check_length_prefix CHECK ((char_length((COALESCE(code_prefix_start, ''::character varying))::text) = char_length((COALESCE(code_prefix_end, ''::character varying))::text)))
);


ALTER TABLE public.account_group OWNER TO runbot;

--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.company_id IS 'Company';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.code_prefix_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group.code_prefix_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_group_check_length_prefix ON account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_group_check_length_prefix ON public.account_group IS 'CHECK(char_length(COALESCE(code_prefix_start, '''')) = char_length(COALESCE(code_prefix_end, '''')))';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_id_seq OWNER TO runbot;

--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_group_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_group_template (
    id integer NOT NULL,
    parent_id integer,
    chart_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code_prefix_start character varying,
    code_prefix_end character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_group_template OWNER TO runbot;

--
-- Name: TABLE account_group_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_group_template IS 'Template for Account Groups';


--
-- Name: COLUMN account_group_template.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.parent_id IS 'Parent';


--
-- Name: COLUMN account_group_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_group_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_group_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.name IS 'Name';


--
-- Name: COLUMN account_group_template.code_prefix_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group_template.code_prefix_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.create_date IS 'Created on';


--
-- Name: COLUMN account_group_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group_template.write_date IS 'Last Updated on';


--
-- Name: account_group_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_group_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_template_id_seq OWNER TO runbot;

--
-- Name: account_group_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_group_template_id_seq OWNED BY public.account_group_template.id;


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying(3) NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_incoterms OWNER TO runbot;

--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_incoterms_id_seq OWNER TO runbot;

--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_invoice_commission_inv_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_commission_inv_rel (
    commissioned_id integer NOT NULL,
    commission_id integer NOT NULL
);


ALTER TABLE public.account_invoice_commission_inv_rel OWNER TO runbot;

--
-- Name: TABLE account_invoice_commission_inv_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_commission_inv_rel IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: account_invoice_extract_words; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_extract_words (
    id integer NOT NULL,
    invoice_id integer NOT NULL,
    word_page integer,
    create_uid integer,
    write_uid integer,
    field character varying,
    word_text character varying,
    ocr_selected boolean,
    user_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "word_box_midX" double precision,
    "word_box_midY" double precision,
    word_box_width double precision,
    word_box_height double precision,
    word_box_angle double precision
);


ALTER TABLE public.account_invoice_extract_words OWNER TO runbot;

--
-- Name: TABLE account_invoice_extract_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_extract_words IS 'Extracted words from invoice scan';


--
-- Name: COLUMN account_invoice_extract_words.invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.invoice_id IS 'Invoice';


--
-- Name: COLUMN account_invoice_extract_words.word_page; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_page IS 'Word Page';


--
-- Name: COLUMN account_invoice_extract_words.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_extract_words.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_extract_words.field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.field IS 'Field';


--
-- Name: COLUMN account_invoice_extract_words.word_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_text IS 'Word Text';


--
-- Name: COLUMN account_invoice_extract_words.ocr_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.ocr_selected IS 'Ocr Selected';


--
-- Name: COLUMN account_invoice_extract_words.user_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.user_selected IS 'User Selected';


--
-- Name: COLUMN account_invoice_extract_words.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_extract_words.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midX"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midX" IS 'Word Box Midx';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midY"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midY" IS 'Word Box Midy';


--
-- Name: COLUMN account_invoice_extract_words.word_box_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_width IS 'Word Box Width';


--
-- Name: COLUMN account_invoice_extract_words.word_box_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_height IS 'Word Box Height';


--
-- Name: COLUMN account_invoice_extract_words.word_box_angle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_angle IS 'Word Box Angle';


--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_extract_words_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_extract_words_id_seq OWNER TO runbot;

--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_extract_words_id_seq OWNED BY public.account_invoice_extract_words.id;


--
-- Name: account_invoice_partial_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_partial_wizard (
    id integer NOT NULL,
    invoice_id integer,
    create_uid integer,
    write_uid integer,
    rounding_method character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage_to_invoice double precision NOT NULL,
    rounding double precision NOT NULL
);


ALTER TABLE public.account_invoice_partial_wizard OWNER TO runbot;

--
-- Name: TABLE account_invoice_partial_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_partial_wizard IS 'Account Invoice Partial Wizard';


--
-- Name: COLUMN account_invoice_partial_wizard.invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.invoice_id IS 'Invoice';


--
-- Name: COLUMN account_invoice_partial_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_partial_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_partial_wizard.rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_invoice_partial_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_partial_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_partial_wizard.percentage_to_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.percentage_to_invoice IS 'Percentage To Invoice';


--
-- Name: COLUMN account_invoice_partial_wizard.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.rounding IS 'Rounding Precision';


--
-- Name: account_invoice_partial_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_partial_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_partial_wizard_id_seq OWNER TO runbot;

--
-- Name: account_invoice_partial_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_partial_wizard_id_seq OWNED BY public.account_invoice_partial_wizard.id;


--
-- Name: account_invoice_prices_update_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_prices_update_wizard (
    id integer NOT NULL,
    pricelist_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_invoice_prices_update_wizard OWNER TO runbot;

--
-- Name: TABLE account_invoice_prices_update_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_prices_update_wizard IS 'account.invoice.prices_update.wizard';


--
-- Name: COLUMN account_invoice_prices_update_wizard.pricelist_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN account_invoice_prices_update_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_prices_update_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_prices_update_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_prices_update_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.write_date IS 'Last Updated on';


--
-- Name: account_invoice_prices_update_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_prices_update_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_prices_update_wizard_id_seq OWNER TO runbot;

--
-- Name: account_invoice_prices_update_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_prices_update_wizard_id_seq OWNED BY public.account_invoice_prices_update_wizard.id;


--
-- Name: account_invoice_send; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_send (
    id integer NOT NULL,
    composer_id integer NOT NULL,
    template_id integer,
    create_uid integer,
    write_uid integer,
    is_email boolean,
    is_print boolean,
    printed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    snailmail_is_letter boolean
);


ALTER TABLE public.account_invoice_send OWNER TO runbot;

--
-- Name: TABLE account_invoice_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_send IS 'Account Invoice Send';


--
-- Name: COLUMN account_invoice_send.composer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.composer_id IS 'Composer';


--
-- Name: COLUMN account_invoice_send.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.template_id IS 'Use template';


--
-- Name: COLUMN account_invoice_send.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_send.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_send.is_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.is_email IS 'Email';


--
-- Name: COLUMN account_invoice_send.is_print; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.is_print IS 'Print';


--
-- Name: COLUMN account_invoice_send.printed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.printed IS 'Is Printed';


--
-- Name: COLUMN account_invoice_send.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_send.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_send.snailmail_is_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_send.snailmail_is_letter IS 'Send by Post';


--
-- Name: account_invoice_send_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_send_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_send_id_seq OWNER TO runbot;

--
-- Name: account_invoice_send_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_send_id_seq OWNED BY public.account_invoice_send.id;


--
-- Name: account_invoice_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_tax (
    id integer NOT NULL,
    move_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_invoice_tax OWNER TO runbot;

--
-- Name: TABLE account_invoice_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_tax IS 'Account Invoice Tax';


--
-- Name: COLUMN account_invoice_tax.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.move_id IS 'Move';


--
-- Name: COLUMN account_invoice_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.write_date IS 'Last Updated on';


--
-- Name: account_invoice_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_tax_id_seq OWNER TO runbot;

--
-- Name: account_invoice_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_tax_id_seq OWNED BY public.account_invoice_tax.id;


--
-- Name: account_invoice_tax_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_tax_line (
    id integer NOT NULL,
    invoice_tax_id integer,
    tax_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_tax boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_invoice_tax_line OWNER TO runbot;

--
-- Name: TABLE account_invoice_tax_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_tax_line IS 'Account Invoice Tax line';


--
-- Name: COLUMN account_invoice_tax_line.invoice_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.invoice_tax_id IS 'Invoice Tax';


--
-- Name: COLUMN account_invoice_tax_line.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.tax_id IS 'Tax';


--
-- Name: COLUMN account_invoice_tax_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_tax_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_tax_line.new_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.new_tax IS 'New Tax';


--
-- Name: COLUMN account_invoice_tax_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_tax_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_tax_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.amount IS 'Amount';


--
-- Name: account_invoice_tax_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_tax_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_tax_line_id_seq OWNER TO runbot;

--
-- Name: account_invoice_tax_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_tax_line_id_seq OWNED BY public.account_invoice_tax_line.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_transaction_rel (
    invoice_id integer NOT NULL,
    transaction_id integer NOT NULL
);


ALTER TABLE public.account_invoice_transaction_rel OWNER TO runbot;

--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN account_move AND payment_transaction';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    message_main_attachment_id integer,
    default_account_id integer,
    suspense_account_id integer,
    sequence integer,
    currency_id integer,
    company_id integer NOT NULL,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    sale_activity_type_id integer,
    sale_activity_user_id integer,
    alias_id integer,
    secure_sequence_id integer,
    create_uid integer,
    write_uid integer,
    color integer,
    name character varying NOT NULL,
    code character varying(5) NOT NULL,
    type character varying NOT NULL,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    bank_statements_source character varying,
    sequence_override_regex text,
    sale_activity_note text,
    active boolean,
    restrict_mode_hash_table boolean,
    refund_sequence boolean,
    payment_sequence boolean,
    show_on_dashboard boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    check_sequence_id integer,
    check_manual_sequencing boolean,
    store_id integer,
    account_online_account_id integer,
    account_online_link_id integer,
    mail_template_id integer,
    l10n_latam_manual_checks boolean,
    l10n_latam_use_documents boolean,
    book_group_id integer,
    l10n_ar_afip_pos_number integer,
    l10n_ar_afip_pos_partner_id integer,
    l10n_ar_afip_pos_system character varying,
    nacha_immediate_destination character varying,
    nacha_destination character varying,
    nacha_immediate_origin character varying,
    nacha_company_identification character varying,
    nacha_origination_dfi_identification character varying,
    l10n_uy_type character varying,
    default_sheet_mapping_id integer,
    l10n_cl_point_of_sale_number integer,
    l10n_cl_point_of_sale_type character varying,
    l10n_cl_point_of_sale_name character varying,
    direct_debit_format character varying,
    settlement_partner_id integer,
    settlement_account_id integer,
    tax_settlement character varying,
    settlement_tax character varying,
    qr_code_label character varying,
    qr_code character varying,
    discriminate_taxes character varying NOT NULL,
    l10n_ar_is_pos boolean,
    direct_debit_merchant_number character varying,
    check_add_debit_button boolean
);


ALTER TABLE public.account_journal OWNER TO runbot;

--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_journal.default_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.default_account_id IS 'Default Account';


--
-- Name: COLUMN account_journal.suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.suspense_account_id IS 'Suspense Account';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.sale_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sale_activity_type_id IS 'Schedule Activity';


--
-- Name: COLUMN account_journal.sale_activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sale_activity_user_id IS 'Activity User';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Email Alias';


--
-- Name: COLUMN account_journal.secure_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.secure_sequence_id IS 'Secure Sequence';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.code IS 'Short Code';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.sequence_override_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence_override_regex IS 'Sequence Override Regex';


--
-- Name: COLUMN account_journal.sale_activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sale_activity_note IS 'Activity Summary';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Lock Posted Entries with Hash';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.payment_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.payment_sequence IS 'Dedicated Payment Sequence';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal.check_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_sequence_id IS 'Check Sequence';


--
-- Name: COLUMN account_journal.check_manual_sequencing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_manual_sequencing IS 'Manual Numbering';


--
-- Name: COLUMN account_journal.store_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.store_id IS 'Store';


--
-- Name: COLUMN account_journal.account_online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_journal.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_journal.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.mail_template_id IS 'Email Template';


--
-- Name: COLUMN account_journal.l10n_latam_manual_checks; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_latam_manual_checks IS 'Use electronic and deferred checks';


--
-- Name: COLUMN account_journal.l10n_latam_use_documents; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_latam_use_documents IS 'Use Documents?';


--
-- Name: COLUMN account_journal.book_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.book_group_id IS 'Book Group';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_number IS 'AFIP POS Number';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_partner_id IS 'AFIP POS Address';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_system; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_system IS 'AFIP POS System';


--
-- Name: COLUMN account_journal.nacha_immediate_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_destination IS 'Immediate Destination';


--
-- Name: COLUMN account_journal.nacha_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_destination IS 'Destination';


--
-- Name: COLUMN account_journal.nacha_immediate_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_origin IS 'Immediate Origin';


--
-- Name: COLUMN account_journal.nacha_company_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_company_identification IS 'Company Identification';


--
-- Name: COLUMN account_journal.nacha_origination_dfi_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_origination_dfi_identification IS 'Origination Dfi Identification';


--
-- Name: COLUMN account_journal.l10n_uy_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_uy_type IS 'Invoicing Type';


--
-- Name: COLUMN account_journal.default_sheet_mapping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.default_sheet_mapping_id IS 'Default Sheet Mapping';


--
-- Name: COLUMN account_journal.l10n_cl_point_of_sale_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_cl_point_of_sale_number IS 'Point Of Sale Number';


--
-- Name: COLUMN account_journal.l10n_cl_point_of_sale_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_cl_point_of_sale_type IS 'Point Of Sale Type';


--
-- Name: COLUMN account_journal.l10n_cl_point_of_sale_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_cl_point_of_sale_name IS 'Point Of Sale Name';


--
-- Name: COLUMN account_journal.direct_debit_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.direct_debit_format IS 'Direct Debit Format';


--
-- Name: COLUMN account_journal.settlement_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.settlement_partner_id IS 'Partner de liquidación';


--
-- Name: COLUMN account_journal.settlement_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.settlement_account_id IS 'Cuenta de contrapartida';


--
-- Name: COLUMN account_journal.tax_settlement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.tax_settlement IS 'Tax Settlement';


--
-- Name: COLUMN account_journal.settlement_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.settlement_tax IS 'Impuesto de liquidación';


--
-- Name: COLUMN account_journal.qr_code_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code_label IS 'QR Code Label';


--
-- Name: COLUMN account_journal.qr_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code IS 'QR Code';


--
-- Name: COLUMN account_journal.discriminate_taxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.discriminate_taxes IS 'Discriminate taxes?';


--
-- Name: COLUMN account_journal.l10n_ar_is_pos; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_is_pos IS 'Is AFIP POS?';


--
-- Name: COLUMN account_journal.direct_debit_merchant_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.direct_debit_merchant_number IS 'Número de comercio';


--
-- Name: COLUMN account_journal.check_add_debit_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_add_debit_button IS 'Agregar botón de débito';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_journal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_account_reconcile_model_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_reconcile_model_template_rel (
    account_reconcile_model_template_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_template_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_reconcile_model_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_template_rel IS 'RELATION BETWEEN account_reconcile_model_template AND account_journal';


--
-- Name: account_journal_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_tag (
    account_journal_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_tag OWNER TO runbot;

--
-- Name: TABLE account_journal_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_tag IS 'RELATION BETWEEN account_journal AND account_account_tag';


--
-- Name: account_journal_book_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_book_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_book_group OWNER TO runbot;

--
-- Name: TABLE account_journal_book_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_book_group IS 'Account Journal Book Group';


--
-- Name: COLUMN account_journal_book_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_book_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_book_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.name IS 'Name';


--
-- Name: COLUMN account_journal_book_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_book_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_book_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_book_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_book_group_id_seq OWNER TO runbot;

--
-- Name: account_journal_book_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_book_group_id_seq OWNED BY public.account_journal_book_group.id;


--
-- Name: account_journal_book_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_book_journal_rel (
    acc_journal_entries_id integer NOT NULL,
    journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_book_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_book_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_book_journal_rel IS 'RELATION BETWEEN account_journal_book_report AND account_journal';


--
-- Name: account_journal_book_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_book_report (
    id integer NOT NULL,
    company_id integer NOT NULL,
    last_entry_number integer NOT NULL,
    create_uid integer,
    write_uid integer,
    target_move character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_book_report OWNER TO runbot;

--
-- Name: TABLE account_journal_book_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_book_report IS 'Journal Book Report';


--
-- Name: COLUMN account_journal_book_report.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.company_id IS 'Company';


--
-- Name: COLUMN account_journal_book_report.last_entry_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.last_entry_number IS 'Último nº de asiento';


--
-- Name: COLUMN account_journal_book_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_book_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_book_report.target_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.target_move IS 'Target Moves';


--
-- Name: COLUMN account_journal_book_report.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_journal_book_report.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.date_to IS 'End Date';


--
-- Name: COLUMN account_journal_book_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_book_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.write_date IS 'Last Updated on';


--
-- Name: account_journal_book_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_book_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_book_report_id_seq OWNER TO runbot;

--
-- Name: account_journal_book_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_book_report_id_seq OWNED BY public.account_journal_book_report.id;


--
-- Name: account_journal_consolidation_company_period_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_consolidation_company_period_rel (
    consolidation_company_period_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_consolidation_company_period_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_consolidation_company_period_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_consolidation_company_period_rel IS 'RELATION BETWEEN consolidation_company_period AND account_journal';


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_group OWNER TO runbot;

--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Journal Group';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_group_id_seq OWNER TO runbot;

--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_id_seq OWNER TO runbot;

--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_journal_l10n_latam_document_type_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_l10n_latam_document_type_rel (
    account_journal_id integer NOT NULL,
    l10n_latam_document_type_id integer NOT NULL
);


ALTER TABLE public.account_journal_l10n_latam_document_type_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_l10n_latam_document_type_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_l10n_latam_document_type_rel IS 'RELATION BETWEEN account_journal AND l10n_latam_document_type';


--
-- Name: account_link_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_link_journal (
    id integer NOT NULL,
    number_added integer,
    create_uid integer,
    write_uid integer,
    sync_date date,
    transactions text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_link_journal OWNER TO runbot;

--
-- Name: TABLE account_link_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_link_journal IS 'Link list of bank accounts to journals';


--
-- Name: COLUMN account_link_journal.number_added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal.number_added IS 'Number Added';


--
-- Name: COLUMN account_link_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_link_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_link_journal.sync_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal.sync_date IS 'Get transactions since';


--
-- Name: COLUMN account_link_journal.transactions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal.transactions IS 'Transactions';


--
-- Name: COLUMN account_link_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_link_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal.write_date IS 'Last Updated on';


--
-- Name: account_link_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_link_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_link_journal_id_seq OWNER TO runbot;

--
-- Name: account_link_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_link_journal_id_seq OWNED BY public.account_link_journal.id;


--
-- Name: account_link_journal_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_link_journal_line (
    id integer NOT NULL,
    journal_id integer,
    currency_id integer,
    online_account_id integer,
    account_online_wizard_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_link_journal_line OWNER TO runbot;

--
-- Name: TABLE account_link_journal_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_link_journal_line IS 'Link one bank account to a journal';


--
-- Name: COLUMN account_link_journal_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_link_journal_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_link_journal_line.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal_line.online_account_id IS 'Online Account';


--
-- Name: COLUMN account_link_journal_line.account_online_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal_line.account_online_wizard_id IS 'Account Online Wizard';


--
-- Name: COLUMN account_link_journal_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_link_journal_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_link_journal_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal_line.create_date IS 'Created on';


--
-- Name: COLUMN account_link_journal_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_link_journal_line.write_date IS 'Last Updated on';


--
-- Name: account_link_journal_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_link_journal_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_link_journal_line_id_seq OWNER TO runbot;

--
-- Name: account_link_journal_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_link_journal_line_id_seq OWNED BY public.account_link_journal_line.id;


--
-- Name: account_method_line_card_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_method_line_card_rel (
    method_id integer NOT NULL,
    card_id integer NOT NULL
);


ALTER TABLE public.account_method_line_card_rel OWNER TO runbot;

--
-- Name: TABLE account_method_line_card_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_method_line_card_rel IS 'RELATION BETWEEN account_payment_method_line AND account_card';


--
-- Name: account_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_model_rel (
    account_transfer_model_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_model_rel OWNER TO runbot;

--
-- Name: TABLE account_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_model_rel IS 'RELATION BETWEEN account_transfer_model AND account_account';


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    sequence_number integer,
    message_main_attachment_id integer,
    journal_id integer NOT NULL,
    company_id integer,
    payment_id integer,
    statement_line_id integer,
    tax_cash_basis_rec_id integer,
    tax_cash_basis_origin_move_id integer,
    auto_post_origin_id integer,
    secure_sequence_number integer,
    invoice_payment_term_id integer,
    partner_id integer,
    commercial_partner_id integer,
    partner_shipping_id integer,
    partner_bank_id integer,
    fiscal_position_id integer,
    currency_id integer NOT NULL,
    reversed_entry_id integer,
    invoice_user_id integer,
    invoice_incoterm_id integer,
    invoice_cash_rounding_id integer,
    create_uid integer,
    write_uid integer,
    sequence_prefix character varying,
    access_token character varying,
    name character varying,
    ref character varying,
    state character varying NOT NULL,
    move_type character varying NOT NULL,
    auto_post character varying NOT NULL,
    inalterable_hash character varying,
    payment_reference character varying,
    qr_code_method character varying,
    payment_state character varying,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_origin character varying,
    date date NOT NULL,
    auto_post_until date,
    invoice_date date,
    invoice_date_due date,
    narration text,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_total_in_currency_signed numeric,
    amount_residual_signed numeric,
    quick_edit_total_amount numeric,
    is_storno boolean,
    always_tax_exigible boolean,
    to_check boolean,
    posted_before boolean,
    is_move_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_state_before_switch character varying,
    background_post boolean,
    preferred_payment_method_id integer,
    debit_origin_id integer,
    edi_state character varying,
    date_last_payment date,
    extract_status_code integer,
    extract_remote_id integer,
    extract_attachment_id integer,
    extract_state character varying NOT NULL,
    store_id integer,
    stock_move_id integer,
    transfer_model_id integer,
    payment_token_id integer,
    next_surcharge_date date,
    avoid_surcharge_invoice boolean,
    next_surcharge_percent double precision,
    tax_closing_end_date date,
    tax_report_control_error boolean,
    internal_notes text,
    l10n_latam_document_type_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    asset_id integer,
    asset_number_days integer,
    asset_depreciation_beginning_date date,
    depreciation_value numeric,
    asset_value_change boolean,
    move_currency_id integer,
    move_inverse_currency_rate numeric,
    suspense_statement_line_id integer,
    l10n_ar_afip_responsibility_type_id integer,
    l10n_ar_afip_service_start date,
    l10n_ar_afip_service_end date,
    l10n_ar_currency_rate double precision,
    l10n_es_reports_mod349_available boolean,
    l10n_es_reports_mod347_invoice_type character varying,
    l10n_es_reports_mod349_invoice_type character varying,
    l10n_uy_payment_type character varying,
    l10n_uy_currency_rate numeric,
    website_id integer,
    pay_now_journal_id integer,
    payment_group_id integer,
    l10n_ar_fce_transmission_type character varying,
    l10n_ar_afip_auth_mode character varying,
    l10n_ar_afip_auth_code character varying(24),
    l10n_ar_afip_result character varying,
    l10n_ar_afip_verification_result character varying,
    l10n_ar_afip_auth_code_due date,
    l10n_ar_afip_xml_request text,
    l10n_ar_afip_xml_response text,
    l10n_ar_afip_fce_is_cancellation boolean,
    l10n_cl_sii_send_file integer,
    l10n_cl_dte_file integer,
    l10n_cl_sii_barcode character varying,
    l10n_cl_dte_status character varying,
    l10n_cl_dte_partner_status character varying,
    l10n_cl_dte_acceptation_status character varying,
    l10n_cl_claim character varying,
    l10n_cl_claim_description character varying,
    l10n_cl_sii_send_ident text,
    l10n_pe_edi_cancel_cdr_number character varying,
    l10n_pe_edi_refund_reason character varying,
    l10n_pe_edi_charge_reason character varying,
    l10n_pe_edi_cancel_reason character varying,
    l10n_pe_edi_operation_type character varying,
    l10n_pe_edi_legend character varying,
    l10n_pe_edi_legend_value character varying,
    l10n_uy_cfe_file integer,
    l10n_uy_cfe_pdf integer,
    l10n_uy_cfe_state character varying,
    l10n_uy_ucfe_state character varying,
    l10n_uy_ucfe_notif character varying,
    l10n_uy_cfe_partner_status character varying,
    l10n_uy_cfe_uuid character varying,
    l10n_uy_cfe_sale_mod character varying,
    l10n_uy_cfe_transport_route character varying,
    l10n_uy_place_of_delivery character varying(100),
    l10n_uy_idreq character varying,
    l10n_uy_ucfe_msg text,
    l10n_uy_cfe_xml text,
    l10n_uy_dgi_xml_request text,
    l10n_uy_dgi_xml_response text,
    l10n_uy_dgi_barcode text,
    l10n_uy_additional_info text,
    sale_type_id integer,
    purchase_order_number character varying,
    direct_debit_mandate_id integer,
    l10n_cl_aec_file integer,
    l10n_pe_dua_invoice_id integer,
    l10n_pe_usage_type_id integer,
    l10n_pe_detraction_number character varying,
    l10n_pe_service_modality character varying,
    l10n_pe_detraction_date date,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date
);


ALTER TABLE public.account_move OWNER TO runbot;

--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move IS 'Journal Entry';


--
-- Name: COLUMN account_move.sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_id IS 'Payment';


--
-- Name: COLUMN account_move.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.statement_line_id IS 'Statement Line';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.tax_cash_basis_origin_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_origin_move_id IS 'Cash Basis Origin';


--
-- Name: COLUMN account_move.auto_post_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_origin_id IS 'First recurring entry';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalteralbility No Gap Sequence #';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN account_move.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_bank_id IS 'Recipient Bank';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.sequence_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.move_type IS 'Type';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Auto-post';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_move.qr_code_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.qr_code_method IS 'Payment QR-code';


--
-- Name: COLUMN account_move.payment_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state IS 'Payment Status';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.auto_post_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_until IS 'Auto-post until';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_total_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_in_currency_signed IS 'Total in Currency Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.quick_edit_total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.quick_edit_total_amount IS 'Total (Tax inc.)';


--
-- Name: COLUMN account_move.is_storno; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_storno IS 'Is Storno';


--
-- Name: COLUMN account_move.always_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.always_tax_exigible IS 'Always Tax Exigible';


--
-- Name: COLUMN account_move.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.to_check IS 'To Check';


--
-- Name: COLUMN account_move.posted_before; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.posted_before IS 'Posted Before';


--
-- Name: COLUMN account_move.is_move_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_move_sent IS 'Is Move Sent';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.payment_state_before_switch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state_before_switch IS 'Payment State Before Switch';


--
-- Name: COLUMN account_move.background_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.background_post IS 'Background Post';


--
-- Name: COLUMN account_move.debit_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.debit_origin_id IS 'Original Invoice Debited';


--
-- Name: COLUMN account_move.edi_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.edi_state IS 'Electronic invoicing';


--
-- Name: COLUMN account_move.date_last_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.date_last_payment IS 'Last Payment Date';


--
-- Name: COLUMN account_move.extract_status_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_status_code IS 'Status code';


--
-- Name: COLUMN account_move.extract_remote_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_remote_id IS 'Id of the request to IAP-OCR';


--
-- Name: COLUMN account_move.extract_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_attachment_id IS 'Extract Attachment';


--
-- Name: COLUMN account_move.extract_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_state IS 'Extract state';


--
-- Name: COLUMN account_move.store_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.store_id IS 'Store';


--
-- Name: COLUMN account_move.stock_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.stock_move_id IS 'Stock Move';


--
-- Name: COLUMN account_move.transfer_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.transfer_model_id IS 'Originating Model';


--
-- Name: COLUMN account_move.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_token_id IS 'automatic electonic payment';


--
-- Name: COLUMN account_move.next_surcharge_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.next_surcharge_date IS 'Next Surcharge Date';


--
-- Name: COLUMN account_move.avoid_surcharge_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.avoid_surcharge_invoice IS 'Avoid Surcharge Invoice';


--
-- Name: COLUMN account_move.next_surcharge_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.next_surcharge_percent IS 'Next Surcharge Percent';


--
-- Name: COLUMN account_move.tax_closing_end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_closing_end_date IS 'Tax Closing End Date';


--
-- Name: COLUMN account_move.tax_report_control_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_report_control_error IS 'Tax Report Control Error';


--
-- Name: COLUMN account_move.internal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.internal_notes IS 'Internal Notes';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: COLUMN account_move.asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_id IS 'Asset';


--
-- Name: COLUMN account_move.asset_number_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_number_days IS 'Number of days';


--
-- Name: COLUMN account_move.asset_depreciation_beginning_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_depreciation_beginning_date IS 'Date of the beginning of the depreciation';


--
-- Name: COLUMN account_move.depreciation_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.depreciation_value IS 'Depreciation';


--
-- Name: COLUMN account_move.asset_value_change; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_value_change IS 'Asset Value Change';


--
-- Name: COLUMN account_move.move_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.move_currency_id IS 'Secondary Currency';


--
-- Name: COLUMN account_move.move_inverse_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.move_inverse_currency_rate IS 'Account Move Secondary Currency Rate';


--
-- Name: COLUMN account_move.suspense_statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.suspense_statement_line_id IS 'Request document from a bank statement line';


--
-- Name: COLUMN account_move.l10n_ar_afip_responsibility_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_responsibility_type_id IS 'AFIP Responsibility Type';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_start IS 'AFIP Service Start Date';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_end IS 'AFIP Service End Date';


--
-- Name: COLUMN account_move.l10n_ar_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move.l10n_es_reports_mod347_invoice_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_es_reports_mod347_invoice_type IS 'Type for mod 347';


--
-- Name: COLUMN account_move.l10n_es_reports_mod349_invoice_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_es_reports_mod349_invoice_type IS 'Type for mod 349';


--
-- Name: COLUMN account_move.l10n_uy_payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_payment_type IS 'CFE Payment Type';


--
-- Name: COLUMN account_move.l10n_uy_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_currency_rate IS 'Currency Rate (UY)';


--
-- Name: COLUMN account_move.pay_now_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.pay_now_journal_id IS 'Pay now Journal';


--
-- Name: COLUMN account_move.payment_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_group_id IS 'Payment Group';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_mode IS 'AFIP Authorization Mode';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code IS 'Authorization Code';


--
-- Name: COLUMN account_move.l10n_ar_afip_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_result IS 'Result';


--
-- Name: COLUMN account_move.l10n_ar_afip_verification_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_verification_result IS 'AFIP Verification result';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code_due IS ' Authorization Due date';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_request IS 'AFIP XML Request';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_response IS 'AFIP XML Response';


--
-- Name: COLUMN account_move.l10n_ar_afip_fce_is_cancellation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_fce_is_cancellation IS 'FCE: Is Cancellation?';


--
-- Name: COLUMN account_move.l10n_cl_sii_send_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_sii_send_file IS 'SII Send file';


--
-- Name: COLUMN account_move.l10n_cl_dte_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_dte_file IS 'DTE file';


--
-- Name: COLUMN account_move.l10n_cl_sii_barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_sii_barcode IS 'SII Barcode';


--
-- Name: COLUMN account_move.l10n_cl_dte_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_dte_status IS 'SII DTE status';


--
-- Name: COLUMN account_move.l10n_cl_dte_partner_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_dte_partner_status IS 'Partner DTE status';


--
-- Name: COLUMN account_move.l10n_cl_dte_acceptation_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_dte_acceptation_status IS 'DTE Accept status';


--
-- Name: COLUMN account_move.l10n_cl_claim; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_claim IS 'Claim';


--
-- Name: COLUMN account_move.l10n_cl_claim_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_claim_description IS 'Claim Detail';


--
-- Name: COLUMN account_move.l10n_cl_sii_send_ident; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_sii_send_ident IS 'SII Send Identification(Track ID)';


--
-- Name: COLUMN account_move.l10n_pe_edi_cancel_cdr_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_cancel_cdr_number IS 'L10N Pe Edi Cancel Cdr Number';


--
-- Name: COLUMN account_move.l10n_pe_edi_refund_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_refund_reason IS 'Credit Reason';


--
-- Name: COLUMN account_move.l10n_pe_edi_charge_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_charge_reason IS 'Debit Reason';


--
-- Name: COLUMN account_move.l10n_pe_edi_cancel_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_cancel_reason IS 'Cancel Reason';


--
-- Name: COLUMN account_move.l10n_pe_edi_operation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_operation_type IS 'Operation Type (PE)';


--
-- Name: COLUMN account_move.l10n_pe_edi_legend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_legend IS 'Legend Code';


--
-- Name: COLUMN account_move.l10n_pe_edi_legend_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_legend_value IS 'Legend';


--
-- Name: COLUMN account_move.l10n_uy_cfe_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_cfe_file IS 'CFE XML file';


--
-- Name: COLUMN account_move.l10n_uy_cfe_pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_cfe_pdf IS 'CFE PDF Representation';


--
-- Name: COLUMN account_move.l10n_uy_cfe_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_cfe_state IS 'CFE Status';


--
-- Name: COLUMN account_move.l10n_uy_ucfe_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_ucfe_state IS 'UCFE State';


--
-- Name: COLUMN account_move.l10n_uy_ucfe_notif; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_ucfe_notif IS 'UCFE Tipo de Notificacion';


--
-- Name: COLUMN account_move.l10n_uy_cfe_partner_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_cfe_partner_status IS 'CFE Partner Status';


--
-- Name: COLUMN account_move.l10n_uy_cfe_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_cfe_uuid IS 'Clave o UUID del CFE';


--
-- Name: COLUMN account_move.l10n_uy_cfe_sale_mod; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_cfe_sale_mod IS 'Modalidad de Venta';


--
-- Name: COLUMN account_move.l10n_uy_cfe_transport_route; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_cfe_transport_route IS 'Vía de Transporte';


--
-- Name: COLUMN account_move.l10n_uy_place_of_delivery; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_place_of_delivery IS 'Lugar de entrega';


--
-- Name: COLUMN account_move.l10n_uy_idreq; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_idreq IS 'idReq';


--
-- Name: COLUMN account_move.l10n_uy_ucfe_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_ucfe_msg IS 'UCFE Mensaje de Respuesta';


--
-- Name: COLUMN account_move.l10n_uy_cfe_xml; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_cfe_xml IS 'XML CFE';


--
-- Name: COLUMN account_move.l10n_uy_dgi_xml_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_dgi_xml_request IS 'DGI XML Request';


--
-- Name: COLUMN account_move.l10n_uy_dgi_xml_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_dgi_xml_response IS 'DGI XML Response';


--
-- Name: COLUMN account_move.l10n_uy_dgi_barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_dgi_barcode IS 'DGI Barcode';


--
-- Name: COLUMN account_move.l10n_uy_additional_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_additional_info IS 'Info. adicional del comprobante';


--
-- Name: COLUMN account_move.sale_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sale_type_id IS 'Sale Type';


--
-- Name: COLUMN account_move.purchase_order_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.purchase_order_number IS 'Purchase Order Number';


--
-- Name: COLUMN account_move.direct_debit_mandate_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.direct_debit_mandate_id IS 'Direct Debit Mandate';


--
-- Name: COLUMN account_move.l10n_cl_aec_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_aec_file IS 'AEC File';


--
-- Name: COLUMN account_move.l10n_pe_dua_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_dua_invoice_id IS 'DUA Invoice';


--
-- Name: COLUMN account_move.l10n_pe_usage_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_usage_type_id IS 'Usage Type';


--
-- Name: COLUMN account_move.l10n_pe_detraction_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_detraction_number IS 'Detraction';


--
-- Name: COLUMN account_move.l10n_pe_service_modality; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_service_modality IS 'Service Modality';


--
-- Name: COLUMN account_move.l10n_pe_detraction_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_detraction_date IS 'Detraction Date';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_start IS 'Associated Period Start';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_end IS 'Associated Perdio End';


--
-- Name: account_move_account_invoice_send_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_invoice_send_rel (
    account_invoice_send_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_invoice_send_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_invoice_send_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_invoice_send_rel IS 'RELATION BETWEEN account_invoice_send AND account_move';


--
-- Name: account_move_account_resequence_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_resequence_wizard_rel (
    account_resequence_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_resequence_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_resequence_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_resequence_wizard_rel IS 'RELATION BETWEEN account_resequence_wizard AND account_move';


--
-- Name: account_move_afip_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_afip_activity_rel (
    account_move_id integer NOT NULL,
    afip_activity_id integer NOT NULL
);


ALTER TABLE public.account_move_afip_activity_rel OWNER TO runbot;

--
-- Name: TABLE account_move_afip_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_afip_activity_rel IS 'RELATION BETWEEN account_move AND afip_activity';


--
-- Name: account_move_asset_modify_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_asset_modify_rel OWNER TO runbot;

--
-- Name: TABLE account_move_asset_modify_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move';


--
-- Name: account_move_change_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_change_rate (
    id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    currency_rate numeric NOT NULL,
    day_rate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_change_rate OWNER TO runbot;

--
-- Name: TABLE account_move_change_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_change_rate IS 'account.move.change.rate';


--
-- Name: COLUMN account_move_change_rate.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.move_id IS 'Move';


--
-- Name: COLUMN account_move_change_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_change_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_change_rate.currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move_change_rate.day_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.day_rate IS 'Use currency rate of the day';


--
-- Name: COLUMN account_move_change_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_move_change_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_date IS 'Last Updated on';


--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_change_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_change_rate_id_seq OWNER TO runbot;

--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_change_rate_id_seq OWNED BY public.account_move_change_rate.id;


--
-- Name: account_move_debit_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_debit_move (
    debit_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_debit_move OWNER TO runbot;

--
-- Name: TABLE account_move_debit_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_debit_move IS 'RELATION BETWEEN account_debit_note AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_id_seq OWNER TO runbot;

--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_l10n_ar_boarding_permission_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_l10n_ar_boarding_permission_rel (
    account_move_id integer NOT NULL,
    l10n_ar_boarding_permission_id integer NOT NULL
);


ALTER TABLE public.account_move_l10n_ar_boarding_permission_rel OWNER TO runbot;

--
-- Name: TABLE account_move_l10n_ar_boarding_permission_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_l10n_ar_boarding_permission_rel IS 'RELATION BETWEEN account_move AND l10n_ar_boarding_permission';


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    sequence integer,
    account_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    group_tax_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_repartition_line_id integer,
    full_reconcile_id integer,
    account_root_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    move_name character varying,
    parent_state character varying,
    ref character varying,
    name character varying,
    tax_audit character varying,
    matching_number character varying,
    display_type character varying NOT NULL,
    date date,
    date_maturity date,
    discount_date date,
    analytic_distribution jsonb,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    tax_base_amount numeric,
    amount_residual numeric,
    amount_residual_currency numeric,
    quantity numeric,
    price_unit numeric,
    price_subtotal numeric,
    price_total numeric,
    discount numeric,
    discount_amount_currency numeric,
    discount_balance numeric,
    tax_tag_invert boolean,
    reconciled boolean,
    blocked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_percentage double precision,
    store_id integer,
    expense_id integer,
    purchase_line_id integer,
    expected_pay_date date,
    user_id integer,
    l10n_latam_document_type_id integer,
    purchase_subscription_id integer,
    is_downpayment boolean,
    followup_line_id integer,
    last_followup_date date,
    next_action_date date,
    l10n_pe_group_id integer,
    discount1 numeric,
    discount2 numeric,
    discount3 numeric,
    is_landed_costs_line boolean,
    l10n_pe_edi_allowance_charge_reason_code character varying,
    l10n_pe_edi_affectation_reason character varying,
    subscription_mrr numeric,
    subscription_id integer,
    subscription_start_date date,
    subscription_end_date date,
    tax_settlement_move_id integer,
    tax_state character varying,
    reward_id integer,
    price_taxcloud double precision,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (((balance <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR ((balance >= (0)::numeric) AND (amount_currency >= (0)::numeric))))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


ALTER TABLE public.account_move_line OWNER TO runbot;

--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Originator Statement Line';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.group_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.group_tax_id IS 'Originator Group of Taxes';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Distribution Line';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching';


--
-- Name: COLUMN account_move_line.account_root_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.account_root_id IS 'Account Root';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.tax_audit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_audit IS 'Tax Audit String';


--
-- Name: COLUMN account_move_line.matching_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.matching_number IS 'Matching #';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.discount_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_date IS 'Discount Date';


--
-- Name: COLUMN account_move_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.analytic_distribution IS 'Analytic';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.discount_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_amount_currency IS 'Discount amount in Currency';


--
-- Name: COLUMN account_move_line.discount_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_balance IS 'Discount Balance';


--
-- Name: COLUMN account_move_line.tax_tag_invert; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_tag_invert IS 'Invert Tags';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.blocked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.blocked IS 'No Follow-up';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.discount_percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_percentage IS 'Discount Percentage';


--
-- Name: COLUMN account_move_line.store_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.store_id IS 'Store';


--
-- Name: COLUMN account_move_line.expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.expense_id IS 'Expense';


--
-- Name: COLUMN account_move_line.purchase_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.purchase_line_id IS 'Purchase Order Line';


--
-- Name: COLUMN account_move_line.expected_pay_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.expected_pay_date IS 'Expected Date';


--
-- Name: COLUMN account_move_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.user_id IS 'Contact Salesperson';


--
-- Name: COLUMN account_move_line.purchase_subscription_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.purchase_subscription_id IS 'Purchase Subscription';


--
-- Name: COLUMN account_move_line.is_downpayment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_downpayment IS 'Is Downpayment';


--
-- Name: COLUMN account_move_line.followup_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.followup_line_id IS 'Follow-up Level';


--
-- Name: COLUMN account_move_line.last_followup_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.last_followup_date IS 'Latest Follow-up';


--
-- Name: COLUMN account_move_line.next_action_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.next_action_date IS 'Next Action Date';


--
-- Name: COLUMN account_move_line.discount1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount1 IS 'Discount 1 (%)';


--
-- Name: COLUMN account_move_line.discount2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount2 IS 'Discount 2 (%)';


--
-- Name: COLUMN account_move_line.discount3; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount3 IS 'Discount 3 (%)';


--
-- Name: COLUMN account_move_line.is_landed_costs_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_landed_costs_line IS 'Is Landed Costs Line';


--
-- Name: COLUMN account_move_line.l10n_pe_edi_allowance_charge_reason_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.l10n_pe_edi_allowance_charge_reason_code IS 'Allowance or Charge reason';


--
-- Name: COLUMN account_move_line.l10n_pe_edi_affectation_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.l10n_pe_edi_affectation_reason IS 'EDI Affect. Reason';


--
-- Name: COLUMN account_move_line.subscription_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.subscription_id IS 'Subscription';


--
-- Name: COLUMN account_move_line.subscription_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.subscription_start_date IS 'Subscription Revenue Start Date';


--
-- Name: COLUMN account_move_line.subscription_end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.subscription_end_date IS 'Subscription Revenue End Date';


--
-- Name: COLUMN account_move_line.tax_settlement_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_settlement_move_id IS 'Tax Settlement Move';


--
-- Name: COLUMN account_move_line.tax_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_state IS 'Tax State';


--
-- Name: COLUMN account_move_line.reward_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reward_id IS 'Discount reward';


--
-- Name: COLUMN account_move_line.price_taxcloud; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_taxcloud IS 'Taxcloud Price';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                display_type IN (''line_section'', ''line_note'')
                OR (
                    (balance <= 0 AND amount_currency <= 0)
                    OR
                    (balance >= 0 AND amount_currency >= 0)
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_account_tax_settlement_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_settlement_wizard_rel (
    account_tax_settlement_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_settlement_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_settlement_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_settlement_wizard_rel IS 'RELATION BETWEEN account_tax_settlement_wizard AND account_move_line';


--
-- Name: account_move_line_asset_modify_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_asset_modify_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_asset_modify_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move_line';


--
-- Name: account_move_line_consolidation_journal_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_consolidation_journal_line_rel (
    account_move_line_id integer NOT NULL,
    consolidation_journal_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_consolidation_journal_line_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_consolidation_journal_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_consolidation_journal_line_rel IS 'RELATION BETWEEN account_move_line AND consolidation_journal_line';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_line_id_seq OWNER TO runbot;

--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_line_l10n_us_1099_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_l10n_us_1099_wizard_rel (
    l10n_us_1099_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_l10n_us_1099_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_l10n_us_1099_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_l10n_us_1099_wizard_rel IS 'RELATION BETWEEN l10n_us_1099_wizard AND account_move_line';


--
-- Name: account_move_line_payment_group_to_pay_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_payment_group_to_pay_rel (
    payment_group_id integer NOT NULL,
    to_pay_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_payment_group_to_pay_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_payment_group_to_pay_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_payment_group_to_pay_rel IS 'RELATION BETWEEN account_payment_group AND account_move_line';


--
-- Name: account_move_purchase_order_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_purchase_order_rel (
    purchase_order_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_purchase_order_rel OWNER TO runbot;

--
-- Name: TABLE account_move_purchase_order_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_purchase_order_rel IS 'RELATION BETWEEN purchase_order AND account_move';


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_mode character varying NOT NULL,
    reason character varying,
    refund_method character varying NOT NULL,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_latam_document_type_id integer,
    l10n_latam_document_number character varying,
    l10n_cl_edi_reference_doc_code character varying,
    l10n_cl_original_text character varying,
    l10n_cl_corrected_text character varying,
    l10n_cl_is_text_correction boolean,
    l10n_pe_edi_refund_reason character varying
);


ALTER TABLE public.account_move_reversal OWNER TO runbot;

--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Use Specific Journal';


--
-- Name: COLUMN account_move_reversal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.company_id IS 'Company';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.date_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.date_mode IS 'Date Mode';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason';


--
-- Name: COLUMN account_move_reversal.refund_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.refund_method IS 'Credit Method';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_number IS 'Document Number';


--
-- Name: COLUMN account_move_reversal.l10n_cl_edi_reference_doc_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_cl_edi_reference_doc_code IS 'SII Reference Code';


--
-- Name: COLUMN account_move_reversal.l10n_cl_original_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_cl_original_text IS 'Original Text';


--
-- Name: COLUMN account_move_reversal.l10n_cl_corrected_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_cl_corrected_text IS 'New Corrected Text';


--
-- Name: COLUMN account_move_reversal.l10n_cl_is_text_correction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_cl_is_text_correction IS 'Only Text Correction';


--
-- Name: COLUMN account_move_reversal.l10n_pe_edi_refund_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_pe_edi_refund_reason IS 'Credit Reason';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_reversal_id_seq OWNER TO runbot;

--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_move_reversal_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_move (
    reversal_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_reversal_new_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_new_move (
    reversal_id integer NOT NULL,
    new_move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_new_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_new_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_new_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_stock_picking_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_stock_picking_rel (
    account_move_id integer NOT NULL,
    stock_picking_id integer NOT NULL
);


ALTER TABLE public.account_move_stock_picking_rel OWNER TO runbot;

--
-- Name: TABLE account_move_stock_picking_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_stock_picking_rel IS 'RELATION BETWEEN account_move AND stock_picking';


--
-- Name: account_move_validate_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_validate_account_move_rel (
    validate_account_move_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_validate_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_move_validate_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_validate_account_move_rel IS 'RELATION BETWEEN validate_account_move AND account_move';


--
-- Name: account_multicurrency_revaluation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_multicurrency_revaluation_wizard (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_multicurrency_revaluation_wizard OWNER TO runbot;

--
-- Name: TABLE account_multicurrency_revaluation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_multicurrency_revaluation_wizard IS 'Multicurrency Revaluation Wizard';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.date IS 'Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_date IS 'Last Updated on';


--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNER TO runbot;

--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNED BY public.account_multicurrency_revaluation_wizard.id;


--
-- Name: account_online_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_account (
    id integer NOT NULL,
    account_online_link_id integer,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    online_identifier character varying,
    account_number character varying,
    account_data character varying,
    last_sync date,
    inverse_balance_sign boolean,
    inverse_transaction_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    balance double precision,
    transactions_blacklist text
);


ALTER TABLE public.account_online_account OWNER TO runbot;

--
-- Name: TABLE account_online_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_account IS 'representation of an online bank account';


--
-- Name: COLUMN account_online_account.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_online_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.currency_id IS 'Currency';


--
-- Name: COLUMN account_online_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.name IS 'Account Name';


--
-- Name: COLUMN account_online_account.online_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.online_identifier IS 'Online Identifier';


--
-- Name: COLUMN account_online_account.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_number IS 'Account Number';


--
-- Name: COLUMN account_online_account.account_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_data IS 'Account Data';


--
-- Name: COLUMN account_online_account.last_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.last_sync IS 'Last synchronization';


--
-- Name: COLUMN account_online_account.inverse_balance_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_balance_sign IS 'Inverse Balance Sign';


--
-- Name: COLUMN account_online_account.inverse_transaction_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_transaction_sign IS 'Inverse Transaction Sign';


--
-- Name: COLUMN account_online_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_date IS 'Created on';


--
-- Name: COLUMN account_online_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_online_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.balance IS 'Balance';


--
-- Name: COLUMN account_online_account.transactions_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.transactions_blacklist IS 'Transactions Blacklist';


--
-- Name: account_online_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_account_id_seq OWNER TO runbot;

--
-- Name: account_online_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_account_id_seq OWNED BY public.account_online_account.id;


--
-- Name: account_online_link; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_link (
    id integer NOT NULL,
    message_main_attachment_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    client_id character varying,
    refresh_token character varying,
    access_token character varying,
    provider_data character varying,
    expiring_synchronization_date date,
    auto_sync boolean,
    last_refresh timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    provider_type character varying,
    paybook_username_hint character varying,
    status_code character varying,
    message character varying,
    provider_identifier character varying,
    paybook_max_date date,
    action_required boolean
);


ALTER TABLE public.account_online_link OWNER TO runbot;

--
-- Name: TABLE account_online_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_link IS 'Bank Connection';


--
-- Name: COLUMN account_online_link.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_online_link.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.company_id IS 'Company';


--
-- Name: COLUMN account_online_link.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_link.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_link.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.state IS 'State';


--
-- Name: COLUMN account_online_link.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.name IS 'Name';


--
-- Name: COLUMN account_online_link.client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.client_id IS 'Client';


--
-- Name: COLUMN account_online_link.refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.refresh_token IS 'Refresh Token';


--
-- Name: COLUMN account_online_link.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.access_token IS 'Access Token';


--
-- Name: COLUMN account_online_link.provider_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.provider_data IS 'Provider Data';


--
-- Name: COLUMN account_online_link.expiring_synchronization_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.expiring_synchronization_date IS 'Expiring Synchronization Date';


--
-- Name: COLUMN account_online_link.auto_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.auto_sync IS 'Automatic synchronization';


--
-- Name: COLUMN account_online_link.last_refresh; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.last_refresh IS 'Last Refresh';


--
-- Name: COLUMN account_online_link.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_date IS 'Created on';


--
-- Name: COLUMN account_online_link.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_online_link.provider_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.provider_type IS 'Proveedor';


--
-- Name: COLUMN account_online_link.paybook_username_hint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.paybook_username_hint IS 'Login/User';


--
-- Name: COLUMN account_online_link.status_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.status_code IS 'Status Code';


--
-- Name: COLUMN account_online_link.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.message IS 'Message';


--
-- Name: COLUMN account_online_link.provider_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.provider_identifier IS 'Provider Identifier';


--
-- Name: COLUMN account_online_link.paybook_max_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.paybook_max_date IS 'Fecha tope sincronización';


--
-- Name: COLUMN account_online_link.action_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.action_required IS 'Action Required';


--
-- Name: account_online_link_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_link_id_seq OWNER TO runbot;

--
-- Name: account_online_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_link_id_seq OWNED BY public.account_online_link.id;


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    full_reconcile_id integer,
    exchange_move_id integer,
    debit_currency_id integer,
    credit_currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    max_date date,
    amount numeric,
    debit_amount_currency numeric,
    credit_amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    exchange_diff_adjustment_required boolean,
    exchange_diff_invoice_id integer,
    exchange_diff_ignored boolean
);


ALTER TABLE public.account_partial_reconcile OWNER TO runbot;

--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_partial_reconcile.debit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_currency_id IS 'Currency of the debit journal item.';


--
-- Name: COLUMN account_partial_reconcile.credit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_currency_id IS 'Currency of the credit journal item.';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.debit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_amount_currency IS 'Debit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.credit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_amount_currency IS 'Credit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_partial_reconcile.exchange_diff_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_diff_invoice_id IS 'NC/ND de ajuste por dif de cambio';


--
-- Name: COLUMN account_partial_reconcile.exchange_diff_ignored; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_diff_ignored IS 'Exchange Diff Ignored';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    move_id integer NOT NULL,
    partner_bank_id integer,
    paired_internal_transfer_payment_id integer,
    payment_method_line_id integer,
    payment_method_id integer,
    currency_id integer,
    partner_id integer,
    outstanding_account_id integer,
    destination_account_id integer,
    destination_journal_id integer,
    create_uid integer,
    write_uid integer,
    payment_type character varying NOT NULL,
    partner_type character varying NOT NULL,
    payment_reference character varying,
    amount numeric,
    amount_company_currency_signed numeric,
    is_reconciled boolean,
    is_matched boolean,
    is_internal_transfer boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    batch_payment_id integer,
    check_number character varying,
    check_amount_in_words character varying,
    store_id integer,
    payment_transaction_id integer,
    payment_token_id integer,
    source_payment_id integer,
    tax_withholding_id integer,
    withholding_number character varying,
    withholding_base_amount numeric,
    l10n_latam_check_id integer,
    l10n_latam_check_current_journal_id integer,
    l10n_latam_check_bank_id integer,
    l10n_latam_check_issuer_vat character varying,
    l10n_latam_check_payment_date date,
    pos_payment_method_id integer,
    force_outstanding_account_id integer,
    pos_session_id integer,
    payment_group_id integer,
    force_amount_company_currency numeric,
    cashbox_session_id integer,
    direct_debit_mandate_id integer,
    counterpart_currency_id integer,
    counterpart_currency_amount numeric,
    card_id integer,
    installment_id integer,
    tiket_number character varying,
    lot_number character varying,
    automatic boolean,
    withholdable_invoiced_amount double precision,
    withholdable_advanced_amount double precision,
    accumulated_amount double precision,
    total_amount double precision,
    withholding_non_taxable_minimum double precision,
    withholding_non_taxable_amount double precision,
    withholdable_base_amount double precision,
    period_withholding_amount double precision,
    previous_withholding_amount double precision,
    computed_withholding_amount double precision,
    alicuota_mendoza double precision,
    sire_codigo_alicuota character varying(4),
    sire_aplica_cdi boolean,
    sire_aplica_acrecentamiento boolean,
    es_sire boolean,
    CONSTRAINT account_payment_check_amount_not_negative CHECK ((amount >= 0.0))
);


ALTER TABLE public.account_payment OWNER TO runbot;

--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_payment.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.paired_internal_transfer_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.paired_internal_transfer_payment_id IS 'Paired Internal Transfer Payment';


--
-- Name: COLUMN account_payment.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Method';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment.outstanding_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN account_payment.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_account_id IS 'Destination Account';


--
-- Name: COLUMN account_payment.destination_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.amount_company_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount_company_currency_signed IS 'Amount Company Currency Signed';


--
-- Name: COLUMN account_payment.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_payment.is_matched; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_matched IS 'Is Matched With a Bank Statement';


--
-- Name: COLUMN account_payment.is_internal_transfer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_internal_transfer IS 'Internal Transfer';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_payment.check_amount_in_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.check_amount_in_words IS 'Amount in Words';


--
-- Name: COLUMN account_payment.store_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.store_id IS 'Store';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved Payment Token';


--
-- Name: COLUMN account_payment.source_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.source_payment_id IS 'Source Payment';


--
-- Name: COLUMN account_payment.tax_withholding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.tax_withholding_id IS 'Withholding Tax';


--
-- Name: COLUMN account_payment.withholding_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholding_number IS 'Withholding Number';


--
-- Name: COLUMN account_payment.withholding_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholding_base_amount IS 'Withholding Base Amount';


--
-- Name: COLUMN account_payment.l10n_latam_check_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_latam_check_id IS 'Check';


--
-- Name: COLUMN account_payment.l10n_latam_check_current_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_latam_check_current_journal_id IS 'Check Current Journal';


--
-- Name: COLUMN account_payment.l10n_latam_check_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_latam_check_bank_id IS 'Check Bank';


--
-- Name: COLUMN account_payment.l10n_latam_check_issuer_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_latam_check_issuer_vat IS 'Check Issuer VAT';


--
-- Name: COLUMN account_payment.l10n_latam_check_payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_latam_check_payment_date IS 'Check Cash-In Date';


--
-- Name: COLUMN account_payment.pos_payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.pos_payment_method_id IS 'POS Payment Method';


--
-- Name: COLUMN account_payment.force_outstanding_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.force_outstanding_account_id IS 'Forced Outstanding Account';


--
-- Name: COLUMN account_payment.pos_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.pos_session_id IS 'POS Session';


--
-- Name: COLUMN account_payment.payment_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_group_id IS 'Payment Group';


--
-- Name: COLUMN account_payment.force_amount_company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.force_amount_company_currency IS 'Forced Amount on Company Currency';


--
-- Name: COLUMN account_payment.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.cashbox_session_id IS 'POP Session';


--
-- Name: COLUMN account_payment.direct_debit_mandate_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.direct_debit_mandate_id IS 'Direct Debit Mandate';


--
-- Name: COLUMN account_payment.counterpart_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_currency_id IS 'Counterpart Currency';


--
-- Name: COLUMN account_payment.counterpart_currency_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_currency_amount IS 'Counterpart Currency Amount';


--
-- Name: COLUMN account_payment.card_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.card_id IS 'Card';


--
-- Name: COLUMN account_payment.installment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.installment_id IS 'Installment plan';


--
-- Name: COLUMN account_payment.tiket_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.tiket_number IS 'Tiket number';


--
-- Name: COLUMN account_payment.lot_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.lot_number IS 'Lot number';


--
-- Name: COLUMN account_payment.automatic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.automatic IS 'Automatic';


--
-- Name: COLUMN account_payment.withholdable_invoiced_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholdable_invoiced_amount IS 'Importe imputado sujeto a retencion';


--
-- Name: COLUMN account_payment.withholdable_advanced_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholdable_advanced_amount IS 'Importe a cuenta sujeto a retencion';


--
-- Name: COLUMN account_payment.accumulated_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.accumulated_amount IS 'Accumulated Amount';


--
-- Name: COLUMN account_payment.total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.total_amount IS 'Total Payment Amount';


--
-- Name: COLUMN account_payment.withholding_non_taxable_minimum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholding_non_taxable_minimum IS 'Non-taxable Minimum';


--
-- Name: COLUMN account_payment.withholding_non_taxable_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholding_non_taxable_amount IS 'Non-taxable Amount';


--
-- Name: COLUMN account_payment.withholdable_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholdable_base_amount IS 'Withholdable Base Amount';


--
-- Name: COLUMN account_payment.period_withholding_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.period_withholding_amount IS 'Period Withholding Amount';


--
-- Name: COLUMN account_payment.previous_withholding_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.previous_withholding_amount IS 'Previous Withholding Amount';


--
-- Name: COLUMN account_payment.computed_withholding_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.computed_withholding_amount IS 'Computed Withholding Amount';


--
-- Name: COLUMN account_payment.alicuota_mendoza; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.alicuota_mendoza IS 'Alicuota Mendoza';


--
-- Name: COLUMN account_payment.sire_codigo_alicuota; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.sire_codigo_alicuota IS 'Sire Codigo Alicuota';


--
-- Name: COLUMN account_payment.sire_aplica_cdi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.sire_aplica_cdi IS 'Sire Aplica Cdi';


--
-- Name: COLUMN account_payment.sire_aplica_acrecentamiento; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.sire_aplica_acrecentamiento IS 'Sire Aplica Acrecentamiento';


--
-- Name: COLUMN account_payment.es_sire; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.es_sire IS 'Es Sire';


--
-- Name: CONSTRAINT account_payment_check_amount_not_negative ON account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_payment_check_amount_not_negative ON public.account_payment IS 'CHECK(amount >= 0.0)';


--
-- Name: account_payment_account_bank_statement_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_account_bank_statement_line_rel (
    account_bank_statement_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_bank_statement_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_account_bank_statement_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_account_bank_statement_line_rel IS 'RELATION BETWEEN account_bank_statement_line AND account_payment';


--
-- Name: account_payment_account_payment_add_checks_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_account_payment_add_checks_rel (
    account_payment_add_checks_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_payment_add_checks_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_account_payment_add_checks_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_account_payment_add_checks_rel IS 'RELATION BETWEEN account_payment_add_checks AND account_payment';


--
-- Name: account_payment_add_checks; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_add_checks (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_add_checks OWNER TO runbot;

--
-- Name: TABLE account_payment_add_checks; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_add_checks IS 'account.payment.add.checks';


--
-- Name: COLUMN account_payment_add_checks.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_add_checks.company_id IS 'Company';


--
-- Name: COLUMN account_payment_add_checks.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_add_checks.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_add_checks.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_add_checks.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_add_checks.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_add_checks.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_add_checks.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_add_checks.write_date IS 'Last Updated on';


--
-- Name: account_payment_add_checks_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_add_checks_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_add_checks_id_seq OWNER TO runbot;

--
-- Name: account_payment_add_checks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_add_checks_id_seq OWNED BY public.account_payment_add_checks.id;


--
-- Name: account_payment_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_group (
    id integer NOT NULL,
    message_main_attachment_id integer,
    receiptbook_id integer,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    partner_type character varying,
    communication character varying,
    state character varying,
    payment_date date NOT NULL,
    notes text,
    unreconciled_amount numeric,
    sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    withholdable_advanced_amount numeric,
    store_id integer,
    regimen_ganancias_id integer,
    retencion_ganancias character varying,
    alicuota_mendoza double precision
);


ALTER TABLE public.account_payment_group OWNER TO runbot;

--
-- Name: TABLE account_payment_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_group IS 'Payment Group';


--
-- Name: COLUMN account_payment_group.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment_group.receiptbook_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.receiptbook_id IS 'ReceiptBook';


--
-- Name: COLUMN account_payment_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.company_id IS 'Company';


--
-- Name: COLUMN account_payment_group.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.partner_id IS 'Partner';


--
-- Name: COLUMN account_payment_group.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.name IS 'Number';


--
-- Name: COLUMN account_payment_group.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_group.communication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.communication IS 'Memo';


--
-- Name: COLUMN account_payment_group.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.state IS 'Status';


--
-- Name: COLUMN account_payment_group.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_group.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.notes IS 'Notes';


--
-- Name: COLUMN account_payment_group.unreconciled_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.unreconciled_amount IS 'Adjustment / Advance';


--
-- Name: COLUMN account_payment_group.sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.sent IS 'Sent';


--
-- Name: COLUMN account_payment_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_group.withholdable_advanced_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.withholdable_advanced_amount IS 'Adjustment / Advance (untaxed)';


--
-- Name: COLUMN account_payment_group.store_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.store_id IS 'Store';


--
-- Name: COLUMN account_payment_group.regimen_ganancias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.regimen_ganancias_id IS 'Regimen Ganancias';


--
-- Name: COLUMN account_payment_group.retencion_ganancias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.retencion_ganancias IS 'Retención Ganancias';


--
-- Name: COLUMN account_payment_group.alicuota_mendoza; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group.alicuota_mendoza IS 'Alicuota Mendoza';


--
-- Name: account_payment_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_group_id_seq OWNER TO runbot;

--
-- Name: account_payment_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_group_id_seq OWNED BY public.account_payment_group.id;


--
-- Name: account_payment_group_invoice_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_group_invoice_wizard (
    id integer NOT NULL,
    payment_group_id integer NOT NULL,
    journal_id integer NOT NULL,
    product_id integer NOT NULL,
    journal_document_type_id integer,
    create_uid integer,
    write_uid integer,
    description character varying,
    document_number character varying,
    invoice_date date NOT NULL,
    date date,
    analytic_distribution jsonb,
    amount_total numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    origin_invoice_id integer,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date
);


ALTER TABLE public.account_payment_group_invoice_wizard OWNER TO runbot;

--
-- Name: TABLE account_payment_group_invoice_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_group_invoice_wizard IS 'account.payment.group.invoice.wizard';


--
-- Name: COLUMN account_payment_group_invoice_wizard.payment_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.payment_group_id IS 'Payment Group';


--
-- Name: COLUMN account_payment_group_invoice_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_group_invoice_wizard.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.product_id IS 'Product';


--
-- Name: COLUMN account_payment_group_invoice_wizard.journal_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.journal_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_payment_group_invoice_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_group_invoice_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_group_invoice_wizard.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.description IS 'Reason';


--
-- Name: COLUMN account_payment_group_invoice_wizard.document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.document_number IS 'Document Number';


--
-- Name: COLUMN account_payment_group_invoice_wizard.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.invoice_date IS 'Refund Date';


--
-- Name: COLUMN account_payment_group_invoice_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.date IS 'Accounting Date';


--
-- Name: COLUMN account_payment_group_invoice_wizard.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.analytic_distribution IS 'Analytic';


--
-- Name: COLUMN account_payment_group_invoice_wizard.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.amount_total IS 'Total Amount';


--
-- Name: COLUMN account_payment_group_invoice_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_group_invoice_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_group_invoice_wizard.origin_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.origin_invoice_id IS 'Origin Invoice';


--
-- Name: COLUMN account_payment_group_invoice_wizard.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.l10n_ar_afip_asoc_period_start IS 'Associate Period From';


--
-- Name: COLUMN account_payment_group_invoice_wizard.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_group_invoice_wizard.l10n_ar_afip_asoc_period_end IS 'Associate Period To';


--
-- Name: account_payment_group_invoice_wizard_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_group_invoice_wizard_account_tax_rel (
    account_payment_group_invoice_wizard_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_payment_group_invoice_wizard_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_group_invoice_wizard_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_group_invoice_wizard_account_tax_rel IS 'RELATION BETWEEN account_payment_group_invoice_wizard AND account_tax';


--
-- Name: account_payment_group_invoice_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_group_invoice_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_group_invoice_wizard_id_seq OWNER TO runbot;

--
-- Name: account_payment_group_invoice_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_group_invoice_wizard_id_seq OWNED BY public.account_payment_group_invoice_wizard.id;


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_id_seq OWNER TO runbot;

--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_l10n_latam_payment_mass_transfer_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_l10n_latam_payment_mass_transfer_rel (
    l10n_latam_payment_mass_transfer_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_l10n_latam_payment_mass_transfer_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_l10n_latam_payment_mass_transfer_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_l10n_latam_payment_mass_transfer_rel IS 'RELATION BETWEEN l10n_latam_payment_mass_transfer AND account_payment';


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_method OWNER TO runbot;

--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_method_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method_line (
    id integer NOT NULL,
    sequence integer,
    payment_method_id integer NOT NULL,
    payment_account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_provider_id integer
);


ALTER TABLE public.account_payment_method_line OWNER TO runbot;

--
-- Name: TABLE account_payment_method_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method_line IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_method_line.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_method_line.payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_account_id IS 'Payment Account';


--
-- Name: COLUMN account_payment_method_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_method_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.name IS 'Name';


--
-- Name: COLUMN account_payment_method_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_method_line.payment_provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_provider_id IS 'Payment Provider';


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_line_id_seq OWNED BY public.account_payment_method_line.id;


--
-- Name: account_payment_receiptbook; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_receiptbook (
    id integer NOT NULL,
    report_partner_id integer,
    mail_template_id integer,
    sequence integer,
    sequence_id integer,
    company_id integer NOT NULL,
    padding integer,
    document_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying(64) NOT NULL,
    partner_type character varying NOT NULL,
    sequence_type character varying,
    prefix character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_receiptbook OWNER TO runbot;

--
-- Name: TABLE account_payment_receiptbook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_receiptbook IS 'Account payment Receiptbook';


--
-- Name: COLUMN account_payment_receiptbook.report_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.report_partner_id IS 'Report Partner';


--
-- Name: COLUMN account_payment_receiptbook.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.mail_template_id IS 'Email Template';


--
-- Name: COLUMN account_payment_receiptbook.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_receiptbook.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.sequence_id IS 'Entry Sequence';


--
-- Name: COLUMN account_payment_receiptbook.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.company_id IS 'Company';


--
-- Name: COLUMN account_payment_receiptbook.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.padding IS 'Number Padding';


--
-- Name: COLUMN account_payment_receiptbook.document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.document_type_id IS 'Document Type';


--
-- Name: COLUMN account_payment_receiptbook.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_receiptbook.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_receiptbook.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.name IS 'Name';


--
-- Name: COLUMN account_payment_receiptbook.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_receiptbook.sequence_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.sequence_type IS 'Sequence Type';


--
-- Name: COLUMN account_payment_receiptbook.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.prefix IS 'Prefix';


--
-- Name: COLUMN account_payment_receiptbook.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.active IS 'Active';


--
-- Name: COLUMN account_payment_receiptbook.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_receiptbook.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.write_date IS 'Last Updated on';


--
-- Name: account_payment_receiptbook_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_receiptbook_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_receiptbook_id_seq OWNER TO runbot;

--
-- Name: account_payment_receiptbook_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_receiptbook_id_seq OWNED BY public.account_payment_receiptbook.id;


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    currency_id integer,
    journal_id integer,
    partner_bank_id integer,
    source_currency_id integer,
    company_id integer,
    partner_id integer,
    payment_method_line_id integer,
    writeoff_account_id integer,
    create_uid integer,
    write_uid integer,
    communication character varying,
    payment_type character varying,
    partner_type character varying,
    payment_difference_handling character varying,
    writeoff_label character varying,
    payment_date date NOT NULL,
    amount numeric,
    source_amount numeric,
    source_amount_currency numeric,
    group_payment boolean,
    can_edit_wizard boolean,
    can_group_payments boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_token_id integer,
    l10n_latam_check_id integer,
    l10n_latam_check_bank_id integer,
    l10n_latam_check_issuer_vat character varying,
    l10n_latam_check_number character varying,
    l10n_latam_check_payment_date date,
    cashbox_session_id integer
);


ALTER TABLE public.account_payment_register OWNER TO runbot;

--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register IS 'Register Payment';


--
-- Name: COLUMN account_payment_register.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment_register.source_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_currency_id IS 'Source Currency';


--
-- Name: COLUMN account_payment_register.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.company_id IS 'Company';


--
-- Name: COLUMN account_payment_register.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_register.writeoff_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.communication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.communication IS 'Memo';


--
-- Name: COLUMN account_payment_register.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_register.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_register.payment_difference_handling; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment_register.writeoff_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.amount IS 'Amount';


--
-- Name: COLUMN account_payment_register.source_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount IS 'Amount to Pay (company currency)';


--
-- Name: COLUMN account_payment_register.source_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount_currency IS 'Amount to Pay (foreign currency)';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payments';


--
-- Name: COLUMN account_payment_register.can_edit_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_edit_wizard IS 'Can Edit Wizard';


--
-- Name: COLUMN account_payment_register.can_group_payments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_group_payments IS 'Can Group Payments';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_register.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_token_id IS 'Saved payment token';


--
-- Name: COLUMN account_payment_register.l10n_latam_check_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.l10n_latam_check_id IS 'Check';


--
-- Name: COLUMN account_payment_register.l10n_latam_check_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.l10n_latam_check_bank_id IS 'Check Bank';


--
-- Name: COLUMN account_payment_register.l10n_latam_check_issuer_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.l10n_latam_check_issuer_vat IS 'Check Issuer VAT';


--
-- Name: COLUMN account_payment_register.l10n_latam_check_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.l10n_latam_check_number IS 'Check Number';


--
-- Name: COLUMN account_payment_register.l10n_latam_check_payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.l10n_latam_check_payment_date IS 'Check Cash-In Date';


--
-- Name: COLUMN account_payment_register.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.cashbox_session_id IS 'POP Session';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_register_id_seq OWNER TO runbot;

--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_register_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_move_line_rel (
    wizard_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_move_line_rel IS 'RELATION BETWEEN account_payment_register AND account_move_line';


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    company_id integer,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    display_on_invoice boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_cl_sii_code character varying
);


ALTER TABLE public.account_payment_term OWNER TO runbot;

--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.display_on_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.display_on_invoice IS 'Display terms on invoice';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term.l10n_cl_sii_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.l10n_cl_sii_code IS 'DTE SII Code';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    months integer NOT NULL,
    days integer NOT NULL,
    days_after integer,
    discount_days integer,
    payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    value_amount numeric,
    end_month boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_percentage double precision
);


ALTER TABLE public.account_payment_term_line OWNER TO runbot;

--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.months; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.months IS 'Months';


--
-- Name: COLUMN account_payment_term_line.days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.days IS 'Days';


--
-- Name: COLUMN account_payment_term_line.days_after; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.days_after IS 'Days after End of month';


--
-- Name: COLUMN account_payment_term_line.discount_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.discount_days IS 'Discount Days';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Type';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Value';


--
-- Name: COLUMN account_payment_term_line.end_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.end_month IS 'End of month';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term_line.discount_percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.discount_percentage IS 'Discount %';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_payment_term_surcharge; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_surcharge (
    id integer NOT NULL,
    payment_term_id integer NOT NULL,
    days integer NOT NULL,
    day_of_the_month integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    option character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    surcharge double precision
);


ALTER TABLE public.account_payment_term_surcharge OWNER TO runbot;

--
-- Name: TABLE account_payment_term_surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_surcharge IS 'Payment Terms Surcharge';


--
-- Name: COLUMN account_payment_term_surcharge.payment_term_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_surcharge.days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.days IS 'Number of Days';


--
-- Name: COLUMN account_payment_term_surcharge.day_of_the_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.day_of_the_month IS 'Day of the month';


--
-- Name: COLUMN account_payment_term_surcharge.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term_surcharge.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_surcharge.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_surcharge.option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.option IS 'Options';


--
-- Name: COLUMN account_payment_term_surcharge.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_surcharge.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term_surcharge.surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.surcharge IS 'Surcharge [%]';


--
-- Name: account_payment_term_surcharge_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_surcharge_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_surcharge_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_surcharge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_surcharge_id_seq OWNED BY public.account_payment_term_surcharge.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    message_main_attachment_id integer,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    past_months_limit integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    rule_type character varying NOT NULL,
    matching_order character varying NOT NULL,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    payment_tolerance_type character varying NOT NULL,
    decimal_separator character varying,
    active boolean,
    auto_reconcile boolean,
    to_check boolean,
    match_text_location_label boolean,
    match_text_location_note boolean,
    match_text_location_reference boolean,
    match_same_currency boolean,
    allow_payment_tolerance boolean,
    match_partner boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    match_amount_min double precision,
    match_amount_max double precision,
    payment_tolerance_param double precision
);


ALTER TABLE public.account_reconcile_model OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.past_months_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.past_months_limit IS 'Search Months Limit';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.rule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model.matching_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.matching_order IS 'Matching Order';


--
-- Name: COLUMN account_reconcile_model.match_nature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_nature IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount Condition';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.match_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model.match_note_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_type IS 'Payment Tolerance Type';


--
-- Name: COLUMN account_reconcile_model.decimal_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.active IS 'Active';


--
-- Name: COLUMN account_reconcile_model.auto_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model.match_text_location_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_label IS 'Match Text Location Label';


--
-- Name: COLUMN account_reconcile_model.match_text_location_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_note IS 'Match Text Location Note';


--
-- Name: COLUMN account_reconcile_model.match_text_location_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_reference IS 'Match Text Location Reference';


--
-- Name: COLUMN account_reconcile_model.match_same_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_same_currency IS 'Same Currency';


--
-- Name: COLUMN account_reconcile_model.allow_payment_tolerance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.allow_payment_tolerance IS 'Payment Tolerance';


--
-- Name: COLUMN account_reconcile_model.match_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_partner IS 'Partner is Set';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_param IS 'Gap';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line (
    id integer NOT NULL,
    model_id integer,
    company_id integer,
    sequence integer NOT NULL,
    account_id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    label character varying,
    amount_type character varying NOT NULL,
    amount_string character varying NOT NULL,
    analytic_distribution jsonb,
    force_tax_included boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_reconcile_model_line OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line IS 'Rules for the reconciliation model';


--
-- Name: COLUMN account_reconcile_model_line.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line.amount_string; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.analytic_distribution IS 'Analytic';


--
-- Name: COLUMN account_reconcile_model_line.force_tax_included; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount IS 'Float Amount';


--
-- Name: account_reconcile_model_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_account_tax_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_tax';


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNED BY public.account_reconcile_model_line.id;


--
-- Name: account_reconcile_model_line_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_template (
    id integer NOT NULL,
    model_id integer,
    sequence integer NOT NULL,
    account_id integer,
    create_uid integer,
    write_uid integer,
    label character varying,
    amount_type character varying NOT NULL,
    amount_string character varying,
    force_tax_included boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_line_template OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_template IS 'Reconcile Model Line Template';


--
-- Name: COLUMN account_reconcile_model_line_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line_template.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line_template.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_line_template.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line_template.amount_string; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line_template.force_tax_included; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_line_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line_template.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_line_template_account_tax_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_template_account_tax_template_rel (
    account_reconcile_model_line_template_id integer NOT NULL,
    account_tax_template_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_template_account_tax_template_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_template_account_tax_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_template_account_tax_template_rel IS 'RELATION BETWEEN account_reconcile_model_line_template AND account_tax_template';


--
-- Name: account_reconcile_model_line_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_line_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_template_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_line_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_line_template_id_seq OWNED BY public.account_reconcile_model_line_template.id;


--
-- Name: account_reconcile_model_partner_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_partner_mapping (
    id integer NOT NULL,
    model_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_ref_regex character varying,
    narration_regex character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_partner_mapping OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_partner_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_partner_mapping IS 'Partner mapping for reconciliation models';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.payment_ref_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.payment_ref_regex IS 'Find Text in Label';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.narration_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.narration_regex IS 'Find Text in Notes';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_partner_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNED BY public.account_reconcile_model_partner_mapping.id;


--
-- Name: account_reconcile_model_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_category_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner_category';


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_reconcile_model_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_template (
    id integer NOT NULL,
    chart_template_id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    rule_type character varying NOT NULL,
    matching_order character varying,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    payment_tolerance_type character varying NOT NULL,
    decimal_separator character varying,
    auto_reconcile boolean,
    to_check boolean,
    match_text_location_label boolean,
    match_text_location_note boolean,
    match_text_location_reference boolean,
    match_same_currency boolean,
    allow_payment_tolerance boolean,
    match_partner boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    match_amount_min double precision,
    match_amount_max double precision,
    payment_tolerance_param double precision
);


ALTER TABLE public.account_reconcile_model_template OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_template IS 'Reconcile Model Template';


--
-- Name: COLUMN account_reconcile_model_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_reconcile_model_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.name IS 'Button Label';


--
-- Name: COLUMN account_reconcile_model_template.rule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model_template.matching_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.matching_order IS 'Matching Order';


--
-- Name: COLUMN account_reconcile_model_template.match_nature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_nature IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_template.match_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_amount IS 'Amount Condition';


--
-- Name: COLUMN account_reconcile_model_template.match_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model_template.match_label_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model_template.match_note_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model_template.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model_template.payment_tolerance_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.payment_tolerance_type IS 'Payment Tolerance Type';


--
-- Name: COLUMN account_reconcile_model_template.decimal_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model_template.auto_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model_template.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model_template.match_text_location_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_text_location_label IS 'Match Text Location Label';


--
-- Name: COLUMN account_reconcile_model_template.match_text_location_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_text_location_note IS 'Match Text Location Note';


--
-- Name: COLUMN account_reconcile_model_template.match_text_location_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_text_location_reference IS 'Match Text Location Reference';


--
-- Name: COLUMN account_reconcile_model_template.match_same_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_same_currency IS 'Same Currency';


--
-- Name: COLUMN account_reconcile_model_template.allow_payment_tolerance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.allow_payment_tolerance IS 'Allow Payment Gap';


--
-- Name: COLUMN account_reconcile_model_template.match_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_partner IS 'Partner Is Set';


--
-- Name: COLUMN account_reconcile_model_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model_template.match_amount_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model_template.match_amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model_template.payment_tolerance_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_template.payment_tolerance_param IS 'Gap';


--
-- Name: account_reconcile_model_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_template_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_template_id_seq OWNED BY public.account_reconcile_model_template.id;


--
-- Name: account_reconcile_model_template_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_template_res_partner_category_rel (
    account_reconcile_model_template_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_template_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_template_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_template_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model_template AND res_partner_category';


--
-- Name: account_reconcile_model_template_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_template_res_partner_rel (
    account_reconcile_model_template_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_template_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_template_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_template_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model_template AND res_partner';


--
-- Name: account_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report (
    id integer NOT NULL,
    root_report_id integer,
    chart_template_id integer,
    country_id integer,
    load_more_limit integer,
    create_uid integer,
    write_uid integer,
    availability_condition character varying,
    default_opening_date_filter character varying,
    filter_multi_company character varying,
    filter_hierarchy character varying,
    name jsonb NOT NULL,
    only_tax_exigible boolean,
    search_bar boolean,
    filter_date_range boolean,
    filter_show_draft boolean,
    filter_unreconciled boolean,
    filter_unfold_all boolean,
    filter_period_comparison boolean,
    filter_growth_comparison boolean,
    filter_journals boolean,
    filter_analytic boolean,
    filter_account_type boolean,
    filter_partner boolean,
    filter_fiscal_position boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    custom_handler_model_id integer,
    main_template character varying NOT NULL,
    main_table_header_template character varying NOT NULL,
    line_template character varying NOT NULL,
    footnotes_template character varying NOT NULL,
    search_template character varying NOT NULL,
    filter_analytic_groupby boolean,
    settlement_title jsonb,
    allow_settlement boolean,
    settlement_allow_unbalanced boolean,
    filter_cash_basis boolean
);


ALTER TABLE public.account_report OWNER TO runbot;

--
-- Name: TABLE account_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report IS 'Accounting Report';


--
-- Name: COLUMN account_report.root_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.root_report_id IS 'Root Report';


--
-- Name: COLUMN account_report.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.chart_template_id IS 'Chart of Accounts';


--
-- Name: COLUMN account_report.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.country_id IS 'Country';


--
-- Name: COLUMN account_report.load_more_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.load_more_limit IS 'Load More Limit';


--
-- Name: COLUMN account_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report.availability_condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.availability_condition IS 'Availability';


--
-- Name: COLUMN account_report.default_opening_date_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.default_opening_date_filter IS 'Default Opening';


--
-- Name: COLUMN account_report.filter_multi_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_multi_company IS 'Multi-Company';


--
-- Name: COLUMN account_report.filter_hierarchy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hierarchy IS 'Account Groups';


--
-- Name: COLUMN account_report.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.name IS 'Name';


--
-- Name: COLUMN account_report.only_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.only_tax_exigible IS 'Only Tax Exigible Lines';


--
-- Name: COLUMN account_report.search_bar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.search_bar IS 'Search Bar';


--
-- Name: COLUMN account_report.filter_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_date_range IS 'Date Range';


--
-- Name: COLUMN account_report.filter_show_draft; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_show_draft IS 'Draft Entries';


--
-- Name: COLUMN account_report.filter_unreconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unreconciled IS 'Unreconciled Entries';


--
-- Name: COLUMN account_report.filter_unfold_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unfold_all IS 'Unfold All';


--
-- Name: COLUMN account_report.filter_period_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_period_comparison IS 'Period Comparison';


--
-- Name: COLUMN account_report.filter_growth_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_growth_comparison IS 'Growth Comparison';


--
-- Name: COLUMN account_report.filter_journals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_journals IS 'Journals';


--
-- Name: COLUMN account_report.filter_analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic IS 'Analytic Filter';


--
-- Name: COLUMN account_report.filter_account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_account_type IS 'Account Types';


--
-- Name: COLUMN account_report.filter_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_partner IS 'Partners';


--
-- Name: COLUMN account_report.filter_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_fiscal_position IS 'Filter Multivat';


--
-- Name: COLUMN account_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_date IS 'Created on';


--
-- Name: COLUMN account_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report.custom_handler_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.custom_handler_model_id IS 'Custom Handler Model';


--
-- Name: COLUMN account_report.main_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.main_template IS 'Main Template';


--
-- Name: COLUMN account_report.main_table_header_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.main_table_header_template IS 'Main Table Header Template';


--
-- Name: COLUMN account_report.line_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.line_template IS 'Line Template';


--
-- Name: COLUMN account_report.footnotes_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.footnotes_template IS 'Footnotes Template';


--
-- Name: COLUMN account_report.search_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.search_template IS 'Search Template';


--
-- Name: COLUMN account_report.filter_analytic_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic_groupby IS 'Analytic Group By';


--
-- Name: COLUMN account_report.settlement_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.settlement_title IS 'Settlement Title';


--
-- Name: COLUMN account_report.allow_settlement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.allow_settlement IS 'Allow Settlement';


--
-- Name: COLUMN account_report.settlement_allow_unbalanced; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.settlement_allow_unbalanced IS 'Settlement Allow Unbalanced';


--
-- Name: COLUMN account_report.filter_cash_basis; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_cash_basis IS 'Cash Basis';


--
-- Name: account_report_account_report_horizontal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_account_report_horizontal_group_rel (
    account_report_id integer NOT NULL,
    account_report_horizontal_group_id integer NOT NULL
);


ALTER TABLE public.account_report_account_report_horizontal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_report_account_report_horizontal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_account_report_horizontal_group_rel IS 'RELATION BETWEEN account_report AND account_report_horizontal_group';


--
-- Name: account_report_column; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_column (
    id integer NOT NULL,
    sequence integer,
    report_id integer,
    custom_audit_action_id integer,
    create_uid integer,
    write_uid integer,
    expression_label character varying NOT NULL,
    figure_type character varying NOT NULL,
    name jsonb NOT NULL,
    sortable boolean,
    blank_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_column OWNER TO runbot;

--
-- Name: TABLE account_report_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_column IS 'Accounting Report Column';


--
-- Name: COLUMN account_report_column.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_column.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.report_id IS 'Report';


--
-- Name: COLUMN account_report_column.custom_audit_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.custom_audit_action_id IS 'Custom Audit Action';


--
-- Name: COLUMN account_report_column.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_column.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_column.expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.expression_label IS 'Expression Label';


--
-- Name: COLUMN account_report_column.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_column.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.name IS 'Name';


--
-- Name: COLUMN account_report_column.sortable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sortable IS 'Sortable';


--
-- Name: COLUMN account_report_column.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_column.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_date IS 'Created on';


--
-- Name: COLUMN account_report_column.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_date IS 'Last Updated on';


--
-- Name: account_report_column_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_column_id_seq OWNER TO runbot;

--
-- Name: account_report_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_column_id_seq OWNED BY public.account_report_column.id;


--
-- Name: account_report_expression; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_expression (
    id integer NOT NULL,
    report_line_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label character varying NOT NULL,
    engine character varying NOT NULL,
    formula character varying NOT NULL,
    subformula character varying,
    date_scope character varying NOT NULL,
    figure_type character varying,
    carryover_target character varying,
    green_on_positive boolean,
    blank_if_zero boolean,
    auditable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_expression OWNER TO runbot;

--
-- Name: TABLE account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_expression IS 'Accounting Report Expression';


--
-- Name: COLUMN account_report_expression.report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.report_line_id IS 'Report Line';


--
-- Name: COLUMN account_report_expression.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_expression.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_expression.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.label IS 'Label';


--
-- Name: COLUMN account_report_expression.engine; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.engine IS 'Computation Engine';


--
-- Name: COLUMN account_report_expression.formula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.formula IS 'Formula';


--
-- Name: COLUMN account_report_expression.subformula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.subformula IS 'Subformula';


--
-- Name: COLUMN account_report_expression.date_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.date_scope IS 'Date Scope';


--
-- Name: COLUMN account_report_expression.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_expression.carryover_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.carryover_target IS 'Carry Over To';


--
-- Name: COLUMN account_report_expression.green_on_positive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.green_on_positive IS 'Is Growth Good when Positive';


--
-- Name: COLUMN account_report_expression.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_expression.auditable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.auditable IS 'Auditable';


--
-- Name: COLUMN account_report_expression.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_date IS 'Created on';


--
-- Name: COLUMN account_report_expression.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_date IS 'Last Updated on';


--
-- Name: account_report_expression_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_expression_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_expression_id_seq OWNER TO runbot;

--
-- Name: account_report_expression_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_expression_id_seq OWNED BY public.account_report_expression.id;


--
-- Name: account_report_external_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_external_value (
    id integer NOT NULL,
    target_report_expression_id integer NOT NULL,
    company_id integer NOT NULL,
    foreign_vat_fiscal_position_id integer,
    carryover_origin_report_line_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    carryover_origin_expression_label character varying,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision NOT NULL
);


ALTER TABLE public.account_report_external_value OWNER TO runbot;

--
-- Name: TABLE account_report_external_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_external_value IS 'Accounting Report External Value';


--
-- Name: COLUMN account_report_external_value.target_report_expression_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.target_report_expression_id IS 'Target Expression';


--
-- Name: COLUMN account_report_external_value.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.company_id IS 'Company';


--
-- Name: COLUMN account_report_external_value.foreign_vat_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.foreign_vat_fiscal_position_id IS 'Fiscal position';


--
-- Name: COLUMN account_report_external_value.carryover_origin_report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_report_line_id IS 'Origin Line';


--
-- Name: COLUMN account_report_external_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_external_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_external_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.name IS 'Name';


--
-- Name: COLUMN account_report_external_value.carryover_origin_expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_expression_label IS 'Origin Expression Label';


--
-- Name: COLUMN account_report_external_value.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.date IS 'Date';


--
-- Name: COLUMN account_report_external_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_date IS 'Created on';


--
-- Name: COLUMN account_report_external_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_external_value.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.value IS 'Value';


--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_external_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_external_value_id_seq OWNER TO runbot;

--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_external_value_id_seq OWNED BY public.account_report_external_value.id;


--
-- Name: account_report_footnote; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_footnote (
    id integer NOT NULL,
    manager_id integer,
    create_uid integer,
    write_uid integer,
    text character varying,
    line character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_footnote OWNER TO runbot;

--
-- Name: TABLE account_report_footnote; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_footnote IS 'Account Report Footnote';


--
-- Name: COLUMN account_report_footnote.manager_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_footnote.manager_id IS 'Manager';


--
-- Name: COLUMN account_report_footnote.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_footnote.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_footnote.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_footnote.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_footnote.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_footnote.text IS 'Text';


--
-- Name: COLUMN account_report_footnote.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_footnote.line IS 'Line';


--
-- Name: COLUMN account_report_footnote.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_footnote.create_date IS 'Created on';


--
-- Name: COLUMN account_report_footnote.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_footnote.write_date IS 'Last Updated on';


--
-- Name: account_report_footnote_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_footnote_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_footnote_id_seq OWNER TO runbot;

--
-- Name: account_report_footnote_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_footnote_id_seq OWNED BY public.account_report_footnote.id;


--
-- Name: account_report_horizontal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group IS 'Horizontal group for reports';


--
-- Name: COLUMN account_report_horizontal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.name IS 'Name';


--
-- Name: COLUMN account_report_horizontal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNED BY public.account_report_horizontal_group.id;


--
-- Name: account_report_horizontal_group_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group_rule (
    id integer NOT NULL,
    horizontal_group_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    domain character varying NOT NULL,
    field_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group_rule OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group_rule IS 'Horizontal group rule for reports';


--
-- Name: COLUMN account_report_horizontal_group_rule.horizontal_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.horizontal_group_id IS 'Horizontal Group';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group_rule.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.domain IS 'Domain';


--
-- Name: COLUMN account_report_horizontal_group_rule.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.field_name IS 'Field';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNED BY public.account_report_horizontal_group_rule.id;


--
-- Name: account_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_id_seq OWNER TO runbot;

--
-- Name: account_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_id_seq OWNED BY public.account_report.id;


--
-- Name: account_report_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_line (
    id integer NOT NULL,
    report_id integer NOT NULL,
    hierarchy_level integer NOT NULL,
    parent_id integer,
    sequence integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    groupby character varying,
    code character varying,
    name jsonb NOT NULL,
    foldable boolean,
    print_on_new_page boolean,
    hide_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_line OWNER TO runbot;

--
-- Name: TABLE account_report_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_line IS 'Accounting Report Line';


--
-- Name: COLUMN account_report_line.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.report_id IS 'Parent Report';


--
-- Name: COLUMN account_report_line.hierarchy_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hierarchy_level IS 'Level';


--
-- Name: COLUMN account_report_line.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_report_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_line.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.action_id IS 'Action';


--
-- Name: COLUMN account_report_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_line.groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.groupby IS 'Group By';


--
-- Name: COLUMN account_report_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.code IS 'Code';


--
-- Name: COLUMN account_report_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.name IS 'Name';


--
-- Name: COLUMN account_report_line.foldable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.foldable IS 'Foldable';


--
-- Name: COLUMN account_report_line.print_on_new_page; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.print_on_new_page IS 'Print On New Page';


--
-- Name: COLUMN account_report_line.hide_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hide_if_zero IS 'Hide if Zero';


--
-- Name: COLUMN account_report_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_report_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_date IS 'Last Updated on';


--
-- Name: account_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_line_id_seq OWNER TO runbot;

--
-- Name: account_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_line_id_seq OWNED BY public.account_report_line.id;


--
-- Name: account_report_manager; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_manager (
    id integer NOT NULL,
    company_id integer,
    report_id integer,
    create_uid integer,
    write_uid integer,
    report_name character varying NOT NULL,
    summary character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_manager OWNER TO runbot;

--
-- Name: TABLE account_report_manager; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_manager IS 'Manage Summary and Footnotes of Reports';


--
-- Name: COLUMN account_report_manager.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_manager.company_id IS 'Company';


--
-- Name: COLUMN account_report_manager.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_manager.report_id IS 'Report';


--
-- Name: COLUMN account_report_manager.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_manager.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_manager.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_manager.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_manager.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_manager.report_name IS 'Report Name';


--
-- Name: COLUMN account_report_manager.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_manager.summary IS 'Summary';


--
-- Name: COLUMN account_report_manager.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_manager.create_date IS 'Created on';


--
-- Name: COLUMN account_report_manager.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_manager.write_date IS 'Last Updated on';


--
-- Name: account_report_manager_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_manager_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_manager_id_seq OWNER TO runbot;

--
-- Name: account_report_manager_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_manager_id_seq OWNED BY public.account_report_manager.id;


--
-- Name: account_reports_export_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard (
    id integer NOT NULL,
    report_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    doc_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    folder_id integer NOT NULL,
    l10n_es_reports_boe_wizard_id integer,
    l10n_es_reports_boe_wizard_model character varying
);


ALTER TABLE public.account_reports_export_wizard OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard IS 'Export wizard for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.report_id IS 'Parent Report Id';


--
-- Name: COLUMN account_reports_export_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard.doc_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.doc_name IS 'Documents Name';


--
-- Name: COLUMN account_reports_export_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reports_export_wizard.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.folder_id IS 'Folder';


--
-- Name: COLUMN account_reports_export_wizard.l10n_es_reports_boe_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.l10n_es_reports_boe_wizard_id IS 'L10N Es Reports Boe Wizard';


--
-- Name: COLUMN account_reports_export_wizard.l10n_es_reports_boe_wizard_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.l10n_es_reports_boe_wizard_model IS 'L10N Es Reports Boe Wizard Model';


--
-- Name: account_reports_export_wizard_format; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard_format (
    id integer NOT NULL,
    export_wizard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    fun_to_call character varying NOT NULL,
    fun_param character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reports_export_wizard_format OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard_format IS 'Export format for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard_format.export_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.export_wizard_id IS 'Parent Wizard';


--
-- Name: COLUMN account_reports_export_wizard_format.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard_format.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard_format.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.name IS 'Name';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_to_call; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_to_call IS 'Function to Call';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_param IS 'Function Parameter';


--
-- Name: COLUMN account_reports_export_wizard_format.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard_format.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNED BY public.account_reports_export_wizard_format.id;


--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNED BY public.account_reports_export_wizard.id;


--
-- Name: account_resequence_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_resequence_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    first_name character varying NOT NULL,
    ordering character varying NOT NULL,
    first_date date,
    end_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_resequence_wizard OWNER TO runbot;

--
-- Name: TABLE account_resequence_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_resequence_wizard IS 'Remake the sequence of Journal Entries.';


--
-- Name: COLUMN account_resequence_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_resequence_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_resequence_wizard.first_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_name IS 'First New Sequence';


--
-- Name: COLUMN account_resequence_wizard.ordering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.ordering IS 'Ordering';


--
-- Name: COLUMN account_resequence_wizard.first_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_date IS 'First Date';


--
-- Name: COLUMN account_resequence_wizard.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.end_date IS 'End Date';


--
-- Name: COLUMN account_resequence_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_resequence_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_date IS 'Last Updated on';


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_resequence_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNER TO runbot;

--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNED BY public.account_resequence_wizard.id;


--
-- Name: account_root; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.account_root AS
 SELECT DISTINCT ((ascii((account_account.code)::text) * 1000) + ascii("substring"((account_account.code)::text, 2, 1))) AS id,
    "left"((account_account.code)::text, 2) AS name,
    ascii((account_account.code)::text) AS parent_id,
    account_account.company_id
   FROM public.account_account
  WHERE (account_account.code IS NOT NULL)
UNION ALL
 SELECT DISTINCT ascii((account_account.code)::text) AS id,
    "left"((account_account.code)::text, 1) AS name,
    NULL::integer AS parent_id,
    account_account.company_id
   FROM public.account_account
  WHERE (account_account.code IS NOT NULL);


ALTER VIEW public.account_root OWNER TO runbot;

--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    num_journals_without_account integer,
    create_uid integer,
    write_uid integer,
    new_journal_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_setup_bank_manual_config OWNER TO runbot;

--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account IS 'Num Journals Without Account';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNER TO runbot;

--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_statement_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_statement_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    statement_filename character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sheet_mapping_id integer
);


ALTER TABLE public.account_statement_import OWNER TO runbot;

--
-- Name: TABLE account_statement_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_statement_import IS 'Import Bank Statement Files';


--
-- Name: COLUMN account_statement_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.create_uid IS 'Created by';


--
-- Name: COLUMN account_statement_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_statement_import.statement_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.statement_filename IS 'Statement Filename';


--
-- Name: COLUMN account_statement_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.create_date IS 'Created on';


--
-- Name: COLUMN account_statement_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_statement_import.sheet_mapping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.sheet_mapping_id IS 'Sheet mapping';


--
-- Name: account_statement_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_statement_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_statement_import_id_seq OWNER TO runbot;

--
-- Name: account_statement_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_statement_import_id_seq OWNED BY public.account_statement_import.id;


--
-- Name: account_statement_import_sheet_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_statement_import_sheet_mapping (
    id integer NOT NULL,
    footer_lines_count integer,
    column_labels_row integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    float_thousands_sep character varying,
    float_decimal_sep character varying,
    file_encoding character varying,
    delimiter character varying,
    quotechar character varying(1),
    timestamp_format character varying NOT NULL,
    timestamp_column character varying NOT NULL,
    currency_column character varying,
    amount_column character varying,
    debit_column character varying,
    credit_column character varying,
    amount_debit_column character varying,
    amount_credit_column character varying,
    balance_column character varying,
    original_currency_column character varying,
    original_amount_column character varying,
    amount_type character varying NOT NULL,
    debit_credit_column character varying,
    debit_value character varying,
    credit_value character varying,
    transaction_id_column character varying,
    description_column character varying,
    notes_column character varying,
    reference_column character varying,
    partner_name_column character varying,
    bank_name_column character varying,
    bank_account_column character varying,
    no_header boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_statement_import_sheet_mapping_check_amount_columns CHECK (((amount_column IS NULL) OR ((amount_debit_column IS NULL) AND (amount_credit_column IS NULL))))
);


ALTER TABLE public.account_statement_import_sheet_mapping OWNER TO runbot;

--
-- Name: TABLE account_statement_import_sheet_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_statement_import_sheet_mapping IS 'Bank Statement Import Sheet Mapping';


--
-- Name: COLUMN account_statement_import_sheet_mapping.footer_lines_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.footer_lines_count IS 'Footer lines number';


--
-- Name: COLUMN account_statement_import_sheet_mapping.column_labels_row; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.column_labels_row IS 'Row number for column labels';


--
-- Name: COLUMN account_statement_import_sheet_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN account_statement_import_sheet_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_statement_import_sheet_mapping.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.name IS 'Name';


--
-- Name: COLUMN account_statement_import_sheet_mapping.float_thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.float_thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN account_statement_import_sheet_mapping.float_decimal_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.float_decimal_sep IS 'Decimals Separator';


--
-- Name: COLUMN account_statement_import_sheet_mapping.file_encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.file_encoding IS 'Encoding';


--
-- Name: COLUMN account_statement_import_sheet_mapping.delimiter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.delimiter IS 'Delimiter';


--
-- Name: COLUMN account_statement_import_sheet_mapping.quotechar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.quotechar IS 'Text qualifier';


--
-- Name: COLUMN account_statement_import_sheet_mapping.timestamp_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.timestamp_format IS 'Timestamp Format';


--
-- Name: COLUMN account_statement_import_sheet_mapping.timestamp_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.timestamp_column IS 'Timestamp Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.currency_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.currency_column IS 'Currency Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.amount_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.amount_column IS 'Amount column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.debit_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.debit_column IS 'Debit column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.credit_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.credit_column IS 'Credit column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.amount_debit_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.amount_debit_column IS 'OCA Debit Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.amount_credit_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.amount_credit_column IS 'OCA Credit Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.balance_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.balance_column IS 'Balance Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.original_currency_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.original_currency_column IS 'Original Currency Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.original_amount_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.original_amount_column IS 'Original Amount Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.amount_type IS 'Amount type';


--
-- Name: COLUMN account_statement_import_sheet_mapping.debit_credit_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.debit_credit_column IS 'Debit/credit column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.debit_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.debit_value IS 'Debit Value';


--
-- Name: COLUMN account_statement_import_sheet_mapping.credit_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.credit_value IS 'Credit Value';


--
-- Name: COLUMN account_statement_import_sheet_mapping.transaction_id_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.transaction_id_column IS 'Unique transaction ID column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.description_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.description_column IS 'Description Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.notes_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.notes_column IS 'Notes Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.reference_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.reference_column IS 'Reference Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.partner_name_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.partner_name_column IS 'Partner Name Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.bank_name_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.bank_name_column IS 'Bank Name Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.bank_account_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.bank_account_column IS 'Bank Account Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.no_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.no_header IS 'File does not contain header line';


--
-- Name: COLUMN account_statement_import_sheet_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.create_date IS 'Created on';


--
-- Name: COLUMN account_statement_import_sheet_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_statement_import_sheet_mapping_check_amount_columns ON account_statement_import_sheet_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_statement_import_sheet_mapping_check_amount_columns ON public.account_statement_import_sheet_mapping IS 'CHECK(amount_column IS NULL OR (amount_debit_column IS NULL AND amount_credit_column IS NULL))';


--
-- Name: account_statement_import_sheet_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_statement_import_sheet_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_statement_import_sheet_mapping_id_seq OWNER TO runbot;

--
-- Name: account_statement_import_sheet_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_statement_import_sheet_mapping_id_seq OWNED BY public.account_statement_import_sheet_mapping.id;


--
-- Name: account_statement_import_sheet_parser; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_statement_import_sheet_parser (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_statement_import_sheet_parser OWNER TO runbot;

--
-- Name: TABLE account_statement_import_sheet_parser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_statement_import_sheet_parser IS 'Bank Statement Import Sheet Parser';


--
-- Name: COLUMN account_statement_import_sheet_parser.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_parser.create_uid IS 'Created by';


--
-- Name: COLUMN account_statement_import_sheet_parser.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_parser.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_statement_import_sheet_parser.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_parser.create_date IS 'Created on';


--
-- Name: COLUMN account_statement_import_sheet_parser.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_parser.write_date IS 'Last Updated on';


--
-- Name: account_statement_import_sheet_parser_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_statement_import_sheet_parser_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_statement_import_sheet_parser_id_seq OWNER TO runbot;

--
-- Name: account_statement_import_sheet_parser_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_statement_import_sheet_parser_id_seq OWNED BY public.account_statement_import_sheet_parser.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    tax_group_id integer NOT NULL,
    cash_basis_transition_account_id integer,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    description character varying,
    tax_exigibility character varying,
    amount numeric NOT NULL,
    active boolean,
    price_include boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    real_amount double precision,
    withholding_sequence_id integer,
    l10n_cl_sii_code integer,
    l10n_pe_edi_tax_code character varying,
    l10n_pe_edi_unece_category character varying,
    l10n_pe_edi_isc_type character varying,
    l10n_pe_edi_affectation_reason character varying,
    withholding_amount_type character varying,
    withholding_user_error_message character varying,
    withholding_user_error_domain character varying,
    withholding_accumulated_payments character varying,
    withholding_type character varying,
    withholding_python_compute text,
    withholding_non_taxable_amount numeric,
    withholding_non_taxable_minimum numeric,
    withholding_advances boolean,
    codigo_regimen character varying(3),
    porcentaje_exclusion double precision,
    ratio double precision
);


ALTER TABLE public.account_tax OWNER TO runbot;

--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.country_id IS 'Country';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax.tax_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.description IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Exigibility';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.price_include; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.price_include IS 'Included in Price';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.is_base_affected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax.real_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.real_amount IS 'Real amount to apply';


--
-- Name: COLUMN account_tax.withholding_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_sequence_id IS 'Withholding Number Sequence';


--
-- Name: COLUMN account_tax.l10n_cl_sii_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_cl_sii_code IS 'SII Code';


--
-- Name: COLUMN account_tax.l10n_pe_edi_tax_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_pe_edi_tax_code IS 'EDI peruvian code';


--
-- Name: COLUMN account_tax.l10n_pe_edi_unece_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_pe_edi_unece_category IS 'EDI UNECE code';


--
-- Name: COLUMN account_tax.l10n_pe_edi_isc_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_pe_edi_isc_type IS 'ISC Type';


--
-- Name: COLUMN account_tax.l10n_pe_edi_affectation_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_pe_edi_affectation_reason IS 'EDI Affect. Reason';


--
-- Name: COLUMN account_tax.withholding_amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_amount_type IS 'Base Amount';


--
-- Name: COLUMN account_tax.withholding_user_error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_user_error_message IS 'Withholding User Error Message';


--
-- Name: COLUMN account_tax.withholding_user_error_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_user_error_domain IS 'Withholding User Error Domain';


--
-- Name: COLUMN account_tax.withholding_accumulated_payments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_accumulated_payments IS 'Accumulated Payments';


--
-- Name: COLUMN account_tax.withholding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_type IS 'Type';


--
-- Name: COLUMN account_tax.withholding_python_compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_python_compute IS 'Python Code (withholdings)';


--
-- Name: COLUMN account_tax.withholding_non_taxable_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_non_taxable_amount IS 'Non-taxable Amount';


--
-- Name: COLUMN account_tax.withholding_non_taxable_minimum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_non_taxable_minimum IS 'Non-taxable Minimum';


--
-- Name: COLUMN account_tax.withholding_advances; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.withholding_advances IS 'Advances are Withholdable?';


--
-- Name: COLUMN account_tax.codigo_regimen; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.codigo_regimen IS 'Codigo de regimen IVA';


--
-- Name: COLUMN account_tax.porcentaje_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.porcentaje_exclusion IS 'Porcentaje de exclusión';


--
-- Name: COLUMN account_tax.ratio; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.ratio IS 'Ratio';


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_filiation_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    preceding_subtotal character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_ar_tribute_afip_code character varying,
    l10n_ar_vat_afip_code character varying,
    l10n_uy_vat_code character varying,
    l10n_pe_edi_code character varying
);


ALTER TABLE public.account_tax_group OWNER TO runbot;

--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.country_id IS 'Country';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.preceding_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.preceding_subtotal IS 'Preceding Subtotal';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_group.l10n_ar_tribute_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_tribute_afip_code IS 'Tribute AFIP Code';


--
-- Name: COLUMN account_tax_group.l10n_ar_vat_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_vat_afip_code IS 'VAT AFIP Code';


--
-- Name: COLUMN account_tax_group.l10n_uy_vat_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_uy_vat_code IS 'VAT Code (UY)';


--
-- Name: COLUMN account_tax_group.l10n_pe_edi_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_pe_edi_code IS 'EDI Code';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_group_id_seq OWNER TO runbot;

--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_hr_expense_split_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_hr_expense_split_rel (
    hr_expense_split_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_hr_expense_split_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_hr_expense_split_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_hr_expense_split_rel IS 'RELATION BETWEEN hr_expense_split AND account_tax';


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_id_seq OWNER TO runbot;

--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_pos_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_pos_order_line_rel (
    pos_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_pos_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_pos_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_pos_order_line_rel IS 'RELATION BETWEEN pos_order_line AND account_tax';


--
-- Name: account_tax_purchase_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_purchase_order_line_rel (
    purchase_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_purchase_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_purchase_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_purchase_order_line_rel IS 'RELATION BETWEEN purchase_order_line AND account_tax';


--
-- Name: account_tax_rep_template_minus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_rep_template_minus (
    account_tax_repartition_line_template_id integer NOT NULL,
    account_report_expression_id integer NOT NULL
);


ALTER TABLE public.account_tax_rep_template_minus OWNER TO runbot;

--
-- Name: TABLE account_tax_rep_template_minus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_rep_template_minus IS 'RELATION BETWEEN account_tax_repartition_line_template AND account_report_expression';


--
-- Name: account_tax_rep_template_plus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_rep_template_plus (
    account_tax_repartition_line_template_id integer NOT NULL,
    account_report_expression_id integer NOT NULL
);


ALTER TABLE public.account_tax_rep_template_plus OWNER TO runbot;

--
-- Name: TABLE account_tax_rep_template_plus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_rep_template_plus IS 'RELATION BETWEEN account_tax_repartition_line_template AND account_report_expression';


--
-- Name: account_tax_repartition_financial_tags; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_financial_tags (
    account_tax_repartition_line_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_tax_repartition_financial_tags OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_financial_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_financial_tags IS 'RELATION BETWEEN account_tax_repartition_line_template AND account_account_tag';


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    account_id integer,
    invoice_tax_id integer,
    refund_tax_id integer,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    repartition_type character varying NOT NULL,
    use_in_tax_closing boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    factor_percent double precision NOT NULL
);


ALTER TABLE public.account_tax_repartition_line OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.invoice_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.invoice_tax_id IS 'Invoice Tax';


--
-- Name: COLUMN account_tax_repartition_line.refund_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.refund_tax_id IS 'Refund Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNER TO runbot;

--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_repartition_line_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_line_template (
    id integer NOT NULL,
    account_id integer,
    invoice_tax_id integer,
    refund_tax_id integer,
    create_uid integer,
    write_uid integer,
    repartition_type character varying NOT NULL,
    use_in_tax_closing boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    factor_percent double precision NOT NULL
);


ALTER TABLE public.account_tax_repartition_line_template OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_line_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_line_template IS 'Tax Repartition Line Template';


--
-- Name: COLUMN account_tax_repartition_line_template.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line_template.invoice_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.invoice_tax_id IS 'Invoice Tax';


--
-- Name: COLUMN account_tax_repartition_line_template.refund_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.refund_tax_id IS 'Refund Tax';


--
-- Name: COLUMN account_tax_repartition_line_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line_template.repartition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line_template.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_repartition_line_template.factor_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line_template.factor_percent IS '%';


--
-- Name: account_tax_repartition_line_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_repartition_line_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_template_id_seq OWNER TO runbot;

--
-- Name: account_tax_repartition_line_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_repartition_line_template_id_seq OWNED BY public.account_tax_repartition_line_template.id;


--
-- Name: account_tax_sale_advance_payment_inv_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_advance_payment_inv_rel (
    sale_advance_payment_inv_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_advance_payment_inv_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_advance_payment_inv_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_advance_payment_inv_rel IS 'RELATION BETWEEN sale_advance_payment_inv AND account_tax';


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: account_tax_settlement_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_settlement_wizard (
    id integer NOT NULL,
    settlement_journal_id integer,
    report_id integer,
    company_id integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    select_journal boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_settlement_wizard OWNER TO runbot;

--
-- Name: TABLE account_tax_settlement_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_settlement_wizard IS 'Wizard para generar liquidaciones de impuestos desde ';


--
-- Name: COLUMN account_tax_settlement_wizard.settlement_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.settlement_journal_id IS 'Journal';


--
-- Name: COLUMN account_tax_settlement_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.report_id IS 'Report';


--
-- Name: COLUMN account_tax_settlement_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_tax_settlement_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.account_id IS 'Account';


--
-- Name: COLUMN account_tax_settlement_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_settlement_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_settlement_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.date IS 'Journal Entry Date';


--
-- Name: COLUMN account_tax_settlement_wizard.select_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.select_journal IS 'Select Journal';


--
-- Name: COLUMN account_tax_settlement_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_settlement_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.write_date IS 'Last Updated on';


--
-- Name: account_tax_settlement_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_settlement_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_settlement_wizard_id_seq OWNER TO runbot;

--
-- Name: account_tax_settlement_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_settlement_wizard_id_seq OWNED BY public.account_tax_settlement_wizard.id;


--
-- Name: account_tax_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_template (
    id integer NOT NULL,
    chart_template_id integer NOT NULL,
    sequence integer NOT NULL,
    tax_group_id integer,
    cash_basis_transition_account_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    description character varying,
    tax_exigibility character varying,
    amount numeric NOT NULL,
    active boolean,
    price_include boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_cl_sii_code integer,
    l10n_pe_edi_tax_code character varying,
    l10n_pe_edi_unece_category character varying,
    l10n_pe_edi_isc_type character varying
);


ALTER TABLE public.account_tax_template OWNER TO runbot;

--
-- Name: TABLE account_tax_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_template IS 'Templates for Taxes';


--
-- Name: COLUMN account_tax_template.chart_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.chart_template_id IS 'Chart Template';


--
-- Name: COLUMN account_tax_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_template.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax_template.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.name IS 'Tax Name';


--
-- Name: COLUMN account_tax_template.type_tax_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax_template.tax_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax_template.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.description IS 'Display on Invoices';


--
-- Name: COLUMN account_tax_template.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.tax_exigibility IS 'Tax Due';


--
-- Name: COLUMN account_tax_template.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.amount IS 'Amount';


--
-- Name: COLUMN account_tax_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.active IS 'Active';


--
-- Name: COLUMN account_tax_template.price_include; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.price_include IS 'Included in Price';


--
-- Name: COLUMN account_tax_template.include_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.include_base_amount IS 'Affect Subsequent Taxes';


--
-- Name: COLUMN account_tax_template.is_base_affected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax_template.analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.analytic IS 'Analytic Cost';


--
-- Name: COLUMN account_tax_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_template.l10n_cl_sii_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.l10n_cl_sii_code IS 'SII Code';


--
-- Name: COLUMN account_tax_template.l10n_pe_edi_tax_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.l10n_pe_edi_tax_code IS 'EDI peruvian code';


--
-- Name: COLUMN account_tax_template.l10n_pe_edi_unece_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.l10n_pe_edi_unece_category IS 'EDI UNECE code';


--
-- Name: COLUMN account_tax_template.l10n_pe_edi_isc_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_template.l10n_pe_edi_isc_type IS 'ISC Type';


--
-- Name: account_tax_template_filiation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_template_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_template_filiation_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_template_filiation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_template_filiation_rel IS 'RELATION BETWEEN account_tax_template AND account_tax_template';


--
-- Name: account_tax_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_template_id_seq OWNER TO runbot;

--
-- Name: account_tax_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_template_id_seq OWNED BY public.account_tax_template.id;


--
-- Name: account_tax_unit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit (
    id integer NOT NULL,
    country_id integer NOT NULL,
    main_company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    vat character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_unit OWNER TO runbot;

--
-- Name: TABLE account_tax_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit IS 'Tax Unit';


--
-- Name: COLUMN account_tax_unit.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.country_id IS 'Country';


--
-- Name: COLUMN account_tax_unit.main_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.main_company_id IS 'Main Company';


--
-- Name: COLUMN account_tax_unit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_unit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_unit.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.name IS 'Name';


--
-- Name: COLUMN account_tax_unit.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.vat IS 'Tax ID';


--
-- Name: COLUMN account_tax_unit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_unit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_date IS 'Last Updated on';


--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_unit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_unit_id_seq OWNER TO runbot;

--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_unit_id_seq OWNED BY public.account_tax_unit.id;


--
-- Name: account_tax_unit_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit_res_company_rel (
    res_company_id integer NOT NULL,
    account_tax_unit_id integer NOT NULL
);


ALTER TABLE public.account_tax_unit_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_unit_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit_res_company_rel IS 'RELATION BETWEEN res_company AND account_tax_unit';


--
-- Name: account_tax_withholding_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_withholding_rule (
    id integer NOT NULL,
    sequence integer,
    tax_withholding_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    domain character varying NOT NULL,
    percentage numeric,
    fix_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_withholding_rule OWNER TO runbot;

--
-- Name: TABLE account_tax_withholding_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_withholding_rule IS 'account.tax.withholding.rule';


--
-- Name: COLUMN account_tax_withholding_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_withholding_rule.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_withholding_rule.tax_withholding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_withholding_rule.tax_withholding_id IS 'Tax Withholding';


--
-- Name: COLUMN account_tax_withholding_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_withholding_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_withholding_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_withholding_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_withholding_rule.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_withholding_rule.domain IS 'Domain';


--
-- Name: COLUMN account_tax_withholding_rule.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_withholding_rule.percentage IS 'Percentage';


--
-- Name: COLUMN account_tax_withholding_rule.fix_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_withholding_rule.fix_amount IS 'Amount';


--
-- Name: COLUMN account_tax_withholding_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_withholding_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_withholding_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_withholding_rule.write_date IS 'Last Updated on';


--
-- Name: account_tax_withholding_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_withholding_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_withholding_rule_id_seq OWNER TO runbot;

--
-- Name: account_tax_withholding_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_withholding_rule_id_seq OWNED BY public.account_tax_withholding_rule.id;


--
-- Name: account_tour_upload_bill; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tour_upload_bill (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    selection character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tour_upload_bill OWNER TO runbot;

--
-- Name: TABLE account_tour_upload_bill; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tour_upload_bill IS 'Account tour upload bill';


--
-- Name: COLUMN account_tour_upload_bill.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.create_uid IS 'Created by';


--
-- Name: COLUMN account_tour_upload_bill.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tour_upload_bill.selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.selection IS 'Selection';


--
-- Name: COLUMN account_tour_upload_bill.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.create_date IS 'Created on';


--
-- Name: COLUMN account_tour_upload_bill.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill.write_date IS 'Last Updated on';


--
-- Name: account_tour_upload_bill_email_confirm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tour_upload_bill_email_confirm (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email_alias character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tour_upload_bill_email_confirm OWNER TO runbot;

--
-- Name: TABLE account_tour_upload_bill_email_confirm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tour_upload_bill_email_confirm IS 'Account tour upload bill email confirm';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.create_uid IS 'Created by';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.email_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.email_alias IS 'Email Alias';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.create_date IS 'Created on';


--
-- Name: COLUMN account_tour_upload_bill_email_confirm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tour_upload_bill_email_confirm.write_date IS 'Last Updated on';


--
-- Name: account_tour_upload_bill_email_confirm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tour_upload_bill_email_confirm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tour_upload_bill_email_confirm_id_seq OWNER TO runbot;

--
-- Name: account_tour_upload_bill_email_confirm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tour_upload_bill_email_confirm_id_seq OWNED BY public.account_tour_upload_bill_email_confirm.id;


--
-- Name: account_tour_upload_bill_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tour_upload_bill_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tour_upload_bill_id_seq OWNER TO runbot;

--
-- Name: account_tour_upload_bill_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tour_upload_bill_id_seq OWNED BY public.account_tour_upload_bill.id;


--
-- Name: account_tour_upload_bill_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tour_upload_bill_ir_attachments_rel (
    account_tour_upload_bill_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_tour_upload_bill_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE account_tour_upload_bill_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tour_upload_bill_ir_attachments_rel IS 'RELATION BETWEEN account_tour_upload_bill AND ir_attachment';


--
-- Name: account_transfer_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_transfer_model (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    frequency character varying NOT NULL,
    state character varying NOT NULL,
    date_start date NOT NULL,
    date_stop date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_transfer_model OWNER TO runbot;

--
-- Name: TABLE account_transfer_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_transfer_model IS 'Account Transfer Model';


--
-- Name: COLUMN account_transfer_model.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_transfer_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.name IS 'Name';


--
-- Name: COLUMN account_transfer_model.frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.frequency IS 'Frequency';


--
-- Name: COLUMN account_transfer_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.state IS 'State';


--
-- Name: COLUMN account_transfer_model.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.date_start IS 'Start Date';


--
-- Name: COLUMN account_transfer_model.date_stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.date_stop IS 'Stop Date';


--
-- Name: COLUMN account_transfer_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.write_date IS 'Last Updated on';


--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_transfer_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_transfer_model_id_seq OWNER TO runbot;

--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_transfer_model_id_seq OWNED BY public.account_transfer_model.id;


--
-- Name: account_transfer_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_transfer_model_line (
    id integer NOT NULL,
    transfer_model_id integer NOT NULL,
    account_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percent double precision NOT NULL
);


ALTER TABLE public.account_transfer_model_line OWNER TO runbot;

--
-- Name: TABLE account_transfer_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_transfer_model_line IS 'Account Transfer Model Line';


--
-- Name: COLUMN account_transfer_model_line.transfer_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.transfer_model_id IS 'Transfer Model';


--
-- Name: COLUMN account_transfer_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.account_id IS 'Destination Account';


--
-- Name: COLUMN account_transfer_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_transfer_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_transfer_model_line.percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.percent IS 'Percent';


--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_transfer_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_transfer_model_line_id_seq OWNER TO runbot;

--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_transfer_model_line_id_seq OWNED BY public.account_transfer_model_line.id;


--
-- Name: account_transfer_model_line_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_transfer_model_line_res_partner_rel (
    account_transfer_model_line_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_transfer_model_line_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_transfer_model_line_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_transfer_model_line_res_partner_rel IS 'RELATION BETWEEN account_transfer_model_line AND res_partner';


--
-- Name: account_unreconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_unreconcile (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_unreconcile OWNER TO runbot;

--
-- Name: TABLE account_unreconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_unreconcile IS 'Account Unreconcile';


--
-- Name: COLUMN account_unreconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_unreconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_unreconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_unreconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_unreconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_unreconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_unreconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_unreconcile.write_date IS 'Last Updated on';


--
-- Name: account_unreconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_unreconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_unreconcile_id_seq OWNER TO runbot;

--
-- Name: account_unreconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_unreconcile_id_seq OWNED BY public.account_unreconcile.id;


--
-- Name: account_uy_vat_line; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.account_uy_vat_line AS
SELECT
    NULL::text AS column_group_key,
    NULL::integer AS id,
    NULL::character varying AS rut,
    NULL::character varying AS move_name,
    NULL::character varying AS partner_name,
    NULL::integer AS move_id,
    NULL::character varying AS tax_type,
    NULL::character varying AS move_type,
    NULL::date AS date,
    NULL::date AS invoice_date,
    NULL::integer AS partner_id,
    NULL::integer AS journal_id,
    NULL::integer AS document_type_id,
    NULL::character varying AS state,
    NULL::integer AS company_id,
    NULL::numeric AS base_22,
    NULL::numeric AS vat_22,
    NULL::numeric AS base_10,
    NULL::numeric AS vat_10,
    NULL::numeric AS not_taxed,
    NULL::numeric AS taxed,
    NULL::numeric AS other_taxes,
    NULL::numeric AS total;


ALTER VIEW public.account_uy_vat_line OWNER TO runbot;

--
-- Name: adhoc_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_category (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_category OWNER TO runbot;

--
-- Name: TABLE adhoc_module_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_category IS 'adhoc.module.category';


--
-- Name: COLUMN adhoc_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN adhoc_module_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.name IS 'Name';


--
-- Name: COLUMN adhoc_module_category.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.code IS 'Code';


--
-- Name: COLUMN adhoc_module_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_category_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_category_id_seq OWNED BY public.adhoc_module_category.id;


--
-- Name: afip_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_activity (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    alicuota_general character varying,
    posee_tasa_cero character varying,
    no_posee_certificado_tasa_cero character varying
);


ALTER TABLE public.afip_activity OWNER TO runbot;

--
-- Name: TABLE afip_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_activity IS 'afip.activity';


--
-- Name: COLUMN afip_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.create_uid IS 'Created by';


--
-- Name: COLUMN afip_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_activity.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.code IS 'Code';


--
-- Name: COLUMN afip_activity.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.name IS 'Name';


--
-- Name: COLUMN afip_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.active IS 'Active';


--
-- Name: COLUMN afip_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.create_date IS 'Created on';


--
-- Name: COLUMN afip_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.write_date IS 'Last Updated on';


--
-- Name: COLUMN afip_activity.alicuota_general; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.alicuota_general IS 'Alicuota General';


--
-- Name: COLUMN afip_activity.posee_tasa_cero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.posee_tasa_cero IS 'Posee Tasa Cero';


--
-- Name: COLUMN afip_activity.no_posee_certificado_tasa_cero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.no_posee_certificado_tasa_cero IS 'No Posee Certificado Tasa Cero';


--
-- Name: afip_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_activity_id_seq OWNER TO runbot;

--
-- Name: afip_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_activity_id_seq OWNED BY public.afip_activity.id;


--
-- Name: afip_concept; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_concept (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_concept OWNER TO runbot;

--
-- Name: TABLE afip_concept; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_concept IS 'afip.concept';


--
-- Name: COLUMN afip_concept.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_uid IS 'Created by';


--
-- Name: COLUMN afip_concept.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_concept.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.code IS 'Code';


--
-- Name: COLUMN afip_concept.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.name IS 'Name';


--
-- Name: COLUMN afip_concept.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.active IS 'Active';


--
-- Name: COLUMN afip_concept.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_date IS 'Created on';


--
-- Name: COLUMN afip_concept.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_date IS 'Last Updated on';


--
-- Name: afip_concept_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_concept_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_concept_id_seq OWNER TO runbot;

--
-- Name: afip_concept_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_concept_id_seq OWNED BY public.afip_concept.id;


--
-- Name: afip_tabla_ganancias_alicuotasymontos; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_tabla_ganancias_alicuotasymontos (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    codigo_de_regimen character varying(6) NOT NULL,
    anexo_referencia character varying NOT NULL,
    concepto_referencia text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    porcentaje_inscripto double precision,
    porcentaje_no_inscripto double precision,
    montos_no_sujetos_a_retencion double precision
);


ALTER TABLE public.afip_tabla_ganancias_alicuotasymontos OWNER TO runbot;

--
-- Name: TABLE afip_tabla_ganancias_alicuotasymontos; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_tabla_ganancias_alicuotasymontos IS 'afip.tabla_ganancias.alicuotasymontos';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.create_uid IS 'Created by';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.codigo_de_regimen; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.codigo_de_regimen IS 'Codigo de regimen';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.anexo_referencia; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.anexo_referencia IS 'Anexo Referencia';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.concepto_referencia; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.concepto_referencia IS 'Concepto Referencia';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.create_date IS 'Created on';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.write_date IS 'Last Updated on';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.porcentaje_inscripto; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.porcentaje_inscripto IS '% Inscripto';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.porcentaje_no_inscripto; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.porcentaje_no_inscripto IS '% No Inscripto';


--
-- Name: COLUMN afip_tabla_ganancias_alicuotasymontos.montos_no_sujetos_a_retencion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_alicuotasymontos.montos_no_sujetos_a_retencion IS 'Montos No Sujetos A Retencion';


--
-- Name: afip_tabla_ganancias_alicuotasymontos_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_tabla_ganancias_alicuotasymontos_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_tabla_ganancias_alicuotasymontos_id_seq OWNER TO runbot;

--
-- Name: afip_tabla_ganancias_alicuotasymontos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_tabla_ganancias_alicuotasymontos_id_seq OWNED BY public.afip_tabla_ganancias_alicuotasymontos.id;


--
-- Name: afip_tabla_ganancias_escala; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_tabla_ganancias_escala (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    codigo_de_regimen character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    importe_desde double precision,
    importe_hasta double precision,
    importe_fijo double precision,
    porcentaje double precision,
    importe_excedente double precision
);


ALTER TABLE public.afip_tabla_ganancias_escala OWNER TO runbot;

--
-- Name: TABLE afip_tabla_ganancias_escala; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_tabla_ganancias_escala IS 'afip.tabla_ganancias.escala';


--
-- Name: COLUMN afip_tabla_ganancias_escala.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.create_uid IS 'Created by';


--
-- Name: COLUMN afip_tabla_ganancias_escala.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_tabla_ganancias_escala.codigo_de_regimen; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.codigo_de_regimen IS 'Codigo de Regimen';


--
-- Name: COLUMN afip_tabla_ganancias_escala.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.create_date IS 'Created on';


--
-- Name: COLUMN afip_tabla_ganancias_escala.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.write_date IS 'Last Updated on';


--
-- Name: COLUMN afip_tabla_ganancias_escala.importe_desde; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.importe_desde IS 'Mas de $';


--
-- Name: COLUMN afip_tabla_ganancias_escala.importe_hasta; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.importe_hasta IS 'A $';


--
-- Name: COLUMN afip_tabla_ganancias_escala.importe_fijo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.importe_fijo IS '$';


--
-- Name: COLUMN afip_tabla_ganancias_escala.porcentaje; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.porcentaje IS 'Más el %';


--
-- Name: COLUMN afip_tabla_ganancias_escala.importe_excedente; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tabla_ganancias_escala.importe_excedente IS 'S/ Exced. de $';


--
-- Name: afip_tabla_ganancias_escala_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_tabla_ganancias_escala_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_tabla_ganancias_escala_id_seq OWNER TO runbot;

--
-- Name: afip_tabla_ganancias_escala_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_tabla_ganancias_escala_id_seq OWNED BY public.afip_tabla_ganancias_escala.id;


--
-- Name: afip_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_tax (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_tax OWNER TO runbot;

--
-- Name: TABLE afip_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_tax IS 'afip.tax';


--
-- Name: COLUMN afip_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_uid IS 'Created by';


--
-- Name: COLUMN afip_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_tax.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.code IS 'Code';


--
-- Name: COLUMN afip_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.name IS 'Name';


--
-- Name: COLUMN afip_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.active IS 'Active';


--
-- Name: COLUMN afip_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_date IS 'Created on';


--
-- Name: COLUMN afip_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_date IS 'Last Updated on';


--
-- Name: afip_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_tax_id_seq OWNER TO runbot;

--
-- Name: afip_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_tax_id_seq OWNED BY public.afip_tax.id;


--
-- Name: algolia_field; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.algolia_field (
    id integer NOT NULL,
    priority integer,
    field_id integer NOT NULL,
    sub_field_id integer,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    searchable boolean,
    unordered boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.algolia_field OWNER TO runbot;

--
-- Name: TABLE algolia_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.algolia_field IS 'Algolia Attribute';


--
-- Name: COLUMN algolia_field.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.priority IS 'Priority';


--
-- Name: COLUMN algolia_field.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.field_id IS 'Field';


--
-- Name: COLUMN algolia_field.sub_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.sub_field_id IS 'Sub Campo';


--
-- Name: COLUMN algolia_field.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.model_id IS 'Model';


--
-- Name: COLUMN algolia_field.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.create_uid IS 'Created by';


--
-- Name: COLUMN algolia_field.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.write_uid IS 'Last Updated by';


--
-- Name: COLUMN algolia_field.searchable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.searchable IS 'Searchable';


--
-- Name: COLUMN algolia_field.unordered; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.unordered IS 'Unordered';


--
-- Name: COLUMN algolia_field.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.create_date IS 'Created on';


--
-- Name: COLUMN algolia_field.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.algolia_field.write_date IS 'Last Updated on';


--
-- Name: algolia_field_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.algolia_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.algolia_field_id_seq OWNER TO runbot;

--
-- Name: algolia_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.algolia_field_id_seq OWNED BY public.algolia_field.id;


--
-- Name: applicant_get_refuse_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_get_refuse_reason (
    id integer NOT NULL,
    refuse_reason_id integer NOT NULL,
    template_id integer,
    create_uid integer,
    write_uid integer,
    send_mail boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.applicant_get_refuse_reason OWNER TO runbot;

--
-- Name: TABLE applicant_get_refuse_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_get_refuse_reason IS 'Get Refuse Reason';


--
-- Name: COLUMN applicant_get_refuse_reason.refuse_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.refuse_reason_id IS 'Refuse Reason';


--
-- Name: COLUMN applicant_get_refuse_reason.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.template_id IS 'Email Template';


--
-- Name: COLUMN applicant_get_refuse_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.create_uid IS 'Created by';


--
-- Name: COLUMN applicant_get_refuse_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN applicant_get_refuse_reason.send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.send_mail IS 'Send Email';


--
-- Name: COLUMN applicant_get_refuse_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.create_date IS 'Created on';


--
-- Name: COLUMN applicant_get_refuse_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.write_date IS 'Last Updated on';


--
-- Name: applicant_get_refuse_reason_hr_applicant_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_get_refuse_reason_hr_applicant_rel (
    applicant_get_refuse_reason_id integer NOT NULL,
    hr_applicant_id integer NOT NULL
);


ALTER TABLE public.applicant_get_refuse_reason_hr_applicant_rel OWNER TO runbot;

--
-- Name: TABLE applicant_get_refuse_reason_hr_applicant_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_get_refuse_reason_hr_applicant_rel IS 'RELATION BETWEEN applicant_get_refuse_reason AND hr_applicant';


--
-- Name: applicant_get_refuse_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.applicant_get_refuse_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.applicant_get_refuse_reason_id_seq OWNER TO runbot;

--
-- Name: applicant_get_refuse_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.applicant_get_refuse_reason_id_seq OWNED BY public.applicant_get_refuse_reason.id;


--
-- Name: applicant_send_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_send_mail (
    id integer NOT NULL,
    template_id integer,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.applicant_send_mail OWNER TO runbot;

--
-- Name: TABLE applicant_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_send_mail IS 'Send mails to applicants';


--
-- Name: COLUMN applicant_send_mail.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.template_id IS 'Mail Template';


--
-- Name: COLUMN applicant_send_mail.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.author_id IS 'Author';


--
-- Name: COLUMN applicant_send_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.create_uid IS 'Created by';


--
-- Name: COLUMN applicant_send_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN applicant_send_mail.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.lang IS 'Language';


--
-- Name: COLUMN applicant_send_mail.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.subject IS 'Subject';


--
-- Name: COLUMN applicant_send_mail.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.body IS 'Contents';


--
-- Name: COLUMN applicant_send_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.create_date IS 'Created on';


--
-- Name: COLUMN applicant_send_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.write_date IS 'Last Updated on';


--
-- Name: applicant_send_mail_hr_applicant_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_send_mail_hr_applicant_rel (
    applicant_send_mail_id integer NOT NULL,
    hr_applicant_id integer NOT NULL
);


ALTER TABLE public.applicant_send_mail_hr_applicant_rel OWNER TO runbot;

--
-- Name: TABLE applicant_send_mail_hr_applicant_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_send_mail_hr_applicant_rel IS 'RELATION BETWEEN applicant_send_mail AND hr_applicant';


--
-- Name: applicant_send_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.applicant_send_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.applicant_send_mail_id_seq OWNER TO runbot;

--
-- Name: applicant_send_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.applicant_send_mail_id_seq OWNED BY public.applicant_send_mail.id;


--
-- Name: approval_approver; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.approval_approver (
    id integer NOT NULL,
    sequence integer,
    user_id integer NOT NULL,
    request_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    status character varying,
    required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_approver OWNER TO runbot;

--
-- Name: TABLE approval_approver; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.approval_approver IS 'Approver';


--
-- Name: COLUMN approval_approver.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.sequence IS 'Sequence';


--
-- Name: COLUMN approval_approver.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.user_id IS 'User';


--
-- Name: COLUMN approval_approver.request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.request_id IS 'Request';


--
-- Name: COLUMN approval_approver.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.company_id IS 'Company';


--
-- Name: COLUMN approval_approver.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.create_uid IS 'Created by';


--
-- Name: COLUMN approval_approver.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_approver.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.status IS 'Status';


--
-- Name: COLUMN approval_approver.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.required IS 'Required';


--
-- Name: COLUMN approval_approver.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.create_date IS 'Created on';


--
-- Name: COLUMN approval_approver.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_approver.write_date IS 'Last Updated on';


--
-- Name: approval_approver_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.approval_approver_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_approver_id_seq OWNER TO runbot;

--
-- Name: approval_approver_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.approval_approver_id_seq OWNED BY public.approval_approver.id;


--
-- Name: approval_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.approval_category (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer,
    approval_minimum integer NOT NULL,
    sequence_id integer,
    create_uid integer,
    write_uid integer,
    has_date character varying NOT NULL,
    has_period character varying NOT NULL,
    has_quantity character varying NOT NULL,
    has_amount character varying NOT NULL,
    has_reference character varying NOT NULL,
    has_partner character varying NOT NULL,
    has_payment_method character varying NOT NULL,
    has_location character varying NOT NULL,
    has_product character varying NOT NULL,
    requirer_document character varying NOT NULL,
    approval_type character varying,
    manager_approval character varying,
    sequence_code character varying,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    approver_sequence boolean,
    automated_sequence boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_category OWNER TO runbot;

--
-- Name: TABLE approval_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.approval_category IS 'Approval Category';


--
-- Name: COLUMN approval_category.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.company_id IS 'Company';


--
-- Name: COLUMN approval_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.sequence IS 'Sequence';


--
-- Name: COLUMN approval_category.approval_minimum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.approval_minimum IS 'Minimum Approval';


--
-- Name: COLUMN approval_category.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.sequence_id IS 'Reference Sequence';


--
-- Name: COLUMN approval_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.create_uid IS 'Created by';


--
-- Name: COLUMN approval_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_category.has_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.has_date IS 'Has Date';


--
-- Name: COLUMN approval_category.has_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.has_period IS 'Has Period';


--
-- Name: COLUMN approval_category.has_quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.has_quantity IS 'Has Quantity';


--
-- Name: COLUMN approval_category.has_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.has_amount IS 'Has Amount';


--
-- Name: COLUMN approval_category.has_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.has_reference IS 'Has Reference';


--
-- Name: COLUMN approval_category.has_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.has_partner IS 'Has Contact';


--
-- Name: COLUMN approval_category.has_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.has_payment_method IS 'Has Payment';


--
-- Name: COLUMN approval_category.has_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.has_location IS 'Has Location';


--
-- Name: COLUMN approval_category.has_product; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.has_product IS 'Has Product';


--
-- Name: COLUMN approval_category.requirer_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.requirer_document IS 'Documents';


--
-- Name: COLUMN approval_category.approval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.approval_type IS 'Approval Type';


--
-- Name: COLUMN approval_category.manager_approval; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.manager_approval IS 'Employee''s Manager';


--
-- Name: COLUMN approval_category.sequence_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.sequence_code IS 'Code';


--
-- Name: COLUMN approval_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.name IS 'Name';


--
-- Name: COLUMN approval_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.description IS 'Description';


--
-- Name: COLUMN approval_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.active IS 'Active';


--
-- Name: COLUMN approval_category.approver_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.approver_sequence IS 'Approvers Sequence?';


--
-- Name: COLUMN approval_category.automated_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.automated_sequence IS 'Automated Sequence?';


--
-- Name: COLUMN approval_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.create_date IS 'Created on';


--
-- Name: COLUMN approval_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category.write_date IS 'Last Updated on';


--
-- Name: approval_category_approver; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.approval_category_approver (
    id integer NOT NULL,
    sequence integer,
    category_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.approval_category_approver OWNER TO runbot;

--
-- Name: TABLE approval_category_approver; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.approval_category_approver IS 'Approval Type Approver';


--
-- Name: COLUMN approval_category_approver.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category_approver.sequence IS 'Sequence';


--
-- Name: COLUMN approval_category_approver.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category_approver.category_id IS 'Approval Type';


--
-- Name: COLUMN approval_category_approver.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category_approver.user_id IS 'User';


--
-- Name: COLUMN approval_category_approver.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category_approver.create_uid IS 'Created by';


--
-- Name: COLUMN approval_category_approver.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category_approver.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_category_approver.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category_approver.required IS 'Required';


--
-- Name: COLUMN approval_category_approver.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category_approver.create_date IS 'Created on';


--
-- Name: COLUMN approval_category_approver.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_category_approver.write_date IS 'Last Updated on';


--
-- Name: approval_category_approver_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.approval_category_approver_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_category_approver_id_seq OWNER TO runbot;

--
-- Name: approval_category_approver_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.approval_category_approver_id_seq OWNED BY public.approval_category_approver.id;


--
-- Name: approval_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.approval_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_category_id_seq OWNER TO runbot;

--
-- Name: approval_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.approval_category_id_seq OWNED BY public.approval_category.id;


--
-- Name: approval_product_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.approval_product_line (
    id integer NOT NULL,
    approval_request_id integer NOT NULL,
    company_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    description character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    quantity double precision,
    purchase_order_line_id integer,
    warehouse_id integer
);


ALTER TABLE public.approval_product_line OWNER TO runbot;

--
-- Name: TABLE approval_product_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.approval_product_line IS 'Product Line';


--
-- Name: COLUMN approval_product_line.approval_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.approval_request_id IS 'Approval Request';


--
-- Name: COLUMN approval_product_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.company_id IS 'Company';


--
-- Name: COLUMN approval_product_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.product_id IS 'Products';


--
-- Name: COLUMN approval_product_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN approval_product_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.create_uid IS 'Created by';


--
-- Name: COLUMN approval_product_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_product_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.description IS 'Description';


--
-- Name: COLUMN approval_product_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.create_date IS 'Created on';


--
-- Name: COLUMN approval_product_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN approval_product_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.quantity IS 'Quantity';


--
-- Name: COLUMN approval_product_line.purchase_order_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.purchase_order_line_id IS 'Purchase Order Line';


--
-- Name: COLUMN approval_product_line.warehouse_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_product_line.warehouse_id IS 'Warehouse';


--
-- Name: approval_product_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.approval_product_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_product_line_id_seq OWNER TO runbot;

--
-- Name: approval_product_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.approval_product_line_id_seq OWNED BY public.approval_product_line.id;


--
-- Name: approval_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.approval_request (
    id integer NOT NULL,
    message_main_attachment_id integer,
    category_id integer NOT NULL,
    company_id integer,
    partner_id integer,
    request_owner_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    location character varying,
    reference character varying,
    request_status character varying,
    reason text,
    date timestamp without time zone,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    date_confirmed timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    quantity double precision,
    amount double precision
);


ALTER TABLE public.approval_request OWNER TO runbot;

--
-- Name: TABLE approval_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.approval_request IS 'Approval Request';


--
-- Name: COLUMN approval_request.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN approval_request.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.category_id IS 'Category';


--
-- Name: COLUMN approval_request.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.company_id IS 'Company';


--
-- Name: COLUMN approval_request.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.partner_id IS 'Contact';


--
-- Name: COLUMN approval_request.request_owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.request_owner_id IS 'Request Owner';


--
-- Name: COLUMN approval_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.create_uid IS 'Created by';


--
-- Name: COLUMN approval_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN approval_request.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.name IS 'Approval Subject';


--
-- Name: COLUMN approval_request.location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.location IS 'Location';


--
-- Name: COLUMN approval_request.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.reference IS 'Reference';


--
-- Name: COLUMN approval_request.request_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.request_status IS 'Request Status';


--
-- Name: COLUMN approval_request.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.reason IS 'Description';


--
-- Name: COLUMN approval_request.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.date IS 'Date';


--
-- Name: COLUMN approval_request.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.date_start IS 'Date start';


--
-- Name: COLUMN approval_request.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.date_end IS 'Date end';


--
-- Name: COLUMN approval_request.date_confirmed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.date_confirmed IS 'Date Confirmed';


--
-- Name: COLUMN approval_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.create_date IS 'Created on';


--
-- Name: COLUMN approval_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.write_date IS 'Last Updated on';


--
-- Name: COLUMN approval_request.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.quantity IS 'Quantity';


--
-- Name: COLUMN approval_request.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.approval_request.amount IS 'Amount';


--
-- Name: approval_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.approval_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.approval_request_id_seq OWNER TO runbot;

--
-- Name: approval_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.approval_request_id_seq OWNED BY public.approval_request.id;


--
-- Name: arba_cot_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.arba_cot_wizard (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tipo_recorrido character varying NOT NULL,
    patente_vehiculo character varying,
    patente_acoplado character varying,
    prod_no_term_dev character varying NOT NULL,
    datetime_out timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    importe double precision
);


ALTER TABLE public.arba_cot_wizard OWNER TO runbot;

--
-- Name: TABLE arba_cot_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.arba_cot_wizard IS 'arba.cot.wizard';


--
-- Name: COLUMN arba_cot_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.partner_id IS 'Transportista';


--
-- Name: COLUMN arba_cot_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN arba_cot_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN arba_cot_wizard.tipo_recorrido; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.tipo_recorrido IS 'Tipo Recorrido';


--
-- Name: COLUMN arba_cot_wizard.patente_vehiculo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.patente_vehiculo IS 'Patente Vehiculo';


--
-- Name: COLUMN arba_cot_wizard.patente_acoplado; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.patente_acoplado IS 'Patente Acoplado';


--
-- Name: COLUMN arba_cot_wizard.prod_no_term_dev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.prod_no_term_dev IS 'Productos no terminados / devoluciones';


--
-- Name: COLUMN arba_cot_wizard.datetime_out; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.datetime_out IS 'Datetime Out';


--
-- Name: COLUMN arba_cot_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.create_date IS 'Created on';


--
-- Name: COLUMN arba_cot_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN arba_cot_wizard.importe; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.importe IS 'Importe Neto';


--
-- Name: arba_cot_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.arba_cot_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.arba_cot_wizard_id_seq OWNER TO runbot;

--
-- Name: arba_cot_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.arba_cot_wizard_id_seq OWNED BY public.arba_cot_wizard.id;


--
-- Name: asset_modify; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.asset_modify (
    id integer NOT NULL,
    asset_id integer NOT NULL,
    method_number integer NOT NULL,
    account_asset_id integer,
    account_asset_counterpart_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    create_uid integer,
    write_uid integer,
    method_period character varying,
    modify_action character varying,
    date date,
    name text,
    value_residual numeric,
    salvage_value numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.asset_modify OWNER TO runbot;

--
-- Name: TABLE asset_modify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.asset_modify IS 'Modify Asset';


--
-- Name: COLUMN asset_modify.asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.asset_id IS 'Asset';


--
-- Name: COLUMN asset_modify.method_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.method_number IS 'Duration';


--
-- Name: COLUMN asset_modify.account_asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_asset_id IS 'Gross Increase Account';


--
-- Name: COLUMN asset_modify.account_asset_counterpart_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_asset_counterpart_id IS 'Asset Counterpart Account';


--
-- Name: COLUMN asset_modify.account_depreciation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN asset_modify.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN asset_modify.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.create_uid IS 'Created by';


--
-- Name: COLUMN asset_modify.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.write_uid IS 'Last Updated by';


--
-- Name: COLUMN asset_modify.method_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN asset_modify.modify_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.modify_action IS 'Action';


--
-- Name: COLUMN asset_modify.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.date IS 'Date';


--
-- Name: COLUMN asset_modify.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.name IS 'Note';


--
-- Name: COLUMN asset_modify.value_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.value_residual IS 'Depreciable Amount';


--
-- Name: COLUMN asset_modify.salvage_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.salvage_value IS 'Not Depreciable Amount';


--
-- Name: COLUMN asset_modify.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.create_date IS 'Created on';


--
-- Name: COLUMN asset_modify.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.write_date IS 'Last Updated on';


--
-- Name: asset_modify_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.asset_modify_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.asset_modify_id_seq OWNER TO runbot;

--
-- Name: asset_modify_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.asset_modify_id_seq OWNED BY public.asset_modify.id;


--
-- Name: asset_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.asset_move_line_rel (
    asset_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.asset_move_line_rel OWNER TO runbot;

--
-- Name: TABLE asset_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.asset_move_line_rel IS 'RELATION BETWEEN account_asset AND account_move_line';


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: badge_unlocked_definition_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.badge_unlocked_definition_rel (
    gamification_badge_id integer NOT NULL,
    gamification_goal_definition_id integer NOT NULL
);


ALTER TABLE public.badge_unlocked_definition_rel OWNER TO runbot;

--
-- Name: TABLE badge_unlocked_definition_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.badge_unlocked_definition_rel IS 'RELATION BETWEEN gamification_badge AND gamification_goal_definition';


--
-- Name: barcode_nomenclature; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_nomenclature (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying(32) NOT NULL,
    upc_ean_conv character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    gs1_separator_fnc1 character varying,
    is_gs1_nomenclature boolean
);


ALTER TABLE public.barcode_nomenclature OWNER TO runbot;

--
-- Name: TABLE barcode_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_nomenclature IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_nomenclature.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_nomenclature.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.name IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.upc_ean_conv; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.upc_ean_conv IS 'UPC/EAN Conversion';


--
-- Name: COLUMN barcode_nomenclature.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_date IS 'Created on';


--
-- Name: COLUMN barcode_nomenclature.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_nomenclature.gs1_separator_fnc1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.gs1_separator_fnc1 IS 'FNC1 Separator';


--
-- Name: COLUMN barcode_nomenclature.is_gs1_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.is_gs1_nomenclature IS 'Is GS1 Nomenclature';


--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_nomenclature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNER TO runbot;

--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNED BY public.barcode_nomenclature.id;


--
-- Name: barcode_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_rule (
    id integer NOT NULL,
    barcode_nomenclature_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying(32) NOT NULL,
    encoding character varying NOT NULL,
    type character varying NOT NULL,
    pattern character varying NOT NULL,
    alias character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    associated_uom_id integer,
    gs1_content_type character varying,
    gs1_decimal_usage boolean
);


ALTER TABLE public.barcode_rule OWNER TO runbot;

--
-- Name: TABLE barcode_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_rule IS 'Barcode Rule';


--
-- Name: COLUMN barcode_rule.barcode_nomenclature_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.barcode_nomenclature_id IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.sequence IS 'Sequence';


--
-- Name: COLUMN barcode_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.name IS 'Rule Name';


--
-- Name: COLUMN barcode_rule.encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.encoding IS 'Encoding';


--
-- Name: COLUMN barcode_rule.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.type IS 'Type';


--
-- Name: COLUMN barcode_rule.pattern; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.pattern IS 'Barcode Pattern';


--
-- Name: COLUMN barcode_rule.alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.alias IS 'Alias';


--
-- Name: COLUMN barcode_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_date IS 'Created on';


--
-- Name: COLUMN barcode_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_rule.associated_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.associated_uom_id IS 'Associated Uom';


--
-- Name: COLUMN barcode_rule.gs1_content_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_content_type IS 'GS1 Content Type';


--
-- Name: COLUMN barcode_rule.gs1_decimal_usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_decimal_usage IS 'Decimal';


--
-- Name: barcode_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_rule_id_seq OWNER TO runbot;

--
-- Name: barcode_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_rule_id_seq OWNED BY public.barcode_rule.id;


--
-- Name: base_automation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation (
    id integer NOT NULL,
    action_server_id integer NOT NULL,
    trg_date_id integer,
    trg_date_range integer,
    trg_date_calendar_id integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    trg_date_range_type character varying,
    filter_pre_domain character varying,
    filter_domain character varying,
    active boolean,
    last_run timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    trg_date_resource_field_id integer
);


ALTER TABLE public.base_automation OWNER TO runbot;

--
-- Name: TABLE base_automation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation IS 'Automated Action';


--
-- Name: COLUMN base_automation.action_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.action_server_id IS 'Server Actions';


--
-- Name: COLUMN base_automation.trg_date_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_id IS 'Trigger Date';


--
-- Name: COLUMN base_automation.trg_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_range IS 'Delay after trigger date';


--
-- Name: COLUMN base_automation.trg_date_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_calendar_id IS 'Use Calendar';


--
-- Name: COLUMN base_automation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trigger IS 'Trigger';


--
-- Name: COLUMN base_automation.trg_date_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_range_type IS 'Delay type';


--
-- Name: COLUMN base_automation.filter_pre_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.filter_pre_domain IS 'Before Update Domain';


--
-- Name: COLUMN base_automation.filter_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.filter_domain IS 'Apply on';


--
-- Name: COLUMN base_automation.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.active IS 'Active';


--
-- Name: COLUMN base_automation.last_run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.last_run IS 'Last Run';


--
-- Name: COLUMN base_automation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.create_date IS 'Created on';


--
-- Name: COLUMN base_automation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_automation.trg_date_resource_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_resource_field_id IS 'Use employee work schedule';


--
-- Name: base_automation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_automation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_id_seq OWNER TO runbot;

--
-- Name: base_automation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_automation_id_seq OWNED BY public.base_automation.id;


--
-- Name: base_automation_ir_model_fields_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_ir_model_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_ir_model_fields_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_ir_model_fields_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_ir_model_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_automation_onchange_fields_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_onchange_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_onchange_fields_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_onchange_fields_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_onchange_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_automation_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    base_automation_id integer NOT NULL
);


ALTER TABLE public.base_automation_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND base_automation';


--
-- Name: base_cache_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_geo_provider; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_geo_provider (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tech_name character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_geo_provider OWNER TO runbot;

--
-- Name: TABLE base_geo_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_geo_provider IS 'Geo Provider';


--
-- Name: COLUMN base_geo_provider.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.create_uid IS 'Created by';


--
-- Name: COLUMN base_geo_provider.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_geo_provider.tech_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.tech_name IS 'Tech Name';


--
-- Name: COLUMN base_geo_provider.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.name IS 'Name';


--
-- Name: COLUMN base_geo_provider.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.create_date IS 'Created on';


--
-- Name: COLUMN base_geo_provider.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.write_date IS 'Last Updated on';


--
-- Name: base_geo_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_geo_provider_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_geo_provider_id_seq OWNER TO runbot;

--
-- Name: base_geo_provider_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_geo_provider_id_seq OWNED BY public.base_geo_provider.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_match; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_match (
    id integer NOT NULL,
    sequence integer,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    model_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_match OWNER TO runbot;

--
-- Name: TABLE base_import_match; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_match IS 'Deduplicate settings prior to CSV imports.';


--
-- Name: COLUMN base_import_match.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match.sequence IS 'Sequence';


--
-- Name: COLUMN base_import_match.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match.model_id IS 'Model';


--
-- Name: COLUMN base_import_match.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_match.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_match.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match.name IS 'Name';


--
-- Name: COLUMN base_import_match.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match.model_name IS 'Model name';


--
-- Name: COLUMN base_import_match.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match.create_date IS 'Created on';


--
-- Name: COLUMN base_import_match.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match.write_date IS 'Last Updated on';


--
-- Name: base_import_match_field; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_match_field (
    id integer NOT NULL,
    field_id integer NOT NULL,
    match_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    imported_value character varying,
    conditional boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_match_field OWNER TO runbot;

--
-- Name: TABLE base_import_match_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_match_field IS 'Field import match definition';


--
-- Name: COLUMN base_import_match_field.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match_field.field_id IS 'Field';


--
-- Name: COLUMN base_import_match_field.match_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match_field.match_id IS 'Match';


--
-- Name: COLUMN base_import_match_field.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match_field.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_match_field.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match_field.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_match_field.imported_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match_field.imported_value IS 'Imported Value';


--
-- Name: COLUMN base_import_match_field.conditional; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match_field.conditional IS 'Conditional';


--
-- Name: COLUMN base_import_match_field.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match_field.create_date IS 'Created on';


--
-- Name: COLUMN base_import_match_field.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_match_field.write_date IS 'Last Updated on';


--
-- Name: base_import_match_field_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_match_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_match_field_id_seq OWNER TO runbot;

--
-- Name: base_import_match_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_match_field_id_seq OWNED BY public.base_import_match_field.id;


--
-- Name: base_import_match_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_match_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_match_id_seq OWNER TO runbot;

--
-- Name: base_import_match_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_match_id_seq OWNED BY public.base_import_match.id;


--
-- Name: base_import_tests_models_char; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char IS 'Tests : Base Import Model, Character';


--
-- Name: COLUMN base_import_tests_models_char.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_id_seq OWNED BY public.base_import_tests_models_char.id;


--
-- Name: base_import_tests_models_char_noreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_noreadonly (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_noreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_noreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_noreadonly IS 'Tests : Base Import Model, Character No readonly';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_noreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_noreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_noreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_noreadonly_id_seq OWNED BY public.base_import_tests_models_char_noreadonly.id;


--
-- Name: base_import_tests_models_char_readonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_readonly (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_readonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_readonly IS 'Tests : Base Import Model, Character readonly';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_readonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_readonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_readonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_readonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_readonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_readonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_readonly_id_seq OWNED BY public.base_import_tests_models_char_readonly.id;


--
-- Name: base_import_tests_models_char_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_required (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_required IS 'Tests : Base Import Model, Character required';


--
-- Name: COLUMN base_import_tests_models_char_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_required_id_seq OWNED BY public.base_import_tests_models_char_required.id;


--
-- Name: base_import_tests_models_char_states; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_states (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_states OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_states; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_states IS 'Tests : Base Import Model, Character states';


--
-- Name: COLUMN base_import_tests_models_char_states.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_states.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_states.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_states.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_states.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_states.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_states_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_states_id_seq OWNED BY public.base_import_tests_models_char_states.id;


--
-- Name: base_import_tests_models_char_stillreadonly; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_char_stillreadonly (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_char_stillreadonly OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_char_stillreadonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_char_stillreadonly IS 'Tests : Base Import Model, Character still readonly';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_char_stillreadonly.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_char_stillreadonly.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_char_stillreadonly_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_char_stillreadonly_id_seq OWNED BY public.base_import_tests_models_char_stillreadonly.id;


--
-- Name: base_import_tests_models_complex; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_complex (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    c character varying,
    d date,
    m numeric,
    dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    f double precision
);


ALTER TABLE public.base_import_tests_models_complex OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_complex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_complex IS 'Tests: Base Import Model Complex';


--
-- Name: COLUMN base_import_tests_models_complex.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_complex.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_complex.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_complex.c; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.c IS 'C';


--
-- Name: COLUMN base_import_tests_models_complex.d; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.d IS 'D';


--
-- Name: COLUMN base_import_tests_models_complex.m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.m IS 'M';


--
-- Name: COLUMN base_import_tests_models_complex.dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.dt IS 'Dt';


--
-- Name: COLUMN base_import_tests_models_complex.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_complex.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_tests_models_complex.f; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_complex.f IS 'F';


--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_complex_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_complex_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_complex_id_seq OWNED BY public.base_import_tests_models_complex.id;


--
-- Name: base_import_tests_models_float; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_float (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    value2 numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


ALTER TABLE public.base_import_tests_models_float OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_float IS 'Tests: Base Import Model Float';


--
-- Name: COLUMN base_import_tests_models_float.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.currency_id IS 'Currency';


--
-- Name: COLUMN base_import_tests_models_float.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_float.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_float.value2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value2 IS 'Value2';


--
-- Name: COLUMN base_import_tests_models_float.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_float.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_tests_models_float.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_float.value IS 'Value';


--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_float_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_float_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_float_id_seq OWNED BY public.base_import_tests_models_float.id;


--
-- Name: base_import_tests_models_m2o; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o IS 'Tests : Base Import Model, Many to One';


--
-- Name: COLUMN base_import_tests_models_m2o.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_id_seq OWNED BY public.base_import_tests_models_m2o.id;


--
-- Name: base_import_tests_models_m2o_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_related IS 'Tests : Base Import Model, Many to One related';


--
-- Name: COLUMN base_import_tests_models_m2o_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_related_id_seq OWNED BY public.base_import_tests_models_m2o_related.id;


--
-- Name: base_import_tests_models_m2o_required; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required (
    id integer NOT NULL,
    value integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required IS 'Tests : Base Import Model, Many to One required';


--
-- Name: COLUMN base_import_tests_models_m2o_required.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_id_seq OWNED BY public.base_import_tests_models_m2o_required.id;


--
-- Name: base_import_tests_models_m2o_required_related; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_m2o_required_related (
    id integer NOT NULL,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_m2o_required_related OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_m2o_required_related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_m2o_required_related IS 'Tests : Base Import Model, Many to One required related';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_m2o_required_related.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_m2o_required_related.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_m2o_required_related_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_m2o_required_related_id_seq OWNED BY public.base_import_tests_models_m2o_required_related.id;


--
-- Name: base_import_tests_models_o2m; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m IS 'Tests : Base Import Model, One to Many';


--
-- Name: COLUMN base_import_tests_models_o2m.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_o2m.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_o2m_child (
    id integer NOT NULL,
    parent_id integer,
    value integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_o2m_child OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_o2m_child; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_o2m_child IS 'Tests : Base Import Model, One to Many child';


--
-- Name: COLUMN base_import_tests_models_o2m_child.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.parent_id IS 'Parent';


--
-- Name: COLUMN base_import_tests_models_o2m_child.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.value IS 'Value';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_o2m_child.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_o2m_child.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_o2m_child.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_child_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_child_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_child_id_seq OWNED BY public.base_import_tests_models_o2m_child.id;


--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_o2m_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_o2m_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_o2m_id_seq OWNED BY public.base_import_tests_models_o2m.id;


--
-- Name: base_import_tests_models_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_tests_models_preview (
    id integer NOT NULL,
    somevalue integer NOT NULL,
    othervalue integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_tests_models_preview OWNER TO runbot;

--
-- Name: TABLE base_import_tests_models_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_tests_models_preview IS 'Tests : Base Import Model Preview';


--
-- Name: COLUMN base_import_tests_models_preview.somevalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.somevalue IS 'Some Value';


--
-- Name: COLUMN base_import_tests_models_preview.othervalue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.othervalue IS 'Other Variable';


--
-- Name: COLUMN base_import_tests_models_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_tests_models_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_tests_models_preview.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.name IS 'Name';


--
-- Name: COLUMN base_import_tests_models_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.create_date IS 'Created on';


--
-- Name: COLUMN base_import_tests_models_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_tests_models_preview.write_date IS 'Last Updated on';


--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_tests_models_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNER TO runbot;

--
-- Name: base_import_tests_models_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_tests_models_preview_id_seq OWNED BY public.base_import_tests_models_preview.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying(6) NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_language_install_website_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install_website_rel (
    base_language_install_id integer NOT NULL,
    website_id integer NOT NULL
);


ALTER TABLE public.base_language_install_website_rel OWNER TO runbot;

--
-- Name: TABLE base_language_install_website_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install_website_rel IS 'RELATION BETWEEN base_language_install AND website';


--
-- Name: base_module_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install OWNER TO runbot;

--
-- Name: TABLE base_module_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install IS 'Module Install';


--
-- Name: COLUMN base_module_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.show_all IS 'Show All';


--
-- Name: COLUMN base_module_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_date IS 'Last Updated on';


--
-- Name: base_module_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_id_seq OWNER TO runbot;

--
-- Name: base_module_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_id_seq OWNED BY public.base_module_install.id;


--
-- Name: base_module_install_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_ir_module_module_rel (
    base_module_install_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_install_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_install_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_ir_module_module_rel IS 'RELATION BETWEEN base_module_install AND ir_module_module';


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    confirm_input integer
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_module_uninstall.confirm_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.confirm_input IS 'Confirm Input';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    guest_id integer,
    CONSTRAINT bus_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN bus_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.guest_id IS 'Guest';


--
-- Name: CONSTRAINT bus_presence_partner_or_guest_exists ON bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT bus_presence_partner_or_guest_exists ON public.bus_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm (
    id integer NOT NULL,
    duration integer NOT NULL,
    duration_minutes integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    alarm_type character varying NOT NULL,
    "interval" character varying NOT NULL,
    name jsonb NOT NULL,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer
);


ALTER TABLE public.calendar_alarm OWNER TO runbot;

--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm IS 'Event Alarm';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration IS 'Remind Before';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.mail_template_id IS 'Email Template';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.alarm_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.alarm_type IS 'Type';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.body IS 'Additional Message';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_alarm.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.sms_template_id IS 'SMS Template';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.calendar_alarm_calendar_event_rel OWNER TO runbot;

--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_alarm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_alarm_id_seq OWNER TO runbot;

--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_alarm_id_seq OWNED BY public.calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_attendee (
    id integer NOT NULL,
    event_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    common_name character varying,
    access_token character varying,
    state character varying,
    availability character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_attendee OWNER TO runbot;

--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_attendee IS 'Calendar Attendee Information';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.partner_id IS 'Attendee';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.common_name IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.availability IS 'Available/Busy';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_attendee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_attendee_id_seq OWNER TO runbot;

--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_attendee_id_seq OWNED BY public.calendar_attendee.id;


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event (
    id integer NOT NULL,
    message_main_attachment_id integer,
    user_id integer,
    videocall_channel_id integer,
    res_id integer,
    res_model_id integer,
    recurrence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location character varying,
    videocall_location character varying,
    access_token character varying,
    privacy character varying NOT NULL,
    show_as character varying NOT NULL,
    res_model character varying,
    start_date date,
    stop_date date,
    description text,
    active boolean,
    allday boolean,
    recurrency boolean,
    follow_recurrence boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision,
    opportunity_id integer,
    applicant_id integer
);


ALTER TABLE public.calendar_event OWNER TO runbot;

--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event IS 'Calendar Event';


--
-- Name: COLUMN calendar_event.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.user_id IS 'Organizer';


--
-- Name: COLUMN calendar_event.videocall_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_channel_id IS 'Discuss Channel';


--
-- Name: COLUMN calendar_event.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_id IS 'Document ID';


--
-- Name: COLUMN calendar_event.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model_id IS 'Document Model';


--
-- Name: COLUMN calendar_event.recurrence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrence_id IS 'Recurrence Rule';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.videocall_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_location IS 'Meeting URL';


--
-- Name: COLUMN calendar_event.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_event.privacy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.privacy IS 'Privacy';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.show_as IS 'Show as';


--
-- Name: COLUMN calendar_event.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model IS 'Document Model Name';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.follow_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.follow_recurrence IS 'Follow Recurrence';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start IS 'Start';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop IS 'Stop';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.duration IS 'Duration';


--
-- Name: COLUMN calendar_event.opportunity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.opportunity_id IS 'Opportunity';


--
-- Name: COLUMN calendar_event.applicant_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.applicant_id IS 'Applicant';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_id_seq OWNER TO runbot;

--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_id_seq OWNED BY public.calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_res_partner_rel (
    res_partner_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


ALTER TABLE public.calendar_event_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_res_partner_rel IS 'RELATION BETWEEN res_partner AND calendar_event';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_event_type OWNER TO runbot;

--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_type IS 'Event Meeting Type';


--
-- Name: COLUMN calendar_event_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.color IS 'Color';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_type_id_seq OWNER TO runbot;

--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_type_id_seq OWNED BY public.calendar_event_type.id;


--
-- Name: calendar_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_filters (
    id integer NOT NULL,
    user_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    partner_checked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_filters OWNER TO runbot;

--
-- Name: TABLE calendar_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_filters IS 'Calendar Filters';


--
-- Name: COLUMN calendar_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.user_id IS 'Me';


--
-- Name: COLUMN calendar_filters.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_id IS 'Employee';


--
-- Name: COLUMN calendar_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.active IS 'Active';


--
-- Name: COLUMN calendar_filters.partner_checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_checked IS 'Checked';


--
-- Name: COLUMN calendar_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_date IS 'Created on';


--
-- Name: COLUMN calendar_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_date IS 'Last Updated on';


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_filters_id_seq OWNER TO runbot;

--
-- Name: calendar_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_filters_id_seq OWNED BY public.calendar_filters.id;


--
-- Name: calendar_provider_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_provider_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    external_calendar_provider character varying,
    cal_client_id character varying,
    cal_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_provider_config OWNER TO runbot;

--
-- Name: TABLE calendar_provider_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_provider_config IS 'Calendar Provider Configuration Wizard';


--
-- Name: COLUMN calendar_provider_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_provider_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_provider_config.external_calendar_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.external_calendar_provider IS 'Choose an external calendar to configure';


--
-- Name: COLUMN calendar_provider_config.cal_client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_id IS 'Google Client_id';


--
-- Name: COLUMN calendar_provider_config.cal_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_secret IS 'Google Client_key';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN calendar_provider_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_date IS 'Created on';


--
-- Name: COLUMN calendar_provider_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_date IS 'Last Updated on';


--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_provider_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_provider_config_id_seq OWNER TO runbot;

--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_provider_config_id_seq OWNED BY public.calendar_provider_config.id;


--
-- Name: calendar_recurrence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_recurrence (
    id integer NOT NULL,
    base_event_id integer,
    "interval" integer,
    count integer,
    day integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    event_tz character varying,
    rrule character varying,
    rrule_type character varying,
    end_type character varying,
    month_by character varying,
    weekday character varying,
    byday character varying,
    until date,
    mon boolean,
    tue boolean,
    wed boolean,
    thu boolean,
    fri boolean,
    sat boolean,
    sun boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT calendar_recurrence_month_day CHECK ((((rrule_type)::text <> 'monthly'::text) OR ((month_by)::text <> 'day'::text) OR ((day >= 1) AND (day <= 31)) OR (((weekday)::text = ANY ((ARRAY['MON'::character varying, 'TUE'::character varying, 'WED'::character varying, 'THU'::character varying, 'FRI'::character varying, 'SAT'::character varying, 'SUN'::character varying])::text[])) AND ((byday)::text = ANY ((ARRAY['1'::character varying, '2'::character varying, '3'::character varying, '4'::character varying, '-1'::character varying])::text[])))))
);


ALTER TABLE public.calendar_recurrence OWNER TO runbot;

--
-- Name: TABLE calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_recurrence IS 'Event Recurrence Rule';


--
-- Name: COLUMN calendar_recurrence.base_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.base_event_id IS 'Base Event';


--
-- Name: COLUMN calendar_recurrence."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence."interval" IS 'Interval';


--
-- Name: COLUMN calendar_recurrence.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.count IS 'Count';


--
-- Name: COLUMN calendar_recurrence.day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.day IS 'Day';


--
-- Name: COLUMN calendar_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_recurrence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.name IS 'Name';


--
-- Name: COLUMN calendar_recurrence.event_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.event_tz IS 'Timezone';


--
-- Name: COLUMN calendar_recurrence.rrule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule IS 'Rrule';


--
-- Name: COLUMN calendar_recurrence.rrule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule_type IS 'Rrule Type';


--
-- Name: COLUMN calendar_recurrence.end_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.end_type IS 'End Type';


--
-- Name: COLUMN calendar_recurrence.month_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.month_by IS 'Month By';


--
-- Name: COLUMN calendar_recurrence.weekday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.weekday IS 'Weekday';


--
-- Name: COLUMN calendar_recurrence.byday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.byday IS 'By day';


--
-- Name: COLUMN calendar_recurrence.until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.until IS 'Repeat Until';


--
-- Name: COLUMN calendar_recurrence.mon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.mon IS 'Mon';


--
-- Name: COLUMN calendar_recurrence.tue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.tue IS 'Tue';


--
-- Name: COLUMN calendar_recurrence.wed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.wed IS 'Wed';


--
-- Name: COLUMN calendar_recurrence.thu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.thu IS 'Thu';


--
-- Name: COLUMN calendar_recurrence.fri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.fri IS 'Fri';


--
-- Name: COLUMN calendar_recurrence.sat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sat IS 'Sat';


--
-- Name: COLUMN calendar_recurrence.sun; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sun IS 'Sun';


--
-- Name: COLUMN calendar_recurrence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN calendar_recurrence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT calendar_recurrence_month_day ON calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT calendar_recurrence_month_day ON public.calendar_recurrence IS 'CHECK (rrule_type != ''monthly'' OR month_by != ''day'' OR day >= 1 AND day <= 31 OR weekday in (''MON'', ''TUE'', ''WED'', ''THU'', ''FRI'', ''SAT'', ''SUN'') AND byday in (''1'', ''2'', ''3'', ''4'', ''-1''))';


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_recurrence_id_seq OWNER TO runbot;

--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_recurrence_id_seq OWNED BY public.calendar_recurrence.id;


--
-- Name: cashbox_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cashbox_journal_rel (
    cashbox_id integer NOT NULL,
    journal_id integer NOT NULL
);


ALTER TABLE public.cashbox_journal_rel OWNER TO runbot;

--
-- Name: TABLE cashbox_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cashbox_journal_rel IS 'RELATION BETWEEN account_cashbox AND account_journal';


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: change_production_qty; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_production_qty (
    id integer NOT NULL,
    mo_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    product_qty numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_production_qty OWNER TO runbot;

--
-- Name: TABLE change_production_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_production_qty IS 'Change Production Qty';


--
-- Name: COLUMN change_production_qty.mo_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.mo_id IS 'Manufacturing Order';


--
-- Name: COLUMN change_production_qty.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.create_uid IS 'Created by';


--
-- Name: COLUMN change_production_qty.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_production_qty.product_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.product_qty IS 'Quantity To Produce';


--
-- Name: COLUMN change_production_qty.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.create_date IS 'Created on';


--
-- Name: COLUMN change_production_qty.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.write_date IS 'Last Updated on';


--
-- Name: change_production_qty_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_production_qty_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_production_qty_id_seq OWNER TO runbot;

--
-- Name: change_production_qty_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_production_qty_id_seq OWNED BY public.change_production_qty.id;


--
-- Name: choose_delivery_carrier; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.choose_delivery_carrier (
    id integer NOT NULL,
    order_id integer NOT NULL,
    carrier_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    delivery_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    delivery_price double precision,
    display_price double precision
);


ALTER TABLE public.choose_delivery_carrier OWNER TO runbot;

--
-- Name: TABLE choose_delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.choose_delivery_carrier IS 'Delivery Carrier Selection Wizard';


--
-- Name: COLUMN choose_delivery_carrier.order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.order_id IS 'Order';


--
-- Name: COLUMN choose_delivery_carrier.carrier_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.carrier_id IS 'Shipping Method';


--
-- Name: COLUMN choose_delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN choose_delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN choose_delivery_carrier.delivery_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_message IS 'Delivery Message';


--
-- Name: COLUMN choose_delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN choose_delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: COLUMN choose_delivery_carrier.delivery_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_price IS 'Delivery Price';


--
-- Name: COLUMN choose_delivery_carrier.display_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.display_price IS 'Cost';


--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.choose_delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.choose_delivery_carrier_id_seq OWNER TO runbot;

--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.choose_delivery_carrier_id_seq OWNED BY public.choose_delivery_carrier.id;


--
-- Name: choose_delivery_package; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.choose_delivery_package (
    id integer NOT NULL,
    picking_id integer,
    delivery_package_type_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    shipping_weight double precision
);


ALTER TABLE public.choose_delivery_package OWNER TO runbot;

--
-- Name: TABLE choose_delivery_package; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.choose_delivery_package IS 'Delivery Package Selection Wizard';


--
-- Name: COLUMN choose_delivery_package.picking_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.picking_id IS 'Picking';


--
-- Name: COLUMN choose_delivery_package.delivery_package_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.delivery_package_type_id IS 'Delivery Package Type';


--
-- Name: COLUMN choose_delivery_package.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.create_uid IS 'Created by';


--
-- Name: COLUMN choose_delivery_package.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.write_uid IS 'Last Updated by';


--
-- Name: COLUMN choose_delivery_package.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.create_date IS 'Created on';


--
-- Name: COLUMN choose_delivery_package.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.write_date IS 'Last Updated on';


--
-- Name: COLUMN choose_delivery_package.shipping_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_package.shipping_weight IS 'Shipping Weight';


--
-- Name: choose_delivery_package_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.choose_delivery_package_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.choose_delivery_package_id_seq OWNER TO runbot;

--
-- Name: choose_delivery_package_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.choose_delivery_package_id_seq OWNED BY public.choose_delivery_package.id;


--
-- Name: cleanup_create_indexes_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_create_indexes_line (
    id integer NOT NULL,
    wizard_id integer,
    field_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    purged boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_create_indexes_line OWNER TO runbot;

--
-- Name: TABLE cleanup_create_indexes_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_create_indexes_line IS 'Cleanup Create Indexes line';


--
-- Name: COLUMN cleanup_create_indexes_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN cleanup_create_indexes_line.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_line.field_id IS 'Field';


--
-- Name: COLUMN cleanup_create_indexes_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_line.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_create_indexes_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_create_indexes_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_line.name IS 'Name';


--
-- Name: COLUMN cleanup_create_indexes_line.purged; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_line.purged IS 'Created';


--
-- Name: COLUMN cleanup_create_indexes_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_line.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_create_indexes_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_line.write_date IS 'Last Updated on';


--
-- Name: cleanup_create_indexes_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_create_indexes_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_create_indexes_line_id_seq OWNER TO runbot;

--
-- Name: cleanup_create_indexes_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_create_indexes_line_id_seq OWNED BY public.cleanup_create_indexes_line.id;


--
-- Name: cleanup_create_indexes_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_create_indexes_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_create_indexes_wizard OWNER TO runbot;

--
-- Name: TABLE cleanup_create_indexes_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_create_indexes_wizard IS 'Create indexes';


--
-- Name: COLUMN cleanup_create_indexes_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_create_indexes_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_create_indexes_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_wizard.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_create_indexes_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_create_indexes_wizard.write_date IS 'Last Updated on';


--
-- Name: cleanup_create_indexes_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_create_indexes_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_create_indexes_wizard_id_seq OWNER TO runbot;

--
-- Name: cleanup_create_indexes_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_create_indexes_wizard_id_seq OWNED BY public.cleanup_create_indexes_wizard.id;


--
-- Name: cleanup_purge_line_column; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_line_column (
    id integer NOT NULL,
    wizard_id integer,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    purged boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_line_column OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_line_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_line_column IS 'Cleanup Purge Line Column';


--
-- Name: COLUMN cleanup_purge_line_column.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_column.wizard_id IS 'Purge Wizard';


--
-- Name: COLUMN cleanup_purge_line_column.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_column.model_id IS 'Model';


--
-- Name: COLUMN cleanup_purge_line_column.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_column.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_line_column.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_line_column.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_column.name IS 'Name';


--
-- Name: COLUMN cleanup_purge_line_column.purged; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_column.purged IS 'Purged';


--
-- Name: COLUMN cleanup_purge_line_column.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_column.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_line_column.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_column.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_line_column_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_line_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_line_column_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_line_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_line_column_id_seq OWNED BY public.cleanup_purge_line_column.id;


--
-- Name: cleanup_purge_line_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_line_data (
    id integer NOT NULL,
    wizard_id integer,
    data_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    purged boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_line_data OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_line_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_line_data IS 'Cleanup Purge Line Data';


--
-- Name: COLUMN cleanup_purge_line_data.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_data.wizard_id IS 'Purge Wizard';


--
-- Name: COLUMN cleanup_purge_line_data.data_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_data.data_id IS 'Data entry';


--
-- Name: COLUMN cleanup_purge_line_data.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_data.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_line_data.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_data.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_line_data.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_data.name IS 'Name';


--
-- Name: COLUMN cleanup_purge_line_data.purged; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_data.purged IS 'Purged';


--
-- Name: COLUMN cleanup_purge_line_data.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_data.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_line_data.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_data.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_line_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_line_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_line_data_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_line_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_line_data_id_seq OWNED BY public.cleanup_purge_line_data.id;


--
-- Name: cleanup_purge_line_field; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_line_field (
    id integer NOT NULL,
    wizard_id integer,
    field_id integer,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    model_name character varying,
    purged boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_line_field OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_line_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_line_field IS 'Purge fields';


--
-- Name: COLUMN cleanup_purge_line_field.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.wizard_id IS 'Purge Wizard';


--
-- Name: COLUMN cleanup_purge_line_field.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.field_id IS 'Field';


--
-- Name: COLUMN cleanup_purge_line_field.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.model_id IS 'Model';


--
-- Name: COLUMN cleanup_purge_line_field.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_line_field.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_line_field.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.name IS 'Name';


--
-- Name: COLUMN cleanup_purge_line_field.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.model_name IS 'Model Technical Name';


--
-- Name: COLUMN cleanup_purge_line_field.purged; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.purged IS 'Purged';


--
-- Name: COLUMN cleanup_purge_line_field.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_line_field.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_field.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_line_field_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_line_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_line_field_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_line_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_line_field_id_seq OWNED BY public.cleanup_purge_line_field.id;


--
-- Name: cleanup_purge_line_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_line_menu (
    id integer NOT NULL,
    wizard_id integer,
    menu_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    purged boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_line_menu OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_line_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_line_menu IS 'Cleanup Purge Line Menu';


--
-- Name: COLUMN cleanup_purge_line_menu.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_menu.wizard_id IS 'Purge Wizard';


--
-- Name: COLUMN cleanup_purge_line_menu.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_menu.menu_id IS 'Menu entry';


--
-- Name: COLUMN cleanup_purge_line_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_menu.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_line_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_line_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_menu.name IS 'Name';


--
-- Name: COLUMN cleanup_purge_line_menu.purged; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_menu.purged IS 'Purged';


--
-- Name: COLUMN cleanup_purge_line_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_menu.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_line_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_menu.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_line_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_line_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_line_menu_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_line_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_line_menu_id_seq OWNED BY public.cleanup_purge_line_menu.id;


--
-- Name: cleanup_purge_line_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_line_model (
    id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    purged boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_line_model OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_line_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_line_model IS 'Cleanup Purge Line Model';


--
-- Name: COLUMN cleanup_purge_line_model.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_model.wizard_id IS 'Purge Wizard';


--
-- Name: COLUMN cleanup_purge_line_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_model.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_line_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_line_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_model.name IS 'Name';


--
-- Name: COLUMN cleanup_purge_line_model.purged; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_model.purged IS 'Purged';


--
-- Name: COLUMN cleanup_purge_line_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_model.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_line_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_model.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_line_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_line_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_line_model_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_line_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_line_model_id_seq OWNED BY public.cleanup_purge_line_model.id;


--
-- Name: cleanup_purge_line_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_line_module (
    id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    purged boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_line_module OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_line_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_line_module IS 'Cleanup Purge Line Module';


--
-- Name: COLUMN cleanup_purge_line_module.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_module.wizard_id IS 'Purge Wizard';


--
-- Name: COLUMN cleanup_purge_line_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_module.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_line_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_line_module.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_module.name IS 'Name';


--
-- Name: COLUMN cleanup_purge_line_module.purged; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_module.purged IS 'Purged';


--
-- Name: COLUMN cleanup_purge_line_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_module.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_line_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_module.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_line_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_line_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_line_module_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_line_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_line_module_id_seq OWNED BY public.cleanup_purge_line_module.id;


--
-- Name: cleanup_purge_line_property; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_line_property (
    id integer NOT NULL,
    wizard_id integer,
    property_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    reason character varying,
    purged boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_line_property OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_line_property; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_line_property IS 'Cleanup Purge Line Property';


--
-- Name: COLUMN cleanup_purge_line_property.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_property.wizard_id IS 'Purge Wizard';


--
-- Name: COLUMN cleanup_purge_line_property.property_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_property.property_id IS 'Property';


--
-- Name: COLUMN cleanup_purge_line_property.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_property.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_line_property.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_line_property.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_property.name IS 'Name';


--
-- Name: COLUMN cleanup_purge_line_property.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_property.reason IS 'Reason';


--
-- Name: COLUMN cleanup_purge_line_property.purged; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_property.purged IS 'Purged';


--
-- Name: COLUMN cleanup_purge_line_property.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_property.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_line_property.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_property.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_line_property_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_line_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_line_property_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_line_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_line_property_id_seq OWNED BY public.cleanup_purge_line_property.id;


--
-- Name: cleanup_purge_line_table; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_line_table (
    id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    table_type character varying,
    purged boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_line_table OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_line_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_line_table IS 'Cleanup Purge Line Table';


--
-- Name: COLUMN cleanup_purge_line_table.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_table.wizard_id IS 'Purge Wizard';


--
-- Name: COLUMN cleanup_purge_line_table.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_table.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_line_table.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_table.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_line_table.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_table.name IS 'Name';


--
-- Name: COLUMN cleanup_purge_line_table.table_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_table.table_type IS 'Table Type';


--
-- Name: COLUMN cleanup_purge_line_table.purged; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_table.purged IS 'Purged';


--
-- Name: COLUMN cleanup_purge_line_table.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_table.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_line_table.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_line_table.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_line_table_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_line_table_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_line_table_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_line_table_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_line_table_id_seq OWNED BY public.cleanup_purge_line_table.id;


--
-- Name: cleanup_purge_wizard_column; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_wizard_column (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_wizard_column OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_wizard_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_wizard_column IS 'Purge columns';


--
-- Name: COLUMN cleanup_purge_wizard_column.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_column.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_wizard_column.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_wizard_column.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_column.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_wizard_column.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_column.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_wizard_column_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_wizard_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_wizard_column_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_wizard_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_wizard_column_id_seq OWNED BY public.cleanup_purge_wizard_column.id;


--
-- Name: cleanup_purge_wizard_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_wizard_data (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_wizard_data OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_wizard_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_wizard_data IS 'Purge data';


--
-- Name: COLUMN cleanup_purge_wizard_data.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_data.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_wizard_data.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_data.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_wizard_data.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_data.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_wizard_data.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_data.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_wizard_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_wizard_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_wizard_data_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_wizard_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_wizard_data_id_seq OWNED BY public.cleanup_purge_wizard_data.id;


--
-- Name: cleanup_purge_wizard_field; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_wizard_field (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_wizard_field OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_wizard_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_wizard_field IS 'Purge fields';


--
-- Name: COLUMN cleanup_purge_wizard_field.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_field.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_wizard_field.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_field.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_wizard_field.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_field.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_wizard_field.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_field.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_wizard_field_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_wizard_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_wizard_field_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_wizard_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_wizard_field_id_seq OWNED BY public.cleanup_purge_wizard_field.id;


--
-- Name: cleanup_purge_wizard_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_wizard_menu (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_wizard_menu OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_wizard_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_wizard_menu IS 'Purge menus';


--
-- Name: COLUMN cleanup_purge_wizard_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_menu.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_wizard_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_wizard_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_menu.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_wizard_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_menu.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_wizard_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_wizard_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_wizard_menu_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_wizard_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_wizard_menu_id_seq OWNED BY public.cleanup_purge_wizard_menu.id;


--
-- Name: cleanup_purge_wizard_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_wizard_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_wizard_model OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_wizard_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_wizard_model IS 'Purge models';


--
-- Name: COLUMN cleanup_purge_wizard_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_model.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_wizard_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_wizard_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_model.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_wizard_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_model.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_wizard_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_wizard_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_wizard_model_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_wizard_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_wizard_model_id_seq OWNED BY public.cleanup_purge_wizard_model.id;


--
-- Name: cleanup_purge_wizard_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_wizard_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_wizard_module OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_wizard_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_wizard_module IS 'Purge modules';


--
-- Name: COLUMN cleanup_purge_wizard_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_module.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_wizard_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_wizard_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_module.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_wizard_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_module.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_wizard_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_wizard_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_wizard_module_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_wizard_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_wizard_module_id_seq OWNED BY public.cleanup_purge_wizard_module.id;


--
-- Name: cleanup_purge_wizard_property; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_wizard_property (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_wizard_property OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_wizard_property; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_wizard_property IS 'Purge properties';


--
-- Name: COLUMN cleanup_purge_wizard_property.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_property.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_wizard_property.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_property.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_wizard_property.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_property.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_wizard_property.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_property.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_wizard_property_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_wizard_property_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_wizard_property_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_wizard_property_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_wizard_property_id_seq OWNED BY public.cleanup_purge_wizard_property.id;


--
-- Name: cleanup_purge_wizard_table; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cleanup_purge_wizard_table (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.cleanup_purge_wizard_table OWNER TO runbot;

--
-- Name: TABLE cleanup_purge_wizard_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cleanup_purge_wizard_table IS 'Purge tables';


--
-- Name: COLUMN cleanup_purge_wizard_table.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_table.create_uid IS 'Created by';


--
-- Name: COLUMN cleanup_purge_wizard_table.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_table.write_uid IS 'Last Updated by';


--
-- Name: COLUMN cleanup_purge_wizard_table.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_table.create_date IS 'Created on';


--
-- Name: COLUMN cleanup_purge_wizard_table.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.cleanup_purge_wizard_table.write_date IS 'Last Updated on';


--
-- Name: cleanup_purge_wizard_table_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.cleanup_purge_wizard_table_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.cleanup_purge_wizard_table_id_seq OWNER TO runbot;

--
-- Name: cleanup_purge_wizard_table_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.cleanup_purge_wizard_table_id_seq OWNED BY public.cleanup_purge_wizard_table.id;


--
-- Name: compliance_letter_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.compliance_letter_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.compliance_letter_wizard OWNER TO runbot;

--
-- Name: TABLE compliance_letter_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.compliance_letter_wizard IS 'Compliance Letter for EXO Number';


--
-- Name: COLUMN compliance_letter_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.compliance_letter_wizard.company_id IS 'Company';


--
-- Name: COLUMN compliance_letter_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.compliance_letter_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN compliance_letter_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.compliance_letter_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN compliance_letter_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.compliance_letter_wizard.create_date IS 'Created on';


--
-- Name: COLUMN compliance_letter_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.compliance_letter_wizard.write_date IS 'Last Updated on';


--
-- Name: compliance_letter_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.compliance_letter_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.compliance_letter_wizard_id_seq OWNER TO runbot;

--
-- Name: compliance_letter_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.compliance_letter_wizard_id_seq OWNED BY public.compliance_letter_wizard.id;


--
-- Name: confirm_stock_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.confirm_stock_sms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.confirm_stock_sms OWNER TO runbot;

--
-- Name: TABLE confirm_stock_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.confirm_stock_sms IS 'Confirm Stock SMS';


--
-- Name: COLUMN confirm_stock_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_uid IS 'Created by';


--
-- Name: COLUMN confirm_stock_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN confirm_stock_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_date IS 'Created on';


--
-- Name: COLUMN confirm_stock_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_date IS 'Last Updated on';


--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.confirm_stock_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNER TO runbot;

--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNED BY public.confirm_stock_sms.id;


--
-- Name: consolidation_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_account (
    id integer NOT NULL,
    chart_id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying(64),
    currency_mode character varying NOT NULL,
    invert_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    additional_domain character varying
);


ALTER TABLE public.consolidation_account OWNER TO runbot;

--
-- Name: TABLE consolidation_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_account IS 'Consolidation account';


--
-- Name: COLUMN consolidation_account.chart_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.chart_id IS 'Consolidation';


--
-- Name: COLUMN consolidation_account.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.sequence IS 'Sequence';


--
-- Name: COLUMN consolidation_account.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.group_id IS 'Group';


--
-- Name: COLUMN consolidation_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.create_uid IS 'Created by';


--
-- Name: COLUMN consolidation_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN consolidation_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.name IS 'Name';


--
-- Name: COLUMN consolidation_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.code IS 'Code';


--
-- Name: COLUMN consolidation_account.currency_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.currency_mode IS 'Currency Conversion Method';


--
-- Name: COLUMN consolidation_account.invert_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.invert_sign IS 'Invert Balance Sign';


--
-- Name: COLUMN consolidation_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.create_date IS 'Created on';


--
-- Name: COLUMN consolidation_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN consolidation_account.additional_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_account.additional_domain IS 'Additional Domain';


--
-- Name: consolidation_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.consolidation_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.consolidation_account_id_seq OWNER TO runbot;

--
-- Name: consolidation_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.consolidation_account_id_seq OWNED BY public.consolidation_account.id;


--
-- Name: consolidation_accounts_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_accounts_rel (
    used_in_ids integer NOT NULL,
    using_ids integer NOT NULL
);


ALTER TABLE public.consolidation_accounts_rel OWNER TO runbot;

--
-- Name: TABLE consolidation_accounts_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_accounts_rel IS 'RELATION BETWEEN consolidation_account AND consolidation_account';


--
-- Name: consolidation_chart; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_chart (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    invert_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.consolidation_chart OWNER TO runbot;

--
-- Name: TABLE consolidation_chart; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_chart IS 'Consolidation chart';


--
-- Name: COLUMN consolidation_chart.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_chart.currency_id IS 'Target Currency';


--
-- Name: COLUMN consolidation_chart.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_chart.color IS 'Color Index';


--
-- Name: COLUMN consolidation_chart.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_chart.create_uid IS 'Created by';


--
-- Name: COLUMN consolidation_chart.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_chart.write_uid IS 'Last Updated by';


--
-- Name: COLUMN consolidation_chart.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_chart.name IS 'Consolidation Name';


--
-- Name: COLUMN consolidation_chart.invert_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_chart.invert_sign IS 'Invert Balance Sign';


--
-- Name: COLUMN consolidation_chart.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_chart.create_date IS 'Created on';


--
-- Name: COLUMN consolidation_chart.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_chart.write_date IS 'Last Updated on';


--
-- Name: consolidation_chart_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.consolidation_chart_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.consolidation_chart_id_seq OWNER TO runbot;

--
-- Name: consolidation_chart_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.consolidation_chart_id_seq OWNED BY public.consolidation_chart.id;


--
-- Name: consolidation_chart_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_chart_res_company_rel (
    consolidation_chart_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.consolidation_chart_res_company_rel OWNER TO runbot;

--
-- Name: TABLE consolidation_chart_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_chart_res_company_rel IS 'RELATION BETWEEN consolidation_chart AND res_company';


--
-- Name: consolidation_company_period; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_company_period (
    id integer NOT NULL,
    period_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    consolidation_method character varying NOT NULL,
    date_company_begin date NOT NULL,
    date_company_end date NOT NULL,
    currency_rate_avg numeric,
    currency_rate_end numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rate_control double precision NOT NULL,
    rate_ownership double precision NOT NULL,
    rate_consolidation double precision NOT NULL
);


ALTER TABLE public.consolidation_company_period OWNER TO runbot;

--
-- Name: TABLE consolidation_company_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_company_period IS 'Consolidation Company Period';


--
-- Name: COLUMN consolidation_company_period.period_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.period_id IS 'Period';


--
-- Name: COLUMN consolidation_company_period.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.company_id IS 'Company';


--
-- Name: COLUMN consolidation_company_period.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.create_uid IS 'Created by';


--
-- Name: COLUMN consolidation_company_period.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.write_uid IS 'Last Updated by';


--
-- Name: COLUMN consolidation_company_period.consolidation_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.consolidation_method IS 'Consolidation Method';


--
-- Name: COLUMN consolidation_company_period.date_company_begin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.date_company_begin IS 'Start Date';


--
-- Name: COLUMN consolidation_company_period.date_company_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.date_company_end IS 'End Date';


--
-- Name: COLUMN consolidation_company_period.currency_rate_avg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.currency_rate_avg IS 'Average Currency Rate';


--
-- Name: COLUMN consolidation_company_period.currency_rate_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.currency_rate_end IS 'End Currency Rate';


--
-- Name: COLUMN consolidation_company_period.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.create_date IS 'Created on';


--
-- Name: COLUMN consolidation_company_period.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.write_date IS 'Last Updated on';


--
-- Name: COLUMN consolidation_company_period.rate_control; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.rate_control IS 'Rate Control';


--
-- Name: COLUMN consolidation_company_period.rate_ownership; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.rate_ownership IS 'Rate Ownership';


--
-- Name: COLUMN consolidation_company_period.rate_consolidation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_company_period.rate_consolidation IS 'Consolidation Rate';


--
-- Name: consolidation_company_period_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.consolidation_company_period_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.consolidation_company_period_id_seq OWNER TO runbot;

--
-- Name: consolidation_company_period_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.consolidation_company_period_id_seq OWNED BY public.consolidation_company_period.id;


--
-- Name: consolidation_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_group (
    id integer NOT NULL,
    chart_id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    parent_path character varying,
    show_on_dashboard boolean,
    invert_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.consolidation_group OWNER TO runbot;

--
-- Name: TABLE consolidation_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_group IS 'Consolidation Group';


--
-- Name: COLUMN consolidation_group.chart_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.chart_id IS 'Consolidation';


--
-- Name: COLUMN consolidation_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.sequence IS 'Sequence';


--
-- Name: COLUMN consolidation_group.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.parent_id IS 'Parent';


--
-- Name: COLUMN consolidation_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.create_uid IS 'Created by';


--
-- Name: COLUMN consolidation_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN consolidation_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.name IS 'Name';


--
-- Name: COLUMN consolidation_group.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.parent_path IS 'Parent Path';


--
-- Name: COLUMN consolidation_group.show_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.show_on_dashboard IS 'Show On Dashboard';


--
-- Name: COLUMN consolidation_group.invert_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.invert_sign IS 'Invert Balance Sign';


--
-- Name: COLUMN consolidation_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.create_date IS 'Created on';


--
-- Name: COLUMN consolidation_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_group.write_date IS 'Last Updated on';


--
-- Name: consolidation_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.consolidation_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.consolidation_group_id_seq OWNER TO runbot;

--
-- Name: consolidation_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.consolidation_group_id_seq OWNED BY public.consolidation_group.id;


--
-- Name: consolidation_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_journal (
    id integer NOT NULL,
    period_id integer,
    chart_id integer NOT NULL,
    company_period_id integer,
    composition_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    auto_generated boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.consolidation_journal OWNER TO runbot;

--
-- Name: TABLE consolidation_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_journal IS 'Consolidation Journal';


--
-- Name: COLUMN consolidation_journal.period_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.period_id IS 'Analysis Period';


--
-- Name: COLUMN consolidation_journal.chart_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.chart_id IS 'Chart';


--
-- Name: COLUMN consolidation_journal.company_period_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.company_period_id IS 'Company Period';


--
-- Name: COLUMN consolidation_journal.composition_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.composition_id IS 'Consolidation Period';


--
-- Name: COLUMN consolidation_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.create_uid IS 'Created by';


--
-- Name: COLUMN consolidation_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN consolidation_journal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.name IS 'Name';


--
-- Name: COLUMN consolidation_journal.auto_generated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.auto_generated IS 'Automatically Generated';


--
-- Name: COLUMN consolidation_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.create_date IS 'Created on';


--
-- Name: COLUMN consolidation_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal.write_date IS 'Last Updated on';


--
-- Name: consolidation_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.consolidation_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.consolidation_journal_id_seq OWNER TO runbot;

--
-- Name: consolidation_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.consolidation_journal_id_seq OWNED BY public.consolidation_journal.id;


--
-- Name: consolidation_journal_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_journal_line (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    account_id integer NOT NULL,
    group_id integer,
    period_id integer,
    create_uid integer,
    write_uid integer,
    note text,
    currency_amount numeric,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.consolidation_journal_line OWNER TO runbot;

--
-- Name: TABLE consolidation_journal_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_journal_line IS 'Consolidation journal line';


--
-- Name: COLUMN consolidation_journal_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.journal_id IS 'Journal';


--
-- Name: COLUMN consolidation_journal_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.account_id IS 'Consolidated Account';


--
-- Name: COLUMN consolidation_journal_line.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.group_id IS 'Group';


--
-- Name: COLUMN consolidation_journal_line.period_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.period_id IS 'Period';


--
-- Name: COLUMN consolidation_journal_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.create_uid IS 'Created by';


--
-- Name: COLUMN consolidation_journal_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN consolidation_journal_line.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.note IS 'Description';


--
-- Name: COLUMN consolidation_journal_line.currency_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.currency_amount IS 'Currency Amount';


--
-- Name: COLUMN consolidation_journal_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.amount IS 'Amount';


--
-- Name: COLUMN consolidation_journal_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.create_date IS 'Created on';


--
-- Name: COLUMN consolidation_journal_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_journal_line.write_date IS 'Last Updated on';


--
-- Name: consolidation_journal_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.consolidation_journal_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.consolidation_journal_line_id_seq OWNER TO runbot;

--
-- Name: consolidation_journal_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.consolidation_journal_line_id_seq OWNED BY public.consolidation_journal_line.id;


--
-- Name: consolidation_period; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_period (
    id integer NOT NULL,
    message_main_attachment_id integer,
    chart_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    date_analysis_begin date NOT NULL,
    date_analysis_end date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.consolidation_period OWNER TO runbot;

--
-- Name: TABLE consolidation_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_period IS 'Consolidation Period';


--
-- Name: COLUMN consolidation_period.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN consolidation_period.chart_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period.chart_id IS 'Consolidation';


--
-- Name: COLUMN consolidation_period.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period.create_uid IS 'Created by';


--
-- Name: COLUMN consolidation_period.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period.write_uid IS 'Last Updated by';


--
-- Name: COLUMN consolidation_period.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period.state IS 'State';


--
-- Name: COLUMN consolidation_period.date_analysis_begin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period.date_analysis_begin IS 'Start Date';


--
-- Name: COLUMN consolidation_period.date_analysis_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period.date_analysis_end IS 'End Date';


--
-- Name: COLUMN consolidation_period.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period.create_date IS 'Created on';


--
-- Name: COLUMN consolidation_period.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period.write_date IS 'Last Updated on';


--
-- Name: consolidation_period_composition; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_period_composition (
    id integer NOT NULL,
    composed_period_id integer NOT NULL,
    using_period_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    currency_rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rate_consolidation double precision NOT NULL
);


ALTER TABLE public.consolidation_period_composition OWNER TO runbot;

--
-- Name: TABLE consolidation_period_composition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_period_composition IS 'Consolidation Period Composition';


--
-- Name: COLUMN consolidation_period_composition.composed_period_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period_composition.composed_period_id IS 'Composed Analysis Period';


--
-- Name: COLUMN consolidation_period_composition.using_period_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period_composition.using_period_id IS 'Analysis Period Using This';


--
-- Name: COLUMN consolidation_period_composition.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period_composition.create_uid IS 'Created by';


--
-- Name: COLUMN consolidation_period_composition.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period_composition.write_uid IS 'Last Updated by';


--
-- Name: COLUMN consolidation_period_composition.currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period_composition.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN consolidation_period_composition.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period_composition.create_date IS 'Created on';


--
-- Name: COLUMN consolidation_period_composition.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period_composition.write_date IS 'Last Updated on';


--
-- Name: COLUMN consolidation_period_composition.rate_consolidation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_period_composition.rate_consolidation IS 'Consolidation Rate';


--
-- Name: consolidation_period_composition_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.consolidation_period_composition_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.consolidation_period_composition_id_seq OWNER TO runbot;

--
-- Name: consolidation_period_composition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.consolidation_period_composition_id_seq OWNED BY public.consolidation_period_composition.id;


--
-- Name: consolidation_period_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.consolidation_period_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.consolidation_period_id_seq OWNER TO runbot;

--
-- Name: consolidation_period_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.consolidation_period_id_seq OWNED BY public.consolidation_period.id;


--
-- Name: consolidation_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.consolidation_rate (
    id integer NOT NULL,
    chart_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_start date NOT NULL,
    date_end date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rate double precision NOT NULL
);


ALTER TABLE public.consolidation_rate OWNER TO runbot;

--
-- Name: TABLE consolidation_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.consolidation_rate IS 'Consolidation Rate';


--
-- Name: COLUMN consolidation_rate.chart_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_rate.chart_id IS 'Consolidation';


--
-- Name: COLUMN consolidation_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_rate.company_id IS 'Company';


--
-- Name: COLUMN consolidation_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_rate.create_uid IS 'Created by';


--
-- Name: COLUMN consolidation_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN consolidation_rate.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_rate.date_start IS 'Start Date';


--
-- Name: COLUMN consolidation_rate.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_rate.date_end IS 'End Date';


--
-- Name: COLUMN consolidation_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_rate.create_date IS 'Created on';


--
-- Name: COLUMN consolidation_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_rate.write_date IS 'Last Updated on';


--
-- Name: COLUMN consolidation_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.consolidation_rate.rate IS 'Rate';


--
-- Name: consolidation_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.consolidation_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.consolidation_rate_id_seq OWNER TO runbot;

--
-- Name: consolidation_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.consolidation_rate_id_seq OWNED BY public.consolidation_rate.id;


--
-- Name: coupon_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.coupon_share (
    id integer NOT NULL,
    website_id integer NOT NULL,
    coupon_id integer,
    program_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    redirect character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.coupon_share OWNER TO runbot;

--
-- Name: TABLE coupon_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.coupon_share IS 'Create links that apply a coupon and redirect to a specific page';


--
-- Name: COLUMN coupon_share.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.website_id IS 'Website';


--
-- Name: COLUMN coupon_share.coupon_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.coupon_id IS 'Coupon';


--
-- Name: COLUMN coupon_share.program_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.program_id IS 'Program';


--
-- Name: COLUMN coupon_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.create_uid IS 'Created by';


--
-- Name: COLUMN coupon_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN coupon_share.redirect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.redirect IS 'Redirect';


--
-- Name: COLUMN coupon_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.create_date IS 'Created on';


--
-- Name: COLUMN coupon_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.write_date IS 'Last Updated on';


--
-- Name: coupon_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.coupon_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.coupon_share_id_seq OWNER TO runbot;

--
-- Name: coupon_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.coupon_share_id_seq OWNED BY public.coupon_share.id;


--
-- Name: crm_lead; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    message_main_attachment_id integer,
    message_bounce integer,
    user_id integer,
    team_id integer,
    company_id integer,
    stage_id integer,
    color integer,
    recurring_plan integer,
    partner_id integer,
    title integer,
    lang_id integer,
    state_id integer,
    country_id integer,
    lost_reason_id integer,
    create_uid integer,
    write_uid integer,
    phone_sanitized character varying,
    email_normalized character varying,
    email_cc character varying,
    name character varying NOT NULL,
    referred character varying,
    type character varying NOT NULL,
    priority character varying,
    contact_name character varying,
    partner_name character varying,
    function character varying,
    email_from character varying,
    phone character varying,
    mobile character varying,
    phone_state character varying,
    email_state character varying,
    website character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    date_deadline date,
    lead_properties jsonb,
    description text,
    expected_revenue numeric,
    prorated_revenue numeric,
    recurring_revenue numeric,
    recurring_revenue_monthly numeric,
    recurring_revenue_monthly_prorated numeric,
    active boolean,
    date_closed timestamp without time zone,
    date_action_last timestamp without time zone,
    date_open timestamp without time zone,
    date_last_stage_update timestamp without time zone,
    date_conversion timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    day_open double precision,
    day_close double precision,
    probability double precision,
    automated_probability double precision,
    won_status character varying,
    days_to_convert double precision,
    days_exceeding_closing double precision,
    response_id integer,
    event_lead_rule_id integer,
    event_id integer,
    reveal_id character varying,
    iap_enrich_done boolean,
    lead_mining_request_id integer,
    CONSTRAINT crm_lead_check_probability CHECK (((probability >= (0)::double precision) AND (probability <= (100)::double precision)))
);


ALTER TABLE public.crm_lead OWNER TO runbot;

--
-- Name: TABLE crm_lead; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead IS 'Lead/Opportunity';


--
-- Name: COLUMN crm_lead.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.campaign_id IS 'Campaign';


--
-- Name: COLUMN crm_lead.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.source_id IS 'Source';


--
-- Name: COLUMN crm_lead.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.medium_id IS 'Medium';


--
-- Name: COLUMN crm_lead.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN crm_lead.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.message_bounce IS 'Bounce';


--
-- Name: COLUMN crm_lead.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.company_id IS 'Company';


--
-- Name: COLUMN crm_lead.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.stage_id IS 'Stage';


--
-- Name: COLUMN crm_lead.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.color IS 'Color Index';


--
-- Name: COLUMN crm_lead.recurring_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_plan IS 'Recurring Plan';


--
-- Name: COLUMN crm_lead.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.title IS 'Title';


--
-- Name: COLUMN crm_lead.lang_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lang_id IS 'Language';


--
-- Name: COLUMN crm_lead.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.state_id IS 'State';


--
-- Name: COLUMN crm_lead.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.country_id IS 'Country';


--
-- Name: COLUMN crm_lead.lost_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lost_reason_id IS 'Lost Reason';


--
-- Name: COLUMN crm_lead.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead.phone_sanitized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN crm_lead.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN crm_lead.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_cc IS 'Email cc';


--
-- Name: COLUMN crm_lead.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.name IS 'Opportunity';


--
-- Name: COLUMN crm_lead.referred; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.referred IS 'Referred By';


--
-- Name: COLUMN crm_lead.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.type IS 'Type';


--
-- Name: COLUMN crm_lead.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.priority IS 'Priority';


--
-- Name: COLUMN crm_lead.contact_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.contact_name IS 'Contact Name';


--
-- Name: COLUMN crm_lead.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.partner_name IS 'Company Name';


--
-- Name: COLUMN crm_lead.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.function IS 'Job Position';


--
-- Name: COLUMN crm_lead.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_from IS 'Email';


--
-- Name: COLUMN crm_lead.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.phone IS 'Phone';


--
-- Name: COLUMN crm_lead.mobile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.mobile IS 'Mobile';


--
-- Name: COLUMN crm_lead.phone_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.phone_state IS 'Phone Quality';


--
-- Name: COLUMN crm_lead.email_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_state IS 'Email Quality';


--
-- Name: COLUMN crm_lead.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.website IS 'Website';


--
-- Name: COLUMN crm_lead.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.street IS 'Street';


--
-- Name: COLUMN crm_lead.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.street2 IS 'Street2';


--
-- Name: COLUMN crm_lead.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.zip IS 'Zip';


--
-- Name: COLUMN crm_lead.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.city IS 'City';


--
-- Name: COLUMN crm_lead.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_deadline IS 'Expected Closing';


--
-- Name: COLUMN crm_lead.lead_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lead_properties IS 'Properties';


--
-- Name: COLUMN crm_lead.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.description IS 'Notes';


--
-- Name: COLUMN crm_lead.expected_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.expected_revenue IS 'Expected Revenue';


--
-- Name: COLUMN crm_lead.prorated_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.prorated_revenue IS 'Prorated Revenue';


--
-- Name: COLUMN crm_lead.recurring_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue IS 'Recurring Revenues';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly IS 'Expected MRR';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly_prorated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly_prorated IS 'Prorated MRR';


--
-- Name: COLUMN crm_lead.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.active IS 'Active';


--
-- Name: COLUMN crm_lead.date_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_closed IS 'Closed Date';


--
-- Name: COLUMN crm_lead.date_action_last; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_action_last IS 'Last Action';


--
-- Name: COLUMN crm_lead.date_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_open IS 'Assignment Date';


--
-- Name: COLUMN crm_lead.date_last_stage_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN crm_lead.date_conversion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_conversion IS 'Conversion Date';


--
-- Name: COLUMN crm_lead.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_lead.day_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.day_open IS 'Days to Assign';


--
-- Name: COLUMN crm_lead.day_close; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.day_close IS 'Days to Close';


--
-- Name: COLUMN crm_lead.probability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.probability IS 'Probability';


--
-- Name: COLUMN crm_lead.automated_probability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.automated_probability IS 'Automated Probability';


--
-- Name: COLUMN crm_lead.won_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.won_status IS 'Is Won';


--
-- Name: COLUMN crm_lead.days_to_convert; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.days_to_convert IS 'Days To Convert';


--
-- Name: COLUMN crm_lead.days_exceeding_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.days_exceeding_closing IS 'Exceeded Closing Days';


--
-- Name: COLUMN crm_lead.response_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.response_id IS 'Response';


--
-- Name: COLUMN crm_lead.event_lead_rule_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.event_lead_rule_id IS 'Registration Rule';


--
-- Name: COLUMN crm_lead.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.event_id IS 'Source Event';


--
-- Name: COLUMN crm_lead.reveal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.reveal_id IS 'Reveal ID';


--
-- Name: COLUMN crm_lead.iap_enrich_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.iap_enrich_done IS 'Enrichment done';


--
-- Name: COLUMN crm_lead.lead_mining_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lead_mining_request_id IS 'Lead Mining Request';


--
-- Name: CONSTRAINT crm_lead_check_probability ON crm_lead; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT crm_lead_check_probability ON public.crm_lead IS 'check(probability >= 0 and probability <= 100)';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    email_cc character varying,
    email_to character varying,
    mail_tracking_needs_action boolean
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_message.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_cc IS 'Cc';


--
-- Name: COLUMN mail_message.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_to IS 'To';


--
-- Name: COLUMN mail_message.mail_tracking_needs_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_tracking_needs_action IS 'Mail Tracking Needs Action';


--
-- Name: crm_activity_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.crm_activity_report AS
 SELECT m.id,
    l.create_date AS lead_create_date,
    l.date_conversion,
    l.date_deadline,
    l.date_closed,
    m.subtype_id,
    m.mail_activity_type_id,
    m.author_id,
    m.date,
    m.body,
    l.id AS lead_id,
    l.user_id,
    l.team_id,
    l.country_id,
    l.company_id,
    l.stage_id,
    l.partner_id,
    l.type AS lead_type,
    l.active,
    l.won_status
   FROM (public.mail_message m
     JOIN public.crm_lead l ON ((m.res_id = l.id)))
  WHERE (((m.model)::text = 'crm.lead'::text) AND ((m.mail_activity_type_id IS NOT NULL) OR (m.subtype_id = 1)));


ALTER VIEW public.crm_activity_report OWNER TO runbot;

--
-- Name: crm_convert_lead_mass_lead_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_convert_lead_mass_lead_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_convert_lead_mass_lead_rel OWNER TO runbot;

--
-- Name: TABLE crm_convert_lead_mass_lead_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_convert_lead_mass_lead_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND crm_lead';


--
-- Name: crm_iap_lead_helpers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_helpers (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_helpers OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_helpers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_helpers IS 'Helper methods for crm_iap_mine modules';


--
-- Name: COLUMN crm_iap_lead_helpers.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_helpers.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_helpers.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_helpers.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_helpers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_helpers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_helpers_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_helpers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_helpers_id_seq OWNED BY public.crm_iap_lead_helpers.id;


--
-- Name: crm_iap_lead_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_industry (
    id integer NOT NULL,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    reveal_ids character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_industry OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_industry IS 'CRM IAP Lead Industry';


--
-- Name: COLUMN crm_iap_lead_industry.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.color IS 'Color Index';


--
-- Name: COLUMN crm_iap_lead_industry.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.sequence IS 'Sequence';


--
-- Name: COLUMN crm_iap_lead_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_industry.reveal_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.reveal_ids IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.name IS 'Industry';


--
-- Name: COLUMN crm_iap_lead_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_industry_crm_iap_lead_mining_request_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_iap_lead_industry_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_industry_crm_iap_lead_mining_request_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_iap_lead_industry';


--
-- Name: crm_iap_lead_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_industry_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_industry_id_seq OWNED BY public.crm_iap_lead_industry.id;


--
-- Name: crm_iap_lead_mining_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request (
    id integer NOT NULL,
    lead_number integer NOT NULL,
    team_id integer,
    user_id integer,
    company_size_min integer,
    company_size_max integer,
    contact_number integer,
    preferred_role_id integer,
    seniority_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    search_type character varying NOT NULL,
    error_type character varying,
    lead_type character varying NOT NULL,
    contact_filter_type character varying,
    filter_on_size boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_mining_request OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request IS 'CRM Lead Mining Request';


--
-- Name: COLUMN crm_iap_lead_mining_request.lead_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.lead_number IS 'Number of Leads';


--
-- Name: COLUMN crm_iap_lead_mining_request.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_iap_lead_mining_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_iap_lead_mining_request.company_size_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.company_size_min IS 'Size';


--
-- Name: COLUMN crm_iap_lead_mining_request.company_size_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.company_size_max IS 'Company Size Max';


--
-- Name: COLUMN crm_iap_lead_mining_request.contact_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.contact_number IS 'Number of Contacts';


--
-- Name: COLUMN crm_iap_lead_mining_request.preferred_role_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.preferred_role_id IS 'Preferred Role';


--
-- Name: COLUMN crm_iap_lead_mining_request.seniority_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.seniority_id IS 'Seniority';


--
-- Name: COLUMN crm_iap_lead_mining_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_mining_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_mining_request.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.name IS 'Request Number';


--
-- Name: COLUMN crm_iap_lead_mining_request.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.state IS 'Status';


--
-- Name: COLUMN crm_iap_lead_mining_request.search_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.search_type IS 'Target';


--
-- Name: COLUMN crm_iap_lead_mining_request.error_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.error_type IS 'Error Type';


--
-- Name: COLUMN crm_iap_lead_mining_request.lead_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.lead_type IS 'Type';


--
-- Name: COLUMN crm_iap_lead_mining_request.contact_filter_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.contact_filter_type IS 'Filter on';


--
-- Name: COLUMN crm_iap_lead_mining_request.filter_on_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.filter_on_size IS 'Filter on Size';


--
-- Name: COLUMN crm_iap_lead_mining_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_mining_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_mining_request_crm_iap_lead_role_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_iap_lead_role_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_crm_iap_lead_role_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_iap_lead_role';


--
-- Name: crm_iap_lead_mining_request_crm_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_crm_tag_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_tag_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_crm_tag_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_crm_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_crm_tag_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_tag';


--
-- Name: crm_iap_lead_mining_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_mining_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_mining_request_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_mining_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_mining_request_id_seq OWNED BY public.crm_iap_lead_mining_request.id;


--
-- Name: crm_iap_lead_mining_request_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_res_country_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_res_country_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_res_country_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND res_country';


--
-- Name: crm_iap_lead_mining_request_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_res_country_state_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_res_country_state_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND res_country_state';


--
-- Name: crm_iap_lead_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_role (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    reveal_id character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_role OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_role IS 'People Role';


--
-- Name: COLUMN crm_iap_lead_role.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.color IS 'Color Index';


--
-- Name: COLUMN crm_iap_lead_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_role.reveal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.reveal_id IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_role.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.name IS 'Role Name';


--
-- Name: COLUMN crm_iap_lead_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_role_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_role_id_seq OWNED BY public.crm_iap_lead_role.id;


--
-- Name: crm_iap_lead_seniority; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_seniority (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reveal_id character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_seniority OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_seniority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_seniority IS 'People Seniority';


--
-- Name: COLUMN crm_iap_lead_seniority.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_seniority.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_seniority.reveal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.reveal_id IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_seniority.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.name IS 'Name';


--
-- Name: COLUMN crm_iap_lead_seniority.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_seniority.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_seniority_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_seniority_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_seniority_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_seniority_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_seniority_id_seq OWNED BY public.crm_iap_lead_seniority.id;


--
-- Name: crm_lead2opportunity_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead2opportunity_partner (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    partner_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    action character varying,
    force_assignment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead2opportunity_partner OWNER TO runbot;

--
-- Name: TABLE crm_lead2opportunity_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead2opportunity_partner IS 'Convert Lead to Opportunity (not in mass)';


--
-- Name: COLUMN crm_lead2opportunity_partner.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead2opportunity_partner.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner.force_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.force_assignment IS 'Force assignment';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.write_date IS 'Last Updated on';


--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead2opportunity_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead2opportunity_partner_id_seq OWNER TO runbot;

--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead2opportunity_partner_id_seq OWNED BY public.crm_lead2opportunity_partner.id;


--
-- Name: crm_lead2opportunity_partner_mass; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead2opportunity_partner_mass (
    id integer NOT NULL,
    lead_id integer,
    partner_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    action character varying,
    force_assignment boolean,
    deduplicate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead2opportunity_partner_mass OWNER TO runbot;

--
-- Name: TABLE crm_lead2opportunity_partner_mass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead2opportunity_partner_mass IS 'Convert Lead to Opportunity (in mass)';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.force_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.force_assignment IS 'Force assignment';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.deduplicate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.deduplicate IS 'Apply deduplication';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.write_date IS 'Last Updated on';


--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq OWNER TO runbot;

--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq OWNED BY public.crm_lead2opportunity_partner_mass.id;


--
-- Name: crm_lead2opportunity_partner_mass_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead2opportunity_partner_mass_res_users_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.crm_lead2opportunity_partner_mass_res_users_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead2opportunity_partner_mass_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead2opportunity_partner_mass_res_users_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND res_users';


--
-- Name: crm_lead_convert2ticket; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_convert2ticket (
    id integer NOT NULL,
    lead_id integer,
    partner_id integer,
    team_id integer NOT NULL,
    ticket_type_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_convert2ticket OWNER TO runbot;

--
-- Name: TABLE crm_lead_convert2ticket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_convert2ticket IS 'Lead convert to Ticket';


--
-- Name: COLUMN crm_lead_convert2ticket.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.lead_id IS 'Lead';


--
-- Name: COLUMN crm_lead_convert2ticket.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead_convert2ticket.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.team_id IS 'Team';


--
-- Name: COLUMN crm_lead_convert2ticket.ticket_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.ticket_type_id IS 'Ticket Type';


--
-- Name: COLUMN crm_lead_convert2ticket.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_convert2ticket.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_convert2ticket.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_convert2ticket.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.write_date IS 'Last Updated on';


--
-- Name: crm_lead_convert2ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_convert2ticket_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_convert2ticket_id_seq OWNER TO runbot;

--
-- Name: crm_lead_convert2ticket_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_convert2ticket_id_seq OWNED BY public.crm_lead_convert2ticket.id;


--
-- Name: crm_lead_crm_lead2opportunity_partner_mass_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_mass_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND crm_lead';


--
-- Name: crm_lead_crm_lead2opportunity_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_crm_lead2opportunity_partner_rel (
    crm_lead2opportunity_partner_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_crm_lead2opportunity_partner_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_crm_lead2opportunity_partner_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner AND crm_lead';


--
-- Name: crm_lead_event_registration_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_event_registration_rel (
    event_registration_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_event_registration_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_event_registration_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_event_registration_rel IS 'RELATION BETWEEN event_registration AND crm_lead';


--
-- Name: crm_lead_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_id_seq OWNER TO runbot;

--
-- Name: crm_lead_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_id_seq OWNED BY public.crm_lead.id;


--
-- Name: crm_lead_lost; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_lost (
    id integer NOT NULL,
    lost_reason_id integer,
    create_uid integer,
    write_uid integer,
    lost_feedback text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_lost OWNER TO runbot;

--
-- Name: TABLE crm_lead_lost; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_lost IS 'Get Lost Reason';


--
-- Name: COLUMN crm_lead_lost.lost_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.lost_reason_id IS 'Lost Reason';


--
-- Name: COLUMN crm_lead_lost.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_lost.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_lost.lost_feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.lost_feedback IS 'Closing Note';


--
-- Name: COLUMN crm_lead_lost.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_lost.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.write_date IS 'Last Updated on';


--
-- Name: crm_lead_lost_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_lost_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_lost_id_seq OWNER TO runbot;

--
-- Name: crm_lead_lost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_lost_id_seq OWNED BY public.crm_lead_lost.id;


--
-- Name: crm_lead_pls_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_pls_update (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    pls_start_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_pls_update OWNER TO runbot;

--
-- Name: TABLE crm_lead_pls_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_pls_update IS 'Update the probabilities';


--
-- Name: COLUMN crm_lead_pls_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_pls_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_pls_update.pls_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.pls_start_date IS 'Pls Start Date';


--
-- Name: COLUMN crm_lead_pls_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_pls_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.write_date IS 'Last Updated on';


--
-- Name: crm_lead_pls_update_crm_lead_scoring_frequency_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel (
    crm_lead_pls_update_id integer NOT NULL,
    crm_lead_scoring_frequency_field_id integer NOT NULL
);


ALTER TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_pls_update_crm_lead_scoring_frequency_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel IS 'RELATION BETWEEN crm_lead_pls_update AND crm_lead_scoring_frequency_field';


--
-- Name: crm_lead_pls_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_pls_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_pls_update_id_seq OWNER TO runbot;

--
-- Name: crm_lead_pls_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_pls_update_id_seq OWNED BY public.crm_lead_pls_update.id;


--
-- Name: crm_lead_rental; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_rental (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_rental OWNER TO runbot;

--
-- Name: TABLE crm_lead_rental; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_rental IS 'Convert Lead to Rental Order';


--
-- Name: COLUMN crm_lead_rental.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead_rental.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead_rental.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_rental.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_rental.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.action IS 'Rental Customer';


--
-- Name: COLUMN crm_lead_rental.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_rental.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.write_date IS 'Last Updated on';


--
-- Name: crm_lead_rental_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_rental_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_rental_id_seq OWNER TO runbot;

--
-- Name: crm_lead_rental_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_rental_id_seq OWNED BY public.crm_lead_rental.id;


--
-- Name: crm_lead_scoring_frequency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_scoring_frequency (
    id integer NOT NULL,
    team_id integer,
    create_uid integer,
    write_uid integer,
    variable character varying,
    value character varying,
    won_count numeric,
    lost_count numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_scoring_frequency OWNER TO runbot;

--
-- Name: TABLE crm_lead_scoring_frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_scoring_frequency IS 'Lead Scoring Frequency';


--
-- Name: COLUMN crm_lead_scoring_frequency.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead_scoring_frequency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_scoring_frequency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_scoring_frequency.variable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.variable IS 'Variable';


--
-- Name: COLUMN crm_lead_scoring_frequency.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.value IS 'Value';


--
-- Name: COLUMN crm_lead_scoring_frequency.won_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.won_count IS 'Won Count';


--
-- Name: COLUMN crm_lead_scoring_frequency.lost_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.lost_count IS 'Lost Count';


--
-- Name: COLUMN crm_lead_scoring_frequency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_scoring_frequency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.write_date IS 'Last Updated on';


--
-- Name: crm_lead_scoring_frequency_field; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_scoring_frequency_field (
    id integer NOT NULL,
    field_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_scoring_frequency_field OWNER TO runbot;

--
-- Name: TABLE crm_lead_scoring_frequency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_scoring_frequency_field IS 'Fields that can be used for predictive lead scoring computation';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.field_id IS 'Field';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.write_date IS 'Last Updated on';


--
-- Name: crm_lead_scoring_frequency_field_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_scoring_frequency_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_scoring_frequency_field_id_seq OWNER TO runbot;

--
-- Name: crm_lead_scoring_frequency_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_scoring_frequency_field_id_seq OWNED BY public.crm_lead_scoring_frequency_field.id;


--
-- Name: crm_lead_scoring_frequency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_scoring_frequency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_scoring_frequency_id_seq OWNER TO runbot;

--
-- Name: crm_lead_scoring_frequency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_scoring_frequency_id_seq OWNED BY public.crm_lead_scoring_frequency.id;


--
-- Name: crm_lead_website_visitor_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_website_visitor_rel (
    crm_lead_id integer NOT NULL,
    website_visitor_id integer NOT NULL
);


ALTER TABLE public.crm_lead_website_visitor_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_website_visitor_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_website_visitor_rel IS 'RELATION BETWEEN crm_lead AND website_visitor';


--
-- Name: crm_lost_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lost_reason (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lost_reason OWNER TO runbot;

--
-- Name: TABLE crm_lost_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lost_reason IS 'Opp. Lost Reason';


--
-- Name: COLUMN crm_lost_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lost_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lost_reason.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.name IS 'Description';


--
-- Name: COLUMN crm_lost_reason.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.active IS 'Active';


--
-- Name: COLUMN crm_lost_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.create_date IS 'Created on';


--
-- Name: COLUMN crm_lost_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.write_date IS 'Last Updated on';


--
-- Name: crm_lost_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lost_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lost_reason_id_seq OWNER TO runbot;

--
-- Name: crm_lost_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lost_reason_id_seq OWNED BY public.crm_lost_reason.id;


--
-- Name: crm_merge_opportunity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_merge_opportunity (
    id integer NOT NULL,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_merge_opportunity OWNER TO runbot;

--
-- Name: TABLE crm_merge_opportunity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_merge_opportunity IS 'Merge Opportunities';


--
-- Name: COLUMN crm_merge_opportunity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_merge_opportunity.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_merge_opportunity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.create_uid IS 'Created by';


--
-- Name: COLUMN crm_merge_opportunity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_merge_opportunity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.create_date IS 'Created on';


--
-- Name: COLUMN crm_merge_opportunity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.write_date IS 'Last Updated on';


--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_merge_opportunity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_merge_opportunity_id_seq OWNER TO runbot;

--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_merge_opportunity_id_seq OWNED BY public.crm_merge_opportunity.id;


--
-- Name: crm_quotation_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_quotation_partner (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_quotation_partner OWNER TO runbot;

--
-- Name: TABLE crm_quotation_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_quotation_partner IS 'Create new or use existing Customer on new Quotation';


--
-- Name: COLUMN crm_quotation_partner.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_quotation_partner.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.partner_id IS 'Customer';


--
-- Name: COLUMN crm_quotation_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.create_uid IS 'Created by';


--
-- Name: COLUMN crm_quotation_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_quotation_partner.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.action IS 'Quotation Customer';


--
-- Name: COLUMN crm_quotation_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.create_date IS 'Created on';


--
-- Name: COLUMN crm_quotation_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.write_date IS 'Last Updated on';


--
-- Name: crm_quotation_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_quotation_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_quotation_partner_id_seq OWNER TO runbot;

--
-- Name: crm_quotation_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_quotation_partner_id_seq OWNED BY public.crm_quotation_partner.id;


--
-- Name: crm_recurring_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_recurring_plan (
    id integer NOT NULL,
    number_of_months integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT crm_recurring_plan_check_number_of_months CHECK ((number_of_months >= 0))
);


ALTER TABLE public.crm_recurring_plan OWNER TO runbot;

--
-- Name: TABLE crm_recurring_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_recurring_plan IS 'CRM Recurring revenue plans';


--
-- Name: COLUMN crm_recurring_plan.number_of_months; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.number_of_months IS '# Months';


--
-- Name: COLUMN crm_recurring_plan.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.sequence IS 'Sequence';


--
-- Name: COLUMN crm_recurring_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.create_uid IS 'Created by';


--
-- Name: COLUMN crm_recurring_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_recurring_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.name IS 'Plan Name';


--
-- Name: COLUMN crm_recurring_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.active IS 'Active';


--
-- Name: COLUMN crm_recurring_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.create_date IS 'Created on';


--
-- Name: COLUMN crm_recurring_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT crm_recurring_plan_check_number_of_months ON crm_recurring_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT crm_recurring_plan_check_number_of_months ON public.crm_recurring_plan IS 'CHECK(number_of_months >= 0)';


--
-- Name: crm_recurring_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_recurring_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_recurring_plan_id_seq OWNER TO runbot;

--
-- Name: crm_recurring_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_recurring_plan_id_seq OWNED BY public.crm_recurring_plan.id;


--
-- Name: crm_stage; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_stage (
    id integer NOT NULL,
    sequence integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    requirements text,
    is_won boolean,
    fold boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_stage OWNER TO runbot;

--
-- Name: TABLE crm_stage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_stage IS 'CRM Stages';


--
-- Name: COLUMN crm_stage.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.sequence IS 'Sequence';


--
-- Name: COLUMN crm_stage.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_stage.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.create_uid IS 'Created by';


--
-- Name: COLUMN crm_stage.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_stage.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.name IS 'Stage Name';


--
-- Name: COLUMN crm_stage.requirements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.requirements IS 'Requirements';


--
-- Name: COLUMN crm_stage.is_won; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.is_won IS 'Is Won Stage?';


--
-- Name: COLUMN crm_stage.fold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.fold IS 'Folded in Pipeline';


--
-- Name: COLUMN crm_stage.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.create_date IS 'Created on';


--
-- Name: COLUMN crm_stage.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.write_date IS 'Last Updated on';


--
-- Name: crm_stage_crm_team_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_stage_crm_team_rel (
    crm_stage_id integer NOT NULL,
    crm_team_id integer NOT NULL
);


ALTER TABLE public.crm_stage_crm_team_rel OWNER TO runbot;

--
-- Name: TABLE crm_stage_crm_team_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_stage_crm_team_rel IS 'RELATION BETWEEN crm_stage AND crm_team';


--
-- Name: crm_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_stage_id_seq OWNER TO runbot;

--
-- Name: crm_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_stage_id_seq OWNED BY public.crm_stage.id;


--
-- Name: crm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_tag OWNER TO runbot;

--
-- Name: TABLE crm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag IS 'CRM Tag';


--
-- Name: COLUMN crm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.color IS 'Color';


--
-- Name: COLUMN crm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.name IS 'Tag Name';


--
-- Name: COLUMN crm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_date IS 'Created on';


--
-- Name: COLUMN crm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_date IS 'Last Updated on';


--
-- Name: crm_tag_event_lead_rule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag_event_lead_rule_rel (
    event_lead_rule_id integer NOT NULL,
    crm_tag_id integer NOT NULL
);


ALTER TABLE public.crm_tag_event_lead_rule_rel OWNER TO runbot;

--
-- Name: TABLE crm_tag_event_lead_rule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag_event_lead_rule_rel IS 'RELATION BETWEEN event_lead_rule AND crm_tag';


--
-- Name: crm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_tag_id_seq OWNER TO runbot;

--
-- Name: crm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_tag_id_seq OWNED BY public.crm_tag.id;


--
-- Name: crm_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag_rel (
    lead_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.crm_tag_rel OWNER TO runbot;

--
-- Name: TABLE crm_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag_rel IS 'RELATION BETWEEN crm_lead AND crm_tag';


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    message_main_attachment_id integer,
    sequence integer,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    alias_id integer NOT NULL,
    assignment_domain character varying,
    lead_properties_definition jsonb,
    use_leads boolean,
    use_opportunities boolean,
    assignment_optout boolean,
    survey_id integer,
    use_quotations boolean,
    invoiced_target double precision
);


ALTER TABLE public.crm_team OWNER TO runbot;

--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.alias_id IS 'Alias';


--
-- Name: COLUMN crm_team.assignment_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.assignment_domain IS 'Assignment Domain';


--
-- Name: COLUMN crm_team.lead_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.lead_properties_definition IS 'Lead Properties';


--
-- Name: COLUMN crm_team.use_leads; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.use_leads IS 'Leads';


--
-- Name: COLUMN crm_team.use_opportunities; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.use_opportunities IS 'Pipeline';


--
-- Name: COLUMN crm_team.assignment_optout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.assignment_optout IS 'Skip auto assignment';


--
-- Name: COLUMN crm_team.survey_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.survey_id IS 'Interview Form';


--
-- Name: COLUMN crm_team.use_quotations; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.use_quotations IS 'Quotations';


--
-- Name: COLUMN crm_team.invoiced_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.invoiced_target IS 'Invoicing Target';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_id_seq OWNER TO runbot;

--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: crm_team_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_member (
    id integer NOT NULL,
    message_main_attachment_id integer,
    crm_team_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    assignment_max integer,
    assignment_domain character varying,
    assignment_optout boolean
);


ALTER TABLE public.crm_team_member OWNER TO runbot;

--
-- Name: TABLE crm_team_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_member IS 'Sales Team Member';


--
-- Name: COLUMN crm_team_member.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN crm_team_member.crm_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN crm_team_member.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_team_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team_member.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.active IS 'Active';


--
-- Name: COLUMN crm_team_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_date IS 'Created on';


--
-- Name: COLUMN crm_team_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team_member.assignment_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_max IS 'Average Leads Capacity (on 30 days)';


--
-- Name: COLUMN crm_team_member.assignment_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_domain IS 'Assignment Domain';


--
-- Name: COLUMN crm_team_member.assignment_optout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_optout IS 'Skip auto assignment';


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_member_id_seq OWNER TO runbot;

--
-- Name: crm_team_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_member_id_seq OWNED BY public.crm_team_member.id;


--
-- Name: crm_team_sale_order_alert_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_sale_order_alert_rel (
    sale_order_alert_id integer NOT NULL,
    crm_team_id integer NOT NULL
);


ALTER TABLE public.crm_team_sale_order_alert_rel OWNER TO runbot;

--
-- Name: TABLE crm_team_sale_order_alert_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_sale_order_alert_rel IS 'RELATION BETWEEN sale_order_alert AND crm_team';


--
-- Name: currency_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.currency_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    last_report_currency_update timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.currency_group OWNER TO runbot;

--
-- Name: TABLE currency_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.currency_group IS 'Currency Group';


--
-- Name: COLUMN currency_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group.create_uid IS 'Created by';


--
-- Name: COLUMN currency_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN currency_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group.name IS 'Name';


--
-- Name: COLUMN currency_group.last_report_currency_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group.last_report_currency_update IS 'Last Report Currency Update';


--
-- Name: COLUMN currency_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group.create_date IS 'Created on';


--
-- Name: COLUMN currency_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group.write_date IS 'Last Updated on';


--
-- Name: currency_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.currency_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.currency_group_id_seq OWNER TO runbot;

--
-- Name: currency_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.currency_group_id_seq OWNED BY public.currency_group.id;


--
-- Name: currency_group_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.currency_group_line (
    id integer NOT NULL,
    company_id integer NOT NULL,
    currency_id integer NOT NULL,
    currency_group integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.currency_group_line OWNER TO runbot;

--
-- Name: TABLE currency_group_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.currency_group_line IS 'Currency Group Line';


--
-- Name: COLUMN currency_group_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group_line.company_id IS 'Companies';


--
-- Name: COLUMN currency_group_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group_line.currency_id IS 'Currency';


--
-- Name: COLUMN currency_group_line.currency_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group_line.currency_group IS 'Currency Group';


--
-- Name: COLUMN currency_group_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group_line.create_uid IS 'Created by';


--
-- Name: COLUMN currency_group_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN currency_group_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group_line.create_date IS 'Created on';


--
-- Name: COLUMN currency_group_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_group_line.write_date IS 'Last Updated on';


--
-- Name: currency_group_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.currency_group_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.currency_group_line_id_seq OWNER TO runbot;

--
-- Name: currency_group_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.currency_group_line_id_seq OWNED BY public.currency_group_line.id;


--
-- Name: db_configuration; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.db_configuration (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.db_configuration OWNER TO runbot;

--
-- Name: TABLE db_configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.db_configuration IS 'db.configuration';


--
-- Name: COLUMN db_configuration.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.create_uid IS 'Created by';


--
-- Name: COLUMN db_configuration.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.write_uid IS 'Last Updated by';


--
-- Name: COLUMN db_configuration.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.name IS 'Name';


--
-- Name: COLUMN db_configuration.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.create_date IS 'Created on';


--
-- Name: COLUMN db_configuration.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.write_date IS 'Last Updated on';


--
-- Name: db_configuration_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.db_configuration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.db_configuration_id_seq OWNER TO runbot;

--
-- Name: db_configuration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.db_configuration_id_seq OWNED BY public.db_configuration.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: delivery_carrier; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    product_id integer NOT NULL,
    shipping_insurance integer,
    create_uid integer,
    write_uid integer,
    delivery_type character varying NOT NULL,
    integration_level character varying,
    invoice_policy character varying NOT NULL,
    name jsonb NOT NULL,
    carrier_description jsonb,
    active boolean,
    prod_environment boolean,
    debug_logging boolean,
    free_over boolean,
    return_label_on_delivery boolean,
    get_return_label_from_portal boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin double precision,
    amount double precision,
    fixed_price double precision,
    andreani_user character varying,
    andreani_password character varying,
    andreani_contract character varying,
    andreani_client character varying,
    andreani_service_type character varying,
    andreani_branch_id character varying,
    andreani_branch_description text,
    partner_id integer,
    website_id integer,
    is_published boolean,
    CONSTRAINT delivery_carrier_margin_not_under_100_percent CHECK ((margin >= ('-100'::integer)::double precision)),
    CONSTRAINT delivery_carrier_shipping_insurance_is_percentage CHECK (((shipping_insurance >= 0) AND (shipping_insurance <= 100)))
);


ALTER TABLE public.delivery_carrier OWNER TO runbot;

--
-- Name: TABLE delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier IS 'Shipping Methods';


--
-- Name: COLUMN delivery_carrier.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_carrier.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.company_id IS 'Company';


--
-- Name: COLUMN delivery_carrier.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.product_id IS 'Delivery Product';


--
-- Name: COLUMN delivery_carrier.shipping_insurance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.shipping_insurance IS 'Insurance Percentage';


--
-- Name: COLUMN delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_carrier.delivery_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.delivery_type IS 'Provider';


--
-- Name: COLUMN delivery_carrier.integration_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.integration_level IS 'Integration Level';


--
-- Name: COLUMN delivery_carrier.invoice_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.invoice_policy IS 'Invoicing Policy';


--
-- Name: COLUMN delivery_carrier.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.name IS 'Delivery Method';


--
-- Name: COLUMN delivery_carrier.carrier_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.carrier_description IS 'Carrier Description';


--
-- Name: COLUMN delivery_carrier.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.active IS 'Active';


--
-- Name: COLUMN delivery_carrier.prod_environment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.prod_environment IS 'Environment';


--
-- Name: COLUMN delivery_carrier.debug_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.debug_logging IS 'Debug logging';


--
-- Name: COLUMN delivery_carrier.free_over; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.free_over IS 'Free if order amount is above';


--
-- Name: COLUMN delivery_carrier.return_label_on_delivery; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.return_label_on_delivery IS 'Generate Return Label';


--
-- Name: COLUMN delivery_carrier.get_return_label_from_portal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.get_return_label_from_portal IS 'Return Label Accessible from Customer Portal';


--
-- Name: COLUMN delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: COLUMN delivery_carrier.margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.margin IS 'Margin';


--
-- Name: COLUMN delivery_carrier.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.amount IS 'Amount';


--
-- Name: COLUMN delivery_carrier.fixed_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.fixed_price IS 'Fixed Price';


--
-- Name: COLUMN delivery_carrier.andreani_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.andreani_user IS 'User';


--
-- Name: COLUMN delivery_carrier.andreani_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.andreani_password IS 'Password';


--
-- Name: COLUMN delivery_carrier.andreani_contract; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.andreani_contract IS 'Contract';


--
-- Name: COLUMN delivery_carrier.andreani_client; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.andreani_client IS 'Client Number';


--
-- Name: COLUMN delivery_carrier.andreani_service_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.andreani_service_type IS 'Andreani Service Type';


--
-- Name: COLUMN delivery_carrier.andreani_branch_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.andreani_branch_id IS 'Andreani branch ID';


--
-- Name: COLUMN delivery_carrier.andreani_branch_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.andreani_branch_description IS 'Andreani Branch Description';


--
-- Name: COLUMN delivery_carrier.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.partner_id IS 'Carrier Address';


--
-- Name: COLUMN delivery_carrier.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.website_id IS 'Website';


--
-- Name: COLUMN delivery_carrier.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.is_published IS 'Is Published';


--
-- Name: CONSTRAINT delivery_carrier_margin_not_under_100_percent ON delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT delivery_carrier_margin_not_under_100_percent ON public.delivery_carrier IS 'CHECK (margin >= -100)';


--
-- Name: CONSTRAINT delivery_carrier_shipping_insurance_is_percentage ON delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT delivery_carrier_shipping_insurance_is_percentage ON public.delivery_carrier IS 'CHECK(shipping_insurance >= 0 AND shipping_insurance <= 100)';


--
-- Name: delivery_carrier_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier_country_rel (
    carrier_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.delivery_carrier_country_rel OWNER TO runbot;

--
-- Name: TABLE delivery_carrier_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier_country_rel IS 'RELATION BETWEEN delivery_carrier AND res_country';


--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_carrier_id_seq OWNER TO runbot;

--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_carrier_id_seq OWNED BY public.delivery_carrier.id;


--
-- Name: delivery_carrier_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier_state_rel (
    carrier_id integer NOT NULL,
    state_id integer NOT NULL
);


ALTER TABLE public.delivery_carrier_state_rel OWNER TO runbot;

--
-- Name: TABLE delivery_carrier_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier_state_rel IS 'RELATION BETWEEN delivery_carrier AND res_country_state';


--
-- Name: delivery_price_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_price_rule (
    id integer NOT NULL,
    sequence integer NOT NULL,
    carrier_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    variable character varying NOT NULL,
    operator character varying NOT NULL,
    variable_factor character varying NOT NULL,
    list_base_price numeric NOT NULL,
    list_price numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_value double precision NOT NULL
);


ALTER TABLE public.delivery_price_rule OWNER TO runbot;

--
-- Name: TABLE delivery_price_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_price_rule IS 'Delivery Price Rules';


--
-- Name: COLUMN delivery_price_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_price_rule.carrier_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.carrier_id IS 'Carrier';


--
-- Name: COLUMN delivery_price_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_price_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_price_rule.variable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.variable IS 'Variable';


--
-- Name: COLUMN delivery_price_rule.operator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.operator IS 'Operator';


--
-- Name: COLUMN delivery_price_rule.variable_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.variable_factor IS 'Variable Factor';


--
-- Name: COLUMN delivery_price_rule.list_base_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.list_base_price IS 'Sale Base Price';


--
-- Name: COLUMN delivery_price_rule.list_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.list_price IS 'Sale Price';


--
-- Name: COLUMN delivery_price_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.create_date IS 'Created on';


--
-- Name: COLUMN delivery_price_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN delivery_price_rule.max_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.max_value IS 'Maximum Value';


--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_price_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_price_rule_id_seq OWNER TO runbot;

--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_price_rule_id_seq OWNED BY public.delivery_price_rule.id;


--
-- Name: delivery_zip_prefix; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_zip_prefix (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.delivery_zip_prefix OWNER TO runbot;

--
-- Name: TABLE delivery_zip_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_zip_prefix IS 'Delivery Zip Prefix';


--
-- Name: COLUMN delivery_zip_prefix.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_zip_prefix.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_zip_prefix.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.name IS 'Prefix';


--
-- Name: COLUMN delivery_zip_prefix.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.create_date IS 'Created on';


--
-- Name: COLUMN delivery_zip_prefix.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.write_date IS 'Last Updated on';


--
-- Name: delivery_zip_prefix_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_zip_prefix_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_zip_prefix_id_seq OWNER TO runbot;

--
-- Name: delivery_zip_prefix_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_zip_prefix_id_seq OWNED BY public.delivery_zip_prefix.id;


--
-- Name: delivery_zip_prefix_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_zip_prefix_rel (
    carrier_id integer NOT NULL,
    zip_prefix_id integer NOT NULL
);


ALTER TABLE public.delivery_zip_prefix_rel OWNER TO runbot;

--
-- Name: TABLE delivery_zip_prefix_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_zip_prefix_rel IS 'RELATION BETWEEN delivery_carrier AND delivery_zip_prefix';


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    kpi_account_total_revenue boolean,
    kpi_crm_lead_created boolean,
    kpi_crm_opportunities_won boolean,
    kpi_helpdesk_tickets_closed boolean,
    kpi_hr_recruitment_new_colleagues boolean,
    kpi_project_task_opened boolean,
    kpi_account_bank_cash boolean,
    kpi_pos_total boolean,
    kpi_all_sale_total boolean,
    kpi_website_sale_total boolean
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_account_total_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_total_revenue IS 'Revenue';


--
-- Name: COLUMN digest_digest.kpi_crm_lead_created; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_crm_lead_created IS 'New Leads';


--
-- Name: COLUMN digest_digest.kpi_crm_opportunities_won; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_crm_opportunities_won IS 'Opportunities Won';


--
-- Name: COLUMN digest_digest.kpi_helpdesk_tickets_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_helpdesk_tickets_closed IS 'Tickets Closed';


--
-- Name: COLUMN digest_digest.kpi_hr_recruitment_new_colleagues; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_hr_recruitment_new_colleagues IS 'New Employees';


--
-- Name: COLUMN digest_digest.kpi_project_task_opened; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_project_task_opened IS 'Open Tasks';


--
-- Name: COLUMN digest_digest.kpi_account_bank_cash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_bank_cash IS 'Bank & Cash Moves';


--
-- Name: COLUMN digest_digest.kpi_pos_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_pos_total IS 'POS Sales';


--
-- Name: COLUMN digest_digest.kpi_all_sale_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_all_sale_total IS 'All Sales';


--
-- Name: COLUMN digest_digest.kpi_website_sale_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_website_sale_total IS 'eCommerce Sales';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: dms_acc_rep_export_wizard_format_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.dms_acc_rep_export_wizard_format_rel (
    account_reports_export_wizard_id integer NOT NULL,
    account_reports_export_wizard_format_id integer NOT NULL
);


ALTER TABLE public.dms_acc_rep_export_wizard_format_rel OWNER TO runbot;

--
-- Name: TABLE dms_acc_rep_export_wizard_format_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.dms_acc_rep_export_wizard_format_rel IS 'RELATION BETWEEN account_reports_export_wizard AND account_reports_export_wizard_format';


--
-- Name: docs_config_installer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.docs_config_installer (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    port integer NOT NULL,
    host character varying(64) NOT NULL,
    auth_type character varying,
    username character varying(32),
    password character varying(32),
    state character varying,
    msg text,
    error_details text,
    enabled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.docs_config_installer OWNER TO runbot;

--
-- Name: TABLE docs_config_installer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.docs_config_installer IS 'docs_config.installer';


--
-- Name: COLUMN docs_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN docs_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN docs_config_installer.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.port IS 'Port';


--
-- Name: COLUMN docs_config_installer.host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.host IS 'Host';


--
-- Name: COLUMN docs_config_installer.auth_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.auth_type IS 'Authentication';


--
-- Name: COLUMN docs_config_installer.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.username IS 'Username';


--
-- Name: COLUMN docs_config_installer.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.password IS 'Password';


--
-- Name: COLUMN docs_config_installer.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.state IS 'State';


--
-- Name: COLUMN docs_config_installer.msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.msg IS 'Message';


--
-- Name: COLUMN docs_config_installer.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.error_details IS 'Error Details';


--
-- Name: COLUMN docs_config_installer.enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.enabled IS 'Enabled';


--
-- Name: COLUMN docs_config_installer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN docs_config_installer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.write_date IS 'Last Updated on';


--
-- Name: docs_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.docs_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.docs_config_installer_id_seq OWNER TO runbot;

--
-- Name: docs_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.docs_config_installer_id_seq OWNED BY public.docs_config_installer.id;


--
-- Name: document_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.document_tag_rel (
    documents_document_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.document_tag_rel OWNER TO runbot;

--
-- Name: TABLE document_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.document_tag_rel IS 'RELATION BETWEEN documents_document AND documents_tag';


--
-- Name: documents_account_folder_setting; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_account_folder_setting (
    id integer NOT NULL,
    company_id integer NOT NULL,
    journal_id integer NOT NULL,
    folder_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_account_folder_setting OWNER TO runbot;

--
-- Name: TABLE documents_account_folder_setting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_account_folder_setting IS 'Journal and Folder settings';


--
-- Name: COLUMN documents_account_folder_setting.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.company_id IS 'Company';


--
-- Name: COLUMN documents_account_folder_setting.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.journal_id IS 'Journal';


--
-- Name: COLUMN documents_account_folder_setting.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.folder_id IS 'Workspace';


--
-- Name: COLUMN documents_account_folder_setting.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.create_uid IS 'Created by';


--
-- Name: COLUMN documents_account_folder_setting.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_account_folder_setting.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.create_date IS 'Created on';


--
-- Name: COLUMN documents_account_folder_setting.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.write_date IS 'Last Updated on';


--
-- Name: documents_account_folder_setting_documents_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_account_folder_setting_documents_tag_rel (
    documents_account_folder_setting_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.documents_account_folder_setting_documents_tag_rel OWNER TO runbot;

--
-- Name: TABLE documents_account_folder_setting_documents_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_account_folder_setting_documents_tag_rel IS 'RELATION BETWEEN documents_account_folder_setting AND documents_tag';


--
-- Name: documents_account_folder_setting_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_account_folder_setting_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_account_folder_setting_id_seq OWNER TO runbot;

--
-- Name: documents_account_folder_setting_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_account_folder_setting_id_seq OWNED BY public.documents_account_folder_setting.id;


--
-- Name: documents_document; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document (
    id integer NOT NULL,
    message_main_attachment_id integer,
    attachment_id integer,
    file_size integer,
    res_id integer,
    partner_id integer,
    owner_id integer,
    lock_uid integer,
    create_share_id integer,
    request_activity_id integer,
    folder_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    res_model character varying,
    name character varying,
    thumbnail_status character varying,
    url character varying(1024),
    type character varying NOT NULL,
    is_editable_attachment boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    handler character varying
);


ALTER TABLE public.documents_document OWNER TO runbot;

--
-- Name: TABLE documents_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document IS 'Document';


--
-- Name: COLUMN documents_document.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN documents_document.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.attachment_id IS 'Attachment';


--
-- Name: COLUMN documents_document.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.file_size IS 'File Size';


--
-- Name: COLUMN documents_document.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.res_id IS 'Resource ID';


--
-- Name: COLUMN documents_document.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.partner_id IS 'Contact';


--
-- Name: COLUMN documents_document.owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.owner_id IS 'Owner';


--
-- Name: COLUMN documents_document.lock_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.lock_uid IS 'Locked by';


--
-- Name: COLUMN documents_document.create_share_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_share_id IS 'Create Share';


--
-- Name: COLUMN documents_document.request_activity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.request_activity_id IS 'Request Activity';


--
-- Name: COLUMN documents_document.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.folder_id IS 'Workspace';


--
-- Name: COLUMN documents_document.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_uid IS 'Created by';


--
-- Name: COLUMN documents_document.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_document.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.email_cc IS 'Email cc';


--
-- Name: COLUMN documents_document.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.res_model IS 'Resource Model';


--
-- Name: COLUMN documents_document.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.name IS 'Name';


--
-- Name: COLUMN documents_document.thumbnail_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.thumbnail_status IS 'Thumbnail Status';


--
-- Name: COLUMN documents_document.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.url IS 'URL';


--
-- Name: COLUMN documents_document.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.type IS 'Type';


--
-- Name: COLUMN documents_document.is_editable_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.is_editable_attachment IS 'Is Editable Attachment';


--
-- Name: COLUMN documents_document.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.active IS 'Active';


--
-- Name: COLUMN documents_document.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_date IS 'Created on';


--
-- Name: COLUMN documents_document.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.write_date IS 'Last Updated on';


--
-- Name: COLUMN documents_document.handler; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.handler IS 'Handler';


--
-- Name: documents_document_documents_link_to_record_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document_documents_link_to_record_wizard_rel (
    documents_link_to_record_wizard_id integer NOT NULL,
    documents_document_id integer NOT NULL
);


ALTER TABLE public.documents_document_documents_link_to_record_wizard_rel OWNER TO runbot;

--
-- Name: TABLE documents_document_documents_link_to_record_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document_documents_link_to_record_wizard_rel IS 'RELATION BETWEEN documents_link_to_record_wizard AND documents_document';


--
-- Name: documents_document_documents_share_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document_documents_share_rel (
    documents_share_id integer NOT NULL,
    documents_document_id integer NOT NULL
);


ALTER TABLE public.documents_document_documents_share_rel OWNER TO runbot;

--
-- Name: TABLE documents_document_documents_share_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document_documents_share_rel IS 'RELATION BETWEEN documents_share AND documents_document';


--
-- Name: documents_document_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_document_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_document_id_seq OWNER TO runbot;

--
-- Name: documents_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_document_id_seq OWNED BY public.documents_document.id;


--
-- Name: documents_document_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document_ir_attachment_rel (
    documents_document_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.documents_document_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE documents_document_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document_ir_attachment_rel IS 'RELATION BETWEEN documents_document AND ir_attachment';


--
-- Name: documents_document_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document_res_users_rel (
    documents_document_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.documents_document_res_users_rel OWNER TO runbot;

--
-- Name: TABLE documents_document_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document_res_users_rel IS 'RELATION BETWEEN documents_document AND res_users';


--
-- Name: documents_facet; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_facet (
    id integer NOT NULL,
    folder_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    tooltip character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_facet OWNER TO runbot;

--
-- Name: TABLE documents_facet; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_facet IS 'Category';


--
-- Name: COLUMN documents_facet.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_facet.folder_id IS 'Workspace';


--
-- Name: COLUMN documents_facet.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_facet.sequence IS 'Sequence';


--
-- Name: COLUMN documents_facet.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_facet.create_uid IS 'Created by';


--
-- Name: COLUMN documents_facet.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_facet.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_facet.tooltip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_facet.tooltip IS 'Tooltip';


--
-- Name: COLUMN documents_facet.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_facet.name IS 'Name';


--
-- Name: COLUMN documents_facet.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_facet.create_date IS 'Created on';


--
-- Name: COLUMN documents_facet.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_facet.write_date IS 'Last Updated on';


--
-- Name: documents_facet_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_facet_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_facet_id_seq OWNER TO runbot;

--
-- Name: documents_facet_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_facet_id_seq OWNED BY public.documents_facet.id;


--
-- Name: documents_folder; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_folder (
    id integer NOT NULL,
    company_id integer,
    parent_folder_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    description jsonb,
    user_specific boolean,
    user_specific_write boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT documents_folder_check_user_specific CHECK ((NOT (((NOT user_specific) OR (user_specific IS NULL)) AND user_specific_write)))
);


ALTER TABLE public.documents_folder OWNER TO runbot;

--
-- Name: TABLE documents_folder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_folder IS 'Documents Workspace';


--
-- Name: COLUMN documents_folder.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.company_id IS 'Company';


--
-- Name: COLUMN documents_folder.parent_folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.parent_folder_id IS 'Parent Workspace';


--
-- Name: COLUMN documents_folder.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.sequence IS 'Sequence';


--
-- Name: COLUMN documents_folder.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.create_uid IS 'Created by';


--
-- Name: COLUMN documents_folder.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_folder.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.parent_path IS 'Parent Path';


--
-- Name: COLUMN documents_folder.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.name IS 'Name';


--
-- Name: COLUMN documents_folder.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.description IS 'Description';


--
-- Name: COLUMN documents_folder.user_specific; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.user_specific IS 'Own Documents Only';


--
-- Name: COLUMN documents_folder.user_specific_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.user_specific_write IS 'Own Documents Only (Write)';


--
-- Name: COLUMN documents_folder.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.create_date IS 'Created on';


--
-- Name: COLUMN documents_folder.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT documents_folder_check_user_specific ON documents_folder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT documents_folder_check_user_specific ON public.documents_folder IS 'CHECK(not ((NOT user_specific OR user_specific IS NULL) and user_specific_write))';


--
-- Name: documents_folder_deletion_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_folder_deletion_wizard (
    id integer NOT NULL,
    folder_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_folder_deletion_wizard OWNER TO runbot;

--
-- Name: TABLE documents_folder_deletion_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_folder_deletion_wizard IS 'Documents Folder Deletion Wizard';


--
-- Name: COLUMN documents_folder_deletion_wizard.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder_deletion_wizard.folder_id IS 'Folder';


--
-- Name: COLUMN documents_folder_deletion_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder_deletion_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN documents_folder_deletion_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder_deletion_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_folder_deletion_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder_deletion_wizard.create_date IS 'Created on';


--
-- Name: COLUMN documents_folder_deletion_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_folder_deletion_wizard.write_date IS 'Last Updated on';


--
-- Name: documents_folder_deletion_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_folder_deletion_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_folder_deletion_wizard_id_seq OWNER TO runbot;

--
-- Name: documents_folder_deletion_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_folder_deletion_wizard_id_seq OWNED BY public.documents_folder_deletion_wizard.id;


--
-- Name: documents_folder_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_folder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_folder_id_seq OWNER TO runbot;

--
-- Name: documents_folder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_folder_id_seq OWNED BY public.documents_folder.id;


--
-- Name: documents_folder_read_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_folder_read_groups (
    documents_folder_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.documents_folder_read_groups OWNER TO runbot;

--
-- Name: TABLE documents_folder_read_groups; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_folder_read_groups IS 'RELATION BETWEEN documents_folder AND res_groups';


--
-- Name: documents_folder_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_folder_res_groups_rel (
    documents_folder_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.documents_folder_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE documents_folder_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_folder_res_groups_rel IS 'RELATION BETWEEN documents_folder AND res_groups';


--
-- Name: documents_hr_contracts_tags_table; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_hr_contracts_tags_table (
    res_company_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.documents_hr_contracts_tags_table OWNER TO runbot;

--
-- Name: TABLE documents_hr_contracts_tags_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_hr_contracts_tags_table IS 'RELATION BETWEEN res_company AND documents_tag';


--
-- Name: documents_link_to_record_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_link_to_record_wizard (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    is_readonly_model boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_link_to_record_wizard OWNER TO runbot;

--
-- Name: TABLE documents_link_to_record_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_link_to_record_wizard IS 'Documents Link to Record';


--
-- Name: COLUMN documents_link_to_record_wizard.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.model_id IS 'Model';


--
-- Name: COLUMN documents_link_to_record_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN documents_link_to_record_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_link_to_record_wizard.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.resource_ref IS 'Record';


--
-- Name: COLUMN documents_link_to_record_wizard.is_readonly_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.is_readonly_model IS 'is_readonly_model';


--
-- Name: COLUMN documents_link_to_record_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.create_date IS 'Created on';


--
-- Name: COLUMN documents_link_to_record_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.write_date IS 'Last Updated on';


--
-- Name: documents_link_to_record_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_link_to_record_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_link_to_record_wizard_id_seq OWNER TO runbot;

--
-- Name: documents_link_to_record_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_link_to_record_wizard_id_seq OWNED BY public.documents_link_to_record_wizard.id;


--
-- Name: documents_request_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_request_wizard (
    id integer NOT NULL,
    owner_id integer NOT NULL,
    partner_id integer,
    activity_type_id integer NOT NULL,
    folder_id integer NOT NULL,
    res_id integer,
    activity_date_deadline_range integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    activity_date_deadline_range_type character varying,
    activity_note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_request_wizard OWNER TO runbot;

--
-- Name: TABLE documents_request_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_request_wizard IS 'Document Request';


--
-- Name: COLUMN documents_request_wizard.owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.owner_id IS 'Owner';


--
-- Name: COLUMN documents_request_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.partner_id IS 'Contact';


--
-- Name: COLUMN documents_request_wizard.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.activity_type_id IS 'Activity type';


--
-- Name: COLUMN documents_request_wizard.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.folder_id IS 'Workspace';


--
-- Name: COLUMN documents_request_wizard.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.res_id IS 'Resource ID';


--
-- Name: COLUMN documents_request_wizard.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN documents_request_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN documents_request_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_request_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.name IS 'Name';


--
-- Name: COLUMN documents_request_wizard.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.res_model IS 'Resource Model';


--
-- Name: COLUMN documents_request_wizard.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN documents_request_wizard.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.activity_note IS 'Note';


--
-- Name: COLUMN documents_request_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.create_date IS 'Created on';


--
-- Name: COLUMN documents_request_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_request_wizard.write_date IS 'Last Updated on';


--
-- Name: documents_request_wizard_documents_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_request_wizard_documents_tag_rel (
    documents_request_wizard_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.documents_request_wizard_documents_tag_rel OWNER TO runbot;

--
-- Name: TABLE documents_request_wizard_documents_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_request_wizard_documents_tag_rel IS 'RELATION BETWEEN documents_request_wizard AND documents_tag';


--
-- Name: documents_request_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_request_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_request_wizard_id_seq OWNER TO runbot;

--
-- Name: documents_request_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_request_wizard_id_seq OWNED BY public.documents_request_wizard.id;


--
-- Name: documents_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_share (
    id integer NOT NULL,
    alias_id integer NOT NULL,
    message_main_attachment_id integer,
    folder_id integer NOT NULL,
    partner_id integer,
    owner_id integer,
    activity_type_id integer,
    activity_date_deadline_range integer,
    activity_user_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    access_token character varying NOT NULL,
    type character varying,
    domain character varying,
    action character varying,
    activity_summary character varying,
    activity_date_deadline_range_type character varying,
    date_deadline date,
    activity_note text,
    include_sub_folders boolean,
    email_drop boolean,
    activity_option boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_share OWNER TO runbot;

--
-- Name: TABLE documents_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_share IS 'Documents Share';


--
-- Name: COLUMN documents_share.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.alias_id IS 'Alias';


--
-- Name: COLUMN documents_share.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN documents_share.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.folder_id IS 'Workspace';


--
-- Name: COLUMN documents_share.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.partner_id IS 'Contact';


--
-- Name: COLUMN documents_share.owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.owner_id IS 'Document Owner';


--
-- Name: COLUMN documents_share.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.activity_type_id IS 'Activity type';


--
-- Name: COLUMN documents_share.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN documents_share.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.activity_user_id IS 'Responsible';


--
-- Name: COLUMN documents_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.create_uid IS 'Created by';


--
-- Name: COLUMN documents_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_share.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.name IS 'Name';


--
-- Name: COLUMN documents_share.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.access_token IS 'Access Token';


--
-- Name: COLUMN documents_share.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.type IS 'Share type';


--
-- Name: COLUMN documents_share.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.domain IS 'Domain';


--
-- Name: COLUMN documents_share.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.action IS 'Allows to';


--
-- Name: COLUMN documents_share.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.activity_summary IS 'Summary';


--
-- Name: COLUMN documents_share.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN documents_share.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.date_deadline IS 'Valid Until';


--
-- Name: COLUMN documents_share.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.activity_note IS 'Note';


--
-- Name: COLUMN documents_share.include_sub_folders; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.include_sub_folders IS 'Include Sub Folders';


--
-- Name: COLUMN documents_share.email_drop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.email_drop IS 'Upload by Email';


--
-- Name: COLUMN documents_share.activity_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.activity_option IS 'Create a new activity';


--
-- Name: COLUMN documents_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.create_date IS 'Created on';


--
-- Name: COLUMN documents_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_share.write_date IS 'Last Updated on';


--
-- Name: documents_share_documents_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_share_documents_tag_rel (
    documents_share_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.documents_share_documents_tag_rel OWNER TO runbot;

--
-- Name: TABLE documents_share_documents_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_share_documents_tag_rel IS 'RELATION BETWEEN documents_share AND documents_tag';


--
-- Name: documents_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_share_id_seq OWNER TO runbot;

--
-- Name: documents_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_share_id_seq OWNED BY public.documents_share.id;


--
-- Name: documents_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_tag (
    id integer NOT NULL,
    folder_id integer,
    facet_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_tag OWNER TO runbot;

--
-- Name: TABLE documents_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_tag IS 'Tag';


--
-- Name: COLUMN documents_tag.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_tag.folder_id IS 'Workspace';


--
-- Name: COLUMN documents_tag.facet_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_tag.facet_id IS 'Category';


--
-- Name: COLUMN documents_tag.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_tag.sequence IS 'Sequence';


--
-- Name: COLUMN documents_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_tag.create_uid IS 'Created by';


--
-- Name: COLUMN documents_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_tag.name IS 'Name';


--
-- Name: COLUMN documents_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_tag.create_date IS 'Created on';


--
-- Name: COLUMN documents_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_tag.write_date IS 'Last Updated on';


--
-- Name: documents_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_tag_id_seq OWNER TO runbot;

--
-- Name: documents_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_tag_id_seq OWNED BY public.documents_tag.id;


--
-- Name: documents_tag_mail_activity_type_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_tag_mail_activity_type_rel (
    mail_activity_type_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.documents_tag_mail_activity_type_rel OWNER TO runbot;

--
-- Name: TABLE documents_tag_mail_activity_type_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_tag_mail_activity_type_rel IS 'RELATION BETWEEN mail_activity_type AND documents_tag';


--
-- Name: documents_workflow_action; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_workflow_action (
    id integer NOT NULL,
    workflow_rule_id integer,
    facet_id integer,
    tag_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_workflow_action OWNER TO runbot;

--
-- Name: TABLE documents_workflow_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_workflow_action IS 'Document Workflow Tag Action';


--
-- Name: COLUMN documents_workflow_action.workflow_rule_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_workflow_action.workflow_rule_id IS 'Workflow Rule';


--
-- Name: COLUMN documents_workflow_action.facet_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_workflow_action.facet_id IS 'Category';


--
-- Name: COLUMN documents_workflow_action.tag_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_workflow_action.tag_id IS 'Tag';


--
-- Name: COLUMN documents_workflow_action.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_workflow_action.create_uid IS 'Created by';


--
-- Name: COLUMN documents_workflow_action.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_workflow_action.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_workflow_action.action; Type: COMMENT; Schema: public; Owner: runbot
--

