--
-- PostgreSQL database dump
--

\restrict 7U33pVKMzs9b6X1sezGPontiAo3Fg5uANn0pKtdJJ4SFplMbuw1JlnOitWodgfv

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 16.11 (Debian 16.11-1.pgdg12+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: account_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    account_type character varying NOT NULL,
    name jsonb NOT NULL,
    code_store jsonb,
    note text,
    deprecated boolean,
    reconcile boolean,
    non_trade boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_monetary boolean,
    create_asset character varying NOT NULL,
    multiple_assets_per_line boolean,
    disallowed_expenses_category_id integer,
    l10n_ar_afip_activity_id integer
);


ALTER TABLE public.account_account OWNER TO runbot;

--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.account_type IS 'Type';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.name IS 'Account Name';


--
-- Name: COLUMN account_account.code_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.code_store IS 'Code Store';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.deprecated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.deprecated IS 'Deprecated';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.non_trade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.non_trade IS 'Non Trade';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account.is_monetary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.is_monetary IS 'Is Monetary';


--
-- Name: COLUMN account_account.create_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_asset IS 'Create Asset';


--
-- Name: COLUMN account_account.multiple_assets_per_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.multiple_assets_per_line IS 'Multiple Assets per Line';


--
-- Name: COLUMN account_account.disallowed_expenses_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.disallowed_expenses_category_id IS 'Disallowed Expenses Category';


--
-- Name: COLUMN account_account.l10n_ar_afip_activity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.l10n_ar_afip_activity_id IS 'Associated Activity';


--
-- Name: account_account_account_asset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_asset_rel (
    account_account_id integer NOT NULL,
    account_asset_id integer NOT NULL
);


ALTER TABLE public.account_account_account_asset_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_asset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_asset_rel IS 'RELATION BETWEEN account_account AND account_asset';


--
-- Name: account_account_account_auto_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_auto_reconcile_wizard_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_auto_reconcile_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_auto_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_auto_reconcile_wizard_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_account';


--
-- Name: account_account_account_import_summary_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_import_summary_rel (
    account_import_summary_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_import_summary_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_import_summary_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_import_summary_rel IS 'RELATION BETWEEN account_import_summary AND account_account';


--
-- Name: account_account_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_journal_rel (
    account_account_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_account_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_journal_rel IS 'RELATION BETWEEN account_account AND account_journal';


--
-- Name: account_account_account_merge_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_merge_wizard_rel (
    account_merge_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_merge_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_merge_wizard_rel IS 'RELATION BETWEEN account_merge_wizard AND account_account';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_exclude_res_currency_provision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_exclude_res_currency_provision (
    account_account_id integer NOT NULL,
    res_currency_id integer NOT NULL
);


ALTER TABLE public.account_account_exclude_res_currency_provision OWNER TO runbot;

--
-- Name: TABLE account_account_exclude_res_currency_provision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_exclude_res_currency_provision IS 'RELATION BETWEEN account_account AND res_currency';


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_id_seq OWNER TO runbot;

--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_res_company_rel (
    account_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_res_company_rel IS 'RELATION BETWEEN account_account AND res_company';


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    color integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    applicability character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    tax_negate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.tax_negate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.tax_negate IS 'Negate Tax Balance';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_tax_repartition_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_tag_id_seq OWNER TO runbot;

--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tag_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_product_template_rel (
    product_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_product_template_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_product_template_rel IS 'RELATION BETWEEN product_template AND account_account_tag';


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_tax_default_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_accrued_orders_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_accrued_orders_wizard (
    id integer NOT NULL,
    company_id integer,
    journal_id integer NOT NULL,
    currency_id integer,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_accrued_orders_wizard OWNER TO runbot;

--
-- Name: TABLE account_accrued_orders_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_accrued_orders_wizard IS 'Accrued Orders Wizard';


--
-- Name: COLUMN account_accrued_orders_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrued_orders_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_accrued_orders_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.currency_id IS 'Company Currency';


--
-- Name: COLUMN account_accrued_orders_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.account_id IS 'Accrual Account';


--
-- Name: COLUMN account_accrued_orders_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrued_orders_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrued_orders_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrued_orders_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_accrued_orders_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.amount IS 'Amount';


--
-- Name: COLUMN account_accrued_orders_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrued_orders_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_accrued_orders_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNER TO runbot;

--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNED BY public.account_accrued_orders_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    commercial_partner_id integer
);


ALTER TABLE public.account_analytic_account OWNER TO runbot;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_account.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.commercial_partner_id IS 'Commercial Partner';


--
-- Name: account_analytic_account_account_transfer_model_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account_account_transfer_model_line_rel (
    account_transfer_model_line_id integer NOT NULL,
    account_analytic_account_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_account_transfer_model_line_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_account_account_transfer_model_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account_account_transfer_model_line_rel IS 'RELATION BETWEEN account_transfer_model_line AND account_analytic_account';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO runbot;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_applicability OWNER TO runbot;

--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_applicability.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_applicability.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.account_prefix IS 'Financial Accounts Prefixes';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNER TO runbot;

--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    sequence integer,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_distribution_model OWNER TO runbot;

--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_distribution_model.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_distribution_model.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_distribution_model.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.account_prefix IS 'Accounts Prefix';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNER TO runbot;

--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    account_id integer,
    product_uom_id integer,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision,
    x_plan2_id integer,
    x_plan3_id integer,
    product_id integer,
    general_account_id integer,
    journal_id integer,
    move_line_id integer,
    code character varying(8),
    ref character varying,
    so_line integer
);


ALTER TABLE public.account_analytic_line OWNER TO runbot;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Project Account';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_line.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan3_id IS 'Internal';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.journal_id IS 'Financial Journal';


--
-- Name: COLUMN account_analytic_line.move_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.move_line_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    complete_name character varying,
    name jsonb NOT NULL,
    default_applicability jsonb,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    x_plan2_id integer,
    x_plan3_id integer
);


ALTER TABLE public.account_analytic_plan OWNER TO runbot;

--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_plan.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_plan.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.x_plan3_id IS 'Internal';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_plan_id_seq OWNER TO runbot;

--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: account_ar_vat_line; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.account_ar_vat_line AS
SELECT
    NULL::text AS column_group_key,
    NULL::integer AS id,
    NULL::character varying AS cuit,
    NULL::character varying AS afip_responsibility_type_name,
    NULL::character varying AS partner_name,
    NULL::character varying AS tax_type,
    NULL::integer AS move_id,
    NULL::character varying AS move_type,
    NULL::date AS date,
    NULL::date AS invoice_date,
    NULL::integer AS partner_id,
    NULL::integer AS journal_id,
    NULL::character varying AS move_name,
    NULL::integer AS afip_responsibility_type_id,
    NULL::integer AS document_type_id,
    NULL::character varying AS state,
    NULL::integer AS company_id,
    NULL::numeric AS taxed,
    NULL::numeric AS base_10,
    NULL::numeric AS vat_10,
    NULL::numeric AS base_21,
    NULL::numeric AS vat_21,
    NULL::numeric AS base_27,
    NULL::numeric AS vat_27,
    NULL::numeric AS base_5,
    NULL::numeric AS vat_5,
    NULL::numeric AS base_25,
    NULL::numeric AS vat_25,
    NULL::numeric AS not_taxed,
    NULL::numeric AS vat_per,
    NULL::numeric AS perc_iibb,
    NULL::numeric AS perc_earnings,
    NULL::numeric AS city_tax,
    NULL::numeric AS other_taxes,
    NULL::numeric AS total;


ALTER VIEW public.account_ar_vat_line OWNER TO runbot;

--
-- Name: account_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_asset (
    id integer NOT NULL,
    company_id integer NOT NULL,
    currency_id integer,
    method_number integer,
    account_asset_id integer,
    asset_group_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    journal_id integer,
    model_id integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    method character varying,
    method_period character varying,
    prorata_computation_type character varying NOT NULL,
    prorata_date date NOT NULL,
    acquisition_date date,
    disposal_date date,
    analytic_distribution jsonb,
    asset_properties_definition jsonb,
    asset_properties jsonb,
    original_value numeric,
    book_value numeric,
    salvage_value numeric,
    non_deductible_tax_value numeric,
    already_depreciated_amount_import numeric,
    net_gain_on_sale numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    method_progress_factor double precision,
    salvage_value_pct double precision,
    asset_paused_days double precision
);


ALTER TABLE public.account_asset OWNER TO runbot;

--
-- Name: TABLE account_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_asset IS 'Asset/Revenue Recognition';


--
-- Name: COLUMN account_asset.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.company_id IS 'Company';


--
-- Name: COLUMN account_asset.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.currency_id IS 'Currency';


--
-- Name: COLUMN account_asset.method_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_number IS 'Duration';


--
-- Name: COLUMN account_asset.account_asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_asset_id IS 'Fixed Asset Account';


--
-- Name: COLUMN account_asset.asset_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_asset.account_depreciation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN account_asset.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN account_asset.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.journal_id IS 'Journal';


--
-- Name: COLUMN account_asset.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.model_id IS 'Model';


--
-- Name: COLUMN account_asset.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.parent_id IS 'Parent';


--
-- Name: COLUMN account_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.name IS 'Asset Name';


--
-- Name: COLUMN account_asset.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.state IS 'Status';


--
-- Name: COLUMN account_asset.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method IS 'Method';


--
-- Name: COLUMN account_asset.method_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN account_asset.prorata_computation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.prorata_computation_type IS 'Computation';


--
-- Name: COLUMN account_asset.prorata_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.prorata_date IS 'Prorata Date';


--
-- Name: COLUMN account_asset.acquisition_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.acquisition_date IS 'Acquisition Date';


--
-- Name: COLUMN account_asset.disposal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.disposal_date IS 'Disposal Date';


--
-- Name: COLUMN account_asset.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_asset.asset_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_properties_definition IS 'Model Properties';


--
-- Name: COLUMN account_asset.asset_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_properties IS 'Properties';


--
-- Name: COLUMN account_asset.original_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.original_value IS 'Original Value';


--
-- Name: COLUMN account_asset.book_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.book_value IS 'Book Value';


--
-- Name: COLUMN account_asset.salvage_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.salvage_value IS 'Not Depreciable Value';


--
-- Name: COLUMN account_asset.non_deductible_tax_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.non_deductible_tax_value IS 'Non Deductible Tax Value';


--
-- Name: COLUMN account_asset.already_depreciated_amount_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.already_depreciated_amount_import IS 'Already Depreciated Amount Import';


--
-- Name: COLUMN account_asset.net_gain_on_sale; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.net_gain_on_sale IS 'Net gain on sale';


--
-- Name: COLUMN account_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.active IS 'Active';


--
-- Name: COLUMN account_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.create_date IS 'Created on';


--
-- Name: COLUMN account_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_asset.method_progress_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_progress_factor IS 'Declining Factor';


--
-- Name: COLUMN account_asset.salvage_value_pct; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.salvage_value_pct IS 'Not Depreciable Value Percent';


--
-- Name: COLUMN account_asset.asset_paused_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_paused_days IS 'Asset Paused Days';


--
-- Name: account_asset_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_asset_group (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_asset_group OWNER TO runbot;

--
-- Name: TABLE account_asset_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_asset_group IS 'Asset Group';


--
-- Name: COLUMN account_asset_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.company_id IS 'Company';


--
-- Name: COLUMN account_asset_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.name IS 'Name';


--
-- Name: COLUMN account_asset_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.create_date IS 'Created on';


--
-- Name: COLUMN account_asset_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.write_date IS 'Last Updated on';


--
-- Name: account_asset_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_asset_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_asset_group_id_seq OWNER TO runbot;

--
-- Name: account_asset_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_asset_group_id_seq OWNED BY public.account_asset_group.id;


--
-- Name: account_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_asset_id_seq OWNER TO runbot;

--
-- Name: account_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_asset_id_seq OWNED BY public.account_asset.id;


--
-- Name: account_auto_reconcile_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    search_mode character varying NOT NULL,
    from_date date,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_auto_reconcile_wizard OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard IS 'Account automatic reconciliation wizard';


--
-- Name: COLUMN account_auto_reconcile_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_auto_reconcile_wizard.search_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.search_mode IS 'Reconcile';


--
-- Name: COLUMN account_auto_reconcile_wizard.from_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.from_date IS 'From';


--
-- Name: COLUMN account_auto_reconcile_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.to_date IS 'To';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_auto_reconcile_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard_account_move_line_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_account_move_line_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_move_line';


--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_auto_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNER TO runbot;

--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNED BY public.account_auto_reconcile_wizard.id;


--
-- Name: account_auto_reconcile_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard_res_partner_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_res_partner_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND res_partner';


--
-- Name: account_automatic_entry_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    account_type character varying,
    date date NOT NULL,
    total_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage double precision
);


ALTER TABLE public.account_automatic_entry_wizard OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard IS 'Create Automatic Entries';


--
-- Name: COLUMN account_automatic_entry_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_automatic_entry_wizard.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.destination_account_id IS 'To';


--
-- Name: COLUMN account_automatic_entry_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_entry_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_automatic_entry_wizard.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.action IS 'Action';


--
-- Name: COLUMN account_automatic_entry_wizard.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_automatic_entry_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.date IS 'Date';


--
-- Name: COLUMN account_automatic_entry_wizard.total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.total_amount IS 'Total Amount';


--
-- Name: COLUMN account_automatic_entry_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_entry_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_automatic_entry_wizard.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.percentage IS 'Percentage';


--
-- Name: account_automatic_entry_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard_account_move_line_rel (
    account_automatic_entry_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_automatic_entry_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard_account_move_line_rel IS 'RELATION BETWEEN account_automatic_entry_wizard AND account_move_line';


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_automatic_entry_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNER TO runbot;

--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNED BY public.account_automatic_entry_wizard.id;


--
-- Name: account_autopost_bills_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_autopost_bills_wizard (
    id integer NOT NULL,
    partner_id integer,
    nb_unmodified_bills integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_autopost_bills_wizard OWNER TO runbot;

--
-- Name: TABLE account_autopost_bills_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_autopost_bills_wizard IS 'Autopost Bills Wizard';


--
-- Name: COLUMN account_autopost_bills_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN account_autopost_bills_wizard.nb_unmodified_bills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.nb_unmodified_bills IS 'Number of bills previously unmodified from this partner';


--
-- Name: COLUMN account_autopost_bills_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_autopost_bills_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_autopost_bills_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_autopost_bills_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_date IS 'Last Updated on';


--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_autopost_bills_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNER TO runbot;

--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNED BY public.account_autopost_bills_wizard.id;


--
-- Name: account_bank_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_selection (
    id integer NOT NULL,
    account_online_link_id integer,
    selected_account integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_selection OWNER TO runbot;

--
-- Name: TABLE account_bank_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_selection IS 'Link a bank account to the selected journal';


--
-- Name: COLUMN account_bank_selection.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_selection.selected_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.selected_account IS 'Selected Account';


--
-- Name: COLUMN account_bank_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.write_date IS 'Last Updated on';


--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_selection_id_seq OWNER TO runbot;

--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_selection_id_seq OWNED BY public.account_bank_selection.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    company_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    reference character varying,
    first_line_index character varying,
    date date,
    balance_start numeric,
    balance_end numeric,
    balance_end_real numeric,
    is_complete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    message_main_attachment_id integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    is_in_extractable_state boolean,
    extract_state_processed boolean
);


ALTER TABLE public.account_bank_statement OWNER TO runbot;

--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.first_line_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.first_line_index IS 'First Line Index';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.is_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_complete IS 'Is Complete';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_bank_statement.extract_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_state IS 'Extract state';


--
-- Name: COLUMN account_bank_statement.extract_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_status IS 'Extract status';


--
-- Name: COLUMN account_bank_statement.extract_document_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_bank_statement.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_bank_statement.extract_state_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_state_processed IS 'Extract State Processed';


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_ir_attachment_rel (
    account_bank_statement_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_bank_statement_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_ir_attachment_rel IS 'RELATION BETWEEN account_bank_statement AND ir_attachment';


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    statement_id integer,
    sequence integer,
    partner_id integer,
    currency_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    account_number character varying,
    partner_name character varying,
    transaction_type character varying,
    payment_ref character varying,
    internal_index character varying,
    transaction_details jsonb,
    amount numeric,
    amount_currency numeric,
    is_reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount_residual double precision,
    cron_last_check timestamp without time zone,
    unique_import_id character varying,
    online_account_id integer,
    online_link_id integer,
    online_transaction_identifier character varying,
    online_partner_information character varying
);


ALTER TABLE public.account_bank_statement_line OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Journal Currency';


--
-- Name: COLUMN account_bank_statement_line.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.payment_ref IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.internal_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.internal_index IS 'Internal Reference';


--
-- Name: COLUMN account_bank_statement_line.transaction_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_bank_statement_line.cron_last_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.cron_last_check IS 'Cron Last Check';


--
-- Name: COLUMN account_bank_statement_line.unique_import_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.unique_import_id IS 'Import ID';


--
-- Name: COLUMN account_bank_statement_line.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_account_id IS 'Online Account';


--
-- Name: COLUMN account_bank_statement_line.online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_statement_line.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line.online_partner_information; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_partner_information IS 'Online Partner Information';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_bank_statement_line_transient; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line_transient (
    id integer NOT NULL,
    sequence integer,
    journal_id integer,
    online_account_id integer,
    company_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    online_transaction_identifier character varying,
    payment_ref character varying,
    account_number character varying,
    partner_name character varying,
    state character varying,
    date date,
    transaction_details text,
    amount numeric,
    amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_statement_line_transient OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line_transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line_transient IS 'Transient model for bank statement line';


--
-- Name: COLUMN account_bank_statement_line_transient.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line_transient.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line_transient.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_bank_statement_line_transient.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line_transient.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line_transient.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line_transient.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line_transient.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.payment_ref IS 'Payment Ref';


--
-- Name: COLUMN account_bank_statement_line_transient.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.account_number IS 'Account Number';


--
-- Name: COLUMN account_bank_statement_line_transient.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line_transient.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.state IS 'State';


--
-- Name: COLUMN account_bank_statement_line_transient.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.date IS 'Date';


--
-- Name: COLUMN account_bank_statement_line_transient.transaction_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line_transient.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line_transient.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line_transient.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_transient_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNED BY public.account_bank_statement_line_transient.id;


--
-- Name: account_batch_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard (
    id integer NOT NULL,
    batch_payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_remove_options boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard IS 'Batch payments error reporting wizard';


--
-- Name: COLUMN account_batch_error_wizard.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_batch_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard.show_remove_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.show_remove_options IS 'Show Remove Options';


--
-- Name: COLUMN account_batch_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNED BY public.account_batch_error_wizard.id;


--
-- Name: account_batch_error_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line (
    id integer NOT NULL,
    error_wizard_id integer,
    warning_wizard_id integer,
    create_uid integer,
    write_uid integer,
    description character varying NOT NULL,
    help_message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line IS 'Batch payments error reporting wizard line';


--
-- Name: COLUMN account_batch_error_wizard_line.error_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.error_wizard_id IS 'Error Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.warning_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.warning_wizard_id IS 'Warning Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.description IS 'Description';


--
-- Name: COLUMN account_batch_error_wizard_line.help_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.help_message IS 'Help';


--
-- Name: COLUMN account_batch_error_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_line_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line_account_payment_rel (
    account_batch_error_wizard_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_error_wizard_line_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line_account_payment_rel IS 'RELATION BETWEEN account_batch_error_wizard_line AND account_payment';


--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNED BY public.account_batch_error_wizard_line.id;


--
-- Name: account_batch_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment (
    id integer NOT NULL,
    journal_id integer,
    currency_id integer,
    company_currency_id integer,
    payment_method_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    batch_type character varying NOT NULL,
    export_filename character varying,
    date date NOT NULL,
    export_file_create_date date,
    amount_residual numeric,
    amount_residual_currency numeric,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_payment OWNER TO runbot;

--
-- Name: TABLE account_batch_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment IS 'Batch Payment';


--
-- Name: COLUMN account_batch_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.journal_id IS 'Bank';


--
-- Name: COLUMN account_batch_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_batch_payment.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_batch_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_batch_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.name IS 'Reference';


--
-- Name: COLUMN account_batch_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.state IS 'State';


--
-- Name: COLUMN account_batch_payment.batch_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.batch_type IS 'Batch Type';


--
-- Name: COLUMN account_batch_payment.export_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_filename IS 'File Name';


--
-- Name: COLUMN account_batch_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.date IS 'Date';


--
-- Name: COLUMN account_batch_payment.export_file_create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_file_create_date IS 'Generation Date';


--
-- Name: COLUMN account_batch_payment.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual IS 'Amount Residual';


--
-- Name: COLUMN account_batch_payment.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual_currency IS 'Amount Residual Currency';


--
-- Name: COLUMN account_batch_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount IS 'Amount';


--
-- Name: COLUMN account_batch_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_date IS 'Last Updated on';


--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_id_seq OWNER TO runbot;

--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_payment_id_seq OWNED BY public.account_batch_payment.id;


--
-- Name: account_batch_payment_rejection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment_rejection (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_payment_rejection OWNER TO runbot;

--
-- Name: TABLE account_batch_payment_rejection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment_rejection IS 'Manage the payment rejection from batch payments';


--
-- Name: COLUMN account_batch_payment_rejection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment_rejection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment_rejection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment_rejection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment_rejection.write_date IS 'Last Updated on';


--
-- Name: account_batch_payment_rejection_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment_rejection_account_payment_rel (
    account_batch_payment_rejection_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_payment_rejection_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_batch_payment_rejection_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment_rejection_account_payment_rel IS 'RELATION BETWEEN account_batch_payment_rejection AND account_payment';


--
-- Name: account_batch_payment_rejection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_payment_rejection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_rejection_id_seq OWNER TO runbot;

--
-- Name: account_batch_payment_rejection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_payment_rejection_id_seq OWNED BY public.account_batch_payment_rejection.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    strategy character varying NOT NULL,
    rounding_method character varying NOT NULL,
    name jsonb NOT NULL,
    profit_account_id jsonb,
    loss_account_id jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rounding double precision NOT NULL
);


ALTER TABLE public.account_cash_rounding OWNER TO runbot;

--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_cash_rounding.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cash_rounding_id_seq OWNER TO runbot;

--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_change_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_currency (
    id integer NOT NULL,
    currency_to_id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    conversion_rate numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_currency OWNER TO runbot;

--
-- Name: TABLE account_change_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_currency IS 'Change Currency';


--
-- Name: COLUMN account_change_currency.currency_to_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.currency_to_id IS 'Currency to';


--
-- Name: COLUMN account_change_currency.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.move_id IS 'Move';


--
-- Name: COLUMN account_change_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_currency.conversion_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.conversion_rate IS 'Conversion Rate';


--
-- Name: COLUMN account_change_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_date IS 'Created on';


--
-- Name: COLUMN account_change_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_date IS 'Last Updated on';


--
-- Name: account_change_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_currency_id_seq OWNER TO runbot;

--
-- Name: account_change_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_currency_id_seq OWNED BY public.account_change_currency.id;


--
-- Name: account_change_lock_date; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_lock_date (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    exception_applies_to character varying NOT NULL,
    exception_duration character varying NOT NULL,
    exception_reason character varying,
    fiscalyear_lock_date date,
    tax_lock_date date,
    sale_lock_date date,
    purchase_lock_date date,
    hard_lock_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_lock_date OWNER TO runbot;

--
-- Name: TABLE account_change_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_lock_date IS 'Change Lock Date';


--
-- Name: COLUMN account_change_lock_date.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.company_id IS 'Company';


--
-- Name: COLUMN account_change_lock_date.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_lock_date.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_lock_date.exception_applies_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_applies_to IS 'Exception applies';


--
-- Name: COLUMN account_change_lock_date.exception_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_duration IS 'Exception Duration';


--
-- Name: COLUMN account_change_lock_date.exception_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_reason IS 'Exception Reason';


--
-- Name: COLUMN account_change_lock_date.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.fiscalyear_lock_date IS 'Lock Everything';


--
-- Name: COLUMN account_change_lock_date.tax_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.tax_lock_date IS 'Lock Tax Return';


--
-- Name: COLUMN account_change_lock_date.sale_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.sale_lock_date IS 'Lock Sales';


--
-- Name: COLUMN account_change_lock_date.purchase_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.purchase_lock_date IS 'Lock Purchases';


--
-- Name: COLUMN account_change_lock_date.hard_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.hard_lock_date IS 'Hard Lock';


--
-- Name: COLUMN account_change_lock_date.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_date IS 'Created on';


--
-- Name: COLUMN account_change_lock_date.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_date IS 'Last Updated on';


--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_lock_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_lock_date_id_seq OWNER TO runbot;

--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_lock_date_id_seq OWNED BY public.account_change_lock_date.id;


--
-- Name: account_check_action_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_action_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_action_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_action_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_action_wizard IS 'Account Check Action Wizard';


--
-- Name: COLUMN account_check_action_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_action_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_action_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.date IS 'Date';


--
-- Name: COLUMN account_check_action_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_action_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_action_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNED BY public.account_check_action_wizard.id;


--
-- Name: account_check_to_date_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_to_date_report_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_to_date_report_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_to_date_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_to_date_report_wizard IS 'account.check.to_date.report.wizard';


--
-- Name: COLUMN account_check_to_date_report_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.journal_id IS 'Diario';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_to_date_report_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.to_date IS 'Hasta Fecha';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_to_date_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNED BY public.account_check_to_date_report_wizard.id;


--
-- Name: account_debit_note; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_debit_note (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date NOT NULL,
    copy_lines boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_debit_note OWNER TO runbot;

--
-- Name: TABLE account_debit_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_debit_note IS 'Add Debit Note wizard';


--
-- Name: COLUMN account_debit_note.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.journal_id IS 'Use Specific Journal';


--
-- Name: COLUMN account_debit_note.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_uid IS 'Created by';


--
-- Name: COLUMN account_debit_note.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_debit_note.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.reason IS 'Reason';


--
-- Name: COLUMN account_debit_note.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.date IS 'Debit Note Date';


--
-- Name: COLUMN account_debit_note.copy_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.copy_lines IS 'Copy Lines';


--
-- Name: COLUMN account_debit_note.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_date IS 'Created on';


--
-- Name: COLUMN account_debit_note.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_date IS 'Last Updated on';


--
-- Name: account_debit_note_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_debit_note_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_debit_note_id_seq OWNER TO runbot;

--
-- Name: account_debit_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_debit_note_id_seq OWNED BY public.account_debit_note.id;


--
-- Name: account_disallowed_expenses_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_disallowed_expenses_category (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_disallowed_expenses_category OWNER TO runbot;

--
-- Name: TABLE account_disallowed_expenses_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_disallowed_expenses_category IS 'Disallowed Expenses Category';


--
-- Name: COLUMN account_disallowed_expenses_category.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.company_id IS 'Company';


--
-- Name: COLUMN account_disallowed_expenses_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.create_uid IS 'Created by';


--
-- Name: COLUMN account_disallowed_expenses_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_disallowed_expenses_category.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.code IS 'Code';


--
-- Name: COLUMN account_disallowed_expenses_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.name IS 'Name';


--
-- Name: COLUMN account_disallowed_expenses_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.active IS 'Active';


--
-- Name: COLUMN account_disallowed_expenses_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.create_date IS 'Created on';


--
-- Name: COLUMN account_disallowed_expenses_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_category.write_date IS 'Last Updated on';


--
-- Name: account_disallowed_expenses_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_disallowed_expenses_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_disallowed_expenses_category_id_seq OWNER TO runbot;

--
-- Name: account_disallowed_expenses_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_disallowed_expenses_category_id_seq OWNED BY public.account_disallowed_expenses_category.id;


--
-- Name: account_disallowed_expenses_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_disallowed_expenses_rate (
    id integer NOT NULL,
    category_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rate double precision NOT NULL
);


ALTER TABLE public.account_disallowed_expenses_rate OWNER TO runbot;

--
-- Name: TABLE account_disallowed_expenses_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_disallowed_expenses_rate IS 'Disallowed Expenses Rate';


--
-- Name: COLUMN account_disallowed_expenses_rate.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.category_id IS 'Category';


--
-- Name: COLUMN account_disallowed_expenses_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.company_id IS 'Company';


--
-- Name: COLUMN account_disallowed_expenses_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_disallowed_expenses_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_disallowed_expenses_rate.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.date_from IS 'Start Date';


--
-- Name: COLUMN account_disallowed_expenses_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_disallowed_expenses_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_disallowed_expenses_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_disallowed_expenses_rate.rate IS 'Disallowed %';


--
-- Name: account_disallowed_expenses_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_disallowed_expenses_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_disallowed_expenses_rate_id_seq OWNER TO runbot;

--
-- Name: account_disallowed_expenses_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_disallowed_expenses_rate_id_seq OWNED BY public.account_disallowed_expenses_rate.id;


--
-- Name: account_duplicate_transaction_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_duplicate_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_duplicate_transaction_wizard OWNER TO runbot;

--
-- Name: TABLE account_duplicate_transaction_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_duplicate_transaction_wizard IS 'Wizard for duplicate transactions';


--
-- Name: COLUMN account_duplicate_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_duplicate_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNER TO runbot;

--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNED BY public.account_duplicate_transaction_wizard.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_financial_year_op OWNER TO runbot;

--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_financial_year_op_id_seq OWNER TO runbot;

--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    country_id integer,
    country_group_id integer,
    create_uid integer,
    write_uid integer,
    zip_from character varying,
    zip_to character varying,
    foreign_vat character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    auto_apply boolean,
    vat_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    avatax_invoice_account_id integer,
    avatax_refund_account_id integer,
    is_avatax boolean,
    deduct_price_included_taxes boolean
);


ALTER TABLE public.account_fiscal_position OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.foreign_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.foreign_vat IS 'Foreign Tax ID';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position.avatax_invoice_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_invoice_account_id IS 'Avatax Invoice Account';


--
-- Name: COLUMN account_fiscal_position.avatax_refund_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_refund_account_id IS 'Avatax Refund Account';


--
-- Name: COLUMN account_fiscal_position.is_avatax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.is_avatax IS 'Use AvaTax API';


--
-- Name: COLUMN account_fiscal_position.deduct_price_included_taxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.deduct_price_included_taxes IS 'Deduct Price-Included Taxes';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_l10n_ar_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_l10n_ar_tax (
    id integer NOT NULL,
    fiscal_position_id integer NOT NULL,
    default_tax_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    webservice character varying,
    tax_type character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_l10n_ar_tax OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_l10n_ar_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_l10n_ar_tax IS 'account.fiscal.position.l10n_ar_tax';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.default_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.default_tax_id IS 'Default Tax';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.webservice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.webservice IS 'Webservice';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.tax_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.tax_type IS 'Tax Type';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_l10n_ar_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_l10n_ar_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq OWNED BY public.account_fiscal_position_l10n_ar_tax.id;


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_position_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_tax (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    tax_src_id integer NOT NULL,
    tax_dest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_tax OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_tax IS 'Tax Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_tax.tax_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_src_id IS 'Tax on Product';


--
-- Name: COLUMN account_fiscal_position_tax.tax_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.tax_dest_id IS 'Tax to Apply';


--
-- Name: COLUMN account_fiscal_position_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_tax.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_tax_id_seq OWNED BY public.account_fiscal_position_tax.id;


--
-- Name: account_fiscal_year; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_year (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_year OWNER TO runbot;

--
-- Name: TABLE account_fiscal_year; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_year IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscal_year.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_year.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_year.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_year.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.name IS 'Name';


--
-- Name: COLUMN account_fiscal_year.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_from IS 'Start Date';


--
-- Name: COLUMN account_fiscal_year.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_to IS 'End Date';


--
-- Name: COLUMN account_fiscal_year.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_year.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_year_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_year_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_year_id_seq OWNED BY public.account_fiscal_year.id;


--
-- Name: account_followup_followup_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_followup_line (
    id integer NOT NULL,
    delay integer NOT NULL,
    company_id integer NOT NULL,
    mail_template_id integer,
    sms_template_id integer,
    activity_type_id integer,
    create_uid integer,
    write_uid integer,
    activity_summary character varying,
    activity_default_responsible_type character varying NOT NULL,
    name jsonb NOT NULL,
    activity_note text,
    send_email boolean,
    join_invoices boolean,
    send_sms boolean,
    create_activity boolean,
    auto_execute boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    send_letter boolean
);


ALTER TABLE public.account_followup_followup_line OWNER TO runbot;

--
-- Name: TABLE account_followup_followup_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_followup_line IS 'Follow-up Criteria';


--
-- Name: COLUMN account_followup_followup_line.delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.delay IS 'Due Days';


--
-- Name: COLUMN account_followup_followup_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.company_id IS 'Company';


--
-- Name: COLUMN account_followup_followup_line.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.mail_template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_followup_line.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_followup_line.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN account_followup_followup_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_followup_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_followup_line.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_summary IS 'Summary';


--
-- Name: COLUMN account_followup_followup_line.activity_default_responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_default_responsible_type IS 'Responsible';


--
-- Name: COLUMN account_followup_followup_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.name IS 'Description';


--
-- Name: COLUMN account_followup_followup_line.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_note IS 'Note';


--
-- Name: COLUMN account_followup_followup_line.send_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_email IS 'Send Email';


--
-- Name: COLUMN account_followup_followup_line.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_followup_line.send_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_sms IS 'Send SMS Message';


--
-- Name: COLUMN account_followup_followup_line.create_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_activity IS 'Schedule Activity';


--
-- Name: COLUMN account_followup_followup_line.auto_execute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.auto_execute IS 'Automatic';


--
-- Name: COLUMN account_followup_followup_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_followup_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_followup_line.send_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_letter IS 'Send a Letter';


--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_followup_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNER TO runbot;

--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNED BY public.account_followup_followup_line.id;


--
-- Name: account_followup_followup_line_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_followup_line_res_users_rel (
    account_followup_followup_line_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.account_followup_followup_line_res_users_rel OWNER TO runbot;

--
-- Name: TABLE account_followup_followup_line_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_followup_line_res_users_rel IS 'RELATION BETWEEN account_followup_followup_line AND res_users';


--
-- Name: account_followup_manual_reminder; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder (
    id integer NOT NULL,
    template_id integer,
    partner_id integer,
    sms_template_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    sms_body character varying,
    body text,
    email boolean,
    sms boolean,
    print boolean,
    join_invoices boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    snailmail boolean
);


ALTER TABLE public.account_followup_manual_reminder OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder IS 'Wizard for sending manual reminders to clients';


--
-- Name: COLUMN account_followup_manual_reminder.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_manual_reminder.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.partner_id IS 'Partner';


--
-- Name: COLUMN account_followup_manual_reminder.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_manual_reminder.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_manual_reminder.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_manual_reminder.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.lang IS 'Language';


--
-- Name: COLUMN account_followup_manual_reminder.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.subject IS 'Subject';


--
-- Name: COLUMN account_followup_manual_reminder.sms_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_body IS 'Sms Body';


--
-- Name: COLUMN account_followup_manual_reminder.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.body IS 'Contents';


--
-- Name: COLUMN account_followup_manual_reminder.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.email IS 'Email';


--
-- Name: COLUMN account_followup_manual_reminder.sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms IS 'Sms';


--
-- Name: COLUMN account_followup_manual_reminder.print; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.print IS 'Print';


--
-- Name: COLUMN account_followup_manual_reminder.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_manual_reminder.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_manual_reminder.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_manual_reminder.snailmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.snailmail IS 'Snailmail';


--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_manual_reminder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNER TO runbot;

--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNED BY public.account_followup_manual_reminder.id;


--
-- Name: account_followup_manual_reminder_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder_ir_attachment_rel (
    account_followup_manual_reminder_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_followup_manual_reminder_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder_ir_attachment_rel IS 'RELATION BETWEEN account_followup_manual_reminder AND ir_attachment';


--
-- Name: account_followup_missing_information_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_missing_information_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_followup_missing_information_wizard OWNER TO runbot;

--
-- Name: TABLE account_followup_missing_information_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_missing_information_wizard IS 'Followup missing information wizard';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_date IS 'Last Updated on';


--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_missing_information_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNER TO runbot;

--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNED BY public.account_followup_missing_information_wizard.id;


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    exchange_move_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_full_reconcile OWNER TO runbot;

--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_full_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code_prefix_start character varying,
    code_prefix_end character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_group_check_length_prefix CHECK ((char_length((COALESCE(code_prefix_start, ''::character varying))::text) = char_length((COALESCE(code_prefix_end, ''::character varying))::text)))
);


ALTER TABLE public.account_group OWNER TO runbot;

--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.company_id IS 'Company';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.code_prefix_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group.code_prefix_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_group_check_length_prefix ON account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_group_check_length_prefix ON public.account_group IS 'CHECK(char_length(COALESCE(code_prefix_start, '''')) = char_length(COALESCE(code_prefix_end, '''')))';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_id_seq OWNER TO runbot;

--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_import_summary; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    import_summary_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_import_summary OWNER TO runbot;

--
-- Name: TABLE account_import_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary IS 'Account import summary view';


--
-- Name: COLUMN account_import_summary.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.create_uid IS 'Created by';


--
-- Name: COLUMN account_import_summary.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_import_summary.import_summary_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.import_summary_name IS 'Import Summary Name';


--
-- Name: COLUMN account_import_summary.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.create_date IS 'Created on';


--
-- Name: COLUMN account_import_summary.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.write_date IS 'Last Updated on';


--
-- Name: account_import_summary_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_account_journal_rel (
    account_import_summary_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_account_journal_rel IS 'RELATION BETWEEN account_import_summary AND account_journal';


--
-- Name: account_import_summary_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_account_move_rel (
    account_import_summary_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_account_move_rel IS 'RELATION BETWEEN account_import_summary AND account_move';


--
-- Name: account_import_summary_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_account_tax_rel (
    account_import_summary_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_account_tax_rel IS 'RELATION BETWEEN account_import_summary AND account_tax';


--
-- Name: account_import_summary_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_import_summary_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_import_summary_id_seq OWNER TO runbot;

--
-- Name: account_import_summary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_import_summary_id_seq OWNED BY public.account_import_summary.id;


--
-- Name: account_import_summary_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_res_partner_rel (
    account_import_summary_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_res_partner_rel IS 'RELATION BETWEEN account_import_summary AND res_partner';


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying(3) NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_incoterms OWNER TO runbot;

--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_incoterms_id_seq OWNER TO runbot;

--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_invoice_extract_words; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_extract_words (
    id integer NOT NULL,
    invoice_id integer NOT NULL,
    word_page integer,
    create_uid integer,
    write_uid integer,
    field character varying,
    word_text character varying,
    ocr_selected boolean,
    user_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "word_box_midX" double precision,
    "word_box_midY" double precision,
    word_box_width double precision,
    word_box_height double precision,
    word_box_angle double precision
);


ALTER TABLE public.account_invoice_extract_words OWNER TO runbot;

--
-- Name: TABLE account_invoice_extract_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_extract_words IS 'Extracted words from invoice scan';


--
-- Name: COLUMN account_invoice_extract_words.invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.invoice_id IS 'Invoice';


--
-- Name: COLUMN account_invoice_extract_words.word_page; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_page IS 'Word Page';


--
-- Name: COLUMN account_invoice_extract_words.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_extract_words.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_extract_words.field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.field IS 'Field';


--
-- Name: COLUMN account_invoice_extract_words.word_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_text IS 'Word Text';


--
-- Name: COLUMN account_invoice_extract_words.ocr_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.ocr_selected IS 'Ocr Selected';


--
-- Name: COLUMN account_invoice_extract_words.user_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.user_selected IS 'User Selected';


--
-- Name: COLUMN account_invoice_extract_words.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_extract_words.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midX"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midX" IS 'Word Box Midx';


--
-- Name: COLUMN account_invoice_extract_words."word_box_midY"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words."word_box_midY" IS 'Word Box Midy';


--
-- Name: COLUMN account_invoice_extract_words.word_box_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_width IS 'Word Box Width';


--
-- Name: COLUMN account_invoice_extract_words.word_box_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_height IS 'Word Box Height';


--
-- Name: COLUMN account_invoice_extract_words.word_box_angle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_extract_words.word_box_angle IS 'Word Box Angle';


--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_extract_words_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_extract_words_id_seq OWNER TO runbot;

--
-- Name: account_invoice_extract_words_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_extract_words_id_seq OWNED BY public.account_invoice_extract_words.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_transaction_rel (
    invoice_id integer NOT NULL,
    transaction_id integer NOT NULL
);


ALTER TABLE public.account_invoice_transaction_rel OWNER TO runbot;

--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN account_move AND payment_transaction';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    alias_id integer,
    default_account_id integer,
    suspense_account_id integer,
    sequence integer,
    currency_id integer,
    company_id integer NOT NULL,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    create_uid integer,
    write_uid integer,
    color integer,
    access_token character varying,
    code character varying(5) NOT NULL,
    type character varying NOT NULL,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    bank_statements_source character varying,
    name jsonb NOT NULL,
    sequence_override_regex text,
    active boolean,
    autocheck_on_post boolean,
    restrict_mode_hash_table boolean,
    refund_sequence boolean,
    payment_sequence boolean,
    show_on_dashboard boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    debit_sequence boolean,
    account_online_account_id integer,
    account_online_link_id integer,
    renewal_contact_email character varying,
    l10n_latam_use_documents boolean,
    nacha_immediate_destination character varying,
    nacha_destination character varying,
    nacha_immediate_origin character varying,
    nacha_company_identification character varying,
    nacha_origination_dfi_identification character varying,
    nacha_entry_class_code character varying NOT NULL,
    nacha_discretionary_data character varying(20),
    nacha_is_balanced boolean,
    mail_template_id integer,
    l10n_ar_afip_pos_number integer,
    l10n_ar_afip_pos_partner_id integer,
    l10n_ar_afip_pos_system character varying,
    l10n_ar_is_pos boolean,
    settlement_partner_id integer,
    settlement_account_id integer,
    tax_settlement character varying,
    settlement_tax character varying,
    qr_code_label character varying,
    qr_code character varying,
    discriminate_taxes character varying NOT NULL,
    check_add_debit_button boolean,
    loan_properties_definition jsonb
);


ALTER TABLE public.account_journal OWNER TO runbot;

--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Alias';


--
-- Name: COLUMN account_journal.default_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.default_account_id IS 'Default Account';


--
-- Name: COLUMN account_journal.suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.suspense_account_id IS 'Suspense Account';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.access_token IS 'Security Token';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.code IS 'Short Code';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.sequence_override_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence_override_regex IS 'Sequence Override Regex';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.autocheck_on_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.autocheck_on_post IS 'Auto-Check on Post';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Secure Posted Entries with Hash';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.payment_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.payment_sequence IS 'Dedicated Payment Sequence';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal.debit_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.debit_sequence IS 'Dedicated Debit Note Sequence';


--
-- Name: COLUMN account_journal.account_online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_journal.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_journal.renewal_contact_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.renewal_contact_email IS 'Connection Requests';


--
-- Name: COLUMN account_journal.l10n_latam_use_documents; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_latam_use_documents IS 'Use Documents?';


--
-- Name: COLUMN account_journal.nacha_immediate_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_destination IS 'Immediate Destination';


--
-- Name: COLUMN account_journal.nacha_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_destination IS 'Destination';


--
-- Name: COLUMN account_journal.nacha_immediate_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_origin IS 'Immediate Origin';


--
-- Name: COLUMN account_journal.nacha_company_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_company_identification IS 'Company Identification';


--
-- Name: COLUMN account_journal.nacha_origination_dfi_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_origination_dfi_identification IS 'Origination Dfi Identification';


--
-- Name: COLUMN account_journal.nacha_entry_class_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_entry_class_code IS 'Standard Entry Class Code';


--
-- Name: COLUMN account_journal.nacha_discretionary_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_discretionary_data IS 'Company Discretionary Data';


--
-- Name: COLUMN account_journal.nacha_is_balanced; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_is_balanced IS 'Generate Balanced Files';


--
-- Name: COLUMN account_journal.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.mail_template_id IS 'Email Template';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_number IS 'AFIP POS Number';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_partner_id IS 'AFIP POS Address';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_system; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_system IS 'AFIP POS System';


--
-- Name: COLUMN account_journal.l10n_ar_is_pos; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_is_pos IS 'Is AFIP POS?';


--
-- Name: COLUMN account_journal.settlement_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.settlement_partner_id IS 'Partner de liquidación';


--
-- Name: COLUMN account_journal.settlement_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.settlement_account_id IS 'Cuenta de contrapartida';


--
-- Name: COLUMN account_journal.tax_settlement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.tax_settlement IS 'Tax Settlement';


--
-- Name: COLUMN account_journal.settlement_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.settlement_tax IS 'Impuesto de liquidación';


--
-- Name: COLUMN account_journal.qr_code_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code_label IS 'QR Code Label';


--
-- Name: COLUMN account_journal.qr_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code IS 'QR Code';


--
-- Name: COLUMN account_journal.discriminate_taxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.discriminate_taxes IS 'Discriminate taxes?';


--
-- Name: COLUMN account_journal.check_add_debit_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_add_debit_button IS 'Agregar botón de débito';


--
-- Name: COLUMN account_journal.loan_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loan_properties_definition IS 'Model Properties';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_journal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_tag (
    account_journal_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_tag OWNER TO runbot;

--
-- Name: TABLE account_journal_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_tag IS 'RELATION BETWEEN account_journal AND account_account_tag';


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_group OWNER TO runbot;

--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Ledger group';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_group_id_seq OWNER TO runbot;

--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_id_seq OWNER TO runbot;

--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_loan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan (
    id integer NOT NULL,
    company_id integer NOT NULL,
    duration integer,
    long_term_account_id integer,
    short_term_account_id integer,
    expense_account_id integer,
    journal_id integer,
    asset_group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    display_name character varying,
    date date,
    skip_until_date date,
    loan_properties jsonb,
    amount_borrowed numeric,
    interest numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan OWNER TO runbot;

--
-- Name: TABLE account_loan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan IS 'Loan';


--
-- Name: COLUMN account_loan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.company_id IS 'Company';


--
-- Name: COLUMN account_loan.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.duration IS 'Duration';


--
-- Name: COLUMN account_loan.long_term_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.long_term_account_id IS 'Long Term Account';


--
-- Name: COLUMN account_loan.short_term_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.short_term_account_id IS 'Short Term Account';


--
-- Name: COLUMN account_loan.expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.expense_account_id IS 'Expense Account';


--
-- Name: COLUMN account_loan.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.journal_id IS 'Journal';


--
-- Name: COLUMN account_loan.asset_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_loan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.name IS 'Name';


--
-- Name: COLUMN account_loan.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.state IS 'Status';


--
-- Name: COLUMN account_loan.display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.display_name IS 'Loan name';


--
-- Name: COLUMN account_loan.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.date IS 'Loan Date';


--
-- Name: COLUMN account_loan.skip_until_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.skip_until_date IS 'Skip until';


--
-- Name: COLUMN account_loan.loan_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.loan_properties IS 'Properties';


--
-- Name: COLUMN account_loan.amount_borrowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.amount_borrowed IS 'Amount Borrowed';


--
-- Name: COLUMN account_loan.interest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.interest IS 'Interest';


--
-- Name: COLUMN account_loan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.active IS 'Active';


--
-- Name: COLUMN account_loan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.create_date IS 'Created on';


--
-- Name: COLUMN account_loan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_close_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_close_wizard OWNER TO runbot;

--
-- Name: TABLE account_loan_close_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_close_wizard IS 'Close Loan Wizard';


--
-- Name: COLUMN account_loan_close_wizard.loan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_close_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_close_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_close_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.date IS 'Close Date';


--
-- Name: COLUMN account_loan_close_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_close_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_close_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_close_wizard_id_seq OWNER TO runbot;

--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_close_wizard_id_seq OWNED BY public.account_loan_close_wizard.id;


--
-- Name: account_loan_compute_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_compute_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    loan_term integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_end_of_month character varying NOT NULL,
    compounding_method character varying NOT NULL,
    start_date date NOT NULL,
    first_payment_date date NOT NULL,
    loan_amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    interest_rate double precision NOT NULL
);


ALTER TABLE public.account_loan_compute_wizard OWNER TO runbot;

--
-- Name: TABLE account_loan_compute_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_compute_wizard IS 'Loan Compute Wizard';


--
-- Name: COLUMN account_loan_compute_wizard.loan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_compute_wizard.loan_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_term IS 'Loan Term';


--
-- Name: COLUMN account_loan_compute_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_compute_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_compute_wizard.payment_end_of_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.payment_end_of_month IS 'Payment';


--
-- Name: COLUMN account_loan_compute_wizard.compounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.compounding_method IS 'Compounding Method';


--
-- Name: COLUMN account_loan_compute_wizard.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.start_date IS 'Start Date';


--
-- Name: COLUMN account_loan_compute_wizard.first_payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.first_payment_date IS 'First Payment';


--
-- Name: COLUMN account_loan_compute_wizard.loan_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_amount IS 'Loan Amount';


--
-- Name: COLUMN account_loan_compute_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_compute_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_loan_compute_wizard.interest_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.interest_rate IS 'Interest Rate';


--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_compute_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_compute_wizard_id_seq OWNER TO runbot;

--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_compute_wizard_id_seq OWNED BY public.account_loan_compute_wizard.id;


--
-- Name: account_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_id_seq OWNER TO runbot;

--
-- Name: account_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_id_seq OWNED BY public.account_loan.id;


--
-- Name: account_loan_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_line (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    principal numeric,
    interest numeric,
    payment numeric,
    long_term_theoretical_balance numeric,
    short_term_theoretical_balance numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_line OWNER TO runbot;

--
-- Name: TABLE account_loan_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_line IS 'Loan Line';


--
-- Name: COLUMN account_loan_line.loan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.date IS 'Date';


--
-- Name: COLUMN account_loan_line.principal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.principal IS 'Principal';


--
-- Name: COLUMN account_loan_line.interest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.interest IS 'Interest';


--
-- Name: COLUMN account_loan_line.payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.payment IS 'Payment';


--
-- Name: COLUMN account_loan_line.long_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.long_term_theoretical_balance IS 'Long-Term';


--
-- Name: COLUMN account_loan_line.short_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.short_term_theoretical_balance IS 'Short-Term';


--
-- Name: COLUMN account_loan_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.write_date IS 'Last Updated on';


--
-- Name: account_loan_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_line_id_seq OWNER TO runbot;

--
-- Name: account_loan_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_line_id_seq OWNED BY public.account_loan_line.id;


--
-- Name: account_lock_exception; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_lock_exception (
    id integer NOT NULL,
    company_id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    lock_date_field character varying NOT NULL,
    lock_date date,
    company_lock_date date,
    active boolean,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_lock_exception OWNER TO runbot;

--
-- Name: TABLE account_lock_exception; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_lock_exception IS 'Account Lock Exception';


--
-- Name: COLUMN account_lock_exception.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_id IS 'Company';


--
-- Name: COLUMN account_lock_exception.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.user_id IS 'User';


--
-- Name: COLUMN account_lock_exception.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_uid IS 'Created by';


--
-- Name: COLUMN account_lock_exception.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_lock_exception.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.reason IS 'Reason';


--
-- Name: COLUMN account_lock_exception.lock_date_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date_field IS 'Lock Date Field';


--
-- Name: COLUMN account_lock_exception.lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date IS 'Changed Lock Date';


--
-- Name: COLUMN account_lock_exception.company_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_lock_date IS 'Original Lock Date';


--
-- Name: COLUMN account_lock_exception.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.active IS 'Active';


--
-- Name: COLUMN account_lock_exception.end_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.end_datetime IS 'End Date';


--
-- Name: COLUMN account_lock_exception.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_date IS 'Created on';


--
-- Name: COLUMN account_lock_exception.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_date IS 'Last Updated on';


--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_lock_exception_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_lock_exception_id_seq OWNER TO runbot;

--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_lock_exception_id_seq OWNED BY public.account_lock_exception.id;


--
-- Name: account_merge_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    is_group_by_name boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard IS 'Account merge wizard';


--
-- Name: COLUMN account_merge_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard.is_group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.is_group_by_name IS 'Group by name?';


--
-- Name: COLUMN account_merge_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_id_seq OWNED BY public.account_merge_wizard.id;


--
-- Name: account_merge_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    sequence integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    grouping_key character varying,
    display_type character varying NOT NULL,
    is_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard_line IS 'Account merge wizard line';


--
-- Name: COLUMN account_merge_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_merge_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_merge_wizard_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.account_id IS 'Account';


--
-- Name: COLUMN account_merge_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard_line.grouping_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.grouping_key IS 'Grouping Key';


--
-- Name: COLUMN account_merge_wizard_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_merge_wizard_line.is_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.is_selected IS 'Is Selected';


--
-- Name: COLUMN account_merge_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNED BY public.account_merge_wizard_line.id;


--
-- Name: account_missing_transaction_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_missing_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_missing_transaction_wizard OWNER TO runbot;

--
-- Name: TABLE account_missing_transaction_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_missing_transaction_wizard IS 'Wizard for missing transactions';


--
-- Name: COLUMN account_missing_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_missing_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_missing_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_missing_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_missing_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_missing_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_missing_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNER TO runbot;

--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNED BY public.account_missing_transaction_wizard.id;


--
-- Name: account_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_model_rel (
    account_transfer_model_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_model_rel OWNER TO runbot;

--
-- Name: TABLE account_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_model_rel IS 'RELATION BETWEEN account_transfer_model AND account_account';


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    sequence_number integer,
    message_main_attachment_id integer,
    journal_id integer NOT NULL,
    company_id integer,
    origin_payment_id integer,
    statement_line_id integer,
    tax_cash_basis_rec_id integer,
    tax_cash_basis_origin_move_id integer,
    auto_post_origin_id integer,
    secure_sequence_number integer,
    invoice_payment_term_id integer,
    partner_id integer,
    commercial_partner_id integer,
    partner_shipping_id integer,
    partner_bank_id integer,
    fiscal_position_id integer,
    preferred_payment_method_line_id integer,
    currency_id integer NOT NULL,
    reversed_entry_id integer,
    invoice_user_id integer,
    invoice_incoterm_id integer,
    invoice_cash_rounding_id integer,
    create_uid integer,
    write_uid integer,
    sequence_prefix character varying,
    access_token character varying,
    name character varying,
    ref character varying,
    state character varying NOT NULL,
    move_type character varying NOT NULL,
    auto_post character varying NOT NULL,
    inalterable_hash character varying,
    payment_reference character varying,
    qr_code_method character varying,
    payment_state character varying,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_origin character varying,
    incoterm_location character varying,
    date date NOT NULL,
    auto_post_until date,
    invoice_date date,
    invoice_date_due date,
    delivery_date date,
    sending_data jsonb,
    narration text,
    invoice_currency_rate numeric,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_untaxed_in_currency_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_total_in_currency_signed numeric,
    amount_residual_signed numeric,
    quick_edit_total_amount numeric,
    is_storno boolean,
    always_tax_exigible boolean,
    checked boolean,
    posted_before boolean,
    made_sequence_gap boolean,
    is_manually_modified boolean,
    is_move_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    signing_user integer,
    payment_state_before_switch character varying,
    debit_origin_id integer,
    transfer_model_id integer,
    avatax_tax_date date,
    l10n_latam_document_type_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    pay_now_journal_id integer,
    tax_closing_report_id integer,
    internal_notes text,
    l10n_ar_afip_responsibility_type_id integer,
    l10n_ar_afip_service_start date,
    l10n_ar_afip_service_end date,
    asset_id integer,
    asset_number_days integer,
    asset_move_type character varying,
    asset_depreciation_beginning_date date,
    depreciation_value numeric,
    asset_value_change boolean,
    extract_attachment_id integer,
    extract_detected_layout integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    extract_partner_name character varying,
    extract_prefill_data jsonb,
    is_in_extractable_state boolean,
    extract_state_processed boolean,
    receiptbook_id integer,
    l10n_ar_fce_transmission_type character varying,
    l10n_ar_afip_auth_mode character varying,
    l10n_ar_afip_auth_code character varying(24),
    l10n_ar_afip_result character varying,
    l10n_ar_afip_verification_result character varying,
    l10n_ar_afip_auth_code_due date,
    l10n_ar_afip_xml_request text,
    l10n_ar_afip_xml_response text,
    l10n_ar_afip_fce_is_cancellation boolean,
    generating_loan_line_id integer,
    is_loan_payment_move boolean,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date
);


ALTER TABLE public.account_move OWNER TO runbot;

--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move IS 'Journal Entry';


--
-- Name: COLUMN account_move.sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.origin_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.origin_payment_id IS 'Payment';


--
-- Name: COLUMN account_move.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.statement_line_id IS 'Statement Line';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.tax_cash_basis_origin_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_origin_move_id IS 'Cash Basis Origin';


--
-- Name: COLUMN account_move.auto_post_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_origin_id IS 'First recurring entry';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalterability No Gap Sequence #';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN account_move.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_bank_id IS 'Recipient Bank';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.preferred_payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.preferred_payment_method_line_id IS 'Preferred Payment Method Line';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.sequence_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.move_type IS 'Type';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Auto-post';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_move.qr_code_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.qr_code_method IS 'Payment QR-code';


--
-- Name: COLUMN account_move.payment_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state IS 'Payment Status';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.incoterm_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.incoterm_location IS 'Incoterm Location';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.auto_post_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_until IS 'Auto-post until';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.delivery_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.delivery_date IS 'Delivery Date';


--
-- Name: COLUMN account_move.sending_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sending_data IS 'Sending Data';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.invoice_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_untaxed_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_in_currency_signed IS 'Untaxed Amount Signed Currency';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_total_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_in_currency_signed IS 'Total in Currency Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.quick_edit_total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.quick_edit_total_amount IS 'Total (Tax inc.)';


--
-- Name: COLUMN account_move.is_storno; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_storno IS 'Is Storno';


--
-- Name: COLUMN account_move.always_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.always_tax_exigible IS 'Always Tax Exigible';


--
-- Name: COLUMN account_move.checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.checked IS 'Checked';


--
-- Name: COLUMN account_move.posted_before; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.posted_before IS 'Posted Before';


--
-- Name: COLUMN account_move.made_sequence_gap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.made_sequence_gap IS 'Made Sequence Gap';


--
-- Name: COLUMN account_move.is_manually_modified; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_manually_modified IS 'Is Manually Modified';


--
-- Name: COLUMN account_move.is_move_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_move_sent IS 'Is Move Sent';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.signing_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.signing_user IS 'Signer';


--
-- Name: COLUMN account_move.payment_state_before_switch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state_before_switch IS 'Payment State Before Switch';


--
-- Name: COLUMN account_move.debit_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.debit_origin_id IS 'Original Invoice Debited';


--
-- Name: COLUMN account_move.transfer_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.transfer_model_id IS 'Originating Model';


--
-- Name: COLUMN account_move.avatax_tax_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.avatax_tax_date IS 'Avatax Date';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: COLUMN account_move.pay_now_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.pay_now_journal_id IS 'Pay now Journal';


--
-- Name: COLUMN account_move.tax_closing_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_closing_report_id IS 'Tax Closing Report';


--
-- Name: COLUMN account_move.internal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.internal_notes IS 'Internal Notes';


--
-- Name: COLUMN account_move.l10n_ar_afip_responsibility_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_responsibility_type_id IS 'AFIP Responsibility Type';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_start IS 'AFIP Service Start Date';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_end IS 'AFIP Service End Date';


--
-- Name: COLUMN account_move.asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_id IS 'Asset';


--
-- Name: COLUMN account_move.asset_number_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_number_days IS 'Number of days';


--
-- Name: COLUMN account_move.asset_move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_move_type IS 'Asset Move Type';


--
-- Name: COLUMN account_move.asset_depreciation_beginning_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_depreciation_beginning_date IS 'Date of the beginning of the depreciation';


--
-- Name: COLUMN account_move.depreciation_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.depreciation_value IS 'Depreciation';


--
-- Name: COLUMN account_move.asset_value_change; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_value_change IS 'Asset Value Change';


--
-- Name: COLUMN account_move.extract_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_attachment_id IS 'Extract Attachment';


--
-- Name: COLUMN account_move.extract_detected_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_detected_layout IS 'Extract Detected Layout Id';


--
-- Name: COLUMN account_move.extract_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_state IS 'Extract state';


--
-- Name: COLUMN account_move.extract_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_status IS 'Extract status';


--
-- Name: COLUMN account_move.extract_document_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_move.extract_partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_partner_name IS 'Extract Detected Partner Name';


--
-- Name: COLUMN account_move.extract_prefill_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_prefill_data IS 'Extract Prefill Data';


--
-- Name: COLUMN account_move.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_move.extract_state_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_state_processed IS 'Extract State Processed';


--
-- Name: COLUMN account_move.receiptbook_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.receiptbook_id IS 'ReceiptBook';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_mode IS 'AFIP Authorization Mode';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code IS 'Authorization Code';


--
-- Name: COLUMN account_move.l10n_ar_afip_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_result IS 'Result';


--
-- Name: COLUMN account_move.l10n_ar_afip_verification_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_verification_result IS 'AFIP Verification result';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code_due IS 'Authorization Due date';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_request IS 'XML Request';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_response IS 'XML Response';


--
-- Name: COLUMN account_move.l10n_ar_afip_fce_is_cancellation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_fce_is_cancellation IS 'FCE: Is Cancellation?';


--
-- Name: COLUMN account_move.generating_loan_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.generating_loan_line_id IS 'Generating Loan Line';


--
-- Name: COLUMN account_move.is_loan_payment_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_loan_payment_move IS 'Is Loan Payment Move';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_start IS 'Associated Period Start';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_end IS 'Associated Perdio End';


--
-- Name: account_move__account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move__account_payment (
    invoice_id integer NOT NULL,
    payment_id integer NOT NULL
);


ALTER TABLE public.account_move__account_payment OWNER TO runbot;

--
-- Name: TABLE account_move__account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move__account_payment IS 'RELATION BETWEEN account_move AND account_payment';


--
-- Name: account_move_account_move_send_batch_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_move_send_batch_wizard_rel (
    account_move_send_batch_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_move_send_batch_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_move_send_batch_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_move_send_batch_wizard_rel IS 'RELATION BETWEEN account_move_send_batch_wizard AND account_move';


--
-- Name: account_move_account_resequence_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_resequence_wizard_rel (
    account_resequence_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_resequence_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_resequence_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_resequence_wizard_rel IS 'RELATION BETWEEN account_resequence_wizard AND account_move';


--
-- Name: account_move_asset_modify_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_asset_modify_rel OWNER TO runbot;

--
-- Name: TABLE account_move_asset_modify_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move';


--
-- Name: account_move_change_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_change_rate (
    id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    currency_rate numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_change_rate OWNER TO runbot;

--
-- Name: TABLE account_move_change_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_change_rate IS 'account.move.change.rate';


--
-- Name: COLUMN account_move_change_rate.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.move_id IS 'Move';


--
-- Name: COLUMN account_move_change_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_change_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_change_rate.currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move_change_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_move_change_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_date IS 'Last Updated on';


--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_change_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_change_rate_id_seq OWNER TO runbot;

--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_change_rate_id_seq OWNED BY public.account_move_change_rate.id;


--
-- Name: account_move_debit_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_debit_move (
    debit_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_debit_move OWNER TO runbot;

--
-- Name: TABLE account_move_debit_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_debit_move IS 'RELATION BETWEEN account_debit_note AND account_move';


--
-- Name: account_move_deferred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_deferred_rel (
    original_move_id integer NOT NULL,
    deferred_move_id integer NOT NULL
);


ALTER TABLE public.account_move_deferred_rel OWNER TO runbot;

--
-- Name: TABLE account_move_deferred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_deferred_rel IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_id_seq OWNER TO runbot;

--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_l10n_ar_boarding_permission_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_l10n_ar_boarding_permission_rel (
    account_move_id integer NOT NULL,
    l10n_ar_boarding_permission_id integer NOT NULL
);


ALTER TABLE public.account_move_l10n_ar_boarding_permission_rel OWNER TO runbot;

--
-- Name: TABLE account_move_l10n_ar_boarding_permission_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_l10n_ar_boarding_permission_rel IS 'RELATION BETWEEN account_move AND l10n_ar_boarding_permission';


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    sequence integer,
    account_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    group_tax_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_repartition_line_id integer,
    full_reconcile_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    move_name character varying,
    parent_state character varying,
    ref character varying,
    name character varying,
    matching_number character varying,
    display_type character varying NOT NULL,
    date date,
    invoice_date date,
    date_maturity date,
    discount_date date,
    analytic_distribution jsonb,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    tax_base_amount numeric,
    amount_residual numeric,
    amount_residual_currency numeric,
    quantity numeric,
    price_unit numeric,
    price_subtotal numeric,
    price_total numeric,
    discount numeric,
    discount_amount_currency numeric,
    discount_balance numeric,
    is_imported boolean,
    tax_tag_invert boolean,
    reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    deferred_start_date date,
    deferred_end_date date,
    l10n_latam_document_type_id integer,
    is_downpayment boolean,
    exclude_bank_lines boolean,
    user_id integer,
    followup_line_id integer,
    tax_settlement_move_id integer,
    tax_state character varying,
    no_followup boolean DEFAULT false,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR (((balance <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR ((balance >= (0)::numeric) AND (amount_currency >= (0)::numeric))))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


ALTER TABLE public.account_move_line OWNER TO runbot;

--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Originator Statement Line';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.group_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.group_tax_id IS 'Originator Group of Taxes';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Distribution Line';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit of Measure';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.matching_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.matching_number IS 'Matching #';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.discount_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_date IS 'Discount Date';


--
-- Name: COLUMN account_move_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.discount_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_amount_currency IS 'Discount amount in Currency';


--
-- Name: COLUMN account_move_line.discount_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_balance IS 'Discount Balance';


--
-- Name: COLUMN account_move_line.is_imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_imported IS 'Is Imported';


--
-- Name: COLUMN account_move_line.tax_tag_invert; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_tag_invert IS 'Invert Tags';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.deferred_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deferred_start_date IS 'Start Date';


--
-- Name: COLUMN account_move_line.deferred_end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deferred_end_date IS 'End Date';


--
-- Name: COLUMN account_move_line.is_downpayment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_downpayment IS 'Is Downpayment';


--
-- Name: COLUMN account_move_line.exclude_bank_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.exclude_bank_lines IS 'Exclude Bank Lines';


--
-- Name: COLUMN account_move_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.user_id IS 'Contact Salesperson';


--
-- Name: COLUMN account_move_line.followup_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.followup_line_id IS 'Follow-up Level';


--
-- Name: COLUMN account_move_line.tax_settlement_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_settlement_move_id IS 'Tax Settlement Move';


--
-- Name: COLUMN account_move_line.tax_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_state IS 'Tax State';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                display_type IN (''line_section'', ''line_note'')
                OR (
                    (balance <= 0 AND amount_currency <= 0)
                    OR
                    (balance >= 0 AND amount_currency >= 0)
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_note'') OR credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_reconcile_wizard_rel (
    account_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_reconcile_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_reconcile_wizard_rel IS 'RELATION BETWEEN account_reconcile_wizard AND account_move_line';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_account_tax_settlement_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_settlement_wizard_rel (
    account_tax_settlement_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_settlement_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_settlement_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_settlement_wizard_rel IS 'RELATION BETWEEN account_tax_settlement_wizard AND account_move_line';


--
-- Name: account_move_line_asset_modify_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_asset_modify_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_asset_modify_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move_line';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_line_id_seq OWNER TO runbot;

--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_line_l10n_us_1099_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_l10n_us_1099_wizard_rel (
    l10n_us_1099_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_l10n_us_1099_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_l10n_us_1099_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_l10n_us_1099_wizard_rel IS 'RELATION BETWEEN l10n_us_1099_wizard AND account_move_line';


--
-- Name: account_move_line_payment_to_pay_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_payment_to_pay_rel (
    payment_id integer NOT NULL,
    to_pay_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_payment_to_pay_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_payment_to_pay_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_payment_to_pay_rel IS 'RELATION BETWEEN account_payment AND account_move_line';


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_latam_document_type_id integer,
    l10n_latam_document_number character varying,
    l10n_ar_afip_fce_is_cancellation boolean
);


ALTER TABLE public.account_move_reversal OWNER TO runbot;

--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_reversal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.company_id IS 'Company';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason displayed on Credit Note';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_number IS 'Document Number';


--
-- Name: COLUMN account_move_reversal.l10n_ar_afip_fce_is_cancellation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_ar_afip_fce_is_cancellation IS 'FCE: Is Cancellation?';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_reversal_id_seq OWNER TO runbot;

--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_move_reversal_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_move (
    reversal_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_reversal_new_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_new_move (
    reversal_id integer NOT NULL,
    new_move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_new_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_new_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_new_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_send_batch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_batch_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_batch_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_batch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_batch_wizard IS 'Account Move Send Batch Wizard';


--
-- Name: COLUMN account_move_send_batch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_batch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_batch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_batch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_batch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNED BY public.account_move_send_batch_wizard.id;


--
-- Name: account_move_send_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard (
    id integer NOT NULL,
    move_id integer NOT NULL,
    pdf_report_id integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    mail_subject character varying,
    sending_method_checkboxes jsonb,
    extra_edi_checkboxes jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard IS 'Account Move Send Wizard';


--
-- Name: COLUMN account_move_send_wizard.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.move_id IS 'Move';


--
-- Name: COLUMN account_move_send_wizard.pdf_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.pdf_report_id IS 'Invoice template';


--
-- Name: COLUMN account_move_send_wizard.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_move_send_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_wizard.mail_subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_subject IS 'Subject';


--
-- Name: COLUMN account_move_send_wizard.sending_method_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.sending_method_checkboxes IS 'Sending Method Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.extra_edi_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.extra_edi_checkboxes IS 'Extra Edi Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_move_send_wizard.mail_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_body IS 'Contents';


--
-- Name: COLUMN account_move_send_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNED BY public.account_move_send_wizard.id;


--
-- Name: account_move_send_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard_res_partner_rel (
    account_move_send_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_move_send_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard_res_partner_rel IS 'RELATION BETWEEN account_move_send_wizard AND res_partner';


--
-- Name: account_move_validate_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_validate_account_move_rel (
    validate_account_move_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_validate_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_move_validate_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_validate_account_move_rel IS 'RELATION BETWEEN validate_account_move AND account_move';


--
-- Name: account_multicurrency_revaluation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_multicurrency_revaluation_wizard (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_multicurrency_revaluation_wizard OWNER TO runbot;

--
-- Name: TABLE account_multicurrency_revaluation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_multicurrency_revaluation_wizard IS 'Multicurrency Revaluation Wizard';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.date IS 'Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_date IS 'Last Updated on';


--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNER TO runbot;

--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNED BY public.account_multicurrency_revaluation_wizard.id;


--
-- Name: account_online_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_account (
    id integer NOT NULL,
    account_online_link_id integer,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    online_identifier character varying,
    account_number character varying,
    account_data character varying,
    fetching_status character varying,
    last_sync date,
    inverse_balance_sign boolean,
    inverse_transaction_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    balance double precision
);


ALTER TABLE public.account_online_account OWNER TO runbot;

--
-- Name: TABLE account_online_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_account IS 'representation of an online bank account';


--
-- Name: COLUMN account_online_account.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_online_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.currency_id IS 'Currency';


--
-- Name: COLUMN account_online_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.name IS 'Account Name';


--
-- Name: COLUMN account_online_account.online_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.online_identifier IS 'Online Identifier';


--
-- Name: COLUMN account_online_account.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_number IS 'Account Number';


--
-- Name: COLUMN account_online_account.account_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_data IS 'Account Data';


--
-- Name: COLUMN account_online_account.fetching_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.fetching_status IS 'Fetching Status';


--
-- Name: COLUMN account_online_account.last_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.last_sync IS 'Last synchronization';


--
-- Name: COLUMN account_online_account.inverse_balance_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_balance_sign IS 'Inverse Balance Sign';


--
-- Name: COLUMN account_online_account.inverse_transaction_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_transaction_sign IS 'Inverse Transaction Sign';


--
-- Name: COLUMN account_online_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_date IS 'Created on';


--
-- Name: COLUMN account_online_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_online_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.balance IS 'Balance';


--
-- Name: account_online_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_account_id_seq OWNER TO runbot;

--
-- Name: account_online_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_account_id_seq OWNED BY public.account_online_account.id;


--
-- Name: account_online_link; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_link (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    client_id character varying,
    refresh_token character varying,
    access_token character varying,
    provider_data character varying,
    provider_type character varying,
    expiring_synchronization_date date,
    connection_state_details jsonb,
    auto_sync boolean,
    has_unlinked_accounts boolean,
    last_refresh timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_online_link OWNER TO runbot;

--
-- Name: TABLE account_online_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_link IS 'Bank Connection';


--
-- Name: COLUMN account_online_link.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.company_id IS 'Company';


--
-- Name: COLUMN account_online_link.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_link.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_link.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.state IS 'State';


--
-- Name: COLUMN account_online_link.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.name IS 'Name';


--
-- Name: COLUMN account_online_link.client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.client_id IS 'Client';


--
-- Name: COLUMN account_online_link.refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.refresh_token IS 'Refresh Token';


--
-- Name: COLUMN account_online_link.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.access_token IS 'Access Token';


--
-- Name: COLUMN account_online_link.provider_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.provider_data IS 'Provider Data';


--
-- Name: COLUMN account_online_link.provider_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.provider_type IS 'Provider Type';


--
-- Name: COLUMN account_online_link.expiring_synchronization_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.expiring_synchronization_date IS 'Expiring Synchronization Date';


--
-- Name: COLUMN account_online_link.connection_state_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.connection_state_details IS 'Connection State Details';


--
-- Name: COLUMN account_online_link.auto_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.auto_sync IS 'Automatic synchronization';


--
-- Name: COLUMN account_online_link.has_unlinked_accounts; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.has_unlinked_accounts IS 'Has Unlinked Accounts';


--
-- Name: COLUMN account_online_link.last_refresh; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.last_refresh IS 'Last Refresh';


--
-- Name: COLUMN account_online_link.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_date IS 'Created on';


--
-- Name: COLUMN account_online_link.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_date IS 'Last Updated on';


--
-- Name: account_online_link_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_link_id_seq OWNER TO runbot;

--
-- Name: account_online_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_link_id_seq OWNED BY public.account_online_link.id;


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    full_reconcile_id integer,
    exchange_move_id integer,
    debit_currency_id integer,
    credit_currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    max_date date,
    amount numeric,
    debit_amount_currency numeric,
    credit_amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_partial_reconcile OWNER TO runbot;

--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_partial_reconcile.debit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_currency_id IS 'Currency of the debit journal item.';


--
-- Name: COLUMN account_partial_reconcile.credit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_currency_id IS 'Currency of the credit journal item.';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.debit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_amount_currency IS 'Debit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.credit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_amount_currency IS 'Credit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    move_id integer,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    partner_bank_id integer,
    paired_internal_transfer_payment_id integer,
    payment_method_line_id integer,
    payment_method_id integer,
    currency_id integer,
    partner_id integer,
    outstanding_account_id integer,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    state character varying NOT NULL,
    payment_type character varying NOT NULL,
    partner_type character varying NOT NULL,
    memo character varying,
    payment_reference character varying,
    date date NOT NULL,
    amount numeric,
    amount_company_currency_signed numeric,
    is_reconciled boolean,
    is_matched boolean,
    is_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    batch_payment_id integer,
    destination_journal_id integer,
    is_internal_transfer boolean,
    payment_transaction_id integer,
    payment_token_id integer,
    source_payment_id integer,
    counterpart_currency_id integer,
    write_off_type_id integer,
    counterpart_exchange_rate numeric,
    force_amount_company_currency numeric,
    unreconciled_amount numeric,
    write_off_amount numeric,
    receiptbook_id integer,
    l10n_latam_move_check_ids_operation_date timestamp without time zone,
    l10n_ar_fiscal_position_id integer,
    withholdable_advanced_amount numeric,
    CONSTRAINT account_payment_check_amount_not_negative CHECK ((amount >= 0.0))
);


ALTER TABLE public.account_payment OWNER TO runbot;

--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.company_id IS 'Company';


--
-- Name: COLUMN account_payment.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.paired_internal_transfer_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.paired_internal_transfer_payment_id IS 'Paired Internal Transfer Payment';


--
-- Name: COLUMN account_payment.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Method';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment.outstanding_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN account_payment.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_account_id IS 'Destination Account';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.name IS 'Number';


--
-- Name: COLUMN account_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.state IS 'State';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.memo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.memo IS 'Memo';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.date IS 'Date';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.amount_company_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount_company_currency_signed IS 'Amount Company Currency Signed';


--
-- Name: COLUMN account_payment.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_payment.is_matched; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_matched IS 'Is Matched With a Bank Statement';


--
-- Name: COLUMN account_payment.is_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_sent IS 'Is Sent';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_payment.destination_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_payment.is_internal_transfer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_internal_transfer IS 'Internal Transfer';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved Payment Token';


--
-- Name: COLUMN account_payment.source_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.source_payment_id IS 'Source Payment';


--
-- Name: COLUMN account_payment.counterpart_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_currency_id IS 'Counterpart Currency';


--
-- Name: COLUMN account_payment.write_off_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_off_type_id IS 'Write Off Type';


--
-- Name: COLUMN account_payment.counterpart_exchange_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_exchange_rate IS 'Counterpart Exchange Rate';


--
-- Name: COLUMN account_payment.force_amount_company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.force_amount_company_currency IS 'Forced Amount on Company Currency';


--
-- Name: COLUMN account_payment.unreconciled_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.unreconciled_amount IS 'Adjustment / Advance';


--
-- Name: COLUMN account_payment.write_off_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_off_amount IS 'Write Off Amount';


--
-- Name: COLUMN account_payment.receiptbook_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.receiptbook_id IS 'ReceiptBook';


--
-- Name: COLUMN account_payment.l10n_latam_move_check_ids_operation_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_latam_move_check_ids_operation_date IS 'Operation Date';


--
-- Name: COLUMN account_payment.l10n_ar_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_ar_fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_payment.withholdable_advanced_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholdable_advanced_amount IS 'Adjustment / Advance (untaxed)';


--
-- Name: CONSTRAINT account_payment_check_amount_not_negative ON account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_payment_check_amount_not_negative ON public.account_payment IS 'CHECK(amount >= 0.0)';


--
-- Name: account_payment_account_bank_statement_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_account_bank_statement_line_rel (
    account_bank_statement_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_bank_statement_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_account_bank_statement_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_account_bank_statement_line_rel IS 'RELATION BETWEEN account_bank_statement_line AND account_payment';


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_id_seq OWNER TO runbot;

--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_invoice_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_invoice_wizard (
    id integer NOT NULL,
    payment_id integer NOT NULL,
    journal_id integer NOT NULL,
    product_id integer NOT NULL,
    product_account_id integer,
    journal_document_type_id integer,
    create_uid integer,
    write_uid integer,
    description character varying,
    document_number character varying,
    invoice_date date NOT NULL,
    date date,
    analytic_distribution jsonb,
    amount_total numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    origin_invoice_id integer,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date
);


ALTER TABLE public.account_payment_invoice_wizard OWNER TO runbot;

--
-- Name: TABLE account_payment_invoice_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_invoice_wizard IS 'account.payment.invoice.wizard';


--
-- Name: COLUMN account_payment_invoice_wizard.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.payment_id IS 'Payment';


--
-- Name: COLUMN account_payment_invoice_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_invoice_wizard.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.product_id IS 'Product';


--
-- Name: COLUMN account_payment_invoice_wizard.product_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.product_account_id IS 'Product Account';


--
-- Name: COLUMN account_payment_invoice_wizard.journal_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.journal_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_payment_invoice_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_invoice_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_invoice_wizard.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.description IS 'Reason';


--
-- Name: COLUMN account_payment_invoice_wizard.document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.document_number IS 'Document Number';


--
-- Name: COLUMN account_payment_invoice_wizard.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.invoice_date IS 'Refund Date';


--
-- Name: COLUMN account_payment_invoice_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.date IS 'Accounting Date';


--
-- Name: COLUMN account_payment_invoice_wizard.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_payment_invoice_wizard.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.amount_total IS 'Total Amount';


--
-- Name: COLUMN account_payment_invoice_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_invoice_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_invoice_wizard.origin_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.origin_invoice_id IS 'Origin Invoice';


--
-- Name: COLUMN account_payment_invoice_wizard.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.l10n_ar_afip_asoc_period_start IS 'Associate Period From';


--
-- Name: COLUMN account_payment_invoice_wizard.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.l10n_ar_afip_asoc_period_end IS 'Associate Period To';


--
-- Name: account_payment_invoice_wizard_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_invoice_wizard_account_tax_rel (
    account_payment_invoice_wizard_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_payment_invoice_wizard_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_invoice_wizard_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_invoice_wizard_account_tax_rel IS 'RELATION BETWEEN account_payment_invoice_wizard AND account_tax';


--
-- Name: account_payment_invoice_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_invoice_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_invoice_wizard_id_seq OWNER TO runbot;

--
-- Name: account_payment_invoice_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_invoice_wizard_id_seq OWNED BY public.account_payment_invoice_wizard.id;


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_method OWNER TO runbot;

--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_method_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method_line (
    id integer NOT NULL,
    sequence integer,
    payment_method_id integer NOT NULL,
    payment_account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_provider_id integer
);


ALTER TABLE public.account_payment_method_line OWNER TO runbot;

--
-- Name: TABLE account_payment_method_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method_line IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_method_line.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_method_line.payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_account_id IS 'Payment Account';


--
-- Name: COLUMN account_payment_method_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_method_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.name IS 'Name';


--
-- Name: COLUMN account_payment_method_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_method_line.payment_provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_provider_id IS 'Payment Provider';


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_line_id_seq OWNED BY public.account_payment_method_line.id;


--
-- Name: account_payment_receiptbook; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_receiptbook (
    id integer NOT NULL,
    report_partner_id integer,
    mail_template_id integer,
    sequence integer,
    sequence_id integer,
    company_id integer NOT NULL,
    document_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying(64) NOT NULL,
    partner_type character varying NOT NULL,
    prefix character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_receiptbook OWNER TO runbot;

--
-- Name: TABLE account_payment_receiptbook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_receiptbook IS 'Account payment Receiptbook';


--
-- Name: COLUMN account_payment_receiptbook.report_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.report_partner_id IS 'Report Partner';


--
-- Name: COLUMN account_payment_receiptbook.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.mail_template_id IS 'Email Template';


--
-- Name: COLUMN account_payment_receiptbook.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_receiptbook.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.sequence_id IS 'Entry Sequence';


--
-- Name: COLUMN account_payment_receiptbook.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.company_id IS 'Company';


--
-- Name: COLUMN account_payment_receiptbook.document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.document_type_id IS 'Document Type';


--
-- Name: COLUMN account_payment_receiptbook.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_receiptbook.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_receiptbook.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.name IS 'Name';


--
-- Name: COLUMN account_payment_receiptbook.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_receiptbook.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.prefix IS 'Prefix';


--
-- Name: COLUMN account_payment_receiptbook.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.active IS 'Active';


--
-- Name: COLUMN account_payment_receiptbook.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_receiptbook.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.write_date IS 'Last Updated on';


--
-- Name: account_payment_receiptbook_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_receiptbook_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_receiptbook_id_seq OWNER TO runbot;

--
-- Name: account_payment_receiptbook_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_receiptbook_id_seq OWNED BY public.account_payment_receiptbook.id;


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    currency_id integer,
    journal_id integer,
    partner_bank_id integer,
    custom_user_currency_id integer,
    source_currency_id integer,
    company_id integer,
    partner_id integer,
    payment_method_line_id integer,
    writeoff_account_id integer,
    create_uid integer,
    write_uid integer,
    communication character varying,
    installments_mode character varying,
    payment_type character varying,
    partner_type character varying,
    payment_difference_handling character varying,
    writeoff_label character varying,
    payment_date date NOT NULL,
    amount numeric,
    custom_user_amount numeric,
    source_amount numeric,
    source_amount_currency numeric,
    group_payment boolean,
    can_edit_wizard boolean,
    can_group_payments boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_token_id integer,
    l10n_ar_fiscal_position_id integer
);


ALTER TABLE public.account_payment_register OWNER TO runbot;

--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register IS 'Pay';


--
-- Name: COLUMN account_payment_register.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment_register.custom_user_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_currency_id IS 'Custom User Currency';


--
-- Name: COLUMN account_payment_register.source_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_currency_id IS 'Source Currency';


--
-- Name: COLUMN account_payment_register.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.company_id IS 'Company';


--
-- Name: COLUMN account_payment_register.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_register.writeoff_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.communication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.communication IS 'Memo';


--
-- Name: COLUMN account_payment_register.installments_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.installments_mode IS 'Installments Mode';


--
-- Name: COLUMN account_payment_register.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_register.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_register.payment_difference_handling; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment_register.writeoff_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.amount IS 'Amount';


--
-- Name: COLUMN account_payment_register.custom_user_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_amount IS 'Custom User Amount';


--
-- Name: COLUMN account_payment_register.source_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount IS 'Amount to Pay (company currency)';


--
-- Name: COLUMN account_payment_register.source_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount_currency IS 'Amount to Pay (foreign currency)';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payments';


--
-- Name: COLUMN account_payment_register.can_edit_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_edit_wizard IS 'Can Edit Wizard';


--
-- Name: COLUMN account_payment_register.can_group_payments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_group_payments IS 'Can Group Payments';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_register.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_token_id IS 'Saved payment token';


--
-- Name: COLUMN account_payment_register.l10n_ar_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.l10n_ar_fiscal_position_id IS 'Fiscal Position';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_register_id_seq OWNER TO runbot;

--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_register_l10n_latam_check_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_l10n_latam_check_rel (
    account_payment_register_id integer NOT NULL,
    l10n_latam_check_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_l10n_latam_check_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_l10n_latam_check_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_l10n_latam_check_rel IS 'RELATION BETWEEN account_payment_register AND l10n_latam_check';


--
-- Name: account_payment_register_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_move_line_rel (
    wizard_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_move_line_rel IS 'RELATION BETWEEN account_payment_register AND account_move_line';


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    company_id integer,
    sequence integer NOT NULL,
    discount_days integer,
    create_uid integer,
    write_uid integer,
    early_pay_discount_computation character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    display_on_invoice boolean,
    early_discount boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_percentage double precision
);


ALTER TABLE public.account_payment_term OWNER TO runbot;

--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.discount_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_days IS 'Discount Days';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.early_pay_discount_computation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_pay_discount_computation IS 'Cash Discount Tax Reduction';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.display_on_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.display_on_invoice IS 'Show installment dates';


--
-- Name: COLUMN account_payment_term.early_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_discount IS 'Early Discount';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term.discount_percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_percentage IS 'Discount %';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    nb_days integer,
    payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    delay_type character varying NOT NULL,
    days_next_month character varying(2),
    value_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_term_line OWNER TO runbot;

--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.nb_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.nb_days IS 'Days';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Value';


--
-- Name: COLUMN account_payment_term_line.delay_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.delay_type IS 'Delay Type';


--
-- Name: COLUMN account_payment_term_line.days_next_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.days_next_month IS 'Days on the next month';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Due';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    past_months_limit integer,
    create_uid integer,
    write_uid integer,
    rule_type character varying NOT NULL,
    matching_order character varying NOT NULL,
    counterpart_type character varying,
    match_nature character varying NOT NULL,
    match_amount character varying,
    match_label character varying,
    match_label_param character varying,
    match_note character varying,
    match_note_param character varying,
    match_transaction_type character varying,
    match_transaction_type_param character varying,
    payment_tolerance_type character varying NOT NULL,
    decimal_separator character varying,
    name jsonb NOT NULL,
    active boolean,
    auto_reconcile boolean,
    to_check boolean,
    match_text_location_label boolean,
    match_text_location_note boolean,
    match_text_location_reference boolean,
    match_same_currency boolean,
    allow_payment_tolerance boolean,
    match_partner boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    match_amount_min double precision,
    match_amount_max double precision,
    payment_tolerance_param double precision
);


ALTER TABLE public.account_reconcile_model OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.past_months_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.past_months_limit IS 'Search Months Limit';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.rule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.rule_type IS 'Type';


--
-- Name: COLUMN account_reconcile_model.matching_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.matching_order IS 'Matching Order';


--
-- Name: COLUMN account_reconcile_model.counterpart_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.counterpart_type IS 'Counterpart Type';


--
-- Name: COLUMN account_reconcile_model.match_nature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_nature IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount Condition';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.match_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note IS 'Note';


--
-- Name: COLUMN account_reconcile_model.match_note_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_note_param IS 'Note Parameter';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_reconcile_model.match_transaction_type_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_transaction_type_param IS 'Transaction Type Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_type IS 'Payment Tolerance Type';


--
-- Name: COLUMN account_reconcile_model.decimal_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.decimal_separator IS 'Decimal Separator';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.active IS 'Active';


--
-- Name: COLUMN account_reconcile_model.auto_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.auto_reconcile IS 'Auto-validate';


--
-- Name: COLUMN account_reconcile_model.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_model.match_text_location_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_label IS 'Match Text Location Label';


--
-- Name: COLUMN account_reconcile_model.match_text_location_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_note IS 'Match Text Location Note';


--
-- Name: COLUMN account_reconcile_model.match_text_location_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_text_location_reference IS 'Match Text Location Reference';


--
-- Name: COLUMN account_reconcile_model.match_same_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_same_currency IS 'Same Currency';


--
-- Name: COLUMN account_reconcile_model.allow_payment_tolerance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.allow_payment_tolerance IS 'Payment Tolerance';


--
-- Name: COLUMN account_reconcile_model.match_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_partner IS 'Partner is Set';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.payment_tolerance_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.payment_tolerance_param IS 'Gap';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line (
    id integer NOT NULL,
    model_id integer,
    company_id integer,
    sequence integer NOT NULL,
    account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying NOT NULL,
    amount_string character varying NOT NULL,
    analytic_distribution jsonb,
    label jsonb,
    force_tax_included boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_reconcile_model_line OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line IS 'Rules for the reconciliation model';


--
-- Name: COLUMN account_reconcile_model_line.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line.amount_string; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_reconcile_model_line.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.label IS 'Journal Item Label';


--
-- Name: COLUMN account_reconcile_model_line.force_tax_included; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.force_tax_included IS 'Tax Included in Price';


--
-- Name: COLUMN account_reconcile_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount IS 'Float Amount';


--
-- Name: account_reconcile_model_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_account_tax_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_tax';


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNED BY public.account_reconcile_model_line.id;


--
-- Name: account_reconcile_model_partner_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_partner_mapping (
    id integer NOT NULL,
    model_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_ref_regex character varying,
    narration_regex character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_model_partner_mapping OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_partner_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_partner_mapping IS 'Partner mapping for reconciliation models';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.payment_ref_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.payment_ref_regex IS 'Find Text in Label';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.narration_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.narration_regex IS 'Find Text in Notes';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_partner_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_partner_mapping.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_partner_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_partner_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_partner_mapping_id_seq OWNED BY public.account_reconcile_model_partner_mapping.id;


--
-- Name: account_reconcile_model_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_category_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_category_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_category_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner_category';


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_reconcile_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_wizard (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    account_id integer,
    to_partner_id integer,
    tax_id integer,
    create_uid integer,
    write_uid integer,
    label character varying,
    date date,
    edit_mode_amount_currency numeric,
    allow_partials boolean,
    to_check boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_wizard OWNER TO runbot;

--
-- Name: TABLE account_reconcile_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_wizard IS 'Account reconciliation wizard';


--
-- Name: COLUMN account_reconcile_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_wizard.to_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_wizard.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.tax_id IS 'Tax';


--
-- Name: COLUMN account_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_wizard.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.label IS 'Label';


--
-- Name: COLUMN account_reconcile_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.date IS 'Date';


--
-- Name: COLUMN account_reconcile_wizard.edit_mode_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.edit_mode_amount_currency IS 'Edit mode amount';


--
-- Name: COLUMN account_reconcile_wizard.allow_partials; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.allow_partials IS 'Allow partials';


--
-- Name: COLUMN account_reconcile_wizard.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNED BY public.account_reconcile_wizard.id;


--
-- Name: account_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report (
    id integer NOT NULL,
    sequence integer,
    root_report_id integer,
    country_id integer,
    load_more_limit integer,
    prefix_groups_threshold integer,
    create_uid integer,
    write_uid integer,
    chart_template character varying,
    availability_condition character varying,
    integer_rounding character varying,
    default_opening_date_filter character varying,
    currency_translation character varying,
    filter_multi_company character varying,
    filter_hide_0_lines character varying,
    filter_hierarchy character varying,
    filter_account_type character varying,
    name jsonb NOT NULL,
    active boolean,
    use_sections boolean,
    only_tax_exigible boolean,
    search_bar boolean,
    filter_date_range boolean,
    filter_show_draft boolean,
    filter_unreconciled boolean,
    filter_unfold_all boolean,
    filter_period_comparison boolean,
    filter_growth_comparison boolean,
    filter_journals boolean,
    filter_analytic boolean,
    filter_partner boolean,
    filter_fiscal_position boolean,
    filter_aml_ir_filters boolean,
    filter_budgets boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    custom_handler_model_id integer,
    tax_closing_start_date jsonb,
    send_and_print_values jsonb,
    filter_analytic_groupby boolean,
    require_custom_filter boolean,
    settlement_title jsonb,
    allow_settlement boolean,
    settlement_allow_unbalanced boolean,
    filter_cash_basis boolean
);


ALTER TABLE public.account_report OWNER TO runbot;

--
-- Name: TABLE account_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report IS 'Accounting Report';


--
-- Name: COLUMN account_report.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.sequence IS 'Sequence';


--
-- Name: COLUMN account_report.root_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.root_report_id IS 'Root Report';


--
-- Name: COLUMN account_report.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.country_id IS 'Country';


--
-- Name: COLUMN account_report.load_more_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.load_more_limit IS 'Load More Limit';


--
-- Name: COLUMN account_report.prefix_groups_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.prefix_groups_threshold IS 'Prefix Groups Threshold';


--
-- Name: COLUMN account_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report.chart_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.chart_template IS 'Chart of Accounts';


--
-- Name: COLUMN account_report.availability_condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.availability_condition IS 'Availability';


--
-- Name: COLUMN account_report.integer_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.integer_rounding IS 'Integer Rounding';


--
-- Name: COLUMN account_report.default_opening_date_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.default_opening_date_filter IS 'Default Opening';


--
-- Name: COLUMN account_report.currency_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.currency_translation IS 'Currency Translation';


--
-- Name: COLUMN account_report.filter_multi_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_multi_company IS 'Multi-Company';


--
-- Name: COLUMN account_report.filter_hide_0_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hide_0_lines IS 'Hide lines at 0';


--
-- Name: COLUMN account_report.filter_hierarchy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hierarchy IS 'Account Groups';


--
-- Name: COLUMN account_report.filter_account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_account_type IS 'Account Types';


--
-- Name: COLUMN account_report.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.name IS 'Name';


--
-- Name: COLUMN account_report.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.active IS 'Active';


--
-- Name: COLUMN account_report.use_sections; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.use_sections IS 'Composite Report';


--
-- Name: COLUMN account_report.only_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.only_tax_exigible IS 'Only Tax Exigible Lines';


--
-- Name: COLUMN account_report.search_bar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.search_bar IS 'Search Bar';


--
-- Name: COLUMN account_report.filter_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_date_range IS 'Date Range';


--
-- Name: COLUMN account_report.filter_show_draft; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_show_draft IS 'Draft Entries';


--
-- Name: COLUMN account_report.filter_unreconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unreconciled IS 'Unreconciled Entries';


--
-- Name: COLUMN account_report.filter_unfold_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unfold_all IS 'Unfold All';


--
-- Name: COLUMN account_report.filter_period_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_period_comparison IS 'Period Comparison';


--
-- Name: COLUMN account_report.filter_growth_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_growth_comparison IS 'Growth Comparison';


--
-- Name: COLUMN account_report.filter_journals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_journals IS 'Journals';


--
-- Name: COLUMN account_report.filter_analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic IS 'Analytic Filter';


--
-- Name: COLUMN account_report.filter_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_partner IS 'Partners';


--
-- Name: COLUMN account_report.filter_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_fiscal_position IS 'Filter Multivat';


--
-- Name: COLUMN account_report.filter_aml_ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_aml_ir_filters IS 'Favorite Filters';


--
-- Name: COLUMN account_report.filter_budgets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_budgets IS 'Budgets';


--
-- Name: COLUMN account_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_date IS 'Created on';


--
-- Name: COLUMN account_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report.custom_handler_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.custom_handler_model_id IS 'Custom Handler Model';


--
-- Name: COLUMN account_report.tax_closing_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.tax_closing_start_date IS 'Start Date';


--
-- Name: COLUMN account_report.send_and_print_values; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.send_and_print_values IS 'Send And Print Values';


--
-- Name: COLUMN account_report.filter_analytic_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic_groupby IS 'Analytic Group By';


--
-- Name: COLUMN account_report.require_custom_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.require_custom_filter IS 'Require Custom Filter';


--
-- Name: COLUMN account_report.settlement_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.settlement_title IS 'Settlement Title';


--
-- Name: COLUMN account_report.allow_settlement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.allow_settlement IS 'Allow Settlement';


--
-- Name: COLUMN account_report.settlement_allow_unbalanced; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.settlement_allow_unbalanced IS 'Settlement Allow Unbalanced';


--
-- Name: COLUMN account_report.filter_cash_basis; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_cash_basis IS 'Cash Basis';


--
-- Name: account_report_account_report_horizontal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_account_report_horizontal_group_rel (
    account_report_id integer NOT NULL,
    account_report_horizontal_group_id integer NOT NULL
);


ALTER TABLE public.account_report_account_report_horizontal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_report_account_report_horizontal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_account_report_horizontal_group_rel IS 'RELATION BETWEEN account_report AND account_report_horizontal_group';


--
-- Name: account_report_annotation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_annotation (
    id integer NOT NULL,
    report_id integer,
    fiscal_position_id integer,
    create_uid integer,
    write_uid integer,
    line_id character varying,
    text character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_annotation OWNER TO runbot;

--
-- Name: TABLE account_report_annotation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_annotation IS 'Account Report Annotation';


--
-- Name: COLUMN account_report_annotation.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.report_id IS 'Report';


--
-- Name: COLUMN account_report_annotation.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_report_annotation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_annotation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_annotation.line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.line_id IS 'Line';


--
-- Name: COLUMN account_report_annotation.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.text IS 'The annotation''s content.';


--
-- Name: COLUMN account_report_annotation.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.date IS 'Date';


--
-- Name: COLUMN account_report_annotation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.create_date IS 'Created on';


--
-- Name: COLUMN account_report_annotation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.write_date IS 'Last Updated on';


--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_annotation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_annotation_id_seq OWNER TO runbot;

--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_annotation_id_seq OWNED BY public.account_report_annotation.id;


--
-- Name: account_report_budget; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_budget (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_budget OWNER TO runbot;

--
-- Name: TABLE account_report_budget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_budget IS 'Accounting Report Budget';


--
-- Name: COLUMN account_report_budget.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_budget.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.company_id IS 'Company';


--
-- Name: COLUMN account_report_budget.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.name IS 'Name';


--
-- Name: COLUMN account_report_budget.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.write_date IS 'Last Updated on';


--
-- Name: account_report_budget_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_budget_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_id_seq OWNER TO runbot;

--
-- Name: account_report_budget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_budget_id_seq OWNED BY public.account_report_budget.id;


--
-- Name: account_report_budget_item; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_budget_item (
    id integer NOT NULL,
    budget_id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_report_budget_item OWNER TO runbot;

--
-- Name: TABLE account_report_budget_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_budget_item IS 'Accounting Report Budget Item';


--
-- Name: COLUMN account_report_budget_item.budget_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.budget_id IS 'Budget';


--
-- Name: COLUMN account_report_budget_item.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.account_id IS 'Account';


--
-- Name: COLUMN account_report_budget_item.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget_item.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget_item.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.date IS 'Date';


--
-- Name: COLUMN account_report_budget_item.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget_item.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_budget_item.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.amount IS 'Amount';


--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_budget_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_item_id_seq OWNER TO runbot;

--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_budget_item_id_seq OWNED BY public.account_report_budget_item.id;


--
-- Name: account_report_column; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_column (
    id integer NOT NULL,
    sequence integer,
    report_id integer,
    custom_audit_action_id integer,
    create_uid integer,
    write_uid integer,
    expression_label character varying NOT NULL,
    figure_type character varying NOT NULL,
    name jsonb NOT NULL,
    sortable boolean,
    blank_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_column OWNER TO runbot;

--
-- Name: TABLE account_report_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_column IS 'Accounting Report Column';


--
-- Name: COLUMN account_report_column.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_column.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.report_id IS 'Report';


--
-- Name: COLUMN account_report_column.custom_audit_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.custom_audit_action_id IS 'Custom Audit Action';


--
-- Name: COLUMN account_report_column.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_column.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_column.expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.expression_label IS 'Expression Label';


--
-- Name: COLUMN account_report_column.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_column.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.name IS 'Name';


--
-- Name: COLUMN account_report_column.sortable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sortable IS 'Sortable';


--
-- Name: COLUMN account_report_column.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_column.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_date IS 'Created on';


--
-- Name: COLUMN account_report_column.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_date IS 'Last Updated on';


--
-- Name: account_report_column_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_column_id_seq OWNER TO runbot;

--
-- Name: account_report_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_column_id_seq OWNED BY public.account_report_column.id;


--
-- Name: account_report_expression; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_expression (
    id integer NOT NULL,
    report_line_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label character varying NOT NULL,
    engine character varying NOT NULL,
    formula character varying NOT NULL,
    subformula character varying,
    date_scope character varying NOT NULL,
    figure_type character varying,
    carryover_target character varying,
    green_on_positive boolean,
    blank_if_zero boolean,
    auditable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_report_expression_domain_engine_subformula_required CHECK ((((engine)::text <> 'domain'::text) OR (subformula IS NOT NULL)))
);


ALTER TABLE public.account_report_expression OWNER TO runbot;

--
-- Name: TABLE account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_expression IS 'Accounting Report Expression';


--
-- Name: COLUMN account_report_expression.report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.report_line_id IS 'Report Line';


--
-- Name: COLUMN account_report_expression.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_expression.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_expression.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.label IS 'Label';


--
-- Name: COLUMN account_report_expression.engine; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.engine IS 'Computation Engine';


--
-- Name: COLUMN account_report_expression.formula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.formula IS 'Formula';


--
-- Name: COLUMN account_report_expression.subformula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.subformula IS 'Subformula';


--
-- Name: COLUMN account_report_expression.date_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.date_scope IS 'Date Scope';


--
-- Name: COLUMN account_report_expression.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_expression.carryover_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.carryover_target IS 'Carry Over To';


--
-- Name: COLUMN account_report_expression.green_on_positive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.green_on_positive IS 'Is Growth Good when Positive';


--
-- Name: COLUMN account_report_expression.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_expression.auditable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.auditable IS 'Auditable';


--
-- Name: COLUMN account_report_expression.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_date IS 'Created on';


--
-- Name: COLUMN account_report_expression.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_report_expression_domain_engine_subformula_required ON account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_report_expression_domain_engine_subformula_required ON public.account_report_expression IS 'CHECK(engine != ''domain'' OR subformula IS NOT NULL)';


--
-- Name: account_report_expression_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_expression_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_expression_id_seq OWNER TO runbot;

--
-- Name: account_report_expression_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_expression_id_seq OWNED BY public.account_report_expression.id;


--
-- Name: account_report_external_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_external_value (
    id integer NOT NULL,
    target_report_expression_id integer NOT NULL,
    company_id integer NOT NULL,
    foreign_vat_fiscal_position_id integer,
    carryover_origin_report_line_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    text_value character varying,
    carryover_origin_expression_label character varying,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


ALTER TABLE public.account_report_external_value OWNER TO runbot;

--
-- Name: TABLE account_report_external_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_external_value IS 'Accounting Report External Value';


--
-- Name: COLUMN account_report_external_value.target_report_expression_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.target_report_expression_id IS 'Target Expression';


--
-- Name: COLUMN account_report_external_value.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.company_id IS 'Company';


--
-- Name: COLUMN account_report_external_value.foreign_vat_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.foreign_vat_fiscal_position_id IS 'Fiscal position';


--
-- Name: COLUMN account_report_external_value.carryover_origin_report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_report_line_id IS 'Origin Line';


--
-- Name: COLUMN account_report_external_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_external_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_external_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.name IS 'Name';


--
-- Name: COLUMN account_report_external_value.text_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.text_value IS 'Text Value';


--
-- Name: COLUMN account_report_external_value.carryover_origin_expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_expression_label IS 'Origin Expression Label';


--
-- Name: COLUMN account_report_external_value.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.date IS 'Date';


--
-- Name: COLUMN account_report_external_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_date IS 'Created on';


--
-- Name: COLUMN account_report_external_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_external_value.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.value IS 'Numeric Value';


--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_external_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_external_value_id_seq OWNER TO runbot;

--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_external_value_id_seq OWNED BY public.account_report_external_value.id;


--
-- Name: account_report_file_download_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_file_download_error_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    file_name character varying,
    actionable_errors jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_file_download_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_report_file_download_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_file_download_error_wizard IS 'Manage the file generation errors from report exports.';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_file_download_error_wizard.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.file_name IS 'File Name';


--
-- Name: COLUMN account_report_file_download_error_wizard.actionable_errors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.actionable_errors IS 'Actionable Errors';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_file_download_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNED BY public.account_report_file_download_error_wizard.id;


--
-- Name: account_report_horizontal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group IS 'Horizontal group for reports';


--
-- Name: COLUMN account_report_horizontal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.name IS 'Name';


--
-- Name: COLUMN account_report_horizontal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNED BY public.account_report_horizontal_group.id;


--
-- Name: account_report_horizontal_group_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group_rule (
    id integer NOT NULL,
    horizontal_group_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    domain character varying NOT NULL,
    field_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group_rule OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group_rule IS 'Horizontal group rule for reports';


--
-- Name: COLUMN account_report_horizontal_group_rule.horizontal_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.horizontal_group_id IS 'Horizontal Group';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group_rule.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.domain IS 'Domain';


--
-- Name: COLUMN account_report_horizontal_group_rule.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.field_name IS 'Field';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNED BY public.account_report_horizontal_group_rule.id;


--
-- Name: account_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_id_seq OWNER TO runbot;

--
-- Name: account_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_id_seq OWNED BY public.account_report.id;


--
-- Name: account_report_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_line (
    id integer NOT NULL,
    report_id integer NOT NULL,
    hierarchy_level integer NOT NULL,
    parent_id integer,
    sequence integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    groupby character varying,
    user_groupby character varying,
    code character varying,
    horizontal_split_side character varying,
    name jsonb NOT NULL,
    foldable boolean,
    print_on_new_page boolean,
    hide_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_line OWNER TO runbot;

--
-- Name: TABLE account_report_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_line IS 'Accounting Report Line';


--
-- Name: COLUMN account_report_line.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.report_id IS 'Parent Report';


--
-- Name: COLUMN account_report_line.hierarchy_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hierarchy_level IS 'Level';


--
-- Name: COLUMN account_report_line.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_report_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_line.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.action_id IS 'Action';


--
-- Name: COLUMN account_report_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_line.groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.groupby IS 'Group By';


--
-- Name: COLUMN account_report_line.user_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.user_groupby IS 'User Group By';


--
-- Name: COLUMN account_report_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.code IS 'Code';


--
-- Name: COLUMN account_report_line.horizontal_split_side; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.horizontal_split_side IS 'Horizontal Split Side';


--
-- Name: COLUMN account_report_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.name IS 'Name';


--
-- Name: COLUMN account_report_line.foldable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.foldable IS 'Foldable';


--
-- Name: COLUMN account_report_line.print_on_new_page; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.print_on_new_page IS 'Print On New Page';


--
-- Name: COLUMN account_report_line.hide_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hide_if_zero IS 'Hide if Zero';


--
-- Name: COLUMN account_report_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_report_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_date IS 'Last Updated on';


--
-- Name: account_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_line_id_seq OWNER TO runbot;

--
-- Name: account_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_line_id_seq OWNED BY public.account_report_line.id;


--
-- Name: account_report_section_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_section_rel (
    main_report_id integer NOT NULL,
    sub_report_id integer NOT NULL
);


ALTER TABLE public.account_report_section_rel OWNER TO runbot;

--
-- Name: TABLE account_report_section_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_section_rel IS 'RELATION BETWEEN account_report AND account_report';


--
-- Name: account_report_send; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_send (
    id integer NOT NULL,
    mail_template_id integer,
    account_report_id integer,
    create_uid integer,
    write_uid integer,
    mode character varying,
    mail_subject character varying,
    report_options jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    enable_download boolean,
    checkbox_download boolean,
    enable_send_mail boolean,
    checkbox_send_mail boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_send OWNER TO runbot;

--
-- Name: TABLE account_report_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_send IS 'Account Report Send';


--
-- Name: COLUMN account_report_send.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_report_send.account_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.account_report_id IS 'Report';


--
-- Name: COLUMN account_report_send.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_send.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_send.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mode IS 'Mode';


--
-- Name: COLUMN account_report_send.mail_subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_subject IS 'Subject';


--
-- Name: COLUMN account_report_send.report_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.report_options IS 'Report Options';


--
-- Name: COLUMN account_report_send.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_report_send.mail_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_body IS 'Contents';


--
-- Name: COLUMN account_report_send.enable_download; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.enable_download IS 'Enable Download';


--
-- Name: COLUMN account_report_send.checkbox_download; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.checkbox_download IS 'Download';


--
-- Name: COLUMN account_report_send.enable_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.enable_send_mail IS 'Enable Send Mail';


--
-- Name: COLUMN account_report_send.checkbox_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.checkbox_send_mail IS 'Email';


--
-- Name: COLUMN account_report_send.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.create_date IS 'Created on';


--
-- Name: COLUMN account_report_send.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.write_date IS 'Last Updated on';


--
-- Name: account_report_send_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_send_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_send_id_seq OWNER TO runbot;

--
-- Name: account_report_send_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_send_id_seq OWNED BY public.account_report_send.id;


--
-- Name: account_report_send_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_send_res_partner_rel (
    account_report_send_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_report_send_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_report_send_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_send_res_partner_rel IS 'RELATION BETWEEN account_report_send AND res_partner';


--
-- Name: account_reports_export_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard (
    id integer NOT NULL,
    report_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    doc_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reports_export_wizard OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard IS 'Export wizard for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.report_id IS 'Parent Report Id';


--
-- Name: COLUMN account_reports_export_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard.doc_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.doc_name IS 'Documents Name';


--
-- Name: COLUMN account_reports_export_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard_format (
    id integer NOT NULL,
    export_wizard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    fun_to_call character varying NOT NULL,
    fun_param character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reports_export_wizard_format OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard_format IS 'Export format for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard_format.export_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.export_wizard_id IS 'Parent Wizard';


--
-- Name: COLUMN account_reports_export_wizard_format.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard_format.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard_format.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.name IS 'Name';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_to_call; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_to_call IS 'Function to Call';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_param IS 'Function Parameter';


--
-- Name: COLUMN account_reports_export_wizard_format.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard_format.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNED BY public.account_reports_export_wizard_format.id;


--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNED BY public.account_reports_export_wizard.id;


--
-- Name: account_resequence_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_resequence_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    first_name character varying NOT NULL,
    ordering character varying NOT NULL,
    first_date date,
    end_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_resequence_wizard OWNER TO runbot;

--
-- Name: TABLE account_resequence_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_resequence_wizard IS 'Remake the sequence of Journal Entries.';


--
-- Name: COLUMN account_resequence_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_resequence_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_resequence_wizard.first_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_name IS 'First New Sequence';


--
-- Name: COLUMN account_resequence_wizard.ordering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.ordering IS 'Ordering';


--
-- Name: COLUMN account_resequence_wizard.first_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_date IS 'First Date';


--
-- Name: COLUMN account_resequence_wizard.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.end_date IS 'End Date';


--
-- Name: COLUMN account_resequence_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_resequence_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_date IS 'Last Updated on';


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_resequence_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNER TO runbot;

--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNED BY public.account_resequence_wizard.id;


--
-- Name: account_secure_entries_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_secure_entries_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    hash_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_secure_entries_wizard OWNER TO runbot;

--
-- Name: TABLE account_secure_entries_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_secure_entries_wizard IS 'Secure Journal Entries';


--
-- Name: COLUMN account_secure_entries_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_secure_entries_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_secure_entries_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_secure_entries_wizard.hash_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.hash_date IS 'Hash All Entries';


--
-- Name: COLUMN account_secure_entries_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_secure_entries_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_date IS 'Last Updated on';


--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_secure_entries_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNER TO runbot;

--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNED BY public.account_secure_entries_wizard.id;


--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    num_journals_without_account integer,
    create_uid integer,
    write_uid integer,
    new_journal_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_setup_bank_manual_config OWNER TO runbot;

--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account IS 'Num Journals Without Account';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNER TO runbot;

--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    tax_group_id integer NOT NULL,
    cash_basis_transition_account_id integer,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    price_include_override character varying,
    tax_exigibility character varying,
    name jsonb NOT NULL,
    description jsonb,
    invoice_label jsonb,
    invoice_legal_notes text,
    amount numeric NOT NULL,
    active boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_ar_withholding_sequence_id integer,
    l10n_ar_state_id integer,
    l10n_ar_scale_id integer,
    l10n_ar_withholding_payment_type character varying,
    l10n_ar_tax_type character varying,
    l10n_ar_code character varying,
    l10n_ar_non_taxable_amount numeric,
    l10n_ar_minimum_threshold double precision,
    api_codigo_articulo_retencion character varying,
    api_codigo_articulo_percepcion character varying,
    api_articulo_inciso_calculo_percepcion character varying,
    api_articulo_inciso_calculo_retencion character varying,
    porcentaje_exclusion double precision
);


ALTER TABLE public.account_tax OWNER TO runbot;

--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.country_id IS 'Country';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax.tax_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.price_include_override; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.price_include_override IS 'Included in Price';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Exigibility';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.description IS 'Description';


--
-- Name: COLUMN account_tax.invoice_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_label IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.invoice_legal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_legal_notes IS 'Legal Notes';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.is_base_affected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax.l10n_ar_withholding_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_withholding_sequence_id IS 'WTH Sequence';


--
-- Name: COLUMN account_tax.l10n_ar_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_state_id IS 'Jurisdiction';


--
-- Name: COLUMN account_tax.l10n_ar_scale_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_scale_id IS 'Scale';


--
-- Name: COLUMN account_tax.l10n_ar_withholding_payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_withholding_payment_type IS 'Argentina Withholding Payment Type';


--
-- Name: COLUMN account_tax.l10n_ar_tax_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_tax_type IS 'WTH Tax';


--
-- Name: COLUMN account_tax.l10n_ar_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_code IS 'AFIP Code';


--
-- Name: COLUMN account_tax.l10n_ar_non_taxable_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_non_taxable_amount IS 'Non Taxable Amount';


--
-- Name: COLUMN account_tax.l10n_ar_minimum_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_minimum_threshold IS 'Minimum Treshold';


--
-- Name: COLUMN account_tax.api_codigo_articulo_retencion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_codigo_articulo_retencion IS 'Código de Artículo/Inciso por el que retiene';


--
-- Name: COLUMN account_tax.api_codigo_articulo_percepcion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_codigo_articulo_percepcion IS 'Código de artículo Inciso por el que percibe';


--
-- Name: COLUMN account_tax.api_articulo_inciso_calculo_percepcion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_articulo_inciso_calculo_percepcion IS 'Artículo/Inciso para el cálculo percepción';


--
-- Name: COLUMN account_tax.api_articulo_inciso_calculo_retencion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_articulo_inciso_calculo_retencion IS 'Artículo/Inciso para el cálculo retención';


--
-- Name: COLUMN account_tax.porcentaje_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.porcentaje_exclusion IS 'Porcentaje de exclusión';


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_filiation_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    tax_payable_account_id integer,
    tax_receivable_account_id integer,
    advance_tax_payment_account_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    pos_receipt_label character varying,
    name jsonb NOT NULL,
    preceding_subtotal jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_ar_tribute_afip_code character varying,
    l10n_ar_vat_afip_code character varying
);


ALTER TABLE public.account_tax_group OWNER TO runbot;

--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.company_id IS 'Company';


--
-- Name: COLUMN account_tax_group.tax_payable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_payable_account_id IS 'Tax Payable Account';


--
-- Name: COLUMN account_tax_group.tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_receivable_account_id IS 'Tax Receivable Account';


--
-- Name: COLUMN account_tax_group.advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.advance_tax_payment_account_id IS 'Tax Advance Account';


--
-- Name: COLUMN account_tax_group.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.country_id IS 'Country';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.pos_receipt_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.pos_receipt_label IS 'PoS receipt label';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.preceding_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.preceding_subtotal IS 'Preceding Subtotal';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_group.l10n_ar_tribute_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_tribute_afip_code IS 'Tribute AFIP Code';


--
-- Name: COLUMN account_tax_group.l10n_ar_vat_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_vat_afip_code IS 'VAT AFIP Code';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_group_id_seq OWNER TO runbot;

--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_id_seq OWNER TO runbot;

--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    account_id integer,
    tax_id integer,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    repartition_type character varying NOT NULL,
    document_type character varying NOT NULL,
    factor_percent numeric NOT NULL,
    use_in_tax_closing boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_repartition_line OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.tax_id IS 'Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.document_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.document_type IS 'Related to';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNER TO runbot;

--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_sale_advance_payment_inv_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_advance_payment_inv_rel (
    sale_advance_payment_inv_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_advance_payment_inv_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_advance_payment_inv_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_advance_payment_inv_rel IS 'RELATION BETWEEN sale_advance_payment_inv AND account_tax';


--
-- Name: account_tax_sale_order_discount_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_discount_rel (
    sale_order_discount_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_discount_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_discount_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_discount_rel IS 'RELATION BETWEEN sale_order_discount AND account_tax';


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: account_tax_settlement_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_settlement_wizard (
    id integer NOT NULL,
    settlement_journal_id integer,
    report_id integer,
    company_id integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    select_journal boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_settlement_wizard OWNER TO runbot;

--
-- Name: TABLE account_tax_settlement_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_settlement_wizard IS 'Wizard para generar liquidaciones de impuestos desde ';


--
-- Name: COLUMN account_tax_settlement_wizard.settlement_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.settlement_journal_id IS 'Journal';


--
-- Name: COLUMN account_tax_settlement_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.report_id IS 'Report';


--
-- Name: COLUMN account_tax_settlement_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_tax_settlement_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.account_id IS 'Account';


--
-- Name: COLUMN account_tax_settlement_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_settlement_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_settlement_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.date IS 'Journal Entry Date';


--
-- Name: COLUMN account_tax_settlement_wizard.select_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.select_journal IS 'Select Journal';


--
-- Name: COLUMN account_tax_settlement_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_settlement_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_settlement_wizard.write_date IS 'Last Updated on';


--
-- Name: account_tax_settlement_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_settlement_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_settlement_wizard_id_seq OWNER TO runbot;

--
-- Name: account_tax_settlement_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_settlement_wizard_id_seq OWNED BY public.account_tax_settlement_wizard.id;


--
-- Name: account_tax_unit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit (
    id integer NOT NULL,
    country_id integer NOT NULL,
    main_company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    vat character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_unit OWNER TO runbot;

--
-- Name: TABLE account_tax_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit IS 'Tax Unit';


--
-- Name: COLUMN account_tax_unit.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.country_id IS 'Country';


--
-- Name: COLUMN account_tax_unit.main_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.main_company_id IS 'Main Company';


--
-- Name: COLUMN account_tax_unit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_unit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_unit.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.name IS 'Name';


--
-- Name: COLUMN account_tax_unit.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.vat IS 'Tax ID';


--
-- Name: COLUMN account_tax_unit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_unit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_date IS 'Last Updated on';


--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_unit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_unit_id_seq OWNER TO runbot;

--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_unit_id_seq OWNED BY public.account_tax_unit.id;


--
-- Name: account_tax_unit_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit_res_company_rel (
    res_company_id integer NOT NULL,
    account_tax_unit_id integer NOT NULL
);


ALTER TABLE public.account_tax_unit_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_unit_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit_res_company_rel IS 'RELATION BETWEEN res_company AND account_tax_unit';


--
-- Name: account_transfer_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_transfer_model (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    frequency character varying NOT NULL,
    state character varying NOT NULL,
    date_start date NOT NULL,
    date_stop date,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_transfer_model OWNER TO runbot;

--
-- Name: TABLE account_transfer_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_transfer_model IS 'Account Transfer Model';


--
-- Name: COLUMN account_transfer_model.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_transfer_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.name IS 'Name';


--
-- Name: COLUMN account_transfer_model.frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.frequency IS 'Frequency';


--
-- Name: COLUMN account_transfer_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.state IS 'State';


--
-- Name: COLUMN account_transfer_model.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.date_start IS 'Start Date';


--
-- Name: COLUMN account_transfer_model.date_stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.date_stop IS 'Stop Date';


--
-- Name: COLUMN account_transfer_model.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.active IS 'Active';


--
-- Name: COLUMN account_transfer_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model.write_date IS 'Last Updated on';


--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_transfer_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_transfer_model_id_seq OWNER TO runbot;

--
-- Name: account_transfer_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_transfer_model_id_seq OWNED BY public.account_transfer_model.id;


--
-- Name: account_transfer_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_transfer_model_line (
    id integer NOT NULL,
    transfer_model_id integer NOT NULL,
    account_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percent double precision NOT NULL
);


ALTER TABLE public.account_transfer_model_line OWNER TO runbot;

--
-- Name: TABLE account_transfer_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_transfer_model_line IS 'Account Transfer Model Line';


--
-- Name: COLUMN account_transfer_model_line.transfer_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.transfer_model_id IS 'Transfer Model';


--
-- Name: COLUMN account_transfer_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.account_id IS 'Destination Account';


--
-- Name: COLUMN account_transfer_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_transfer_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_transfer_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_transfer_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_transfer_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_transfer_model_line.percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_transfer_model_line.percent IS 'Percent';


--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_transfer_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_transfer_model_line_id_seq OWNER TO runbot;

--
-- Name: account_transfer_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_transfer_model_line_id_seq OWNED BY public.account_transfer_model_line.id;


--
-- Name: account_transfer_model_line_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_transfer_model_line_res_partner_rel (
    account_transfer_model_line_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_transfer_model_line_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_transfer_model_line_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_transfer_model_line_res_partner_rel IS 'RELATION BETWEEN account_transfer_model_line AND res_partner';


--
-- Name: account_write_off_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_write_off_type (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    label character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_write_off_type OWNER TO runbot;

--
-- Name: TABLE account_write_off_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_write_off_type IS 'account.write_off.type';


--
-- Name: COLUMN account_write_off_type.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.account_id IS 'Account';


--
-- Name: COLUMN account_write_off_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.create_uid IS 'Created by';


--
-- Name: COLUMN account_write_off_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_write_off_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.name IS 'Name';


--
-- Name: COLUMN account_write_off_type.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.label IS 'Label';


--
-- Name: COLUMN account_write_off_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.active IS 'Active';


--
-- Name: COLUMN account_write_off_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.create_date IS 'Created on';


--
-- Name: COLUMN account_write_off_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.write_date IS 'Last Updated on';


--
-- Name: account_write_off_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_write_off_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_write_off_type_id_seq OWNER TO runbot;

--
-- Name: account_write_off_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_write_off_type_id_seq OWNED BY public.account_write_off_type.id;


--
-- Name: account_write_off_type_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_write_off_type_res_company_rel (
    account_write_off_type_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_write_off_type_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_write_off_type_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_write_off_type_res_company_rel IS 'RELATION BETWEEN account_write_off_type AND res_company';


--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: adhoc_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_category (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_category OWNER TO runbot;

--
-- Name: TABLE adhoc_module_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_category IS 'adhoc.module.category';


--
-- Name: COLUMN adhoc_module_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.name IS 'Name';


--
-- Name: COLUMN adhoc_module_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_category_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_category_id_seq OWNED BY public.adhoc_module_category.id;


--
-- Name: afip_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_activity (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT afip_activity_code_length CHECK ((length((code)::text) <= 6))
);


ALTER TABLE public.afip_activity OWNER TO runbot;

--
-- Name: TABLE afip_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_activity IS 'afip.activity';


--
-- Name: COLUMN afip_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.create_uid IS 'Created by';


--
-- Name: COLUMN afip_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_activity.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.code IS 'Code';


--
-- Name: COLUMN afip_activity.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.name IS 'Name';


--
-- Name: COLUMN afip_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.active IS 'Active';


--
-- Name: COLUMN afip_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.create_date IS 'Created on';


--
-- Name: COLUMN afip_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_activity.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT afip_activity_code_length ON afip_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT afip_activity_code_length ON public.afip_activity IS 'CHECK(LENGTH(code) <= 6)';


--
-- Name: afip_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_activity_id_seq OWNER TO runbot;

--
-- Name: afip_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_activity_id_seq OWNED BY public.afip_activity.id;


--
-- Name: afip_concept; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_concept (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_concept OWNER TO runbot;

--
-- Name: TABLE afip_concept; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_concept IS 'afip.concept';


--
-- Name: COLUMN afip_concept.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_uid IS 'Created by';


--
-- Name: COLUMN afip_concept.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_concept.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.code IS 'Code';


--
-- Name: COLUMN afip_concept.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.name IS 'Name';


--
-- Name: COLUMN afip_concept.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.active IS 'Active';


--
-- Name: COLUMN afip_concept.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_date IS 'Created on';


--
-- Name: COLUMN afip_concept.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_date IS 'Last Updated on';


--
-- Name: afip_concept_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_concept_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_concept_id_seq OWNER TO runbot;

--
-- Name: afip_concept_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_concept_id_seq OWNED BY public.afip_concept.id;


--
-- Name: afip_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_tax (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_tax OWNER TO runbot;

--
-- Name: TABLE afip_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_tax IS 'afip.tax';


--
-- Name: COLUMN afip_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_uid IS 'Created by';


--
-- Name: COLUMN afip_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_tax.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.code IS 'Code';


--
-- Name: COLUMN afip_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.name IS 'Name';


--
-- Name: COLUMN afip_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.active IS 'Active';


--
-- Name: COLUMN afip_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_date IS 'Created on';


--
-- Name: COLUMN afip_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_date IS 'Last Updated on';


--
-- Name: afip_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_tax_id_seq OWNER TO runbot;

--
-- Name: afip_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_tax_id_seq OWNED BY public.afip_tax.id;


--
-- Name: asset_modify; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.asset_modify (
    id integer NOT NULL,
    asset_id integer NOT NULL,
    method_number integer NOT NULL,
    account_asset_id integer,
    account_asset_counterpart_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    create_uid integer,
    write_uid integer,
    method_period character varying,
    modify_action character varying,
    date date,
    name text,
    value_residual numeric,
    salvage_value numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.asset_modify OWNER TO runbot;

--
-- Name: TABLE asset_modify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.asset_modify IS 'Modify Asset';


--
-- Name: COLUMN asset_modify.asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.asset_id IS 'Asset';


--
-- Name: COLUMN asset_modify.method_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.method_number IS 'Duration';


--
-- Name: COLUMN asset_modify.account_asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_asset_id IS 'Gross Increase Account';


--
-- Name: COLUMN asset_modify.account_asset_counterpart_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_asset_counterpart_id IS 'Asset Counterpart Account';


--
-- Name: COLUMN asset_modify.account_depreciation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN asset_modify.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN asset_modify.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.create_uid IS 'Created by';


--
-- Name: COLUMN asset_modify.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.write_uid IS 'Last Updated by';


--
-- Name: COLUMN asset_modify.method_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN asset_modify.modify_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.modify_action IS 'Action';


--
-- Name: COLUMN asset_modify.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.date IS 'Date';


--
-- Name: COLUMN asset_modify.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.name IS 'Note';


--
-- Name: COLUMN asset_modify.value_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.value_residual IS 'Depreciable Amount';


--
-- Name: COLUMN asset_modify.salvage_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.salvage_value IS 'Not Depreciable Amount';


--
-- Name: COLUMN asset_modify.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.create_date IS 'Created on';


--
-- Name: COLUMN asset_modify.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.write_date IS 'Last Updated on';


--
-- Name: asset_modify_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.asset_modify_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.asset_modify_id_seq OWNER TO runbot;

--
-- Name: asset_modify_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.asset_modify_id_seq OWNED BY public.asset_modify.id;


--
-- Name: asset_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.asset_move_line_rel (
    asset_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.asset_move_line_rel OWNER TO runbot;

--
-- Name: TABLE asset_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.asset_move_line_rel IS 'RELATION BETWEEN account_asset AND account_move_line';


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    code character varying(7),
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.code IS 'Verification Code';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: avatax_connection_test_result; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_connection_test_result (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_response text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_connection_test_result OWNER TO runbot;

--
-- Name: TABLE avatax_connection_test_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_connection_test_result IS 'Test connection with avatax';


--
-- Name: COLUMN avatax_connection_test_result.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_connection_test_result.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_connection_test_result.server_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.server_response IS 'Server Response';


--
-- Name: COLUMN avatax_connection_test_result.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_date IS 'Created on';


--
-- Name: COLUMN avatax_connection_test_result.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_date IS 'Last Updated on';


--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_connection_test_result_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNER TO runbot;

--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNED BY public.avatax_connection_test_result.id;


--
-- Name: avatax_exemption; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_exemption (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    description character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_exemption OWNER TO runbot;

--
-- Name: TABLE avatax_exemption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_exemption IS 'Avatax Partner Exemption Codes';


--
-- Name: COLUMN avatax_exemption.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.company_id IS 'Company';


--
-- Name: COLUMN avatax_exemption.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_exemption.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_exemption.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.name IS 'Name';


--
-- Name: COLUMN avatax_exemption.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.code IS 'Code';


--
-- Name: COLUMN avatax_exemption.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.description IS 'Description';


--
-- Name: COLUMN avatax_exemption.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.create_date IS 'Created on';


--
-- Name: COLUMN avatax_exemption.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.write_date IS 'Last Updated on';


--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_exemption_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_exemption_id_seq OWNER TO runbot;

--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_exemption_id_seq OWNED BY public.avatax_exemption.id;


--
-- Name: avatax_exemption_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_exemption_res_country_rel (
    avatax_exemption_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.avatax_exemption_res_country_rel OWNER TO runbot;

--
-- Name: TABLE avatax_exemption_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_exemption_res_country_rel IS 'RELATION BETWEEN avatax_exemption AND res_country';


--
-- Name: avatax_validate_address; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_validate_address (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_validate_address OWNER TO runbot;

--
-- Name: TABLE avatax_validate_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_validate_address IS 'Suggests validated addresses from Avatax';


--
-- Name: COLUMN avatax_validate_address.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.partner_id IS 'Partner';


--
-- Name: COLUMN avatax_validate_address.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_validate_address.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_validate_address.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.create_date IS 'Created on';


--
-- Name: COLUMN avatax_validate_address.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.write_date IS 'Last Updated on';


--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_validate_address_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_validate_address_id_seq OWNER TO runbot;

--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_validate_address_id_seq OWNED BY public.avatax_validate_address.id;


--
-- Name: base_cache_signaling_assets; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_assets
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_assets OWNER TO runbot;

--
-- Name: base_cache_signaling_default; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_default
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_default OWNER TO runbot;

--
-- Name: base_cache_signaling_groups; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_groups
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_groups OWNER TO runbot;

--
-- Name: base_cache_signaling_routing; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_routing
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_routing OWNER TO runbot;

--
-- Name: base_cache_signaling_templates; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_cache_signaling_templates
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_cache_signaling_templates OWNER TO runbot;

--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    from_invoice boolean
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_document_layout.from_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.from_invoice IS 'From Invoice';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install (
    id integer NOT NULL,
    confirm_input integer,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install OWNER TO runbot;

--
-- Name: TABLE base_module_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install IS 'Module Install';


--
-- Name: COLUMN base_module_install.confirm_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.confirm_input IS 'Confirm Input';


--
-- Name: COLUMN base_module_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.show_all IS 'Show All';


--
-- Name: COLUMN base_module_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_date IS 'Last Updated on';


--
-- Name: base_module_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_id_seq OWNER TO runbot;

--
-- Name: base_module_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_id_seq OWNED BY public.base_module_install.id;


--
-- Name: base_module_install_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_ir_module_module_rel (
    base_module_install_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_install_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_install_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_ir_module_module_rel IS 'RELATION BETWEEN base_module_install AND ir_module_module';


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    confirm_input integer
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.module_id IS 'Module';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_module_uninstall.confirm_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.confirm_input IS 'Confirm Input';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: base_registry_signaling; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_registry_signaling
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_registry_signaling OWNER TO runbot;

--
-- Name: bg_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bg_job (
    id integer NOT NULL,
    priority integer,
    max_retries integer,
    retry_count integer,
    next_job_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    model character varying NOT NULL,
    method character varying NOT NULL,
    batch_key character varying NOT NULL,
    args_json jsonb,
    kwargs_json jsonb,
    context_json jsonb,
    error_message text,
    start_time timestamp without time zone,
    end_time timestamp without time zone,
    cancel_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.bg_job OWNER TO runbot;

--
-- Name: TABLE bg_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bg_job IS 'Background Job';


--
-- Name: COLUMN bg_job.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.priority IS 'Priority';


--
-- Name: COLUMN bg_job.max_retries; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.max_retries IS 'Max Retries';


--
-- Name: COLUMN bg_job.retry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.retry_count IS 'Retry Count';


--
-- Name: COLUMN bg_job.next_job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.next_job_id IS 'Next Job';


--
-- Name: COLUMN bg_job.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.create_uid IS 'Created by';


--
-- Name: COLUMN bg_job.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bg_job.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.name IS 'Job Name';


--
-- Name: COLUMN bg_job.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.state IS 'State';


--
-- Name: COLUMN bg_job.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.model IS 'Model';


--
-- Name: COLUMN bg_job.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.method IS 'Method';


--
-- Name: COLUMN bg_job.batch_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.batch_key IS 'Batch Key';


--
-- Name: COLUMN bg_job.args_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.args_json IS 'Args Json';


--
-- Name: COLUMN bg_job.kwargs_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.kwargs_json IS 'Kwargs Json';


--
-- Name: COLUMN bg_job.context_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.context_json IS 'Context Json';


--
-- Name: COLUMN bg_job.error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.error_message IS 'Error Message';


--
-- Name: COLUMN bg_job.start_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.start_time IS 'Start Time';


--
-- Name: COLUMN bg_job.end_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.end_time IS 'End Time';


--
-- Name: COLUMN bg_job.cancel_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.cancel_time IS 'Cancel Time';


--
-- Name: COLUMN bg_job.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.create_date IS 'Created on';


--
-- Name: COLUMN bg_job.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.write_date IS 'Last Updated on';


--
-- Name: COLUMN bg_job.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.duration IS 'Duration';


--
-- Name: bg_job_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bg_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bg_job_id_seq OWNER TO runbot;

--
-- Name: bg_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bg_job_id_seq OWNED BY public.bg_job.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: bus_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_presence (
    id integer NOT NULL,
    user_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    guest_id integer,
    CONSTRAINT bus_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.bus_presence OWNER TO runbot;

--
-- Name: TABLE bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_presence IS 'User Presence';


--
-- Name: COLUMN bus_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.user_id IS 'Users';


--
-- Name: COLUMN bus_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.status IS 'IM Status';


--
-- Name: COLUMN bus_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN bus_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.last_presence IS 'Last Presence';


--
-- Name: COLUMN bus_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_presence.guest_id IS 'Guest';


--
-- Name: CONSTRAINT bus_presence_partner_or_guest_exists ON bus_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT bus_presence_partner_or_guest_exists ON public.bus_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: bus_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_presence_id_seq OWNER TO runbot;

--
-- Name: bus_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_presence_id_seq OWNED BY public.bus_presence.id;


--
-- Name: certificate_certificate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.certificate_certificate (
    id integer NOT NULL,
    private_key_id integer,
    public_key_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    pkcs12_password character varying,
    scope character varying,
    content_format character varying,
    subject_common_name character varying,
    serial_number character varying,
    loading_error text,
    active boolean,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.certificate_certificate OWNER TO runbot;

--
-- Name: TABLE certificate_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.certificate_certificate IS 'Certificate';


--
-- Name: COLUMN certificate_certificate.private_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.private_key_id IS 'Private Key';


--
-- Name: COLUMN certificate_certificate.public_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.public_key_id IS 'Public Key';


--
-- Name: COLUMN certificate_certificate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.company_id IS 'Company';


--
-- Name: COLUMN certificate_certificate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.create_uid IS 'Created by';


--
-- Name: COLUMN certificate_certificate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN certificate_certificate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.name IS 'Name';


--
-- Name: COLUMN certificate_certificate.pkcs12_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.pkcs12_password IS 'Certificate Password';


--
-- Name: COLUMN certificate_certificate.scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.scope IS 'Certificate scope';


--
-- Name: COLUMN certificate_certificate.content_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.content_format IS 'Original certificate format';


--
-- Name: COLUMN certificate_certificate.subject_common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.subject_common_name IS 'Subject Name';


--
-- Name: COLUMN certificate_certificate.serial_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.serial_number IS 'Serial number';


--
-- Name: COLUMN certificate_certificate.loading_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.loading_error IS 'Loading error';


--
-- Name: COLUMN certificate_certificate.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.active IS 'Active';


--
-- Name: COLUMN certificate_certificate.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.date_start IS 'Available date';


--
-- Name: COLUMN certificate_certificate.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.date_end IS 'Expiration date';


--
-- Name: COLUMN certificate_certificate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.create_date IS 'Created on';


--
-- Name: COLUMN certificate_certificate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.write_date IS 'Last Updated on';


--
-- Name: certificate_certificate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.certificate_certificate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.certificate_certificate_id_seq OWNER TO runbot;

--
-- Name: certificate_certificate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.certificate_certificate_id_seq OWNED BY public.certificate_certificate.id;


--
-- Name: certificate_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.certificate_key (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    password character varying,
    loading_error text,
    public boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.certificate_key OWNER TO runbot;

--
-- Name: TABLE certificate_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.certificate_key IS 'Cryptographic Keys';


--
-- Name: COLUMN certificate_key.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.company_id IS 'Company';


--
-- Name: COLUMN certificate_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.create_uid IS 'Created by';


--
-- Name: COLUMN certificate_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN certificate_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.name IS 'Name';


--
-- Name: COLUMN certificate_key.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.password IS 'Private key password';


--
-- Name: COLUMN certificate_key.loading_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.loading_error IS 'Loading error';


--
-- Name: COLUMN certificate_key.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.public IS 'Public/Private key';


--
-- Name: COLUMN certificate_key.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.active IS 'Active';


--
-- Name: COLUMN certificate_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.create_date IS 'Created on';


--
-- Name: COLUMN certificate_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.write_date IS 'Last Updated on';


--
-- Name: certificate_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.certificate_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.certificate_key_id_seq OWNER TO runbot;

--
-- Name: certificate_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.certificate_key_id_seq OWNED BY public.certificate_key.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: crm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_tag OWNER TO runbot;

--
-- Name: TABLE crm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag IS 'CRM Tag';


--
-- Name: COLUMN crm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.color IS 'Color';


--
-- Name: COLUMN crm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.name IS 'Tag Name';


--
-- Name: COLUMN crm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_date IS 'Created on';


--
-- Name: COLUMN crm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_date IS 'Last Updated on';


--
-- Name: crm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_tag_id_seq OWNER TO runbot;

--
-- Name: crm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_tag_id_seq OWNED BY public.crm_tag.id;


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    invoiced_target double precision
);


ALTER TABLE public.crm_team OWNER TO runbot;

--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team.invoiced_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.invoiced_target IS 'Invoicing Target';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_id_seq OWNER TO runbot;

--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: crm_team_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_member (
    id integer NOT NULL,
    crm_team_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_team_member OWNER TO runbot;

--
-- Name: TABLE crm_team_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_member IS 'Sales Team Member';


--
-- Name: COLUMN crm_team_member.crm_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN crm_team_member.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_team_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team_member.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.active IS 'Active';


--
-- Name: COLUMN crm_team_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_date IS 'Created on';


--
-- Name: COLUMN crm_team_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_date IS 'Last Updated on';


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_member_id_seq OWNER TO runbot;

--
-- Name: crm_team_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_member_id_seq OWNED BY public.crm_team_member.id;


--
-- Name: db_configuration; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.db_configuration (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.db_configuration OWNER TO runbot;

--
-- Name: TABLE db_configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.db_configuration IS 'db.configuration';


--
-- Name: COLUMN db_configuration.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.create_uid IS 'Created by';


--
-- Name: COLUMN db_configuration.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.write_uid IS 'Last Updated by';


--
-- Name: COLUMN db_configuration.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.name IS 'Name';


--
-- Name: COLUMN db_configuration.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.create_date IS 'Created on';


--
-- Name: COLUMN db_configuration.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.db_configuration.write_date IS 'Last Updated on';


--
-- Name: db_configuration_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.db_configuration_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.db_configuration_id_seq OWNER TO runbot;

--
-- Name: db_configuration_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.db_configuration_id_seq OWNED BY public.db_configuration.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    kpi_account_total_revenue boolean,
    kpi_account_bank_cash boolean,
    kpi_all_sale_total boolean
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_account_total_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_total_revenue IS 'Revenue';


--
-- Name: COLUMN digest_digest.kpi_account_bank_cash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_bank_cash IS 'Bank & Cash Moves';


--
-- Name: COLUMN digest_digest.kpi_all_sale_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_all_sale_total IS 'All Sales';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    allow_public_upload boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL))),
    CONSTRAINT discuss_channel_sub_channel_no_group_public_id CHECK (((parent_channel_id IS NULL) OR (group_public_id IS NULL)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.allow_public_upload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.allow_public_upload IS 'Allow Public Upload';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_sub_channel_no_group_public_id ON public.discuss_channel IS 'CHECK(parent_channel_id IS NULL OR group_public_id IS NULL)';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    fold_state character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.fold_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fold_state IS 'Conversation Fold State';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: dms_acc_rep_export_wizard_format_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.dms_acc_rep_export_wizard_format_rel (
    account_reports_export_wizard_id integer NOT NULL,
    account_reports_export_wizard_format_id integer NOT NULL
);


ALTER TABLE public.dms_acc_rep_export_wizard_format_rel OWNER TO runbot;

--
-- Name: TABLE dms_acc_rep_export_wizard_format_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.dms_acc_rep_export_wizard_format_rel IS 'RELATION BETWEEN account_reports_export_wizard AND account_reports_export_wizard_format';


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: header_footer_quotation_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.header_footer_quotation_template_rel (
    quotation_document_id integer NOT NULL,
    sale_order_template_id integer NOT NULL
);


ALTER TABLE public.header_footer_quotation_template_rel OWNER TO runbot;

--
-- Name: TABLE header_footer_quotation_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.header_footer_quotation_template_rel IS 'RELATION BETWEEN quotation_document AND sale_order_template';


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision,
    sender_name character varying
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: COLUMN iap_account.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.sender_name IS 'Sender Name';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: inflation_adjustment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.inflation_adjustment (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    account_id integer NOT NULL,
    closure_move_id integer,
    open_move_id integer,
    create_uid integer,
    write_uid integer,
    open_cloure_entry character varying,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.inflation_adjustment OWNER TO runbot;

--
-- Name: TABLE inflation_adjustment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.inflation_adjustment IS 'Inflation adjustment';


--
-- Name: COLUMN inflation_adjustment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.journal_id IS 'Journal';


--
-- Name: COLUMN inflation_adjustment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.company_id IS 'Company';


--
-- Name: COLUMN inflation_adjustment.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.account_id IS 'Account';


--
-- Name: COLUMN inflation_adjustment.closure_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.closure_move_id IS 'Asiento de cierre';


--
-- Name: COLUMN inflation_adjustment.open_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.open_move_id IS 'Asiento de apertura';


--
-- Name: COLUMN inflation_adjustment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.create_uid IS 'Created by';


--
-- Name: COLUMN inflation_adjustment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN inflation_adjustment.open_cloure_entry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.open_cloure_entry IS 'Ha realizado asientos de cierre/apertura?';


--
-- Name: COLUMN inflation_adjustment.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.date_from IS 'Date From';


--
-- Name: COLUMN inflation_adjustment.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.date_to IS 'Date To';


--
-- Name: COLUMN inflation_adjustment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.create_date IS 'Created on';


--
-- Name: COLUMN inflation_adjustment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment.write_date IS 'Last Updated on';


--
-- Name: inflation_adjustment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.inflation_adjustment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.inflation_adjustment_id_seq OWNER TO runbot;

--
-- Name: inflation_adjustment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.inflation_adjustment_id_seq OWNED BY public.inflation_adjustment.id;


--
-- Name: inflation_adjustment_index; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.inflation_adjustment_index (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    value numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.inflation_adjustment_index OWNER TO runbot;

--
-- Name: TABLE inflation_adjustment_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.inflation_adjustment_index IS 'Inflation Adjustment Index';


--
-- Name: COLUMN inflation_adjustment_index.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.create_uid IS 'Created by';


--
-- Name: COLUMN inflation_adjustment_index.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.write_uid IS 'Last Updated by';


--
-- Name: COLUMN inflation_adjustment_index.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.date IS 'Date';


--
-- Name: COLUMN inflation_adjustment_index.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.value IS 'Value';


--
-- Name: COLUMN inflation_adjustment_index.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.create_date IS 'Created on';


--
-- Name: COLUMN inflation_adjustment_index.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.inflation_adjustment_index.write_date IS 'Last Updated on';


--
-- Name: inflation_adjustment_index_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.inflation_adjustment_index_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.inflation_adjustment_index_id_seq OWNER TO runbot;

--
-- Name: inflation_adjustment_index_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.inflation_adjustment_index_id_seq OWNED BY public.inflation_adjustment_index.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean,
    is_invoice_report boolean,
    l10n_ar_copies character varying
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: COLUMN ir_act_report_xml.is_invoice_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.is_invoice_report IS 'Invoice report';


--
-- Name: COLUMN ir_act_report_xml.l10n_ar_copies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.l10n_ar_copies IS 'Agregar Duplicado/Triplicado';


--
-- Name: ir_act_report_xml_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_act_report_xml_id integer NOT NULL
);


ALTER TABLE public.ir_act_report_xml_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_report_xml_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_report_xml_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_act_report_xml';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    selection_value integer,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    model_name character varying,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text,
    template_id integer,
    activity_type_id integer,
    activity_date_deadline_range integer,
    activity_user_id integer,
    mail_post_method character varying,
    activity_summary character varying,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_field_name character varying,
    activity_note text,
    mail_post_autofollow boolean,
    sms_template_id integer,
    sms_method character varying
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.model_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_name IS 'Model Name';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.mail_post_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_method IS 'Send Email As';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Title';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'User Type';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User Field';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.mail_post_autofollow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_autofollow IS 'Subscribe Recipients';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_method IS 'Send SMS As';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_server_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_act_server';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_cron_id integer NOT NULL
);


ALTER TABLE public.ir_cron_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_cron_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_cron';


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    json_value character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default.json_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.json_value IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
                (action_id IS NOT NULL AND python_method IS NULL) OR
                (action_id IS NULL AND python_method IS NOT NULL)
            )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(
                NOT (python_method IS NOT NULL AND name IS NULL)
            )';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    user_id integer,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.user_id IS 'User';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(
                NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL)
            )';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    google_gmail_access_token_expiration integer,
    google_gmail_authorization_code character varying,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.google_gmail_authorization_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_authorization_code IS 'Authorization Code';


--
-- Name: COLUMN ir_mail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    name jsonb NOT NULL,
    info text,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Has Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Has Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Has Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_access_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_model_access_id integer NOT NULL
);


ALTER TABLE public.ir_model_access_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_access_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_model_access';


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Create Date';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    complete_name character varying,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    translate boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    tracking integer,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.complete_name IS 'Complete Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_model_fields';


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_model_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ir_model_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_model';


--
-- Name: ir_model_spreadsheet_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_spreadsheet_dashboard_rel (
    spreadsheet_dashboard_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ir_model_spreadsheet_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_spreadsheet_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_spreadsheet_dashboard_rel IS 'RELATION BETWEEN spreadsheet_dashboard AND ir_model';


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean,
    adhoc_category_id integer,
    extra_lines integer,
    adhoc_summary character varying,
    support_type character varying,
    review character varying,
    customer_warning character varying,
    tx_project_url character varying,
    adhoc_description_html text,
    is_odoo_module boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: COLUMN ir_module_module.adhoc_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.adhoc_category_id IS 'Adhoc Category';


--
-- Name: COLUMN ir_module_module.extra_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.extra_lines IS 'Extra Lines';


--
-- Name: COLUMN ir_module_module.adhoc_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.adhoc_summary IS 'Adhoc Summary';


--
-- Name: COLUMN ir_module_module.support_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.support_type IS 'Support Type';


--
-- Name: COLUMN ir_module_module.review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.review IS 'Review';


--
-- Name: COLUMN ir_module_module.customer_warning; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.customer_warning IS 'Advertencia';


--
-- Name: COLUMN ir_module_module.tx_project_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.tx_project_url IS 'Transifex Project URL';


--
-- Name: COLUMN ir_module_module.adhoc_description_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.adhoc_description_html IS 'Adhoc Description Html';


--
-- Name: COLUMN ir_module_module.is_odoo_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.is_odoo_module IS 'Is Odoo Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    qweb text,
    create_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_rule_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_rule_id integer NOT NULL
);


ALTER TABLE public.ir_rule_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_rule_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_rule';


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_002; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_002
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_002 OWNER TO runbot;

--
-- Name: ir_sequence_003; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_003
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_003 OWNER TO runbot;

--
-- Name: ir_sequence_004; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_004
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_004 OWNER TO runbot;

--
-- Name: ir_sequence_005; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_005
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_005 OWNER TO runbot;

--
-- Name: ir_sequence_009; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_009
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_009 OWNER TO runbot;

--
-- Name: ir_sequence_010; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_010
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_010 OWNER TO runbot;

--
-- Name: ir_sequence_011; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_011
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_011 OWNER TO runbot;

--
-- Name: ir_sequence_012; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_012
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_012 OWNER TO runbot;

--
-- Name: ir_sequence_013; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_013
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_013 OWNER TO runbot;

--
-- Name: ir_sequence_014; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_014
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_014 OWNER TO runbot;

--
-- Name: ir_sequence_015; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_015
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_015 OWNER TO runbot;

--
-- Name: ir_sequence_016; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_016
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_016 OWNER TO runbot;

--
-- Name: ir_sequence_017; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_017
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_017 OWNER TO runbot;

--
-- Name: ir_sequence_018; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_018
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_018 OWNER TO runbot;

--
-- Name: ir_sequence_019; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_019
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_019 OWNER TO runbot;

--
-- Name: ir_sequence_020; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_020
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_020 OWNER TO runbot;

--
-- Name: ir_sequence_021; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_021
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_021 OWNER TO runbot;

--
-- Name: ir_sequence_022; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_022
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_022 OWNER TO runbot;

--
-- Name: ir_sequence_023; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_023
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_023 OWNER TO runbot;

--
-- Name: ir_sequence_024; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_024
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_024 OWNER TO runbot;

--
-- Name: ir_sequence_025; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_025
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_025 OWNER TO runbot;

--
-- Name: ir_sequence_026; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_026
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_026 OWNER TO runbot;

--
-- Name: ir_sequence_027; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_027
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_027 OWNER TO runbot;

--
-- Name: ir_sequence_028; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_028
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_028 OWNER TO runbot;

--
-- Name: ir_sequence_029; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_029
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_029 OWNER TO runbot;

--
-- Name: ir_sequence_030; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_030
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_030 OWNER TO runbot;

--
-- Name: ir_sequence_031; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_031
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_031 OWNER TO runbot;

--
-- Name: ir_sequence_032; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_032
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_032 OWNER TO runbot;

--
-- Name: ir_sequence_033; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_033
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_033 OWNER TO runbot;

--
-- Name: ir_sequence_034; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_034
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_034 OWNER TO runbot;

--
-- Name: ir_sequence_035; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_035
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_035 OWNER TO runbot;

--
-- Name: ir_sequence_036; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_036
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_036 OWNER TO runbot;

--
-- Name: ir_sequence_037; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_037
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_037 OWNER TO runbot;

--
-- Name: ir_sequence_038; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_038
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_038 OWNER TO runbot;

--
-- Name: ir_sequence_039; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_039
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_039 OWNER TO runbot;

--
-- Name: ir_sequence_040; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_040
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_040 OWNER TO runbot;

--
-- Name: ir_sequence_041; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_041
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_041 OWNER TO runbot;

--
-- Name: ir_sequence_042; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_042
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_042 OWNER TO runbot;

--
-- Name: ir_sequence_043; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_043
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_043 OWNER TO runbot;

--
-- Name: ir_sequence_044; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_044
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_044 OWNER TO runbot;

--
-- Name: ir_sequence_045; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_045
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_045 OWNER TO runbot;

--
-- Name: ir_sequence_046; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_046
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_046 OWNER TO runbot;

--
-- Name: ir_sequence_047; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_047
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_047 OWNER TO runbot;

--
-- Name: ir_sequence_048; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_048
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_048 OWNER TO runbot;

--
-- Name: ir_sequence_049; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_049
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_049 OWNER TO runbot;

--
-- Name: ir_sequence_050; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_050
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_050 OWNER TO runbot;

--
-- Name: ir_sequence_051; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_051
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_051 OWNER TO runbot;

--
-- Name: ir_sequence_052; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_052
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_052 OWNER TO runbot;

--
-- Name: ir_sequence_053; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_053
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_053 OWNER TO runbot;

--
-- Name: ir_sequence_054; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_054
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_054 OWNER TO runbot;

--
-- Name: ir_sequence_055; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_055
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_055 OWNER TO runbot;

--
-- Name: ir_sequence_056; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_056
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_056 OWNER TO runbot;

--
-- Name: ir_sequence_057; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_057
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_057 OWNER TO runbot;

--
-- Name: ir_sequence_058; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_058
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_058 OWNER TO runbot;

--
-- Name: ir_sequence_059; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_059
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_059 OWNER TO runbot;

--
-- Name: ir_sequence_060; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_060
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_060 OWNER TO runbot;

--
-- Name: ir_sequence_061; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_061
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_061 OWNER TO runbot;

--
-- Name: ir_sequence_062; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_062
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_062 OWNER TO runbot;

--
-- Name: ir_sequence_063; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_063
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_063 OWNER TO runbot;

--
-- Name: ir_sequence_064; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_064
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_064 OWNER TO runbot;

--
-- Name: ir_sequence_065; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_065
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_065 OWNER TO runbot;

--
-- Name: ir_sequence_066; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_066
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_066 OWNER TO runbot;

--
-- Name: ir_sequence_067; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_067
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_067 OWNER TO runbot;

--
-- Name: ir_sequence_068; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_068
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_068 OWNER TO runbot;

--
-- Name: ir_sequence_069; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_069
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_069 OWNER TO runbot;

--
-- Name: ir_sequence_070; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_070
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_070 OWNER TO runbot;

--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    customize_show boolean,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_ui_view.customize_show; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.customize_show IS 'Show As Optional Inherit';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: ir_ui_view_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_ui_view_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_ui_view';


--
-- Name: journal_account_control_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.journal_account_control_rel (
    journal_id integer NOT NULL,
    account_id integer NOT NULL
);


ALTER TABLE public.journal_account_control_rel OWNER TO runbot;

--
-- Name: TABLE journal_account_control_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.journal_account_control_rel IS 'RELATION BETWEEN account_journal AND account_account';


--
-- Name: l10n_ar_afip_reponsibility_type_fiscal_pos_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_afip_reponsibility_type_fiscal_pos_rel (
    account_fiscal_position_id integer NOT NULL,
    l10n_ar_afip_responsibility_type_id integer NOT NULL
);


ALTER TABLE public.l10n_ar_afip_reponsibility_type_fiscal_pos_rel OWNER TO runbot;

--
-- Name: TABLE l10n_ar_afip_reponsibility_type_fiscal_pos_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_afip_reponsibility_type_fiscal_pos_rel IS 'RELATION BETWEEN account_fiscal_position AND l10n_ar_afip_responsibility_type';


--
-- Name: l10n_ar_afip_responsibility_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_afip_responsibility_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_ar_afip_responsibility_type OWNER TO runbot;

--
-- Name: TABLE l10n_ar_afip_responsibility_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_afip_responsibility_type IS 'AFIP Responsibility Type';


--
-- Name: COLUMN l10n_ar_afip_responsibility_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_responsibility_type.sequence IS 'Sequence';


--
-- Name: COLUMN l10n_ar_afip_responsibility_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_responsibility_type.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_ar_afip_responsibility_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_responsibility_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_ar_afip_responsibility_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_responsibility_type.name IS 'Name';


--
-- Name: COLUMN l10n_ar_afip_responsibility_type.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_responsibility_type.code IS 'Code';


--
-- Name: COLUMN l10n_ar_afip_responsibility_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_responsibility_type.active IS 'Active';


--
-- Name: COLUMN l10n_ar_afip_responsibility_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_responsibility_type.create_date IS 'Created on';


--
-- Name: COLUMN l10n_ar_afip_responsibility_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_responsibility_type.write_date IS 'Last Updated on';


--
-- Name: l10n_ar_afip_responsibility_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_ar_afip_responsibility_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_ar_afip_responsibility_type_id_seq OWNER TO runbot;

--
-- Name: l10n_ar_afip_responsibility_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_ar_afip_responsibility_type_id_seq OWNED BY public.l10n_ar_afip_responsibility_type.id;


--
-- Name: l10n_ar_afip_ws_consult; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_afip_ws_consult (
    id integer NOT NULL,
    number integer NOT NULL,
    journal_id integer NOT NULL,
    document_type_id integer,
    create_uid integer,
    write_uid integer,
    consult_type character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_ar_afip_ws_consult OWNER TO runbot;

--
-- Name: TABLE l10n_ar_afip_ws_consult; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_afip_ws_consult IS 'Consult Invoice Data in AFIP';


--
-- Name: COLUMN l10n_ar_afip_ws_consult.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_ws_consult.number IS 'Number';


--
-- Name: COLUMN l10n_ar_afip_ws_consult.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_ws_consult.journal_id IS 'Journal';


--
-- Name: COLUMN l10n_ar_afip_ws_consult.document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_ws_consult.document_type_id IS 'Document Type';


--
-- Name: COLUMN l10n_ar_afip_ws_consult.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_ws_consult.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_ar_afip_ws_consult.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_ws_consult.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_ar_afip_ws_consult.consult_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_ws_consult.consult_type IS 'Type';


--
-- Name: COLUMN l10n_ar_afip_ws_consult.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_ws_consult.create_date IS 'Created on';


--
-- Name: COLUMN l10n_ar_afip_ws_consult.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afip_ws_consult.write_date IS 'Last Updated on';


--
-- Name: l10n_ar_afip_ws_consult_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_ar_afip_ws_consult_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_ar_afip_ws_consult_id_seq OWNER TO runbot;

--
-- Name: l10n_ar_afip_ws_consult_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_ar_afip_ws_consult_id_seq OWNED BY public.l10n_ar_afip_ws_consult.id;


--
-- Name: l10n_ar_afipws_connection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_afipws_connection (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    uniqueid character varying,
    type character varying NOT NULL,
    l10n_ar_afip_ws character varying NOT NULL,
    token text,
    sign text,
    generation_time timestamp without time zone,
    expiration_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_ar_afipws_connection OWNER TO runbot;

--
-- Name: TABLE l10n_ar_afipws_connection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_afipws_connection IS 'AFIP Webservice Connection';


--
-- Name: COLUMN l10n_ar_afipws_connection.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.company_id IS 'Company';


--
-- Name: COLUMN l10n_ar_afipws_connection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_ar_afipws_connection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_ar_afipws_connection.uniqueid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.uniqueid IS 'Unique ID';


--
-- Name: COLUMN l10n_ar_afipws_connection.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.type IS 'Type';


--
-- Name: COLUMN l10n_ar_afipws_connection.l10n_ar_afip_ws; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.l10n_ar_afip_ws IS 'AFIP WS';


--
-- Name: COLUMN l10n_ar_afipws_connection.token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.token IS 'Token';


--
-- Name: COLUMN l10n_ar_afipws_connection.sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.sign IS 'Sign';


--
-- Name: COLUMN l10n_ar_afipws_connection.generation_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.generation_time IS 'Generation Time';


--
-- Name: COLUMN l10n_ar_afipws_connection.expiration_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.expiration_time IS 'Expiration Time';


--
-- Name: COLUMN l10n_ar_afipws_connection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.create_date IS 'Created on';


--
-- Name: COLUMN l10n_ar_afipws_connection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_afipws_connection.write_date IS 'Last Updated on';


--
-- Name: l10n_ar_afipws_connection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_ar_afipws_connection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_ar_afipws_connection_id_seq OWNER TO runbot;

--
-- Name: l10n_ar_afipws_connection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_ar_afipws_connection_id_seq OWNED BY public.l10n_ar_afipws_connection.id;


--
-- Name: l10n_ar_boarding_permission; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_boarding_permission (
    id integer NOT NULL,
    dst_country integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    number character varying(16) NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_ar_boarding_permission OWNER TO runbot;

--
-- Name: TABLE l10n_ar_boarding_permission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_boarding_permission IS 'Boarding Permission';


--
-- Name: COLUMN l10n_ar_boarding_permission.dst_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_boarding_permission.dst_country IS 'País de destino';


--
-- Name: COLUMN l10n_ar_boarding_permission.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_boarding_permission.company_id IS 'Company';


--
-- Name: COLUMN l10n_ar_boarding_permission.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_boarding_permission.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_ar_boarding_permission.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_boarding_permission.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_ar_boarding_permission.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_boarding_permission.number IS 'Permiso de embarque';


--
-- Name: COLUMN l10n_ar_boarding_permission.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_boarding_permission.create_date IS 'Created on';


--
-- Name: COLUMN l10n_ar_boarding_permission.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_boarding_permission.write_date IS 'Last Updated on';


--
-- Name: l10n_ar_boarding_permission_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_ar_boarding_permission_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_ar_boarding_permission_id_seq OWNER TO runbot;

--
-- Name: l10n_ar_boarding_permission_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_ar_boarding_permission_id_seq OWNED BY public.l10n_ar_boarding_permission.id;


--
-- Name: l10n_ar_earnings_scale; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_earnings_scale (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_ar_earnings_scale OWNER TO runbot;

--
-- Name: TABLE l10n_ar_earnings_scale; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_earnings_scale IS 'l10n_ar.earnings.scale';


--
-- Name: COLUMN l10n_ar_earnings_scale.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_ar_earnings_scale.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_ar_earnings_scale.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale.name IS 'Name';


--
-- Name: COLUMN l10n_ar_earnings_scale.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale.create_date IS 'Created on';


--
-- Name: COLUMN l10n_ar_earnings_scale.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale.write_date IS 'Last Updated on';


--
-- Name: l10n_ar_earnings_scale_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_ar_earnings_scale_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_ar_earnings_scale_id_seq OWNER TO runbot;

--
-- Name: l10n_ar_earnings_scale_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_ar_earnings_scale_id_seq OWNED BY public.l10n_ar_earnings_scale.id;


--
-- Name: l10n_ar_earnings_scale_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_earnings_scale_line (
    id integer NOT NULL,
    scale_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    to_amount numeric,
    fixed_amount numeric,
    percentage numeric,
    excess_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_ar_earnings_scale_line OWNER TO runbot;

--
-- Name: TABLE l10n_ar_earnings_scale_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_earnings_scale_line IS 'l10n_ar.earnings.scale.line';


--
-- Name: COLUMN l10n_ar_earnings_scale_line.scale_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale_line.scale_id IS 'Scale';


--
-- Name: COLUMN l10n_ar_earnings_scale_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale_line.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_ar_earnings_scale_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_ar_earnings_scale_line.to_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale_line.to_amount IS 'To $';


--
-- Name: COLUMN l10n_ar_earnings_scale_line.fixed_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale_line.fixed_amount IS '$';


--
-- Name: COLUMN l10n_ar_earnings_scale_line.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale_line.percentage IS 'Add %';


--
-- Name: COLUMN l10n_ar_earnings_scale_line.excess_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale_line.excess_amount IS 'S/ Exceeding $';


--
-- Name: COLUMN l10n_ar_earnings_scale_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale_line.create_date IS 'Created on';


--
-- Name: COLUMN l10n_ar_earnings_scale_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_earnings_scale_line.write_date IS 'Last Updated on';


--
-- Name: l10n_ar_earnings_scale_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_ar_earnings_scale_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_ar_earnings_scale_line_id_seq OWNER TO runbot;

--
-- Name: l10n_ar_earnings_scale_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_ar_earnings_scale_line_id_seq OWNED BY public.l10n_ar_earnings_scale_line.id;


--
-- Name: l10n_ar_partner_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_partner_tax (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    tax_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    ref character varying,
    from_date date,
    to_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_ar_partner_tax OWNER TO runbot;

--
-- Name: TABLE l10n_ar_partner_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_partner_tax IS 'Argentinean Partner Taxes';


--
-- Name: COLUMN l10n_ar_partner_tax.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.partner_id IS 'Partner';


--
-- Name: COLUMN l10n_ar_partner_tax.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.tax_id IS 'Tax';


--
-- Name: COLUMN l10n_ar_partner_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.company_id IS 'Company';


--
-- Name: COLUMN l10n_ar_partner_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_ar_partner_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_ar_partner_tax.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.ref IS 'ref';


--
-- Name: COLUMN l10n_ar_partner_tax.from_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.from_date IS 'From Date';


--
-- Name: COLUMN l10n_ar_partner_tax.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.to_date IS 'To Date';


--
-- Name: COLUMN l10n_ar_partner_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.create_date IS 'Created on';


--
-- Name: COLUMN l10n_ar_partner_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_partner_tax.write_date IS 'Last Updated on';


--
-- Name: l10n_ar_partner_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_ar_partner_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_ar_partner_tax_id_seq OWNER TO runbot;

--
-- Name: l10n_ar_partner_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_ar_partner_tax_id_seq OWNED BY public.l10n_ar_partner_tax.id;


--
-- Name: l10n_ar_payment_register_withholding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_payment_register_withholding (
    id integer NOT NULL,
    payment_register_id integer NOT NULL,
    tax_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    base_amount numeric NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_ar_payment_register_withholding OWNER TO runbot;

--
-- Name: TABLE l10n_ar_payment_register_withholding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_payment_register_withholding IS 'Payment register withholding lines';


--
-- Name: COLUMN l10n_ar_payment_register_withholding.payment_register_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_register_withholding.payment_register_id IS 'Payment Register';


--
-- Name: COLUMN l10n_ar_payment_register_withholding.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_register_withholding.tax_id IS 'Tax';


--
-- Name: COLUMN l10n_ar_payment_register_withholding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_register_withholding.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_ar_payment_register_withholding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_register_withholding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_ar_payment_register_withholding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_register_withholding.name IS 'Number';


--
-- Name: COLUMN l10n_ar_payment_register_withholding.base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_register_withholding.base_amount IS 'Base Amount';


--
-- Name: COLUMN l10n_ar_payment_register_withholding.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_register_withholding.amount IS 'Amount';


--
-- Name: COLUMN l10n_ar_payment_register_withholding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_register_withholding.create_date IS 'Created on';


--
-- Name: COLUMN l10n_ar_payment_register_withholding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_register_withholding.write_date IS 'Last Updated on';


--
-- Name: l10n_ar_payment_register_withholding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_ar_payment_register_withholding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_ar_payment_register_withholding_id_seq OWNER TO runbot;

--
-- Name: l10n_ar_payment_register_withholding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_ar_payment_register_withholding_id_seq OWNED BY public.l10n_ar_payment_register_withholding.id;


--
-- Name: l10n_ar_payment_withholding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_ar_payment_withholding (
    id integer NOT NULL,
    payment_id integer NOT NULL,
    tax_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    ref text,
    base_amount numeric,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_ar_payment_withholding OWNER TO runbot;

--
-- Name: TABLE l10n_ar_payment_withholding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_ar_payment_withholding IS 'Payment withholding lines';


--
-- Name: COLUMN l10n_ar_payment_withholding.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.payment_id IS 'Payment';


--
-- Name: COLUMN l10n_ar_payment_withholding.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.tax_id IS 'Tax';


--
-- Name: COLUMN l10n_ar_payment_withholding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_ar_payment_withholding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_ar_payment_withholding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.name IS 'Number';


--
-- Name: COLUMN l10n_ar_payment_withholding.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.ref IS 'Ref';


--
-- Name: COLUMN l10n_ar_payment_withholding.base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.base_amount IS 'Base Amount';


--
-- Name: COLUMN l10n_ar_payment_withholding.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.amount IS 'Amount';


--
-- Name: COLUMN l10n_ar_payment_withholding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.create_date IS 'Created on';


--
-- Name: COLUMN l10n_ar_payment_withholding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_ar_payment_withholding.write_date IS 'Last Updated on';


--
-- Name: l10n_ar_payment_withholding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_ar_payment_withholding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_ar_payment_withholding_id_seq OWNER TO runbot;

--
-- Name: l10n_ar_payment_withholding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_ar_payment_withholding_id_seq OWNED BY public.l10n_ar_payment_withholding.id;


--
-- Name: l10n_latam_check; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_latam_check (
    id integer NOT NULL,
    payment_id integer NOT NULL,
    current_journal_id integer,
    bank_id integer,
    outstanding_line_id integer,
    company_id integer,
    payment_method_line_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    issuer_vat character varying,
    issue_state character varying,
    payment_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    first_operation integer
);


ALTER TABLE public.l10n_latam_check OWNER TO runbot;

--
-- Name: TABLE l10n_latam_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_latam_check IS 'Account payment check';


--
-- Name: COLUMN l10n_latam_check.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.payment_id IS 'Payment';


--
-- Name: COLUMN l10n_latam_check.current_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.current_journal_id IS 'Current Journal';


--
-- Name: COLUMN l10n_latam_check.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.bank_id IS 'Bank';


--
-- Name: COLUMN l10n_latam_check.outstanding_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.outstanding_line_id IS 'Outstanding Line';


--
-- Name: COLUMN l10n_latam_check.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.company_id IS 'Company';


--
-- Name: COLUMN l10n_latam_check.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN l10n_latam_check.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_latam_check.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_latam_check.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.name IS 'Number';


--
-- Name: COLUMN l10n_latam_check.issuer_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.issuer_vat IS 'Issuer Vat';


--
-- Name: COLUMN l10n_latam_check.issue_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.issue_state IS 'Issue State';


--
-- Name: COLUMN l10n_latam_check.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.payment_date IS 'Payment Date';


--
-- Name: COLUMN l10n_latam_check.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.amount IS 'Amount';


--
-- Name: COLUMN l10n_latam_check.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.create_date IS 'Created on';


--
-- Name: COLUMN l10n_latam_check.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.write_date IS 'Last Updated on';


--
-- Name: COLUMN l10n_latam_check.first_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_check.first_operation IS 'First Operation';


--
-- Name: l10n_latam_check_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_latam_check_account_payment_rel (
    payment_id integer NOT NULL,
    check_id integer NOT NULL
);


ALTER TABLE public.l10n_latam_check_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE l10n_latam_check_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_latam_check_account_payment_rel IS 'RELATION BETWEEN account_payment AND l10n_latam_check';


--
-- Name: l10n_latam_check_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_latam_check_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_latam_check_id_seq OWNER TO runbot;

--
-- Name: l10n_latam_check_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_latam_check_id_seq OWNED BY public.l10n_latam_check.id;


--
-- Name: l10n_latam_document_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_latam_document_type (
    id integer NOT NULL,
    sequence integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    doc_code_prefix character varying,
    code character varying,
    internal_type character varying,
    name jsonb NOT NULL,
    report_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_ar_letter character varying,
    purchase_aliquots character varying
);


ALTER TABLE public.l10n_latam_document_type OWNER TO runbot;

--
-- Name: TABLE l10n_latam_document_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_latam_document_type IS 'Latam Document Type';


--
-- Name: COLUMN l10n_latam_document_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.sequence IS 'Sequence';


--
-- Name: COLUMN l10n_latam_document_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.country_id IS 'Country';


--
-- Name: COLUMN l10n_latam_document_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_latam_document_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_latam_document_type.doc_code_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.doc_code_prefix IS 'Document Code Prefix';


--
-- Name: COLUMN l10n_latam_document_type.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.code IS 'Code';


--
-- Name: COLUMN l10n_latam_document_type.internal_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.internal_type IS 'Internal Type';


--
-- Name: COLUMN l10n_latam_document_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.name IS 'Name';


--
-- Name: COLUMN l10n_latam_document_type.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.report_name IS 'Name on Reports';


--
-- Name: COLUMN l10n_latam_document_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.active IS 'Active';


--
-- Name: COLUMN l10n_latam_document_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.create_date IS 'Created on';


--
-- Name: COLUMN l10n_latam_document_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN l10n_latam_document_type.l10n_ar_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.l10n_ar_letter IS 'Letters';


--
-- Name: COLUMN l10n_latam_document_type.purchase_aliquots; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_document_type.purchase_aliquots IS 'Purchase Aliquots';


--
-- Name: l10n_latam_document_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_latam_document_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_latam_document_type_id_seq OWNER TO runbot;

--
-- Name: l10n_latam_document_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_latam_document_type_id_seq OWNED BY public.l10n_latam_document_type.id;


--
-- Name: l10n_latam_identification_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_latam_identification_type (
    id integer NOT NULL,
    sequence integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    description jsonb,
    active boolean,
    is_vat boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_ar_afip_code character varying
);


ALTER TABLE public.l10n_latam_identification_type OWNER TO runbot;

--
-- Name: TABLE l10n_latam_identification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_latam_identification_type IS 'Identification Types';


--
-- Name: COLUMN l10n_latam_identification_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.sequence IS 'Sequence';


--
-- Name: COLUMN l10n_latam_identification_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.country_id IS 'Country';


--
-- Name: COLUMN l10n_latam_identification_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_latam_identification_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_latam_identification_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.name IS 'Name';


--
-- Name: COLUMN l10n_latam_identification_type.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.description IS 'Description';


--
-- Name: COLUMN l10n_latam_identification_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.active IS 'Active';


--
-- Name: COLUMN l10n_latam_identification_type.is_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.is_vat IS 'Is Vat';


--
-- Name: COLUMN l10n_latam_identification_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.create_date IS 'Created on';


--
-- Name: COLUMN l10n_latam_identification_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN l10n_latam_identification_type.l10n_ar_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_identification_type.l10n_ar_afip_code IS 'AFIP Code';


--
-- Name: l10n_latam_identification_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_latam_identification_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_latam_identification_type_id_seq OWNER TO runbot;

--
-- Name: l10n_latam_identification_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_latam_identification_type_id_seq OWNED BY public.l10n_latam_identification_type.id;


--
-- Name: l10n_latam_payment_mass_transfer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_latam_payment_mass_transfer (
    id integer NOT NULL,
    destination_journal_id integer,
    create_uid integer,
    write_uid integer,
    communication character varying,
    payment_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    split_payment boolean
);


ALTER TABLE public.l10n_latam_payment_mass_transfer OWNER TO runbot;

--
-- Name: TABLE l10n_latam_payment_mass_transfer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_latam_payment_mass_transfer IS 'Checks Mass Transfers';


--
-- Name: COLUMN l10n_latam_payment_mass_transfer.destination_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_mass_transfer.destination_journal_id IS 'Destination Journal';


--
-- Name: COLUMN l10n_latam_payment_mass_transfer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_mass_transfer.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_latam_payment_mass_transfer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_mass_transfer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_latam_payment_mass_transfer.communication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_mass_transfer.communication IS 'Memo';


--
-- Name: COLUMN l10n_latam_payment_mass_transfer.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_mass_transfer.payment_date IS 'Payment Date';


--
-- Name: COLUMN l10n_latam_payment_mass_transfer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_mass_transfer.create_date IS 'Created on';


--
-- Name: COLUMN l10n_latam_payment_mass_transfer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_mass_transfer.write_date IS 'Last Updated on';


--
-- Name: COLUMN l10n_latam_payment_mass_transfer.split_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_mass_transfer.split_payment IS 'Split Payment';


--
-- Name: l10n_latam_payment_mass_transfer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_latam_payment_mass_transfer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_latam_payment_mass_transfer_id_seq OWNER TO runbot;

--
-- Name: l10n_latam_payment_mass_transfer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_latam_payment_mass_transfer_id_seq OWNED BY public.l10n_latam_payment_mass_transfer.id;


--
-- Name: l10n_latam_payment_register_check; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_latam_payment_register_check (
    id integer NOT NULL,
    payment_register_id integer NOT NULL,
    bank_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    issuer_vat character varying,
    payment_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_latam_payment_register_check OWNER TO runbot;

--
-- Name: TABLE l10n_latam_payment_register_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_latam_payment_register_check IS 'Payment register check';


--
-- Name: COLUMN l10n_latam_payment_register_check.payment_register_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.payment_register_id IS 'Payment Register';


--
-- Name: COLUMN l10n_latam_payment_register_check.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.bank_id IS 'Bank';


--
-- Name: COLUMN l10n_latam_payment_register_check.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_latam_payment_register_check.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_latam_payment_register_check.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.name IS 'Number';


--
-- Name: COLUMN l10n_latam_payment_register_check.issuer_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.issuer_vat IS 'Issuer Vat';


--
-- Name: COLUMN l10n_latam_payment_register_check.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.payment_date IS 'Payment Date';


--
-- Name: COLUMN l10n_latam_payment_register_check.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.amount IS 'Amount';


--
-- Name: COLUMN l10n_latam_payment_register_check.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.create_date IS 'Created on';


--
-- Name: COLUMN l10n_latam_payment_register_check.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_latam_payment_register_check.write_date IS 'Last Updated on';


--
-- Name: l10n_latam_payment_register_check_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_latam_payment_register_check_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_latam_payment_register_check_id_seq OWNER TO runbot;

--
-- Name: l10n_latam_payment_register_check_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_latam_payment_register_check_id_seq OWNED BY public.l10n_latam_payment_register_check.id;


--
-- Name: l10n_us_1099_box; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_us_1099_box (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_us_1099_box OWNER TO runbot;

--
-- Name: TABLE l10n_us_1099_box; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_us_1099_box IS 'Represents a box on a 1099 box.';


--
-- Name: COLUMN l10n_us_1099_box.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_box.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_us_1099_box.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_box.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_us_1099_box.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_box.name IS 'Name';


--
-- Name: COLUMN l10n_us_1099_box.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_box.create_date IS 'Created on';


--
-- Name: COLUMN l10n_us_1099_box.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_box.write_date IS 'Last Updated on';


--
-- Name: l10n_us_1099_box_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_us_1099_box_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_us_1099_box_id_seq OWNER TO runbot;

--
-- Name: l10n_us_1099_box_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_us_1099_box_id_seq OWNED BY public.l10n_us_1099_box.id;


--
-- Name: l10n_us_1099_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.l10n_us_1099_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    start_date date NOT NULL,
    end_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.l10n_us_1099_wizard OWNER TO runbot;

--
-- Name: TABLE l10n_us_1099_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.l10n_us_1099_wizard IS 'Exports 1099 data to a CSV file.';


--
-- Name: COLUMN l10n_us_1099_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN l10n_us_1099_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN l10n_us_1099_wizard.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_wizard.start_date IS 'Start Date';


--
-- Name: COLUMN l10n_us_1099_wizard.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_wizard.end_date IS 'End Date';


--
-- Name: COLUMN l10n_us_1099_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_wizard.create_date IS 'Created on';


--
-- Name: COLUMN l10n_us_1099_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.l10n_us_1099_wizard.write_date IS 'Last Updated on';


--
-- Name: l10n_us_1099_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.l10n_us_1099_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.l10n_us_1099_wizard_id_seq OWNER TO runbot;

--
-- Name: l10n_us_1099_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.l10n_us_1099_wizard_id_seq OWNED BY public.l10n_us_1099_wizard.id;


--
-- Name: latam_tranfer_check_reltransfer_id; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.latam_tranfer_check_reltransfer_id (
    check_id integer NOT NULL,
    l10n_latam_check_id integer NOT NULL
);


ALTER TABLE public.latam_tranfer_check_reltransfer_id OWNER TO runbot;

--
-- Name: TABLE latam_tranfer_check_reltransfer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.latam_tranfer_check_reltransfer_id IS 'RELATION BETWEEN l10n_latam_payment_mass_transfer AND l10n_latam_check';


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer NOT NULL,
    res_id integer,
    activity_type_id integer,
    user_id integer NOT NULL,
    request_partner_id integer,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    res_name character varying,
    summary character varying,
    user_tz character varying,
    date_deadline date NOT NULL,
    date_done date,
    note text,
    automated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    account_tax_closing_params jsonb,
    CONSTRAINT mail_activity_check_res_id_is_set CHECK (((res_id IS NOT NULL) AND (res_id <> 0)))
);


ALTER TABLE public.mail_activity OWNER TO runbot;

--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.request_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.request_partner_id IS 'Requesting Partner';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.user_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_tz IS 'Timezone';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_done IS 'Done Date';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.active IS 'Active';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_activity.account_tax_closing_params; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.account_tax_closing_params IS 'Tax closing additional params';


--
-- Name: CONSTRAINT mail_activity_check_res_id_is_set ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_res_id_is_set ON public.mail_activity IS 'CHECK(res_id IS NOT NULL AND res_id !=0 )';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_id_seq OWNER TO runbot;

--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan (
    id integer NOT NULL,
    company_id integer,
    res_model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan IS 'Activity Plan';


--
-- Name: COLUMN mail_activity_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.company_id IS 'Company';


--
-- Name: COLUMN mail_activity_plan.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.name IS 'Name';


--
-- Name: COLUMN mail_activity_plan.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.active IS 'Active';


--
-- Name: COLUMN mail_activity_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_id_seq OWNED BY public.mail_activity_plan.id;


--
-- Name: mail_activity_plan_mail_activity_schedule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_mail_activity_schedule_rel (
    mail_activity_schedule_id integer NOT NULL,
    mail_activity_plan_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_mail_activity_schedule_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_mail_activity_schedule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_mail_activity_schedule_rel IS 'RELATION BETWEEN mail_activity_schedule AND mail_activity_plan';


--
-- Name: mail_activity_plan_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    sequence integer,
    activity_type_id integer NOT NULL,
    delay_count integer,
    responsible_id integer,
    create_uid integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    summary character varying,
    responsible_type character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan_template OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template IS 'Activity plan template';


--
-- Name: COLUMN mail_activity_plan_template.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_plan_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_plan_template.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_plan_template.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_count IS 'Interval';


--
-- Name: COLUMN mail_activity_plan_template.responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_plan_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan_template.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_plan_template.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_from IS 'Trigger';


--
-- Name: COLUMN mail_activity_plan_template.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_plan_template.responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_type IS 'Assignment';


--
-- Name: COLUMN mail_activity_plan_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.note IS 'Note';


--
-- Name: COLUMN mail_activity_plan_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNED BY public.mail_activity_plan_template.id;


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


ALTER TABLE public.mail_activity_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule (
    id integer NOT NULL,
    res_model_id integer NOT NULL,
    plan_id integer,
    plan_on_demand_user_id integer,
    activity_type_id integer,
    activity_user_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    summary character varying,
    plan_date date,
    date_deadline date,
    res_ids text,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule IS 'Activity schedule plan Wizard';


--
-- Name: COLUMN mail_activity_schedule.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_schedule.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_schedule.plan_on_demand_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_on_demand_user_id IS 'Assigned To';


--
-- Name: COLUMN mail_activity_schedule.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_schedule.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_schedule.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_schedule.plan_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_date IS 'Plan Date';


--
-- Name: COLUMN mail_activity_schedule.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity_schedule.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_ids IS 'Document IDs';


--
-- Name: COLUMN mail_activity_schedule.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.note IS 'Note';


--
-- Name: COLUMN mail_activity_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNED BY public.mail_activity_schedule.id;


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    delay_count integer,
    triggered_next_type_id integer,
    default_user_id integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model character varying,
    chaining_type character varying NOT NULL,
    category character varying,
    name jsonb NOT NULL,
    summary jsonb,
    default_note jsonb,
    active boolean,
    keep_done boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_type OWNER TO runbot;

--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Schedule';


--
-- Name: COLUMN mail_activity_type.triggered_next_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.triggered_next_type_id IS 'Trigger';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_type.chaining_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.chaining_type IS 'Chaining Type';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.default_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_note IS 'Default Note';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.keep_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.keep_done IS 'Keep Done';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_type_id_seq OWNER TO runbot;

--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_activity_type_mail_template_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_domain_id integer,
    alias_model_id integer NOT NULL,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    create_uid integer,
    write_uid integer,
    alias_name character varying,
    alias_full_name character varying,
    alias_contact character varying NOT NULL,
    alias_status character varying,
    alias_bounced_content jsonb,
    alias_defaults text NOT NULL,
    alias_incoming_local boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias OWNER TO runbot;

--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_full_name IS 'Alias Email';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_status IS 'Alias Status';


--
-- Name: COLUMN mail_alias.alias_bounced_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_bounced_content IS 'Custom Bounced Message';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_incoming_local; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_incoming_local IS 'Local-part based incoming detection';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias_domain (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bounce_alias character varying NOT NULL,
    catchall_alias character varying NOT NULL,
    default_from character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias_domain OWNER TO runbot;

--
-- Name: TABLE mail_alias_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias_domain IS 'Email Domain';


--
-- Name: COLUMN mail_alias_domain.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.sequence IS 'Sequence';


--
-- Name: COLUMN mail_alias_domain.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias_domain.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias_domain.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.name IS 'Name';


--
-- Name: COLUMN mail_alias_domain.bounce_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.bounce_alias IS 'Bounce Alias';


--
-- Name: COLUMN mail_alias_domain.catchall_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.catchall_alias IS 'Catchall Alias';


--
-- Name: COLUMN mail_alias_domain.default_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.default_from IS 'Default From Alias';


--
-- Name: COLUMN mail_alias_domain.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias_domain.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_domain_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_domain_id_seq OWNER TO runbot;

--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_domain_id_seq OWNED BY public.mail_alias_domain.id;


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_id_seq OWNER TO runbot;

--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist OWNER TO runbot;

--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE mail_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist_remove IS 'Remove email from blacklist wizard';


--
-- Name: COLUMN mail_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist_remove.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.email IS 'Email';


--
-- Name: COLUMN mail_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN mail_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNED BY public.mail_blacklist_remove.id;


--
-- Name: mail_canned_response; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source character varying NOT NULL,
    description character varying,
    substitution text NOT NULL,
    is_shared boolean,
    last_used timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_canned_response OWNER TO runbot;

--
-- Name: TABLE mail_canned_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response IS 'Canned Response';


--
-- Name: COLUMN mail_canned_response.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_uid IS 'Created by';


--
-- Name: COLUMN mail_canned_response.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_canned_response.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.source IS 'Shortcut';


--
-- Name: COLUMN mail_canned_response.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.description IS 'Description';


--
-- Name: COLUMN mail_canned_response.substitution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.substitution IS 'Substitution';


--
-- Name: COLUMN mail_canned_response.is_shared; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.is_shared IS 'Determines if the canned_response is currently shared with other users';


--
-- Name: COLUMN mail_canned_response.last_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.last_used IS 'Last Used';


--
-- Name: COLUMN mail_canned_response.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_date IS 'Created on';


--
-- Name: COLUMN mail_canned_response.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_date IS 'Last Updated on';


--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_canned_response_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_canned_response_id_seq OWNER TO runbot;

--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_canned_response_id_seq OWNED BY public.mail_canned_response.id;


--
-- Name: mail_canned_response_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response_res_groups_rel (
    mail_canned_response_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.mail_canned_response_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE mail_canned_response_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response_res_groups_rel IS 'RELATION BETWEEN mail_canned_response AND res_groups';


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    template_id integer,
    parent_id integer,
    author_id integer,
    res_domain_user_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    email_layout_xmlid character varying,
    email_from character varying,
    composition_mode character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    reply_to character varying,
    scheduled_date character varying,
    template_name character varying,
    body text,
    res_ids text,
    res_domain text,
    email_add_signature boolean,
    reply_to_force_new boolean,
    auto_delete boolean,
    auto_delete_keep_log boolean,
    force_send boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_compose_message OWNER TO runbot;

--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.res_domain_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain_user_id IS 'Responsible';


--
-- Name: COLUMN mail_compose_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_compose_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.lang IS 'Language';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_name IS 'Record Name';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_compose_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_compose_message.template_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_name IS 'Template Name';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_compose_message.res_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_add_signature IS 'Add signature';


--
-- Name: COLUMN mail_compose_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to_force_new IS 'Considers answers as new thread';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_keep_log IS 'Keep Message Copy';


--
-- Name: COLUMN mail_compose_message.force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.force_send IS 'Send mailing or notifications directly';


--
-- Name: COLUMN mail_compose_message.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.use_exclusion_list IS 'Check Exclusion List';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_compose_message_id_seq OWNER TO runbot;

--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_id integer,
    partner_id integer NOT NULL,
    res_model character varying NOT NULL
);


ALTER TABLE public.mail_followers OWNER TO runbot;

--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_id_seq OWNER TO runbot;

--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_followers_mail_message_subtype_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_gateway_allowed; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_gateway_allowed (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    email_normalized character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_gateway_allowed OWNER TO runbot;

--
-- Name: TABLE mail_gateway_allowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_gateway_allowed IS 'Mail Gateway Allowed';


--
-- Name: COLUMN mail_gateway_allowed.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_uid IS 'Created by';


--
-- Name: COLUMN mail_gateway_allowed.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_gateway_allowed.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email IS 'Email Address';


--
-- Name: COLUMN mail_gateway_allowed.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN mail_gateway_allowed.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_date IS 'Created on';


--
-- Name: COLUMN mail_gateway_allowed.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_date IS 'Last Updated on';


--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_gateway_allowed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNER TO runbot;

--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNED BY public.mail_gateway_allowed.id;


--
-- Name: mail_guest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_guest (
    id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    access_token character varying NOT NULL,
    lang character varying,
    timezone character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_guest OWNER TO runbot;

--
-- Name: TABLE mail_guest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_guest IS 'Guest';


--
-- Name: COLUMN mail_guest.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.country_id IS 'Country';


--
-- Name: COLUMN mail_guest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_uid IS 'Created by';


--
-- Name: COLUMN mail_guest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_guest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.name IS 'Name';


--
-- Name: COLUMN mail_guest.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.access_token IS 'Access Token';


--
-- Name: COLUMN mail_guest.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.lang IS 'Language';


--
-- Name: COLUMN mail_guest.timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.timezone IS 'Timezone';


--
-- Name: COLUMN mail_guest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_date IS 'Created on';


--
-- Name: COLUMN mail_guest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_date IS 'Last Updated on';


--
-- Name: mail_guest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_guest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_guest_id_seq OWNER TO runbot;

--
-- Name: mail_guest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_guest_id_seq OWNED BY public.mail_guest.id;


--
-- Name: mail_ice_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_ice_server (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_type character varying NOT NULL,
    uri character varying NOT NULL,
    username character varying,
    credential character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_ice_server OWNER TO runbot;

--
-- Name: TABLE mail_ice_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_ice_server IS 'ICE server';


--
-- Name: COLUMN mail_ice_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_uid IS 'Created by';


--
-- Name: COLUMN mail_ice_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_ice_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.server_type IS 'Type';


--
-- Name: COLUMN mail_ice_server.uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.uri IS 'URI';


--
-- Name: COLUMN mail_ice_server.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.username IS 'Username';


--
-- Name: COLUMN mail_ice_server.credential; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.credential IS 'Credential';


--
-- Name: COLUMN mail_ice_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_date IS 'Created on';


--
-- Name: COLUMN mail_ice_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_date IS 'Last Updated on';


--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_ice_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_ice_server_id_seq OWNER TO runbot;

--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_ice_server_id_seq OWNED BY public.mail_ice_server.id;


--
-- Name: mail_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_link_preview (
    id integer NOT NULL,
    message_id integer,
    create_uid integer,
    write_uid integer,
    source_url character varying NOT NULL,
    og_type character varying,
    og_title character varying,
    og_site_name character varying,
    og_image character varying,
    og_mimetype character varying,
    image_mimetype character varying,
    og_description text,
    is_hidden boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_link_preview IS 'Store link preview data';


--
-- Name: COLUMN mail_link_preview.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.message_id IS 'Message';


--
-- Name: COLUMN mail_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_link_preview.source_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.source_url IS 'URL';


--
-- Name: COLUMN mail_link_preview.og_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_type IS 'Type';


--
-- Name: COLUMN mail_link_preview.og_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_title IS 'Title';


--
-- Name: COLUMN mail_link_preview.og_site_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_site_name IS 'Site name';


--
-- Name: COLUMN mail_link_preview.og_image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_image IS 'Image';


--
-- Name: COLUMN mail_link_preview.og_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_mimetype IS 'MIME type';


--
-- Name: COLUMN mail_link_preview.image_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.image_mimetype IS 'Image MIME type';


--
-- Name: COLUMN mail_link_preview.og_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_description IS 'Description';


--
-- Name: COLUMN mail_link_preview.is_hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.is_hidden IS 'Is Hidden';


--
-- Name: COLUMN mail_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_date IS 'Create Date';


--
-- Name: COLUMN mail_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_link_preview_id_seq OWNED BY public.mail_link_preview.id;


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    fetchmail_server_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    state character varying,
    failure_type character varying,
    body_html text,
    "references" text,
    headers text,
    email_to text,
    failure_reason text,
    is_notification boolean,
    auto_delete boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_mail OWNER TO runbot;

--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.is_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.is_notification IS 'Notification Email';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_mail_id_seq OWNER TO runbot;

--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_mail_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    record_name character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    pinned_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.record_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_name IS 'Message Record Name';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.pinned_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.pinned_at IS 'Pinned';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_id_seq OWNER TO runbot;

--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_reaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_reaction (
    id integer NOT NULL,
    message_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    content character varying NOT NULL,
    CONSTRAINT mail_message_reaction_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_message_reaction OWNER TO runbot;

--
-- Name: TABLE mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_reaction IS 'Message Reaction';


--
-- Name: COLUMN mail_message_reaction.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.message_id IS 'Message';


--
-- Name: COLUMN mail_message_reaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.partner_id IS 'Reacting Partner';


--
-- Name: COLUMN mail_message_reaction.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.guest_id IS 'Reacting Guest';


--
-- Name: COLUMN mail_message_reaction.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.content IS 'Content';


--
-- Name: CONSTRAINT mail_message_reaction_partner_or_guest_exists ON mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_message_reaction_partner_or_guest_exists ON public.mail_message_reaction IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_reaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_reaction_id_seq OWNER TO runbot;

--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_reaction_id_seq OWNED BY public.mail_message_reaction.id;


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_starred_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_schedule (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    notification_parameters text,
    scheduled_datetime timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_schedule OWNER TO runbot;

--
-- Name: TABLE mail_message_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_schedule IS 'Scheduled Messages';


--
-- Name: COLUMN mail_message_schedule.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_message_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_schedule.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.notification_parameters IS 'Notification Parameter';


--
-- Name: COLUMN mail_message_schedule.scheduled_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.scheduled_datetime IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_message_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_schedule_id_seq OWNED BY public.mail_message_schedule.id;


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    parent_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    relation_field character varying,
    res_model character varying,
    name jsonb NOT NULL,
    description jsonb,
    internal boolean,
    "default" boolean,
    hidden boolean,
    track_recipients boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_subtype OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.track_recipients; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.track_recipients IS 'Track Recipients';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_subtype_id_seq OWNER TO runbot;

--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_message_translation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_translation (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_lang character varying NOT NULL,
    target_lang character varying NOT NULL,
    body text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_translation OWNER TO runbot;

--
-- Name: TABLE mail_message_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_translation IS 'Message Translation';


--
-- Name: COLUMN mail_message_translation.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.message_id IS 'Message';


--
-- Name: COLUMN mail_message_translation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_translation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_translation.source_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.source_lang IS 'Source Language';


--
-- Name: COLUMN mail_message_translation.target_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.target_lang IS 'Target Language';


--
-- Name: COLUMN mail_message_translation.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.body IS 'Translation Body';


--
-- Name: COLUMN mail_message_translation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_date IS 'Create Date';


--
-- Name: COLUMN mail_message_translation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_date IS 'Last Updated on';


--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_translation_id_seq OWNER TO runbot;

--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_translation_id_seq OWNED BY public.mail_message_translation.id;


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification (
    id integer NOT NULL,
    author_id integer,
    mail_message_id integer NOT NULL,
    mail_mail_id integer,
    res_partner_id integer,
    notification_type character varying NOT NULL,
    notification_status character varying,
    failure_type character varying,
    failure_reason text,
    is_read boolean,
    read_date timestamp without time zone,
    sms_id_int integer,
    sms_number character varying,
    letter_id integer,
    CONSTRAINT mail_notification_notification_partner_required CHECK ((((notification_type)::text <> ALL ((ARRAY['email'::character varying, 'inbox'::character varying])::text[])) OR (res_partner_id IS NOT NULL)))
);


ALTER TABLE public.mail_notification OWNER TO runbot;

--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification IS 'Message Notifications';


--
-- Name: COLUMN mail_notification.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.author_id IS 'Author';


--
-- Name: COLUMN mail_notification.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_notification.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mail_notification.res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.res_partner_id IS 'Recipient';


--
-- Name: COLUMN mail_notification.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_notification.notification_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_status IS 'Status';


--
-- Name: COLUMN mail_notification.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_notification.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.is_read IS 'Is Read';


--
-- Name: COLUMN mail_notification.read_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.read_date IS 'Read Date';


--
-- Name: COLUMN mail_notification.sms_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_id_int IS 'SMS ID';


--
-- Name: COLUMN mail_notification.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_number IS 'SMS Number';


--
-- Name: COLUMN mail_notification.letter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.letter_id IS 'Snailmail Letter';


--
-- Name: CONSTRAINT mail_notification_notification_partner_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_required ON public.mail_notification IS 'CHECK(notification_type NOT IN (''email'', ''inbox'') OR res_partner_id IS NOT NULL)';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_notification_id_seq OWNER TO runbot;

--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_notification_id_seq OWNED BY public.mail_notification.id;


--
-- Name: mail_notification_mail_resend_message_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification_mail_resend_message_rel (
    mail_resend_message_id integer NOT NULL,
    mail_notification_id integer NOT NULL
);


ALTER TABLE public.mail_notification_mail_resend_message_rel OWNER TO runbot;

--
-- Name: TABLE mail_notification_mail_resend_message_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification_mail_resend_message_rel IS 'RELATION BETWEEN mail_resend_message AND mail_notification';


--
-- Name: mail_push; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push (
    id integer NOT NULL,
    mail_push_device_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payload text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push OWNER TO runbot;

--
-- Name: TABLE mail_push; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push IS 'Push Notifications';


--
-- Name: COLUMN mail_push.mail_push_device_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.mail_push_device_id IS 'devices';


--
-- Name: COLUMN mail_push.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push.payload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.payload IS 'Payload';


--
-- Name: COLUMN mail_push.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_date IS 'Created on';


--
-- Name: COLUMN mail_push.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_date IS 'Last Updated on';


--
-- Name: mail_push_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push_device (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    endpoint character varying NOT NULL,
    keys character varying NOT NULL,
    expiration_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push_device OWNER TO runbot;

--
-- Name: TABLE mail_push_device; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push_device IS 'Push Notification Device';


--
-- Name: COLUMN mail_push_device.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.partner_id IS 'Partner';


--
-- Name: COLUMN mail_push_device.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push_device.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push_device.endpoint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.endpoint IS 'Browser endpoint';


--
-- Name: COLUMN mail_push_device.keys; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.keys IS 'Browser keys';


--
-- Name: COLUMN mail_push_device.expiration_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.expiration_time IS 'Expiration Token Date';


--
-- Name: COLUMN mail_push_device.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_date IS 'Created on';


--
-- Name: COLUMN mail_push_device.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_date IS 'Last Updated on';


--
-- Name: mail_push_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_device_id_seq OWNER TO runbot;

--
-- Name: mail_push_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_device_id_seq OWNED BY public.mail_push_device.id;


--
-- Name: mail_push_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_id_seq OWNER TO runbot;

--
-- Name: mail_push_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_id_seq OWNED BY public.mail_push.id;


--
-- Name: mail_resend_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_message (
    id integer NOT NULL,
    mail_message_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_message OWNER TO runbot;

--
-- Name: TABLE mail_resend_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_message IS 'Email resend wizard';


--
-- Name: COLUMN mail_resend_message.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_resend_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_message.write_date IS 'Last Updated on';


--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_message_id_seq OWNER TO runbot;

--
-- Name: mail_resend_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_message_id_seq OWNED BY public.mail_resend_message.id;


--
-- Name: mail_resend_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_resend_partner (
    id integer NOT NULL,
    notification_id integer NOT NULL,
    resend_wizard_id integer,
    create_uid integer,
    write_uid integer,
    message character varying,
    resend boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_resend_partner OWNER TO runbot;

--
-- Name: TABLE mail_resend_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_resend_partner IS 'Partner with additional information for mail resend';


--
-- Name: COLUMN mail_resend_partner.notification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.notification_id IS 'Notification';


--
-- Name: COLUMN mail_resend_partner.resend_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend_wizard_id IS 'Resend wizard';


--
-- Name: COLUMN mail_resend_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_uid IS 'Created by';


--
-- Name: COLUMN mail_resend_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_resend_partner.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.message IS 'Error message';


--
-- Name: COLUMN mail_resend_partner.resend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.resend IS 'Try Again';


--
-- Name: COLUMN mail_resend_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.create_date IS 'Created on';


--
-- Name: COLUMN mail_resend_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_resend_partner.write_date IS 'Last Updated on';


--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_resend_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_resend_partner_id_seq OWNER TO runbot;

--
-- Name: mail_resend_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_resend_partner_id_seq OWNED BY public.mail_resend_partner.id;


--
-- Name: mail_scheduled_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message (
    id integer NOT NULL,
    res_id integer NOT NULL,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying NOT NULL,
    body text,
    notification_parameters text,
    is_note boolean,
    scheduled_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_scheduled_message OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message IS 'Scheduled Message';


--
-- Name: COLUMN mail_scheduled_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.res_id IS 'Related Document Id';


--
-- Name: COLUMN mail_scheduled_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.author_id IS 'Author';


--
-- Name: COLUMN mail_scheduled_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_scheduled_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_scheduled_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.subject IS 'Subject';


--
-- Name: COLUMN mail_scheduled_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_scheduled_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.body IS 'Contents';


--
-- Name: COLUMN mail_scheduled_message.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.notification_parameters IS 'Notification parameters';


--
-- Name: COLUMN mail_scheduled_message.is_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.is_note IS 'Is a note';


--
-- Name: COLUMN mail_scheduled_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_scheduled_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_scheduled_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_date IS 'Last Updated on';


--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_scheduled_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNER TO runbot;

--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNED BY public.mail_scheduled_message.id;


--
-- Name: mail_scheduled_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message_res_partner_rel (
    mail_scheduled_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_scheduled_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message_res_partner_rel IS 'RELATION BETWEEN mail_scheduled_message AND res_partner';


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    model_id integer,
    user_id integer,
    mail_server_id integer,
    ref_ir_act_window integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    email_from character varying,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    scheduled_date character varying,
    name jsonb,
    description jsonb,
    subject jsonb,
    body_html jsonb,
    active boolean,
    use_default_to boolean,
    auto_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template OWNER TO runbot;

--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.user_id IS 'User';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_from IS 'From';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_template.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.description IS 'Template Description';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.active IS 'Active';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default recipients';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_id_seq OWNER TO runbot;

--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_template_ir_actions_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_ir_actions_report_rel (
    mail_template_id integer NOT NULL,
    ir_actions_report_id integer NOT NULL
);


ALTER TABLE public.mail_template_ir_actions_report_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_ir_actions_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_ir_actions_report_rel IS 'RELATION BETWEEN mail_template AND ir_act_report_xml';


--
-- Name: mail_template_mail_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_mail_template_reset_rel (
    mail_template_reset_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_template_mail_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_mail_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_mail_template_reset_rel IS 'RELATION BETWEEN mail_template_reset AND mail_template';


--
-- Name: mail_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_preview (
    id integer NOT NULL,
    mail_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    lang character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_preview OWNER TO runbot;

--
-- Name: TABLE mail_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN mail_template_preview.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.mail_template_id IS 'Related Mail Template';


--
-- Name: COLUMN mail_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.resource_ref IS 'Record';


--
-- Name: COLUMN mail_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN mail_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_date IS 'Last Updated on';


--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_preview_id_seq OWNER TO runbot;

--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_preview_id_seq OWNED BY public.mail_template_preview.id;


--
-- Name: mail_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_reset OWNER TO runbot;

--
-- Name: TABLE mail_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_reset IS 'Mail Template Reset';


--
-- Name: COLUMN mail_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_date IS 'Last Updated on';


--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_reset_id_seq OWNER TO runbot;

--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_reset_id_seq OWNED BY public.mail_template_reset.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field_id integer,
    old_value_integer integer,
    new_value_integer integer,
    currency_id integer,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    old_value_char character varying,
    new_value_char character varying,
    field_info jsonb,
    old_value_text text,
    new_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    old_value_float double precision,
    new_value_float double precision
);


ALTER TABLE public.mail_tracking_value OWNER TO runbot;

--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_id IS 'Field';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.currency_id IS 'Currency';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.field_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_info IS 'Removed field information';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_tracking_value_id_seq OWNER TO runbot;

--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: mail_wizard_invite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite (
    id integer NOT NULL,
    res_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    message text,
    notify boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_wizard_invite OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite IS 'Invite wizard';


--
-- Name: COLUMN mail_wizard_invite.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_wizard_invite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_uid IS 'Created by';


--
-- Name: COLUMN mail_wizard_invite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_wizard_invite.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_wizard_invite.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.message IS 'Message';


--
-- Name: COLUMN mail_wizard_invite.notify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.notify IS 'Notify Recipients';


--
-- Name: COLUMN mail_wizard_invite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.create_date IS 'Created on';


--
-- Name: COLUMN mail_wizard_invite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_wizard_invite.write_date IS 'Last Updated on';


--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_wizard_invite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNER TO runbot;

--
-- Name: mail_wizard_invite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_wizard_invite_id_seq OWNED BY public.mail_wizard_invite.id;


--
-- Name: mail_wizard_invite_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_wizard_invite_res_partner_rel (
    mail_wizard_invite_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_wizard_invite_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_wizard_invite_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_wizard_invite_res_partner_rel IS 'RELATION BETWEEN mail_wizard_invite AND res_partner';


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: module_access_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_access_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_model_access_id integer NOT NULL
);


ALTER TABLE public.module_access_rel OWNER TO runbot;

--
-- Name: TABLE module_access_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_access_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_model_access';


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: module_cron_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_cron_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_cron_id integer NOT NULL
);


ALTER TABLE public.module_cron_rel OWNER TO runbot;

--
-- Name: TABLE module_cron_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_cron_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_cron';


--
-- Name: module_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_field_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.module_field_rel OWNER TO runbot;

--
-- Name: TABLE module_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_field_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_model_fields';


--
-- Name: module_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_group_rel (
    saas_client_dashboard_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.module_group_rel OWNER TO runbot;

--
-- Name: TABLE module_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_group_rel IS 'RELATION BETWEEN saas_client_dashboard AND res_groups';


--
-- Name: module_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_model_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.module_model_rel OWNER TO runbot;

--
-- Name: TABLE module_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_model_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_model';


--
-- Name: module_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_report_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_act_report_xml_id integer NOT NULL
);


ALTER TABLE public.module_report_rel OWNER TO runbot;

--
-- Name: TABLE module_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_report_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_act_report_xml';


--
-- Name: module_rule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_rule_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_rule_id integer NOT NULL
);


ALTER TABLE public.module_rule_rel OWNER TO runbot;

--
-- Name: TABLE module_rule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_rule_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_rule';


--
-- Name: module_server_action_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_server_action_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.module_server_action_rel OWNER TO runbot;

--
-- Name: TABLE module_server_action_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_server_action_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_act_server';


--
-- Name: module_view_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_view_rel (
    saas_client_dashboard_id integer NOT NULL,
    ir_ui_view_id integer NOT NULL
);


ALTER TABLE public.module_view_rel OWNER TO runbot;

--
-- Name: TABLE module_view_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_view_rel IS 'RELATION BETWEEN saas_client_dashboard AND ir_ui_view';


--
-- Name: onboarding_onboarding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_onboarding (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    route_name character varying NOT NULL,
    text_completed character varying,
    panel_close_action_name character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.onboarding_onboarding OWNER TO runbot;

--
-- Name: TABLE onboarding_onboarding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_onboarding IS 'Onboarding';


--
-- Name: COLUMN onboarding_onboarding.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.sequence IS 'Sequence';


--
-- Name: COLUMN onboarding_onboarding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.create_uid IS 'Created by';


--
-- Name: COLUMN onboarding_onboarding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN onboarding_onboarding.route_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.route_name IS 'One word name';


--
-- Name: COLUMN onboarding_onboarding.text_completed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.text_completed IS 'Message at completion';


--
-- Name: COLUMN onboarding_onboarding.panel_close_action_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.panel_close_action_name IS 'Closing action';


--
-- Name: COLUMN onboarding_onboarding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.name IS 'Name of the onboarding';


--
-- Name: COLUMN onboarding_onboarding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.create_date IS 'Created on';


--
-- Name: COLUMN onboarding_onboarding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding.write_date IS 'Last Updated on';


--
-- Name: onboarding_onboarding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.onboarding_onboarding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.onboarding_onboarding_id_seq OWNER TO runbot;

--
-- Name: onboarding_onboarding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.onboarding_onboarding_id_seq OWNED BY public.onboarding_onboarding.id;


--
-- Name: onboarding_onboarding_onboarding_onboarding_step_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_onboarding_onboarding_onboarding_step_rel (
    onboarding_onboarding_id integer NOT NULL,
    onboarding_onboarding_step_id integer NOT NULL
);


ALTER TABLE public.onboarding_onboarding_onboarding_onboarding_step_rel OWNER TO runbot;

--
-- Name: TABLE onboarding_onboarding_onboarding_onboarding_step_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_onboarding_onboarding_onboarding_step_rel IS 'RELATION BETWEEN onboarding_onboarding AND onboarding_onboarding_step';


--
-- Name: onboarding_onboarding_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_onboarding_step (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    done_icon character varying,
    step_image_filename character varying,
    panel_step_open_action_name character varying,
    title jsonb,
    description jsonb,
    button_text jsonb NOT NULL,
    done_text jsonb,
    step_image_alt jsonb,
    is_per_company boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.onboarding_onboarding_step OWNER TO runbot;

--
-- Name: TABLE onboarding_onboarding_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_onboarding_step IS 'Onboarding Step';


--
-- Name: COLUMN onboarding_onboarding_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.sequence IS 'Sequence';


--
-- Name: COLUMN onboarding_onboarding_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.create_uid IS 'Created by';


--
-- Name: COLUMN onboarding_onboarding_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN onboarding_onboarding_step.done_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.done_icon IS 'Font Awesome Icon when completed';


--
-- Name: COLUMN onboarding_onboarding_step.step_image_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.step_image_filename IS 'Step Image Filename';


--
-- Name: COLUMN onboarding_onboarding_step.panel_step_open_action_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.panel_step_open_action_name IS 'Opening action';


--
-- Name: COLUMN onboarding_onboarding_step.title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.title IS 'Title';


--
-- Name: COLUMN onboarding_onboarding_step.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.description IS 'Description';


--
-- Name: COLUMN onboarding_onboarding_step.button_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.button_text IS 'Button text';


--
-- Name: COLUMN onboarding_onboarding_step.done_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.done_text IS 'Text to show when step is completed';


--
-- Name: COLUMN onboarding_onboarding_step.step_image_alt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.step_image_alt IS 'Alt Text for the Step Image';


--
-- Name: COLUMN onboarding_onboarding_step.is_per_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.is_per_company IS 'Is per company';


--
-- Name: COLUMN onboarding_onboarding_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.create_date IS 'Created on';


--
-- Name: COLUMN onboarding_onboarding_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_onboarding_step.write_date IS 'Last Updated on';


--
-- Name: onboarding_onboarding_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.onboarding_onboarding_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.onboarding_onboarding_step_id_seq OWNER TO runbot;

--
-- Name: onboarding_onboarding_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.onboarding_onboarding_step_id_seq OWNED BY public.onboarding_onboarding_step.id;


--
-- Name: onboarding_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_progress (
    id integer NOT NULL,
    company_id integer,
    onboarding_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    onboarding_state character varying,
    is_onboarding_closed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.onboarding_progress OWNER TO runbot;

--
-- Name: TABLE onboarding_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_progress IS 'Onboarding Progress Tracker';


--
-- Name: COLUMN onboarding_progress.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.company_id IS 'Company';


--
-- Name: COLUMN onboarding_progress.onboarding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.onboarding_id IS 'Related onboarding tracked';


--
-- Name: COLUMN onboarding_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.create_uid IS 'Created by';


--
-- Name: COLUMN onboarding_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN onboarding_progress.onboarding_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.onboarding_state IS 'Onboarding progress';


--
-- Name: COLUMN onboarding_progress.is_onboarding_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.is_onboarding_closed IS 'Was panel closed?';


--
-- Name: COLUMN onboarding_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.create_date IS 'Created on';


--
-- Name: COLUMN onboarding_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress.write_date IS 'Last Updated on';


--
-- Name: onboarding_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.onboarding_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.onboarding_progress_id_seq OWNER TO runbot;

--
-- Name: onboarding_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.onboarding_progress_id_seq OWNED BY public.onboarding_progress.id;


--
-- Name: onboarding_progress_onboarding_progress_step_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_progress_onboarding_progress_step_rel (
    onboarding_progress_id integer NOT NULL,
    onboarding_progress_step_id integer NOT NULL
);


ALTER TABLE public.onboarding_progress_onboarding_progress_step_rel OWNER TO runbot;

--
-- Name: TABLE onboarding_progress_onboarding_progress_step_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_progress_onboarding_progress_step_rel IS 'RELATION BETWEEN onboarding_progress AND onboarding_progress_step';


--
-- Name: onboarding_progress_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.onboarding_progress_step (
    id integer NOT NULL,
    step_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    step_state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.onboarding_progress_step OWNER TO runbot;

--
-- Name: TABLE onboarding_progress_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.onboarding_progress_step IS 'Onboarding Progress Step Tracker';


--
-- Name: COLUMN onboarding_progress_step.step_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.step_id IS 'Onboarding Step';


--
-- Name: COLUMN onboarding_progress_step.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.company_id IS 'Company';


--
-- Name: COLUMN onboarding_progress_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.create_uid IS 'Created by';


--
-- Name: COLUMN onboarding_progress_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN onboarding_progress_step.step_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.step_state IS 'Onboarding Step Progress';


--
-- Name: COLUMN onboarding_progress_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.create_date IS 'Created on';


--
-- Name: COLUMN onboarding_progress_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.onboarding_progress_step.write_date IS 'Last Updated on';


--
-- Name: onboarding_progress_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.onboarding_progress_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.onboarding_progress_step_id_seq OWNER TO runbot;

--
-- Name: onboarding_progress_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.onboarding_progress_step_id_seq OWNED BY public.onboarding_progress_step.id;


--
-- Name: partner_update_from_padron_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.partner_update_from_padron_rel (
    update_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.partner_update_from_padron_rel OWNER TO runbot;

--
-- Name: TABLE partner_update_from_padron_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.partner_update_from_padron_rel IS 'RELATION BETWEEN res_partner_update_from_padron_wizard AND res_partner';


--
-- Name: payment_capture_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_capture_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    amount_to_capture numeric,
    void_remaining_amount boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_capture_wizard OWNER TO runbot;

--
-- Name: TABLE payment_capture_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_capture_wizard IS 'Payment Capture Wizard';


--
-- Name: COLUMN payment_capture_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_capture_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_capture_wizard.amount_to_capture; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.amount_to_capture IS 'Amount To Capture';


--
-- Name: COLUMN payment_capture_wizard.void_remaining_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.void_remaining_amount IS 'Void Remaining Amount';


--
-- Name: COLUMN payment_capture_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_capture_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_capture_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_capture_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_capture_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_capture_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_capture_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_capture_wizard_id_seq OWNED BY public.payment_capture_wizard.id;


--
-- Name: payment_capture_wizard_payment_transaction_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_capture_wizard_payment_transaction_rel (
    payment_capture_wizard_id integer NOT NULL,
    payment_transaction_id integer NOT NULL
);


ALTER TABLE public.payment_capture_wizard_payment_transaction_rel OWNER TO runbot;

--
-- Name: TABLE payment_capture_wizard_payment_transaction_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_capture_wizard_payment_transaction_rel IS 'RELATION BETWEEN payment_capture_wizard AND payment_transaction';


--
-- Name: payment_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_country_rel (
    payment_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.payment_country_rel OWNER TO runbot;

--
-- Name: TABLE payment_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_country_rel IS 'RELATION BETWEEN payment_provider AND res_country';


--
-- Name: payment_currency_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_currency_rel (
    payment_provider_id integer NOT NULL,
    currency_id integer NOT NULL
);


ALTER TABLE public.payment_currency_rel OWNER TO runbot;

--
-- Name: TABLE payment_currency_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_currency_rel IS 'RELATION BETWEEN payment_provider AND res_currency';


--
-- Name: payment_link_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_link_wizard (
    id integer NOT NULL,
    res_id integer NOT NULL,
    currency_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    amount numeric NOT NULL,
    amount_max numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_date date,
    open_installments jsonb,
    has_eligible_epd boolean,
    amount_paid numeric
);


ALTER TABLE public.payment_link_wizard OWNER TO runbot;

--
-- Name: TABLE payment_link_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_link_wizard IS 'Generate Payment Link';


--
-- Name: COLUMN payment_link_wizard.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.res_id IS 'Related Document ID';


--
-- Name: COLUMN payment_link_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.currency_id IS 'Currency';


--
-- Name: COLUMN payment_link_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN payment_link_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_link_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_link_wizard.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.res_model IS 'Related Document Model';


--
-- Name: COLUMN payment_link_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.amount IS 'Amount';


--
-- Name: COLUMN payment_link_wizard.amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.amount_max IS 'Amount Max';


--
-- Name: COLUMN payment_link_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_link_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_link_wizard.discount_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.discount_date IS 'Discount Date';


--
-- Name: COLUMN payment_link_wizard.open_installments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.open_installments IS 'Open Installments';


--
-- Name: COLUMN payment_link_wizard.has_eligible_epd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.has_eligible_epd IS 'Has Eligible Epd';


--
-- Name: COLUMN payment_link_wizard.amount_paid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_link_wizard.amount_paid IS 'Already Paid';


--
-- Name: payment_link_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_link_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_link_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_link_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_link_wizard_id_seq OWNED BY public.payment_link_wizard.id;


--
-- Name: payment_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_method (
    id integer NOT NULL,
    sequence integer,
    primary_payment_method_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    support_refund character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    support_tokenization boolean,
    support_express_checkout boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_method OWNER TO runbot;

--
-- Name: TABLE payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_method IS 'Payment Method';


--
-- Name: COLUMN payment_method.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.sequence IS 'Sequence';


--
-- Name: COLUMN payment_method.primary_payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.primary_payment_method_id IS 'Primary Payment Method';


--
-- Name: COLUMN payment_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN payment_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_method.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.code IS 'Code';


--
-- Name: COLUMN payment_method.support_refund; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.support_refund IS 'Refund';


--
-- Name: COLUMN payment_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.name IS 'Name';


--
-- Name: COLUMN payment_method.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.active IS 'Active';


--
-- Name: COLUMN payment_method.support_tokenization; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.support_tokenization IS 'Tokenization';


--
-- Name: COLUMN payment_method.support_express_checkout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.support_express_checkout IS 'Express Checkout';


--
-- Name: COLUMN payment_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.create_date IS 'Created on';


--
-- Name: COLUMN payment_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_method.write_date IS 'Last Updated on';


--
-- Name: payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_method_id_seq OWNER TO runbot;

--
-- Name: payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_method_id_seq OWNED BY public.payment_method.id;


--
-- Name: payment_method_payment_provider_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_method_payment_provider_rel (
    payment_method_id integer NOT NULL,
    payment_provider_id integer NOT NULL
);


ALTER TABLE public.payment_method_payment_provider_rel OWNER TO runbot;

--
-- Name: TABLE payment_method_payment_provider_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_method_payment_provider_rel IS 'RELATION BETWEEN payment_method AND payment_provider';


--
-- Name: payment_method_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_method_res_country_rel (
    payment_method_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.payment_method_res_country_rel OWNER TO runbot;

--
-- Name: TABLE payment_method_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_method_res_country_rel IS 'RELATION BETWEEN payment_method AND res_country';


--
-- Name: payment_method_res_currency_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_method_res_currency_rel (
    payment_method_id integer NOT NULL,
    res_currency_id integer NOT NULL
);


ALTER TABLE public.payment_method_res_currency_rel OWNER TO runbot;

--
-- Name: TABLE payment_method_res_currency_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_method_res_currency_rel IS 'RELATION BETWEEN payment_method AND res_currency';


--
-- Name: payment_provider; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_provider (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    redirect_form_view_id integer,
    inline_form_view_id integer,
    token_inline_form_view_id integer,
    express_checkout_form_view_id integer,
    color integer,
    module_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    state character varying NOT NULL,
    name jsonb NOT NULL,
    pre_msg jsonb,
    pending_msg jsonb,
    auth_msg jsonb,
    done_msg jsonb,
    cancel_msg jsonb,
    maximum_amount numeric,
    is_published boolean,
    allow_tokenization boolean,
    capture_manually boolean,
    allow_express_checkout boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    so_reference_type character varying
);


ALTER TABLE public.payment_provider OWNER TO runbot;

--
-- Name: TABLE payment_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_provider IS 'Payment Provider';


--
-- Name: COLUMN payment_provider.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.sequence IS 'Sequence';


--
-- Name: COLUMN payment_provider.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.company_id IS 'Company';


--
-- Name: COLUMN payment_provider.redirect_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.redirect_form_view_id IS 'Redirect Form Template';


--
-- Name: COLUMN payment_provider.inline_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.inline_form_view_id IS 'Inline Form Template';


--
-- Name: COLUMN payment_provider.token_inline_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.token_inline_form_view_id IS 'Token Inline Form Template';


--
-- Name: COLUMN payment_provider.express_checkout_form_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.express_checkout_form_view_id IS 'Express Checkout Form Template';


--
-- Name: COLUMN payment_provider.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.color IS 'Color';


--
-- Name: COLUMN payment_provider.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.module_id IS 'Corresponding Module';


--
-- Name: COLUMN payment_provider.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.create_uid IS 'Created by';


--
-- Name: COLUMN payment_provider.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_provider.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.code IS 'Code';


--
-- Name: COLUMN payment_provider.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.state IS 'State';


--
-- Name: COLUMN payment_provider.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.name IS 'Name';


--
-- Name: COLUMN payment_provider.pre_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.pre_msg IS 'Help Message';


--
-- Name: COLUMN payment_provider.pending_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.pending_msg IS 'Pending Message';


--
-- Name: COLUMN payment_provider.auth_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.auth_msg IS 'Authorize Message';


--
-- Name: COLUMN payment_provider.done_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.done_msg IS 'Done Message';


--
-- Name: COLUMN payment_provider.cancel_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.cancel_msg IS 'Cancelled Message';


--
-- Name: COLUMN payment_provider.maximum_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.maximum_amount IS 'Maximum Amount';


--
-- Name: COLUMN payment_provider.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.is_published IS 'Published';


--
-- Name: COLUMN payment_provider.allow_tokenization; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.allow_tokenization IS 'Allow Saving Payment Methods';


--
-- Name: COLUMN payment_provider.capture_manually; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.capture_manually IS 'Capture Amount Manually';


--
-- Name: COLUMN payment_provider.allow_express_checkout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.allow_express_checkout IS 'Allow Express Checkout';


--
-- Name: COLUMN payment_provider.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.create_date IS 'Created on';


--
-- Name: COLUMN payment_provider.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_provider.so_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider.so_reference_type IS 'Communication';


--
-- Name: payment_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_provider_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_provider_id_seq OWNER TO runbot;

--
-- Name: payment_provider_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_provider_id_seq OWNED BY public.payment_provider.id;


--
-- Name: payment_provider_onboarding_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_provider_onboarding_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_method character varying,
    paypal_email_account character varying,
    manual_name character varying,
    journal_name character varying,
    acc_number character varying,
    manual_post_msg text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_provider_onboarding_wizard OWNER TO runbot;

--
-- Name: TABLE payment_provider_onboarding_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_provider_onboarding_wizard IS 'Payment provider onboarding wizard';


--
-- Name: COLUMN payment_provider_onboarding_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_provider_onboarding_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_provider_onboarding_wizard.payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.payment_method IS 'Payment Method';


--
-- Name: COLUMN payment_provider_onboarding_wizard.paypal_email_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.paypal_email_account IS 'Email';


--
-- Name: COLUMN payment_provider_onboarding_wizard.manual_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.manual_name IS 'Method';


--
-- Name: COLUMN payment_provider_onboarding_wizard.journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.journal_name IS 'Bank Name';


--
-- Name: COLUMN payment_provider_onboarding_wizard.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.acc_number IS 'Account Number';


--
-- Name: COLUMN payment_provider_onboarding_wizard.manual_post_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.manual_post_msg IS 'Payment Instructions';


--
-- Name: COLUMN payment_provider_onboarding_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_provider_onboarding_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_provider_onboarding_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_provider_onboarding_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_provider_onboarding_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_provider_onboarding_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_provider_onboarding_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_provider_onboarding_wizard_id_seq OWNED BY public.payment_provider_onboarding_wizard.id;


--
-- Name: payment_refund_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_refund_wizard (
    id integer NOT NULL,
    payment_id integer,
    create_uid integer,
    write_uid integer,
    amount_to_refund numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_refund_wizard OWNER TO runbot;

--
-- Name: TABLE payment_refund_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_refund_wizard IS 'Payment Refund Wizard';


--
-- Name: COLUMN payment_refund_wizard.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.payment_id IS 'Payment';


--
-- Name: COLUMN payment_refund_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN payment_refund_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_refund_wizard.amount_to_refund; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.amount_to_refund IS 'Refund Amount';


--
-- Name: COLUMN payment_refund_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.create_date IS 'Created on';


--
-- Name: COLUMN payment_refund_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_refund_wizard.write_date IS 'Last Updated on';


--
-- Name: payment_refund_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_refund_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_refund_wizard_id_seq OWNER TO runbot;

--
-- Name: payment_refund_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_refund_wizard_id_seq OWNED BY public.payment_refund_wizard.id;


--
-- Name: payment_token; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_token (
    id integer NOT NULL,
    provider_id integer NOT NULL,
    company_id integer,
    payment_method_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_details character varying,
    provider_ref character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.payment_token OWNER TO runbot;

--
-- Name: TABLE payment_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_token IS 'Payment Token';


--
-- Name: COLUMN payment_token.provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.provider_id IS 'Provider';


--
-- Name: COLUMN payment_token.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.company_id IS 'Company';


--
-- Name: COLUMN payment_token.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN payment_token.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.partner_id IS 'Partner';


--
-- Name: COLUMN payment_token.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.create_uid IS 'Created by';


--
-- Name: COLUMN payment_token.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_token.payment_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.payment_details IS 'Payment Details';


--
-- Name: COLUMN payment_token.provider_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.provider_ref IS 'Provider Reference';


--
-- Name: COLUMN payment_token.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.active IS 'Active';


--
-- Name: COLUMN payment_token.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.create_date IS 'Created on';


--
-- Name: COLUMN payment_token.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_token.write_date IS 'Last Updated on';


--
-- Name: payment_token_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_token_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_token_id_seq OWNER TO runbot;

--
-- Name: payment_token_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_token_id_seq OWNED BY public.payment_token.id;


--
-- Name: payment_transaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.payment_transaction (
    id integer NOT NULL,
    provider_id integer NOT NULL,
    company_id integer,
    payment_method_id integer NOT NULL,
    currency_id integer NOT NULL,
    token_id integer,
    source_transaction_id integer,
    partner_id integer NOT NULL,
    partner_state_id integer,
    partner_country_id integer,
    create_uid integer,
    write_uid integer,
    reference character varying NOT NULL,
    provider_reference character varying,
    state character varying NOT NULL,
    operation character varying,
    landing_route character varying,
    partner_name character varying,
    partner_lang character varying,
    partner_email character varying,
    partner_address character varying,
    partner_zip character varying,
    partner_city character varying,
    partner_phone character varying,
    state_message text,
    amount numeric NOT NULL,
    is_post_processed boolean,
    tokenize boolean,
    last_state_change timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_id integer
);


ALTER TABLE public.payment_transaction OWNER TO runbot;

--
-- Name: TABLE payment_transaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.payment_transaction IS 'Payment Transaction';


--
-- Name: COLUMN payment_transaction.provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.provider_id IS 'Provider';


--
-- Name: COLUMN payment_transaction.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.company_id IS 'Company';


--
-- Name: COLUMN payment_transaction.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN payment_transaction.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.currency_id IS 'Currency';


--
-- Name: COLUMN payment_transaction.token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.token_id IS 'Payment Token';


--
-- Name: COLUMN payment_transaction.source_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.source_transaction_id IS 'Source Transaction';


--
-- Name: COLUMN payment_transaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_id IS 'Customer';


--
-- Name: COLUMN payment_transaction.partner_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_state_id IS 'State';


--
-- Name: COLUMN payment_transaction.partner_country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_country_id IS 'Country';


--
-- Name: COLUMN payment_transaction.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.create_uid IS 'Created by';


--
-- Name: COLUMN payment_transaction.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.write_uid IS 'Last Updated by';


--
-- Name: COLUMN payment_transaction.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.reference IS 'Reference';


--
-- Name: COLUMN payment_transaction.provider_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.provider_reference IS 'Provider Reference';


--
-- Name: COLUMN payment_transaction.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.state IS 'Status';


--
-- Name: COLUMN payment_transaction.operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.operation IS 'Operation';


--
-- Name: COLUMN payment_transaction.landing_route; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.landing_route IS 'Landing Route';


--
-- Name: COLUMN payment_transaction.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_name IS 'Partner Name';


--
-- Name: COLUMN payment_transaction.partner_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_lang IS 'Language';


--
-- Name: COLUMN payment_transaction.partner_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_email IS 'Email';


--
-- Name: COLUMN payment_transaction.partner_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_address IS 'Address';


--
-- Name: COLUMN payment_transaction.partner_zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_zip IS 'Zip';


--
-- Name: COLUMN payment_transaction.partner_city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_city IS 'City';


--
-- Name: COLUMN payment_transaction.partner_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.partner_phone IS 'Phone';


--
-- Name: COLUMN payment_transaction.state_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.state_message IS 'Message';


--
-- Name: COLUMN payment_transaction.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.amount IS 'Amount';


--
-- Name: COLUMN payment_transaction.is_post_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.is_post_processed IS 'Is Post-processed';


--
-- Name: COLUMN payment_transaction.tokenize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.tokenize IS 'Create Token';


--
-- Name: COLUMN payment_transaction.last_state_change; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.last_state_change IS 'Last State Change Date';


--
-- Name: COLUMN payment_transaction.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.create_date IS 'Created on';


--
-- Name: COLUMN payment_transaction.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.write_date IS 'Last Updated on';


--
-- Name: COLUMN payment_transaction.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.payment_transaction.payment_id IS 'Payment';


--
-- Name: payment_transaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.payment_transaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.payment_transaction_id_seq OWNER TO runbot;

--
-- Name: payment_transaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.payment_transaction_id_seq OWNED BY public.payment_transaction.id;


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    number character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist OWNER TO runbot;

--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: phone_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE phone_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist_remove IS 'Remove phone from blacklist';


--
-- Name: COLUMN phone_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist_remove.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.phone IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN phone_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNED BY public.phone_blacklist_remove.id;


--
-- Name: portal_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share (
    id integer NOT NULL,
    res_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_share OWNER TO runbot;

--
-- Name: TABLE portal_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share IS 'Portal Sharing';


--
-- Name: COLUMN portal_share.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_id IS 'Related Document ID';


--
-- Name: COLUMN portal_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_uid IS 'Created by';


--
-- Name: COLUMN portal_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_share.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.res_model IS 'Related Document Model';


--
-- Name: COLUMN portal_share.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.note IS 'Note';


--
-- Name: COLUMN portal_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.create_date IS 'Created on';


--
-- Name: COLUMN portal_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_share.write_date IS 'Last Updated on';


--
-- Name: portal_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_share_id_seq OWNER TO runbot;

--
-- Name: portal_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_share_id_seq OWNED BY public.portal_share.id;


--
-- Name: portal_share_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_share_res_partner_rel (
    portal_share_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_share_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_share_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_share_res_partner_rel IS 'RELATION BETWEEN portal_share AND res_partner';


--
-- Name: portal_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    welcome_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard OWNER TO runbot;

--
-- Name: TABLE portal_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard IS 'Grant Portal Access';


--
-- Name: COLUMN portal_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard.welcome_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.welcome_message IS 'Invitation Message';


--
-- Name: COLUMN portal_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_id_seq OWNED BY public.portal_wizard.id;


--
-- Name: portal_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_res_partner_rel (
    portal_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.portal_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE portal_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_res_partner_rel IS 'RELATION BETWEEN portal_wizard AND res_partner';


--
-- Name: portal_wizard_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.portal_wizard_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.portal_wizard_user OWNER TO runbot;

--
-- Name: TABLE portal_wizard_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.portal_wizard_user IS 'Portal User Config';


--
-- Name: COLUMN portal_wizard_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN portal_wizard_user.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.partner_id IS 'Contact';


--
-- Name: COLUMN portal_wizard_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_uid IS 'Created by';


--
-- Name: COLUMN portal_wizard_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN portal_wizard_user.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.email IS 'Email';


--
-- Name: COLUMN portal_wizard_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.create_date IS 'Created on';


--
-- Name: COLUMN portal_wizard_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.portal_wizard_user.write_date IS 'Last Updated on';


--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.portal_wizard_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.portal_wizard_user_id_seq OWNER TO runbot;

--
-- Name: portal_wizard_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.portal_wizard_user_id_seq OWNED BY public.portal_wizard_user.id;


--
-- Name: privacy_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    anonymized_name character varying NOT NULL,
    anonymized_email character varying NOT NULL,
    execution_details text,
    records_description text,
    additional_note text,
    date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_log OWNER TO runbot;

--
-- Name: TABLE privacy_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_log IS 'Privacy Log';


--
-- Name: COLUMN privacy_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.user_id IS 'Handled By';


--
-- Name: COLUMN privacy_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_log.anonymized_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_name IS 'Anonymized Name';


--
-- Name: COLUMN privacy_log.anonymized_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_email IS 'Anonymized Email';


--
-- Name: COLUMN privacy_log.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_log.records_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.records_description IS 'Found Records';


--
-- Name: COLUMN privacy_log.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.additional_note IS 'Additional Note';


--
-- Name: COLUMN privacy_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.date IS 'Date';


--
-- Name: COLUMN privacy_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_date IS 'Created on';


--
-- Name: COLUMN privacy_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_date IS 'Last Updated on';


--
-- Name: privacy_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_log_id_seq OWNER TO runbot;

--
-- Name: privacy_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_log_id_seq OWNED BY public.privacy_log.id;


--
-- Name: privacy_lookup_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard (
    id integer NOT NULL,
    log_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    email character varying NOT NULL,
    execution_details text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard IS 'Privacy Lookup Wizard';


--
-- Name: COLUMN privacy_lookup_wizard.log_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.log_id IS 'Log';


--
-- Name: COLUMN privacy_lookup_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.name IS 'Name';


--
-- Name: COLUMN privacy_lookup_wizard.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.email IS 'Email';


--
-- Name: COLUMN privacy_lookup_wizard.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNED BY public.privacy_lookup_wizard.id;


--
-- Name: privacy_lookup_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard_line (
    id integer NOT NULL,
    wizard_id integer,
    res_id integer NOT NULL,
    res_model_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    execution_details character varying,
    has_active boolean,
    is_active boolean,
    is_unlinked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard_line OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard_line IS 'Privacy Lookup Wizard Line';


--
-- Name: COLUMN privacy_lookup_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_id IS 'Resource ID';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_name IS 'Resource name';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model IS 'Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard_line.has_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.has_active IS 'Has Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_active IS 'Is Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_unlinked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_unlinked IS 'Is Unlinked';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNED BY public.privacy_lookup_wizard_line.id;


--
-- Name: product_attr_exclusion_value_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attr_exclusion_value_ids_rel (
    product_template_attribute_exclusion_id integer NOT NULL,
    product_template_attribute_value_id integer NOT NULL
);


ALTER TABLE public.product_attr_exclusion_value_ids_rel OWNER TO runbot;

--
-- Name: TABLE product_attr_exclusion_value_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attr_exclusion_value_ids_rel IS 'RELATION BETWEEN product_template_attribute_exclusion AND product_template_attribute_value';


--
-- Name: product_attribute; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    create_variant character varying NOT NULL,
    display_type character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT product_attribute_check_multi_checkbox_no_variant CHECK ((((display_type)::text <> 'multi'::text) OR ((create_variant)::text = 'no_variant'::text)))
);


ALTER TABLE public.product_attribute OWNER TO runbot;

--
-- Name: TABLE product_attribute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute IS 'Product Attribute';


--
-- Name: COLUMN product_attribute.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.sequence IS 'Sequence';


--
-- Name: COLUMN product_attribute.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute.create_variant; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_variant IS 'Variant Creation';


--
-- Name: COLUMN product_attribute.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.display_type IS 'Display Type';


--
-- Name: COLUMN product_attribute.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.name IS 'Attribute';


--
-- Name: COLUMN product_attribute.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.active IS 'Active';


--
-- Name: COLUMN product_attribute.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT product_attribute_check_multi_checkbox_no_variant ON product_attribute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT product_attribute_check_multi_checkbox_no_variant ON public.product_attribute IS 'CHECK(display_type != ''multi'' OR create_variant = ''no_variant'')';


--
-- Name: product_attribute_custom_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_custom_value (
    id integer NOT NULL,
    custom_product_template_attribute_value_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    custom_value character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sale_order_line_id integer
);


ALTER TABLE public.product_attribute_custom_value OWNER TO runbot;

--
-- Name: TABLE product_attribute_custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_custom_value IS 'Product Attribute Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.custom_product_template_attribute_value_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_product_template_attribute_value_id IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_custom_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_uid IS 'Created by';


--
-- Name: COLUMN product_attribute_custom_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN product_attribute_custom_value.custom_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.custom_value IS 'Custom Value';


--
-- Name: COLUMN product_attribute_custom_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.create_date IS 'Created on';


--
-- Name: COLUMN product_attribute_custom_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN product_attribute_custom_value.sale_order_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.product_attribute_custom_value.sale_order_line_id IS 'Sales Order Line';


--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_custom_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_custom_value_id_seq OWNER TO runbot;

--
-- Name: product_attribute_custom_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_custom_value_id_seq OWNED BY public.product_attribute_custom_value.id;


--
-- Name: product_attribute_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.product_attribute_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.product_attribute_id_seq OWNER TO runbot;

--
-- Name: product_attribute_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.product_attribute_id_seq OWNED BY public.product_attribute.id;


--
-- Name: product_attribute_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_product_template_rel (
    product_attribute_id integer NOT NULL,
    product_template_id integer NOT NULL
);


ALTER TABLE public.product_attribute_product_template_rel OWNER TO runbot;

--
-- Name: TABLE product_attribute_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_product_template_rel IS 'RELATION BETWEEN product_attribute AND product_template';


--
-- Name: product_attribute_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.product_attribute_value (
    id integer NOT NULL,
    sequence integer,
    attribute_id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    html_color character varying,
    name jsonb NOT NULL,
    is_custom boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    default_extra_price double precision
);


ALTER TABLE public.product_attribute_value OWNER TO runbot;

--
-- Name: TABLE product_attribute_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.product_attribute_value IS 'Attribute Value';


--
-- Name: COLUMN product_attribute_value.sequence; Type