--
-- PostgreSQL database dump
--

\restrict ma4QHZAuwZZofLcBYyeuNPpmzOfHKVGVBBtfnGoHapdNPfqCNq9ifVIJAJtpOMK

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.1 (Debian 18.1-1.pgdg12+2)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: vector; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS vector WITH SCHEMA public;


--
-- Name: EXTENSION vector; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION vector IS 'vector data type and ivfflat and hnsw access methods';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: Products; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public."Products" (
    stock_package_destination_id integer NOT NULL,
    stock_move_line_id integer NOT NULL
);


ALTER TABLE public."Products" OWNER TO runbot;

--
-- Name: TABLE "Products"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public."Products" IS 'RELATION BETWEEN stock_package_destination AND stock_move_line';


--
-- Name: account_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account (
    id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    account_type character varying NOT NULL,
    name jsonb NOT NULL,
    description jsonb,
    code_store jsonb,
    note text,
    active boolean,
    reconcile boolean,
    non_trade boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    account_stock_variation_id integer,
    account_stock_expense_id integer,
    fiscal_category_id integer,
    is_monetary boolean,
    create_asset character varying NOT NULL,
    multiple_assets_per_line boolean,
    l10n_ar_arca_activity_id integer
);


ALTER TABLE public.account_account OWNER TO runbot;

--
-- Name: TABLE account_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account IS 'Account';


--
-- Name: COLUMN account_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.currency_id IS 'Account Currency';


--
-- Name: COLUMN account_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.account_type IS 'Type';


--
-- Name: COLUMN account_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.name IS 'Account Name';


--
-- Name: COLUMN account_account.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.description IS 'Description';


--
-- Name: COLUMN account_account.code_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.code_store IS 'Code Store';


--
-- Name: COLUMN account_account.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.note IS 'Internal Notes';


--
-- Name: COLUMN account_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.active IS 'Active';


--
-- Name: COLUMN account_account.reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.reconcile IS 'Allow Reconciliation';


--
-- Name: COLUMN account_account.non_trade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.non_trade IS 'Non Trade';


--
-- Name: COLUMN account_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_date IS 'Created on';


--
-- Name: COLUMN account_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account.account_stock_variation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.account_stock_variation_id IS 'Variation Account';


--
-- Name: COLUMN account_account.account_stock_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.account_stock_expense_id IS 'Expense Account';


--
-- Name: COLUMN account_account.fiscal_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.fiscal_category_id IS 'Fiscal Category';


--
-- Name: COLUMN account_account.is_monetary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.is_monetary IS 'Is Monetary';


--
-- Name: COLUMN account_account.create_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.create_asset IS 'Create Asset';


--
-- Name: COLUMN account_account.multiple_assets_per_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.multiple_assets_per_line IS 'Multiple Assets per Line';


--
-- Name: COLUMN account_account.l10n_ar_arca_activity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account.l10n_ar_arca_activity_id IS 'Associated ARCA Activity';


--
-- Name: account_account_account_asset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_asset_rel (
    account_account_id integer NOT NULL,
    account_asset_id integer NOT NULL
);


ALTER TABLE public.account_account_account_asset_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_asset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_asset_rel IS 'RELATION BETWEEN account_account AND account_asset';


--
-- Name: account_account_account_auto_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_auto_reconcile_wizard_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_auto_reconcile_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_auto_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_auto_reconcile_wizard_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_account';


--
-- Name: account_account_account_import_summary_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_import_summary_rel (
    account_import_summary_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_import_summary_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_import_summary_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_import_summary_rel IS 'RELATION BETWEEN account_import_summary AND account_account';


--
-- Name: account_account_account_merge_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_merge_wizard_rel (
    account_merge_wizard_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_account_merge_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_account_account_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_merge_wizard_rel IS 'RELATION BETWEEN account_merge_wizard AND account_account';


--
-- Name: account_account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_account_tag (
    account_account_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_account_tag IS 'RELATION BETWEEN account_account AND account_account_tag';


--
-- Name: account_account_exclude_res_currency_provision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_exclude_res_currency_provision (
    account_account_id integer NOT NULL,
    res_currency_id integer NOT NULL
);


ALTER TABLE public.account_account_exclude_res_currency_provision OWNER TO runbot;

--
-- Name: TABLE account_account_exclude_res_currency_provision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_exclude_res_currency_provision IS 'RELATION BETWEEN account_account AND res_currency';


--
-- Name: account_account_fiscal_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_fiscal_rate (
    id integer NOT NULL,
    related_account_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rate double precision NOT NULL
);


ALTER TABLE public.account_account_fiscal_rate OWNER TO runbot;

--
-- Name: TABLE account_account_fiscal_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_fiscal_rate IS 'Fiscal Rate';


--
-- Name: COLUMN account_account_fiscal_rate.related_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.related_account_id IS 'Account';


--
-- Name: COLUMN account_account_fiscal_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.company_id IS 'Company';


--
-- Name: COLUMN account_account_fiscal_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_fiscal_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_fiscal_rate.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.date_from IS 'Start Date';


--
-- Name: COLUMN account_account_fiscal_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_account_fiscal_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_account_fiscal_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_fiscal_rate.rate IS 'Fiscal Rate (%)';


--
-- Name: account_account_fiscal_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_fiscal_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_fiscal_rate_id_seq OWNER TO runbot;

--
-- Name: account_account_fiscal_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_fiscal_rate_id_seq OWNED BY public.account_account_fiscal_rate.id;


--
-- Name: account_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_id_seq OWNER TO runbot;

--
-- Name: account_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_id_seq OWNED BY public.account_account.id;


--
-- Name: account_account_res_company_interest_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_res_company_interest_rel (
    res_company_interest_id integer NOT NULL,
    account_account_id integer NOT NULL
);


ALTER TABLE public.account_account_res_company_interest_rel OWNER TO runbot;

--
-- Name: TABLE account_account_res_company_interest_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_res_company_interest_rel IS 'RELATION BETWEEN res_company_interest AND account_account';


--
-- Name: account_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_res_company_rel (
    account_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_res_company_rel IS 'RELATION BETWEEN account_account AND res_company';


--
-- Name: account_account_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag (
    id integer NOT NULL,
    color integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    applicability character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_account_tag OWNER TO runbot;

--
-- Name: TABLE account_account_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag IS 'Account Tag';


--
-- Name: COLUMN account_account_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.color IS 'Color Index';


--
-- Name: COLUMN account_account_tag.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.country_id IS 'Country';


--
-- Name: COLUMN account_account_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_uid IS 'Created by';


--
-- Name: COLUMN account_account_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_account_tag.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.applicability IS 'Applicability';


--
-- Name: COLUMN account_account_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.name IS 'Tag Name';


--
-- Name: COLUMN account_account_tag.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.active IS 'Active';


--
-- Name: COLUMN account_account_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.create_date IS 'Created on';


--
-- Name: COLUMN account_account_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_account_tag.write_date IS 'Last Updated on';


--
-- Name: account_account_tag_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_move_line_rel (
    account_move_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_move_line_rel IS 'RELATION BETWEEN account_move_line AND account_account_tag';


--
-- Name: account_account_tag_account_tax_repartition_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_account_tax_repartition_line_rel (
    account_tax_repartition_line_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_account_tax_repartition_line_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_account_tax_repartition_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_account_tax_repartition_line_rel IS 'RELATION BETWEEN account_tax_repartition_line AND account_account_tag';


--
-- Name: account_account_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_account_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_account_tag_id_seq OWNER TO runbot;

--
-- Name: account_account_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_account_tag_id_seq OWNED BY public.account_account_tag.id;


--
-- Name: account_account_tag_product_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tag_product_template_rel (
    product_template_id integer NOT NULL,
    account_account_tag_id integer NOT NULL
);


ALTER TABLE public.account_account_tag_product_template_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tag_product_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tag_product_template_rel IS 'RELATION BETWEEN product_template AND account_account_tag';


--
-- Name: account_account_tax_default_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_account_tax_default_rel (
    account_id integer NOT NULL,
    tax_id integer NOT NULL
);


ALTER TABLE public.account_account_tax_default_rel OWNER TO runbot;

--
-- Name: TABLE account_account_tax_default_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_account_tax_default_rel IS 'RELATION BETWEEN account_account AND account_tax';


--
-- Name: account_accrued_orders_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_accrued_orders_wizard (
    id integer NOT NULL,
    company_id integer,
    journal_id integer NOT NULL,
    currency_id integer,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_accrued_orders_wizard OWNER TO runbot;

--
-- Name: TABLE account_accrued_orders_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_accrued_orders_wizard IS 'Accrued Orders Wizard';


--
-- Name: COLUMN account_accrued_orders_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_accrued_orders_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_accrued_orders_wizard.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.currency_id IS 'Company Currency';


--
-- Name: COLUMN account_accrued_orders_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.account_id IS 'Accrual Account';


--
-- Name: COLUMN account_accrued_orders_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_accrued_orders_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_accrued_orders_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.date IS 'Date';


--
-- Name: COLUMN account_accrued_orders_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_accrued_orders_wizard.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.amount IS 'Amount';


--
-- Name: COLUMN account_accrued_orders_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_accrued_orders_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_accrued_orders_wizard.write_date IS 'Last Updated on';


--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_accrued_orders_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNER TO runbot;

--
-- Name: account_accrued_orders_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_accrued_orders_wizard_id_seq OWNED BY public.account_accrued_orders_wizard.id;


--
-- Name: account_analytic_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    root_plan_id integer,
    company_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    commercial_partner_id integer
);


ALTER TABLE public.account_analytic_account OWNER TO runbot;

--
-- Name: TABLE account_analytic_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.plan_id IS 'Plan';


--
-- Name: COLUMN account_analytic_account.root_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.root_plan_id IS 'Root Plan';


--
-- Name: COLUMN account_analytic_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_account.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.partner_id IS 'Customer';


--
-- Name: COLUMN account_analytic_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_account.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.code IS 'Reference';


--
-- Name: COLUMN account_analytic_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.name IS 'Analytic Account';


--
-- Name: COLUMN account_analytic_account.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.active IS 'Active';


--
-- Name: COLUMN account_analytic_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_account.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_account.commercial_partner_id IS 'Commercial Partner';


--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_account_id_seq OWNER TO runbot;

--
-- Name: account_analytic_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_account_id_seq OWNED BY public.account_analytic_account.id;


--
-- Name: account_analytic_account_mrp_bom_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account_mrp_bom_rel (
    account_analytic_account_id integer NOT NULL,
    mrp_bom_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_mrp_bom_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_account_mrp_bom_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account_mrp_bom_rel IS 'RELATION BETWEEN account_analytic_account AND mrp_bom';


--
-- Name: account_analytic_account_mrp_production_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account_mrp_production_rel (
    account_analytic_account_id integer NOT NULL,
    mrp_production_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_mrp_production_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_account_mrp_production_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account_mrp_production_rel IS 'RELATION BETWEEN account_analytic_account AND mrp_production';


--
-- Name: account_analytic_account_mrp_workcenter_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_account_mrp_workcenter_rel (
    account_analytic_account_id integer NOT NULL,
    mrp_workcenter_id integer NOT NULL
);


ALTER TABLE public.account_analytic_account_mrp_workcenter_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_account_mrp_workcenter_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_account_mrp_workcenter_rel IS 'RELATION BETWEEN account_analytic_account AND mrp_workcenter';


--
-- Name: account_analytic_applicability; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_applicability (
    id integer NOT NULL,
    analytic_plan_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    business_domain character varying NOT NULL,
    applicability character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_applicability OWNER TO runbot;

--
-- Name: TABLE account_analytic_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_applicability IS 'Analytic Plan''s Applicabilities';


--
-- Name: COLUMN account_analytic_applicability.analytic_plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.analytic_plan_id IS 'Analytic Plan';


--
-- Name: COLUMN account_analytic_applicability.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_applicability.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_applicability.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_applicability.business_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.business_domain IS 'Domain';


--
-- Name: COLUMN account_analytic_applicability.applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.applicability IS 'Applicability';


--
-- Name: COLUMN account_analytic_applicability.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_applicability.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_applicability.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_applicability.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_applicability.account_prefix IS 'Financial Accounts Prefixes';


--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_applicability_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNER TO runbot;

--
-- Name: account_analytic_applicability_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_applicability_id_seq OWNED BY public.account_analytic_applicability.id;


--
-- Name: account_analytic_distribution_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_distribution_model (
    id integer NOT NULL,
    sequence integer,
    partner_id integer,
    partner_category_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    analytic_distribution jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    product_id integer,
    product_categ_id integer,
    account_prefix character varying
);


ALTER TABLE public.account_analytic_distribution_model OWNER TO runbot;

--
-- Name: TABLE account_analytic_distribution_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_distribution_model IS 'Analytic Distribution Model';


--
-- Name: COLUMN account_analytic_distribution_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_distribution_model.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_distribution_model.partner_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.partner_category_id IS 'Partner Category';


--
-- Name: COLUMN account_analytic_distribution_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_distribution_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_distribution_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_distribution_model.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_analytic_distribution_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_distribution_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_distribution_model.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_distribution_model.product_categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.product_categ_id IS 'Product Category';


--
-- Name: COLUMN account_analytic_distribution_model.account_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_distribution_model.account_prefix IS 'Accounts Prefix';


--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_distribution_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNER TO runbot;

--
-- Name: account_analytic_distribution_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_distribution_model_id_seq OWNED BY public.account_analytic_distribution_model.id;


--
-- Name: account_analytic_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line (
    id integer NOT NULL,
    account_id integer,
    product_uom_id integer,
    partner_id integer,
    user_id integer,
    company_id integer NOT NULL,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    category character varying,
    date date NOT NULL,
    amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    unit_amount double precision,
    x_plan2_id integer,
    x_plan3_id integer,
    product_id integer,
    general_account_id integer,
    journal_id integer,
    move_line_id integer,
    code character varying(8),
    ref character varying,
    task_id integer,
    parent_task_id integer,
    project_id integer,
    department_id integer,
    manager_id integer,
    employee_id integer,
    so_line integer,
    holiday_id integer,
    global_leave_id integer,
    validated boolean,
    helpdesk_ticket_id integer,
    timesheet_invoice_id integer,
    order_id integer,
    timesheet_invoice_type character varying,
    is_so_line_edited boolean,
    extra_hour_type character varying,
    extra_hour boolean,
    cost double precision
);


ALTER TABLE public.account_analytic_line OWNER TO runbot;

--
-- Name: TABLE account_analytic_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line IS 'Analytic Line';


--
-- Name: COLUMN account_analytic_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.account_id IS 'Project Account';


--
-- Name: COLUMN account_analytic_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_uom_id IS 'Unit';


--
-- Name: COLUMN account_analytic_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_analytic_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.company_id IS 'Company';


--
-- Name: COLUMN account_analytic_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_analytic_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.name IS 'Description';


--
-- Name: COLUMN account_analytic_line.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.category IS 'Category';


--
-- Name: COLUMN account_analytic_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.date IS 'Date';


--
-- Name: COLUMN account_analytic_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.amount IS 'Amount';


--
-- Name: COLUMN account_analytic_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_line.unit_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.unit_amount IS 'Quantity';


--
-- Name: COLUMN account_analytic_line.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_line.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.x_plan3_id IS 'Internal';


--
-- Name: COLUMN account_analytic_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.product_id IS 'Product';


--
-- Name: COLUMN account_analytic_line.general_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.general_account_id IS 'Financial Account';


--
-- Name: COLUMN account_analytic_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.journal_id IS 'Financial Journal';


--
-- Name: COLUMN account_analytic_line.move_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.move_line_id IS 'Journal Item';


--
-- Name: COLUMN account_analytic_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.code IS 'Code';


--
-- Name: COLUMN account_analytic_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.ref IS 'Ref.';


--
-- Name: COLUMN account_analytic_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.employee_id IS 'Employee';


--
-- Name: COLUMN account_analytic_line.so_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.so_line IS 'Sales Order Item';


--
-- Name: COLUMN account_analytic_line.holiday_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.holiday_id IS 'Time Off Request';


--
-- Name: COLUMN account_analytic_line.global_leave_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.global_leave_id IS 'Global Time Off';


--
-- Name: COLUMN account_analytic_line.validated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.validated IS 'Validated line';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_id IS 'Invoice';


--
-- Name: COLUMN account_analytic_line.order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.order_id IS 'Order Reference';


--
-- Name: COLUMN account_analytic_line.timesheet_invoice_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.timesheet_invoice_type IS 'Billable Type';


--
-- Name: COLUMN account_analytic_line.is_so_line_edited; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.is_so_line_edited IS 'Is Sales Order Item Manually Edited';


--
-- Name: COLUMN account_analytic_line.extra_hour_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.extra_hour_type IS 'Extra Hour Type';


--
-- Name: COLUMN account_analytic_line.extra_hour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.extra_hour IS 'Extra Hour?';


--
-- Name: COLUMN account_analytic_line.cost; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line.cost IS 'Cost';


--
-- Name: account_analytic_line_calendar_employee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_calendar_employee (
    id integer NOT NULL,
    user_id integer NOT NULL,
    employee_id integer,
    create_uid integer,
    write_uid integer,
    checked boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_analytic_line_calendar_employee OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_calendar_employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_calendar_employee IS 'Personal Filters on Employees for the Calendar view';


--
-- Name: COLUMN account_analytic_line_calendar_employee.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.user_id IS 'User';


--
-- Name: COLUMN account_analytic_line_calendar_employee.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.employee_id IS 'Employee';


--
-- Name: COLUMN account_analytic_line_calendar_employee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_line_calendar_employee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_line_calendar_employee.checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.checked IS 'Checked';


--
-- Name: COLUMN account_analytic_line_calendar_employee.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.active IS 'Active';


--
-- Name: COLUMN account_analytic_line_calendar_employee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_line_calendar_employee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_line_calendar_employee.write_date IS 'Last Updated on';


--
-- Name: account_analytic_line_calendar_employee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_calendar_employee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_calendar_employee_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_calendar_employee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_calendar_employee_id_seq OWNED BY public.account_analytic_line_calendar_employee.id;


--
-- Name: account_analytic_line_hr_timesheet_merge_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel (
    hr_timesheet_merge_wizard_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_hr_timesheet_merge_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_hr_timesheet_merge_wizard_rel IS 'RELATION BETWEEN hr_timesheet_merge_wizard AND account_analytic_line';


--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_line_id_seq OWNER TO runbot;

--
-- Name: account_analytic_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_line_id_seq OWNED BY public.account_analytic_line.id;


--
-- Name: account_analytic_line_mrp_workorder_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_mrp_workorder_rel (
    mrp_workorder_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_mrp_workorder_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_mrp_workorder_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_mrp_workorder_rel IS 'RELATION BETWEEN mrp_workorder AND account_analytic_line';


--
-- Name: account_analytic_line_stock_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_line_stock_move_rel (
    stock_move_id integer NOT NULL,
    account_analytic_line_id integer NOT NULL
);


ALTER TABLE public.account_analytic_line_stock_move_rel OWNER TO runbot;

--
-- Name: TABLE account_analytic_line_stock_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_line_stock_move_rel IS 'RELATION BETWEEN stock_move AND account_analytic_line';


--
-- Name: account_analytic_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_analytic_plan (
    id integer NOT NULL,
    parent_id integer,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    complete_name character varying,
    name jsonb NOT NULL,
    default_applicability jsonb,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    x_plan2_id integer,
    x_plan3_id integer
);


ALTER TABLE public.account_analytic_plan OWNER TO runbot;

--
-- Name: TABLE account_analytic_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_analytic_plan IS 'Analytic Plans';


--
-- Name: COLUMN account_analytic_plan.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_id IS 'Parent';


--
-- Name: COLUMN account_analytic_plan.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.color IS 'Color';


--
-- Name: COLUMN account_analytic_plan.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.sequence IS 'Sequence';


--
-- Name: COLUMN account_analytic_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_uid IS 'Created by';


--
-- Name: COLUMN account_analytic_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_analytic_plan.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.parent_path IS 'Parent Path';


--
-- Name: COLUMN account_analytic_plan.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.complete_name IS 'Complete Name';


--
-- Name: COLUMN account_analytic_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.name IS 'Name';


--
-- Name: COLUMN account_analytic_plan.default_applicability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.default_applicability IS 'Default Applicability';


--
-- Name: COLUMN account_analytic_plan.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.description IS 'Description';


--
-- Name: COLUMN account_analytic_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.create_date IS 'Created on';


--
-- Name: COLUMN account_analytic_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_analytic_plan.x_plan2_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.x_plan2_id IS 'Departments';


--
-- Name: COLUMN account_analytic_plan.x_plan3_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_analytic_plan.x_plan3_id IS 'Internal';


--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_analytic_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_analytic_plan_id_seq OWNER TO runbot;

--
-- Name: account_analytic_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_analytic_plan_id_seq OWNED BY public.account_analytic_plan.id;


--
-- Name: account_ar_vat_line; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.account_ar_vat_line AS
SELECT
    NULL::text AS column_group_key,
    NULL::integer AS id,
    NULL::character varying AS cuit,
    NULL::character varying AS afip_responsibility_type_name,
    NULL::character varying AS partner_name,
    NULL::character varying AS tax_type,
    NULL::integer AS move_id,
    NULL::character varying AS move_type,
    NULL::date AS date,
    NULL::date AS invoice_date,
    NULL::integer AS partner_id,
    NULL::integer AS journal_id,
    NULL::character varying AS move_name,
    NULL::integer AS afip_responsibility_type_id,
    NULL::integer AS document_type_id,
    NULL::character varying AS state,
    NULL::integer AS company_id,
    NULL::numeric AS taxed,
    NULL::numeric AS base_10,
    NULL::numeric AS vat_10,
    NULL::numeric AS base_21,
    NULL::numeric AS vat_21,
    NULL::numeric AS base_27,
    NULL::numeric AS vat_27,
    NULL::numeric AS base_5,
    NULL::numeric AS vat_5,
    NULL::numeric AS base_25,
    NULL::numeric AS vat_25,
    NULL::numeric AS not_taxed,
    NULL::numeric AS vat_per,
    NULL::numeric AS perc_iibb,
    NULL::numeric AS perc_earnings,
    NULL::numeric AS city_tax,
    NULL::numeric AS other_taxes,
    NULL::numeric AS total;


ALTER VIEW public.account_ar_vat_line OWNER TO runbot;

--
-- Name: account_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_asset (
    id integer NOT NULL,
    company_id integer NOT NULL,
    currency_id integer,
    method_number integer,
    account_asset_id integer,
    asset_group_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    journal_id integer,
    model_id integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    method character varying,
    method_period character varying,
    prorata_computation_type character varying NOT NULL,
    prorata_date date NOT NULL,
    acquisition_date date,
    disposal_date date,
    analytic_distribution jsonb,
    asset_properties_definition jsonb,
    asset_properties jsonb,
    original_value numeric,
    book_value numeric,
    salvage_value numeric,
    non_deductible_tax_value numeric,
    already_depreciated_amount_import numeric,
    net_gain_on_sale numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    method_progress_factor double precision,
    salvage_value_pct double precision,
    asset_paused_days double precision
);


ALTER TABLE public.account_asset OWNER TO runbot;

--
-- Name: TABLE account_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_asset IS 'Asset/Revenue Recognition';


--
-- Name: COLUMN account_asset.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.company_id IS 'Company';


--
-- Name: COLUMN account_asset.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.currency_id IS 'Currency';


--
-- Name: COLUMN account_asset.method_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_number IS 'Duration';


--
-- Name: COLUMN account_asset.account_asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_asset_id IS 'Fixed Asset Account';


--
-- Name: COLUMN account_asset.asset_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_asset.account_depreciation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN account_asset.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN account_asset.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.journal_id IS 'Journal';


--
-- Name: COLUMN account_asset.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.model_id IS 'Model';


--
-- Name: COLUMN account_asset.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.parent_id IS 'Parent';


--
-- Name: COLUMN account_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.name IS 'Asset Name';


--
-- Name: COLUMN account_asset.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.state IS 'Status';


--
-- Name: COLUMN account_asset.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method IS 'Method';


--
-- Name: COLUMN account_asset.method_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN account_asset.prorata_computation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.prorata_computation_type IS 'Computation';


--
-- Name: COLUMN account_asset.prorata_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.prorata_date IS 'Prorata Date';


--
-- Name: COLUMN account_asset.acquisition_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.acquisition_date IS 'Acquisition Date';


--
-- Name: COLUMN account_asset.disposal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.disposal_date IS 'Disposal Date';


--
-- Name: COLUMN account_asset.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_asset.asset_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_properties_definition IS 'Model Properties';


--
-- Name: COLUMN account_asset.asset_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_properties IS 'Properties';


--
-- Name: COLUMN account_asset.original_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.original_value IS 'Original Value';


--
-- Name: COLUMN account_asset.book_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.book_value IS 'Book Value';


--
-- Name: COLUMN account_asset.salvage_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.salvage_value IS 'Not Depreciable Value';


--
-- Name: COLUMN account_asset.non_deductible_tax_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.non_deductible_tax_value IS 'Non Deductible Tax Value';


--
-- Name: COLUMN account_asset.already_depreciated_amount_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.already_depreciated_amount_import IS 'Already Depreciated Amount Import';


--
-- Name: COLUMN account_asset.net_gain_on_sale; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.net_gain_on_sale IS 'Net gain on sale';


--
-- Name: COLUMN account_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.active IS 'Active';


--
-- Name: COLUMN account_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.create_date IS 'Created on';


--
-- Name: COLUMN account_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_asset.method_progress_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.method_progress_factor IS 'Declining Factor';


--
-- Name: COLUMN account_asset.salvage_value_pct; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.salvage_value_pct IS 'Not Depreciable Value Percent';


--
-- Name: COLUMN account_asset.asset_paused_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset.asset_paused_days IS 'Asset Paused Days';


--
-- Name: account_asset_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_asset_group (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_asset_group OWNER TO runbot;

--
-- Name: TABLE account_asset_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_asset_group IS 'Asset Group';


--
-- Name: COLUMN account_asset_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.company_id IS 'Company';


--
-- Name: COLUMN account_asset_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_asset_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_asset_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.name IS 'Name';


--
-- Name: COLUMN account_asset_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.create_date IS 'Created on';


--
-- Name: COLUMN account_asset_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_asset_group.write_date IS 'Last Updated on';


--
-- Name: account_asset_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_asset_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_asset_group_id_seq OWNER TO runbot;

--
-- Name: account_asset_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_asset_group_id_seq OWNED BY public.account_asset_group.id;


--
-- Name: account_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_asset_id_seq OWNER TO runbot;

--
-- Name: account_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_asset_id_seq OWNED BY public.account_asset.id;


--
-- Name: account_audit_account_status; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_audit_account_status (
    id integer NOT NULL,
    audit_id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    status character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_audit_account_status OWNER TO runbot;

--
-- Name: TABLE account_audit_account_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_audit_account_status IS 'Account Audit Account Status';


--
-- Name: COLUMN account_audit_account_status.audit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.audit_id IS 'Audit';


--
-- Name: COLUMN account_audit_account_status.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.account_id IS 'Account';


--
-- Name: COLUMN account_audit_account_status.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.create_uid IS 'Created by';


--
-- Name: COLUMN account_audit_account_status.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_audit_account_status.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.status IS 'Status';


--
-- Name: COLUMN account_audit_account_status.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.create_date IS 'Created on';


--
-- Name: COLUMN account_audit_account_status.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_audit_account_status.write_date IS 'Last Updated on';


--
-- Name: account_audit_account_status_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_audit_account_status_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_audit_account_status_id_seq OWNER TO runbot;

--
-- Name: account_audit_account_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_audit_account_status_id_seq OWNED BY public.account_audit_account_status.id;


--
-- Name: account_auto_reconcile_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    search_mode character varying NOT NULL,
    from_date date,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_auto_reconcile_wizard OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard IS 'Account automatic reconciliation wizard';


--
-- Name: COLUMN account_auto_reconcile_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_auto_reconcile_wizard.search_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.search_mode IS 'Reconcile';


--
-- Name: COLUMN account_auto_reconcile_wizard.from_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.from_date IS 'From';


--
-- Name: COLUMN account_auto_reconcile_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.to_date IS 'To';


--
-- Name: COLUMN account_auto_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_auto_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_auto_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_auto_reconcile_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard_account_move_line_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_account_move_line_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND account_move_line';


--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_auto_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNER TO runbot;

--
-- Name: account_auto_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_auto_reconcile_wizard_id_seq OWNED BY public.account_auto_reconcile_wizard.id;


--
-- Name: account_auto_reconcile_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_auto_reconcile_wizard_res_partner_rel (
    account_auto_reconcile_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_auto_reconcile_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_auto_reconcile_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_auto_reconcile_wizard_res_partner_rel IS 'RELATION BETWEEN account_auto_reconcile_wizard AND res_partner';


--
-- Name: account_automatic_entry_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    account_type character varying,
    date date NOT NULL,
    total_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage double precision
);


ALTER TABLE public.account_automatic_entry_wizard OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard IS 'Create Automatic Entries';


--
-- Name: COLUMN account_automatic_entry_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_automatic_entry_wizard.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.destination_account_id IS 'To';


--
-- Name: COLUMN account_automatic_entry_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_automatic_entry_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_automatic_entry_wizard.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.action IS 'Action';


--
-- Name: COLUMN account_automatic_entry_wizard.account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.account_type IS 'Account Type';


--
-- Name: COLUMN account_automatic_entry_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.date IS 'Date';


--
-- Name: COLUMN account_automatic_entry_wizard.total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.total_amount IS 'Total Amount';


--
-- Name: COLUMN account_automatic_entry_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_automatic_entry_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_automatic_entry_wizard.percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_automatic_entry_wizard.percentage IS 'Percentage';


--
-- Name: account_automatic_entry_wizard_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_automatic_entry_wizard_account_move_line_rel (
    account_automatic_entry_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_automatic_entry_wizard_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_automatic_entry_wizard_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_automatic_entry_wizard_account_move_line_rel IS 'RELATION BETWEEN account_automatic_entry_wizard AND account_move_line';


--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_automatic_entry_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNER TO runbot;

--
-- Name: account_automatic_entry_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_automatic_entry_wizard_id_seq OWNED BY public.account_automatic_entry_wizard.id;


--
-- Name: account_autopost_bills_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_autopost_bills_wizard (
    id integer NOT NULL,
    partner_id integer,
    nb_unmodified_bills integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_autopost_bills_wizard OWNER TO runbot;

--
-- Name: TABLE account_autopost_bills_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_autopost_bills_wizard IS 'Autopost Bills Wizard';


--
-- Name: COLUMN account_autopost_bills_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN account_autopost_bills_wizard.nb_unmodified_bills; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.nb_unmodified_bills IS 'Number of bills previously unmodified from this partner';


--
-- Name: COLUMN account_autopost_bills_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_autopost_bills_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_autopost_bills_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_autopost_bills_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_autopost_bills_wizard.write_date IS 'Last Updated on';


--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_autopost_bills_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNER TO runbot;

--
-- Name: account_autopost_bills_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_autopost_bills_wizard_id_seq OWNED BY public.account_autopost_bills_wizard.id;


--
-- Name: account_balance_import_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_balance_import_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    counterpart_account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    mode character varying NOT NULL,
    partner_balance_type character varying,
    import_type character varying NOT NULL,
    accounting_date date NOT NULL,
    export_partners boolean,
    reconcile_debt boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    check_type character varying
);


ALTER TABLE public.account_balance_import_wizard OWNER TO runbot;

--
-- Name: TABLE account_balance_import_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_balance_import_wizard IS 'Account Initial Balance Wizard';


--
-- Name: COLUMN account_balance_import_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.company_id IS 'Compañía';


--
-- Name: COLUMN account_balance_import_wizard.counterpart_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.counterpart_account_id IS 'Cuenta de Contrapartida';


--
-- Name: COLUMN account_balance_import_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.journal_id IS 'Diario';


--
-- Name: COLUMN account_balance_import_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_balance_import_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_balance_import_wizard.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.mode IS 'Modo de Importación';


--
-- Name: COLUMN account_balance_import_wizard.partner_balance_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.partner_balance_type IS 'Tipo de Deuda';


--
-- Name: COLUMN account_balance_import_wizard.import_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.import_type IS 'Tipo de Importación';


--
-- Name: COLUMN account_balance_import_wizard.accounting_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.accounting_date IS 'Fecha Contable';


--
-- Name: COLUMN account_balance_import_wizard.export_partners; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.export_partners IS 'Exportar Partners';


--
-- Name: COLUMN account_balance_import_wizard.reconcile_debt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.reconcile_debt IS 'Conciliar deuda';


--
-- Name: COLUMN account_balance_import_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_balance_import_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_balance_import_wizard.check_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_balance_import_wizard.check_type IS 'Tipo de Cheques';


--
-- Name: account_balance_import_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_balance_import_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_balance_import_wizard_id_seq OWNER TO runbot;

--
-- Name: account_balance_import_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_balance_import_wizard_id_seq OWNED BY public.account_balance_import_wizard.id;


--
-- Name: account_bank_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_selection (
    id integer NOT NULL,
    account_online_link_id integer,
    selected_account integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_selection OWNER TO runbot;

--
-- Name: TABLE account_bank_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_selection IS 'Link a bank account to the selected journal';


--
-- Name: COLUMN account_bank_selection.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_selection.selected_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.selected_account IS 'Selected Account';


--
-- Name: COLUMN account_bank_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_selection.write_date IS 'Last Updated on';


--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_selection_id_seq OWNER TO runbot;

--
-- Name: account_bank_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_selection_id_seq OWNED BY public.account_bank_selection.id;


--
-- Name: account_bank_statement; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement (
    id integer NOT NULL,
    company_id integer,
    currency_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    reference character varying,
    first_line_index character varying,
    date date,
    balance_start numeric,
    balance_end numeric,
    balance_end_real numeric,
    is_complete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    message_main_attachment_id integer,
    extract_attachment_id integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    extracted_words jsonb,
    extracted_numbers jsonb,
    extracted_dates jsonb,
    is_in_extractable_state boolean,
    extract_state_processed boolean
);


ALTER TABLE public.account_bank_statement OWNER TO runbot;

--
-- Name: TABLE account_bank_statement; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement IS 'Bank Statement';


--
-- Name: COLUMN account_bank_statement.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.currency_id IS 'Currency';


--
-- Name: COLUMN account_bank_statement.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.name IS 'Reference';


--
-- Name: COLUMN account_bank_statement.reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.reference IS 'External Reference';


--
-- Name: COLUMN account_bank_statement.first_line_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.first_line_index IS 'First Line Index';


--
-- Name: COLUMN account_bank_statement.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.date IS 'Date';


--
-- Name: COLUMN account_bank_statement.balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_start IS 'Starting Balance';


--
-- Name: COLUMN account_bank_statement.balance_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end IS 'Computed Balance';


--
-- Name: COLUMN account_bank_statement.balance_end_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.balance_end_real IS 'Ending Balance';


--
-- Name: COLUMN account_bank_statement.is_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_complete IS 'Is Complete';


--
-- Name: COLUMN account_bank_statement.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_bank_statement.extract_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_attachment_id IS 'Extract Attachment';


--
-- Name: COLUMN account_bank_statement.extract_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_state IS 'Extract state';


--
-- Name: COLUMN account_bank_statement.extract_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_status IS 'Extract status';


--
-- Name: COLUMN account_bank_statement.extract_document_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_bank_statement.extracted_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extracted_words IS 'Extracted Words';


--
-- Name: COLUMN account_bank_statement.extracted_numbers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extracted_numbers IS 'Extracted Numbers';


--
-- Name: COLUMN account_bank_statement.extracted_dates; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extracted_dates IS 'Extracted Dates';


--
-- Name: COLUMN account_bank_statement.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_bank_statement.extract_state_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement.extract_state_processed IS 'Extract State Processed';


--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_id_seq OWNED BY public.account_bank_statement.id;


--
-- Name: account_bank_statement_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_ir_attachment_rel (
    account_bank_statement_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_bank_statement_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_ir_attachment_rel IS 'RELATION BETWEEN account_bank_statement AND ir_attachment';


--
-- Name: account_bank_statement_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    statement_id integer,
    sequence integer,
    partner_id integer,
    currency_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    account_number character varying,
    partner_name character varying,
    transaction_type character varying,
    payment_ref character varying,
    internal_index character varying,
    transaction_details jsonb,
    amount numeric,
    amount_currency numeric,
    is_reconciled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount_residual double precision,
    message_main_attachment_id integer,
    cron_last_check timestamp without time zone,
    unique_import_id character varying,
    online_account_id integer,
    online_link_id integer,
    online_transaction_identifier character varying,
    online_partner_information character varying,
    raw_data text,
    pos_session_id integer,
    employee_id integer,
    end_to_end_uuid character varying
);


ALTER TABLE public.account_bank_statement_line OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line IS 'Bank Statement Line';


--
-- Name: COLUMN account_bank_statement_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_bank_statement_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_bank_statement_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_bank_statement_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.currency_id IS 'Journal Currency';


--
-- Name: COLUMN account_bank_statement_line.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.account_number IS 'Bank Account Number';


--
-- Name: COLUMN account_bank_statement_line.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line.transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_type IS 'Transaction Type';


--
-- Name: COLUMN account_bank_statement_line.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.payment_ref IS 'Label';


--
-- Name: COLUMN account_bank_statement_line.internal_index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.internal_index IS 'Internal Reference';


--
-- Name: COLUMN account_bank_statement_line.transaction_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_bank_statement_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_bank_statement_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_bank_statement_line.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_bank_statement_line.cron_last_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.cron_last_check IS 'Cron Last Check';


--
-- Name: COLUMN account_bank_statement_line.unique_import_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.unique_import_id IS 'Import ID';


--
-- Name: COLUMN account_bank_statement_line.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_account_id IS 'Online Account';


--
-- Name: COLUMN account_bank_statement_line.online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_bank_statement_line.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line.online_partner_information; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.online_partner_information IS 'Online Partner Information';


--
-- Name: COLUMN account_bank_statement_line.raw_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.raw_data IS 'Raw Data';


--
-- Name: COLUMN account_bank_statement_line.pos_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.pos_session_id IS 'Session';


--
-- Name: COLUMN account_bank_statement_line.employee_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.employee_id IS 'Employee';


--
-- Name: COLUMN account_bank_statement_line.end_to_end_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line.end_to_end_uuid IS 'End to End ID';


--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_id_seq OWNED BY public.account_bank_statement_line.id;


--
-- Name: account_bank_statement_line_transient; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_bank_statement_line_transient (
    id integer NOT NULL,
    sequence integer,
    journal_id integer,
    online_account_id integer,
    company_id integer,
    foreign_currency_id integer,
    create_uid integer,
    write_uid integer,
    online_transaction_identifier character varying,
    payment_ref character varying,
    account_number character varying,
    partner_name character varying,
    state character varying,
    date date,
    transaction_details jsonb,
    amount numeric,
    amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_bank_statement_line_transient OWNER TO runbot;

--
-- Name: TABLE account_bank_statement_line_transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_bank_statement_line_transient IS 'Transient model for bank statement line';


--
-- Name: COLUMN account_bank_statement_line_transient.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.sequence IS 'Sequence';


--
-- Name: COLUMN account_bank_statement_line_transient.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.journal_id IS 'Journal';


--
-- Name: COLUMN account_bank_statement_line_transient.online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_bank_statement_line_transient.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.company_id IS 'Company';


--
-- Name: COLUMN account_bank_statement_line_transient.foreign_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.foreign_currency_id IS 'Foreign Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_uid IS 'Created by';


--
-- Name: COLUMN account_bank_statement_line_transient.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_bank_statement_line_transient.online_transaction_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.online_transaction_identifier IS 'Online Transaction Identifier';


--
-- Name: COLUMN account_bank_statement_line_transient.payment_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.payment_ref IS 'Payment Ref';


--
-- Name: COLUMN account_bank_statement_line_transient.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.account_number IS 'Account Number';


--
-- Name: COLUMN account_bank_statement_line_transient.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.partner_name IS 'Partner Name';


--
-- Name: COLUMN account_bank_statement_line_transient.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.state IS 'State';


--
-- Name: COLUMN account_bank_statement_line_transient.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.date IS 'Date';


--
-- Name: COLUMN account_bank_statement_line_transient.transaction_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.transaction_details IS 'Transaction Details';


--
-- Name: COLUMN account_bank_statement_line_transient.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount IS 'Amount';


--
-- Name: COLUMN account_bank_statement_line_transient.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_bank_statement_line_transient.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.create_date IS 'Created on';


--
-- Name: COLUMN account_bank_statement_line_transient.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_bank_statement_line_transient.write_date IS 'Last Updated on';


--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_bank_statement_line_transient_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNER TO runbot;

--
-- Name: account_bank_statement_line_transient_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_bank_statement_line_transient_id_seq OWNED BY public.account_bank_statement_line_transient.id;


--
-- Name: account_batch_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard (
    id integer NOT NULL,
    batch_payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_remove_options boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard IS 'Batch payments error reporting wizard';


--
-- Name: COLUMN account_batch_error_wizard.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_batch_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard.show_remove_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.show_remove_options IS 'Show Remove Options';


--
-- Name: COLUMN account_batch_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_id_seq OWNED BY public.account_batch_error_wizard.id;


--
-- Name: account_batch_error_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line (
    id integer NOT NULL,
    error_wizard_id integer,
    warning_wizard_id integer,
    create_uid integer,
    write_uid integer,
    description character varying NOT NULL,
    help_message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_batch_error_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line IS 'Batch payments error reporting wizard line';


--
-- Name: COLUMN account_batch_error_wizard_line.error_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.error_wizard_id IS 'Error Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.warning_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.warning_wizard_id IS 'Warning Wizard';


--
-- Name: COLUMN account_batch_error_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_error_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_error_wizard_line.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.description IS 'Description';


--
-- Name: COLUMN account_batch_error_wizard_line.help_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.help_message IS 'Help';


--
-- Name: COLUMN account_batch_error_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_error_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_error_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_batch_error_wizard_line_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_error_wizard_line_account_payment_rel (
    account_batch_error_wizard_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_batch_error_wizard_line_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_batch_error_wizard_line_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_error_wizard_line_account_payment_rel IS 'RELATION BETWEEN account_batch_error_wizard_line AND account_payment';


--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_error_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_batch_error_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_error_wizard_line_id_seq OWNED BY public.account_batch_error_wizard_line.id;


--
-- Name: account_batch_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_batch_payment (
    id integer NOT NULL,
    journal_id integer,
    currency_id integer,
    company_currency_id integer,
    payment_method_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    batch_type character varying NOT NULL,
    export_filename character varying,
    date date NOT NULL,
    export_file_create_date date,
    amount_residual numeric,
    amount_residual_currency numeric,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    direct_debit_collection_date date,
    periodo character varying,
    iso20022_batch_booking boolean,
    payment_identifier character varying,
    payment_online_status character varying
);


ALTER TABLE public.account_batch_payment OWNER TO runbot;

--
-- Name: TABLE account_batch_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_batch_payment IS 'Batch Payment';


--
-- Name: COLUMN account_batch_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.journal_id IS 'Bank';


--
-- Name: COLUMN account_batch_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_batch_payment.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_batch_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_batch_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_batch_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_batch_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.name IS 'Reference';


--
-- Name: COLUMN account_batch_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.state IS 'State';


--
-- Name: COLUMN account_batch_payment.batch_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.batch_type IS 'Batch Type';


--
-- Name: COLUMN account_batch_payment.export_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_filename IS 'File Name';


--
-- Name: COLUMN account_batch_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.date IS 'Date';


--
-- Name: COLUMN account_batch_payment.export_file_create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.export_file_create_date IS 'Generation Date';


--
-- Name: COLUMN account_batch_payment.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual IS 'Amount Residual';


--
-- Name: COLUMN account_batch_payment.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount_residual_currency IS 'Amount Residual Currency';


--
-- Name: COLUMN account_batch_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.amount IS 'Amount';


--
-- Name: COLUMN account_batch_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_batch_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_batch_payment.direct_debit_collection_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.direct_debit_collection_date IS 'Collection date';


--
-- Name: COLUMN account_batch_payment.periodo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.periodo IS 'Periodo';


--
-- Name: COLUMN account_batch_payment.iso20022_batch_booking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.iso20022_batch_booking IS 'SCT Batch Booking';


--
-- Name: COLUMN account_batch_payment.payment_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.payment_identifier IS 'Batch ID';


--
-- Name: COLUMN account_batch_payment.payment_online_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_batch_payment.payment_online_status IS 'PIS Status';


--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_batch_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_batch_payment_id_seq OWNER TO runbot;

--
-- Name: account_batch_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_batch_payment_id_seq OWNED BY public.account_batch_payment.id;


--
-- Name: account_card; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_card (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    due_day integer,
    loan_due_method character varying,
    is_loan boolean
);


ALTER TABLE public.account_card OWNER TO runbot;

--
-- Name: TABLE account_card; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_card IS 'Credit Card';


--
-- Name: COLUMN account_card.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.company_id IS 'Company';


--
-- Name: COLUMN account_card.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.create_uid IS 'Created by';


--
-- Name: COLUMN account_card.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_card.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.name IS 'name';


--
-- Name: COLUMN account_card.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.active IS 'Active';


--
-- Name: COLUMN account_card.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.create_date IS 'Created on';


--
-- Name: COLUMN account_card.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_card.due_day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.due_day IS 'Due Day';


--
-- Name: COLUMN account_card.loan_due_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.loan_due_method IS 'Loan Due Method';


--
-- Name: COLUMN account_card.is_loan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card.is_loan IS 'Is Loan';


--
-- Name: account_card_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_card_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_card_id_seq OWNER TO runbot;

--
-- Name: account_card_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_card_id_seq OWNED BY public.account_card.id;


--
-- Name: account_card_installment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_card_installment (
    id integer NOT NULL,
    card_id integer NOT NULL,
    divisor integer,
    installment integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    surcharge_coefficient numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    bank_discount double precision,
    message character varying,
    is_published boolean
);


ALTER TABLE public.account_card_installment OWNER TO runbot;

--
-- Name: TABLE account_card_installment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_card_installment IS 'amount to add for collection in installments';


--
-- Name: COLUMN account_card_installment.card_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.card_id IS 'Card';


--
-- Name: COLUMN account_card_installment.divisor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.divisor IS 'Divisor';


--
-- Name: COLUMN account_card_installment.installment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.installment IS 'Installment Plan';


--
-- Name: COLUMN account_card_installment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.create_uid IS 'Created by';


--
-- Name: COLUMN account_card_installment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_card_installment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.name IS 'Fantasy Name';


--
-- Name: COLUMN account_card_installment.surcharge_coefficient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.surcharge_coefficient IS 'Surcharge Coefficient';


--
-- Name: COLUMN account_card_installment.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.active IS 'Active';


--
-- Name: COLUMN account_card_installment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.create_date IS 'Created on';


--
-- Name: COLUMN account_card_installment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_card_installment.bank_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.bank_discount IS 'Bank Discount';


--
-- Name: COLUMN account_card_installment.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.message IS 'Message';


--
-- Name: COLUMN account_card_installment.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_card_installment.is_published IS 'Is Published';


--
-- Name: account_card_installment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_card_installment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_card_installment_id_seq OWNER TO runbot;

--
-- Name: account_card_installment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_card_installment_id_seq OWNED BY public.account_card_installment.id;


--
-- Name: account_cash_rounding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cash_rounding (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    strategy character varying NOT NULL,
    rounding_method character varying NOT NULL,
    name jsonb NOT NULL,
    profit_account_id jsonb,
    loss_account_id jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    rounding double precision NOT NULL
);


ALTER TABLE public.account_cash_rounding OWNER TO runbot;

--
-- Name: TABLE account_cash_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cash_rounding IS 'Account Cash Rounding';


--
-- Name: COLUMN account_cash_rounding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_uid IS 'Created by';


--
-- Name: COLUMN account_cash_rounding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cash_rounding.strategy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.strategy IS 'Rounding Strategy';


--
-- Name: COLUMN account_cash_rounding.rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_cash_rounding.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.name IS 'Name';


--
-- Name: COLUMN account_cash_rounding.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_cash_rounding.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_cash_rounding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.create_date IS 'Created on';


--
-- Name: COLUMN account_cash_rounding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cash_rounding.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cash_rounding.rounding IS 'Rounding Precision';


--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cash_rounding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cash_rounding_id_seq OWNER TO runbot;

--
-- Name: account_cash_rounding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cash_rounding_id_seq OWNED BY public.account_cash_rounding.id;


--
-- Name: account_cashbox; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    allow_dates_edition boolean,
    restrict_users boolean,
    allow_concurrent_sessions boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_diff double precision
);


ALTER TABLE public.account_cashbox OWNER TO runbot;

--
-- Name: TABLE account_cashbox; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox IS 'Cashbox';


--
-- Name: COLUMN account_cashbox.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.company_id IS 'Company';


--
-- Name: COLUMN account_cashbox.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.sequence_id IS 'Sequence';


--
-- Name: COLUMN account_cashbox.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.name IS 'Name';


--
-- Name: COLUMN account_cashbox.allow_dates_edition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.allow_dates_edition IS 'Allow Dates Edition';


--
-- Name: COLUMN account_cashbox.restrict_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.restrict_users IS 'Restrict Users';


--
-- Name: COLUMN account_cashbox.allow_concurrent_sessions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.allow_concurrent_sessions IS 'Allow Concurrent Sessions';


--
-- Name: COLUMN account_cashbox.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_cashbox.max_diff; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox.max_diff IS 'Max Allowed Difference';


--
-- Name: account_cashbox_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_account_journal_rel (
    account_cashbox_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_cashbox_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_cashbox_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_account_journal_rel IS 'RELATION BETWEEN account_cashbox AND account_journal';


--
-- Name: account_cashbox_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_id_seq OWNED BY public.account_cashbox.id;


--
-- Name: account_cashbox_payment_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_payment_import (
    id integer NOT NULL,
    cashbox_session_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_cashbox_payment_import OWNER TO runbot;

--
-- Name: TABLE account_cashbox_payment_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_payment_import IS 'Import Payment into session';


--
-- Name: COLUMN account_cashbox_payment_import.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.cashbox_session_id IS 'Cashbox Session';


--
-- Name: COLUMN account_cashbox_payment_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_payment_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox_payment_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_payment_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_payment_import.write_date IS 'Last Updated on';


--
-- Name: account_cashbox_payment_import_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_payment_import_account_payment_rel (
    account_cashbox_payment_import_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_cashbox_payment_import_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_cashbox_payment_import_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_payment_import_account_payment_rel IS 'RELATION BETWEEN account_cashbox_payment_import AND account_payment';


--
-- Name: account_cashbox_payment_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_payment_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_payment_import_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_payment_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_payment_import_id_seq OWNED BY public.account_cashbox_payment_import.id;


--
-- Name: account_cashbox_rounding_adjustment_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_rounding_adjustment_wizard (
    id integer NOT NULL,
    cashbox_session_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_cashbox_rounding_adjustment_wizard OWNER TO runbot;

--
-- Name: TABLE account_cashbox_rounding_adjustment_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_rounding_adjustment_wizard IS 'Cashbox Rounding Adjustment';


--
-- Name: COLUMN account_cashbox_rounding_adjustment_wizard.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_rounding_adjustment_wizard.cashbox_session_id IS 'Cashbox Session';


--
-- Name: COLUMN account_cashbox_rounding_adjustment_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_rounding_adjustment_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_rounding_adjustment_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_rounding_adjustment_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox_rounding_adjustment_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_rounding_adjustment_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_rounding_adjustment_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_rounding_adjustment_wizard.write_date IS 'Last Updated on';


--
-- Name: account_cashbox_rounding_adjustment_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_rounding_adjustment_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_rounding_adjustment_wizard_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_rounding_adjustment_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_rounding_adjustment_wizard_id_seq OWNED BY public.account_cashbox_rounding_adjustment_wizard.id;


--
-- Name: account_cashbox_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_session (
    id integer NOT NULL,
    cashbox_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    opening_date timestamp without time zone,
    closing_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_cashbox_session OWNER TO runbot;

--
-- Name: TABLE account_cashbox_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_session IS 'Cashbox session';


--
-- Name: COLUMN account_cashbox_session.cashbox_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.cashbox_id IS 'Cashbox';


--
-- Name: COLUMN account_cashbox_session.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.company_id IS 'Company';


--
-- Name: COLUMN account_cashbox_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox_session.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.name IS 'Name';


--
-- Name: COLUMN account_cashbox_session.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.state IS 'State';


--
-- Name: COLUMN account_cashbox_session.opening_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.opening_date IS 'Opening Date';


--
-- Name: COLUMN account_cashbox_session.closing_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.closing_date IS 'Closing Date';


--
-- Name: COLUMN account_cashbox_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session.write_date IS 'Last Updated on';


--
-- Name: account_cashbox_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_session_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_session_id_seq OWNED BY public.account_cashbox_session.id;


--
-- Name: account_cashbox_session_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_session_line (
    id integer NOT NULL,
    cashbox_session_id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    balance_start numeric,
    balance_end_real numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_cashbox_session_line OWNER TO runbot;

--
-- Name: TABLE account_cashbox_session_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_session_line IS 'session journal';


--
-- Name: COLUMN account_cashbox_session_line.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.cashbox_session_id IS 'Session';


--
-- Name: COLUMN account_cashbox_session_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_cashbox_session_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_cashbox_session_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_cashbox_session_line.balance_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.balance_start IS 'Balance Start';


--
-- Name: COLUMN account_cashbox_session_line.balance_end_real; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.balance_end_real IS 'Real Ending Balance';


--
-- Name: COLUMN account_cashbox_session_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.create_date IS 'Created on';


--
-- Name: COLUMN account_cashbox_session_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_cashbox_session_line.write_date IS 'Last Updated on';


--
-- Name: account_cashbox_session_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_cashbox_session_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_cashbox_session_line_id_seq OWNER TO runbot;

--
-- Name: account_cashbox_session_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_cashbox_session_line_id_seq OWNED BY public.account_cashbox_session_line.id;


--
-- Name: account_cashbox_session_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_session_res_users_rel (
    account_cashbox_session_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.account_cashbox_session_res_users_rel OWNER TO runbot;

--
-- Name: TABLE account_cashbox_session_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_session_res_users_rel IS 'RELATION BETWEEN account_cashbox_session AND res_users';


--
-- Name: account_cashbox_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_cashbox_users_rel (
    cashbox_id integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.account_cashbox_users_rel OWNER TO runbot;

--
-- Name: TABLE account_cashbox_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_cashbox_users_rel IS 'RELATION BETWEEN account_cashbox AND res_users';


--
-- Name: account_change_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_company (
    id integer NOT NULL,
    move_id integer,
    company_id integer NOT NULL,
    journal_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_company OWNER TO runbot;

--
-- Name: TABLE account_change_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_company IS 'Change Company';


--
-- Name: COLUMN account_change_company.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.move_id IS 'Move';


--
-- Name: COLUMN account_change_company.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.company_id IS 'Company';


--
-- Name: COLUMN account_change_company.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.journal_id IS 'Journal';


--
-- Name: COLUMN account_change_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_company.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.create_date IS 'Created on';


--
-- Name: COLUMN account_change_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_company.write_date IS 'Last Updated on';


--
-- Name: account_change_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_company_id_seq OWNER TO runbot;

--
-- Name: account_change_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_company_id_seq OWNED BY public.account_change_company.id;


--
-- Name: account_change_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_currency (
    id integer NOT NULL,
    currency_to_id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    conversion_rate numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_currency OWNER TO runbot;

--
-- Name: TABLE account_change_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_currency IS 'Change Currency';


--
-- Name: COLUMN account_change_currency.currency_to_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.currency_to_id IS 'Currency to';


--
-- Name: COLUMN account_change_currency.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.move_id IS 'Move';


--
-- Name: COLUMN account_change_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_currency.conversion_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.conversion_rate IS 'Conversion Rate';


--
-- Name: COLUMN account_change_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.create_date IS 'Created on';


--
-- Name: COLUMN account_change_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_currency.write_date IS 'Last Updated on';


--
-- Name: account_change_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_currency_id_seq OWNER TO runbot;

--
-- Name: account_change_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_currency_id_seq OWNED BY public.account_change_currency.id;


--
-- Name: account_change_lock_date; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_change_lock_date (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    exception_applies_to character varying NOT NULL,
    exception_duration character varying NOT NULL,
    exception_reason character varying,
    fiscalyear_lock_date date,
    tax_lock_date date,
    sale_lock_date date,
    purchase_lock_date date,
    hard_lock_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_change_lock_date OWNER TO runbot;

--
-- Name: TABLE account_change_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_change_lock_date IS 'Change Lock Date';


--
-- Name: COLUMN account_change_lock_date.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.company_id IS 'Company';


--
-- Name: COLUMN account_change_lock_date.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_uid IS 'Created by';


--
-- Name: COLUMN account_change_lock_date.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_change_lock_date.exception_applies_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_applies_to IS 'Exception applies';


--
-- Name: COLUMN account_change_lock_date.exception_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_duration IS 'Exception Duration';


--
-- Name: COLUMN account_change_lock_date.exception_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.exception_reason IS 'Exception Reason';


--
-- Name: COLUMN account_change_lock_date.fiscalyear_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.fiscalyear_lock_date IS 'Lock Everything';


--
-- Name: COLUMN account_change_lock_date.tax_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.tax_lock_date IS 'Lock Tax Return';


--
-- Name: COLUMN account_change_lock_date.sale_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.sale_lock_date IS 'Lock Sales';


--
-- Name: COLUMN account_change_lock_date.purchase_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.purchase_lock_date IS 'Lock Purchases';


--
-- Name: COLUMN account_change_lock_date.hard_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.hard_lock_date IS 'Hard Lock';


--
-- Name: COLUMN account_change_lock_date.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.create_date IS 'Created on';


--
-- Name: COLUMN account_change_lock_date.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_change_lock_date.write_date IS 'Last Updated on';


--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_change_lock_date_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_change_lock_date_id_seq OWNER TO runbot;

--
-- Name: account_change_lock_date_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_change_lock_date_id_seq OWNED BY public.account_change_lock_date.id;


--
-- Name: account_check_action_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_action_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_action_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_action_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_action_wizard IS 'Account Check Action Wizard';


--
-- Name: COLUMN account_check_action_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_action_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_action_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.date IS 'Date';


--
-- Name: COLUMN account_check_action_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_action_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_action_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_action_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_action_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_action_wizard_id_seq OWNED BY public.account_check_action_wizard.id;


--
-- Name: account_check_to_date_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_check_to_date_report_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    to_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_check_to_date_report_wizard OWNER TO runbot;

--
-- Name: TABLE account_check_to_date_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_check_to_date_report_wizard IS 'account.check.to_date.report.wizard';


--
-- Name: COLUMN account_check_to_date_report_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.journal_id IS 'Diario';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_check_to_date_report_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.to_date IS 'Hasta Fecha';


--
-- Name: COLUMN account_check_to_date_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_check_to_date_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_check_to_date_report_wizard.write_date IS 'Last Updated on';


--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_check_to_date_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNER TO runbot;

--
-- Name: account_check_to_date_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_check_to_date_report_wizard_id_seq OWNED BY public.account_check_to_date_report_wizard.id;


--
-- Name: account_commission_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_commission_rule (
    id integer NOT NULL,
    sequence integer NOT NULL,
    partner_id integer,
    customer_id integer,
    product_tmpl_id integer,
    categ_id integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    date_start date,
    date_end date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    min_amount double precision,
    percent_commission double precision,
    public_category_id integer
);


ALTER TABLE public.account_commission_rule OWNER TO runbot;

--
-- Name: TABLE account_commission_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_commission_rule IS 'Account Commission Rule';


--
-- Name: COLUMN account_commission_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.sequence IS 'Sequence';


--
-- Name: COLUMN account_commission_rule.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.partner_id IS 'Partner';


--
-- Name: COLUMN account_commission_rule.customer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.customer_id IS 'Customer';


--
-- Name: COLUMN account_commission_rule.product_tmpl_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.product_tmpl_id IS 'Product Template';


--
-- Name: COLUMN account_commission_rule.categ_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.categ_id IS 'Product Category';


--
-- Name: COLUMN account_commission_rule.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.account_id IS 'Commission Account';


--
-- Name: COLUMN account_commission_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_commission_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_commission_rule.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.date_start IS 'Start Date';


--
-- Name: COLUMN account_commission_rule.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.date_end IS 'End Date';


--
-- Name: COLUMN account_commission_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_commission_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_commission_rule.min_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.min_amount IS 'Min Amount';


--
-- Name: COLUMN account_commission_rule.percent_commission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.percent_commission IS 'Percentage Commission';


--
-- Name: COLUMN account_commission_rule.public_category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_commission_rule.public_category_id IS 'Website Category';


--
-- Name: account_commission_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_commission_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_commission_rule_id_seq OWNER TO runbot;

--
-- Name: account_commission_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_commission_rule_id_seq OWNED BY public.account_commission_rule.id;


--
-- Name: account_create_batch_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_create_batch_error_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_create_batch_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_create_batch_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_create_batch_error_wizard IS 'Create Batch Payment Error Wizard';


--
-- Name: COLUMN account_create_batch_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_create_batch_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_create_batch_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_create_batch_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_create_batch_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_create_batch_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_create_batch_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_create_batch_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_create_batch_error_wizard_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_create_batch_error_wizard_account_payment_rel (
    account_create_batch_error_wizard_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_create_batch_error_wizard_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_create_batch_error_wizard_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_create_batch_error_wizard_account_payment_rel IS 'RELATION BETWEEN account_create_batch_error_wizard AND account_payment';


--
-- Name: account_create_batch_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_create_batch_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_create_batch_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_create_batch_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_create_batch_error_wizard_id_seq OWNED BY public.account_create_batch_error_wizard.id;


--
-- Name: account_debit_note; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_debit_note (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date NOT NULL,
    copy_lines boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_cl_edi_reference_doc_code character varying,
    l10n_cl_original_text character varying,
    l10n_cl_corrected_text character varying,
    l10n_pe_edi_charge_reason character varying
);


ALTER TABLE public.account_debit_note OWNER TO runbot;

--
-- Name: TABLE account_debit_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_debit_note IS 'Add Debit Note wizard';


--
-- Name: COLUMN account_debit_note.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.journal_id IS 'Use Specific Journal';


--
-- Name: COLUMN account_debit_note.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_uid IS 'Created by';


--
-- Name: COLUMN account_debit_note.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_debit_note.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.reason IS 'Reason';


--
-- Name: COLUMN account_debit_note.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.date IS 'Debit Note Date';


--
-- Name: COLUMN account_debit_note.copy_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.copy_lines IS 'Copy Lines';


--
-- Name: COLUMN account_debit_note.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.create_date IS 'Created on';


--
-- Name: COLUMN account_debit_note.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_debit_note.l10n_cl_edi_reference_doc_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.l10n_cl_edi_reference_doc_code IS 'SII Reference Code';


--
-- Name: COLUMN account_debit_note.l10n_cl_original_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.l10n_cl_original_text IS 'Original Text';


--
-- Name: COLUMN account_debit_note.l10n_cl_corrected_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.l10n_cl_corrected_text IS 'New Corrected Text';


--
-- Name: COLUMN account_debit_note.l10n_pe_edi_charge_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debit_note.l10n_pe_edi_charge_reason IS 'Debit Reason';


--
-- Name: account_debit_note_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_debit_note_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_debit_note_id_seq OWNER TO runbot;

--
-- Name: account_debit_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_debit_note_id_seq OWNED BY public.account_debit_note.id;


--
-- Name: account_debt_report_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_debt_report_wizard (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    result_selection character varying NOT NULL,
    from_date date,
    to_date date,
    show_invoice_detail boolean,
    historical_full boolean,
    company_currency boolean,
    secondary_currency boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_debt_report_wizard OWNER TO runbot;

--
-- Name: TABLE account_debt_report_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_debt_report_wizard IS 'Account Debt Report Wizard';


--
-- Name: COLUMN account_debt_report_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_debt_report_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_debt_report_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_debt_report_wizard.result_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.result_selection IS 'Account Type''s';


--
-- Name: COLUMN account_debt_report_wizard.from_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.from_date IS 'From Date';


--
-- Name: COLUMN account_debt_report_wizard.to_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.to_date IS 'To Date';


--
-- Name: COLUMN account_debt_report_wizard.show_invoice_detail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.show_invoice_detail IS 'Show Invoice Detail';


--
-- Name: COLUMN account_debt_report_wizard.historical_full; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.historical_full IS 'Historical Full';


--
-- Name: COLUMN account_debt_report_wizard.company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.company_currency IS 'Company Currency';


--
-- Name: COLUMN account_debt_report_wizard.secondary_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.secondary_currency IS 'Secondary Currency';


--
-- Name: COLUMN account_debt_report_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_debt_report_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_debt_report_wizard.write_date IS 'Last Updated on';


--
-- Name: account_debt_report_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_debt_report_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_debt_report_wizard_id_seq OWNER TO runbot;

--
-- Name: account_debt_report_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_debt_report_wizard_id_seq OWNED BY public.account_debt_report_wizard.id;


--
-- Name: account_direct_debit_mandate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_direct_debit_mandate (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    commercial_partner_id integer,
    company_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    description character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    partner_bank_id integer,
    credit_card_number character varying,
    partner_bbva_id character varying,
    partner_payer_id character varying
);


ALTER TABLE public.account_direct_debit_mandate OWNER TO runbot;

--
-- Name: TABLE account_direct_debit_mandate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_direct_debit_mandate IS 'Direct Debit Mandates';


--
-- Name: COLUMN account_direct_debit_mandate.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.partner_id IS 'Customer';


--
-- Name: COLUMN account_direct_debit_mandate.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_direct_debit_mandate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.company_id IS 'Company';


--
-- Name: COLUMN account_direct_debit_mandate.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.journal_id IS 'Journal';


--
-- Name: COLUMN account_direct_debit_mandate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.create_uid IS 'Created by';


--
-- Name: COLUMN account_direct_debit_mandate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_direct_debit_mandate.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.state IS 'State';


--
-- Name: COLUMN account_direct_debit_mandate.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.description IS 'Description';


--
-- Name: COLUMN account_direct_debit_mandate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.create_date IS 'Created on';


--
-- Name: COLUMN account_direct_debit_mandate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_direct_debit_mandate.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.partner_bank_id IS 'CBU';


--
-- Name: COLUMN account_direct_debit_mandate.credit_card_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.credit_card_number IS 'Credit Card Number';


--
-- Name: COLUMN account_direct_debit_mandate.partner_bbva_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.partner_bbva_id IS 'ID de Cliente BBVA';


--
-- Name: COLUMN account_direct_debit_mandate.partner_payer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_direct_debit_mandate.partner_payer_id IS 'ID de Cliente';


--
-- Name: account_direct_debit_mandate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_direct_debit_mandate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_direct_debit_mandate_id_seq OWNER TO runbot;

--
-- Name: account_direct_debit_mandate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_direct_debit_mandate_id_seq OWNED BY public.account_direct_debit_mandate.id;


--
-- Name: account_duplicate_transaction_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_duplicate_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_duplicate_transaction_wizard OWNER TO runbot;

--
-- Name: TABLE account_duplicate_transaction_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_duplicate_transaction_wizard IS 'Wizard for duplicate transactions';


--
-- Name: COLUMN account_duplicate_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_duplicate_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_duplicate_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_duplicate_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_duplicate_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_duplicate_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNER TO runbot;

--
-- Name: account_duplicate_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_duplicate_transaction_wizard_id_seq OWNED BY public.account_duplicate_transaction_wizard.id;


--
-- Name: account_edi_document; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_edi_document (
    id integer NOT NULL,
    move_id integer NOT NULL,
    edi_format_id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    blocking_level character varying,
    error text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_edi_document OWNER TO runbot;

--
-- Name: TABLE account_edi_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_edi_document IS 'Electronic Document for an account.move';


--
-- Name: COLUMN account_edi_document.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.move_id IS 'Move';


--
-- Name: COLUMN account_edi_document.edi_format_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.edi_format_id IS 'Edi Format';


--
-- Name: COLUMN account_edi_document.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.attachment_id IS 'Attachment';


--
-- Name: COLUMN account_edi_document.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.create_uid IS 'Created by';


--
-- Name: COLUMN account_edi_document.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_edi_document.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.state IS 'State';


--
-- Name: COLUMN account_edi_document.blocking_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.blocking_level IS 'Blocking Level';


--
-- Name: COLUMN account_edi_document.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.error IS 'Error';


--
-- Name: COLUMN account_edi_document.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.create_date IS 'Created on';


--
-- Name: COLUMN account_edi_document.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_document.write_date IS 'Last Updated on';


--
-- Name: account_edi_document_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_edi_document_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_edi_document_id_seq OWNER TO runbot;

--
-- Name: account_edi_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_edi_document_id_seq OWNED BY public.account_edi_document.id;


--
-- Name: account_edi_format; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_edi_format (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_edi_format OWNER TO runbot;

--
-- Name: TABLE account_edi_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_edi_format IS 'EDI format';


--
-- Name: COLUMN account_edi_format.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_edi_format.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_edi_format.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.name IS 'Name';


--
-- Name: COLUMN account_edi_format.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.code IS 'Code';


--
-- Name: COLUMN account_edi_format.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.create_date IS 'Created on';


--
-- Name: COLUMN account_edi_format.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_edi_format.write_date IS 'Last Updated on';


--
-- Name: account_edi_format_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_edi_format_account_journal_rel (
    account_journal_id integer NOT NULL,
    account_edi_format_id integer NOT NULL
);


ALTER TABLE public.account_edi_format_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_edi_format_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_edi_format_account_journal_rel IS 'RELATION BETWEEN account_journal AND account_edi_format';


--
-- Name: account_edi_format_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_edi_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_edi_format_id_seq OWNER TO runbot;

--
-- Name: account_edi_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_edi_format_id_seq OWNED BY public.account_edi_format.id;


--
-- Name: account_exchange_diff_invoice; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_exchange_diff_invoice (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_exchange_diff_invoice OWNER TO runbot;

--
-- Name: TABLE account_exchange_diff_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_exchange_diff_invoice IS 'account.exchange_diff_invoice';


--
-- Name: COLUMN account_exchange_diff_invoice.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.company_id IS 'Company';


--
-- Name: COLUMN account_exchange_diff_invoice.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.create_uid IS 'Created by';


--
-- Name: COLUMN account_exchange_diff_invoice.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_exchange_diff_invoice.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.create_date IS 'Created on';


--
-- Name: COLUMN account_exchange_diff_invoice.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice.write_date IS 'Last Updated on';


--
-- Name: account_exchange_diff_invoice_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_exchange_diff_invoice_account_move_rel (
    account_exchange_diff_invoice_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_exchange_diff_invoice_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_exchange_diff_invoice_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_exchange_diff_invoice_account_move_rel IS 'RELATION BETWEEN account_exchange_diff_invoice AND account_move';


--
-- Name: account_exchange_diff_invoice_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_exchange_diff_invoice_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_exchange_diff_invoice_id_seq OWNER TO runbot;

--
-- Name: account_exchange_diff_invoice_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_exchange_diff_invoice_id_seq OWNED BY public.account_exchange_diff_invoice.id;


--
-- Name: account_exchange_diff_invoice_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_exchange_diff_invoice_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partial_line_id integer,
    create_uid integer,
    write_uid integer,
    debit_name character varying,
    credit_name character varying,
    debit_date date,
    credit_date date,
    credit_date_maturity date,
    reconciled_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    debit_rate double precision,
    credit_rate double precision
);


ALTER TABLE public.account_exchange_diff_invoice_line OWNER TO runbot;

--
-- Name: TABLE account_exchange_diff_invoice_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_exchange_diff_invoice_line IS 'account.exchange_diff_invoice.line';


--
-- Name: COLUMN account_exchange_diff_invoice_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_exchange_diff_invoice_line.partial_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.partial_line_id IS 'Partial Line';


--
-- Name: COLUMN account_exchange_diff_invoice_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_exchange_diff_invoice_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_exchange_diff_invoice_line.debit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.debit_name IS 'Debit Name';


--
-- Name: COLUMN account_exchange_diff_invoice_line.credit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.credit_name IS 'Credit Name';


--
-- Name: COLUMN account_exchange_diff_invoice_line.debit_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.debit_date IS 'Debit Date';


--
-- Name: COLUMN account_exchange_diff_invoice_line.credit_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.credit_date IS 'Credit Date';


--
-- Name: COLUMN account_exchange_diff_invoice_line.credit_date_maturity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.credit_date_maturity IS 'Due date';


--
-- Name: COLUMN account_exchange_diff_invoice_line.reconciled_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.reconciled_amount IS 'Importe';


--
-- Name: COLUMN account_exchange_diff_invoice_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.create_date IS 'Created on';


--
-- Name: COLUMN account_exchange_diff_invoice_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_exchange_diff_invoice_line.debit_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.debit_rate IS 'Debit Rate';


--
-- Name: COLUMN account_exchange_diff_invoice_line.credit_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_diff_invoice_line.credit_rate IS 'Credit Rate';


--
-- Name: account_exchange_diff_invoice_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_exchange_diff_invoice_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_exchange_diff_invoice_line_id_seq OWNER TO runbot;

--
-- Name: account_exchange_diff_invoice_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_exchange_diff_invoice_line_id_seq OWNED BY public.account_exchange_diff_invoice_line.id;


--
-- Name: account_exchange_difference_line_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_exchange_difference_line_wizard (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    balance numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_exchange_difference_line_wizard OWNER TO runbot;

--
-- Name: TABLE account_exchange_difference_line_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_exchange_difference_line_wizard IS 'Exchange Difference Line Wizard';


--
-- Name: COLUMN account_exchange_difference_line_wizard.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_line_wizard.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_exchange_difference_line_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_line_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN account_exchange_difference_line_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_line_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_exchange_difference_line_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_line_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_exchange_difference_line_wizard.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_line_wizard.balance IS 'Balance';


--
-- Name: COLUMN account_exchange_difference_line_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_line_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_exchange_difference_line_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_line_wizard.write_date IS 'Last Updated on';


--
-- Name: account_exchange_difference_line_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_exchange_difference_line_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_exchange_difference_line_wizard_id_seq OWNER TO runbot;

--
-- Name: account_exchange_difference_line_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_exchange_difference_line_wizard_id_seq OWNED BY public.account_exchange_difference_line_wizard.id;


--
-- Name: account_exchange_difference_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_exchange_difference_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    journal_id integer NOT NULL,
    fiscal_position_id integer,
    create_uid integer,
    write_uid integer,
    fiscal_position character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_exchange_difference_wizard OWNER TO runbot;

--
-- Name: TABLE account_exchange_difference_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_exchange_difference_wizard IS 'Exchange Difference Wizard';


--
-- Name: COLUMN account_exchange_difference_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_exchange_difference_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_exchange_difference_wizard.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_wizard.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_exchange_difference_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_exchange_difference_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_exchange_difference_wizard.fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_wizard.fiscal_position IS 'Fiscal Position Mode';


--
-- Name: COLUMN account_exchange_difference_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_exchange_difference_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_exchange_difference_wizard.write_date IS 'Last Updated on';


--
-- Name: account_exchange_difference_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_exchange_difference_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_exchange_difference_wizard_id_seq OWNER TO runbot;

--
-- Name: account_exchange_difference_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_exchange_difference_wizard_id_seq OWNED BY public.account_exchange_difference_wizard.id;


--
-- Name: account_financial_year_op; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_financial_year_op (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_financial_year_op OWNER TO runbot;

--
-- Name: TABLE account_financial_year_op; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_financial_year_op IS 'Opening Balance of Financial Year';


--
-- Name: COLUMN account_financial_year_op.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.company_id IS 'Company';


--
-- Name: COLUMN account_financial_year_op.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_uid IS 'Created by';


--
-- Name: COLUMN account_financial_year_op.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_financial_year_op.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.create_date IS 'Created on';


--
-- Name: COLUMN account_financial_year_op.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_financial_year_op.write_date IS 'Last Updated on';


--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_financial_year_op_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_financial_year_op_id_seq OWNER TO runbot;

--
-- Name: account_financial_year_op_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_financial_year_op_id_seq OWNED BY public.account_financial_year_op.id;


--
-- Name: account_fiscal_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_category (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_category OWNER TO runbot;

--
-- Name: TABLE account_fiscal_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_category IS 'Account Fiscal Category';


--
-- Name: COLUMN account_fiscal_category.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_category.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.code IS 'Code';


--
-- Name: COLUMN account_fiscal_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.name IS 'Name';


--
-- Name: COLUMN account_fiscal_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.active IS 'Active';


--
-- Name: COLUMN account_fiscal_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_category.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_category_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_category_id_seq OWNED BY public.account_fiscal_category.id;


--
-- Name: account_fiscal_position; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    country_id integer,
    country_group_id integer,
    create_uid integer,
    write_uid integer,
    zip_from character varying,
    zip_to character varying,
    foreign_vat character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    auto_apply boolean,
    vat_required boolean,
    is_domestic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    avatax_invoice_account_id integer,
    avatax_refund_account_id integer,
    is_avatax boolean,
    deduct_price_included_taxes boolean
);


ALTER TABLE public.account_fiscal_position OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.sequence IS 'Sequence';


--
-- Name: COLUMN account_fiscal_position.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_id IS 'Country';


--
-- Name: COLUMN account_fiscal_position.country_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.country_group_id IS 'Country Group';


--
-- Name: COLUMN account_fiscal_position.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position.zip_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_from IS 'Zip Range From';


--
-- Name: COLUMN account_fiscal_position.zip_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.zip_to IS 'Zip Range To';


--
-- Name: COLUMN account_fiscal_position.foreign_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.foreign_vat IS 'Foreign Tax ID';


--
-- Name: COLUMN account_fiscal_position.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.name IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.note IS 'Notes';


--
-- Name: COLUMN account_fiscal_position.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.active IS 'Active';


--
-- Name: COLUMN account_fiscal_position.auto_apply; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.auto_apply IS 'Detect Automatically';


--
-- Name: COLUMN account_fiscal_position.vat_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.vat_required IS 'VAT required';


--
-- Name: COLUMN account_fiscal_position.is_domestic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.is_domestic IS 'Is Domestic';


--
-- Name: COLUMN account_fiscal_position.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position.avatax_invoice_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_invoice_account_id IS 'Avatax Invoice Account';


--
-- Name: COLUMN account_fiscal_position.avatax_refund_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.avatax_refund_account_id IS 'Avatax Refund Account';


--
-- Name: COLUMN account_fiscal_position.is_avatax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.is_avatax IS 'Use AvaTax API';


--
-- Name: COLUMN account_fiscal_position.deduct_price_included_taxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position.deduct_price_included_taxes IS 'Deduct Price-Included Taxes';


--
-- Name: account_fiscal_position_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account (
    id integer NOT NULL,
    position_id integer NOT NULL,
    company_id integer,
    account_src_id integer NOT NULL,
    account_dest_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_position_account OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account IS 'Accounts Mapping of Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_account.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_position_account.account_src_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_src_id IS 'Account on Product';


--
-- Name: COLUMN account_fiscal_position_account.account_dest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.account_dest_id IS 'Account to Use Instead';


--
-- Name: COLUMN account_fiscal_position_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_account.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_account_id_seq OWNED BY public.account_fiscal_position_account.id;


--
-- Name: account_fiscal_position_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_account_tax_rel (
    account_fiscal_position_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_account_tax_rel IS 'RELATION BETWEEN account_fiscal_position AND account_tax';


--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_id_seq OWNED BY public.account_fiscal_position.id;


--
-- Name: account_fiscal_position_l10n_ar_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_l10n_ar_tax (
    id integer NOT NULL,
    fiscal_position_id integer NOT NULL,
    default_tax_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    webservice character varying,
    tax_type character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    python_formula text
);


ALTER TABLE public.account_fiscal_position_l10n_ar_tax OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_l10n_ar_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_l10n_ar_tax IS 'account.fiscal.position.l10n_ar_tax';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.default_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.default_tax_id IS 'Default Tax';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.webservice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.webservice IS 'Webservice';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.tax_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.tax_type IS 'Tax Type';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_fiscal_position_l10n_ar_tax.python_formula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_position_l10n_ar_tax.python_formula IS 'Python Formula';


--
-- Name: account_fiscal_position_l10n_ar_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_position_l10n_ar_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_position_l10n_ar_tax_id_seq OWNED BY public.account_fiscal_position_l10n_ar_tax.id;


--
-- Name: account_fiscal_position_pos_config_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_pos_config_rel (
    pos_config_id integer NOT NULL,
    account_fiscal_position_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_pos_config_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_pos_config_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_pos_config_rel IS 'RELATION BETWEEN pos_config AND account_fiscal_position';


--
-- Name: account_fiscal_position_res_config_settings_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_res_config_settings_rel (
    res_config_settings_id integer NOT NULL,
    account_fiscal_position_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_config_settings_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_res_config_settings_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_res_config_settings_rel IS 'RELATION BETWEEN res_config_settings AND account_fiscal_position';


--
-- Name: account_fiscal_position_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_position_res_country_state_rel (
    account_fiscal_position_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.account_fiscal_position_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE account_fiscal_position_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_position_res_country_state_rel IS 'RELATION BETWEEN account_fiscal_position AND res_country_state';


--
-- Name: account_fiscal_year; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_fiscal_year (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_fiscal_year OWNER TO runbot;

--
-- Name: TABLE account_fiscal_year; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_fiscal_year IS 'Fiscal Year';


--
-- Name: COLUMN account_fiscal_year.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.company_id IS 'Company';


--
-- Name: COLUMN account_fiscal_year.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_uid IS 'Created by';


--
-- Name: COLUMN account_fiscal_year.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_fiscal_year.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.name IS 'Name';


--
-- Name: COLUMN account_fiscal_year.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_from IS 'Start Date';


--
-- Name: COLUMN account_fiscal_year.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.date_to IS 'End Date';


--
-- Name: COLUMN account_fiscal_year.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.create_date IS 'Created on';


--
-- Name: COLUMN account_fiscal_year.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_fiscal_year.write_date IS 'Last Updated on';


--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_fiscal_year_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_fiscal_year_id_seq OWNER TO runbot;

--
-- Name: account_fiscal_year_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_fiscal_year_id_seq OWNED BY public.account_fiscal_year.id;


--
-- Name: account_followup_followup_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_followup_line (
    id integer NOT NULL,
    delay integer NOT NULL,
    company_id integer NOT NULL,
    mail_template_id integer,
    sms_template_id integer,
    activity_type_id integer,
    create_uid integer,
    write_uid integer,
    activity_summary character varying,
    activity_default_responsible_type character varying NOT NULL,
    name jsonb NOT NULL,
    activity_note text,
    send_email boolean,
    join_invoices boolean,
    send_sms boolean,
    create_activity boolean,
    auto_execute boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    send_letter boolean,
    whatsapp_template_id integer,
    send_whatsapp boolean
);


ALTER TABLE public.account_followup_followup_line OWNER TO runbot;

--
-- Name: TABLE account_followup_followup_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_followup_line IS 'Follow-up Criteria';


--
-- Name: COLUMN account_followup_followup_line.delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.delay IS 'Due Days';


--
-- Name: COLUMN account_followup_followup_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.company_id IS 'Company';


--
-- Name: COLUMN account_followup_followup_line.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.mail_template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_followup_line.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_followup_line.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN account_followup_followup_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_followup_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_followup_line.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_summary IS 'Summary';


--
-- Name: COLUMN account_followup_followup_line.activity_default_responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_default_responsible_type IS 'Responsible';


--
-- Name: COLUMN account_followup_followup_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.name IS 'Description';


--
-- Name: COLUMN account_followup_followup_line.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.activity_note IS 'Note';


--
-- Name: COLUMN account_followup_followup_line.send_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_email IS 'Email';


--
-- Name: COLUMN account_followup_followup_line.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_followup_line.send_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_sms IS 'SMS';


--
-- Name: COLUMN account_followup_followup_line.create_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_activity IS 'Schedule Activity';


--
-- Name: COLUMN account_followup_followup_line.auto_execute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.auto_execute IS 'Automatic';


--
-- Name: COLUMN account_followup_followup_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_followup_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_followup_line.send_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_letter IS 'Letter';


--
-- Name: COLUMN account_followup_followup_line.whatsapp_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.whatsapp_template_id IS 'Whatsapp Template';


--
-- Name: COLUMN account_followup_followup_line.send_whatsapp; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_followup_line.send_whatsapp IS 'WhatsApp';


--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_followup_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNER TO runbot;

--
-- Name: account_followup_followup_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_followup_line_id_seq OWNED BY public.account_followup_followup_line.id;


--
-- Name: account_followup_followup_line_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_followup_line_res_users_rel (
    account_followup_followup_line_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.account_followup_followup_line_res_users_rel OWNER TO runbot;

--
-- Name: TABLE account_followup_followup_line_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_followup_line_res_users_rel IS 'RELATION BETWEEN account_followup_followup_line AND res_users';


--
-- Name: account_followup_manual_reminder; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder (
    id integer NOT NULL,
    template_id integer,
    partner_id integer,
    sms_template_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    sms_body character varying,
    body text,
    email boolean,
    sms boolean,
    print boolean,
    join_invoices boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    snailmail boolean,
    attachment_id integer,
    wa_template_id integer,
    res_ids character varying NOT NULL,
    res_model character varying NOT NULL,
    phone character varying,
    header_text_1 character varying,
    free_text_1 character varying,
    free_text_2 character varying,
    free_text_3 character varying,
    free_text_4 character varying,
    free_text_5 character varying,
    free_text_6 character varying,
    free_text_7 character varying,
    free_text_8 character varying,
    free_text_9 character varying,
    free_text_10 character varying,
    button_dynamic_url_1 character varying,
    button_dynamic_url_2 character varying,
    batch_mode boolean,
    whatsapp boolean
);


ALTER TABLE public.account_followup_manual_reminder OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder IS 'Wizard for sending manual reminders to clients';


--
-- Name: COLUMN account_followup_manual_reminder.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.template_id IS 'Mail Template';


--
-- Name: COLUMN account_followup_manual_reminder.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.partner_id IS 'Partner';


--
-- Name: COLUMN account_followup_manual_reminder.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN account_followup_manual_reminder.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_manual_reminder.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_manual_reminder.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.lang IS 'Language';


--
-- Name: COLUMN account_followup_manual_reminder.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.subject IS 'Subject';


--
-- Name: COLUMN account_followup_manual_reminder.sms_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms_body IS 'Sms Body';


--
-- Name: COLUMN account_followup_manual_reminder.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.body IS 'Contents';


--
-- Name: COLUMN account_followup_manual_reminder.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.email IS 'Email';


--
-- Name: COLUMN account_followup_manual_reminder.sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.sms IS 'Sms';


--
-- Name: COLUMN account_followup_manual_reminder.print; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.print IS 'Print';


--
-- Name: COLUMN account_followup_manual_reminder.join_invoices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.join_invoices IS 'Attach Invoices';


--
-- Name: COLUMN account_followup_manual_reminder.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_manual_reminder.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_followup_manual_reminder.snailmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.snailmail IS 'Snailmail';


--
-- Name: COLUMN account_followup_manual_reminder.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.attachment_id IS 'WhatsApp attachment';


--
-- Name: COLUMN account_followup_manual_reminder.wa_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.wa_template_id IS 'Template';


--
-- Name: COLUMN account_followup_manual_reminder.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.res_ids IS 'Document IDs';


--
-- Name: COLUMN account_followup_manual_reminder.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.res_model IS 'Document Model Name';


--
-- Name: COLUMN account_followup_manual_reminder.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.phone IS 'Phone';


--
-- Name: COLUMN account_followup_manual_reminder.header_text_1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.header_text_1 IS 'Header Free Text';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_1 IS 'Free Text 1';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_2 IS 'Free Text 2';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_3; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_3 IS 'Free Text 3';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_4; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_4 IS 'Free Text 4';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_5; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_5 IS 'Free Text 5';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_6; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_6 IS 'Free Text 6';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_7; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_7 IS 'Free Text 7';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_8; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_8 IS 'Free Text 8';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_9; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_9 IS 'Free Text 9';


--
-- Name: COLUMN account_followup_manual_reminder.free_text_10; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.free_text_10 IS 'Free Text 10';


--
-- Name: COLUMN account_followup_manual_reminder.button_dynamic_url_1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.button_dynamic_url_1 IS 'Button Url 1';


--
-- Name: COLUMN account_followup_manual_reminder.button_dynamic_url_2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.button_dynamic_url_2 IS 'Button Url 2';


--
-- Name: COLUMN account_followup_manual_reminder.batch_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.batch_mode IS 'Is Multiple Records';


--
-- Name: COLUMN account_followup_manual_reminder.whatsapp; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_manual_reminder.whatsapp IS 'Whatsapp';


--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_manual_reminder_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNER TO runbot;

--
-- Name: account_followup_manual_reminder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_manual_reminder_id_seq OWNED BY public.account_followup_manual_reminder.id;


--
-- Name: account_followup_manual_reminder_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_manual_reminder_ir_attachment_rel (
    account_followup_manual_reminder_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_followup_manual_reminder_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_followup_manual_reminder_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_manual_reminder_ir_attachment_rel IS 'RELATION BETWEEN account_followup_manual_reminder AND ir_attachment';


--
-- Name: account_followup_missing_information_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_followup_missing_information_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_followup_missing_information_wizard OWNER TO runbot;

--
-- Name: TABLE account_followup_missing_information_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_followup_missing_information_wizard IS 'Followup missing information wizard';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_followup_missing_information_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_followup_missing_information_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_followup_missing_information_wizard.write_date IS 'Last Updated on';


--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_followup_missing_information_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNER TO runbot;

--
-- Name: account_followup_missing_information_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_followup_missing_information_wizard_id_seq OWNED BY public.account_followup_missing_information_wizard.id;


--
-- Name: account_full_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_full_reconcile (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_full_reconcile OWNER TO runbot;

--
-- Name: TABLE account_full_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_full_reconcile IS 'Full Reconcile';


--
-- Name: COLUMN account_full_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_full_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_full_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_full_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_full_reconcile.write_date IS 'Last Updated on';


--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_full_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_full_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_full_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_full_reconcile_id_seq OWNED BY public.account_full_reconcile.id;


--
-- Name: account_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_group (
    id integer NOT NULL,
    parent_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code_prefix_start character varying,
    code_prefix_end character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_group_check_length_prefix CHECK ((char_length((COALESCE(code_prefix_start, ''::character varying))::text) = char_length((COALESCE(code_prefix_end, ''::character varying))::text)))
);


ALTER TABLE public.account_group OWNER TO runbot;

--
-- Name: TABLE account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_group IS 'Account Group';


--
-- Name: COLUMN account_group.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.parent_id IS 'Parent';


--
-- Name: COLUMN account_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.company_id IS 'Company';


--
-- Name: COLUMN account_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_group.code_prefix_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_start IS 'Code Prefix Start';


--
-- Name: COLUMN account_group.code_prefix_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.code_prefix_end IS 'Code Prefix End';


--
-- Name: COLUMN account_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.name IS 'Name';


--
-- Name: COLUMN account_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.create_date IS 'Created on';


--
-- Name: COLUMN account_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_group.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_group_check_length_prefix ON account_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_group_check_length_prefix ON public.account_group IS 'CHECK(char_length(COALESCE(code_prefix_start, '''')) = char_length(COALESCE(code_prefix_end, '''')))';


--
-- Name: account_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_group_id_seq OWNER TO runbot;

--
-- Name: account_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_group_id_seq OWNED BY public.account_group.id;


--
-- Name: account_import_summary; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    import_summary_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    account_opening_move_id integer
);


ALTER TABLE public.account_import_summary OWNER TO runbot;

--
-- Name: TABLE account_import_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary IS 'Account import summary view';


--
-- Name: COLUMN account_import_summary.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.create_uid IS 'Created by';


--
-- Name: COLUMN account_import_summary.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_import_summary.import_summary_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.import_summary_name IS 'Import Summary Name';


--
-- Name: COLUMN account_import_summary.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.create_date IS 'Created on';


--
-- Name: COLUMN account_import_summary.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_import_summary.account_opening_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_import_summary.account_opening_move_id IS 'Asiento de Apertura';


--
-- Name: account_import_summary_account_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_account_journal_rel (
    account_import_summary_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_account_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_account_journal_rel IS 'RELATION BETWEEN account_import_summary AND account_journal';


--
-- Name: account_import_summary_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_account_move_rel (
    account_import_summary_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_account_move_rel IS 'RELATION BETWEEN account_import_summary AND account_move';


--
-- Name: account_import_summary_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_account_tax_rel (
    account_import_summary_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_account_tax_rel IS 'RELATION BETWEEN account_import_summary AND account_tax';


--
-- Name: account_import_summary_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_import_summary_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_import_summary_id_seq OWNER TO runbot;

--
-- Name: account_import_summary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_import_summary_id_seq OWNED BY public.account_import_summary.id;


--
-- Name: account_import_summary_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_import_summary_res_partner_rel (
    account_import_summary_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_import_summary_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_import_summary_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_import_summary_res_partner_rel IS 'RELATION BETWEEN account_import_summary AND res_partner';


--
-- Name: account_incoterms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_incoterms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying(3) NOT NULL,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_incoterms OWNER TO runbot;

--
-- Name: TABLE account_incoterms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_incoterms IS 'Incoterms';


--
-- Name: COLUMN account_incoterms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_uid IS 'Created by';


--
-- Name: COLUMN account_incoterms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_incoterms.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.code IS 'Code';


--
-- Name: COLUMN account_incoterms.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.name IS 'Name';


--
-- Name: COLUMN account_incoterms.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.active IS 'Active';


--
-- Name: COLUMN account_incoterms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.create_date IS 'Created on';


--
-- Name: COLUMN account_incoterms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_incoterms.write_date IS 'Last Updated on';


--
-- Name: account_incoterms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_incoterms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_incoterms_id_seq OWNER TO runbot;

--
-- Name: account_incoterms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_incoterms_id_seq OWNED BY public.account_incoterms.id;


--
-- Name: account_invoice_commission_inv_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_commission_inv_rel (
    commissioned_id integer NOT NULL,
    commission_id integer NOT NULL
);


ALTER TABLE public.account_invoice_commission_inv_rel OWNER TO runbot;

--
-- Name: TABLE account_invoice_commission_inv_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_commission_inv_rel IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: account_invoice_partial_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_partial_wizard (
    id integer NOT NULL,
    invoice_id integer,
    create_uid integer,
    write_uid integer,
    rounding_method character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    percentage_to_invoice double precision NOT NULL,
    rounding double precision NOT NULL
);


ALTER TABLE public.account_invoice_partial_wizard OWNER TO runbot;

--
-- Name: TABLE account_invoice_partial_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_partial_wizard IS 'Account Invoice Partial Wizard';


--
-- Name: COLUMN account_invoice_partial_wizard.invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.invoice_id IS 'Invoice';


--
-- Name: COLUMN account_invoice_partial_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_partial_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_partial_wizard.rounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.rounding_method IS 'Rounding Method';


--
-- Name: COLUMN account_invoice_partial_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_partial_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_invoice_partial_wizard.percentage_to_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.percentage_to_invoice IS 'Percentage To Invoice';


--
-- Name: COLUMN account_invoice_partial_wizard.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_partial_wizard.rounding IS 'Rounding Precision';


--
-- Name: account_invoice_partial_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_partial_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_partial_wizard_id_seq OWNER TO runbot;

--
-- Name: account_invoice_partial_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_partial_wizard_id_seq OWNED BY public.account_invoice_partial_wizard.id;


--
-- Name: account_invoice_prices_update_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_prices_update_wizard (
    id integer NOT NULL,
    pricelist_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_invoice_prices_update_wizard OWNER TO runbot;

--
-- Name: TABLE account_invoice_prices_update_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_prices_update_wizard IS 'account.invoice.prices_update.wizard';


--
-- Name: COLUMN account_invoice_prices_update_wizard.pricelist_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.pricelist_id IS 'Pricelist';


--
-- Name: COLUMN account_invoice_prices_update_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_prices_update_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_prices_update_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_prices_update_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_prices_update_wizard.write_date IS 'Last Updated on';


--
-- Name: account_invoice_prices_update_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_prices_update_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_prices_update_wizard_id_seq OWNER TO runbot;

--
-- Name: account_invoice_prices_update_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_prices_update_wizard_id_seq OWNED BY public.account_invoice_prices_update_wizard.id;


--
-- Name: account_invoice_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_tax (
    id integer NOT NULL,
    move_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_invoice_tax OWNER TO runbot;

--
-- Name: TABLE account_invoice_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_tax IS 'Account Invoice Tax';


--
-- Name: COLUMN account_invoice_tax.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.move_id IS 'Move';


--
-- Name: COLUMN account_invoice_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax.write_date IS 'Last Updated on';


--
-- Name: account_invoice_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_tax_id_seq OWNER TO runbot;

--
-- Name: account_invoice_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_tax_id_seq OWNED BY public.account_invoice_tax.id;


--
-- Name: account_invoice_tax_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_tax_line (
    id integer NOT NULL,
    invoice_tax_id integer,
    tax_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    amount numeric,
    new_tax boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_invoice_tax_line OWNER TO runbot;

--
-- Name: TABLE account_invoice_tax_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_tax_line IS 'Account Invoice Tax line';


--
-- Name: COLUMN account_invoice_tax_line.invoice_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.invoice_tax_id IS 'Invoice Tax';


--
-- Name: COLUMN account_invoice_tax_line.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.tax_id IS 'Tax';


--
-- Name: COLUMN account_invoice_tax_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_invoice_tax_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_invoice_tax_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.amount IS 'Amount';


--
-- Name: COLUMN account_invoice_tax_line.new_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.new_tax IS 'New Tax';


--
-- Name: COLUMN account_invoice_tax_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.create_date IS 'Created on';


--
-- Name: COLUMN account_invoice_tax_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_invoice_tax_line.write_date IS 'Last Updated on';


--
-- Name: account_invoice_tax_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_invoice_tax_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_invoice_tax_line_id_seq OWNER TO runbot;

--
-- Name: account_invoice_tax_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_invoice_tax_line_id_seq OWNED BY public.account_invoice_tax_line.id;


--
-- Name: account_invoice_transaction_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_invoice_transaction_rel (
    invoice_id integer NOT NULL,
    transaction_id integer NOT NULL
);


ALTER TABLE public.account_invoice_transaction_rel OWNER TO runbot;

--
-- Name: TABLE account_invoice_transaction_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_invoice_transaction_rel IS 'RELATION BETWEEN account_move AND payment_transaction';


--
-- Name: account_journal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal (
    id integer NOT NULL,
    alias_id integer,
    default_account_id integer,
    suspense_account_id integer,
    non_deductible_account_id integer,
    sequence integer,
    currency_id integer,
    company_id integer NOT NULL,
    invoice_template_pdf_report_id integer,
    profit_account_id integer,
    loss_account_id integer,
    bank_account_id integer,
    create_uid integer,
    write_uid integer,
    color integer,
    access_token character varying,
    code character varying(5) NOT NULL,
    type character varying NOT NULL,
    invoice_reference_type character varying NOT NULL,
    invoice_reference_model character varying NOT NULL,
    bank_statements_source character varying,
    incoming_einvoice_notification_email character varying,
    name jsonb NOT NULL,
    sequence_override_regex text,
    active boolean,
    is_self_billing boolean,
    restrict_mode_hash_table boolean,
    refund_sequence boolean,
    payment_sequence boolean,
    show_on_dashboard boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    check_sequence_id integer,
    bank_check_printing_layout character varying,
    check_manual_sequencing boolean,
    debit_sequence boolean,
    direct_debit_format character varying,
    account_online_account_id integer,
    account_online_link_id integer,
    l10n_latam_use_documents boolean,
    nacha_immediate_destination character varying,
    nacha_destination character varying,
    nacha_immediate_origin character varying,
    nacha_company_identification character varying,
    nacha_origination_dfi_identification character varying,
    nacha_entry_class_code character varying NOT NULL,
    nacha_discretionary_data character varying(20),
    nacha_is_balanced boolean,
    book_group_id integer,
    mail_template_id integer,
    branch_order integer,
    shared_to_branches boolean,
    l10n_ar_afip_pos_number integer,
    l10n_ar_afip_pos_partner_id integer,
    l10n_ar_afip_pos_system character varying,
    l10n_ar_is_pos boolean,
    direct_debit_merchant_number character varying,
    account_number character varying,
    default_sheet_mapping_id integer,
    qr_code_label character varying,
    qr_code character varying,
    discriminate_taxes character varying NOT NULL,
    l10n_cl_point_of_sale_number integer,
    l10n_cl_point_of_sale_type character varying,
    l10n_cl_point_of_sale_name character varying,
    check_add_debit_button boolean,
    l10n_uy_edi_type character varying,
    l10n_uy_edi_send_print boolean,
    loan_properties_definition jsonb,
    sepa_pain_version character varying,
    iso20022_default_priority character varying NOT NULL,
    iso20022_charge_bearer character varying
);


ALTER TABLE public.account_journal OWNER TO runbot;

--
-- Name: TABLE account_journal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal IS 'Journal';


--
-- Name: COLUMN account_journal.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.alias_id IS 'Alias';


--
-- Name: COLUMN account_journal.default_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.default_account_id IS 'Default Account';


--
-- Name: COLUMN account_journal.suspense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.suspense_account_id IS 'Suspense Account';


--
-- Name: COLUMN account_journal.non_deductible_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.non_deductible_account_id IS 'Private Share Account';


--
-- Name: COLUMN account_journal.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.currency_id IS 'Currency';


--
-- Name: COLUMN account_journal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.company_id IS 'Company';


--
-- Name: COLUMN account_journal.invoice_template_pdf_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_template_pdf_report_id IS 'Invoice report';


--
-- Name: COLUMN account_journal.profit_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.profit_account_id IS 'Profit Account';


--
-- Name: COLUMN account_journal.loss_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loss_account_id IS 'Loss Account';


--
-- Name: COLUMN account_journal.bank_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_account_id IS 'Bank Account';


--
-- Name: COLUMN account_journal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.color IS 'Color Index';


--
-- Name: COLUMN account_journal.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.access_token IS 'Security Token';


--
-- Name: COLUMN account_journal.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.code IS 'Sequence Prefix';


--
-- Name: COLUMN account_journal.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.type IS 'Type';


--
-- Name: COLUMN account_journal.invoice_reference_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_type IS 'Communication Type';


--
-- Name: COLUMN account_journal.invoice_reference_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.invoice_reference_model IS 'Communication Standard';


--
-- Name: COLUMN account_journal.bank_statements_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_statements_source IS 'Bank Feeds';


--
-- Name: COLUMN account_journal.incoming_einvoice_notification_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.incoming_einvoice_notification_email IS 'Send Copy To';


--
-- Name: COLUMN account_journal.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.name IS 'Journal Name';


--
-- Name: COLUMN account_journal.sequence_override_regex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sequence_override_regex IS 'Sequence Override Regex';


--
-- Name: COLUMN account_journal.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.active IS 'Active';


--
-- Name: COLUMN account_journal.is_self_billing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.is_self_billing IS 'Self Billing';


--
-- Name: COLUMN account_journal.restrict_mode_hash_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.restrict_mode_hash_table IS 'Secure Posted Entries with Hash';


--
-- Name: COLUMN account_journal.refund_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.refund_sequence IS 'Dedicated Credit Note Sequence';


--
-- Name: COLUMN account_journal.payment_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.payment_sequence IS 'Dedicated Payment Sequence';


--
-- Name: COLUMN account_journal.show_on_dashboard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.show_on_dashboard IS 'Show journal on dashboard';


--
-- Name: COLUMN account_journal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.create_date IS 'Created on';


--
-- Name: COLUMN account_journal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_journal.check_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_sequence_id IS 'Check Sequence';


--
-- Name: COLUMN account_journal.bank_check_printing_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.bank_check_printing_layout IS 'Check Layout';


--
-- Name: COLUMN account_journal.check_manual_sequencing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_manual_sequencing IS 'Manual Numbering';


--
-- Name: COLUMN account_journal.debit_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.debit_sequence IS 'Dedicated Debit Note Sequence';


--
-- Name: COLUMN account_journal.direct_debit_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.direct_debit_format IS 'Direct Debit Format';


--
-- Name: COLUMN account_journal.account_online_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_account_id IS 'Account Online Account';


--
-- Name: COLUMN account_journal.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_journal.l10n_latam_use_documents; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_latam_use_documents IS 'Use Documents?';


--
-- Name: COLUMN account_journal.nacha_immediate_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_destination IS 'Immediate Destination';


--
-- Name: COLUMN account_journal.nacha_destination; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_destination IS 'Destination';


--
-- Name: COLUMN account_journal.nacha_immediate_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_immediate_origin IS 'Immediate Origin';


--
-- Name: COLUMN account_journal.nacha_company_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_company_identification IS 'Company Identification';


--
-- Name: COLUMN account_journal.nacha_origination_dfi_identification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_origination_dfi_identification IS 'Origination Dfi Identification';


--
-- Name: COLUMN account_journal.nacha_entry_class_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_entry_class_code IS 'Standard Entry Class Code';


--
-- Name: COLUMN account_journal.nacha_discretionary_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_discretionary_data IS 'Company Discretionary Data';


--
-- Name: COLUMN account_journal.nacha_is_balanced; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.nacha_is_balanced IS 'Generate Balanced Files';


--
-- Name: COLUMN account_journal.book_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.book_group_id IS 'Journal Book Report';


--
-- Name: COLUMN account_journal.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.mail_template_id IS 'Email Template';


--
-- Name: COLUMN account_journal.branch_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.branch_order IS 'Branch Order';


--
-- Name: COLUMN account_journal.shared_to_branches; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.shared_to_branches IS 'Shared To Branches';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_number IS 'ARCA POS Number';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_partner_id IS 'ARCA POS Address';


--
-- Name: COLUMN account_journal.l10n_ar_afip_pos_system; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_afip_pos_system IS 'ARCA POS System';


--
-- Name: COLUMN account_journal.l10n_ar_is_pos; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_ar_is_pos IS 'Is ARCA POS?';


--
-- Name: COLUMN account_journal.direct_debit_merchant_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.direct_debit_merchant_number IS 'Número de comercio';


--
-- Name: COLUMN account_journal.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.account_number IS 'Número de cuenta de débito';


--
-- Name: COLUMN account_journal.default_sheet_mapping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.default_sheet_mapping_id IS 'Default Sheet Mapping';


--
-- Name: COLUMN account_journal.qr_code_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code_label IS 'QR Code Label';


--
-- Name: COLUMN account_journal.qr_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.qr_code IS 'QR Code';


--
-- Name: COLUMN account_journal.discriminate_taxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.discriminate_taxes IS 'Discriminate taxes?';


--
-- Name: COLUMN account_journal.l10n_cl_point_of_sale_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_cl_point_of_sale_number IS 'Point Of Sale Number';


--
-- Name: COLUMN account_journal.l10n_cl_point_of_sale_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_cl_point_of_sale_type IS 'Point Of Sale Type';


--
-- Name: COLUMN account_journal.l10n_cl_point_of_sale_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_cl_point_of_sale_name IS 'Point Of Sale Name';


--
-- Name: COLUMN account_journal.check_add_debit_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.check_add_debit_button IS 'Agregar botón de débito';


--
-- Name: COLUMN account_journal.l10n_uy_edi_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_uy_edi_type IS 'Invoicing Type';


--
-- Name: COLUMN account_journal.l10n_uy_edi_send_print; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.l10n_uy_edi_send_print IS 'Auto pop up Send and Print';


--
-- Name: COLUMN account_journal.loan_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.loan_properties_definition IS 'Model Properties';


--
-- Name: COLUMN account_journal.sepa_pain_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.sepa_pain_version IS 'SEPA XML Format';


--
-- Name: COLUMN account_journal.iso20022_default_priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.iso20022_default_priority IS 'Default Priority';


--
-- Name: COLUMN account_journal.iso20022_charge_bearer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal.iso20022_charge_bearer IS 'ISO 20022 Charge Bearer';


--
-- Name: account_journal_account_journal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_journal_group_rel (
    account_journal_group_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_journal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_journal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_journal_group_rel IS 'RELATION BETWEEN account_journal_group AND account_journal';


--
-- Name: account_journal_account_reconcile_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_account_reconcile_model_rel (
    account_reconcile_model_id integer NOT NULL,
    account_journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_account_reconcile_model_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_account_reconcile_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_account_reconcile_model_rel IS 'RELATION BETWEEN account_reconcile_model AND account_journal';


--
-- Name: account_journal_book_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_book_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_book_group OWNER TO runbot;

--
-- Name: TABLE account_journal_book_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_book_group IS 'Account Journal Book Group';


--
-- Name: COLUMN account_journal_book_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_book_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_book_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.name IS 'Name';


--
-- Name: COLUMN account_journal_book_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_book_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_book_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_book_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_book_group_id_seq OWNER TO runbot;

--
-- Name: account_journal_book_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_book_group_id_seq OWNED BY public.account_journal_book_group.id;


--
-- Name: account_journal_book_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_book_journal_rel (
    acc_journal_entries_id integer NOT NULL,
    journal_id integer NOT NULL
);


ALTER TABLE public.account_journal_book_journal_rel OWNER TO runbot;

--
-- Name: TABLE account_journal_book_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_book_journal_rel IS 'RELATION BETWEEN account_journal_book_report AND account_journal';


--
-- Name: account_journal_book_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_book_report (
    id integer NOT NULL,
    company_id integer NOT NULL,
    last_entry_number integer NOT NULL,
    create_uid integer,
    write_uid integer,
    target_move character varying NOT NULL,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_book_report OWNER TO runbot;

--
-- Name: TABLE account_journal_book_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_book_report IS 'Journal Book Report';


--
-- Name: COLUMN account_journal_book_report.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.company_id IS 'Company';


--
-- Name: COLUMN account_journal_book_report.last_entry_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.last_entry_number IS 'Último nº de asiento';


--
-- Name: COLUMN account_journal_book_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_book_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_book_report.target_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.target_move IS 'Target Moves';


--
-- Name: COLUMN account_journal_book_report.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.date_from IS 'Start Date';


--
-- Name: COLUMN account_journal_book_report.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.date_to IS 'End Date';


--
-- Name: COLUMN account_journal_book_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_book_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_book_report.write_date IS 'Last Updated on';


--
-- Name: account_journal_book_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_book_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_book_report_id_seq OWNER TO runbot;

--
-- Name: account_journal_book_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_book_report_id_seq OWNED BY public.account_journal_book_report.id;


--
-- Name: account_journal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_journal_group (
    id integer NOT NULL,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_journal_group OWNER TO runbot;

--
-- Name: TABLE account_journal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_journal_group IS 'Account Journal Group';


--
-- Name: COLUMN account_journal_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.company_id IS 'Company';


--
-- Name: COLUMN account_journal_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_journal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_journal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_journal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.name IS 'Ledger group';


--
-- Name: COLUMN account_journal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_journal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_journal_group.write_date IS 'Last Updated on';


--
-- Name: account_journal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_group_id_seq OWNER TO runbot;

--
-- Name: account_journal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_group_id_seq OWNED BY public.account_journal_group.id;


--
-- Name: account_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_journal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_journal_id_seq OWNER TO runbot;

--
-- Name: account_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_journal_id_seq OWNED BY public.account_journal.id;


--
-- Name: account_loan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan (
    id integer NOT NULL,
    company_id integer NOT NULL,
    duration integer,
    long_term_account_id integer,
    short_term_account_id integer,
    expense_account_id integer,
    journal_id integer,
    asset_group_id integer,
    create_uid integer,
    write_uid integer,
    display_name character varying,
    name character varying NOT NULL,
    state character varying NOT NULL,
    date date,
    skip_until_date date,
    loan_properties jsonb,
    amount_borrowed numeric,
    interest numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan OWNER TO runbot;

--
-- Name: TABLE account_loan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan IS 'Loan';


--
-- Name: COLUMN account_loan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.company_id IS 'Company';


--
-- Name: COLUMN account_loan.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.duration IS 'Duration';


--
-- Name: COLUMN account_loan.long_term_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.long_term_account_id IS 'Long Term Account';


--
-- Name: COLUMN account_loan.short_term_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.short_term_account_id IS 'Short Term Account';


--
-- Name: COLUMN account_loan.expense_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.expense_account_id IS 'Expense Account';


--
-- Name: COLUMN account_loan.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.journal_id IS 'Journal';


--
-- Name: COLUMN account_loan.asset_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.asset_group_id IS 'Asset Group';


--
-- Name: COLUMN account_loan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan.display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.display_name IS 'Loan name';


--
-- Name: COLUMN account_loan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.name IS 'Name';


--
-- Name: COLUMN account_loan.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.state IS 'Status';


--
-- Name: COLUMN account_loan.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.date IS 'Loan Date';


--
-- Name: COLUMN account_loan.skip_until_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.skip_until_date IS 'Skip until';


--
-- Name: COLUMN account_loan.loan_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.loan_properties IS 'Properties';


--
-- Name: COLUMN account_loan.amount_borrowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.amount_borrowed IS 'Amount Borrowed';


--
-- Name: COLUMN account_loan.interest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.interest IS 'Interest';


--
-- Name: COLUMN account_loan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.active IS 'Active';


--
-- Name: COLUMN account_loan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.create_date IS 'Created on';


--
-- Name: COLUMN account_loan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_close_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_close_wizard OWNER TO runbot;

--
-- Name: TABLE account_loan_close_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_close_wizard IS 'Close Loan Wizard';


--
-- Name: COLUMN account_loan_close_wizard.loan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_close_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_close_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_close_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.date IS 'Close Date';


--
-- Name: COLUMN account_loan_close_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_close_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_close_wizard.write_date IS 'Last Updated on';


--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_close_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_close_wizard_id_seq OWNER TO runbot;

--
-- Name: account_loan_close_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_close_wizard_id_seq OWNED BY public.account_loan_close_wizard.id;


--
-- Name: account_loan_compute_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_compute_wizard (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    loan_term integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payment_end_of_month character varying NOT NULL,
    compounding_method character varying NOT NULL,
    start_date date NOT NULL,
    first_payment_date date NOT NULL,
    loan_amount numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    interest_rate double precision NOT NULL
);


ALTER TABLE public.account_loan_compute_wizard OWNER TO runbot;

--
-- Name: TABLE account_loan_compute_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_compute_wizard IS 'Loan Compute Wizard';


--
-- Name: COLUMN account_loan_compute_wizard.loan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_compute_wizard.loan_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_term IS 'Loan Term';


--
-- Name: COLUMN account_loan_compute_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_compute_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_compute_wizard.payment_end_of_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.payment_end_of_month IS 'Payment';


--
-- Name: COLUMN account_loan_compute_wizard.compounding_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.compounding_method IS 'Compounding Method';


--
-- Name: COLUMN account_loan_compute_wizard.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.start_date IS 'Start Date';


--
-- Name: COLUMN account_loan_compute_wizard.first_payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.first_payment_date IS 'First Payment';


--
-- Name: COLUMN account_loan_compute_wizard.loan_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.loan_amount IS 'Loan Amount';


--
-- Name: COLUMN account_loan_compute_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_compute_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_loan_compute_wizard.interest_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_compute_wizard.interest_rate IS 'Interest Rate';


--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_compute_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_compute_wizard_id_seq OWNER TO runbot;

--
-- Name: account_loan_compute_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_compute_wizard_id_seq OWNED BY public.account_loan_compute_wizard.id;


--
-- Name: account_loan_debt_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_debt_report (
    id integer NOT NULL,
    partner_id integer,
    company_id integer NOT NULL,
    loan_move_id integer,
    create_uid integer,
    write_uid integer,
    amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_debt_report OWNER TO runbot;

--
-- Name: TABLE account_loan_debt_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_debt_report IS 'Account Loan debt report';


--
-- Name: COLUMN account_loan_debt_report.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_debt_report.partner_id IS 'Partner';


--
-- Name: COLUMN account_loan_debt_report.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_debt_report.company_id IS 'Company';


--
-- Name: COLUMN account_loan_debt_report.loan_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_debt_report.loan_move_id IS 'Loan';


--
-- Name: COLUMN account_loan_debt_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_debt_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_debt_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_debt_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_debt_report.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_debt_report.amount IS 'Amount';


--
-- Name: COLUMN account_loan_debt_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_debt_report.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_debt_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_debt_report.write_date IS 'Last Updated on';


--
-- Name: account_loan_debt_report_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_debt_report_account_move_line_rel (
    account_loan_debt_report_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_loan_debt_report_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_loan_debt_report_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_debt_report_account_move_line_rel IS 'RELATION BETWEEN account_loan_debt_report AND account_move_line';


--
-- Name: account_loan_debt_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_debt_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_debt_report_id_seq OWNER TO runbot;

--
-- Name: account_loan_debt_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_debt_report_id_seq OWNED BY public.account_loan_debt_report.id;


--
-- Name: account_loan_extra_charges; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_extra_charges (
    id integer NOT NULL,
    partner_id integer,
    company_id integer NOT NULL,
    loan_move_id integer,
    create_uid integer,
    write_uid integer,
    label character varying NOT NULL,
    extra_charges numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_extra_charges OWNER TO runbot;

--
-- Name: TABLE account_loan_extra_charges; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_extra_charges IS 'Account Loan extra charges';


--
-- Name: COLUMN account_loan_extra_charges.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_extra_charges.partner_id IS 'Partner';


--
-- Name: COLUMN account_loan_extra_charges.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_extra_charges.company_id IS 'Company';


--
-- Name: COLUMN account_loan_extra_charges.loan_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_extra_charges.loan_move_id IS 'Loan';


--
-- Name: COLUMN account_loan_extra_charges.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_extra_charges.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_extra_charges.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_extra_charges.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_extra_charges.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_extra_charges.label IS 'Label';


--
-- Name: COLUMN account_loan_extra_charges.extra_charges; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_extra_charges.extra_charges IS 'Extra Charges';


--
-- Name: COLUMN account_loan_extra_charges.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_extra_charges.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_extra_charges.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_extra_charges.write_date IS 'Last Updated on';


--
-- Name: account_loan_extra_charges_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_extra_charges_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_extra_charges_id_seq OWNER TO runbot;

--
-- Name: account_loan_extra_charges_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_extra_charges_id_seq OWNED BY public.account_loan_extra_charges.id;


--
-- Name: account_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_id_seq OWNER TO runbot;

--
-- Name: account_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_id_seq OWNED BY public.account_loan.id;


--
-- Name: account_loan_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_line (
    id integer NOT NULL,
    loan_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    principal numeric,
    interest numeric,
    payment numeric,
    long_term_theoretical_balance numeric,
    short_term_theoretical_balance numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_line OWNER TO runbot;

--
-- Name: TABLE account_loan_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_line IS 'Loan Line';


--
-- Name: COLUMN account_loan_line.loan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.loan_id IS 'Loan';


--
-- Name: COLUMN account_loan_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.date IS 'Date';


--
-- Name: COLUMN account_loan_line.principal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.principal IS 'Principal';


--
-- Name: COLUMN account_loan_line.interest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.interest IS 'Interest';


--
-- Name: COLUMN account_loan_line.payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.payment IS 'Payment';


--
-- Name: COLUMN account_loan_line.long_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.long_term_theoretical_balance IS 'Long-Term';


--
-- Name: COLUMN account_loan_line.short_term_theoretical_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.short_term_theoretical_balance IS 'Short-Term';


--
-- Name: COLUMN account_loan_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_line.write_date IS 'Last Updated on';


--
-- Name: account_loan_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_line_id_seq OWNER TO runbot;

--
-- Name: account_loan_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_line_id_seq OWNED BY public.account_loan_line.id;


--
-- Name: account_loan_register; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_register (
    id integer NOT NULL,
    company_id integer,
    currency_id integer,
    partner_id integer,
    card_id integer NOT NULL,
    installment_id integer,
    create_uid integer,
    write_uid integer,
    note text,
    amount numeric,
    is_invoiceable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_loan_register OWNER TO runbot;

--
-- Name: TABLE account_loan_register; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_register IS 'Account Loan Register';


--
-- Name: COLUMN account_loan_register.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.company_id IS 'Company';


--
-- Name: COLUMN account_loan_register.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_loan_register.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.partner_id IS 'Partner';


--
-- Name: COLUMN account_loan_register.card_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.card_id IS 'Card';


--
-- Name: COLUMN account_loan_register.installment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.installment_id IS 'Installment plan';


--
-- Name: COLUMN account_loan_register.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_loan_register.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_loan_register.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.note IS 'Internal Note';


--
-- Name: COLUMN account_loan_register.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.amount IS 'Amount';


--
-- Name: COLUMN account_loan_register.is_invoiceable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.is_invoiceable IS 'Is Invoiceable';


--
-- Name: COLUMN account_loan_register.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.create_date IS 'Created on';


--
-- Name: COLUMN account_loan_register.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_loan_register.write_date IS 'Last Updated on';


--
-- Name: account_loan_register_account_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_register_account_move_line_rel (
    account_loan_register_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_loan_register_account_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_loan_register_account_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_register_account_move_line_rel IS 'RELATION BETWEEN account_loan_register AND account_move_line';


--
-- Name: account_loan_register_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_loan_register_account_move_rel (
    account_loan_register_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_loan_register_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_loan_register_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_loan_register_account_move_rel IS 'RELATION BETWEEN account_loan_register AND account_move';


--
-- Name: account_loan_register_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_loan_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_loan_register_id_seq OWNER TO runbot;

--
-- Name: account_loan_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_loan_register_id_seq OWNED BY public.account_loan_register.id;


--
-- Name: account_lock_exception; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_lock_exception (
    id integer NOT NULL,
    company_id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    reason character varying,
    lock_date_field character varying NOT NULL,
    lock_date date,
    company_lock_date date,
    active boolean,
    end_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_lock_exception OWNER TO runbot;

--
-- Name: TABLE account_lock_exception; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_lock_exception IS 'Account Lock Exception';


--
-- Name: COLUMN account_lock_exception.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_id IS 'Company';


--
-- Name: COLUMN account_lock_exception.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.user_id IS 'User';


--
-- Name: COLUMN account_lock_exception.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_uid IS 'Created by';


--
-- Name: COLUMN account_lock_exception.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_lock_exception.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.reason IS 'Reason';


--
-- Name: COLUMN account_lock_exception.lock_date_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date_field IS 'Lock Date Field';


--
-- Name: COLUMN account_lock_exception.lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.lock_date IS 'Changed Lock Date';


--
-- Name: COLUMN account_lock_exception.company_lock_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.company_lock_date IS 'Original Lock Date';


--
-- Name: COLUMN account_lock_exception.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.active IS 'Active';


--
-- Name: COLUMN account_lock_exception.end_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.end_datetime IS 'End Date';


--
-- Name: COLUMN account_lock_exception.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.create_date IS 'Created on';


--
-- Name: COLUMN account_lock_exception.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_lock_exception.write_date IS 'Last Updated on';


--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_lock_exception_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_lock_exception_id_seq OWNER TO runbot;

--
-- Name: account_lock_exception_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_lock_exception_id_seq OWNED BY public.account_lock_exception.id;


--
-- Name: account_merge_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    is_group_by_name boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard IS 'Account merge wizard';


--
-- Name: COLUMN account_merge_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard.is_group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.is_group_by_name IS 'Group by name?';


--
-- Name: COLUMN account_merge_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_id_seq OWNED BY public.account_merge_wizard.id;


--
-- Name: account_merge_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_merge_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    sequence integer,
    account_id integer,
    create_uid integer,
    write_uid integer,
    grouping_key character varying,
    display_type character varying NOT NULL,
    is_selected boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_merge_wizard_line OWNER TO runbot;

--
-- Name: TABLE account_merge_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_merge_wizard_line IS 'Account merge wizard line';


--
-- Name: COLUMN account_merge_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN account_merge_wizard_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_merge_wizard_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.account_id IS 'Account';


--
-- Name: COLUMN account_merge_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_merge_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_merge_wizard_line.grouping_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.grouping_key IS 'Grouping Key';


--
-- Name: COLUMN account_merge_wizard_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_merge_wizard_line.is_selected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.is_selected IS 'Is Selected';


--
-- Name: COLUMN account_merge_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN account_merge_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_merge_wizard_line.write_date IS 'Last Updated on';


--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_merge_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNER TO runbot;

--
-- Name: account_merge_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_merge_wizard_line_id_seq OWNED BY public.account_merge_wizard_line.id;


--
-- Name: account_method_line_card_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_method_line_card_rel (
    method_id integer NOT NULL,
    card_id integer NOT NULL
);


ALTER TABLE public.account_method_line_card_rel OWNER TO runbot;

--
-- Name: TABLE account_method_line_card_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_method_line_card_rel IS 'RELATION BETWEEN account_payment_method_line AND account_card';


--
-- Name: account_missing_transaction_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_missing_transaction_wizard (
    id integer NOT NULL,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_missing_transaction_wizard OWNER TO runbot;

--
-- Name: TABLE account_missing_transaction_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_missing_transaction_wizard IS 'Wizard for missing transactions';


--
-- Name: COLUMN account_missing_transaction_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_missing_transaction_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_missing_transaction_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_missing_transaction_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.date IS 'Starting Date';


--
-- Name: COLUMN account_missing_transaction_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_missing_transaction_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_missing_transaction_wizard.write_date IS 'Last Updated on';


--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_missing_transaction_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNER TO runbot;

--
-- Name: account_missing_transaction_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_missing_transaction_wizard_id_seq OWNED BY public.account_missing_transaction_wizard.id;


--
-- Name: account_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move (
    id integer NOT NULL,
    sequence_number integer,
    message_main_attachment_id integer,
    journal_id integer NOT NULL,
    company_id integer,
    origin_payment_id integer,
    statement_line_id integer,
    tax_cash_basis_rec_id integer,
    tax_cash_basis_origin_move_id integer,
    auto_post_origin_id integer,
    secure_sequence_number integer,
    invoice_payment_term_id integer,
    partner_id integer,
    commercial_partner_id integer,
    partner_shipping_id integer,
    partner_bank_id integer,
    fiscal_position_id integer,
    preferred_payment_method_line_id integer,
    currency_id integer NOT NULL,
    reversed_entry_id integer,
    invoice_user_id integer,
    invoice_incoterm_id integer,
    invoice_cash_rounding_id integer,
    create_uid integer,
    write_uid integer,
    sequence_prefix character varying,
    access_token character varying,
    name character varying,
    ref character varying,
    state character varying NOT NULL,
    move_type character varying NOT NULL,
    auto_post character varying NOT NULL,
    inalterable_hash character varying,
    payment_reference character varying,
    qr_code_method character varying,
    payment_state character varying,
    invoice_source_email character varying,
    invoice_partner_display_name character varying,
    invoice_origin character varying,
    incoterm_location character varying,
    date date NOT NULL,
    auto_post_until date,
    invoice_date date,
    invoice_date_due date,
    delivery_date date,
    taxable_supply_date date,
    sending_data jsonb,
    narration text,
    invoice_currency_rate numeric,
    amount_untaxed numeric,
    amount_tax numeric,
    amount_total numeric,
    amount_residual numeric,
    amount_untaxed_signed numeric,
    amount_untaxed_in_currency_signed numeric,
    amount_tax_signed numeric,
    amount_total_signed numeric,
    amount_total_in_currency_signed numeric,
    amount_residual_signed numeric,
    quick_edit_total_amount numeric,
    always_tax_exigible boolean,
    checked boolean,
    posted_before boolean,
    made_sequence_gap boolean,
    is_manually_modified boolean,
    is_move_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    signing_user integer,
    payment_state_before_switch character varying,
    background_post boolean,
    debit_origin_id integer,
    edi_state character varying,
    date_last_payment date,
    avatax_tax_date date,
    direct_debit_mandate_id integer,
    next_surcharge_date date,
    avoid_surcharge_invoice boolean,
    next_surcharge_percent double precision,
    closing_return_id integer,
    l10n_es_is_simplified boolean,
    l10n_latam_document_type_id integer,
    reversed_pos_order_id integer,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    team_id integer,
    pay_now_journal_id integer,
    internal_notes text,
    suspense_statement_line_id integer,
    l10n_ar_afip_responsibility_type_id integer,
    l10n_ar_afip_service_start date,
    l10n_ar_afip_service_end date,
    l10n_es_edi_facturae_reason_code character varying,
    l10n_es_payment_means character varying,
    l10n_es_invoicing_period_start_date date,
    l10n_es_invoicing_period_end_date date,
    l10n_es_reports_mod349_available boolean,
    l10n_es_reports_mod347_invoice_type character varying,
    l10n_es_reports_mod349_invoice_type character varying,
    pagos360_barcode character varying,
    pagos360_rp_barcode character varying,
    pagos360_barcode_amount double precision,
    asset_id integer,
    asset_number_days integer,
    asset_move_type character varying,
    asset_depreciation_beginning_date date,
    depreciation_value numeric,
    asset_value_change boolean,
    cashbox_session_id integer,
    extract_attachment_id integer,
    extract_detected_layout integer,
    extract_state character varying,
    extract_status character varying,
    extract_document_uuid character varying,
    extract_partner_name character varying,
    extracted_words jsonb,
    extracted_numbers jsonb,
    extracted_dates jsonb,
    extract_prefill_data jsonb,
    is_in_extractable_state boolean,
    extract_state_processed boolean,
    receiptbook_id integer,
    l10n_ar_fce_transmission_type character varying,
    l10n_ar_afip_auth_mode character varying,
    l10n_ar_afip_auth_code character varying(24),
    l10n_ar_afip_result character varying,
    l10n_ar_afip_verification_result character varying,
    l10n_ar_afip_auth_code_due date,
    l10n_ar_afip_xml_request text,
    l10n_ar_afip_xml_response text,
    l10n_ar_afip_fce_is_cancellation boolean,
    l10n_cl_sii_send_file integer,
    l10n_cl_dte_file integer,
    l10n_cl_sii_barcode character varying,
    l10n_cl_dte_status character varying,
    l10n_cl_dte_partner_status character varying,
    l10n_cl_dte_acceptation_status character varying,
    l10n_cl_claim character varying,
    l10n_cl_claim_description character varying,
    l10n_cl_sii_send_ident text,
    l10n_pe_edi_legend_value character varying,
    l10n_pe_edi_operation_type character varying,
    l10n_pe_edi_cancel_cdr_number character varying,
    l10n_pe_edi_refund_reason character varying,
    l10n_pe_edi_charge_reason character varying,
    l10n_pe_edi_cancel_reason character varying,
    l10n_pe_edi_legend character varying,
    l10n_uy_edi_document_id integer,
    l10n_uy_edi_cfe_sale_mode character varying,
    l10n_uy_edi_cfe_transport_route character varying,
    l10n_uy_edi_cfe_state character varying,
    pos_amount_unsettled numeric,
    sale_type_id integer,
    purchase_order_number character varying,
    website_id integer,
    generating_loan_line_id integer,
    is_loan_payment_move boolean,
    last_interest_date_calculation date,
    loan_description text,
    l10n_pe_dua_invoice_id integer,
    l10n_pe_usage_type_id integer,
    l10n_pe_detraction_number character varying,
    l10n_pe_service_modality character varying,
    l10n_pe_sunat_transaction_type character varying,
    l10n_pe_detraction_date date,
    manual_uruware_invoice character varying,
    l10n_uy_cfe_xml text,
    exchange_reversal_id integer,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date
);


ALTER TABLE public.account_move OWNER TO runbot;

--
-- Name: TABLE account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move IS 'Journal Entry';


--
-- Name: COLUMN account_move.sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_number IS 'Sequence Number';


--
-- Name: COLUMN account_move.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_move.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.journal_id IS 'Journal';


--
-- Name: COLUMN account_move.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.company_id IS 'Company';


--
-- Name: COLUMN account_move.origin_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.origin_payment_id IS 'Payment';


--
-- Name: COLUMN account_move.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.statement_line_id IS 'Statement Line';


--
-- Name: COLUMN account_move.tax_cash_basis_rec_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_rec_id IS 'Tax Cash Basis Entry of';


--
-- Name: COLUMN account_move.tax_cash_basis_origin_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.tax_cash_basis_origin_move_id IS 'Cash Basis Origin';


--
-- Name: COLUMN account_move.auto_post_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_origin_id IS 'First recurring entry';


--
-- Name: COLUMN account_move.secure_sequence_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.secure_sequence_number IS 'Inalterability No Gap Sequence #';


--
-- Name: COLUMN account_move.invoice_payment_term_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_move.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_id IS 'Partner';


--
-- Name: COLUMN account_move.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN account_move.partner_shipping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_shipping_id IS 'Delivery Address';


--
-- Name: COLUMN account_move.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.partner_bank_id IS 'Recipient Bank';


--
-- Name: COLUMN account_move.fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_move.preferred_payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.preferred_payment_method_line_id IS 'Preferred Payment Method Line';


--
-- Name: COLUMN account_move.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.currency_id IS 'Currency';


--
-- Name: COLUMN account_move.reversed_entry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.reversed_entry_id IS 'Reversal of';


--
-- Name: COLUMN account_move.invoice_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_user_id IS 'Salesperson';


--
-- Name: COLUMN account_move.invoice_incoterm_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_incoterm_id IS 'Incoterm';


--
-- Name: COLUMN account_move.invoice_cash_rounding_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_cash_rounding_id IS 'Cash Rounding Method';


--
-- Name: COLUMN account_move.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_uid IS 'Created by';


--
-- Name: COLUMN account_move.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move.sequence_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sequence_prefix IS 'Sequence Prefix';


--
-- Name: COLUMN account_move.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.access_token IS 'Security Token';


--
-- Name: COLUMN account_move.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.name IS 'Number';


--
-- Name: COLUMN account_move.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.ref IS 'Reference';


--
-- Name: COLUMN account_move.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.state IS 'Status';


--
-- Name: COLUMN account_move.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.move_type IS 'Type';


--
-- Name: COLUMN account_move.auto_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post IS 'Auto-post';


--
-- Name: COLUMN account_move.inalterable_hash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.inalterable_hash IS 'Inalterability Hash';


--
-- Name: COLUMN account_move.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_move.qr_code_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.qr_code_method IS 'Payment QR-code';


--
-- Name: COLUMN account_move.payment_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state IS 'Payment Status';


--
-- Name: COLUMN account_move.invoice_source_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_source_email IS 'Source Email';


--
-- Name: COLUMN account_move.invoice_partner_display_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_partner_display_name IS 'Invoice Partner Display Name';


--
-- Name: COLUMN account_move.invoice_origin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_origin IS 'Origin';


--
-- Name: COLUMN account_move.incoterm_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.incoterm_location IS 'Incoterm Location';


--
-- Name: COLUMN account_move.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.date IS 'Date';


--
-- Name: COLUMN account_move.auto_post_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.auto_post_until IS 'Auto-post until';


--
-- Name: COLUMN account_move.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move.invoice_date_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_date_due IS 'Due Date';


--
-- Name: COLUMN account_move.delivery_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.delivery_date IS 'Delivery Date';


--
-- Name: COLUMN account_move.taxable_supply_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.taxable_supply_date IS 'Taxable Supply Date';


--
-- Name: COLUMN account_move.sending_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sending_data IS 'Sending Data';


--
-- Name: COLUMN account_move.narration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.narration IS 'Terms and Conditions';


--
-- Name: COLUMN account_move.invoice_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.invoice_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move.amount_untaxed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed IS 'Untaxed Amount';


--
-- Name: COLUMN account_move.amount_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax IS 'Tax';


--
-- Name: COLUMN account_move.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total IS 'Total';


--
-- Name: COLUMN account_move.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual IS 'Amount Due';


--
-- Name: COLUMN account_move.amount_untaxed_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_signed IS 'Untaxed Amount Signed';


--
-- Name: COLUMN account_move.amount_untaxed_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_untaxed_in_currency_signed IS 'Untaxed Amount Signed Currency';


--
-- Name: COLUMN account_move.amount_tax_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_tax_signed IS 'Tax Signed';


--
-- Name: COLUMN account_move.amount_total_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_signed IS 'Total Signed';


--
-- Name: COLUMN account_move.amount_total_in_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_total_in_currency_signed IS 'Total in Currency Signed';


--
-- Name: COLUMN account_move.amount_residual_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.amount_residual_signed IS 'Amount Due Signed';


--
-- Name: COLUMN account_move.quick_edit_total_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.quick_edit_total_amount IS 'Total (Tax inc.)';


--
-- Name: COLUMN account_move.always_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.always_tax_exigible IS 'Always Tax Exigible';


--
-- Name: COLUMN account_move.checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.checked IS 'Reviewed';


--
-- Name: COLUMN account_move.posted_before; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.posted_before IS 'Posted Before';


--
-- Name: COLUMN account_move.made_sequence_gap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.made_sequence_gap IS 'Made Sequence Gap';


--
-- Name: COLUMN account_move.is_manually_modified; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_manually_modified IS 'Is Manually Modified';


--
-- Name: COLUMN account_move.is_move_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_move_sent IS 'Is Move Sent';


--
-- Name: COLUMN account_move.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.create_date IS 'Created on';


--
-- Name: COLUMN account_move.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move.signing_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.signing_user IS 'Signer';


--
-- Name: COLUMN account_move.payment_state_before_switch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.payment_state_before_switch IS 'Payment State Before Switch';


--
-- Name: COLUMN account_move.background_post; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.background_post IS 'Background Post';


--
-- Name: COLUMN account_move.debit_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.debit_origin_id IS 'Original Invoice Debited';


--
-- Name: COLUMN account_move.edi_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.edi_state IS 'Electronic invoicing';


--
-- Name: COLUMN account_move.date_last_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.date_last_payment IS 'Last Payment Date';


--
-- Name: COLUMN account_move.avatax_tax_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.avatax_tax_date IS 'Avatax Date';


--
-- Name: COLUMN account_move.direct_debit_mandate_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.direct_debit_mandate_id IS 'Direct Debit Mandate';


--
-- Name: COLUMN account_move.next_surcharge_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.next_surcharge_date IS 'Next Surcharge Date';


--
-- Name: COLUMN account_move.avoid_surcharge_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.avoid_surcharge_invoice IS 'Avoid Surcharge Invoice';


--
-- Name: COLUMN account_move.next_surcharge_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.next_surcharge_percent IS 'Next Surcharge Percent';


--
-- Name: COLUMN account_move.closing_return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.closing_return_id IS 'Closing Return';


--
-- Name: COLUMN account_move.l10n_es_is_simplified; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_es_is_simplified IS 'Is Simplified';


--
-- Name: COLUMN account_move.reversed_pos_order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.reversed_pos_order_id IS 'Reversed POS Order';


--
-- Name: COLUMN account_move.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.campaign_id IS 'Campaign';


--
-- Name: COLUMN account_move.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.source_id IS 'Source';


--
-- Name: COLUMN account_move.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.medium_id IS 'Medium';


--
-- Name: COLUMN account_move.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.team_id IS 'Sales Team';


--
-- Name: COLUMN account_move.pay_now_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.pay_now_journal_id IS 'Pay now Journal';


--
-- Name: COLUMN account_move.internal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.internal_notes IS 'Internal Notes';


--
-- Name: COLUMN account_move.suspense_statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.suspense_statement_line_id IS 'Request document from a bank statement line';


--
-- Name: COLUMN account_move.l10n_ar_afip_responsibility_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_responsibility_type_id IS 'ARCA Responsibility Type';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_start IS 'ARCA Service Start Date';


--
-- Name: COLUMN account_move.l10n_ar_afip_service_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_service_end IS 'ARCA Service End Date';


--
-- Name: COLUMN account_move.l10n_es_invoicing_period_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_es_invoicing_period_start_date IS 'Invoice Period Start Date';


--
-- Name: COLUMN account_move.l10n_es_invoicing_period_end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_es_invoicing_period_end_date IS 'Invoice Period End Date';


--
-- Name: COLUMN account_move.l10n_es_reports_mod347_invoice_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_es_reports_mod347_invoice_type IS 'Type for mod 347';


--
-- Name: COLUMN account_move.l10n_es_reports_mod349_invoice_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_es_reports_mod349_invoice_type IS 'Type for mod 349';


--
-- Name: COLUMN account_move.pagos360_barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.pagos360_barcode IS 'Pagos360 Barcode';


--
-- Name: COLUMN account_move.pagos360_rp_barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.pagos360_rp_barcode IS 'Pagos360 Rp Barcode';


--
-- Name: COLUMN account_move.pagos360_barcode_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.pagos360_barcode_amount IS 'Pagos360 Barcode Amount';


--
-- Name: COLUMN account_move.asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_id IS 'Asset';


--
-- Name: COLUMN account_move.asset_number_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_number_days IS 'Number of days';


--
-- Name: COLUMN account_move.asset_move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_move_type IS 'Asset Move Type';


--
-- Name: COLUMN account_move.asset_depreciation_beginning_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_depreciation_beginning_date IS 'Date of the beginning of the depreciation';


--
-- Name: COLUMN account_move.depreciation_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.depreciation_value IS 'Depreciation';


--
-- Name: COLUMN account_move.asset_value_change; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.asset_value_change IS 'Asset Value Change';


--
-- Name: COLUMN account_move.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.cashbox_session_id IS 'Cashbox Session';


--
-- Name: COLUMN account_move.extract_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_attachment_id IS 'Extract Attachment';


--
-- Name: COLUMN account_move.extract_detected_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_detected_layout IS 'Extract Detected Layout Id';


--
-- Name: COLUMN account_move.extract_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_state IS 'Extract state';


--
-- Name: COLUMN account_move.extract_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_status IS 'Extract status';


--
-- Name: COLUMN account_move.extract_document_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_document_uuid IS 'ID of the request to IAP-OCR';


--
-- Name: COLUMN account_move.extract_partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_partner_name IS 'Extract Detected Partner Name';


--
-- Name: COLUMN account_move.extracted_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extracted_words IS 'Extracted Words';


--
-- Name: COLUMN account_move.extracted_numbers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extracted_numbers IS 'Extracted Numbers';


--
-- Name: COLUMN account_move.extracted_dates; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extracted_dates IS 'Extracted Dates';


--
-- Name: COLUMN account_move.extract_prefill_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_prefill_data IS 'Extract Prefill Data';


--
-- Name: COLUMN account_move.is_in_extractable_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_in_extractable_state IS 'Is In Extractable State';


--
-- Name: COLUMN account_move.extract_state_processed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.extract_state_processed IS 'Extract State Processed';


--
-- Name: COLUMN account_move.receiptbook_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.receiptbook_id IS 'ReceiptBook';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_mode IS 'ARCA Authorization Mode';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code IS 'Authorization Code';


--
-- Name: COLUMN account_move.l10n_ar_afip_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_result IS 'Result';


--
-- Name: COLUMN account_move.l10n_ar_afip_verification_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_verification_result IS 'ARCA Verification result';


--
-- Name: COLUMN account_move.l10n_ar_afip_auth_code_due; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_auth_code_due IS 'Authorization Due date';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_request IS 'XML Request';


--
-- Name: COLUMN account_move.l10n_ar_afip_xml_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_xml_response IS 'XML Response';


--
-- Name: COLUMN account_move.l10n_ar_afip_fce_is_cancellation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_fce_is_cancellation IS 'FCE: Is Cancellation?';


--
-- Name: COLUMN account_move.l10n_cl_sii_send_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_sii_send_file IS 'SII Send file';


--
-- Name: COLUMN account_move.l10n_cl_dte_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_dte_file IS 'DTE file';


--
-- Name: COLUMN account_move.l10n_cl_sii_barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_sii_barcode IS 'SII Barcode';


--
-- Name: COLUMN account_move.l10n_cl_dte_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_dte_status IS 'SII DTE status';


--
-- Name: COLUMN account_move.l10n_cl_dte_partner_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_dte_partner_status IS 'Partner DTE status';


--
-- Name: COLUMN account_move.l10n_cl_dte_acceptation_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_dte_acceptation_status IS 'DTE Accept status';


--
-- Name: COLUMN account_move.l10n_cl_claim; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_claim IS 'Claim';


--
-- Name: COLUMN account_move.l10n_cl_claim_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_claim_description IS 'Claim Detail';


--
-- Name: COLUMN account_move.l10n_cl_sii_send_ident; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_cl_sii_send_ident IS 'SII Send Identification(Track ID)';


--
-- Name: COLUMN account_move.l10n_pe_edi_cancel_cdr_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_cancel_cdr_number IS 'L10N Pe Edi Cancel Cdr Number';


--
-- Name: COLUMN account_move.l10n_pe_edi_refund_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_refund_reason IS 'Credit Reason';


--
-- Name: COLUMN account_move.l10n_pe_edi_charge_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_charge_reason IS 'Debit Reason';


--
-- Name: COLUMN account_move.l10n_pe_edi_cancel_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_cancel_reason IS 'Cancel Reason';


--
-- Name: COLUMN account_move.l10n_pe_edi_legend; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_edi_legend IS 'Legend Code';


--
-- Name: COLUMN account_move.l10n_uy_edi_document_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_edi_document_id IS 'Uruguay E-Invoice CFE';


--
-- Name: COLUMN account_move.l10n_uy_edi_cfe_sale_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_edi_cfe_sale_mode IS 'Sales Modality';


--
-- Name: COLUMN account_move.l10n_uy_edi_cfe_transport_route; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_edi_cfe_transport_route IS 'Transportation Route';


--
-- Name: COLUMN account_move.l10n_uy_edi_cfe_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_edi_cfe_state IS 'CFE Status';


--
-- Name: COLUMN account_move.pos_amount_unsettled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.pos_amount_unsettled IS 'Amount To Pay In POS';


--
-- Name: COLUMN account_move.sale_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.sale_type_id IS 'Sale Type';


--
-- Name: COLUMN account_move.purchase_order_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.purchase_order_number IS 'Purchase Order Number';


--
-- Name: COLUMN account_move.generating_loan_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.generating_loan_line_id IS 'Generating Loan Line';


--
-- Name: COLUMN account_move.is_loan_payment_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.is_loan_payment_move IS 'Is Loan Payment Move';


--
-- Name: COLUMN account_move.last_interest_date_calculation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.last_interest_date_calculation IS 'Last Interest Date Calculation';


--
-- Name: COLUMN account_move.loan_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.loan_description IS 'Loan Description';


--
-- Name: COLUMN account_move.l10n_pe_dua_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_dua_invoice_id IS 'DUA Invoice';


--
-- Name: COLUMN account_move.l10n_pe_usage_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_usage_type_id IS 'Usage Type';


--
-- Name: COLUMN account_move.l10n_pe_detraction_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_detraction_number IS 'Detraction';


--
-- Name: COLUMN account_move.l10n_pe_service_modality; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_service_modality IS 'Service Modality';


--
-- Name: COLUMN account_move.l10n_pe_sunat_transaction_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_sunat_transaction_type IS 'PLE Transaction Type';


--
-- Name: COLUMN account_move.l10n_pe_detraction_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_pe_detraction_date IS 'Detraction Date';


--
-- Name: COLUMN account_move.manual_uruware_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.manual_uruware_invoice IS 'Manual Uruware Invoice';


--
-- Name: COLUMN account_move.l10n_uy_cfe_xml; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_uy_cfe_xml IS 'Technical field to preview the xml';


--
-- Name: COLUMN account_move.exchange_reversal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.exchange_reversal_id IS 'Exchange Reversal Entry';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_start IS 'Associated Period Start';


--
-- Name: COLUMN account_move.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move.l10n_ar_afip_asoc_period_end IS 'Associated Perdio End';


--
-- Name: account_move__account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move__account_payment (
    invoice_id integer NOT NULL,
    payment_id integer NOT NULL
);


ALTER TABLE public.account_move__account_payment OWNER TO runbot;

--
-- Name: TABLE account_move__account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move__account_payment IS 'RELATION BETWEEN account_move AND account_payment';


--
-- Name: account_move_account_move_send_batch_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_move_send_batch_wizard_rel (
    account_move_send_batch_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_move_send_batch_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_move_send_batch_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_move_send_batch_wizard_rel IS 'RELATION BETWEEN account_move_send_batch_wizard AND account_move';


--
-- Name: account_move_account_resequence_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_account_resequence_wizard_rel (
    account_resequence_wizard_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_account_resequence_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_account_resequence_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_account_resequence_wizard_rel IS 'RELATION BETWEEN account_resequence_wizard AND account_move';


--
-- Name: account_move_asset_modify_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_asset_modify_rel OWNER TO runbot;

--
-- Name: TABLE account_move_asset_modify_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move';


--
-- Name: account_move_change_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_change_rate (
    id integer NOT NULL,
    move_id integer,
    create_uid integer,
    write_uid integer,
    currency_rate numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_change_rate OWNER TO runbot;

--
-- Name: TABLE account_move_change_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_change_rate IS 'account.move.change.rate';


--
-- Name: COLUMN account_move_change_rate.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.move_id IS 'Move';


--
-- Name: COLUMN account_move_change_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_change_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_change_rate.currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.currency_rate IS 'Currency Rate';


--
-- Name: COLUMN account_move_change_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.create_date IS 'Created on';


--
-- Name: COLUMN account_move_change_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_change_rate.write_date IS 'Last Updated on';


--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_change_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_change_rate_id_seq OWNER TO runbot;

--
-- Name: account_move_change_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_change_rate_id_seq OWNED BY public.account_move_change_rate.id;


--
-- Name: account_move_debit_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_debit_move (
    debit_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_debit_move OWNER TO runbot;

--
-- Name: TABLE account_move_debit_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_debit_move IS 'RELATION BETWEEN account_debit_note AND account_move';


--
-- Name: account_move_deferred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_deferred_rel (
    original_move_id integer NOT NULL,
    deferred_move_id integer NOT NULL
);


ALTER TABLE public.account_move_deferred_rel OWNER TO runbot;

--
-- Name: TABLE account_move_deferred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_deferred_rel IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: account_move_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_id_seq OWNER TO runbot;

--
-- Name: account_move_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_id_seq OWNED BY public.account_move.id;


--
-- Name: account_move_l10n_ar_boarding_permission_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_l10n_ar_boarding_permission_rel (
    account_move_id integer NOT NULL,
    l10n_ar_boarding_permission_id integer NOT NULL
);


ALTER TABLE public.account_move_l10n_ar_boarding_permission_rel OWNER TO runbot;

--
-- Name: TABLE account_move_l10n_ar_boarding_permission_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_l10n_ar_boarding_permission_rel IS 'RELATION BETWEEN account_move AND l10n_ar_boarding_permission';


--
-- Name: account_move_l10n_uy_edi_addenda_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_l10n_uy_edi_addenda_rel (
    account_move_id integer NOT NULL,
    l10n_uy_edi_addenda_id integer NOT NULL
);


ALTER TABLE public.account_move_l10n_uy_edi_addenda_rel OWNER TO runbot;

--
-- Name: TABLE account_move_l10n_uy_edi_addenda_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_l10n_uy_edi_addenda_rel IS 'RELATION BETWEEN account_move AND l10n_uy_edi_addenda';


--
-- Name: account_move_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line (
    id integer NOT NULL,
    move_id integer NOT NULL,
    journal_id integer,
    company_id integer,
    company_currency_id integer,
    sequence integer,
    account_id integer,
    currency_id integer NOT NULL,
    partner_id integer,
    reconcile_model_id integer,
    payment_id integer,
    statement_line_id integer,
    statement_id integer,
    group_tax_id integer,
    tax_line_id integer,
    tax_group_id integer,
    tax_repartition_line_id integer,
    full_reconcile_id integer,
    product_id integer,
    product_uom_id integer,
    create_uid integer,
    write_uid integer,
    move_name character varying,
    parent_state character varying,
    ref character varying,
    name character varying,
    matching_number character varying,
    display_type character varying NOT NULL,
    date date,
    invoice_date date,
    date_maturity date,
    discount_date date,
    analytic_distribution jsonb,
    extra_tax_data jsonb,
    debit numeric,
    credit numeric,
    balance numeric,
    amount_currency numeric,
    tax_base_amount numeric,
    amount_residual numeric,
    amount_residual_currency numeric,
    quantity numeric,
    price_unit numeric,
    price_subtotal numeric,
    price_total numeric,
    discount numeric,
    discount_amount_currency numeric,
    discount_balance numeric,
    is_storno boolean,
    is_imported boolean,
    reconciled boolean,
    collapse_composition boolean,
    collapse_prices boolean,
    no_followup boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    deductible_amount double precision,
    deferred_start_date date,
    deferred_end_date date,
    purchase_line_id integer,
    is_downpayment boolean,
    cogs_origin_id integer,
    exclude_bank_lines boolean,
    l10n_latam_document_type_id integer,
    purchase_subscription_id integer,
    followup_line_id integer,
    user_id integer,
    is_landed_costs_line boolean,
    l10n_pe_edi_affectation_reason character varying,
    l10n_pe_edi_allowance_charge_reason_code character varying,
    subscription_mrr numeric,
    subscription_id integer,
    CONSTRAINT account_move_line_check_accountable_required_fields CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_subsection'::character varying, 'line_note'::character varying])::text[])) OR (account_id IS NOT NULL))),
    CONSTRAINT account_move_line_check_amount_currency_balance_sign CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_subsection'::character varying, 'line_note'::character varying])::text[])) OR (((balance <= (0)::numeric) AND (amount_currency <= (0)::numeric)) OR ((balance >= (0)::numeric) AND (amount_currency >= (0)::numeric))))),
    CONSTRAINT account_move_line_check_credit_debit CHECK ((((display_type)::text = ANY ((ARRAY['line_section'::character varying, 'line_subsection'::character varying, 'line_note'::character varying])::text[])) OR ((credit * debit) = (0)::numeric))),
    CONSTRAINT account_move_line_check_non_accountable_fields_null CHECK ((((display_type)::text <> ALL ((ARRAY['line_section'::character varying, 'line_subsection'::character varying, 'line_note'::character varying])::text[])) OR ((amount_currency = (0)::numeric) AND (debit = (0)::numeric) AND (credit = (0)::numeric) AND (account_id IS NULL))))
);


ALTER TABLE public.account_move_line OWNER TO runbot;

--
-- Name: TABLE account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line IS 'Journal Item';


--
-- Name: COLUMN account_move_line.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_move_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_id IS 'Company';


--
-- Name: COLUMN account_move_line.company_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.company_currency_id IS 'Company Currency';


--
-- Name: COLUMN account_move_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_move_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.account_id IS 'Account';


--
-- Name: COLUMN account_move_line.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.currency_id IS 'Currency';


--
-- Name: COLUMN account_move_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_move_line.reconcile_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconcile_model_id IS 'Reconciliation Model';


--
-- Name: COLUMN account_move_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.payment_id IS 'Originator Payment';


--
-- Name: COLUMN account_move_line.statement_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_line_id IS 'Originator Statement Line';


--
-- Name: COLUMN account_move_line.statement_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.statement_id IS 'Statement';


--
-- Name: COLUMN account_move_line.group_tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.group_tax_id IS 'Originator Group of Taxes';


--
-- Name: COLUMN account_move_line.tax_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_line_id IS 'Originator Tax';


--
-- Name: COLUMN account_move_line.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_group_id IS 'Originator tax group';


--
-- Name: COLUMN account_move_line.tax_repartition_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_repartition_line_id IS 'Originator Tax Distribution Line';


--
-- Name: COLUMN account_move_line.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.full_reconcile_id IS 'Matching';


--
-- Name: COLUMN account_move_line.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_id IS 'Product';


--
-- Name: COLUMN account_move_line.product_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.product_uom_id IS 'Unit';


--
-- Name: COLUMN account_move_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_line.move_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.move_name IS 'Number';


--
-- Name: COLUMN account_move_line.parent_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.parent_state IS 'Status';


--
-- Name: COLUMN account_move_line.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.ref IS 'Reference';


--
-- Name: COLUMN account_move_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.name IS 'Label';


--
-- Name: COLUMN account_move_line.matching_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.matching_number IS 'Matching #';


--
-- Name: COLUMN account_move_line.display_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.display_type IS 'Display Type';


--
-- Name: COLUMN account_move_line.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date IS 'Date';


--
-- Name: COLUMN account_move_line.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.invoice_date IS 'Invoice/Bill Date';


--
-- Name: COLUMN account_move_line.date_maturity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.date_maturity IS 'Due Date';


--
-- Name: COLUMN account_move_line.discount_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_date IS 'Discount Date';


--
-- Name: COLUMN account_move_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_move_line.extra_tax_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.extra_tax_data IS 'Extra Tax Data';


--
-- Name: COLUMN account_move_line.debit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.debit IS 'Debit';


--
-- Name: COLUMN account_move_line.credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.credit IS 'Credit';


--
-- Name: COLUMN account_move_line.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.balance IS 'Balance';


--
-- Name: COLUMN account_move_line.amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_currency IS 'Amount in Currency';


--
-- Name: COLUMN account_move_line.tax_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.tax_base_amount IS 'Base Amount';


--
-- Name: COLUMN account_move_line.amount_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual IS 'Residual Amount';


--
-- Name: COLUMN account_move_line.amount_residual_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.amount_residual_currency IS 'Residual Amount in Currency';


--
-- Name: COLUMN account_move_line.quantity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.quantity IS 'Quantity';


--
-- Name: COLUMN account_move_line.price_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_unit IS 'Unit Price';


--
-- Name: COLUMN account_move_line.price_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_subtotal IS 'Subtotal';


--
-- Name: COLUMN account_move_line.price_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.price_total IS 'Total';


--
-- Name: COLUMN account_move_line.discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount IS 'Discount (%)';


--
-- Name: COLUMN account_move_line.discount_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_amount_currency IS 'Discount amount in Currency';


--
-- Name: COLUMN account_move_line.discount_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.discount_balance IS 'Discount Balance';


--
-- Name: COLUMN account_move_line.is_storno; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_storno IS 'Company Storno Accounting';


--
-- Name: COLUMN account_move_line.is_imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_imported IS 'Is Imported';


--
-- Name: COLUMN account_move_line.reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.reconciled IS 'Reconciled';


--
-- Name: COLUMN account_move_line.collapse_composition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.collapse_composition IS 'Hide Composition';


--
-- Name: COLUMN account_move_line.collapse_prices; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.collapse_prices IS 'Hide Prices';


--
-- Name: COLUMN account_move_line.no_followup; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.no_followup IS 'No Follow-Up';


--
-- Name: COLUMN account_move_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.create_date IS 'Created on';


--
-- Name: COLUMN account_move_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_line.deductible_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deductible_amount IS 'Deductibility';


--
-- Name: COLUMN account_move_line.deferred_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deferred_start_date IS 'Start Date';


--
-- Name: COLUMN account_move_line.deferred_end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.deferred_end_date IS 'End Date';


--
-- Name: COLUMN account_move_line.purchase_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.purchase_line_id IS 'Purchase Order Line';


--
-- Name: COLUMN account_move_line.is_downpayment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_downpayment IS 'Is Downpayment';


--
-- Name: COLUMN account_move_line.cogs_origin_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.cogs_origin_id IS 'Cogs Origin';


--
-- Name: COLUMN account_move_line.exclude_bank_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.exclude_bank_lines IS 'Exclude Bank Lines';


--
-- Name: COLUMN account_move_line.purchase_subscription_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.purchase_subscription_id IS 'Purchase Subscription';


--
-- Name: COLUMN account_move_line.followup_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.followup_line_id IS 'Follow-up Level';


--
-- Name: COLUMN account_move_line.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.user_id IS 'Contact Salesperson';


--
-- Name: COLUMN account_move_line.is_landed_costs_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.is_landed_costs_line IS 'Is Landed Costs Line';


--
-- Name: COLUMN account_move_line.l10n_pe_edi_allowance_charge_reason_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.l10n_pe_edi_allowance_charge_reason_code IS 'Allowance or Charge reason';


--
-- Name: COLUMN account_move_line.subscription_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_line.subscription_id IS 'Subscription';


--
-- Name: CONSTRAINT account_move_line_check_accountable_required_fields ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_accountable_required_fields ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_subsection'', ''line_note'') OR account_id IS NOT NULL)';


--
-- Name: CONSTRAINT account_move_line_check_amount_currency_balance_sign ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_amount_currency_balance_sign ON public.account_move_line IS 'CHECK(
                display_type IN (''line_section'', ''line_subsection'', ''line_note'')
                OR (
                    (balance <= 0 AND amount_currency <= 0)
                    OR
                    (balance >= 0 AND amount_currency >= 0)
                )
            )';


--
-- Name: CONSTRAINT account_move_line_check_credit_debit ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_credit_debit ON public.account_move_line IS 'CHECK(display_type IN (''line_section'', ''line_subsection'', ''line_note'') OR credit * debit=0)';


--
-- Name: CONSTRAINT account_move_line_check_non_accountable_fields_null ON account_move_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_move_line_check_non_accountable_fields_null ON public.account_move_line IS 'CHECK(display_type NOT IN (''line_section'', ''line_subsection'', ''line_note'') OR (amount_currency = 0 AND debit = 0 AND credit = 0 AND account_id IS NULL))';


--
-- Name: account_move_line_account_payment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_payment_rel (
    account_move_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_payment_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_payment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_payment_rel IS 'RELATION BETWEEN account_move_line AND account_payment';


--
-- Name: account_move_line_account_reconcile_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_reconcile_wizard_rel (
    account_reconcile_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_reconcile_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_reconcile_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_reconcile_wizard_rel IS 'RELATION BETWEEN account_reconcile_wizard AND account_move_line';


--
-- Name: account_move_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_account_tax_rel (
    account_move_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_move_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_account_tax_rel IS 'RELATION BETWEEN account_move_line AND account_tax';


--
-- Name: account_move_line_asset_modify_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_asset_modify_rel (
    asset_modify_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_asset_modify_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_asset_modify_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_asset_modify_rel IS 'RELATION BETWEEN asset_modify AND account_move_line';


--
-- Name: account_move_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_line_id_seq OWNER TO runbot;

--
-- Name: account_move_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_line_id_seq OWNED BY public.account_move_line.id;


--
-- Name: account_move_line_l10n_us_1099_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_l10n_us_1099_wizard_rel (
    l10n_us_1099_wizard_id integer NOT NULL,
    account_move_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_l10n_us_1099_wizard_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_l10n_us_1099_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_l10n_us_1099_wizard_rel IS 'RELATION BETWEEN l10n_us_1099_wizard AND account_move_line';


--
-- Name: account_move_line_l10n_uy_edi_addenda_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_l10n_uy_edi_addenda_rel (
    account_move_line_id integer NOT NULL,
    l10n_uy_edi_addenda_id integer NOT NULL
);


ALTER TABLE public.account_move_line_l10n_uy_edi_addenda_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_l10n_uy_edi_addenda_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_l10n_uy_edi_addenda_rel IS 'RELATION BETWEEN account_move_line AND l10n_uy_edi_addenda';


--
-- Name: account_move_line_payment_to_pay_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_line_payment_to_pay_rel (
    payment_id integer NOT NULL,
    to_pay_line_id integer NOT NULL
);


ALTER TABLE public.account_move_line_payment_to_pay_rel OWNER TO runbot;

--
-- Name: TABLE account_move_line_payment_to_pay_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_line_payment_to_pay_rel IS 'RELATION BETWEEN account_payment AND account_move_line';


--
-- Name: account_move_loan_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_loan_rel (
    move_id integer NOT NULL,
    loan_move_id integer NOT NULL
);


ALTER TABLE public.account_move_loan_rel OWNER TO runbot;

--
-- Name: TABLE account_move_loan_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_loan_rel IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: account_move_purchase_order_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_purchase_order_rel (
    purchase_order_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_purchase_order_rel OWNER TO runbot;

--
-- Name: TABLE account_move_purchase_order_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_purchase_order_rel IS 'RELATION BETWEEN purchase_order AND account_move';


--
-- Name: account_move_reversal; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reason character varying,
    date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_latam_document_type_id integer,
    l10n_latam_document_number character varying,
    l10n_es_edi_facturae_reason_code character varying,
    l10n_ar_afip_fce_is_cancellation boolean,
    l10n_cl_edi_reference_doc_code character varying,
    l10n_cl_original_text character varying,
    l10n_cl_corrected_text character varying,
    l10n_cl_is_text_correction boolean,
    l10n_pe_edi_refund_reason character varying
);


ALTER TABLE public.account_move_reversal OWNER TO runbot;

--
-- Name: TABLE account_move_reversal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal IS 'Account Move Reversal';


--
-- Name: COLUMN account_move_reversal.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.journal_id IS 'Journal';


--
-- Name: COLUMN account_move_reversal.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.company_id IS 'Company';


--
-- Name: COLUMN account_move_reversal.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_reversal.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_reversal.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.reason IS 'Reason displayed on Credit Note';


--
-- Name: COLUMN account_move_reversal.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.date IS 'Reversal date';


--
-- Name: COLUMN account_move_reversal.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.create_date IS 'Created on';


--
-- Name: COLUMN account_move_reversal.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_move_reversal.l10n_latam_document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_latam_document_number IS 'Document Number';


--
-- Name: COLUMN account_move_reversal.l10n_es_edi_facturae_reason_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_es_edi_facturae_reason_code IS 'Spanish Facturae EDI Reason Code';


--
-- Name: COLUMN account_move_reversal.l10n_ar_afip_fce_is_cancellation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_ar_afip_fce_is_cancellation IS 'FCE: Is Cancellation?';


--
-- Name: COLUMN account_move_reversal.l10n_cl_edi_reference_doc_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_cl_edi_reference_doc_code IS 'SII Reference Code';


--
-- Name: COLUMN account_move_reversal.l10n_cl_original_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_cl_original_text IS 'Original Text';


--
-- Name: COLUMN account_move_reversal.l10n_cl_corrected_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_cl_corrected_text IS 'New Corrected Text';


--
-- Name: COLUMN account_move_reversal.l10n_cl_is_text_correction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_cl_is_text_correction IS 'Only Text Correction';


--
-- Name: COLUMN account_move_reversal.l10n_pe_edi_refund_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_reversal.l10n_pe_edi_refund_reason IS 'Credit Reason';


--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_reversal_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_reversal_id_seq OWNER TO runbot;

--
-- Name: account_move_reversal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_reversal_id_seq OWNED BY public.account_move_reversal.id;


--
-- Name: account_move_reversal_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_move (
    reversal_id integer NOT NULL,
    move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_reversal_new_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_reversal_new_move (
    reversal_id integer NOT NULL,
    new_move_id integer NOT NULL
);


ALTER TABLE public.account_move_reversal_new_move OWNER TO runbot;

--
-- Name: TABLE account_move_reversal_new_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_reversal_new_move IS 'RELATION BETWEEN account_move_reversal AND account_move';


--
-- Name: account_move_send_batch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_batch_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_batch_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_batch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_batch_wizard IS 'Account Move Send Batch Wizard';


--
-- Name: COLUMN account_move_send_batch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_batch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_batch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_batch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_batch_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_batch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_batch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_batch_wizard_id_seq OWNED BY public.account_move_send_batch_wizard.id;


--
-- Name: account_move_send_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard (
    id integer NOT NULL,
    template_id integer,
    move_id integer NOT NULL,
    pdf_report_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    model character varying,
    template_name character varying,
    sending_method_checkboxes jsonb,
    extra_edi_checkboxes jsonb,
    mail_attachments_widget jsonb,
    body text,
    res_ids text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_move_send_wizard OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard IS 'Account Move Send Wizard';


--
-- Name: COLUMN account_move_send_wizard.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.template_id IS 'Mail Template';


--
-- Name: COLUMN account_move_send_wizard.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.move_id IS 'Move';


--
-- Name: COLUMN account_move_send_wizard.pdf_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.pdf_report_id IS 'Invoice report';


--
-- Name: COLUMN account_move_send_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_move_send_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_move_send_wizard.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.lang IS 'Language';


--
-- Name: COLUMN account_move_send_wizard.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.subject IS 'Subject';


--
-- Name: COLUMN account_move_send_wizard.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.model IS 'Related Document Model';


--
-- Name: COLUMN account_move_send_wizard.template_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.template_name IS 'Template Name';


--
-- Name: COLUMN account_move_send_wizard.sending_method_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.sending_method_checkboxes IS 'Sending Method Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.extra_edi_checkboxes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.extra_edi_checkboxes IS 'Extra Edi Checkboxes';


--
-- Name: COLUMN account_move_send_wizard.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_move_send_wizard.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.body IS 'Contents';


--
-- Name: COLUMN account_move_send_wizard.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN account_move_send_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_move_send_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_move_send_wizard.write_date IS 'Last Updated on';


--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_move_send_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNER TO runbot;

--
-- Name: account_move_send_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_move_send_wizard_id_seq OWNED BY public.account_move_send_wizard.id;


--
-- Name: account_move_send_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_send_wizard_res_partner_rel (
    account_move_send_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_move_send_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_move_send_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_send_wizard_res_partner_rel IS 'RELATION BETWEEN account_move_send_wizard AND res_partner';


--
-- Name: account_move_stock_picking_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_stock_picking_rel (
    account_move_id integer NOT NULL,
    stock_picking_id integer NOT NULL
);


ALTER TABLE public.account_move_stock_picking_rel OWNER TO runbot;

--
-- Name: TABLE account_move_stock_picking_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_stock_picking_rel IS 'RELATION BETWEEN account_move AND stock_picking';


--
-- Name: account_move_validate_account_move_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_move_validate_account_move_rel (
    validate_account_move_id integer NOT NULL,
    account_move_id integer NOT NULL
);


ALTER TABLE public.account_move_validate_account_move_rel OWNER TO runbot;

--
-- Name: TABLE account_move_validate_account_move_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_move_validate_account_move_rel IS 'RELATION BETWEEN validate_account_move AND account_move';


--
-- Name: account_multicurrency_revaluation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_multicurrency_revaluation_wizard (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    reversal_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_multicurrency_revaluation_wizard OWNER TO runbot;

--
-- Name: TABLE account_multicurrency_revaluation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_multicurrency_revaluation_wizard IS 'Multicurrency Revaluation Wizard';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.date IS 'Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.reversal_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.reversal_date IS 'Reversal Date';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_multicurrency_revaluation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_multicurrency_revaluation_wizard.write_date IS 'Last Updated on';


--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNER TO runbot;

--
-- Name: account_multicurrency_revaluation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_multicurrency_revaluation_wizard_id_seq OWNED BY public.account_multicurrency_revaluation_wizard.id;


--
-- Name: account_online_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_account (
    id integer NOT NULL,
    account_online_link_id integer,
    currency_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    online_identifier character varying,
    account_number character varying,
    account_data character varying,
    fetching_status character varying,
    last_sync timestamp without time zone,
    inverse_balance_sign boolean,
    inverse_transaction_sign boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    balance double precision,
    available_balance double precision,
    status character varying,
    last_balance_sync timestamp without time zone
);


ALTER TABLE public.account_online_account OWNER TO runbot;

--
-- Name: TABLE account_online_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_account IS 'representation of an online bank account';


--
-- Name: COLUMN account_online_account.account_online_link_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_online_link_id IS 'Account Online Link';


--
-- Name: COLUMN account_online_account.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.currency_id IS 'Currency';


--
-- Name: COLUMN account_online_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.name IS 'Account Name';


--
-- Name: COLUMN account_online_account.online_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.online_identifier IS 'Online Identifier';


--
-- Name: COLUMN account_online_account.account_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_number IS 'Account Number';


--
-- Name: COLUMN account_online_account.account_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.account_data IS 'Account Data';


--
-- Name: COLUMN account_online_account.fetching_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.fetching_status IS 'Fetching Status';


--
-- Name: COLUMN account_online_account.last_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.last_sync IS 'Last Transaction Synchronized on';


--
-- Name: COLUMN account_online_account.inverse_balance_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_balance_sign IS 'Inverse Balance Sign';


--
-- Name: COLUMN account_online_account.inverse_transaction_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.inverse_transaction_sign IS 'Inverse Transaction Sign';


--
-- Name: COLUMN account_online_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.create_date IS 'Created on';


--
-- Name: COLUMN account_online_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_online_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.balance IS 'Balance';


--
-- Name: COLUMN account_online_account.available_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.available_balance IS 'Available Balance';


--
-- Name: COLUMN account_online_account.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.status IS 'Status';


--
-- Name: COLUMN account_online_account.last_balance_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_account.last_balance_sync IS 'Last Balance Sync';


--
-- Name: account_online_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_account_id_seq OWNER TO runbot;

--
-- Name: account_online_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_account_id_seq OWNED BY public.account_online_account.id;


--
-- Name: account_online_link; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_online_link (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    client_id character varying,
    refresh_token character varying,
    access_token character varying,
    provider_type character varying,
    renewal_contact_email character varying,
    expiring_synchronization_date date,
    connection_state_details jsonb,
    auto_sync boolean,
    has_unlinked_accounts boolean,
    last_refresh timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    customer_id character varying,
    client_secret character varying,
    status_code character varying,
    is_payment_enabled boolean,
    is_payment_activated boolean
);


ALTER TABLE public.account_online_link OWNER TO runbot;

--
-- Name: TABLE account_online_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_online_link IS 'Bank Connection';


--
-- Name: COLUMN account_online_link.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.company_id IS 'Company';


--
-- Name: COLUMN account_online_link.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_uid IS 'Created by';


--
-- Name: COLUMN account_online_link.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_online_link.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.state IS 'State';


--
-- Name: COLUMN account_online_link.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.name IS 'Name';


--
-- Name: COLUMN account_online_link.client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.client_id IS 'Client';


--
-- Name: COLUMN account_online_link.refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.refresh_token IS 'Refresh Token';


--
-- Name: COLUMN account_online_link.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.access_token IS 'Access Token';


--
-- Name: COLUMN account_online_link.provider_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.provider_type IS 'Provider Type';


--
-- Name: COLUMN account_online_link.renewal_contact_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.renewal_contact_email IS 'Connection Requests';


--
-- Name: COLUMN account_online_link.expiring_synchronization_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.expiring_synchronization_date IS 'Expiring Synchronization Date';


--
-- Name: COLUMN account_online_link.connection_state_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.connection_state_details IS 'Connection State Details';


--
-- Name: COLUMN account_online_link.auto_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.auto_sync IS 'Automatic synchronization';


--
-- Name: COLUMN account_online_link.has_unlinked_accounts; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.has_unlinked_accounts IS 'Has Unlinked Accounts';


--
-- Name: COLUMN account_online_link.last_refresh; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.last_refresh IS 'Last Synchronization';


--
-- Name: COLUMN account_online_link.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.create_date IS 'Created on';


--
-- Name: COLUMN account_online_link.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_online_link.customer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.customer_id IS 'Customer';


--
-- Name: COLUMN account_online_link.client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.client_secret IS 'Client Secret';


--
-- Name: COLUMN account_online_link.status_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.status_code IS 'Status Code';


--
-- Name: COLUMN account_online_link.is_payment_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.is_payment_enabled IS 'Is Payment Enabled';


--
-- Name: COLUMN account_online_link.is_payment_activated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_online_link.is_payment_activated IS 'Is Payment Activated';


--
-- Name: account_online_link_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_online_link_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_online_link_id_seq OWNER TO runbot;

--
-- Name: account_online_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_online_link_id_seq OWNED BY public.account_online_link.id;


--
-- Name: account_partial_reconcile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_partial_reconcile (
    id integer NOT NULL,
    debit_move_id integer NOT NULL,
    credit_move_id integer NOT NULL,
    full_reconcile_id integer,
    exchange_move_id integer,
    debit_currency_id integer,
    credit_currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    max_date date,
    draft_caba_move_vals jsonb,
    amount numeric,
    debit_amount_currency numeric,
    credit_amount_currency numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    exchange_diff_adjustment_required boolean,
    exchange_diff_invoice_id integer,
    exchange_diff_ignored boolean
);


ALTER TABLE public.account_partial_reconcile OWNER TO runbot;

--
-- Name: TABLE account_partial_reconcile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_partial_reconcile IS 'Partial Reconcile';


--
-- Name: COLUMN account_partial_reconcile.debit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_move_id IS 'Debit Move';


--
-- Name: COLUMN account_partial_reconcile.credit_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_move_id IS 'Credit Move';


--
-- Name: COLUMN account_partial_reconcile.full_reconcile_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.full_reconcile_id IS 'Full Reconcile';


--
-- Name: COLUMN account_partial_reconcile.exchange_move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_move_id IS 'Exchange Move';


--
-- Name: COLUMN account_partial_reconcile.debit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_currency_id IS 'Currency of the debit journal item.';


--
-- Name: COLUMN account_partial_reconcile.credit_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_currency_id IS 'Currency of the credit journal item.';


--
-- Name: COLUMN account_partial_reconcile.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.company_id IS 'Company';


--
-- Name: COLUMN account_partial_reconcile.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_uid IS 'Created by';


--
-- Name: COLUMN account_partial_reconcile.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_partial_reconcile.max_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.max_date IS 'Max Date of Matched Lines';


--
-- Name: COLUMN account_partial_reconcile.draft_caba_move_vals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.draft_caba_move_vals IS 'Values that created the draft cash-basis entry';


--
-- Name: COLUMN account_partial_reconcile.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.amount IS 'Amount';


--
-- Name: COLUMN account_partial_reconcile.debit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.debit_amount_currency IS 'Debit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.credit_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.credit_amount_currency IS 'Credit Amount Currency';


--
-- Name: COLUMN account_partial_reconcile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.create_date IS 'Created on';


--
-- Name: COLUMN account_partial_reconcile.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_partial_reconcile.exchange_diff_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_diff_invoice_id IS 'NC/ND de ajuste por dif de cambio';


--
-- Name: COLUMN account_partial_reconcile.exchange_diff_ignored; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_partial_reconcile.exchange_diff_ignored IS 'Exchange Diff Ignored';


--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_partial_reconcile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNER TO runbot;

--
-- Name: account_partial_reconcile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_partial_reconcile_id_seq OWNED BY public.account_partial_reconcile.id;


--
-- Name: account_payment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment (
    id integer NOT NULL,
    message_main_attachment_id integer,
    move_id integer,
    journal_id integer NOT NULL,
    company_id integer NOT NULL,
    partner_bank_id integer,
    paired_internal_transfer_payment_id integer,
    payment_method_line_id integer,
    payment_method_id integer,
    currency_id integer,
    partner_id integer,
    outstanding_account_id integer,
    destination_account_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    state character varying NOT NULL,
    payment_type character varying NOT NULL,
    partner_type character varying NOT NULL,
    memo character varying,
    payment_reference character varying,
    date date NOT NULL,
    amount numeric,
    amount_company_currency_signed numeric,
    is_reconciled boolean,
    is_matched boolean,
    is_sent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    batch_payment_id integer,
    check_number character varying,
    check_amount_in_words character varying,
    destination_company_id integer,
    destination_journal_id integer,
    is_internal_transfer boolean,
    payment_transaction_id integer,
    payment_token_id integer,
    source_payment_id integer,
    direct_debit_mandate_id integer,
    pos_payment_method_id integer,
    force_outstanding_account_id integer,
    pos_session_id integer,
    counterpart_currency_id integer,
    write_off_type_id integer,
    counterpart_exchange_rate numeric,
    force_amount_company_currency numeric,
    unreconciled_amount numeric,
    write_off_amount numeric,
    pos_order_id integer,
    cashbox_session_id integer,
    card_id integer,
    installment_id integer,
    receiptbook_id integer,
    l10n_latam_move_check_ids_operation_date timestamp without time zone,
    loan_surcharge numeric,
    is_loan_payment boolean,
    l10n_ar_fiscal_position_id integer,
    withholdable_advanced_amount numeric,
    main_payment_id integer,
    is_main_payment boolean,
    is_backward_withholding_payment boolean,
    end_to_end_uuid character varying,
    iso20022_uetr character varying,
    iso20022_priority character varying,
    iso20022_charge_bearer character varying,
    CONSTRAINT account_payment_check_amount_not_negative CHECK ((amount >= 0.0))
);


ALTER TABLE public.account_payment OWNER TO runbot;

--
-- Name: TABLE account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment IS 'Payments';


--
-- Name: COLUMN account_payment.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_payment.move_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.move_id IS 'Journal Entry';


--
-- Name: COLUMN account_payment.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.company_id IS 'Company';


--
-- Name: COLUMN account_payment.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment.paired_internal_transfer_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.paired_internal_transfer_payment_id IS 'Paired Internal Transfer Payment';


--
-- Name: COLUMN account_payment.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_method_id IS 'Method';


--
-- Name: COLUMN account_payment.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment.outstanding_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.outstanding_account_id IS 'Outstanding Account';


--
-- Name: COLUMN account_payment.destination_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_account_id IS 'Destination Account';


--
-- Name: COLUMN account_payment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.name IS 'Number';


--
-- Name: COLUMN account_payment.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.state IS 'State';


--
-- Name: COLUMN account_payment.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment.memo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.memo IS 'Memo';


--
-- Name: COLUMN account_payment.payment_reference; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_reference IS 'Payment Reference';


--
-- Name: COLUMN account_payment.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.date IS 'Date';


--
-- Name: COLUMN account_payment.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount IS 'Amount';


--
-- Name: COLUMN account_payment.amount_company_currency_signed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.amount_company_currency_signed IS 'Amount Company Currency Signed';


--
-- Name: COLUMN account_payment.is_reconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_reconciled IS 'Is Reconciled';


--
-- Name: COLUMN account_payment.is_matched; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_matched IS 'Is Matched With a Bank Statement';


--
-- Name: COLUMN account_payment.is_sent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_sent IS 'Is Sent';


--
-- Name: COLUMN account_payment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.create_date IS 'Created on';


--
-- Name: COLUMN account_payment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment.batch_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.batch_payment_id IS 'Batch Payment';


--
-- Name: COLUMN account_payment.check_amount_in_words; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.check_amount_in_words IS 'Amount in Words';


--
-- Name: COLUMN account_payment.destination_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_company_id IS 'Destination Company';


--
-- Name: COLUMN account_payment.destination_journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.destination_journal_id IS 'Destination Journal';


--
-- Name: COLUMN account_payment.is_internal_transfer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_internal_transfer IS 'Internal Transfer';


--
-- Name: COLUMN account_payment.payment_transaction_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_transaction_id IS 'Payment Transaction';


--
-- Name: COLUMN account_payment.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.payment_token_id IS 'Saved Payment Token';


--
-- Name: COLUMN account_payment.source_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.source_payment_id IS 'Source Payment';


--
-- Name: COLUMN account_payment.direct_debit_mandate_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.direct_debit_mandate_id IS 'Direct Debit Mandate';


--
-- Name: COLUMN account_payment.pos_payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.pos_payment_method_id IS 'POS Payment Method';


--
-- Name: COLUMN account_payment.force_outstanding_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.force_outstanding_account_id IS 'Forced Outstanding Account';


--
-- Name: COLUMN account_payment.pos_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.pos_session_id IS 'POS Session';


--
-- Name: COLUMN account_payment.counterpart_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_currency_id IS 'Counterpart Currency';


--
-- Name: COLUMN account_payment.write_off_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_off_type_id IS 'Write Off Type';


--
-- Name: COLUMN account_payment.counterpart_exchange_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.counterpart_exchange_rate IS 'Counterpart Exchange Rate';


--
-- Name: COLUMN account_payment.force_amount_company_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.force_amount_company_currency IS 'Forced Amount on Company Currency';


--
-- Name: COLUMN account_payment.unreconciled_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.unreconciled_amount IS 'Adjustment / Advance';


--
-- Name: COLUMN account_payment.write_off_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.write_off_amount IS 'Write Off Amount';


--
-- Name: COLUMN account_payment.pos_order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.pos_order_id IS 'POS Order';


--
-- Name: COLUMN account_payment.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.cashbox_session_id IS 'POP Session';


--
-- Name: COLUMN account_payment.card_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.card_id IS 'Card';


--
-- Name: COLUMN account_payment.installment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.installment_id IS 'Installment plan';


--
-- Name: COLUMN account_payment.receiptbook_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.receiptbook_id IS 'ReceiptBook';


--
-- Name: COLUMN account_payment.l10n_latam_move_check_ids_operation_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_latam_move_check_ids_operation_date IS 'Operation Date';


--
-- Name: COLUMN account_payment.loan_surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.loan_surcharge IS 'Loan Surcharge';


--
-- Name: COLUMN account_payment.is_loan_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_loan_payment IS 'Is Loan Payment';


--
-- Name: COLUMN account_payment.l10n_ar_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.l10n_ar_fiscal_position_id IS 'Fiscal Position';


--
-- Name: COLUMN account_payment.withholdable_advanced_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.withholdable_advanced_amount IS 'Adjustment / Advance (untaxed)';


--
-- Name: COLUMN account_payment.main_payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.main_payment_id IS 'Main Payment';


--
-- Name: COLUMN account_payment.is_main_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_main_payment IS 'Is Main Payment';


--
-- Name: COLUMN account_payment.is_backward_withholding_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.is_backward_withholding_payment IS 'Is Backward Withholding Payment';


--
-- Name: COLUMN account_payment.end_to_end_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.end_to_end_uuid IS 'End to End ID';


--
-- Name: COLUMN account_payment.iso20022_uetr; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.iso20022_uetr IS 'UETR';


--
-- Name: COLUMN account_payment.iso20022_priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.iso20022_priority IS 'Priority';


--
-- Name: COLUMN account_payment.iso20022_charge_bearer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment.iso20022_charge_bearer IS 'Charge Bearer';


--
-- Name: CONSTRAINT account_payment_check_amount_not_negative ON account_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_payment_check_amount_not_negative ON public.account_payment IS 'CHECK(amount >= 0.0)';


--
-- Name: account_payment_account_bank_statement_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_account_bank_statement_line_rel (
    account_bank_statement_line_id integer NOT NULL,
    account_payment_id integer NOT NULL
);


ALTER TABLE public.account_payment_account_bank_statement_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_account_bank_statement_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_account_bank_statement_line_rel IS 'RELATION BETWEEN account_bank_statement_line AND account_payment';


--
-- Name: account_payment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_id_seq OWNER TO runbot;

--
-- Name: account_payment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_id_seq OWNED BY public.account_payment.id;


--
-- Name: account_payment_invoice_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_invoice_wizard (
    id integer NOT NULL,
    payment_id integer NOT NULL,
    journal_id integer NOT NULL,
    product_id integer NOT NULL,
    product_account_id integer,
    journal_document_type_id integer,
    create_uid integer,
    write_uid integer,
    description character varying,
    document_number character varying,
    invoice_date date NOT NULL,
    date date,
    analytic_distribution jsonb,
    amount_total numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    origin_invoice_id integer,
    l10n_ar_afip_asoc_period_start date,
    l10n_ar_afip_asoc_period_end date
);


ALTER TABLE public.account_payment_invoice_wizard OWNER TO runbot;

--
-- Name: TABLE account_payment_invoice_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_invoice_wizard IS 'account.payment.invoice.wizard';


--
-- Name: COLUMN account_payment_invoice_wizard.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.payment_id IS 'Payment';


--
-- Name: COLUMN account_payment_invoice_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_invoice_wizard.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.product_id IS 'Product';


--
-- Name: COLUMN account_payment_invoice_wizard.product_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.product_account_id IS 'Product Account';


--
-- Name: COLUMN account_payment_invoice_wizard.journal_document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.journal_document_type_id IS 'Document Type';


--
-- Name: COLUMN account_payment_invoice_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_invoice_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_invoice_wizard.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.description IS 'Reason';


--
-- Name: COLUMN account_payment_invoice_wizard.document_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.document_number IS 'Document Number';


--
-- Name: COLUMN account_payment_invoice_wizard.invoice_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.invoice_date IS 'Refund Date';


--
-- Name: COLUMN account_payment_invoice_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.date IS 'Accounting Date';


--
-- Name: COLUMN account_payment_invoice_wizard.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_payment_invoice_wizard.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.amount_total IS 'Total Amount';


--
-- Name: COLUMN account_payment_invoice_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_invoice_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_invoice_wizard.origin_invoice_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.origin_invoice_id IS 'Origin Invoice';


--
-- Name: COLUMN account_payment_invoice_wizard.l10n_ar_afip_asoc_period_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.l10n_ar_afip_asoc_period_start IS 'Associate Period From';


--
-- Name: COLUMN account_payment_invoice_wizard.l10n_ar_afip_asoc_period_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_invoice_wizard.l10n_ar_afip_asoc_period_end IS 'Associate Period To';


--
-- Name: account_payment_invoice_wizard_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_invoice_wizard_account_tax_rel (
    account_payment_invoice_wizard_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_payment_invoice_wizard_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_invoice_wizard_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_invoice_wizard_account_tax_rel IS 'RELATION BETWEEN account_payment_invoice_wizard AND account_tax';


--
-- Name: account_payment_invoice_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_invoice_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_invoice_wizard_id_seq OWNER TO runbot;

--
-- Name: account_payment_invoice_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_invoice_wizard_id_seq OWNED BY public.account_payment_invoice_wizard.id;


--
-- Name: account_payment_method; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    payment_type character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_method OWNER TO runbot;

--
-- Name: TABLE account_payment_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.code IS 'Code';


--
-- Name: COLUMN account_payment_method.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_method.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.name IS 'Name';


--
-- Name: COLUMN account_payment_method.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method.write_date IS 'Last Updated on';


--
-- Name: account_payment_method_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_id_seq OWNED BY public.account_payment_method.id;


--
-- Name: account_payment_method_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_method_line (
    id integer NOT NULL,
    sequence integer,
    payment_method_id integer NOT NULL,
    payment_account_id integer,
    journal_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_provider_id integer
);


ALTER TABLE public.account_payment_method_line OWNER TO runbot;

--
-- Name: TABLE account_payment_method_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_method_line IS 'Payment Methods';


--
-- Name: COLUMN account_payment_method_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_method_line.payment_method_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_method_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_method_line.payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_account_id IS 'Payment Account';


--
-- Name: COLUMN account_payment_method_line.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_method_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_method_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_method_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.name IS 'Name';


--
-- Name: COLUMN account_payment_method_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_method_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_method_line.payment_provider_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_method_line.payment_provider_id IS 'Payment Provider';


--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_method_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_method_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_method_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_method_line_id_seq OWNED BY public.account_payment_method_line.id;


--
-- Name: account_payment_receiptbook; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_receiptbook (
    id integer NOT NULL,
    report_partner_id integer,
    mail_template_id integer,
    sequence integer,
    sequence_id integer,
    company_id integer NOT NULL,
    document_type_id integer NOT NULL,
    initial_sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying(64) NOT NULL,
    partner_type character varying NOT NULL,
    prefix character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_receiptbook OWNER TO runbot;

--
-- Name: TABLE account_payment_receiptbook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_receiptbook IS 'Account payment Receiptbook';


--
-- Name: COLUMN account_payment_receiptbook.report_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.report_partner_id IS 'Report Partner';


--
-- Name: COLUMN account_payment_receiptbook.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.mail_template_id IS 'Email Template';


--
-- Name: COLUMN account_payment_receiptbook.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_receiptbook.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.sequence_id IS 'Entry Sequence';


--
-- Name: COLUMN account_payment_receiptbook.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.company_id IS 'Company';


--
-- Name: COLUMN account_payment_receiptbook.document_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.document_type_id IS 'Document Type';


--
-- Name: COLUMN account_payment_receiptbook.initial_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.initial_sequence IS 'Initial Sequence';


--
-- Name: COLUMN account_payment_receiptbook.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_receiptbook.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_receiptbook.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.name IS 'Name';


--
-- Name: COLUMN account_payment_receiptbook.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_receiptbook.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.prefix IS 'Prefix';


--
-- Name: COLUMN account_payment_receiptbook.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.active IS 'Active';


--
-- Name: COLUMN account_payment_receiptbook.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_receiptbook.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_receiptbook.write_date IS 'Last Updated on';


--
-- Name: account_payment_receiptbook_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_receiptbook_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_receiptbook_id_seq OWNER TO runbot;

--
-- Name: account_payment_receiptbook_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_receiptbook_id_seq OWNED BY public.account_payment_receiptbook.id;


--
-- Name: account_payment_register; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register (
    id integer NOT NULL,
    currency_id integer,
    journal_id integer,
    partner_bank_id integer,
    custom_user_currency_id integer,
    source_currency_id integer,
    company_id integer,
    partner_id integer,
    payment_method_line_id integer,
    writeoff_account_id integer,
    create_uid integer,
    write_uid integer,
    communication character varying,
    installments_mode character varying,
    payment_type character varying,
    partner_type character varying,
    payment_difference_handling character varying,
    writeoff_label character varying,
    payment_date date NOT NULL,
    amount numeric,
    custom_user_amount numeric,
    source_amount numeric,
    source_amount_currency numeric,
    group_payment boolean,
    can_edit_wizard boolean,
    can_group_payments boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_token_id integer,
    cashbox_session_id integer,
    l10n_ar_fiscal_position_id integer
);


ALTER TABLE public.account_payment_register OWNER TO runbot;

--
-- Name: TABLE account_payment_register; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register IS 'Pay';


--
-- Name: COLUMN account_payment_register.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.currency_id IS 'Currency';


--
-- Name: COLUMN account_payment_register.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.journal_id IS 'Journal';


--
-- Name: COLUMN account_payment_register.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_bank_id IS 'Recipient Bank Account';


--
-- Name: COLUMN account_payment_register.custom_user_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_currency_id IS 'Custom User Currency';


--
-- Name: COLUMN account_payment_register.source_currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_currency_id IS 'Source Currency';


--
-- Name: COLUMN account_payment_register.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.company_id IS 'Company';


--
-- Name: COLUMN account_payment_register.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_id IS 'Customer/Vendor';


--
-- Name: COLUMN account_payment_register.payment_method_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_method_line_id IS 'Payment Method';


--
-- Name: COLUMN account_payment_register.writeoff_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_account_id IS 'Difference Account';


--
-- Name: COLUMN account_payment_register.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_register.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_register.communication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.communication IS 'Memo';


--
-- Name: COLUMN account_payment_register.installments_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.installments_mode IS 'Installments Mode';


--
-- Name: COLUMN account_payment_register.payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_type IS 'Payment Type';


--
-- Name: COLUMN account_payment_register.partner_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.partner_type IS 'Partner Type';


--
-- Name: COLUMN account_payment_register.payment_difference_handling; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_difference_handling IS 'Payment Difference Handling';


--
-- Name: COLUMN account_payment_register.writeoff_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.writeoff_label IS 'Journal Item Label';


--
-- Name: COLUMN account_payment_register.payment_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_date IS 'Payment Date';


--
-- Name: COLUMN account_payment_register.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.amount IS 'Amount';


--
-- Name: COLUMN account_payment_register.custom_user_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.custom_user_amount IS 'Custom User Amount';


--
-- Name: COLUMN account_payment_register.source_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount IS 'Amount to Pay (company currency)';


--
-- Name: COLUMN account_payment_register.source_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.source_amount_currency IS 'Amount to Pay (foreign currency)';


--
-- Name: COLUMN account_payment_register.group_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.group_payment IS 'Group Payments';


--
-- Name: COLUMN account_payment_register.can_edit_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_edit_wizard IS 'Can Edit Wizard';


--
-- Name: COLUMN account_payment_register.can_group_payments; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.can_group_payments IS 'Can Group Payments';


--
-- Name: COLUMN account_payment_register.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_register.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_register.payment_token_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.payment_token_id IS 'Saved payment token';


--
-- Name: COLUMN account_payment_register.cashbox_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.cashbox_session_id IS 'POP Session';


--
-- Name: COLUMN account_payment_register.l10n_ar_fiscal_position_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_register.l10n_ar_fiscal_position_id IS 'Fiscal Position';


--
-- Name: account_payment_register_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_register_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_register_id_seq OWNER TO runbot;

--
-- Name: account_payment_register_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_register_id_seq OWNED BY public.account_payment_register.id;


--
-- Name: account_payment_register_l10n_latam_check_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_l10n_latam_check_rel (
    account_payment_register_id integer NOT NULL,
    l10n_latam_check_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_l10n_latam_check_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_l10n_latam_check_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_l10n_latam_check_rel IS 'RELATION BETWEEN account_payment_register AND l10n_latam_check';


--
-- Name: account_payment_register_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_register_move_line_rel (
    wizard_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.account_payment_register_move_line_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_register_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_register_move_line_rel IS 'RELATION BETWEEN account_payment_register AND account_move_line';


--
-- Name: account_payment_term; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term (
    id integer NOT NULL,
    company_id integer,
    sequence integer NOT NULL,
    discount_days integer,
    create_uid integer,
    write_uid integer,
    early_pay_discount_computation character varying,
    name jsonb NOT NULL,
    note jsonb,
    active boolean,
    display_on_invoice boolean,
    early_discount boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    discount_percentage double precision,
    l10n_cl_sii_code character varying
);


ALTER TABLE public.account_payment_term OWNER TO runbot;

--
-- Name: TABLE account_payment_term; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.company_id IS 'Company';


--
-- Name: COLUMN account_payment_term.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term.discount_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_days IS 'Discount Days';


--
-- Name: COLUMN account_payment_term.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term.early_pay_discount_computation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_pay_discount_computation IS 'Cash Discount Tax Reduction';


--
-- Name: COLUMN account_payment_term.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.name IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.note IS 'Description on the Invoice';


--
-- Name: COLUMN account_payment_term.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.active IS 'Active';


--
-- Name: COLUMN account_payment_term.display_on_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.display_on_invoice IS 'Show installment dates';


--
-- Name: COLUMN account_payment_term.early_discount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.early_discount IS 'Early Discount';


--
-- Name: COLUMN account_payment_term.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term.discount_percentage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.discount_percentage IS 'Discount %';


--
-- Name: COLUMN account_payment_term.l10n_cl_sii_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term.l10n_cl_sii_code IS 'DTE SII Code';


--
-- Name: account_payment_term_allowed_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_allowed_rel (
    user_id integer NOT NULL,
    payment_term_id integer NOT NULL
);


ALTER TABLE public.account_payment_term_allowed_rel OWNER TO runbot;

--
-- Name: TABLE account_payment_term_allowed_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_allowed_rel IS 'RELATION BETWEEN account_payment_term AND account_payment_term';


--
-- Name: account_payment_term_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_id_seq OWNED BY public.account_payment_term.id;


--
-- Name: account_payment_term_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_line (
    id integer NOT NULL,
    nb_days integer,
    payment_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    delay_type character varying NOT NULL,
    days_next_month character varying(2),
    value_amount numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_payment_term_line OWNER TO runbot;

--
-- Name: TABLE account_payment_term_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_line IS 'Payment Terms Line';


--
-- Name: COLUMN account_payment_term_line.nb_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.nb_days IS 'Days';


--
-- Name: COLUMN account_payment_term_line.payment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.payment_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_line.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value IS 'Value';


--
-- Name: COLUMN account_payment_term_line.delay_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.delay_type IS 'Delay Type';


--
-- Name: COLUMN account_payment_term_line.days_next_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.days_next_month IS 'Days on the next month';


--
-- Name: COLUMN account_payment_term_line.value_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.value_amount IS 'Due';


--
-- Name: COLUMN account_payment_term_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_line.write_date IS 'Last Updated on';


--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_line_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_line_id_seq OWNED BY public.account_payment_term_line.id;


--
-- Name: account_payment_term_surcharge; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_payment_term_surcharge (
    id integer NOT NULL,
    payment_term_id integer NOT NULL,
    days integer NOT NULL,
    day_of_the_month integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    option character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    surcharge double precision
);


ALTER TABLE public.account_payment_term_surcharge OWNER TO runbot;

--
-- Name: TABLE account_payment_term_surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_payment_term_surcharge IS 'Payment Terms Surcharge';


--
-- Name: COLUMN account_payment_term_surcharge.payment_term_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.payment_term_id IS 'Payment Terms';


--
-- Name: COLUMN account_payment_term_surcharge.days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.days IS 'Number of Days';


--
-- Name: COLUMN account_payment_term_surcharge.day_of_the_month; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.day_of_the_month IS 'Day of the month';


--
-- Name: COLUMN account_payment_term_surcharge.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.sequence IS 'Sequence';


--
-- Name: COLUMN account_payment_term_surcharge.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.create_uid IS 'Created by';


--
-- Name: COLUMN account_payment_term_surcharge.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_payment_term_surcharge.option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.option IS 'Options';


--
-- Name: COLUMN account_payment_term_surcharge.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.create_date IS 'Created on';


--
-- Name: COLUMN account_payment_term_surcharge.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_payment_term_surcharge.surcharge; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_payment_term_surcharge.surcharge IS 'Surcharge [%]';


--
-- Name: account_payment_term_surcharge_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_payment_term_surcharge_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_payment_term_surcharge_id_seq OWNER TO runbot;

--
-- Name: account_payment_term_surcharge_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_payment_term_surcharge_id_seq OWNED BY public.account_payment_term_surcharge.id;


--
-- Name: account_reconcile_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model (
    id integer NOT NULL,
    sequence integer NOT NULL,
    company_id integer NOT NULL,
    next_activity_type_id integer,
    mapped_partner_id integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    match_amount character varying,
    match_label character varying,
    match_label_param character varying,
    name jsonb NOT NULL,
    active boolean,
    can_be_proposed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    match_amount_min double precision,
    match_amount_max double precision,
    created_automatically boolean
);


ALTER TABLE public.account_reconcile_model OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model IS 'Preset to create journal entries during a invoices and payments matching';


--
-- Name: COLUMN account_reconcile_model.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model.next_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.next_activity_type_id IS 'Next Activity';


--
-- Name: COLUMN account_reconcile_model.mapped_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.mapped_partner_id IS 'Mapped Partner';


--
-- Name: COLUMN account_reconcile_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.trigger IS 'Trigger';


--
-- Name: COLUMN account_reconcile_model.match_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount IS 'Amount';


--
-- Name: COLUMN account_reconcile_model.match_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label IS 'Label';


--
-- Name: COLUMN account_reconcile_model.match_label_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_label_param IS 'Label Parameter';


--
-- Name: COLUMN account_reconcile_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.name IS 'Name';


--
-- Name: COLUMN account_reconcile_model.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.active IS 'Active';


--
-- Name: COLUMN account_reconcile_model.can_be_proposed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.can_be_proposed IS 'Can Be Proposed';


--
-- Name: COLUMN account_reconcile_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model.match_amount_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_min IS 'Amount Min Parameter';


--
-- Name: COLUMN account_reconcile_model.match_amount_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.match_amount_max IS 'Amount Max Parameter';


--
-- Name: COLUMN account_reconcile_model.created_automatically; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model.created_automatically IS 'Created Automatically';


--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_id_seq OWNED BY public.account_reconcile_model.id;


--
-- Name: account_reconcile_model_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line (
    id integer NOT NULL,
    model_id integer,
    company_id integer,
    sequence integer NOT NULL,
    account_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    amount_type character varying NOT NULL,
    amount_string character varying NOT NULL,
    analytic_distribution jsonb,
    label jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_reconcile_model_line OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line IS 'Rules for the reconciliation model';


--
-- Name: COLUMN account_reconcile_model_line.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.model_id IS 'Model';


--
-- Name: COLUMN account_reconcile_model_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.company_id IS 'Company';


--
-- Name: COLUMN account_reconcile_model_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_reconcile_model_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_model_line.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_model_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_model_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_model_line.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_type IS 'Amount Type';


--
-- Name: COLUMN account_reconcile_model_line.amount_string; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount_string IS 'Amount';


--
-- Name: COLUMN account_reconcile_model_line.analytic_distribution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.analytic_distribution IS 'Analytic Distribution';


--
-- Name: COLUMN account_reconcile_model_line.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.label IS 'Label';


--
-- Name: COLUMN account_reconcile_model_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_model_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reconcile_model_line.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_model_line.amount IS 'Float Amount';


--
-- Name: account_reconcile_model_line_account_tax_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_line_account_tax_rel (
    account_reconcile_model_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_line_account_tax_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_line_account_tax_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_line_account_tax_rel IS 'RELATION BETWEEN account_reconcile_model_line AND account_tax';


--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_model_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_model_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_model_line_id_seq OWNED BY public.account_reconcile_model_line.id;


--
-- Name: account_reconcile_model_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_model_res_partner_rel (
    account_reconcile_model_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_reconcile_model_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_reconcile_model_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_model_res_partner_rel IS 'RELATION BETWEEN account_reconcile_model AND res_partner';


--
-- Name: account_reconcile_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reconcile_wizard (
    id integer NOT NULL,
    journal_id integer NOT NULL,
    account_id integer,
    to_partner_id integer,
    tax_id integer,
    create_uid integer,
    write_uid integer,
    label character varying,
    date date,
    edit_mode_amount_currency numeric,
    allow_partials boolean,
    to_check boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reconcile_wizard OWNER TO runbot;

--
-- Name: TABLE account_reconcile_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reconcile_wizard IS 'Account reconciliation wizard';


--
-- Name: COLUMN account_reconcile_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN account_reconcile_wizard.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.account_id IS 'Account';


--
-- Name: COLUMN account_reconcile_wizard.to_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_partner_id IS 'Partner';


--
-- Name: COLUMN account_reconcile_wizard.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.tax_id IS 'Tax';


--
-- Name: COLUMN account_reconcile_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reconcile_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reconcile_wizard.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.label IS 'Label';


--
-- Name: COLUMN account_reconcile_wizard.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.date IS 'Date';


--
-- Name: COLUMN account_reconcile_wizard.edit_mode_amount_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.edit_mode_amount_currency IS 'Edit mode amount';


--
-- Name: COLUMN account_reconcile_wizard.allow_partials; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.allow_partials IS 'Allow partials';


--
-- Name: COLUMN account_reconcile_wizard.to_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.to_check IS 'To Check';


--
-- Name: COLUMN account_reconcile_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reconcile_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reconcile_wizard.write_date IS 'Last Updated on';


--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reconcile_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNER TO runbot;

--
-- Name: account_reconcile_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reconcile_wizard_id_seq OWNED BY public.account_reconcile_wizard.id;


--
-- Name: account_report; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report (
    id integer NOT NULL,
    sequence integer,
    root_report_id integer,
    country_id integer,
    load_more_limit integer,
    prefix_groups_threshold integer,
    create_uid integer,
    write_uid integer,
    chart_template character varying,
    availability_condition character varying,
    integer_rounding character varying,
    default_opening_date_filter character varying,
    currency_translation character varying,
    filter_multi_company character varying,
    filter_hide_0_lines character varying,
    filter_hierarchy character varying,
    filter_account_type character varying,
    name jsonb NOT NULL,
    active boolean,
    use_sections boolean,
    only_tax_exigible boolean,
    search_bar boolean,
    allow_foreign_vat boolean,
    filter_date_range boolean,
    filter_show_draft boolean,
    filter_unreconciled boolean,
    filter_unfold_all boolean,
    filter_period_comparison boolean,
    filter_growth_comparison boolean,
    filter_journals boolean,
    filter_analytic boolean,
    filter_partner boolean,
    filter_aml_ir_filters boolean,
    filter_budgets boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    custom_handler_model_id integer,
    send_and_print_values jsonb,
    allow_account_audit_status_on_lines boolean,
    filter_analytic_groupby boolean,
    require_custom_filter boolean,
    filter_show_all_custom boolean,
    filter_cash_basis boolean
);


ALTER TABLE public.account_report OWNER TO runbot;

--
-- Name: TABLE account_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report IS 'Accounting Report';


--
-- Name: COLUMN account_report.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.sequence IS 'Sequence';


--
-- Name: COLUMN account_report.root_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.root_report_id IS 'Root Report';


--
-- Name: COLUMN account_report.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.country_id IS 'Country';


--
-- Name: COLUMN account_report.load_more_limit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.load_more_limit IS 'Load More Limit';


--
-- Name: COLUMN account_report.prefix_groups_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.prefix_groups_threshold IS 'Prefix Groups Threshold';


--
-- Name: COLUMN account_report.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_uid IS 'Created by';


--
-- Name: COLUMN account_report.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report.chart_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.chart_template IS 'Chart of Accounts';


--
-- Name: COLUMN account_report.availability_condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.availability_condition IS 'Availability';


--
-- Name: COLUMN account_report.integer_rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.integer_rounding IS 'Integer Rounding';


--
-- Name: COLUMN account_report.default_opening_date_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.default_opening_date_filter IS 'Default Opening';


--
-- Name: COLUMN account_report.currency_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.currency_translation IS 'Currency Translation';


--
-- Name: COLUMN account_report.filter_multi_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_multi_company IS 'Multi-Company';


--
-- Name: COLUMN account_report.filter_hide_0_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hide_0_lines IS 'Hide lines at 0';


--
-- Name: COLUMN account_report.filter_hierarchy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_hierarchy IS 'Account Groups';


--
-- Name: COLUMN account_report.filter_account_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_account_type IS 'Account Types';


--
-- Name: COLUMN account_report.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.name IS 'Name';


--
-- Name: COLUMN account_report.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.active IS 'Active';


--
-- Name: COLUMN account_report.use_sections; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.use_sections IS 'Composite Report';


--
-- Name: COLUMN account_report.only_tax_exigible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.only_tax_exigible IS 'Only Tax Exigible Lines';


--
-- Name: COLUMN account_report.search_bar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.search_bar IS 'Search Bar';


--
-- Name: COLUMN account_report.allow_foreign_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.allow_foreign_vat IS 'Allow Foreign VAT';


--
-- Name: COLUMN account_report.filter_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_date_range IS 'Date Range';


--
-- Name: COLUMN account_report.filter_show_draft; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_show_draft IS 'Draft Entries';


--
-- Name: COLUMN account_report.filter_unreconciled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unreconciled IS 'Unreconciled Entries';


--
-- Name: COLUMN account_report.filter_unfold_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_unfold_all IS 'Unfold All';


--
-- Name: COLUMN account_report.filter_period_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_period_comparison IS 'Period Comparison';


--
-- Name: COLUMN account_report.filter_growth_comparison; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_growth_comparison IS 'Growth Comparison';


--
-- Name: COLUMN account_report.filter_journals; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_journals IS 'Journals';


--
-- Name: COLUMN account_report.filter_analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic IS 'Analytic Filter';


--
-- Name: COLUMN account_report.filter_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_partner IS 'Partners';


--
-- Name: COLUMN account_report.filter_aml_ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_aml_ir_filters IS 'Favorite Filters';


--
-- Name: COLUMN account_report.filter_budgets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_budgets IS 'Budgets';


--
-- Name: COLUMN account_report.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.create_date IS 'Created on';


--
-- Name: COLUMN account_report.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report.custom_handler_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.custom_handler_model_id IS 'Custom Handler Model';


--
-- Name: COLUMN account_report.send_and_print_values; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.send_and_print_values IS 'Send And Print Values';


--
-- Name: COLUMN account_report.allow_account_audit_status_on_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.allow_account_audit_status_on_lines IS 'Allow Account Audit Status On Lines';


--
-- Name: COLUMN account_report.filter_analytic_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_analytic_groupby IS 'Analytic Group By';


--
-- Name: COLUMN account_report.require_custom_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.require_custom_filter IS 'Require Custom Filter';


--
-- Name: COLUMN account_report.filter_show_all_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_show_all_custom IS 'Show All';


--
-- Name: COLUMN account_report.filter_cash_basis; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report.filter_cash_basis IS 'Cash Basis';


--
-- Name: account_report_account_report_horizontal_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_account_report_horizontal_group_rel (
    account_report_id integer NOT NULL,
    account_report_horizontal_group_id integer NOT NULL
);


ALTER TABLE public.account_report_account_report_horizontal_group_rel OWNER TO runbot;

--
-- Name: TABLE account_report_account_report_horizontal_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_account_report_horizontal_group_rel IS 'RELATION BETWEEN account_report AND account_report_horizontal_group';


--
-- Name: account_report_annotation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_annotation (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_annotation OWNER TO runbot;

--
-- Name: TABLE account_report_annotation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_annotation IS 'Account Report Annotation';


--
-- Name: COLUMN account_report_annotation.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.message_id IS 'Message';


--
-- Name: COLUMN account_report_annotation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_annotation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_annotation.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.date IS 'Date';


--
-- Name: COLUMN account_report_annotation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.create_date IS 'Created on';


--
-- Name: COLUMN account_report_annotation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_annotation.write_date IS 'Last Updated on';


--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_annotation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_annotation_id_seq OWNER TO runbot;

--
-- Name: account_report_annotation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_annotation_id_seq OWNED BY public.account_report_annotation.id;


--
-- Name: account_report_budget; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_budget (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_budget OWNER TO runbot;

--
-- Name: TABLE account_report_budget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_budget IS 'Accounting Report Budget';


--
-- Name: COLUMN account_report_budget.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_budget.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.company_id IS 'Company';


--
-- Name: COLUMN account_report_budget.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.name IS 'Name';


--
-- Name: COLUMN account_report_budget.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget.write_date IS 'Last Updated on';


--
-- Name: account_report_budget_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_budget_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_id_seq OWNER TO runbot;

--
-- Name: account_report_budget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_budget_id_seq OWNED BY public.account_report_budget.id;


--
-- Name: account_report_budget_item; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_budget_item (
    id integer NOT NULL,
    budget_id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    amount double precision
);


ALTER TABLE public.account_report_budget_item OWNER TO runbot;

--
-- Name: TABLE account_report_budget_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_budget_item IS 'Accounting Report Budget Item';


--
-- Name: COLUMN account_report_budget_item.budget_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.budget_id IS 'Budget';


--
-- Name: COLUMN account_report_budget_item.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.account_id IS 'Account';


--
-- Name: COLUMN account_report_budget_item.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_budget_item.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_budget_item.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.date IS 'Date';


--
-- Name: COLUMN account_report_budget_item.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.create_date IS 'Created on';


--
-- Name: COLUMN account_report_budget_item.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_budget_item.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_budget_item.amount IS 'Amount';


--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_budget_item_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_budget_item_id_seq OWNER TO runbot;

--
-- Name: account_report_budget_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_budget_item_id_seq OWNED BY public.account_report_budget_item.id;


--
-- Name: account_report_column; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_column (
    id integer NOT NULL,
    sequence integer,
    report_id integer,
    custom_audit_action_id integer,
    create_uid integer,
    write_uid integer,
    expression_label character varying NOT NULL,
    figure_type character varying NOT NULL,
    name jsonb NOT NULL,
    sortable boolean,
    blank_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_column OWNER TO runbot;

--
-- Name: TABLE account_report_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_column IS 'Accounting Report Column';


--
-- Name: COLUMN account_report_column.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_column.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.report_id IS 'Report';


--
-- Name: COLUMN account_report_column.custom_audit_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.custom_audit_action_id IS 'Custom Audit Action';


--
-- Name: COLUMN account_report_column.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_column.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_column.expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.expression_label IS 'Expression Label';


--
-- Name: COLUMN account_report_column.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_column.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.name IS 'Name';


--
-- Name: COLUMN account_report_column.sortable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.sortable IS 'Sortable';


--
-- Name: COLUMN account_report_column.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_column.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.create_date IS 'Created on';


--
-- Name: COLUMN account_report_column.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_column.write_date IS 'Last Updated on';


--
-- Name: account_report_column_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_column_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_column_id_seq OWNER TO runbot;

--
-- Name: account_report_column_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_column_id_seq OWNED BY public.account_report_column.id;


--
-- Name: account_report_expression; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_expression (
    id integer NOT NULL,
    report_line_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    label character varying NOT NULL,
    engine character varying NOT NULL,
    formula character varying NOT NULL,
    subformula character varying,
    date_scope character varying NOT NULL,
    figure_type character varying,
    carryover_target character varying,
    green_on_positive boolean,
    blank_if_zero boolean,
    auditable boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT account_report_expression_domain_engine_subformula_required CHECK ((((engine)::text <> 'domain'::text) OR (subformula IS NOT NULL)))
);


ALTER TABLE public.account_report_expression OWNER TO runbot;

--
-- Name: TABLE account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_expression IS 'Accounting Report Expression';


--
-- Name: COLUMN account_report_expression.report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.report_line_id IS 'Report Line';


--
-- Name: COLUMN account_report_expression.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_expression.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_expression.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.label IS 'Label';


--
-- Name: COLUMN account_report_expression.engine; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.engine IS 'Computation Engine';


--
-- Name: COLUMN account_report_expression.formula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.formula IS 'Formula';


--
-- Name: COLUMN account_report_expression.subformula; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.subformula IS 'Subformula';


--
-- Name: COLUMN account_report_expression.date_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.date_scope IS 'Date Scope';


--
-- Name: COLUMN account_report_expression.figure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.figure_type IS 'Figure Type';


--
-- Name: COLUMN account_report_expression.carryover_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.carryover_target IS 'Carry Over To';


--
-- Name: COLUMN account_report_expression.green_on_positive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.green_on_positive IS 'Is Growth Good when Positive';


--
-- Name: COLUMN account_report_expression.blank_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.blank_if_zero IS 'Blank if Zero';


--
-- Name: COLUMN account_report_expression.auditable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.auditable IS 'Auditable';


--
-- Name: COLUMN account_report_expression.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.create_date IS 'Created on';


--
-- Name: COLUMN account_report_expression.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_expression.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT account_report_expression_domain_engine_subformula_required ON account_report_expression; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT account_report_expression_domain_engine_subformula_required ON public.account_report_expression IS 'CHECK(engine != ''domain'' OR subformula IS NOT NULL)';


--
-- Name: account_report_expression_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_expression_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_expression_id_seq OWNER TO runbot;

--
-- Name: account_report_expression_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_expression_id_seq OWNED BY public.account_report_expression.id;


--
-- Name: account_report_external_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_external_value (
    id integer NOT NULL,
    target_report_expression_id integer NOT NULL,
    company_id integer NOT NULL,
    carryover_origin_report_line_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    text_value character varying,
    carryover_origin_expression_label character varying,
    date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    value double precision
);


ALTER TABLE public.account_report_external_value OWNER TO runbot;

--
-- Name: TABLE account_report_external_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_external_value IS 'Accounting Report External Value';


--
-- Name: COLUMN account_report_external_value.target_report_expression_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.target_report_expression_id IS 'Target Expression';


--
-- Name: COLUMN account_report_external_value.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.company_id IS 'Company';


--
-- Name: COLUMN account_report_external_value.carryover_origin_report_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_report_line_id IS 'Origin Line';


--
-- Name: COLUMN account_report_external_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_external_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_external_value.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.name IS 'Name';


--
-- Name: COLUMN account_report_external_value.text_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.text_value IS 'Text Value';


--
-- Name: COLUMN account_report_external_value.carryover_origin_expression_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.carryover_origin_expression_label IS 'Origin Expression Label';


--
-- Name: COLUMN account_report_external_value.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.date IS 'Date';


--
-- Name: COLUMN account_report_external_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.create_date IS 'Created on';


--
-- Name: COLUMN account_report_external_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_report_external_value.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_external_value.value IS 'Numeric Value';


--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_external_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_external_value_id_seq OWNER TO runbot;

--
-- Name: account_report_external_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_external_value_id_seq OWNED BY public.account_report_external_value.id;


--
-- Name: account_report_file_download_error_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_file_download_error_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    file_name character varying,
    actionable_errors jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_file_download_error_wizard OWNER TO runbot;

--
-- Name: TABLE account_report_file_download_error_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_file_download_error_wizard IS 'Manage the file generation errors from report exports.';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_file_download_error_wizard.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.file_name IS 'File Name';


--
-- Name: COLUMN account_report_file_download_error_wizard.actionable_errors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.actionable_errors IS 'Actionable Errors';


--
-- Name: COLUMN account_report_file_download_error_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_report_file_download_error_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_file_download_error_wizard.write_date IS 'Last Updated on';


--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_file_download_error_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNER TO runbot;

--
-- Name: account_report_file_download_error_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_file_download_error_wizard_id_seq OWNED BY public.account_report_file_download_error_wizard.id;


--
-- Name: account_report_horizontal_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group IS 'Horizontal group for reports';


--
-- Name: COLUMN account_report_horizontal_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.name IS 'Name';


--
-- Name: COLUMN account_report_horizontal_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_id_seq OWNED BY public.account_report_horizontal_group.id;


--
-- Name: account_report_horizontal_group_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_horizontal_group_rule (
    id integer NOT NULL,
    horizontal_group_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    domain character varying NOT NULL,
    field_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_horizontal_group_rule OWNER TO runbot;

--
-- Name: TABLE account_report_horizontal_group_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_horizontal_group_rule IS 'Horizontal group rule for reports';


--
-- Name: COLUMN account_report_horizontal_group_rule.horizontal_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.horizontal_group_id IS 'Horizontal Group';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_horizontal_group_rule.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.domain IS 'Domain';


--
-- Name: COLUMN account_report_horizontal_group_rule.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.field_name IS 'Field';


--
-- Name: COLUMN account_report_horizontal_group_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.create_date IS 'Created on';


--
-- Name: COLUMN account_report_horizontal_group_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_horizontal_group_rule.write_date IS 'Last Updated on';


--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_horizontal_group_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNER TO runbot;

--
-- Name: account_report_horizontal_group_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_horizontal_group_rule_id_seq OWNED BY public.account_report_horizontal_group_rule.id;


--
-- Name: account_report_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_id_seq OWNER TO runbot;

--
-- Name: account_report_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_id_seq OWNED BY public.account_report.id;


--
-- Name: account_report_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_line (
    id integer NOT NULL,
    report_id integer NOT NULL,
    hierarchy_level integer NOT NULL,
    parent_id integer,
    sequence integer,
    action_id integer,
    create_uid integer,
    write_uid integer,
    groupby character varying,
    user_groupby character varying,
    code character varying,
    horizontal_split_side character varying,
    name jsonb NOT NULL,
    foldable boolean,
    print_on_new_page boolean,
    hide_if_zero boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_line OWNER TO runbot;

--
-- Name: TABLE account_report_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_line IS 'Accounting Report Line';


--
-- Name: COLUMN account_report_line.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.report_id IS 'Parent Report';


--
-- Name: COLUMN account_report_line.hierarchy_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hierarchy_level IS 'Level';


--
-- Name: COLUMN account_report_line.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.parent_id IS 'Parent Line';


--
-- Name: COLUMN account_report_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_report_line.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.action_id IS 'Action';


--
-- Name: COLUMN account_report_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_line.groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.groupby IS 'Group By';


--
-- Name: COLUMN account_report_line.user_groupby; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.user_groupby IS 'User Group By';


--
-- Name: COLUMN account_report_line.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.code IS 'Code';


--
-- Name: COLUMN account_report_line.horizontal_split_side; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.horizontal_split_side IS 'Horizontal Split Side';


--
-- Name: COLUMN account_report_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.name IS 'Name';


--
-- Name: COLUMN account_report_line.foldable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.foldable IS 'Foldable';


--
-- Name: COLUMN account_report_line.print_on_new_page; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.print_on_new_page IS 'Print On New Page';


--
-- Name: COLUMN account_report_line.hide_if_zero; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.hide_if_zero IS 'Hide if Zero';


--
-- Name: COLUMN account_report_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.create_date IS 'Created on';


--
-- Name: COLUMN account_report_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_line.write_date IS 'Last Updated on';


--
-- Name: account_report_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_line_id_seq OWNER TO runbot;

--
-- Name: account_report_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_line_id_seq OWNED BY public.account_report_line.id;


--
-- Name: account_report_section_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_section_rel (
    main_report_id integer NOT NULL,
    sub_report_id integer NOT NULL
);


ALTER TABLE public.account_report_section_rel OWNER TO runbot;

--
-- Name: TABLE account_report_section_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_section_rel IS 'RELATION BETWEEN account_report AND account_report';


--
-- Name: account_report_send; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_send (
    id integer NOT NULL,
    mail_template_id integer,
    account_report_id integer,
    create_uid integer,
    write_uid integer,
    mode character varying,
    mail_subject character varying,
    report_options jsonb,
    mail_attachments_widget jsonb,
    mail_body text,
    enable_download boolean,
    checkbox_download boolean,
    enable_send_mail boolean,
    checkbox_send_mail boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_report_send OWNER TO runbot;

--
-- Name: TABLE account_report_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_send IS 'Account Report Send';


--
-- Name: COLUMN account_report_send.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_template_id IS 'Email template';


--
-- Name: COLUMN account_report_send.account_report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.account_report_id IS 'Report';


--
-- Name: COLUMN account_report_send.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.create_uid IS 'Created by';


--
-- Name: COLUMN account_report_send.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_report_send.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mode IS 'Mode';


--
-- Name: COLUMN account_report_send.mail_subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_subject IS 'Subject';


--
-- Name: COLUMN account_report_send.report_options; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.report_options IS 'Report Options';


--
-- Name: COLUMN account_report_send.mail_attachments_widget; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_attachments_widget IS 'Mail Attachments Widget';


--
-- Name: COLUMN account_report_send.mail_body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.mail_body IS 'Contents';


--
-- Name: COLUMN account_report_send.enable_download; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.enable_download IS 'Enable Download';


--
-- Name: COLUMN account_report_send.checkbox_download; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.checkbox_download IS 'Download';


--
-- Name: COLUMN account_report_send.enable_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.enable_send_mail IS 'Enable Send Mail';


--
-- Name: COLUMN account_report_send.checkbox_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.checkbox_send_mail IS 'Email';


--
-- Name: COLUMN account_report_send.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.create_date IS 'Created on';


--
-- Name: COLUMN account_report_send.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_report_send.write_date IS 'Last Updated on';


--
-- Name: account_report_send_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_report_send_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_report_send_id_seq OWNER TO runbot;

--
-- Name: account_report_send_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_report_send_id_seq OWNED BY public.account_report_send.id;


--
-- Name: account_report_send_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_report_send_res_partner_rel (
    account_report_send_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.account_report_send_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE account_report_send_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_report_send_res_partner_rel IS 'RELATION BETWEEN account_report_send AND res_partner';


--
-- Name: account_reports_export_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard (
    id integer NOT NULL,
    report_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    doc_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    folder_id integer NOT NULL,
    l10n_es_reports_boe_wizard_id integer,
    l10n_es_reports_boe_wizard_model character varying
);


ALTER TABLE public.account_reports_export_wizard OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard IS 'Export wizard for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.report_id IS 'Parent Report Id';


--
-- Name: COLUMN account_reports_export_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard.doc_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.doc_name IS 'Documents Name';


--
-- Name: COLUMN account_reports_export_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_reports_export_wizard.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.folder_id IS 'Folder';


--
-- Name: COLUMN account_reports_export_wizard.l10n_es_reports_boe_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.l10n_es_reports_boe_wizard_id IS 'L10N Es Reports Boe Wizard';


--
-- Name: COLUMN account_reports_export_wizard.l10n_es_reports_boe_wizard_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard.l10n_es_reports_boe_wizard_model IS 'L10N Es Reports Boe Wizard Model';


--
-- Name: account_reports_export_wizard_format; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_reports_export_wizard_format (
    id integer NOT NULL,
    export_wizard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    fun_to_call character varying NOT NULL,
    fun_param character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_reports_export_wizard_format OWNER TO runbot;

--
-- Name: TABLE account_reports_export_wizard_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_reports_export_wizard_format IS 'Export format for accounting''s reports';


--
-- Name: COLUMN account_reports_export_wizard_format.export_wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.export_wizard_id IS 'Parent Wizard';


--
-- Name: COLUMN account_reports_export_wizard_format.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_uid IS 'Created by';


--
-- Name: COLUMN account_reports_export_wizard_format.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_reports_export_wizard_format.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.name IS 'Name';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_to_call; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_to_call IS 'Function to Call';


--
-- Name: COLUMN account_reports_export_wizard_format.fun_param; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.fun_param IS 'Function Parameter';


--
-- Name: COLUMN account_reports_export_wizard_format.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.create_date IS 'Created on';


--
-- Name: COLUMN account_reports_export_wizard_format.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_reports_export_wizard_format.write_date IS 'Last Updated on';


--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_format_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_format_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_format_id_seq OWNED BY public.account_reports_export_wizard_format.id;


--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_reports_export_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNER TO runbot;

--
-- Name: account_reports_export_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_reports_export_wizard_id_seq OWNED BY public.account_reports_export_wizard.id;


--
-- Name: account_resequence_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_resequence_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    first_name character varying NOT NULL,
    ordering character varying NOT NULL,
    first_date date,
    end_date date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_resequence_wizard OWNER TO runbot;

--
-- Name: TABLE account_resequence_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_resequence_wizard IS 'Remake the sequence of Journal Entries.';


--
-- Name: COLUMN account_resequence_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_resequence_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_resequence_wizard.first_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_name IS 'First New Sequence';


--
-- Name: COLUMN account_resequence_wizard.ordering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.ordering IS 'Ordering';


--
-- Name: COLUMN account_resequence_wizard.first_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.first_date IS 'First Date';


--
-- Name: COLUMN account_resequence_wizard.end_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.end_date IS 'End Date';


--
-- Name: COLUMN account_resequence_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_resequence_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_resequence_wizard.write_date IS 'Last Updated on';


--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_resequence_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNER TO runbot;

--
-- Name: account_resequence_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_resequence_wizard_id_seq OWNED BY public.account_resequence_wizard.id;


--
-- Name: account_return; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return (
    id integer NOT NULL,
    message_main_attachment_id integer,
    type_id integer NOT NULL,
    company_id integer NOT NULL,
    tax_unit_id integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    generic_state_tax_report character varying,
    generic_state_only_pay character varying,
    generic_state_review_submit character varying,
    generic_state_review character varying,
    audit_status character varying NOT NULL,
    skipped_check_cycles character varying,
    date_from date NOT NULL,
    date_to date NOT NULL,
    date_deadline date,
    date_lock date,
    date_submission date,
    name jsonb NOT NULL,
    total_amount_to_pay numeric,
    period_amount_to_pay numeric,
    active boolean,
    is_completed boolean,
    manually_created boolean,
    report_opened_once boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return OWNER TO runbot;

--
-- Name: TABLE account_return; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return IS 'Accounting Return';


--
-- Name: COLUMN account_return.message_main_attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.message_main_attachment_id IS 'Main Attachment';


--
-- Name: COLUMN account_return.type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.type_id IS 'Return Type';


--
-- Name: COLUMN account_return.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.company_id IS 'Company';


--
-- Name: COLUMN account_return.tax_unit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.tax_unit_id IS 'Tax Unit';


--
-- Name: COLUMN account_return.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.create_uid IS 'Created by';


--
-- Name: COLUMN account_return.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.state IS 'State';


--
-- Name: COLUMN account_return.generic_state_tax_report; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.generic_state_tax_report IS 'Generic State';


--
-- Name: COLUMN account_return.generic_state_only_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.generic_state_only_pay IS 'Generic State Only Pay';


--
-- Name: COLUMN account_return.generic_state_review_submit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.generic_state_review_submit IS 'Generic State Review Submit';


--
-- Name: COLUMN account_return.generic_state_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.generic_state_review IS 'Generic State Review';


--
-- Name: COLUMN account_return.audit_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.audit_status IS 'Audit Status';


--
-- Name: COLUMN account_return.skipped_check_cycles; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.skipped_check_cycles IS 'Skipped Check Cycles';


--
-- Name: COLUMN account_return.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_from IS 'Date From';


--
-- Name: COLUMN account_return.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_to IS 'Date To';


--
-- Name: COLUMN account_return.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_deadline IS 'Deadline';


--
-- Name: COLUMN account_return.date_lock; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_lock IS 'Lock Date';


--
-- Name: COLUMN account_return.date_submission; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.date_submission IS 'Submission Date';


--
-- Name: COLUMN account_return.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.name IS 'Name';


--
-- Name: COLUMN account_return.total_amount_to_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.total_amount_to_pay IS 'Total Amount To Pay';


--
-- Name: COLUMN account_return.period_amount_to_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.period_amount_to_pay IS 'Period Amount To Pay';


--
-- Name: COLUMN account_return.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.active IS 'Active';


--
-- Name: COLUMN account_return.is_completed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.is_completed IS 'Is Completed';


--
-- Name: COLUMN account_return.manually_created; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.manually_created IS 'Manually Created';


--
-- Name: COLUMN account_return.report_opened_once; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.report_opened_once IS 'Report Opened Once';


--
-- Name: COLUMN account_return.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.create_date IS 'Created on';


--
-- Name: COLUMN account_return.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return.write_date IS 'Last Updated on';


--
-- Name: account_return_check; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check (
    id integer NOT NULL,
    template_id integer,
    records_count integer,
    records_model integer,
    return_id integer NOT NULL,
    supervisor_id integer,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    type character varying NOT NULL,
    state character varying NOT NULL,
    result character varying NOT NULL,
    return_state character varying,
    name jsonb NOT NULL,
    message jsonb,
    action jsonb,
    refresh_result boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_check OWNER TO runbot;

--
-- Name: TABLE account_return_check; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check IS 'Accounting Return Check';


--
-- Name: COLUMN account_return_check.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.template_id IS 'Template';


--
-- Name: COLUMN account_return_check.records_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.records_count IS 'Records Count';


--
-- Name: COLUMN account_return_check.records_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.records_model IS 'Model';


--
-- Name: COLUMN account_return_check.return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.return_id IS 'Account Return';


--
-- Name: COLUMN account_return_check.supervisor_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.supervisor_id IS 'Supervised By';


--
-- Name: COLUMN account_return_check.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_check.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_check.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.code IS 'Check ID';


--
-- Name: COLUMN account_return_check.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.type IS 'Type';


--
-- Name: COLUMN account_return_check.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.state IS 'Return State To Check For';


--
-- Name: COLUMN account_return_check.result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.result IS 'Result';


--
-- Name: COLUMN account_return_check.return_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.return_state IS 'Return State';


--
-- Name: COLUMN account_return_check.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.name IS 'Name';


--
-- Name: COLUMN account_return_check.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.message IS 'Description';


--
-- Name: COLUMN account_return_check.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.action IS 'Action';


--
-- Name: COLUMN account_return_check.refresh_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.refresh_result IS 'Refresh Result';


--
-- Name: COLUMN account_return_check.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.create_date IS 'Created on';


--
-- Name: COLUMN account_return_check.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check.write_date IS 'Last Updated on';


--
-- Name: account_return_check_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_check_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_check_id_seq OWNER TO runbot;

--
-- Name: account_return_check_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_check_id_seq OWNED BY public.account_return_check.id;


--
-- Name: account_return_check_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check_ir_attachment_rel (
    account_return_check_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_return_check_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_return_check_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check_ir_attachment_rel IS 'RELATION BETWEEN account_return_check AND ir_attachment';


--
-- Name: account_return_check_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check_res_users_rel (
    account_return_check_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.account_return_check_res_users_rel OWNER TO runbot;

--
-- Name: TABLE account_return_check_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check_res_users_rel IS 'RELATION BETWEEN account_return_check AND res_users';


--
-- Name: account_return_check_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check_template (
    id integer NOT NULL,
    return_type integer NOT NULL,
    action_id integer,
    activity_type integer,
    create_uid integer,
    write_uid integer,
    code character varying,
    cycle character varying NOT NULL,
    type character varying NOT NULL,
    additional_action_domain character varying,
    additional_action_context character varying,
    additional_action_params character varying,
    model character varying,
    domain character varying,
    name jsonb NOT NULL,
    description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_check_template OWNER TO runbot;

--
-- Name: TABLE account_return_check_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check_template IS 'Account Return Check Template';


--
-- Name: COLUMN account_return_check_template.return_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.return_type IS 'Tax Return/Audit';


--
-- Name: COLUMN account_return_check_template.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.action_id IS 'Action on Click';


--
-- Name: COLUMN account_return_check_template.activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.activity_type IS 'Activities';


--
-- Name: COLUMN account_return_check_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_check_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_check_template.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.code IS 'Code';


--
-- Name: COLUMN account_return_check_template.cycle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.cycle IS 'Cycle';


--
-- Name: COLUMN account_return_check_template.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.type IS 'Type';


--
-- Name: COLUMN account_return_check_template.additional_action_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.additional_action_domain IS 'Additional Action Domain';


--
-- Name: COLUMN account_return_check_template.additional_action_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.additional_action_context IS 'Additional Action Context';


--
-- Name: COLUMN account_return_check_template.additional_action_params; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.additional_action_params IS 'Additional Action Params';


--
-- Name: COLUMN account_return_check_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.model IS 'Model';


--
-- Name: COLUMN account_return_check_template.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.domain IS 'Domain';


--
-- Name: COLUMN account_return_check_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.name IS 'Title';


--
-- Name: COLUMN account_return_check_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.description IS 'Description';


--
-- Name: COLUMN account_return_check_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.create_date IS 'Created on';


--
-- Name: COLUMN account_return_check_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_check_template.write_date IS 'Last Updated on';


--
-- Name: account_return_check_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_check_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_check_template_id_seq OWNER TO runbot;

--
-- Name: account_return_check_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_check_template_id_seq OWNED BY public.account_return_check_template.id;


--
-- Name: account_return_check_template_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_check_template_res_country_rel (
    account_return_check_template_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.account_return_check_template_res_country_rel OWNER TO runbot;

--
-- Name: TABLE account_return_check_template_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_check_template_res_country_rel IS 'RELATION BETWEEN account_return_check_template AND res_country';


--
-- Name: account_return_creation_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_creation_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    return_type_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    category character varying,
    date_from date NOT NULL,
    date_to date NOT NULL,
    regulatory_compliance boolean,
    treasury_financing boolean,
    purchases boolean,
    operating_expenses boolean,
    sales boolean,
    inventory boolean,
    fixed_assets boolean,
    payroll boolean,
    government boolean,
    equity boolean,
    other boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_creation_wizard OWNER TO runbot;

--
-- Name: TABLE account_return_creation_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_creation_wizard IS 'Return creation wizard';


--
-- Name: COLUMN account_return_creation_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_return_creation_wizard.return_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.return_type_id IS 'Return Type';


--
-- Name: COLUMN account_return_creation_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_creation_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_creation_wizard.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.category IS 'Category';


--
-- Name: COLUMN account_return_creation_wizard.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.date_from IS 'Date From';


--
-- Name: COLUMN account_return_creation_wizard.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.date_to IS 'Date To';


--
-- Name: COLUMN account_return_creation_wizard.regulatory_compliance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.regulatory_compliance IS 'Regulatory compliance';


--
-- Name: COLUMN account_return_creation_wizard.treasury_financing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.treasury_financing IS 'Treasury and financing';


--
-- Name: COLUMN account_return_creation_wizard.purchases; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.purchases IS 'Purchases';


--
-- Name: COLUMN account_return_creation_wizard.operating_expenses; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.operating_expenses IS 'Operating expenses';


--
-- Name: COLUMN account_return_creation_wizard.sales; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.sales IS 'Sales';


--
-- Name: COLUMN account_return_creation_wizard.inventory; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.inventory IS 'Inventory';


--
-- Name: COLUMN account_return_creation_wizard.fixed_assets; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.fixed_assets IS 'Fixed assets';


--
-- Name: COLUMN account_return_creation_wizard.payroll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.payroll IS 'Payroll';


--
-- Name: COLUMN account_return_creation_wizard.government; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.government IS 'Government';


--
-- Name: COLUMN account_return_creation_wizard.equity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.equity IS 'Equity';


--
-- Name: COLUMN account_return_creation_wizard.other; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.other IS 'Others';


--
-- Name: COLUMN account_return_creation_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_return_creation_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_creation_wizard.write_date IS 'Last Updated on';


--
-- Name: account_return_creation_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_creation_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_creation_wizard_id_seq OWNER TO runbot;

--
-- Name: account_return_creation_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_creation_wizard_id_seq OWNED BY public.account_return_creation_wizard.id;


--
-- Name: account_return_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_id_seq OWNER TO runbot;

--
-- Name: account_return_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_id_seq OWNED BY public.account_return.id;


--
-- Name: account_return_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_ir_attachment_rel (
    account_return_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.account_return_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE account_return_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_ir_attachment_rel IS 'RELATION BETWEEN account_return AND ir_attachment';


--
-- Name: account_return_payment_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_payment_wizard (
    id integer NOT NULL,
    company_id integer,
    partner_bank_id integer,
    return_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    amount_to_pay numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_payment_wizard OWNER TO runbot;

--
-- Name: TABLE account_return_payment_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_payment_wizard IS 'Returns Generic Payment Wizard';


--
-- Name: COLUMN account_return_payment_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_return_payment_wizard.partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.partner_bank_id IS 'Partner Bank';


--
-- Name: COLUMN account_return_payment_wizard.return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.return_id IS 'Return';


--
-- Name: COLUMN account_return_payment_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_payment_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_payment_wizard.amount_to_pay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.amount_to_pay IS 'Amount To Pay';


--
-- Name: COLUMN account_return_payment_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_return_payment_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_payment_wizard.write_date IS 'Last Updated on';


--
-- Name: account_return_payment_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_payment_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_payment_wizard_id_seq OWNER TO runbot;

--
-- Name: account_return_payment_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_payment_wizard_id_seq OWNED BY public.account_return_payment_wizard.id;


--
-- Name: account_return_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_res_company_rel (
    account_return_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_return_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_return_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_res_company_rel IS 'RELATION BETWEEN account_return AND res_company';


--
-- Name: account_return_submission_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_submission_wizard (
    id integer NOT NULL,
    return_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    instructions text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_return_submission_wizard OWNER TO runbot;

--
-- Name: TABLE account_return_submission_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_submission_wizard IS 'Return submission wizard';


--
-- Name: COLUMN account_return_submission_wizard.return_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.return_id IS 'Return';


--
-- Name: COLUMN account_return_submission_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_submission_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_submission_wizard.instructions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.instructions IS 'Instructions';


--
-- Name: COLUMN account_return_submission_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_return_submission_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_submission_wizard.write_date IS 'Last Updated on';


--
-- Name: account_return_submission_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_submission_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_submission_wizard_id_seq OWNER TO runbot;

--
-- Name: account_return_submission_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_submission_wizard_id_seq OWNED BY public.account_return_submission_wizard.id;


--
-- Name: account_return_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_return_type (
    id integer NOT NULL,
    report_id integer,
    country_id integer,
    payment_partner_bank_id integer,
    default_deadline_days_delay integer,
    create_uid integer,
    write_uid integer,
    category character varying NOT NULL,
    states_workflow character varying,
    default_deadline_periodicity character varying,
    default_deadline_start_date date,
    name jsonb NOT NULL,
    deadline_periodicity jsonb,
    deadline_start_date jsonb,
    deadline_days_delay jsonb,
    auto_generate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    payment_partner_id integer,
    l10n_ar_account_id jsonb
);


ALTER TABLE public.account_return_type OWNER TO runbot;

--
-- Name: TABLE account_return_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_return_type IS 'Accounting Return Type';


--
-- Name: COLUMN account_return_type.report_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.report_id IS 'Report';


--
-- Name: COLUMN account_return_type.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.country_id IS 'Country';


--
-- Name: COLUMN account_return_type.payment_partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.payment_partner_bank_id IS 'Payment Partner Bank';


--
-- Name: COLUMN account_return_type.default_deadline_days_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.default_deadline_days_delay IS 'Default Deadline';


--
-- Name: COLUMN account_return_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.create_uid IS 'Created by';


--
-- Name: COLUMN account_return_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_return_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.category IS 'Type';


--
-- Name: COLUMN account_return_type.states_workflow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.states_workflow IS 'States';


--
-- Name: COLUMN account_return_type.default_deadline_periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.default_deadline_periodicity IS 'Default Periodicity';


--
-- Name: COLUMN account_return_type.default_deadline_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.default_deadline_start_date IS 'Default Start Date';


--
-- Name: COLUMN account_return_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.name IS 'Name';


--
-- Name: COLUMN account_return_type.deadline_periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.deadline_periodicity IS 'Periodicity';


--
-- Name: COLUMN account_return_type.deadline_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.deadline_start_date IS 'Start Date';


--
-- Name: COLUMN account_return_type.deadline_days_delay; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.deadline_days_delay IS 'Deadline';


--
-- Name: COLUMN account_return_type.auto_generate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.auto_generate IS 'Auto Generated';


--
-- Name: COLUMN account_return_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.create_date IS 'Created on';


--
-- Name: COLUMN account_return_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_return_type.payment_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.payment_partner_id IS 'Payment Partner';


--
-- Name: COLUMN account_return_type.l10n_ar_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_return_type.l10n_ar_account_id IS 'AR Closing Account';


--
-- Name: account_return_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_return_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_return_type_id_seq OWNER TO runbot;

--
-- Name: account_return_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_return_type_id_seq OWNED BY public.account_return_type.id;


--
-- Name: account_secure_entries_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_secure_entries_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    hash_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_secure_entries_wizard OWNER TO runbot;

--
-- Name: TABLE account_secure_entries_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_secure_entries_wizard IS 'Secure Journal Entries';


--
-- Name: COLUMN account_secure_entries_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.company_id IS 'Company';


--
-- Name: COLUMN account_secure_entries_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN account_secure_entries_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_secure_entries_wizard.hash_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.hash_date IS 'Hash All Entries';


--
-- Name: COLUMN account_secure_entries_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.create_date IS 'Created on';


--
-- Name: COLUMN account_secure_entries_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_secure_entries_wizard.write_date IS 'Last Updated on';


--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_secure_entries_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNER TO runbot;

--
-- Name: account_secure_entries_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_secure_entries_wizard_id_seq OWNED BY public.account_secure_entries_wizard.id;


--
-- Name: account_setup_bank_manual_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_setup_bank_manual_config (
    id integer NOT NULL,
    res_partner_bank_id integer NOT NULL,
    num_journals_without_account_bank integer,
    num_journals_without_account_credit integer,
    create_uid integer,
    write_uid integer,
    new_journal_name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_setup_bank_manual_config OWNER TO runbot;

--
-- Name: TABLE account_setup_bank_manual_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_setup_bank_manual_config IS 'Bank setup manual config';


--
-- Name: COLUMN account_setup_bank_manual_config.res_partner_bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.res_partner_bank_id IS 'Res Partner Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account_bank IS 'Num Journals Without Account Bank';


--
-- Name: COLUMN account_setup_bank_manual_config.num_journals_without_account_credit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.num_journals_without_account_credit IS 'Num Journals Without Account Credit';


--
-- Name: COLUMN account_setup_bank_manual_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_uid IS 'Created by';


--
-- Name: COLUMN account_setup_bank_manual_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_setup_bank_manual_config.new_journal_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.new_journal_name IS 'New Journal Name';


--
-- Name: COLUMN account_setup_bank_manual_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.create_date IS 'Created on';


--
-- Name: COLUMN account_setup_bank_manual_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_setup_bank_manual_config.write_date IS 'Last Updated on';


--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_setup_bank_manual_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNER TO runbot;

--
-- Name: account_setup_bank_manual_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_setup_bank_manual_config_id_seq OWNED BY public.account_setup_bank_manual_config.id;


--
-- Name: account_statement_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_statement_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    statement_filename character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sheet_mapping_id integer
);


ALTER TABLE public.account_statement_import OWNER TO runbot;

--
-- Name: TABLE account_statement_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_statement_import IS 'Import Bank Statement Files';


--
-- Name: COLUMN account_statement_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.create_uid IS 'Created by';


--
-- Name: COLUMN account_statement_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_statement_import.statement_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.statement_filename IS 'Statement Filename';


--
-- Name: COLUMN account_statement_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.create_date IS 'Created on';


--
-- Name: COLUMN account_statement_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_statement_import.sheet_mapping_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import.sheet_mapping_id IS 'Sheet mapping';


--
-- Name: account_statement_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_statement_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_statement_import_id_seq OWNER TO runbot;

--
-- Name: account_statement_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_statement_import_id_seq OWNED BY public.account_statement_import.id;


--
-- Name: account_statement_import_sheet_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_statement_import_sheet_mapping (
    id integer NOT NULL,
    footer_lines_skip_count integer,
    header_lines_skip_count integer,
    offset_column integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    float_thousands_sep character varying,
    float_decimal_sep character varying,
    file_encoding character varying,
    delimiter character varying,
    quotechar character varying(1),
    timestamp_format character varying NOT NULL,
    timestamp_column character varying NOT NULL,
    currency_column character varying,
    amount_debit_column character varying,
    amount_credit_column character varying,
    balance_column character varying,
    original_currency_column character varying,
    original_amount_column character varying,
    amount_type character varying NOT NULL,
    amount_column character varying,
    debit_credit_column character varying,
    debit_value character varying,
    credit_value character varying,
    transaction_id_column character varying,
    description_column character varying,
    notes_column character varying,
    reference_column character varying,
    partner_name_column character varying,
    bank_name_column character varying,
    bank_account_column character varying,
    no_header boolean,
    amount_inverse_sign boolean,
    skip_empty_lines boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_statement_import_sheet_mapping OWNER TO runbot;

--
-- Name: TABLE account_statement_import_sheet_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_statement_import_sheet_mapping IS 'Bank Statement Import Sheet Mapping';


--
-- Name: COLUMN account_statement_import_sheet_mapping.footer_lines_skip_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.footer_lines_skip_count IS 'Footer lines skip count';


--
-- Name: COLUMN account_statement_import_sheet_mapping.header_lines_skip_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.header_lines_skip_count IS 'Header lines skip count';


--
-- Name: COLUMN account_statement_import_sheet_mapping.offset_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.offset_column IS 'Offset Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN account_statement_import_sheet_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_statement_import_sheet_mapping.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.name IS 'Name';


--
-- Name: COLUMN account_statement_import_sheet_mapping.float_thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.float_thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN account_statement_import_sheet_mapping.float_decimal_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.float_decimal_sep IS 'Decimals Separator';


--
-- Name: COLUMN account_statement_import_sheet_mapping.file_encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.file_encoding IS 'Encoding';


--
-- Name: COLUMN account_statement_import_sheet_mapping.delimiter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.delimiter IS 'Delimiter';


--
-- Name: COLUMN account_statement_import_sheet_mapping.quotechar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.quotechar IS 'Text qualifier';


--
-- Name: COLUMN account_statement_import_sheet_mapping.timestamp_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.timestamp_format IS 'Timestamp Format';


--
-- Name: COLUMN account_statement_import_sheet_mapping.timestamp_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.timestamp_column IS 'Timestamp Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.currency_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.currency_column IS 'Currency Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.amount_debit_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.amount_debit_column IS 'Debit amount column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.amount_credit_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.amount_credit_column IS 'Credit amount column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.balance_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.balance_column IS 'Balance Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.original_currency_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.original_currency_column IS 'Original Currency Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.original_amount_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.original_amount_column IS 'Original Amount Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.amount_type IS 'Amount type';


--
-- Name: COLUMN account_statement_import_sheet_mapping.amount_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.amount_column IS 'Amount column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.debit_credit_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.debit_credit_column IS 'Debit/credit column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.debit_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.debit_value IS 'Debit Value';


--
-- Name: COLUMN account_statement_import_sheet_mapping.credit_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.credit_value IS 'Credit Value';


--
-- Name: COLUMN account_statement_import_sheet_mapping.transaction_id_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.transaction_id_column IS 'Unique transaction ID column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.description_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.description_column IS 'Description Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.notes_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.notes_column IS 'Notes Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.reference_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.reference_column IS 'Reference Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.partner_name_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.partner_name_column IS 'Partner Name Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.bank_name_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.bank_name_column IS 'Bank Name Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.bank_account_column; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.bank_account_column IS 'Bank Account Column';


--
-- Name: COLUMN account_statement_import_sheet_mapping.no_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.no_header IS 'File does not contain header line';


--
-- Name: COLUMN account_statement_import_sheet_mapping.amount_inverse_sign; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.amount_inverse_sign IS 'Inverse sign of amount';


--
-- Name: COLUMN account_statement_import_sheet_mapping.skip_empty_lines; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.skip_empty_lines IS 'Skip Empty Lines';


--
-- Name: COLUMN account_statement_import_sheet_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.create_date IS 'Created on';


--
-- Name: COLUMN account_statement_import_sheet_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_mapping.write_date IS 'Last Updated on';


--
-- Name: account_statement_import_sheet_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_statement_import_sheet_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_statement_import_sheet_mapping_id_seq OWNER TO runbot;

--
-- Name: account_statement_import_sheet_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_statement_import_sheet_mapping_id_seq OWNED BY public.account_statement_import_sheet_mapping.id;


--
-- Name: account_statement_import_sheet_parser; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_statement_import_sheet_parser (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_statement_import_sheet_parser OWNER TO runbot;

--
-- Name: TABLE account_statement_import_sheet_parser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_statement_import_sheet_parser IS 'Bank Statement Import Sheet Parser';


--
-- Name: COLUMN account_statement_import_sheet_parser.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_parser.create_uid IS 'Created by';


--
-- Name: COLUMN account_statement_import_sheet_parser.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_parser.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_statement_import_sheet_parser.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_parser.create_date IS 'Created on';


--
-- Name: COLUMN account_statement_import_sheet_parser.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_statement_import_sheet_parser.write_date IS 'Last Updated on';


--
-- Name: account_statement_import_sheet_parser_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_statement_import_sheet_parser_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_statement_import_sheet_parser_id_seq OWNER TO runbot;

--
-- Name: account_statement_import_sheet_parser_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_statement_import_sheet_parser_id_seq OWNED BY public.account_statement_import_sheet_parser.id;


--
-- Name: account_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax (
    id integer NOT NULL,
    company_id integer NOT NULL,
    sequence integer NOT NULL,
    tax_group_id integer NOT NULL,
    cash_basis_transition_account_id integer,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    type_tax_use character varying NOT NULL,
    tax_scope character varying,
    amount_type character varying NOT NULL,
    price_include_override character varying,
    tax_exigibility character varying,
    name jsonb NOT NULL,
    description jsonb,
    invoice_label jsonb,
    invoice_legal_notes jsonb,
    amount numeric NOT NULL,
    is_domestic boolean,
    active boolean,
    include_base_amount boolean,
    is_base_affected boolean,
    analytic boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ubl_cii_tax_category_code character varying,
    ubl_cii_tax_exemption_reason_code character varying,
    l10n_es_exempt_reason character varying,
    l10n_es_type character varying,
    l10n_es_bien_inversion boolean,
    l10n_cl_sii_code integer,
    l10n_es_edi_facturae_tax_type character varying,
    l10n_pe_edi_tax_code character varying,
    l10n_pe_edi_unece_category character varying,
    l10n_pe_edi_isc_type character varying,
    l10n_uy_tax_category character varying,
    l10n_ar_withholding_sequence_id integer,
    l10n_ar_state_id integer,
    l10n_ar_scale_id integer,
    l10n_ar_withholding_payment_type character varying,
    l10n_ar_tax_type character varying,
    l10n_ar_code character varying,
    l10n_ar_non_taxable_amount numeric,
    l10n_ar_minimum_threshold double precision,
    l10n_pe_edi_affectation_reason character varying,
    api_codigo_articulo_retencion character varying,
    api_codigo_articulo_percepcion character varying,
    api_articulo_inciso_calculo_percepcion character varying,
    api_articulo_inciso_calculo_retencion character varying,
    ratio double precision,
    is_backward_tax boolean
);


ALTER TABLE public.account_tax OWNER TO runbot;

--
-- Name: TABLE account_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax IS 'Tax';


--
-- Name: COLUMN account_tax.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.company_id IS 'Company';


--
-- Name: COLUMN account_tax.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax.tax_group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_group_id IS 'Tax Group';


--
-- Name: COLUMN account_tax.cash_basis_transition_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.cash_basis_transition_account_id IS 'Cash Basis Transition Account';


--
-- Name: COLUMN account_tax.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.country_id IS 'Country';


--
-- Name: COLUMN account_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax.type_tax_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.type_tax_use IS 'Tax Type';


--
-- Name: COLUMN account_tax.tax_scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_scope IS 'Tax Scope';


--
-- Name: COLUMN account_tax.amount_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount_type IS 'Tax Computation';


--
-- Name: COLUMN account_tax.price_include_override; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.price_include_override IS 'Included in Price';


--
-- Name: COLUMN account_tax.tax_exigibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.tax_exigibility IS 'Tax Exigibility';


--
-- Name: COLUMN account_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.name IS 'Tax Name';


--
-- Name: COLUMN account_tax.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.description IS 'Description';


--
-- Name: COLUMN account_tax.invoice_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_label IS 'Label on Invoices';


--
-- Name: COLUMN account_tax.invoice_legal_notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.invoice_legal_notes IS 'Legal Notes';


--
-- Name: COLUMN account_tax.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.amount IS 'Amount';


--
-- Name: COLUMN account_tax.is_domestic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_domestic IS 'Is Domestic';


--
-- Name: COLUMN account_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.active IS 'Active';


--
-- Name: COLUMN account_tax.include_base_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.include_base_amount IS 'Affect Base of Subsequent Taxes';


--
-- Name: COLUMN account_tax.is_base_affected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_base_affected IS 'Base Affected by Previous Taxes';


--
-- Name: COLUMN account_tax.analytic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.analytic IS 'Include in Analytic Cost';


--
-- Name: COLUMN account_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.create_date IS 'Created on';


--
-- Name: COLUMN account_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax.ubl_cii_tax_category_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.ubl_cii_tax_category_code IS 'Tax Category Code';


--
-- Name: COLUMN account_tax.ubl_cii_tax_exemption_reason_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.ubl_cii_tax_exemption_reason_code IS 'Tax Exemption Reason Code';


--
-- Name: COLUMN account_tax.l10n_es_exempt_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_es_exempt_reason IS 'Exempt Reason (Spain)';


--
-- Name: COLUMN account_tax.l10n_es_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_es_type IS 'Tax Type (Spain)';


--
-- Name: COLUMN account_tax.l10n_es_bien_inversion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_es_bien_inversion IS 'Bien de Inversion';


--
-- Name: COLUMN account_tax.l10n_cl_sii_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_cl_sii_code IS 'SII Code';


--
-- Name: COLUMN account_tax.l10n_es_edi_facturae_tax_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_es_edi_facturae_tax_type IS 'Spanish Facturae EDI Tax Type';


--
-- Name: COLUMN account_tax.l10n_pe_edi_tax_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_pe_edi_tax_code IS 'Code';


--
-- Name: COLUMN account_tax.l10n_pe_edi_unece_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_pe_edi_unece_category IS 'UNECE Code';


--
-- Name: COLUMN account_tax.l10n_pe_edi_isc_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_pe_edi_isc_type IS 'ISC Type';


--
-- Name: COLUMN account_tax.l10n_uy_tax_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_uy_tax_category IS 'Tax Category';


--
-- Name: COLUMN account_tax.l10n_ar_withholding_sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_withholding_sequence_id IS 'WTH Sequence';


--
-- Name: COLUMN account_tax.l10n_ar_state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_state_id IS 'Jurisdiction';


--
-- Name: COLUMN account_tax.l10n_ar_scale_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_scale_id IS 'Scale';


--
-- Name: COLUMN account_tax.l10n_ar_withholding_payment_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_withholding_payment_type IS 'Argentina Withholding Payment Type';


--
-- Name: COLUMN account_tax.l10n_ar_tax_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_tax_type IS 'WTH Tax';


--
-- Name: COLUMN account_tax.l10n_ar_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_code IS 'ARCA Code';


--
-- Name: COLUMN account_tax.l10n_ar_non_taxable_amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_non_taxable_amount IS 'Non Taxable Amount';


--
-- Name: COLUMN account_tax.l10n_ar_minimum_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_ar_minimum_threshold IS 'Minimum Treshold';


--
-- Name: COLUMN account_tax.l10n_pe_edi_affectation_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.l10n_pe_edi_affectation_reason IS 'Affectation Reason';


--
-- Name: COLUMN account_tax.api_codigo_articulo_retencion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_codigo_articulo_retencion IS 'Código de Artículo/Inciso por el que retiene';


--
-- Name: COLUMN account_tax.api_codigo_articulo_percepcion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_codigo_articulo_percepcion IS 'Código de artículo Inciso por el que percibe';


--
-- Name: COLUMN account_tax.api_articulo_inciso_calculo_percepcion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_articulo_inciso_calculo_percepcion IS 'Artículo/Inciso para el cálculo percepción';


--
-- Name: COLUMN account_tax.api_articulo_inciso_calculo_retencion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.api_articulo_inciso_calculo_retencion IS 'Artículo/Inciso para el cálculo retención';


--
-- Name: COLUMN account_tax.ratio; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.ratio IS 'Ratio';


--
-- Name: COLUMN account_tax.is_backward_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax.is_backward_tax IS 'Is Backward Tax';


--
-- Name: account_tax_alternatives; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_alternatives (
    dest_tax_id integer NOT NULL,
    src_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_alternatives OWNER TO runbot;

--
-- Name: TABLE account_tax_alternatives; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_alternatives IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_filiation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_filiation_rel (
    parent_tax integer NOT NULL,
    child_tax integer NOT NULL
);


ALTER TABLE public.account_tax_filiation_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_filiation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_filiation_rel IS 'RELATION BETWEEN account_tax AND account_tax';


--
-- Name: account_tax_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_group (
    id integer NOT NULL,
    sequence integer,
    company_id integer NOT NULL,
    tax_payable_account_id integer,
    tax_receivable_account_id integer,
    advance_tax_payment_account_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    pos_receipt_label character varying,
    name jsonb NOT NULL,
    preceding_subtotal jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    l10n_ar_tribute_afip_code character varying,
    l10n_ar_vat_afip_code character varying,
    l10n_pe_edi_code character varying
);


ALTER TABLE public.account_tax_group OWNER TO runbot;

--
-- Name: TABLE account_tax_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_group IS 'Tax Group';


--
-- Name: COLUMN account_tax_group.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_group.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.company_id IS 'Company';


--
-- Name: COLUMN account_tax_group.tax_payable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_payable_account_id IS 'Tax Payable Account';


--
-- Name: COLUMN account_tax_group.tax_receivable_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.tax_receivable_account_id IS 'Tax Receivable Account';


--
-- Name: COLUMN account_tax_group.advance_tax_payment_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.advance_tax_payment_account_id IS 'Tax Advance Account';


--
-- Name: COLUMN account_tax_group.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.country_id IS 'Country';


--
-- Name: COLUMN account_tax_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_group.pos_receipt_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.pos_receipt_label IS 'PoS receipt label';


--
-- Name: COLUMN account_tax_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.name IS 'Name';


--
-- Name: COLUMN account_tax_group.preceding_subtotal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.preceding_subtotal IS 'Preceding Subtotal';


--
-- Name: COLUMN account_tax_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.write_date IS 'Last Updated on';


--
-- Name: COLUMN account_tax_group.l10n_ar_tribute_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_tribute_afip_code IS 'Tribute ARCA Code';


--
-- Name: COLUMN account_tax_group.l10n_ar_vat_afip_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_ar_vat_afip_code IS 'VAT ARCA Code';


--
-- Name: COLUMN account_tax_group.l10n_pe_edi_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_group.l10n_pe_edi_code IS 'EDI Code';


--
-- Name: account_tax_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_group_id_seq OWNER TO runbot;

--
-- Name: account_tax_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_group_id_seq OWNED BY public.account_tax_group.id;


--
-- Name: account_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_id_seq OWNER TO runbot;

--
-- Name: account_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_id_seq OWNED BY public.account_tax.id;


--
-- Name: account_tax_pos_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_pos_order_line_rel (
    pos_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_pos_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_pos_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_pos_order_line_rel IS 'RELATION BETWEEN pos_order_line AND account_tax';


--
-- Name: account_tax_purchase_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_purchase_order_line_rel (
    purchase_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_purchase_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_purchase_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_purchase_order_line_rel IS 'RELATION BETWEEN purchase_order_line AND account_tax';


--
-- Name: account_tax_repartition_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_repartition_line (
    id integer NOT NULL,
    account_id integer,
    tax_id integer,
    company_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    repartition_type character varying NOT NULL,
    document_type character varying NOT NULL,
    factor_percent numeric NOT NULL,
    use_in_tax_closing boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_repartition_line OWNER TO runbot;

--
-- Name: TABLE account_tax_repartition_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_repartition_line IS 'Tax Repartition Line';


--
-- Name: COLUMN account_tax_repartition_line.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.account_id IS 'Account';


--
-- Name: COLUMN account_tax_repartition_line.tax_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.tax_id IS 'Tax';


--
-- Name: COLUMN account_tax_repartition_line.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.company_id IS 'Company';


--
-- Name: COLUMN account_tax_repartition_line.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.sequence IS 'Sequence';


--
-- Name: COLUMN account_tax_repartition_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_repartition_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_repartition_line.repartition_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.repartition_type IS 'Based On';


--
-- Name: COLUMN account_tax_repartition_line.document_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.document_type IS 'Related to';


--
-- Name: COLUMN account_tax_repartition_line.factor_percent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.factor_percent IS '%';


--
-- Name: COLUMN account_tax_repartition_line.use_in_tax_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.use_in_tax_closing IS 'Tax Closing Entry';


--
-- Name: COLUMN account_tax_repartition_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_repartition_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_repartition_line.write_date IS 'Last Updated on';


--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_repartition_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNER TO runbot;

--
-- Name: account_tax_repartition_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_repartition_line_id_seq OWNED BY public.account_tax_repartition_line.id;


--
-- Name: account_tax_sale_advance_payment_inv_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_advance_payment_inv_rel (
    sale_advance_payment_inv_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_advance_payment_inv_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_advance_payment_inv_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_advance_payment_inv_rel IS 'RELATION BETWEEN sale_advance_payment_inv AND account_tax';


--
-- Name: account_tax_sale_order_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_sale_order_line_rel (
    sale_order_line_id integer NOT NULL,
    account_tax_id integer NOT NULL
);


ALTER TABLE public.account_tax_sale_order_line_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_sale_order_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_sale_order_line_rel IS 'RELATION BETWEEN sale_order_line AND account_tax';


--
-- Name: account_tax_unit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit (
    id integer NOT NULL,
    country_id integer NOT NULL,
    main_company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    vat character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_tax_unit OWNER TO runbot;

--
-- Name: TABLE account_tax_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit IS 'Tax Unit';


--
-- Name: COLUMN account_tax_unit.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.country_id IS 'Country';


--
-- Name: COLUMN account_tax_unit.main_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.main_company_id IS 'Main Company';


--
-- Name: COLUMN account_tax_unit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_uid IS 'Created by';


--
-- Name: COLUMN account_tax_unit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_tax_unit.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.name IS 'Name';


--
-- Name: COLUMN account_tax_unit.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.vat IS 'Tax ID';


--
-- Name: COLUMN account_tax_unit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.create_date IS 'Created on';


--
-- Name: COLUMN account_tax_unit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_tax_unit.write_date IS 'Last Updated on';


--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_tax_unit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_tax_unit_id_seq OWNER TO runbot;

--
-- Name: account_tax_unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_tax_unit_id_seq OWNED BY public.account_tax_unit.id;


--
-- Name: account_tax_unit_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_tax_unit_res_company_rel (
    res_company_id integer NOT NULL,
    account_tax_unit_id integer NOT NULL
);


ALTER TABLE public.account_tax_unit_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_tax_unit_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_tax_unit_res_company_rel IS 'RELATION BETWEEN res_company AND account_tax_unit';


--
-- Name: account_uy_vat_line; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.account_uy_vat_line AS
SELECT
    NULL::text AS column_group_key,
    NULL::integer AS id,
    NULL::character varying AS rut,
    NULL::character varying AS move_name,
    NULL::character varying AS partner_name,
    NULL::integer AS move_id,
    NULL::character varying AS tax_type,
    NULL::character varying AS move_type,
    NULL::date AS date,
    NULL::date AS invoice_date,
    NULL::integer AS partner_id,
    NULL::integer AS journal_id,
    NULL::integer AS document_type_id,
    NULL::character varying AS state,
    NULL::integer AS company_id,
    NULL::numeric AS base_22,
    NULL::numeric AS vat_22,
    NULL::numeric AS base_10,
    NULL::numeric AS vat_10,
    NULL::numeric AS not_taxed,
    NULL::numeric AS taxed,
    NULL::numeric AS other_taxes,
    NULL::numeric AS total;


ALTER VIEW public.account_uy_vat_line OWNER TO runbot;

--
-- Name: account_write_off_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_write_off_type (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    label character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.account_write_off_type OWNER TO runbot;

--
-- Name: TABLE account_write_off_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_write_off_type IS 'account.write_off.type';


--
-- Name: COLUMN account_write_off_type.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.account_id IS 'Account';


--
-- Name: COLUMN account_write_off_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.create_uid IS 'Created by';


--
-- Name: COLUMN account_write_off_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN account_write_off_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.name IS 'Name';


--
-- Name: COLUMN account_write_off_type.label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.label IS 'Label';


--
-- Name: COLUMN account_write_off_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.active IS 'Active';


--
-- Name: COLUMN account_write_off_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.create_date IS 'Created on';


--
-- Name: COLUMN account_write_off_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.account_write_off_type.write_date IS 'Last Updated on';


--
-- Name: account_write_off_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.account_write_off_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.account_write_off_type_id_seq OWNER TO runbot;

--
-- Name: account_write_off_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.account_write_off_type_id_seq OWNED BY public.account_write_off_type.id;


--
-- Name: account_write_off_type_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.account_write_off_type_res_company_rel (
    account_write_off_type_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.account_write_off_type_res_company_rel OWNER TO runbot;

--
-- Name: TABLE account_write_off_type_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.account_write_off_type_res_company_rel IS 'RELATION BETWEEN account_write_off_type AND res_company';


--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: adhoc_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adhoc_module_category (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.adhoc_module_category OWNER TO runbot;

--
-- Name: TABLE adhoc_module_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adhoc_module_category IS 'adhoc.module.category';


--
-- Name: COLUMN adhoc_module_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_uid IS 'Created by';


--
-- Name: COLUMN adhoc_module_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN adhoc_module_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.name IS 'Name';


--
-- Name: COLUMN adhoc_module_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.create_date IS 'Created on';


--
-- Name: COLUMN adhoc_module_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.adhoc_module_category.write_date IS 'Last Updated on';


--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.adhoc_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.adhoc_module_category_id_seq OWNER TO runbot;

--
-- Name: adhoc_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.adhoc_module_category_id_seq OWNED BY public.adhoc_module_category.id;


--
-- Name: adjusting_entries__account_move; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.adjusting_entries__account_move (
    move_id integer NOT NULL,
    adjusting_entry_move_id integer NOT NULL
);


ALTER TABLE public.adjusting_entries__account_move OWNER TO runbot;

--
-- Name: TABLE adjusting_entries__account_move; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.adjusting_entries__account_move IS 'RELATION BETWEEN account_move AND account_move';


--
-- Name: afip_concept; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_concept (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_concept OWNER TO runbot;

--
-- Name: TABLE afip_concept; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_concept IS 'afip.concept';


--
-- Name: COLUMN afip_concept.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_uid IS 'Created by';


--
-- Name: COLUMN afip_concept.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_concept.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.code IS 'Code';


--
-- Name: COLUMN afip_concept.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.name IS 'Name';


--
-- Name: COLUMN afip_concept.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.active IS 'Active';


--
-- Name: COLUMN afip_concept.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.create_date IS 'Created on';


--
-- Name: COLUMN afip_concept.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_concept.write_date IS 'Last Updated on';


--
-- Name: afip_concept_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_concept_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_concept_id_seq OWNER TO runbot;

--
-- Name: afip_concept_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_concept_id_seq OWNED BY public.afip_concept.id;


--
-- Name: afip_import_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_import_wizard (
    id integer NOT NULL,
    company_id integer NOT NULL,
    journal_id integer NOT NULL,
    counterpart_account_id integer,
    create_uid integer,
    write_uid integer,
    file_name character varying,
    auto_validate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_import_wizard OWNER TO runbot;

--
-- Name: TABLE afip_import_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_import_wizard IS 'Import AFIP bills from xlsx';


--
-- Name: COLUMN afip_import_wizard.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard.company_id IS 'Company';


--
-- Name: COLUMN afip_import_wizard.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard.journal_id IS 'Journal';


--
-- Name: COLUMN afip_import_wizard.counterpart_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard.counterpart_account_id IS 'Counterpart Account';


--
-- Name: COLUMN afip_import_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN afip_import_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_import_wizard.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard.file_name IS 'Nombre del Archivo';


--
-- Name: COLUMN afip_import_wizard.auto_validate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard.auto_validate IS 'Autovalidar Facturas Importadas';


--
-- Name: COLUMN afip_import_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard.create_date IS 'Created on';


--
-- Name: COLUMN afip_import_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard.write_date IS 'Last Updated on';


--
-- Name: afip_import_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_import_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_import_wizard_id_seq OWNER TO runbot;

--
-- Name: afip_import_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_import_wizard_id_seq OWNED BY public.afip_import_wizard.id;


--
-- Name: afip_import_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_import_wizard_line (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    invoice_number character varying,
    partner_name character varying,
    partner_vat character varying,
    partner_identification_type character varying,
    currency character varying,
    document_type character varying,
    move_type character varying,
    cae character varying,
    date_invoice date,
    "exists" boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    currency_rate double precision,
    amount_total double precision,
    neto_grav_iva_0 double precision,
    iva_2_5 double precision,
    neto_grav_iva_2_5 double precision,
    iva_5 double precision,
    neto_grav_iva_5 double precision,
    iva_10_5 double precision,
    neto_grav_iva_10_5 double precision,
    iva_21 double precision,
    neto_grav_iva_21 double precision,
    iva_27 double precision,
    neto_grav_iva_27 double precision,
    no_gravado double precision,
    otros_tributos double precision,
    exento double precision
);


ALTER TABLE public.afip_import_wizard_line OWNER TO runbot;

--
-- Name: TABLE afip_import_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_import_wizard_line IS 'Línea de Factura Importada desde Excel';


--
-- Name: COLUMN afip_import_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN afip_import_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN afip_import_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_import_wizard_line.invoice_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.invoice_number IS 'Número de Factura';


--
-- Name: COLUMN afip_import_wizard_line.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.partner_name IS 'Proveedor';


--
-- Name: COLUMN afip_import_wizard_line.partner_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.partner_vat IS 'VAT del Proveedor';


--
-- Name: COLUMN afip_import_wizard_line.partner_identification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.partner_identification_type IS 'Tipo de Identificación';


--
-- Name: COLUMN afip_import_wizard_line.currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.currency IS 'Moneda';


--
-- Name: COLUMN afip_import_wizard_line.document_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.document_type IS 'Tipo de Documento';


--
-- Name: COLUMN afip_import_wizard_line.move_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.move_type IS 'Tipo de Factura';


--
-- Name: COLUMN afip_import_wizard_line.cae; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.cae IS 'CAE';


--
-- Name: COLUMN afip_import_wizard_line.date_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.date_invoice IS 'Fecha de Factura';


--
-- Name: COLUMN afip_import_wizard_line."exists"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line."exists" IS 'Ya Existe';


--
-- Name: COLUMN afip_import_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN afip_import_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.write_date IS 'Last Updated on';


--
-- Name: COLUMN afip_import_wizard_line.currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.currency_rate IS 'Valor de cambio';


--
-- Name: COLUMN afip_import_wizard_line.amount_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.amount_total IS 'Total';


--
-- Name: COLUMN afip_import_wizard_line.neto_grav_iva_0; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.neto_grav_iva_0 IS 'Neto Gravado IVA 0%';


--
-- Name: COLUMN afip_import_wizard_line.iva_2_5; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.iva_2_5 IS 'IVA 2.5%';


--
-- Name: COLUMN afip_import_wizard_line.neto_grav_iva_2_5; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.neto_grav_iva_2_5 IS 'Neto Gravado IVA 2.5%';


--
-- Name: COLUMN afip_import_wizard_line.iva_5; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.iva_5 IS 'IVA 5%';


--
-- Name: COLUMN afip_import_wizard_line.neto_grav_iva_5; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.neto_grav_iva_5 IS 'Neto Gravado IVA 5%';


--
-- Name: COLUMN afip_import_wizard_line.iva_10_5; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.iva_10_5 IS 'IVA 10.5%';


--
-- Name: COLUMN afip_import_wizard_line.neto_grav_iva_10_5; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.neto_grav_iva_10_5 IS 'Neto Gravado IVA 10.5%';


--
-- Name: COLUMN afip_import_wizard_line.iva_21; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.iva_21 IS 'IVA 21%';


--
-- Name: COLUMN afip_import_wizard_line.neto_grav_iva_21; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.neto_grav_iva_21 IS 'Neto Gravado IVA 21%';


--
-- Name: COLUMN afip_import_wizard_line.iva_27; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.iva_27 IS 'IVA 27%';


--
-- Name: COLUMN afip_import_wizard_line.neto_grav_iva_27; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.neto_grav_iva_27 IS 'Neto Gravado IVA 27%';


--
-- Name: COLUMN afip_import_wizard_line.no_gravado; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.no_gravado IS 'No Gravado';


--
-- Name: COLUMN afip_import_wizard_line.otros_tributos; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.otros_tributos IS 'Otros Tributos';


--
-- Name: COLUMN afip_import_wizard_line.exento; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_import_wizard_line.exento IS 'Exento';


--
-- Name: afip_import_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_import_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_import_wizard_line_id_seq OWNER TO runbot;

--
-- Name: afip_import_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_import_wizard_line_id_seq OWNED BY public.afip_import_wizard_line.id;


--
-- Name: afip_tax; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.afip_tax (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying NOT NULL,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.afip_tax OWNER TO runbot;

--
-- Name: TABLE afip_tax; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.afip_tax IS 'afip.tax';


--
-- Name: COLUMN afip_tax.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_uid IS 'Created by';


--
-- Name: COLUMN afip_tax.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_uid IS 'Last Updated by';


--
-- Name: COLUMN afip_tax.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.code IS 'Code';


--
-- Name: COLUMN afip_tax.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.name IS 'Name';


--
-- Name: COLUMN afip_tax.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.active IS 'Active';


--
-- Name: COLUMN afip_tax.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.create_date IS 'Created on';


--
-- Name: COLUMN afip_tax.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.afip_tax.write_date IS 'Last Updated on';


--
-- Name: afip_tax_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.afip_tax_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.afip_tax_id_seq OWNER TO runbot;

--
-- Name: afip_tax_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.afip_tax_id_seq OWNED BY public.afip_tax.id;


--
-- Name: ai_agent; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subtitle character varying,
    response_style character varying NOT NULL,
    llm_model character varying NOT NULL,
    system_prompt text,
    active boolean,
    restrict_to_sources boolean,
    is_system_agent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    source_id integer NOT NULL
);


ALTER TABLE public.ai_agent OWNER TO runbot;

--
-- Name: TABLE ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent IS 'AI Agent';


--
-- Name: COLUMN ai_agent.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.partner_id IS 'Partner';


--
-- Name: COLUMN ai_agent.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent.subtitle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.subtitle IS 'Description';


--
-- Name: COLUMN ai_agent.response_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.response_style IS 'Response Style';


--
-- Name: COLUMN ai_agent.llm_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.llm_model IS 'LLM Model';


--
-- Name: COLUMN ai_agent.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.system_prompt IS 'System Prompt';


--
-- Name: COLUMN ai_agent.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.active IS 'Active';


--
-- Name: COLUMN ai_agent.restrict_to_sources; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.restrict_to_sources IS 'Restrict to Sources';


--
-- Name: COLUMN ai_agent.is_system_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.is_system_agent IS 'System Agent';


--
-- Name: COLUMN ai_agent.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_date IS 'Last Updated on';


--
-- Name: COLUMN ai_agent.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.source_id IS 'Source';


--
-- Name: ai_agent_ai_topic_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_ai_topic_rel (
    ai_agent_id integer NOT NULL,
    ai_topic_id integer NOT NULL
);


ALTER TABLE public.ai_agent_ai_topic_rel OWNER TO runbot;

--
-- Name: TABLE ai_agent_ai_topic_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_ai_topic_rel IS 'RELATION BETWEEN ai_agent AND ai_topic';


--
-- Name: ai_agent_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_id_seq OWNER TO runbot;

--
-- Name: ai_agent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_id_seq OWNED BY public.ai_agent.id;


--
-- Name: ai_agent_source; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_source (
    id integer NOT NULL,
    agent_id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    type character varying NOT NULL,
    status character varying,
    url character varying,
    error_details text,
    is_active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    res_id integer,
    model_template_id integer,
    source_rule_id integer,
    document_id integer
);


ALTER TABLE public.ai_agent_source OWNER TO runbot;

--
-- Name: TABLE ai_agent_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_source IS 'AI Agent Source';


--
-- Name: COLUMN ai_agent_source.agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.agent_id IS 'Agent';


--
-- Name: COLUMN ai_agent_source.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_agent_source.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent_source.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent_source.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.name IS 'Name';


--
-- Name: COLUMN ai_agent_source.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.type IS 'Type';


--
-- Name: COLUMN ai_agent_source.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.status IS 'Status';


--
-- Name: COLUMN ai_agent_source.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.url IS 'URL';


--
-- Name: COLUMN ai_agent_source.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.error_details IS 'Error Details';


--
-- Name: COLUMN ai_agent_source.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.is_active IS 'Active';


--
-- Name: COLUMN ai_agent_source.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent_source.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_date IS 'Last Updated on';


--
-- Name: COLUMN ai_agent_source.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.res_id IS 'Related Document';


--
-- Name: COLUMN ai_agent_source.model_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.model_template_id IS 'Model Template';


--
-- Name: COLUMN ai_agent_source.source_rule_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.source_rule_id IS 'Source Rule';


--
-- Name: COLUMN ai_agent_source.document_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.document_id IS 'Source Document';


--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_source_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_source_id_seq OWNER TO runbot;

--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_source_id_seq OWNED BY public.ai_agent_source.id;


--
-- Name: ai_agent_source_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_source_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    model_template_id integer NOT NULL,
    agent_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    domain character varying,
    is_active boolean,
    last_update timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent_source_rule OWNER TO runbot;

--
-- Name: TABLE ai_agent_source_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_source_rule IS 'AI Agent Source Rule';


--
-- Name: COLUMN ai_agent_source_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.model_id IS 'Model';


--
-- Name: COLUMN ai_agent_source_rule.model_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.model_template_id IS 'Model Template';


--
-- Name: COLUMN ai_agent_source_rule.agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.agent_id IS 'Agent';


--
-- Name: COLUMN ai_agent_source_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent_source_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent_source_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.name IS 'Name';


--
-- Name: COLUMN ai_agent_source_rule.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.domain IS 'Domain';


--
-- Name: COLUMN ai_agent_source_rule.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.is_active IS 'Active';


--
-- Name: COLUMN ai_agent_source_rule.last_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.last_update IS 'Last Update';


--
-- Name: COLUMN ai_agent_source_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent_source_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source_rule.write_date IS 'Last Updated on';


--
-- Name: ai_agent_source_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_source_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_source_rule_id_seq OWNER TO runbot;

--
-- Name: ai_agent_source_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_source_rule_id_seq OWNED BY public.ai_agent_source_rule.id;


--
-- Name: ai_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer (
    id integer NOT NULL,
    ai_agent integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    interface_key character varying NOT NULL,
    default_prompt text,
    is_system_default boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_composer OWNER TO runbot;

--
-- Name: TABLE ai_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer IS 'AI model configurations (system prompts) for text drafting.';


--
-- Name: COLUMN ai_composer.ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.ai_agent IS 'Agent';


--
-- Name: COLUMN ai_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_uid IS 'Created by';


--
-- Name: COLUMN ai_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_composer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.name IS 'Rule Name';


--
-- Name: COLUMN ai_composer.interface_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.interface_key IS 'Action';


--
-- Name: COLUMN ai_composer.default_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.default_prompt IS 'Instructions';


--
-- Name: COLUMN ai_composer.is_system_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.is_system_default IS 'Is the rule a system default or user created';


--
-- Name: COLUMN ai_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_date IS 'Created on';


--
-- Name: COLUMN ai_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_date IS 'Last Updated on';


--
-- Name: ai_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_composer_id_seq OWNER TO runbot;

--
-- Name: ai_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_composer_id_seq OWNED BY public.ai_composer.id;


--
-- Name: ai_composer_ir_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer_ir_model_rel (
    ai_composer_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ai_composer_ir_model_rel OWNER TO runbot;

--
-- Name: TABLE ai_composer_ir_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer_ir_model_rel IS 'RELATION BETWEEN ai_composer AND ir_model';


--
-- Name: ai_documents_sort; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_documents_sort (
    id integer NOT NULL,
    folder_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    ai_sort_prompt text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_documents_sort OWNER TO runbot;

--
-- Name: TABLE ai_documents_sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_documents_sort IS 'Ai Documents Sort';


--
-- Name: COLUMN ai_documents_sort.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_documents_sort.folder_id IS 'Folder';


--
-- Name: COLUMN ai_documents_sort.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_documents_sort.create_uid IS 'Created by';


--
-- Name: COLUMN ai_documents_sort.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_documents_sort.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_documents_sort.ai_sort_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_documents_sort.ai_sort_prompt IS 'AI Folder Sort Prompt';


--
-- Name: COLUMN ai_documents_sort.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_documents_sort.create_date IS 'Created on';


--
-- Name: COLUMN ai_documents_sort.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_documents_sort.write_date IS 'Last Updated on';


--
-- Name: ai_documents_sort_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_documents_sort_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_documents_sort_id_seq OWNER TO runbot;

--
-- Name: ai_documents_sort_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_documents_sort_id_seq OWNED BY public.ai_documents_sort.id;


--
-- Name: ai_documents_sort_ir_act_server_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_documents_sort_ir_act_server_rel (
    ai_documents_sort_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.ai_documents_sort_ir_act_server_rel OWNER TO runbot;

--
-- Name: TABLE ai_documents_sort_ir_act_server_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_documents_sort_ir_act_server_rel IS 'RELATION BETWEEN ai_documents_sort AND ir_act_server';


--
-- Name: ai_embedding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_embedding (
    id integer NOT NULL,
    attachment_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    embedding_model character varying NOT NULL,
    content text NOT NULL,
    has_embedding_generation_failed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    embedding_vector public.vector(1536)
);


ALTER TABLE public.ai_embedding OWNER TO runbot;

--
-- Name: TABLE ai_embedding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_embedding IS 'Attachment Chunks Embedding';


--
-- Name: COLUMN ai_embedding.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_embedding.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.sequence IS 'Sequence';


--
-- Name: COLUMN ai_embedding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_uid IS 'Created by';


--
-- Name: COLUMN ai_embedding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_embedding.embedding_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_model IS 'Embedding Model';


--
-- Name: COLUMN ai_embedding.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.content IS 'Chunk Content';


--
-- Name: COLUMN ai_embedding.has_embedding_generation_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.has_embedding_generation_failed IS 'Has Embedding Generation Failed';


--
-- Name: COLUMN ai_embedding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_date IS 'Created on';


--
-- Name: COLUMN ai_embedding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_date IS 'Last Updated on';


--
-- Name: COLUMN ai_embedding.embedding_vector; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_vector IS 'Embedding Vector';


--
-- Name: ai_embedding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_embedding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_embedding_id_seq OWNER TO runbot;

--
-- Name: ai_embedding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_embedding_id_seq OWNED BY public.ai_embedding.id;


--
-- Name: ai_model_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_model_template (
    id integer NOT NULL,
    model_id integer NOT NULL,
    template_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_model_template OWNER TO runbot;

--
-- Name: TABLE ai_model_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_model_template IS 'ai.model.template';


--
-- Name: COLUMN ai_model_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template.model_id IS 'Model';


--
-- Name: COLUMN ai_model_template.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template.template_id IS 'Template View';


--
-- Name: COLUMN ai_model_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template.create_uid IS 'Created by';


--
-- Name: COLUMN ai_model_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_model_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template.name IS 'Name';


--
-- Name: COLUMN ai_model_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template.active IS 'Active';


--
-- Name: COLUMN ai_model_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template.create_date IS 'Created on';


--
-- Name: COLUMN ai_model_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template.write_date IS 'Last Updated on';


--
-- Name: ai_model_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_model_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_model_template_id_seq OWNER TO runbot;

--
-- Name: ai_model_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_model_template_id_seq OWNED BY public.ai_model_template.id;


--
-- Name: ai_model_template_preview_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_model_template_preview_wizard (
    id integer NOT NULL,
    res_id integer,
    template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_model_template_preview_wizard OWNER TO runbot;

--
-- Name: TABLE ai_model_template_preview_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_model_template_preview_wizard IS 'ai.model.template.preview.wizard';


--
-- Name: COLUMN ai_model_template_preview_wizard.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template_preview_wizard.res_id IS 'Related Document';


--
-- Name: COLUMN ai_model_template_preview_wizard.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template_preview_wizard.template_id IS 'Template';


--
-- Name: COLUMN ai_model_template_preview_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template_preview_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ai_model_template_preview_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template_preview_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_model_template_preview_wizard.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template_preview_wizard.res_model IS 'Res Model';


--
-- Name: COLUMN ai_model_template_preview_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template_preview_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ai_model_template_preview_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_model_template_preview_wizard.write_date IS 'Last Updated on';


--
-- Name: ai_model_template_preview_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_model_template_preview_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_model_template_preview_wizard_id_seq OWNER TO runbot;

--
-- Name: ai_model_template_preview_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_model_template_preview_wizard_id_seq OWNED BY public.ai_model_template_preview_wizard.id;


--
-- Name: ai_prompt_button; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_prompt_button (
    id integer NOT NULL,
    sequence integer,
    composer_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_prompt_button OWNER TO runbot;

--
-- Name: TABLE ai_prompt_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_prompt_button IS 'Prompt that can be attached to AI UI rules for quick access by the user.';


--
-- Name: COLUMN ai_prompt_button.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.sequence IS 'Sequence';


--
-- Name: COLUMN ai_prompt_button.composer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.composer_id IS 'Composer';


--
-- Name: COLUMN ai_prompt_button.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_uid IS 'Created by';


--
-- Name: COLUMN ai_prompt_button.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_prompt_button.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.name IS 'AI Prompt';


--
-- Name: COLUMN ai_prompt_button.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_date IS 'Created on';


--
-- Name: COLUMN ai_prompt_button.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_date IS 'Last Updated on';


--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_prompt_button_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_prompt_button_id_seq OWNER TO runbot;

--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_prompt_button_id_seq OWNED BY public.ai_prompt_button.id;


--
-- Name: ai_tool_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_tool_ids_rel (
    parent_id integer NOT NULL,
    tool_id integer NOT NULL
);


ALTER TABLE public.ai_tool_ids_rel OWNER TO runbot;

--
-- Name: TABLE ai_tool_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_tool_ids_rel IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: ai_topic; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description text,
    instructions text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_topic OWNER TO runbot;

--
-- Name: TABLE ai_topic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic IS 'Create a topic that leverages instructions and tools to direct Odoo AI in assisting the user with their tasks.';


--
-- Name: COLUMN ai_topic.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_uid IS 'Created by';


--
-- Name: COLUMN ai_topic.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_topic.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.name IS 'Title';


--
-- Name: COLUMN ai_topic.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.description IS 'Description';


--
-- Name: COLUMN ai_topic.instructions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.instructions IS 'Instructions';


--
-- Name: COLUMN ai_topic.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_date IS 'Created on';


--
-- Name: COLUMN ai_topic.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_date IS 'Last Updated on';


--
-- Name: ai_topic_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_topic_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_topic_id_seq OWNER TO runbot;

--
-- Name: ai_topic_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_topic_id_seq OWNED BY public.ai_topic.id;


--
-- Name: ai_topic_ir_act_server_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic_ir_act_server_rel (
    ai_topic_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.ai_topic_ir_act_server_rel OWNER TO runbot;

--
-- Name: TABLE ai_topic_ir_act_server_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic_ir_act_server_rel IS 'RELATION BETWEEN ai_topic AND ir_act_server';


--
-- Name: allow_billable_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.allow_billable_wizard (
    id integer NOT NULL,
    project_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.allow_billable_wizard OWNER TO runbot;

--
-- Name: TABLE allow_billable_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.allow_billable_wizard IS 'Confirmar cambio de valor de Allow Billable';


--
-- Name: COLUMN allow_billable_wizard.project_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allow_billable_wizard.project_id IS 'Project';


--
-- Name: COLUMN allow_billable_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allow_billable_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN allow_billable_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allow_billable_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN allow_billable_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allow_billable_wizard.create_date IS 'Created on';


--
-- Name: COLUMN allow_billable_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.allow_billable_wizard.write_date IS 'Last Updated on';


--
-- Name: allow_billable_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.allow_billable_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.allow_billable_wizard_id_seq OWNER TO runbot;

--
-- Name: allow_billable_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.allow_billable_wizard_id_seq OWNED BY public.allow_billable_wizard.id;


--
-- Name: applicant_get_refuse_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_get_refuse_reason (
    id integer NOT NULL,
    template_id integer,
    refuse_reason_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    scheduled_date character varying,
    body text,
    send_mail boolean,
    duplicates boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.applicant_get_refuse_reason OWNER TO runbot;

--
-- Name: TABLE applicant_get_refuse_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_get_refuse_reason IS 'Get Refuse Reason';


--
-- Name: COLUMN applicant_get_refuse_reason.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.template_id IS 'Email Template';


--
-- Name: COLUMN applicant_get_refuse_reason.refuse_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.refuse_reason_id IS 'Refuse Reason';


--
-- Name: COLUMN applicant_get_refuse_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.create_uid IS 'Created by';


--
-- Name: COLUMN applicant_get_refuse_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN applicant_get_refuse_reason.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.lang IS 'Language';


--
-- Name: COLUMN applicant_get_refuse_reason.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.subject IS 'Subject';


--
-- Name: COLUMN applicant_get_refuse_reason.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN applicant_get_refuse_reason.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.body IS 'Contents';


--
-- Name: COLUMN applicant_get_refuse_reason.send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.send_mail IS 'Send Email';


--
-- Name: COLUMN applicant_get_refuse_reason.duplicates; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.duplicates IS 'Refuse Duplicate Applications';


--
-- Name: COLUMN applicant_get_refuse_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.create_date IS 'Created on';


--
-- Name: COLUMN applicant_get_refuse_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_get_refuse_reason.write_date IS 'Last Updated on';


--
-- Name: applicant_get_refuse_reason_duplicate_applicants_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_get_refuse_reason_duplicate_applicants_rel (
    applicant_get_refuse_reason_id integer NOT NULL,
    hr_applicant_id integer NOT NULL
);


ALTER TABLE public.applicant_get_refuse_reason_duplicate_applicants_rel OWNER TO runbot;

--
-- Name: TABLE applicant_get_refuse_reason_duplicate_applicants_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_get_refuse_reason_duplicate_applicants_rel IS 'RELATION BETWEEN applicant_get_refuse_reason AND hr_applicant';


--
-- Name: applicant_get_refuse_reason_hr_applicant_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_get_refuse_reason_hr_applicant_rel (
    applicant_get_refuse_reason_id integer NOT NULL,
    hr_applicant_id integer NOT NULL
);


ALTER TABLE public.applicant_get_refuse_reason_hr_applicant_rel OWNER TO runbot;

--
-- Name: TABLE applicant_get_refuse_reason_hr_applicant_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_get_refuse_reason_hr_applicant_rel IS 'RELATION BETWEEN applicant_get_refuse_reason AND hr_applicant';


--
-- Name: applicant_get_refuse_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.applicant_get_refuse_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.applicant_get_refuse_reason_id_seq OWNER TO runbot;

--
-- Name: applicant_get_refuse_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.applicant_get_refuse_reason_id_seq OWNED BY public.applicant_get_refuse_reason.id;


--
-- Name: applicant_get_refuse_reason_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_get_refuse_reason_ir_attachment_rel (
    applicant_get_refuse_reason_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.applicant_get_refuse_reason_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE applicant_get_refuse_reason_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_get_refuse_reason_ir_attachment_rel IS 'RELATION BETWEEN applicant_get_refuse_reason AND ir_attachment';


--
-- Name: applicant_send_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_send_mail (
    id integer NOT NULL,
    template_id integer,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.applicant_send_mail OWNER TO runbot;

--
-- Name: TABLE applicant_send_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_send_mail IS 'Send mails to applicants';


--
-- Name: COLUMN applicant_send_mail.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.template_id IS 'Mail Template';


--
-- Name: COLUMN applicant_send_mail.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.author_id IS 'Author';


--
-- Name: COLUMN applicant_send_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.create_uid IS 'Created by';


--
-- Name: COLUMN applicant_send_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN applicant_send_mail.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.lang IS 'Language';


--
-- Name: COLUMN applicant_send_mail.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.subject IS 'Subject';


--
-- Name: COLUMN applicant_send_mail.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.body IS 'Contents';


--
-- Name: COLUMN applicant_send_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.create_date IS 'Created on';


--
-- Name: COLUMN applicant_send_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.applicant_send_mail.write_date IS 'Last Updated on';


--
-- Name: applicant_send_mail_hr_applicant_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_send_mail_hr_applicant_rel (
    applicant_send_mail_id integer NOT NULL,
    hr_applicant_id integer NOT NULL
);


ALTER TABLE public.applicant_send_mail_hr_applicant_rel OWNER TO runbot;

--
-- Name: TABLE applicant_send_mail_hr_applicant_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_send_mail_hr_applicant_rel IS 'RELATION BETWEEN applicant_send_mail AND hr_applicant';


--
-- Name: applicant_send_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.applicant_send_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.applicant_send_mail_id_seq OWNER TO runbot;

--
-- Name: applicant_send_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.applicant_send_mail_id_seq OWNED BY public.applicant_send_mail.id;


--
-- Name: applicant_send_mail_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.applicant_send_mail_ir_attachment_rel (
    applicant_send_mail_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.applicant_send_mail_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE applicant_send_mail_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.applicant_send_mail_ir_attachment_rel IS 'RELATION BETWEEN applicant_send_mail AND ir_attachment';


--
-- Name: arba_cot_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.arba_cot_wizard (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tipo_recorrido character varying NOT NULL,
    patente_vehiculo character varying,
    patente_acoplado character varying,
    prod_no_term_dev character varying NOT NULL,
    datetime_out timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    importe double precision
);


ALTER TABLE public.arba_cot_wizard OWNER TO runbot;

--
-- Name: TABLE arba_cot_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.arba_cot_wizard IS 'arba.cot.wizard';


--
-- Name: COLUMN arba_cot_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.partner_id IS 'Transportista';


--
-- Name: COLUMN arba_cot_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN arba_cot_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN arba_cot_wizard.tipo_recorrido; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.tipo_recorrido IS 'Tipo Recorrido';


--
-- Name: COLUMN arba_cot_wizard.patente_vehiculo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.patente_vehiculo IS 'Patente Vehiculo';


--
-- Name: COLUMN arba_cot_wizard.patente_acoplado; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.patente_acoplado IS 'Patente Acoplado';


--
-- Name: COLUMN arba_cot_wizard.prod_no_term_dev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.prod_no_term_dev IS 'Productos no terminados / devoluciones';


--
-- Name: COLUMN arba_cot_wizard.datetime_out; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.datetime_out IS 'Datetime Out';


--
-- Name: COLUMN arba_cot_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.create_date IS 'Created on';


--
-- Name: COLUMN arba_cot_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN arba_cot_wizard.importe; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.arba_cot_wizard.importe IS 'Importe Neto';


--
-- Name: arba_cot_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.arba_cot_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.arba_cot_wizard_id_seq OWNER TO runbot;

--
-- Name: arba_cot_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.arba_cot_wizard_id_seq OWNED BY public.arba_cot_wizard.id;


--
-- Name: asset_modify; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.asset_modify (
    id integer NOT NULL,
    asset_id integer NOT NULL,
    method_number integer NOT NULL,
    account_asset_id integer,
    account_asset_counterpart_id integer,
    account_depreciation_id integer,
    account_depreciation_expense_id integer,
    create_uid integer,
    write_uid integer,
    method_period character varying,
    modify_action character varying,
    date date,
    name text,
    value_residual numeric,
    salvage_value numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.asset_modify OWNER TO runbot;

--
-- Name: TABLE asset_modify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.asset_modify IS 'Modify Asset';


--
-- Name: COLUMN asset_modify.asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.asset_id IS 'Asset';


--
-- Name: COLUMN asset_modify.method_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.method_number IS 'Duration';


--
-- Name: COLUMN asset_modify.account_asset_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_asset_id IS 'Gross Increase Account';


--
-- Name: COLUMN asset_modify.account_asset_counterpart_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_asset_counterpart_id IS 'Asset Counterpart Account';


--
-- Name: COLUMN asset_modify.account_depreciation_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_id IS 'Depreciation Account';


--
-- Name: COLUMN asset_modify.account_depreciation_expense_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.account_depreciation_expense_id IS 'Expense Account';


--
-- Name: COLUMN asset_modify.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.create_uid IS 'Created by';


--
-- Name: COLUMN asset_modify.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.write_uid IS 'Last Updated by';


--
-- Name: COLUMN asset_modify.method_period; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.method_period IS 'Number of Months in a Period';


--
-- Name: COLUMN asset_modify.modify_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.modify_action IS 'Action';


--
-- Name: COLUMN asset_modify.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.date IS 'Date';


--
-- Name: COLUMN asset_modify.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.name IS 'Note';


--
-- Name: COLUMN asset_modify.value_residual; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.value_residual IS 'Depreciable Amount';


--
-- Name: COLUMN asset_modify.salvage_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.salvage_value IS 'Not Depreciable Amount';


--
-- Name: COLUMN asset_modify.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.create_date IS 'Created on';


--
-- Name: COLUMN asset_modify.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.asset_modify.write_date IS 'Last Updated on';


--
-- Name: asset_modify_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.asset_modify_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.asset_modify_id_seq OWNER TO runbot;

--
-- Name: asset_modify_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.asset_modify_id_seq OWNED BY public.asset_modify.id;


--
-- Name: asset_move_line_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.asset_move_line_rel (
    asset_id integer NOT NULL,
    line_id integer NOT NULL
);


ALTER TABLE public.asset_move_line_rel OWNER TO runbot;

--
-- Name: TABLE asset_move_line_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.asset_move_line_rel IS 'RELATION BETWEEN account_asset AND account_move_line';


--
-- Name: auth_passkey_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key (
    id integer NOT NULL,
    sign_count integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    credential_identifier character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    public_key character varying
);


ALTER TABLE public.auth_passkey_key OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key IS 'Passkey';


--
-- Name: COLUMN auth_passkey_key.sign_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.sign_count IS 'Sign Count';


--
-- Name: COLUMN auth_passkey_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_uid IS 'Create Uid';


--
-- Name: COLUMN auth_passkey_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key.credential_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.credential_identifier IS 'Credential Identifier';


--
-- Name: COLUMN auth_passkey_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key_create (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_passkey_key_create OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key_create IS 'Create a Passkey';


--
-- Name: COLUMN auth_passkey_key_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_uid IS 'Created by';


--
-- Name: COLUMN auth_passkey_key_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNED BY public.auth_passkey_key_create.id;


--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_id_seq OWNED BY public.auth_passkey_key.id;


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_rate_limit_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_rate_limit_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    ip character varying,
    limit_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_totp_rate_limit_log OWNER TO runbot;

--
-- Name: TABLE auth_totp_rate_limit_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_rate_limit_log IS 'TOTP rate limit logs';


--
-- Name: COLUMN auth_totp_rate_limit_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.user_id IS 'User';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_rate_limit_log.ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.ip IS 'Ip';


--
-- Name: COLUMN auth_totp_rate_limit_log.limit_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.limit_type IS 'Limit Type';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_date IS 'Last Updated on';


--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_rate_limit_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNER TO runbot;

--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNED BY public.auth_totp_rate_limit_log.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: avatax_connection_test_result; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_connection_test_result (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_response text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_connection_test_result OWNER TO runbot;

--
-- Name: TABLE avatax_connection_test_result; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_connection_test_result IS 'Test connection with avatax';


--
-- Name: COLUMN avatax_connection_test_result.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_connection_test_result.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_connection_test_result.server_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.server_response IS 'Server Response';


--
-- Name: COLUMN avatax_connection_test_result.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.create_date IS 'Created on';


--
-- Name: COLUMN avatax_connection_test_result.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_connection_test_result.write_date IS 'Last Updated on';


--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_connection_test_result_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNER TO runbot;

--
-- Name: avatax_connection_test_result_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_connection_test_result_id_seq OWNED BY public.avatax_connection_test_result.id;


--
-- Name: avatax_exemption; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_exemption (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    description character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_exemption OWNER TO runbot;

--
-- Name: TABLE avatax_exemption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_exemption IS 'Avatax Partner Exemption Codes';


--
-- Name: COLUMN avatax_exemption.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.company_id IS 'Company';


--
-- Name: COLUMN avatax_exemption.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_exemption.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_exemption.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.name IS 'Name';


--
-- Name: COLUMN avatax_exemption.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.code IS 'Code';


--
-- Name: COLUMN avatax_exemption.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.description IS 'Description';


--
-- Name: COLUMN avatax_exemption.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.create_date IS 'Created on';


--
-- Name: COLUMN avatax_exemption.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_exemption.write_date IS 'Last Updated on';


--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_exemption_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_exemption_id_seq OWNER TO runbot;

--
-- Name: avatax_exemption_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_exemption_id_seq OWNED BY public.avatax_exemption.id;


--
-- Name: avatax_exemption_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_exemption_res_country_rel (
    avatax_exemption_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.avatax_exemption_res_country_rel OWNER TO runbot;

--
-- Name: TABLE avatax_exemption_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_exemption_res_country_rel IS 'RELATION BETWEEN avatax_exemption AND res_country';


--
-- Name: avatax_validate_address; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.avatax_validate_address (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.avatax_validate_address OWNER TO runbot;

--
-- Name: TABLE avatax_validate_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.avatax_validate_address IS 'Suggests validated addresses from Avatax';


--
-- Name: COLUMN avatax_validate_address.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.partner_id IS 'Partner';


--
-- Name: COLUMN avatax_validate_address.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.create_uid IS 'Created by';


--
-- Name: COLUMN avatax_validate_address.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.write_uid IS 'Last Updated by';


--
-- Name: COLUMN avatax_validate_address.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.create_date IS 'Created on';


--
-- Name: COLUMN avatax_validate_address.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.avatax_validate_address.write_date IS 'Last Updated on';


--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.avatax_validate_address_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.avatax_validate_address_id_seq OWNER TO runbot;

--
-- Name: avatax_validate_address_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.avatax_validate_address_id_seq OWNED BY public.avatax_validate_address.id;


--
-- Name: barcode_nomenclature; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_nomenclature (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    upc_ean_conv character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    gs1_separator_fnc1 character varying,
    is_gs1_nomenclature boolean
);


ALTER TABLE public.barcode_nomenclature OWNER TO runbot;

--
-- Name: TABLE barcode_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_nomenclature IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_nomenclature.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_nomenclature.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.name IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_nomenclature.upc_ean_conv; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.upc_ean_conv IS 'UPC/EAN Conversion';


--
-- Name: COLUMN barcode_nomenclature.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.create_date IS 'Created on';


--
-- Name: COLUMN barcode_nomenclature.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_nomenclature.gs1_separator_fnc1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.gs1_separator_fnc1 IS 'FNC1 Separator';


--
-- Name: COLUMN barcode_nomenclature.is_gs1_nomenclature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_nomenclature.is_gs1_nomenclature IS 'Is GS1 Nomenclature';


--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_nomenclature_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNER TO runbot;

--
-- Name: barcode_nomenclature_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_nomenclature_id_seq OWNED BY public.barcode_nomenclature.id;


--
-- Name: barcode_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.barcode_rule (
    id integer NOT NULL,
    barcode_nomenclature_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    encoding character varying NOT NULL,
    type character varying NOT NULL,
    pattern character varying NOT NULL,
    alias character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    associated_uom_id integer,
    gs1_content_type character varying,
    gs1_decimal_usage boolean
);


ALTER TABLE public.barcode_rule OWNER TO runbot;

--
-- Name: TABLE barcode_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.barcode_rule IS 'Barcode Rule';


--
-- Name: COLUMN barcode_rule.barcode_nomenclature_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.barcode_nomenclature_id IS 'Barcode Nomenclature';


--
-- Name: COLUMN barcode_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.sequence IS 'Sequence';


--
-- Name: COLUMN barcode_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_uid IS 'Created by';


--
-- Name: COLUMN barcode_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN barcode_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.name IS 'Rule Name';


--
-- Name: COLUMN barcode_rule.encoding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.encoding IS 'Encoding';


--
-- Name: COLUMN barcode_rule.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.type IS 'Type';


--
-- Name: COLUMN barcode_rule.pattern; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.pattern IS 'Barcode Pattern';


--
-- Name: COLUMN barcode_rule.alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.alias IS 'Alias';


--
-- Name: COLUMN barcode_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.create_date IS 'Created on';


--
-- Name: COLUMN barcode_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN barcode_rule.associated_uom_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.associated_uom_id IS 'Associated Uom';


--
-- Name: COLUMN barcode_rule.gs1_content_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_content_type IS 'GS1 Content Type';


--
-- Name: COLUMN barcode_rule.gs1_decimal_usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.barcode_rule.gs1_decimal_usage IS 'Decimal';


--
-- Name: barcode_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.barcode_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.barcode_rule_id_seq OWNER TO runbot;

--
-- Name: barcode_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.barcode_rule_id_seq OWNED BY public.barcode_rule.id;


--
-- Name: base_automation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation (
    id integer NOT NULL,
    model_id integer NOT NULL,
    trg_selection_field_id integer,
    trg_field_ref integer,
    trg_date_id integer,
    trg_date_range integer,
    trg_date_calendar_id integer,
    create_uid integer,
    write_uid integer,
    webhook_uuid character varying,
    record_getter character varying,
    trigger character varying NOT NULL,
    trg_date_range_mode character varying,
    trg_date_range_type character varying,
    filter_pre_domain character varying,
    filter_domain character varying,
    name jsonb NOT NULL,
    description text,
    log_webhook_calls boolean,
    active boolean,
    last_run timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ai_autosort_folder_id integer,
    trg_date_resource_field_id integer
);


ALTER TABLE public.base_automation OWNER TO runbot;

--
-- Name: TABLE base_automation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation IS 'Automation Rule';


--
-- Name: COLUMN base_automation.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.model_id IS 'Model';


--
-- Name: COLUMN base_automation.trg_selection_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_selection_field_id IS 'Trigger Field';


--
-- Name: COLUMN base_automation.trg_field_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_field_ref IS 'Trigger Reference';


--
-- Name: COLUMN base_automation.trg_date_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_id IS 'Trigger Date';


--
-- Name: COLUMN base_automation.trg_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_range IS 'Delay';


--
-- Name: COLUMN base_automation.trg_date_calendar_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_calendar_id IS 'Use Calendar';


--
-- Name: COLUMN base_automation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.create_uid IS 'Created by';


--
-- Name: COLUMN base_automation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_automation.webhook_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.webhook_uuid IS 'Webhook UUID';


--
-- Name: COLUMN base_automation.record_getter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.record_getter IS 'Record Getter';


--
-- Name: COLUMN base_automation.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trigger IS 'Trigger';


--
-- Name: COLUMN base_automation.trg_date_range_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_range_mode IS 'Delay mode';


--
-- Name: COLUMN base_automation.trg_date_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_range_type IS 'Delay unit';


--
-- Name: COLUMN base_automation.filter_pre_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.filter_pre_domain IS 'Before Update Domain';


--
-- Name: COLUMN base_automation.filter_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.filter_domain IS 'Apply on';


--
-- Name: COLUMN base_automation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.name IS 'Automation Rule Name';


--
-- Name: COLUMN base_automation.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.description IS 'Description';


--
-- Name: COLUMN base_automation.log_webhook_calls; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.log_webhook_calls IS 'Log Calls';


--
-- Name: COLUMN base_automation.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.active IS 'Active';


--
-- Name: COLUMN base_automation.last_run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.last_run IS 'Last Run';


--
-- Name: COLUMN base_automation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.create_date IS 'Created on';


--
-- Name: COLUMN base_automation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_automation.ai_autosort_folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.ai_autosort_folder_id IS 'Sorted Folder';


--
-- Name: COLUMN base_automation.trg_date_resource_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_automation.trg_date_resource_field_id IS 'Use employee work schedule';


--
-- Name: base_automation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_automation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_automation_id_seq OWNER TO runbot;

--
-- Name: base_automation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_automation_id_seq OWNED BY public.base_automation.id;


--
-- Name: base_automation_ir_model_fields_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_ir_model_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_ir_model_fields_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_ir_model_fields_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_ir_model_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_automation_onchange_fields_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_onchange_fields_rel (
    base_automation_id integer NOT NULL,
    ir_model_fields_id integer NOT NULL
);


ALTER TABLE public.base_automation_onchange_fields_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_onchange_fields_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_onchange_fields_rel IS 'RELATION BETWEEN base_automation AND ir_model_fields';


--
-- Name: base_automation_saas_client_dashboard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_automation_saas_client_dashboard_rel (
    saas_client_dashboard_id integer NOT NULL,
    base_automation_id integer NOT NULL
);


ALTER TABLE public.base_automation_saas_client_dashboard_rel OWNER TO runbot;

--
-- Name: TABLE base_automation_saas_client_dashboard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_automation_saas_client_dashboard_rel IS 'RELATION BETWEEN saas_client_dashboard AND base_automation';


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    from_invoice boolean
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_document_layout.from_invoice; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.from_invoice IS 'From Invoice';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_geo_provider; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_geo_provider (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tech_name character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_geo_provider OWNER TO runbot;

--
-- Name: TABLE base_geo_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_geo_provider IS 'Geo Provider';


--
-- Name: COLUMN base_geo_provider.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.create_uid IS 'Created by';


--
-- Name: COLUMN base_geo_provider.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_geo_provider.tech_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.tech_name IS 'Technical Name';


--
-- Name: COLUMN base_geo_provider.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.name IS 'Name';


--
-- Name: COLUMN base_geo_provider.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.create_date IS 'Created on';


--
-- Name: COLUMN base_geo_provider.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_geo_provider.write_date IS 'Last Updated on';


--
-- Name: base_geo_provider_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_geo_provider_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_geo_provider_id_seq OWNER TO runbot;

--
-- Name: base_geo_provider_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_geo_provider_id_seq OWNED BY public.base_geo_provider.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_language_install_website_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install_website_rel (
    base_language_install_id integer NOT NULL,
    website_id integer NOT NULL
);


ALTER TABLE public.base_language_install_website_rel OWNER TO runbot;

--
-- Name: TABLE base_language_install_website_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install_website_rel IS 'RELATION BETWEEN base_language_install AND website';


--
-- Name: base_module_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install (
    id integer NOT NULL,
    confirm_input integer,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install OWNER TO runbot;

--
-- Name: TABLE base_module_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install IS 'Module Install';


--
-- Name: COLUMN base_module_install.confirm_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.confirm_input IS 'Confirm Input';


--
-- Name: COLUMN base_module_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.show_all IS 'Show All';


--
-- Name: COLUMN base_module_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install.write_date IS 'Last Updated on';


--
-- Name: base_module_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_id_seq OWNER TO runbot;

--
-- Name: base_module_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_id_seq OWNED BY public.base_module_install.id;


--
-- Name: base_module_install_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_ir_module_module_rel (
    base_module_install_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_install_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_install_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_ir_module_module_rel IS 'RELATION BETWEEN base_module_install AND ir_module_module';


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    confirm_input integer
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_module_uninstall.confirm_input; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.confirm_input IS 'Confirm Input';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_uninstall_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall_ir_module_module_rel (
    base_module_uninstall_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_uninstall_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall_ir_module_module_rel IS 'RELATION BETWEEN base_module_uninstall AND ir_module_module';


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: bg_job; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bg_job (
    id integer NOT NULL,
    priority integer,
    max_retries integer,
    retry_count integer,
    next_job_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    model character varying NOT NULL,
    method character varying NOT NULL,
    batch_key character varying NOT NULL,
    args_json jsonb,
    kwargs_json jsonb,
    context_json jsonb,
    error_message text,
    start_time timestamp without time zone,
    end_time timestamp without time zone,
    cancel_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision
);


ALTER TABLE public.bg_job OWNER TO runbot;

--
-- Name: TABLE bg_job; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bg_job IS 'Background Job';


--
-- Name: COLUMN bg_job.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.priority IS 'Priority';


--
-- Name: COLUMN bg_job.max_retries; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.max_retries IS 'Max Retries';


--
-- Name: COLUMN bg_job.retry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.retry_count IS 'Retry Count';


--
-- Name: COLUMN bg_job.next_job_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.next_job_id IS 'Next Job';


--
-- Name: COLUMN bg_job.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.create_uid IS 'Created by';


--
-- Name: COLUMN bg_job.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bg_job.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.name IS 'Job Name';


--
-- Name: COLUMN bg_job.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.state IS 'State';


--
-- Name: COLUMN bg_job.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.model IS 'Model';


--
-- Name: COLUMN bg_job.method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.method IS 'Method';


--
-- Name: COLUMN bg_job.batch_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.batch_key IS 'Batch Key';


--
-- Name: COLUMN bg_job.args_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.args_json IS 'Args Json';


--
-- Name: COLUMN bg_job.kwargs_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.kwargs_json IS 'Kwargs Json';


--
-- Name: COLUMN bg_job.context_json; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.context_json IS 'Context Json';


--
-- Name: COLUMN bg_job.error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.error_message IS 'Error Message';


--
-- Name: COLUMN bg_job.start_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.start_time IS 'Start Time';


--
-- Name: COLUMN bg_job.end_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.end_time IS 'End Time';


--
-- Name: COLUMN bg_job.cancel_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.cancel_time IS 'Cancel Time';


--
-- Name: COLUMN bg_job.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.create_date IS 'Created on';


--
-- Name: COLUMN bg_job.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.write_date IS 'Last Updated on';


--
-- Name: COLUMN bg_job.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bg_job.duration IS 'Duration';


--
-- Name: bg_job_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bg_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bg_job_id_seq OWNER TO runbot;

--
-- Name: bg_job_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bg_job_id_seq OWNED BY public.bg_job.id;


--
-- Name: bill_to_po_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bill_to_po_wizard (
    id integer NOT NULL,
    purchase_order_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bill_to_po_wizard OWNER TO runbot;

--
-- Name: TABLE bill_to_po_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bill_to_po_wizard IS 'Bill to Purchase Order';


--
-- Name: COLUMN bill_to_po_wizard.purchase_order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.purchase_order_id IS 'Purchase Order';


--
-- Name: COLUMN bill_to_po_wizard.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.partner_id IS 'Partner';


--
-- Name: COLUMN bill_to_po_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN bill_to_po_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bill_to_po_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.create_date IS 'Created on';


--
-- Name: COLUMN bill_to_po_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bill_to_po_wizard.write_date IS 'Last Updated on';


--
-- Name: bill_to_po_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bill_to_po_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bill_to_po_wizard_id_seq OWNER TO runbot;

--
-- Name: bill_to_po_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bill_to_po_wizard_id_seq OWNED BY public.bill_to_po_wizard.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: calendar_alarm; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm (
    id integer NOT NULL,
    duration integer NOT NULL,
    duration_minutes integer,
    mail_template_id integer,
    create_uid integer,
    write_uid integer,
    alarm_type character varying NOT NULL,
    "interval" character varying NOT NULL,
    name jsonb NOT NULL,
    body text,
    notify_responsible boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    sms_template_id integer,
    wa_template_id integer
);


ALTER TABLE public.calendar_alarm OWNER TO runbot;

--
-- Name: TABLE calendar_alarm; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm IS 'Event Alarm';


--
-- Name: COLUMN calendar_alarm.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration IS 'Remind Before';


--
-- Name: COLUMN calendar_alarm.duration_minutes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.duration_minutes IS 'Duration in minutes';


--
-- Name: COLUMN calendar_alarm.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.mail_template_id IS 'Email Template';


--
-- Name: COLUMN calendar_alarm.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_alarm.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_alarm.alarm_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.alarm_type IS 'Type';


--
-- Name: COLUMN calendar_alarm."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm."interval" IS 'Unit';


--
-- Name: COLUMN calendar_alarm.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.name IS 'Name';


--
-- Name: COLUMN calendar_alarm.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.body IS 'Additional Message';


--
-- Name: COLUMN calendar_alarm.notify_responsible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.notify_responsible IS 'Notify Responsible';


--
-- Name: COLUMN calendar_alarm.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.create_date IS 'Created on';


--
-- Name: COLUMN calendar_alarm.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_alarm.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN calendar_alarm.wa_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_alarm.wa_template_id IS 'WhatsApp Template';


--
-- Name: calendar_alarm_calendar_event_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_alarm_calendar_event_rel (
    calendar_event_id integer NOT NULL,
    calendar_alarm_id integer NOT NULL
);


ALTER TABLE public.calendar_alarm_calendar_event_rel OWNER TO runbot;

--
-- Name: TABLE calendar_alarm_calendar_event_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_alarm_calendar_event_rel IS 'RELATION BETWEEN calendar_event AND calendar_alarm';


--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_alarm_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_alarm_id_seq OWNER TO runbot;

--
-- Name: calendar_alarm_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_alarm_id_seq OWNED BY public.calendar_alarm.id;


--
-- Name: calendar_attendee; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_attendee (
    id integer NOT NULL,
    event_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    common_name character varying,
    access_token character varying,
    state character varying,
    availability character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_attendee OWNER TO runbot;

--
-- Name: TABLE calendar_attendee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_attendee IS 'Calendar Attendee Information';


--
-- Name: COLUMN calendar_attendee.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.event_id IS 'Meeting linked';


--
-- Name: COLUMN calendar_attendee.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.partner_id IS 'Attendee';


--
-- Name: COLUMN calendar_attendee.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_attendee.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_attendee.common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.common_name IS 'Common name';


--
-- Name: COLUMN calendar_attendee.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_attendee.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.state IS 'Status';


--
-- Name: COLUMN calendar_attendee.availability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.availability IS 'Available/Busy';


--
-- Name: COLUMN calendar_attendee.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.create_date IS 'Created on';


--
-- Name: COLUMN calendar_attendee.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_attendee.write_date IS 'Last Updated on';


--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_attendee_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_attendee_id_seq OWNER TO runbot;

--
-- Name: calendar_attendee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_attendee_id_seq OWNED BY public.calendar_attendee.id;


--
-- Name: calendar_event; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event (
    id integer NOT NULL,
    user_id integer,
    videocall_channel_id integer,
    res_id integer,
    res_model_id integer,
    recurrence_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    location character varying,
    videocall_location character varying,
    access_token character varying,
    privacy character varying,
    show_as character varying NOT NULL,
    res_model character varying,
    start_date date,
    stop_date date,
    description text,
    notes text,
    active boolean,
    allday boolean,
    recurrency boolean,
    follow_recurrence boolean,
    start timestamp without time zone NOT NULL,
    stop timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    duration double precision,
    opportunity_id integer,
    applicant_id integer
);


ALTER TABLE public.calendar_event OWNER TO runbot;

--
-- Name: TABLE calendar_event; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event IS 'Calendar Event';


--
-- Name: COLUMN calendar_event.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.user_id IS 'Organizer';


--
-- Name: COLUMN calendar_event.videocall_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_channel_id IS 'Discuss Channel';


--
-- Name: COLUMN calendar_event.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_id IS 'Document ID';


--
-- Name: COLUMN calendar_event.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model_id IS 'Document Model';


--
-- Name: COLUMN calendar_event.recurrence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrence_id IS 'Recurrence Rule';


--
-- Name: COLUMN calendar_event.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.name IS 'Meeting Subject';


--
-- Name: COLUMN calendar_event.location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.location IS 'Location';


--
-- Name: COLUMN calendar_event.videocall_location; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.videocall_location IS 'Meeting URL';


--
-- Name: COLUMN calendar_event.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.access_token IS 'Invitation Token';


--
-- Name: COLUMN calendar_event.privacy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.privacy IS 'Privacy';


--
-- Name: COLUMN calendar_event.show_as; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.show_as IS 'Show as';


--
-- Name: COLUMN calendar_event.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.res_model IS 'Document Model Name';


--
-- Name: COLUMN calendar_event.start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start_date IS 'Start Date';


--
-- Name: COLUMN calendar_event.stop_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop_date IS 'End Date';


--
-- Name: COLUMN calendar_event.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.description IS 'Description';


--
-- Name: COLUMN calendar_event.notes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.notes IS 'Notes';


--
-- Name: COLUMN calendar_event.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.active IS 'Active';


--
-- Name: COLUMN calendar_event.allday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.allday IS 'All Day';


--
-- Name: COLUMN calendar_event.recurrency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.recurrency IS 'Recurrent';


--
-- Name: COLUMN calendar_event.follow_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.follow_recurrence IS 'Follow Recurrence';


--
-- Name: COLUMN calendar_event.start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.start IS 'Start';


--
-- Name: COLUMN calendar_event.stop; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.stop IS 'Stop';


--
-- Name: COLUMN calendar_event.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.write_date IS 'Last Updated on';


--
-- Name: COLUMN calendar_event.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.duration IS 'Duration';


--
-- Name: COLUMN calendar_event.opportunity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.opportunity_id IS 'Opportunity';


--
-- Name: COLUMN calendar_event.applicant_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event.applicant_id IS 'Applicant';


--
-- Name: calendar_event_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_id_seq OWNER TO runbot;

--
-- Name: calendar_event_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_id_seq OWNED BY public.calendar_event.id;


--
-- Name: calendar_event_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_res_partner_rel (
    res_partner_id integer NOT NULL,
    calendar_event_id integer NOT NULL
);


ALTER TABLE public.calendar_event_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE calendar_event_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_res_partner_rel IS 'RELATION BETWEEN res_partner AND calendar_event';


--
-- Name: calendar_event_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_event_type (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_event_type OWNER TO runbot;

--
-- Name: TABLE calendar_event_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_event_type IS 'Event Meeting Type';


--
-- Name: COLUMN calendar_event_type.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.color IS 'Color';


--
-- Name: COLUMN calendar_event_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_event_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_event_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.name IS 'Name';


--
-- Name: COLUMN calendar_event_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.create_date IS 'Created on';


--
-- Name: COLUMN calendar_event_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_event_type.write_date IS 'Last Updated on';


--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_event_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_event_type_id_seq OWNER TO runbot;

--
-- Name: calendar_event_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_event_type_id_seq OWNED BY public.calendar_event_type.id;


--
-- Name: calendar_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_filters (
    id integer NOT NULL,
    user_id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    partner_checked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_filters OWNER TO runbot;

--
-- Name: TABLE calendar_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_filters IS 'Calendar Filters';


--
-- Name: COLUMN calendar_filters.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.user_id IS 'Me';


--
-- Name: COLUMN calendar_filters.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_id IS 'Employee';


--
-- Name: COLUMN calendar_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.active IS 'Active';


--
-- Name: COLUMN calendar_filters.partner_checked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.partner_checked IS 'Checked';


--
-- Name: COLUMN calendar_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.create_date IS 'Created on';


--
-- Name: COLUMN calendar_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_filters.write_date IS 'Last Updated on';


--
-- Name: calendar_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_filters_id_seq OWNER TO runbot;

--
-- Name: calendar_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_filters_id_seq OWNED BY public.calendar_filters.id;


--
-- Name: calendar_popover_delete_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_popover_delete_wizard (
    id integer NOT NULL,
    template_id integer,
    calendar_event_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    delete character varying,
    body text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_popover_delete_wizard OWNER TO runbot;

--
-- Name: TABLE calendar_popover_delete_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_popover_delete_wizard IS 'Calendar Popover Delete Wizard';


--
-- Name: COLUMN calendar_popover_delete_wizard.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.template_id IS 'Mail Template';


--
-- Name: COLUMN calendar_popover_delete_wizard.calendar_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.calendar_event_id IS 'Calendar Event';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_popover_delete_wizard.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.lang IS 'Language';


--
-- Name: COLUMN calendar_popover_delete_wizard.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.subject IS 'Subject';


--
-- Name: COLUMN calendar_popover_delete_wizard.delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.delete IS 'Delete';


--
-- Name: COLUMN calendar_popover_delete_wizard.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.body IS 'Contents';


--
-- Name: COLUMN calendar_popover_delete_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.create_date IS 'Created on';


--
-- Name: COLUMN calendar_popover_delete_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_popover_delete_wizard.write_date IS 'Last Updated on';


--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_popover_delete_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNER TO runbot;

--
-- Name: calendar_popover_delete_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_popover_delete_wizard_id_seq OWNED BY public.calendar_popover_delete_wizard.id;


--
-- Name: calendar_provider_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_provider_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    external_calendar_provider character varying,
    cal_client_id character varying,
    cal_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    cal_sync_paused boolean,
    microsoft_outlook_sync_paused boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.calendar_provider_config OWNER TO runbot;

--
-- Name: TABLE calendar_provider_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_provider_config IS 'Calendar Provider Configuration Wizard';


--
-- Name: COLUMN calendar_provider_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_provider_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_provider_config.external_calendar_provider; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.external_calendar_provider IS 'Choose an external calendar to configure';


--
-- Name: COLUMN calendar_provider_config.cal_client_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_id IS 'Google Client_id';


--
-- Name: COLUMN calendar_provider_config.cal_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_client_secret IS 'Google Client_key';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN calendar_provider_config.cal_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.cal_sync_paused IS 'Google Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.microsoft_outlook_sync_paused; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.microsoft_outlook_sync_paused IS 'Outlook Synchronization Paused';


--
-- Name: COLUMN calendar_provider_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.create_date IS 'Created on';


--
-- Name: COLUMN calendar_provider_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_provider_config.write_date IS 'Last Updated on';


--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_provider_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_provider_config_id_seq OWNER TO runbot;

--
-- Name: calendar_provider_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_provider_config_id_seq OWNED BY public.calendar_provider_config.id;


--
-- Name: calendar_recurrence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.calendar_recurrence (
    id integer NOT NULL,
    base_event_id integer,
    "interval" integer,
    count integer,
    day integer,
    trigger_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    event_tz character varying,
    rrule character varying,
    rrule_type character varying,
    end_type character varying,
    month_by character varying,
    weekday character varying,
    byday character varying,
    until date,
    mon boolean,
    tue boolean,
    wed boolean,
    thu boolean,
    fri boolean,
    sat boolean,
    sun boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT calendar_recurrence_month_day CHECK ((((rrule_type)::text <> 'monthly'::text) OR ((month_by)::text <> 'day'::text) OR ((day >= 1) AND (day <= 31)) OR (((weekday)::text = ANY ((ARRAY['MON'::character varying, 'TUE'::character varying, 'WED'::character varying, 'THU'::character varying, 'FRI'::character varying, 'SAT'::character varying, 'SUN'::character varying])::text[])) AND ((byday)::text = ANY ((ARRAY['1'::character varying, '2'::character varying, '3'::character varying, '4'::character varying, '-1'::character varying])::text[])))))
);


ALTER TABLE public.calendar_recurrence OWNER TO runbot;

--
-- Name: TABLE calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.calendar_recurrence IS 'Event Recurrence Rule';


--
-- Name: COLUMN calendar_recurrence.base_event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.base_event_id IS 'Base Event';


--
-- Name: COLUMN calendar_recurrence."interval"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence."interval" IS 'Interval';


--
-- Name: COLUMN calendar_recurrence.count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.count IS 'Count';


--
-- Name: COLUMN calendar_recurrence.day; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.day IS 'Day';


--
-- Name: COLUMN calendar_recurrence.trigger_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.trigger_id IS 'Trigger';


--
-- Name: COLUMN calendar_recurrence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_uid IS 'Created by';


--
-- Name: COLUMN calendar_recurrence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN calendar_recurrence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.name IS 'Name';


--
-- Name: COLUMN calendar_recurrence.event_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.event_tz IS 'Timezone';


--
-- Name: COLUMN calendar_recurrence.rrule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule IS 'Rrule';


--
-- Name: COLUMN calendar_recurrence.rrule_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.rrule_type IS 'Rrule Type';


--
-- Name: COLUMN calendar_recurrence.end_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.end_type IS 'End Type';


--
-- Name: COLUMN calendar_recurrence.month_by; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.month_by IS 'Month By';


--
-- Name: COLUMN calendar_recurrence.weekday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.weekday IS 'Weekday';


--
-- Name: COLUMN calendar_recurrence.byday; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.byday IS 'By day';


--
-- Name: COLUMN calendar_recurrence.until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.until IS 'Repeat Until';


--
-- Name: COLUMN calendar_recurrence.mon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.mon IS 'Mon';


--
-- Name: COLUMN calendar_recurrence.tue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.tue IS 'Tue';


--
-- Name: COLUMN calendar_recurrence.wed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.wed IS 'Wed';


--
-- Name: COLUMN calendar_recurrence.thu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.thu IS 'Thu';


--
-- Name: COLUMN calendar_recurrence.fri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.fri IS 'Fri';


--
-- Name: COLUMN calendar_recurrence.sat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sat IS 'Sat';


--
-- Name: COLUMN calendar_recurrence.sun; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.sun IS 'Sun';


--
-- Name: COLUMN calendar_recurrence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.create_date IS 'Created on';


--
-- Name: COLUMN calendar_recurrence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.calendar_recurrence.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT calendar_recurrence_month_day ON calendar_recurrence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT calendar_recurrence_month_day ON public.calendar_recurrence IS 'CHECK (
        rrule_type != ''monthly''
        OR month_by != ''day''
        OR day >= 1 AND day <= 31
        OR weekday IN (''MON'', ''TUE'', ''WED'', ''THU'', ''FRI'', ''SAT'', ''SUN'') AND byday IN (''1'', ''2'', ''3'', ''4'', ''-1''))';


--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.calendar_recurrence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.calendar_recurrence_id_seq OWNER TO runbot;

--
-- Name: calendar_recurrence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.calendar_recurrence_id_seq OWNED BY public.calendar_recurrence.id;


--
-- Name: cashbox_journal_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.cashbox_journal_rel (
    cashbox_id integer NOT NULL,
    journal_id integer NOT NULL
);


ALTER TABLE public.cashbox_journal_rel OWNER TO runbot;

--
-- Name: TABLE cashbox_journal_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.cashbox_journal_rel IS 'RELATION BETWEEN account_cashbox AND account_journal';


--
-- Name: certificate_certificate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.certificate_certificate (
    id integer NOT NULL,
    private_key_id integer,
    public_key_id integer,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    pkcs12_password character varying,
    scope character varying,
    content_format character varying,
    subject_common_name character varying,
    serial_number character varying,
    loading_error text,
    active boolean,
    date_start timestamp without time zone,
    date_end timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    user_id integer,
    last_token character varying,
    last_rest_token character varying,
    subject_serial_number character varying,
    token_time timestamp without time zone,
    content_filename character varying
);


ALTER TABLE public.certificate_certificate OWNER TO runbot;

--
-- Name: TABLE certificate_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.certificate_certificate IS 'Certificate';


--
-- Name: COLUMN certificate_certificate.private_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.private_key_id IS 'Private Key';


--
-- Name: COLUMN certificate_certificate.public_key_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.public_key_id IS 'Public Key';


--
-- Name: COLUMN certificate_certificate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.company_id IS 'Company';


--
-- Name: COLUMN certificate_certificate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.create_uid IS 'Created by';


--
-- Name: COLUMN certificate_certificate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN certificate_certificate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.name IS 'Name';


--
-- Name: COLUMN certificate_certificate.pkcs12_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.pkcs12_password IS 'Certificate Password';


--
-- Name: COLUMN certificate_certificate.scope; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.scope IS 'Certificate scope';


--
-- Name: COLUMN certificate_certificate.content_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.content_format IS 'Original certificate format';


--
-- Name: COLUMN certificate_certificate.subject_common_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.subject_common_name IS 'Subject Name';


--
-- Name: COLUMN certificate_certificate.serial_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.serial_number IS 'Serial number';


--
-- Name: COLUMN certificate_certificate.loading_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.loading_error IS 'Loading error';


--
-- Name: COLUMN certificate_certificate.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.active IS 'Active';


--
-- Name: COLUMN certificate_certificate.date_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.date_start IS 'Available date';


--
-- Name: COLUMN certificate_certificate.date_end; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.date_end IS 'Expiration date';


--
-- Name: COLUMN certificate_certificate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.create_date IS 'Created on';


--
-- Name: COLUMN certificate_certificate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.write_date IS 'Last Updated on';


--
-- Name: COLUMN certificate_certificate.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.user_id IS 'Certificate Owner';


--
-- Name: COLUMN certificate_certificate.last_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.last_token IS 'Last Token';


--
-- Name: COLUMN certificate_certificate.last_rest_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.last_rest_token IS 'Last REST Token';


--
-- Name: COLUMN certificate_certificate.subject_serial_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.subject_serial_number IS 'Subject Serial Number';


--
-- Name: COLUMN certificate_certificate.token_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.token_time IS 'Token Time';


--
-- Name: COLUMN certificate_certificate.content_filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_certificate.content_filename IS 'Certificate Filename';


--
-- Name: certificate_certificate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.certificate_certificate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.certificate_certificate_id_seq OWNER TO runbot;

--
-- Name: certificate_certificate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.certificate_certificate_id_seq OWNED BY public.certificate_certificate.id;


--
-- Name: certificate_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.certificate_key (
    id integer NOT NULL,
    company_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    password character varying,
    loading_error text,
    public boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.certificate_key OWNER TO runbot;

--
-- Name: TABLE certificate_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.certificate_key IS 'Cryptographic Keys';


--
-- Name: COLUMN certificate_key.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.company_id IS 'Company';


--
-- Name: COLUMN certificate_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.create_uid IS 'Created by';


--
-- Name: COLUMN certificate_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN certificate_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.name IS 'Name';


--
-- Name: COLUMN certificate_key.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.password IS 'Private key password';


--
-- Name: COLUMN certificate_key.loading_error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.loading_error IS 'Loading error';


--
-- Name: COLUMN certificate_key.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.public IS 'Public/Private key';


--
-- Name: COLUMN certificate_key.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.active IS 'Active';


--
-- Name: COLUMN certificate_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.create_date IS 'Created on';


--
-- Name: COLUMN certificate_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.certificate_key.write_date IS 'Last Updated on';


--
-- Name: certificate_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.certificate_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.certificate_key_id_seq OWNER TO runbot;

--
-- Name: certificate_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.certificate_key_id_seq OWNED BY public.certificate_key.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: change_production_qty; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_production_qty (
    id integer NOT NULL,
    mo_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    product_qty numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_production_qty OWNER TO runbot;

--
-- Name: TABLE change_production_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_production_qty IS 'Change Production Qty';


--
-- Name: COLUMN change_production_qty.mo_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.mo_id IS 'Manufacturing Order';


--
-- Name: COLUMN change_production_qty.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.create_uid IS 'Created by';


--
-- Name: COLUMN change_production_qty.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_production_qty.product_qty; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.product_qty IS 'Quantity To Produce';


--
-- Name: COLUMN change_production_qty.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.create_date IS 'Created on';


--
-- Name: COLUMN change_production_qty.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_production_qty.write_date IS 'Last Updated on';


--
-- Name: change_production_qty_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_production_qty_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_production_qty_id_seq OWNER TO runbot;

--
-- Name: change_production_qty_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_production_qty_id_seq OWNED BY public.change_production_qty.id;


--
-- Name: choose_delivery_carrier; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.choose_delivery_carrier (
    id integer NOT NULL,
    order_id integer NOT NULL,
    carrier_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    weight_uom_name character varying,
    delivery_message text,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    delivery_price double precision,
    display_price double precision
);


ALTER TABLE public.choose_delivery_carrier OWNER TO runbot;

--
-- Name: TABLE choose_delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.choose_delivery_carrier IS 'Delivery Carrier Selection Wizard';


--
-- Name: COLUMN choose_delivery_carrier.order_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.order_id IS 'Order';


--
-- Name: COLUMN choose_delivery_carrier.carrier_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.carrier_id IS 'Shipping Method';


--
-- Name: COLUMN choose_delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN choose_delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN choose_delivery_carrier.weight_uom_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.weight_uom_name IS 'Weight Uom Name';


--
-- Name: COLUMN choose_delivery_carrier.delivery_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_message IS 'Delivery Message';


--
-- Name: COLUMN choose_delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN choose_delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: COLUMN choose_delivery_carrier.delivery_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.delivery_price IS 'Delivery Price';


--
-- Name: COLUMN choose_delivery_carrier.display_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.choose_delivery_carrier.display_price IS 'Cost';


--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.choose_delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.choose_delivery_carrier_id_seq OWNER TO runbot;

--
-- Name: choose_delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.choose_delivery_carrier_id_seq OWNED BY public.choose_delivery_carrier.id;


--
-- Name: confirm_stock_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.confirm_stock_sms (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.confirm_stock_sms OWNER TO runbot;

--
-- Name: TABLE confirm_stock_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.confirm_stock_sms IS 'Confirm Stock SMS';


--
-- Name: COLUMN confirm_stock_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_uid IS 'Created by';


--
-- Name: COLUMN confirm_stock_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN confirm_stock_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.create_date IS 'Created on';


--
-- Name: COLUMN confirm_stock_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.confirm_stock_sms.write_date IS 'Last Updated on';


--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.confirm_stock_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNER TO runbot;

--
-- Name: confirm_stock_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.confirm_stock_sms_id_seq OWNED BY public.confirm_stock_sms.id;


--
-- Name: coupon_share; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.coupon_share (
    id integer NOT NULL,
    website_id integer NOT NULL,
    coupon_id integer,
    program_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    redirect character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.coupon_share OWNER TO runbot;

--
-- Name: TABLE coupon_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.coupon_share IS 'Create links that apply a coupon and redirect to a specific page';


--
-- Name: COLUMN coupon_share.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.website_id IS 'Website';


--
-- Name: COLUMN coupon_share.coupon_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.coupon_id IS 'Coupon';


--
-- Name: COLUMN coupon_share.program_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.program_id IS 'Program';


--
-- Name: COLUMN coupon_share.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.create_uid IS 'Created by';


--
-- Name: COLUMN coupon_share.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.write_uid IS 'Last Updated by';


--
-- Name: COLUMN coupon_share.redirect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.redirect IS 'Redirect';


--
-- Name: COLUMN coupon_share.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.create_date IS 'Created on';


--
-- Name: COLUMN coupon_share.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.coupon_share.write_date IS 'Last Updated on';


--
-- Name: coupon_share_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.coupon_share_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.coupon_share_id_seq OWNER TO runbot;

--
-- Name: coupon_share_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.coupon_share_id_seq OWNED BY public.coupon_share.id;


--
-- Name: crm_lead; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead (
    id integer NOT NULL,
    campaign_id integer,
    source_id integer,
    medium_id integer,
    message_bounce integer,
    user_id integer,
    team_id integer,
    company_id integer,
    stage_id integer,
    color integer,
    recurring_plan integer,
    partner_id integer,
    lang_id integer,
    state_id integer,
    country_id integer,
    lost_reason_id integer,
    create_uid integer,
    write_uid integer,
    phone_sanitized character varying,
    email_normalized character varying,
    email_cc character varying,
    name character varying NOT NULL,
    referred character varying,
    type character varying NOT NULL,
    priority character varying,
    contact_name character varying,
    partner_name character varying,
    function character varying,
    email_from character varying,
    email_domain_criterion character varying,
    phone character varying,
    phone_state character varying,
    email_state character varying,
    website character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    won_status character varying,
    date_deadline date,
    lead_properties jsonb,
    description text,
    expected_revenue numeric,
    prorated_revenue numeric,
    recurring_revenue numeric,
    recurring_revenue_monthly numeric,
    recurring_revenue_monthly_prorated numeric,
    recurring_revenue_prorated numeric,
    active boolean,
    date_closed timestamp without time zone,
    date_automation_last timestamp without time zone,
    date_open timestamp without time zone,
    date_last_stage_update timestamp without time zone,
    date_conversion timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    day_open double precision,
    day_close double precision,
    probability double precision,
    automated_probability double precision,
    days_to_convert double precision,
    days_exceeding_closing double precision,
    event_lead_rule_id integer,
    event_id integer,
    reveal_id character varying,
    iap_enrich_done boolean,
    lead_mining_request_id integer,
    CONSTRAINT crm_lead_check_probability CHECK (((probability >= (0)::double precision) AND (probability <= (100)::double precision)))
);


ALTER TABLE public.crm_lead OWNER TO runbot;

--
-- Name: TABLE crm_lead; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead IS 'Lead';


--
-- Name: COLUMN crm_lead.campaign_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.campaign_id IS 'Campaign';


--
-- Name: COLUMN crm_lead.source_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.source_id IS 'Source';


--
-- Name: COLUMN crm_lead.medium_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.medium_id IS 'Medium';


--
-- Name: COLUMN crm_lead.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.message_bounce IS 'Bounce';


--
-- Name: COLUMN crm_lead.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.company_id IS 'Company';


--
-- Name: COLUMN crm_lead.stage_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.stage_id IS 'Stage';


--
-- Name: COLUMN crm_lead.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.color IS 'Color Index';


--
-- Name: COLUMN crm_lead.recurring_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_plan IS 'Recurring Plan';


--
-- Name: COLUMN crm_lead.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.partner_id IS 'Contact';


--
-- Name: COLUMN crm_lead.lang_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lang_id IS 'Language';


--
-- Name: COLUMN crm_lead.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.state_id IS 'State';


--
-- Name: COLUMN crm_lead.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.country_id IS 'Country';


--
-- Name: COLUMN crm_lead.lost_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lost_reason_id IS 'Lost Reason';


--
-- Name: COLUMN crm_lead.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead.phone_sanitized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN crm_lead.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN crm_lead.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_cc IS 'Email cc';


--
-- Name: COLUMN crm_lead.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.name IS 'Opportunity';


--
-- Name: COLUMN crm_lead.referred; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.referred IS 'Referred By';


--
-- Name: COLUMN crm_lead.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.type IS 'Type';


--
-- Name: COLUMN crm_lead.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.priority IS 'Priority';


--
-- Name: COLUMN crm_lead.contact_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.contact_name IS 'Contact Name';


--
-- Name: COLUMN crm_lead.partner_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.partner_name IS 'Company Name';


--
-- Name: COLUMN crm_lead.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.function IS 'Job Position';


--
-- Name: COLUMN crm_lead.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_from IS 'Email';


--
-- Name: COLUMN crm_lead.email_domain_criterion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_domain_criterion IS 'Email Domain Criterion';


--
-- Name: COLUMN crm_lead.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.phone IS 'Phone';


--
-- Name: COLUMN crm_lead.phone_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.phone_state IS 'Phone Quality';


--
-- Name: COLUMN crm_lead.email_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.email_state IS 'Email Quality';


--
-- Name: COLUMN crm_lead.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.website IS 'Website';


--
-- Name: COLUMN crm_lead.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.street IS 'Street';


--
-- Name: COLUMN crm_lead.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.street2 IS 'Street2';


--
-- Name: COLUMN crm_lead.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.zip IS 'Zip';


--
-- Name: COLUMN crm_lead.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.city IS 'City';


--
-- Name: COLUMN crm_lead.won_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.won_status IS 'Won/Lost';


--
-- Name: COLUMN crm_lead.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_deadline IS 'Expected Closing';


--
-- Name: COLUMN crm_lead.lead_properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lead_properties IS 'Properties';


--
-- Name: COLUMN crm_lead.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.description IS 'Notes';


--
-- Name: COLUMN crm_lead.expected_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.expected_revenue IS 'Expected Revenue';


--
-- Name: COLUMN crm_lead.prorated_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.prorated_revenue IS 'Prorated Revenue';


--
-- Name: COLUMN crm_lead.recurring_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue IS 'Recurring Revenues';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly IS 'Expected MRR';


--
-- Name: COLUMN crm_lead.recurring_revenue_monthly_prorated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_monthly_prorated IS 'Prorated MRR';


--
-- Name: COLUMN crm_lead.recurring_revenue_prorated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.recurring_revenue_prorated IS 'Prorated Recurring Revenues';


--
-- Name: COLUMN crm_lead.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.active IS 'Active';


--
-- Name: COLUMN crm_lead.date_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_closed IS 'Closed Date';


--
-- Name: COLUMN crm_lead.date_automation_last; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_automation_last IS 'Last Action';


--
-- Name: COLUMN crm_lead.date_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_open IS 'Assignment Date';


--
-- Name: COLUMN crm_lead.date_last_stage_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_last_stage_update IS 'Last Stage Update';


--
-- Name: COLUMN crm_lead.date_conversion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.date_conversion IS 'Conversion Date';


--
-- Name: COLUMN crm_lead.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_lead.day_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.day_open IS 'Days to Assign';


--
-- Name: COLUMN crm_lead.day_close; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.day_close IS 'Days to Close';


--
-- Name: COLUMN crm_lead.probability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.probability IS 'Probability';


--
-- Name: COLUMN crm_lead.automated_probability; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.automated_probability IS 'Automated Probability';


--
-- Name: COLUMN crm_lead.days_to_convert; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.days_to_convert IS 'Days To Convert';


--
-- Name: COLUMN crm_lead.days_exceeding_closing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.days_exceeding_closing IS 'Exceeded Closing Days';


--
-- Name: COLUMN crm_lead.event_lead_rule_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.event_lead_rule_id IS 'Registration Rule';


--
-- Name: COLUMN crm_lead.event_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.event_id IS 'Source Event';


--
-- Name: COLUMN crm_lead.reveal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.reveal_id IS 'Reveal ID';


--
-- Name: COLUMN crm_lead.iap_enrich_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.iap_enrich_done IS 'Enrichment done';


--
-- Name: COLUMN crm_lead.lead_mining_request_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead.lead_mining_request_id IS 'Lead Mining Request';


--
-- Name: CONSTRAINT crm_lead_check_probability ON crm_lead; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT crm_lead_check_probability ON public.crm_lead IS 'check(probability >= 0 and probability <= 100)';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    incoming_email_cc character varying,
    outgoing_email_to character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    incoming_email_to text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    pinned_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.incoming_email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_cc IS 'Emails Cc';


--
-- Name: COLUMN mail_message.outgoing_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.outgoing_email_to IS 'emails To';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.incoming_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_to IS 'Emails To';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.pinned_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.pinned_at IS 'Pinned';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: crm_activity_report; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.crm_activity_report AS
 SELECT m.id,
    l.create_date AS lead_create_date,
    l.date_conversion,
    l.date_deadline,
    l.date_closed,
    m.subtype_id,
    m.mail_activity_type_id,
    m.author_id,
    m.date,
    m.body,
    l.id AS lead_id,
    l.user_id,
    l.team_id,
    l.country_id,
    l.company_id,
    l.stage_id,
    l.partner_id,
    l.type AS lead_type,
    l.active,
    l.won_status
   FROM (public.mail_message m
     JOIN public.crm_lead l ON ((m.res_id = l.id)))
  WHERE (((m.model)::text = 'crm.lead'::text) AND (m.mail_activity_type_id IS NOT NULL));


ALTER VIEW public.crm_activity_report OWNER TO runbot;

--
-- Name: crm_convert_lead_mass_lead_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_convert_lead_mass_lead_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_convert_lead_mass_lead_rel OWNER TO runbot;

--
-- Name: TABLE crm_convert_lead_mass_lead_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_convert_lead_mass_lead_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND crm_lead';


--
-- Name: crm_iap_lead_helpers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_helpers (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_helpers OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_helpers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_helpers IS 'Helper methods for crm_iap_mine modules';


--
-- Name: COLUMN crm_iap_lead_helpers.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_helpers.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_helpers.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_helpers.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_helpers.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_helpers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_helpers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_helpers_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_helpers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_helpers_id_seq OWNED BY public.crm_iap_lead_helpers.id;


--
-- Name: crm_iap_lead_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_industry (
    id integer NOT NULL,
    color integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    reveal_ids character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_industry OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_industry IS 'CRM IAP Lead Industry';


--
-- Name: COLUMN crm_iap_lead_industry.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.color IS 'Color Index';


--
-- Name: COLUMN crm_iap_lead_industry.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.sequence IS 'Sequence';


--
-- Name: COLUMN crm_iap_lead_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_industry.reveal_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.reveal_ids IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.name IS 'Industry';


--
-- Name: COLUMN crm_iap_lead_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_industry.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_industry_crm_iap_lead_mining_request_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_iap_lead_industry_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_industry_crm_iap_lead_mining_request_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_industry_crm_iap_lead_mining_request_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_iap_lead_industry';


--
-- Name: crm_iap_lead_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_industry_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_industry_id_seq OWNED BY public.crm_iap_lead_industry.id;


--
-- Name: crm_iap_lead_mining_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request (
    id integer NOT NULL,
    lead_number integer NOT NULL,
    team_id integer,
    user_id integer,
    company_size_min integer,
    company_size_max integer,
    contact_number integer,
    preferred_role_id integer,
    seniority_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying NOT NULL,
    search_type character varying NOT NULL,
    error_type character varying,
    lead_type character varying NOT NULL,
    contact_filter_type character varying,
    filter_on_size boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_mining_request OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request IS 'CRM Lead Mining Request';


--
-- Name: COLUMN crm_iap_lead_mining_request.lead_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.lead_number IS 'Number of Leads';


--
-- Name: COLUMN crm_iap_lead_mining_request.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_iap_lead_mining_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_iap_lead_mining_request.company_size_min; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.company_size_min IS 'Size';


--
-- Name: COLUMN crm_iap_lead_mining_request.company_size_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.company_size_max IS 'Company Size Max';


--
-- Name: COLUMN crm_iap_lead_mining_request.contact_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.contact_number IS 'Number of Contacts';


--
-- Name: COLUMN crm_iap_lead_mining_request.preferred_role_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.preferred_role_id IS 'Preferred Role';


--
-- Name: COLUMN crm_iap_lead_mining_request.seniority_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.seniority_id IS 'Seniority';


--
-- Name: COLUMN crm_iap_lead_mining_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_mining_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_mining_request.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.name IS 'Request Number';


--
-- Name: COLUMN crm_iap_lead_mining_request.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.state IS 'Status';


--
-- Name: COLUMN crm_iap_lead_mining_request.search_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.search_type IS 'Target';


--
-- Name: COLUMN crm_iap_lead_mining_request.error_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.error_type IS 'Error Type';


--
-- Name: COLUMN crm_iap_lead_mining_request.lead_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.lead_type IS 'Type';


--
-- Name: COLUMN crm_iap_lead_mining_request.contact_filter_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.contact_filter_type IS 'Filter on';


--
-- Name: COLUMN crm_iap_lead_mining_request.filter_on_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.filter_on_size IS 'Filter on Size';


--
-- Name: COLUMN crm_iap_lead_mining_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_mining_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_mining_request.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_mining_request_crm_iap_lead_role_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_iap_lead_role_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_crm_iap_lead_role_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_crm_iap_lead_role_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_iap_lead_role';


--
-- Name: crm_iap_lead_mining_request_crm_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_crm_tag_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    crm_tag_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_crm_tag_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_crm_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_crm_tag_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND crm_tag';


--
-- Name: crm_iap_lead_mining_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_mining_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_mining_request_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_mining_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_mining_request_id_seq OWNED BY public.crm_iap_lead_mining_request.id;


--
-- Name: crm_iap_lead_mining_request_res_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_res_country_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    res_country_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_res_country_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_res_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_res_country_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND res_country';


--
-- Name: crm_iap_lead_mining_request_res_country_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_mining_request_res_country_state_rel (
    crm_iap_lead_mining_request_id integer NOT NULL,
    res_country_state_id integer NOT NULL
);


ALTER TABLE public.crm_iap_lead_mining_request_res_country_state_rel OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_mining_request_res_country_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_mining_request_res_country_state_rel IS 'RELATION BETWEEN crm_iap_lead_mining_request AND res_country_state';


--
-- Name: crm_iap_lead_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_role (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    reveal_id character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_role OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_role IS 'People Role';


--
-- Name: COLUMN crm_iap_lead_role.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.color IS 'Color Index';


--
-- Name: COLUMN crm_iap_lead_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_role.reveal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.reveal_id IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_role.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.name IS 'Role Name';


--
-- Name: COLUMN crm_iap_lead_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_role.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_role_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_role_id_seq OWNED BY public.crm_iap_lead_role.id;


--
-- Name: crm_iap_lead_seniority; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_iap_lead_seniority (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    reveal_id character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_iap_lead_seniority OWNER TO runbot;

--
-- Name: TABLE crm_iap_lead_seniority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_iap_lead_seniority IS 'People Seniority';


--
-- Name: COLUMN crm_iap_lead_seniority.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.create_uid IS 'Created by';


--
-- Name: COLUMN crm_iap_lead_seniority.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_iap_lead_seniority.reveal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.reveal_id IS 'Reveal';


--
-- Name: COLUMN crm_iap_lead_seniority.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.name IS 'Name';


--
-- Name: COLUMN crm_iap_lead_seniority.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.create_date IS 'Created on';


--
-- Name: COLUMN crm_iap_lead_seniority.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_iap_lead_seniority.write_date IS 'Last Updated on';


--
-- Name: crm_iap_lead_seniority_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_iap_lead_seniority_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_iap_lead_seniority_id_seq OWNER TO runbot;

--
-- Name: crm_iap_lead_seniority_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_iap_lead_seniority_id_seq OWNED BY public.crm_iap_lead_seniority.id;


--
-- Name: crm_lead2opportunity_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead2opportunity_partner (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    commercial_partner_id integer,
    partner_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    action character varying NOT NULL,
    force_assignment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead2opportunity_partner OWNER TO runbot;

--
-- Name: TABLE crm_lead2opportunity_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead2opportunity_partner IS 'Convert Lead to Opportunity (not in mass)';


--
-- Name: COLUMN crm_lead2opportunity_partner.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead2opportunity_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.commercial_partner_id IS 'Company';


--
-- Name: COLUMN crm_lead2opportunity_partner.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner.force_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.force_assignment IS 'Force assignment';


--
-- Name: COLUMN crm_lead2opportunity_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner.write_date IS 'Last Updated on';


--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead2opportunity_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead2opportunity_partner_id_seq OWNER TO runbot;

--
-- Name: crm_lead2opportunity_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead2opportunity_partner_id_seq OWNED BY public.crm_lead2opportunity_partner.id;


--
-- Name: crm_lead2opportunity_partner_mass; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead2opportunity_partner_mass (
    id integer NOT NULL,
    lead_id integer,
    commercial_partner_id integer,
    partner_id integer,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    action character varying NOT NULL,
    force_assignment boolean,
    deduplicate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead2opportunity_partner_mass OWNER TO runbot;

--
-- Name: TABLE crm_lead2opportunity_partner_mass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead2opportunity_partner_mass IS 'Convert Lead to Opportunity (in mass)';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.commercial_partner_id IS 'Company';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.name IS 'Conversion Action';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.action IS 'Related Customer';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.force_assignment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.force_assignment IS 'Force assignment';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.deduplicate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.deduplicate IS 'Apply deduplication';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead2opportunity_partner_mass.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead2opportunity_partner_mass.write_date IS 'Last Updated on';


--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq OWNER TO runbot;

--
-- Name: crm_lead2opportunity_partner_mass_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead2opportunity_partner_mass_id_seq OWNED BY public.crm_lead2opportunity_partner_mass.id;


--
-- Name: crm_lead2opportunity_partner_mass_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead2opportunity_partner_mass_res_users_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.crm_lead2opportunity_partner_mass_res_users_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead2opportunity_partner_mass_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead2opportunity_partner_mass_res_users_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND res_users';


--
-- Name: crm_lead_convert2ticket; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_convert2ticket (
    id integer NOT NULL,
    lead_id integer,
    partner_id integer,
    team_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_convert2ticket OWNER TO runbot;

--
-- Name: TABLE crm_lead_convert2ticket; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_convert2ticket IS 'Lead convert to Ticket';


--
-- Name: COLUMN crm_lead_convert2ticket.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.lead_id IS 'Lead';


--
-- Name: COLUMN crm_lead_convert2ticket.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead_convert2ticket.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.team_id IS 'Team';


--
-- Name: COLUMN crm_lead_convert2ticket.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_convert2ticket.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_convert2ticket.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_convert2ticket.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_convert2ticket.write_date IS 'Last Updated on';


--
-- Name: crm_lead_convert2ticket_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_convert2ticket_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_convert2ticket_id_seq OWNER TO runbot;

--
-- Name: crm_lead_convert2ticket_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_convert2ticket_id_seq OWNED BY public.crm_lead_convert2ticket.id;


--
-- Name: crm_lead_crm_lead2opportunity_partner_mass_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel (
    crm_lead2opportunity_partner_mass_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_mass_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_crm_lead2opportunity_partner_mass_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner_mass AND crm_lead';


--
-- Name: crm_lead_crm_lead2opportunity_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_crm_lead2opportunity_partner_rel (
    crm_lead2opportunity_partner_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_crm_lead2opportunity_partner_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_crm_lead2opportunity_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_crm_lead2opportunity_partner_rel IS 'RELATION BETWEEN crm_lead2opportunity_partner AND crm_lead';


--
-- Name: crm_lead_crm_lead_lost_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_crm_lead_lost_rel (
    crm_lead_lost_id integer NOT NULL,
    crm_lead_id integer NOT NULL
);


ALTER TABLE public.crm_lead_crm_lead_lost_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_crm_lead_lost_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_crm_lead_lost_rel IS 'RELATION BETWEEN crm_lead_lost AND crm_lead';


--
-- Name: crm_lead_event_registration_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_event_registration_rel (
    crm_lead_id integer NOT NULL,
    event_registration_id integer NOT NULL
);


ALTER TABLE public.crm_lead_event_registration_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_event_registration_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_event_registration_rel IS 'RELATION BETWEEN crm_lead AND event_registration';


--
-- Name: crm_lead_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_id_seq OWNER TO runbot;

--
-- Name: crm_lead_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_id_seq OWNED BY public.crm_lead.id;


--
-- Name: crm_lead_lost; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_lost (
    id integer NOT NULL,
    lost_reason_id integer,
    create_uid integer,
    write_uid integer,
    lost_feedback text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_lost OWNER TO runbot;

--
-- Name: TABLE crm_lead_lost; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_lost IS 'Get Lost Reason';


--
-- Name: COLUMN crm_lead_lost.lost_reason_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.lost_reason_id IS 'Lost Reason';


--
-- Name: COLUMN crm_lead_lost.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_lost.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_lost.lost_feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.lost_feedback IS 'Closing Note';


--
-- Name: COLUMN crm_lead_lost.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_lost.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_lost.write_date IS 'Last Updated on';


--
-- Name: crm_lead_lost_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_lost_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_lost_id_seq OWNER TO runbot;

--
-- Name: crm_lead_lost_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_lost_id_seq OWNED BY public.crm_lead_lost.id;


--
-- Name: crm_lead_pls_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_pls_update (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    pls_start_date date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_pls_update OWNER TO runbot;

--
-- Name: TABLE crm_lead_pls_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_pls_update IS 'Update the probabilities';


--
-- Name: COLUMN crm_lead_pls_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_pls_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_pls_update.pls_start_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.pls_start_date IS 'Pls Start Date';


--
-- Name: COLUMN crm_lead_pls_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_pls_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_pls_update.write_date IS 'Last Updated on';


--
-- Name: crm_lead_pls_update_crm_lead_scoring_frequency_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel (
    crm_lead_pls_update_id integer NOT NULL,
    crm_lead_scoring_frequency_field_id integer NOT NULL
);


ALTER TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_pls_update_crm_lead_scoring_frequency_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_pls_update_crm_lead_scoring_frequency_field_rel IS 'RELATION BETWEEN crm_lead_pls_update AND crm_lead_scoring_frequency_field';


--
-- Name: crm_lead_pls_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_pls_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_pls_update_id_seq OWNER TO runbot;

--
-- Name: crm_lead_pls_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_pls_update_id_seq OWNED BY public.crm_lead_pls_update.id;


--
-- Name: crm_lead_rental; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_rental (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_rental OWNER TO runbot;

--
-- Name: TABLE crm_lead_rental; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_rental IS 'Convert Lead to Rental Order';


--
-- Name: COLUMN crm_lead_rental.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_lead_rental.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.partner_id IS 'Customer';


--
-- Name: COLUMN crm_lead_rental.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_rental.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_rental.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.action IS 'Rental Customer';


--
-- Name: COLUMN crm_lead_rental.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_rental.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_rental.write_date IS 'Last Updated on';


--
-- Name: crm_lead_rental_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_rental_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_rental_id_seq OWNER TO runbot;

--
-- Name: crm_lead_rental_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_rental_id_seq OWNED BY public.crm_lead_rental.id;


--
-- Name: crm_lead_scoring_frequency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_scoring_frequency (
    id integer NOT NULL,
    team_id integer,
    create_uid integer,
    write_uid integer,
    variable character varying,
    value character varying,
    won_count numeric,
    lost_count numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_scoring_frequency OWNER TO runbot;

--
-- Name: TABLE crm_lead_scoring_frequency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_scoring_frequency IS 'Lead Scoring Frequency';


--
-- Name: COLUMN crm_lead_scoring_frequency.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_lead_scoring_frequency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_scoring_frequency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_scoring_frequency.variable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.variable IS 'Variable';


--
-- Name: COLUMN crm_lead_scoring_frequency.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.value IS 'Value';


--
-- Name: COLUMN crm_lead_scoring_frequency.won_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.won_count IS 'Won Count';


--
-- Name: COLUMN crm_lead_scoring_frequency.lost_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.lost_count IS 'Lost Count';


--
-- Name: COLUMN crm_lead_scoring_frequency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_scoring_frequency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency.write_date IS 'Last Updated on';


--
-- Name: crm_lead_scoring_frequency_field; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_scoring_frequency_field (
    id integer NOT NULL,
    field_id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lead_scoring_frequency_field OWNER TO runbot;

--
-- Name: TABLE crm_lead_scoring_frequency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_scoring_frequency_field IS 'Fields that can be used for predictive lead scoring computation';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.field_id IS 'Field';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.color IS 'Color';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.create_date IS 'Created on';


--
-- Name: COLUMN crm_lead_scoring_frequency_field.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lead_scoring_frequency_field.write_date IS 'Last Updated on';


--
-- Name: crm_lead_scoring_frequency_field_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_scoring_frequency_field_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_scoring_frequency_field_id_seq OWNER TO runbot;

--
-- Name: crm_lead_scoring_frequency_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_scoring_frequency_field_id_seq OWNED BY public.crm_lead_scoring_frequency_field.id;


--
-- Name: crm_lead_scoring_frequency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lead_scoring_frequency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lead_scoring_frequency_id_seq OWNER TO runbot;

--
-- Name: crm_lead_scoring_frequency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lead_scoring_frequency_id_seq OWNED BY public.crm_lead_scoring_frequency.id;


--
-- Name: crm_lead_website_visitor_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lead_website_visitor_rel (
    crm_lead_id integer NOT NULL,
    website_visitor_id integer NOT NULL
);


ALTER TABLE public.crm_lead_website_visitor_rel OWNER TO runbot;

--
-- Name: TABLE crm_lead_website_visitor_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lead_website_visitor_rel IS 'RELATION BETWEEN crm_lead AND website_visitor';


--
-- Name: crm_lost_reason; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_lost_reason (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_lost_reason OWNER TO runbot;

--
-- Name: TABLE crm_lost_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_lost_reason IS 'Opp. Lost Reason';


--
-- Name: COLUMN crm_lost_reason.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.create_uid IS 'Created by';


--
-- Name: COLUMN crm_lost_reason.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_lost_reason.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.name IS 'Description';


--
-- Name: COLUMN crm_lost_reason.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.active IS 'Active';


--
-- Name: COLUMN crm_lost_reason.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.create_date IS 'Created on';


--
-- Name: COLUMN crm_lost_reason.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_lost_reason.write_date IS 'Last Updated on';


--
-- Name: crm_lost_reason_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_lost_reason_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_lost_reason_id_seq OWNER TO runbot;

--
-- Name: crm_lost_reason_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_lost_reason_id_seq OWNED BY public.crm_lost_reason.id;


--
-- Name: crm_merge_opportunity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_merge_opportunity (
    id integer NOT NULL,
    user_id integer,
    team_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_merge_opportunity OWNER TO runbot;

--
-- Name: TABLE crm_merge_opportunity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_merge_opportunity IS 'Merge Opportunities';


--
-- Name: COLUMN crm_merge_opportunity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_merge_opportunity.team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.team_id IS 'Sales Team';


--
-- Name: COLUMN crm_merge_opportunity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.create_uid IS 'Created by';


--
-- Name: COLUMN crm_merge_opportunity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_merge_opportunity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.create_date IS 'Created on';


--
-- Name: COLUMN crm_merge_opportunity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_merge_opportunity.write_date IS 'Last Updated on';


--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_merge_opportunity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_merge_opportunity_id_seq OWNER TO runbot;

--
-- Name: crm_merge_opportunity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_merge_opportunity_id_seq OWNED BY public.crm_merge_opportunity.id;


--
-- Name: crm_quotation_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_quotation_partner (
    id integer NOT NULL,
    lead_id integer NOT NULL,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    action character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_quotation_partner OWNER TO runbot;

--
-- Name: TABLE crm_quotation_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_quotation_partner IS 'Create new or use existing Customer on new Quotation';


--
-- Name: COLUMN crm_quotation_partner.lead_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.lead_id IS 'Associated Lead';


--
-- Name: COLUMN crm_quotation_partner.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.partner_id IS 'Customer';


--
-- Name: COLUMN crm_quotation_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.create_uid IS 'Created by';


--
-- Name: COLUMN crm_quotation_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_quotation_partner.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.action IS 'Quotation Customer';


--
-- Name: COLUMN crm_quotation_partner.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.create_date IS 'Created on';


--
-- Name: COLUMN crm_quotation_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_quotation_partner.write_date IS 'Last Updated on';


--
-- Name: crm_quotation_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_quotation_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_quotation_partner_id_seq OWNER TO runbot;

--
-- Name: crm_quotation_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_quotation_partner_id_seq OWNED BY public.crm_quotation_partner.id;


--
-- Name: crm_recurring_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_recurring_plan (
    id integer NOT NULL,
    number_of_months integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT crm_recurring_plan_check_number_of_months CHECK ((number_of_months >= 0))
);


ALTER TABLE public.crm_recurring_plan OWNER TO runbot;

--
-- Name: TABLE crm_recurring_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_recurring_plan IS 'CRM Recurring revenue plans';


--
-- Name: COLUMN crm_recurring_plan.number_of_months; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.number_of_months IS '# Months';


--
-- Name: COLUMN crm_recurring_plan.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.sequence IS 'Sequence';


--
-- Name: COLUMN crm_recurring_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.create_uid IS 'Created by';


--
-- Name: COLUMN crm_recurring_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_recurring_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.name IS 'Plan Name';


--
-- Name: COLUMN crm_recurring_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.active IS 'Active';


--
-- Name: COLUMN crm_recurring_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.create_date IS 'Created on';


--
-- Name: COLUMN crm_recurring_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_recurring_plan.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT crm_recurring_plan_check_number_of_months ON crm_recurring_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT crm_recurring_plan_check_number_of_months ON public.crm_recurring_plan IS 'CHECK(number_of_months >= 0)';


--
-- Name: crm_recurring_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_recurring_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_recurring_plan_id_seq OWNER TO runbot;

--
-- Name: crm_recurring_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_recurring_plan_id_seq OWNED BY public.crm_recurring_plan.id;


--
-- Name: crm_stage; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_stage (
    id integer NOT NULL,
    sequence integer,
    rotting_threshold_days integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    requirements text,
    is_won boolean,
    fold boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_stage OWNER TO runbot;

--
-- Name: TABLE crm_stage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_stage IS 'CRM Stages';


--
-- Name: COLUMN crm_stage.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.sequence IS 'Sequence';


--
-- Name: COLUMN crm_stage.rotting_threshold_days; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.rotting_threshold_days IS 'Days to rot';


--
-- Name: COLUMN crm_stage.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.color IS 'Color';


--
-- Name: COLUMN crm_stage.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.create_uid IS 'Created by';


--
-- Name: COLUMN crm_stage.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_stage.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.name IS 'Stage Name';


--
-- Name: COLUMN crm_stage.requirements; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.requirements IS 'Requirements';


--
-- Name: COLUMN crm_stage.is_won; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.is_won IS 'Is Won Stage?';


--
-- Name: COLUMN crm_stage.fold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.fold IS 'Folded in Pipeline';


--
-- Name: COLUMN crm_stage.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.create_date IS 'Created on';


--
-- Name: COLUMN crm_stage.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_stage.write_date IS 'Last Updated on';


--
-- Name: crm_stage_crm_team_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_stage_crm_team_rel (
    crm_stage_id integer NOT NULL,
    crm_team_id integer NOT NULL
);


ALTER TABLE public.crm_stage_crm_team_rel OWNER TO runbot;

--
-- Name: TABLE crm_stage_crm_team_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_stage_crm_team_rel IS 'RELATION BETWEEN crm_stage AND crm_team';


--
-- Name: crm_stage_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_stage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_stage_id_seq OWNER TO runbot;

--
-- Name: crm_stage_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_stage_id_seq OWNED BY public.crm_stage.id;


--
-- Name: crm_tag; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag (
    id integer NOT NULL,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.crm_tag OWNER TO runbot;

--
-- Name: TABLE crm_tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag IS 'CRM Tag';


--
-- Name: COLUMN crm_tag.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.color IS 'Color';


--
-- Name: COLUMN crm_tag.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_uid IS 'Created by';


--
-- Name: COLUMN crm_tag.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_tag.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.name IS 'Tag Name';


--
-- Name: COLUMN crm_tag.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.create_date IS 'Created on';


--
-- Name: COLUMN crm_tag.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_tag.write_date IS 'Last Updated on';


--
-- Name: crm_tag_event_lead_rule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag_event_lead_rule_rel (
    event_lead_rule_id integer NOT NULL,
    crm_tag_id integer NOT NULL
);


ALTER TABLE public.crm_tag_event_lead_rule_rel OWNER TO runbot;

--
-- Name: TABLE crm_tag_event_lead_rule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag_event_lead_rule_rel IS 'RELATION BETWEEN event_lead_rule AND crm_tag';


--
-- Name: crm_tag_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_tag_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_tag_id_seq OWNER TO runbot;

--
-- Name: crm_tag_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_tag_id_seq OWNED BY public.crm_tag.id;


--
-- Name: crm_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_tag_rel (
    lead_id integer NOT NULL,
    tag_id integer NOT NULL
);


ALTER TABLE public.crm_tag_rel OWNER TO runbot;

--
-- Name: TABLE crm_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_tag_rel IS 'RELATION BETWEEN crm_lead AND crm_tag';


--
-- Name: crm_team; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    user_id integer,
    color integer,
    create_uid integer,
    write_uid integer,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    alias_id integer NOT NULL,
    assignment_domain character varying,
    lead_properties_definition jsonb,
    use_leads boolean,
    use_opportunities boolean,
    assignment_optout boolean,
    invoiced_target double precision
);


ALTER TABLE public.crm_team OWNER TO runbot;

--
-- Name: TABLE crm_team; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team IS 'Sales Team';


--
-- Name: COLUMN crm_team.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.sequence IS 'Sequence';


--
-- Name: COLUMN crm_team.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.company_id IS 'Company';


--
-- Name: COLUMN crm_team.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.user_id IS 'Team Leader';


--
-- Name: COLUMN crm_team.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.color IS 'Color Index';


--
-- Name: COLUMN crm_team.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.name IS 'Sales Team';


--
-- Name: COLUMN crm_team.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.active IS 'Active';


--
-- Name: COLUMN crm_team.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.create_date IS 'Created on';


--
-- Name: COLUMN crm_team.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.alias_id IS 'Alias';


--
-- Name: COLUMN crm_team.assignment_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.assignment_domain IS 'Assignment Domain';


--
-- Name: COLUMN crm_team.lead_properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.lead_properties_definition IS 'Lead Properties';


--
-- Name: COLUMN crm_team.use_leads; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.use_leads IS 'Leads';


--
-- Name: COLUMN crm_team.use_opportunities; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.use_opportunities IS 'Pipeline';


--
-- Name: COLUMN crm_team.assignment_optout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.assignment_optout IS 'Skip auto assignment';


--
-- Name: COLUMN crm_team.invoiced_target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team.invoiced_target IS 'Invoicing Target';


--
-- Name: crm_team_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_id_seq OWNER TO runbot;

--
-- Name: crm_team_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_id_seq OWNED BY public.crm_team.id;


--
-- Name: crm_team_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.crm_team_member (
    id integer NOT NULL,
    crm_team_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    assignment_max integer,
    assignment_domain character varying,
    assignment_domain_preferred character varying,
    assignment_optout boolean
);


ALTER TABLE public.crm_team_member OWNER TO runbot;

--
-- Name: TABLE crm_team_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.crm_team_member IS 'Sales Team Member';


--
-- Name: COLUMN crm_team_member.crm_team_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.crm_team_id IS 'Sales Team';


--
-- Name: COLUMN crm_team_member.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.user_id IS 'Salesperson';


--
-- Name: COLUMN crm_team_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_uid IS 'Created by';


--
-- Name: COLUMN crm_team_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN crm_team_member.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.active IS 'Active';


--
-- Name: COLUMN crm_team_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.create_date IS 'Created on';


--
-- Name: COLUMN crm_team_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.write_date IS 'Last Updated on';


--
-- Name: COLUMN crm_team_member.assignment_max; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_max IS 'Average Leads Capacity (on 30 days)';


--
-- Name: COLUMN crm_team_member.assignment_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_domain IS 'Assignment Domain';


--
-- Name: COLUMN crm_team_member.assignment_domain_preferred; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_domain_preferred IS 'Preference assignment Domain';


--
-- Name: COLUMN crm_team_member.assignment_optout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.crm_team_member.assignment_optout IS 'Pause assignment';


--
-- Name: crm_team_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.crm_team_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.crm_team_member_id_seq OWNER TO runbot;

--
-- Name: crm_team_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.crm_team_member_id_seq OWNED BY public.crm_team_member.id;


--
-- Name: currency_rate_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.currency_rate_wizard (
    id integer NOT NULL,
    selected_consolidation_company integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.currency_rate_wizard OWNER TO runbot;

--
-- Name: TABLE currency_rate_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.currency_rate_wizard IS 'Currency Rate Wizard';


--
-- Name: COLUMN currency_rate_wizard.selected_consolidation_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_rate_wizard.selected_consolidation_company IS 'Selected Consolidation Company';


--
-- Name: COLUMN currency_rate_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_rate_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN currency_rate_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_rate_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN currency_rate_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_rate_wizard.create_date IS 'Created on';


--
-- Name: COLUMN currency_rate_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.currency_rate_wizard.write_date IS 'Last Updated on';


--
-- Name: currency_rate_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.currency_rate_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.currency_rate_wizard_id_seq OWNER TO runbot;

--
-- Name: currency_rate_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.currency_rate_wizard_id_seq OWNED BY public.currency_rate_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: delivery_carrier; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier (
    id integer NOT NULL,
    sequence integer,
    company_id integer,
    product_id integer NOT NULL,
    shipping_insurance integer,
    create_uid integer,
    write_uid integer,
    delivery_type character varying NOT NULL,
    integration_level character varying,
    tracking_url character varying,
    invoice_policy character varying NOT NULL,
    name jsonb NOT NULL,
    carrier_description jsonb,
    active boolean,
    allow_cash_on_delivery boolean,
    prod_environment boolean,
    debug_logging boolean,
    free_over boolean,
    return_label_on_delivery boolean,
    get_return_label_from_portal boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_weight double precision,
    max_volume double precision,
    margin double precision,
    fixed_margin double precision,
    amount double precision,
    fixed_price double precision,
    partner_id integer,
    website_id integer,
    is_published boolean,
    CONSTRAINT delivery_carrier_margin_not_under_100_percent CHECK ((margin >= ('-1'::integer)::double precision)),
    CONSTRAINT delivery_carrier_shipping_insurance_is_percentage CHECK (((shipping_insurance >= 0) AND (shipping_insurance <= 100)))
);


ALTER TABLE public.delivery_carrier OWNER TO runbot;

--
-- Name: TABLE delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier IS 'Shipping Methods';


--
-- Name: COLUMN delivery_carrier.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_carrier.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.company_id IS 'Company';


--
-- Name: COLUMN delivery_carrier.product_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.product_id IS 'Delivery Product';


--
-- Name: COLUMN delivery_carrier.shipping_insurance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.shipping_insurance IS 'Insurance Percentage';


--
-- Name: COLUMN delivery_carrier.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_carrier.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_carrier.delivery_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.delivery_type IS 'Provider';


--
-- Name: COLUMN delivery_carrier.integration_level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.integration_level IS 'Integration Level';


--
-- Name: COLUMN delivery_carrier.tracking_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.tracking_url IS 'Tracking Link';


--
-- Name: COLUMN delivery_carrier.invoice_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.invoice_policy IS 'Invoicing Policy';


--
-- Name: COLUMN delivery_carrier.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.name IS 'Delivery Method';


--
-- Name: COLUMN delivery_carrier.carrier_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.carrier_description IS 'Carrier Description';


--
-- Name: COLUMN delivery_carrier.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.active IS 'Active';


--
-- Name: COLUMN delivery_carrier.allow_cash_on_delivery; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.allow_cash_on_delivery IS 'Cash on Delivery';


--
-- Name: COLUMN delivery_carrier.prod_environment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.prod_environment IS 'Environment';


--
-- Name: COLUMN delivery_carrier.debug_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.debug_logging IS 'Debug logging';


--
-- Name: COLUMN delivery_carrier.free_over; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.free_over IS 'Free if order amount is above';


--
-- Name: COLUMN delivery_carrier.return_label_on_delivery; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.return_label_on_delivery IS 'Generate Return Label';


--
-- Name: COLUMN delivery_carrier.get_return_label_from_portal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.get_return_label_from_portal IS 'Return Label Accessible from Customer Portal';


--
-- Name: COLUMN delivery_carrier.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.create_date IS 'Created on';


--
-- Name: COLUMN delivery_carrier.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.write_date IS 'Last Updated on';


--
-- Name: COLUMN delivery_carrier.max_weight; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.max_weight IS 'Max Weight';


--
-- Name: COLUMN delivery_carrier.max_volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.max_volume IS 'Max Volume';


--
-- Name: COLUMN delivery_carrier.margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.margin IS 'Margin';


--
-- Name: COLUMN delivery_carrier.fixed_margin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.fixed_margin IS 'Fixed Margin';


--
-- Name: COLUMN delivery_carrier.amount; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.amount IS 'Amount';


--
-- Name: COLUMN delivery_carrier.fixed_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.fixed_price IS 'Fixed Price';


--
-- Name: COLUMN delivery_carrier.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.partner_id IS 'Carrier Address';


--
-- Name: COLUMN delivery_carrier.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.website_id IS 'Website';


--
-- Name: COLUMN delivery_carrier.is_published; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_carrier.is_published IS 'Is Published';


--
-- Name: CONSTRAINT delivery_carrier_margin_not_under_100_percent ON delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT delivery_carrier_margin_not_under_100_percent ON public.delivery_carrier IS 'CHECK (margin >= -1)';


--
-- Name: CONSTRAINT delivery_carrier_shipping_insurance_is_percentage ON delivery_carrier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT delivery_carrier_shipping_insurance_is_percentage ON public.delivery_carrier IS 'CHECK(shipping_insurance >= 0 AND shipping_insurance <= 100)';


--
-- Name: delivery_carrier_country_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier_country_rel (
    carrier_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.delivery_carrier_country_rel OWNER TO runbot;

--
-- Name: TABLE delivery_carrier_country_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier_country_rel IS 'RELATION BETWEEN delivery_carrier AND res_country';


--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_carrier_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_carrier_id_seq OWNER TO runbot;

--
-- Name: delivery_carrier_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_carrier_id_seq OWNED BY public.delivery_carrier.id;


--
-- Name: delivery_carrier_state_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_carrier_state_rel (
    carrier_id integer NOT NULL,
    state_id integer NOT NULL
);


ALTER TABLE public.delivery_carrier_state_rel OWNER TO runbot;

--
-- Name: TABLE delivery_carrier_state_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_carrier_state_rel IS 'RELATION BETWEEN delivery_carrier AND res_country_state';


--
-- Name: delivery_price_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_price_rule (
    id integer NOT NULL,
    sequence integer NOT NULL,
    carrier_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    variable character varying NOT NULL,
    operator character varying NOT NULL,
    variable_factor character varying NOT NULL,
    list_base_price numeric NOT NULL,
    list_price numeric NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_value double precision NOT NULL
);


ALTER TABLE public.delivery_price_rule OWNER TO runbot;

--
-- Name: TABLE delivery_price_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_price_rule IS 'Delivery Price Rules';


--
-- Name: COLUMN delivery_price_rule.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.sequence IS 'Sequence';


--
-- Name: COLUMN delivery_price_rule.carrier_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.carrier_id IS 'Carrier';


--
-- Name: COLUMN delivery_price_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_price_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_price_rule.variable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.variable IS 'Variable';


--
-- Name: COLUMN delivery_price_rule.operator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.operator IS 'Operator';


--
-- Name: COLUMN delivery_price_rule.variable_factor; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.variable_factor IS 'Variable Factor';


--
-- Name: COLUMN delivery_price_rule.list_base_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.list_base_price IS 'Sale Base Price';


--
-- Name: COLUMN delivery_price_rule.list_price; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.list_price IS 'Sale Price';


--
-- Name: COLUMN delivery_price_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.create_date IS 'Created on';


--
-- Name: COLUMN delivery_price_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.write_date IS 'Last Updated on';


--
-- Name: COLUMN delivery_price_rule.max_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_price_rule.max_value IS 'Maximum Value';


--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_price_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_price_rule_id_seq OWNER TO runbot;

--
-- Name: delivery_price_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_price_rule_id_seq OWNED BY public.delivery_price_rule.id;


--
-- Name: delivery_zip_prefix; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_zip_prefix (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.delivery_zip_prefix OWNER TO runbot;

--
-- Name: TABLE delivery_zip_prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_zip_prefix IS 'Delivery Zip Prefix';


--
-- Name: COLUMN delivery_zip_prefix.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.create_uid IS 'Created by';


--
-- Name: COLUMN delivery_zip_prefix.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.write_uid IS 'Last Updated by';


--
-- Name: COLUMN delivery_zip_prefix.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.name IS 'Prefix';


--
-- Name: COLUMN delivery_zip_prefix.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.create_date IS 'Created on';


--
-- Name: COLUMN delivery_zip_prefix.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.delivery_zip_prefix.write_date IS 'Last Updated on';


--
-- Name: delivery_zip_prefix_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.delivery_zip_prefix_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.delivery_zip_prefix_id_seq OWNER TO runbot;

--
-- Name: delivery_zip_prefix_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.delivery_zip_prefix_id_seq OWNED BY public.delivery_zip_prefix.id;


--
-- Name: delivery_zip_prefix_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.delivery_zip_prefix_rel (
    carrier_id integer NOT NULL,
    zip_prefix_id integer NOT NULL
);


ALTER TABLE public.delivery_zip_prefix_rel OWNER TO runbot;

--
-- Name: TABLE delivery_zip_prefix_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.delivery_zip_prefix_rel IS 'RELATION BETWEEN delivery_carrier AND delivery_zip_prefix';


--
-- Name: digest_digest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest (
    id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    periodicity character varying NOT NULL,
    state character varying,
    next_run_date date,
    name jsonb NOT NULL,
    kpi_res_users_connected boolean,
    kpi_mail_message_total boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    kpi_account_total_revenue boolean,
    kpi_crm_lead_created boolean,
    kpi_crm_opportunities_won boolean,
    kpi_helpdesk_tickets_closed boolean,
    kpi_project_task_opened boolean,
    kpi_account_bank_cash boolean,
    kpi_hr_recruitment_new_colleagues boolean,
    kpi_pos_total boolean,
    kpi_all_sale_total boolean,
    kpi_website_sale_total boolean
);


ALTER TABLE public.digest_digest OWNER TO runbot;

--
-- Name: TABLE digest_digest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest IS 'Digest';


--
-- Name: COLUMN digest_digest.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.company_id IS 'Company';


--
-- Name: COLUMN digest_digest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_uid IS 'Created by';


--
-- Name: COLUMN digest_digest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_digest.periodicity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.periodicity IS 'Periodicity';


--
-- Name: COLUMN digest_digest.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.state IS 'Status';


--
-- Name: COLUMN digest_digest.next_run_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.next_run_date IS 'Next Mailing Date';


--
-- Name: COLUMN digest_digest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.name IS 'Name';


--
-- Name: COLUMN digest_digest.kpi_res_users_connected; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_res_users_connected IS 'Connected Users';


--
-- Name: COLUMN digest_digest.kpi_mail_message_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_mail_message_total IS 'Messages Sent';


--
-- Name: COLUMN digest_digest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.create_date IS 'Created on';


--
-- Name: COLUMN digest_digest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.write_date IS 'Last Updated on';


--
-- Name: COLUMN digest_digest.kpi_account_total_revenue; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_total_revenue IS 'Revenue';


--
-- Name: COLUMN digest_digest.kpi_crm_lead_created; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_crm_lead_created IS 'New Leads';


--
-- Name: COLUMN digest_digest.kpi_crm_opportunities_won; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_crm_opportunities_won IS 'Opportunities Won';


--
-- Name: COLUMN digest_digest.kpi_helpdesk_tickets_closed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_helpdesk_tickets_closed IS 'Tickets Closed';


--
-- Name: COLUMN digest_digest.kpi_project_task_opened; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_project_task_opened IS 'Open Tasks';


--
-- Name: COLUMN digest_digest.kpi_account_bank_cash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_account_bank_cash IS 'Bank & Cash Moves';


--
-- Name: COLUMN digest_digest.kpi_hr_recruitment_new_colleagues; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_hr_recruitment_new_colleagues IS 'New Employees';


--
-- Name: COLUMN digest_digest.kpi_pos_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_pos_total IS 'POS Sales';


--
-- Name: COLUMN digest_digest.kpi_all_sale_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_all_sale_total IS 'All Sales';


--
-- Name: COLUMN digest_digest.kpi_website_sale_total; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_digest.kpi_website_sale_total IS 'eCommerce Sales';


--
-- Name: digest_digest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_digest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_digest_id_seq OWNER TO runbot;

--
-- Name: digest_digest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_digest_id_seq OWNED BY public.digest_digest.id;


--
-- Name: digest_digest_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_digest_res_users_rel (
    digest_digest_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_digest_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_digest_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_digest_res_users_rel IS 'RELATION BETWEEN digest_digest AND res_users';


--
-- Name: digest_tip; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip (
    id integer NOT NULL,
    sequence integer,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name jsonb,
    tip_description jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.digest_tip OWNER TO runbot;

--
-- Name: TABLE digest_tip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip IS 'Digest Tips';


--
-- Name: COLUMN digest_tip.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.sequence IS 'Sequence';


--
-- Name: COLUMN digest_tip.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.group_id IS 'Authorized Group';


--
-- Name: COLUMN digest_tip.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_uid IS 'Created by';


--
-- Name: COLUMN digest_tip.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_uid IS 'Last Updated by';


--
-- Name: COLUMN digest_tip.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.name IS 'Name';


--
-- Name: COLUMN digest_tip.tip_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.tip_description IS 'Tip description';


--
-- Name: COLUMN digest_tip.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.create_date IS 'Created on';


--
-- Name: COLUMN digest_tip.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.digest_tip.write_date IS 'Last Updated on';


--
-- Name: digest_tip_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.digest_tip_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.digest_tip_id_seq OWNER TO runbot;

--
-- Name: digest_tip_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.digest_tip_id_seq OWNED BY public.digest_tip.id;


--
-- Name: digest_tip_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.digest_tip_res_users_rel (
    digest_tip_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.digest_tip_res_users_rel OWNER TO runbot;

--
-- Name: TABLE digest_tip_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.digest_tip_res_users_rel IS 'RELATION BETWEEN digest_tip AND res_users';


--
-- Name: discuss_call_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_call_history (
    id integer NOT NULL,
    channel_id integer NOT NULL,
    start_call_message_id integer,
    create_uid integer,
    write_uid integer,
    start_dt timestamp without time zone NOT NULL,
    end_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_call_history_channel_id_not_null_constraint CHECK ((channel_id IS NOT NULL)),
    CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint CHECK ((start_dt IS NOT NULL))
);


ALTER TABLE public.discuss_call_history OWNER TO runbot;

--
-- Name: TABLE discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_call_history IS 'Keep the call history';


--
-- Name: COLUMN discuss_call_history.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_call_history.start_call_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_call_message_id IS 'Start Call Message';


--
-- Name: COLUMN discuss_call_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_call_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_call_history.start_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_dt IS 'Start Dt';


--
-- Name: COLUMN discuss_call_history.end_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.end_dt IS 'End Dt';


--
-- Name: COLUMN discuss_call_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_date IS 'Created on';


--
-- Name: COLUMN discuss_call_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON public.discuss_call_history IS 'CHECK (channel_id IS NOT NULL)';


--
-- Name: CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON public.discuss_call_history IS 'CHECK (start_dt IS NOT NULL)';


--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_call_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_call_history_id_seq OWNER TO runbot;

--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_call_history_id_seq OWNED BY public.discuss_call_history.id;


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ai_agent_id integer,
    ai_env_context jsonb,
    last_wa_mail_message_id integer,
    whatsapp_partner_id integer,
    wa_account_id integer,
    whatsapp_number character varying,
    CONSTRAINT discuss_channel_ai_channel_type_check CHECK (((ai_agent_id IS NULL) OR ((channel_type)::text = 'ai_chat'::text) OR ((channel_type)::text = 'livechat'::text))),
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR ((channel_type)::text = 'whatsapp'::text) OR (group_public_id IS NULL)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: COLUMN discuss_channel.ai_agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_agent_id IS 'Ai Agent';


--
-- Name: COLUMN discuss_channel.ai_env_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_env_context IS 'Context for AI agent';


--
-- Name: COLUMN discuss_channel.last_wa_mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_wa_mail_message_id IS 'Last WA Partner Mail Message';


--
-- Name: COLUMN discuss_channel.whatsapp_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.whatsapp_partner_id IS 'WhatsApp Partner';


--
-- Name: COLUMN discuss_channel.wa_account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.wa_account_id IS 'WhatsApp Business Account';


--
-- Name: COLUMN discuss_channel.whatsapp_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.whatsapp_number IS 'Phone Number';


--
-- Name: CONSTRAINT discuss_channel_ai_channel_type_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_ai_channel_type_check ON public.discuss_channel IS 'CHECK(ai_agent_id IS NULL or channel_type = ''ai_chat'' or channel_type = ''livechat'')';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR channel_type = ''whatsapp'' OR group_public_id IS NULL)';


--
-- Name: discuss_channel_hr_department_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_hr_department_rel (
    discuss_channel_id integer NOT NULL,
    hr_department_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_hr_department_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_hr_department_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_hr_department_rel IS 'RELATION BETWEEN discuss_channel AND hr_department';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: dms_acc_rep_export_wizard_format_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.dms_acc_rep_export_wizard_format_rel (
    account_reports_export_wizard_id integer NOT NULL,
    account_reports_export_wizard_format_id integer NOT NULL
);


ALTER TABLE public.dms_acc_rep_export_wizard_format_rel OWNER TO runbot;

--
-- Name: TABLE dms_acc_rep_export_wizard_format_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.dms_acc_rep_export_wizard_format_rel IS 'RELATION BETWEEN account_reports_export_wizard AND account_reports_export_wizard_format';


--
-- Name: docs_config_installer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.docs_config_installer (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    port integer NOT NULL,
    host character varying(64) NOT NULL,
    auth_type character varying,
    username character varying(32),
    password character varying(32),
    state character varying,
    msg text,
    error_details text,
    enabled boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.docs_config_installer OWNER TO runbot;

--
-- Name: TABLE docs_config_installer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.docs_config_installer IS 'docs_config.installer';


--
-- Name: COLUMN docs_config_installer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.create_uid IS 'Created by';


--
-- Name: COLUMN docs_config_installer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN docs_config_installer.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.port IS 'Port';


--
-- Name: COLUMN docs_config_installer.host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.host IS 'Host';


--
-- Name: COLUMN docs_config_installer.auth_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.auth_type IS 'Authentication';


--
-- Name: COLUMN docs_config_installer.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.username IS 'Username';


--
-- Name: COLUMN docs_config_installer.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.password IS 'Password';


--
-- Name: COLUMN docs_config_installer.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.state IS 'State';


--
-- Name: COLUMN docs_config_installer.msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.msg IS 'Message';


--
-- Name: COLUMN docs_config_installer.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.error_details IS 'Error Details';


--
-- Name: COLUMN docs_config_installer.enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.enabled IS 'Enabled';


--
-- Name: COLUMN docs_config_installer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.create_date IS 'Created on';


--
-- Name: COLUMN docs_config_installer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.docs_config_installer.write_date IS 'Last Updated on';


--
-- Name: docs_config_installer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.docs_config_installer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.docs_config_installer_id_seq OWNER TO runbot;

--
-- Name: docs_config_installer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.docs_config_installer_id_seq OWNED BY public.docs_config_installer.id;


--
-- Name: document_alias_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.document_alias_tag_rel (
    documents_document_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.document_alias_tag_rel OWNER TO runbot;

--
-- Name: TABLE document_alias_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.document_alias_tag_rel IS 'RELATION BETWEEN documents_document AND documents_tag';


--
-- Name: document_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.document_tag_rel (
    documents_document_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.document_tag_rel OWNER TO runbot;

--
-- Name: TABLE document_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.document_tag_rel IS 'RELATION BETWEEN documents_document AND documents_tag';


--
-- Name: documents_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_access (
    id integer NOT NULL,
    document_id integer NOT NULL,
    partner_id integer NOT NULL,
    role character varying,
    last_access_date timestamp without time zone,
    expiration_date timestamp without time zone,
    CONSTRAINT documents_access_role_or_last_access_date CHECK (((role IS NOT NULL) OR (last_access_date IS NOT NULL)))
);


ALTER TABLE public.documents_access OWNER TO runbot;

--
-- Name: TABLE documents_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_access IS 'Document / Partner';


--
-- Name: COLUMN documents_access.document_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_access.document_id IS 'Document';


--
-- Name: COLUMN documents_access.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_access.partner_id IS 'Partner';


--
-- Name: COLUMN documents_access.role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_access.role IS 'Role';


--
-- Name: COLUMN documents_access.last_access_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_access.last_access_date IS 'Last Accessed On';


--
-- Name: COLUMN documents_access.expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_access.expiration_date IS 'Expiration';


--
-- Name: CONSTRAINT documents_access_role_or_last_access_date ON documents_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT documents_access_role_or_last_access_date ON public.documents_access IS 'check (role IS NOT NULL or last_access_date IS NOT NULL)';


--
-- Name: documents_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_access_id_seq OWNER TO runbot;

--
-- Name: documents_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_access_id_seq OWNED BY public.documents_access.id;


--
-- Name: documents_access_tracking; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_access_tracking (
    id integer NOT NULL,
    user_id integer,
    changes jsonb NOT NULL,
    documents jsonb NOT NULL
);


ALTER TABLE public.documents_access_tracking OWNER TO runbot;

--
-- Name: TABLE documents_access_tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_access_tracking IS 'Document Access Tracking';


--
-- Name: COLUMN documents_access_tracking.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_access_tracking.user_id IS 'User';


--
-- Name: COLUMN documents_access_tracking.changes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_access_tracking.changes IS 'Changes need to be tracked';


--
-- Name: COLUMN documents_access_tracking.documents; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_access_tracking.documents IS 'Impacted Document Ids';


--
-- Name: documents_access_tracking_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_access_tracking_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_access_tracking_id_seq OWNER TO runbot;

--
-- Name: documents_access_tracking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_access_tracking_id_seq OWNED BY public.documents_access_tracking.id;


--
-- Name: documents_account_folder_setting; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_account_folder_setting (
    id integer NOT NULL,
    company_id integer NOT NULL,
    journal_id integer NOT NULL,
    folder_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_account_folder_setting OWNER TO runbot;

--
-- Name: TABLE documents_account_folder_setting; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_account_folder_setting IS 'Journal and Folder settings';


--
-- Name: COLUMN documents_account_folder_setting.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.company_id IS 'Company';


--
-- Name: COLUMN documents_account_folder_setting.journal_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.journal_id IS 'Journal';


--
-- Name: COLUMN documents_account_folder_setting.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.folder_id IS 'Folder';


--
-- Name: COLUMN documents_account_folder_setting.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.create_uid IS 'Created by';


--
-- Name: COLUMN documents_account_folder_setting.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_account_folder_setting.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.create_date IS 'Created on';


--
-- Name: COLUMN documents_account_folder_setting.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_account_folder_setting.write_date IS 'Last Updated on';


--
-- Name: documents_account_folder_setting_documents_tag_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_account_folder_setting_documents_tag_rel (
    documents_account_folder_setting_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.documents_account_folder_setting_documents_tag_rel OWNER TO runbot;

--
-- Name: TABLE documents_account_folder_setting_documents_tag_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_account_folder_setting_documents_tag_rel IS 'RELATION BETWEEN documents_account_folder_setting AND documents_tag';


--
-- Name: documents_account_folder_setting_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_account_folder_setting_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_account_folder_setting_id_seq OWNER TO runbot;

--
-- Name: documents_account_folder_setting_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_account_folder_setting_id_seq OWNED BY public.documents_account_folder_setting.id;


--
-- Name: documents_document; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document (
    id integer NOT NULL,
    alias_id integer,
    attachment_id integer,
    file_size integer,
    res_id integer,
    shortcut_document_id integer,
    shortcut_document_owner_id integer,
    partner_id integer,
    owner_id integer,
    lock_uid integer,
    request_activity_id integer,
    requestee_partner_id integer,
    sequence integer,
    folder_id integer,
    company_id integer,
    create_activity_type_id integer,
    create_activity_date_deadline_range integer,
    create_activity_user_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    file_extension character varying,
    res_model character varying,
    thumbnail_status character varying,
    url character varying(1024),
    url_preview_image character varying,
    type character varying NOT NULL,
    document_token character varying NOT NULL,
    access_via_link character varying NOT NULL,
    access_internal character varying NOT NULL,
    parent_path character varying,
    create_activity_summary character varying,
    create_activity_date_deadline_range_type character varying,
    name jsonb,
    create_activity_note text,
    is_editable_attachment boolean,
    is_multipage boolean,
    active boolean,
    is_access_via_link_hidden boolean,
    create_activity_option boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ai_sort_prompt text,
    ai_to_sort boolean,
    handler character varying,
    website_id integer,
    has_embedded_pdf boolean,
    CONSTRAINT documents_document_check_ai_sort_prompt CHECK (((COALESCE(ai_sort_prompt, ''::text) = ''::text) OR (((type)::text = 'folder'::text) AND (shortcut_document_id IS NULL)))),
    CONSTRAINT documents_document_folder_id_not_id CHECK ((folder_id <> id)),
    CONSTRAINT documents_document_frozen_spreadsheet_access_via_link__52cdd6ea CHECK ((((handler)::text <> 'frozen_spreadsheet'::text) OR (((access_via_link)::text <> 'edit'::text) AND ((access_internal)::text <> 'edit'::text)))),
    CONSTRAINT documents_document_shortcut_document_id_not_id CHECK ((shortcut_document_id <> id)),
    CONSTRAINT documents_document_spreadsheet_access_via_link CHECK ((((handler)::text <> 'spreadsheet'::text) OR ((access_via_link)::text <> 'edit'::text)))
);


ALTER TABLE public.documents_document OWNER TO runbot;

--
-- Name: TABLE documents_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document IS 'Document';


--
-- Name: COLUMN documents_document.alias_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.alias_id IS 'Alias';


--
-- Name: COLUMN documents_document.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.attachment_id IS 'Attachment';


--
-- Name: COLUMN documents_document.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.file_size IS 'File Size';


--
-- Name: COLUMN documents_document.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.res_id IS 'Resource ID';


--
-- Name: COLUMN documents_document.shortcut_document_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.shortcut_document_id IS 'Source Document';


--
-- Name: COLUMN documents_document.shortcut_document_owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.shortcut_document_owner_id IS 'Source Document Owner';


--
-- Name: COLUMN documents_document.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.partner_id IS 'Contact';


--
-- Name: COLUMN documents_document.owner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.owner_id IS 'Owner';


--
-- Name: COLUMN documents_document.lock_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.lock_uid IS 'Locked by';


--
-- Name: COLUMN documents_document.request_activity_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.request_activity_id IS 'Request Activity';


--
-- Name: COLUMN documents_document.requestee_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.requestee_partner_id IS 'Requestee Partner';


--
-- Name: COLUMN documents_document.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.sequence IS 'Sequence';


--
-- Name: COLUMN documents_document.folder_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.folder_id IS 'Folder';


--
-- Name: COLUMN documents_document.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.company_id IS 'Company';


--
-- Name: COLUMN documents_document.create_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_activity_type_id IS 'Activity type';


--
-- Name: COLUMN documents_document.create_activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN documents_document.create_activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_activity_user_id IS 'Responsible';


--
-- Name: COLUMN documents_document.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_uid IS 'Created by';


--
-- Name: COLUMN documents_document.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_document.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.email_cc IS 'Email cc';


--
-- Name: COLUMN documents_document.file_extension; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.file_extension IS 'File Extension';


--
-- Name: COLUMN documents_document.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.res_model IS 'Resource Model';


--
-- Name: COLUMN documents_document.thumbnail_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.thumbnail_status IS 'Thumbnail Status';


--
-- Name: COLUMN documents_document.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.url IS 'Link URL';


--
-- Name: COLUMN documents_document.url_preview_image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.url_preview_image IS 'URL Preview Image';


--
-- Name: COLUMN documents_document.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.type IS 'Type';


--
-- Name: COLUMN documents_document.document_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.document_token IS 'Document Token';


--
-- Name: COLUMN documents_document.access_via_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.access_via_link IS 'Link Access Rights';


--
-- Name: COLUMN documents_document.access_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.access_internal IS 'Internal Users Rights';


--
-- Name: COLUMN documents_document.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.parent_path IS 'Parent Path';


--
-- Name: COLUMN documents_document.create_activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_activity_summary IS 'Summary';


--
-- Name: COLUMN documents_document.create_activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN documents_document.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.name IS 'Name';


--
-- Name: COLUMN documents_document.create_activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_activity_note IS 'Note';


--
-- Name: COLUMN documents_document.is_editable_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.is_editable_attachment IS 'Is Editable Attachment';


--
-- Name: COLUMN documents_document.is_multipage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.is_multipage IS 'Is considered multipage';


--
-- Name: COLUMN documents_document.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.active IS 'Active';


--
-- Name: COLUMN documents_document.is_access_via_link_hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.is_access_via_link_hidden IS 'Link Access Hidden';


--
-- Name: COLUMN documents_document.create_activity_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_activity_option IS 'Create a new activity';


--
-- Name: COLUMN documents_document.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.create_date IS 'Created on';


--
-- Name: COLUMN documents_document.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.write_date IS 'Last Updated on';


--
-- Name: COLUMN documents_document.ai_sort_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.ai_sort_prompt IS 'AI Folder Sort Prompt';


--
-- Name: COLUMN documents_document.ai_to_sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.ai_to_sort IS 'AI To Sort';


--
-- Name: COLUMN documents_document.handler; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.handler IS 'Handler';


--
-- Name: COLUMN documents_document.website_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.website_id IS 'Website';


--
-- Name: COLUMN documents_document.has_embedded_pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_document.has_embedded_pdf IS 'Has Embedded PDF';


--
-- Name: CONSTRAINT documents_document_check_ai_sort_prompt ON documents_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT documents_document_check_ai_sort_prompt ON public.documents_document IS 'CHECK(COALESCE(ai_sort_prompt, '''') = '''' OR (type = ''folder'' AND shortcut_document_id IS NULL))';


--
-- Name: CONSTRAINT documents_document_folder_id_not_id ON documents_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT documents_document_folder_id_not_id ON public.documents_document IS 'check(folder_id <> id)';


--
-- Name: CONSTRAINT documents_document_frozen_spreadsheet_access_via_link__52cdd6ea ON documents_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT documents_document_frozen_spreadsheet_access_via_link__52cdd6ea ON public.documents_document IS 'CHECK((handler != ''frozen_spreadsheet'') OR (access_via_link != ''edit'' AND access_internal != ''edit''))';


--
-- Name: CONSTRAINT documents_document_shortcut_document_id_not_id ON documents_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT documents_document_shortcut_document_id_not_id ON public.documents_document IS 'check(shortcut_document_id <> id)';


--
-- Name: CONSTRAINT documents_document_spreadsheet_access_via_link ON documents_document; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT documents_document_spreadsheet_access_via_link ON public.documents_document IS 'CHECK((handler != ''spreadsheet'') OR access_via_link != ''edit'')';


--
-- Name: documents_document_documents_link_to_record_wizard_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document_documents_link_to_record_wizard_rel (
    documents_link_to_record_wizard_id integer NOT NULL,
    documents_document_id integer NOT NULL
);


ALTER TABLE public.documents_document_documents_link_to_record_wizard_rel OWNER TO runbot;

--
-- Name: TABLE documents_document_documents_link_to_record_wizard_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document_documents_link_to_record_wizard_rel IS 'RELATION BETWEEN documents_link_to_record_wizard AND documents_document';


--
-- Name: documents_document_documents_operation_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document_documents_operation_rel (
    documents_operation_id integer NOT NULL,
    documents_document_id integer NOT NULL
);


ALTER TABLE public.documents_document_documents_operation_rel OWNER TO runbot;

--
-- Name: TABLE documents_document_documents_operation_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document_documents_operation_rel IS 'RELATION BETWEEN documents_operation AND documents_document';


--
-- Name: documents_document_documents_sharing_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document_documents_sharing_rel (
    documents_sharing_id integer NOT NULL,
    documents_document_id integer NOT NULL
);


ALTER TABLE public.documents_document_documents_sharing_rel OWNER TO runbot;

--
-- Name: TABLE documents_document_documents_sharing_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document_documents_sharing_rel IS 'RELATION BETWEEN documents_sharing AND documents_document';


--
-- Name: documents_document_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_document_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_document_id_seq OWNER TO runbot;

--
-- Name: documents_document_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.documents_document_id_seq OWNED BY public.documents_document.id;


--
-- Name: documents_document_ir_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document_ir_attachment_rel (
    documents_document_id integer NOT NULL,
    ir_attachment_id integer NOT NULL
);


ALTER TABLE public.documents_document_ir_attachment_rel OWNER TO runbot;

--
-- Name: TABLE documents_document_ir_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document_ir_attachment_rel IS 'RELATION BETWEEN documents_document AND ir_attachment';


--
-- Name: documents_document_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_document_res_users_rel (
    documents_document_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.documents_document_res_users_rel OWNER TO runbot;

--
-- Name: TABLE documents_document_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_document_res_users_rel IS 'RELATION BETWEEN documents_document AND res_users';


--
-- Name: documents_hr_contracts_tags_table; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_hr_contracts_tags_table (
    res_company_id integer NOT NULL,
    documents_tag_id integer NOT NULL
);


ALTER TABLE public.documents_hr_contracts_tags_table OWNER TO runbot;

--
-- Name: TABLE documents_hr_contracts_tags_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_hr_contracts_tags_table IS 'RELATION BETWEEN res_company AND documents_tag';


--
-- Name: documents_link_to_record_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.documents_link_to_record_wizard (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    is_readonly_model boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.documents_link_to_record_wizard OWNER TO runbot;

--
-- Name: TABLE documents_link_to_record_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.documents_link_to_record_wizard IS 'Documents Link to Record';


--
-- Name: COLUMN documents_link_to_record_wizard.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.model_id IS 'Model';


--
-- Name: COLUMN documents_link_to_record_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN documents_link_to_record_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN documents_link_to_record_wizard.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.resource_ref IS 'Record';


--
-- Name: COLUMN documents_link_to_record_wizard.is_readonly_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.is_readonly_model IS 'is_readonly_model';


--
-- Name: COLUMN documents_link_to_record_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.create_date IS 'Created on';


--
-- Name: COLUMN documents_link_to_record_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.documents_link_to_record_wizard.write_date IS 'Last Updated on';


--
-- Name: documents_link_to_record_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.documents_link_to_record_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.documents_link_to_record_wizar