--
-- PostgreSQL database dump
--

\restrict yQf9WAIl1wWdkLaMSXbkBlyUdbAIqZy6WzaYOXbCrpbJxJwu1W2FC6I87wbw1qO

-- Dumped from database version 16.11 (Ubuntu 16.11-0ubuntu0.24.04.1)
-- Dumped by pg_dump version 18.1 (Debian 18.1-1.pgdg12+2)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET transaction_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: vector; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS vector WITH SCHEMA public;


--
-- Name: EXTENSION vector; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION vector IS 'vector data type and ivfflat and hnsw access methods';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: activity_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.activity_attachment_rel (
    activity_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.activity_attachment_rel OWNER TO runbot;

--
-- Name: TABLE activity_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.activity_attachment_rel IS 'RELATION BETWEEN mail_activity AND ir_attachment';


--
-- Name: ai_agent; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subtitle character varying,
    response_style character varying NOT NULL,
    llm_model character varying NOT NULL,
    system_prompt text,
    active boolean,
    restrict_to_sources boolean,
    is_system_agent boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent OWNER TO runbot;

--
-- Name: TABLE ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent IS 'AI Agent';


--
-- Name: COLUMN ai_agent.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.partner_id IS 'Partner';


--
-- Name: COLUMN ai_agent.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent.subtitle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.subtitle IS 'Description';


--
-- Name: COLUMN ai_agent.response_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.response_style IS 'Response Style';


--
-- Name: COLUMN ai_agent.llm_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.llm_model IS 'LLM Model';


--
-- Name: COLUMN ai_agent.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.system_prompt IS 'System Prompt';


--
-- Name: COLUMN ai_agent.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.active IS 'Active';


--
-- Name: COLUMN ai_agent.restrict_to_sources; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.restrict_to_sources IS 'Restrict to Sources';


--
-- Name: COLUMN ai_agent.is_system_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.is_system_agent IS 'System Agent';


--
-- Name: COLUMN ai_agent.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent.write_date IS 'Last Updated on';


--
-- Name: ai_agent_ai_topic_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_ai_topic_rel (
    ai_agent_id integer NOT NULL,
    ai_topic_id integer NOT NULL
);


ALTER TABLE public.ai_agent_ai_topic_rel OWNER TO runbot;

--
-- Name: TABLE ai_agent_ai_topic_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_ai_topic_rel IS 'RELATION BETWEEN ai_agent AND ai_topic';


--
-- Name: ai_agent_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_id_seq OWNER TO runbot;

--
-- Name: ai_agent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_id_seq OWNED BY public.ai_agent.id;


--
-- Name: ai_agent_source; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_agent_source (
    id integer NOT NULL,
    agent_id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    type character varying NOT NULL,
    status character varying,
    url character varying,
    error_details text,
    is_active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_agent_source OWNER TO runbot;

--
-- Name: TABLE ai_agent_source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_agent_source IS 'AI Agent Source';


--
-- Name: COLUMN ai_agent_source.agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.agent_id IS 'Agent';


--
-- Name: COLUMN ai_agent_source.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_agent_source.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_uid IS 'Created by';


--
-- Name: COLUMN ai_agent_source.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_agent_source.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.name IS 'Name';


--
-- Name: COLUMN ai_agent_source.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.type IS 'Type';


--
-- Name: COLUMN ai_agent_source.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.status IS 'Status';


--
-- Name: COLUMN ai_agent_source.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.url IS 'URL';


--
-- Name: COLUMN ai_agent_source.error_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.error_details IS 'Error Details';


--
-- Name: COLUMN ai_agent_source.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.is_active IS 'Active';


--
-- Name: COLUMN ai_agent_source.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.create_date IS 'Created on';


--
-- Name: COLUMN ai_agent_source.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_agent_source.write_date IS 'Last Updated on';


--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_agent_source_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_agent_source_id_seq OWNER TO runbot;

--
-- Name: ai_agent_source_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_agent_source_id_seq OWNED BY public.ai_agent_source.id;


--
-- Name: ai_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer (
    id integer NOT NULL,
    ai_agent integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    interface_key character varying NOT NULL,
    default_prompt text,
    is_system_default boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_composer OWNER TO runbot;

--
-- Name: TABLE ai_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer IS 'AI model configurations (system prompts) for text drafting.';


--
-- Name: COLUMN ai_composer.ai_agent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.ai_agent IS 'Agent';


--
-- Name: COLUMN ai_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_uid IS 'Created by';


--
-- Name: COLUMN ai_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_composer.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.name IS 'Rule Name';


--
-- Name: COLUMN ai_composer.interface_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.interface_key IS 'Action';


--
-- Name: COLUMN ai_composer.default_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.default_prompt IS 'Instructions';


--
-- Name: COLUMN ai_composer.is_system_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.is_system_default IS 'Is the rule a system default or user created';


--
-- Name: COLUMN ai_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.create_date IS 'Created on';


--
-- Name: COLUMN ai_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_composer.write_date IS 'Last Updated on';


--
-- Name: ai_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_composer_id_seq OWNER TO runbot;

--
-- Name: ai_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_composer_id_seq OWNED BY public.ai_composer.id;


--
-- Name: ai_composer_ir_model_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_composer_ir_model_rel (
    ai_composer_id integer NOT NULL,
    ir_model_id integer NOT NULL
);


ALTER TABLE public.ai_composer_ir_model_rel OWNER TO runbot;

--
-- Name: TABLE ai_composer_ir_model_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_composer_ir_model_rel IS 'RELATION BETWEEN ai_composer AND ir_model';


--
-- Name: ai_embedding; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_embedding (
    id integer NOT NULL,
    attachment_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    embedding_model character varying NOT NULL,
    content text NOT NULL,
    has_embedding_generation_failed boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    embedding_vector public.vector(1536)
);


ALTER TABLE public.ai_embedding OWNER TO runbot;

--
-- Name: TABLE ai_embedding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_embedding IS 'Attachment Chunks Embedding';


--
-- Name: COLUMN ai_embedding.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.attachment_id IS 'Attachment';


--
-- Name: COLUMN ai_embedding.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.sequence IS 'Sequence';


--
-- Name: COLUMN ai_embedding.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_uid IS 'Created by';


--
-- Name: COLUMN ai_embedding.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_embedding.embedding_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_model IS 'Embedding Model';


--
-- Name: COLUMN ai_embedding.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.content IS 'Chunk Content';


--
-- Name: COLUMN ai_embedding.has_embedding_generation_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.has_embedding_generation_failed IS 'Has Embedding Generation Failed';


--
-- Name: COLUMN ai_embedding.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.create_date IS 'Created on';


--
-- Name: COLUMN ai_embedding.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.write_date IS 'Last Updated on';


--
-- Name: COLUMN ai_embedding.embedding_vector; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_embedding.embedding_vector IS 'Embedding Vector';


--
-- Name: ai_embedding_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_embedding_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_embedding_id_seq OWNER TO runbot;

--
-- Name: ai_embedding_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_embedding_id_seq OWNED BY public.ai_embedding.id;


--
-- Name: ai_prompt_button; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_prompt_button (
    id integer NOT NULL,
    sequence integer,
    composer_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_prompt_button OWNER TO runbot;

--
-- Name: TABLE ai_prompt_button; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_prompt_button IS 'Prompt that can be attached to AI UI rules for quick access by the user.';


--
-- Name: COLUMN ai_prompt_button.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.sequence IS 'Sequence';


--
-- Name: COLUMN ai_prompt_button.composer_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.composer_id IS 'Composer';


--
-- Name: COLUMN ai_prompt_button.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_uid IS 'Created by';


--
-- Name: COLUMN ai_prompt_button.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_prompt_button.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.name IS 'AI Prompt';


--
-- Name: COLUMN ai_prompt_button.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.create_date IS 'Created on';


--
-- Name: COLUMN ai_prompt_button.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_prompt_button.write_date IS 'Last Updated on';


--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_prompt_button_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_prompt_button_id_seq OWNER TO runbot;

--
-- Name: ai_prompt_button_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_prompt_button_id_seq OWNED BY public.ai_prompt_button.id;


--
-- Name: ai_tool_ids_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_tool_ids_rel (
    parent_id integer NOT NULL,
    tool_id integer NOT NULL
);


ALTER TABLE public.ai_tool_ids_rel OWNER TO runbot;

--
-- Name: TABLE ai_tool_ids_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_tool_ids_rel IS 'RELATION BETWEEN ir_act_server AND ir_act_server';


--
-- Name: ai_topic; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    description text,
    instructions text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ai_topic OWNER TO runbot;

--
-- Name: TABLE ai_topic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic IS 'Create a topic that leverages instructions and tools to direct Odoo AI in assisting the user with their tasks.';


--
-- Name: COLUMN ai_topic.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_uid IS 'Created by';


--
-- Name: COLUMN ai_topic.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ai_topic.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.name IS 'Title';


--
-- Name: COLUMN ai_topic.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.description IS 'Description';


--
-- Name: COLUMN ai_topic.instructions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.instructions IS 'Instructions';


--
-- Name: COLUMN ai_topic.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.create_date IS 'Created on';


--
-- Name: COLUMN ai_topic.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ai_topic.write_date IS 'Last Updated on';


--
-- Name: ai_topic_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ai_topic_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ai_topic_id_seq OWNER TO runbot;

--
-- Name: ai_topic_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ai_topic_id_seq OWNED BY public.ai_topic.id;


--
-- Name: ai_topic_ir_act_server_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ai_topic_ir_act_server_rel (
    ai_topic_id integer NOT NULL,
    ir_act_server_id integer NOT NULL
);


ALTER TABLE public.ai_topic_ir_act_server_rel OWNER TO runbot;

--
-- Name: TABLE ai_topic_ir_act_server_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ai_topic_ir_act_server_rel IS 'RELATION BETWEEN ai_topic AND ir_act_server';


--
-- Name: auth_passkey_key; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key (
    id integer NOT NULL,
    sign_count integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    credential_identifier character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    public_key character varying
);


ALTER TABLE public.auth_passkey_key OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key IS 'Passkey';


--
-- Name: COLUMN auth_passkey_key.sign_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.sign_count IS 'Sign Count';


--
-- Name: COLUMN auth_passkey_key.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_uid IS 'Create Uid';


--
-- Name: COLUMN auth_passkey_key.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key.credential_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.credential_identifier IS 'Credential Identifier';


--
-- Name: COLUMN auth_passkey_key.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_passkey_key_create (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_passkey_key_create OWNER TO runbot;

--
-- Name: TABLE auth_passkey_key_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_passkey_key_create IS 'Create a Passkey';


--
-- Name: COLUMN auth_passkey_key_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_uid IS 'Created by';


--
-- Name: COLUMN auth_passkey_key_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_passkey_key_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.name IS 'Name';


--
-- Name: COLUMN auth_passkey_key_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.create_date IS 'Created on';


--
-- Name: COLUMN auth_passkey_key_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_passkey_key_create.write_date IS 'Last Updated on';


--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_create_id_seq OWNED BY public.auth_passkey_key_create.id;


--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_passkey_key_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_passkey_key_id_seq OWNER TO runbot;

--
-- Name: auth_passkey_key_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_passkey_key_id_seq OWNED BY public.auth_passkey_key.id;


--
-- Name: auth_totp_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_device (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT auth_totp_device_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.auth_totp_device OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_device_id_seq OWNER TO runbot;

--
-- Name: auth_totp_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_device_id_seq OWNED BY public.auth_totp_device.id;


--
-- Name: auth_totp_rate_limit_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_rate_limit_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    ip character varying,
    limit_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.auth_totp_rate_limit_log OWNER TO runbot;

--
-- Name: TABLE auth_totp_rate_limit_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_rate_limit_log IS 'TOTP rate limit logs';


--
-- Name: COLUMN auth_totp_rate_limit_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.user_id IS 'User';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_rate_limit_log.ip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.ip IS 'Ip';


--
-- Name: COLUMN auth_totp_rate_limit_log.limit_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.limit_type IS 'Limit Type';


--
-- Name: COLUMN auth_totp_rate_limit_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_rate_limit_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_rate_limit_log.write_date IS 'Last Updated on';


--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_rate_limit_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNER TO runbot;

--
-- Name: auth_totp_rate_limit_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_rate_limit_log_id_seq OWNED BY public.auth_totp_rate_limit_log.id;


--
-- Name: auth_totp_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.auth_totp_wizard (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    secret character varying NOT NULL,
    url character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    qrcode bytea
);


ALTER TABLE public.auth_totp_wizard OWNER TO runbot;

--
-- Name: TABLE auth_totp_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.auth_totp_wizard IS '2-Factor Setup Wizard';


--
-- Name: COLUMN auth_totp_wizard.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.user_id IS 'User';


--
-- Name: COLUMN auth_totp_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN auth_totp_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN auth_totp_wizard.secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.secret IS 'Secret';


--
-- Name: COLUMN auth_totp_wizard.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.url IS 'Url';


--
-- Name: COLUMN auth_totp_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.create_date IS 'Created on';


--
-- Name: COLUMN auth_totp_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.write_date IS 'Last Updated on';


--
-- Name: COLUMN auth_totp_wizard.qrcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.auth_totp_wizard.qrcode IS 'Qrcode';


--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.auth_totp_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNER TO runbot;

--
-- Name: auth_totp_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.auth_totp_wizard_id_seq OWNED BY public.auth_totp_wizard.id;


--
-- Name: base_document_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_document_layout (
    id integer NOT NULL,
    company_id integer NOT NULL,
    report_layout_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_document_layout OWNER TO runbot;

--
-- Name: TABLE base_document_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_document_layout IS 'Company Document Layout';


--
-- Name: COLUMN base_document_layout.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.company_id IS 'Company';


--
-- Name: COLUMN base_document_layout.report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.report_layout_id IS 'Report Layout';


--
-- Name: COLUMN base_document_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_uid IS 'Created by';


--
-- Name: COLUMN base_document_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_document_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.create_date IS 'Created on';


--
-- Name: COLUMN base_document_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_document_layout.write_date IS 'Last Updated on';


--
-- Name: base_document_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_document_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_document_layout_id_seq OWNER TO runbot;

--
-- Name: base_document_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_document_layout_id_seq OWNED BY public.base_document_layout.id;


--
-- Name: base_enable_profiling_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_enable_profiling_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    duration character varying,
    expiration timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_enable_profiling_wizard OWNER TO runbot;

--
-- Name: TABLE base_enable_profiling_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_enable_profiling_wizard IS 'Enable profiling for some time';


--
-- Name: COLUMN base_enable_profiling_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_enable_profiling_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_enable_profiling_wizard.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.duration IS 'Enable profiling for';


--
-- Name: COLUMN base_enable_profiling_wizard.expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.expiration IS 'Enable profiling until';


--
-- Name: COLUMN base_enable_profiling_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_enable_profiling_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_enable_profiling_wizard.write_date IS 'Last Updated on';


--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_enable_profiling_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNER TO runbot;

--
-- Name: base_enable_profiling_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_enable_profiling_wizard_id_seq OWNED BY public.base_enable_profiling_wizard.id;


--
-- Name: base_import_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    file_name character varying,
    file_type character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    file bytea
);


ALTER TABLE public.base_import_import OWNER TO runbot;

--
-- Name: TABLE base_import_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_import IS 'Base Import';


--
-- Name: COLUMN base_import_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_import.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.res_model IS 'Model';


--
-- Name: COLUMN base_import_import.file_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_name IS 'File Name';


--
-- Name: COLUMN base_import_import.file_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file_type IS 'File Type';


--
-- Name: COLUMN base_import_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.create_date IS 'Created on';


--
-- Name: COLUMN base_import_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_import.file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_import.file IS 'File';


--
-- Name: base_import_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_import_id_seq OWNER TO runbot;

--
-- Name: base_import_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_import_id_seq OWNED BY public.base_import_import.id;


--
-- Name: base_import_mapping; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_mapping (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    column_name character varying,
    field_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_import_mapping OWNER TO runbot;

--
-- Name: TABLE base_import_mapping; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_mapping IS 'Base Import Mapping';


--
-- Name: COLUMN base_import_mapping.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_mapping.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_mapping.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.res_model IS 'Res Model';


--
-- Name: COLUMN base_import_mapping.column_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.column_name IS 'Column Name';


--
-- Name: COLUMN base_import_mapping.field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.field_name IS 'Field Name';


--
-- Name: COLUMN base_import_mapping.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.create_date IS 'Created on';


--
-- Name: COLUMN base_import_mapping.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_mapping.write_date IS 'Last Updated on';


--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_mapping_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_mapping_id_seq OWNER TO runbot;

--
-- Name: base_import_mapping_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_mapping_id_seq OWNED BY public.base_import_mapping.id;


--
-- Name: base_import_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_import_module (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    state character varying,
    import_message text,
    modules_dependencies text,
    force boolean,
    with_demo boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    module_file bytea NOT NULL
);


ALTER TABLE public.base_import_module OWNER TO runbot;

--
-- Name: TABLE base_import_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_import_module IS 'Import Module';


--
-- Name: COLUMN base_import_module.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_uid IS 'Created by';


--
-- Name: COLUMN base_import_module.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_import_module.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.state IS 'Status';


--
-- Name: COLUMN base_import_module.import_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.import_message IS 'Import Message';


--
-- Name: COLUMN base_import_module.modules_dependencies; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.modules_dependencies IS 'Modules Dependencies';


--
-- Name: COLUMN base_import_module.force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.force IS 'Force init';


--
-- Name: COLUMN base_import_module.with_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.with_demo IS 'Import demo data of module';


--
-- Name: COLUMN base_import_module.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.create_date IS 'Created on';


--
-- Name: COLUMN base_import_module.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_import_module.module_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_import_module.module_file IS 'Module .ZIP file';


--
-- Name: base_import_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_import_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_import_module_id_seq OWNER TO runbot;

--
-- Name: base_import_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_import_module_id_seq OWNED BY public.base_import_module.id;


--
-- Name: base_language_export; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_export (
    id integer NOT NULL,
    model_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    lang character varying NOT NULL,
    format character varying NOT NULL,
    export_type character varying NOT NULL,
    domain character varying,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea
);


ALTER TABLE public.base_language_export OWNER TO runbot;

--
-- Name: TABLE base_language_export; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_export IS 'Language Export';


--
-- Name: COLUMN base_language_export.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.model_id IS 'Model to Export';


--
-- Name: COLUMN base_language_export.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_export.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_export.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.name IS 'File Name';


--
-- Name: COLUMN base_language_export.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.lang IS 'Language';


--
-- Name: COLUMN base_language_export.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.format IS 'File Format';


--
-- Name: COLUMN base_language_export.export_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.export_type IS 'Export Type';


--
-- Name: COLUMN base_language_export.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.domain IS 'Model Domain';


--
-- Name: COLUMN base_language_export.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.state IS 'State';


--
-- Name: COLUMN base_language_export.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.create_date IS 'Created on';


--
-- Name: COLUMN base_language_export.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_export.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_export.data IS 'File';


--
-- Name: base_language_export_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_export_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_export_id_seq OWNER TO runbot;

--
-- Name: base_language_export_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_export_id_seq OWNED BY public.base_language_export.id;


--
-- Name: base_language_import; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_import (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    filename character varying NOT NULL,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    data bytea NOT NULL
);


ALTER TABLE public.base_language_import OWNER TO runbot;

--
-- Name: TABLE base_language_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_import IS 'Language Import';


--
-- Name: COLUMN base_language_import.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_import.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_import.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.name IS 'Language Name';


--
-- Name: COLUMN base_language_import.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.code IS 'ISO Code';


--
-- Name: COLUMN base_language_import.filename; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.filename IS 'File Name';


--
-- Name: COLUMN base_language_import.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_import.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.create_date IS 'Created on';


--
-- Name: COLUMN base_language_import.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.write_date IS 'Last Updated on';


--
-- Name: COLUMN base_language_import.data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_import.data IS 'File';


--
-- Name: base_language_import_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_import_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_import_id_seq OWNER TO runbot;

--
-- Name: base_language_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_import_id_seq OWNED BY public.base_language_import.id;


--
-- Name: base_language_install; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_language_install (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    overwrite boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_language_install OWNER TO runbot;

--
-- Name: TABLE base_language_install; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_language_install IS 'Install Language';


--
-- Name: COLUMN base_language_install.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_uid IS 'Created by';


--
-- Name: COLUMN base_language_install.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_language_install.overwrite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.overwrite IS 'Overwrite Existing Terms';


--
-- Name: COLUMN base_language_install.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.create_date IS 'Created on';


--
-- Name: COLUMN base_language_install.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_language_install.write_date IS 'Last Updated on';


--
-- Name: base_language_install_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_language_install_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_language_install_id_seq OWNER TO runbot;

--
-- Name: base_language_install_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_language_install_id_seq OWNED BY public.base_language_install.id;


--
-- Name: base_module_install_request; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_request (
    id integer NOT NULL,
    module_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    body_html text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_request OWNER TO runbot;

--
-- Name: TABLE base_module_install_request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_request IS 'Module Activation Request';


--
-- Name: COLUMN base_module_install_request.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_request.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.user_id IS 'User';


--
-- Name: COLUMN base_module_install_request.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_request.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_request.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.body_html IS 'Body';


--
-- Name: COLUMN base_module_install_request.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_request.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_request.write_date IS 'Last Updated on';


--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_request_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_request_id_seq OWNER TO runbot;

--
-- Name: base_module_install_request_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_request_id_seq OWNED BY public.base_module_install_request.id;


--
-- Name: base_module_install_review; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_install_review (
    id integer NOT NULL,
    module_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_install_review OWNER TO runbot;

--
-- Name: TABLE base_module_install_review; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_install_review IS 'Module Activation Review';


--
-- Name: COLUMN base_module_install_review.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.module_id IS 'Module';


--
-- Name: COLUMN base_module_install_review.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_install_review.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_install_review.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.create_date IS 'Created on';


--
-- Name: COLUMN base_module_install_review.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_install_review.write_date IS 'Last Updated on';


--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_install_review_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_install_review_id_seq OWNER TO runbot;

--
-- Name: base_module_install_review_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_install_review_id_seq OWNED BY public.base_module_install_review.id;


--
-- Name: base_module_uninstall; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    show_all boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_uninstall OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall IS 'Module Uninstall';


--
-- Name: COLUMN base_module_uninstall.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_uninstall.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_uninstall.show_all; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.show_all IS 'Show All';


--
-- Name: COLUMN base_module_uninstall.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.create_date IS 'Created on';


--
-- Name: COLUMN base_module_uninstall.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_uninstall.write_date IS 'Last Updated on';


--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_uninstall_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_uninstall_id_seq OWNER TO runbot;

--
-- Name: base_module_uninstall_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_uninstall_id_seq OWNED BY public.base_module_uninstall.id;


--
-- Name: base_module_uninstall_ir_module_module_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_uninstall_ir_module_module_rel (
    base_module_uninstall_id integer NOT NULL,
    ir_module_module_id integer NOT NULL
);


ALTER TABLE public.base_module_uninstall_ir_module_module_rel OWNER TO runbot;

--
-- Name: TABLE base_module_uninstall_ir_module_module_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_uninstall_ir_module_module_rel IS 'RELATION BETWEEN base_module_uninstall AND ir_module_module';


--
-- Name: base_module_update; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_update (
    id integer NOT NULL,
    updated integer,
    added integer,
    create_uid integer,
    write_uid integer,
    state character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_update OWNER TO runbot;

--
-- Name: TABLE base_module_update; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_update IS 'Update Module';


--
-- Name: COLUMN base_module_update.updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.updated IS 'Number of modules updated';


--
-- Name: COLUMN base_module_update.added; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.added IS 'Number of modules added';


--
-- Name: COLUMN base_module_update.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_update.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_update.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.state IS 'Status';


--
-- Name: COLUMN base_module_update.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.create_date IS 'Created on';


--
-- Name: COLUMN base_module_update.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_update.write_date IS 'Last Updated on';


--
-- Name: base_module_update_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_update_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_update_id_seq OWNER TO runbot;

--
-- Name: base_module_update_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_update_id_seq OWNED BY public.base_module_update.id;


--
-- Name: base_module_upgrade; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_module_upgrade (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    module_info text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_module_upgrade OWNER TO runbot;

--
-- Name: TABLE base_module_upgrade; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_module_upgrade IS 'Upgrade Module';


--
-- Name: COLUMN base_module_upgrade.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_uid IS 'Created by';


--
-- Name: COLUMN base_module_upgrade.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_module_upgrade.module_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.module_info IS 'Apps to Update';


--
-- Name: COLUMN base_module_upgrade.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.create_date IS 'Created on';


--
-- Name: COLUMN base_module_upgrade.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_module_upgrade.write_date IS 'Last Updated on';


--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_module_upgrade_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_module_upgrade_id_seq OWNER TO runbot;

--
-- Name: base_module_upgrade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_module_upgrade_id_seq OWNED BY public.base_module_upgrade.id;


--
-- Name: base_partner_merge_automatic_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard (
    id integer NOT NULL,
    number_group integer,
    current_line_id integer,
    dst_partner_id integer,
    maximum_group integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    group_by_email boolean,
    group_by_name boolean,
    group_by_is_company boolean,
    group_by_vat boolean,
    group_by_parent_id boolean,
    exclude_contact boolean,
    exclude_journal_item boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_automatic_wizard OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard IS 'Merge Partner Wizard';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.number_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.number_group IS 'Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.current_line_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.current_line_id IS 'Current Line';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.dst_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.dst_partner_id IS 'Destination Contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.maximum_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.maximum_group IS 'Maximum of Group of Contacts';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.state IS 'State';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_email IS 'Email';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_name IS 'Name';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_is_company IS 'Is Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_vat IS 'VAT';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.group_by_parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.group_by_parent_id IS 'Parent Company';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_contact IS 'A user associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.exclude_journal_item; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.exclude_journal_item IS 'Journal Items associated to the contact';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_automatic_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_automatic_wizard.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_automatic_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_automatic_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_automatic_wizard_id_seq OWNED BY public.base_partner_merge_automatic_wizard.id;


--
-- Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_automatic_wizard_res_partner_rel (
    base_partner_merge_automatic_wizard_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.base_partner_merge_automatic_wizard_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_automatic_wizard_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_automatic_wizard_res_partner_rel IS 'RELATION BETWEEN base_partner_merge_automatic_wizard AND res_partner';


--
-- Name: base_partner_merge_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.base_partner_merge_line (
    id integer NOT NULL,
    wizard_id integer,
    min_id integer,
    create_uid integer,
    write_uid integer,
    aggr_ids character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.base_partner_merge_line OWNER TO runbot;

--
-- Name: TABLE base_partner_merge_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.base_partner_merge_line IS 'Merge Partner Line';


--
-- Name: COLUMN base_partner_merge_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN base_partner_merge_line.min_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.min_id IS 'MinID';


--
-- Name: COLUMN base_partner_merge_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_uid IS 'Created by';


--
-- Name: COLUMN base_partner_merge_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN base_partner_merge_line.aggr_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.aggr_ids IS 'Ids';


--
-- Name: COLUMN base_partner_merge_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.create_date IS 'Created on';


--
-- Name: COLUMN base_partner_merge_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.base_partner_merge_line.write_date IS 'Last Updated on';


--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.base_partner_merge_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNER TO runbot;

--
-- Name: base_partner_merge_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.base_partner_merge_line_id_seq OWNED BY public.base_partner_merge_line.id;


--
-- Name: bus_bus; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.bus_bus (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    channel character varying,
    message character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.bus_bus OWNER TO runbot;

--
-- Name: TABLE bus_bus; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.bus_bus IS 'Communication Bus';


--
-- Name: COLUMN bus_bus.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_uid IS 'Created by';


--
-- Name: COLUMN bus_bus.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_uid IS 'Last Updated by';


--
-- Name: COLUMN bus_bus.channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.channel IS 'Channel';


--
-- Name: COLUMN bus_bus.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.message IS 'Message';


--
-- Name: COLUMN bus_bus.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.create_date IS 'Created on';


--
-- Name: COLUMN bus_bus.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.bus_bus.write_date IS 'Last Updated on';


--
-- Name: bus_bus_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.bus_bus_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.bus_bus_id_seq OWNER TO runbot;

--
-- Name: bus_bus_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.bus_bus_id_seq OWNED BY public.bus_bus.id;


--
-- Name: change_password_own; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_own (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    new_password character varying,
    confirm_password character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_own OWNER TO runbot;

--
-- Name: TABLE change_password_own; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_own IS 'User, change own password wizard';


--
-- Name: COLUMN change_password_own.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_own.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_own.new_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.new_password IS 'New Password';


--
-- Name: COLUMN change_password_own.confirm_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.confirm_password IS 'New Password (Confirmation)';


--
-- Name: COLUMN change_password_own.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.create_date IS 'Created on';


--
-- Name: COLUMN change_password_own.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_own.write_date IS 'Last Updated on';


--
-- Name: change_password_own_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_own_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_own_id_seq OWNER TO runbot;

--
-- Name: change_password_own_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_own_id_seq OWNED BY public.change_password_own.id;


--
-- Name: change_password_user; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_user (
    id integer NOT NULL,
    wizard_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    user_login character varying,
    new_passwd character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_user OWNER TO runbot;

--
-- Name: TABLE change_password_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_user IS 'User, Change Password Wizard';


--
-- Name: COLUMN change_password_user.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.wizard_id IS 'Wizard';


--
-- Name: COLUMN change_password_user.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_id IS 'User';


--
-- Name: COLUMN change_password_user.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_user.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_user.user_login; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.user_login IS 'User Login';


--
-- Name: COLUMN change_password_user.new_passwd; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.new_passwd IS 'New Password';


--
-- Name: COLUMN change_password_user.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.create_date IS 'Created on';


--
-- Name: COLUMN change_password_user.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_user.write_date IS 'Last Updated on';


--
-- Name: change_password_user_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_user_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_user_id_seq OWNER TO runbot;

--
-- Name: change_password_user_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_user_id_seq OWNED BY public.change_password_user.id;


--
-- Name: change_password_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.change_password_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.change_password_wizard OWNER TO runbot;

--
-- Name: TABLE change_password_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.change_password_wizard IS 'Change Password Wizard';


--
-- Name: COLUMN change_password_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN change_password_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN change_password_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.create_date IS 'Created on';


--
-- Name: COLUMN change_password_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.change_password_wizard.write_date IS 'Last Updated on';


--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.change_password_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.change_password_wizard_id_seq OWNER TO runbot;

--
-- Name: change_password_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.change_password_wizard_id_seq OWNED BY public.change_password_wizard.id;


--
-- Name: decimal_precision; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.decimal_precision (
    id integer NOT NULL,
    digits integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.decimal_precision OWNER TO runbot;

--
-- Name: TABLE decimal_precision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.decimal_precision IS 'Decimal Precision';


--
-- Name: COLUMN decimal_precision.digits; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.digits IS 'Digits';


--
-- Name: COLUMN decimal_precision.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_uid IS 'Created by';


--
-- Name: COLUMN decimal_precision.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_uid IS 'Last Updated by';


--
-- Name: COLUMN decimal_precision.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.name IS 'Usage';


--
-- Name: COLUMN decimal_precision.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.create_date IS 'Created on';


--
-- Name: COLUMN decimal_precision.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.decimal_precision.write_date IS 'Last Updated on';


--
-- Name: decimal_precision_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.decimal_precision_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.decimal_precision_id_seq OWNER TO runbot;

--
-- Name: decimal_precision_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.decimal_precision_id_seq OWNED BY public.decimal_precision.id;


--
-- Name: discuss_call_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_call_history (
    id integer NOT NULL,
    channel_id integer NOT NULL,
    start_call_message_id integer,
    create_uid integer,
    write_uid integer,
    start_dt timestamp without time zone NOT NULL,
    end_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_call_history_channel_id_not_null_constraint CHECK ((channel_id IS NOT NULL)),
    CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint CHECK ((start_dt IS NOT NULL))
);


ALTER TABLE public.discuss_call_history OWNER TO runbot;

--
-- Name: TABLE discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_call_history IS 'Keep the call history';


--
-- Name: COLUMN discuss_call_history.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_call_history.start_call_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_call_message_id IS 'Start Call Message';


--
-- Name: COLUMN discuss_call_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_call_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_call_history.start_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.start_dt IS 'Start Dt';


--
-- Name: COLUMN discuss_call_history.end_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.end_dt IS 'End Dt';


--
-- Name: COLUMN discuss_call_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.create_date IS 'Created on';


--
-- Name: COLUMN discuss_call_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_call_history.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_channel_id_not_null_constraint ON public.discuss_call_history IS 'CHECK (channel_id IS NOT NULL)';


--
-- Name: CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON discuss_call_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_call_history_start_dt_is_not_null_constraint ON public.discuss_call_history IS 'CHECK (start_dt IS NOT NULL)';


--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_call_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_call_history_id_seq OWNER TO runbot;

--
-- Name: discuss_call_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_call_history_id_seq OWNED BY public.discuss_call_history.id;


--
-- Name: discuss_channel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel (
    id integer NOT NULL,
    parent_channel_id integer,
    from_message_id integer,
    group_public_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    channel_type character varying NOT NULL,
    default_display_mode character varying,
    sfu_channel_uuid character varying,
    sfu_server_url character varying,
    uuid character varying(50),
    description text,
    active boolean,
    last_interest_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    ai_agent_id integer,
    ai_env_context jsonb,
    CONSTRAINT discuss_channel_ai_channel_type_check CHECK (((ai_agent_id IS NULL) OR ((channel_type)::text = 'ai_chat'::text) OR ((channel_type)::text = 'livechat'::text))),
    CONSTRAINT discuss_channel_group_public_id_check CHECK ((((channel_type)::text = 'channel'::text) OR (group_public_id IS NULL)))
);


ALTER TABLE public.discuss_channel OWNER TO runbot;

--
-- Name: TABLE discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel IS 'Discussion Channel';


--
-- Name: COLUMN discuss_channel.parent_channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.parent_channel_id IS 'Parent Channel';


--
-- Name: COLUMN discuss_channel.from_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.from_message_id IS 'From Message';


--
-- Name: COLUMN discuss_channel.group_public_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.group_public_id IS 'Authorized Group';


--
-- Name: COLUMN discuss_channel.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.name IS 'Name';


--
-- Name: COLUMN discuss_channel.channel_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.channel_type IS 'Channel Type';


--
-- Name: COLUMN discuss_channel.default_display_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.default_display_mode IS 'Default Display Mode';


--
-- Name: COLUMN discuss_channel.sfu_channel_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_channel_uuid IS 'Sfu Channel Uuid';


--
-- Name: COLUMN discuss_channel.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.sfu_server_url IS 'Sfu Server Url';


--
-- Name: COLUMN discuss_channel.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.uuid IS 'UUID';


--
-- Name: COLUMN discuss_channel.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.description IS 'Description';


--
-- Name: COLUMN discuss_channel.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.active IS 'Active';


--
-- Name: COLUMN discuss_channel.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.write_date IS 'Last Updated on';


--
-- Name: COLUMN discuss_channel.ai_agent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_agent_id IS 'Ai Agent';


--
-- Name: COLUMN discuss_channel.ai_env_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel.ai_env_context IS 'Context for AI agent';


--
-- Name: CONSTRAINT discuss_channel_ai_channel_type_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_ai_channel_type_check ON public.discuss_channel IS 'CHECK(ai_agent_id IS NULL or channel_type = ''ai_chat'' or channel_type = ''livechat'')';


--
-- Name: CONSTRAINT discuss_channel_group_public_id_check ON discuss_channel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_group_public_id_check ON public.discuss_channel IS 'CHECK (channel_type = ''channel'' OR group_public_id IS NULL)';


--
-- Name: discuss_channel_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_id_seq OWNED BY public.discuss_channel.id;


--
-- Name: discuss_channel_member; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_member (
    id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    channel_id integer NOT NULL,
    fetched_message_id integer,
    seen_message_id integer,
    new_message_separator integer NOT NULL,
    rtc_inviting_session_id integer,
    create_uid integer,
    write_uid integer,
    custom_channel_name character varying,
    custom_notifications character varying,
    mute_until_dt timestamp without time zone,
    unpin_dt timestamp without time zone,
    last_interest_dt timestamp without time zone,
    last_seen_dt timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT discuss_channel_member_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.discuss_channel_member OWNER TO runbot;

--
-- Name: TABLE discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_member IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_member.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_member.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.guest_id IS 'Guest';


--
-- Name: COLUMN discuss_channel_member.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_member.fetched_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.fetched_message_id IS 'Last Fetched';


--
-- Name: COLUMN discuss_channel_member.seen_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.seen_message_id IS 'Last Seen';


--
-- Name: COLUMN discuss_channel_member.new_message_separator; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.new_message_separator IS 'New Message Separator';


--
-- Name: COLUMN discuss_channel_member.rtc_inviting_session_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.rtc_inviting_session_id IS 'Ringing session';


--
-- Name: COLUMN discuss_channel_member.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_member.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_member.custom_channel_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_channel_name IS 'Custom channel name';


--
-- Name: COLUMN discuss_channel_member.custom_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.custom_notifications IS 'Customized Notifications';


--
-- Name: COLUMN discuss_channel_member.mute_until_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.mute_until_dt IS 'Mute notifications until';


--
-- Name: COLUMN discuss_channel_member.unpin_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.unpin_dt IS 'Unpin date';


--
-- Name: COLUMN discuss_channel_member.last_interest_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_interest_dt IS 'Last Interest';


--
-- Name: COLUMN discuss_channel_member.last_seen_dt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.last_seen_dt IS 'Last seen date';


--
-- Name: COLUMN discuss_channel_member.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.create_date IS 'Created on';


--
-- Name: COLUMN discuss_channel_member.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_member.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT discuss_channel_member_partner_or_guest_exists ON discuss_channel_member; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT discuss_channel_member_partner_or_guest_exists ON public.discuss_channel_member IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_member_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_member_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_member_id_seq OWNED BY public.discuss_channel_member.id;


--
-- Name: discuss_channel_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_res_groups_rel (
    discuss_channel_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.discuss_channel_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE discuss_channel_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_res_groups_rel IS 'RELATION BETWEEN discuss_channel AND res_groups';


--
-- Name: discuss_channel_rtc_session; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_channel_rtc_session (
    id integer NOT NULL,
    channel_member_id integer NOT NULL,
    channel_id integer,
    partner_id integer,
    create_uid integer,
    write_uid integer,
    is_screen_sharing_on boolean,
    is_camera_on boolean,
    is_muted boolean,
    is_deaf boolean,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.discuss_channel_rtc_session OWNER TO runbot;

--
-- Name: TABLE discuss_channel_rtc_session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_channel_rtc_session IS 'Mail RTC session';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_member_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_member_id IS 'Channel Member';


--
-- Name: COLUMN discuss_channel_rtc_session.channel_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.channel_id IS 'Channel';


--
-- Name: COLUMN discuss_channel_rtc_session.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.partner_id IS 'Partner';


--
-- Name: COLUMN discuss_channel_rtc_session.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_channel_rtc_session.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_channel_rtc_session.is_screen_sharing_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_screen_sharing_on IS 'Is sharing the screen';


--
-- Name: COLUMN discuss_channel_rtc_session.is_camera_on; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_camera_on IS 'Is sending user video';


--
-- Name: COLUMN discuss_channel_rtc_session.is_muted; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_muted IS 'Is microphone muted';


--
-- Name: COLUMN discuss_channel_rtc_session.is_deaf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.is_deaf IS 'Has disabled incoming sound';


--
-- Name: COLUMN discuss_channel_rtc_session.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.write_date IS 'Last Updated On';


--
-- Name: COLUMN discuss_channel_rtc_session.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_channel_rtc_session.create_date IS 'Created on';


--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_channel_rtc_session_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNER TO runbot;

--
-- Name: discuss_channel_rtc_session_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_channel_rtc_session_id_seq OWNED BY public.discuss_channel_rtc_session.id;


--
-- Name: discuss_gif_favorite; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_gif_favorite (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    tenor_gif_id character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_gif_favorite OWNER TO runbot;

--
-- Name: TABLE discuss_gif_favorite; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_gif_favorite IS 'Save favorite GIF from Tenor API';


--
-- Name: COLUMN discuss_gif_favorite.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_gif_favorite.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_gif_favorite.tenor_gif_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.tenor_gif_id IS 'GIF id from Tenor';


--
-- Name: COLUMN discuss_gif_favorite.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.create_date IS 'Created on';


--
-- Name: COLUMN discuss_gif_favorite.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_gif_favorite.write_date IS 'Last Updated on';


--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_gif_favorite_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNER TO runbot;

--
-- Name: discuss_gif_favorite_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_gif_favorite_id_seq OWNED BY public.discuss_gif_favorite.id;


--
-- Name: discuss_voice_metadata; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.discuss_voice_metadata (
    id integer NOT NULL,
    attachment_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.discuss_voice_metadata OWNER TO runbot;

--
-- Name: TABLE discuss_voice_metadata; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.discuss_voice_metadata IS 'Metadata for voice attachments';


--
-- Name: COLUMN discuss_voice_metadata.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.attachment_id IS 'Attachment';


--
-- Name: COLUMN discuss_voice_metadata.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_uid IS 'Created by';


--
-- Name: COLUMN discuss_voice_metadata.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_uid IS 'Last Updated by';


--
-- Name: COLUMN discuss_voice_metadata.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.create_date IS 'Created on';


--
-- Name: COLUMN discuss_voice_metadata.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.discuss_voice_metadata.write_date IS 'Last Updated on';


--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.discuss_voice_metadata_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNER TO runbot;

--
-- Name: discuss_voice_metadata_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.discuss_voice_metadata_id_seq OWNED BY public.discuss_voice_metadata.id;


--
-- Name: email_template_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.email_template_attachment_rel (
    email_template_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.email_template_attachment_rel OWNER TO runbot;

--
-- Name: TABLE email_template_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.email_template_attachment_rel IS 'RELATION BETWEEN mail_template AND ir_attachment';


--
-- Name: fetchmail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.fetchmail_server (
    id integer NOT NULL,
    port integer,
    object_id integer,
    priority integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    state character varying,
    server character varying,
    server_type character varying NOT NULL,
    "user" character varying,
    password character varying,
    script character varying,
    error_message text,
    configuration text,
    active boolean,
    is_ssl boolean,
    attach boolean,
    original boolean,
    date timestamp without time zone,
    error_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    microsoft_outlook_access_token_expiration integer,
    microsoft_outlook_refresh_token character varying,
    microsoft_outlook_access_token character varying
);


ALTER TABLE public.fetchmail_server OWNER TO runbot;

--
-- Name: TABLE fetchmail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.fetchmail_server IS 'Incoming Mail Server';


--
-- Name: COLUMN fetchmail_server.port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.port IS 'Port';


--
-- Name: COLUMN fetchmail_server.object_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.object_id IS 'Create a New Record';


--
-- Name: COLUMN fetchmail_server.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.priority IS 'Server Priority';


--
-- Name: COLUMN fetchmail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_uid IS 'Created by';


--
-- Name: COLUMN fetchmail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN fetchmail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.name IS 'Name';


--
-- Name: COLUMN fetchmail_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.state IS 'Status';


--
-- Name: COLUMN fetchmail_server.server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server IS 'Server Name';


--
-- Name: COLUMN fetchmail_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.server_type IS 'Server Type';


--
-- Name: COLUMN fetchmail_server."user"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server."user" IS 'Username';


--
-- Name: COLUMN fetchmail_server.password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.password IS 'Password';


--
-- Name: COLUMN fetchmail_server.script; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.script IS 'Script';


--
-- Name: COLUMN fetchmail_server.error_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_message IS 'Last Error Message';


--
-- Name: COLUMN fetchmail_server.configuration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.configuration IS 'Configuration';


--
-- Name: COLUMN fetchmail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.active IS 'Active';


--
-- Name: COLUMN fetchmail_server.is_ssl; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.is_ssl IS 'SSL/TLS';


--
-- Name: COLUMN fetchmail_server.attach; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.attach IS 'Keep Attachments';


--
-- Name: COLUMN fetchmail_server.original; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.original IS 'Keep Original';


--
-- Name: COLUMN fetchmail_server.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.date IS 'Last Fetch Date';


--
-- Name: COLUMN fetchmail_server.error_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.error_date IS 'Last Error Date';


--
-- Name: COLUMN fetchmail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.create_date IS 'Created on';


--
-- Name: COLUMN fetchmail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN fetchmail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token_expiration IS 'Outlook Access Token Expiration Timestamp';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_refresh_token IS 'Outlook Refresh Token';


--
-- Name: COLUMN fetchmail_server.microsoft_outlook_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.fetchmail_server.microsoft_outlook_access_token IS 'Outlook Access Token';


--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.fetchmail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.fetchmail_server_id_seq OWNER TO runbot;

--
-- Name: fetchmail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.fetchmail_server_id_seq OWNED BY public.fetchmail_server.id;


--
-- Name: html_editor_converter_test; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.html_editor_converter_test (
    id integer NOT NULL,
    "integer" integer,
    many2one integer,
    create_uid integer,
    write_uid integer,
    "char" character varying,
    selection_str character varying,
    date date,
    html text,
    text text,
    "numeric" numeric,
    datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    "float" double precision,
    "binary" bytea
);


ALTER TABLE public.html_editor_converter_test OWNER TO runbot;

--
-- Name: TABLE html_editor_converter_test; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.html_editor_converter_test IS 'Html Editor Converter Test';


--
-- Name: COLUMN html_editor_converter_test."integer"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."integer" IS 'Integer';


--
-- Name: COLUMN html_editor_converter_test.many2one; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.many2one IS 'Many2One';


--
-- Name: COLUMN html_editor_converter_test.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.create_uid IS 'Created by';


--
-- Name: COLUMN html_editor_converter_test.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.write_uid IS 'Last Updated by';


--
-- Name: COLUMN html_editor_converter_test."char"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."char" IS 'Char';


--
-- Name: COLUMN html_editor_converter_test.selection_str; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.selection_str IS 'Lorsqu''un pancake prend l''avion à destination de Toronto et qu''il fait une escale technique à St Claude, on dit:';


--
-- Name: COLUMN html_editor_converter_test.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.date IS 'Date';


--
-- Name: COLUMN html_editor_converter_test.html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.html IS 'Html';


--
-- Name: COLUMN html_editor_converter_test.text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.text IS 'Text';


--
-- Name: COLUMN html_editor_converter_test."numeric"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."numeric" IS 'Numeric';


--
-- Name: COLUMN html_editor_converter_test.datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.datetime IS 'Datetime';


--
-- Name: COLUMN html_editor_converter_test.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.create_date IS 'Created on';


--
-- Name: COLUMN html_editor_converter_test.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test.write_date IS 'Last Updated on';


--
-- Name: COLUMN html_editor_converter_test."float"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."float" IS 'Float';


--
-- Name: COLUMN html_editor_converter_test."binary"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test."binary" IS 'Binary';


--
-- Name: html_editor_converter_test_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.html_editor_converter_test_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.html_editor_converter_test_id_seq OWNER TO runbot;

--
-- Name: html_editor_converter_test_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.html_editor_converter_test_id_seq OWNED BY public.html_editor_converter_test.id;


--
-- Name: html_editor_converter_test_sub; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.html_editor_converter_test_sub (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.html_editor_converter_test_sub OWNER TO runbot;

--
-- Name: TABLE html_editor_converter_test_sub; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.html_editor_converter_test_sub IS 'Html Editor Converter Subtest';


--
-- Name: COLUMN html_editor_converter_test_sub.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.create_uid IS 'Created by';


--
-- Name: COLUMN html_editor_converter_test_sub.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.write_uid IS 'Last Updated by';


--
-- Name: COLUMN html_editor_converter_test_sub.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.name IS 'Name';


--
-- Name: COLUMN html_editor_converter_test_sub.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.create_date IS 'Created on';


--
-- Name: COLUMN html_editor_converter_test_sub.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.html_editor_converter_test_sub.write_date IS 'Last Updated on';


--
-- Name: html_editor_converter_test_sub_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.html_editor_converter_test_sub_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.html_editor_converter_test_sub_id_seq OWNER TO runbot;

--
-- Name: html_editor_converter_test_sub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.html_editor_converter_test_sub_id_seq OWNED BY public.html_editor_converter_test_sub.id;


--
-- Name: iap_account; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account (
    id integer NOT NULL,
    service_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    account_token character varying(43),
    balance character varying,
    state character varying,
    service_locked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    warning_threshold double precision,
    sender_name character varying
);


ALTER TABLE public.iap_account OWNER TO runbot;

--
-- Name: TABLE iap_account; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account IS 'IAP Account';


--
-- Name: COLUMN iap_account.service_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_id IS 'Service';


--
-- Name: COLUMN iap_account.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_uid IS 'Created by';


--
-- Name: COLUMN iap_account.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_account.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.name IS 'Name';


--
-- Name: COLUMN iap_account.account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.account_token IS 'Account Token';


--
-- Name: COLUMN iap_account.balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.balance IS 'Balance';


--
-- Name: COLUMN iap_account.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.state IS 'State';


--
-- Name: COLUMN iap_account.service_locked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.service_locked IS 'Service Locked';


--
-- Name: COLUMN iap_account.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.create_date IS 'Created on';


--
-- Name: COLUMN iap_account.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.write_date IS 'Last Updated on';


--
-- Name: COLUMN iap_account.warning_threshold; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.warning_threshold IS 'Email Alert Threshold';


--
-- Name: COLUMN iap_account.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_account.sender_name IS 'Sender Name';


--
-- Name: iap_account_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_account_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_account_id_seq OWNER TO runbot;

--
-- Name: iap_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_account_id_seq OWNED BY public.iap_account.id;


--
-- Name: iap_account_res_company_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_company_rel (
    iap_account_id integer NOT NULL,
    res_company_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_company_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_company_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_company_rel IS 'RELATION BETWEEN iap_account AND res_company';


--
-- Name: iap_account_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_account_res_users_rel (
    iap_account_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.iap_account_res_users_rel OWNER TO runbot;

--
-- Name: TABLE iap_account_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_account_res_users_rel IS 'RELATION BETWEEN iap_account AND res_users';


--
-- Name: iap_service; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.iap_service (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    technical_name character varying NOT NULL,
    description jsonb NOT NULL,
    unit_name jsonb NOT NULL,
    integer_balance boolean NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.iap_service OWNER TO runbot;

--
-- Name: TABLE iap_service; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.iap_service IS 'IAP Service';


--
-- Name: COLUMN iap_service.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_uid IS 'Created by';


--
-- Name: COLUMN iap_service.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_uid IS 'Last Updated by';


--
-- Name: COLUMN iap_service.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.name IS 'Name';


--
-- Name: COLUMN iap_service.technical_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.technical_name IS 'Technical Name';


--
-- Name: COLUMN iap_service.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.description IS 'Description';


--
-- Name: COLUMN iap_service.unit_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.unit_name IS 'Unit Name';


--
-- Name: COLUMN iap_service.integer_balance; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.integer_balance IS 'Integer Balance';


--
-- Name: COLUMN iap_service.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.create_date IS 'Created on';


--
-- Name: COLUMN iap_service.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.iap_service.write_date IS 'Last Updated on';


--
-- Name: iap_service_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.iap_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.iap_service_id_seq OWNER TO runbot;

--
-- Name: iap_service_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.iap_service_id_seq OWNED BY public.iap_service.id;


--
-- Name: ir_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions (
    id integer NOT NULL,
    binding_model_id integer,
    create_uid integer,
    write_uid integer,
    type character varying NOT NULL,
    path character varying,
    binding_type character varying NOT NULL,
    binding_view_types character varying,
    name jsonb NOT NULL,
    help jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions OWNER TO runbot;

--
-- Name: COLUMN ir_actions.binding_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_model_id IS 'Binding Model';


--
-- Name: COLUMN ir_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.type IS 'Action Type';


--
-- Name: COLUMN ir_actions.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.path IS 'Path to show in the URL';


--
-- Name: COLUMN ir_actions.binding_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_type IS 'Binding Type';


--
-- Name: COLUMN ir_actions.binding_view_types; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.binding_view_types IS 'Binding View Types';


--
-- Name: COLUMN ir_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.name IS 'Action Name';


--
-- Name: COLUMN ir_actions.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.help IS 'Action Description';


--
-- Name: COLUMN ir_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions.write_date IS 'Last Updated on';


--
-- Name: ir_act_client; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_client (
    tag character varying NOT NULL,
    target character varying,
    res_model character varying,
    context character varying NOT NULL,
    params_store bytea
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_client OWNER TO runbot;

--
-- Name: COLUMN ir_act_client.tag; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.tag IS 'Client action tag';


--
-- Name: COLUMN ir_act_client.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.target IS 'Target Window';


--
-- Name: COLUMN ir_act_client.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_client.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.context IS 'Context Value';


--
-- Name: COLUMN ir_act_client.params_store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_client.params_store IS 'Params storage';


--
-- Name: ir_act_report_xml; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_report_xml (
    paperformat_id integer,
    model character varying NOT NULL,
    report_type character varying NOT NULL,
    report_name character varying NOT NULL,
    report_file character varying,
    attachment character varying,
    domain character varying,
    print_report_name jsonb,
    multi boolean,
    attachment_use boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_report_xml OWNER TO runbot;

--
-- Name: COLUMN ir_act_report_xml.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.paperformat_id IS 'Paper Format';


--
-- Name: COLUMN ir_act_report_xml.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.model IS 'Model Name';


--
-- Name: COLUMN ir_act_report_xml.report_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_type IS 'Report Type';


--
-- Name: COLUMN ir_act_report_xml.report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_name IS 'Template Name';


--
-- Name: COLUMN ir_act_report_xml.report_file; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.report_file IS 'Report File';


--
-- Name: COLUMN ir_act_report_xml.attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment IS 'Save as Attachment Prefix';


--
-- Name: COLUMN ir_act_report_xml.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.domain IS 'Filter domain';


--
-- Name: COLUMN ir_act_report_xml.print_report_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.print_report_name IS 'Printed Report Name';


--
-- Name: COLUMN ir_act_report_xml.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_report_xml.attachment_use; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_report_xml.attachment_use IS 'Reload from Attachment';


--
-- Name: ir_act_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server (
    sequence integer,
    model_id integer NOT NULL,
    parent_id integer,
    crud_model_id integer,
    link_field_id integer,
    update_field_id integer,
    update_related_model_id integer,
    sequence_id integer,
    selection_value integer,
    automated_name character varying,
    usage character varying NOT NULL,
    state character varying NOT NULL,
    update_path character varying,
    update_m2m_operation character varying,
    update_boolean_value character varying,
    evaluation_type character varying,
    resource_ref character varying,
    webhook_url character varying,
    code text,
    value text,
    html_value text,
    activity_user_id integer,
    activity_type_id integer,
    template_id integer,
    activity_date_deadline_range integer,
    activity_summary character varying,
    followers_type character varying,
    followers_partner_field_name character varying,
    mail_post_method character varying,
    activity_date_deadline_range_type character varying,
    activity_user_type character varying,
    activity_user_field_name character varying,
    activity_note text,
    mail_post_autofollow boolean,
    sms_template_id integer,
    sms_method character varying,
    ai_tool_description jsonb,
    ai_action_prompt text,
    ai_tool_schema text,
    use_in_ai boolean,
    ai_tool_allow_end_message boolean,
    ai_update_prompt text
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_server OWNER TO runbot;

--
-- Name: COLUMN ir_act_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_server.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.model_id IS 'Model';


--
-- Name: COLUMN ir_act_server.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.parent_id IS 'Parent Action';


--
-- Name: COLUMN ir_act_server.crud_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.crud_model_id IS 'Record to Create';


--
-- Name: COLUMN ir_act_server.link_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.link_field_id IS 'Link Field';


--
-- Name: COLUMN ir_act_server.update_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_field_id IS 'Field to Update';


--
-- Name: COLUMN ir_act_server.update_related_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_related_model_id IS 'Update Related Model';


--
-- Name: COLUMN ir_act_server.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sequence_id IS 'Sequence to use';


--
-- Name: COLUMN ir_act_server.selection_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.selection_value IS 'Custom Value';


--
-- Name: COLUMN ir_act_server.automated_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.automated_name IS 'Automated Name';


--
-- Name: COLUMN ir_act_server.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.usage IS 'Usage';


--
-- Name: COLUMN ir_act_server.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.state IS 'Type';


--
-- Name: COLUMN ir_act_server.update_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_path IS 'Field to Update Path';


--
-- Name: COLUMN ir_act_server.update_m2m_operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_m2m_operation IS 'Many2many Operations';


--
-- Name: COLUMN ir_act_server.update_boolean_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.update_boolean_value IS 'Boolean Value';


--
-- Name: COLUMN ir_act_server.evaluation_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.evaluation_type IS 'Value Type';


--
-- Name: COLUMN ir_act_server.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.resource_ref IS 'Record';


--
-- Name: COLUMN ir_act_server.webhook_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.webhook_url IS 'Webhook URL';


--
-- Name: COLUMN ir_act_server.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.code IS 'Python Code';


--
-- Name: COLUMN ir_act_server.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.value IS 'Value';


--
-- Name: COLUMN ir_act_server.html_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.html_value IS 'Html Value';


--
-- Name: COLUMN ir_act_server.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_id IS 'Responsible';


--
-- Name: COLUMN ir_act_server.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN ir_act_server.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.template_id IS 'Email Template';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range IS 'Due Date In';


--
-- Name: COLUMN ir_act_server.activity_summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_summary IS 'Title';


--
-- Name: COLUMN ir_act_server.followers_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.followers_type IS 'Followers Type';


--
-- Name: COLUMN ir_act_server.followers_partner_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.followers_partner_field_name IS 'Followers Field';


--
-- Name: COLUMN ir_act_server.mail_post_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_method IS 'Send Email As';


--
-- Name: COLUMN ir_act_server.activity_date_deadline_range_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_date_deadline_range_type IS 'Due type';


--
-- Name: COLUMN ir_act_server.activity_user_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_type IS 'User Type';


--
-- Name: COLUMN ir_act_server.activity_user_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_user_field_name IS 'User Field';


--
-- Name: COLUMN ir_act_server.activity_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.activity_note IS 'Note';


--
-- Name: COLUMN ir_act_server.mail_post_autofollow; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.mail_post_autofollow IS 'Subscribe Recipients';


--
-- Name: COLUMN ir_act_server.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_template_id IS 'SMS Template';


--
-- Name: COLUMN ir_act_server.sms_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.sms_method IS 'Send SMS As';


--
-- Name: COLUMN ir_act_server.ai_tool_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_description IS 'AI Tool Description';


--
-- Name: COLUMN ir_act_server.ai_action_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_action_prompt IS 'AI Action Prompt';


--
-- Name: COLUMN ir_act_server.ai_tool_schema; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_schema IS 'AI Schema';


--
-- Name: COLUMN ir_act_server.use_in_ai; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.use_in_ai IS 'Use in AI';


--
-- Name: COLUMN ir_act_server.ai_tool_allow_end_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_tool_allow_end_message IS 'Allow End Message';


--
-- Name: COLUMN ir_act_server.ai_update_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_server.ai_update_prompt IS 'AI Update Prompt';


--
-- Name: ir_act_server_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_server_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_group_rel IS 'RELATION BETWEEN ir_act_server AND res_groups';


--
-- Name: ir_act_server_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_res_partner_rel (
    ir_act_server_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_res_partner_rel IS 'RELATION BETWEEN ir_act_server AND res_partner';


--
-- Name: ir_act_server_webhook_field_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_server_webhook_field_rel (
    server_id integer NOT NULL,
    field_id integer NOT NULL
);


ALTER TABLE public.ir_act_server_webhook_field_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_server_webhook_field_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_server_webhook_field_rel IS 'RELATION BETWEEN ir_act_server AND ir_model_fields';


--
-- Name: ir_act_url; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_url (
    target character varying NOT NULL,
    url text NOT NULL
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_url OWNER TO runbot;

--
-- Name: COLUMN ir_act_url.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.target IS 'Action Target';


--
-- Name: COLUMN ir_act_url.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_url.url IS 'Action URL';


--
-- Name: ir_act_window; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window (
    view_id integer,
    res_id integer,
    "limit" integer,
    search_view_id integer,
    domain character varying,
    context character varying NOT NULL,
    res_model character varying NOT NULL,
    target character varying,
    view_mode character varying NOT NULL,
    mobile_view_mode character varying,
    usage character varying,
    filter boolean,
    cache boolean
)
INHERITS (public.ir_actions);


ALTER TABLE public.ir_act_window OWNER TO runbot;

--
-- Name: COLUMN ir_act_window.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_id IS 'View Ref.';


--
-- Name: COLUMN ir_act_window.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_id IS 'Record ID';


--
-- Name: COLUMN ir_act_window."limit"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window."limit" IS 'Limit';


--
-- Name: COLUMN ir_act_window.search_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.search_view_id IS 'Search View Ref.';


--
-- Name: COLUMN ir_act_window.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.domain IS 'Domain Value';


--
-- Name: COLUMN ir_act_window.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.context IS 'Context Value';


--
-- Name: COLUMN ir_act_window.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.res_model IS 'Destination Model';


--
-- Name: COLUMN ir_act_window.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.target IS 'Target Window';


--
-- Name: COLUMN ir_act_window.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.view_mode IS 'View Mode';


--
-- Name: COLUMN ir_act_window.mobile_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.mobile_view_mode IS 'Mobile View Mode';


--
-- Name: COLUMN ir_act_window.usage; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.usage IS 'Action Usage';


--
-- Name: COLUMN ir_act_window.filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.filter IS 'Filter';


--
-- Name: COLUMN ir_act_window.cache; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window.cache IS 'Data Caching';


--
-- Name: ir_act_window_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_group_rel (
    act_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_act_window_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_act_window_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_group_rel IS 'RELATION BETWEEN ir_act_window AND res_groups';


--
-- Name: ir_act_window_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_act_window_view (
    id integer NOT NULL,
    sequence integer,
    view_id integer,
    act_window_id integer,
    create_uid integer,
    write_uid integer,
    view_mode character varying NOT NULL,
    multi boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_act_window_view OWNER TO runbot;

--
-- Name: TABLE ir_act_window_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_act_window_view IS 'Action Window View';


--
-- Name: COLUMN ir_act_window_view.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.sequence IS 'Sequence';


--
-- Name: COLUMN ir_act_window_view.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_id IS 'View';


--
-- Name: COLUMN ir_act_window_view.act_window_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.act_window_id IS 'Action';


--
-- Name: COLUMN ir_act_window_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_act_window_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_act_window_view.view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.view_mode IS 'View Type';


--
-- Name: COLUMN ir_act_window_view.multi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.multi IS 'On Multiple Doc.';


--
-- Name: COLUMN ir_act_window_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_act_window_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_act_window_view.write_date IS 'Last Updated on';


--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_act_window_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_act_window_view_id_seq OWNER TO runbot;

--
-- Name: ir_act_window_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_act_window_view_id_seq OWNED BY public.ir_act_window_view.id;


--
-- Name: ir_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_id_seq OWNER TO runbot;

--
-- Name: ir_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_id_seq OWNED BY public.ir_actions.id;


--
-- Name: ir_actions_server_history; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_server_history (
    id integer NOT NULL,
    action_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_server_history OWNER TO runbot;

--
-- Name: TABLE ir_actions_server_history; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_server_history IS 'Server Action History';


--
-- Name: COLUMN ir_actions_server_history.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_server_history.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_server_history.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_server_history.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.code IS 'Code';


--
-- Name: COLUMN ir_actions_server_history.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_server_history.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_server_history.write_date IS 'Last Updated on';


--
-- Name: ir_actions_server_history_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_server_history_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_server_history_id_seq OWNER TO runbot;

--
-- Name: ir_actions_server_history_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_server_history_id_seq OWNED BY public.ir_actions_server_history.id;


--
-- Name: ir_actions_todo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_actions_todo (
    id integer NOT NULL,
    action_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_actions_todo OWNER TO runbot;

--
-- Name: TABLE ir_actions_todo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_actions_todo IS 'Configuration Wizards';


--
-- Name: COLUMN ir_actions_todo.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.action_id IS 'Action';


--
-- Name: COLUMN ir_actions_todo.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.sequence IS 'Sequence';


--
-- Name: COLUMN ir_actions_todo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_actions_todo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_actions_todo.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.state IS 'Status';


--
-- Name: COLUMN ir_actions_todo.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.name IS 'Name';


--
-- Name: COLUMN ir_actions_todo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.create_date IS 'Created on';


--
-- Name: COLUMN ir_actions_todo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_actions_todo.write_date IS 'Last Updated on';


--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_actions_todo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_actions_todo_id_seq OWNER TO runbot;

--
-- Name: ir_actions_todo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_actions_todo_id_seq OWNED BY public.ir_actions_todo.id;


--
-- Name: ir_asset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_asset (
    id integer NOT NULL,
    sequence integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bundle character varying NOT NULL,
    directive character varying,
    path character varying NOT NULL,
    target character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_asset OWNER TO runbot;

--
-- Name: TABLE ir_asset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_asset IS 'Asset';


--
-- Name: COLUMN ir_asset.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.sequence IS 'Sequence';


--
-- Name: COLUMN ir_asset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_uid IS 'Created by';


--
-- Name: COLUMN ir_asset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_asset.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.name IS 'Name';


--
-- Name: COLUMN ir_asset.bundle; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.bundle IS 'Bundle name';


--
-- Name: COLUMN ir_asset.directive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.directive IS 'Directive';


--
-- Name: COLUMN ir_asset.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.path IS 'Path (or glob pattern)';


--
-- Name: COLUMN ir_asset.target; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.target IS 'Target';


--
-- Name: COLUMN ir_asset.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.active IS 'active';


--
-- Name: COLUMN ir_asset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.create_date IS 'Created on';


--
-- Name: COLUMN ir_asset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_asset.write_date IS 'Last Updated on';


--
-- Name: ir_asset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_asset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_asset_id_seq OWNER TO runbot;

--
-- Name: ir_asset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_asset_id_seq OWNED BY public.ir_asset.id;


--
-- Name: ir_attachment; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_attachment (
    id integer NOT NULL,
    res_id integer,
    company_id integer,
    file_size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying,
    res_field character varying,
    type character varying NOT NULL,
    url character varying(1024),
    access_token character varying,
    store_fname character varying,
    checksum character varying(40),
    mimetype character varying,
    description text,
    index_content text,
    public boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    db_datas bytea,
    original_id integer
);


ALTER TABLE public.ir_attachment OWNER TO runbot;

--
-- Name: TABLE ir_attachment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_attachment IS 'Attachment';


--
-- Name: COLUMN ir_attachment.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_id IS 'Resource ID';


--
-- Name: COLUMN ir_attachment.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.company_id IS 'Company';


--
-- Name: COLUMN ir_attachment.file_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.file_size IS 'File Size';


--
-- Name: COLUMN ir_attachment.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_uid IS 'Created by';


--
-- Name: COLUMN ir_attachment.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_attachment.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.name IS 'Name';


--
-- Name: COLUMN ir_attachment.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_model IS 'Resource Model';


--
-- Name: COLUMN ir_attachment.res_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.res_field IS 'Resource Field';


--
-- Name: COLUMN ir_attachment.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.type IS 'Type';


--
-- Name: COLUMN ir_attachment.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.url IS 'Url';


--
-- Name: COLUMN ir_attachment.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.access_token IS 'Access Token';


--
-- Name: COLUMN ir_attachment.store_fname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.store_fname IS 'Stored Filename';


--
-- Name: COLUMN ir_attachment.checksum; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.checksum IS 'Checksum/SHA1';


--
-- Name: COLUMN ir_attachment.mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.mimetype IS 'Mime Type';


--
-- Name: COLUMN ir_attachment.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.description IS 'Description';


--
-- Name: COLUMN ir_attachment.index_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.index_content IS 'Indexed Content';


--
-- Name: COLUMN ir_attachment.public; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.public IS 'Is public document';


--
-- Name: COLUMN ir_attachment.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.create_date IS 'Created on';


--
-- Name: COLUMN ir_attachment.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_attachment.db_datas; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.db_datas IS 'Database Data';


--
-- Name: COLUMN ir_attachment.original_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_attachment.original_id IS 'Original (unoptimized, unresized) attachment';


--
-- Name: ir_attachment_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_attachment_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_attachment_id_seq OWNER TO runbot;

--
-- Name: ir_attachment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_attachment_id_seq OWNED BY public.ir_attachment.id;


--
-- Name: ir_config_parameter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_config_parameter (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    key character varying NOT NULL,
    value text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_config_parameter OWNER TO runbot;

--
-- Name: TABLE ir_config_parameter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_config_parameter IS 'System Parameter';


--
-- Name: COLUMN ir_config_parameter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_uid IS 'Created by';


--
-- Name: COLUMN ir_config_parameter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_config_parameter.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.key IS 'Key';


--
-- Name: COLUMN ir_config_parameter.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.value IS 'Value';


--
-- Name: COLUMN ir_config_parameter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.create_date IS 'Created on';


--
-- Name: COLUMN ir_config_parameter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_config_parameter.write_date IS 'Last Updated on';


--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_config_parameter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_config_parameter_id_seq OWNER TO runbot;

--
-- Name: ir_config_parameter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_config_parameter_id_seq OWNED BY public.ir_config_parameter.id;


--
-- Name: ir_cron; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron (
    id integer NOT NULL,
    ir_actions_server_id integer NOT NULL,
    user_id integer NOT NULL,
    interval_number integer NOT NULL,
    priority integer,
    failure_count integer,
    create_uid integer,
    write_uid integer,
    cron_name character varying,
    interval_type character varying NOT NULL,
    active boolean,
    nextcall timestamp without time zone NOT NULL,
    lastcall timestamp without time zone,
    first_failure_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_cron_check_strictly_positive_interval CHECK ((interval_number > 0))
);


ALTER TABLE public.ir_cron OWNER TO runbot;

--
-- Name: TABLE ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron IS 'Scheduled Actions';


--
-- Name: COLUMN ir_cron.ir_actions_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.ir_actions_server_id IS 'Server action';


--
-- Name: COLUMN ir_cron.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.user_id IS 'Scheduler User';


--
-- Name: COLUMN ir_cron.interval_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_number IS 'Interval Number';


--
-- Name: COLUMN ir_cron.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.priority IS 'Priority';


--
-- Name: COLUMN ir_cron.failure_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.failure_count IS 'Failure Count';


--
-- Name: COLUMN ir_cron.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron.cron_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.cron_name IS 'Name';


--
-- Name: COLUMN ir_cron.interval_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.interval_type IS 'Interval Unit';


--
-- Name: COLUMN ir_cron.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.active IS 'Active';


--
-- Name: COLUMN ir_cron.nextcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.nextcall IS 'Next Execution Date';


--
-- Name: COLUMN ir_cron.lastcall; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.lastcall IS 'Last Execution Date';


--
-- Name: COLUMN ir_cron.first_failure_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.first_failure_date IS 'First Failure Date';


--
-- Name: COLUMN ir_cron.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_cron_check_strictly_positive_interval ON ir_cron; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_cron_check_strictly_positive_interval ON public.ir_cron IS 'CHECK(interval_number > 0)';


--
-- Name: ir_cron_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_id_seq OWNER TO runbot;

--
-- Name: ir_cron_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_id_seq OWNED BY public.ir_cron.id;


--
-- Name: ir_cron_progress; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_progress (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    remaining integer,
    done integer,
    timed_out_counter integer,
    create_uid integer,
    write_uid integer,
    deactivate boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_progress OWNER TO runbot;

--
-- Name: TABLE ir_cron_progress; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_progress IS 'Progress of Scheduled Actions';


--
-- Name: COLUMN ir_cron_progress.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_progress.remaining; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.remaining IS 'Remaining';


--
-- Name: COLUMN ir_cron_progress.done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.done IS 'Done';


--
-- Name: COLUMN ir_cron_progress.timed_out_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.timed_out_counter IS 'Timed Out Counter';


--
-- Name: COLUMN ir_cron_progress.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_progress.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_progress.deactivate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.deactivate IS 'Deactivate';


--
-- Name: COLUMN ir_cron_progress.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_progress.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_progress.write_date IS 'Last Updated on';


--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_progress_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_progress_id_seq OWNER TO runbot;

--
-- Name: ir_cron_progress_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_progress_id_seq OWNED BY public.ir_cron_progress.id;


--
-- Name: ir_cron_trigger; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_cron_trigger (
    id integer NOT NULL,
    cron_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    call_at timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_cron_trigger OWNER TO runbot;

--
-- Name: TABLE ir_cron_trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_cron_trigger IS 'Triggered actions';


--
-- Name: COLUMN ir_cron_trigger.cron_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.cron_id IS 'Cron';


--
-- Name: COLUMN ir_cron_trigger.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_uid IS 'Created by';


--
-- Name: COLUMN ir_cron_trigger.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_cron_trigger.call_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.call_at IS 'Call At';


--
-- Name: COLUMN ir_cron_trigger.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.create_date IS 'Created on';


--
-- Name: COLUMN ir_cron_trigger.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_cron_trigger.write_date IS 'Last Updated on';


--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_cron_trigger_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNER TO runbot;

--
-- Name: ir_cron_trigger_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_cron_trigger_id_seq OWNED BY public.ir_cron_trigger.id;


--
-- Name: ir_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_default (
    id integer NOT NULL,
    field_id integer NOT NULL,
    user_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    condition character varying,
    "json_value" character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_default OWNER TO runbot;

--
-- Name: TABLE ir_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_default IS 'Default Values';


--
-- Name: COLUMN ir_default.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.field_id IS 'Field';


--
-- Name: COLUMN ir_default.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.user_id IS 'User';


--
-- Name: COLUMN ir_default.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.company_id IS 'Company';


--
-- Name: COLUMN ir_default.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_uid IS 'Created by';


--
-- Name: COLUMN ir_default.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_default.condition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.condition IS 'Condition';


--
-- Name: COLUMN ir_default."json_value"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default."json_value" IS 'Default Value (JSON format)';


--
-- Name: COLUMN ir_default.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.create_date IS 'Created on';


--
-- Name: COLUMN ir_default.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_default.write_date IS 'Last Updated on';


--
-- Name: ir_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_default_id_seq OWNER TO runbot;

--
-- Name: ir_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_default_id_seq OWNED BY public.ir_default.id;


--
-- Name: ir_demo; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo OWNER TO runbot;

--
-- Name: TABLE ir_demo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo IS 'Demo';


--
-- Name: COLUMN ir_demo.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure (
    id integer NOT NULL,
    module_id integer NOT NULL,
    wizard_id integer,
    create_uid integer,
    write_uid integer,
    error character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure IS 'Demo failure';


--
-- Name: COLUMN ir_demo_failure.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.module_id IS 'Module';


--
-- Name: COLUMN ir_demo_failure.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.wizard_id IS 'Wizard';


--
-- Name: COLUMN ir_demo_failure.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure.error; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.error IS 'Error';


--
-- Name: COLUMN ir_demo_failure.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_id_seq OWNED BY public.ir_demo_failure.id;


--
-- Name: ir_demo_failure_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_demo_failure_wizard (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_demo_failure_wizard OWNER TO runbot;

--
-- Name: TABLE ir_demo_failure_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_demo_failure_wizard IS 'Demo Failure wizard';


--
-- Name: COLUMN ir_demo_failure_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN ir_demo_failure_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_demo_failure_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.create_date IS 'Created on';


--
-- Name: COLUMN ir_demo_failure_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_demo_failure_wizard.write_date IS 'Last Updated on';


--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_failure_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNER TO runbot;

--
-- Name: ir_demo_failure_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_failure_wizard_id_seq OWNED BY public.ir_demo_failure_wizard.id;


--
-- Name: ir_demo_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_demo_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_demo_id_seq OWNER TO runbot;

--
-- Name: ir_demo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_demo_id_seq OWNED BY public.ir_demo.id;


--
-- Name: ir_embedded_actions; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions (
    id integer NOT NULL,
    sequence integer,
    parent_action_id integer NOT NULL,
    parent_res_id integer,
    action_id integer,
    user_id integer,
    create_uid integer,
    write_uid integer,
    parent_res_model character varying NOT NULL,
    python_method character varying,
    default_view_mode character varying,
    domain character varying,
    context character varying,
    name jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_embedded_actions_check_only_one_action_defined CHECK ((((action_id IS NOT NULL) AND (python_method IS NULL)) OR ((action_id IS NULL) AND (python_method IS NOT NULL)))),
    CONSTRAINT ir_embedded_actions_check_python_method_requires_name CHECK ((NOT ((python_method IS NOT NULL) AND (name IS NULL))))
);


ALTER TABLE public.ir_embedded_actions OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions IS 'Embedded Actions';


--
-- Name: COLUMN ir_embedded_actions.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.sequence IS 'Sequence';


--
-- Name: COLUMN ir_embedded_actions.parent_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_action_id IS 'Parent Action';


--
-- Name: COLUMN ir_embedded_actions.parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_id IS 'Active Parent Id';


--
-- Name: COLUMN ir_embedded_actions.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.action_id IS 'Action';


--
-- Name: COLUMN ir_embedded_actions.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.user_id IS 'User';


--
-- Name: COLUMN ir_embedded_actions.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_uid IS 'Created by';


--
-- Name: COLUMN ir_embedded_actions.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_embedded_actions.parent_res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.parent_res_model IS 'Active Parent Model';


--
-- Name: COLUMN ir_embedded_actions.python_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.python_method IS 'Python Method';


--
-- Name: COLUMN ir_embedded_actions.default_view_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.default_view_mode IS 'Default View';


--
-- Name: COLUMN ir_embedded_actions.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.domain IS 'Domain';


--
-- Name: COLUMN ir_embedded_actions.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.context IS 'Context';


--
-- Name: COLUMN ir_embedded_actions.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.name IS 'Name';


--
-- Name: COLUMN ir_embedded_actions.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.create_date IS 'Created on';


--
-- Name: COLUMN ir_embedded_actions.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_embedded_actions.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_only_one_action_defined ON public.ir_embedded_actions IS 'CHECK(
            (action_id IS NOT NULL AND python_method IS NULL)
            OR (action_id IS NULL AND python_method IS NOT NULL)
        )';


--
-- Name: CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON ir_embedded_actions; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_embedded_actions_check_python_method_requires_name ON public.ir_embedded_actions IS 'CHECK(NOT (python_method IS NOT NULL AND name IS NULL))';


--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_embedded_actions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNER TO runbot;

--
-- Name: ir_embedded_actions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_embedded_actions_id_seq OWNED BY public.ir_embedded_actions.id;


--
-- Name: ir_embedded_actions_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_embedded_actions_res_groups_rel (
    ir_embedded_actions_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.ir_embedded_actions_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE ir_embedded_actions_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_embedded_actions_res_groups_rel IS 'RELATION BETWEEN ir_embedded_actions AND res_groups';


--
-- Name: ir_exports; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    resource character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports OWNER TO runbot;

--
-- Name: TABLE ir_exports; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports IS 'Exports';


--
-- Name: COLUMN ir_exports.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.name IS 'Export Name';


--
-- Name: COLUMN ir_exports.resource; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.resource IS 'Resource';


--
-- Name: COLUMN ir_exports.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports.write_date IS 'Last Updated on';


--
-- Name: ir_exports_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_id_seq OWNER TO runbot;

--
-- Name: ir_exports_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_id_seq OWNED BY public.ir_exports.id;


--
-- Name: ir_exports_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_exports_line (
    id integer NOT NULL,
    export_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_exports_line OWNER TO runbot;

--
-- Name: TABLE ir_exports_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_exports_line IS 'Exports Line';


--
-- Name: COLUMN ir_exports_line.export_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.export_id IS 'Export';


--
-- Name: COLUMN ir_exports_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_uid IS 'Created by';


--
-- Name: COLUMN ir_exports_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_exports_line.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.name IS 'Field Name';


--
-- Name: COLUMN ir_exports_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.create_date IS 'Created on';


--
-- Name: COLUMN ir_exports_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_exports_line.write_date IS 'Last Updated on';


--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_exports_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_exports_line_id_seq OWNER TO runbot;

--
-- Name: ir_exports_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_exports_line_id_seq OWNED BY public.ir_exports_line.id;


--
-- Name: ir_filters; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters (
    id integer NOT NULL,
    action_id integer,
    embedded_action_id integer,
    embedded_parent_res_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    sort character varying NOT NULL,
    model_id character varying NOT NULL,
    domain text NOT NULL,
    context text NOT NULL,
    is_default boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_filters_check_res_id_only_when_embedded_action CHECK ((NOT ((embedded_parent_res_id IS NOT NULL) AND (embedded_action_id IS NULL)))),
    CONSTRAINT ir_filters_check_sort_json CHECK (((sort IS NULL) OR (jsonb_typeof((sort)::jsonb) = 'array'::text)))
);


ALTER TABLE public.ir_filters OWNER TO runbot;

--
-- Name: TABLE ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters IS 'Filters';


--
-- Name: COLUMN ir_filters.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.action_id IS 'Action';


--
-- Name: COLUMN ir_filters.embedded_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_action_id IS 'Embedded Action';


--
-- Name: COLUMN ir_filters.embedded_parent_res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.embedded_parent_res_id IS 'Embedded Parent Res';


--
-- Name: COLUMN ir_filters.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_uid IS 'Created by';


--
-- Name: COLUMN ir_filters.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_filters.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.name IS 'Filter Name';


--
-- Name: COLUMN ir_filters.sort; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.sort IS 'Sort';


--
-- Name: COLUMN ir_filters.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.model_id IS 'Model';


--
-- Name: COLUMN ir_filters.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.domain IS 'Domain';


--
-- Name: COLUMN ir_filters.context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.context IS 'Context';


--
-- Name: COLUMN ir_filters.is_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.is_default IS 'Default Filter';


--
-- Name: COLUMN ir_filters.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.active IS 'Active';


--
-- Name: COLUMN ir_filters.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.create_date IS 'Created on';


--
-- Name: COLUMN ir_filters.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_filters.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_res_id_only_when_embedded_action ON public.ir_filters IS 'CHECK(NOT (embedded_parent_res_id IS NOT NULL AND embedded_action_id IS NULL))';


--
-- Name: CONSTRAINT ir_filters_check_sort_json ON ir_filters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_filters_check_sort_json ON public.ir_filters IS 'CHECK(sort IS NULL OR jsonb_typeof(sort::jsonb) = ''array'')';


--
-- Name: ir_filters_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_filters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_filters_id_seq OWNER TO runbot;

--
-- Name: ir_filters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_filters_id_seq OWNED BY public.ir_filters.id;


--
-- Name: ir_filters_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_filters_res_users_rel (
    ir_filters_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.ir_filters_res_users_rel OWNER TO runbot;

--
-- Name: TABLE ir_filters_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_filters_res_users_rel IS 'RELATION BETWEEN ir_filters AND res_users';


--
-- Name: ir_logging; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_logging (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    type character varying NOT NULL,
    dbname character varying,
    level character varying,
    path character varying NOT NULL,
    func character varying NOT NULL,
    line character varying NOT NULL,
    message text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_logging OWNER TO runbot;

--
-- Name: TABLE ir_logging; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_logging IS 'Logging';


--
-- Name: COLUMN ir_logging.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_uid IS 'Created by';


--
-- Name: COLUMN ir_logging.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_logging.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.name IS 'Name';


--
-- Name: COLUMN ir_logging.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.type IS 'Type';


--
-- Name: COLUMN ir_logging.dbname; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.dbname IS 'Database Name';


--
-- Name: COLUMN ir_logging.level; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.level IS 'Level';


--
-- Name: COLUMN ir_logging.path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.path IS 'Path';


--
-- Name: COLUMN ir_logging.func; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.func IS 'Function';


--
-- Name: COLUMN ir_logging.line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.line IS 'Line';


--
-- Name: COLUMN ir_logging.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.message IS 'Message';


--
-- Name: COLUMN ir_logging.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.create_date IS 'Created on';


--
-- Name: COLUMN ir_logging.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_logging.write_date IS 'Last Updated on';


--
-- Name: ir_logging_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_logging_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_logging_id_seq OWNER TO runbot;

--
-- Name: ir_logging_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_logging_id_seq OWNED BY public.ir_logging.id;


--
-- Name: ir_mail_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_mail_server (
    id integer NOT NULL,
    smtp_port integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    from_filter character varying,
    smtp_host character varying,
    smtp_authentication character varying NOT NULL,
    smtp_user character varying,
    smtp_pass character varying,
    smtp_encryption character varying NOT NULL,
    smtp_debug boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    max_email_size double precision,
    smtp_ssl_certificate bytea,
    smtp_ssl_private_key bytea,
    owner_user_id integer,
    owner_limit_count integer,
    owner_limit_time timestamp without time zone,
    google_gmail_access_token_expiration integer,
    google_gmail_refresh_token character varying,
    google_gmail_access_token character varying,
    microsoft_outlook_access_token_expiration integer,
    microsoft_outlook_refresh_token character varying,
    microsoft_outlook_access_token character varying,
    CONSTRAINT ir_mail_server_certificate_requires_tls CHECK ((((smtp_encryption)::text <> 'none'::text) OR ((smtp_authentication)::text <> 'certificate'::text)))
);


ALTER TABLE public.ir_mail_server OWNER TO runbot;

--
-- Name: TABLE ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_mail_server IS 'Mail Server';


--
-- Name: COLUMN ir_mail_server.smtp_port; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_port IS 'SMTP Port';


--
-- Name: COLUMN ir_mail_server.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.sequence IS 'Priority';


--
-- Name: COLUMN ir_mail_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_uid IS 'Created by';


--
-- Name: COLUMN ir_mail_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_mail_server.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.name IS 'Name';


--
-- Name: COLUMN ir_mail_server.from_filter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.from_filter IS 'FROM Filtering';


--
-- Name: COLUMN ir_mail_server.smtp_host; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_host IS 'SMTP Server';


--
-- Name: COLUMN ir_mail_server.smtp_authentication; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_authentication IS 'Authenticate with';


--
-- Name: COLUMN ir_mail_server.smtp_user; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_user IS 'Username';


--
-- Name: COLUMN ir_mail_server.smtp_pass; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_pass IS 'Password';


--
-- Name: COLUMN ir_mail_server.smtp_encryption; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_encryption IS 'Connection Encryption';


--
-- Name: COLUMN ir_mail_server.smtp_debug; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_debug IS 'Debugging';


--
-- Name: COLUMN ir_mail_server.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.active IS 'Active';


--
-- Name: COLUMN ir_mail_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.create_date IS 'Created on';


--
-- Name: COLUMN ir_mail_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_mail_server.max_email_size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.max_email_size IS 'Max Email Size';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_certificate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_certificate IS 'SSL Certificate';


--
-- Name: COLUMN ir_mail_server.smtp_ssl_private_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.smtp_ssl_private_key IS 'SSL Private Key';


--
-- Name: COLUMN ir_mail_server.owner_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_user_id IS 'Owner';


--
-- Name: COLUMN ir_mail_server.owner_limit_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_limit_count IS 'Owner Limit Count';


--
-- Name: COLUMN ir_mail_server.owner_limit_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.owner_limit_time IS 'Owner Limit Time';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token_expiration IS 'Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.google_gmail_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_refresh_token IS 'Refresh Token';


--
-- Name: COLUMN ir_mail_server.google_gmail_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.google_gmail_access_token IS 'Access Token';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_access_token_expiration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_access_token_expiration IS 'Outlook Access Token Expiration Timestamp';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_refresh_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_refresh_token IS 'Outlook Refresh Token';


--
-- Name: COLUMN ir_mail_server.microsoft_outlook_access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_mail_server.microsoft_outlook_access_token IS 'Outlook Access Token';


--
-- Name: CONSTRAINT ir_mail_server_certificate_requires_tls ON ir_mail_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_mail_server_certificate_requires_tls ON public.ir_mail_server IS 'CHECK(smtp_encryption != ''none'' OR smtp_authentication != ''certificate'')';


--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_mail_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_mail_server_id_seq OWNER TO runbot;

--
-- Name: ir_mail_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_mail_server_id_seq OWNED BY public.ir_mail_server.id;


--
-- Name: ir_model; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    "order" character varying NOT NULL,
    state character varying,
    fold_name character varying,
    name jsonb NOT NULL,
    info text,
    abstract boolean,
    transient boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    is_mail_thread boolean,
    is_mail_activity boolean,
    is_mail_blacklist boolean
);


ALTER TABLE public.ir_model OWNER TO runbot;

--
-- Name: TABLE ir_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model IS 'Models';


--
-- Name: COLUMN ir_model.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.model IS 'Model';


--
-- Name: COLUMN ir_model."order"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model."order" IS 'Order';


--
-- Name: COLUMN ir_model.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.state IS 'Type';


--
-- Name: COLUMN ir_model.fold_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.fold_name IS 'Fold Field';


--
-- Name: COLUMN ir_model.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.name IS 'Model Description';


--
-- Name: COLUMN ir_model.info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.info IS 'Information';


--
-- Name: COLUMN ir_model.abstract; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.abstract IS 'Abstract Model';


--
-- Name: COLUMN ir_model.transient; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.transient IS 'Transient Model';


--
-- Name: COLUMN ir_model.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.create_date IS 'Created on';


--
-- Name: COLUMN ir_model.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model.is_mail_thread; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_thread IS 'Has Mail Thread';


--
-- Name: COLUMN ir_model.is_mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_activity IS 'Has Mail Activity';


--
-- Name: COLUMN ir_model.is_mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model.is_mail_blacklist IS 'Has Mail Blacklist';


--
-- Name: ir_model_access; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_access (
    id integer NOT NULL,
    model_id integer NOT NULL,
    group_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_access OWNER TO runbot;

--
-- Name: TABLE ir_model_access; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_access IS 'Model Access';


--
-- Name: COLUMN ir_model_access.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.model_id IS 'Model';


--
-- Name: COLUMN ir_model_access.group_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.group_id IS 'Group';


--
-- Name: COLUMN ir_model_access.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_access.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_access.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.name IS 'Name';


--
-- Name: COLUMN ir_model_access.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.active IS 'Active';


--
-- Name: COLUMN ir_model_access.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_read IS 'Read Access';


--
-- Name: COLUMN ir_model_access.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_write IS 'Write Access';


--
-- Name: COLUMN ir_model_access.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_create IS 'Create Access';


--
-- Name: COLUMN ir_model_access.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.perm_unlink IS 'Delete Access';


--
-- Name: COLUMN ir_model_access.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_access.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_access.write_date IS 'Last Updated on';


--
-- Name: ir_model_access_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_access_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_access_id_seq OWNER TO runbot;

--
-- Name: ir_model_access_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_access_id_seq OWNED BY public.ir_model_access.id;


--
-- Name: ir_model_constraint; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_constraint (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    definition character varying,
    type character varying(1) NOT NULL,
    message jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_constraint OWNER TO runbot;

--
-- Name: TABLE ir_model_constraint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_constraint IS 'Model Constraint';


--
-- Name: COLUMN ir_model_constraint.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.model IS 'Model';


--
-- Name: COLUMN ir_model_constraint.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.module IS 'Module';


--
-- Name: COLUMN ir_model_constraint.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_constraint.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_constraint.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.name IS 'Constraint';


--
-- Name: COLUMN ir_model_constraint.definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.definition IS 'Definition';


--
-- Name: COLUMN ir_model_constraint.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.type IS 'Constraint Type';


--
-- Name: COLUMN ir_model_constraint.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.message IS 'Message';


--
-- Name: COLUMN ir_model_constraint.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_constraint.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_constraint.write_date IS 'Last Updated on';


--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_constraint_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_constraint_id_seq OWNER TO runbot;

--
-- Name: ir_model_constraint_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_constraint_id_seq OWNED BY public.ir_model_constraint.id;


--
-- Name: ir_model_data; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_data (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'UTC'::text),
    write_uid integer,
    res_id integer,
    noupdate boolean DEFAULT false,
    name character varying NOT NULL,
    module character varying NOT NULL,
    model character varying NOT NULL,
    CONSTRAINT ir_model_data_name_nospaces CHECK (((name)::text !~~ '% %'::text))
);


ALTER TABLE public.ir_model_data OWNER TO runbot;

--
-- Name: CONSTRAINT ir_model_data_name_nospaces ON ir_model_data; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_data_name_nospaces ON public.ir_model_data IS 'CHECK(name NOT LIKE ''% %'')';


--
-- Name: ir_model_data_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_data_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_data_id_seq OWNER TO runbot;

--
-- Name: ir_model_data_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_data_id_seq OWNED BY public.ir_model_data.id;


--
-- Name: ir_model_fields; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields (
    id integer NOT NULL,
    relation_field_id integer,
    model_id integer NOT NULL,
    related_field_id integer,
    size integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying NOT NULL,
    relation character varying,
    relation_field character varying,
    ttype character varying NOT NULL,
    related character varying,
    translate character varying,
    state character varying NOT NULL,
    on_delete character varying,
    domain character varying,
    relation_table character varying,
    column1 character varying,
    column2 character varying,
    depends character varying,
    currency_field character varying,
    field_description jsonb NOT NULL,
    help jsonb,
    compute text,
    copied boolean,
    required boolean,
    readonly boolean,
    index boolean,
    company_dependent boolean,
    group_expand boolean,
    selectable boolean,
    store boolean,
    sanitize boolean,
    sanitize_overridable boolean,
    sanitize_tags boolean,
    sanitize_attributes boolean,
    sanitize_style boolean,
    sanitize_form boolean,
    strip_style boolean,
    strip_classes boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    tracking integer,
    ai_domain character varying,
    system_prompt text,
    ai boolean,
    CONSTRAINT ir_model_fields_name_manual_field CHECK ((((state)::text <> 'manual'::text) OR ((name)::text ~~ 'x\_%'::text))),
    CONSTRAINT ir_model_fields_size_gt_zero CHECK ((size >= 0))
);


ALTER TABLE public.ir_model_fields OWNER TO runbot;

--
-- Name: TABLE ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields IS 'Fields';


--
-- Name: COLUMN ir_model_fields.relation_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field_id IS 'Relation field';


--
-- Name: COLUMN ir_model_fields.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model_id IS 'Model';


--
-- Name: COLUMN ir_model_fields.related_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related_field_id IS 'Related Field';


--
-- Name: COLUMN ir_model_fields.size; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.size IS 'Size';


--
-- Name: COLUMN ir_model_fields.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.name IS 'Field Name';


--
-- Name: COLUMN ir_model_fields.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.model IS 'Model Name';


--
-- Name: COLUMN ir_model_fields.relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation IS 'Related Model';


--
-- Name: COLUMN ir_model_fields.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_field IS 'Relation Field';


--
-- Name: COLUMN ir_model_fields.ttype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ttype IS 'Field Type';


--
-- Name: COLUMN ir_model_fields.related; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.related IS 'Related Field Definition';


--
-- Name: COLUMN ir_model_fields.translate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.translate IS 'Translatable';


--
-- Name: COLUMN ir_model_fields.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.state IS 'Type';


--
-- Name: COLUMN ir_model_fields.on_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.on_delete IS 'On Delete';


--
-- Name: COLUMN ir_model_fields.domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.domain IS 'Domain';


--
-- Name: COLUMN ir_model_fields.relation_table; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.relation_table IS 'Relation Table';


--
-- Name: COLUMN ir_model_fields.column1; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column1 IS 'Column 1';


--
-- Name: COLUMN ir_model_fields.column2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.column2 IS 'Column 2';


--
-- Name: COLUMN ir_model_fields.depends; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.depends IS 'Dependencies';


--
-- Name: COLUMN ir_model_fields.currency_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.currency_field IS 'Currency field';


--
-- Name: COLUMN ir_model_fields.field_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.field_description IS 'Field Label';


--
-- Name: COLUMN ir_model_fields.help; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.help IS 'Field Help';


--
-- Name: COLUMN ir_model_fields.compute; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.compute IS 'Compute';


--
-- Name: COLUMN ir_model_fields.copied; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.copied IS 'Copied';


--
-- Name: COLUMN ir_model_fields.required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.required IS 'Required';


--
-- Name: COLUMN ir_model_fields.readonly; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.readonly IS 'Readonly';


--
-- Name: COLUMN ir_model_fields.index; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.index IS 'Indexed';


--
-- Name: COLUMN ir_model_fields.company_dependent; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.company_dependent IS 'Company Dependent';


--
-- Name: COLUMN ir_model_fields.group_expand; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.group_expand IS 'Expand Groups';


--
-- Name: COLUMN ir_model_fields.selectable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.selectable IS 'Selectable';


--
-- Name: COLUMN ir_model_fields.store; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.store IS 'Stored';


--
-- Name: COLUMN ir_model_fields.sanitize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize IS 'Sanitize HTML';


--
-- Name: COLUMN ir_model_fields.sanitize_overridable; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_overridable IS 'Sanitize HTML overridable';


--
-- Name: COLUMN ir_model_fields.sanitize_tags; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_tags IS 'Sanitize HTML Tags';


--
-- Name: COLUMN ir_model_fields.sanitize_attributes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_attributes IS 'Sanitize HTML Attributes';


--
-- Name: COLUMN ir_model_fields.sanitize_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_style IS 'Sanitize HTML Style';


--
-- Name: COLUMN ir_model_fields.sanitize_form; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.sanitize_form IS 'Sanitize HTML Form';


--
-- Name: COLUMN ir_model_fields.strip_style; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_style IS 'Strip Style Attribute';


--
-- Name: COLUMN ir_model_fields.strip_classes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.strip_classes IS 'Strip Class Attribute';


--
-- Name: COLUMN ir_model_fields.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.write_date IS 'Last Updated on';


--
-- Name: COLUMN ir_model_fields.tracking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.tracking IS 'Enable Ordered Tracking';


--
-- Name: COLUMN ir_model_fields.ai_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ai_domain IS 'AI field domain';


--
-- Name: COLUMN ir_model_fields.system_prompt; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.system_prompt IS 'AI Prompt';


--
-- Name: COLUMN ir_model_fields.ai; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields.ai IS 'AI field';


--
-- Name: CONSTRAINT ir_model_fields_name_manual_field ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_name_manual_field ON public.ir_model_fields IS 'CHECK (state != ''manual'' OR name LIKE ''x\_%'')';


--
-- Name: CONSTRAINT ir_model_fields_size_gt_zero ON ir_model_fields; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_model_fields_size_gt_zero ON public.ir_model_fields IS 'CHECK (size>=0)';


--
-- Name: ir_model_fields_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_group_rel (
    field_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_model_fields_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_group_rel IS 'RELATION BETWEEN ir_model_fields AND res_groups';


--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_id_seq OWNED BY public.ir_model_fields.id;


--
-- Name: ir_model_fields_selection; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_fields_selection (
    id integer NOT NULL,
    field_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    value character varying NOT NULL,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_model_fields_selection OWNER TO runbot;

--
-- Name: TABLE ir_model_fields_selection; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_fields_selection IS 'Fields Selection';


--
-- Name: COLUMN ir_model_fields_selection.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.field_id IS 'Field';


--
-- Name: COLUMN ir_model_fields_selection.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.sequence IS 'Sequence';


--
-- Name: COLUMN ir_model_fields_selection.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_fields_selection.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_fields_selection.value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.value IS 'Value';


--
-- Name: COLUMN ir_model_fields_selection.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.name IS 'Name';


--
-- Name: COLUMN ir_model_fields_selection.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.create_date IS 'Created on';


--
-- Name: COLUMN ir_model_fields_selection.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_fields_selection.write_date IS 'Last Updated on';


--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_fields_selection_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNER TO runbot;

--
-- Name: ir_model_fields_selection_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_fields_selection_id_seq OWNED BY public.ir_model_fields_selection.id;


--
-- Name: ir_model_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_id_seq OWNER TO runbot;

--
-- Name: ir_model_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_id_seq OWNED BY public.ir_model.id;


--
-- Name: ir_model_inherit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_inherit (
    id integer NOT NULL,
    model_id integer NOT NULL,
    parent_id integer NOT NULL,
    parent_field_id integer
);


ALTER TABLE public.ir_model_inherit OWNER TO runbot;

--
-- Name: TABLE ir_model_inherit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_inherit IS 'Model Inheritance Tree';


--
-- Name: COLUMN ir_model_inherit.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.model_id IS 'Model';


--
-- Name: COLUMN ir_model_inherit.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_id IS 'Parent';


--
-- Name: COLUMN ir_model_inherit.parent_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_inherit.parent_field_id IS 'Parent Field';


--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_inherit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_inherit_id_seq OWNER TO runbot;

--
-- Name: ir_model_inherit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_inherit_id_seq OWNED BY public.ir_model_inherit.id;


--
-- Name: ir_model_relation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_model_relation (
    id integer NOT NULL,
    model integer NOT NULL,
    module integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    write_date timestamp without time zone,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_model_relation OWNER TO runbot;

--
-- Name: TABLE ir_model_relation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_model_relation IS 'Relation Model';


--
-- Name: COLUMN ir_model_relation.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.model IS 'Model';


--
-- Name: COLUMN ir_model_relation.module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.module IS 'Module';


--
-- Name: COLUMN ir_model_relation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_uid IS 'Created by';


--
-- Name: COLUMN ir_model_relation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_model_relation.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.name IS 'Relation Name';


--
-- Name: COLUMN ir_model_relation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.write_date IS 'Write Date';


--
-- Name: COLUMN ir_model_relation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_model_relation.create_date IS 'Create Date';


--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_model_relation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_model_relation_id_seq OWNER TO runbot;

--
-- Name: ir_model_relation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_model_relation_id_seq OWNED BY public.ir_model_relation.id;


--
-- Name: ir_module_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_category (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    parent_id integer,
    name jsonb NOT NULL,
    sequence integer,
    description jsonb,
    visible boolean,
    exclusive boolean
);


ALTER TABLE public.ir_module_category OWNER TO runbot;

--
-- Name: COLUMN ir_module_category.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.sequence IS 'Sequence';


--
-- Name: COLUMN ir_module_category.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.description IS 'Description';


--
-- Name: COLUMN ir_module_category.visible; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.visible IS 'Visible';


--
-- Name: COLUMN ir_module_category.exclusive; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_category.exclusive IS 'Exclusive';


--
-- Name: ir_module_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_category_id_seq OWNER TO runbot;

--
-- Name: ir_module_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_category_id_seq OWNED BY public.ir_module_category.id;


--
-- Name: ir_module_module; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module (
    id integer NOT NULL,
    create_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    write_uid integer,
    website character varying,
    summary jsonb,
    name character varying NOT NULL,
    author character varying,
    icon character varying,
    state character varying(16),
    latest_version character varying,
    shortdesc jsonb,
    category_id integer,
    description jsonb,
    application boolean DEFAULT false,
    demo boolean DEFAULT false,
    web boolean DEFAULT false,
    license character varying(32),
    sequence integer DEFAULT 100,
    auto_install boolean DEFAULT false,
    to_buy boolean DEFAULT false,
    maintainer character varying,
    published_version character varying,
    url character varying,
    contributors text,
    menus_by_module text,
    reports_by_module text,
    views_by_module text,
    module_type character varying,
    imported boolean
);


ALTER TABLE public.ir_module_module OWNER TO runbot;

--
-- Name: COLUMN ir_module_module.maintainer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.maintainer IS 'Maintainer';


--
-- Name: COLUMN ir_module_module.published_version; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.published_version IS 'Published Version';


--
-- Name: COLUMN ir_module_module.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.url IS 'URL';


--
-- Name: COLUMN ir_module_module.contributors; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.contributors IS 'Contributors';


--
-- Name: COLUMN ir_module_module.menus_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.menus_by_module IS 'Menus';


--
-- Name: COLUMN ir_module_module.reports_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.reports_by_module IS 'Reports';


--
-- Name: COLUMN ir_module_module.views_by_module; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.views_by_module IS 'Views';


--
-- Name: COLUMN ir_module_module.module_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.module_type IS 'Module Type';


--
-- Name: COLUMN ir_module_module.imported; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module.imported IS 'Imported Module';


--
-- Name: ir_module_module_dependency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_dependency (
    id integer NOT NULL,
    name character varying,
    module_id integer,
    auto_install_required boolean DEFAULT true
);


ALTER TABLE public.ir_module_module_dependency OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_dependency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_dependency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_dependency_id_seq OWNED BY public.ir_module_module_dependency.id;


--
-- Name: ir_module_module_exclusion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_module_module_exclusion (
    id integer NOT NULL,
    module_id integer,
    create_uid integer,
    write_uid integer,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_module_module_exclusion OWNER TO runbot;

--
-- Name: TABLE ir_module_module_exclusion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_module_module_exclusion IS 'Module exclusion';


--
-- Name: COLUMN ir_module_module_exclusion.module_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.module_id IS 'Module';


--
-- Name: COLUMN ir_module_module_exclusion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_uid IS 'Created by';


--
-- Name: COLUMN ir_module_module_exclusion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_module_module_exclusion.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.name IS 'Name';


--
-- Name: COLUMN ir_module_module_exclusion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.create_date IS 'Created on';


--
-- Name: COLUMN ir_module_module_exclusion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_module_module_exclusion.write_date IS 'Last Updated on';


--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_exclusion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_exclusion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_exclusion_id_seq OWNED BY public.ir_module_module_exclusion.id;


--
-- Name: ir_module_module_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_module_module_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_module_module_id_seq OWNER TO runbot;

--
-- Name: ir_module_module_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_module_module_id_seq OWNED BY public.ir_module_module.id;


--
-- Name: ir_profile; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_profile (
    id integer NOT NULL,
    sql_count integer,
    entry_count integer,
    session character varying,
    name character varying,
    init_stack_trace text,
    sql text,
    traces_async text,
    traces_sync text,
    others text,
    qweb text,
    duration numeric,
    cpu_duration numeric,
    create_date timestamp without time zone
);


ALTER TABLE public.ir_profile OWNER TO runbot;

--
-- Name: TABLE ir_profile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_profile IS 'Profiling results';


--
-- Name: COLUMN ir_profile.sql_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql_count IS 'Queries Count';


--
-- Name: COLUMN ir_profile.entry_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.entry_count IS 'Entry count';


--
-- Name: COLUMN ir_profile.session; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.session IS 'Session';


--
-- Name: COLUMN ir_profile.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.name IS 'Description';


--
-- Name: COLUMN ir_profile.init_stack_trace; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.init_stack_trace IS 'Initial stack trace';


--
-- Name: COLUMN ir_profile.sql; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.sql IS 'Sql';


--
-- Name: COLUMN ir_profile.traces_async; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_async IS 'Traces Async';


--
-- Name: COLUMN ir_profile.traces_sync; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.traces_sync IS 'Traces Sync';


--
-- Name: COLUMN ir_profile.others; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.others IS 'others';


--
-- Name: COLUMN ir_profile.qweb; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.qweb IS 'Qweb';


--
-- Name: COLUMN ir_profile.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.duration IS 'Duration';


--
-- Name: COLUMN ir_profile.cpu_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.cpu_duration IS 'CPU Duration';


--
-- Name: COLUMN ir_profile.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_profile.create_date IS 'Creation Date';


--
-- Name: ir_profile_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_profile_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_profile_id_seq OWNER TO runbot;

--
-- Name: ir_profile_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_profile_id_seq OWNED BY public.ir_profile.id;


--
-- Name: ir_rule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_rule (
    id integer NOT NULL,
    model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying,
    domain_force text,
    active boolean,
    perm_read boolean,
    perm_write boolean,
    perm_create boolean,
    perm_unlink boolean,
    global boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_rule_no_access_rights CHECK (((perm_read <> false) OR (perm_write <> false) OR (perm_create <> false) OR (perm_unlink <> false)))
);


ALTER TABLE public.ir_rule OWNER TO runbot;

--
-- Name: TABLE ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_rule IS 'Record Rule';


--
-- Name: COLUMN ir_rule.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.model_id IS 'Model';


--
-- Name: COLUMN ir_rule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_uid IS 'Created by';


--
-- Name: COLUMN ir_rule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_rule.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.name IS 'Name';


--
-- Name: COLUMN ir_rule.domain_force; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.domain_force IS 'Domain';


--
-- Name: COLUMN ir_rule.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.active IS 'Active';


--
-- Name: COLUMN ir_rule.perm_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_read IS 'Read';


--
-- Name: COLUMN ir_rule.perm_write; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_write IS 'Write';


--
-- Name: COLUMN ir_rule.perm_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_create IS 'Create';


--
-- Name: COLUMN ir_rule.perm_unlink; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.perm_unlink IS 'Delete';


--
-- Name: COLUMN ir_rule.global; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.global IS 'Global';


--
-- Name: COLUMN ir_rule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.create_date IS 'Created on';


--
-- Name: COLUMN ir_rule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_rule.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_rule_no_access_rights ON ir_rule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_rule_no_access_rights ON public.ir_rule IS 'CHECK (perm_read!=False or perm_write!=False or perm_create!=False or perm_unlink!=False)';


--
-- Name: ir_rule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_rule_id_seq OWNER TO runbot;

--
-- Name: ir_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_rule_id_seq OWNED BY public.ir_rule.id;


--
-- Name: ir_sequence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence (
    id integer NOT NULL,
    number_next integer NOT NULL,
    number_increment integer NOT NULL,
    padding integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying,
    implementation character varying NOT NULL,
    prefix character varying,
    suffix character varying,
    active boolean,
    use_date_range boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence OWNER TO runbot;

--
-- Name: TABLE ir_sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence IS 'Sequence';


--
-- Name: COLUMN ir_sequence.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence.number_increment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.number_increment IS 'Step';


--
-- Name: COLUMN ir_sequence.padding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.padding IS 'Sequence Size';


--
-- Name: COLUMN ir_sequence.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.company_id IS 'Company';


--
-- Name: COLUMN ir_sequence.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.name IS 'Name';


--
-- Name: COLUMN ir_sequence.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.code IS 'Sequence Code';


--
-- Name: COLUMN ir_sequence.implementation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.implementation IS 'Implementation';


--
-- Name: COLUMN ir_sequence.prefix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.prefix IS 'Prefix';


--
-- Name: COLUMN ir_sequence.suffix; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.suffix IS 'Suffix';


--
-- Name: COLUMN ir_sequence.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.active IS 'Active';


--
-- Name: COLUMN ir_sequence.use_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.use_date_range IS 'Use subsequences per date_range';


--
-- Name: COLUMN ir_sequence.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_sequence_date_range (
    id integer NOT NULL,
    sequence_id integer NOT NULL,
    number_next integer NOT NULL,
    create_uid integer,
    write_uid integer,
    date_from date NOT NULL,
    date_to date NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_sequence_date_range OWNER TO runbot;

--
-- Name: TABLE ir_sequence_date_range; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_sequence_date_range IS 'Sequence Date Range';


--
-- Name: COLUMN ir_sequence_date_range.sequence_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.sequence_id IS 'Main Sequence';


--
-- Name: COLUMN ir_sequence_date_range.number_next; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.number_next IS 'Next Number';


--
-- Name: COLUMN ir_sequence_date_range.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_uid IS 'Created by';


--
-- Name: COLUMN ir_sequence_date_range.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_sequence_date_range.date_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_from IS 'From';


--
-- Name: COLUMN ir_sequence_date_range.date_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.date_to IS 'To';


--
-- Name: COLUMN ir_sequence_date_range.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.create_date IS 'Created on';


--
-- Name: COLUMN ir_sequence_date_range.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_sequence_date_range.write_date IS 'Last Updated on';


--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_date_range_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_date_range_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_date_range_id_seq OWNED BY public.ir_sequence_date_range.id;


--
-- Name: ir_sequence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_sequence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_sequence_id_seq OWNER TO runbot;

--
-- Name: ir_sequence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_sequence_id_seq OWNED BY public.ir_sequence.id;


--
-- Name: ir_ui_menu; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu (
    id integer NOT NULL,
    sequence integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    web_icon character varying,
    action character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_menu OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.sequence IS 'Sequence';


--
-- Name: COLUMN ir_ui_menu.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_id IS 'Parent Menu';


--
-- Name: COLUMN ir_ui_menu.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_menu.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_menu.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.parent_path IS 'Parent Path';


--
-- Name: COLUMN ir_ui_menu.web_icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.web_icon IS 'Web Icon File';


--
-- Name: COLUMN ir_ui_menu.action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.action IS 'Action';


--
-- Name: COLUMN ir_ui_menu.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.name IS 'Menu';


--
-- Name: COLUMN ir_ui_menu.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.active IS 'Active';


--
-- Name: COLUMN ir_ui_menu.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_menu.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_menu.write_date IS 'Last Updated on';


--
-- Name: ir_ui_menu_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_menu_group_rel (
    menu_id integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.ir_ui_menu_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_menu_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_menu_group_rel IS 'RELATION BETWEEN ir_ui_menu AND res_groups';


--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_menu_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_menu_id_seq OWNER TO runbot;

--
-- Name: ir_ui_menu_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_menu_id_seq OWNED BY public.ir_ui_menu.id;


--
-- Name: ir_ui_view; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view (
    id integer NOT NULL,
    priority integer NOT NULL,
    inherit_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    model character varying,
    key character varying,
    type character varying,
    arch_fs character varying,
    mode character varying NOT NULL,
    arch_db jsonb,
    arch_prev text,
    arch_updated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT ir_ui_view_inheritance_mode CHECK ((((mode)::text <> 'extension'::text) OR (inherit_id IS NOT NULL))),
    CONSTRAINT ir_ui_view_qweb_required_key CHECK ((((type)::text <> 'qweb'::text) OR (key IS NOT NULL)))
);


ALTER TABLE public.ir_ui_view OWNER TO runbot;

--
-- Name: TABLE ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view IS 'View';


--
-- Name: COLUMN ir_ui_view.priority; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.priority IS 'Sequence';


--
-- Name: COLUMN ir_ui_view.inherit_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.inherit_id IS 'Inherited View';


--
-- Name: COLUMN ir_ui_view.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.name IS 'View Name';


--
-- Name: COLUMN ir_ui_view.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.model IS 'Model';


--
-- Name: COLUMN ir_ui_view.key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.key IS 'Key';


--
-- Name: COLUMN ir_ui_view.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.type IS 'View Type';


--
-- Name: COLUMN ir_ui_view.arch_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_fs IS 'Arch Filename';


--
-- Name: COLUMN ir_ui_view.mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.mode IS 'View inheritance mode';


--
-- Name: COLUMN ir_ui_view.arch_db; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_db IS 'Arch Blob';


--
-- Name: COLUMN ir_ui_view.arch_prev; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_prev IS 'Previous View Architecture';


--
-- Name: COLUMN ir_ui_view.arch_updated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.arch_updated IS 'Modified Architecture';


--
-- Name: COLUMN ir_ui_view.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.active IS 'Active';


--
-- Name: COLUMN ir_ui_view.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT ir_ui_view_inheritance_mode ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_inheritance_mode ON public.ir_ui_view IS 'CHECK (mode != ''extension'' OR inherit_id IS NOT NULL)';


--
-- Name: CONSTRAINT ir_ui_view_qweb_required_key ON ir_ui_view; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT ir_ui_view_qweb_required_key ON public.ir_ui_view IS 'CHECK (type != ''qweb'' OR key IS NOT NULL)';


--
-- Name: ir_ui_view_custom; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_custom (
    id integer NOT NULL,
    ref_id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    arch text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.ir_ui_view_custom OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_custom IS 'Custom View';


--
-- Name: COLUMN ir_ui_view_custom.ref_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.ref_id IS 'Original View';


--
-- Name: COLUMN ir_ui_view_custom.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.user_id IS 'User';


--
-- Name: COLUMN ir_ui_view_custom.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_uid IS 'Created by';


--
-- Name: COLUMN ir_ui_view_custom.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_uid IS 'Last Updated by';


--
-- Name: COLUMN ir_ui_view_custom.arch; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.arch IS 'View Architecture';


--
-- Name: COLUMN ir_ui_view_custom.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.create_date IS 'Created on';


--
-- Name: COLUMN ir_ui_view_custom.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.ir_ui_view_custom.write_date IS 'Last Updated on';


--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_custom_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_custom_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_custom_id_seq OWNED BY public.ir_ui_view_custom.id;


--
-- Name: ir_ui_view_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.ir_ui_view_group_rel (
    view_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.ir_ui_view_group_rel OWNER TO runbot;

--
-- Name: TABLE ir_ui_view_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.ir_ui_view_group_rel IS 'RELATION BETWEEN ir_ui_view AND res_groups';


--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.ir_ui_view_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.ir_ui_view_id_seq OWNER TO runbot;

--
-- Name: ir_ui_view_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.ir_ui_view_id_seq OWNED BY public.ir_ui_view.id;


--
-- Name: mail_activity; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity (
    id integer NOT NULL,
    res_model_id integer,
    res_id integer,
    activity_type_id integer,
    user_id integer,
    recommended_activity_type_id integer,
    previous_activity_type_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    res_name character varying,
    summary character varying,
    user_tz character varying,
    date_deadline date NOT NULL,
    date_done date,
    note text,
    feedback text,
    automated boolean,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT mail_activity_check_res_id_is_set_if_model CHECK (((((COALESCE(res_model, ''::character varying))::text <> ''::text) AND ((res_id IS NOT NULL) AND (res_id <> 0))) OR (((COALESCE(res_model, ''::character varying))::text = ''::text) AND ((res_id IS NULL) OR (res_id = 0))))),
    CONSTRAINT mail_activity_check_user_id_is_set_if_model CHECK ((((COALESCE(res_model, ''::character varying))::text <> ''::text) OR (user_id IS NOT NULL)))
);


ALTER TABLE public.mail_activity OWNER TO runbot;

--
-- Name: TABLE mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity IS 'Activity';


--
-- Name: COLUMN mail_activity.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model_id IS 'Document Model';


--
-- Name: COLUMN mail_activity.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_activity.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity.recommended_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.recommended_activity_type_id IS 'Recommended Activity Type';


--
-- Name: COLUMN mail_activity.previous_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.previous_activity_type_id IS 'Previous Activity Type';


--
-- Name: COLUMN mail_activity.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_activity.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.res_name IS 'Document Name';


--
-- Name: COLUMN mail_activity.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.summary IS 'Summary';


--
-- Name: COLUMN mail_activity.user_tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.user_tz IS 'Timezone';


--
-- Name: COLUMN mail_activity.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity.date_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.date_done IS 'Done Date';


--
-- Name: COLUMN mail_activity.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.note IS 'Note';


--
-- Name: COLUMN mail_activity.feedback; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.feedback IS 'Feedback';


--
-- Name: COLUMN mail_activity.automated; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.automated IS 'Automated activity';


--
-- Name: COLUMN mail_activity.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.active IS 'Active';


--
-- Name: COLUMN mail_activity.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT mail_activity_check_res_id_is_set_if_model ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_res_id_is_set_if_model ON public.mail_activity IS 'CHECK(
            (COALESCE(res_model, '''') <> '''' AND (res_id IS NOT NULL AND res_id != 0)) OR
            (COALESCE(res_model, '''') = '''' AND (res_id IS NULL OR res_id = 0))
        )';


--
-- Name: CONSTRAINT mail_activity_check_user_id_is_set_if_model ON mail_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_activity_check_user_id_is_set_if_model ON public.mail_activity IS 'CHECK(
            (COALESCE(res_model, '''') <> '''' OR user_id IS NOT NULL)
        )';


--
-- Name: mail_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_id_seq OWNER TO runbot;

--
-- Name: mail_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_id_seq OWNED BY public.mail_activity.id;


--
-- Name: mail_activity_plan; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan (
    id integer NOT NULL,
    company_id integer,
    res_model_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    res_model character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan IS 'Activity Plan';


--
-- Name: COLUMN mail_activity_plan.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.company_id IS 'Company';


--
-- Name: COLUMN mail_activity_plan.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_plan.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.name IS 'Name';


--
-- Name: COLUMN mail_activity_plan.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_plan.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.active IS 'Active';


--
-- Name: COLUMN mail_activity_plan.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_id_seq OWNED BY public.mail_activity_plan.id;


--
-- Name: mail_activity_plan_mail_activity_schedule_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_mail_activity_schedule_rel (
    mail_activity_schedule_id integer NOT NULL,
    mail_activity_plan_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_mail_activity_schedule_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_mail_activity_schedule_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_mail_activity_schedule_rel IS 'RELATION BETWEEN mail_activity_schedule AND mail_activity_plan';


--
-- Name: mail_activity_plan_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template (
    id integer NOT NULL,
    plan_id integer NOT NULL,
    sequence integer,
    activity_type_id integer NOT NULL,
    delay_count integer,
    responsible_id integer,
    create_uid integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    summary character varying,
    responsible_type character varying NOT NULL,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_plan_template OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template IS 'Activity plan template';


--
-- Name: COLUMN mail_activity_plan_template.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_plan_template.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_plan_template.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_plan_template.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_count IS 'Interval';


--
-- Name: COLUMN mail_activity_plan_template.responsible_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_plan_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_plan_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_plan_template.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_plan_template.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.delay_from IS 'Trigger';


--
-- Name: COLUMN mail_activity_plan_template.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_plan_template.responsible_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.responsible_type IS 'Assignment';


--
-- Name: COLUMN mail_activity_plan_template.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.note IS 'Note';


--
-- Name: COLUMN mail_activity_plan_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_plan_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_plan_template.write_date IS 'Last Updated on';


--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_plan_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNER TO runbot;

--
-- Name: mail_activity_plan_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_plan_template_id_seq OWNED BY public.mail_activity_plan_template.id;


--
-- Name: mail_activity_plan_template_mail_activity_type_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_plan_template_mail_activity_type_rel (
    mail_activity_plan_template_id integer NOT NULL,
    mail_activity_type_id integer NOT NULL
);


ALTER TABLE public.mail_activity_plan_template_mail_activity_type_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_plan_template_mail_activity_type_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_plan_template_mail_activity_type_rel IS 'RELATION BETWEEN mail_activity_plan_template AND mail_activity_type';


--
-- Name: mail_activity_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_rel (
    activity_id integer NOT NULL,
    recommended_id integer NOT NULL
);


ALTER TABLE public.mail_activity_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_rel IS 'RELATION BETWEEN mail_activity_type AND mail_activity_type';


--
-- Name: mail_activity_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule (
    id integer NOT NULL,
    res_model_id integer,
    plan_id integer,
    plan_on_demand_user_id integer,
    activity_type_id integer,
    activity_user_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying,
    summary character varying,
    plan_date date,
    date_deadline date,
    res_ids text,
    note text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule IS 'Activity schedule plan Wizard';


--
-- Name: COLUMN mail_activity_schedule.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model_id IS 'Applies to';


--
-- Name: COLUMN mail_activity_schedule.plan_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_id IS 'Plan';


--
-- Name: COLUMN mail_activity_schedule.plan_on_demand_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_on_demand_user_id IS 'Assigned To';


--
-- Name: COLUMN mail_activity_schedule.activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_type_id IS 'Activity Type';


--
-- Name: COLUMN mail_activity_schedule.activity_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.activity_user_id IS 'Assigned to';


--
-- Name: COLUMN mail_activity_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_schedule.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.summary IS 'Summary';


--
-- Name: COLUMN mail_activity_schedule.plan_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.plan_date IS 'Plan Date';


--
-- Name: COLUMN mail_activity_schedule.date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.date_deadline IS 'Due Date';


--
-- Name: COLUMN mail_activity_schedule.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.res_ids IS 'Document IDs';


--
-- Name: COLUMN mail_activity_schedule.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.note IS 'Note';


--
-- Name: COLUMN mail_activity_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_id_seq OWNED BY public.mail_activity_schedule.id;


--
-- Name: mail_activity_schedule_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_schedule_line (
    id integer NOT NULL,
    activity_schedule_id integer NOT NULL,
    responsible_user_id integer,
    create_uid integer,
    write_uid integer,
    line_description character varying,
    line_date_deadline date,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_schedule_line OWNER TO runbot;

--
-- Name: TABLE mail_activity_schedule_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_schedule_line IS 'Mail Activity Schedule Line';


--
-- Name: COLUMN mail_activity_schedule_line.activity_schedule_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.activity_schedule_id IS 'Activity Schedule';


--
-- Name: COLUMN mail_activity_schedule_line.responsible_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.responsible_user_id IS 'Responsible User';


--
-- Name: COLUMN mail_activity_schedule_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.create_uid IS 'Created by';


--
-- Name: COLUMN mail_activity_schedule_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_schedule_line.line_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.line_description IS 'Line Description';


--
-- Name: COLUMN mail_activity_schedule_line.line_date_deadline; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.line_date_deadline IS 'Date Deadline';


--
-- Name: COLUMN mail_activity_schedule_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_schedule_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_schedule_line.write_date IS 'Last Updated on';


--
-- Name: mail_activity_schedule_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_schedule_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_schedule_line_id_seq OWNER TO runbot;

--
-- Name: mail_activity_schedule_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_schedule_line_id_seq OWNED BY public.mail_activity_schedule_line.id;


--
-- Name: mail_activity_type; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    delay_count integer,
    triggered_next_type_id integer,
    default_user_id integer,
    write_uid integer,
    delay_unit character varying NOT NULL,
    delay_from character varying NOT NULL,
    icon character varying,
    decoration_type character varying,
    res_model character varying,
    chaining_type character varying NOT NULL,
    category character varying,
    name jsonb NOT NULL,
    summary jsonb,
    default_note jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_activity_type OWNER TO runbot;

--
-- Name: TABLE mail_activity_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type IS 'Activity Type';


--
-- Name: COLUMN mail_activity_type.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.sequence IS 'Sequence';


--
-- Name: COLUMN mail_activity_type.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_uid IS 'Create Uid';


--
-- Name: COLUMN mail_activity_type.delay_count; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_count IS 'Schedule';


--
-- Name: COLUMN mail_activity_type.triggered_next_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.triggered_next_type_id IS 'Trigger';


--
-- Name: COLUMN mail_activity_type.default_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_user_id IS 'Default User';


--
-- Name: COLUMN mail_activity_type.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_activity_type.delay_unit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_unit IS 'Delay units';


--
-- Name: COLUMN mail_activity_type.delay_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.delay_from IS 'Delay Type';


--
-- Name: COLUMN mail_activity_type.icon; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.icon IS 'Icon';


--
-- Name: COLUMN mail_activity_type.decoration_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.decoration_type IS 'Decoration Type';


--
-- Name: COLUMN mail_activity_type.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.res_model IS 'Model';


--
-- Name: COLUMN mail_activity_type.chaining_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.chaining_type IS 'Chaining Type';


--
-- Name: COLUMN mail_activity_type.category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.category IS 'Action';


--
-- Name: COLUMN mail_activity_type.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.name IS 'Name';


--
-- Name: COLUMN mail_activity_type.summary; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.summary IS 'Default Summary';


--
-- Name: COLUMN mail_activity_type.default_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.default_note IS 'Default Note';


--
-- Name: COLUMN mail_activity_type.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.active IS 'Active';


--
-- Name: COLUMN mail_activity_type.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.create_date IS 'Created on';


--
-- Name: COLUMN mail_activity_type.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_activity_type.write_date IS 'Last Updated on';


--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_activity_type_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_activity_type_id_seq OWNER TO runbot;

--
-- Name: mail_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_activity_type_id_seq OWNED BY public.mail_activity_type.id;


--
-- Name: mail_activity_type_mail_template_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_activity_type_mail_template_rel (
    mail_activity_type_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_activity_type_mail_template_rel OWNER TO runbot;

--
-- Name: TABLE mail_activity_type_mail_template_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_activity_type_mail_template_rel IS 'RELATION BETWEEN mail_activity_type AND mail_template';


--
-- Name: mail_alias; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias (
    id integer NOT NULL,
    alias_domain_id integer,
    alias_model_id integer NOT NULL,
    alias_force_thread_id integer,
    alias_parent_model_id integer,
    alias_parent_thread_id integer,
    create_uid integer,
    write_uid integer,
    alias_name character varying,
    alias_full_name character varying,
    alias_contact character varying NOT NULL,
    alias_status character varying,
    alias_bounced_content jsonb,
    alias_defaults text NOT NULL,
    alias_incoming_local boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias OWNER TO runbot;

--
-- Name: TABLE mail_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias IS 'Email Aliases';


--
-- Name: COLUMN mail_alias.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_alias.alias_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_model_id IS 'Aliased Model';


--
-- Name: COLUMN mail_alias.alias_force_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_force_thread_id IS 'Record Thread ID';


--
-- Name: COLUMN mail_alias.alias_parent_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_model_id IS 'Parent Model';


--
-- Name: COLUMN mail_alias.alias_parent_thread_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_parent_thread_id IS 'Parent Record Thread ID';


--
-- Name: COLUMN mail_alias.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias.alias_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_name IS 'Alias Name';


--
-- Name: COLUMN mail_alias.alias_full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_full_name IS 'Alias Email';


--
-- Name: COLUMN mail_alias.alias_contact; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_contact IS 'Alias Contact Security';


--
-- Name: COLUMN mail_alias.alias_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_status IS 'Alias Status';


--
-- Name: COLUMN mail_alias.alias_bounced_content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_bounced_content IS 'Custom Bounced Message';


--
-- Name: COLUMN mail_alias.alias_defaults; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_defaults IS 'Default Values';


--
-- Name: COLUMN mail_alias.alias_incoming_local; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.alias_incoming_local IS 'Local-part based incoming detection';


--
-- Name: COLUMN mail_alias.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_alias_domain (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    bounce_alias character varying NOT NULL,
    catchall_alias character varying NOT NULL,
    default_from character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_alias_domain OWNER TO runbot;

--
-- Name: TABLE mail_alias_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_alias_domain IS 'Email Domain';


--
-- Name: COLUMN mail_alias_domain.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.sequence IS 'Sequence';


--
-- Name: COLUMN mail_alias_domain.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_uid IS 'Created by';


--
-- Name: COLUMN mail_alias_domain.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_alias_domain.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.name IS 'Name';


--
-- Name: COLUMN mail_alias_domain.bounce_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.bounce_alias IS 'Bounce Alias';


--
-- Name: COLUMN mail_alias_domain.catchall_alias; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.catchall_alias IS 'Catchall Alias';


--
-- Name: COLUMN mail_alias_domain.default_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.default_from IS 'Default From Alias';


--
-- Name: COLUMN mail_alias_domain.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.create_date IS 'Created on';


--
-- Name: COLUMN mail_alias_domain.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_alias_domain.write_date IS 'Last Updated on';


--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_domain_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_domain_id_seq OWNER TO runbot;

--
-- Name: mail_alias_domain_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_domain_id_seq OWNED BY public.mail_alias_domain.id;


--
-- Name: mail_alias_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_alias_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_alias_id_seq OWNER TO runbot;

--
-- Name: mail_alias_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_alias_id_seq OWNED BY public.mail_alias.id;


--
-- Name: mail_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist OWNER TO runbot;

--
-- Name: TABLE mail_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist IS 'Mail Blacklist';


--
-- Name: COLUMN mail_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.email IS 'Email Address';


--
-- Name: COLUMN mail_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.active IS 'Active';


--
-- Name: COLUMN mail_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_id_seq OWNED BY public.mail_blacklist.id;


--
-- Name: mail_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE mail_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_blacklist_remove IS 'Remove email from blacklist wizard';


--
-- Name: COLUMN mail_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN mail_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_blacklist_remove.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.email IS 'Email';


--
-- Name: COLUMN mail_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN mail_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN mail_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: mail_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_blacklist_remove_id_seq OWNED BY public.mail_blacklist_remove.id;


--
-- Name: mail_canned_response; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source character varying NOT NULL,
    substitution text NOT NULL,
    is_shared boolean,
    last_used timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_canned_response OWNER TO runbot;

--
-- Name: TABLE mail_canned_response; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response IS 'Canned Response';


--
-- Name: COLUMN mail_canned_response.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_uid IS 'Created by';


--
-- Name: COLUMN mail_canned_response.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_canned_response.source; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.source IS 'Shortcut';


--
-- Name: COLUMN mail_canned_response.substitution; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.substitution IS 'Substitution';


--
-- Name: COLUMN mail_canned_response.is_shared; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.is_shared IS 'Determines if the canned_response is currently shared with other users';


--
-- Name: COLUMN mail_canned_response.last_used; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.last_used IS 'Last Used';


--
-- Name: COLUMN mail_canned_response.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.create_date IS 'Created on';


--
-- Name: COLUMN mail_canned_response.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_canned_response.write_date IS 'Last Updated on';


--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_canned_response_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_canned_response_id_seq OWNER TO runbot;

--
-- Name: mail_canned_response_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_canned_response_id_seq OWNED BY public.mail_canned_response.id;


--
-- Name: mail_canned_response_res_groups_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_canned_response_res_groups_rel (
    mail_canned_response_id integer NOT NULL,
    res_groups_id integer NOT NULL
);


ALTER TABLE public.mail_canned_response_res_groups_rel OWNER TO runbot;

--
-- Name: TABLE mail_canned_response_res_groups_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_canned_response_res_groups_rel IS 'RELATION BETWEEN mail_canned_response AND res_groups';


--
-- Name: mail_compose_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message (
    id integer NOT NULL,
    template_id integer,
    parent_id integer,
    author_id integer,
    res_domain_user_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    lang character varying,
    subject character varying,
    email_layout_xmlid character varying,
    email_from character varying,
    composition_mode character varying,
    composition_comment_option character varying,
    model character varying,
    message_type character varying NOT NULL,
    reply_to character varying,
    scheduled_date character varying,
    template_name character varying,
    body text,
    res_ids text,
    res_domain text,
    email_add_signature boolean,
    reply_to_force_new boolean,
    auto_delete boolean,
    auto_delete_keep_log boolean,
    force_send boolean,
    notify_author boolean,
    notify_author_mention boolean,
    notify_skip_followers boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_compose_message OWNER TO runbot;

--
-- Name: TABLE mail_compose_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message IS 'Email composition wizard';


--
-- Name: COLUMN mail_compose_message.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_id IS 'Use template';


--
-- Name: COLUMN mail_compose_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_compose_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.author_id IS 'Author';


--
-- Name: COLUMN mail_compose_message.res_domain_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain_user_id IS 'Responsible';


--
-- Name: COLUMN mail_compose_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_compose_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_compose_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_compose_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_compose_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_compose_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_compose_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_compose_message.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.lang IS 'Language';


--
-- Name: COLUMN mail_compose_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.subject IS 'Subject';


--
-- Name: COLUMN mail_compose_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_compose_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_from IS 'From';


--
-- Name: COLUMN mail_compose_message.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_mode IS 'Composition mode';


--
-- Name: COLUMN mail_compose_message.composition_comment_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.composition_comment_option IS 'Comment Options';


--
-- Name: COLUMN mail_compose_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_compose_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.message_type IS 'Type';


--
-- Name: COLUMN mail_compose_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_compose_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_compose_message.template_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.template_name IS 'Template Name';


--
-- Name: COLUMN mail_compose_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.body IS 'Contents';


--
-- Name: COLUMN mail_compose_message.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_compose_message.res_domain; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.res_domain IS 'Active domain';


--
-- Name: COLUMN mail_compose_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.email_add_signature IS 'Add signature';


--
-- Name: COLUMN mail_compose_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.reply_to_force_new IS 'Considers answers as new thread';


--
-- Name: COLUMN mail_compose_message.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete IS 'Delete Emails';


--
-- Name: COLUMN mail_compose_message.auto_delete_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.auto_delete_keep_log IS 'Keep Message Copy';


--
-- Name: COLUMN mail_compose_message.force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.force_send IS 'Send mailing or notifications directly';


--
-- Name: COLUMN mail_compose_message.notify_author; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_author IS 'Notify Author';


--
-- Name: COLUMN mail_compose_message.notify_author_mention; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_author_mention IS 'Notify Author Mention';


--
-- Name: COLUMN mail_compose_message.notify_skip_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.notify_skip_followers IS 'Notify Skip Followers';


--
-- Name: COLUMN mail_compose_message.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.use_exclusion_list IS 'Use Exclusion List';


--
-- Name: COLUMN mail_compose_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_compose_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_compose_message.write_date IS 'Last Updated on';


--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_compose_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_compose_message_id_seq OWNER TO runbot;

--
-- Name: mail_compose_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_compose_message_id_seq OWNED BY public.mail_compose_message.id;


--
-- Name: mail_compose_message_ir_attachments_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_ir_attachments_rel (
    wizard_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_ir_attachments_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_ir_attachments_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_ir_attachments_rel IS 'RELATION BETWEEN mail_compose_message AND ir_attachment';


--
-- Name: mail_compose_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_compose_message_res_partner_rel (
    wizard_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.mail_compose_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_compose_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_compose_message_res_partner_rel IS 'RELATION BETWEEN mail_compose_message AND res_partner';


--
-- Name: mail_followers; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers (
    id integer NOT NULL,
    res_id integer,
    partner_id integer NOT NULL,
    res_model character varying NOT NULL
);


ALTER TABLE public.mail_followers OWNER TO runbot;

--
-- Name: TABLE mail_followers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers IS 'Document Followers';


--
-- Name: COLUMN mail_followers.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_followers.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.partner_id IS 'Related Partner';


--
-- Name: COLUMN mail_followers.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers.res_model IS 'Related Document Model Name';


--
-- Name: mail_followers_edit; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_edit (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    res_ids character varying,
    operation character varying NOT NULL,
    message text,
    notify boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_followers_edit OWNER TO runbot;

--
-- Name: TABLE mail_followers_edit; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_edit IS 'Followers edit wizard';


--
-- Name: COLUMN mail_followers_edit.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.create_uid IS 'Created by';


--
-- Name: COLUMN mail_followers_edit.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_followers_edit.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.res_model IS 'Related Document Model';


--
-- Name: COLUMN mail_followers_edit.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.res_ids IS 'Related Document IDs';


--
-- Name: COLUMN mail_followers_edit.operation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.operation IS 'Operation';


--
-- Name: COLUMN mail_followers_edit.message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.message IS 'Message';


--
-- Name: COLUMN mail_followers_edit.notify; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.notify IS 'Notify Recipients';


--
-- Name: COLUMN mail_followers_edit.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.create_date IS 'Created on';


--
-- Name: COLUMN mail_followers_edit.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_followers_edit.write_date IS 'Last Updated on';


--
-- Name: mail_followers_edit_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_edit_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_edit_id_seq OWNER TO runbot;

--
-- Name: mail_followers_edit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_edit_id_seq OWNED BY public.mail_followers_edit.id;


--
-- Name: mail_followers_edit_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_edit_res_partner_rel (
    mail_followers_edit_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_followers_edit_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_edit_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_edit_res_partner_rel IS 'RELATION BETWEEN mail_followers_edit AND res_partner';


--
-- Name: mail_followers_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_followers_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_followers_id_seq OWNER TO runbot;

--
-- Name: mail_followers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_followers_id_seq OWNED BY public.mail_followers.id;


--
-- Name: mail_followers_mail_message_subtype_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_followers_mail_message_subtype_rel (
    mail_followers_id integer NOT NULL,
    mail_message_subtype_id integer NOT NULL
);


ALTER TABLE public.mail_followers_mail_message_subtype_rel OWNER TO runbot;

--
-- Name: TABLE mail_followers_mail_message_subtype_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_followers_mail_message_subtype_rel IS 'RELATION BETWEEN mail_followers AND mail_message_subtype';


--
-- Name: mail_gateway_allowed; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_gateway_allowed (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    email character varying NOT NULL,
    email_normalized character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_gateway_allowed OWNER TO runbot;

--
-- Name: TABLE mail_gateway_allowed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_gateway_allowed IS 'Mail Gateway Allowed';


--
-- Name: COLUMN mail_gateway_allowed.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_uid IS 'Created by';


--
-- Name: COLUMN mail_gateway_allowed.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_gateway_allowed.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email IS 'Email Address';


--
-- Name: COLUMN mail_gateway_allowed.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN mail_gateway_allowed.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.create_date IS 'Created on';


--
-- Name: COLUMN mail_gateway_allowed.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_gateway_allowed.write_date IS 'Last Updated on';


--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_gateway_allowed_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNER TO runbot;

--
-- Name: mail_gateway_allowed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_gateway_allowed_id_seq OWNED BY public.mail_gateway_allowed.id;


--
-- Name: mail_guest; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_guest (
    id integer NOT NULL,
    country_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    access_token character varying NOT NULL,
    email character varying,
    lang character varying,
    timezone character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_guest OWNER TO runbot;

--
-- Name: TABLE mail_guest; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_guest IS 'Guest';


--
-- Name: COLUMN mail_guest.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.country_id IS 'Country';


--
-- Name: COLUMN mail_guest.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_uid IS 'Created by';


--
-- Name: COLUMN mail_guest.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_guest.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.name IS 'Name';


--
-- Name: COLUMN mail_guest.access_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.access_token IS 'Access Token';


--
-- Name: COLUMN mail_guest.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.email IS 'Email';


--
-- Name: COLUMN mail_guest.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.lang IS 'Language';


--
-- Name: COLUMN mail_guest.timezone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.timezone IS 'Timezone';


--
-- Name: COLUMN mail_guest.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.create_date IS 'Created on';


--
-- Name: COLUMN mail_guest.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_guest.write_date IS 'Last Updated on';


--
-- Name: mail_guest_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_guest_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_guest_id_seq OWNER TO runbot;

--
-- Name: mail_guest_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_guest_id_seq OWNED BY public.mail_guest.id;


--
-- Name: mail_ice_server; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_ice_server (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    server_type character varying NOT NULL,
    uri character varying NOT NULL,
    username character varying,
    credential character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_ice_server OWNER TO runbot;

--
-- Name: TABLE mail_ice_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_ice_server IS 'ICE Server';


--
-- Name: COLUMN mail_ice_server.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_uid IS 'Created by';


--
-- Name: COLUMN mail_ice_server.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_ice_server.server_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.server_type IS 'Type';


--
-- Name: COLUMN mail_ice_server.uri; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.uri IS 'URI';


--
-- Name: COLUMN mail_ice_server.username; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.username IS 'Username';


--
-- Name: COLUMN mail_ice_server.credential; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.credential IS 'Credential';


--
-- Name: COLUMN mail_ice_server.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.create_date IS 'Created on';


--
-- Name: COLUMN mail_ice_server.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_ice_server.write_date IS 'Last Updated on';


--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_ice_server_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_ice_server_id_seq OWNER TO runbot;

--
-- Name: mail_ice_server_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_ice_server_id_seq OWNED BY public.mail_ice_server.id;


--
-- Name: mail_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_link_preview (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_url character varying NOT NULL,
    og_type character varying,
    og_title character varying,
    og_site_name character varying,
    og_image character varying,
    og_mimetype character varying,
    image_mimetype character varying,
    og_description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_link_preview IS 'Store link preview data';


--
-- Name: COLUMN mail_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_link_preview.source_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.source_url IS 'URL';


--
-- Name: COLUMN mail_link_preview.og_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_type IS 'Type';


--
-- Name: COLUMN mail_link_preview.og_title; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_title IS 'Title';


--
-- Name: COLUMN mail_link_preview.og_site_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_site_name IS 'Site name';


--
-- Name: COLUMN mail_link_preview.og_image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_image IS 'Image';


--
-- Name: COLUMN mail_link_preview.og_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_mimetype IS 'MIME type';


--
-- Name: COLUMN mail_link_preview.image_mimetype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.image_mimetype IS 'Image MIME type';


--
-- Name: COLUMN mail_link_preview.og_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.og_description IS 'Description';


--
-- Name: COLUMN mail_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.create_date IS 'Create Date';


--
-- Name: COLUMN mail_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_link_preview_id_seq OWNED BY public.mail_link_preview.id;


--
-- Name: mail_mail; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    fetchmail_server_id integer,
    create_uid integer,
    write_uid integer,
    email_cc character varying,
    state character varying,
    failure_type character varying,
    body_html text,
    "references" text,
    headers text,
    email_to text,
    failure_reason text,
    is_notification boolean,
    auto_delete boolean,
    scheduled_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_mail OWNER TO runbot;

--
-- Name: TABLE mail_mail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail IS 'Outgoing Mails';


--
-- Name: COLUMN mail_mail.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_mail.fetchmail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.fetchmail_server_id IS 'Inbound Mail Server';


--
-- Name: COLUMN mail_mail.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_uid IS 'Created by';


--
-- Name: COLUMN mail_mail.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_mail.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_cc IS 'Cc';


--
-- Name: COLUMN mail_mail.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.state IS 'Status';


--
-- Name: COLUMN mail_mail.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_mail.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.body_html IS 'Text Contents';


--
-- Name: COLUMN mail_mail."references"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail."references" IS 'References';


--
-- Name: COLUMN mail_mail.headers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.headers IS 'Headers';


--
-- Name: COLUMN mail_mail.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.email_to IS 'To';


--
-- Name: COLUMN mail_mail.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.failure_reason IS 'Failure Reason';


--
-- Name: COLUMN mail_mail.is_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.is_notification IS 'Notification Email';


--
-- Name: COLUMN mail_mail.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_mail.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.scheduled_date IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_mail.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.create_date IS 'Created on';


--
-- Name: COLUMN mail_mail.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_mail.write_date IS 'Last Updated on';


--
-- Name: mail_mail_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_mail_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_mail_id_seq OWNER TO runbot;

--
-- Name: mail_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_mail_id_seq OWNED BY public.mail_mail.id;


--
-- Name: mail_mail_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_mail_res_partner_rel (
    mail_mail_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_mail_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_mail_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_mail_res_partner_rel IS 'RELATION BETWEEN mail_mail AND res_partner';


--
-- Name: mail_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message (
    id integer NOT NULL,
    parent_id integer,
    res_id integer,
    record_alias_domain_id integer,
    record_company_id integer,
    subtype_id integer,
    mail_activity_type_id integer,
    author_id integer,
    author_guest_id integer,
    mail_server_id integer,
    create_uid integer,
    write_uid integer,
    subject character varying,
    model character varying,
    message_type character varying NOT NULL,
    email_from character varying,
    incoming_email_cc character varying,
    outgoing_email_to character varying,
    message_id character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    body text,
    incoming_email_to text,
    is_internal boolean,
    reply_to_force_new boolean,
    email_add_signature boolean,
    date timestamp without time zone,
    pinned_at timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message OWNER TO runbot;

--
-- Name: TABLE mail_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message IS 'Message';


--
-- Name: COLUMN mail_message.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.parent_id IS 'Parent Message';


--
-- Name: COLUMN mail_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.res_id IS 'Related Document ID';


--
-- Name: COLUMN mail_message.record_alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_alias_domain_id IS 'Alias Domain';


--
-- Name: COLUMN mail_message.record_company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.record_company_id IS 'Company';


--
-- Name: COLUMN mail_message.subtype_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subtype_id IS 'Subtype';


--
-- Name: COLUMN mail_message.mail_activity_type_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_activity_type_id IS 'Mail Activity Type';


--
-- Name: COLUMN mail_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_id IS 'Author';


--
-- Name: COLUMN mail_message.author_guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.author_guest_id IS 'Guest';


--
-- Name: COLUMN mail_message.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.mail_server_id IS 'Outgoing mail server';


--
-- Name: COLUMN mail_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.subject IS 'Subject';


--
-- Name: COLUMN mail_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_message.message_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_type IS 'Type';


--
-- Name: COLUMN mail_message.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_from IS 'From';


--
-- Name: COLUMN mail_message.incoming_email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_cc IS 'Emails Cc';


--
-- Name: COLUMN mail_message.outgoing_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.outgoing_email_to IS 'emails To';


--
-- Name: COLUMN mail_message.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.message_id IS 'Message-Id';


--
-- Name: COLUMN mail_message.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to IS 'Reply-To';


--
-- Name: COLUMN mail_message.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_layout_xmlid IS 'Layout';


--
-- Name: COLUMN mail_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.body IS 'Contents';


--
-- Name: COLUMN mail_message.incoming_email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.incoming_email_to IS 'Emails To';


--
-- Name: COLUMN mail_message.is_internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.is_internal IS 'Employee Only';


--
-- Name: COLUMN mail_message.reply_to_force_new; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.reply_to_force_new IS 'No threading for answers';


--
-- Name: COLUMN mail_message.email_add_signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.email_add_signature IS 'Email Add Signature';


--
-- Name: COLUMN mail_message.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.date IS 'Date';


--
-- Name: COLUMN mail_message.pinned_at; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.pinned_at IS 'Pinned';


--
-- Name: COLUMN mail_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message.write_date IS 'Last Updated on';


--
-- Name: mail_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_id_seq OWNER TO runbot;

--
-- Name: mail_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_id_seq OWNED BY public.mail_message.id;


--
-- Name: mail_message_link_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_link_preview (
    id integer NOT NULL,
    message_id integer NOT NULL,
    link_preview_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    is_hidden boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_link_preview OWNER TO runbot;

--
-- Name: TABLE mail_message_link_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_link_preview IS 'Link between link previews and messages';


--
-- Name: COLUMN mail_message_link_preview.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.message_id IS 'Message';


--
-- Name: COLUMN mail_message_link_preview.link_preview_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.link_preview_id IS 'Link Preview';


--
-- Name: COLUMN mail_message_link_preview.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_link_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_link_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_link_preview.is_hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.is_hidden IS 'Is Hidden';


--
-- Name: COLUMN mail_message_link_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_link_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_link_preview.write_date IS 'Last Updated on';


--
-- Name: mail_message_link_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_link_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_link_preview_id_seq OWNER TO runbot;

--
-- Name: mail_message_link_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_link_preview_id_seq OWNED BY public.mail_message_link_preview.id;


--
-- Name: mail_message_reaction; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_reaction (
    id integer NOT NULL,
    message_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    content character varying NOT NULL,
    CONSTRAINT mail_message_reaction_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_message_reaction OWNER TO runbot;

--
-- Name: TABLE mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_reaction IS 'Message Reaction';


--
-- Name: COLUMN mail_message_reaction.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.message_id IS 'Message';


--
-- Name: COLUMN mail_message_reaction.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.partner_id IS 'Reacting Partner';


--
-- Name: COLUMN mail_message_reaction.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.guest_id IS 'Reacting Guest';


--
-- Name: COLUMN mail_message_reaction.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_reaction.content IS 'Content';


--
-- Name: CONSTRAINT mail_message_reaction_partner_or_guest_exists ON mail_message_reaction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_message_reaction_partner_or_guest_exists ON public.mail_message_reaction IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_reaction_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_reaction_id_seq OWNER TO runbot;

--
-- Name: mail_message_reaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_reaction_id_seq OWNED BY public.mail_message_reaction.id;


--
-- Name: mail_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_res_partner_starred_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_res_partner_starred_rel (
    mail_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_message_res_partner_starred_rel OWNER TO runbot;

--
-- Name: TABLE mail_message_res_partner_starred_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_res_partner_starred_rel IS 'RELATION BETWEEN mail_message AND res_partner';


--
-- Name: mail_message_schedule; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_schedule (
    id integer NOT NULL,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    notification_parameters text,
    scheduled_datetime timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_schedule OWNER TO runbot;

--
-- Name: TABLE mail_message_schedule; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_schedule IS 'Scheduled Messages';


--
-- Name: COLUMN mail_message_schedule.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_message_schedule.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_schedule.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_schedule.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.notification_parameters IS 'Notification Parameter';


--
-- Name: COLUMN mail_message_schedule.scheduled_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.scheduled_datetime IS 'Scheduled Send Date';


--
-- Name: COLUMN mail_message_schedule.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_schedule.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_schedule.write_date IS 'Last Updated on';


--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_schedule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_schedule_id_seq OWNER TO runbot;

--
-- Name: mail_message_schedule_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_schedule_id_seq OWNED BY public.mail_message_schedule.id;


--
-- Name: mail_message_subtype; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_subtype (
    id integer NOT NULL,
    parent_id integer,
    sequence integer,
    create_uid integer,
    write_uid integer,
    relation_field character varying,
    res_model character varying,
    name jsonb NOT NULL,
    description jsonb,
    internal boolean,
    "default" boolean,
    hidden boolean,
    track_recipients boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_subtype OWNER TO runbot;

--
-- Name: TABLE mail_message_subtype; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_subtype IS 'Message subtypes';


--
-- Name: COLUMN mail_message_subtype.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.parent_id IS 'Parent';


--
-- Name: COLUMN mail_message_subtype.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.sequence IS 'Sequence';


--
-- Name: COLUMN mail_message_subtype.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_subtype.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_subtype.relation_field; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.relation_field IS 'Relation field';


--
-- Name: COLUMN mail_message_subtype.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.res_model IS 'Model';


--
-- Name: COLUMN mail_message_subtype.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.name IS 'Message Type';


--
-- Name: COLUMN mail_message_subtype.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.description IS 'Description';


--
-- Name: COLUMN mail_message_subtype.internal; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.internal IS 'Internal Only';


--
-- Name: COLUMN mail_message_subtype."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype."default" IS 'Default';


--
-- Name: COLUMN mail_message_subtype.hidden; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.hidden IS 'Hidden';


--
-- Name: COLUMN mail_message_subtype.track_recipients; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.track_recipients IS 'Track Recipients';


--
-- Name: COLUMN mail_message_subtype.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.create_date IS 'Created on';


--
-- Name: COLUMN mail_message_subtype.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_subtype.write_date IS 'Last Updated on';


--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_subtype_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_subtype_id_seq OWNER TO runbot;

--
-- Name: mail_message_subtype_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_subtype_id_seq OWNED BY public.mail_message_subtype.id;


--
-- Name: mail_message_translation; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_message_translation (
    id integer NOT NULL,
    message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    source_lang character varying NOT NULL,
    target_lang character varying NOT NULL,
    body text NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_message_translation OWNER TO runbot;

--
-- Name: TABLE mail_message_translation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_message_translation IS 'Message Translation';


--
-- Name: COLUMN mail_message_translation.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.message_id IS 'Message';


--
-- Name: COLUMN mail_message_translation.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_uid IS 'Created by';


--
-- Name: COLUMN mail_message_translation.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_message_translation.source_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.source_lang IS 'Source Language';


--
-- Name: COLUMN mail_message_translation.target_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.target_lang IS 'Target Language';


--
-- Name: COLUMN mail_message_translation.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.body IS 'Translation Body';


--
-- Name: COLUMN mail_message_translation.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.create_date IS 'Create Date';


--
-- Name: COLUMN mail_message_translation.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_message_translation.write_date IS 'Last Updated on';


--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_message_translation_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_message_translation_id_seq OWNER TO runbot;

--
-- Name: mail_message_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_message_translation_id_seq OWNED BY public.mail_message_translation.id;


--
-- Name: mail_notification; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_notification (
    id integer NOT NULL,
    author_id integer,
    mail_message_id integer NOT NULL,
    mail_mail_id integer,
    res_partner_id integer,
    mail_email_address character varying,
    notification_type character varying NOT NULL,
    notification_status character varying,
    failure_type character varying,
    failure_reason text,
    is_read boolean,
    read_date timestamp without time zone,
    sms_id_int integer,
    sms_number character varying,
    letter_id integer,
    CONSTRAINT mail_notification_notification_partner_or_email_required CHECK ((((notification_type)::text <> 'email'::text) OR (failure_type IS NOT NULL) OR (res_partner_id IS NOT NULL) OR ((COALESCE(mail_email_address, ''::character varying))::text <> ''::text))),
    CONSTRAINT mail_notification_notification_partner_required CHECK ((((notification_type)::text <> 'inbox'::text) OR (res_partner_id IS NOT NULL)))
);


ALTER TABLE public.mail_notification OWNER TO runbot;

--
-- Name: TABLE mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_notification IS 'Message Notifications';


--
-- Name: COLUMN mail_notification.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.author_id IS 'Author';


--
-- Name: COLUMN mail_notification.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_message_id IS 'Message';


--
-- Name: COLUMN mail_notification.mail_mail_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_mail_id IS 'Mail';


--
-- Name: COLUMN mail_notification.res_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.res_partner_id IS 'Recipient';


--
-- Name: COLUMN mail_notification.mail_email_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.mail_email_address IS 'Mail Email Address';


--
-- Name: COLUMN mail_notification.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_type IS 'Notification Type';


--
-- Name: COLUMN mail_notification.notification_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.notification_status IS 'Status';


--
-- Name: COLUMN mail_notification.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_type IS 'Failure type';


--
-- Name: COLUMN mail_notification.failure_reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.failure_reason IS 'Failure reason';


--
-- Name: COLUMN mail_notification.is_read; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.is_read IS 'Is Read';


--
-- Name: COLUMN mail_notification.read_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.read_date IS 'Read Date';


--
-- Name: COLUMN mail_notification.sms_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_id_int IS 'SMS ID';


--
-- Name: COLUMN mail_notification.sms_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.sms_number IS 'SMS Number';


--
-- Name: COLUMN mail_notification.letter_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_notification.letter_id IS 'Snailmail Letter';


--
-- Name: CONSTRAINT mail_notification_notification_partner_or_email_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_or_email_required ON public.mail_notification IS 'CHECK(notification_type != ''email'' OR failure_type IS NOT NULL OR res_partner_id IS NOT NULL OR COALESCE(mail_email_address, '''') != '''')';


--
-- Name: CONSTRAINT mail_notification_notification_partner_required ON mail_notification; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_notification_notification_partner_required ON public.mail_notification IS 'CHECK(notification_type != ''inbox'' OR res_partner_id IS NOT NULL)';


--
-- Name: mail_notification_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_notification_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_notification_id_seq OWNER TO runbot;

--
-- Name: mail_notification_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_notification_id_seq OWNED BY public.mail_notification.id;


--
-- Name: mail_presence; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_presence (
    id integer NOT NULL,
    user_id integer,
    guest_id integer,
    status character varying,
    last_poll timestamp without time zone,
    last_presence timestamp without time zone,
    CONSTRAINT mail_presence_partner_or_guest_exists CHECK ((((user_id IS NOT NULL) AND (guest_id IS NULL)) OR ((user_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.mail_presence OWNER TO runbot;

--
-- Name: TABLE mail_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_presence IS 'User/Guest Presence';


--
-- Name: COLUMN mail_presence.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.user_id IS 'Users';


--
-- Name: COLUMN mail_presence.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.guest_id IS 'Guest';


--
-- Name: COLUMN mail_presence.status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.status IS 'IM Status';


--
-- Name: COLUMN mail_presence.last_poll; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.last_poll IS 'Last Poll';


--
-- Name: COLUMN mail_presence.last_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_presence.last_presence IS 'Last Presence';


--
-- Name: CONSTRAINT mail_presence_partner_or_guest_exists ON mail_presence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT mail_presence_partner_or_guest_exists ON public.mail_presence IS 'CHECK((user_id IS NOT NULL AND guest_id IS NULL) OR (user_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: mail_presence_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_presence_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_presence_id_seq OWNER TO runbot;

--
-- Name: mail_presence_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_presence_id_seq OWNED BY public.mail_presence.id;


--
-- Name: mail_push; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push (
    id integer NOT NULL,
    mail_push_device_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    payload text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push OWNER TO runbot;

--
-- Name: TABLE mail_push; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push IS 'Push Notifications';


--
-- Name: COLUMN mail_push.mail_push_device_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.mail_push_device_id IS 'devices';


--
-- Name: COLUMN mail_push.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push.payload; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.payload IS 'Payload';


--
-- Name: COLUMN mail_push.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.create_date IS 'Created on';


--
-- Name: COLUMN mail_push.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push.write_date IS 'Last Updated on';


--
-- Name: mail_push_device; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_push_device (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    endpoint character varying NOT NULL,
    keys character varying NOT NULL,
    expiration_time timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_push_device OWNER TO runbot;

--
-- Name: TABLE mail_push_device; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_push_device IS 'Push Notification Device';


--
-- Name: COLUMN mail_push_device.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.partner_id IS 'Partner';


--
-- Name: COLUMN mail_push_device.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_uid IS 'Created by';


--
-- Name: COLUMN mail_push_device.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_push_device.endpoint; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.endpoint IS 'Browser endpoint';


--
-- Name: COLUMN mail_push_device.keys; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.keys IS 'Browser keys';


--
-- Name: COLUMN mail_push_device.expiration_time; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.expiration_time IS 'Expiration Token Date';


--
-- Name: COLUMN mail_push_device.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.create_date IS 'Created on';


--
-- Name: COLUMN mail_push_device.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_push_device.write_date IS 'Last Updated on';


--
-- Name: mail_push_device_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_device_id_seq OWNER TO runbot;

--
-- Name: mail_push_device_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_device_id_seq OWNED BY public.mail_push_device.id;


--
-- Name: mail_push_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_push_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_push_id_seq OWNER TO runbot;

--
-- Name: mail_push_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_push_id_seq OWNED BY public.mail_push.id;


--
-- Name: mail_scheduled_message; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message (
    id integer NOT NULL,
    res_id integer NOT NULL,
    author_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    subject character varying,
    composition_comment_option character varying,
    model character varying NOT NULL,
    send_context jsonb,
    body text,
    notification_parameters text,
    is_note boolean,
    scheduled_date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_scheduled_message OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message IS 'Scheduled Message';


--
-- Name: COLUMN mail_scheduled_message.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.res_id IS 'Related Document Id';


--
-- Name: COLUMN mail_scheduled_message.author_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.author_id IS 'Author';


--
-- Name: COLUMN mail_scheduled_message.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_uid IS 'Created by';


--
-- Name: COLUMN mail_scheduled_message.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_scheduled_message.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.subject IS 'Subject';


--
-- Name: COLUMN mail_scheduled_message.composition_comment_option; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.composition_comment_option IS 'Comment Options';


--
-- Name: COLUMN mail_scheduled_message.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.model IS 'Related Document Model';


--
-- Name: COLUMN mail_scheduled_message.send_context; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.send_context IS 'Sending Context';


--
-- Name: COLUMN mail_scheduled_message.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.body IS 'Contents';


--
-- Name: COLUMN mail_scheduled_message.notification_parameters; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.notification_parameters IS 'Notification parameters';


--
-- Name: COLUMN mail_scheduled_message.is_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.is_note IS 'Is a note';


--
-- Name: COLUMN mail_scheduled_message.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_scheduled_message.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.create_date IS 'Created on';


--
-- Name: COLUMN mail_scheduled_message.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_scheduled_message.write_date IS 'Last Updated on';


--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_scheduled_message_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNER TO runbot;

--
-- Name: mail_scheduled_message_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_scheduled_message_id_seq OWNED BY public.mail_scheduled_message.id;


--
-- Name: mail_scheduled_message_res_partner_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_scheduled_message_res_partner_rel (
    mail_scheduled_message_id integer NOT NULL,
    res_partner_id integer NOT NULL
);


ALTER TABLE public.mail_scheduled_message_res_partner_rel OWNER TO runbot;

--
-- Name: TABLE mail_scheduled_message_res_partner_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_scheduled_message_res_partner_rel IS 'RELATION BETWEEN mail_scheduled_message AND res_partner';


--
-- Name: mail_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template (
    id integer NOT NULL,
    model_id integer,
    user_id integer,
    mail_server_id integer,
    ref_ir_act_window integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    email_from character varying,
    email_to character varying,
    partner_to character varying,
    email_cc character varying,
    reply_to character varying,
    email_layout_xmlid character varying,
    scheduled_date character varying,
    name jsonb,
    description jsonb,
    subject jsonb,
    body_html jsonb,
    active boolean,
    use_default_to boolean,
    auto_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template OWNER TO runbot;

--
-- Name: TABLE mail_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template IS 'Email Templates';


--
-- Name: COLUMN mail_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model_id IS 'Applies to';


--
-- Name: COLUMN mail_template.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.user_id IS 'Owner';


--
-- Name: COLUMN mail_template.mail_server_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.mail_server_id IS 'Outgoing Mail Server';


--
-- Name: COLUMN mail_template.ref_ir_act_window; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.ref_ir_act_window IS 'Sidebar action';


--
-- Name: COLUMN mail_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN mail_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.lang IS 'Language';


--
-- Name: COLUMN mail_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.model IS 'Related Document Model';


--
-- Name: COLUMN mail_template.email_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_from IS 'Send From';


--
-- Name: COLUMN mail_template.email_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_to IS 'To (Emails)';


--
-- Name: COLUMN mail_template.partner_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.partner_to IS 'To (Partners)';


--
-- Name: COLUMN mail_template.email_cc; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_cc IS 'Cc';


--
-- Name: COLUMN mail_template.reply_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.reply_to IS 'Reply To';


--
-- Name: COLUMN mail_template.email_layout_xmlid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.email_layout_xmlid IS 'Email Notification Layout';


--
-- Name: COLUMN mail_template.scheduled_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.scheduled_date IS 'Scheduled Date';


--
-- Name: COLUMN mail_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.name IS 'Name';


--
-- Name: COLUMN mail_template.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.description IS 'Template Description';


--
-- Name: COLUMN mail_template.subject; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.subject IS 'Subject';


--
-- Name: COLUMN mail_template.body_html; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.body_html IS 'Body';


--
-- Name: COLUMN mail_template.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.active IS 'Active';


--
-- Name: COLUMN mail_template.use_default_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.use_default_to IS 'Default Recipients';


--
-- Name: COLUMN mail_template.auto_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.auto_delete IS 'Auto Delete';


--
-- Name: COLUMN mail_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.create_date IS 'Created on';


--
-- Name: COLUMN mail_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template.write_date IS 'Last Updated on';


--
-- Name: mail_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_id_seq OWNER TO runbot;

--
-- Name: mail_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_id_seq OWNED BY public.mail_template.id;


--
-- Name: mail_template_ir_actions_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_ir_actions_report_rel (
    mail_template_id integer NOT NULL,
    ir_actions_report_id integer NOT NULL
);


ALTER TABLE public.mail_template_ir_actions_report_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_ir_actions_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_ir_actions_report_rel IS 'RELATION BETWEEN mail_template AND ir_act_report_xml';


--
-- Name: mail_template_mail_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_mail_template_reset_rel (
    mail_template_reset_id integer NOT NULL,
    mail_template_id integer NOT NULL
);


ALTER TABLE public.mail_template_mail_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE mail_template_mail_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_mail_template_reset_rel IS 'RELATION BETWEEN mail_template_reset AND mail_template';


--
-- Name: mail_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_preview (
    id integer NOT NULL,
    mail_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    resource_ref character varying,
    lang character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_preview OWNER TO runbot;

--
-- Name: TABLE mail_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_preview IS 'Email Template Preview';


--
-- Name: COLUMN mail_template_preview.mail_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.mail_template_id IS 'Related Mail Template';


--
-- Name: COLUMN mail_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.resource_ref IS 'Record';


--
-- Name: COLUMN mail_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN mail_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_preview.write_date IS 'Last Updated on';


--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_preview_id_seq OWNER TO runbot;

--
-- Name: mail_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_preview_id_seq OWNED BY public.mail_template_preview.id;


--
-- Name: mail_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.mail_template_reset OWNER TO runbot;

--
-- Name: TABLE mail_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_template_reset IS 'Mail Template Reset';


--
-- Name: COLUMN mail_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN mail_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN mail_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_template_reset.write_date IS 'Last Updated on';


--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_template_reset_id_seq OWNER TO runbot;

--
-- Name: mail_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_template_reset_id_seq OWNED BY public.mail_template_reset.id;


--
-- Name: mail_tracking_value; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.mail_tracking_value (
    id integer NOT NULL,
    field_id integer,
    old_value_integer integer,
    new_value_integer integer,
    currency_id integer,
    mail_message_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    old_value_char character varying,
    new_value_char character varying,
    field_info jsonb,
    old_value_text text,
    new_value_text text,
    old_value_datetime timestamp without time zone,
    new_value_datetime timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    old_value_float double precision,
    new_value_float double precision
);


ALTER TABLE public.mail_tracking_value OWNER TO runbot;

--
-- Name: TABLE mail_tracking_value; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.mail_tracking_value IS 'Mail Tracking Value';


--
-- Name: COLUMN mail_tracking_value.field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_id IS 'Field';


--
-- Name: COLUMN mail_tracking_value.old_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_integer IS 'Old Value Integer';


--
-- Name: COLUMN mail_tracking_value.new_value_integer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_integer IS 'New Value Integer';


--
-- Name: COLUMN mail_tracking_value.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.currency_id IS 'Currency';


--
-- Name: COLUMN mail_tracking_value.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.mail_message_id IS 'Message ID';


--
-- Name: COLUMN mail_tracking_value.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_uid IS 'Created by';


--
-- Name: COLUMN mail_tracking_value.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_uid IS 'Last Updated by';


--
-- Name: COLUMN mail_tracking_value.old_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_char IS 'Old Value Char';


--
-- Name: COLUMN mail_tracking_value.new_value_char; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_char IS 'New Value Char';


--
-- Name: COLUMN mail_tracking_value.field_info; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.field_info IS 'Removed field information';


--
-- Name: COLUMN mail_tracking_value.old_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_text IS 'Old Value Text';


--
-- Name: COLUMN mail_tracking_value.new_value_text; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_text IS 'New Value Text';


--
-- Name: COLUMN mail_tracking_value.old_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_datetime IS 'Old Value DateTime';


--
-- Name: COLUMN mail_tracking_value.new_value_datetime; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_datetime IS 'New Value Datetime';


--
-- Name: COLUMN mail_tracking_value.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.create_date IS 'Created on';


--
-- Name: COLUMN mail_tracking_value.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.write_date IS 'Last Updated on';


--
-- Name: COLUMN mail_tracking_value.old_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.old_value_float IS 'Old Value Float';


--
-- Name: COLUMN mail_tracking_value.new_value_float; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.mail_tracking_value.new_value_float IS 'New Value Float';


--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.mail_tracking_value_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.mail_tracking_value_id_seq OWNER TO runbot;

--
-- Name: mail_tracking_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.mail_tracking_value_id_seq OWNED BY public.mail_tracking_value.id;


--
-- Name: message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.message_attachment_rel (
    message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.message_attachment_rel IS 'RELATION BETWEEN mail_message AND ir_attachment';


--
-- Name: module_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.module_country (
    module_id integer NOT NULL,
    country_id integer NOT NULL
);


ALTER TABLE public.module_country OWNER TO runbot;

--
-- Name: TABLE module_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.module_country IS 'RELATION BETWEEN ir_module_module AND res_country';


--
-- Name: orm_signaling_assets; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_assets (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_assets OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_assets_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_assets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_assets_id_seq OWNED BY public.orm_signaling_assets.id;


--
-- Name: orm_signaling_default; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_default (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_default OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_default_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_default_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_default_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_default_id_seq OWNED BY public.orm_signaling_default.id;


--
-- Name: orm_signaling_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_groups (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_groups OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_groups_id_seq OWNED BY public.orm_signaling_groups.id;


--
-- Name: orm_signaling_registry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_registry (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_registry OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_registry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_registry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_registry_id_seq OWNED BY public.orm_signaling_registry.id;


--
-- Name: orm_signaling_routing; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_routing (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_routing OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_routing_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_routing_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_routing_id_seq OWNED BY public.orm_signaling_routing.id;


--
-- Name: orm_signaling_stable; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_stable (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_stable OWNER TO runbot;

--
-- Name: orm_signaling_stable_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_stable_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_stable_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_stable_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_stable_id_seq OWNED BY public.orm_signaling_stable.id;


--
-- Name: orm_signaling_templates; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.orm_signaling_templates (
    id integer NOT NULL,
    date timestamp without time zone DEFAULT now()
);


ALTER TABLE public.orm_signaling_templates OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.orm_signaling_templates_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNER TO runbot;

--
-- Name: orm_signaling_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.orm_signaling_templates_id_seq OWNED BY public.orm_signaling_templates.id;


--
-- Name: phone_blacklist; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    number character varying NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist OWNER TO runbot;

--
-- Name: TABLE phone_blacklist; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist IS 'Phone Blacklist';


--
-- Name: COLUMN phone_blacklist.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.number IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.active IS 'Active';


--
-- Name: COLUMN phone_blacklist.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_id_seq OWNED BY public.phone_blacklist.id;


--
-- Name: phone_blacklist_remove; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.phone_blacklist_remove (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone character varying NOT NULL,
    reason character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.phone_blacklist_remove OWNER TO runbot;

--
-- Name: TABLE phone_blacklist_remove; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.phone_blacklist_remove IS 'Remove phone from blacklist';


--
-- Name: COLUMN phone_blacklist_remove.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_uid IS 'Created by';


--
-- Name: COLUMN phone_blacklist_remove.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_uid IS 'Last Updated by';


--
-- Name: COLUMN phone_blacklist_remove.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.phone IS 'Phone Number';


--
-- Name: COLUMN phone_blacklist_remove.reason; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.reason IS 'Reason';


--
-- Name: COLUMN phone_blacklist_remove.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.create_date IS 'Created on';


--
-- Name: COLUMN phone_blacklist_remove.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.phone_blacklist_remove.write_date IS 'Last Updated on';


--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.phone_blacklist_remove_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNER TO runbot;

--
-- Name: phone_blacklist_remove_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.phone_blacklist_remove_id_seq OWNED BY public.phone_blacklist_remove.id;


--
-- Name: privacy_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_log (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    anonymized_name character varying NOT NULL,
    anonymized_email character varying NOT NULL,
    execution_details text,
    records_description text,
    additional_note text,
    date timestamp without time zone NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_log OWNER TO runbot;

--
-- Name: TABLE privacy_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_log IS 'Privacy Log';


--
-- Name: COLUMN privacy_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.user_id IS 'Handled By';


--
-- Name: COLUMN privacy_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_log.anonymized_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_name IS 'Anonymized Name';


--
-- Name: COLUMN privacy_log.anonymized_email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.anonymized_email IS 'Anonymized Email';


--
-- Name: COLUMN privacy_log.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_log.records_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.records_description IS 'Found Records';


--
-- Name: COLUMN privacy_log.additional_note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.additional_note IS 'Additional Note';


--
-- Name: COLUMN privacy_log.date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.date IS 'Date';


--
-- Name: COLUMN privacy_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.create_date IS 'Created on';


--
-- Name: COLUMN privacy_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_log.write_date IS 'Last Updated on';


--
-- Name: privacy_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_log_id_seq OWNER TO runbot;

--
-- Name: privacy_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_log_id_seq OWNED BY public.privacy_log.id;


--
-- Name: privacy_lookup_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard (
    id integer NOT NULL,
    log_id integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    email character varying NOT NULL,
    execution_details text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard IS 'Privacy Lookup Wizard';


--
-- Name: COLUMN privacy_lookup_wizard.log_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.log_id IS 'Log';


--
-- Name: COLUMN privacy_lookup_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.name IS 'Name';


--
-- Name: COLUMN privacy_lookup_wizard.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.email IS 'Email';


--
-- Name: COLUMN privacy_lookup_wizard.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_id_seq OWNED BY public.privacy_lookup_wizard.id;


--
-- Name: privacy_lookup_wizard_line; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.privacy_lookup_wizard_line (
    id integer NOT NULL,
    wizard_id integer,
    res_id integer NOT NULL,
    res_model_id integer,
    create_uid integer,
    write_uid integer,
    res_name character varying,
    res_model character varying,
    execution_details character varying,
    has_active boolean,
    is_active boolean,
    is_unlinked boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.privacy_lookup_wizard_line OWNER TO runbot;

--
-- Name: TABLE privacy_lookup_wizard_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.privacy_lookup_wizard_line IS 'Privacy Lookup Wizard Line';


--
-- Name: COLUMN privacy_lookup_wizard_line.wizard_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.wizard_id IS 'Wizard';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_id IS 'Resource ID';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model_id IS 'Related Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_uid IS 'Created by';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_uid IS 'Last Updated by';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_name IS 'Resource name';


--
-- Name: COLUMN privacy_lookup_wizard_line.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.res_model IS 'Document Model';


--
-- Name: COLUMN privacy_lookup_wizard_line.execution_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.execution_details IS 'Execution Details';


--
-- Name: COLUMN privacy_lookup_wizard_line.has_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.has_active IS 'Has Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_active IS 'Is Active';


--
-- Name: COLUMN privacy_lookup_wizard_line.is_unlinked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.is_unlinked IS 'Is Unlinked';


--
-- Name: COLUMN privacy_lookup_wizard_line.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.create_date IS 'Created on';


--
-- Name: COLUMN privacy_lookup_wizard_line.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.privacy_lookup_wizard_line.write_date IS 'Last Updated on';


--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.privacy_lookup_wizard_line_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNER TO runbot;

--
-- Name: privacy_lookup_wizard_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.privacy_lookup_wizard_line_id_seq OWNED BY public.privacy_lookup_wizard_line.id;


--
-- Name: properties_base_definition; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.properties_base_definition (
    id integer NOT NULL,
    properties_field_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    properties_definition jsonb,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.properties_base_definition OWNER TO runbot;

--
-- Name: TABLE properties_base_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.properties_base_definition IS 'Properties Base Definition';


--
-- Name: COLUMN properties_base_definition.properties_field_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.properties_field_id IS 'Properties Field';


--
-- Name: COLUMN properties_base_definition.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.create_uid IS 'Created by';


--
-- Name: COLUMN properties_base_definition.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.write_uid IS 'Last Updated by';


--
-- Name: COLUMN properties_base_definition.properties_definition; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.properties_definition IS 'Properties Definition';


--
-- Name: COLUMN properties_base_definition.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.create_date IS 'Created on';


--
-- Name: COLUMN properties_base_definition.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.properties_base_definition.write_date IS 'Last Updated on';


--
-- Name: properties_base_definition_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.properties_base_definition_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.properties_base_definition_id_seq OWNER TO runbot;

--
-- Name: properties_base_definition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.properties_base_definition_id_seq OWNED BY public.properties_base_definition.id;


--
-- Name: rel_modules_langexport; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rel_modules_langexport (
    wiz_id integer NOT NULL,
    module_id integer NOT NULL
);


ALTER TABLE public.rel_modules_langexport OWNER TO runbot;

--
-- Name: TABLE rel_modules_langexport; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rel_modules_langexport IS 'RELATION BETWEEN base_language_export AND ir_module_module';


--
-- Name: report_layout; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_layout (
    id integer NOT NULL,
    view_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    image character varying,
    pdf character varying,
    name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.report_layout OWNER TO runbot;

--
-- Name: TABLE report_layout; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_layout IS 'Report Layout';


--
-- Name: COLUMN report_layout.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.view_id IS 'Document Template';


--
-- Name: COLUMN report_layout.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.sequence IS 'Sequence';


--
-- Name: COLUMN report_layout.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_uid IS 'Created by';


--
-- Name: COLUMN report_layout.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_layout.image; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.image IS 'Preview image src';


--
-- Name: COLUMN report_layout.pdf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.pdf IS 'Preview pdf src';


--
-- Name: COLUMN report_layout.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.name IS 'Name';


--
-- Name: COLUMN report_layout.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.create_date IS 'Created on';


--
-- Name: COLUMN report_layout.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_layout.write_date IS 'Last Updated on';


--
-- Name: report_layout_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_layout_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_layout_id_seq OWNER TO runbot;

--
-- Name: report_layout_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_layout_id_seq OWNED BY public.report_layout.id;


--
-- Name: report_paperformat; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.report_paperformat (
    id integer NOT NULL,
    page_height integer,
    page_width integer,
    header_spacing integer,
    dpi integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    format character varying,
    orientation character varying,
    "default" boolean,
    header_line boolean,
    disable_shrinking boolean,
    css_margins boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    margin_top double precision,
    margin_bottom double precision,
    margin_left double precision,
    margin_right double precision
);


ALTER TABLE public.report_paperformat OWNER TO runbot;

--
-- Name: TABLE report_paperformat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.report_paperformat IS 'Paper Format Config';


--
-- Name: COLUMN report_paperformat.page_height; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_height IS 'Page height (mm)';


--
-- Name: COLUMN report_paperformat.page_width; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.page_width IS 'Page width (mm)';


--
-- Name: COLUMN report_paperformat.header_spacing; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_spacing IS 'Header spacing';


--
-- Name: COLUMN report_paperformat.dpi; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.dpi IS 'Output DPI';


--
-- Name: COLUMN report_paperformat.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_uid IS 'Created by';


--
-- Name: COLUMN report_paperformat.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_uid IS 'Last Updated by';


--
-- Name: COLUMN report_paperformat.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.name IS 'Name';


--
-- Name: COLUMN report_paperformat.format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.format IS 'Paper size';


--
-- Name: COLUMN report_paperformat.orientation; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.orientation IS 'Orientation';


--
-- Name: COLUMN report_paperformat."default"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat."default" IS 'Default paper format?';


--
-- Name: COLUMN report_paperformat.header_line; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.header_line IS 'Display a header line';


--
-- Name: COLUMN report_paperformat.disable_shrinking; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.disable_shrinking IS 'Disable smart shrinking';


--
-- Name: COLUMN report_paperformat.css_margins; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.css_margins IS 'Use css margins';


--
-- Name: COLUMN report_paperformat.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.create_date IS 'Created on';


--
-- Name: COLUMN report_paperformat.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.write_date IS 'Last Updated on';


--
-- Name: COLUMN report_paperformat.margin_top; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_top IS 'Top Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_bottom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_bottom IS 'Bottom Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_left; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_left IS 'Left Margin (mm)';


--
-- Name: COLUMN report_paperformat.margin_right; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.report_paperformat.margin_right IS 'Right Margin (mm)';


--
-- Name: report_paperformat_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.report_paperformat_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.report_paperformat_id_seq OWNER TO runbot;

--
-- Name: report_paperformat_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.report_paperformat_id_seq OWNED BY public.report_paperformat.id;


--
-- Name: res_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_bank (
    id integer NOT NULL,
    state integer,
    country integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    bic character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_bank OWNER TO runbot;

--
-- Name: TABLE res_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_bank IS 'Bank';


--
-- Name: COLUMN res_bank.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.state IS 'Fed. State';


--
-- Name: COLUMN res_bank.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.country IS 'Country';


--
-- Name: COLUMN res_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_bank.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.name IS 'Name';


--
-- Name: COLUMN res_bank.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street IS 'Street';


--
-- Name: COLUMN res_bank.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.street2 IS 'Street2';


--
-- Name: COLUMN res_bank.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.zip IS 'Zip';


--
-- Name: COLUMN res_bank.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.city IS 'City';


--
-- Name: COLUMN res_bank.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.email IS 'Email';


--
-- Name: COLUMN res_bank.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.phone IS 'Phone';


--
-- Name: COLUMN res_bank.bic; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.bic IS 'Bank Identifier Code';


--
-- Name: COLUMN res_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.active IS 'Active';


--
-- Name: COLUMN res_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_bank.write_date IS 'Last Updated on';


--
-- Name: res_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_bank_id_seq OWNER TO runbot;

--
-- Name: res_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_bank_id_seq OWNED BY public.res_bank.id;


--
-- Name: res_company; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company (
    id integer NOT NULL,
    name character varying NOT NULL,
    partner_id integer NOT NULL,
    currency_id integer NOT NULL,
    sequence integer,
    create_date timestamp without time zone,
    parent_path character varying,
    parent_id integer,
    paperformat_id integer,
    external_report_layout_id integer,
    create_uid integer,
    write_uid integer,
    email character varying,
    phone character varying,
    font character varying,
    primary_color character varying,
    secondary_color character varying,
    layout_background character varying NOT NULL,
    report_header jsonb,
    report_footer jsonb,
    company_details jsonb,
    active boolean,
    uses_default_logo boolean,
    write_date timestamp without time zone,
    logo_web bytea,
    alias_domain_id integer,
    email_primary_color character varying,
    email_secondary_color character varying,
    iap_enrich_auto_done boolean,
    snailmail_color boolean,
    snailmail_cover boolean,
    snailmail_duplex boolean
);


ALTER TABLE public.res_company OWNER TO runbot;

--
-- Name: COLUMN res_company.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.parent_id IS 'Parent Company';


--
-- Name: COLUMN res_company.paperformat_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.paperformat_id IS 'Paper format';


--
-- Name: COLUMN res_company.external_report_layout_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.external_report_layout_id IS 'Document Template';


--
-- Name: COLUMN res_company.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.create_uid IS 'Created by';


--
-- Name: COLUMN res_company.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_company.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email IS 'Email';


--
-- Name: COLUMN res_company.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.phone IS 'Phone';


--
-- Name: COLUMN res_company.font; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.font IS 'Font';


--
-- Name: COLUMN res_company.primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.primary_color IS 'Primary Color';


--
-- Name: COLUMN res_company.secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.secondary_color IS 'Secondary Color';


--
-- Name: COLUMN res_company.layout_background; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.layout_background IS 'Layout Background';


--
-- Name: COLUMN res_company.report_header; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_header IS 'Company Tagline';


--
-- Name: COLUMN res_company.report_footer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.report_footer IS 'Report Footer';


--
-- Name: COLUMN res_company.company_details; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.company_details IS 'Company Details';


--
-- Name: COLUMN res_company.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.active IS 'Active';


--
-- Name: COLUMN res_company.uses_default_logo; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.uses_default_logo IS 'Uses Default Logo';


--
-- Name: COLUMN res_company.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_company.logo_web; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.logo_web IS 'Logo Web';


--
-- Name: COLUMN res_company.alias_domain_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.alias_domain_id IS 'Email Domain';


--
-- Name: COLUMN res_company.email_primary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_primary_color IS 'Email Button Text';


--
-- Name: COLUMN res_company.email_secondary_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.email_secondary_color IS 'Email Button Color';


--
-- Name: COLUMN res_company.iap_enrich_auto_done; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.iap_enrich_auto_done IS 'Enrich Done';


--
-- Name: COLUMN res_company.snailmail_color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_color IS 'Snailmail Color';


--
-- Name: COLUMN res_company.snailmail_cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_cover IS 'Add a Cover Page';


--
-- Name: COLUMN res_company.snailmail_duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_company.snailmail_duplex IS 'Both sides';


--
-- Name: res_company_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_company_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_company_id_seq OWNER TO runbot;

--
-- Name: res_company_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_company_id_seq OWNED BY public.res_company.id;


--
-- Name: res_company_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_company_users_rel (
    cid integer NOT NULL,
    user_id integer NOT NULL
);


ALTER TABLE public.res_company_users_rel OWNER TO runbot;

--
-- Name: TABLE res_company_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_company_users_rel IS 'RELATION BETWEEN res_company AND res_users';


--
-- Name: res_config; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_config OWNER TO runbot;

--
-- Name: TABLE res_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config IS 'Config';


--
-- Name: COLUMN res_config.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_uid IS 'Created by';


--
-- Name: COLUMN res_config.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.create_date IS 'Created on';


--
-- Name: COLUMN res_config.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config.write_date IS 'Last Updated on';


--
-- Name: res_config_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_id_seq OWNER TO runbot;

--
-- Name: res_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_id_seq OWNED BY public.res_config.id;


--
-- Name: res_config_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_config_settings (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    web_app_name character varying,
    company_id integer NOT NULL,
    module_base_import boolean,
    module_google_calendar boolean,
    module_microsoft_calendar boolean,
    module_mail_plugin boolean,
    module_auth_oauth boolean,
    module_auth_ldap boolean,
    module_account_inter_company_rules boolean,
    module_voip boolean,
    module_web_unsplash boolean,
    module_sms boolean,
    module_partner_autocomplete boolean,
    module_base_geolocalize boolean,
    module_google_recaptcha boolean,
    module_website_cf_turnstile boolean,
    module_google_address_autocomplete boolean,
    group_multi_currency boolean,
    show_effect boolean,
    profiling_enabled_until timestamp without time zone,
    map_box_token character varying,
    twilio_account_sid character varying,
    twilio_account_token character varying,
    sfu_server_url character varying,
    sfu_server_key character varying,
    tenor_api_key character varying,
    google_translate_api_key character varying,
    external_email_server_default boolean,
    module_google_gmail boolean,
    module_microsoft_outlook boolean,
    restrict_template_rendering boolean,
    use_twilio_rtc_servers boolean,
    use_sfu_server boolean,
    unsplash_access_key character varying,
    unsplash_app_id character varying,
    auth_signup_template_user_id integer,
    auth_signup_uninvited character varying,
    auth_signup_reset_password boolean,
    auth_totp_policy character varying,
    auth_totp_enforce boolean,
    google_gmail_client_identifier character varying,
    google_gmail_client_secret character varying,
    microsoft_outlook_client_identifier character varying,
    microsoft_outlook_client_secret character varying,
    disable_redirect_firebase_dynamic_link boolean,
    enable_ocn boolean,
    openai_key character varying,
    google_key character varying
);


ALTER TABLE public.res_config_settings OWNER TO runbot;

--
-- Name: TABLE res_config_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_config_settings IS 'Config Settings';


--
-- Name: COLUMN res_config_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_config_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_config_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_config_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_config_settings.web_app_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.web_app_name IS 'Web App Name';


--
-- Name: COLUMN res_config_settings.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.company_id IS 'Company';


--
-- Name: COLUMN res_config_settings.module_base_import; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_import IS 'Allow users to import data from CSV/XLS/XLSX/ODS files';


--
-- Name: COLUMN res_config_settings.module_google_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_calendar IS 'Allow the users to synchronize their calendar  with Google Calendar';


--
-- Name: COLUMN res_config_settings.module_microsoft_calendar; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_calendar IS 'Allow the users to synchronize their calendar with Outlook Calendar';


--
-- Name: COLUMN res_config_settings.module_mail_plugin; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_mail_plugin IS 'Allow integration with the mail plugins';


--
-- Name: COLUMN res_config_settings.module_auth_oauth; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_oauth IS 'Use external authentication providers (OAuth)';


--
-- Name: COLUMN res_config_settings.module_auth_ldap; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_auth_ldap IS 'LDAP Authentication';


--
-- Name: COLUMN res_config_settings.module_account_inter_company_rules; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_account_inter_company_rules IS 'Manage Inter Company';


--
-- Name: COLUMN res_config_settings.module_voip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_voip IS 'Phone';


--
-- Name: COLUMN res_config_settings.module_web_unsplash; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_web_unsplash IS 'Unsplash Image Library';


--
-- Name: COLUMN res_config_settings.module_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_sms IS 'SMS';


--
-- Name: COLUMN res_config_settings.module_partner_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_partner_autocomplete IS 'Partner Autocomplete';


--
-- Name: COLUMN res_config_settings.module_base_geolocalize; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_base_geolocalize IS 'GeoLocalize';


--
-- Name: COLUMN res_config_settings.module_google_recaptcha; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_recaptcha IS 'reCAPTCHA';


--
-- Name: COLUMN res_config_settings.module_website_cf_turnstile; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_website_cf_turnstile IS 'Cloudflare Turnstile';


--
-- Name: COLUMN res_config_settings.module_google_address_autocomplete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_address_autocomplete IS 'Google Address Autocomplete';


--
-- Name: COLUMN res_config_settings.group_multi_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.group_multi_currency IS 'Multi-Currencies';


--
-- Name: COLUMN res_config_settings.show_effect; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.show_effect IS 'Show Effect';


--
-- Name: COLUMN res_config_settings.profiling_enabled_until; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.profiling_enabled_until IS 'Profiling enabled until';


--
-- Name: COLUMN res_config_settings.map_box_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.map_box_token IS 'Token Map Box';


--
-- Name: COLUMN res_config_settings.twilio_account_sid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_sid IS 'Account SID';


--
-- Name: COLUMN res_config_settings.twilio_account_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.twilio_account_token IS 'Account Auth Token';


--
-- Name: COLUMN res_config_settings.sfu_server_url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_url IS 'SFU Server URL';


--
-- Name: COLUMN res_config_settings.sfu_server_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.sfu_server_key IS 'SFU Server key';


--
-- Name: COLUMN res_config_settings.tenor_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.tenor_api_key IS 'Tenor API key';


--
-- Name: COLUMN res_config_settings.google_translate_api_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_translate_api_key IS 'Message Translation API Key';


--
-- Name: COLUMN res_config_settings.external_email_server_default; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.external_email_server_default IS 'Use Custom Email Servers';


--
-- Name: COLUMN res_config_settings.module_google_gmail; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_google_gmail IS 'Support Gmail Authentication';


--
-- Name: COLUMN res_config_settings.module_microsoft_outlook; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.module_microsoft_outlook IS 'Support Outlook Authentication';


--
-- Name: COLUMN res_config_settings.restrict_template_rendering; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.restrict_template_rendering IS 'Restrict Template Rendering';


--
-- Name: COLUMN res_config_settings.use_twilio_rtc_servers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_twilio_rtc_servers IS 'Use Twilio ICE servers';


--
-- Name: COLUMN res_config_settings.use_sfu_server; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.use_sfu_server IS 'Use SFU server';


--
-- Name: COLUMN res_config_settings.unsplash_access_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_access_key IS 'Access Key';


--
-- Name: COLUMN res_config_settings.unsplash_app_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.unsplash_app_id IS 'Application ID';


--
-- Name: COLUMN res_config_settings.auth_signup_template_user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_template_user_id IS 'Template user for new users created through signup';


--
-- Name: COLUMN res_config_settings.auth_signup_uninvited; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_uninvited IS 'Customer Account';


--
-- Name: COLUMN res_config_settings.auth_signup_reset_password; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_signup_reset_password IS 'Enable password reset from Login page';


--
-- Name: COLUMN res_config_settings.auth_totp_policy; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_totp_policy IS 'Two-factor authentication enforcing policy';


--
-- Name: COLUMN res_config_settings.auth_totp_enforce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.auth_totp_enforce IS 'Enforce two-factor authentication';


--
-- Name: COLUMN res_config_settings.google_gmail_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_identifier IS 'Gmail Client Id';


--
-- Name: COLUMN res_config_settings.google_gmail_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_gmail_client_secret IS 'Gmail Client Secret';


--
-- Name: COLUMN res_config_settings.microsoft_outlook_client_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.microsoft_outlook_client_identifier IS 'Outlook Client Id';


--
-- Name: COLUMN res_config_settings.microsoft_outlook_client_secret; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.microsoft_outlook_client_secret IS 'Outlook Client Secret';


--
-- Name: COLUMN res_config_settings.disable_redirect_firebase_dynamic_link; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.disable_redirect_firebase_dynamic_link IS 'Disable link redirection to mobile app';


--
-- Name: COLUMN res_config_settings.enable_ocn; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.enable_ocn IS 'Push Notifications';


--
-- Name: COLUMN res_config_settings.openai_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.openai_key IS 'OpenAI API key';


--
-- Name: COLUMN res_config_settings.google_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_config_settings.google_key IS 'Google AI API key';


--
-- Name: res_config_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_config_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_config_settings_id_seq OWNER TO runbot;

--
-- Name: res_config_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_config_settings_id_seq OWNED BY public.res_config_settings.id;


--
-- Name: res_country; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country (
    id integer NOT NULL,
    address_view_id integer,
    currency_id integer,
    phone_code integer,
    create_uid integer,
    write_uid integer,
    code character varying(2) NOT NULL,
    name_position character varying,
    name jsonb NOT NULL,
    vat_label jsonb,
    address_format text,
    state_required boolean,
    zip_required boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country OWNER TO runbot;

--
-- Name: TABLE res_country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country IS 'Country';


--
-- Name: COLUMN res_country.address_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_view_id IS 'Input View';


--
-- Name: COLUMN res_country.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.currency_id IS 'Currency';


--
-- Name: COLUMN res_country.phone_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.phone_code IS 'Country Calling Code';


--
-- Name: COLUMN res_country.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_uid IS 'Created by';


--
-- Name: COLUMN res_country.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.code IS 'Country Code';


--
-- Name: COLUMN res_country.name_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name_position IS 'Customer Name Position';


--
-- Name: COLUMN res_country.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.name IS 'Country Name';


--
-- Name: COLUMN res_country.vat_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.vat_label IS 'Vat Label';


--
-- Name: COLUMN res_country.address_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.address_format IS 'Layout in Reports';


--
-- Name: COLUMN res_country.state_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.state_required IS 'State Required';


--
-- Name: COLUMN res_country.zip_required; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.zip_required IS 'Zip Required';


--
-- Name: COLUMN res_country.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.create_date IS 'Created on';


--
-- Name: COLUMN res_country.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country.write_date IS 'Last Updated on';


--
-- Name: res_country_group; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_group (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    code character varying,
    name jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_group OWNER TO runbot;

--
-- Name: TABLE res_country_group; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_group IS 'Country Group';


--
-- Name: COLUMN res_country_group.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_group.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_group.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.code IS 'Code';


--
-- Name: COLUMN res_country_group.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.name IS 'Name';


--
-- Name: COLUMN res_country_group.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.create_date IS 'Created on';


--
-- Name: COLUMN res_country_group.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_group.write_date IS 'Last Updated on';


--
-- Name: res_country_group_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_group_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_group_id_seq OWNER TO runbot;

--
-- Name: res_country_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_group_id_seq OWNED BY public.res_country_group.id;


--
-- Name: res_country_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_id_seq OWNER TO runbot;

--
-- Name: res_country_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_id_seq OWNED BY public.res_country.id;


--
-- Name: res_country_res_country_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_res_country_group_rel (
    res_country_id integer NOT NULL,
    res_country_group_id integer NOT NULL
);


ALTER TABLE public.res_country_res_country_group_rel OWNER TO runbot;

--
-- Name: TABLE res_country_res_country_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_res_country_group_rel IS 'RELATION BETWEEN res_country AND res_country_group';


--
-- Name: res_country_state; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_country_state (
    id integer NOT NULL,
    country_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_country_state OWNER TO runbot;

--
-- Name: TABLE res_country_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_country_state IS 'Country state';


--
-- Name: COLUMN res_country_state.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.country_id IS 'Country';


--
-- Name: COLUMN res_country_state.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_uid IS 'Created by';


--
-- Name: COLUMN res_country_state.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_country_state.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.name IS 'State Name';


--
-- Name: COLUMN res_country_state.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.code IS 'State Code';


--
-- Name: COLUMN res_country_state.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.create_date IS 'Created on';


--
-- Name: COLUMN res_country_state.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_country_state.write_date IS 'Last Updated on';


--
-- Name: res_country_state_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_country_state_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_country_state_id_seq OWNER TO runbot;

--
-- Name: res_country_state_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_country_state_id_seq OWNED BY public.res_country_state.id;


--
-- Name: res_currency; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency (
    id integer NOT NULL,
    name character varying NOT NULL,
    symbol character varying NOT NULL,
    iso_numeric integer,
    decimal_places integer,
    create_uid integer,
    write_uid integer,
    full_name character varying,
    "position" character varying,
    currency_unit_label jsonb,
    currency_subunit_label jsonb,
    rounding numeric,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rounding_gt_zero CHECK ((rounding > (0)::numeric))
);


ALTER TABLE public.res_currency OWNER TO runbot;

--
-- Name: COLUMN res_currency.iso_numeric; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.iso_numeric IS 'Currency numeric code.';


--
-- Name: COLUMN res_currency.decimal_places; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.decimal_places IS 'Decimal Places';


--
-- Name: COLUMN res_currency.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.full_name IS 'Name';


--
-- Name: COLUMN res_currency."position"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency."position" IS 'Symbol Position';


--
-- Name: COLUMN res_currency.currency_unit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_unit_label IS 'Currency Unit';


--
-- Name: COLUMN res_currency.currency_subunit_label; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.currency_subunit_label IS 'Currency Subunit';


--
-- Name: COLUMN res_currency.rounding; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.rounding IS 'Rounding Factor';


--
-- Name: COLUMN res_currency.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.active IS 'Active';


--
-- Name: COLUMN res_currency.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.create_date IS 'Created on';


--
-- Name: COLUMN res_currency.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rounding_gt_zero ON res_currency; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rounding_gt_zero ON public.res_currency IS 'CHECK (rounding>0)';


--
-- Name: res_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_id_seq OWNER TO runbot;

--
-- Name: res_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_id_seq OWNED BY public.res_currency.id;


--
-- Name: res_currency_rate; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_currency_rate (
    id integer NOT NULL,
    currency_id integer NOT NULL,
    company_id integer,
    create_uid integer,
    write_uid integer,
    name date NOT NULL,
    rate numeric,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    CONSTRAINT res_currency_rate_currency_rate_check CHECK ((rate > (0)::numeric))
);


ALTER TABLE public.res_currency_rate OWNER TO runbot;

--
-- Name: TABLE res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_currency_rate IS 'Currency Rate';


--
-- Name: COLUMN res_currency_rate.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.currency_id IS 'Currency';


--
-- Name: COLUMN res_currency_rate.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.company_id IS 'Company';


--
-- Name: COLUMN res_currency_rate.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_uid IS 'Created by';


--
-- Name: COLUMN res_currency_rate.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_currency_rate.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.name IS 'Date';


--
-- Name: COLUMN res_currency_rate.rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.rate IS 'Technical Rate';


--
-- Name: COLUMN res_currency_rate.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.create_date IS 'Created on';


--
-- Name: COLUMN res_currency_rate.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_currency_rate.write_date IS 'Last Updated on';


--
-- Name: CONSTRAINT res_currency_rate_currency_rate_check ON res_currency_rate; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_currency_rate_currency_rate_check ON public.res_currency_rate IS 'CHECK (rate>0)';


--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_currency_rate_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_currency_rate_id_seq OWNER TO runbot;

--
-- Name: res_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_currency_rate_id_seq OWNED BY public.res_currency_rate.id;


--
-- Name: res_device_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_device_log (
    id integer NOT NULL,
    user_id integer,
    create_uid integer,
    write_uid integer,
    session_identifier character varying NOT NULL,
    platform character varying,
    browser character varying,
    ip_address character varying,
    country character varying,
    city character varying,
    device_type character varying,
    revoked boolean,
    first_activity timestamp without time zone,
    last_activity timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_device_log OWNER TO runbot;

--
-- Name: TABLE res_device_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_device_log IS 'Device Log';


--
-- Name: COLUMN res_device_log.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.user_id IS 'User';


--
-- Name: COLUMN res_device_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_device_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_device_log.session_identifier; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.session_identifier IS 'Session Identifier';


--
-- Name: COLUMN res_device_log.platform; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.platform IS 'Platform';


--
-- Name: COLUMN res_device_log.browser; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.browser IS 'Browser';


--
-- Name: COLUMN res_device_log.ip_address; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.ip_address IS 'IP Address';


--
-- Name: COLUMN res_device_log.country; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.country IS 'Country';


--
-- Name: COLUMN res_device_log.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.city IS 'City';


--
-- Name: COLUMN res_device_log.device_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.device_type IS 'Device Type';


--
-- Name: COLUMN res_device_log.revoked; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.revoked IS 'Revoked';


--
-- Name: COLUMN res_device_log.first_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.first_activity IS 'First Activity';


--
-- Name: COLUMN res_device_log.last_activity; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.last_activity IS 'Last Activity';


--
-- Name: COLUMN res_device_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.create_date IS 'Created on';


--
-- Name: COLUMN res_device_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_device_log.write_date IS 'Last Updated on';


--
-- Name: res_device; Type: VIEW; Schema: public; Owner: runbot
--

CREATE VIEW public.res_device AS
 SELECT id,
    user_id,
    create_uid,
    write_uid,
    session_identifier,
    platform,
    browser,
    ip_address,
    country,
    city,
    device_type,
    revoked,
    first_activity,
    last_activity,
    create_date,
    write_date
   FROM public.res_device_log d
  WHERE ((NOT (EXISTS ( SELECT 1
           FROM public.res_device_log d2
          WHERE ((d2.user_id = d.user_id) AND ((d2.session_identifier)::text = (d.session_identifier)::text) AND (NOT ((d2.platform)::text IS DISTINCT FROM (d.platform)::text)) AND (NOT ((d2.browser)::text IS DISTINCT FROM (d.browser)::text)) AND ((d2.last_activity > d.last_activity) OR ((d2.last_activity = d.last_activity) AND (d2.id > d.id))) AND (d2.revoked IS NOT TRUE))))) AND (revoked IS NOT TRUE));


ALTER VIEW public.res_device OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_device_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_device_log_id_seq OWNER TO runbot;

--
-- Name: res_device_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_device_log_id_seq OWNED BY public.res_device_log.id;


--
-- Name: res_groups; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups (
    id integer NOT NULL,
    name jsonb NOT NULL,
    sequence integer,
    privilege_id integer,
    create_uid integer,
    write_uid integer,
    comment jsonb,
    share boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    api_key_duration double precision,
    CONSTRAINT res_groups_check_api_key_duration CHECK ((api_key_duration >= (0)::double precision))
);


ALTER TABLE public.res_groups OWNER TO runbot;

--
-- Name: COLUMN res_groups.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.sequence IS 'Sequence';


--
-- Name: COLUMN res_groups.privilege_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.privilege_id IS 'Privilege';


--
-- Name: COLUMN res_groups.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.comment IS 'Comment';


--
-- Name: COLUMN res_groups.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.share IS 'Share Group';


--
-- Name: COLUMN res_groups.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.create_date IS 'Created on';


--
-- Name: COLUMN res_groups.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_groups.api_key_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups.api_key_duration IS 'API Keys maximum duration days';


--
-- Name: CONSTRAINT res_groups_check_api_key_duration ON res_groups; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_groups_check_api_key_duration ON public.res_groups IS 'CHECK(api_key_duration >= 0)';


--
-- Name: res_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_id_seq OWNER TO runbot;

--
-- Name: res_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_id_seq OWNED BY public.res_groups.id;


--
-- Name: res_groups_implied_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_implied_rel (
    gid integer NOT NULL,
    hid integer NOT NULL
);


ALTER TABLE public.res_groups_implied_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_implied_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_implied_rel IS 'RELATION BETWEEN res_groups AND res_groups';


--
-- Name: res_groups_privilege; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_privilege (
    id integer NOT NULL,
    sequence integer,
    category_id integer,
    create_uid integer,
    write_uid integer,
    placeholder character varying,
    name jsonb NOT NULL,
    description text,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_groups_privilege OWNER TO runbot;

--
-- Name: TABLE res_groups_privilege; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_privilege IS 'Privileges';


--
-- Name: COLUMN res_groups_privilege.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.sequence IS 'Sequence';


--
-- Name: COLUMN res_groups_privilege.category_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.category_id IS 'Category';


--
-- Name: COLUMN res_groups_privilege.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.create_uid IS 'Created by';


--
-- Name: COLUMN res_groups_privilege.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_groups_privilege.placeholder; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.placeholder IS 'Placeholder';


--
-- Name: COLUMN res_groups_privilege.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.name IS 'Name';


--
-- Name: COLUMN res_groups_privilege.description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.description IS 'Description';


--
-- Name: COLUMN res_groups_privilege.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.create_date IS 'Created on';


--
-- Name: COLUMN res_groups_privilege.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_groups_privilege.write_date IS 'Last Updated on';


--
-- Name: res_groups_privilege_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_groups_privilege_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_groups_privilege_id_seq OWNER TO runbot;

--
-- Name: res_groups_privilege_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_groups_privilege_id_seq OWNED BY public.res_groups_privilege.id;


--
-- Name: res_groups_report_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_report_rel (
    uid integer NOT NULL,
    gid integer NOT NULL
);


ALTER TABLE public.res_groups_report_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_report_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_report_rel IS 'RELATION BETWEEN ir_act_report_xml AND res_groups';


--
-- Name: res_groups_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_groups_users_rel (
    gid integer NOT NULL,
    uid integer NOT NULL
);


ALTER TABLE public.res_groups_users_rel OWNER TO runbot;

--
-- Name: TABLE res_groups_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_groups_users_rel IS 'RELATION BETWEEN res_groups AND res_users';


--
-- Name: res_lang; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    code character varying NOT NULL,
    iso_code character varying,
    url_code character varying NOT NULL,
    direction character varying NOT NULL,
    date_format character varying NOT NULL,
    time_format character varying NOT NULL,
    week_start character varying NOT NULL,
    "grouping" character varying NOT NULL,
    decimal_point character varying NOT NULL,
    thousands_sep character varying,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_lang OWNER TO runbot;

--
-- Name: TABLE res_lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang IS 'Languages';


--
-- Name: COLUMN res_lang.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_uid IS 'Created by';


--
-- Name: COLUMN res_lang.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_lang.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.name IS 'Name';


--
-- Name: COLUMN res_lang.code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.code IS 'Locale Code';


--
-- Name: COLUMN res_lang.iso_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.iso_code IS 'ISO code';


--
-- Name: COLUMN res_lang.url_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.url_code IS 'URL Code';


--
-- Name: COLUMN res_lang.direction; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.direction IS 'Direction';


--
-- Name: COLUMN res_lang.date_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.date_format IS 'Date Format';


--
-- Name: COLUMN res_lang.time_format; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.time_format IS 'Time Format';


--
-- Name: COLUMN res_lang.week_start; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.week_start IS 'First Day of Week';


--
-- Name: COLUMN res_lang."grouping"; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang."grouping" IS 'Separator Format';


--
-- Name: COLUMN res_lang.decimal_point; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.decimal_point IS 'Decimal Separator';


--
-- Name: COLUMN res_lang.thousands_sep; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.thousands_sep IS 'Thousands Separator';


--
-- Name: COLUMN res_lang.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.active IS 'Active';


--
-- Name: COLUMN res_lang.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.create_date IS 'Created on';


--
-- Name: COLUMN res_lang.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_lang.write_date IS 'Last Updated on';


--
-- Name: res_lang_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_lang_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_lang_id_seq OWNER TO runbot;

--
-- Name: res_lang_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_lang_id_seq OWNED BY public.res_lang.id;


--
-- Name: res_lang_install_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_lang_install_rel (
    language_wizard_id integer NOT NULL,
    lang_id integer NOT NULL
);


ALTER TABLE public.res_lang_install_rel OWNER TO runbot;

--
-- Name: TABLE res_lang_install_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_lang_install_rel IS 'RELATION BETWEEN base_language_install AND res_lang';


--
-- Name: res_partner; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner (
    id integer NOT NULL,
    company_id integer,
    create_date timestamp without time zone,
    name character varying,
    parent_id integer,
    user_id integer,
    state_id integer,
    country_id integer,
    industry_id integer,
    color integer,
    commercial_partner_id integer,
    create_uid integer,
    write_uid integer,
    complete_name character varying,
    ref character varying,
    lang character varying,
    tz character varying,
    vat character varying,
    company_registry character varying,
    website character varying,
    function character varying,
    type character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    email character varying,
    phone character varying,
    commercial_company_name character varying,
    company_name character varying,
    properties jsonb,
    barcode jsonb,
    comment text,
    partner_latitude numeric,
    partner_longitude numeric,
    active boolean,
    employee boolean,
    is_company boolean,
    partner_share boolean,
    write_date timestamp without time zone,
    contact_address_complete character varying,
    message_bounce integer,
    email_normalized character varying,
    signup_type character varying,
    phone_sanitized character varying,
    ocn_token character varying,
    CONSTRAINT res_partner_check_name CHECK (((((type)::text = 'contact'::text) AND (name IS NOT NULL)) OR ((type)::text <> 'contact'::text)))
);


ALTER TABLE public.res_partner OWNER TO runbot;

--
-- Name: COLUMN res_partner.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.parent_id IS 'Related Company';


--
-- Name: COLUMN res_partner.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.user_id IS 'Salesperson';


--
-- Name: COLUMN res_partner.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.state_id IS 'State';


--
-- Name: COLUMN res_partner.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.country_id IS 'Country';


--
-- Name: COLUMN res_partner.industry_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.industry_id IS 'Industry';


--
-- Name: COLUMN res_partner.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.color IS 'Color Index';


--
-- Name: COLUMN res_partner.commercial_partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_partner_id IS 'Commercial Entity';


--
-- Name: COLUMN res_partner.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner.complete_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.complete_name IS 'Complete Name';


--
-- Name: COLUMN res_partner.ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ref IS 'Reference';


--
-- Name: COLUMN res_partner.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.lang IS 'Language';


--
-- Name: COLUMN res_partner.tz; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.tz IS 'Timezone';


--
-- Name: COLUMN res_partner.vat; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.vat IS 'Tax ID';


--
-- Name: COLUMN res_partner.company_registry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_registry IS 'Company ID';


--
-- Name: COLUMN res_partner.website; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.website IS 'Website Link';


--
-- Name: COLUMN res_partner.function; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.function IS 'Job Position';


--
-- Name: COLUMN res_partner.type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.type IS 'Address Type';


--
-- Name: COLUMN res_partner.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street IS 'Street';


--
-- Name: COLUMN res_partner.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.street2 IS 'Street2';


--
-- Name: COLUMN res_partner.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.zip IS 'Zip';


--
-- Name: COLUMN res_partner.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.city IS 'City';


--
-- Name: COLUMN res_partner.email; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email IS 'Email';


--
-- Name: COLUMN res_partner.phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone IS 'Phone';


--
-- Name: COLUMN res_partner.commercial_company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.commercial_company_name IS 'Company Name Entity';


--
-- Name: COLUMN res_partner.company_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.company_name IS 'Company Name';


--
-- Name: COLUMN res_partner.properties; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.properties IS 'Properties';


--
-- Name: COLUMN res_partner.barcode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.barcode IS 'Barcode';


--
-- Name: COLUMN res_partner.comment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.comment IS 'Notes';


--
-- Name: COLUMN res_partner.partner_latitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_latitude IS 'Geo Latitude';


--
-- Name: COLUMN res_partner.partner_longitude; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_longitude IS 'Geo Longitude';


--
-- Name: COLUMN res_partner.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.active IS 'Active';


--
-- Name: COLUMN res_partner.employee; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.employee IS 'Employee';


--
-- Name: COLUMN res_partner.is_company; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.is_company IS 'Is a Company';


--
-- Name: COLUMN res_partner.partner_share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.partner_share IS 'Share Partner';


--
-- Name: COLUMN res_partner.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_partner.contact_address_complete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.contact_address_complete IS 'Contact Address Complete';


--
-- Name: COLUMN res_partner.message_bounce; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.message_bounce IS 'Bounce';


--
-- Name: COLUMN res_partner.email_normalized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.email_normalized IS 'Normalized Email';


--
-- Name: COLUMN res_partner.signup_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.signup_type IS 'Signup Token Type';


--
-- Name: COLUMN res_partner.phone_sanitized; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.phone_sanitized IS 'Sanitized Number';


--
-- Name: COLUMN res_partner.ocn_token; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner.ocn_token IS 'OCN Token';


--
-- Name: CONSTRAINT res_partner_check_name ON res_partner; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_partner_check_name ON public.res_partner IS 'CHECK( (type=''contact'' AND name IS NOT NULL) or (type!=''contact'') )';


--
-- Name: res_partner_bank; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_bank (
    id integer NOT NULL,
    partner_id integer NOT NULL,
    bank_id integer,
    sequence integer,
    currency_id integer,
    company_id integer,
    create_uid integer,
    write_uid integer,
    acc_number character varying NOT NULL,
    clearing_number character varying,
    sanitized_acc_number character varying,
    acc_holder_name character varying,
    note text,
    active boolean,
    allow_out_payment boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_bank OWNER TO runbot;

--
-- Name: TABLE res_partner_bank; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_bank IS 'Bank Accounts';


--
-- Name: COLUMN res_partner_bank.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.partner_id IS 'Account Holder';


--
-- Name: COLUMN res_partner_bank.bank_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.bank_id IS 'Bank';


--
-- Name: COLUMN res_partner_bank.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sequence IS 'Sequence';


--
-- Name: COLUMN res_partner_bank.currency_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.currency_id IS 'Currency';


--
-- Name: COLUMN res_partner_bank.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.company_id IS 'Company';


--
-- Name: COLUMN res_partner_bank.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_bank.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_bank.acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_number IS 'Account Number';


--
-- Name: COLUMN res_partner_bank.clearing_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.clearing_number IS 'Clearing Number';


--
-- Name: COLUMN res_partner_bank.sanitized_acc_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.sanitized_acc_number IS 'Sanitized Account Number';


--
-- Name: COLUMN res_partner_bank.acc_holder_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.acc_holder_name IS 'Account Holder Name';


--
-- Name: COLUMN res_partner_bank.note; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.note IS 'Notes';


--
-- Name: COLUMN res_partner_bank.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.active IS 'Active';


--
-- Name: COLUMN res_partner_bank.allow_out_payment; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.allow_out_payment IS 'Send Money';


--
-- Name: COLUMN res_partner_bank.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_bank.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_bank.write_date IS 'Last Updated on';


--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_bank_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_bank_id_seq OWNER TO runbot;

--
-- Name: res_partner_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_bank_id_seq OWNED BY public.res_partner_bank.id;


--
-- Name: res_partner_category; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_category (
    id integer NOT NULL,
    color integer,
    parent_id integer,
    create_uid integer,
    write_uid integer,
    parent_path character varying,
    name jsonb NOT NULL,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_category OWNER TO runbot;

--
-- Name: TABLE res_partner_category; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_category IS 'Partner Tags';


--
-- Name: COLUMN res_partner_category.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.color IS 'Color';


--
-- Name: COLUMN res_partner_category.parent_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_id IS 'Category';


--
-- Name: COLUMN res_partner_category.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_category.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_category.parent_path; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.parent_path IS 'Parent Path';


--
-- Name: COLUMN res_partner_category.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.name IS 'Name';


--
-- Name: COLUMN res_partner_category.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.active IS 'Active';


--
-- Name: COLUMN res_partner_category.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_category.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_category.write_date IS 'Last Updated on';


--
-- Name: res_partner_category_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_category_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_category_id_seq OWNER TO runbot;

--
-- Name: res_partner_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_category_id_seq OWNED BY public.res_partner_category.id;


--
-- Name: res_partner_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_id_seq OWNER TO runbot;

--
-- Name: res_partner_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_id_seq OWNED BY public.res_partner.id;


--
-- Name: res_partner_industry; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_industry (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name jsonb,
    full_name jsonb,
    active boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_partner_industry OWNER TO runbot;

--
-- Name: TABLE res_partner_industry; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_industry IS 'Industry';


--
-- Name: COLUMN res_partner_industry.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_uid IS 'Created by';


--
-- Name: COLUMN res_partner_industry.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_partner_industry.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.name IS 'Name';


--
-- Name: COLUMN res_partner_industry.full_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.full_name IS 'Full Name';


--
-- Name: COLUMN res_partner_industry.active; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.active IS 'Active';


--
-- Name: COLUMN res_partner_industry.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.create_date IS 'Created on';


--
-- Name: COLUMN res_partner_industry.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_partner_industry.write_date IS 'Last Updated on';


--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_partner_industry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_partner_industry_id_seq OWNER TO runbot;

--
-- Name: res_partner_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_partner_industry_id_seq OWNED BY public.res_partner_industry.id;


--
-- Name: res_partner_res_partner_category_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_partner_res_partner_category_rel (
    category_id integer NOT NULL,
    partner_id integer NOT NULL
);


ALTER TABLE public.res_partner_res_partner_category_rel OWNER TO runbot;

--
-- Name: TABLE res_partner_res_partner_category_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_partner_res_partner_category_rel IS 'RELATION BETWEEN res_partner_category AND res_partner';


--
-- Name: res_role; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_role (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_role OWNER TO runbot;

--
-- Name: TABLE res_role; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_role IS 'Represents a role in the system used to categorize users. Each role has a unique name and can be associated with multiple users. Roles can be mentioned in messages to notify all associated users.';


--
-- Name: COLUMN res_role.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.create_uid IS 'Created by';


--
-- Name: COLUMN res_role.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_role.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.name IS 'Name';


--
-- Name: COLUMN res_role.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.create_date IS 'Created on';


--
-- Name: COLUMN res_role.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_role.write_date IS 'Last Updated on';


--
-- Name: res_role_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_role_id_seq OWNER TO runbot;

--
-- Name: res_role_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_role_id_seq OWNED BY public.res_role.id;


--
-- Name: res_role_res_users_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_role_res_users_rel (
    res_role_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_role_res_users_rel OWNER TO runbot;

--
-- Name: TABLE res_role_res_users_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_role_res_users_rel IS 'RELATION BETWEEN res_role AND res_users';


--
-- Name: res_users; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users (
    id integer NOT NULL,
    company_id integer NOT NULL,
    partner_id integer NOT NULL,
    active boolean DEFAULT true,
    create_date timestamp without time zone,
    login character varying NOT NULL,
    password character varying,
    action_id integer,
    create_uid integer,
    write_uid integer,
    signature text,
    share boolean,
    write_date timestamp without time zone,
    totp_last_counter integer,
    totp_secret character varying,
    tour_enabled boolean,
    notification_type character varying NOT NULL,
    manual_im_status character varying,
    out_of_office_message text,
    out_of_office_from timestamp without time zone,
    out_of_office_to timestamp without time zone,
    odoobot_state character varying,
    odoobot_failed boolean,
    saas_provider_uuid character varying,
    CONSTRAINT res_users_notification_type CHECK ((((notification_type)::text = 'email'::text) OR (NOT share)))
);


ALTER TABLE public.res_users OWNER TO runbot;

--
-- Name: COLUMN res_users.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.action_id IS 'Home Action';


--
-- Name: COLUMN res_users.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.create_uid IS 'Created by';


--
-- Name: COLUMN res_users.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users.signature; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.signature IS 'Email Signature';


--
-- Name: COLUMN res_users.share; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.share IS 'Share User';


--
-- Name: COLUMN res_users.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users.totp_last_counter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.totp_last_counter IS 'Totp Last Counter';


--
-- Name: COLUMN res_users.tour_enabled; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.tour_enabled IS 'Onboarding';


--
-- Name: COLUMN res_users.notification_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.notification_type IS 'Notification';


--
-- Name: COLUMN res_users.manual_im_status; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.manual_im_status IS 'IM status manually set by the user';


--
-- Name: COLUMN res_users.out_of_office_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_message IS 'Vacation Responder';


--
-- Name: COLUMN res_users.out_of_office_from; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_from IS 'Out Of Office From';


--
-- Name: COLUMN res_users.out_of_office_to; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.out_of_office_to IS 'Out Of Office To';


--
-- Name: COLUMN res_users.odoobot_state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_state IS 'OdooBot Status';


--
-- Name: COLUMN res_users.odoobot_failed; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.odoobot_failed IS 'Odoobot Failed';


--
-- Name: COLUMN res_users.saas_provider_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users.saas_provider_uuid IS 'SaaS Provider UUID';


--
-- Name: CONSTRAINT res_users_notification_type ON res_users; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_notification_type ON public.res_users IS 'CHECK (notification_type = ''email'' OR NOT share)';


--
-- Name: res_users_apikeys; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys (
    id integer NOT NULL,
    name character varying NOT NULL,
    user_id integer NOT NULL,
    scope character varying,
    expiration_date timestamp without time zone,
    index character varying(8),
    key character varying,
    create_date timestamp without time zone DEFAULT (now() AT TIME ZONE 'utc'::text),
    CONSTRAINT res_users_apikeys_index_check CHECK ((char_length((index)::text) = 8))
);


ALTER TABLE public.res_users_apikeys OWNER TO runbot;

--
-- Name: res_users_apikeys_description; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_apikeys_description (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    duration character varying NOT NULL,
    expiration_date timestamp without time zone,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_apikeys_description OWNER TO runbot;

--
-- Name: TABLE res_users_apikeys_description; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_apikeys_description IS 'API Key Description';


--
-- Name: COLUMN res_users_apikeys_description.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_apikeys_description.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_apikeys_description.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.name IS 'Description';


--
-- Name: COLUMN res_users_apikeys_description.duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.duration IS 'Duration';


--
-- Name: COLUMN res_users_apikeys_description.expiration_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.expiration_date IS 'Expiration Date';


--
-- Name: COLUMN res_users_apikeys_description.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.create_date IS 'Created on';


--
-- Name: COLUMN res_users_apikeys_description.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_apikeys_description.write_date IS 'Last Updated on';


--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_description_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_description_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_description_id_seq OWNED BY public.res_users_apikeys_description.id;


--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_apikeys_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_apikeys_id_seq OWNER TO runbot;

--
-- Name: res_users_apikeys_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_apikeys_id_seq OWNED BY public.res_users_apikeys.id;


--
-- Name: res_users_deletion; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_deletion (
    id integer NOT NULL,
    user_id integer,
    user_id_int integer,
    create_uid integer,
    write_uid integer,
    state character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_deletion OWNER TO runbot;

--
-- Name: TABLE res_users_deletion; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_deletion IS 'Users Deletion Request';


--
-- Name: COLUMN res_users_deletion.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id IS 'User';


--
-- Name: COLUMN res_users_deletion.user_id_int; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.user_id_int IS 'User Id';


--
-- Name: COLUMN res_users_deletion.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_deletion.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_deletion.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.state IS 'State';


--
-- Name: COLUMN res_users_deletion.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.create_date IS 'Created on';


--
-- Name: COLUMN res_users_deletion.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_deletion.write_date IS 'Last Updated on';


--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_deletion_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_deletion_id_seq OWNER TO runbot;

--
-- Name: res_users_deletion_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_deletion_id_seq OWNED BY public.res_users_deletion.id;


--
-- Name: res_users_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_id_seq OWNER TO runbot;

--
-- Name: res_users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_id_seq OWNED BY public.res_users.id;


--
-- Name: res_users_identitycheck; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_identitycheck (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    request character varying,
    auth_method character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_identitycheck OWNER TO runbot;

--
-- Name: TABLE res_users_identitycheck; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_identitycheck IS 'Password Check Wizard';


--
-- Name: COLUMN res_users_identitycheck.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_identitycheck.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_identitycheck.request; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.request IS 'Request';


--
-- Name: COLUMN res_users_identitycheck.auth_method; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.auth_method IS 'Auth Method';


--
-- Name: COLUMN res_users_identitycheck.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.create_date IS 'Created on';


--
-- Name: COLUMN res_users_identitycheck.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_identitycheck.write_date IS 'Last Updated on';


--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_identitycheck_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNER TO runbot;

--
-- Name: res_users_identitycheck_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_identitycheck_id_seq OWNED BY public.res_users_identitycheck.id;


--
-- Name: res_users_log; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_log (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_log OWNER TO runbot;

--
-- Name: TABLE res_users_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_log IS 'Users Log';


--
-- Name: COLUMN res_users_log.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_log.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_log.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.create_date IS 'Created on';


--
-- Name: COLUMN res_users_log.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_log.write_date IS 'Last Updated on';


--
-- Name: res_users_log_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_log_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_log_id_seq OWNER TO runbot;

--
-- Name: res_users_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_log_id_seq OWNED BY public.res_users_log.id;


--
-- Name: res_users_settings; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings (
    id integer NOT NULL,
    user_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    color_scheme character varying NOT NULL,
    homemenu_config jsonb,
    voice_active_duration integer,
    push_to_talk_key character varying,
    channel_notifications character varying,
    is_discuss_sidebar_category_channel_open boolean,
    is_discuss_sidebar_category_chat_open boolean,
    use_push_to_talk boolean
);


ALTER TABLE public.res_users_settings OWNER TO runbot;

--
-- Name: TABLE res_users_settings; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings IS 'User Settings';


--
-- Name: COLUMN res_users_settings.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.user_id IS 'User';


--
-- Name: COLUMN res_users_settings.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings.color_scheme; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.color_scheme IS 'Color Scheme';


--
-- Name: COLUMN res_users_settings.homemenu_config; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.homemenu_config IS 'Home Menu Configuration';


--
-- Name: COLUMN res_users_settings.voice_active_duration; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.voice_active_duration IS 'Duration of voice activity in ms';


--
-- Name: COLUMN res_users_settings.push_to_talk_key; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.push_to_talk_key IS 'Push-To-Talk shortcut';


--
-- Name: COLUMN res_users_settings.channel_notifications; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.channel_notifications IS 'Channel Notifications';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_channel_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_channel_open IS 'Is discuss sidebar category channel open?';


--
-- Name: COLUMN res_users_settings.is_discuss_sidebar_category_chat_open; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.is_discuss_sidebar_category_chat_open IS 'Is discuss sidebar category chat open?';


--
-- Name: COLUMN res_users_settings.use_push_to_talk; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings.use_push_to_talk IS 'Use the push to talk feature';


--
-- Name: res_users_settings_embedded_action; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_embedded_action (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    action_id integer NOT NULL,
    res_id integer,
    create_uid integer,
    write_uid integer,
    res_model character varying NOT NULL,
    embedded_actions_order character varying,
    embedded_actions_visibility character varying,
    embedded_visibility boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.res_users_settings_embedded_action OWNER TO runbot;

--
-- Name: TABLE res_users_settings_embedded_action; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_embedded_action IS 'User Settings for Embedded Actions';


--
-- Name: COLUMN res_users_settings_embedded_action.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_embedded_action.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.action_id IS 'Action';


--
-- Name: COLUMN res_users_settings_embedded_action.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.res_id IS 'Res';


--
-- Name: COLUMN res_users_settings_embedded_action.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_embedded_action.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_embedded_action.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.res_model IS 'Res Model';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_actions_order; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_actions_order IS 'List order of embedded action ids';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_actions_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_actions_visibility IS 'List visibility of embedded actions ids';


--
-- Name: COLUMN res_users_settings_embedded_action.embedded_visibility; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.embedded_visibility IS 'Is top bar visible';


--
-- Name: COLUMN res_users_settings_embedded_action.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_embedded_action.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_embedded_action.write_date IS 'Last Updated on';


--
-- Name: res_users_settings_embedded_action_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_embedded_action_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_embedded_action_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_embedded_action_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_embedded_action_id_seq OWNED BY public.res_users_settings_embedded_action.id;


--
-- Name: res_users_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_id_seq OWNED BY public.res_users_settings.id;


--
-- Name: res_users_settings_volumes; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_settings_volumes (
    id integer NOT NULL,
    user_setting_id integer NOT NULL,
    partner_id integer,
    guest_id integer,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone,
    volume double precision,
    CONSTRAINT res_users_settings_volumes_partner_or_guest_exists CHECK ((((partner_id IS NOT NULL) AND (guest_id IS NULL)) OR ((partner_id IS NULL) AND (guest_id IS NOT NULL))))
);


ALTER TABLE public.res_users_settings_volumes OWNER TO runbot;

--
-- Name: TABLE res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_settings_volumes IS 'User Settings Volumes';


--
-- Name: COLUMN res_users_settings_volumes.user_setting_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.user_setting_id IS 'User Setting';


--
-- Name: COLUMN res_users_settings_volumes.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.partner_id IS 'Partner';


--
-- Name: COLUMN res_users_settings_volumes.guest_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.guest_id IS 'Guest';


--
-- Name: COLUMN res_users_settings_volumes.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_uid IS 'Created by';


--
-- Name: COLUMN res_users_settings_volumes.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_uid IS 'Last Updated by';


--
-- Name: COLUMN res_users_settings_volumes.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.create_date IS 'Created on';


--
-- Name: COLUMN res_users_settings_volumes.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.write_date IS 'Last Updated on';


--
-- Name: COLUMN res_users_settings_volumes.volume; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.res_users_settings_volumes.volume IS 'Volume';


--
-- Name: CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON res_users_settings_volumes; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON CONSTRAINT res_users_settings_volumes_partner_or_guest_exists ON public.res_users_settings_volumes IS 'CHECK((partner_id IS NOT NULL AND guest_id IS NULL) OR (partner_id IS NULL AND guest_id IS NOT NULL))';


--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.res_users_settings_volumes_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNER TO runbot;

--
-- Name: res_users_settings_volumes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.res_users_settings_volumes_id_seq OWNED BY public.res_users_settings_volumes.id;


--
-- Name: res_users_web_tour_tour_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.res_users_web_tour_tour_rel (
    web_tour_tour_id integer NOT NULL,
    res_users_id integer NOT NULL
);


ALTER TABLE public.res_users_web_tour_tour_rel OWNER TO runbot;

--
-- Name: TABLE res_users_web_tour_tour_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.res_users_web_tour_tour_rel IS 'RELATION BETWEEN web_tour_tour AND res_users';


--
-- Name: reset_view_arch_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.reset_view_arch_wizard (
    id integer NOT NULL,
    view_id integer,
    compare_view_id integer,
    create_uid integer,
    write_uid integer,
    reset_mode character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.reset_view_arch_wizard OWNER TO runbot;

--
-- Name: TABLE reset_view_arch_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.reset_view_arch_wizard IS 'Reset View Architecture Wizard';


--
-- Name: COLUMN reset_view_arch_wizard.view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.view_id IS 'View';


--
-- Name: COLUMN reset_view_arch_wizard.compare_view_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.compare_view_id IS 'Compare To View';


--
-- Name: COLUMN reset_view_arch_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN reset_view_arch_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN reset_view_arch_wizard.reset_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.reset_mode IS 'Reset Mode';


--
-- Name: COLUMN reset_view_arch_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.create_date IS 'Created on';


--
-- Name: COLUMN reset_view_arch_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.reset_view_arch_wizard.write_date IS 'Last Updated on';


--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.reset_view_arch_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNER TO runbot;

--
-- Name: reset_view_arch_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.reset_view_arch_wizard_id_seq OWNED BY public.reset_view_arch_wizard.id;


--
-- Name: rule_group_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.rule_group_rel (
    rule_group_id integer NOT NULL,
    group_id integer NOT NULL
);


ALTER TABLE public.rule_group_rel OWNER TO runbot;

--
-- Name: TABLE rule_group_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.rule_group_rel IS 'RELATION BETWEEN ir_rule AND res_groups';


--
-- Name: scheduled_message_attachment_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.scheduled_message_attachment_rel (
    scheduled_message_id integer NOT NULL,
    attachment_id integer NOT NULL
);


ALTER TABLE public.scheduled_message_attachment_rel OWNER TO runbot;

--
-- Name: TABLE scheduled_message_attachment_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.scheduled_message_attachment_rel IS 'RELATION BETWEEN mail_scheduled_message AND ir_attachment';


--
-- Name: server_action_history_wizard; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.server_action_history_wizard (
    id integer NOT NULL,
    action_id integer,
    revision integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.server_action_history_wizard OWNER TO runbot;

--
-- Name: TABLE server_action_history_wizard; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.server_action_history_wizard IS 'Server Action History Wizard';


--
-- Name: COLUMN server_action_history_wizard.action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.action_id IS 'Action';


--
-- Name: COLUMN server_action_history_wizard.revision; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.revision IS 'Revision';


--
-- Name: COLUMN server_action_history_wizard.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.create_uid IS 'Created by';


--
-- Name: COLUMN server_action_history_wizard.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.write_uid IS 'Last Updated by';


--
-- Name: COLUMN server_action_history_wizard.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.create_date IS 'Created on';


--
-- Name: COLUMN server_action_history_wizard.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.server_action_history_wizard.write_date IS 'Last Updated on';


--
-- Name: server_action_history_wizard_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.server_action_history_wizard_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.server_action_history_wizard_id_seq OWNER TO runbot;

--
-- Name: server_action_history_wizard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.server_action_history_wizard_id_seq OWNED BY public.server_action_history_wizard.id;


--
-- Name: sms_account_code; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_code (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    verification_code character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_code OWNER TO runbot;

--
-- Name: TABLE sms_account_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_code IS 'SMS Account Verification Code Wizard';


--
-- Name: COLUMN sms_account_code.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.account_id IS 'Account';


--
-- Name: COLUMN sms_account_code.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_code.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_code.verification_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.verification_code IS 'Verification Code';


--
-- Name: COLUMN sms_account_code.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_code.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_code.write_date IS 'Last Updated on';


--
-- Name: sms_account_code_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_code_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_code_id_seq OWNER TO runbot;

--
-- Name: sms_account_code_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_code_id_seq OWNED BY public.sms_account_code.id;


--
-- Name: sms_account_phone; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_phone (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    phone_number character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_phone OWNER TO runbot;

--
-- Name: TABLE sms_account_phone; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_phone IS 'SMS Account Registration Phone Number Wizard';


--
-- Name: COLUMN sms_account_phone.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.account_id IS 'Account';


--
-- Name: COLUMN sms_account_phone.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_phone.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_phone.phone_number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.phone_number IS 'Phone Number';


--
-- Name: COLUMN sms_account_phone.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_phone.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_phone.write_date IS 'Last Updated on';


--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_phone_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_phone_id_seq OWNER TO runbot;

--
-- Name: sms_account_phone_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_phone_id_seq OWNED BY public.sms_account_phone.id;


--
-- Name: sms_account_sender; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_account_sender (
    id integer NOT NULL,
    account_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    sender_name character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_account_sender OWNER TO runbot;

--
-- Name: TABLE sms_account_sender; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_account_sender IS 'SMS Account Sender Name Wizard';


--
-- Name: COLUMN sms_account_sender.account_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.account_id IS 'Account';


--
-- Name: COLUMN sms_account_sender.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_uid IS 'Created by';


--
-- Name: COLUMN sms_account_sender.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_account_sender.sender_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.sender_name IS 'Sender Name';


--
-- Name: COLUMN sms_account_sender.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.create_date IS 'Created on';


--
-- Name: COLUMN sms_account_sender.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_account_sender.write_date IS 'Last Updated on';


--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_account_sender_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_account_sender_id_seq OWNER TO runbot;

--
-- Name: sms_account_sender_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_account_sender_id_seq OWNED BY public.sms_account_sender.id;


--
-- Name: sms_composer; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_composer (
    id integer NOT NULL,
    res_id integer,
    template_id integer,
    create_uid integer,
    write_uid integer,
    composition_mode character varying NOT NULL,
    res_model character varying,
    res_ids character varying,
    recipient_single_number_itf character varying,
    number_field_name character varying,
    numbers character varying,
    body text NOT NULL,
    mass_keep_log boolean,
    mass_force_send boolean,
    use_exclusion_list boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_composer OWNER TO runbot;

--
-- Name: TABLE sms_composer; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_composer IS 'Send SMS Wizard';


--
-- Name: COLUMN sms_composer.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_id IS 'Document ID';


--
-- Name: COLUMN sms_composer.template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.template_id IS 'Use Template';


--
-- Name: COLUMN sms_composer.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_uid IS 'Created by';


--
-- Name: COLUMN sms_composer.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_composer.composition_mode; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.composition_mode IS 'Composition Mode';


--
-- Name: COLUMN sms_composer.res_model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_model IS 'Document Model Name';


--
-- Name: COLUMN sms_composer.res_ids; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.res_ids IS 'Document IDs';


--
-- Name: COLUMN sms_composer.recipient_single_number_itf; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.recipient_single_number_itf IS 'Recipient Number';


--
-- Name: COLUMN sms_composer.number_field_name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.number_field_name IS 'Number Field';


--
-- Name: COLUMN sms_composer.numbers; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.numbers IS 'Recipients (Numbers)';


--
-- Name: COLUMN sms_composer.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.body IS 'Message';


--
-- Name: COLUMN sms_composer.mass_keep_log; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_keep_log IS 'Keep a note on document';


--
-- Name: COLUMN sms_composer.mass_force_send; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.mass_force_send IS 'Send directly';


--
-- Name: COLUMN sms_composer.use_exclusion_list; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.use_exclusion_list IS 'Use Exclusion List';


--
-- Name: COLUMN sms_composer.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.create_date IS 'Created on';


--
-- Name: COLUMN sms_composer.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_composer.write_date IS 'Last Updated on';


--
-- Name: sms_composer_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_composer_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_composer_id_seq OWNER TO runbot;

--
-- Name: sms_composer_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_composer_id_seq OWNED BY public.sms_composer.id;


--
-- Name: sms_sms; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_sms (
    id integer NOT NULL,
    partner_id integer,
    mail_message_id integer,
    create_uid integer,
    write_uid integer,
    uuid character varying,
    number character varying,
    state character varying NOT NULL,
    failure_type character varying,
    body text,
    to_delete boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_sms OWNER TO runbot;

--
-- Name: TABLE sms_sms; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_sms IS 'Outgoing SMS';


--
-- Name: COLUMN sms_sms.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.partner_id IS 'Customer';


--
-- Name: COLUMN sms_sms.mail_message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.mail_message_id IS 'Mail Message';


--
-- Name: COLUMN sms_sms.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_uid IS 'Created by';


--
-- Name: COLUMN sms_sms.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_sms.uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.uuid IS 'UUID';


--
-- Name: COLUMN sms_sms.number; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.number IS 'Number';


--
-- Name: COLUMN sms_sms.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.state IS 'SMS Status';


--
-- Name: COLUMN sms_sms.failure_type; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.failure_type IS 'Failure Type';


--
-- Name: COLUMN sms_sms.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.body IS 'Body';


--
-- Name: COLUMN sms_sms.to_delete; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.to_delete IS 'Marked for deletion';


--
-- Name: COLUMN sms_sms.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.create_date IS 'Created on';


--
-- Name: COLUMN sms_sms.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_sms.write_date IS 'Last Updated on';


--
-- Name: sms_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_sms_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_sms_id_seq OWNER TO runbot;

--
-- Name: sms_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_sms_id_seq OWNED BY public.sms_sms.id;


--
-- Name: sms_template; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template (
    id integer NOT NULL,
    model_id integer NOT NULL,
    sidebar_action_id integer,
    create_uid integer,
    write_uid integer,
    template_fs character varying,
    lang character varying,
    model character varying,
    name jsonb,
    body jsonb NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template OWNER TO runbot;

--
-- Name: TABLE sms_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template IS 'SMS Templates';


--
-- Name: COLUMN sms_template.model_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model_id IS 'Applies to';


--
-- Name: COLUMN sms_template.sidebar_action_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.sidebar_action_id IS 'Sidebar action';


--
-- Name: COLUMN sms_template.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template.template_fs; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.template_fs IS 'Template Filename';


--
-- Name: COLUMN sms_template.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.lang IS 'Language';


--
-- Name: COLUMN sms_template.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.model IS 'Related Document Model';


--
-- Name: COLUMN sms_template.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.name IS 'Name';


--
-- Name: COLUMN sms_template.body; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.body IS 'Body';


--
-- Name: COLUMN sms_template.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.create_date IS 'Created on';


--
-- Name: COLUMN sms_template.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template.write_date IS 'Last Updated on';


--
-- Name: sms_template_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_id_seq OWNER TO runbot;

--
-- Name: sms_template_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_id_seq OWNED BY public.sms_template.id;


--
-- Name: sms_template_preview; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_preview (
    id integer NOT NULL,
    sms_template_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    lang character varying,
    resource_ref character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_preview OWNER TO runbot;

--
-- Name: TABLE sms_template_preview; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_preview IS 'SMS Template Preview';


--
-- Name: COLUMN sms_template_preview.sms_template_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.sms_template_id IS 'Sms Template';


--
-- Name: COLUMN sms_template_preview.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_preview.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_preview.lang; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.lang IS 'Template Preview Language';


--
-- Name: COLUMN sms_template_preview.resource_ref; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.resource_ref IS 'Record reference';


--
-- Name: COLUMN sms_template_preview.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_preview.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_preview.write_date IS 'Last Updated on';


--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_preview_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_preview_id_seq OWNER TO runbot;

--
-- Name: sms_template_preview_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_preview_id_seq OWNED BY public.sms_template_preview.id;


--
-- Name: sms_template_reset; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_reset (
    id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_template_reset OWNER TO runbot;

--
-- Name: TABLE sms_template_reset; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_reset IS 'SMS Template Reset';


--
-- Name: COLUMN sms_template_reset.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_uid IS 'Created by';


--
-- Name: COLUMN sms_template_reset.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_template_reset.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.create_date IS 'Created on';


--
-- Name: COLUMN sms_template_reset.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_template_reset.write_date IS 'Last Updated on';


--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_template_reset_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_template_reset_id_seq OWNER TO runbot;

--
-- Name: sms_template_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_template_reset_id_seq OWNED BY public.sms_template_reset.id;


--
-- Name: sms_template_sms_template_reset_rel; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_template_sms_template_reset_rel (
    sms_template_reset_id integer NOT NULL,
    sms_template_id integer NOT NULL
);


ALTER TABLE public.sms_template_sms_template_reset_rel OWNER TO runbot;

--
-- Name: TABLE sms_template_sms_template_reset_rel; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_template_sms_template_reset_rel IS 'RELATION BETWEEN sms_template_reset AND sms_template';


--
-- Name: sms_tracker; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.sms_tracker (
    id integer NOT NULL,
    mail_notification_id integer,
    create_uid integer,
    write_uid integer,
    sms_uuid character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.sms_tracker OWNER TO runbot;

--
-- Name: TABLE sms_tracker; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.sms_tracker IS 'Link SMS to mailing/sms tracking models';


--
-- Name: COLUMN sms_tracker.mail_notification_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.mail_notification_id IS 'Mail Notification';


--
-- Name: COLUMN sms_tracker.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_uid IS 'Created by';


--
-- Name: COLUMN sms_tracker.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_uid IS 'Last Updated by';


--
-- Name: COLUMN sms_tracker.sms_uuid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.sms_uuid IS 'SMS uuid';


--
-- Name: COLUMN sms_tracker.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.create_date IS 'Created on';


--
-- Name: COLUMN sms_tracker.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.sms_tracker.write_date IS 'Last Updated on';


--
-- Name: sms_tracker_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.sms_tracker_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.sms_tracker_id_seq OWNER TO runbot;

--
-- Name: sms_tracker_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.sms_tracker_id_seq OWNED BY public.sms_tracker.id;


--
-- Name: snailmail_letter; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.snailmail_letter (
    id integer NOT NULL,
    user_id integer,
    res_id integer NOT NULL,
    partner_id integer NOT NULL,
    company_id integer NOT NULL,
    report_template integer,
    attachment_id integer,
    message_id integer,
    state_id integer,
    country_id integer,
    create_uid integer,
    write_uid integer,
    model character varying NOT NULL,
    state character varying NOT NULL,
    error_code character varying,
    street character varying,
    street2 character varying,
    zip character varying,
    city character varying,
    info_msg text,
    color boolean,
    cover boolean,
    duplex boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.snailmail_letter OWNER TO runbot;

--
-- Name: TABLE snailmail_letter; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.snailmail_letter IS 'Snailmail Letter';


--
-- Name: COLUMN snailmail_letter.user_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.user_id IS 'Sent by';


--
-- Name: COLUMN snailmail_letter.res_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.res_id IS 'Document ID';


--
-- Name: COLUMN snailmail_letter.partner_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.partner_id IS 'Recipient';


--
-- Name: COLUMN snailmail_letter.company_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.company_id IS 'Company';


--
-- Name: COLUMN snailmail_letter.report_template; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.report_template IS 'Optional report to print and attach';


--
-- Name: COLUMN snailmail_letter.attachment_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.attachment_id IS 'Attachment';


--
-- Name: COLUMN snailmail_letter.message_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.message_id IS 'Snailmail Status Message';


--
-- Name: COLUMN snailmail_letter.state_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state_id IS 'State';


--
-- Name: COLUMN snailmail_letter.country_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.country_id IS 'Country';


--
-- Name: COLUMN snailmail_letter.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_uid IS 'Created by';


--
-- Name: COLUMN snailmail_letter.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_uid IS 'Last Updated by';


--
-- Name: COLUMN snailmail_letter.model; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.model IS 'Model';


--
-- Name: COLUMN snailmail_letter.state; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.state IS 'Status';


--
-- Name: COLUMN snailmail_letter.error_code; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.error_code IS 'Error';


--
-- Name: COLUMN snailmail_letter.street; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street IS 'Street';


--
-- Name: COLUMN snailmail_letter.street2; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.street2 IS 'Street2';


--
-- Name: COLUMN snailmail_letter.zip; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.zip IS 'Zip';


--
-- Name: COLUMN snailmail_letter.city; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.city IS 'City';


--
-- Name: COLUMN snailmail_letter.info_msg; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.info_msg IS 'Information';


--
-- Name: COLUMN snailmail_letter.color; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.color IS 'Color';


--
-- Name: COLUMN snailmail_letter.cover; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.cover IS 'Cover Page';


--
-- Name: COLUMN snailmail_letter.duplex; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.duplex IS 'Both side';


--
-- Name: COLUMN snailmail_letter.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.create_date IS 'Created on';


--
-- Name: COLUMN snailmail_letter.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.snailmail_letter.write_date IS 'Last Updated on';


--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.snailmail_letter_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.snailmail_letter_id_seq OWNER TO runbot;

--
-- Name: snailmail_letter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.snailmail_letter_id_seq OWNED BY public.snailmail_letter.id;


--
-- Name: web_tour_tour; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour (
    id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    url character varying,
    rainbow_man_message jsonb,
    custom boolean,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour OWNER TO runbot;

--
-- Name: TABLE web_tour_tour; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour IS 'Tours';


--
-- Name: COLUMN web_tour_tour.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.name IS 'Name';


--
-- Name: COLUMN web_tour_tour.url; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.url IS 'Starting URL';


--
-- Name: COLUMN web_tour_tour.rainbow_man_message; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.rainbow_man_message IS 'Rainbow Man Message';


--
-- Name: COLUMN web_tour_tour.custom; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.custom IS 'Custom';


--
-- Name: COLUMN web_tour_tour.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_id_seq OWNED BY public.web_tour_tour.id;


--
-- Name: web_tour_tour_step; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.web_tour_tour_step (
    id integer NOT NULL,
    tour_id integer NOT NULL,
    sequence integer,
    create_uid integer,
    write_uid integer,
    trigger character varying NOT NULL,
    content character varying,
    tooltip_position character varying,
    run character varying,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.web_tour_tour_step OWNER TO runbot;

--
-- Name: TABLE web_tour_tour_step; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.web_tour_tour_step IS 'Tour''s step';


--
-- Name: COLUMN web_tour_tour_step.tour_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tour_id IS 'Tour';


--
-- Name: COLUMN web_tour_tour_step.sequence; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.sequence IS 'Sequence';


--
-- Name: COLUMN web_tour_tour_step.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_uid IS 'Created by';


--
-- Name: COLUMN web_tour_tour_step.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_uid IS 'Last Updated by';


--
-- Name: COLUMN web_tour_tour_step.trigger; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.trigger IS 'Trigger';


--
-- Name: COLUMN web_tour_tour_step.content; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.content IS 'Content';


--
-- Name: COLUMN web_tour_tour_step.tooltip_position; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.tooltip_position IS 'Tooltip Position';


--
-- Name: COLUMN web_tour_tour_step.run; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.run IS 'Run';


--
-- Name: COLUMN web_tour_tour_step.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.create_date IS 'Created on';


--
-- Name: COLUMN web_tour_tour_step.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.web_tour_tour_step.write_date IS 'Last Updated on';


--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.web_tour_tour_step_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNER TO runbot;

--
-- Name: web_tour_tour_step_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.web_tour_tour_step_id_seq OWNED BY public.web_tour_tour_step.id;


--
-- Name: wizard_ir_model_menu_create; Type: TABLE; Schema: public; Owner: runbot
--

CREATE TABLE public.wizard_ir_model_menu_create (
    id integer NOT NULL,
    menu_id integer NOT NULL,
    create_uid integer,
    write_uid integer,
    name character varying NOT NULL,
    create_date timestamp without time zone,
    write_date timestamp without time zone
);


ALTER TABLE public.wizard_ir_model_menu_create OWNER TO runbot;

--
-- Name: TABLE wizard_ir_model_menu_create; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON TABLE public.wizard_ir_model_menu_create IS 'Create Menu Wizard';


--
-- Name: COLUMN wizard_ir_model_menu_create.menu_id; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.menu_id IS 'Parent Menu';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_uid IS 'Created by';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_uid; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_uid IS 'Last Updated by';


--
-- Name: COLUMN wizard_ir_model_menu_create.name; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.name IS 'Menu Name';


--
-- Name: COLUMN wizard_ir_model_menu_create.create_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.create_date IS 'Created on';


--
-- Name: COLUMN wizard_ir_model_menu_create.write_date; Type: COMMENT; Schema: public; Owner: runbot
--

COMMENT ON COLUMN public.wizard_ir_model_menu_create.write_date IS 'Last Updated on';


--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE; Schema: public; Owner: runbot
--

CREATE SEQUENCE public.wizard_ir_model_menu_create_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNER TO runbot;

--
-- Name: wizard_ir_model_menu_create_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: runbot
--

ALTER SEQUENCE public.wizard_ir_model_menu_create_id_seq OWNED BY public.wizard_ir_model_menu_create.id;


--
-- Name: ai_agent id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_agent ALTER COLUMN id SET DEFAULT nextval('public.ai_agent_id_seq'::regclass);


--
-- Name: ai_agent_source id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_agent_source ALTER COLUMN id SET DEFAULT nextval('public.ai_agent_source_id_seq'::regclass);


--
-- Name: ai_composer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_composer ALTER COLUMN id SET DEFAULT nextval('public.ai_composer_id_seq'::regclass);


--
-- Name: ai_embedding id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_embedding ALTER COLUMN id SET DEFAULT nextval('public.ai_embedding_id_seq'::regclass);


--
-- Name: ai_prompt_button id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_prompt_button ALTER COLUMN id SET DEFAULT nextval('public.ai_prompt_button_id_seq'::regclass);


--
-- Name: ai_topic id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ai_topic ALTER COLUMN id SET DEFAULT nextval('public.ai_topic_id_seq'::regclass);


--
-- Name: auth_passkey_key id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_passkey_key ALTER COLUMN id SET DEFAULT nextval('public.auth_passkey_key_id_seq'::regclass);


--
-- Name: auth_passkey_key_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_passkey_key_create ALTER COLUMN id SET DEFAULT nextval('public.auth_passkey_key_create_id_seq'::regclass);


--
-- Name: auth_totp_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_device ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_device_id_seq'::regclass);


--
-- Name: auth_totp_rate_limit_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_rate_limit_log ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_rate_limit_log_id_seq'::regclass);


--
-- Name: auth_totp_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.auth_totp_wizard ALTER COLUMN id SET DEFAULT nextval('public.auth_totp_wizard_id_seq'::regclass);


--
-- Name: base_document_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_document_layout ALTER COLUMN id SET DEFAULT nextval('public.base_document_layout_id_seq'::regclass);


--
-- Name: base_enable_profiling_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_enable_profiling_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_enable_profiling_wizard_id_seq'::regclass);


--
-- Name: base_import_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_import ALTER COLUMN id SET DEFAULT nextval('public.base_import_import_id_seq'::regclass);


--
-- Name: base_import_mapping id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_mapping ALTER COLUMN id SET DEFAULT nextval('public.base_import_mapping_id_seq'::regclass);


--
-- Name: base_import_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_import_module ALTER COLUMN id SET DEFAULT nextval('public.base_import_module_id_seq'::regclass);


--
-- Name: base_language_export id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_export ALTER COLUMN id SET DEFAULT nextval('public.base_language_export_id_seq'::regclass);


--
-- Name: base_language_import id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_import ALTER COLUMN id SET DEFAULT nextval('public.base_language_import_id_seq'::regclass);


--
-- Name: base_language_install id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_language_install ALTER COLUMN id SET DEFAULT nextval('public.base_language_install_id_seq'::regclass);


--
-- Name: base_module_install_request id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_request ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_request_id_seq'::regclass);


--
-- Name: base_module_install_review id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_install_review ALTER COLUMN id SET DEFAULT nextval('public.base_module_install_review_id_seq'::regclass);


--
-- Name: base_module_uninstall id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_uninstall ALTER COLUMN id SET DEFAULT nextval('public.base_module_uninstall_id_seq'::regclass);


--
-- Name: base_module_update id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_update ALTER COLUMN id SET DEFAULT nextval('public.base_module_update_id_seq'::regclass);


--
-- Name: base_module_upgrade id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_module_upgrade ALTER COLUMN id SET DEFAULT nextval('public.base_module_upgrade_id_seq'::regclass);


--
-- Name: base_partner_merge_automatic_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_automatic_wizard ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_automatic_wizard_id_seq'::regclass);


--
-- Name: base_partner_merge_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.base_partner_merge_line ALTER COLUMN id SET DEFAULT nextval('public.base_partner_merge_line_id_seq'::regclass);


--
-- Name: bus_bus id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.bus_bus ALTER COLUMN id SET DEFAULT nextval('public.bus_bus_id_seq'::regclass);


--
-- Name: change_password_own id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_own ALTER COLUMN id SET DEFAULT nextval('public.change_password_own_id_seq'::regclass);


--
-- Name: change_password_user id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_user ALTER COLUMN id SET DEFAULT nextval('public.change_password_user_id_seq'::regclass);


--
-- Name: change_password_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.change_password_wizard ALTER COLUMN id SET DEFAULT nextval('public.change_password_wizard_id_seq'::regclass);


--
-- Name: decimal_precision id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.decimal_precision ALTER COLUMN id SET DEFAULT nextval('public.decimal_precision_id_seq'::regclass);


--
-- Name: discuss_call_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_call_history ALTER COLUMN id SET DEFAULT nextval('public.discuss_call_history_id_seq'::regclass);


--
-- Name: discuss_channel id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_id_seq'::regclass);


--
-- Name: discuss_channel_member id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_member ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_member_id_seq'::regclass);


--
-- Name: discuss_channel_rtc_session id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_channel_rtc_session ALTER COLUMN id SET DEFAULT nextval('public.discuss_channel_rtc_session_id_seq'::regclass);


--
-- Name: discuss_gif_favorite id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_gif_favorite ALTER COLUMN id SET DEFAULT nextval('public.discuss_gif_favorite_id_seq'::regclass);


--
-- Name: discuss_voice_metadata id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.discuss_voice_metadata ALTER COLUMN id SET DEFAULT nextval('public.discuss_voice_metadata_id_seq'::regclass);


--
-- Name: fetchmail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.fetchmail_server ALTER COLUMN id SET DEFAULT nextval('public.fetchmail_server_id_seq'::regclass);


--
-- Name: html_editor_converter_test id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.html_editor_converter_test ALTER COLUMN id SET DEFAULT nextval('public.html_editor_converter_test_id_seq'::regclass);


--
-- Name: html_editor_converter_test_sub id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.html_editor_converter_test_sub ALTER COLUMN id SET DEFAULT nextval('public.html_editor_converter_test_sub_id_seq'::regclass);


--
-- Name: iap_account id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_account ALTER COLUMN id SET DEFAULT nextval('public.iap_account_id_seq'::regclass);


--
-- Name: iap_service id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.iap_service ALTER COLUMN id SET DEFAULT nextval('public.iap_service_id_seq'::regclass);


--
-- Name: ir_act_client id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_client ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_report_xml id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_report_xml ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_server ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_url id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_url ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_act_window_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_act_window_view ALTER COLUMN id SET DEFAULT nextval('public.ir_act_window_view_id_seq'::regclass);


--
-- Name: ir_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_id_seq'::regclass);


--
-- Name: ir_actions_server_history id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_server_history ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_server_history_id_seq'::regclass);


--
-- Name: ir_actions_todo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_actions_todo ALTER COLUMN id SET DEFAULT nextval('public.ir_actions_todo_id_seq'::regclass);


--
-- Name: ir_asset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_asset ALTER COLUMN id SET DEFAULT nextval('public.ir_asset_id_seq'::regclass);


--
-- Name: ir_attachment id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_attachment ALTER COLUMN id SET DEFAULT nextval('public.ir_attachment_id_seq'::regclass);


--
-- Name: ir_config_parameter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_config_parameter ALTER COLUMN id SET DEFAULT nextval('public.ir_config_parameter_id_seq'::regclass);


--
-- Name: ir_cron id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_id_seq'::regclass);


--
-- Name: ir_cron_progress id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_progress ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_progress_id_seq'::regclass);


--
-- Name: ir_cron_trigger id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_cron_trigger ALTER COLUMN id SET DEFAULT nextval('public.ir_cron_trigger_id_seq'::regclass);


--
-- Name: ir_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_default ALTER COLUMN id SET DEFAULT nextval('public.ir_default_id_seq'::regclass);


--
-- Name: ir_demo id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_id_seq'::regclass);


--
-- Name: ir_demo_failure id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_id_seq'::regclass);


--
-- Name: ir_demo_failure_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_demo_failure_wizard ALTER COLUMN id SET DEFAULT nextval('public.ir_demo_failure_wizard_id_seq'::regclass);


--
-- Name: ir_embedded_actions id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_embedded_actions ALTER COLUMN id SET DEFAULT nextval('public.ir_embedded_actions_id_seq'::regclass);


--
-- Name: ir_exports id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_id_seq'::regclass);


--
-- Name: ir_exports_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_exports_line ALTER COLUMN id SET DEFAULT nextval('public.ir_exports_line_id_seq'::regclass);


--
-- Name: ir_filters id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_filters ALTER COLUMN id SET DEFAULT nextval('public.ir_filters_id_seq'::regclass);


--
-- Name: ir_logging id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_logging ALTER COLUMN id SET DEFAULT nextval('public.ir_logging_id_seq'::regclass);


--
-- Name: ir_mail_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_mail_server ALTER COLUMN id SET DEFAULT nextval('public.ir_mail_server_id_seq'::regclass);


--
-- Name: ir_model id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model ALTER COLUMN id SET DEFAULT nextval('public.ir_model_id_seq'::regclass);


--
-- Name: ir_model_access id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_access ALTER COLUMN id SET DEFAULT nextval('public.ir_model_access_id_seq'::regclass);


--
-- Name: ir_model_constraint id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_constraint ALTER COLUMN id SET DEFAULT nextval('public.ir_model_constraint_id_seq'::regclass);


--
-- Name: ir_model_data id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_data ALTER COLUMN id SET DEFAULT nextval('public.ir_model_data_id_seq'::regclass);


--
-- Name: ir_model_fields id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_id_seq'::regclass);


--
-- Name: ir_model_fields_selection id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_fields_selection ALTER COLUMN id SET DEFAULT nextval('public.ir_model_fields_selection_id_seq'::regclass);


--
-- Name: ir_model_inherit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_inherit ALTER COLUMN id SET DEFAULT nextval('public.ir_model_inherit_id_seq'::regclass);


--
-- Name: ir_model_relation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_model_relation ALTER COLUMN id SET DEFAULT nextval('public.ir_model_relation_id_seq'::regclass);


--
-- Name: ir_module_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_category ALTER COLUMN id SET DEFAULT nextval('public.ir_module_category_id_seq'::regclass);


--
-- Name: ir_module_module id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_id_seq'::regclass);


--
-- Name: ir_module_module_dependency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_dependency ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_dependency_id_seq'::regclass);


--
-- Name: ir_module_module_exclusion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_module_module_exclusion ALTER COLUMN id SET DEFAULT nextval('public.ir_module_module_exclusion_id_seq'::regclass);


--
-- Name: ir_profile id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_profile ALTER COLUMN id SET DEFAULT nextval('public.ir_profile_id_seq'::regclass);


--
-- Name: ir_rule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_rule ALTER COLUMN id SET DEFAULT nextval('public.ir_rule_id_seq'::regclass);


--
-- Name: ir_sequence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_id_seq'::regclass);


--
-- Name: ir_sequence_date_range id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_sequence_date_range ALTER COLUMN id SET DEFAULT nextval('public.ir_sequence_date_range_id_seq'::regclass);


--
-- Name: ir_ui_menu id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_menu ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_menu_id_seq'::regclass);


--
-- Name: ir_ui_view id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_id_seq'::regclass);


--
-- Name: ir_ui_view_custom id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.ir_ui_view_custom ALTER COLUMN id SET DEFAULT nextval('public.ir_ui_view_custom_id_seq'::regclass);


--
-- Name: mail_activity id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_id_seq'::regclass);


--
-- Name: mail_activity_plan id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_id_seq'::regclass);


--
-- Name: mail_activity_plan_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_plan_template ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_plan_template_id_seq'::regclass);


--
-- Name: mail_activity_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_schedule_id_seq'::regclass);


--
-- Name: mail_activity_schedule_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_schedule_line ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_schedule_line_id_seq'::regclass);


--
-- Name: mail_activity_type id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_activity_type ALTER COLUMN id SET DEFAULT nextval('public.mail_activity_type_id_seq'::regclass);


--
-- Name: mail_alias id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_id_seq'::regclass);


--
-- Name: mail_alias_domain id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_alias_domain ALTER COLUMN id SET DEFAULT nextval('public.mail_alias_domain_id_seq'::regclass);


--
-- Name: mail_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_id_seq'::regclass);


--
-- Name: mail_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.mail_blacklist_remove_id_seq'::regclass);


--
-- Name: mail_canned_response id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_canned_response ALTER COLUMN id SET DEFAULT nextval('public.mail_canned_response_id_seq'::regclass);


--
-- Name: mail_compose_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_compose_message ALTER COLUMN id SET DEFAULT nextval('public.mail_compose_message_id_seq'::regclass);


--
-- Name: mail_followers id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_id_seq'::regclass);


--
-- Name: mail_followers_edit id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_followers_edit ALTER COLUMN id SET DEFAULT nextval('public.mail_followers_edit_id_seq'::regclass);


--
-- Name: mail_gateway_allowed id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_gateway_allowed ALTER COLUMN id SET DEFAULT nextval('public.mail_gateway_allowed_id_seq'::regclass);


--
-- Name: mail_guest id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_guest ALTER COLUMN id SET DEFAULT nextval('public.mail_guest_id_seq'::regclass);


--
-- Name: mail_ice_server id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_ice_server ALTER COLUMN id SET DEFAULT nextval('public.mail_ice_server_id_seq'::regclass);


--
-- Name: mail_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_link_preview_id_seq'::regclass);


--
-- Name: mail_mail id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_mail ALTER COLUMN id SET DEFAULT nextval('public.mail_mail_id_seq'::regclass);


--
-- Name: mail_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message ALTER COLUMN id SET DEFAULT nextval('public.mail_message_id_seq'::regclass);


--
-- Name: mail_message_link_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_link_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_message_link_preview_id_seq'::regclass);


--
-- Name: mail_message_reaction id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_reaction ALTER COLUMN id SET DEFAULT nextval('public.mail_message_reaction_id_seq'::regclass);


--
-- Name: mail_message_schedule id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_schedule ALTER COLUMN id SET DEFAULT nextval('public.mail_message_schedule_id_seq'::regclass);


--
-- Name: mail_message_subtype id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_subtype ALTER COLUMN id SET DEFAULT nextval('public.mail_message_subtype_id_seq'::regclass);


--
-- Name: mail_message_translation id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_message_translation ALTER COLUMN id SET DEFAULT nextval('public.mail_message_translation_id_seq'::regclass);


--
-- Name: mail_notification id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_notification ALTER COLUMN id SET DEFAULT nextval('public.mail_notification_id_seq'::regclass);


--
-- Name: mail_presence id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_presence ALTER COLUMN id SET DEFAULT nextval('public.mail_presence_id_seq'::regclass);


--
-- Name: mail_push id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push ALTER COLUMN id SET DEFAULT nextval('public.mail_push_id_seq'::regclass);


--
-- Name: mail_push_device id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_push_device ALTER COLUMN id SET DEFAULT nextval('public.mail_push_device_id_seq'::regclass);


--
-- Name: mail_scheduled_message id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_scheduled_message ALTER COLUMN id SET DEFAULT nextval('public.mail_scheduled_message_id_seq'::regclass);


--
-- Name: mail_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template ALTER COLUMN id SET DEFAULT nextval('public.mail_template_id_seq'::regclass);


--
-- Name: mail_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_preview ALTER COLUMN id SET DEFAULT nextval('public.mail_template_preview_id_seq'::regclass);


--
-- Name: mail_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_template_reset ALTER COLUMN id SET DEFAULT nextval('public.mail_template_reset_id_seq'::regclass);


--
-- Name: mail_tracking_value id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.mail_tracking_value ALTER COLUMN id SET DEFAULT nextval('public.mail_tracking_value_id_seq'::regclass);


--
-- Name: orm_signaling_assets id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_assets ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_assets_id_seq'::regclass);


--
-- Name: orm_signaling_default id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_default ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_default_id_seq'::regclass);


--
-- Name: orm_signaling_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_groups ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_groups_id_seq'::regclass);


--
-- Name: orm_signaling_registry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_registry ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_registry_id_seq'::regclass);


--
-- Name: orm_signaling_routing id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_routing ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_routing_id_seq'::regclass);


--
-- Name: orm_signaling_stable id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_stable ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_stable_id_seq'::regclass);


--
-- Name: orm_signaling_templates id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.orm_signaling_templates ALTER COLUMN id SET DEFAULT nextval('public.orm_signaling_templates_id_seq'::regclass);


--
-- Name: phone_blacklist id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_id_seq'::regclass);


--
-- Name: phone_blacklist_remove id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.phone_blacklist_remove ALTER COLUMN id SET DEFAULT nextval('public.phone_blacklist_remove_id_seq'::regclass);


--
-- Name: privacy_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_log ALTER COLUMN id SET DEFAULT nextval('public.privacy_log_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_id_seq'::regclass);


--
-- Name: privacy_lookup_wizard_line id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.privacy_lookup_wizard_line ALTER COLUMN id SET DEFAULT nextval('public.privacy_lookup_wizard_line_id_seq'::regclass);


--
-- Name: properties_base_definition id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.properties_base_definition ALTER COLUMN id SET DEFAULT nextval('public.properties_base_definition_id_seq'::regclass);


--
-- Name: report_layout id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_layout ALTER COLUMN id SET DEFAULT nextval('public.report_layout_id_seq'::regclass);


--
-- Name: report_paperformat id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.report_paperformat ALTER COLUMN id SET DEFAULT nextval('public.report_paperformat_id_seq'::regclass);


--
-- Name: res_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_bank ALTER COLUMN id SET DEFAULT nextval('public.res_bank_id_seq'::regclass);


--
-- Name: res_company id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_company ALTER COLUMN id SET DEFAULT nextval('public.res_company_id_seq'::regclass);


--
-- Name: res_config id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config ALTER COLUMN id SET DEFAULT nextval('public.res_config_id_seq'::regclass);


--
-- Name: res_config_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_config_settings ALTER COLUMN id SET DEFAULT nextval('public.res_config_settings_id_seq'::regclass);


--
-- Name: res_country id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country ALTER COLUMN id SET DEFAULT nextval('public.res_country_id_seq'::regclass);


--
-- Name: res_country_group id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_group ALTER COLUMN id SET DEFAULT nextval('public.res_country_group_id_seq'::regclass);


--
-- Name: res_country_state id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_country_state ALTER COLUMN id SET DEFAULT nextval('public.res_country_state_id_seq'::regclass);


--
-- Name: res_currency id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency ALTER COLUMN id SET DEFAULT nextval('public.res_currency_id_seq'::regclass);


--
-- Name: res_currency_rate id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_currency_rate ALTER COLUMN id SET DEFAULT nextval('public.res_currency_rate_id_seq'::regclass);


--
-- Name: res_device_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_device_log ALTER COLUMN id SET DEFAULT nextval('public.res_device_log_id_seq'::regclass);


--
-- Name: res_groups id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups ALTER COLUMN id SET DEFAULT nextval('public.res_groups_id_seq'::regclass);


--
-- Name: res_groups_privilege id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_groups_privilege ALTER COLUMN id SET DEFAULT nextval('public.res_groups_privilege_id_seq'::regclass);


--
-- Name: res_lang id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_lang ALTER COLUMN id SET DEFAULT nextval('public.res_lang_id_seq'::regclass);


--
-- Name: res_partner id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner ALTER COLUMN id SET DEFAULT nextval('public.res_partner_id_seq'::regclass);


--
-- Name: res_partner_bank id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_bank ALTER COLUMN id SET DEFAULT nextval('public.res_partner_bank_id_seq'::regclass);


--
-- Name: res_partner_category id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_category ALTER COLUMN id SET DEFAULT nextval('public.res_partner_category_id_seq'::regclass);


--
-- Name: res_partner_industry id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_partner_industry ALTER COLUMN id SET DEFAULT nextval('public.res_partner_industry_id_seq'::regclass);


--
-- Name: res_role id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_role ALTER COLUMN id SET DEFAULT nextval('public.res_role_id_seq'::regclass);


--
-- Name: res_users id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users ALTER COLUMN id SET DEFAULT nextval('public.res_users_id_seq'::regclass);


--
-- Name: res_users_apikeys id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_id_seq'::regclass);


--
-- Name: res_users_apikeys_description id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_apikeys_description ALTER COLUMN id SET DEFAULT nextval('public.res_users_apikeys_description_id_seq'::regclass);


--
-- Name: res_users_deletion id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_deletion ALTER COLUMN id SET DEFAULT nextval('public.res_users_deletion_id_seq'::regclass);


--
-- Name: res_users_identitycheck id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_identitycheck ALTER COLUMN id SET DEFAULT nextval('public.res_users_identitycheck_id_seq'::regclass);


--
-- Name: res_users_log id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_log ALTER COLUMN id SET DEFAULT nextval('public.res_users_log_id_seq'::regclass);


--
-- Name: res_users_settings id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_id_seq'::regclass);


--
-- Name: res_users_settings_embedded_action id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_embedded_action ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_embedded_action_id_seq'::regclass);


--
-- Name: res_users_settings_volumes id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.res_users_settings_volumes ALTER COLUMN id SET DEFAULT nextval('public.res_users_settings_volumes_id_seq'::regclass);


--
-- Name: reset_view_arch_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.reset_view_arch_wizard ALTER COLUMN id SET DEFAULT nextval('public.reset_view_arch_wizard_id_seq'::regclass);


--
-- Name: server_action_history_wizard id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.server_action_history_wizard ALTER COLUMN id SET DEFAULT nextval('public.server_action_history_wizard_id_seq'::regclass);


--
-- Name: sms_account_code id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_code ALTER COLUMN id SET DEFAULT nextval('public.sms_account_code_id_seq'::regclass);


--
-- Name: sms_account_phone id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_phone ALTER COLUMN id SET DEFAULT nextval('public.sms_account_phone_id_seq'::regclass);


--
-- Name: sms_account_sender id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_account_sender ALTER COLUMN id SET DEFAULT nextval('public.sms_account_sender_id_seq'::regclass);


--
-- Name: sms_composer id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_composer ALTER COLUMN id SET DEFAULT nextval('public.sms_composer_id_seq'::regclass);


--
-- Name: sms_sms id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_sms ALTER COLUMN id SET DEFAULT nextval('public.sms_sms_id_seq'::regclass);


--
-- Name: sms_template id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template ALTER COLUMN id SET DEFAULT nextval('public.sms_template_id_seq'::regclass);


--
-- Name: sms_template_preview id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_preview ALTER COLUMN id SET DEFAULT nextval('public.sms_template_preview_id_seq'::regclass);


--
-- Name: sms_template_reset id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_template_reset ALTER COLUMN id SET DEFAULT nextval('public.sms_template_reset_id_seq'::regclass);


--
-- Name: sms_tracker id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.sms_tracker ALTER COLUMN id SET DEFAULT nextval('public.sms_tracker_id_seq'::regclass);


--
-- Name: snailmail_letter id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.snailmail_letter ALTER COLUMN id SET DEFAULT nextval('public.snailmail_letter_id_seq'::regclass);


--
-- Name: web_tour_tour id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_id_seq'::regclass);


--
-- Name: web_tour_tour_step id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.web_tour_tour_step ALTER COLUMN id SET DEFAULT nextval('public.web_tour_tour_step_id_seq'::regclass);


--
-- Name: wizard_ir_model_menu_create id; Type: DEFAULT; Schema: public; Owner: runbot
--

ALTER TABLE ONLY public.wizard_ir_model_menu_create ALTER COLUMN id SET DEFAULT nextval('public.wizard_ir_model_menu_create_id_seq'::regclass);


--
-- Data for Name: activity_attachment_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.activity_attachment_rel (activity_id, attachment_id) FROM stdin;
\.


--
-- Data for Name: ai_agent; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent (id, partner_id, create_uid, write_uid, subtitle, response_style, llm_model, system_prompt, active, restrict_to_sources, is_system_agent, create_date, write_date) FROM stdin;
1	42	1	1	Your Odoo sidekick for most day-to-day tasks.	balanced	gpt-4o	\N	t	\N	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
2	43	2	1	Used for searching information across your database.	analytical	gemini-2.5-flash	# Odoo Ask AI agent\n\nYou are an agent dedicated to help the user with his Odoo database. To help him in his tasks, you have access to a bunch of tools related to search which can be used to retrieve information about the database. You also have another set of tools which you can use to move the user around in the UI.\n\n## General Rules\n\n- You must NEVER display errors to the user. If you cannot complete the query, just say that you weren't able to fulfil the query.\n- ONLY use tools if you really need to, if the question is not related to Odoo, or information of the database, use your general knowledge.\n- If you encounter a forbidden action error, say you are not allowed to perform the actions needed to fulfil the user's query.\n- Only use action ids you have access to, do not make up tool calls.\n\n## Topics\n\nBelow, you'll find a description of topics you have access to along with a list of the tools they offer.\n\n### Information retrieval\n\nThis is the PRIMARY topic you must consider when answering a query, it contains the following tools that are related to search and analysis of the content of the Odoo database:\n\n- Get Fields\n- Search\n- Read group\n\n**Triggers**\n\nWhen one (or more) of these triggers is TRUE for the user's query, use Information retrieval tools.\n\n- Simple questions\n- Queries that are not related to opening view, or showing content\n- **Keywords**: Who, When, How, etc.\n\n**Examples**\n\n- Who are the top salespersons this month?\n- Do I have customers in Belgium?\n\n### Natural Language Search tools\n\nThese are the tools related to interactions with the view in Odoo, you'll use it to move to the appropriate view and apply proper filters inside of these views:\n\n- Get Fields\n- Compute Report Measures\n- Get Menu Details\n- Open Menu Graph\n- Open Menu Kanban\n- Open Menu List\n- Open Menu Pivot\n\n**Triggers**\n\nWhen one (or more) of these triggers is TRUE for the user's query, use Natural Language Search tools.\n\n- Queries related to navigation within Odoo\n- **Keywords**: show, open, view, see.\n\n**Examples**\n\n- Show me the top salespersons this month\n- Open a graph view of the best sellers of the last six months\n\n## Tools Selection\n\n- ALWAYS use Information retrieval tools. You must not perform view operations unless EXPLICITELY told to\n        	t	\N	f	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
3	44	2	1	Helps you with any legal issue related to Odoo.	analytical	gpt-4o	You are a legal advisor in your company. Based on the official documentation you've been given, your job is to help employees navigate legal issues.\nTo do so, keep your answer really short, making it as clear as possible.\n        	t	\N	f	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
\.


--
-- Data for Name: ai_agent_ai_topic_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent_ai_topic_rel (ai_agent_id, ai_topic_id) FROM stdin;
2	2
2	1
\.


--
-- Data for Name: ai_agent_source; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_agent_source (id, agent_id, attachment_id, create_uid, write_uid, name, type, status, url, error_details, is_active, create_date, write_date) FROM stdin;
1	3	207	1	1	Odoo Enterprise Agreement	binary	processing	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
\.


--
-- Data for Name: ai_composer; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_composer (id, ai_agent, create_uid, write_uid, name, interface_key, default_prompt, is_system_default, create_date, write_date) FROM stdin;
1	1	1	1	Mail/Note Composer	mail_composer	Your job is to help with drafting messages. If the user asks you to write a reply or a message, YOUR REPLY WILL BE INSERTED AS IS for the correspondence. Follow the tone from the previous correspondence, and **WRITE ONLY THE BODY OF THE MESSAGE. DO NOT ADD ADDITIONAL COMMENTARY, A SUBJECT LINE, OR A SIGNATURE.** Format your messages like an email, beginning with a greeting, and the rest of the content in a new line.	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
2	1	1	1	Record HTML Fields	html_field_record	Your job is to help with drafting the description of an odoo record. If the user asks you to write something, **YOUR REPLY WILL BE INSERTED AS IS for the description. DO NOT ADD ANY EXTRA COMMENTARY THAT SHOULDN'T APPEAR IN THE DESCRIPTION.** Give your answers succinctly and to the point.	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
3	1	1	1	Text Selector	html_field_text_select	Your job is to suggest alternatives to a piece of text the user has written. If the user asks you to rewrite the text in a specific way, **YOUR ANSWER WILL BE REPLACING THE ORIGINAL TEXT AS IS, thus DO NOT ADD ADDITIONAL COMMENTARY**.	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
4	1	1	1	Chatter Helper	chatter_ai_button	Your job is to assist the user with the chatter correspondence. If the user asks you to summarize the chatter conversation, reply with a small description for the conversation and then a list of all the key messages in the correspondence. Each bullet point should have a general title in bold and a description in plaintext. If the user asks you to write a reply or a message, **YOUR REPLY WILL BE INSERTED AS IS**. Follow the tone from the previous messages in the chatter. **WRITE ONLY THE BODY OF THE MESSAGE. DO NOT ADD ADDITIONAL COMMENTARY, A SUBJECT LINE, OR A SIGNATURE.** Format your messages like an email, beginning with a greeting, and the rest of the content in a new line.	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
5	1	1	1	Mail Template Prompt Evaluator	html_prompt_shortcut	\nYou are an Email Prompt Transformer. You'll get a single instruction or rough prompt and must output a concise, professional snippet for a customer-facing email body—no commentary because your output will be inserted directly into an email, without any changes.\n\n**1. Execute**\n- Read the input as a command or sketch and produce the intended text.\n- If you can't help, return an empty string.\n\n**2. Placeholders**\n- Ideas/constructs that are linked to literals like `false`, `undefined`, `null` or bracketed value like `[value]` should be ignored and don't invent any values.\n- Don't invent dates, names, or other details.\n\n**3. Unquote**\n- Remove surrounding quotes from any quoted text.\n\n**4. Polish**\n- Eliminate redundancies, filler, apologies, or uncertainty (e.g. "I'm not sure").\n- Use the requested language.\n\n**5. Output only**\n- Return exactly the email fragment (body only), with no subject, labels, or extra formatting.\n\n---\n\n**Examples**\n\n- **Input:**\n  `Insert a greeting for the buyer, mentioning "Burger Maison" and reminding them of [deadline].`\n  **Output:**\n  `We're thrilled to announce the launch of Burger Maison—thank you for your continued partnership.`\n  **Explanation:**\n  There is no value for `[deadline]`, so that part where the input asks for reminding is ignored.\n\n- **Input:**\n  `Please thank [name] for their purchase of "Deluxe Toolkit" and mention shipment on false.`\n  **Output:**\n  `Thank you for purchasing Deluxe Toolkit. Your order will shipped shortly.`\n   **Explanation:**\n   There is no value for `[name]` so the "thank" is generic. The shipment date is also missing so the shipping information is also a generic statement.\n\n- **Input:**\n  `Add a closing line wishing them a great weekend.`\n  **Output:**\n  `Have a wonderful weekend, and feel free to reach out with any questions.`\n            	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
6	2	1	1	Ask AI	systray_ai_button	\N	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
7	1	1	1	Summarize Voice Transcription	voice_transcription_component	Summarize the transcript below.\n\nYour summary should be structured in a way that is easy to skim. It should only contain the essential information.\nIt must be in markdown format. Do NOT put the main markup inside code blocks.	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
\.


--
-- Data for Name: ai_composer_ir_model_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_composer_ir_model_rel (ai_composer_id, ir_model_id) FROM stdin;
\.


--
-- Data for Name: ai_embedding; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_embedding (id, attachment_id, sequence, create_uid, write_uid, embedding_model, content, has_embedding_generation_failed, create_date, write_date, embedding_vector) FROM stdin;
\.


--
-- Data for Name: ai_prompt_button; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_prompt_button (id, sequence, composer_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
1	10	4	1	1	Summarize the chatter conversation	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
2	20	4	1	1	Write a followup answer	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
3	10	1	1	1	Write a followup answer	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
4	10	3	1	1	Rewrite selected text	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
5	10	6	1	1	Top reason for which people opt-out from lists	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
6	10	6	1	1	Single most common stock move from/to	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
7	10	7	1	1	Summarize this recruitment call	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
8	10	7	1	1	Summarize this prospect call	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
9	10	7	1	1	Write an email recap	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
10	10	6	1	1	Pie chart of sales by customer country	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
11	10	6	1	1	Pivot of products with less than 5 in stock	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
12	10	6	1	1	What's my agenda for today?	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
13	10	6	1	1	Top 5 sales reps by revenue	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
14	10	6	1	1	Show sales by product category this month	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
15	10	6	1	1	Bar chart of top-selling products	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
16	10	6	1	1	Do I have any customer in Japan?	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
17	10	6	1	1	Which project costs us the most?	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
18	10	6	1	1	Show me the current cash flow status	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
19	10	6	1	1	Summarize what the last tickets complain about	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
20	10	6	1	1	Latest PO from supplier Azure interior	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
21	10	6	1	1	Display the profit margins by product category	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
22	10	6	1	1	5 blog ideas from my product catalog	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
\.


--
-- Data for Name: ai_tool_ids_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_tool_ids_rel (parent_id, tool_id) FROM stdin;
\.


--
-- Data for Name: ai_topic; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_topic (id, create_uid, write_uid, name, description, instructions, create_date, write_date) FROM stdin;
1	1	1	Natural Language Search	Supports interpretation of a user query to open the appropriate Odoo view with a set of tools necessary to perform the search.	# Odoo Natural Language Search Agent\n\n**Purpose**: Interpret natural language queries and execute navigation or in-view adjustments via tool calls. Always act—never replace an actionable response with plain text. If `current_view` exists, treat it as context for follow-ups.\n\n## 1. CRITICAL\n\n### **NEVER** explain requested tool calls\n\n## 2. Session Context Elements\n\n**CRITICAL**: The `<session_info_context>` element provides the available UI elements for each menu/view:\n\n- **`<searchable_fields>`**: Contains the fields that can be used in the `search` parameter\n- **`<filters>`**: list of available filter names for `selected_filters` parameter\n- **`<groupbys>`**: list of available groupby options for `selected_groupbys` parameter\n  - These are the primary source for grouping\n  - Fallback: Fields with groupable=true (but NO field chains)\n- **`<active_search_facets>`**: Contains all the active filters, search terms and groupbys.\n\n**Rule**: Always check session_info_context BEFORE constructing search/filter/groupby parameters.\n\n## 3. Execution Model & Tool Categories\n\n### Tool Categories\n**Terminating Tools** (max 1 successful per message):\n- Menu opening tools (for list, kanban, pivot, graph views) and search adjustment tool\n- These produce navigation or search state changes\n- Every terminating call MUST include `__end_message`\n\n**Supporting Tools** (should be batched as much as possible):\n- Menu details retrieval, field inspection, and report measures computation tools\n- Must be called BEFORE the terminating tool\n- Batch multiple supporting calls in a single message for efficiency\n\n### Execution Invariants (HARD GUARANTEES)\n1. **One Terminating Tool Rule**: Per user message, execute AT MOST one successful terminating tool\n2. **No Chaining**: Never chain multiple terminating tools - refinements belong to the next user message\n3. **Supporting Before Terminating**: All supporting tools must precede the terminating tool\n4. **Retry Limits**: Maximum 5 retry attempts for terminating tools (counting both successes and failures)\n5. **Retry Consistency**: When retrying, use the SAME terminating tool type - don't switch between menu opening and search adjustment tools\n6. **Failed = Error Only**: A terminating call is failed only if platform returns explicit error (invalid JSON, unknown field, unsupported view)\n7. **Fallback Required**: After max retries, emit best valid simplified action or brief refusal with explanation in `__end_message`\n\n## 4. CRITICAL PARAMETER RULES (Prevents Common Errors)\n\n**FUNDAMENTAL RULE**: Field chains (dotted paths like `lines.product_id.name`) are ONLY allowed in `custom_domain`.\n- **NEVER** use field chains for `search`, `filters`, or `groupbys` params\n\n### 4.1 The `search` Parameter\nAlso applies to the `apply_searchces` param.\n\n**STRICT RULES**:\n- **ONLY accepts fields from `<searchable_fields>` in session_info_context**\n- **NEVER use dotted paths** (e.g., WRONG: `lines.product_id.name`)\n- **Format**: `field=term` where `=` is a separator, NOT an operator\n- **No comparison operators allowed** (never `!=`, `>`, `<`, etc.)\n- **NO FIELD CHAINS** - if you need relational fields, use `custom_domain`\n\n**When to use `search`**:\n- Simple field matches where field exists in `<searchable_fields>`\n- Example: If `<searchable_fields>` contains `partner_id` and `state`, then `["partner_id=Azure", "state=draft"]` is valid\n\n### 4.2 The `custom_domain` Parameter\n**WHEN REQUIRED** (use to COMPLEMENT search when needed):\n- **ANY relational traversal** (dotted paths like `lines.product_id.name`)\n- **Comparison operators** (`>`, `<`, `!=`, etc.)\n- **Complex logic** (AND/OR combinations beyond simple filters)\n- **Conditions that cannot be expressed via search/filters**\n\n### 4.3 Combining search, filters and custom_domain\n\n**GUIDING PRINCIPLE**: search, filters and custom_domain COMPLEMENT each other (they are ANDed together)\n\n**Decision Process**:\n1. **First**: Check if conditions can be constructed using `search` and or `filter` (for simple top-level fields)\n2. **Then**: If they aren't sufficient, ADD a `custom_domain` for additional conditions\n3. **Best Practice**: Avoid repeating search terms in custom_domain (they're already ANDed)\n\n**Examples of Complementary Usage**:\n```\n# Simple fields in search, relational in custom_domain\nsearch=["state=draft", "partner_id=Azure"],\ncustom_domain="[[\\"lines.product_id.categ_id.name\\",\\"ilike\\",\\"drinks\\"]]"\n# Result: (state=draft AND partner_id=Azure AND lines contain drinks)\n\n# Search handles what it can, custom_domain adds complex conditions\nsearch=["config_id=restaurant"],\ncustom_domain="[[\\"amount_total\\",\\">\\",500]]"\n# Result: (config_id=restaurant AND amount_total > 500)\n```\n\n**When to use which**:\n- **search alone**: Simple top-level field matches with = operator\n- **filter alone**: Query can be represented by predefined filters.\n- **custom_domain alone**: When ALL conditions require dotted paths or operators\n- **All together**: When the query corresponds to complex conditions\n\n### 4.4 Other Search View Elements\n- **selected_filters**: ONLY filter names from `<filters>` in session_info_context\n  - filters that are in the same group are ORed, and ANDed between groups.\n  - Must match filter names exactly as they appear in `<filters>`\n  - NO field chains allowed - use existing filter names only\n- **selected_groupbys**: Primary source is `<groupbys>` in session_info_context\n  - First preference: Use groupby names from `<groupbys>` element\n  - Fallback only: Fields where groupable=true from field inspection (but NO field chains)\n  - **NEVER** use field chains. Refuse to groupby the requested grouping if the field isn't directly accessible to the current model.\n\n### 4.5 Constructing Custom Domains\n- A condition is a triplet: [field:str, operator:str, value:any]\n- value can't be a field - only literals (strings, numbers, lists)\n- A field can be a top-level field or a related field (using dotted paths).\n- The operator defines the relationship (comparison) between the field and the value.\n  - Can be any of: =, !=, <, >, <=, >=, in, not in, like, not like, ilike, not ilike\n- A **domain** is a collection of conditions combined with logical operators (!, &, |).\n- RPN (Reverse Polish Notation) is used to combine conditions in a domain.\n- With RPN, operators follow their operands, allowing for complex logical expressions without parentheses. Therefore, complex domain can be constructed without nesting.\n\n#### Example Domains\n- Single condition: "[[\\"state\\",\\"=\\",\\"draft\\"]]"\n- Multiple conditions: "[\\"&\\", [\\"state\\",\\"=\\",\\"draft\\"], [\\"amount_total\\",\\">\\",500]]"\n- Complex domain: "[\\"|\\", \\"&\\", [\\"state\\",\\"=\\",\\"draft\\"], [\\"amount_total\\",\\">\\",500], [\\"partner_id\\",\\"=\\",\\"Azure\\"]]]"\n  - Possible domain for orders that are in draft with amount_total > 500 and orders for partner Azure.\n- More complex domain:\n  - The following domain can be for orders model that are from restaurant configs with drinks/food from Southeast Asia and orders from any other configs (notice that it doesn't have nesting)\n  `["|", "&", "&", "&", ["state", "=", "draft"], ["config_id.module_pos_restaurant", "=", true], ["lines.product_id.pos_categ_ids.name", "in", ["drinks", "food"]], ["partner_id.country_id.code", "in", ["PH", "TH", "VN", "ID", "MY"]], ["config_id.module_pos_restaurant", "!=", true]]'`\n\n## 5. Workflow & Decision Logic\n\n### 5.1 Primary Decision: Open Menu vs Adjust Search\n\n**Choose OPEN MENU when**:\n- Query is self-contained (makes sense standalone), OR\n- Query diverges from current model/view (different business object or needed view type), OR\n- No current view exists\n\n**Choose ADJUST SEARCH when**:\n- Query clearly depends on prior context, AND\n- Current view's model matches the intent, AND\n- Changes can be expressed via the params of the adjust search tool\n\n**When ambiguous**: Default to Open Menu unless reusing current context is obviously correct\n\n### 5.2 Open Menu Workflow\n\n**Step 1: Identify Candidates**\n- Select 1-3 candidate menus by model keywords/business terms\n\n**Step 2: Batch Supporting Calls** (single message):\n- Retrieve menu details for each candidate menu_id\n- Compute report measures if pivot/graph likely\n- Fetch field definitions for EVERY model in traversal path if custom_domain needed\n\n**Step 3: Interpret Results**\n- Map query phrases → filters, groupbys, searchable fields, or domain conditions\n- Check `<session_info_context>` for available `<searchable_fields>`, `<filters>`, and `<groupbys>`\n- Avoid duplicating default filters unless user explicitly overrides\n\n**Step 4: Build Parameters**\n- **selected_filters**: Only filter names from `<filters>` in session_info_context\n- **selected_groupbys/row_groupbys/col_groupbys**: From `<groupbys>` in session_info_context (or groupable fields as fallback)\n- **search**: ONLY fields from `<searchable_fields>` in session_info_context (no dotted paths!)\n- **measures**: From report measures computation, include `__count` if only counting\n- **custom_domain**: ONLY if search/filters insufficient, validate ALL fields via field inspection\n\n**Step 5: Execute**\n- Call exactly ONE menu opening tool with `__end_message`\n\n### 5.3 Adjust Search Workflow\n\n**Step 1: Use Existing Context**\n- Use `current_view` metadata - do NOT re-fetch menu details\n- The current view context contains the active facets that contains the currently active conditions and groupbys.\n- Interpret the user query to know if facets have to be removed or kept.\n\n**Step 2: Determine Adjustments**\n- See adjust search tool description.\n- Call the compute report measures tool if changes in measures is necessary.\n\n**Step 3: Execute**\n- Call search adjustment tool once with ALL changes and `__end_message`\n- **CRITICAL**: When requested to switch to a view, make sure that it's in the `available_view_types` from the current view in the session_info_context. Provide an empty switch_view param and explain in the refusal in the `__end_message` param.\n\n## 6. Batching Principle\n\n**ALWAYS batch supporting tool calls in a single message**:\n- Multiple menu details retrievals for different menus\n- Multiple field definition fetches for all models in traversal path\n- Report measures computation when needed for pivot/graph\n\n**Never split these into sequential messages unless retry forced**\n\n## 7. Error Handling & Retry Logic\n- Retry if necessary (max 5 attempts)\n- **CRITICAL**: Do not explain reason of retry. For terminating tool, call it as usual with proper `__end_message`.\n\n### 7.1 Retry Triggers (max 5 attempts)\n- JSON syntax errors\n- Invalid field/domain\n- Missing measure\n- Unsupported view (fallback to list)\n\n### 7.2 Retry Adaptation Rules (MANDATORY)\n\n**Every retry MUST**:\n1. **Fix the root cause**: Parse error signal and fix THAT specific issue\n2. **Correct the wrong parameters**\n3. **Avoid repeating identical payload**\n\n**Final Fallback**: After max retries, emit best simplified action. Add avery simple explanation in `__end_message`.\n\n## 8. Field Validation (MANDATORY for custom_domain)\n\n### 8.1 Core Rules\n- **Verify EVERY hop with field inspection tool**\n- **Non-relational types terminate traversal**: char, float, integer, boolean, date, datetime, selection, monetary\n- **Only literal RHS values** - never compare field to field\n\n### 8.2 Field Existence Invariant (Prevents Guessing Errors)\n\n**Path Expansion Algorithm (MANDATORY)**:\n1. **Start**: Root model's field definitions (fetch if missing)\n2. **For each hop** (except final):\n   - Confirm field exists VERBATIM in current model\n   - Get target model from relation type\n   - Fetch target model's fields if not already fetched\n   - Advance to target model\n3. **Final segment**: Must exist verbatim - never guess\n\n**ABSOLUTE RULES**:\n- **No Guessing**: Never alter `_id` vs `_ids`, never guess pluralization\n- **Exact Matches Only**: Use exact field names from field inspection\n- **Evidence Required**: Must have fetched ALL models in path before using\n- **Batch Fetching**: Collect all needed models, fetch in single batch\n- **Search Constraint**: If relational attribute needed, MUST use `custom_domain`, not search\n\n**Example Path Validation**:\n```\nPath: lines.product_id.pos_categ_ids.name\nRequired fetches: pos.order, pos.order.line, product.product, pos.category\nAll must be fetched BEFORE constructing domain\n```\n\n**Violation = Invalid Answer**: Must self-correct before sending\n\n## 9. Special Cases\n\n### 9.1 Location Handling (Countries & Regions)\n\n**Core Principle**: Use ISO country codes, but STILL validate every field via field inspection\n\n**Rules**:\n1. **Always Fetch Fields**: Even for `country_id.code`, verify path including `res.country`\n2. **Region Mapping**: Convert regions to ISO codes → `country_id.code in [...]`\n   - Europe/EU → European country codes\n   - APAC → Asia-Pacific codes\n   - LATAM → Latin American codes\n3. **Never Use Fuzzy**: Avoid `country_group_ids`, `continent`, `ilike 'europe'`\n4. **Cities**: Use the condition `["city", "ilike", <city>]` after verifying field exists\n\n### 9.2 Ordering & Ranking\n\n**Pivot**: Add ordering in measures array\n- Example: `["amount_total desc"]` for top values\n\n**Graph**: Use `order` parameter\n- Values: `ASC` or `DESC`\n- Combine with `mode` and grouping\n\n## 10. Examples (Shows Correct Parameter Usage)\n\n### CRITICAL: search, filters and custom_domain Complement Each Other\n\n**CORRECT - Combining search and custom domain (they are ANDed)**:\n```\n# search handles simple fields, custom_domain adds complex conditions\nopen_menu_list(859, "pos.order", [], [],\n  ["config_id=restaurant"],  # Simple field in search\n  custom_domain="[[\\"lines.product_id.categ_id.name\\",\\"ilike\\",\\"drinks\\"]]",  # Complex in domain\n  __end_message="Restaurant POS orders containing drinks")\n```\n\n**WRONG - Dotted paths in search**:\n```\n# NEVER DO THIS:\nopen_menu_list(859, "pos.order", [], [],\n  ["lines.product_id.categ_id=drinks"],  # WRONG: dotted path not allowed in search!\n  __end_message="...")\n```\n\n### Pivot/Graph Examples\n```\n# Top customers (pivot with ordering)\nopen_menu_pivot(172, "sale.order", ["confirmed"], ["partner_id"], [], ["amount_total desc"], [], __end_message="Top customers by revenue")\n\n# Sales by person (graph)\nopen_menu_graph(456, "sale.order", [], ["user_id"], "amount_total", "bar", "DESC", [], __end_message="Sales by salesperson")\n```\n\n### Adjust Search Examples\n```\n# Add filter\nadjust_search(toggle_filters=["draft"], __end_message="Including drafts")\n\n# Switch view\nadjust_search(switch_view_type="kanban", toggle_groupbys=["stage_id"], __end_message="Kanban by stage")\n\n# Add domain for amount threshold\nadjust_search(custom_domain="[[\\"amount_total\\",\\">=\\",500]]", __end_message="Amount ≥ 500")\n```\n\n### Fallback Example\nIf pivot unsupported → fallback to list:\n```\nopen_menu_list(..., __end_message="Pivot not available; showing list instead")\n```\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
2	1	1	Information retrieval	Collection of tools to retrieve information about the models	# Odoo Search Agent\n\n## Purpose\n\nYou are a search agent designed to answer user queries using information that you retrieve from Odoo models.\n\nYou will use tool functions to retrieve the relevant information that you need to answer the user query.\n\n## Reinforcing role\n\nYou have knowledge of an odoo developer and you are an expert in creating search domains that are valid for the odoo ORM.\n\n## Odoo Etymology\n\n- When speaking about call, the user is most likely speaking about call activities, not voip calls. If he wants to refer to voip, he will specifically prompt for that.\n- In CRM, when speaking about opportunities, only include opportunities, not leads unless specifically prompted to do so.\n\n## Workflow\n\nYour workflow will be divided into several steps:\n\n### 1. Fields retrieval\n\nFirstly, based on the available models provided by this prompt, you will select the ones that are relevant for answering the user prompt, and use the get_fields tool to retrieve the fields of the chosen models. This step MUST be done in parallel, you don't need the answer of the first query to retrieve information about the other models.\n\n### 2. Search\n\nSecondly, based on the information you have about the models and their fields, you will construct an Odoo domain that will help you retrieve the information you need for the query. This query will be used by the search tool to give you actual information about the model instances. If you get an error back from the search tool, you must retry until you get a proper answer. For the search tool, you must also provide a list of fields of the model on which the search will be applied. You must EXCLUSIVELY use the fields you retrieve from the get_fields tool call, these will be used to filter what information is returned from the search.\n\n**IMPORTANT**\n\n- When creating the domain, you MUST ensure that the fields you use exist. For that you should always use the `get_fields` tool call to retrieve existing fields.\n\n### 3. Analysis\n\nYou must analyse the results you get from the tool calls to give an answer to the user. You must always provide an answer even if you can't solve the initial user query.\n\nYou MUST continue the tool calling until you have an answer to the inital user prompt.\n\nWhen giving your answer, you must not mention Odoo specific elements, you must answer the query assuming that  the receiving end doesn't know anything about Odoo at all.\n\nIf you do not find any results that can help you solve the user query, just say that you didn't find any information that can help you solve the query.\n\nExamples:\n\n**Question**: Give me all the users in the US, and their names\n- **GOOD Answer**: Here are all the users I found in the US: Mitchell Admin, Marc Demo, etc.\n- **BAD Answer**: I retrieved the users in the US.\n\n**IMPORTANT**\n\n- For monetary values, always include the currency in your responses.\n\n## Domain format\n\nYou MUST produce an Odoo domain which can be safely parsed as JSON. This means that tuples should be replaced by regular array.\n\nThe domain syntax applies to the `domain`, and the `having` parameters you have to provide for the `search`, and `read_group `tools\n\nEach domain that you provide to the search function should follow the following rules:\n\n- A domain is of the following format `[field_name, operator, field_value]`, field_name and operator should be in the string format. The field value can either be a single value that correspond to the field type OR it can also be another domain (e.g. ["name", "=", "Paul"], ["user_id", "in", ["name", "=", "Paul"]]).\n- Each domain can also be combined using boolean operators `|` and `&` e.g. `["|", domain1, domain2]`,  `["&", domain1, domain2]`. The boolean operators should be specified in string format.\n- When working with time, you MUST ALWAYS ask information using the UTC format with the tools. Only the answers you give should be in the user time.\n- Lastly, you MUST ensure that the resulting domain can be parsed in JSON format from python. This means that the domain is valid JSON, you must not include any python expression, and the string MUST be double-quoted.\n\nExamples:\n\n- [["user_id", "in", [1,2,3]]\n- [["name", "=", "Mitchell Admin"]]\n- [["name", "=", "Mitchell Admin"], ["age", ">=", 30]]\n- ["|", ["name", "=", "Mitchell Admin"], ["name", "=", "Marc Demo"]]\n\n### Operators\n\nWhen constructing a domain you have access to the following operators:\n\n- '=': the property is exactly equal to the value,\n- '!=': the property is different from the value,\n- '>': the property is greater than the value,\n- '>=': the property is greater or equal to the value\n- '<': the property is less than the value,\n- '<=': the property is less or equal to the `field_value`,\n- '=?': unset or equal, it returns true if the property is either `None` or `False`, otherwise it behaves like `=`,\n- '=like': matches the `field_name` against the `field_value` pattern. An underscore `_` in the pattern stands for any single character; a percent sign `%` matches any string of 0 or more characters,\n- 'like': matches `field_name` against the `%field_value%` pattern. Similar to `=like` but wraps `field_value` with '%' before matching,\n- 'not like': doesn't match against the `%field_value%` pattern,\n- 'ilike': case insensitive `like`,\n- '=ilike': case insensitive `=like`,\n- 'in': is equal to any of the items from the `field_value`, where `field_value` is a list of items,\n- 'not in': is unequal to all the items from `field_value`,\n- 'child_of': is a child of a `field_value` record, the `field_value` can either be one item or a list of items. Takes the semantics of the model into account (i.e following the relationship field named by \\_parent_name),\n- 'parent_or': the is a parent of a `field_value` record, the `field_value` can either be one item or a list of items. Takes the semantics of the model into account (i.e following the relationship field named by \\_parent_name),\n- 'any': matches if any record in the relationship traversal through `field_name` (Many2one, One2many, or Many2many) satisfies the provided domain value,\n- 'not any': matches if no record in the relationship traversal through `field_name` (Many2one, One2many, or Many2many) satisfies the provided domain value.\n\n#### Combining domains\n\nSimple domains can be combined using boolean operators:\n\n- '&': logical AND, used as `[ "&", domain1, domain2]`, ensures that `domain1` and `domain2` are true at the same time,\n- '|': logical OR, used as `["|", domain1, domain2]`, ensures that at least one of `domain1` or `domain2` is true,\n- '!': logical NOT, used as `["!", domain1]`, ensures that `domain1` is false. Applies to the next domain ONLY.\n\nCONSTRAINTS:\n- You MUST NOT have more than one operator in a row.\n\n## Fields format\n\nThe fields you provide for filtering must be in JSON array format, each element of the array is a string retrieved from a `get_fields` tool call.\n\n## Tool usage\n\n**read_group**\n\n- When using read_group, you MUST ensure that fields use in the `order` parameter exits. DO NOT make up any field name. i.e. For an aggregate `amount_total:sum`, the valid order is `amount_total:sum`.\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
\.


--
-- Data for Name: ai_topic_ir_act_server_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ai_topic_ir_act_server_rel (ai_topic_id, ir_act_server_id) FROM stdin;
1	163
1	164
1	165
1	166
1	167
1	168
1	169
1	170
2	164
2	171
2	172
\.


--
-- Data for Name: auth_passkey_key; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_passkey_key (id, sign_count, create_uid, write_uid, name, credential_identifier, create_date, write_date, public_key) FROM stdin;
\.


--
-- Data for Name: auth_passkey_key_create; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_passkey_key_create (id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_device; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_device (id, name, user_id, scope, expiration_date, index, key, create_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_rate_limit_log; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_rate_limit_log (id, user_id, create_uid, write_uid, ip, limit_type, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: auth_totp_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.auth_totp_wizard (id, user_id, create_uid, write_uid, secret, url, create_date, write_date, qrcode) FROM stdin;
\.


--
-- Data for Name: base_document_layout; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_document_layout (id, company_id, report_layout_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_enable_profiling_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_enable_profiling_wizard (id, create_uid, write_uid, duration, expiration, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_import (id, create_uid, write_uid, res_model, file_name, file_type, create_date, write_date, file) FROM stdin;
\.


--
-- Data for Name: base_import_mapping; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_mapping (id, create_uid, write_uid, res_model, column_name, field_name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_import_module; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_import_module (id, create_uid, write_uid, state, import_message, modules_dependencies, force, with_demo, create_date, write_date, module_file) FROM stdin;
\.


--
-- Data for Name: base_language_export; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_export (id, model_id, create_uid, write_uid, name, lang, format, export_type, domain, state, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_import; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_import (id, create_uid, write_uid, name, code, filename, overwrite, create_date, write_date, data) FROM stdin;
\.


--
-- Data for Name: base_language_install; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_language_install (id, create_uid, write_uid, overwrite, create_date, write_date) FROM stdin;
1	1	1	t	2026-02-19 14:17:50.439579	2026-02-19 14:17:50.439579
2	1	1	t	2026-02-19 14:17:50.439579	2026-02-19 14:17:50.439579
\.


--
-- Data for Name: base_module_install_request; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_request (id, module_id, user_id, create_uid, write_uid, body_html, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_install_review; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_install_review (id, module_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall (id, create_uid, write_uid, show_all, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_uninstall_ir_module_module_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_uninstall_ir_module_module_rel (base_module_uninstall_id, ir_module_module_id) FROM stdin;
\.


--
-- Data for Name: base_module_update; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_update (id, updated, added, create_uid, write_uid, state, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_module_upgrade; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_module_upgrade (id, create_uid, write_uid, module_info, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard (id, number_group, current_line_id, dst_partner_id, maximum_group, create_uid, write_uid, state, group_by_email, group_by_name, group_by_is_company, group_by_vat, group_by_parent_id, exclude_contact, exclude_journal_item, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_automatic_wizard_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_automatic_wizard_res_partner_rel (base_partner_merge_automatic_wizard_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: base_partner_merge_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.base_partner_merge_line (id, wizard_id, min_id, create_uid, write_uid, aggr_ids, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: bus_bus; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.bus_bus (id, create_uid, write_uid, channel, message, create_date, write_date) FROM stdin;
1	1	1	["49387-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"res.users":[{"id":1,"notification_type":"inbox"}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
2	1	1	["49387-19-0-all-without-test","res.partner",3]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"avatar_cache_key":"dfad9a04659801a2859bdb50177f08a951f608f3750fa74b38b70fc72e90981b1b0c5bb4c3232136809f644c85c2612b96a83343332fd094e483b0865eacb98f","channel_type":"channel","create_uid":1,"default_display_mode":false,"description":"General channel for administrators.","from_message_id":false,"group_ids":[4],"group_public_id":4,"id":2,"invited_member_ids":[["ADD",[]]],"last_interest_dt":"2026-02-19 14:17:56","member_count":1,"name":"Administrators","parent_channel_id":false,"rtc_session_ids":[["ADD",[]]],"uuid":"ACqN9PeBCB"}],"discuss.channel.member":[{"channel_id":{"id":2,"model":"discuss.channel"},"id":1,"partner_id":3,"unpin_dt":false}],"res.groups":[{"full_name":"Role / Administrator","id":4}],"res.partner":[{"active":true,"avatar_128_access_token":"e06bf55d112ae986080134053b250961c573ecdcca4c385669e4cd38a1b79fa2o0x69be0c78","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"8d3f4bf0838b36ac7b917bdb6b5dfc9fdd1a0cd709c44a0341f2dfa8eb21abe1o0x69bd8189","is_company":false,"main_user_id":2,"mention_token":"bcf7e244efb974ad6acc36b35f02e52cc44dc7a953bd9048ff6171ca316497e8o0x69b8d525","name":"Mitchell Admin","write_date":"2026-02-19 14:17:56"}],"res.users":[{"id":2,"share":false}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
3	1	1	["49387-19-0-all-without-test","discuss.channel",1]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"group_ids":[1],"id":1}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
4	1	1	["49387-19-0-all-without-test","res.partner",6]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"avatar_cache_key":"057d4ac3e29303cc0c069422e56f8d37b46bca1d893be34c422cd9652e907a0671c6946b662f746c6cf2c85023a98c4b2b280dcc12cc2b5b8b33586f3557ea96","channel_type":"channel","create_uid":1,"default_display_mode":false,"description":"General announcements for all employees.","from_message_id":false,"group_ids":[1],"group_public_id":1,"id":1,"invited_member_ids":[["ADD",[]]],"last_interest_dt":"2026-02-19 14:17:56","member_count":2,"name":"general","parent_channel_id":false,"rtc_session_ids":[["ADD",[]]],"uuid":"IYPZEvvy6u"}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"id":3,"partner_id":6,"unpin_dt":false}],"res.groups":[{"full_name":"Role / User","id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"4cfec6e05b98d7836d75d310f4c0d1c848e2ab1ae4522986c62bd787b873598ao0x69be0fee","email":"mark.brown23@example.com","id":6,"im_status":"offline","im_status_access_token":"6ef65e6c3f3d3f8b440070363f7c09cebfa045d561070c4f23abcb6fee37af93o0x69bd84c8","is_company":false,"main_user_id":5,"mention_token":"9d3ad76f6e5b822efb38d2a4df87472b51e9a274d05ee0c0a5026ab509b1ecd5o0x69b8d6e0","name":"Marc Demo","write_date":"2026-02-19 14:17:56"}],"res.users":[{"id":5,"share":false}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
5	1	1	["49387-19-0-all-without-test","res.groups",1]	{"type":"mail.record/insert","payload":{"mail.canned.response":[{"id":1,"source":"hello","substitution":"Hello, how may I help you?"}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
6	1	1	["49387-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
7	1	1	["49387-19-0-all-without-test","res.partner",3]	{"type":"mail.activity/updated","payload":{"activity_created":true,"count_diff":1}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
8	1	1	["49387-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-02-19 14:17:56","fetched_message_id":1,"id":2,"last_seen_dt":false,"partner_id":3,"seen_message_id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"e06bf55d112ae986080134053b250961c573ecdcca4c385669e4cd38a1b79fa2o0x69be0c78","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"8d3f4bf0838b36ac7b917bdb6b5dfc9fdd1a0cd709c44a0341f2dfa8eb21abe1o0x69bd8189","is_company":false,"main_user_id":2,"mention_token":"bcf7e244efb974ad6acc36b35f02e52cc44dc7a953bd9048ff6171ca316497e8o0x69b8d525","name":"Mitchell Admin","write_date":"2026-02-19 14:17:56"}],"res.users":[{"id":2,"share":false}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
9	1	1	["49387-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-02-19 14:17:56","fetched_message_id":1,"id":2,"last_seen_dt":false,"partner_id":3,"seen_message_id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"e06bf55d112ae986080134053b250961c573ecdcca4c385669e4cd38a1b79fa2o0x69be0c78","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"8d3f4bf0838b36ac7b917bdb6b5dfc9fdd1a0cd709c44a0341f2dfa8eb21abe1o0x69bd8189","is_company":false,"main_user_id":2,"mention_token":"bcf7e244efb974ad6acc36b35f02e52cc44dc7a953bd9048ff6171ca316497e8o0x69b8d525","name":"Mitchell Admin","write_date":"2026-02-19 14:17:56"}],"res.users":[{"id":2,"share":false}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
10	1	1	["49387-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-02-19 14:17:56","fetched_message_id":false,"id":3,"last_seen_dt":false,"partner_id":6,"seen_message_id":false}],"res.partner":[{"active":true,"avatar_128_access_token":"4cfec6e05b98d7836d75d310f4c0d1c848e2ab1ae4522986c62bd787b873598ao0x69be0fee","email":"mark.brown23@example.com","id":6,"im_status":"offline","im_status_access_token":"6ef65e6c3f3d3f8b440070363f7c09cebfa045d561070c4f23abcb6fee37af93o0x69bd84c8","is_company":false,"main_user_id":5,"mention_token":"9d3ad76f6e5b822efb38d2a4df87472b51e9a274d05ee0c0a5026ab509b1ecd5o0x69b8d6e0","name":"Marc Demo","write_date":"2026-02-19 14:17:56"}],"res.users":[{"id":5,"share":false}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
11	1	1	["49387-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-02-19 14:17:56","fetched_message_id":1,"id":2,"last_seen_dt":false,"partner_id":3,"seen_message_id":1}],"res.partner":[{"active":true,"avatar_128_access_token":"e06bf55d112ae986080134053b250961c573ecdcca4c385669e4cd38a1b79fa2o0x69be0c78","email":"admin@example.com","id":3,"im_status":"offline","im_status_access_token":"8d3f4bf0838b36ac7b917bdb6b5dfc9fdd1a0cd709c44a0341f2dfa8eb21abe1o0x69bd8189","is_company":false,"main_user_id":2,"mention_token":"bcf7e244efb974ad6acc36b35f02e52cc44dc7a953bd9048ff6171ca316497e8o0x69b8d525","name":"Mitchell Admin","write_date":"2026-02-19 14:17:56"}],"res.users":[{"id":2,"share":false}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
12	1	1	["49387-19-0-all-without-test","res.partner",2]	{"type":"mail.record/insert","payload":{"discuss.channel":[{"id":1,"member_count":2}],"discuss.channel.member":[{"channel_id":{"id":1,"model":"discuss.channel"},"create_date":"2026-02-19 14:17:56","fetched_message_id":false,"id":3,"last_seen_dt":false,"partner_id":6,"seen_message_id":false}],"res.partner":[{"active":true,"avatar_128_access_token":"4cfec6e05b98d7836d75d310f4c0d1c848e2ab1ae4522986c62bd787b873598ao0x69be0fee","email":"mark.brown23@example.com","id":6,"im_status":"offline","im_status_access_token":"6ef65e6c3f3d3f8b440070363f7c09cebfa045d561070c4f23abcb6fee37af93o0x69bd84c8","is_company":false,"main_user_id":5,"mention_token":"9d3ad76f6e5b822efb38d2a4df87472b51e9a274d05ee0c0a5026ab509b1ecd5o0x69b8d6e0","name":"Marc Demo","write_date":"2026-02-19 14:17:56"}],"res.users":[{"id":5,"share":false}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
13	1	1	["49387-19-0-all-without-test","res.groups",1]	{"type":"mail.record/insert","payload":{"mail.canned.response":[{"id":2,"source":"bye","substitution":"Thanks for your feedback. Goodbye!"}]}}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
\.


--
-- Data for Name: change_password_own; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_own (id, create_uid, write_uid, new_password, confirm_password, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_user; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_user (id, wizard_id, user_id, create_uid, write_uid, user_login, new_passwd, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: change_password_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.change_password_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: decimal_precision; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.decimal_precision (id, digits, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: discuss_call_history; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_call_history (id, channel_id, start_call_message_id, create_uid, write_uid, start_dt, end_dt, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: discuss_channel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel (id, parent_channel_id, from_message_id, group_public_id, create_uid, write_uid, name, channel_type, default_display_mode, sfu_channel_uuid, sfu_server_url, uuid, description, active, last_interest_dt, create_date, write_date, ai_agent_id, ai_env_context) FROM stdin;
2	\N	\N	4	1	1	Administrators	channel	\N	\N	\N	ACqN9PeBCB	General channel for administrators.	t	2026-02-19 14:17:56	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
1	\N	\N	1	1	1	general	channel	\N	\N	\N	IYPZEvvy6u	General announcements for all employees.	t	2026-02-19 14:17:56	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
9	\N	\N	\N	1	1	Public Community	channel	\N	\N	\N	BwKtztXp8X	A space for engaging discussions among employees, partners, and the public.	t	2026-02-19 14:17:57	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
3	\N	\N	1	1	1	sales	channel	\N	\N	\N	YHfWEcbJwA	Discussion about best sales practices and deals.	t	2026-02-19 14:17:57	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
4	\N	\N	1	1	1	board-meetings	channel	\N	\N	\N	7LzJBJrGVk	Board meetings, budgets, strategic plans	t	2026-02-19 14:17:57	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
5	\N	\N	1	1	1	rd	channel	\N	\N	\N	3Qp5GTj6rm	Research and development discussion group	t	2026-02-19 14:17:57	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
6	1	1	1	1	1	Welcome to the #general channel	channel	\N	\N	\N	3byyocSBRh	\N	t	2026-02-19 14:17:57	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
7	1	\N	1	1	1	Ideas & Suggestions	channel	\N	\N	\N	otaxbwjWkM	\N	t	2026-02-19 14:17:57	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
8	1	\N	1	1	1	Troubleshooting	channel	\N	\N	\N	QYDZARscrB	\N	t	2026-02-19 14:17:57	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
\.


--
-- Data for Name: discuss_channel_member; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_member (id, partner_id, guest_id, channel_id, fetched_message_id, seen_message_id, new_message_separator, rtc_inviting_session_id, create_uid, write_uid, custom_channel_name, custom_notifications, mute_until_dt, unpin_dt, last_interest_dt, last_seen_dt, create_date, write_date) FROM stdin;
3	6	\N	1	\N	\N	0	\N	1	1	\N	\N	\N	\N	2026-02-19 14:17:56	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
6	6	\N	7	\N	\N	0	\N	1	1	\N	\N	\N	\N	2026-02-19 14:17:57	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
8	6	\N	8	30	30	31	\N	1	1	\N	\N	\N	\N	2026-02-19 14:17:57	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
9	3	\N	9	31	31	32	\N	1	1	\N	\N	\N	\N	2026-02-19 14:17:57	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
10	6	\N	9	33	33	34	\N	1	1	\N	\N	\N	\N	2026-02-19 14:17:57	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
11	\N	1	9	32	32	33	\N	1	1	\N	\N	\N	\N	2026-02-19 14:17:57	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
\.


--
-- Data for Name: discuss_channel_res_groups_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_res_groups_rel (discuss_channel_id, res_groups_id) FROM stdin;
2	4
1	1
\.


--
-- Data for Name: discuss_channel_rtc_session; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_channel_rtc_session (id, channel_member_id, channel_id, partner_id, create_uid, write_uid, is_screen_sharing_on, is_camera_on, is_muted, is_deaf, write_date, create_date) FROM stdin;
\.


--
-- Data for Name: discuss_gif_favorite; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_gif_favorite (id, create_uid, write_uid, tenor_gif_id, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: discuss_voice_metadata; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.discuss_voice_metadata (id, attachment_id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: email_template_attachment_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.email_template_attachment_rel (email_template_id, attachment_id) FROM stdin;
\.


--
-- Data for Name: fetchmail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.fetchmail_server (id, port, object_id, priority, create_uid, write_uid, name, state, server, server_type, "user", password, script, error_message, configuration, active, is_ssl, attach, original, date, error_date, create_date, write_date, google_gmail_access_token_expiration, google_gmail_refresh_token, google_gmail_access_token, microsoft_outlook_access_token_expiration, microsoft_outlook_refresh_token, microsoft_outlook_access_token) FROM stdin;
\.


--
-- Data for Name: html_editor_converter_test; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.html_editor_converter_test (id, "integer", many2one, create_uid, write_uid, "char", selection_str, date, html, text, "numeric", datetime, create_date, write_date, "float", "binary") FROM stdin;
\.


--
-- Data for Name: html_editor_converter_test_sub; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.html_editor_converter_test_sub (id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: iap_account; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account (id, service_id, create_uid, write_uid, name, account_token, balance, state, service_locked, create_date, write_date, warning_threshold, sender_name) FROM stdin;
\.


--
-- Data for Name: iap_account_res_company_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_company_rel (iap_account_id, res_company_id) FROM stdin;
\.


--
-- Data for Name: iap_account_res_users_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_account_res_users_rel (iap_account_id, res_users_id) FROM stdin;
\.


--
-- Data for Name: iap_service; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.iap_service (id, create_uid, write_uid, name, technical_name, description, unit_name, integer_balance, create_date, write_date) FROM stdin;
1	1	1	Lead Generation	reveal	{"en_US": "Get quality leads and opportunities: convert your website visitors into leads, generate leads based on a set of criteria and enrich the company data of your opportunities.", "es_419": "Obtenga leads y oportunidades de calidad: convierta a los visitantes de su sitio web en leads, genere leads basándose en un conjunto de criterios y enriquezca los datos de la empresa de sus oportunidades."}	{"en_US": "Credits", "es_419": "Créditos"}	t	2026-02-19 14:17:56.17534	2026-02-19 14:17:56.17534
2	1	1	Document Digitization	invoice_ocr	{"en_US": "Digitize your scanned or PDF vendor bills, expenses and resumes with OCR and Artificial Intelligence.", "es_419": "Digitalice sus facturas de proveedores, gastos y CV escaneados o en PDF con OCR e Inteligencia Artificial"}	{"en_US": "Documents", "es_419": "Documentos"}	t	2026-02-19 14:18:00.368862	2026-02-19 14:18:00.368862
3	1	1	Partner Autocomplete	partner_autocomplete	{"en_US": "Automatically enrich your contact base with corporate data.", "es_419": "Enriquezca su base de contactos de forma automática con datos empresariales."}	{"en_US": "Enrichments", "es_419": "Enriquecimientos"}	t	2026-02-19 14:18:00.547635	2026-02-19 14:18:00.547635
4	1	1	SMS	sms	{"en_US": "Send SMS to your contacts directly from your database.", "es_419": "Envíe mensajes SMS a sus contactos directo desde su base de datos."}	{"en_US": "Credits", "es_419": "Créditos"}	f	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
5	1	1	Snail Mail	snailmail	{"en_US": "Send your customer invoices and follow-up reports by post, worldwide.", "es_419": "Envíe sus facturas y reportes de seguimiento por correo postal a todo el mundo."}	{"en_US": "Stamps", "es_419": "Sellos"}	t	2026-02-19 14:18:01.593522	2026-02-19 14:18:01.593522
\.


--
-- Data for Name: ir_act_client; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_client (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, tag, target, res_model, context, params_store) FROM stdin;
3	\N	1	1	ir.actions.client	\N	action	list,form	{"en_US": "Open Settings Menu", "es_419": "Abrir el menú de ajustes"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	reload	current	\N	{}	\\x7b276d656e755f6964273a20317d
109	\N	1	1	ir.actions.client	discuss	action	list,form	{"en_US": "Discuss", "es_419": "Conversaciones"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	mail.action_discuss	current	\N	{}	\\x7b202764656661756c745f6163746976655f6964273a20276d61696c2e626f785f696e626f7827207d
125	\N	1	1	ir.actions.client	\N	action	list,form	{"en_US": "Notifications", "es_419": "Notificaciones"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	mail.discuss_notification_settings_action	new	\N	{"dialog_size": "medium", "footer": false}	\N
126	\N	1	1	ir.actions.client	\N	action	list,form	{"en_US": "Voice & Video Settings", "es_419": "Ajustes de voz y video"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	mail.discuss_call_settings_action	new	\N	{'dialog_size': 'medium', 'footer': false}	\N
\.


--
-- Data for Name: ir_act_report_xml; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_report_xml (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, paperformat_id, model, report_type, report_name, report_file, attachment, domain, print_report_name, multi, attachment_use) FROM stdin;
37	3	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Model Overview", "es_419": "Resumen del modelo"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	ir.model	qweb-pdf	base.report_irmodeloverview	base.report_irmodeloverview	\N	\N	\N	\N	\N
42	69	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Technical guide", "es_419": "Guía técnica"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	ir.module.module	qweb-pdf	base.report_irmodulereference	base.report_irmodulereference	\N	\N	\N	\N	\N
79	98	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Preview External Report", "es_419": "Vista previa del reporte externo"}	\N	2026-02-19 14:17:52.907935	2026-02-19 14:17:52.907935	\N	res.company	qweb-pdf	web.preview_externalreport	web.preview_externalreport	\N	\N	\N	\N	\N
78	98	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Preview Internal Report", "es_419": "Vista previa del reporte interno"}	\N	2026-02-19 14:17:52.907935	2026-02-19 14:17:52.907935	\N	res.company	qweb-pdf	web.preview_internalreport	web.preview_internalreport	\N	\N	\N	\N	\N
80	98	1	1	ir.actions.report	\N	report	list,form	{"en_US": "Report Layout Preview", "es_419": "Vista previa del diseño del reporte"}	\N	2026-02-19 14:17:52.907935	2026-02-19 14:17:52.907935	\N	res.company	qweb-pdf	web.preview_layout_report	web.preview_layout_report	\N	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, sequence, model_id, parent_id, crud_model_id, link_field_id, update_field_id, update_related_model_id, sequence_id, selection_value, automated_name, usage, state, update_path, update_m2m_operation, update_boolean_value, evaluation_type, resource_ref, webhook_url, code, value, html_value, activity_user_id, activity_type_id, template_id, activity_date_deadline_range, activity_summary, followers_type, followers_partner_field_name, mail_post_method, activity_date_deadline_range_type, activity_user_type, activity_user_field_name, activity_note, mail_post_autofollow, sms_template_id, sms_method, ai_tool_description, ai_action_prompt, ai_tool_schema, use_in_ai, ai_tool_allow_end_message, ai_update_prompt) FROM stdin;
35	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Base: Auto-vacuum internal data", "es_419": "Base: limpieza automática de datos internos"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:18:00.812257	5	41	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._run_vacuum_cleaner()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
36	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Base: Portal Users Deletion", "es_419": "Base: eliminación de usuarios del portal"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:18:00.812257	5	111	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._gc_portal_users(batch_size=50)	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
13	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Config: Run Remaining Action Todo", "es_419": "Configuración: ejecutar las acciones pendientes"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:18:00.812257	5	94	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
51	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Failed to install demo data for some modules, demo disabled", "es_419": "Error al instalar datos de demostración para algunos módulos, la demostración está deshabilitada"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:18:00.812257	5	74	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
82	90	1	1	ir.actions.server	\N	action	form,list,kanban	{"en_US": "Download (vCard)", "es_419": "Descargar (vCard)"}	\N	2026-02-19 14:17:52.907935	2026-02-19 14:18:00.812257	5	90	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            action = {\n                'type': 'ir.actions.act_url',\n                'url': '/web/partner/vcard?partner_ids=' + ','.join(map(str, records.ids)),\n                'target': 'download',\n            }\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
83	102	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Disable two-factor authentication", "es_419": "Deshabilitar la autenticación de dos factores"}	\N	2026-02-19 14:17:53.952449	2026-02-19 14:18:00.812257	5	102	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            action = records.action_totp_disable()\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
87	139	1	1	ir.actions.server	\N	action	form	{"en_US": "Export JS", "es_419": "Exportar JS"}	\N	2026-02-19 14:17:55.456461	2026-02-19 14:18:00.812257	5	139	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\nif records:\n    action = records.export_js_file()\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
124	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Discuss: channel member unmute", "es_419": "Conversaciones: activar el sonido de un miembro del canal"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:18:00.812257	5	210	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._cleanup_expired_mutes()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
117	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Mail: Email Queue Manager", "es_419": "Correo: Administrador de tareas del correo electrónico"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:18:00.812257	5	180	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model.process_email_queue(batch_size=1000)	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
120	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Mail: Fetchmail Service", "es_419": "Correo: servicio de Fetchmail"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:18:00.812257	5	164	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._fetch_mails()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
121	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Mail: Post scheduled messages", "es_419": "Correo: Publicar los mensajes programados"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:18:00.812257	5	184	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._post_messages_cron()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
123	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Mail: send web push notification", "es_419": "Correo: enviar notificaciones push en web"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:18:00.812257	5	182	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._push_notification_to_endpoint()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
119	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Notification: Delete Notifications older than 6 Months", "es_419": "Notificación: Eliminar notificaciones con más de 6 meses de antigüedad"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:18:00.812257	5	165	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._gc_notifications(max_age_days=180)	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
122	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Notification: Notify scheduled messages", "es_419": "Notificación: notificar acerca de los mensajes programados"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:18:00.812257	5	176	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._send_notifications_cron()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
118	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Publisher: Update Notification", "es_419": "Editor: notificación de actualización"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:18:00.812257	5	208	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model.update_notification(None)	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
139	102	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Send Password Reset Instructions", "es_419": "Enviar instrucciones para restablecer la contraseña"}	\N	2026-02-19 14:17:58.885671	2026-02-19 14:18:00.812257	5	102	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	records.action_reset_password()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
138	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Users: Notify About Unregistered Users", "es_419": "Usuarios: notificar sobre usuarios no registrados"}	\N	2026-02-19 14:17:58.885671	2026-02-19 14:18:00.812257	5	102	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model.send_unregistered_user_reminder(batch_size=100)	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
140	102	1	1	ir.actions.server	\N	action	list,kanban	{"en_US": "Invite to use two-factor authentication", "es_419": "Invitar a usar la autenticación de dos factores"}	\N	2026-02-19 14:17:59.096548	2026-02-19 14:18:00.812257	5	102	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            action = records.action_totp_invite()\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
141	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Open two-factor authentication configuration", "es_419": "Abrir la configuración de la autenticación de dos factores"}	\N	2026-02-19 14:17:59.096548	2026-02-19 14:18:00.812257	5	102	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\nuser = env.user\naction = user.action_open_my_account_settings()\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
150	366	1	1	ir.actions.server	\N	action	list,kanban	{"en_US": "Archive Selection", "es_419": "Selección de archivo"}	\N	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.812257	5	366	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\nrecords.action_archive_all()\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
151	366	1	1	ir.actions.server	\N	action	list,kanban	{"en_US": "Delete Selection", "es_419": "Eliminar selección"}	\N	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.812257	5	366	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\nrecords.action_unlink_all()\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
146	90	1	1	ir.actions.server	\N	action	form	{"en_US": "Privacy Lookup", "es_419": "Búsqueda de privacidad"}	\N	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.812257	5	90	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\naction = record.action_privacy_lookup()\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
147	102	1	1	ir.actions.server	\N	action	form	{"en_US": "Privacy Lookup", "es_419": "Búsqueda de privacidad"}	\N	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.812257	5	102	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\naction = record.partner_id.action_privacy_lookup()\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
159	372	1	1	ir.actions.server	\N	action	list,kanban	{"en_US": "Resend", "es_419": "Reenviar"}	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257	5	372	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	action = records.resend_failed()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
152	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "SMS: SMS Queue Manager", "es_419": "SMS: administrador de la cola de SMS"}	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257	5	372	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._process_queue()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
161	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "Snailmail: process letters queue", "es_419": "Correo postal: procesar cartas en la cola"}	\N	2026-02-19 14:18:01.593522	2026-02-19 14:18:01.593522	5	381	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._snailmail_cron()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
164	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Get Fields", "es_419": "IA: Obtener campos"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_get_fields(model_name, include_description)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            Lists ONLY searchable fields for a single model that can be used in domain filters and grouping.\\n            Essential for building valid domains - if a field isn't listed here, it CANNOT be used.\\n\\n            Returns format:\\n            ```\\n            field_name|display_name|type|sortable|groupable|description\\n            partner_id|Customer|many2one(res.partner)|true|true|Customer for this order\\n            date_order|Order Date|datetime|true|true|Date when order was placed\\n            order_line|Order Lines|one2many(sale.order.line)|false|false|Lines in this order\\n            state|Status|selection|true|true|Order status\\n            ```\\n\\n            Key points:\\n            - ⚠️ Only returns SEARCHABLE fields - others cannot be used in domains\\n            - For relationships: Shows related model in parentheses (many2one, one2many, many2many)\\n            - Only relationship fields can be used to traverse to other models\\n            - Literal fields such as char/text/float CANNOT be used for traversal\\n            - 'sortable' indicates if field can be used in order_by parameter\\n            - 'groupable' indicates if field can be used for grouping when not available in search view\\n\\n            💡 Performance tip: When exploring multiple models, call this tool multiple times in ONE message\\n            Example: Exploring sale.order, product.product, and res.partner? Make 3 parallel calls.\\n        ", "es_419": "\\n            Muestra SOLO los campos que se pueden buscar para un modelo único que se pueden usar en filtros de dominio y agrupamiento.\\n            Es esencial para crear dominios válidos. Si un campo no aparece aquí, NO se puede usar.\\n\\n            Formato de devoluciones:\\n            ```\\n            field_name|display_name|type|sortable|groupable|descripción\\n            partner_id|Cliente|many2one(res.partner)|true|true|Cliente de esta orden\\n            date_order|Fecha de la orden|datetime|true|true|Fecha en la que se realizó la orden\\n            order_line|Líneas de la orden|one2many(sale.order.line)|false|false|Líneas en esta orden\\n            state|Estado|selection|true|true|Estado de la orden\\n            ```\\n\\n            Puntos importantes:\\n            - ⚠️ Solo muestra campos QUE SE PUEDAN BUSCAR, otros no se pueden usar en dominios\\n            - Para relaciones: Muestra modelos relacionados en paréntesis (many2one, one2many, many2many).\\n            - Solo se pueden usar los campos de relación para relacionar con otros modelos\\n            - Los campos literales como char/text/float NO se pueden usar para esta relación\\n            - 'sortable' indica si un campo se puede usar en el parámetro order_by\\n            - 'groupable' indica si un campo se puede usar para agrupar cuando no está disponible en la vista de búsqueda\\n\\n            💡 Consejo de rendimiento: Al explorar diferentes modelos, llama a esta herramienta varias veces en UN mensaje\\n            Por ejemplo: ¿Estás explorando sale.order, product.product y res.parter? Haz 3 llamadas en paralelo.\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "model_name": {\n                    "type": "string",\n                    "description": "Technical model name (e.g., 'sale.order', 'product.product', 'res.partner')"\n                },\n                "include_description": {\n                    "type": "boolean",\n                    "description": "Include field help text in output (default: true)"\n                }\n            },\n            "required": ["model_name"]\n        }\n        	t	\N	\N
173	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI Embedding: Generate Embeddings", "es_419": "Incrustaciones de IA: Generar incrustaciones"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	385	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._cron_generate_embedding()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
174	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI Agent Sources: Process Sources", "es_419": "Fuentes del agente de IA: Procesar fuentes"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	384	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._cron_process_sources()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
170	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Adjust Search", "es_419": "IA: Ajustar búsqueda"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_adjust_search(model_name, remove_facets, toggle_filters, toggle_groupbys, apply_searches, measures, mode, order, stacked, cumulated, custom_domain, switch_view_type)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            The user can continue on asking questions and if you think that the current search can just be adjusted without opening a different menu, you can use this tool.\\n\\n            Provided in the prompt's <session_info_context> is a current view info which contains the active search facets.\\n            A facet can be a group of `OR`ed filters, a group of groupbys, or a group of `OR`ed search terms.\\n\\n            **Understanding the parameters**:\\n            - `remove_facets` - Removing a facet removes the whole group of filters/groupbys/search terms. Removing a filter or a search facet reduces the constraints.\\n            - `toggle_filters` - Toggling a filter will add/remove a filter from an active filter facet.\\n            - `toggle_groupbys` - Toggling a groupby will add/remove a groupby from the active groupbys facet.\\n            - `apply_searches` - Applying a search will `OR` the search term on an active search facet containing the same field. E.g., if there is a field facet of \\"name=John\\" and you provide search \\"name=Jane\\", the resulting search will be \\"name=John OR name=Jane\\".\\n            - `measures` - Specifying measures will activate the selected measures in the current view if it's a pivot or a graph view.\\n            - `mode` - Graph view only: This is the chart type. Choose from \\"line\\", \\"bar\\", or \\"pie\\" to change the chart type in the current graph view.\\n            - `order` - Graph view only: Specifying the order will change the sorting of the results in the current graph view.\\n            - `stacked` - Graph view only: Specifying stacked will change the stacking of the results in the current graph view.\\n            - `cumulated` - Graph view only: Specifying cumulated will change the accumulation of the results in the current graph view.\\n            - `custom_domain` - The search view elements may not be sufficient to express the needed domain. In that case, you can provide a custom domain as a JSON string.\\n            - `switch_view_type` - Switching the view type will change the current view to the specified type. Select from the available view types in the current view info.\\n        ", "es_419": "\\n            El usuario puede seguir haciendo preguntas y, si consideras que la búsqueda actual solo necesita ajustes sin abrir otro menú, puedes usar esta herramienta.\\n\\n            En la parte de <session_info_context> de la instrucción hay información de la vista actual y contiene las facetas de búsqueda activas.\\n            Una faceta puede ser un grupo de filtros combinados con `OR`(O), un grupo de agrupaciones (groupbys) o un grupo de términos de búsqueda combinados con `OR.\\n\\n            **Comprendiendo los parámetros:**:\\n            - `remove_facets` - Eliminar una faceta elimina todo el grupo de filtros, agrupaciones o términos de búsqueda. Eliminar un filtro o faceta reduce las restricciones.\\n            - `toggle_filters` - Habilitar o deshabilitar un filtro lo agrega o elimina de una faceta de filtros activa.\\n            - `toggle_groupbys` - Habilitar o deshabilitar una agrupación la agrega o elimina de la faceta de agrupaciones activa.\\n            - `apply_searches` - Aplicar una búsqueda combina el término con `OR` en una faceta de búsqueda activa del mismo campo. Por ejemplo, si hay una faceta de campo \\"name=Juan\\" y proporcionas \\"name=Jimena\\", la búsqueda resultante será \\"name=Juan OR name=Jimena\\".\\n            - `measures` - Especificar medidas activa las seleccionadas en la vista actual si es de tabla dinámica o de gráfico.\\n            - `mode` - Solo en la vista de gráfico: Este es el tipo de gráfico. Elige entre líneas, barras o circular para cambiar el tipo de gráfico en la vista actual.\\n            - `order` - Solo en la vista de gráfico: Especificar el orden cambia la clasificación de los resultados en la vista actual.\\n            - `stacked` - Solo en la vista de gráfico: Especificar esto cambiará el apilamiento de los resultados en la vista actual.\\n            - `cumulated` - Solo en la vista de gráfico: Especificar esto cambiará la acumulación de los resultados en la vista actual.\\n            - `custom_domain` - Si los elementos de la vista de búsqueda no son suficientes para expresar el dominio necesario puedes proporcionar un dominio personalizado como cadena JSON.\\n            - `switch_view_type` - Cambiar el tipo de vista cambia la vista actual al tipo especificado. Elige entre los tipos de vista disponibles en la información de la vista actual.\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "model_name": {\n                    "type": "string",\n                    "description": "The model linked to the current view."\n                },\n                "remove_facets": {\n                    "type": "array",\n                    "items": {"type": "number"},\n                    "description": "List of facet group IDs to be removed from the search view."\n                },\n                "toggle_filters": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Filter names from menu's available filters. See list from the searchable fields from the search view. Example: ['my_sale_orders', 'draft']. If a filter is already applied, it will be removed; otherwise, it will be added. Empty array [] for no filters. "\n                },\n                "toggle_groupbys": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Field names to add/remove from grouping. Priority: 1) Use group_by_field values from search view, 2) If needed field not in search view, use groupable fields from get_fields tool. Example: ['user_id', 'partner_id']. Empty array [] for no grouping changes."\n                },\n                "apply_searches": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Array of field=text strings for searching multiple fields. Each string uses format 'field_name=search_text' where field_name is from menu's searchable_fields. Examples: ['partner_id=Azure', 'product_id=laptop'], ['name=SO-001'], or [] for no search."\n                },\n                "measures": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "List of measures to be activated. Can be multiple items in pivot view but only one item in graph view."\n                },\n                "mode": {\n                    "type": "string",\n                    "description": "For graph view: Chart type: 'bar' for comparisons, 'line' for trends, 'pie' for proportions"\n                },\n                "order": {\n                    "type": "string",\n                    "description": "For graph view: Sort direction: 'DESC' for highest first, 'ASC' for lowest first"\n                },\n                "stacked": {\n                    "type": "boolean",\n                    "description": "For graph view: Stack bars/areas on top of each other (default: false)"\n                },\n                "cumulated": {\n                    "type": "boolean",\n                    "description": "For graph view: Show cumulative values over time (default: false)"\n                },\n                "custom_domain": {\n                    "type": "string",\n                    "description": "Optional custom domain as JSON string when search view elements are insufficient."\n                },\n                "switch_view_type": {\n                    "type": "string",\n                    "description": "The view type to switch to. Must be one of the available view types. Empty string for no switch."\n                },\n                "__end_message": {\n                    "type": "string",\n                    "description": "The message that will be shown to the user. Provide a short summary of what you wanted to adjust in the search view when calling this tool."\n                }\n            },\n            "required": ["model_name"]\n        }\n        	t	t	\N
169	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Compute Report Measures", "es_419": "IA: Calcular medidas del reporte"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_compute_report_measures(action_id, model_name)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            Lists numeric fields (measures) available for aggregation in pivot/graph views.\\n            MUST be called before using measures in open_menu_pivot() or open_menu_graph().\\n\\n            Returns CSV with pipe (|) delimiter:\\n            ```\\n            field_name|display_name|type|aggregator|sortable\\n            __count|Count|integer||true\\n            amount_total|Total|monetary|sum|true\\n            margin|Margin|float|sum|true\\n            quantity|Quantity|float|sum|true\\n            ```\\n\\n            Key points:\\n            - __count is always available (counts records)\\n            - Only numeric fields with aggregators are returned\\n            - Use field_name in measures parameter\\n            - For rankings in pivot: Add ordering (e.g., \\"amount_total desc\\")\\n            - Call multiple times in parallel if comparing different menus\\n        ", "es_419": "\\n            Enumera los campos numéricos (medidas) que puedes agregar a las vistas de tabla dinámica o de gráficos.\\n            DEBES llamarlo antes de usar medidas en open_menu_pivot() o open_menu_graph().\\n\\n            Devuelve un CSV con un delimitador de barra vertical (|):\\n            ```\\n            field_name|display_name|type|aggregator|sortable\\n            __count|Número|integer||true\\n            amount_total|Total|monetary|sum|true\\n            margin|Margen|float|sum|true\\n            quantity|Cantidad|float|sum|true\\n            ```\\n\\n            Puntos clave:\\n            - __count siempre está disponible (cuenta registros)\\n            - Solo se devuelven los campos numéricos con agregadores\\n            - Usa field_name en el parámetro de medidas\\n            - Para crear clasificaciones en una tabla dinámica: agrega el orden (ejemplo: \\"amount_total desc\\")\\n            - Llama varias veces de manera paralela si compararás menús distintos\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "action_id": {\n                    "type": "number",\n                    "description": "Action ID - the id of the action linked to a menu or available in the current view context."\n                },\n                "model_name": {\n                    "type": "string",\n                    "description": "Model name - must match the action's model"\n                }\n            },\n            "required": ["action_id", "model_name"]\n        }\n        	t	\N	\N
167	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Open Menu Pivot", "es_419": "IA: Abrir menú de la tabla dinámica"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_open_menu_pivot(menu_id, model_name, selected_filters, row_groupbys, col_groupbys, measures, search, custom_domain)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            Opens a pivot table with advanced search and filtering.\\n            Best for: \\"Top N\\" queries, rankings, cross-tabulation, performance metrics.\\n\\n            Key features:\\n            - Supports filters from search view\\n            - Groups data by rows AND columns simultaneously\\n            - Aggregates measures (sum, avg, count)\\n            - Supports text search across searchable fields\\n            - Excel-like pivot table functionality\\n\\n            💡 ALWAYS call compute_report_measures() first to get valid measures\\n            💡 For rankings: Include ordering in measures (e.g., [\\"amount_total desc\\"])\\n            💡 Use search parameter to filter by any searchable field BEFORE considering custom domains\\n            ⚠️ Prefer \\"Reporting\\" app menus for best pivot experience\\n            ⚠️ Each search string must use format 'field=text'. Array can contain multiple search strings or be empty []\\n            ⚠️ Note: Uses row_groupbys/col_groupbys (arrays) instead of selected_groupbys\\n\\n            Example: For \\"top salespeople selling office products\\":\\n            - Use search=[\\"categ_id\\", \\"office\\"] if categ_id is searchable\\n            - Only use custom_domain if no searchable field matches your needs\\n        ", "es_419": "\\n            Abre una tabla dinámica con búsqueda avanzada y filtrado.\\n            Ideal para: consultas \\"Mejores X\\", clasificaciones, tablas cruzadas y métricas de desempeño.\\n\\n            Funciones principales:\\n            - Permite usar filtros desde la vista de búsqueda\\n            - Agrupa datos por filas Y columnas de forma simultánea\\n            - Agrega medidas (suma, promedio, número)\\n            - Permite buscar texto en los campos que es posible utilizar esta función\\n            - Funcionalidad similar a tabla dinámica de Excel\\n\\n            💡 SIEMPRE llama primero a compute_report_measures() para obtener medidas válidas\\n            💡 Para clasificaciones: incluye el orden en las medidas (por ejemplo: [\\"amount_total desc\\"])\\n            💡 Usa el parámetro de búsqueda para filtrar por cualquier campo buscable ANTES de considerar dominios personalizados\\n            ⚠️ Prefiere los menús \\"Reportes\\" de las aplicaciones para que tengas una mejor experiencia con las tablas dinámicas\\n            ⚠️ Cada cadena de búsqueda debe usar el formato 'campo=valor'. El arreglo puede contener varias cadenas o estar vacío []\\n            ⚠️ Nota: Utiliza row_groupbys/col_groupbys (arreglos) en lugar de selected_groupbys\\n\\n            Por ejemplo, para \\"Mejores vendedores de productos de oficina\\":\\n            - Usa search=[\\"categ_id\\", \\"oficina\\"] si puedes buscar en categ_id\\n            - Solo usa un dominio_personalizado si no hay ningún campo en el que puedas buscar que coincida con tus necesidades\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "menu_id": {\n                    "type": "number",\n                    "description": "Menu ID from available menu data (prefer Reporting app menus)"\n                },\n                "model_name": {\n                    "type": "string",\n                    "description": "Model name - must match the menu's model"\n                },\n                "selected_filters": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Filter names from menu's available filters. Empty array [] for no filters."\n                },\n                "row_groupbys": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Row grouping fields. Priority: 1) Use group_by_field values from search view, 2) If needed field not in search view, use groupable fields from get_fields tool. Examples: ['product_id'] for products, ['user_id'] for salespeople"\n                },\n                "col_groupbys": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Column grouping fields. Priority: 1) Use group_by_field values from search view, 2) If needed field not in search view, use groupable fields from get_fields tool. Common: ['date:month'] for monthly, ['state'] for status, [] for no columns"\n                },\n                "measures": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Measures from _compute_report_measures(). For rankings add ordering: ['amount_total desc']"\n                },\n                "search": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Array of field=text strings for searching multiple fields. Each string uses format 'field_name=search_text' where field_name is from menu's searchable_fields. Examples: ['partner_id=Azure', 'product_id=laptop'], ['name=SO-001'], or [] for no search."\n                },\n                "custom_domain": {\n                    "type": "string",\n                    "description": "Optional custom domain as JSON string when search view elements are insufficient."\n                },\n                "__end_message": {\n                    "type": "string",\n                    "description": "The message that will be shown to the user. Provide a short summary of how this tool call answers the user's request."\n                }\n            },\n            "required": ["menu_id", "model_name", "selected_filters", "row_groupbys", "col_groupbys", "measures", "search"]\n        }\n        	t	t	\N
163	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Get Menu Details", "es_419": "IA: Obtener detalles del menú"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_get_menu_details(menu_ids)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            Retrieves detailed information (context, domain, search_view) for specific menus.\\n            MUST be called before using any open_menu_* tool to get menu-specific details.\\n\\n            Returns CSV with pipe (|) delimiter:\\n            ```\\n            menu_id|model_name|context|domain|search_view\\n            389|sale.order|{\\"search_default_my_quotation\\": 1}|[]|<search><fields>...</fields></search>\\n            172|account.move|{\\"search_default_draft\\": 1}|[[\\"type\\", \\"=\\", \\"out_invoice\\"]]|<search>...</search>\\n            ```\\n\\n            Key information:\\n            - Context: Default filters/groupings applied when menu opens\\n            - Domain: Permanent filters that cannot be removed by users\\n            - Search_view: Full XML structure with available filters, groupbys, and searchable fields\\n\\n            💡 Performance tip: Request multiple menu details in one call when comparing options\\n            ⚠️ Always validate the returned model matches your expectations\\n        ", "es_419": "\\n            Recupera información detallada (contexto, dominio, search_view) de menús específicos.\\n            DEBES llamarlo antes de usar cualquier herramienta de open_menu_* para obtener detalles específicos del menú.\\n\\n            Devuelve un CSV con un delimitador de barra vertical (|):\\n            ``` \\n            menu_id|model_name|context|domain|search_view\\n            389|sale.order|{\\"search_default_my_quotation\\": 1}|[]|<search><fields>...</fields></search>\\n            172|account.move|{\\"search_default_draft\\": 1}|[[\\"type\\", \\"=\\", \\"out_invoice\\"]]|<search>...</search>\\n            ```\\n\\n            Información clave:\\n            - Contexto: Filtros y grupos predeterminados aplicados al abrir el menú\\n            - Dominio: Filtros permanentes que los usuarios no pueden eliminar\\n            - Search_view: Estructura XML completa con filtros disponibles, agrupaciones y campos en los que es posible buscar\\n\\n            💡 Consejo de rendimiento: Solicita los detalles de varios menús en una sola llamada al comparar opciones\\n            ⚠️ Siempre valida que el modelo devuelto cumpla con tus expectativas\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "menu_ids": {\n                    "type": "array",\n                    "items": {"type": "number"},\n                    "description": "List of menu IDs to get details for (available in menu data context)"\n                }\n            },\n            "required": ["menu_ids"]\n        }\n        	t	\N	\N
168	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Open Menu Graph", "es_419": "IA: Abrir gráfico del menú"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_open_menu_graph(\n                menu_id, model_name, selected_filters, selected_groupbys, measure,\n                mode, order, search, stacked, cumulated, custom_domain)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            Opens a graph/chart view using search view elements.\\n            Best for: Trends, comparisons, distributions, visual KPIs.\\n\\n            Supported chart types:\\n            - 'bar': Compare values across categories\\n            - 'line': Show trends over time\\n            - 'pie': Display proportions of a whole\\n\\n            Features:\\n            - Apply filters from menu's available options\\n            - Visualize a single measure\\n            - Group by one field for the chart axis\\n            - Search within specific fields\\n            - Stacking and cumulation options\\n            - Order control (ASC/DESC)\\n\\n            💡 Call compute_report_measures() first to find valid measures\\n            ⚠️ Each search string must use format 'field=text'. Array can contain multiple search strings or be empty []\\n            ⚠️ Mode must be exactly 'bar', 'line', or 'pie'\\n            ⚠️ Order must be exactly 'ASC' or 'DESC'\\n        ", "es_419": "\\n            Abre una vista de gráfico o diagrama con los elementos de la vista de búsqueda.\\n            Ideal para: tendencias, comparaciones, distribuciones y KPIs visuales.\\n\\n            Tipos de gráfico compatibles:\\n            - Barras: Compara valores entre categorías\\n            - Líneas: Muestra tendencias a lo largo del tiempo\\n            - Circular: Muestra proporciones de un total\\n\\n            Funciones:\\n            - Aplica filtros desde las opciones disponibles del menú\\n            - Visualiza una sola medida\\n            - Agrupa por un campo para el eje del gráfico\\n            - Busca dentro de campos específicos\\n            - Opciones de apilamiento y acumulación\\n            - Control del orden (ASC/DESC)\\n\\n            💡 Primero llama a compute_report_measures() para encontrar medidas válidas\\n            ⚠️ Cada cadena de búsqueda debe usar el formato \\"campo=valor\\". El arreglo puede contener varias cadenas o estar vacío []\\n            ⚠️ El modo debe ser exactamente \\"Barras\\" (bar), \\"Líneas\\" (line) o \\"Circular\\" (pie)\\n            ⚠️ El orden debe ser exactamente 'ASC' or 'DESC'\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "menu_id": {\n                    "type": "number",\n                    "description": "Menu ID from available menu data"\n                },\n                "model_name": {\n                    "type": "string",\n                    "description": "Model name - must match the menu's model"\n                },\n                "selected_filters": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Filter names from menu's available filters. Empty array [] for no filters."\n                },\n                "selected_groupbys": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Field names for grouping. Priority: 1) Use group_by_field values from search view, 2) If needed field not in search view, use groupable fields from get_fields tool. Example: ['user_id', 'partner_id']. Empty array [] for no grouping."\n                },\n                "measure": {\n                    "type": "string",\n                    "description": "Measure from _compute_report_measures() or '__count' for record count"\n                },\n                "mode": {\n                    "type": "string",\n                    "description": "Chart type: 'bar' for comparisons, 'line' for trends, 'pie' for proportions"\n                },\n                "order": {\n                    "type": "string",\n                    "description": "Sort direction: 'DESC' for highest first, 'ASC' for lowest first"\n                },\n                "search": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Array of field=text strings for searching multiple fields. Each string uses format 'field_name=search_text' where field_name is from menu's searchable_fields. Examples: ['partner_id=Azure', 'product_id=laptop'], ['name=SO-001'], or [] for no search."\n                },\n                "stacked": {\n                    "type": "boolean",\n                    "description": "Stack bars/areas on top of each other (default: false)"\n                },\n                "cumulated": {\n                    "type": "boolean",\n                    "description": "Show cumulative values over time (default: false)"\n                },\n                "custom_domain": {\n                    "type": "string",\n                    "description": "Optional custom domain as JSON string when search view elements are insufficient."\n                },\n                "__end_message": {\n                    "type": "string",\n                    "description": "The message that will be shown to the user. Provide a short summary of how this tool call answers the user's request."\n                }\n            },\n            "required": ["menu_id", "model_name", "selected_filters", "selected_groupbys", "measure", "mode", "order", "search"]\n        }\n        	t	t	\N
166	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Open Menu Kanban", "es_419": "IA: Abrir menú de kanban"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_open_menu_kanban(menu_id, model_name, selected_filters, selected_groupbys, search, custom_domain)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            Opens a kanban (card-based) view using search view elements.\\n            Best for: Stage/status visualization, pipeline views, workflow management.\\n\\n            Key features:\\n            - Display records as cards in columns\\n            - Apply filters from menu's available options\\n            - Group by workflow stages or other fields\\n            - Search within specific fields\\n            - Ideal for CRM pipelines, task boards, project workflows\\n\\n            ⚠️ Use only filter names and groupby fields from menu data\\n            ⚠️ Each search string must use format 'field=text'. Array can contain multiple search strings or be empty []\\n        ", "es_419": "\\n            Abre una vista de kanban (basada en tarjetas) con los elementos de la vista de búsqueda.\\n            Ideal para: visualizar etapas y estados, visualizar flujos y gestionarlos.\\n\\n            Funciones principales:\\n            - Muestra registros como tarjetas en columnas\\n            - Aplica filtros desde las opciones disponibles del menú\\n            - Agrupa por etapas del flujo de trabajo u otros campos\\n            - Busca dentro de campos específicos\\n            - Ideal para flujos de CRM, tableros de tareas y flujos de proyectos\\n\\n            ⚠️ Solo usa nombres de filtros y campos de agrupación del menú\\n            ⚠️ Cada cadena de búsqueda debe usar el formato \\"campo=valor\\". El arreglo puede contener varias cadenas o estar vacío []\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "menu_id": {\n                    "type": "number",\n                    "description": "Menu ID from available menu data"\n                },\n                "model_name": {\n                    "type": "string",\n                    "description": "Model name - must match the menu's model"\n                },\n                "selected_filters": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Filter names from menu's available filters. Empty array [] for no filters."\n                },\n                "selected_groupbys": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Field names for grouping (usually one for kanban columns). Priority: 1) Use group_by_field values from search view, 2) If needed field not in search view, use groupable fields from get_fields tool. Empty array [] for ungrouped."\n                },\n                "search": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Array of field=text strings for searching multiple fields. Each string uses format 'field_name=search_text' where field_name is from menu's searchable_fields. Examples: ['partner_id=Azure', 'product_id=laptop'], ['name=SO-001'], or [] for no search."\n                },\n                "custom_domain": {\n                    "type": "string",\n                    "description": "Optional custom domain as JSON string when search view elements are insufficient."\n                },\n                "__end_message": {\n                    "type": "string",\n                    "description": "The message that will be shown to the user. Provide a short summary of how this tool call answers the user's request."\n                }\n            },\n            "required": ["menu_id", "model_name", "selected_filters", "selected_groupbys", "search"]\n        }\n        	t	t	\N
165	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Open Menu List", "es_419": "IA: Abrir lista del menú"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_open_menu_list(menu_id, model_name, selected_filters, selected_groupbys, search, custom_domain)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            Opens a list (table) view using search view elements.\\n            Best for: \\"Show me\\", \\"List all\\", detailed record viewing, sorting data.\\n\\n            Key features:\\n            - Apply multiple filters by name (from menu's search view)\\n            - Group records by available fields\\n            - Search within specific fields for text\\n            - Displays records in sortable table format\\n            - Ideal for reviewing, filtering, and exporting data\\n\\n            💡 Use search parameter to filter by any searchable field BEFORE considering custom domains\\n            ⚠️ Use only filter names and groupby fields from menu data\\n            ⚠️ Each search string must use format 'field=text'. Array can contain multiple search strings or be empty []\\n        ", "es_419": "\\n            Abre una vista de lista (tabla) con los elementos de la vista de búsqueda.\\n            Ideal para: \\"Muéstrame\\", \\"Enumera todo\\", ver registros detallados y ordenar datos.\\n\\n            Funciones principales:\\n            - Aplica varios filtros por nombre (desde la vista de búsqueda del menú)\\n            - Agrupa registros por campos disponibles\\n            - Busca dentro de campos específicos para texto\\n            - Muestra los registros en formato de tabla que puedes ordenar\\n            - Ideal para revisar, filtrar y exportar datos\\n\\n            💡 Usa el parámetro de búsqueda para filtrar por cualquier campo que puedas buscar ANTES de considerar el uso de dominios personalizados\\n            ⚠️ Solo usa nombres de filtros y campos de agrupación del menú\\n            ⚠️ Cada cadena de búsqueda debe usar el formato \\"campo=valor\\". El arreglo puede contener varias cadenas o estar vacío []\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "menu_id": {\n                    "type": "number",\n                    "description": "Menu ID from available menu data"\n                },\n                "model_name": {\n                    "type": "string",\n                    "description": "Model name - must match the menu's model"\n                },\n                "selected_filters": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Filter names from menu's available filters. Example: ['my_sale_orders', 'draft']. Empty array [] for no filters."\n                },\n                "selected_groupbys": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Field names for grouping. Priority: 1) Use group_by_field values from search view, 2) If needed field not in search view, use groupable fields from get_fields tool. Example: ['user_id', 'partner_id']. Empty array [] for no grouping."\n                },\n                "search": {\n                    "type": "array",\n                    "items": {"type": "string"},\n                    "description": "Array of field=text strings for searching multiple fields. Each string uses format 'field_name=search_text' where field_name is from menu's searchable_fields. Examples: ['partner_id=Azure', 'product_id=laptop'], ['name=SO-001'], or [] for no search."\n                },\n                "custom_domain": {\n                    "type": "string",\n                    "description": "Optional custom domain as JSON string when search view elements are insufficient."\n                },\n                "__end_message": {\n                    "type": "string",\n                    "description": "The message that will be shown to the user. Provide a short summary of how this tool call answers the user's request."\n                }\n            },\n            "required": ["menu_id", "model_name", "selected_filters", "selected_groupbys", "search"]\n        }\n        	t	t	\N
172	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Read group", "es_419": "IA: Leer grupo"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_read_group(model_name, domain, groupby, aggregates, having, offset, limit, order)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            **Tool Name: Read group**\\n\\n            Searches a particular model using a domain. The provided domain must be in valid JSON format.\\n        ", "es_419": "\\n            **Nombre de la herramienta: Leer grupo**\\n\\n            Busca un modelo particular usando un dominio. El dominio proporcionado debe estar en formato JSON válido.\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "model_name": {\n                    "type": "string",\n                    "description": "Technical model name (e.g., 'sale.order', 'product.product', 'res.partner')"\n                },\n                "domain": {\n                    "type": "string",\n                    "description": "A search domain. Use an empty list to match all records. The domain MUST be a valid JSON string."\n                },\n                "groupby": {\n                    "type": "array",\n            "description": "list of groupby descriptions by which the records will be grouped. A groupby description is either a field (then it will be grouped by that field) or a string `'field:granularity'`. Right now, the only supported granularities are `'day'`, `'week'`, `'month'`, `'quarter'` or `'year'`, and they only make sense for date/datetime fields. Additionally integer date parts are also supported: `'year_number'`, `'quarter_number'`, `'month_number'`, `'iso_week_number'`, `'day_of_year'`, `'day_of_month'`, 'day_of_week', 'hour_number', 'minute_number' and 'second_number'.",\n                    "items": {\n                        "type": "string"\n                    }\n                },\n                "aggregates": {\n                    "type": "array",\n                    "description": "list of aggregates specification. Each element is `'field:agg'` (aggregate field with aggregation function `'agg'`). The possible aggregation functions are the ones provided by `PostgreSQL`, `'count_distinct'` with the expected meaning and `'recordset'` to act like `'array_agg'` converted into a recordset.",\n                    "items": {\n                        "type": "string"\n                    }\n                },\n                "having": {\n                    "type": "string",\n                    "description": "A domain where the valid 'fields' are the aggregates. The provided field names must exist in the aggregate elements. The having MUST be a valid JSON string. Example '[[\\"amount_total:sum\\", \\">\\", 1000]]"\n                },\n                "offset": {\n                    "type": "number",\n                    "description": "optional number of groups to skip"\n                },\n                "limit": {\n                    "type": "number",\n                    "description": "optional max number of groups to return"\n                },\n                "order": {\n                    "type": "string",\n                    "description": "optional 'order by' specification, for overriding the natural sort ordering of the groups. The order must be a valid PostgreSQL group by, it must use a valid `aggregate` or `groupby element. The provided fields must exist in the group by or aggregate elements."\n                }\n            },\n            "required": ["model_name", "domain"]\n        }\n        	t	\N	\N
171	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI: Search", "es_419": "IA: Buscar"}	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	5	383	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_actions_server	code	\N	add	true	value	\N	\N	\n            ai['result'] = record._ai_tool_search(model_name, domain, fields, offset, limit, order)\n        	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	{"en_US": "\\n            **Tool Name: search**\\n\\n            Searches a particular model using a domain. The provided domain must be in valid JSON format.\\n        ", "es_419": "\\n            **Nombre de la herramienta: buscar**\\n\\n            Para buscar un modelo particular con un dominio. El dominio brindado debe estar en formato JSON válido.\\n        "}	\N	\n        {\n            "type": "object",\n            "properties": {\n                "model_name": {\n                    "type": "string",\n                    "description": "Technical model name (e.g., 'sale.order', 'product.product', 'res.partner')"\n                },\n                "domain": {\n                    "type": "string",\n                    "description": "A search domain. Use an empty list to match all records. The domain must be a JSON parsable string."\n                },\n                "fields": {\n                    "type": "array",\n                    "description": "a collection of field names to fetch, or None for all accessible fields marked with prefetch=True",\n                    "items": {\n                        "type": "string"\n                    }\n                },\n                "offset": {\n                    "type": "number",\n                    "description": "number of results to ignore (default: none)"\n                },\n                "limit": {\n                    "type": "number",\n                    "description": "optional max number of records to return (default: all)"\n                },\n                "order": {\n                    "type": "string",\n                    "description": "Optional 'order by' specification. This field should have the form `field_name DESC` (or ASC for ascending order)"\n                }\n            },\n            "required": ["model_name", "domain"]\n        }\n        	t	\N	\N
175	\N	1	1	ir.actions.server	\N	action	list,form	{"en_US": "AI Fields: Compute AI fields", "es_419": "Campos IA: Calcular campos de IA"}	\N	2026-02-19 14:18:02.664252	2026-02-19 14:18:02.664252	5	4	\N	\N	\N	\N	\N	\N	\N	Execute Code	ir_cron	code	\N	add	true	value	\N	\N	model._cron_fill_ai_fields()	\N	\N	\N	\N	\N	0	\N	\N	\N	\N	\N	\N	\N	\N	f	\N	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: ir_act_server_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_group_rel (act_id, gid) FROM stdin;
83	2
139	2
140	2
141	1
146	4
147	4
\.


--
-- Data for Name: ir_act_server_res_partner_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_res_partner_rel (ir_act_server_id, res_partner_id) FROM stdin;
\.


--
-- Data for Name: ir_act_server_webhook_field_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_server_webhook_field_rel (server_id, field_id) FROM stdin;
\.


--
-- Data for Name: ir_act_url; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_url (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, target, url) FROM stdin;
4	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Home Menu", "es_419": "Menú de inicio"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	self	/web
41	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Theme Store", "es_419": "Tienda de temas"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	new	https://apps.odoo.com/apps/themes
40	\N	1	1	ir.actions.act_url	\N	action	list,form	{"en_US": "Third-Party Apps", "es_419": "Aplicaciones externas"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	new	https://apps.odoo.com/apps/modules
\.


--
-- Data for Name: ir_act_window; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date, view_id, res_id, "limit", search_view_id, domain, context, res_model, target, view_mode, mobile_view_mode, usage, filter, cache) FROM stdin;
26	\N	1	1	ir.actions.act_window	access-rights	action	list,form	{"en_US": "Access Rights", "es_419": "Permisos de acceso"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	65	\N	80	67	\N	{}	ir.model.access	current	list,form	kanban	\N	\N	t
1	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Load demo data", "es_419": "Cargar datos de demostración"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	ir.demo	new	form	kanban	\N	\N	t
2	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Create Menu", "es_419": "Crear menú"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{'model_id': active_id}	wizard.ir.model.menu.create	new	form	kanban	\N	\N	t
5	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Decimal Accuracy", "es_419": "Precisión decimal"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	decimal.precision	current	list,form	kanban	\N	\N	t
6	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Actions", "es_419": "Acciones"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	7	\N	80	8	\N	{}	ir.actions.actions	current	list,form	kanban	\N	\N	t
7	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Reports", "es_419": "Reportes"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	10	\N	80	11	\N	{}	ir.actions.report	current	list,form	kanban	\N	\N	t
8	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Window Actions", "es_419": "Acciones de ventana"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	15	\N	{}	ir.actions.act_window	current	list,form	kanban	\N	\N	t
9	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Client Actions", "es_419": "Acciones del cliente"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	16	\N	80	\N	\N	{}	ir.actions.client	current	list,form	kanban	\N	\N	t
10	\N	1	1	ir.actions.act_window	server-actions	action	list,form	{"en_US": "Server Actions", "es_419": "Acciones del servidor"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	20	\N	80	21	\N	{\n                'key':'server_action',\n                'search_default_toplevel_actions': 1,\n            }	ir.actions.server	current	list,form	kanban	\N	\N	t
11	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Embedded Actions", "es_419": "Acciones incrustadas"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	23	\N	80	\N	\N	{}	ir.embedded.actions	current	list,form	kanban	\N	\N	t
12	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Configuration Wizards", "es_419": "Asistentes de configuración"}	{"en_US": "<p>The configuration wizards are used to help you configure a new instance of Odoo. They are launched during the installation of new modules, but you can choose to restart some wizards manually from this menu.</p>", "es_419": "<p>Los asistentes de configuración se usan para ayudarle a configurar una nueva instancia de Odoo. Estos se inician durante la instalación de nuevos módulos, pero puede reiniciarlos de forma manual desde este menú.</p>"}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	24	\N	80	\N	\N	{}	ir.actions.todo	current	list,form	kanban	\N	\N	t
14	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Assets", "es_419": "Activos"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	28	\N	80	\N	\N	{'search_default_active': 1}	ir.asset	current	list,form	kanban	\N	\N	t
15	\N	1	1	ir.actions.act_window	system-parameters	action	list,form	{"en_US": "System Parameters", "es_419": "Parámetros del sistema"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	ir.config_parameter	current	list,form	kanban	\N	\N	t
17	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Scheduled Actions Triggers", "es_419": "Activación de acciones planificadas"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	ir.cron.trigger	current	list,form	kanban	\N	\N	t
18	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User-defined Filters", "es_419": "Filtros de usuario"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	ir.filters	current	list,form	kanban	\N	\N	t
19	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Outgoing Mail Servers", "es_419": "Servidores de correo saliente"}	{"en_US": "<div>\\n                    <b class=\\"o_view_nocontent_smiling_face\\">\\n                        No Outgoing Servers yet\\n                    </b>\\n                </div>\\n            ", "es_419": "<div>\\n                    <b class=\\"o_view_nocontent_smiling_face\\">\\n                        Todavía no hay servidores salientest\\n                    </b>\\n                </div>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	45	\N	80	46	\N	{}	ir.mail_server	current	list,form	kanban	\N	\N	t
20	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Models", "es_419": "Modelos"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	48	\N	80	\N	\N	{}	ir.model	current	list,form	kanban	\N	\N	t
21	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fields", "es_419": "Campos"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	51	\N	80	\N	\N	{}	ir.model.fields	current	list,form	kanban	\N	\N	t
22	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fields Selection", "es_419": "Selección de campos"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	54	\N	80	\N	\N	{}	ir.model.fields.selection	current	list,form	kanban	\N	\N	t
23	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "External Identifiers", "es_419": "Identificadores externos"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	57	\N	80	\N	\N	{}	ir.model.data	current	list,form	kanban	\N	\N	t
24	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Model Constraints", "es_419": "Restricciones del modelo"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	60	\N	80	61	\N	{}	ir.model.constraint	current	list,form	kanban	\N	\N	t
25	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "ManyToMany Relations", "es_419": "Relaciones many2many"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	63	\N	80	\N	\N	{}	ir.model.relation	current	list,form	kanban	\N	\N	t
16	\N	1	1	ir.actions.act_window	crons	action	list,form	{"en_US": "Scheduled Actions", "es_419": "Acciones planificadas"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:56.616872	34	\N	80	\N	[('id', '!=', 4)]	{'search_default_all': 1}	ir.cron	current	list,form,calendar	kanban	\N	\N	t
28	\N	1	1	ir.actions.act_window	record-rules	action	list,form	{"en_US": "Record Rules", "es_419": "Reglas de registro"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	72	\N	80	73	\N	{}	ir.rule	current	list,form	kanban	\N	\N	t
29	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Sequences", "es_419": "Secuencias"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	75	\N	80	\N	\N	{'active_test': False}	ir.sequence	current	list,form	kanban	\N	\N	t
30	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Menu Items", "es_419": "Elementos de menú"}	{"en_US": "<p>Manage and customize the items available and displayed in your Odoo system menu. You can delete an item by clicking on the box at the beginning of each line and then delete it through the button that appeared. Items can be assigned to specific groups in order to make them accessible to some users within the system.</p>", "es_419": "<p>Gestione y personalice los elementos disponibles que aparecen en su menú de Odoo. Para eliminar un elemento, haga clic en la caja que se encuentra al inicio de cada línea y haga clic en el botón de eliminar. Los elementos se pueden asignar a grupos específicos para que solo algunos usuarios del sistema puedan acceder a ellos.</p>"}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	78	\N	80	79	\N	{'ir.ui.menu.full_list':True}	ir.ui.menu	current	list,form	kanban	\N	\N	t
31	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Views", "es_419": "Vistas"}	{"en_US": "<p>Views allows you to personalize each view of Odoo. You can add new fields, move fields, rename them or delete the ones that you do not need.</p>", "es_419": "<p>Las vistas le permiten personalizar cada vista de Odoo. Puede agregar nuevos campos, moverlos, renombrarlos o eliminarlos si es necesario.</p>"}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	81	\N	80	\N	\N	{'search_default_active': 1}	ir.ui.view	current	list,form	kanban	\N	\N	t
32	15	1	1	ir.actions.act_window	\N	action	form,list,kanban	{"en_US": "Compare/Reset", "es_419": "Comparar/Restablecer"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	reset.view.arch.wizard	new	form	kanban	\N	\N	t
33	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customized Views", "es_419": "Vistas personalizadas"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">Create a customized view</p><p>Customized views are used when users reorganize the content of their dashboard views (via web client)</p>", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">Crear una vista personalizada</p><p>Las vistas personalizadas se utilizan cuando los usuarios reorganizan el contenido de sus vistas de tablero (mediante el cliente web)</p>"}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	ir.ui.view.custom	current	list,form	kanban	\N	\N	t
34	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User-defined Defaults", "es_419": "Predeterminados por el usuario"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	89	\N	{}	ir.default	current	list,form	kanban	\N	\N	t
38	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Logging", "es_419": "Registro"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	93	\N	{}	ir.logging	current	list,form	kanban	\N	\N	t
39	\N	1	1	ir.actions.act_window	apps	action	list,form	{"en_US": "Apps", "es_419": "Aplicaciones"}	{"en_US": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No module found!\\n              </p><p>\\n                You should try other search criteria.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_empty_folder\\">\\n                No se encontró ningún módulo\\n              </p><p>\\n                Intente usar otro criterio de búsqueda.\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	98	\N	{'search_default_app':1}	ir.module.module	current	kanban,list,form	kanban	\N	\N	t
43	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Module Update", "es_419": "Actualización de módulo"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	base.module.update	new	form	kanban	\N	\N	t
44	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Add Languages", "es_419": "Agregar idiomas"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	base.language.install	new	form	kanban	\N	\N	t
45	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Import Translation", "es_419": "Importar traducción"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	base.language.import	new	form	kanban	\N	\N	t
46	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Apply Schedule Upgrade", "es_419": "Aplicar actualización programada"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N	t
47	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Module Upgrade Install", "es_419": "Instalar actualización del módulo"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	108	\N	80	\N	\N	{}	base.module.upgrade	new	form	kanban	\N	\N	t
48	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Export Translation", "es_419": "Exportar traducción"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	base.language.export	new	form	kanban	\N	\N	t
49	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Deduplicate Contacts", "es_419": "Deduplicar contactos"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{'active_test': False}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N	t
50	90	1	1	ir.actions.act_window	\N	action	list,kanban	{"en_US": "Merge", "es_419": "Fusionar"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	base.partner.merge.automatic.wizard	new	form	kanban	\N	\N	t
52	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Ir profile", "es_419": "Perfil de IR"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{'search_default_group_session': 1}	ir.profile	current	list,form	kanban	\N	\N	t
53	\N	1	1	ir.actions.act_window	companies	action	list,form	{"en_US": "Companies", "es_419": "Empresas"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new company\\n              </p><p>\\n                Create and manage the companies that will be managed by Odoo from here. Shops or subsidiaries can be created and maintained from here.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear una nueva empresa\\n              </p><p>\\n                Cree y gestione las empresas que Odoo gestionará aquí. También puede crear y dar mantenimiento a las tiendas o subsidiarias desde aquí.\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	[('parent_id', '=', False)]	{}	res.company	current	list,kanban,form	kanban	\N	\N	t
54	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Languages", "es_419": "Idiomas"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	123	\N	{'active_test': False}	res.lang	current	list,form	kanban	\N	\N	t
58	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Contact Tags", "es_419": "Etiquetas de contacto"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact Tag\\n              </p><p>\\n                Assign tags to your contacts to organize, filter and track them.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear una etiqueta de contacto\\n              </p><p>\\n                Asigne etiquetas a sus contactos para organizarlos, filtrarlos y rastrearlos.\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	132	\N	{}	res.partner.category	current	list,form	kanban	\N	\N	t
59	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Industries", "es_419": "Industrias"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create an Industry\\n              </p><p>\\n                Specify industries to classify your contacts and draw up reports.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear una industria\\n              </p><p>\\n                Especifique las industrias para clasificar sus contactos y elaborar reportes.\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	135	\N	{}	res.partner.industry	current	list,form	kanban	\N	\N	t
60	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Banks", "es_419": "Bancos"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank\\n              </p><p>\\n                Banks are the financial institutions at which you and your contacts have their accounts.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear un banco\\n              </p><p>\\n                Los bancos son instituciones financieras en las que usted y sus contactos tienen sus cuentas.\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	138	\N	{}	res.bank	current	list,form	kanban	\N	\N	t
61	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Bank Accounts", "es_419": "Cuentas bancarias"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Bank Account\\n              </p><p>\\n                From here you can manage all bank accounts linked to you and your contacts.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear una cuenta bancaria\\n              </p><p>\\n                Desde aquí puede gestionar todas las cuentas bancarias vinculadas a usted o a sus contactos.\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	res.partner.bank	current	list,form	kanban	\N	\N	t
62	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Countries", "es_419": "Países"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No Country Found!\\n                </p><p>\\n                    Manage the list of countries that can be set on your contacts.\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No se encontró el país\\n                </p><p>\\n                    Gestione la lista de países que se pueden establecer en sus contactos.\\n                </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	res.country	current	list,form	kanban	\N	\N	t
63	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Country Group", "es_419": "Grupo del país"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a Country Group\\n                </p><p>\\n                    Use groups to organize countries that are frequently selected together (e.g. \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Crear un grupo de países\\n                </p><p>\\n                    Use grupos para organizar países que se seleccionan juntos con frecuencia (por ejemplo, \\"LATAM\\", \\"BeNeLux\\", \\"ASEAN\\").\\n                </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	res.country.group	current	list,form	kanban	\N	\N	t
64	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Fed. States", "es_419": "Estados"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create a State\\n                </p><p>\\n                    Federal States belong to countries and are part of your contacts' addresses.\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Crear un estado\\n                </p><p>\\n                    Los estados federales pertenecen a países que son parte de sus direcciones de contacto\\n                </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	147	\N	80	\N	\N	{}	res.country.state	current	list,form	kanban	\N	\N	t
65	96	1	1	ir.actions.act_window	\N	action	form	{"en_US": "Show Currency Rates", "es_419": "Mostrar tasas de cambio"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	151	\N	80	\N	[('currency_id','=', active_id)]	{'default_currency_id': active_id}	res.currency.rate	current	list,form	kanban	\N	\N	t
66	\N	1	1	ir.actions.act_window	currencies	action	list,form	{"en_US": "Currencies", "es_419": "Monedas"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	153	\N	{'active_test': False}	res.currency	current	list,kanban,form	kanban	\N	\N	t
67	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Privileges", "es_419": "Privilegios"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	res.groups.privilege	current	list,form	kanban	\N	\N	t
68	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Groups", "es_419": "Grupos"}	{"en_US": "<p>A group is a set of functional areas that will be assigned to the user in order to give them access and rights to specific applications and tasks in the system. You can create custom groups or edit the ones existing by default in order to customize the view of the menu that users will be able to see. Whether they can have a read, write, create and delete access right can be managed from here.</p>", "es_419": "<p>Un grupo es un conjunto de áreas funcionales que se asignarán al usuario para proporcionarle acceso y permisos a aplicaciones específicas y tareas en el sistema. Puede crear grupos personalizados o editar los existentes para personalizar la vista de menús que los usuarios podrán ver. La gestión de los permisos de lectura, escritura, creación y eliminación se puede gestionar desde aquí.</p>"}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{'search_default_filter_no_share': 1}	res.groups	current	list,form	kanban	\N	\N	t
69	102	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Change Password", "es_419": "Cambiar contraseña"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	change.password.wizard	new	form	kanban	\N	\N	t
70	\N	1	1	ir.actions.act_window	users	action	list,form	{"en_US": "Users", "es_419": "Usuarios"}	{"en_US": "<p>Create and manage users that will connect to the system. Users can be deactivated should there be a period of time during which they will/should not connect to the system. You can assign them groups in order to give them specific access to the applications they need to use in the system.</p>", "es_419": "<p>Cree y gestione los usuarios que accederán al sistema, puede desactivarlos si no accederán durante cierto tiempo. Puede asignarles grupos para darles acceso específico a las aplicaciones que necesitan usar.</p>"}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	168	\N	80	170	\N	{'search_default_filter_no_share': 1, 'is_action_res_users': True}	res.users	current	list,kanban,form	kanban	\N	\N	t
71	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "API Key: description input wizard", "es_419": "Clave API: asistente de entrada de descripción"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	res.users.apikeys.description	new	form	kanban	\N	\N	t
72	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Change My Preferences", "es_419": "Cambiar mis preferencias"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	res.users	new	form	kanban	\N	\N	t
73	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "API Keys Listing", "es_419": "Lista de claves API"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	174	\N	80	\N	\N	{}	res.users.apikeys	current	list	kanban	\N	\N	t
74	\N	1	1	ir.actions.act_window	user-device	action	list,form	{"en_US": "User Devices", "es_419": "Dispositivos de usuario"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	res.device	current	list,kanban,form	kanban	\N	\N	t
75	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Settings", "es_419": "Ajustes"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	res.config.settings	current	form	kanban	\N	\N	t
76	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Paper Format General Configuration", "es_419": "Configuración general del formato de papel"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	report.paperformat	current	list,form	kanban	\N	\N	t
77	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Reports", "es_419": "Reportes"}	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N	80	\N	\N	{}	ir.actions.report	current	list,form	kanban	\N	\N	t
81	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Configure your document layout", "es_419": "Configura el diseño de tu documento"}	\N	2026-02-19 14:17:52.907935	2026-02-19 14:17:52.907935	219	\N	80	\N	\N	{"dialog_size": "extra-large"}	base.document.layout	new	form	kanban	\N	\N	t
84	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Import Module", "es_419": "Importar módulo"}	\N	2026-02-19 14:17:54.40811	2026-02-19 14:17:54.40811	\N	\N	80	\N	\N	{}	base.import.module	new	form	kanban	\N	\N	t
85	\N	1	1	ir.actions.act_window	settings	action	list,form	{"en_US": "Settings", "es_419": "Ajustes"}	\N	2026-02-19 14:17:54.518519	2026-02-19 14:17:54.518519	\N	\N	80	\N	\N	{'module' : 'general_settings', 'bin_size': False}	res.config.settings	current	form	kanban	\N	\N	t
86	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Tours", "es_419": "Recorridos"}	\N	2026-02-19 14:17:55.456461	2026-02-19 14:17:55.456461	239	\N	80	240	\N	{}	web_tour.tour	current	list,form	kanban	\N	\N	t
88	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Create Passkey Wizard", "es_419": "Asistente para crear llaves de acceso"}	\N	2026-02-19 14:17:55.572166	2026-02-19 14:17:55.572166	\N	\N	80	\N	\N	{}	auth.passkey.key.create	new	form	kanban	\N	\N	t
89	\N	1	1	ir.actions.act_window	iap-accounts	action	list,form	{"en_US": "IAP Account", "es_419": "Cuenta para compras dentro de la aplicación"}	\N	2026-02-19 14:17:56.17534	2026-02-19 14:17:56.17534	\N	\N	80	\N	\N	{}	iap.account	current	list,form	kanban	\N	\N	t
90	222	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Compose Email", "es_419": "Redactar correo electrónico"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.compose.message	new	form	kanban	\N	\N	t
91	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Template Preview", "es_419": "Vista previa de la plantilla"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	263	\N	80	\N	\N	{'default_mail_template_id':active_id}	mail.template.preview	new	form	kanban	\N	\N	t
92	186	1	1	ir.actions.act_window	\N	action	list,kanban	{"en_US": "Reset Mail Template", "es_419": "Restablecer plantilla de correo"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	266	\N	80	\N	\N	{\n            'default_template_ids': active_ids\n        }	mail.template.reset	new	form	kanban	\N	\N	t
27	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Attachments", "es_419": "Archivos adjuntos"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Attach a new document\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Attach a new document\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:56.616872	\N	\N	80	70	\N	{}	ir.attachment	current	kanban,list,form	kanban	\N	\N	t
55	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Customers", "es_419": "Clientes"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a Contact in your address book\\n              </p><p>\\n                Odoo helps you track all activities related to your contacts.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear un contacto en la libreta de direcciones\\n              </p><p>\\n                Odoo te ayuda a llevar seguimiento de todas las actividades relacionadas con tus contactos.\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:56.616872	\N	\N	80	128	\N	{'res_partner_search_mode': 'customer'}	res.partner	current	list,kanban,form,activity	kanban	\N	\N	t
56	\N	1	1	ir.actions.act_window	ecommerce-customers	action	list,form	{"en_US": "Customers", "es_419": "Clientes"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new customer in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a customer.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Crear un nuevo cliente en su directorio\\n              </p><p>\\n                Odoo le ayuda a rastrear con facilidad todas las actividades relacionadas con un cliente.\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:56.616872	\N	\N	80	\N	[]	{'res_partner_search_mode': 'customer', 'default_is_company': True}	res.partner	current	list,kanban,form,activity	kanban	\N	t	t
57	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Vendors", "es_419": "Proveedores"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Create a new vendor in your address book\\n              </p><p>\\n                Odoo helps you easily track all activities related to a vendor.\\n              </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Cree un nuevo proveedor en su libreta de direcciones\\n              </p><p>\\n                Odoo le ayuda a rastrear con facilidad todas las actividades relacionadas con un proveedor.\\n              </p>\\n            "}	2026-02-19 14:17:42.822463	2026-02-19 14:17:56.616872	\N	\N	80	\N	[]	{'res_partner_search_mode': 'supplier', 'default_is_company': True}	res.partner	current	list,kanban,form,activity	kanban	\N	t	t
93	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Incoming Mail Servers", "es_419": "Servidores de correo entrante"}	{"en_US": "<div>\\n                    <b class=\\"o_view_nocontent_smiling_face\\">\\n                        No Incoming Servers yet\\n                    </b>\\n                </div>\\n            ", "es_419": "<div>\\n                    <b class=\\"o_view_nocontent_smiling_face\\">\\n                        Todavía no hay servidores entrantes\\n                    </b>\\n                </div>\\n            "}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	267	\N	80	269	\N	{}	fetchmail.server	current	list,form	kanban	\N	\N	t
94	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Subtypes", "es_419": "Subtipos"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.message.subtype	current	list,form	kanban	\N	\N	t
95	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Tracking Values", "es_419": "Valores de seguimiento"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.tracking.value	current	list,form	kanban	\N	\N	t
96	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Notifications", "es_419": "Notificaciones"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.notification	current	list,form	kanban	\N	\N	t
97	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Messages", "es_419": "Mensajes"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	283	\N	{}	mail.message	current	list,form	kanban	\N	\N	t
98	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Scheduled Messages", "es_419": "Mensajes programados"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.message.schedule	current	list,form	kanban	\N	\N	t
99	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Emails", "es_419": "Correos electrónicos"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	290	\N	{}	mail.mail	current	list,form	kanban	\N	\N	t
100	164	1	1	ir.actions.act_window	\N	action	form	{"en_US": "Messages", "es_419": "Mensajes"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	[('email_from', '!=', False), ('fetchmail_server_id', '=', active_id)]	{'search_default_server_id': active_id, 'default_fetchmail_server_id': active_id}	mail.mail	current	list,form	kanban	\N	\N	t
101	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Followers", "es_419": "Seguidores"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.followers	current	list,form	kanban	\N	\N	t
102	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "ICE Servers", "es_419": "Servidores ICE"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">No ICE servers found. Let's create one!</p>\\n            <p>Use your own servers for calls to manage heavy traffic and ensure reliability if Twilio is unavailable.</p>\\n        ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">No se encontraron servidores ICE. Creemos uno.</p>\\n            <p>Usa tus propios servidores de llamadas para gestionar el tráfico alto y asegurar la seguridad si Twilio no está disponible.</p>\\n        "}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.ice.server	current	list,form,kanban	kanban	\N	\N	t
103	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Channels/Members", "es_419": "Canales/Miembros"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	discuss.channel.member	current	list,form	kanban	\N	\N	t
104	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "RTC sessions", "es_419": "Sesiones de comunicación en tiempo real"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{'search_default_group_by_channel': True}	discuss.channel.rtc.session	current	list,form	kanban	\N	\N	t
105	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Link Previews", "es_419": "Vista previa del enlace"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.link.preview	current	list,form	kanban	\N	\N	t
106	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "GIF favorite", "es_419": "GIF favorito"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	discuss.gif.favorite	current	list,form	kanban	\N	\N	t
107	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Join a group", "es_419": "Unirse a un grupo"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	311	\N	{}	discuss.channel	current	kanban,list,form	kanban	\N	\N	t
108	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Channels", "es_419": "Canales"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	311	[('channel_type', '=', 'channel')]	{}	discuss.channel	current	kanban,form	kanban	\N	\N	t
110	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Canned Responses", "es_419": "Respuestas predefinidas"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No canned response found. Let's create one!\\n                </p><p>\\n                    Use canned responses to quickly insert prewritten messages with <i>::shortcut</i>. You can edit the text before sending.\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    No se encontró ninguna respuesta predeterminada. Creemos una.\\n                </p><p>\\n                    Use respuestas predeterminadas para insertar mensajes ya escritos con solo un <i>::atajo</i>. Podrá editar el texto antes de enviarlo.\\n                </p>\\n            "}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	312	\N	{}	mail.canned.response	current	list,form,kanban	kanban	\N	\N	t
111	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Roles", "es_419": "Funciones"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">No roles found. Let's create one!</p>\\n                <p>Notify multiple people at once by @-mentioning roles in conversations.</p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">No se encontraron funciones. ¡Creemos una!</p>\\n                <p>Mencione @-roles en conversaciones para enviar notificaciones a varias personas al mismo tiempo.</p>\\n            "}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	316	\N	{}	res.role	current	list,form	kanban	\N	\N	t
112	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Activity Types", "es_419": "Tipos de actividad"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.activity.type	current	list,kanban,form	kanban	\N	\N	t
113	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Activity Overview", "es_419": "Información general de la actividad"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{\n            'force_search_count': 1,\n        }	mail.activity	current	list,form	kanban	\N	\N	t
114	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Other activities", "es_419": "Otras actividades"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                No activities.\\n            </p>\\n        ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Sin actividades.\\n            </p>\\n        "}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	326	['|', ('id', 'in', context.get('active_ids')), '&', ('res_model', '=', False), ('user_id', '=', uid)]	{}	mail.activity	main	list,form	kanban	\N	\N	t
115	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "My Activities", "es_419": "Mis actividades"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	326	\N	{\n            'force_search_count': 1,\n            'search_default_filter_user_id_uid': 1,\n            'search_default_filter_date_deadline_past': 1,\n            'search_default_filter_date_deadline_today': 1,\n        }	mail.activity	current	list,kanban,calendar	kanban	\N	\N	t
149	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Privacy Logs", "es_419": "Registros de privacidad"}	\N	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805	\N	\N	80	\N	\N	{'create': False}	privacy.log	current	form	kanban	\N	\N	t
116	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Activity Plans", "es_419": "Planes de actividad"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Create an Activity Plan\\n                </p>\\n                <p>\\n                    Activity plans are used to assign a list of activities in just a few clicks\\n                    (e.g. \\"Onboarding\\", \\"Prospect Follow-up\\", \\"Project Milestone Meeting\\", ...)\\n                </p>\\n            ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                    Crear un plan de actividad\\n                </p>\\n                <p>\\n                    Los planes de actividad se utilizan para asignar una lista de actividades con unos cuantos clics\\n                    (por ejemplo, \\"Capacitación\\", \\"Seguimiento del cliente potencial\\", \\"Reunión sobre objetivos del proyecto\\", entre otras)\\n                </p>\\n            "}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	332	\N	{}	mail.activity.plan	current	list,kanban,form	kanban	\N	\N	t
127	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Alias Domains", "es_419": "Dominios del alias"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.alias.domain	current	list,form	kanban	\N	\N	t
128	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Aliases", "es_419": "Alias"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{\n                    'search_default_active': True,\n                }\n            	mail.alias	current	list,form	kanban	\N	\N	t
129	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Mail Gateway Allowed", "es_419": "Puerta de enlace de correo permitida"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.gateway.allowed	current	list	kanban	\N	\N	t
130	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Guests", "es_419": "Invitados"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.guest	current	list,form	kanban	\N	\N	t
131	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Message Reactions", "es_419": "Reacciones de mensaje"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	mail.message.reaction	current	list,form	kanban	\N	\N	t
132	\N	1	1	ir.actions.act_window	my-preferences	action	list,form	{"en_US": "Change My Preferences", "es_419": "Cambiar mis preferencias"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	res.users	current	form	kanban	\N	\N	t
133	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "User Settings", "es_419": "Ajustes de usuario"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{}	res.users.settings	current	list,form	kanban	\N	\N	t
134	\N	1	1	ir.actions.act_window	email-templates	action	list,form	{"en_US": "Email Templates", "es_419": "Plantillas de correo electrónico"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	376	\N	80	377	\N	{'search_default_base_templates': 1}	mail.template	current	form,list	kanban	\N	\N	t
135	90	1	1	ir.actions.act_window	\N	action	list,kanban	{"en_US": "Send email", "es_419": "Enviar correo"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{\n                'default_composition_mode': 'mass_mail',\n                'default_partner_to': '{{ object.id or \\'\\' }}',\n                'default_subtype_xmlid': 'mail.mt_comment',\n                'default_reply_to_force_new': True,\n            }	mail.compose.message	new	form	kanban	\N	\N	t
136	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Blacklisted Email Addresses", "es_419": "Direcciones de correo electrónico incluidas en la lista de exclusión"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Add an email address to the blacklist\\n          </p><p>\\n            Email addresses that are blacklisted won't receive Email mailings anymore.\\n        </p>\\n        ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n            Agregar una dirección de correo electrónico a la lista de exclusión\\n          </p><p>\\n            Las direcciones de correo electrónico que estén en la lista negra ya no recibirán correos electrónicos\\n        </p>\\n        "}	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	387	\N	80	389	\N	{}	mail.blacklist	current	list,form	kanban	\N	\N	t
137	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Call History", "es_419": "Historial de la llamada"}	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N	80	\N	\N	{"create": False}	discuss.call.history	current	list,form	kanban	\N	\N	t
142	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "You are about to install an extra application", "es_419": "Está por instalar una aplicación adicional"}	\N	2026-02-19 14:17:59.215236	2026-02-19 14:17:59.215236	\N	\N	80	\N	\N	{ 'default_module_id': active_id }	base.module.install.review	new	form	kanban	\N	\N	t
143	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Blacklisted Phone Numbers", "es_419": "Números de teléfono en la lista de exclusión"}	{"en_US": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Add a phone number in the blacklist\\n            </p><p>\\n                Blacklisted phone numbers won't receive SMS Mailings anymore.\\n            </p>\\n        ", "es_419": "<p class=\\"o_view_nocontent_smiling_face\\">\\n                Agregue un número de teléfono a la lista de exclusión\\n            </p><p>\\n                Los números de teléfono en la lista de exclusión no recibirán SMS.\\n            </p>\\n        "}	2026-02-19 14:17:59.669059	2026-02-19 14:17:59.669059	428	\N	80	430	\N	{}	phone.blacklist	current	list,form	kanban	\N	\N	t
148	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Privacy Logs", "es_419": "Registros de privacidad"}	\N	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805	\N	\N	80	\N	\N	{'create': False}	privacy.log	current	list,form	kanban	\N	\N	t
144	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Privacy Lookup", "es_419": "Búsqueda de privacidad"}	\N	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805	433	\N	80	\N	\N	{}	privacy.lookup.wizard	current	form	kanban	\N	\N	t
145	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Privacy Lookup Line", "es_419": "Línea de búsqueda de privacidad"}	\N	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805	434	\N	80	\N	\N	{'search_default_group_by_res_model_id': 1, 'no_create_edit': True}	privacy.lookup.wizard.line	current	list	kanban	\N	\N	t
155	373	1	1	ir.actions.act_window	\N	action	list,kanban	{"en_US": "Reset SMS Template", "es_419": "Restablecer las plantillas de SMS"}	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257	446	\N	80	\N	\N	{\n            'default_template_ids': active_ids\n        }	sms.template.reset	new	form	kanban	\N	\N	t
158	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "SMS", "es_419": "SMS"}	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257	\N	\N	80	\N	[('to_delete', '!=', True)]	{}	sms.sms	current	list,form	kanban	\N	\N	t
156	90	1	1	ir.actions.act_window	\N	action	list,kanban	{"en_US": "Send SMS", "es_419": "Enviar SMS"}	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257	\N	\N	80	\N	\N	{\n            'default_composition_mode': 'mass',\n            'default_mass_keep_log': True,\n            'default_res_ids': active_ids\n        }	sms.composer	new	form	kanban	\N	\N	t
157	90	1	1	ir.actions.act_window	\N	action	form	{"en_US": "Send SMS", "es_419": "Enviar SMS"}	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257	\N	\N	80	\N	\N	{\n            'default_composition_mode': 'comment',\n            'default_res_id': active_id,\n        }	sms.composer	new	form	kanban	\N	\N	t
153	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Send SMS", "es_419": "Enviar SMS"}	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257	\N	\N	80	\N	\N	{}	sms.composer	new	form	kanban	\N	\N	t
154	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Template Preview", "es_419": "Vista previa de la plantilla"}	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257	445	\N	80	\N	\N	{'default_sms_template_id':active_id}	sms.template.preview	new	form	kanban	\N	\N	t
160	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Templates", "es_419": "Plantillas"}	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257	\N	\N	80	\N	\N	{}	sms.template	current	list,form	kanban	\N	\N	t
162	\N	1	1	ir.actions.act_window	\N	action	list,form	{"en_US": "Snailmail Letters", "es_419": "Cartas de correo postal"}	\N	2026-02-19 14:18:01.593522	2026-02-19 14:18:01.593522	461	\N	80	\N	[('state', '!=', 'draft')]	{}	snailmail.letter	current	form,list	kanban	\N	\N	t
\.


--
-- Data for Name: ir_act_window_group_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_group_rel (act_id, gid) FROM stdin;
73	4
\.


--
-- Data for Name: ir_act_window_view; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_act_window_view (id, sequence, view_id, act_window_id, create_uid, write_uid, view_mode, multi, create_date, write_date) FROM stdin;
1	1	13	8	1	1	list	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
2	2	14	8	1	1	form	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
3	1	129	55	1	1	kanban	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
4	2	127	55	1	1	form	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
5	0	124	55	1	1	list	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
6	2	129	56	1	1	kanban	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
7	1	124	56	1	1	list	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
8	3	127	56	1	1	form	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
9	2	129	57	1	1	kanban	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
10	1	124	57	1	1	list	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
11	3	127	57	1	1	form	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
12	10	168	70	1	1	list	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
13	20	167	70	1	1	form	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
14	10	173	72	1	1	form	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
15	1	\N	113	1	1	list	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
16	2	324	113	1	1	form	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
17	1	328	114	1	1	list	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
18	2	325	114	1	1	form	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
19	1	329	115	1	1	list	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
20	1	330	115	1	1	kanban	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
21	1	331	115	1	1	calendar	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
22	1	334	116	1	1	list	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
23	2	335	116	1	1	form	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
24	50	173	132	1	1	form	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
\.


--
-- Data for Name: ir_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions (id, binding_model_id, create_uid, write_uid, type, path, binding_type, binding_view_types, name, help, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_actions_server_history; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_server_history (id, action_id, create_uid, write_uid, code, create_date, write_date) FROM stdin;
1	13	1	1	\nconfig = model.next() or {}\nif config.get('type') not in ('ir.actions.act_window_close',):\n    action = config\n	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
2	35	1	1	model._run_vacuum_cleaner()	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
3	36	1	1	model._gc_portal_users(batch_size=50)	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
4	51	1	1	\nfailures = env['ir.demo_failure'].search([\n    ('wizard_id', '=', False),\n])\nrecord = model.create({\n    'failure_ids': [Command.set(failures.ids)],\n})\naction = {\n    'type': 'ir.actions.act_window',\n    'res_id': record.id,\n    'res_model': 'ir.demo_failure.wizard',\n    'target': 'new',\n    'views': [(env.ref('base.demo_failures_dialog').id, 'form')],\n}\n        	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
5	82	1	1	\n            action = {\n                'type': 'ir.actions.act_url',\n                'url': '/web/partner/vcard?partner_ids=' + ','.join(map(str, records.ids)),\n                'target': 'download',\n            }\n        	2026-02-19 14:17:52.907935	2026-02-19 14:17:52.907935
6	83	1	1	\n            action = records.action_totp_disable()\n        	2026-02-19 14:17:53.952449	2026-02-19 14:17:53.952449
7	87	1	1	\nif records:\n    action = records.export_js_file()\n        	2026-02-19 14:17:55.456461	2026-02-19 14:17:55.456461
8	117	1	1	model.process_email_queue(batch_size=1000)	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
9	118	1	1	model.update_notification(None)	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
10	119	1	1	model._gc_notifications(max_age_days=180)	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
11	120	1	1	model._fetch_mails()	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
12	121	1	1	model._post_messages_cron()	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
13	122	1	1	model._send_notifications_cron()	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
14	123	1	1	model._push_notification_to_endpoint()	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
15	124	1	1	model._cleanup_expired_mutes()	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
16	138	1	1	model.send_unregistered_user_reminder(batch_size=100)	2026-02-19 14:17:58.885671	2026-02-19 14:17:58.885671
17	139	1	1	records.action_reset_password()	2026-02-19 14:17:58.885671	2026-02-19 14:17:58.885671
18	140	1	1	\n            action = records.action_totp_invite()\n        	2026-02-19 14:17:59.096548	2026-02-19 14:17:59.096548
19	141	1	1	\nuser = env.user\naction = user.action_open_my_account_settings()\n        	2026-02-19 14:17:59.096548	2026-02-19 14:17:59.096548
20	146	1	1	\naction = record.action_privacy_lookup()\n        	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805
21	147	1	1	\naction = record.partner_id.action_privacy_lookup()\n        	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805
22	150	1	1	\nrecords.action_archive_all()\n        	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805
23	151	1	1	\nrecords.action_unlink_all()\n        	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805
24	152	1	1	model._process_queue()	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
25	159	1	1	action = records.resend_failed()	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
26	161	1	1	model._snailmail_cron()	2026-02-19 14:18:01.593522	2026-02-19 14:18:01.593522
27	163	1	1	\n            ai['result'] = record._ai_tool_get_menu_details(menu_ids)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
28	164	1	1	\n            ai['result'] = record._ai_tool_get_fields(model_name, include_description)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
29	165	1	1	\n            ai['result'] = record._ai_tool_open_menu_list(menu_id, model_name, selected_filters, selected_groupbys, search, custom_domain)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
30	166	1	1	\n            ai['result'] = record._ai_tool_open_menu_kanban(menu_id, model_name, selected_filters, selected_groupbys, search, custom_domain)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
31	167	1	1	\n            ai['result'] = record._ai_tool_open_menu_pivot(menu_id, model_name, selected_filters, row_groupbys, col_groupbys, measures, search, custom_domain)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
32	168	1	1	\n            ai['result'] = record._ai_tool_open_menu_graph(\n                menu_id, model_name, selected_filters, selected_groupbys, measure,\n                mode, order, search, stacked, cumulated, custom_domain)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
33	169	1	1	\n            ai['result'] = record._ai_tool_compute_report_measures(action_id, model_name)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
34	170	1	1	\n            ai['result'] = record._ai_tool_adjust_search(model_name, remove_facets, toggle_filters, toggle_groupbys, apply_searches, measures, mode, order, stacked, cumulated, custom_domain, switch_view_type)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
35	171	1	1	\n            ai['result'] = record._ai_tool_search(model_name, domain, fields, offset, limit, order)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
36	172	1	1	\n            ai['result'] = record._ai_tool_read_group(model_name, domain, groupby, aggregates, having, offset, limit, order)\n        	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
37	173	1	1	model._cron_generate_embedding()	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
38	174	1	1	model._cron_process_sources()	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
39	175	1	1	model._cron_fill_ai_fields()	2026-02-19 14:18:02.664252	2026-02-19 14:18:02.664252
\.


--
-- Data for Name: ir_actions_todo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_actions_todo (id, action_id, sequence, create_uid, write_uid, state, name, create_date, write_date) FROM stdin;
1	3	100	1	1	done	Open Menu	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
2	51	1	1	1	done	Demo Failure Notification	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
\.


--
-- Data for Name: ir_asset; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_asset (id, sequence, create_uid, write_uid, name, bundle, directive, path, target, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_attachment; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_attachment (id, res_id, company_id, file_size, create_uid, write_uid, name, res_model, res_field, type, url, access_token, store_fname, checksum, mimetype, description, index_content, public, create_date, write_date, db_datas, original_id) FROM stdin;
1	3	1	9152	1	1	flag_image	res.lang	flag_image	binary	\N	\N	44/44d1661b24fa9f688091c8256535434b60aafba7	44d1661b24fa9f688091c8256535434b60aafba7	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
2	65	1	15497	1	1	flag_image	res.lang	flag_image	binary	\N	\N	62/627090759f9a66678c28c1bc3c3039b37f40f66e	627090759f9a66678c28c1bc3c3039b37f40f66e	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
3	11	1	192	1	1	flag_image	res.lang	flag_image	binary	\N	\N	05/055ffc5cce56e142234ffc466012dff7edc2c7e7	055ffc5cce56e142234ffc466012dff7edc2c7e7	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
4	1	1	11445	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
5	1	1	11445	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
6	1	1	11445	1	1	image_512	res.partner	image_512	binary	\N	\N	b6/b6a3cdaa2cec346455710636e1f000edcff7d706	b6a3cdaa2cec346455710636e1f000edcff7d706	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
7	1	1	12556	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0ce8c97df3ec768af51696ede284aac75b0eec18	0ce8c97df3ec768af51696ede284aac75b0eec18	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
8	1	1	5254	1	1	image_128	res.partner	image_128	binary	\N	\N	60/60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	60a2a24a2fcfd3b3045bbaa75c5d68815df9d541	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
9	1	1	2063	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	b7/b73a9deb85def8a1a00e4d545c4f79747d78f487	b73a9deb85def8a1a00e4d545c4f79747d78f487	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
10	15	1	2282	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	3d/3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	3d7a7360fe4a73a90dd3b4ba554a9254ed61e864	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
11	16	1	4667	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	1c/1c2a8239bc7e06429116c40bc1d1334c621ca379	1c2a8239bc7e06429116c40bc1d1334c621ca379	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
12	6	1	63193	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
13	3	1	68639	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
14	7	1	52528	1	1	image_1920	res.partner	image_1920	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
15	6	1	63193	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
16	3	1	68639	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
17	7	1	52528	1	1	image_1024	res.partner	image_1024	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
18	6	1	63193	1	1	image_512	res.partner	image_512	binary	\N	\N	0b/0b32d4522cb499add9801adc8434f054e0813df4	0b32d4522cb499add9801adc8434f054e0813df4	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
19	3	1	68639	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dad37b86834762b1ad101dc33be7903560ec598	7dad37b86834762b1ad101dc33be7903560ec598	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
20	7	1	52528	1	1	image_512	res.partner	image_512	binary	\N	\N	70/7095c30dec0fc371a399eb7dbfceea96319fa702	7095c30dec0fc371a399eb7dbfceea96319fa702	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
21	6	1	52447	1	1	image_256	res.partner	image_256	binary	\N	\N	54/541590d82737cc97075b4d26e20dd2279c7bdddb	541590d82737cc97075b4d26e20dd2279c7bdddb	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
22	3	1	38672	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88fde30360b832576cfb405e1803f323701cb481	88fde30360b832576cfb405e1803f323701cb481	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
23	7	1	43536	1	1	image_256	res.partner	image_256	binary	\N	\N	19/191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	191d9f5b897c2724d0fd3dd97cbf9376b21fa1c3	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
24	6	1	16870	1	1	image_128	res.partner	image_128	binary	\N	\N	fe/feec584f963736452b620ab99d007a7472d50e4d	feec584f963736452b620ab99d007a7472d50e4d	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
25	3	1	15206	1	1	image_128	res.partner	image_128	binary	\N	\N	f6/f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	f6ef5c3e4f6b0bb9264106dfa871c53b8ccbaf73	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
26	7	1	15699	1	1	image_128	res.partner	image_128	binary	\N	\N	24/24ffb3e8122416b93bcd50cc67ac33799d047501	24ffb3e8122416b93bcd50cc67ac33799d047501	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
27	8	1	8135	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
28	9	1	7131	1	1	image_1920	res.partner	image_1920	binary	\N	\N	08/080fb87aed474669e45b87f7c25ae51a9bb11f93	080fb87aed474669e45b87f7c25ae51a9bb11f93	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
29	10	1	6301	1	1	image_1920	res.partner	image_1920	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
30	11	1	13440	1	1	image_1920	res.partner	image_1920	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
31	12	1	4724	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
32	13	1	1963	1	1	image_1920	res.partner	image_1920	binary	\N	\N	9b/9b7b3069a8339084a0e07359b08ae722b50bd378	9b7b3069a8339084a0e07359b08ae722b50bd378	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
33	14	1	4755	1	1	image_1920	res.partner	image_1920	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
34	15	1	1464	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
35	16	1	1277	1	1	image_1920	res.partner	image_1920	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
36	17	1	3598	1	1	image_1920	res.partner	image_1920	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
37	18	1	4752	1	1	image_1920	res.partner	image_1920	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
38	19	1	4896	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
39	20	1	5433	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
40	21	1	5422	1	1	image_1920	res.partner	image_1920	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
41	22	1	5615	1	1	image_1920	res.partner	image_1920	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
42	23	1	5616	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
43	24	1	5084	1	1	image_1920	res.partner	image_1920	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
44	25	1	23707	1	1	image_1920	res.partner	image_1920	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
45	26	1	6322	1	1	image_1920	res.partner	image_1920	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
46	27	1	4563	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
47	28	1	4105	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
48	29	1	4513	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
49	30	1	4051	1	1	image_1920	res.partner	image_1920	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
50	31	1	4726	1	1	image_1920	res.partner	image_1920	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
51	32	1	6516	1	1	image_1920	res.partner	image_1920	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
52	33	1	4410	1	1	image_1920	res.partner	image_1920	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
53	34	1	5157	1	1	image_1920	res.partner	image_1920	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
54	35	1	6492	1	1	image_1920	res.partner	image_1920	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
55	36	1	4291	1	1	image_1920	res.partner	image_1920	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
56	37	1	3767	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
57	38	1	4857	1	1	image_1920	res.partner	image_1920	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
58	39	1	4612	1	1	image_1920	res.partner	image_1920	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
59	40	1	3200	1	1	image_1920	res.partner	image_1920	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
60	41	1	18074	1	1	image_1920	res.partner	image_1920	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
61	8	1	8135	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
62	9	1	7131	1	1	image_1024	res.partner	image_1024	binary	\N	\N	08/080fb87aed474669e45b87f7c25ae51a9bb11f93	080fb87aed474669e45b87f7c25ae51a9bb11f93	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
63	10	1	6301	1	1	image_1024	res.partner	image_1024	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
64	11	1	13440	1	1	image_1024	res.partner	image_1024	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
65	12	1	4724	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
66	13	1	1963	1	1	image_1024	res.partner	image_1024	binary	\N	\N	9b/9b7b3069a8339084a0e07359b08ae722b50bd378	9b7b3069a8339084a0e07359b08ae722b50bd378	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
67	14	1	4755	1	1	image_1024	res.partner	image_1024	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
68	15	1	1464	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
69	16	1	1277	1	1	image_1024	res.partner	image_1024	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
70	17	1	3598	1	1	image_1024	res.partner	image_1024	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
71	18	1	4752	1	1	image_1024	res.partner	image_1024	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
72	19	1	4896	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
73	20	1	5433	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
74	21	1	5422	1	1	image_1024	res.partner	image_1024	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
75	22	1	5615	1	1	image_1024	res.partner	image_1024	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
76	23	1	5616	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
77	24	1	5084	1	1	image_1024	res.partner	image_1024	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
78	25	1	23707	1	1	image_1024	res.partner	image_1024	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
79	26	1	6322	1	1	image_1024	res.partner	image_1024	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
80	27	1	4563	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
81	28	1	4105	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
82	29	1	4513	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
83	30	1	4051	1	1	image_1024	res.partner	image_1024	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
84	31	1	4726	1	1	image_1024	res.partner	image_1024	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
85	32	1	6516	1	1	image_1024	res.partner	image_1024	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
86	33	1	4410	1	1	image_1024	res.partner	image_1024	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
87	34	1	5157	1	1	image_1024	res.partner	image_1024	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
88	35	1	6492	1	1	image_1024	res.partner	image_1024	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
89	36	1	4291	1	1	image_1024	res.partner	image_1024	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
90	37	1	3767	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
91	38	1	4857	1	1	image_1024	res.partner	image_1024	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
92	39	1	4612	1	1	image_1024	res.partner	image_1024	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
93	40	1	3200	1	1	image_1024	res.partner	image_1024	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
94	41	1	18074	1	1	image_1024	res.partner	image_1024	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
95	8	1	8135	1	1	image_512	res.partner	image_512	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
96	9	1	7131	1	1	image_512	res.partner	image_512	binary	\N	\N	08/080fb87aed474669e45b87f7c25ae51a9bb11f93	080fb87aed474669e45b87f7c25ae51a9bb11f93	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
97	10	1	6301	1	1	image_512	res.partner	image_512	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
98	11	1	13440	1	1	image_512	res.partner	image_512	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
99	12	1	4724	1	1	image_512	res.partner	image_512	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
100	13	1	1963	1	1	image_512	res.partner	image_512	binary	\N	\N	9b/9b7b3069a8339084a0e07359b08ae722b50bd378	9b7b3069a8339084a0e07359b08ae722b50bd378	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
101	14	1	4755	1	1	image_512	res.partner	image_512	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
102	15	1	1464	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
103	16	1	1277	1	1	image_512	res.partner	image_512	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
104	17	1	3598	1	1	image_512	res.partner	image_512	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
105	18	1	4752	1	1	image_512	res.partner	image_512	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
106	19	1	4896	1	1	image_512	res.partner	image_512	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
107	20	1	5433	1	1	image_512	res.partner	image_512	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
108	21	1	5422	1	1	image_512	res.partner	image_512	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
109	22	1	5615	1	1	image_512	res.partner	image_512	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
110	23	1	5616	1	1	image_512	res.partner	image_512	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
111	24	1	5084	1	1	image_512	res.partner	image_512	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
112	25	1	23707	1	1	image_512	res.partner	image_512	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
113	26	1	6322	1	1	image_512	res.partner	image_512	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
114	27	1	4563	1	1	image_512	res.partner	image_512	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
115	28	1	4105	1	1	image_512	res.partner	image_512	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
116	29	1	4513	1	1	image_512	res.partner	image_512	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
117	30	1	4051	1	1	image_512	res.partner	image_512	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
118	31	1	4726	1	1	image_512	res.partner	image_512	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
119	32	1	6516	1	1	image_512	res.partner	image_512	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
120	33	1	4410	1	1	image_512	res.partner	image_512	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
121	34	1	5157	1	1	image_512	res.partner	image_512	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
122	35	1	6492	1	1	image_512	res.partner	image_512	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
123	36	1	4291	1	1	image_512	res.partner	image_512	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
124	37	1	3767	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
125	38	1	4857	1	1	image_512	res.partner	image_512	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
126	39	1	4612	1	1	image_512	res.partner	image_512	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
127	40	1	3200	1	1	image_512	res.partner	image_512	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
128	41	1	18074	1	1	image_512	res.partner	image_512	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
129	8	1	8135	1	1	image_256	res.partner	image_256	binary	\N	\N	ff/ff935642b2614b9bd605477e981462e8e546b2fb	ff935642b2614b9bd605477e981462e8e546b2fb	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
130	9	1	7131	1	1	image_256	res.partner	image_256	binary	\N	\N	08/080fb87aed474669e45b87f7c25ae51a9bb11f93	080fb87aed474669e45b87f7c25ae51a9bb11f93	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
131	10	1	6301	1	1	image_256	res.partner	image_256	binary	\N	\N	59/5977bb7dc56273c59d98908bbc7dcade24f74e7d	5977bb7dc56273c59d98908bbc7dcade24f74e7d	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
132	11	1	13440	1	1	image_256	res.partner	image_256	binary	\N	\N	cb/cb188695911c6e9b4a062d657d28f0ffda09ec35	cb188695911c6e9b4a062d657d28f0ffda09ec35	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
133	12	1	4724	1	1	image_256	res.partner	image_256	binary	\N	\N	7e/7e9c74ee79fce91ce5bbeda21908cf247794f978	7e9c74ee79fce91ce5bbeda21908cf247794f978	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
134	13	1	1963	1	1	image_256	res.partner	image_256	binary	\N	\N	9b/9b7b3069a8339084a0e07359b08ae722b50bd378	9b7b3069a8339084a0e07359b08ae722b50bd378	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
135	14	1	4755	1	1	image_256	res.partner	image_256	binary	\N	\N	5c/5caed90cc123cc1ce20716209a610d910ebcd0c5	5caed90cc123cc1ce20716209a610d910ebcd0c5	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
136	15	1	1464	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
137	16	1	1277	1	1	image_256	res.partner	image_256	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
138	17	1	3598	1	1	image_256	res.partner	image_256	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
139	18	1	4752	1	1	image_256	res.partner	image_256	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
140	19	1	4896	1	1	image_256	res.partner	image_256	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
141	20	1	5433	1	1	image_256	res.partner	image_256	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
142	21	1	5422	1	1	image_256	res.partner	image_256	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
143	22	1	5615	1	1	image_256	res.partner	image_256	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
144	23	1	5616	1	1	image_256	res.partner	image_256	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
145	24	1	5084	1	1	image_256	res.partner	image_256	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
146	25	1	23707	1	1	image_256	res.partner	image_256	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
147	26	1	6322	1	1	image_256	res.partner	image_256	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
148	27	1	4563	1	1	image_256	res.partner	image_256	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
149	28	1	4105	1	1	image_256	res.partner	image_256	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
150	29	1	4513	1	1	image_256	res.partner	image_256	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
151	30	1	4051	1	1	image_256	res.partner	image_256	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
152	31	1	4726	1	1	image_256	res.partner	image_256	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
153	32	1	6516	1	1	image_256	res.partner	image_256	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
154	33	1	4410	1	1	image_256	res.partner	image_256	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
155	34	1	5157	1	1	image_256	res.partner	image_256	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
156	35	1	6492	1	1	image_256	res.partner	image_256	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
157	36	1	4291	1	1	image_256	res.partner	image_256	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
158	37	1	3767	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
159	38	1	4857	1	1	image_256	res.partner	image_256	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
160	39	1	4612	1	1	image_256	res.partner	image_256	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
161	40	1	3200	1	1	image_256	res.partner	image_256	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
162	41	1	18074	1	1	image_256	res.partner	image_256	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
163	8	1	10323	1	1	image_128	res.partner	image_128	binary	\N	\N	82/823b20bb764aaf8fcb88134b9bb3d82a05dea84a	823b20bb764aaf8fcb88134b9bb3d82a05dea84a	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
164	9	1	10692	1	1	image_128	res.partner	image_128	binary	\N	\N	93/93624f0fccfa00c1ad177ebb764526eaab850012	93624f0fccfa00c1ad177ebb764526eaab850012	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
165	10	1	8472	1	1	image_128	res.partner	image_128	binary	\N	\N	1d/1d695025b620cc90bd115824dbd8c6722fde6506	1d695025b620cc90bd115824dbd8c6722fde6506	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
166	11	1	15232	1	1	image_128	res.partner	image_128	binary	\N	\N	48/48c74e0562a9887fccde6079b766c08ba86a2069	48c74e0562a9887fccde6079b766c08ba86a2069	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
167	12	1	5510	1	1	image_128	res.partner	image_128	binary	\N	\N	a1/a1600097a74b7d4407c60f4ae1f5fa425c521e52	a1600097a74b7d4407c60f4ae1f5fa425c521e52	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
168	13	1	1112	1	1	image_128	res.partner	image_128	binary	\N	\N	64/64c4621d9b82d0e3d985d2614bbbe803d0163b2d	64c4621d9b82d0e3d985d2614bbbe803d0163b2d	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
169	14	1	4258	1	1	image_128	res.partner	image_128	binary	\N	\N	dc/dcb6d977c85554329430b436ff900158de14160c	dcb6d977c85554329430b436ff900158de14160c	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
170	15	1	1464	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0cffbaa48243465315e779fb34e9b11f3b24aec2	0cffbaa48243465315e779fb34e9b11f3b24aec2	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
171	16	1	1277	1	1	image_128	res.partner	image_128	binary	\N	\N	34/344411fee70a44e6558ebd36f3a0857ce7a973a3	344411fee70a44e6558ebd36f3a0857ce7a973a3	image/png	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
172	17	1	3598	1	1	image_128	res.partner	image_128	binary	\N	\N	2b/2bbfba99b1749239c49d753f9b8fca48490d370a	2bbfba99b1749239c49d753f9b8fca48490d370a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
173	18	1	4752	1	1	image_128	res.partner	image_128	binary	\N	\N	24/2470aa607bdf1f128394703173f150fcc671f746	2470aa607bdf1f128394703173f150fcc671f746	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
174	19	1	4896	1	1	image_128	res.partner	image_128	binary	\N	\N	e6/e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	e6e0c664f9d9c4a3cda34fd1c67117e31b87cd68	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
175	20	1	5433	1	1	image_128	res.partner	image_128	binary	\N	\N	b8/b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	b8e80fa6386f7e827ed68466f0dcdede5e6aaa2e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
176	21	1	5422	1	1	image_128	res.partner	image_128	binary	\N	\N	e1/e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	e1e1059a01d6e0b0eb2c934cf023d70bfa5ebfcd	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
177	22	1	5615	1	1	image_128	res.partner	image_128	binary	\N	\N	1f/1f3b37adc61b802fb704cbd1202bafeb55b9e91d	1f3b37adc61b802fb704cbd1202bafeb55b9e91d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
178	23	1	5616	1	1	image_128	res.partner	image_128	binary	\N	\N	6a/6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	6aba4dd7477ebcee9d86feaad8e3cf4828d5321c	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
179	24	1	5084	1	1	image_128	res.partner	image_128	binary	\N	\N	88/88a7693befb72024fccf723230df1eaa90a35658	88a7693befb72024fccf723230df1eaa90a35658	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
180	25	1	23707	1	1	image_128	res.partner	image_128	binary	\N	\N	0c/0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	0c78f98ea899bf4e50afdbc01263fcc9fd0a3206	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
181	26	1	6322	1	1	image_128	res.partner	image_128	binary	\N	\N	6c/6c9541e39119d72b2a5707076f90f7f3eab3ea32	6c9541e39119d72b2a5707076f90f7f3eab3ea32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
182	27	1	4563	1	1	image_128	res.partner	image_128	binary	\N	\N	8b/8bcd1ed212fb444a25a01a0316c702e121384935	8bcd1ed212fb444a25a01a0316c702e121384935	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
183	28	1	4105	1	1	image_128	res.partner	image_128	binary	\N	\N	b2/b29e8936556376421844858012fc6c634f96752d	b29e8936556376421844858012fc6c634f96752d	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
184	29	1	4513	1	1	image_128	res.partner	image_128	binary	\N	\N	d6/d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	d694aedb3fd293b0ad70a7ee7cbc4c0918d51d21	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
185	30	1	4051	1	1	image_128	res.partner	image_128	binary	\N	\N	c8/c8fd583925c09ec326a3b997cd044a0ad7636db7	c8fd583925c09ec326a3b997cd044a0ad7636db7	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
186	31	1	4726	1	1	image_128	res.partner	image_128	binary	\N	\N	f0/f0068698d805597da85a9b9a5e24888373dc2168	f0068698d805597da85a9b9a5e24888373dc2168	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
187	32	1	6516	1	1	image_128	res.partner	image_128	binary	\N	\N	ce/cebcd6a1510ed163049e1ac0b81e3eec738ee7de	cebcd6a1510ed163049e1ac0b81e3eec738ee7de	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
188	33	1	4410	1	1	image_128	res.partner	image_128	binary	\N	\N	18/180ea12a2fb2289fcfcedea56049c17a840a0736	180ea12a2fb2289fcfcedea56049c17a840a0736	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
189	34	1	5157	1	1	image_128	res.partner	image_128	binary	\N	\N	63/63d4ba80def55da294e5ecc6a94b9d450860cb65	63d4ba80def55da294e5ecc6a94b9d450860cb65	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
190	35	1	6492	1	1	image_128	res.partner	image_128	binary	\N	\N	52/52430a11dd26a23a0ce513777909d4fcfb9c395a	52430a11dd26a23a0ce513777909d4fcfb9c395a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
191	36	1	4291	1	1	image_128	res.partner	image_128	binary	\N	\N	58/58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	58a54b94f7ed9dcb9f1d2baa8a5e385f3abe0597	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
192	37	1	3767	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7dbfe519d334d518b6f8c8e3afcafec5e758112e	7dbfe519d334d518b6f8c8e3afcafec5e758112e	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
193	38	1	4857	1	1	image_128	res.partner	image_128	binary	\N	\N	06/06a538b8b393cede62a0c00a4e683e54b1268441	06a538b8b393cede62a0c00a4e683e54b1268441	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
194	39	1	4612	1	1	image_128	res.partner	image_128	binary	\N	\N	7d/7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	7d2eb6cad924d15a60cf92bad5f00a6685dd29ac	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
195	40	1	3200	1	1	image_128	res.partner	image_128	binary	\N	\N	d5/d5a76a0e9e771e444c01717e50b65e667040330a	d5a76a0e9e771e444c01717e50b65e667040330a	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
196	41	1	18074	1	1	image_128	res.partner	image_128	binary	\N	\N	8a/8ab946e90d0263f19993389417ff2b0779c34b32	8ab946e90d0263f19993389417ff2b0779c34b32	image/jpeg	\N	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463	\N	\N
197	\N	1	\N	1	1	placeholder.png	\N	\N	url	/web/static/img/placeholder.png	\N	\N	\N	image/png	\N	\N	t	2026-02-19 14:17:52.907935	2026-02-19 14:17:52.907935	\N	\N
198	\N	1	854	1	1	res.company.scss	\N	\N	binary	web/static/asset_styles_company_report.scss	\N	54/542922906caac0fe5d253e2c7d913758eb0a7f6e	542922906caac0fe5d253e2c7d913758eb0a7f6e	text/scss	\N	                // Simplified color-contrast function to replicate bootstrap in report preview.\n                @function preview-color-contrast($background) {\n                    @if (lightness($background) > 50) {\n                        @return black;\n                    } @else {\n                        @return white;\n                    }\n                }\n                .o_company_1_layout {\n                    font-family: Lato;\n                    h2 {\n                        color: #212529;\n                    }\n                    #informations strong {\n                        color: #212529;\n                    }\n                    .o_total strong {\n                        color: #212529;\n                    }\n                    .o_company_tagline {\n                        color: #212529\n                    }\n            }	\N	2026-02-19 14:17:52.907935	2026-02-19 14:17:52.907935	\N	\N
199	2	1	25613	1	1	image_1920	res.partner	image_1920	binary	\N	\N	c7/c7a775ae75785d5acee7edb5b8c748fef61ef8d4	c7a775ae75785d5acee7edb5b8c748fef61ef8d4	image/png	\N	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
200	2	1	25613	1	1	image_1024	res.partner	image_1024	binary	\N	\N	c7/c7a775ae75785d5acee7edb5b8c748fef61ef8d4	c7a775ae75785d5acee7edb5b8c748fef61ef8d4	image/png	\N	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
201	2	1	25613	1	1	image_512	res.partner	image_512	binary	\N	\N	c7/c7a775ae75785d5acee7edb5b8c748fef61ef8d4	c7a775ae75785d5acee7edb5b8c748fef61ef8d4	image/png	\N	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
202	2	1	11405	1	1	image_256	res.partner	image_256	binary	\N	\N	88/882cf6e5697903fd69b7700f5e51fd15096d136c	882cf6e5697903fd69b7700f5e51fd15096d136c	image/png	\N	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
203	2	1	5202	1	1	image_128	res.partner	image_128	binary	\N	\N	36/36ba5ef36880a809f9bdddfe35f12fcf34406a6e	36ba5ef36880a809f9bdddfe35f12fcf34406a6e	image/png	\N	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
204	72	1	1796	1	1	web_icon_data	ir.ui.menu	web_icon_data	binary	\N	\N	74/744fc247b813c44f4cf02357706e88b283cb0f97	744fc247b813c44f4cf02357706e88b283cb0f97	image/png	\N	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872	\N	\N
205	42	1	2226	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
206	43	1	2226	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
208	44	1	2226	1	1	image_1920	res.partner	image_1920	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
209	42	1	2226	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
210	43	1	2226	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
211	44	1	2226	1	1	image_1024	res.partner	image_1024	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
212	42	1	2226	1	1	image_512	res.partner	image_512	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
213	43	1	2226	1	1	image_512	res.partner	image_512	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
214	44	1	2226	1	1	image_512	res.partner	image_512	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
215	42	1	2226	1	1	image_256	res.partner	image_256	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
216	43	1	2226	1	1	image_256	res.partner	image_256	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
217	44	1	2226	1	1	image_256	res.partner	image_256	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
218	42	1	2226	1	1	image_128	res.partner	image_128	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
219	43	1	2226	1	1	image_128	res.partner	image_128	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
220	44	1	2226	1	1	image_128	res.partner	image_128	binary	\N	\N	b0/b0604346460254a567c648e09db0de4201099150	b0604346460254a567c648e09db0de4201099150	image/png	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
207	1	1	76124	1	1	Odoo Enterprise Agreement.pdf	ai.agent.source	\N	binary	\N	\N	cb/cbc47a88e5412ac84c30efacbbe9e6f69807dcd9	cbc47a88e5412ac84c30efacbbe9e6f69807dcd9	application/pdf;base64	\N	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901	\N	\N
\.


--
-- Data for Name: ir_config_parameter; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_config_parameter (id, create_uid, write_uid, key, value, create_date, write_date) FROM stdin;
4	1	1	web.base.url	http://localhost:8069	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
5	1	1	base.login_cooldown_after	10	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
6	1	1	base.login_cooldown_duration	60	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
7	1	1	base.template_portal_user_id	4	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
8	1	1	base.default_max_email_size	10	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
1	1	1	database.secret	0ef21fc7-90c6-4c31-af14-f9a2734661d2	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
2	1	1	database.uuid	c5ab2eb8-0d9d-11f1-9a91-fa21005cdd9b	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
3	1	1	database.create_date	2026-02-19 14:17:50	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
9	1	1	base_setup.show_effect	True	2026-02-19 14:17:54.518519	2026-02-19 14:17:54.518519
10	1	1	ribbon.name	TEST<br/>({db_name})	2026-02-19 14:17:54.933447	2026-02-19 14:17:54.933447
11	1	1	ribbon.color	#f0f0f0	2026-02-19 14:17:54.933447	2026-02-19 14:17:54.933447
12	1	1	ribbon.background.color	rgba(255,0,0,.6)	2026-02-19 14:17:54.933447	2026-02-19 14:17:54.933447
13	1	1	mail.activity.gc.delete_overdue_years	3	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
14	1	1	mail.restrict.template.rendering	1	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
15	1	1	auth_signup.invitation_scope	b2c	2026-02-19 14:17:58.885671	2026-02-19 14:17:58.885671
16	1	1	auth_signup.reset_password	True	2026-02-19 14:17:58.885671	2026-02-19 14:17:58.885671
17	1	1	iap_extract_endpoint	https://extract.api.odoo.com	2026-02-19 14:18:00.368862	2026-02-19 14:18:00.368862
18	1	1	mail_mobile.enable_ocn	True	2026-02-19 14:18:00.418522	2026-02-19 14:18:00.418522
19	1	1	saas_client.allow_bypass_on_production	True	2026-02-19 14:18:00.684409	2026-02-19 14:18:00.684409
20	1	1	server_mode.ribbon_name	DEMO 19	2026-02-19 14:18:00.684409	2026-02-19 14:18:00.684409
\.


--
-- Data for Name: ir_cron; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron (id, ir_actions_server_id, user_id, interval_number, priority, failure_count, create_uid, write_uid, cron_name, interval_type, active, nextcall, lastcall, first_failure_date, create_date, write_date) FROM stdin;
1	35	1	1	3	0	1	1	Base: Auto-vacuum internal data	days	t	2026-02-19 14:17:48	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:56.616872
2	36	1	1	8	0	1	1	Base: Portal Users Deletion	days	t	2026-02-19 14:17:48	\N	\N	2026-02-19 14:17:42.822463	2026-02-19 14:17:56.616872
3	117	1	1	6	0	1	1	Mail: Email Queue Manager	hours	t	2026-02-19 14:17:57	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
4	118	1	1	1000	0	1	1	Publisher: Update Notification	weeks	t	2026-02-26 14:17:57	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
5	119	1	1	5	0	1	1	Notification: Delete Notifications older than 6 Months	months	t	2026-02-19 14:17:57	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
6	120	1	5	5	0	1	1	Mail: Fetchmail Service	minutes	f	2026-02-19 14:17:57	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
7	121	1	1	5	0	1	1	Mail: Post scheduled messages	days	t	2026-02-19 14:17:57	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
8	122	1	1	5	0	1	1	Notification: Notify scheduled messages	hours	t	2026-02-19 14:17:57	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
9	123	1	1	5	0	1	1	Mail: send web push notification	days	t	2026-02-19 14:17:57	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
10	124	1	1	5	0	1	1	Discuss: channel member unmute	days	t	2026-02-19 14:17:57	\N	\N	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
11	138	1	1	6	0	1	1	Users: Notify About Unregistered Users	days	t	2026-02-19 14:17:58	\N	\N	2026-02-19 14:17:58.885671	2026-02-19 14:17:58.885671
12	152	1	24	5	0	1	1	SMS: SMS Queue Manager	hours	t	2026-02-19 14:18:01	\N	\N	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
13	161	1	24	5	0	1	1	Snailmail: process letters queue	hours	t	2026-02-19 14:18:01	\N	\N	2026-02-19 14:18:01.593522	2026-02-19 14:18:01.593522
14	173	1	9999	5	0	1	1	AI Embedding: Generate Embeddings	months	t	2026-02-19 14:18:02	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
15	174	1	9999	5	0	1	1	AI Agent Sources: Process Sources	months	t	2026-02-19 14:18:02	\N	\N	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
16	175	1	1	5	0	1	1	AI Fields: Compute AI fields	days	t	2026-02-19 14:18:03	\N	\N	2026-02-19 14:18:02.664252	2026-02-19 14:18:02.664252
\.


--
-- Data for Name: ir_cron_progress; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_progress (id, cron_id, remaining, done, timed_out_counter, create_uid, write_uid, deactivate, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_cron_trigger; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_cron_trigger (id, cron_id, create_uid, write_uid, call_at, create_date, write_date) FROM stdin;
1	14	1	1	2026-02-19 14:18:02	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
2	1	1	1	2026-02-19 14:19:03.573783	2026-02-19 14:18:03.48102	2026-02-19 14:18:03.48102
\.


--
-- Data for Name: ir_default; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_default (id, field_id, user_id, company_id, create_uid, write_uid, condition, "json_value", create_date, write_date) FROM stdin;
1	1014	\N	\N	1	1	\N	"en_US"	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
\.


--
-- Data for Name: ir_demo; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure (id, module_id, wizard_id, create_uid, write_uid, error, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_demo_failure_wizard; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_demo_failure_wizard (id, create_uid, write_uid, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_embedded_actions; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_embedded_actions (id, sequence, parent_action_id, parent_res_id, action_id, user_id, create_uid, write_uid, parent_res_model, python_method, default_view_mode, domain, context, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_embedded_actions_res_groups_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_embedded_actions_res_groups_rel (ir_embedded_actions_id, res_groups_id) FROM stdin;
\.


--
-- Data for Name: ir_exports; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports (id, create_uid, write_uid, name, resource, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_exports_line; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_exports_line (id, export_id, create_uid, write_uid, name, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_filters; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_filters (id, action_id, embedded_action_id, embedded_parent_res_id, create_uid, write_uid, name, sort, model_id, domain, context, is_default, active, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_filters_res_users_rel; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_filters_res_users_rel (ir_filters_id, res_users_id) FROM stdin;
\.


--
-- Data for Name: ir_logging; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_logging (id, create_uid, write_uid, name, type, dbname, level, path, func, line, message, create_date, write_date) FROM stdin;
\.


--
-- Data for Name: ir_mail_server; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_mail_server (id, smtp_port, sequence, create_uid, write_uid, name, from_filter, smtp_host, smtp_authentication, smtp_user, smtp_pass, smtp_encryption, smtp_debug, active, create_date, write_date, max_email_size, smtp_ssl_certificate, smtp_ssl_private_key, owner_user_id, owner_limit_count, owner_limit_time, google_gmail_access_token_expiration, google_gmail_refresh_token, google_gmail_access_token, microsoft_outlook_access_token_expiration, microsoft_outlook_refresh_token, microsoft_outlook_access_token) FROM stdin;
\.


--
-- Data for Name: ir_model; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model (id, create_uid, write_uid, model, "order", state, fold_name, name, info, abstract, transient, create_date, write_date, is_mail_thread, is_mail_activity, is_mail_blacklist) FROM stdin;
54	\N	\N	ir.qweb.field.one2many	id	base	fold	{"en_US": "Qweb field one2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
2	\N	\N	_unknown	id	base	fold	{"en_US": "Unknown", "es_419": "Desconocido"}	\n    Abstract model used as a substitute for relational fields with an unknown\n    comodel.\n    	t	f	\N	\N	f	f	f
6	\N	\N	ir.model.fields.selection	sequence, id	base	fold	{"en_US": "Fields Selection", "es_419": "Selección de campos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
10	\N	\N	ir.model.data	module, model, name	base	fold	{"en_US": "Model Data", "es_419": "Datos del modelo"}	Holds external identifier keys for records in the database.\n       This has two main uses:\n\n           * allows easy data integration with third-party systems,\n             making import/export/sync of data possible, as records\n             can be uniquely identified across multiple systems\n           * allows tracking the origin of data installed by Odoo\n             modules themselves, thus making it possible to later\n             update them seamlessly.\n    	f	f	\N	\N	f	f	f
23	\N	\N	server.action.history.wizard	id	base	fold	{"en_US": "Server Action History Wizard", "es_419": "Asistente de historial de acciones del servidor"}	 A wizard to compare and reset server action code. 	f	t	\N	\N	f	f	f
24	\N	\N	ir.actions.server.history	create_date desc, id desc	base	fold	{"en_US": "Server Action History", "es_419": "Historial de acciones del servidor"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
28	\N	\N	ir.embedded.actions	sequence, id	base	fold	{"en_US": "Embedded Actions", "es_419": "Acciones incrustadas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
33	\N	\N	ir.cron.trigger	id	base	fold	{"en_US": "Triggered actions", "es_419": "Acciones activadas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
35	\N	\N	ir.filters	model_id, name, id desc	base	fold	{"en_US": "Filters", "es_419": "Filtros"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
37	\N	\N	ir.exports	name, id	base	fold	{"en_US": "Exports", "es_419": "Exportaciones"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
38	\N	\N	ir.exports.line	id	base	fold	{"en_US": "Exports Line", "es_419": "Línea de exportaciones"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
43	\N	\N	ir.fields.converter	id	base	fold	{"en_US": "Fields Converter", "es_419": "Convertidor de campos"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
47	\N	\N	ir.qweb.field.float	id	base	fold	{"en_US": "Qweb Field Float", "es_419": "Campo Qweb flotante"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
48	\N	\N	ir.qweb.field.date	id	base	fold	{"en_US": "Qweb Field Date", "es_419": "Campo Qweb de fecha"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
49	\N	\N	ir.qweb.field.datetime	id	base	fold	{"en_US": "Qweb Field Datetime", "es_419": "Campo Qweb de fecha y hora"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
50	\N	\N	ir.qweb.field.text	id	base	fold	{"en_US": "Qweb Field Text", "es_419": "Campo Qweb de texto"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
51	\N	\N	ir.qweb.field.selection	id	base	fold	{"en_US": "Qweb Field Selection", "es_419": "Campo Qweb de selección"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
52	\N	\N	ir.qweb.field.many2one	id	base	fold	{"en_US": "Qweb Field Many to One", "es_419": "Campo Qweb Many2One"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
88	\N	\N	format.address.mixin	id	base	fold	{"en_US": "Address Format", "es_419": "Formato de dirección"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
82	\N	\N	avatar.mixin	id	base	fold	{"en_US": "Avatar Mixin", "es_419": "Mixin del avatar"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
83	\N	\N	res.country	name, id	base	fold	{"en_US": "Country", "es_419": "País"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
84	\N	\N	res.country.group	id	base	fold	{"en_US": "Country Group", "es_419": "Grupo del país"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
85	\N	\N	res.country.state	code, id	base	fold	{"en_US": "Country state", "es_419": "Estado"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
86	\N	\N	res.lang	active desc,name	base	fold	{"en_US": "Languages", "es_419": "Idiomas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
89	\N	\N	res.partner.category	name, id	base	fold	{"en_US": "Partner Tags", "es_419": "Etiquetas del contacto"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
91	\N	\N	res.partner.industry	name, id	base	fold	{"en_US": "Industry", "es_419": "Industria"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
93	\N	\N	res.partner.bank	sequence, id	base	fold	{"en_US": "Bank Accounts", "es_419": "Cuentas bancarias"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
94	\N	\N	res.config	id	base	fold	{"en_US": "Config", "es_419": "Configuración"}	 Base classes for new-style configuration items\n\n    Configuration items should inherit from this class, implement\n    the execute method (and optionally the cancel one) and have\n    their view inherit from the related res_config_view_base view.\n    	f	t	\N	\N	f	f	f
96	\N	\N	res.currency	active desc, name	base	fold	{"en_US": "Currency", "es_419": "Moneda"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
97	\N	\N	res.currency.rate	name desc, id	base	fold	{"en_US": "Currency Rate", "es_419": "Tasa de cambio"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
99	\N	\N	res.groups.privilege	sequence, name, id	base	fold	{"en_US": "Privileges", "es_419": "Privilegios"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
101	\N	\N	res.users.log	id desc	base	fold	{"en_US": "Users Log", "es_419": "Registro de usuarios"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
103	\N	\N	res.users.identitycheck	id	base	fold	{"en_US": "Password Check Wizard", "es_419": "Asistente de verificación de contraseñas"}	 Wizard used to re-check the user's credentials (password) and eventually\n    revoke access to his account to every device he has an active session on.\n\n    Might be useful before the more security-sensitive operations, users might be\n    leaving their computer unlocked & unattended. Re-checking credentials mitigates\n    some of the risk of a third party using such an unattended device to manipulate\n    the account.\n    	f	t	\N	\N	f	f	f
104	\N	\N	change.password.wizard	id	base	fold	{"en_US": "Change Password Wizard", "es_419": "Asistente para cambiar contraseña"}	 A wizard to manage the change of users' passwords. 	f	t	\N	\N	f	f	f
105	\N	\N	change.password.user	id	base	fold	{"en_US": "User, Change Password Wizard", "es_419": "Usuario, asistente de cambio de contraseña"}	 A model to configure users in the change password wizard. 	f	t	\N	\N	f	f	f
106	\N	\N	change.password.own	id	base	fold	{"en_US": "User, change own password wizard", "es_419": "Usuario, asistente de cambio de contraseña propia"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
107	\N	\N	res.users.apikeys	id	base	fold	{"en_US": "Users API Keys", "es_419": "Claves API de los usuarios"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
108	\N	\N	res.users.apikeys.description	id	base	fold	{"en_US": "API Key Description", "es_419": "Descripción de la clave API"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
17	\N	\N	ir.asset	sequence, id	base	fold	{"en_US": "Asset", "es_419": "Activo"}	This model contributes to two things:\n\n        1. It provides a function returning a list of all file paths declared\n        in a given list of addons (see _get_addon_paths);\n\n        2. It allows to create 'ir.asset' records to add additional directives\n        to certain bundles.\n    	f	f	\N	\N	f	f	f
18	\N	\N	ir.actions.actions	name, id	base	fold	{"en_US": "Actions", "es_419": "Acciones"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
19	\N	\N	ir.actions.act_window	name, id	base	fold	{"en_US": "Action Window", "es_419": "Ventana de acción"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
21	\N	\N	ir.actions.act_window_close	name, id	base	fold	{"en_US": "Action Window Close", "es_419": "Acción - Cierre de ventana"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
22	\N	\N	ir.actions.act_url	name, id	base	fold	{"en_US": "Action URL", "es_419": "URL de la acción"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
27	\N	\N	ir.actions.client	name, id	base	fold	{"en_US": "Client Action", "es_419": "Acción del cliente"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
41	\N	\N	ir.autovacuum	id	base	fold	{"en_US": "Automatic Vacuum", "es_419": "Vaciado automático"}	 Helper model to the ``@api.autovacuum`` method decorator. 	t	f	\N	\N	f	f	f
92	\N	\N	res.bank	name, id	base	fold	{"en_US": "Bank", "es_419": "Banco"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
14	\N	\N	ir.ui.view.custom	create_date desc, id desc	base	fold	{"en_US": "Custom View", "es_419": "Vista personalizada"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
26	\N	\N	ir.actions.todo	sequence, id	base	fold	{"en_US": "Configuration Wizards", "es_419": "Asistentes de configuración"}	\n    Configuration Wizards\n    	f	f	\N	\N	f	f	f
36	\N	\N	ir.default	id	base	fold	{"en_US": "Default Values", "es_419": "Valores predeterminados"}	 User-defined default values for fields. 	f	f	\N	\N	f	f	f
72	\N	\N	ir.demo	id	base	fold	{"en_US": "Demo", "es_419": "Demostración"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
73	\N	\N	ir.demo_failure	id	base	fold	{"en_US": "Demo failure", "es_419": "Error en la demostración"}	 Stores modules for which we could not install demo data\n    	f	t	\N	\N	f	f	f
74	\N	\N	ir.demo_failure.wizard	id	base	fold	{"en_US": "Demo Failure wizard", "es_419": "Asistente para error de datos de demostración"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
87	\N	\N	format.vat.label.mixin	id	base	fold	{"en_US": "Country Specific VAT Label", "es_419": "Etiqueta de IVA específica del país"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
31	\N	\N	ir.binary	id	base	fold	{"en_US": "File streaming helper model for controllers", "es_419": "Modelo de ayuda para la transmisión de archivos para controladores"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
5	\N	\N	ir.model.inherit	id	base	fold	{"en_US": "Model Inheritance Tree", "es_419": "Modelo de árbol de la herencia"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
7	\N	\N	ir.model.constraint	id	base	fold	{"en_US": "Model Constraint", "es_419": "Restricción del modelo"}	\n    This model tracks PostgreSQL indexes, foreign keys and constraints\n    used by Odoo models.\n    	f	f	\N	\N	f	f	f
9	\N	\N	ir.model.access	model_id,group_id,name,id	base	fold	{"en_US": "Model Access", "es_419": "Acceso al modelo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
115	\N	\N	report.base.report_irmodulereference	id	base	fold	{"en_US": "Module Reference Report (base)", "es_419": "Reporte del módulo de referencia (base)"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
34	\N	\N	ir.cron.progress	id	base	fold	{"en_US": "Progress of Scheduled Actions", "es_419": "Progreso de acciones programadas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
45	\N	\N	ir.qweb.field	id	base	fold	{"en_US": "Qweb Field", "es_419": "Campo Qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
59	\N	\N	ir.qweb.field.float_time	id	base	fold	{"en_US": "Qweb Field Float Time", "es_419": "Campo Qweb de tiempo flotante"}	 ``float_time`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "01:30").\n\n    Can be used on any numerical field.\n    	t	f	\N	\N	f	f	f
60	\N	\N	ir.qweb.field.time	id	base	fold	{"en_US": "QWeb Field Time", "es_419": "Campo de tiempo QWeb"}	 ``time`` converter, to display integer or fractional value as\n    human-readable time (e.g. 1.5 as "1:30 AM"). The unit of this value\n    is in hours.\n\n    Can be used on any numerical field between: 0 <= value < 24\n    	t	f	\N	\N	f	f	f
63	\N	\N	ir.qweb.field.barcode	id	base	fold	{"en_US": "Qweb Field Barcode", "es_419": "Código de barras del campo Qweb"}	 ``barcode`` widget rendering, inserts a data:uri-using image tag in the\n    document. May be overridden by e.g. the website module to generate links\n    instead.\n    	t	f	\N	\N	f	f	f
44	\N	\N	ir.qweb	id	base	fold	{"en_US": "Qweb", "es_419": "Qweb"}	Add ``raise_on_forbidden_code_for_model`` option for qweb.\n\n    When this option is activated, only a whitelist of expressions\n    is allowed for the given model.\n    	t	f	\N	\N	f	f	f
8	\N	\N	ir.model.relation	id	base	fold	{"en_US": "Relation Model", "es_419": "Modelo relacional"}	\n    This model tracks PostgreSQL tables used to implement Odoo many2many\n    relations.\n    	f	f	\N	\N	f	f	f
11	\N	\N	ir.sequence	name, id	base	fold	{"en_US": "Sequence", "es_419": "Secuencia"}	 Sequence model.\n\n    The sequence model allows to define and use so-called sequence objects.\n    Such objects are used to generate unique identifiers in a transaction-safe\n    way.\n\n    	f	f	\N	\N	f	f	f
12	\N	\N	ir.sequence.date_range	id	base	fold	{"en_US": "Sequence Date Range", "es_419": "Rango de fechas de la secuencia"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
16	\N	\N	reset.view.arch.wizard	id	base	fold	{"en_US": "Reset View Architecture Wizard", "es_419": "Asistente para restablecer la arquitectura de la vista"}	 A wizard to compare and reset views architecture. 	f	t	\N	\N	f	f	f
39	\N	\N	ir.rule	model_id DESC,id	base	fold	{"en_US": "Record Rule", "es_419": "Regla"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
53	\N	\N	ir.qweb.field.many2many	id	base	fold	{"en_US": "Qweb field many2many", "es_419": "Campo Qweb many2many"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
75	\N	\N	properties.base.definition	id	base	fold	{"en_US": "Properties Base Definition", "es_419": "Definición base de las propiedades"}	Models storing the properties definition of the record without parent.	f	f	\N	\N	f	f	f
126	\N	\N	base.document.layout	id	base	fold	{"en_US": "Company Document Layout", "es_419": "Diseño de documentos de la empresa"}	\n    Customise the company document layout and display a live preview\n    	f	t	\N	\N	f	f	f
127	\N	\N	res.users.settings.embedded.action	id	base	fold	{"en_US": "User Settings for Embedded Actions", "es_419": "Ajustes del usuario para acciones incrustadas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
130	\N	\N	auth_totp.wizard	id	base	fold	{"en_US": "2-Factor Setup Wizard", "es_419": "Asistente de la configuración de la autenticación de dos factores"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
13	\N	\N	ir.ui.menu	sequence,id	base	fold	{"en_US": "Menu", "es_419": "Menú"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
56	\N	\N	ir.qweb.field.image	id	base	fold	{"en_US": "Qweb Field Image", "es_419": "Campo Qweb de imagen"}	\n    Widget options:\n\n    ``class``\n        set as attribute on the generated <img> tag\n    	t	f	\N	\N	f	f	f
128	\N	\N	auth_totp.device	id	base	fold	{"en_US": "Authentication Device", "es_419": "Dispositivo de autenticación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
129	\N	\N	auth.totp.rate.limit.log	id	base	fold	{"en_US": "TOTP rate limit logs", "es_419": "Cantidad límite de registros de TOTP"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
131	\N	\N	base_import.mapping	id	base	fold	{"en_US": "Base Import Mapping", "es_419": "Mapeo de la importación de base"}	 mapping of previous column:field selections\n\n    This is useful when repeatedly importing from a third-party\n    system: column names generated by the external system may\n    not match Odoo's field names or labels. This model is used\n    to save the mapping between column names and fields so that\n    next time a user imports from the same third-party systems\n    we can automatically match the columns to the correct field\n    without them having to re-enter the mapping every single\n    time.\n    	f	f	\N	\N	f	f	f
132	\N	\N	base_import.import	id	base	fold	{"en_US": "Base Import", "es_419": "Importación base"}	\n    This model is used to prepare the loading of data coming from a user file.\n\n    Here is the process that is followed:\n\n    #. The user selects a file to import.\n    #. File parsing and mapping suggestion (see "parse_preview" method)\n\n       #. Extract the current model's importable fields tree (see :meth:`get_fields_tree`).\n       #. Read the file (see :meth:`_read_file`) and extract header names and file\n          length (used for batch import).\n       #. Extract headers types from the data preview (10 first line of the file)\n          (see :meth:`_extract_headers_types`).\n       #. Try to find for each header a field to map with (see :meth:`_get_mapping_suggestions`)\n\n          - First check the previously saved mappings between the header name\n            and one of the model's fields.\n          - If no mapping found, try an exact match comparison using fields\n            technical names, labels and user language translated labels.\n          - If nothing found, try a fuzzy match using word distance between\n            header name and fields tachnical names, labels and user language\n            translated labels. Keep only the closest match.\n\n       #. Prepare examples for each columns using the first non null value from each column.\n       #. Send the info back to the UI where the user can modify the suggested mapping.\n    #. Execute the import: There are two import mode with uses the same process. (see :meth:`execute_import`)\n\n       #. Test import: Try to import but rollback the transaction. This allows\n          the check errors during the import process and allow the user to\n          choose import options for the different encountered errors.\n       #. Real import: Try to import the file using the configured mapping and\n          the eventual "error mapping options". If import encounters blocking\n          errors, the transaction is rollbacked and the user is allowed to\n          choose import options for the different errors.\n\n          - Get file data and fields to import into (see :meth:`_convert_import_data`).\n          - Parse date, float and binary data (see :meth:`_parse_import_data`).\n          - Handle multiple mapping -> concatenate char/text/many2many columns\n            mapped on the same field (see :meth:`_handle_multi_mapping`).\n          - Handle fallback values for boolean and selection fields, in case\n            input data does not match any allowed values (see :meth:`_handle_fallback_values`).\n          - Load data (see ir.model "load" method).\n          - Rollback transaction if test mode or if encountered error.\n          - Save mapping if any import is successful to ease later mapping suggestions.\n          - Return import result to the UI (success or errors if any).\n    	f	t	\N	\N	f	f	f
133	\N	\N	base.import.module	id	base	fold	{"en_US": "Import Module", "es_419": "Importar módulo"}	 Import Module 	f	t	\N	\N	f	f	f
120	\N	\N	base.module.uninstall	id	base	fold	{"en_US": "Module Uninstall", "es_419": "Desinstalar módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
134	\N	\N	kpi.provider	id	base	fold	{"en_US": "KPI Provider", "es_419": "Proveedor de KPI"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
135	\N	\N	bus.bus	id	base	fold	{"en_US": "Communication Bus", "es_419": "Bus de comunicación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
100	\N	\N	res.groups	privilege_id, sequence, name, id	base	fold	{"en_US": "Access Groups", "es_419": "Grupos de acceso"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
46	\N	\N	ir.qweb.field.integer	id	base	fold	{"en_US": "Qweb Field Integer", "es_419": "Campo Qweb entero"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
55	\N	\N	ir.qweb.field.html	id	base	fold	{"en_US": "Qweb Field HTML", "es_419": "Campo Qweb HTML"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
57	\N	\N	ir.qweb.field.image_url	id	base	fold	{"en_US": "Qweb Field Image", "es_419": "Campo Qweb de imagen"}	 ``image_url`` widget rendering, inserts an image tag in the\n    document.\n    	t	f	\N	\N	f	f	f
58	\N	\N	ir.qweb.field.monetary	id	base	fold	{"en_US": "Qweb Field Monetary", "es_419": "Campo monetario Qweb"}	 ``monetary`` converter, has a mandatory option\n    ``display_currency`` only if field is not of type Monetary.\n    Otherwise, if we are in presence of a monetary field, the field definition must\n    have a currency_field attribute set.\n\n    The currency is used for formatting *and rounding* of the float value. It\n    is assumed that the linked res_currency has a non-empty rounding value and\n    res.currency's ``round`` method is used to perform rounding.\n\n    .. note:: the monetary converter internally adds the qweb context to its\n              options mapping, so that the context is available to callees.\n              It's set under the ``_values`` key.\n    	t	f	\N	\N	f	f	f
61	\N	\N	ir.qweb.field.duration	id	base	fold	{"en_US": "Qweb Field Duration", "es_419": "Campo Qweb de duración"}	 ``duration`` converter, to display integral or fractional values as\n    human-readable time spans (e.g. 1.5 as "1 hour 30 minutes").\n\n    Can be used on any numerical field.\n\n    Has an option ``unit`` which can be one of ``second``, ``minute``,\n    ``hour``, ``day``, ``week`` or ``year``, used to interpret the numerical\n    field value before converting it. By default use ``second``.\n\n    Has an option ``round``. By default use ``second``.\n\n    Has an option ``digital`` to display 01:00 instead of 1 hour\n\n    Sub-second values will be ignored.\n    	t	f	\N	\N	f	f	f
62	\N	\N	ir.qweb.field.relative	id	base	fold	{"en_US": "Qweb Field Relative", "es_419": "Campo relativo de Qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
64	\N	\N	ir.qweb.field.contact	id	base	fold	{"en_US": "Qweb Field Contact", "es_419": "Campo Qweb de contacto"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
65	\N	\N	ir.qweb.field.qweb	id	base	fold	{"en_US": "Qweb Field qweb", "es_419": "Qweb del campo qweb"}	 Used to convert a t-field specification into an output HTML field.\n\n    :meth:`~.to_html` is the entry point of this conversion from QWeb, it:\n\n    * converts the record value to html using :meth:`~.record_to_html`\n    * generates the metadata attributes (``data-oe-``) to set on the root\n      result node\n    * generates the root result node itself through :meth:`~.render_element`\n    	t	f	\N	\N	f	f	f
67	\N	\N	ir.logging	id DESC	base	fold	{"en_US": "Logging", "es_419": "Registro"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
68	\N	\N	ir.module.category	sequence, name, id	base	fold	{"en_US": "Application", "es_419": "Aplicación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
70	\N	\N	ir.module.module.dependency	id	base	fold	{"en_US": "Module dependency", "es_419": "Dependencia del módulo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
71	\N	\N	ir.module.module.exclusion	id	base	fold	{"en_US": "Module exclusion", "es_419": "Exclusión del módulo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
76	\N	\N	properties.base.definition.mixin	id	base	fold	{"en_US": "Properties Base Definition Mixin", "es_419": "Mixin de la definición base de propiedades"}	Mixin that add properties without parent on a model.	t	f	\N	\N	f	f	f
77	\N	\N	report.layout	sequence, id	base	fold	{"en_US": "Report Layout", "es_419": "Diseño del reporte"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
78	\N	\N	report.paperformat	id	base	fold	{"en_US": "Paper Format Config", "es_419": "Configuración del formato de papel"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
79	\N	\N	ir.profile	session desc, id desc	base	fold	{"en_US": "Profiling results", "es_419": "Resultados del análisis de rendimiento de software"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
80	\N	\N	base.enable.profiling.wizard	id	base	fold	{"en_US": "Enable profiling for some time", "es_419": "Habilitar análisis de rendimiento por cierto tiempo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
81	\N	\N	image.mixin	id	base	fold	{"en_US": "Image Mixin", "es_419": "Mixin de imagen"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
109	\N	\N	res.users.apikeys.show	id	base	fold	{"en_US": "Show API Key", "es_419": "Mostrar clave API"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
111	\N	\N	res.users.deletion	id	base	fold	{"en_US": "Users Deletion Request", "es_419": "Solicitud de eliminación del usario"}	User deletion requests.\n\n    Those requests are logged in a different model to keep a trace of this action and the\n    deletion is done in a CRON. Indeed, removing a user can be a heavy operation on\n    large database (because of create_uid, write_uid on each model, which are not always\n    indexed). This model just remove the users added in the deletion queue, remaining code\n    must deal with other consideration (archiving, blacklist email...).\n    	f	f	\N	\N	f	f	f
112	\N	\N	res.device.log	id	base	fold	{"en_US": "Device Log", "es_419": "Registro del dispositivo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
113	\N	\N	res.device	last_activity desc	base	fold	{"en_US": "Devices", "es_419": "Dispositivos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
114	\N	\N	decimal.precision	id	base	fold	{"en_US": "Decimal Precision", "es_419": "Precisión decimal"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
116	\N	\N	base.module.update	id	base	fold	{"en_US": "Update Module", "es_419": "Actualizar módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
117	\N	\N	base.language.install	id	base	fold	{"en_US": "Install Language", "es_419": "Instalar idioma"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
118	\N	\N	base.language.import	id	base	fold	{"en_US": "Language Import", "es_419": "Importar idioma"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
119	\N	\N	base.module.upgrade	id	base	fold	{"en_US": "Upgrade Module", "es_419": "Actualizar módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
121	\N	\N	base.language.export	id	base	fold	{"en_US": "Language Export", "es_419": "Exportar idioma"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
122	\N	\N	base.partner.merge.line	min_id asc	base	fold	{"en_US": "Merge Partner Line", "es_419": "Fusionar línea de contacto"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
124	\N	\N	wizard.ir.model.menu.create	id	base	fold	{"en_US": "Create Menu Wizard", "es_419": "Asistente para crear menú"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
139	\N	\N	web_tour.tour	sequence, name, id	base	fold	{"en_US": "Tours", "es_419": "Recorridos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
140	\N	\N	web_tour.tour.step	sequence, id	base	fold	{"en_US": "Tour's step", "es_419": "Paso del recorrido"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
141	\N	\N	auth.passkey.key	id desc	base	fold	{"en_US": "Passkey", "es_419": "Llave de acceso"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
142	\N	\N	auth.passkey.key.create	id	base	fold	{"en_US": "Create a Passkey", "es_419": "Crear una llave de acceso"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
144	\N	\N	html_editor.converter.test	id	base	fold	{"en_US": "Html Editor Converter Test", "es_419": "Prueba del convertidor de editor HTML"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
145	\N	\N	html_editor.converter.test.sub	id	base	fold	{"en_US": "Html Editor Converter Subtest", "es_419": "Subprueba del convertidor de editor HTML"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
146	\N	\N	html.field.history.mixin	id	base	fold	{"en_US": "Field html History", "es_419": "Historial del campo html"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
148	\N	\N	iap.enrich.api	id	base	fold	{"en_US": "IAP Lead Enrichment API", "es_419": "API de enriquecimiento de leads para compras dentro de la aplicación"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
149	\N	\N	iap.service	id	base	fold	{"en_US": "IAP Service", "es_419": "Servicio de compras dentro de la aplicación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
123	\N	\N	base.partner.merge.automatic.wizard	id	base	fold	{"en_US": "Merge Partner Wizard", "es_419": "Asistente de fusión de contactos"}	\n        The idea behind this wizard is to create a list of potential partners to\n        merge. We use two objects, the first one is the wizard for the end-user.\n        And the second will contain the partner list to merge.\n    	f	t	\N	\N	f	f	f
32	\N	\N	ir.cron	cron_name, id	base	fold	{"en_US": "Scheduled Actions", "es_419": "Acciones planificadas"}	 Model describing cron jobs (also called actions or tasks).\n    	f	f	\N	\N	t	t	f
40	\N	\N	ir.config_parameter	key	base	fold	{"en_US": "System Parameter", "es_419": "Parámetro del sistema"}	Per-database storage of configuration key-value pairs.	f	f	\N	\N	f	f	f
136	\N	\N	bus.listener.mixin	id	base	fold	{"en_US": "Can send messages via bus.bus", "es_419": "Puede enviar mensajes mediante bus.bus"}	Allow sending messages related to the current model via as a bus.bus channel.\n\n    The model needs to be allowed as a valid channel for the bus in `_build_bus_channel_list`.\n    	t	f	\N	\N	f	f	f
137	\N	\N	ir.websocket	id	base	fold	{"en_US": "websocket message handling", "es_419": "gestión de mensajes de WebSocket"}	Override to handle discuss specific features (channel in particular).	t	f	\N	\N	f	f	f
20	\N	\N	ir.actions.act_window.view	sequence,id	base	fold	{"en_US": "Action Window View", "es_419": "Vista de ventana de acción"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
15	\N	\N	ir.ui.view	priority,name,id	base	fold	{"en_US": "View", "es_419": "Vista"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
110	\N	\N	res.users.settings	id	base	fold	{"en_US": "User Settings", "es_419": "Ajustes de usuario"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
150	\N	\N	mail.alias	alias_model_id, alias_name	base	fold	{"en_US": "Email Aliases", "es_419": "Alias de correo"}	A Mail Alias is a mapping of an email address with a given Odoo Document\n       model. It is used by Odoo's mail gateway when processing incoming emails\n       sent to the system. If the recipient address (To) of the message matches\n       a Mail MailAlias, the message will be either processed following the rules\n       of that alias. If the message is a reply it will be attached to the\n       existing discussion on the corresponding record, otherwise a new\n       record of the corresponding model will be created.\n\n       This is meant to be used in combination with a catch-all email configuration\n       on the company's mail server, so that as soon as a new mail.alias is\n       created, it becomes immediately usable and Odoo will accept email for it.\n     	f	f	\N	\N	f	f	f
151	\N	\N	mail.alias.domain	sequence ASC, id ASC	base	fold	{"en_US": "Email Domain", "es_419": "Dominio de correo electrónico"}	 Model alias domains, now company-specific. Alias domains are email\n    domains used to receive emails through catchall and bounce aliases, as\n    well as using mail.alias records to redirect email replies.\n\n    This replaces ``mail.alias.domain`` configuration parameter use until v16.\n    	f	f	\N	\N	f	f	f
153	\N	\N	mail.activity.mixin	id	base	fold	{"en_US": "Activity Mixin", "es_419": "Mixin de la actividad"}	 Mail Activity Mixin is a mixin class to use if you want to add activities\n    management on a model. It works like the mail.thread mixin. It defines\n    an activity_ids one2many field toward activities using res_id and res_model_id.\n    Various related / computed fields are also added to have a global status of\n    activities on documents.\n\n    Activities come with a new JS widget for the form view. It is integrated in the\n    Chatter widget although it is a separate widget. It displays activities linked\n    to the current record and allow to schedule, edit and mark done activities.\n\n    There is also a kanban widget defined. It defines a small widget to integrate\n    in kanban vignettes. It allow to manage activities directly from the kanban\n    view. Use widget="kanban_activity" on activitiy_ids field in kanban view to\n    use it.\n\n    Some context keys allow to control the mixin behavior. Use those in some\n    specific cases like import\n\n     * ``mail_activity_automation_skip``: skip activities automation; it means\n       no automated activities will be generated, updated or unlinked, allowing\n       to save computation and avoid generating unwanted activities;\n    	t	f	\N	\N	f	t	f
154	\N	\N	mail.alias.mixin.optional	id	base	fold	{"en_US": "Email Aliases Mixin (light)", "es_419": "Mixin de los alias de correo (claro)"}	 A mixin for models that handles underlying 'mail.alias' records to use\n    the mail gateway. Field is not mandatory and its creation is done dynamically\n    based on given 'alias_name', allowing to gradually populate the alias table\n    without having void aliases as when used with an inherits-like implementation.\n    	t	f	\N	\N	f	f	f
155	\N	\N	mail.alias.mixin	id	base	fold	{"en_US": "Email Aliases Mixin", "es_419": "Mixin de los alias de correo"}	 A mixin for models that inherits mail.alias to have a one-to-one relation\n    between the model and its alias. 	t	f	\N	\N	f	f	f
159	\N	\N	mail.thread.blacklist	id	base	fold	{"en_US": "Mail Blacklist mixin", "es_419": "Mixin de exclusión de correos"}	 Mixin that is inherited by all model with opt out. This mixin stores a normalized\n    email based on primary_email field.\n\n    A normalized email is considered as :\n        - having a left part + @ + a right part (the domain can be without '.something')\n        - being lower case\n        - having no name before the address. Typically, having no 'Name <>'\n    Ex:\n        - Formatted Email : 'Name <NaMe@DoMaIn.CoM>'\n        - Normalized Email : 'name@domain.com'\n\n    The primary email field can be specified on the parent model, if it differs from the default one ('email')\n    The email_normalized field can than be used on that model to search quickly on emails (by simple comparison\n    and not using time consuming regex anymore).\n\n    Using this email_normalized field, blacklist status is computed.\n\n    Mail Thread capabilities are required for this mixin. 	t	f	\N	\N	t	f	t
160	\N	\N	mail.thread.cc	id	base	fold	{"en_US": "Email CC management", "es_419": "Gestión del CC del correo electrónico"}	 mail_thread model is meant to be inherited by any model that needs to\n        act as a discussion topic on which messages can be attached. Public\n        methods are prefixed with ``message_`` in order to avoid name\n        collisions with methods of the models that will inherit from this class.\n\n        ``mail.thread`` defines fields used to handle and display the\n        communication history. ``mail.thread`` also manages followers of\n        inheriting classes. All features and expected behavior are managed\n        by mail.thread. Widgets has been designed for the 7.0 and following\n        versions of Odoo.\n\n        Inheriting classes are not required to implement any method, as the\n        default implementation will work for any model. However it is common\n        to override at least the ``message_new`` and ``message_update``\n        methods (calling ``super``) to add model-specific behavior at\n        creation and update of a thread when processing incoming emails.\n\n    MailThread class options:\n\n     - _mail_flat_thread: if set to True, all messages without parent_id\n       are automatically attached to the first message posted on the\n       resource. If set to False, threads are supported and no parent is forced.\n     - _mail_post_access: required document access when posting on the document.\n       Equivalent to: 'create' rights on mail.message depends notably on\n       document rights, which can be controller using this attribute. Defaults\n       to 'write' as writing is considered as editing. A common customization\n       is to set it to 'read', allowing people with read access to discuss.\n     - _mail_thread_customer: if set to True, consider this model has a strong\n       tie with the customer (found using '_mail_get_customer'). It currently\n       automatically subscribes customer if found in any post recipients.\n\n    MailThread features can be somewhat controlled through context keys :\n\n    # Tracking and logging\n     - ``mail_create_nosubscribe``: at create, do not subscribe uid to the\n       record thread. False by default, as creating = following;\n     - ``mail_create_nolog``: at create, do not log the automatic '<Document>\n       created' message\n     - ``mail_notrack``: at create and write, do not perform the value tracking\n       creating messages;\n     - ``tracking_disable``: at create and write, perform no MailThread features\n       (auto subscription, tracking, post, ...);\n    # Posting process\n     - ``mail_notify_force_send``: if less than 50 email notifications to send,\n       send them directly instead of using the queue i.e. controls 'force_send'\n       parameter of '_notify_thread_by_email'. True by default as it is\n       the desired behavior;\n     - ``mail_notify_author``: notify author if they are in potential notified\n       partners (e.g. following a document on which they post) i.e. controls\n       'notify_author' parameter of '_notify_get_recipients'. False by default\n       as people should not be notified of what they typed;\n     - ``mail_notify_author_mention``: notify author if they are in direct\n       recipients ('partner_ids') i.e. controls 'notify_author_mention'. Used\n       in flows involving auto replies where author could be used to contact\n       themselves. False by default;\n    # Post side effects\n     - ``mail_auto_subscribe_no_notify``: skip notifications linked to auto\n       subscription. False by default, notifications are intended;\n     - ``mail_post_autofollow``: subscribe specific recipients ('partner_ids') during\n        message_post. False by default;\n     - ``mail_post_autofollow_author_skip``: do not subscribe author of a message\n        post. False by default, as we consider authors should receive answers;\n    	t	f	\N	\N	t	f	f
161	\N	\N	mail.thread.main.attachment	id	base	fold	{"en_US": "Mail Main Attachment management", "es_419": "Correo principal para gestión de archivos adjuntos"}	 Mixin that adds main attachment support to the MailThread class. 	t	f	\N	\N	t	f	f
162	\N	\N	mail.tracking.duration.mixin	id	base	fold	{"en_US": "Mixin to compute the time a record has spent in each value a many2one field can take", "es_419": "Mixin para calcular el tiempo que ha pasado un registro en cada valor que puede tomar un campo many2one"}	 mail_thread model is meant to be inherited by any model that needs to\n        act as a discussion topic on which messages can be attached. Public\n        methods are prefixed with ``message_`` in order to avoid name\n        collisions with methods of the models that will inherit from this class.\n\n        ``mail.thread`` defines fields used to handle and display the\n        communication history. ``mail.thread`` also manages followers of\n        inheriting classes. All features and expected behavior are managed\n        by mail.thread. Widgets has been designed for the 7.0 and following\n        versions of Odoo.\n\n        Inheriting classes are not required to implement any method, as the\n        default implementation will work for any model. However it is common\n        to override at least the ``message_new`` and ``message_update``\n        methods (calling ``super``) to add model-specific behavior at\n        creation and update of a thread when processing incoming emails.\n\n    MailThread class options:\n\n     - _mail_flat_thread: if set to True, all messages without parent_id\n       are automatically attached to the first message posted on the\n       resource. If set to False, threads are supported and no parent is forced.\n     - _mail_post_access: required document access when posting on the document.\n       Equivalent to: 'create' rights on mail.message depends notably on\n       document rights, which can be controller using this attribute. Defaults\n       to 'write' as writing is considered as editing. A common customization\n       is to set it to 'read', allowing people with read access to discuss.\n     - _mail_thread_customer: if set to True, consider this model has a strong\n       tie with the customer (found using '_mail_get_customer'). It currently\n       automatically subscribes customer if found in any post recipients.\n\n    MailThread features can be somewhat controlled through context keys :\n\n    # Tracking and logging\n     - ``mail_create_nosubscribe``: at create, do not subscribe uid to the\n       record thread. False by default, as creating = following;\n     - ``mail_create_nolog``: at create, do not log the automatic '<Document>\n       created' message\n     - ``mail_notrack``: at create and write, do not perform the value tracking\n       creating messages;\n     - ``tracking_disable``: at create and write, perform no MailThread features\n       (auto subscription, tracking, post, ...);\n    # Posting process\n     - ``mail_notify_force_send``: if less than 50 email notifications to send,\n       send them directly instead of using the queue i.e. controls 'force_send'\n       parameter of '_notify_thread_by_email'. True by default as it is\n       the desired behavior;\n     - ``mail_notify_author``: notify author if they are in potential notified\n       partners (e.g. following a document on which they post) i.e. controls\n       'notify_author' parameter of '_notify_get_recipients'. False by default\n       as people should not be notified of what they typed;\n     - ``mail_notify_author_mention``: notify author if they are in direct\n       recipients ('partner_ids') i.e. controls 'notify_author_mention'. Used\n       in flows involving auto replies where author could be used to contact\n       themselves. False by default;\n    # Post side effects\n     - ``mail_auto_subscribe_no_notify``: skip notifications linked to auto\n       subscription. False by default, notifications are intended;\n     - ``mail_post_autofollow``: subscribe specific recipients ('partner_ids') during\n        message_post. False by default;\n     - ``mail_post_autofollow_author_skip``: do not subscribe author of a message\n        post. False by default, as we consider authors should receive answers;\n    	t	f	\N	\N	t	f	f
163	\N	\N	template.reset.mixin	id	base	fold	{"en_US": "Template Reset Mixin", "es_419": "Mixin de restablecimiento de plantilla"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
166	\N	\N	mail.activity.type	sequence, id	base	fold	{"en_US": "Activity Type", "es_419": "Tipo de actividad"}	 Activity Types are used to categorize activities. Each type is a different\n    kind of activity e.g. call, mail, meeting. An activity can be generic i.e.\n    available for all models using activities; or specific to a model in which\n    case res_model field should be used. 	f	f	\N	\N	f	f	f
167	\N	\N	mail.activity	date_deadline ASC, id ASC	base	fold	{"en_US": "Activity", "es_419": "Actividad"}	 An actual activity to perform. Activities are linked to\n    documents using res_id and res_model_id fields. Activities have a deadline\n    that can be used in kanban view to display a status. Once done activities\n    are unlinked and a message is posted. This message has a new activity_type_id\n    field that indicates the activity linked to the message. 	f	f	\N	\N	f	f	f
168	\N	\N	mail.activity.plan	id DESC	base	fold	{"en_US": "Activity Plan", "es_419": "Plan de actividad"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
169	\N	\N	mail.activity.plan.template	sequence, id	base	fold	{"en_US": "Activity plan template", "es_419": "Plantilla del plan de actividad"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
170	\N	\N	mail.blacklist	id	base	fold	{"en_US": "Mail Blacklist", "es_419": "Exclusión del correo"}	 Model of blacklisted email addresses to stop sending emails.	f	f	\N	\N	t	f	f
172	\N	\N	mail.gateway.allowed	id	base	fold	{"en_US": "Mail Gateway Allowed", "es_419": "Puerta de enlace de correo permitida"}	List of trusted email address which won't have the quota restriction.\n\n    The incoming emails have a restriction of the number of records they can\n    create with alias, defined by the 2 systems parameters;\n    - mail.gateway.loop.minutes\n    - mail.gateway.loop.threshold\n\n    But we might have some legit use cases for which we want to receive a ton of emails\n    from an automated-source. This model stores those trusted source and this restriction\n    won't apply to them.\n    	f	f	\N	\N	f	f	f
173	\N	\N	mail.link.preview	id	base	fold	{"en_US": "Store link preview data", "es_419": "Almacenar los datos de la vista previa del enlace"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
174	\N	\N	mail.message.link.preview	sequence, id	base	fold	{"en_US": "Link between link previews and messages", "es_419": "Enlace entre la previsualización de enlaces y mensajes"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
175	\N	\N	mail.message.reaction	id desc	base	fold	{"en_US": "Message Reaction", "es_419": "Reacción de mensaje"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
176	\N	\N	mail.message.schedule	scheduled_datetime DESC, id DESC	base	fold	{"en_US": "Scheduled Messages", "es_419": "Mensajes programados"}	 Mail message notification schedule queue.\n\n    This model is used to store the mail messages scheduled. So we can\n    delay the sending of the notifications. A scheduled date field already\n    exists on the <mail.mail> but it does not allow us to delay the sending\n    of the <bus.bus> notifications.\n    	f	f	\N	\N	f	f	f
177	\N	\N	mail.message.subtype	sequence, id	base	fold	{"en_US": "Message subtypes", "es_419": "Subtipos de mensaje"}	 Class holding subtype definition for messages. Subtypes allow to tune\n        the follower subscription, allowing only some subtypes to be pushed\n        on the Wall. 	f	f	\N	\N	f	f	f
178	\N	\N	mail.message.translation	id	base	fold	{"en_US": "Message Translation", "es_419": "Traducción de mensajes"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
180	\N	\N	mail.mail	id desc	base	fold	{"en_US": "Outgoing Mails", "es_419": "Correos salientes"}	 Model holding RFC2822 email messages to send. This model also provides\n        facilities to queue and send new email messages.  	f	f	\N	\N	f	f	f
181	\N	\N	mail.presence	id	base	fold	{"en_US": "User/Guest Presence", "es_419": "Conexión del usuario/invitado"}	User/Guest Presence\n    Its status is 'online', 'away' or 'offline'. This model should be a one2one, but is not\n    attached to res_users to avoid database concurrency errors.\n    	f	f	\N	\N	f	f	f
182	\N	\N	mail.push	id	base	fold	{"en_US": "Push Notifications", "es_419": "Notificaciones push"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
183	\N	\N	mail.push.device	id	base	fold	{"en_US": "Push Notification Device", "es_419": "Dispositivo de notificación push"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
184	\N	\N	mail.scheduled.message	id	base	fold	{"en_US": "Scheduled Message", "es_419": "Mensaje programado"}	 Scheduled message model (holds post values generated by the composer to delay the\n    posting of the message). Different from mail.message.schedule that posts the message but\n    delays the notification process.\n\n    Todo: when adding support for scheduling messages in mass_mail mode, could add a reference to\n    the "parent" composer (by making 'mail.compose.message' not transient anymore). This reference\n    could then be used to cancel every message scheduled "at the same time" (from one composer),\n    and to get the static 'notification parameters' (mail_server_id, auto_delete,...) instead of\n    duplicating them for each scheduled message.\n    Currently as scheduling is allowed in monocomment only, we don't have duplicates and we only\n    have static notification parameters, but some will become dynamic when adding mass_mail support\n    such as 'email_from' and 'force_email_lang'.\n    	f	f	\N	\N	f	f	f
185	\N	\N	mail.tracking.value	id DESC	base	fold	{"en_US": "Mail Tracking Value", "es_419": "Valor de seguimiento de correo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
187	\N	\N	mail.ice.server	id	base	fold	{"en_US": "ICE Server", "es_419": "Servidor ICE"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
188	\N	\N	mail.canned.response	id desc	base	fold	{"en_US": "Canned Response", "es_419": "Respuesta predefinida"}	 Canned Response: content that automatically replaces shortcuts of your\n    choosing. This content can still be adapted before sending your message. 	f	f	\N	\N	f	f	f
190	\N	\N	res.users.settings.volumes	id	base	fold	{"en_US": "User Settings Volumes", "es_419": "Ajustes de volumen del usuario"}	 Represents the volume of the sound that the user of user_setting_id will receive from partner_id. 	f	f	\N	\N	f	f	f
206	\N	\N	res.role	id	base	fold	{"en_US": "Represents a role in the system used to categorize users. Each role has a unique name and can be associated with multiple users. Roles can be mentioned in messages to notify all associated users.", "es_419": "Representa un rol en el sistema utilizado para categorizar a los usuarios. Cada rol tiene un nombre único y puede estar asociado a varios usuarios. Puede mencionar a los roles en los mensajes para notificar a todos los usuarios asociados."}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
209	\N	\N	discuss.call.history	start_dt DESC, id DESC	base	fold	{"en_US": "Keep the call history", "es_419": "Mantener el historial de la llamada"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
210	\N	\N	discuss.channel.member	id	base	fold	{"en_US": "Channel Member", "es_419": "Miembro del canal"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
211	\N	\N	discuss.channel.rtc.session	id	base	fold	{"en_US": "Mail RTC session", "es_419": "Sesión de comunicación en tiempo real por correo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
213	\N	\N	discuss.gif.favorite	id	base	fold	{"en_US": "Save favorite GIF from Tenor API", "es_419": "Marcar un GIF de Tenor API como favorito"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
214	\N	\N	discuss.voice.metadata	id	base	fold	{"en_US": "Metadata for voice attachments", "es_419": "Metadatos para los archivos adjuntos de voz"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
215	\N	\N	mail.guest	id	base	fold	{"en_US": "Guest", "es_419": "Invitado"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
186	\N	\N	mail.template	user_id, name, id	base	fold	{"en_US": "Email Templates", "es_419": "Plantillas de correo electrónico"}	Templates for sending email	f	f	\N	\N	f	f	f
221	\N	\N	mail.blacklist.remove	id	base	fold	{"en_US": "Remove email from blacklist wizard", "es_419": "Asistente para eliminar los correos electrónicos de la lista de exclusión"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
222	\N	\N	mail.compose.message	id	base	fold	{"en_US": "Email composition wizard", "es_419": "Asistente de redacción de correo electrónico"}	 Generic message composition wizard. You may inherit from this wizard\n        at model and view levels to provide specific features.\n\n        The behavior of the wizard depends on the composition_mode field:\n        - 'comment': post on a record.\n        - 'mass_mail': wizard in mass mailing mode where the mail details can\n            contain template placeholders that will be merged with actual data\n            before being sent to each recipient.\n    	f	t	\N	\N	f	f	f
223	\N	\N	mail.activity.schedule	id	base	fold	{"en_US": "Activity schedule plan Wizard", "es_419": "Asistente para planificar actividades"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
224	\N	\N	mail.activity.schedule.line	line_date_deadline asc, id asc	base	fold	{"en_US": "Mail Activity Schedule Line", "es_419": "Línea de programar la actividad de correo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
225	\N	\N	mail.template.preview	id	base	fold	{"en_US": "Email Template Preview", "es_419": "Vista previa de la plantilla del correo electrónico"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
226	\N	\N	mail.template.reset	id	base	fold	{"en_US": "Mail Template Reset", "es_419": "Restablecer plantilla de correo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
227	\N	\N	mail.followers.edit	id	base	fold	{"en_US": "Followers edit wizard", "es_419": "Asistente para editar seguidores"}	Wizard to edit partners (or channels) to add/remove them to/from followers list.	f	t	\N	\N	f	f	f
352	\N	\N	base.module.install.request	id	base	fold	{"en_US": "Module Activation Request", "es_419": "Solicitud de activación de módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
353	\N	\N	base.module.install.review	id	base	fold	{"en_US": "Module Activation Review", "es_419": "Revisión de la activación del módulo"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
354	\N	\N	google.gmail.mixin	id	base	fold	{"en_US": "Google Gmail Mixin", "es_419": "Mixin de Gmail de Google"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
356	\N	\N	mail.bot	id	base	fold	{"en_US": "Mail Bot", "es_419": "Bot de correo electrónico"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
208	\N	\N	publisher_warranty.contract	id	base	fold	{"en_US": "Publisher Warranty Contract", "es_419": "Contrato de garantía del editor"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
357	\N	\N	microsoft.outlook.mixin	id	base	fold	{"en_US": "Microsoft Outlook Mixin", "es_419": "Mixin de Microsoft Outlook"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
360	\N	\N	phone.blacklist	id	base	fold	{"en_US": "Phone Blacklist", "es_419": "Lista de exclusión de números telefónicos"}	 Blacklist of phone numbers. Used to avoid sending unwanted messages to people. 	f	f	\N	\N	t	f	f
361	\N	\N	mail.thread.phone	id	base	fold	{"en_US": "Phone Blacklist Mixin", "es_419": "Mixin de lista de exclusión de teléfonos"}	 Purpose of this mixin is to offer two services\n\n      * compute a sanitized phone number based on _phone_get_number_fields.\n        It takes first sanitized value, trying each field returned by the\n        method (see ``BaseModel._phone_get_number_fields()´´ for more details\n        about the usage of this method);\n      * compute blacklist state of records. It is based on phone.blacklist\n        model and give an easy-to-use field and API to manipulate blacklisted\n        records;\n\n    Main API methods\n\n      * ``_phone_set_blacklisted``: set recordset as blacklisted;\n      * ``_phone_reset_blacklisted``: reactivate recordset (even if not blacklisted\n        this method can be called safely);\n    	t	f	\N	\N	t	f	f
363	\N	\N	phone.blacklist.remove	id	base	fold	{"en_US": "Remove phone from blacklist", "es_419": "Eliminar teléfono de la lista de exclusión"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
364	\N	\N	privacy.log	id	base	fold	{"en_US": "Privacy Log", "es_419": "Registro de privacidad"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
365	\N	\N	privacy.lookup.wizard	id	base	fold	{"en_US": "Privacy Lookup Wizard", "es_419": "Asistente de búsqueda de privacidad"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
366	\N	\N	privacy.lookup.wizard.line	id	base	fold	{"en_US": "Privacy Lookup Wizard Line", "es_419": "Línea de asistente de búsqueda de privacidad"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
164	\N	\N	fetchmail.server	priority	base	fold	{"en_US": "Incoming Mail Server", "es_419": "Servidor de correos entrantes"}	Add the Outlook OAuth authentication on the incoming mail servers.	f	f	\N	\N	f	f	f
42	\N	\N	ir.mail_server	sequence, id	base	fold	{"en_US": "Mail Server", "es_419": "Servidor de correo"}	Add the Outlook OAuth authentication on the outgoing mail servers.	f	f	\N	\N	f	f	f
138	\N	\N	web.environment.ribbon.backend	id	base	fold	{"en_US": "Web Environment Ribbon Backend", "es_419": "Backend \\"Web Environment Ribbon\\""}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
367	\N	\N	extract.mixin	id	base	fold	{"en_US": "Base class to extract data from documents", "es_419": "Clase base para extraer datos de documentos"}	 Base model to inherit from to add extract functionality to a model. 	t	f	\N	\N	t	f	f
368	\N	\N	extract.mixin.with.words	id	base	fold	{"en_US": "Base class to extract data from documents with OCRed words saved", "es_419": "Clase base para extraer datos de documentos con las palabras OCR guardadas"}	 Base model to inherit from to add extract functionality to a model. 	t	f	\N	\N	t	f	f
369	\N	\N	iap.autocomplete.api	id	base	fold	{"en_US": "IAP Partner Autocomplete API", "es_419": "API de autocompletado del contacto de compras dentro de la aplicación"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
69	\N	\N	ir.module.module	application desc,sequence,name	base	fold	{"en_US": "Module", "es_419": "Módulo"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
102	\N	\N	res.users	name, login	base	fold	{"en_US": "User", "es_419": "Usuario"}	 Update of res.users class\n        - add a preference about sending emails about notifications\n        - make a new user follow itself\n        - add a welcome message\n        - add suggestion preference\n    	f	f	\N	\N	f	f	f
3	\N	\N	ir.model	is_mail_thread DESC, name ASC	base	fold	{"en_US": "Models", "es_419": "Modelos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
171	\N	\N	mail.followers	id	base	fold	{"en_US": "Document Followers", "es_419": "Seguidores del documento"}	 mail_followers holds the data related to the follow mechanism inside\n    Odoo. Partners can choose to follow documents (records) of any kind\n    that inherits from mail.thread. Following documents allow to receive\n    notifications for new messages. A subscription is characterized by:\n\n    :param: res_model: model of the followed objects\n    :param: res_id: ID of resource (may be 0 for every objects)\n    	f	f	\N	\N	f	f	f
147	\N	\N	iap.account	id	base	fold	{"en_US": "IAP Account", "es_419": "Cuenta para compras dentro de la aplicación"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	t	f	f
372	\N	\N	sms.sms	id DESC	base	fold	{"en_US": "Outgoing SMS", "es_419": "SMS salientes"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
373	\N	\N	sms.template	id	base	fold	{"en_US": "SMS Templates", "es_419": "Plantillas de SMS"}	Templates for sending SMS	f	f	\N	\N	f	f	f
374	\N	\N	sms.tracker	id	base	fold	{"en_US": "Link SMS to mailing/sms tracking models", "es_419": "Vincula SMS a los modelos de seguimiento de correo y mensajes de texto"}	Relationship between a sent SMS and tracking records such as notifications and traces.\n\n    This model acts as an extension of a `mail.notification` or a `mailing.trace` and allows to\n    update those based on the SMS provider responses both at sending and when later receiving\n    sent/delivery reports (see `SmsController`).\n    SMS trackers are supposed to be created manually when necessary, and tied to their related\n    SMS through the SMS UUID field. (They are not tied to the SMS records directly as those can\n    be deleted when sent).\n\n    Note: Only admins/system user should need to access (a fortiori modify) these technical\n      records so no "sudo" is used nor should be required here.\n    	f	f	\N	\N	f	f	f
378	\N	\N	sms.composer	id	base	fold	{"en_US": "Send SMS Wizard", "es_419": "Asistente de envío de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
375	\N	\N	sms.account.code	id	base	fold	{"en_US": "SMS Account Verification Code Wizard", "es_419": "Asistente para código de verificación para cuenta de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
376	\N	\N	sms.account.phone	id	base	fold	{"en_US": "SMS Account Registration Phone Number Wizard", "es_419": "Asistente de registro de número de teléfono para cuenta de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
377	\N	\N	sms.account.sender	id	base	fold	{"en_US": "SMS Account Sender Name Wizard", "es_419": "Asistente para nombre de remitente para cuenta de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
379	\N	\N	sms.template.preview	id	base	fold	{"en_US": "SMS Template Preview", "es_419": "Previsualización de la plantilla de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
380	\N	\N	sms.template.reset	id	base	fold	{"en_US": "SMS Template Reset", "es_419": "Restablecer las plantillas de SMS"}	 Model super-class for transient records, meant to be temporarily\n    persistent, and regularly vacuum-cleaned.\n\n    A TransientModel has a simplified access rights management, all users can\n    create new records, and may only access the records they created. The\n    superuser has unrestricted access to all TransientModel records.\n    	f	t	\N	\N	f	f	f
98	\N	\N	res.company	sequence, name	base	fold	{"en_US": "Companies", "es_419": "Empresas"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
165	\N	\N	mail.notification	id	base	fold	{"en_US": "Message Notifications", "es_419": "Notificaciones de mensajes"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
29	\N	\N	ir.actions.report	name, id	base	fold	{"en_US": "Report Action", "es_419": "Acción de reporte"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
381	\N	\N	snailmail.letter	id	base	fold	{"en_US": "Snailmail Letter", "es_419": "Carta de correo postal"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
1	\N	\N	base	id	base	fold	{"en_US": "Base", "es_419": "Base"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
156	\N	\N	mail.render.mixin	id	base	fold	{"en_US": "Mail Render Mixin", "es_419": "Mixin de renderización de correo"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
157	\N	\N	mail.composer.mixin	id	base	fold	{"en_US": "Mail Composer Mixin", "es_419": "Mixin del redactor de correo"}	 Mixin used to edit and render some fields used when sending emails or\n    notifications based on a mail template.\n\n    Main current purpose is to hide details related to subject and body computation\n    and rendering based on a mail.template. It also give the base tools to control\n    who is allowed to edit body, notably when dealing with templating language\n    like inline_template or qweb.\n\n    It is meant to evolve in a near future with upcoming support of qweb and fine\n    grain control of rendering access.\n    	t	f	\N	\N	f	f	f
212	\N	\N	discuss.channel	id	base	fold	{"en_US": "Discussion Channel", "es_419": "Canal de conversaciones"}	Chat Session\n    Representing a conversation between users.\n    It extends the base method for usage with AI assistant.\n    	f	f	\N	\N	t	f	f
30	\N	\N	ir.attachment	id desc	base	fold	{"en_US": "Attachment", "es_419": "Archivos adjuntos"}	Attachments are used to link binary files or url to any openerp document.\n\n    External attachment storage\n    ---------------------------\n\n    The computed field ``datas`` is implemented using ``_file_read``,\n    ``_file_write`` and ``_file_delete``, which can be overridden to implement\n    other storage engines. Such methods should check for other location pseudo\n    uri (example: hdfs://hadoopserver).\n\n    The default implementation is the file:dirname location that stores files\n    on the local filesystem using name based on their sha1 hash\n    	f	f	\N	\N	f	f	f
66	\N	\N	ir.http	id	base	fold	{"en_US": "HTTP Routing", "es_419": "Enrutamiento HTTP"}	 The base model, which is implicitly inherited by all models. 	t	f	\N	\N	f	f	f
158	\N	\N	mail.thread	id	base	fold	{"en_US": "Email Thread", "es_419": "Hilo de correos"}	 mail_thread model is meant to be inherited by any model that needs to\n        act as a discussion topic on which messages can be attached. Public\n        methods are prefixed with ``message_`` in order to avoid name\n        collisions with methods of the models that will inherit from this class.\n\n        ``mail.thread`` defines fields used to handle and display the\n        communication history. ``mail.thread`` also manages followers of\n        inheriting classes. All features and expected behavior are managed\n        by mail.thread. Widgets has been designed for the 7.0 and following\n        versions of Odoo.\n\n        Inheriting classes are not required to implement any method, as the\n        default implementation will work for any model. However it is common\n        to override at least the ``message_new`` and ``message_update``\n        methods (calling ``super``) to add model-specific behavior at\n        creation and update of a thread when processing incoming emails.\n\n    MailThread class options:\n\n     - _mail_flat_thread: if set to True, all messages without parent_id\n       are automatically attached to the first message posted on the\n       resource. If set to False, threads are supported and no parent is forced.\n     - _mail_post_access: required document access when posting on the document.\n       Equivalent to: 'create' rights on mail.message depends notably on\n       document rights, which can be controller using this attribute. Defaults\n       to 'write' as writing is considered as editing. A common customization\n       is to set it to 'read', allowing people with read access to discuss.\n     - _mail_thread_customer: if set to True, consider this model has a strong\n       tie with the customer (found using '_mail_get_customer'). It currently\n       automatically subscribes customer if found in any post recipients.\n\n    MailThread features can be somewhat controlled through context keys :\n\n    # Tracking and logging\n     - ``mail_create_nosubscribe``: at create, do not subscribe uid to the\n       record thread. False by default, as creating = following;\n     - ``mail_create_nolog``: at create, do not log the automatic '<Document>\n       created' message\n     - ``mail_notrack``: at create and write, do not perform the value tracking\n       creating messages;\n     - ``tracking_disable``: at create and write, perform no MailThread features\n       (auto subscription, tracking, post, ...);\n    # Posting process\n     - ``mail_notify_force_send``: if less than 50 email notifications to send,\n       send them directly instead of using the queue i.e. controls 'force_send'\n       parameter of '_notify_thread_by_email'. True by default as it is\n       the desired behavior;\n     - ``mail_notify_author``: notify author if they are in potential notified\n       partners (e.g. following a document on which they post) i.e. controls\n       'notify_author' parameter of '_notify_get_recipients'. False by default\n       as people should not be notified of what they typed;\n     - ``mail_notify_author_mention``: notify author if they are in direct\n       recipients ('partner_ids') i.e. controls 'notify_author_mention'. Used\n       in flows involving auto replies where author could be used to contact\n       themselves. False by default;\n    # Post side effects\n     - ``mail_auto_subscribe_no_notify``: skip notifications linked to auto\n       subscription. False by default, notifications are intended;\n     - ``mail_post_autofollow``: subscribe specific recipients ('partner_ids') during\n        message_post. False by default;\n     - ``mail_post_autofollow_author_skip``: do not subscribe author of a message\n        post. False by default, as we consider authors should receive answers;\n    	t	f	\N	\N	t	f	f
95	\N	\N	res.config.settings	id	base	fold	{"en_US": "Config Settings", "es_419": "Ajustes de configuración"}	 Inherit the base settings to add a counter of failed email + configure\n    the alias domain. 	f	t	\N	\N	f	f	f
90	\N	\N	res.partner	complete_name ASC, id DESC	base	fold	{"en_US": "Contact", "es_419": "Contacto"}	 Purpose of this mixin is to offer two services\n\n      * compute a sanitized phone number based on _phone_get_number_fields.\n        It takes first sanitized value, trying each field returned by the\n        method (see ``BaseModel._phone_get_number_fields()´´ for more details\n        about the usage of this method);\n      * compute blacklist state of records. It is based on phone.blacklist\n        model and give an easy-to-use field and API to manipulate blacklisted\n        records;\n\n    Main API methods\n\n      * ``_phone_set_blacklisted``: set recordset as blacklisted;\n      * ``_phone_reset_blacklisted``: reactivate recordset (even if not blacklisted\n        this method can be called safely);\n    	f	f	\N	\N	t	t	t
382	\N	\N	ai.topic	id	base	fold	{"en_US": "Create a topic that leverages instructions and tools to direct Odoo AI in assisting the user with their tasks.", "es_419": "Crea un tema que aproveche las instrucciones y herramientas para orientar a la IA de Odoo y que pueda ayudar al usuario con sus tareas."}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
383	\N	\N	ai.agent	name	base	fold	{"en_US": "AI Agent", "es_419": "Agente de IA"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
384	\N	\N	ai.agent.source	name	base	fold	{"en_US": "AI Agent Source", "es_419": "Origen del agente de IA"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
385	\N	\N	ai.embedding	sequence	base	fold	{"en_US": "Attachment Chunks Embedding", "es_419": "Incrustación de segmentos adjuntos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
386	\N	\N	ai.prompt.button	id	base	fold	{"en_US": "Prompt that can be attached to AI UI rules for quick access by the user.", "es_419": "Instrucción que puede adjuntarse a las reglas de la interfaz de usuario de la IA para acceso rápido."}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
387	\N	\N	ai.composer	id	base	fold	{"en_US": "AI model configurations (system prompts) for text drafting.", "es_419": "Configuraciones de modelos de IA (instrucciones del sistema) para redactar textos."}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
4	\N	\N	ir.model.fields	name, id	base	fold	{"en_US": "Fields", "es_419": "Campos"}	 Main super-class for regular database-persisted Odoo models.\n\n    Odoo models are created by inheriting from this class::\n\n        class ResUsers(Model):\n            ...\n\n    The system will later instantiate the class once per database (on\n    which the class' module is installed).\n    	f	f	\N	\N	f	f	f
179	\N	\N	mail.message	id desc	base	fold	{"en_US": "Message", "es_419": "Mensaje"}	 Override MailMessage class in order to add a new type: SMS messages.\n    Those messages comes with their own notification method, using SMS\n    gateway. 	f	f	\N	\N	f	f	f
25	\N	\N	ir.actions.server	sequence,name,id	base	fold	{"en_US": "Server Action", "es_419": "Acción del servidor"}	 Add SMS option in server actions. 	f	f	\N	\N	t	t	f
\.


--
-- Data for Name: ir_model_access; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_access (id, model_id, group_id, create_uid, write_uid, name, active, perm_read, perm_write, perm_create, perm_unlink, create_date, write_date) FROM stdin;
1	114	4	1	1	decimal.precision configuration	t	t	t	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
2	30	1	1	1	ir_attachment group_user	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
3	30	\N	1	1	ir_attachment group_portal_public	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
4	32	4	1	1	ir_cron group_cron	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
5	34	4	1	1	ir_cron_progress group_cron	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
6	33	4	1	1	ir_cron_trigger group_cron	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
7	37	8	1	1	ir_exports group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
8	38	1	1	1	ir_exports_line group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
9	3	2	1	1	ir_model group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
10	7	2	1	1	ir_model_constraint group_erp_manager	t	t	t	f	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
11	8	2	1	1	ir_model_relation group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
12	5	\N	1	1	ir_model_inherit nobody	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
13	9	2	1	1	ir_model_access_group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
14	10	2	1	1	ir_model_data group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
15	4	2	1	1	ir_model_fields group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
16	6	2	1	1	ir_model_fields_selection group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
17	3	1	1	1	ir_model_all	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
18	10	1	1	1	ir_model_data user	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
19	4	1	1	1	ir_model_fields all	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
20	6	1	1	1	ir_model_fields_selection all	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
21	99	1	1	1	res_groups_privilege group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
22	99	2	1	1	res_groups_privilege group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
23	68	2	1	1	ir_module_category group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
24	69	4	1	1	ir_module_module group_user	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
25	70	4	1	1	ir_module_module_dependency group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
26	71	4	1	1	ir_module_module_exclusion group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
27	39	2	1	1	ir_rule group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
28	11	1	1	1	ir_sequence group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
29	11	4	1	1	ir_sequence group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
30	12	1	1	1	ir_sequence_date_range group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
31	12	4	1	1	ir_sequence_date_range group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
32	13	1	1	1	ir_ui_menu group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
33	13	4	1	1	ir_ui_menu group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
34	15	\N	1	1	ir_ui_view group_user	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
35	15	4	1	1	ir_ui_view group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
36	16	4	1	1	reset_view_arch_wizard group_system	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
37	14	4	1	1	ir_ui_view_custom_group_user	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
38	36	\N	1	1	ir_default all	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
39	36	1	1	1	ir_default group_user	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
40	36	4	1	1	ir_default group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
41	98	2	1	1	res_company group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
42	98	11	1	1	res_company group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
43	98	10	1	1	res_company group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
44	98	1	1	1	res_company group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
45	83	11	1	1	res_country group_user_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
46	83	10	1	1	res_country group_user_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
47	83	1	1	1	res_country group_user_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
48	85	11	1	1	res_country_state group_user_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
49	85	10	1	1	res_country_state group_user_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
50	85	1	1	1	res_country_state group_user_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
51	84	11	1	1	res_country_group group_user_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
52	84	10	1	1	res_country_group group_user_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
53	84	1	1	1	res_country_group group_user_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
54	83	9	1	1	res_country group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
55	83	4	1	1	res_country_group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
56	85	9	1	1	res_country_state group_user	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
57	84	9	1	1	res_country_group group_user	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
58	96	11	1	1	res_currency group_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
59	96	10	1	1	res_currency group_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
60	96	1	1	1	res_currency group_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
61	97	11	1	1	res_currency_rate group_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
62	97	10	1	1	res_currency_rate group_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
63	97	1	1	1	res_currency_rate group_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
64	96	4	1	1	res_currency group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
65	97	4	1	1	res_currency_rate group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
66	100	2	1	1	res_groups group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
67	100	1	1	1	res_groups group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
68	86	11	1	1	res_lang group_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
69	86	10	1	1	res_lang group_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
70	86	1	1	1	res_lang group_all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
71	86	4	1	1	res_lang group_user	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
72	90	11	1	1	res_partner group_public	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
73	90	10	1	1	res_partner group_portal	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
74	90	9	1	1	res_partner group_partner_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
75	90	1	1	1	res_partner group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
76	93	1	1	1	res_partner_bank group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
77	93	9	1	1	res_partner_bank group_partner_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
78	89	1	1	1	res_partner_category group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
79	89	9	1	1	res_partner_category group_partner_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
80	91	1	1	1	res_partner_industry group_user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
164	142	1	1	1	access_auth_passkey_key_create	t	t	t	t	t	2026-02-19 14:17:55.572166	2026-02-19 14:17:55.572166
81	91	4	1	1	res_partner_industry group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
82	102	11	1	1	res_users all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
83	102	10	1	1	res_users all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
84	102	1	1	1	res_users all	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
85	102	2	1	1	res_users group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
86	111	\N	1	1	res_users_deletion all	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
87	111	2	1	1	res_users_deletion group_erp_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
88	101	4	1	1	res_users_log_all	t	t	f	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
89	103	1	1	1	id check employees	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
90	103	10	1	1	id check portal	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
91	107	1	1	1	API keys access employees	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
92	107	10	1	1	API keys access portal	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
93	108	1	1	1	API key wizard employees	t	t	f	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
94	108	10	1	1	API key wizard	t	t	f	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
95	109	1	1	1	API key result employees	t	t	f	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
96	110	\N	1	1	res.users.settings	t	f	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
97	110	1	1	1	res.users.settings	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
98	17	4	1	1	ir_asset_group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
99	18	4	1	1	ir_actions_group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
100	19	4	1	1	ir_actions_act_window_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
101	21	4	1	1	ir_actions_act_window_close_group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
102	29	4	1	1	ir_actions_report_group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
103	26	4	1	1	ir_actions_todo group system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
104	20	4	1	1	ir_actions_act_window_view_group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
105	22	4	1	1	ir_actions_act_url_group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
106	25	4	1	1	ir_actions_server_group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
107	24	4	1	1	ir_actions_server_history_group_system	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
108	28	1	1	1	ir_embedded_actions_group_user	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
109	27	4	1	1	ir_actions_client all	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
110	92	4	1	1	res_bank_group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
111	92	9	1	1	res_bank_group_partner_manager	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
112	92	1	1	1	res_bank user	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
113	35	2	1	1	ir_filters all	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
114	35	1	1	1	ir_filters all	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
115	35	10	1	1	ir_filters all	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
116	35	11	1	1	ir_filters all	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
117	40	4	1	1	ir_config_parameter_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
118	42	4	1	1	ir_mail_server	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
119	67	2	1	1	ir_logging admin	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
120	78	1	1	1	ir_actions_report_paperformat group_portal	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
121	78	4	1	1	ir_actions_report_paperformat group_system	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
122	77	1	1	1	access_report_layout	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
123	124	4	1	1	access.wizard.ir.model.menu.create	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
124	16	2	1	1	access.reset.view.arch.wizard	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
125	23	4	1	1	access.server.action.history.wizard	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
126	72	4	1	1	access.ir.demo	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
127	73	4	1	1	access.ir.demo_failure	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
128	74	4	1	1	access.ir.demo_failure.wizard	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
129	94	4	1	1	access.res.config	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
130	95	4	1	1	access.res.config.settings	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
131	104	2	1	1	access.change.password.wizard	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
132	105	2	1	1	access.change.password.user	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
133	106	1	1	1	access.change.password.own	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
134	116	4	1	1	access.base.module.update	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
135	117	4	1	1	access.base.language.install	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
136	118	4	1	1	access.base.language.import	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
137	119	4	1	1	access.base.module.upgrade	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
138	120	4	1	1	access.base.module.uninstall	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
139	121	1	1	1	access.base.language.export	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
140	122	9	1	1	access.base.partner.merge.line	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
141	123	9	1	1	access.base.partner.merge.automatic.wizard	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
142	79	4	1	1	ir_profile	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
143	80	4	1	1	access.base.enable.profiling.wizard	t	t	t	t	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
144	113	1	1	1	access_res_device	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
145	112	1	1	1	access_res_device_log	t	t	f	f	f	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
146	75	4	1	1	access_properties_base_definition	t	t	t	t	t	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
147	126	4	1	1	access.base.document.layout	t	t	t	t	f	2026-02-19 14:17:52.907935	2026-02-19 14:17:52.907935
148	127	1	1	1	res.users.settings.embedded.action	t	t	t	t	t	2026-02-19 14:17:52.907935	2026-02-19 14:17:52.907935
149	130	1	1	1	auth_totp wizard access rules	t	t	t	t	t	2026-02-19 14:17:53.952449	2026-02-19 14:17:53.952449
150	128	1	1	1	TOTP Device access employees	t	t	f	f	f	2026-02-19 14:17:53.952449	2026-02-19 14:17:53.952449
151	128	10	1	1	TOTP Device access portal	t	t	f	f	f	2026-02-19 14:17:53.952449	2026-02-19 14:17:53.952449
152	129	1	1	1	access_auth_totp_rate_limit_log	t	f	f	f	f	2026-02-19 14:17:53.952449	2026-02-19 14:17:53.952449
153	131	1	1	1	base.import.mapping	t	t	t	t	t	2026-02-19 14:17:54.135004	2026-02-19 14:17:54.135004
154	132	1	1	1	access.base_import.import	t	t	t	t	f	2026-02-19 14:17:54.135004	2026-02-19 14:17:54.135004
155	133	4	1	1	access.base.import.module	t	t	t	t	f	2026-02-19 14:17:54.40811	2026-02-19 14:17:54.40811
156	135	\N	1	1	bus.bus public	t	f	f	f	f	2026-02-19 14:17:54.598096	2026-02-19 14:17:54.598096
157	139	4	1	1	access_web_tour_tour_admin	t	t	t	t	t	2026-02-19 14:17:55.456461	2026-02-19 14:17:55.456461
158	139	1	1	1	access_web_tour_tour_readonly	t	t	f	f	f	2026-02-19 14:17:55.456461	2026-02-19 14:17:55.456461
159	140	4	1	1	access_web_tour_tour_step_admin	t	t	t	t	t	2026-02-19 14:17:55.456461	2026-02-19 14:17:55.456461
160	140	1	1	1	access_web_tour_tour_step_readonly	t	t	f	f	f	2026-02-19 14:17:55.456461	2026-02-19 14:17:55.456461
161	141	1	1	1	access_auth_passkey_key	t	t	t	f	f	2026-02-19 14:17:55.572166	2026-02-19 14:17:55.572166
162	141	10	1	1	access_auth_passkey_key_portal	t	t	t	f	f	2026-02-19 14:17:55.572166	2026-02-19 14:17:55.572166
163	141	2	1	1	access_auth_passkey_key_admin	t	t	t	f	t	2026-02-19 14:17:55.572166	2026-02-19 14:17:55.572166
165	142	10	1	1	access_auth_passkey_key_create_portal	t	t	t	t	t	2026-02-19 14:17:55.572166	2026-02-19 14:17:55.572166
166	144	4	1	1	access_html_editor_converter_test	t	t	t	t	t	2026-02-19 14:17:55.874388	2026-02-19 14:17:55.874388
167	145	4	1	1	access_html_editor_converter_test_sub	t	t	t	t	t	2026-02-19 14:17:55.874388	2026-02-19 14:17:55.874388
168	147	4	1	1	iap.account.manager	t	t	t	t	t	2026-02-19 14:17:56.17534	2026-02-19 14:17:56.17534
169	147	1	1	1	iap.account.user	t	t	f	t	f	2026-02-19 14:17:56.17534	2026-02-19 14:17:56.17534
170	149	4	1	1	iap.service.manager	t	t	t	t	t	2026-02-19 14:17:56.17534	2026-02-19 14:17:56.17534
171	149	1	1	1	iap.service.user	t	t	f	f	f	2026-02-19 14:17:56.17534	2026-02-19 14:17:56.17534
172	164	4	1	1	fetchmail.server	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
173	179	11	1	1	mail.message.all	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
174	179	10	1	1	mail.message.portal	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
175	179	1	1	1	mail.message.user	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
176	176	4	1	1	mail.message.scheduled.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
177	180	4	1	1	mail.mail.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
178	171	1	1	1	mail.followers.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
179	171	4	1	1	mail.followers.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
180	165	10	1	1	mail.notification.portal	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
181	165	1	1	1	mail.notification.user	t	t	t	t	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
182	165	4	1	1	 mail.notification.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
183	212	11	1	1	discuss.channel.public	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
184	212	10	1	1	discuss.channel.portal	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
185	212	1	1	1	discuss.channel.user	t	t	t	t	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
186	212	4	1	1	discuss.channel.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
187	210	11	1	1	discuss.channel.member.public	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
188	210	10	1	1	discuss.channel.member.portal	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
189	210	1	1	1	discuss.channel.member.user	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
190	211	4	1	1	discuss.channel.rtc.session.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
191	209	1	1	1	discuss.call.history.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
192	209	11	1	1	discuss.call.history.public	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
193	209	10	1	1	discuss.call.history.portal	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
194	206	1	1	1	res.role.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
195	206	2	1	1	res.role.admin	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
196	150	1	1	1	mail.alias.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
197	150	4	1	1	mail.alias.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
198	151	1	1	1	mail.alias.domain.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
199	151	2	1	1	mail.alias.domain.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
200	172	4	1	1	mail.gateway.allowed.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
201	175	4	1	1	mail.message.reaction.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
202	177	11	1	1	mail.message.subtype.all	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
203	177	10	1	1	mail.message.subtype.all	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
204	177	1	1	1	mail.message.subtype.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
205	177	4	1	1	mail.message.subtype.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
206	181	4	1	1	mail.presence	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
207	185	4	1	1	mail.tracking.value.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
208	208	4	1	1	publisher.warranty.contract.all	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
209	186	1	1	1	mail.template	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
210	186	15	1	1	mail.template_editor	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
211	186	4	1	1	mail.template_system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
212	188	1	1	1	mail.canned.response	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
213	167	1	1	1	mail.activity.user	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
214	168	1	1	1	mail.activity.plan.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
215	168	4	1	1	mail.activity.plan.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
216	169	1	1	1	mail.activity.plan.template.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
217	169	4	1	1	mail.activity.plan.template.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
218	223	1	1	1	mail.activity.schedule.user	t	t	t	t	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
219	224	1	1	1	mail.activity.schedule.line.user	t	t	t	t	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
220	166	1	1	1	mail.activity.type.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
221	166	4	1	1	mail.activity.type.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
222	170	4	1	1	access_mail_blacklist_system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
223	227	1	1	1	access.mail.followers.edit	t	t	t	t	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
224	222	1	1	1	access.mail.compose.message	t	t	t	t	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
225	225	1	1	1	access.mail.template.preview	t	t	t	t	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
226	221	4	1	1	acesss.mail.blacklist.remove.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
227	215	1	1	1	mail.guest	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
228	215	4	1	1	mail.guest	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
229	187	4	1	1	mail.ice.server.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
230	190	1	1	1	res.users.settings.volumes	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
231	226	15	1	1	access.mail.template.reset	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
232	29	1	1	1	ir.actions.report.access.user	t	t	f	f	f	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
233	173	2	1	1	mail.link.preview.admin	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
234	174	2	1	1	mail.link.preview.erp_manager	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
235	213	1	1	1	discuss.gif.favorite	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
236	214	4	1	1	discuss.voice.metadata.user	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
237	182	4	1	1	access.mail.push.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
238	183	4	1	1	access.mail.push.device.system	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
239	178	4	1	1	mail.message.translation	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
240	184	1	1	1	access.mail.scheduled.message	t	t	t	t	t	2026-02-19 14:17:56.616872	2026-02-19 14:17:56.616872
241	352	1	1	1	access_base_module_install_request	t	t	t	t	f	2026-02-19 14:17:59.215236	2026-02-19 14:17:59.215236
242	353	4	1	1	access_base_module_install_review	t	t	t	t	f	2026-02-19 14:17:59.215236	2026-02-19 14:17:59.215236
243	68	1	1	1	ir_module_category group_user	t	t	f	f	f	2026-02-19 14:17:59.215236	2026-02-19 14:17:59.215236
244	69	1	1	1	ir_module_module group_user	t	t	f	f	f	2026-02-19 14:17:59.215236	2026-02-19 14:17:59.215236
245	70	1	1	1	ir_module_module_dependency group_user	t	t	f	f	f	2026-02-19 14:17:59.215236	2026-02-19 14:17:59.215236
246	71	1	1	1	ir_module_module_exclusion group_user	t	t	f	f	f	2026-02-19 14:17:59.215236	2026-02-19 14:17:59.215236
247	360	\N	1	1	access.phone.blacklist.all	t	f	f	f	f	2026-02-19 14:17:59.669059	2026-02-19 14:17:59.669059
248	360	4	1	1	access.phone.blacklist.system	t	t	t	t	t	2026-02-19 14:17:59.669059	2026-02-19 14:17:59.669059
249	363	4	1	1	acesss.phone.blacklist.remove.system	t	t	t	t	t	2026-02-19 14:17:59.669059	2026-02-19 14:17:59.669059
250	365	4	1	1	access_privacy_lookup_wizard	t	t	t	t	t	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805
251	366	4	1	1	access_privacy_lookup_wizard_line	t	t	t	t	f	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805
252	364	4	1	1	access_privacy_log	t	t	t	t	t	2026-02-19 14:18:00.166805	2026-02-19 14:18:00.166805
253	372	\N	1	1	access.sms.sms.all	t	f	f	f	f	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
254	372	4	1	1	access.sms.sms.system	t	t	t	t	t	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
255	373	\N	1	1	access.sms.template.all	t	f	f	f	f	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
256	373	1	1	1	access.sms.template.user	t	t	f	f	f	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
257	373	4	1	1	access.sms.template.system	t	t	t	t	t	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
258	374	\N	1	1	access.sms.tracker.all	t	f	f	f	f	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
259	374	4	1	1	access.sms.tracker.system	t	t	t	t	t	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
260	378	1	1	1	access.sms.composer	t	t	t	t	f	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
261	379	1	1	1	access.sms.template.preview	t	t	t	t	f	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
262	380	15	1	1	access.sms.template.reset	t	t	t	t	t	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
263	376	4	1	1	access.sms.account.phone.system	t	t	t	t	t	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
264	375	4	1	1	access.sms.account.code.system	t	t	t	t	t	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
265	377	4	1	1	access.sms.account.sender.system	t	t	t	t	t	2026-02-19 14:18:00.812257	2026-02-19 14:18:00.812257
266	381	1	1	1	snailmail.letter.user	t	t	t	t	f	2026-02-19 14:18:01.593522	2026-02-19 14:18:01.593522
267	381	4	1	1	snailmail.letter.system	t	t	t	t	t	2026-02-19 14:18:01.593522	2026-02-19 14:18:01.593522
268	383	1	1	1	access_ai_agent_user	t	t	f	f	f	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
269	385	1	1	1	access_ai_embedding_user	t	t	f	f	f	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
270	382	1	1	1	access_ai_topic_user	t	t	f	f	f	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
271	383	4	1	1	access_ai_agent_system	t	t	t	t	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
272	385	4	1	1	access_ai_embedding_system	t	t	t	t	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
273	382	4	1	1	access_ai_topic_system	t	t	t	t	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
274	387	1	1	1	ai.composer	t	t	f	f	f	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
275	387	4	1	1	ai.composer	t	t	t	t	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
276	386	1	1	1	access_ai_prompt_button_user	t	t	f	f	f	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
277	386	4	1	1	ai.access_ai_prompt_button_admin.button	t	t	t	t	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
278	384	1	1	1	access_ai_agent_source_user	t	t	f	f	f	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
279	384	4	1	1	access_ai_agent_source_system	t	t	t	t	t	2026-02-19 14:18:01.804901	2026-02-19 14:18:01.804901
\.


--
-- Data for Name: ir_model_constraint; Type: TABLE DATA; Schema: public; Owner: runbot
--

COPY public.ir_model_constraint (id, model, module, create_uid, write_uid, name, definition, type, message, create_date, write_date) FROM stdin;
9	10	165	1	1	ir_model_data_module_name_uniq_index	UNIQUE INDEX (module, name)	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
10	10	165	1	1	ir_model_data_model_res_id_index	INDEX (model, res_id)	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
12	14	165	1	1	ir_ui_view_custom_user_id_ref_id	INDEX (user_id, ref_id)	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
15	15	165	1	1	ir_ui_view_model_type_inherit_id	INDEX (model, inherit_id)	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
18	20	165	1	1	ir_act_window_view_unique_mode_per_action	UNIQUE INDEX (act_window_id, view_mode)	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
25	30	165	1	1	ir_attachment_res_idx	INDEX (res_model, res_id)	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
27	35	165	1	1	ir_filters_get_filters_index	INDEX (model_id, action_id, embedded_action_id, embedded_parent_res_id)	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
53	112	165	1	1	res_device_log_composite_idx	INDEX (user_id, session_identifier, platform, browser, last_activity, id) WHERE revoked IS NOT TRUE	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
54	112	165	1	1	res_device_log_revoked_idx	INDEX (revoked) WHERE revoked IS NOT TRUE	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
55	113	165	1	1	res_device_composite_idx	INDEX (user_id, session_identifier, platform, browser, last_activity, id) WHERE revoked IS NOT TRUE	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
56	113	165	1	1	res_device_revoked_idx	INDEX (revoked) WHERE revoked IS NOT TRUE	i	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
58	3	165	1	1	ir_model_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
59	3	165	1	1	ir_model_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
60	4	165	1	1	ir_model_fields_group_rel_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
61	4	165	1	1	ir_model_fields_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
62	4	165	1	1	ir_model_fields_relation_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
63	4	165	1	1	ir_model_fields_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
64	4	165	1	1	ir_model_fields_related_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
65	4	165	1	1	ir_model_fields_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
66	4	165	1	1	ir_model_fields_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
67	5	165	1	1	ir_model_inherit_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
68	5	165	1	1	ir_model_inherit_parent_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
69	5	165	1	1	ir_model_inherit_parent_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
70	6	165	1	1	ir_model_fields_selection_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
71	6	165	1	1	ir_model_fields_selection_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
72	6	165	1	1	ir_model_fields_selection_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
73	7	165	1	1	ir_model_constraint_model_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
74	7	165	1	1	ir_model_constraint_module_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
75	7	165	1	1	ir_model_constraint_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
76	7	165	1	1	ir_model_constraint_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
77	8	165	1	1	ir_model_relation_model_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
78	8	165	1	1	ir_model_relation_module_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
79	8	165	1	1	ir_model_relation_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
80	8	165	1	1	ir_model_relation_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
81	9	165	1	1	ir_model_access_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
82	9	165	1	1	ir_model_access_group_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
83	9	165	1	1	ir_model_access_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
84	9	165	1	1	ir_model_access_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
85	10	165	1	1	ir_model_data_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
86	10	165	1	1	ir_model_data_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
87	11	165	1	1	ir_sequence_company_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
88	11	165	1	1	ir_sequence_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
89	11	165	1	1	ir_sequence_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
90	12	165	1	1	ir_sequence_date_range_sequence_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
91	12	165	1	1	ir_sequence_date_range_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
92	12	165	1	1	ir_sequence_date_range_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
93	100	165	1	1	ir_ui_menu_group_rel_menu_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
94	13	165	1	1	ir_ui_menu_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
95	13	165	1	1	ir_ui_menu_parent_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
96	13	165	1	1	ir_ui_menu_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
97	13	165	1	1	ir_ui_menu_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
98	14	165	1	1	ir_ui_view_custom_ref_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
99	14	165	1	1	ir_ui_view_custom_user_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
100	14	165	1	1	ir_ui_view_custom_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
101	14	165	1	1	ir_ui_view_custom_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
102	100	165	1	1	ir_ui_view_group_rel_view_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
103	15	165	1	1	ir_ui_view_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
104	15	165	1	1	ir_ui_view_inherit_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
105	15	165	1	1	ir_ui_view_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
106	15	165	1	1	ir_ui_view_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
107	16	165	1	1	reset_view_arch_wizard_view_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
108	16	165	1	1	reset_view_arch_wizard_compare_view_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
109	16	165	1	1	reset_view_arch_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
110	16	165	1	1	reset_view_arch_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
111	17	165	1	1	ir_asset_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
112	17	165	1	1	ir_asset_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
113	21	165	1	1	ir_actions_binding_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
114	21	165	1	1	ir_actions_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
115	21	165	1	1	ir_actions_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
116	19	165	1	1	ir_act_window_group_rel_act_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
117	19	165	1	1	ir_act_window_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
118	19	165	1	1	ir_act_window_binding_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
119	19	165	1	1	ir_act_window_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
120	19	165	1	1	ir_act_window_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
121	19	165	1	1	ir_act_window_view_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
122	19	165	1	1	ir_act_window_search_view_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
123	20	165	1	1	ir_act_window_view_view_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
124	20	165	1	1	ir_act_window_view_act_window_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
125	20	165	1	1	ir_act_window_view_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
126	20	165	1	1	ir_act_window_view_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
127	22	165	1	1	ir_act_url_binding_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
128	22	165	1	1	ir_act_url_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
129	22	165	1	1	ir_act_url_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
130	23	165	1	1	server_action_history_wizard_action_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
131	23	165	1	1	server_action_history_wizard_revision_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
132	23	165	1	1	server_action_history_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
133	23	165	1	1	server_action_history_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
134	24	165	1	1	ir_actions_server_history_action_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
135	24	165	1	1	ir_actions_server_history_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
136	24	165	1	1	ir_actions_server_history_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
137	25	165	1	1	ir_act_server_group_rel_act_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
138	25	165	1	1	ir_act_server_group_rel_gid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
139	25	165	1	1	ir_act_server_webhook_field_rel_server_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
140	25	165	1	1	ir_act_server_webhook_field_rel_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
141	25	165	1	1	ir_act_server_binding_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
142	25	165	1	1	ir_act_server_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
143	25	165	1	1	ir_act_server_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
144	25	165	1	1	ir_act_server_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
145	25	165	1	1	ir_act_server_parent_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
146	25	165	1	1	ir_act_server_crud_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
147	25	165	1	1	ir_act_server_link_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
148	25	165	1	1	ir_act_server_update_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
149	25	165	1	1	ir_act_server_update_related_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
150	25	165	1	1	ir_act_server_sequence_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
151	25	165	1	1	ir_act_server_selection_value_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
152	26	165	1	1	ir_actions_todo_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
153	26	165	1	1	ir_actions_todo_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
154	27	165	1	1	ir_act_client_binding_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
155	27	165	1	1	ir_act_client_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
156	27	165	1	1	ir_act_client_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
157	28	165	1	1	ir_embedded_actions_res_groups_rel_ir_embedded_actions_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
158	28	165	1	1	ir_embedded_actions_res_groups_rel_res_groups_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
159	28	165	1	1	ir_embedded_actions_parent_action_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
160	28	165	1	1	ir_embedded_actions_user_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
161	28	165	1	1	ir_embedded_actions_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
162	28	165	1	1	ir_embedded_actions_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
163	29	165	1	1	res_groups_report_rel_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
164	29	165	1	1	res_groups_report_rel_gid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
165	29	165	1	1	ir_act_report_xml_binding_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
166	29	165	1	1	ir_act_report_xml_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
167	29	165	1	1	ir_act_report_xml_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
168	29	165	1	1	ir_act_report_xml_paperformat_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
169	30	165	1	1	ir_attachment_company_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
170	30	165	1	1	ir_attachment_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
171	30	165	1	1	ir_attachment_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
172	32	165	1	1	ir_cron_ir_actions_server_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
173	32	165	1	1	ir_cron_user_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
174	32	165	1	1	ir_cron_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
175	32	165	1	1	ir_cron_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
176	33	165	1	1	ir_cron_trigger_cron_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
177	33	165	1	1	ir_cron_trigger_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
178	33	165	1	1	ir_cron_trigger_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
179	34	165	1	1	ir_cron_progress_cron_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
180	34	165	1	1	ir_cron_progress_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
181	34	165	1	1	ir_cron_progress_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
182	35	165	1	1	ir_filters_res_users_rel_ir_filters_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
183	35	165	1	1	ir_filters_res_users_rel_res_users_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
184	35	165	1	1	ir_filters_embedded_action_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
185	35	165	1	1	ir_filters_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
186	35	165	1	1	ir_filters_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
187	36	165	1	1	ir_default_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
188	36	165	1	1	ir_default_user_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
189	36	165	1	1	ir_default_company_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
190	36	165	1	1	ir_default_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
191	36	165	1	1	ir_default_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
192	37	165	1	1	ir_exports_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
193	37	165	1	1	ir_exports_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
194	38	165	1	1	ir_exports_line_export_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
195	38	165	1	1	ir_exports_line_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
196	38	165	1	1	ir_exports_line_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
197	100	165	1	1	rule_group_rel_rule_group_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
198	39	165	1	1	rule_group_rel_group_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
199	39	165	1	1	ir_rule_model_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
200	39	165	1	1	ir_rule_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
201	39	165	1	1	ir_rule_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
202	40	165	1	1	ir_config_parameter_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
203	40	165	1	1	ir_config_parameter_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
204	42	165	1	1	ir_mail_server_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
205	42	165	1	1	ir_mail_server_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
206	68	165	1	1	ir_module_category_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
207	68	165	1	1	ir_module_category_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
208	69	165	1	1	module_country_module_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
209	69	165	1	1	module_country_country_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
210	69	165	1	1	ir_module_module_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
211	69	165	1	1	ir_module_module_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
212	71	165	1	1	ir_module_module_exclusion_module_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
213	71	165	1	1	ir_module_module_exclusion_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
214	71	165	1	1	ir_module_module_exclusion_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
215	72	165	1	1	ir_demo_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
216	72	165	1	1	ir_demo_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
217	73	165	1	1	ir_demo_failure_module_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
218	73	165	1	1	ir_demo_failure_wizard_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
219	73	165	1	1	ir_demo_failure_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
220	73	165	1	1	ir_demo_failure_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
221	74	165	1	1	ir_demo_failure_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
222	74	165	1	1	ir_demo_failure_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
223	75	165	1	1	properties_base_definition_properties_field_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
224	75	165	1	1	properties_base_definition_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
225	75	165	1	1	properties_base_definition_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
226	77	165	1	1	report_layout_view_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
227	77	165	1	1	report_layout_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
228	77	165	1	1	report_layout_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
229	78	165	1	1	report_paperformat_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
230	78	165	1	1	report_paperformat_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
231	80	165	1	1	base_enable_profiling_wizard_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
232	80	165	1	1	base_enable_profiling_wizard_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
233	84	165	1	1	res_country_res_country_group_rel_res_country_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
234	83	165	1	1	res_country_res_country_group_rel_res_country_group_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
235	83	165	1	1	res_country_address_view_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
236	83	165	1	1	res_country_currency_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
237	83	165	1	1	res_country_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
238	83	165	1	1	res_country_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
239	84	165	1	1	res_country_group_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
240	84	165	1	1	res_country_group_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
241	85	165	1	1	res_country_state_country_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
242	85	165	1	1	res_country_state_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
243	85	165	1	1	res_country_state_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
244	86	165	1	1	res_lang_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
245	86	165	1	1	res_lang_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
246	90	165	1	1	res_partner_res_partner_category_rel_category_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
247	89	165	1	1	res_partner_res_partner_category_rel_partner_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
248	89	165	1	1	res_partner_category_parent_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
249	89	165	1	1	res_partner_category_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
250	89	165	1	1	res_partner_category_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
251	90	165	1	1	res_partner_parent_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
252	90	165	1	1	res_partner_user_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
253	90	165	1	1	res_partner_state_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
254	90	165	1	1	res_partner_country_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
255	90	165	1	1	res_partner_industry_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
256	90	165	1	1	res_partner_company_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
257	90	165	1	1	res_partner_commercial_partner_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
258	90	165	1	1	res_partner_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
259	90	165	1	1	res_partner_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
260	91	165	1	1	res_partner_industry_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
261	91	165	1	1	res_partner_industry_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
262	92	165	1	1	res_bank_state_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
263	92	165	1	1	res_bank_country_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
264	92	165	1	1	res_bank_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
265	92	165	1	1	res_bank_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
266	93	165	1	1	res_partner_bank_partner_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
267	93	165	1	1	res_partner_bank_bank_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
268	93	165	1	1	res_partner_bank_currency_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
269	93	165	1	1	res_partner_bank_company_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
270	93	165	1	1	res_partner_bank_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
271	93	165	1	1	res_partner_bank_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
272	94	165	1	1	res_config_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
273	94	165	1	1	res_config_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
274	95	165	1	1	res_config_settings_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
275	95	165	1	1	res_config_settings_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
276	96	165	1	1	res_currency_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
277	96	165	1	1	res_currency_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
278	97	165	1	1	res_currency_rate_currency_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
279	97	165	1	1	res_currency_rate_company_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
280	97	165	1	1	res_currency_rate_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
281	97	165	1	1	res_currency_rate_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
282	102	165	1	1	res_company_users_rel_cid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
283	98	165	1	1	res_company_users_rel_user_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
284	98	165	1	1	res_company_parent_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
285	98	165	1	1	res_company_partner_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
286	98	165	1	1	res_company_currency_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
287	98	165	1	1	res_company_paperformat_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
288	98	165	1	1	res_company_external_report_layout_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
289	98	165	1	1	res_company_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
290	98	165	1	1	res_company_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
291	99	165	1	1	res_groups_privilege_category_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
292	99	165	1	1	res_groups_privilege_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
293	99	165	1	1	res_groups_privilege_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
294	102	165	1	1	res_groups_users_rel_gid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
295	100	165	1	1	res_groups_users_rel_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
296	100	165	1	1	res_groups_implied_rel_gid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
297	100	165	1	1	res_groups_implied_rel_hid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
298	100	165	1	1	res_groups_privilege_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
299	100	165	1	1	res_groups_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
300	100	165	1	1	res_groups_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
301	101	165	1	1	res_users_log_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
302	101	165	1	1	res_users_log_write_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
303	102	165	1	1	res_users_partner_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
304	102	165	1	1	res_users_company_id_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
305	102	165	1	1	res_users_create_uid_fkey	\N	f	{"en_US": null}	2026-02-19 14:17:42.822463	2026-02-19 14:17:42.822463
306	102	165	1	1	res_users_write_uid_fkey	\N	f	{"en